
module ol_vamp_3_ppllaj_eexbbxag_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllaj_eexbbxag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllaj_eexbbxag_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllaj_eexbbxag_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllaj_eexbbxag_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllaj_eexbbxag_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllaj_eexbbxag_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call ol_merge_tensors(T0sum(61),[G0tensor(157)])
  call ol_merge_tensors(T0sum(62),[G0tensor(21)])
  call ol_merge_tensors(T0sum(63),[G0tensor(166)])
  call ol_merge_tensors(T0sum(64),[G0tensor(46)])
  call ol_merge_tensors(T0sum(65),[G0tensor(122)])
  call ol_merge_tensors(T0sum(66),[G0tensor(91)])
  call ol_merge_tensors(T0sum(67),[G0tensor(14)])
  call ol_merge_tensors(T0sum(68),[G0tensor(96)])
  call ol_merge_tensors(T0sum(69),[G0tensor(27)])
  call ol_merge_tensors(T0sum(70),[G0tensor(134)])
  call ol_merge_tensors(T0sum(71),[G0tensor(139)])
  call ol_merge_tensors(T0sum(72),[G0tensor(52)])
  call ol_merge_tensors(T0sum(73),[G0tensor(54)])
  call ol_merge_tensors(T0sum(74),[G0tensor(179)])
  call ol_merge_tensors(T0sum(75),[G0tensor(13)])
  call ol_merge_tensors(T0sum(76),[G0tensor(18)])
  call ol_merge_tensors(T0sum(77),[G0tensor(189)])
  call ol_merge_tensors(T0sum(78),[G0tensor(204)])
  call ol_merge_tensors(T0sum(79),[G0tensor(39)])
  call ol_merge_tensors(T0sum(80),[G0tensor(106)])
  call ol_merge_tensors(T0sum(81),[G0tensor(102)])
  call ol_merge_tensors(T0sum(82),[G0tensor(33)])
  call ol_merge_tensors(T0sum(83),[G0tensor(47)])
  call ol_merge_tensors(T0sum(84),[G0tensor(58)])
  call ol_merge_tensors(T0sum(85),[G0tensor(206)])
  call ol_merge_tensors(T0sum(86),[G0tensor(77)])
  call ol_merge_tensors(T0sum(87),[G0tensor(88)])
  call ol_merge_tensors(T0sum(88),[G0tensor(108)])
  call ol_merge_tensors(T0sum(89),[G0tensor(133)])
  call ol_merge_tensors(T0sum(90),[G0tensor(178)])
  call ol_merge_tensors(T0sum(91),[G0tensor(143)])
  call ol_merge_tensors(T0sum(92),[G0tensor(183)])
  call ol_merge_tensors(T0sum(93),[G0tensor(193)])
  call ol_merge_tensors(T0sum(94),[G0tensor(212)])
  call ol_merge_tensors(T0sum(95),[G0tensor(217)])
  call ol_merge_tensors(T0sum(96),[G0tensor(222)])
  call ol_merge_tensors(T0sum(97),[G0tensor(226)])
  call ol_merge_tensors(T0sum(98),[G0tensor(231)])
  call ol_merge_tensors(T0sum(99),[G0tensor(236)])
  call ol_merge_tensors(T0sum(100),[G0tensor(241)])
  call ol_merge_tensors(T0sum(101),[G0tensor(246)])
  call ol_merge_tensors(T0sum(102),[G0tensor(251)])
  call ol_merge_tensors(T0sum(103),[G0tensor(256)])
  call ol_merge_tensors(T0sum(104),[G0tensor(261)])
  call ol_merge_tensors(T0sum(105),[G0tensor(266)])
  call ol_merge_tensors(T0sum(106),[G0tensor(271)])
  call ol_merge_tensors(T0sum(107),[G0tensor(276)])
  call ol_merge_tensors(T0sum(108),[G0tensor(281)])
  call ol_merge_tensors(T0sum(109),[G0tensor(286)])
  call ol_merge_tensors(T1sum(9),[G1tensor(172)])
  call ol_merge_tensors(T1sum(10),[G1tensor(204)])
  call ol_merge_tensors(T1sum(11),[G1tensor(194)])
  call ol_merge_tensors(T1sum(12),[G1tensor(175)])
  call ol_merge_tensors(T1sum(13),[G1tensor(176)])
  call ol_merge_tensors(T1sum(14),[G1tensor(196)])
  call ol_merge_tensors(T1sum(15),[G1tensor(186)])
  call ol_merge_tensors(T1sum(16),[G1tensor(179)])
  call ol_merge_tensors(T1sum(17),[G1tensor(180)])
  call ol_merge_tensors(T1sum(18),[G1tensor(200)])
  call ol_merge_tensors(T1sum(19),[G1tensor(190)])
  call ol_merge_tensors(T1sum(20),[G1tensor(183)])
  call ol_merge_tensors(T1sum(21),[G1tensor(184)])
  call ol_merge_tensors(T1sum(22),[G1tensor(185)])
  call ol_merge_tensors(T1sum(23),[G1tensor(199)])
  call ol_merge_tensors(T1sum(24),[G1tensor(188)])
  call ol_merge_tensors(T1sum(25),[G1tensor(189)])
  call ol_merge_tensors(T1sum(26),[G1tensor(203)])
  call ol_merge_tensors(T1sum(27),[G1tensor(192)])
  call ol_merge_tensors(T1sum(28),[G1tensor(193)])
  call ol_merge_tensors(T1sum(29),[G1tensor(207)])
  call ol_merge_tensors(T1sum(30),[G1tensor(197)])
  call ol_merge_tensors(T1sum(31),[G1tensor(198)])
  call ol_merge_tensors(T1sum(32),[G1tensor(201)])
  call ol_merge_tensors(T1sum(33),[G1tensor(202)])
  call ol_merge_tensors(T1sum(34),[G1tensor(205)])
  call ol_merge_tensors(T1sum(35),[G1tensor(206)])
  call ol_merge_tensors(T0sum(110),[G0tensor(291)])
  call ol_merge_tensors(T0sum(111),[G0tensor(296)])
  call ol_merge_tensors(T0sum(112),[G0tensor(300)])
  call ol_merge_tensors(T0sum(113),[G0tensor(305)])
  call ol_merge_tensors(T0sum(114),[G0tensor(309)])
  call ol_merge_tensors(T0sum(115),[G0tensor(314)])
  call ol_merge_tensors(T0sum(116),[G0tensor(318)])
  call ol_merge_tensors(T0sum(117),[G0tensor(322)])
  call ol_merge_tensors(T0sum(118),[G0tensor(327)])
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[40,23],[0,nMB],2,2,wf4(:,5),wf16(:,19))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,277))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[40,23],[0,nMB],2,2,wf4(:,5),wf16(:,20))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(2),m3h4x16(:,26),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[43,20],[nMB,0],2,2,wf16(:,16),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,16),G0H4(5),m3h16x4(:,9),heltab2x64(:,:,279))
  call Hloop_A_Q(ntryL,G0H4(5),43,nMB,G1H4(49),n2h4(85))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[43,20],[nMB,0],2,2,wf16(:,18),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,18),G0H4(2),m3h16x4(:,10),heltab2x64(:,:,280))
  call Hloop_A_Q(ntryL,G0H4(2),43,nMB,G1H4(5),n2h4(86))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[52,11],[nMB,0],2,2,wf8(:,31),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,31),G0H8(17),m3h8x8(:,9),heltab2x64(:,:,281))
  call Hloop_Q_A(ntryL,G0H8(17),52,nMB,G1H8(32),n2h8(207))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[52,11],[nMB,0],2,2,wf8(:,31),wf8(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,31),G0H8(18),m3h8x8(:,10),heltab2x64(:,:,282))
  call Hloop_Q_A(ntryL,G0H8(18),52,nMB,G1H8(37),n2h8(208))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[43,20],[nMB,0],2,2,wf16(:,44),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,44),G0H4(1),m3h16x4(:,11),heltab2x64(:,:,283))
  call Hloop_A_Q(ntryL,G0H4(1),43,nMB,G1H4(6),n2h4(87))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[43,20],[nMB,0],2,2,wf16(:,46),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,46),G0H4(7),m3h16x4(:,12),heltab2x64(:,:,284))
  call Hloop_A_Q(ntryL,G0H4(7),43,nMB,G1H4(52),n2h4(88))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[39,24],[nMB,0],2,2,wf16(:,25),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,25),G0H4(4),m3h16x4(:,13),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(4),39,nMB,G1H4(53),n2h4(89))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[39,24],[nMB,0],2,2,wf16(:,26),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,26),G0H4(3),m3h16x4(:,14),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G0H4(3),39,nMB,G1H4(54),n2h4(90))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,22))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(3),m3h4x16(:,27),heltab2x64(:,:,287))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,24))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(4),m3h4x16(:,28),heltab2x64(:,:,288))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[39,24],[nMB,0],2,2,wf16(:,34),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,34),G0H4(6),m3h16x4(:,15),heltab2x64(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(6),39,nMB,G1H4(57),n2h4(91))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[39,24],[nMB,0],2,2,wf16(:,36),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,36),G0H4(8),m3h16x4(:,16),heltab2x64(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(8),39,nMB,G1H4(58),n2h4(92))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[56,7],[nMB,0],2,2,wf8(:,37),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(19),m3h8x8(:,11),heltab2x64(:,:,291))
  call Hloop_A_Q(ntryL,G0H8(19),56,nMB,G1H8(42),n2h8(209))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[56,7],[nMB,0],2,2,wf8(:,37),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,37),G0H8(20),m3h8x8(:,12),heltab2x64(:,:,292))
  call Hloop_A_Q(ntryL,G0H8(20),56,nMB,G1H8(48),n2h8(210))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[52,11],[nMB,0],2,2,wf8(:,33),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(21),m3h8x8(:,13),heltab2x64(:,:,293))
  call Hloop_Q_A(ntryL,G0H8(21),52,nMB,G1H8(58),n2h8(211))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[52,11],[nMB,0],2,2,wf8(:,33),wf8(:,5))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(22),m3h8x8(:,14),heltab2x64(:,:,294))
  call Hloop_Q_A(ntryL,G0H8(22),52,nMB,G1H8(59),n2h8(212))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,40))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(5),m3h4x16(:,29),heltab2x64(:,:,295))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,42))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(6),m3h4x16(:,30),heltab2x64(:,:,296))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[40,23],[0,nMB],2,2,wf4(:,5),wf16(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(7),m3h4x16(:,31),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[40,23],[0,nMB],2,2,wf4(:,5),wf16(:,32))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(8),m3h4x16(:,32),heltab2x64(:,:,298))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[56,7],[nMB,0],2,2,wf8(:,39),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,39),G0H8(23),m3h8x8(:,15),heltab2x64(:,:,299))
  call Hloop_A_Q(ntryL,G0H8(23),56,nMB,G1H8(3),n2h8(213))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[56,7],[nMB,0],2,2,wf8(:,39),wf8(:,10))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,39),G0H8(24),m3h8x8(:,16),heltab2x64(:,:,300))
  call Hloop_A_Q(ntryL,G0H8(24),56,nMB,G1H8(9),n2h8(214))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,52))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(9),m3h4x16(:,33),heltab2x64(:,:,301))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,54))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(10),m3h4x16(:,34),heltab2x64(:,:,302))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[40,23],[nMB,0],2,2,wf4(:,5),wf16(:,48))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,35),heltab2x64(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(11),40,nMB,G1H16(46),n2h16(53))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[40,23],[nMB,0],2,2,wf4(:,5),wf16(:,50))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,36),heltab2x64(:,:,304))
  call Hloop_A_Q(ntryL,G0H16(12),40,nMB,G1H16(47),n2h16(54))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,60))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(11),m3h4x16(:,37),heltab2x64(:,:,305))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[36,27],[0,nMB],2,2,wf4(:,10),wf16(:,62))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(12),m3h4x16(:,38),heltab2x64(:,:,306))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[40,23],[nMB,0],2,2,wf4(:,5),wf16(:,56))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,39),heltab2x64(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(13),40,nMB,G1H16(49),n2h16(55))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[40,23],[nMB,0],2,2,wf4(:,5),wf16(:,58))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(13),m3h4x16(:,40),heltab2x64(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(13),40,nMB,G1H16(50),n2h16(56))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(6),G1H4(5),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(57),G1H4(54),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(48)])
  call Hloop_VQ_A(ntryL,G0H16(1),wf16(:,19),G0H1(1),m3h16x1(:,33),heltab2x16(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(1),n2h1(368))
  call Hloop_VQ_A(ntryL,G0H16(2),wf16(:,20),G0H1(1),m3h16x1(:,34),heltab2x16(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(31),n2h1(369))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(52),wf4(:,4),G1tensor(14),m3h4x1(:,111),heltab2x4(:,:,161))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(58),wf8(:,3),G1tensor(26),m3h8x1(:,81),heltab2x8(:,:,321))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(59),wf8(:,5),G1tensor(42),m3h8x1(:,82),heltab2x8(:,:,322))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(58),wf4(:,11),G1tensor(4),m3h4x1(:,112),heltab2x4(:,:,162))
  call Hloop_VA_Q(ntryL,G0H16(3),wf16(:,22),G0H1(1),m3h16x1(:,35),heltab2x16(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(10),n2h1(370))
  call Hloop_VA_Q(ntryL,G0H16(4),wf16(:,24),G0H1(1),m3h16x1(:,36),heltab2x16(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(22),n2h1(371))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(3),wf8(:,8),G1tensor(29),m3h8x1(:,83),heltab2x8(:,:,323))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,10),G1tensor(39),m3h8x1(:,84),heltab2x8(:,:,324))
  call Hloop_VA_Q(ntryL,G0H16(5),wf16(:,40),G0H1(1),m3h16x1(:,37),heltab2x16(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(51),n2h1(372))
  call Hloop_VA_Q(ntryL,G0H16(6),wf16(:,42),G0H1(1),m3h16x1(:,38),heltab2x16(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(56),n2h1(373))
  call Hloop_VQ_A(ntryL,G0H16(7),wf16(:,30),G0H1(1),m3h16x1(:,39),heltab2x16(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(61),n2h1(374))
  call Hloop_VQ_A(ntryL,G0H16(8),wf16(:,32),G0H1(1),m3h16x1(:,40),heltab2x16(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(66),n2h1(375))
  call Hloop_VA_Q(ntryL,G0H16(9),wf16(:,52),G0H1(1),m3h16x1(:,41),heltab2x16(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(71),n2h1(376))
  call Hloop_VA_Q(ntryL,G0H16(10),wf16(:,54),G0H1(1),m3h16x1(:,42),heltab2x16(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(76),n2h1(377))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H16(46),wf16(:,48),G1tensor(81),m3h16x1(:,43),heltab2x16(:,:,151))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H16(47),wf16(:,50),G1tensor(86),m3h16x1(:,44),heltab2x16(:,:,152))
  call Hloop_VA_Q(ntryL,G0H16(11),wf16(:,60),G0H1(1),m3h16x1(:,45),heltab2x16(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(91),n2h1(378))
  call Hloop_VA_Q(ntryL,G0H16(12),wf16(:,62),G0H1(1),m3h16x1(:,46),heltab2x16(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(96),n2h1(379))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H16(49),wf16(:,56),G1tensor(101),m3h16x1(:,47),heltab2x16(:,:,155))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H16(50),wf16(:,58),G1tensor(106),m3h16x1(:,48),heltab2x16(:,:,156))
  call ol_merge_tensors(G0tensor(238),[G0tensor(233),G0tensor(163),G0tensor(168),G0tensor(32),G0tensor(131),G0tensor(169) &
    ,G0tensor(87),G0tensor(9),G0tensor(90),G0tensor(40),G0tensor(15)])
  call ol_merge_tensors(G0tensor(288),[G0tensor(283),G0tensor(278),G0tensor(273),G0tensor(248),G0tensor(232),G0tensor(86) &
    ,G0tensor(186),G0tensor(42),G0tensor(195),G0tensor(4),G0tensor(20)])
  call ol_merge_tensors(G0tensor(234),[G0tensor(177),G0tensor(187),G0tensor(72),G0tensor(66),G0tensor(152),G0tensor(145) &
    ,G0tensor(25)])
  call ol_merge_tensors(G0tensor(295),[G0tensor(290),G0tensor(285),G0tensor(280),G0tensor(275),G0tensor(270),G0tensor(265) &
    ,G0tensor(260),G0tensor(255),G0tensor(250),G0tensor(245),G0tensor(240),G0tensor(235),G0tensor(167),G0tensor(148),G0tensor(138) &
    ,G0tensor(123),G0tensor(117),G0tensor(93),G0tensor(81),G0tensor(201),G0tensor(171),G0tensor(151),G0tensor(83),G0tensor(121) &
    ,G0tensor(104),G0tensor(89),G0tensor(63),G0tensor(164),G0tensor(154),G0tensor(29),G0tensor(149),G0tensor(109),G0tensor(11) &
    ,G0tensor(19),G0tensor(99),G0tensor(127),G0tensor(51),G0tensor(36),G0tensor(26),G0tensor(210),G0tensor(185),G0tensor(6) &
    ,G0tensor(1),G0tensor(155),G0tensor(130),G0tensor(105),G0tensor(80),G0tensor(55),G0tensor(30)])
  call ol_merge_tensors(G0tensor(243),[G0tensor(101),G0tensor(78),G0tensor(156),G0tensor(119),G0tensor(112),G0tensor(115) &
    ,G0tensor(45)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(26),G0tensor(118),G0tensor(73),G0tensor(144),G0tensor(61),G0tensor(50)])
  call ol_merge_tensors(G0tensor(211),[G0tensor(191),G0tensor(141),G0tensor(67),G0tensor(142),G0tensor(95),G0tensor(65)])
  call ol_merge_tensors(G0tensor(287),[G0tensor(258),G0tensor(253),G0tensor(153),G0tensor(128),G0tensor(22),G0tensor(71) &
    ,G0tensor(70)])
  call ol_merge_tensors(G0tensor(272),[G0tensor(173),G0tensor(126),G0tensor(79),G0tensor(97),G0tensor(200),G0tensor(125) &
    ,G0tensor(75)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(29),G0tensor(162),G0tensor(129),G0tensor(100)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(263),G0tensor(113),G0tensor(8),G0tensor(3),G0tensor(165),G0tensor(140) &
    ,G0tensor(120)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(61),G1tensor(31),G1tensor(1),G0tensor(249),G0tensor(242),G0tensor(239),G0tensor(64) &
    ,G0tensor(150)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(98),G0tensor(174),G0tensor(43),G0tensor(170)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(299),G0tensor(294),G0tensor(244),G0tensor(23),G0tensor(59),G0tensor(24) &
    ,G0tensor(12),G0tensor(53),G0tensor(175)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(159),G0tensor(56),G0tensor(107),G0tensor(5)])
  call ol_merge_tensors(G0tensor(247),[G0tensor(68),G0tensor(74),G0tensor(180)])
  call ol_merge_tensors(G0tensor(274),[G0tensor(264),G0tensor(254),G0tensor(124),G0tensor(57),G0tensor(82),G0tensor(205)])
  call ol_merge_tensors(G0tensor(279),[G0tensor(269),G0tensor(259),G0tensor(44),G0tensor(28),G0tensor(76),G0tensor(94) &
    ,G0tensor(136),G0tensor(41),G0tensor(31)])
  call ol_merge_tensors(G1tensor(96),[G1tensor(91),G1tensor(76),G1tensor(71),G1tensor(56),G1tensor(51),G1tensor(22),G1tensor(10) &
    ,G0tensor(284),G0tensor(137),G0tensor(37)])
  call ol_merge_tensors(G0tensor(289),[G0tensor(114),G0tensor(16)])
  call ol_merge_tensors(G1tensor(4),[G0tensor(262),G0tensor(103),G0tensor(84),G0tensor(62)])
  call ol_merge_tensors(G1tensor(14),[G0tensor(293),G0tensor(252),G0tensor(196),G0tensor(34)])
  call ol_merge_tensors(G1tensor(106),[G1tensor(101),G1tensor(86),G1tensor(81),G0tensor(257),G0tensor(192),G0tensor(111) &
    ,G0tensor(17)])
  call ol_merge_tensors(G0tensor(320),[G0tensor(316),G0tensor(306),G0tensor(215),G0tensor(198),G0tensor(182)])
  call ol_merge_tensors(G0tensor(319),[G0tensor(225),G0tensor(116)])
  call ol_merge_tensors(G0tensor(329),[G0tensor(324),G0tensor(310),G0tensor(219),G0tensor(197),G0tensor(194)])
  call ol_merge_tensors(G0tensor(328),[G0tensor(229),G0tensor(209)])
  call ol_merge_tensors(G0tensor(330),[G0tensor(303),G0tensor(176),G0tensor(199)])
  call ol_merge_tensors(G0tensor(331),[G0tensor(326),G0tensor(313),G0tensor(304),G0tensor(230),G0tensor(221),G0tensor(208) &
    ,G0tensor(69),G0tensor(214)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(213),G0tensor(188),G0tensor(184)])
  call ol_merge_tensors(G0tensor(317),[G0tensor(308),G0tensor(146)])
  call ol_merge_tensors(G0tensor(227),[G0tensor(218),G0tensor(202),G0tensor(161)])
  call ol_merge_tensors(G0tensor(325),[G0tensor(312),G0tensor(49)])
  call ol_merge_tensors(G0tensor(277),[G0tensor(172),G0tensor(158),G0tensor(132),G0tensor(48),G0tensor(181),G0tensor(92)])
  call ol_merge_tensors(G0tensor(292),[G0tensor(282),G0tensor(147),G0tensor(38)])
  call ol_merge_tensors(G0tensor(297),[G0tensor(216),G0tensor(203)])
  call ol_merge_tensors(G0tensor(301),[G0tensor(220),G0tensor(207)])
  call ol_merge_tensors(G0tensor(315),[G0tensor(307),G0tensor(298),G0tensor(224)])
  call ol_merge_tensors(G0tensor(323),[G0tensor(311),G0tensor(302),G0tensor(228)])
call TI_bubble_red(G1tensor(42),52,mass2set(:,1),G0tensor(10),M2L1R1,G0tensor(35))
call TI_bubble_red(G1tensor(39),56,mass2set(:,1),G0tensor(60),M2L1R1,G0tensor(85))
call TI_bubble_red(G1tensor(66),40,mass2set(:,2),G0tensor(110),M2L1R1,G0tensor(135))
call TI_bubble_red(G1tensor(96),36,mass2set(:,2),G0tensor(160),M2L1R1,G0tensor(2))
call TI_bubble_red(G1tensor(4),39,mass2set(:,1),G0tensor(7),M2L1R1,G0tensor(190))
call TI_bubble_red(G1tensor(14),43,mass2set(:,1),G0tensor(157),M2L1R1,G0tensor(21))
call TI_bubble_red(G1tensor(106),40,mass2set(:,1),G0tensor(166),M2L1R1,G0tensor(46))
  call ol_merge_tensors(G0tensor(46),[G0tensor(21),G0tensor(190),G0tensor(2),G0tensor(135),G0tensor(85),G0tensor(35) &
    ,G0tensor(295)])
  call ol_merge_tensors(T0sum(119),[G0tensor(238)])
  call ol_merge_tensors(T0sum(120),[G0tensor(288)])
  call ol_merge_tensors(T0sum(121),[G0tensor(234)])
  call ol_merge_tensors(T0sum(122),[G0tensor(46)])
  call ol_merge_tensors(T0sum(123),[G0tensor(243)])
  call ol_merge_tensors(T0sum(124),[G0tensor(10)])
  call ol_merge_tensors(T0sum(125),[G0tensor(211)])
  call ol_merge_tensors(T0sum(126),[G0tensor(287)])
  call ol_merge_tensors(T0sum(127),[G0tensor(272)])
  call ol_merge_tensors(T0sum(128),[G0tensor(60)])
  call ol_merge_tensors(T0sum(129),[G0tensor(268)])
  call ol_merge_tensors(T0sum(130),[G0tensor(110)])
  call ol_merge_tensors(T0sum(131),[G0tensor(267)])
  call ol_merge_tensors(T0sum(132),[G0tensor(321)])
  call ol_merge_tensors(T0sum(133),[G0tensor(237)])
  call ol_merge_tensors(T0sum(134),[G0tensor(247)])
  call ol_merge_tensors(T0sum(135),[G0tensor(274)])
  call ol_merge_tensors(T0sum(136),[G0tensor(279)])
  call ol_merge_tensors(T0sum(137),[G0tensor(160)])
  call ol_merge_tensors(T0sum(138),[G0tensor(289)])
  call ol_merge_tensors(T0sum(139),[G0tensor(7)])
  call ol_merge_tensors(T0sum(140),[G0tensor(157)])
  call ol_merge_tensors(T0sum(141),[G0tensor(166)])
  call ol_merge_tensors(T0sum(142),[G0tensor(320)])
  call ol_merge_tensors(T0sum(143),[G0tensor(319)])
  call ol_merge_tensors(T0sum(144),[G0tensor(329)])
  call ol_merge_tensors(T0sum(145),[G0tensor(328)])
  call ol_merge_tensors(T0sum(146),[G0tensor(330)])
  call ol_merge_tensors(T0sum(147),[G0tensor(331)])
  call ol_merge_tensors(T0sum(148),[G0tensor(223)])
  call ol_merge_tensors(T0sum(149),[G0tensor(317)])
  call ol_merge_tensors(T0sum(150),[G0tensor(227)])
  call ol_merge_tensors(T0sum(151),[G0tensor(325)])
  call ol_merge_tensors(T0sum(152),[G0tensor(277)])
  call ol_merge_tensors(T0sum(153),[G0tensor(292)])
  call ol_merge_tensors(T0sum(154),[G0tensor(297)])
  call ol_merge_tensors(T0sum(155),[G0tensor(301)])
  call ol_merge_tensors(T0sum(156),[G0tensor(315)])
  call ol_merge_tensors(T0sum(157),[G0tensor(323)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 36, 52, 55 ],masses2_19,RedSet_4(9),ScalarBoxes(1))
  call compute_scalar_box([ 32, 52, 55 ],masses2_15,RedSet_4(10),ScalarBoxes(2))
  call compute_scalar_box([ 32, 36, 55 ],masses2_15,RedSet_4(1),ScalarBoxes(3))
  call compute_scalar_box([ 32, 36, 52 ],masses2_15,RedSet_4(2),ScalarBoxes(4))
  call compute_scalar_box([ 4, 20, 23 ],masses2_19,RedSet_4(11),ScalarBoxes(5))
  call compute_scalar_box([ 36, 39, 55 ],masses2_19,RedSet_4(12),ScalarBoxes(6))
  call compute_scalar_box([ 32, 39, 55 ],masses2_15,RedSet_4(13),ScalarBoxes(7))
  call compute_scalar_box([ 32, 36, 39 ],masses2_15,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 4, 7, 23 ],masses2_19,RedSet_4(14),ScalarBoxes(9))
  call compute_scalar_box([ 35, 51, 55 ],masses2_18,RedSet_4(15),ScalarBoxes(10))
  call compute_scalar_box([ 32, 51, 55 ],masses2_18,RedSet_4(16),ScalarBoxes(11))
  call compute_scalar_box([ 32, 35, 55 ],masses2_18,RedSet_4(17),ScalarBoxes(12))
  call compute_scalar_box([ 32, 35, 51 ],masses2_20,RedSet_4(4),ScalarBoxes(13))
  call compute_scalar_box([ 3, 19, 23 ],masses2_18,RedSet_4(18),ScalarBoxes(14))
  call compute_scalar_box([ 35, 51, 59 ],masses2_18,RedSet_4(19),ScalarBoxes(15))
  call compute_scalar_box([ 32, 51, 59 ],masses2_18,RedSet_4(20),ScalarBoxes(16))
  call compute_scalar_box([ 32, 35, 59 ],masses2_18,RedSet_4(21),ScalarBoxes(17))
  call compute_scalar_box([ 3, 19, 27 ],masses2_18,RedSet_4(22),ScalarBoxes(18))
  call compute_scalar_box([ 35, 43, 47 ],masses2_17,RedSet_4(23),ScalarBoxes(19))
  call compute_scalar_box([ 32, 43, 47 ],masses2_17,RedSet_4(24),ScalarBoxes(20))
  call compute_scalar_box([ 32, 35, 47 ],masses2_20,RedSet_4(25),ScalarBoxes(21))
  call compute_scalar_box([ 32, 35, 43 ],masses2_18,RedSet_4(5),ScalarBoxes(22))
  call compute_scalar_box([ 3, 11, 15 ],masses2_17,RedSet_4(26),ScalarBoxes(23))
  call compute_scalar_box([ 36, 44, 47 ],masses2_16,RedSet_4(27),ScalarBoxes(24))
  call compute_scalar_box([ 32, 44, 47 ],masses2_20,RedSet_4(28),ScalarBoxes(25))
  call compute_scalar_box([ 32, 36, 47 ],masses2_17,RedSet_4(29),ScalarBoxes(26))
  call compute_scalar_box([ 32, 36, 44 ],masses2_17,RedSet_4(6),ScalarBoxes(27))
  call compute_scalar_box([ 4, 12, 15 ],masses2_16,RedSet_4(30),ScalarBoxes(28))
  call compute_scalar_box([ 35, 39, 47 ],masses2_17,RedSet_4(31),ScalarBoxes(29))
  call compute_scalar_box([ 32, 39, 47 ],masses2_17,RedSet_4(32),ScalarBoxes(30))
  call compute_scalar_box([ 32, 35, 39 ],masses2_18,RedSet_4(7),ScalarBoxes(31))
  call compute_scalar_box([ 3, 7, 15 ],masses2_17,RedSet_4(33),ScalarBoxes(32))
  call compute_scalar_box([ 40, 44, 47 ],masses2_16,RedSet_4(34),ScalarBoxes(33))
  call compute_scalar_box([ 32, 40, 47 ],masses2_17,RedSet_4(35),ScalarBoxes(34))
  call compute_scalar_box([ 32, 40, 44 ],masses2_17,RedSet_4(8),ScalarBoxes(35))
  call compute_scalar_box([ 8, 12, 15 ],masses2_16,RedSet_4(36),ScalarBoxes(36))
! end of process


end subroutine vamp_3

end module ol_vamp_3_ppllaj_eexbbxag_1_/**/REALKIND
