
module ol_vamp_1_ppllaj_eexuuxag_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllaj_eexuuxag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllaj_eexuuxag_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllaj_eexuuxag_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllaj_eexuuxag_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllaj_eexuuxag_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllaj_eexuuxag_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(7))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(8),n2h32(8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(9))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(10),n2h32(10))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(11))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,12),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(12),n2h32(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(2),n2h8(2))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,1),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(3),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H32(4),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(4),n2h8(4))
  call Hloop_QV_A(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(5),n2h8(5))
  call Hloop_QZ_A(ntryL,G1H32(6),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),35,0,G2H8(6),n2h8(6))
  call Hloop_AQ_V(ntryL,G1H32(7),ex3(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,7))
  call Hloop_AQ_V(ntryL,G1H32(8),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,8))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,1),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(10),wf4(:,7),G1H8(1),ngZu,m3h4x8(:,8),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(8),n2h8(8))
  call Hloop_QA_V(ntryL,G1H32(11),ex4(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,11))
  call Hloop_QA_V(ntryL,G1H32(12),ex4(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,12))
  call Hloop_VQ_A(ntryL,G1H32(13),ex3(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(1),n2h16(1))
  call Hloop_VQ_A(ntryL,G1H32(14),ex3(:),G1H16(5),m3h2x16(:,6),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(2),n2h16(2))
  call Hloop_VQ_A(ntryL,G1H32(15),ex3(:),G1H16(5),m3h2x16(:,7),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(3),n2h16(3))
  call Hloop_VQ_A(ntryL,G1H32(16),ex3(:),G1H16(5),m3h2x16(:,8),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(4),n2h16(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G2H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G2H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G2H8(7)])
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hloop_QA_V(ntryL,G2H8(4),ex4(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(2),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),4,8)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(13),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(13),44,0,G2H8(1),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(2),ex4(:),G1H8(13),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(13),44,0,G2H8(3),n2h8(10))
  call Hloop_AQ_V(ntryL,G2H8(8),ex3(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_VQ_A(ntryL,G1H16(3),ex3(:),G1H8(13),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(13),44,0,G2H8(5),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(4),ex3(:),G1H8(13),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(13),44,0,G2H8(7),n2h8(12))
  call Hotf_5pt_reduction(G2H16(1),RedSet_5(3),mass5set(:,1),  & 
G1H16(5),G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(6),16)
  call HG1shiftOLR(G1H16(1),8,16)
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(3),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),8,16)
  call Hotf_5pt_reduction(G2H16(3),RedSet_5(4),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),8,16)
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(4),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),8,16)
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(3),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-8,0,G2H8(2),n2h8(13))
  call Hloop_QA_V(ntryL,G2H8(2),ex4(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AV_Q(ntryL,G1H8(4),ex5(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(5),n2h4(2))
  call Hloop_AV_Q(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(6),n2h4(3))
  call Hloop_AV_Q(ntryL,G1H8(6),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(7),n2h4(4))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(8),n2h4(5))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-4,0,G2H8(4),n2h8(14))
  call Hloop_AQ_V(ntryL,G2H8(4),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QV_A(ntryL,G1H8(10),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(10),n2h4(6))
  call Hloop_QV_A(ntryL,G1H8(11),ex5(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(11),n2h4(7))
  call Hloop_QV_A(ntryL,G1H8(12),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(12),n2h4(8))
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(13),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(13),52,0,G2H8(6),n2h8(15))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QV_A(ntryL,G1H16(3),ex5(:),G1H8(2),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(2),52,0,G2H8(8),n2h8(16))
  call Hloop_QV_A(ntryL,G1H16(4),ex5(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(4),52,0,G2H8(2),n2h8(17))
  call Hloop_QV_A(ntryL,G1H16(6),ex5(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(5),52,0,G2H8(4),n2h8(18))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(6),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(6),52,0,G2H8(9),n2h8(19))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(8),ex4(:),G1H8(7),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QV_A(ntryL,G1H16(10),ex5(:),G1H8(8),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(8),52,0,G2H8(10),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(10),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(10),52,0,G2H8(11),n2h8(21))
  call Hloop_QV_A(ntryL,G1H16(12),ex5(:),G1H8(11),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(11),52,0,G2H8(12),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(13),n2h4(9))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(14),ex4(:),G1H8(12),m3h2x8(:,15),heltab2x16(:,:,16))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(14),n2h4(10))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(15),n2h4(11))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,1),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(16),n2h4(12))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(17),n2h4(13))
call HGT_raise_alpha_OLR(G1H16(20),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(20),ex4(:),G1H8(13),m3h2x8(:,16),heltab2x16(:,:,21))
  call Hloop_QZ_A(ntryL,G1H16(22),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(18),n2h4(14))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,7),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(19),n2h4(15))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,8),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(20),n2h4(16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(16)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(5),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(6),mass5set(:,1),  & 
G1H8(2),G1H8(4),G1H8(5),G1H8(6),G1H8(8),G1H8(10),8)
  call HG1shiftOLR(G1H8(4),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(6),mass5set(:,1),  & 
G1H8(11),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(7),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(8),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(8),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(7),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(11),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(12),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(3),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(1),mass4set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(2),mass4set(:,1),  & 
G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(43),11,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(3),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(1),mass4set(:,1),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),8)
  call HG1shiftOLR(G1H8(54),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(2),mass4set(:,1),  & 
G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(59),11,8)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(4),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(1),mass4set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(3),mass4set(:,1),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(25),24,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(18)])
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(7),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-16,0,G2H4(13),n2h4(17))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(9),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(10),n2h2(3))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(11),n2h2(4))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-16,0,G2H8(1),n2h8(23))
  call Hloop_QV_A(ntryL,G2H8(1),ex5(:),G2H4(15),m3h2x4(:,13),heltab2x8(:,:,14))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,1),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(12),n2h2(5))
  call Hloop_AV_Q(ntryL,G1H8(10),wf4(:,1),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(13),n2h2(6))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,4),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(14),n2h2(7))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-16,0,G2H8(3),n2h8(24))
  call Hloop_QV_A(ntryL,G2H8(3),ex5(:),G2H4(16),m3h2x4(:,14),heltab2x8(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,5),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(15),n2h2(8))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,6),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(16),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(17),n2h2(10))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,0,G2H4(1),n2h4(18))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(18),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(19),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(20),n2h2(12))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,1),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(21),n2h2(13))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-16,0,G2H8(5),n2h8(25))
  call Hloop_AV_Q(ntryL,G2H8(5),ex5(:),G2H4(2),m3h2x4(:,15),heltab2x8(:,:,22))
  call Hloop_QV_A(ntryL,G1H8(23),wf4(:,1),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(22),n2h2(14))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,1),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(23),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,10),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(24),n2h2(16))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,0,G2H8(7),n2h8(26))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(3),m3h2x4(:,16),heltab2x8(:,:,26))
  call Hloop_QZ_A(ntryL,G1H8(29),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,11),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(25),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H8(30),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,12),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(26),n2h2(18))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,1),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(27),n2h2(19))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(32),ex4(:),G1H4(17),m3h2x4(:,17),heltab2x8(:,:,30))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,1),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(28),n2h2(20))
  call Hloop_QV_A(ntryL,G1H8(42),wf4(:,1),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(29),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(38),ex4(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,33))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,1),G1H2(1),m3h4x2(:,16),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(30),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(43),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(43),ex4(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,35))
  call Hloop_QV_A(ntryL,G1H8(46),wf4(:,1),G1H2(1),m3h4x2(:,17),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(31),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H8(47),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,18),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(32),n2h2(24))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(48),ex4(:),G1H4(2),m3h2x4(:,20),heltab2x8(:,:,38))
  call Hloop_QZ_A(ntryL,G1H8(53),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,19),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(33),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,20),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(34),n2h2(26))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(54),ex4(:),G1H4(5),m3h2x4(:,21),heltab2x8(:,:,41))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,21),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(35),n2h2(27))
call HGT_raise_alpha_OLR(G1H8(59),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(59),ex4(:),G1H4(6),m3h2x4(:,22),heltab2x8(:,:,43))
  call Hloop_QZ_A(ntryL,G1H8(62),wf4(:,7),G1H2(1),ngZu,m3h4x2(:,22),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(36),n2h2(28))
  call Hloop_QV_A(ntryL,G1H4(13),ex5(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(37),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QV_A(ntryL,G1H4(19),ex5(:),G1H2(2),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(38),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(24),ex5(:),G1H2(2),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(2),55,0,G2H2(39),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(2),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QV_A(ntryL,G1H4(23),ex5(:),G1H2(3),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(40),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(25),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(3),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QV_A(ntryL,G1H4(28),ex5(:),G1H2(4),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(4),55,0,G2H2(41),n2h2(33))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(29)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),2)
  call HG1shiftOLR(G1H2(5),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,1),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(11),12,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(4),mass4set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
  call HG1shiftOLR(G1H2(22),12,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(5),mass5set(:,1),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
  call HG1shiftOLR(G1H2(27),16,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(5),mass4set(:,1),  & 
G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(33),20,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(6),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(6),mass4set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(44),19,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(7),mass5set(:,1),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),2)
  call HG1shiftOLR(G1H2(49),16,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(7),mass4set(:,1),  & 
G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(55),24,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(8),mass5set(:,1),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),16,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(8),mass4set(:,1),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),2)
  call HG1shiftOLR(G1H2(66),19,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(64)])
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(8),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(12),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(10))
  call Hloop_QV_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(33),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(16),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(18),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(20),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(49),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(22),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(54),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(24),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(26),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(28),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(4),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(13))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(2),n2h32(14))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(3),n2h32(15))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(4),n2h32(16))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(5),n2h32(17))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(6),n2h32(18))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(7),n2h32(19))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(8),n2h32(20))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(9),n2h32(21))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(10),n2h32(22))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(11),n2h32(23))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(12),n2h32(24))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(13),n2h32(25))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(14),n2h32(26))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,12,3,16],[0,0,0,0],4,2,wf4(:,16),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(15),n2h32(27))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(16),n2h32(28))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(17),n2h32(29))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(18),n2h32(30))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(19),n2h32(31))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(20),n2h32(32))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(21),n2h32(33))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(22),n2h32(34))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(23),n2h32(35))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(24),n2h32(36))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,3,12,16],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(25),n2h32(37))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(26),n2h32(38))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,3,12,16],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(27),n2h32(39))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(28),n2h32(40))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,3,12,16],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(29),n2h32(41))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(30),n2h32(42))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,12,16],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(31),n2h32(43))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(32),n2h32(44))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(33),n2h32(45))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(34),n2h32(46))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(35),n2h32(47))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(36),n2h32(48))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(37),n2h32(49))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,54),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(38),n2h32(50))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(39),n2h32(51))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(40),n2h32(52))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,3,16,12],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(41),n2h32(53))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(42),n2h32(54))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,3,16,12],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(43),n2h32(55))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,60),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(44),n2h32(56))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,3,16,12],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(45),n2h32(57))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(46),n2h32(58))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,3,16,12],[0,0,0,0],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(47),n2h32(59))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,64),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(48),n2h32(60))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,8,3,20],[0,0,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(51),n2h32(61))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,3,20,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(52),n2h32(62))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(53),n2h32(63))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,3,8,20],[0,0,0,0],4,2,wf4(:,7),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,70),heltab2x64(:,:,70))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(54),n2h32(64))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,4,3,24],[0,0,0,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(57),n2h32(65))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,3,24,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(58),n2h32(66))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(59),n2h32(67))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,3,4,24],[0,0,0,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,76),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(60),n2h32(68))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[36,3,16,8],[0,0,0,0],4,2,wf4(:,10),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,10),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(5),n2h16(9))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[36,3,16,8],[0,0,0,0],4,2,wf4(:,10),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,10),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(1),n2h16(10))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[36,8,3,16],[0,0,0,0],4,2,wf4(:,10),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[36,8,3,16],[0,0,0,0],4,2,wf4(:,10),wf4(:,7))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,10),G0H16(2),m3h4x16(:,4),heltab2x64(:,:,80))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[40,3,16,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,5),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(3),40,0,G1H16(3),n2h16(11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[40,3,16,4],[0,0,0,0],4,2,wf4(:,5),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,6),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(3),40,0,G1H16(4),n2h16(12))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[40,4,3,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(3),m3h4x16(:,7),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[40,4,3,16],[0,0,0,0],4,2,wf4(:,5),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,5),G0H16(4),m3h4x16(:,8),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,7,16,8],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(61),m3h2x32(:,77),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,7,16,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,78),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,7,8,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,79),heltab2x64(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(63),n2h32(69))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,7,8,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,88))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(64),n2h32(70))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,8,7,16],[0,0,0,0],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,89))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(65),n2h32(71))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,8,7,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(66),n2h32(72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,83),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,4,16,11],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,84),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(69),n2h32(73))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,11,4,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,94))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(70),n2h32(74))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(71),n2h32(75))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,4,11,16],[0,0,0,0],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,88),heltab2x64(:,:,96))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(72),n2h32(76))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,4,8,19],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(73),n2h32(77))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,4,8,19],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,90),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(74),n2h32(78))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,8,4,19],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(75),n2h32(79))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,8,4,19],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,92),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(76),n2h32(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,4,19,8],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(77),m3h2x32(:,93),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,4,19,8],[0,0,0,0],4,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,94),heltab2x64(:,:,102))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,8,19],[0,0,0,0],4,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,95),heltab2x64(:,:,103))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(79),n2h32(81))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,4,8,19],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,96),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(80),n2h32(82))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,8,4,19],[0,0,0,0],4,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(81),n2h32(83))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,8,4,19],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,98),heltab2x64(:,:,106))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(82),n2h32(84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,4,19,8],[0,0,0,0],4,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,99),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,4,19,8],[0,0,0,0],4,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,100),heltab2x64(:,:,108))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(1),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(7),[G1H32(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(21),[G1H32(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(23),[G1H32(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(37),[G1H32(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(39),[G1H32(35)])
  call Hloop_AV_Q(ntryL,G1H8(3),ex5(:),G1H4(7),m3h2x4(:,23),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(7),51,0,G2H4(6),n2h4(22))
  call Hloop_QV_A(ntryL,G1H8(9),ex5(:),G1H4(8),m3h2x4(:,24),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(8),51,0,G2H4(7),n2h4(23))
  call Hloop_QV_A(ntryL,G1H16(2),ex5(:),G1H8(35),m3h2x8(:,17),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(35),52,0,G2H8(6),n2h8(33))
  call Hloop_QV_A(ntryL,G1H16(9),ex5(:),G1H8(36),m3h2x8(:,18),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(36),52,0,G2H8(2),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(11),m3h4x4(:,9),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(11),39,0,G2H4(8),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,7),G1H4(12),ngZu,m3h4x4(:,10),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(12),39,0,G2H4(11),n2h4(25))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,16),G1H8(51),m3h4x8(:,9),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(51),44,0,G2H8(4),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,16),G1H8(52),m3h4x8(:,10),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(52),44,nMT,G2H8(9),n2h8(36))
  call Hloop_QV_A(ntryL,G1H32(7),wf4(:,16),G1H8(2),m3h4x8(:,11),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(2),44,0,G2H8(11),n2h8(37))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,16),G1H8(4),m3h4x8(:,12),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(4),44,nMT,G2H8(12),n2h8(38))
  call Hloop_AV_Q(ntryL,G1H32(6),wf4(:,16),G1H8(8),m3h4x8(:,13),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(8),44,nMB,G2H8(1),n2h8(39))
  call Hloop_QV_A(ntryL,G1H32(8),wf4(:,16),G1H8(10),m3h4x8(:,14),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(10),44,nMB,G2H8(3),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,16),G1H8(11),m3h4x8(:,15),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(11),44,0,G2H8(5),n2h8(41))
  call Hloop_AV_Q(ntryL,G1H32(10),wf4(:,16),G1H8(14),m3h4x8(:,16),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(14),44,nMT,G2H8(7),n2h8(42))
  call Hloop_QV_A(ntryL,G1H32(11),wf4(:,16),G1H8(17),m3h4x8(:,17),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(17),44,0,G2H8(13),n2h8(43))
  call Hloop_QV_A(ntryL,G1H32(12),wf4(:,16),G1H8(18),m3h4x8(:,18),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(18),44,nMT,G2H8(14),n2h8(44))
  call Hloop_AV_Q(ntryL,G1H32(13),wf4(:,16),G1H8(19),m3h4x8(:,19),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(19),44,0,G2H8(15),n2h8(45))
  call Hloop_AV_Q(ntryL,G1H32(14),wf4(:,16),G1H8(20),m3h4x8(:,20),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(20),44,nMB,G2H8(16),n2h8(46))
  call Hloop_QV_A(ntryL,G1H32(15),wf4(:,16),G1H8(23),m3h4x8(:,21),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(23),44,0,G2H8(17),n2h8(47))
  call Hloop_QV_A(ntryL,G1H32(16),wf4(:,16),G1H8(24),m3h4x8(:,22),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(24),44,nMB,G2H8(18),n2h8(48))
  call Hloop_AV_Q(ntryL,G1H32(21),wf4(:,1),G1H8(25),m3h4x8(:,23),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(19),n2h8(49))
  call Hloop_AV_Q(ntryL,G1H32(18),wf4(:,1),G1H8(26),m3h4x8(:,24),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(26),35,nMT,G2H8(20),n2h8(50))
  call Hloop_QV_A(ntryL,G1H32(23),wf4(:,1),G1H8(29),m3h4x8(:,25),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(29),35,0,G2H8(21),n2h8(51))
  call Hloop_QV_A(ntryL,G1H32(20),wf4(:,1),G1H8(30),m3h4x8(:,26),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(30),35,nMT,G2H8(22),n2h8(52))
  call Hloop_AV_Q(ntryL,G1H32(22),wf4(:,1),G1H8(31),m3h4x8(:,27),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(31),35,nMB,G2H8(23),n2h8(53))
  call Hloop_QV_A(ntryL,G1H32(24),wf4(:,1),G1H8(32),m3h4x8(:,28),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(32),35,nMB,G2H8(24),n2h8(54))
  call Hloop_AZ_Q(ntryL,G1H32(25),wf4(:,7),G1H8(37),ngZu,m3h4x8(:,29),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(37),35,0,G2H8(25),n2h8(55))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf4(:,7),G1H8(42),ngZu,m3h4x8(:,30),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(42),35,nMT,G2H8(26),n2h8(56))
  call Hloop_QZ_A(ntryL,G1H32(27),wf4(:,7),G1H8(38),ngZu,m3h4x8(:,31),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(38),35,0,G2H8(27),n2h8(57))
  call Hloop_QZ_A(ntryL,G1H32(28),wf4(:,7),G1H8(41),ngZu,m3h4x8(:,32),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(41),35,nMT,G2H8(28),n2h8(58))
  call Hloop_AZ_Q(ntryL,G1H32(29),wf4(:,7),G1H8(43),ngZd,m3h4x8(:,33),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(43),35,0,G2H8(29),n2h8(59))
  call Hloop_AZ_Q(ntryL,G1H32(30),wf4(:,7),G1H8(46),ngZd,m3h4x8(:,34),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(46),35,nMB,G2H8(30),n2h8(60))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,7),G1H8(47),ngZd,m3h4x8(:,35),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(47),35,0,G2H8(31),n2h8(61))
  call Hloop_QZ_A(ntryL,G1H32(32),wf4(:,7),G1H8(48),ngZd,m3h4x8(:,36),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(48),35,nMB,G2H8(32),n2h8(62))
  call Hloop_QV_A(ntryL,G1H32(37),wf4(:,1),G1H8(53),m3h4x8(:,37),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(53),35,0,G2H8(33),n2h8(63))
  call Hloop_QV_A(ntryL,G1H32(34),wf4(:,1),G1H8(58),m3h4x8(:,38),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(58),35,nMT,G2H8(34),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H32(39),wf4(:,1),G1H8(54),m3h4x8(:,39),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(54),35,0,G2H8(35),n2h8(65))
  call Hloop_AV_Q(ntryL,G1H32(36),wf4(:,1),G1H8(57),m3h4x8(:,40),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(57),35,nMT,G2H8(36),n2h8(66))
  call Hloop_QV_A(ntryL,G1H32(38),wf4(:,1),G1H8(59),m3h4x8(:,41),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(59),35,nMB,G2H8(37),n2h8(67))
  call Hloop_AV_Q(ntryL,G1H32(40),wf4(:,1),G1H8(62),m3h4x8(:,42),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(62),35,nMB,G2H8(38),n2h8(68))
  call Hloop_QZ_A(ntryL,G1H32(41),wf4(:,7),G1H8(3),ngZu,m3h4x8(:,43),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(3),35,0,G2H8(39),n2h8(69))
  call Hloop_QZ_A(ntryL,G1H32(42),wf4(:,7),G1H8(9),ngZu,m3h4x8(:,44),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(9),35,nMT,G2H8(40),n2h8(70))
  call Hloop_AZ_Q(ntryL,G1H32(43),wf4(:,7),G1H8(35),ngZu,m3h4x8(:,45),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(35),35,0,G2H8(41),n2h8(71))
  call Hloop_AZ_Q(ntryL,G1H32(44),wf4(:,7),G1H8(36),ngZu,m3h4x8(:,46),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(36),35,nMT,G2H8(42),n2h8(72))
  call Hloop_QZ_A(ntryL,G1H32(45),wf4(:,7),G1H8(51),ngZd,m3h4x8(:,47),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(51),35,0,G2H8(43),n2h8(73))
  call Hloop_QZ_A(ntryL,G1H32(46),wf4(:,7),G1H8(52),ngZd,m3h4x8(:,48),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(52),35,nMB,G2H8(44),n2h8(74))
  call Hloop_AZ_Q(ntryL,G1H32(47),wf4(:,7),G1H8(2),ngZd,m3h4x8(:,49),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(45),n2h8(75))
  call Hloop_AZ_Q(ntryL,G1H32(48),wf4(:,7),G1H8(4),ngZd,m3h4x8(:,50),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(4),35,nMB,G2H8(46),n2h8(76))
  call Hloop_VA_Q(ntryL,G1H32(49),ex4(:),G1H16(6),m3h2x16(:,9),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G1H16(6),40,0,G2H16(1),n2h16(13))
  call Hloop_VA_Q(ntryL,G1H32(50),ex4(:),G1H16(7),m3h2x16(:,10),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H16(7),40,0,G2H16(2),n2h16(14))
  call Hloop_AV_Q(ntryL,G1H32(51),wf4(:,1),G1H8(8),m3h4x8(:,51),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(47),n2h8(77))
  call Hloop_AZ_Q(ntryL,G1H32(52),wf4(:,7),G1H8(10),ngZu,m3h4x8(:,52),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(10),35,0,G2H8(48),n2h8(78))
  call Hloop_QV_A(ntryL,G1H32(53),wf4(:,1),G1H8(11),m3h4x8(:,53),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(11),35,0,G2H8(49),n2h8(79))
  call Hloop_QZ_A(ntryL,G1H32(54),wf4(:,7),G1H8(14),ngZu,m3h4x8(:,54),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(14),35,0,G2H8(50),n2h8(80))
  call Hloop_VQ_A(ntryL,G1H32(55),ex3(:),G1H16(8),m3h2x16(:,11),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H16(8),36,0,G2H16(3),n2h16(15))
  call Hloop_VQ_A(ntryL,G1H32(56),ex3(:),G1H16(10),m3h2x16(:,12),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G1H16(10),36,0,G2H16(4),n2h16(16))
  call Hloop_QV_A(ntryL,G1H32(57),wf4(:,1),G1H8(17),m3h4x8(:,55),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(17),35,0,G2H8(51),n2h8(81))
  call Hloop_QZ_A(ntryL,G1H32(58),wf4(:,7),G1H8(18),ngZu,m3h4x8(:,56),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(18),35,0,G2H8(52),n2h8(82))
  call Hloop_AV_Q(ntryL,G1H32(59),wf4(:,1),G1H8(19),m3h4x8(:,57),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(19),35,0,G2H8(53),n2h8(83))
  call Hloop_AZ_Q(ntryL,G1H32(60),wf4(:,7),G1H8(20),ngZu,m3h4x8(:,58),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(20),35,0,G2H8(54),n2h8(84))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(23),n2h8(85))
  call Hloop_VA_Q(ntryL,G0H16(2),ex4(:),G0H8(1),m3h2x8(:,20),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(1),44,0,G1H8(24),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(13),m3h4x4(:,11),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(13),43,0,G2H4(12),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,7),G1H4(14),ngZu,m3h4x4(:,12),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(14),43,0,G2H4(17),n2h4(27))
  call Hloop_VQ_A(ntryL,G0H16(3),ex3(:),G0H8(1),m3h2x8(:,21),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(1),44,0,G1H8(25),n2h8(87))
  call Hloop_VQ_A(ntryL,G0H16(4),ex3(:),G0H8(1),m3h2x8(:,22),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G0H8(1),44,0,G1H8(26),n2h8(88))
  call Hloop_VQ_A(ntryL,G1H32(61),wf8(:,8),G1H4(19),m3h8x4(:,1),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(19),39,0,G2H4(19),n2h4(28))
  call Hloop_VQ_A(ntryL,G1H32(62),wf8(:,10),G1H4(24),m3h8x4(:,2),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(24),39,0,G2H4(20),n2h4(29))
  call Hloop_AQ_V(ntryL,G1H32(63),wf8(:,8),G1H4(20),m3h8x4(:,3),heltab2x32(:,:,73))
  call Hloop_AQ_V(ntryL,G1H32(64),wf8(:,10),G1H4(23),m3h8x4(:,4),heltab2x32(:,:,74))
  call Hloop_QA_V(ntryL,G1H32(65),ex4(:),G1H16(11),m3h2x16(:,13),heltab2x32(:,:,75))
  call Hloop_QA_V(ntryL,G1H32(66),ex4(:),G1H16(12),m3h2x16(:,14),heltab2x32(:,:,76))
  call Hloop_VQ_A(ntryL,G1H32(67),ex3(:),G1H16(13),m3h2x16(:,15),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(13),36,0,G2H16(5),n2h16(17))
  call Hloop_VQ_A(ntryL,G1H32(68),ex3(:),G1H16(14),m3h2x16(:,16),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(14),36,0,G2H16(6),n2h16(18))
  call Hloop_QA_V(ntryL,G1H32(69),wf8(:,3),G1H4(25),m3h8x4(:,5),heltab2x32(:,:,79))
  call Hloop_QA_V(ntryL,G1H32(70),wf8(:,5),G1H4(28),m3h8x4(:,6),heltab2x32(:,:,80))
  call Hloop_AQ_V(ntryL,G1H32(71),ex3(:),G1H16(16),m3h2x16(:,17),heltab2x32(:,:,81))
  call Hloop_AQ_V(ntryL,G1H32(72),ex3(:),G1H16(17),m3h2x16(:,18),heltab2x32(:,:,82))
  call Hloop_AQ_V(ntryL,G1H32(73),ex3(:),G1H16(18),m3h2x16(:,19),heltab2x32(:,:,83))
  call Hloop_AQ_V(ntryL,G1H32(74),ex3(:),G1H16(19),m3h2x16(:,20),heltab2x32(:,:,84))
  call Hloop_QA_V(ntryL,G1H32(75),ex4(:),G1H16(20),m3h2x16(:,21),heltab2x32(:,:,85))
  call Hloop_QA_V(ntryL,G1H32(76),ex4(:),G1H16(22),m3h2x16(:,22),heltab2x32(:,:,86))
  call Hloop_VQ_A(ntryL,G1H32(77),ex3(:),G1H16(23),m3h2x16(:,23),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H16(23),36,0,G2H16(7),n2h16(19))
  call Hloop_VQ_A(ntryL,G1H32(78),ex3(:),G1H16(24),m3h2x16(:,24),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H16(24),36,0,G2H16(8),n2h16(20))
  call Hloop_AQ_V(ntryL,G1H32(79),ex3(:),G1H16(15),m3h2x16(:,25),heltab2x32(:,:,89))
  call Hloop_AQ_V(ntryL,G1H32(80),ex3(:),G1H16(21),m3h2x16(:,26),heltab2x32(:,:,90))
  call Hloop_QA_V(ntryL,G1H32(81),ex4(:),G1H16(2),m3h2x16(:,27),heltab2x32(:,:,91))
  call Hloop_QA_V(ntryL,G1H32(82),ex4(:),G1H16(9),m3h2x16(:,28),heltab2x32(:,:,92))
  call Hloop_VQ_A(ntryL,G1H32(83),ex3(:),G1H16(5),m3h2x16(:,29),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H16(5),36,0,G2H16(9),n2h16(21))
  call Hloop_VQ_A(ntryL,G1H32(84),ex3(:),G1H16(1),m3h2x16(:,30),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H16(1),36,0,G2H16(10),n2h16(22))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(12)])
call HGT_lower_alpha_w2_OLR(G2H4(4),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(4),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(4),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(8),G1H4(15)])
call HGT_lower_alpha_w2_OLR(G2H4(9),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(9),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(9),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(21)])
call HGT_w2_OLR(G1H8(12),1,1,8)
call HGT_w2_invQ_OLR(G1H8(12),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(19),G2H4(18),G2H4(14),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(27)])
call HGT_w2_OLR(G1H8(13),1,1,8)
call HGT_w2_invQ_OLR(G1H8(13),2,5,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(25),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(20),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(25),G2H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G2H8(27),G2H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G2H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G2H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G2H8(39),G2H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G2H8(41),G2H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G2H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G2H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G2H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G2H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G2H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G2H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G2H8(53)])
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(37),mass4set(:,1),  & 
G1H4(7),G1H4(8),G1H4(11),G1H4(12),G1H4(13),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_AQ_V(ntryL,G2H4(5),ex3(:),G2H2(11),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(12),mass4set(:,1),  & 
G1H4(14),G1H4(19),G1H4(24),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(19),8,4)
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(13),m3h2x2(:,24),heltab2x4(:,:,24))
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_QV_A(ntryL,G1H8(1),ex5(:),G1H4(25),m3h2x4(:,25),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(25),60,0,G2H4(13),n2h4(30))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(10),mass4set(:,1),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(37),8)
  call HG1shiftOLR(G1H8(30),8,8)
call HGT_w2_OLR(G1H8(7),1,1,8)
call HGT_w2_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(4),m3h2x4(:,26),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(4),60,0,G2H4(1),n2h4(31))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(10),mass4set(:,1),  & 
G1H8(42),G1H8(38),G1H8(41),G1H8(43),G1H8(46),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,1),G1H2(9),m3h4x2(:,23),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(21),n2h2(34))
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(13),mass4set(:,1),  & 
G1H4(20),G1H4(10),G1H4(25),G1H4(4),G1H4(29),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,7),G1H2(20),ngZu,m3h4x2(:,24),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(23),n2h2(35))
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(31),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(27),n2h2(36))
  call Hloop_VQ_A(ntryL,G1H4(28),ex3(:),G1H2(42),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(42),47,0,G2H2(29),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,1),G1H2(53),m3h4x2(:,25),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(53),47,0,G2H2(1),n2h2(38))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(28),mass4set(:,1),  & 
G1H8(47),G1H8(48),G1H8(53),G1H8(58),G1H8(54),G0H8(1),8)
  call HG1shiftOLR(G1H8(48),16,8)
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,7),G1H2(64),ngZu,m3h4x2(:,26),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(64),47,0,G2H2(3),n2h2(39))
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(28),mass4set(:,1),  & 
G1H8(57),G1H8(59),G1H8(62),G1H8(3),G1H8(9),G0H8(2),8)
  call HG1shiftOLR(G1H8(59),16,8)
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(4),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(4),n2h2(40))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(5),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(6),n2h2(41))
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(28),mass4set(:,1),  & 
G1H8(35),G1H8(36),G1H8(51),G1H8(52),G1H8(2),G0H8(3),8)
  call HG1shiftOLR(G1H8(36),16,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(28),mass4set(:,1),  & 
G1H8(4),G1H8(8),G1H8(10),G1H8(11),G1H8(14),G0H8(4),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(9),mass4set(:,1),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(34),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,1),G1H2(10),m3h4x2(:,27),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(10),55,0,G2H2(7),n2h2(42))
  call Hloop_QV_A(ntryL,G1H8(40),wf4(:,1),G1H2(11),m3h4x2(:,28),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(10),n2h2(43))
  call Hloop_QV_A(ntryL,G1H8(44),wf4(:,1),G1H2(15),m3h4x2(:,29),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(15),55,0,G2H2(14),n2h2(44))
  call Hloop_QV_A(ntryL,G1H8(45),wf4(:,1),G1H2(16),m3h4x2(:,30),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(16),55,0,G2H2(16),n2h2(45))
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(9),mass4set(:,1),  & 
G1H8(50),G1H8(21),G1H8(25),G1H8(27),G1H8(26),8)
  call HG1shiftOLR(G1H8(21),8,8)
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,7),G1H2(21),ngZu,m3h4x2(:,31),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(21),55,0,G2H2(17),n2h2(46))
  call Hloop_QZ_A(ntryL,G1H8(56),wf4(:,7),G1H2(22),ngZu,m3h4x2(:,32),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(22),55,0,G2H2(20),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H8(60),wf4(:,7),G1H2(26),ngZu,m3h4x2(:,33),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(26),55,0,G2H2(24),n2h2(48))
  call Hloop_QZ_A(ntryL,G1H8(61),wf4(:,7),G1H2(27),ngZu,m3h4x2(:,34),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(27),55,0,G2H2(26),n2h2(49))
  call Hloop_QV_A(ntryL,G1H4(21),ex5(:),G1H2(32),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(32),n2h2(50))
  call Hloop_QV_A(ntryL,G1H4(22),ex5(:),G1H2(33),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(33),55,0,G2H2(34),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(26),ex5(:),G1H2(37),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(37),55,0,G2H2(37),n2h2(52))
  call Hloop_QV_A(ntryL,G1H4(27),ex5(:),G1H2(38),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(38),55,0,G2H2(39),n2h2(53))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(42),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(43),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(28),mass4set(:,2),  & 
G1H8(5),G1H8(6),G1H8(15),G1H8(16),G1H8(22),G0H8(5),8)
  call HG1shiftOLR(G1H8(6),16,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(28),mass4set(:,2),  & 
G1H8(28),G1H8(33),G1H8(49),G1H8(1),G1H8(7),G0H8(6),8)
  call HG1shiftOLR(G1H8(33),16,8)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(28),mass4set(:,3),  & 
G1H8(12),G1H8(13),G1H8(23),G1H8(24),G1H8(39),G0H8(7),8)
  call HG1shiftOLR(G1H8(13),16,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(28),mass4set(:,3),  & 
G1H8(40),G1H8(44),G1H8(45),G1H8(55),G1H8(56),G0H8(8),8)
  call HG1shiftOLR(G1H8(44),16,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(28),mass4set(:,2),  & 
G1H8(60),G1H8(61),G1H8(63),G1H8(64),G1H8(65),G0H8(9),8)
  call HG1shiftOLR(G1H8(61),16,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(28),mass4set(:,2),  & 
G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),G0H8(10),8)
  call HG1shiftOLR(G1H8(67),16,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(28),mass4set(:,1),  & 
G1H8(71),G1H8(72),G1H8(73),G1H8(74),G1H8(75),G0H8(11),8)
  call HG1shiftOLR(G1H8(72),16,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(28),mass4set(:,3),  & 
G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),G0H8(12),8)
  call HG1shiftOLR(G1H8(77),16,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(28),mass4set(:,1),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G0H8(13),8)
  call HG1shiftOLR(G1H8(82),16,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(28),mass4set(:,3),  & 
G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),G0H8(14),8)
  call HG1shiftOLR(G1H8(87),16,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(25),mass4set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G0H8(15),8)
  call HG1shiftOLR(G1H8(92),16,8)
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(25),mass4set(:,2),  & 
G1H8(96),G1H8(97),G1H8(98),G1H8(99),G1H8(100),G0H8(16),8)
  call HG1shiftOLR(G1H8(97),16,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(25),mass4set(:,1),  & 
G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(105),G0H8(17),8)
  call HG1shiftOLR(G1H8(102),16,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(25),mass4set(:,2),  & 
G1H8(106),G1H8(107),G1H8(108),G1H8(109),G1H8(110),G0H8(18),8)
  call HG1shiftOLR(G1H8(107),16,8)
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(25),mass4set(:,3),  & 
G1H8(111),G1H8(112),G1H8(113),G1H8(114),G1H8(115),G0H8(19),8)
  call HG1shiftOLR(G1H8(112),16,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(25),mass4set(:,3),  & 
G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),G0H8(20),8)
  call HG1shiftOLR(G1H8(117),16,8)
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(4),mass4set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G0H8(21),8)
  call HG1shiftOLR(G1H8(122),12,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(4),mass4set(:,2),  & 
G1H8(126),G1H8(127),G1H8(128),G1H8(129),G1H8(130),G0H8(22),8)
  call HG1shiftOLR(G1H8(127),12,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(4),mass4set(:,1),  & 
G1H8(131),G1H8(132),G1H8(133),G1H8(134),G1H8(135),G0H8(23),8)
  call HG1shiftOLR(G1H8(132),12,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(4),mass4set(:,2),  & 
G1H8(136),G1H8(137),G1H8(138),G1H8(139),G1H8(140),G0H8(24),8)
  call HG1shiftOLR(G1H8(137),12,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(4),mass4set(:,3),  & 
G1H8(141),G1H8(142),G1H8(143),G1H8(144),G1H8(145),G0H8(25),8)
  call HG1shiftOLR(G1H8(142),12,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(4),mass4set(:,3),  & 
G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),G0H8(26),8)
  call HG1shiftOLR(G1H8(147),12,8)
  call Hotf_4pt_reduction(G2H16(1),RedSet_4(38),mass4set(:,1),  & 
G1H16(6),G1H16(7),G1H16(8),G1H16(10),G1H16(3),16)
  call HG1shiftOLR(G1H16(7),20,16)
  call Hotf_4pt_reduction(G2H16(2),RedSet_4(38),mass4set(:,1),  & 
G1H16(4),G1H16(13),G1H16(14),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(13),20,16)
  call Hloop_AQ_V(ntryL,G2H8(48),wf4(:,4),G2H2(44),m3h4x2(:,35),heltab2x8(:,:,61))
  call Hloop_QA_V(ntryL,G2H8(50),ex4(:),G2H4(12),m3h2x4(:,27),heltab2x8(:,:,62))
  call Hotf_4pt_reduction(G2H16(3),RedSet_4(3),mass4set(:,1),  & 
G1H16(5),G1H16(1),G1H16(25),G1H16(26),G1H16(27),16)
  call HG1shiftOLR(G1H16(1),24,16)
  call Hotf_4pt_reduction(G2H16(4),RedSet_4(3),mass4set(:,1),  & 
G1H16(28),G1H16(29),G1H16(30),G1H16(31),G1H16(32),16)
  call HG1shiftOLR(G1H16(29),24,16)
  call Hloop_QA_V(ntryL,G2H8(52),wf4(:,11),G2H2(45),m3h4x2(:,36),heltab2x8(:,:,63))
  call Hloop_AQ_V(ntryL,G2H8(54),ex3(:),G2H4(17),m3h2x4(:,28),heltab2x8(:,:,64))
  call Hloop_VQ_A(ntryL,G1H16(11),wf8(:,8),G1H2(43),m3h8x2(:,1),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(46),n2h2(54))
  call Hloop_VQ_A(ntryL,G1H16(12),wf8(:,10),G1H2(44),m3h8x2(:,2),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(47),n2h2(55))
  call Hotf_4pt_reduction(G2H16(5),RedSet_4(2),mass4set(:,1),  & 
G1H16(11),G1H16(12),G1H16(33),G1H16(34),G1H16(35),16)
  call HG1shiftOLR(G1H16(12),11,16)
  call Hotf_4pt_reduction(G2H16(6),RedSet_4(2),mass4set(:,1),  & 
G1H16(36),G1H16(37),G1H16(38),G1H16(39),G1H16(40),16)
  call HG1shiftOLR(G1H16(37),11,16)
  call Hloop_VA_Q(ntryL,G1H16(16),wf8(:,3),G1H2(48),m3h8x2(:,3),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(48),47,0,G2H2(48),n2h2(56))
  call Hloop_VA_Q(ntryL,G1H16(17),wf8(:,5),G1H2(49),m3h8x2(:,4),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(49),47,0,G2H2(49),n2h2(57))
  call Hloop_VA_Q(ntryL,G1H16(18),ex4(:),G1H8(151),m3h2x8(:,23),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(151),44,0,G2H8(25),n2h8(89))
  call Hloop_VA_Q(ntryL,G1H16(19),ex4(:),G1H8(151),m3h2x8(:,24),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(151),44,0,G2H8(19),n2h8(90))
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(151),m3h2x8(:,25),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(151),44,0,G2H8(20),n2h8(91))
  call Hloop_VQ_A(ntryL,G1H16(22),ex3(:),G1H8(151),m3h2x8(:,26),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(151),44,0,G2H8(27),n2h8(92))
  call Hotf_4pt_reduction(G2H16(7),RedSet_4(1),mass4set(:,1),  & 
G1H16(16),G1H16(17),G1H16(18),G1H16(19),G1H16(20),16)
  call HG1shiftOLR(G1H16(17),8,16)
  call Hotf_4pt_reduction(G2H16(8),RedSet_4(1),mass4set(:,1),  & 
G1H16(22),G1H16(41),G1H16(42),G1H16(43),G1H16(44),16)
  call HG1shiftOLR(G1H16(41),8,16)
  call Hloop_VA_Q(ntryL,G1H16(15),ex4(:),G1H8(151),m3h2x8(:,27),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(151),44,0,G2H8(21),n2h8(93))
  call Hloop_VA_Q(ntryL,G1H16(21),ex4(:),G1H8(151),m3h2x8(:,28),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(151),44,0,G2H8(22),n2h8(94))
  call Hloop_VQ_A(ntryL,G1H16(2),ex3(:),G1H8(151),m3h2x8(:,29),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(151),44,0,G2H8(23),n2h8(95))
  call Hloop_VQ_A(ntryL,G1H16(9),ex3(:),G1H8(151),m3h2x8(:,30),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(151),44,0,G2H8(24),n2h8(96))
  call Hotf_4pt_reduction(G2H16(9),RedSet_4(1),mass4set(:,1),  & 
G1H16(15),G1H16(21),G1H16(2),G1H16(9),G1H16(45),16)
  call HG1shiftOLR(G1H16(21),8,16)
  call Hotf_4pt_reduction(G2H16(10),RedSet_4(1),mass4set(:,1),  & 
G1H16(46),G1H16(47),G1H16(48),G1H16(49),G1H16(50),16)
  call HG1shiftOLR(G1H16(47),8,16)
  call Hloop_AV_Q(ntryL,G1H4(7),ex5(:),G1H2(54),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(54),59,0,G2H2(50),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(55),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AV_Q(ntryL,G1H4(12),ex5(:),G1H2(59),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(59),59,0,G2H2(51),n2h2(59))
  call Hloop_AV_Q(ntryL,G1H4(13),ex5(:),G1H2(60),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(60),59,0,G2H2(52),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(14),ex5(:),G1H2(65),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(65),55,0,G2H2(53),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(19),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(66),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QV_A(ntryL,G1H4(15),ex5(:),G1H2(9),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(54),n2h2(62))
  call Hloop_QV_A(ntryL,G1H4(16),ex5(:),G1H2(20),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(55),n2h2(63))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,1),G1H2(31),m3h4x2(:,37),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(31),55,0,G2H2(56),n2h2(64))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(30),ex4(:),G1H4(3),m3h2x4(:,29),heltab2x8(:,:,66))
  call Hloop_QV_A(ntryL,G1H8(32),wf4(:,1),G1H2(42),m3h4x2(:,38),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(57),n2h2(65))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,1),G1H2(53),m3h4x2(:,39),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(58),n2h2(66))
  call Hloop_QZ_A(ntryL,G1H8(42),wf4(:,7),G1H2(64),ngZu,m3h4x2(:,40),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(64),55,0,G2H2(59),n2h2(67))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(38),ex4(:),G1H4(28),m3h2x4(:,30),heltab2x8(:,:,70))
  call Hloop_QZ_A(ntryL,G1H8(43),wf4(:,7),G1H2(4),ngZu,m3h4x2(:,41),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(4),55,0,G2H2(60),n2h2(68))
  call Hloop_QZ_A(ntryL,G1H8(46),wf4(:,7),G1H2(5),ngZu,m3h4x2(:,42),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(5),55,0,G2H2(61),n2h2(69))
  call Hloop_QV_A(ntryL,G1H4(20),ex5(:),G1H2(10),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(10),55,0,G2H2(62),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(10),ex4(:),G1H2(11),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(4),ex5(:),G1H2(15),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(15),55,0,G2H2(63),n2h2(71))
  call Hloop_QV_A(ntryL,G1H4(29),ex5(:),G1H2(16),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(16),55,0,G2H2(64),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,1),G1H2(21),m3h4x2(:,43),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(21),47,0,G2H2(65),n2h2(73))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-16,0,G2H8(39),n2h8(99))
  call Hloop_QV_A(ntryL,G2H8(39),ex5(:),G2H4(8),m3h2x4(:,31),heltab2x8(:,:,74))
  call Hloop_AV_Q(ntryL,G1H8(58),wf4(:,1),G1H2(22),m3h4x2(:,44),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(22),47,0,G2H2(66),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H8(54),wf4(:,1),G1H2(26),m3h4x2(:,45),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(26),47,0,G2H2(67),n2h2(75))
  call Hloop_AV_Q(ntryL,G0H8(1),wf4(:,1),G0H2(1),m3h4x2(:,46),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(27),n2h2(76))
  call Hloop_AZ_Q(ntryL,G1H8(57),wf4(:,7),G1H2(32),ngZu,m3h4x2(:,47),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(32),47,0,G2H2(68),n2h2(77))
call HGT_OLR(G1H8(59),1,1,8)
call HGT_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(59),-16,0,G2H8(33),n2h8(100))
  call Hloop_QV_A(ntryL,G2H8(33),ex5(:),G2H4(11),m3h2x4(:,32),heltab2x8(:,:,79))
  call Hloop_AZ_Q(ntryL,G1H8(3),wf4(:,7),G1H2(33),ngZu,m3h4x2(:,48),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(33),47,0,G2H2(69),n2h2(78))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,7),G1H2(37),ngZu,m3h4x2(:,49),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(37),47,0,G2H2(70),n2h2(79))
  call Hloop_AZ_Q(ntryL,G0H8(2),wf4(:,7),G0H2(1),ngZu,m3h4x2(:,50),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(38),n2h2(80))
  call Hloop_QV_A(ntryL,G1H8(35),wf4(:,1),G1H2(43),m3h4x2(:,51),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(71),n2h2(81))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(36),-16,0,G2H8(34),n2h8(101))
  call Hloop_AV_Q(ntryL,G2H8(34),ex5(:),G2H4(19),m3h2x4(:,33),heltab2x8(:,:,84))
  call Hloop_QV_A(ntryL,G1H8(52),wf4(:,1),G1H2(44),m3h4x2(:,52),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(72),n2h2(82))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,1),G1H2(48),m3h4x2(:,53),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(48),47,0,G2H2(73),n2h2(83))
  call Hloop_QV_A(ntryL,G0H8(3),wf4(:,1),G0H2(1),m3h4x2(:,54),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(49),n2h2(84))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,7),G1H2(54),ngZu,m3h4x2(:,55),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(54),47,0,G2H2(74),n2h2(85))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,0,G2H8(41),n2h8(102))
  call Hloop_AV_Q(ntryL,G2H8(41),ex5(:),G2H4(18),m3h2x4(:,34),heltab2x8(:,:,89))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,7),G1H2(59),ngZu,m3h4x2(:,56),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(59),47,0,G2H2(75),n2h2(86))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,7),G1H2(60),ngZu,m3h4x2(:,57),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(60),47,0,G2H2(76),n2h2(87))
  call Hloop_QZ_A(ntryL,G0H8(4),wf4(:,7),G0H2(1),ngZu,m3h4x2(:,58),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(65),n2h2(88))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,1),G1H2(9),m3h4x2(:,59),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(77),n2h2(89))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(9),m3h2x4(:,35),heltab2x8(:,:,94))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,1),G1H2(20),m3h4x2(:,60),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(78),n2h2(90))
  call Hloop_QV_A(ntryL,G1H8(34),wf4(:,1),G1H2(31),m3h4x2(:,61),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(31),55,0,G2H2(79),n2h2(91))
  call Hloop_QZ_A(ntryL,G1H8(50),wf4(:,7),G1H2(42),ngZu,m3h4x2(:,62),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(80),n2h2(92))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(21),ex4(:),G1H4(23),m3h2x4(:,36),heltab2x8(:,:,98))
  call Hloop_QZ_A(ntryL,G1H8(27),wf4(:,7),G1H2(53),ngZu,m3h4x2(:,63),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(53),55,0,G2H2(81),n2h2(93))
  call Hloop_QZ_A(ntryL,G1H8(26),wf4(:,7),G1H2(64),ngZu,m3h4x2(:,64),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(64),55,0,G2H2(82),n2h2(94))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,1),G1H2(4),m3h4x2(:,65),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(4),47,nMT,G2H2(83),n2h2(95))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(6),-16,nMT,G2H8(35),n2h8(105))
  call Hloop_QV_A(ntryL,G2H8(35),ex5(:),G2H4(14),m3h2x4(:,37),heltab2x8(:,:,102))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,1),G1H2(5),m3h4x2(:,66),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(5),47,nMT,G2H2(84),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,1),G1H2(10),m3h4x2(:,67),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(10),47,nMT,G2H2(85),n2h2(97))
  call Hloop_AV_Q(ntryL,G0H8(5),wf4(:,1),G0H2(1),m3h4x2(:,68),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMT,G1H2(15),n2h2(98))
  call Hloop_QV_A(ntryL,G1H8(28),wf4(:,1),G1H2(16),m3h4x2(:,69),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(16),47,nMT,G2H2(86),n2h2(99))
call HGT_OLR(G1H8(33),1,1,8)
call HGT_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(33),-16,nMT,G2H8(36),n2h8(106))
  call Hloop_AV_Q(ntryL,G2H8(36),ex5(:),G2H4(4),m3h2x4(:,38),heltab2x8(:,:,107))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(21),m3h4x2(:,70),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(21),47,nMT,G2H2(87),n2h2(100))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(22),m3h4x2(:,71),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(22),47,nMT,G2H2(88),n2h2(101))
  call Hloop_QV_A(ntryL,G0H8(6),wf4(:,1),G0H2(1),m3h4x2(:,72),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMT,G1H2(26),n2h2(102))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,1),G1H2(32),m3h4x2(:,73),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(32),47,nMB,G2H2(89),n2h2(103))
call HGT_OLR(G1H8(13),1,1,8)
call HGT_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(13),-16,nMB,G2H8(37),n2h8(107))
  call Hloop_QV_A(ntryL,G2H8(37),ex5(:),G2H4(5),m3h2x4(:,39),heltab2x8(:,:,112))
  call Hloop_AV_Q(ntryL,G1H8(24),wf4(:,1),G1H2(33),m3h4x2(:,74),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(33),47,nMB,G2H2(90),n2h2(104))
  call Hloop_AV_Q(ntryL,G1H8(39),wf4(:,1),G1H2(37),m3h4x2(:,75),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(37),47,nMB,G2H2(91),n2h2(105))
  call Hloop_AV_Q(ntryL,G0H8(7),wf4(:,1),G0H2(1),m3h4x2(:,76),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMB,G1H2(43),n2h2(106))
  call Hloop_QV_A(ntryL,G1H8(40),wf4(:,1),G1H2(44),m3h4x2(:,77),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(44),47,nMB,G2H2(92),n2h2(107))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-16,nMB,G2H8(38),n2h8(108))
  call Hloop_AV_Q(ntryL,G2H8(38),ex5(:),G2H4(9),m3h2x4(:,40),heltab2x8(:,:,117))
  call Hloop_QV_A(ntryL,G1H8(55),wf4(:,1),G1H2(48),m3h4x2(:,78),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(48),47,nMB,G2H2(93),n2h2(108))
  call Hloop_QV_A(ntryL,G1H8(56),wf4(:,1),G1H2(54),m3h4x2(:,79),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(54),47,nMB,G2H2(94),n2h2(109))
  call Hloop_QV_A(ntryL,G0H8(8),wf4(:,1),G0H2(1),m3h4x2(:,80),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMB,G1H2(59),n2h2(110))
  call Hloop_AZ_Q(ntryL,G1H8(60),wf4(:,7),G1H2(60),ngZu,m3h4x2(:,81),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(60),47,nMT,G2H2(95),n2h2(111))
call HGT_OLR(G1H8(61),1,1,8)
call HGT_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(61),-16,nMT,G2H8(47),n2h8(109))
  call Hloop_QV_A(ntryL,G2H8(47),ex5(:),G2H4(10),m3h2x4(:,41),heltab2x8(:,:,122))
  call Hloop_AZ_Q(ntryL,G1H8(64),wf4(:,7),G1H2(9),ngZu,m3h4x2(:,82),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(9),47,nMT,G2H2(96),n2h2(112))
  call Hloop_AZ_Q(ntryL,G1H8(65),wf4(:,7),G1H2(20),ngZu,m3h4x2(:,83),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(20),47,nMT,G2H2(97),n2h2(113))
  call Hloop_AZ_Q(ntryL,G0H8(9),wf4(:,7),G0H2(1),ngZu,m3h4x2(:,84),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMT,G1H2(31),n2h2(114))
  call Hloop_QZ_A(ntryL,G1H8(66),wf4(:,7),G1H2(42),ngZu,m3h4x2(:,85),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(42),47,nMT,G2H2(98),n2h2(115))
call HGT_OLR(G1H8(67),1,1,8)
call HGT_invQ_OLR(G1H8(67),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(67),-16,nMT,G2H8(49),n2h8(110))
  call Hloop_AV_Q(ntryL,G2H8(49),ex5(:),G2H4(20),m3h2x4(:,42),heltab2x8(:,:,127))
  call Hloop_QZ_A(ntryL,G1H8(69),wf4(:,7),G1H2(53),ngZu,m3h4x2(:,86),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(53),47,nMT,G2H2(99),n2h2(116))
  call Hloop_QZ_A(ntryL,G1H8(70),wf4(:,7),G1H2(64),ngZu,m3h4x2(:,87),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(64),47,nMT,G2H2(100),n2h2(117))
  call Hloop_QZ_A(ntryL,G0H8(10),wf4(:,7),G0H2(1),ngZu,m3h4x2(:,88),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMT,G1H2(4),n2h2(118))
  call Hloop_AZ_Q(ntryL,G1H8(71),wf4(:,7),G1H2(5),ngZd,m3h4x2(:,89),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(101),n2h2(119))
call HGT_OLR(G1H8(72),1,1,8)
call HGT_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(72),-16,0,G2H8(51),n2h8(111))
  call Hloop_QV_A(ntryL,G2H8(51),ex5(:),G2H4(6),m3h2x4(:,43),heltab2x8(:,:,132))
  call Hloop_AZ_Q(ntryL,G1H8(74),wf4(:,7),G1H2(10),ngZd,m3h4x2(:,90),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(10),47,0,G2H2(102),n2h2(120))
  call Hloop_AZ_Q(ntryL,G1H8(75),wf4(:,7),G1H2(16),ngZd,m3h4x2(:,91),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(16),47,0,G2H2(103),n2h2(121))
  call Hloop_AZ_Q(ntryL,G0H8(11),wf4(:,7),G0H2(1),ngZd,m3h4x2(:,92),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(21),n2h2(122))
  call Hloop_AZ_Q(ntryL,G1H8(76),wf4(:,7),G1H2(22),ngZd,m3h4x2(:,93),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(22),47,nMB,G2H2(104),n2h2(123))
call HGT_OLR(G1H8(77),1,1,8)
call HGT_invQ_OLR(G1H8(77),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(77),-16,nMB,G2H8(53),n2h8(112))
  call Hloop_QV_A(ntryL,G2H8(53),ex5(:),G2H4(7),m3h2x4(:,44),heltab2x8(:,:,137))
  call Hloop_AZ_Q(ntryL,G1H8(79),wf4(:,7),G1H2(32),ngZd,m3h4x2(:,94),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(32),47,nMB,G2H2(105),n2h2(124))
  call Hloop_AZ_Q(ntryL,G1H8(80),wf4(:,7),G1H2(33),ngZd,m3h4x2(:,95),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(33),47,nMB,G2H2(106),n2h2(125))
  call Hloop_AZ_Q(ntryL,G0H8(12),wf4(:,7),G0H2(1),ngZd,m3h4x2(:,96),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMB,G1H2(37),n2h2(126))
  call Hloop_QZ_A(ntryL,G1H8(81),wf4(:,7),G1H2(44),ngZd,m3h4x2(:,97),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(107),n2h2(127))
call HGT_OLR(G1H8(82),1,1,8)
call HGT_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(82),-16,0,G2H8(8),n2h8(113))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(21),m3h2x4(:,45),heltab2x8(:,:,142))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,7),G1H2(48),ngZd,m3h4x2(:,98),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(48),47,0,G2H2(108),n2h2(128))
  call Hloop_QZ_A(ntryL,G1H8(85),wf4(:,7),G1H2(54),ngZd,m3h4x2(:,99),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(54),47,0,G2H2(109),n2h2(129))
  call Hloop_QZ_A(ntryL,G0H8(13),wf4(:,7),G0H2(1),ngZd,m3h4x2(:,100),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(60),n2h2(130))
  call Hloop_QZ_A(ntryL,G1H8(86),wf4(:,7),G1H2(9),ngZd,m3h4x2(:,101),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(9),47,nMB,G2H2(110),n2h2(131))
call HGT_OLR(G1H8(87),1,1,8)
call HGT_invQ_OLR(G1H8(87),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(87),-16,nMB,G2H8(10),n2h8(114))
  call Hloop_AV_Q(ntryL,G2H8(10),ex5(:),G2H4(22),m3h2x4(:,46),heltab2x8(:,:,147))
  call Hloop_QZ_A(ntryL,G1H8(89),wf4(:,7),G1H2(20),ngZd,m3h4x2(:,102),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(20),47,nMB,G2H2(111),n2h2(132))
  call Hloop_QZ_A(ntryL,G1H8(90),wf4(:,7),G1H2(42),ngZd,m3h4x2(:,103),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(42),47,nMB,G2H2(112),n2h2(133))
  call Hloop_QZ_A(ntryL,G0H8(14),wf4(:,7),G0H2(1),ngZd,m3h4x2(:,104),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMB,G1H2(53),n2h2(134))
  call Hloop_AV_Q(ntryL,G1H8(91),wf4(:,16),G1H2(64),m3h4x2(:,105),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(64),47,0,G2H2(113),n2h2(135))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(92),-16,0,G2H8(4),n2h8(115))
  call Hloop_QV_A(ntryL,G2H8(4),ex5(:),G2H4(23),m3h2x4(:,47),heltab2x8(:,:,152))
  call Hloop_AV_Q(ntryL,G1H8(94),wf4(:,16),G1H2(5),m3h4x2(:,106),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(5),47,0,G2H2(114),n2h2(136))
  call Hloop_AV_Q(ntryL,G1H8(95),wf4(:,16),G1H2(10),m3h4x2(:,107),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(10),47,0,G2H2(115),n2h2(137))
  call Hloop_AV_Q(ntryL,G0H8(15),wf4(:,16),G0H2(1),m3h4x2(:,108),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G0H2(1),47,0,G1H2(16),n2h2(138))
  call Hloop_AV_Q(ntryL,G1H8(96),wf4(:,16),G1H2(22),m3h4x2(:,109),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(22),47,nMT,G2H2(116),n2h2(139))
call HGT_OLR(G1H8(97),1,1,8)
call HGT_invQ_OLR(G1H8(97),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(97),-16,nMT,G2H8(5),n2h8(116))
  call Hloop_QV_A(ntryL,G2H8(5),ex5(:),G2H4(24),m3h2x4(:,48),heltab2x8(:,:,157))
  call Hloop_AV_Q(ntryL,G1H8(99),wf4(:,16),G1H2(32),m3h4x2(:,110),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(32),47,nMT,G2H2(117),n2h2(140))
  call Hloop_AV_Q(ntryL,G1H8(100),wf4(:,16),G1H2(33),m3h4x2(:,111),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(33),47,nMT,G2H2(118),n2h2(141))
  call Hloop_AV_Q(ntryL,G0H8(16),wf4(:,16),G0H2(1),m3h4x2(:,112),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMT,G1H2(44),n2h2(142))
  call Hloop_QV_A(ntryL,G1H8(101),wf4(:,16),G1H2(48),m3h4x2(:,113),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(48),47,0,G2H2(119),n2h2(143))
call HGT_OLR(G1H8(102),1,1,8)
call HGT_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(102),-16,0,G2H8(11),n2h8(117))
  call Hloop_AV_Q(ntryL,G2H8(11),ex5(:),G2H4(25),m3h2x4(:,49),heltab2x8(:,:,162))
  call Hloop_QV_A(ntryL,G1H8(104),wf4(:,16),G1H2(54),m3h4x2(:,114),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(54),47,0,G2H2(120),n2h2(144))
  call Hloop_QV_A(ntryL,G1H8(105),wf4(:,16),G1H2(9),m3h4x2(:,115),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(9),47,0,G2H2(121),n2h2(145))
  call Hloop_QV_A(ntryL,G0H8(17),wf4(:,16),G0H2(1),m3h4x2(:,116),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G0H2(1),47,0,G1H2(20),n2h2(146))
  call Hloop_QV_A(ntryL,G1H8(106),wf4(:,16),G1H2(42),m3h4x2(:,117),heltab2x8(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(42),47,nMT,G2H2(122),n2h2(147))
call HGT_OLR(G1H8(107),1,1,8)
call HGT_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(107),-16,nMT,G2H8(13),n2h8(118))
  call Hloop_AV_Q(ntryL,G2H8(13),ex5(:),G2H4(26),m3h2x4(:,50),heltab2x8(:,:,167))
  call Hloop_QV_A(ntryL,G1H8(109),wf4(:,16),G1H2(64),m3h4x2(:,118),heltab2x8(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(64),47,nMT,G2H2(123),n2h2(148))
  call Hloop_QV_A(ntryL,G1H8(110),wf4(:,16),G1H2(5),m3h4x2(:,119),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(5),47,nMT,G2H2(124),n2h2(149))
  call Hloop_QV_A(ntryL,G0H8(18),wf4(:,16),G0H2(1),m3h4x2(:,120),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMT,G1H2(10),n2h2(150))
  call Hloop_AV_Q(ntryL,G1H8(111),wf4(:,16),G1H2(22),m3h4x2(:,121),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(22),47,nMB,G2H2(125),n2h2(151))
call HGT_OLR(G1H8(112),1,1,8)
call HGT_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(112),-16,nMB,G2H8(6),n2h8(119))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(27),m3h2x4(:,51),heltab2x8(:,:,172))
  call Hloop_AV_Q(ntryL,G1H8(114),wf4(:,16),G1H2(32),m3h4x2(:,122),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(32),47,nMB,G2H2(126),n2h2(152))
  call Hloop_AV_Q(ntryL,G1H8(115),wf4(:,16),G1H2(33),m3h4x2(:,123),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(33),47,nMB,G2H2(127),n2h2(153))
  call Hloop_AV_Q(ntryL,G0H8(19),wf4(:,16),G0H2(1),m3h4x2(:,124),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G0H2(1),47,nMB,G1H2(48),n2h2(154))
  call Hloop_QV_A(ntryL,G1H8(116),wf4(:,16),G1H2(54),m3h4x2(:,125),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(54),47,nMB,G2H2(128),n2h2(155))
call HGT_OLR(G1H8(117),1,1,8)
call HGT_invQ_OLR(G1H8(117),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(117),-16,nMB,G2H8(2),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(2),ex5(:),G2H4(28),m3h2x4(:,52),heltab2x8(:,:,177))
  call Hloop_QV_A(ntryL,G1H8(119),wf4(:,16),G1H2(9),m3h4x2(:,126),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(9),47,nMB,G2H2(129),n2h2(156))
  call Hloop_QV_A(ntryL,G1H8(120),wf4(:,16),G1H2(42),m3h4x2(:,127),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(42),47,nMB,G2H2(130),n2h2(157))
  call Hloop_QV_A(ntryL,G0H8(20),wf4(:,16),G0H2(1),m3h4x2(:,128),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G0H2(1),47,nMB,G1H2(64),n2h2(158))
  call Hloop_QV_A(ntryL,G1H8(121),ex5(:),G1H4(21),m3h2x4(:,53),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(21),51,0,G2H4(29),n2h4(35))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-12,0,G2H8(9),n2h8(121))
  call Hloop_AV_Q(ntryL,G2H8(9),wf4(:,16),G2H2(131),m3h4x2(:,129),heltab2x8(:,:,182))
  call Hloop_QV_A(ntryL,G1H8(124),ex5(:),G1H4(22),m3h2x4(:,54),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(22),51,0,G2H4(30),n2h4(36))
  call Hloop_QV_A(ntryL,G1H8(125),ex5(:),G1H4(26),m3h2x4(:,55),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(26),51,0,G2H4(31),n2h4(37))
  call Hloop_QV_A(ntryL,G0H8(21),ex5(:),G0H4(1),m3h2x4(:,56),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(27),n2h4(38))
  call Hloop_QV_A(ntryL,G1H8(126),ex5(:),G1H4(7),m3h2x4(:,57),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(7),51,nMT,G2H4(32),n2h4(39))
call HGT_OLR(G1H8(127),1,1,8)
call HGT_invQ_OLR(G1H8(127),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(127),-12,nMT,G2H8(12),n2h8(122))
  call Hloop_AV_Q(ntryL,G2H8(12),wf4(:,16),G2H2(132),m3h4x2(:,130),heltab2x8(:,:,187))
  call Hloop_QV_A(ntryL,G1H8(129),ex5(:),G1H4(8),m3h2x4(:,58),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(8),51,nMT,G2H4(33),n2h4(40))
  call Hloop_QV_A(ntryL,G1H8(130),ex5(:),G1H4(12),m3h2x4(:,59),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(12),51,nMT,G2H4(34),n2h4(41))
  call Hloop_QV_A(ntryL,G0H8(22),ex5(:),G0H4(1),m3h2x4(:,60),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(13),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(131),ex5(:),G1H4(14),m3h2x4(:,61),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(14),51,0,G2H4(35),n2h4(43))
call HGT_OLR(G1H8(132),1,1,8)
call HGT_invQ_OLR(G1H8(132),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(132),-12,0,G2H8(1),n2h8(123))
  call Hloop_QV_A(ntryL,G2H8(1),wf4(:,16),G2H2(133),m3h4x2(:,131),heltab2x8(:,:,192))
  call Hloop_AV_Q(ntryL,G1H8(134),ex5(:),G1H4(19),m3h2x4(:,62),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(19),51,0,G2H4(36),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(135),ex5(:),G1H4(15),m3h2x4(:,63),heltab2x8(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(15),51,0,G2H4(37),n2h4(45))
  call Hloop_AV_Q(ntryL,G0H8(23),ex5(:),G0H4(1),m3h2x4(:,64),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(16),n2h4(46))
  call Hloop_AV_Q(ntryL,G1H8(136),ex5(:),G1H4(20),m3h2x4(:,65),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(20),51,nMT,G2H4(38),n2h4(47))
call HGT_OLR(G1H8(137),1,1,8)
call HGT_invQ_OLR(G1H8(137),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(137),-12,nMT,G2H8(3),n2h8(124))
  call Hloop_QV_A(ntryL,G2H8(3),wf4(:,16),G2H2(134),m3h4x2(:,132),heltab2x8(:,:,197))
  call Hloop_AV_Q(ntryL,G1H8(139),ex5(:),G1H4(10),m3h2x4(:,66),heltab2x8(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(10),51,nMT,G2H4(39),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(140),ex5(:),G1H4(4),m3h2x4(:,67),heltab2x8(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(4),51,nMT,G2H4(40),n2h4(49))
  call Hloop_AV_Q(ntryL,G0H8(24),ex5(:),G0H4(1),m3h2x4(:,68),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(29),n2h4(50))
  call Hloop_QV_A(ntryL,G1H8(141),ex5(:),G1H4(21),m3h2x4(:,69),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(21),51,nMB,G2H4(41),n2h4(51))
call HGT_OLR(G1H8(142),1,1,8)
call HGT_invQ_OLR(G1H8(142),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(142),-12,nMB,G2H8(7),n2h8(125))
  call Hloop_AV_Q(ntryL,G2H8(7),wf4(:,16),G2H2(135),m3h4x2(:,133),heltab2x8(:,:,202))
  call Hloop_QV_A(ntryL,G1H8(144),ex5(:),G1H4(22),m3h2x4(:,70),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(22),51,nMB,G2H4(42),n2h4(52))
  call Hloop_QV_A(ntryL,G1H8(145),ex5(:),G1H4(26),m3h2x4(:,71),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(26),51,nMB,G2H4(43),n2h4(53))
  call Hloop_QV_A(ntryL,G0H8(25),ex5(:),G0H4(1),m3h2x4(:,72),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(7),n2h4(54))
  call Hloop_AV_Q(ntryL,G1H8(146),ex5(:),G1H4(8),m3h2x4(:,73),heltab2x8(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(8),51,nMB,G2H4(44),n2h4(55))
call HGT_OLR(G1H8(147),1,1,8)
call HGT_invQ_OLR(G1H8(147),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(147),-12,nMB,G2H8(14),n2h8(126))
  call Hloop_QV_A(ntryL,G2H8(14),wf4(:,16),G2H2(136),m3h4x2(:,134),heltab2x8(:,:,207))
  call Hloop_AV_Q(ntryL,G1H8(149),ex5(:),G1H4(12),m3h2x4(:,74),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(12),51,nMB,G2H4(45),n2h4(56))
  call Hloop_AV_Q(ntryL,G1H8(150),ex5(:),G1H4(14),m3h2x4(:,75),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H4(14),51,nMB,G2H4(46),n2h4(57))
  call Hloop_AV_Q(ntryL,G0H8(26),ex5(:),G0H4(1),m3h2x4(:,76),heltab2x8(:,:,210))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMB,G1H4(19),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,1),G1H4(15),m3h4x4(:,13),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(15),43,0,G2H4(47),n2h4(59))
call HGT_raise_alpha_OLR(G1H16(7),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(7),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(7),wf4(:,4),G1H4(20),m3h4x4(:,14),heltab2x16(:,:,48))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,1),G1H4(10),m3h4x4(:,15),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(10),43,0,G2H4(48),n2h4(60))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(4),m3h4x4(:,16),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(4),43,0,G2H4(49),n2h4(61))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,7),G1H4(21),ngZu,m3h4x4(:,17),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(21),43,0,G2H4(50),n2h4(62))
call HGT_raise_alpha_OLR(G1H16(13),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(13),2,5,16)
  call Hloop_VQ_A(ntryL,G1H16(13),wf4(:,4),G1H4(22),m3h4x4(:,18),heltab2x16(:,:,52))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,7),G1H4(26),ngZu,m3h4x4(:,19),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(26),43,0,G2H4(51),n2h4(63))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf4(:,7),G1H4(8),ngZu,m3h4x4(:,20),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(8),43,0,G2H4(52),n2h4(64))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(12),m3h4x4(:,21),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(12),39,0,G2H4(53),n2h4(65))
call HGT_raise_alpha_OLR(G1H16(1),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(1),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(1),wf4(:,11),G1H4(14),m3h4x4(:,22),heltab2x16(:,:,56))
  call Hloop_QV_A(ntryL,G1H16(26),wf4(:,1),G1H4(15),m3h4x4(:,23),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(15),39,0,G2H4(54),n2h4(66))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,1),G1H4(10),m3h4x4(:,24),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(10),39,0,G2H4(55),n2h4(67))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,7),G1H4(4),ngZu,m3h4x4(:,25),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(4),39,0,G2H4(56),n2h4(68))
call HGT_raise_alpha_OLR(G1H16(29),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(29),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(29),wf4(:,11),G1H4(21),m3h4x4(:,26),heltab2x16(:,:,60))
  call Hloop_QZ_A(ntryL,G1H16(31),wf4(:,7),G1H4(26),ngZu,m3h4x4(:,27),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(26),39,0,G2H4(57),n2h4(69))
  call Hloop_QZ_A(ntryL,G1H16(32),wf4(:,7),G1H4(8),ngZu,m3h4x4(:,28),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(8),39,0,G2H4(58),n2h4(70))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(151),m3h2x8(:,31),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(151),52,0,G2H8(15),n2h8(127))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(12),wf8(:,3),G1H2(5),m3h8x2(:,5),heltab2x16(:,:,64))
  call Hloop_QV_A(ntryL,G1H16(34),ex5(:),G1H8(29),m3h2x8(:,32),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(29),52,0,G2H8(16),n2h8(128))
  call Hloop_QV_A(ntryL,G1H16(35),ex5(:),G1H8(30),m3h2x8(:,33),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(30),52,0,G2H8(17),n2h8(129))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(32),m3h2x8(:,34),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(32),52,0,G2H8(18),n2h8(130))
call HGT_raise_alpha_OLR(G1H16(37),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(37),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(37),wf8(:,5),G1H2(22),m3h8x2(:,6),heltab2x16(:,:,68))
  call Hloop_QV_A(ntryL,G1H16(39),ex5(:),G1H8(37),m3h2x8(:,35),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(37),52,0,G2H8(29),n2h8(131))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(42),m3h2x8(:,36),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(42),52,0,G2H8(26),n2h8(132))
  call Hloop_QV_A(ntryL,G1H16(16),wf8(:,13),G1H2(32),m3h8x2(:,7),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(137),n2h2(159))
call HGT_raise_alpha_OLR(G1H16(17),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(17),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(17),ex4(:),G1H8(38),m3h2x8(:,37),heltab2x16(:,:,72))
  call Hloop_QV_A(ntryL,G1H16(19),wf8(:,13),G1H2(33),m3h8x2(:,8),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(33),55,0,G2H2(138),n2h2(160))
  call Hloop_QV_A(ntryL,G1H16(20),wf8(:,13),G1H2(54),m3h8x2(:,9),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(54),55,0,G2H2(139),n2h2(161))
  call Hloop_QZ_A(ntryL,G1H16(22),wf8(:,17),G1H2(9),ngZu,m3h8x2(:,10),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(140),n2h2(162))
call HGT_raise_alpha_OLR(G1H16(41),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(41),ex4(:),G1H8(43),m3h2x8(:,38),heltab2x16(:,:,76))
  call Hloop_QZ_A(ntryL,G1H16(43),wf8(:,17),G1H2(42),ngZu,m3h8x2(:,11),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(141),n2h2(163))
  call Hloop_QZ_A(ntryL,G1H16(44),wf8(:,17),G1H2(32),ngZu,m3h8x2(:,12),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(142),n2h2(164))
  call Hloop_QV_A(ntryL,G1H16(15),wf8(:,20),G1H2(33),m3h8x2(:,13),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(33),55,0,G2H2(143),n2h2(165))
call HGT_raise_alpha_OLR(G1H16(21),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(21),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(21),ex4(:),G1H8(46),m3h2x8(:,39),heltab2x16(:,:,80))
  call Hloop_QV_A(ntryL,G1H16(9),wf8(:,20),G1H2(54),m3h8x2(:,14),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(54),55,0,G2H2(144),n2h2(166))
  call Hloop_QV_A(ntryL,G1H16(45),wf8(:,20),G1H2(9),m3h8x2(:,15),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(145),n2h2(167))
  call Hloop_QZ_A(ntryL,G1H16(46),wf8(:,22),G1H2(42),ngZu,m3h8x2(:,16),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(146),n2h2(168))
call HGT_raise_alpha_OLR(G1H16(47),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(47),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(47),ex4(:),G1H8(47),m3h2x8(:,40),heltab2x16(:,:,84))
  call Hloop_QZ_A(ntryL,G1H16(49),wf8(:,22),G1H2(32),ngZu,m3h8x2(:,17),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(32),55,0,G2H2(147),n2h2(169))
  call Hloop_QZ_A(ntryL,G1H16(50),wf8(:,22),G1H2(33),ngZu,m3h8x2(:,18),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(33),55,0,G2H2(148),n2h2(170))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(2),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(5),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G2H2(9),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(48),G2H2(15),G2H2(12),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(19),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(46),G2H2(25),G2H2(22),G1H2(63)])
call HGT_w2_OLR(G1H4(17),1,1,4)
call HGT_w2_invQ_OLR(G1H4(17),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(143),G2H2(140),G2H2(137),G2H2(38),G2H2(33) &
    ,G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G2H2(145),G2H2(142),G2H2(139),G2H2(41),G2H2(40) &
    ,G2H2(36),G2H2(35),G2H2(31),G2H2(30)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(21),G1H2(61)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(1)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(1),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(68),G2H2(65),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G2H2(70),G2H2(67),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(74),G2H2(71),G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(76),G2H2(73),G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(79),G2H2(24),G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(58),G2H2(26),G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(38),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(65),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G2H4(55)])
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(17),mass4set(:,1),  & 
G1H2(54),G1H2(9),G1H2(42),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(9),8,2)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(21),mass4set(:,1),  & 
G1H2(8),G1H2(19),G1H2(30),G1H2(41),G1H2(52),2)
  call HG1shiftOLR(G1H2(19),4,2)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(39),mass4set(:,1),  & 
G1H2(63),G1H2(61),G1H2(1),G1H2(67),G1H2(6),2)
  call HG1shiftOLR(G1H2(61),4,2)
  call Hotf_4pt_reduction(G2H2(119),RedSet_4(25),mass4set(:,1),  & 
G1H2(7),G1H2(17),G1H2(18),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(17),16,2)
call HGT_OLR(G2H4(15),1,1,4)
call HGT_invQ_OLR(G2H4(15),2,5,4)
call HGT_OLR(G2H4(15),6,15,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(40),mass4set(:,1),  & 
G1H4(12),G1H4(15),G1H4(10),G1H4(4),G1H4(26),4)
  call HG1shiftOLR(G1H4(15),3,4)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(29),mass4set(:,1),  & 
G1H2(36),G1H2(39),G1H2(40),G1H2(46),G1H2(50),2)
  call HG1shiftOLR(G1H2(39),16,2)
call HGT_OLR(G2H4(16),1,1,4)
call HGT_invQ_OLR(G2H4(16),2,5,4)
call HGT_OLR(G2H4(16),6,15,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(40),mass4set(:,1),  & 
G1H4(8),G1H4(17),G1H4(2),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(17),3,4)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(41),mass4set(:,1),  & 
G1H2(51),G1H2(58),G1H2(62),G1H2(68),G1H2(38),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(25),mass4set(:,1),  & 
G1H2(27),G1H2(65),G1H2(49),G1H2(15),G1H2(26),2)
  call HG1shiftOLR(G1H2(65),16,2)
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(42),mass4set(:,1),  & 
G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(33),3,4)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(35),mass4set(:,1),  & 
G1H2(43),G1H2(59),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(59),16,2)
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(42),mass4set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),4)
  call HG1shiftOLR(G1H4(38),3,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(43),mass4set(:,1),  & 
G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(43),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(146),ex4(:),G2tensor(1),m3h2x1(:,29),heltab2x2(:,:,29))
call HGT_w2_OLR(G1H4(18),1,1,4)
call HGT_w2_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(25))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(148),ex4(:),G2tensor(5),m3h2x1(:,30),heltab2x2(:,:,30))
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(9),n2h1(26))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(43),mass4set(:,1),  & 
G1H4(18),G1H4(1),G1H4(47),G1H4(48),G1H4(49),4)
  call HG1shiftOLR(G1H4(1),3,4)
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(27))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(17),n2h1(28))
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(34),mass4set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hloop_QV_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(29))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(25),n2h1(30))
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(15),mass4set(:,1),  & 
G1H2(2),G1H2(3),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(3),8,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(16),mass4set(:,1),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(33))
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(19),mass4set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(86),G1H2(87),2)
  call HG1shiftOLR(G1H2(13),4,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(20),mass4set(:,1),  & 
G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(89),4,2)
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(36))
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(23),mass4set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(24),16,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(24),mass4set(:,1),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(96),16,2)
  call Hloop_QV_A(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(38))
  call Hloop_QV_A(ntryL,G2H2(121),ex5(:),G2H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(39))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(27),mass4set(:,1),  & 
G1H2(34),G1H2(35),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(28),mass4set(:,1),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),2)
  call HG1shiftOLR(G1H2(104),16,2)
  call Hloop_AV_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(40))
  call Hloop_AV_Q(ntryL,G2H2(103),ex5(:),G2H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(42))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(31),mass4set(:,1),  & 
G1H2(45),G1H2(47),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(47),16,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(32),mass4set(:,1),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),2)
  call HG1shiftOLR(G1H2(112),16,2)
  call Hloop_AV_Q(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(44))
  call Hloop_AV_Q(ntryL,G2H2(115),ex5(:),G2H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(3),n2h1(45))
  call Hotf_4pt_reduction(G2H2(107),RedSet_4(28),mass4set(:,1),  & 
G1H2(56),G1H2(57),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(57),16,2)
  call Hloop_QV_A(ntryL,G2H2(109),ex5(:),G2H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(4),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(82),ex4(:),G2tensor(42),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex4(:),G2tensor(43),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(44),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex4(:),G2tensor(45),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(5),mass4set(:,1),  & 
G1H4(5),G1H4(6),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(6),20,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(7),mass4set(:,1),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),4)
  call HG1shiftOLR(G1H4(54),24,4)
  call Hotf_4pt_reduction(G2H8(25),RedSet_4(6),mass4set(:,1),  & 
G1H8(48),G1H8(58),G1H8(54),G1H8(57),G1H8(59),8)
  call HG1shiftOLR(G1H8(58),19,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(6),mass4set(:,1),  & 
G1H8(3),G1H8(9),G1H8(35),G1H8(36),G1H8(52),8)
  call HG1shiftOLR(G1H8(9),19,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(8),mass4set(:,1),  & 
G1H8(2),G1H8(4),G1H8(8),G1H8(11),G1H8(14),8)
  call HG1shiftOLR(G1H8(4),19,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(8),mass4set(:,1),  & 
G1H8(17),G1H8(18),G1H8(20),G1H8(34),G1H8(50),8)
  call HG1shiftOLR(G1H8(18),19,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(6),mass4set(:,1),  & 
G1H8(21),G1H8(27),G1H8(26),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(27),19,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(6),mass4set(:,1),  & 
G1H8(16),G1H8(22),G1H8(28),G1H8(33),G1H8(1),8)
  call HG1shiftOLR(G1H8(22),19,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(8),mass4set(:,1),  & 
G1H8(7),G1H8(12),G1H8(13),G1H8(24),G1H8(39),8)
  call HG1shiftOLR(G1H8(12),19,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(8),mass4set(:,1),  & 
G1H8(40),G1H8(44),G1H8(55),G1H8(56),G1H8(60),8)
  call HG1shiftOLR(G1H8(44),19,8)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(50),ex3(:),G2tensor(46),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(52),ex3(:),G2tensor(47),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(53),ex4(:),G2tensor(48),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex4(:),G2tensor(49),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(62),ex4(:),G2tensor(50),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hloop_AV_Q(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(80),ex4(:),G2tensor(53),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hotf_4pt_reduction(G2H2(95),RedSet_4(28),mass4set(:,2),  & 
G1H2(69),G1H2(21),G1H2(60),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(21),16,2)
  call Hloop_AV_Q(ntryL,G2H2(97),ex5(:),G2H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(5),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(54),n2h1(51))
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(28),mass4set(:,2),  & 
G1H2(31),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(121),16,2)
  call Hloop_QV_A(ntryL,G2H2(100),ex5(:),G2H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(6),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(55),n2h1(53))
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(28),mass4set(:,3),  & 
G1H2(4),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(125),16,2)
  call Hloop_AV_Q(ntryL,G2H2(106),ex5(:),G2H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(7),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(56),n2h1(55))
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(28),mass4set(:,3),  & 
G1H2(37),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(129),16,2)
  call Hloop_QV_A(ntryL,G2H2(112),ex5(:),G2H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(8),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(57),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(58))
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(25),mass4set(:,2),  & 
G1H2(53),G1H2(16),G1H2(133),G1H2(134),G1H2(135),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hloop_AV_Q(ntryL,G2H2(118),ex5(:),G2H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(9),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(59),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(61))
  call Hotf_4pt_reduction(G2H2(122),RedSet_4(25),mass4set(:,2),  & 
G1H2(44),G1H2(20),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hloop_QV_A(ntryL,G2H2(124),ex5(:),G2H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(10),n2h1(62))
  call Hloop_QV_A(ntryL,G1H2(10),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(63))
  call Hotf_4pt_reduction(G2H2(125),RedSet_4(25),mass4set(:,3),  & 
G1H2(10),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(139),16,2)
  call Hloop_AV_Q(ntryL,G2H2(127),ex5(:),G2H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(11),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(62),n2h1(65))
  call Hotf_4pt_reduction(G2H2(128),RedSet_4(25),mass4set(:,3),  & 
G1H2(48),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(143),16,2)
  call Hloop_QV_A(ntryL,G2H2(130),ex5(:),G2H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(12),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(64),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(63),n2h1(67))
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(4),mass4set(:,1),  & 
G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(59),12,4)
  call Hloop_QV_A(ntryL,G2H4(31),wf4(:,16),G2H1(1),m3h4x1(:,5),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(13),n2h1(68))
  call Hloop_QV_A(ntryL,G1H4(27),wf4(:,16),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(69))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(4),mass4set(:,2),  & 
G1H4(27),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(63),12,4)
  call Hloop_QV_A(ntryL,G2H4(34),wf4(:,16),G2H1(1),m3h4x1(:,7),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(14),n2h1(70))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,16),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(65),n2h1(71))
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(4),mass4set(:,1),  & 
G1H4(13),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(67),12,4)
  call Hloop_AV_Q(ntryL,G2H4(37),wf4(:,16),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(15),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H4(16),wf4(:,16),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(73))
  call Hotf_4pt_reduction(G2H4(38),RedSet_4(4),mass4set(:,2),  & 
G1H4(16),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(71),12,4)
  call Hloop_AV_Q(ntryL,G2H4(40),wf4(:,16),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(16),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H4(29),wf4(:,16),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(75))
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(4),mass4set(:,3),  & 
G1H4(29),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(75),12,4)
  call Hloop_QV_A(ntryL,G2H4(43),wf4(:,16),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(17),n2h1(76))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,16),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(68),n2h1(77))
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(4),mass4set(:,3),  & 
G1H4(7),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(79),12,4)
  call Hloop_AV_Q(ntryL,G2H4(46),wf4(:,16),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(18),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,16),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(69),n2h1(79))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(50),wf4(:,4),G2tensor(70),m3h4x1(:,17),heltab2x4(:,:,63))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(52),wf4(:,4),G2tensor(71),m3h4x1(:,18),heltab2x4(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(56),wf4(:,11),G2tensor(72),m3h4x1(:,19),heltab2x4(:,:,65))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(58),wf4(:,11),G2tensor(73),m3h4x1(:,20),heltab2x4(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(15),wf8(:,3),G2tensor(74),m3h8x1(:,1),heltab2x8(:,:,211))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(17),wf8(:,3),G2tensor(75),m3h8x1(:,2),heltab2x8(:,:,212))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(18),wf8(:,5),G2tensor(76),m3h8x1(:,3),heltab2x8(:,:,213))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(26),wf8(:,5),G2tensor(77),m3h8x1(:,4),heltab2x8(:,:,214))
  call Hloop_VA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(79),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(81),n2h1(83))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(82),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(85))
  call Hloop_VQ_A(ntryL,G1H2(63),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(84),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(85),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(86),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(88),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,0,G2tensor(91),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H4(26),wf4(:,1),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(92),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(94),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(50),ex5(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(97))
  call Hloop_AZ_Q(ntryL,G1H4(8),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,24),heltab2x4(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(98))
  call Hloop_AZ_Q(ntryL,G1H4(17),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,25),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,0,G2tensor(97),n2h1(99))
  call Hloop_AZ_Q(ntryL,G1H4(31),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,26),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(98),n2h1(100))
  call Hloop_VA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(100),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(102),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(103),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(106))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,1),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(107))
  call Hloop_QV_A(ntryL,G1H4(33),wf4(:,1),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(106),n2h1(108))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,1),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(107),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(108),n2h1(110))
  call Hloop_QV_A(ntryL,G1H2(59),ex5(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(109),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(112))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,30),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(113))
  call Hloop_QZ_A(ntryL,G1H4(38),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,31),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(112),n2h1(114))
  call Hloop_QZ_A(ntryL,G1H4(41),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,32),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(113),n2h1(115))
  call Hloop_QV_A(ntryL,G1H4(42),wf4(:,1),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(116))
  call Hloop_QV_A(ntryL,G1H4(43),wf4(:,1),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(115),n2h1(117))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,1),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(116),n2h1(118))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,36),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(119))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,37),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(118),n2h1(120))
  call Hloop_QZ_A(ntryL,G1H4(49),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,38),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(122))
  call Hloop_QV_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(121),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(77),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(122),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(125))
  call Hloop_VA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(124),n2h1(126))
  call Hloop_VA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(127))
  call Hloop_VA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(128))
  call Hloop_VA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(127),n2h1(129))
  call Hloop_VA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(128),n2h1(130))
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(131))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(130),n2h1(132))
  call Hloop_VQ_A(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(133))
  call Hloop_VQ_A(ntryL,G1H2(88),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(134))
  call Hloop_VQ_A(ntryL,G1H2(89),ex3(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(133),n2h1(135))
  call Hloop_VQ_A(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(136))
  call Hloop_QV_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(137))
  call Hloop_QV_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(136),n2h1(138))
  call Hloop_QV_A(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(95),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(96),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(139),n2h1(141))
  call Hloop_QV_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(140),n2h1(142))
  call Hloop_AV_Q(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(142),n2h1(144))
  call Hloop_AV_Q(ntryL,G1H2(102),ex5(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(145))
  call Hloop_AV_Q(ntryL,G1H2(103),ex5(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(146))
  call Hloop_AV_Q(ntryL,G1H2(104),ex5(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(145),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H2(107),ex5(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(146),n2h1(148))
  call Hloop_AV_Q(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(149))
  call Hloop_AV_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(148),n2h1(150))
  call Hloop_AV_Q(ntryL,G1H2(110),ex5(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(149),n2h1(151))
  call Hloop_AV_Q(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(152))
  call Hloop_AV_Q(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(151),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H2(115),ex5(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(152),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(154),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(118),ex5(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(155),n2h1(157))
  call Hloop_VQ_A(ntryL,G1H4(5),wf4(:,4),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(158))
  call Hloop_VQ_A(ntryL,G1H4(6),wf4(:,4),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(157),n2h1(159))
  call Hloop_VQ_A(ntryL,G1H4(52),wf4(:,4),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(158),n2h1(160))
  call Hloop_VA_Q(ntryL,G1H4(53),wf4(:,11),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(161))
  call Hloop_VA_Q(ntryL,G1H4(54),wf4(:,11),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(160),n2h1(162))
  call Hloop_VA_Q(ntryL,G1H4(57),wf4(:,11),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H8(48),wf8(:,13),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(162),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H8(58),wf8(:,13),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(163),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H8(59),wf8(:,13),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(164),n2h1(166))
  call Hloop_AZ_Q(ntryL,G1H8(3),wf8(:,17),G1H1(1),ngZu,m3h8x1(:,8),heltab2x8(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(167))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf8(:,17),G1H1(1),ngZu,m3h8x1(:,9),heltab2x8(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(166),n2h1(168))
  call Hloop_AZ_Q(ntryL,G1H8(52),wf8(:,17),G1H1(1),ngZu,m3h8x1(:,10),heltab2x8(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(169))
  call Hloop_QV_A(ntryL,G1H8(2),wf8(:,13),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(168),n2h1(170))
  call Hloop_QV_A(ntryL,G1H8(4),wf8(:,13),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(169),n2h1(171))
  call Hloop_QV_A(ntryL,G1H8(14),wf8(:,13),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(170),n2h1(172))
  call Hloop_QZ_A(ntryL,G1H8(17),wf8(:,17),G1H1(1),ngZu,m3h8x1(:,14),heltab2x8(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(173))
  call Hloop_QZ_A(ntryL,G1H8(18),wf8(:,17),G1H1(1),ngZu,m3h8x1(:,15),heltab2x8(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),19,0,G2tensor(172),n2h1(174))
  call Hloop_QZ_A(ntryL,G1H8(50),wf8(:,17),G1H1(1),ngZu,m3h8x1(:,16),heltab2x8(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H8(21),wf8(:,20),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,227))



end subroutine vamp_1

end module ol_vamp_1_ppllaj_eexuuxag_1_/**/REALKIND
