
module ol_vamp_1_ppllaaj_eexddxaag_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllaaj_eexddxaag_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllaaj_eexddxaag_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppllaaj_eexddxaag_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppllaaj_eexddxaag_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppllaaj_eexddxaag_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppllaaj_eexddxaag_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(1,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,3,32,8,4,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,3,32,8,4,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,3,16,4,8,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,3),heltab2x128(:,:,3))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(3))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,3,16,4,8,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(4))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,3,32,16,4,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(5))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,3,32,16,4,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(6))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,8,4,16,3,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,7),heltab2x128(:,:,7))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(7),n2h64(7))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,8,4,16,3,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(8),n2h64(8))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,3,8,4,16,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,9),heltab2x128(:,:,9))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(9),n2h64(9))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,3,8,4,16,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(10),n2h64(10))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,16,4,8,3,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(11))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,16,4,8,3,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(12))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,3,32,4,8,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(13),n2h64(13))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,3,32,4,8,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(14))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,3,16,8,4,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(15))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,3,16,8,4,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(16),n2h64(16))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,3,16,32,4,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,17),heltab2x128(:,:,17))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(17))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,3,16,32,4,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,18),heltab2x128(:,:,18))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(18))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,8,4,32,3,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,19),heltab2x128(:,:,19))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(19),n2h64(19))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,8,4,32,3,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(20),n2h64(20))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,3,8,4,32,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,21),heltab2x128(:,:,21))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(21),n2h64(21))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,8,4,32,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(22),n2h64(22))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[64,16,3,8,4,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,23),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(23),n2h64(23))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[64,16,3,8,4,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(24),n2h64(24))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[64,3,32,16,8,4],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,25),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(25),n2h64(25))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[64,3,32,16,8,4],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,26),heltab2x128(:,:,26))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(26),n2h64(26))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[64,4,8,16,3,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(27),n2h64(27))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[64,4,8,16,3,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,28),heltab2x128(:,:,28))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(28),n2h64(28))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[64,3,16,32,8,4],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,29))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(29),n2h64(29))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[64,3,16,32,8,4],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,30))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(30),n2h64(30))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,4,8,32,3,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,31))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(31),n2h64(31))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,4,8,32,3,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,32),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(32),n2h64(32))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,4,8,3,32,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,33))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(33),n2h64(33))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,4,8,3,32,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,34))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(34),n2h64(34))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,4,8,3,16,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,35),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(35),n2h64(35))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,4,8,3,16,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,36))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(36),n2h64(36))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,3,4,8,16,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,37),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(37),n2h64(37))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,3,4,8,16,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,38),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(38),n2h64(38))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,16,8,4,3,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,39))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(39),n2h64(39))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,16,8,4,3,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,40),heltab2x128(:,:,40))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(40),n2h64(40))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,3,4,8,32,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(41),n2h64(41))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,3,4,8,32,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,42),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(42),n2h64(42))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,16,3,4,8,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,43))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(43),n2h64(43))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,16,3,4,8,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,44),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(44),n2h64(44))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,8,4,3,32,16],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,45))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(45),n2h64(45))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,8,4,3,32,16],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,46),heltab2x128(:,:,46))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(46),n2h64(46))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[64,8,4,3,16,32],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(47),n2h64(47))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[64,8,4,3,16,32],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,48),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(48),n2h64(48))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[64,4,16,3,32,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(49),m3h2x64(:,49),heltab2x128(:,:,49))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[64,4,16,3,32,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(50),m3h2x64(:,50),heltab2x128(:,:,50))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[64,4,16,32,3,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(51),m3h2x64(:,51),heltab2x128(:,:,51))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[64,4,16,32,3,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(52),m3h2x64(:,52),heltab2x128(:,:,52))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[64,4,32,3,16,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(53),m3h2x64(:,53),heltab2x128(:,:,53))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[64,4,32,3,16,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(54),m3h2x64(:,54),heltab2x128(:,:,54))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[64,4,32,16,3,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(55),m3h2x64(:,55),heltab2x128(:,:,55))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,4,32,16,3,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(56),m3h2x64(:,56),heltab2x128(:,:,56))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,4,3,32,16,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(57),m3h2x64(:,57),heltab2x128(:,:,57))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,4,3,32,16,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(58),m3h2x64(:,58),heltab2x128(:,:,58))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,4,3,16,32,8],[0,0,0,0,0,0],6,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(59),m3h2x64(:,59),heltab2x128(:,:,59))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,4,3,16,32,8],[0,0,0,0,0,0],6,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(60),m3h2x64(:,60),heltab2x128(:,:,60))
  call Hloop_QV_A(ntryL,G1H64(1),wf4(:,1),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(1),n2h16(1))
  call Hloop_QZ_A(ntryL,G1H64(2),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(2),n2h16(2))
  call Hloop_AV_Q(ntryL,G1H64(3),wf4(:,1),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(3),n2h16(3))
  call Hloop_AZ_Q(ntryL,G1H64(4),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(4),n2h16(4))
  call Hloop_AV_Q(ntryL,G1H64(5),wf4(:,1),G1H16(1),m3h4x16(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(5),n2h16(5))
  call Hloop_AZ_Q(ntryL,G1H64(6),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(6),n2h16(6))
  call Hloop_QA_V(ntryL,G1H64(7),ex4(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,7))
  call Hloop_QA_V(ntryL,G1H64(8),ex4(:),G1H32(2),m3h2x32(:,2),heltab2x64(:,:,8))
  call Hloop_QV_A(ntryL,G1H64(9),wf4(:,1),G1H16(1),m3h4x16(:,7),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(7),n2h16(7))
  call Hloop_QZ_A(ntryL,G1H64(10),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(8),n2h16(8))
  call Hloop_AV_Q(ntryL,G1H64(11),ex5(:),G1H32(3),m3h2x32(:,3),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G1H32(3),80,0,G2H32(1),n2h32(1))
  call Hloop_AV_Q(ntryL,G1H64(12),ex5(:),G1H32(3),m3h2x32(:,4),heltab2x64(:,:,12))
  call Hloop_A_Q(ntryL,G1H32(3),80,0,G2H32(2),n2h32(2))
  call Hloop_AV_Q(ntryL,G1H64(13),wf4(:,1),G1H16(1),m3h4x16(:,9),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(9),n2h16(9))
  call Hloop_AZ_Q(ntryL,G1H64(14),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,10),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(10),n2h16(10))
  call Hloop_QV_A(ntryL,G1H64(15),wf4(:,1),G1H16(1),m3h4x16(:,11),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(11),n2h16(11))
  call Hloop_QZ_A(ntryL,G1H64(16),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,12),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(12),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H64(17),wf4(:,1),G1H16(1),m3h4x16(:,13),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(13),n2h16(13))
  call Hloop_AZ_Q(ntryL,G1H64(18),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,14),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(14),n2h16(14))
  call Hloop_QA_V(ntryL,G1H64(19),ex4(:),G1H32(3),m3h2x32(:,5),heltab2x64(:,:,19))
  call Hloop_QA_V(ntryL,G1H64(20),ex4(:),G1H32(4),m3h2x32(:,6),heltab2x64(:,:,20))
  call Hloop_QV_A(ntryL,G1H64(21),wf4(:,1),G1H16(1),m3h4x16(:,15),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(15),n2h16(15))
  call Hloop_QZ_A(ntryL,G1H64(22),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,16),heltab2x64(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(16),n2h16(16))
  call Hloop_QV_A(ntryL,G1H64(23),ex5(:),G1H32(5),m3h2x32(:,7),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H32(5),80,0,G2H32(3),n2h32(3))
  call Hloop_QV_A(ntryL,G1H64(24),ex5(:),G1H32(5),m3h2x32(:,8),heltab2x64(:,:,24))
  call Hloop_Q_A(ntryL,G1H32(5),80,0,G2H32(4),n2h32(4))
  call Hloop_QV_A(ntryL,G1H64(25),wf4(:,1),G1H16(1),m3h4x16(:,17),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(17),n2h16(17))
  call Hloop_QZ_A(ntryL,G1H64(26),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,18),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(18),n2h16(18))
  call Hloop_AQ_V(ntryL,G1H64(27),ex3(:),G1H32(5),m3h2x32(:,9),heltab2x64(:,:,27))
  call Hloop_AQ_V(ntryL,G1H64(28),ex3(:),G1H32(6),m3h2x32(:,10),heltab2x64(:,:,28))
  call Hloop_QV_A(ntryL,G1H64(29),wf4(:,1),G1H16(1),m3h4x16(:,19),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(19),n2h16(19))
  call Hloop_QZ_A(ntryL,G1H64(30),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,20),heltab2x64(:,:,30))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(20),n2h16(20))
  call Hloop_AQ_V(ntryL,G1H64(31),ex3(:),G1H32(7),m3h2x32(:,11),heltab2x64(:,:,31))
  call Hloop_AQ_V(ntryL,G1H64(32),ex3(:),G1H32(8),m3h2x32(:,12),heltab2x64(:,:,32))
  call Hloop_AQ_V(ntryL,G1H64(33),ex3(:),G1H32(9),m3h2x32(:,13),heltab2x64(:,:,33))
  call Hloop_AQ_V(ntryL,G1H64(34),ex3(:),G1H32(10),m3h2x32(:,14),heltab2x64(:,:,34))
  call Hloop_AQ_V(ntryL,G1H64(35),ex3(:),G1H32(11),m3h2x32(:,15),heltab2x64(:,:,35))
  call Hloop_AQ_V(ntryL,G1H64(36),ex3(:),G1H32(12),m3h2x32(:,16),heltab2x64(:,:,36))
  call Hloop_AV_Q(ntryL,G1H64(37),wf4(:,1),G1H16(1),m3h4x16(:,21),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(21),n2h16(21))
  call Hloop_AZ_Q(ntryL,G1H64(38),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,22),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(22),n2h16(22))
  call Hloop_QV_A(ntryL,G1H64(39),ex5(:),G1H32(13),m3h2x32(:,17),heltab2x64(:,:,39))
  call Hloop_Q_A(ntryL,G1H32(13),80,0,G2H32(5),n2h32(5))
  call Hloop_QV_A(ntryL,G1H64(40),ex5(:),G1H32(13),m3h2x32(:,18),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G1H32(13),80,0,G2H32(6),n2h32(6))
  call Hloop_AV_Q(ntryL,G1H64(41),wf4(:,1),G1H16(1),m3h4x16(:,23),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(23),n2h16(23))
  call Hloop_AZ_Q(ntryL,G1H64(42),wf4(:,7),G1H16(1),ngZd,m3h4x16(:,24),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(24),n2h16(24))
  call Hloop_AV_Q(ntryL,G1H64(43),ex5(:),G1H32(13),m3h2x32(:,19),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G1H32(13),80,0,G2H32(7),n2h32(7))
  call Hloop_AV_Q(ntryL,G1H64(44),ex5(:),G1H32(13),m3h2x32(:,20),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G1H32(13),80,0,G2H32(8),n2h32(8))
  call Hloop_QA_V(ntryL,G1H64(45),ex4(:),G1H32(13),m3h2x32(:,21),heltab2x64(:,:,45))
  call Hloop_QA_V(ntryL,G1H64(46),ex4(:),G1H32(14),m3h2x32(:,22),heltab2x64(:,:,46))
  call Hloop_QA_V(ntryL,G1H64(47),ex4(:),G1H32(15),m3h2x32(:,23),heltab2x64(:,:,47))
  call Hloop_QA_V(ntryL,G1H64(48),ex4(:),G1H32(16),m3h2x32(:,24),heltab2x64(:,:,48))
  call Hloop_VQ_A(ntryL,G1H64(49),ex3(:),G1H32(17),m3h2x32(:,25),heltab2x64(:,:,49))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(9),n2h32(9))
  call Hloop_VQ_A(ntryL,G1H64(50),ex3(:),G1H32(17),m3h2x32(:,26),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(10),n2h32(10))
  call Hloop_VQ_A(ntryL,G1H64(51),ex3(:),G1H32(17),m3h2x32(:,27),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(11),n2h32(11))
  call Hloop_VQ_A(ntryL,G1H64(52),ex3(:),G1H32(17),m3h2x32(:,28),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(12),n2h32(12))
  call Hloop_VQ_A(ntryL,G1H64(53),ex3(:),G1H32(17),m3h2x32(:,29),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(13),n2h32(13))
  call Hloop_VQ_A(ntryL,G1H64(54),ex3(:),G1H32(17),m3h2x32(:,30),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(14),n2h32(14))
  call Hloop_VQ_A(ntryL,G1H64(55),ex3(:),G1H32(17),m3h2x32(:,31),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(15),n2h32(15))
  call Hloop_VQ_A(ntryL,G1H64(56),ex3(:),G1H32(17),m3h2x32(:,32),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(16),n2h32(16))
  call Hloop_VQ_A(ntryL,G1H64(57),ex3(:),G1H32(17),m3h2x32(:,33),heltab2x64(:,:,57))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(17),n2h32(17))
  call Hloop_VQ_A(ntryL,G1H64(58),ex3(:),G1H32(17),m3h2x32(:,34),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(18),n2h32(18))
  call Hloop_VQ_A(ntryL,G1H64(59),ex3(:),G1H32(17),m3h2x32(:,35),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(19),n2h32(19))
  call Hloop_VQ_A(ntryL,G1H64(60),ex3(:),G1H32(17),m3h2x32(:,36),heltab2x64(:,:,60))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(20),n2h32(20))
  call ol_merge(ntryL,G2H16(2),[G2H16(1)])
  call ol_merge(ntryL,G2H16(4),[G2H16(3)])
  call ol_merge(ntryL,G2H16(6),[G2H16(5)])
  call ol_merge(ntryL,G2H16(8),[G2H16(7)])
  call ol_merge(ntryL,G2H16(10),[G2H16(9)])
  call ol_merge(ntryL,G2H16(12),[G2H16(11)])
  call ol_merge(ntryL,G2H16(14),[G2H16(13)])
  call ol_merge(ntryL,G2H16(16),[G2H16(15)])
  call ol_merge(ntryL,G2H16(18),[G2H16(17)])
  call ol_merge(ntryL,G2H16(20),[G2H16(19)])
  call ol_merge(ntryL,G2H16(22),[G2H16(21)])
  call ol_merge(ntryL,G2H16(24),[G2H16(23)])
call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(2),16,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
call HG1shiftOLR(G1H16(8),32,16)
call Hotf_5pt_reduction(G2H16(6),RedSet_5(3),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
call HG1shiftOLR(G1H16(14),8,16)
  call Hloop_VQ_A(ntryL,G1H32(1),ex3(:),G1H16(19),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(19),76,0,G2H16(1),n2h16(25))
  call Hloop_VQ_A(ntryL,G1H32(2),ex3(:),G1H16(19),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(19),76,0,G2H16(3),n2h16(26))
  call Hloop_QA_V(ntryL,G2H16(8),ex4(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H32(1),ex3(:),G2H16(5),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_V(ntryL,G2H32(2),ex3(:),G2H16(7),m3h2x16(:,4),heltab2x32(:,:,4))
call Hotf_5pt_reduction(G2H16(10),RedSet_5(4),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
call HG1shiftOLR(G1H16(20),16,16)
call Hotf_5pt_reduction(G2H16(12),RedSet_5(5),mass5set(:,1),  & 
G1H16(25),G1H16(26),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
call HG1shiftOLR(G1H16(26),32,16)
call Hotf_5pt_reduction(G2H16(14),RedSet_5(6),mass5set(:,1),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
call HG1shiftOLR(G1H16(32),8,16)
  call Hloop_VQ_A(ntryL,G1H32(3),ex3(:),G1H16(37),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(37),76,0,G2H16(9),n2h16(27))
  call Hloop_VQ_A(ntryL,G1H32(4),ex3(:),G1H16(37),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G1H16(37),76,0,G2H16(11),n2h16(28))
  call Hloop_QA_V(ntryL,G2H16(16),ex4(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
call Hotf_5pt_reduction(G2H32(3),RedSet_5(7),mass5set(:,1),  & 
G1H32(17),G1H32(1),G1H32(2),G1H32(3),G1H32(4),G1H32(18),32)
call HG1shiftOLR(G1H32(1),32,32)
call Hotf_5pt_reduction(G2H32(4),RedSet_5(7),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
call HG1shiftOLR(G1H32(20),32,32)
call Hotf_5pt_reduction(G2H16(18),RedSet_5(3),mass5set(:,1),  & 
G1H16(37),G1H16(38),G1H16(39),G1H16(40),G1H16(41),G1H16(42),16)
call HG1shiftOLR(G1H16(38),4,16)
  call Hloop_VA_Q(ntryL,G1H32(5),ex4(:),G1H16(43),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(43),76,0,G2H16(13),n2h16(29))
  call Hloop_VA_Q(ntryL,G1H32(6),ex4(:),G1H16(43),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(43),76,0,G2H16(15),n2h16(30))
call Hotf_5pt_reduction(G2H16(20),RedSet_5(6),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
call HG1shiftOLR(G1H16(44),4,16)
  call Hloop_VA_Q(ntryL,G1H32(7),ex4(:),G1H16(49),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(49),76,0,G2H16(17),n2h16(31))
  call Hloop_VA_Q(ntryL,G1H32(8),ex4(:),G1H16(49),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(49),76,0,G2H16(19),n2h16(32))
  call Hloop_VA_Q(ntryL,G1H32(9),ex4(:),G1H16(49),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H16(49),76,0,G2H16(21),n2h16(33))
  call Hloop_VA_Q(ntryL,G1H32(10),ex4(:),G1H16(49),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(49),76,0,G2H16(23),n2h16(34))
  call Hloop_VA_Q(ntryL,G1H32(11),ex4(:),G1H16(49),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(49),76,0,G2H16(2),n2h16(35))
  call Hloop_VA_Q(ntryL,G1H32(12),ex4(:),G1H16(49),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(49),76,0,G2H16(4),n2h16(36))
  call Hloop_AQ_V(ntryL,G2H16(22),ex3(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_V(ntryL,G2H32(5),ex4(:),G2H16(6),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_QA_V(ntryL,G2H32(6),ex4(:),G2H16(8),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_AQ_V(ntryL,G2H16(24),ex3(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
call Hotf_5pt_reduction(G2H32(7),RedSet_5(8),mass5set(:,1),  & 
G1H32(5),G1H32(6),G1H32(7),G1H32(8),G1H32(9),G1H32(10),32)
call HG1shiftOLR(G1H32(6),32,32)
call Hotf_5pt_reduction(G2H32(8),RedSet_5(8),mass5set(:,1),  & 
G1H32(11),G1H32(12),G1H32(25),G1H32(26),G1H32(27),G1H32(28),32)
call HG1shiftOLR(G1H32(12),32,32)
  call Hloop_VQ_A(ntryL,G1H32(13),ex3(:),G1H16(49),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G1H16(49),76,0,G2H16(10),n2h16(37))
  call Hloop_VQ_A(ntryL,G1H32(14),ex3(:),G1H16(49),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G1H16(49),76,0,G2H16(12),n2h16(38))
  call Hloop_VQ_A(ntryL,G1H32(15),ex3(:),G1H16(49),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(49),76,0,G2H16(14),n2h16(39))
  call Hloop_VQ_A(ntryL,G1H32(16),ex3(:),G1H16(49),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(49),76,0,G2H16(16),n2h16(40))
call Hotf_5pt_reduction(G2H32(9),RedSet_5(9),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(29),G1H32(30),32)
call HG1shiftOLR(G1H32(14),8,32)
call Hotf_5pt_reduction(G2H32(10),RedSet_5(9),mass5set(:,1),  & 
G1H32(31),G1H32(32),G1H32(33),G1H32(34),G1H32(35),G1H32(36),32)
call HG1shiftOLR(G1H32(32),8,32)
call Hotf_5pt_reduction(G2H32(11),RedSet_5(10),mass5set(:,1),  & 
G1H32(37),G1H32(38),G1H32(39),G1H32(40),G1H32(41),G1H32(42),32)
call HG1shiftOLR(G1H32(38),8,32)
call Hotf_5pt_reduction(G2H32(12),RedSet_5(10),mass5set(:,1),  & 
G1H32(43),G1H32(44),G1H32(45),G1H32(46),G1H32(47),G1H32(48),32)
call HG1shiftOLR(G1H32(44),8,32)
call Hotf_5pt_reduction(G2H32(13),RedSet_5(11),mass5set(:,1),  & 
G1H32(49),G1H32(50),G1H32(51),G1H32(52),G1H32(53),G1H32(54),32)
call HG1shiftOLR(G1H32(50),8,32)
call Hotf_5pt_reduction(G2H32(14),RedSet_5(11),mass5set(:,1),  & 
G1H32(55),G1H32(56),G1H32(57),G1H32(58),G1H32(59),G1H32(60),32)
call HG1shiftOLR(G1H32(56),8,32)
call Hotf_5pt_reduction(G2H32(15),RedSet_5(12),mass5set(:,1),  & 
G1H32(61),G1H32(62),G1H32(63),G1H32(64),G1H32(65),G1H32(66),32)
call HG1shiftOLR(G1H32(62),8,32)
call Hotf_5pt_reduction(G2H32(16),RedSet_5(12),mass5set(:,1),  & 
G1H32(67),G1H32(68),G1H32(69),G1H32(70),G1H32(71),G1H32(72),32)
call HG1shiftOLR(G1H32(68),8,32)
call Hotf_5pt_reduction(G2H32(17),RedSet_5(13),mass5set(:,1),  & 
G1H32(73),G1H32(74),G1H32(75),G1H32(76),G1H32(77),G1H32(78),32)
call HG1shiftOLR(G1H32(74),8,32)
call Hotf_5pt_reduction(G2H32(18),RedSet_5(13),mass5set(:,1),  & 
G1H32(79),G1H32(80),G1H32(81),G1H32(82),G1H32(83),G1H32(84),32)
call HG1shiftOLR(G1H32(80),8,32)
call Hotf_5pt_reduction(G2H32(19),RedSet_5(14),mass5set(:,1),  & 
G1H32(85),G1H32(86),G1H32(87),G1H32(88),G1H32(89),G1H32(90),32)
call HG1shiftOLR(G1H32(86),8,32)
call Hotf_5pt_reduction(G2H32(20),RedSet_5(14),mass5set(:,1),  & 
G1H32(91),G1H32(92),G1H32(93),G1H32(94),G1H32(95),G1H32(96),32)
call HG1shiftOLR(G1H32(92),8,32)
  call Hloop_QV_A(ntryL,G1H16(1),ex6(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(5),n2h8(1))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-16,0,G2H16(18),n2h16(41))
  call Hloop_AV_Q(ntryL,G2H16(18),ex5(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QV_A(ntryL,G1H16(4),ex6(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(7),n2h8(2))
  call Hloop_QV_A(ntryL,G1H16(5),ex6(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(8),n2h8(3))
  call Hloop_QV_A(ntryL,G1H16(6),ex6(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(9),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(7),ex5(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(10),n2h8(5))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(8),-32,0,G2H16(20),n2h16(42))
  call Hloop_QV_A(ntryL,G2H16(20),ex6(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AV_Q(ntryL,G1H16(10),ex5(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(12),n2h8(6))
  call Hloop_AV_Q(ntryL,G1H16(11),ex5(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(13),n2h8(7))
  call Hloop_AV_Q(ntryL,G1H16(12),ex5(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(14),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H16(13),ex6(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(15),n2h8(9))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(14),-8,0,G2H16(22),n2h16(43))
  call Hloop_QA_V(ntryL,G2H16(22),ex4(:),G2H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AV_Q(ntryL,G1H16(16),ex6(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(17),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H16(17),ex6(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(18),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H16(18),ex6(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(19),n2h8(12))
  call Hloop_AV_Q(ntryL,G1H16(19),ex6(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(20),n2h8(13))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-16,0,G2H16(24),n2h16(44))
  call Hloop_QV_A(ntryL,G2H16(24),ex5(:),G2H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AV_Q(ntryL,G1H16(22),ex6(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(22),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(23),ex6(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(23),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(24),ex6(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(24),n2h8(16))
  call Hloop_QV_A(ntryL,G1H16(25),ex5(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(25),n2h8(17))
call HGT_OLR(G1H16(26),1,1,16)
call HGT_invQ_OLR(G1H16(26),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(26),-32,0,G2H16(18),n2h16(45))
  call Hloop_AV_Q(ntryL,G2H16(18),ex6(:),G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_QV_A(ntryL,G1H16(28),ex5(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(27),n2h8(18))
  call Hloop_QV_A(ntryL,G1H16(29),ex5(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(28),n2h8(19))
  call Hloop_QV_A(ntryL,G1H16(30),ex5(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(29),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(31),ex5(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(30),n2h8(21))
call HGT_OLR(G1H16(32),1,1,16)
call HGT_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(32),-8,0,G2H16(20),n2h16(46))
  call Hloop_QA_V(ntryL,G2H16(20),ex4(:),G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AV_Q(ntryL,G1H16(34),ex5(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(32),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H16(35),ex5(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(33),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(36),ex5(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(34),n2h8(24))
  call Hloop_QV_A(ntryL,G1H32(17),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(35),n2h8(25))
call HGT_OLR(G1H32(1),1,1,32)
call HGT_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_A_Q(ntryL,G1H32(1),-32,0,G2H32(1),n2h32(21))
  call Hloop_AV_Q(ntryL,G2H32(1),ex6(:),G2H16(22),m3h2x16(:,21),heltab2x32(:,:,22))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,1),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(36),n2h8(26))
  call Hloop_QV_A(ntryL,G1H32(4),wf4(:,1),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(37),n2h8(27))
  call Hloop_QV_A(ntryL,G1H32(18),wf4(:,1),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(38),n2h8(28))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,5),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(39),n2h8(29))
call HGT_OLR(G1H32(20),1,1,32)
call HGT_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_A_Q(ntryL,G1H32(20),-32,0,G2H32(2),n2h32(22))
  call Hloop_AV_Q(ntryL,G2H32(2),ex6(:),G2H16(24),m3h2x16(:,22),heltab2x32(:,:,27))
  call Hloop_QZ_A(ntryL,G1H32(22),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,6),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(40),n2h8(30))
  call Hloop_QZ_A(ntryL,G1H32(23),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,7),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(41),n2h8(31))
  call Hloop_QZ_A(ntryL,G1H32(24),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(42),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(37),ex6(:),G1H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(43),n2h8(33))
call HGT_OLR(G1H16(38),1,1,16)
call HGT_invQ_OLR(G1H16(38),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(38),-4,0,G2H16(18),n2h16(47))
  call Hloop_AQ_V(ntryL,G2H16(18),ex3(:),G2H8(44),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_QV_A(ntryL,G1H16(40),ex6(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(45),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(41),ex6(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(46),n2h8(35))
  call Hloop_QV_A(ntryL,G1H16(42),ex6(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),99,0,G2H8(47),n2h8(36))
  call Hloop_QV_A(ntryL,G1H16(43),ex5(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(48),n2h8(37))
call HGT_OLR(G1H16(44),1,1,16)
call HGT_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(44),-4,0,G2H16(20),n2h16(48))
  call Hloop_AQ_V(ntryL,G2H16(20),ex3(:),G2H8(49),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_QV_A(ntryL,G1H16(46),ex5(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(50),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(47),ex5(:),G1H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(51),n2h8(39))
  call Hloop_QV_A(ntryL,G1H16(48),ex5(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(1),83,0,G2H8(52),n2h8(40))
  call Hloop_AV_Q(ntryL,G1H32(5),wf4(:,1),G1H8(1),m3h4x8(:,9),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(53),n2h8(41))
call HGT_OLR(G1H32(6),1,1,32)
call HGT_invQ_OLR(G1H32(6),2,5,32)
  call Hloop_Q_A(ntryL,G1H32(6),-32,0,G2H32(3),n2h32(23))
  call Hloop_QV_A(ntryL,G2H32(3),ex6(:),G2H16(18),m3h2x16(:,23),heltab2x32(:,:,32))
  call Hloop_AV_Q(ntryL,G1H32(8),wf4(:,1),G1H8(1),m3h4x8(:,10),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(54),n2h8(42))
  call Hloop_AV_Q(ntryL,G1H32(9),wf4(:,1),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(55),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H32(10),wf4(:,1),G1H8(1),m3h4x8(:,12),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(56),n2h8(44))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,13),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(57),n2h8(45))
call HGT_OLR(G1H32(12),1,1,32)
call HGT_invQ_OLR(G1H32(12),2,5,32)
  call Hloop_Q_A(ntryL,G1H32(12),-32,0,G2H32(4),n2h32(24))
  call Hloop_QV_A(ntryL,G2H32(4),ex6(:),G2H16(20),m3h2x16(:,24),heltab2x32(:,:,37))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,14),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(58),n2h8(46))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,15),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(59),n2h8(47))
  call Hloop_AZ_Q(ntryL,G1H32(28),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,16),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(1),83,0,G2H8(60),n2h8(48))
  call Hloop_QV_A(ntryL,G1H32(13),ex5(:),G1H16(49),m3h2x16(:,25),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H16(49),84,0,G2H16(25),n2h16(49))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(14),ex4(:),G1H16(1),m3h2x16(:,26),heltab2x32(:,:,42))
  call Hloop_QV_A(ntryL,G1H32(16),ex5(:),G1H16(2),m3h2x16(:,27),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(2),84,0,G2H16(26),n2h16(50))
  call Hloop_QV_A(ntryL,G1H32(29),ex5(:),G1H16(4),m3h2x16(:,28),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(4),84,0,G2H16(27),n2h16(51))
  call Hloop_QV_A(ntryL,G1H32(30),ex5(:),G1H16(5),m3h2x16(:,29),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H16(5),84,0,G2H16(28),n2h16(52))
  call Hloop_QV_A(ntryL,G1H32(31),ex5(:),G1H16(6),m3h2x16(:,30),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(6),84,0,G2H16(29),n2h16(53))
call HGT_raise_alpha_OLR(G1H32(32),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(32),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(32),ex4(:),G1H16(7),m3h2x16(:,31),heltab2x32(:,:,47))
  call Hloop_QV_A(ntryL,G1H32(34),ex5(:),G1H16(8),m3h2x16(:,32),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(8),84,0,G2H16(30),n2h16(54))
  call Hloop_QV_A(ntryL,G1H32(35),ex5(:),G1H16(10),m3h2x16(:,33),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H16(10),84,0,G2H16(31),n2h16(55))
  call Hloop_QV_A(ntryL,G1H32(36),ex5(:),G1H16(11),m3h2x16(:,34),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H16(11),84,0,G2H16(32),n2h16(56))
  call Hloop_QV_A(ntryL,G1H32(37),ex5(:),G1H16(12),m3h2x16(:,35),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H16(12),84,0,G2H16(33),n2h16(57))
call HGT_raise_alpha_OLR(G1H32(38),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(38),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(38),ex4(:),G1H16(13),m3h2x16(:,36),heltab2x32(:,:,52))
  call Hloop_QV_A(ntryL,G1H32(40),ex5(:),G1H16(14),m3h2x16(:,37),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H16(14),84,0,G2H16(34),n2h16(58))
  call Hloop_QV_A(ntryL,G1H32(41),ex5(:),G1H16(16),m3h2x16(:,38),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G1H16(16),84,0,G2H16(35),n2h16(59))
  call Hloop_QV_A(ntryL,G1H32(42),ex5(:),G1H16(17),m3h2x16(:,39),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(17),84,0,G2H16(36),n2h16(60))
  call Hloop_QV_A(ntryL,G1H32(43),ex5(:),G1H16(18),m3h2x16(:,40),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G1H16(18),84,0,G2H16(37),n2h16(61))
call HGT_raise_alpha_OLR(G1H32(44),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(44),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(44),ex4(:),G1H16(19),m3h2x16(:,41),heltab2x32(:,:,57))
  call Hloop_QV_A(ntryL,G1H32(46),ex5(:),G1H16(20),m3h2x16(:,42),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G1H16(20),84,0,G2H16(38),n2h16(62))
  call Hloop_QV_A(ntryL,G1H32(47),ex5(:),G1H16(22),m3h2x16(:,43),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G1H16(22),84,0,G2H16(39),n2h16(63))
  call Hloop_QV_A(ntryL,G1H32(48),ex5(:),G1H16(23),m3h2x16(:,44),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G1H16(23),84,0,G2H16(40),n2h16(64))
  call Hloop_QV_A(ntryL,G1H32(49),ex6(:),G1H16(24),m3h2x16(:,45),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H16(24),100,0,G2H16(41),n2h16(65))
call HGT_raise_alpha_OLR(G1H32(50),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(50),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(50),ex4(:),G1H16(25),m3h2x16(:,46),heltab2x32(:,:,62))
  call Hloop_QV_A(ntryL,G1H32(52),ex6(:),G1H16(26),m3h2x16(:,47),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G1H16(26),100,0,G2H16(42),n2h16(66))
  call Hloop_QV_A(ntryL,G1H32(53),ex6(:),G1H16(28),m3h2x16(:,48),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G1H16(28),100,0,G2H16(43),n2h16(67))
  call Hloop_QV_A(ntryL,G1H32(54),ex6(:),G1H16(29),m3h2x16(:,49),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G1H16(29),100,0,G2H16(44),n2h16(68))
  call Hloop_QV_A(ntryL,G1H32(55),ex6(:),G1H16(30),m3h2x16(:,50),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G1H16(30),100,0,G2H16(45),n2h16(69))
call HGT_raise_alpha_OLR(G1H32(56),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(56),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(56),ex4(:),G1H16(31),m3h2x16(:,51),heltab2x32(:,:,67))
  call Hloop_QV_A(ntryL,G1H32(58),ex6(:),G1H16(32),m3h2x16(:,52),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G1H16(32),100,0,G2H16(46),n2h16(70))
  call Hloop_QV_A(ntryL,G1H32(59),ex6(:),G1H16(34),m3h2x16(:,53),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G1H16(34),100,0,G2H16(47),n2h16(71))
  call Hloop_QV_A(ntryL,G1H32(60),ex6(:),G1H16(35),m3h2x16(:,54),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G1H16(35),100,0,G2H16(48),n2h16(72))
  call Hloop_QV_A(ntryL,G1H32(61),ex6(:),G1H16(36),m3h2x16(:,55),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G1H16(36),100,0,G2H16(49),n2h16(73))
call HGT_raise_alpha_OLR(G1H32(62),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(62),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(62),ex4(:),G1H16(37),m3h2x16(:,56),heltab2x32(:,:,72))
  call Hloop_QV_A(ntryL,G1H32(64),ex6(:),G1H16(38),m3h2x16(:,57),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H16(38),100,0,G2H16(50),n2h16(74))
  call Hloop_QV_A(ntryL,G1H32(65),ex6(:),G1H16(40),m3h2x16(:,58),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(40),100,0,G2H16(51),n2h16(75))
  call Hloop_QV_A(ntryL,G1H32(66),ex6(:),G1H16(41),m3h2x16(:,59),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H16(41),100,0,G2H16(52),n2h16(76))
  call Hloop_QV_A(ntryL,G1H32(67),ex6(:),G1H16(42),m3h2x16(:,60),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(42),100,0,G2H16(53),n2h16(77))
call HGT_raise_alpha_OLR(G1H32(68),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(68),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(68),ex4(:),G1H16(43),m3h2x16(:,61),heltab2x32(:,:,77))
  call Hloop_QV_A(ntryL,G1H32(70),ex6(:),G1H16(44),m3h2x16(:,62),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H16(44),100,0,G2H16(54),n2h16(78))
  call Hloop_QV_A(ntryL,G1H32(71),ex6(:),G1H16(46),m3h2x16(:,63),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H16(46),100,0,G2H16(55),n2h16(79))
  call Hloop_QV_A(ntryL,G1H32(72),ex6(:),G1H16(47),m3h2x16(:,64),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G1H16(47),100,0,G2H16(56),n2h16(80))
  call Hloop_QV_A(ntryL,G1H32(73),wf4(:,1),G1H8(1),m3h4x8(:,17),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(61),n2h8(49))
call HGT_raise_alpha_OLR(G1H32(74),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(74),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(74),ex4(:),G1H16(48),m3h2x16(:,65),heltab2x32(:,:,82))
  call Hloop_QV_A(ntryL,G1H32(76),wf4(:,1),G1H8(1),m3h4x8(:,18),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(62),n2h8(50))
  call Hloop_QV_A(ntryL,G1H32(77),wf4(:,1),G1H8(1),m3h4x8(:,19),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(63),n2h8(51))
  call Hloop_QV_A(ntryL,G1H32(78),wf4(:,1),G1H8(1),m3h4x8(:,20),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(64),n2h8(52))
  call Hloop_QZ_A(ntryL,G1H32(79),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,21),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(65),n2h8(53))
call HGT_raise_alpha_OLR(G1H32(80),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(80),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(80),ex4(:),G1H16(49),m3h2x16(:,66),heltab2x32(:,:,87))
  call Hloop_QZ_A(ntryL,G1H32(82),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,22),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(66),n2h8(54))
  call Hloop_QZ_A(ntryL,G1H32(83),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,23),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(67),n2h8(55))
  call Hloop_QZ_A(ntryL,G1H32(84),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,24),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(68),n2h8(56))
  call Hloop_QV_A(ntryL,G1H32(85),wf4(:,1),G1H8(1),m3h4x8(:,25),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(69),n2h8(57))
call HGT_raise_alpha_OLR(G1H32(86),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(86),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(86),ex4(:),G1H16(2),m3h2x16(:,67),heltab2x32(:,:,92))
  call Hloop_QV_A(ntryL,G1H32(88),wf4(:,1),G1H8(1),m3h4x8(:,26),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(70),n2h8(58))
  call Hloop_QV_A(ntryL,G1H32(89),wf4(:,1),G1H8(1),m3h4x8(:,27),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(71),n2h8(59))
  call Hloop_QV_A(ntryL,G1H32(90),wf4(:,1),G1H8(1),m3h4x8(:,28),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(72),n2h8(60))
  call Hloop_QZ_A(ntryL,G1H32(91),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,29),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(73),n2h8(61))
call HGT_raise_alpha_OLR(G1H32(92),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(92),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(92),ex4(:),G1H16(4),m3h2x16(:,68),heltab2x32(:,:,97))
  call Hloop_QZ_A(ntryL,G1H32(94),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,30),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(74),n2h8(62))
  call Hloop_QZ_A(ntryL,G1H32(95),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,31),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(75),n2h8(63))
  call Hloop_QZ_A(ntryL,G1H32(96),wf4(:,7),G1H8(1),ngZd,m3h4x8(:,32),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(76),n2h8(64))
  call ol_merge(ntryL,G2H8(39),[G2H8(35)])
  call ol_merge(ntryL,G2H8(41),[G2H8(37)])
  call ol_merge(ntryL,G2H8(42),[G2H8(38)])
  call ol_merge(ntryL,G2H8(57),[G2H8(53)])
  call ol_merge(ntryL,G2H8(59),[G2H8(55)])
  call ol_merge(ntryL,G2H8(60),[G2H8(56)])
  call ol_merge(ntryL,G2H8(65),[G2H8(61)])
  call ol_merge(ntryL,G2H8(67),[G2H8(63)])
  call ol_merge(ntryL,G2H8(68),[G2H8(64)])
  call ol_merge(ntryL,G2H8(73),[G2H8(69)])
  call ol_merge(ntryL,G2H8(75),[G2H8(71)])
  call ol_merge(ntryL,G2H8(76),[G2H8(72)])
call Hotf_5pt_reduction(G2H16(1),RedSet_5(15),mass5set(:,1),  & 
G1H16(5),G1H16(6),G1H16(8),G1H16(10),G1H16(11),G1H16(12),16)
call HG1shiftOLR(G1H16(6),32,16)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(15),mass5set(:,1),  & 
G1H16(14),G1H16(16),G1H16(17),G1H16(18),G1H16(20),G1H16(22),16)
call HG1shiftOLR(G1H16(16),32,16)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(16),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),32,8)
call Hotf_5pt_reduction(G2H16(5),RedSet_5(17),mass5set(:,1),  & 
G1H16(23),G1H16(24),G1H16(26),G1H16(28),G1H16(29),G1H16(30),16)
call HG1shiftOLR(G1H16(24),32,16)
call Hotf_5pt_reduction(G2H16(7),RedSet_5(17),mass5set(:,1),  & 
G1H16(32),G1H16(34),G1H16(35),G1H16(36),G1H16(38),G1H16(40),16)
call HG1shiftOLR(G1H16(34),32,16)
call Hotf_5pt_reduction(G2H16(9),RedSet_5(18),mass5set(:,1),  & 
G1H16(41),G1H16(42),G1H16(44),G1H16(46),G1H16(47),G1H16(50),16)
call HG1shiftOLR(G1H16(42),16,16)
call Hotf_5pt_reduction(G2H16(11),RedSet_5(18),mass5set(:,1),  & 
G1H16(51),G1H16(52),G1H16(53),G1H16(54),G1H16(55),G1H16(56),16)
call HG1shiftOLR(G1H16(52),16,16)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(16),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),16,8)
call Hotf_5pt_reduction(G2H16(13),RedSet_5(19),mass5set(:,1),  & 
G1H16(57),G1H16(58),G1H16(59),G1H16(60),G1H16(61),G1H16(62),16)
call HG1shiftOLR(G1H16(58),32,16)
call Hotf_5pt_reduction(G2H16(15),RedSet_5(19),mass5set(:,1),  & 
G1H16(63),G1H16(64),G1H16(65),G1H16(66),G1H16(67),G1H16(68),16)
call HG1shiftOLR(G1H16(64),32,16)
call Hotf_5pt_reduction(G2H16(17),RedSet_5(20),mass5set(:,1),  & 
G1H16(69),G1H16(70),G1H16(71),G1H16(72),G1H16(73),G1H16(74),16)
call HG1shiftOLR(G1H16(70),16,16)
call Hotf_5pt_reduction(G2H16(19),RedSet_5(20),mass5set(:,1),  & 
G1H16(75),G1H16(76),G1H16(77),G1H16(78),G1H16(79),G1H16(80),16)
call HG1shiftOLR(G1H16(76),16,16)
call Hotf_5pt_reduction(G2H16(21),RedSet_5(21),mass5set(:,1),  & 
G1H16(81),G1H16(82),G1H16(83),G1H16(84),G1H16(85),G1H16(86),16)
call HG1shiftOLR(G1H16(82),16,16)
call Hotf_5pt_reduction(G2H16(23),RedSet_5(21),mass5set(:,1),  & 
G1H16(87),G1H16(88),G1H16(89),G1H16(90),G1H16(91),G1H16(92),16)
call HG1shiftOLR(G1H16(88),16,16)
call Hotf_5pt_reduction(G2H16(2),RedSet_5(21),mass5set(:,1),  & 
G1H16(93),G1H16(94),G1H16(95),G1H16(96),G1H16(97),G1H16(98),16)
call HG1shiftOLR(G1H16(94),32,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(21),mass5set(:,1),  & 
G1H16(99),G1H16(100),G1H16(101),G1H16(102),G1H16(103),G1H16(104),16)
call HG1shiftOLR(G1H16(100),32,16)
call Hotf_5pt_reduction(G2H8(3),RedSet_5(22),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(14),32,8)
call Hotf_5pt_reduction(G2H16(6),RedSet_5(23),mass5set(:,1),  & 
G1H16(105),G1H16(106),G1H16(107),G1H16(108),G1H16(109),G1H16(110),16)
call HG1shiftOLR(G1H16(106),32,16)
call Hotf_5pt_reduction(G2H16(8),RedSet_5(23),mass5set(:,1),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G1H16(116),16)
call HG1shiftOLR(G1H16(112),32,16)
call Hotf_5pt_reduction(G2H8(4),RedSet_5(22),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
call HG1shiftOLR(G1H8(20),16,8)
call Hotf_5pt_reduction(G2H16(10),RedSet_5(24),mass5set(:,1),  & 
G1H16(117),G1H16(118),G1H16(119),G1H16(120),G1H16(121),G1H16(122),16)
call HG1shiftOLR(G1H16(118),16,16)
call Hotf_5pt_reduction(G2H16(12),RedSet_5(24),mass5set(:,1),  & 
G1H16(123),G1H16(124),G1H16(125),G1H16(126),G1H16(127),G1H16(128),16)
call HG1shiftOLR(G1H16(124),16,16)
call Hotf_5pt_reduction(G2H16(14),RedSet_5(24),mass5set(:,1),  & 
G1H16(129),G1H16(130),G1H16(131),G1H16(132),G1H16(133),G1H16(134),16)
call HG1shiftOLR(G1H16(130),32,16)
call Hotf_5pt_reduction(G2H16(16),RedSet_5(24),mass5set(:,1),  & 
G1H16(135),G1H16(136),G1H16(137),G1H16(138),G1H16(139),G1H16(140),16)
call HG1shiftOLR(G1H16(136),32,16)
  call Hloop_QA_V(ntryL,G2H8(5),ex4(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(8),ex4(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_V(ntryL,G2H8(9),ex4(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(10),ex3(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(13),ex3(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(14),ex3(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
call Hotf_5pt_reduction(G2H8(15),RedSet_5(3),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(26),8,8)
call Hotf_5pt_reduction(G2H8(18),RedSet_5(25),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
call HG1shiftOLR(G1H8(32),8,8)
call Hotf_5pt_reduction(G2H8(19),RedSet_5(26),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_AQ_V(ntryL,G2H8(20),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(23),ex3(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H8(24),ex3(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(25),ex4(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(28),ex4(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(29),ex4(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
call Hotf_5pt_reduction(G2H8(30),RedSet_5(6),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
call HG1shiftOLR(G1H8(44),8,8)
call Hotf_5pt_reduction(G2H8(33),RedSet_5(25),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
call HG1shiftOLR(G1H8(50),8,8)
call Hotf_5pt_reduction(G2H8(34),RedSet_5(27),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
call HG1shiftOLR(G1H8(56),8,8)
  call Hloop_QA_V(ntryL,G2H8(39),ex4(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(41),ex4(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(42),ex4(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
call Hotf_5pt_reduction(G2H8(43),RedSet_5(3),mass5set(:,1),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
call HG1shiftOLR(G1H8(62),4,8)
call Hotf_5pt_reduction(G2H8(46),RedSet_5(28),mass5set(:,1),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
call HG1shiftOLR(G1H8(68),4,8)
call Hotf_5pt_reduction(G2H8(47),RedSet_5(29),mass5set(:,1),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
call HG1shiftOLR(G1H8(74),4,8)
call Hotf_5pt_reduction(G2H8(48),RedSet_5(6),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
call HG1shiftOLR(G1H8(80),4,8)
call Hotf_5pt_reduction(G2H8(51),RedSet_5(28),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
call HG1shiftOLR(G1H8(86),4,8)
call Hotf_5pt_reduction(G2H8(52),RedSet_5(30),mass5set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
call HG1shiftOLR(G1H8(92),4,8)
  call Hloop_AQ_V(ntryL,G2H8(57),ex3(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(59),ex3(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(60),ex3(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
call Hotf_5pt_reduction(G2H16(25),RedSet_5(9),mass5set(:,1),  & 
G1H16(141),G1H16(142),G1H16(143),G1H16(144),G1H16(145),G1H16(146),16)
call HG1shiftOLR(G1H16(142),8,16)
call Hotf_5pt_reduction(G2H16(27),RedSet_5(31),mass5set(:,1),  & 
G1H16(147),G1H16(148),G1H16(149),G1H16(150),G1H16(151),G1H16(152),16)
call HG1shiftOLR(G1H16(148),8,16)
call Hotf_5pt_reduction(G2H16(28),RedSet_5(32),mass5set(:,1),  & 
G1H16(153),G1H16(154),G1H16(155),G1H16(156),G1H16(157),G1H16(158),16)
call HG1shiftOLR(G1H16(154),8,16)
call Hotf_5pt_reduction(G2H16(29),RedSet_5(9),mass5set(:,1),  & 
G1H16(159),G1H16(160),G1H16(161),G1H16(162),G1H16(163),G1H16(164),16)
call HG1shiftOLR(G1H16(160),8,16)
call Hotf_5pt_reduction(G2H16(31),RedSet_5(31),mass5set(:,1),  & 
G1H16(165),G1H16(166),G1H16(167),G1H16(168),G1H16(169),G1H16(170),16)
call HG1shiftOLR(G1H16(166),8,16)
call Hotf_5pt_reduction(G2H16(32),RedSet_5(32),mass5set(:,1),  & 
G1H16(171),G1H16(172),G1H16(173),G1H16(174),G1H16(175),G1H16(176),16)
call HG1shiftOLR(G1H16(172),8,16)
call Hotf_5pt_reduction(G2H16(33),RedSet_5(10),mass5set(:,1),  & 
G1H16(177),G1H16(178),G1H16(179),G1H16(180),G1H16(181),G1H16(182),16)
call HG1shiftOLR(G1H16(178),8,16)
call Hotf_5pt_reduction(G2H16(35),RedSet_5(33),mass5set(:,1),  & 
G1H16(183),G1H16(184),G1H16(185),G1H16(186),G1H16(187),G1H16(188),16)
call HG1shiftOLR(G1H16(184),8,16)
call Hotf_5pt_reduction(G2H16(36),RedSet_5(32),mass5set(:,1),  & 
G1H16(189),G1H16(190),G1H16(191),G1H16(192),G1H16(193),G1H16(194),16)
call HG1shiftOLR(G1H16(190),8,16)
call Hotf_5pt_reduction(G2H16(37),RedSet_5(10),mass5set(:,1),  & 
G1H16(195),G1H16(196),G1H16(197),G1H16(198),G1H16(199),G1H16(200),16)
call HG1shiftOLR(G1H16(196),8,16)
call Hotf_5pt_reduction(G2H16(39),RedSet_5(33),mass5set(:,1),  & 
G1H16(201),G1H16(202),G1H16(203),G1H16(204),G1H16(205),G1H16(206),16)
call HG1shiftOLR(G1H16(202),8,16)
call Hotf_5pt_reduction(G2H16(40),RedSet_5(32),mass5set(:,1),  & 
G1H16(207),G1H16(208),G1H16(209),G1H16(210),G1H16(211),G1H16(212),16)
call HG1shiftOLR(G1H16(208),8,16)
call Hotf_5pt_reduction(G2H16(41),RedSet_5(11),mass5set(:,1),  & 
G1H16(213),G1H16(214),G1H16(215),G1H16(216),G1H16(217),G1H16(218),16)
call HG1shiftOLR(G1H16(214),8,16)
call Hotf_5pt_reduction(G2H16(43),RedSet_5(34),mass5set(:,1),  & 
G1H16(219),G1H16(220),G1H16(221),G1H16(222),G1H16(223),G1H16(224),16)
call HG1shiftOLR(G1H16(220),8,16)
call Hotf_5pt_reduction(G2H16(44),RedSet_5(35),mass5set(:,1),  & 
G1H16(225),G1H16(226),G1H16(227),G1H16(228),G1H16(229),G1H16(230),16)
call HG1shiftOLR(G1H16(226),8,16)
call Hotf_5pt_reduction(G2H16(45),RedSet_5(11),mass5set(:,1),  & 
G1H16(231),G1H16(232),G1H16(233),G1H16(234),G1H16(235),G1H16(236),16)
call HG1shiftOLR(G1H16(232),8,16)
call Hotf_5pt_reduction(G2H16(47),RedSet_5(34),mass5set(:,1),  & 
G1H16(237),G1H16(238),G1H16(239),G1H16(240),G1H16(241),G1H16(242),16)
call HG1shiftOLR(G1H16(238),8,16)
call Hotf_5pt_reduction(G2H16(48),RedSet_5(35),mass5set(:,1),  & 
G1H16(243),G1H16(244),G1H16(245),G1H16(246),G1H16(247),G1H16(248),16)
call HG1shiftOLR(G1H16(244),8,16)
call Hotf_5pt_reduction(G2H16(49),RedSet_5(12),mass5set(:,1),  & 
G1H16(249),G1H16(250),G1H16(251),G1H16(252),G1H16(253),G1H16(254),16)
call HG1shiftOLR(G1H16(250),8,16)
call Hotf_5pt_reduction(G2H16(51),RedSet_5(33),mass5set(:,1),  & 
G1H16(255),G1H16(256),G1H16(257),G1H16(258),G1H16(259),G1H16(260),16)
call HG1shiftOLR(G1H16(256),8,16)
call Hotf_5pt_reduction(G2H16(52),RedSet_5(35),mass5set(:,1),  & 
G1H16(261),G1H16(262),G1H16(263),G1H16(264),G1H16(265),G1H16(266),16)
call HG1shiftOLR(G1H16(262),8,16)
call Hotf_5pt_reduction(G2H16(53),RedSet_5(12),mass5set(:,1),  & 
G1H16(267),G1H16(268),G1H16(269),G1H16(270),G1H16(271),G1H16(272),16)
call HG1shiftOLR(G1H16(268),8,16)
call Hotf_5pt_reduction(G2H16(55),RedSet_5(33),mass5set(:,1),  & 
G1H16(273),G1H16(274),G1H16(275),G1H16(276),G1H16(277),G1H16(278),16)
call HG1shiftOLR(G1H16(274),8,16)
call Hotf_5pt_reduction(G2H16(56),RedSet_5(35),mass5set(:,1),  & 
G1H16(279),G1H16(280),G1H16(281),G1H16(282),G1H16(283),G1H16(284),16)
call HG1shiftOLR(G1H16(280),8,16)
call Hotf_5pt_reduction(G2H8(65),RedSet_5(13),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
call HG1shiftOLR(G1H8(98),8,8)
call Hotf_5pt_reduction(G2H8(67),RedSet_5(34),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
call HG1shiftOLR(G1H8(104),8,8)
call Hotf_5pt_reduction(G2H8(68),RedSet_5(36),mass5set(:,1),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
call HG1shiftOLR(G1H8(110),8,8)
call Hotf_5pt_reduction(G2H8(73),RedSet_5(14),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
call HG1shiftOLR(G1H8(116),8,8)
call Hotf_5pt_reduction(G2H8(75),RedSet_5(31),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
call HG1shiftOLR(G1H8(122),8,8)
call Hotf_5pt_reduction(G2H8(76),RedSet_5(36),mass5set(:,1),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
call HG1shiftOLR(G1H8(128),8,8)
  call ol_merge(ntryL,G1H8(31),[G1H8(29)])
  call ol_merge(ntryL,G1H8(37),[G1H8(30)])
  call ol_merge(ntryL,G1H8(49),[G1H8(47)])
  call ol_merge(ntryL,G1H8(55),[G1H8(48)])
  call ol_merge(ntryL,G1H8(67),[G1H8(65)])
  call ol_merge(ntryL,G1H8(73),[G1H8(66)])
  call ol_merge(ntryL,G1H8(85),[G1H8(83)])
  call ol_merge(ntryL,G1H8(91),[G1H8(84)])
  call ol_merge(ntryL,G1H16(147),[G1H16(145)])
  call ol_merge(ntryL,G1H16(153),[G1H16(146)])
  call ol_merge(ntryL,G1H16(165),[G1H16(163)])
  call ol_merge(ntryL,G1H16(171),[G1H16(164)])
  call ol_merge(ntryL,G1H16(183),[G1H16(181)])
  call ol_merge(ntryL,G1H16(189),[G1H16(182)])
  call ol_merge(ntryL,G1H16(201),[G1H16(199)])
  call ol_merge(ntryL,G1H16(207),[G1H16(200)])
  call ol_merge(ntryL,G1H16(219),[G1H16(217)])
  call ol_merge(ntryL,G1H16(225),[G1H16(218)])
  call ol_merge(ntryL,G1H16(237),[G1H16(235)])
  call ol_merge(ntryL,G1H16(243),[G1H16(236)])
  call ol_merge(ntryL,G1H16(255),[G1H16(253)])
  call ol_merge(ntryL,G1H16(261),[G1H16(254)])
  call ol_merge(ntryL,G1H16(273),[G1H16(271)])
  call ol_merge(ntryL,G1H16(279),[G1H16(272)])
  call ol_merge(ntryL,G1H8(103),[G1H8(101)])
  call ol_merge(ntryL,G1H8(109),[G1H8(102)])
  call ol_merge(ntryL,G1H8(121),[G1H8(119)])
  call ol_merge(ntryL,G1H8(127),[G1H8(120)])
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(29),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(29),92,0,G2H8(35),n2h8(65))
call HGT_OLR(G1H16(6),1,1,16)
call HGT_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(6),-32,0,G2H16(1),n2h16(81))
  call Hloop_AV_Q(ntryL,G2H16(1),ex6(:),G2H8(37),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(30),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(30),92,0,G2H8(38),n2h8(66))
  call Hloop_QV_A(ntryL,G1H16(12),ex5(:),G1H8(47),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(47),92,0,G2H8(53),n2h8(67))
  call Hloop_QV_A(ntryL,G1H16(14),ex5(:),G1H8(48),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(48),92,0,G2H8(55),n2h8(68))
call HGT_OLR(G1H16(16),1,1,16)
call HGT_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(16),-32,0,G2H16(3),n2h16(82))
  call Hloop_AV_Q(ntryL,G2H16(3),ex6(:),G2H8(56),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_QV_A(ntryL,G1H16(20),ex5(:),G1H8(65),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(65),92,0,G2H8(61),n2h8(69))
  call Hloop_QV_A(ntryL,G1H16(22),ex5(:),G1H8(66),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(66),92,0,G2H8(63),n2h8(70))
  call Hloop_VQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(19),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-32,0,G2H8(64),n2h8(71))
  call Hloop_AV_Q(ntryL,G2H8(64),ex6(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(21),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(6),ex3(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(22),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H16(23),ex4(:),G1H8(83),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(83),92,0,G2H8(69),n2h8(72))
call HGT_OLR(G1H16(24),1,1,16)
call HGT_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(24),-32,0,G2H16(5),n2h16(83))
  call Hloop_QV_A(ntryL,G2H16(5),ex6(:),G2H8(71),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_VA_Q(ntryL,G1H16(29),ex4(:),G1H8(84),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(84),92,0,G2H8(72),n2h8(73))
  call Hloop_VA_Q(ntryL,G1H16(30),ex4(:),G1H8(101),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(101),92,0,G2H8(1),n2h8(74))
  call Hloop_VA_Q(ntryL,G1H16(32),ex4(:),G1H8(102),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(102),92,0,G2H8(2),n2h8(75))
call HGT_OLR(G1H16(34),1,1,16)
call HGT_invQ_OLR(G1H16(34),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(34),-32,0,G2H16(7),n2h16(84))
  call Hloop_QV_A(ntryL,G2H16(7),ex6(:),G2H8(3),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(119),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(119),92,0,G2H8(4),n2h8(76))
  call Hloop_VA_Q(ntryL,G1H16(40),ex4(:),G1H8(120),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(120),92,0,G2H8(5),n2h8(77))
  call Hloop_QV_A(ntryL,G1H16(41),ex6(:),G1H8(29),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(29),108,0,G2H8(8),n2h8(78))
call HGT_OLR(G1H16(42),1,1,16)
call HGT_invQ_OLR(G1H16(42),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(42),-16,0,G2H16(9),n2h16(85))
  call Hloop_AV_Q(ntryL,G2H16(9),ex5(:),G2H8(9),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_QV_A(ntryL,G1H16(47),ex6(:),G1H8(30),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(30),108,0,G2H8(10),n2h8(79))
  call Hloop_QV_A(ntryL,G1H16(50),ex6(:),G1H8(47),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H8(47),108,0,G2H8(13),n2h8(80))
  call Hloop_QV_A(ntryL,G1H16(51),ex6(:),G1H8(48),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(48),108,0,G2H8(14),n2h8(81))
call HGT_OLR(G1H16(52),1,1,16)
call HGT_invQ_OLR(G1H16(52),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(52),-16,0,G2H16(11),n2h16(86))
  call Hloop_AV_Q(ntryL,G2H16(11),ex5(:),G2H8(15),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_QV_A(ntryL,G1H16(55),ex6(:),G1H8(65),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(65),108,0,G2H8(18),n2h8(82))
  call Hloop_QV_A(ntryL,G1H16(56),ex6(:),G1H8(66),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(66),108,0,G2H8(19),n2h8(83))
  call Hloop_VQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(23),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,0,G2H8(20),n2h8(84))
  call Hloop_AV_Q(ntryL,G2H8(20),ex5(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(25),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(12),ex3(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(26),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H16(57),ex5(:),G1H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(1),92,0,G2H8(23),n2h8(85))
call HGT_OLR(G1H16(58),1,1,16)
call HGT_invQ_OLR(G1H16(58),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(58),-32,0,G2H16(13),n2h16(87))
  call Hloop_QV_A(ntryL,G2H16(13),ex6(:),G2H8(24),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_AV_Q(ntryL,G1H16(61),ex5(:),G1H8(2),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(2),92,0,G2H8(25),n2h8(86))
  call Hloop_AV_Q(ntryL,G1H16(62),ex5(:),G1H8(5),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(5),92,0,G2H8(28),n2h8(87))
  call Hloop_AV_Q(ntryL,G1H16(63),ex5(:),G1H8(6),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(6),92,0,G2H8(29),n2h8(88))
call HGT_OLR(G1H16(64),1,1,16)
call HGT_invQ_OLR(G1H16(64),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(64),-32,0,G2H16(15),n2h16(88))
  call Hloop_QV_A(ntryL,G2H16(15),ex6(:),G2H8(30),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_AV_Q(ntryL,G1H16(67),ex5(:),G1H8(83),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(83),92,0,G2H8(33),n2h8(89))
  call Hloop_AV_Q(ntryL,G1H16(68),ex5(:),G1H8(84),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(84),92,0,G2H8(34),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H16(69),ex6(:),G1H8(101),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(101),108,0,G2H8(39),n2h8(91))
call HGT_OLR(G1H16(70),1,1,16)
call HGT_invQ_OLR(G1H16(70),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(70),-16,0,G2H16(17),n2h16(89))
  call Hloop_QV_A(ntryL,G2H16(17),ex5(:),G2H8(41),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_AV_Q(ntryL,G1H16(73),ex6(:),G1H8(102),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(102),108,0,G2H8(42),n2h8(92))
  call Hloop_AV_Q(ntryL,G1H16(74),ex6(:),G1H8(119),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(119),108,0,G2H8(43),n2h8(93))
  call Hloop_AV_Q(ntryL,G1H16(75),ex6(:),G1H8(120),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(120),108,0,G2H8(46),n2h8(94))
call HGT_OLR(G1H16(76),1,1,16)
call HGT_invQ_OLR(G1H16(76),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(76),-16,0,G2H16(19),n2h16(90))
  call Hloop_QV_A(ntryL,G2H16(19),ex5(:),G2H8(47),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_AV_Q(ntryL,G1H16(79),ex6(:),G1H8(29),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(29),108,0,G2H8(48),n2h8(95))
  call Hloop_AV_Q(ntryL,G1H16(80),ex6(:),G1H8(30),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(30),108,0,G2H8(51),n2h8(96))
  call Hloop_AV_Q(ntryL,G1H16(81),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(27),n2h4(7))
call HGT_OLR(G1H16(82),1,1,16)
call HGT_invQ_OLR(G1H16(82),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(82),-16,0,G2H16(21),n2h16(91))
  call Hloop_QV_A(ntryL,G2H16(21),ex5(:),G2H8(52),m3h2x8(:,85),heltab2x16(:,:,86))
  call Hloop_AV_Q(ntryL,G1H16(85),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(28),n2h4(8))
  call Hloop_AV_Q(ntryL,G1H16(86),wf4(:,1),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(29),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H16(87),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(30),n2h4(10))
call HGT_OLR(G1H16(88),1,1,16)
call HGT_invQ_OLR(G1H16(88),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(88),-16,0,G2H16(23),n2h16(92))
  call Hloop_QV_A(ntryL,G2H16(23),ex5(:),G2H8(57),m3h2x8(:,86),heltab2x16(:,:,90))
  call Hloop_AZ_Q(ntryL,G1H16(91),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(31),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(92),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,6),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(32),n2h4(12))
  call Hloop_AV_Q(ntryL,G1H16(93),wf4(:,1),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(33),n2h4(13))
call HGT_OLR(G1H16(94),1,1,16)
call HGT_invQ_OLR(G1H16(94),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(94),-32,0,G2H16(2),n2h16(93))
  call Hloop_QV_A(ntryL,G2H16(2),ex6(:),G2H8(59),m3h2x8(:,87),heltab2x16(:,:,94))
  call Hloop_AV_Q(ntryL,G1H16(97),wf4(:,1),G1H4(1),m3h4x4(:,8),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(34),n2h4(14))
  call Hloop_AV_Q(ntryL,G1H16(98),wf4(:,1),G1H4(1),m3h4x4(:,9),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(35),n2h4(15))
  call Hloop_AZ_Q(ntryL,G1H16(99),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(36),n2h4(16))
call HGT_OLR(G1H16(100),1,1,16)
call HGT_invQ_OLR(G1H16(100),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(100),-32,0,G2H16(4),n2h16(94))
  call Hloop_QV_A(ntryL,G2H16(4),ex6(:),G2H8(60),m3h2x8(:,88),heltab2x16(:,:,98))
  call Hloop_AZ_Q(ntryL,G1H16(103),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(37),n2h4(17))
  call Hloop_AZ_Q(ntryL,G1H16(104),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,12),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(38),n2h4(18))
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(39),n2h4(19))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-32,0,G2H8(65),n2h8(97))
  call Hloop_QV_A(ntryL,G2H8(65),ex6(:),G2H4(40),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G1H8(17),ex4(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(41),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(42),n2h4(21))
  call Hloop_VQ_A(ntryL,G1H16(105),ex3(:),G1H8(47),m3h2x8(:,89),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(47),92,0,G2H8(67),n2h8(98))
call HGT_OLR(G1H16(106),1,1,16)
call HGT_invQ_OLR(G1H16(106),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(106),-32,0,G2H16(6),n2h16(95))
  call Hloop_AV_Q(ntryL,G2H16(6),ex6(:),G2H8(68),m3h2x8(:,90),heltab2x16(:,:,102))
  call Hloop_VQ_A(ntryL,G1H16(109),ex3(:),G1H8(48),m3h2x8(:,91),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(48),92,0,G2H8(73),n2h8(99))
  call Hloop_VQ_A(ntryL,G1H16(110),ex3(:),G1H8(65),m3h2x8(:,92),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(65),92,0,G2H8(75),n2h8(100))
  call Hloop_VQ_A(ntryL,G1H16(111),ex3(:),G1H8(66),m3h2x8(:,93),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(66),92,0,G2H8(76),n2h8(101))
call HGT_OLR(G1H16(112),1,1,16)
call HGT_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(112),-32,0,G2H16(8),n2h16(96))
  call Hloop_AV_Q(ntryL,G2H16(8),ex6(:),G2H8(64),m3h2x8(:,94),heltab2x16(:,:,106))
  call Hloop_VQ_A(ntryL,G1H16(115),ex3(:),G1H8(7),m3h2x8(:,95),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(7),92,0,G2H8(20),n2h8(102))
  call Hloop_VQ_A(ntryL,G1H16(116),ex3(:),G1H8(8),m3h2x8(:,96),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(8),92,0,G2H8(65),n2h8(103))
  call Hloop_VA_Q(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(43),n2h4(22))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-16,0,G2H8(77),n2h8(104))
  call Hloop_QV_A(ntryL,G2H8(77),ex5(:),G2H4(44),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(45),n2h4(23))
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),79,0,G2H4(46),n2h4(24))
  call Hloop_QV_A(ntryL,G1H16(117),wf4(:,1),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(47),n2h4(25))
call HGT_OLR(G1H16(118),1,1,16)
call HGT_invQ_OLR(G1H16(118),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(118),-16,0,G2H16(10),n2h16(97))
  call Hloop_AV_Q(ntryL,G2H16(10),ex5(:),G2H8(77),m3h2x8(:,97),heltab2x16(:,:,110))
  call Hloop_QV_A(ntryL,G1H16(121),wf4(:,1),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(48),n2h4(26))
  call Hloop_QV_A(ntryL,G1H16(122),wf4(:,1),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(49),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(123),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(50),n2h4(28))
call HGT_OLR(G1H16(124),1,1,16)
call HGT_invQ_OLR(G1H16(124),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(124),-16,0,G2H16(12),n2h16(98))
  call Hloop_AV_Q(ntryL,G2H16(12),ex5(:),G2H8(78),m3h2x8(:,98),heltab2x16(:,:,114))
  call Hloop_QZ_A(ntryL,G1H16(127),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,17),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(51),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H16(128),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,18),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(52),n2h4(30))
  call Hloop_QV_A(ntryL,G1H16(129),wf4(:,1),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(53),n2h4(31))
call HGT_OLR(G1H16(130),1,1,16)
call HGT_invQ_OLR(G1H16(130),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(130),-32,0,G2H16(14),n2h16(99))
  call Hloop_AV_Q(ntryL,G2H16(14),ex6(:),G2H8(79),m3h2x8(:,99),heltab2x16(:,:,118))
  call Hloop_QV_A(ntryL,G1H16(133),wf4(:,1),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(54),n2h4(32))
  call Hloop_QV_A(ntryL,G1H16(134),wf4(:,1),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(55),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(135),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(56),n2h4(34))
call HGT_OLR(G1H16(136),1,1,16)
call HGT_invQ_OLR(G1H16(136),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(136),-32,0,G2H16(16),n2h16(100))
  call Hloop_AV_Q(ntryL,G2H16(16),ex6(:),G2H8(80),m3h2x8(:,100),heltab2x16(:,:,122))
  call Hloop_QZ_A(ntryL,G1H16(139),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(57),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(140),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,24),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(58),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(25),ex5(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(59),n2h4(37))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-8,0,G2H8(81),n2h8(105))
  call Hloop_QA_V(ntryL,G2H8(81),ex4(:),G2H4(60),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_AV_Q(ntryL,G1H8(31),ex5(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(61),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(37),ex5(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(62),n2h4(39))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-8,0,G2H8(81),n2h8(106))
  call Hloop_QA_V(ntryL,G2H8(81),ex4(:),G2H4(63),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AV_Q(ntryL,G1H8(35),ex5(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(64),n2h4(40))
  call Hloop_AV_Q(ntryL,G1H8(36),ex5(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(65),n2h4(41))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-8,0,G2H8(81),n2h8(107))
  call Hloop_QA_V(ntryL,G2H8(81),ex4(:),G2H4(66),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(67),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(68),n2h4(43))
  call Hloop_AV_Q(ntryL,G1H8(43),ex6(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(69),n2h4(44))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-8,0,G2H8(81),n2h8(108))
  call Hloop_QA_V(ntryL,G2H8(81),ex4(:),G2H4(70),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_AV_Q(ntryL,G1H8(49),ex6(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(71),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H8(55),ex6(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(72),n2h4(46))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-8,0,G2H8(81),n2h8(109))
  call Hloop_QA_V(ntryL,G2H8(81),ex4(:),G2H4(73),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_AV_Q(ntryL,G1H8(53),ex6(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(74),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(54),ex6(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(75),n2h4(48))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(56),-8,0,G2H8(81),n2h8(110))
  call Hloop_QA_V(ntryL,G2H8(81),ex4(:),G2H4(76),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_AV_Q(ntryL,G1H8(59),ex6(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(77),n2h4(49))
  call Hloop_AV_Q(ntryL,G1H8(60),ex6(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),115,0,G2H4(78),n2h4(50))
  call Hloop_QV_A(ntryL,G1H8(61),ex5(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(79),n2h4(51))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-4,0,G2H8(81),n2h8(111))
  call Hloop_AQ_V(ntryL,G2H8(81),ex3(:),G2H4(80),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(81),n2h4(52))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(82),n2h4(53))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-4,0,G2H8(81),n2h8(112))
  call Hloop_AQ_V(ntryL,G2H8(81),ex3(:),G2H4(83),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_QV_A(ntryL,G1H8(71),ex5(:),G1H4(1),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(84),n2h4(54))
  call Hloop_QV_A(ntryL,G1H8(72),ex5(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(85),n2h4(55))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(74),-4,0,G2H8(81),n2h8(113))
  call Hloop_AQ_V(ntryL,G2H8(81),ex3(:),G2H4(86),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QV_A(ntryL,G1H8(77),ex5(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(87),n2h4(56))
  call Hloop_QV_A(ntryL,G1H8(78),ex5(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(88),n2h4(57))
  call Hloop_QV_A(ntryL,G1H8(79),ex6(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(89),n2h4(58))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-4,0,G2H8(81),n2h8(114))
  call Hloop_AQ_V(ntryL,G2H8(81),ex3(:),G2H4(90),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_QV_A(ntryL,G1H8(85),ex6(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(91),n2h4(59))
  call Hloop_QV_A(ntryL,G1H8(91),ex6(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(92),n2h4(60))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(86),-4,0,G2H8(81),n2h8(115))
  call Hloop_AQ_V(ntryL,G2H8(81),ex3(:),G2H4(93),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_QV_A(ntryL,G1H8(89),ex6(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(94),n2h4(61))
  call Hloop_QV_A(ntryL,G1H8(90),ex6(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(95),n2h4(62))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(92),-4,0,G2H8(81),n2h8(116))
  call Hloop_AQ_V(ntryL,G2H8(81),ex3(:),G2H4(96),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QV_A(ntryL,G1H8(95),ex6(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(97),n2h4(63))
  call Hloop_QV_A(ntryL,G1H8(96),ex6(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(1),115,0,G2H4(98),n2h4(64))
  call Hloop_QV_A(ntryL,G1H16(141),wf4(:,1),G1H4(1),m3h4x4(:,25),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(99),n2h4(65))
call HGT_raise_alpha_OLR(G1H16(142),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(142),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(142),ex4(:),G1H8(11),m3h2x8(:,101),heltab2x16(:,:,126))
  call Hloop_QV_A(ntryL,G1H16(147),wf4(:,1),G1H4(1),m3h4x4(:,26),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(100),n2h4(66))
  call Hloop_QV_A(ntryL,G1H16(153),wf4(:,1),G1H4(1),m3h4x4(:,27),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(101),n2h4(67))
call HGT_raise_alpha_OLR(G1H16(148),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(148),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(148),ex4(:),G1H8(12),m3h2x8(:,102),heltab2x16(:,:,129))
  call Hloop_QV_A(ntryL,G1H16(151),wf4(:,1),G1H4(1),m3h4x4(:,28),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(102),n2h4(68))
  call Hloop_QV_A(ntryL,G1H16(152),wf4(:,1),G1H4(1),m3h4x4(:,29),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(103),n2h4(69))
call HGT_raise_alpha_OLR(G1H16(154),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(154),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(154),ex4(:),G1H8(1),m3h2x8(:,103),heltab2x16(:,:,132))
  call Hloop_QV_A(ntryL,G1H16(157),wf4(:,1),G1H4(1),m3h4x4(:,30),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(104),n2h4(70))
  call Hloop_QV_A(ntryL,G1H16(158),wf4(:,1),G1H4(1),m3h4x4(:,31),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(105),n2h4(71))
  call Hloop_QZ_A(ntryL,G1H16(159),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,32),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(106),n2h4(72))
call HGT_raise_alpha_OLR(G1H16(160),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(160),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(160),ex4(:),G1H8(2),m3h2x8(:,104),heltab2x16(:,:,136))
  call Hloop_QZ_A(ntryL,G1H16(165),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,33),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(107),n2h4(73))
  call Hloop_QZ_A(ntryL,G1H16(171),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,34),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(108),n2h4(74))
call HGT_raise_alpha_OLR(G1H16(166),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(166),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(166),ex4(:),G1H8(5),m3h2x8(:,105),heltab2x16(:,:,139))
  call Hloop_QZ_A(ntryL,G1H16(169),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,35),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(109),n2h4(75))
  call Hloop_QZ_A(ntryL,G1H16(170),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,36),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(110),n2h4(76))
call HGT_raise_alpha_OLR(G1H16(172),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(172),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(172),ex4(:),G1H8(6),m3h2x8(:,106),heltab2x16(:,:,142))
  call Hloop_QZ_A(ntryL,G1H16(175),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,37),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(111),n2h4(77))
  call Hloop_QZ_A(ntryL,G1H16(176),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,38),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),87,0,G2H4(112),n2h4(78))
  call Hloop_QV_A(ntryL,G1H16(177),ex6(:),G1H8(83),m3h2x8(:,107),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(83),116,0,G2H8(81),n2h8(117))
call HGT_raise_alpha_OLR(G1H16(178),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(178),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(178),ex4(:),G1H8(84),m3h2x8(:,108),heltab2x16(:,:,146))
  call Hloop_QV_A(ntryL,G1H16(183),ex6(:),G1H8(101),m3h2x8(:,109),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H8(101),116,0,G2H8(82),n2h8(118))
  call Hloop_QV_A(ntryL,G1H16(189),ex6(:),G1H8(102),m3h2x8(:,110),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H8(102),116,0,G2H8(83),n2h8(119))
call HGT_raise_alpha_OLR(G1H16(184),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(184),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(184),ex4(:),G1H8(119),m3h2x8(:,111),heltab2x16(:,:,149))
  call Hloop_QV_A(ntryL,G1H16(187),ex6(:),G1H8(120),m3h2x8(:,112),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H8(120),116,0,G2H8(84),n2h8(120))
  call Hloop_QV_A(ntryL,G1H16(188),ex6(:),G1H8(29),m3h2x8(:,113),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H8(29),116,0,G2H8(85),n2h8(121))
call HGT_raise_alpha_OLR(G1H16(190),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(190),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(190),ex4(:),G1H8(30),m3h2x8(:,114),heltab2x16(:,:,152))
  call Hloop_QV_A(ntryL,G1H16(193),ex6(:),G1H8(13),m3h2x8(:,115),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H8(13),116,0,G2H8(86),n2h8(122))
  call Hloop_QV_A(ntryL,G1H16(194),ex6(:),G1H8(14),m3h2x8(:,116),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(14),116,0,G2H8(87),n2h8(123))
  call Hloop_QV_A(ntryL,G1H16(195),ex6(:),G1H8(17),m3h2x8(:,117),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H8(17),116,0,G2H8(88),n2h8(124))
call HGT_raise_alpha_OLR(G1H16(196),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(196),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(196),ex4(:),G1H8(18),m3h2x8(:,118),heltab2x16(:,:,156))
  call Hloop_QV_A(ntryL,G1H16(201),ex6(:),G1H8(47),m3h2x8(:,119),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(47),116,0,G2H8(89),n2h8(125))
  call Hloop_QV_A(ntryL,G1H16(207),ex6(:),G1H8(48),m3h2x8(:,120),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(48),116,0,G2H8(90),n2h8(126))
call HGT_raise_alpha_OLR(G1H16(202),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(202),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(202),ex4(:),G1H8(65),m3h2x8(:,121),heltab2x16(:,:,159))
  call Hloop_QV_A(ntryL,G1H16(205),ex6(:),G1H8(66),m3h2x8(:,122),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(66),116,0,G2H8(91),n2h8(127))
  call Hloop_QV_A(ntryL,G1H16(206),ex6(:),G1H8(7),m3h2x8(:,123),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(7),116,0,G2H8(92),n2h8(128))
call HGT_raise_alpha_OLR(G1H16(208),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(208),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(208),ex4(:),G1H8(8),m3h2x8(:,124),heltab2x16(:,:,162))
  call Hloop_QV_A(ntryL,G1H16(211),ex6(:),G1H8(19),m3h2x8(:,125),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H8(19),116,0,G2H8(93),n2h8(129))
  call Hloop_QV_A(ntryL,G1H16(212),ex6(:),G1H8(20),m3h2x8(:,126),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H8(20),116,0,G2H8(94),n2h8(130))
  call Hloop_QV_A(ntryL,G1H16(213),wf4(:,1),G1H4(1),m3h4x4(:,39),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(113),n2h4(79))
call HGT_raise_alpha_OLR(G1H16(214),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(214),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(214),ex4(:),G1H8(23),m3h2x8(:,127),heltab2x16(:,:,166))
  call Hloop_QV_A(ntryL,G1H16(219),wf4(:,1),G1H4(1),m3h4x4(:,40),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(114),n2h4(80))
  call Hloop_QV_A(ntryL,G1H16(225),wf4(:,1),G1H4(1),m3h4x4(:,41),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(115),n2h4(81))
call HGT_raise_alpha_OLR(G1H16(220),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(220),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(220),ex4(:),G1H8(24),m3h2x8(:,128),heltab2x16(:,:,169))
  call Hloop_QV_A(ntryL,G1H16(223),wf4(:,1),G1H4(1),m3h4x4(:,42),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(116),n2h4(82))
  call Hloop_QV_A(ntryL,G1H16(224),wf4(:,1),G1H4(1),m3h4x4(:,43),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(117),n2h4(83))
call HGT_raise_alpha_OLR(G1H16(226),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(226),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(226),ex4(:),G1H8(25),m3h2x8(:,129),heltab2x16(:,:,172))
  call Hloop_QV_A(ntryL,G1H16(229),wf4(:,1),G1H4(1),m3h4x4(:,44),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(118),n2h4(84))
  call Hloop_QV_A(ntryL,G1H16(230),wf4(:,1),G1H4(1),m3h4x4(:,45),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(119),n2h4(85))
  call Hloop_QZ_A(ntryL,G1H16(231),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,46),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(120),n2h4(86))
call HGT_raise_alpha_OLR(G1H16(232),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(232),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(232),ex4(:),G1H8(26),m3h2x8(:,130),heltab2x16(:,:,176))
  call Hloop_QZ_A(ntryL,G1H16(237),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,47),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(121),n2h4(87))
  call Hloop_QZ_A(ntryL,G1H16(243),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,48),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(122),n2h4(88))
call HGT_raise_alpha_OLR(G1H16(238),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(238),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(238),ex4(:),G1H8(31),m3h2x8(:,131),heltab2x16(:,:,179))
  call Hloop_QZ_A(ntryL,G1H16(241),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,49),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(123),n2h4(89))
  call Hloop_QZ_A(ntryL,G1H16(242),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,50),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(124),n2h4(90))
call HGT_raise_alpha_OLR(G1H16(244),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(244),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(244),ex4(:),G1H8(37),m3h2x8(:,132),heltab2x16(:,:,182))
  call Hloop_QZ_A(ntryL,G1H16(247),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,51),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(125),n2h4(91))
  call Hloop_QZ_A(ntryL,G1H16(248),wf4(:,7),G1H4(1),ngZd,m3h4x4(:,52),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(126),n2h4(92))
  call Hloop_QV_A(ntryL,G1H16(249),ex5(:),G1H8(32),m3h2x8(:,133),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G1H8(32),116,0,G2H8(95),n2h8(131))
call HGT_raise_alpha_OLR(G1H16(250),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(250),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(250),ex4(:),G1H8(35),m3h2x8(:,134),heltab2x16(:,:,186))
  call Hloop_QV_A(ntryL,G1H16(255),ex5(:),G1H8(36),m3h2x8(:,135),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(36),116,0,G2H8(96),n2h8(132))
  call Hloop_QV_A(ntryL,G1H16(261),ex5(:),G1H8(38),m3h2x8(:,136),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(38),116,0,G2H8(97),n2h8(133))
call HGT_raise_alpha_OLR(G1H16(256),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(256),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(256),ex4(:),G1H8(41),m3h2x8(:,137),heltab2x16(:,:,189))
  call Hloop_QV_A(ntryL,G1H16(259),ex5(:),G1H8(42),m3h2x8(:,138),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H8(42),116,0,G2H8(98),n2h8(134))
  call Hloop_QV_A(ntryL,G1H16(260),ex5(:),G1H8(43),m3h2x8(:,139),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H8(43),116,0,G2H8(99),n2h8(135))
call HGT_raise_alpha_OLR(G1H16(262),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(262),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(262),ex4(:),G1H8(44),m3h2x8(:,140),heltab2x16(:,:,192))
  call Hloop_QV_A(ntryL,G1H16(265),ex5(:),G1H8(49),m3h2x8(:,141),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(49),116,0,G2H8(100),n2h8(136))
  call Hloop_QV_A(ntryL,G1H16(266),ex5(:),G1H8(55),m3h2x8(:,142),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H8(55),116,0,G2H8(101),n2h8(137))
  call Hloop_QV_A(ntryL,G1H16(267),ex5(:),G1H8(50),m3h2x8(:,143),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G1H8(50),116,0,G2H8(102),n2h8(138))
call HGT_raise_alpha_OLR(G1H16(268),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(268),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(268),ex4(:),G1H8(53),m3h2x8(:,144),heltab2x16(:,:,196))
  call Hloop_QV_A(ntryL,G1H16(273),ex5(:),G1H8(54),m3h2x8(:,145),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(54),116,0,G2H8(103),n2h8(139))
  call Hloop_QV_A(ntryL,G1H16(279),ex5(:),G1H8(56),m3h2x8(:,146),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H8(56),116,0,G2H8(104),n2h8(140))
call HGT_raise_alpha_OLR(G1H16(274),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(274),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(274),ex4(:),G1H8(59),m3h2x8(:,147),heltab2x16(:,:,199))
  call Hloop_QV_A(ntryL,G1H16(277),ex5(:),G1H8(60),m3h2x8(:,148),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(60),116,0,G2H8(105),n2h8(141))
  call Hloop_QV_A(ntryL,G1H16(278),ex5(:),G1H8(61),m3h2x8(:,149),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(61),116,0,G2H8(106),n2h8(142))
call HGT_raise_alpha_OLR(G1H16(280),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(280),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(280),ex4(:),G1H8(62),m3h2x8(:,150),heltab2x16(:,:,202))
  call Hloop_QV_A(ntryL,G1H16(283),ex5(:),G1H8(67),m3h2x8(:,151),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(67),116,0,G2H8(107),n2h8(143))
  call Hloop_QV_A(ntryL,G1H16(284),ex5(:),G1H8(73),m3h2x8(:,152),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(73),116,0,G2H8(108),n2h8(144))
  call Hloop_QV_A(ntryL,G1H8(97),ex6(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),103,0,G2H4(127),n2h4(93))
call HGT_raise_alpha_OLR(G1H8(98),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(98),ex4(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_QV_A(ntryL,G1H8(103),ex6(:),G1H4(2),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(2),103,0,G2H4(128),n2h4(94))
  call Hloop_QV_A(ntryL,G1H8(109),ex6(:),G1H4(2),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(2),103,0,G2H4(129),n2h4(95))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(104),ex4(:),G1H4(2),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_QV_A(ntryL,G1H8(107),ex6(:),G1H4(3),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(3),103,0,G2H4(130),n2h4(96))
  call Hloop_QV_A(ntryL,G1H8(108),ex6(:),G1H4(3),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(3),103,0,G2H4(131),n2h4(97))
call HGT_raise_alpha_OLR(G1H8(110),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(110),ex4(:),G1H4(3),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_QV_A(ntryL,G1H8(113),ex6(:),G1H4(4),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(4),103,0,G2H4(132),n2h4(98))
  call Hloop_QV_A(ntryL,G1H8(114),ex6(:),G1H4(4),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(4),103,0,G2H4(133),n2h4(99))
  call Hloop_QV_A(ntryL,G1H8(115),ex5(:),G1H4(4),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(4),87,0,G2H4(134),n2h4(100))
call HGT_raise_alpha_OLR(G1H8(116),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(116),ex4(:),G1H4(4),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QV_A(ntryL,G1H8(121),ex5(:),G1H4(5),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(5),87,0,G2H4(135),n2h4(101))
  call Hloop_QV_A(ntryL,G1H8(127),ex5(:),G1H4(5),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(5),87,0,G2H4(136),n2h4(102))
call HGT_raise_alpha_OLR(G1H8(122),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(122),ex4(:),G1H4(5),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_QV_A(ntryL,G1H8(125),ex5(:),G1H4(6),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(6),87,0,G2H4(137),n2h4(103))
  call Hloop_QV_A(ntryL,G1H8(126),ex5(:),G1H4(6),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(6),87,0,G2H4(138),n2h4(104))
call HGT_raise_alpha_OLR(G1H8(128),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(128),ex4(:),G1H4(6),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_QV_A(ntryL,G1H8(131),ex5(:),G1H4(7),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(7),87,0,G2H4(139),n2h4(105))
  call Hloop_QV_A(ntryL,G1H8(132),ex5(:),G1H4(7),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(7),87,0,G2H4(140),n2h4(106))
  call ol_merge(ntryL,G2H4(30),[G2H4(27)])
  call ol_merge(ntryL,G2H4(32),[G2H4(29)])
  call ol_merge(ntryL,G2H4(36),[G2H4(33)])
  call ol_merge(ntryL,G2H4(38),[G2H4(35)])
  call ol_merge(ntryL,G2H4(50),[G2H4(47)])
  call ol_merge(ntryL,G2H4(52),[G2H4(49)])
  call ol_merge(ntryL,G2H4(56),[G2H4(53)])
  call ol_merge(ntryL,G2H4(58),[G2H4(55)])
  call ol_merge(ntryL,G2H4(106),[G2H4(99)])
  call ol_merge(ntryL,G2H4(108),[G2H4(101)])
  call ol_merge(ntryL,G2H4(112),[G2H4(105)])
  call ol_merge(ntryL,G2H4(120),[G2H4(113)])
  call ol_merge(ntryL,G2H4(122),[G2H4(115)])
  call ol_merge(ntryL,G2H4(126),[G2H4(119)])
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),16,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(37),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),16,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),32,4)
call Hotf_5pt_reduction(G2H4(6),RedSet_5(38),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),32,4)
call Hotf_5pt_reduction(G2H4(7),RedSet_5(4),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
call HG1shiftOLR(G1H4(32),16,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(37),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
call HG1shiftOLR(G1H4(38),16,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(5),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(44),32,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(38),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
call HG1shiftOLR(G1H4(50),32,4)
call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
call HG1shiftOLR(G1H4(56),32,4)
call Hotf_5pt_reduction(G2H4(15),RedSet_5(39),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
call HG1shiftOLR(G1H4(62),32,4)
call Hotf_5pt_reduction(G2H4(16),RedSet_5(8),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
call HG1shiftOLR(G1H4(68),32,4)
call Hotf_5pt_reduction(G2H4(18),RedSet_5(39),mass5set(:,1),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
call HG1shiftOLR(G1H4(74),32,4)
call Hotf_5pt_reduction(G2H8(35),RedSet_5(15),mass5set(:,1),  & 
G1H8(68),G1H8(71),G1H8(72),G1H8(74),G1H8(77),G1H8(78),8)
call HG1shiftOLR(G1H8(71),32,8)
call Hotf_5pt_reduction(G2H8(53),RedSet_5(40),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(85),G1H8(91),G1H8(86),G1H8(89),8)
call HG1shiftOLR(G1H8(80),32,8)
call Hotf_5pt_reduction(G2H8(55),RedSet_5(15),mass5set(:,1),  & 
G1H8(90),G1H8(92),G1H8(95),G1H8(96),G1H8(83),G1H8(101),8)
call HG1shiftOLR(G1H8(92),32,8)
call Hotf_5pt_reduction(G2H8(63),RedSet_5(40),mass5set(:,1),  & 
G1H8(102),G1H8(120),G1H8(29),G1H8(13),G1H8(14),G1H8(17),8)
call HG1shiftOLR(G1H8(120),32,8)
call Hotf_5pt_reduction(G2H4(19),RedSet_5(16),mass5set(:,1),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
call HG1shiftOLR(G1H4(80),32,4)
call Hotf_5pt_reduction(G2H4(22),RedSet_5(41),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
call HG1shiftOLR(G1H4(86),32,4)
call Hotf_5pt_reduction(G2H8(69),RedSet_5(17),mass5set(:,1),  & 
G1H8(47),G1H8(48),G1H8(66),G1H8(7),G1H8(19),G1H8(20),8)
call HG1shiftOLR(G1H8(48),32,8)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(42),mass5set(:,1),  & 
G1H8(32),G1H8(36),G1H8(38),G1H8(42),G1H8(43),G1H8(49),8)
call HG1shiftOLR(G1H8(36),32,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(17),mass5set(:,1),  & 
G1H8(55),G1H8(50),G1H8(54),G1H8(56),G1H8(60),G1H8(61),8)
call HG1shiftOLR(G1H8(50),32,8)
call Hotf_5pt_reduction(G2H8(5),RedSet_5(42),mass5set(:,1),  & 
G1H8(67),G1H8(73),G1H8(97),G1H8(98),G1H8(103),G1H8(109),8)
call HG1shiftOLR(G1H8(73),32,8)
call Hotf_5pt_reduction(G2H8(8),RedSet_5(18),mass5set(:,1),  & 
G1H8(104),G1H8(107),G1H8(108),G1H8(110),G1H8(113),G1H8(114),8)
call HG1shiftOLR(G1H8(107),16,8)
call Hotf_5pt_reduction(G2H8(13),RedSet_5(43),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(121),G1H8(127),G1H8(122),G1H8(125),8)
call HG1shiftOLR(G1H8(116),16,8)
call Hotf_5pt_reduction(G2H8(14),RedSet_5(18),mass5set(:,1),  & 
G1H8(126),G1H8(128),G1H8(131),G1H8(132),G1H8(133),G1H8(134),8)
call HG1shiftOLR(G1H8(128),16,8)
call Hotf_5pt_reduction(G2H8(19),RedSet_5(43),mass5set(:,1),  & 
G1H8(135),G1H8(136),G1H8(137),G1H8(138),G1H8(139),G1H8(140),8)
call HG1shiftOLR(G1H8(136),16,8)
call Hotf_5pt_reduction(G2H4(23),RedSet_5(16),mass5set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
call HG1shiftOLR(G1H4(92),16,4)
call Hotf_5pt_reduction(G2H4(26),RedSet_5(44),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
call HG1shiftOLR(G1H4(98),16,4)
call Hotf_5pt_reduction(G2H8(23),RedSet_5(19),mass5set(:,1),  & 
G1H8(141),G1H8(142),G1H8(143),G1H8(144),G1H8(145),G1H8(146),8)
call HG1shiftOLR(G1H8(142),32,8)
call Hotf_5pt_reduction(G2H8(28),RedSet_5(45),mass5set(:,1),  & 
G1H8(147),G1H8(148),G1H8(149),G1H8(150),G1H8(151),G1H8(152),8)
call HG1shiftOLR(G1H8(148),32,8)
call Hotf_5pt_reduction(G2H8(29),RedSet_5(19),mass5set(:,1),  & 
G1H8(153),G1H8(154),G1H8(155),G1H8(156),G1H8(157),G1H8(158),8)
call HG1shiftOLR(G1H8(154),32,8)
call Hotf_5pt_reduction(G2H8(34),RedSet_5(45),mass5set(:,1),  & 
G1H8(159),G1H8(160),G1H8(161),G1H8(162),G1H8(163),G1H8(164),8)
call HG1shiftOLR(G1H8(160),32,8)
call Hotf_5pt_reduction(G2H8(39),RedSet_5(20),mass5set(:,1),  & 
G1H8(165),G1H8(166),G1H8(167),G1H8(168),G1H8(169),G1H8(170),8)
call HG1shiftOLR(G1H8(166),16,8)
call Hotf_5pt_reduction(G2H8(43),RedSet_5(46),mass5set(:,1),  & 
G1H8(171),G1H8(172),G1H8(173),G1H8(174),G1H8(175),G1H8(176),8)
call HG1shiftOLR(G1H8(172),16,8)
call Hotf_5pt_reduction(G2H8(46),RedSet_5(20),mass5set(:,1),  & 
G1H8(177),G1H8(178),G1H8(179),G1H8(180),G1H8(181),G1H8(182),8)
call HG1shiftOLR(G1H8(178),16,8)
call Hotf_5pt_reduction(G2H8(51),RedSet_5(46),mass5set(:,1),  & 
G1H8(183),G1H8(184),G1H8(185),G1H8(186),G1H8(187),G1H8(188),8)
call HG1shiftOLR(G1H8(184),16,8)
call Hotf_5pt_reduction(G2H4(30),RedSet_5(21),mass5set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
call HG1shiftOLR(G1H4(104),16,4)
call Hotf_5pt_reduction(G2H4(32),RedSet_5(46),mass5set(:,1),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
call HG1shiftOLR(G1H4(110),16,4)
call Hotf_5pt_reduction(G2H4(36),RedSet_5(21),mass5set(:,1),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
call HG1shiftOLR(G1H4(116),32,4)
call Hotf_5pt_reduction(G2H4(38),RedSet_5(45),mass5set(:,1),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
call HG1shiftOLR(G1H4(122),32,4)
call Hotf_5pt_reduction(G2H4(39),RedSet_5(22),mass5set(:,1),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
call HG1shiftOLR(G1H4(128),32,4)
call Hotf_5pt_reduction(G2H4(42),RedSet_5(47),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
call HG1shiftOLR(G1H4(134),32,4)
call Hotf_5pt_reduction(G2H8(67),RedSet_5(23),mass5set(:,1),  & 
G1H8(189),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G1H8(194),8)
call HG1shiftOLR(G1H8(190),32,8)
call Hotf_5pt_reduction(G2H8(75),RedSet_5(48),mass5set(:,1),  & 
G1H8(195),G1H8(196),G1H8(197),G1H8(198),G1H8(199),G1H8(200),8)
call HG1shiftOLR(G1H8(196),32,8)
call Hotf_5pt_reduction(G2H8(76),RedSet_5(23),mass5set(:,1),  & 
G1H8(201),G1H8(202),G1H8(203),G1H8(204),G1H8(205),G1H8(206),8)
call HG1shiftOLR(G1H8(202),32,8)
call Hotf_5pt_reduction(G2H8(65),RedSet_5(48),mass5set(:,1),  & 
G1H8(207),G1H8(208),G1H8(209),G1H8(210),G1H8(211),G1H8(212),8)
call HG1shiftOLR(G1H8(208),32,8)
call Hotf_5pt_reduction(G2H4(43),RedSet_5(22),mass5set(:,1),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
call HG1shiftOLR(G1H4(140),16,4)
call Hotf_5pt_reduction(G2H4(46),RedSet_5(49),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
call HG1shiftOLR(G1H4(146),16,4)
call Hotf_5pt_reduction(G2H4(50),RedSet_5(24),mass5set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
call HG1shiftOLR(G1H4(152),16,4)
call Hotf_5pt_reduction(G2H4(52),RedSet_5(43),mass5set(:,1),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
call HG1shiftOLR(G1H4(158),16,4)
call Hotf_5pt_reduction(G2H4(56),RedSet_5(24),mass5set(:,1),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
call HG1shiftOLR(G1H4(164),32,4)
call Hotf_5pt_reduction(G2H4(58),RedSet_5(40),mass5set(:,1),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
call HG1shiftOLR(G1H4(170),32,4)
  call Hloop_AQ_V(ntryL,G2H4(59),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(62),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(68),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(69),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(72),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(78),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(79),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(82),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(88),ex4(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(89),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(92),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(98),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
call Hotf_5pt_reduction(G2H4(106),RedSet_5(9),mass5set(:,1),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
call HG1shiftOLR(G1H4(176),8,4)
call Hotf_5pt_reduction(G2H4(108),RedSet_5(32),mass5set(:,1),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
call HG1shiftOLR(G1H4(182),8,4)
call Hotf_4pt_reduction(G2H4(112),RedSet_4(1),mass4set(:,1),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),4)
call HG1shiftOLR(G1H4(188),43,4)
call Hotf_5pt_reduction(G2H8(81),RedSet_5(10),mass5set(:,1),  & 
G1H8(213),G1H8(214),G1H8(215),G1H8(216),G1H8(217),G1H8(218),8)
call HG1shiftOLR(G1H8(214),8,8)
call Hotf_5pt_reduction(G2H8(83),RedSet_5(32),mass5set(:,1),  & 
G1H8(219),G1H8(220),G1H8(221),G1H8(222),G1H8(223),G1H8(224),8)
call HG1shiftOLR(G1H8(220),8,8)
call Hotf_4pt_reduction(G2H8(87),RedSet_4(1),mass4set(:,1),  & 
G1H8(225),G1H8(226),G1H8(227),G1H8(228),G1H8(229),8)
call HG1shiftOLR(G1H8(226),43,8)
call Hotf_5pt_reduction(G2H8(88),RedSet_5(10),mass5set(:,1),  & 
G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),G1H8(235),8)
call HG1shiftOLR(G1H8(231),8,8)
call Hotf_5pt_reduction(G2H8(90),RedSet_5(32),mass5set(:,1),  & 
G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),G1H8(241),8)
call HG1shiftOLR(G1H8(237),8,8)
call Hotf_4pt_reduction(G2H8(94),RedSet_4(1),mass4set(:,1),  & 
G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
call HG1shiftOLR(G1H8(243),43,8)
call Hotf_5pt_reduction(G2H4(120),RedSet_5(11),mass5set(:,1),  & 
G1H4(192),G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),4)
call HG1shiftOLR(G1H4(193),8,4)
call Hotf_5pt_reduction(G2H4(122),RedSet_5(35),mass5set(:,1),  & 
G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),4)
call HG1shiftOLR(G1H4(199),8,4)
call Hotf_4pt_reduction(G2H4(126),RedSet_4(2),mass4set(:,1),  & 
G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),4)
call HG1shiftOLR(G1H4(205),27,4)
call Hotf_5pt_reduction(G2H8(95),RedSet_5(12),mass5set(:,1),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
call HG1shiftOLR(G1H8(248),8,8)
call Hotf_5pt_reduction(G2H8(97),RedSet_5(35),mass5set(:,1),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
call HG1shiftOLR(G1H8(254),8,8)
call Hotf_4pt_reduction(G2H8(101),RedSet_4(2),mass4set(:,1),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),8)
call HG1shiftOLR(G1H8(260),27,8)
call Hotf_5pt_reduction(G2H8(102),RedSet_5(12),mass5set(:,1),  & 
G1H8(264),G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),8)
call HG1shiftOLR(G1H8(265),8,8)
call Hotf_5pt_reduction(G2H8(104),RedSet_5(35),mass5set(:,1),  & 
G1H8(270),G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),8)
call HG1shiftOLR(G1H8(271),8,8)
call Hotf_4pt_reduction(G2H8(108),RedSet_4(2),mass4set(:,1),  & 
G1H8(276),G1H8(277),G1H8(278),G1H8(279),G1H8(280),8)
call HG1shiftOLR(G1H8(277),27,8)
call Hotf_5pt_reduction(G2H4(127),RedSet_5(13),mass5set(:,1),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
call HG1shiftOLR(G1H4(210),8,4)
call Hotf_5pt_reduction(G2H4(129),RedSet_5(36),mass5set(:,1),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
call HG1shiftOLR(G1H4(216),8,4)
call Hotf_4pt_reduction(G2H4(133),RedSet_4(3),mass4set(:,1),  & 
G1H4(221),G1H4(222),G1H4(223),G1H4(224),G1H4(225),4)
call HG1shiftOLR(G1H4(222),56,4)
call Hotf_5pt_reduction(G2H4(134),RedSet_5(14),mass5set(:,1),  & 
G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),G1H4(231),4)
call HG1shiftOLR(G1H4(227),8,4)
call Hotf_5pt_reduction(G2H4(136),RedSet_5(36),mass5set(:,1),  & 
G1H4(232),G1H4(233),G1H4(234),G1H4(235),G1H4(236),G1H4(237),4)
call HG1shiftOLR(G1H4(233),8,4)
call Hotf_4pt_reduction(G2H4(140),RedSet_4(3),mass4set(:,1),  & 
G1H4(238),G1H4(239),G1H4(240),G1H4(241),G1H4(242),4)
call HG1shiftOLR(G1H4(239),56,4)
  call ol_merge(ntryL,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,G1H8(79),[G1H8(78)])
  call ol_merge(ntryL,G1H8(102),[G1H8(101)])
  call ol_merge(ntryL,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,G1H8(32),[G1H8(20)])
  call ol_merge(ntryL,G1H8(67),[G1H8(61)])
  call ol_merge(ntryL,G1H8(115),[G1H8(114)])
  call ol_merge(ntryL,G1H8(135),[G1H8(134)])
  call ol_merge(ntryL,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,G1H8(147),[G1H8(146)])
  call ol_merge(ntryL,G1H8(159),[G1H8(158)])
  call ol_merge(ntryL,G1H8(171),[G1H8(170)])
  call ol_merge(ntryL,G1H8(183),[G1H8(182)])
  call ol_merge(ntryL,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,G1H8(195),[G1H8(194)])
  call ol_merge(ntryL,G1H8(207),[G1H8(206)])
  call ol_merge(ntryL,G1H4(145),[G1H4(144)])
  call ol_merge(ntryL,G1H4(157),[G1H4(156)])
  call ol_merge(ntryL,G1H4(169),[G1H4(168)])
  call ol_merge(ntryL,G1H4(181),[G1H4(180)])
  call ol_merge(ntryL,G1H4(187),[G1H4(186)])
  call ol_merge(ntryL,G1H8(219),[G1H8(218)])
  call ol_merge(ntryL,G1H8(225),[G1H8(224)])
  call ol_merge(ntryL,G1H8(236),[G1H8(235)])
  call ol_merge(ntryL,G1H8(242),[G1H8(241)])
  call ol_merge(ntryL,G1H4(198),[G1H4(197)])
  call ol_merge(ntryL,G1H4(204),[G1H4(203)])
  call ol_merge(ntryL,G1H8(253),[G1H8(252)])
  call ol_merge(ntryL,G1H8(259),[G1H8(258)])
  call ol_merge(ntryL,G1H8(270),[G1H8(269)])
  call ol_merge(ntryL,G1H8(276),[G1H8(275)])
  call ol_merge(ntryL,G1H4(215),[G1H4(214)])
  call ol_merge(ntryL,G1H4(221),[G1H4(220)])
  call ol_merge(ntryL,G1H4(232),[G1H4(231)])
  call ol_merge(ntryL,G1H4(238),[G1H4(237)])
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(13),n2h2(1))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-16,0,G2H4(27),n2h4(107))
  call Hloop_AV_Q(ntryL,G2H4(27),ex5(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(15),n2h2(2))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-16,0,G2H4(29),n2h4(108))
  call Hloop_AV_Q(ntryL,G2H4(29),ex5(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(17),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(18),n2h2(4))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-32,0,G2H4(33),n2h4(109))
  call Hloop_QV_A(ntryL,G2H4(33),ex6(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(20),n2h2(5))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-32,0,G2H4(35),n2h4(110))
  call Hloop_QV_A(ntryL,G2H4(35),ex6(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(22),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H4(31),ex4(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(23),n2h2(7))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-16,0,G2H4(47),n2h4(111))
  call Hloop_QV_A(ntryL,G2H4(47),ex5(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VA_Q(ntryL,G1H4(37),ex4(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(25),n2h2(8))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-16,0,G2H4(49),n2h4(112))
  call Hloop_QV_A(ntryL,G2H4(49),ex5(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VA_Q(ntryL,G1H4(42),ex4(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(27),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(43),ex3(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(28),n2h2(10))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-32,0,G2H4(53),n2h4(113))
  call Hloop_AV_Q(ntryL,G2H4(53),ex6(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_VQ_A(ntryL,G1H4(49),ex3(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(30),n2h2(11))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-32,0,G2H4(55),n2h4(114))
  call Hloop_AV_Q(ntryL,G2H4(55),ex6(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_VQ_A(ntryL,G1H4(54),ex3(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(32),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(55),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(33),n2h2(13))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-32,0,G2H4(99),n2h4(115))
  call Hloop_AV_Q(ntryL,G2H4(99),ex6(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(35),n2h2(14))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-32,0,G2H4(101),n2h4(116))
  call Hloop_AV_Q(ntryL,G2H4(101),ex6(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VQ_A(ntryL,G1H4(66),ex3(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(37),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(67),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(38),n2h2(16))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-32,0,G2H4(105),n2h4(117))
  call Hloop_QV_A(ntryL,G2H4(105),ex6(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(73),ex4(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(40),n2h2(17))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(74),-32,0,G2H4(113),n2h4(118))
  call Hloop_QV_A(ntryL,G2H4(113),ex6(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VA_Q(ntryL,G1H4(78),ex4(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(42),n2h2(18))
  call Hloop_QV_A(ntryL,G1H8(68),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(43),n2h2(19))
call HGT_OLR(G1H8(71),1,1,8)
call HGT_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(71),-32,0,G2H8(35),n2h8(151))
  call Hloop_AV_Q(ntryL,G2H8(35),ex6(:),G2H4(115),m3h2x4(:,95),heltab2x8(:,:,96))
  call Hloop_QV_A(ntryL,G1H8(79),wf4(:,1),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(44),n2h2(20))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-32,0,G2H8(53),n2h8(152))
  call Hloop_AV_Q(ntryL,G2H8(53),ex6(:),G2H4(119),m3h2x4(:,96),heltab2x8(:,:,98))
  call Hloop_QV_A(ntryL,G1H8(89),wf4(:,1),G1H2(1),m3h4x2(:,3),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(45),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H8(90),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(46),n2h2(22))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(92),-32,0,G2H8(55),n2h8(153))
  call Hloop_AV_Q(ntryL,G2H8(55),ex6(:),G2H4(1),m3h2x4(:,97),heltab2x8(:,:,101))
  call Hloop_QZ_A(ntryL,G1H8(102),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,5),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(47),n2h2(23))
call HGT_OLR(G1H8(120),1,1,8)
call HGT_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(120),-32,0,G2H8(63),n2h8(154))
  call Hloop_AV_Q(ntryL,G2H8(63),ex6(:),G2H4(3),m3h2x4(:,98),heltab2x8(:,:,103))
  call Hloop_QZ_A(ntryL,G1H8(17),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,6),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(48),n2h2(24))
  call Hloop_QV_A(ntryL,G1H4(79),ex5(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(49),n2h2(25))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-32,0,G2H4(4),n2h4(119))
  call Hloop_AV_Q(ntryL,G2H4(4),ex6(:),G2H2(50),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(85),ex5(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(51),n2h2(26))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(86),-32,0,G2H4(6),n2h4(120))
  call Hloop_AV_Q(ntryL,G2H4(6),ex6(:),G2H2(52),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QV_A(ntryL,G1H4(90),ex5(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(53),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H8(47),wf4(:,1),G1H2(1),m3h4x2(:,7),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(54),n2h2(28))
call HGT_OLR(G1H8(48),1,1,8)
call HGT_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(48),-32,0,G2H8(69),n2h8(155))
  call Hloop_QV_A(ntryL,G2H8(69),ex6(:),G2H4(7),m3h2x4(:,99),heltab2x8(:,:,106))
  call Hloop_AV_Q(ntryL,G1H8(32),wf4(:,1),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(55),n2h2(29))
call HGT_OLR(G1H8(36),1,1,8)
call HGT_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(36),-32,0,G2H8(1),n2h8(156))
  call Hloop_QV_A(ntryL,G2H8(1),ex6(:),G2H4(9),m3h2x4(:,100),heltab2x8(:,:,108))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,1),G1H2(1),m3h4x2(:,9),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(56),n2h2(30))
  call Hloop_AZ_Q(ntryL,G1H8(55),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,10),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(57),n2h2(31))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-32,0,G2H8(2),n2h8(157))
  call Hloop_QV_A(ntryL,G2H8(2),ex6(:),G2H4(10),m3h2x4(:,101),heltab2x8(:,:,111))
  call Hloop_AZ_Q(ntryL,G1H8(67),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,11),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(58),n2h2(32))
call HGT_OLR(G1H8(73),1,1,8)
call HGT_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(73),-32,0,G2H8(5),n2h8(158))
  call Hloop_QV_A(ntryL,G2H8(5),ex6(:),G2H4(12),m3h2x4(:,102),heltab2x8(:,:,113))
  call Hloop_AZ_Q(ntryL,G1H8(109),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,12),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(59),n2h2(33))
  call Hloop_QV_A(ntryL,G1H8(104),wf4(:,1),G1H2(1),m3h4x2(:,13),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(60),n2h2(34))
call HGT_OLR(G1H8(107),1,1,8)
call HGT_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(107),-16,0,G2H8(8),n2h8(159))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(13),m3h2x4(:,103),heltab2x8(:,:,116))
  call Hloop_QV_A(ntryL,G1H8(115),wf4(:,1),G1H2(1),m3h4x2(:,14),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(61),n2h2(35))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(116),-16,0,G2H8(13),n2h8(160))
  call Hloop_AV_Q(ntryL,G2H8(13),ex5(:),G2H4(15),m3h2x4(:,104),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(125),wf4(:,1),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(62),n2h2(36))
  call Hloop_QZ_A(ntryL,G1H8(126),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,16),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(63),n2h2(37))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(128),-16,0,G2H8(14),n2h8(161))
  call Hloop_AV_Q(ntryL,G2H8(14),ex5(:),G2H4(16),m3h2x4(:,105),heltab2x8(:,:,121))
  call Hloop_QZ_A(ntryL,G1H8(135),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,17),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(64),n2h2(38))
call HGT_OLR(G1H8(136),1,1,8)
call HGT_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(136),-16,0,G2H8(19),n2h8(162))
  call Hloop_AV_Q(ntryL,G2H8(19),ex5(:),G2H4(18),m3h2x4(:,106),heltab2x8(:,:,123))
  call Hloop_QZ_A(ntryL,G1H8(140),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,18),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(65),n2h2(39))
  call Hloop_QV_A(ntryL,G1H4(91),ex6(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(66),n2h2(40))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(92),-16,0,G2H4(19),n2h4(121))
  call Hloop_AV_Q(ntryL,G2H4(19),ex5(:),G2H2(67),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QV_A(ntryL,G1H4(97),ex6(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(68),n2h2(41))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(98),-16,0,G2H4(22),n2h4(122))
  call Hloop_AV_Q(ntryL,G2H4(22),ex5(:),G2H2(69),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QV_A(ntryL,G1H4(102),ex6(:),G1H2(1),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(70),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H8(141),wf4(:,1),G1H2(1),m3h4x2(:,19),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(71),n2h2(43))
call HGT_OLR(G1H8(142),1,1,8)
call HGT_invQ_OLR(G1H8(142),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(142),-32,0,G2H8(23),n2h8(163))
  call Hloop_QV_A(ntryL,G2H8(23),ex6(:),G2H4(23),m3h2x4(:,107),heltab2x8(:,:,126))
  call Hloop_AV_Q(ntryL,G1H8(147),wf4(:,1),G1H2(1),m3h4x2(:,20),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(72),n2h2(44))
call HGT_OLR(G1H8(148),1,1,8)
call HGT_invQ_OLR(G1H8(148),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(148),-32,0,G2H8(28),n2h8(164))
  call Hloop_QV_A(ntryL,G2H8(28),ex6(:),G2H4(26),m3h2x4(:,108),heltab2x8(:,:,128))
  call Hloop_AV_Q(ntryL,G1H8(152),wf4(:,1),G1H2(1),m3h4x2(:,21),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(73),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H8(153),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,22),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(74),n2h2(46))
call HGT_OLR(G1H8(154),1,1,8)
call HGT_invQ_OLR(G1H8(154),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(154),-32,0,G2H8(29),n2h8(165))
  call Hloop_QV_A(ntryL,G2H8(29),ex6(:),G2H4(30),m3h2x4(:,109),heltab2x8(:,:,131))
  call Hloop_AZ_Q(ntryL,G1H8(159),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,23),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(75),n2h2(47))
call HGT_OLR(G1H8(160),1,1,8)
call HGT_invQ_OLR(G1H8(160),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(160),-32,0,G2H8(34),n2h8(166))
  call Hloop_QV_A(ntryL,G2H8(34),ex6(:),G2H4(32),m3h2x4(:,110),heltab2x8(:,:,133))
  call Hloop_AZ_Q(ntryL,G1H8(164),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,24),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(76),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H8(165),wf4(:,1),G1H2(1),m3h4x2(:,25),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(77),n2h2(49))
call HGT_OLR(G1H8(166),1,1,8)
call HGT_invQ_OLR(G1H8(166),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(166),-16,0,G2H8(39),n2h8(167))
  call Hloop_QV_A(ntryL,G2H8(39),ex5(:),G2H4(36),m3h2x4(:,111),heltab2x8(:,:,136))
  call Hloop_AV_Q(ntryL,G1H8(171),wf4(:,1),G1H2(1),m3h4x2(:,26),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(78),n2h2(50))
call HGT_OLR(G1H8(172),1,1,8)
call HGT_invQ_OLR(G1H8(172),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(172),-16,0,G2H8(43),n2h8(168))
  call Hloop_QV_A(ntryL,G2H8(43),ex5(:),G2H4(38),m3h2x4(:,112),heltab2x8(:,:,138))
  call Hloop_AV_Q(ntryL,G1H8(176),wf4(:,1),G1H2(1),m3h4x2(:,27),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(79),n2h2(51))
  call Hloop_AZ_Q(ntryL,G1H8(177),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,28),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(80),n2h2(52))
call HGT_OLR(G1H8(178),1,1,8)
call HGT_invQ_OLR(G1H8(178),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(178),-16,0,G2H8(46),n2h8(169))
  call Hloop_QV_A(ntryL,G2H8(46),ex5(:),G2H4(39),m3h2x4(:,113),heltab2x8(:,:,141))
  call Hloop_AZ_Q(ntryL,G1H8(183),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,29),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(81),n2h2(53))
call HGT_OLR(G1H8(184),1,1,8)
call HGT_invQ_OLR(G1H8(184),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(184),-16,0,G2H8(51),n2h8(170))
  call Hloop_QV_A(ntryL,G2H8(51),ex5(:),G2H4(42),m3h2x4(:,114),heltab2x8(:,:,143))
  call Hloop_AZ_Q(ntryL,G1H8(188),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,30),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(82),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(103),ex6(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(83),n2h2(55))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(104),-16,0,G2H4(43),n2h4(123))
  call Hloop_QV_A(ntryL,G2H4(43),ex5(:),G2H2(84),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AV_Q(ntryL,G1H4(109),ex6(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(85),n2h2(56))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(110),-16,0,G2H4(46),n2h4(124))
  call Hloop_QV_A(ntryL,G2H4(46),ex5(:),G2H2(86),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AV_Q(ntryL,G1H4(114),ex6(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(87),n2h2(57))
  call Hloop_AV_Q(ntryL,G1H4(115),ex5(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(88),n2h2(58))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(116),-32,0,G2H4(50),n2h4(125))
  call Hloop_QV_A(ntryL,G2H4(50),ex6(:),G2H2(89),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AV_Q(ntryL,G1H4(121),ex5(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(90),n2h2(59))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(122),-32,0,G2H4(52),n2h4(126))
  call Hloop_QV_A(ntryL,G2H4(52),ex6(:),G2H2(91),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AV_Q(ntryL,G1H4(126),ex5(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(92),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(127),ex5(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(93),n2h2(61))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(128),-32,0,G2H4(56),n2h4(127))
  call Hloop_QV_A(ntryL,G2H4(56),ex6(:),G2H2(94),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AV_Q(ntryL,G1H4(133),ex5(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(95),n2h2(62))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-32,0,G2H4(58),n2h4(128))
  call Hloop_QV_A(ntryL,G2H4(58),ex6(:),G2H2(96),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AV_Q(ntryL,G1H4(138),ex5(:),G1H2(1),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),95,0,G2H2(97),n2h2(63))
  call Hloop_QV_A(ntryL,G1H8(189),wf4(:,1),G1H2(1),m3h4x2(:,31),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(98),n2h2(64))
call HGT_OLR(G1H8(190),1,1,8)
call HGT_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(190),-32,0,G2H8(67),n2h8(171))
  call Hloop_AV_Q(ntryL,G2H8(67),ex6(:),G2H4(59),m3h2x4(:,115),heltab2x8(:,:,146))
  call Hloop_QV_A(ntryL,G1H8(195),wf4(:,1),G1H2(1),m3h4x2(:,32),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(99),n2h2(65))
call HGT_OLR(G1H8(196),1,1,8)
call HGT_invQ_OLR(G1H8(196),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(196),-32,0,G2H8(75),n2h8(172))
  call Hloop_AV_Q(ntryL,G2H8(75),ex6(:),G2H4(62),m3h2x4(:,116),heltab2x8(:,:,148))
  call Hloop_QV_A(ntryL,G1H8(200),wf4(:,1),G1H2(1),m3h4x2(:,33),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(100),n2h2(66))
  call Hloop_QZ_A(ntryL,G1H8(201),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,34),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(101),n2h2(67))
call HGT_OLR(G1H8(202),1,1,8)
call HGT_invQ_OLR(G1H8(202),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(202),-32,0,G2H8(76),n2h8(173))
  call Hloop_AV_Q(ntryL,G2H8(76),ex6(:),G2H4(68),m3h2x4(:,117),heltab2x8(:,:,151))
  call Hloop_QZ_A(ntryL,G1H8(207),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,35),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(102),n2h2(68))
call HGT_OLR(G1H8(208),1,1,8)
call HGT_invQ_OLR(G1H8(208),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(208),-32,0,G2H8(65),n2h8(174))
  call Hloop_AV_Q(ntryL,G2H8(65),ex6(:),G2H4(69),m3h2x4(:,118),heltab2x8(:,:,153))
  call Hloop_QZ_A(ntryL,G1H8(212),wf4(:,7),G1H2(1),ngZd,m3h4x2(:,36),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(103),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(139),ex6(:),G1H2(1),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(104),n2h2(70))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-16,0,G2H4(72),n2h4(129))
  call Hloop_QV_A(ntryL,G2H4(72),ex5(:),G2H2(105),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_AV_Q(ntryL,G1H4(145),ex6(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(106),n2h2(71))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(146),-16,0,G2H4(78),n2h4(130))
  call Hloop_QV_A(ntryL,G2H4(78),ex5(:),G2H2(107),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_AV_Q(ntryL,G1H4(150),ex6(:),G1H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),111,0,G2H2(108),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(151),ex6(:),G1H2(1),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(109),n2h2(73))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(152),-16,0,G2H4(79),n2h4(131))
  call Hloop_AV_Q(ntryL,G2H4(79),ex5(:),G2H2(110),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(157),ex6(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(111),n2h2(74))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(158),-16,0,G2H4(82),n2h4(132))
  call Hloop_AV_Q(ntryL,G2H4(82),ex5(:),G2H2(112),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QV_A(ntryL,G1H4(162),ex6(:),G1H2(1),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(1),111,0,G2H2(113),n2h2(75))
  call Hloop_QV_A(ntryL,G1H4(163),ex5(:),G1H2(1),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(114),n2h2(76))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(164),-32,0,G2H4(88),n2h4(133))
  call Hloop_AV_Q(ntryL,G2H4(88),ex6(:),G2H2(115),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QV_A(ntryL,G1H4(169),ex5(:),G1H2(1),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(116),n2h2(77))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(170),-32,0,G2H4(89),n2h4(134))
  call Hloop_AV_Q(ntryL,G2H4(89),ex6(:),G2H2(117),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_QV_A(ntryL,G1H4(174),ex5(:),G1H2(1),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(1),95,0,G2H2(118),n2h2(78))
  call Hloop_QV_A(ntryL,G1H4(175),ex6(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),119,0,G2H2(119),n2h2(79))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(176),ex4(:),G1H2(1),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QV_A(ntryL,G1H4(181),ex6(:),G1H2(2),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(2),119,0,G2H2(120),n2h2(80))
call HGT_raise_alpha_OLR(G1H4(182),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(182),ex4(:),G1H2(2),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QV_A(ntryL,G1H4(187),ex6(:),G1H2(3),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(3),119,0,G2H2(121),n2h2(81))
call HGT_raise_alpha_OLR(G1H4(188),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(188),ex4(:),G1H2(3),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_QV_A(ntryL,G1H8(213),wf4(:,1),G1H2(4),m3h4x2(:,37),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(122),n2h2(82))
call HGT_raise_alpha_OLR(G1H8(214),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(214),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(214),ex4(:),G1H4(12),m3h2x4(:,119),heltab2x8(:,:,156))
  call Hloop_QV_A(ntryL,G1H8(219),wf4(:,1),G1H2(4),m3h4x2(:,38),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(123),n2h2(83))
call HGT_raise_alpha_OLR(G1H8(220),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(220),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(220),ex4(:),G1H4(24),m3h2x4(:,120),heltab2x8(:,:,158))
  call Hloop_QV_A(ntryL,G1H8(225),wf4(:,1),G1H2(4),m3h4x2(:,39),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(124),n2h2(84))
call HGT_raise_alpha_OLR(G1H8(226),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(226),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(226),ex4(:),G1H4(36),m3h2x4(:,121),heltab2x8(:,:,160))
  call Hloop_QZ_A(ntryL,G1H8(230),wf4(:,7),G1H2(4),ngZd,m3h4x2(:,40),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(125),n2h2(85))
call HGT_raise_alpha_OLR(G1H8(231),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(231),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(231),ex4(:),G1H4(48),m3h2x4(:,122),heltab2x8(:,:,162))
  call Hloop_QZ_A(ntryL,G1H8(236),wf4(:,7),G1H2(4),ngZd,m3h4x2(:,41),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(126),n2h2(86))
call HGT_raise_alpha_OLR(G1H8(237),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(237),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(237),ex4(:),G1H4(60),m3h2x4(:,123),heltab2x8(:,:,164))
  call Hloop_QZ_A(ntryL,G1H8(242),wf4(:,7),G1H2(4),ngZd,m3h4x2(:,42),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(127),n2h2(87))
call HGT_raise_alpha_OLR(G1H8(243),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(243),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(243),ex4(:),G1H4(72),m3h2x4(:,124),heltab2x8(:,:,166))
  call Hloop_QV_A(ntryL,G1H4(192),ex5(:),G1H2(4),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(4),119,0,G2H2(128),n2h2(88))
call HGT_raise_alpha_OLR(G1H4(193),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(193),ex4(:),G1H2(4),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QV_A(ntryL,G1H4(198),ex5(:),G1H2(5),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(5),119,0,G2H2(129),n2h2(89))
call HGT_raise_alpha_OLR(G1H4(199),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(199),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(199),ex4(:),G1H2(5),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_QV_A(ntryL,G1H4(204),ex5(:),G1H2(6),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(6),119,0,G2H2(130),n2h2(90))
call HGT_raise_alpha_OLR(G1H4(205),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(205),ex4(:),G1H2(6),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_QV_A(ntryL,G1H8(247),wf4(:,1),G1H2(7),m3h4x2(:,43),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(131),n2h2(91))
call HGT_raise_alpha_OLR(G1H8(248),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(248),ex4(:),G1H4(84),m3h2x4(:,125),heltab2x8(:,:,168))
  call Hloop_QV_A(ntryL,G1H8(253),wf4(:,1),G1H2(7),m3h4x2(:,44),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(132),n2h2(92))
call HGT_raise_alpha_OLR(G1H8(254),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(254),ex4(:),G1H4(96),m3h2x4(:,126),heltab2x8(:,:,170))
  call Hloop_QV_A(ntryL,G1H8(259),wf4(:,1),G1H2(7),m3h4x2(:,45),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(133),n2h2(93))
call HGT_raise_alpha_OLR(G1H8(260),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(260),ex4(:),G1H4(108),m3h2x4(:,127),heltab2x8(:,:,172))
  call Hloop_QZ_A(ntryL,G1H8(264),wf4(:,7),G1H2(7),ngZd,m3h4x2(:,46),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(134),n2h2(94))
call HGT_raise_alpha_OLR(G1H8(265),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(265),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(265),ex4(:),G1H4(120),m3h2x4(:,128),heltab2x8(:,:,174))
  call Hloop_QZ_A(ntryL,G1H8(270),wf4(:,7),G1H2(7),ngZd,m3h4x2(:,47),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(135),n2h2(95))
call HGT_raise_alpha_OLR(G1H8(271),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(271),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(271),ex4(:),G1H4(132),m3h2x4(:,129),heltab2x8(:,:,176))
  call Hloop_QZ_A(ntryL,G1H8(276),wf4(:,7),G1H2(7),ngZd,m3h4x2(:,48),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(136),n2h2(96))
call HGT_raise_alpha_OLR(G1H8(277),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(277),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(277),ex4(:),G1H4(144),m3h2x4(:,130),heltab2x8(:,:,178))
  call Hloop_QV_A(ntryL,G1H4(209),ex5(:),G1H2(7),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(7),119,0,G2H2(137),n2h2(97))
call HGT_raise_alpha_OLR(G1H4(210),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(210),ex4(:),G1H2(7),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QV_A(ntryL,G1H4(215),ex5(:),G1H2(8),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(8),119,0,G2H2(138),n2h2(98))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(216),ex4(:),G1H2(8),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QV_A(ntryL,G1H4(221),ex5(:),G1H2(9),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(9),119,0,G2H2(139),n2h2(99))
call HGT_raise_alpha_OLR(G1H4(222),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(222),2,5,4)



end subroutine vamp_1

end module ol_vamp_1_ppllaaj_eexddxaag_1_/**/REALKIND
