
module ol_colourmatrix_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 9, 3]
  K1(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND



module ol_forced_parameters_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND

module ol_tree_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(1)
  complex(REALKIND), save :: den(507)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(256) ! physical helicity states
  complex(DREALKIND) :: M1helarr(2,256) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED**4*gQCD**2)/9._/**/REALKIND

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,72) - MB2)+L(6,72))
  den(3) = 1 /((L(5,20))+L(6,20))
  den(4) = 1 /((L(5,160) - MB2)+L(6,160))
  den(7) = 1 /((L(5,75) - MB2)+L(6,75))
  den(12) = 1 /((L(5,163) - MB2)+L(6,163))
  den(15) = 1 /((L(5,35) - MB2)+L(6,35))
  den(17) = 1 /((L(5,200) - MB2)+L(6,200))
  den(21) = 1 /((L(5,92) - MB2)+L(6,92))
  den(24) = 1 /((L(5,52) - MB2)+L(6,52))
  den(29) = 1 /((L(5,136) - MB2)+L(6,136))
  den(30) = 1 /((L(5,96) - MB2)+L(6,96))
  den(33) = 1 /((L(5,139) - MB2)+L(6,139))
  den(38) = 1 /((L(5,99) - MB2)+L(6,99))
  den(41) = 1 /((L(5,11) - MB2)+L(6,11))
  den(43) = 1 /((L(5,116) - MB2)+L(6,116))
  den(46) = 1 /((L(5,224) - MB2)+L(6,224))
  den(50) = 1 /((L(5,28) - MB2)+L(6,28))
  den(57) = 1 /((L(5,156) - MB2)+L(6,156))
  den(62) = 1 /((L(5,180) - MB2)+L(6,180))
  den(77) = 1 /((L(5,68) - MB2)+L(6,68))
  den(78) = 1 /((L(5,24))+L(6,24))
  den(81) = 1 /((L(5,71) - MB2)+L(6,71))
  den(86) = 1 /((L(5,196) - MB2)+L(6,196))
  den(92) = 1 /((L(5,56) - MB2)+L(6,56))
  den(97) = 1 /((L(5,132) - MB2)+L(6,132))
  den(100) = 1 /((L(5,135) - MB2)+L(6,135))
  den(105) = 1 /((L(5,7) - MB2)+L(6,7))
  den(107) = 1 /((L(5,120) - MB2)+L(6,120))
  den(122) = 1 /((L(5,184) - MB2)+L(6,184))
  den(135) = 1 /((L(5,36))+L(6,36))
  den(136) = 1 /((L(5,144) - MB2)+L(6,144))
  den(141) = 1 /((L(5,147) - MB2)+L(6,147))
  den(144) = 1 /((L(5,19) - MB2)+L(6,19))
  den(148) = 1 /((L(5,108) - MB2)+L(6,108))
  den(155) = 1 /((L(5,80) - MB2)+L(6,80))
  den(160) = 1 /((L(5,83) - MB2)+L(6,83))
  den(165) = 1 /((L(5,208) - MB2)+L(6,208))
  den(169) = 1 /((L(5,44) - MB2)+L(6,44))
  den(175) = 1 /((L(5,172) - MB2)+L(6,172))
  den(193) = 1 /((L(5,40))+L(6,40))
  den(234) = 1 /((L(5,100))+L(6,100))
  den(238) = 1 /((L(5,168))+L(6,168))
  den(242) = 1 /((L(5,84))+L(6,84))
  den(246) = 1 /((L(5,152))+L(6,152))
  den(257) = 1 /((L(5,212))+L(6,212))
  den(269) = 1 /((L(5,228))+L(6,228))
  den(282) = 1 /((L(5,27))+L(6,27))
  den(293) = 1 /((L(5,43))+L(6,43))
  den(296) = 1 /((L(5,164))+L(6,164))
  den(300) = 1 /((L(5,104))+L(6,104))
  den(304) = 1 /((L(5,148))+L(6,148))
  den(308) = 1 /((L(5,88))+L(6,88))
  den(317) = 1 /((L(5,216))+L(6,216))
  den(329) = 1 /((L(5,232))+L(6,232))
  den(340) = 1 /((L(5,23))+L(6,23))
  den(353) = 1 /((L(5,39))+L(6,39))

  ! denominators

  den(5) = den(1)*den(2)
  den(6) = den(3)*den(4)
  den(8) = den(5)*den(7)
  den(9) = den(6)*den(8)
  den(10) = den(1)*den(4)
  den(11) = den(2)*den(3)
  den(13) = den(10)*den(12)
  den(14) = den(11)*den(13)
  den(16) = den(1)*den(15)
  den(18) = den(2)*den(17)
  den(19) = den(3)*den(16)
  den(20) = den(18)*den(19)
  den(22) = den(11)*den(21)
  den(23) = den(16)*den(22)
  den(25) = den(3)*den(24)
  den(26) = den(1)*den(25)
  den(27) = den(18)*den(26)
  den(28) = den(8)*den(25)
  den(31) = den(1)*den(29)
  den(32) = den(3)*den(30)
  den(34) = den(31)*den(33)
  den(35) = den(32)*den(34)
  den(36) = den(1)*den(30)
  den(37) = den(3)*den(29)
  den(39) = den(36)*den(38)
  den(40) = den(37)*den(39)
  den(42) = den(1)*den(41)
  den(44) = den(32)*den(43)
  den(45) = den(42)*den(44)
  den(47) = den(30)*den(46)
  den(48) = den(3)*den(42)
  den(49) = den(47)*den(48)
  den(51) = den(3)*den(50)
  den(52) = den(39)*den(51)
  den(53) = den(1)*den(51)
  den(54) = den(47)*den(53)
  den(55) = den(17)*den(29)
  den(56) = den(19)*den(55)
  den(58) = den(37)*den(57)
  den(59) = den(16)*den(58)
  den(60) = den(26)*den(55)
  den(61) = den(25)*den(34)
  den(63) = den(6)*den(62)
  den(64) = den(42)*den(63)
  den(65) = den(4)*den(46)
  den(66) = den(48)*den(65)
  den(67) = den(13)*den(51)
  den(68) = den(53)*den(65)
  den(69) = den(7)*den(42)
  den(70) = den(25)*den(69)
  den(71) = den(25)*den(43)
  den(72) = den(42)*den(71)
  den(73) = den(21)*den(51)
  den(74) = den(16)*den(73)
  den(75) = den(16)*den(38)
  den(76) = den(51)*den(75)
  den(79) = den(1)*den(77)
  den(80) = den(4)*den(78)
  den(82) = den(79)*den(81)
  den(83) = den(80)*den(82)
  den(84) = den(77)*den(78)
  den(85) = den(13)*den(84)
  den(87) = den(77)*den(86)
  den(88) = den(16)*den(78)
  den(89) = den(87)*den(88)
  den(90) = den(21)*den(84)
  den(91) = den(16)*den(90)
  den(93) = den(78)*den(92)
  den(94) = den(1)*den(93)
  den(95) = den(87)*den(94)
  den(96) = den(82)*den(93)
  den(98) = den(1)*den(97)
  den(99) = den(30)*den(78)
  den(101) = den(98)*den(100)
  den(102) = den(99)*den(101)
  den(103) = den(78)*den(97)
  den(104) = den(39)*den(103)
  den(106) = den(1)*den(105)
  den(108) = den(99)*den(107)
  den(109) = den(106)*den(108)
  den(110) = den(78)*den(106)
  den(111) = den(47)*den(110)
  den(112) = den(50)*den(78)
  den(113) = den(39)*den(112)
  den(114) = den(1)*den(112)
  den(115) = den(47)*den(114)
  den(116) = den(86)*den(97)
  den(117) = den(88)*den(116)
  den(118) = den(57)*den(103)
  den(119) = den(16)*den(118)
  den(120) = den(94)*den(116)
  den(121) = den(93)*den(101)
  den(123) = den(80)*den(122)
  den(124) = den(106)*den(123)
  den(125) = den(65)*den(110)
  den(126) = den(13)*den(112)
  den(127) = den(65)*den(114)
  den(128) = den(81)*den(106)
  den(129) = den(93)*den(128)
  den(130) = den(93)*den(107)
  den(131) = den(106)*den(130)
  den(132) = den(21)*den(112)
  den(133) = den(16)*den(132)
  den(134) = den(75)*den(112)
  den(137) = den(135)*den(136)
  den(138) = den(8)*den(137)
  den(139) = den(1)*den(136)
  den(140) = den(2)*den(135)
  den(142) = den(139)*den(141)
  den(143) = den(140)*den(142)
  den(145) = den(1)*den(144)
  den(146) = den(135)*den(145)
  den(147) = den(18)*den(146)
  den(149) = den(140)*den(148)
  den(150) = den(145)*den(149)
  den(151) = den(24)*den(135)
  den(152) = den(1)*den(151)
  den(153) = den(18)*den(152)
  den(154) = den(8)*den(151)
  den(156) = den(135)*den(155)
  den(157) = den(34)*den(156)
  den(158) = den(1)*den(155)
  den(159) = den(29)*den(135)
  den(161) = den(158)*den(160)
  den(162) = den(159)*den(161)
  den(163) = den(43)*den(156)
  den(164) = den(42)*den(163)
  den(166) = den(155)*den(165)
  den(167) = den(42)*den(135)
  den(168) = den(166)*den(167)
  den(170) = den(135)*den(169)
  den(171) = den(161)*den(170)
  den(172) = den(1)*den(170)
  den(173) = den(166)*den(172)
  den(174) = den(55)*den(146)
  den(176) = den(159)*den(175)
  den(177) = den(145)*den(176)
  den(178) = den(55)*den(152)
  den(179) = den(34)*den(151)
  den(180) = den(62)*den(137)
  den(181) = den(42)*den(180)
  den(182) = den(136)*den(165)
  den(183) = den(167)*den(182)
  den(184) = den(142)*den(170)
  den(185) = den(172)*den(182)
  den(186) = den(69)*den(151)
  den(187) = den(43)*den(151)
  den(188) = den(42)*den(187)
  den(189) = den(148)*den(170)
  den(190) = den(145)*den(189)
  den(191) = den(145)*den(160)
  den(192) = den(170)*den(191)
  den(194) = den(136)*den(193)
  den(195) = den(82)*den(194)
  den(196) = den(77)*den(193)
  den(197) = den(142)*den(196)
  den(198) = den(145)*den(193)
  den(199) = den(87)*den(198)
  den(200) = den(148)*den(196)
  den(201) = den(145)*den(200)
  den(202) = den(92)*den(193)
  den(203) = den(1)*den(202)
  den(204) = den(87)*den(203)
  den(205) = den(82)*den(202)
  den(206) = den(155)*den(193)
  den(207) = den(101)*den(206)
  den(208) = den(97)*den(193)
  den(209) = den(161)*den(208)
  den(210) = den(107)*den(206)
  den(211) = den(106)*den(210)
  den(212) = den(106)*den(193)
  den(213) = den(166)*den(212)
  den(214) = den(169)*den(193)
  den(215) = den(161)*den(214)
  den(216) = den(1)*den(214)
  den(217) = den(166)*den(216)
  den(218) = den(116)*den(198)
  den(219) = den(175)*den(208)
  den(220) = den(145)*den(219)
  den(221) = den(116)*den(203)
  den(222) = den(101)*den(202)
  den(223) = den(122)*den(194)
  den(224) = den(106)*den(223)
  den(225) = den(182)*den(212)
  den(226) = den(142)*den(214)
  den(227) = den(182)*den(216)
  den(228) = den(128)*den(202)
  den(229) = den(107)*den(202)
  den(230) = den(106)*den(229)
  den(231) = den(148)*den(214)
  den(232) = den(145)*den(231)
  den(233) = den(191)*den(214)
  den(235) = den(77)*den(234)
  den(236) = den(29)*den(145)
  den(237) = den(235)*den(236)
  den(239) = den(29)*den(238)
  den(240) = den(77)*den(145)
  den(241) = den(239)*den(240)
  den(243) = den(77)*den(242)
  den(244) = den(29)*den(243)
  den(245) = den(16)*den(244)
  den(247) = den(29)*den(246)
  den(248) = den(77)*den(247)
  den(249) = den(16)*den(248)
  den(250) = den(34)*den(243)
  den(251) = den(34)*den(235)
  den(252) = den(82)*den(247)
  den(253) = den(82)*den(239)
  den(254) = den(42)*den(136)
  den(255) = den(235)*den(254)
  den(256) = den(77)*den(136)
  den(258) = den(256)*den(257)
  den(259) = den(42)*den(258)
  den(260) = den(136)*den(246)
  den(261) = den(77)*den(260)
  den(262) = den(16)*den(261)
  den(263) = den(16)*den(258)
  den(264) = den(142)*den(235)
  den(265) = den(82)*den(260)
  den(266) = den(42)*den(243)
  den(267) = den(4)*den(266)
  den(268) = den(4)*den(77)
  den(270) = den(268)*den(269)
  den(271) = den(42)*den(270)
  den(272) = den(145)*den(270)
  den(273) = den(4)*den(238)
  den(274) = den(77)*den(273)
  den(275) = den(145)*den(274)
  den(276) = den(13)*den(243)
  den(277) = den(82)*den(273)
  den(278) = den(43)*den(243)
  den(279) = den(42)*den(278)
  den(280) = den(43)*den(235)
  den(281) = den(42)*den(280)
  den(283) = den(42)*den(282)
  den(284) = den(87)*den(283)
  den(285) = den(87)*den(257)
  den(286) = den(42)*den(285)
  den(287) = den(148)*den(235)
  den(288) = den(145)*den(287)
  den(289) = den(145)*den(282)
  den(290) = den(87)*den(289)
  den(291) = den(21)*den(243)
  den(292) = den(16)*den(291)
  den(294) = den(16)*den(293)
  den(295) = den(87)*den(294)
  den(297) = den(97)*den(296)
  den(298) = den(2)*den(145)
  den(299) = den(297)*den(298)
  den(301) = den(2)*den(300)
  den(302) = den(97)*den(145)
  den(303) = den(301)*den(302)
  den(305) = den(97)*den(304)
  den(306) = den(2)*den(305)
  den(307) = den(16)*den(306)
  den(309) = den(2)*den(308)
  den(310) = den(97)*den(309)
  den(311) = den(16)*den(310)
  den(312) = den(8)*den(305)
  den(313) = den(8)*den(297)
  den(314) = den(101)*den(309)
  den(315) = den(101)*den(301)
  den(316) = den(2)*den(136)
  den(318) = den(316)*den(317)
  den(319) = den(106)*den(318)
  den(320) = den(106)*den(136)
  den(321) = den(301)*den(320)
  den(322) = den(136)*den(304)
  den(323) = den(2)*den(322)
  den(324) = den(16)*den(323)
  den(325) = den(16)*den(318)
  den(326) = den(8)*den(322)
  den(327) = den(142)*den(301)
  den(328) = den(2)*den(4)
  den(330) = den(328)*den(329)
  den(331) = den(106)*den(330)
  den(332) = den(106)*den(309)
  den(333) = den(4)*den(332)
  den(334) = den(145)*den(330)
  den(335) = den(4)*den(296)
  den(336) = den(2)*den(335)
  den(337) = den(145)*den(336)
  den(338) = den(8)*den(335)
  den(339) = den(13)*den(309)
  den(341) = den(106)*den(340)
  den(342) = den(18)*den(341)
  den(343) = den(18)*den(317)
  den(344) = den(106)*den(343)
  den(345) = den(107)*den(309)
  den(346) = den(106)*den(345)
  den(347) = den(107)*den(301)
  den(348) = den(106)*den(347)
  den(349) = den(145)*den(340)
  den(350) = den(18)*den(349)
  den(351) = den(148)*den(301)
  den(352) = den(145)*den(351)
  den(354) = den(16)*den(353)
  den(355) = den(18)*den(354)
  den(356) = den(21)*den(309)
  den(357) = den(16)*den(356)
  den(358) = den(42)*den(155)
  den(359) = den(297)*den(358)
  den(360) = den(97)*den(155)
  den(361) = den(257)*den(360)
  den(362) = den(42)*den(361)
  den(363) = den(155)*den(308)
  den(364) = den(97)*den(363)
  den(365) = den(16)*den(364)
  den(366) = den(16)*den(361)
  den(367) = den(161)*den(297)
  den(368) = den(101)*den(363)
  den(369) = den(29)*den(155)
  den(370) = den(317)*den(369)
  den(371) = den(106)*den(370)
  den(372) = den(106)*den(155)
  den(373) = den(239)*den(372)
  den(374) = den(155)*den(242)
  den(375) = den(29)*den(374)
  den(376) = den(16)*den(375)
  den(377) = den(16)*den(370)
  den(378) = den(34)*den(374)
  den(379) = den(161)*den(239)
  den(380) = den(106)*den(363)
  den(381) = den(4)*den(380)
  den(382) = den(106)*den(273)
  den(383) = den(155)*den(382)
  den(384) = den(42)*den(374)
  den(385) = den(4)*den(384)
  den(386) = den(42)*den(335)
  den(387) = den(155)*den(386)
  den(388) = den(13)*den(374)
  den(389) = den(161)*den(335)
  den(390) = den(13)*den(363)
  den(391) = den(161)*den(273)
  den(392) = den(166)*den(317)
  den(393) = den(106)*den(392)
  den(394) = den(107)*den(363)
  den(395) = den(106)*den(394)
  den(396) = den(43)*den(374)
  den(397) = den(42)*den(396)
  den(398) = den(166)*den(257)
  den(399) = den(42)*den(398)
  den(400) = den(21)*den(374)
  den(401) = den(16)*den(400)
  den(402) = den(166)*den(354)
  den(403) = den(21)*den(363)
  den(404) = den(16)*den(403)
  den(405) = den(16)*den(398)
  den(406) = den(42)*den(305)
  den(407) = den(30)*den(406)
  den(408) = den(30)*den(97)
  den(409) = den(269)*den(408)
  den(410) = den(42)*den(409)
  den(411) = den(145)*den(409)
  den(412) = den(30)*den(300)
  den(413) = den(97)*den(412)
  den(414) = den(145)*den(413)
  den(415) = den(39)*den(305)
  den(416) = den(101)*den(412)
  den(417) = den(29)*den(30)
  den(418) = den(329)*den(417)
  den(419) = den(106)*den(418)
  den(420) = den(106)*den(247)
  den(421) = den(30)*den(420)
  den(422) = den(145)*den(418)
  den(423) = den(30)*den(234)
  den(424) = den(29)*den(423)
  den(425) = den(145)*den(424)
  den(426) = den(34)*den(423)
  den(427) = den(39)*den(247)
  den(428) = den(106)*den(260)
  den(429) = den(30)*den(428)
  den(430) = den(106)*den(412)
  den(431) = den(136)*den(430)
  den(432) = den(42)*den(322)
  den(433) = den(30)*den(432)
  den(434) = den(42)*den(423)
  den(435) = den(136)*den(434)
  den(436) = den(39)*den(322)
  den(437) = den(142)*den(423)
  den(438) = den(39)*den(260)
  den(439) = den(142)*den(412)
  den(440) = den(47)*den(329)
  den(441) = den(106)*den(440)
  den(442) = den(107)*den(412)
  den(443) = den(106)*den(442)
  den(444) = den(43)*den(423)
  den(445) = den(42)*den(444)
  den(446) = den(47)*den(269)
  den(447) = den(42)*den(446)
  den(448) = den(47)*den(349)
  den(449) = den(148)*den(423)
  den(450) = den(145)*den(449)
  den(451) = den(145)*den(446)
  den(452) = den(148)*den(412)
  den(453) = den(145)*den(452)
  den(454) = den(62)*den(305)
  den(455) = den(42)*den(454)
  den(456) = den(62)*den(297)
  den(457) = den(42)*den(456)
  den(458) = den(116)*den(283)
  den(459) = den(116)*den(257)
  den(460) = den(42)*den(459)
  den(461) = den(175)*den(297)
  den(462) = den(145)*den(461)
  den(463) = den(116)*den(289)
  den(464) = den(57)*den(305)
  den(465) = den(16)*den(464)
  den(466) = den(116)*den(294)
  den(467) = den(55)*den(341)
  den(468) = den(55)*den(317)
  den(469) = den(106)*den(468)
  den(470) = den(122)*den(247)
  den(471) = den(106)*den(470)
  den(472) = den(122)*den(239)
  den(473) = den(106)*den(472)
  den(474) = den(55)*den(349)
  den(475) = den(175)*den(239)
  den(476) = den(145)*den(475)
  den(477) = den(55)*den(354)
  den(478) = den(57)*den(247)
  den(479) = den(16)*den(478)
  den(480) = den(182)*den(317)
  den(481) = den(106)*den(480)
  den(482) = den(122)*den(260)
  den(483) = den(106)*den(482)
  den(484) = den(62)*den(322)
  den(485) = den(42)*den(484)
  den(486) = den(182)*den(257)
  den(487) = den(42)*den(486)
  den(488) = den(57)*den(322)
  den(489) = den(16)*den(488)
  den(490) = den(182)*den(354)
  den(491) = den(57)*den(260)
  den(492) = den(16)*den(491)
  den(493) = den(16)*den(486)
  den(494) = den(65)*den(329)
  den(495) = den(106)*den(494)
  den(496) = den(122)*den(273)
  den(497) = den(106)*den(496)
  den(498) = den(62)*den(335)
  den(499) = den(42)*den(498)
  den(500) = den(65)*den(269)
  den(501) = den(42)*den(500)
  den(502) = den(65)*den(349)
  den(503) = den(175)*den(335)
  den(504) = den(145)*den(503)
  den(505) = den(145)*den(500)
  den(506) = den(175)*den(273)
  den(507) = den(145)*den(506)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppllaaj_nenexbbbxbxaa_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppllaaj_nenexbbbxbxaa_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e anti-nu_e bottom bottom anti-bottom anti-bottom gamma gamma -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllaaj_nenexbbbxbxaa_1, only: &
    & external_perm_ppllaaj_nenexbbbxbxaa_1, &
    & external_perm_inv_ppllaaj_nenexbbbxbxaa_1, &
    & extcomb_perm_ppllaaj_nenexbbbxbxaa_1, &
    & average_factor_ppllaaj_nenexbbbxbxaa_1
  use ol_external_ppllaaj_nenexbbbxbxaa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppllaaj_nenexbbbxbxaa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:1-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,8)
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add(0:1-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(2), M1helarray(2,256)
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,22), wf8(8,56), wf16(16,180), wf32(32,36), wf64(64,12), wf256(256,240)

  type(polcont) :: A(256,240)
  complex(REALKIND) :: Aj(240)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMB, nMB, nMB, nMB, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllaaj_nenexbbbxbxaa_1, 8,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppllaaj_nenexbbbxbxaa_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppllaaj_nenexbbbxbxaa_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllaaj_nenexbbbxbxaa_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3))
  call pol_wf_Q(P(:,4), rMB, H4, ex4, POLSEL(4))
  call pol_wf_A(P(:,5), rMB, H5, ex5, POLSEL(5))
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))
  call pol_wf_V(P(:,8), rZERO, H8, ex8, POLSEL(8))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_A(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_Q(P(:,3), rMB, H3, ex3, 0)
      call pol_wf_Q(P(:,4), rMB, H4, ex4, 0)
      call pol_wf_A(P(:,5), rMB, H5, ex5, 0)
      call pol_wf_A(P(:,6), rMB, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)
      call pol_wf_V(P(:,8), rZERO, H8, ex8, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)
    call helbookkeeping_flip(H8, 8, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H8, ex8, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1, ex2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3, ex5, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7, ex4, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AV_Q(ntry, ex6, ex8, wf4(:,4), n3(:,4), t3x4(:,:,4))
  call prop_W_W(ntry, wf4(:,1), 3, MZ, 1_intkind1, wf4(:,5), n2(1))
  call prop_Q_A(ntry, wf4(:,3), 72, MB, 1_intkind1, wf4(:,6), n2(2))
  call prop_A_Q(ntry, wf4(:,4), 160, MB, 1_intkind1, wf4(:,7), n2(3))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf4(:,6), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,2), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call prop_Q_A(ntry, wf16(:,1), 75, MB, 1_intkind1, wf16(:,3), n2(4))
  call vert_AZ_Q(gZd,ntry, wf4(:,7), wf4(:,5), wf16(:,4), n3(:,7), t3x16(:,:,3))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,6), wf16(:,5), n3(:,8), t3x16(:,:,4))
  call prop_A_Q(ntry, wf16(:,4), 163, MB, 1_intkind1, wf16(:,6), n2(5))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,5), wf8(:,1), n3(:,9), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex8, wf4(:,6), wf8(:,2), n3(:,10), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 35, MB, 1_intkind1, wf8(:,3), n2(6))
  call prop_Q_A(ntry, wf8(:,2), 200, MB, 1_intkind1, wf8(:,4), n2(7))
  call vert_AV_Q(ntry, wf8(:,3), wf4(:,2), wf32(:,1), n3(:,11), t3x32(:,:,1))
  call prop_Q_A(ntry, wf16(:,5), 92, MB, 1_intkind1, wf16(:,7), n2(8))
  call vert_AV_Q(ntry, wf8(:,3), ex8, wf16(:,8), n3(:,12), t3x16(:,:,5))
  call vert_AV_Q(ntry, ex6, wf4(:,2), wf8(:,5), n3(:,13), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 52, MB, 1_intkind1, wf8(:,6), n2(9))
  call vert_AZ_Q(gZd,ntry, wf8(:,6), wf4(:,5), wf32(:,2), n3(:,14), t3x32(:,:,2))
  call vert_AV_Q(ntry, wf8(:,6), ex8, wf16(:,9), n3(:,15), t3x16(:,:,6))
  call vert_VQ_A(ntry, ex8, ex4, wf4(:,8), n3(:,16), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex6, ex7, wf4(:,9), n3(:,17), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,8), 136, MB, 1_intkind1, wf4(:,10), n2(10))
  call prop_A_Q(ntry, wf4(:,9), 96, MB, 1_intkind1, wf4(:,11), n2(11))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf4(:,10), wf16(:,10), n3(:,18), t3x16(:,:,7))
  call vert_AV_Q(ntry, wf4(:,11), wf4(:,2), wf16(:,11), n3(:,19), t3x16(:,:,8))
  call prop_Q_A(ntry, wf16(:,10), 139, MB, 1_intkind1, wf16(:,12), n2(12))
  call vert_AZ_Q(gZd,ntry, wf4(:,11), wf4(:,5), wf16(:,13), n3(:,20), t3x16(:,:,9))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,10), wf16(:,14), n3(:,21), t3x16(:,:,10))
  call prop_A_Q(ntry, wf16(:,13), 99, MB, 1_intkind1, wf16(:,15), n2(13))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), ex4, wf8(:,7), n3(:,22), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 11, MB, 1_intkind1, wf8(:,8), n2(14))
  call prop_A_Q(ntry, wf16(:,11), 116, MB, 1_intkind1, wf16(:,16), n2(15))
  call vert_VQ_A(ntry, ex8, wf8(:,8), wf16(:,17), n3(:,23), t3x16(:,:,11))
  call vert_AV_Q(ntry, wf4(:,11), ex8, wf8(:,9), n3(:,24), t3x8(:,:,5))
  call prop_A_Q(ntry, wf8(:,9), 224, MB, 1_intkind1, wf8(:,10), n2(16))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,8), wf32(:,3), n3(:,25), t3x32(:,:,3))
  call vert_VQ_A(ntry, wf4(:,2), ex4, wf8(:,11), n3(:,26), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 28, MB, 1_intkind1, wf8(:,12), n2(17))
  call vert_VQ_A(ntry, ex8, wf8(:,12), wf16(:,18), n3(:,27), t3x16(:,:,12))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf8(:,12), wf32(:,4), n3(:,28), t3x32(:,:,4))
  call vert_VQ_A(ntry, ex7, wf4(:,10), wf8(:,13), n3(:,29), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,13), 200, MB, 1_intkind1, wf8(:,14), n2(18))
  call prop_Q_A(ntry, wf16(:,14), 156, MB, 1_intkind1, wf16(:,19), n2(19))
  call vert_AV_Q(ntry, wf8(:,3), ex7, wf16(:,20), n3(:,30), t3x16(:,:,13))
  call vert_AV_Q(ntry, wf8(:,6), ex7, wf16(:,21), n3(:,31), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,2), 180, MB, 1_intkind1, wf16(:,22), n2(20))
  call vert_VQ_A(ntry, ex7, wf8(:,8), wf16(:,23), n3(:,32), t3x16(:,:,15))
  call vert_AV_Q(ntry, wf4(:,7), ex7, wf8(:,15), n3(:,33), t3x8(:,:,8))
  call prop_A_Q(ntry, wf8(:,15), 224, MB, 1_intkind1, wf8(:,16), n2(21))
  call vert_VQ_A(ntry, ex7, wf8(:,12), wf16(:,24), n3(:,34), t3x16(:,:,16))
  call prop_Q_A(ntry, wf16(:,23), 75, MB, 1_intkind1, wf16(:,25), n2(22))
  call prop_A_Q(ntry, wf16(:,21), 116, MB, 1_intkind1, wf16(:,26), n2(23))
  call prop_Q_A(ntry, wf16(:,24), 92, MB, 1_intkind1, wf16(:,27), n2(24))
  call prop_A_Q(ntry, wf16(:,20), 99, MB, 1_intkind1, wf16(:,28), n2(25))
  call vert_VQ_A(ntry, ex7, ex3, wf4(:,12), n3(:,35), t3x4(:,:,7))
  call vert_QA_V(ntry, ex4, ex5, wf4(:,13), n3(:,36), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,12), 68, MB, 1_intkind1, wf4(:,14), n2(26))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf4(:,14), wf16(:,29), n3(:,37), t3x16(:,:,17))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,13), wf16(:,30), n3(:,38), t3x16(:,:,18))
  call prop_Q_A(ntry, wf16(:,29), 71, MB, 1_intkind1, wf16(:,31), n2(27))
  call vert_VQ_A(ntry, wf4(:,13), wf4(:,14), wf16(:,32), n3(:,39), t3x16(:,:,19))
  call vert_VQ_A(ntry, ex8, wf4(:,14), wf8(:,17), n3(:,40), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,17), 196, MB, 1_intkind1, wf8(:,18), n2(28))
  call vert_AV_Q(ntry, wf8(:,3), wf4(:,13), wf32(:,5), n3(:,41), t3x32(:,:,5))
  call prop_Q_A(ntry, wf16(:,32), 92, MB, 1_intkind1, wf16(:,33), n2(29))
  call vert_AV_Q(ntry, ex6, wf4(:,13), wf8(:,19), n3(:,42), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 56, MB, 1_intkind1, wf8(:,20), n2(30))
  call vert_AZ_Q(gZd,ntry, wf8(:,20), wf4(:,5), wf32(:,6), n3(:,43), t3x32(:,:,6))
  call vert_AV_Q(ntry, wf8(:,20), ex8, wf16(:,34), n3(:,44), t3x16(:,:,20))
  call vert_VQ_A(ntry, ex8, ex3, wf4(:,15), n3(:,45), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,15), 132, MB, 1_intkind1, wf4(:,16), n2(31))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf4(:,16), wf16(:,35), n3(:,46), t3x16(:,:,21))
  call vert_AV_Q(ntry, wf4(:,11), wf4(:,13), wf16(:,36), n3(:,47), t3x16(:,:,22))
  call prop_Q_A(ntry, wf16(:,35), 135, MB, 1_intkind1, wf16(:,37), n2(32))
  call vert_VQ_A(ntry, wf4(:,13), wf4(:,16), wf16(:,38), n3(:,48), t3x16(:,:,23))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), ex3, wf8(:,21), n3(:,49), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,21), 7, MB, 1_intkind1, wf8(:,22), n2(33))
  call prop_A_Q(ntry, wf16(:,36), 120, MB, 1_intkind1, wf16(:,39), n2(34))
  call vert_VQ_A(ntry, ex8, wf8(:,22), wf16(:,40), n3(:,50), t3x16(:,:,24))
  call vert_VQ_A(ntry, wf4(:,13), wf8(:,22), wf32(:,7), n3(:,51), t3x32(:,:,7))
  call vert_VQ_A(ntry, wf4(:,13), ex3, wf8(:,23), n3(:,52), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,23), 28, MB, 1_intkind1, wf8(:,24), n2(35))
  call vert_VQ_A(ntry, ex8, wf8(:,24), wf16(:,41), n3(:,53), t3x16(:,:,25))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf8(:,24), wf32(:,8), n3(:,54), t3x32(:,:,8))
  call vert_VQ_A(ntry, ex7, wf4(:,16), wf8(:,25), n3(:,55), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,25), 196, MB, 1_intkind1, wf8(:,26), n2(36))
  call prop_Q_A(ntry, wf16(:,38), 156, MB, 1_intkind1, wf16(:,42), n2(37))
  call vert_AV_Q(ntry, wf8(:,20), ex7, wf16(:,43), n3(:,56), t3x16(:,:,26))
  call prop_A_Q(ntry, wf16(:,30), 184, MB, 1_intkind1, wf16(:,44), n2(38))
  call vert_VQ_A(ntry, ex7, wf8(:,22), wf16(:,45), n3(:,57), t3x16(:,:,27))
  call vert_VQ_A(ntry, ex7, wf8(:,24), wf16(:,46), n3(:,58), t3x16(:,:,28))
  call prop_Q_A(ntry, wf16(:,45), 71, MB, 1_intkind1, wf16(:,47), n2(39))
  call prop_A_Q(ntry, wf16(:,43), 120, MB, 1_intkind1, wf16(:,48), n2(40))
  call prop_Q_A(ntry, wf16(:,46), 92, MB, 1_intkind1, wf16(:,49), n2(41))
  call vert_QA_V(ntry, ex3, ex6, wf4(:,17), n3(:,59), t3x4(:,:,10))
  call vert_AV_Q(ntry, ex5, ex8, wf4(:,18), n3(:,60), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,18), 144, MB, 1_intkind1, wf4(:,19), n2(42))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,17), wf16(:,50), n3(:,61), t3x16(:,:,29))
  call vert_AZ_Q(gZd,ntry, wf4(:,19), wf4(:,5), wf16(:,51), n3(:,62), t3x16(:,:,30))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,6), wf16(:,52), n3(:,63), t3x16(:,:,31))
  call prop_A_Q(ntry, wf16(:,51), 147, MB, 1_intkind1, wf16(:,53), n2(43))
  call vert_AZ_Q(gZd,ntry, ex5, wf4(:,5), wf8(:,27), n3(:,64), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 19, MB, 1_intkind1, wf8(:,28), n2(44))
  call vert_AV_Q(ntry, wf8(:,28), wf4(:,17), wf32(:,9), n3(:,65), t3x32(:,:,9))
  call prop_Q_A(ntry, wf16(:,52), 108, MB, 1_intkind1, wf16(:,54), n2(45))
  call vert_AV_Q(ntry, wf8(:,28), ex8, wf16(:,55), n3(:,66), t3x16(:,:,32))
  call vert_AV_Q(ntry, ex5, wf4(:,17), wf8(:,29), n3(:,67), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,29), 52, MB, 1_intkind1, wf8(:,30), n2(46))
  call vert_AZ_Q(gZd,ntry, wf8(:,30), wf4(:,5), wf32(:,10), n3(:,68), t3x32(:,:,10))
  call vert_AV_Q(ntry, wf8(:,30), ex8, wf16(:,56), n3(:,69), t3x16(:,:,33))
  call vert_AV_Q(ntry, ex5, ex7, wf4(:,20), n3(:,70), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,20), 80, MB, 1_intkind1, wf4(:,21), n2(47))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,17), wf16(:,57), n3(:,71), t3x16(:,:,34))
  call vert_AZ_Q(gZd,ntry, wf4(:,21), wf4(:,5), wf16(:,58), n3(:,72), t3x16(:,:,35))
  call vert_VQ_A(ntry, wf4(:,17), wf4(:,10), wf16(:,59), n3(:,73), t3x16(:,:,36))
  call prop_A_Q(ntry, wf16(:,58), 83, MB, 1_intkind1, wf16(:,60), n2(48))
  call prop_A_Q(ntry, wf16(:,57), 116, MB, 1_intkind1, wf16(:,61), n2(49))
  call vert_AV_Q(ntry, wf4(:,21), ex8, wf8(:,31), n3(:,74), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,31), 208, MB, 1_intkind1, wf8(:,32), n2(50))
  call vert_VQ_A(ntry, wf4(:,17), wf8(:,8), wf32(:,11), n3(:,75), t3x32(:,:,11))
  call vert_VQ_A(ntry, wf4(:,17), ex4, wf8(:,33), n3(:,76), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,33), 44, MB, 1_intkind1, wf8(:,34), n2(51))
  call vert_VQ_A(ntry, ex8, wf8(:,34), wf16(:,62), n3(:,77), t3x16(:,:,37))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf8(:,34), wf32(:,12), n3(:,78), t3x32(:,:,12))
  call prop_Q_A(ntry, wf16(:,59), 172, MB, 1_intkind1, wf16(:,63), n2(52))
  call vert_AV_Q(ntry, wf8(:,28), ex7, wf16(:,64), n3(:,79), t3x16(:,:,38))
  call vert_AV_Q(ntry, wf8(:,30), ex7, wf16(:,65), n3(:,80), t3x16(:,:,39))
  call prop_A_Q(ntry, wf16(:,50), 180, MB, 1_intkind1, wf16(:,66), n2(53))
  call vert_AV_Q(ntry, wf4(:,19), ex7, wf8(:,35), n3(:,81), t3x8(:,:,18))
  call prop_A_Q(ntry, wf8(:,35), 208, MB, 1_intkind1, wf8(:,36), n2(54))
  call vert_VQ_A(ntry, ex7, wf8(:,34), wf16(:,67), n3(:,82), t3x16(:,:,40))
  call prop_A_Q(ntry, wf16(:,65), 116, MB, 1_intkind1, wf16(:,68), n2(55))
  call prop_Q_A(ntry, wf16(:,67), 108, MB, 1_intkind1, wf16(:,69), n2(56))
  call prop_A_Q(ntry, wf16(:,64), 83, MB, 1_intkind1, wf16(:,70), n2(57))
  call vert_QA_V(ntry, ex4, ex6, wf4(:,22), n3(:,83), t3x4(:,:,13))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,22), wf16(:,71), n3(:,84), t3x16(:,:,41))
  call vert_VQ_A(ntry, wf4(:,22), wf4(:,14), wf16(:,72), n3(:,85), t3x16(:,:,42))
  call vert_AV_Q(ntry, wf8(:,28), wf4(:,22), wf32(:,13), n3(:,86), t3x32(:,:,13))
  call prop_Q_A(ntry, wf16(:,72), 108, MB, 1_intkind1, wf16(:,73), n2(58))
  call vert_AV_Q(ntry, ex5, wf4(:,22), wf8(:,37), n3(:,87), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,37), 56, MB, 1_intkind1, wf8(:,38), n2(59))
  call vert_AZ_Q(gZd,ntry, wf8(:,38), wf4(:,5), wf32(:,14), n3(:,88), t3x32(:,:,14))
  call vert_AV_Q(ntry, wf8(:,38), ex8, wf16(:,74), n3(:,89), t3x16(:,:,43))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,22), wf16(:,75), n3(:,90), t3x16(:,:,44))
  call vert_VQ_A(ntry, wf4(:,22), wf4(:,16), wf16(:,76), n3(:,91), t3x16(:,:,45))
  call prop_A_Q(ntry, wf16(:,75), 120, MB, 1_intkind1, wf16(:,77), n2(60))
  call vert_VQ_A(ntry, wf4(:,22), wf8(:,22), wf32(:,15), n3(:,92), t3x32(:,:,15))
  call vert_VQ_A(ntry, wf4(:,22), ex3, wf8(:,39), n3(:,93), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,39), 44, MB, 1_intkind1, wf8(:,40), n2(61))
  call vert_VQ_A(ntry, ex8, wf8(:,40), wf16(:,78), n3(:,94), t3x16(:,:,46))
  call vert_ZQ_A(gZd,ntry, wf4(:,5), wf8(:,40), wf32(:,16), n3(:,95), t3x32(:,:,16))
  call prop_Q_A(ntry, wf16(:,76), 172, MB, 1_intkind1, wf16(:,79), n2(62))
  call vert_AV_Q(ntry, wf8(:,38), ex7, wf16(:,80), n3(:,96), t3x16(:,:,47))
  call prop_A_Q(ntry, wf16(:,71), 184, MB, 1_intkind1, wf16(:,81), n2(63))
  call vert_VQ_A(ntry, ex7, wf8(:,40), wf16(:,82), n3(:,97), t3x16(:,:,48))
  call prop_A_Q(ntry, wf16(:,80), 120, MB, 1_intkind1, wf16(:,83), n2(64))
  call prop_Q_A(ntry, wf16(:,82), 108, MB, 1_intkind1, wf16(:,84), n2(65))
  call vert_QA_V(ntry, wf4(:,14), ex6, wf8(:,41), n3(:,98), t3x8(:,:,21))
  call vert_QA_V(ntry, wf4(:,10), wf8(:,28), wf32(:,17), n3(:,99), t3x32(:,:,17))
  call vert_QA_V(ntry, wf4(:,10), ex6, wf8(:,42), n3(:,100), t3x8(:,:,22))
  call vert_QA_V(ntry, wf4(:,14), wf8(:,28), wf32(:,18), n3(:,101), t3x32(:,:,18))
  call vert_QA_V(ntry, wf4(:,14), ex5, wf8(:,43), n3(:,102), t3x8(:,:,23))
  call vert_VQ_A(ntry, wf8(:,43), wf4(:,10), wf32(:,19), n3(:,103), t3x32(:,:,19))
  call vert_QA_V(ntry, wf4(:,10), ex5, wf8(:,44), n3(:,104), t3x8(:,:,24))
  call vert_VQ_A(ntry, wf8(:,44), wf4(:,14), wf32(:,20), n3(:,105), t3x32(:,:,20))
  call vert_AV_Q(ntry, ex6, wf8(:,43), wf16(:,85), n3(:,106), t3x16(:,:,49))
  call vert_AV_Q(ntry, ex5, wf8(:,41), wf16(:,86), n3(:,107), t3x16(:,:,50))
  call vert_AV_Q(ntry, ex6, wf8(:,44), wf16(:,87), n3(:,108), t3x16(:,:,51))
  call vert_AV_Q(ntry, ex5, wf8(:,42), wf16(:,88), n3(:,109), t3x16(:,:,52))
  call vert_QA_V(ntry, wf8(:,8), wf4(:,19), wf32(:,21), n3(:,110), t3x32(:,:,21))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,19), wf16(:,89), n3(:,111), t3x16(:,:,53))
  call vert_QA_V(ntry, wf8(:,8), ex6, wf16(:,90), n3(:,112), t3x16(:,:,54))
  call vert_QA_V(ntry, ex4, wf4(:,19), wf8(:,45), n3(:,113), t3x8(:,:,25))
  call vert_VQ_A(ntry, wf8(:,45), wf4(:,14), wf32(:,22), n3(:,114), t3x32(:,:,22))
  call vert_QA_V(ntry, ex4, wf8(:,3), wf16(:,91), n3(:,115), t3x16(:,:,55))
  call vert_VQ_A(ntry, wf8(:,41), ex4, wf16(:,92), n3(:,116), t3x16(:,:,56))
  call vert_AV_Q(ntry, ex6, wf8(:,45), wf16(:,93), n3(:,117), t3x16(:,:,57))
  call vert_VQ_A(ntry, wf8(:,43), wf8(:,8), wf64(:,1), n3(:,118), t3x64(:,:,1))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,7), wf16(:,94), n3(:,119), t3x16(:,:,58))
  call vert_QA_V(ntry, wf8(:,8), ex5, wf16(:,95), n3(:,120), t3x16(:,:,59))
  call vert_QA_V(ntry, ex4, wf8(:,28), wf16(:,96), n3(:,121), t3x16(:,:,60))
  call vert_QA_V(ntry, ex4, wf4(:,7), wf8(:,46), n3(:,122), t3x8(:,:,26))
  call vert_VQ_A(ntry, wf8(:,46), wf4(:,14), wf32(:,23), n3(:,123), t3x32(:,:,23))
  call vert_VQ_A(ntry, wf8(:,43), ex4, wf16(:,97), n3(:,124), t3x16(:,:,61))
  call vert_AV_Q(ntry, ex5, wf8(:,46), wf16(:,98), n3(:,125), t3x16(:,:,62))
  call prop_A_Q(ntry, wf16(:,85), 116, MB, 1_intkind1, wf16(:,99), n2(66))
  call prop_A_Q(ntry, wf16(:,86), 116, MB, 1_intkind1, wf16(:,100), n2(67))
  call vert_QA_V(ntry, wf8(:,18), ex6, wf16(:,101), n3(:,126), t3x16(:,:,63))
  call vert_QA_V(ntry, wf8(:,18), ex5, wf16(:,102), n3(:,127), t3x16(:,:,64))
  call prop_Q_A(ntry, wf16(:,92), 108, MB, 1_intkind1, wf16(:,103), n2(68))
  call prop_Q_A(ntry, wf16(:,97), 92, MB, 1_intkind1, wf16(:,104), n2(69))
  call vert_QA_V(ntry, wf4(:,16), ex6, wf8(:,47), n3(:,128), t3x8(:,:,27))
  call vert_QA_V(ntry, wf4(:,6), wf8(:,28), wf32(:,24), n3(:,129), t3x32(:,:,24))
  call vert_QA_V(ntry, wf4(:,6), ex6, wf8(:,48), n3(:,130), t3x8(:,:,28))
  call vert_QA_V(ntry, wf4(:,16), wf8(:,28), wf32(:,25), n3(:,131), t3x32(:,:,25))
  call vert_QA_V(ntry, wf4(:,16), ex5, wf8(:,49), n3(:,132), t3x8(:,:,29))
  call vert_VQ_A(ntry, wf8(:,49), wf4(:,6), wf32(:,26), n3(:,133), t3x32(:,:,26))
  call vert_QA_V(ntry, wf4(:,6), ex5, wf8(:,50), n3(:,134), t3x8(:,:,30))
  call vert_VQ_A(ntry, wf8(:,50), wf4(:,16), wf32(:,27), n3(:,135), t3x32(:,:,27))
  call vert_AV_Q(ntry, ex6, wf8(:,49), wf16(:,105), n3(:,136), t3x16(:,:,65))
  call vert_AV_Q(ntry, ex5, wf8(:,47), wf16(:,106), n3(:,137), t3x16(:,:,66))
  call vert_AV_Q(ntry, ex6, wf8(:,50), wf16(:,107), n3(:,138), t3x16(:,:,67))
  call vert_AV_Q(ntry, ex5, wf8(:,48), wf16(:,108), n3(:,139), t3x16(:,:,68))
  call vert_QA_V(ntry, wf4(:,6), wf4(:,19), wf16(:,109), n3(:,140), t3x16(:,:,69))
  call vert_QA_V(ntry, wf8(:,22), ex6, wf16(:,110), n3(:,141), t3x16(:,:,70))
  call vert_QA_V(ntry, wf8(:,22), wf4(:,19), wf32(:,28), n3(:,142), t3x32(:,:,28))
  call vert_QA_V(ntry, ex3, wf4(:,19), wf8(:,51), n3(:,143), t3x8(:,:,31))
  call vert_VQ_A(ntry, wf8(:,51), wf4(:,6), wf32(:,29), n3(:,144), t3x32(:,:,29))
  call vert_QA_V(ntry, ex3, wf8(:,3), wf16(:,111), n3(:,145), t3x16(:,:,71))
  call vert_AV_Q(ntry, ex6, wf8(:,51), wf16(:,112), n3(:,146), t3x16(:,:,72))
  call vert_VQ_A(ntry, wf8(:,48), ex3, wf16(:,113), n3(:,147), t3x16(:,:,73))
  call vert_QA_V(ntry, wf4(:,6), wf4(:,7), wf16(:,114), n3(:,148), t3x16(:,:,74))
  call vert_QA_V(ntry, wf8(:,22), ex5, wf16(:,115), n3(:,149), t3x16(:,:,75))
  call vert_VQ_A(ntry, wf8(:,50), wf8(:,22), wf64(:,2), n3(:,150), t3x64(:,:,2))
  call vert_QA_V(ntry, ex3, wf8(:,28), wf16(:,116), n3(:,151), t3x16(:,:,76))
  call vert_QA_V(ntry, ex3, wf4(:,7), wf8(:,52), n3(:,152), t3x8(:,:,32))
  call vert_VQ_A(ntry, wf8(:,52), wf4(:,6), wf32(:,30), n3(:,153), t3x32(:,:,30))
  call vert_AV_Q(ntry, ex5, wf8(:,52), wf16(:,117), n3(:,154), t3x16(:,:,77))
  call vert_VQ_A(ntry, wf8(:,50), ex3, wf16(:,118), n3(:,155), t3x16(:,:,78))
  call vert_QA_V(ntry, wf8(:,4), ex6, wf16(:,119), n3(:,156), t3x16(:,:,79))
  call vert_QA_V(ntry, wf8(:,4), ex5, wf16(:,120), n3(:,157), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,107), 120, MB, 1_intkind1, wf16(:,121), n2(70))
  call prop_A_Q(ntry, wf16(:,108), 120, MB, 1_intkind1, wf16(:,122), n2(71))
  call prop_Q_A(ntry, wf16(:,113), 108, MB, 1_intkind1, wf16(:,123), n2(72))
  call prop_Q_A(ntry, wf16(:,118), 92, MB, 1_intkind1, wf16(:,124), n2(73))
  call vert_QA_V(ntry, wf8(:,8), wf4(:,21), wf32(:,31), n3(:,158), t3x32(:,:,31))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,21), wf16(:,125), n3(:,159), t3x16(:,:,81))
  call vert_QA_V(ntry, ex4, wf4(:,21), wf8(:,53), n3(:,160), t3x8(:,:,33))
  call vert_VQ_A(ntry, wf8(:,53), wf4(:,16), wf32(:,32), n3(:,161), t3x32(:,:,32))
  call vert_VQ_A(ntry, wf8(:,47), ex4, wf16(:,126), n3(:,162), t3x16(:,:,82))
  call vert_AV_Q(ntry, ex6, wf8(:,53), wf16(:,127), n3(:,163), t3x16(:,:,83))
  call vert_QA_V(ntry, wf4(:,10), wf4(:,21), wf16(:,128), n3(:,164), t3x16(:,:,84))
  call vert_QA_V(ntry, wf8(:,22), wf4(:,21), wf32(:,33), n3(:,165), t3x32(:,:,33))
  call vert_QA_V(ntry, ex3, wf4(:,21), wf8(:,54), n3(:,166), t3x8(:,:,34))
  call vert_VQ_A(ntry, wf8(:,54), wf4(:,10), wf32(:,34), n3(:,167), t3x32(:,:,34))
  call vert_AV_Q(ntry, ex6, wf8(:,54), wf16(:,129), n3(:,168), t3x16(:,:,85))
  call vert_VQ_A(ntry, wf8(:,42), ex3, wf16(:,130), n3(:,169), t3x16(:,:,86))
  call vert_VQ_A(ntry, wf8(:,53), wf8(:,22), wf64(:,3), n3(:,170), t3x64(:,:,3))
  call vert_VQ_A(ntry, wf8(:,46), wf8(:,22), wf64(:,4), n3(:,171), t3x64(:,:,4))
  call vert_VQ_A(ntry, wf8(:,54), wf8(:,8), wf64(:,5), n3(:,172), t3x64(:,:,5))
  call vert_VQ_A(ntry, wf8(:,52), wf8(:,8), wf64(:,6), n3(:,173), t3x64(:,:,6))
  call vert_VQ_A(ntry, wf8(:,54), ex4, wf16(:,131), n3(:,174), t3x16(:,:,87))
  call vert_VQ_A(ntry, wf8(:,52), ex4, wf16(:,132), n3(:,175), t3x16(:,:,88))
  call vert_VQ_A(ntry, wf8(:,53), ex3, wf16(:,133), n3(:,176), t3x16(:,:,89))
  call vert_VQ_A(ntry, wf8(:,46), ex3, wf16(:,134), n3(:,177), t3x16(:,:,90))
  call vert_QA_V(ntry, ex4, wf8(:,32), wf16(:,135), n3(:,178), t3x16(:,:,91))
  call prop_A_Q(ntry, wf16(:,127), 120, MB, 1_intkind1, wf16(:,136), n2(74))
  call prop_A_Q(ntry, wf16(:,129), 116, MB, 1_intkind1, wf16(:,137), n2(75))
  call vert_QA_V(ntry, ex3, wf8(:,32), wf16(:,138), n3(:,179), t3x16(:,:,92))
  call prop_Q_A(ntry, wf16(:,131), 92, MB, 1_intkind1, wf16(:,139), n2(76))
  call prop_Q_A(ntry, wf16(:,133), 92, MB, 1_intkind1, wf16(:,140), n2(77))
  call vert_VQ_A(ntry, wf8(:,49), wf8(:,8), wf64(:,7), n3(:,180), t3x64(:,:,7))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,11), wf16(:,141), n3(:,181), t3x16(:,:,93))
  call vert_QA_V(ntry, ex4, wf4(:,11), wf8(:,55), n3(:,182), t3x8(:,:,35))
  call vert_VQ_A(ntry, wf8(:,55), wf4(:,16), wf32(:,35), n3(:,183), t3x32(:,:,35))
  call vert_VQ_A(ntry, wf8(:,49), ex4, wf16(:,142), n3(:,184), t3x16(:,:,94))
  call vert_AV_Q(ntry, ex5, wf8(:,55), wf16(:,143), n3(:,185), t3x16(:,:,95))
  call vert_QA_V(ntry, wf4(:,10), wf4(:,11), wf16(:,144), n3(:,186), t3x16(:,:,96))
  call vert_VQ_A(ntry, wf8(:,44), wf8(:,22), wf64(:,8), n3(:,187), t3x64(:,:,8))
  call vert_QA_V(ntry, ex3, wf4(:,11), wf8(:,56), n3(:,188), t3x8(:,:,36))
  call vert_VQ_A(ntry, wf8(:,56), wf4(:,10), wf32(:,36), n3(:,189), t3x32(:,:,36))
  call vert_AV_Q(ntry, ex5, wf8(:,56), wf16(:,145), n3(:,190), t3x16(:,:,97))
  call vert_VQ_A(ntry, wf8(:,44), ex3, wf16(:,146), n3(:,191), t3x16(:,:,98))
  call vert_VQ_A(ntry, wf8(:,45), wf8(:,22), wf64(:,9), n3(:,192), t3x64(:,:,9))
  call vert_VQ_A(ntry, wf8(:,55), wf8(:,22), wf64(:,10), n3(:,193), t3x64(:,:,10))
  call vert_VQ_A(ntry, wf8(:,51), wf8(:,8), wf64(:,11), n3(:,194), t3x64(:,:,11))
  call vert_VQ_A(ntry, wf8(:,56), wf8(:,8), wf64(:,12), n3(:,195), t3x64(:,:,12))
  call vert_VQ_A(ntry, wf8(:,51), ex4, wf16(:,147), n3(:,196), t3x16(:,:,99))
  call vert_VQ_A(ntry, wf8(:,56), ex4, wf16(:,148), n3(:,197), t3x16(:,:,100))
  call vert_VQ_A(ntry, wf8(:,45), ex3, wf16(:,149), n3(:,198), t3x16(:,:,101))
  call vert_VQ_A(ntry, wf8(:,55), ex3, wf16(:,150), n3(:,199), t3x16(:,:,102))
  call vert_QA_V(ntry, ex4, wf8(:,10), wf16(:,151), n3(:,200), t3x16(:,:,103))
  call prop_A_Q(ntry, wf16(:,143), 120, MB, 1_intkind1, wf16(:,152), n2(78))
  call prop_A_Q(ntry, wf16(:,145), 116, MB, 1_intkind1, wf16(:,153), n2(79))
  call vert_QA_V(ntry, ex3, wf8(:,10), wf16(:,154), n3(:,201), t3x16(:,:,104))
  call prop_Q_A(ntry, wf16(:,148), 108, MB, 1_intkind1, wf16(:,155), n2(80))
  call prop_Q_A(ntry, wf16(:,150), 108, MB, 1_intkind1, wf16(:,156), n2(81))
  call prop_A_Q(ntry, wf16(:,105), 180, MB, 1_intkind1, wf16(:,157), n2(82))
  call prop_A_Q(ntry, wf16(:,106), 180, MB, 1_intkind1, wf16(:,158), n2(83))
  call vert_QA_V(ntry, wf8(:,26), ex6, wf16(:,159), n3(:,202), t3x16(:,:,105))
  call vert_QA_V(ntry, wf8(:,26), ex5, wf16(:,160), n3(:,203), t3x16(:,:,106))
  call prop_Q_A(ntry, wf16(:,126), 172, MB, 1_intkind1, wf16(:,161), n2(84))
  call prop_Q_A(ntry, wf16(:,142), 156, MB, 1_intkind1, wf16(:,162), n2(85))
  call vert_QA_V(ntry, wf8(:,14), ex6, wf16(:,163), n3(:,204), t3x16(:,:,107))
  call vert_QA_V(ntry, wf8(:,14), ex5, wf16(:,164), n3(:,205), t3x16(:,:,108))
  call prop_A_Q(ntry, wf16(:,87), 184, MB, 1_intkind1, wf16(:,165), n2(86))
  call prop_A_Q(ntry, wf16(:,88), 184, MB, 1_intkind1, wf16(:,166), n2(87))
  call prop_Q_A(ntry, wf16(:,130), 172, MB, 1_intkind1, wf16(:,167), n2(88))
  call prop_Q_A(ntry, wf16(:,146), 156, MB, 1_intkind1, wf16(:,168), n2(89))
  call vert_QA_V(ntry, ex4, wf8(:,36), wf16(:,169), n3(:,206), t3x16(:,:,109))
  call prop_A_Q(ntry, wf16(:,93), 184, MB, 1_intkind1, wf16(:,170), n2(90))
  call prop_A_Q(ntry, wf16(:,112), 180, MB, 1_intkind1, wf16(:,171), n2(91))
  call vert_QA_V(ntry, ex3, wf8(:,36), wf16(:,172), n3(:,207), t3x16(:,:,110))
  call prop_Q_A(ntry, wf16(:,147), 156, MB, 1_intkind1, wf16(:,173), n2(92))
  call prop_Q_A(ntry, wf16(:,149), 156, MB, 1_intkind1, wf16(:,174), n2(93))
  call vert_QA_V(ntry, ex4, wf8(:,16), wf16(:,175), n3(:,208), t3x16(:,:,111))
  call prop_A_Q(ntry, wf16(:,98), 184, MB, 1_intkind1, wf16(:,176), n2(94))
  call prop_A_Q(ntry, wf16(:,117), 180, MB, 1_intkind1, wf16(:,177), n2(95))
  call vert_QA_V(ntry, ex3, wf8(:,16), wf16(:,178), n3(:,209), t3x16(:,:,112))
  call prop_Q_A(ntry, wf16(:,132), 172, MB, 1_intkind1, wf16(:,179), n2(96))
  call prop_Q_A(ntry, wf16(:,134), 172, MB, 1_intkind1, wf16(:,180), n2(97))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    M2munu = 0
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppllaaj_nenexbbbxbxaa_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllaaj_nenexbbbxbxaa_1

  do k = 0, 1-1
    M2(k) = M2add(extcomb_perm_ppllaaj_nenexbbbxbxaa_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*8-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf16(:,2), wf16(:,3), A(:,1), n3(:,210), t3x256(:,:,1), nhel, den(9))
    call cont_QA(nsync, wf16(:,5), wf16(:,6), A(:,2), n3(:,211), t3x256(:,:,2), nhel, den(14))
    call cont_QA(nsync, wf8(:,4), wf32(:,1), A(:,3), n3(:,212), t3x256(:,:,3), nhel, den(20))
    call cont_QA(nsync, wf16(:,7), wf16(:,8), A(:,4), n3(:,213), t3x256(:,:,4), nhel, den(23))
    call cont_QA(nsync, wf8(:,4), wf32(:,2), A(:,5), n3(:,214), t3x256(:,:,5), nhel, den(27))
    call cont_QA(nsync, wf16(:,3), wf16(:,9), A(:,6), n3(:,215), t3x256(:,:,6), nhel, den(28))
    call cont_QA(nsync, wf16(:,11), wf16(:,12), A(:,7), n3(:,216), t3x256(:,:,7), nhel, den(35))
    call cont_QA(nsync, wf16(:,14), wf16(:,15), A(:,8), n3(:,217), t3x256(:,:,8), nhel, den(40))
    call cont_QA(nsync, wf16(:,16), wf16(:,17), A(:,9), n3(:,218), t3x256(:,:,9), nhel, den(45))
    call cont_QA(nsync, wf8(:,10), wf32(:,3), A(:,10), n3(:,219), t3x256(:,:,10), nhel, den(49))
    call cont_QA(nsync, wf16(:,15), wf16(:,18), A(:,11), n3(:,220), t3x256(:,:,11), nhel, den(52))
    call cont_QA(nsync, wf8(:,10), wf32(:,4), A(:,12), n3(:,221), t3x256(:,:,12), nhel, den(54))
    call cont_QA(nsync, wf32(:,1), wf8(:,14), A(:,13), n3(:,222), t3x256(:,:,13), nhel, den(56))
    call cont_QA(nsync, wf16(:,19), wf16(:,20), A(:,14), n3(:,223), t3x256(:,:,14), nhel, den(59))
    call cont_QA(nsync, wf32(:,2), wf8(:,14), A(:,15), n3(:,224), t3x256(:,:,15), nhel, den(60))
    call cont_QA(nsync, wf16(:,12), wf16(:,21), A(:,16), n3(:,225), t3x256(:,:,16), nhel, den(61))
    call cont_QA(nsync, wf16(:,22), wf16(:,23), A(:,17), n3(:,226), t3x256(:,:,17), nhel, den(64))
    call cont_QA(nsync, wf32(:,3), wf8(:,16), A(:,18), n3(:,227), t3x256(:,:,18), nhel, den(66))
    call cont_QA(nsync, wf16(:,6), wf16(:,24), A(:,19), n3(:,228), t3x256(:,:,19), nhel, den(67))
    call cont_QA(nsync, wf32(:,4), wf8(:,16), A(:,20), n3(:,229), t3x256(:,:,20), nhel, den(68))
    call cont_QA(nsync, wf16(:,9), wf16(:,25), A(:,21), n3(:,230), t3x256(:,:,21), nhel, den(70))
    call cont_QA(nsync, wf16(:,17), wf16(:,26), A(:,22), n3(:,231), t3x256(:,:,22), nhel, den(72))
    call cont_QA(nsync, wf16(:,8), wf16(:,27), A(:,23), n3(:,232), t3x256(:,:,23), nhel, den(74))
    call cont_QA(nsync, wf16(:,18), wf16(:,28), A(:,24), n3(:,233), t3x256(:,:,24), nhel, den(76))
    call cont_QA(nsync, wf16(:,30), wf16(:,31), A(:,25), n3(:,234), t3x256(:,:,25), nhel, den(83))
    call cont_QA(nsync, wf16(:,6), wf16(:,32), A(:,26), n3(:,235), t3x256(:,:,26), nhel, den(85))
    call cont_QA(nsync, wf8(:,18), wf32(:,5), A(:,27), n3(:,236), t3x256(:,:,27), nhel, den(89))
    call cont_QA(nsync, wf16(:,8), wf16(:,33), A(:,28), n3(:,237), t3x256(:,:,28), nhel, den(91))
    call cont_QA(nsync, wf8(:,18), wf32(:,6), A(:,29), n3(:,238), t3x256(:,:,29), nhel, den(95))
    call cont_QA(nsync, wf16(:,31), wf16(:,34), A(:,30), n3(:,239), t3x256(:,:,30), nhel, den(96))
    call cont_QA(nsync, wf16(:,36), wf16(:,37), A(:,31), n3(:,240), t3x256(:,:,31), nhel, den(102))
    call cont_QA(nsync, wf16(:,15), wf16(:,38), A(:,32), n3(:,241), t3x256(:,:,32), nhel, den(104))
    call cont_QA(nsync, wf16(:,39), wf16(:,40), A(:,33), n3(:,242), t3x256(:,:,33), nhel, den(109))
    call cont_QA(nsync, wf8(:,10), wf32(:,7), A(:,34), n3(:,243), t3x256(:,:,34), nhel, den(111))
    call cont_QA(nsync, wf16(:,15), wf16(:,41), A(:,35), n3(:,244), t3x256(:,:,35), nhel, den(113))
    call cont_QA(nsync, wf8(:,10), wf32(:,8), A(:,36), n3(:,245), t3x256(:,:,36), nhel, den(115))
    call cont_QA(nsync, wf32(:,5), wf8(:,26), A(:,37), n3(:,246), t3x256(:,:,37), nhel, den(117))
    call cont_QA(nsync, wf16(:,20), wf16(:,42), A(:,38), n3(:,247), t3x256(:,:,38), nhel, den(119))
    call cont_QA(nsync, wf32(:,6), wf8(:,26), A(:,39), n3(:,248), t3x256(:,:,39), nhel, den(120))
    call cont_QA(nsync, wf16(:,37), wf16(:,43), A(:,40), n3(:,249), t3x256(:,:,40), nhel, den(121))
    call cont_QA(nsync, wf16(:,44), wf16(:,45), A(:,41), n3(:,250), t3x256(:,:,41), nhel, den(124))
    call cont_QA(nsync, wf8(:,16), wf32(:,7), A(:,42), n3(:,251), t3x256(:,:,42), nhel, den(125))
    call cont_QA(nsync, wf16(:,6), wf16(:,46), A(:,43), n3(:,252), t3x256(:,:,43), nhel, den(126))
    call cont_QA(nsync, wf8(:,16), wf32(:,8), A(:,44), n3(:,253), t3x256(:,:,44), nhel, den(127))
    call cont_QA(nsync, wf16(:,34), wf16(:,47), A(:,45), n3(:,254), t3x256(:,:,45), nhel, den(129))
    call cont_QA(nsync, wf16(:,40), wf16(:,48), A(:,46), n3(:,255), t3x256(:,:,46), nhel, den(131))
    call cont_QA(nsync, wf16(:,8), wf16(:,49), A(:,47), n3(:,256), t3x256(:,:,47), nhel, den(133))
    call cont_QA(nsync, wf16(:,28), wf16(:,41), A(:,48), n3(:,257), t3x256(:,:,48), nhel, den(134))
    call cont_QA(nsync, wf16(:,3), wf16(:,50), A(:,49), n3(:,258), t3x256(:,:,49), nhel, den(138))
    call cont_QA(nsync, wf16(:,52), wf16(:,53), A(:,50), n3(:,259), t3x256(:,:,50), nhel, den(143))
    call cont_QA(nsync, wf8(:,4), wf32(:,9), A(:,51), n3(:,260), t3x256(:,:,51), nhel, den(147))
    call cont_QA(nsync, wf16(:,54), wf16(:,55), A(:,52), n3(:,261), t3x256(:,:,52), nhel, den(150))
    call cont_QA(nsync, wf8(:,4), wf32(:,10), A(:,53), n3(:,262), t3x256(:,:,53), nhel, den(153))
    call cont_QA(nsync, wf16(:,3), wf16(:,56), A(:,54), n3(:,263), t3x256(:,:,54), nhel, den(154))
    call cont_QA(nsync, wf16(:,12), wf16(:,57), A(:,55), n3(:,264), t3x256(:,:,55), nhel, den(157))
    call cont_QA(nsync, wf16(:,59), wf16(:,60), A(:,56), n3(:,265), t3x256(:,:,56), nhel, den(162))
    call cont_QA(nsync, wf16(:,17), wf16(:,61), A(:,57), n3(:,266), t3x256(:,:,57), nhel, den(164))
    call cont_QA(nsync, wf8(:,32), wf32(:,11), A(:,58), n3(:,267), t3x256(:,:,58), nhel, den(168))
    call cont_QA(nsync, wf16(:,60), wf16(:,62), A(:,59), n3(:,268), t3x256(:,:,59), nhel, den(171))
    call cont_QA(nsync, wf8(:,32), wf32(:,12), A(:,60), n3(:,269), t3x256(:,:,60), nhel, den(173))
    call cont_QA(nsync, wf8(:,14), wf32(:,9), A(:,61), n3(:,270), t3x256(:,:,61), nhel, den(174))
    call cont_QA(nsync, wf16(:,63), wf16(:,64), A(:,62), n3(:,271), t3x256(:,:,62), nhel, den(177))
    call cont_QA(nsync, wf8(:,14), wf32(:,10), A(:,63), n3(:,272), t3x256(:,:,63), nhel, den(178))
    call cont_QA(nsync, wf16(:,12), wf16(:,65), A(:,64), n3(:,273), t3x256(:,:,64), nhel, den(179))
    call cont_QA(nsync, wf16(:,23), wf16(:,66), A(:,65), n3(:,274), t3x256(:,:,65), nhel, den(181))
    call cont_QA(nsync, wf32(:,11), wf8(:,36), A(:,66), n3(:,275), t3x256(:,:,66), nhel, den(183))
    call cont_QA(nsync, wf16(:,53), wf16(:,67), A(:,67), n3(:,276), t3x256(:,:,67), nhel, den(184))
    call cont_QA(nsync, wf32(:,12), wf8(:,36), A(:,68), n3(:,277), t3x256(:,:,68), nhel, den(185))
    call cont_QA(nsync, wf16(:,25), wf16(:,56), A(:,69), n3(:,278), t3x256(:,:,69), nhel, den(186))
    call cont_QA(nsync, wf16(:,17), wf16(:,68), A(:,70), n3(:,279), t3x256(:,:,70), nhel, den(188))
    call cont_QA(nsync, wf16(:,55), wf16(:,69), A(:,71), n3(:,280), t3x256(:,:,71), nhel, den(190))
    call cont_QA(nsync, wf16(:,62), wf16(:,70), A(:,72), n3(:,281), t3x256(:,:,72), nhel, den(192))
    call cont_QA(nsync, wf16(:,31), wf16(:,71), A(:,73), n3(:,282), t3x256(:,:,73), nhel, den(195))
    call cont_QA(nsync, wf16(:,53), wf16(:,72), A(:,74), n3(:,283), t3x256(:,:,74), nhel, den(197))
    call cont_QA(nsync, wf8(:,18), wf32(:,13), A(:,75), n3(:,284), t3x256(:,:,75), nhel, den(199))
    call cont_QA(nsync, wf16(:,55), wf16(:,73), A(:,76), n3(:,285), t3x256(:,:,76), nhel, den(201))
    call cont_QA(nsync, wf8(:,18), wf32(:,14), A(:,77), n3(:,286), t3x256(:,:,77), nhel, den(204))
    call cont_QA(nsync, wf16(:,31), wf16(:,74), A(:,78), n3(:,287), t3x256(:,:,78), nhel, den(205))
    call cont_QA(nsync, wf16(:,37), wf16(:,75), A(:,79), n3(:,288), t3x256(:,:,79), nhel, den(207))
    call cont_QA(nsync, wf16(:,60), wf16(:,76), A(:,80), n3(:,289), t3x256(:,:,80), nhel, den(209))
    call cont_QA(nsync, wf16(:,40), wf16(:,77), A(:,81), n3(:,290), t3x256(:,:,81), nhel, den(211))
    call cont_QA(nsync, wf8(:,32), wf32(:,15), A(:,82), n3(:,291), t3x256(:,:,82), nhel, den(213))
    call cont_QA(nsync, wf16(:,60), wf16(:,78), A(:,83), n3(:,292), t3x256(:,:,83), nhel, den(215))
    call cont_QA(nsync, wf8(:,32), wf32(:,16), A(:,84), n3(:,293), t3x256(:,:,84), nhel, den(217))
    call cont_QA(nsync, wf8(:,26), wf32(:,13), A(:,85), n3(:,294), t3x256(:,:,85), nhel, den(218))
    call cont_QA(nsync, wf16(:,64), wf16(:,79), A(:,86), n3(:,295), t3x256(:,:,86), nhel, den(220))
    call cont_QA(nsync, wf8(:,26), wf32(:,14), A(:,87), n3(:,296), t3x256(:,:,87), nhel, den(221))
    call cont_QA(nsync, wf16(:,37), wf16(:,80), A(:,88), n3(:,297), t3x256(:,:,88), nhel, den(222))
    call cont_QA(nsync, wf16(:,45), wf16(:,81), A(:,89), n3(:,298), t3x256(:,:,89), nhel, den(224))
    call cont_QA(nsync, wf8(:,36), wf32(:,15), A(:,90), n3(:,299), t3x256(:,:,90), nhel, den(225))
    call cont_QA(nsync, wf16(:,53), wf16(:,82), A(:,91), n3(:,300), t3x256(:,:,91), nhel, den(226))
    call cont_QA(nsync, wf8(:,36), wf32(:,16), A(:,92), n3(:,301), t3x256(:,:,92), nhel, den(227))
    call cont_QA(nsync, wf16(:,47), wf16(:,74), A(:,93), n3(:,302), t3x256(:,:,93), nhel, den(228))
    call cont_QA(nsync, wf16(:,40), wf16(:,83), A(:,94), n3(:,303), t3x256(:,:,94), nhel, den(230))
    call cont_QA(nsync, wf16(:,55), wf16(:,84), A(:,95), n3(:,304), t3x256(:,:,95), nhel, den(232))
    call cont_QA(nsync, wf16(:,70), wf16(:,78), A(:,96), n3(:,305), t3x256(:,:,96), nhel, den(233))
    call cont_VV(nsync, wf8(:,41), wf32(:,17), A(:,97), n3(:,306), t3x256(:,:,97), nhel, den(237))
    call cont_VV(nsync, wf8(:,42), wf32(:,18), A(:,98), n3(:,307), t3x256(:,:,98), nhel, den(241))
    call cont_QA(nsync, wf8(:,3), wf32(:,19), A(:,99), n3(:,308), t3x256(:,:,99), nhel, den(245))
    call cont_QA(nsync, wf8(:,3), wf32(:,20), A(:,100), n3(:,309), t3x256(:,:,100), nhel, den(249))
    call cont_QA(nsync, wf16(:,12), wf16(:,85), A(:,101), n3(:,310), t3x256(:,:,101), nhel, den(250))
    call cont_QA(nsync, wf16(:,12), wf16(:,86), A(:,102), n3(:,311), t3x256(:,:,102), nhel, den(251))
    call cont_QA(nsync, wf16(:,31), wf16(:,87), A(:,103), n3(:,312), t3x256(:,:,103), nhel, den(252))
    call cont_QA(nsync, wf16(:,31), wf16(:,88), A(:,104), n3(:,313), t3x256(:,:,104), nhel, den(253))
    call cont_VV(nsync, wf8(:,41), wf32(:,21), A(:,105), n3(:,314), t3x256(:,:,105), nhel, den(255))
    call cont_VV(nsync, wf16(:,89), wf16(:,90), A(:,106), n3(:,315), t3x256(:,:,106), nhel, den(259))
    call cont_QA(nsync, wf8(:,3), wf32(:,22), A(:,107), n3(:,316), t3x256(:,:,107), nhel, den(262))
    call cont_VV(nsync, wf16(:,89), wf16(:,91), A(:,108), n3(:,317), t3x256(:,:,108), nhel, den(263))
    call cont_QA(nsync, wf16(:,53), wf16(:,92), A(:,109), n3(:,318), t3x256(:,:,109), nhel, den(264))
    call cont_QA(nsync, wf16(:,31), wf16(:,93), A(:,110), n3(:,319), t3x256(:,:,110), nhel, den(265))
    call cont_QA(nsync, wf4(:,7), wf64(:,1), A(:,111), n3(:,320), t3x256(:,:,111), nhel, den(267))
    call cont_VV(nsync, wf16(:,94), wf16(:,95), A(:,112), n3(:,321), t3x256(:,:,112), nhel, den(271))
    call cont_VV(nsync, wf16(:,94), wf16(:,96), A(:,113), n3(:,322), t3x256(:,:,113), nhel, den(272))
    call cont_QA(nsync, wf8(:,28), wf32(:,23), A(:,114), n3(:,323), t3x256(:,:,114), nhel, den(275))
    call cont_QA(nsync, wf16(:,6), wf16(:,97), A(:,115), n3(:,324), t3x256(:,:,115), nhel, den(276))
    call cont_QA(nsync, wf16(:,31), wf16(:,98), A(:,116), n3(:,325), t3x256(:,:,116), nhel, den(277))
    call cont_QA(nsync, wf16(:,17), wf16(:,99), A(:,117), n3(:,326), t3x256(:,:,117), nhel, den(279))
    call cont_QA(nsync, wf16(:,17), wf16(:,100), A(:,118), n3(:,327), t3x256(:,:,118), nhel, den(281))
    call cont_VV(nsync, wf16(:,95), wf16(:,101), A(:,119), n3(:,328), t3x256(:,:,119), nhel, den(284))
    call cont_VV(nsync, wf16(:,90), wf16(:,102), A(:,120), n3(:,329), t3x256(:,:,120), nhel, den(286))
    call cont_QA(nsync, wf16(:,55), wf16(:,103), A(:,121), n3(:,330), t3x256(:,:,121), nhel, den(288))
    call cont_VV(nsync, wf16(:,96), wf16(:,101), A(:,122), n3(:,331), t3x256(:,:,122), nhel, den(290))
    call cont_QA(nsync, wf16(:,8), wf16(:,104), A(:,123), n3(:,332), t3x256(:,:,123), nhel, den(292))
    call cont_VV(nsync, wf16(:,91), wf16(:,102), A(:,124), n3(:,333), t3x256(:,:,124), nhel, den(295))
    call cont_VV(nsync, wf8(:,47), wf32(:,24), A(:,125), n3(:,334), t3x256(:,:,125), nhel, den(299))
    call cont_VV(nsync, wf8(:,48), wf32(:,25), A(:,126), n3(:,335), t3x256(:,:,126), nhel, den(303))
    call cont_QA(nsync, wf8(:,3), wf32(:,26), A(:,127), n3(:,336), t3x256(:,:,127), nhel, den(307))
    call cont_QA(nsync, wf8(:,3), wf32(:,27), A(:,128), n3(:,337), t3x256(:,:,128), nhel, den(311))
    call cont_QA(nsync, wf16(:,3), wf16(:,105), A(:,129), n3(:,338), t3x256(:,:,129), nhel, den(312))
    call cont_QA(nsync, wf16(:,3), wf16(:,106), A(:,130), n3(:,339), t3x256(:,:,130), nhel, den(313))
    call cont_QA(nsync, wf16(:,37), wf16(:,107), A(:,131), n3(:,340), t3x256(:,:,131), nhel, den(314))
    call cont_QA(nsync, wf16(:,37), wf16(:,108), A(:,132), n3(:,341), t3x256(:,:,132), nhel, den(315))
    call cont_VV(nsync, wf16(:,109), wf16(:,110), A(:,133), n3(:,342), t3x256(:,:,133), nhel, den(319))
    call cont_VV(nsync, wf8(:,48), wf32(:,28), A(:,134), n3(:,343), t3x256(:,:,134), nhel, den(321))
    call cont_QA(nsync, wf8(:,3), wf32(:,29), A(:,135), n3(:,344), t3x256(:,:,135), nhel, den(324))
    call cont_VV(nsync, wf16(:,109), wf16(:,111), A(:,136), n3(:,345), t3x256(:,:,136), nhel, den(325))
    call cont_QA(nsync, wf16(:,3), wf16(:,112), A(:,137), n3(:,346), t3x256(:,:,137), nhel, den(326))
    call cont_QA(nsync, wf16(:,53), wf16(:,113), A(:,138), n3(:,347), t3x256(:,:,138), nhel, den(327))
    call cont_VV(nsync, wf16(:,114), wf16(:,115), A(:,139), n3(:,348), t3x256(:,:,139), nhel, den(331))
    call cont_QA(nsync, wf4(:,7), wf64(:,2), A(:,140), n3(:,349), t3x256(:,:,140), nhel, den(333))
    call cont_VV(nsync, wf16(:,114), wf16(:,116), A(:,141), n3(:,350), t3x256(:,:,141), nhel, den(334))
    call cont_QA(nsync, wf8(:,28), wf32(:,30), A(:,142), n3(:,351), t3x256(:,:,142), nhel, den(337))
    call cont_QA(nsync, wf16(:,3), wf16(:,117), A(:,143), n3(:,352), t3x256(:,:,143), nhel, den(338))
    call cont_QA(nsync, wf16(:,6), wf16(:,118), A(:,144), n3(:,353), t3x256(:,:,144), nhel, den(339))
    call cont_VV(nsync, wf16(:,115), wf16(:,119), A(:,145), n3(:,354), t3x256(:,:,145), nhel, den(342))
    call cont_VV(nsync, wf16(:,110), wf16(:,120), A(:,146), n3(:,355), t3x256(:,:,146), nhel, den(344))
    call cont_QA(nsync, wf16(:,40), wf16(:,121), A(:,147), n3(:,356), t3x256(:,:,147), nhel, den(346))
    call cont_QA(nsync, wf16(:,40), wf16(:,122), A(:,148), n3(:,357), t3x256(:,:,148), nhel, den(348))
    call cont_VV(nsync, wf16(:,116), wf16(:,119), A(:,149), n3(:,358), t3x256(:,:,149), nhel, den(350))
    call cont_QA(nsync, wf16(:,55), wf16(:,123), A(:,150), n3(:,359), t3x256(:,:,150), nhel, den(352))
    call cont_VV(nsync, wf16(:,111), wf16(:,120), A(:,151), n3(:,360), t3x256(:,:,151), nhel, den(355))
    call cont_QA(nsync, wf16(:,8), wf16(:,124), A(:,152), n3(:,361), t3x256(:,:,152), nhel, den(357))
    call cont_VV(nsync, wf8(:,47), wf32(:,31), A(:,153), n3(:,362), t3x256(:,:,153), nhel, den(359))
    call cont_VV(nsync, wf16(:,90), wf16(:,125), A(:,154), n3(:,363), t3x256(:,:,154), nhel, den(362))
    call cont_QA(nsync, wf8(:,3), wf32(:,32), A(:,155), n3(:,364), t3x256(:,:,155), nhel, den(365))
    call cont_VV(nsync, wf16(:,91), wf16(:,125), A(:,156), n3(:,365), t3x256(:,:,156), nhel, den(366))
    call cont_QA(nsync, wf16(:,60), wf16(:,126), A(:,157), n3(:,366), t3x256(:,:,157), nhel, den(367))
    call cont_QA(nsync, wf16(:,37), wf16(:,127), A(:,158), n3(:,367), t3x256(:,:,158), nhel, den(368))
    call cont_VV(nsync, wf16(:,110), wf16(:,128), A(:,159), n3(:,368), t3x256(:,:,159), nhel, den(371))
    call cont_VV(nsync, wf8(:,42), wf32(:,33), A(:,160), n3(:,369), t3x256(:,:,160), nhel, den(373))
    call cont_QA(nsync, wf8(:,3), wf32(:,34), A(:,161), n3(:,370), t3x256(:,:,161), nhel, den(376))
    call cont_VV(nsync, wf16(:,111), wf16(:,128), A(:,162), n3(:,371), t3x256(:,:,162), nhel, den(377))
    call cont_QA(nsync, wf16(:,12), wf16(:,129), A(:,163), n3(:,372), t3x256(:,:,163), nhel, den(378))
    call cont_QA(nsync, wf16(:,60), wf16(:,130), A(:,164), n3(:,373), t3x256(:,:,164), nhel, den(379))
    call cont_QA(nsync, wf4(:,7), wf64(:,3), A(:,165), n3(:,374), t3x256(:,:,165), nhel, den(381))
    call cont_QA(nsync, wf4(:,21), wf64(:,4), A(:,166), n3(:,375), t3x256(:,:,166), nhel, den(383))
    call cont_QA(nsync, wf4(:,7), wf64(:,5), A(:,167), n3(:,376), t3x256(:,:,167), nhel, den(385))
    call cont_QA(nsync, wf4(:,21), wf64(:,6), A(:,168), n3(:,377), t3x256(:,:,168), nhel, den(387))
    call cont_QA(nsync, wf16(:,6), wf16(:,131), A(:,169), n3(:,378), t3x256(:,:,169), nhel, den(388))
    call cont_QA(nsync, wf16(:,60), wf16(:,132), A(:,170), n3(:,379), t3x256(:,:,170), nhel, den(389))
    call cont_QA(nsync, wf16(:,6), wf16(:,133), A(:,171), n3(:,380), t3x256(:,:,171), nhel, den(390))
    call cont_QA(nsync, wf16(:,60), wf16(:,134), A(:,172), n3(:,381), t3x256(:,:,172), nhel, den(391))
    call cont_VV(nsync, wf16(:,110), wf16(:,135), A(:,173), n3(:,382), t3x256(:,:,173), nhel, den(393))
    call cont_QA(nsync, wf16(:,40), wf16(:,136), A(:,174), n3(:,383), t3x256(:,:,174), nhel, den(395))
    call cont_QA(nsync, wf16(:,17), wf16(:,137), A(:,175), n3(:,384), t3x256(:,:,175), nhel, den(397))
    call cont_VV(nsync, wf16(:,90), wf16(:,138), A(:,176), n3(:,385), t3x256(:,:,176), nhel, den(399))
    call cont_QA(nsync, wf16(:,8), wf16(:,139), A(:,177), n3(:,386), t3x256(:,:,177), nhel, den(401))
    call cont_VV(nsync, wf16(:,111), wf16(:,135), A(:,178), n3(:,387), t3x256(:,:,178), nhel, den(402))
    call cont_QA(nsync, wf16(:,8), wf16(:,140), A(:,179), n3(:,388), t3x256(:,:,179), nhel, den(404))
    call cont_VV(nsync, wf16(:,91), wf16(:,138), A(:,180), n3(:,389), t3x256(:,:,180), nhel, den(405))
    call cont_QA(nsync, wf4(:,11), wf64(:,7), A(:,181), n3(:,390), t3x256(:,:,181), nhel, den(407))
    call cont_VV(nsync, wf16(:,95), wf16(:,141), A(:,182), n3(:,391), t3x256(:,:,182), nhel, den(410))
    call cont_VV(nsync, wf16(:,96), wf16(:,141), A(:,183), n3(:,392), t3x256(:,:,183), nhel, den(411))
    call cont_QA(nsync, wf8(:,28), wf32(:,35), A(:,184), n3(:,393), t3x256(:,:,184), nhel, den(414))
    call cont_QA(nsync, wf16(:,15), wf16(:,142), A(:,185), n3(:,394), t3x256(:,:,185), nhel, den(415))
    call cont_QA(nsync, wf16(:,37), wf16(:,143), A(:,186), n3(:,395), t3x256(:,:,186), nhel, den(416))
    call cont_VV(nsync, wf16(:,115), wf16(:,144), A(:,187), n3(:,396), t3x256(:,:,187), nhel, den(419))
    call cont_QA(nsync, wf4(:,11), wf64(:,8), A(:,188), n3(:,397), t3x256(:,:,188), nhel, den(421))
    call cont_VV(nsync, wf16(:,116), wf16(:,144), A(:,189), n3(:,398), t3x256(:,:,189), nhel, den(422))
    call cont_QA(nsync, wf8(:,28), wf32(:,36), A(:,190), n3(:,399), t3x256(:,:,190), nhel, den(425))
    call cont_QA(nsync, wf16(:,12), wf16(:,145), A(:,191), n3(:,400), t3x256(:,:,191), nhel, den(426))
    call cont_QA(nsync, wf16(:,15), wf16(:,146), A(:,192), n3(:,401), t3x256(:,:,192), nhel, den(427))
    call cont_QA(nsync, wf4(:,11), wf64(:,9), A(:,193), n3(:,402), t3x256(:,:,193), nhel, den(429))
    call cont_QA(nsync, wf4(:,19), wf64(:,10), A(:,194), n3(:,403), t3x256(:,:,194), nhel, den(431))
    call cont_QA(nsync, wf4(:,11), wf64(:,11), A(:,195), n3(:,404), t3x256(:,:,195), nhel, den(433))
    call cont_QA(nsync, wf4(:,19), wf64(:,12), A(:,196), n3(:,405), t3x256(:,:,196), nhel, den(435))
    call cont_QA(nsync, wf16(:,15), wf16(:,147), A(:,197), n3(:,406), t3x256(:,:,197), nhel, den(436))
    call cont_QA(nsync, wf16(:,53), wf16(:,148), A(:,198), n3(:,407), t3x256(:,:,198), nhel, den(437))
    call cont_QA(nsync, wf16(:,15), wf16(:,149), A(:,199), n3(:,408), t3x256(:,:,199), nhel, den(438))
    call cont_QA(nsync, wf16(:,53), wf16(:,150), A(:,200), n3(:,409), t3x256(:,:,200), nhel, den(439))
    call cont_VV(nsync, wf16(:,115), wf16(:,151), A(:,201), n3(:,410), t3x256(:,:,201), nhel, den(441))
    call cont_QA(nsync, wf16(:,40), wf16(:,152), A(:,202), n3(:,411), t3x256(:,:,202), nhel, den(443))
    call cont_QA(nsync, wf16(:,17), wf16(:,153), A(:,203), n3(:,412), t3x256(:,:,203), nhel, den(445))
    call cont_VV(nsync, wf16(:,95), wf16(:,154), A(:,204), n3(:,413), t3x256(:,:,204), nhel, den(447))
    call cont_VV(nsync, wf16(:,116), wf16(:,151), A(:,205), n3(:,414), t3x256(:,:,205), nhel, den(448))
    call cont_QA(nsync, wf16(:,55), wf16(:,155), A(:,206), n3(:,415), t3x256(:,:,206), nhel, den(450))
    call cont_VV(nsync, wf16(:,96), wf16(:,154), A(:,207), n3(:,416), t3x256(:,:,207), nhel, den(451))
    call cont_QA(nsync, wf16(:,55), wf16(:,156), A(:,208), n3(:,417), t3x256(:,:,208), nhel, den(453))
    call cont_QA(nsync, wf16(:,23), wf16(:,157), A(:,209), n3(:,418), t3x256(:,:,209), nhel, den(455))
    call cont_QA(nsync, wf16(:,23), wf16(:,158), A(:,210), n3(:,419), t3x256(:,:,210), nhel, den(457))
    call cont_VV(nsync, wf16(:,95), wf16(:,159), A(:,211), n3(:,420), t3x256(:,:,211), nhel, den(458))
    call cont_VV(nsync, wf16(:,90), wf16(:,160), A(:,212), n3(:,421), t3x256(:,:,212), nhel, den(460))
    call cont_QA(nsync, wf16(:,64), wf16(:,161), A(:,213), n3(:,422), t3x256(:,:,213), nhel, den(462))
    call cont_VV(nsync, wf16(:,96), wf16(:,159), A(:,214), n3(:,423), t3x256(:,:,214), nhel, den(463))
    call cont_QA(nsync, wf16(:,20), wf16(:,162), A(:,215), n3(:,424), t3x256(:,:,215), nhel, den(465))
    call cont_VV(nsync, wf16(:,91), wf16(:,160), A(:,216), n3(:,425), t3x256(:,:,216), nhel, den(466))
    call cont_VV(nsync, wf16(:,115), wf16(:,163), A(:,217), n3(:,426), t3x256(:,:,217), nhel, den(467))
    call cont_VV(nsync, wf16(:,110), wf16(:,164), A(:,218), n3(:,427), t3x256(:,:,218), nhel, den(469))
    call cont_QA(nsync, wf16(:,45), wf16(:,165), A(:,219), n3(:,428), t3x256(:,:,219), nhel, den(471))
    call cont_QA(nsync, wf16(:,45), wf16(:,166), A(:,220), n3(:,429), t3x256(:,:,220), nhel, den(473))
    call cont_VV(nsync, wf16(:,116), wf16(:,163), A(:,221), n3(:,430), t3x256(:,:,221), nhel, den(474))
    call cont_QA(nsync, wf16(:,64), wf16(:,167), A(:,222), n3(:,431), t3x256(:,:,222), nhel, den(476))
    call cont_VV(nsync, wf16(:,111), wf16(:,164), A(:,223), n3(:,432), t3x256(:,:,223), nhel, den(477))
    call cont_QA(nsync, wf16(:,20), wf16(:,168), A(:,224), n3(:,433), t3x256(:,:,224), nhel, den(479))
    call cont_VV(nsync, wf16(:,110), wf16(:,169), A(:,225), n3(:,434), t3x256(:,:,225), nhel, den(481))
    call cont_QA(nsync, wf16(:,45), wf16(:,170), A(:,226), n3(:,435), t3x256(:,:,226), nhel, den(483))
    call cont_QA(nsync, wf16(:,23), wf16(:,171), A(:,227), n3(:,436), t3x256(:,:,227), nhel, den(485))
    call cont_VV(nsync, wf16(:,90), wf16(:,172), A(:,228), n3(:,437), t3x256(:,:,228), nhel, den(487))
    call cont_QA(nsync, wf16(:,20), wf16(:,173), A(:,229), n3(:,438), t3x256(:,:,229), nhel, den(489))
    call cont_VV(nsync, wf16(:,111), wf16(:,169), A(:,230), n3(:,439), t3x256(:,:,230), nhel, den(490))
    call cont_QA(nsync, wf16(:,20), wf16(:,174), A(:,231), n3(:,440), t3x256(:,:,231), nhel, den(492))
    call cont_VV(nsync, wf16(:,91), wf16(:,172), A(:,232), n3(:,441), t3x256(:,:,232), nhel, den(493))
    call cont_VV(nsync, wf16(:,115), wf16(:,175), A(:,233), n3(:,442), t3x256(:,:,233), nhel, den(495))
    call cont_QA(nsync, wf16(:,45), wf16(:,176), A(:,234), n3(:,443), t3x256(:,:,234), nhel, den(497))
    call cont_QA(nsync, wf16(:,23), wf16(:,177), A(:,235), n3(:,444), t3x256(:,:,235), nhel, den(499))
    call cont_VV(nsync, wf16(:,95), wf16(:,178), A(:,236), n3(:,445), t3x256(:,:,236), nhel, den(501))
    call cont_VV(nsync, wf16(:,116), wf16(:,175), A(:,237), n3(:,446), t3x256(:,:,237), nhel, den(502))
    call cont_QA(nsync, wf16(:,64), wf16(:,179), A(:,238), n3(:,447), t3x256(:,:,238), nhel, den(504))
    call cont_VV(nsync, wf16(:,96), wf16(:,178), A(:,239), n3(:,448), t3x256(:,:,239), nhel, den(505))
    call cont_QA(nsync, wf16(:,64), wf16(:,180), A(:,240), n3(:,449), t3x256(:,:,240), nhel, den(507))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(2) ! M1helarray(2,256)
  integer :: empty(0)

  M1(1) = ((-A(j,25)%j-A(j,26)%j-A(j,27)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j-A(j,31)%j-A(j,32)%j-A(j,33)%j-A(j,34)%j-A(j,35)%j &
       -A(j,36)%j-A(j,37)%j-A(j,38)%j-A(j,39)%j-A(j,40)%j-A(j,41)%j-A(j,42)%j-A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,47)%j &
       -A(j,48)%j-A(j,49)%j-A(j,50)%j-A(j,51)%j-A(j,52)%j-A(j,53)%j-A(j,54)%j-A(j,55)%j-A(j,56)%j-A(j,57)%j-A(j,58)%j-A(j,59)%j &
       -A(j,60)%j-A(j,61)%j-A(j,62)%j-A(j,63)%j-A(j,64)%j-A(j,65)%j-A(j,66)%j-A(j,67)%j-A(j,68)%j-A(j,69)%j-A(j,70)%j-A(j,71)%j &
       -A(j,72)%j-A(j,97)%j-A(j,100)%j-A(j,102)%j-A(j,103)%j-A(j,105)%j-A(j,107)%j-A(j,109)%j-A(j,110)%j-A(j,112)%j-A(j,113)%j &
       -A(j,118)%j-A(j,119)%j-A(j,121)%j-A(j,122)%j-A(j,125)%j-A(j,128)%j-A(j,130)%j-A(j,131)%j-A(j,133)%j-A(j,136)%j-A(j,140)%j &
       -A(j,142)%j-A(j,143)%j-A(j,144)%j-A(j,146)%j-A(j,147)%j-A(j,151)%j-A(j,152)%j-A(j,153)%j-A(j,155)%j-A(j,157)%j-A(j,158)%j &
       -A(j,159)%j-A(j,162)%j-A(j,165)%j-A(j,168)%j-A(j,170)%j-A(j,171)%j-A(j,173)%j-A(j,174)%j-A(j,178)%j-A(j,179)%j-A(j,182)%j &
       -A(j,183)%j-A(j,188)%j-A(j,190)%j-A(j,191)%j-A(j,192)%j-A(j,193)%j-A(j,196)%j-A(j,198)%j-A(j,199)%j-A(j,203)%j-A(j,204)%j &
       -A(j,206)%j-A(j,207)%j-A(j,210)%j-A(j,211)%j-A(j,213)%j-A(j,214)%j-A(j,218)%j-A(j,219)%j-A(j,223)%j-A(j,224)%j-A(j,225)%j &
       -A(j,226)%j-A(j,230)%j-A(j,231)%j-A(j,235)%j-A(j,236)%j-A(j,238)%j-A(j,239)%j)*f(1))/6._/**/REALKIND+((-A(j,1)%j-A(j,2)%j &
       -A(j,3)%j-A(j,4)%j-A(j,5)%j-A(j,6)%j-A(j,7)%j-A(j,8)%j-A(j,9)%j-A(j,10)%j-A(j,11)%j-A(j,12)%j-A(j,13)%j-A(j,14)%j-A(j,15)%j &
       -A(j,16)%j-A(j,17)%j-A(j,18)%j-A(j,19)%j-A(j,20)%j-A(j,21)%j-A(j,22)%j-A(j,23)%j-A(j,24)%j-A(j,73)%j-A(j,74)%j-A(j,75)%j &
       -A(j,76)%j-A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,80)%j-A(j,81)%j-A(j,82)%j-A(j,83)%j-A(j,84)%j-A(j,85)%j-A(j,86)%j-A(j,87)%j &
       -A(j,88)%j-A(j,89)%j-A(j,90)%j-A(j,91)%j-A(j,92)%j-A(j,93)%j-A(j,94)%j-A(j,95)%j-A(j,96)%j-A(j,98)%j-A(j,99)%j-A(j,101)%j &
       -A(j,104)%j-A(j,106)%j-A(j,108)%j-A(j,111)%j-A(j,114)%j-A(j,115)%j-A(j,116)%j-A(j,117)%j-A(j,120)%j-A(j,123)%j-A(j,124)%j &
       -A(j,126)%j-A(j,127)%j-A(j,129)%j-A(j,132)%j-A(j,134)%j-A(j,135)%j-A(j,137)%j-A(j,138)%j-A(j,139)%j-A(j,141)%j-A(j,145)%j &
       -A(j,148)%j-A(j,149)%j-A(j,150)%j-A(j,154)%j-A(j,156)%j-A(j,160)%j-A(j,161)%j-A(j,163)%j-A(j,164)%j-A(j,166)%j-A(j,167)%j &
       -A(j,169)%j-A(j,172)%j-A(j,175)%j-A(j,176)%j-A(j,177)%j-A(j,180)%j-A(j,181)%j-A(j,184)%j-A(j,185)%j-A(j,186)%j-A(j,187)%j &
       -A(j,189)%j-A(j,194)%j-A(j,195)%j-A(j,197)%j-A(j,200)%j-A(j,201)%j-A(j,202)%j-A(j,205)%j-A(j,208)%j-A(j,209)%j-A(j,212)%j &
       -A(j,215)%j-A(j,216)%j-A(j,217)%j-A(j,220)%j-A(j,221)%j-A(j,222)%j-A(j,227)%j-A(j,228)%j-A(j,229)%j-A(j,232)%j-A(j,233)%j &
       -A(j,234)%j-A(j,237)%j-A(j,240)%j)*f(1))/2._/**/REALKIND
  M1(2) = ((A(j,25)%j+A(j,26)%j+A(j,27)%j+A(j,28)%j+A(j,29)%j+A(j,30)%j+A(j,31)%j+A(j,32)%j+A(j,33)%j+A(j,34)%j+A(j,35)%j &
       +A(j,36)%j+A(j,37)%j+A(j,38)%j+A(j,39)%j+A(j,40)%j+A(j,41)%j+A(j,42)%j+A(j,43)%j+A(j,44)%j+A(j,45)%j+A(j,46)%j+A(j,47)%j &
       +A(j,48)%j+A(j,49)%j+A(j,50)%j+A(j,51)%j+A(j,52)%j+A(j,53)%j+A(j,54)%j+A(j,55)%j+A(j,56)%j+A(j,57)%j+A(j,58)%j+A(j,59)%j &
       +A(j,60)%j+A(j,61)%j+A(j,62)%j+A(j,63)%j+A(j,64)%j+A(j,65)%j+A(j,66)%j+A(j,67)%j+A(j,68)%j+A(j,69)%j+A(j,70)%j+A(j,71)%j &
       +A(j,72)%j+A(j,97)%j+A(j,100)%j+A(j,102)%j+A(j,103)%j+A(j,105)%j+A(j,107)%j+A(j,109)%j+A(j,110)%j+A(j,112)%j+A(j,113)%j &
       +A(j,118)%j+A(j,119)%j+A(j,121)%j+A(j,122)%j+A(j,125)%j+A(j,128)%j+A(j,130)%j+A(j,131)%j+A(j,133)%j+A(j,136)%j+A(j,140)%j &
       +A(j,142)%j+A(j,143)%j+A(j,144)%j+A(j,146)%j+A(j,147)%j+A(j,151)%j+A(j,152)%j+A(j,153)%j+A(j,155)%j+A(j,157)%j+A(j,158)%j &
       +A(j,159)%j+A(j,162)%j+A(j,165)%j+A(j,168)%j+A(j,170)%j+A(j,171)%j+A(j,173)%j+A(j,174)%j+A(j,178)%j+A(j,179)%j+A(j,182)%j &
       +A(j,183)%j+A(j,188)%j+A(j,190)%j+A(j,191)%j+A(j,192)%j+A(j,193)%j+A(j,196)%j+A(j,198)%j+A(j,199)%j+A(j,203)%j+A(j,204)%j &
       +A(j,206)%j+A(j,207)%j+A(j,210)%j+A(j,211)%j+A(j,213)%j+A(j,214)%j+A(j,218)%j+A(j,219)%j+A(j,223)%j+A(j,224)%j+A(j,225)%j &
       +A(j,226)%j+A(j,230)%j+A(j,231)%j+A(j,235)%j+A(j,236)%j+A(j,238)%j+A(j,239)%j)*f(1))/2._/**/REALKIND+((A(j,1)%j+A(j,2)%j &
       +A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j+A(j,7)%j+A(j,8)%j+A(j,9)%j+A(j,10)%j+A(j,11)%j+A(j,12)%j+A(j,13)%j+A(j,14)%j+A(j,15)%j &
       +A(j,16)%j+A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j+A(j,23)%j+A(j,24)%j+A(j,73)%j+A(j,74)%j+A(j,75)%j &
       +A(j,76)%j+A(j,77)%j+A(j,78)%j+A(j,79)%j+A(j,80)%j+A(j,81)%j+A(j,82)%j+A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j &
       +A(j,88)%j+A(j,89)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j+A(j,93)%j+A(j,94)%j+A(j,95)%j+A(j,96)%j+A(j,98)%j+A(j,99)%j+A(j,101)%j &
       +A(j,104)%j+A(j,106)%j+A(j,108)%j+A(j,111)%j+A(j,114)%j+A(j,115)%j+A(j,116)%j+A(j,117)%j+A(j,120)%j+A(j,123)%j+A(j,124)%j &
       +A(j,126)%j+A(j,127)%j+A(j,129)%j+A(j,132)%j+A(j,134)%j+A(j,135)%j+A(j,137)%j+A(j,138)%j+A(j,139)%j+A(j,141)%j+A(j,145)%j &
       +A(j,148)%j+A(j,149)%j+A(j,150)%j+A(j,154)%j+A(j,156)%j+A(j,160)%j+A(j,161)%j+A(j,163)%j+A(j,164)%j+A(j,166)%j+A(j,167)%j &
       +A(j,169)%j+A(j,172)%j+A(j,175)%j+A(j,176)%j+A(j,177)%j+A(j,180)%j+A(j,181)%j+A(j,184)%j+A(j,185)%j+A(j,186)%j+A(j,187)%j &
       +A(j,189)%j+A(j,194)%j+A(j,195)%j+A(j,197)%j+A(j,200)%j+A(j,201)%j+A(j,202)%j+A(j,205)%j+A(j,208)%j+A(j,209)%j+A(j,212)%j &
       +A(j,215)%j+A(j,216)%j+A(j,217)%j+A(j,220)%j+A(j,221)%j+A(j,222)%j+A(j,227)%j+A(j,228)%j+A(j,229)%j+A(j,232)%j+A(j,233)%j &
       +A(j,234)%j+A(j,237)%j+A(j,240)%j)*f(1))/6._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint(0:1-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(2), M2(2)
  real(REALKIND),    intent(out) :: M2colint(0:1-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppllaaj_nenexbbbxbxaa_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(2,256)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllaaj_nenexbbbxbxaa_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllaaj_nenexbbbxbxaa_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllaaj_nenexbbbxbxaa_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    1, [ (k, k = 0, 1-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllaaj_nenexbbbxbxaa_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllaaj_nenexbbbxbxaa_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(8)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(8)
  do J = 1, 8
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 8,extcombs, M2munu)
  do J = 1, 8
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllaaj_nenexbbbxbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllaaj_nenexbbbxbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllaaj_nenexbbbxbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(0:1-1)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(0:1-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllaaj_nenexbbbxbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllaaj_nenexbbbxbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(8)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(8)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppllaaj_nenexbbbxbxaa_1_/**/REALKIND
