
module ol_colourmatrix_ppllaaj_eexuuxbbxaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 9, 3]
  K1(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllaaj_eexuuxbbxaa_1_/**/REALKIND



module ol_forced_parameters_ppllaaj_eexuuxbbxaa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllaaj_eexuuxbbxaa_1_/**/REALKIND

module ol_tree_ppllaaj_eexuuxbbxaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(10)
  complex(REALKIND), save :: den(753)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(256) ! physical helicity states
  complex(DREALKIND) :: M1helarr(2,256) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD**2)/27._/**/REALKIND
    f( 2) = (2*CI*eQED**4*gQCD**2)/27._/**/REALKIND
    f( 3) = (CI*eQED**4*gQCD**2)/9._/**/REALKIND
    f( 4) = (4*CI*eQED**4*gQCD**2)/27._/**/REALKIND
    f( 5) = (2*CI*eQED**4*gQCD**2)/9._/**/REALKIND
    f( 6) = (8*CI*eQED**4*gQCD**2)/27._/**/REALKIND
    f( 7) = (CI*eQED**4*gQCD**2)/3._/**/REALKIND
    f( 8) = (4*CI*eQED**4*gQCD**2)/9._/**/REALKIND
    f( 9) = (2*CI*eQED**4*gQCD**2)/3._/**/REALKIND
    f(10) = CI*eQED**4*gQCD**2

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,80) - MB2)+L(6,80))
  den(3) = 1 /((L(5,12))+L(6,12))
  den(4) = 1 /((L(5,160) - MB2)+L(6,160))
  den(7) = 1 /((L(5,83) - MB2)+L(6,83))
  den(10) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(16) = 1 /((L(5,163) - MB2)+L(6,163))
  den(22) = 1 /((L(5,35) - MB2)+L(6,35))
  den(24) = 1 /((L(5,208) - MB2)+L(6,208))
  den(31) = 1 /((L(5,92) - MB2)+L(6,92))
  den(35) = 1 /((L(5,44) - MB2)+L(6,44))
  den(43) = 1 /((L(5,144) - MB2)+L(6,144))
  den(44) = 1 /((L(5,96) - MB2)+L(6,96))
  den(47) = 1 /((L(5,147) - MB2)+L(6,147))
  den(55) = 1 /((L(5,99) - MB2)+L(6,99))
  den(61) = 1 /((L(5,19) - MB2)+L(6,19))
  den(63) = 1 /((L(5,108) - MB2)+L(6,108))
  den(68) = 1 /((L(5,224) - MB2)+L(6,224))
  den(74) = 1 /((L(5,28) - MB2)+L(6,28))
  den(85) = 1 /((L(5,156) - MB2)+L(6,156))
  den(93) = 1 /((L(5,172) - MB2)+L(6,172))
  den(118) = 1 /((L(5,68))+L(6,68))
  den(119) = 1 /((L(5,136))+L(6,136))
  den(120) = 1 /((L(5,48))+L(6,48))
  den(123) = 1 /((L(5,71))+L(6,71))
  den(131) = 1 /((L(5,139))+L(6,139))
  den(137) = 1 /((L(5,11))+L(6,11))
  den(139) = 1 /((L(5,196))+L(6,196))
  den(146) = 1 /((L(5,116))+L(6,116))
  den(150) = 1 /((L(5,56))+L(6,56))
  den(158) = 1 /((L(5,132))+L(6,132))
  den(159) = 1 /((L(5,72))+L(6,72))
  den(162) = 1 /((L(5,135))+L(6,135))
  den(170) = 1 /((L(5,75))+L(6,75))
  den(176) = 1 /((L(5,7))+L(6,7))
  den(178) = 1 /((L(5,120))+L(6,120))
  den(183) = 1 /((L(5,200))+L(6,200))
  den(189) = 1 /((L(5,52))+L(6,52))
  den(200) = 1 /((L(5,180))+L(6,180))
  den(208) = 1 /((L(5,184))+L(6,184))
  den(234) = 1 /((L(5,204))+L(6,204))
  den(240) = 1 /((L(5,176))+L(6,176))
  den(246) = 1 /((L(5,76))+L(6,76))
  den(316) = 1 /((L(5,112))+L(6,112))
  den(322) = 1 /((L(5,140))+L(6,140))
  den(344) = 1 /((L(5,240))+L(6,240))
  den(350) = 1 /((L(5,15))+L(6,15))
  den(444) = 1 /((L(5,65))+L(6,65))
  den(445) = 1 /((L(5,130))+L(6,130))
  den(447) = 1 /((L(5,195))+L(6,195))
  den(450) = 1 /((L(5,195) - MZ2)+L(6,195))
  den(455) = 1 /((L(5,67))+L(6,67))
  den(458) = 1 /((L(5,67) - MZ2)+L(6,67))
  den(479) = 1 /((L(5,193))+L(6,193))
  den(487) = 1 /((L(5,129))+L(6,129))
  den(488) = 1 /((L(5,66))+L(6,66))
  den(518) = 1 /((L(5,194))+L(6,194))
  den(526) = 1 /((L(5,131))+L(6,131))
  den(529) = 1 /((L(5,131) - MZ2)+L(6,131))

  ! denominators

  den(5) = den(1)*den(2)
  den(6) = den(3)*den(4)
  den(8) = den(5)*den(7)
  den(9) = den(6)*den(8)
  den(11) = den(2)*den(10)
  den(12) = den(7)*den(11)
  den(13) = den(6)*den(12)
  den(14) = den(1)*den(4)
  den(15) = den(2)*den(3)
  den(17) = den(14)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(4)*den(10)
  den(20) = den(16)*den(19)
  den(21) = den(15)*den(20)
  den(23) = den(1)*den(22)
  den(25) = den(2)*den(24)
  den(26) = den(3)*den(23)
  den(27) = den(25)*den(26)
  den(28) = den(10)*den(22)
  den(29) = den(3)*den(28)
  den(30) = den(25)*den(29)
  den(32) = den(15)*den(31)
  den(33) = den(23)*den(32)
  den(34) = den(28)*den(32)
  den(36) = den(3)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(25)*den(37)
  den(39) = den(10)*den(36)
  den(40) = den(25)*den(39)
  den(41) = den(8)*den(36)
  den(42) = den(12)*den(36)
  den(45) = den(1)*den(43)
  den(46) = den(3)*den(44)
  den(48) = den(45)*den(47)
  den(49) = den(46)*den(48)
  den(50) = den(10)*den(43)
  den(51) = den(47)*den(50)
  den(52) = den(46)*den(51)
  den(53) = den(1)*den(44)
  den(54) = den(3)*den(43)
  den(56) = den(53)*den(55)
  den(57) = den(54)*den(56)
  den(58) = den(10)*den(44)
  den(59) = den(55)*den(58)
  den(60) = den(54)*den(59)
  den(62) = den(1)*den(61)
  den(64) = den(46)*den(63)
  den(65) = den(62)*den(64)
  den(66) = den(10)*den(61)
  den(67) = den(64)*den(66)
  den(69) = den(44)*den(68)
  den(70) = den(3)*den(62)
  den(71) = den(69)*den(70)
  den(72) = den(3)*den(66)
  den(73) = den(69)*den(72)
  den(75) = den(3)*den(74)
  den(76) = den(56)*den(75)
  den(77) = den(59)*den(75)
  den(78) = den(1)*den(75)
  den(79) = den(69)*den(78)
  den(80) = den(10)*den(75)
  den(81) = den(69)*den(80)
  den(82) = den(24)*den(43)
  den(83) = den(26)*den(82)
  den(84) = den(29)*den(82)
  den(86) = den(54)*den(85)
  den(87) = den(23)*den(86)
  den(88) = den(28)*den(86)
  den(89) = den(37)*den(82)
  den(90) = den(39)*den(82)
  den(91) = den(36)*den(48)
  den(92) = den(36)*den(51)
  den(94) = den(6)*den(93)
  den(95) = den(62)*den(94)
  den(96) = den(66)*den(94)
  den(97) = den(4)*den(68)
  den(98) = den(70)*den(97)
  den(99) = den(72)*den(97)
  den(100) = den(17)*den(75)
  den(101) = den(20)*den(75)
  den(102) = den(78)*den(97)
  den(103) = den(80)*den(97)
  den(104) = den(7)*den(62)
  den(105) = den(36)*den(104)
  den(106) = den(7)*den(66)
  den(107) = den(36)*den(106)
  den(108) = den(36)*den(63)
  den(109) = den(62)*den(108)
  den(110) = den(66)*den(108)
  den(111) = den(31)*den(75)
  den(112) = den(23)*den(111)
  den(113) = den(28)*den(111)
  den(114) = den(23)*den(55)
  den(115) = den(75)*den(114)
  den(116) = den(28)*den(55)
  den(117) = den(75)*den(116)
  den(121) = den(1)*den(118)
  den(122) = den(119)*den(120)
  den(124) = den(121)*den(123)
  den(125) = den(122)*den(124)
  den(126) = den(10)*den(118)
  den(127) = den(123)*den(126)
  den(128) = den(122)*den(127)
  den(129) = den(1)*den(119)
  den(130) = den(118)*den(120)
  den(132) = den(129)*den(131)
  den(133) = den(130)*den(132)
  den(134) = den(10)*den(119)
  den(135) = den(131)*den(134)
  den(136) = den(130)*den(135)
  den(138) = den(1)*den(137)
  den(140) = den(118)*den(139)
  den(141) = den(120)*den(138)
  den(142) = den(140)*den(141)
  den(143) = den(10)*den(137)
  den(144) = den(120)*den(143)
  den(145) = den(140)*den(144)
  den(147) = den(130)*den(146)
  den(148) = den(138)*den(147)
  den(149) = den(143)*den(147)
  den(151) = den(120)*den(150)
  den(152) = den(1)*den(151)
  den(153) = den(140)*den(152)
  den(154) = den(10)*den(151)
  den(155) = den(140)*den(154)
  den(156) = den(124)*den(151)
  den(157) = den(127)*den(151)
  den(160) = den(1)*den(158)
  den(161) = den(120)*den(159)
  den(163) = den(160)*den(162)
  den(164) = den(161)*den(163)
  den(165) = den(10)*den(158)
  den(166) = den(162)*den(165)
  den(167) = den(161)*den(166)
  den(168) = den(1)*den(159)
  den(169) = den(120)*den(158)
  den(171) = den(168)*den(170)
  den(172) = den(169)*den(171)
  den(173) = den(10)*den(159)
  den(174) = den(170)*den(173)
  den(175) = den(169)*den(174)
  den(177) = den(1)*den(176)
  den(179) = den(161)*den(178)
  den(180) = den(177)*den(179)
  den(181) = den(10)*den(176)
  den(182) = den(179)*den(181)
  den(184) = den(159)*den(183)
  den(185) = den(120)*den(177)
  den(186) = den(184)*den(185)
  den(187) = den(120)*den(181)
  den(188) = den(184)*den(187)
  den(190) = den(120)*den(189)
  den(191) = den(171)*den(190)
  den(192) = den(174)*den(190)
  den(193) = den(1)*den(190)
  den(194) = den(184)*den(193)
  den(195) = den(10)*den(190)
  den(196) = den(184)*den(195)
  den(197) = den(139)*den(158)
  den(198) = den(141)*den(197)
  den(199) = den(144)*den(197)
  den(201) = den(169)*den(200)
  den(202) = den(138)*den(201)
  den(203) = den(143)*den(201)
  den(204) = den(152)*den(197)
  den(205) = den(154)*den(197)
  den(206) = den(151)*den(163)
  den(207) = den(151)*den(166)
  den(209) = den(122)*den(208)
  den(210) = den(177)*den(209)
  den(211) = den(181)*den(209)
  den(212) = den(119)*den(183)
  den(213) = den(185)*den(212)
  den(214) = den(187)*den(212)
  den(215) = den(132)*den(190)
  den(216) = den(135)*den(190)
  den(217) = den(193)*den(212)
  den(218) = den(195)*den(212)
  den(219) = den(123)*den(177)
  den(220) = den(151)*den(219)
  den(221) = den(123)*den(181)
  den(222) = den(151)*den(221)
  den(223) = den(151)*den(178)
  den(224) = den(177)*den(223)
  den(225) = den(181)*den(223)
  den(226) = den(146)*den(190)
  den(227) = den(138)*den(226)
  den(228) = den(143)*den(226)
  den(229) = den(138)*den(170)
  den(230) = den(190)*den(229)
  den(231) = den(143)*den(170)
  den(232) = den(190)*den(231)
  den(233) = den(118)*den(119)
  den(235) = den(233)*den(234)
  den(236) = den(62)*den(235)
  den(237) = den(66)*den(235)
  den(238) = den(23)*den(235)
  den(239) = den(28)*den(235)
  den(241) = den(43)*den(240)
  den(242) = den(118)*den(138)
  den(243) = den(241)*den(242)
  den(244) = den(118)*den(143)
  den(245) = den(241)*den(244)
  den(247) = den(118)*den(246)
  den(248) = den(43)*den(247)
  den(249) = den(23)*den(248)
  den(250) = den(28)*den(248)
  den(251) = den(48)*den(247)
  den(252) = den(51)*den(247)
  den(253) = den(124)*den(241)
  den(254) = den(127)*den(241)
  den(255) = den(4)*den(240)
  den(256) = den(242)*den(255)
  den(257) = den(244)*den(255)
  den(258) = den(62)*den(247)
  den(259) = den(4)*den(258)
  den(260) = den(66)*den(247)
  den(261) = den(4)*den(260)
  den(262) = den(17)*den(247)
  den(263) = den(20)*den(247)
  den(264) = den(124)*den(255)
  den(265) = den(127)*den(255)
  den(266) = den(63)*den(247)
  den(267) = den(62)*den(266)
  den(268) = den(66)*den(266)
  den(269) = den(140)*den(234)
  den(270) = den(62)*den(269)
  den(271) = den(66)*den(269)
  den(272) = den(31)*den(247)
  den(273) = den(23)*den(272)
  den(274) = den(28)*den(272)
  den(275) = den(23)*den(269)
  den(276) = den(28)*den(269)
  den(277) = den(158)*den(159)
  den(278) = den(234)*den(277)
  den(279) = den(62)*den(278)
  den(280) = den(66)*den(278)
  den(281) = den(23)*den(278)
  den(282) = den(28)*den(278)
  den(283) = den(159)*den(177)
  den(284) = den(241)*den(283)
  den(285) = den(159)*den(181)
  den(286) = den(241)*den(285)
  den(287) = den(159)*den(246)
  den(288) = den(43)*den(287)
  den(289) = den(23)*den(288)
  den(290) = den(28)*den(288)
  den(291) = den(48)*den(287)
  den(292) = den(51)*den(287)
  den(293) = den(171)*den(241)
  den(294) = den(174)*den(241)
  den(295) = den(255)*den(283)
  den(296) = den(255)*den(285)
  den(297) = den(62)*den(287)
  den(298) = den(4)*den(297)
  den(299) = den(66)*den(287)
  den(300) = den(4)*den(299)
  den(301) = den(17)*den(287)
  den(302) = den(20)*den(287)
  den(303) = den(171)*den(255)
  den(304) = den(174)*den(255)
  den(305) = den(63)*den(287)
  den(306) = den(62)*den(305)
  den(307) = den(66)*den(305)
  den(308) = den(184)*den(234)
  den(309) = den(62)*den(308)
  den(310) = den(66)*den(308)
  den(311) = den(31)*den(287)
  den(312) = den(23)*den(311)
  den(313) = den(28)*den(311)
  den(314) = den(23)*den(308)
  den(315) = den(28)*den(308)
  den(317) = den(2)*den(316)
  den(318) = den(138)*den(158)
  den(319) = den(317)*den(318)
  den(320) = den(143)*den(158)
  den(321) = den(317)*den(320)
  den(323) = den(158)*den(322)
  den(324) = den(2)*den(323)
  den(325) = den(23)*den(324)
  den(326) = den(28)*den(324)
  den(327) = den(8)*den(323)
  den(328) = den(12)*den(323)
  den(329) = den(163)*den(317)
  den(330) = den(166)*den(317)
  den(331) = den(119)*den(177)
  den(332) = den(317)*den(331)
  den(333) = den(119)*den(181)
  den(334) = den(317)*den(333)
  den(335) = den(119)*den(322)
  den(336) = den(2)*den(335)
  den(337) = den(23)*den(336)
  den(338) = den(28)*den(336)
  den(339) = den(8)*den(335)
  den(340) = den(12)*den(335)
  den(341) = den(132)*den(317)
  den(342) = den(135)*den(317)
  den(343) = den(2)*den(4)
  den(345) = den(343)*den(344)
  den(346) = den(177)*den(345)
  den(347) = den(181)*den(345)
  den(348) = den(138)*den(345)
  den(349) = den(143)*den(345)
  den(351) = den(177)*den(350)
  den(352) = den(25)*den(351)
  den(353) = den(181)*den(350)
  den(354) = den(25)*den(353)
  den(355) = den(178)*den(317)
  den(356) = den(177)*den(355)
  den(357) = den(181)*den(355)
  den(358) = den(138)*den(350)
  den(359) = den(25)*den(358)
  den(360) = den(143)*den(350)
  den(361) = den(25)*den(360)
  den(362) = den(146)*den(317)
  den(363) = den(138)*den(362)
  den(364) = den(143)*den(362)
  den(365) = den(44)*den(316)
  den(366) = den(318)*den(365)
  den(367) = den(320)*den(365)
  den(368) = den(62)*den(323)
  den(369) = den(44)*den(368)
  den(370) = den(66)*den(323)
  den(371) = den(44)*den(370)
  den(372) = den(56)*den(323)
  den(373) = den(59)*den(323)
  den(374) = den(163)*den(365)
  den(375) = den(166)*den(365)
  den(376) = den(331)*den(365)
  den(377) = den(333)*den(365)
  den(378) = den(62)*den(335)
  den(379) = den(44)*den(378)
  den(380) = den(66)*den(335)
  den(381) = den(44)*den(380)
  den(382) = den(56)*den(335)
  den(383) = den(59)*den(335)
  den(384) = den(132)*den(365)
  den(385) = den(135)*den(365)
  den(386) = den(43)*den(44)
  den(387) = den(344)*den(386)
  den(388) = den(177)*den(387)
  den(389) = den(181)*den(387)
  den(390) = den(138)*den(387)
  den(391) = den(143)*den(387)
  den(392) = den(69)*den(351)
  den(393) = den(69)*den(353)
  den(394) = den(178)*den(365)
  den(395) = den(177)*den(394)
  den(396) = den(181)*den(394)
  den(397) = den(69)*den(358)
  den(398) = den(69)*den(360)
  den(399) = den(146)*den(365)
  den(400) = den(138)*den(399)
  den(401) = den(143)*den(399)
  den(402) = den(93)*den(323)
  den(403) = den(62)*den(402)
  den(404) = den(66)*den(402)
  den(405) = den(197)*den(234)
  den(406) = den(62)*den(405)
  den(407) = den(66)*den(405)
  den(408) = den(85)*den(323)
  den(409) = den(23)*den(408)
  den(410) = den(28)*den(408)
  den(411) = den(23)*den(405)
  den(412) = den(28)*den(405)
  den(413) = den(93)*den(335)
  den(414) = den(62)*den(413)
  den(415) = den(66)*den(413)
  den(416) = den(212)*den(234)
  den(417) = den(62)*den(416)
  den(418) = den(66)*den(416)
  den(419) = den(85)*den(335)
  den(420) = den(23)*den(419)
  den(421) = den(28)*den(419)
  den(422) = den(23)*den(416)
  den(423) = den(28)*den(416)
  den(424) = den(82)*den(351)
  den(425) = den(82)*den(353)
  den(426) = den(208)*den(241)
  den(427) = den(177)*den(426)
  den(428) = den(181)*den(426)
  den(429) = den(82)*den(358)
  den(430) = den(82)*den(360)
  den(431) = den(200)*den(241)
  den(432) = den(138)*den(431)
  den(433) = den(143)*den(431)
  den(434) = den(97)*den(351)
  den(435) = den(97)*den(353)
  den(436) = den(208)*den(255)
  den(437) = den(177)*den(436)
  den(438) = den(181)*den(436)
  den(439) = den(97)*den(358)
  den(440) = den(97)*den(360)
  den(441) = den(200)*den(255)
  den(442) = den(138)*den(441)
  den(443) = den(143)*den(441)
  den(446) = den(444)*den(445)
  den(448) = den(446)*den(447)
  den(449) = den(75)*den(448)
  den(451) = den(446)*den(450)
  den(452) = den(75)*den(451)
  den(453) = den(36)*den(448)
  den(454) = den(36)*den(451)
  den(456) = den(444)*den(455)
  den(457) = den(86)*den(456)
  den(459) = den(444)*den(458)
  den(460) = den(86)*den(459)
  den(461) = den(43)*den(456)
  den(462) = den(36)*den(461)
  den(463) = den(43)*den(459)
  den(464) = den(36)*den(463)
  den(465) = den(94)*den(456)
  den(466) = den(94)*den(459)
  den(467) = den(75)*den(456)
  den(468) = den(4)*den(467)
  den(469) = den(75)*den(459)
  den(470) = den(4)*den(469)
  den(471) = den(7)*den(456)
  den(472) = den(36)*den(471)
  den(473) = den(7)*den(459)
  den(474) = den(36)*den(473)
  den(475) = den(55)*den(456)
  den(476) = den(75)*den(475)
  den(477) = den(55)*den(459)
  den(478) = den(75)*den(477)
  den(480) = den(444)*den(479)
  den(481) = den(447)*den(480)
  den(482) = den(36)*den(481)
  den(483) = den(450)*den(480)
  den(484) = den(36)*den(483)
  den(485) = den(75)*den(481)
  den(486) = den(75)*den(483)
  den(489) = den(487)*den(488)
  den(490) = den(447)*den(489)
  den(491) = den(75)*den(490)
  den(492) = den(450)*den(489)
  den(493) = den(75)*den(492)
  den(494) = den(36)*den(490)
  den(495) = den(36)*den(492)
  den(496) = den(455)*den(488)
  den(497) = den(86)*den(496)
  den(498) = den(458)*den(488)
  den(499) = den(86)*den(498)
  den(500) = den(43)*den(496)
  den(501) = den(36)*den(500)
  den(502) = den(43)*den(498)
  den(503) = den(36)*den(502)
  den(504) = den(94)*den(496)
  den(505) = den(94)*den(498)
  den(506) = den(75)*den(496)
  den(507) = den(4)*den(506)
  den(508) = den(75)*den(498)
  den(509) = den(4)*den(508)
  den(510) = den(7)*den(496)
  den(511) = den(36)*den(510)
  den(512) = den(7)*den(498)
  den(513) = den(36)*den(512)
  den(514) = den(55)*den(496)
  den(515) = den(75)*den(514)
  den(516) = den(55)*den(498)
  den(517) = den(75)*den(516)
  den(519) = den(488)*den(518)
  den(520) = den(447)*den(519)
  den(521) = den(36)*den(520)
  den(522) = den(450)*den(519)
  den(523) = den(36)*den(522)
  den(524) = den(75)*den(520)
  den(525) = den(75)*den(522)
  den(527) = den(487)*den(526)
  den(528) = den(32)*den(527)
  den(530) = den(487)*den(529)
  den(531) = den(32)*den(530)
  den(532) = den(2)*den(527)
  den(533) = den(36)*den(532)
  den(534) = den(2)*den(530)
  den(535) = den(36)*den(534)
  den(536) = den(445)*den(526)
  den(537) = den(32)*den(536)
  den(538) = den(445)*den(529)
  den(539) = den(32)*den(538)
  den(540) = den(2)*den(536)
  den(541) = den(36)*den(540)
  den(542) = den(2)*den(538)
  den(543) = den(36)*den(542)
  den(544) = den(64)*den(527)
  den(545) = den(64)*den(530)
  den(546) = den(75)*den(527)
  den(547) = den(44)*den(546)
  den(548) = den(75)*den(530)
  den(549) = den(44)*den(548)
  den(550) = den(64)*den(536)
  den(551) = den(64)*den(538)
  den(552) = den(75)*den(536)
  den(553) = den(44)*den(552)
  den(554) = den(75)*den(538)
  den(555) = den(44)*den(554)
  den(556) = den(47)*den(527)
  den(557) = den(36)*den(556)
  den(558) = den(47)*den(530)
  den(559) = den(36)*den(558)
  den(560) = den(16)*den(527)
  den(561) = den(75)*den(560)
  den(562) = den(16)*den(530)
  den(563) = den(75)*den(562)
  den(564) = den(479)*den(487)
  den(565) = den(447)*den(564)
  den(566) = den(36)*den(565)
  den(567) = den(450)*den(564)
  den(568) = den(36)*den(567)
  den(569) = den(75)*den(565)
  den(570) = den(75)*den(567)
  den(571) = den(47)*den(536)
  den(572) = den(36)*den(571)
  den(573) = den(47)*den(538)
  den(574) = den(36)*den(573)
  den(575) = den(16)*den(536)
  den(576) = den(75)*den(575)
  den(577) = den(16)*den(538)
  den(578) = den(75)*den(577)
  den(579) = den(445)*den(518)
  den(580) = den(447)*den(579)
  den(581) = den(36)*den(580)
  den(582) = den(450)*den(579)
  den(583) = den(36)*den(582)
  den(584) = den(75)*den(580)
  den(585) = den(75)*den(582)
  den(586) = den(190)*den(448)
  den(587) = den(190)*den(451)
  den(588) = den(151)*den(448)
  den(589) = den(151)*den(451)
  den(590) = den(201)*den(456)
  den(591) = den(201)*den(459)
  den(592) = den(158)*den(456)
  den(593) = den(151)*den(592)
  den(594) = den(158)*den(459)
  den(595) = den(151)*den(594)
  den(596) = den(209)*den(456)
  den(597) = den(209)*den(459)
  den(598) = den(190)*den(456)
  den(599) = den(119)*den(598)
  den(600) = den(190)*den(459)
  den(601) = den(119)*den(600)
  den(602) = den(123)*den(456)
  den(603) = den(151)*den(602)
  den(604) = den(123)*den(459)
  den(605) = den(151)*den(604)
  den(606) = den(170)*den(456)
  den(607) = den(190)*den(606)
  den(608) = den(170)*den(459)
  den(609) = den(190)*den(608)
  den(610) = den(151)*den(481)
  den(611) = den(151)*den(483)
  den(612) = den(190)*den(481)
  den(613) = den(190)*den(483)
  den(614) = den(190)*den(490)
  den(615) = den(190)*den(492)
  den(616) = den(151)*den(490)
  den(617) = den(151)*den(492)
  den(618) = den(201)*den(496)
  den(619) = den(201)*den(498)
  den(620) = den(158)*den(496)
  den(621) = den(151)*den(620)
  den(622) = den(158)*den(498)
  den(623) = den(151)*den(622)
  den(624) = den(209)*den(496)
  den(625) = den(209)*den(498)
  den(626) = den(190)*den(496)
  den(627) = den(119)*den(626)
  den(628) = den(190)*den(498)
  den(629) = den(119)*den(628)
  den(630) = den(123)*den(496)
  den(631) = den(151)*den(630)
  den(632) = den(123)*den(498)
  den(633) = den(151)*den(632)
  den(634) = den(170)*den(496)
  den(635) = den(190)*den(634)
  den(636) = den(170)*den(498)
  den(637) = den(190)*den(636)
  den(638) = den(151)*den(520)
  den(639) = den(151)*den(522)
  den(640) = den(190)*den(520)
  den(641) = den(190)*den(522)
  den(642) = den(147)*den(527)
  den(643) = den(147)*den(530)
  den(644) = den(118)*den(527)
  den(645) = den(151)*den(644)
  den(646) = den(118)*den(530)
  den(647) = den(151)*den(646)
  den(648) = den(147)*den(536)
  den(649) = den(147)*den(538)
  den(650) = den(118)*den(536)
  den(651) = den(151)*den(650)
  den(652) = den(118)*den(538)
  den(653) = den(151)*den(652)
  den(654) = den(179)*den(527)
  den(655) = den(179)*den(530)
  den(656) = den(190)*den(527)
  den(657) = den(159)*den(656)
  den(658) = den(190)*den(530)
  den(659) = den(159)*den(658)
  den(660) = den(179)*den(536)
  den(661) = den(179)*den(538)
  den(662) = den(190)*den(536)
  den(663) = den(159)*den(662)
  den(664) = den(190)*den(538)
  den(665) = den(159)*den(664)
  den(666) = den(162)*den(527)
  den(667) = den(151)*den(666)
  den(668) = den(162)*den(530)
  den(669) = den(151)*den(668)
  den(670) = den(131)*den(527)
  den(671) = den(190)*den(670)
  den(672) = den(131)*den(530)
  den(673) = den(190)*den(672)
  den(674) = den(151)*den(565)
  den(675) = den(151)*den(567)
  den(676) = den(190)*den(565)
  den(677) = den(190)*den(567)
  den(678) = den(162)*den(536)
  den(679) = den(151)*den(678)
  den(680) = den(162)*den(538)
  den(681) = den(151)*den(680)
  den(682) = den(131)*den(536)
  den(683) = den(190)*den(682)
  den(684) = den(131)*den(538)
  den(685) = den(190)*den(684)
  den(686) = den(151)*den(580)
  den(687) = den(151)*den(582)
  den(688) = den(190)*den(580)
  den(689) = den(190)*den(582)
  den(690) = den(323)*den(471)
  den(691) = den(323)*den(473)
  den(692) = den(408)*den(456)
  den(693) = den(408)*den(459)
  den(694) = den(335)*den(471)
  den(695) = den(335)*den(473)
  den(696) = den(419)*den(456)
  den(697) = den(419)*den(459)
  den(698) = den(241)*den(602)
  den(699) = den(241)*den(604)
  den(700) = den(431)*den(456)
  den(701) = den(431)*den(459)
  den(702) = den(255)*den(602)
  den(703) = den(255)*den(604)
  den(704) = den(441)*den(456)
  den(705) = den(441)*den(459)
  den(706) = den(323)*den(510)
  den(707) = den(323)*den(512)
  den(708) = den(408)*den(496)
  den(709) = den(408)*den(498)
  den(710) = den(335)*den(510)
  den(711) = den(335)*den(512)
  den(712) = den(419)*den(496)
  den(713) = den(419)*den(498)
  den(714) = den(241)*den(630)
  den(715) = den(241)*den(632)
  den(716) = den(431)*den(496)
  den(717) = den(431)*den(498)
  den(718) = den(255)*den(630)
  den(719) = den(255)*den(632)
  den(720) = den(441)*den(496)
  den(721) = den(441)*den(498)
  den(722) = den(247)*den(556)
  den(723) = den(247)*den(558)
  den(724) = den(272)*den(527)
  den(725) = den(272)*den(530)
  den(726) = den(247)*den(571)
  den(727) = den(247)*den(573)
  den(728) = den(272)*den(536)
  den(729) = den(272)*den(538)
  den(730) = den(287)*den(556)
  den(731) = den(287)*den(558)
  den(732) = den(311)*den(527)
  den(733) = den(311)*den(530)
  den(734) = den(287)*den(571)
  den(735) = den(287)*den(573)
  den(736) = den(311)*den(536)
  den(737) = den(311)*den(538)
  den(738) = den(317)*den(666)
  den(739) = den(317)*den(668)
  den(740) = den(362)*den(527)
  den(741) = den(362)*den(530)
  den(742) = den(317)*den(678)
  den(743) = den(317)*den(680)
  den(744) = den(362)*den(536)
  den(745) = den(362)*den(538)
  den(746) = den(365)*den(666)
  den(747) = den(365)*den(668)
  den(748) = den(399)*den(527)
  den(749) = den(399)*den(530)
  den(750) = den(365)*den(678)
  den(751) = den(365)*den(680)
  den(752) = den(399)*den(536)
  den(753) = den(399)*den(538)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppllaaj_eexuuxbbxaa_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppllaaj_eexuuxbbxaa_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ up anti-up bottom anti-bottom gamma gamma -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllaaj_eexuuxbbxaa_1, only: &
    & external_perm_ppllaaj_eexuuxbbxaa_1, &
    & external_perm_inv_ppllaaj_eexuuxbbxaa_1, &
    & extcomb_perm_ppllaaj_eexuuxbbxaa_1, &
    & average_factor_ppllaaj_eexuuxbbxaa_1
  use ol_external_ppllaaj_eexuuxbbxaa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllaaj_eexuuxbbxaa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllaaj_eexuuxbbxaa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppllaaj_eexuuxbbxaa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:1-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,8)
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add(0:1-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(2), M1helarray(2,256)
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,29), wf8(8,68), wf16(16,226), wf32(32,44), wf64(64,24), wf256(256,448)

  type(polcont) :: A(256,448)
  complex(REALKIND) :: Aj(448)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMB, nMB, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllaaj_eexuuxbbxaa_1, 8,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppllaaj_eexuuxbbxaa_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppllaaj_eexuuxbbxaa_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllaaj_eexuuxbbxaa_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5))
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))
  call pol_wf_V(P(:,8), rZERO, H8, ex8, POLSEL(8))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_A(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_Q(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_A(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_Q(P(:,5), rMB, H5, ex5, 0)
      call pol_wf_A(P(:,6), rMB, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)
      call pol_wf_V(P(:,8), rZERO, H8, ex8, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)
    call helbookkeeping_flip(H8, 8, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H8, ex8, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3, ex4, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7, ex5, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AV_Q(ntry, ex6, ex8, wf4(:,4), n3(:,4), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,3), 80, MB, 1_intkind1, wf4(:,5), n2(1))
  call prop_A_Q(ntry, wf4(:,4), 160, MB, 1_intkind1, wf4(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,5), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call vert_AV_Q(ntry, wf4(:,6), wf4(:,2), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call prop_Q_A(ntry, wf16(:,1), 83, MB, 1_intkind1, wf16(:,3), n2(3))
  call vert_QA_Z(gZl,ntry, ex1, ex2, wf4(:,7), n3(:,7), t3x4(:,:,5))
  call prop_W_W(ntry, wf4(:,7), 3, MZ, 1_intkind1, wf4(:,8), n2(4))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,5), wf16(:,4), n3(:,8), t3x16(:,:,3))
  call prop_Q_A(ntry, wf16(:,4), 83, MB, 1_intkind1, wf16(:,5), n2(5))
  call vert_AV_Q(ntry, wf4(:,6), wf4(:,1), wf16(:,6), n3(:,9), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,5), wf16(:,7), n3(:,10), t3x16(:,:,5))
  call prop_A_Q(ntry, wf16(:,6), 163, MB, 1_intkind1, wf16(:,8), n2(6))
  call vert_AZ_Q(gZd,ntry, wf4(:,6), wf4(:,8), wf16(:,9), n3(:,11), t3x16(:,:,6))
  call prop_A_Q(ntry, wf16(:,9), 163, MB, 1_intkind1, wf16(:,10), n2(7))
  call vert_AV_Q(ntry, ex6, wf4(:,1), wf8(:,1), n3(:,12), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex8, wf4(:,5), wf8(:,2), n3(:,13), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 35, MB, 1_intkind1, wf8(:,3), n2(8))
  call prop_Q_A(ntry, wf8(:,2), 208, MB, 1_intkind1, wf8(:,4), n2(9))
  call vert_AV_Q(ntry, wf8(:,3), wf4(:,2), wf32(:,1), n3(:,14), t3x32(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,8), wf8(:,5), n3(:,15), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 35, MB, 1_intkind1, wf8(:,6), n2(10))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,2), wf32(:,2), n3(:,16), t3x32(:,:,2))
  call prop_Q_A(ntry, wf16(:,7), 92, MB, 1_intkind1, wf16(:,11), n2(11))
  call vert_AV_Q(ntry, wf8(:,3), ex8, wf16(:,12), n3(:,17), t3x16(:,:,7))
  call vert_AV_Q(ntry, wf8(:,6), ex8, wf16(:,13), n3(:,18), t3x16(:,:,8))
  call vert_AV_Q(ntry, ex6, wf4(:,2), wf8(:,7), n3(:,19), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 44, MB, 1_intkind1, wf8(:,8), n2(12))
  call vert_AV_Q(ntry, wf8(:,8), wf4(:,1), wf32(:,3), n3(:,20), t3x32(:,:,3))
  call vert_AZ_Q(gZd,ntry, wf8(:,8), wf4(:,8), wf32(:,4), n3(:,21), t3x32(:,:,4))
  call vert_AV_Q(ntry, wf8(:,8), ex8, wf16(:,14), n3(:,22), t3x16(:,:,9))
  call vert_VQ_A(ntry, ex8, ex5, wf4(:,9), n3(:,23), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex6, ex7, wf4(:,10), n3(:,24), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,9), 144, MB, 1_intkind1, wf4(:,11), n2(13))
  call prop_A_Q(ntry, wf4(:,10), 96, MB, 1_intkind1, wf4(:,12), n2(14))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,11), wf16(:,15), n3(:,25), t3x16(:,:,10))
  call vert_AV_Q(ntry, wf4(:,12), wf4(:,2), wf16(:,16), n3(:,26), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,15), 147, MB, 1_intkind1, wf16(:,17), n2(15))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,11), wf16(:,18), n3(:,27), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,18), 147, MB, 1_intkind1, wf16(:,19), n2(16))
  call vert_AV_Q(ntry, wf4(:,12), wf4(:,1), wf16(:,20), n3(:,28), t3x16(:,:,13))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,11), wf16(:,21), n3(:,29), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,20), 99, MB, 1_intkind1, wf16(:,22), n2(17))
  call vert_AZ_Q(gZd,ntry, wf4(:,12), wf4(:,8), wf16(:,23), n3(:,30), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,23), 99, MB, 1_intkind1, wf16(:,24), n2(18))
  call vert_VQ_A(ntry, wf4(:,1), ex5, wf8(:,9), n3(:,31), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 19, MB, 1_intkind1, wf8(:,10), n2(19))
  call prop_A_Q(ntry, wf16(:,16), 108, MB, 1_intkind1, wf16(:,25), n2(20))
  call vert_VQ_A(ntry, ex8, wf8(:,10), wf16(:,26), n3(:,32), t3x16(:,:,16))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex5, wf8(:,11), n3(:,33), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 19, MB, 1_intkind1, wf8(:,12), n2(21))
  call vert_VQ_A(ntry, ex8, wf8(:,12), wf16(:,27), n3(:,34), t3x16(:,:,17))
  call vert_AV_Q(ntry, wf4(:,12), ex8, wf8(:,13), n3(:,35), t3x8(:,:,7))
  call prop_A_Q(ntry, wf8(:,13), 224, MB, 1_intkind1, wf8(:,14), n2(22))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,10), wf32(:,5), n3(:,36), t3x32(:,:,5))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,12), wf32(:,6), n3(:,37), t3x32(:,:,6))
  call vert_VQ_A(ntry, wf4(:,2), ex5, wf8(:,15), n3(:,38), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 28, MB, 1_intkind1, wf8(:,16), n2(23))
  call vert_VQ_A(ntry, ex8, wf8(:,16), wf16(:,28), n3(:,39), t3x16(:,:,18))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,16), wf32(:,7), n3(:,40), t3x32(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,16), wf32(:,8), n3(:,41), t3x32(:,:,8))
  call vert_VQ_A(ntry, ex7, wf4(:,11), wf8(:,17), n3(:,42), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,17), 208, MB, 1_intkind1, wf8(:,18), n2(24))
  call prop_Q_A(ntry, wf16(:,21), 156, MB, 1_intkind1, wf16(:,29), n2(25))
  call vert_AV_Q(ntry, wf8(:,3), ex7, wf16(:,30), n3(:,43), t3x16(:,:,19))
  call vert_AV_Q(ntry, wf8(:,6), ex7, wf16(:,31), n3(:,44), t3x16(:,:,20))
  call vert_AV_Q(ntry, wf8(:,8), ex7, wf16(:,32), n3(:,45), t3x16(:,:,21))
  call prop_A_Q(ntry, wf16(:,2), 172, MB, 1_intkind1, wf16(:,33), n2(26))
  call vert_VQ_A(ntry, ex7, wf8(:,10), wf16(:,34), n3(:,46), t3x16(:,:,22))
  call vert_VQ_A(ntry, ex7, wf8(:,12), wf16(:,35), n3(:,47), t3x16(:,:,23))
  call vert_AV_Q(ntry, wf4(:,6), ex7, wf8(:,19), n3(:,48), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 224, MB, 1_intkind1, wf8(:,20), n2(27))
  call vert_VQ_A(ntry, ex7, wf8(:,16), wf16(:,36), n3(:,49), t3x16(:,:,24))
  call prop_Q_A(ntry, wf16(:,34), 83, MB, 1_intkind1, wf16(:,37), n2(28))
  call prop_Q_A(ntry, wf16(:,35), 83, MB, 1_intkind1, wf16(:,38), n2(29))
  call prop_A_Q(ntry, wf16(:,32), 108, MB, 1_intkind1, wf16(:,39), n2(30))
  call prop_Q_A(ntry, wf16(:,36), 92, MB, 1_intkind1, wf16(:,40), n2(31))
  call prop_A_Q(ntry, wf16(:,30), 99, MB, 1_intkind1, wf16(:,41), n2(32))
  call prop_A_Q(ntry, wf16(:,31), 99, MB, 1_intkind1, wf16(:,42), n2(33))
  call vert_VQ_A(ntry, ex7, ex3, wf4(:,13), n3(:,50), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex4, ex8, wf4(:,14), n3(:,51), t3x4(:,:,9))
  call vert_QA_V(ntry, ex5, ex6, wf4(:,15), n3(:,52), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,13), 68, ZERO, 0_intkind1, wf4(:,16), n2(34))
  call prop_A_Q(ntry, wf4(:,14), 136, ZERO, 0_intkind1, wf4(:,17), n2(35))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,16), wf16(:,43), n3(:,53), t3x16(:,:,25))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,15), wf16(:,44), n3(:,54), t3x16(:,:,26))
  call prop_Q_A(ntry, wf16(:,43), 71, ZERO, 0_intkind1, wf16(:,45), n2(36))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf4(:,16), wf16(:,46), n3(:,55), t3x16(:,:,27))
  call prop_Q_A(ntry, wf16(:,46), 71, ZERO, 0_intkind1, wf16(:,47), n2(37))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,1), wf16(:,48), n3(:,56), t3x16(:,:,28))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,16), wf16(:,49), n3(:,57), t3x16(:,:,29))
  call prop_A_Q(ntry, wf16(:,48), 139, ZERO, 0_intkind1, wf16(:,50), n2(38))
  call vert_AZ_Q(gZu,ntry, wf4(:,17), wf4(:,8), wf16(:,51), n3(:,58), t3x16(:,:,30))
  call prop_A_Q(ntry, wf16(:,51), 139, ZERO, 0_intkind1, wf16(:,52), n2(39))
  call vert_AV_Q(ntry, ex4, wf4(:,1), wf8(:,21), n3(:,59), t3x8(:,:,11))
  call vert_VQ_A(ntry, ex8, wf4(:,16), wf8(:,22), n3(:,60), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,21), 11, ZERO, 0_intkind1, wf8(:,23), n2(40))
  call prop_Q_A(ntry, wf8(:,22), 196, ZERO, 0_intkind1, wf8(:,24), n2(41))
  call vert_AV_Q(ntry, wf8(:,23), wf4(:,15), wf32(:,9), n3(:,61), t3x32(:,:,9))
  call vert_AZ_Q(gZu,ntry, ex4, wf4(:,8), wf8(:,25), n3(:,62), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,25), 11, ZERO, 0_intkind1, wf8(:,26), n2(42))
  call vert_AV_Q(ntry, wf8(:,26), wf4(:,15), wf32(:,10), n3(:,63), t3x32(:,:,10))
  call prop_Q_A(ntry, wf16(:,49), 116, ZERO, 0_intkind1, wf16(:,53), n2(43))
  call vert_AV_Q(ntry, wf8(:,23), ex8, wf16(:,54), n3(:,64), t3x16(:,:,31))
  call vert_AV_Q(ntry, wf8(:,26), ex8, wf16(:,55), n3(:,65), t3x16(:,:,32))
  call vert_AV_Q(ntry, ex4, wf4(:,15), wf8(:,27), n3(:,66), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 56, ZERO, 0_intkind1, wf8(:,28), n2(44))
  call vert_AV_Q(ntry, wf8(:,28), wf4(:,1), wf32(:,11), n3(:,67), t3x32(:,:,11))
  call vert_AZ_Q(gZu,ntry, wf8(:,28), wf4(:,8), wf32(:,12), n3(:,68), t3x32(:,:,12))
  call vert_AV_Q(ntry, wf8(:,28), ex8, wf16(:,56), n3(:,69), t3x16(:,:,33))
  call vert_VQ_A(ntry, ex8, ex3, wf4(:,18), n3(:,70), t3x4(:,:,11))
  call vert_AV_Q(ntry, ex4, ex7, wf4(:,19), n3(:,71), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,18), 132, ZERO, 0_intkind1, wf4(:,20), n2(45))
  call prop_A_Q(ntry, wf4(:,19), 72, ZERO, 0_intkind1, wf4(:,21), n2(46))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,20), wf16(:,57), n3(:,72), t3x16(:,:,34))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,15), wf16(:,58), n3(:,73), t3x16(:,:,35))
  call prop_Q_A(ntry, wf16(:,57), 135, ZERO, 0_intkind1, wf16(:,59), n2(47))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf4(:,20), wf16(:,60), n3(:,74), t3x16(:,:,36))
  call prop_Q_A(ntry, wf16(:,60), 135, ZERO, 0_intkind1, wf16(:,61), n2(48))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,1), wf16(:,62), n3(:,75), t3x16(:,:,37))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,20), wf16(:,63), n3(:,76), t3x16(:,:,38))
  call prop_A_Q(ntry, wf16(:,62), 75, ZERO, 0_intkind1, wf16(:,64), n2(49))
  call vert_AZ_Q(gZu,ntry, wf4(:,21), wf4(:,8), wf16(:,65), n3(:,77), t3x16(:,:,39))
  call prop_A_Q(ntry, wf16(:,65), 75, ZERO, 0_intkind1, wf16(:,66), n2(50))
  call vert_VQ_A(ntry, wf4(:,1), ex3, wf8(:,29), n3(:,78), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,29), 7, ZERO, 0_intkind1, wf8(:,30), n2(51))
  call prop_A_Q(ntry, wf16(:,58), 120, ZERO, 0_intkind1, wf16(:,67), n2(52))
  call vert_VQ_A(ntry, ex8, wf8(:,30), wf16(:,68), n3(:,79), t3x16(:,:,40))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), ex3, wf8(:,31), n3(:,80), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 7, ZERO, 0_intkind1, wf8(:,32), n2(53))
  call vert_VQ_A(ntry, ex8, wf8(:,32), wf16(:,69), n3(:,81), t3x16(:,:,41))
  call vert_AV_Q(ntry, wf4(:,21), ex8, wf8(:,33), n3(:,82), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,33), 200, ZERO, 0_intkind1, wf8(:,34), n2(54))
  call vert_VQ_A(ntry, wf4(:,15), wf8(:,30), wf32(:,13), n3(:,83), t3x32(:,:,13))
  call vert_VQ_A(ntry, wf4(:,15), wf8(:,32), wf32(:,14), n3(:,84), t3x32(:,:,14))
  call vert_VQ_A(ntry, wf4(:,15), ex3, wf8(:,35), n3(:,85), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,35), 52, ZERO, 0_intkind1, wf8(:,36), n2(55))
  call vert_VQ_A(ntry, ex8, wf8(:,36), wf16(:,70), n3(:,86), t3x16(:,:,42))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,36), wf32(:,15), n3(:,87), t3x32(:,:,15))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), wf8(:,36), wf32(:,16), n3(:,88), t3x32(:,:,16))
  call vert_VQ_A(ntry, ex7, wf4(:,20), wf8(:,37), n3(:,89), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,37), 196, ZERO, 0_intkind1, wf8(:,38), n2(56))
  call prop_Q_A(ntry, wf16(:,63), 180, ZERO, 0_intkind1, wf16(:,71), n2(57))
  call vert_AV_Q(ntry, wf8(:,23), ex7, wf16(:,72), n3(:,90), t3x16(:,:,43))
  call vert_AV_Q(ntry, wf8(:,26), ex7, wf16(:,73), n3(:,91), t3x16(:,:,44))
  call vert_AV_Q(ntry, wf8(:,28), ex7, wf16(:,74), n3(:,92), t3x16(:,:,45))
  call prop_A_Q(ntry, wf16(:,44), 184, ZERO, 0_intkind1, wf16(:,75), n2(58))
  call vert_VQ_A(ntry, ex7, wf8(:,30), wf16(:,76), n3(:,93), t3x16(:,:,46))
  call vert_VQ_A(ntry, ex7, wf8(:,32), wf16(:,77), n3(:,94), t3x16(:,:,47))
  call vert_AV_Q(ntry, wf4(:,17), ex7, wf8(:,39), n3(:,95), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,39), 200, ZERO, 0_intkind1, wf8(:,40), n2(59))
  call vert_VQ_A(ntry, ex7, wf8(:,36), wf16(:,78), n3(:,96), t3x16(:,:,48))
  call prop_Q_A(ntry, wf16(:,76), 71, ZERO, 0_intkind1, wf16(:,79), n2(60))
  call prop_Q_A(ntry, wf16(:,77), 71, ZERO, 0_intkind1, wf16(:,80), n2(61))
  call prop_A_Q(ntry, wf16(:,74), 120, ZERO, 0_intkind1, wf16(:,81), n2(62))
  call prop_Q_A(ntry, wf16(:,78), 116, ZERO, 0_intkind1, wf16(:,82), n2(63))
  call prop_A_Q(ntry, wf16(:,72), 75, ZERO, 0_intkind1, wf16(:,83), n2(64))
  call prop_A_Q(ntry, wf16(:,73), 75, ZERO, 0_intkind1, wf16(:,84), n2(65))
  call vert_QA_V(ntry, wf4(:,16), wf4(:,17), wf16(:,85), n3(:,97), t3x16(:,:,49))
  call vert_QA_V(ntry, wf8(:,10), ex6, wf16(:,86), n3(:,98), t3x16(:,:,50))
  call vert_QA_V(ntry, wf8(:,12), ex6, wf16(:,87), n3(:,99), t3x16(:,:,51))
  call vert_QA_V(ntry, ex5, wf8(:,3), wf16(:,88), n3(:,100), t3x16(:,:,52))
  call vert_QA_V(ntry, ex5, wf8(:,6), wf16(:,89), n3(:,101), t3x16(:,:,53))
  call vert_QA_V(ntry, wf4(:,11), ex6, wf8(:,41), n3(:,102), t3x8(:,:,21))
  call vert_QA_V(ntry, wf4(:,16), wf8(:,23), wf32(:,17), n3(:,103), t3x32(:,:,17))
  call vert_QA_V(ntry, wf4(:,16), wf8(:,26), wf32(:,18), n3(:,104), t3x32(:,:,18))
  call vert_QA_V(ntry, wf4(:,16), ex4, wf8(:,42), n3(:,105), t3x8(:,:,22))
  call vert_VQ_A(ntry, wf8(:,42), wf4(:,11), wf32(:,19), n3(:,106), t3x32(:,:,19))
  call vert_AV_Q(ntry, ex6, wf8(:,42), wf16(:,90), n3(:,107), t3x16(:,:,54))
  call vert_AV_Q(ntry, ex4, wf8(:,41), wf16(:,91), n3(:,108), t3x16(:,:,55))
  call vert_QA_V(ntry, ex5, wf4(:,6), wf8(:,43), n3(:,109), t3x8(:,:,23))
  call vert_VQ_A(ntry, wf8(:,42), wf8(:,10), wf64(:,1), n3(:,110), t3x64(:,:,1))
  call vert_VQ_A(ntry, wf8(:,42), wf8(:,12), wf64(:,2), n3(:,111), t3x64(:,:,2))
  call vert_VQ_A(ntry, wf8(:,42), ex5, wf16(:,92), n3(:,112), t3x16(:,:,56))
  call vert_AV_Q(ntry, ex4, wf8(:,43), wf16(:,93), n3(:,113), t3x16(:,:,57))
  call prop_A_Q(ntry, wf16(:,90), 108, MB, 1_intkind1, wf16(:,94), n2(66))
  call vert_QA_V(ntry, wf8(:,24), ex4, wf16(:,95), n3(:,114), t3x16(:,:,58))
  call prop_Q_A(ntry, wf16(:,92), 92, MB, 1_intkind1, wf16(:,96), n2(67))
  call vert_QA_V(ntry, wf4(:,20), wf4(:,21), wf16(:,97), n3(:,115), t3x16(:,:,59))
  call vert_QA_V(ntry, wf8(:,30), wf4(:,21), wf32(:,20), n3(:,116), t3x32(:,:,20))
  call vert_QA_V(ntry, wf8(:,32), wf4(:,21), wf32(:,21), n3(:,117), t3x32(:,:,21))
  call vert_QA_V(ntry, ex3, wf4(:,21), wf8(:,44), n3(:,118), t3x8(:,:,24))
  call vert_VQ_A(ntry, wf8(:,44), wf4(:,11), wf32(:,22), n3(:,119), t3x32(:,:,22))
  call vert_AV_Q(ntry, ex6, wf8(:,44), wf16(:,98), n3(:,120), t3x16(:,:,60))
  call vert_VQ_A(ntry, wf8(:,41), ex3, wf16(:,99), n3(:,121), t3x16(:,:,61))
  call vert_VQ_A(ntry, wf8(:,44), wf8(:,10), wf64(:,3), n3(:,122), t3x64(:,:,3))
  call vert_VQ_A(ntry, wf8(:,44), wf8(:,12), wf64(:,4), n3(:,123), t3x64(:,:,4))
  call vert_VQ_A(ntry, wf8(:,44), ex5, wf16(:,100), n3(:,124), t3x16(:,:,62))
  call vert_VQ_A(ntry, wf8(:,43), ex3, wf16(:,101), n3(:,125), t3x16(:,:,63))
  call prop_A_Q(ntry, wf16(:,98), 108, MB, 1_intkind1, wf16(:,102), n2(68))
  call vert_QA_V(ntry, ex3, wf8(:,34), wf16(:,103), n3(:,126), t3x16(:,:,64))
  call prop_Q_A(ntry, wf16(:,100), 92, MB, 1_intkind1, wf16(:,104), n2(69))
  call vert_QA_V(ntry, wf4(:,5), ex6, wf8(:,45), n3(:,127), t3x8(:,:,25))
  call vert_QA_V(ntry, wf4(:,20), wf8(:,23), wf32(:,23), n3(:,128), t3x32(:,:,23))
  call vert_QA_V(ntry, wf4(:,20), wf8(:,26), wf32(:,24), n3(:,129), t3x32(:,:,24))
  call vert_QA_V(ntry, wf4(:,20), ex4, wf8(:,46), n3(:,130), t3x8(:,:,26))
  call vert_VQ_A(ntry, wf8(:,46), wf4(:,5), wf32(:,25), n3(:,131), t3x32(:,:,25))
  call vert_AV_Q(ntry, ex6, wf8(:,46), wf16(:,105), n3(:,132), t3x16(:,:,65))
  call vert_AV_Q(ntry, ex4, wf8(:,45), wf16(:,106), n3(:,133), t3x16(:,:,66))
  call vert_QA_V(ntry, wf8(:,30), wf4(:,17), wf32(:,26), n3(:,134), t3x32(:,:,26))
  call vert_QA_V(ntry, wf8(:,32), wf4(:,17), wf32(:,27), n3(:,135), t3x32(:,:,27))
  call vert_QA_V(ntry, ex3, wf4(:,17), wf8(:,47), n3(:,136), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf8(:,47), wf4(:,5), wf32(:,28), n3(:,137), t3x32(:,:,28))
  call vert_AV_Q(ntry, ex6, wf8(:,47), wf16(:,107), n3(:,138), t3x16(:,:,67))
  call vert_VQ_A(ntry, wf8(:,45), ex3, wf16(:,108), n3(:,139), t3x16(:,:,68))
  call vert_QA_V(ntry, wf4(:,5), wf4(:,6), wf16(:,109), n3(:,140), t3x16(:,:,69))
  call vert_QA_V(ntry, wf8(:,30), ex4, wf16(:,110), n3(:,141), t3x16(:,:,70))
  call vert_QA_V(ntry, wf8(:,32), ex4, wf16(:,111), n3(:,142), t3x16(:,:,71))
  call vert_QA_V(ntry, ex3, wf8(:,23), wf16(:,112), n3(:,143), t3x16(:,:,72))
  call vert_QA_V(ntry, ex3, wf8(:,26), wf16(:,113), n3(:,144), t3x16(:,:,73))
  call vert_QA_V(ntry, wf8(:,4), ex6, wf16(:,114), n3(:,145), t3x16(:,:,74))
  call prop_A_Q(ntry, wf16(:,106), 120, ZERO, 0_intkind1, wf16(:,115), n2(70))
  call prop_Q_A(ntry, wf16(:,108), 116, ZERO, 0_intkind1, wf16(:,116), n2(71))
  call vert_QA_V(ntry, ex5, wf4(:,12), wf8(:,48), n3(:,146), t3x8(:,:,28))
  call vert_VQ_A(ntry, wf8(:,46), wf8(:,10), wf64(:,5), n3(:,147), t3x64(:,:,5))
  call vert_VQ_A(ntry, wf8(:,46), wf8(:,12), wf64(:,6), n3(:,148), t3x64(:,:,6))
  call vert_VQ_A(ntry, wf8(:,46), ex5, wf16(:,117), n3(:,149), t3x16(:,:,75))
  call vert_AV_Q(ntry, ex4, wf8(:,48), wf16(:,118), n3(:,150), t3x16(:,:,76))
  call vert_VQ_A(ntry, wf8(:,47), wf8(:,10), wf64(:,7), n3(:,151), t3x64(:,:,7))
  call vert_VQ_A(ntry, wf8(:,47), wf8(:,12), wf64(:,8), n3(:,152), t3x64(:,:,8))
  call vert_VQ_A(ntry, wf8(:,47), ex5, wf16(:,119), n3(:,153), t3x16(:,:,77))
  call vert_VQ_A(ntry, wf8(:,48), ex3, wf16(:,120), n3(:,154), t3x16(:,:,78))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,12), wf16(:,121), n3(:,155), t3x16(:,:,79))
  call vert_QA_V(ntry, ex5, wf8(:,14), wf16(:,122), n3(:,156), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,118), 120, ZERO, 0_intkind1, wf16(:,123), n2(72))
  call prop_Q_A(ntry, wf16(:,120), 116, ZERO, 0_intkind1, wf16(:,124), n2(73))
  call prop_A_Q(ntry, wf16(:,105), 172, MB, 1_intkind1, wf16(:,125), n2(74))
  call vert_QA_V(ntry, wf8(:,38), ex4, wf16(:,126), n3(:,157), t3x16(:,:,81))
  call prop_Q_A(ntry, wf16(:,117), 156, MB, 1_intkind1, wf16(:,127), n2(75))
  call prop_A_Q(ntry, wf16(:,107), 172, MB, 1_intkind1, wf16(:,128), n2(76))
  call vert_QA_V(ntry, ex3, wf8(:,40), wf16(:,129), n3(:,158), t3x16(:,:,82))
  call prop_Q_A(ntry, wf16(:,119), 156, MB, 1_intkind1, wf16(:,130), n2(77))
  call vert_QA_V(ntry, wf8(:,18), ex6, wf16(:,131), n3(:,159), t3x16(:,:,83))
  call prop_A_Q(ntry, wf16(:,91), 184, ZERO, 0_intkind1, wf16(:,132), n2(78))
  call prop_Q_A(ntry, wf16(:,99), 180, ZERO, 0_intkind1, wf16(:,133), n2(79))
  call vert_QA_V(ntry, ex5, wf8(:,20), wf16(:,134), n3(:,160), t3x16(:,:,84))
  call prop_A_Q(ntry, wf16(:,93), 184, ZERO, 0_intkind1, wf16(:,135), n2(80))
  call prop_Q_A(ntry, wf16(:,101), 180, ZERO, 0_intkind1, wf16(:,136), n2(81))
  call vert_VQ_A(ntry, ex7, ex1, wf4(:,22), n3(:,161), t3x4(:,:,13))
  call vert_AV_Q(ntry, ex2, ex8, wf4(:,23), n3(:,162), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,22), 65, ZERO, 0_intkind1, wf4(:,24), n2(82))
  call prop_A_Q(ntry, wf4(:,23), 130, ZERO, 0_intkind1, wf4(:,25), n2(83))
  call vert_QA_V(ntry, wf4(:,24), wf4(:,25), wf16(:,137), n3(:,163), t3x16(:,:,85))
  call vert_QA_V(ntry, wf8(:,16), ex6, wf16(:,138), n3(:,164), t3x16(:,:,86))
  call vert_QA_Z(gZl,ntry, wf4(:,24), wf4(:,25), wf16(:,139), n3(:,165), t3x16(:,:,87))
  call prop_W_W(ntry, wf16(:,139), 195, MZ, 1_intkind1, wf16(:,140), n2(84))
  call vert_QA_Z(gZd,ntry, wf8(:,16), ex6, wf16(:,141), n3(:,166), t3x16(:,:,88))
  call vert_QA_V(ntry, ex5, wf8(:,8), wf16(:,142), n3(:,167), t3x16(:,:,89))
  call vert_QA_Z(gZd,ntry, ex5, wf8(:,8), wf16(:,143), n3(:,168), t3x16(:,:,90))
  call vert_QA_V(ntry, wf4(:,24), ex2, wf8(:,49), n3(:,169), t3x8(:,:,29))
  call vert_AV_Q(ntry, ex6, wf8(:,49), wf16(:,144), n3(:,170), t3x16(:,:,91))
  call vert_QA_Z(gZl,ntry, wf4(:,24), ex2, wf8(:,50), n3(:,171), t3x8(:,:,30))
  call prop_W_W(ntry, wf8(:,50), 67, MZ, 1_intkind1, wf8(:,51), n2(85))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,51), wf16(:,145), n3(:,172), t3x16(:,:,92))
  call vert_VQ_A(ntry, wf8(:,49), wf4(:,11), wf32(:,29), n3(:,173), t3x32(:,:,29))
  call vert_ZQ_A(gZd,ntry, wf8(:,51), wf4(:,11), wf32(:,30), n3(:,174), t3x32(:,:,30))
  call vert_VQ_A(ntry, wf8(:,49), ex5, wf16(:,146), n3(:,175), t3x16(:,:,93))
  call vert_ZQ_A(gZd,ntry, wf8(:,51), ex5, wf16(:,147), n3(:,176), t3x16(:,:,94))
  call vert_VQ_A(ntry, wf8(:,49), wf8(:,16), wf64(:,9), n3(:,177), t3x64(:,:,9))
  call vert_ZQ_A(gZd,ntry, wf8(:,51), wf8(:,16), wf64(:,10), n3(:,178), t3x64(:,:,10))
  call prop_Q_A(ntry, wf16(:,146), 83, MB, 1_intkind1, wf16(:,148), n2(86))
  call prop_Q_A(ntry, wf16(:,147), 83, MB, 1_intkind1, wf16(:,149), n2(87))
  call prop_A_Q(ntry, wf16(:,144), 99, MB, 1_intkind1, wf16(:,150), n2(88))
  call prop_A_Q(ntry, wf16(:,145), 99, MB, 1_intkind1, wf16(:,151), n2(89))
  call vert_VQ_A(ntry, ex8, wf4(:,24), wf8(:,52), n3(:,179), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,52), 193, ZERO, 0_intkind1, wf8(:,53), n2(90))
  call vert_QA_V(ntry, wf8(:,53), ex2, wf16(:,152), n3(:,180), t3x16(:,:,95))
  call vert_QA_Z(gZl,ntry, wf8(:,53), ex2, wf16(:,153), n3(:,181), t3x16(:,:,96))
  call prop_W_W(ntry, wf16(:,153), 195, MZ, 1_intkind1, wf16(:,154), n2(91))
  call vert_VQ_A(ntry, ex8, ex1, wf4(:,26), n3(:,182), t3x4(:,:,15))
  call vert_AV_Q(ntry, ex2, ex7, wf4(:,27), n3(:,183), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,26), 129, ZERO, 0_intkind1, wf4(:,28), n2(92))
  call prop_A_Q(ntry, wf4(:,27), 66, ZERO, 0_intkind1, wf4(:,29), n2(93))
  call vert_QA_V(ntry, wf4(:,28), wf4(:,29), wf16(:,155), n3(:,184), t3x16(:,:,97))
  call vert_QA_Z(gZl,ntry, wf4(:,28), wf4(:,29), wf16(:,156), n3(:,185), t3x16(:,:,98))
  call prop_W_W(ntry, wf16(:,156), 195, MZ, 1_intkind1, wf16(:,157), n2(94))
  call vert_QA_V(ntry, ex1, wf4(:,29), wf8(:,54), n3(:,186), t3x8(:,:,32))
  call vert_AV_Q(ntry, ex6, wf8(:,54), wf16(:,158), n3(:,187), t3x16(:,:,99))
  call vert_QA_Z(gZl,ntry, ex1, wf4(:,29), wf8(:,55), n3(:,188), t3x8(:,:,33))
  call prop_W_W(ntry, wf8(:,55), 67, MZ, 1_intkind1, wf8(:,56), n2(95))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,56), wf16(:,159), n3(:,189), t3x16(:,:,100))
  call vert_VQ_A(ntry, wf8(:,54), wf4(:,11), wf32(:,31), n3(:,190), t3x32(:,:,31))
  call vert_ZQ_A(gZd,ntry, wf8(:,56), wf4(:,11), wf32(:,32), n3(:,191), t3x32(:,:,32))
  call vert_VQ_A(ntry, wf8(:,54), ex5, wf16(:,160), n3(:,192), t3x16(:,:,101))
  call vert_ZQ_A(gZd,ntry, wf8(:,56), ex5, wf16(:,161), n3(:,193), t3x16(:,:,102))
  call vert_VQ_A(ntry, wf8(:,54), wf8(:,16), wf64(:,11), n3(:,194), t3x64(:,:,11))
  call vert_ZQ_A(gZd,ntry, wf8(:,56), wf8(:,16), wf64(:,12), n3(:,195), t3x64(:,:,12))
  call prop_Q_A(ntry, wf16(:,160), 83, MB, 1_intkind1, wf16(:,162), n2(96))
  call prop_Q_A(ntry, wf16(:,161), 83, MB, 1_intkind1, wf16(:,163), n2(97))
  call prop_A_Q(ntry, wf16(:,158), 99, MB, 1_intkind1, wf16(:,164), n2(98))
  call prop_A_Q(ntry, wf16(:,159), 99, MB, 1_intkind1, wf16(:,165), n2(99))
  call vert_AV_Q(ntry, wf4(:,29), ex8, wf8(:,57), n3(:,196), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,57), 194, ZERO, 0_intkind1, wf8(:,58), n2(100))
  call vert_QA_V(ntry, ex1, wf8(:,58), wf16(:,166), n3(:,197), t3x16(:,:,103))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,58), wf16(:,167), n3(:,198), t3x16(:,:,104))
  call prop_W_W(ntry, wf16(:,167), 195, MZ, 1_intkind1, wf16(:,168), n2(101))
  call vert_QA_V(ntry, wf4(:,28), ex2, wf8(:,59), n3(:,199), t3x8(:,:,35))
  call vert_AV_Q(ntry, ex6, wf8(:,59), wf16(:,169), n3(:,200), t3x16(:,:,105))
  call vert_QA_Z(gZl,ntry, wf4(:,28), ex2, wf8(:,60), n3(:,201), t3x8(:,:,36))
  call prop_W_W(ntry, wf8(:,60), 131, MZ, 1_intkind1, wf8(:,61), n2(102))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,61), wf16(:,170), n3(:,202), t3x16(:,:,106))
  call vert_VQ_A(ntry, wf8(:,59), wf4(:,5), wf32(:,33), n3(:,203), t3x32(:,:,33))
  call vert_ZQ_A(gZd,ntry, wf8(:,61), wf4(:,5), wf32(:,34), n3(:,204), t3x32(:,:,34))
  call vert_QA_V(ntry, ex1, wf4(:,25), wf8(:,62), n3(:,205), t3x8(:,:,37))
  call vert_AV_Q(ntry, ex6, wf8(:,62), wf16(:,171), n3(:,206), t3x16(:,:,107))
  call vert_QA_Z(gZl,ntry, ex1, wf4(:,25), wf8(:,63), n3(:,207), t3x8(:,:,38))
  call prop_W_W(ntry, wf8(:,63), 131, MZ, 1_intkind1, wf8(:,64), n2(103))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,64), wf16(:,172), n3(:,208), t3x16(:,:,108))
  call vert_VQ_A(ntry, wf8(:,62), wf4(:,5), wf32(:,35), n3(:,209), t3x32(:,:,35))
  call vert_ZQ_A(gZd,ntry, wf8(:,64), wf4(:,5), wf32(:,36), n3(:,210), t3x32(:,:,36))
  call vert_VQ_A(ntry, wf8(:,59), ex5, wf16(:,173), n3(:,211), t3x16(:,:,109))
  call vert_ZQ_A(gZd,ntry, wf8(:,61), ex5, wf16(:,174), n3(:,212), t3x16(:,:,110))
  call vert_VQ_A(ntry, wf8(:,59), wf8(:,16), wf64(:,13), n3(:,213), t3x64(:,:,13))
  call vert_ZQ_A(gZd,ntry, wf8(:,61), wf8(:,16), wf64(:,14), n3(:,214), t3x64(:,:,14))
  call vert_VQ_A(ntry, wf8(:,62), ex5, wf16(:,175), n3(:,215), t3x16(:,:,111))
  call vert_ZQ_A(gZd,ntry, wf8(:,64), ex5, wf16(:,176), n3(:,216), t3x16(:,:,112))
  call vert_VQ_A(ntry, wf8(:,62), wf8(:,16), wf64(:,15), n3(:,217), t3x64(:,:,15))
  call vert_ZQ_A(gZd,ntry, wf8(:,64), wf8(:,16), wf64(:,16), n3(:,218), t3x64(:,:,16))
  call prop_Q_A(ntry, wf16(:,173), 147, MB, 1_intkind1, wf16(:,177), n2(104))
  call prop_Q_A(ntry, wf16(:,174), 147, MB, 1_intkind1, wf16(:,178), n2(105))
  call prop_A_Q(ntry, wf16(:,169), 163, MB, 1_intkind1, wf16(:,179), n2(106))
  call prop_A_Q(ntry, wf16(:,170), 163, MB, 1_intkind1, wf16(:,180), n2(107))
  call vert_VQ_A(ntry, ex7, wf4(:,28), wf8(:,65), n3(:,219), t3x8(:,:,39))
  call prop_Q_A(ntry, wf8(:,65), 193, ZERO, 0_intkind1, wf8(:,66), n2(108))
  call vert_QA_V(ntry, wf8(:,66), ex2, wf16(:,181), n3(:,220), t3x16(:,:,113))
  call vert_QA_Z(gZl,ntry, wf8(:,66), ex2, wf16(:,182), n3(:,221), t3x16(:,:,114))
  call prop_W_W(ntry, wf16(:,182), 195, MZ, 1_intkind1, wf16(:,183), n2(109))
  call prop_Q_A(ntry, wf16(:,175), 147, MB, 1_intkind1, wf16(:,184), n2(110))
  call prop_Q_A(ntry, wf16(:,176), 147, MB, 1_intkind1, wf16(:,185), n2(111))
  call prop_A_Q(ntry, wf16(:,171), 163, MB, 1_intkind1, wf16(:,186), n2(112))
  call prop_A_Q(ntry, wf16(:,172), 163, MB, 1_intkind1, wf16(:,187), n2(113))
  call vert_AV_Q(ntry, wf4(:,25), ex7, wf8(:,67), n3(:,222), t3x8(:,:,40))
  call prop_A_Q(ntry, wf8(:,67), 194, ZERO, 0_intkind1, wf8(:,68), n2(114))
  call vert_QA_V(ntry, ex1, wf8(:,68), wf16(:,188), n3(:,223), t3x16(:,:,115))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,68), wf16(:,189), n3(:,224), t3x16(:,:,116))
  call prop_W_W(ntry, wf16(:,189), 195, MZ, 1_intkind1, wf16(:,190), n2(115))
  call vert_QA_V(ntry, wf8(:,36), ex4, wf16(:,191), n3(:,225), t3x16(:,:,117))
  call vert_QA_Z(gZu,ntry, wf8(:,36), ex4, wf16(:,192), n3(:,226), t3x16(:,:,118))
  call vert_QA_V(ntry, ex3, wf8(:,28), wf16(:,193), n3(:,227), t3x16(:,:,119))
  call vert_QA_Z(gZu,ntry, ex3, wf8(:,28), wf16(:,194), n3(:,228), t3x16(:,:,120))
  call vert_AV_Q(ntry, ex4, wf8(:,49), wf16(:,195), n3(:,229), t3x16(:,:,121))
  call vert_AZ_Q(gZu,ntry, ex4, wf8(:,51), wf16(:,196), n3(:,230), t3x16(:,:,122))
  call vert_VQ_A(ntry, wf8(:,49), wf4(:,20), wf32(:,37), n3(:,231), t3x32(:,:,37))
  call vert_ZQ_A(gZu,ntry, wf8(:,51), wf4(:,20), wf32(:,38), n3(:,232), t3x32(:,:,38))
  call vert_VQ_A(ntry, wf8(:,49), ex3, wf16(:,197), n3(:,233), t3x16(:,:,123))
  call vert_ZQ_A(gZu,ntry, wf8(:,51), ex3, wf16(:,198), n3(:,234), t3x16(:,:,124))
  call vert_VQ_A(ntry, wf8(:,49), wf8(:,36), wf64(:,17), n3(:,235), t3x64(:,:,17))
  call vert_ZQ_A(gZu,ntry, wf8(:,51), wf8(:,36), wf64(:,18), n3(:,236), t3x64(:,:,18))
  call prop_Q_A(ntry, wf16(:,197), 71, ZERO, 0_intkind1, wf16(:,199), n2(116))
  call prop_Q_A(ntry, wf16(:,198), 71, ZERO, 0_intkind1, wf16(:,200), n2(117))
  call prop_A_Q(ntry, wf16(:,195), 75, ZERO, 0_intkind1, wf16(:,201), n2(118))
  call prop_A_Q(ntry, wf16(:,196), 75, ZERO, 0_intkind1, wf16(:,202), n2(119))
  call vert_AV_Q(ntry, ex4, wf8(:,54), wf16(:,203), n3(:,237), t3x16(:,:,125))
  call vert_AZ_Q(gZu,ntry, ex4, wf8(:,56), wf16(:,204), n3(:,238), t3x16(:,:,126))
  call vert_VQ_A(ntry, wf8(:,54), wf4(:,20), wf32(:,39), n3(:,239), t3x32(:,:,39))
  call vert_ZQ_A(gZu,ntry, wf8(:,56), wf4(:,20), wf32(:,40), n3(:,240), t3x32(:,:,40))
  call vert_VQ_A(ntry, wf8(:,54), ex3, wf16(:,205), n3(:,241), t3x16(:,:,127))
  call vert_ZQ_A(gZu,ntry, wf8(:,56), ex3, wf16(:,206), n3(:,242), t3x16(:,:,128))
  call vert_VQ_A(ntry, wf8(:,54), wf8(:,36), wf64(:,19), n3(:,243), t3x64(:,:,19))
  call vert_ZQ_A(gZu,ntry, wf8(:,56), wf8(:,36), wf64(:,20), n3(:,244), t3x64(:,:,20))
  call prop_Q_A(ntry, wf16(:,205), 71, ZERO, 0_intkind1, wf16(:,207), n2(120))
  call prop_Q_A(ntry, wf16(:,206), 71, ZERO, 0_intkind1, wf16(:,208), n2(121))
  call prop_A_Q(ntry, wf16(:,203), 75, ZERO, 0_intkind1, wf16(:,209), n2(122))
  call prop_A_Q(ntry, wf16(:,204), 75, ZERO, 0_intkind1, wf16(:,210), n2(123))
  call vert_AV_Q(ntry, ex4, wf8(:,59), wf16(:,211), n3(:,245), t3x16(:,:,129))
  call vert_AZ_Q(gZu,ntry, ex4, wf8(:,61), wf16(:,212), n3(:,246), t3x16(:,:,130))
  call vert_VQ_A(ntry, wf8(:,59), wf4(:,16), wf32(:,41), n3(:,247), t3x32(:,:,41))
  call vert_ZQ_A(gZu,ntry, wf8(:,61), wf4(:,16), wf32(:,42), n3(:,248), t3x32(:,:,42))
  call vert_AV_Q(ntry, ex4, wf8(:,62), wf16(:,213), n3(:,249), t3x16(:,:,131))
  call vert_AZ_Q(gZu,ntry, ex4, wf8(:,64), wf16(:,214), n3(:,250), t3x16(:,:,132))
  call vert_VQ_A(ntry, wf8(:,62), wf4(:,16), wf32(:,43), n3(:,251), t3x32(:,:,43))
  call vert_ZQ_A(gZu,ntry, wf8(:,64), wf4(:,16), wf32(:,44), n3(:,252), t3x32(:,:,44))
  call vert_VQ_A(ntry, wf8(:,59), ex3, wf16(:,215), n3(:,253), t3x16(:,:,133))
  call vert_ZQ_A(gZu,ntry, wf8(:,61), ex3, wf16(:,216), n3(:,254), t3x16(:,:,134))
  call vert_VQ_A(ntry, wf8(:,59), wf8(:,36), wf64(:,21), n3(:,255), t3x64(:,:,21))
  call vert_ZQ_A(gZu,ntry, wf8(:,61), wf8(:,36), wf64(:,22), n3(:,256), t3x64(:,:,22))
  call vert_VQ_A(ntry, wf8(:,62), ex3, wf16(:,217), n3(:,257), t3x16(:,:,135))
  call vert_ZQ_A(gZu,ntry, wf8(:,64), ex3, wf16(:,218), n3(:,258), t3x16(:,:,136))
  call vert_VQ_A(ntry, wf8(:,62), wf8(:,36), wf64(:,23), n3(:,259), t3x64(:,:,23))
  call vert_ZQ_A(gZu,ntry, wf8(:,64), wf8(:,36), wf64(:,24), n3(:,260), t3x64(:,:,24))
  call prop_Q_A(ntry, wf16(:,215), 135, ZERO, 0_intkind1, wf16(:,219), n2(124))
  call prop_Q_A(ntry, wf16(:,216), 135, ZERO, 0_intkind1, wf16(:,220), n2(125))
  call prop_A_Q(ntry, wf16(:,211), 139, ZERO, 0_intkind1, wf16(:,221), n2(126))
  call prop_A_Q(ntry, wf16(:,212), 139, ZERO, 0_intkind1, wf16(:,222), n2(127))
  call prop_Q_A(ntry, wf16(:,217), 135, ZERO, 0_intkind1, wf16(:,223), n2(128))
  call prop_Q_A(ntry, wf16(:,218), 135, ZERO, 0_intkind1, wf16(:,224), n2(129))
  call prop_A_Q(ntry, wf16(:,213), 139, ZERO, 0_intkind1, wf16(:,225), n2(130))
  call prop_A_Q(ntry, wf16(:,214), 139, ZERO, 0_intkind1, wf16(:,226), n2(131))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    M2munu = 0
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppllaaj_eexuuxbbxaa_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllaaj_eexuuxbbxaa_1

  do k = 0, 1-1
    M2(k) = M2add(extcomb_perm_ppllaaj_eexuuxbbxaa_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*8-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf16(:,2), wf16(:,3), A(:,1), n3(:,261), t3x256(:,:,1), nhel, den(9))
    call cont_QA(nsync, wf16(:,2), wf16(:,5), A(:,2), n3(:,262), t3x256(:,:,2), nhel, den(13))
    call cont_QA(nsync, wf16(:,7), wf16(:,8), A(:,3), n3(:,263), t3x256(:,:,3), nhel, den(18))
    call cont_QA(nsync, wf16(:,7), wf16(:,10), A(:,4), n3(:,264), t3x256(:,:,4), nhel, den(21))
    call cont_QA(nsync, wf8(:,4), wf32(:,1), A(:,5), n3(:,265), t3x256(:,:,5), nhel, den(27))
    call cont_QA(nsync, wf8(:,4), wf32(:,2), A(:,6), n3(:,266), t3x256(:,:,6), nhel, den(30))
    call cont_QA(nsync, wf16(:,11), wf16(:,12), A(:,7), n3(:,267), t3x256(:,:,7), nhel, den(33))
    call cont_QA(nsync, wf16(:,11), wf16(:,13), A(:,8), n3(:,268), t3x256(:,:,8), nhel, den(34))
    call cont_QA(nsync, wf8(:,4), wf32(:,3), A(:,9), n3(:,269), t3x256(:,:,9), nhel, den(38))
    call cont_QA(nsync, wf8(:,4), wf32(:,4), A(:,10), n3(:,270), t3x256(:,:,10), nhel, den(40))
    call cont_QA(nsync, wf16(:,3), wf16(:,14), A(:,11), n3(:,271), t3x256(:,:,11), nhel, den(41))
    call cont_QA(nsync, wf16(:,5), wf16(:,14), A(:,12), n3(:,272), t3x256(:,:,12), nhel, den(42))
    call cont_QA(nsync, wf16(:,16), wf16(:,17), A(:,13), n3(:,273), t3x256(:,:,13), nhel, den(49))
    call cont_QA(nsync, wf16(:,16), wf16(:,19), A(:,14), n3(:,274), t3x256(:,:,14), nhel, den(52))
    call cont_QA(nsync, wf16(:,21), wf16(:,22), A(:,15), n3(:,275), t3x256(:,:,15), nhel, den(57))
    call cont_QA(nsync, wf16(:,21), wf16(:,24), A(:,16), n3(:,276), t3x256(:,:,16), nhel, den(60))
    call cont_QA(nsync, wf16(:,25), wf16(:,26), A(:,17), n3(:,277), t3x256(:,:,17), nhel, den(65))
    call cont_QA(nsync, wf16(:,25), wf16(:,27), A(:,18), n3(:,278), t3x256(:,:,18), nhel, den(67))
    call cont_QA(nsync, wf8(:,14), wf32(:,5), A(:,19), n3(:,279), t3x256(:,:,19), nhel, den(71))
    call cont_QA(nsync, wf8(:,14), wf32(:,6), A(:,20), n3(:,280), t3x256(:,:,20), nhel, den(73))
    call cont_QA(nsync, wf16(:,22), wf16(:,28), A(:,21), n3(:,281), t3x256(:,:,21), nhel, den(76))
    call cont_QA(nsync, wf16(:,24), wf16(:,28), A(:,22), n3(:,282), t3x256(:,:,22), nhel, den(77))
    call cont_QA(nsync, wf8(:,14), wf32(:,7), A(:,23), n3(:,283), t3x256(:,:,23), nhel, den(79))
    call cont_QA(nsync, wf8(:,14), wf32(:,8), A(:,24), n3(:,284), t3x256(:,:,24), nhel, den(81))
    call cont_QA(nsync, wf32(:,1), wf8(:,18), A(:,25), n3(:,285), t3x256(:,:,25), nhel, den(83))
    call cont_QA(nsync, wf32(:,2), wf8(:,18), A(:,26), n3(:,286), t3x256(:,:,26), nhel, den(84))
    call cont_QA(nsync, wf16(:,29), wf16(:,30), A(:,27), n3(:,287), t3x256(:,:,27), nhel, den(87))
    call cont_QA(nsync, wf16(:,29), wf16(:,31), A(:,28), n3(:,288), t3x256(:,:,28), nhel, den(88))
    call cont_QA(nsync, wf32(:,3), wf8(:,18), A(:,29), n3(:,289), t3x256(:,:,29), nhel, den(89))
    call cont_QA(nsync, wf32(:,4), wf8(:,18), A(:,30), n3(:,290), t3x256(:,:,30), nhel, den(90))
    call cont_QA(nsync, wf16(:,17), wf16(:,32), A(:,31), n3(:,291), t3x256(:,:,31), nhel, den(91))
    call cont_QA(nsync, wf16(:,19), wf16(:,32), A(:,32), n3(:,292), t3x256(:,:,32), nhel, den(92))
    call cont_QA(nsync, wf16(:,33), wf16(:,34), A(:,33), n3(:,293), t3x256(:,:,33), nhel, den(95))
    call cont_QA(nsync, wf16(:,33), wf16(:,35), A(:,34), n3(:,294), t3x256(:,:,34), nhel, den(96))
    call cont_QA(nsync, wf32(:,5), wf8(:,20), A(:,35), n3(:,295), t3x256(:,:,35), nhel, den(98))
    call cont_QA(nsync, wf32(:,6), wf8(:,20), A(:,36), n3(:,296), t3x256(:,:,36), nhel, den(99))
    call cont_QA(nsync, wf16(:,8), wf16(:,36), A(:,37), n3(:,297), t3x256(:,:,37), nhel, den(100))
    call cont_QA(nsync, wf16(:,10), wf16(:,36), A(:,38), n3(:,298), t3x256(:,:,38), nhel, den(101))
    call cont_QA(nsync, wf32(:,7), wf8(:,20), A(:,39), n3(:,299), t3x256(:,:,39), nhel, den(102))
    call cont_QA(nsync, wf32(:,8), wf8(:,20), A(:,40), n3(:,300), t3x256(:,:,40), nhel, den(103))
    call cont_QA(nsync, wf16(:,14), wf16(:,37), A(:,41), n3(:,301), t3x256(:,:,41), nhel, den(105))
    call cont_QA(nsync, wf16(:,14), wf16(:,38), A(:,42), n3(:,302), t3x256(:,:,42), nhel, den(107))
    call cont_QA(nsync, wf16(:,26), wf16(:,39), A(:,43), n3(:,303), t3x256(:,:,43), nhel, den(109))
    call cont_QA(nsync, wf16(:,27), wf16(:,39), A(:,44), n3(:,304), t3x256(:,:,44), nhel, den(110))
    call cont_QA(nsync, wf16(:,12), wf16(:,40), A(:,45), n3(:,305), t3x256(:,:,45), nhel, den(112))
    call cont_QA(nsync, wf16(:,13), wf16(:,40), A(:,46), n3(:,306), t3x256(:,:,46), nhel, den(113))
    call cont_QA(nsync, wf16(:,28), wf16(:,41), A(:,47), n3(:,307), t3x256(:,:,47), nhel, den(115))
    call cont_QA(nsync, wf16(:,28), wf16(:,42), A(:,48), n3(:,308), t3x256(:,:,48), nhel, den(117))
    call cont_QA(nsync, wf16(:,44), wf16(:,45), A(:,49), n3(:,309), t3x256(:,:,49), nhel, den(125))
    call cont_QA(nsync, wf16(:,44), wf16(:,47), A(:,50), n3(:,310), t3x256(:,:,50), nhel, den(128))
    call cont_QA(nsync, wf16(:,49), wf16(:,50), A(:,51), n3(:,311), t3x256(:,:,51), nhel, den(133))
    call cont_QA(nsync, wf16(:,49), wf16(:,52), A(:,52), n3(:,312), t3x256(:,:,52), nhel, den(136))
    call cont_QA(nsync, wf8(:,24), wf32(:,9), A(:,53), n3(:,313), t3x256(:,:,53), nhel, den(142))
    call cont_QA(nsync, wf8(:,24), wf32(:,10), A(:,54), n3(:,314), t3x256(:,:,54), nhel, den(145))
    call cont_QA(nsync, wf16(:,53), wf16(:,54), A(:,55), n3(:,315), t3x256(:,:,55), nhel, den(148))
    call cont_QA(nsync, wf16(:,53), wf16(:,55), A(:,56), n3(:,316), t3x256(:,:,56), nhel, den(149))
    call cont_QA(nsync, wf8(:,24), wf32(:,11), A(:,57), n3(:,317), t3x256(:,:,57), nhel, den(153))
    call cont_QA(nsync, wf8(:,24), wf32(:,12), A(:,58), n3(:,318), t3x256(:,:,58), nhel, den(155))
    call cont_QA(nsync, wf16(:,45), wf16(:,56), A(:,59), n3(:,319), t3x256(:,:,59), nhel, den(156))
    call cont_QA(nsync, wf16(:,47), wf16(:,56), A(:,60), n3(:,320), t3x256(:,:,60), nhel, den(157))
    call cont_QA(nsync, wf16(:,58), wf16(:,59), A(:,61), n3(:,321), t3x256(:,:,61), nhel, den(164))
    call cont_QA(nsync, wf16(:,58), wf16(:,61), A(:,62), n3(:,322), t3x256(:,:,62), nhel, den(167))
    call cont_QA(nsync, wf16(:,63), wf16(:,64), A(:,63), n3(:,323), t3x256(:,:,63), nhel, den(172))
    call cont_QA(nsync, wf16(:,63), wf16(:,66), A(:,64), n3(:,324), t3x256(:,:,64), nhel, den(175))
    call cont_QA(nsync, wf16(:,67), wf16(:,68), A(:,65), n3(:,325), t3x256(:,:,65), nhel, den(180))
    call cont_QA(nsync, wf16(:,67), wf16(:,69), A(:,66), n3(:,326), t3x256(:,:,66), nhel, den(182))
    call cont_QA(nsync, wf8(:,34), wf32(:,13), A(:,67), n3(:,327), t3x256(:,:,67), nhel, den(186))
    call cont_QA(nsync, wf8(:,34), wf32(:,14), A(:,68), n3(:,328), t3x256(:,:,68), nhel, den(188))
    call cont_QA(nsync, wf16(:,64), wf16(:,70), A(:,69), n3(:,329), t3x256(:,:,69), nhel, den(191))
    call cont_QA(nsync, wf16(:,66), wf16(:,70), A(:,70), n3(:,330), t3x256(:,:,70), nhel, den(192))
    call cont_QA(nsync, wf8(:,34), wf32(:,15), A(:,71), n3(:,331), t3x256(:,:,71), nhel, den(194))
    call cont_QA(nsync, wf8(:,34), wf32(:,16), A(:,72), n3(:,332), t3x256(:,:,72), nhel, den(196))
    call cont_QA(nsync, wf32(:,9), wf8(:,38), A(:,73), n3(:,333), t3x256(:,:,73), nhel, den(198))
    call cont_QA(nsync, wf32(:,10), wf8(:,38), A(:,74), n3(:,334), t3x256(:,:,74), nhel, den(199))
    call cont_QA(nsync, wf16(:,71), wf16(:,72), A(:,75), n3(:,335), t3x256(:,:,75), nhel, den(202))
    call cont_QA(nsync, wf16(:,71), wf16(:,73), A(:,76), n3(:,336), t3x256(:,:,76), nhel, den(203))
    call cont_QA(nsync, wf32(:,11), wf8(:,38), A(:,77), n3(:,337), t3x256(:,:,77), nhel, den(204))
    call cont_QA(nsync, wf32(:,12), wf8(:,38), A(:,78), n3(:,338), t3x256(:,:,78), nhel, den(205))
    call cont_QA(nsync, wf16(:,59), wf16(:,74), A(:,79), n3(:,339), t3x256(:,:,79), nhel, den(206))
    call cont_QA(nsync, wf16(:,61), wf16(:,74), A(:,80), n3(:,340), t3x256(:,:,80), nhel, den(207))
    call cont_QA(nsync, wf16(:,75), wf16(:,76), A(:,81), n3(:,341), t3x256(:,:,81), nhel, den(210))
    call cont_QA(nsync, wf16(:,75), wf16(:,77), A(:,82), n3(:,342), t3x256(:,:,82), nhel, den(211))
    call cont_QA(nsync, wf32(:,13), wf8(:,40), A(:,83), n3(:,343), t3x256(:,:,83), nhel, den(213))
    call cont_QA(nsync, wf32(:,14), wf8(:,40), A(:,84), n3(:,344), t3x256(:,:,84), nhel, den(214))
    call cont_QA(nsync, wf16(:,50), wf16(:,78), A(:,85), n3(:,345), t3x256(:,:,85), nhel, den(215))
    call cont_QA(nsync, wf16(:,52), wf16(:,78), A(:,86), n3(:,346), t3x256(:,:,86), nhel, den(216))
    call cont_QA(nsync, wf32(:,15), wf8(:,40), A(:,87), n3(:,347), t3x256(:,:,87), nhel, den(217))
    call cont_QA(nsync, wf32(:,16), wf8(:,40), A(:,88), n3(:,348), t3x256(:,:,88), nhel, den(218))
    call cont_QA(nsync, wf16(:,56), wf16(:,79), A(:,89), n3(:,349), t3x256(:,:,89), nhel, den(220))
    call cont_QA(nsync, wf16(:,56), wf16(:,80), A(:,90), n3(:,350), t3x256(:,:,90), nhel, den(222))
    call cont_QA(nsync, wf16(:,68), wf16(:,81), A(:,91), n3(:,351), t3x256(:,:,91), nhel, den(224))
    call cont_QA(nsync, wf16(:,69), wf16(:,81), A(:,92), n3(:,352), t3x256(:,:,92), nhel, den(225))
    call cont_QA(nsync, wf16(:,54), wf16(:,82), A(:,93), n3(:,353), t3x256(:,:,93), nhel, den(227))
    call cont_QA(nsync, wf16(:,55), wf16(:,82), A(:,94), n3(:,354), t3x256(:,:,94), nhel, den(228))
    call cont_QA(nsync, wf16(:,70), wf16(:,83), A(:,95), n3(:,355), t3x256(:,:,95), nhel, den(230))
    call cont_QA(nsync, wf16(:,70), wf16(:,84), A(:,96), n3(:,356), t3x256(:,:,96), nhel, den(232))
    call cont_VV(nsync, wf16(:,85), wf16(:,86), A(:,97), n3(:,357), t3x256(:,:,97), nhel, den(236))
    call cont_VV(nsync, wf16(:,85), wf16(:,87), A(:,98), n3(:,358), t3x256(:,:,98), nhel, den(237))
    call cont_VV(nsync, wf16(:,85), wf16(:,88), A(:,99), n3(:,359), t3x256(:,:,99), nhel, den(238))
    call cont_VV(nsync, wf16(:,85), wf16(:,89), A(:,100), n3(:,360), t3x256(:,:,100), nhel, den(239))
    call cont_VV(nsync, wf8(:,41), wf32(:,17), A(:,101), n3(:,361), t3x256(:,:,101), nhel, den(243))
    call cont_VV(nsync, wf8(:,41), wf32(:,18), A(:,102), n3(:,362), t3x256(:,:,102), nhel, den(245))
    call cont_QA(nsync, wf8(:,3), wf32(:,19), A(:,103), n3(:,363), t3x256(:,:,103), nhel, den(249))
    call cont_QA(nsync, wf8(:,6), wf32(:,19), A(:,104), n3(:,364), t3x256(:,:,104), nhel, den(250))
    call cont_QA(nsync, wf16(:,17), wf16(:,90), A(:,105), n3(:,365), t3x256(:,:,105), nhel, den(251))
    call cont_QA(nsync, wf16(:,19), wf16(:,90), A(:,106), n3(:,366), t3x256(:,:,106), nhel, den(252))
    call cont_QA(nsync, wf16(:,45), wf16(:,91), A(:,107), n3(:,367), t3x256(:,:,107), nhel, den(253))
    call cont_QA(nsync, wf16(:,47), wf16(:,91), A(:,108), n3(:,368), t3x256(:,:,108), nhel, den(254))
    call cont_VV(nsync, wf32(:,17), wf8(:,43), A(:,109), n3(:,369), t3x256(:,:,109), nhel, den(256))
    call cont_VV(nsync, wf32(:,18), wf8(:,43), A(:,110), n3(:,370), t3x256(:,:,110), nhel, den(257))
    call cont_QA(nsync, wf4(:,6), wf64(:,1), A(:,111), n3(:,371), t3x256(:,:,111), nhel, den(259))
    call cont_QA(nsync, wf4(:,6), wf64(:,2), A(:,112), n3(:,372), t3x256(:,:,112), nhel, den(261))
    call cont_QA(nsync, wf16(:,8), wf16(:,92), A(:,113), n3(:,373), t3x256(:,:,113), nhel, den(262))
    call cont_QA(nsync, wf16(:,10), wf16(:,92), A(:,114), n3(:,374), t3x256(:,:,114), nhel, den(263))
    call cont_QA(nsync, wf16(:,45), wf16(:,93), A(:,115), n3(:,375), t3x256(:,:,115), nhel, den(264))
    call cont_QA(nsync, wf16(:,47), wf16(:,93), A(:,116), n3(:,376), t3x256(:,:,116), nhel, den(265))
    call cont_QA(nsync, wf16(:,26), wf16(:,94), A(:,117), n3(:,377), t3x256(:,:,117), nhel, den(267))
    call cont_QA(nsync, wf16(:,27), wf16(:,94), A(:,118), n3(:,378), t3x256(:,:,118), nhel, den(268))
    call cont_VV(nsync, wf16(:,86), wf16(:,95), A(:,119), n3(:,379), t3x256(:,:,119), nhel, den(270))
    call cont_VV(nsync, wf16(:,87), wf16(:,95), A(:,120), n3(:,380), t3x256(:,:,120), nhel, den(271))
    call cont_QA(nsync, wf16(:,12), wf16(:,96), A(:,121), n3(:,381), t3x256(:,:,121), nhel, den(273))
    call cont_QA(nsync, wf16(:,13), wf16(:,96), A(:,122), n3(:,382), t3x256(:,:,122), nhel, den(274))
    call cont_VV(nsync, wf16(:,88), wf16(:,95), A(:,123), n3(:,383), t3x256(:,:,123), nhel, den(275))
    call cont_VV(nsync, wf16(:,89), wf16(:,95), A(:,124), n3(:,384), t3x256(:,:,124), nhel, den(276))
    call cont_VV(nsync, wf16(:,86), wf16(:,97), A(:,125), n3(:,385), t3x256(:,:,125), nhel, den(279))
    call cont_VV(nsync, wf16(:,87), wf16(:,97), A(:,126), n3(:,386), t3x256(:,:,126), nhel, den(280))
    call cont_VV(nsync, wf16(:,88), wf16(:,97), A(:,127), n3(:,387), t3x256(:,:,127), nhel, den(281))
    call cont_VV(nsync, wf16(:,89), wf16(:,97), A(:,128), n3(:,388), t3x256(:,:,128), nhel, den(282))
    call cont_VV(nsync, wf8(:,41), wf32(:,20), A(:,129), n3(:,389), t3x256(:,:,129), nhel, den(284))
    call cont_VV(nsync, wf8(:,41), wf32(:,21), A(:,130), n3(:,390), t3x256(:,:,130), nhel, den(286))
    call cont_QA(nsync, wf8(:,3), wf32(:,22), A(:,131), n3(:,391), t3x256(:,:,131), nhel, den(289))
    call cont_QA(nsync, wf8(:,6), wf32(:,22), A(:,132), n3(:,392), t3x256(:,:,132), nhel, den(290))
    call cont_QA(nsync, wf16(:,17), wf16(:,98), A(:,133), n3(:,393), t3x256(:,:,133), nhel, den(291))
    call cont_QA(nsync, wf16(:,19), wf16(:,98), A(:,134), n3(:,394), t3x256(:,:,134), nhel, den(292))
    call cont_QA(nsync, wf16(:,64), wf16(:,99), A(:,135), n3(:,395), t3x256(:,:,135), nhel, den(293))
    call cont_QA(nsync, wf16(:,66), wf16(:,99), A(:,136), n3(:,396), t3x256(:,:,136), nhel, den(294))
    call cont_VV(nsync, wf8(:,43), wf32(:,20), A(:,137), n3(:,397), t3x256(:,:,137), nhel, den(295))
    call cont_VV(nsync, wf8(:,43), wf32(:,21), A(:,138), n3(:,398), t3x256(:,:,138), nhel, den(296))
    call cont_QA(nsync, wf4(:,6), wf64(:,3), A(:,139), n3(:,399), t3x256(:,:,139), nhel, den(298))
    call cont_QA(nsync, wf4(:,6), wf64(:,4), A(:,140), n3(:,400), t3x256(:,:,140), nhel, den(300))
    call cont_QA(nsync, wf16(:,8), wf16(:,100), A(:,141), n3(:,401), t3x256(:,:,141), nhel, den(301))
    call cont_QA(nsync, wf16(:,10), wf16(:,100), A(:,142), n3(:,402), t3x256(:,:,142), nhel, den(302))
    call cont_QA(nsync, wf16(:,64), wf16(:,101), A(:,143), n3(:,403), t3x256(:,:,143), nhel, den(303))
    call cont_QA(nsync, wf16(:,66), wf16(:,101), A(:,144), n3(:,404), t3x256(:,:,144), nhel, den(304))
    call cont_QA(nsync, wf16(:,26), wf16(:,102), A(:,145), n3(:,405), t3x256(:,:,145), nhel, den(306))
    call cont_QA(nsync, wf16(:,27), wf16(:,102), A(:,146), n3(:,406), t3x256(:,:,146), nhel, den(307))
    call cont_VV(nsync, wf16(:,86), wf16(:,103), A(:,147), n3(:,407), t3x256(:,:,147), nhel, den(309))
    call cont_VV(nsync, wf16(:,87), wf16(:,103), A(:,148), n3(:,408), t3x256(:,:,148), nhel, den(310))
    call cont_QA(nsync, wf16(:,12), wf16(:,104), A(:,149), n3(:,409), t3x256(:,:,149), nhel, den(312))
    call cont_QA(nsync, wf16(:,13), wf16(:,104), A(:,150), n3(:,410), t3x256(:,:,150), nhel, den(313))
    call cont_VV(nsync, wf16(:,88), wf16(:,103), A(:,151), n3(:,411), t3x256(:,:,151), nhel, den(314))
    call cont_VV(nsync, wf16(:,89), wf16(:,103), A(:,152), n3(:,412), t3x256(:,:,152), nhel, den(315))
    call cont_VV(nsync, wf8(:,45), wf32(:,23), A(:,153), n3(:,413), t3x256(:,:,153), nhel, den(319))
    call cont_VV(nsync, wf8(:,45), wf32(:,24), A(:,154), n3(:,414), t3x256(:,:,154), nhel, den(321))
    call cont_QA(nsync, wf8(:,3), wf32(:,25), A(:,155), n3(:,415), t3x256(:,:,155), nhel, den(325))
    call cont_QA(nsync, wf8(:,6), wf32(:,25), A(:,156), n3(:,416), t3x256(:,:,156), nhel, den(326))
    call cont_QA(nsync, wf16(:,3), wf16(:,105), A(:,157), n3(:,417), t3x256(:,:,157), nhel, den(327))
    call cont_QA(nsync, wf16(:,5), wf16(:,105), A(:,158), n3(:,418), t3x256(:,:,158), nhel, den(328))
    call cont_QA(nsync, wf16(:,59), wf16(:,106), A(:,159), n3(:,419), t3x256(:,:,159), nhel, den(329))
    call cont_QA(nsync, wf16(:,61), wf16(:,106), A(:,160), n3(:,420), t3x256(:,:,160), nhel, den(330))
    call cont_VV(nsync, wf8(:,45), wf32(:,26), A(:,161), n3(:,421), t3x256(:,:,161), nhel, den(332))
    call cont_VV(nsync, wf8(:,45), wf32(:,27), A(:,162), n3(:,422), t3x256(:,:,162), nhel, den(334))
    call cont_QA(nsync, wf8(:,3), wf32(:,28), A(:,163), n3(:,423), t3x256(:,:,163), nhel, den(337))
    call cont_QA(nsync, wf8(:,6), wf32(:,28), A(:,164), n3(:,424), t3x256(:,:,164), nhel, den(338))
    call cont_QA(nsync, wf16(:,3), wf16(:,107), A(:,165), n3(:,425), t3x256(:,:,165), nhel, den(339))
    call cont_QA(nsync, wf16(:,5), wf16(:,107), A(:,166), n3(:,426), t3x256(:,:,166), nhel, den(340))
    call cont_QA(nsync, wf16(:,50), wf16(:,108), A(:,167), n3(:,427), t3x256(:,:,167), nhel, den(341))
    call cont_QA(nsync, wf16(:,52), wf16(:,108), A(:,168), n3(:,428), t3x256(:,:,168), nhel, den(342))
    call cont_VV(nsync, wf16(:,109), wf16(:,110), A(:,169), n3(:,429), t3x256(:,:,169), nhel, den(346))
    call cont_VV(nsync, wf16(:,109), wf16(:,111), A(:,170), n3(:,430), t3x256(:,:,170), nhel, den(347))
    call cont_VV(nsync, wf16(:,109), wf16(:,112), A(:,171), n3(:,431), t3x256(:,:,171), nhel, den(348))
    call cont_VV(nsync, wf16(:,109), wf16(:,113), A(:,172), n3(:,432), t3x256(:,:,172), nhel, den(349))
    call cont_VV(nsync, wf16(:,110), wf16(:,114), A(:,173), n3(:,433), t3x256(:,:,173), nhel, den(352))
    call cont_VV(nsync, wf16(:,111), wf16(:,114), A(:,174), n3(:,434), t3x256(:,:,174), nhel, den(354))
    call cont_QA(nsync, wf16(:,68), wf16(:,115), A(:,175), n3(:,435), t3x256(:,:,175), nhel, den(356))
    call cont_QA(nsync, wf16(:,69), wf16(:,115), A(:,176), n3(:,436), t3x256(:,:,176), nhel, den(357))
    call cont_VV(nsync, wf16(:,112), wf16(:,114), A(:,177), n3(:,437), t3x256(:,:,177), nhel, den(359))
    call cont_VV(nsync, wf16(:,113), wf16(:,114), A(:,178), n3(:,438), t3x256(:,:,178), nhel, den(361))
    call cont_QA(nsync, wf16(:,54), wf16(:,116), A(:,179), n3(:,439), t3x256(:,:,179), nhel, den(363))
    call cont_QA(nsync, wf16(:,55), wf16(:,116), A(:,180), n3(:,440), t3x256(:,:,180), nhel, den(364))
    call cont_VV(nsync, wf32(:,23), wf8(:,48), A(:,181), n3(:,441), t3x256(:,:,181), nhel, den(366))
    call cont_VV(nsync, wf32(:,24), wf8(:,48), A(:,182), n3(:,442), t3x256(:,:,182), nhel, den(367))
    call cont_QA(nsync, wf4(:,12), wf64(:,5), A(:,183), n3(:,443), t3x256(:,:,183), nhel, den(369))
    call cont_QA(nsync, wf4(:,12), wf64(:,6), A(:,184), n3(:,444), t3x256(:,:,184), nhel, den(371))
    call cont_QA(nsync, wf16(:,22), wf16(:,117), A(:,185), n3(:,445), t3x256(:,:,185), nhel, den(372))
    call cont_QA(nsync, wf16(:,24), wf16(:,117), A(:,186), n3(:,446), t3x256(:,:,186), nhel, den(373))
    call cont_QA(nsync, wf16(:,59), wf16(:,118), A(:,187), n3(:,447), t3x256(:,:,187), nhel, den(374))
    call cont_QA(nsync, wf16(:,61), wf16(:,118), A(:,188), n3(:,448), t3x256(:,:,188), nhel, den(375))
    call cont_VV(nsync, wf32(:,26), wf8(:,48), A(:,189), n3(:,449), t3x256(:,:,189), nhel, den(376))
    call cont_VV(nsync, wf32(:,27), wf8(:,48), A(:,190), n3(:,450), t3x256(:,:,190), nhel, den(377))
    call cont_QA(nsync, wf4(:,12), wf64(:,7), A(:,191), n3(:,451), t3x256(:,:,191), nhel, den(379))
    call cont_QA(nsync, wf4(:,12), wf64(:,8), A(:,192), n3(:,452), t3x256(:,:,192), nhel, den(381))
    call cont_QA(nsync, wf16(:,22), wf16(:,119), A(:,193), n3(:,453), t3x256(:,:,193), nhel, den(382))
    call cont_QA(nsync, wf16(:,24), wf16(:,119), A(:,194), n3(:,454), t3x256(:,:,194), nhel, den(383))
    call cont_QA(nsync, wf16(:,50), wf16(:,120), A(:,195), n3(:,455), t3x256(:,:,195), nhel, den(384))
    call cont_QA(nsync, wf16(:,52), wf16(:,120), A(:,196), n3(:,456), t3x256(:,:,196), nhel, den(385))
    call cont_VV(nsync, wf16(:,110), wf16(:,121), A(:,197), n3(:,457), t3x256(:,:,197), nhel, den(388))
    call cont_VV(nsync, wf16(:,111), wf16(:,121), A(:,198), n3(:,458), t3x256(:,:,198), nhel, den(389))
    call cont_VV(nsync, wf16(:,112), wf16(:,121), A(:,199), n3(:,459), t3x256(:,:,199), nhel, den(390))
    call cont_VV(nsync, wf16(:,113), wf16(:,121), A(:,200), n3(:,460), t3x256(:,:,200), nhel, den(391))
    call cont_VV(nsync, wf16(:,110), wf16(:,122), A(:,201), n3(:,461), t3x256(:,:,201), nhel, den(392))
    call cont_VV(nsync, wf16(:,111), wf16(:,122), A(:,202), n3(:,462), t3x256(:,:,202), nhel, den(393))
    call cont_QA(nsync, wf16(:,68), wf16(:,123), A(:,203), n3(:,463), t3x256(:,:,203), nhel, den(395))
    call cont_QA(nsync, wf16(:,69), wf16(:,123), A(:,204), n3(:,464), t3x256(:,:,204), nhel, den(396))
    call cont_VV(nsync, wf16(:,112), wf16(:,122), A(:,205), n3(:,465), t3x256(:,:,205), nhel, den(397))
    call cont_VV(nsync, wf16(:,113), wf16(:,122), A(:,206), n3(:,466), t3x256(:,:,206), nhel, den(398))
    call cont_QA(nsync, wf16(:,54), wf16(:,124), A(:,207), n3(:,467), t3x256(:,:,207), nhel, den(400))
    call cont_QA(nsync, wf16(:,55), wf16(:,124), A(:,208), n3(:,468), t3x256(:,:,208), nhel, den(401))
    call cont_QA(nsync, wf16(:,34), wf16(:,125), A(:,209), n3(:,469), t3x256(:,:,209), nhel, den(403))
    call cont_QA(nsync, wf16(:,35), wf16(:,125), A(:,210), n3(:,470), t3x256(:,:,210), nhel, den(404))
    call cont_VV(nsync, wf16(:,86), wf16(:,126), A(:,211), n3(:,471), t3x256(:,:,211), nhel, den(406))
    call cont_VV(nsync, wf16(:,87), wf16(:,126), A(:,212), n3(:,472), t3x256(:,:,212), nhel, den(407))
    call cont_QA(nsync, wf16(:,30), wf16(:,127), A(:,213), n3(:,473), t3x256(:,:,213), nhel, den(409))
    call cont_QA(nsync, wf16(:,31), wf16(:,127), A(:,214), n3(:,474), t3x256(:,:,214), nhel, den(410))
    call cont_VV(nsync, wf16(:,88), wf16(:,126), A(:,215), n3(:,475), t3x256(:,:,215), nhel, den(411))
    call cont_VV(nsync, wf16(:,89), wf16(:,126), A(:,216), n3(:,476), t3x256(:,:,216), nhel, den(412))
    call cont_QA(nsync, wf16(:,34), wf16(:,128), A(:,217), n3(:,477), t3x256(:,:,217), nhel, den(414))
    call cont_QA(nsync, wf16(:,35), wf16(:,128), A(:,218), n3(:,478), t3x256(:,:,218), nhel, den(415))
    call cont_VV(nsync, wf16(:,86), wf16(:,129), A(:,219), n3(:,479), t3x256(:,:,219), nhel, den(417))
    call cont_VV(nsync, wf16(:,87), wf16(:,129), A(:,220), n3(:,480), t3x256(:,:,220), nhel, den(418))
    call cont_QA(nsync, wf16(:,30), wf16(:,130), A(:,221), n3(:,481), t3x256(:,:,221), nhel, den(420))
    call cont_QA(nsync, wf16(:,31), wf16(:,130), A(:,222), n3(:,482), t3x256(:,:,222), nhel, den(421))
    call cont_VV(nsync, wf16(:,88), wf16(:,129), A(:,223), n3(:,483), t3x256(:,:,223), nhel, den(422))
    call cont_VV(nsync, wf16(:,89), wf16(:,129), A(:,224), n3(:,484), t3x256(:,:,224), nhel, den(423))
    call cont_VV(nsync, wf16(:,110), wf16(:,131), A(:,225), n3(:,485), t3x256(:,:,225), nhel, den(424))
    call cont_VV(nsync, wf16(:,111), wf16(:,131), A(:,226), n3(:,486), t3x256(:,:,226), nhel, den(425))
    call cont_QA(nsync, wf16(:,76), wf16(:,132), A(:,227), n3(:,487), t3x256(:,:,227), nhel, den(427))
    call cont_QA(nsync, wf16(:,77), wf16(:,132), A(:,228), n3(:,488), t3x256(:,:,228), nhel, den(428))
    call cont_VV(nsync, wf16(:,112), wf16(:,131), A(:,229), n3(:,489), t3x256(:,:,229), nhel, den(429))
    call cont_VV(nsync, wf16(:,113), wf16(:,131), A(:,230), n3(:,490), t3x256(:,:,230), nhel, den(430))
    call cont_QA(nsync, wf16(:,72), wf16(:,133), A(:,231), n3(:,491), t3x256(:,:,231), nhel, den(432))
    call cont_QA(nsync, wf16(:,73), wf16(:,133), A(:,232), n3(:,492), t3x256(:,:,232), nhel, den(433))
    call cont_VV(nsync, wf16(:,110), wf16(:,134), A(:,233), n3(:,493), t3x256(:,:,233), nhel, den(434))
    call cont_VV(nsync, wf16(:,111), wf16(:,134), A(:,234), n3(:,494), t3x256(:,:,234), nhel, den(435))
    call cont_QA(nsync, wf16(:,76), wf16(:,135), A(:,235), n3(:,495), t3x256(:,:,235), nhel, den(437))
    call cont_QA(nsync, wf16(:,77), wf16(:,135), A(:,236), n3(:,496), t3x256(:,:,236), nhel, den(438))
    call cont_VV(nsync, wf16(:,112), wf16(:,134), A(:,237), n3(:,497), t3x256(:,:,237), nhel, den(439))
    call cont_VV(nsync, wf16(:,113), wf16(:,134), A(:,238), n3(:,498), t3x256(:,:,238), nhel, den(440))
    call cont_QA(nsync, wf16(:,72), wf16(:,136), A(:,239), n3(:,499), t3x256(:,:,239), nhel, den(442))
    call cont_QA(nsync, wf16(:,73), wf16(:,136), A(:,240), n3(:,500), t3x256(:,:,240), nhel, den(443))
    call cont_VV(nsync, wf16(:,137), wf16(:,138), A(:,241), n3(:,501), t3x256(:,:,241), nhel, den(449))
    call cont_VV(nsync, wf16(:,140), wf16(:,141), A(:,242), n3(:,502), t3x256(:,:,242), nhel, den(452))
    call cont_VV(nsync, wf16(:,137), wf16(:,142), A(:,243), n3(:,503), t3x256(:,:,243), nhel, den(453))
    call cont_VV(nsync, wf16(:,140), wf16(:,143), A(:,244), n3(:,504), t3x256(:,:,244), nhel, den(454))
    call cont_QA(nsync, wf16(:,29), wf16(:,144), A(:,245), n3(:,505), t3x256(:,:,245), nhel, den(457))
    call cont_QA(nsync, wf16(:,29), wf16(:,145), A(:,246), n3(:,506), t3x256(:,:,246), nhel, den(460))
    call cont_QA(nsync, wf8(:,8), wf32(:,29), A(:,247), n3(:,507), t3x256(:,:,247), nhel, den(462))
    call cont_QA(nsync, wf8(:,8), wf32(:,30), A(:,248), n3(:,508), t3x256(:,:,248), nhel, den(464))
    call cont_QA(nsync, wf16(:,33), wf16(:,146), A(:,249), n3(:,509), t3x256(:,:,249), nhel, den(465))
    call cont_QA(nsync, wf16(:,33), wf16(:,147), A(:,250), n3(:,510), t3x256(:,:,250), nhel, den(466))
    call cont_QA(nsync, wf4(:,6), wf64(:,9), A(:,251), n3(:,511), t3x256(:,:,251), nhel, den(468))
    call cont_QA(nsync, wf4(:,6), wf64(:,10), A(:,252), n3(:,512), t3x256(:,:,252), nhel, den(470))
    call cont_QA(nsync, wf16(:,14), wf16(:,148), A(:,253), n3(:,513), t3x256(:,:,253), nhel, den(472))
    call cont_QA(nsync, wf16(:,14), wf16(:,149), A(:,254), n3(:,514), t3x256(:,:,254), nhel, den(474))
    call cont_QA(nsync, wf16(:,28), wf16(:,150), A(:,255), n3(:,515), t3x256(:,:,255), nhel, den(476))
    call cont_QA(nsync, wf16(:,28), wf16(:,151), A(:,256), n3(:,516), t3x256(:,:,256), nhel, den(478))
    call cont_VV(nsync, wf16(:,142), wf16(:,152), A(:,257), n3(:,517), t3x256(:,:,257), nhel, den(482))
    call cont_VV(nsync, wf16(:,143), wf16(:,154), A(:,258), n3(:,518), t3x256(:,:,258), nhel, den(484))
    call cont_VV(nsync, wf16(:,138), wf16(:,152), A(:,259), n3(:,519), t3x256(:,:,259), nhel, den(485))
    call cont_VV(nsync, wf16(:,141), wf16(:,154), A(:,260), n3(:,520), t3x256(:,:,260), nhel, den(486))
    call cont_VV(nsync, wf16(:,138), wf16(:,155), A(:,261), n3(:,521), t3x256(:,:,261), nhel, den(491))
    call cont_VV(nsync, wf16(:,141), wf16(:,157), A(:,262), n3(:,522), t3x256(:,:,262), nhel, den(493))
    call cont_VV(nsync, wf16(:,142), wf16(:,155), A(:,263), n3(:,523), t3x256(:,:,263), nhel, den(494))
    call cont_VV(nsync, wf16(:,143), wf16(:,157), A(:,264), n3(:,524), t3x256(:,:,264), nhel, den(495))
    call cont_QA(nsync, wf16(:,29), wf16(:,158), A(:,265), n3(:,525), t3x256(:,:,265), nhel, den(497))
    call cont_QA(nsync, wf16(:,29), wf16(:,159), A(:,266), n3(:,526), t3x256(:,:,266), nhel, den(499))
    call cont_QA(nsync, wf8(:,8), wf32(:,31), A(:,267), n3(:,527), t3x256(:,:,267), nhel, den(501))
    call cont_QA(nsync, wf8(:,8), wf32(:,32), A(:,268), n3(:,528), t3x256(:,:,268), nhel, den(503))
    call cont_QA(nsync, wf16(:,33), wf16(:,160), A(:,269), n3(:,529), t3x256(:,:,269), nhel, den(504))
    call cont_QA(nsync, wf16(:,33), wf16(:,161), A(:,270), n3(:,530), t3x256(:,:,270), nhel, den(505))
    call cont_QA(nsync, wf4(:,6), wf64(:,11), A(:,271), n3(:,531), t3x256(:,:,271), nhel, den(507))
    call cont_QA(nsync, wf4(:,6), wf64(:,12), A(:,272), n3(:,532), t3x256(:,:,272), nhel, den(509))
    call cont_QA(nsync, wf16(:,14), wf16(:,162), A(:,273), n3(:,533), t3x256(:,:,273), nhel, den(511))
    call cont_QA(nsync, wf16(:,14), wf16(:,163), A(:,274), n3(:,534), t3x256(:,:,274), nhel, den(513))
    call cont_QA(nsync, wf16(:,28), wf16(:,164), A(:,275), n3(:,535), t3x256(:,:,275), nhel, den(515))
    call cont_QA(nsync, wf16(:,28), wf16(:,165), A(:,276), n3(:,536), t3x256(:,:,276), nhel, den(517))
    call cont_VV(nsync, wf16(:,142), wf16(:,166), A(:,277), n3(:,537), t3x256(:,:,277), nhel, den(521))
    call cont_VV(nsync, wf16(:,143), wf16(:,168), A(:,278), n3(:,538), t3x256(:,:,278), nhel, den(523))
    call cont_VV(nsync, wf16(:,138), wf16(:,166), A(:,279), n3(:,539), t3x256(:,:,279), nhel, den(524))
    call cont_VV(nsync, wf16(:,141), wf16(:,168), A(:,280), n3(:,540), t3x256(:,:,280), nhel, den(525))
    call cont_QA(nsync, wf16(:,11), wf16(:,169), A(:,281), n3(:,541), t3x256(:,:,281), nhel, den(528))
    call cont_QA(nsync, wf16(:,11), wf16(:,170), A(:,282), n3(:,542), t3x256(:,:,282), nhel, den(531))
    call cont_QA(nsync, wf8(:,8), wf32(:,33), A(:,283), n3(:,543), t3x256(:,:,283), nhel, den(533))
    call cont_QA(nsync, wf8(:,8), wf32(:,34), A(:,284), n3(:,544), t3x256(:,:,284), nhel, den(535))
    call cont_QA(nsync, wf16(:,11), wf16(:,171), A(:,285), n3(:,545), t3x256(:,:,285), nhel, den(537))
    call cont_QA(nsync, wf16(:,11), wf16(:,172), A(:,286), n3(:,546), t3x256(:,:,286), nhel, den(539))
    call cont_QA(nsync, wf8(:,8), wf32(:,35), A(:,287), n3(:,547), t3x256(:,:,287), nhel, den(541))
    call cont_QA(nsync, wf8(:,8), wf32(:,36), A(:,288), n3(:,548), t3x256(:,:,288), nhel, den(543))
    call cont_QA(nsync, wf16(:,25), wf16(:,173), A(:,289), n3(:,549), t3x256(:,:,289), nhel, den(544))
    call cont_QA(nsync, wf16(:,25), wf16(:,174), A(:,290), n3(:,550), t3x256(:,:,290), nhel, den(545))
    call cont_QA(nsync, wf4(:,12), wf64(:,13), A(:,291), n3(:,551), t3x256(:,:,291), nhel, den(547))
    call cont_QA(nsync, wf4(:,12), wf64(:,14), A(:,292), n3(:,552), t3x256(:,:,292), nhel, den(549))
    call cont_QA(nsync, wf16(:,25), wf16(:,175), A(:,293), n3(:,553), t3x256(:,:,293), nhel, den(550))
    call cont_QA(nsync, wf16(:,25), wf16(:,176), A(:,294), n3(:,554), t3x256(:,:,294), nhel, den(551))
    call cont_QA(nsync, wf4(:,12), wf64(:,15), A(:,295), n3(:,555), t3x256(:,:,295), nhel, den(553))
    call cont_QA(nsync, wf4(:,12), wf64(:,16), A(:,296), n3(:,556), t3x256(:,:,296), nhel, den(555))
    call cont_QA(nsync, wf16(:,32), wf16(:,177), A(:,297), n3(:,557), t3x256(:,:,297), nhel, den(557))
    call cont_QA(nsync, wf16(:,32), wf16(:,178), A(:,298), n3(:,558), t3x256(:,:,298), nhel, den(559))
    call cont_QA(nsync, wf16(:,36), wf16(:,179), A(:,299), n3(:,559), t3x256(:,:,299), nhel, den(561))
    call cont_QA(nsync, wf16(:,36), wf16(:,180), A(:,300), n3(:,560), t3x256(:,:,300), nhel, den(563))
    call cont_VV(nsync, wf16(:,142), wf16(:,181), A(:,301), n3(:,561), t3x256(:,:,301), nhel, den(566))
    call cont_VV(nsync, wf16(:,143), wf16(:,183), A(:,302), n3(:,562), t3x256(:,:,302), nhel, den(568))
    call cont_VV(nsync, wf16(:,138), wf16(:,181), A(:,303), n3(:,563), t3x256(:,:,303), nhel, den(569))
    call cont_VV(nsync, wf16(:,141), wf16(:,183), A(:,304), n3(:,564), t3x256(:,:,304), nhel, den(570))
    call cont_QA(nsync, wf16(:,32), wf16(:,184), A(:,305), n3(:,565), t3x256(:,:,305), nhel, den(572))
    call cont_QA(nsync, wf16(:,32), wf16(:,185), A(:,306), n3(:,566), t3x256(:,:,306), nhel, den(574))
    call cont_QA(nsync, wf16(:,36), wf16(:,186), A(:,307), n3(:,567), t3x256(:,:,307), nhel, den(576))
    call cont_QA(nsync, wf16(:,36), wf16(:,187), A(:,308), n3(:,568), t3x256(:,:,308), nhel, den(578))
    call cont_VV(nsync, wf16(:,142), wf16(:,188), A(:,309), n3(:,569), t3x256(:,:,309), nhel, den(581))
    call cont_VV(nsync, wf16(:,143), wf16(:,190), A(:,310), n3(:,570), t3x256(:,:,310), nhel, den(583))
    call cont_VV(nsync, wf16(:,138), wf16(:,188), A(:,311), n3(:,571), t3x256(:,:,311), nhel, den(584))
    call cont_VV(nsync, wf16(:,141), wf16(:,190), A(:,312), n3(:,572), t3x256(:,:,312), nhel, den(585))
    call cont_VV(nsync, wf16(:,137), wf16(:,191), A(:,313), n3(:,573), t3x256(:,:,313), nhel, den(586))
    call cont_VV(nsync, wf16(:,140), wf16(:,192), A(:,314), n3(:,574), t3x256(:,:,314), nhel, den(587))
    call cont_VV(nsync, wf16(:,137), wf16(:,193), A(:,315), n3(:,575), t3x256(:,:,315), nhel, den(588))
    call cont_VV(nsync, wf16(:,140), wf16(:,194), A(:,316), n3(:,576), t3x256(:,:,316), nhel, den(589))
    call cont_QA(nsync, wf16(:,71), wf16(:,195), A(:,317), n3(:,577), t3x256(:,:,317), nhel, den(590))
    call cont_QA(nsync, wf16(:,71), wf16(:,196), A(:,318), n3(:,578), t3x256(:,:,318), nhel, den(591))
    call cont_QA(nsync, wf8(:,28), wf32(:,37), A(:,319), n3(:,579), t3x256(:,:,319), nhel, den(593))
    call cont_QA(nsync, wf8(:,28), wf32(:,38), A(:,320), n3(:,580), t3x256(:,:,320), nhel, den(595))
    call cont_QA(nsync, wf16(:,75), wf16(:,197), A(:,321), n3(:,581), t3x256(:,:,321), nhel, den(596))
    call cont_QA(nsync, wf16(:,75), wf16(:,198), A(:,322), n3(:,582), t3x256(:,:,322), nhel, den(597))
    call cont_QA(nsync, wf4(:,17), wf64(:,17), A(:,323), n3(:,583), t3x256(:,:,323), nhel, den(599))
    call cont_QA(nsync, wf4(:,17), wf64(:,18), A(:,324), n3(:,584), t3x256(:,:,324), nhel, den(601))
    call cont_QA(nsync, wf16(:,56), wf16(:,199), A(:,325), n3(:,585), t3x256(:,:,325), nhel, den(603))
    call cont_QA(nsync, wf16(:,56), wf16(:,200), A(:,326), n3(:,586), t3x256(:,:,326), nhel, den(605))
    call cont_QA(nsync, wf16(:,70), wf16(:,201), A(:,327), n3(:,587), t3x256(:,:,327), nhel, den(607))
    call cont_QA(nsync, wf16(:,70), wf16(:,202), A(:,328), n3(:,588), t3x256(:,:,328), nhel, den(609))
    call cont_VV(nsync, wf16(:,152), wf16(:,193), A(:,329), n3(:,589), t3x256(:,:,329), nhel, den(610))
    call cont_VV(nsync, wf16(:,154), wf16(:,194), A(:,330), n3(:,590), t3x256(:,:,330), nhel, den(611))
    call cont_VV(nsync, wf16(:,152), wf16(:,191), A(:,331), n3(:,591), t3x256(:,:,331), nhel, den(612))
    call cont_VV(nsync, wf16(:,154), wf16(:,192), A(:,332), n3(:,592), t3x256(:,:,332), nhel, den(613))
    call cont_VV(nsync, wf16(:,155), wf16(:,191), A(:,333), n3(:,593), t3x256(:,:,333), nhel, den(614))
    call cont_VV(nsync, wf16(:,157), wf16(:,192), A(:,334), n3(:,594), t3x256(:,:,334), nhel, den(615))
    call cont_VV(nsync, wf16(:,155), wf16(:,193), A(:,335), n3(:,595), t3x256(:,:,335), nhel, den(616))
    call cont_VV(nsync, wf16(:,157), wf16(:,194), A(:,336), n3(:,596), t3x256(:,:,336), nhel, den(617))
    call cont_QA(nsync, wf16(:,71), wf16(:,203), A(:,337), n3(:,597), t3x256(:,:,337), nhel, den(618))
    call cont_QA(nsync, wf16(:,71), wf16(:,204), A(:,338), n3(:,598), t3x256(:,:,338), nhel, den(619))
    call cont_QA(nsync, wf8(:,28), wf32(:,39), A(:,339), n3(:,599), t3x256(:,:,339), nhel, den(621))
    call cont_QA(nsync, wf8(:,28), wf32(:,40), A(:,340), n3(:,600), t3x256(:,:,340), nhel, den(623))
    call cont_QA(nsync, wf16(:,75), wf16(:,205), A(:,341), n3(:,601), t3x256(:,:,341), nhel, den(624))
    call cont_QA(nsync, wf16(:,75), wf16(:,206), A(:,342), n3(:,602), t3x256(:,:,342), nhel, den(625))
    call cont_QA(nsync, wf4(:,17), wf64(:,19), A(:,343), n3(:,603), t3x256(:,:,343), nhel, den(627))
    call cont_QA(nsync, wf4(:,17), wf64(:,20), A(:,344), n3(:,604), t3x256(:,:,344), nhel, den(629))
    call cont_QA(nsync, wf16(:,56), wf16(:,207), A(:,345), n3(:,605), t3x256(:,:,345), nhel, den(631))
    call cont_QA(nsync, wf16(:,56), wf16(:,208), A(:,346), n3(:,606), t3x256(:,:,346), nhel, den(633))
    call cont_QA(nsync, wf16(:,70), wf16(:,209), A(:,347), n3(:,607), t3x256(:,:,347), nhel, den(635))
    call cont_QA(nsync, wf16(:,70), wf16(:,210), A(:,348), n3(:,608), t3x256(:,:,348), nhel, den(637))
    call cont_VV(nsync, wf16(:,166), wf16(:,193), A(:,349), n3(:,609), t3x256(:,:,349), nhel, den(638))
    call cont_VV(nsync, wf16(:,168), wf16(:,194), A(:,350), n3(:,610), t3x256(:,:,350), nhel, den(639))
    call cont_VV(nsync, wf16(:,166), wf16(:,191), A(:,351), n3(:,611), t3x256(:,:,351), nhel, den(640))
    call cont_VV(nsync, wf16(:,168), wf16(:,192), A(:,352), n3(:,612), t3x256(:,:,352), nhel, den(641))
    call cont_QA(nsync, wf16(:,53), wf16(:,211), A(:,353), n3(:,613), t3x256(:,:,353), nhel, den(642))
    call cont_QA(nsync, wf16(:,53), wf16(:,212), A(:,354), n3(:,614), t3x256(:,:,354), nhel, den(643))
    call cont_QA(nsync, wf8(:,28), wf32(:,41), A(:,355), n3(:,615), t3x256(:,:,355), nhel, den(645))
    call cont_QA(nsync, wf8(:,28), wf32(:,42), A(:,356), n3(:,616), t3x256(:,:,356), nhel, den(647))
    call cont_QA(nsync, wf16(:,53), wf16(:,213), A(:,357), n3(:,617), t3x256(:,:,357), nhel, den(648))
    call cont_QA(nsync, wf16(:,53), wf16(:,214), A(:,358), n3(:,618), t3x256(:,:,358), nhel, den(649))
    call cont_QA(nsync, wf8(:,28), wf32(:,43), A(:,359), n3(:,619), t3x256(:,:,359), nhel, den(651))
    call cont_QA(nsync, wf8(:,28), wf32(:,44), A(:,360), n3(:,620), t3x256(:,:,360), nhel, den(653))
    call cont_QA(nsync, wf16(:,67), wf16(:,215), A(:,361), n3(:,621), t3x256(:,:,361), nhel, den(654))
    call cont_QA(nsync, wf16(:,67), wf16(:,216), A(:,362), n3(:,622), t3x256(:,:,362), nhel, den(655))
    call cont_QA(nsync, wf4(:,21), wf64(:,21), A(:,363), n3(:,623), t3x256(:,:,363), nhel, den(657))
    call cont_QA(nsync, wf4(:,21), wf64(:,22), A(:,364), n3(:,624), t3x256(:,:,364), nhel, den(659))
    call cont_QA(nsync, wf16(:,67), wf16(:,217), A(:,365), n3(:,625), t3x256(:,:,365), nhel, den(660))
    call cont_QA(nsync, wf16(:,67), wf16(:,218), A(:,366), n3(:,626), t3x256(:,:,366), nhel, den(661))
    call cont_QA(nsync, wf4(:,21), wf64(:,23), A(:,367), n3(:,627), t3x256(:,:,367), nhel, den(663))
    call cont_QA(nsync, wf4(:,21), wf64(:,24), A(:,368), n3(:,628), t3x256(:,:,368), nhel, den(665))
    call cont_QA(nsync, wf16(:,74), wf16(:,219), A(:,369), n3(:,629), t3x256(:,:,369), nhel, den(667))
    call cont_QA(nsync, wf16(:,74), wf16(:,220), A(:,370), n3(:,630), t3x256(:,:,370), nhel, den(669))
    call cont_QA(nsync, wf16(:,78), wf16(:,221), A(:,371), n3(:,631), t3x256(:,:,371), nhel, den(671))
    call cont_QA(nsync, wf16(:,78), wf16(:,222), A(:,372), n3(:,632), t3x256(:,:,372), nhel, den(673))
    call cont_VV(nsync, wf16(:,181), wf16(:,193), A(:,373), n3(:,633), t3x256(:,:,373), nhel, den(674))
    call cont_VV(nsync, wf16(:,183), wf16(:,194), A(:,374), n3(:,634), t3x256(:,:,374), nhel, den(675))
    call cont_VV(nsync, wf16(:,181), wf16(:,191), A(:,375), n3(:,635), t3x256(:,:,375), nhel, den(676))
    call cont_VV(nsync, wf16(:,183), wf16(:,192), A(:,376), n3(:,636), t3x256(:,:,376), nhel, den(677))
    call cont_QA(nsync, wf16(:,74), wf16(:,223), A(:,377), n3(:,637), t3x256(:,:,377), nhel, den(679))
    call cont_QA(nsync, wf16(:,74), wf16(:,224), A(:,378), n3(:,638), t3x256(:,:,378), nhel, den(681))
    call cont_QA(nsync, wf16(:,78), wf16(:,225), A(:,379), n3(:,639), t3x256(:,:,379), nhel, den(683))
    call cont_QA(nsync, wf16(:,78), wf16(:,226), A(:,380), n3(:,640), t3x256(:,:,380), nhel, den(685))
    call cont_VV(nsync, wf16(:,188), wf16(:,193), A(:,381), n3(:,641), t3x256(:,:,381), nhel, den(686))
    call cont_VV(nsync, wf16(:,190), wf16(:,194), A(:,382), n3(:,642), t3x256(:,:,382), nhel, den(687))
    call cont_VV(nsync, wf16(:,188), wf16(:,191), A(:,383), n3(:,643), t3x256(:,:,383), nhel, den(688))
    call cont_VV(nsync, wf16(:,190), wf16(:,192), A(:,384), n3(:,644), t3x256(:,:,384), nhel, den(689))
    call cont_QA(nsync, wf16(:,105), wf16(:,148), A(:,385), n3(:,645), t3x256(:,:,385), nhel, den(690))
    call cont_QA(nsync, wf16(:,105), wf16(:,149), A(:,386), n3(:,646), t3x256(:,:,386), nhel, den(691))
    call cont_QA(nsync, wf16(:,127), wf16(:,144), A(:,387), n3(:,647), t3x256(:,:,387), nhel, den(692))
    call cont_QA(nsync, wf16(:,127), wf16(:,145), A(:,388), n3(:,648), t3x256(:,:,388), nhel, den(693))
    call cont_QA(nsync, wf16(:,107), wf16(:,148), A(:,389), n3(:,649), t3x256(:,:,389), nhel, den(694))
    call cont_QA(nsync, wf16(:,107), wf16(:,149), A(:,390), n3(:,650), t3x256(:,:,390), nhel, den(695))
    call cont_QA(nsync, wf16(:,130), wf16(:,144), A(:,391), n3(:,651), t3x256(:,:,391), nhel, den(696))
    call cont_QA(nsync, wf16(:,130), wf16(:,145), A(:,392), n3(:,652), t3x256(:,:,392), nhel, den(697))
    call cont_QA(nsync, wf16(:,91), wf16(:,199), A(:,393), n3(:,653), t3x256(:,:,393), nhel, den(698))
    call cont_QA(nsync, wf16(:,91), wf16(:,200), A(:,394), n3(:,654), t3x256(:,:,394), nhel, den(699))
    call cont_QA(nsync, wf16(:,133), wf16(:,195), A(:,395), n3(:,655), t3x256(:,:,395), nhel, den(700))
    call cont_QA(nsync, wf16(:,133), wf16(:,196), A(:,396), n3(:,656), t3x256(:,:,396), nhel, den(701))
    call cont_QA(nsync, wf16(:,93), wf16(:,199), A(:,397), n3(:,657), t3x256(:,:,397), nhel, den(702))
    call cont_QA(nsync, wf16(:,93), wf16(:,200), A(:,398), n3(:,658), t3x256(:,:,398), nhel, den(703))
    call cont_QA(nsync, wf16(:,136), wf16(:,195), A(:,399), n3(:,659), t3x256(:,:,399), nhel, den(704))
    call cont_QA(nsync, wf16(:,136), wf16(:,196), A(:,400), n3(:,660), t3x256(:,:,400), nhel, den(705))
    call cont_QA(nsync, wf16(:,105), wf16(:,162), A(:,401), n3(:,661), t3x256(:,:,401), nhel, den(706))
    call cont_QA(nsync, wf16(:,105), wf16(:,163), A(:,402), n3(:,662), t3x256(:,:,402), nhel, den(707))
    call cont_QA(nsync, wf16(:,127), wf16(:,158), A(:,403), n3(:,663), t3x256(:,:,403), nhel, den(708))
    call cont_QA(nsync, wf16(:,127), wf16(:,159), A(:,404), n3(:,664), t3x256(:,:,404), nhel, den(709))
    call cont_QA(nsync, wf16(:,107), wf16(:,162), A(:,405), n3(:,665), t3x256(:,:,405), nhel, den(710))
    call cont_QA(nsync, wf16(:,107), wf16(:,163), A(:,406), n3(:,666), t3x256(:,:,406), nhel, den(711))
    call cont_QA(nsync, wf16(:,130), wf16(:,158), A(:,407), n3(:,667), t3x256(:,:,407), nhel, den(712))
    call cont_QA(nsync, wf16(:,130), wf16(:,159), A(:,408), n3(:,668), t3x256(:,:,408), nhel, den(713))
    call cont_QA(nsync, wf16(:,91), wf16(:,207), A(:,409), n3(:,669), t3x256(:,:,409), nhel, den(714))
    call cont_QA(nsync, wf16(:,91), wf16(:,208), A(:,410), n3(:,670), t3x256(:,:,410), nhel, den(715))
    call cont_QA(nsync, wf16(:,133), wf16(:,203), A(:,411), n3(:,671), t3x256(:,:,411), nhel, den(716))
    call cont_QA(nsync, wf16(:,133), wf16(:,204), A(:,412), n3(:,672), t3x256(:,:,412), nhel, den(717))
    call cont_QA(nsync, wf16(:,93), wf16(:,207), A(:,413), n3(:,673), t3x256(:,:,413), nhel, den(718))
    call cont_QA(nsync, wf16(:,93), wf16(:,208), A(:,414), n3(:,674), t3x256(:,:,414), nhel, den(719))
    call cont_QA(nsync, wf16(:,136), wf16(:,203), A(:,415), n3(:,675), t3x256(:,:,415), nhel, den(720))
    call cont_QA(nsync, wf16(:,136), wf16(:,204), A(:,416), n3(:,676), t3x256(:,:,416), nhel, den(721))
    call cont_QA(nsync, wf16(:,90), wf16(:,177), A(:,417), n3(:,677), t3x256(:,:,417), nhel, den(722))
    call cont_QA(nsync, wf16(:,90), wf16(:,178), A(:,418), n3(:,678), t3x256(:,:,418), nhel, den(723))
    call cont_QA(nsync, wf16(:,96), wf16(:,169), A(:,419), n3(:,679), t3x256(:,:,419), nhel, den(724))
    call cont_QA(nsync, wf16(:,96), wf16(:,170), A(:,420), n3(:,680), t3x256(:,:,420), nhel, den(725))
    call cont_QA(nsync, wf16(:,90), wf16(:,184), A(:,421), n3(:,681), t3x256(:,:,421), nhel, den(726))
    call cont_QA(nsync, wf16(:,90), wf16(:,185), A(:,422), n3(:,682), t3x256(:,:,422), nhel, den(727))
    call cont_QA(nsync, wf16(:,96), wf16(:,171), A(:,423), n3(:,683), t3x256(:,:,423), nhel, den(728))
    call cont_QA(nsync, wf16(:,96), wf16(:,172), A(:,424), n3(:,684), t3x256(:,:,424), nhel, den(729))
    call cont_QA(nsync, wf16(:,98), wf16(:,177), A(:,425), n3(:,685), t3x256(:,:,425), nhel, den(730))
    call cont_QA(nsync, wf16(:,98), wf16(:,178), A(:,426), n3(:,686), t3x256(:,:,426), nhel, den(731))
    call cont_QA(nsync, wf16(:,104), wf16(:,169), A(:,427), n3(:,687), t3x256(:,:,427), nhel, den(732))
    call cont_QA(nsync, wf16(:,104), wf16(:,170), A(:,428), n3(:,688), t3x256(:,:,428), nhel, den(733))
    call cont_QA(nsync, wf16(:,98), wf16(:,184), A(:,429), n3(:,689), t3x256(:,:,429), nhel, den(734))
    call cont_QA(nsync, wf16(:,98), wf16(:,185), A(:,430), n3(:,690), t3x256(:,:,430), nhel, den(735))
    call cont_QA(nsync, wf16(:,104), wf16(:,171), A(:,431), n3(:,691), t3x256(:,:,431), nhel, den(736))
    call cont_QA(nsync, wf16(:,104), wf16(:,172), A(:,432), n3(:,692), t3x256(:,:,432), nhel, den(737))
    call cont_QA(nsync, wf16(:,106), wf16(:,219), A(:,433), n3(:,693), t3x256(:,:,433), nhel, den(738))
    call cont_QA(nsync, wf16(:,106), wf16(:,220), A(:,434), n3(:,694), t3x256(:,:,434), nhel, den(739))
    call cont_QA(nsync, wf16(:,116), wf16(:,211), A(:,435), n3(:,695), t3x256(:,:,435), nhel, den(740))
    call cont_QA(nsync, wf16(:,116), wf16(:,212), A(:,436), n3(:,696), t3x256(:,:,436), nhel, den(741))
    call cont_QA(nsync, wf16(:,106), wf16(:,223), A(:,437), n3(:,697), t3x256(:,:,437), nhel, den(742))
    call cont_QA(nsync, wf16(:,106), wf16(:,224), A(:,438), n3(:,698), t3x256(:,:,438), nhel, den(743))
    call cont_QA(nsync, wf16(:,116), wf16(:,213), A(:,439), n3(:,699), t3x256(:,:,439), nhel, den(744))
    call cont_QA(nsync, wf16(:,116), wf16(:,214), A(:,440), n3(:,700), t3x256(:,:,440), nhel, den(745))
    call cont_QA(nsync, wf16(:,118), wf16(:,219), A(:,441), n3(:,701), t3x256(:,:,441), nhel, den(746))
    call cont_QA(nsync, wf16(:,118), wf16(:,220), A(:,442), n3(:,702), t3x256(:,:,442), nhel, den(747))
    call cont_QA(nsync, wf16(:,124), wf16(:,211), A(:,443), n3(:,703), t3x256(:,:,443), nhel, den(748))
    call cont_QA(nsync, wf16(:,124), wf16(:,212), A(:,444), n3(:,704), t3x256(:,:,444), nhel, den(749))
    call cont_QA(nsync, wf16(:,118), wf16(:,223), A(:,445), n3(:,705), t3x256(:,:,445), nhel, den(750))
    call cont_QA(nsync, wf16(:,118), wf16(:,224), A(:,446), n3(:,706), t3x256(:,:,446), nhel, den(751))
    call cont_QA(nsync, wf16(:,124), wf16(:,213), A(:,447), n3(:,707), t3x256(:,:,447), nhel, den(752))
    call cont_QA(nsync, wf16(:,124), wf16(:,214), A(:,448), n3(:,708), t3x256(:,:,448), nhel, den(753))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(2) ! M1helarray(2,256)
  integer :: empty(0)

  M1(1) = ((A(j,1)%j+A(j,3)%j+A(j,5)%j+A(j,7)%j+A(j,9)%j+A(j,11)%j+A(j,13)%j+A(j,15)%j+A(j,17)%j+A(j,19)%j+A(j,21)%j+A(j,23)%j &
       +A(j,25)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j+A(j,43)%j+A(j,45)%j &
       +A(j,47)%j)*f(1))/2._/**/REALKIND+((-A(j,103)%j-A(j,105)%j-A(j,111)%j-A(j,113)%j-A(j,117)%j-A(j,121)%j-A(j,131)%j &
       -A(j,133)%j-A(j,139)%j-A(j,141)%j-A(j,145)%j-A(j,149)%j-A(j,155)%j-A(j,157)%j-A(j,163)%j-A(j,165)%j-A(j,169)%j-A(j,171)%j &
       -A(j,173)%j-A(j,177)%j-A(j,183)%j-A(j,185)%j-A(j,191)%j-A(j,193)%j-A(j,197)%j-A(j,199)%j-A(j,201)%j-A(j,205)%j-A(j,209)%j &
       -A(j,213)%j-A(j,217)%j-A(j,221)%j-A(j,225)%j-A(j,229)%j-A(j,233)%j-A(j,237)%j)*f(2))/2._/**/REALKIND+((A(j,2)%j+A(j,4)%j &
       +A(j,6)%j+A(j,8)%j+A(j,10)%j+A(j,12)%j+A(j,14)%j+A(j,16)%j+A(j,18)%j+A(j,20)%j+A(j,22)%j+A(j,24)%j+A(j,26)%j+A(j,28)%j &
       +A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j+A(j,38)%j+A(j,40)%j+A(j,42)%j+A(j,44)%j+A(j,46)%j+A(j,48)%j+A(j,170)%j+A(j,172)%j &
       +A(j,174)%j+A(j,178)%j+A(j,198)%j+A(j,200)%j+A(j,202)%j+A(j,206)%j+A(j,226)%j+A(j,230)%j+A(j,234)%j+A(j,238)%j+A(j,245)%j &
       +A(j,247)%j+A(j,249)%j+A(j,251)%j+A(j,253)%j+A(j,255)%j+A(j,265)%j+A(j,267)%j+A(j,269)%j+A(j,271)%j+A(j,273)%j+A(j,275)%j &
       +A(j,281)%j+A(j,283)%j+A(j,285)%j+A(j,287)%j+A(j,289)%j+A(j,291)%j+A(j,293)%j+A(j,295)%j+A(j,297)%j+A(j,299)%j+A(j,305)%j &
       +A(j,307)%j)*f(3))/2._/**/REALKIND+((A(j,97)%j+A(j,99)%j+A(j,101)%j+A(j,107)%j+A(j,109)%j+A(j,115)%j+A(j,119)%j+A(j,123)%j &
       +A(j,125)%j+A(j,127)%j+A(j,129)%j+A(j,135)%j+A(j,137)%j+A(j,143)%j+A(j,147)%j+A(j,151)%j+A(j,153)%j+A(j,159)%j+A(j,161)%j &
       +A(j,167)%j+A(j,175)%j+A(j,179)%j+A(j,181)%j+A(j,187)%j+A(j,189)%j+A(j,195)%j+A(j,203)%j+A(j,207)%j+A(j,211)%j+A(j,215)%j &
       +A(j,219)%j+A(j,223)%j+A(j,227)%j+A(j,231)%j+A(j,235)%j+A(j,239)%j)*f(4))/2._/**/REALKIND+((-A(j,102)%j-A(j,104)%j &
       -A(j,106)%j-A(j,108)%j-A(j,110)%j-A(j,112)%j-A(j,114)%j-A(j,116)%j-A(j,118)%j-A(j,122)%j-A(j,130)%j-A(j,132)%j-A(j,134)%j &
       -A(j,136)%j-A(j,138)%j-A(j,140)%j-A(j,142)%j-A(j,144)%j-A(j,146)%j-A(j,150)%j-A(j,154)%j-A(j,156)%j-A(j,158)%j-A(j,160)%j &
       -A(j,162)%j-A(j,164)%j-A(j,166)%j-A(j,168)%j-A(j,176)%j-A(j,180)%j-A(j,182)%j-A(j,184)%j-A(j,186)%j-A(j,188)%j-A(j,190)%j &
       -A(j,192)%j-A(j,194)%j-A(j,196)%j-A(j,204)%j-A(j,208)%j-A(j,210)%j-A(j,214)%j-A(j,218)%j-A(j,222)%j-A(j,228)%j-A(j,232)%j &
       -A(j,236)%j-A(j,240)%j-A(j,385)%j-A(j,387)%j-A(j,389)%j-A(j,391)%j-A(j,393)%j-A(j,395)%j-A(j,397)%j-A(j,399)%j-A(j,401)%j &
       -A(j,403)%j-A(j,405)%j-A(j,407)%j-A(j,409)%j-A(j,411)%j-A(j,413)%j-A(j,415)%j-A(j,417)%j-A(j,419)%j-A(j,421)%j-A(j,423)%j &
       -A(j,425)%j-A(j,427)%j-A(j,429)%j-A(j,431)%j-A(j,433)%j-A(j,435)%j-A(j,437)%j-A(j,439)%j-A(j,441)%j-A(j,443)%j-A(j,445)%j &
       -A(j,447)%j)*f(5))/2._/**/REALKIND+((-A(j,49)%j-A(j,51)%j-A(j,53)%j-A(j,55)%j-A(j,57)%j-A(j,59)%j-A(j,61)%j-A(j,63)%j &
       -A(j,65)%j-A(j,67)%j-A(j,69)%j-A(j,71)%j-A(j,73)%j-A(j,75)%j-A(j,77)%j-A(j,79)%j-A(j,81)%j-A(j,83)%j-A(j,85)%j-A(j,87)%j &
       -A(j,89)%j-A(j,91)%j-A(j,93)%j-A(j,95)%j)*f(6))/2._/**/REALKIND+((A(j,241)%j+A(j,243)%j+A(j,246)%j+A(j,248)%j+A(j,250)%j &
       +A(j,252)%j+A(j,254)%j+A(j,256)%j+A(j,257)%j+A(j,259)%j+A(j,261)%j+A(j,263)%j+A(j,266)%j+A(j,268)%j+A(j,270)%j+A(j,272)%j &
       +A(j,274)%j+A(j,276)%j+A(j,277)%j+A(j,279)%j+A(j,282)%j+A(j,284)%j+A(j,286)%j+A(j,288)%j+A(j,290)%j+A(j,292)%j+A(j,294)%j &
       +A(j,296)%j+A(j,298)%j+A(j,300)%j+A(j,301)%j+A(j,303)%j+A(j,306)%j+A(j,308)%j+A(j,309)%j+A(j,311)%j+A(j,394)%j+A(j,396)%j &
       +A(j,398)%j+A(j,400)%j+A(j,410)%j+A(j,412)%j+A(j,414)%j+A(j,416)%j+A(j,434)%j+A(j,436)%j+A(j,438)%j+A(j,440)%j+A(j,442)%j &
       +A(j,444)%j+A(j,446)%j+A(j,448)%j)*f(7))/2._/**/REALKIND+((A(j,50)%j+A(j,52)%j+A(j,54)%j+A(j,56)%j+A(j,58)%j+A(j,60)%j &
       +A(j,62)%j+A(j,64)%j+A(j,66)%j+A(j,68)%j+A(j,70)%j+A(j,72)%j+A(j,74)%j+A(j,76)%j+A(j,78)%j+A(j,80)%j+A(j,82)%j+A(j,84)%j &
       +A(j,86)%j+A(j,88)%j+A(j,90)%j+A(j,92)%j+A(j,94)%j+A(j,96)%j+A(j,98)%j+A(j,100)%j+A(j,120)%j+A(j,124)%j+A(j,126)%j &
       +A(j,128)%j+A(j,148)%j+A(j,152)%j+A(j,212)%j+A(j,216)%j+A(j,220)%j+A(j,224)%j+A(j,317)%j+A(j,319)%j+A(j,321)%j+A(j,323)%j &
       +A(j,325)%j+A(j,327)%j+A(j,337)%j+A(j,339)%j+A(j,341)%j+A(j,343)%j+A(j,345)%j+A(j,347)%j+A(j,353)%j+A(j,355)%j+A(j,357)%j &
       +A(j,359)%j+A(j,361)%j+A(j,363)%j+A(j,365)%j+A(j,367)%j+A(j,369)%j+A(j,371)%j+A(j,377)%j+A(j,379)%j)*f(8))/2._/**/REALKIND &
       +((-A(j,313)%j-A(j,315)%j-A(j,318)%j-A(j,320)%j-A(j,322)%j-A(j,324)%j-A(j,326)%j-A(j,328)%j-A(j,329)%j-A(j,331)%j &
       -A(j,333)%j-A(j,335)%j-A(j,338)%j-A(j,340)%j-A(j,342)%j-A(j,344)%j-A(j,346)%j-A(j,348)%j-A(j,349)%j-A(j,351)%j-A(j,354)%j &
       -A(j,356)%j-A(j,358)%j-A(j,360)%j-A(j,362)%j-A(j,364)%j-A(j,366)%j-A(j,368)%j-A(j,370)%j-A(j,372)%j-A(j,373)%j-A(j,375)%j &
       -A(j,378)%j-A(j,380)%j-A(j,381)%j-A(j,383)%j-A(j,386)%j-A(j,388)%j-A(j,390)%j-A(j,392)%j-A(j,402)%j-A(j,404)%j-A(j,406)%j &
       -A(j,408)%j-A(j,418)%j-A(j,420)%j-A(j,422)%j-A(j,424)%j-A(j,426)%j-A(j,428)%j-A(j,430)%j-A(j,432)%j)*f(9))/2._/**/REALKIND &
       +((A(j,242)%j+A(j,244)%j+A(j,258)%j+A(j,260)%j+A(j,262)%j+A(j,264)%j+A(j,278)%j+A(j,280)%j+A(j,302)%j+A(j,304)%j+A(j,310)%j &
       +A(j,312)%j+A(j,314)%j+A(j,316)%j+A(j,330)%j+A(j,332)%j+A(j,334)%j+A(j,336)%j+A(j,350)%j+A(j,352)%j+A(j,374)%j+A(j,376)%j &
       +A(j,382)%j+A(j,384)%j)*f(10))/2._/**/REALKIND
  M1(2) = ((-A(j,1)%j-A(j,3)%j-A(j,5)%j-A(j,7)%j-A(j,9)%j-A(j,11)%j-A(j,13)%j-A(j,15)%j-A(j,17)%j-A(j,19)%j-A(j,21)%j-A(j,23)%j &
       -A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j-A(j,37)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j &
       -A(j,47)%j)*f(1))/6._/**/REALKIND+((A(j,103)%j+A(j,105)%j+A(j,111)%j+A(j,113)%j+A(j,117)%j+A(j,121)%j+A(j,131)%j+A(j,133)%j &
       +A(j,139)%j+A(j,141)%j+A(j,145)%j+A(j,149)%j+A(j,155)%j+A(j,157)%j+A(j,163)%j+A(j,165)%j+A(j,169)%j+A(j,171)%j+A(j,173)%j &
       +A(j,177)%j+A(j,183)%j+A(j,185)%j+A(j,191)%j+A(j,193)%j+A(j,197)%j+A(j,199)%j+A(j,201)%j+A(j,205)%j+A(j,209)%j+A(j,213)%j &
       +A(j,217)%j+A(j,221)%j+A(j,225)%j+A(j,229)%j+A(j,233)%j+A(j,237)%j)*f(2))/6._/**/REALKIND+((-A(j,2)%j-A(j,4)%j-A(j,6)%j &
       -A(j,8)%j-A(j,10)%j-A(j,12)%j-A(j,14)%j-A(j,16)%j-A(j,18)%j-A(j,20)%j-A(j,22)%j-A(j,24)%j-A(j,26)%j-A(j,28)%j-A(j,30)%j &
       -A(j,32)%j-A(j,34)%j-A(j,36)%j-A(j,38)%j-A(j,40)%j-A(j,42)%j-A(j,44)%j-A(j,46)%j-A(j,48)%j-A(j,170)%j-A(j,172)%j-A(j,174)%j &
       -A(j,178)%j-A(j,198)%j-A(j,200)%j-A(j,202)%j-A(j,206)%j-A(j,226)%j-A(j,230)%j-A(j,234)%j-A(j,238)%j-A(j,245)%j-A(j,247)%j &
       -A(j,249)%j-A(j,251)%j-A(j,253)%j-A(j,255)%j-A(j,265)%j-A(j,267)%j-A(j,269)%j-A(j,271)%j-A(j,273)%j-A(j,275)%j-A(j,281)%j &
       -A(j,283)%j-A(j,285)%j-A(j,287)%j-A(j,289)%j-A(j,291)%j-A(j,293)%j-A(j,295)%j-A(j,297)%j-A(j,299)%j-A(j,305)%j &
       -A(j,307)%j)*f(3))/6._/**/REALKIND+((-A(j,97)%j-A(j,99)%j-A(j,101)%j-A(j,107)%j-A(j,109)%j-A(j,115)%j-A(j,119)%j-A(j,123)%j &
       -A(j,125)%j-A(j,127)%j-A(j,129)%j-A(j,135)%j-A(j,137)%j-A(j,143)%j-A(j,147)%j-A(j,151)%j-A(j,153)%j-A(j,159)%j-A(j,161)%j &
       -A(j,167)%j-A(j,175)%j-A(j,179)%j-A(j,181)%j-A(j,187)%j-A(j,189)%j-A(j,195)%j-A(j,203)%j-A(j,207)%j-A(j,211)%j-A(j,215)%j &
       -A(j,219)%j-A(j,223)%j-A(j,227)%j-A(j,231)%j-A(j,235)%j-A(j,239)%j)*f(4))/6._/**/REALKIND+((A(j,102)%j+A(j,104)%j &
       +A(j,106)%j+A(j,108)%j+A(j,110)%j+A(j,112)%j+A(j,114)%j+A(j,116)%j+A(j,118)%j+A(j,122)%j+A(j,130)%j+A(j,132)%j+A(j,134)%j &
       +A(j,136)%j+A(j,138)%j+A(j,140)%j+A(j,142)%j+A(j,144)%j+A(j,146)%j+A(j,150)%j+A(j,154)%j+A(j,156)%j+A(j,158)%j+A(j,160)%j &
       +A(j,162)%j+A(j,164)%j+A(j,166)%j+A(j,168)%j+A(j,176)%j+A(j,180)%j+A(j,182)%j+A(j,184)%j+A(j,186)%j+A(j,188)%j+A(j,190)%j &
       +A(j,192)%j+A(j,194)%j+A(j,196)%j+A(j,204)%j+A(j,208)%j+A(j,210)%j+A(j,214)%j+A(j,218)%j+A(j,222)%j+A(j,228)%j+A(j,232)%j &
       +A(j,236)%j+A(j,240)%j+A(j,385)%j+A(j,387)%j+A(j,389)%j+A(j,391)%j+A(j,393)%j+A(j,395)%j+A(j,397)%j+A(j,399)%j+A(j,401)%j &
       +A(j,403)%j+A(j,405)%j+A(j,407)%j+A(j,409)%j+A(j,411)%j+A(j,413)%j+A(j,415)%j+A(j,417)%j+A(j,419)%j+A(j,421)%j+A(j,423)%j &
       +A(j,425)%j+A(j,427)%j+A(j,429)%j+A(j,431)%j+A(j,433)%j+A(j,435)%j+A(j,437)%j+A(j,439)%j+A(j,441)%j+A(j,443)%j+A(j,445)%j &
       +A(j,447)%j)*f(5))/6._/**/REALKIND+((A(j,49)%j+A(j,51)%j+A(j,53)%j+A(j,55)%j+A(j,57)%j+A(j,59)%j+A(j,61)%j+A(j,63)%j &
       +A(j,65)%j+A(j,67)%j+A(j,69)%j+A(j,71)%j+A(j,73)%j+A(j,75)%j+A(j,77)%j+A(j,79)%j+A(j,81)%j+A(j,83)%j+A(j,85)%j+A(j,87)%j &
       +A(j,89)%j+A(j,91)%j+A(j,93)%j+A(j,95)%j)*f(6))/6._/**/REALKIND+((-A(j,241)%j-A(j,243)%j-A(j,246)%j-A(j,248)%j-A(j,250)%j &
       -A(j,252)%j-A(j,254)%j-A(j,256)%j-A(j,257)%j-A(j,259)%j-A(j,261)%j-A(j,263)%j-A(j,266)%j-A(j,268)%j-A(j,270)%j-A(j,272)%j &
       -A(j,274)%j-A(j,276)%j-A(j,277)%j-A(j,279)%j-A(j,282)%j-A(j,284)%j-A(j,286)%j-A(j,288)%j-A(j,290)%j-A(j,292)%j-A(j,294)%j &
       -A(j,296)%j-A(j,298)%j-A(j,300)%j-A(j,301)%j-A(j,303)%j-A(j,306)%j-A(j,308)%j-A(j,309)%j-A(j,311)%j-A(j,394)%j-A(j,396)%j &
       -A(j,398)%j-A(j,400)%j-A(j,410)%j-A(j,412)%j-A(j,414)%j-A(j,416)%j-A(j,434)%j-A(j,436)%j-A(j,438)%j-A(j,440)%j-A(j,442)%j &
       -A(j,444)%j-A(j,446)%j-A(j,448)%j)*f(7))/6._/**/REALKIND+((-A(j,50)%j-A(j,52)%j-A(j,54)%j-A(j,56)%j-A(j,58)%j-A(j,60)%j &
       -A(j,62)%j-A(j,64)%j-A(j,66)%j-A(j,68)%j-A(j,70)%j-A(j,72)%j-A(j,74)%j-A(j,76)%j-A(j,78)%j-A(j,80)%j-A(j,82)%j-A(j,84)%j &
       -A(j,86)%j-A(j,88)%j-A(j,90)%j-A(j,92)%j-A(j,94)%j-A(j,96)%j-A(j,98)%j-A(j,100)%j-A(j,120)%j-A(j,124)%j-A(j,126)%j &
       -A(j,128)%j-A(j,148)%j-A(j,152)%j-A(j,212)%j-A(j,216)%j-A(j,220)%j-A(j,224)%j-A(j,317)%j-A(j,319)%j-A(j,321)%j-A(j,323)%j &
       -A(j,325)%j-A(j,327)%j-A(j,337)%j-A(j,339)%j-A(j,341)%j-A(j,343)%j-A(j,345)%j-A(j,347)%j-A(j,353)%j-A(j,355)%j-A(j,357)%j &
       -A(j,359)%j-A(j,361)%j-A(j,363)%j-A(j,365)%j-A(j,367)%j-A(j,369)%j-A(j,371)%j-A(j,377)%j-A(j,379)%j)*f(8))/6._/**/REALKIND &
       +((A(j,313)%j+A(j,315)%j+A(j,318)%j+A(j,320)%j+A(j,322)%j+A(j,324)%j+A(j,326)%j+A(j,328)%j+A(j,329)%j+A(j,331)%j+A(j,333)%j &
       +A(j,335)%j+A(j,338)%j+A(j,340)%j+A(j,342)%j+A(j,344)%j+A(j,346)%j+A(j,348)%j+A(j,349)%j+A(j,351)%j+A(j,354)%j+A(j,356)%j &
       +A(j,358)%j+A(j,360)%j+A(j,362)%j+A(j,364)%j+A(j,366)%j+A(j,368)%j+A(j,370)%j+A(j,372)%j+A(j,373)%j+A(j,375)%j+A(j,378)%j &
       +A(j,380)%j+A(j,381)%j+A(j,383)%j+A(j,386)%j+A(j,388)%j+A(j,390)%j+A(j,392)%j+A(j,402)%j+A(j,404)%j+A(j,406)%j+A(j,408)%j &
       +A(j,418)%j+A(j,420)%j+A(j,422)%j+A(j,424)%j+A(j,426)%j+A(j,428)%j+A(j,430)%j+A(j,432)%j)*f(9))/6._/**/REALKIND+(( &
       -A(j,242)%j-A(j,244)%j-A(j,258)%j-A(j,260)%j-A(j,262)%j-A(j,264)%j-A(j,278)%j-A(j,280)%j-A(j,302)%j-A(j,304)%j-A(j,310)%j &
       -A(j,312)%j-A(j,314)%j-A(j,316)%j-A(j,330)%j-A(j,332)%j-A(j,334)%j-A(j,336)%j-A(j,350)%j-A(j,352)%j-A(j,374)%j-A(j,376)%j &
       -A(j,382)%j-A(j,384)%j)*f(10))/6._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllaaj_eexuuxbbxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint(0:1-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllaaj_eexuuxbbxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(2), M2(2)
  real(REALKIND),    intent(out) :: M2colint(0:1-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllaaj_eexuuxbbxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppllaaj_eexuuxbbxaa_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(2,256)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllaaj_eexuuxbbxaa_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllaaj_eexuuxbbxaa_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllaaj_eexuuxbbxaa_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    1, [ (k, k = 0, 1-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllaaj_eexuuxbbxaa_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllaaj_eexuuxbbxaa_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(8)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(8)
  do J = 1, 8
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 8,extcombs, M2munu)
  do J = 1, 8
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllaaj_eexuuxbbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllaaj_eexuuxbbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllaaj_eexuuxbbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(0:1-1)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(0:1-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllaaj_eexuuxbbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllaaj_eexuuxbbxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(8)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(8)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppllaaj_eexuuxbbxaa_1_/**/REALKIND
