
module ol_colourmatrix_ppllaaj_eexdddxdxaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(2,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 9, 3]
  K1(2,:) = [ 3, 9]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllaaj_eexdddxdxaa_1_/**/REALKIND



module ol_forced_parameters_ppllaaj_eexdddxdxaa_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllaaj_eexdddxdxaa_1_/**/REALKIND

module ol_tree_ppllaaj_eexdddxdxaa_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(4)
  complex(REALKIND), save :: den(1348)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 256 ! number of helicity configurations
  integer(intkind2), save :: nhel = 256 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(256) ! physical helicity states
  complex(DREALKIND) :: M1helarr(2,256) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED**4*gQCD**2)/27._/**/REALKIND
    f(2) = (CI*eQED**4*gQCD**2)/9._/**/REALKIND
    f(3) = (CI*eQED**4*gQCD**2)/3._/**/REALKIND
    f(4) = CI*eQED**4*gQCD**2

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,72))+L(6,72))
  den(3) = 1 /((L(5,20))+L(6,20))
  den(4) = 1 /((L(5,160))+L(6,160))
  den(7) = 1 /((L(5,75))+L(6,75))
  den(10) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(16) = 1 /((L(5,163))+L(6,163))
  den(22) = 1 /((L(5,35))+L(6,35))
  den(24) = 1 /((L(5,200))+L(6,200))
  den(31) = 1 /((L(5,92))+L(6,92))
  den(35) = 1 /((L(5,52))+L(6,52))
  den(43) = 1 /((L(5,136))+L(6,136))
  den(44) = 1 /((L(5,96))+L(6,96))
  den(47) = 1 /((L(5,139))+L(6,139))
  den(55) = 1 /((L(5,99))+L(6,99))
  den(61) = 1 /((L(5,11))+L(6,11))
  den(63) = 1 /((L(5,116))+L(6,116))
  den(68) = 1 /((L(5,224))+L(6,224))
  den(74) = 1 /((L(5,28))+L(6,28))
  den(85) = 1 /((L(5,156))+L(6,156))
  den(93) = 1 /((L(5,180))+L(6,180))
  den(118) = 1 /((L(5,68))+L(6,68))
  den(119) = 1 /((L(5,24))+L(6,24))
  den(122) = 1 /((L(5,71))+L(6,71))
  den(131) = 1 /((L(5,196))+L(6,196))
  den(140) = 1 /((L(5,56))+L(6,56))
  den(148) = 1 /((L(5,132))+L(6,132))
  den(151) = 1 /((L(5,135))+L(6,135))
  den(160) = 1 /((L(5,7))+L(6,7))
  den(162) = 1 /((L(5,120))+L(6,120))
  den(188) = 1 /((L(5,184))+L(6,184))
  den(210) = 1 /((L(5,36))+L(6,36))
  den(211) = 1 /((L(5,144))+L(6,144))
  den(217) = 1 /((L(5,147))+L(6,147))
  den(223) = 1 /((L(5,19))+L(6,19))
  den(230) = 1 /((L(5,108))+L(6,108))
  den(241) = 1 /((L(5,80))+L(6,80))
  den(247) = 1 /((L(5,83))+L(6,83))
  den(256) = 1 /((L(5,208))+L(6,208))
  den(262) = 1 /((L(5,44))+L(6,44))
  den(272) = 1 /((L(5,172))+L(6,172))
  den(302) = 1 /((L(5,40))+L(6,40))
  den(371) = 1 /((L(5,100))+L(6,100))
  den(377) = 1 /((L(5,168))+L(6,168))
  den(383) = 1 /((L(5,84))+L(6,84))
  den(388) = 1 /((L(5,152))+L(6,152))
  den(406) = 1 /((L(5,212))+L(6,212))
  den(425) = 1 /((L(5,228))+L(6,228))
  den(445) = 1 /((L(5,27))+L(6,27))
  den(463) = 1 /((L(5,43))+L(6,43))
  den(468) = 1 /((L(5,164))+L(6,164))
  den(474) = 1 /((L(5,104))+L(6,104))
  den(480) = 1 /((L(5,148))+L(6,148))
  den(485) = 1 /((L(5,88))+L(6,88))
  den(499) = 1 /((L(5,216))+L(6,216))
  den(518) = 1 /((L(5,232))+L(6,232))
  den(536) = 1 /((L(5,23))+L(6,23))
  den(557) = 1 /((L(5,39))+L(6,39))
  den(815) = 1 /((L(5,65))+L(6,65))
  den(816) = 1 /((L(5,130))+L(6,130))
  den(818) = 1 /((L(5,195))+L(6,195))
  den(821) = 1 /((L(5,195) - MZ2)+L(6,195))
  den(826) = 1 /((L(5,67))+L(6,67))
  den(829) = 1 /((L(5,67) - MZ2)+L(6,67))
  den(850) = 1 /((L(5,193))+L(6,193))
  den(858) = 1 /((L(5,129))+L(6,129))
  den(859) = 1 /((L(5,66))+L(6,66))
  den(889) = 1 /((L(5,194))+L(6,194))
  den(897) = 1 /((L(5,131))+L(6,131))
  den(900) = 1 /((L(5,131) - MZ2)+L(6,131))

  ! denominators

  den(5) = den(1)*den(2)
  den(6) = den(3)*den(4)
  den(8) = den(5)*den(7)
  den(9) = den(6)*den(8)
  den(11) = den(2)*den(10)
  den(12) = den(7)*den(11)
  den(13) = den(6)*den(12)
  den(14) = den(1)*den(4)
  den(15) = den(2)*den(3)
  den(17) = den(14)*den(16)
  den(18) = den(15)*den(17)
  den(19) = den(4)*den(10)
  den(20) = den(16)*den(19)
  den(21) = den(15)*den(20)
  den(23) = den(1)*den(22)
  den(25) = den(2)*den(24)
  den(26) = den(3)*den(23)
  den(27) = den(25)*den(26)
  den(28) = den(10)*den(22)
  den(29) = den(3)*den(28)
  den(30) = den(25)*den(29)
  den(32) = den(15)*den(31)
  den(33) = den(23)*den(32)
  den(34) = den(28)*den(32)
  den(36) = den(3)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(25)*den(37)
  den(39) = den(10)*den(36)
  den(40) = den(25)*den(39)
  den(41) = den(8)*den(36)
  den(42) = den(12)*den(36)
  den(45) = den(1)*den(43)
  den(46) = den(3)*den(44)
  den(48) = den(45)*den(47)
  den(49) = den(46)*den(48)
  den(50) = den(10)*den(43)
  den(51) = den(47)*den(50)
  den(52) = den(46)*den(51)
  den(53) = den(1)*den(44)
  den(54) = den(3)*den(43)
  den(56) = den(53)*den(55)
  den(57) = den(54)*den(56)
  den(58) = den(10)*den(44)
  den(59) = den(55)*den(58)
  den(60) = den(54)*den(59)
  den(62) = den(1)*den(61)
  den(64) = den(46)*den(63)
  den(65) = den(62)*den(64)
  den(66) = den(10)*den(61)
  den(67) = den(64)*den(66)
  den(69) = den(44)*den(68)
  den(70) = den(3)*den(62)
  den(71) = den(69)*den(70)
  den(72) = den(3)*den(66)
  den(73) = den(69)*den(72)
  den(75) = den(3)*den(74)
  den(76) = den(56)*den(75)
  den(77) = den(59)*den(75)
  den(78) = den(1)*den(75)
  den(79) = den(69)*den(78)
  den(80) = den(10)*den(75)
  den(81) = den(69)*den(80)
  den(82) = den(24)*den(43)
  den(83) = den(26)*den(82)
  den(84) = den(29)*den(82)
  den(86) = den(54)*den(85)
  den(87) = den(23)*den(86)
  den(88) = den(28)*den(86)
  den(89) = den(37)*den(82)
  den(90) = den(39)*den(82)
  den(91) = den(36)*den(48)
  den(92) = den(36)*den(51)
  den(94) = den(6)*den(93)
  den(95) = den(62)*den(94)
  den(96) = den(66)*den(94)
  den(97) = den(4)*den(68)
  den(98) = den(70)*den(97)
  den(99) = den(72)*den(97)
  den(100) = den(17)*den(75)
  den(101) = den(20)*den(75)
  den(102) = den(78)*den(97)
  den(103) = den(80)*den(97)
  den(104) = den(7)*den(62)
  den(105) = den(36)*den(104)
  den(106) = den(7)*den(66)
  den(107) = den(36)*den(106)
  den(108) = den(36)*den(63)
  den(109) = den(62)*den(108)
  den(110) = den(66)*den(108)
  den(111) = den(31)*den(75)
  den(112) = den(23)*den(111)
  den(113) = den(28)*den(111)
  den(114) = den(23)*den(55)
  den(115) = den(75)*den(114)
  den(116) = den(28)*den(55)
  den(117) = den(75)*den(116)
  den(120) = den(1)*den(118)
  den(121) = den(4)*den(119)
  den(123) = den(120)*den(122)
  den(124) = den(121)*den(123)
  den(125) = den(10)*den(118)
  den(126) = den(122)*den(125)
  den(127) = den(121)*den(126)
  den(128) = den(118)*den(119)
  den(129) = den(17)*den(128)
  den(130) = den(20)*den(128)
  den(132) = den(118)*den(131)
  den(133) = den(23)*den(119)
  den(134) = den(132)*den(133)
  den(135) = den(28)*den(119)
  den(136) = den(132)*den(135)
  den(137) = den(31)*den(128)
  den(138) = den(23)*den(137)
  den(139) = den(28)*den(137)
  den(141) = den(119)*den(140)
  den(142) = den(1)*den(141)
  den(143) = den(132)*den(142)
  den(144) = den(10)*den(141)
  den(145) = den(132)*den(144)
  den(146) = den(123)*den(141)
  den(147) = den(126)*den(141)
  den(149) = den(1)*den(148)
  den(150) = den(44)*den(119)
  den(152) = den(149)*den(151)
  den(153) = den(150)*den(152)
  den(154) = den(10)*den(148)
  den(155) = den(151)*den(154)
  den(156) = den(150)*den(155)
  den(157) = den(119)*den(148)
  den(158) = den(56)*den(157)
  den(159) = den(59)*den(157)
  den(161) = den(1)*den(160)
  den(163) = den(150)*den(162)
  den(164) = den(161)*den(163)
  den(165) = den(10)*den(160)
  den(166) = den(163)*den(165)
  den(167) = den(119)*den(161)
  den(168) = den(69)*den(167)
  den(169) = den(119)*den(165)
  den(170) = den(69)*den(169)
  den(171) = den(74)*den(119)
  den(172) = den(56)*den(171)
  den(173) = den(59)*den(171)
  den(174) = den(1)*den(171)
  den(175) = den(69)*den(174)
  den(176) = den(10)*den(171)
  den(177) = den(69)*den(176)
  den(178) = den(131)*den(148)
  den(179) = den(133)*den(178)
  den(180) = den(135)*den(178)
  den(181) = den(85)*den(157)
  den(182) = den(23)*den(181)
  den(183) = den(28)*den(181)
  den(184) = den(142)*den(178)
  den(185) = den(144)*den(178)
  den(186) = den(141)*den(152)
  den(187) = den(141)*den(155)
  den(189) = den(121)*den(188)
  den(190) = den(161)*den(189)
  den(191) = den(165)*den(189)
  den(192) = den(97)*den(167)
  den(193) = den(97)*den(169)
  den(194) = den(17)*den(171)
  den(195) = den(20)*den(171)
  den(196) = den(97)*den(174)
  den(197) = den(97)*den(176)
  den(198) = den(122)*den(161)
  den(199) = den(141)*den(198)
  den(200) = den(122)*den(165)
  den(201) = den(141)*den(200)
  den(202) = den(141)*den(162)
  den(203) = den(161)*den(202)
  den(204) = den(165)*den(202)
  den(205) = den(31)*den(171)
  den(206) = den(23)*den(205)
  den(207) = den(28)*den(205)
  den(208) = den(114)*den(171)
  den(209) = den(116)*den(171)
  den(212) = den(210)*den(211)
  den(213) = den(8)*den(212)
  den(214) = den(12)*den(212)
  den(215) = den(1)*den(211)
  den(216) = den(2)*den(210)
  den(218) = den(215)*den(217)
  den(219) = den(216)*den(218)
  den(220) = den(10)*den(211)
  den(221) = den(217)*den(220)
  den(222) = den(216)*den(221)
  den(224) = den(1)*den(223)
  den(225) = den(210)*den(224)
  den(226) = den(25)*den(225)
  den(227) = den(10)*den(223)
  den(228) = den(210)*den(227)
  den(229) = den(25)*den(228)
  den(231) = den(216)*den(230)
  den(232) = den(224)*den(231)
  den(233) = den(227)*den(231)
  den(234) = den(35)*den(210)
  den(235) = den(1)*den(234)
  den(236) = den(25)*den(235)
  den(237) = den(10)*den(234)
  den(238) = den(25)*den(237)
  den(239) = den(8)*den(234)
  den(240) = den(12)*den(234)
  den(242) = den(210)*den(241)
  den(243) = den(48)*den(242)
  den(244) = den(51)*den(242)
  den(245) = den(1)*den(241)
  den(246) = den(43)*den(210)
  den(248) = den(245)*den(247)
  den(249) = den(246)*den(248)
  den(250) = den(10)*den(241)
  den(251) = den(247)*den(250)
  den(252) = den(246)*den(251)
  den(253) = den(63)*den(242)
  den(254) = den(62)*den(253)
  den(255) = den(66)*den(253)
  den(257) = den(241)*den(256)
  den(258) = den(62)*den(210)
  den(259) = den(257)*den(258)
  den(260) = den(66)*den(210)
  den(261) = den(257)*den(260)
  den(263) = den(210)*den(262)
  den(264) = den(248)*den(263)
  den(265) = den(251)*den(263)
  den(266) = den(1)*den(263)
  den(267) = den(257)*den(266)
  den(268) = den(10)*den(263)
  den(269) = den(257)*den(268)
  den(270) = den(82)*den(225)
  den(271) = den(82)*den(228)
  den(273) = den(246)*den(272)
  den(274) = den(224)*den(273)
  den(275) = den(227)*den(273)
  den(276) = den(82)*den(235)
  den(277) = den(82)*den(237)
  den(278) = den(48)*den(234)
  den(279) = den(51)*den(234)
  den(280) = den(93)*den(212)
  den(281) = den(62)*den(280)
  den(282) = den(66)*den(280)
  den(283) = den(211)*den(256)
  den(284) = den(258)*den(283)
  den(285) = den(260)*den(283)
  den(286) = den(218)*den(263)
  den(287) = den(221)*den(263)
  den(288) = den(266)*den(283)
  den(289) = den(268)*den(283)
  den(290) = den(104)*den(234)
  den(291) = den(106)*den(234)
  den(292) = den(63)*den(234)
  den(293) = den(62)*den(292)
  den(294) = den(66)*den(292)
  den(295) = den(230)*den(263)
  den(296) = den(224)*den(295)
  den(297) = den(227)*den(295)
  den(298) = den(224)*den(247)
  den(299) = den(263)*den(298)
  den(300) = den(227)*den(247)
  den(301) = den(263)*den(300)
  den(303) = den(211)*den(302)
  den(304) = den(123)*den(303)
  den(305) = den(126)*den(303)
  den(306) = den(118)*den(302)
  den(307) = den(218)*den(306)
  den(308) = den(221)*den(306)
  den(309) = den(224)*den(302)
  den(310) = den(132)*den(309)
  den(311) = den(227)*den(302)
  den(312) = den(132)*den(311)
  den(313) = den(230)*den(306)
  den(314) = den(224)*den(313)
  den(315) = den(227)*den(313)
  den(316) = den(140)*den(302)
  den(317) = den(1)*den(316)
  den(318) = den(132)*den(317)
  den(319) = den(10)*den(316)
  den(320) = den(132)*den(319)
  den(321) = den(123)*den(316)
  den(322) = den(126)*den(316)
  den(323) = den(241)*den(302)
  den(324) = den(152)*den(323)
  den(325) = den(155)*den(323)
  den(326) = den(148)*den(302)
  den(327) = den(248)*den(326)
  den(328) = den(251)*den(326)
  den(329) = den(162)*den(323)
  den(330) = den(161)*den(329)
  den(331) = den(165)*den(329)
  den(332) = den(161)*den(302)
  den(333) = den(257)*den(332)
  den(334) = den(165)*den(302)
  den(335) = den(257)*den(334)
  den(336) = den(262)*den(302)
  den(337) = den(248)*den(336)
  den(338) = den(251)*den(336)
  den(339) = den(1)*den(336)
  den(340) = den(257)*den(339)
  den(341) = den(10)*den(336)
  den(342) = den(257)*den(341)
  den(343) = den(178)*den(309)
  den(344) = den(178)*den(311)
  den(345) = den(272)*den(326)
  den(346) = den(224)*den(345)
  den(347) = den(227)*den(345)
  den(348) = den(178)*den(317)
  den(349) = den(178)*den(319)
  den(350) = den(152)*den(316)
  den(351) = den(155)*den(316)
  den(352) = den(188)*den(303)
  den(353) = den(161)*den(352)
  den(354) = den(165)*den(352)
  den(355) = den(283)*den(332)
  den(356) = den(283)*den(334)
  den(357) = den(218)*den(336)
  den(358) = den(221)*den(336)
  den(359) = den(283)*den(339)
  den(360) = den(283)*den(341)
  den(361) = den(198)*den(316)
  den(362) = den(200)*den(316)
  den(363) = den(162)*den(316)
  den(364) = den(161)*den(363)
  den(365) = den(165)*den(363)
  den(366) = den(230)*den(336)
  den(367) = den(224)*den(366)
  den(368) = den(227)*den(366)
  den(369) = den(298)*den(336)
  den(370) = den(300)*den(336)
  den(372) = den(118)*den(371)
  den(373) = den(43)*den(224)
  den(374) = den(372)*den(373)
  den(375) = den(43)*den(227)
  den(376) = den(372)*den(375)
  den(378) = den(43)*den(377)
  den(379) = den(118)*den(224)
  den(380) = den(378)*den(379)
  den(381) = den(118)*den(227)
  den(382) = den(378)*den(381)
  den(384) = den(118)*den(383)
  den(385) = den(43)*den(384)
  den(386) = den(23)*den(385)
  den(387) = den(28)*den(385)
  den(389) = den(43)*den(388)
  den(390) = den(118)*den(389)
  den(391) = den(23)*den(390)
  den(392) = den(28)*den(390)
  den(393) = den(48)*den(384)
  den(394) = den(51)*den(384)
  den(395) = den(48)*den(372)
  den(396) = den(51)*den(372)
  den(397) = den(123)*den(389)
  den(398) = den(126)*den(389)
  den(399) = den(123)*den(378)
  den(400) = den(126)*den(378)
  den(401) = den(62)*den(211)
  den(402) = den(372)*den(401)
  den(403) = den(66)*den(211)
  den(404) = den(372)*den(403)
  den(405) = den(118)*den(211)
  den(407) = den(405)*den(406)
  den(408) = den(62)*den(407)
  den(409) = den(66)*den(407)
  den(410) = den(211)*den(388)
  den(411) = den(118)*den(410)
  den(412) = den(23)*den(411)
  den(413) = den(28)*den(411)
  den(414) = den(23)*den(407)
  den(415) = den(28)*den(407)
  den(416) = den(218)*den(372)
  den(417) = den(221)*den(372)
  den(418) = den(123)*den(410)
  den(419) = den(126)*den(410)
  den(420) = den(62)*den(384)
  den(421) = den(4)*den(420)
  den(422) = den(66)*den(384)
  den(423) = den(4)*den(422)
  den(424) = den(4)*den(118)
  den(426) = den(424)*den(425)
  den(427) = den(62)*den(426)
  den(428) = den(66)*den(426)
  den(429) = den(224)*den(426)
  den(430) = den(227)*den(426)
  den(431) = den(4)*den(377)
  den(432) = den(118)*den(431)
  den(433) = den(224)*den(432)
  den(434) = den(227)*den(432)
  den(435) = den(17)*den(384)
  den(436) = den(20)*den(384)
  den(437) = den(123)*den(431)
  den(438) = den(126)*den(431)
  den(439) = den(63)*den(384)
  den(440) = den(62)*den(439)
  den(441) = den(66)*den(439)
  den(442) = den(63)*den(372)
  den(443) = den(62)*den(442)
  den(444) = den(66)*den(442)
  den(446) = den(62)*den(445)
  den(447) = den(132)*den(446)
  den(448) = den(66)*den(445)
  den(449) = den(132)*den(448)
  den(450) = den(132)*den(406)
  den(451) = den(62)*den(450)
  den(452) = den(66)*den(450)
  den(453) = den(230)*den(372)
  den(454) = den(224)*den(453)
  den(455) = den(227)*den(453)
  den(456) = den(224)*den(445)
  den(457) = den(132)*den(456)
  den(458) = den(227)*den(445)
  den(459) = den(132)*den(458)
  den(460) = den(31)*den(384)
  den(461) = den(23)*den(460)
  den(462) = den(28)*den(460)
  den(464) = den(23)*den(463)
  den(465) = den(132)*den(464)
  den(466) = den(28)*den(463)
  den(467) = den(132)*den(466)
  den(469) = den(148)*den(468)
  den(470) = den(2)*den(224)
  den(471) = den(469)*den(470)
  den(472) = den(2)*den(227)
  den(473) = den(469)*den(472)
  den(475) = den(2)*den(474)
  den(476) = den(148)*den(224)
  den(477) = den(475)*den(476)
  den(478) = den(148)*den(227)
  den(479) = den(475)*den(478)
  den(481) = den(148)*den(480)
  den(482) = den(2)*den(481)
  den(483) = den(23)*den(482)
  den(484) = den(28)*den(482)
  den(486) = den(2)*den(485)
  den(487) = den(148)*den(486)
  den(488) = den(23)*den(487)
  den(489) = den(28)*den(487)
  den(490) = den(8)*den(481)
  den(491) = den(12)*den(481)
  den(492) = den(8)*den(469)
  den(493) = den(12)*den(469)
  den(494) = den(152)*den(486)
  den(495) = den(155)*den(486)
  den(496) = den(152)*den(475)
  den(497) = den(155)*den(475)
  den(498) = den(2)*den(211)
  den(500) = den(498)*den(499)
  den(501) = den(161)*den(500)
  den(502) = den(165)*den(500)
  den(503) = den(161)*den(211)
  den(504) = den(475)*den(503)
  den(505) = den(165)*den(211)
  den(506) = den(475)*den(505)
  den(507) = den(211)*den(480)
  den(508) = den(2)*den(507)
  den(509) = den(23)*den(508)
  den(510) = den(28)*den(508)
  den(511) = den(23)*den(500)
  den(512) = den(28)*den(500)
  den(513) = den(8)*den(507)
  den(514) = den(12)*den(507)
  den(515) = den(218)*den(475)
  den(516) = den(221)*den(475)
  den(517) = den(2)*den(4)
  den(519) = den(517)*den(518)
  den(520) = den(161)*den(519)
  den(521) = den(165)*den(519)
  den(522) = den(161)*den(486)
  den(523) = den(4)*den(522)
  den(524) = den(165)*den(486)
  den(525) = den(4)*den(524)
  den(526) = den(224)*den(519)
  den(527) = den(227)*den(519)
  den(528) = den(4)*den(468)
  den(529) = den(2)*den(528)
  den(530) = den(224)*den(529)
  den(531) = den(227)*den(529)
  den(532) = den(8)*den(528)
  den(533) = den(12)*den(528)
  den(534) = den(17)*den(486)
  den(535) = den(20)*den(486)
  den(537) = den(161)*den(536)
  den(538) = den(25)*den(537)
  den(539) = den(165)*den(536)
  den(540) = den(25)*den(539)
  den(541) = den(25)*den(499)
  den(542) = den(161)*den(541)
  den(543) = den(165)*den(541)
  den(544) = den(162)*den(486)
  den(545) = den(161)*den(544)
  den(546) = den(165)*den(544)
  den(547) = den(162)*den(475)
  den(548) = den(161)*den(547)
  den(549) = den(165)*den(547)
  den(550) = den(224)*den(536)
  den(551) = den(25)*den(550)
  den(552) = den(227)*den(536)
  den(553) = den(25)*den(552)
  den(554) = den(230)*den(475)
  den(555) = den(224)*den(554)
  den(556) = den(227)*den(554)
  den(558) = den(23)*den(557)
  den(559) = den(25)*den(558)
  den(560) = den(28)*den(557)
  den(561) = den(25)*den(560)
  den(562) = den(31)*den(486)
  den(563) = den(23)*den(562)
  den(564) = den(28)*den(562)
  den(565) = den(62)*den(241)
  den(566) = den(469)*den(565)
  den(567) = den(66)*den(241)
  den(568) = den(469)*den(567)
  den(569) = den(148)*den(241)
  den(570) = den(406)*den(569)
  den(571) = den(62)*den(570)
  den(572) = den(66)*den(570)
  den(573) = den(241)*den(485)
  den(574) = den(148)*den(573)
  den(575) = den(23)*den(574)
  den(576) = den(28)*den(574)
  den(577) = den(23)*den(570)
  den(578) = den(28)*den(570)
  den(579) = den(248)*den(469)
  den(580) = den(251)*den(469)
  den(581) = den(152)*den(573)
  den(582) = den(155)*den(573)
  den(583) = den(43)*den(241)
  den(584) = den(499)*den(583)
  den(585) = den(161)*den(584)
  den(586) = den(165)*den(584)
  den(587) = den(161)*den(241)
  den(588) = den(378)*den(587)
  den(589) = den(165)*den(241)
  den(590) = den(378)*den(589)
  den(591) = den(241)*den(383)
  den(592) = den(43)*den(591)
  den(593) = den(23)*den(592)
  den(594) = den(28)*den(592)
  den(595) = den(23)*den(584)
  den(596) = den(28)*den(584)
  den(597) = den(48)*den(591)
  den(598) = den(51)*den(591)
  den(599) = den(248)*den(378)
  den(600) = den(251)*den(378)
  den(601) = den(161)*den(573)
  den(602) = den(4)*den(601)
  den(603) = den(165)*den(573)
  den(604) = den(4)*den(603)
  den(605) = den(161)*den(431)
  den(606) = den(241)*den(605)
  den(607) = den(165)*den(431)
  den(608) = den(241)*den(607)
  den(609) = den(62)*den(591)
  den(610) = den(4)*den(609)
  den(611) = den(66)*den(591)
  den(612) = den(4)*den(611)
  den(613) = den(62)*den(528)
  den(614) = den(241)*den(613)
  den(615) = den(66)*den(528)
  den(616) = den(241)*den(615)
  den(617) = den(17)*den(591)
  den(618) = den(20)*den(591)
  den(619) = den(248)*den(528)
  den(620) = den(251)*den(528)
  den(621) = den(17)*den(573)
  den(622) = den(20)*den(573)
  den(623) = den(248)*den(431)
  den(624) = den(251)*den(431)
  den(625) = den(257)*den(499)
  den(626) = den(161)*den(625)
  den(627) = den(165)*den(625)
  den(628) = den(162)*den(573)
  den(629) = den(161)*den(628)
  den(630) = den(165)*den(628)
  den(631) = den(63)*den(591)
  den(632) = den(62)*den(631)
  den(633) = den(66)*den(631)
  den(634) = den(257)*den(406)
  den(635) = den(62)*den(634)
  den(636) = den(66)*den(634)
  den(637) = den(31)*den(591)
  den(638) = den(23)*den(637)
  den(639) = den(28)*den(637)
  den(640) = den(257)*den(558)
  den(641) = den(257)*den(560)
  den(642) = den(31)*den(573)
  den(643) = den(23)*den(642)
  den(644) = den(28)*den(642)
  den(645) = den(23)*den(634)
  den(646) = den(28)*den(634)
  den(647) = den(62)*den(481)
  den(648) = den(44)*den(647)
  den(649) = den(66)*den(481)
  den(650) = den(44)*den(649)
  den(651) = den(44)*den(148)
  den(652) = den(425)*den(651)
  den(653) = den(62)*den(652)
  den(654) = den(66)*den(652)
  den(655) = den(224)*den(652)
  den(656) = den(227)*den(652)
  den(657) = den(44)*den(474)
  den(658) = den(148)*den(657)
  den(659) = den(224)*den(658)
  den(660) = den(227)*den(658)
  den(661) = den(56)*den(481)
  den(662) = den(59)*den(481)
  den(663) = den(152)*den(657)
  den(664) = den(155)*den(657)
  den(665) = den(43)*den(44)
  den(666) = den(518)*den(665)
  den(667) = den(161)*den(666)
  den(668) = den(165)*den(666)
  den(669) = den(161)*den(389)
  den(670) = den(44)*den(669)
  den(671) = den(165)*den(389)
  den(672) = den(44)*den(671)
  den(673) = den(224)*den(666)
  den(674) = den(227)*den(666)
  den(675) = den(44)*den(371)
  den(676) = den(43)*den(675)
  den(677) = den(224)*den(676)
  den(678) = den(227)*den(676)
  den(679) = den(48)*den(675)
  den(680) = den(51)*den(675)
  den(681) = den(56)*den(389)
  den(682) = den(59)*den(389)
  den(683) = den(161)*den(410)
  den(684) = den(44)*den(683)
  den(685) = den(165)*den(410)
  den(686) = den(44)*den(685)
  den(687) = den(161)*den(657)
  den(688) = den(211)*den(687)
  den(689) = den(165)*den(657)
  den(690) = den(211)*den(689)
  den(691) = den(62)*den(507)
  den(692) = den(44)*den(691)
  den(693) = den(66)*den(507)
  den(694) = den(44)*den(693)
  den(695) = den(62)*den(675)
  den(696) = den(211)*den(695)
  den(697) = den(66)*den(675)
  den(698) = den(211)*den(697)
  den(699) = den(56)*den(507)
  den(700) = den(59)*den(507)
  den(701) = den(218)*den(675)
  den(702) = den(221)*den(675)
  den(703) = den(56)*den(410)
  den(704) = den(59)*den(410)
  den(705) = den(218)*den(657)
  den(706) = den(221)*den(657)
  den(707) = den(69)*den(518)
  den(708) = den(161)*den(707)
  den(709) = den(165)*den(707)
  den(710) = den(162)*den(657)
  den(711) = den(161)*den(710)
  den(712) = den(165)*den(710)
  den(713) = den(63)*den(675)
  den(714) = den(62)*den(713)
  den(715) = den(66)*den(713)
  den(716) = den(69)*den(425)
  den(717) = den(62)*den(716)
  den(718) = den(66)*den(716)
  den(719) = den(69)*den(550)
  den(720) = den(69)*den(552)
  den(721) = den(230)*den(675)
  den(722) = den(224)*den(721)
  den(723) = den(227)*den(721)
  den(724) = den(224)*den(716)
  den(725) = den(227)*den(716)
  den(726) = den(230)*den(657)
  den(727) = den(224)*den(726)
  den(728) = den(227)*den(726)
  den(729) = den(93)*den(481)
  den(730) = den(62)*den(729)
  den(731) = den(66)*den(729)
  den(732) = den(93)*den(469)
  den(733) = den(62)*den(732)
  den(734) = den(66)*den(732)
  den(735) = den(178)*den(446)
  den(736) = den(178)*den(448)
  den(737) = den(178)*den(406)
  den(738) = den(62)*den(737)
  den(739) = den(66)*den(737)
  den(740) = den(272)*den(469)
  den(741) = den(224)*den(740)
  den(742) = den(227)*den(740)
  den(743) = den(178)*den(456)
  den(744) = den(178)*den(458)
  den(745) = den(85)*den(481)
  den(746) = den(23)*den(745)
  den(747) = den(28)*den(745)
  den(748) = den(178)*den(464)
  den(749) = den(178)*den(466)
  den(750) = den(82)*den(537)
  den(751) = den(82)*den(539)
  den(752) = den(82)*den(499)
  den(753) = den(161)*den(752)
  den(754) = den(165)*den(752)
  den(755) = den(188)*den(389)
  den(756) = den(161)*den(755)
  den(757) = den(165)*den(755)
  den(758) = den(188)*den(378)
  den(759) = den(161)*den(758)
  den(760) = den(165)*den(758)
  den(761) = den(82)*den(550)
  den(762) = den(82)*den(552)
  den(763) = den(272)*den(378)
  den(764) = den(224)*den(763)
  den(765) = den(227)*den(763)
  den(766) = den(82)*den(558)
  den(767) = den(82)*den(560)
  den(768) = den(85)*den(389)
  den(769) = den(23)*den(768)
  den(770) = den(28)*den(768)
  den(771) = den(283)*den(499)
  den(772) = den(161)*den(771)
  den(773) = den(165)*den(771)
  den(774) = den(188)*den(410)
  den(775) = den(161)*den(774)
  den(776) = den(165)*den(774)
  den(777) = den(93)*den(507)
  den(778) = den(62)*den(777)
  den(779) = den(66)*den(777)
  den(780) = den(283)*den(406)
  den(781) = den(62)*den(780)
  den(782) = den(66)*den(780)
  den(783) = den(85)*den(507)
  den(784) = den(23)*den(783)
  den(785) = den(28)*den(783)
  den(786) = den(283)*den(558)
  den(787) = den(283)*den(560)
  den(788) = den(85)*den(410)
  den(789) = den(23)*den(788)
  den(790) = den(28)*den(788)
  den(791) = den(23)*den(780)
  den(792) = den(28)*den(780)
  den(793) = den(97)*den(518)
  den(794) = den(161)*den(793)
  den(795) = den(165)*den(793)
  den(796) = den(188)*den(431)
  den(797) = den(161)*den(796)
  den(798) = den(165)*den(796)
  den(799) = den(93)*den(528)
  den(800) = den(62)*den(799)
  den(801) = den(66)*den(799)
  den(802) = den(97)*den(425)
  den(803) = den(62)*den(802)
  den(804) = den(66)*den(802)
  den(805) = den(97)*den(550)
  den(806) = den(97)*den(552)
  den(807) = den(272)*den(528)
  den(808) = den(224)*den(807)
  den(809) = den(227)*den(807)
  den(810) = den(224)*den(802)
  den(811) = den(227)*den(802)
  den(812) = den(272)*den(431)
  den(813) = den(224)*den(812)
  den(814) = den(227)*den(812)
  den(817) = den(815)*den(816)
  den(819) = den(817)*den(818)
  den(820) = den(75)*den(819)
  den(822) = den(817)*den(821)
  den(823) = den(75)*den(822)
  den(824) = den(36)*den(819)
  den(825) = den(36)*den(822)
  den(827) = den(815)*den(826)
  den(828) = den(86)*den(827)
  den(830) = den(815)*den(829)
  den(831) = den(86)*den(830)
  den(832) = den(43)*den(827)
  den(833) = den(36)*den(832)
  den(834) = den(43)*den(830)
  den(835) = den(36)*den(834)
  den(836) = den(94)*den(827)
  den(837) = den(94)*den(830)
  den(838) = den(75)*den(827)
  den(839) = den(4)*den(838)
  den(840) = den(75)*den(830)
  den(841) = den(4)*den(840)
  den(842) = den(7)*den(827)
  den(843) = den(36)*den(842)
  den(844) = den(7)*den(830)
  den(845) = den(36)*den(844)
  den(846) = den(55)*den(827)
  den(847) = den(75)*den(846)
  den(848) = den(55)*den(830)
  den(849) = den(75)*den(848)
  den(851) = den(815)*den(850)
  den(852) = den(818)*den(851)
  den(853) = den(36)*den(852)
  den(854) = den(821)*den(851)
  den(855) = den(36)*den(854)
  den(856) = den(75)*den(852)
  den(857) = den(75)*den(854)
  den(860) = den(858)*den(859)
  den(861) = den(818)*den(860)
  den(862) = den(75)*den(861)
  den(863) = den(821)*den(860)
  den(864) = den(75)*den(863)
  den(865) = den(36)*den(861)
  den(866) = den(36)*den(863)
  den(867) = den(826)*den(859)
  den(868) = den(86)*den(867)
  den(869) = den(829)*den(859)
  den(870) = den(86)*den(869)
  den(871) = den(43)*den(867)
  den(872) = den(36)*den(871)
  den(873) = den(43)*den(869)
  den(874) = den(36)*den(873)
  den(875) = den(94)*den(867)
  den(876) = den(94)*den(869)
  den(877) = den(75)*den(867)
  den(878) = den(4)*den(877)
  den(879) = den(75)*den(869)
  den(880) = den(4)*den(879)
  den(881) = den(7)*den(867)
  den(882) = den(36)*den(881)
  den(883) = den(7)*den(869)
  den(884) = den(36)*den(883)
  den(885) = den(55)*den(867)
  den(886) = den(75)*den(885)
  den(887) = den(55)*den(869)
  den(888) = den(75)*den(887)
  den(890) = den(859)*den(889)
  den(891) = den(818)*den(890)
  den(892) = den(36)*den(891)
  den(893) = den(821)*den(890)
  den(894) = den(36)*den(893)
  den(895) = den(75)*den(891)
  den(896) = den(75)*den(893)
  den(898) = den(858)*den(897)
  den(899) = den(32)*den(898)
  den(901) = den(858)*den(900)
  den(902) = den(32)*den(901)
  den(903) = den(2)*den(898)
  den(904) = den(36)*den(903)
  den(905) = den(2)*den(901)
  den(906) = den(36)*den(905)
  den(907) = den(816)*den(897)
  den(908) = den(32)*den(907)
  den(909) = den(816)*den(900)
  den(910) = den(32)*den(909)
  den(911) = den(2)*den(907)
  den(912) = den(36)*den(911)
  den(913) = den(2)*den(909)
  den(914) = den(36)*den(913)
  den(915) = den(64)*den(898)
  den(916) = den(64)*den(901)
  den(917) = den(75)*den(898)
  den(918) = den(44)*den(917)
  den(919) = den(75)*den(901)
  den(920) = den(44)*den(919)
  den(921) = den(64)*den(907)
  den(922) = den(64)*den(909)
  den(923) = den(75)*den(907)
  den(924) = den(44)*den(923)
  den(925) = den(75)*den(909)
  den(926) = den(44)*den(925)
  den(927) = den(47)*den(898)
  den(928) = den(36)*den(927)
  den(929) = den(47)*den(901)
  den(930) = den(36)*den(929)
  den(931) = den(16)*den(898)
  den(932) = den(75)*den(931)
  den(933) = den(16)*den(901)
  den(934) = den(75)*den(933)
  den(935) = den(850)*den(858)
  den(936) = den(818)*den(935)
  den(937) = den(36)*den(936)
  den(938) = den(821)*den(935)
  den(939) = den(36)*den(938)
  den(940) = den(75)*den(936)
  den(941) = den(75)*den(938)
  den(942) = den(47)*den(907)
  den(943) = den(36)*den(942)
  den(944) = den(47)*den(909)
  den(945) = den(36)*den(944)
  den(946) = den(16)*den(907)
  den(947) = den(75)*den(946)
  den(948) = den(16)*den(909)
  den(949) = den(75)*den(948)
  den(950) = den(816)*den(889)
  den(951) = den(818)*den(950)
  den(952) = den(36)*den(951)
  den(953) = den(821)*den(950)
  den(954) = den(36)*den(953)
  den(955) = den(75)*den(951)
  den(956) = den(75)*den(953)
  den(957) = den(171)*den(819)
  den(958) = den(171)*den(822)
  den(959) = den(141)*den(819)
  den(960) = den(141)*den(822)
  den(961) = den(181)*den(827)
  den(962) = den(181)*den(830)
  den(963) = den(148)*den(827)
  den(964) = den(141)*den(963)
  den(965) = den(148)*den(830)
  den(966) = den(141)*den(965)
  den(967) = den(189)*den(827)
  den(968) = den(189)*den(830)
  den(969) = den(171)*den(827)
  den(970) = den(4)*den(969)
  den(971) = den(171)*den(830)
  den(972) = den(4)*den(971)
  den(973) = den(122)*den(827)
  den(974) = den(141)*den(973)
  den(975) = den(122)*den(830)
  den(976) = den(141)*den(975)
  den(977) = den(171)*den(846)
  den(978) = den(171)*den(848)
  den(979) = den(141)*den(852)
  den(980) = den(141)*den(854)
  den(981) = den(171)*den(852)
  den(982) = den(171)*den(854)
  den(983) = den(171)*den(861)
  den(984) = den(171)*den(863)
  den(985) = den(141)*den(861)
  den(986) = den(141)*den(863)
  den(987) = den(181)*den(867)
  den(988) = den(181)*den(869)
  den(989) = den(148)*den(867)
  den(990) = den(141)*den(989)
  den(991) = den(148)*den(869)
  den(992) = den(141)*den(991)
  den(993) = den(189)*den(867)
  den(994) = den(189)*den(869)
  den(995) = den(171)*den(867)
  den(996) = den(4)*den(995)
  den(997) = den(171)*den(869)
  den(998) = den(4)*den(997)
  den(999) = den(122)*den(867)
  den(1000) = den(141)*den(999)
  den(1001) = den(122)*den(869)
  den(1002) = den(141)*den(1001)
  den(1003) = den(171)*den(885)
  den(1004) = den(171)*den(887)
  den(1005) = den(141)*den(891)
  den(1006) = den(141)*den(893)
  den(1007) = den(171)*den(891)
  den(1008) = den(171)*den(893)
  den(1009) = den(137)*den(898)
  den(1010) = den(137)*den(901)
  den(1011) = den(118)*den(898)
  den(1012) = den(141)*den(1011)
  den(1013) = den(118)*den(901)
  den(1014) = den(141)*den(1013)
  den(1015) = den(137)*den(907)
  den(1016) = den(137)*den(909)
  den(1017) = den(118)*den(907)
  den(1018) = den(141)*den(1017)
  den(1019) = den(118)*den(909)
  den(1020) = den(141)*den(1019)
  den(1021) = den(163)*den(898)
  den(1022) = den(163)*den(901)
  den(1023) = den(171)*den(898)
  den(1024) = den(44)*den(1023)
  den(1025) = den(171)*den(901)
  den(1026) = den(44)*den(1025)
  den(1027) = den(163)*den(907)
  den(1028) = den(163)*den(909)
  den(1029) = den(171)*den(907)
  den(1030) = den(44)*den(1029)
  den(1031) = den(171)*den(909)
  den(1032) = den(44)*den(1031)
  den(1033) = den(151)*den(898)
  den(1034) = den(141)*den(1033)
  den(1035) = den(151)*den(901)
  den(1036) = den(141)*den(1035)
  den(1037) = den(171)*den(931)
  den(1038) = den(171)*den(933)
  den(1039) = den(141)*den(936)
  den(1040) = den(141)*den(938)
  den(1041) = den(171)*den(936)
  den(1042) = den(171)*den(938)
  den(1043) = den(151)*den(907)
  den(1044) = den(141)*den(1043)
  den(1045) = den(151)*den(909)
  den(1046) = den(141)*den(1045)
  den(1047) = den(171)*den(946)
  den(1048) = den(171)*den(948)
  den(1049) = den(141)*den(951)
  den(1050) = den(141)*den(953)
  den(1051) = den(171)*den(951)
  den(1052) = den(171)*den(953)
  den(1053) = den(263)*den(819)
  den(1054) = den(263)*den(822)
  den(1055) = den(234)*den(819)
  den(1056) = den(234)*den(822)
  den(1057) = den(273)*den(827)
  den(1058) = den(273)*den(830)
  den(1059) = den(234)*den(832)
  den(1060) = den(234)*den(834)
  den(1061) = den(280)*den(827)
  den(1062) = den(280)*den(830)
  den(1063) = den(263)*den(827)
  den(1064) = den(211)*den(1063)
  den(1065) = den(263)*den(830)
  den(1066) = den(211)*den(1065)
  den(1067) = den(234)*den(842)
  den(1068) = den(234)*den(844)
  den(1069) = den(247)*den(827)
  den(1070) = den(263)*den(1069)
  den(1071) = den(247)*den(830)
  den(1072) = den(263)*den(1071)
  den(1073) = den(234)*den(852)
  den(1074) = den(234)*den(854)
  den(1075) = den(263)*den(852)
  den(1076) = den(263)*den(854)
  den(1077) = den(263)*den(861)
  den(1078) = den(263)*den(863)
  den(1079) = den(234)*den(861)
  den(1080) = den(234)*den(863)
  den(1081) = den(273)*den(867)
  den(1082) = den(273)*den(869)
  den(1083) = den(234)*den(871)
  den(1084) = den(234)*den(873)
  den(1085) = den(280)*den(867)
  den(1086) = den(280)*den(869)
  den(1087) = den(263)*den(867)
  den(1088) = den(211)*den(1087)
  den(1089) = den(263)*den(869)
  den(1090) = den(211)*den(1089)
  den(1091) = den(234)*den(881)
  den(1092) = den(234)*den(883)
  den(1093) = den(247)*den(867)
  den(1094) = den(263)*den(1093)
  den(1095) = den(247)*den(869)
  den(1096) = den(263)*den(1095)
  den(1097) = den(234)*den(891)
  den(1098) = den(234)*den(893)
  den(1099) = den(263)*den(891)
  den(1100) = den(263)*den(893)
  den(1101) = den(231)*den(898)
  den(1102) = den(231)*den(901)
  den(1103) = den(234)*den(903)
  den(1104) = den(234)*den(905)
  den(1105) = den(231)*den(907)
  den(1106) = den(231)*den(909)
  den(1107) = den(234)*den(911)
  den(1108) = den(234)*den(913)
  den(1109) = den(253)*den(898)
  den(1110) = den(253)*den(901)
  den(1111) = den(263)*den(898)
  den(1112) = den(241)*den(1111)
  den(1113) = den(263)*den(901)
  den(1114) = den(241)*den(1113)
  den(1115) = den(253)*den(907)
  den(1116) = den(253)*den(909)
  den(1117) = den(263)*den(907)
  den(1118) = den(241)*den(1117)
  den(1119) = den(263)*den(909)
  den(1120) = den(241)*den(1119)
  den(1121) = den(234)*den(927)
  den(1122) = den(234)*den(929)
  den(1123) = den(217)*den(898)
  den(1124) = den(263)*den(1123)
  den(1125) = den(217)*den(901)
  den(1126) = den(263)*den(1125)
  den(1127) = den(234)*den(936)
  den(1128) = den(234)*den(938)
  den(1129) = den(263)*den(936)
  den(1130) = den(263)*den(938)
  den(1131) = den(234)*den(942)
  den(1132) = den(234)*den(944)
  den(1133) = den(217)*den(907)
  den(1134) = den(263)*den(1133)
  den(1135) = den(217)*den(909)
  den(1136) = den(263)*den(1135)
  den(1137) = den(234)*den(951)
  den(1138) = den(234)*den(953)
  den(1139) = den(263)*den(951)
  den(1140) = den(263)*den(953)
  den(1141) = den(336)*den(819)
  den(1142) = den(336)*den(822)
  den(1143) = den(316)*den(819)
  den(1144) = den(316)*den(822)
  den(1145) = den(345)*den(827)
  den(1146) = den(345)*den(830)
  den(1147) = den(316)*den(963)
  den(1148) = den(316)*den(965)
  den(1149) = den(352)*den(827)
  den(1150) = den(352)*den(830)
  den(1151) = den(336)*den(827)
  den(1152) = den(211)*den(1151)
  den(1153) = den(336)*den(830)
  den(1154) = den(211)*den(1153)
  den(1155) = den(316)*den(973)
  den(1156) = den(316)*den(975)
  den(1157) = den(336)*den(1069)
  den(1158) = den(336)*den(1071)
  den(1159) = den(316)*den(852)
  den(1160) = den(316)*den(854)
  den(1161) = den(336)*den(852)
  den(1162) = den(336)*den(854)
  den(1163) = den(336)*den(861)
  den(1164) = den(336)*den(863)
  den(1165) = den(316)*den(861)
  den(1166) = den(316)*den(863)
  den(1167) = den(345)*den(867)
  den(1168) = den(345)*den(869)
  den(1169) = den(316)*den(989)
  den(1170) = den(316)*den(991)
  den(1171) = den(352)*den(867)
  den(1172) = den(352)*den(869)
  den(1173) = den(336)*den(867)
  den(1174) = den(211)*den(1173)
  den(1175) = den(336)*den(869)
  den(1176) = den(211)*den(1175)
  den(1177) = den(316)*den(999)
  den(1178) = den(316)*den(1001)
  den(1179) = den(336)*den(1093)
  den(1180) = den(336)*den(1095)
  den(1181) = den(316)*den(891)
  den(1182) = den(316)*den(893)
  den(1183) = den(336)*den(891)
  den(1184) = den(336)*den(893)
  den(1185) = den(313)*den(898)
  den(1186) = den(313)*den(901)
  den(1187) = den(316)*den(1011)
  den(1188) = den(316)*den(1013)
  den(1189) = den(313)*den(907)
  den(1190) = den(313)*den(909)
  den(1191) = den(316)*den(1017)
  den(1192) = den(316)*den(1019)
  den(1193) = den(329)*den(898)
  den(1194) = den(329)*den(901)
  den(1195) = den(336)*den(898)
  den(1196) = den(241)*den(1195)
  den(1197) = den(336)*den(901)
  den(1198) = den(241)*den(1197)
  den(1199) = den(329)*den(907)
  den(1200) = den(329)*den(909)
  den(1201) = den(336)*den(907)
  den(1202) = den(241)*den(1201)
  den(1203) = den(336)*den(909)
  den(1204) = den(241)*den(1203)
  den(1205) = den(316)*den(1033)
  den(1206) = den(316)*den(1035)
  den(1207) = den(336)*den(1123)
  den(1208) = den(336)*den(1125)
  den(1209) = den(316)*den(936)
  den(1210) = den(316)*den(938)
  den(1211) = den(336)*den(936)
  den(1212) = den(336)*den(938)
  den(1213) = den(316)*den(1043)
  den(1214) = den(316)*den(1045)
  den(1215) = den(336)*den(1133)
  den(1216) = den(336)*den(1135)
  den(1217) = den(316)*den(951)
  den(1218) = den(316)*den(953)
  den(1219) = den(336)*den(951)
  den(1220) = den(336)*den(953)
  den(1221) = den(481)*den(842)
  den(1222) = den(481)*den(844)
  den(1223) = den(469)*den(842)
  den(1224) = den(469)*den(844)
  den(1225) = den(740)*den(827)
  den(1226) = den(740)*den(830)
  den(1227) = den(745)*den(827)
  den(1228) = den(745)*den(830)
  den(1229) = den(378)*den(973)
  den(1230) = den(378)*den(975)
  den(1231) = den(389)*den(973)
  den(1232) = den(389)*den(975)
  den(1233) = den(763)*den(827)
  den(1234) = den(763)*den(830)
  den(1235) = den(768)*den(827)
  den(1236) = den(768)*den(830)
  den(1237) = den(410)*den(973)
  den(1238) = den(410)*den(975)
  den(1239) = den(507)*den(842)
  den(1240) = den(507)*den(844)
  den(1241) = den(783)*den(827)
  den(1242) = den(783)*den(830)
  den(1243) = den(788)*den(827)
  den(1244) = den(788)*den(830)
  den(1245) = den(431)*den(973)
  den(1246) = den(431)*den(975)
  den(1247) = den(528)*den(842)
  den(1248) = den(528)*den(844)
  den(1249) = den(812)*den(827)
  den(1250) = den(812)*den(830)
  den(1251) = den(807)*den(827)
  den(1252) = den(807)*den(830)
  den(1253) = den(481)*den(881)
  den(1254) = den(481)*den(883)
  den(1255) = den(469)*den(881)
  den(1256) = den(469)*den(883)
  den(1257) = den(740)*den(867)
  den(1258) = den(740)*den(869)
  den(1259) = den(745)*den(867)
  den(1260) = den(745)*den(869)
  den(1261) = den(378)*den(999)
  den(1262) = den(378)*den(1001)
  den(1263) = den(389)*den(999)
  den(1264) = den(389)*den(1001)
  den(1265) = den(763)*den(867)
  den(1266) = den(763)*den(869)
  den(1267) = den(768)*den(867)
  den(1268) = den(768)*den(869)
  den(1269) = den(410)*den(999)
  den(1270) = den(410)*den(1001)
  den(1271) = den(507)*den(881)
  den(1272) = den(507)*den(883)
  den(1273) = den(783)*den(867)
  den(1274) = den(783)*den(869)
  den(1275) = den(788)*den(867)
  den(1276) = den(788)*den(869)
  den(1277) = den(431)*den(999)
  den(1278) = den(431)*den(1001)
  den(1279) = den(528)*den(881)
  den(1280) = den(528)*den(883)
  den(1281) = den(812)*den(867)
  den(1282) = den(812)*den(869)
  den(1283) = den(807)*den(867)
  den(1284) = den(807)*den(869)
  den(1285) = den(384)*den(927)
  den(1286) = den(384)*den(929)
  den(1287) = den(372)*den(927)
  den(1288) = den(372)*den(929)
  den(1289) = den(453)*den(898)
  den(1290) = den(453)*den(901)
  den(1291) = den(460)*den(898)
  den(1292) = den(460)*den(901)
  den(1293) = den(384)*den(942)
  den(1294) = den(384)*den(944)
  den(1295) = den(372)*den(942)
  den(1296) = den(372)*den(944)
  den(1297) = den(453)*den(907)
  den(1298) = den(453)*den(909)
  den(1299) = den(460)*den(907)
  den(1300) = den(460)*den(909)
  den(1301) = den(475)*den(1033)
  den(1302) = den(475)*den(1035)
  den(1303) = den(486)*den(1033)
  den(1304) = den(486)*den(1035)
  den(1305) = den(554)*den(898)
  den(1306) = den(554)*den(901)
  den(1307) = den(562)*den(898)
  den(1308) = den(562)*den(901)
  den(1309) = den(475)*den(1043)
  den(1310) = den(475)*den(1045)
  den(1311) = den(486)*den(1043)
  den(1312) = den(486)*den(1045)
  den(1313) = den(554)*den(907)
  den(1314) = den(554)*den(909)
  den(1315) = den(562)*den(907)
  den(1316) = den(562)*den(909)
  den(1317) = den(573)*den(1033)
  den(1318) = den(573)*den(1035)
  den(1319) = den(591)*den(927)
  den(1320) = den(591)*den(929)
  den(1321) = den(637)*den(898)
  den(1322) = den(637)*den(901)
  den(1323) = den(642)*den(898)
  den(1324) = den(642)*den(901)
  den(1325) = den(573)*den(1043)
  den(1326) = den(573)*den(1045)
  den(1327) = den(591)*den(942)
  den(1328) = den(591)*den(944)
  den(1329) = den(637)*den(907)
  den(1330) = den(637)*den(909)
  den(1331) = den(642)*den(907)
  den(1332) = den(642)*den(909)
  den(1333) = den(657)*den(1033)
  den(1334) = den(657)*den(1035)
  den(1335) = den(675)*den(927)
  den(1336) = den(675)*den(929)
  den(1337) = den(726)*den(898)
  den(1338) = den(726)*den(901)
  den(1339) = den(721)*den(898)
  den(1340) = den(721)*den(901)
  den(1341) = den(657)*den(1043)
  den(1342) = den(657)*den(1045)
  den(1343) = den(675)*den(942)
  den(1344) = den(675)*den(944)
  den(1345) = den(726)*den(907)
  den(1346) = den(726)*den(909)
  den(1347) = den(721)*den(907)
  den(1348) = den(721)*den(909)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppllaaj_eexdddxdxaa_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppllaaj_eexdddxdxaa_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ down down anti-down anti-down gamma gamma -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllaaj_eexdddxdxaa_1, only: &
    & external_perm_ppllaaj_eexdddxdxaa_1, &
    & external_perm_inv_ppllaaj_eexdddxdxaa_1, &
    & extcomb_perm_ppllaaj_eexdddxdxaa_1, &
    & average_factor_ppllaaj_eexdddxdxaa_1
  use ol_external_ppllaaj_eexdddxdxaa_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppllaaj_eexdddxdxaa_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllaaj_eexdddxdxaa_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppllaaj_eexdddxdxaa_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:1-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,8)
  integer           :: extmasses2(8)
  real(REALKIND)    :: M2add(0:1-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(2), M1helarray(2,256)
  real(REALKIND)    :: P_scatt_intern(0:3,8)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2), ex8(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,31), wf8(8,84), wf16(16,314), wf32(32,76), wf64(64,56), wf256(256,896)

  type(polcont) :: A(256,896)
  complex(REALKIND) :: Aj(896)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppllaaj_eexdddxdxaa_1, 8,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppllaaj_eexdddxdxaa_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppllaaj_eexdddxdxaa_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllaaj_eexdddxdxaa_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1))
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2))
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))
  call pol_wf_V(P(:,8), rZERO, H8, ex8, POLSEL(8))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rZERO, H1, ex1, 0)
      call pol_wf_A(P(:,2), rZERO, H2, ex2, 0)
      call pol_wf_Q(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_Q(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_A(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_A(P(:,6), rZERO, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)
      call pol_wf_V(P(:,8), rZERO, H8, ex8, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)
    call helbookkeeping_flip(H8, 8, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H8, ex8, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3, ex5, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex7, ex4, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AV_Q(ntry, ex6, ex8, wf4(:,4), n3(:,4), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,3), 72, ZERO, 0_intkind1, wf4(:,5), n2(1))
  call prop_A_Q(ntry, wf4(:,4), 160, ZERO, 0_intkind1, wf4(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,5), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call vert_AV_Q(ntry, wf4(:,6), wf4(:,2), wf16(:,2), n3(:,6), t3x16(:,:,2))
  call prop_Q_A(ntry, wf16(:,1), 75, ZERO, 0_intkind1, wf16(:,3), n2(3))
  call vert_QA_Z(gZl,ntry, ex1, ex2, wf4(:,7), n3(:,7), t3x4(:,:,5))
  call prop_W_W(ntry, wf4(:,7), 3, MZ, 1_intkind1, wf4(:,8), n2(4))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,5), wf16(:,4), n3(:,8), t3x16(:,:,3))
  call prop_Q_A(ntry, wf16(:,4), 75, ZERO, 0_intkind1, wf16(:,5), n2(5))
  call vert_AV_Q(ntry, wf4(:,6), wf4(:,1), wf16(:,6), n3(:,9), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,5), wf16(:,7), n3(:,10), t3x16(:,:,5))
  call prop_A_Q(ntry, wf16(:,6), 163, ZERO, 0_intkind1, wf16(:,8), n2(6))
  call vert_AZ_Q(gZd,ntry, wf4(:,6), wf4(:,8), wf16(:,9), n3(:,11), t3x16(:,:,6))
  call prop_A_Q(ntry, wf16(:,9), 163, ZERO, 0_intkind1, wf16(:,10), n2(7))
  call vert_AV_Q(ntry, ex6, wf4(:,1), wf8(:,1), n3(:,12), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex8, wf4(:,5), wf8(:,2), n3(:,13), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 35, ZERO, 0_intkind1, wf8(:,3), n2(8))
  call prop_Q_A(ntry, wf8(:,2), 200, ZERO, 0_intkind1, wf8(:,4), n2(9))
  call vert_AV_Q(ntry, wf8(:,3), wf4(:,2), wf32(:,1), n3(:,14), t3x32(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,8), wf8(:,5), n3(:,15), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 35, ZERO, 0_intkind1, wf8(:,6), n2(10))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,2), wf32(:,2), n3(:,16), t3x32(:,:,2))
  call prop_Q_A(ntry, wf16(:,7), 92, ZERO, 0_intkind1, wf16(:,11), n2(11))
  call vert_AV_Q(ntry, wf8(:,3), ex8, wf16(:,12), n3(:,17), t3x16(:,:,7))
  call vert_AV_Q(ntry, wf8(:,6), ex8, wf16(:,13), n3(:,18), t3x16(:,:,8))
  call vert_AV_Q(ntry, ex6, wf4(:,2), wf8(:,7), n3(:,19), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 52, ZERO, 0_intkind1, wf8(:,8), n2(12))
  call vert_AV_Q(ntry, wf8(:,8), wf4(:,1), wf32(:,3), n3(:,20), t3x32(:,:,3))
  call vert_AZ_Q(gZd,ntry, wf8(:,8), wf4(:,8), wf32(:,4), n3(:,21), t3x32(:,:,4))
  call vert_AV_Q(ntry, wf8(:,8), ex8, wf16(:,14), n3(:,22), t3x16(:,:,9))
  call vert_VQ_A(ntry, ex8, ex4, wf4(:,9), n3(:,23), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex6, ex7, wf4(:,10), n3(:,24), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,9), 136, ZERO, 0_intkind1, wf4(:,11), n2(13))
  call prop_A_Q(ntry, wf4(:,10), 96, ZERO, 0_intkind1, wf4(:,12), n2(14))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,11), wf16(:,15), n3(:,25), t3x16(:,:,10))
  call vert_AV_Q(ntry, wf4(:,12), wf4(:,2), wf16(:,16), n3(:,26), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,15), 139, ZERO, 0_intkind1, wf16(:,17), n2(15))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,11), wf16(:,18), n3(:,27), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,18), 139, ZERO, 0_intkind1, wf16(:,19), n2(16))
  call vert_AV_Q(ntry, wf4(:,12), wf4(:,1), wf16(:,20), n3(:,28), t3x16(:,:,13))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,11), wf16(:,21), n3(:,29), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,20), 99, ZERO, 0_intkind1, wf16(:,22), n2(17))
  call vert_AZ_Q(gZd,ntry, wf4(:,12), wf4(:,8), wf16(:,23), n3(:,30), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,23), 99, ZERO, 0_intkind1, wf16(:,24), n2(18))
  call vert_VQ_A(ntry, wf4(:,1), ex4, wf8(:,9), n3(:,31), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 11, ZERO, 0_intkind1, wf8(:,10), n2(19))
  call prop_A_Q(ntry, wf16(:,16), 116, ZERO, 0_intkind1, wf16(:,25), n2(20))
  call vert_VQ_A(ntry, ex8, wf8(:,10), wf16(:,26), n3(:,32), t3x16(:,:,16))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex4, wf8(:,11), n3(:,33), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 11, ZERO, 0_intkind1, wf8(:,12), n2(21))
  call vert_VQ_A(ntry, ex8, wf8(:,12), wf16(:,27), n3(:,34), t3x16(:,:,17))
  call vert_AV_Q(ntry, wf4(:,12), ex8, wf8(:,13), n3(:,35), t3x8(:,:,7))
  call prop_A_Q(ntry, wf8(:,13), 224, ZERO, 0_intkind1, wf8(:,14), n2(22))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,10), wf32(:,5), n3(:,36), t3x32(:,:,5))
  call vert_VQ_A(ntry, wf4(:,2), wf8(:,12), wf32(:,6), n3(:,37), t3x32(:,:,6))
  call vert_VQ_A(ntry, wf4(:,2), ex4, wf8(:,15), n3(:,38), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,15), 28, ZERO, 0_intkind1, wf8(:,16), n2(23))
  call vert_VQ_A(ntry, ex8, wf8(:,16), wf16(:,28), n3(:,39), t3x16(:,:,18))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,16), wf32(:,7), n3(:,40), t3x32(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,16), wf32(:,8), n3(:,41), t3x32(:,:,8))
  call vert_VQ_A(ntry, ex7, wf4(:,11), wf8(:,17), n3(:,42), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,17), 200, ZERO, 0_intkind1, wf8(:,18), n2(24))
  call prop_Q_A(ntry, wf16(:,21), 156, ZERO, 0_intkind1, wf16(:,29), n2(25))
  call vert_AV_Q(ntry, wf8(:,3), ex7, wf16(:,30), n3(:,43), t3x16(:,:,19))
  call vert_AV_Q(ntry, wf8(:,6), ex7, wf16(:,31), n3(:,44), t3x16(:,:,20))
  call vert_AV_Q(ntry, wf8(:,8), ex7, wf16(:,32), n3(:,45), t3x16(:,:,21))
  call prop_A_Q(ntry, wf16(:,2), 180, ZERO, 0_intkind1, wf16(:,33), n2(26))
  call vert_VQ_A(ntry, ex7, wf8(:,10), wf16(:,34), n3(:,46), t3x16(:,:,22))
  call vert_VQ_A(ntry, ex7, wf8(:,12), wf16(:,35), n3(:,47), t3x16(:,:,23))
  call vert_AV_Q(ntry, wf4(:,6), ex7, wf8(:,19), n3(:,48), t3x8(:,:,10))
  call prop_A_Q(ntry, wf8(:,19), 224, ZERO, 0_intkind1, wf8(:,20), n2(27))
  call vert_VQ_A(ntry, ex7, wf8(:,16), wf16(:,36), n3(:,49), t3x16(:,:,24))
  call prop_Q_A(ntry, wf16(:,34), 75, ZERO, 0_intkind1, wf16(:,37), n2(28))
  call prop_Q_A(ntry, wf16(:,35), 75, ZERO, 0_intkind1, wf16(:,38), n2(29))
  call prop_A_Q(ntry, wf16(:,32), 116, ZERO, 0_intkind1, wf16(:,39), n2(30))
  call prop_Q_A(ntry, wf16(:,36), 92, ZERO, 0_intkind1, wf16(:,40), n2(31))
  call prop_A_Q(ntry, wf16(:,30), 99, ZERO, 0_intkind1, wf16(:,41), n2(32))
  call prop_A_Q(ntry, wf16(:,31), 99, ZERO, 0_intkind1, wf16(:,42), n2(33))
  call vert_VQ_A(ntry, ex7, ex3, wf4(:,13), n3(:,50), t3x4(:,:,8))
  call vert_QA_V(ntry, ex4, ex5, wf4(:,14), n3(:,51), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,13), 68, ZERO, 0_intkind1, wf4(:,15), n2(34))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,15), wf16(:,43), n3(:,52), t3x16(:,:,25))
  call vert_AV_Q(ntry, wf4(:,6), wf4(:,14), wf16(:,44), n3(:,53), t3x16(:,:,26))
  call prop_Q_A(ntry, wf16(:,43), 71, ZERO, 0_intkind1, wf16(:,45), n2(35))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,15), wf16(:,46), n3(:,54), t3x16(:,:,27))
  call prop_Q_A(ntry, wf16(:,46), 71, ZERO, 0_intkind1, wf16(:,47), n2(36))
  call vert_VQ_A(ntry, wf4(:,14), wf4(:,15), wf16(:,48), n3(:,55), t3x16(:,:,28))
  call vert_VQ_A(ntry, ex8, wf4(:,15), wf8(:,21), n3(:,56), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,21), 196, ZERO, 0_intkind1, wf8(:,22), n2(37))
  call vert_AV_Q(ntry, wf8(:,3), wf4(:,14), wf32(:,9), n3(:,57), t3x32(:,:,9))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,14), wf32(:,10), n3(:,58), t3x32(:,:,10))
  call prop_Q_A(ntry, wf16(:,48), 92, ZERO, 0_intkind1, wf16(:,49), n2(38))
  call vert_AV_Q(ntry, ex6, wf4(:,14), wf8(:,23), n3(:,59), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,23), 56, ZERO, 0_intkind1, wf8(:,24), n2(39))
  call vert_AV_Q(ntry, wf8(:,24), wf4(:,1), wf32(:,11), n3(:,60), t3x32(:,:,11))
  call vert_AZ_Q(gZd,ntry, wf8(:,24), wf4(:,8), wf32(:,12), n3(:,61), t3x32(:,:,12))
  call vert_AV_Q(ntry, wf8(:,24), ex8, wf16(:,50), n3(:,62), t3x16(:,:,29))
  call vert_VQ_A(ntry, ex8, ex3, wf4(:,16), n3(:,63), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,16), 132, ZERO, 0_intkind1, wf4(:,17), n2(40))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,17), wf16(:,51), n3(:,64), t3x16(:,:,30))
  call vert_AV_Q(ntry, wf4(:,12), wf4(:,14), wf16(:,52), n3(:,65), t3x16(:,:,31))
  call prop_Q_A(ntry, wf16(:,51), 135, ZERO, 0_intkind1, wf16(:,53), n2(41))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf4(:,17), wf16(:,54), n3(:,66), t3x16(:,:,32))
  call prop_Q_A(ntry, wf16(:,54), 135, ZERO, 0_intkind1, wf16(:,55), n2(42))
  call vert_VQ_A(ntry, wf4(:,14), wf4(:,17), wf16(:,56), n3(:,67), t3x16(:,:,33))
  call vert_VQ_A(ntry, wf4(:,1), ex3, wf8(:,25), n3(:,68), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,25), 7, ZERO, 0_intkind1, wf8(:,26), n2(43))
  call prop_A_Q(ntry, wf16(:,52), 120, ZERO, 0_intkind1, wf16(:,57), n2(44))
  call vert_VQ_A(ntry, ex8, wf8(:,26), wf16(:,58), n3(:,69), t3x16(:,:,34))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex3, wf8(:,27), n3(:,70), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,27), 7, ZERO, 0_intkind1, wf8(:,28), n2(45))
  call vert_VQ_A(ntry, ex8, wf8(:,28), wf16(:,59), n3(:,71), t3x16(:,:,35))
  call vert_VQ_A(ntry, wf4(:,14), wf8(:,26), wf32(:,13), n3(:,72), t3x32(:,:,13))
  call vert_VQ_A(ntry, wf4(:,14), wf8(:,28), wf32(:,14), n3(:,73), t3x32(:,:,14))
  call vert_VQ_A(ntry, wf4(:,14), ex3, wf8(:,29), n3(:,74), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,29), 28, ZERO, 0_intkind1, wf8(:,30), n2(46))
  call vert_VQ_A(ntry, ex8, wf8(:,30), wf16(:,60), n3(:,75), t3x16(:,:,36))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,30), wf32(:,15), n3(:,76), t3x32(:,:,15))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,30), wf32(:,16), n3(:,77), t3x32(:,:,16))
  call vert_VQ_A(ntry, ex7, wf4(:,17), wf8(:,31), n3(:,78), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,31), 196, ZERO, 0_intkind1, wf8(:,32), n2(47))
  call prop_Q_A(ntry, wf16(:,56), 156, ZERO, 0_intkind1, wf16(:,61), n2(48))
  call vert_AV_Q(ntry, wf8(:,24), ex7, wf16(:,62), n3(:,79), t3x16(:,:,37))
  call prop_A_Q(ntry, wf16(:,44), 184, ZERO, 0_intkind1, wf16(:,63), n2(49))
  call vert_VQ_A(ntry, ex7, wf8(:,26), wf16(:,64), n3(:,80), t3x16(:,:,38))
  call vert_VQ_A(ntry, ex7, wf8(:,28), wf16(:,65), n3(:,81), t3x16(:,:,39))
  call vert_VQ_A(ntry, ex7, wf8(:,30), wf16(:,66), n3(:,82), t3x16(:,:,40))
  call prop_Q_A(ntry, wf16(:,64), 71, ZERO, 0_intkind1, wf16(:,67), n2(50))
  call prop_Q_A(ntry, wf16(:,65), 71, ZERO, 0_intkind1, wf16(:,68), n2(51))
  call prop_A_Q(ntry, wf16(:,62), 120, ZERO, 0_intkind1, wf16(:,69), n2(52))
  call prop_Q_A(ntry, wf16(:,66), 92, ZERO, 0_intkind1, wf16(:,70), n2(53))
  call vert_QA_V(ntry, ex3, ex6, wf4(:,18), n3(:,83), t3x4(:,:,11))
  call vert_AV_Q(ntry, ex5, ex8, wf4(:,19), n3(:,84), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,19), 144, ZERO, 0_intkind1, wf4(:,20), n2(54))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,18), wf16(:,71), n3(:,85), t3x16(:,:,41))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,1), wf16(:,72), n3(:,86), t3x16(:,:,42))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,5), wf16(:,73), n3(:,87), t3x16(:,:,43))
  call prop_A_Q(ntry, wf16(:,72), 147, ZERO, 0_intkind1, wf16(:,74), n2(55))
  call vert_AZ_Q(gZd,ntry, wf4(:,20), wf4(:,8), wf16(:,75), n3(:,88), t3x16(:,:,44))
  call prop_A_Q(ntry, wf16(:,75), 147, ZERO, 0_intkind1, wf16(:,76), n2(56))
  call vert_AV_Q(ntry, ex5, wf4(:,1), wf8(:,33), n3(:,89), t3x8(:,:,17))
  call prop_A_Q(ntry, wf8(:,33), 19, ZERO, 0_intkind1, wf8(:,34), n2(57))
  call vert_AV_Q(ntry, wf8(:,34), wf4(:,18), wf32(:,17), n3(:,90), t3x32(:,:,17))
  call vert_AZ_Q(gZd,ntry, ex5, wf4(:,8), wf8(:,35), n3(:,91), t3x8(:,:,18))
  call prop_A_Q(ntry, wf8(:,35), 19, ZERO, 0_intkind1, wf8(:,36), n2(58))
  call vert_AV_Q(ntry, wf8(:,36), wf4(:,18), wf32(:,18), n3(:,92), t3x32(:,:,18))
  call prop_Q_A(ntry, wf16(:,73), 108, ZERO, 0_intkind1, wf16(:,77), n2(59))
  call vert_AV_Q(ntry, wf8(:,34), ex8, wf16(:,78), n3(:,93), t3x16(:,:,45))
  call vert_AV_Q(ntry, wf8(:,36), ex8, wf16(:,79), n3(:,94), t3x16(:,:,46))
  call vert_AV_Q(ntry, ex5, wf4(:,18), wf8(:,37), n3(:,95), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,37), 52, ZERO, 0_intkind1, wf8(:,38), n2(60))
  call vert_AV_Q(ntry, wf8(:,38), wf4(:,1), wf32(:,19), n3(:,96), t3x32(:,:,19))
  call vert_AZ_Q(gZd,ntry, wf8(:,38), wf4(:,8), wf32(:,20), n3(:,97), t3x32(:,:,20))
  call vert_AV_Q(ntry, wf8(:,38), ex8, wf16(:,80), n3(:,98), t3x16(:,:,47))
  call vert_AV_Q(ntry, ex5, ex7, wf4(:,21), n3(:,99), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,21), 80, ZERO, 0_intkind1, wf4(:,22), n2(61))
  call vert_AV_Q(ntry, wf4(:,22), wf4(:,18), wf16(:,81), n3(:,100), t3x16(:,:,48))
  call vert_AV_Q(ntry, wf4(:,22), wf4(:,1), wf16(:,82), n3(:,101), t3x16(:,:,49))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,11), wf16(:,83), n3(:,102), t3x16(:,:,50))
  call prop_A_Q(ntry, wf16(:,82), 83, ZERO, 0_intkind1, wf16(:,84), n2(62))
  call vert_AZ_Q(gZd,ntry, wf4(:,22), wf4(:,8), wf16(:,85), n3(:,103), t3x16(:,:,51))
  call prop_A_Q(ntry, wf16(:,85), 83, ZERO, 0_intkind1, wf16(:,86), n2(63))
  call prop_A_Q(ntry, wf16(:,81), 116, ZERO, 0_intkind1, wf16(:,87), n2(64))
  call vert_AV_Q(ntry, wf4(:,22), ex8, wf8(:,39), n3(:,104), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,39), 208, ZERO, 0_intkind1, wf8(:,40), n2(65))
  call vert_VQ_A(ntry, wf4(:,18), wf8(:,10), wf32(:,21), n3(:,105), t3x32(:,:,21))
  call vert_VQ_A(ntry, wf4(:,18), wf8(:,12), wf32(:,22), n3(:,106), t3x32(:,:,22))
  call vert_VQ_A(ntry, wf4(:,18), ex4, wf8(:,41), n3(:,107), t3x8(:,:,21))
  call prop_Q_A(ntry, wf8(:,41), 44, ZERO, 0_intkind1, wf8(:,42), n2(66))
  call vert_VQ_A(ntry, ex8, wf8(:,42), wf16(:,88), n3(:,108), t3x16(:,:,52))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,42), wf32(:,23), n3(:,109), t3x32(:,:,23))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,42), wf32(:,24), n3(:,110), t3x32(:,:,24))
  call prop_Q_A(ntry, wf16(:,83), 172, ZERO, 0_intkind1, wf16(:,89), n2(67))
  call vert_AV_Q(ntry, wf8(:,34), ex7, wf16(:,90), n3(:,111), t3x16(:,:,53))
  call vert_AV_Q(ntry, wf8(:,36), ex7, wf16(:,91), n3(:,112), t3x16(:,:,54))
  call vert_AV_Q(ntry, wf8(:,38), ex7, wf16(:,92), n3(:,113), t3x16(:,:,55))
  call prop_A_Q(ntry, wf16(:,71), 180, ZERO, 0_intkind1, wf16(:,93), n2(68))
  call vert_AV_Q(ntry, wf4(:,20), ex7, wf8(:,43), n3(:,114), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,43), 208, ZERO, 0_intkind1, wf8(:,44), n2(69))
  call vert_VQ_A(ntry, ex7, wf8(:,42), wf16(:,94), n3(:,115), t3x16(:,:,56))
  call prop_A_Q(ntry, wf16(:,92), 116, ZERO, 0_intkind1, wf16(:,95), n2(70))
  call prop_Q_A(ntry, wf16(:,94), 108, ZERO, 0_intkind1, wf16(:,96), n2(71))
  call prop_A_Q(ntry, wf16(:,90), 83, ZERO, 0_intkind1, wf16(:,97), n2(72))
  call prop_A_Q(ntry, wf16(:,91), 83, ZERO, 0_intkind1, wf16(:,98), n2(73))
  call vert_QA_V(ntry, ex4, ex6, wf4(:,23), n3(:,116), t3x4(:,:,14))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,23), wf16(:,99), n3(:,117), t3x16(:,:,57))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,15), wf16(:,100), n3(:,118), t3x16(:,:,58))
  call vert_AV_Q(ntry, wf8(:,34), wf4(:,23), wf32(:,25), n3(:,119), t3x32(:,:,25))
  call vert_AV_Q(ntry, wf8(:,36), wf4(:,23), wf32(:,26), n3(:,120), t3x32(:,:,26))
  call prop_Q_A(ntry, wf16(:,100), 108, ZERO, 0_intkind1, wf16(:,101), n2(74))
  call vert_AV_Q(ntry, ex5, wf4(:,23), wf8(:,45), n3(:,121), t3x8(:,:,23))
  call prop_A_Q(ntry, wf8(:,45), 56, ZERO, 0_intkind1, wf8(:,46), n2(75))
  call vert_AV_Q(ntry, wf8(:,46), wf4(:,1), wf32(:,27), n3(:,122), t3x32(:,:,27))
  call vert_AZ_Q(gZd,ntry, wf8(:,46), wf4(:,8), wf32(:,28), n3(:,123), t3x32(:,:,28))
  call vert_AV_Q(ntry, wf8(:,46), ex8, wf16(:,102), n3(:,124), t3x16(:,:,59))
  call vert_AV_Q(ntry, wf4(:,22), wf4(:,23), wf16(:,103), n3(:,125), t3x16(:,:,60))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,17), wf16(:,104), n3(:,126), t3x16(:,:,61))
  call prop_A_Q(ntry, wf16(:,103), 120, ZERO, 0_intkind1, wf16(:,105), n2(76))
  call vert_VQ_A(ntry, wf4(:,23), wf8(:,26), wf32(:,29), n3(:,127), t3x32(:,:,29))
  call vert_VQ_A(ntry, wf4(:,23), wf8(:,28), wf32(:,30), n3(:,128), t3x32(:,:,30))
  call vert_VQ_A(ntry, wf4(:,23), ex3, wf8(:,47), n3(:,129), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,47), 44, ZERO, 0_intkind1, wf8(:,48), n2(77))
  call vert_VQ_A(ntry, ex8, wf8(:,48), wf16(:,106), n3(:,130), t3x16(:,:,62))
  call vert_VQ_A(ntry, wf4(:,1), wf8(:,48), wf32(:,31), n3(:,131), t3x32(:,:,31))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf8(:,48), wf32(:,32), n3(:,132), t3x32(:,:,32))
  call prop_Q_A(ntry, wf16(:,104), 172, ZERO, 0_intkind1, wf16(:,107), n2(78))
  call vert_AV_Q(ntry, wf8(:,46), ex7, wf16(:,108), n3(:,133), t3x16(:,:,63))
  call prop_A_Q(ntry, wf16(:,99), 184, ZERO, 0_intkind1, wf16(:,109), n2(79))
  call vert_VQ_A(ntry, ex7, wf8(:,48), wf16(:,110), n3(:,134), t3x16(:,:,64))
  call prop_A_Q(ntry, wf16(:,108), 120, ZERO, 0_intkind1, wf16(:,111), n2(80))
  call prop_Q_A(ntry, wf16(:,110), 108, ZERO, 0_intkind1, wf16(:,112), n2(81))
  call vert_QA_V(ntry, wf4(:,15), ex6, wf8(:,49), n3(:,135), t3x8(:,:,25))
  call vert_QA_V(ntry, wf4(:,11), wf8(:,34), wf32(:,33), n3(:,136), t3x32(:,:,33))
  call vert_QA_V(ntry, wf4(:,11), wf8(:,36), wf32(:,34), n3(:,137), t3x32(:,:,34))
  call vert_QA_V(ntry, wf4(:,11), ex6, wf8(:,50), n3(:,138), t3x8(:,:,26))
  call vert_QA_V(ntry, wf4(:,15), wf8(:,34), wf32(:,35), n3(:,139), t3x32(:,:,35))
  call vert_QA_V(ntry, wf4(:,15), wf8(:,36), wf32(:,36), n3(:,140), t3x32(:,:,36))
  call vert_QA_V(ntry, wf4(:,15), ex5, wf8(:,51), n3(:,141), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf8(:,51), wf4(:,11), wf32(:,37), n3(:,142), t3x32(:,:,37))
  call vert_QA_V(ntry, wf4(:,11), ex5, wf8(:,52), n3(:,143), t3x8(:,:,28))
  call vert_VQ_A(ntry, wf8(:,52), wf4(:,15), wf32(:,38), n3(:,144), t3x32(:,:,38))
  call vert_AV_Q(ntry, ex6, wf8(:,51), wf16(:,113), n3(:,145), t3x16(:,:,65))
  call vert_AV_Q(ntry, ex5, wf8(:,49), wf16(:,114), n3(:,146), t3x16(:,:,66))
  call vert_AV_Q(ntry, ex6, wf8(:,52), wf16(:,115), n3(:,147), t3x16(:,:,67))
  call vert_AV_Q(ntry, ex5, wf8(:,50), wf16(:,116), n3(:,148), t3x16(:,:,68))
  call vert_QA_V(ntry, wf8(:,10), wf4(:,20), wf32(:,39), n3(:,149), t3x32(:,:,39))
  call vert_QA_V(ntry, wf8(:,12), wf4(:,20), wf32(:,40), n3(:,150), t3x32(:,:,40))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,20), wf16(:,117), n3(:,151), t3x16(:,:,69))
  call vert_QA_V(ntry, wf8(:,10), ex6, wf16(:,118), n3(:,152), t3x16(:,:,70))
  call vert_QA_V(ntry, wf8(:,12), ex6, wf16(:,119), n3(:,153), t3x16(:,:,71))
  call vert_QA_V(ntry, ex4, wf4(:,20), wf8(:,53), n3(:,154), t3x8(:,:,29))
  call vert_VQ_A(ntry, wf8(:,53), wf4(:,15), wf32(:,41), n3(:,155), t3x32(:,:,41))
  call vert_QA_V(ntry, ex4, wf8(:,3), wf16(:,120), n3(:,156), t3x16(:,:,72))
  call vert_QA_V(ntry, ex4, wf8(:,6), wf16(:,121), n3(:,157), t3x16(:,:,73))
  call vert_VQ_A(ntry, wf8(:,49), ex4, wf16(:,122), n3(:,158), t3x16(:,:,74))
  call vert_AV_Q(ntry, ex6, wf8(:,53), wf16(:,123), n3(:,159), t3x16(:,:,75))
  call vert_VQ_A(ntry, wf8(:,51), wf8(:,10), wf64(:,1), n3(:,160), t3x64(:,:,1))
  call vert_VQ_A(ntry, wf8(:,51), wf8(:,12), wf64(:,2), n3(:,161), t3x64(:,:,2))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,6), wf16(:,124), n3(:,162), t3x16(:,:,76))
  call vert_QA_V(ntry, wf8(:,10), ex5, wf16(:,125), n3(:,163), t3x16(:,:,77))
  call vert_QA_V(ntry, wf8(:,12), ex5, wf16(:,126), n3(:,164), t3x16(:,:,78))
  call vert_QA_V(ntry, ex4, wf8(:,34), wf16(:,127), n3(:,165), t3x16(:,:,79))
  call vert_QA_V(ntry, ex4, wf8(:,36), wf16(:,128), n3(:,166), t3x16(:,:,80))
  call vert_QA_V(ntry, ex4, wf4(:,6), wf8(:,54), n3(:,167), t3x8(:,:,30))
  call vert_VQ_A(ntry, wf8(:,54), wf4(:,15), wf32(:,42), n3(:,168), t3x32(:,:,42))
  call vert_VQ_A(ntry, wf8(:,51), ex4, wf16(:,129), n3(:,169), t3x16(:,:,81))
  call vert_AV_Q(ntry, ex5, wf8(:,54), wf16(:,130), n3(:,170), t3x16(:,:,82))
  call prop_A_Q(ntry, wf16(:,113), 116, ZERO, 0_intkind1, wf16(:,131), n2(82))
  call prop_A_Q(ntry, wf16(:,114), 116, ZERO, 0_intkind1, wf16(:,132), n2(83))
  call vert_QA_V(ntry, wf8(:,22), ex6, wf16(:,133), n3(:,171), t3x16(:,:,83))
  call vert_QA_V(ntry, wf8(:,22), ex5, wf16(:,134), n3(:,172), t3x16(:,:,84))
  call prop_Q_A(ntry, wf16(:,122), 108, ZERO, 0_intkind1, wf16(:,135), n2(84))
  call prop_Q_A(ntry, wf16(:,129), 92, ZERO, 0_intkind1, wf16(:,136), n2(85))
  call vert_QA_V(ntry, wf4(:,17), ex6, wf8(:,55), n3(:,173), t3x8(:,:,31))
  call vert_QA_V(ntry, wf4(:,5), wf8(:,34), wf32(:,43), n3(:,174), t3x32(:,:,43))
  call vert_QA_V(ntry, wf4(:,5), wf8(:,36), wf32(:,44), n3(:,175), t3x32(:,:,44))
  call vert_QA_V(ntry, wf4(:,5), ex6, wf8(:,56), n3(:,176), t3x8(:,:,32))
  call vert_QA_V(ntry, wf4(:,17), wf8(:,34), wf32(:,45), n3(:,177), t3x32(:,:,45))
  call vert_QA_V(ntry, wf4(:,17), wf8(:,36), wf32(:,46), n3(:,178), t3x32(:,:,46))
  call vert_QA_V(ntry, wf4(:,17), ex5, wf8(:,57), n3(:,179), t3x8(:,:,33))
  call vert_VQ_A(ntry, wf8(:,57), wf4(:,5), wf32(:,47), n3(:,180), t3x32(:,:,47))
  call vert_QA_V(ntry, wf4(:,5), ex5, wf8(:,58), n3(:,181), t3x8(:,:,34))
  call vert_VQ_A(ntry, wf8(:,58), wf4(:,17), wf32(:,48), n3(:,182), t3x32(:,:,48))
  call vert_AV_Q(ntry, ex6, wf8(:,57), wf16(:,137), n3(:,183), t3x16(:,:,85))
  call vert_AV_Q(ntry, ex5, wf8(:,55), wf16(:,138), n3(:,184), t3x16(:,:,86))
  call vert_AV_Q(ntry, ex6, wf8(:,58), wf16(:,139), n3(:,185), t3x16(:,:,87))
  call vert_AV_Q(ntry, ex5, wf8(:,56), wf16(:,140), n3(:,186), t3x16(:,:,88))
  call vert_QA_V(ntry, wf4(:,5), wf4(:,20), wf16(:,141), n3(:,187), t3x16(:,:,89))
  call vert_QA_V(ntry, wf8(:,26), ex6, wf16(:,142), n3(:,188), t3x16(:,:,90))
  call vert_QA_V(ntry, wf8(:,28), ex6, wf16(:,143), n3(:,189), t3x16(:,:,91))
  call vert_QA_V(ntry, wf8(:,26), wf4(:,20), wf32(:,49), n3(:,190), t3x32(:,:,49))
  call vert_QA_V(ntry, wf8(:,28), wf4(:,20), wf32(:,50), n3(:,191), t3x32(:,:,50))
  call vert_QA_V(ntry, ex3, wf4(:,20), wf8(:,59), n3(:,192), t3x8(:,:,35))
  call vert_VQ_A(ntry, wf8(:,59), wf4(:,5), wf32(:,51), n3(:,193), t3x32(:,:,51))
  call vert_QA_V(ntry, ex3, wf8(:,3), wf16(:,144), n3(:,194), t3x16(:,:,92))
  call vert_QA_V(ntry, ex3, wf8(:,6), wf16(:,145), n3(:,195), t3x16(:,:,93))
  call vert_AV_Q(ntry, ex6, wf8(:,59), wf16(:,146), n3(:,196), t3x16(:,:,94))
  call vert_VQ_A(ntry, wf8(:,56), ex3, wf16(:,147), n3(:,197), t3x16(:,:,95))
  call vert_QA_V(ntry, wf4(:,5), wf4(:,6), wf16(:,148), n3(:,198), t3x16(:,:,96))
  call vert_QA_V(ntry, wf8(:,26), ex5, wf16(:,149), n3(:,199), t3x16(:,:,97))
  call vert_QA_V(ntry, wf8(:,28), ex5, wf16(:,150), n3(:,200), t3x16(:,:,98))
  call vert_VQ_A(ntry, wf8(:,58), wf8(:,26), wf64(:,3), n3(:,201), t3x64(:,:,3))
  call vert_VQ_A(ntry, wf8(:,58), wf8(:,28), wf64(:,4), n3(:,202), t3x64(:,:,4))
  call vert_QA_V(ntry, ex3, wf8(:,34), wf16(:,151), n3(:,203), t3x16(:,:,99))
  call vert_QA_V(ntry, ex3, wf8(:,36), wf16(:,152), n3(:,204), t3x16(:,:,100))
  call vert_QA_V(ntry, ex3, wf4(:,6), wf8(:,60), n3(:,205), t3x8(:,:,36))
  call vert_VQ_A(ntry, wf8(:,60), wf4(:,5), wf32(:,52), n3(:,206), t3x32(:,:,52))
  call vert_AV_Q(ntry, ex5, wf8(:,60), wf16(:,153), n3(:,207), t3x16(:,:,101))
  call vert_VQ_A(ntry, wf8(:,58), ex3, wf16(:,154), n3(:,208), t3x16(:,:,102))
  call vert_QA_V(ntry, wf8(:,4), ex6, wf16(:,155), n3(:,209), t3x16(:,:,103))
  call vert_QA_V(ntry, wf8(:,4), ex5, wf16(:,156), n3(:,210), t3x16(:,:,104))
  call prop_A_Q(ntry, wf16(:,139), 120, ZERO, 0_intkind1, wf16(:,157), n2(86))
  call prop_A_Q(ntry, wf16(:,140), 120, ZERO, 0_intkind1, wf16(:,158), n2(87))
  call prop_Q_A(ntry, wf16(:,147), 108, ZERO, 0_intkind1, wf16(:,159), n2(88))
  call prop_Q_A(ntry, wf16(:,154), 92, ZERO, 0_intkind1, wf16(:,160), n2(89))
  call vert_QA_V(ntry, wf8(:,10), wf4(:,22), wf32(:,53), n3(:,211), t3x32(:,:,53))
  call vert_QA_V(ntry, wf8(:,12), wf4(:,22), wf32(:,54), n3(:,212), t3x32(:,:,54))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,22), wf16(:,161), n3(:,213), t3x16(:,:,105))
  call vert_QA_V(ntry, ex4, wf4(:,22), wf8(:,61), n3(:,214), t3x8(:,:,37))
  call vert_VQ_A(ntry, wf8(:,61), wf4(:,17), wf32(:,55), n3(:,215), t3x32(:,:,55))
  call vert_VQ_A(ntry, wf8(:,55), ex4, wf16(:,162), n3(:,216), t3x16(:,:,106))
  call vert_AV_Q(ntry, ex6, wf8(:,61), wf16(:,163), n3(:,217), t3x16(:,:,107))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,22), wf16(:,164), n3(:,218), t3x16(:,:,108))
  call vert_QA_V(ntry, wf8(:,26), wf4(:,22), wf32(:,56), n3(:,219), t3x32(:,:,56))
  call vert_QA_V(ntry, wf8(:,28), wf4(:,22), wf32(:,57), n3(:,220), t3x32(:,:,57))
  call vert_QA_V(ntry, ex3, wf4(:,22), wf8(:,62), n3(:,221), t3x8(:,:,38))
  call vert_VQ_A(ntry, wf8(:,62), wf4(:,11), wf32(:,58), n3(:,222), t3x32(:,:,58))
  call vert_AV_Q(ntry, ex6, wf8(:,62), wf16(:,165), n3(:,223), t3x16(:,:,109))
  call vert_VQ_A(ntry, wf8(:,50), ex3, wf16(:,166), n3(:,224), t3x16(:,:,110))
  call vert_VQ_A(ntry, wf8(:,61), wf8(:,26), wf64(:,5), n3(:,225), t3x64(:,:,5))
  call vert_VQ_A(ntry, wf8(:,61), wf8(:,28), wf64(:,6), n3(:,226), t3x64(:,:,6))
  call vert_VQ_A(ntry, wf8(:,54), wf8(:,26), wf64(:,7), n3(:,227), t3x64(:,:,7))
  call vert_VQ_A(ntry, wf8(:,54), wf8(:,28), wf64(:,8), n3(:,228), t3x64(:,:,8))
  call vert_VQ_A(ntry, wf8(:,62), wf8(:,10), wf64(:,9), n3(:,229), t3x64(:,:,9))
  call vert_VQ_A(ntry, wf8(:,62), wf8(:,12), wf64(:,10), n3(:,230), t3x64(:,:,10))
  call vert_VQ_A(ntry, wf8(:,60), wf8(:,10), wf64(:,11), n3(:,231), t3x64(:,:,11))
  call vert_VQ_A(ntry, wf8(:,60), wf8(:,12), wf64(:,12), n3(:,232), t3x64(:,:,12))
  call vert_VQ_A(ntry, wf8(:,62), ex4, wf16(:,167), n3(:,233), t3x16(:,:,111))
  call vert_VQ_A(ntry, wf8(:,60), ex4, wf16(:,168), n3(:,234), t3x16(:,:,112))
  call vert_VQ_A(ntry, wf8(:,61), ex3, wf16(:,169), n3(:,235), t3x16(:,:,113))
  call vert_VQ_A(ntry, wf8(:,54), ex3, wf16(:,170), n3(:,236), t3x16(:,:,114))
  call vert_QA_V(ntry, ex4, wf8(:,40), wf16(:,171), n3(:,237), t3x16(:,:,115))
  call prop_A_Q(ntry, wf16(:,163), 120, ZERO, 0_intkind1, wf16(:,172), n2(90))
  call prop_A_Q(ntry, wf16(:,165), 116, ZERO, 0_intkind1, wf16(:,173), n2(91))
  call vert_QA_V(ntry, ex3, wf8(:,40), wf16(:,174), n3(:,238), t3x16(:,:,116))
  call prop_Q_A(ntry, wf16(:,167), 92, ZERO, 0_intkind1, wf16(:,175), n2(92))
  call prop_Q_A(ntry, wf16(:,169), 92, ZERO, 0_intkind1, wf16(:,176), n2(93))
  call vert_VQ_A(ntry, wf8(:,57), wf8(:,10), wf64(:,13), n3(:,239), t3x64(:,:,13))
  call vert_VQ_A(ntry, wf8(:,57), wf8(:,12), wf64(:,14), n3(:,240), t3x64(:,:,14))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,12), wf16(:,177), n3(:,241), t3x16(:,:,117))
  call vert_QA_V(ntry, ex4, wf4(:,12), wf8(:,63), n3(:,242), t3x8(:,:,39))
  call vert_VQ_A(ntry, wf8(:,63), wf4(:,17), wf32(:,59), n3(:,243), t3x32(:,:,59))
  call vert_VQ_A(ntry, wf8(:,57), ex4, wf16(:,178), n3(:,244), t3x16(:,:,118))
  call vert_AV_Q(ntry, ex5, wf8(:,63), wf16(:,179), n3(:,245), t3x16(:,:,119))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,12), wf16(:,180), n3(:,246), t3x16(:,:,120))
  call vert_VQ_A(ntry, wf8(:,52), wf8(:,26), wf64(:,15), n3(:,247), t3x64(:,:,15))
  call vert_VQ_A(ntry, wf8(:,52), wf8(:,28), wf64(:,16), n3(:,248), t3x64(:,:,16))
  call vert_QA_V(ntry, ex3, wf4(:,12), wf8(:,64), n3(:,249), t3x8(:,:,40))
  call vert_VQ_A(ntry, wf8(:,64), wf4(:,11), wf32(:,60), n3(:,250), t3x32(:,:,60))
  call vert_AV_Q(ntry, ex5, wf8(:,64), wf16(:,181), n3(:,251), t3x16(:,:,121))
  call vert_VQ_A(ntry, wf8(:,52), ex3, wf16(:,182), n3(:,252), t3x16(:,:,122))
  call vert_VQ_A(ntry, wf8(:,53), wf8(:,26), wf64(:,17), n3(:,253), t3x64(:,:,17))
  call vert_VQ_A(ntry, wf8(:,53), wf8(:,28), wf64(:,18), n3(:,254), t3x64(:,:,18))
  call vert_VQ_A(ntry, wf8(:,63), wf8(:,26), wf64(:,19), n3(:,255), t3x64(:,:,19))
  call vert_VQ_A(ntry, wf8(:,63), wf8(:,28), wf64(:,20), n3(:,256), t3x64(:,:,20))
  call vert_VQ_A(ntry, wf8(:,59), wf8(:,10), wf64(:,21), n3(:,257), t3x64(:,:,21))
  call vert_VQ_A(ntry, wf8(:,59), wf8(:,12), wf64(:,22), n3(:,258), t3x64(:,:,22))
  call vert_VQ_A(ntry, wf8(:,64), wf8(:,10), wf64(:,23), n3(:,259), t3x64(:,:,23))
  call vert_VQ_A(ntry, wf8(:,64), wf8(:,12), wf64(:,24), n3(:,260), t3x64(:,:,24))
  call vert_VQ_A(ntry, wf8(:,59), ex4, wf16(:,183), n3(:,261), t3x16(:,:,123))
  call vert_VQ_A(ntry, wf8(:,64), ex4, wf16(:,184), n3(:,262), t3x16(:,:,124))
  call vert_VQ_A(ntry, wf8(:,53), ex3, wf16(:,185), n3(:,263), t3x16(:,:,125))
  call vert_VQ_A(ntry, wf8(:,63), ex3, wf16(:,186), n3(:,264), t3x16(:,:,126))
  call vert_QA_V(ntry, ex4, wf8(:,14), wf16(:,187), n3(:,265), t3x16(:,:,127))
  call prop_A_Q(ntry, wf16(:,179), 120, ZERO, 0_intkind1, wf16(:,188), n2(94))
  call prop_A_Q(ntry, wf16(:,181), 116, ZERO, 0_intkind1, wf16(:,189), n2(95))
  call vert_QA_V(ntry, ex3, wf8(:,14), wf16(:,190), n3(:,266), t3x16(:,:,128))
  call prop_Q_A(ntry, wf16(:,184), 108, ZERO, 0_intkind1, wf16(:,191), n2(96))
  call prop_Q_A(ntry, wf16(:,186), 108, ZERO, 0_intkind1, wf16(:,192), n2(97))
  call prop_A_Q(ntry, wf16(:,137), 180, ZERO, 0_intkind1, wf16(:,193), n2(98))
  call prop_A_Q(ntry, wf16(:,138), 180, ZERO, 0_intkind1, wf16(:,194), n2(99))
  call vert_QA_V(ntry, wf8(:,32), ex6, wf16(:,195), n3(:,267), t3x16(:,:,129))
  call vert_QA_V(ntry, wf8(:,32), ex5, wf16(:,196), n3(:,268), t3x16(:,:,130))
  call prop_Q_A(ntry, wf16(:,162), 172, ZERO, 0_intkind1, wf16(:,197), n2(100))
  call prop_Q_A(ntry, wf16(:,178), 156, ZERO, 0_intkind1, wf16(:,198), n2(101))
  call vert_QA_V(ntry, wf8(:,18), ex6, wf16(:,199), n3(:,269), t3x16(:,:,131))
  call vert_QA_V(ntry, wf8(:,18), ex5, wf16(:,200), n3(:,270), t3x16(:,:,132))
  call prop_A_Q(ntry, wf16(:,115), 184, ZERO, 0_intkind1, wf16(:,201), n2(102))
  call prop_A_Q(ntry, wf16(:,116), 184, ZERO, 0_intkind1, wf16(:,202), n2(103))
  call prop_Q_A(ntry, wf16(:,166), 172, ZERO, 0_intkind1, wf16(:,203), n2(104))
  call prop_Q_A(ntry, wf16(:,182), 156, ZERO, 0_intkind1, wf16(:,204), n2(105))
  call vert_QA_V(ntry, ex4, wf8(:,44), wf16(:,205), n3(:,271), t3x16(:,:,133))
  call prop_A_Q(ntry, wf16(:,123), 184, ZERO, 0_intkind1, wf16(:,206), n2(106))
  call prop_A_Q(ntry, wf16(:,146), 180, ZERO, 0_intkind1, wf16(:,207), n2(107))
  call vert_QA_V(ntry, ex3, wf8(:,44), wf16(:,208), n3(:,272), t3x16(:,:,134))
  call prop_Q_A(ntry, wf16(:,183), 156, ZERO, 0_intkind1, wf16(:,209), n2(108))
  call prop_Q_A(ntry, wf16(:,185), 156, ZERO, 0_intkind1, wf16(:,210), n2(109))
  call vert_QA_V(ntry, ex4, wf8(:,20), wf16(:,211), n3(:,273), t3x16(:,:,135))
  call prop_A_Q(ntry, wf16(:,130), 184, ZERO, 0_intkind1, wf16(:,212), n2(110))
  call prop_A_Q(ntry, wf16(:,153), 180, ZERO, 0_intkind1, wf16(:,213), n2(111))
  call vert_QA_V(ntry, ex3, wf8(:,20), wf16(:,214), n3(:,274), t3x16(:,:,136))
  call prop_Q_A(ntry, wf16(:,168), 172, ZERO, 0_intkind1, wf16(:,215), n2(112))
  call prop_Q_A(ntry, wf16(:,170), 172, ZERO, 0_intkind1, wf16(:,216), n2(113))
  call vert_VQ_A(ntry, ex7, ex1, wf4(:,24), n3(:,275), t3x4(:,:,15))
  call vert_AV_Q(ntry, ex2, ex8, wf4(:,25), n3(:,276), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,24), 65, ZERO, 0_intkind1, wf4(:,26), n2(114))
  call prop_A_Q(ntry, wf4(:,25), 130, ZERO, 0_intkind1, wf4(:,27), n2(115))
  call vert_QA_V(ntry, wf4(:,26), wf4(:,27), wf16(:,217), n3(:,277), t3x16(:,:,137))
  call vert_QA_V(ntry, wf8(:,16), ex6, wf16(:,218), n3(:,278), t3x16(:,:,138))
  call vert_QA_Z(gZl,ntry, wf4(:,26), wf4(:,27), wf16(:,219), n3(:,279), t3x16(:,:,139))
  call prop_W_W(ntry, wf16(:,219), 195, MZ, 1_intkind1, wf16(:,220), n2(116))
  call vert_QA_Z(gZd,ntry, wf8(:,16), ex6, wf16(:,221), n3(:,280), t3x16(:,:,140))
  call vert_QA_V(ntry, ex4, wf8(:,8), wf16(:,222), n3(:,281), t3x16(:,:,141))
  call vert_QA_Z(gZd,ntry, ex4, wf8(:,8), wf16(:,223), n3(:,282), t3x16(:,:,142))
  call vert_QA_V(ntry, wf4(:,26), ex2, wf8(:,65), n3(:,283), t3x8(:,:,41))
  call vert_AV_Q(ntry, ex6, wf8(:,65), wf16(:,224), n3(:,284), t3x16(:,:,143))
  call vert_QA_Z(gZl,ntry, wf4(:,26), ex2, wf8(:,66), n3(:,285), t3x8(:,:,42))
  call prop_W_W(ntry, wf8(:,66), 67, MZ, 1_intkind1, wf8(:,67), n2(117))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,67), wf16(:,225), n3(:,286), t3x16(:,:,144))
  call vert_VQ_A(ntry, wf8(:,65), wf4(:,11), wf32(:,61), n3(:,287), t3x32(:,:,61))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), wf4(:,11), wf32(:,62), n3(:,288), t3x32(:,:,62))
  call vert_VQ_A(ntry, wf8(:,65), ex4, wf16(:,226), n3(:,289), t3x16(:,:,145))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), ex4, wf16(:,227), n3(:,290), t3x16(:,:,146))
  call vert_VQ_A(ntry, wf8(:,65), wf8(:,16), wf64(:,25), n3(:,291), t3x64(:,:,25))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), wf8(:,16), wf64(:,26), n3(:,292), t3x64(:,:,26))
  call prop_Q_A(ntry, wf16(:,226), 75, ZERO, 0_intkind1, wf16(:,228), n2(118))
  call prop_Q_A(ntry, wf16(:,227), 75, ZERO, 0_intkind1, wf16(:,229), n2(119))
  call prop_A_Q(ntry, wf16(:,224), 99, ZERO, 0_intkind1, wf16(:,230), n2(120))
  call prop_A_Q(ntry, wf16(:,225), 99, ZERO, 0_intkind1, wf16(:,231), n2(121))
  call vert_VQ_A(ntry, ex8, wf4(:,26), wf8(:,68), n3(:,293), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,68), 193, ZERO, 0_intkind1, wf8(:,69), n2(122))
  call vert_QA_V(ntry, wf8(:,69), ex2, wf16(:,232), n3(:,294), t3x16(:,:,147))
  call vert_QA_Z(gZl,ntry, wf8(:,69), ex2, wf16(:,233), n3(:,295), t3x16(:,:,148))
  call prop_W_W(ntry, wf16(:,233), 195, MZ, 1_intkind1, wf16(:,234), n2(123))
  call vert_VQ_A(ntry, ex8, ex1, wf4(:,28), n3(:,296), t3x4(:,:,17))
  call vert_AV_Q(ntry, ex2, ex7, wf4(:,29), n3(:,297), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,28), 129, ZERO, 0_intkind1, wf4(:,30), n2(124))
  call prop_A_Q(ntry, wf4(:,29), 66, ZERO, 0_intkind1, wf4(:,31), n2(125))
  call vert_QA_V(ntry, wf4(:,30), wf4(:,31), wf16(:,235), n3(:,298), t3x16(:,:,149))
  call vert_QA_Z(gZl,ntry, wf4(:,30), wf4(:,31), wf16(:,236), n3(:,299), t3x16(:,:,150))
  call prop_W_W(ntry, wf16(:,236), 195, MZ, 1_intkind1, wf16(:,237), n2(126))
  call vert_QA_V(ntry, ex1, wf4(:,31), wf8(:,70), n3(:,300), t3x8(:,:,44))
  call vert_AV_Q(ntry, ex6, wf8(:,70), wf16(:,238), n3(:,301), t3x16(:,:,151))
  call vert_QA_Z(gZl,ntry, ex1, wf4(:,31), wf8(:,71), n3(:,302), t3x8(:,:,45))
  call prop_W_W(ntry, wf8(:,71), 67, MZ, 1_intkind1, wf8(:,72), n2(127))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,72), wf16(:,239), n3(:,303), t3x16(:,:,152))
  call vert_VQ_A(ntry, wf8(:,70), wf4(:,11), wf32(:,63), n3(:,304), t3x32(:,:,63))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), wf4(:,11), wf32(:,64), n3(:,305), t3x32(:,:,64))
  call vert_VQ_A(ntry, wf8(:,70), ex4, wf16(:,240), n3(:,306), t3x16(:,:,153))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), ex4, wf16(:,241), n3(:,307), t3x16(:,:,154))
  call vert_VQ_A(ntry, wf8(:,70), wf8(:,16), wf64(:,27), n3(:,308), t3x64(:,:,27))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), wf8(:,16), wf64(:,28), n3(:,309), t3x64(:,:,28))
  call prop_Q_A(ntry, wf16(:,240), 75, ZERO, 0_intkind1, wf16(:,242), n2(128))
  call prop_Q_A(ntry, wf16(:,241), 75, ZERO, 0_intkind1, wf16(:,243), n2(129))
  call prop_A_Q(ntry, wf16(:,238), 99, ZERO, 0_intkind1, wf16(:,244), n2(130))
  call prop_A_Q(ntry, wf16(:,239), 99, ZERO, 0_intkind1, wf16(:,245), n2(131))
  call vert_AV_Q(ntry, wf4(:,31), ex8, wf8(:,73), n3(:,310), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,73), 194, ZERO, 0_intkind1, wf8(:,74), n2(132))
  call vert_QA_V(ntry, ex1, wf8(:,74), wf16(:,246), n3(:,311), t3x16(:,:,155))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,74), wf16(:,247), n3(:,312), t3x16(:,:,156))
  call prop_W_W(ntry, wf16(:,247), 195, MZ, 1_intkind1, wf16(:,248), n2(133))
  call vert_QA_V(ntry, wf4(:,30), ex2, wf8(:,75), n3(:,313), t3x8(:,:,47))
  call vert_AV_Q(ntry, ex6, wf8(:,75), wf16(:,249), n3(:,314), t3x16(:,:,157))
  call vert_QA_Z(gZl,ntry, wf4(:,30), ex2, wf8(:,76), n3(:,315), t3x8(:,:,48))
  call prop_W_W(ntry, wf8(:,76), 131, MZ, 1_intkind1, wf8(:,77), n2(134))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,77), wf16(:,250), n3(:,316), t3x16(:,:,158))
  call vert_VQ_A(ntry, wf8(:,75), wf4(:,5), wf32(:,65), n3(:,317), t3x32(:,:,65))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), wf4(:,5), wf32(:,66), n3(:,318), t3x32(:,:,66))
  call vert_QA_V(ntry, ex1, wf4(:,27), wf8(:,78), n3(:,319), t3x8(:,:,49))
  call vert_AV_Q(ntry, ex6, wf8(:,78), wf16(:,251), n3(:,320), t3x16(:,:,159))
  call vert_QA_Z(gZl,ntry, ex1, wf4(:,27), wf8(:,79), n3(:,321), t3x8(:,:,50))
  call prop_W_W(ntry, wf8(:,79), 131, MZ, 1_intkind1, wf8(:,80), n2(135))
  call vert_AZ_Q(gZd,ntry, ex6, wf8(:,80), wf16(:,252), n3(:,322), t3x16(:,:,160))
  call vert_VQ_A(ntry, wf8(:,78), wf4(:,5), wf32(:,67), n3(:,323), t3x32(:,:,67))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), wf4(:,5), wf32(:,68), n3(:,324), t3x32(:,:,68))
  call vert_VQ_A(ntry, wf8(:,75), ex4, wf16(:,253), n3(:,325), t3x16(:,:,161))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), ex4, wf16(:,254), n3(:,326), t3x16(:,:,162))
  call vert_VQ_A(ntry, wf8(:,75), wf8(:,16), wf64(:,29), n3(:,327), t3x64(:,:,29))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), wf8(:,16), wf64(:,30), n3(:,328), t3x64(:,:,30))
  call vert_VQ_A(ntry, wf8(:,78), ex4, wf16(:,255), n3(:,329), t3x16(:,:,163))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), ex4, wf16(:,256), n3(:,330), t3x16(:,:,164))
  call vert_VQ_A(ntry, wf8(:,78), wf8(:,16), wf64(:,31), n3(:,331), t3x64(:,:,31))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), wf8(:,16), wf64(:,32), n3(:,332), t3x64(:,:,32))
  call prop_Q_A(ntry, wf16(:,253), 139, ZERO, 0_intkind1, wf16(:,257), n2(136))
  call prop_Q_A(ntry, wf16(:,254), 139, ZERO, 0_intkind1, wf16(:,258), n2(137))
  call prop_A_Q(ntry, wf16(:,249), 163, ZERO, 0_intkind1, wf16(:,259), n2(138))
  call prop_A_Q(ntry, wf16(:,250), 163, ZERO, 0_intkind1, wf16(:,260), n2(139))
  call vert_VQ_A(ntry, ex7, wf4(:,30), wf8(:,81), n3(:,333), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,81), 193, ZERO, 0_intkind1, wf8(:,82), n2(140))
  call vert_QA_V(ntry, wf8(:,82), ex2, wf16(:,261), n3(:,334), t3x16(:,:,165))
  call vert_QA_Z(gZl,ntry, wf8(:,82), ex2, wf16(:,262), n3(:,335), t3x16(:,:,166))
  call prop_W_W(ntry, wf16(:,262), 195, MZ, 1_intkind1, wf16(:,263), n2(141))
  call prop_Q_A(ntry, wf16(:,255), 139, ZERO, 0_intkind1, wf16(:,264), n2(142))
  call prop_Q_A(ntry, wf16(:,256), 139, ZERO, 0_intkind1, wf16(:,265), n2(143))
  call prop_A_Q(ntry, wf16(:,251), 163, ZERO, 0_intkind1, wf16(:,266), n2(144))
  call prop_A_Q(ntry, wf16(:,252), 163, ZERO, 0_intkind1, wf16(:,267), n2(145))
  call vert_AV_Q(ntry, wf4(:,27), ex7, wf8(:,83), n3(:,336), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,83), 194, ZERO, 0_intkind1, wf8(:,84), n2(146))
  call vert_QA_V(ntry, ex1, wf8(:,84), wf16(:,268), n3(:,337), t3x16(:,:,167))
  call vert_QA_Z(gZl,ntry, ex1, wf8(:,84), wf16(:,269), n3(:,338), t3x16(:,:,168))
  call prop_W_W(ntry, wf16(:,269), 195, MZ, 1_intkind1, wf16(:,270), n2(147))
  call vert_QA_V(ntry, wf8(:,30), ex6, wf16(:,271), n3(:,339), t3x16(:,:,169))
  call vert_QA_Z(gZd,ntry, wf8(:,30), ex6, wf16(:,272), n3(:,340), t3x16(:,:,170))
  call vert_QA_V(ntry, ex3, wf8(:,24), wf16(:,273), n3(:,341), t3x16(:,:,171))
  call vert_QA_Z(gZd,ntry, ex3, wf8(:,24), wf16(:,274), n3(:,342), t3x16(:,:,172))
  call vert_VQ_A(ntry, wf8(:,65), wf4(:,17), wf32(:,69), n3(:,343), t3x32(:,:,69))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), wf4(:,17), wf32(:,70), n3(:,344), t3x32(:,:,70))
  call vert_VQ_A(ntry, wf8(:,65), ex3, wf16(:,275), n3(:,345), t3x16(:,:,173))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), ex3, wf16(:,276), n3(:,346), t3x16(:,:,174))
  call vert_VQ_A(ntry, wf8(:,65), wf8(:,30), wf64(:,33), n3(:,347), t3x64(:,:,33))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), wf8(:,30), wf64(:,34), n3(:,348), t3x64(:,:,34))
  call prop_Q_A(ntry, wf16(:,275), 71, ZERO, 0_intkind1, wf16(:,277), n2(148))
  call prop_Q_A(ntry, wf16(:,276), 71, ZERO, 0_intkind1, wf16(:,278), n2(149))
  call vert_VQ_A(ntry, wf8(:,70), wf4(:,17), wf32(:,71), n3(:,349), t3x32(:,:,71))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), wf4(:,17), wf32(:,72), n3(:,350), t3x32(:,:,72))
  call vert_VQ_A(ntry, wf8(:,70), ex3, wf16(:,279), n3(:,351), t3x16(:,:,175))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), ex3, wf16(:,280), n3(:,352), t3x16(:,:,176))
  call vert_VQ_A(ntry, wf8(:,70), wf8(:,30), wf64(:,35), n3(:,353), t3x64(:,:,35))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), wf8(:,30), wf64(:,36), n3(:,354), t3x64(:,:,36))
  call prop_Q_A(ntry, wf16(:,279), 71, ZERO, 0_intkind1, wf16(:,281), n2(150))
  call prop_Q_A(ntry, wf16(:,280), 71, ZERO, 0_intkind1, wf16(:,282), n2(151))
  call vert_VQ_A(ntry, wf8(:,75), wf4(:,15), wf32(:,73), n3(:,355), t3x32(:,:,73))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), wf4(:,15), wf32(:,74), n3(:,356), t3x32(:,:,74))
  call vert_VQ_A(ntry, wf8(:,78), wf4(:,15), wf32(:,75), n3(:,357), t3x32(:,:,75))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), wf4(:,15), wf32(:,76), n3(:,358), t3x32(:,:,76))
  call vert_VQ_A(ntry, wf8(:,75), ex3, wf16(:,283), n3(:,359), t3x16(:,:,177))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), ex3, wf16(:,284), n3(:,360), t3x16(:,:,178))
  call vert_VQ_A(ntry, wf8(:,75), wf8(:,30), wf64(:,37), n3(:,361), t3x64(:,:,37))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), wf8(:,30), wf64(:,38), n3(:,362), t3x64(:,:,38))
  call vert_VQ_A(ntry, wf8(:,78), ex3, wf16(:,285), n3(:,363), t3x16(:,:,179))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), ex3, wf16(:,286), n3(:,364), t3x16(:,:,180))
  call vert_VQ_A(ntry, wf8(:,78), wf8(:,30), wf64(:,39), n3(:,365), t3x64(:,:,39))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), wf8(:,30), wf64(:,40), n3(:,366), t3x64(:,:,40))
  call prop_Q_A(ntry, wf16(:,283), 135, ZERO, 0_intkind1, wf16(:,287), n2(152))
  call prop_Q_A(ntry, wf16(:,284), 135, ZERO, 0_intkind1, wf16(:,288), n2(153))
  call prop_Q_A(ntry, wf16(:,285), 135, ZERO, 0_intkind1, wf16(:,289), n2(154))
  call prop_Q_A(ntry, wf16(:,286), 135, ZERO, 0_intkind1, wf16(:,290), n2(155))
  call vert_QA_V(ntry, wf8(:,42), ex5, wf16(:,291), n3(:,367), t3x16(:,:,181))
  call vert_QA_Z(gZd,ntry, wf8(:,42), ex5, wf16(:,292), n3(:,368), t3x16(:,:,182))
  call vert_QA_V(ntry, ex4, wf8(:,38), wf16(:,293), n3(:,369), t3x16(:,:,183))
  call vert_QA_Z(gZd,ntry, ex4, wf8(:,38), wf16(:,294), n3(:,370), t3x16(:,:,184))
  call vert_AV_Q(ntry, ex5, wf8(:,65), wf16(:,295), n3(:,371), t3x16(:,:,185))
  call vert_AZ_Q(gZd,ntry, ex5, wf8(:,67), wf16(:,296), n3(:,372), t3x16(:,:,186))
  call vert_VQ_A(ntry, wf8(:,65), wf8(:,42), wf64(:,41), n3(:,373), t3x64(:,:,41))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), wf8(:,42), wf64(:,42), n3(:,374), t3x64(:,:,42))
  call prop_A_Q(ntry, wf16(:,295), 83, ZERO, 0_intkind1, wf16(:,297), n2(156))
  call prop_A_Q(ntry, wf16(:,296), 83, ZERO, 0_intkind1, wf16(:,298), n2(157))
  call vert_AV_Q(ntry, ex5, wf8(:,70), wf16(:,299), n3(:,375), t3x16(:,:,187))
  call vert_AZ_Q(gZd,ntry, ex5, wf8(:,72), wf16(:,300), n3(:,376), t3x16(:,:,188))
  call vert_VQ_A(ntry, wf8(:,70), wf8(:,42), wf64(:,43), n3(:,377), t3x64(:,:,43))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), wf8(:,42), wf64(:,44), n3(:,378), t3x64(:,:,44))
  call prop_A_Q(ntry, wf16(:,299), 83, ZERO, 0_intkind1, wf16(:,301), n2(158))
  call prop_A_Q(ntry, wf16(:,300), 83, ZERO, 0_intkind1, wf16(:,302), n2(159))
  call vert_AV_Q(ntry, ex5, wf8(:,75), wf16(:,303), n3(:,379), t3x16(:,:,189))
  call vert_AZ_Q(gZd,ntry, ex5, wf8(:,77), wf16(:,304), n3(:,380), t3x16(:,:,190))
  call vert_AV_Q(ntry, ex5, wf8(:,78), wf16(:,305), n3(:,381), t3x16(:,:,191))
  call vert_AZ_Q(gZd,ntry, ex5, wf8(:,80), wf16(:,306), n3(:,382), t3x16(:,:,192))
  call vert_VQ_A(ntry, wf8(:,75), wf8(:,42), wf64(:,45), n3(:,383), t3x64(:,:,45))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), wf8(:,42), wf64(:,46), n3(:,384), t3x64(:,:,46))
  call vert_VQ_A(ntry, wf8(:,78), wf8(:,42), wf64(:,47), n3(:,385), t3x64(:,:,47))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), wf8(:,42), wf64(:,48), n3(:,386), t3x64(:,:,48))
  call prop_A_Q(ntry, wf16(:,303), 147, ZERO, 0_intkind1, wf16(:,307), n2(160))
  call prop_A_Q(ntry, wf16(:,304), 147, ZERO, 0_intkind1, wf16(:,308), n2(161))
  call prop_A_Q(ntry, wf16(:,305), 147, ZERO, 0_intkind1, wf16(:,309), n2(162))
  call prop_A_Q(ntry, wf16(:,306), 147, ZERO, 0_intkind1, wf16(:,310), n2(163))
  call vert_QA_V(ntry, wf8(:,48), ex5, wf16(:,311), n3(:,387), t3x16(:,:,193))
  call vert_QA_Z(gZd,ntry, wf8(:,48), ex5, wf16(:,312), n3(:,388), t3x16(:,:,194))
  call vert_QA_V(ntry, ex3, wf8(:,46), wf16(:,313), n3(:,389), t3x16(:,:,195))
  call vert_QA_Z(gZd,ntry, ex3, wf8(:,46), wf16(:,314), n3(:,390), t3x16(:,:,196))
  call vert_VQ_A(ntry, wf8(:,65), wf8(:,48), wf64(:,49), n3(:,391), t3x64(:,:,49))
  call vert_ZQ_A(gZd,ntry, wf8(:,67), wf8(:,48), wf64(:,50), n3(:,392), t3x64(:,:,50))
  call vert_VQ_A(ntry, wf8(:,70), wf8(:,48), wf64(:,51), n3(:,393), t3x64(:,:,51))
  call vert_ZQ_A(gZd,ntry, wf8(:,72), wf8(:,48), wf64(:,52), n3(:,394), t3x64(:,:,52))
  call vert_VQ_A(ntry, wf8(:,75), wf8(:,48), wf64(:,53), n3(:,395), t3x64(:,:,53))
  call vert_ZQ_A(gZd,ntry, wf8(:,77), wf8(:,48), wf64(:,54), n3(:,396), t3x64(:,:,54))
  call vert_VQ_A(ntry, wf8(:,78), wf8(:,48), wf64(:,55), n3(:,397), t3x64(:,:,55))
  call vert_ZQ_A(gZd,ntry, wf8(:,80), wf8(:,48), wf64(:,56), n3(:,398), t3x64(:,:,56))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    M2munu = 0
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppllaaj_eexdddxdxaa_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllaaj_eexdddxdxaa_1

  do k = 0, 1-1
    M2(k) = M2add(extcomb_perm_ppllaaj_eexdddxdxaa_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*8-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf16(:,2), wf16(:,3), A(:,1), n3(:,399), t3x256(:,:,1), nhel, den(9))
    call cont_QA(nsync, wf16(:,2), wf16(:,5), A(:,2), n3(:,400), t3x256(:,:,2), nhel, den(13))
    call cont_QA(nsync, wf16(:,7), wf16(:,8), A(:,3), n3(:,401), t3x256(:,:,3), nhel, den(18))
    call cont_QA(nsync, wf16(:,7), wf16(:,10), A(:,4), n3(:,402), t3x256(:,:,4), nhel, den(21))
    call cont_QA(nsync, wf8(:,4), wf32(:,1), A(:,5), n3(:,403), t3x256(:,:,5), nhel, den(27))
    call cont_QA(nsync, wf8(:,4), wf32(:,2), A(:,6), n3(:,404), t3x256(:,:,6), nhel, den(30))
    call cont_QA(nsync, wf16(:,11), wf16(:,12), A(:,7), n3(:,405), t3x256(:,:,7), nhel, den(33))
    call cont_QA(nsync, wf16(:,11), wf16(:,13), A(:,8), n3(:,406), t3x256(:,:,8), nhel, den(34))
    call cont_QA(nsync, wf8(:,4), wf32(:,3), A(:,9), n3(:,407), t3x256(:,:,9), nhel, den(38))
    call cont_QA(nsync, wf8(:,4), wf32(:,4), A(:,10), n3(:,408), t3x256(:,:,10), nhel, den(40))
    call cont_QA(nsync, wf16(:,3), wf16(:,14), A(:,11), n3(:,409), t3x256(:,:,11), nhel, den(41))
    call cont_QA(nsync, wf16(:,5), wf16(:,14), A(:,12), n3(:,410), t3x256(:,:,12), nhel, den(42))
    call cont_QA(nsync, wf16(:,16), wf16(:,17), A(:,13), n3(:,411), t3x256(:,:,13), nhel, den(49))
    call cont_QA(nsync, wf16(:,16), wf16(:,19), A(:,14), n3(:,412), t3x256(:,:,14), nhel, den(52))
    call cont_QA(nsync, wf16(:,21), wf16(:,22), A(:,15), n3(:,413), t3x256(:,:,15), nhel, den(57))
    call cont_QA(nsync, wf16(:,21), wf16(:,24), A(:,16), n3(:,414), t3x256(:,:,16), nhel, den(60))
    call cont_QA(nsync, wf16(:,25), wf16(:,26), A(:,17), n3(:,415), t3x256(:,:,17), nhel, den(65))
    call cont_QA(nsync, wf16(:,25), wf16(:,27), A(:,18), n3(:,416), t3x256(:,:,18), nhel, den(67))
    call cont_QA(nsync, wf8(:,14), wf32(:,5), A(:,19), n3(:,417), t3x256(:,:,19), nhel, den(71))
    call cont_QA(nsync, wf8(:,14), wf32(:,6), A(:,20), n3(:,418), t3x256(:,:,20), nhel, den(73))
    call cont_QA(nsync, wf16(:,22), wf16(:,28), A(:,21), n3(:,419), t3x256(:,:,21), nhel, den(76))
    call cont_QA(nsync, wf16(:,24), wf16(:,28), A(:,22), n3(:,420), t3x256(:,:,22), nhel, den(77))
    call cont_QA(nsync, wf8(:,14), wf32(:,7), A(:,23), n3(:,421), t3x256(:,:,23), nhel, den(79))
    call cont_QA(nsync, wf8(:,14), wf32(:,8), A(:,24), n3(:,422), t3x256(:,:,24), nhel, den(81))
    call cont_QA(nsync, wf32(:,1), wf8(:,18), A(:,25), n3(:,423), t3x256(:,:,25), nhel, den(83))
    call cont_QA(nsync, wf32(:,2), wf8(:,18), A(:,26), n3(:,424), t3x256(:,:,26), nhel, den(84))
    call cont_QA(nsync, wf16(:,29), wf16(:,30), A(:,27), n3(:,425), t3x256(:,:,27), nhel, den(87))
    call cont_QA(nsync, wf16(:,29), wf16(:,31), A(:,28), n3(:,426), t3x256(:,:,28), nhel, den(88))
    call cont_QA(nsync, wf32(:,3), wf8(:,18), A(:,29), n3(:,427), t3x256(:,:,29), nhel, den(89))
    call cont_QA(nsync, wf32(:,4), wf8(:,18), A(:,30), n3(:,428), t3x256(:,:,30), nhel, den(90))
    call cont_QA(nsync, wf16(:,17), wf16(:,32), A(:,31), n3(:,429), t3x256(:,:,31), nhel, den(91))
    call cont_QA(nsync, wf16(:,19), wf16(:,32), A(:,32), n3(:,430), t3x256(:,:,32), nhel, den(92))
    call cont_QA(nsync, wf16(:,33), wf16(:,34), A(:,33), n3(:,431), t3x256(:,:,33), nhel, den(95))
    call cont_QA(nsync, wf16(:,33), wf16(:,35), A(:,34), n3(:,432), t3x256(:,:,34), nhel, den(96))
    call cont_QA(nsync, wf32(:,5), wf8(:,20), A(:,35), n3(:,433), t3x256(:,:,35), nhel, den(98))
    call cont_QA(nsync, wf32(:,6), wf8(:,20), A(:,36), n3(:,434), t3x256(:,:,36), nhel, den(99))
    call cont_QA(nsync, wf16(:,8), wf16(:,36), A(:,37), n3(:,435), t3x256(:,:,37), nhel, den(100))
    call cont_QA(nsync, wf16(:,10), wf16(:,36), A(:,38), n3(:,436), t3x256(:,:,38), nhel, den(101))
    call cont_QA(nsync, wf32(:,7), wf8(:,20), A(:,39), n3(:,437), t3x256(:,:,39), nhel, den(102))
    call cont_QA(nsync, wf32(:,8), wf8(:,20), A(:,40), n3(:,438), t3x256(:,:,40), nhel, den(103))
    call cont_QA(nsync, wf16(:,14), wf16(:,37), A(:,41), n3(:,439), t3x256(:,:,41), nhel, den(105))
    call cont_QA(nsync, wf16(:,14), wf16(:,38), A(:,42), n3(:,440), t3x256(:,:,42), nhel, den(107))
    call cont_QA(nsync, wf16(:,26), wf16(:,39), A(:,43), n3(:,441), t3x256(:,:,43), nhel, den(109))
    call cont_QA(nsync, wf16(:,27), wf16(:,39), A(:,44), n3(:,442), t3x256(:,:,44), nhel, den(110))
    call cont_QA(nsync, wf16(:,12), wf16(:,40), A(:,45), n3(:,443), t3x256(:,:,45), nhel, den(112))
    call cont_QA(nsync, wf16(:,13), wf16(:,40), A(:,46), n3(:,444), t3x256(:,:,46), nhel, den(113))
    call cont_QA(nsync, wf16(:,28), wf16(:,41), A(:,47), n3(:,445), t3x256(:,:,47), nhel, den(115))
    call cont_QA(nsync, wf16(:,28), wf16(:,42), A(:,48), n3(:,446), t3x256(:,:,48), nhel, den(117))
    call cont_QA(nsync, wf16(:,44), wf16(:,45), A(:,49), n3(:,447), t3x256(:,:,49), nhel, den(124))
    call cont_QA(nsync, wf16(:,44), wf16(:,47), A(:,50), n3(:,448), t3x256(:,:,50), nhel, den(127))
    call cont_QA(nsync, wf16(:,8), wf16(:,48), A(:,51), n3(:,449), t3x256(:,:,51), nhel, den(129))
    call cont_QA(nsync, wf16(:,10), wf16(:,48), A(:,52), n3(:,450), t3x256(:,:,52), nhel, den(130))
    call cont_QA(nsync, wf8(:,22), wf32(:,9), A(:,53), n3(:,451), t3x256(:,:,53), nhel, den(134))
    call cont_QA(nsync, wf8(:,22), wf32(:,10), A(:,54), n3(:,452), t3x256(:,:,54), nhel, den(136))
    call cont_QA(nsync, wf16(:,12), wf16(:,49), A(:,55), n3(:,453), t3x256(:,:,55), nhel, den(138))
    call cont_QA(nsync, wf16(:,13), wf16(:,49), A(:,56), n3(:,454), t3x256(:,:,56), nhel, den(139))
    call cont_QA(nsync, wf8(:,22), wf32(:,11), A(:,57), n3(:,455), t3x256(:,:,57), nhel, den(143))
    call cont_QA(nsync, wf8(:,22), wf32(:,12), A(:,58), n3(:,456), t3x256(:,:,58), nhel, den(145))
    call cont_QA(nsync, wf16(:,45), wf16(:,50), A(:,59), n3(:,457), t3x256(:,:,59), nhel, den(146))
    call cont_QA(nsync, wf16(:,47), wf16(:,50), A(:,60), n3(:,458), t3x256(:,:,60), nhel, den(147))
    call cont_QA(nsync, wf16(:,52), wf16(:,53), A(:,61), n3(:,459), t3x256(:,:,61), nhel, den(153))
    call cont_QA(nsync, wf16(:,52), wf16(:,55), A(:,62), n3(:,460), t3x256(:,:,62), nhel, den(156))
    call cont_QA(nsync, wf16(:,22), wf16(:,56), A(:,63), n3(:,461), t3x256(:,:,63), nhel, den(158))
    call cont_QA(nsync, wf16(:,24), wf16(:,56), A(:,64), n3(:,462), t3x256(:,:,64), nhel, den(159))
    call cont_QA(nsync, wf16(:,57), wf16(:,58), A(:,65), n3(:,463), t3x256(:,:,65), nhel, den(164))
    call cont_QA(nsync, wf16(:,57), wf16(:,59), A(:,66), n3(:,464), t3x256(:,:,66), nhel, den(166))
    call cont_QA(nsync, wf8(:,14), wf32(:,13), A(:,67), n3(:,465), t3x256(:,:,67), nhel, den(168))
    call cont_QA(nsync, wf8(:,14), wf32(:,14), A(:,68), n3(:,466), t3x256(:,:,68), nhel, den(170))
    call cont_QA(nsync, wf16(:,22), wf16(:,60), A(:,69), n3(:,467), t3x256(:,:,69), nhel, den(172))
    call cont_QA(nsync, wf16(:,24), wf16(:,60), A(:,70), n3(:,468), t3x256(:,:,70), nhel, den(173))
    call cont_QA(nsync, wf8(:,14), wf32(:,15), A(:,71), n3(:,469), t3x256(:,:,71), nhel, den(175))
    call cont_QA(nsync, wf8(:,14), wf32(:,16), A(:,72), n3(:,470), t3x256(:,:,72), nhel, den(177))
    call cont_QA(nsync, wf32(:,9), wf8(:,32), A(:,73), n3(:,471), t3x256(:,:,73), nhel, den(179))
    call cont_QA(nsync, wf32(:,10), wf8(:,32), A(:,74), n3(:,472), t3x256(:,:,74), nhel, den(180))
    call cont_QA(nsync, wf16(:,30), wf16(:,61), A(:,75), n3(:,473), t3x256(:,:,75), nhel, den(182))
    call cont_QA(nsync, wf16(:,31), wf16(:,61), A(:,76), n3(:,474), t3x256(:,:,76), nhel, den(183))
    call cont_QA(nsync, wf32(:,11), wf8(:,32), A(:,77), n3(:,475), t3x256(:,:,77), nhel, den(184))
    call cont_QA(nsync, wf32(:,12), wf8(:,32), A(:,78), n3(:,476), t3x256(:,:,78), nhel, den(185))
    call cont_QA(nsync, wf16(:,53), wf16(:,62), A(:,79), n3(:,477), t3x256(:,:,79), nhel, den(186))
    call cont_QA(nsync, wf16(:,55), wf16(:,62), A(:,80), n3(:,478), t3x256(:,:,80), nhel, den(187))
    call cont_QA(nsync, wf16(:,63), wf16(:,64), A(:,81), n3(:,479), t3x256(:,:,81), nhel, den(190))
    call cont_QA(nsync, wf16(:,63), wf16(:,65), A(:,82), n3(:,480), t3x256(:,:,82), nhel, den(191))
    call cont_QA(nsync, wf8(:,20), wf32(:,13), A(:,83), n3(:,481), t3x256(:,:,83), nhel, den(192))
    call cont_QA(nsync, wf8(:,20), wf32(:,14), A(:,84), n3(:,482), t3x256(:,:,84), nhel, den(193))
    call cont_QA(nsync, wf16(:,8), wf16(:,66), A(:,85), n3(:,483), t3x256(:,:,85), nhel, den(194))
    call cont_QA(nsync, wf16(:,10), wf16(:,66), A(:,86), n3(:,484), t3x256(:,:,86), nhel, den(195))
    call cont_QA(nsync, wf8(:,20), wf32(:,15), A(:,87), n3(:,485), t3x256(:,:,87), nhel, den(196))
    call cont_QA(nsync, wf8(:,20), wf32(:,16), A(:,88), n3(:,486), t3x256(:,:,88), nhel, den(197))
    call cont_QA(nsync, wf16(:,50), wf16(:,67), A(:,89), n3(:,487), t3x256(:,:,89), nhel, den(199))
    call cont_QA(nsync, wf16(:,50), wf16(:,68), A(:,90), n3(:,488), t3x256(:,:,90), nhel, den(201))
    call cont_QA(nsync, wf16(:,58), wf16(:,69), A(:,91), n3(:,489), t3x256(:,:,91), nhel, den(203))
    call cont_QA(nsync, wf16(:,59), wf16(:,69), A(:,92), n3(:,490), t3x256(:,:,92), nhel, den(204))
    call cont_QA(nsync, wf16(:,12), wf16(:,70), A(:,93), n3(:,491), t3x256(:,:,93), nhel, den(206))
    call cont_QA(nsync, wf16(:,13), wf16(:,70), A(:,94), n3(:,492), t3x256(:,:,94), nhel, den(207))
    call cont_QA(nsync, wf16(:,41), wf16(:,60), A(:,95), n3(:,493), t3x256(:,:,95), nhel, den(208))
    call cont_QA(nsync, wf16(:,42), wf16(:,60), A(:,96), n3(:,494), t3x256(:,:,96), nhel, den(209))
    call cont_QA(nsync, wf16(:,3), wf16(:,71), A(:,97), n3(:,495), t3x256(:,:,97), nhel, den(213))
    call cont_QA(nsync, wf16(:,5), wf16(:,71), A(:,98), n3(:,496), t3x256(:,:,98), nhel, den(214))
    call cont_QA(nsync, wf16(:,73), wf16(:,74), A(:,99), n3(:,497), t3x256(:,:,99), nhel, den(219))
    call cont_QA(nsync, wf16(:,73), wf16(:,76), A(:,100), n3(:,498), t3x256(:,:,100), nhel, den(222))
    call cont_QA(nsync, wf8(:,4), wf32(:,17), A(:,101), n3(:,499), t3x256(:,:,101), nhel, den(226))
    call cont_QA(nsync, wf8(:,4), wf32(:,18), A(:,102), n3(:,500), t3x256(:,:,102), nhel, den(229))
    call cont_QA(nsync, wf16(:,77), wf16(:,78), A(:,103), n3(:,501), t3x256(:,:,103), nhel, den(232))
    call cont_QA(nsync, wf16(:,77), wf16(:,79), A(:,104), n3(:,502), t3x256(:,:,104), nhel, den(233))
    call cont_QA(nsync, wf8(:,4), wf32(:,19), A(:,105), n3(:,503), t3x256(:,:,105), nhel, den(236))
    call cont_QA(nsync, wf8(:,4), wf32(:,20), A(:,106), n3(:,504), t3x256(:,:,106), nhel, den(238))
    call cont_QA(nsync, wf16(:,3), wf16(:,80), A(:,107), n3(:,505), t3x256(:,:,107), nhel, den(239))
    call cont_QA(nsync, wf16(:,5), wf16(:,80), A(:,108), n3(:,506), t3x256(:,:,108), nhel, den(240))
    call cont_QA(nsync, wf16(:,17), wf16(:,81), A(:,109), n3(:,507), t3x256(:,:,109), nhel, den(243))
    call cont_QA(nsync, wf16(:,19), wf16(:,81), A(:,110), n3(:,508), t3x256(:,:,110), nhel, den(244))
    call cont_QA(nsync, wf16(:,83), wf16(:,84), A(:,111), n3(:,509), t3x256(:,:,111), nhel, den(249))
    call cont_QA(nsync, wf16(:,83), wf16(:,86), A(:,112), n3(:,510), t3x256(:,:,112), nhel, den(252))
    call cont_QA(nsync, wf16(:,26), wf16(:,87), A(:,113), n3(:,511), t3x256(:,:,113), nhel, den(254))
    call cont_QA(nsync, wf16(:,27), wf16(:,87), A(:,114), n3(:,512), t3x256(:,:,114), nhel, den(255))
    call cont_QA(nsync, wf8(:,40), wf32(:,21), A(:,115), n3(:,513), t3x256(:,:,115), nhel, den(259))
    call cont_QA(nsync, wf8(:,40), wf32(:,22), A(:,116), n3(:,514), t3x256(:,:,116), nhel, den(261))
    call cont_QA(nsync, wf16(:,84), wf16(:,88), A(:,117), n3(:,515), t3x256(:,:,117), nhel, den(264))
    call cont_QA(nsync, wf16(:,86), wf16(:,88), A(:,118), n3(:,516), t3x256(:,:,118), nhel, den(265))
    call cont_QA(nsync, wf8(:,40), wf32(:,23), A(:,119), n3(:,517), t3x256(:,:,119), nhel, den(267))
    call cont_QA(nsync, wf8(:,40), wf32(:,24), A(:,120), n3(:,518), t3x256(:,:,120), nhel, den(269))
    call cont_QA(nsync, wf8(:,18), wf32(:,17), A(:,121), n3(:,519), t3x256(:,:,121), nhel, den(270))
    call cont_QA(nsync, wf8(:,18), wf32(:,18), A(:,122), n3(:,520), t3x256(:,:,122), nhel, den(271))
    call cont_QA(nsync, wf16(:,89), wf16(:,90), A(:,123), n3(:,521), t3x256(:,:,123), nhel, den(274))
    call cont_QA(nsync, wf16(:,89), wf16(:,91), A(:,124), n3(:,522), t3x256(:,:,124), nhel, den(275))
    call cont_QA(nsync, wf8(:,18), wf32(:,19), A(:,125), n3(:,523), t3x256(:,:,125), nhel, den(276))
    call cont_QA(nsync, wf8(:,18), wf32(:,20), A(:,126), n3(:,524), t3x256(:,:,126), nhel, den(277))
    call cont_QA(nsync, wf16(:,17), wf16(:,92), A(:,127), n3(:,525), t3x256(:,:,127), nhel, den(278))
    call cont_QA(nsync, wf16(:,19), wf16(:,92), A(:,128), n3(:,526), t3x256(:,:,128), nhel, den(279))
    call cont_QA(nsync, wf16(:,34), wf16(:,93), A(:,129), n3(:,527), t3x256(:,:,129), nhel, den(281))
    call cont_QA(nsync, wf16(:,35), wf16(:,93), A(:,130), n3(:,528), t3x256(:,:,130), nhel, den(282))
    call cont_QA(nsync, wf32(:,21), wf8(:,44), A(:,131), n3(:,529), t3x256(:,:,131), nhel, den(284))
    call cont_QA(nsync, wf32(:,22), wf8(:,44), A(:,132), n3(:,530), t3x256(:,:,132), nhel, den(285))
    call cont_QA(nsync, wf16(:,74), wf16(:,94), A(:,133), n3(:,531), t3x256(:,:,133), nhel, den(286))
    call cont_QA(nsync, wf16(:,76), wf16(:,94), A(:,134), n3(:,532), t3x256(:,:,134), nhel, den(287))
    call cont_QA(nsync, wf32(:,23), wf8(:,44), A(:,135), n3(:,533), t3x256(:,:,135), nhel, den(288))
    call cont_QA(nsync, wf32(:,24), wf8(:,44), A(:,136), n3(:,534), t3x256(:,:,136), nhel, den(289))
    call cont_QA(nsync, wf16(:,37), wf16(:,80), A(:,137), n3(:,535), t3x256(:,:,137), nhel, den(290))
    call cont_QA(nsync, wf16(:,38), wf16(:,80), A(:,138), n3(:,536), t3x256(:,:,138), nhel, den(291))
    call cont_QA(nsync, wf16(:,26), wf16(:,95), A(:,139), n3(:,537), t3x256(:,:,139), nhel, den(293))
    call cont_QA(nsync, wf16(:,27), wf16(:,95), A(:,140), n3(:,538), t3x256(:,:,140), nhel, den(294))
    call cont_QA(nsync, wf16(:,78), wf16(:,96), A(:,141), n3(:,539), t3x256(:,:,141), nhel, den(296))
    call cont_QA(nsync, wf16(:,79), wf16(:,96), A(:,142), n3(:,540), t3x256(:,:,142), nhel, den(297))
    call cont_QA(nsync, wf16(:,88), wf16(:,97), A(:,143), n3(:,541), t3x256(:,:,143), nhel, den(299))
    call cont_QA(nsync, wf16(:,88), wf16(:,98), A(:,144), n3(:,542), t3x256(:,:,144), nhel, den(301))
    call cont_QA(nsync, wf16(:,45), wf16(:,99), A(:,145), n3(:,543), t3x256(:,:,145), nhel, den(304))
    call cont_QA(nsync, wf16(:,47), wf16(:,99), A(:,146), n3(:,544), t3x256(:,:,146), nhel, den(305))
    call cont_QA(nsync, wf16(:,74), wf16(:,100), A(:,147), n3(:,545), t3x256(:,:,147), nhel, den(307))
    call cont_QA(nsync, wf16(:,76), wf16(:,100), A(:,148), n3(:,546), t3x256(:,:,148), nhel, den(308))
    call cont_QA(nsync, wf8(:,22), wf32(:,25), A(:,149), n3(:,547), t3x256(:,:,149), nhel, den(310))
    call cont_QA(nsync, wf8(:,22), wf32(:,26), A(:,150), n3(:,548), t3x256(:,:,150), nhel, den(312))
    call cont_QA(nsync, wf16(:,78), wf16(:,101), A(:,151), n3(:,549), t3x256(:,:,151), nhel, den(314))
    call cont_QA(nsync, wf16(:,79), wf16(:,101), A(:,152), n3(:,550), t3x256(:,:,152), nhel, den(315))
    call cont_QA(nsync, wf8(:,22), wf32(:,27), A(:,153), n3(:,551), t3x256(:,:,153), nhel, den(318))
    call cont_QA(nsync, wf8(:,22), wf32(:,28), A(:,154), n3(:,552), t3x256(:,:,154), nhel, den(320))
    call cont_QA(nsync, wf16(:,45), wf16(:,102), A(:,155), n3(:,553), t3x256(:,:,155), nhel, den(321))
    call cont_QA(nsync, wf16(:,47), wf16(:,102), A(:,156), n3(:,554), t3x256(:,:,156), nhel, den(322))
    call cont_QA(nsync, wf16(:,53), wf16(:,103), A(:,157), n3(:,555), t3x256(:,:,157), nhel, den(324))
    call cont_QA(nsync, wf16(:,55), wf16(:,103), A(:,158), n3(:,556), t3x256(:,:,158), nhel, den(325))
    call cont_QA(nsync, wf16(:,84), wf16(:,104), A(:,159), n3(:,557), t3x256(:,:,159), nhel, den(327))
    call cont_QA(nsync, wf16(:,86), wf16(:,104), A(:,160), n3(:,558), t3x256(:,:,160), nhel, den(328))
    call cont_QA(nsync, wf16(:,58), wf16(:,105), A(:,161), n3(:,559), t3x256(:,:,161), nhel, den(330))
    call cont_QA(nsync, wf16(:,59), wf16(:,105), A(:,162), n3(:,560), t3x256(:,:,162), nhel, den(331))
    call cont_QA(nsync, wf8(:,40), wf32(:,29), A(:,163), n3(:,561), t3x256(:,:,163), nhel, den(333))
    call cont_QA(nsync, wf8(:,40), wf32(:,30), A(:,164), n3(:,562), t3x256(:,:,164), nhel, den(335))
    call cont_QA(nsync, wf16(:,84), wf16(:,106), A(:,165), n3(:,563), t3x256(:,:,165), nhel, den(337))
    call cont_QA(nsync, wf16(:,86), wf16(:,106), A(:,166), n3(:,564), t3x256(:,:,166), nhel, den(338))
    call cont_QA(nsync, wf8(:,40), wf32(:,31), A(:,167), n3(:,565), t3x256(:,:,167), nhel, den(340))
    call cont_QA(nsync, wf8(:,40), wf32(:,32), A(:,168), n3(:,566), t3x256(:,:,168), nhel, den(342))
    call cont_QA(nsync, wf8(:,32), wf32(:,25), A(:,169), n3(:,567), t3x256(:,:,169), nhel, den(343))
    call cont_QA(nsync, wf8(:,32), wf32(:,26), A(:,170), n3(:,568), t3x256(:,:,170), nhel, den(344))
    call cont_QA(nsync, wf16(:,90), wf16(:,107), A(:,171), n3(:,569), t3x256(:,:,171), nhel, den(346))
    call cont_QA(nsync, wf16(:,91), wf16(:,107), A(:,172), n3(:,570), t3x256(:,:,172), nhel, den(347))
    call cont_QA(nsync, wf8(:,32), wf32(:,27), A(:,173), n3(:,571), t3x256(:,:,173), nhel, den(348))
    call cont_QA(nsync, wf8(:,32), wf32(:,28), A(:,174), n3(:,572), t3x256(:,:,174), nhel, den(349))
    call cont_QA(nsync, wf16(:,53), wf16(:,108), A(:,175), n3(:,573), t3x256(:,:,175), nhel, den(350))
    call cont_QA(nsync, wf16(:,55), wf16(:,108), A(:,176), n3(:,574), t3x256(:,:,176), nhel, den(351))
    call cont_QA(nsync, wf16(:,64), wf16(:,109), A(:,177), n3(:,575), t3x256(:,:,177), nhel, den(353))
    call cont_QA(nsync, wf16(:,65), wf16(:,109), A(:,178), n3(:,576), t3x256(:,:,178), nhel, den(354))
    call cont_QA(nsync, wf8(:,44), wf32(:,29), A(:,179), n3(:,577), t3x256(:,:,179), nhel, den(355))
    call cont_QA(nsync, wf8(:,44), wf32(:,30), A(:,180), n3(:,578), t3x256(:,:,180), nhel, den(356))
    call cont_QA(nsync, wf16(:,74), wf16(:,110), A(:,181), n3(:,579), t3x256(:,:,181), nhel, den(357))
    call cont_QA(nsync, wf16(:,76), wf16(:,110), A(:,182), n3(:,580), t3x256(:,:,182), nhel, den(358))
    call cont_QA(nsync, wf8(:,44), wf32(:,31), A(:,183), n3(:,581), t3x256(:,:,183), nhel, den(359))
    call cont_QA(nsync, wf8(:,44), wf32(:,32), A(:,184), n3(:,582), t3x256(:,:,184), nhel, den(360))
    call cont_QA(nsync, wf16(:,67), wf16(:,102), A(:,185), n3(:,583), t3x256(:,:,185), nhel, den(361))
    call cont_QA(nsync, wf16(:,68), wf16(:,102), A(:,186), n3(:,584), t3x256(:,:,186), nhel, den(362))
    call cont_QA(nsync, wf16(:,58), wf16(:,111), A(:,187), n3(:,585), t3x256(:,:,187), nhel, den(364))
    call cont_QA(nsync, wf16(:,59), wf16(:,111), A(:,188), n3(:,586), t3x256(:,:,188), nhel, den(365))
    call cont_QA(nsync, wf16(:,78), wf16(:,112), A(:,189), n3(:,587), t3x256(:,:,189), nhel, den(367))
    call cont_QA(nsync, wf16(:,79), wf16(:,112), A(:,190), n3(:,588), t3x256(:,:,190), nhel, den(368))
    call cont_QA(nsync, wf16(:,97), wf16(:,106), A(:,191), n3(:,589), t3x256(:,:,191), nhel, den(369))
    call cont_QA(nsync, wf16(:,98), wf16(:,106), A(:,192), n3(:,590), t3x256(:,:,192), nhel, den(370))
    call cont_VV(nsync, wf8(:,49), wf32(:,33), A(:,193), n3(:,591), t3x256(:,:,193), nhel, den(374))
    call cont_VV(nsync, wf8(:,49), wf32(:,34), A(:,194), n3(:,592), t3x256(:,:,194), nhel, den(376))
    call cont_VV(nsync, wf8(:,50), wf32(:,35), A(:,195), n3(:,593), t3x256(:,:,195), nhel, den(380))
    call cont_VV(nsync, wf8(:,50), wf32(:,36), A(:,196), n3(:,594), t3x256(:,:,196), nhel, den(382))
    call cont_QA(nsync, wf8(:,3), wf32(:,37), A(:,197), n3(:,595), t3x256(:,:,197), nhel, den(386))
    call cont_QA(nsync, wf8(:,6), wf32(:,37), A(:,198), n3(:,596), t3x256(:,:,198), nhel, den(387))
    call cont_QA(nsync, wf8(:,3), wf32(:,38), A(:,199), n3(:,597), t3x256(:,:,199), nhel, den(391))
    call cont_QA(nsync, wf8(:,6), wf32(:,38), A(:,200), n3(:,598), t3x256(:,:,200), nhel, den(392))
    call cont_QA(nsync, wf16(:,17), wf16(:,113), A(:,201), n3(:,599), t3x256(:,:,201), nhel, den(393))
    call cont_QA(nsync, wf16(:,19), wf16(:,113), A(:,202), n3(:,600), t3x256(:,:,202), nhel, den(394))
    call cont_QA(nsync, wf16(:,17), wf16(:,114), A(:,203), n3(:,601), t3x256(:,:,203), nhel, den(395))
    call cont_QA(nsync, wf16(:,19), wf16(:,114), A(:,204), n3(:,602), t3x256(:,:,204), nhel, den(396))
    call cont_QA(nsync, wf16(:,45), wf16(:,115), A(:,205), n3(:,603), t3x256(:,:,205), nhel, den(397))
    call cont_QA(nsync, wf16(:,47), wf16(:,115), A(:,206), n3(:,604), t3x256(:,:,206), nhel, den(398))
    call cont_QA(nsync, wf16(:,45), wf16(:,116), A(:,207), n3(:,605), t3x256(:,:,207), nhel, den(399))
    call cont_QA(nsync, wf16(:,47), wf16(:,116), A(:,208), n3(:,606), t3x256(:,:,208), nhel, den(400))
    call cont_VV(nsync, wf8(:,49), wf32(:,39), A(:,209), n3(:,607), t3x256(:,:,209), nhel, den(402))
    call cont_VV(nsync, wf8(:,49), wf32(:,40), A(:,210), n3(:,608), t3x256(:,:,210), nhel, den(404))
    call cont_VV(nsync, wf16(:,117), wf16(:,118), A(:,211), n3(:,609), t3x256(:,:,211), nhel, den(408))
    call cont_VV(nsync, wf16(:,117), wf16(:,119), A(:,212), n3(:,610), t3x256(:,:,212), nhel, den(409))
    call cont_QA(nsync, wf8(:,3), wf32(:,41), A(:,213), n3(:,611), t3x256(:,:,213), nhel, den(412))
    call cont_QA(nsync, wf8(:,6), wf32(:,41), A(:,214), n3(:,612), t3x256(:,:,214), nhel, den(413))
    call cont_VV(nsync, wf16(:,117), wf16(:,120), A(:,215), n3(:,613), t3x256(:,:,215), nhel, den(414))
    call cont_VV(nsync, wf16(:,117), wf16(:,121), A(:,216), n3(:,614), t3x256(:,:,216), nhel, den(415))
    call cont_QA(nsync, wf16(:,74), wf16(:,122), A(:,217), n3(:,615), t3x256(:,:,217), nhel, den(416))
    call cont_QA(nsync, wf16(:,76), wf16(:,122), A(:,218), n3(:,616), t3x256(:,:,218), nhel, den(417))
    call cont_QA(nsync, wf16(:,45), wf16(:,123), A(:,219), n3(:,617), t3x256(:,:,219), nhel, den(418))
    call cont_QA(nsync, wf16(:,47), wf16(:,123), A(:,220), n3(:,618), t3x256(:,:,220), nhel, den(419))
    call cont_QA(nsync, wf4(:,6), wf64(:,1), A(:,221), n3(:,619), t3x256(:,:,221), nhel, den(421))
    call cont_QA(nsync, wf4(:,6), wf64(:,2), A(:,222), n3(:,620), t3x256(:,:,222), nhel, den(423))
    call cont_VV(nsync, wf16(:,124), wf16(:,125), A(:,223), n3(:,621), t3x256(:,:,223), nhel, den(427))
    call cont_VV(nsync, wf16(:,124), wf16(:,126), A(:,224), n3(:,622), t3x256(:,:,224), nhel, den(428))
    call cont_VV(nsync, wf16(:,124), wf16(:,127), A(:,225), n3(:,623), t3x256(:,:,225), nhel, den(429))
    call cont_VV(nsync, wf16(:,124), wf16(:,128), A(:,226), n3(:,624), t3x256(:,:,226), nhel, den(430))
    call cont_QA(nsync, wf8(:,34), wf32(:,42), A(:,227), n3(:,625), t3x256(:,:,227), nhel, den(433))
    call cont_QA(nsync, wf8(:,36), wf32(:,42), A(:,228), n3(:,626), t3x256(:,:,228), nhel, den(434))
    call cont_QA(nsync, wf16(:,8), wf16(:,129), A(:,229), n3(:,627), t3x256(:,:,229), nhel, den(435))
    call cont_QA(nsync, wf16(:,10), wf16(:,129), A(:,230), n3(:,628), t3x256(:,:,230), nhel, den(436))
    call cont_QA(nsync, wf16(:,45), wf16(:,130), A(:,231), n3(:,629), t3x256(:,:,231), nhel, den(437))
    call cont_QA(nsync, wf16(:,47), wf16(:,130), A(:,232), n3(:,630), t3x256(:,:,232), nhel, den(438))
    call cont_QA(nsync, wf16(:,26), wf16(:,131), A(:,233), n3(:,631), t3x256(:,:,233), nhel, den(440))
    call cont_QA(nsync, wf16(:,27), wf16(:,131), A(:,234), n3(:,632), t3x256(:,:,234), nhel, den(441))
    call cont_QA(nsync, wf16(:,26), wf16(:,132), A(:,235), n3(:,633), t3x256(:,:,235), nhel, den(443))
    call cont_QA(nsync, wf16(:,27), wf16(:,132), A(:,236), n3(:,634), t3x256(:,:,236), nhel, den(444))
    call cont_VV(nsync, wf16(:,125), wf16(:,133), A(:,237), n3(:,635), t3x256(:,:,237), nhel, den(447))
    call cont_VV(nsync, wf16(:,126), wf16(:,133), A(:,238), n3(:,636), t3x256(:,:,238), nhel, den(449))
    call cont_VV(nsync, wf16(:,118), wf16(:,134), A(:,239), n3(:,637), t3x256(:,:,239), nhel, den(451))
    call cont_VV(nsync, wf16(:,119), wf16(:,134), A(:,240), n3(:,638), t3x256(:,:,240), nhel, den(452))
    call cont_QA(nsync, wf16(:,78), wf16(:,135), A(:,241), n3(:,639), t3x256(:,:,241), nhel, den(454))
    call cont_QA(nsync, wf16(:,79), wf16(:,135), A(:,242), n3(:,640), t3x256(:,:,242), nhel, den(455))
    call cont_VV(nsync, wf16(:,127), wf16(:,133), A(:,243), n3(:,641), t3x256(:,:,243), nhel, den(457))
    call cont_VV(nsync, wf16(:,128), wf16(:,133), A(:,244), n3(:,642), t3x256(:,:,244), nhel, den(459))
    call cont_QA(nsync, wf16(:,12), wf16(:,136), A(:,245), n3(:,643), t3x256(:,:,245), nhel, den(461))
    call cont_QA(nsync, wf16(:,13), wf16(:,136), A(:,246), n3(:,644), t3x256(:,:,246), nhel, den(462))
    call cont_VV(nsync, wf16(:,120), wf16(:,134), A(:,247), n3(:,645), t3x256(:,:,247), nhel, den(465))
    call cont_VV(nsync, wf16(:,121), wf16(:,134), A(:,248), n3(:,646), t3x256(:,:,248), nhel, den(467))
    call cont_VV(nsync, wf8(:,55), wf32(:,43), A(:,249), n3(:,647), t3x256(:,:,249), nhel, den(471))
    call cont_VV(nsync, wf8(:,55), wf32(:,44), A(:,250), n3(:,648), t3x256(:,:,250), nhel, den(473))
    call cont_VV(nsync, wf8(:,56), wf32(:,45), A(:,251), n3(:,649), t3x256(:,:,251), nhel, den(477))
    call cont_VV(nsync, wf8(:,56), wf32(:,46), A(:,252), n3(:,650), t3x256(:,:,252), nhel, den(479))
    call cont_QA(nsync, wf8(:,3), wf32(:,47), A(:,253), n3(:,651), t3x256(:,:,253), nhel, den(483))
    call cont_QA(nsync, wf8(:,6), wf32(:,47), A(:,254), n3(:,652), t3x256(:,:,254), nhel, den(484))
    call cont_QA(nsync, wf8(:,3), wf32(:,48), A(:,255), n3(:,653), t3x256(:,:,255), nhel, den(488))
    call cont_QA(nsync, wf8(:,6), wf32(:,48), A(:,256), n3(:,654), t3x256(:,:,256), nhel, den(489))
    call cont_QA(nsync, wf16(:,3), wf16(:,137), A(:,257), n3(:,655), t3x256(:,:,257), nhel, den(490))
    call cont_QA(nsync, wf16(:,5), wf16(:,137), A(:,258), n3(:,656), t3x256(:,:,258), nhel, den(491))
    call cont_QA(nsync, wf16(:,3), wf16(:,138), A(:,259), n3(:,657), t3x256(:,:,259), nhel, den(492))
    call cont_QA(nsync, wf16(:,5), wf16(:,138), A(:,260), n3(:,658), t3x256(:,:,260), nhel, den(493))
    call cont_QA(nsync, wf16(:,53), wf16(:,139), A(:,261), n3(:,659), t3x256(:,:,261), nhel, den(494))
    call cont_QA(nsync, wf16(:,55), wf16(:,139), A(:,262), n3(:,660), t3x256(:,:,262), nhel, den(495))
    call cont_QA(nsync, wf16(:,53), wf16(:,140), A(:,263), n3(:,661), t3x256(:,:,263), nhel, den(496))
    call cont_QA(nsync, wf16(:,55), wf16(:,140), A(:,264), n3(:,662), t3x256(:,:,264), nhel, den(497))
    call cont_VV(nsync, wf16(:,141), wf16(:,142), A(:,265), n3(:,663), t3x256(:,:,265), nhel, den(501))
    call cont_VV(nsync, wf16(:,141), wf16(:,143), A(:,266), n3(:,664), t3x256(:,:,266), nhel, den(502))
    call cont_VV(nsync, wf8(:,56), wf32(:,49), A(:,267), n3(:,665), t3x256(:,:,267), nhel, den(504))
    call cont_VV(nsync, wf8(:,56), wf32(:,50), A(:,268), n3(:,666), t3x256(:,:,268), nhel, den(506))
    call cont_QA(nsync, wf8(:,3), wf32(:,51), A(:,269), n3(:,667), t3x256(:,:,269), nhel, den(509))
    call cont_QA(nsync, wf8(:,6), wf32(:,51), A(:,270), n3(:,668), t3x256(:,:,270), nhel, den(510))
    call cont_VV(nsync, wf16(:,141), wf16(:,144), A(:,271), n3(:,669), t3x256(:,:,271), nhel, den(511))
    call cont_VV(nsync, wf16(:,141), wf16(:,145), A(:,272), n3(:,670), t3x256(:,:,272), nhel, den(512))
    call cont_QA(nsync, wf16(:,3), wf16(:,146), A(:,273), n3(:,671), t3x256(:,:,273), nhel, den(513))
    call cont_QA(nsync, wf16(:,5), wf16(:,146), A(:,274), n3(:,672), t3x256(:,:,274), nhel, den(514))
    call cont_QA(nsync, wf16(:,74), wf16(:,147), A(:,275), n3(:,673), t3x256(:,:,275), nhel, den(515))
    call cont_QA(nsync, wf16(:,76), wf16(:,147), A(:,276), n3(:,674), t3x256(:,:,276), nhel, den(516))
    call cont_VV(nsync, wf16(:,148), wf16(:,149), A(:,277), n3(:,675), t3x256(:,:,277), nhel, den(520))
    call cont_VV(nsync, wf16(:,148), wf16(:,150), A(:,278), n3(:,676), t3x256(:,:,278), nhel, den(521))
    call cont_QA(nsync, wf4(:,6), wf64(:,3), A(:,279), n3(:,677), t3x256(:,:,279), nhel, den(523))
    call cont_QA(nsync, wf4(:,6), wf64(:,4), A(:,280), n3(:,678), t3x256(:,:,280), nhel, den(525))
    call cont_VV(nsync, wf16(:,148), wf16(:,151), A(:,281), n3(:,679), t3x256(:,:,281), nhel, den(526))
    call cont_VV(nsync, wf16(:,148), wf16(:,152), A(:,282), n3(:,680), t3x256(:,:,282), nhel, den(527))
    call cont_QA(nsync, wf8(:,34), wf32(:,52), A(:,283), n3(:,681), t3x256(:,:,283), nhel, den(530))
    call cont_QA(nsync, wf8(:,36), wf32(:,52), A(:,284), n3(:,682), t3x256(:,:,284), nhel, den(531))
    call cont_QA(nsync, wf16(:,3), wf16(:,153), A(:,285), n3(:,683), t3x256(:,:,285), nhel, den(532))
    call cont_QA(nsync, wf16(:,5), wf16(:,153), A(:,286), n3(:,684), t3x256(:,:,286), nhel, den(533))
    call cont_QA(nsync, wf16(:,8), wf16(:,154), A(:,287), n3(:,685), t3x256(:,:,287), nhel, den(534))
    call cont_QA(nsync, wf16(:,10), wf16(:,154), A(:,288), n3(:,686), t3x256(:,:,288), nhel, den(535))
    call cont_VV(nsync, wf16(:,149), wf16(:,155), A(:,289), n3(:,687), t3x256(:,:,289), nhel, den(538))
    call cont_VV(nsync, wf16(:,150), wf16(:,155), A(:,290), n3(:,688), t3x256(:,:,290), nhel, den(540))
    call cont_VV(nsync, wf16(:,142), wf16(:,156), A(:,291), n3(:,689), t3x256(:,:,291), nhel, den(542))
    call cont_VV(nsync, wf16(:,143), wf16(:,156), A(:,292), n3(:,690), t3x256(:,:,292), nhel, den(543))
    call cont_QA(nsync, wf16(:,58), wf16(:,157), A(:,293), n3(:,691), t3x256(:,:,293), nhel, den(545))
    call cont_QA(nsync, wf16(:,59), wf16(:,157), A(:,294), n3(:,692), t3x256(:,:,294), nhel, den(546))
    call cont_QA(nsync, wf16(:,58), wf16(:,158), A(:,295), n3(:,693), t3x256(:,:,295), nhel, den(548))
    call cont_QA(nsync, wf16(:,59), wf16(:,158), A(:,296), n3(:,694), t3x256(:,:,296), nhel, den(549))
    call cont_VV(nsync, wf16(:,151), wf16(:,155), A(:,297), n3(:,695), t3x256(:,:,297), nhel, den(551))
    call cont_VV(nsync, wf16(:,152), wf16(:,155), A(:,298), n3(:,696), t3x256(:,:,298), nhel, den(553))
    call cont_QA(nsync, wf16(:,78), wf16(:,159), A(:,299), n3(:,697), t3x256(:,:,299), nhel, den(555))
    call cont_QA(nsync, wf16(:,79), wf16(:,159), A(:,300), n3(:,698), t3x256(:,:,300), nhel, den(556))
    call cont_VV(nsync, wf16(:,144), wf16(:,156), A(:,301), n3(:,699), t3x256(:,:,301), nhel, den(559))
    call cont_VV(nsync, wf16(:,145), wf16(:,156), A(:,302), n3(:,700), t3x256(:,:,302), nhel, den(561))
    call cont_QA(nsync, wf16(:,12), wf16(:,160), A(:,303), n3(:,701), t3x256(:,:,303), nhel, den(563))
    call cont_QA(nsync, wf16(:,13), wf16(:,160), A(:,304), n3(:,702), t3x256(:,:,304), nhel, den(564))
    call cont_VV(nsync, wf8(:,55), wf32(:,53), A(:,305), n3(:,703), t3x256(:,:,305), nhel, den(566))
    call cont_VV(nsync, wf8(:,55), wf32(:,54), A(:,306), n3(:,704), t3x256(:,:,306), nhel, den(568))
    call cont_VV(nsync, wf16(:,118), wf16(:,161), A(:,307), n3(:,705), t3x256(:,:,307), nhel, den(571))
    call cont_VV(nsync, wf16(:,119), wf16(:,161), A(:,308), n3(:,706), t3x256(:,:,308), nhel, den(572))
    call cont_QA(nsync, wf8(:,3), wf32(:,55), A(:,309), n3(:,707), t3x256(:,:,309), nhel, den(575))
    call cont_QA(nsync, wf8(:,6), wf32(:,55), A(:,310), n3(:,708), t3x256(:,:,310), nhel, den(576))
    call cont_VV(nsync, wf16(:,120), wf16(:,161), A(:,311), n3(:,709), t3x256(:,:,311), nhel, den(577))
    call cont_VV(nsync, wf16(:,121), wf16(:,161), A(:,312), n3(:,710), t3x256(:,:,312), nhel, den(578))
    call cont_QA(nsync, wf16(:,84), wf16(:,162), A(:,313), n3(:,711), t3x256(:,:,313), nhel, den(579))
    call cont_QA(nsync, wf16(:,86), wf16(:,162), A(:,314), n3(:,712), t3x256(:,:,314), nhel, den(580))
    call cont_QA(nsync, wf16(:,53), wf16(:,163), A(:,315), n3(:,713), t3x256(:,:,315), nhel, den(581))
    call cont_QA(nsync, wf16(:,55), wf16(:,163), A(:,316), n3(:,714), t3x256(:,:,316), nhel, den(582))
    call cont_VV(nsync, wf16(:,142), wf16(:,164), A(:,317), n3(:,715), t3x256(:,:,317), nhel, den(585))
    call cont_VV(nsync, wf16(:,143), wf16(:,164), A(:,318), n3(:,716), t3x256(:,:,318), nhel, den(586))
    call cont_VV(nsync, wf8(:,50), wf32(:,56), A(:,319), n3(:,717), t3x256(:,:,319), nhel, den(588))
    call cont_VV(nsync, wf8(:,50), wf32(:,57), A(:,320), n3(:,718), t3x256(:,:,320), nhel, den(590))
    call cont_QA(nsync, wf8(:,3), wf32(:,58), A(:,321), n3(:,719), t3x256(:,:,321), nhel, den(593))
    call cont_QA(nsync, wf8(:,6), wf32(:,58), A(:,322), n3(:,720), t3x256(:,:,322), nhel, den(594))
    call cont_VV(nsync, wf16(:,144), wf16(:,164), A(:,323), n3(:,721), t3x256(:,:,323), nhel, den(595))
    call cont_VV(nsync, wf16(:,145), wf16(:,164), A(:,324), n3(:,722), t3x256(:,:,324), nhel, den(596))
    call cont_QA(nsync, wf16(:,17), wf16(:,165), A(:,325), n3(:,723), t3x256(:,:,325), nhel, den(597))
    call cont_QA(nsync, wf16(:,19), wf16(:,165), A(:,326), n3(:,724), t3x256(:,:,326), nhel, den(598))
    call cont_QA(nsync, wf16(:,84), wf16(:,166), A(:,327), n3(:,725), t3x256(:,:,327), nhel, den(599))
    call cont_QA(nsync, wf16(:,86), wf16(:,166), A(:,328), n3(:,726), t3x256(:,:,328), nhel, den(600))
    call cont_QA(nsync, wf4(:,6), wf64(:,5), A(:,329), n3(:,727), t3x256(:,:,329), nhel, den(602))
    call cont_QA(nsync, wf4(:,6), wf64(:,6), A(:,330), n3(:,728), t3x256(:,:,330), nhel, den(604))
    call cont_QA(nsync, wf4(:,22), wf64(:,7), A(:,331), n3(:,729), t3x256(:,:,331), nhel, den(606))
    call cont_QA(nsync, wf4(:,22), wf64(:,8), A(:,332), n3(:,730), t3x256(:,:,332), nhel, den(608))
    call cont_QA(nsync, wf4(:,6), wf64(:,9), A(:,333), n3(:,731), t3x256(:,:,333), nhel, den(610))
    call cont_QA(nsync, wf4(:,6), wf64(:,10), A(:,334), n3(:,732), t3x256(:,:,334), nhel, den(612))
    call cont_QA(nsync, wf4(:,22), wf64(:,11), A(:,335), n3(:,733), t3x256(:,:,335), nhel, den(614))
    call cont_QA(nsync, wf4(:,22), wf64(:,12), A(:,336), n3(:,734), t3x256(:,:,336), nhel, den(616))
    call cont_QA(nsync, wf16(:,8), wf16(:,167), A(:,337), n3(:,735), t3x256(:,:,337), nhel, den(617))
    call cont_QA(nsync, wf16(:,10), wf16(:,167), A(:,338), n3(:,736), t3x256(:,:,338), nhel, den(618))
    call cont_QA(nsync, wf16(:,84), wf16(:,168), A(:,339), n3(:,737), t3x256(:,:,339), nhel, den(619))
    call cont_QA(nsync, wf16(:,86), wf16(:,168), A(:,340), n3(:,738), t3x256(:,:,340), nhel, den(620))
    call cont_QA(nsync, wf16(:,8), wf16(:,169), A(:,341), n3(:,739), t3x256(:,:,341), nhel, den(621))
    call cont_QA(nsync, wf16(:,10), wf16(:,169), A(:,342), n3(:,740), t3x256(:,:,342), nhel, den(622))
    call cont_QA(nsync, wf16(:,84), wf16(:,170), A(:,343), n3(:,741), t3x256(:,:,343), nhel, den(623))
    call cont_QA(nsync, wf16(:,86), wf16(:,170), A(:,344), n3(:,742), t3x256(:,:,344), nhel, den(624))
    call cont_VV(nsync, wf16(:,142), wf16(:,171), A(:,345), n3(:,743), t3x256(:,:,345), nhel, den(626))
    call cont_VV(nsync, wf16(:,143), wf16(:,171), A(:,346), n3(:,744), t3x256(:,:,346), nhel, den(627))
    call cont_QA(nsync, wf16(:,58), wf16(:,172), A(:,347), n3(:,745), t3x256(:,:,347), nhel, den(629))
    call cont_QA(nsync, wf16(:,59), wf16(:,172), A(:,348), n3(:,746), t3x256(:,:,348), nhel, den(630))
    call cont_QA(nsync, wf16(:,26), wf16(:,173), A(:,349), n3(:,747), t3x256(:,:,349), nhel, den(632))
    call cont_QA(nsync, wf16(:,27), wf16(:,173), A(:,350), n3(:,748), t3x256(:,:,350), nhel, den(633))
    call cont_VV(nsync, wf16(:,118), wf16(:,174), A(:,351), n3(:,749), t3x256(:,:,351), nhel, den(635))
    call cont_VV(nsync, wf16(:,119), wf16(:,174), A(:,352), n3(:,750), t3x256(:,:,352), nhel, den(636))
    call cont_QA(nsync, wf16(:,12), wf16(:,175), A(:,353), n3(:,751), t3x256(:,:,353), nhel, den(638))
    call cont_QA(nsync, wf16(:,13), wf16(:,175), A(:,354), n3(:,752), t3x256(:,:,354), nhel, den(639))
    call cont_VV(nsync, wf16(:,144), wf16(:,171), A(:,355), n3(:,753), t3x256(:,:,355), nhel, den(640))
    call cont_VV(nsync, wf16(:,145), wf16(:,171), A(:,356), n3(:,754), t3x256(:,:,356), nhel, den(641))
    call cont_QA(nsync, wf16(:,12), wf16(:,176), A(:,357), n3(:,755), t3x256(:,:,357), nhel, den(643))
    call cont_QA(nsync, wf16(:,13), wf16(:,176), A(:,358), n3(:,756), t3x256(:,:,358), nhel, den(644))
    call cont_VV(nsync, wf16(:,120), wf16(:,174), A(:,359), n3(:,757), t3x256(:,:,359), nhel, den(645))
    call cont_VV(nsync, wf16(:,121), wf16(:,174), A(:,360), n3(:,758), t3x256(:,:,360), nhel, den(646))
    call cont_QA(nsync, wf4(:,12), wf64(:,13), A(:,361), n3(:,759), t3x256(:,:,361), nhel, den(648))
    call cont_QA(nsync, wf4(:,12), wf64(:,14), A(:,362), n3(:,760), t3x256(:,:,362), nhel, den(650))
    call cont_VV(nsync, wf16(:,125), wf16(:,177), A(:,363), n3(:,761), t3x256(:,:,363), nhel, den(653))
    call cont_VV(nsync, wf16(:,126), wf16(:,177), A(:,364), n3(:,762), t3x256(:,:,364), nhel, den(654))
    call cont_VV(nsync, wf16(:,127), wf16(:,177), A(:,365), n3(:,763), t3x256(:,:,365), nhel, den(655))
    call cont_VV(nsync, wf16(:,128), wf16(:,177), A(:,366), n3(:,764), t3x256(:,:,366), nhel, den(656))
    call cont_QA(nsync, wf8(:,34), wf32(:,59), A(:,367), n3(:,765), t3x256(:,:,367), nhel, den(659))
    call cont_QA(nsync, wf8(:,36), wf32(:,59), A(:,368), n3(:,766), t3x256(:,:,368), nhel, den(660))
    call cont_QA(nsync, wf16(:,22), wf16(:,178), A(:,369), n3(:,767), t3x256(:,:,369), nhel, den(661))
    call cont_QA(nsync, wf16(:,24), wf16(:,178), A(:,370), n3(:,768), t3x256(:,:,370), nhel, den(662))
    call cont_QA(nsync, wf16(:,53), wf16(:,179), A(:,371), n3(:,769), t3x256(:,:,371), nhel, den(663))
    call cont_QA(nsync, wf16(:,55), wf16(:,179), A(:,372), n3(:,770), t3x256(:,:,372), nhel, den(664))
    call cont_VV(nsync, wf16(:,149), wf16(:,180), A(:,373), n3(:,771), t3x256(:,:,373), nhel, den(667))
    call cont_VV(nsync, wf16(:,150), wf16(:,180), A(:,374), n3(:,772), t3x256(:,:,374), nhel, den(668))
    call cont_QA(nsync, wf4(:,12), wf64(:,15), A(:,375), n3(:,773), t3x256(:,:,375), nhel, den(670))
    call cont_QA(nsync, wf4(:,12), wf64(:,16), A(:,376), n3(:,774), t3x256(:,:,376), nhel, den(672))
    call cont_VV(nsync, wf16(:,151), wf16(:,180), A(:,377), n3(:,775), t3x256(:,:,377), nhel, den(673))
    call cont_VV(nsync, wf16(:,152), wf16(:,180), A(:,378), n3(:,776), t3x256(:,:,378), nhel, den(674))
    call cont_QA(nsync, wf8(:,34), wf32(:,60), A(:,379), n3(:,777), t3x256(:,:,379), nhel, den(677))
    call cont_QA(nsync, wf8(:,36), wf32(:,60), A(:,380), n3(:,778), t3x256(:,:,380), nhel, den(678))
    call cont_QA(nsync, wf16(:,17), wf16(:,181), A(:,381), n3(:,779), t3x256(:,:,381), nhel, den(679))
    call cont_QA(nsync, wf16(:,19), wf16(:,181), A(:,382), n3(:,780), t3x256(:,:,382), nhel, den(680))
    call cont_QA(nsync, wf16(:,22), wf16(:,182), A(:,383), n3(:,781), t3x256(:,:,383), nhel, den(681))
    call cont_QA(nsync, wf16(:,24), wf16(:,182), A(:,384), n3(:,782), t3x256(:,:,384), nhel, den(682))
    call cont_QA(nsync, wf4(:,12), wf64(:,17), A(:,385), n3(:,783), t3x256(:,:,385), nhel, den(684))
    call cont_QA(nsync, wf4(:,12), wf64(:,18), A(:,386), n3(:,784), t3x256(:,:,386), nhel, den(686))
    call cont_QA(nsync, wf4(:,20), wf64(:,19), A(:,387), n3(:,785), t3x256(:,:,387), nhel, den(688))
    call cont_QA(nsync, wf4(:,20), wf64(:,20), A(:,388), n3(:,786), t3x256(:,:,388), nhel, den(690))
    call cont_QA(nsync, wf4(:,12), wf64(:,21), A(:,389), n3(:,787), t3x256(:,:,389), nhel, den(692))
    call cont_QA(nsync, wf4(:,12), wf64(:,22), A(:,390), n3(:,788), t3x256(:,:,390), nhel, den(694))
    call cont_QA(nsync, wf4(:,20), wf64(:,23), A(:,391), n3(:,789), t3x256(:,:,391), nhel, den(696))
    call cont_QA(nsync, wf4(:,20), wf64(:,24), A(:,392), n3(:,790), t3x256(:,:,392), nhel, den(698))
    call cont_QA(nsync, wf16(:,22), wf16(:,183), A(:,393), n3(:,791), t3x256(:,:,393), nhel, den(699))
    call cont_QA(nsync, wf16(:,24), wf16(:,183), A(:,394), n3(:,792), t3x256(:,:,394), nhel, den(700))
    call cont_QA(nsync, wf16(:,74), wf16(:,184), A(:,395), n3(:,793), t3x256(:,:,395), nhel, den(701))
    call cont_QA(nsync, wf16(:,76), wf16(:,184), A(:,396), n3(:,794), t3x256(:,:,396), nhel, den(702))
    call cont_QA(nsync, wf16(:,22), wf16(:,185), A(:,397), n3(:,795), t3x256(:,:,397), nhel, den(703))
    call cont_QA(nsync, wf16(:,24), wf16(:,185), A(:,398), n3(:,796), t3x256(:,:,398), nhel, den(704))
    call cont_QA(nsync, wf16(:,74), wf16(:,186), A(:,399), n3(:,797), t3x256(:,:,399), nhel, den(705))
    call cont_QA(nsync, wf16(:,76), wf16(:,186), A(:,400), n3(:,798), t3x256(:,:,400), nhel, den(706))
    call cont_VV(nsync, wf16(:,149), wf16(:,187), A(:,401), n3(:,799), t3x256(:,:,401), nhel, den(708))
    call cont_VV(nsync, wf16(:,150), wf16(:,187), A(:,402), n3(:,800), t3x256(:,:,402), nhel, den(709))
    call cont_QA(nsync, wf16(:,58), wf16(:,188), A(:,403), n3(:,801), t3x256(:,:,403), nhel, den(711))
    call cont_QA(nsync, wf16(:,59), wf16(:,188), A(:,404), n3(:,802), t3x256(:,:,404), nhel, den(712))
    call cont_QA(nsync, wf16(:,26), wf16(:,189), A(:,405), n3(:,803), t3x256(:,:,405), nhel, den(714))
    call cont_QA(nsync, wf16(:,27), wf16(:,189), A(:,406), n3(:,804), t3x256(:,:,406), nhel, den(715))
    call cont_VV(nsync, wf16(:,125), wf16(:,190), A(:,407), n3(:,805), t3x256(:,:,407), nhel, den(717))
    call cont_VV(nsync, wf16(:,126), wf16(:,190), A(:,408), n3(:,806), t3x256(:,:,408), nhel, den(718))
    call cont_VV(nsync, wf16(:,151), wf16(:,187), A(:,409), n3(:,807), t3x256(:,:,409), nhel, den(719))
    call cont_VV(nsync, wf16(:,152), wf16(:,187), A(:,410), n3(:,808), t3x256(:,:,410), nhel, den(720))
    call cont_QA(nsync, wf16(:,78), wf16(:,191), A(:,411), n3(:,809), t3x256(:,:,411), nhel, den(722))
    call cont_QA(nsync, wf16(:,79), wf16(:,191), A(:,412), n3(:,810), t3x256(:,:,412), nhel, den(723))
    call cont_VV(nsync, wf16(:,127), wf16(:,190), A(:,413), n3(:,811), t3x256(:,:,413), nhel, den(724))
    call cont_VV(nsync, wf16(:,128), wf16(:,190), A(:,414), n3(:,812), t3x256(:,:,414), nhel, den(725))
    call cont_QA(nsync, wf16(:,78), wf16(:,192), A(:,415), n3(:,813), t3x256(:,:,415), nhel, den(727))
    call cont_QA(nsync, wf16(:,79), wf16(:,192), A(:,416), n3(:,814), t3x256(:,:,416), nhel, den(728))
    call cont_QA(nsync, wf16(:,34), wf16(:,193), A(:,417), n3(:,815), t3x256(:,:,417), nhel, den(730))
    call cont_QA(nsync, wf16(:,35), wf16(:,193), A(:,418), n3(:,816), t3x256(:,:,418), nhel, den(731))
    call cont_QA(nsync, wf16(:,34), wf16(:,194), A(:,419), n3(:,817), t3x256(:,:,419), nhel, den(733))
    call cont_QA(nsync, wf16(:,35), wf16(:,194), A(:,420), n3(:,818), t3x256(:,:,420), nhel, den(734))
    call cont_VV(nsync, wf16(:,125), wf16(:,195), A(:,421), n3(:,819), t3x256(:,:,421), nhel, den(735))
    call cont_VV(nsync, wf16(:,126), wf16(:,195), A(:,422), n3(:,820), t3x256(:,:,422), nhel, den(736))
    call cont_VV(nsync, wf16(:,118), wf16(:,196), A(:,423), n3(:,821), t3x256(:,:,423), nhel, den(738))
    call cont_VV(nsync, wf16(:,119), wf16(:,196), A(:,424), n3(:,822), t3x256(:,:,424), nhel, den(739))
    call cont_QA(nsync, wf16(:,90), wf16(:,197), A(:,425), n3(:,823), t3x256(:,:,425), nhel, den(741))
    call cont_QA(nsync, wf16(:,91), wf16(:,197), A(:,426), n3(:,824), t3x256(:,:,426), nhel, den(742))
    call cont_VV(nsync, wf16(:,127), wf16(:,195), A(:,427), n3(:,825), t3x256(:,:,427), nhel, den(743))
    call cont_VV(nsync, wf16(:,128), wf16(:,195), A(:,428), n3(:,826), t3x256(:,:,428), nhel, den(744))
    call cont_QA(nsync, wf16(:,30), wf16(:,198), A(:,429), n3(:,827), t3x256(:,:,429), nhel, den(746))
    call cont_QA(nsync, wf16(:,31), wf16(:,198), A(:,430), n3(:,828), t3x256(:,:,430), nhel, den(747))
    call cont_VV(nsync, wf16(:,120), wf16(:,196), A(:,431), n3(:,829), t3x256(:,:,431), nhel, den(748))
    call cont_VV(nsync, wf16(:,121), wf16(:,196), A(:,432), n3(:,830), t3x256(:,:,432), nhel, den(749))
    call cont_VV(nsync, wf16(:,149), wf16(:,199), A(:,433), n3(:,831), t3x256(:,:,433), nhel, den(750))
    call cont_VV(nsync, wf16(:,150), wf16(:,199), A(:,434), n3(:,832), t3x256(:,:,434), nhel, den(751))
    call cont_VV(nsync, wf16(:,142), wf16(:,200), A(:,435), n3(:,833), t3x256(:,:,435), nhel, den(753))
    call cont_VV(nsync, wf16(:,143), wf16(:,200), A(:,436), n3(:,834), t3x256(:,:,436), nhel, den(754))
    call cont_QA(nsync, wf16(:,64), wf16(:,201), A(:,437), n3(:,835), t3x256(:,:,437), nhel, den(756))
    call cont_QA(nsync, wf16(:,65), wf16(:,201), A(:,438), n3(:,836), t3x256(:,:,438), nhel, den(757))
    call cont_QA(nsync, wf16(:,64), wf16(:,202), A(:,439), n3(:,837), t3x256(:,:,439), nhel, den(759))
    call cont_QA(nsync, wf16(:,65), wf16(:,202), A(:,440), n3(:,838), t3x256(:,:,440), nhel, den(760))
    call cont_VV(nsync, wf16(:,151), wf16(:,199), A(:,441), n3(:,839), t3x256(:,:,441), nhel, den(761))
    call cont_VV(nsync, wf16(:,152), wf16(:,199), A(:,442), n3(:,840), t3x256(:,:,442), nhel, den(762))
    call cont_QA(nsync, wf16(:,90), wf16(:,203), A(:,443), n3(:,841), t3x256(:,:,443), nhel, den(764))
    call cont_QA(nsync, wf16(:,91), wf16(:,203), A(:,444), n3(:,842), t3x256(:,:,444), nhel, den(765))
    call cont_VV(nsync, wf16(:,144), wf16(:,200), A(:,445), n3(:,843), t3x256(:,:,445), nhel, den(766))
    call cont_VV(nsync, wf16(:,145), wf16(:,200), A(:,446), n3(:,844), t3x256(:,:,446), nhel, den(767))
    call cont_QA(nsync, wf16(:,30), wf16(:,204), A(:,447), n3(:,845), t3x256(:,:,447), nhel, den(769))
    call cont_QA(nsync, wf16(:,31), wf16(:,204), A(:,448), n3(:,846), t3x256(:,:,448), nhel, den(770))
    call cont_VV(nsync, wf16(:,142), wf16(:,205), A(:,449), n3(:,847), t3x256(:,:,449), nhel, den(772))
    call cont_VV(nsync, wf16(:,143), wf16(:,205), A(:,450), n3(:,848), t3x256(:,:,450), nhel, den(773))
    call cont_QA(nsync, wf16(:,64), wf16(:,206), A(:,451), n3(:,849), t3x256(:,:,451), nhel, den(775))
    call cont_QA(nsync, wf16(:,65), wf16(:,206), A(:,452), n3(:,850), t3x256(:,:,452), nhel, den(776))
    call cont_QA(nsync, wf16(:,34), wf16(:,207), A(:,453), n3(:,851), t3x256(:,:,453), nhel, den(778))
    call cont_QA(nsync, wf16(:,35), wf16(:,207), A(:,454), n3(:,852), t3x256(:,:,454), nhel, den(779))
    call cont_VV(nsync, wf16(:,118), wf16(:,208), A(:,455), n3(:,853), t3x256(:,:,455), nhel, den(781))
    call cont_VV(nsync, wf16(:,119), wf16(:,208), A(:,456), n3(:,854), t3x256(:,:,456), nhel, den(782))
    call cont_QA(nsync, wf16(:,30), wf16(:,209), A(:,457), n3(:,855), t3x256(:,:,457), nhel, den(784))
    call cont_QA(nsync, wf16(:,31), wf16(:,209), A(:,458), n3(:,856), t3x256(:,:,458), nhel, den(785))
    call cont_VV(nsync, wf16(:,144), wf16(:,205), A(:,459), n3(:,857), t3x256(:,:,459), nhel, den(786))
    call cont_VV(nsync, wf16(:,145), wf16(:,205), A(:,460), n3(:,858), t3x256(:,:,460), nhel, den(787))
    call cont_QA(nsync, wf16(:,30), wf16(:,210), A(:,461), n3(:,859), t3x256(:,:,461), nhel, den(789))
    call cont_QA(nsync, wf16(:,31), wf16(:,210), A(:,462), n3(:,860), t3x256(:,:,462), nhel, den(790))
    call cont_VV(nsync, wf16(:,120), wf16(:,208), A(:,463), n3(:,861), t3x256(:,:,463), nhel, den(791))
    call cont_VV(nsync, wf16(:,121), wf16(:,208), A(:,464), n3(:,862), t3x256(:,:,464), nhel, den(792))
    call cont_VV(nsync, wf16(:,149), wf16(:,211), A(:,465), n3(:,863), t3x256(:,:,465), nhel, den(794))
    call cont_VV(nsync, wf16(:,150), wf16(:,211), A(:,466), n3(:,864), t3x256(:,:,466), nhel, den(795))
    call cont_QA(nsync, wf16(:,64), wf16(:,212), A(:,467), n3(:,865), t3x256(:,:,467), nhel, den(797))
    call cont_QA(nsync, wf16(:,65), wf16(:,212), A(:,468), n3(:,866), t3x256(:,:,468), nhel, den(798))
    call cont_QA(nsync, wf16(:,34), wf16(:,213), A(:,469), n3(:,867), t3x256(:,:,469), nhel, den(800))
    call cont_QA(nsync, wf16(:,35), wf16(:,213), A(:,470), n3(:,868), t3x256(:,:,470), nhel, den(801))
    call cont_VV(nsync, wf16(:,125), wf16(:,214), A(:,471), n3(:,869), t3x256(:,:,471), nhel, den(803))
    call cont_VV(nsync, wf16(:,126), wf16(:,214), A(:,472), n3(:,870), t3x256(:,:,472), nhel, den(804))
    call cont_VV(nsync, wf16(:,151), wf16(:,211), A(:,473), n3(:,871), t3x256(:,:,473), nhel, den(805))
    call cont_VV(nsync, wf16(:,152), wf16(:,211), A(:,474), n3(:,872), t3x256(:,:,474), nhel, den(806))
    call cont_QA(nsync, wf16(:,90), wf16(:,215), A(:,475), n3(:,873), t3x256(:,:,475), nhel, den(808))
    call cont_QA(nsync, wf16(:,91), wf16(:,215), A(:,476), n3(:,874), t3x256(:,:,476), nhel, den(809))
    call cont_VV(nsync, wf16(:,127), wf16(:,214), A(:,477), n3(:,875), t3x256(:,:,477), nhel, den(810))
    call cont_VV(nsync, wf16(:,128), wf16(:,214), A(:,478), n3(:,876), t3x256(:,:,478), nhel, den(811))
    call cont_QA(nsync, wf16(:,90), wf16(:,216), A(:,479), n3(:,877), t3x256(:,:,479), nhel, den(813))
    call cont_QA(nsync, wf16(:,91), wf16(:,216), A(:,480), n3(:,878), t3x256(:,:,480), nhel, den(814))
    call cont_VV(nsync, wf16(:,217), wf16(:,218), A(:,481), n3(:,879), t3x256(:,:,481), nhel, den(820))
    call cont_VV(nsync, wf16(:,220), wf16(:,221), A(:,482), n3(:,880), t3x256(:,:,482), nhel, den(823))
    call cont_VV(nsync, wf16(:,217), wf16(:,222), A(:,483), n3(:,881), t3x256(:,:,483), nhel, den(824))
    call cont_VV(nsync, wf16(:,220), wf16(:,223), A(:,484), n3(:,882), t3x256(:,:,484), nhel, den(825))
    call cont_QA(nsync, wf16(:,29), wf16(:,224), A(:,485), n3(:,883), t3x256(:,:,485), nhel, den(828))
    call cont_QA(nsync, wf16(:,29), wf16(:,225), A(:,486), n3(:,884), t3x256(:,:,486), nhel, den(831))
    call cont_QA(nsync, wf8(:,8), wf32(:,61), A(:,487), n3(:,885), t3x256(:,:,487), nhel, den(833))
    call cont_QA(nsync, wf8(:,8), wf32(:,62), A(:,488), n3(:,886), t3x256(:,:,488), nhel, den(835))
    call cont_QA(nsync, wf16(:,33), wf16(:,226), A(:,489), n3(:,887), t3x256(:,:,489), nhel, den(836))
    call cont_QA(nsync, wf16(:,33), wf16(:,227), A(:,490), n3(:,888), t3x256(:,:,490), nhel, den(837))
    call cont_QA(nsync, wf4(:,6), wf64(:,25), A(:,491), n3(:,889), t3x256(:,:,491), nhel, den(839))
    call cont_QA(nsync, wf4(:,6), wf64(:,26), A(:,492), n3(:,890), t3x256(:,:,492), nhel, den(841))
    call cont_QA(nsync, wf16(:,14), wf16(:,228), A(:,493), n3(:,891), t3x256(:,:,493), nhel, den(843))
    call cont_QA(nsync, wf16(:,14), wf16(:,229), A(:,494), n3(:,892), t3x256(:,:,494), nhel, den(845))
    call cont_QA(nsync, wf16(:,28), wf16(:,230), A(:,495), n3(:,893), t3x256(:,:,495), nhel, den(847))
    call cont_QA(nsync, wf16(:,28), wf16(:,231), A(:,496), n3(:,894), t3x256(:,:,496), nhel, den(849))
    call cont_VV(nsync, wf16(:,222), wf16(:,232), A(:,497), n3(:,895), t3x256(:,:,497), nhel, den(853))
    call cont_VV(nsync, wf16(:,223), wf16(:,234), A(:,498), n3(:,896), t3x256(:,:,498), nhel, den(855))
    call cont_VV(nsync, wf16(:,218), wf16(:,232), A(:,499), n3(:,897), t3x256(:,:,499), nhel, den(856))
    call cont_VV(nsync, wf16(:,221), wf16(:,234), A(:,500), n3(:,898), t3x256(:,:,500), nhel, den(857))
    call cont_VV(nsync, wf16(:,218), wf16(:,235), A(:,501), n3(:,899), t3x256(:,:,501), nhel, den(862))
    call cont_VV(nsync, wf16(:,221), wf16(:,237), A(:,502), n3(:,900), t3x256(:,:,502), nhel, den(864))
    call cont_VV(nsync, wf16(:,222), wf16(:,235), A(:,503), n3(:,901), t3x256(:,:,503), nhel, den(865))
    call cont_VV(nsync, wf16(:,223), wf16(:,237), A(:,504), n3(:,902), t3x256(:,:,504), nhel, den(866))
    call cont_QA(nsync, wf16(:,29), wf16(:,238), A(:,505), n3(:,903), t3x256(:,:,505), nhel, den(868))
    call cont_QA(nsync, wf16(:,29), wf16(:,239), A(:,506), n3(:,904), t3x256(:,:,506), nhel, den(870))
    call cont_QA(nsync, wf8(:,8), wf32(:,63), A(:,507), n3(:,905), t3x256(:,:,507), nhel, den(872))
    call cont_QA(nsync, wf8(:,8), wf32(:,64), A(:,508), n3(:,906), t3x256(:,:,508), nhel, den(874))
    call cont_QA(nsync, wf16(:,33), wf16(:,240), A(:,509), n3(:,907), t3x256(:,:,509), nhel, den(875))
    call cont_QA(nsync, wf16(:,33), wf16(:,241), A(:,510), n3(:,908), t3x256(:,:,510), nhel, den(876))
    call cont_QA(nsync, wf4(:,6), wf64(:,27), A(:,511), n3(:,909), t3x256(:,:,511), nhel, den(878))
    call cont_QA(nsync, wf4(:,6), wf64(:,28), A(:,512), n3(:,910), t3x256(:,:,512), nhel, den(880))
    call cont_QA(nsync, wf16(:,14), wf16(:,242), A(:,513), n3(:,911), t3x256(:,:,513), nhel, den(882))
    call cont_QA(nsync, wf16(:,14), wf16(:,243), A(:,514), n3(:,912), t3x256(:,:,514), nhel, den(884))
    call cont_QA(nsync, wf16(:,28), wf16(:,244), A(:,515), n3(:,913), t3x256(:,:,515), nhel, den(886))
    call cont_QA(nsync, wf16(:,28), wf16(:,245), A(:,516), n3(:,914), t3x256(:,:,516), nhel, den(888))
    call cont_VV(nsync, wf16(:,222), wf16(:,246), A(:,517), n3(:,915), t3x256(:,:,517), nhel, den(892))
    call cont_VV(nsync, wf16(:,223), wf16(:,248), A(:,518), n3(:,916), t3x256(:,:,518), nhel, den(894))
    call cont_VV(nsync, wf16(:,218), wf16(:,246), A(:,519), n3(:,917), t3x256(:,:,519), nhel, den(895))
    call cont_VV(nsync, wf16(:,221), wf16(:,248), A(:,520), n3(:,918), t3x256(:,:,520), nhel, den(896))
    call cont_QA(nsync, wf16(:,11), wf16(:,249), A(:,521), n3(:,919), t3x256(:,:,521), nhel, den(899))
    call cont_QA(nsync, wf16(:,11), wf16(:,250), A(:,522), n3(:,920), t3x256(:,:,522), nhel, den(902))
    call cont_QA(nsync, wf8(:,8), wf32(:,65), A(:,523), n3(:,921), t3x256(:,:,523), nhel, den(904))
    call cont_QA(nsync, wf8(:,8), wf32(:,66), A(:,524), n3(:,922), t3x256(:,:,524), nhel, den(906))
    call cont_QA(nsync, wf16(:,11), wf16(:,251), A(:,525), n3(:,923), t3x256(:,:,525), nhel, den(908))
    call cont_QA(nsync, wf16(:,11), wf16(:,252), A(:,526), n3(:,924), t3x256(:,:,526), nhel, den(910))
    call cont_QA(nsync, wf8(:,8), wf32(:,67), A(:,527), n3(:,925), t3x256(:,:,527), nhel, den(912))
    call cont_QA(nsync, wf8(:,8), wf32(:,68), A(:,528), n3(:,926), t3x256(:,:,528), nhel, den(914))
    call cont_QA(nsync, wf16(:,25), wf16(:,253), A(:,529), n3(:,927), t3x256(:,:,529), nhel, den(915))
    call cont_QA(nsync, wf16(:,25), wf16(:,254), A(:,530), n3(:,928), t3x256(:,:,530), nhel, den(916))
    call cont_QA(nsync, wf4(:,12), wf64(:,29), A(:,531), n3(:,929), t3x256(:,:,531), nhel, den(918))
    call cont_QA(nsync, wf4(:,12), wf64(:,30), A(:,532), n3(:,930), t3x256(:,:,532), nhel, den(920))
    call cont_QA(nsync, wf16(:,25), wf16(:,255), A(:,533), n3(:,931), t3x256(:,:,533), nhel, den(921))
    call cont_QA(nsync, wf16(:,25), wf16(:,256), A(:,534), n3(:,932), t3x256(:,:,534), nhel, den(922))
    call cont_QA(nsync, wf4(:,12), wf64(:,31), A(:,535), n3(:,933), t3x256(:,:,535), nhel, den(924))
    call cont_QA(nsync, wf4(:,12), wf64(:,32), A(:,536), n3(:,934), t3x256(:,:,536), nhel, den(926))
    call cont_QA(nsync, wf16(:,32), wf16(:,257), A(:,537), n3(:,935), t3x256(:,:,537), nhel, den(928))
    call cont_QA(nsync, wf16(:,32), wf16(:,258), A(:,538), n3(:,936), t3x256(:,:,538), nhel, den(930))
    call cont_QA(nsync, wf16(:,36), wf16(:,259), A(:,539), n3(:,937), t3x256(:,:,539), nhel, den(932))
    call cont_QA(nsync, wf16(:,36), wf16(:,260), A(:,540), n3(:,938), t3x256(:,:,540), nhel, den(934))
    call cont_VV(nsync, wf16(:,222), wf16(:,261), A(:,541), n3(:,939), t3x256(:,:,541), nhel, den(937))
    call cont_VV(nsync, wf16(:,223), wf16(:,263), A(:,542), n3(:,940), t3x256(:,:,542), nhel, den(939))
    call cont_VV(nsync, wf16(:,218), wf16(:,261), A(:,543), n3(:,941), t3x256(:,:,543), nhel, den(940))
    call cont_VV(nsync, wf16(:,221), wf16(:,263), A(:,544), n3(:,942), t3x256(:,:,544), nhel, den(941))
    call cont_QA(nsync, wf16(:,32), wf16(:,264), A(:,545), n3(:,943), t3x256(:,:,545), nhel, den(943))
    call cont_QA(nsync, wf16(:,32), wf16(:,265), A(:,546), n3(:,944), t3x256(:,:,546), nhel, den(945))
    call cont_QA(nsync, wf16(:,36), wf16(:,266), A(:,547), n3(:,945), t3x256(:,:,547), nhel, den(947))
    call cont_QA(nsync, wf16(:,36), wf16(:,267), A(:,548), n3(:,946), t3x256(:,:,548), nhel, den(949))
    call cont_VV(nsync, wf16(:,222), wf16(:,268), A(:,549), n3(:,947), t3x256(:,:,549), nhel, den(952))
    call cont_VV(nsync, wf16(:,223), wf16(:,270), A(:,550), n3(:,948), t3x256(:,:,550), nhel, den(954))
    call cont_VV(nsync, wf16(:,218), wf16(:,268), A(:,551), n3(:,949), t3x256(:,:,551), nhel, den(955))
    call cont_VV(nsync, wf16(:,221), wf16(:,270), A(:,552), n3(:,950), t3x256(:,:,552), nhel, den(956))
    call cont_VV(nsync, wf16(:,217), wf16(:,271), A(:,553), n3(:,951), t3x256(:,:,553), nhel, den(957))
    call cont_VV(nsync, wf16(:,220), wf16(:,272), A(:,554), n3(:,952), t3x256(:,:,554), nhel, den(958))
    call cont_VV(nsync, wf16(:,217), wf16(:,273), A(:,555), n3(:,953), t3x256(:,:,555), nhel, den(959))
    call cont_VV(nsync, wf16(:,220), wf16(:,274), A(:,556), n3(:,954), t3x256(:,:,556), nhel, den(960))
    call cont_QA(nsync, wf16(:,61), wf16(:,224), A(:,557), n3(:,955), t3x256(:,:,557), nhel, den(961))
    call cont_QA(nsync, wf16(:,61), wf16(:,225), A(:,558), n3(:,956), t3x256(:,:,558), nhel, den(962))
    call cont_QA(nsync, wf8(:,24), wf32(:,69), A(:,559), n3(:,957), t3x256(:,:,559), nhel, den(964))
    call cont_QA(nsync, wf8(:,24), wf32(:,70), A(:,560), n3(:,958), t3x256(:,:,560), nhel, den(966))
    call cont_QA(nsync, wf16(:,63), wf16(:,275), A(:,561), n3(:,959), t3x256(:,:,561), nhel, den(967))
    call cont_QA(nsync, wf16(:,63), wf16(:,276), A(:,562), n3(:,960), t3x256(:,:,562), nhel, den(968))
    call cont_QA(nsync, wf4(:,6), wf64(:,33), A(:,563), n3(:,961), t3x256(:,:,563), nhel, den(970))
    call cont_QA(nsync, wf4(:,6), wf64(:,34), A(:,564), n3(:,962), t3x256(:,:,564), nhel, den(972))
    call cont_QA(nsync, wf16(:,50), wf16(:,277), A(:,565), n3(:,963), t3x256(:,:,565), nhel, den(974))
    call cont_QA(nsync, wf16(:,50), wf16(:,278), A(:,566), n3(:,964), t3x256(:,:,566), nhel, den(976))
    call cont_QA(nsync, wf16(:,60), wf16(:,230), A(:,567), n3(:,965), t3x256(:,:,567), nhel, den(977))
    call cont_QA(nsync, wf16(:,60), wf16(:,231), A(:,568), n3(:,966), t3x256(:,:,568), nhel, den(978))
    call cont_VV(nsync, wf16(:,232), wf16(:,273), A(:,569), n3(:,967), t3x256(:,:,569), nhel, den(979))
    call cont_VV(nsync, wf16(:,234), wf16(:,274), A(:,570), n3(:,968), t3x256(:,:,570), nhel, den(980))
    call cont_VV(nsync, wf16(:,232), wf16(:,271), A(:,571), n3(:,969), t3x256(:,:,571), nhel, den(981))
    call cont_VV(nsync, wf16(:,234), wf16(:,272), A(:,572), n3(:,970), t3x256(:,:,572), nhel, den(982))
    call cont_VV(nsync, wf16(:,235), wf16(:,271), A(:,573), n3(:,971), t3x256(:,:,573), nhel, den(983))
    call cont_VV(nsync, wf16(:,237), wf16(:,272), A(:,574), n3(:,972), t3x256(:,:,574), nhel, den(984))
    call cont_VV(nsync, wf16(:,235), wf16(:,273), A(:,575), n3(:,973), t3x256(:,:,575), nhel, den(985))
    call cont_VV(nsync, wf16(:,237), wf16(:,274), A(:,576), n3(:,974), t3x256(:,:,576), nhel, den(986))
    call cont_QA(nsync, wf16(:,61), wf16(:,238), A(:,577), n3(:,975), t3x256(:,:,577), nhel, den(987))
    call cont_QA(nsync, wf16(:,61), wf16(:,239), A(:,578), n3(:,976), t3x256(:,:,578), nhel, den(988))
    call cont_QA(nsync, wf8(:,24), wf32(:,71), A(:,579), n3(:,977), t3x256(:,:,579), nhel, den(990))
    call cont_QA(nsync, wf8(:,24), wf32(:,72), A(:,580), n3(:,978), t3x256(:,:,580), nhel, den(992))
    call cont_QA(nsync, wf16(:,63), wf16(:,279), A(:,581), n3(:,979), t3x256(:,:,581), nhel, den(993))
    call cont_QA(nsync, wf16(:,63), wf16(:,280), A(:,582), n3(:,980), t3x256(:,:,582), nhel, den(994))
    call cont_QA(nsync, wf4(:,6), wf64(:,35), A(:,583), n3(:,981), t3x256(:,:,583), nhel, den(996))
    call cont_QA(nsync, wf4(:,6), wf64(:,36), A(:,584), n3(:,982), t3x256(:,:,584), nhel, den(998))
    call cont_QA(nsync, wf16(:,50), wf16(:,281), A(:,585), n3(:,983), t3x256(:,:,585), nhel, den(1000))
    call cont_QA(nsync, wf16(:,50), wf16(:,282), A(:,586), n3(:,984), t3x256(:,:,586), nhel, den(1002))
    call cont_QA(nsync, wf16(:,60), wf16(:,244), A(:,587), n3(:,985), t3x256(:,:,587), nhel, den(1003))
    call cont_QA(nsync, wf16(:,60), wf16(:,245), A(:,588), n3(:,986), t3x256(:,:,588), nhel, den(1004))
    call cont_VV(nsync, wf16(:,246), wf16(:,273), A(:,589), n3(:,987), t3x256(:,:,589), nhel, den(1005))
    call cont_VV(nsync, wf16(:,248), wf16(:,274), A(:,590), n3(:,988), t3x256(:,:,590), nhel, den(1006))
    call cont_VV(nsync, wf16(:,246), wf16(:,271), A(:,591), n3(:,989), t3x256(:,:,591), nhel, den(1007))
    call cont_VV(nsync, wf16(:,248), wf16(:,272), A(:,592), n3(:,990), t3x256(:,:,592), nhel, den(1008))
    call cont_QA(nsync, wf16(:,49), wf16(:,249), A(:,593), n3(:,991), t3x256(:,:,593), nhel, den(1009))
    call cont_QA(nsync, wf16(:,49), wf16(:,250), A(:,594), n3(:,992), t3x256(:,:,594), nhel, den(1010))
    call cont_QA(nsync, wf8(:,24), wf32(:,73), A(:,595), n3(:,993), t3x256(:,:,595), nhel, den(1012))
    call cont_QA(nsync, wf8(:,24), wf32(:,74), A(:,596), n3(:,994), t3x256(:,:,596), nhel, den(1014))
    call cont_QA(nsync, wf16(:,49), wf16(:,251), A(:,597), n3(:,995), t3x256(:,:,597), nhel, den(1015))
    call cont_QA(nsync, wf16(:,49), wf16(:,252), A(:,598), n3(:,996), t3x256(:,:,598), nhel, den(1016))
    call cont_QA(nsync, wf8(:,24), wf32(:,75), A(:,599), n3(:,997), t3x256(:,:,599), nhel, den(1018))
    call cont_QA(nsync, wf8(:,24), wf32(:,76), A(:,600), n3(:,998), t3x256(:,:,600), nhel, den(1020))
    call cont_QA(nsync, wf16(:,57), wf16(:,283), A(:,601), n3(:,999), t3x256(:,:,601), nhel, den(1021))
    call cont_QA(nsync, wf16(:,57), wf16(:,284), A(:,602), n3(:,1000), t3x256(:,:,602), nhel, den(1022))
    call cont_QA(nsync, wf4(:,12), wf64(:,37), A(:,603), n3(:,1001), t3x256(:,:,603), nhel, den(1024))
    call cont_QA(nsync, wf4(:,12), wf64(:,38), A(:,604), n3(:,1002), t3x256(:,:,604), nhel, den(1026))
    call cont_QA(nsync, wf16(:,57), wf16(:,285), A(:,605), n3(:,1003), t3x256(:,:,605), nhel, den(1027))
    call cont_QA(nsync, wf16(:,57), wf16(:,286), A(:,606), n3(:,1004), t3x256(:,:,606), nhel, den(1028))
    call cont_QA(nsync, wf4(:,12), wf64(:,39), A(:,607), n3(:,1005), t3x256(:,:,607), nhel, den(1030))
    call cont_QA(nsync, wf4(:,12), wf64(:,40), A(:,608), n3(:,1006), t3x256(:,:,608), nhel, den(1032))
    call cont_QA(nsync, wf16(:,62), wf16(:,287), A(:,609), n3(:,1007), t3x256(:,:,609), nhel, den(1034))
    call cont_QA(nsync, wf16(:,62), wf16(:,288), A(:,610), n3(:,1008), t3x256(:,:,610), nhel, den(1036))
    call cont_QA(nsync, wf16(:,66), wf16(:,259), A(:,611), n3(:,1009), t3x256(:,:,611), nhel, den(1037))
    call cont_QA(nsync, wf16(:,66), wf16(:,260), A(:,612), n3(:,1010), t3x256(:,:,612), nhel, den(1038))
    call cont_VV(nsync, wf16(:,261), wf16(:,273), A(:,613), n3(:,1011), t3x256(:,:,613), nhel, den(1039))
    call cont_VV(nsync, wf16(:,263), wf16(:,274), A(:,614), n3(:,1012), t3x256(:,:,614), nhel, den(1040))
    call cont_VV(nsync, wf16(:,261), wf16(:,271), A(:,615), n3(:,1013), t3x256(:,:,615), nhel, den(1041))
    call cont_VV(nsync, wf16(:,263), wf16(:,272), A(:,616), n3(:,1014), t3x256(:,:,616), nhel, den(1042))
    call cont_QA(nsync, wf16(:,62), wf16(:,289), A(:,617), n3(:,1015), t3x256(:,:,617), nhel, den(1044))
    call cont_QA(nsync, wf16(:,62), wf16(:,290), A(:,618), n3(:,1016), t3x256(:,:,618), nhel, den(1046))
    call cont_QA(nsync, wf16(:,66), wf16(:,266), A(:,619), n3(:,1017), t3x256(:,:,619), nhel, den(1047))
    call cont_QA(nsync, wf16(:,66), wf16(:,267), A(:,620), n3(:,1018), t3x256(:,:,620), nhel, den(1048))
    call cont_VV(nsync, wf16(:,268), wf16(:,273), A(:,621), n3(:,1019), t3x256(:,:,621), nhel, den(1049))
    call cont_VV(nsync, wf16(:,270), wf16(:,274), A(:,622), n3(:,1020), t3x256(:,:,622), nhel, den(1050))
    call cont_VV(nsync, wf16(:,268), wf16(:,271), A(:,623), n3(:,1021), t3x256(:,:,623), nhel, den(1051))
    call cont_VV(nsync, wf16(:,270), wf16(:,272), A(:,624), n3(:,1022), t3x256(:,:,624), nhel, den(1052))
    call cont_VV(nsync, wf16(:,217), wf16(:,291), A(:,625), n3(:,1023), t3x256(:,:,625), nhel, den(1053))
    call cont_VV(nsync, wf16(:,220), wf16(:,292), A(:,626), n3(:,1024), t3x256(:,:,626), nhel, den(1054))
    call cont_VV(nsync, wf16(:,217), wf16(:,293), A(:,627), n3(:,1025), t3x256(:,:,627), nhel, den(1055))
    call cont_VV(nsync, wf16(:,220), wf16(:,294), A(:,628), n3(:,1026), t3x256(:,:,628), nhel, den(1056))
    call cont_QA(nsync, wf16(:,89), wf16(:,295), A(:,629), n3(:,1027), t3x256(:,:,629), nhel, den(1057))
    call cont_QA(nsync, wf16(:,89), wf16(:,296), A(:,630), n3(:,1028), t3x256(:,:,630), nhel, den(1058))
    call cont_QA(nsync, wf8(:,38), wf32(:,61), A(:,631), n3(:,1029), t3x256(:,:,631), nhel, den(1059))
    call cont_QA(nsync, wf8(:,38), wf32(:,62), A(:,632), n3(:,1030), t3x256(:,:,632), nhel, den(1060))
    call cont_QA(nsync, wf16(:,93), wf16(:,226), A(:,633), n3(:,1031), t3x256(:,:,633), nhel, den(1061))
    call cont_QA(nsync, wf16(:,93), wf16(:,227), A(:,634), n3(:,1032), t3x256(:,:,634), nhel, den(1062))
    call cont_QA(nsync, wf4(:,20), wf64(:,41), A(:,635), n3(:,1033), t3x256(:,:,635), nhel, den(1064))
    call cont_QA(nsync, wf4(:,20), wf64(:,42), A(:,636), n3(:,1034), t3x256(:,:,636), nhel, den(1066))
    call cont_QA(nsync, wf16(:,80), wf16(:,228), A(:,637), n3(:,1035), t3x256(:,:,637), nhel, den(1067))
    call cont_QA(nsync, wf16(:,80), wf16(:,229), A(:,638), n3(:,1036), t3x256(:,:,638), nhel, den(1068))
    call cont_QA(nsync, wf16(:,88), wf16(:,297), A(:,639), n3(:,1037), t3x256(:,:,639), nhel, den(1070))
    call cont_QA(nsync, wf16(:,88), wf16(:,298), A(:,640), n3(:,1038), t3x256(:,:,640), nhel, den(1072))
    call cont_VV(nsync, wf16(:,232), wf16(:,293), A(:,641), n3(:,1039), t3x256(:,:,641), nhel, den(1073))
    call cont_VV(nsync, wf16(:,234), wf16(:,294), A(:,642), n3(:,1040), t3x256(:,:,642), nhel, den(1074))
    call cont_VV(nsync, wf16(:,232), wf16(:,291), A(:,643), n3(:,1041), t3x256(:,:,643), nhel, den(1075))
    call cont_VV(nsync, wf16(:,234), wf16(:,292), A(:,644), n3(:,1042), t3x256(:,:,644), nhel, den(1076))
    call cont_VV(nsync, wf16(:,235), wf16(:,291), A(:,645), n3(:,1043), t3x256(:,:,645), nhel, den(1077))
    call cont_VV(nsync, wf16(:,237), wf16(:,292), A(:,646), n3(:,1044), t3x256(:,:,646), nhel, den(1078))
    call cont_VV(nsync, wf16(:,235), wf16(:,293), A(:,647), n3(:,1045), t3x256(:,:,647), nhel, den(1079))
    call cont_VV(nsync, wf16(:,237), wf16(:,294), A(:,648), n3(:,1046), t3x256(:,:,648), nhel, den(1080))
    call cont_QA(nsync, wf16(:,89), wf16(:,299), A(:,649), n3(:,1047), t3x256(:,:,649), nhel, den(1081))
    call cont_QA(nsync, wf16(:,89), wf16(:,300), A(:,650), n3(:,1048), t3x256(:,:,650), nhel, den(1082))
    call cont_QA(nsync, wf8(:,38), wf32(:,63), A(:,651), n3(:,1049), t3x256(:,:,651), nhel, den(1083))
    call cont_QA(nsync, wf8(:,38), wf32(:,64), A(:,652), n3(:,1050), t3x256(:,:,652), nhel, den(1084))
    call cont_QA(nsync, wf16(:,93), wf16(:,240), A(:,653), n3(:,1051), t3x256(:,:,653), nhel, den(1085))
    call cont_QA(nsync, wf16(:,93), wf16(:,241), A(:,654), n3(:,1052), t3x256(:,:,654), nhel, den(1086))
    call cont_QA(nsync, wf4(:,20), wf64(:,43), A(:,655), n3(:,1053), t3x256(:,:,655), nhel, den(1088))
    call cont_QA(nsync, wf4(:,20), wf64(:,44), A(:,656), n3(:,1054), t3x256(:,:,656), nhel, den(1090))
    call cont_QA(nsync, wf16(:,80), wf16(:,242), A(:,657), n3(:,1055), t3x256(:,:,657), nhel, den(1091))
    call cont_QA(nsync, wf16(:,80), wf16(:,243), A(:,658), n3(:,1056), t3x256(:,:,658), nhel, den(1092))
    call cont_QA(nsync, wf16(:,88), wf16(:,301), A(:,659), n3(:,1057), t3x256(:,:,659), nhel, den(1094))
    call cont_QA(nsync, wf16(:,88), wf16(:,302), A(:,660), n3(:,1058), t3x256(:,:,660), nhel, den(1096))
    call cont_VV(nsync, wf16(:,246), wf16(:,293), A(:,661), n3(:,1059), t3x256(:,:,661), nhel, den(1097))
    call cont_VV(nsync, wf16(:,248), wf16(:,294), A(:,662), n3(:,1060), t3x256(:,:,662), nhel, den(1098))
    call cont_VV(nsync, wf16(:,246), wf16(:,291), A(:,663), n3(:,1061), t3x256(:,:,663), nhel, den(1099))
    call cont_VV(nsync, wf16(:,248), wf16(:,292), A(:,664), n3(:,1062), t3x256(:,:,664), nhel, den(1100))
    call cont_QA(nsync, wf16(:,77), wf16(:,303), A(:,665), n3(:,1063), t3x256(:,:,665), nhel, den(1101))
    call cont_QA(nsync, wf16(:,77), wf16(:,304), A(:,666), n3(:,1064), t3x256(:,:,666), nhel, den(1102))
    call cont_QA(nsync, wf8(:,38), wf32(:,65), A(:,667), n3(:,1065), t3x256(:,:,667), nhel, den(1103))
    call cont_QA(nsync, wf8(:,38), wf32(:,66), A(:,668), n3(:,1066), t3x256(:,:,668), nhel, den(1104))
    call cont_QA(nsync, wf16(:,77), wf16(:,305), A(:,669), n3(:,1067), t3x256(:,:,669), nhel, den(1105))
    call cont_QA(nsync, wf16(:,77), wf16(:,306), A(:,670), n3(:,1068), t3x256(:,:,670), nhel, den(1106))
    call cont_QA(nsync, wf8(:,38), wf32(:,67), A(:,671), n3(:,1069), t3x256(:,:,671), nhel, den(1107))
    call cont_QA(nsync, wf8(:,38), wf32(:,68), A(:,672), n3(:,1070), t3x256(:,:,672), nhel, den(1108))
    call cont_QA(nsync, wf16(:,87), wf16(:,253), A(:,673), n3(:,1071), t3x256(:,:,673), nhel, den(1109))
    call cont_QA(nsync, wf16(:,87), wf16(:,254), A(:,674), n3(:,1072), t3x256(:,:,674), nhel, den(1110))
    call cont_QA(nsync, wf4(:,22), wf64(:,45), A(:,675), n3(:,1073), t3x256(:,:,675), nhel, den(1112))
    call cont_QA(nsync, wf4(:,22), wf64(:,46), A(:,676), n3(:,1074), t3x256(:,:,676), nhel, den(1114))
    call cont_QA(nsync, wf16(:,87), wf16(:,255), A(:,677), n3(:,1075), t3x256(:,:,677), nhel, den(1115))
    call cont_QA(nsync, wf16(:,87), wf16(:,256), A(:,678), n3(:,1076), t3x256(:,:,678), nhel, den(1116))
    call cont_QA(nsync, wf4(:,22), wf64(:,47), A(:,679), n3(:,1077), t3x256(:,:,679), nhel, den(1118))
    call cont_QA(nsync, wf4(:,22), wf64(:,48), A(:,680), n3(:,1078), t3x256(:,:,680), nhel, den(1120))
    call cont_QA(nsync, wf16(:,92), wf16(:,257), A(:,681), n3(:,1079), t3x256(:,:,681), nhel, den(1121))
    call cont_QA(nsync, wf16(:,92), wf16(:,258), A(:,682), n3(:,1080), t3x256(:,:,682), nhel, den(1122))
    call cont_QA(nsync, wf16(:,94), wf16(:,307), A(:,683), n3(:,1081), t3x256(:,:,683), nhel, den(1124))
    call cont_QA(nsync, wf16(:,94), wf16(:,308), A(:,684), n3(:,1082), t3x256(:,:,684), nhel, den(1126))
    call cont_VV(nsync, wf16(:,261), wf16(:,293), A(:,685), n3(:,1083), t3x256(:,:,685), nhel, den(1127))
    call cont_VV(nsync, wf16(:,263), wf16(:,294), A(:,686), n3(:,1084), t3x256(:,:,686), nhel, den(1128))
    call cont_VV(nsync, wf16(:,261), wf16(:,291), A(:,687), n3(:,1085), t3x256(:,:,687), nhel, den(1129))
    call cont_VV(nsync, wf16(:,263), wf16(:,292), A(:,688), n3(:,1086), t3x256(:,:,688), nhel, den(1130))
    call cont_QA(nsync, wf16(:,92), wf16(:,264), A(:,689), n3(:,1087), t3x256(:,:,689), nhel, den(1131))
    call cont_QA(nsync, wf16(:,92), wf16(:,265), A(:,690), n3(:,1088), t3x256(:,:,690), nhel, den(1132))
    call cont_QA(nsync, wf16(:,94), wf16(:,309), A(:,691), n3(:,1089), t3x256(:,:,691), nhel, den(1134))
    call cont_QA(nsync, wf16(:,94), wf16(:,310), A(:,692), n3(:,1090), t3x256(:,:,692), nhel, den(1136))
    call cont_VV(nsync, wf16(:,268), wf16(:,293), A(:,693), n3(:,1091), t3x256(:,:,693), nhel, den(1137))
    call cont_VV(nsync, wf16(:,270), wf16(:,294), A(:,694), n3(:,1092), t3x256(:,:,694), nhel, den(1138))
    call cont_VV(nsync, wf16(:,268), wf16(:,291), A(:,695), n3(:,1093), t3x256(:,:,695), nhel, den(1139))
    call cont_VV(nsync, wf16(:,270), wf16(:,292), A(:,696), n3(:,1094), t3x256(:,:,696), nhel, den(1140))
    call cont_VV(nsync, wf16(:,217), wf16(:,311), A(:,697), n3(:,1095), t3x256(:,:,697), nhel, den(1141))
    call cont_VV(nsync, wf16(:,220), wf16(:,312), A(:,698), n3(:,1096), t3x256(:,:,698), nhel, den(1142))
    call cont_VV(nsync, wf16(:,217), wf16(:,313), A(:,699), n3(:,1097), t3x256(:,:,699), nhel, den(1143))
    call cont_VV(nsync, wf16(:,220), wf16(:,314), A(:,700), n3(:,1098), t3x256(:,:,700), nhel, den(1144))
    call cont_QA(nsync, wf16(:,107), wf16(:,295), A(:,701), n3(:,1099), t3x256(:,:,701), nhel, den(1145))
    call cont_QA(nsync, wf16(:,107), wf16(:,296), A(:,702), n3(:,1100), t3x256(:,:,702), nhel, den(1146))
    call cont_QA(nsync, wf8(:,46), wf32(:,69), A(:,703), n3(:,1101), t3x256(:,:,703), nhel, den(1147))
    call cont_QA(nsync, wf8(:,46), wf32(:,70), A(:,704), n3(:,1102), t3x256(:,:,704), nhel, den(1148))
    call cont_QA(nsync, wf16(:,109), wf16(:,275), A(:,705), n3(:,1103), t3x256(:,:,705), nhel, den(1149))
    call cont_QA(nsync, wf16(:,109), wf16(:,276), A(:,706), n3(:,1104), t3x256(:,:,706), nhel, den(1150))
    call cont_QA(nsync, wf4(:,20), wf64(:,49), A(:,707), n3(:,1105), t3x256(:,:,707), nhel, den(1152))
    call cont_QA(nsync, wf4(:,20), wf64(:,50), A(:,708), n3(:,1106), t3x256(:,:,708), nhel, den(1154))
    call cont_QA(nsync, wf16(:,102), wf16(:,277), A(:,709), n3(:,1107), t3x256(:,:,709), nhel, den(1155))
    call cont_QA(nsync, wf16(:,102), wf16(:,278), A(:,710), n3(:,1108), t3x256(:,:,710), nhel, den(1156))
    call cont_QA(nsync, wf16(:,106), wf16(:,297), A(:,711), n3(:,1109), t3x256(:,:,711), nhel, den(1157))
    call cont_QA(nsync, wf16(:,106), wf16(:,298), A(:,712), n3(:,1110), t3x256(:,:,712), nhel, den(1158))
    call cont_VV(nsync, wf16(:,232), wf16(:,313), A(:,713), n3(:,1111), t3x256(:,:,713), nhel, den(1159))
    call cont_VV(nsync, wf16(:,234), wf16(:,314), A(:,714), n3(:,1112), t3x256(:,:,714), nhel, den(1160))
    call cont_VV(nsync, wf16(:,232), wf16(:,311), A(:,715), n3(:,1113), t3x256(:,:,715), nhel, den(1161))
    call cont_VV(nsync, wf16(:,234), wf16(:,312), A(:,716), n3(:,1114), t3x256(:,:,716), nhel, den(1162))
    call cont_VV(nsync, wf16(:,235), wf16(:,311), A(:,717), n3(:,1115), t3x256(:,:,717), nhel, den(1163))
    call cont_VV(nsync, wf16(:,237), wf16(:,312), A(:,718), n3(:,1116), t3x256(:,:,718), nhel, den(1164))
    call cont_VV(nsync, wf16(:,235), wf16(:,313), A(:,719), n3(:,1117), t3x256(:,:,719), nhel, den(1165))
    call cont_VV(nsync, wf16(:,237), wf16(:,314), A(:,720), n3(:,1118), t3x256(:,:,720), nhel, den(1166))
    call cont_QA(nsync, wf16(:,107), wf16(:,299), A(:,721), n3(:,1119), t3x256(:,:,721), nhel, den(1167))
    call cont_QA(nsync, wf16(:,107), wf16(:,300), A(:,722), n3(:,1120), t3x256(:,:,722), nhel, den(1168))
    call cont_QA(nsync, wf8(:,46), wf32(:,71), A(:,723), n3(:,1121), t3x256(:,:,723), nhel, den(1169))
    call cont_QA(nsync, wf8(:,46), wf32(:,72), A(:,724), n3(:,1122), t3x256(:,:,724), nhel, den(1170))
    call cont_QA(nsync, wf16(:,109), wf16(:,279), A(:,725), n3(:,1123), t3x256(:,:,725), nhel, den(1171))
    call cont_QA(nsync, wf16(:,109), wf16(:,280), A(:,726), n3(:,1124), t3x256(:,:,726), nhel, den(1172))
    call cont_QA(nsync, wf4(:,20), wf64(:,51), A(:,727), n3(:,1125), t3x256(:,:,727), nhel, den(1174))
    call cont_QA(nsync, wf4(:,20), wf64(:,52), A(:,728), n3(:,1126), t3x256(:,:,728), nhel, den(1176))
    call cont_QA(nsync, wf16(:,102), wf16(:,281), A(:,729), n3(:,1127), t3x256(:,:,729), nhel, den(1177))
    call cont_QA(nsync, wf16(:,102), wf16(:,282), A(:,730), n3(:,1128), t3x256(:,:,730), nhel, den(1178))
    call cont_QA(nsync, wf16(:,106), wf16(:,301), A(:,731), n3(:,1129), t3x256(:,:,731), nhel, den(1179))
    call cont_QA(nsync, wf16(:,106), wf16(:,302), A(:,732), n3(:,1130), t3x256(:,:,732), nhel, den(1180))
    call cont_VV(nsync, wf16(:,246), wf16(:,313), A(:,733), n3(:,1131), t3x256(:,:,733), nhel, den(1181))
    call cont_VV(nsync, wf16(:,248), wf16(:,314), A(:,734), n3(:,1132), t3x256(:,:,734), nhel, den(1182))
    call cont_VV(nsync, wf16(:,246), wf16(:,311), A(:,735), n3(:,1133), t3x256(:,:,735), nhel, den(1183))
    call cont_VV(nsync, wf16(:,248), wf16(:,312), A(:,736), n3(:,1134), t3x256(:,:,736), nhel, den(1184))
    call cont_QA(nsync, wf16(:,101), wf16(:,303), A(:,737), n3(:,1135), t3x256(:,:,737), nhel, den(1185))
    call cont_QA(nsync, wf16(:,101), wf16(:,304), A(:,738), n3(:,1136), t3x256(:,:,738), nhel, den(1186))
    call cont_QA(nsync, wf8(:,46), wf32(:,73), A(:,739), n3(:,1137), t3x256(:,:,739), nhel, den(1187))
    call cont_QA(nsync, wf8(:,46), wf32(:,74), A(:,740), n3(:,1138), t3x256(:,:,740), nhel, den(1188))
    call cont_QA(nsync, wf16(:,101), wf16(:,305), A(:,741), n3(:,1139), t3x256(:,:,741), nhel, den(1189))
    call cont_QA(nsync, wf16(:,101), wf16(:,306), A(:,742), n3(:,1140), t3x256(:,:,742), nhel, den(1190))
    call cont_QA(nsync, wf8(:,46), wf32(:,75), A(:,743), n3(:,1141), t3x256(:,:,743), nhel, den(1191))
    call cont_QA(nsync, wf8(:,46), wf32(:,76), A(:,744), n3(:,1142), t3x256(:,:,744), nhel, den(1192))
    call cont_QA(nsync, wf16(:,105), wf16(:,283), A(:,745), n3(:,1143), t3x256(:,:,745), nhel, den(1193))
    call cont_QA(nsync, wf16(:,105), wf16(:,284), A(:,746), n3(:,1144), t3x256(:,:,746), nhel, den(1194))
    call cont_QA(nsync, wf4(:,22), wf64(:,53), A(:,747), n3(:,1145), t3x256(:,:,747), nhel, den(1196))
    call cont_QA(nsync, wf4(:,22), wf64(:,54), A(:,748), n3(:,1146), t3x256(:,:,748), nhel, den(1198))
    call cont_QA(nsync, wf16(:,105), wf16(:,285), A(:,749), n3(:,1147), t3x256(:,:,749), nhel, den(1199))
    call cont_QA(nsync, wf16(:,105), wf16(:,286), A(:,750), n3(:,1148), t3x256(:,:,750), nhel, den(1200))
    call cont_QA(nsync, wf4(:,22), wf64(:,55), A(:,751), n3(:,1149), t3x256(:,:,751), nhel, den(1202))
    call cont_QA(nsync, wf4(:,22), wf64(:,56), A(:,752), n3(:,1150), t3x256(:,:,752), nhel, den(1204))
    call cont_QA(nsync, wf16(:,108), wf16(:,287), A(:,753), n3(:,1151), t3x256(:,:,753), nhel, den(1205))
    call cont_QA(nsync, wf16(:,108), wf16(:,288), A(:,754), n3(:,1152), t3x256(:,:,754), nhel, den(1206))
    call cont_QA(nsync, wf16(:,110), wf16(:,307), A(:,755), n3(:,1153), t3x256(:,:,755), nhel, den(1207))
    call cont_QA(nsync, wf16(:,110), wf16(:,308), A(:,756), n3(:,1154), t3x256(:,:,756), nhel, den(1208))
    call cont_VV(nsync, wf16(:,261), wf16(:,313), A(:,757), n3(:,1155), t3x256(:,:,757), nhel, den(1209))
    call cont_VV(nsync, wf16(:,263), wf16(:,314), A(:,758), n3(:,1156), t3x256(:,:,758), nhel, den(1210))
    call cont_VV(nsync, wf16(:,261), wf16(:,311), A(:,759), n3(:,1157), t3x256(:,:,759), nhel, den(1211))
    call cont_VV(nsync, wf16(:,263), wf16(:,312), A(:,760), n3(:,1158), t3x256(:,:,760), nhel, den(1212))
    call cont_QA(nsync, wf16(:,108), wf16(:,289), A(:,761), n3(:,1159), t3x256(:,:,761), nhel, den(1213))
    call cont_QA(nsync, wf16(:,108), wf16(:,290), A(:,762), n3(:,1160), t3x256(:,:,762), nhel, den(1214))
    call cont_QA(nsync, wf16(:,110), wf16(:,309), A(:,763), n3(:,1161), t3x256(:,:,763), nhel, den(1215))
    call cont_QA(nsync, wf16(:,110), wf16(:,310), A(:,764), n3(:,1162), t3x256(:,:,764), nhel, den(1216))
    call cont_VV(nsync, wf16(:,268), wf16(:,313), A(:,765), n3(:,1163), t3x256(:,:,765), nhel, den(1217))
    call cont_VV(nsync, wf16(:,270), wf16(:,314), A(:,766), n3(:,1164), t3x256(:,:,766), nhel, den(1218))
    call cont_VV(nsync, wf16(:,268), wf16(:,311), A(:,767), n3(:,1165), t3x256(:,:,767), nhel, den(1219))
    call cont_VV(nsync, wf16(:,270), wf16(:,312), A(:,768), n3(:,1166), t3x256(:,:,768), nhel, den(1220))
    call cont_QA(nsync, wf16(:,137), wf16(:,228), A(:,769), n3(:,1167), t3x256(:,:,769), nhel, den(1221))
    call cont_QA(nsync, wf16(:,137), wf16(:,229), A(:,770), n3(:,1168), t3x256(:,:,770), nhel, den(1222))
    call cont_QA(nsync, wf16(:,138), wf16(:,228), A(:,771), n3(:,1169), t3x256(:,:,771), nhel, den(1223))
    call cont_QA(nsync, wf16(:,138), wf16(:,229), A(:,772), n3(:,1170), t3x256(:,:,772), nhel, den(1224))
    call cont_QA(nsync, wf16(:,197), wf16(:,295), A(:,773), n3(:,1171), t3x256(:,:,773), nhel, den(1225))
    call cont_QA(nsync, wf16(:,197), wf16(:,296), A(:,774), n3(:,1172), t3x256(:,:,774), nhel, den(1226))
    call cont_QA(nsync, wf16(:,198), wf16(:,224), A(:,775), n3(:,1173), t3x256(:,:,775), nhel, den(1227))
    call cont_QA(nsync, wf16(:,198), wf16(:,225), A(:,776), n3(:,1174), t3x256(:,:,776), nhel, den(1228))
    call cont_QA(nsync, wf16(:,116), wf16(:,277), A(:,777), n3(:,1175), t3x256(:,:,777), nhel, den(1229))
    call cont_QA(nsync, wf16(:,116), wf16(:,278), A(:,778), n3(:,1176), t3x256(:,:,778), nhel, den(1230))
    call cont_QA(nsync, wf16(:,115), wf16(:,277), A(:,779), n3(:,1177), t3x256(:,:,779), nhel, den(1231))
    call cont_QA(nsync, wf16(:,115), wf16(:,278), A(:,780), n3(:,1178), t3x256(:,:,780), nhel, den(1232))
    call cont_QA(nsync, wf16(:,203), wf16(:,295), A(:,781), n3(:,1179), t3x256(:,:,781), nhel, den(1233))
    call cont_QA(nsync, wf16(:,203), wf16(:,296), A(:,782), n3(:,1180), t3x256(:,:,782), nhel, den(1234))
    call cont_QA(nsync, wf16(:,204), wf16(:,224), A(:,783), n3(:,1181), t3x256(:,:,783), nhel, den(1235))
    call cont_QA(nsync, wf16(:,204), wf16(:,225), A(:,784), n3(:,1182), t3x256(:,:,784), nhel, den(1236))
    call cont_QA(nsync, wf16(:,123), wf16(:,277), A(:,785), n3(:,1183), t3x256(:,:,785), nhel, den(1237))
    call cont_QA(nsync, wf16(:,123), wf16(:,278), A(:,786), n3(:,1184), t3x256(:,:,786), nhel, den(1238))
    call cont_QA(nsync, wf16(:,146), wf16(:,228), A(:,787), n3(:,1185), t3x256(:,:,787), nhel, den(1239))
    call cont_QA(nsync, wf16(:,146), wf16(:,229), A(:,788), n3(:,1186), t3x256(:,:,788), nhel, den(1240))
    call cont_QA(nsync, wf16(:,209), wf16(:,224), A(:,789), n3(:,1187), t3x256(:,:,789), nhel, den(1241))
    call cont_QA(nsync, wf16(:,209), wf16(:,225), A(:,790), n3(:,1188), t3x256(:,:,790), nhel, den(1242))
    call cont_QA(nsync, wf16(:,210), wf16(:,224), A(:,791), n3(:,1189), t3x256(:,:,791), nhel, den(1243))
    call cont_QA(nsync, wf16(:,210), wf16(:,225), A(:,792), n3(:,1190), t3x256(:,:,792), nhel, den(1244))
    call cont_QA(nsync, wf16(:,130), wf16(:,277), A(:,793), n3(:,1191), t3x256(:,:,793), nhel, den(1245))
    call cont_QA(nsync, wf16(:,130), wf16(:,278), A(:,794), n3(:,1192), t3x256(:,:,794), nhel, den(1246))
    call cont_QA(nsync, wf16(:,153), wf16(:,228), A(:,795), n3(:,1193), t3x256(:,:,795), nhel, den(1247))
    call cont_QA(nsync, wf16(:,153), wf16(:,229), A(:,796), n3(:,1194), t3x256(:,:,796), nhel, den(1248))
    call cont_QA(nsync, wf16(:,216), wf16(:,295), A(:,797), n3(:,1195), t3x256(:,:,797), nhel, den(1249))
    call cont_QA(nsync, wf16(:,216), wf16(:,296), A(:,798), n3(:,1196), t3x256(:,:,798), nhel, den(1250))
    call cont_QA(nsync, wf16(:,215), wf16(:,295), A(:,799), n3(:,1197), t3x256(:,:,799), nhel, den(1251))
    call cont_QA(nsync, wf16(:,215), wf16(:,296), A(:,800), n3(:,1198), t3x256(:,:,800), nhel, den(1252))
    call cont_QA(nsync, wf16(:,137), wf16(:,242), A(:,801), n3(:,1199), t3x256(:,:,801), nhel, den(1253))
    call cont_QA(nsync, wf16(:,137), wf16(:,243), A(:,802), n3(:,1200), t3x256(:,:,802), nhel, den(1254))
    call cont_QA(nsync, wf16(:,138), wf16(:,242), A(:,803), n3(:,1201), t3x256(:,:,803), nhel, den(1255))
    call cont_QA(nsync, wf16(:,138), wf16(:,243), A(:,804), n3(:,1202), t3x256(:,:,804), nhel, den(1256))
    call cont_QA(nsync, wf16(:,197), wf16(:,299), A(:,805), n3(:,1203), t3x256(:,:,805), nhel, den(1257))
    call cont_QA(nsync, wf16(:,197), wf16(:,300), A(:,806), n3(:,1204), t3x256(:,:,806), nhel, den(1258))
    call cont_QA(nsync, wf16(:,198), wf16(:,238), A(:,807), n3(:,1205), t3x256(:,:,807), nhel, den(1259))
    call cont_QA(nsync, wf16(:,198), wf16(:,239), A(:,808), n3(:,1206), t3x256(:,:,808), nhel, den(1260))
    call cont_QA(nsync, wf16(:,116), wf16(:,281), A(:,809), n3(:,1207), t3x256(:,:,809), nhel, den(1261))
    call cont_QA(nsync, wf16(:,116), wf16(:,282), A(:,810), n3(:,1208), t3x256(:,:,810), nhel, den(1262))
    call cont_QA(nsync, wf16(:,115), wf16(:,281), A(:,811), n3(:,1209), t3x256(:,:,811), nhel, den(1263))
    call cont_QA(nsync, wf16(:,115), wf16(:,282), A(:,812), n3(:,1210), t3x256(:,:,812), nhel, den(1264))
    call cont_QA(nsync, wf16(:,203), wf16(:,299), A(:,813), n3(:,1211), t3x256(:,:,813), nhel, den(1265))
    call cont_QA(nsync, wf16(:,203), wf16(:,300), A(:,814), n3(:,1212), t3x256(:,:,814), nhel, den(1266))
    call cont_QA(nsync, wf16(:,204), wf16(:,238), A(:,815), n3(:,1213), t3x256(:,:,815), nhel, den(1267))
    call cont_QA(nsync, wf16(:,204), wf16(:,239), A(:,816), n3(:,1214), t3x256(:,:,816), nhel, den(1268))
    call cont_QA(nsync, wf16(:,123), wf16(:,281), A(:,817), n3(:,1215), t3x256(:,:,817), nhel, den(1269))
    call cont_QA(nsync, wf16(:,123), wf16(:,282), A(:,818), n3(:,1216), t3x256(:,:,818), nhel, den(1270))
    call cont_QA(nsync, wf16(:,146), wf16(:,242), A(:,819), n3(:,1217), t3x256(:,:,819), nhel, den(1271))
    call cont_QA(nsync, wf16(:,146), wf16(:,243), A(:,820), n3(:,1218), t3x256(:,:,820), nhel, den(1272))
    call cont_QA(nsync, wf16(:,209), wf16(:,238), A(:,821), n3(:,1219), t3x256(:,:,821), nhel, den(1273))
    call cont_QA(nsync, wf16(:,209), wf16(:,239), A(:,822), n3(:,1220), t3x256(:,:,822), nhel, den(1274))
    call cont_QA(nsync, wf16(:,210), wf16(:,238), A(:,823), n3(:,1221), t3x256(:,:,823), nhel, den(1275))
    call cont_QA(nsync, wf16(:,210), wf16(:,239), A(:,824), n3(:,1222), t3x256(:,:,824), nhel, den(1276))
    call cont_QA(nsync, wf16(:,130), wf16(:,281), A(:,825), n3(:,1223), t3x256(:,:,825), nhel, den(1277))
    call cont_QA(nsync, wf16(:,130), wf16(:,282), A(:,826), n3(:,1224), t3x256(:,:,826), nhel, den(1278))
    call cont_QA(nsync, wf16(:,153), wf16(:,242), A(:,827), n3(:,1225), t3x256(:,:,827), nhel, den(1279))
    call cont_QA(nsync, wf16(:,153), wf16(:,243), A(:,828), n3(:,1226), t3x256(:,:,828), nhel, den(1280))
    call cont_QA(nsync, wf16(:,216), wf16(:,299), A(:,829), n3(:,1227), t3x256(:,:,829), nhel, den(1281))
    call cont_QA(nsync, wf16(:,216), wf16(:,300), A(:,830), n3(:,1228), t3x256(:,:,830), nhel, den(1282))
    call cont_QA(nsync, wf16(:,215), wf16(:,299), A(:,831), n3(:,1229), t3x256(:,:,831), nhel, den(1283))
    call cont_QA(nsync, wf16(:,215), wf16(:,300), A(:,832), n3(:,1230), t3x256(:,:,832), nhel, den(1284))
    call cont_QA(nsync, wf16(:,113), wf16(:,257), A(:,833), n3(:,1231), t3x256(:,:,833), nhel, den(1285))
    call cont_QA(nsync, wf16(:,113), wf16(:,258), A(:,834), n3(:,1232), t3x256(:,:,834), nhel, den(1286))
    call cont_QA(nsync, wf16(:,114), wf16(:,257), A(:,835), n3(:,1233), t3x256(:,:,835), nhel, den(1287))
    call cont_QA(nsync, wf16(:,114), wf16(:,258), A(:,836), n3(:,1234), t3x256(:,:,836), nhel, den(1288))
    call cont_QA(nsync, wf16(:,135), wf16(:,303), A(:,837), n3(:,1235), t3x256(:,:,837), nhel, den(1289))
    call cont_QA(nsync, wf16(:,135), wf16(:,304), A(:,838), n3(:,1236), t3x256(:,:,838), nhel, den(1290))
    call cont_QA(nsync, wf16(:,136), wf16(:,249), A(:,839), n3(:,1237), t3x256(:,:,839), nhel, den(1291))
    call cont_QA(nsync, wf16(:,136), wf16(:,250), A(:,840), n3(:,1238), t3x256(:,:,840), nhel, den(1292))
    call cont_QA(nsync, wf16(:,113), wf16(:,264), A(:,841), n3(:,1239), t3x256(:,:,841), nhel, den(1293))
    call cont_QA(nsync, wf16(:,113), wf16(:,265), A(:,842), n3(:,1240), t3x256(:,:,842), nhel, den(1294))
    call cont_QA(nsync, wf16(:,114), wf16(:,264), A(:,843), n3(:,1241), t3x256(:,:,843), nhel, den(1295))
    call cont_QA(nsync, wf16(:,114), wf16(:,265), A(:,844), n3(:,1242), t3x256(:,:,844), nhel, den(1296))
    call cont_QA(nsync, wf16(:,135), wf16(:,305), A(:,845), n3(:,1243), t3x256(:,:,845), nhel, den(1297))
    call cont_QA(nsync, wf16(:,135), wf16(:,306), A(:,846), n3(:,1244), t3x256(:,:,846), nhel, den(1298))
    call cont_QA(nsync, wf16(:,136), wf16(:,251), A(:,847), n3(:,1245), t3x256(:,:,847), nhel, den(1299))
    call cont_QA(nsync, wf16(:,136), wf16(:,252), A(:,848), n3(:,1246), t3x256(:,:,848), nhel, den(1300))
    call cont_QA(nsync, wf16(:,140), wf16(:,287), A(:,849), n3(:,1247), t3x256(:,:,849), nhel, den(1301))
    call cont_QA(nsync, wf16(:,140), wf16(:,288), A(:,850), n3(:,1248), t3x256(:,:,850), nhel, den(1302))
    call cont_QA(nsync, wf16(:,139), wf16(:,287), A(:,851), n3(:,1249), t3x256(:,:,851), nhel, den(1303))
    call cont_QA(nsync, wf16(:,139), wf16(:,288), A(:,852), n3(:,1250), t3x256(:,:,852), nhel, den(1304))
    call cont_QA(nsync, wf16(:,159), wf16(:,303), A(:,853), n3(:,1251), t3x256(:,:,853), nhel, den(1305))
    call cont_QA(nsync, wf16(:,159), wf16(:,304), A(:,854), n3(:,1252), t3x256(:,:,854), nhel, den(1306))
    call cont_QA(nsync, wf16(:,160), wf16(:,249), A(:,855), n3(:,1253), t3x256(:,:,855), nhel, den(1307))
    call cont_QA(nsync, wf16(:,160), wf16(:,250), A(:,856), n3(:,1254), t3x256(:,:,856), nhel, den(1308))
    call cont_QA(nsync, wf16(:,140), wf16(:,289), A(:,857), n3(:,1255), t3x256(:,:,857), nhel, den(1309))
    call cont_QA(nsync, wf16(:,140), wf16(:,290), A(:,858), n3(:,1256), t3x256(:,:,858), nhel, den(1310))
    call cont_QA(nsync, wf16(:,139), wf16(:,289), A(:,859), n3(:,1257), t3x256(:,:,859), nhel, den(1311))
    call cont_QA(nsync, wf16(:,139), wf16(:,290), A(:,860), n3(:,1258), t3x256(:,:,860), nhel, den(1312))
    call cont_QA(nsync, wf16(:,159), wf16(:,305), A(:,861), n3(:,1259), t3x256(:,:,861), nhel, den(1313))
    call cont_QA(nsync, wf16(:,159), wf16(:,306), A(:,862), n3(:,1260), t3x256(:,:,862), nhel, den(1314))
    call cont_QA(nsync, wf16(:,160), wf16(:,251), A(:,863), n3(:,1261), t3x256(:,:,863), nhel, den(1315))
    call cont_QA(nsync, wf16(:,160), wf16(:,252), A(:,864), n3(:,1262), t3x256(:,:,864), nhel, den(1316))
    call cont_QA(nsync, wf16(:,163), wf16(:,287), A(:,865), n3(:,1263), t3x256(:,:,865), nhel, den(1317))
    call cont_QA(nsync, wf16(:,163), wf16(:,288), A(:,866), n3(:,1264), t3x256(:,:,866), nhel, den(1318))
    call cont_QA(nsync, wf16(:,165), wf16(:,257), A(:,867), n3(:,1265), t3x256(:,:,867), nhel, den(1319))
    call cont_QA(nsync, wf16(:,165), wf16(:,258), A(:,868), n3(:,1266), t3x256(:,:,868), nhel, den(1320))
    call cont_QA(nsync, wf16(:,175), wf16(:,249), A(:,869), n3(:,1267), t3x256(:,:,869), nhel, den(1321))
    call cont_QA(nsync, wf16(:,175), wf16(:,250), A(:,870), n3(:,1268), t3x256(:,:,870), nhel, den(1322))
    call cont_QA(nsync, wf16(:,176), wf16(:,249), A(:,871), n3(:,1269), t3x256(:,:,871), nhel, den(1323))
    call cont_QA(nsync, wf16(:,176), wf16(:,250), A(:,872), n3(:,1270), t3x256(:,:,872), nhel, den(1324))
    call cont_QA(nsync, wf16(:,163), wf16(:,289), A(:,873), n3(:,1271), t3x256(:,:,873), nhel, den(1325))
    call cont_QA(nsync, wf16(:,163), wf16(:,290), A(:,874), n3(:,1272), t3x256(:,:,874), nhel, den(1326))
    call cont_QA(nsync, wf16(:,165), wf16(:,264), A(:,875), n3(:,1273), t3x256(:,:,875), nhel, den(1327))
    call cont_QA(nsync, wf16(:,165), wf16(:,265), A(:,876), n3(:,1274), t3x256(:,:,876), nhel, den(1328))
    call cont_QA(nsync, wf16(:,175), wf16(:,251), A(:,877), n3(:,1275), t3x256(:,:,877), nhel, den(1329))
    call cont_QA(nsync, wf16(:,175), wf16(:,252), A(:,878), n3(:,1276), t3x256(:,:,878), nhel, den(1330))
    call cont_QA(nsync, wf16(:,176), wf16(:,251), A(:,879), n3(:,1277), t3x256(:,:,879), nhel, den(1331))
    call cont_QA(nsync, wf16(:,176), wf16(:,252), A(:,880), n3(:,1278), t3x256(:,:,880), nhel, den(1332))
    call cont_QA(nsync, wf16(:,179), wf16(:,287), A(:,881), n3(:,1279), t3x256(:,:,881), nhel, den(1333))
    call cont_QA(nsync, wf16(:,179), wf16(:,288), A(:,882), n3(:,1280), t3x256(:,:,882), nhel, den(1334))
    call cont_QA(nsync, wf16(:,181), wf16(:,257), A(:,883), n3(:,1281), t3x256(:,:,883), nhel, den(1335))
    call cont_QA(nsync, wf16(:,181), wf16(:,258), A(:,884), n3(:,1282), t3x256(:,:,884), nhel, den(1336))
    call cont_QA(nsync, wf16(:,192), wf16(:,303), A(:,885), n3(:,1283), t3x256(:,:,885), nhel, den(1337))
    call cont_QA(nsync, wf16(:,192), wf16(:,304), A(:,886), n3(:,1284), t3x256(:,:,886), nhel, den(1338))
    call cont_QA(nsync, wf16(:,191), wf16(:,303), A(:,887), n3(:,1285), t3x256(:,:,887), nhel, den(1339))
    call cont_QA(nsync, wf16(:,191), wf16(:,304), A(:,888), n3(:,1286), t3x256(:,:,888), nhel, den(1340))
    call cont_QA(nsync, wf16(:,179), wf16(:,289), A(:,889), n3(:,1287), t3x256(:,:,889), nhel, den(1341))
    call cont_QA(nsync, wf16(:,179), wf16(:,290), A(:,890), n3(:,1288), t3x256(:,:,890), nhel, den(1342))
    call cont_QA(nsync, wf16(:,181), wf16(:,264), A(:,891), n3(:,1289), t3x256(:,:,891), nhel, den(1343))
    call cont_QA(nsync, wf16(:,181), wf16(:,265), A(:,892), n3(:,1290), t3x256(:,:,892), nhel, den(1344))
    call cont_QA(nsync, wf16(:,192), wf16(:,305), A(:,893), n3(:,1291), t3x256(:,:,893), nhel, den(1345))
    call cont_QA(nsync, wf16(:,192), wf16(:,306), A(:,894), n3(:,1292), t3x256(:,:,894), nhel, den(1346))
    call cont_QA(nsync, wf16(:,191), wf16(:,305), A(:,895), n3(:,1293), t3x256(:,:,895), nhel, den(1347))
    call cont_QA(nsync, wf16(:,191), wf16(:,306), A(:,896), n3(:,1294), t3x256(:,:,896), nhel, den(1348))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(2) ! M1helarray(2,256)
  integer :: empty(0)

  M1(1) = ((-A(j,49)%j-A(j,51)%j-A(j,53)%j-A(j,55)%j-A(j,57)%j-A(j,59)%j-A(j,61)%j-A(j,63)%j-A(j,65)%j-A(j,67)%j-A(j,69)%j &
       -A(j,71)%j-A(j,73)%j-A(j,75)%j-A(j,77)%j-A(j,79)%j-A(j,81)%j-A(j,83)%j-A(j,85)%j-A(j,87)%j-A(j,89)%j-A(j,91)%j-A(j,93)%j &
       -A(j,95)%j-A(j,97)%j-A(j,99)%j-A(j,101)%j-A(j,103)%j-A(j,105)%j-A(j,107)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,115)%j &
       -A(j,117)%j-A(j,119)%j-A(j,121)%j-A(j,123)%j-A(j,125)%j-A(j,127)%j-A(j,129)%j-A(j,131)%j-A(j,133)%j-A(j,135)%j-A(j,137)%j &
       -A(j,139)%j-A(j,141)%j-A(j,143)%j-A(j,193)%j-A(j,199)%j-A(j,203)%j-A(j,205)%j-A(j,209)%j-A(j,213)%j-A(j,217)%j-A(j,219)%j &
       -A(j,223)%j-A(j,225)%j-A(j,235)%j-A(j,237)%j-A(j,241)%j-A(j,243)%j-A(j,249)%j-A(j,255)%j-A(j,259)%j-A(j,261)%j-A(j,265)%j &
       -A(j,271)%j-A(j,279)%j-A(j,283)%j-A(j,285)%j-A(j,287)%j-A(j,291)%j-A(j,293)%j-A(j,301)%j-A(j,303)%j-A(j,305)%j-A(j,309)%j &
       -A(j,313)%j-A(j,315)%j-A(j,317)%j-A(j,323)%j-A(j,329)%j-A(j,335)%j-A(j,339)%j-A(j,341)%j-A(j,345)%j-A(j,347)%j-A(j,355)%j &
       -A(j,357)%j-A(j,363)%j-A(j,365)%j-A(j,375)%j-A(j,379)%j-A(j,381)%j-A(j,383)%j-A(j,385)%j-A(j,391)%j-A(j,395)%j-A(j,397)%j &
       -A(j,405)%j-A(j,407)%j-A(j,411)%j-A(j,413)%j-A(j,419)%j-A(j,421)%j-A(j,425)%j-A(j,427)%j-A(j,435)%j-A(j,437)%j-A(j,445)%j &
       -A(j,447)%j-A(j,449)%j-A(j,451)%j-A(j,459)%j-A(j,461)%j-A(j,469)%j-A(j,471)%j-A(j,475)%j-A(j,477)%j)*f(1))/6._/**/REALKIND &
       +((-A(j,1)%j-A(j,3)%j-A(j,5)%j-A(j,7)%j-A(j,9)%j-A(j,11)%j-A(j,13)%j-A(j,15)%j-A(j,17)%j-A(j,19)%j-A(j,21)%j-A(j,23)%j &
       -A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j-A(j,37)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j-A(j,47)%j &
       -A(j,145)%j-A(j,147)%j-A(j,149)%j-A(j,151)%j-A(j,153)%j-A(j,155)%j-A(j,157)%j-A(j,159)%j-A(j,161)%j-A(j,163)%j-A(j,165)%j &
       -A(j,167)%j-A(j,169)%j-A(j,171)%j-A(j,173)%j-A(j,175)%j-A(j,177)%j-A(j,179)%j-A(j,181)%j-A(j,183)%j-A(j,185)%j-A(j,187)%j &
       -A(j,189)%j-A(j,191)%j-A(j,195)%j-A(j,197)%j-A(j,201)%j-A(j,207)%j-A(j,211)%j-A(j,215)%j-A(j,221)%j-A(j,227)%j-A(j,229)%j &
       -A(j,231)%j-A(j,233)%j-A(j,239)%j-A(j,245)%j-A(j,247)%j-A(j,251)%j-A(j,253)%j-A(j,257)%j-A(j,263)%j-A(j,267)%j-A(j,269)%j &
       -A(j,273)%j-A(j,275)%j-A(j,277)%j-A(j,281)%j-A(j,289)%j-A(j,295)%j-A(j,297)%j-A(j,299)%j-A(j,307)%j-A(j,311)%j-A(j,319)%j &
       -A(j,321)%j-A(j,325)%j-A(j,327)%j-A(j,331)%j-A(j,333)%j-A(j,337)%j-A(j,343)%j-A(j,349)%j-A(j,351)%j-A(j,353)%j-A(j,359)%j &
       -A(j,361)%j-A(j,367)%j-A(j,369)%j-A(j,371)%j-A(j,373)%j-A(j,377)%j-A(j,387)%j-A(j,389)%j-A(j,393)%j-A(j,399)%j-A(j,401)%j &
       -A(j,403)%j-A(j,409)%j-A(j,415)%j-A(j,417)%j-A(j,423)%j-A(j,429)%j-A(j,431)%j-A(j,433)%j-A(j,439)%j-A(j,441)%j-A(j,443)%j &
       -A(j,453)%j-A(j,455)%j-A(j,457)%j-A(j,463)%j-A(j,465)%j-A(j,467)%j-A(j,473)%j-A(j,479)%j)*f(1))/2._/**/REALKIND+((-A(j,2)%j &
       -A(j,4)%j-A(j,6)%j-A(j,8)%j-A(j,10)%j-A(j,12)%j-A(j,14)%j-A(j,16)%j-A(j,18)%j-A(j,20)%j-A(j,22)%j-A(j,24)%j-A(j,26)%j &
       -A(j,28)%j-A(j,30)%j-A(j,32)%j-A(j,34)%j-A(j,36)%j-A(j,38)%j-A(j,40)%j-A(j,42)%j-A(j,44)%j-A(j,46)%j-A(j,48)%j-A(j,146)%j &
       -A(j,148)%j-A(j,150)%j-A(j,152)%j-A(j,154)%j-A(j,156)%j-A(j,158)%j-A(j,160)%j-A(j,162)%j-A(j,164)%j-A(j,166)%j-A(j,168)%j &
       -A(j,170)%j-A(j,172)%j-A(j,174)%j-A(j,176)%j-A(j,178)%j-A(j,180)%j-A(j,182)%j-A(j,184)%j-A(j,186)%j-A(j,188)%j-A(j,190)%j &
       -A(j,192)%j-A(j,196)%j-A(j,198)%j-A(j,202)%j-A(j,208)%j-A(j,212)%j-A(j,216)%j-A(j,222)%j-A(j,228)%j-A(j,230)%j-A(j,232)%j &
       -A(j,234)%j-A(j,240)%j-A(j,246)%j-A(j,248)%j-A(j,252)%j-A(j,254)%j-A(j,258)%j-A(j,264)%j-A(j,268)%j-A(j,270)%j-A(j,274)%j &
       -A(j,276)%j-A(j,278)%j-A(j,282)%j-A(j,290)%j-A(j,296)%j-A(j,298)%j-A(j,300)%j-A(j,308)%j-A(j,312)%j-A(j,320)%j-A(j,322)%j &
       -A(j,326)%j-A(j,328)%j-A(j,332)%j-A(j,334)%j-A(j,338)%j-A(j,344)%j-A(j,350)%j-A(j,352)%j-A(j,354)%j-A(j,360)%j-A(j,362)%j &
       -A(j,368)%j-A(j,370)%j-A(j,372)%j-A(j,374)%j-A(j,378)%j-A(j,388)%j-A(j,390)%j-A(j,394)%j-A(j,400)%j-A(j,402)%j-A(j,404)%j &
       -A(j,410)%j-A(j,416)%j-A(j,418)%j-A(j,424)%j-A(j,430)%j-A(j,432)%j-A(j,434)%j-A(j,440)%j-A(j,442)%j-A(j,444)%j-A(j,454)%j &
       -A(j,456)%j-A(j,458)%j-A(j,464)%j-A(j,466)%j-A(j,468)%j-A(j,474)%j-A(j,480)%j-A(j,485)%j-A(j,487)%j-A(j,489)%j-A(j,491)%j &
       -A(j,493)%j-A(j,495)%j-A(j,505)%j-A(j,507)%j-A(j,509)%j-A(j,511)%j-A(j,513)%j-A(j,515)%j-A(j,521)%j-A(j,523)%j-A(j,525)%j &
       -A(j,527)%j-A(j,529)%j-A(j,531)%j-A(j,533)%j-A(j,535)%j-A(j,537)%j-A(j,539)%j-A(j,545)%j-A(j,547)%j-A(j,701)%j-A(j,703)%j &
       -A(j,705)%j-A(j,707)%j-A(j,709)%j-A(j,711)%j-A(j,721)%j-A(j,723)%j-A(j,725)%j-A(j,727)%j-A(j,729)%j-A(j,731)%j-A(j,737)%j &
       -A(j,739)%j-A(j,741)%j-A(j,743)%j-A(j,745)%j-A(j,747)%j-A(j,749)%j-A(j,751)%j-A(j,753)%j-A(j,755)%j-A(j,761)%j-A(j,763)%j &
       -A(j,769)%j-A(j,775)%j-A(j,777)%j-A(j,781)%j-A(j,787)%j-A(j,789)%j-A(j,793)%j-A(j,797)%j-A(j,801)%j-A(j,807)%j-A(j,809)%j &
       -A(j,813)%j-A(j,819)%j-A(j,821)%j-A(j,825)%j-A(j,829)%j-A(j,833)%j-A(j,839)%j-A(j,841)%j-A(j,847)%j-A(j,849)%j-A(j,853)%j &
       -A(j,857)%j-A(j,861)%j-A(j,867)%j-A(j,869)%j-A(j,875)%j-A(j,877)%j-A(j,881)%j-A(j,885)%j-A(j,889)%j &
       -A(j,893)%j)*f(2))/2._/**/REALKIND+((-A(j,50)%j-A(j,52)%j-A(j,54)%j-A(j,56)%j-A(j,58)%j-A(j,60)%j-A(j,62)%j-A(j,64)%j &
       -A(j,66)%j-A(j,68)%j-A(j,70)%j-A(j,72)%j-A(j,74)%j-A(j,76)%j-A(j,78)%j-A(j,80)%j-A(j,82)%j-A(j,84)%j-A(j,86)%j-A(j,88)%j &
       -A(j,90)%j-A(j,92)%j-A(j,94)%j-A(j,96)%j-A(j,98)%j-A(j,100)%j-A(j,102)%j-A(j,104)%j-A(j,106)%j-A(j,108)%j-A(j,110)%j &
       -A(j,112)%j-A(j,114)%j-A(j,116)%j-A(j,118)%j-A(j,120)%j-A(j,122)%j-A(j,124)%j-A(j,126)%j-A(j,128)%j-A(j,130)%j-A(j,132)%j &
       -A(j,134)%j-A(j,136)%j-A(j,138)%j-A(j,140)%j-A(j,142)%j-A(j,144)%j-A(j,194)%j-A(j,200)%j-A(j,204)%j-A(j,206)%j-A(j,210)%j &
       -A(j,214)%j-A(j,218)%j-A(j,220)%j-A(j,224)%j-A(j,226)%j-A(j,236)%j-A(j,238)%j-A(j,242)%j-A(j,244)%j-A(j,250)%j-A(j,256)%j &
       -A(j,260)%j-A(j,262)%j-A(j,266)%j-A(j,272)%j-A(j,280)%j-A(j,284)%j-A(j,286)%j-A(j,288)%j-A(j,292)%j-A(j,294)%j-A(j,302)%j &
       -A(j,304)%j-A(j,306)%j-A(j,310)%j-A(j,314)%j-A(j,316)%j-A(j,318)%j-A(j,324)%j-A(j,330)%j-A(j,336)%j-A(j,340)%j-A(j,342)%j &
       -A(j,346)%j-A(j,348)%j-A(j,356)%j-A(j,358)%j-A(j,364)%j-A(j,366)%j-A(j,376)%j-A(j,380)%j-A(j,382)%j-A(j,384)%j-A(j,386)%j &
       -A(j,392)%j-A(j,396)%j-A(j,398)%j-A(j,406)%j-A(j,408)%j-A(j,412)%j-A(j,414)%j-A(j,420)%j-A(j,422)%j-A(j,426)%j-A(j,428)%j &
       -A(j,436)%j-A(j,438)%j-A(j,446)%j-A(j,448)%j-A(j,450)%j-A(j,452)%j-A(j,460)%j-A(j,462)%j-A(j,470)%j-A(j,472)%j-A(j,476)%j &
       -A(j,478)%j-A(j,557)%j-A(j,559)%j-A(j,561)%j-A(j,563)%j-A(j,565)%j-A(j,567)%j-A(j,577)%j-A(j,579)%j-A(j,581)%j-A(j,583)%j &
       -A(j,585)%j-A(j,587)%j-A(j,593)%j-A(j,595)%j-A(j,597)%j-A(j,599)%j-A(j,601)%j-A(j,603)%j-A(j,605)%j-A(j,607)%j-A(j,609)%j &
       -A(j,611)%j-A(j,617)%j-A(j,619)%j-A(j,629)%j-A(j,631)%j-A(j,633)%j-A(j,635)%j-A(j,637)%j-A(j,639)%j-A(j,649)%j-A(j,651)%j &
       -A(j,653)%j-A(j,655)%j-A(j,657)%j-A(j,659)%j-A(j,665)%j-A(j,667)%j-A(j,669)%j-A(j,671)%j-A(j,673)%j-A(j,675)%j-A(j,677)%j &
       -A(j,679)%j-A(j,681)%j-A(j,683)%j-A(j,689)%j-A(j,691)%j-A(j,771)%j-A(j,773)%j-A(j,779)%j-A(j,783)%j-A(j,785)%j-A(j,791)%j &
       -A(j,795)%j-A(j,799)%j-A(j,803)%j-A(j,805)%j-A(j,811)%j-A(j,815)%j-A(j,817)%j-A(j,823)%j-A(j,827)%j-A(j,831)%j-A(j,835)%j &
       -A(j,837)%j-A(j,843)%j-A(j,845)%j-A(j,851)%j-A(j,855)%j-A(j,859)%j-A(j,863)%j-A(j,865)%j-A(j,871)%j-A(j,873)%j-A(j,879)%j &
       -A(j,883)%j-A(j,887)%j-A(j,891)%j-A(j,895)%j)*f(2))/6._/**/REALKIND+((-A(j,481)%j-A(j,483)%j-A(j,486)%j-A(j,488)%j &
       -A(j,490)%j-A(j,492)%j-A(j,494)%j-A(j,496)%j-A(j,497)%j-A(j,499)%j-A(j,501)%j-A(j,503)%j-A(j,506)%j-A(j,508)%j-A(j,510)%j &
       -A(j,512)%j-A(j,514)%j-A(j,516)%j-A(j,517)%j-A(j,519)%j-A(j,522)%j-A(j,524)%j-A(j,526)%j-A(j,528)%j-A(j,530)%j-A(j,532)%j &
       -A(j,534)%j-A(j,536)%j-A(j,538)%j-A(j,540)%j-A(j,541)%j-A(j,543)%j-A(j,546)%j-A(j,548)%j-A(j,549)%j-A(j,551)%j-A(j,697)%j &
       -A(j,699)%j-A(j,702)%j-A(j,704)%j-A(j,706)%j-A(j,708)%j-A(j,710)%j-A(j,712)%j-A(j,713)%j-A(j,715)%j-A(j,717)%j-A(j,719)%j &
       -A(j,722)%j-A(j,724)%j-A(j,726)%j-A(j,728)%j-A(j,730)%j-A(j,732)%j-A(j,733)%j-A(j,735)%j-A(j,738)%j-A(j,740)%j-A(j,742)%j &
       -A(j,744)%j-A(j,746)%j-A(j,748)%j-A(j,750)%j-A(j,752)%j-A(j,754)%j-A(j,756)%j-A(j,757)%j-A(j,759)%j-A(j,762)%j-A(j,764)%j &
       -A(j,765)%j-A(j,767)%j-A(j,770)%j-A(j,776)%j-A(j,778)%j-A(j,782)%j-A(j,788)%j-A(j,790)%j-A(j,794)%j-A(j,798)%j-A(j,802)%j &
       -A(j,808)%j-A(j,810)%j-A(j,814)%j-A(j,820)%j-A(j,822)%j-A(j,826)%j-A(j,830)%j-A(j,834)%j-A(j,840)%j-A(j,842)%j-A(j,848)%j &
       -A(j,850)%j-A(j,854)%j-A(j,858)%j-A(j,862)%j-A(j,868)%j-A(j,870)%j-A(j,876)%j-A(j,878)%j-A(j,882)%j-A(j,886)%j-A(j,890)%j &
       -A(j,894)%j)*f(3))/2._/**/REALKIND+((-A(j,553)%j-A(j,555)%j-A(j,558)%j-A(j,560)%j-A(j,562)%j-A(j,564)%j-A(j,566)%j &
       -A(j,568)%j-A(j,569)%j-A(j,571)%j-A(j,573)%j-A(j,575)%j-A(j,578)%j-A(j,580)%j-A(j,582)%j-A(j,584)%j-A(j,586)%j-A(j,588)%j &
       -A(j,589)%j-A(j,591)%j-A(j,594)%j-A(j,596)%j-A(j,598)%j-A(j,600)%j-A(j,602)%j-A(j,604)%j-A(j,606)%j-A(j,608)%j-A(j,610)%j &
       -A(j,612)%j-A(j,613)%j-A(j,615)%j-A(j,618)%j-A(j,620)%j-A(j,621)%j-A(j,623)%j-A(j,625)%j-A(j,627)%j-A(j,630)%j-A(j,632)%j &
       -A(j,634)%j-A(j,636)%j-A(j,638)%j-A(j,640)%j-A(j,641)%j-A(j,643)%j-A(j,645)%j-A(j,647)%j-A(j,650)%j-A(j,652)%j-A(j,654)%j &
       -A(j,656)%j-A(j,658)%j-A(j,660)%j-A(j,661)%j-A(j,663)%j-A(j,666)%j-A(j,668)%j-A(j,670)%j-A(j,672)%j-A(j,674)%j-A(j,676)%j &
       -A(j,678)%j-A(j,680)%j-A(j,682)%j-A(j,684)%j-A(j,685)%j-A(j,687)%j-A(j,690)%j-A(j,692)%j-A(j,693)%j-A(j,695)%j-A(j,772)%j &
       -A(j,774)%j-A(j,780)%j-A(j,784)%j-A(j,786)%j-A(j,792)%j-A(j,796)%j-A(j,800)%j-A(j,804)%j-A(j,806)%j-A(j,812)%j-A(j,816)%j &
       -A(j,818)%j-A(j,824)%j-A(j,828)%j-A(j,832)%j-A(j,836)%j-A(j,838)%j-A(j,844)%j-A(j,846)%j-A(j,852)%j-A(j,856)%j-A(j,860)%j &
       -A(j,864)%j-A(j,866)%j-A(j,872)%j-A(j,874)%j-A(j,880)%j-A(j,884)%j-A(j,888)%j-A(j,892)%j-A(j,896)%j)*f(3))/6._/**/REALKIND &
       +((-A(j,554)%j-A(j,556)%j-A(j,570)%j-A(j,572)%j-A(j,574)%j-A(j,576)%j-A(j,590)%j-A(j,592)%j-A(j,614)%j-A(j,616)%j &
       -A(j,622)%j-A(j,624)%j-A(j,626)%j-A(j,628)%j-A(j,642)%j-A(j,644)%j-A(j,646)%j-A(j,648)%j-A(j,662)%j-A(j,664)%j-A(j,686)%j &
       -A(j,688)%j-A(j,694)%j-A(j,696)%j)*f(4))/6._/**/REALKIND+((-A(j,482)%j-A(j,484)%j-A(j,498)%j-A(j,500)%j-A(j,502)%j &
       -A(j,504)%j-A(j,518)%j-A(j,520)%j-A(j,542)%j-A(j,544)%j-A(j,550)%j-A(j,552)%j-A(j,698)%j-A(j,700)%j-A(j,714)%j-A(j,716)%j &
       -A(j,718)%j-A(j,720)%j-A(j,734)%j-A(j,736)%j-A(j,758)%j-A(j,760)%j-A(j,766)%j-A(j,768)%j)*f(4))/2._/**/REALKIND
  M1(2) = ((A(j,49)%j+A(j,51)%j+A(j,53)%j+A(j,55)%j+A(j,57)%j+A(j,59)%j+A(j,61)%j+A(j,63)%j+A(j,65)%j+A(j,67)%j+A(j,69)%j &
       +A(j,71)%j+A(j,73)%j+A(j,75)%j+A(j,77)%j+A(j,79)%j+A(j,81)%j+A(j,83)%j+A(j,85)%j+A(j,87)%j+A(j,89)%j+A(j,91)%j+A(j,93)%j &
       +A(j,95)%j+A(j,97)%j+A(j,99)%j+A(j,101)%j+A(j,103)%j+A(j,105)%j+A(j,107)%j+A(j,109)%j+A(j,111)%j+A(j,113)%j+A(j,115)%j &
       +A(j,117)%j+A(j,119)%j+A(j,121)%j+A(j,123)%j+A(j,125)%j+A(j,127)%j+A(j,129)%j+A(j,131)%j+A(j,133)%j+A(j,135)%j+A(j,137)%j &
       +A(j,139)%j+A(j,141)%j+A(j,143)%j+A(j,193)%j+A(j,199)%j+A(j,203)%j+A(j,205)%j+A(j,209)%j+A(j,213)%j+A(j,217)%j+A(j,219)%j &
       +A(j,223)%j+A(j,225)%j+A(j,235)%j+A(j,237)%j+A(j,241)%j+A(j,243)%j+A(j,249)%j+A(j,255)%j+A(j,259)%j+A(j,261)%j+A(j,265)%j &
       +A(j,271)%j+A(j,279)%j+A(j,283)%j+A(j,285)%j+A(j,287)%j+A(j,291)%j+A(j,293)%j+A(j,301)%j+A(j,303)%j+A(j,305)%j+A(j,309)%j &
       +A(j,313)%j+A(j,315)%j+A(j,317)%j+A(j,323)%j+A(j,329)%j+A(j,335)%j+A(j,339)%j+A(j,341)%j+A(j,345)%j+A(j,347)%j+A(j,355)%j &
       +A(j,357)%j+A(j,363)%j+A(j,365)%j+A(j,375)%j+A(j,379)%j+A(j,381)%j+A(j,383)%j+A(j,385)%j+A(j,391)%j+A(j,395)%j+A(j,397)%j &
       +A(j,405)%j+A(j,407)%j+A(j,411)%j+A(j,413)%j+A(j,419)%j+A(j,421)%j+A(j,425)%j+A(j,427)%j+A(j,435)%j+A(j,437)%j+A(j,445)%j &
       +A(j,447)%j+A(j,449)%j+A(j,451)%j+A(j,459)%j+A(j,461)%j+A(j,469)%j+A(j,471)%j+A(j,475)%j+A(j,477)%j)*f(1))/2._/**/REALKIND &
       +((A(j,1)%j+A(j,3)%j+A(j,5)%j+A(j,7)%j+A(j,9)%j+A(j,11)%j+A(j,13)%j+A(j,15)%j+A(j,17)%j+A(j,19)%j+A(j,21)%j+A(j,23)%j &
       +A(j,25)%j+A(j,27)%j+A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,35)%j+A(j,37)%j+A(j,39)%j+A(j,41)%j+A(j,43)%j+A(j,45)%j+A(j,47)%j &
       +A(j,145)%j+A(j,147)%j+A(j,149)%j+A(j,151)%j+A(j,153)%j+A(j,155)%j+A(j,157)%j+A(j,159)%j+A(j,161)%j+A(j,163)%j+A(j,165)%j &
       +A(j,167)%j+A(j,169)%j+A(j,171)%j+A(j,173)%j+A(j,175)%j+A(j,177)%j+A(j,179)%j+A(j,181)%j+A(j,183)%j+A(j,185)%j+A(j,187)%j &
       +A(j,189)%j+A(j,191)%j+A(j,195)%j+A(j,197)%j+A(j,201)%j+A(j,207)%j+A(j,211)%j+A(j,215)%j+A(j,221)%j+A(j,227)%j+A(j,229)%j &
       +A(j,231)%j+A(j,233)%j+A(j,239)%j+A(j,245)%j+A(j,247)%j+A(j,251)%j+A(j,253)%j+A(j,257)%j+A(j,263)%j+A(j,267)%j+A(j,269)%j &
       +A(j,273)%j+A(j,275)%j+A(j,277)%j+A(j,281)%j+A(j,289)%j+A(j,295)%j+A(j,297)%j+A(j,299)%j+A(j,307)%j+A(j,311)%j+A(j,319)%j &
       +A(j,321)%j+A(j,325)%j+A(j,327)%j+A(j,331)%j+A(j,333)%j+A(j,337)%j+A(j,343)%j+A(j,349)%j+A(j,351)%j+A(j,353)%j+A(j,359)%j &
       +A(j,361)%j+A(j,367)%j+A(j,369)%j+A(j,371)%j+A(j,373)%j+A(j,377)%j+A(j,387)%j+A(j,389)%j+A(j,393)%j+A(j,399)%j+A(j,401)%j &
       +A(j,403)%j+A(j,409)%j+A(j,415)%j+A(j,417)%j+A(j,423)%j+A(j,429)%j+A(j,431)%j+A(j,433)%j+A(j,439)%j+A(j,441)%j+A(j,443)%j &
       +A(j,453)%j+A(j,455)%j+A(j,457)%j+A(j,463)%j+A(j,465)%j+A(j,467)%j+A(j,473)%j+A(j,479)%j)*f(1))/6._/**/REALKIND+((A(j,2)%j &
       +A(j,4)%j+A(j,6)%j+A(j,8)%j+A(j,10)%j+A(j,12)%j+A(j,14)%j+A(j,16)%j+A(j,18)%j+A(j,20)%j+A(j,22)%j+A(j,24)%j+A(j,26)%j &
       +A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j+A(j,38)%j+A(j,40)%j+A(j,42)%j+A(j,44)%j+A(j,46)%j+A(j,48)%j+A(j,146)%j &
       +A(j,148)%j+A(j,150)%j+A(j,152)%j+A(j,154)%j+A(j,156)%j+A(j,158)%j+A(j,160)%j+A(j,162)%j+A(j,164)%j+A(j,166)%j+A(j,168)%j &
       +A(j,170)%j+A(j,172)%j+A(j,174)%j+A(j,176)%j+A(j,178)%j+A(j,180)%j+A(j,182)%j+A(j,184)%j+A(j,186)%j+A(j,188)%j+A(j,190)%j &
       +A(j,192)%j+A(j,196)%j+A(j,198)%j+A(j,202)%j+A(j,208)%j+A(j,212)%j+A(j,216)%j+A(j,222)%j+A(j,228)%j+A(j,230)%j+A(j,232)%j &
       +A(j,234)%j+A(j,240)%j+A(j,246)%j+A(j,248)%j+A(j,252)%j+A(j,254)%j+A(j,258)%j+A(j,264)%j+A(j,268)%j+A(j,270)%j+A(j,274)%j &
       +A(j,276)%j+A(j,278)%j+A(j,282)%j+A(j,290)%j+A(j,296)%j+A(j,298)%j+A(j,300)%j+A(j,308)%j+A(j,312)%j+A(j,320)%j+A(j,322)%j &
       +A(j,326)%j+A(j,328)%j+A(j,332)%j+A(j,334)%j+A(j,338)%j+A(j,344)%j+A(j,350)%j+A(j,352)%j+A(j,354)%j+A(j,360)%j+A(j,362)%j &
       +A(j,368)%j+A(j,370)%j+A(j,372)%j+A(j,374)%j+A(j,378)%j+A(j,388)%j+A(j,390)%j+A(j,394)%j+A(j,400)%j+A(j,402)%j+A(j,404)%j &
       +A(j,410)%j+A(j,416)%j+A(j,418)%j+A(j,424)%j+A(j,430)%j+A(j,432)%j+A(j,434)%j+A(j,440)%j+A(j,442)%j+A(j,444)%j+A(j,454)%j &
       +A(j,456)%j+A(j,458)%j+A(j,464)%j+A(j,466)%j+A(j,468)%j+A(j,474)%j+A(j,480)%j+A(j,485)%j+A(j,487)%j+A(j,489)%j+A(j,491)%j &
       +A(j,493)%j+A(j,495)%j+A(j,505)%j+A(j,507)%j+A(j,509)%j+A(j,511)%j+A(j,513)%j+A(j,515)%j+A(j,521)%j+A(j,523)%j+A(j,525)%j &
       +A(j,527)%j+A(j,529)%j+A(j,531)%j+A(j,533)%j+A(j,535)%j+A(j,537)%j+A(j,539)%j+A(j,545)%j+A(j,547)%j+A(j,701)%j+A(j,703)%j &
       +A(j,705)%j+A(j,707)%j+A(j,709)%j+A(j,711)%j+A(j,721)%j+A(j,723)%j+A(j,725)%j+A(j,727)%j+A(j,729)%j+A(j,731)%j+A(j,737)%j &
       +A(j,739)%j+A(j,741)%j+A(j,743)%j+A(j,745)%j+A(j,747)%j+A(j,749)%j+A(j,751)%j+A(j,753)%j+A(j,755)%j+A(j,761)%j+A(j,763)%j &
       +A(j,769)%j+A(j,775)%j+A(j,777)%j+A(j,781)%j+A(j,787)%j+A(j,789)%j+A(j,793)%j+A(j,797)%j+A(j,801)%j+A(j,807)%j+A(j,809)%j &
       +A(j,813)%j+A(j,819)%j+A(j,821)%j+A(j,825)%j+A(j,829)%j+A(j,833)%j+A(j,839)%j+A(j,841)%j+A(j,847)%j+A(j,849)%j+A(j,853)%j &
       +A(j,857)%j+A(j,861)%j+A(j,867)%j+A(j,869)%j+A(j,875)%j+A(j,877)%j+A(j,881)%j+A(j,885)%j+A(j,889)%j &
       +A(j,893)%j)*f(2))/6._/**/REALKIND+((A(j,50)%j+A(j,52)%j+A(j,54)%j+A(j,56)%j+A(j,58)%j+A(j,60)%j+A(j,62)%j+A(j,64)%j &
       +A(j,66)%j+A(j,68)%j+A(j,70)%j+A(j,72)%j+A(j,74)%j+A(j,76)%j+A(j,78)%j+A(j,80)%j+A(j,82)%j+A(j,84)%j+A(j,86)%j+A(j,88)%j &
       +A(j,90)%j+A(j,92)%j+A(j,94)%j+A(j,96)%j+A(j,98)%j+A(j,100)%j+A(j,102)%j+A(j,104)%j+A(j,106)%j+A(j,108)%j+A(j,110)%j &
       +A(j,112)%j+A(j,114)%j+A(j,116)%j+A(j,118)%j+A(j,120)%j+A(j,122)%j+A(j,124)%j+A(j,126)%j+A(j,128)%j+A(j,130)%j+A(j,132)%j &
       +A(j,134)%j+A(j,136)%j+A(j,138)%j+A(j,140)%j+A(j,142)%j+A(j,144)%j+A(j,194)%j+A(j,200)%j+A(j,204)%j+A(j,206)%j+A(j,210)%j &
       +A(j,214)%j+A(j,218)%j+A(j,220)%j+A(j,224)%j+A(j,226)%j+A(j,236)%j+A(j,238)%j+A(j,242)%j+A(j,244)%j+A(j,250)%j+A(j,256)%j &
       +A(j,260)%j+A(j,262)%j+A(j,266)%j+A(j,272)%j+A(j,280)%j+A(j,284)%j+A(j,286)%j+A(j,288)%j+A(j,292)%j+A(j,294)%j+A(j,302)%j &
       +A(j,304)%j+A(j,306)%j+A(j,310)%j+A(j,314)%j+A(j,316)%j+A(j,318)%j+A(j,324)%j+A(j,330)%j+A(j,336)%j+A(j,340)%j+A(j,342)%j &
       +A(j,346)%j+A(j,348)%j+A(j,356)%j+A(j,358)%j+A(j,364)%j+A(j,366)%j+A(j,376)%j+A(j,380)%j+A(j,382)%j+A(j,384)%j+A(j,386)%j &
       +A(j,392)%j+A(j,396)%j+A(j,398)%j+A(j,406)%j+A(j,408)%j+A(j,412)%j+A(j,414)%j+A(j,420)%j+A(j,422)%j+A(j,426)%j+A(j,428)%j &
       +A(j,436)%j+A(j,438)%j+A(j,446)%j+A(j,448)%j+A(j,450)%j+A(j,452)%j+A(j,460)%j+A(j,462)%j+A(j,470)%j+A(j,472)%j+A(j,476)%j &
       +A(j,478)%j+A(j,557)%j+A(j,559)%j+A(j,561)%j+A(j,563)%j+A(j,565)%j+A(j,567)%j+A(j,577)%j+A(j,579)%j+A(j,581)%j+A(j,583)%j &
       +A(j,585)%j+A(j,587)%j+A(j,593)%j+A(j,595)%j+A(j,597)%j+A(j,599)%j+A(j,601)%j+A(j,603)%j+A(j,605)%j+A(j,607)%j+A(j,609)%j &
       +A(j,611)%j+A(j,617)%j+A(j,619)%j+A(j,629)%j+A(j,631)%j+A(j,633)%j+A(j,635)%j+A(j,637)%j+A(j,639)%j+A(j,649)%j+A(j,651)%j &
       +A(j,653)%j+A(j,655)%j+A(j,657)%j+A(j,659)%j+A(j,665)%j+A(j,667)%j+A(j,669)%j+A(j,671)%j+A(j,673)%j+A(j,675)%j+A(j,677)%j &
       +A(j,679)%j+A(j,681)%j+A(j,683)%j+A(j,689)%j+A(j,691)%j+A(j,771)%j+A(j,773)%j+A(j,779)%j+A(j,783)%j+A(j,785)%j+A(j,791)%j &
       +A(j,795)%j+A(j,799)%j+A(j,803)%j+A(j,805)%j+A(j,811)%j+A(j,815)%j+A(j,817)%j+A(j,823)%j+A(j,827)%j+A(j,831)%j+A(j,835)%j &
       +A(j,837)%j+A(j,843)%j+A(j,845)%j+A(j,851)%j+A(j,855)%j+A(j,859)%j+A(j,863)%j+A(j,865)%j+A(j,871)%j+A(j,873)%j+A(j,879)%j &
       +A(j,883)%j+A(j,887)%j+A(j,891)%j+A(j,895)%j)*f(2))/2._/**/REALKIND+((A(j,481)%j+A(j,483)%j+A(j,486)%j+A(j,488)%j &
       +A(j,490)%j+A(j,492)%j+A(j,494)%j+A(j,496)%j+A(j,497)%j+A(j,499)%j+A(j,501)%j+A(j,503)%j+A(j,506)%j+A(j,508)%j+A(j,510)%j &
       +A(j,512)%j+A(j,514)%j+A(j,516)%j+A(j,517)%j+A(j,519)%j+A(j,522)%j+A(j,524)%j+A(j,526)%j+A(j,528)%j+A(j,530)%j+A(j,532)%j &
       +A(j,534)%j+A(j,536)%j+A(j,538)%j+A(j,540)%j+A(j,541)%j+A(j,543)%j+A(j,546)%j+A(j,548)%j+A(j,549)%j+A(j,551)%j+A(j,697)%j &
       +A(j,699)%j+A(j,702)%j+A(j,704)%j+A(j,706)%j+A(j,708)%j+A(j,710)%j+A(j,712)%j+A(j,713)%j+A(j,715)%j+A(j,717)%j+A(j,719)%j &
       +A(j,722)%j+A(j,724)%j+A(j,726)%j+A(j,728)%j+A(j,730)%j+A(j,732)%j+A(j,733)%j+A(j,735)%j+A(j,738)%j+A(j,740)%j+A(j,742)%j &
       +A(j,744)%j+A(j,746)%j+A(j,748)%j+A(j,750)%j+A(j,752)%j+A(j,754)%j+A(j,756)%j+A(j,757)%j+A(j,759)%j+A(j,762)%j+A(j,764)%j &
       +A(j,765)%j+A(j,767)%j+A(j,770)%j+A(j,776)%j+A(j,778)%j+A(j,782)%j+A(j,788)%j+A(j,790)%j+A(j,794)%j+A(j,798)%j+A(j,802)%j &
       +A(j,808)%j+A(j,810)%j+A(j,814)%j+A(j,820)%j+A(j,822)%j+A(j,826)%j+A(j,830)%j+A(j,834)%j+A(j,840)%j+A(j,842)%j+A(j,848)%j &
       +A(j,850)%j+A(j,854)%j+A(j,858)%j+A(j,862)%j+A(j,868)%j+A(j,870)%j+A(j,876)%j+A(j,878)%j+A(j,882)%j+A(j,886)%j+A(j,890)%j &
       +A(j,894)%j)*f(3))/6._/**/REALKIND+((A(j,553)%j+A(j,555)%j+A(j,558)%j+A(j,560)%j+A(j,562)%j+A(j,564)%j+A(j,566)%j &
       +A(j,568)%j+A(j,569)%j+A(j,571)%j+A(j,573)%j+A(j,575)%j+A(j,578)%j+A(j,580)%j+A(j,582)%j+A(j,584)%j+A(j,586)%j+A(j,588)%j &
       +A(j,589)%j+A(j,591)%j+A(j,594)%j+A(j,596)%j+A(j,598)%j+A(j,600)%j+A(j,602)%j+A(j,604)%j+A(j,606)%j+A(j,608)%j+A(j,610)%j &
       +A(j,612)%j+A(j,613)%j+A(j,615)%j+A(j,618)%j+A(j,620)%j+A(j,621)%j+A(j,623)%j+A(j,625)%j+A(j,627)%j+A(j,630)%j+A(j,632)%j &
       +A(j,634)%j+A(j,636)%j+A(j,638)%j+A(j,640)%j+A(j,641)%j+A(j,643)%j+A(j,645)%j+A(j,647)%j+A(j,650)%j+A(j,652)%j+A(j,654)%j &
       +A(j,656)%j+A(j,658)%j+A(j,660)%j+A(j,661)%j+A(j,663)%j+A(j,666)%j+A(j,668)%j+A(j,670)%j+A(j,672)%j+A(j,674)%j+A(j,676)%j &
       +A(j,678)%j+A(j,680)%j+A(j,682)%j+A(j,684)%j+A(j,685)%j+A(j,687)%j+A(j,690)%j+A(j,692)%j+A(j,693)%j+A(j,695)%j+A(j,772)%j &
       +A(j,774)%j+A(j,780)%j+A(j,784)%j+A(j,786)%j+A(j,792)%j+A(j,796)%j+A(j,800)%j+A(j,804)%j+A(j,806)%j+A(j,812)%j+A(j,816)%j &
       +A(j,818)%j+A(j,824)%j+A(j,828)%j+A(j,832)%j+A(j,836)%j+A(j,838)%j+A(j,844)%j+A(j,846)%j+A(j,852)%j+A(j,856)%j+A(j,860)%j &
       +A(j,864)%j+A(j,866)%j+A(j,872)%j+A(j,874)%j+A(j,880)%j+A(j,884)%j+A(j,888)%j+A(j,892)%j+A(j,896)%j)*f(3))/2._/**/REALKIND &
       +((A(j,554)%j+A(j,556)%j+A(j,570)%j+A(j,572)%j+A(j,574)%j+A(j,576)%j+A(j,590)%j+A(j,592)%j+A(j,614)%j+A(j,616)%j+A(j,622)%j &
       +A(j,624)%j+A(j,626)%j+A(j,628)%j+A(j,642)%j+A(j,644)%j+A(j,646)%j+A(j,648)%j+A(j,662)%j+A(j,664)%j+A(j,686)%j+A(j,688)%j &
       +A(j,694)%j+A(j,696)%j)*f(4))/2._/**/REALKIND+((A(j,482)%j+A(j,484)%j+A(j,498)%j+A(j,500)%j+A(j,502)%j+A(j,504)%j &
       +A(j,518)%j+A(j,520)%j+A(j,542)%j+A(j,544)%j+A(j,550)%j+A(j,552)%j+A(j,698)%j+A(j,700)%j+A(j,714)%j+A(j,716)%j+A(j,718)%j &
       +A(j,720)%j+A(j,734)%j+A(j,736)%j+A(j,758)%j+A(j,760)%j+A(j,766)%j+A(j,768)%j)*f(4))/6._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllaaj_eexdddxdxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint(0:1-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppllaaj_eexdddxdxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(2), M2(2)
  real(REALKIND),    intent(out) :: M2colint(0:1-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 2*extcomb
    do i = 1, 2
      do j = 1, 2
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppllaaj_eexdddxdxaa_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppllaaj_eexdddxdxaa_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(2,256)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllaaj_eexdddxdxaa_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllaaj_eexdddxdxaa_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllaaj_eexdddxdxaa_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    1, [ (k, k = 0, 1-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllaaj_eexdddxdxaa_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllaaj_eexdddxdxaa_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,8)
  real(REALKIND),  intent(out) :: M2(8)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:1-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(8)
  do J = 1, 8
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 8,extcombs, M2munu)
  do J = 1, 8
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllaaj_eexdddxdxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllaaj_eexdddxdxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllaaj_eexdddxdxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(0:1-1)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(0:1-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllaaj_eexdddxdxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllaaj_eexdddxdxaa_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,8)
  real(c_double), intent(out) :: m2(8)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,8)
  real(DREALKIND) :: f_m2(8)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppllaaj_eexdddxdxaa_1_/**/REALKIND
