
module ol_vamp_1_pplla_ew_eexuuxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplla_ew_eexuuxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplla_ew_eexuuxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplla_ew_eexuuxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplla_ew_eexuuxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplla_ew_eexuuxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplla_ew_eexuuxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[0,nMW,0,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(7),n2h16(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(8),n2h16(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(9),n2h16(8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,2,1,8],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(10),n2h16(9))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,1,2,8,4],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(12),n2h16(10))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,1,4,8,2],[0,0,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(13),n2h16(11))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,1,4,8,2],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(12))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,1,4,8,2],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(13))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(16),n2h16(14))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,1,8,4,2],[0,0,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(17),n2h16(15))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,1,8,4,2],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(16))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,1,8,4,2],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(19),n2h16(17))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex3(:),G1H8(3),ngZu,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex3(:),G1H8(4),ngZu,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_W(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_WA_Q(ntryL,G1H16(6),ex2(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(6),18,0,G2H8(1),n2h8(1))
  call Hloop_AQ_V(ntryL,G1H16(7),ex3(:),G1H8(6),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex3(:),G1H8(7),ngZu,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(9),ex3(:),G1H8(8),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H16(10),ex3(:),G1H8(9),ngZu,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_WQ_A(ntryL,G1H16(11),ex1(:),G1H8(10),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(10),17,0,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G1H16(12),ex1(:),G1H8(10),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(11),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex1(:),G1H8(12),ngZl,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex1(:),G1H8(13),ngZl,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(16),ex1(:),G1H8(14),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G1H16(17),ex1(:),G1H8(15),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(16),ngZl,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H16(19),ex1(:),G1H8(17),ngZl,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(2),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngZl,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZl,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(4),n2h4(4))
  call Hloop_WQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(5),n2h4(5))
  call Hloop_AQ_W(ntryL,G2H8(1),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(7),n2h4(6))
  call Hloop_ZA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),ngZl,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(8),n2h4(7))
  call Hloop_VA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(9),n2h4(8))
  call Hloop_ZA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),ngZl,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(10),n2h4(9))
  call Hloop_QA_W(ntryL,G2H8(2),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_VQ_A(ntryL,G1H8(10),ex3(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(12),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(13),n2h4(11))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex3(:),G1H4(1),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(14),n2h4(12))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex3(:),G1H4(1),ngZu,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(15),n2h4(13))
  call Hloop_VA_Q(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(16),n2h4(14))
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(17),n2h4(15))
  call Hloop_ZA_Q(ntryL,G1H8(16),ex4(:),G1H4(1),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(18),n2h4(16))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex4(:),G1H4(1),ngZu,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(19),n2h4(17))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex2(:),G2H2(2),ngZl,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(3),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_Z(ntryL,G2H4(4),ex2(:),G2H2(4),ngZl,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_W(ntryL,G2H4(5),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_AQ_V(ntryL,G2H4(7),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(8),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H4(9),ex1(:),G2H2(8),ngZl,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_Z(ntryL,G2H4(10),ex1(:),G2H2(9),ngZl,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_QA_V(ntryL,G2H4(12),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_Z(ntryL,G2H4(13),ex4(:),G2H2(11),ngZu,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(14),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(15),ex4(:),G2H2(13),ngZu,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(16),ex3(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_Z(ntryL,G2H4(17),ex3(:),G2H2(15),ngZu,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(18),ex3(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H4(19),ex3(:),G2H2(17),ngZu,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_WQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(18),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_WQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(2),23,0,G2H2(19),n2h2(2))
  call Hloop_WQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(2),23,0,G2H2(20),n2h2(3))
  call Hloop_WA_Q(ntryL,G1H4(7),ex4(:),G1H2(2),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(2),27,0,G2H2(21),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_WA_Q(ntryL,G1H4(11),ex4(:),G1H2(3),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(22),n2h2(5))
  call Hloop_WA_Q(ntryL,G1H4(12),ex4(:),G1H2(3),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(23),n2h2(6))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(3),G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(4),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(3),mass5set(:,3),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,4),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(3),mass5set(:,5),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(3),mass5set(:,6),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(4),mass5set(:,2),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(4),mass5set(:,4),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(4),mass5set(:,3),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(4),mass5set(:,5),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(5),mass5set(:,2),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),2,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(5),mass5set(:,3),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),2,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(5),mass5set(:,4),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),2,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(5),mass5set(:,5),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),2,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(6),mass5set(:,2),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),2,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(6),mass5set(:,3),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),2,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(6),mass5set(:,4),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),2,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(6),mass5set(:,5),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(100),2,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_ZA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),ngZu,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(9),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),ngZu,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_ZA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),ngZu,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(10))
  call Hloop_ZA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),ngZu,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(15),n2h1(11))
  call Hloop_ZA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),ngZu,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(12))
  call Hloop_WA_Q(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(13))
  call Hloop_WA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(14))
  call Hloop_WA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(21),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),ngZu,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),ngZu,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(27),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),ngZu,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(24))
  call Hloop_ZA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),ngZu,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(25))
  call Hloop_ZA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),ngZu,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(26))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),ngZu,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(57),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(58),ex2(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(33),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(62),ex2(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(30))
  call Hloop_ZA_Q(ntryL,G1H2(63),ex2(:),G1H1(1),ngZl,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(31))
  call Hloop_ZA_Q(ntryL,G1H2(64),ex2(:),G1H1(1),ngZl,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(36),n2h1(32))
  call Hloop_ZA_Q(ntryL,G1H2(68),ex2(:),G1H1(1),ngZl,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(69),ex2(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H2(70),ex2(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(39),n2h1(35))
  call Hloop_VA_Q(ntryL,G1H2(74),ex2(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(36))
  call Hloop_ZA_Q(ntryL,G1H2(75),ex2(:),G1H1(1),ngZl,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(37))
  call Hloop_ZA_Q(ntryL,G1H2(76),ex2(:),G1H1(1),ngZl,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(42),n2h1(38))
  call Hloop_ZA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),ngZl,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(81),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(82),ex2(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(45),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(86),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(42))
  call Hloop_ZA_Q(ntryL,G1H2(87),ex2(:),G1H1(1),ngZl,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(43))
  call Hloop_ZA_Q(ntryL,G1H2(88),ex2(:),G1H1(1),ngZl,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(48),n2h1(44))
  call Hloop_ZA_Q(ntryL,G1H2(92),ex2(:),G1H1(1),ngZl,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H2(94),ex2(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(51),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(98),ex2(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(48))
  call Hloop_ZA_Q(ntryL,G1H2(99),ex2(:),G1H1(1),ngZl,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(49))
  call Hloop_ZA_Q(ntryL,G1H2(100),ex2(:),G1H1(1),ngZl,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(54),n2h1(50))
  call Hloop_ZA_Q(ntryL,G1H2(104),ex2(:),G1H1(1),ngZl,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(51))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(3),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,4),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(3),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(3),mass5set(:,6),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(4),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(4),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(4),mass5set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(5),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(5),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(5),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(6),mass5set(:,2),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(6),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),2)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(6),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),2)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(6),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(1),n2h16(18))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,3,8,4],[0,0,nMZ,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(2),n2h16(19))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,3,8,4],[0,0,nMW,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(20))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,3,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(4),n2h16(21))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,3,8,4],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(22))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,3,8,4],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(23))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(9),n2h16(24))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,3,4,8],[0,0,nMZ,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(10),n2h16(25))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,3,4,8],[0,0,nMW,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(11),n2h16(26))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,3,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(12),n2h16(27))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,3,4,8],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(13),n2h16(28))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,3,4,8],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(14),n2h16(29))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,36),heltab2x32(:,:,36))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,39),heltab2x32(:,:,39))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,4,3,8],[0,nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(17),n2h16(30))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,4,3,8],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(18),n2h16(31))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,4,3,8],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,42),heltab2x32(:,:,42))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,4,3,8],[nMW,0,0,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(21),n2h16(32))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,1,2,12],[0,nMZ,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(22),n2h16(33))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,1,2,12],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(23),n2h16(34))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,1,2,12],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(24),n2h16(35))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,49),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,50),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,51),heltab2x32(:,:,51))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(27),n2h16(36))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,2,1,12],[0,nMZ,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(28),n2h16(37))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,2,1,12],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(29),n2h16(38))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,2,1,12],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(30),n2h16(39))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,56),heltab2x32(:,:,56))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,57),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,58),heltab2x32(:,:,58))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,59),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,60),heltab2x32(:,:,60))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[17,2,4,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(1),n2h8(3))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[17,2,4,8],[0,0,0,nMZ],4,1,wf4(:,9))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),ngZl,m3h4x8(:,2),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(2),n2h8(4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[17,2,4,8],[0,nMZ,0,0],4,1,wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,3),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(3),n2h8(5))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[17,2,4,8],[0,nMZ,0,nMZ],4,1,wf4(:,9))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),ngZl,m3h4x8(:,4),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(4),n2h8(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[17,2,8,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(5),n2h8(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[17,2,8,4],[0,0,0,nMZ],4,1,wf4(:,9))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),ngZl,m3h4x8(:,6),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(6),n2h8(8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[17,2,8,4],[0,nMZ,0,0],4,1,wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,7),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(7),n2h8(9))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[17,2,8,4],[0,nMZ,0,nMZ],4,1,wf4(:,9))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),ngZl,m3h4x8(:,8),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(8),n2h8(10))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[17,2,8,4],[0,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(9),n2h8(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[18,1,4,8],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,10),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(10),n2h8(12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[18,1,4,8],[0,0,0,nMZ],4,1,wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngZl,m3h4x8(:,11),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(11),n2h8(13))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[18,1,4,8],[0,nMZ,0,0],4,1,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,12),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(12),n2h8(14))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[18,1,4,8],[0,nMZ,0,nMZ],4,1,wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngZl,m3h4x8(:,13),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(13),n2h8(15))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[18,1,4,8],[0,nMW,0,nMW],4,1,wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,14),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(14),n2h8(16))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[18,1,8,4],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,15),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(15),n2h8(17))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[18,1,8,4],[0,0,0,nMZ],4,1,wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngZl,m3h4x8(:,16),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(16),n2h8(18))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[18,1,8,4],[0,nMZ,0,0],4,1,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,17),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(17),n2h8(19))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[18,1,8,4],[0,nMZ,0,nMZ],4,1,wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngZl,m3h4x8(:,18),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(18),n2h8(20))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[20,2,1,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,19),heltab2x32(:,:,79))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[20,2,1,8],[nMZ,0,0,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZu,m3h4x8(:,20),heltab2x32(:,:,80))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[20,2,1,8],[0,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,21),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[20,2,1,8],[nMZ,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngZu,m3h4x8(:,22),heltab2x32(:,:,82))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[20,1,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,23),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[20,1,2,8],[0,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,24),heltab2x32(:,:,84))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[20,1,2,8],[nMZ,0,0,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(7),ngZu,m3h4x8(:,25),heltab2x32(:,:,85))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[20,1,2,8],[nMZ,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(8),ngZu,m3h4x8(:,26),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[20,1,2,8],[nMW,0,nMW,0],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(9),m3h4x8(:,27),heltab2x32(:,:,87))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[24,2,1,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,28),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[24,2,1,4],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngZu,m3h4x8(:,29),heltab2x32(:,:,89))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[24,2,1,4],[0,0,nMZ,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,30),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[24,2,1,4],[nMZ,0,nMZ,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngZu,m3h4x8(:,31),heltab2x32(:,:,91))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[24,2,1,4],[nMW,0,nMW,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,32),heltab2x32(:,:,92))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[24,1,2,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,33),heltab2x32(:,:,93))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[24,1,2,4],[0,0,nMZ,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,34),heltab2x32(:,:,94))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[24,1,2,4],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(17),ngZu,m3h4x8(:,35),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[24,1,2,4],[nMZ,0,nMZ,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(18),ngZu,m3h4x8(:,36),heltab2x32(:,:,96))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(1),n2h4(20))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,1),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(2),19,0,G2H4(2),n2h4(21))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(5),m3h4x4(:,3),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(5),19,0,G2H4(3),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,4),G1H4(6),ngZu,m3h4x4(:,4),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(6),19,0,G2H4(4),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,4),G1H4(7),ngZu,m3h4x4(:,5),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(7),19,0,G2H4(5),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,4),G1H4(8),ngZd,m3h4x4(:,6),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(8),19,0,G2H4(6),n2h4(25))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,1),G0H4(1),m3h4x4(:,7),heltab2x16(:,:,26))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,4),G0H4(2),m3h4x4(:,8),heltab2x16(:,:,27))
  call Hloop_UW_V(ntryL,G1H16(7),16,wf4(:,1),3,G2H4(7),m3h4x4(:,9),heltab2x16(:,:,28))
  call Hloop_UW_V(ntryL,G1H16(8),16,wf4(:,4),3,G2H4(8),m3h4x4(:,10),heltab2x16(:,:,29))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,1),G1H4(11),m3h4x4(:,11),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(11),19,0,G2H4(9),n2h4(26))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,1),G1H4(12),m3h4x4(:,12),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(12),19,0,G2H4(10),n2h4(27))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(11),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,4),G1H4(2),ngZu,m3h4x4(:,14),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(2),19,0,G2H4(12),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H16(13),wf4(:,4),G1H4(5),ngZu,m3h4x4(:,15),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(13),n2h4(30))
  call Hloop_AZ_Q(ntryL,G1H16(14),wf4(:,4),G1H4(6),ngZd,m3h4x4(:,16),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(6),19,0,G2H4(14),n2h4(31))
  call Hloop_SV_V(ntryL,G0H16(3),wf4(:,1),G0H4(3),m3h4x4(:,17),heltab2x16(:,:,36))
  call Hloop_SV_V(ntryL,G0H16(4),wf4(:,4),G0H4(4),m3h4x4(:,18),heltab2x16(:,:,37))
  call Hloop_UV_W(ntryL,G1H16(15),16,wf4(:,1),3,G2H4(15),m3h4x4(:,19),heltab2x16(:,:,38))
  call Hloop_UV_W(ntryL,G1H16(16),16,wf4(:,4),3,G2H4(16),m3h4x4(:,20),heltab2x16(:,:,39))
  call Hloop_AQ_W(ntryL,G1H16(17),ex3(:),G1H8(19),m3h2x8(:,20),heltab2x16(:,:,40))
  call Hloop_AQ_W(ntryL,G1H16(18),ex3(:),G1H8(20),m3h2x8(:,21),heltab2x16(:,:,41))
  call Hloop_WQ_A(ntryL,G1H16(19),ex3(:),G1H8(21),m3h2x8(:,22),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(1),n2h8(21))
  call Hloop_WQ_A(ntryL,G1H16(20),ex3(:),G1H8(21),m3h2x8(:,23),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(2),n2h8(22))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(21),m3h2x8(:,24),heltab2x16(:,:,44))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(22),ngZl,m3h2x8(:,25),heltab2x16(:,:,45))
  call Hloop_AQ_V(ntryL,G1H16(23),ex1(:),G1H8(23),m3h2x8(:,26),heltab2x16(:,:,46))
  call Hloop_AQ_Z(ntryL,G1H16(24),ex1(:),G1H8(24),ngZl,m3h2x8(:,27),heltab2x16(:,:,47))
  call Hloop_WQ_A(ntryL,G0H16(5),ex1(:),G0H8(19),m3h2x8(:,28),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(25),n2h8(23))
  call Hloop_WQ_A(ntryL,G0H16(6),ex1(:),G0H8(19),m3h2x8(:,29),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(26),n2h8(24))
  call Hloop_WQ_A(ntryL,G1H16(25),ex1(:),G1H8(27),m3h2x8(:,30),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(27),17,0,G2H8(3),n2h8(25))
  call Hloop_WQ_A(ntryL,G1H16(26),ex1(:),G1H8(27),m3h2x8(:,31),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(27),17,0,G2H8(4),n2h8(26))
  call Hloop_QA_V(ntryL,G1H16(27),ex2(:),G1H8(27),m3h2x8(:,32),heltab2x16(:,:,52))
  call Hloop_QA_Z(ntryL,G1H16(28),ex2(:),G1H8(28),ngZl,m3h2x8(:,33),heltab2x16(:,:,53))
  call Hloop_QA_V(ntryL,G1H16(29),ex2(:),G1H8(29),m3h2x8(:,34),heltab2x16(:,:,54))
  call Hloop_QA_Z(ntryL,G1H16(30),ex2(:),G1H8(30),ngZl,m3h2x8(:,35),heltab2x16(:,:,55))
  call Hloop_WA_Q(ntryL,G0H16(7),ex2(:),G0H8(19),m3h2x8(:,36),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(19),18,0,G1H8(31),n2h8(27))
  call Hloop_WA_Q(ntryL,G0H16(8),ex2(:),G0H8(19),m3h2x8(:,37),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(19),18,0,G1H8(32),n2h8(28))
  call Hloop_WA_Q(ntryL,G1H16(31),ex2(:),G1H8(33),m3h2x8(:,38),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(33),18,0,G2H8(5),n2h8(29))
  call Hloop_WA_Q(ntryL,G1H16(32),ex2(:),G1H8(33),m3h2x8(:,39),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(33),18,0,G2H8(6),n2h8(30))
  call Hloop_WQ_A(ntryL,G1H16(33),ex1(:),G1H8(33),m3h2x8(:,40),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(33),17,0,G2H8(7),n2h8(31))
  call Hloop_QA_V(ntryL,G1H8(1),ex2(:),G1H4(7),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_V(ntryL,G1H8(2),ex2(:),G1H4(8),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_Z(ntryL,G1H8(3),ex2(:),G1H4(11),ngZl,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_Z(ntryL,G1H8(4),ex2(:),G1H4(12),ngZl,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_V(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_V(ntryL,G1H8(6),ex2(:),G1H4(2),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_Z(ntryL,G1H8(7),ex2(:),G1H4(5),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_Z(ntryL,G1H8(8),ex2(:),G1H4(6),ngZl,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_W(ntryL,G1H8(9),ex2(:),G1H4(13),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G1H8(10),ex1(:),G1H4(14),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_V(ntryL,G1H8(11),ex1(:),G1H4(15),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H8(12),ex1(:),G1H4(16),ngZl,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H8(13),ex1(:),G1H4(17),ngZl,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(18),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AQ_V(ntryL,G1H8(15),ex1(:),G1H4(19),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G1H8(16),ex1(:),G1H4(20),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_Z(ntryL,G1H8(17),ex1(:),G1H4(21),ngZl,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H8(18),ex1(:),G1H4(22),ngZl,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(5),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G0H4(5),22,0,G1H4(23),n2h4(32))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex2(:),G0H4(5),ngZl,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(5),22,0,G1H4(24),n2h4(33))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(5),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G0H4(5),22,0,G1H4(25),n2h4(34))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(5),ngZl,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(5),22,0,G1H4(26),n2h4(35))
  call Hloop_VQ_A(ntryL,G0H8(5),ex1(:),G0H4(5),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G0H4(5),21,0,G1H4(27),n2h4(36))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(5),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(5),21,0,G1H4(28),n2h4(37))
  call Hloop_ZQ_A(ntryL,G0H8(7),ex1(:),G0H4(5),ngZl,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(5),21,0,G1H4(29),n2h4(38))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex1(:),G0H4(5),ngZl,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(5),21,0,G1H4(30),n2h4(39))
  call Hloop_WQ_A(ntryL,G0H8(9),ex1(:),G0H4(5),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(5),21,0,G1H4(31),n2h4(40))
  call Hloop_VA_Q(ntryL,G0H8(10),ex2(:),G0H4(5),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(32),n2h4(41))
  call Hloop_ZA_Q(ntryL,G0H8(11),ex2(:),G0H4(5),ngZl,m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(33),n2h4(42))
  call Hloop_VA_Q(ntryL,G0H8(12),ex2(:),G0H4(5),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(34),n2h4(43))
  call Hloop_ZA_Q(ntryL,G0H8(13),ex2(:),G0H4(5),ngZl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(35),n2h4(44))
  call Hloop_WA_Q(ntryL,G0H8(14),ex2(:),G0H4(5),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(36),n2h4(45))
  call Hloop_VQ_A(ntryL,G0H8(15),ex1(:),G0H4(5),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G0H4(5),25,0,G1H4(37),n2h4(46))
  call Hloop_VQ_A(ntryL,G0H8(16),ex1(:),G0H4(5),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G0H4(5),25,0,G1H4(38),n2h4(47))
  call Hloop_ZQ_A(ntryL,G0H8(17),ex1(:),G0H4(5),ngZl,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G0H4(5),25,0,G1H4(39),n2h4(48))
  call Hloop_ZQ_A(ntryL,G0H8(18),ex1(:),G0H4(5),ngZl,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(5),25,0,G1H4(40),n2h4(49))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(15),G1H4(4),G0H4(4),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(7),G1H4(10),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(11)])
  call Hloop_WQ_A(ntryL,G1H4(18),ex3(:),G1H2(3),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(1),n2h2(7))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(2),mass4set(:,1),  & 
G1H4(3),G1H4(4),G1H4(9),G1H4(10),G1H4(18),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hloop_WA_Q(ntryL,G1H4(13),ex4(:),G1H2(4),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(4),27,0,G2H2(2),n2h2(8))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(7),mass4set(:,1),  & 
G1H4(13),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(41),4,4)
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(3),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_Z(ntryL,G2H4(5),ex4(:),G2H2(4),ngZu,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_W(ntryL,G2H4(6),ex4(:),G2H2(5),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_V(ntryL,G2H4(12),ex3(:),G2H2(6),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_Z(ntryL,G2H4(13),ex3(:),G2H2(7),ngZu,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_W(ntryL,G2H4(14),ex3(:),G2H2(8),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_UW_V(ntryL,G1H8(19),20,wf4(:,1),3,G2H2(9),m3h4x2(:,1),heltab2x8(:,:,56))
  call Hloop_UW_V(ntryL,G1H8(20),20,wf4(:,4),3,G2H2(10),m3h4x2(:,2),heltab2x8(:,:,57))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(13),mass4set(:,2),  & 
G1H8(33),G1H8(1),G1H8(2),G1H8(3),G1H8(4),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(13),mass4set(:,2),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(45),m3h2x4(:,56),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(45),19,0,G2H4(17),n2h4(50))
  call Hloop_ZA_Q(ntryL,G1H8(22),ex2(:),G1H4(45),ngZl,m3h2x4(:,57),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(45),19,0,G2H4(18),n2h4(51))
  call Hloop_VA_Q(ntryL,G1H8(23),ex2(:),G1H4(45),m3h2x4(:,58),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(45),19,0,G2H4(19),n2h4(52))
  call Hloop_ZA_Q(ntryL,G1H8(24),ex2(:),G1H4(45),ngZl,m3h2x4(:,59),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(45),19,0,G2H4(15),n2h4(53))
  call Hloop_QA_W(ntryL,G1H8(25),ex2(:),G1H4(45),m3h2x4(:,60),heltab2x8(:,:,62))
  call Hloop_QA_W(ntryL,G1H8(26),ex2(:),G1H4(46),m3h2x4(:,61),heltab2x8(:,:,63))
  call Hloop_QA_W(ntryL,G2H8(3),ex2(:),G2H4(7),m3h2x4(:,62),heltab2x8(:,:,64))
  call Hloop_QA_W(ntryL,G2H8(4),ex2(:),G2H4(1),m3h2x4(:,63),heltab2x8(:,:,65))
  call Hloop_VQ_A(ntryL,G1H8(27),ex1(:),G1H4(47),m3h2x4(:,64),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(47),19,0,G2H4(2),n2h4(54))
  call Hloop_ZQ_A(ntryL,G1H8(28),ex1(:),G1H4(47),ngZl,m3h2x4(:,65),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(47),19,0,G2H4(3),n2h4(55))
  call Hloop_VQ_A(ntryL,G1H8(29),ex1(:),G1H4(47),m3h2x4(:,66),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(47),19,0,G2H4(9),n2h4(56))
  call Hloop_ZQ_A(ntryL,G1H8(30),ex1(:),G1H4(47),ngZl,m3h2x4(:,67),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(47),19,0,G2H4(10),n2h4(57))
  call Hloop_AQ_W(ntryL,G1H8(31),ex1(:),G1H4(47),m3h2x4(:,68),heltab2x8(:,:,70))
  call Hloop_AQ_W(ntryL,G1H8(32),ex1(:),G1H4(48),m3h2x4(:,69),heltab2x8(:,:,71))
  call Hloop_AQ_W(ntryL,G2H8(5),ex1(:),G2H4(11),m3h2x4(:,70),heltab2x8(:,:,72))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(16),m3h2x4(:,71),heltab2x8(:,:,73))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(22),mass4set(:,2),  & 
G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(11),2,8)
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(8),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(8),23,0,G2H2(11),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(9),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(9),23,0,G2H2(12),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(11),ex3(:),G1H2(10),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(10),23,0,G2H2(13),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex3(:),G1H2(14),ngZu,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(14),23,0,G2H2(14),n2h2(12))
  call Hloop_VA_Q(ntryL,G1H4(1),ex4(:),G1H2(15),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(15),27,0,G2H2(15),n2h2(13))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(16),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(16),27,0,G2H2(16),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex4(:),G1H2(20),ngZu,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(20),27,0,G2H2(17),n2h2(15))
  call Hloop_ZA_Q(ntryL,G1H4(6),ex4(:),G1H2(21),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(21),27,0,G2H2(18),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(22),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(22),23,0,G2H2(20),n2h2(17))
  call Hloop_VQ_A(ntryL,G1H4(15),ex3(:),G1H2(26),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(21),n2h2(18))
  call Hloop_ZQ_A(ntryL,G1H4(16),ex3(:),G1H2(27),ngZu,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(27),23,0,G2H2(23),n2h2(19))
  call Hloop_ZQ_A(ntryL,G1H4(17),ex3(:),G1H2(28),ngZu,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(28),23,0,G2H2(24),n2h2(20))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(32),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(32),27,0,G2H2(25),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(33),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(33),27,0,G2H2(26),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(21),ex4(:),G1H2(34),ngZu,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(34),27,0,G2H2(27),n2h2(23))
  call Hloop_ZA_Q(ntryL,G1H4(22),ex4(:),G1H2(38),ngZu,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(38),27,0,G2H2(28),n2h2(24))
  call Hloop_AQ_V(ntryL,G1H4(23),ex1(:),G1H2(39),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_V(ntryL,G1H4(24),ex1(:),G1H2(40),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_Z(ntryL,G1H4(25),ex1(:),G1H2(44),ngZl,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H4(26),ex1(:),G1H2(45),ngZl,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_QA_V(ntryL,G1H4(27),ex2(:),G1H2(46),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QA_Z(ntryL,G1H4(28),ex2(:),G1H2(50),ngZl,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_QA_V(ntryL,G1H4(29),ex2(:),G1H2(51),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_QA_Z(ntryL,G1H4(30),ex2(:),G1H2(52),ngZl,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_W(ntryL,G1H4(31),ex2(:),G1H2(56),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_AQ_V(ntryL,G1H4(32),ex1(:),G1H2(57),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AQ_V(ntryL,G1H4(33),ex1(:),G1H2(58),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AQ_Z(ntryL,G1H4(34),ex1(:),G1H2(62),ngZl,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H4(35),ex1(:),G1H2(63),ngZl,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_AQ_W(ntryL,G1H4(36),ex1(:),G1H2(64),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_QA_V(ntryL,G1H4(37),ex2(:),G1H2(68),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QA_Z(ntryL,G1H4(38),ex2(:),G1H2(69),ngZl,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_QA_V(ntryL,G1H4(39),ex2(:),G1H2(70),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QA_Z(ntryL,G1H4(40),ex2(:),G1H2(74),ngZl,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_WQ_A(ntryL,G1H4(3),ex3(:),G1H2(75),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(75),23,0,G2H2(29),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(4),ex4(:),G1H2(76),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_WQ_A(ntryL,G1H4(10),ex3(:),G1H2(80),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(80),23,0,G2H2(30),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(18),ex3(:),G1H2(81),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(81),23,0,G2H2(31),n2h2(27))
  call Hloop_WA_Q(ntryL,G1H4(13),ex4(:),G1H2(82),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(82),27,0,G2H2(32),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(41),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(41),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(41),ex3(:),G1H2(86),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_WA_Q(ntryL,G1H4(43),ex4(:),G1H2(87),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(87),27,0,G2H2(33),n2h2(29))
  call Hloop_WA_Q(ntryL,G1H4(44),ex4(:),G1H2(88),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(88),27,0,G2H2(34),n2h2(30))
  call Hloop_QV_A(ntryL,G1H8(33),wf4(:,1),G1H2(92),m3h4x2(:,3),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(92),23,0,G2H2(35),n2h2(31))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(1),ex4(:),G1H4(7),m3h2x4(:,72),heltab2x8(:,:,75))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,1),G1H2(93),m3h4x2(:,4),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(93),23,0,G2H2(36),n2h2(32))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,1),G1H2(94),m3h4x2(:,5),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(94),23,0,G2H2(37),n2h2(33))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,4),G1H2(98),ngZd,m3h4x2(:,6),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(98),23,0,G2H2(38),n2h2(34))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(6),ex4(:),G1H4(8),m3h2x4(:,73),heltab2x8(:,:,79))
  call Hloop_QZ_A(ntryL,G1H8(8),wf4(:,4),G1H2(99),ngZd,m3h4x2(:,7),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(99),23,0,G2H2(39),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H8(9),wf4(:,4),G1H2(100),ngZd,m3h4x2(:,8),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(100),23,0,G2H2(40),n2h2(36))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,10),G1H2(104),ngZn,m3h4x2(:,9),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(104),29,0,G2H2(41),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(11),ex2(:),G1H4(11),m3h2x4(:,74),heltab2x8(:,:,83))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,10),G1H2(3),ngZn,m3h4x2(:,10),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(3),29,0,G2H2(42),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,10),G1H2(4),ngZn,m3h4x2(:,11),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(43),n2h2(39))
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(56),[G1H2(29)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(49),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(55),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(9),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(97),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(103),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(37)])
  call Hloop_WQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(52))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(3),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hloop_WA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(53))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(8),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(55))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(56))
  call Hloop_ZA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(57))
  call Hloop_ZA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),ngZu,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(58))
  call Hloop_ZA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),ngZu,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(59))
  call Hloop_VA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(61))
  call Hloop_ZA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(62))
  call Hloop_ZA_Q(ntryL,G1H2(55),ex4(:),G1H1(1),ngZu,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(63))
  call Hloop_WA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(64))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(13),mass4set(:,3),  & 
G1H2(8),G1H2(9),G1H2(10),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(9),8,2)
  call Hloop_VA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(67))
  call Hloop_ZA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(68))
  call Hloop_ZA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),ngZu,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(69))
  call Hloop_ZA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),ngZu,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H2(59),ex2(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(58),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(72),ex2(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(85),ex2(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(73))
  call Hloop_ZA_Q(ntryL,G1H2(65),ex2(:),G1H1(1),ngZl,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(74))
  call Hloop_ZA_Q(ntryL,G1H2(78),ex2(:),G1H1(1),ngZl,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(75))
  call Hloop_ZA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),ngZl,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(97),ex2(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(78))
  call Hloop_ZA_Q(ntryL,G1H2(77),ex2(:),G1H1(1),ngZl,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(79))
  call Hloop_ZA_Q(ntryL,G1H2(103),ex2(:),G1H1(1),ngZl,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(83),ex2(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(96),ex2(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(82))
  call Hloop_ZA_Q(ntryL,G1H2(89),ex2(:),G1H1(1),ngZl,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(83))
  call Hloop_ZA_Q(ntryL,G1H2(102),ex2(:),G1H1(1),ngZl,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(95),ex2(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(85))
  call Hloop_ZA_Q(ntryL,G1H2(101),ex2(:),G1H1(1),ngZl,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(86))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(74),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(75),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(7),mass4set(:,4),  & 
G1H2(16),G1H2(20),G1H2(21),G1H2(22),G1H2(26),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(7),mass4set(:,5),  & 
G1H2(27),G1H2(28),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(28),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,6),  & 
G1H2(38),G1H2(75),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(75),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(2),mass4set(:,4),  & 
G1H2(87),G1H2(88),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(88),8,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(2),mass4set(:,5),  & 
G1H2(98),G1H2(99),G1H2(100),G1H2(104),G1H2(3),2)
  call HG1shiftOLR(G1H2(99),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(2),mass4set(:,6),  & 
G1H2(4),G1H2(64),G1H2(29),G1H2(56),G1H2(5),2)
  call HG1shiftOLR(G1H2(64),8,2)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(9),mass4set(:,4),  & 
G1H4(12),G1H4(1),G1H4(2),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(1),12,4)
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(9),mass4set(:,7),  & 
G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(19),4)
  call HG1shiftOLR(G1H4(15),12,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(9),mass4set(:,4),  & 
G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(21),12,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(9),mass4set(:,7),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),4)
  call HG1shiftOLR(G1H4(26),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(45),wf4(:,8),G1tensor(1),m3h4x1(:,1),heltab2x4(:,:,76))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(46),wf4(:,10),G1tensor(7),m3h4x1(:,2),heltab2x4(:,:,77))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(9),mass4set(:,8),  & 
G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(31),12,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(9),mass4set(:,8),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),4)
  call HG1shiftOLR(G1H4(36),12,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(4),mass4set(:,4),  & 
G1H4(40),G1H4(3),G1H4(4),G1H4(10),G1H4(18),4)
  call HG1shiftOLR(G1H4(3),12,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(4),mass4set(:,7),  & 
G1H4(13),G1H4(41),G1H4(43),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(41),12,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(4),mass4set(:,4),  & 
G1H4(46),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(49),12,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(4),mass4set(:,7),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),4)
  call HG1shiftOLR(G1H4(54),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(47),wf4(:,8),G1tensor(13),m3h4x1(:,3),heltab2x4(:,:,78))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(48),wf4(:,10),G1tensor(19),m3h4x1(:,4),heltab2x4(:,:,79))
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(4),mass4set(:,8),  & 
G1H4(47),G1H4(48),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(48),12,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(4),mass4set(:,8),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),4)
  call HG1shiftOLR(G1H4(62),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(76),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(77),ngZu,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(78),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(79),ngZu,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(80),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(81),ngZu,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(82),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(83),ngZu,m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(84),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(85),ngZu,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(86),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(87),ngZu,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex3(:),G2tensor(88),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(89),ngZu,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(90),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(91),ngZu,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hloop_VQ_A(ntryL,G1H2(57),ex3(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(88))
  call Hloop_ZQ_A(ntryL,G1H2(62),ex3(:),G1H1(1),ngZu,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(94),n2h1(89))
  call Hloop_ZQ_A(ntryL,G1H2(63),ex3(:),G1H1(1),ngZu,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(96),n2h1(91))
  call Hloop_ZQ_A(ntryL,G1H2(69),ex3(:),G1H1(1),ngZu,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(93))
  call Hloop_ZQ_A(ntryL,G1H2(74),ex3(:),G1H1(1),ngZu,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(94))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(100),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(101),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(32),ex3(:),G2tensor(102),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(34),ex3(:),G2tensor(103),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(104),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(105),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(41),ex2(:),G2tensor(106),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(43),ex2(:),G2tensor(107),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hloop_WA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(108),n2h1(95))
  call Hloop_WA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(109),n2h1(96))
  call Hloop_WA_Q(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(97))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(98))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(112),n2h1(99))
  call Hloop_VQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(100))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),ngZu,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(114),n2h1(101))
  call Hloop_ZQ_A(ntryL,G1H2(28),ex3(:),G1H1(1),ngZu,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(115),n2h1(102))
  call Hloop_ZQ_A(ntryL,G1H2(34),ex3(:),G1H1(1),ngZu,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(116),n2h1(103))
  call Hloop_WQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(104))
  call Hloop_WQ_A(ntryL,G1H2(75),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(118),n2h1(105))
  call Hloop_WQ_A(ntryL,G1H2(82),ex3(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(121),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H2(94),ex4(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(109))
  call Hloop_ZA_Q(ntryL,G1H2(98),ex4(:),G1H1(1),ngZu,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(110))
  call Hloop_ZA_Q(ntryL,G1H2(99),ex4(:),G1H1(1),ngZu,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(124),n2h1(111))
  call Hloop_ZA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),ngZu,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(112))
  call Hloop_WA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(126),n2h1(113))
  call Hloop_WA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(127),n2h1(114))
  call Hloop_WA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H4(12),wf4(:,8),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H4(1),wf4(:,8),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(130),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,8),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,8),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,8),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(133),n2h1(120))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,8),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(121))
  call Hloop_AZ_Q(ntryL,G1H4(20),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,11),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(122))
  call Hloop_AZ_Q(ntryL,G1H4(21),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,12),heltab2x4(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(136),n2h1(123))
  call Hloop_AZ_Q(ntryL,G1H4(24),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,13),heltab2x4(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(124))
  call Hloop_AZ_Q(ntryL,G1H4(25),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,14),heltab2x4(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(125))
  call Hloop_AZ_Q(ntryL,G1H4(26),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,15),heltab2x4(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(139),n2h1(126))
  call Hloop_AZ_Q(ntryL,G1H4(29),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,16),heltab2x4(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(127))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(30),19,wf4(:,8),12,G2tensor(141),m3h4x1(:,17),heltab2x4(:,:,92))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(31),0,wf4(:,8),12,G2tensor(142),m3h4x1(:,18),heltab2x4(:,:,93))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(34),19,wf4(:,8),12,G2tensor(143),m3h4x1(:,19),heltab2x4(:,:,94))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(35),19,wf4(:,10),12,G2tensor(144),m3h4x1(:,20),heltab2x4(:,:,95))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(36),0,wf4(:,10),12,G2tensor(145),m3h4x1(:,21),heltab2x4(:,:,96))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(39),19,wf4(:,10),12,G2tensor(146),m3h4x1(:,22),heltab2x4(:,:,97))
  call Hloop_QV_A(ntryL,G1H4(40),wf4(:,8),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(130))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,8),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(148),n2h1(131))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,8),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(132))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,8),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(133))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,8),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(151),n2h1(134))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,8),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(152),n2h1(135))
  call Hloop_QZ_A(ntryL,G1H4(46),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,29),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(136))
  call Hloop_QZ_A(ntryL,G1H4(49),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,30),heltab2x4(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(154),n2h1(137))
  call Hloop_QZ_A(ntryL,G1H4(52),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(155),n2h1(138))
  call Hloop_QZ_A(ntryL,G1H4(53),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,32),heltab2x4(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(156),n2h1(139))
  call Hloop_QZ_A(ntryL,G1H4(54),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,33),heltab2x4(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(157),n2h1(140))
  call Hloop_QZ_A(ntryL,G1H4(57),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,34),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(158),n2h1(141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(47),19,wf4(:,8),12,G2tensor(159),m3h4x1(:,35),heltab2x4(:,:,110))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),0,wf4(:,8),12,G2tensor(160),m3h4x1(:,36),heltab2x4(:,:,111))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(60),19,wf4(:,8),12,G2tensor(161),m3h4x1(:,37),heltab2x4(:,:,112))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(61),19,wf4(:,10),12,G2tensor(162),m3h4x1(:,38),heltab2x4(:,:,113))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(62),0,wf4(:,10),12,G2tensor(163),m3h4x1(:,39),heltab2x4(:,:,114))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(65),19,wf4(:,10),12,G2tensor(164),m3h4x1(:,40),heltab2x4(:,:,115))
  call ol_merge_tensors(G2tensor(162),[G2tensor(159),G2tensor(2),G1tensor(19),G1tensor(13),G1tensor(6)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(141),G2tensor(4),G1tensor(7),G1tensor(1),G1tensor(12)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(7),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(13),G1tensor(36),G1tensor(30)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(22),G1tensor(60),G1tensor(48)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(25),G1tensor(66),G1tensor(54)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(33),G1tensor(68)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(34),G1tensor(78),G1tensor(72)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(36),G1tensor(74)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(39),G1tensor(80)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(40),G1tensor(90),G1tensor(84)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(42),G1tensor(86)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(45),G1tensor(92)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(46),G1tensor(102),G1tensor(96)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(48),G1tensor(98)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(51),G1tensor(104)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(52),G1tensor(114),G1tensor(108)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(54),G1tensor(110)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(39),G1tensor(8)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(28),G1tensor(16)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(47),G1tensor(17)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(59),G1tensor(23)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(53),G1tensor(29)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(65),G1tensor(35)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(52),G1tensor(46)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(64),G1tensor(58)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(82),G1tensor(70)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(95),G1tensor(71)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(88),G1tensor(76)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(101),G1tensor(77)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(107),G1tensor(83)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(113),G1tensor(89)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(106),G1tensor(94)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(112),G1tensor(100)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(129)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(132)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(147)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(150)])
  call Hotf_4pt_reduction_last(G2tensor(162),RedSet_4(4),mass4set(:,8),  & 
G1tensor(25),G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49))
  call G_TensorShift(G1tensor(31),12)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(9),mass4set(:,8),  & 
G1tensor(55),G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79))
  call G_TensorShift(G1tensor(61),12)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(29),mass4set(:,4),  & 
G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109))
  call G_TensorShift(G1tensor(91),2)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(14),mass4set(:,4),  & 
G1tensor(19),G1tensor(13),G1tensor(6),G1tensor(7),G1tensor(1))
  call G_TensorShift(G1tensor(13),10)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(29),mass4set(:,9),  & 
G1tensor(12),G1tensor(14),G1tensor(24),G1tensor(18),G1tensor(20))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(29),mass4set(:,7),  & 
G1tensor(26),G1tensor(36),G1tensor(30),G1tensor(32),G1tensor(38))
  call G_TensorShift(G1tensor(36),2)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(14),mass4set(:,7),  & 
G1tensor(42),G1tensor(44),G1tensor(60),G1tensor(48),G1tensor(50))
  call G_TensorShift(G1tensor(44),10)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(29),mass4set(:,10),  & 
G1tensor(66),G1tensor(54),G1tensor(56),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(54),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(29),mass4set(:,11),  & 
G1tensor(78),G1tensor(72),G1tensor(74),G1tensor(80),G1tensor(90))
  call G_TensorShift(G1tensor(72),2)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(14),mass4set(:,12),  & 
G1tensor(84),G1tensor(86),G1tensor(92),G1tensor(102),G1tensor(96))
  call G_TensorShift(G1tensor(86),10)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(30),mass4set(:,4),  & 
G1tensor(98),G1tensor(104),G1tensor(114),G1tensor(108),G1tensor(110))
  call G_TensorShift(G1tensor(104),1)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(18),mass4set(:,4),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(39))
  call G_TensorShift(G1tensor(3),9)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(30),mass4set(:,7),  & 
G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(15))
  call G_TensorShift(G1tensor(9),1)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(18),mass4set(:,7),  & 
G1tensor(28),G1tensor(16),G1tensor(47),G1tensor(17),G1tensor(21))
  call G_TensorShift(G1tensor(16),9)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(30),mass4set(:,9),  & 
G1tensor(34),G1tensor(22),G1tensor(59),G1tensor(23),G1tensor(27))
  call G_TensorShift(G1tensor(22),1)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(30),mass4set(:,10),  & 
G1tensor(53),G1tensor(29),G1tensor(33),G1tensor(65),G1tensor(35))
  call G_TensorShift(G1tensor(29),1)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(1),mass4set(:,4),  & 
G1tensor(40),G1tensor(41),G1tensor(45),G1tensor(52),G1tensor(46))
  call G_TensorShift(G1tensor(41),8)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(23),mass4set(:,4),  & 
G1tensor(51),G1tensor(57),G1tensor(64),G1tensor(58),G1tensor(63))
  call G_TensorShift(G1tensor(57),10)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(1),mass4set(:,9),  & 
G1tensor(69),G1tensor(82),G1tensor(70),G1tensor(95),G1tensor(71))
  call G_TensorShift(G1tensor(82),8)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(1),mass4set(:,7),  & 
G1tensor(75),G1tensor(88),G1tensor(76),G1tensor(101),G1tensor(77))
  call G_TensorShift(G1tensor(88),8)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(23),mass4set(:,7),  & 
G1tensor(81),G1tensor(107),G1tensor(83),G1tensor(87),G1tensor(113))
  call G_TensorShift(G1tensor(107),10)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(1),mass4set(:,10),  & 
G1tensor(89),G1tensor(93),G1tensor(106),G1tensor(94),G1tensor(99))
  call G_TensorShift(G1tensor(93),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(31),mass4set(:,4),  & 
G1tensor(112),G1tensor(100),G1tensor(105),G1tensor(111),G1tensor(115))
  call G_TensorShift(G1tensor(100),4)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(27),mass4set(:,4),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),6)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(31),mass4set(:,9),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(31),mass4set(:,7),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),4)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(27),mass4set(:,7),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),6)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(31),mass4set(:,10),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),4)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(32),mass4set(:,13),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),4)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(1),mass4set(:,11),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(2),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,2),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(11),mass4set(:,13),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),8)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(6),mass4set(:,11),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),4)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(7),mass4set(:,1),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(8),mass4set(:,2),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(11),mass4set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(12),mass4set(:,4),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),8)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(13),mass4set(:,4),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(11),mass4set(:,5),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(12),mass4set(:,5),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(13),mass4set(:,5),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),8)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(11),mass4set(:,14),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(13),mass4set(:,7),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(11),mass4set(:,15),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),8)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(13),mass4set(:,16),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),8)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(12),mass4set(:,6),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),8)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(13),mass4set(:,3),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),8)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(16),mass4set(:,4),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(17),mass4set(:,4),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(16),mass4set(:,14),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(16),mass4set(:,5),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(17),mass4set(:,5),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),8)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(16),mass4set(:,15),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),8)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(20),mass4set(:,4),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),2)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(21),mass4set(:,4),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),2)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(22),mass4set(:,4),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),2)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(20),mass4set(:,5),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),2)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(21),mass4set(:,5),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),2)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(22),mass4set(:,5),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),2)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(20),mass4set(:,14),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),2)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(22),mass4set(:,7),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),2)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(20),mass4set(:,15),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),2)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(22),mass4set(:,16),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),2)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(25),mass4set(:,4),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),2)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(26),mass4set(:,4),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),2)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(25),mass4set(:,5),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(332),2)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(26),mass4set(:,5),  & 
G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340))
  call G_TensorShift(G1tensor(337),2)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(25),mass4set(:,14),  & 
G1tensor(341),G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(342),2)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(25),mass4set(:,15),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),2)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(33),mass4set(:,4),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),8)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(33),mass4set(:,9),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),8)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(33),mass4set(:,7),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),8)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(33),mass4set(:,10),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),8)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(6),mass4set(:,4),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),4)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(6),mass4set(:,9),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),4)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(6),mass4set(:,7),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),4)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(6),mass4set(:,10),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),4)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(32),mass4set(:,4),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(32),mass4set(:,14),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),4)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(32),mass4set(:,5),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),4)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(32),mass4set(:,15),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),4)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(34),mass4set(:,4),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(34),mass4set(:,5),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),4)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(34),mass4set(:,14),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),4)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(34),mass4set(:,15),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),4)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(13),mass4set(:,2),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),8)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(22),mass4set(:,2),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),2)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(7),mass4set(:,4),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),4)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(7),mass4set(:,5),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),4)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(7),mass4set(:,6),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),4)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(2),mass4set(:,4),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),8)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(2),mass4set(:,5),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),8)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(2),mass4set(:,6),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),8)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(9),mass4set(:,4),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),12)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(9),mass4set(:,7),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),12)
  call Hotf_4pt_reduction_last(G2tensor(153),RedSet_4(4),mass4set(:,4),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),12)
  call Hotf_4pt_reduction_last(G2tensor(156),RedSet_4(4),mass4set(:,7),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),12)
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(4),mass4set(:,8),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(9),mass4set(:,8),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(85),RedSet_4(29),mass4set(:,4),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(19),RedSet_4(14),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(29),mass4set(:,9),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(29),mass4set(:,7),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(14),mass4set(:,7),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(29),mass4set(:,10),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(29),mass4set(:,11),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(14),mass4set(:,12),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(30),mass4set(:,4),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(18),mass4set(:,4),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(30),mass4set(:,7),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(18),mass4set(:,7),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(30),mass4set(:,9),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(30),mass4set(:,10),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(1),mass4set(:,4),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(23),mass4set(:,4),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(1),mass4set(:,9),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(75),RedSet_4(1),mass4set(:,7),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(23),mass4set(:,7),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(89),RedSet_4(1),mass4set(:,10),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(112),RedSet_4(31),mass4set(:,4),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(27),mass4set(:,4),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(31),mass4set(:,9),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(31),mass4set(:,7),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(27),mass4set(:,7),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(31),mass4set(:,10),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(32),mass4set(:,13),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(1),mass4set(:,11),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(2),mass4set(:,1),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(3),mass4set(:,2),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(11),mass4set(:,13),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(6),mass4set(:,11),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(7),mass4set(:,1),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(8),mass4set(:,2),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(11),mass4set(:,4),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(12),mass4set(:,4),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(13),mass4set(:,4),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(11),mass4set(:,5),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(12),mass4set(:,5),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(13),mass4set(:,5),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(11),mass4set(:,14),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(13),mass4set(:,7),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(11),mass4set(:,15),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(13),mass4set(:,16),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(12),mass4set(:,6),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(13),mass4set(:,3),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(16),mass4set(:,4),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(17),mass4set(:,4),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(16),mass4set(:,14),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(16),mass4set(:,5),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(17),mass4set(:,5),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(16),mass4set(:,15),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(20),mass4set(:,4),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(21),mass4set(:,4),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(22),mass4set(:,4),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(20),mass4set(:,5),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(21),mass4set(:,5),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(22),mass4set(:,5),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(20),mass4set(:,14),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(22),mass4set(:,7),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(20),mass4set(:,15),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(22),mass4set(:,16),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(25),mass4set(:,4),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(26),mass4set(:,4),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(25),mass4set(:,5),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(26),mass4set(:,5),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(25),mass4set(:,14),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(25),mass4set(:,15),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(33),mass4set(:,4),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(33),mass4set(:,9),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(33),mass4set(:,7),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(33),mass4set(:,10),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(6),mass4set(:,4),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(6),mass4set(:,9),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(6),mass4set(:,7),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(6),mass4set(:,10),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(32),mass4set(:,4),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(32),mass4set(:,14),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(32),mass4set(:,5),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(32),mass4set(:,15),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(34),mass4set(:,4),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(34),mass4set(:,5),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(34),mass4set(:,14),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(34),mass4set(:,15),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(13),mass4set(:,2),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(22),mass4set(:,2),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(7),mass4set(:,4),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(7),mass4set(:,5),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(7),mass4set(:,6),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(2),mass4set(:,4),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(2),mass4set(:,5),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(2),mass4set(:,6),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(9),mass4set(:,4),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(9),mass4set(:,7),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(4),mass4set(:,4),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(4),mass4set(:,7),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[19,4,8],[nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(5),m4h2x4x4(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[19,4,8],[nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,4),G0H4(4),m4h2x4x4(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[28,1,2],[nMW,0,nMW],4,1,wf4(:,8))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(3),m4h2x4x4(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[28,1,2],[nMW,0,nMW],4,1,wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,10),G0H4(2),m4h2x4x4(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(40))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,62),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMM,G1H16(2),n2h16(41))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,63),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(3),16,nML,G1H16(3),n2h16(42))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,64),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H16(4),16,0,G1H16(4),n2h16(43))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,65),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMM,G1H16(5),n2h16(44))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,66),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H16(6),16,nML,G1H16(6),n2h16(45))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,67),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(7),n2h16(46))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,68),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(8),16,nMT,G1H16(8),n2h16(47))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(9),n2h16(48))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,70),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(10),n2h16(49))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,71),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(11),n2h16(50))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,72),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(12),n2h16(51))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,73),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(13),n2h16(52))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,74),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMB,G1H16(14),n2h16(53))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,75),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(15),n2h16(54))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,76),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(8),16,nMM,G1H16(16),n2h16(55))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),16,nML,G1H16(17),n2h16(56))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,78),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(18),n2h16(57))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,79),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMM,G1H16(19),n2h16(58))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,80),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G0H16(4),16,nML,G1H16(20),n2h16(59))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,81),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(21),n2h16(60))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,82),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(6),16,nMT,G1H16(22),n2h16(61))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,83),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(23),n2h16(62))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,84),heltab2x32(:,:,120))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMT,G1H16(24),n2h16(63))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(25),n2h16(64))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,86),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(26),n2h16(65))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,87),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(27),n2h16(66))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,88),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMB,G1H16(28),n2h16(67))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,89),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(29),n2h16(68))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,90),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(6),16,nMM,G1H16(30),n2h16(69))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,91),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(7),16,nML,G1H16(31),n2h16(70))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,92),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(8),16,0,G1H16(32),n2h16(71))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMM,G1H16(33),n2h16(72))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,94),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G0H16(2),16,nML,G1H16(34),n2h16(73))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,95),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(35),n2h16(74))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,96),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMT,G1H16(36),n2h16(75))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,97),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(37),n2h16(76))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,98),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMT,G1H16(38),n2h16(77))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,99),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(39),n2h16(78))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,100),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(8),16,nMB,G1H16(40),n2h16(79))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(41),n2h16(80))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,102),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMB,G1H16(42),n2h16(81))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,103),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(43),n2h16(82))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,104),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMM,G1H16(44),n2h16(83))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,105),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(5),16,nML,G1H16(45),n2h16(84))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,106),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(6),16,0,G1H16(46),n2h16(85))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,107),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(7),16,nMM,G1H16(47),n2h16(86))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,108),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(8),16,nML,G1H16(48),n2h16(87))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(49),n2h16(88))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,110),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(50),n2h16(89))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,111),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(51),n2h16(90))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,112),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMT,G1H16(52),n2h16(91))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,113),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(53),n2h16(92))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,114),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(6),16,nMB,G1H16(54),n2h16(93))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,3,12],[0,0,0],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,115),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(55),n2h16(94))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,116),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMB,G1H16(56),n2h16(95))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,117),heltab2x32(:,:,153))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,118),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,119),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,120),heltab2x32(:,:,156))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,121),heltab2x32(:,:,157))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,122),heltab2x32(:,:,158))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,123),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,124),heltab2x32(:,:,160))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(65),m3h2x16(:,125),heltab2x32(:,:,161))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,126),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(67),m3h2x16(:,127),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,128),heltab2x32(:,:,164))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(69),m3h2x16(:,129),heltab2x32(:,:,165))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,130),heltab2x32(:,:,166))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(71),m3h2x16(:,131),heltab2x32(:,:,167))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,132),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(73),m3h2x16(:,133),heltab2x32(:,:,169))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,134),heltab2x32(:,:,170))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(75),m3h2x16(:,135),heltab2x32(:,:,171))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(76),m3h2x16(:,136),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(77),m3h2x16(:,137),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,138),heltab2x32(:,:,174))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(79),m3h2x16(:,139),heltab2x32(:,:,175))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,140),heltab2x32(:,:,176))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,141),heltab2x32(:,:,177))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(82),m3h2x16(:,142),heltab2x32(:,:,178))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(83),m3h2x16(:,143),heltab2x32(:,:,179))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(84),m3h2x16(:,144),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(85),m3h2x16(:,145),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(86),m3h2x16(:,146),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,147),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,148),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,149),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,150),heltab2x32(:,:,186))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,151),heltab2x32(:,:,187))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(92),m3h2x16(:,152),heltab2x32(:,:,188))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,153),heltab2x32(:,:,189))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,154),heltab2x32(:,:,190))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,155),heltab2x32(:,:,191))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(96),m3h2x16(:,156),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,157),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,158),heltab2x32(:,:,194))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,159),heltab2x32(:,:,195))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,160),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,161),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,162),heltab2x32(:,:,198))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,163),heltab2x32(:,:,199))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,164),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,165),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,166),heltab2x32(:,:,202))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,167),heltab2x32(:,:,203))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,168),heltab2x32(:,:,204))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,169),heltab2x32(:,:,205))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,170),heltab2x32(:,:,206))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,171),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,172),heltab2x32(:,:,208))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,173),heltab2x32(:,:,209))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,174),heltab2x32(:,:,210))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,175),heltab2x32(:,:,211))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,176),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,177),heltab2x32(:,:,213))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,178),heltab2x32(:,:,214))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,179),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,180),heltab2x32(:,:,216))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,181),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,182),heltab2x32(:,:,218))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,183),heltab2x32(:,:,219))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,184),heltab2x32(:,:,220))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,185),heltab2x32(:,:,221))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,186),heltab2x32(:,:,222))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,187),heltab2x32(:,:,223))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,188),heltab2x32(:,:,224))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,189),heltab2x32(:,:,225))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(98),m3h2x16(:,190),heltab2x32(:,:,226))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,191),heltab2x32(:,:,227))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,192),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,193),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,194),heltab2x32(:,:,230))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,195),heltab2x32(:,:,231))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,196),heltab2x32(:,:,232))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(19),m3h4x8(:,37),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G0H8(19),20,0,G1H8(15),n2h8(35))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[20,3,8],[0,0,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZu,m3h4x8(:,38),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(16),n2h8(36))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[20,3,8],[0,0,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,39),heltab2x32(:,:,235))
  call Hloop_Q_A(ntryL,G0H8(2),20,0,G1H8(17),n2h8(37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,40),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H8(3),20,0,G1H8(18),n2h8(38))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[20,3,8],[0,0,nMZ],3,2,wf4(:,3),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngZu,m3h4x8(:,41),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G0H8(4),20,0,G1H8(19),n2h8(39))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[20,3,8],[0,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,42),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H8(5),20,0,G1H8(20),n2h8(40))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[20,3,8],[nMW,nMW,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,43),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[20,3,8],[nMW,nMW,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,44),heltab2x32(:,:,240))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[24,3,4],[0,0,0],3,2,wf4(:,6),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,45),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H8(8),24,0,G1H8(21),n2h8(41))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[24,3,4],[0,0,nMZ],3,2,wf4(:,6),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(9),ngZu,m3h4x8(:,46),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H8(9),24,0,G1H8(22),n2h8(42))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[24,3,4],[0,0,nMW],3,2,wf4(:,6),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,47),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H8(10),24,0,G1H8(23),n2h8(43))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[24,3,4],[0,0,0],3,2,wf4(:,6),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,48),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H8(11),24,0,G1H8(24),n2h8(44))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[24,3,4],[0,0,nMZ],3,2,wf4(:,6),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngZu,m3h4x8(:,49),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H8(12),24,0,G1H8(25),n2h8(45))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[24,3,4],[0,0,nMW],3,2,wf4(:,6),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,50),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G0H8(13),24,0,G1H8(26),n2h8(46))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[24,3,4],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,51),heltab2x32(:,:,247))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[24,3,4],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,52),heltab2x32(:,:,248))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,7,8],[0,0,0],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,197),heltab2x32(:,:,249))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(105),n2h16(96))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,7,8],[0,nMZ,0],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,198),heltab2x32(:,:,250))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(106),n2h16(97))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,7,8],[0,nMW,0],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,199),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(107),n2h16(98))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,7,8],[0,0,0],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,200),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(108),n2h16(99))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,7,8],[0,nMZ,0],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,201),heltab2x32(:,:,253))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(109),n2h16(100))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,7,8],[0,nMW,0],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,202),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(110),n2h16(101))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,7,8],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,203),heltab2x32(:,:,255))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,7,8],[nMW,0,nMW],3,1,wf8(:,32))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,204),heltab2x32(:,:,256))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,4,11],[0,0,0],3,1,wf8(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,205),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(113),n2h16(102))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,4,11],[0,nMZ,0],3,1,wf8(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,206),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(114),n2h16(103))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,4,11],[0,nMW,0],3,1,wf8(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,207),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(115),n2h16(104))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,4,11],[0,0,0],3,1,wf8(:,28))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,208),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(116),n2h16(105))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,4,11],[0,nMZ,0],3,1,wf8(:,28))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,209),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(117),n2h16(106))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,4,11],[0,nMW,0],3,1,wf8(:,28))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,210),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(118),n2h16(107))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,4,11],[nMW,0,nMW],3,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,211),heltab2x32(:,:,263))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,4,11],[nMW,0,nMW],3,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,212),heltab2x32(:,:,264))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[17,2,12],[0,0,0],3,2,wf4(:,9),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(16),m3h4x8(:,53),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[17,2,12],[nMZ,0,0],3,2,wf4(:,9),wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(17),ngZl,m3h4x8(:,54),heltab2x32(:,:,266))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[17,2,12],[0,0,0],3,2,wf4(:,9),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(18),m3h4x8(:,55),heltab2x32(:,:,267))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[17,2,12],[nMZ,0,0],3,2,wf4(:,9),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(19),ngZl,m3h4x8(:,56),heltab2x32(:,:,268))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[17,2,12],[nMW,0,0],3,2,wf4(:,9),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(1),m3h4x8(:,57),heltab2x32(:,:,269))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[17,2,12],[0,nMW,nMW],3,2,wf4(:,9),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(2),m3h4x8(:,58),heltab2x32(:,:,270))
  call Hloop_Q_A(ntryL,G0H8(2),17,0,G1H8(27),n2h8(47))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[17,2,12],[0,nMW,nMW],3,2,wf4(:,9),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,9),G0H8(3),m3h4x8(:,59),heltab2x32(:,:,271))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(28),n2h8(48))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[18,1,12],[0,0,0],3,2,wf4(:,12),wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,60),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[18,1,12],[nMZ,0,0],3,2,wf4(:,12),wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,12),G0H8(5),ngZl,m3h4x8(:,61),heltab2x32(:,:,273))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[18,1,12],[0,0,0],3,2,wf4(:,12),wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,62),heltab2x32(:,:,274))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[18,1,12],[nMZ,0,0],3,2,wf4(:,12),wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngZl,m3h4x8(:,63),heltab2x32(:,:,275))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[18,1,12],[nMW,0,0],3,2,wf4(:,12),wf4(:,10))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,12),G0H8(10),m3h4x8(:,64),heltab2x32(:,:,276))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[18,1,12],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(11),m3h4x8(:,65),heltab2x32(:,:,277))
  call Hloop_A_Q(ntryL,G0H8(11),18,0,G1H8(29),n2h8(49))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[18,1,12],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(12),m3h4x8(:,66),heltab2x32(:,:,278))
  call Hloop_A_Q(ntryL,G0H8(12),18,0,G1H8(30),n2h8(50))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,2,13],[0,0,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,213),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(121),n2h16(108))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,2,13],[0,nMZ,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,214),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(122),n2h16(109))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,2,13],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,215),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(123),n2h16(110))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,2,13],[0,nMZ,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,216),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(124),n2h16(111))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,2,13],[nMW,0,nMW],3,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,217),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,2,13],[nMW,0,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,218),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,1,14],[0,0,0],3,1,wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,219),heltab2x32(:,:,285))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(127),n2h16(112))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,1,14],[0,nMZ,0],3,1,wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,220),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(128),n2h16(113))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,1,14],[0,0,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,221),heltab2x32(:,:,287))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(129),n2h16(114))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,1,14],[0,nMZ,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,222),heltab2x32(:,:,288))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(130),n2h16(115))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,1,14],[nMW,0,nMW],3,1,wf8(:,34))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(131),m3h2x16(:,223),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,224),heltab2x32(:,:,290))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[19,4,8],[0,0,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,291))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(12),n2h4(60))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[19,4,8],[0,nMZ,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,292))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(1),n2h4(61))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[19,4,8],[0,nMW,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(6),n2h4(62))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[19,4,8],[0,0,0],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZu,m3h8x4(:,4),heltab2x32(:,:,294))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(14),n2h4(63))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[19,4,8],[0,nMZ,0],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZu,m3h8x4(:,5),heltab2x32(:,:,295))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(15),n2h4(64))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[19,4,8],[0,nMW,0],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZd,m3h8x4(:,6),heltab2x32(:,:,296))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(19),n2h4(65))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[19,4,8],[nMW,0,nMW],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(20),m3h8x4(:,7),heltab2x32(:,:,297))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[19,4,8],[nMW,0,nMW],3,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(21),m3h8x4(:,8),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[19,4,8],[0,0,0],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(1),m3h8x4(:,9),heltab2x32(:,:,299))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(24),n2h4(66))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[19,4,8],[0,nMZ,0],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(1),m3h8x4(:,10),heltab2x32(:,:,300))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(25),n2h4(67))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[19,4,8],[0,nMW,0],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(1),m3h8x4(:,11),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(26),n2h4(68))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[19,4,8],[0,0,0],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(1),ngZu,m3h8x4(:,12),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(29),n2h4(69))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[19,4,8],[0,nMZ,0],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(1),ngZu,m3h8x4(:,13),heltab2x32(:,:,303))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(30),n2h4(70))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[19,4,8],[0,nMW,0],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(1),ngZd,m3h8x4(:,14),heltab2x32(:,:,304))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(31),n2h4(71))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[19,4,8],[nMW,0,nMW],3,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(34),m3h8x4(:,15),heltab2x32(:,:,305))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[19,4,8],[nMW,0,nMW],3,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(35),m3h8x4(:,16),heltab2x32(:,:,306))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[28,1,2],[0,0,0],3,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,25),G0H4(1),m3h8x4(:,17),heltab2x32(:,:,307))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(36),n2h4(72))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[28,1,2],[0,nMZ,0],3,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,25),G0H4(1),m3h8x4(:,18),heltab2x32(:,:,308))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(39),n2h4(73))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[28,1,2],[0,0,0],3,1,wf8(:,26))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,26),G0H4(1),ngZl,m3h8x4(:,19),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(40),n2h4(74))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[28,1,2],[0,nMZ,0],3,1,wf8(:,26))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,26),G0H4(1),ngZl,m3h8x4(:,20),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(3),n2h4(75))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[28,1,2],[0,nMW,0],3,1,wf8(:,26))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,26),G0H4(1),ngZn,m3h8x4(:,21),heltab2x32(:,:,311))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(18),n2h4(76))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[28,1,2],[nMW,0,nMW],3,1,wf8(:,25))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(13),m3h8x4(:,22),heltab2x32(:,:,312))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[28,1,2],[nMW,0,nMW],3,1,wf8(:,26))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(41),m3h8x4(:,23),heltab2x32(:,:,313))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[28,1,2],[0,0,0],3,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,29),G0H4(1),m3h8x4(:,24),heltab2x32(:,:,314))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(45),n2h4(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[28,1,2],[0,nMZ,0],3,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,29),G0H4(1),m3h8x4(:,25),heltab2x32(:,:,315))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(46),n2h4(78))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[28,1,2],[0,0,0],3,1,wf8(:,30))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,30),G0H4(1),ngZl,m3h8x4(:,26),heltab2x32(:,:,316))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(49),n2h4(79))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[28,1,2],[0,nMZ,0],3,1,wf8(:,30))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,30),G0H4(1),ngZl,m3h8x4(:,27),heltab2x32(:,:,317))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(52),n2h4(80))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[28,1,2],[0,nMW,0],3,1,wf8(:,30))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,30),G0H4(1),ngZn,m3h8x4(:,28),heltab2x32(:,:,318))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(53),n2h4(81))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[28,1,2],[nMW,0,nMW],3,1,wf8(:,29))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(54),m3h8x4(:,29),heltab2x32(:,:,319))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[28,1,2],[nMW,0,nMW],3,1,wf8(:,30))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(57),m3h8x4(:,30),heltab2x32(:,:,320))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(34),G1H4(21),G1H4(20),G1H4(9),G0H4(4) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(54),G1H4(41),G1H4(13),G0H4(2),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(7),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(9),G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(67),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(68),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(79),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(90),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(92),[G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(94),[G1H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(100),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(24),G1H4(14),G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(25),G1H4(15),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(26),G1H4(19),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(45),G1H4(40),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(46),G1H4(3),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(18)])
  call Hloop_WQ_A(ntryL,G1H4(35),ex3(:),G1H2(6),m3h2x2(:,76),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(6),23,0,G2H2(9),n2h2(40))
  call Hloop_WA_Q(ntryL,G1H4(42),ex4(:),G1H2(7),m3h2x2(:,77),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(7),27,0,G2H2(35),n2h2(41))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,1),G1H2(11),m3h4x2(:,12),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(11),23,0,G2H2(37),n2h2(42))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,4),G1H2(12),ngZd,m3h4x2(:,13),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(12),23,0,G2H2(19),n2h2(43))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,10),G1H2(13),ngZn,m3h4x2(:,14),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(13),29,0,G2H2(22),n2h2(44))
  call Hloop_WQ_A(ntryL,G1H4(57),ex1(:),G1H2(17),m3h2x2(:,78),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(17),29,0,G2H2(10),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(47),m3h4x4(:,21),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(47),19,0,G2H4(8),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(48),m3h4x4(:,22),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(48),19,nMM,G2H4(4),n2h4(83))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(60),m3h4x4(:,23),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(60),19,nML,G2H4(5),n2h4(84))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,1),G1H4(61),m3h4x4(:,24),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(61),19,0,G2H4(6),n2h4(85))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(62),m3h4x4(:,25),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(62),19,nMM,G2H4(12),n2h4(86))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,1),G1H4(65),m3h4x4(:,26),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(65),19,nML,G2H4(13),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(34),m3h4x4(:,27),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(34),19,nMT,G2H4(14),n2h4(88))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,1),G1H4(21),m3h4x4(:,28),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(21),19,nMT,G2H4(17),n2h4(89))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,1),G1H4(20),m3h4x4(:,29),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(20),19,nMB,G2H4(18),n2h4(90))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,1),G1H4(9),m3h4x4(:,30),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMB,G2H4(19),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,1),G1H4(54),m3h4x4(:,31),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(54),19,0,G2H4(15),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H16(16),wf4(:,1),G1H4(41),m3h4x4(:,32),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(41),19,nMM,G2H4(7),n2h4(93))
  call Hloop_AV_Q(ntryL,G1H16(17),wf4(:,1),G1H4(13),m3h4x4(:,33),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(13),19,nML,G2H4(1),n2h4(94))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,1),G1H4(24),m3h4x4(:,34),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(24),19,0,G2H4(2),n2h4(95))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,1),G1H4(14),m3h4x4(:,35),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(14),19,nMM,G2H4(3),n2h4(96))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,1),G1H4(12),m3h4x4(:,36),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(12),19,nML,G2H4(9),n2h4(97))
  call Hloop_AV_Q(ntryL,G1H16(21),wf4(:,1),G1H4(25),m3h4x4(:,37),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(25),19,0,G2H4(10),n2h4(98))
  call Hloop_AV_Q(ntryL,G1H16(22),wf4(:,1),G1H4(15),m3h4x4(:,38),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMT,G2H4(11),n2h4(99))
  call Hloop_QV_A(ntryL,G1H16(23),wf4(:,1),G1H4(1),m3h4x4(:,39),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(16),n2h4(100))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,1),G1H4(26),m3h4x4(:,40),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(26),19,nMT,G2H4(20),n2h4(101))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,1),G1H4(19),m3h4x4(:,41),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(19),19,0,G2H4(21),n2h4(102))
  call Hloop_AV_Q(ntryL,G1H16(26),wf4(:,1),G1H4(6),m3h4x4(:,42),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(6),19,nMB,G2H4(22),n2h4(103))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,1),G1H4(45),m3h4x4(:,43),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(45),19,0,G2H4(23),n2h4(104))
  call Hloop_QV_A(ntryL,G1H16(28),wf4(:,1),G1H4(40),m3h4x4(:,44),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(40),19,nMB,G2H4(24),n2h4(105))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,4),G1H4(36),ngZl,m3h4x4(:,45),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(36),19,0,G2H4(25),n2h4(106))
  call Hloop_AZ_Q(ntryL,G1H16(30),wf4(:,4),G1H4(46),ngZl,m3h4x4(:,46),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(46),19,nMM,G2H4(26),n2h4(107))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,4),G1H4(3),ngZl,m3h4x4(:,47),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(3),19,nML,G2H4(27),n2h4(108))
  call Hloop_QZ_A(ntryL,G1H16(32),wf4(:,4),G1H4(39),ngZl,m3h4x4(:,48),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(39),19,0,G2H4(28),n2h4(109))
  call Hloop_QZ_A(ntryL,G1H16(33),wf4(:,4),G1H4(18),ngZl,m3h4x4(:,49),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(18),19,nMM,G2H4(29),n2h4(110))
  call Hloop_QZ_A(ntryL,G1H16(34),wf4(:,4),G1H4(35),ngZl,m3h4x4(:,50),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(35),19,nML,G2H4(30),n2h4(111))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,4),G1H4(42),ngZu,m3h4x4(:,51),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(42),19,0,G2H4(31),n2h4(112))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,4),G1H4(57),ngZu,m3h4x4(:,52),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(57),19,nMT,G2H4(32),n2h4(113))
  call Hloop_QZ_A(ntryL,G1H16(37),wf4(:,4),G1H4(47),ngZu,m3h4x4(:,53),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(47),19,0,G2H4(33),n2h4(114))
  call Hloop_QZ_A(ntryL,G1H16(38),wf4(:,4),G1H4(48),ngZu,m3h4x4(:,54),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(48),19,nMT,G2H4(34),n2h4(115))
  call Hloop_AZ_Q(ntryL,G1H16(39),wf4(:,4),G1H4(60),ngZd,m3h4x4(:,55),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(60),19,0,G2H4(35),n2h4(116))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,4),G1H4(61),ngZd,m3h4x4(:,56),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(61),19,nMB,G2H4(36),n2h4(117))
  call Hloop_QZ_A(ntryL,G1H16(41),wf4(:,4),G1H4(62),ngZd,m3h4x4(:,57),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(62),19,0,G2H4(37),n2h4(118))
  call Hloop_QZ_A(ntryL,G1H16(42),wf4(:,4),G1H4(65),ngZd,m3h4x4(:,58),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(65),19,nMB,G2H4(38),n2h4(119))
  call Hloop_AZ_Q(ntryL,G1H16(43),wf4(:,4),G1H4(34),ngZl,m3h4x4(:,59),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(34),19,0,G2H4(39),n2h4(120))
  call Hloop_AZ_Q(ntryL,G1H16(44),wf4(:,4),G1H4(21),ngZl,m3h4x4(:,60),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(21),19,nMM,G2H4(40),n2h4(121))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,4),G1H4(20),ngZl,m3h4x4(:,61),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(20),19,nML,G2H4(41),n2h4(122))
  call Hloop_QZ_A(ntryL,G1H16(46),wf4(:,4),G1H4(9),ngZl,m3h4x4(:,62),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(9),19,0,G2H4(42),n2h4(123))
  call Hloop_QZ_A(ntryL,G1H16(47),wf4(:,4),G1H4(54),ngZl,m3h4x4(:,63),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(54),19,nMM,G2H4(43),n2h4(124))
  call Hloop_QZ_A(ntryL,G1H16(48),wf4(:,4),G1H4(41),ngZl,m3h4x4(:,64),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(41),19,nML,G2H4(44),n2h4(125))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf4(:,4),G1H4(13),ngZu,m3h4x4(:,65),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(13),19,0,G2H4(45),n2h4(126))
  call Hloop_AZ_Q(ntryL,G1H16(50),wf4(:,4),G1H4(24),ngZu,m3h4x4(:,66),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(24),19,nMT,G2H4(46),n2h4(127))
  call Hloop_QZ_A(ntryL,G1H16(51),wf4(:,4),G1H4(14),ngZu,m3h4x4(:,67),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(14),19,0,G2H4(47),n2h4(128))
  call Hloop_QZ_A(ntryL,G1H16(52),wf4(:,4),G1H4(12),ngZu,m3h4x4(:,68),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMT,G2H4(48),n2h4(129))
  call Hloop_AZ_Q(ntryL,G1H16(53),wf4(:,4),G1H4(25),ngZd,m3h4x4(:,69),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(25),19,0,G2H4(49),n2h4(130))
  call Hloop_AZ_Q(ntryL,G1H16(54),wf4(:,4),G1H4(15),ngZd,m3h4x4(:,70),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMB,G2H4(50),n2h4(131))
  call Hloop_QZ_A(ntryL,G1H16(55),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,71),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(51),n2h4(132))
  call Hloop_QZ_A(ntryL,G1H16(56),wf4(:,4),G1H4(26),ngZd,m3h4x4(:,72),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(26),19,nMB,G2H4(52),n2h4(133))
  call Hloop_SV_T(ntryL,G1H16(57),16,wf4(:,1),3,G2H4(53),m3h4x4(:,73),heltab2x16(:,:,113))
  call Hloop_TV_S(ntryL,G1H16(58),16,wf4(:,1),3,G2H4(54),m3h4x4(:,74),heltab2x16(:,:,114))
  call Hloop_SV_T(ntryL,G1H16(59),16,wf4(:,1),3,G2H4(55),m3h4x4(:,75),heltab2x16(:,:,115))
  call Hloop_TV_S(ntryL,G1H16(60),16,wf4(:,1),3,G2H4(56),m3h4x4(:,76),heltab2x16(:,:,116))
  call Hloop_SV_T(ntryL,G1H16(61),16,wf4(:,4),3,G2H4(57),m3h4x4(:,77),heltab2x16(:,:,117))
  call Hloop_TV_S(ntryL,G1H16(62),16,wf4(:,4),3,G2H4(58),m3h4x4(:,78),heltab2x16(:,:,118))
  call Hloop_SV_T(ntryL,G1H16(63),16,wf4(:,4),3,G2H4(59),m3h4x4(:,79),heltab2x16(:,:,119))
  call Hloop_TV_S(ntryL,G1H16(64),16,wf4(:,4),3,G2H4(60),m3h4x4(:,80),heltab2x16(:,:,120))
  call Hloop_DV_C(ntryL,G1H16(67),16,wf4(:,1),G2H4(61),m3h4x4(:,81),heltab2x16(:,:,121))
  call Hloop_CV_D(ntryL,G1H16(68),16,wf4(:,1),3,G2H4(62),m3h4x4(:,82),heltab2x16(:,:,122))
  call Hloop_DV_C(ntryL,G1H16(71),16,wf4(:,1),G2H4(63),m3h4x4(:,83),heltab2x16(:,:,123))
  call Hloop_CV_D(ntryL,G1H16(72),16,wf4(:,1),3,G2H4(64),m3h4x4(:,84),heltab2x16(:,:,124))
  call Hloop_DV_C(ntryL,G1H16(75),16,wf4(:,4),G2H4(65),m3h4x4(:,85),heltab2x16(:,:,125))
  call Hloop_CV_D(ntryL,G1H16(76),16,wf4(:,4),3,G2H4(66),m3h4x4(:,86),heltab2x16(:,:,126))
  call Hloop_DV_C(ntryL,G1H16(79),16,wf4(:,4),G2H4(67),m3h4x4(:,87),heltab2x16(:,:,127))
  call Hloop_CV_D(ntryL,G1H16(80),16,wf4(:,4),3,G2H4(68),m3h4x4(:,88),heltab2x16(:,:,128))
  call Hloop_UW_V(ntryL,G1H16(81),16,wf4(:,1),3,G2H4(69),m3h4x4(:,89),heltab2x16(:,:,129))
  call Hloop_UV_W(ntryL,G1H16(82),16,wf4(:,1),3,G2H4(70),m3h4x4(:,90),heltab2x16(:,:,130))
  call Hloop_UW_V(ntryL,G1H16(83),16,wf4(:,1),3,G2H4(71),m3h4x4(:,91),heltab2x16(:,:,131))
  call Hloop_UV_W(ntryL,G1H16(84),16,wf4(:,1),3,G2H4(72),m3h4x4(:,92),heltab2x16(:,:,132))
  call Hloop_UW_V(ntryL,G1H16(85),16,wf4(:,4),3,G2H4(73),m3h4x4(:,93),heltab2x16(:,:,133))
  call Hloop_UV_W(ntryL,G1H16(86),16,wf4(:,4),3,G2H4(74),m3h4x4(:,94),heltab2x16(:,:,134))
  call Hloop_UW_V(ntryL,G1H16(87),16,wf4(:,4),3,G2H4(75),m3h4x4(:,95),heltab2x16(:,:,135))
  call Hloop_UV_W(ntryL,G1H16(88),16,wf4(:,4),3,G2H4(76),m3h4x4(:,96),heltab2x16(:,:,136))
  call Hloop_SV_V(ntryL,G1H16(90),wf4(:,1),G1H4(19),m3h4x4(:,97),heltab2x16(:,:,137))
  call Hloop_SV_V(ntryL,G1H16(92),wf4(:,1),G1H4(6),m3h4x4(:,98),heltab2x16(:,:,138))
  call Hloop_SV_V(ntryL,G1H16(94),wf4(:,4),G1H4(45),m3h4x4(:,99),heltab2x16(:,:,139))
  call Hloop_SV_V(ntryL,G1H16(96),wf4(:,4),G1H4(40),m3h4x4(:,100),heltab2x16(:,:,140))
  call Hloop_SV_T(ntryL,G0H16(1),16,wf4(:,1),3,G1H4(36),m3h4x4(:,101),heltab2x16(:,:,141))
  call Hloop_TV_S(ntryL,G0H16(2),16,wf4(:,1),3,G1H4(46),m3h4x4(:,102),heltab2x16(:,:,142))
  call Hloop_SV_T(ntryL,G0H16(3),16,wf4(:,1),3,G1H4(3),m3h4x4(:,103),heltab2x16(:,:,143))
  call Hloop_TV_S(ntryL,G0H16(4),16,wf4(:,1),3,G1H4(39),m3h4x4(:,104),heltab2x16(:,:,144))
  call Hloop_SV_T(ntryL,G0H16(5),16,wf4(:,4),3,G1H4(18),m3h4x4(:,105),heltab2x16(:,:,145))
  call Hloop_TV_S(ntryL,G0H16(6),16,wf4(:,4),3,G1H4(35),m3h4x4(:,106),heltab2x16(:,:,146))
  call Hloop_SV_T(ntryL,G0H16(7),16,wf4(:,4),3,G1H4(42),m3h4x4(:,107),heltab2x16(:,:,147))
  call Hloop_TV_S(ntryL,G0H16(8),16,wf4(:,4),3,G1H4(57),m3h4x4(:,108),heltab2x16(:,:,148))
  call Hloop_VV_S(ntryL,G0H16(9),wf4(:,1),G0H4(1),m3h4x4(:,109),heltab2x16(:,:,149))
  call Hloop_VV_S(ntryL,G0H16(10),wf4(:,1),G0H4(4),m3h4x4(:,110),heltab2x16(:,:,150))
  call Hloop_VV_S(ntryL,G0H16(11),wf4(:,1),G0H4(5),m3h4x4(:,111),heltab2x16(:,:,151))
  call Hloop_VV_S(ntryL,G0H16(12),wf4(:,1),G0H4(2),m3h4x4(:,112),heltab2x16(:,:,152))
  call Hloop_VV_S(ntryL,G0H16(13),wf4(:,4),G0H4(3),m3h4x4(:,113),heltab2x16(:,:,153))
  call Hloop_VV_S(ntryL,G0H16(14),wf4(:,4),G0H4(6),m3h4x4(:,114),heltab2x16(:,:,154))
  call Hloop_VV_S(ntryL,G0H16(15),wf4(:,4),G0H4(7),m3h4x4(:,115),heltab2x16(:,:,155))
  call Hloop_VV_S(ntryL,G0H16(16),wf4(:,4),G0H4(8),m3h4x4(:,116),heltab2x16(:,:,156))
  call Hloop_SV_V(ntryL,G0H16(17),wf4(:,1),G0H4(9),m3h4x4(:,117),heltab2x16(:,:,157))
  call Hloop_SV_V(ntryL,G0H16(18),wf4(:,1),G0H4(10),m3h4x4(:,118),heltab2x16(:,:,158))
  call Hloop_SV_V(ntryL,G0H16(19),wf4(:,1),G0H4(11),m3h4x4(:,119),heltab2x16(:,:,159))
  call Hloop_SV_V(ntryL,G0H16(20),wf4(:,1),G0H4(12),m3h4x4(:,120),heltab2x16(:,:,160))
  call Hloop_SV_V(ntryL,G0H16(21),wf4(:,4),G0H4(13),m3h4x4(:,121),heltab2x16(:,:,161))
  call Hloop_SV_V(ntryL,G0H16(22),wf4(:,4),G0H4(14),m3h4x4(:,122),heltab2x16(:,:,162))
  call Hloop_SV_V(ntryL,G0H16(23),wf4(:,4),G0H4(15),m3h4x4(:,123),heltab2x16(:,:,163))
  call Hloop_SV_V(ntryL,G0H16(24),wf4(:,4),G0H4(16),m3h4x4(:,124),heltab2x16(:,:,164))
  call Hloop_UW_V(ntryL,G0H16(25),16,wf4(:,1),3,G1H4(47),m3h4x4(:,125),heltab2x16(:,:,165))
  call Hloop_UV_W(ntryL,G0H16(26),16,wf4(:,1),3,G1H4(48),m3h4x4(:,126),heltab2x16(:,:,166))
  call Hloop_UW_V(ntryL,G0H16(27),16,wf4(:,1),3,G1H4(60),m3h4x4(:,127),heltab2x16(:,:,167))
  call Hloop_UV_W(ntryL,G0H16(28),16,wf4(:,1),3,G1H4(61),m3h4x4(:,128),heltab2x16(:,:,168))
  call Hloop_UW_V(ntryL,G0H16(29),16,wf4(:,4),3,G1H4(62),m3h4x4(:,129),heltab2x16(:,:,169))
  call Hloop_UV_W(ntryL,G0H16(30),16,wf4(:,4),3,G1H4(65),m3h4x4(:,130),heltab2x16(:,:,170))
  call Hloop_UW_V(ntryL,G0H16(31),16,wf4(:,4),3,G1H4(34),m3h4x4(:,131),heltab2x16(:,:,171))
  call Hloop_UV_W(ntryL,G0H16(32),16,wf4(:,4),3,G1H4(21),m3h4x4(:,132),heltab2x16(:,:,172))
  call Hloop_VV_S(ntryL,G1H16(98),wf4(:,1),G1H4(20),m3h4x4(:,133),heltab2x16(:,:,173))
  call Hloop_VV_S(ntryL,G1H16(100),wf4(:,1),G1H4(9),m3h4x4(:,134),heltab2x16(:,:,174))
  call Hloop_VV_S(ntryL,G1H16(102),wf4(:,4),G1H4(54),m3h4x4(:,135),heltab2x16(:,:,175))
  call Hloop_VV_S(ntryL,G1H16(104),wf4(:,4),G1H4(41),m3h4x4(:,136),heltab2x16(:,:,176))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,1),G1H2(19),m3h4x2(:,15),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(19),23,0,G2H2(1),n2h2(46))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(23),m3h4x2(:,16),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(23),23,0,G2H2(2),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,4),G1H2(25),ngZu,m3h4x2(:,17),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(25),23,0,G2H2(3),n2h2(48))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,4),G1H2(31),ngZu,m3h4x2(:,18),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(31),23,0,G2H2(4),n2h2(49))
  call Hloop_UW_V(ntryL,G0H8(6),20,wf4(:,1),3,G1H2(35),m3h4x2(:,19),heltab2x8(:,:,93))
  call Hloop_UW_V(ntryL,G0H8(7),20,wf4(:,4),3,G1H2(36),m3h4x2(:,20),heltab2x8(:,:,94))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,1),G1H2(41),m3h4x2(:,21),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(41),27,0,G2H2(5),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,1),G1H2(47),m3h4x2(:,22),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(47),27,0,G2H2(6),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,1),G1H2(48),m3h4x2(:,23),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(48),27,0,G2H2(7),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,4),G1H2(53),ngZu,m3h4x2(:,24),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(53),27,0,G2H2(8),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H8(25),wf4(:,4),G1H2(60),ngZu,m3h4x2(:,25),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(60),27,0,G2H2(11),n2h2(54))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,4),G1H2(61),ngZd,m3h4x2(:,26),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(61),27,0,G2H2(12),n2h2(55))
  call Hloop_UV_W(ntryL,G0H8(14),24,wf4(:,1),3,G1H2(66),m3h4x2(:,27),heltab2x8(:,:,101))
  call Hloop_UV_W(ntryL,G0H8(15),24,wf4(:,4),3,G1H2(67),m3h4x2(:,28),heltab2x8(:,:,102))
  call Hloop_AQ_V(ntryL,G1H16(105),wf8(:,31),G1H2(73),m3h8x2(:,1),heltab2x16(:,:,177))
  call Hloop_AQ_Z(ntryL,G1H16(106),wf8(:,31),G1H2(79),ngZu,m3h8x2(:,2),heltab2x16(:,:,178))
  call Hloop_AQ_W(ntryL,G1H16(107),wf8(:,31),G1H2(84),m3h8x2(:,3),heltab2x16(:,:,179))
  call Hloop_AQ_V(ntryL,G1H16(108),wf8(:,32),G1H2(90),m3h8x2(:,4),heltab2x16(:,:,180))
  call Hloop_AQ_Z(ntryL,G1H16(109),wf8(:,32),G1H2(1),ngZu,m3h8x2(:,5),heltab2x16(:,:,181))
  call Hloop_AQ_W(ntryL,G1H16(110),wf8(:,32),G1H2(2),m3h8x2(:,6),heltab2x16(:,:,182))
  call Hloop_WQ_A(ntryL,G1H16(111),wf8(:,31),G1H2(46),m3h8x2(:,7),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(13),n2h2(56))
  call Hloop_WQ_A(ntryL,G1H16(112),wf8(:,32),G1H2(18),m3h8x2(:,8),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(18),23,0,G2H2(14),n2h2(57))
  call Hloop_AQ_V(ntryL,G1H16(113),ex3(:),G1H8(31),m3h2x8(:,41),heltab2x16(:,:,185))
  call Hloop_AQ_Z(ntryL,G1H16(114),ex3(:),G1H8(32),ngZu,m3h2x8(:,42),heltab2x16(:,:,186))
  call Hloop_AQ_W(ntryL,G1H16(115),ex3(:),G1H8(33),m3h2x8(:,43),heltab2x16(:,:,187))
  call Hloop_AQ_V(ntryL,G1H16(116),ex3(:),G1H8(1),m3h2x8(:,44),heltab2x16(:,:,188))
  call Hloop_AQ_Z(ntryL,G1H16(117),ex3(:),G1H8(3),ngZu,m3h2x8(:,45),heltab2x16(:,:,189))
  call Hloop_AQ_W(ntryL,G1H16(118),ex3(:),G1H8(4),m3h2x8(:,46),heltab2x16(:,:,190))
  call Hloop_WQ_A(ntryL,G1H16(119),ex3(:),G1H8(5),m3h2x8(:,47),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G1H8(5),20,0,G2H8(1),n2h8(51))
  call Hloop_WQ_A(ntryL,G1H16(120),ex3(:),G1H8(6),m3h2x8(:,48),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(6),20,0,G2H8(2),n2h8(52))
  call Hloop_VA_Q(ntryL,G0H8(16),ex2(:),G0H4(17),m3h2x4(:,75),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(13),n2h4(134))
  call Hloop_ZA_Q(ntryL,G0H8(17),ex2(:),G0H4(17),ngZl,m3h2x4(:,76),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(24),n2h4(135))
  call Hloop_VA_Q(ntryL,G0H8(18),ex2(:),G0H4(17),m3h2x4(:,77),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(14),n2h4(136))
  call Hloop_ZA_Q(ntryL,G0H8(19),ex2(:),G0H4(17),ngZl,m3h2x4(:,78),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(12),n2h4(137))
  call Hloop_WA_Q(ntryL,G0H8(1),ex2(:),G0H4(17),m3h2x4(:,79),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(25),n2h4(138))
  call Hloop_QA_W(ntryL,G1H8(27),ex2(:),G1H4(15),m3h2x4(:,80),heltab2x8(:,:,108))
  call Hloop_QA_W(ntryL,G1H8(28),ex2(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,109))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(17),m3h2x4(:,82),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G0H4(17),19,0,G1H4(26),n2h4(139))
  call Hloop_ZQ_A(ntryL,G0H8(5),ex1(:),G0H4(17),ngZl,m3h2x4(:,83),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G0H4(17),19,0,G1H4(66),n2h4(140))
  call Hloop_VQ_A(ntryL,G0H8(8),ex1(:),G0H4(17),m3h2x4(:,84),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G0H4(17),19,0,G1H4(67),n2h4(141))
  call Hloop_ZQ_A(ntryL,G0H8(9),ex1(:),G0H4(17),ngZl,m3h2x4(:,85),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(17),19,0,G1H4(68),n2h4(142))
  call Hloop_WQ_A(ntryL,G0H8(10),ex1(:),G0H4(17),m3h2x4(:,86),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G0H4(17),19,0,G1H4(69),n2h4(143))
  call Hloop_AQ_W(ntryL,G1H8(29),ex1(:),G1H4(70),m3h2x4(:,87),heltab2x8(:,:,115))
  call Hloop_AQ_W(ntryL,G1H8(30),ex1(:),G1H4(71),m3h2x4(:,88),heltab2x8(:,:,116))
  call Hloop_QA_V(ntryL,G1H16(121),ex2(:),G1H8(8),m3h2x8(:,49),heltab2x16(:,:,193))
  call Hloop_QA_Z(ntryL,G1H16(122),ex2(:),G1H8(9),ngZl,m3h2x8(:,50),heltab2x16(:,:,194))
  call Hloop_QA_V(ntryL,G1H16(123),ex2(:),G1H8(10),m3h2x8(:,51),heltab2x16(:,:,195))
  call Hloop_QA_Z(ntryL,G1H16(124),ex2(:),G1H8(11),ngZl,m3h2x8(:,52),heltab2x16(:,:,196))
  call Hloop_WA_Q(ntryL,G1H16(125),ex2(:),G1H8(13),m3h2x8(:,53),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H8(13),18,0,G2H8(3),n2h8(53))
  call Hloop_WA_Q(ntryL,G1H16(126),ex2(:),G1H8(14),m3h2x8(:,54),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G1H8(14),18,0,G2H8(4),n2h8(54))
  call Hloop_AQ_V(ntryL,G1H16(127),ex1(:),G1H8(2),m3h2x8(:,55),heltab2x16(:,:,199))
  call Hloop_AQ_Z(ntryL,G1H16(128),ex1(:),G1H8(7),ngZl,m3h2x8(:,56),heltab2x16(:,:,200))
  call Hloop_AQ_V(ntryL,G1H16(129),ex1(:),G1H8(17),m3h2x8(:,57),heltab2x16(:,:,201))
  call Hloop_AQ_Z(ntryL,G1H16(130),ex1(:),G1H8(20),ngZl,m3h2x8(:,58),heltab2x16(:,:,202))
  call Hloop_WQ_A(ntryL,G1H16(131),ex1(:),G1H8(12),m3h2x8(:,59),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(12),17,0,G2H8(5),n2h8(55))
  call Hloop_WQ_A(ntryL,G1H16(132),ex1(:),G1H8(15),m3h2x8(:,60),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G1H8(15),17,0,G2H8(6),n2h8(56))
  call Hloop_AQ_V(ntryL,G1H4(29),ex3(:),G1H2(37),m3h2x2(:,79),heltab2x4(:,:,119))
  call Hloop_AQ_Z(ntryL,G1H4(30),ex3(:),G1H2(50),ngZu,m3h2x2(:,80),heltab2x4(:,:,120))
  call Hloop_AQ_W(ntryL,G1H4(31),ex3(:),G1H2(24),m3h2x2(:,81),heltab2x4(:,:,121))
  call Hloop_AQ_V(ntryL,G1H4(49),ex1(:),G1H2(49),m3h2x2(:,82),heltab2x4(:,:,122))
  call Hloop_AQ_Z(ntryL,G1H4(52),ex1(:),G1H2(51),ngZl,m3h2x2(:,83),heltab2x4(:,:,123))
  call Hloop_AQ_W(ntryL,G1H4(53),ex1(:),G1H2(43),m3h2x2(:,84),heltab2x4(:,:,124))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(67),[G1H2(66)])
call HGT_w2_OLR(G1H2(76),1,1,2)
call HGT_w2_invQ_OLR(G1H2(76),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(13),G2H2(39),G2H2(36),G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(35),G1H2(10)])
call HGT_w2_OLR(G1H2(86),1,1,2)
call HGT_w2_invQ_OLR(G1H2(86),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(36)])
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(84),G1H2(56),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(73),G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(79),G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(31),G2H4(25),G2H4(8),G1H4(17),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(15),G1H4(28),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(69),G1H4(33),G0H4(13),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(71),G1H4(38),G0H4(15),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(33),G2H4(28),G2H4(6),G1H4(44),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(2),G1H4(56),G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(70),G1H4(59),G0H4(14),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(72),G1H4(64),G0H4(16),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(53),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G2H4(54),G0H4(6),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G2H4(55),G0H4(7),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(56),G0H4(8),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G2H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(62),G1H4(48),G1H4(47),G1H4(45),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(34),G1H4(61),G1H4(60),G1H4(40),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(20),G1H4(35),G1H4(18),G1H4(46),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(9),G1H4(57),G1H4(42),G1H4(39),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(7)])
  call Hloop_WQ_A(ntryL,G1H2(76),ex3(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(159),n2h1(144))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(2),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hloop_WA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(145))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(33),ex3(:),G2tensor(4),m3h2x1(:,151),heltab2x2(:,:,151))
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,1),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(146))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,42),heltab2x4(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(147))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,10),G1H1(1),ngZn,m3h4x1(:,43),heltab2x4(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(148))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(42),ex2(:),G2tensor(25),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hloop_WA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(149))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(151))
  call Hloop_ZQ_A(ntryL,G1H2(32),ex3(:),G1H1(1),ngZu,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(152))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex3(:),G1H1(1),ngZu,m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(153))
  call Hloop_WQ_A(ntryL,G1H2(80),ex3(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(154))
  call Hloop_WQ_A(ntryL,G1H2(81),ex3(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(155))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(156))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(157))
  call Hloop_ZA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),ngZu,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(158))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),ngZu,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(159))
  call Hloop_WA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(54),n2h1(160))
  call Hloop_AV_Q(ntryL,G1H4(13),wf4(:,8),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(161))
  call Hloop_AV_Q(ntryL,G2H4(35),wf4(:,8),G2H1(1),m3h4x1(:,45),heltab2x4(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,8),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(163))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,47),heltab2x4(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(164))
  call Hloop_AZ_Q(ntryL,G2H4(39),wf4(:,10),G2H1(1),ngZl,m3h4x1(:,48),heltab2x4(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(2),n2h1(165))
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,49),heltab2x4(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(166))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(15),19,wf4(:,8),12,G2tensor(162),m3h4x1(:,50),heltab2x4(:,:,134))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(73),19,wf4(:,8),12,G3tensor(3),m3h4x1(:,51),heltab2x4(:,:,135))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(1),19,wf4(:,10),12,G2tensor(144),m3h4x1(:,52),heltab2x4(:,:,136))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(75),19,wf4(:,10),12,G3tensor(4),m3h4x1(:,53),heltab2x4(:,:,137))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,8),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(167))
  call Hloop_QV_A(ntryL,G2H4(37),wf4(:,8),G2H1(1),m3h4x1(:,55),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(168))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,8),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(169))
  call Hloop_QZ_A(ntryL,G1H4(67),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,57),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(170))
  call Hloop_QZ_A(ntryL,G2H4(42),wf4(:,10),G2H1(1),ngZl,m3h4x1(:,58),heltab2x4(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(171))
  call Hloop_QZ_A(ntryL,G1H4(68),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,59),heltab2x4(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(172))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(70),19,wf4(:,8),12,G2tensor(16),m3h4x1(:,60),heltab2x4(:,:,144))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(74),19,wf4(:,8),12,G3tensor(7),m3h4x1(:,61),heltab2x4(:,:,145))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(71),19,wf4(:,10),12,G2tensor(15),m3h4x1(:,62),heltab2x4(:,:,146))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(76),19,wf4(:,10),12,G3tensor(8),m3h4x1(:,63),heltab2x4(:,:,147))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(18),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(35),ex3(:),G2tensor(19),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(21),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(28),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(24),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hloop_AV_Q(ntryL,G2H4(26),wf4(:,8),G2H1(1),m3h4x1(:,64),heltab2x4(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(9),n2h1(173))
  call Hloop_AV_Q(ntryL,G2H4(27),wf4(:,8),G2H1(1),m3h4x1(:,65),heltab2x4(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(10),n2h1(174))
  call Hloop_QV_A(ntryL,G2H4(29),wf4(:,8),G2H1(1),m3h4x1(:,66),heltab2x4(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(11),n2h1(175))
  call Hloop_QV_A(ntryL,G2H4(30),wf4(:,8),G2H1(1),m3h4x1(:,67),heltab2x4(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(12),n2h1(176))
  call Hloop_AV_Q(ntryL,G2H4(32),wf4(:,8),G2H1(1),m3h4x1(:,68),heltab2x4(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(177))
  call Hloop_QV_A(ntryL,G2H4(34),wf4(:,8),G2H1(1),m3h4x1(:,69),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(178))
  call Hloop_AV_Q(ntryL,G2H4(36),wf4(:,8),G2H1(1),m3h4x1(:,70),heltab2x4(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(179))
  call Hloop_QV_A(ntryL,G2H4(38),wf4(:,8),G2H1(1),m3h4x1(:,71),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(16),n2h1(180))
  call Hloop_AZ_Q(ntryL,G2H4(40),wf4(:,10),G2H1(1),ngZl,m3h4x1(:,72),heltab2x4(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(17),n2h1(181))
  call Hloop_AZ_Q(ntryL,G2H4(41),wf4(:,10),G2H1(1),ngZl,m3h4x1(:,73),heltab2x4(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(18),n2h1(182))
  call Hloop_QZ_A(ntryL,G2H4(43),wf4(:,10),G2H1(1),ngZl,m3h4x1(:,74),heltab2x4(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(19),n2h1(183))
  call Hloop_QZ_A(ntryL,G2H4(44),wf4(:,10),G2H1(1),ngZl,m3h4x1(:,75),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(20),n2h1(184))
  call Hloop_AZ_Q(ntryL,G2H4(45),wf4(:,10),G2H1(1),ngZu,m3h4x1(:,76),heltab2x4(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(185))
  call Hloop_AZ_Q(ntryL,G2H4(46),wf4(:,10),G2H1(1),ngZu,m3h4x1(:,77),heltab2x4(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(22),n2h1(186))
  call Hloop_QZ_A(ntryL,G2H4(47),wf4(:,10),G2H1(1),ngZu,m3h4x1(:,78),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(23),n2h1(187))
  call Hloop_QZ_A(ntryL,G2H4(48),wf4(:,10),G2H1(1),ngZu,m3h4x1(:,79),heltab2x4(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(24),n2h1(188))
  call Hloop_AZ_Q(ntryL,G2H4(49),wf4(:,10),G2H1(1),ngZd,m3h4x1(:,80),heltab2x4(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(25),n2h1(189))
  call Hloop_AZ_Q(ntryL,G2H4(50),wf4(:,10),G2H1(1),ngZd,m3h4x1(:,81),heltab2x4(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(26),n2h1(190))
  call Hloop_QZ_A(ntryL,G2H4(51),wf4(:,10),G2H1(1),ngZd,m3h4x1(:,82),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(27),n2h1(191))
  call Hloop_QZ_A(ntryL,G2H4(52),wf4(:,10),G2H1(1),ngZd,m3h4x1(:,83),heltab2x4(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(28),n2h1(192))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(57),19,wf4(:,8),12,G3tensor(29),m3h4x1(:,84),heltab2x4(:,:,168))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(58),19,wf4(:,8),12,G3tensor(30),m3h4x1(:,85),heltab2x4(:,:,169))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(59),19,wf4(:,10),12,G3tensor(31),m3h4x1(:,86),heltab2x4(:,:,170))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(60),19,wf4(:,10),12,G3tensor(32),m3h4x1(:,87),heltab2x4(:,:,171))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(65),19,wf4(:,8),G3tensor(33),m3h4x1(:,88),heltab2x4(:,:,172))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(66),19,wf4(:,8),12,G3tensor(34),m3h4x1(:,89),heltab2x4(:,:,173))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(67),19,wf4(:,10),G3tensor(35),m3h4x1(:,90),heltab2x4(:,:,174))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(68),19,wf4(:,10),12,G3tensor(36),m3h4x1(:,91),heltab2x4(:,:,175))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(65),wf4(:,8),G1tensor(25),m3h4x1(:,92),heltab2x4(:,:,176))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(21),wf4(:,10),G1tensor(55),m3h4x1(:,93),heltab2x4(:,:,177))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(54),wf4(:,8),G1tensor(85),m3h4x1(:,94),heltab2x4(:,:,178))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(41),wf4(:,10),G1tensor(19),m3h4x1(:,95),heltab2x4(:,:,179))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(31),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(27),ngZu,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(30),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(84),ngZu,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(37),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hloop_VA_Q(ntryL,G1H8(31),wf8(:,27),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(193))
  call Hloop_ZA_Q(ntryL,G1H8(32),wf8(:,27),G1H1(1),ngZu,m3h8x1(:,2),heltab2x8(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(194))
  call Hloop_WA_Q(ntryL,G1H8(33),wf8(:,27),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(195))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,28),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(196))
  call Hloop_ZA_Q(ntryL,G1H8(3),wf8(:,28),G1H1(1),ngZu,m3h8x1(:,5),heltab2x8(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(197))
  call Hloop_WA_Q(ntryL,G1H8(4),wf8(:,28),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(198))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(1),wf8(:,27),G2tensor(89),m3h8x1(:,7),heltab2x8(:,:,123))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(2),wf8(:,28),G2tensor(90),m3h8x1(:,8),heltab2x8(:,:,124))
  call Hloop_AZ_Q(ntryL,G1H4(25),wf4(:,10),G1H1(1),ngZn,m3h4x1(:,96),heltab2x4(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(199))
  call Hloop_VQ_A(ntryL,G1H8(8),wf8(:,38),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(200))
  call Hloop_ZQ_A(ntryL,G1H8(9),wf8(:,38),G1H1(1),ngZl,m3h8x1(:,10),heltab2x8(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(201))
  call Hloop_VQ_A(ntryL,G1H8(10),wf8(:,40),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(74),n2h1(202))
  call Hloop_ZQ_A(ntryL,G1H8(11),wf8(:,40),G1H1(1),ngZl,m3h8x1(:,12),heltab2x8(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(203))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(3),wf8(:,38),G2tensor(3),m3h8x1(:,13),heltab2x8(:,:,129))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(4),wf8(:,40),G2tensor(5),m3h8x1(:,14),heltab2x8(:,:,130))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,34),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(204))
  call Hloop_ZA_Q(ntryL,G1H8(7),wf8(:,34),G1H1(1),ngZl,m3h8x1(:,16),heltab2x8(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(205))
  call Hloop_VA_Q(ntryL,G1H8(17),wf8(:,36),G1H1(1),m3h8x1(:,17),heltab2x8(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(206))
  call Hloop_ZA_Q(ntryL,G1H8(20),wf8(:,36),G1H1(1),ngZl,m3h8x1(:,18),heltab2x8(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(207))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(5),wf8(:,34),G2tensor(14),m3h8x1(:,19),heltab2x8(:,:,135))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(6),wf8(:,36),G2tensor(17),m3h8x1(:,20),heltab2x8(:,:,136))
  call Hloop_VA_Q(ntryL,G1H2(49),ex2(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(208))
  call Hloop_ZA_Q(ntryL,G1H2(51),ex2(:),G1H1(1),ngZl,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(209))
  call Hloop_WA_Q(ntryL,G1H2(43),ex2(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(210))
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G3tensor(34),G3tensor(33),G3tensor(32),G3tensor(31),G3tensor(30),G3tensor(29) &
    ,G3tensor(8),G3tensor(7),G3tensor(4),G3tensor(3),G2tensor(103),G2tensor(101),G1tensor(19),G1tensor(85),G1tensor(55) &
    ,G1tensor(25),G1tensor(175),G1tensor(155),G1tensor(73),G1tensor(43),G0tensor(175),G0tensor(155),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(89),G2tensor(105),G1tensor(435),G0tensor(435)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(14),G2tensor(146),G2tensor(143),G2tensor(107),G1tensor(440),G1tensor(180) &
    ,G1tensor(79),G0tensor(440),G0tensor(180),G0tensor(10)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(237),G1tensor(90),G0tensor(237),G0tensor(45)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(43),G2tensor(110),G1tensor(240),G1tensor(96),G0tensor(240),G0tensor(50)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(112),G1tensor(442),G1tensor(244),G1tensor(193),G1tensor(184),G0tensor(442) &
    ,G0tensor(244),G0tensor(193),G0tensor(184)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G3tensor(23),G3tensor(21),G3tensor(6),G3tensor(5),G3tensor(2),G3tensor(1) &
    ,G2tensor(128),G2tensor(125),G2tensor(122),G2tensor(119),G2tensor(116),G2tensor(113),G1tensor(489),G1tensor(484),G1tensor(479) &
    ,G1tensor(474),G1tensor(470),G1tensor(465),G1tensor(460),G1tensor(455),G1tensor(450),G1tensor(445),G0tensor(489),G0tensor(484) &
    ,G0tensor(479),G0tensor(474),G0tensor(470),G0tensor(465),G0tensor(460),G0tensor(455),G0tensor(450),G0tensor(445)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(115),G1tensor(447),G0tensor(447)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(118),G1tensor(452),G1tensor(433),G0tensor(452),G0tensor(433)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(121),G1tensor(457),G1tensor(414),G1tensor(394),G0tensor(457),G0tensor(414) &
    ,G0tensor(394)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(124),G1tensor(462),G0tensor(462)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(127),G1tensor(467),G0tensor(467)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(136),G2tensor(130),G1tensor(472),G1tensor(412),G1tensor(182),G1tensor(97) &
    ,G0tensor(472),G0tensor(412),G0tensor(182),G0tensor(13)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(75),G2tensor(137),G2tensor(131),G1tensor(475),G1tensor(300),G1tensor(285) &
    ,G1tensor(120),G1tensor(63),G0tensor(475),G0tensor(300),G0tensor(285),G0tensor(120),G0tensor(90)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(139),G2tensor(133),G1tensor(477),G0tensor(477)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(102),G2tensor(140),G2tensor(134),G1tensor(480),G1tensor(320),G1tensor(310) &
    ,G1tensor(135),G1tensor(113),G0tensor(480),G0tensor(320),G0tensor(310),G0tensor(135),G0tensor(105)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(145),G2tensor(142),G1tensor(162),G1tensor(74),G1tensor(61),G0tensor(162) &
    ,G0tensor(43),G0tensor(7)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(148),G1tensor(482),G1tensor(392),G1tensor(242),G1tensor(114),G0tensor(482) &
    ,G0tensor(392),G0tensor(242),G0tensor(53)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(91),G2tensor(155),G2tensor(149),G1tensor(485),G0tensor(485)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(151),G1tensor(487),G0tensor(487)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(1),G2tensor(158),G2tensor(152),G1tensor(490),G0tensor(490)])
  call ol_merge_tensors(G2tensor(163),[G2tensor(160),G1tensor(142),G1tensor(31),G0tensor(142),G0tensor(2)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(3),G2tensor(164),G2tensor(161),G1tensor(160),G1tensor(49),G0tensor(160) &
    ,G0tensor(5)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(16),G1tensor(150),G1tensor(37),G0tensor(150),G0tensor(3)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(162),G1tensor(170),G1tensor(67),G0tensor(170),G0tensor(8)])
  call ol_merge_tensors(G1tensor(14),[G1tensor(13),G1tensor(91),G0tensor(22),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(187),[G1tensor(32),G1tensor(103),G0tensor(187),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G1tensor(192),[G1tensor(110),G1tensor(109),G0tensor(192),G0tensor(55),G0tensor(15)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(185),G1tensor(6),G0tensor(200),G0tensor(185),G0tensor(18)])
  call ol_merge_tensors(G1tensor(295),[G1tensor(280),G1tensor(235),G1tensor(205),G1tensor(190),G1tensor(87),G1tensor(58) &
    ,G1tensor(102),G1tensor(48),G1tensor(7),G0tensor(295),G0tensor(280),G0tensor(235),G0tensor(205),G0tensor(190),G0tensor(104) &
    ,G0tensor(89),G0tensor(49),G0tensor(34),G0tensor(19)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(85),G1tensor(210),G1tensor(195),G1tensor(39),G1tensor(1),G0tensor(210) &
    ,G0tensor(195),G0tensor(60),G0tensor(20)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(197),G1tensor(24),G0tensor(417),G0tensor(197),G0tensor(23)])
  call ol_merge_tensors(G1tensor(202),[G1tensor(62),G1tensor(18),G0tensor(202),G0tensor(39),G0tensor(24)])
  call ol_merge_tensors(G1tensor(207),[G1tensor(27),G1tensor(20),G0tensor(207),G0tensor(75),G0tensor(25)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(44),G1tensor(36),G0tensor(37),G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G1tensor(422),[G1tensor(212),G1tensor(30),G0tensor(422),G0tensor(212),G0tensor(28)])
  call ol_merge_tensors(G1tensor(217),[G1tensor(15),G1tensor(38),G0tensor(217),G0tensor(65),G0tensor(30)])
  call ol_merge_tensors(G1tensor(225),[G1tensor(215),G1tensor(60),G0tensor(225),G0tensor(215),G0tensor(33)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(86),G1tensor(230),G1tensor(220),G1tensor(21),G1tensor(50),G0tensor(230) &
    ,G0tensor(220),G0tensor(70),G0tensor(35)])
  call ol_merge_tensors(G1tensor(427),[G1tensor(222),G1tensor(56),G0tensor(427),G0tensor(222),G0tensor(38)])
  call ol_merge_tensors(G1tensor(227),[G1tensor(35),G1tensor(68),G0tensor(227),G0tensor(80),G0tensor(40)])
  call ol_merge_tensors(G1tensor(86),[G1tensor(72),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G1tensor(232),[G1tensor(80),G0tensor(232),G0tensor(44)])
  call ol_merge_tensors(G1tensor(177),[G1tensor(165),G1tensor(92),G0tensor(177),G0tensor(165),G0tensor(48)])
  call ol_merge_tensors(G1tensor(343),[G1tensor(328),G1tensor(323),G1tensor(22),G1tensor(3),G1tensor(104),G0tensor(343) &
    ,G0tensor(328),G0tensor(323),G0tensor(72),G0tensor(57),G0tensor(52)])
  call ol_merge_tensors(G1tensor(247),[G1tensor(11),G1tensor(108),G0tensor(247),G0tensor(64),G0tensor(54)])
  call ol_merge_tensors(G1tensor(260),[G1tensor(245),G1tensor(4),G0tensor(260),G0tensor(245),G0tensor(58)])
  call ol_merge_tensors(G1tensor(265),[G1tensor(250),G1tensor(17),G1tensor(5),G0tensor(265),G0tensor(250),G0tensor(69) &
    ,G0tensor(59)])
  call ol_merge_tensors(G1tensor(348),[G1tensor(338),G1tensor(333),G1tensor(29),G1tensor(16),G1tensor(9),G0tensor(348) &
    ,G0tensor(338),G0tensor(333),G0tensor(77),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G1tensor(397),[G1tensor(252),G1tensor(10),G0tensor(397),G0tensor(252),G0tensor(63)])
  call ol_merge_tensors(G1tensor(270),[G1tensor(255),G1tensor(47),G0tensor(270),G0tensor(255),G0tensor(68)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(257),G1tensor(59),G0tensor(402),G0tensor(257),G0tensor(73)])
  call ol_merge_tensors(G1tensor(262),[G1tensor(65),G1tensor(23),G0tensor(262),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(267),G1tensor(33),G0tensor(407),G0tensor(267),G0tensor(78)])
  call ol_merge_tensors(G1tensor(398),[G1tensor(393),G1tensor(82),G1tensor(57),G1tensor(41),G0tensor(398),G0tensor(393) &
    ,G0tensor(92),G0tensor(87),G0tensor(82)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(458),G1tensor(353),G1tensor(272),G1tensor(45),G0tensor(458),G0tensor(353) &
    ,G0tensor(272),G0tensor(83)])
  call ol_merge_tensors(G1tensor(277),[G1tensor(101),G1tensor(52),G0tensor(277),G0tensor(99),G0tensor(84)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(6),G1tensor(483),G1tensor(282),G1tensor(115),G1tensor(46),G0tensor(483) &
    ,G0tensor(282),G0tensor(115),G0tensor(85)])
  call ol_merge_tensors(G1tensor(290),[G1tensor(275),G1tensor(64),G0tensor(290),G0tensor(275),G0tensor(88)])
  call ol_merge_tensors(G1tensor(358),[G1tensor(287),G1tensor(70),G0tensor(358),G0tensor(287),G0tensor(93)])
  call ol_merge_tensors(G1tensor(292),[G1tensor(94),G1tensor(95),G0tensor(292),G0tensor(109),G0tensor(94)])
  call ol_merge_tensors(G1tensor(297),[G1tensor(125),G1tensor(71),G0tensor(297),G0tensor(125),G0tensor(95)])
  call ol_merge_tensors(G1tensor(408),[G1tensor(403),G1tensor(93),G1tensor(107),G1tensor(88),G0tensor(408),G0tensor(403) &
    ,G0tensor(107),G0tensor(102),G0tensor(97)])
  call ol_merge_tensors(G1tensor(363),[G1tensor(302),G1tensor(76),G0tensor(363),G0tensor(302),G0tensor(98)])
  call ol_merge_tensors(G1tensor(307),[G1tensor(130),G1tensor(77),G0tensor(307),G0tensor(130),G0tensor(100)])
  call ol_merge_tensors(G1tensor(315),[G1tensor(305),G1tensor(83),G0tensor(315),G0tensor(305),G0tensor(103)])
  call ol_merge_tensors(G1tensor(368),[G1tensor(312),G1tensor(106),G0tensor(368),G0tensor(312),G0tensor(108)])
  call ol_merge_tensors(G1tensor(317),[G1tensor(140),G1tensor(99),G0tensor(317),G0tensor(140),G0tensor(110)])
  call ol_merge_tensors(G1tensor(253),[G1tensor(248),G1tensor(243),G1tensor(122),G1tensor(117),G1tensor(100),G0tensor(253) &
    ,G0tensor(248),G0tensor(243),G0tensor(122),G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(443),G1tensor(373),G1tensor(322),G1tensor(105),G0tensor(443),G0tensor(373) &
    ,G0tensor(322),G0tensor(113)])
  call ol_merge_tensors(G1tensor(327),[G1tensor(129),G1tensor(111),G0tensor(327),G0tensor(129),G0tensor(114)])
  call ol_merge_tensors(G1tensor(335),[G1tensor(325),G1tensor(118),G0tensor(335),G0tensor(325),G0tensor(118)])
  call ol_merge_tensors(G1tensor(340),[G1tensor(330),G1tensor(134),G1tensor(119),G0tensor(340),G0tensor(330),G0tensor(134) &
    ,G0tensor(119)])
  call ol_merge_tensors(G1tensor(378),[G1tensor(332),G1tensor(123),G0tensor(378),G0tensor(332),G0tensor(123)])
  call ol_merge_tensors(G1tensor(337),[G1tensor(139),G1tensor(124),G0tensor(337),G0tensor(139),G0tensor(124)])
  call ol_merge_tensors(G1tensor(268),[G1tensor(263),G1tensor(258),G1tensor(137),G1tensor(132),G1tensor(127),G0tensor(268) &
    ,G0tensor(263),G0tensor(258),G0tensor(137),G0tensor(132),G0tensor(127)])
  call ol_merge_tensors(G1tensor(383),[G1tensor(342),G1tensor(128),G0tensor(383),G0tensor(342),G0tensor(128)])
  call ol_merge_tensors(G1tensor(350),[G1tensor(345),G1tensor(133),G0tensor(350),G0tensor(345),G0tensor(133)])
  call ol_merge_tensors(G1tensor(388),[G1tensor(347),G1tensor(138),G0tensor(388),G0tensor(347),G0tensor(138)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(143),G0tensor(147),G0tensor(143)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(152),G1tensor(144),G0tensor(152),G0tensor(144)])
  call ol_merge_tensors(G1tensor(157),[G1tensor(145),G0tensor(157),G0tensor(145)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(153),G1tensor(148),G0tensor(153),G0tensor(148)])
  call ol_merge_tensors(G1tensor(158),[G1tensor(149),G0tensor(158),G0tensor(149)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(434),G1tensor(159),G1tensor(154),G0tensor(434),G0tensor(159),G0tensor(154)])
  call ol_merge_tensors(G1tensor(233),[G1tensor(167),G1tensor(163),G0tensor(233),G0tensor(167),G0tensor(163)])
  call ol_merge_tensors(G2tensor(141),[G1tensor(238),G1tensor(172),G1tensor(164),G0tensor(238),G0tensor(172),G0tensor(164)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(173),G1tensor(168),G0tensor(173),G0tensor(168)])
  call ol_merge_tensors(G1tensor(178),[G1tensor(169),G0tensor(178),G0tensor(169)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(179),G1tensor(174),G0tensor(179),G0tensor(174)])
  call ol_merge_tensors(G1tensor(377),[G1tensor(372),G1tensor(213),G1tensor(188),G1tensor(183),G0tensor(377),G0tensor(372) &
    ,G0tensor(213),G0tensor(188),G0tensor(183)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(459),G1tensor(249),G1tensor(219),G1tensor(194),G1tensor(189),G0tensor(459) &
    ,G0tensor(249),G0tensor(219),G0tensor(194),G0tensor(189)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(382),G1tensor(223),G1tensor(203),G1tensor(198),G0tensor(387),G0tensor(382) &
    ,G0tensor(223),G0tensor(203),G0tensor(198)])
  call ol_merge_tensors(G1tensor(259),[G1tensor(208),G1tensor(199),G0tensor(259),G0tensor(208),G0tensor(199)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(464),G1tensor(264),G1tensor(229),G1tensor(209),G1tensor(204),G0tensor(464) &
    ,G0tensor(264),G0tensor(229),G0tensor(209),G0tensor(204)])
  call ol_merge_tensors(G1tensor(254),[G1tensor(218),G1tensor(214),G0tensor(254),G0tensor(218),G0tensor(214)])
  call ol_merge_tensors(G1tensor(269),[G1tensor(228),G1tensor(224),G0tensor(269),G0tensor(228),G0tensor(224)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(469),G1tensor(239),G1tensor(234),G0tensor(469),G0tensor(239),G0tensor(234)])
  call ol_merge_tensors(G1tensor(303),[G1tensor(278),G1tensor(273),G0tensor(303),G0tensor(278),G0tensor(273)])
  call ol_merge_tensors(G1tensor(324),[G1tensor(283),G1tensor(274),G0tensor(324),G0tensor(283),G0tensor(274)])
  call ol_merge_tensors(G1tensor(329),[G1tensor(309),G1tensor(284),G1tensor(279),G0tensor(329),G0tensor(309),G0tensor(284) &
    ,G0tensor(279)])
  call ol_merge_tensors(G1tensor(313),[G1tensor(293),G1tensor(288),G0tensor(313),G0tensor(293),G0tensor(288)])
  call ol_merge_tensors(G1tensor(334),[G1tensor(298),G1tensor(289),G0tensor(334),G0tensor(298),G0tensor(289)])
  call ol_merge_tensors(G1tensor(339),[G1tensor(319),G1tensor(299),G1tensor(294),G0tensor(339),G0tensor(319),G0tensor(299) &
    ,G0tensor(294)])
  call ol_merge_tensors(G1tensor(344),[G1tensor(308),G1tensor(304),G0tensor(344),G0tensor(308),G0tensor(304)])
  call ol_merge_tensors(G1tensor(349),[G1tensor(318),G1tensor(314),G0tensor(349),G0tensor(318),G0tensor(314)])
  call ol_merge_tensors(G1tensor(423),[G1tensor(413),G1tensor(357),G1tensor(352),G0tensor(423),G0tensor(413),G0tensor(357) &
    ,G0tensor(352)])
  call ol_merge_tensors(G1tensor(364),[G1tensor(354),G0tensor(364),G0tensor(354)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(129),G1tensor(473),G1tensor(375),G1tensor(355),G0tensor(473),G0tensor(375) &
    ,G0tensor(355)])
  call ol_merge_tensors(G1tensor(369),[G1tensor(359),G0tensor(369),G0tensor(359)])
  call ol_merge_tensors(G1tensor(380),[G1tensor(360),G0tensor(380),G0tensor(360)])
  call ol_merge_tensors(G1tensor(428),[G1tensor(418),G1tensor(367),G1tensor(362),G0tensor(428),G0tensor(418),G0tensor(367) &
    ,G0tensor(362)])
  call ol_merge_tensors(G1tensor(385),[G1tensor(365),G0tensor(385),G0tensor(365)])
  call ol_merge_tensors(G1tensor(390),[G1tensor(370),G0tensor(390),G0tensor(370)])
  call ol_merge_tensors(G1tensor(384),[G1tensor(374),G0tensor(384),G0tensor(374)])
  call ol_merge_tensors(G1tensor(389),[G1tensor(379),G0tensor(389),G0tensor(379)])
  call ol_merge_tensors(G1tensor(405),[G1tensor(395),G0tensor(405),G0tensor(395)])
  call ol_merge_tensors(G1tensor(424),[G1tensor(399),G0tensor(424),G0tensor(399)])
  call ol_merge_tensors(G1tensor(410),[G1tensor(400),G0tensor(410),G0tensor(400)])
  call ol_merge_tensors(G1tensor(419),[G1tensor(404),G0tensor(419),G0tensor(404)])
  call ol_merge_tensors(G1tensor(429),[G1tensor(409),G0tensor(429),G0tensor(409)])
  call ol_merge_tensors(G1tensor(420),[G1tensor(415),G0tensor(420),G0tensor(415)])
  call ol_merge_tensors(G1tensor(430),[G1tensor(425),G0tensor(430),G0tensor(425)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(7),G1tensor(432),G0tensor(432)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(437),G0tensor(437)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(438),G0tensor(438)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(439),G0tensor(439)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(444),G0tensor(444)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(448),G0tensor(448)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(449),G0tensor(449)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(453),G0tensor(453)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(454),G0tensor(454)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(463),G0tensor(463)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(468),G0tensor(468)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(132),G1tensor(478),G0tensor(478)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(10),G1tensor(488),G0tensor(488)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(17),G3tensor(11),G3tensor(9)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(18),G3tensor(12),G3tensor(10)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(22),G3tensor(14),G3tensor(13)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G3tensor(16),G3tensor(15)])
  call TI_triangle_red(G3tensor(36),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(90),RedBasis(12),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMW], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(17),RedBasis(7),mass3set(:,2),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMW], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(109),RedBasis(43),mass3set(:,3),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMW], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(49),RedBasis(12),mass3set(:,4),G0tensor(101),G0tensor(106),G0tensor(111), &
    G0tensor(116),M2L1R1,[nMW],G0tensor(121))
  call TI_triangle_red(G2tensor(31),RedBasis(15),mass3set(:,5),G0tensor(126),G0tensor(131),G0tensor(136),G0tensor(141),M2L1R1)
  call TI_triangle_red(G3tensor(27),RedBasis(2),mass3set(:,5),G0tensor(146),G0tensor(151),G0tensor(156),G0tensor(161),M2L1R1)
  call TI_triangle_red(G2tensor(27),RedBasis(15),mass3set(:,6),G0tensor(166),G0tensor(171),G0tensor(176), &
    G0tensor(181),M2L1R1,[nMZ],G0tensor(186))
  call TI_triangle_red(G2tensor(21),RedBasis(15),mass3set(:,7),G0tensor(191),G0tensor(196),G0tensor(201), &
    G0tensor(206),M2L1R1,[nMW],G0tensor(211))
  call TI_triangle_red(G2tensor(30),RedBasis(50),mass3set(:,5),G0tensor(216),G0tensor(221),G0tensor(226),G0tensor(231),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(50),mass3set(:,6),G0tensor(236),G0tensor(241),G0tensor(246), &
    G0tensor(251),M2L1R1,[nMZ],G0tensor(256))
  call TI_triangle_red(G2tensor(37),RedBasis(50),mass3set(:,7),G0tensor(261),G0tensor(266),G0tensor(271), &
    G0tensor(276),M2L1R1,[nMW],G0tensor(281))
  call TI_triangle_red(G2tensor(20),RedBasis(45),mass3set(:,5),G0tensor(286),G0tensor(291),G0tensor(296),G0tensor(301),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(7),mass3set(:,5),G0tensor(306),G0tensor(311),G0tensor(316),G0tensor(321),M2L1R1)
  call TI_triangle_red(G2tensor(23),RedBasis(45),mass3set(:,8),G0tensor(326),G0tensor(331),G0tensor(336), &
    G0tensor(341),M2L1R1,[nMZ],G0tensor(346))
  call TI_triangle_red(G2tensor(11),RedBasis(7),mass3set(:,8),G0tensor(351),G0tensor(356),G0tensor(361), &
    G0tensor(366),M2L1R1,[nMZ],G0tensor(371))
  call TI_triangle_red(G2tensor(24),RedBasis(45),mass3set(:,2),G0tensor(376),G0tensor(381),G0tensor(386), &
    G0tensor(391),M2L1R1,[nMW],G0tensor(396))
  call TI_triangle_red(G2tensor(154),RedBasis(47),mass3set(:,5),G0tensor(401),G0tensor(406),G0tensor(411),G0tensor(416),M2L1R1)
  call TI_triangle_red(G2tensor(74),RedBasis(1),mass3set(:,5),G0tensor(421),G0tensor(426),G0tensor(431),G0tensor(436),M2L1R1)
  call TI_triangle_red(G2tensor(157),RedBasis(47),mass3set(:,8),G0tensor(441),G0tensor(446),G0tensor(451), &
    G0tensor(456),M2L1R1,[nMZ],G0tensor(461))
  call TI_triangle_red(G2tensor(100),RedBasis(1),mass3set(:,8),G0tensor(466),G0tensor(471),G0tensor(476), &
    G0tensor(481),M2L1R1,[nMZ],G0tensor(486))
  call TI_triangle_red(G2tensor(163),RedBasis(47),mass3set(:,2),G0tensor(175),G0tensor(155),G0tensor(9),G0tensor(4),M2L1R1,[nMW], &
    G0tensor(435))
  call TI_triangle_red(G2tensor(5),RedBasis(1),mass3set(:,2),G0tensor(440),G0tensor(180),G0tensor(10),G0tensor(237),M2L1R1,[nMW], &
    G0tensor(45))
  call TI_triangle_red(G2tensor(15),RedBasis(4),mass3set(:,3),G0tensor(240),G0tensor(50),G0tensor(442),G0tensor(244),M2L1R1,[nMW], &
    G0tensor(193))
  call TI_triangle_red(G2tensor(144),RedBasis(9),mass3set(:,3),G0tensor(184),G0tensor(489),G0tensor(484), &
    G0tensor(479),M2L1R1,[nMW],G0tensor(474))
  call TI_triangle_red(G2tensor(87),RedBasis(12),mass3set(:,5),G0tensor(470),G0tensor(465),G0tensor(460),G0tensor(455),M2L1R1)
  call TI_triangle_red(G2tensor(88),RedBasis(12),mass3set(:,8),G0tensor(450),G0tensor(445),G0tensor(447), &
    G0tensor(452),M2L1R1,[nMZ],G0tensor(433))
  call TI_triangle_red(G2tensor(46),RedBasis(6),mass3set(:,5),G0tensor(457),G0tensor(414),G0tensor(394),G0tensor(462),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(4),mass3set(:,5),G0tensor(467),G0tensor(472),G0tensor(412),G0tensor(182),M2L1R1)
  call TI_triangle_red(G2tensor(34),RedBasis(11),mass3set(:,5),G0tensor(13),G0tensor(475),G0tensor(300),G0tensor(285),M2L1R1)
  call TI_triangle_red(G2tensor(159),RedBasis(50),mass3set(:,9),G0tensor(120),G0tensor(90),G0tensor(477), &
    G0tensor(480),M2L1R1,[nMW],G0tensor(320))
  call TI_triangle_red(G2tensor(18),RedBasis(6),mass3set(:,2),G0tensor(310),G0tensor(135),G0tensor(105), &
    G0tensor(162),M2L1R1,[nMW],G0tensor(43))
  call TI_triangle_red(G2tensor(2),RedBasis(3),mass3set(:,2),G0tensor(7),G0tensor(482),G0tensor(392),G0tensor(242),M2L1R1,[nMW], &
    G0tensor(53))
  call TI_triangle_red(G2tensor(141),RedBasis(15),mass3set(:,9),G0tensor(485),G0tensor(487),G0tensor(490), &
    G0tensor(142),M2L1R1,[nMW],G0tensor(2))
  call TI_triangle_red(G2tensor(19),RedBasis(11),mass3set(:,2),G0tensor(160),G0tensor(5),G0tensor(150),G0tensor(3),M2L1R1,[nMW], &
    G0tensor(170))
  call TI_triangle_red(G2tensor(4),RedBasis(8),mass3set(:,2),G0tensor(8),G0tensor(22),G0tensor(17),G0tensor(12),M2L1R1,[nMW], &
    G0tensor(187))
  call TI_triangle_red(G2tensor(48),RedBasis(3),mass3set(:,5),G0tensor(29),G0tensor(14),G0tensor(192),G0tensor(55),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(3),mass3set(:,8),G0tensor(15),G0tensor(200),G0tensor(185),G0tensor(18),M2L1R1,[nMZ], &
    G0tensor(295))
  call TI_triangle_red(G2tensor(33),RedBasis(3),mass3set(:,4),G0tensor(280),G0tensor(235),G0tensor(205), &
    G0tensor(190),M2L1R1,[nMW],G0tensor(104))
  call TI_triangle_red(G2tensor(147),RedBasis(9),mass3set(:,5),G0tensor(89),G0tensor(49),G0tensor(34),G0tensor(19),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(43),mass3set(:,10),G0tensor(210),G0tensor(195),G0tensor(60), &
    G0tensor(20),M2L1R1,[nMW],G0tensor(417))
  call TI_triangle_red(G2tensor(22),RedBasis(4),mass3set(:,10),G0tensor(197),G0tensor(23),G0tensor(202),G0tensor(39),M2L1R1,[nMW], &
    G0tensor(24))
  call TI_triangle_red(G2tensor(28),RedBasis(22),mass3set(:,7),G0tensor(207),G0tensor(75),G0tensor(25),G0tensor(37),M2L1R1,[nMW], &
    G0tensor(32))
  call TI_triangle_red(G2tensor(25),RedBasis(20),mass3set(:,2),G0tensor(27),G0tensor(422),G0tensor(212),G0tensor(28),M2L1R1,[nMW], &
    G0tensor(217))
  call TI_triangle_red(G2tensor(36),RedBasis(8),mass3set(:,5),G0tensor(65),G0tensor(30),G0tensor(225),G0tensor(215),M2L1R1)
  call TI_triangle_red(G2tensor(39),RedBasis(11),mass3set(:,8),G0tensor(33),G0tensor(230),G0tensor(220),G0tensor(70),M2L1R1,[nMZ], &
    G0tensor(35))
  call TI_triangle_red(G2tensor(40),RedBasis(8),mass3set(:,8),G0tensor(427),G0tensor(222),G0tensor(38),G0tensor(227),M2L1R1,[nMZ], &
    G0tensor(80))
  call TI_triangle_red(G2tensor(42),RedBasis(11),mass3set(:,4),G0tensor(40),G0tensor(47),G0tensor(42),G0tensor(232),M2L1R1,[nMW], &
    G0tensor(44))
  call TI_triangle_red(G2tensor(45),RedBasis(8),mass3set(:,4),G0tensor(177),G0tensor(165),G0tensor(48),G0tensor(343),M2L1R1,[nMW], &
    G0tensor(328))
  call TI_triangle_red(G2tensor(51),RedBasis(6),mass3set(:,8),G0tensor(323),G0tensor(72),G0tensor(57),G0tensor(52),M2L1R1,[nMZ], &
    G0tensor(247))
  call TI_triangle_red(G2tensor(54),RedBasis(6),mass3set(:,4),G0tensor(64),G0tensor(54),G0tensor(260),G0tensor(245),M2L1R1,[nMW], &
    G0tensor(58))
  call TI_triangle_red(G2tensor(150),RedBasis(9),mass3set(:,11),G0tensor(265),G0tensor(250),G0tensor(69), &
    G0tensor(59),M2L1R1,[nMZ],G0tensor(348))
  call TI_triangle_red(G2tensor(12),RedBasis(4),mass3set(:,11),G0tensor(338),G0tensor(333),G0tensor(77),G0tensor(67),M2L1R1,[nMZ], &
    G0tensor(62))
  call TI_triangle_red(G3tensor(19),RedBasis(2),mass3set(:,12),G0tensor(397),G0tensor(252),G0tensor(63), &
    G0tensor(270),M2L1R1,[nMM],G0tensor(255))
  call TI_triangle_red(G3tensor(20),RedBasis(2),mass3set(:,13),G0tensor(68),G0tensor(402),G0tensor(257),G0tensor(73),M2L1R1,[nML], &
    G0tensor(262))
  call TI_triangle_red(G3tensor(24),RedBasis(2),mass3set(:,14),G0tensor(79),G0tensor(74),G0tensor(407),G0tensor(267),M2L1R1,[nMT], &
    G0tensor(78))
  call TI_triangle_red(G3tensor(28),RedBasis(2),mass3set(:,15),G0tensor(398),G0tensor(393),G0tensor(92),G0tensor(87),M2L1R1,[nMB], &
    G0tensor(82))
  call TI_triangle_red(G2tensor(55),RedBasis(9),mass3set(:,10),G0tensor(458),G0tensor(353),G0tensor(272), &
    G0tensor(83),M2L1R1,[nMW],G0tensor(277))
  call TI_triangle_red(G2tensor(26),RedBasis(45),mass3set(:,4),G0tensor(99),G0tensor(84),G0tensor(483),G0tensor(282),M2L1R1,[nMW], &
    G0tensor(115))
  call TI_triangle_red(G1tensor(14),RedBasis(55),mass3set(:,5),G0tensor(85),G0tensor(290),G0tensor(275),G0tensor(88),M2L1R1)
  call TI_triangle_red(G1tensor(187),RedBasis(44),mass3set(:,5),G0tensor(358),G0tensor(287),G0tensor(93),G0tensor(292),M2L1R1)
  call TI_triangle_red(G1tensor(192),RedBasis(43),mass3set(:,5),G0tensor(109),G0tensor(94),G0tensor(297),G0tensor(125),M2L1R1)
  call TI_triangle_red(G1tensor(200),RedBasis(14),mass3set(:,5),G0tensor(95),G0tensor(408),G0tensor(403),G0tensor(107),M2L1R1)
  call TI_triangle_red(G1tensor(295),RedBasis(13),mass3set(:,5),G0tensor(102),G0tensor(97),G0tensor(363),G0tensor(302),M2L1R1)
  call TI_triangle_red(G1tensor(417),RedBasis(45),mass3set(:,6),G0tensor(98),G0tensor(307),G0tensor(130), &
    G0tensor(100),M2L1R1,[nMZ],G0tensor(315))
  call TI_triangle_red(G1tensor(202),RedBasis(44),mass3set(:,6),G0tensor(305),G0tensor(103),G0tensor(368), &
    G0tensor(312),M2L1R1,[nMZ],G0tensor(108))
  call TI_triangle_red(G1tensor(207),RedBasis(43),mass3set(:,6),G0tensor(317),G0tensor(140),G0tensor(110), &
    G0tensor(253),M2L1R1,[nMZ],G0tensor(248))
  call TI_triangle_red(G1tensor(54),RedBasis(55),mass3set(:,8),G0tensor(243),G0tensor(122),G0tensor(117), &
    G0tensor(112),M2L1R1,[nMZ],G0tensor(443))
  call TI_triangle_red(G1tensor(422),RedBasis(45),mass3set(:,11),G0tensor(373),G0tensor(322),G0tensor(113), &
    G0tensor(327),M2L1R1,[nMZ],G0tensor(129))
  call TI_triangle_red(G1tensor(217),RedBasis(43),mass3set(:,8),G0tensor(114),G0tensor(335),G0tensor(325), &
    G0tensor(118),M2L1R1,[nMZ],G0tensor(340))
  call TI_triangle_red(G1tensor(225),RedBasis(14),mass3set(:,11),G0tensor(330),G0tensor(134),G0tensor(119), &
    G0tensor(378),M2L1R1,[nMZ],G0tensor(332))
  call TI_triangle_red(G1tensor(427),RedBasis(45),mass3set(:,16),G0tensor(123),G0tensor(337),G0tensor(139), &
    G0tensor(124),M2L1R1,[nMZ],G0tensor(268))
  call TI_triangle_red(G1tensor(227),RedBasis(43),mass3set(:,17),G0tensor(263),G0tensor(258),G0tensor(137), &
    G0tensor(132),M2L1R1,[nMZ],G0tensor(127))
  call TI_triangle_red(G1tensor(86),RedBasis(55),mass3set(:,4),G0tensor(383),G0tensor(342),G0tensor(128), &
    G0tensor(350),M2L1R1,[nMW],G0tensor(345))
  call TI_triangle_red(G1tensor(232),RedBasis(44),mass3set(:,7),G0tensor(133),G0tensor(388),G0tensor(347), &
    G0tensor(138),M2L1R1,[nMW],G0tensor(147))
  call TI_triangle_red(G1tensor(177),RedBasis(14),mass3set(:,10),G0tensor(143),G0tensor(152),G0tensor(144), &
    G0tensor(157),M2L1R1,[nMW],G0tensor(145))
  call TI_triangle_red(G1tensor(343),RedBasis(26),mass3set(:,5),G0tensor(153),G0tensor(148),G0tensor(158),G0tensor(149),M2L1R1)
  call TI_triangle_red(G1tensor(247),RedBasis(46),mass3set(:,5),G0tensor(434),G0tensor(159),G0tensor(154),G0tensor(233),M2L1R1)
  call TI_triangle_red(G1tensor(260),RedBasis(18),mass3set(:,5),G0tensor(167),G0tensor(163),G0tensor(238),G0tensor(172),M2L1R1)
  call TI_triangle_red(G1tensor(265),RedBasis(17),mass3set(:,5),G0tensor(164),G0tensor(173),G0tensor(168),G0tensor(178),M2L1R1)
  call TI_triangle_red(G1tensor(348),RedBasis(26),mass3set(:,8),G0tensor(169),G0tensor(179),G0tensor(174), &
    G0tensor(377),M2L1R1,[nMZ],G0tensor(372))
  call TI_triangle_red(G1tensor(397),RedBasis(47),mass3set(:,11),G0tensor(213),G0tensor(188),G0tensor(183), &
    G0tensor(459),M2L1R1,[nMZ],G0tensor(249))
  call TI_triangle_red(G1tensor(270),RedBasis(18),mass3set(:,11),G0tensor(219),G0tensor(194),G0tensor(189), &
    G0tensor(387),M2L1R1,[nMZ],G0tensor(382))
  call TI_triangle_red(G1tensor(402),RedBasis(47),mass3set(:,6),G0tensor(223),G0tensor(203),G0tensor(198), &
    G0tensor(259),M2L1R1,[nMZ],G0tensor(208))
  call TI_triangle_red(G1tensor(262),RedBasis(46),mass3set(:,6),G0tensor(199),G0tensor(464),G0tensor(264), &
    G0tensor(229),M2L1R1,[nMZ],G0tensor(209))
  call TI_triangle_red(G1tensor(407),RedBasis(47),mass3set(:,16),G0tensor(204),G0tensor(254),G0tensor(218), &
    G0tensor(214),M2L1R1,[nMZ],G0tensor(269))
  call TI_triangle_red(G1tensor(398),RedBasis(51),mass3set(:,5),G0tensor(228),G0tensor(224),G0tensor(469),G0tensor(239),M2L1R1)
  call TI_triangle_red(G1tensor(277),RedBasis(5),mass3set(:,5),G0tensor(234),G0tensor(303),G0tensor(278),G0tensor(273),M2L1R1)
  call TI_triangle_red(G1tensor(290),RedBasis(21),mass3set(:,5),G0tensor(324),G0tensor(283),G0tensor(274),G0tensor(329),M2L1R1)
  call TI_triangle_red(G1tensor(358),RedBasis(6),mass3set(:,6),G0tensor(309),G0tensor(284),G0tensor(279), &
    G0tensor(313),M2L1R1,[nMZ],G0tensor(293))
  call TI_triangle_red(G1tensor(292),RedBasis(5),mass3set(:,6),G0tensor(288),G0tensor(334),G0tensor(298), &
    G0tensor(289),M2L1R1,[nMZ],G0tensor(339))
  call TI_triangle_red(G1tensor(297),RedBasis(4),mass3set(:,6),G0tensor(319),G0tensor(299),G0tensor(294), &
    G0tensor(344),M2L1R1,[nMZ],G0tensor(308))
  call TI_triangle_red(G1tensor(408),RedBasis(51),mass3set(:,8),G0tensor(304),G0tensor(349),G0tensor(318), &
    G0tensor(314),M2L1R1,[nMZ],G0tensor(423))
  call TI_triangle_red(G1tensor(363),RedBasis(6),mass3set(:,11),G0tensor(413),G0tensor(357),G0tensor(352), &
    G0tensor(364),M2L1R1,[nMZ],G0tensor(354))
  call TI_triangle_red(G1tensor(307),RedBasis(4),mass3set(:,8),G0tensor(473),G0tensor(375),G0tensor(355), &
    G0tensor(369),M2L1R1,[nMZ],G0tensor(359))
  call TI_triangle_red(G1tensor(315),RedBasis(21),mass3set(:,11),G0tensor(380),G0tensor(360),G0tensor(428), &
    G0tensor(418),M2L1R1,[nMZ],G0tensor(367))
  call TI_triangle_red(G1tensor(368),RedBasis(6),mass3set(:,16),G0tensor(362),G0tensor(385),G0tensor(365), &
    G0tensor(390),M2L1R1,[nMZ],G0tensor(370))
  call TI_triangle_red(G1tensor(317),RedBasis(4),mass3set(:,17),G0tensor(384),G0tensor(374),G0tensor(389), &
    G0tensor(379),M2L1R1,[nMZ],G0tensor(405))
  call TI_triangle_red(G1tensor(253),RedBasis(19),mass3set(:,5),G0tensor(395),G0tensor(424),G0tensor(399),G0tensor(410),M2L1R1)
  call TI_triangle_red(G1tensor(327),RedBasis(48),mass3set(:,5),G0tensor(400),G0tensor(419),G0tensor(404),G0tensor(429),M2L1R1)
  call TI_triangle_red(G1tensor(335),RedBasis(25),mass3set(:,5),G0tensor(409),G0tensor(420),G0tensor(415),G0tensor(430),M2L1R1)
  call TI_triangle_red(G1tensor(340),RedBasis(24),mass3set(:,5),G0tensor(425),G0tensor(432),G0tensor(437),G0tensor(438),M2L1R1)
  call TI_triangle_red(G1tensor(378),RedBasis(11),mass3set(:,6),G0tensor(439),G0tensor(444),G0tensor(448), &
    G0tensor(449),M2L1R1,[nMZ],G0tensor(453))
  call TI_triangle_red(G1tensor(337),RedBasis(48),mass3set(:,6),G0tensor(454),G0tensor(463),G0tensor(468), &
    G0tensor(478),M2L1R1,[nMZ],G0tensor(488))
  call TI_triangle_red(G1tensor(268),RedBasis(19),mass3set(:,8),G0tensor(491),G0tensor(492),G0tensor(493), &
    G0tensor(494),M2L1R1,[nMZ],G0tensor(495))
  call TI_triangle_red(G1tensor(383),RedBasis(11),mass3set(:,11),G0tensor(496),G0tensor(497),G0tensor(498), &
    G0tensor(499),M2L1R1,[nMZ],G0tensor(500))
  call TI_triangle_red(G1tensor(350),RedBasis(25),mass3set(:,11),G0tensor(501),G0tensor(502),G0tensor(503), &
    G0tensor(504),M2L1R1,[nMZ],G0tensor(505))
  call TI_triangle_red(G1tensor(388),RedBasis(11),mass3set(:,16),G0tensor(506),G0tensor(507),G0tensor(508), &
    G0tensor(509),M2L1R1,[nMZ],G0tensor(510))
  call TI_triangle_red(G1tensor(147),RedBasis(51),mass3set(:,4),G0tensor(511),G0tensor(512),G0tensor(513), &
    G0tensor(514),M2L1R1,[nMW],G0tensor(515))
  call TI_triangle_red(G1tensor(157),RedBasis(49),mass3set(:,10),G0tensor(516),G0tensor(517),G0tensor(518), &
    G0tensor(519),M2L1R1,[nMW],G0tensor(520))
  call TI_triangle_red(G1tensor(158),RedBasis(5),mass3set(:,7),G0tensor(521),G0tensor(522),G0tensor(523), &
    G0tensor(524),M2L1R1,[nMW],G0tensor(525))
  call TI_triangle_red(G1tensor(233),RedBasis(16),mass3set(:,4),G0tensor(526),G0tensor(527),G0tensor(528), &
    G0tensor(529),M2L1R1,[nMW],G0tensor(530))
  call TI_triangle_red(G1tensor(178),RedBasis(10),mass3set(:,7),G0tensor(531),G0tensor(532),G0tensor(533), &
    G0tensor(534),M2L1R1,[nMW],G0tensor(535))
  call TI_triangle_red(G1tensor(377),RedBasis(16),mass3set(:,5),G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),M2L1R1)
  call TI_triangle_red(G1tensor(387),RedBasis(16),mass3set(:,8),G0tensor(540),G0tensor(541),G0tensor(542), &
    G0tensor(543),M2L1R1,[nMZ],G0tensor(544))
  call TI_triangle_red(G1tensor(259),RedBasis(15),mass3set(:,8),G0tensor(545),G0tensor(546),G0tensor(547), &
    G0tensor(548),M2L1R1,[nMZ],G0tensor(549))
  call TI_triangle_red(G1tensor(254),RedBasis(15),mass3set(:,11),G0tensor(550),G0tensor(551),G0tensor(552), &
    G0tensor(553),M2L1R1,[nMZ],G0tensor(554))
  call TI_triangle_red(G1tensor(269),RedBasis(15),mass3set(:,18),G0tensor(555),G0tensor(556),G0tensor(557), &
    G0tensor(558),M2L1R1,[nMZ],G0tensor(559))
  call TI_triangle_red(G1tensor(303),RedBasis(23),mass3set(:,5),G0tensor(560),G0tensor(561),G0tensor(562),G0tensor(563),M2L1R1)
  call TI_triangle_red(G1tensor(324),RedBasis(22),mass3set(:,5),G0tensor(564),G0tensor(565),G0tensor(566),G0tensor(567),M2L1R1)
  call TI_triangle_red(G1tensor(329),RedBasis(20),mass3set(:,5),G0tensor(568),G0tensor(569),G0tensor(570),G0tensor(571),M2L1R1)
  call TI_triangle_red(G1tensor(313),RedBasis(23),mass3set(:,8),G0tensor(572),G0tensor(573),G0tensor(574), &
    G0tensor(575),M2L1R1,[nMZ],G0tensor(576))
  call TI_triangle_red(G1tensor(334),RedBasis(22),mass3set(:,8),G0tensor(577),G0tensor(578),G0tensor(579), &
    G0tensor(580),M2L1R1,[nMZ],G0tensor(581))
  call TI_triangle_red(G1tensor(339),RedBasis(20),mass3set(:,8),G0tensor(582),G0tensor(583),G0tensor(584), &
    G0tensor(585),M2L1R1,[nMZ],G0tensor(586))
  call TI_triangle_red(G1tensor(344),RedBasis(22),mass3set(:,11),G0tensor(587),G0tensor(588),G0tensor(589), &
    G0tensor(590),M2L1R1,[nMZ],G0tensor(591))
  call TI_triangle_red(G1tensor(349),RedBasis(22),mass3set(:,18),G0tensor(592),G0tensor(593),G0tensor(594), &
    G0tensor(595),M2L1R1,[nMZ],G0tensor(596))
  call TI_triangle_red(G1tensor(423),RedBasis(54),mass3set(:,5),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600),M2L1R1)
  call TI_triangle_red(G1tensor(364),RedBasis(52),mass3set(:,5),G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),M2L1R1)
  call TI_triangle_red(G1tensor(369),RedBasis(52),mass3set(:,6),G0tensor(605),G0tensor(606),G0tensor(607), &
    G0tensor(608),M2L1R1,[nMZ],G0tensor(609))
  call TI_triangle_red(G1tensor(380),RedBasis(9),mass3set(:,6),G0tensor(610),G0tensor(611),G0tensor(612), &
    G0tensor(613),M2L1R1,[nMZ],G0tensor(614))
  call TI_triangle_red(G1tensor(428),RedBasis(54),mass3set(:,8),G0tensor(615),G0tensor(616),G0tensor(617), &
    G0tensor(618),M2L1R1,[nMZ],G0tensor(619))
  call TI_triangle_red(G1tensor(385),RedBasis(9),mass3set(:,8),G0tensor(620),G0tensor(621),G0tensor(622), &
    G0tensor(623),M2L1R1,[nMZ],G0tensor(624))
  call TI_triangle_red(G1tensor(390),RedBasis(9),mass3set(:,17),G0tensor(625),G0tensor(626),G0tensor(627), &
    G0tensor(628),M2L1R1,[nMZ],G0tensor(629))
  call TI_triangle_red(G1tensor(384),RedBasis(10),mass3set(:,5),G0tensor(630),G0tensor(631),G0tensor(632),G0tensor(633),M2L1R1)
  call TI_triangle_red(G1tensor(389),RedBasis(10),mass3set(:,6),G0tensor(634),G0tensor(635),G0tensor(636), &
    G0tensor(637),M2L1R1,[nMZ],G0tensor(638))
  call TI_triangle_red(G1tensor(405),RedBasis(49),mass3set(:,5),G0tensor(639),G0tensor(640),G0tensor(641),G0tensor(642),M2L1R1)
  call TI_triangle_red(G1tensor(424),RedBasis(50),mass3set(:,11),G0tensor(643),G0tensor(644),G0tensor(645), &
    G0tensor(646),M2L1R1,[nMZ],G0tensor(647))
  call TI_triangle_red(G1tensor(410),RedBasis(49),mass3set(:,11),G0tensor(648),G0tensor(649),G0tensor(650), &
    G0tensor(651),M2L1R1,[nMZ],G0tensor(652))
  call TI_triangle_red(G1tensor(419),RedBasis(50),mass3set(:,8),G0tensor(653),G0tensor(654),G0tensor(655), &
    G0tensor(656),M2L1R1,[nMZ],G0tensor(657))
  call TI_triangle_red(G1tensor(429),RedBasis(50),mass3set(:,18),G0tensor(658),G0tensor(659),G0tensor(660), &
    G0tensor(661),M2L1R1,[nMZ],G0tensor(662))
  call TI_triangle_red(G1tensor(420),RedBasis(53),mass3set(:,5),G0tensor(663),G0tensor(664),G0tensor(665),G0tensor(666),M2L1R1)
  call TI_triangle_red(G1tensor(430),RedBasis(53),mass3set(:,11),G0tensor(667),G0tensor(668),G0tensor(669), &
    G0tensor(670),M2L1R1,[nMZ],G0tensor(671))
  call ol_merge_tensors(T0sum(99),[G0tensor(1)])
  call ol_merge_tensors(T0sum(100),[G0tensor(26)])
  call ol_merge_tensors(T0sum(101),[G0tensor(51)])
  call ol_merge_tensors(T0sum(102),[G0tensor(76)])
  call ol_merge_tensors(T0sum(103),[G0tensor(101)])
  call ol_merge_tensors(T0sum(104),[G0tensor(126)])
  call ol_merge_tensors(T0sum(105),[G0tensor(146)])
  call ol_merge_tensors(T0sum(106),[G0tensor(166)])
  call ol_merge_tensors(T0sum(107),[G0tensor(191)])
  call ol_merge_tensors(T0sum(108),[G0tensor(216)])
  call ol_merge_tensors(T0sum(109),[G0tensor(236)])
  call ol_merge_tensors(T0sum(110),[G0tensor(261)])
  call ol_merge_tensors(T0sum(111),[G0tensor(286)])
  call ol_merge_tensors(T0sum(112),[G0tensor(306)])
  call ol_merge_tensors(T0sum(113),[G0tensor(326)])
  call ol_merge_tensors(T0sum(114),[G0tensor(351)])
  call ol_merge_tensors(T0sum(115),[G0tensor(376)])
  call ol_merge_tensors(T0sum(116),[G0tensor(401)])
  call ol_merge_tensors(T0sum(117),[G0tensor(421)])
  call ol_merge_tensors(T0sum(118),[G0tensor(441)])
  call ol_merge_tensors(T0sum(119),[G0tensor(466)])
  call ol_merge_tensors(T0sum(120),[G0tensor(175)])
  call ol_merge_tensors(T0sum(121),[G0tensor(440)])
  call ol_merge_tensors(T0sum(122),[G0tensor(240)])
  call ol_merge_tensors(T0sum(123),[G0tensor(184)])
  call ol_merge_tensors(T0sum(124),[G0tensor(85)])
  call ol_merge_tensors(T0sum(125),[G0tensor(358)])
  call ol_merge_tensors(T0sum(126),[G0tensor(109)])
  call ol_merge_tensors(T0sum(127),[G0tensor(95)])
  call ol_merge_tensors(T0sum(128),[G0tensor(102)])
  call ol_merge_tensors(T0sum(129),[G0tensor(470)])
  call ol_merge_tensors(T0sum(130),[G0tensor(98)])
  call ol_merge_tensors(T0sum(131),[G0tensor(305)])
  call ol_merge_tensors(T0sum(132),[G0tensor(317)])
  call ol_merge_tensors(T0sum(133),[G0tensor(243)])
  call ol_merge_tensors(T0sum(134),[G0tensor(373)])
  call ol_merge_tensors(T0sum(135),[G0tensor(114)])
  call ol_merge_tensors(T0sum(136),[G0tensor(330)])
  call ol_merge_tensors(T0sum(137),[G0tensor(450)])
  call ol_merge_tensors(T0sum(138),[G0tensor(123)])
  call ol_merge_tensors(T0sum(139),[G0tensor(263)])
  call ol_merge_tensors(T0sum(140),[G0tensor(383)])
  call ol_merge_tensors(T0sum(141),[G0tensor(133)])
  call ol_merge_tensors(T0sum(142),[G0tensor(143)])
  call ol_merge_tensors(T0sum(143),[G0tensor(153)])
  call ol_merge_tensors(T0sum(144),[G0tensor(434)])
  call ol_merge_tensors(T0sum(145),[G0tensor(167)])
  call ol_merge_tensors(T0sum(146),[G0tensor(164)])
  call ol_merge_tensors(T0sum(147),[G0tensor(169)])
  call ol_merge_tensors(T0sum(148),[G0tensor(213)])
  call ol_merge_tensors(T0sum(149),[G0tensor(219)])
  call ol_merge_tensors(T0sum(150),[G0tensor(223)])
  call ol_merge_tensors(T0sum(151),[G0tensor(199)])
  call ol_merge_tensors(T0sum(152),[G0tensor(204)])
  call ol_merge_tensors(T0sum(153),[G0tensor(228)])
  call ol_merge_tensors(T0sum(154),[G0tensor(457)])
  call ol_merge_tensors(T0sum(155),[G0tensor(234)])
  call ol_merge_tensors(T0sum(156),[G0tensor(467)])
  call ol_merge_tensors(T0sum(157),[G0tensor(324)])
  call ol_merge_tensors(T0sum(158),[G0tensor(309)])
  call ol_merge_tensors(T0sum(159),[G0tensor(288)])
  call ol_merge_tensors(T0sum(160),[G0tensor(319)])
  call ol_merge_tensors(T0sum(161),[G0tensor(304)])
  call ol_merge_tensors(T0sum(162),[G0tensor(413)])
  call ol_merge_tensors(T0sum(163),[G0tensor(473)])
  call ol_merge_tensors(T0sum(164),[G0tensor(380)])
  call ol_merge_tensors(T0sum(165),[G0tensor(362)])
  call ol_merge_tensors(T0sum(166),[G0tensor(384)])
  call ol_merge_tensors(T0sum(167),[G0tensor(395)])
  call ol_merge_tensors(T0sum(168),[G0tensor(13)])
  call ol_merge_tensors(T0sum(169),[G0tensor(400)])
  call ol_merge_tensors(T0sum(170),[G0tensor(409)])
  call ol_merge_tensors(T0sum(171),[G0tensor(425)])
  call ol_merge_tensors(T0sum(172),[G0tensor(439)])
  call ol_merge_tensors(T0sum(173),[G0tensor(454)])
  call ol_merge_tensors(T0sum(174),[G0tensor(491)])
  call ol_merge_tensors(T0sum(175),[G0tensor(496)])
  call ol_merge_tensors(T0sum(176),[G0tensor(501)])
  call ol_merge_tensors(T0sum(177),[G0tensor(506)])
  call ol_merge_tensors(T0sum(178),[G0tensor(511)])
  call ol_merge_tensors(T0sum(179),[G0tensor(120)])
  call ol_merge_tensors(T0sum(180),[G0tensor(516)])
  call ol_merge_tensors(T0sum(181),[G0tensor(310)])
  call ol_merge_tensors(T0sum(182),[G0tensor(521)])
  call ol_merge_tensors(T0sum(183),[G0tensor(7)])
  call ol_merge_tensors(T0sum(184),[G0tensor(526)])
  call ol_merge_tensors(T0sum(185),[G0tensor(485)])
  call ol_merge_tensors(T0sum(186),[G0tensor(160)])
  call ol_merge_tensors(T0sum(187),[G0tensor(531)])
  call ol_merge_tensors(T0sum(188),[G0tensor(8)])
  call ol_merge_tensors(T0sum(189),[G0tensor(536)])
  call ol_merge_tensors(T0sum(190),[G0tensor(29)])
  call ol_merge_tensors(T0sum(191),[G0tensor(540)])
  call ol_merge_tensors(T0sum(192),[G0tensor(545)])
  call ol_merge_tensors(T0sum(193),[G0tensor(15)])
  call ol_merge_tensors(T0sum(194),[G0tensor(550)])
  call ol_merge_tensors(T0sum(195),[G0tensor(555)])
  call ol_merge_tensors(T0sum(196),[G0tensor(280)])
  call ol_merge_tensors(T0sum(197),[G0tensor(560)])
  call ol_merge_tensors(T0sum(198),[G0tensor(564)])
  call ol_merge_tensors(T0sum(199),[G0tensor(568)])
  call ol_merge_tensors(T0sum(200),[G0tensor(572)])
  call ol_merge_tensors(T0sum(201),[G0tensor(577)])
  call ol_merge_tensors(T0sum(202),[G0tensor(582)])
  call ol_merge_tensors(T0sum(203),[G0tensor(587)])
  call ol_merge_tensors(T0sum(204),[G0tensor(592)])
  call ol_merge_tensors(T0sum(205),[G0tensor(597)])
  call ol_merge_tensors(T0sum(206),[G0tensor(601)])
  call ol_merge_tensors(T0sum(207),[G0tensor(89)])
  call ol_merge_tensors(T0sum(208),[G0tensor(605)])
  call ol_merge_tensors(T0sum(209),[G0tensor(610)])
  call ol_merge_tensors(T0sum(210),[G0tensor(615)])
  call ol_merge_tensors(T0sum(211),[G0tensor(620)])
  call ol_merge_tensors(T0sum(212),[G0tensor(625)])
  call ol_merge_tensors(T0sum(213),[G0tensor(630)])
  call ol_merge_tensors(T0sum(214),[G0tensor(634)])
  call ol_merge_tensors(T0sum(215),[G0tensor(639)])
  call ol_merge_tensors(T0sum(216),[G0tensor(643)])
  call ol_merge_tensors(T0sum(217),[G0tensor(648)])
  call ol_merge_tensors(T0sum(218),[G0tensor(653)])
  call ol_merge_tensors(T0sum(219),[G0tensor(658)])
  call ol_merge_tensors(T0sum(220),[G0tensor(663)])
  call ol_merge_tensors(T0sum(221),[G0tensor(667)])
  call ol_merge_tensors(T0sum(222),[G0tensor(210)])
  call ol_merge_tensors(T0sum(223),[G0tensor(197)])
  call ol_merge_tensors(T0sum(224),[G0tensor(207)])
  call ol_merge_tensors(T0sum(225),[G0tensor(27)])
  call ol_merge_tensors(T0sum(226),[G0tensor(65)])
  call ol_merge_tensors(T0sum(227),[G0tensor(33)])
  call ol_merge_tensors(T0sum(228),[G0tensor(427)])
  call ol_merge_tensors(T0sum(229),[G0tensor(40)])
  call ol_merge_tensors(T0sum(230),[G0tensor(177)])
  call ol_merge_tensors(T0sum(231),[G0tensor(323)])
  call ol_merge_tensors(T0sum(232),[G0tensor(64)])
  call ol_merge_tensors(T0sum(233),[G0tensor(265)])
  call ol_merge_tensors(T0sum(234),[G0tensor(338)])
  call ol_merge_tensors(T0sum(235),[G0tensor(397)])
  call ol_merge_tensors(T0sum(236),[G0tensor(68)])
  call ol_merge_tensors(T0sum(237),[G0tensor(79)])
  call ol_merge_tensors(T0sum(238),[G0tensor(398)])
  call ol_merge_tensors(T0sum(239),[G0tensor(458)])
  call ol_merge_tensors(T0sum(240),[G0tensor(99)])
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,225),heltab2x32(:,:,321))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,226),heltab2x32(:,:,322))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,227),heltab2x32(:,:,323))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,228),heltab2x32(:,:,324))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,229),heltab2x32(:,:,325))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,230),heltab2x32(:,:,326))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,231),heltab2x32(:,:,327))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,232),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[28,3],[nMW,nMW],3,2,wf4(:,8),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(17),m4h2x4x4(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[28,3],[nMW,nMW],3,2,wf4(:,10),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,10),G0H4(13),m4h2x4x4(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[28,3],[nMW,nMW],3,2,wf4(:,8),wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(9),m4h2x4x4(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[28,3],[nMW,nMW],3,2,wf4(:,10),wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,10),G0H4(15),m4h2x4x4(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[28,3],[nMW,nMW],3,2,wf4(:,8),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(11),m4h2x4x4(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[28,3],[nMW,nMW],3,2,wf4(:,10),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,10),G0H4(14),m4h2x4x4(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[28,3],[nMW,nMW],3,2,wf4(:,8),wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(10),m4h2x4x4(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[28,3],[nMW,nMW],3,2,wf4(:,10),wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,10),G0H4(16),m4h2x4x4(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(12),m4h2x4x4(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,4),G0H4(1),m4h2x4x4(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,4),G0H4(6),m4h2x4x4(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,8))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(4),m4h2x4x4(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(7),m4h2x4x4(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,8))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,4),G0H4(5),m4h2x4x4(:,19),heltab3x32(:,:,19))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,4),G0H4(8),m4h2x4x4(:,20),heltab3x32(:,:,20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[20,11],[0,0],2,2,wf4(:,3),wf8(:,27))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,67),heltab2x32(:,:,329))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[20,11],[nMZ,0],2,2,wf4(:,3),wf8(:,27))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZu,m3h4x8(:,68),heltab2x32(:,:,330))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[20,11],[nMW,0],2,2,wf4(:,3),wf8(:,27))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,69),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[20,11],[0,0],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(11),m3h4x8(:,70),heltab2x32(:,:,332))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[20,11],[nMZ,0],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(12),ngZu,m3h4x8(:,71),heltab2x32(:,:,333))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[20,11],[nMW,0],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,72),heltab2x32(:,:,334))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[28,3],[0,0],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,31),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(29),n2h4(144))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[28,3],[nMM,nMM],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,32),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(30),n2h4(145))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[28,3],[nML,nML],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,33),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(2),28,nML,G1H4(31),n2h4(146))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[28,3],[0,0],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,34),heltab2x32(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(49),n2h4(147))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[28,3],[nMT,nMT],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,35),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(52),n2h4(148))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[28,3],[0,0],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,36),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(53),n2h4(149))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[28,3],[nMB,nMB],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,37),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(69),n2h4(150))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[28,3],[0,0],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZl,m3h8x4(:,38),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(2),n2h4(151))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[28,3],[nMM,nMM],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZl,m3h8x4(:,39),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(17),n2h4(152))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[28,3],[nML,nML],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZl,m3h8x4(:,40),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(2),28,nML,G1H4(5),n2h4(153))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[28,3],[0,0],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZu,m3h8x4(:,41),heltab2x32(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(16),n2h4(154))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[28,3],[nMT,nMT],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZu,m3h8x4(:,42),heltab2x32(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(22),n2h4(155))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[28,3],[0,0],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZd,m3h8x4(:,43),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(28),n2h4(156))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[28,3],[nMB,nMB],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZd,m3h8x4(:,44),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(23),n2h4(157))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[28,3],[0,0],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,45),heltab2x32(:,:,349))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(27),n2h4(158))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[28,3],[nMM,nMM],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,46),heltab2x32(:,:,350))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(32),n2h4(159))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[28,3],[nML,nML],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,47),heltab2x32(:,:,351))
  call Hloop_Q_A(ntryL,G0H4(2),28,nML,G1H4(33),n2h4(160))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[28,3],[0,0],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,48),heltab2x32(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(37),n2h4(161))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[28,3],[nMT,nMT],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,49),heltab2x32(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(38),n2h4(162))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[28,3],[0,0],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,50),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(4),n2h4(163))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[28,3],[nMB,nMB],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,51),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(44),n2h4(164))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[28,3],[0,0],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZn,m3h8x4(:,52),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(10),n2h4(165))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[28,3],[0,0],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZl,m3h8x4(:,53),heltab2x32(:,:,357))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(43),n2h4(166))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[28,3],[nMM,nMM],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZl,m3h8x4(:,54),heltab2x32(:,:,358))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMM,G1H4(50),n2h4(167))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[28,3],[nML,nML],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZl,m3h8x4(:,55),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H4(2),28,nML,G1H4(56),n2h4(168))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[28,3],[0,0],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZu,m3h8x4(:,56),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(51),n2h4(169))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[28,3],[nMT,nMT],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZu,m3h8x4(:,57),heltab2x32(:,:,361))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(55),n2h4(170))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[28,3],[0,0],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZd,m3h8x4(:,58),heltab2x32(:,:,362))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(58),n2h4(171))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[28,3],[nMB,nMB],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,26),G0H4(2),ngZd,m3h8x4(:,59),heltab2x32(:,:,363))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(59),n2h4(172))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(63),m3h8x4(:,60),heltab2x32(:,:,364))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(64),m3h8x4(:,61),heltab2x32(:,:,365))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(62),m3h8x4(:,62),heltab2x32(:,:,366))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[28,3],[nMH,nMZ],2,2,wf8(:,26),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(48),m3h8x4(:,63),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(47),m3h8x4(:,64),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(45),m3h8x4(:,65),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(19),m3h8x4(:,66),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(34),m3h8x4(:,67),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(61),m3h8x4(:,68),heltab2x32(:,:,372))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(60),m3h8x4(:,69),heltab2x32(:,:,373))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(40),m3h8x4(:,70),heltab2x32(:,:,374))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(6),m3h8x4(:,71),heltab2x32(:,:,375))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(20),m3h8x4(:,72),heltab2x32(:,:,376))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(35),m3h8x4(:,73),heltab2x32(:,:,377))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(18),m3h8x4(:,74),heltab2x32(:,:,378))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(46),m3h8x4(:,75),heltab2x32(:,:,379))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(36),m3h8x4(:,76),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,25),G0H4(2),m3h8x4(:,77),heltab2x32(:,:,381))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,25),G0H4(18),m3h8x4(:,78),heltab2x32(:,:,382))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(19),m3h8x4(:,79),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(20),m3h8x4(:,80),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,25),G0H4(21),m3h8x4(:,81),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,25),G0H4(22),m3h8x4(:,82),heltab2x32(:,:,386))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[28,3],[nMH,nMZ],2,2,wf8(:,26),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(23),m3h8x4(:,83),heltab2x32(:,:,387))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(24),m3h8x4(:,84),heltab2x32(:,:,388))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(25),m3h8x4(:,85),heltab2x32(:,:,389))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[24,7],[0,0],2,2,wf4(:,6),wf8(:,31))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(7),m3h4x8(:,73),heltab2x32(:,:,390))
  call Hloop_A_Q(ntryL,G0H8(7),24,0,G1H8(16),n2h8(57))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[24,7],[0,nMZ],2,2,wf4(:,6),wf8(:,31))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngZu,m3h4x8(:,74),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G0H8(14),24,0,G1H8(18),n2h8(58))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[24,7],[0,nMW],2,2,wf4(:,6),wf8(:,31))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,75),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H8(15),24,0,G1H8(19),n2h8(59))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[24,7],[0,0],2,2,wf4(:,6),wf8(:,32))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,76),heltab2x32(:,:,393))
  call Hloop_A_Q(ntryL,G0H8(16),24,0,G1H8(21),n2h8(60))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[24,7],[0,nMZ],2,2,wf4(:,6),wf8(:,32))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(17),ngZu,m3h4x8(:,77),heltab2x32(:,:,394))
  call Hloop_A_Q(ntryL,G0H8(17),24,0,G1H8(22),n2h8(61))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[24,7],[0,nMW],2,2,wf4(:,6),wf8(:,32))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(18),m3h4x8(:,78),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G0H8(18),24,0,G1H8(23),n2h8(62))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[28,3],[0,0],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,86),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(9),n2h4(173))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[28,3],[nMM,nMM],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,87),heltab2x32(:,:,397))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMM,G1H4(57),n2h4(174))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[28,3],[nML,nML],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,88),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H4(26),28,nML,G1H4(42),n2h4(175))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[28,3],[0,0],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,89),heltab2x32(:,:,399))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(39),n2h4(176))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[28,3],[nMT,nMT],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,90),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMT,G1H4(3),n2h4(177))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[28,3],[0,0],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,91),heltab2x32(:,:,401))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(7),n2h4(178))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[28,3],[nMB,nMB],2,2,wf8(:,29),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,92),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMB,G1H4(8),n2h4(179))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[28,3],[0,0],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZl,m3h8x4(:,93),heltab2x32(:,:,403))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(11),n2h4(180))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[28,3],[nMM,nMM],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZl,m3h8x4(:,94),heltab2x32(:,:,404))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMM,G1H4(13),n2h4(181))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[28,3],[nML,nML],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZl,m3h8x4(:,95),heltab2x32(:,:,405))
  call Hloop_Q_A(ntryL,G0H4(26),28,nML,G1H4(24),n2h4(182))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[28,3],[0,0],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZu,m3h8x4(:,96),heltab2x32(:,:,406))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(14),n2h4(183))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[28,3],[nMT,nMT],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZu,m3h8x4(:,97),heltab2x32(:,:,407))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMT,G1H4(12),n2h4(184))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[28,3],[0,0],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZd,m3h8x4(:,98),heltab2x32(:,:,408))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(15),n2h4(185))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[28,3],[nMB,nMB],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZd,m3h8x4(:,99),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMB,G1H4(1),n2h4(186))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[28,3],[0,0],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,100),heltab2x32(:,:,410))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(26),n2h4(187))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[28,3],[nMM,nMM],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,101),heltab2x32(:,:,411))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMM,G1H4(66),n2h4(188))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[28,3],[nML,nML],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,102),heltab2x32(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(26),28,nML,G1H4(67),n2h4(189))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[28,3],[0,0],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,103),heltab2x32(:,:,413))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(68),n2h4(190))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[28,3],[nMT,nMT],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,104),heltab2x32(:,:,414))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMT,G1H4(70),n2h4(191))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[28,3],[0,0],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,105),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(71),n2h4(192))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[28,3],[nMB,nMB],2,2,wf8(:,29),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,106),heltab2x32(:,:,416))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMB,G1H4(65),n2h4(193))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[28,3],[0,0],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZn,m3h8x4(:,107),heltab2x32(:,:,417))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(21),n2h4(194))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[28,3],[0,0],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZl,m3h8x4(:,108),heltab2x32(:,:,418))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(54),n2h4(195))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[28,3],[nMM,nMM],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZl,m3h8x4(:,109),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMM,G1H4(41),n2h4(196))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[28,3],[nML,nML],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZl,m3h8x4(:,110),heltab2x32(:,:,420))
  call Hloop_Q_A(ntryL,G0H4(26),28,nML,G1H4(25),n2h4(197))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[28,3],[0,0],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZu,m3h8x4(:,111),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(72),n2h4(198))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[28,3],[nMT,nMT],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZu,m3h8x4(:,112),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMT,G1H4(73),n2h4(199))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[28,3],[0,0],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZd,m3h8x4(:,113),heltab2x32(:,:,423))
  call Hloop_Q_A(ntryL,G0H4(26),28,0,G1H4(74),n2h4(200))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[28,3],[nMB,nMB],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,30),G0H4(26),ngZd,m3h8x4(:,114),heltab2x32(:,:,424))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMB,G1H4(75),n2h4(201))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(76),m3h8x4(:,115),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(77),m3h8x4(:,116),heltab2x32(:,:,426))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(78),m3h8x4(:,117),heltab2x32(:,:,427))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[28,3],[nMH,nMZ],2,2,wf8(:,30),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(79),m3h8x4(:,118),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(80),m3h8x4(:,119),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(81),m3h8x4(:,120),heltab2x32(:,:,430))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(82),m3h8x4(:,121),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(83),m3h8x4(:,122),heltab2x32(:,:,432))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(84),m3h8x4(:,123),heltab2x32(:,:,433))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(85),m3h8x4(:,124),heltab2x32(:,:,434))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(86),m3h8x4(:,125),heltab2x32(:,:,435))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(87),m3h8x4(:,126),heltab2x32(:,:,436))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(88),m3h8x4(:,127),heltab2x32(:,:,437))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(89),m3h8x4(:,128),heltab2x32(:,:,438))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(90),m3h8x4(:,129),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,29),28,G1H4(91),m3h8x4(:,130),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(92),m3h8x4(:,131),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,29),G0H4(26),m3h8x4(:,132),heltab2x32(:,:,442))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,29),G0H4(27),m3h8x4(:,133),heltab2x32(:,:,443))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,30),G0H4(28),m3h8x4(:,134),heltab2x32(:,:,444))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,30),G0H4(29),m3h8x4(:,135),heltab2x32(:,:,445))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,29),G0H4(30),m3h8x4(:,136),heltab2x32(:,:,446))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[28,3],[nMW,nMW],2,2,wf8(:,29),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,29),G0H4(31),m3h8x4(:,137),heltab2x32(:,:,447))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[28,3],[nMH,nMZ],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,30),G0H4(32),m3h8x4(:,138),heltab2x32(:,:,448))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,30),G0H4(33),m3h8x4(:,139),heltab2x32(:,:,449))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,30),G0H4(34),m3h8x4(:,140),heltab2x32(:,:,450))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[19,12],[0,0],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,141),heltab2x32(:,:,451))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(93),n2h4(202))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[19,12],[nMM,nMM],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,142),heltab2x32(:,:,452))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMM,G1H4(94),n2h4(203))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[19,12],[nML,nML],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,143),heltab2x32(:,:,453))
  call Hloop_Q_A(ntryL,G0H4(35),19,nML,G1H4(95),n2h4(204))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[19,12],[0,0],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,144),heltab2x32(:,:,454))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(96),n2h4(205))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,145),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMT,G1H4(97),n2h4(206))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[19,12],[0,0],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,146),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(98),n2h4(207))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,147),heltab2x32(:,:,457))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMB,G1H4(99),n2h4(208))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[19,12],[0,0],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,148),heltab2x32(:,:,458))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(100),n2h4(209))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[19,12],[nMM,nMM],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,149),heltab2x32(:,:,459))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMM,G1H4(101),n2h4(210))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[19,12],[nML,nML],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,150),heltab2x32(:,:,460))
  call Hloop_Q_A(ntryL,G0H4(35),19,nML,G1H4(102),n2h4(211))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[19,12],[0,0],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,151),heltab2x32(:,:,461))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(103),n2h4(212))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,152),heltab2x32(:,:,462))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMT,G1H4(104),n2h4(213))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[19,12],[0,0],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,153),heltab2x32(:,:,463))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(105),n2h4(214))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,154),heltab2x32(:,:,464))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMB,G1H4(106),n2h4(215))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[19,12],[0,0],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZl,m3h8x4(:,155),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(107),n2h4(216))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[19,12],[nMM,nMM],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZl,m3h8x4(:,156),heltab2x32(:,:,466))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMM,G1H4(108),n2h4(217))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[19,12],[nML,nML],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZl,m3h8x4(:,157),heltab2x32(:,:,467))
  call Hloop_Q_A(ntryL,G0H4(35),19,nML,G1H4(109),n2h4(218))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[19,12],[0,0],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZu,m3h8x4(:,158),heltab2x32(:,:,468))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(110),n2h4(219))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[19,12],[nMT,nMT],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZu,m3h8x4(:,159),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMT,G1H4(111),n2h4(220))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[19,12],[0,0],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZd,m3h8x4(:,160),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(112),n2h4(221))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZd,m3h8x4(:,161),heltab2x32(:,:,471))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMB,G1H4(113),n2h4(222))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZn,m3h8x4(:,162),heltab2x32(:,:,472))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(114),n2h4(223))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZl,m3h8x4(:,163),heltab2x32(:,:,473))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(115),n2h4(224))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[19,12],[nMM,nMM],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZl,m3h8x4(:,164),heltab2x32(:,:,474))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMM,G1H4(116),n2h4(225))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[19,12],[nML,nML],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZl,m3h8x4(:,165),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G0H4(35),19,nML,G1H4(117),n2h4(226))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZu,m3h8x4(:,166),heltab2x32(:,:,476))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(118),n2h4(227))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[19,12],[nMT,nMT],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZu,m3h8x4(:,167),heltab2x32(:,:,477))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMT,G1H4(119),n2h4(228))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZd,m3h8x4(:,168),heltab2x32(:,:,478))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(120),n2h4(229))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZd,m3h8x4(:,169),heltab2x32(:,:,479))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMB,G1H4(121),n2h4(230))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(122),m3h8x4(:,170),heltab2x32(:,:,480))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(123),m3h8x4(:,171),heltab2x32(:,:,481))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(124),m3h8x4(:,172),heltab2x32(:,:,482))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(125),m3h8x4(:,173),heltab2x32(:,:,483))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(126),m3h8x4(:,174),heltab2x32(:,:,484))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(127),m3h8x4(:,175),heltab2x32(:,:,485))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(128),m3h8x4(:,176),heltab2x32(:,:,486))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(129),m3h8x4(:,177),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(130),m3h8x4(:,178),heltab2x32(:,:,488))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(131),m3h8x4(:,179),heltab2x32(:,:,489))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(132),m3h8x4(:,180),heltab2x32(:,:,490))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(133),m3h8x4(:,181),heltab2x32(:,:,491))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(134),m3h8x4(:,182),heltab2x32(:,:,492))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(135),m3h8x4(:,183),heltab2x32(:,:,493))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(136),m3h8x4(:,184),heltab2x32(:,:,494))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(137),m3h8x4(:,185),heltab2x32(:,:,495))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(138),m3h8x4(:,186),heltab2x32(:,:,496))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,187),heltab2x32(:,:,497))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(36),m3h8x4(:,188),heltab2x32(:,:,498))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(37),m3h8x4(:,189),heltab2x32(:,:,499))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(38),m3h8x4(:,190),heltab2x32(:,:,500))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(39),m3h8x4(:,191),heltab2x32(:,:,501))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(40),m3h8x4(:,192),heltab2x32(:,:,502))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(41),m3h8x4(:,193),heltab2x32(:,:,503))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(42),m3h8x4(:,194),heltab2x32(:,:,504))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(43),m3h8x4(:,195),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[17,14],[0,0],2,2,wf4(:,9),wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(19),m3h4x8(:,79),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,34))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(1),ngZl,m3h4x8(:,80),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,34))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(4),m3h4x8(:,81),heltab2x32(:,:,508))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[17,14],[0,0],2,2,wf4(:,9),wf8(:,36))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(5),m3h4x8(:,82),heltab2x32(:,:,509))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,36))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(8),ngZl,m3h4x8(:,83),heltab2x32(:,:,510))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,36))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(9),m3h4x8(:,84),heltab2x32(:,:,511))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,196),heltab2x32(:,:,512))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(139),n2h4(231))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,197),heltab2x32(:,:,513))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(140),n2h4(232))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,198),heltab2x32(:,:,514))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(141),n2h4(233))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,199),heltab2x32(:,:,515))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(142),n2h4(234))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,200),heltab2x32(:,:,516))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(143),n2h4(235))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,201),heltab2x32(:,:,517))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(144),n2h4(236))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,202),heltab2x32(:,:,518))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(145),n2h4(237))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,203),heltab2x32(:,:,519))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(146),n2h4(238))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,204),heltab2x32(:,:,520))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(147),n2h4(239))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,205),heltab2x32(:,:,521))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(148),n2h4(240))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,206),heltab2x32(:,:,522))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(149),n2h4(241))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,207),heltab2x32(:,:,523))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(150),n2h4(242))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,208),heltab2x32(:,:,524))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(151),n2h4(243))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,209),heltab2x32(:,:,525))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(152),n2h4(244))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,210),heltab2x32(:,:,526))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(153),n2h4(245))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,211),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(154),n2h4(246))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,212),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(155),n2h4(247))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,213),heltab2x32(:,:,529))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(156),n2h4(248))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,214),heltab2x32(:,:,530))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(157),n2h4(249))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,215),heltab2x32(:,:,531))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(158),n2h4(250))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,216),heltab2x32(:,:,532))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(159),n2h4(251))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZn,m3h8x4(:,217),heltab2x32(:,:,533))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(160),n2h4(252))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,218),heltab2x32(:,:,534))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(161),n2h4(253))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,219),heltab2x32(:,:,535))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(162),n2h4(254))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,220),heltab2x32(:,:,536))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(163),n2h4(255))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,221),heltab2x32(:,:,537))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(164),n2h4(256))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,222),heltab2x32(:,:,538))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(165),n2h4(257))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,223),heltab2x32(:,:,539))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(166),n2h4(258))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,224),heltab2x32(:,:,540))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(167),n2h4(259))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(168),m3h8x4(:,225),heltab2x32(:,:,541))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(169),m3h8x4(:,226),heltab2x32(:,:,542))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(170),m3h8x4(:,227),heltab2x32(:,:,543))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(171),m3h8x4(:,228),heltab2x32(:,:,544))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(172),m3h8x4(:,229),heltab2x32(:,:,545))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(173),m3h8x4(:,230),heltab2x32(:,:,546))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(174),m3h8x4(:,231),heltab2x32(:,:,547))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(175),m3h8x4(:,232),heltab2x32(:,:,548))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(176),m3h8x4(:,233),heltab2x32(:,:,549))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(177),m3h8x4(:,234),heltab2x32(:,:,550))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(178),m3h8x4(:,235),heltab2x32(:,:,551))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(179),m3h8x4(:,236),heltab2x32(:,:,552))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(180),m3h8x4(:,237),heltab2x32(:,:,553))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(181),m3h8x4(:,238),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(182),m3h8x4(:,239),heltab2x32(:,:,555))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(183),m3h8x4(:,240),heltab2x32(:,:,556))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(184),m3h8x4(:,241),heltab2x32(:,:,557))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,242),heltab2x32(:,:,558))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(45),m3h8x4(:,243),heltab2x32(:,:,559))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(46),m3h8x4(:,244),heltab2x32(:,:,560))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(47),m3h8x4(:,245),heltab2x32(:,:,561))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(48),m3h8x4(:,246),heltab2x32(:,:,562))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(49),m3h8x4(:,247),heltab2x32(:,:,563))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(50),m3h8x4(:,248),heltab2x32(:,:,564))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(51),m3h8x4(:,249),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(52),m3h8x4(:,250),heltab2x32(:,:,566))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[18,13],[0,0],2,2,wf4(:,12),wf8(:,38))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(10),m3h4x8(:,85),heltab2x32(:,:,567))
  call Hloop_A_Q(ntryL,G0H8(10),18,0,G1H8(24),n2h8(63))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,38))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngZl,m3h4x8(:,86),heltab2x32(:,:,568))
  call Hloop_A_Q(ntryL,G0H8(7),18,0,G1H8(25),n2h8(64))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,38))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(14),m3h4x8(:,87),heltab2x32(:,:,569))
  call Hloop_A_Q(ntryL,G0H8(14),18,0,G1H8(26),n2h8(65))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[18,13],[0,0],2,2,wf4(:,12),wf8(:,40))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(15),m3h4x8(:,88),heltab2x32(:,:,570))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(5),n2h8(66))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,40))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(16),ngZl,m3h4x8(:,89),heltab2x32(:,:,571))
  call Hloop_A_Q(ntryL,G0H8(16),18,0,G1H8(6),n2h8(67))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,40))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,90),heltab2x32(:,:,572))
  call Hloop_A_Q(ntryL,G0H8(17),18,0,G1H8(27),n2h8(68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(76),G1H4(64),G1H4(63),G0H4(13),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(78),G1H4(47),G1H4(62),G0H4(15),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(89),G1H4(18),G1H4(35),G0H4(14),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(91),G1H4(36),G1H4(46),G0H4(16),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(170),[G1H4(168),G1H4(124),G1H4(122),G0H4(1),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(169),G1H4(126),G1H4(123),G0H4(6),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(181),G1H4(137),G1H4(135),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(182),G1H4(138),G1H4(136),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(14),G1H4(11),G1H4(7),G1H4(39),G1H4(9),G1H4(28) &
    ,G1H4(16),G1H4(2),G1H4(53),G1H4(49),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(57),G1H4(17),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(42),G1H4(5),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(3),G1H4(22),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(8),G1H4(23),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(26),G1H4(43),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(66),G1H4(50),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(67),G1H4(56),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(68),G1H4(51),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(70),G1H4(55),G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(71),G1H4(58),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(65),G1H4(59),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(83),G1H4(82),G1H4(81),G1H4(61),G1H4(34) &
    ,G1H4(19),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(87),G1H4(86),G1H4(85),G1H4(20),G1H4(6),G1H4(40) &
    ,G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(29),[G0H4(28),G0H4(27),G0H4(26),G0H4(20),G0H4(19) &
    ,G0H4(18),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(34),[G0H4(33),G0H4(31),G0H4(30),G0H4(25),G0H4(24) &
    ,G0H4(22),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(32),[G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(156),G1H4(153),G1H4(144),G1H4(142),G1H4(139) &
    ,G1H4(112),G1H4(110),G1H4(107),G1H4(98),G1H4(96),G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(140),G1H4(108),G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(155),[G1H4(141),G1H4(109),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(143),G1H4(111),G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(145),G1H4(113),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(161),[G1H4(146),G1H4(115),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(147),G1H4(116),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(148),G1H4(117),G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(149),G1H4(118),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(150),G1H4(119),G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(151),G1H4(120),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(152),G1H4(121),G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(160),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(177),G1H4(174),G1H4(173),G1H4(132),G1H4(131) &
    ,G1H4(128),G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(179),G1H4(176),G1H4(175),G1H4(134),G1H4(133) &
    ,G1H4(130),G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(49),[G0H4(48),G0H4(45),G0H4(44),G0H4(40),G0H4(39) &
    ,G0H4(36),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(52),[G0H4(51),G0H4(47),G0H4(46),G0H4(43),G0H4(42) &
    ,G0H4(38),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(50),[G0H4(41)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(7),wf4(:,1),wf4(:,8),G1tensor(12),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(1),wf4(:,1),wf4(:,10),G1tensor(26),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(9),wf4(:,4),wf4(:,8),G1tensor(42),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(4),wf4(:,4),wf4(:,10),G1tensor(66),m4h4x4x1(:,4),heltab3x16(:,:,4))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(65),wf4(:,1),wf4(:,8),G1tensor(78),m4h4x4x1(:,5),heltab3x16(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(66),wf4(:,1),wf4(:,10),G1tensor(84),m4h4x4x1(:,6),heltab3x16(:,:,6))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(69),wf4(:,4),wf4(:,8),G1tensor(98),m4h4x4x1(:,7),heltab3x16(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(70),wf4(:,4),wf4(:,10),G1tensor(2),m4h4x4x1(:,8),heltab3x16(:,:,8))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(77),28,wf4(:,1),3,G2tensor(29),m3h4x1(:,97),heltab2x4(:,:,181))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(80),28,wf4(:,4),3,G2tensor(32),m3h4x1(:,98),heltab2x4(:,:,182))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(90),28,wf4(:,1),3,G2tensor(35),m3h4x1(:,99),heltab2x4(:,:,183))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(92),28,wf4(:,4),3,G2tensor(38),m3h4x1(:,100),heltab2x4(:,:,184))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(170),19,wf4(:,8),12,G2tensor(41),m3h4x1(:,101),heltab2x4(:,:,185))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(172),19,wf4(:,10),12,G2tensor(108),m3h4x1(:,102),heltab2x4(:,:,186))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(183),19,wf4(:,8),12,G2tensor(44),m3h4x1(:,103),heltab2x4(:,:,187))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(184),19,wf4(:,10),12,G2tensor(47),m3h4x1(:,104),heltab2x4(:,:,188))
  call Hloop_VA_Q(ntryL,G0H8(13),wf8(:,27),G0H1(1),m3h8x1(:,21),heltab2x8(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(8),n2h1(211))
  call Hloop_ZA_Q(ntryL,G0H8(2),wf8(:,27),G0H1(1),ngZu,m3h8x1(:,22),heltab2x8(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(28),n2h1(212))
  call Hloop_WA_Q(ntryL,G0H8(3),wf8(:,27),G0H1(1),m3h8x1(:,23),heltab2x8(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(34),n2h1(213))
  call Hloop_VA_Q(ntryL,G0H8(11),wf8(:,28),G0H1(1),m3h8x1(:,24),heltab2x8(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(53),n2h1(214))
  call Hloop_ZA_Q(ntryL,G0H8(12),wf8(:,28),G0H1(1),ngZu,m3h8x1(:,25),heltab2x8(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(40),n2h1(215))
  call Hloop_WA_Q(ntryL,G0H8(6),wf8(:,28),G0H1(1),m3h8x1(:,26),heltab2x8(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(51),n2h1(216))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(217))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,1),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(53),n2h1(218))
  call Hloop_QV_A(ntryL,G1H4(24),wf4(:,1),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(56),n2h1(219))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(57),n2h1(220))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(221))
  call Hloop_QZ_A(ntryL,G1H4(54),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,110),heltab2x4(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(222))
  call Hloop_QZ_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,111),heltab2x4(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(60),n2h1(223))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,112),heltab2x4(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(61),n2h1(224))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,113),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(225))
  call Hloop_QZ_A(ntryL,G1H4(73),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,114),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(226))
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,115),heltab2x4(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(227))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,116),heltab2x4(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(228))
  call Hloop_QZ_A(ntryL,G1H4(21),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,117),heltab2x4(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(229))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(79),28,wf4(:,4),3,G2tensor(67),m3h4x1(:,118),heltab2x4(:,:,202))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(84),28,wf4(:,1),3,G2tensor(68),m3h4x1(:,119),heltab2x4(:,:,203))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(88),28,wf4(:,4),3,G2tensor(69),m3h4x1(:,120),heltab2x4(:,:,204))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(29),wf4(:,1),G0tensor(1),m3h4x1(:,121),heltab2x4(:,:,205))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(34),wf4(:,4),G0tensor(26),m3h4x1(:,122),heltab2x4(:,:,206))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(32),wf4(:,4),G0tensor(51),m3h4x1(:,123),heltab2x4(:,:,207))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(16),wf8(:,31),G1tensor(69),m3h8x1(:,27),heltab2x8(:,:,143))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(18),wf8(:,31),G1tensor(75),ngZu,m3h8x1(:,28),heltab2x8(:,:,144))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(19),wf8(:,31),G1tensor(81),m3h8x1(:,29),heltab2x8(:,:,145))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(21),wf8(:,32),G1tensor(89),m3h8x1(:,30),heltab2x8(:,:,146))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(22),wf8(:,32),G1tensor(112),ngZu,m3h8x1(:,31),heltab2x8(:,:,147))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(23),wf8(:,32),G1tensor(116),m3h8x1(:,32),heltab2x8(:,:,148))
  call Hloop_QV_A(ntryL,G1H4(158),wf4(:,8),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(230))
  call Hloop_QV_A(ntryL,G1H4(154),wf4(:,8),G1H1(1),m3h4x1(:,125),heltab2x4(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(71),n2h1(231))
  call Hloop_QV_A(ntryL,G1H4(155),wf4(:,8),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(72),n2h1(232))
  call Hloop_QV_A(ntryL,G1H4(157),wf4(:,8),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(233))
  call Hloop_QV_A(ntryL,G1H4(159),wf4(:,8),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(76),n2h1(234))
  call Hloop_QZ_A(ntryL,G1H4(161),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,129),heltab2x4(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(235))
  call Hloop_QZ_A(ntryL,G1H4(162),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,130),heltab2x4(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(78),n2h1(236))
  call Hloop_QZ_A(ntryL,G1H4(163),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,131),heltab2x4(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(79),n2h1(237))
  call Hloop_QZ_A(ntryL,G1H4(164),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,132),heltab2x4(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(238))
  call Hloop_QZ_A(ntryL,G1H4(165),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,133),heltab2x4(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(239))
  call Hloop_QZ_A(ntryL,G1H4(166),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,134),heltab2x4(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(240))
  call Hloop_QZ_A(ntryL,G1H4(167),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,135),heltab2x4(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(241))
  call Hloop_QZ_A(ntryL,G1H4(160),wf4(:,10),G1H1(1),ngZn,m3h4x1(:,136),heltab2x4(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(242))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(171),19,wf4(:,10),12,G2tensor(93),m3h4x1(:,137),heltab2x4(:,:,221))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(178),19,wf4(:,8),12,G2tensor(94),m3h4x1(:,138),heltab2x4(:,:,222))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(180),19,wf4(:,10),12,G2tensor(95),m3h4x1(:,139),heltab2x4(:,:,223))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(49),wf4(:,8),G0tensor(76),m3h4x1(:,140),heltab2x4(:,:,224))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(52),wf4(:,10),G0tensor(101),m3h4x1(:,141),heltab2x4(:,:,225))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(50),wf4(:,10),G0tensor(126),m3h4x1(:,142),heltab2x4(:,:,226))
  call Hloop_VA_Q(ntryL,G0H8(19),wf8(:,34),G0H1(1),m3h8x1(:,33),heltab2x8(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(121),n2h1(243))
  call Hloop_ZA_Q(ntryL,G0H8(1),wf8(:,34),G0H1(1),ngZl,m3h8x1(:,34),heltab2x8(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(126),n2h1(244))
  call Hloop_WA_Q(ntryL,G0H8(4),wf8(:,34),G0H1(1),m3h8x1(:,35),heltab2x8(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(131),n2h1(245))
  call Hloop_VA_Q(ntryL,G0H8(5),wf8(:,36),G0H1(1),m3h8x1(:,36),heltab2x8(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(136),n2h1(246))
  call Hloop_ZA_Q(ntryL,G0H8(8),wf8(:,36),G0H1(1),ngZl,m3h8x1(:,37),heltab2x8(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(141),n2h1(247))
  call Hloop_WA_Q(ntryL,G0H8(9),wf8(:,36),G0H1(1),m3h8x1(:,38),heltab2x8(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(146),n2h1(248))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(24),wf8(:,38),G1tensor(151),m3h8x1(:,39),heltab2x8(:,:,155))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(25),wf8(:,38),G1tensor(156),ngZl,m3h8x1(:,40),heltab2x8(:,:,156))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(26),wf8(:,38),G1tensor(161),m3h8x1(:,41),heltab2x8(:,:,157))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(5),wf8(:,40),G1tensor(166),m3h8x1(:,42),heltab2x8(:,:,158))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(6),wf8(:,40),G1tensor(171),ngZl,m3h8x1(:,43),heltab2x8(:,:,159))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(27),wf8(:,40),G1tensor(176),m3h8x1(:,44),heltab2x8(:,:,160))
  call ol_merge_tensors(G2tensor(69),[G2tensor(68),G2tensor(38),G2tensor(35),G2tensor(32),G2tensor(29),G0tensor(26),G0tensor(1) &
    ,G0tensor(487),G0tensor(90),G0tensor(4),G0tensor(391),G0tensor(86),G0tensor(6)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(94),G2tensor(47),G2tensor(44),G2tensor(108),G2tensor(41),G0tensor(101),G0tensor(76) &
    ,G0tensor(3),G0tensor(162),G0tensor(484),G0tensor(442),G0tensor(11)])
  call ol_merge_tensors(G1tensor(2),[G1tensor(98),G1tensor(84),G1tensor(78),G1tensor(66),G1tensor(42),G1tensor(26),G1tensor(12) &
    ,G0tensor(28),G0tensor(12),G0tensor(242),G0tensor(237),G0tensor(66),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(535),[G0tensor(530),G0tensor(525),G0tensor(520),G0tensor(515),G0tensor(145),G0tensor(147) &
    ,G0tensor(345),G0tensor(115),G0tensor(277),G0tensor(58),G0tensor(328),G0tensor(44),G0tensor(217),G0tensor(32),G0tensor(24) &
    ,G0tensor(417),G0tensor(104),G0tensor(187),G0tensor(170),G0tensor(2),G0tensor(53),G0tensor(43),G0tensor(320),G0tensor(474) &
    ,G0tensor(193),G0tensor(45),G0tensor(435),G0tensor(396),G0tensor(281),G0tensor(211),G0tensor(121),G0tensor(96),G0tensor(71) &
    ,G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(513),[G0tensor(48),G0tensor(42),G0tensor(195),G0tensor(135),G0tensor(477),G0tensor(31)])
  call ol_merge_tensors(G0tensor(165),[G0tensor(206),G0tensor(36)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(128),G0tensor(23),G0tensor(381),G0tensor(56)])
  call ol_merge_tensors(G0tensor(534),[G0tensor(37),G0tensor(479),G0tensor(61)])
  call ol_merge_tensors(G0tensor(533),[G0tensor(342),G0tensor(54),G0tensor(17),G0tensor(150),G0tensor(271),G0tensor(106) &
    ,G0tensor(81)])
  call ol_merge_tensors(G1tensor(116),[G1tensor(81),G0tensor(138),G0tensor(235),G0tensor(276),G0tensor(91)])
  call ol_merge_tensors(G1tensor(51),[G1tensor(34),G0tensor(157),G0tensor(22),G0tensor(142),G0tensor(111)])
  call ol_merge_tensors(G0tensor(585),[G0tensor(571),G0tensor(438),G0tensor(178),G0tensor(302),G0tensor(343),G0tensor(227) &
    ,G0tensor(215),G0tensor(190),G0tensor(18),G0tensor(55),G0tensor(452),G0tensor(455),G0tensor(481),G0tensor(436),G0tensor(366) &
    ,G0tensor(321),G0tensor(161),G0tensor(116)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(64),G2tensor(62),G2tensor(59),G2tensor(50),G0tensor(297),G0tensor(282),G0tensor(60) &
    ,G0tensor(456),G0tensor(416),G0tensor(341),G0tensor(301),G0tensor(266),G0tensor(241),G0tensor(221),G0tensor(196),G0tensor(171) &
    ,G0tensor(151),G0tensor(131)])
  call ol_merge_tensors(G0tensor(603),[G0tensor(561),G0tensor(552),G0tensor(538),G0tensor(444),G0tensor(420),G0tensor(399) &
    ,G0tensor(352),G0tensor(278),G0tensor(192),G0tensor(475),G0tensor(394),G0tensor(136)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(8),G0tensor(548),G0tensor(172),G0tensor(107),G0tensor(30),G0tensor(460) &
    ,G0tensor(141)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(82),G2tensor(80),G2tensor(77),G2tensor(70),G0tensor(565),G0tensor(272),G0tensor(77) &
    ,G0tensor(69),G0tensor(245),G0tensor(52),G0tensor(232),G0tensor(70),G0tensor(75),G0tensor(202),G0tensor(34),G0tensor(285) &
    ,G0tensor(412),G0tensor(462),G0tensor(156)])
  call ol_merge_tensors(G0tensor(607),[G0tensor(573),G0tensor(365),G0tensor(298),G0tensor(279),G0tensor(230),G0tensor(176)])
  call ol_merge_tensors(G0tensor(222),[G0tensor(181)])
  call ol_merge_tensors(G0tensor(671),[G0tensor(662),G0tensor(657),G0tensor(652),G0tensor(647),G0tensor(638),G0tensor(629) &
    ,G0tensor(624),G0tensor(619),G0tensor(614),G0tensor(609),G0tensor(596),G0tensor(591),G0tensor(586),G0tensor(581),G0tensor(576) &
    ,G0tensor(559),G0tensor(554),G0tensor(549),G0tensor(544),G0tensor(510),G0tensor(505),G0tensor(500),G0tensor(495),G0tensor(488) &
    ,G0tensor(453),G0tensor(405),G0tensor(370),G0tensor(367),G0tensor(359),G0tensor(354),G0tensor(423),G0tensor(308),G0tensor(339) &
    ,G0tensor(293),G0tensor(269),G0tensor(209),G0tensor(208),G0tensor(382),G0tensor(249),G0tensor(372),G0tensor(127),G0tensor(268) &
    ,G0tensor(332),G0tensor(340),G0tensor(129),G0tensor(443),G0tensor(248),G0tensor(108),G0tensor(315),G0tensor(62),G0tensor(348) &
    ,G0tensor(247),G0tensor(80),G0tensor(35),G0tensor(295),G0tensor(433),G0tensor(486),G0tensor(461),G0tensor(371),G0tensor(346) &
    ,G0tensor(256),G0tensor(186)])
  call ol_merge_tensors(G0tensor(523),[G0tensor(47),G0tensor(392),G0tensor(105),G0tensor(201)])
  call ol_merge_tensors(G0tensor(645),[G0tensor(632),G0tensor(599),G0tensor(498),G0tensor(404),G0tensor(284),G0tensor(283) &
    ,G0tensor(469),G0tensor(148),G0tensor(140),G0tensor(94),G0tensor(290),G0tensor(225),G0tensor(300),G0tensor(414),G0tensor(465) &
    ,G0tensor(226)])
  call ol_merge_tensors(G1tensor(89),[G1tensor(69),G0tensor(666),G0tensor(656),G0tensor(642),G0tensor(233),G0tensor(118) &
    ,G0tensor(125),G0tensor(292),G0tensor(14),G0tensor(231)])
  call ol_merge_tensors(G0tensor(636),[G0tensor(508),G0tensor(468),G0tensor(448),G0tensor(179),G0tensor(258),G0tensor(335) &
    ,G0tensor(122),G0tensor(72),G0tensor(445),G0tensor(246)])
  call ol_merge_tensors(G1tensor(112),[G1tensor(75),G0tensor(229),G0tensor(132),G0tensor(253),G0tensor(312),G0tensor(200) &
    ,G0tensor(251)])
  call ol_merge_tensors(G0tensor(664),[G0tensor(424),G0tensor(299),G0tensor(224),G0tensor(183),G0tensor(154),G0tensor(307) &
    ,G0tensor(408),G0tensor(275),G0tensor(472),G0tensor(411),G0tensor(311),G0tensor(291)])
  call ol_merge_tensors(G0tensor(640),[G0tensor(611),G0tensor(598),G0tensor(589),G0tensor(570),G0tensor(566),G0tensor(562) &
    ,G0tensor(537),G0tensor(203),G0tensor(163),G0tensor(158),G0tensor(113),G0tensor(93),G0tensor(49),G0tensor(426),G0tensor(406) &
    ,G0tensor(296)])
  call ol_merge_tensors(G1tensor(136),[G1tensor(121),G0tensor(633),G0tensor(623),G0tensor(604),G0tensor(580),G0tensor(567) &
    ,G0tensor(430),G0tensor(329),G0tensor(19),G0tensor(316)])
  call ol_merge_tensors(G0tensor(492),[G0tensor(374),G0tensor(375),G0tensor(349),G0tensor(218),G0tensor(264),G0tensor(198) &
    ,G0tensor(356),G0tensor(331)])
  call ol_merge_tensors(G0tensor(649),[G0tensor(594),G0tensor(584),G0tensor(579),G0tensor(574),G0tensor(254),G0tensor(194) &
    ,G0tensor(188),G0tensor(174),G0tensor(250),G0tensor(336)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(126),G0tensor(595),G0tensor(590),G0tensor(504),G0tensor(418),G0tensor(59) &
    ,G0tensor(361)])
  call ol_merge_tensors(G0tensor(527),[G0tensor(347),G0tensor(212),G0tensor(25),G0tensor(489),G0tensor(386)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(151),G0tensor(569),G0tensor(429),G0tensor(369),G0tensor(273),G0tensor(182) &
    ,G0tensor(431)])
  call ol_merge_tensors(G0tensor(626),[G0tensor(621),G0tensor(616),G0tensor(541),G0tensor(139),G0tensor(368),G0tensor(130) &
    ,G0tensor(471),G0tensor(446)])
  call ol_merge_tensors(G0tensor(668),[G0tensor(337),G0tensor(134),G0tensor(322),G0tensor(117),G0tensor(333),G0tensor(451)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(476)])
  call ol_merge_tensors(G0tensor(517),[G0tensor(483),G0tensor(353),G0tensor(180),G0tensor(155)])
  call ol_merge_tensors(G0tensor(512),[G0tensor(84),G0tensor(50),G0tensor(9)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(161),G0tensor(524),G0tensor(244),G0tensor(10)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(28),G0tensor(558),G0tensor(553),G0tensor(387),G0tensor(378),G0tensor(447)])
  call ol_merge_tensors(G0tensor(519),[G0tensor(20),G0tensor(482),G0tensor(480)])
  call ol_merge_tensors(G0tensor(528),[G0tensor(260),G0tensor(205),G0tensor(5),G0tensor(490)])
  call ol_merge_tensors(G0tensor(557),[G0tensor(547),G0tensor(542),G0tensor(507),G0tensor(502),G0tensor(497),G0tensor(493) &
    ,G0tensor(57),G0tensor(185)])
  call ol_merge_tensors(G0tensor(422),[G0tensor(39)])
  call ol_merge_tensors(G0tensor(660),[G0tensor(655),G0tensor(617),G0tensor(385),G0tensor(360),G0tensor(357),G0tensor(318) &
    ,G0tensor(38),G0tensor(220)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(53),G0tensor(252)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(71),G0tensor(63)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(56),G0tensor(402)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(72),G0tensor(257)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(57),G0tensor(74)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(73),G0tensor(407)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(58),G0tensor(393)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(76),G0tensor(92)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(131),G0tensor(83)])
  call ol_merge_tensors(G0tensor(650),[G0tensor(641),G0tensor(522),G0tensor(518),G0tensor(514),G0tensor(314),G0tensor(334) &
    ,G0tensor(303),G0tensor(239),G0tensor(388),G0tensor(350),G0tensor(112),G0tensor(103),G0tensor(97),G0tensor(287) &
    ,G0tensor(88)])
  call ol_merge_tensors(G0tensor(635),[G0tensor(631),G0tensor(575),G0tensor(563),G0tensor(543),G0tensor(539),G0tensor(532) &
    ,G0tensor(529),G0tensor(428),G0tensor(274),G0tensor(144),G0tensor(119),G0tensor(363),G0tensor(403)])
  call ol_merge_tensors(G0tensor(654),[G0tensor(546),G0tensor(259),G0tensor(110),G0tensor(100)])
  call ol_merge_tensors(G0tensor(644),[G0tensor(551),G0tensor(459),G0tensor(325),G0tensor(327)])
  call ol_merge_tensors(G0tensor(659),[G0tensor(556),G0tensor(214),G0tensor(137),G0tensor(124)])
  call ol_merge_tensors(G0tensor(669),[G0tensor(665),G0tensor(618),G0tensor(606),G0tensor(602),G0tensor(600),G0tensor(503) &
    ,G0tensor(437),G0tensor(415),G0tensor(464),G0tensor(377),G0tensor(173),G0tensor(159),G0tensor(149)])
  call ol_merge_tensors(G0tensor(494),[G0tensor(463),G0tensor(432),G0tensor(419),G0tensor(410),G0tensor(189),G0tensor(168) &
    ,G0tensor(238)])
  call ol_merge_tensors(G0tensor(612),[G0tensor(578),G0tensor(449),G0tensor(294),G0tensor(313)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(156),G0tensor(583),G0tensor(478),G0tensor(379),G0tensor(344),G0tensor(289)])
  call ol_merge_tensors(G0tensor(622),[G0tensor(588),G0tensor(499),G0tensor(355),G0tensor(364)])
  call ol_merge_tensors(G0tensor(627),[G0tensor(593),G0tensor(509),G0tensor(389),G0tensor(390)])
  call ol_merge_tensors(G0tensor(637),[G0tensor(628),G0tensor(613),G0tensor(608)])
  call ol_merge_tensors(G0tensor(670),[G0tensor(661),G0tensor(651),G0tensor(646)])
  call ol_merge_tensors(G2tensor(67),[G0tensor(51)])
  call ol_merge_tensors(G2tensor(93),[G0tensor(126)])
call TI_bubble_red(G2tensor(69),28,mass2set(:,1),G0tensor(146),M2L1R1,G0tensor(166))
call TI_bubble_red(G2tensor(95),19,mass2set(:,1),G0tensor(191),M2L1R1,G0tensor(216))
call TI_bubble_red(G2tensor(66),28,mass2set(:,2),G0tensor(236),M2L1R1)
call TI_bubble_red(G2tensor(92),19,mass2set(:,2),G0tensor(261),M2L1R1)
call TI_bubble_red(G2tensor(60),28,mass2set(:,3),G0tensor(286),M2L1R1,G0tensor(306))
call TI_bubble_red(G2tensor(78),19,mass2set(:,3),G0tensor(326),M2L1R1,G0tensor(351))
call TI_bubble_red(G2tensor(61),28,mass2set(:,4),G0tensor(376),M2L1R1,G0tensor(401))
call TI_bubble_red(G2tensor(79),19,mass2set(:,4),G0tensor(421),M2L1R1,G0tensor(441))
call TI_bubble_red(G2tensor(63),28,mass2set(:,5),G0tensor(466),M2L1R1,G0tensor(175))
call TI_bubble_red(G2tensor(81),19,mass2set(:,5),G0tensor(440),M2L1R1,G0tensor(240))
call TI_bubble_red(G2tensor(65),28,mass2set(:,6),G0tensor(184),M2L1R1,G0tensor(85))
call TI_bubble_red(G2tensor(83),19,mass2set(:,6),G0tensor(358),M2L1R1,G0tensor(109))
call TI_bubble_red(G2tensor(67),28,mass2set(:,7),G0tensor(95),M2L1R1,G0tensor(102),G0tensor(470))
call TI_bubble_red(G2tensor(93),19,mass2set(:,8),G0tensor(98),M2L1R1,G0tensor(305),G0tensor(317))
  call ol_merge_tensors(G0tensor(535),[G0tensor(216),G0tensor(166)])
  call ol_merge_tensors(G0tensor(317),[G0tensor(102),G0tensor(671)])
  call ol_merge_tensors(G0tensor(255),[G0tensor(351),G0tensor(306)])
  call ol_merge_tensors(G0tensor(262),[G0tensor(441),G0tensor(401)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(240),G0tensor(175)])
  call ol_merge_tensors(G0tensor(82),[G0tensor(109),G0tensor(85)])
  call ol_merge_tensors(G0tensor(305),[G0tensor(470)])
call TI_bubble_red(G1tensor(2),16,mass2set(:,1),G0tensor(243),M2L1R1,G0tensor(373))
call TI_bubble_red(G1tensor(116),24,mass2set(:,9),G0tensor(114),M2L1R1,G0tensor(330))
call TI_bubble_red(G1tensor(51),20,mass2set(:,10),G0tensor(450),M2L1R1,G0tensor(123))
call TI_bubble_red(G1tensor(53),20,mass2set(:,2),G0tensor(263),M2L1R1)
call TI_bubble_red(G1tensor(89),24,mass2set(:,2),G0tensor(383),M2L1R1)
call TI_bubble_red(G1tensor(112),24,mass2set(:,11),G0tensor(133),M2L1R1,G0tensor(143))
call TI_bubble_red(G1tensor(136),17,mass2set(:,2),G0tensor(153),M2L1R1)
call TI_bubble_red(G1tensor(141),17,mass2set(:,12),G0tensor(434),M2L1R1,G0tensor(167))
call TI_bubble_red(G1tensor(166),18,mass2set(:,2),G0tensor(164),M2L1R1)
call TI_bubble_red(G1tensor(176),18,mass2set(:,9),G0tensor(169),M2L1R1,G0tensor(213))
call TI_bubble_red(G1tensor(40),20,mass2set(:,12),G0tensor(219),M2L1R1,G0tensor(223))
call TI_bubble_red(G1tensor(146),17,mass2set(:,10),G0tensor(199),M2L1R1,G0tensor(204))
call TI_bubble_red(G1tensor(171),18,mass2set(:,11),G0tensor(228),M2L1R1,G0tensor(457))
  call ol_merge_tensors(G0tensor(204),[G0tensor(213),G0tensor(123),G0tensor(330),G0tensor(373),G0tensor(535)])
  call ol_merge_tensors(G0tensor(457),[G0tensor(223),G0tensor(167),G0tensor(143),G0tensor(317)])
  call ol_merge_tensors(T0sum(241),[G0tensor(146)])
  call ol_merge_tensors(T0sum(242),[G0tensor(204)])
  call ol_merge_tensors(T0sum(243),[G0tensor(191)])
  call ol_merge_tensors(T0sum(244),[G0tensor(243)])
  call ol_merge_tensors(T0sum(245),[G0tensor(513)])
  call ol_merge_tensors(T0sum(246),[G0tensor(165)])
  call ol_merge_tensors(T0sum(247),[G0tensor(152)])
  call ol_merge_tensors(T0sum(248),[G0tensor(534)])
  call ol_merge_tensors(T0sum(249),[G0tensor(533)])
  call ol_merge_tensors(T0sum(250),[G0tensor(114)])
  call ol_merge_tensors(T0sum(251),[G0tensor(450)])
  call ol_merge_tensors(T0sum(252),[G0tensor(585)])
  call ol_merge_tensors(T0sum(253),[G0tensor(236)])
  call ol_merge_tensors(T0sum(254),[G0tensor(603)])
  call ol_merge_tensors(T0sum(255),[G0tensor(263)])
  call ol_merge_tensors(T0sum(256),[G0tensor(261)])
  call ol_merge_tensors(T0sum(257),[G0tensor(607)])
  call ol_merge_tensors(T0sum(258),[G0tensor(222)])
  call ol_merge_tensors(T0sum(259),[G0tensor(457)])
  call ol_merge_tensors(T0sum(260),[G0tensor(523)])
  call ol_merge_tensors(T0sum(261),[G0tensor(645)])
  call ol_merge_tensors(T0sum(262),[G0tensor(383)])
  call ol_merge_tensors(T0sum(263),[G0tensor(636)])
  call ol_merge_tensors(T0sum(264),[G0tensor(133)])
  call ol_merge_tensors(T0sum(265),[G0tensor(664)])
  call ol_merge_tensors(T0sum(266),[G0tensor(640)])
  call ol_merge_tensors(T0sum(267),[G0tensor(153)])
  call ol_merge_tensors(T0sum(268),[G0tensor(492)])
  call ol_merge_tensors(T0sum(269),[G0tensor(649)])
  call ol_merge_tensors(T0sum(270),[G0tensor(434)])
  call ol_merge_tensors(T0sum(271),[G0tensor(527)])
  call ol_merge_tensors(T0sum(272),[G0tensor(164)])
  call ol_merge_tensors(T0sum(273),[G0tensor(626)])
  call ol_merge_tensors(T0sum(274),[G0tensor(668)])
  call ol_merge_tensors(T0sum(275),[G0tensor(67)])
  call ol_merge_tensors(T0sum(276),[G0tensor(517)])
  call ol_merge_tensors(T0sum(277),[G0tensor(512)])
  call ol_merge_tensors(T0sum(278),[G0tensor(169)])
  call ol_merge_tensors(T0sum(279),[G0tensor(219)])
  call ol_merge_tensors(T0sum(280),[G0tensor(519)])
  call ol_merge_tensors(T0sum(281),[G0tensor(528)])
  call ol_merge_tensors(T0sum(282),[G0tensor(557)])
  call ol_merge_tensors(T0sum(283),[G0tensor(422)])
  call ol_merge_tensors(T0sum(284),[G0tensor(660)])
  call ol_merge_tensors(T0sum(285),[G0tensor(286)])
  call ol_merge_tensors(T0sum(286),[G0tensor(255)])
  call ol_merge_tensors(T0sum(287),[G0tensor(326)])
  call ol_merge_tensors(T0sum(288),[G0tensor(270)])
  call ol_merge_tensors(T0sum(289),[G0tensor(376)])
  call ol_merge_tensors(T0sum(290),[G0tensor(262)])
  call ol_merge_tensors(T0sum(291),[G0tensor(421)])
  call ol_merge_tensors(T0sum(292),[G0tensor(73)])
  call ol_merge_tensors(T0sum(293),[G0tensor(466)])
  call ol_merge_tensors(T0sum(294),[G0tensor(78)])
  call ol_merge_tensors(T0sum(295),[G0tensor(440)])
  call ol_merge_tensors(T0sum(296),[G0tensor(267)])
  call ol_merge_tensors(T0sum(297),[G0tensor(184)])
  call ol_merge_tensors(T0sum(298),[G0tensor(82)])
  call ol_merge_tensors(T0sum(299),[G0tensor(358)])
  call ol_merge_tensors(T0sum(300),[G0tensor(87)])
  call ol_merge_tensors(T0sum(301),[G0tensor(199)])
  call ol_merge_tensors(T0sum(302),[G0tensor(650)])
  call ol_merge_tensors(T0sum(303),[G0tensor(635)])
  call ol_merge_tensors(T0sum(304),[G0tensor(654)])
  call ol_merge_tensors(T0sum(305),[G0tensor(644)])
  call ol_merge_tensors(T0sum(306),[G0tensor(659)])
  call ol_merge_tensors(T0sum(307),[G0tensor(669)])
  call ol_merge_tensors(T0sum(308),[G0tensor(494)])
  call ol_merge_tensors(T0sum(309),[G0tensor(612)])
  call ol_merge_tensors(T0sum(310),[G0tensor(228)])
  call ol_merge_tensors(T0sum(311),[G0tensor(622)])
  call ol_merge_tensors(T0sum(312),[G0tensor(627)])
  call ol_merge_tensors(T0sum(313),[G0tensor(637)])
  call ol_merge_tensors(T0sum(314),[G0tensor(670)])
  call ol_merge_tensors(T0sum(315),[G0tensor(95)])
  call ol_merge_tensors(T0sum(316),[G0tensor(305)])
  call ol_merge_tensors(T0sum(317),[G0tensor(98)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_42,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_50,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_47,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_49,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_42,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 17, 19, 27 ],masses2_42,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 27 ],masses2_50,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 27 ],masses2_47,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 16, 17, 19 ],masses2_49,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 1, 3, 11 ],masses2_42,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 20, 21, 23 ],masses2_37,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 21, 23 ],masses2_37,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 23 ],masses2_37,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 16, 20, 21 ],masses2_37,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 4, 5, 7 ],masses2_37,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 20, 21, 23 ],masses2_40,RedSet_4(11),ScalarBoxes(16))
  call compute_scalar_box([ 16, 21, 23 ],masses2_40,RedSet_4(12),ScalarBoxes(17))
  call compute_scalar_box([ 16, 20, 23 ],masses2_40,RedSet_4(13),ScalarBoxes(18))
  call compute_scalar_box([ 4, 5, 7 ],masses2_40,RedSet_4(15),ScalarBoxes(19))
  call compute_scalar_box([ 20, 21, 23 ],masses2_51,RedSet_4(11),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 23 ],masses2_44,RedSet_4(13),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 21 ],masses2_44,RedSet_4(14),ScalarBoxes(22))
  call compute_scalar_box([ 4, 5, 7 ],masses2_51,RedSet_4(15),ScalarBoxes(23))
  call compute_scalar_box([ 20, 21, 23 ],masses2_52,RedSet_4(11),ScalarBoxes(24))
  call compute_scalar_box([ 16, 20, 23 ],masses2_46,RedSet_4(13),ScalarBoxes(25))
  call compute_scalar_box([ 4, 5, 7 ],masses2_52,RedSet_4(15),ScalarBoxes(26))
  call compute_scalar_box([ 20, 21, 23 ],masses2_48,RedSet_4(11),ScalarBoxes(27))
  call compute_scalar_box([ 16, 21, 23 ],masses2_39,RedSet_4(12),ScalarBoxes(28))
  call compute_scalar_box([ 16, 20, 23 ],masses2_43,RedSet_4(13),ScalarBoxes(29))
  call compute_scalar_box([ 16, 20, 21 ],masses2_41,RedSet_4(14),ScalarBoxes(30))
  call compute_scalar_box([ 4, 5, 7 ],masses2_48,RedSet_4(15),ScalarBoxes(31))
  call compute_scalar_box([ 20, 22, 23 ],masses2_37,RedSet_4(16),ScalarBoxes(32))
  call compute_scalar_box([ 16, 22, 23 ],masses2_37,RedSet_4(17),ScalarBoxes(33))
  call compute_scalar_box([ 16, 20, 22 ],masses2_37,RedSet_4(18),ScalarBoxes(34))
  call compute_scalar_box([ 4, 6, 7 ],masses2_37,RedSet_4(19),ScalarBoxes(35))
  call compute_scalar_box([ 20, 22, 23 ],masses2_51,RedSet_4(16),ScalarBoxes(36))
  call compute_scalar_box([ 16, 20, 22 ],masses2_44,RedSet_4(18),ScalarBoxes(37))
  call compute_scalar_box([ 4, 6, 7 ],masses2_51,RedSet_4(19),ScalarBoxes(38))
  call compute_scalar_box([ 20, 22, 23 ],masses2_40,RedSet_4(16),ScalarBoxes(39))
  call compute_scalar_box([ 16, 22, 23 ],masses2_40,RedSet_4(17),ScalarBoxes(40))
  call compute_scalar_box([ 4, 6, 7 ],masses2_40,RedSet_4(19),ScalarBoxes(41))
  call compute_scalar_box([ 20, 22, 23 ],masses2_52,RedSet_4(16),ScalarBoxes(42))
  call compute_scalar_box([ 4, 6, 7 ],masses2_52,RedSet_4(19),ScalarBoxes(43))
  call compute_scalar_box([ 17, 21, 29 ],masses2_37,RedSet_4(20),ScalarBoxes(44))
  call compute_scalar_box([ 16, 21, 29 ],masses2_37,RedSet_4(21),ScalarBoxes(45))
  call compute_scalar_box([ 16, 17, 29 ],masses2_37,RedSet_4(22),ScalarBoxes(46))
  call compute_scalar_box([ 16, 17, 21 ],masses2_37,RedSet_4(23),ScalarBoxes(47))
  call compute_scalar_box([ 1, 5, 13 ],masses2_37,RedSet_4(24),ScalarBoxes(48))
  call compute_scalar_box([ 17, 21, 29 ],masses2_40,RedSet_4(20),ScalarBoxes(49))
  call compute_scalar_box([ 16, 21, 29 ],masses2_40,RedSet_4(21),ScalarBoxes(50))
  call compute_scalar_box([ 16, 17, 29 ],masses2_40,RedSet_4(22),ScalarBoxes(51))
  call compute_scalar_box([ 1, 5, 13 ],masses2_40,RedSet_4(24),ScalarBoxes(52))
  call compute_scalar_box([ 17, 21, 29 ],masses2_51,RedSet_4(20),ScalarBoxes(53))
  call compute_scalar_box([ 16, 17, 29 ],masses2_44,RedSet_4(22),ScalarBoxes(54))
  call compute_scalar_box([ 16, 17, 21 ],masses2_44,RedSet_4(23),ScalarBoxes(55))
  call compute_scalar_box([ 1, 5, 13 ],masses2_51,RedSet_4(24),ScalarBoxes(56))
  call compute_scalar_box([ 17, 21, 29 ],masses2_52,RedSet_4(20),ScalarBoxes(57))
  call compute_scalar_box([ 16, 17, 29 ],masses2_46,RedSet_4(22),ScalarBoxes(58))
  call compute_scalar_box([ 1, 5, 13 ],masses2_52,RedSet_4(24),ScalarBoxes(59))
  call compute_scalar_box([ 17, 25, 29 ],masses2_37,RedSet_4(25),ScalarBoxes(60))
  call compute_scalar_box([ 16, 25, 29 ],masses2_37,RedSet_4(26),ScalarBoxes(61))
  call compute_scalar_box([ 16, 17, 25 ],masses2_37,RedSet_4(27),ScalarBoxes(62))
  call compute_scalar_box([ 1, 9, 13 ],masses2_37,RedSet_4(28),ScalarBoxes(63))
  call compute_scalar_box([ 17, 25, 29 ],masses2_40,RedSet_4(25),ScalarBoxes(64))
  call compute_scalar_box([ 16, 25, 29 ],masses2_40,RedSet_4(26),ScalarBoxes(65))
  call compute_scalar_box([ 1, 9, 13 ],masses2_40,RedSet_4(28),ScalarBoxes(66))
  call compute_scalar_box([ 17, 25, 29 ],masses2_51,RedSet_4(25),ScalarBoxes(67))
  call compute_scalar_box([ 16, 17, 25 ],masses2_44,RedSet_4(27),ScalarBoxes(68))
  call compute_scalar_box([ 1, 9, 13 ],masses2_51,RedSet_4(28),ScalarBoxes(69))
  call compute_scalar_box([ 17, 25, 29 ],masses2_52,RedSet_4(25),ScalarBoxes(70))
  call compute_scalar_box([ 1, 9, 13 ],masses2_52,RedSet_4(28),ScalarBoxes(71))
! end of process

! end do

end subroutine vamp_1

end module ol_vamp_1_pplla_ew_eexuuxa_1_/**/REALKIND
