
module ol_vamp_1_pplla_ew_eexddxa_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplla_ew_eexddxa_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplla_ew_eexddxa_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplla_ew_eexddxa_3_/**/DREALKIND
  use ol_tensor_sum_storage_pplla_ew_eexddxa_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplla_ew_eexddxa_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplla_ew_eexddxa_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(4))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(4),n2h4(4))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(2),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(3),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),2,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(4),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),2,2)
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(2),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(5),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(8),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(11),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(1),n2h16(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,1,2,12],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(7))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,12],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(4),n2h16(8))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[17,2,4,8],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[17,2,8,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[18,1,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(1),m3h4x8(:,3),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[18,1,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(1),m3h4x8(:,4),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[20,2,1,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[20,1,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,6),heltab2x32(:,:,14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[24,2,1,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,5),G0H8(3),m3h4x8(:,7),heltab2x32(:,:,15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[24,1,2,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,5),G0H8(4),m3h4x8(:,8),heltab2x32(:,:,16))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(1),n2h4(5))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(2),n2h4(6))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,7))
  call Hloop_QA_V(ntryL,G1H16(4),ex2(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,8))
  call Hloop_QA_V(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G1H8(2),ex2(:),G1H4(2),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_V(ntryL,G1H8(3),ex1(:),G1H4(3),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G1H8(4),ex1(:),G1H4(4),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(5),n2h4(7))
  call Hloop_VQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(6),n2h4(8))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(7),n2h4(9))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(8),n2h4(10))
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(9),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(9),19,0,G2H4(3),n2h4(11))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(9),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(9),19,0,G2H4(4),n2h4(12))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(3),n2h2(1))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(2),27,0,G2H2(4),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(6),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(6),23,0,G2H2(5),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(7),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(7),27,0,G2H2(6),n2h2(4))
  call Hloop_AQ_V(ntryL,G1H4(5),ex1(:),G1H2(8),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G1H4(6),ex2(:),G1H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_V(ntryL,G1H4(7),ex1(:),G1H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G1H4(8),ex2(:),G1H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(17)])
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(21),ex2(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(22))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(19),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(24),G1H2(1),2)
  call HG1shiftOLR(G1H2(19),4,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(20),mass4set(:,1),  & 
G1H2(2),G1H2(6),G1H2(7),G1H2(3),G1H2(5),2)
  call HG1shiftOLR(G1H2(6),8,2)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(21),mass4set(:,1),  & 
G1H4(9),G1H4(1),G1H4(2),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(1),12,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(22),mass4set(:,1),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(19),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(20),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(21),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(22),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(29),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,7),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H4(1),wf4(:,7),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(32),n2h1(32))
  call Hloop_AV_Q(ntryL,G1H4(4),wf4(:,7),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,7),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,7),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,7),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(36))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(8),G1tensor(14)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(11),G1tensor(20)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(23),G1tensor(17)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(22)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(23),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(2))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(4),mass4set(:,1),  & 
G1tensor(6),G1tensor(8),G1tensor(12),G1tensor(14),G1tensor(18))
  call G_TensorShift(G1tensor(8),10)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(24),mass4set(:,1),  & 
G1tensor(20),G1tensor(24),G1tensor(3),G1tensor(4),G1tensor(11))
  call G_TensorShift(G1tensor(24),1)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(8),mass4set(:,1),  & 
G1tensor(5),G1tensor(9),G1tensor(10),G1tensor(15),G1tensor(16))
  call G_TensorShift(G1tensor(9),9)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(25),mass4set(:,1),  & 
G1tensor(23),G1tensor(17),G1tensor(21),G1tensor(22),G1tensor(25))
  call G_TensorShift(G1tensor(17),8)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(13),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),10)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(26),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(17),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),6)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(3),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(6),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(7),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(10),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(11),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),2)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(12),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),2)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(15),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(16),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),2)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(27),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(28),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),4)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(29),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(30),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),4)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(19),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(20),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(21),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),12)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(22),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),12)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(23),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(4),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(24),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(8),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(25),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(13),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(26),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(17),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(2),mass4set(:,1),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(3),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(6),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(7),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(10),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(11),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(12),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(15),mass4set(:,1),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(16),mass4set(:,1),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(27),mass4set(:,1),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(28),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(29),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(30),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(19),mass4set(:,1),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(20),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(21),mass4set(:,1),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(22),mass4set(:,1),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(1),n2h8(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H8(2),24,0,G1H8(2),n2h8(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,7,8],[0,0,0],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(10))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[17,2,12],[0,0,0],3,2,wf4(:,8),wf4(:,7))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,21))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[18,1,12],[0,0,0],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(4),m3h4x8(:,12),heltab2x32(:,:,22))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,13],[0,0,0],3,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(11))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,1,14],[0,0,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(12))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[19,4,8],[0,0,0],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(9),n2h4(13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,4),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(1),n2h4(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[28,1,2],[0,0,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,13),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(4),n2h4(15))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[28,1,2],[0,0,0],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,15),G0H4(1),m3h8x4(:,4),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(5),n2h4(16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(4)])
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(9),m3h4x2(:,1),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(9),23,0,G2H2(1),n2h2(5))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,1),G1H2(17),m3h4x2(:,2),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(17),27,0,G2H2(2),n2h2(6))
  call Hloop_AQ_V(ntryL,G1H16(1),wf8(:,16),G1H2(12),m3h8x2(:,1),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(3),m3h2x8(:,7),heltab2x16(:,:,10))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,15),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(6),n2h4(17))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,16),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(10),n2h4(18))
  call Hloop_QA_V(ntryL,G1H16(3),ex2(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H4(1),ex3(:),G1H2(4),m3h2x2(:,15),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G1H4(5),ex1(:),G1H2(11),m3h2x2(:,16),heltab2x4(:,:,22))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(7)])
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,7),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H4(3),wf4(:,7),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(42))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,7),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(43))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,7),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(22),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(12),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,14),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,20),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H8(5),wf8(:,18),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(48))
  call ol_merge_tensors(G2tensor(22),[G2tensor(26),G1tensor(112),G1tensor(59),G1tensor(53),G1tensor(44),G0tensor(112),G0tensor(59) &
    ,G0tensor(53),G0tensor(44)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(6),G2tensor(30),G2tensor(27),G1tensor(129),G1tensor(124),G1tensor(120),G1tensor(115) &
    ,G0tensor(129),G0tensor(124),G0tensor(120),G0tensor(115)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(29),G1tensor(117),G1tensor(109),G1tensor(104),G0tensor(117),G0tensor(109) &
    ,G0tensor(104)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(32),G1tensor(122),G1tensor(107),G1tensor(42),G1tensor(13),G0tensor(122) &
    ,G0tensor(107),G0tensor(42),G0tensor(3)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(33),G1tensor(125),G1tensor(80),G1tensor(40),G1tensor(30),G0tensor(125),G0tensor(80) &
    ,G0tensor(40),G0tensor(30)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(127),G1tensor(102),G1tensor(57),G1tensor(3),G0tensor(127),G0tensor(102) &
    ,G0tensor(57),G0tensor(13)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(36),G1tensor(130),G0tensor(130)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(7),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G1tensor(47),[G1tensor(19),G0tensor(47),G0tensor(4)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(11),G1tensor(2),G0tensor(52),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G1tensor(45),[G1tensor(12),G0tensor(45),G0tensor(8)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(50),G1tensor(29),G1tensor(14),G0tensor(75),G0tensor(50),G0tensor(29),G0tensor(9)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(55),G1tensor(16),G1tensor(18),G0tensor(55),G0tensor(20),G0tensor(10)])
  call ol_merge_tensors(G1tensor(88),[G1tensor(83),G1tensor(9),G1tensor(24),G0tensor(88),G0tensor(83),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(4),G0tensor(62),G0tensor(14)])
  call ol_merge_tensors(G1tensor(60),[G1tensor(10),G0tensor(60),G0tensor(18)])
  call ol_merge_tensors(G1tensor(65),[G1tensor(15),G0tensor(65),G0tensor(19)])
  call ol_merge_tensors(G1tensor(103),[G1tensor(27),G1tensor(17),G0tensor(103),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(118),G1tensor(93),G1tensor(67),G1tensor(21),G0tensor(118),G0tensor(93),G0tensor(67) &
    ,G0tensor(23)])
  call ol_merge_tensors(G1tensor(72),[G1tensor(22),G0tensor(72),G0tensor(24)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(128),G1tensor(77),G1tensor(35),G1tensor(25),G0tensor(128),G0tensor(77),G0tensor(35) &
    ,G0tensor(25)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(28),G0tensor(70),G0tensor(28)])
  call ol_merge_tensors(G1tensor(63),[G1tensor(58),G1tensor(37),G1tensor(32),G0tensor(63),G0tensor(58),G0tensor(37) &
    ,G0tensor(32)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(113),G1tensor(98),G1tensor(82),G1tensor(33),G0tensor(113),G0tensor(98),G0tensor(82) &
    ,G0tensor(33)])
  call ol_merge_tensors(G1tensor(87),[G1tensor(34),G0tensor(87),G0tensor(34)])
  call ol_merge_tensors(G1tensor(85),[G1tensor(38),G0tensor(85),G0tensor(38)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(39),G0tensor(90),G0tensor(39)])
  call ol_merge_tensors(G1tensor(97),[G1tensor(48),G1tensor(43),G0tensor(97),G0tensor(48),G0tensor(43)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(119),G1tensor(64),G1tensor(54),G1tensor(49),G0tensor(119),G0tensor(64),G0tensor(54) &
    ,G0tensor(49)])
  call ol_merge_tensors(G1tensor(73),[G1tensor(68),G0tensor(73),G0tensor(68)])
  call ol_merge_tensors(G1tensor(84),[G1tensor(78),G1tensor(69),G0tensor(84),G0tensor(78),G0tensor(69)])
  call ol_merge_tensors(G1tensor(89),[G1tensor(79),G1tensor(74),G0tensor(89),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G1tensor(108),[G1tensor(92),G0tensor(108),G0tensor(92)])
  call ol_merge_tensors(G1tensor(94),[G0tensor(94)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(123),G1tensor(100),G1tensor(95),G0tensor(123),G0tensor(100),G0tensor(95)])
  call ol_merge_tensors(G1tensor(99),[G0tensor(99)])
  call ol_merge_tensors(G1tensor(105),[G0tensor(105)])
  call ol_merge_tensors(G1tensor(110),[G0tensor(110)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(114),G0tensor(114)])
  call TI_triangle_red(G2tensor(22),RedBasis(5),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(28),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(45),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(37),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(10),mass3set(:,1),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
  call TI_triangle_red(G2tensor(35),RedBasis(39),mass3set(:,1),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(116),M2L1R1)
  call TI_triangle_red(G2tensor(4),RedBasis(33),mass3set(:,1),G0tensor(121),G0tensor(126),G0tensor(112),G0tensor(59),M2L1R1)
  call TI_triangle_red(G2tensor(1),RedBasis(1),mass3set(:,1),G0tensor(53),G0tensor(44),G0tensor(129),G0tensor(124),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(31),mass3set(:,1),G0tensor(120),G0tensor(115),G0tensor(117),G0tensor(109),M2L1R1)
  call TI_triangle_red(G2tensor(21),RedBasis(34),mass3set(:,1),G0tensor(104),G0tensor(122),G0tensor(107),G0tensor(42),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(30),mass3set(:,1),G0tensor(3),G0tensor(125),G0tensor(80),G0tensor(40),M2L1R1)
  call TI_triangle_red(G2tensor(3),RedBasis(3),mass3set(:,1),G0tensor(30),G0tensor(127),G0tensor(102),G0tensor(57),M2L1R1)
  call TI_triangle_red(G2tensor(5),RedBasis(32),mass3set(:,1),G0tensor(13),G0tensor(130),G0tensor(7),G0tensor(2),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(29),mass3set(:,1),G0tensor(47),G0tensor(4),G0tensor(52),G0tensor(15),M2L1R1)
  call TI_triangle_red(G1tensor(8),RedBasis(49),mass3set(:,1),G0tensor(5),G0tensor(45),G0tensor(8),G0tensor(75),M2L1R1)
  call TI_triangle_red(G1tensor(47),RedBasis(36),mass3set(:,1),G0tensor(50),G0tensor(29),G0tensor(9),G0tensor(55),M2L1R1)
  call TI_triangle_red(G1tensor(52),RedBasis(35),mass3set(:,1),G0tensor(20),G0tensor(10),G0tensor(88),G0tensor(83),M2L1R1)
  call TI_triangle_red(G1tensor(45),RedBasis(4),mass3set(:,1),G0tensor(17),G0tensor(12),G0tensor(62),G0tensor(14),M2L1R1)
  call TI_triangle_red(G1tensor(75),RedBasis(2),mass3set(:,1),G0tensor(60),G0tensor(18),G0tensor(65),G0tensor(19),M2L1R1)
  call TI_triangle_red(G1tensor(88),RedBasis(17),mass3set(:,1),G0tensor(103),G0tensor(27),G0tensor(22),G0tensor(118),M2L1R1)
  call TI_triangle_red(G1tensor(62),RedBasis(38),mass3set(:,1),G0tensor(93),G0tensor(67),G0tensor(23),G0tensor(72),M2L1R1)
  call TI_triangle_red(G1tensor(60),RedBasis(8),mass3set(:,1),G0tensor(24),G0tensor(128),G0tensor(77),G0tensor(35),M2L1R1)
  call TI_triangle_red(G1tensor(65),RedBasis(7),mass3set(:,1),G0tensor(25),G0tensor(70),G0tensor(28),G0tensor(63),M2L1R1)
  call TI_triangle_red(G1tensor(103),RedBasis(46),mass3set(:,1),G0tensor(58),G0tensor(37),G0tensor(32),G0tensor(113),M2L1R1)
  call TI_triangle_red(G1tensor(72),RedBasis(40),mass3set(:,1),G0tensor(98),G0tensor(82),G0tensor(33),G0tensor(87),M2L1R1)
  call TI_triangle_red(G1tensor(70),RedBasis(12),mass3set(:,1),G0tensor(34),G0tensor(85),G0tensor(38),G0tensor(90),M2L1R1)
  call TI_triangle_red(G1tensor(63),RedBasis(9),mass3set(:,1),G0tensor(39),G0tensor(97),G0tensor(48),G0tensor(43),M2L1R1)
  call TI_triangle_red(G1tensor(87),RedBasis(41),mass3set(:,1),G0tensor(119),G0tensor(64),G0tensor(54),G0tensor(49),M2L1R1)
  call TI_triangle_red(G1tensor(85),RedBasis(16),mass3set(:,1),G0tensor(73),G0tensor(68),G0tensor(84),G0tensor(78),M2L1R1)
  call TI_triangle_red(G1tensor(90),RedBasis(15),mass3set(:,1),G0tensor(69),G0tensor(89),G0tensor(79),G0tensor(74),M2L1R1)
  call TI_triangle_red(G1tensor(97),RedBasis(6),mass3set(:,1),G0tensor(108),G0tensor(92),G0tensor(94),G0tensor(123),M2L1R1)
  call TI_triangle_red(G1tensor(73),RedBasis(14),mass3set(:,1),G0tensor(100),G0tensor(95),G0tensor(99),G0tensor(105),M2L1R1)
  call TI_triangle_red(G1tensor(84),RedBasis(13),mass3set(:,1),G0tensor(110),G0tensor(114),G0tensor(131),G0tensor(132),M2L1R1)
  call TI_triangle_red(G1tensor(89),RedBasis(11),mass3set(:,1),G0tensor(133),G0tensor(134),G0tensor(135),G0tensor(136),M2L1R1)
  call TI_triangle_red(G1tensor(108),RedBasis(48),mass3set(:,1),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140),M2L1R1)
  call TI_triangle_red(G1tensor(94),RedBasis(42),mass3set(:,1),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),M2L1R1)
  call TI_triangle_red(G1tensor(99),RedBasis(43),mass3set(:,1),G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),M2L1R1)
  call TI_triangle_red(G1tensor(105),RedBasis(44),mass3set(:,1),G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152),M2L1R1)
  call TI_triangle_red(G1tensor(110),RedBasis(47),mass3set(:,1),G0tensor(153),G0tensor(154),G0tensor(155),G0tensor(156),M2L1R1)
  call ol_merge_tensors(T0sum(27),[G0tensor(1)])
  call ol_merge_tensors(T0sum(28),[G0tensor(21)])
  call ol_merge_tensors(T0sum(29),[G0tensor(41)])
  call ol_merge_tensors(T0sum(30),[G0tensor(61)])
  call ol_merge_tensors(T0sum(31),[G0tensor(81)])
  call ol_merge_tensors(T0sum(32),[G0tensor(101)])
  call ol_merge_tensors(T0sum(33),[G0tensor(121)])
  call ol_merge_tensors(T0sum(34),[G0tensor(5)])
  call ol_merge_tensors(T0sum(35),[G0tensor(50)])
  call ol_merge_tensors(T0sum(36),[G0tensor(20)])
  call ol_merge_tensors(T0sum(37),[G0tensor(17)])
  call ol_merge_tensors(T0sum(38),[G0tensor(60)])
  call ol_merge_tensors(T0sum(39),[G0tensor(53)])
  call ol_merge_tensors(T0sum(40),[G0tensor(103)])
  call ol_merge_tensors(T0sum(41),[G0tensor(93)])
  call ol_merge_tensors(T0sum(42),[G0tensor(24)])
  call ol_merge_tensors(T0sum(43),[G0tensor(25)])
  call ol_merge_tensors(T0sum(44),[G0tensor(58)])
  call ol_merge_tensors(T0sum(45),[G0tensor(120)])
  call ol_merge_tensors(T0sum(46),[G0tensor(98)])
  call ol_merge_tensors(T0sum(47),[G0tensor(104)])
  call ol_merge_tensors(T0sum(48),[G0tensor(34)])
  call ol_merge_tensors(T0sum(49),[G0tensor(39)])
  call ol_merge_tensors(T0sum(50),[G0tensor(3)])
  call ol_merge_tensors(T0sum(51),[G0tensor(119)])
  call ol_merge_tensors(T0sum(52),[G0tensor(73)])
  call ol_merge_tensors(T0sum(53),[G0tensor(69)])
  call ol_merge_tensors(T0sum(54),[G0tensor(108)])
  call ol_merge_tensors(T0sum(55),[G0tensor(30)])
  call ol_merge_tensors(T0sum(56),[G0tensor(100)])
  call ol_merge_tensors(T0sum(57),[G0tensor(110)])
  call ol_merge_tensors(T0sum(58),[G0tensor(133)])
  call ol_merge_tensors(T0sum(59),[G0tensor(137)])
  call ol_merge_tensors(T0sum(60),[G0tensor(141)])
  call ol_merge_tensors(T0sum(61),[G0tensor(13)])
  call ol_merge_tensors(T0sum(62),[G0tensor(145)])
  call ol_merge_tensors(T0sum(63),[G0tensor(149)])
  call ol_merge_tensors(T0sum(64),[G0tensor(153)])
  call ol_merge_tensors(T0sum(65),[G0tensor(47)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[20,11],[0,0],2,2,wf4(:,3),wf8(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,13),heltab2x32(:,:,29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[24,7],[0,0],2,2,wf4(:,5),wf8(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,14),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(2),24,0,G1H8(6),n2h8(7))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[17,14],[0,0],2,2,wf4(:,8),wf8(:,18))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(3),m3h4x8(:,15),heltab2x32(:,:,31))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[18,13],[0,0],2,2,wf4(:,10),wf8(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(4),m3h4x8(:,16),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(4),18,0,G1H8(1),n2h8(8))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,14),G0H1(1),m3h8x1(:,4),heltab2x8(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(1),n2h1(49))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(6),wf8(:,16),G1tensor(6),m3h8x1(:,5),heltab2x8(:,:,23))
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,18),G0H1(1),m3h8x1(:,6),heltab2x8(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(20),n2h1(50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(1),wf8(:,20),G1tensor(5),m3h8x1(:,7),heltab2x8(:,:,25))
  call ol_merge_tensors(G0tensor(88),[G0tensor(116),G0tensor(76),G0tensor(46),G0tensor(26),G0tensor(6)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(95),G0tensor(94),G0tensor(68),G0tensor(48),G0tensor(33),G0tensor(102) &
    ,G0tensor(125),G0tensor(117),G0tensor(11)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(35),G0tensor(14),G0tensor(4),G0tensor(129),G0tensor(16)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(7),G0tensor(40),G0tensor(107),G0tensor(109),G0tensor(31)])
  call ol_merge_tensors(G0tensor(136),[G0tensor(74),G0tensor(63),G0tensor(19),G0tensor(15),G0tensor(57),G0tensor(124),G0tensor(59) &
    ,G0tensor(96),G0tensor(36)])
  call ol_merge_tensors(G0tensor(147),[G0tensor(139),G0tensor(54),G0tensor(85),G0tensor(32),G0tensor(27),G0tensor(10),G0tensor(45) &
    ,G0tensor(52),G0tensor(80),G0tensor(115),G0tensor(44),G0tensor(51)])
  call ol_merge_tensors(G1tensor(6),[G0tensor(156),G0tensor(152),G0tensor(72),G0tensor(83),G0tensor(55),G0tensor(127) &
    ,G0tensor(56)])
  call ol_merge_tensors(G0tensor(154),[G0tensor(97),G0tensor(37),G0tensor(23),G0tensor(12),G0tensor(8),G0tensor(122),G0tensor(111) &
    ,G0tensor(86),G0tensor(66)])
  call ol_merge_tensors(G0tensor(150),[G0tensor(138),G0tensor(135),G0tensor(131),G0tensor(99),G0tensor(92),G0tensor(128) &
    ,G0tensor(22),G0tensor(9),G0tensor(130),G0tensor(126),G0tensor(106),G0tensor(71)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(148),G0tensor(144),G0tensor(132),G0tensor(78),G0tensor(90),G0tensor(2) &
    ,G0tensor(91)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(134),G0tensor(49),G0tensor(87),G0tensor(42),G0tensor(112)])
  call ol_merge_tensors(G0tensor(151),[G0tensor(82),G0tensor(113),G0tensor(18),G0tensor(29),G0tensor(75)])
  call ol_merge_tensors(G0tensor(146),[G0tensor(105),G0tensor(123),G0tensor(38),G0tensor(65),G0tensor(62)])
  call ol_merge_tensors(G0tensor(155),[G0tensor(142),G0tensor(140),G0tensor(79),G0tensor(84),G0tensor(70),G0tensor(67) &
    ,G0tensor(118)])
  call ol_merge_tensors(G0tensor(89),[G0tensor(64),G0tensor(43),G0tensor(28),G0tensor(77)])
call TI_bubble_red(G1tensor(1),20,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(6),24,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(20),17,mass2set(:,1),G0tensor(41),M2L1R1)
call TI_bubble_red(G1tensor(5),18,mass2set(:,1),G0tensor(61),M2L1R1)
  call ol_merge_tensors(T0sum(66),[G0tensor(88)])
  call ol_merge_tensors(T0sum(67),[G0tensor(143)])
  call ol_merge_tensors(T0sum(68),[G0tensor(1)])
  call ol_merge_tensors(T0sum(69),[G0tensor(114)])
  call ol_merge_tensors(T0sum(70),[G0tensor(136)])
  call ol_merge_tensors(T0sum(71),[G0tensor(147)])
  call ol_merge_tensors(T0sum(72),[G0tensor(21)])
  call ol_merge_tensors(T0sum(73),[G0tensor(154)])
  call ol_merge_tensors(T0sum(74),[G0tensor(150)])
  call ol_merge_tensors(T0sum(75),[G0tensor(41)])
  call ol_merge_tensors(T0sum(76),[G0tensor(61)])
  call ol_merge_tensors(T0sum(77),[G0tensor(151)])
  call ol_merge_tensors(T0sum(78),[G0tensor(146)])
  call ol_merge_tensors(T0sum(79),[G0tensor(155)])
  call ol_merge_tensors(T0sum(80),[G0tensor(89)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_3,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_3,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_3,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_3,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_3,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 20, 22, 23 ],masses2_3,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 22, 23 ],masses2_3,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 20, 22 ],masses2_3,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 4, 6, 7 ],masses2_3,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 17, 21, 29 ],masses2_3,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 16, 21, 29 ],masses2_3,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 17, 29 ],masses2_3,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 16, 17, 21 ],masses2_3,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 1, 5, 13 ],masses2_3,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 17, 25, 29 ],masses2_3,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 16, 25, 29 ],masses2_3,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 16, 17, 25 ],masses2_3,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 1, 9, 13 ],masses2_3,RedSet_4(18),ScalarBoxes(18))
! end of process

! end do

end subroutine vamp_1

end module ol_vamp_1_pplla_ew_eexddxa_3_/**/REALKIND
