
module ol_vamp_1_pplla_ew_eexaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplla_ew_eexaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplla_ew_eexaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplla_ew_eexaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplla_ew_eexaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplla_ew_eexaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplla_ew_eexaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,5),heltab2x32(:,:,5))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(5),n2h16(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(6),n2h16(4))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(9),n2h16(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(10),n2h16(6))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(13),n2h16(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(14),n2h16(8))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,21),heltab2x32(:,:,21))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,22),heltab2x32(:,:,22))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,23),heltab2x32(:,:,23))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,24),heltab2x32(:,:,24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(17),n2h16(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(18),n2h16(10))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(21),n2h16(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(22),n2h16(12))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_SV_V(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_SV_V(ntryL,G0H16(1),ex3(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_UW_V(ntryL,G0H16(2),16,ex3(:),4,G1H8(2),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_UW_V(ntryL,G1H16(4),16,ex3(:),4,G2H8(3),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G1H16(5),ex2(:),G1H8(3),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_Z(ntryL,G1H16(6),ex2(:),G1H8(4),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_WA_Q(ntryL,G0H16(3),ex2(:),G0H8(2),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(2),18,0,G1H8(5),n2h8(3))
  call Hloop_WA_Q(ntryL,G1H16(7),ex2(:),G1H8(6),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(6),18,0,G2H8(4),n2h8(4))
  call Hloop_WA_Q(ntryL,G0H16(4),ex2(:),G0H8(2),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(2),18,0,G1H8(6),n2h8(5))
  call Hloop_WA_Q(ntryL,G1H16(8),ex2(:),G1H8(7),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(7),18,0,G2H8(5),n2h8(6))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(7),20,0,G2H8(6),n2h8(7))
  call Hloop_QV_A(ntryL,G1H16(10),ex3(:),G1H8(7),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(7),20,0,G2H8(7),n2h8(8))
  call Hloop_SV_V(ntryL,G1H16(11),ex3(:),G1H8(7),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_SV_V(ntryL,G0H16(5),ex3(:),G0H8(2),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_UV_W(ntryL,G0H16(6),16,ex3(:),4,G1H8(8),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_UV_W(ntryL,G1H16(12),16,ex3(:),4,G2H8(8),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(9),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_Z(ntryL,G1H16(14),ex2(:),G1H8(10),ngZl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_WA_Q(ntryL,G0H16(7),ex2(:),G0H8(3),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(3),18,0,G1H8(11),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(15),ex2(:),G1H8(12),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(9),n2h8(10))
  call Hloop_WA_Q(ntryL,G0H16(8),ex2(:),G0H8(3),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(3),18,0,G1H8(12),n2h8(11))
  call Hloop_WA_Q(ntryL,G1H16(16),ex2(:),G1H8(13),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(13),18,0,G2H8(10),n2h8(12))
  call Hloop_AQ_V(ntryL,G1H16(17),ex1(:),G1H8(13),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(14),ngZl,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_WQ_A(ntryL,G0H16(9),ex1(:),G0H8(3),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(15),n2h8(13))
  call Hloop_WQ_A(ntryL,G1H16(19),ex1(:),G1H8(16),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(11),n2h8(14))
  call Hloop_WQ_A(ntryL,G0H16(10),ex1(:),G0H8(3),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(16),n2h8(15))
  call Hloop_WQ_A(ntryL,G1H16(20),ex1(:),G1H8(17),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(17),17,0,G2H8(12),n2h8(16))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(17),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(18),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_WQ_A(ntryL,G0H16(11),ex1(:),G0H8(3),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(19),n2h8(17))
  call Hloop_WQ_A(ntryL,G1H16(23),ex1(:),G1H8(20),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(20),17,0,G2H8(13),n2h8(18))
  call Hloop_WQ_A(ntryL,G0H16(12),ex1(:),G0H8(3),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(20),n2h8(19))
  call Hloop_WQ_A(ntryL,G1H16(24),ex1(:),G1H8(21),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(21),17,0,G2H8(14),n2h8(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(2)])
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(1))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(21),G1H8(1),G1H8(7),G1H8(2),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(4),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZl,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(5),n2h4(3))
  call Hloop_AQ_W(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(6),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_W(ntryL,G1H8(6),ex1(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_W(ntryL,G2H8(5),ex1(:),G2H4(7),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(6),ex2(:),G2H4(8),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_Z(ntryL,G2H8(7),ex2(:),G2H4(9),ngZl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(3),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(10),n2h4(4))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(2),mass5set(:,1),  & 
G1H8(3),G1H8(4),G1H8(5),G1H8(6),G1H8(8),G1H8(24),8)
  call HG1shiftOLR(G1H8(4),8,8)
  call Hloop_VQ_A(ntryL,G1H8(9),ex1(:),G1H4(3),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(3),19,0,G2H4(11),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex1(:),G1H4(3),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(3),19,0,G2H4(12),n2h4(6))
  call Hloop_AQ_W(ntryL,G1H8(11),ex1(:),G1H4(3),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_W(ntryL,G2H8(9),ex1(:),G2H4(13),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_W(ntryL,G1H8(12),ex1(:),G1H4(4),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G2H8(10),ex1(:),G2H4(14),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(5),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(15),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex2(:),G1H4(5),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(16),n2h4(8))
  call Hloop_QA_W(ntryL,G1H8(15),ex2(:),G1H4(5),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_W(ntryL,G2H8(11),ex2(:),G2H4(17),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_W(ntryL,G1H8(16),ex2(:),G1H4(6),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(18),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(7),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(19),n2h4(9))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex2(:),G1H4(7),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(20),n2h4(10))
  call Hloop_QA_W(ntryL,G1H8(19),ex2(:),G1H4(7),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_W(ntryL,G2H8(13),ex2(:),G2H4(21),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_W(ntryL,G1H8(20),ex2(:),G1H4(8),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_W(ntryL,G2H8(14),ex2(:),G2H4(22),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_WQ_A(ntryL,G1H8(21),ex1(:),G1H4(9),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(23),n2h4(11))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1),-8,ex4(:),8,G2H4(24),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(9),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(25),n2h4(12))
  call Hloop_WQ_A(ntryL,G1H8(22),ex1(:),G1H4(9),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(26),n2h4(13))
  call Hloop_WQ_A(ntryL,G1H8(23),ex1(:),G1H4(9),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(27),n2h4(14))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(9),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(28),n2h4(15))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(4),-8,ex4(:),8,G2H4(29),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_WA_Q(ntryL,G1H8(6),ex2(:),G1H4(9),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(30),n2h4(16))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(9),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(31),n2h4(17))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(9),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(32),n2h4(18))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,2),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,3),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hloop_QA_W(ntryL,G2H4(3),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(3),mass5set(:,2),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(3),mass5set(:,4),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hloop_VV_S(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VV_S(ntryL,G2H4(6),ex3(:),G2H2(2),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_UV_W(ntryL,G1H4(2),19,ex3(:),4,G2H2(3),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,5),  & 
G1H4(1),G1H4(2),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(2),mass5set(:,2),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(2),mass5set(:,3),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hloop_AQ_W(ntryL,G2H4(10),ex1(:),G2H2(4),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(4),mass5set(:,2),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(4),mass5set(:,4),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hloop_VV_S(ntryL,G1H4(3),ex4(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VV_S(ntryL,G2H4(13),ex4(:),G2H2(5),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_UV_W(ntryL,G1H4(4),19,ex4(:),8,G2H2(6),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(4),mass5set(:,5),  & 
G1H4(3),G1H4(4),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(4),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(5),mass5set(:,2),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(5),mass5set(:,4),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hloop_VV_S(ntryL,G1H4(5),ex3(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_VV_S(ntryL,G2H4(17),ex3(:),G2H2(7),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_UW_V(ntryL,G1H4(6),19,ex3(:),4,G2H2(8),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(5),mass5set(:,5),  & 
G1H4(5),G1H4(6),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(6),mass5set(:,2),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(6),mass5set(:,4),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),4,4)
  call Hloop_VV_S(ntryL,G1H4(7),ex4(:),G1H2(4),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VV_S(ntryL,G2H4(21),ex4(:),G2H2(9),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_UW_V(ntryL,G1H4(8),19,ex4(:),8,G2H2(10),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(6),mass5set(:,5),  & 
G1H4(7),G1H4(8),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_QA_W(ntryL,G2H4(23),ex2(:),G2H2(11),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_W(ntryL,G2H4(26),ex2(:),G2H2(12),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_W(ntryL,G2H4(27),ex2(:),G2H2(13),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_W(ntryL,G2H4(28),ex1(:),G2H2(14),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_W(ntryL,G2H4(31),ex1(:),G2H2(15),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_W(ntryL,G2H4(32),ex1(:),G2H2(16),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(17),n2h2(1))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-8,0,G2H4(1),n2h4(19))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(18),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(19),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(14),ex2(:),G1H2(5),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(20),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex2(:),G1H2(5),ngZl,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(21),n2h2(4))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-8,0,G2H4(2),n2h4(20))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(22),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex2(:),G1H2(5),ngZl,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(23),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(20),ex2(:),G1H2(5),ngZl,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(24),n2h2(6))
  call Hloop_QV_A(ntryL,G1H4(21),ex3(:),G1H2(5),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(25),n2h2(7))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-8,0,G2H4(3),n2h4(21))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(26),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(5),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(27),n2h2(8))
  call Hloop_QV_A(ntryL,G1H4(26),ex3(:),G1H2(5),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(28),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(27),ex3(:),G1H2(5),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(29),n2h2(10))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-8,0,G2H4(4),n2h4(22))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(30),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(31),ex3(:),G1H2(5),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(31),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(32),ex3(:),G1H2(5),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(32),n2h2(12))
  call Hloop_UV_W(ntryL,G1H4(1),19,ex3(:),4,G2H2(33),m3h2x2(:,37),heltab2x4(:,:,37))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(2),-8,ex4(:),8,G2H2(34),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_UV_W(ntryL,G1H4(35),19,ex3(:),4,G2H2(35),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_UV_W(ntryL,G1H4(36),19,ex3(:),4,G2H2(36),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(5),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(37),n2h2(13))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-8,0,G2H4(5),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(38),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(5),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(39),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H4(42),ex1(:),G1H2(5),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(40),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(43),ex1(:),G1H2(5),ngZl,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(41),n2h2(16))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,0,G2H4(6),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(42),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex1(:),G1H2(5),ngZl,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(43),n2h2(17))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex1(:),G1H2(5),ngZl,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(44),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(49),ex4(:),G1H2(5),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(45),n2h2(19))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-4,0,G2H4(7),n2h4(26))
  call Hloop_AV_Q(ntryL,G2H4(7),ex3(:),G2H2(46),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QV_A(ntryL,G1H4(53),ex4(:),G1H2(5),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(47),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(54),ex4(:),G1H2(5),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(48),n2h2(21))
  call Hloop_QV_A(ntryL,G1H4(55),ex4(:),G1H2(5),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(49),n2h2(22))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-4,0,G2H4(8),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(8),ex3(:),G2H2(50),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(59),ex4(:),G1H2(5),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(51),n2h2(23))
  call Hloop_QV_A(ntryL,G1H4(60),ex4(:),G1H2(5),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(52),n2h2(24))
  call Hloop_UV_W(ntryL,G1H4(3),19,ex4(:),8,G2H2(53),m3h2x2(:,57),heltab2x4(:,:,57))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(4),-4,ex3(:),4,G2H2(54),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_UV_W(ntryL,G1H4(63),19,ex4(:),8,G2H2(55),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_UV_W(ntryL,G1H4(64),19,ex4(:),8,G2H2(56),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AV_Q(ntryL,G1H4(65),ex3(:),G1H2(5),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(57),n2h2(25))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(66),-8,0,G2H4(9),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(9),ex4(:),G2H2(58),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_AV_Q(ntryL,G1H4(69),ex3(:),G1H2(5),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(59),n2h2(26))
  call Hloop_AV_Q(ntryL,G1H4(70),ex3(:),G1H2(5),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(60),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H4(71),ex3(:),G1H2(5),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(61),n2h2(28))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(72),-8,0,G2H4(10),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(10),ex4(:),G2H2(62),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AV_Q(ntryL,G1H4(75),ex3(:),G1H2(5),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(63),n2h2(29))
  call Hloop_AV_Q(ntryL,G1H4(76),ex3(:),G1H2(5),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(64),n2h2(30))
  call Hloop_UW_V(ntryL,G1H4(5),19,ex3(:),4,G2H2(65),m3h2x2(:,69),heltab2x4(:,:,69))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(6),-8,ex4(:),8,G2H2(66),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UW_V(ntryL,G1H4(79),19,ex3(:),4,G2H2(67),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_UW_V(ntryL,G1H4(80),19,ex3(:),4,G2H2(68),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AV_Q(ntryL,G1H4(81),ex4(:),G1H2(5),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(69),n2h2(31))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-4,0,G2H4(11),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(11),ex3(:),G2H2(70),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AV_Q(ntryL,G1H4(85),ex4(:),G1H2(5),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(71),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H4(86),ex4(:),G1H2(5),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(72),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(87),ex4(:),G1H2(5),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(73),n2h2(34))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-4,0,G2H4(12),n2h4(33))
  call Hloop_QV_A(ntryL,G2H4(12),ex3(:),G2H2(74),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AV_Q(ntryL,G1H4(91),ex4(:),G1H2(5),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(75),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H4(92),ex4(:),G1H2(5),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(76),n2h2(36))
  call Hloop_UW_V(ntryL,G1H4(7),19,ex4(:),8,G2H2(77),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(8),-4,ex3(:),4,G2H2(78),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_UW_V(ntryL,G1H4(95),19,ex4(:),8,G2H2(79),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_UW_V(ntryL,G1H4(96),19,ex4(:),8,G2H2(80),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(1),23,ex4(:),8,G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(2),27,ex3(:),4,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(3),23,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(4),27,ex3(:),4,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(1),mass5set(:,1),  & 
G1H2(5),G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(6),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),10,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(2),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),9,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,2),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(1),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),10,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(1),mass5set(:,3),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(1),mass4set(:,3),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),10,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(3),mass5set(:,2),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(3),mass4set(:,2),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),12,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(3),mass5set(:,4),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(3),mass4set(:,4),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),12,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(3),mass5set(:,5),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(3),mass4set(:,5),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(74),12,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(2),mass5set(:,2),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(79),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,2),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(85),9,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(2),mass5set(:,3),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(2),mass4set(:,3),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(96),9,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(4),mass5set(:,2),  & 
G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),2)
  call HG1shiftOLR(G1H2(101),4,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(3),mass4set(:,2),  & 
G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(107),12,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(4),mass5set(:,4),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),4,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(3),mass4set(:,4),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(118),12,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(4),mass5set(:,5),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(123),4,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(3),mass4set(:,5),  & 
G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(129),12,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(5),mass5set(:,2),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(4),mass4set(:,2),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(140),12,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(5),mass5set(:,4),  & 
G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(145),8,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(4),mass4set(:,4),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(151),12,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(5),mass5set(:,5),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),8,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(4),mass4set(:,5),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),2)
  call HG1shiftOLR(G1H2(162),12,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(6),mass5set(:,2),  & 
G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(167),4,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(4),mass4set(:,2),  & 
G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(173),12,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(6),mass5set(:,4),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),4,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(4),mass4set(:,4),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(184),12,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(6),mass5set(:,5),  & 
G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(4),mass4set(:,5),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(195),12,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(161),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(193)])
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(5),23,ex4(:),8,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1),0,ex4(:),8,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(7),23,ex4(:),8,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(8),2,ex4(:),8,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(13),0,ex4(:),8,G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),23,ex4(:),8,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),1,ex4(:),8,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_AV_Q(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(26),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(30),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(34),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(38),n2h1(20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(67),23,ex4(:),8,G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(68),0,ex4(:),8,G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(73),23,ex4(:),8,G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(74),4,ex4(:),8,G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(44),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(46),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(48),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(50),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(101),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(52),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(106),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(107),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(54),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(111),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(112),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(56),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(117),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(58),n2h1(38))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(122),27,ex3(:),4,G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(123),0,ex3(:),4,G2tensor(60),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(128),27,ex3(:),4,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(129),8,ex3(:),4,G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hloop_AV_Q(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(139),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(66),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(70),n2h1(48))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(155),23,ex4(:),8,G2tensor(71),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(156),0,ex4(:),8,G2tensor(72),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(161),23,ex4(:),8,G2tensor(73),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(162),4,ex4(:),8,G2tensor(74),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hloop_AV_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(172),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(173),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(78),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(177),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(80),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(183),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(82),n2h1(58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(188),27,ex3(:),4,G2tensor(83),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(189),0,ex3(:),4,G2tensor(84),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(194),27,ex3(:),4,G2tensor(85),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(195),8,ex3(:),4,G2tensor(86),m3h2x1(:,86),heltab2x2(:,:,86))
  call ol_merge_tensors(G2tensor(15),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(4),G2tensor(3),G2tensor(2)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(8),G2tensor(7),G2tensor(6)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(11),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(14),G2tensor(13),G2tensor(12)])
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,5),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(4),mass5set(:,5),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(5),mass5set(:,5),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(6),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(1),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(1),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(3),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(3),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(2),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(2),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(4),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(4),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(5),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(5),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(6),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(6),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(2),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(4),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMM,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(3),16,nML,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(4),16,0,G1H16(6),n2h16(16))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMM,G1H16(7),n2h16(17))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(6),16,nML,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(9),n2h16(19))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMT,G1H16(10),n2h16(20))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(11),n2h16(21))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(10),16,nMT,G1H16(12),n2h16(22))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(11),16,0,G1H16(13),n2h16(23))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMB,G1H16(14),n2h16(24))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(25))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(16),n2h16(26))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(17),n2h16(27))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMM,G1H16(18),n2h16(28))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(5),16,nML,G1H16(19),n2h16(29))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(6),16,0,G1H16(20),n2h16(30))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMM,G1H16(21),n2h16(31))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(8),16,nML,G1H16(22),n2h16(32))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(23),n2h16(33))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(10),16,nMT,G1H16(24),n2h16(34))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(25),n2h16(35))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMT,G1H16(26),n2h16(36))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(37))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMB,G1H16(28),n2h16(38))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(29),n2h16(39))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(30),n2h16(40))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,67),heltab2x32(:,:,67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,68),heltab2x32(:,:,68))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,69),heltab2x32(:,:,69))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,71),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(36),m3h2x16(:,72),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,73),heltab2x32(:,:,73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(38),m3h2x16(:,74),heltab2x32(:,:,74))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(40),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(42),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,81),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,82),heltab2x32(:,:,82))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,84),heltab2x32(:,:,84))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,85),heltab2x32(:,:,85))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,89),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,91),heltab2x32(:,:,91))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,93),heltab2x32(:,:,93))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,94),heltab2x32(:,:,94))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,95),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,96),heltab2x32(:,:,96))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,100),heltab2x32(:,:,100))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,101),heltab2x32(:,:,101))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,102),heltab2x32(:,:,102))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,104),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,105),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,107),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,112),heltab2x32(:,:,112))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,113),heltab2x32(:,:,113))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,114),heltab2x32(:,:,114))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,115),heltab2x32(:,:,115))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,116),heltab2x32(:,:,116))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,117),heltab2x32(:,:,117))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,120),heltab2x32(:,:,120))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,123),heltab2x32(:,:,123))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,124),heltab2x32(:,:,124))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,125),heltab2x32(:,:,125))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,127),heltab2x32(:,:,127))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,128),heltab2x32(:,:,128))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,129),heltab2x32(:,:,129))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,130),heltab2x32(:,:,130))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,131),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,132),heltab2x32(:,:,132))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,133),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,135),heltab2x32(:,:,135))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,136),heltab2x32(:,:,136))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(71),n2h16(41))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMM,G1H16(72),n2h16(42))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(73),n2h16(43))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(74),n2h16(44))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMM,G1H16(75),n2h16(45))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(33),16,nML,G1H16(76),n2h16(46))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(77),n2h16(47))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(78),n2h16(48))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(79),n2h16(49))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMT,G1H16(80),n2h16(50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(81),n2h16(51))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(82),n2h16(52))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(83),n2h16(53))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMB,G1H16(84),n2h16(54))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(85),n2h16(55))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMM,G1H16(86),n2h16(56))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(87),n2h16(57))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(88),n2h16(58))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMM,G1H16(89),n2h16(59))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H16(33),16,nML,G1H16(90),n2h16(60))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(91),n2h16(61))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(92),n2h16(62))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(93),n2h16(63))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMT,G1H16(94),n2h16(64))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(95),n2h16(65))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(96),n2h16(66))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(97),n2h16(67))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMB,G1H16(98),n2h16(68))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,170),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(103),m3h2x16(:,171),heltab2x32(:,:,171))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,172),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(105),m3h2x16(:,173),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,174),heltab2x32(:,:,174))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(107),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,176),heltab2x32(:,:,176))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(109),m3h2x16(:,177),heltab2x32(:,:,177))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,178),heltab2x32(:,:,178))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,179),heltab2x32(:,:,179))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,180),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,181),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,182),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,183),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,184),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,186),heltab2x32(:,:,186))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,187),heltab2x32(:,:,187))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,188),heltab2x32(:,:,188))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,189),heltab2x32(:,:,189))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,190),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,191),heltab2x32(:,:,191))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,192),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,193),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,194),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,195),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,196),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,197),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,198),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,199),heltab2x32(:,:,199))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,200),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,201),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,202),heltab2x32(:,:,202))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,203),heltab2x32(:,:,203))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,204),heltab2x32(:,:,204))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,205),heltab2x32(:,:,205))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,206),heltab2x32(:,:,206))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,207),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,208),heltab2x32(:,:,208))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,209),heltab2x32(:,:,209))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,210),heltab2x32(:,:,210))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,211),heltab2x32(:,:,211))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,212),heltab2x32(:,:,212))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,213),heltab2x32(:,:,213))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,214),heltab2x32(:,:,214))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,215),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,216),heltab2x32(:,:,216))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,217),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,218),heltab2x32(:,:,218))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,219),heltab2x32(:,:,219))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(128),m3h2x16(:,220),heltab2x32(:,:,220))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(129),m3h2x16(:,221),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(130),m3h2x16(:,222),heltab2x32(:,:,222))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(131),m3h2x16(:,223),heltab2x32(:,:,223))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,224),heltab2x32(:,:,224))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(133),m3h2x16(:,225),heltab2x32(:,:,225))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(134),m3h2x16(:,226),heltab2x32(:,:,226))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(135),m3h2x16(:,227),heltab2x32(:,:,227))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(136),m3h2x16(:,228),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(137),m3h2x16(:,229),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,230),heltab2x32(:,:,230))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,231),heltab2x32(:,:,231))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,232),heltab2x32(:,:,232))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,233),heltab2x32(:,:,233))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,234),heltab2x32(:,:,234))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,235),heltab2x32(:,:,235))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,236),heltab2x32(:,:,236))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,237),heltab2x32(:,:,237))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,238),heltab2x32(:,:,238))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,239),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(139),n2h16(69))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,240),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMM,G1H16(140),n2h16(70))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,241),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G0H16(65),16,nML,G1H16(141),n2h16(71))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(142),n2h16(72))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMM,G1H16(143),n2h16(73))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(65),16,nML,G1H16(144),n2h16(74))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(145),n2h16(75))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMT,G1H16(146),n2h16(76))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(147),n2h16(77))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMT,G1H16(148),n2h16(78))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(149),n2h16(79))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,250),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMB,G1H16(150),n2h16(80))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,251),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(151),n2h16(81))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,252),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMB,G1H16(152),n2h16(82))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(153),n2h16(83))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMM,G1H16(154),n2h16(84))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G0H16(65),16,nML,G1H16(155),n2h16(85))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(156),n2h16(86))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMM,G1H16(157),n2h16(87))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(65),16,nML,G1H16(158),n2h16(88))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(159),n2h16(89))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMT,G1H16(160),n2h16(90))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,261),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(161),n2h16(91))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,262),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMT,G1H16(162),n2h16(92))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,263),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(163),n2h16(93))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMB,G1H16(164),n2h16(94))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(165),n2h16(95))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMB,G1H16(166),n2h16(96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,267),heltab2x32(:,:,267))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,268),heltab2x32(:,:,268))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,269),heltab2x32(:,:,269))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,270),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,271),heltab2x32(:,:,271))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(172),m3h2x16(:,272),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,273),heltab2x32(:,:,273))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(174),m3h2x16(:,274),heltab2x32(:,:,274))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,275),heltab2x32(:,:,275))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(176),m3h2x16(:,276),heltab2x32(:,:,276))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,277),heltab2x32(:,:,277))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(178),m3h2x16(:,278),heltab2x32(:,:,278))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(179),m3h2x16(:,279),heltab2x32(:,:,279))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(180),m3h2x16(:,280),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(181),m3h2x16(:,281),heltab2x32(:,:,281))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(182),m3h2x16(:,282),heltab2x32(:,:,282))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,283),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(184),m3h2x16(:,284),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,285),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(186),m3h2x16(:,286),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,287),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,288),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,289),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,290),heltab2x32(:,:,290))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(187),m3h2x16(:,291),heltab2x32(:,:,291))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(188),m3h2x16(:,292),heltab2x32(:,:,292))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(189),m3h2x16(:,293),heltab2x32(:,:,293))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(190),m3h2x16(:,294),heltab2x32(:,:,294))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,295),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,296),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,297),heltab2x32(:,:,297))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,298),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,299),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,300),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,301),heltab2x32(:,:,301))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,302),heltab2x32(:,:,302))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(191),m3h2x16(:,303),heltab2x32(:,:,303))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(192),m3h2x16(:,304),heltab2x32(:,:,304))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(193),m3h2x16(:,305),heltab2x32(:,:,305))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(194),m3h2x16(:,306),heltab2x32(:,:,306))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,307),heltab2x32(:,:,307))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,308),heltab2x32(:,:,308))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,309),heltab2x32(:,:,309))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,310),heltab2x32(:,:,310))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,311),heltab2x32(:,:,311))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,312),heltab2x32(:,:,312))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,313),heltab2x32(:,:,313))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,314),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(195),m3h2x16(:,315),heltab2x32(:,:,315))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(196),m3h2x16(:,316),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(197),m3h2x16(:,317),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(198),m3h2x16(:,318),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,319),heltab2x32(:,:,319))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,320),heltab2x32(:,:,320))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,321),heltab2x32(:,:,321))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,322),heltab2x32(:,:,322))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,323),heltab2x32(:,:,323))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,324),heltab2x32(:,:,324))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,325),heltab2x32(:,:,325))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,326),heltab2x32(:,:,326))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(199),m3h2x16(:,327),heltab2x32(:,:,327))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(200),m3h2x16(:,328),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(201),m3h2x16(:,329),heltab2x32(:,:,329))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(202),m3h2x16(:,330),heltab2x32(:,:,330))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,331),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,332),heltab2x32(:,:,332))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,333),heltab2x32(:,:,333))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,334),heltab2x32(:,:,334))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(203),m3h2x16(:,335),heltab2x32(:,:,335))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(204),m3h2x16(:,336),heltab2x32(:,:,336))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(205),m3h2x16(:,337),heltab2x32(:,:,337))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(206),m3h2x16(:,338),heltab2x32(:,:,338))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,5,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,339),heltab2x32(:,:,339))
  call Hloop_A_Q(ntryL,G0H16(97),16,0,G1H16(207),n2h16(97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,5,2,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,340),heltab2x32(:,:,340))
  call Hloop_A_Q(ntryL,G0H16(97),16,0,G1H16(208),n2h16(98))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,341),heltab2x32(:,:,341))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(209),m3h2x16(:,342),heltab2x32(:,:,342))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,2,5,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H16(98),16,0,G1H16(210),n2h16(99))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,2,5,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H16(98),16,0,G1H16(211),n2h16(100))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,345),heltab2x32(:,:,345))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,346),heltab2x32(:,:,346))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,6,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G0H16(99),16,0,G1H16(213),n2h16(101))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,6,1,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G0H16(99),16,0,G1H16(214),n2h16(102))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,349),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(215),m3h2x16(:,350),heltab2x32(:,:,350))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,1,6,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,351),heltab2x32(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(100),16,0,G1H16(216),n2h16(103))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,1,6,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(100),16,0,G1H16(217),n2h16(104))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,353),heltab2x32(:,:,353))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,354),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,4,2,9],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H16(101),16,0,G1H16(219),n2h16(105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,4,2,9],[0,0,nMZ,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G0H16(101),16,0,G1H16(220),n2h16(106))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,357),heltab2x32(:,:,357))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,358),heltab2x32(:,:,358))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,2,9,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H16(102),16,0,G1H16(222),n2h16(107))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,2,9,4],[0,nMZ,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,360),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G0H16(102),16,0,G1H16(223),n2h16(108))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,361),heltab2x32(:,:,361))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,362),heltab2x32(:,:,362))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,4,1,10],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(103),16,0,G1H16(225),n2h16(109))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,4,1,10],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(103),16,0,G1H16(226),n2h16(110))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,365),heltab2x32(:,:,365))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,366),heltab2x32(:,:,366))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,1,10,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(104),16,0,G1H16(228),n2h16(111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,1,10,4],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(104),16,0,G1H16(229),n2h16(112))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,369),heltab2x32(:,:,369))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,370),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[17,2,4,8],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,1),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(6),ngZl,m3h4x8(:,2),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,3),heltab2x32(:,:,373))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(9),n2h8(23))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,4),heltab2x32(:,:,374))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(10),n2h8(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[17,2,8,4],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,5),heltab2x32(:,:,375))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(8),ngZl,m3h4x8(:,6),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,7),heltab2x32(:,:,377))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(11),n2h8(25))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,8),heltab2x32(:,:,378))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(12),n2h8(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[18,1,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,9),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(10),ngZl,m3h4x8(:,10),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,11),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H8(11),18,0,G1H8(13),n2h8(27))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,12),heltab2x32(:,:,382))
  call Hloop_A_Q(ntryL,G0H8(11),18,0,G1H8(14),n2h8(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[18,1,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,13),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngZl,m3h4x8(:,14),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,15),heltab2x32(:,:,385))
  call Hloop_A_Q(ntryL,G0H8(13),18,0,G1H8(15),n2h8(29))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,16),heltab2x32(:,:,386))
  call Hloop_A_Q(ntryL,G0H8(13),18,0,G1H8(16),n2h8(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(9),G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(11),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(14),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(16),[G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(18),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(77),G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(83),[G1H16(79),G1H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(105),[G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G1H16(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(109),[G1H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(46),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(50),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(52),[G0H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(149),[G1H16(145),G1H16(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(151),[G1H16(147),G1H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(173),[G1H16(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(174),[G1H16(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(177),[G1H16(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(178),[G1H16(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(78),[G0H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(80),[G0H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(82),[G0H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(84),[G0H16(83)])
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(9),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(13),n2h4(35))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(10),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(10),22,0,G2H4(14),n2h4(36))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(13),n2h4(37))
  call Hloop_WQ_A(ntryL,G0H8(1),ex1(:),G0H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(14),n2h4(38))
  call Hloop_WQ_A(ntryL,G1H16(1),ex1(:),G1H8(17),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(17),17,0,G2H8(1),n2h8(31))
  call Hloop_WA_Q(ntryL,G1H16(2),ex2(:),G1H8(18),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(18),18,0,G2H8(2),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,13),G1H4(15),m3h4x4(:,1),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(15),19,0,G2H4(15),n2h4(39))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,13),G1H4(16),m3h4x4(:,2),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMM,G2H4(16),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,13),G1H4(19),m3h4x4(:,3),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(19),19,nML,G2H4(17),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,13),G1H4(20),m3h4x4(:,4),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(20),19,0,G2H4(18),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,13),G1H4(21),m3h4x4(:,5),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(21),19,nMM,G2H4(19),n2h4(43))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,13),G1H4(22),m3h4x4(:,6),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(22),19,nML,G2H4(20),n2h4(44))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,13),G1H4(25),m3h4x4(:,7),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(25),19,nMT,G2H4(21),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,13),G1H4(26),m3h4x4(:,8),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(26),19,nMT,G2H4(22),n2h4(46))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,13),G1H4(27),m3h4x4(:,9),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(27),19,nMB,G2H4(23),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H16(16),wf4(:,13),G1H4(28),m3h4x4(:,10),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(28),19,nMB,G2H4(26),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,14),G1H4(31),ngZl,m3h4x4(:,11),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(31),19,0,G2H4(27),n2h4(49))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,14),G1H4(32),ngZl,m3h4x4(:,12),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(32),19,nMM,G2H4(28),n2h4(50))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,14),G1H4(1),ngZl,m3h4x4(:,13),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(31),n2h4(51))
  call Hloop_AZ_Q(ntryL,G1H16(20),wf4(:,14),G1H4(2),ngZl,m3h4x4(:,14),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(2),19,0,G2H4(32),n2h4(52))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,14),G1H4(35),ngZl,m3h4x4(:,15),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(35),19,nMM,G2H4(1),n2h4(53))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,14),G1H4(36),ngZl,m3h4x4(:,16),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(36),19,nML,G2H4(2),n2h4(54))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,14),G1H4(37),ngZu,m3h4x4(:,17),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(37),19,0,G2H4(3),n2h4(55))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,14),G1H4(38),ngZu,m3h4x4(:,18),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(38),19,nMT,G2H4(4),n2h4(56))
  call Hloop_AZ_Q(ntryL,G1H16(25),wf4(:,14),G1H4(41),ngZu,m3h4x4(:,19),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(41),19,0,G2H4(5),n2h4(57))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,14),G1H4(42),ngZu,m3h4x4(:,20),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(42),19,nMT,G2H4(6),n2h4(58))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,14),G1H4(43),ngZd,m3h4x4(:,21),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(43),19,0,G2H4(7),n2h4(59))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,14),G1H4(44),ngZd,m3h4x4(:,22),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(44),19,nMB,G2H4(8),n2h4(60))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,14),G1H4(47),ngZd,m3h4x4(:,23),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(47),19,0,G2H4(9),n2h4(61))
  call Hloop_AZ_Q(ntryL,G1H16(30),wf4(:,14),G1H4(48),ngZd,m3h4x4(:,24),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(48),19,nMB,G2H4(10),n2h4(62))
  call Hloop_TV_S(ntryL,G1H16(31),16,wf4(:,13),3,G2H4(11),m3h4x4(:,25),heltab2x16(:,:,63))
  call Hloop_SV_T(ntryL,G1H16(32),16,wf4(:,13),3,G2H4(12),m3h4x4(:,26),heltab2x16(:,:,64))
  call Hloop_TV_S(ntryL,G1H16(33),16,wf4(:,14),3,G2H4(33),m3h4x4(:,27),heltab2x16(:,:,65))
  call Hloop_SV_T(ntryL,G1H16(34),16,wf4(:,14),3,G2H4(34),m3h4x4(:,28),heltab2x16(:,:,66))
  call Hloop_CV_D(ntryL,G1H16(37),16,wf4(:,13),3,G2H4(35),m3h4x4(:,29),heltab2x16(:,:,67))
  call Hloop_DV_C(ntryL,G1H16(38),16,wf4(:,13),G2H4(36),m3h4x4(:,30),heltab2x16(:,:,68))
  call Hloop_CV_D(ntryL,G1H16(41),16,wf4(:,14),3,G2H4(37),m3h4x4(:,31),heltab2x16(:,:,69))
  call Hloop_DV_C(ntryL,G1H16(42),16,wf4(:,14),G2H4(38),m3h4x4(:,32),heltab2x16(:,:,70))
  call Hloop_UV_W(ntryL,G1H16(43),16,wf4(:,13),3,G2H4(39),m3h4x4(:,33),heltab2x16(:,:,71))
  call Hloop_UW_V(ntryL,G1H16(44),16,wf4(:,13),3,G2H4(40),m3h4x4(:,34),heltab2x16(:,:,72))
  call Hloop_UV_W(ntryL,G1H16(45),16,wf4(:,14),3,G2H4(41),m3h4x4(:,35),heltab2x16(:,:,73))
  call Hloop_UW_V(ntryL,G1H16(46),16,wf4(:,14),3,G2H4(42),m3h4x4(:,36),heltab2x16(:,:,74))
  call Hloop_VV_S(ntryL,G0H16(5),wf4(:,13),G0H4(1),m3h4x4(:,37),heltab2x16(:,:,75))
  call Hloop_VV_S(ntryL,G0H16(6),wf4(:,13),G0H4(2),m3h4x4(:,38),heltab2x16(:,:,76))
  call Hloop_VV_S(ntryL,G0H16(7),wf4(:,14),G0H4(3),m3h4x4(:,39),heltab2x16(:,:,77))
  call Hloop_VV_S(ntryL,G0H16(8),wf4(:,14),G0H4(4),m3h4x4(:,40),heltab2x16(:,:,78))
  call Hloop_SV_V(ntryL,G1H16(47),wf4(:,13),G1H4(49),m3h4x4(:,41),heltab2x16(:,:,79))
  call Hloop_SV_V(ntryL,G1H16(48),wf4(:,13),G1H4(50),m3h4x4(:,42),heltab2x16(:,:,80))
  call Hloop_SV_V(ntryL,G1H16(49),wf4(:,14),G1H4(53),m3h4x4(:,43),heltab2x16(:,:,81))
  call Hloop_SV_V(ntryL,G1H16(50),wf4(:,14),G1H4(54),m3h4x4(:,44),heltab2x16(:,:,82))
  call Hloop_TV_S(ntryL,G0H16(9),16,wf4(:,13),3,G1H4(55),m3h4x4(:,45),heltab2x16(:,:,83))
  call Hloop_SV_T(ntryL,G0H16(10),16,wf4(:,13),3,G1H4(56),m3h4x4(:,46),heltab2x16(:,:,84))
  call Hloop_TV_S(ntryL,G0H16(11),16,wf4(:,14),3,G1H4(59),m3h4x4(:,47),heltab2x16(:,:,85))
  call Hloop_SV_T(ntryL,G0H16(12),16,wf4(:,14),3,G1H4(60),m3h4x4(:,48),heltab2x16(:,:,86))
  call Hloop_TV_S(ntryL,G1H16(51),16,wf4(:,13),3,G2H4(43),m3h4x4(:,49),heltab2x16(:,:,87))
  call Hloop_SV_T(ntryL,G1H16(52),16,wf4(:,13),3,G2H4(44),m3h4x4(:,50),heltab2x16(:,:,88))
  call Hloop_TV_S(ntryL,G1H16(53),16,wf4(:,14),3,G2H4(45),m3h4x4(:,51),heltab2x16(:,:,89))
  call Hloop_SV_T(ntryL,G1H16(54),16,wf4(:,14),3,G2H4(46),m3h4x4(:,52),heltab2x16(:,:,90))
  call Hloop_UV_W(ntryL,G0H16(1),16,wf4(:,13),3,G1H4(3),m3h4x4(:,53),heltab2x16(:,:,91))
  call Hloop_UW_V(ntryL,G0H16(2),16,wf4(:,13),3,G1H4(4),m3h4x4(:,54),heltab2x16(:,:,92))
  call Hloop_UV_W(ntryL,G0H16(3),16,wf4(:,14),3,G1H4(63),m3h4x4(:,55),heltab2x16(:,:,93))
  call Hloop_UW_V(ntryL,G0H16(4),16,wf4(:,14),3,G1H4(64),m3h4x4(:,56),heltab2x16(:,:,94))
  call Hloop_VV_S(ntryL,G1H16(55),wf4(:,13),G1H4(65),m3h4x4(:,57),heltab2x16(:,:,95))
  call Hloop_VV_S(ntryL,G1H16(56),wf4(:,13),G1H4(66),m3h4x4(:,58),heltab2x16(:,:,96))
  call Hloop_VV_S(ntryL,G1H16(57),wf4(:,14),G1H4(69),m3h4x4(:,59),heltab2x16(:,:,97))
  call Hloop_VV_S(ntryL,G1H16(58),wf4(:,14),G1H4(70),m3h4x4(:,60),heltab2x16(:,:,98))
  call Hloop_SV_V(ntryL,G0H16(14),wf4(:,13),G0H4(5),m3h4x4(:,61),heltab2x16(:,:,99))
  call Hloop_SV_V(ntryL,G0H16(16),wf4(:,14),G0H4(6),m3h4x4(:,62),heltab2x16(:,:,100))
  call Hloop_VV_S(ntryL,G0H16(18),wf4(:,13),G0H4(7),m3h4x4(:,63),heltab2x16(:,:,101))
  call Hloop_VV_S(ntryL,G0H16(20),wf4(:,14),G0H4(8),m3h4x4(:,64),heltab2x16(:,:,102))
  call Hloop_SV_V(ntryL,G1H16(59),wf4(:,13),G1H4(71),m3h4x4(:,65),heltab2x16(:,:,103))
  call Hloop_SV_V(ntryL,G1H16(60),wf4(:,13),G1H4(72),m3h4x4(:,66),heltab2x16(:,:,104))
  call Hloop_SV_V(ntryL,G1H16(61),wf4(:,14),G1H4(75),m3h4x4(:,67),heltab2x16(:,:,105))
  call Hloop_SV_V(ntryL,G1H16(62),wf4(:,14),G1H4(76),m3h4x4(:,68),heltab2x16(:,:,106))
  call Hloop_TV_S(ntryL,G0H16(21),16,wf4(:,13),3,G1H4(5),m3h4x4(:,69),heltab2x16(:,:,107))
  call Hloop_SV_T(ntryL,G0H16(22),16,wf4(:,13),3,G1H4(6),m3h4x4(:,70),heltab2x16(:,:,108))
  call Hloop_TV_S(ntryL,G0H16(23),16,wf4(:,14),3,G1H4(79),m3h4x4(:,71),heltab2x16(:,:,109))
  call Hloop_SV_T(ntryL,G0H16(24),16,wf4(:,14),3,G1H4(80),m3h4x4(:,72),heltab2x16(:,:,110))
  call Hloop_UV_W(ntryL,G1H16(63),16,wf4(:,13),3,G2H4(47),m3h4x4(:,73),heltab2x16(:,:,111))
  call Hloop_UW_V(ntryL,G1H16(64),16,wf4(:,13),3,G2H4(48),m3h4x4(:,74),heltab2x16(:,:,112))
  call Hloop_UV_W(ntryL,G1H16(65),16,wf4(:,14),3,G2H4(49),m3h4x4(:,75),heltab2x16(:,:,113))
  call Hloop_UW_V(ntryL,G1H16(66),16,wf4(:,14),3,G2H4(50),m3h4x4(:,76),heltab2x16(:,:,114))
  call Hloop_UV_W(ntryL,G0H16(25),16,wf4(:,13),3,G1H4(81),m3h4x4(:,77),heltab2x16(:,:,115))
  call Hloop_UW_V(ntryL,G0H16(26),16,wf4(:,13),3,G1H4(82),m3h4x4(:,78),heltab2x16(:,:,116))
  call Hloop_UV_W(ntryL,G0H16(27),16,wf4(:,14),3,G1H4(85),m3h4x4(:,79),heltab2x16(:,:,117))
  call Hloop_UW_V(ntryL,G0H16(28),16,wf4(:,14),3,G1H4(86),m3h4x4(:,80),heltab2x16(:,:,118))
  call Hloop_VV_S(ntryL,G1H16(67),wf4(:,13),G1H4(87),m3h4x4(:,81),heltab2x16(:,:,119))
  call Hloop_VV_S(ntryL,G1H16(68),wf4(:,13),G1H4(88),m3h4x4(:,82),heltab2x16(:,:,120))
  call Hloop_VV_S(ntryL,G1H16(69),wf4(:,14),G1H4(91),m3h4x4(:,83),heltab2x16(:,:,121))
  call Hloop_VV_S(ntryL,G1H16(70),wf4(:,14),G1H4(92),m3h4x4(:,84),heltab2x16(:,:,122))
  call Hloop_SV_V(ntryL,G0H16(29),wf4(:,13),G0H4(9),m3h4x4(:,85),heltab2x16(:,:,123))
  call Hloop_SV_V(ntryL,G0H16(30),wf4(:,13),G0H4(10),m3h4x4(:,86),heltab2x16(:,:,124))
  call Hloop_SV_V(ntryL,G0H16(31),wf4(:,14),G0H4(11),m3h4x4(:,87),heltab2x16(:,:,125))
  call Hloop_SV_V(ntryL,G0H16(32),wf4(:,14),G0H4(12),m3h4x4(:,88),heltab2x16(:,:,126))
  call Hloop_AV_Q(ntryL,G1H16(81),wf4(:,13),G1H4(7),m3h4x4(:,89),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(51),n2h4(63))
  call Hloop_AV_Q(ntryL,G1H16(72),wf4(:,13),G1H4(8),m3h4x4(:,90),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(8),19,nMM,G2H4(52),n2h4(64))
  call Hloop_AV_Q(ntryL,G1H16(73),wf4(:,13),G1H4(95),m3h4x4(:,91),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(95),19,nML,G2H4(53),n2h4(65))
  call Hloop_QV_A(ntryL,G1H16(83),wf4(:,13),G1H4(96),m3h4x4(:,92),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(96),19,0,G2H4(54),n2h4(66))
  call Hloop_QV_A(ntryL,G1H16(75),wf4(:,13),G1H4(9),m3h4x4(:,93),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMM,G2H4(55),n2h4(67))
  call Hloop_QV_A(ntryL,G1H16(76),wf4(:,13),G1H4(10),m3h4x4(:,94),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(10),19,nML,G2H4(56),n2h4(68))
  call Hloop_AV_Q(ntryL,G1H16(78),wf4(:,13),G1H4(15),m3h4x4(:,95),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMT,G2H4(57),n2h4(69))
  call Hloop_QV_A(ntryL,G1H16(80),wf4(:,13),G1H4(16),m3h4x4(:,96),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMT,G2H4(58),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H16(82),wf4(:,13),G1H4(19),m3h4x4(:,97),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(19),19,nMB,G2H4(59),n2h4(71))
  call Hloop_QV_A(ntryL,G1H16(84),wf4(:,13),G1H4(20),m3h4x4(:,98),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(20),19,nMB,G2H4(60),n2h4(72))
  call Hloop_AZ_Q(ntryL,G1H16(85),wf4(:,14),G1H4(21),ngZl,m3h4x4(:,99),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(21),19,0,G2H4(61),n2h4(73))
  call Hloop_AZ_Q(ntryL,G1H16(86),wf4(:,14),G1H4(22),ngZl,m3h4x4(:,100),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(22),19,nMM,G2H4(62),n2h4(74))
  call Hloop_AZ_Q(ntryL,G1H16(87),wf4(:,14),G1H4(25),ngZl,m3h4x4(:,101),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(25),19,nML,G2H4(63),n2h4(75))
  call Hloop_QZ_A(ntryL,G1H16(88),wf4(:,14),G1H4(26),ngZl,m3h4x4(:,102),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(26),19,0,G2H4(64),n2h4(76))
  call Hloop_QZ_A(ntryL,G1H16(89),wf4(:,14),G1H4(27),ngZl,m3h4x4(:,103),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(27),19,nMM,G2H4(65),n2h4(77))
  call Hloop_QZ_A(ntryL,G1H16(90),wf4(:,14),G1H4(28),ngZl,m3h4x4(:,104),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(28),19,nML,G2H4(66),n2h4(78))
  call Hloop_AZ_Q(ntryL,G1H16(91),wf4(:,14),G1H4(31),ngZu,m3h4x4(:,105),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(31),19,0,G2H4(67),n2h4(79))
  call Hloop_AZ_Q(ntryL,G1H16(92),wf4(:,14),G1H4(32),ngZu,m3h4x4(:,106),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(32),19,nMT,G2H4(68),n2h4(80))
  call Hloop_QZ_A(ntryL,G1H16(93),wf4(:,14),G1H4(1),ngZu,m3h4x4(:,107),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(69),n2h4(81))
  call Hloop_QZ_A(ntryL,G1H16(94),wf4(:,14),G1H4(2),ngZu,m3h4x4(:,108),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMT,G2H4(70),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H16(95),wf4(:,14),G1H4(35),ngZd,m3h4x4(:,109),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(35),19,0,G2H4(71),n2h4(83))
  call Hloop_AZ_Q(ntryL,G1H16(96),wf4(:,14),G1H4(36),ngZd,m3h4x4(:,110),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(36),19,nMB,G2H4(72),n2h4(84))
  call Hloop_QZ_A(ntryL,G1H16(97),wf4(:,14),G1H4(37),ngZd,m3h4x4(:,111),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(37),19,0,G2H4(73),n2h4(85))
  call Hloop_QZ_A(ntryL,G1H16(98),wf4(:,14),G1H4(38),ngZd,m3h4x4(:,112),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(38),19,nMB,G2H4(74),n2h4(86))
  call Hloop_SV_T(ntryL,G1H16(99),16,wf4(:,13),3,G2H4(75),m3h4x4(:,113),heltab2x16(:,:,151))
  call Hloop_TV_S(ntryL,G1H16(100),16,wf4(:,13),3,G2H4(76),m3h4x4(:,114),heltab2x16(:,:,152))
  call Hloop_SV_T(ntryL,G1H16(101),16,wf4(:,14),3,G2H4(77),m3h4x4(:,115),heltab2x16(:,:,153))
  call Hloop_TV_S(ntryL,G1H16(102),16,wf4(:,14),3,G2H4(78),m3h4x4(:,116),heltab2x16(:,:,154))
  call Hloop_DV_C(ntryL,G1H16(105),16,wf4(:,13),G2H4(79),m3h4x4(:,117),heltab2x16(:,:,155))
  call Hloop_CV_D(ntryL,G1H16(106),16,wf4(:,13),3,G2H4(80),m3h4x4(:,118),heltab2x16(:,:,156))
  call Hloop_DV_C(ntryL,G1H16(109),16,wf4(:,14),G2H4(81),m3h4x4(:,119),heltab2x16(:,:,157))
  call Hloop_CV_D(ntryL,G1H16(110),16,wf4(:,14),3,G2H4(82),m3h4x4(:,120),heltab2x16(:,:,158))
  call Hloop_UW_V(ntryL,G1H16(111),16,wf4(:,13),3,G2H4(83),m3h4x4(:,121),heltab2x16(:,:,159))
  call Hloop_UV_W(ntryL,G1H16(112),16,wf4(:,13),3,G2H4(84),m3h4x4(:,122),heltab2x16(:,:,160))
  call Hloop_UW_V(ntryL,G1H16(113),16,wf4(:,14),3,G2H4(85),m3h4x4(:,123),heltab2x16(:,:,161))
  call Hloop_UV_W(ntryL,G1H16(114),16,wf4(:,14),3,G2H4(86),m3h4x4(:,124),heltab2x16(:,:,162))
  call Hloop_VV_S(ntryL,G0H16(33),wf4(:,13),G0H4(13),m3h4x4(:,125),heltab2x16(:,:,163))
  call Hloop_VV_S(ntryL,G0H16(34),wf4(:,13),G0H4(14),m3h4x4(:,126),heltab2x16(:,:,164))
  call Hloop_VV_S(ntryL,G0H16(35),wf4(:,14),G0H4(15),m3h4x4(:,127),heltab2x16(:,:,165))
  call Hloop_VV_S(ntryL,G0H16(36),wf4(:,14),G0H4(16),m3h4x4(:,128),heltab2x16(:,:,166))
  call Hloop_SV_T(ntryL,G0H16(37),16,wf4(:,13),3,G1H4(41),m3h4x4(:,129),heltab2x16(:,:,167))
  call Hloop_TV_S(ntryL,G0H16(38),16,wf4(:,13),3,G1H4(42),m3h4x4(:,130),heltab2x16(:,:,168))
  call Hloop_SV_T(ntryL,G0H16(39),16,wf4(:,14),3,G1H4(43),m3h4x4(:,131),heltab2x16(:,:,169))
  call Hloop_TV_S(ntryL,G0H16(40),16,wf4(:,14),3,G1H4(44),m3h4x4(:,132),heltab2x16(:,:,170))
  call Hloop_SV_V(ntryL,G1H16(115),wf4(:,13),G1H4(47),m3h4x4(:,133),heltab2x16(:,:,171))
  call Hloop_SV_V(ntryL,G1H16(116),wf4(:,13),G1H4(48),m3h4x4(:,134),heltab2x16(:,:,172))
  call Hloop_SV_V(ntryL,G1H16(117),wf4(:,14),G1H4(7),m3h4x4(:,135),heltab2x16(:,:,173))
  call Hloop_SV_V(ntryL,G1H16(118),wf4(:,14),G1H4(8),m3h4x4(:,136),heltab2x16(:,:,174))
  call Hloop_SV_T(ntryL,G1H16(119),16,wf4(:,13),3,G2H4(87),m3h4x4(:,137),heltab2x16(:,:,175))
  call Hloop_TV_S(ntryL,G1H16(120),16,wf4(:,13),3,G2H4(88),m3h4x4(:,138),heltab2x16(:,:,176))
  call Hloop_SV_T(ntryL,G1H16(121),16,wf4(:,14),3,G2H4(89),m3h4x4(:,139),heltab2x16(:,:,177))
  call Hloop_TV_S(ntryL,G1H16(122),16,wf4(:,14),3,G2H4(90),m3h4x4(:,140),heltab2x16(:,:,178))
  call Hloop_VV_S(ntryL,G1H16(123),wf4(:,13),G1H4(95),m3h4x4(:,141),heltab2x16(:,:,179))
  call Hloop_VV_S(ntryL,G1H16(124),wf4(:,13),G1H4(96),m3h4x4(:,142),heltab2x16(:,:,180))
  call Hloop_VV_S(ntryL,G1H16(125),wf4(:,14),G1H4(9),m3h4x4(:,143),heltab2x16(:,:,181))
  call Hloop_VV_S(ntryL,G1H16(126),wf4(:,14),G1H4(10),m3h4x4(:,144),heltab2x16(:,:,182))
  call Hloop_UW_V(ntryL,G0H16(41),16,wf4(:,13),3,G1H4(15),m3h4x4(:,145),heltab2x16(:,:,183))
  call Hloop_UV_W(ntryL,G0H16(42),16,wf4(:,13),3,G1H4(16),m3h4x4(:,146),heltab2x16(:,:,184))
  call Hloop_UW_V(ntryL,G0H16(43),16,wf4(:,14),3,G1H4(19),m3h4x4(:,147),heltab2x16(:,:,185))
  call Hloop_UV_W(ntryL,G0H16(44),16,wf4(:,14),3,G1H4(20),m3h4x4(:,148),heltab2x16(:,:,186))
  call Hloop_SV_V(ntryL,G0H16(46),wf4(:,13),G0H4(17),m3h4x4(:,149),heltab2x16(:,:,187))
  call Hloop_SV_V(ntryL,G0H16(48),wf4(:,14),G0H4(18),m3h4x4(:,150),heltab2x16(:,:,188))
  call Hloop_VV_S(ntryL,G0H16(50),wf4(:,13),G0H4(19),m3h4x4(:,151),heltab2x16(:,:,189))
  call Hloop_VV_S(ntryL,G0H16(52),wf4(:,14),G0H4(20),m3h4x4(:,152),heltab2x16(:,:,190))
  call Hloop_SV_T(ntryL,G0H16(53),16,wf4(:,13),3,G1H4(21),m3h4x4(:,153),heltab2x16(:,:,191))
  call Hloop_TV_S(ntryL,G0H16(54),16,wf4(:,13),3,G1H4(22),m3h4x4(:,154),heltab2x16(:,:,192))
  call Hloop_SV_T(ntryL,G0H16(55),16,wf4(:,14),3,G1H4(25),m3h4x4(:,155),heltab2x16(:,:,193))
  call Hloop_TV_S(ntryL,G0H16(56),16,wf4(:,14),3,G1H4(26),m3h4x4(:,156),heltab2x16(:,:,194))
  call Hloop_SV_V(ntryL,G1H16(127),wf4(:,13),G1H4(27),m3h4x4(:,157),heltab2x16(:,:,195))
  call Hloop_SV_V(ntryL,G1H16(128),wf4(:,13),G1H4(28),m3h4x4(:,158),heltab2x16(:,:,196))
  call Hloop_SV_V(ntryL,G1H16(129),wf4(:,14),G1H4(31),m3h4x4(:,159),heltab2x16(:,:,197))
  call Hloop_SV_V(ntryL,G1H16(130),wf4(:,14),G1H4(32),m3h4x4(:,160),heltab2x16(:,:,198))
  call Hloop_UW_V(ntryL,G1H16(131),16,wf4(:,13),3,G2H4(91),m3h4x4(:,161),heltab2x16(:,:,199))
  call Hloop_UV_W(ntryL,G1H16(132),16,wf4(:,13),3,G2H4(92),m3h4x4(:,162),heltab2x16(:,:,200))
  call Hloop_UW_V(ntryL,G1H16(133),16,wf4(:,14),3,G2H4(93),m3h4x4(:,163),heltab2x16(:,:,201))
  call Hloop_UV_W(ntryL,G1H16(134),16,wf4(:,14),3,G2H4(94),m3h4x4(:,164),heltab2x16(:,:,202))
  call Hloop_VV_S(ntryL,G1H16(135),wf4(:,13),G1H4(1),m3h4x4(:,165),heltab2x16(:,:,203))
  call Hloop_VV_S(ntryL,G1H16(136),wf4(:,13),G1H4(2),m3h4x4(:,166),heltab2x16(:,:,204))
  call Hloop_VV_S(ntryL,G1H16(137),wf4(:,14),G1H4(35),m3h4x4(:,167),heltab2x16(:,:,205))
  call Hloop_VV_S(ntryL,G1H16(138),wf4(:,14),G1H4(36),m3h4x4(:,168),heltab2x16(:,:,206))
  call Hloop_UW_V(ntryL,G0H16(57),16,wf4(:,13),3,G1H4(37),m3h4x4(:,169),heltab2x16(:,:,207))
  call Hloop_UV_W(ntryL,G0H16(58),16,wf4(:,13),3,G1H4(38),m3h4x4(:,170),heltab2x16(:,:,208))
  call Hloop_UW_V(ntryL,G0H16(59),16,wf4(:,14),3,G1H4(97),m3h4x4(:,171),heltab2x16(:,:,209))
  call Hloop_UV_W(ntryL,G0H16(60),16,wf4(:,14),3,G1H4(98),m3h4x4(:,172),heltab2x16(:,:,210))
  call Hloop_SV_V(ntryL,G0H16(61),wf4(:,13),G0H4(21),m3h4x4(:,173),heltab2x16(:,:,211))
  call Hloop_SV_V(ntryL,G0H16(62),wf4(:,13),G0H4(22),m3h4x4(:,174),heltab2x16(:,:,212))
  call Hloop_SV_V(ntryL,G0H16(63),wf4(:,14),G0H4(23),m3h4x4(:,175),heltab2x16(:,:,213))
  call Hloop_SV_V(ntryL,G0H16(64),wf4(:,14),G0H4(24),m3h4x4(:,176),heltab2x16(:,:,214))
  call Hloop_QV_A(ntryL,G1H16(149),ex3(:),G1H8(19),m3h2x8(:,39),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H8(19),20,0,G2H8(3),n2h8(33))
  call Hloop_QV_A(ntryL,G1H16(140),ex3(:),G1H8(20),m3h2x8(:,40),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H8(20),20,nMM,G2H8(4),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(141),ex3(:),G1H8(21),m3h2x8(:,41),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H8(21),20,nML,G2H8(5),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(151),ex3(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(6),n2h8(36))
  call Hloop_AV_Q(ntryL,G1H16(143),ex3(:),G1H8(2),m3h2x8(:,43),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMM,G2H8(7),n2h8(37))
  call Hloop_AV_Q(ntryL,G1H16(144),ex3(:),G1H8(22),m3h2x8(:,44),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G1H8(22),20,nML,G2H8(8),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(146),ex3(:),G1H8(23),m3h2x8(:,45),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(9),n2h8(39))
  call Hloop_AV_Q(ntryL,G1H16(148),ex3(:),G1H8(3),m3h2x8(:,46),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMT,G2H8(10),n2h8(40))
  call Hloop_QV_A(ntryL,G1H16(150),ex3(:),G1H8(4),m3h2x8(:,47),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMB,G2H8(11),n2h8(41))
  call Hloop_AV_Q(ntryL,G1H16(152),ex3(:),G1H8(6),m3h2x8(:,48),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H8(6),20,nMB,G2H8(12),n2h8(42))
  call Hloop_QV_A(ntryL,G1H16(153),ex3(:),G1H8(8),m3h2x8(:,49),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H8(8),20,0,G2H8(13),n2h8(43))
  call Hloop_QV_A(ntryL,G1H16(154),ex3(:),G1H8(24),m3h2x8(:,50),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(24),20,nMM,G2H8(14),n2h8(44))
  call Hloop_QV_A(ntryL,G1H16(155),ex3(:),G1H8(7),m3h2x8(:,51),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(7),20,nML,G2H8(15),n2h8(45))
  call Hloop_AV_Q(ntryL,G1H16(156),ex3(:),G1H8(5),m3h2x8(:,52),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H8(5),20,0,G2H8(16),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(157),ex3(:),G1H8(17),m3h2x8(:,53),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G1H8(17),20,nMM,G2H8(17),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H16(158),ex3(:),G1H8(18),m3h2x8(:,54),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H8(18),20,nML,G2H8(18),n2h8(48))
  call Hloop_QV_A(ntryL,G1H16(159),ex3(:),G1H8(19),m3h2x8(:,55),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H8(19),20,0,G2H8(19),n2h8(49))
  call Hloop_QV_A(ntryL,G1H16(160),ex3(:),G1H8(20),m3h2x8(:,56),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(20),20,nMT,G2H8(20),n2h8(50))
  call Hloop_AV_Q(ntryL,G1H16(161),ex3(:),G1H8(21),m3h2x8(:,57),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G1H8(21),20,0,G2H8(21),n2h8(51))
  call Hloop_AV_Q(ntryL,G1H16(162),ex3(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(22),n2h8(52))
  call Hloop_QV_A(ntryL,G1H16(163),ex3(:),G1H8(2),m3h2x8(:,59),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H8(2),20,0,G2H8(23),n2h8(53))
  call Hloop_QV_A(ntryL,G1H16(164),ex3(:),G1H8(22),m3h2x8(:,60),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H8(22),20,nMB,G2H8(24),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H16(165),ex3(:),G1H8(23),m3h2x8(:,61),heltab2x16(:,:,237))
  call Hloop_A_Q(ntryL,G1H8(23),20,0,G2H8(25),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(166),ex3(:),G1H8(3),m3h2x8(:,62),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMB,G2H8(26),n2h8(56))
  call Hloop_TV_S(ntryL,G1H16(167),16,ex3(:),4,G2H8(27),m3h2x8(:,63),heltab2x16(:,:,239))
  call Hloop_SV_T(ntryL,G1H16(168),16,ex3(:),4,G2H8(28),m3h2x8(:,64),heltab2x16(:,:,240))
  call Hloop_TV_S(ntryL,G1H16(169),16,ex3(:),4,G2H8(29),m3h2x8(:,65),heltab2x16(:,:,241))
  call Hloop_SV_T(ntryL,G1H16(170),16,ex3(:),4,G2H8(30),m3h2x8(:,66),heltab2x16(:,:,242))
  call Hloop_CV_D(ntryL,G1H16(173),16,ex3(:),4,G2H8(31),m3h2x8(:,67),heltab2x16(:,:,243))
  call Hloop_DV_C(ntryL,G1H16(174),16,ex3(:),G2H8(32),m3h2x8(:,68),heltab2x16(:,:,244))
  call Hloop_CV_D(ntryL,G1H16(177),16,ex3(:),4,G2H8(33),m3h2x8(:,69),heltab2x16(:,:,245))
  call Hloop_DV_C(ntryL,G1H16(178),16,ex3(:),G2H8(34),m3h2x8(:,70),heltab2x16(:,:,246))
  call Hloop_UV_W(ntryL,G1H16(179),16,ex3(:),4,G2H8(35),m3h2x8(:,71),heltab2x16(:,:,247))
  call Hloop_UW_V(ntryL,G1H16(180),16,ex3(:),4,G2H8(36),m3h2x8(:,72),heltab2x16(:,:,248))
  call Hloop_UV_W(ntryL,G1H16(181),16,ex3(:),4,G2H8(37),m3h2x8(:,73),heltab2x16(:,:,249))
  call Hloop_UW_V(ntryL,G1H16(182),16,ex3(:),4,G2H8(38),m3h2x8(:,74),heltab2x16(:,:,250))
  call Hloop_TV_S(ntryL,G1H16(183),16,ex3(:),4,G2H8(39),m3h2x8(:,75),heltab2x16(:,:,251))
  call Hloop_SV_T(ntryL,G1H16(184),16,ex3(:),4,G2H8(40),m3h2x8(:,76),heltab2x16(:,:,252))
  call Hloop_TV_S(ntryL,G1H16(185),16,ex3(:),4,G2H8(41),m3h2x8(:,77),heltab2x16(:,:,253))
  call Hloop_SV_T(ntryL,G1H16(186),16,ex3(:),4,G2H8(42),m3h2x8(:,78),heltab2x16(:,:,254))
  call Hloop_TV_S(ntryL,G0H16(65),16,ex3(:),4,G1H8(4),m3h2x8(:,79),heltab2x16(:,:,255))
  call Hloop_SV_T(ntryL,G0H16(66),16,ex3(:),4,G1H8(6),m3h2x8(:,80),heltab2x16(:,:,256))
  call Hloop_TV_S(ntryL,G0H16(67),16,ex3(:),4,G1H8(8),m3h2x8(:,81),heltab2x16(:,:,257))
  call Hloop_SV_T(ntryL,G0H16(68),16,ex3(:),4,G1H8(24),m3h2x8(:,82),heltab2x16(:,:,258))
  call Hloop_SV_V(ntryL,G1H16(187),ex3(:),G1H8(7),m3h2x8(:,83),heltab2x16(:,:,259))
  call Hloop_SV_V(ntryL,G1H16(188),ex3(:),G1H8(5),m3h2x8(:,84),heltab2x16(:,:,260))
  call Hloop_SV_V(ntryL,G1H16(189),ex3(:),G1H8(17),m3h2x8(:,85),heltab2x16(:,:,261))
  call Hloop_SV_V(ntryL,G1H16(190),ex3(:),G1H8(18),m3h2x8(:,86),heltab2x16(:,:,262))
  call Hloop_VV_S(ntryL,G0H16(69),ex3(:),G0H8(13),m3h2x8(:,87),heltab2x16(:,:,263))
  call Hloop_VV_S(ntryL,G0H16(70),ex3(:),G0H8(4),m3h2x8(:,88),heltab2x16(:,:,264))
  call Hloop_VV_S(ntryL,G0H16(71),ex3(:),G0H8(2),m3h2x8(:,89),heltab2x16(:,:,265))
  call Hloop_VV_S(ntryL,G0H16(72),ex3(:),G0H8(3),m3h2x8(:,90),heltab2x16(:,:,266))
  call Hloop_TV_S(ntryL,G0H16(73),16,ex3(:),4,G1H8(19),m3h2x8(:,91),heltab2x16(:,:,267))
  call Hloop_SV_T(ntryL,G0H16(74),16,ex3(:),4,G1H8(20),m3h2x8(:,92),heltab2x16(:,:,268))
  call Hloop_TV_S(ntryL,G0H16(75),16,ex3(:),4,G1H8(21),m3h2x8(:,93),heltab2x16(:,:,269))
  call Hloop_SV_T(ntryL,G0H16(76),16,ex3(:),4,G1H8(1),m3h2x8(:,94),heltab2x16(:,:,270))
  call Hloop_SV_V(ntryL,G1H16(191),ex3(:),G1H8(2),m3h2x8(:,95),heltab2x16(:,:,271))
  call Hloop_SV_V(ntryL,G1H16(192),ex3(:),G1H8(22),m3h2x8(:,96),heltab2x16(:,:,272))
  call Hloop_SV_V(ntryL,G1H16(193),ex3(:),G1H8(23),m3h2x8(:,97),heltab2x16(:,:,273))
  call Hloop_SV_V(ntryL,G1H16(194),ex3(:),G1H8(3),m3h2x8(:,98),heltab2x16(:,:,274))
  call Hloop_SV_V(ntryL,G0H16(78),ex3(:),G0H8(1),m3h2x8(:,99),heltab2x16(:,:,275))
  call Hloop_SV_V(ntryL,G0H16(80),ex3(:),G0H8(14),m3h2x8(:,100),heltab2x16(:,:,276))
  call Hloop_VV_S(ntryL,G0H16(82),ex3(:),G0H8(15),m3h2x8(:,101),heltab2x16(:,:,277))
  call Hloop_VV_S(ntryL,G0H16(84),ex3(:),G0H8(16),m3h2x8(:,102),heltab2x16(:,:,278))
  call Hloop_VV_S(ntryL,G1H16(195),ex3(:),G1H8(25),m3h2x8(:,103),heltab2x16(:,:,279))
  call Hloop_VV_S(ntryL,G1H16(196),ex3(:),G1H8(26),m3h2x8(:,104),heltab2x16(:,:,280))
  call Hloop_VV_S(ntryL,G1H16(197),ex3(:),G1H8(27),m3h2x8(:,105),heltab2x16(:,:,281))
  call Hloop_VV_S(ntryL,G1H16(198),ex3(:),G1H8(28),m3h2x8(:,106),heltab2x16(:,:,282))
  call Hloop_UV_W(ntryL,G0H16(85),16,ex3(:),4,G1H8(29),m3h2x8(:,107),heltab2x16(:,:,283))
  call Hloop_UW_V(ntryL,G0H16(86),16,ex3(:),4,G1H8(30),m3h2x8(:,108),heltab2x16(:,:,284))
  call Hloop_UV_W(ntryL,G0H16(87),16,ex3(:),4,G1H8(31),m3h2x8(:,109),heltab2x16(:,:,285))
  call Hloop_UW_V(ntryL,G0H16(88),16,ex3(:),4,G1H8(32),m3h2x8(:,110),heltab2x16(:,:,286))
  call Hloop_SV_V(ntryL,G0H16(89),ex3(:),G0H8(17),m3h2x8(:,111),heltab2x16(:,:,287))
  call Hloop_SV_V(ntryL,G0H16(90),ex3(:),G0H8(18),m3h2x8(:,112),heltab2x16(:,:,288))
  call Hloop_SV_V(ntryL,G0H16(91),ex3(:),G0H8(19),m3h2x8(:,113),heltab2x16(:,:,289))
  call Hloop_SV_V(ntryL,G0H16(92),ex3(:),G0H8(20),m3h2x8(:,114),heltab2x16(:,:,290))
  call Hloop_VV_S(ntryL,G1H16(199),ex3(:),G1H8(33),m3h2x8(:,115),heltab2x16(:,:,291))
  call Hloop_VV_S(ntryL,G1H16(200),ex3(:),G1H8(34),m3h2x8(:,116),heltab2x16(:,:,292))
  call Hloop_VV_S(ntryL,G1H16(201),ex3(:),G1H8(35),m3h2x8(:,117),heltab2x16(:,:,293))
  call Hloop_VV_S(ntryL,G1H16(202),ex3(:),G1H8(36),m3h2x8(:,118),heltab2x16(:,:,294))
  call Hloop_UV_W(ntryL,G0H16(93),16,ex3(:),4,G1H8(37),m3h2x8(:,119),heltab2x16(:,:,295))
  call Hloop_UW_V(ntryL,G0H16(94),16,ex3(:),4,G1H8(38),m3h2x8(:,120),heltab2x16(:,:,296))
  call Hloop_UV_W(ntryL,G0H16(95),16,ex3(:),4,G1H8(39),m3h2x8(:,121),heltab2x16(:,:,297))
  call Hloop_UW_V(ntryL,G0H16(96),16,ex3(:),4,G1H8(40),m3h2x8(:,122),heltab2x16(:,:,298))
  call Hloop_UV_W(ntryL,G1H16(203),16,ex3(:),4,G2H8(43),m3h2x8(:,123),heltab2x16(:,:,299))
  call Hloop_UW_V(ntryL,G1H16(204),16,ex3(:),4,G2H8(44),m3h2x8(:,124),heltab2x16(:,:,300))
  call Hloop_UV_W(ntryL,G1H16(205),16,ex3(:),4,G2H8(45),m3h2x8(:,125),heltab2x16(:,:,301))
  call Hloop_UW_V(ntryL,G1H16(206),16,ex3(:),4,G2H8(46),m3h2x8(:,126),heltab2x16(:,:,302))
  call Hloop_AQ_V(ntryL,G1H16(207),wf4(:,3),G1H4(99),m3h4x4(:,177),heltab2x16(:,:,303))
  call Hloop_AQ_Z(ntryL,G1H16(208),wf4(:,3),G1H4(100),ngZl,m3h4x4(:,178),heltab2x16(:,:,304))
  call Hloop_WQ_A(ntryL,G0H16(97),wf4(:,3),G0H4(25),m3h4x4(:,179),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(25),21,0,G1H4(101),n2h4(87))
  call Hloop_WQ_A(ntryL,G1H16(209),wf4(:,3),G1H4(102),m3h4x4(:,180),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(102),21,0,G2H4(95),n2h4(88))
  call Hloop_QA_V(ntryL,G1H16(210),ex2(:),G1H8(41),m3h2x8(:,127),heltab2x16(:,:,307))
  call Hloop_QA_Z(ntryL,G1H16(211),ex2(:),G1H8(42),ngZl,m3h2x8(:,128),heltab2x16(:,:,308))
  call Hloop_WA_Q(ntryL,G0H16(98),ex2(:),G0H8(21),m3h2x8(:,129),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G0H8(21),18,0,G1H8(43),n2h8(57))
  call Hloop_WA_Q(ntryL,G1H16(212),ex2(:),G1H8(44),m3h2x8(:,130),heltab2x16(:,:,310))
  call Hloop_A_Q(ntryL,G1H8(44),18,0,G2H8(47),n2h8(58))
  call Hloop_QA_V(ntryL,G1H16(213),wf4(:,10),G1H4(102),m3h4x4(:,181),heltab2x16(:,:,311))
  call Hloop_QA_Z(ntryL,G1H16(214),wf4(:,10),G1H4(103),ngZl,m3h4x4(:,182),heltab2x16(:,:,312))
  call Hloop_WA_Q(ntryL,G0H16(99),wf4(:,10),G0H4(25),m3h4x4(:,183),heltab2x16(:,:,313))
  call Hloop_A_Q(ntryL,G0H4(25),22,0,G1H4(104),n2h4(89))
  call Hloop_WA_Q(ntryL,G1H16(215),wf4(:,10),G1H4(105),m3h4x4(:,184),heltab2x16(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(105),22,0,G2H4(96),n2h4(90))
  call Hloop_AQ_V(ntryL,G1H16(216),ex1(:),G1H8(44),m3h2x8(:,131),heltab2x16(:,:,315))
  call Hloop_AQ_Z(ntryL,G1H16(217),ex1(:),G1H8(45),ngZl,m3h2x8(:,132),heltab2x16(:,:,316))
  call Hloop_WQ_A(ntryL,G0H16(100),ex1(:),G0H8(21),m3h2x8(:,133),heltab2x16(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(46),n2h8(59))
  call Hloop_WQ_A(ntryL,G1H16(218),ex1(:),G1H8(47),m3h2x8(:,134),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G1H8(47),17,0,G2H8(48),n2h8(60))
  call Hloop_QV_A(ntryL,G1H16(219),ex3(:),G1H8(47),m3h2x8(:,135),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G1H8(47),20,0,G2H8(49),n2h8(61))
  call Hloop_QV_A(ntryL,G1H16(220),ex3(:),G1H8(47),m3h2x8(:,136),heltab2x16(:,:,320))
  call Hloop_Q_A(ntryL,G1H8(47),20,0,G2H8(50),n2h8(62))
  call Hloop_SV_V(ntryL,G0H16(101),ex3(:),G0H8(21),m3h2x8(:,137),heltab2x16(:,:,321))
  call Hloop_UV_W(ntryL,G1H16(221),16,ex3(:),4,G2H8(51),m3h2x8(:,138),heltab2x16(:,:,322))
  call Hloop_QA_V(ntryL,G1H16(222),ex2(:),G1H8(47),m3h2x8(:,139),heltab2x16(:,:,323))
  call Hloop_QA_Z(ntryL,G1H16(223),ex2(:),G1H8(48),ngZl,m3h2x8(:,140),heltab2x16(:,:,324))
  call Hloop_WA_Q(ntryL,G0H16(102),ex2(:),G0H8(22),m3h2x8(:,141),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G0H8(22),18,0,G1H8(49),n2h8(63))
  call Hloop_WA_Q(ntryL,G1H16(224),ex2(:),G1H8(50),m3h2x8(:,142),heltab2x16(:,:,326))
  call Hloop_A_Q(ntryL,G1H8(50),18,0,G2H8(52),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H16(225),ex3(:),G1H8(50),m3h2x8(:,143),heltab2x16(:,:,327))
  call Hloop_A_Q(ntryL,G1H8(50),20,0,G2H8(53),n2h8(65))
  call Hloop_AV_Q(ntryL,G1H16(226),ex3(:),G1H8(50),m3h2x8(:,144),heltab2x16(:,:,328))
  call Hloop_A_Q(ntryL,G1H8(50),20,0,G2H8(54),n2h8(66))
  call Hloop_SV_V(ntryL,G0H16(103),ex3(:),G0H8(22),m3h2x8(:,145),heltab2x16(:,:,329))
  call Hloop_UW_V(ntryL,G1H16(227),16,ex3(:),4,G2H8(55),m3h2x8(:,146),heltab2x16(:,:,330))
  call Hloop_AQ_V(ntryL,G1H16(228),ex1(:),G1H8(50),m3h2x8(:,147),heltab2x16(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H16(229),ex1(:),G1H8(51),ngZl,m3h2x8(:,148),heltab2x16(:,:,332))
  call Hloop_WQ_A(ntryL,G0H16(104),ex1(:),G0H8(23),m3h2x8(:,149),heltab2x16(:,:,333))
  call Hloop_Q_A(ntryL,G0H8(23),17,0,G1H8(52),n2h8(67))
  call Hloop_WQ_A(ntryL,G1H16(230),ex1(:),G1H8(53),m3h2x8(:,150),heltab2x16(:,:,334))
  call Hloop_Q_A(ntryL,G1H8(53),17,0,G2H8(56),n2h8(68))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(25),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(105),n2h4(91))
  call Hloop_ZA_Q(ntryL,G0H8(6),ex2(:),G0H4(25),ngZl,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(106),n2h4(92))
  call Hloop_QA_W(ntryL,G1H8(9),ex2(:),G1H4(107),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QA_W(ntryL,G1H8(10),ex2(:),G1H4(108),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(25),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(109),n2h4(93))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex2(:),G0H4(25),ngZl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(110),n2h4(94))
  call Hloop_QA_W(ntryL,G1H8(11),ex2(:),G1H4(111),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_QA_W(ntryL,G1H8(12),ex2(:),G1H4(112),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(25),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(113),n2h4(95))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(25),ngZl,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(114),n2h4(96))
  call Hloop_AQ_W(ntryL,G1H8(13),ex1(:),G1H4(115),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(116),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G0H8(11),ex1(:),G0H4(25),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(117),n2h4(97))
  call Hloop_ZQ_A(ntryL,G0H8(12),ex1(:),G0H4(25),ngZl,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(118),n2h4(98))
  call Hloop_AQ_W(ntryL,G1H8(15),ex1(:),G1H4(119),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_W(ntryL,G1H8(16),ex1(:),G1H4(120),m3h2x4(:,60),heltab2x8(:,:,60))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(69),G2H4(64),G2H4(54),G1H4(30),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G2H4(84),G1H4(34),G0H4(24),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(3),G2H4(27),G2H4(15),G1H4(58),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(39),G1H4(62),G0H4(11),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(67),G2H4(61),G2H4(51),G1H4(74),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G2H4(83),G1H4(78),G0H4(23),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(5),G2H4(32),G2H4(18),G1H4(90),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(40),G1H4(94),G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(11),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(12),G0H4(4),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(3),G1H4(53),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(4),G1H4(54),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(65),G1H4(59),G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(66),G1H4(60),G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(45),G2H4(44),G2H4(43),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(49),G2H4(48),G2H4(47),G0H4(6),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(81),G1H4(75),G1H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(82),G1H4(76),G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(87),G1H4(79),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(88),G1H4(80),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G2H4(75),G0H4(15),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G2H4(76),G0H4(16),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G2H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(95),G1H4(43),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(96),G1H4(44),G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(15),G1H4(7),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(16),G1H4(8),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(89),G2H4(88),G2H4(87),G0H4(20),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(93),G2H4(92),G2H4(91),G0H4(18),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(1),G1H4(25),G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(2),G1H4(26),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(37),G1H4(31),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(38),G1H4(32),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(39),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G2H8(41),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(33),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G2H8(43),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G2H8(45),G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G0H8(22)])
call HGT_lower_alpha_OLR(G2H4(24),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(24),2,5,4)
call HGT_lower_alpha_OLR(G2H4(24),6,15,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(26),mass4set(:,1),  & 
G1H4(12),G1H4(18),G1H4(23),G1H4(30),G1H4(24),4)
  call HG1shiftOLR(G1H4(18),2,4)
  call Hloop_QA_W(ntryL,G2H4(95),ex2(:),G2H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
call HGT_lower_alpha_OLR(G2H4(29),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(29),2,5,4)
call HGT_lower_alpha_OLR(G2H4(29),6,15,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(27),mass4set(:,1),  & 
G1H4(29),G1H4(33),G1H4(34),G1H4(40),G1H4(46),4)
  call HG1shiftOLR(G1H4(33),1,4)
  call Hloop_AQ_W(ntryL,G2H4(96),ex1(:),G2H2(2),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(6),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(6),23,0,G2H2(3),n2h2(37))
  call Hloop_VA_Q(ntryL,G1H4(99),ex2(:),G1H2(17),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(17),23,0,G2H2(4),n2h2(38))
  call Hloop_ZA_Q(ntryL,G1H4(17),ex2(:),G1H2(28),ngZl,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(28),23,0,G2H2(5),n2h2(39))
  call Hloop_ZA_Q(ntryL,G1H4(100),ex2(:),G1H2(39),ngZl,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(39),23,0,G2H2(6),n2h2(40))
  call Hloop_QV_A(ntryL,G1H4(113),ex3(:),G1H2(50),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(50),23,0,G2H2(7),n2h2(41))
  call Hotf_4pt_reduction(G2H4(73),RedSet_4(10),mass4set(:,2),  & 
G1H4(51),G1H4(58),G1H4(52),G1H4(57),G1H4(61),G0H4(25),4)
  call HG1shiftOLR(G1H4(58),8,4)
  call Hloop_QV_A(ntryL,G1H4(114),ex3(:),G1H2(61),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(61),23,0,G2H2(8),n2h2(42))
  call Hloop_UV_W(ntryL,G1H4(116),19,ex3(:),4,G2H2(9),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hotf_4pt_reduction(G2H4(86),RedSet_4(10),mass4set(:,6),  & 
G1H4(62),G1H4(67),G1H4(74),G1H4(68),G1H4(73),G0H4(24),4)
  call HG1shiftOLR(G1H4(67),8,4)
  call Hloop_VQ_A(ntryL,G1H4(39),ex1(:),G1H2(72),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(72),23,0,G2H2(10),n2h2(43))
  call Hloop_VQ_A(ntryL,G1H4(102),ex1(:),G1H2(83),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(83),23,0,G2H2(11),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(45),ex1(:),G1H2(94),ngZl,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(94),23,0,G2H2(13),n2h2(45))
  call Hloop_ZQ_A(ntryL,G1H4(103),ex1(:),G1H2(105),ngZl,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(105),23,0,G2H2(14),n2h2(46))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(116),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(116),27,0,G2H2(16),n2h2(47))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(17),mass4set(:,2),  & 
G1H4(77),G1H4(78),G1H4(83),G1H4(90),G1H4(84),G0H4(22),4)
  call HG1shiftOLR(G1H4(78),4,4)
  call Hloop_QV_A(ntryL,G1H4(118),ex4(:),G1H2(127),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(127),27,0,G2H2(17),n2h2(48))
  call Hloop_UV_W(ntryL,G1H4(120),19,ex4(:),8,G2H2(20),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(17),mass4set(:,6),  & 
G1H4(89),G1H4(93),G1H4(94),G1H4(3),G1H4(53),G0H4(11),4)
  call HG1shiftOLR(G1H4(93),4,4)
  call Hloop_AV_Q(ntryL,G1H4(105),ex3(:),G1H2(138),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(138),23,0,G2H2(21),n2h2(49))
  call Hotf_4pt_reduction(G2H4(71),RedSet_4(10),mass4set(:,2),  & 
G1H4(49),G1H4(4),G1H4(54),G1H4(50),G1H4(65),G0H4(9),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hloop_AV_Q(ntryL,G1H4(106),ex3(:),G1H2(149),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(149),23,0,G2H2(24),n2h2(50))
  call Hloop_UW_V(ntryL,G1H4(108),19,ex3(:),4,G2H2(25),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(10),mass4set(:,6),  & 
G1H4(59),G1H4(55),G1H4(66),G1H4(60),G1H4(56),G0H4(23),4)
  call HG1shiftOLR(G1H4(55),8,4)
  call Hloop_AV_Q(ntryL,G1H4(109),ex4(:),G1H2(160),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(160),27,0,G2H2(28),n2h2(51))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(17),mass4set(:,2),  & 
G1H4(81),G1H4(75),G1H4(71),G1H4(82),G1H4(76),G0H4(21),4)
  call HG1shiftOLR(G1H4(75),4,4)
  call Hloop_AV_Q(ntryL,G1H4(110),ex4(:),G1H2(171),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(171),27,0,G2H2(29),n2h2(52))
  call Hloop_UW_V(ntryL,G1H4(112),19,ex4(:),8,G2H2(32),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(17),mass4set(:,6),  & 
G1H4(72),G1H4(87),G1H4(79),G1H4(5),G1H4(88),G0H4(12),4)
  call HG1shiftOLR(G1H4(87),4,4)
  call Hloop_QA_W(ntryL,G2H4(13),ex2(:),G2H2(33),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AQ_W(ntryL,G2H4(14),ex1(:),G2H2(36),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_AQ_W(ntryL,G1H4(13),ex1(:),G1H2(182),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_QA_W(ntryL,G1H4(14),ex2(:),G1H2(193),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_QA_W(ntryL,G2H8(1),ex2(:),G2H4(25),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_AQ_W(ntryL,G2H8(2),ex1(:),G2H4(30),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(17),mass4set(:,7),  & 
G1H4(80),G1H4(6),G1H4(95),G1H4(43),G1H4(41),G0H4(10),4)
  call HG1shiftOLR(G1H4(6),4,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(17),mass4set(:,8),  & 
G1H4(96),G1H4(44),G1H4(42),G1H4(15),G1H4(7),G0H4(3),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(17),mass4set(:,7),  & 
G1H4(47),G1H4(16),G1H4(8),G1H4(48),G1H4(1),G0H4(1),4)
  call HG1shiftOLR(G1H4(16),4,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(17),mass4set(:,8),  & 
G1H4(25),G1H4(21),G1H4(2),G1H4(26),G1H4(22),G0H4(4),4)
  call HG1shiftOLR(G1H4(21),4,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(17),mass4set(:,9),  & 
G1H4(37),G1H4(31),G1H4(27),G1H4(38),G1H4(32),G0H4(2),4)
  call HG1shiftOLR(G1H4(31),4,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(17),mass4set(:,9),  & 
G1H4(28),G1H4(11),G1H4(99),G1H4(17),G1H4(100),G0H4(8),4)
  call HG1shiftOLR(G1H4(11),4,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(17),mass4set(:,10),  & 
G1H4(113),G1H4(114),G1H4(116),G1H4(39),G1H4(102),G0H4(7),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(17),mass4set(:,10),  & 
G1H4(45),G1H4(103),G1H4(117),G1H4(118),G1H4(120),G0H4(6),4)
  call HG1shiftOLR(G1H4(103),4,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(17),mass4set(:,6),  & 
G1H4(105),G1H4(106),G1H4(108),G1H4(109),G1H4(110),G0H4(5),4)
  call HG1shiftOLR(G1H4(106),4,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(17),mass4set(:,6),  & 
G1H4(112),G1H4(13),G1H4(14),G1H4(121),G1H4(122),G0H4(15),4)
  call HG1shiftOLR(G1H4(13),4,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(17),mass4set(:,6),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G0H4(13),4)
  call HG1shiftOLR(G1H4(124),4,4)
  call Hotf_4pt_reduction(G2H4(38),RedSet_4(17),mass4set(:,6),  & 
G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),G0H4(16),4)
  call HG1shiftOLR(G1H4(129),4,4)
  call Hloop_VV_S(ntryL,G1H4(63),ex4(:),G1H2(5),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_VV_S(ntryL,G1H4(64),ex4(:),G1H2(1),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_TV_S(ntryL,G1H4(69),19,ex4(:),8,G2H2(37),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_SV_T(ntryL,G1H4(70),19,ex4(:),8,G2H2(40),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_SV_V(ntryL,G2H4(46),ex4(:),G2H2(41),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_VV_S(ntryL,G2H4(50),ex4(:),G2H2(44),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_UV_W(ntryL,G1H4(85),19,ex4(:),8,G2H2(45),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_UW_V(ntryL,G1H4(86),19,ex4(:),8,G2H2(48),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_SV_V(ntryL,G1H4(91),ex4(:),G1H2(7),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_SV_V(ntryL,G1H4(92),ex4(:),G1H2(8),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(10),mass4set(:,7),  & 
G1H4(63),G1H4(64),G1H4(69),G1H4(70),G1H4(85),G0H4(14),4)
  call HG1shiftOLR(G1H4(64),8,4)
  call Hotf_4pt_reduction(G2H4(63),RedSet_4(10),mass4set(:,8),  & 
G1H4(86),G1H4(91),G1H4(92),G1H4(133),G1H4(134),G0H4(20),4)
  call HG1shiftOLR(G1H4(91),8,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(10),mass4set(:,7),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G0H4(19),4)
  call HG1shiftOLR(G1H4(136),8,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(10),mass4set(:,8),  & 
G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),G0H4(18),4)
  call HG1shiftOLR(G1H4(141),8,4)
  call Hotf_4pt_reduction(G2H4(68),RedSet_4(10),mass4set(:,9),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G0H4(17),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(10),mass4set(:,9),  & 
G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),G0H4(26),4)
  call HG1shiftOLR(G1H4(151),8,4)
  call Hotf_4pt_reduction(G2H4(72),RedSet_4(10),mass4set(:,10),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G0H4(27),4)
  call HG1shiftOLR(G1H4(156),8,4)
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(10),mass4set(:,10),  & 
G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),G0H4(28),4)
  call HG1shiftOLR(G1H4(161),8,4)
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(10),mass4set(:,6),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G0H4(29),4)
  call HG1shiftOLR(G1H4(166),8,4)
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(10),mass4set(:,6),  & 
G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),G0H4(30),4)
  call HG1shiftOLR(G1H4(171),8,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(10),mass4set(:,6),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G0H4(31),4)
  call HG1shiftOLR(G1H4(176),8,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(10),mass4set(:,6),  & 
G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),G0H4(32),4)
  call HG1shiftOLR(G1H4(181),8,4)
  call Hloop_SV_T(ntryL,G1H4(9),19,ex3(:),4,G2H2(49),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_TV_S(ntryL,G1H4(10),19,ex3(:),4,G2H2(52),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_VV_S(ntryL,G1H4(19),ex3(:),G1H2(12),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_VV_S(ntryL,G1H4(20),ex3(:),G1H2(13),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_SV_V(ntryL,G2H4(90),ex3(:),G2H2(53),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_VV_S(ntryL,G2H4(94),ex3(:),G2H2(56),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_SV_V(ntryL,G1H4(35),ex3(:),G1H2(18),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_SV_V(ntryL,G1H4(36),ex3(:),G1H2(19),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_UW_V(ntryL,G1H4(97),19,ex3(:),4,G2H2(57),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_UV_W(ntryL,G1H4(98),19,ex3(:),4,G2H2(60),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(7),mass4set(:,2),  & 
G1H8(53),G1H8(9),G1H8(10),G1H8(11),G1H8(12),G0H8(23),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(7),mass4set(:,7),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(4),G0H8(5),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(7),mass4set(:,8),  & 
G1H8(6),G1H8(8),G1H8(24),G1H8(7),G1H8(5),G0H8(6),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(7),mass4set(:,2),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G0H8(7),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(7),mass4set(:,7),  & 
G1H8(1),G1H8(2),G1H8(22),G1H8(23),G1H8(3),G0H8(8),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(7),mass4set(:,8),  & 
G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),G0H8(9),8)
  call HG1shiftOLR(G1H8(55),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(7),mass4set(:,9),  & 
G1H8(59),G1H8(60),G1H8(61),G1H8(62),G1H8(63),G0H8(10),8)
  call HG1shiftOLR(G1H8(60),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(7),mass4set(:,9),  & 
G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),G0H8(11),8)
  call HG1shiftOLR(G1H8(65),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(7),mass4set(:,10),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G0H8(12),8)
  call HG1shiftOLR(G1H8(70),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(7),mass4set(:,10),  & 
G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),G0H8(13),8)
  call HG1shiftOLR(G1H8(75),8,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(7),mass4set(:,2),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G0H8(4),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(7),mass4set(:,7),  & 
G1H8(84),G1H8(85),G1H8(86),G1H8(87),G1H8(88),G0H8(2),8)
  call HG1shiftOLR(G1H8(85),8,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(7),mass4set(:,8),  & 
G1H8(89),G1H8(90),G1H8(91),G1H8(92),G1H8(93),G0H8(3),8)
  call HG1shiftOLR(G1H8(90),8,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(7),mass4set(:,2),  & 
G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),G0H8(17),8)
  call HG1shiftOLR(G1H8(95),8,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(7),mass4set(:,7),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),G0H8(18),8)
  call HG1shiftOLR(G1H8(100),8,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(7),mass4set(:,8),  & 
G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),G0H8(19),8)
  call HG1shiftOLR(G1H8(105),8,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(7),mass4set(:,2),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G0H8(20),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(7),mass4set(:,9),  & 
G1H8(114),G1H8(115),G1H8(116),G1H8(117),G1H8(118),G0H8(15),8)
  call HG1shiftOLR(G1H8(115),8,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(7),mass4set(:,2),  & 
G1H8(119),G1H8(120),G1H8(121),G1H8(122),G1H8(123),G0H8(16),8)
  call HG1shiftOLR(G1H8(120),8,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(7),mass4set(:,9),  & 
G1H8(124),G1H8(125),G1H8(126),G1H8(127),G1H8(128),G0H8(1),8)
  call HG1shiftOLR(G1H8(125),8,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(7),mass4set(:,2),  & 
G1H8(129),G1H8(130),G1H8(131),G1H8(132),G1H8(133),G0H8(14),8)
  call HG1shiftOLR(G1H8(130),8,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(7),mass4set(:,10),  & 
G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),G0H8(21),8)
  call HG1shiftOLR(G1H8(135),8,8)
  call Hotf_4pt_reduction(G2H8(25),RedSet_4(7),mass4set(:,2),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G0H8(22),8)
  call HG1shiftOLR(G1H8(140),8,8)
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(7),mass4set(:,10),  & 
G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),G0H8(24),8)
  call HG1shiftOLR(G1H8(145),8,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(7),mass4set(:,6),  & 
G1H8(149),G1H8(150),G1H8(151),G1H8(152),G1H8(153),G0H8(25),8)
  call HG1shiftOLR(G1H8(150),8,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(7),mass4set(:,6),  & 
G1H8(154),G1H8(155),G1H8(156),G1H8(157),G1H8(158),G0H8(26),8)
  call HG1shiftOLR(G1H8(155),8,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(7),mass4set(:,6),  & 
G1H8(159),G1H8(160),G1H8(161),G1H8(162),G1H8(163),G0H8(27),8)
  call HG1shiftOLR(G1H8(160),8,8)
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(7),mass4set(:,6),  & 
G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),G0H8(28),8)
  call HG1shiftOLR(G1H8(165),8,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(7),mass4set(:,6),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G0H8(29),8)
  call HG1shiftOLR(G1H8(170),8,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(7),mass4set(:,6),  & 
G1H8(174),G1H8(175),G1H8(176),G1H8(177),G1H8(178),G0H8(30),8)
  call HG1shiftOLR(G1H8(175),8,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(7),mass4set(:,6),  & 
G1H8(179),G1H8(180),G1H8(181),G1H8(182),G1H8(183),G0H8(31),8)
  call HG1shiftOLR(G1H8(180),8,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(7),mass4set(:,6),  & 
G1H8(184),G1H8(185),G1H8(186),G1H8(187),G1H8(188),G0H8(32),8)
  call HG1shiftOLR(G1H8(185),8,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(7),mass4set(:,6),  & 
G1H8(189),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G0H8(33),8)
  call HG1shiftOLR(G1H8(190),8,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(7),mass4set(:,6),  & 
G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),G0H8(34),8)
  call HG1shiftOLR(G1H8(195),8,8)
  call Hotf_4pt_reduction(G2H8(37),RedSet_4(7),mass4set(:,6),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G0H8(35),8)
  call HG1shiftOLR(G1H8(200),8,8)
  call Hotf_4pt_reduction(G2H8(38),RedSet_4(7),mass4set(:,6),  & 
G1H8(204),G1H8(205),G1H8(206),G1H8(207),G1H8(208),G0H8(36),8)
  call HG1shiftOLR(G1H8(205),8,8)
  call Hloop_SV_V(ntryL,G2H8(40),wf4(:,13),G2H2(61),m3h4x2(:,1),heltab2x8(:,:,63))
  call Hloop_SV_V(ntryL,G2H8(42),wf4(:,14),G2H2(64),m3h4x2(:,2),heltab2x8(:,:,64))
  call Hloop_TV_S(ntryL,G1H8(25),20,wf4(:,13),3,G2H2(65),m3h4x2(:,3),heltab2x8(:,:,65))
  call Hloop_SV_T(ntryL,G1H8(26),20,wf4(:,13),3,G2H2(68),m3h4x2(:,4),heltab2x8(:,:,66))
  call Hloop_TV_S(ntryL,G1H8(27),20,wf4(:,14),3,G2H2(69),m3h4x2(:,5),heltab2x8(:,:,67))
  call Hloop_SV_T(ntryL,G1H8(28),20,wf4(:,14),3,G2H2(72),m3h4x2(:,6),heltab2x8(:,:,68))
  call Hloop_VV_S(ntryL,G1H8(29),wf4(:,13),G1H2(23),m3h4x2(:,7),heltab2x8(:,:,69))
  call Hloop_VV_S(ntryL,G1H8(30),wf4(:,13),G1H2(24),m3h4x2(:,8),heltab2x8(:,:,70))
  call Hloop_VV_S(ntryL,G1H8(31),wf4(:,14),G1H2(29),m3h4x2(:,9),heltab2x8(:,:,71))
  call Hloop_VV_S(ntryL,G1H8(32),wf4(:,14),G1H2(30),m3h4x2(:,10),heltab2x8(:,:,72))
  call Hloop_SV_V(ntryL,G1H8(33),wf4(:,13),G1H2(34),m3h4x2(:,11),heltab2x8(:,:,73))
  call Hloop_SV_V(ntryL,G1H8(34),wf4(:,13),G1H2(35),m3h4x2(:,12),heltab2x8(:,:,74))
  call Hloop_SV_V(ntryL,G1H8(35),wf4(:,14),G1H2(40),m3h4x2(:,13),heltab2x8(:,:,75))
  call Hloop_SV_V(ntryL,G1H8(36),wf4(:,14),G1H2(41),m3h4x2(:,14),heltab2x8(:,:,76))
  call Hloop_UV_W(ntryL,G1H8(37),20,wf4(:,13),3,G2H2(73),m3h4x2(:,15),heltab2x8(:,:,77))
  call Hloop_UW_V(ntryL,G1H8(38),20,wf4(:,13),3,G2H2(76),m3h4x2(:,16),heltab2x8(:,:,78))
  call Hloop_UV_W(ntryL,G1H8(39),20,wf4(:,14),3,G2H2(77),m3h4x2(:,17),heltab2x8(:,:,79))
  call Hloop_UW_V(ntryL,G1H8(40),20,wf4(:,14),3,G2H2(80),m3h4x2(:,18),heltab2x8(:,:,80))
  call Hloop_VV_S(ntryL,G2H8(44),wf4(:,13),G2H2(81),m3h4x2(:,19),heltab2x8(:,:,81))
  call Hloop_VV_S(ntryL,G2H8(46),wf4(:,14),G2H2(82),m3h4x2(:,20),heltab2x8(:,:,82))
  call Hloop_QA_W(ntryL,G1H4(101),ex2(:),G1H2(45),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_VQ_A(ntryL,G1H8(41),wf4(:,3),G1H2(46),m3h4x2(:,21),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(83),n2h2(53))
  call Hloop_ZQ_A(ntryL,G1H8(42),wf4(:,3),G1H2(51),ngZl,m3h4x2(:,22),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(51),23,0,G2H2(84),n2h2(54))
  call Hloop_AQ_W(ntryL,G1H8(43),wf4(:,3),G1H2(52),m3h4x2(:,23),heltab2x8(:,:,85))
  call Hloop_AQ_W(ntryL,G2H8(47),wf4(:,3),G2H2(85),m3h4x2(:,24),heltab2x8(:,:,86))
  call Hloop_AQ_W(ntryL,G1H4(104),ex1(:),G1H2(56),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_VA_Q(ntryL,G1H8(44),wf4(:,10),G1H2(57),m3h4x2(:,25),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(57),23,0,G2H2(86),n2h2(55))
  call Hloop_ZA_Q(ntryL,G1H8(45),wf4(:,10),G1H2(62),ngZl,m3h4x2(:,26),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(62),23,0,G2H2(87),n2h2(56))
  call Hloop_QA_W(ntryL,G1H8(46),wf4(:,10),G1H2(63),m3h4x2(:,27),heltab2x8(:,:,89))
  call Hloop_QA_W(ntryL,G2H8(48),wf4(:,10),G2H2(88),m3h4x2(:,28),heltab2x8(:,:,90))
  call Hloop_QA_V(ntryL,G2H8(49),ex2(:),G2H4(69),m3h2x4(:,63),heltab2x8(:,:,91))
  call Hloop_QA_Z(ntryL,G2H8(50),ex2(:),G2H4(64),ngZl,m3h2x4(:,64),heltab2x8(:,:,92))
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(2),mass4set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),8)
  call HG1shiftOLR(G1H8(26),9,8)
  call Hloop_VQ_A(ntryL,G1H8(47),wf4(:,9),G1H2(67),m3h4x2(:,29),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(67),27,0,G2H2(89),n2h2(57))
  call Hloop_ZQ_A(ntryL,G1H8(48),wf4(:,9),G1H2(68),ngZl,m3h4x2(:,30),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(68),27,0,G2H2(90),n2h2(58))
  call Hloop_AQ_W(ntryL,G1H8(49),wf4(:,9),G1H2(73),m3h4x2(:,31),heltab2x8(:,:,95))
  call Hloop_AQ_W(ntryL,G2H8(52),wf4(:,9),G2H2(91),m3h4x2(:,32),heltab2x8(:,:,96))
  call Hloop_AQ_V(ntryL,G2H8(53),ex1(:),G2H4(54),m3h2x4(:,65),heltab2x8(:,:,97))
  call Hloop_AQ_Z(ntryL,G2H8(54),ex1(:),G2H4(84),ngZl,m3h2x4(:,66),heltab2x8(:,:,98))
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(1),mass4set(:,1),  & 
G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(31),10,8)
  call Hloop_VA_Q(ntryL,G1H8(50),wf4(:,4),G1H2(74),m3h4x2(:,33),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(74),27,0,G2H2(92),n2h2(59))
  call Hloop_ZA_Q(ntryL,G1H8(51),wf4(:,4),G1H2(78),ngZl,m3h4x2(:,34),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(78),27,0,G2H2(93),n2h2(60))
  call Hloop_QA_W(ntryL,G1H8(52),wf4(:,4),G1H2(79),m3h4x2(:,35),heltab2x8(:,:,101))
  call Hloop_QA_W(ntryL,G2H8(56),wf4(:,4),G2H2(94),m3h4x2(:,36),heltab2x8(:,:,102))
  call Hloop_VV_S(ntryL,G1H4(107),ex3(:),G1H2(84),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_VV_S(ntryL,G1H4(111),ex4(:),G1H2(85),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_VV_S(ntryL,G1H4(115),ex3(:),G1H2(89),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_VV_S(ntryL,G1H4(119),ex4(:),G1H2(90),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_WQ_A(ntryL,G1H4(12),ex1(:),G1H2(95),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(95),29,0,G2H2(95),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(18),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(18),ex2(:),G1H2(96),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_WQ_A(ntryL,G1H4(30),ex1(:),G1H2(100),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(100),29,0,G2H2(96),n2h2(62))
  call Hloop_WQ_A(ntryL,G1H4(24),ex1(:),G1H2(101),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(101),29,0,G2H2(97),n2h2(63))
  call Hloop_WA_Q(ntryL,G1H4(29),ex2(:),G1H2(106),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(106),30,0,G2H2(98),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(33),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(33),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(33),ex1(:),G1H2(107),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_WA_Q(ntryL,G1H4(40),ex2(:),G1H2(111),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(111),30,0,G2H2(99),n2h2(65))
  call Hloop_WA_Q(ntryL,G1H4(46),ex2(:),G1H2(112),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(112),30,0,G2H2(100),n2h2(66))
  call Hloop_QV_A(ntryL,G1H4(51),ex3(:),G1H2(117),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(117),23,0,G2H2(101),n2h2(67))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-8,0,G2H4(3),n2h4(101))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(102),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_QV_A(ntryL,G1H4(57),ex3(:),G1H2(118),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(118),23,0,G2H2(103),n2h2(68))
  call Hloop_QV_A(ntryL,G1H4(61),ex3(:),G1H2(122),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(122),23,0,G2H2(104),n2h2(69))
  call Hloop_QV_A(ntryL,G0H4(25),ex3(:),G0H2(1),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(123),n2h2(70))
  call Hloop_UV_W(ntryL,G1H4(62),19,ex3(:),4,G2H2(105),m3h2x2(:,150),heltab2x4(:,:,150))
call HGT_raise_alpha_OLR(G1H4(67),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(67),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(67),-8,ex4(:),8,G2H2(106),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_UV_W(ntryL,G1H4(68),19,ex3(:),4,G2H2(107),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_UV_W(ntryL,G1H4(73),19,ex3(:),4,G2H2(108),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_UV_W(ntryL,G0H4(24),19,ex3(:),4,G1H2(128),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_QV_A(ntryL,G1H4(77),ex4(:),G1H2(129),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(129),27,0,G2H2(109),n2h2(71))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(78),-4,0,G2H4(27),n2h4(103))
  call Hloop_AV_Q(ntryL,G2H4(27),ex3(:),G2H2(110),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_QV_A(ntryL,G1H4(90),ex4(:),G1H2(133),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(133),27,0,G2H2(111),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(84),ex4(:),G1H2(134),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(134),27,0,G2H2(112),n2h2(73))
  call Hloop_QV_A(ntryL,G0H4(22),ex4(:),G0H2(1),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(139),n2h2(74))
  call Hloop_UV_W(ntryL,G1H4(89),19,ex4(:),8,G2H2(113),m3h2x2(:,160),heltab2x4(:,:,160))
call HGT_raise_alpha_OLR(G1H4(93),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(93),-4,ex3(:),4,G2H2(114),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_UV_W(ntryL,G1H4(3),19,ex4(:),8,G2H2(115),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_UV_W(ntryL,G1H4(53),19,ex4(:),8,G2H2(116),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_UV_W(ntryL,G0H4(11),19,ex4(:),8,G1H2(140),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_AV_Q(ntryL,G1H4(49),ex3(:),G1H2(144),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(144),23,0,G2H2(117),n2h2(75))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(4),-8,0,G2H4(15),n2h4(105))
  call Hloop_QV_A(ntryL,G2H4(15),ex4(:),G2H2(118),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_AV_Q(ntryL,G1H4(50),ex3(:),G1H2(145),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(145),23,0,G2H2(119),n2h2(76))
  call Hloop_AV_Q(ntryL,G1H4(65),ex3(:),G1H2(150),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(150),23,0,G2H2(120),n2h2(77))
  call Hloop_AV_Q(ntryL,G0H4(9),ex3(:),G0H2(1),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(151),n2h2(78))
  call Hloop_UW_V(ntryL,G1H4(59),19,ex3(:),4,G2H2(121),m3h2x2(:,170),heltab2x4(:,:,170))
call HGT_raise_alpha_OLR(G1H4(55),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(55),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(55),-8,ex4(:),8,G2H2(122),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_UW_V(ntryL,G1H4(60),19,ex3(:),4,G2H2(123),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_UW_V(ntryL,G1H4(56),19,ex3(:),4,G2H2(124),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_UW_V(ntryL,G0H4(23),19,ex3(:),4,G1H2(155),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_AV_Q(ntryL,G1H4(81),ex4(:),G1H2(156),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(156),27,0,G2H2(125),n2h2(79))
call HGT_OLR(G1H4(75),1,1,4)
call HGT_invQ_OLR(G1H4(75),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(75),-4,0,G2H4(39),n2h4(107))
  call Hloop_QV_A(ntryL,G2H4(39),ex3(:),G2H2(126),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_AV_Q(ntryL,G1H4(82),ex4(:),G1H2(161),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(161),27,0,G2H2(127),n2h2(80))
  call Hloop_AV_Q(ntryL,G1H4(76),ex4(:),G1H2(162),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(162),27,0,G2H2(128),n2h2(81))
  call Hloop_AV_Q(ntryL,G0H4(21),ex4(:),G0H2(1),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(166),n2h2(82))
  call Hloop_UW_V(ntryL,G1H4(72),19,ex4(:),8,G2H2(129),m3h2x2(:,180),heltab2x4(:,:,180))
call HGT_raise_alpha_OLR(G1H4(87),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(87),-4,ex3(:),4,G2H2(130),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_UW_V(ntryL,G1H4(5),19,ex4(:),8,G2H2(131),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_UW_V(ntryL,G1H4(88),19,ex4(:),8,G2H2(132),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_UW_V(ntryL,G0H4(12),19,ex4(:),8,G1H2(167),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_QV_A(ntryL,G1H4(80),ex4(:),G1H2(172),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(172),27,nMM,G2H2(133),n2h2(83))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(6),-4,nMM,G2H4(67),n2h4(109))
  call Hloop_AV_Q(ntryL,G2H4(67),ex3(:),G2H2(134),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_QV_A(ntryL,G1H4(43),ex4(:),G1H2(173),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(173),27,nMM,G2H2(135),n2h2(84))
  call Hloop_QV_A(ntryL,G1H4(41),ex4(:),G1H2(177),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(177),27,nMM,G2H2(136),n2h2(85))
  call Hloop_QV_A(ntryL,G0H4(10),ex4(:),G0H2(1),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMM,G1H2(178),n2h2(86))
  call Hloop_QV_A(ntryL,G1H4(96),ex4(:),G1H2(183),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(183),27,nML,G2H2(137),n2h2(87))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-4,nML,G2H4(61),n2h4(110))
  call Hloop_AV_Q(ntryL,G2H4(61),ex3(:),G2H2(138),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_QV_A(ntryL,G1H4(15),ex4(:),G1H2(184),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(184),27,nML,G2H2(139),n2h2(88))
  call Hloop_QV_A(ntryL,G1H4(7),ex4(:),G1H2(188),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(188),27,nML,G2H2(140),n2h2(89))
  call Hloop_QV_A(ntryL,G0H4(3),ex4(:),G0H2(1),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G0H2(1),27,nML,G1H2(189),n2h2(90))
  call Hloop_AV_Q(ntryL,G1H4(47),ex4(:),G1H2(194),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(194),27,nMM,G2H2(141),n2h2(91))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-4,nMM,G2H4(51),n2h4(111))
  call Hloop_QV_A(ntryL,G2H4(51),ex3(:),G2H2(142),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_AV_Q(ntryL,G1H4(48),ex4(:),G1H2(195),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(195),27,nMM,G2H2(143),n2h2(92))
  call Hloop_AV_Q(ntryL,G1H4(1),ex4(:),G1H2(6),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(6),27,nMM,G2H2(144),n2h2(93))
  call Hloop_AV_Q(ntryL,G0H4(1),ex4(:),G0H2(1),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMM,G1H2(17),n2h2(94))
  call Hloop_AV_Q(ntryL,G1H4(25),ex4(:),G1H2(28),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(28),27,nML,G2H2(145),n2h2(95))
call HGT_OLR(G1H4(21),1,1,4)
call HGT_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(21),-4,nML,G2H4(83),n2h4(112))
  call Hloop_QV_A(ntryL,G2H4(83),ex3(:),G2H2(146),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_AV_Q(ntryL,G1H4(26),ex4(:),G1H2(39),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(39),27,nML,G2H2(147),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H4(22),ex4(:),G1H2(50),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(50),27,nML,G2H2(148),n2h2(97))
  call Hloop_AV_Q(ntryL,G0H4(4),ex4(:),G0H2(1),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G0H2(1),27,nML,G1H2(61),n2h2(98))
  call Hloop_QV_A(ntryL,G1H4(37),ex4(:),G1H2(72),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(72),27,nMT,G2H2(149),n2h2(99))
call HGT_OLR(G1H4(31),1,1,4)
call HGT_invQ_OLR(G1H4(31),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(31),-4,nMT,G2H4(5),n2h4(113))
  call Hloop_AV_Q(ntryL,G2H4(5),ex3(:),G2H2(150),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_QV_A(ntryL,G1H4(38),ex4(:),G1H2(83),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(83),27,nMT,G2H2(151),n2h2(100))
  call Hloop_QV_A(ntryL,G1H4(32),ex4(:),G1H2(94),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(94),27,nMT,G2H2(152),n2h2(101))
  call Hloop_QV_A(ntryL,G0H4(2),ex4(:),G0H2(1),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(105),n2h2(102))
  call Hloop_AV_Q(ntryL,G1H4(28),ex4(:),G1H2(116),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_A_Q(ntryL,G1H2(116),27,nMT,G2H2(153),n2h2(103))
call HGT_OLR(G1H4(11),1,1,4)
call HGT_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(11),-4,nMT,G2H4(32),n2h4(114))
  call Hloop_QV_A(ntryL,G2H4(32),ex3(:),G2H2(154),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_AV_Q(ntryL,G1H4(17),ex4(:),G1H2(127),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(127),27,nMT,G2H2(155),n2h2(104))
  call Hloop_AV_Q(ntryL,G1H4(100),ex4(:),G1H2(138),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(138),27,nMT,G2H2(156),n2h2(105))
  call Hloop_AV_Q(ntryL,G0H4(8),ex4(:),G0H2(1),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(149),n2h2(106))
  call Hloop_QV_A(ntryL,G1H4(113),ex4(:),G1H2(160),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(160),27,nMB,G2H2(157),n2h2(107))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-4,nMB,G2H4(18),n2h4(115))
  call Hloop_AV_Q(ntryL,G2H4(18),ex3(:),G2H2(158),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_QV_A(ntryL,G1H4(39),ex4(:),G1H2(171),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(171),27,nMB,G2H2(159),n2h2(108))
  call Hloop_QV_A(ntryL,G1H4(102),ex4(:),G1H2(46),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(46),27,nMB,G2H2(160),n2h2(109))
  call Hloop_QV_A(ntryL,G0H4(7),ex4(:),G0H2(1),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(51),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H4(45),ex4(:),G1H2(57),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(57),27,nMB,G2H2(161),n2h2(111))
call HGT_OLR(G1H4(103),1,1,4)
call HGT_invQ_OLR(G1H4(103),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(103),-4,nMB,G2H4(40),n2h4(116))
  call Hloop_QV_A(ntryL,G2H4(40),ex3(:),G2H2(162),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_AV_Q(ntryL,G1H4(118),ex4(:),G1H2(62),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(62),27,nMB,G2H2(163),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H4(120),ex4(:),G1H2(67),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(67),27,nMB,G2H2(164),n2h2(113))
  call Hloop_AV_Q(ntryL,G0H4(6),ex4(:),G0H2(1),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(68),n2h2(114))
  call Hloop_TV_S(ntryL,G1H4(105),19,ex4(:),8,G2H2(165),m3h2x2(:,225),heltab2x4(:,:,225))
call HGT_OLR(G1H4(106),1,1,4)
call HGT_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(106),-4,ex3(:),4,G2H2(166),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_TV_S(ntryL,G1H4(109),19,ex4(:),8,G2H2(167),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_TV_S(ntryL,G1H4(110),19,ex4(:),8,G2H2(168),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_TV_S(ntryL,G0H4(5),19,ex4(:),8,G1H2(74),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_SV_T(ntryL,G1H4(112),19,ex4(:),8,G2H2(169),m3h2x2(:,230),heltab2x4(:,:,230))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(13),-4,ex3(:),4,G2H2(170),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_SV_T(ntryL,G1H4(121),19,ex4(:),8,G2H2(171),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_SV_T(ntryL,G1H4(122),19,ex4(:),8,G2H2(172),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_SV_T(ntryL,G0H4(15),19,ex4(:),8,G1H2(78),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_CV_D(ntryL,G1H4(123),19,ex4(:),8,G2H2(173),m3h2x2(:,235),heltab2x4(:,:,235))
call HGT_OLR(G1H4(124),1,1,4)
call HGT_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(124),-4,ex3(:),G2H2(174),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_CV_D(ntryL,G1H4(126),19,ex4(:),8,G2H2(175),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_CV_D(ntryL,G1H4(127),19,ex4(:),8,G2H2(176),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_CV_D(ntryL,G0H4(13),19,ex4(:),8,G1H2(95),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_DV_C(ntryL,G1H4(128),19,ex4(:),G2H2(177),m3h2x2(:,240),heltab2x4(:,:,240))
call HGT_OLR(G1H4(129),1,1,4)
call HGT_invQ_OLR(G1H4(129),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(129),-4,ex3(:),4,G2H2(178),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_DV_C(ntryL,G1H4(131),19,ex4(:),G2H2(179),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_DV_C(ntryL,G1H4(132),19,ex4(:),G2H2(180),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_DV_C(ntryL,G0H4(16),19,ex4(:),G1H2(100),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_AV_Q(ntryL,G1H4(63),ex3(:),G1H2(101),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(101),23,nMM,G2H2(181),n2h2(115))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(64),-8,nMM,G2H4(16),n2h4(121))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(182),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_AV_Q(ntryL,G1H4(70),ex3(:),G1H2(106),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(106),23,nMM,G2H2(183),n2h2(116))
  call Hloop_AV_Q(ntryL,G1H4(85),ex3(:),G1H2(111),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(111),23,nMM,G2H2(184),n2h2(117))
  call Hloop_AV_Q(ntryL,G0H4(14),ex3(:),G0H2(1),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(112),n2h2(118))
  call Hloop_AV_Q(ntryL,G1H4(86),ex3(:),G1H2(117),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(117),23,nML,G2H2(185),n2h2(119))
call HGT_OLR(G1H4(91),1,1,4)
call HGT_invQ_OLR(G1H4(91),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(91),-8,nML,G2H4(17),n2h4(122))
  call Hloop_QV_A(ntryL,G2H4(17),ex4(:),G2H2(186),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_AV_Q(ntryL,G1H4(133),ex3(:),G1H2(118),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(118),23,nML,G2H2(187),n2h2(120))
  call Hloop_AV_Q(ntryL,G1H4(134),ex3(:),G1H2(122),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(122),23,nML,G2H2(188),n2h2(121))
  call Hloop_AV_Q(ntryL,G0H4(20),ex3(:),G0H2(1),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(129),n2h2(122))
  call Hloop_QV_A(ntryL,G1H4(135),ex3(:),G1H2(133),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMM,G2H2(189),n2h2(123))
call HGT_OLR(G1H4(136),1,1,4)
call HGT_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(136),-8,nMM,G2H4(19),n2h4(123))
  call Hloop_AV_Q(ntryL,G2H4(19),ex4(:),G2H2(190),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_QV_A(ntryL,G1H4(138),ex3(:),G1H2(134),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(134),23,nMM,G2H2(191),n2h2(124))
  call Hloop_QV_A(ntryL,G1H4(139),ex3(:),G1H2(144),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(144),23,nMM,G2H2(192),n2h2(125))
  call Hloop_QV_A(ntryL,G0H4(19),ex3(:),G0H2(1),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(145),n2h2(126))
  call Hloop_QV_A(ntryL,G1H4(140),ex3(:),G1H2(150),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(150),23,nML,G2H2(193),n2h2(127))
call HGT_OLR(G1H4(141),1,1,4)
call HGT_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(141),-8,nML,G2H4(20),n2h4(124))
  call Hloop_AV_Q(ntryL,G2H4(20),ex4(:),G2H2(194),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_QV_A(ntryL,G1H4(143),ex3(:),G1H2(156),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(156),23,nML,G2H2(195),n2h2(128))
  call Hloop_QV_A(ntryL,G1H4(144),ex3(:),G1H2(161),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(161),23,nML,G2H2(196),n2h2(129))
  call Hloop_QV_A(ntryL,G0H4(18),ex3(:),G0H2(1),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(162),n2h2(130))
  call Hloop_AV_Q(ntryL,G1H4(145),ex3(:),G1H2(172),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_A_Q(ntryL,G1H2(172),23,nMT,G2H2(197),n2h2(131))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(146),-8,nMT,G2H4(21),n2h4(125))
  call Hloop_QV_A(ntryL,G2H4(21),ex4(:),G2H2(198),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_AV_Q(ntryL,G1H4(148),ex3(:),G1H2(173),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_A_Q(ntryL,G1H2(173),23,nMT,G2H2(199),n2h2(132))
  call Hloop_AV_Q(ntryL,G1H4(149),ex3(:),G1H2(177),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_A_Q(ntryL,G1H2(177),23,nMT,G2H2(200),n2h2(133))
  call Hloop_AV_Q(ntryL,G0H4(17),ex3(:),G0H2(1),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(183),n2h2(134))
  call Hloop_QV_A(ntryL,G1H4(150),ex3(:),G1H2(184),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(184),23,nMT,G2H2(201),n2h2(135))
call HGT_OLR(G1H4(151),1,1,4)
call HGT_invQ_OLR(G1H4(151),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(151),-8,nMT,G2H4(22),n2h4(126))
  call Hloop_AV_Q(ntryL,G2H4(22),ex4(:),G2H2(202),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_QV_A(ntryL,G1H4(153),ex3(:),G1H2(188),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(188),23,nMT,G2H2(203),n2h2(136))
  call Hloop_QV_A(ntryL,G1H4(154),ex3(:),G1H2(194),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(194),23,nMT,G2H2(204),n2h2(137))
  call Hloop_QV_A(ntryL,G0H4(26),ex3(:),G0H2(1),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(195),n2h2(138))
  call Hloop_AV_Q(ntryL,G1H4(155),ex3(:),G1H2(6),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_A_Q(ntryL,G1H2(6),23,nMB,G2H2(205),n2h2(139))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(156),-8,nMB,G2H4(23),n2h4(127))
  call Hloop_QV_A(ntryL,G2H4(23),ex4(:),G2H2(206),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_AV_Q(ntryL,G1H4(158),ex3(:),G1H2(28),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_A_Q(ntryL,G1H2(28),23,nMB,G2H2(207),n2h2(140))
  call Hloop_AV_Q(ntryL,G1H4(159),ex3(:),G1H2(39),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_A_Q(ntryL,G1H2(39),23,nMB,G2H2(208),n2h2(141))
  call Hloop_AV_Q(ntryL,G0H4(27),ex3(:),G0H2(1),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(50),n2h2(142))
  call Hloop_QV_A(ntryL,G1H4(160),ex3(:),G1H2(72),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(72),23,nMB,G2H2(209),n2h2(143))
call HGT_OLR(G1H4(161),1,1,4)
call HGT_invQ_OLR(G1H4(161),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(161),-8,nMB,G2H4(26),n2h4(128))
  call Hloop_AV_Q(ntryL,G2H4(26),ex4(:),G2H2(210),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_QV_A(ntryL,G1H4(163),ex3(:),G1H2(83),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(211),n2h2(144))
  call Hloop_QV_A(ntryL,G1H4(164),ex3(:),G1H2(94),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(94),23,nMB,G2H2(212),n2h2(145))
  call Hloop_QV_A(ntryL,G0H4(28),ex3(:),G0H2(1),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(116),n2h2(146))
  call Hloop_SV_T(ntryL,G1H4(165),19,ex3(:),4,G2H2(213),m3h2x2(:,285),heltab2x4(:,:,285))
call HGT_OLR(G1H4(166),1,1,4)
call HGT_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(166),-8,ex4(:),8,G2H2(214),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_SV_T(ntryL,G1H4(168),19,ex3(:),4,G2H2(215),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_SV_T(ntryL,G1H4(169),19,ex3(:),4,G2H2(216),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_SV_T(ntryL,G0H4(29),19,ex3(:),4,G1H2(127),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_TV_S(ntryL,G1H4(170),19,ex3(:),4,G2H2(217),m3h2x2(:,290),heltab2x4(:,:,290))
call HGT_OLR(G1H4(171),1,1,4)
call HGT_invQ_OLR(G1H4(171),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(171),-8,ex4(:),8,G2H2(218),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_TV_S(ntryL,G1H4(173),19,ex3(:),4,G2H2(219),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_TV_S(ntryL,G1H4(174),19,ex3(:),4,G2H2(220),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_TV_S(ntryL,G0H4(30),19,ex3(:),4,G1H2(138),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_DV_C(ntryL,G1H4(175),19,ex3(:),G2H2(221),m3h2x2(:,295),heltab2x4(:,:,295))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(176),-8,ex4(:),8,G2H2(222),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_DV_C(ntryL,G1H4(178),19,ex3(:),G2H2(223),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_DV_C(ntryL,G1H4(179),19,ex3(:),G2H2(224),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_DV_C(ntryL,G0H4(31),19,ex3(:),G1H2(160),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_CV_D(ntryL,G1H4(180),19,ex3(:),4,G2H2(225),m3h2x2(:,300),heltab2x4(:,:,300))
call HGT_OLR(G1H4(181),1,1,4)
call HGT_invQ_OLR(G1H4(181),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(181),-8,ex4(:),G2H2(226),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_CV_D(ntryL,G1H4(183),19,ex3(:),4,G2H2(227),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_CV_D(ntryL,G1H4(184),19,ex3(:),4,G2H2(228),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_CV_D(ntryL,G0H4(32),19,ex3(:),4,G1H2(171),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,13),G1H2(46),m3h4x2(:,37),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(229),n2h2(147))
call HGT_OLR(G1H8(9),1,1,8)
call HGT_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(9),-8,0,G2H8(39),n2h8(69))
  call Hloop_AV_Q(ntryL,G2H8(39),ex4(:),G2H4(11),m3h2x4(:,67),heltab2x8(:,:,104))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,13),G1H2(57),m3h4x2(:,38),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(57),23,0,G2H2(230),n2h2(148))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,13),G1H2(62),m3h4x2(:,39),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(62),23,0,G2H2(231),n2h2(149))
  call Hloop_QV_A(ntryL,G0H8(23),wf4(:,13),G0H2(1),m3h4x2(:,40),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(67),n2h2(150))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,13),G1H2(101),m3h4x2(:,41),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(101),23,nMM,G2H2(232),n2h2(151))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-8,nMM,G2H8(41),n2h8(70))
  call Hloop_AV_Q(ntryL,G2H8(41),ex4(:),G2H4(12),m3h2x4(:,68),heltab2x8(:,:,109))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,13),G1H2(106),m3h4x2(:,42),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(106),23,nMM,G2H2(233),n2h2(152))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,13),G1H2(111),m3h4x2(:,43),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMM,G2H2(234),n2h2(153))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,13),G0H2(1),m3h4x2(:,44),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(117),n2h2(154))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,13),G1H2(118),m3h4x2(:,45),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(118),23,nML,G2H2(235),n2h2(155))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-8,nML,G2H8(43),n2h8(71))
  call Hloop_AV_Q(ntryL,G2H8(43),ex4(:),G2H4(35),m3h2x4(:,69),heltab2x8(:,:,114))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,13),G1H2(122),m3h4x2(:,46),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(122),23,nML,G2H2(236),n2h2(156))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,13),G1H2(133),m3h4x2(:,47),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(133),23,nML,G2H2(237),n2h2(157))
  call Hloop_QV_A(ntryL,G0H8(6),wf4(:,13),G0H2(1),m3h4x2(:,48),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(134),n2h2(158))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,13),G1H2(144),m3h4x2(:,49),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(144),23,0,G2H2(238),n2h2(159))
call HGT_OLR(G1H8(18),1,1,8)
call HGT_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(18),-8,0,G2H8(45),n2h8(72))
  call Hloop_QV_A(ntryL,G2H8(45),ex4(:),G2H4(36),m3h2x4(:,70),heltab2x8(:,:,119))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,13),G1H2(150),m3h4x2(:,50),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(150),23,0,G2H2(239),n2h2(160))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,13),G1H2(156),m3h4x2(:,51),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(156),23,0,G2H2(240),n2h2(161))
  call Hloop_AV_Q(ntryL,G0H8(7),wf4(:,13),G0H2(1),m3h4x2(:,52),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(161),n2h2(162))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,13),G1H2(172),m3h4x2(:,53),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(172),23,nMM,G2H2(241),n2h2(163))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-8,nMM,G2H8(1),n2h8(73))
  call Hloop_QV_A(ntryL,G2H8(1),ex4(:),G2H4(45),m3h2x4(:,71),heltab2x8(:,:,124))
  call Hloop_AV_Q(ntryL,G1H8(23),wf4(:,13),G1H2(173),m3h4x2(:,54),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(173),23,nMM,G2H2(242),n2h2(164))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,13),G1H2(177),m3h4x2(:,55),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(177),23,nMM,G2H2(243),n2h2(165))
  call Hloop_AV_Q(ntryL,G0H8(8),wf4(:,13),G0H2(1),m3h4x2(:,56),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(184),n2h2(166))
  call Hloop_AV_Q(ntryL,G1H8(54),wf4(:,13),G1H2(188),m3h4x2(:,57),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(188),23,nML,G2H2(244),n2h2(167))
call HGT_OLR(G1H8(55),1,1,8)
call HGT_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(55),-8,nML,G2H8(2),n2h8(74))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(44),m3h2x4(:,72),heltab2x8(:,:,129))
  call Hloop_AV_Q(ntryL,G1H8(57),wf4(:,13),G1H2(194),m3h4x2(:,58),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(194),23,nML,G2H2(245),n2h2(168))
  call Hloop_AV_Q(ntryL,G1H8(58),wf4(:,13),G1H2(6),m3h4x2(:,59),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(6),23,nML,G2H2(246),n2h2(169))
  call Hloop_AV_Q(ntryL,G0H8(9),wf4(:,13),G0H2(1),m3h4x2(:,60),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(28),n2h2(170))
  call Hloop_QV_A(ntryL,G1H8(59),wf4(:,13),G1H2(39),m3h4x2(:,61),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMT,G2H2(247),n2h2(171))
call HGT_OLR(G1H8(60),1,1,8)
call HGT_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(60),-8,nMT,G2H8(3),n2h8(75))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(43),m3h2x4(:,73),heltab2x8(:,:,134))
  call Hloop_QV_A(ntryL,G1H8(62),wf4(:,13),G1H2(72),m3h4x2(:,62),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(72),23,nMT,G2H2(248),n2h2(172))
  call Hloop_QV_A(ntryL,G1H8(63),wf4(:,13),G1H2(83),m3h4x2(:,63),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMT,G2H2(249),n2h2(173))
  call Hloop_QV_A(ntryL,G0H8(10),wf4(:,13),G0H2(1),m3h4x2(:,64),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(94),n2h2(174))
  call Hloop_AV_Q(ntryL,G1H8(64),wf4(:,13),G1H2(46),m3h4x2(:,65),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(46),23,nMT,G2H2(250),n2h2(175))
call HGT_OLR(G1H8(65),1,1,8)
call HGT_invQ_OLR(G1H8(65),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(65),-8,nMT,G2H8(4),n2h8(76))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(49),m3h2x4(:,74),heltab2x8(:,:,139))
  call Hloop_AV_Q(ntryL,G1H8(67),wf4(:,13),G1H2(57),m3h4x2(:,66),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(57),23,nMT,G2H2(251),n2h2(176))
  call Hloop_AV_Q(ntryL,G1H8(68),wf4(:,13),G1H2(62),m3h4x2(:,67),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(62),23,nMT,G2H2(252),n2h2(177))
  call Hloop_AV_Q(ntryL,G0H8(11),wf4(:,13),G0H2(1),m3h4x2(:,68),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(101),n2h2(178))
  call Hloop_QV_A(ntryL,G1H8(69),wf4(:,13),G1H2(106),m3h4x2(:,69),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(106),23,nMB,G2H2(253),n2h2(179))
call HGT_OLR(G1H8(70),1,1,8)
call HGT_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(70),-8,nMB,G2H8(5),n2h8(77))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(48),m3h2x4(:,75),heltab2x8(:,:,144))
  call Hloop_QV_A(ntryL,G1H8(72),wf4(:,13),G1H2(111),m3h4x2(:,70),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMB,G2H2(254),n2h2(180))
  call Hloop_QV_A(ntryL,G1H8(73),wf4(:,13),G1H2(118),m3h4x2(:,71),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(118),23,nMB,G2H2(255),n2h2(181))
  call Hloop_QV_A(ntryL,G0H8(12),wf4(:,13),G0H2(1),m3h4x2(:,72),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(122),n2h2(182))
  call Hloop_AV_Q(ntryL,G1H8(74),wf4(:,13),G1H2(133),m3h4x2(:,73),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(256),n2h2(183))
call HGT_OLR(G1H8(75),1,1,8)
call HGT_invQ_OLR(G1H8(75),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(75),-8,nMB,G2H8(6),n2h8(78))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(47),m3h2x4(:,76),heltab2x8(:,:,149))
  call Hloop_AV_Q(ntryL,G1H8(77),wf4(:,13),G1H2(144),m3h4x2(:,74),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(144),23,nMB,G2H2(257),n2h2(184))
  call Hloop_AV_Q(ntryL,G1H8(78),wf4(:,13),G1H2(150),m3h4x2(:,75),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(150),23,nMB,G2H2(258),n2h2(185))
  call Hloop_AV_Q(ntryL,G0H8(13),wf4(:,13),G0H2(1),m3h4x2(:,76),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(156),n2h2(186))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,14),G1H2(172),ngZl,m3h4x2(:,77),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(172),23,0,G2H2(259),n2h2(187))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-8,0,G2H8(7),n2h8(79))
  call Hloop_AV_Q(ntryL,G2H8(7),ex4(:),G2H4(52),m3h2x4(:,77),heltab2x8(:,:,154))
  call Hloop_QZ_A(ntryL,G1H8(82),wf4(:,14),G1H2(173),ngZl,m3h4x2(:,78),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(173),23,0,G2H2(260),n2h2(188))
  call Hloop_QZ_A(ntryL,G1H8(83),wf4(:,14),G1H2(177),ngZl,m3h4x2(:,79),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(177),23,0,G2H2(261),n2h2(189))
  call Hloop_QZ_A(ntryL,G0H8(4),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,80),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(188),n2h2(190))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,14),G1H2(194),ngZl,m3h4x2(:,81),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(194),23,nMM,G2H2(262),n2h2(191))
call HGT_OLR(G1H8(85),1,1,8)
call HGT_invQ_OLR(G1H8(85),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(85),-8,nMM,G2H8(8),n2h8(80))
  call Hloop_AV_Q(ntryL,G2H8(8),ex4(:),G2H4(53),m3h2x4(:,78),heltab2x8(:,:,159))
  call Hloop_QZ_A(ntryL,G1H8(87),wf4(:,14),G1H2(6),ngZl,m3h4x2(:,82),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMM,G2H2(263),n2h2(192))
  call Hloop_QZ_A(ntryL,G1H8(88),wf4(:,14),G1H2(39),ngZl,m3h4x2(:,83),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMM,G2H2(264),n2h2(193))
  call Hloop_QZ_A(ntryL,G0H8(2),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,84),heltab2x8(:,:,162))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(72),n2h2(194))
  call Hloop_QZ_A(ntryL,G1H8(89),wf4(:,14),G1H2(83),ngZl,m3h4x2(:,85),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(83),23,nML,G2H2(265),n2h2(195))
call HGT_OLR(G1H8(90),1,1,8)
call HGT_invQ_OLR(G1H8(90),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(90),-8,nML,G2H8(9),n2h8(81))
  call Hloop_AV_Q(ntryL,G2H8(9),ex4(:),G2H4(55),m3h2x4(:,79),heltab2x8(:,:,164))
  call Hloop_QZ_A(ntryL,G1H8(92),wf4(:,14),G1H2(46),ngZl,m3h4x2(:,86),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(46),23,nML,G2H2(266),n2h2(196))
  call Hloop_QZ_A(ntryL,G1H8(93),wf4(:,14),G1H2(57),ngZl,m3h4x2(:,87),heltab2x8(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(57),23,nML,G2H2(267),n2h2(197))
  call Hloop_QZ_A(ntryL,G0H8(3),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,88),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(62),n2h2(198))
  call Hloop_AZ_Q(ntryL,G1H8(94),wf4(:,14),G1H2(106),ngZl,m3h4x2(:,89),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(106),23,0,G2H2(268),n2h2(199))
call HGT_OLR(G1H8(95),1,1,8)
call HGT_invQ_OLR(G1H8(95),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(95),-8,0,G2H8(10),n2h8(82))
  call Hloop_QV_A(ntryL,G2H8(10),ex4(:),G2H4(56),m3h2x4(:,80),heltab2x8(:,:,169))
  call Hloop_AZ_Q(ntryL,G1H8(97),wf4(:,14),G1H2(111),ngZl,m3h4x2(:,90),heltab2x8(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(111),23,0,G2H2(269),n2h2(200))
  call Hloop_AZ_Q(ntryL,G1H8(98),wf4(:,14),G1H2(118),ngZl,m3h4x2(:,91),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(118),23,0,G2H2(270),n2h2(201))
  call Hloop_AZ_Q(ntryL,G0H8(17),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,92),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(133),n2h2(202))
  call Hloop_AZ_Q(ntryL,G1H8(99),wf4(:,14),G1H2(144),ngZl,m3h4x2(:,93),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(144),23,nMM,G2H2(271),n2h2(203))
call HGT_OLR(G1H8(100),1,1,8)
call HGT_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(100),-8,nMM,G2H8(11),n2h8(83))
  call Hloop_QV_A(ntryL,G2H8(11),ex4(:),G2H4(57),m3h2x4(:,81),heltab2x8(:,:,174))
  call Hloop_AZ_Q(ntryL,G1H8(102),wf4(:,14),G1H2(150),ngZl,m3h4x2(:,94),heltab2x8(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(150),23,nMM,G2H2(272),n2h2(204))
  call Hloop_AZ_Q(ntryL,G1H8(103),wf4(:,14),G1H2(172),ngZl,m3h4x2(:,95),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(172),23,nMM,G2H2(273),n2h2(205))
  call Hloop_AZ_Q(ntryL,G0H8(18),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,96),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(173),n2h2(206))
  call Hloop_AZ_Q(ntryL,G1H8(104),wf4(:,14),G1H2(177),ngZl,m3h4x2(:,97),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(177),23,nML,G2H2(274),n2h2(207))
call HGT_OLR(G1H8(105),1,1,8)
call HGT_invQ_OLR(G1H8(105),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(105),-8,nML,G2H8(12),n2h8(84))
  call Hloop_QV_A(ntryL,G2H8(12),ex4(:),G2H4(58),m3h2x4(:,82),heltab2x8(:,:,179))
  call Hloop_AZ_Q(ntryL,G1H8(107),wf4(:,14),G1H2(194),ngZl,m3h4x2(:,98),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(194),23,nML,G2H2(275),n2h2(208))
  call Hloop_AZ_Q(ntryL,G1H8(108),wf4(:,14),G1H2(6),ngZl,m3h4x2(:,99),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(6),23,nML,G2H2(276),n2h2(209))
  call Hloop_AZ_Q(ntryL,G0H8(19),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,100),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(39),n2h2(210))
  call Hloop_QZ_A(ntryL,G1H8(109),wf4(:,14),G1H2(83),ngZu,m3h4x2(:,101),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(83),23,0,G2H2(277),n2h2(211))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(110),-8,0,G2H8(13),n2h8(85))
  call Hloop_AV_Q(ntryL,G2H8(13),ex4(:),G2H4(59),m3h2x4(:,83),heltab2x8(:,:,184))
  call Hloop_QZ_A(ntryL,G1H8(112),wf4(:,14),G1H2(46),ngZu,m3h4x2(:,102),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(278),n2h2(212))
  call Hloop_QZ_A(ntryL,G1H8(113),wf4(:,14),G1H2(57),ngZu,m3h4x2(:,103),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(57),23,0,G2H2(279),n2h2(213))
  call Hloop_QZ_A(ntryL,G0H8(20),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,104),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(106),n2h2(214))
  call Hloop_QZ_A(ntryL,G1H8(114),wf4(:,14),G1H2(111),ngZu,m3h4x2(:,105),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMT,G2H2(280),n2h2(215))
call HGT_OLR(G1H8(115),1,1,8)
call HGT_invQ_OLR(G1H8(115),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(115),-8,nMT,G2H8(14),n2h8(86))
  call Hloop_AV_Q(ntryL,G2H8(14),ex4(:),G2H4(60),m3h2x4(:,84),heltab2x8(:,:,189))
  call Hloop_QZ_A(ntryL,G1H8(117),wf4(:,14),G1H2(118),ngZu,m3h4x2(:,106),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(118),23,nMT,G2H2(281),n2h2(216))
  call Hloop_QZ_A(ntryL,G1H8(118),wf4(:,14),G1H2(144),ngZu,m3h4x2(:,107),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(144),23,nMT,G2H2(282),n2h2(217))
  call Hloop_QZ_A(ntryL,G0H8(15),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,108),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(150),n2h2(218))
  call Hloop_AZ_Q(ntryL,G1H8(119),wf4(:,14),G1H2(172),ngZu,m3h4x2(:,109),heltab2x8(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(172),23,0,G2H2(283),n2h2(219))
call HGT_OLR(G1H8(120),1,1,8)
call HGT_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(120),-8,0,G2H8(15),n2h8(87))
  call Hloop_QV_A(ntryL,G2H8(15),ex4(:),G2H4(75),m3h2x4(:,85),heltab2x8(:,:,194))
  call Hloop_AZ_Q(ntryL,G1H8(122),wf4(:,14),G1H2(177),ngZu,m3h4x2(:,110),heltab2x8(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(177),23,0,G2H2(284),n2h2(220))
  call Hloop_AZ_Q(ntryL,G1H8(123),wf4(:,14),G1H2(194),ngZu,m3h4x2(:,111),heltab2x8(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(194),23,0,G2H2(285),n2h2(221))
  call Hloop_AZ_Q(ntryL,G0H8(16),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,112),heltab2x8(:,:,197))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(6),n2h2(222))
  call Hloop_AZ_Q(ntryL,G1H8(124),wf4(:,14),G1H2(83),ngZu,m3h4x2(:,113),heltab2x8(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(83),23,nMT,G2H2(286),n2h2(223))
call HGT_OLR(G1H8(125),1,1,8)
call HGT_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(125),-8,nMT,G2H8(16),n2h8(88))
  call Hloop_QV_A(ntryL,G2H8(16),ex4(:),G2H4(76),m3h2x4(:,86),heltab2x8(:,:,199))
  call Hloop_AZ_Q(ntryL,G1H8(127),wf4(:,14),G1H2(46),ngZu,m3h4x2(:,114),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(46),23,nMT,G2H2(287),n2h2(224))
  call Hloop_AZ_Q(ntryL,G1H8(128),wf4(:,14),G1H2(57),ngZu,m3h4x2(:,115),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(57),23,nMT,G2H2(288),n2h2(225))
  call Hloop_AZ_Q(ntryL,G0H8(1),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,116),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(111),n2h2(226))
  call Hloop_QZ_A(ntryL,G1H8(129),wf4(:,14),G1H2(118),ngZd,m3h4x2(:,117),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(118),23,0,G2H2(289),n2h2(227))
call HGT_OLR(G1H8(130),1,1,8)
call HGT_invQ_OLR(G1H8(130),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(130),-8,0,G2H8(17),n2h8(89))
  call Hloop_AV_Q(ntryL,G2H8(17),ex4(:),G2H4(79),m3h2x4(:,87),heltab2x8(:,:,204))
  call Hloop_QZ_A(ntryL,G1H8(132),wf4(:,14),G1H2(144),ngZd,m3h4x2(:,118),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(144),23,0,G2H2(290),n2h2(228))
  call Hloop_QZ_A(ntryL,G1H8(133),wf4(:,14),G1H2(172),ngZd,m3h4x2(:,119),heltab2x8(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(172),23,0,G2H2(291),n2h2(229))
  call Hloop_QZ_A(ntryL,G0H8(14),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,120),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(177),n2h2(230))
  call Hloop_QZ_A(ntryL,G1H8(134),wf4(:,14),G1H2(194),ngZd,m3h4x2(:,121),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(194),23,nMB,G2H2(292),n2h2(231))
call HGT_OLR(G1H8(135),1,1,8)
call HGT_invQ_OLR(G1H8(135),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(135),-8,nMB,G2H8(18),n2h8(90))
  call Hloop_AV_Q(ntryL,G2H8(18),ex4(:),G2H4(80),m3h2x4(:,88),heltab2x8(:,:,209))
  call Hloop_QZ_A(ntryL,G1H8(137),wf4(:,14),G1H2(83),ngZd,m3h4x2(:,122),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(293),n2h2(232))
  call Hloop_QZ_A(ntryL,G1H8(138),wf4(:,14),G1H2(46),ngZd,m3h4x2(:,123),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(46),23,nMB,G2H2(294),n2h2(233))
  call Hloop_QZ_A(ntryL,G0H8(21),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,124),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(57),n2h2(234))
  call Hloop_AZ_Q(ntryL,G1H8(139),wf4(:,14),G1H2(118),ngZd,m3h4x2(:,125),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(118),23,0,G2H2(295),n2h2(235))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(140),-8,0,G2H8(19),n2h8(91))
  call Hloop_QV_A(ntryL,G2H8(19),ex4(:),G2H4(89),m3h2x4(:,89),heltab2x8(:,:,214))
  call Hloop_AZ_Q(ntryL,G1H8(142),wf4(:,14),G1H2(144),ngZd,m3h4x2(:,126),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(144),23,0,G2H2(296),n2h2(236))
  call Hloop_AZ_Q(ntryL,G1H8(143),wf4(:,14),G1H2(172),ngZd,m3h4x2(:,127),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(172),23,0,G2H2(297),n2h2(237))
  call Hloop_AZ_Q(ntryL,G0H8(22),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,128),heltab2x8(:,:,217))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(194),n2h2(238))
  call Hloop_AZ_Q(ntryL,G1H8(144),wf4(:,14),G1H2(83),ngZd,m3h4x2(:,129),heltab2x8(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(83),23,nMB,G2H2(298),n2h2(239))
call HGT_OLR(G1H8(145),1,1,8)
call HGT_invQ_OLR(G1H8(145),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(145),-8,nMB,G2H8(20),n2h8(92))
  call Hloop_QV_A(ntryL,G2H8(20),ex4(:),G2H4(88),m3h2x4(:,90),heltab2x8(:,:,219))
  call Hloop_AZ_Q(ntryL,G1H8(147),wf4(:,14),G1H2(46),ngZd,m3h4x2(:,130),heltab2x8(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(46),23,nMB,G2H2(299),n2h2(240))
  call Hloop_AZ_Q(ntryL,G1H8(148),wf4(:,14),G1H2(118),ngZd,m3h4x2(:,131),heltab2x8(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(118),23,nMB,G2H2(300),n2h2(241))
  call Hloop_AZ_Q(ntryL,G0H8(24),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,132),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(144),n2h2(242))
  call Hloop_TV_S(ntryL,G1H8(149),20,wf4(:,13),3,G2H2(301),m3h4x2(:,133),heltab2x8(:,:,223))
call HGT_OLR(G1H8(150),1,1,8)
call HGT_invQ_OLR(G1H8(150),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(150),-8,ex4(:),8,G2H4(87),m3h2x4(:,91),heltab2x8(:,:,224))
  call Hloop_TV_S(ntryL,G1H8(152),20,wf4(:,13),3,G2H2(302),m3h4x2(:,134),heltab2x8(:,:,225))
  call Hloop_TV_S(ntryL,G1H8(153),20,wf4(:,13),3,G2H2(303),m3h4x2(:,135),heltab2x8(:,:,226))
  call Hloop_TV_S(ntryL,G0H8(25),20,wf4(:,13),3,G1H2(172),m3h4x2(:,136),heltab2x8(:,:,227))
  call Hloop_SV_T(ntryL,G1H8(154),20,wf4(:,13),3,G2H2(304),m3h4x2(:,137),heltab2x8(:,:,228))
call HGT_OLR(G1H8(155),1,1,8)
call HGT_invQ_OLR(G1H8(155),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(155),-8,ex4(:),8,G2H4(93),m3h2x4(:,92),heltab2x8(:,:,229))
  call Hloop_SV_T(ntryL,G1H8(157),20,wf4(:,13),3,G2H2(305),m3h4x2(:,138),heltab2x8(:,:,230))
  call Hloop_SV_T(ntryL,G1H8(158),20,wf4(:,13),3,G2H2(306),m3h4x2(:,139),heltab2x8(:,:,231))
  call Hloop_SV_T(ntryL,G0H8(26),20,wf4(:,13),3,G1H2(83),m3h4x2(:,140),heltab2x8(:,:,232))
  call Hloop_TV_S(ntryL,G1H8(159),20,wf4(:,14),3,G2H2(307),m3h4x2(:,141),heltab2x8(:,:,233))
call HGT_OLR(G1H8(160),1,1,8)
call HGT_invQ_OLR(G1H8(160),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(160),-8,ex4(:),8,G2H4(92),m3h2x4(:,93),heltab2x8(:,:,234))
  call Hloop_TV_S(ntryL,G1H8(162),20,wf4(:,14),3,G2H2(308),m3h4x2(:,142),heltab2x8(:,:,235))
  call Hloop_TV_S(ntryL,G1H8(163),20,wf4(:,14),3,G2H2(309),m3h4x2(:,143),heltab2x8(:,:,236))
  call Hloop_TV_S(ntryL,G0H8(27),20,wf4(:,14),3,G1H2(46),m3h4x2(:,144),heltab2x8(:,:,237))
  call Hloop_SV_T(ntryL,G1H8(164),20,wf4(:,14),3,G2H2(310),m3h4x2(:,145),heltab2x8(:,:,238))
call HGT_OLR(G1H8(165),1,1,8)
call HGT_invQ_OLR(G1H8(165),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(165),-8,ex4(:),8,G2H4(91),m3h2x4(:,94),heltab2x8(:,:,239))
  call Hloop_SV_T(ntryL,G1H8(167),20,wf4(:,14),3,G2H2(311),m3h4x2(:,146),heltab2x8(:,:,240))
  call Hloop_SV_T(ntryL,G1H8(168),20,wf4(:,14),3,G2H2(312),m3h4x2(:,147),heltab2x8(:,:,241))
  call Hloop_SV_T(ntryL,G0H8(28),20,wf4(:,14),3,G1H2(118),m3h4x2(:,148),heltab2x8(:,:,242))
  call Hloop_CV_D(ntryL,G1H8(169),20,wf4(:,13),3,G2H2(313),m3h4x2(:,149),heltab2x8(:,:,243))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(170),-8,ex4(:),G2H4(24),m3h2x4(:,95),heltab2x8(:,:,244))
  call Hloop_CV_D(ntryL,G1H8(172),20,wf4(:,13),3,G2H2(314),m3h4x2(:,150),heltab2x8(:,:,245))
  call Hloop_CV_D(ntryL,G1H8(173),20,wf4(:,13),3,G2H2(315),m3h4x2(:,151),heltab2x8(:,:,246))
  call Hloop_CV_D(ntryL,G0H8(29),20,wf4(:,13),3,G1H2(199),m3h4x2(:,152),heltab2x8(:,:,247))
  call Hloop_DV_C(ntryL,G1H8(174),20,wf4(:,13),G2H2(316),m3h4x2(:,153),heltab2x8(:,:,248))
call HGT_OLR(G1H8(175),1,1,8)
call HGT_invQ_OLR(G1H8(175),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(175),-8,ex4(:),8,G2H4(95),m3h2x4(:,96),heltab2x8(:,:,249))
  call Hloop_DV_C(ntryL,G1H8(177),20,wf4(:,13),G2H2(317),m3h4x2(:,154),heltab2x8(:,:,250))
  call Hloop_DV_C(ntryL,G1H8(178),20,wf4(:,13),G2H2(318),m3h4x2(:,155),heltab2x8(:,:,251))
  call Hloop_DV_C(ntryL,G0H8(30),20,wf4(:,13),G1H2(200),m3h4x2(:,156),heltab2x8(:,:,252))
  call Hloop_CV_D(ntryL,G1H8(179),20,wf4(:,14),3,G2H2(319),m3h4x2(:,157),heltab2x8(:,:,253))
call HGT_OLR(G1H8(180),1,1,8)
call HGT_invQ_OLR(G1H8(180),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(180),-8,ex4(:),G2H4(29),m3h2x4(:,97),heltab2x8(:,:,254))
  call Hloop_CV_D(ntryL,G1H8(182),20,wf4(:,14),3,G2H2(320),m3h4x2(:,158),heltab2x8(:,:,255))
  call Hloop_CV_D(ntryL,G1H8(183),20,wf4(:,14),3,G2H2(321),m3h4x2(:,159),heltab2x8(:,:,256))
  call Hloop_CV_D(ntryL,G0H8(31),20,wf4(:,14),3,G1H2(201),m3h4x2(:,160),heltab2x8(:,:,257))
  call Hloop_DV_C(ntryL,G1H8(184),20,wf4(:,14),G2H2(322),m3h4x2(:,161),heltab2x8(:,:,258))
call HGT_OLR(G1H8(185),1,1,8)
call HGT_invQ_OLR(G1H8(185),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(185),-8,ex4(:),8,G2H4(96),m3h2x4(:,98),heltab2x8(:,:,259))
  call Hloop_DV_C(ntryL,G1H8(187),20,wf4(:,14),G2H2(323),m3h4x2(:,162),heltab2x8(:,:,260))
  call Hloop_DV_C(ntryL,G1H8(188),20,wf4(:,14),G2H2(324),m3h4x2(:,163),heltab2x8(:,:,261))
  call Hloop_DV_C(ntryL,G0H8(32),20,wf4(:,14),G1H2(202),m3h4x2(:,164),heltab2x8(:,:,262))
  call Hloop_UV_W(ntryL,G1H8(189),20,wf4(:,13),3,G2H2(325),m3h4x2(:,165),heltab2x8(:,:,263))
call HGT_raise_alpha_OLR(G1H8(190),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(190),-8,ex4(:),8,G2H4(73),m3h2x4(:,99),heltab2x8(:,:,264))
  call Hloop_UV_W(ntryL,G1H8(192),20,wf4(:,13),3,G2H2(326),m3h4x2(:,166),heltab2x8(:,:,265))
  call Hloop_UV_W(ntryL,G1H8(193),20,wf4(:,13),3,G2H2(327),m3h4x2(:,167),heltab2x8(:,:,266))
  call Hloop_UV_W(ntryL,G0H8(33),20,wf4(:,13),3,G1H2(203),m3h4x2(:,168),heltab2x8(:,:,267))
  call Hloop_UW_V(ntryL,G1H8(194),20,wf4(:,13),3,G2H2(328),m3h4x2(:,169),heltab2x8(:,:,268))
call HGT_raise_alpha_OLR(G1H8(195),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(195),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(195),-8,ex4(:),8,G2H4(86),m3h2x4(:,100),heltab2x8(:,:,269))
  call Hloop_UW_V(ntryL,G1H8(197),20,wf4(:,13),3,G2H2(329),m3h4x2(:,170),heltab2x8(:,:,270))
  call Hloop_UW_V(ntryL,G1H8(198),20,wf4(:,13),3,G2H2(330),m3h4x2(:,171),heltab2x8(:,:,271))
  call Hloop_UW_V(ntryL,G0H8(34),20,wf4(:,13),3,G1H2(204),m3h4x2(:,172),heltab2x8(:,:,272))
  call Hloop_UV_W(ntryL,G1H8(199),20,wf4(:,14),3,G2H2(331),m3h4x2(:,173),heltab2x8(:,:,273))
call HGT_raise_alpha_OLR(G1H8(200),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(200),-8,ex4(:),8,G2H4(7),m3h2x4(:,101),heltab2x8(:,:,274))
  call Hloop_UV_W(ntryL,G1H8(202),20,wf4(:,14),3,G2H2(332),m3h4x2(:,174),heltab2x8(:,:,275))
  call Hloop_UV_W(ntryL,G1H8(203),20,wf4(:,14),3,G2H2(333),m3h4x2(:,175),heltab2x8(:,:,276))
  call Hloop_UV_W(ntryL,G0H8(35),20,wf4(:,14),3,G1H2(205),m3h4x2(:,176),heltab2x8(:,:,277))
  call Hloop_UW_V(ntryL,G1H8(204),20,wf4(:,14),3,G2H2(334),m3h4x2(:,177),heltab2x8(:,:,278))
call HGT_raise_alpha_OLR(G1H8(205),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(205),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(205),-8,ex4(:),8,G2H4(41),m3h2x4(:,102),heltab2x8(:,:,279))
  call Hloop_UW_V(ntryL,G1H8(207),20,wf4(:,14),3,G2H2(335),m3h4x2(:,178),heltab2x8(:,:,280))
  call Hloop_UW_V(ntryL,G1H8(208),20,wf4(:,14),3,G2H2(336),m3h4x2(:,179),heltab2x8(:,:,281))
  call Hloop_UW_V(ntryL,G0H8(36),20,wf4(:,14),3,G1H2(206),m3h4x2(:,180),heltab2x8(:,:,282))
  call Hloop_WA_Q(ntryL,G1H8(25),ex2(:),G1H4(9),m3h2x4(:,103),heltab2x8(:,:,283))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(71),n2h4(133))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(26),wf4(:,9),G1H2(207),m3h4x2(:,181),heltab2x8(:,:,284))
  call Hloop_WA_Q(ntryL,G1H8(28),ex2(:),G1H4(10),m3h2x4(:,104),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(10),22,0,G2H4(85),n2h4(134))
  call Hloop_WA_Q(ntryL,G1H8(29),ex2(:),G1H4(19),m3h2x4(:,105),heltab2x8(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(19),22,0,G2H4(9),n2h4(135))
  call Hloop_WQ_A(ntryL,G1H8(30),ex1(:),G1H4(20),m3h2x4(:,106),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G1H4(20),21,0,G2H4(42),n2h4(136))
call HGT_raise_alpha_OLR(G1H8(31),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(31),wf4(:,4),G1H2(208),m3h4x2(:,182),heltab2x8(:,:,288))
  call Hloop_WQ_A(ntryL,G1H8(33),ex1(:),G1H4(35),m3h2x4(:,107),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(35),21,0,G2H4(13),n2h4(137))
  call Hloop_WQ_A(ntryL,G1H8(34),ex1(:),G1H4(36),m3h2x4(:,108),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G1H4(36),21,0,G2H4(14),n2h4(138))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(334),[G2H2(328),G2H2(12),G1H2(41),G1H2(35),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(331),[G2H2(325),G2H2(15),G1H2(40),G1H2(34),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(295),[G2H2(283),G2H2(268),G2H2(238),G2H2(23),G2H2(19) &
    ,G1H2(38),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(27),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(31),G1H2(60)])
call HGT_lower_alpha_OLR(G2H2(34),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(34),2,5,2)
call HGT_lower_alpha_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(35),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G2H2(277),G2H2(259),G2H2(229),G2H2(43),G2H2(39) &
    ,G1H2(93),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(80)])
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(47),G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(91)])
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(51),G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(14)])
call HGT_lower_alpha_OLR(G2H2(54),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(54),2,5,2)
call HGT_lower_alpha_OLR(G2H2(54),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(55),G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(59),G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(63),G1H2(148)])
call HGT_lower_alpha_OLR(G2H2(66),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(66),2,5,2)
call HGT_lower_alpha_OLR(G2H2(66),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(67),G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(25)])
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(71),G1H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(36)])
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G2H2(75),G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(2)])
call HGT_lower_alpha_OLR(G2H2(78),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(78),2,5,2)
call HGT_lower_alpha_OLR(G2H2(78),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(79),G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(336),[G2H2(330),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(333),[G2H2(327),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G2H2(285),G2H2(270),G2H2(240),G1H2(44),G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G1H2(59),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G1H2(65),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G1H2(19),G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(291),[G2H2(279),G2H2(261),G2H2(231),G1H2(99),G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G1H2(114),G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G1H2(120),G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G1H2(7),G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G1H2(147),G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G1H2(153),G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G1H2(18),G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G1H2(180),G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G1H2(186),G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(8),G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(169),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(40),G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(45),G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(52),G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(217),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(57),G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(77),G2H2(76),G2H2(73),G2H2(64),G2H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(81),G2H2(72),G2H2(69),G2H2(68),G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(307),[G2H2(301),G1H2(29),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(310),[G2H2(304),G1H2(30),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(177),[G1H2(106),G1H2(188),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(262),[G2H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(264),[G2H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(265),[G2H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(267),[G2H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(6),G1H2(133),G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(271),[G2H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(273),[G2H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(274),[G2H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(276),[G2H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(280),[G2H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(282),[G2H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G2H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(288),[G2H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(292),[G2H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(294),[G2H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(298),[G2H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(300),[G2H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(144),[G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(309),[G2H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(312),[G2H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(319),[G2H2(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(321),[G2H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(322),[G2H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(324),[G2H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(202),[G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(206),[G1H2(204)])
  call Hotf_4pt_reduction(G2H2(334),RedSet_4(7),mass4set(:,6),  & 
G1H2(41),G1H2(35),G1H2(4),G1H2(40),G1H2(34),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hotf_4pt_reduction(G2H2(331),RedSet_4(7),mass4set(:,6),  & 
G1H2(16),G1H2(38),G1H2(27),G1H2(49),G1H2(60),2)
  call HG1shiftOLR(G1H2(38),8,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(26),mass4set(:,2),  & 
G1H2(182),G1H2(71),G1H2(93),G1H2(82),G1H2(80),2)
  call HG1shiftOLR(G1H2(71),2,2)
  call Hotf_4pt_reduction(G2H2(295),RedSet_4(7),mass4set(:,2),  & 
G1H2(104),G1H2(91),G1H2(115),G1H2(14),G1H2(126),2)
  call HG1shiftOLR(G1H2(91),8,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(26),mass4set(:,3),  & 
G1H2(137),G1H2(148),G1H2(193),G1H2(159),G1H2(25),2)
  call HG1shiftOLR(G1H2(148),2,2)
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(28),mass4set(:,2),  & 
G1H2(170),G1H2(36),G1H2(181),G1H2(2),G1H2(192),2)
  call HG1shiftOLR(G1H2(36),4,2)
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(11),mass4set(:,2),  & 
G1H2(3),G1H2(11),G1H2(15),G1H2(22),G1H2(26),2)
  call HG1shiftOLR(G1H2(11),8,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(28),mass4set(:,4),  & 
G1H2(44),G1H2(33),G1H2(37),G1H2(47),G1H2(59),2)
  call HG1shiftOLR(G1H2(33),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(11),mass4set(:,4),  & 
G1H2(48),G1H2(65),G1H2(54),G1H2(58),G1H2(69),2)
  call HG1shiftOLR(G1H2(65),8,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(28),mass4set(:,5),  & 
G1H2(19),G1H2(70),G1H2(76),G1H2(81),G1H2(99),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(11),mass4set(:,5),  & 
G1H2(88),G1H2(92),G1H2(102),G1H2(114),G1H2(103),2)
  call HG1shiftOLR(G1H2(92),8,2)
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(27),mass4set(:,2),  & 
G1H2(120),G1H2(109),G1H2(113),G1H2(124),G1H2(7),2)
  call HG1shiftOLR(G1H2(109),1,2)
  call Hotf_4pt_reduction(G2H2(289),RedSet_4(7),mass4set(:,2),  & 
G1H2(125),G1H2(131),G1H2(135),G1H2(147),G1H2(136),2)
  call HG1shiftOLR(G1H2(131),8,2)
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(27),mass4set(:,3),  & 
G1H2(153),G1H2(142),G1H2(146),G1H2(157),G1H2(18),2)
  call HG1shiftOLR(G1H2(142),1,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(13),mass4set(:,2),  & 
G1H2(158),G1H2(164),G1H2(168),G1H2(180),G1H2(169),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(18),mass4set(:,2),  & 
G1H2(186),G1H2(175),G1H2(179),G1H2(190),G1H2(8),2)
  call HG1shiftOLR(G1H2(175),4,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(13),mass4set(:,4),  & 
G1H2(191),G1H2(197),G1H2(5),G1H2(1),G1H2(12),2)
  call HG1shiftOLR(G1H2(197),8,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(18),mass4set(:,4),  & 
G1H2(13),G1H2(29),G1H2(23),G1H2(30),G1H2(24),2)
  call HG1shiftOLR(G1H2(29),4,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(13),mass4set(:,5),  & 
G1H2(106),G1H2(188),G1H2(67),G1H2(117),G1H2(134),2)
  call HG1shiftOLR(G1H2(188),8,2)
  call Hotf_4pt_reduction(G2H2(91),RedSet_4(18),mass4set(:,5),  & 
G1H2(6),G1H2(133),G1H2(161),G1H2(184),G1H2(28),2)
  call HG1shiftOLR(G1H2(133),4,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(29),mass4set(:,2),  & 
G1H2(94),G1H2(101),G1H2(122),G1H2(156),G1H2(172),2)
  call HG1shiftOLR(G1H2(101),4,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(21),mass4set(:,2),  & 
G1H2(83),G1H2(199),G1H2(200),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(199),8,2)
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(29),mass4set(:,4),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),2)
  call HG1shiftOLR(G1H2(210),4,2)
  call Hotf_4pt_reduction(G2H2(87),RedSet_4(21),mass4set(:,4),  & 
G1H2(214),G1H2(215),G1H2(216),G1H2(217),G1H2(218),2)
  call HG1shiftOLR(G1H2(215),8,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(29),mass4set(:,5),  & 
G1H2(219),G1H2(220),G1H2(221),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(220),4,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(21),mass4set(:,5),  & 
G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(225),8,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(5),mass4set(:,2),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(230),8,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(24),mass4set(:,2),  & 
G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(235),4,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(5),mass4set(:,4),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),2)
  call HG1shiftOLR(G1H2(240),8,2)
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(24),mass4set(:,4),  & 
G1H2(244),G1H2(245),G1H2(246),G1H2(247),G1H2(248),2)
  call HG1shiftOLR(G1H2(245),4,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(5),mass4set(:,5),  & 
G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),2)
  call HG1shiftOLR(G1H2(250),8,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(24),mass4set(:,5),  & 
G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(255),4,2)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(6),mass4set(:,5),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(260),8,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(9),23,ex4(:),8,G2tensor(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(10),23,ex4(:),8,G2tensor(4),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(336),23,ex4(:),8,G3tensor(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(14),mass4set(:,5),  & 
G1H2(9),G1H2(10),G1H2(264),G1H2(265),G1H2(266),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),23,ex4(:),8,G2tensor(3),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(21),23,ex4(:),8,G2tensor(2),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(333),23,ex4(:),8,G3tensor(2),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(6),mass4set(:,2),  & 
G1H2(20),G1H2(21),G1H2(267),G1H2(268),G1H2(269),2)
  call HG1shiftOLR(G1H2(21),8,2)
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(62))
  call Hloop_AV_Q(ntryL,G2H2(297),ex4(:),G2H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(63))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(6),mass4set(:,4),  & 
G1H2(31),G1H2(32),G1H2(270),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(65))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(9),mass4set(:,2),  & 
G1H2(42),G1H2(43),G1H2(273),G1H2(274),G1H2(275),2)
  call HG1shiftOLR(G1H2(43),8,2)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(10),mass4set(:,2),  & 
G1H2(276),G1H2(277),G1H2(278),G1H2(279),G1H2(280),2)
  call HG1shiftOLR(G1H2(277),8,2)
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(66))
  call Hloop_QV_A(ntryL,G2H2(104),ex4(:),G2H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(4),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(68))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(9),mass4set(:,11),  & 
G1H2(53),G1H2(55),G1H2(281),G1H2(282),G1H2(283),2)
  call HG1shiftOLR(G1H2(55),8,2)
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(70))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(9),mass4set(:,12),  & 
G1H2(64),G1H2(66),G1H2(284),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(66),8,2)
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(10),mass4set(:,6),  & 
G1H2(287),G1H2(288),G1H2(289),G1H2(290),G1H2(291),2)
  call HG1shiftOLR(G1H2(288),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(75),23,ex4(:),8,G2tensor(13),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(108),23,ex4(:),8,G3tensor(5),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(77),23,ex4(:),8,G2tensor(12),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(14),mass4set(:,2),  & 
G1H2(75),G1H2(77),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(72))
  call Hloop_QV_A(ntryL,G2H2(291),ex4(:),G2H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(73))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(14),mass4set(:,4),  & 
G1H2(86),G1H2(87),G1H2(295),G1H2(296),G1H2(297),2)
  call HG1shiftOLR(G1H2(87),8,2)
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(75))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(16),mass4set(:,2),  & 
G1H2(97),G1H2(98),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_4pt_reduction(G2H2(109),RedSet_4(17),mass4set(:,2),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),2)
  call HG1shiftOLR(G1H2(302),4,2)
  call Hloop_QV_A(ntryL,G1H2(108),ex3(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(76))
  call Hloop_QV_A(ntryL,G2H2(112),ex3(:),G2H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(77))
  call Hloop_QV_A(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(78))
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(16),mass4set(:,11),  & 
G1H2(108),G1H2(110),G1H2(306),G1H2(307),G1H2(308),2)
  call HG1shiftOLR(G1H2(110),4,2)
  call Hloop_QV_A(ntryL,G1H2(119),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(121),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(80))
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(16),mass4set(:,12),  & 
G1H2(119),G1H2(121),G1H2(309),G1H2(310),G1H2(311),2)
  call HG1shiftOLR(G1H2(121),4,2)
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(17),mass4set(:,6),  & 
G1H2(312),G1H2(313),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(313),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(130),27,ex3(:),4,G2tensor(31),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(116),27,ex3(:),4,G3tensor(8),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(132),27,ex3(:),4,G2tensor(35),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(20),mass4set(:,2),  & 
G1H2(130),G1H2(132),G1H2(317),G1H2(318),G1H2(319),2)
  call HG1shiftOLR(G1H2(132),8,2)
  call Hotf_4pt_reduction(G2H2(117),RedSet_4(10),mass4set(:,2),  & 
G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(321),8,2)
  call Hloop_AV_Q(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(81))
  call Hloop_AV_Q(ntryL,G2H2(120),ex4(:),G2H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(9),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(143),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(83))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(20),mass4set(:,11),  & 
G1H2(141),G1H2(143),G1H2(325),G1H2(326),G1H2(327),2)
  call HG1shiftOLR(G1H2(143),8,2)
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(85))
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(20),mass4set(:,12),  & 
G1H2(152),G1H2(154),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(154),8,2)
  call Hotf_4pt_reduction(G2H2(121),RedSet_4(10),mass4set(:,6),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),2)
  call HG1shiftOLR(G1H2(332),8,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(163),23,ex4(:),8,G2tensor(63),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(124),23,ex4(:),8,G3tensor(10),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(165),23,ex4(:),8,G2tensor(67),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(23),mass4set(:,2),  & 
G1H2(163),G1H2(165),G1H2(336),G1H2(337),G1H2(338),2)
  call HG1shiftOLR(G1H2(165),4,2)
  call Hotf_4pt_reduction(G2H2(125),RedSet_4(17),mass4set(:,2),  & 
G1H2(339),G1H2(340),G1H2(341),G1H2(342),G1H2(343),2)
  call HG1shiftOLR(G1H2(340),4,2)
  call Hloop_AV_Q(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(86))
  call Hloop_AV_Q(ntryL,G2H2(128),ex3(:),G2H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(11),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(88))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(23),mass4set(:,11),  & 
G1H2(174),G1H2(176),G1H2(344),G1H2(345),G1H2(346),2)
  call HG1shiftOLR(G1H2(176),4,2)
  call Hloop_AV_Q(ntryL,G1H2(185),ex3(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(90))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(23),mass4set(:,12),  & 
G1H2(185),G1H2(187),G1H2(347),G1H2(348),G1H2(349),2)
  call HG1shiftOLR(G1H2(187),4,2)
  call Hotf_4pt_reduction(G2H2(129),RedSet_4(17),mass4set(:,6),  & 
G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(351),4,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(196),27,ex3(:),4,G2tensor(89),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(132),27,ex3(:),4,G3tensor(12),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(198),27,ex3(:),4,G2tensor(90),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(25),ex4(:),ex3(:),G2tensor(91),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(30),ex4(:),ex3(:),G2tensor(92),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hotf_4pt_reduction(G2H2(165),RedSet_4(17),mass4set(:,6),  & 
G1H2(196),G1H2(198),G1H2(355),G1H2(356),G1H2(357),2)
  call HG1shiftOLR(G1H2(198),4,2)
  call Hotf_4pt_reduction(G2H2(169),RedSet_4(17),mass4set(:,6),  & 
G1H2(358),G1H2(359),G1H2(360),G1H2(361),G1H2(362),2)
  call HG1shiftOLR(G1H2(359),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(44),ex3(:),G2tensor(93),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(94),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(56),ex4(:),G2tensor(95),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hotf_4pt_reduction(G2H2(213),RedSet_4(10),mass4set(:,6),  & 
G1H2(363),G1H2(364),G1H2(365),G1H2(366),G1H2(367),2)
  call HG1shiftOLR(G1H2(364),8,2)
  call Hotf_4pt_reduction(G2H2(217),RedSet_4(10),mass4set(:,6),  & 
G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(369),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(96),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(80),ex4(:),G2tensor(97),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(82),ex4(:),G2tensor(98),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hotf_4pt_reduction(G2H2(307),RedSet_4(7),mass4set(:,6),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(374),8,2)
  call Hotf_4pt_reduction(G2H2(310),RedSet_4(7),mass4set(:,6),  & 
G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),2)
  call HG1shiftOLR(G1H2(379),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(45),ex4(:),G1tensor(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(52),ex4(:),G1tensor(7),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(56),ex4(:),G1tensor(13),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(63),ex4(:),G1tensor(19),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(2),mass4set(:,2),  & 
G1H4(97),G1H4(98),G1H4(101),G1H4(104),G1H4(107),4)
  call HG1shiftOLR(G1H4(98),9,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(2),mass4set(:,3),  & 
G1H4(111),G1H4(115),G1H4(119),G1H4(12),G1H4(18),4)
  call HG1shiftOLR(G1H4(115),9,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(73),ex3(:),G1tensor(25),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(1),mass4set(:,2),  & 
G1H4(30),G1H4(24),G1H4(29),G1H4(33),G1H4(40),4)
  call HG1shiftOLR(G1H4(24),10,4)
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(1),mass4set(:,3),  & 
G1H4(46),G1H4(51),G1H4(58),G1H4(57),G1H4(61),4)
  call HG1shiftOLR(G1H4(51),10,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(79),ex3(:),G1tensor(31),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(84),ex4(:),G1tensor(37),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(85),ex3(:),G1tensor(43),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(89),ex4(:),G1tensor(49),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(90),ex3(:),G1tensor(55),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(95),ex2(:),G2tensor(99),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(97),ex2(:),G2tensor(100),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(98),ex1(:),G2tensor(101),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(100),ex1(:),G2tensor(102),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hloop_QV_A(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(91))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(128),23,ex4(:),8,G2tensor(104),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hloop_QV_A(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(92))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(140),27,ex3(:),4,G2tensor(106),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(93))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(155),23,ex4(:),8,G2tensor(108),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hloop_AV_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(94))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(167),27,ex3(:),4,G2tensor(110),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(17),mass4set(:,7),  & 
G1H2(45),G1H2(52),G1H2(56),G1H2(63),G1H2(73),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hloop_QV_A(ntryL,G2H2(136),ex3(:),G2H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(13),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(111),n2h1(96))
  call Hotf_4pt_reduction(G2H2(137),RedSet_4(17),mass4set(:,8),  & 
G1H2(79),G1H2(84),G1H2(85),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(84),4,2)
  call Hloop_QV_A(ntryL,G2H2(140),ex3(:),G2H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(14),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(112),n2h1(98))
  call Hotf_4pt_reduction(G2H2(141),RedSet_4(17),mass4set(:,7),  & 
G1H2(123),G1H2(128),G1H2(139),G1H2(140),G1H2(151),2)
  call HG1shiftOLR(G1H2(128),4,2)
  call Hloop_AV_Q(ntryL,G2H2(144),ex3(:),G2H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(15),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(113),n2h1(100))
  call Hotf_4pt_reduction(G2H2(145),RedSet_4(17),mass4set(:,8),  & 
G1H2(155),G1H2(166),G1H2(167),G1H2(178),G1H2(189),2)
  call HG1shiftOLR(G1H2(166),4,2)
  call Hloop_AV_Q(ntryL,G2H2(148),ex3(:),G2H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(16),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(114),n2h1(102))
  call Hotf_4pt_reduction(G2H2(149),RedSet_4(17),mass4set(:,9),  & 
G1H2(17),G1H2(61),G1H2(383),G1H2(384),G1H2(385),2)
  call HG1shiftOLR(G1H2(61),4,2)
  call Hloop_QV_A(ntryL,G2H2(152),ex3(:),G2H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(17),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(115),n2h1(104))
  call Hotf_4pt_reduction(G2H2(153),RedSet_4(17),mass4set(:,9),  & 
G1H2(105),G1H2(386),G1H2(387),G1H2(388),G1H2(389),2)
  call HG1shiftOLR(G1H2(386),4,2)
  call Hloop_AV_Q(ntryL,G2H2(156),ex3(:),G2H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(18),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(116),n2h1(106))
  call Hotf_4pt_reduction(G2H2(157),RedSet_4(17),mass4set(:,10),  & 
G1H2(149),G1H2(390),G1H2(391),G1H2(392),G1H2(393),2)
  call HG1shiftOLR(G1H2(390),4,2)
  call Hloop_QV_A(ntryL,G2H2(160),ex3(:),G2H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(19),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(117),n2h1(108))
  call Hotf_4pt_reduction(G2H2(161),RedSet_4(17),mass4set(:,10),  & 
G1H2(51),G1H2(394),G1H2(395),G1H2(396),G1H2(397),2)
  call HG1shiftOLR(G1H2(394),4,2)
  call Hloop_AV_Q(ntryL,G2H2(164),ex3(:),G2H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(20),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(118),n2h1(110))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(168),27,ex3(:),4,G3tensor(21),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(74),27,ex3(:),4,G2tensor(119),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(172),27,ex3(:),4,G3tensor(22),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(78),27,ex3(:),4,G2tensor(120),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hotf_4pt_reduction(G2H2(173),RedSet_4(17),mass4set(:,6),  & 
G1H2(68),G1H2(74),G1H2(78),G1H2(398),G1H2(399),2)
  call HG1shiftOLR(G1H2(74),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(176),27,ex3(:),4,G3tensor(23),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(95),27,ex3(:),4,G2tensor(121),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hotf_4pt_reduction(G2H2(177),RedSet_4(17),mass4set(:,6),  & 
G1H2(95),G1H2(400),G1H2(401),G1H2(402),G1H2(403),2)
  call HG1shiftOLR(G1H2(400),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(180),27,ex3(:),G3tensor(24),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(100),27,ex3(:),G2tensor(122),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hotf_4pt_reduction(G2H2(181),RedSet_4(10),mass4set(:,7),  & 
G1H2(100),G1H2(404),G1H2(405),G1H2(406),G1H2(407),2)
  call HG1shiftOLR(G1H2(404),8,2)
  call Hloop_AV_Q(ntryL,G2H2(184),ex4(:),G2H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(25),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(123),n2h1(112))
  call Hotf_4pt_reduction(G2H2(185),RedSet_4(10),mass4set(:,8),  & 
G1H2(112),G1H2(408),G1H2(409),G1H2(410),G1H2(411),2)
  call HG1shiftOLR(G1H2(408),8,2)
  call Hloop_AV_Q(ntryL,G2H2(188),ex4(:),G2H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(26),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(124),n2h1(114))
  call Hotf_4pt_reduction(G2H2(189),RedSet_4(10),mass4set(:,7),  & 
G1H2(129),G1H2(412),G1H2(413),G1H2(414),G1H2(415),2)
  call HG1shiftOLR(G1H2(412),8,2)
  call Hloop_QV_A(ntryL,G2H2(192),ex4(:),G2H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(27),n2h1(115))
  call Hloop_QV_A(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(125),n2h1(116))
  call Hotf_4pt_reduction(G2H2(193),RedSet_4(10),mass4set(:,8),  & 
G1H2(145),G1H2(416),G1H2(417),G1H2(418),G1H2(419),2)
  call HG1shiftOLR(G1H2(416),8,2)
  call Hloop_QV_A(ntryL,G2H2(196),ex4(:),G2H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(28),n2h1(117))
  call Hloop_QV_A(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(126),n2h1(118))
  call Hotf_4pt_reduction(G2H2(197),RedSet_4(10),mass4set(:,9),  & 
G1H2(162),G1H2(420),G1H2(421),G1H2(422),G1H2(423),2)
  call HG1shiftOLR(G1H2(420),8,2)
  call Hloop_AV_Q(ntryL,G2H2(200),ex4(:),G2H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(29),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(183),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(127),n2h1(120))
  call Hotf_4pt_reduction(G2H2(201),RedSet_4(10),mass4set(:,9),  & 
G1H2(183),G1H2(424),G1H2(425),G1H2(426),G1H2(427),2)
  call HG1shiftOLR(G1H2(424),8,2)
  call Hloop_QV_A(ntryL,G2H2(204),ex4(:),G2H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(30),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(128),n2h1(122))
  call Hotf_4pt_reduction(G2H2(205),RedSet_4(10),mass4set(:,10),  & 
G1H2(195),G1H2(428),G1H2(429),G1H2(430),G1H2(431),2)
  call HG1shiftOLR(G1H2(428),8,2)
  call Hloop_AV_Q(ntryL,G2H2(208),ex4(:),G2H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(31),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(129),n2h1(124))
  call Hotf_4pt_reduction(G2H2(209),RedSet_4(10),mass4set(:,10),  & 
G1H2(50),G1H2(432),G1H2(433),G1H2(434),G1H2(435),2)
  call HG1shiftOLR(G1H2(432),8,2)
  call Hloop_QV_A(ntryL,G2H2(212),ex4(:),G2H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(32),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(130),n2h1(126))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(216),23,ex4(:),8,G3tensor(33),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(127),23,ex4(:),8,G2tensor(131),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(220),23,ex4(:),8,G3tensor(34),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(138),23,ex4(:),8,G2tensor(132),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hotf_4pt_reduction(G2H2(221),RedSet_4(10),mass4set(:,6),  & 
G1H2(116),G1H2(127),G1H2(138),G1H2(436),G1H2(437),2)
  call HG1shiftOLR(G1H2(127),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(224),23,ex4(:),G3tensor(35),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(160),23,ex4(:),G2tensor(133),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hotf_4pt_reduction(G2H2(225),RedSet_4(10),mass4set(:,6),  & 
G1H2(160),G1H2(438),G1H2(439),G1H2(440),G1H2(441),2)
  call HG1shiftOLR(G1H2(438),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(228),23,ex4(:),8,G3tensor(36),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(171),23,ex4(:),8,G2tensor(134),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hloop_QV_A(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(127))
  call Hotf_4pt_reduction(G2H2(262),RedSet_4(7),mass4set(:,7),  & 
G1H2(171),G1H2(177),G1H2(442),G1H2(443),G1H2(444),2)
  call HG1shiftOLR(G1H2(177),8,2)
  call Hloop_QV_A(ntryL,G2H2(264),ex4(:),G2H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(37),n2h1(128))
  call Hloop_QV_A(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(136),n2h1(129))
  call Hotf_4pt_reduction(G2H2(265),RedSet_4(7),mass4set(:,8),  & 
G1H2(72),G1H2(445),G1H2(446),G1H2(447),G1H2(448),2)
  call HG1shiftOLR(G1H2(445),8,2)
  call Hloop_QV_A(ntryL,G2H2(267),ex4(:),G2H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(38),n2h1(130))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(137),n2h1(131))
  call Hloop_AV_Q(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(132))
  call Hotf_4pt_reduction(G2H2(271),RedSet_4(7),mass4set(:,7),  & 
G1H2(62),G1H2(194),G1H2(449),G1H2(450),G1H2(451),2)
  call HG1shiftOLR(G1H2(194),8,2)
  call Hloop_AV_Q(ntryL,G2H2(273),ex4(:),G2H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(39),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(139),n2h1(134))
  call Hotf_4pt_reduction(G2H2(274),RedSet_4(7),mass4set(:,8),  & 
G1H2(173),G1H2(452),G1H2(453),G1H2(454),G1H2(455),2)
  call HG1shiftOLR(G1H2(452),8,2)
  call Hloop_AV_Q(ntryL,G2H2(276),ex4(:),G2H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(40),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(140),n2h1(136))
  call Hotf_4pt_reduction(G2H2(280),RedSet_4(7),mass4set(:,9),  & 
G1H2(39),G1H2(456),G1H2(457),G1H2(458),G1H2(459),2)
  call HG1shiftOLR(G1H2(456),8,2)
  call Hloop_QV_A(ntryL,G2H2(282),ex4(:),G2H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(41),n2h1(137))
  call Hloop_QV_A(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(141),n2h1(138))
  call Hotf_4pt_reduction(G2H2(286),RedSet_4(7),mass4set(:,9),  & 
G1H2(150),G1H2(460),G1H2(461),G1H2(462),G1H2(463),2)
  call HG1shiftOLR(G1H2(460),8,2)
  call Hloop_AV_Q(ntryL,G2H2(288),ex4(:),G2H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(42),n2h1(139))
  call Hloop_AV_Q(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(142),n2h1(140))
  call Hotf_4pt_reduction(G2H2(292),RedSet_4(7),mass4set(:,10),  & 
G1H2(111),G1H2(464),G1H2(465),G1H2(466),G1H2(467),2)
  call HG1shiftOLR(G1H2(464),8,2)
  call Hloop_QV_A(ntryL,G2H2(294),ex4(:),G2H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(43),n2h1(141))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(142))
  call Hotf_4pt_reduction(G2H2(298),RedSet_4(7),mass4set(:,10),  & 
G1H2(57),G1H2(468),G1H2(469),G1H2(470),G1H2(471),2)
  call HG1shiftOLR(G1H2(468),8,2)
  call Hloop_AV_Q(ntryL,G2H2(300),ex4(:),G2H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(44),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(144),n2h1(144))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(309),23,ex4(:),8,G3tensor(45),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(46),23,ex4(:),8,G2tensor(145),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(312),23,ex4(:),8,G3tensor(46),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(118),23,ex4(:),8,G2tensor(146),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hotf_4pt_reduction(G2H2(319),RedSet_4(7),mass4set(:,6),  & 
G1H2(144),G1H2(46),G1H2(118),G1H2(472),G1H2(473),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(321),23,ex4(:),8,G3tensor(47),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(201),23,ex4(:),8,G2tensor(147),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hotf_4pt_reduction(G2H2(322),RedSet_4(7),mass4set(:,6),  & 
G1H2(201),G1H2(474),G1H2(475),G1H2(476),G1H2(477),2)
  call HG1shiftOLR(G1H2(474),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(324),23,ex4(:),G3tensor(48),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(202),23,ex4(:),G2tensor(148),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(205),23,ex4(:),8,G2tensor(149),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(206),23,ex4(:),8,G2tensor(150),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(71),wf4(:,9),G2tensor(151),m3h4x1(:,1),heltab2x4(:,:,305))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(9),wf4(:,9),G2tensor(152),m3h4x1(:,2),heltab2x4(:,:,306))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(42),wf4(:,4),G2tensor(153),m3h4x1(:,3),heltab2x4(:,:,307))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(14),wf4(:,4),G2tensor(154),m3h4x1(:,4),heltab2x4(:,:,308))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(41),23,ex4(:),8,G2tensor(155),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(35),0,ex4(:),8,G2tensor(156),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(34),23,ex4(:),8,G2tensor(157),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(16),23,ex4(:),8,G2tensor(158),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),0,ex4(:),8,G2tensor(159),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(60),23,ex4(:),8,G2tensor(160),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hloop_VA_Q(ntryL,G1H2(182),ex2(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(161),n2h1(147))
  call Hloop_VA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(162),n2h1(148))
  call Hloop_VA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(163),n2h1(149))
  call Hloop_AV_Q(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(164),n2h1(150))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(165),n2h1(151))
  call Hloop_AV_Q(ntryL,G1H2(126),ex4(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(166),n2h1(152))
  call Hloop_ZA_Q(ntryL,G1H2(137),ex2(:),G1H1(1),ngZl,m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(167),n2h1(153))
  call Hloop_ZA_Q(ntryL,G1H2(148),ex2(:),G1H1(1),ngZl,m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(168),n2h1(154))
  call Hloop_ZA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),ngZl,m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(169),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(170),ex3(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(170),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(171),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(172),n2h1(158))
  call Hloop_QV_A(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(174),n2h1(160))
  call Hloop_QV_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(175),n2h1(161))
  call Hloop_QV_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(176),n2h1(162))
  call Hloop_QV_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(177),n2h1(163))
  call Hloop_QV_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(178),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(179),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(180),n2h1(166))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(181),n2h1(167))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),27,ex3(:),4,G2tensor(182),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(70),0,ex3(:),4,G2tensor(183),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(99),27,ex3(:),4,G2tensor(184),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(88),23,ex4(:),8,G2tensor(185),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(92),0,ex4(:),8,G2tensor(186),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(103),23,ex4(:),8,G2tensor(187),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hloop_VQ_A(ntryL,G1H2(120),ex1(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(188),n2h1(170))
  call Hloop_VQ_A(ntryL,G1H2(109),ex1(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(189),n2h1(171))
  call Hloop_VQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(190),n2h1(172))
  call Hloop_QV_A(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(173))
  call Hloop_QV_A(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(192),n2h1(174))
  call Hloop_QV_A(ntryL,G1H2(136),ex4(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(193),n2h1(175))
  call Hloop_ZQ_A(ntryL,G1H2(153),ex1(:),G1H1(1),ngZl,m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(194),n2h1(176))
  call Hloop_ZQ_A(ntryL,G1H2(142),ex1(:),G1H1(1),ngZl,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(195),n2h1(177))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex1(:),G1H1(1),ngZl,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(196),n2h1(178))
  call Hloop_QV_A(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(179))
  call Hloop_QV_A(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(198),n2h1(180))
  call Hloop_QV_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(199),n2h1(181))
  call Hloop_QV_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(200),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(201),n2h1(183))
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(202),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(191),ex4(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(203),n2h1(185))
  call Hloop_QV_A(ntryL,G1H2(197),ex4(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(204),n2h1(186))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(205),n2h1(187))
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(206),n2h1(188))
  call Hloop_QV_A(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(207),n2h1(189))
  call Hloop_QV_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(208),n2h1(190))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(106),23,ex4(:),8,G2tensor(209),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(188),0,ex4(:),8,G2tensor(210),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(134),23,ex4(:),8,G2tensor(211),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(6),27,ex3(:),4,G2tensor(212),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(133),0,ex3(:),4,G2tensor(213),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),27,ex3(:),4,G2tensor(214),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hloop_AV_Q(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(215),n2h1(193))
  call Hloop_AV_Q(ntryL,G1H2(101),ex3(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(216),n2h1(194))
  call Hloop_AV_Q(ntryL,G1H2(172),ex3(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(217),n2h1(195))
  call Hloop_AV_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(218),n2h1(196))
  call Hloop_AV_Q(ntryL,G1H2(199),ex4(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(219),n2h1(197))
  call Hloop_AV_Q(ntryL,G1H2(204),ex4(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(220),n2h1(198))
  call Hloop_AV_Q(ntryL,G1H2(209),ex3(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(221),n2h1(199))
  call Hloop_AV_Q(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(222),n2h1(200))
  call Hloop_AV_Q(ntryL,G1H2(213),ex3(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(223),n2h1(201))
  call Hloop_AV_Q(ntryL,G1H2(214),ex4(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(224),n2h1(202))
  call Hloop_AV_Q(ntryL,G1H2(215),ex4(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(225),n2h1(203))
  call Hloop_AV_Q(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(226),n2h1(204))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(219),27,ex3(:),4,G2tensor(227),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(220),0,ex3(:),4,G2tensor(228),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(223),27,ex3(:),4,G2tensor(229),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(224),23,ex4(:),8,G2tensor(230),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(225),0,ex4(:),8,G2tensor(231),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(228),23,ex4(:),8,G2tensor(232),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hloop_AV_Q(ntryL,G1H2(229),ex4(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(233),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H2(230),ex4(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(234),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(235),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(234),ex3(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(236),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(235),ex3(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(237),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(238),ex3(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(238),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(239),ex4(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(239),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H2(240),ex4(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(240),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(243),ex4(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(241),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H2(244),ex3(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(242),n2h1(216))
  call Hloop_AV_Q(ntryL,G1H2(245),ex3(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(243),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(248),ex3(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(244),n2h1(218))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(249),23,ex4(:),8,G2tensor(245),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(250),0,ex4(:),8,G2tensor(246),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(253),23,ex4(:),8,G2tensor(247),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(254),27,ex3(:),4,G2tensor(248),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(255),0,ex3(:),4,G2tensor(249),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(258),27,ex3(:),4,G2tensor(250),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(259),23,ex4(:),8,G2tensor(251),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(260),0,ex4(:),8,G2tensor(252),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(263),23,ex4(:),8,G2tensor(253),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(9),23,ex4(:),8,G2tensor(254),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),0,ex4(:),8,G2tensor(255),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(266),23,ex4(:),8,G2tensor(256),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hloop_AV_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(257),n2h1(223))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(258),n2h1(224))
  call Hloop_AV_Q(ntryL,G1H2(269),ex4(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(259),n2h1(225))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(260),n2h1(226))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(261),n2h1(227))
  call Hloop_AV_Q(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(262),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(263),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(264),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(275),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(265),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(276),ex4(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(266),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(277),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(267),n2h1(233))
  call Hloop_QV_A(ntryL,G1H2(280),ex4(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(268),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(269),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(270),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(283),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(271),n2h1(237))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(64),23,ex4(:),8,G2tensor(272),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(66),0,ex4(:),8,G2tensor(273),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(286),23,ex4(:),8,G2tensor(274),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(287),23,ex4(:),8,G2tensor(275),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(288),0,ex4(:),8,G2tensor(276),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(291),23,ex4(:),8,G2tensor(277),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(278),n2h1(240))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(279),n2h1(241))
  call Hloop_QV_A(ntryL,G1H2(294),ex4(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(280),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(281),n2h1(243))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(282),n2h1(244))
  call Hloop_QV_A(ntryL,G1H2(297),ex4(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(283),n2h1(245))
  call Hloop_QV_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(284),n2h1(246))
  call Hloop_QV_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(285),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(300),ex3(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(286),n2h1(248))
  call Hloop_QV_A(ntryL,G1H2(301),ex3(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(287),n2h1(249))
  call Hloop_QV_A(ntryL,G1H2(302),ex3(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(288),n2h1(250))
  call Hloop_QV_A(ntryL,G1H2(305),ex3(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(289),n2h1(251))
  call Hloop_QV_A(ntryL,G1H2(108),ex3(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(290),n2h1(252))
  call Hloop_QV_A(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(291),n2h1(253))
  call Hloop_QV_A(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(292),n2h1(254))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(119),27,ex3(:),4,G2tensor(293),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(121),0,ex3(:),4,G2tensor(294),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(311),27,ex3(:),4,G2tensor(295),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(312),27,ex3(:),4,G2tensor(296),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(313),0,ex3(:),4,G2tensor(297),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(316),27,ex3(:),4,G2tensor(298),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hloop_AV_Q(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(299),n2h1(257))
  call Hloop_AV_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(300),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H2(319),ex4(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(301),n2h1(259))
  call Hloop_AV_Q(ntryL,G1H2(320),ex4(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(302),n2h1(260))
  call Hloop_AV_Q(ntryL,G1H2(321),ex4(:),G1H1(1),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(303),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H2(324),ex4(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(304),n2h1(262))
  call Hloop_AV_Q(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(305),n2h1(263))
  call Hloop_AV_Q(ntryL,G1H2(143),ex4(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(306),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(327),ex4(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(307),n2h1(265))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(152),23,ex4(:),8,G2tensor(308),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(154),0,ex4(:),8,G2tensor(309),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(330),23,ex4(:),8,G2tensor(310),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(331),23,ex4(:),8,G2tensor(311),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(332),0,ex4(:),8,G2tensor(312),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(335),23,ex4(:),8,G2tensor(313),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hloop_AV_Q(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(314),n2h1(268))
  call Hloop_AV_Q(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(315),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H2(338),ex3(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(316),n2h1(270))
  call Hloop_AV_Q(ntryL,G1H2(339),ex3(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(317),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H2(340),ex3(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(318),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(343),ex3(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(319),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(320),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(321),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(346),ex3(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(322),n2h1(276))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(185),27,ex3(:),4,G2tensor(323),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(187),0,ex3(:),4,G2tensor(324),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(349),27,ex3(:),4,G2tensor(325),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(350),27,ex3(:),4,G2tensor(326),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(351),0,ex3(:),4,G2tensor(327),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(354),27,ex3(:),4,G2tensor(328),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(196),27,ex3(:),4,G2tensor(329),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(198),0,ex3(:),4,G2tensor(330),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(357),27,ex3(:),4,G2tensor(331),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(358),27,ex3(:),4,G2tensor(332),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(359),0,ex3(:),4,G2tensor(333),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(362),27,ex3(:),4,G2tensor(334),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(363),23,ex4(:),8,G2tensor(335),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(364),0,ex4(:),8,G2tensor(336),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(367),23,ex4(:),8,G2tensor(337),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(368),23,ex4(:),8,G2tensor(338),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(369),0,ex4(:),8,G2tensor(339),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(372),23,ex4(:),8,G2tensor(340),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(373),23,ex4(:),8,G2tensor(341),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(374),0,ex4(:),8,G2tensor(342),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(377),23,ex4(:),8,G2tensor(343),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(378),23,ex4(:),8,G2tensor(344),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(379),0,ex4(:),8,G2tensor(345),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(382),23,ex4(:),8,G2tensor(346),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hloop_VQ_A(ntryL,G1H4(97),wf4(:,9),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(347),n2h1(285))
  call Hloop_VQ_A(ntryL,G1H4(98),wf4(:,9),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(348),n2h1(286))
  call Hloop_VQ_A(ntryL,G1H4(107),wf4(:,9),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(349),n2h1(287))
  call Hloop_ZQ_A(ntryL,G1H4(111),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,8),heltab2x4(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(350),n2h1(288))
  call Hloop_ZQ_A(ntryL,G1H4(115),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,9),heltab2x4(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(351),n2h1(289))
  call Hloop_ZQ_A(ntryL,G1H4(18),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,10),heltab2x4(:,:,314))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(352),n2h1(290))
  call Hloop_VA_Q(ntryL,G1H4(30),wf4(:,4),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(353),n2h1(291))
  call Hloop_VA_Q(ntryL,G1H4(24),wf4(:,4),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(354),n2h1(292))
  call Hloop_VA_Q(ntryL,G1H4(40),wf4(:,4),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(355),n2h1(293))
  call Hloop_ZA_Q(ntryL,G1H4(46),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,14),heltab2x4(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(356),n2h1(294))
  call Hloop_ZA_Q(ntryL,G1H4(51),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,15),heltab2x4(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(357),n2h1(295))
  call Hloop_ZA_Q(ntryL,G1H4(61),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,16),heltab2x4(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(358),n2h1(296))
  call Hloop_QV_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(359),n2h1(297))
  call Hloop_QV_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(360),n2h1(298))
  call Hloop_QV_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(361),n2h1(299))
  call Hloop_QV_A(ntryL,G1H2(79),ex3(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(362),n2h1(300))
  call Hloop_QV_A(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nML,G2tensor(363),n2h1(301))
  call Hloop_QV_A(ntryL,G1H2(90),ex3(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(364),n2h1(302))
  call Hloop_AV_Q(ntryL,G1H2(123),ex3(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(365),n2h1(303))
  call Hloop_AV_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMM,G2tensor(366),n2h1(304))
  call Hloop_AV_Q(ntryL,G1H2(151),ex3(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(367),n2h1(305))
  call Hloop_AV_Q(ntryL,G1H2(155),ex3(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(368),n2h1(306))
  call Hloop_AV_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nML,G2tensor(369),n2h1(307))
  call Hloop_AV_Q(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(370),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(371),n2h1(309))
  call Hloop_QV_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(372),n2h1(310))
  call Hloop_QV_A(ntryL,G1H2(385),ex3(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(373),n2h1(311))
  call Hloop_AV_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(374),n2h1(312))
  call Hloop_AV_Q(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(375),n2h1(313))
  call Hloop_AV_Q(ntryL,G1H2(389),ex3(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(376),n2h1(314))
  call Hloop_QV_A(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(377),n2h1(315))
  call Hloop_QV_A(ntryL,G1H2(390),ex3(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(378),n2h1(316))
  call Hloop_QV_A(ntryL,G1H2(393),ex3(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(379),n2h1(317))
  call Hloop_AV_Q(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(380),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H2(394),ex3(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(381),n2h1(319))
  call Hloop_AV_Q(ntryL,G1H2(397),ex3(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(382),n2h1(320))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(68),27,ex3(:),4,G2tensor(383),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(74),0,ex3(:),4,G2tensor(384),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(399),27,ex3(:),4,G2tensor(385),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(95),27,ex3(:),G2tensor(386),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(400),0,ex3(:),G2tensor(387),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(403),27,ex3(:),G2tensor(388),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hloop_AV_Q(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(389),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H2(404),ex4(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(390),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H2(407),ex4(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(391),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(392),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(408),ex4(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(393),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H2(411),ex4(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(394),n2h1(328))
  call Hloop_QV_A(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(395),n2h1(329))
  call Hloop_QV_A(ntryL,G1H2(412),ex4(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(396),n2h1(330))
  call Hloop_QV_A(ntryL,G1H2(415),ex4(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(397),n2h1(331))
  call Hloop_QV_A(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(398),n2h1(332))
  call Hloop_QV_A(ntryL,G1H2(416),ex4(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(399),n2h1(333))
  call Hloop_QV_A(ntryL,G1H2(419),ex4(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(400),n2h1(334))
  call Hloop_AV_Q(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(401),n2h1(335))
  call Hloop_AV_Q(ntryL,G1H2(420),ex4(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(402),n2h1(336))
  call Hloop_AV_Q(ntryL,G1H2(423),ex4(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(403),n2h1(337))
  call Hloop_QV_A(ntryL,G1H2(183),ex4(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(404),n2h1(338))
  call Hloop_QV_A(ntryL,G1H2(424),ex4(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(405),n2h1(339))
  call Hloop_QV_A(ntryL,G1H2(427),ex4(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(406),n2h1(340))
  call Hloop_AV_Q(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(407),n2h1(341))
  call Hloop_AV_Q(ntryL,G1H2(428),ex4(:),G1H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(408),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(431),ex4(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(409),n2h1(343))
  call Hloop_QV_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(410),n2h1(344))
  call Hloop_QV_A(ntryL,G1H2(432),ex4(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(411),n2h1(345))
  call Hloop_QV_A(ntryL,G1H2(435),ex4(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(412),n2h1(346))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(116),23,ex4(:),G2tensor(413),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(127),0,ex4(:),G2tensor(414),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(437),23,ex4(:),G2tensor(415),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(160),23,ex4(:),8,G2tensor(416),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(438),0,ex4(:),8,G2tensor(417),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(441),23,ex4(:),8,G2tensor(418),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hloop_QV_A(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(419),n2h1(349))
  call Hloop_QV_A(ntryL,G1H2(177),ex4(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(420),n2h1(350))
  call Hloop_QV_A(ntryL,G1H2(444),ex4(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(421),n2h1(351))
  call Hloop_QV_A(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(422),n2h1(352))
  call Hloop_QV_A(ntryL,G1H2(445),ex4(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nML,G2tensor(423),n2h1(353))
  call Hloop_QV_A(ntryL,G1H2(448),ex4(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(424),n2h1(354))
  call Hloop_AV_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(425),n2h1(355))
  call Hloop_AV_Q(ntryL,G1H2(194),ex4(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMM,G2tensor(426),n2h1(356))
  call Hloop_AV_Q(ntryL,G1H2(451),ex4(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(427),n2h1(357))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(428),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H2(452),ex4(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(429),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H2(455),ex4(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(430),n2h1(360))
  call Hloop_QV_A(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(431),n2h1(361))
  call Hloop_QV_A(ntryL,G1H2(456),ex4(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(432),n2h1(362))
  call Hloop_QV_A(ntryL,G1H2(459),ex4(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(433),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(434),n2h1(364))
  call Hloop_AV_Q(ntryL,G1H2(460),ex4(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(435),n2h1(365))
  call Hloop_AV_Q(ntryL,G1H2(463),ex4(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(436),n2h1(366))
  call Hloop_QV_A(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(437),n2h1(367))
  call Hloop_QV_A(ntryL,G1H2(464),ex4(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(438),n2h1(368))
  call Hloop_QV_A(ntryL,G1H2(467),ex4(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(439),n2h1(369))
  call Hloop_AV_Q(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(440),n2h1(370))
  call Hloop_AV_Q(ntryL,G1H2(468),ex4(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(441),n2h1(371))
  call Hloop_AV_Q(ntryL,G1H2(471),ex4(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(442),n2h1(372))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(144),23,ex4(:),8,G2tensor(443),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(46),0,ex4(:),8,G2tensor(444),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(473),23,ex4(:),8,G2tensor(445),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(201),23,ex4(:),G2tensor(446),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(474),0,ex4(:),G2tensor(447),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(477),23,ex4(:),G2tensor(448),m3h2x1(:,520),heltab2x2(:,:,520))
  call ol_merge_tensors(G2tensor(99),[G2tensor(16),G1tensor(2)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(17),G1tensor(6)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(20),G1tensor(14)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(21),G1tensor(18)])
  call ol_merge_tensors(G2tensor(161),[G2tensor(24),G1tensor(38)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(25),G1tensor(42)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(28),G1tensor(44)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(29),G1tensor(48)])
  call ol_merge_tensors(G2tensor(170),[G2tensor(32),G1tensor(50)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(33),G1tensor(78),G1tensor(54)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(36),G1tensor(56)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(37),G1tensor(84),G1tensor(60)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(40),G1tensor(8)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(61),G2tensor(41),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(44),G1tensor(62)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(45),G1tensor(66)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(48),G1tensor(68)])
  call ol_merge_tensors(G2tensor(350),[G2tensor(49),G1tensor(72)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(52),G1tensor(74),G1tensor(63)])
  call ol_merge_tensors(G2tensor(203),[G2tensor(56),G1tensor(80),G1tensor(69)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(60),G1tensor(20),G1tensor(15)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(64),G1tensor(86)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(65),G1tensor(102),G1tensor(90)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(68),G1tensor(92)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(69),G1tensor(108),G1tensor(96)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(72),G1tensor(26)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(85),G2tensor(73),G1tensor(36),G1tensor(30)])
  call ol_merge_tensors(G2tensor(233),[G2tensor(76),G1tensor(98),G1tensor(39)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(80),G1tensor(104),G1tensor(45)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(84),G1tensor(32),G1tensor(3)])
  call ol_merge_tensors(G2tensor(251),[G1tensor(1),G1tensor(4)])
  call ol_merge_tensors(G2tensor(446),[G2tensor(443),G2tensor(344),G2tensor(341),G2tensor(158),G2tensor(155),G2tensor(98) &
    ,G2tensor(97),G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(272),[G1tensor(49),G1tensor(9)])
  call ol_merge_tensors(G2tensor(416),[G2tensor(413),G2tensor(338),G2tensor(335),G2tensor(311),G2tensor(275),G2tensor(96) &
    ,G2tensor(95),G1tensor(28),G1tensor(10)])
  call ol_merge_tensors(G2tensor(185),[G1tensor(7),G1tensor(11)])
  call ol_merge_tensors(G2tensor(254),[G1tensor(13),G1tensor(16)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(55),G1tensor(21)])
  call ol_merge_tensors(G2tensor(386),[G2tensor(383),G2tensor(332),G2tensor(329),G2tensor(326),G2tensor(296),G2tensor(94) &
    ,G2tensor(93),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(212),[G1tensor(25),G1tensor(23)])
  call ol_merge_tensors(G2tensor(308),[G1tensor(37),G1tensor(27)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(19),G1tensor(29)])
  call ol_merge_tensors(G2tensor(323),[G1tensor(43),G1tensor(33)])
  call ol_merge_tensors(G2tensor(248),[G1tensor(31),G1tensor(35)])
  call ol_merge_tensors(G2tensor(257),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(164),G1tensor(71),G1tensor(65),G1tensor(47),G1tensor(41)])
  call ol_merge_tensors(G2tensor(260),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(263),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(266),G1tensor(94),G1tensor(88),G1tensor(58),G1tensor(52)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(269),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(179),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(278),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(287),G1tensor(106),G1tensor(100),G1tensor(82),G1tensor(76)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(206),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(299),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(218),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(305),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(224),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(314),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(236),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(320),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(242),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(103)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(133),G2tensor(132),G2tensor(131),G2tensor(108),G2tensor(104)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(105)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(121),G2tensor(120),G2tensor(119),G2tensor(110),G2tensor(106)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(111)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(112)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(115)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(117)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(123)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(124)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(127)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(129)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(135)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(136)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(137)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(141)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(143)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(149),G2tensor(148),G2tensor(147),G2tensor(146),G2tensor(145)])
  call ol_merge_tensors(G2tensor(365),[G2tensor(359)])
  call ol_merge_tensors(G2tensor(368),[G2tensor(362)])
  call ol_merge_tensors(G2tensor(374),[G2tensor(371)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(377)])
  call ol_merge_tensors(G2tensor(395),[G2tensor(389)])
  call ol_merge_tensors(G2tensor(398),[G2tensor(392)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(401)])
  call ol_merge_tensors(G2tensor(410),[G2tensor(407)])
  call ol_merge_tensors(G2tensor(425),[G2tensor(419)])
  call ol_merge_tensors(G2tensor(428),[G2tensor(422)])
  call ol_merge_tensors(G2tensor(434),[G2tensor(431)])
  call ol_merge_tensors(G2tensor(440),[G2tensor(437)])
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(26),mass4set(:,1),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(153),RedSet_4(1),mass4set(:,1),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(2),G1tensor(6))
  call G_TensorShift(G1tensor(97),10)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(27),mass4set(:,1),  & 
G1tensor(14),G1tensor(18),G1tensor(38),G1tensor(42),G1tensor(44))
  call G_TensorShift(G1tensor(18),1)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(2),mass4set(:,1),  & 
G1tensor(48),G1tensor(50),G1tensor(78),G1tensor(54),G1tensor(56))
  call G_TensorShift(G1tensor(50),9)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(26),mass4set(:,2),  & 
G1tensor(84),G1tensor(60),G1tensor(8),G1tensor(24),G1tensor(12))
  call G_TensorShift(G1tensor(60),2)
  call Hotf_4pt_reduction_last(G2tensor(353),RedSet_4(1),mass4set(:,2),  & 
G1tensor(62),G1tensor(66),G1tensor(68),G1tensor(72),G1tensor(74))
  call G_TensorShift(G1tensor(66),10)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(26),mass4set(:,3),  & 
G1tensor(63),G1tensor(80),G1tensor(69),G1tensor(20),G1tensor(15))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(1),mass4set(:,3),  & 
G1tensor(86),G1tensor(102),G1tensor(90),G1tensor(92),G1tensor(108))
  call G_TensorShift(G1tensor(102),10)
  call Hotf_4pt_reduction_last(G2tensor(170),RedSet_4(28),mass4set(:,2),  & 
G1tensor(96),G1tensor(26),G1tensor(36),G1tensor(30),G1tensor(98))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(3),mass4set(:,2),  & 
G1tensor(39),G1tensor(104),G1tensor(45),G1tensor(32),G1tensor(3))
  call G_TensorShift(G1tensor(104),12)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(28),mass4set(:,4),  & 
G1tensor(1),G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(49))
  call G_TensorShift(G1tensor(4),4)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(3),mass4set(:,4),  & 
G1tensor(9),G1tensor(28),G1tensor(10),G1tensor(7),G1tensor(11))
  call G_TensorShift(G1tensor(28),12)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(28),mass4set(:,5),  & 
G1tensor(13),G1tensor(16),G1tensor(55),G1tensor(21),G1tensor(34))
  call G_TensorShift(G1tensor(16),4)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(3),mass4set(:,5),  & 
G1tensor(22),G1tensor(25),G1tensor(23),G1tensor(37),G1tensor(27))
  call G_TensorShift(G1tensor(25),12)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(27),mass4set(:,2),  & 
G1tensor(19),G1tensor(29),G1tensor(43),G1tensor(33),G1tensor(31))
  call G_TensorShift(G1tensor(29),1)
  call Hotf_4pt_reduction_last(G2tensor(347),RedSet_4(2),mass4set(:,2),  & 
G1tensor(35),G1tensor(40),G1tensor(71),G1tensor(65),G1tensor(47))
  call G_TensorShift(G1tensor(40),9)
  call Hotf_4pt_reduction_last(G2tensor(194),RedSet_4(27),mass4set(:,3),  & 
G1tensor(41),G1tensor(46),G1tensor(51),G1tensor(94),G1tensor(88))
  call G_TensorShift(G1tensor(46),1)
  call Hotf_4pt_reduction_last(G2tensor(350),RedSet_4(2),mass4set(:,3),  & 
G1tensor(58),G1tensor(52),G1tensor(53),G1tensor(57),G1tensor(59))
  call G_TensorShift(G1tensor(52),9)
  call Hotf_4pt_reduction_last(G2tensor(197),RedSet_4(13),mass4set(:,2),  & 
G1tensor(64),G1tensor(70),G1tensor(75),G1tensor(106),G1tensor(100))
  call G_TensorShift(G1tensor(70),8)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(13),mass4set(:,4),  & 
G1tensor(82),G1tensor(76),G1tensor(77),G1tensor(81),G1tensor(83))
  call G_TensorShift(G1tensor(76),8)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(13),mass4set(:,5),  & 
G1tensor(87),G1tensor(89),G1tensor(93),G1tensor(95),G1tensor(99))
  call G_TensorShift(G1tensor(89),8)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(29),mass4set(:,2),  & 
G1tensor(101),G1tensor(105),G1tensor(107),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(105),4)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(4),mass4set(:,2),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),12)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(29),mass4set(:,4),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),4)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(4),mass4set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),12)
  call Hotf_4pt_reduction_last(G2tensor(227),RedSet_4(29),mass4set(:,5),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),4)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(4),mass4set(:,5),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),12)
  call Hotf_4pt_reduction_last(G2tensor(233),RedSet_4(5),mass4set(:,2),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(239),RedSet_4(5),mass4set(:,4),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),8)
  call Hotf_4pt_reduction_last(G2tensor(245),RedSet_4(5),mass4set(:,5),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(251),RedSet_4(6),mass4set(:,5),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(446),RedSet_4(7),mass4set(:,6),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(9),mass4set(:,12),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),8)
  call Hotf_4pt_reduction_last(G2tensor(416),RedSet_4(10),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),8)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(11),mass4set(:,5),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),8)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(14),mass4set(:,5),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),8)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(16),mass4set(:,12),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(386),RedSet_4(17),mass4set(:,6),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(18),mass4set(:,5),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(20),mass4set(:,12),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(21),mass4set(:,5),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(23),mass4set(:,12),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),4)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(24),mass4set(:,5),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_4pt_reduction_last(G2tensor(257),RedSet_4(6),mass4set(:,2),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(7),mass4set(:,2),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),8)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(6),mass4set(:,4),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),8)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(9),mass4set(:,2),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),8)
  call Hotf_4pt_reduction_last(G2tensor(302),RedSet_4(10),mass4set(:,2),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),8)
  call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(11),mass4set(:,2),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_4pt_reduction_last(G2tensor(269),RedSet_4(9),mass4set(:,11),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(11),mass4set(:,4),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_4pt_reduction_last(G2tensor(278),RedSet_4(14),mass4set(:,2),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(14),mass4set(:,4),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),8)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(16),mass4set(:,2),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),4)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(17),mass4set(:,2),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(18),mass4set(:,2),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),4)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(16),mass4set(:,11),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),4)
  call Hotf_4pt_reduction_last(G2tensor(206),RedSet_4(18),mass4set(:,4),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),4)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(20),mass4set(:,2),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(218),RedSet_4(21),mass4set(:,2),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),8)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(20),mass4set(:,11),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(224),RedSet_4(21),mass4set(:,4),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),8)
  call Hotf_4pt_reduction_last(G2tensor(314),RedSet_4(23),mass4set(:,2),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),4)
  call Hotf_4pt_reduction_last(G2tensor(236),RedSet_4(24),mass4set(:,2),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),4)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(23),mass4set(:,11),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),4)
  call Hotf_4pt_reduction_last(G2tensor(242),RedSet_4(24),mass4set(:,4),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),4)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(10),mass4set(:,2),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G0tensor(1))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(10),mass4set(:,6),  & 
G1tensor(331),G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G0tensor(2))
  call G_TensorShift(G1tensor(336),8)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(17),mass4set(:,2),  & 
G1tensor(331),G1tensor(340),G1tensor(341),G1tensor(342),G1tensor(343),G0tensor(3))
  call G_TensorShift(G1tensor(340),4)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(17),mass4set(:,6),  & 
G1tensor(331),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G0tensor(4))
  call G_TensorShift(G1tensor(344),4)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(17),mass4set(:,7),  & 
G1tensor(331),G1tensor(348),G1tensor(349),G1tensor(350),G1tensor(351),G0tensor(5))
  call G_TensorShift(G1tensor(348),4)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(17),mass4set(:,8),  & 
G1tensor(331),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355),G0tensor(6))
  call G_TensorShift(G1tensor(352),4)
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(17),mass4set(:,9),  & 
G1tensor(331),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G0tensor(7))
  call G_TensorShift(G1tensor(356),4)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(17),mass4set(:,10),  & 
G1tensor(331),G1tensor(360),G1tensor(361),G1tensor(362),G1tensor(363),G0tensor(8))
  call G_TensorShift(G1tensor(360),4)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(10),mass4set(:,7),  & 
G1tensor(331),G1tensor(364),G1tensor(365),G1tensor(366),G1tensor(367),G0tensor(9))
  call G_TensorShift(G1tensor(364),8)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(10),mass4set(:,8),  & 
G1tensor(331),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G0tensor(10))
  call G_TensorShift(G1tensor(368),8)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(10),mass4set(:,9),  & 
G1tensor(331),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375),G0tensor(11))
  call G_TensorShift(G1tensor(372),8)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(10),mass4set(:,10),  & 
G1tensor(331),G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G0tensor(12))
  call G_TensorShift(G1tensor(376),8)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(7),mass4set(:,2),  & 
G1tensor(331),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G0tensor(13))
  call G_TensorShift(G1tensor(380),8)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(7),mass4set(:,7),  & 
G1tensor(331),G1tensor(384),G1tensor(385),G1tensor(386),G1tensor(387),G0tensor(14))
  call G_TensorShift(G1tensor(384),8)
  call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(7),mass4set(:,8),  & 
G1tensor(331),G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391),G0tensor(15))
  call G_TensorShift(G1tensor(388),8)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(7),mass4set(:,9),  & 
G1tensor(331),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G0tensor(16))
  call G_TensorShift(G1tensor(392),8)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(7),mass4set(:,10),  & 
G1tensor(331),G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G0tensor(17))
  call G_TensorShift(G1tensor(396),8)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(7),mass4set(:,6),  & 
G1tensor(331),G1tensor(400),G1tensor(401),G1tensor(402),G1tensor(403),G0tensor(18))
  call G_TensorShift(G1tensor(400),8)
  call Hotf_4pt_reduction_last(G2tensor(365),RedSet_4(17),mass4set(:,7),  & 
G1tensor(331),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407))
  call G_TensorShift(G1tensor(404),4)
  call Hotf_4pt_reduction_last(G2tensor(368),RedSet_4(17),mass4set(:,8),  & 
G1tensor(408),G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412))
  call G_TensorShift(G1tensor(409),4)
  call Hotf_4pt_reduction_last(G2tensor(374),RedSet_4(17),mass4set(:,9),  & 
G1tensor(413),G1tensor(414),G1tensor(415),G1tensor(416),G1tensor(417))
  call G_TensorShift(G1tensor(414),4)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(17),mass4set(:,10),  & 
G1tensor(418),G1tensor(419),G1tensor(420),G1tensor(421),G1tensor(422))
  call G_TensorShift(G1tensor(419),4)
  call Hotf_4pt_reduction_last(G2tensor(395),RedSet_4(10),mass4set(:,7),  & 
G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426),G1tensor(427))
  call G_TensorShift(G1tensor(424),8)
  call Hotf_4pt_reduction_last(G2tensor(398),RedSet_4(10),mass4set(:,8),  & 
G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(429),8)
  call Hotf_4pt_reduction_last(G2tensor(404),RedSet_4(10),mass4set(:,9),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437))
  call G_TensorShift(G1tensor(434),8)
  call Hotf_4pt_reduction_last(G2tensor(410),RedSet_4(10),mass4set(:,10),  & 
G1tensor(438),G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442))
  call G_TensorShift(G1tensor(439),8)
  call Hotf_4pt_reduction_last(G2tensor(425),RedSet_4(7),mass4set(:,7),  & 
G1tensor(443),G1tensor(444),G1tensor(445),G1tensor(446),G1tensor(447))
  call G_TensorShift(G1tensor(444),8)
  call Hotf_4pt_reduction_last(G2tensor(428),RedSet_4(7),mass4set(:,8),  & 
G1tensor(448),G1tensor(449),G1tensor(450),G1tensor(451),G1tensor(452))
  call G_TensorShift(G1tensor(449),8)
  call Hotf_4pt_reduction_last(G2tensor(434),RedSet_4(7),mass4set(:,9),  & 
G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456),G1tensor(457))
  call G_TensorShift(G1tensor(454),8)
  call Hotf_4pt_reduction_last(G2tensor(440),RedSet_4(7),mass4set(:,10),  & 
G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(459),8)
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(26),mass4set(:,1),  & 
G0tensor(19),G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(1),mass4set(:,1),  & 
G0tensor(24),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(27),mass4set(:,1),  & 
G0tensor(29),G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33))
  call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(2),mass4set(:,1),  & 
G0tensor(34),G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(26),mass4set(:,2),  & 
G0tensor(39),G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(1),mass4set(:,2),  & 
G0tensor(44),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(26),mass4set(:,3),  & 
G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(1),mass4set(:,3),  & 
G0tensor(54),G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(28),mass4set(:,2),  & 
G0tensor(59),G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(3),mass4set(:,2),  & 
G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(28),mass4set(:,4),  & 
G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(3),mass4set(:,4),  & 
G0tensor(74),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78))
  call Hotf_4pt_reduction_last(G1tensor(13),RedSet_4(28),mass4set(:,5),  & 
G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(3),mass4set(:,5),  & 
G0tensor(84),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88))
  call Hotf_4pt_reduction_last(G1tensor(19),RedSet_4(27),mass4set(:,2),  & 
G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(2),mass4set(:,2),  & 
G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(27),mass4set(:,3),  & 
G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(2),mass4set(:,3),  & 
G0tensor(104),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(13),mass4set(:,2),  & 
G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113))
  call Hotf_4pt_reduction_last(G1tensor(82),RedSet_4(13),mass4set(:,4),  & 
G0tensor(114),G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(13),mass4set(:,5),  & 
G0tensor(119),G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(29),mass4set(:,2),  & 
G0tensor(124),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(4),mass4set(:,2),  & 
G0tensor(129),G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(29),mass4set(:,4),  & 
G0tensor(134),G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(4),mass4set(:,4),  & 
G0tensor(139),G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(29),mass4set(:,5),  & 
G0tensor(144),G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(4),mass4set(:,5),  & 
G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(5),mass4set(:,2),  & 
G0tensor(154),G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(5),mass4set(:,4),  & 
G0tensor(159),G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(5),mass4set(:,5),  & 
G0tensor(164),G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(6),mass4set(:,5),  & 
G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(7),mass4set(:,6),  & 
G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(9),mass4set(:,12),  & 
G0tensor(179),G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(10),mass4set(:,6),  & 
G0tensor(184),G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(11),mass4set(:,5),  & 
G0tensor(189),G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(14),mass4set(:,5),  & 
G0tensor(194),G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(16),mass4set(:,12),  & 
G0tensor(199),G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(17),mass4set(:,6),  & 
G0tensor(204),G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(18),mass4set(:,5),  & 
G0tensor(209),G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(20),mass4set(:,12),  & 
G0tensor(214),G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(21),mass4set(:,5),  & 
G0tensor(219),G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(23),mass4set(:,12),  & 
G0tensor(224),G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(24),mass4set(:,5),  & 
G0tensor(229),G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(6),mass4set(:,2),  & 
G0tensor(234),G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(7),mass4set(:,2),  & 
G0tensor(239),G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(6),mass4set(:,4),  & 
G0tensor(244),G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(9),mass4set(:,2),  & 
G0tensor(249),G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(10),mass4set(:,2),  & 
G0tensor(254),G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(11),mass4set(:,2),  & 
G0tensor(259),G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(9),mass4set(:,11),  & 
G0tensor(264),G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(11),mass4set(:,4),  & 
G0tensor(269),G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(14),mass4set(:,2),  & 
G0tensor(274),G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(14),mass4set(:,4),  & 
G0tensor(279),G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(16),mass4set(:,2),  & 
G0tensor(284),G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(17),mass4set(:,2),  & 
G0tensor(289),G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(18),mass4set(:,2),  & 
G0tensor(294),G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(16),mass4set(:,11),  & 
G0tensor(299),G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(18),mass4set(:,4),  & 
G0tensor(304),G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(20),mass4set(:,2),  & 
G0tensor(309),G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(21),mass4set(:,2),  & 
G0tensor(314),G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(20),mass4set(:,11),  & 
G0tensor(319),G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(21),mass4set(:,4),  & 
G0tensor(324),G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(23),mass4set(:,2),  & 
G0tensor(329),G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(24),mass4set(:,2),  & 
G0tensor(334),G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(23),mass4set(:,11),  & 
G0tensor(339),G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(24),mass4set(:,4),  & 
G0tensor(344),G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(17),mass4set(:,7),  & 
G0tensor(349),G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(17),mass4set(:,8),  & 
G0tensor(354),G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358))
  call Hotf_4pt_reduction_last(G1tensor(413),RedSet_4(17),mass4set(:,9),  & 
G0tensor(359),G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363))
  call Hotf_4pt_reduction_last(G1tensor(418),RedSet_4(17),mass4set(:,10),  & 
G0tensor(364),G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368))
  call Hotf_4pt_reduction_last(G1tensor(423),RedSet_4(10),mass4set(:,7),  & 
G0tensor(369),G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(10),mass4set(:,8),  & 
G0tensor(374),G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378))
  call Hotf_4pt_reduction_last(G1tensor(433),RedSet_4(10),mass4set(:,9),  & 
G0tensor(379),G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383))
  call Hotf_4pt_reduction_last(G1tensor(438),RedSet_4(10),mass4set(:,10),  & 
G0tensor(384),G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388))
  call Hotf_4pt_reduction_last(G1tensor(443),RedSet_4(7),mass4set(:,7),  & 
G0tensor(389),G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393))
  call Hotf_4pt_reduction_last(G1tensor(448),RedSet_4(7),mass4set(:,8),  & 
G0tensor(394),G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398))
  call Hotf_4pt_reduction_last(G1tensor(453),RedSet_4(7),mass4set(:,9),  & 
G0tensor(399),G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403))
  call Hotf_4pt_reduction_last(G1tensor(458),RedSet_4(7),mass4set(:,10),  & 
G0tensor(404),G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408))
  call ol_merge_tensors(T0sum(1),[G0tensor(19)])
  call ol_merge_tensors(T0sum(2),[G0tensor(24)])
  call ol_merge_tensors(T0sum(3),[G0tensor(29)])
  call ol_merge_tensors(T0sum(4),[G0tensor(34)])
  call ol_merge_tensors(T0sum(5),[G0tensor(39)])
  call ol_merge_tensors(T0sum(6),[G0tensor(44)])
  call ol_merge_tensors(T0sum(7),[G0tensor(49)])
  call ol_merge_tensors(T0sum(8),[G0tensor(54)])
  call ol_merge_tensors(T0sum(9),[G0tensor(59)])
  call ol_merge_tensors(T0sum(10),[G0tensor(64)])
  call ol_merge_tensors(T0sum(11),[G0tensor(69)])
  call ol_merge_tensors(T0sum(12),[G0tensor(74)])
  call ol_merge_tensors(T0sum(13),[G0tensor(79)])
  call ol_merge_tensors(T0sum(14),[G0tensor(84)])
  call ol_merge_tensors(T0sum(15),[G0tensor(89)])
  call ol_merge_tensors(T0sum(16),[G0tensor(94)])
  call ol_merge_tensors(T0sum(17),[G0tensor(99)])
  call ol_merge_tensors(T0sum(18),[G0tensor(104)])
  call ol_merge_tensors(T0sum(19),[G0tensor(109)])
  call ol_merge_tensors(T0sum(20),[G0tensor(114)])
  call ol_merge_tensors(T0sum(21),[G0tensor(119)])
  call ol_merge_tensors(T0sum(22),[G0tensor(124)])
  call ol_merge_tensors(T0sum(23),[G0tensor(129)])
  call ol_merge_tensors(T0sum(24),[G0tensor(134)])
  call ol_merge_tensors(T0sum(25),[G0tensor(139)])
  call ol_merge_tensors(T0sum(26),[G0tensor(144)])
  call ol_merge_tensors(T0sum(27),[G0tensor(149)])
  call ol_merge_tensors(T0sum(28),[G0tensor(154)])
  call ol_merge_tensors(T0sum(29),[G0tensor(159)])
  call ol_merge_tensors(T0sum(30),[G0tensor(164)])
  call ol_merge_tensors(T0sum(31),[G0tensor(169)])
  call ol_merge_tensors(T0sum(32),[G0tensor(174)])
  call ol_merge_tensors(T0sum(33),[G0tensor(179)])
  call ol_merge_tensors(T0sum(34),[G0tensor(184)])
  call ol_merge_tensors(T0sum(35),[G0tensor(189)])
  call ol_merge_tensors(T0sum(36),[G0tensor(194)])
  call ol_merge_tensors(T0sum(37),[G0tensor(199)])
  call ol_merge_tensors(T0sum(38),[G0tensor(204)])
  call ol_merge_tensors(T0sum(39),[G0tensor(209)])
  call ol_merge_tensors(T0sum(40),[G0tensor(214)])
  call ol_merge_tensors(T0sum(41),[G0tensor(219)])
  call ol_merge_tensors(T0sum(42),[G0tensor(224)])
  call ol_merge_tensors(T0sum(43),[G0tensor(229)])
  call ol_merge_tensors(T0sum(44),[G0tensor(234)])
  call ol_merge_tensors(T0sum(45),[G0tensor(239)])
  call ol_merge_tensors(T0sum(46),[G0tensor(244)])
  call ol_merge_tensors(T0sum(47),[G0tensor(249)])
  call ol_merge_tensors(T0sum(48),[G0tensor(254)])
  call ol_merge_tensors(T0sum(49),[G0tensor(259)])
  call ol_merge_tensors(T0sum(50),[G0tensor(264)])
  call ol_merge_tensors(T0sum(51),[G0tensor(269)])
  call ol_merge_tensors(T0sum(52),[G0tensor(274)])
  call ol_merge_tensors(T0sum(53),[G0tensor(279)])
  call ol_merge_tensors(T0sum(54),[G0tensor(284)])
  call ol_merge_tensors(T0sum(55),[G0tensor(289)])
  call ol_merge_tensors(T0sum(56),[G0tensor(294)])
  call ol_merge_tensors(T0sum(57),[G0tensor(299)])
  call ol_merge_tensors(T0sum(58),[G0tensor(304)])
  call ol_merge_tensors(T0sum(59),[G0tensor(309)])
  call ol_merge_tensors(T0sum(60),[G0tensor(314)])
  call ol_merge_tensors(T0sum(61),[G0tensor(319)])
  call ol_merge_tensors(T0sum(62),[G0tensor(324)])
  call ol_merge_tensors(T0sum(63),[G0tensor(329)])
  call ol_merge_tensors(T0sum(64),[G0tensor(334)])
  call ol_merge_tensors(T0sum(65),[G0tensor(339)])
  call ol_merge_tensors(T0sum(66),[G0tensor(344)])
  call ol_merge_tensors(T0sum(67),[G0tensor(1)])
  call ol_merge_tensors(T0sum(68),[G0tensor(2)])
  call ol_merge_tensors(T0sum(69),[G0tensor(3)])
  call ol_merge_tensors(T0sum(70),[G0tensor(4)])
  call ol_merge_tensors(T0sum(71),[G0tensor(5)])
  call ol_merge_tensors(T0sum(72),[G0tensor(6)])
  call ol_merge_tensors(T0sum(73),[G0tensor(7)])
  call ol_merge_tensors(T0sum(74),[G0tensor(8)])
  call ol_merge_tensors(T0sum(75),[G0tensor(9)])
  call ol_merge_tensors(T0sum(76),[G0tensor(10)])
  call ol_merge_tensors(T0sum(77),[G0tensor(11)])
  call ol_merge_tensors(T0sum(78),[G0tensor(12)])
  call ol_merge_tensors(T0sum(79),[G0tensor(13)])
  call ol_merge_tensors(T0sum(80),[G0tensor(14)])
  call ol_merge_tensors(T0sum(81),[G0tensor(15)])
  call ol_merge_tensors(T0sum(82),[G0tensor(16)])
  call ol_merge_tensors(T0sum(83),[G0tensor(17)])
  call ol_merge_tensors(T0sum(84),[G0tensor(18)])
  call ol_merge_tensors(T0sum(85),[G0tensor(349)])
  call ol_merge_tensors(T0sum(86),[G0tensor(354)])
  call ol_merge_tensors(T0sum(87),[G0tensor(359)])
  call ol_merge_tensors(T0sum(88),[G0tensor(364)])
  call ol_merge_tensors(T0sum(89),[G0tensor(369)])
  call ol_merge_tensors(T0sum(90),[G0tensor(374)])
  call ol_merge_tensors(T0sum(91),[G0tensor(379)])
  call ol_merge_tensors(T0sum(92),[G0tensor(384)])
  call ol_merge_tensors(T0sum(93),[G0tensor(389)])
  call ol_merge_tensors(T0sum(94),[G0tensor(394)])
  call ol_merge_tensors(T0sum(95),[G0tensor(399)])
  call ol_merge_tensors(T0sum(96),[G0tensor(404)])
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(25),m4h2x4x4(:,1),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(24),m4h2x4x4(:,2),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(22),m4h2x4x4(:,3),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(11),m4h2x4x4(:,4),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(9),m4h2x4x4(:,5),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(23),m4h2x4x4(:,6),heltab3x32(:,:,10))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(21),m4h2x4x4(:,7),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(12),m4h2x4x4(:,8),heltab3x32(:,:,12))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(10),m4h2x4x4(:,9),heltab3x32(:,:,13))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(3),m4h2x4x4(:,10),heltab3x32(:,:,14))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(1),m4h2x4x4(:,11),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(4),m4h2x4x4(:,12),heltab3x32(:,:,16))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(2),m4h2x4x4(:,13),heltab3x32(:,:,17))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(8),m4h2x4x4(:,14),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(7),m4h2x4x4(:,15),heltab3x32(:,:,19))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(6),m4h2x4x4(:,16),heltab3x32(:,:,20))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,371),heltab2x32(:,:,387))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,372),heltab2x32(:,:,388))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,373),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,374),heltab2x32(:,:,390))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,375),heltab2x32(:,:,391))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,376),heltab2x32(:,:,392))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,377),heltab2x32(:,:,393))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,378),heltab2x32(:,:,394))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,379),heltab2x32(:,:,395))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,380),heltab2x32(:,:,396))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,381),heltab2x32(:,:,397))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,382),heltab2x32(:,:,398))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,383),heltab2x32(:,:,399))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,384),heltab2x32(:,:,400))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,385),heltab2x32(:,:,401))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,386),heltab2x32(:,:,402))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(23),m4h2x2x8(:,5),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,6),heltab3x32(:,:,22))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,7),heltab3x32(:,:,23))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,8),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(8),m4h2x2x8(:,9),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,10),heltab3x32(:,:,26))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(10),m4h2x2x8(:,11),heltab3x32(:,:,27))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(11),m4h2x2x8(:,12),heltab3x32(:,:,28))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(12),m4h2x2x8(:,13),heltab3x32(:,:,29))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(13),m4h2x2x8(:,14),heltab3x32(:,:,30))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,15),heltab3x32(:,:,31))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,16),heltab3x32(:,:,32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,17),heltab3x32(:,:,33))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(17),m4h2x2x8(:,18),heltab3x32(:,:,34))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(18),m4h2x2x8(:,19),heltab3x32(:,:,35))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(19),m4h2x2x8(:,20),heltab3x32(:,:,36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,387),heltab2x32(:,:,403))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(71),m3h2x16(:,388),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,389),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,390),heltab2x32(:,:,406))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,391),heltab2x32(:,:,407))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,392),heltab2x32(:,:,408))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,393),heltab2x32(:,:,409))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,394),heltab2x32(:,:,410))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,395),heltab2x32(:,:,411))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,396),heltab2x32(:,:,412))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,397),heltab2x32(:,:,413))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,398),heltab2x32(:,:,414))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,399),heltab2x32(:,:,415))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,400),heltab2x32(:,:,416))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,401),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,402),heltab2x32(:,:,418))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(20),m4h2x2x8(:,21),heltab3x32(:,:,37))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,22),heltab3x32(:,:,38))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,23),heltab3x32(:,:,39))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(1),m4h2x2x8(:,24),heltab3x32(:,:,40))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(14),m4h2x2x8(:,25),heltab3x32(:,:,41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(21),m4h2x2x8(:,26),heltab3x32(:,:,42))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(22),m4h2x2x8(:,27),heltab3x32(:,:,43))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(24),m4h2x2x8(:,28),heltab3x32(:,:,44))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(25),m4h2x2x8(:,29),heltab3x32(:,:,45))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(26),m4h2x2x8(:,30),heltab3x32(:,:,46))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(27),m4h2x2x8(:,31),heltab3x32(:,:,47))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(28),m4h2x2x8(:,32),heltab3x32(:,:,48))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(29),m4h2x2x8(:,33),heltab3x32(:,:,49))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(30),m4h2x2x8(:,34),heltab3x32(:,:,50))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(31),m4h2x2x8(:,35),heltab3x32(:,:,51))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(32),m4h2x2x8(:,36),heltab3x32(:,:,52))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(145),m3h2x16(:,403),heltab2x32(:,:,419))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(139),m3h2x16(:,404),heltab2x32(:,:,420))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(147),m3h2x16(:,405),heltab2x32(:,:,421))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(142),m3h2x16(:,406),heltab2x32(:,:,422))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,407),heltab2x32(:,:,423))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(172),m3h2x16(:,408),heltab2x32(:,:,424))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,409),heltab2x32(:,:,425))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(176),m3h2x16(:,410),heltab2x32(:,:,426))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,411),heltab2x32(:,:,427))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,412),heltab2x32(:,:,428))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,413),heltab2x32(:,:,429))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,414),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,415),heltab2x32(:,:,431))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,416),heltab2x32(:,:,432))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,417),heltab2x32(:,:,433))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,418),heltab2x32(:,:,434))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[24,2,5],[nMW,0,nMW],4,1,wf4(:,3))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(33),m4h2x2x8(:,37),heltab3x32(:,:,53))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[24,1,6],[nMW,0,nMW],4,1,wf4(:,10))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(34),m4h2x2x8(:,38),heltab3x32(:,:,54))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[20,2,9],[nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(35),m4h2x2x8(:,39),heltab3x32(:,:,55))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[20,1,10],[nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(36),m4h2x2x8(:,40),heltab3x32(:,:,56))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[17,2,12],[0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,17),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(35),n2h8(107))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[18,1,12],[0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(37),m3h4x8(:,18),heltab2x32(:,:,436))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(36),n2h8(108))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[16,5,10],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,419),heltab2x32(:,:,437))
  call Hloop_A_Q(ntryL,G0H16(14),16,0,G1H16(1),n2h16(113))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[16,5,10],[0,nMZ,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,420),heltab2x32(:,:,438))
  call Hloop_A_Q(ntryL,G0H16(16),16,0,G1H16(2),n2h16(114))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[16,5,10],[nMW,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,421),heltab2x32(:,:,439))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[18,5,8],[0,0,0],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(37),m3h4x8(:,19),heltab2x32(:,:,440))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[18,5,8],[nMZ,0,0],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(38),ngZl,m3h4x8(:,20),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[18,5,8],[0,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(39),m3h4x8(:,21),heltab2x32(:,:,442))
  call Hloop_A_Q(ntryL,G0H8(39),18,0,G1H8(37),n2h8(109))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,422),heltab2x32(:,:,443))
  call Hloop_A_Q(ntryL,G0H16(18),16,0,G1H16(4),n2h16(115))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,423),heltab2x32(:,:,444))
  call Hloop_A_Q(ntryL,G0H16(20),16,nMM,G1H16(5),n2h16(116))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[16,7,8],[nML,nML,nML],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,424),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G0H16(21),16,nML,G1H16(15),n2h16(117))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,425),heltab2x32(:,:,446))
  call Hloop_Q_A(ntryL,G0H16(22),16,0,G1H16(7),n2h16(118))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,426),heltab2x32(:,:,447))
  call Hloop_Q_A(ntryL,G0H16(23),16,nMM,G1H16(8),n2h16(119))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[16,7,8],[nML,nML,nML],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,427),heltab2x32(:,:,448))
  call Hloop_Q_A(ntryL,G0H16(24),16,nML,G1H16(10),n2h16(120))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,428),heltab2x32(:,:,449))
  call Hloop_A_Q(ntryL,G0H16(25),16,0,G1H16(12),n2h16(121))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,429),heltab2x32(:,:,450))
  call Hloop_A_Q(ntryL,G0H16(26),16,nMT,G1H16(14),n2h16(122))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,430),heltab2x32(:,:,451))
  call Hloop_Q_A(ntryL,G0H16(27),16,0,G1H16(16),n2h16(123))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,431),heltab2x32(:,:,452))
  call Hloop_Q_A(ntryL,G0H16(28),16,nMT,G1H16(17),n2h16(124))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,432),heltab2x32(:,:,453))
  call Hloop_A_Q(ntryL,G0H16(29),16,0,G1H16(18),n2h16(125))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,433),heltab2x32(:,:,454))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(19),n2h16(126))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[16,7,8],[0,0,0],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,434),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G0H16(31),16,0,G1H16(20),n2h16(127))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,435),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G0H16(32),16,nMB,G1H16(21),n2h16(128))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,436),heltab2x32(:,:,457))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(22),n2h16(129))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,437),heltab2x32(:,:,458))
  call Hloop_A_Q(ntryL,G0H16(34),16,nMM,G1H16(23),n2h16(130))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[16,7,8],[nML,nML,nML],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,438),heltab2x32(:,:,459))
  call Hloop_A_Q(ntryL,G0H16(35),16,nML,G1H16(24),n2h16(131))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,439),heltab2x32(:,:,460))
  call Hloop_Q_A(ntryL,G0H16(36),16,0,G1H16(25),n2h16(132))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,440),heltab2x32(:,:,461))
  call Hloop_Q_A(ntryL,G0H16(37),16,nMM,G1H16(26),n2h16(133))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[16,7,8],[nML,nML,nML],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,441),heltab2x32(:,:,462))
  call Hloop_Q_A(ntryL,G0H16(38),16,nML,G1H16(27),n2h16(134))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,442),heltab2x32(:,:,463))
  call Hloop_A_Q(ntryL,G0H16(39),16,0,G1H16(28),n2h16(135))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,443),heltab2x32(:,:,464))
  call Hloop_A_Q(ntryL,G0H16(40),16,nMT,G1H16(29),n2h16(136))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,444),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G0H16(41),16,0,G1H16(30),n2h16(137))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,445),heltab2x32(:,:,466))
  call Hloop_Q_A(ntryL,G0H16(42),16,nMT,G1H16(31),n2h16(138))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,446),heltab2x32(:,:,467))
  call Hloop_A_Q(ntryL,G0H16(43),16,0,G1H16(32),n2h16(139))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,447),heltab2x32(:,:,468))
  call Hloop_A_Q(ntryL,G0H16(44),16,nMB,G1H16(33),n2h16(140))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,448),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G0H16(46),16,0,G1H16(34),n2h16(141))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,449),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G0H16(48),16,nMB,G1H16(37),n2h16(142))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,450),heltab2x32(:,:,471))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,451),heltab2x32(:,:,472))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,452),heltab2x32(:,:,473))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,453),heltab2x32(:,:,474))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(44),m3h2x16(:,454),heltab2x32(:,:,475))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,455),heltab2x32(:,:,476))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(46),m3h2x16(:,456),heltab2x32(:,:,477))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,457),heltab2x32(:,:,478))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(48),m3h2x16(:,458),heltab2x32(:,:,479))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,459),heltab2x32(:,:,480))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(50),m3h2x16(:,460),heltab2x32(:,:,481))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,461),heltab2x32(:,:,482))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,462),heltab2x32(:,:,483))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,463),heltab2x32(:,:,484))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,464),heltab2x32(:,:,485))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,465),heltab2x32(:,:,486))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,466),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,467),heltab2x32(:,:,488))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,468),heltab2x32(:,:,489))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,469),heltab2x32(:,:,490))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,470),heltab2x32(:,:,491))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,471),heltab2x32(:,:,492))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,472),heltab2x32(:,:,493))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,473),heltab2x32(:,:,494))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,474),heltab2x32(:,:,495))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,475),heltab2x32(:,:,496))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,476),heltab2x32(:,:,497))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,477),heltab2x32(:,:,498))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,478),heltab2x32(:,:,499))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,479),heltab2x32(:,:,500))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,480),heltab2x32(:,:,501))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,481),heltab2x32(:,:,502))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,482),heltab2x32(:,:,503))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,483),heltab2x32(:,:,504))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,484),heltab2x32(:,:,505))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,485),heltab2x32(:,:,506))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,486),heltab2x32(:,:,507))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,38))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,487),heltab2x32(:,:,508))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,488),heltab2x32(:,:,509))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,489),heltab2x32(:,:,510))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[16,2,13],[0,0,0],3,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,490),heltab2x32(:,:,511))
  call Hloop_Q_A(ntryL,G0H16(67),16,0,G1H16(64),n2h16(143))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[16,2,13],[0,nMZ,0],3,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,491),heltab2x32(:,:,512))
  call Hloop_Q_A(ntryL,G0H16(68),16,0,G1H16(65),n2h16(144))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[16,2,13],[nMW,0,nMW],3,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,492),heltab2x32(:,:,513))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[21,2,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,22),G0H4(5),m3h8x4(:,1),heltab2x32(:,:,514))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[21,2,8],[nMZ,0,0],3,1,wf8(:,22))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,22),G0H4(15),ngZl,m3h8x4(:,2),heltab2x32(:,:,515))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[21,2,8],[0,nMW,nMW],3,1,wf8(:,22))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,22),G0H4(13),m3h8x4(:,3),heltab2x32(:,:,516))
  call Hloop_Q_A(ntryL,G0H4(13),21,0,G1H4(62),n2h4(139))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[16,6,9],[0,0,0],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,493),heltab2x32(:,:,517))
  call Hloop_Q_A(ntryL,G0H16(69),16,0,G1H16(67),n2h16(145))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[16,6,9],[0,nMZ,0],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,494),heltab2x32(:,:,518))
  call Hloop_Q_A(ntryL,G0H16(70),16,0,G1H16(68),n2h16(146))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[16,6,9],[nMW,0,nMW],3,2,wf4(:,10),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,495),heltab2x32(:,:,519))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[17,6,8],[0,0,0],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(39),m3h4x8(:,22),heltab2x32(:,:,520))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[17,6,8],[nMZ,0,0],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(40),ngZl,m3h4x8(:,23),heltab2x32(:,:,521))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[17,6,8],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(41),m3h4x8(:,24),heltab2x32(:,:,522))
  call Hloop_Q_A(ntryL,G0H8(41),17,0,G1H8(38),n2h8(110))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[16,7,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,496),heltab2x32(:,:,523))
  call Hloop_A_Q(ntryL,G0H16(71),16,0,G1H16(70),n2h16(147))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,497),heltab2x32(:,:,524))
  call Hloop_A_Q(ntryL,G0H16(72),16,nMM,G1H16(81),n2h16(148))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[16,7,8],[nML,nML,nML],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,498),heltab2x32(:,:,525))
  call Hloop_A_Q(ntryL,G0H16(73),16,nML,G1H16(72),n2h16(149))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[16,7,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,499),heltab2x32(:,:,526))
  call Hloop_Q_A(ntryL,G0H16(74),16,0,G1H16(73),n2h16(150))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,500),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G0H16(75),16,nMM,G1H16(83),n2h16(151))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[16,7,8],[nML,nML,nML],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,501),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G0H16(76),16,nML,G1H16(75),n2h16(152))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[16,7,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,502),heltab2x32(:,:,529))
  call Hloop_A_Q(ntryL,G0H16(78),16,0,G1H16(76),n2h16(153))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,503),heltab2x32(:,:,530))
  call Hloop_A_Q(ntryL,G0H16(80),16,nMT,G1H16(78),n2h16(154))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[16,7,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,504),heltab2x32(:,:,531))
  call Hloop_Q_A(ntryL,G0H16(82),16,0,G1H16(80),n2h16(155))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,505),heltab2x32(:,:,532))
  call Hloop_Q_A(ntryL,G0H16(84),16,nMT,G1H16(82),n2h16(156))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[16,7,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,506),heltab2x32(:,:,533))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(84),n2h16(157))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,507),heltab2x32(:,:,534))
  call Hloop_A_Q(ntryL,G0H16(86),16,nMB,G1H16(85),n2h16(158))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[16,7,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,508),heltab2x32(:,:,535))
  call Hloop_Q_A(ntryL,G0H16(87),16,0,G1H16(86),n2h16(159))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,509),heltab2x32(:,:,536))
  call Hloop_Q_A(ntryL,G0H16(88),16,nMB,G1H16(87),n2h16(160))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[16,7,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,510),heltab2x32(:,:,537))
  call Hloop_A_Q(ntryL,G0H16(89),16,0,G1H16(88),n2h16(161))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,511),heltab2x32(:,:,538))
  call Hloop_A_Q(ntryL,G0H16(90),16,nMM,G1H16(89),n2h16(162))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[16,7,8],[nML,nML,nML],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,512),heltab2x32(:,:,539))
  call Hloop_A_Q(ntryL,G0H16(91),16,nML,G1H16(90),n2h16(163))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[16,7,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,513),heltab2x32(:,:,540))
  call Hloop_Q_A(ntryL,G0H16(92),16,0,G1H16(91),n2h16(164))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[16,7,8],[nMM,nMM,nMM],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,514),heltab2x32(:,:,541))
  call Hloop_Q_A(ntryL,G0H16(93),16,nMM,G1H16(92),n2h16(165))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[16,7,8],[nML,nML,nML],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,515),heltab2x32(:,:,542))
  call Hloop_Q_A(ntryL,G0H16(94),16,nML,G1H16(93),n2h16(166))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[16,7,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,516),heltab2x32(:,:,543))
  call Hloop_A_Q(ntryL,G0H16(95),16,0,G1H16(94),n2h16(167))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,517),heltab2x32(:,:,544))
  call Hloop_A_Q(ntryL,G0H16(96),16,nMT,G1H16(95),n2h16(168))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[16,7,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,518),heltab2x32(:,:,545))
  call Hloop_Q_A(ntryL,G0H16(97),16,0,G1H16(96),n2h16(169))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,519),heltab2x32(:,:,546))
  call Hloop_Q_A(ntryL,G0H16(98),16,nMT,G1H16(97),n2h16(170))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[16,7,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,520),heltab2x32(:,:,547))
  call Hloop_A_Q(ntryL,G0H16(99),16,0,G1H16(98),n2h16(171))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,521),heltab2x32(:,:,548))
  call Hloop_A_Q(ntryL,G0H16(100),16,nMB,G1H16(99),n2h16(172))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[16,7,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,522),heltab2x32(:,:,549))
  call Hloop_Q_A(ntryL,G0H16(101),16,0,G1H16(100),n2h16(173))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,523),heltab2x32(:,:,550))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(101),n2h16(174))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,524),heltab2x32(:,:,551))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,525),heltab2x32(:,:,552))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,526),heltab2x32(:,:,553))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,527),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(110),m3h2x16(:,528),heltab2x32(:,:,555))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,529),heltab2x32(:,:,556))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(112),m3h2x16(:,530),heltab2x32(:,:,557))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,531),heltab2x32(:,:,558))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(114),m3h2x16(:,532),heltab2x32(:,:,559))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,533),heltab2x32(:,:,560))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(116),m3h2x16(:,534),heltab2x32(:,:,561))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,535),heltab2x32(:,:,562))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,536),heltab2x32(:,:,563))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,537),heltab2x32(:,:,564))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,538),heltab2x32(:,:,565))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,539),heltab2x32(:,:,566))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,540),heltab2x32(:,:,567))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,541),heltab2x32(:,:,568))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,542),heltab2x32(:,:,569))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,543),heltab2x32(:,:,570))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,544),heltab2x32(:,:,571))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,545),heltab2x32(:,:,572))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,546),heltab2x32(:,:,573))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,547),heltab2x32(:,:,574))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,548),heltab2x32(:,:,575))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,549),heltab2x32(:,:,576))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,550),heltab2x32(:,:,577))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,551),heltab2x32(:,:,578))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,552),heltab2x32(:,:,579))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,553),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,554),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,555),heltab2x32(:,:,582))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,556),heltab2x32(:,:,583))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,557),heltab2x32(:,:,584))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(128),m3h2x16(:,558),heltab2x32(:,:,585))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(129),m3h2x16(:,559),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,560),heltab2x32(:,:,587))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,561),heltab2x32(:,:,588))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,562),heltab2x32(:,:,589))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[16,7,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,563),heltab2x32(:,:,590))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[16,1,14],[0,0,0],3,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,564),heltab2x32(:,:,591))
  call Hloop_A_Q(ntryL,G0H16(31),16,0,G1H16(130),n2h16(175))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[16,1,14],[0,nMZ,0],3,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,565),heltab2x32(:,:,592))
  call Hloop_A_Q(ntryL,G0H16(32),16,0,G1H16(131),n2h16(176))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[16,1,14],[nMW,0,nMW],3,1,wf8(:,30))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,566),heltab2x32(:,:,593))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[22,1,8],[0,0,0],3,1,wf8(:,27))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,27),G0H4(16),m3h8x4(:,4),heltab2x32(:,:,594))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[22,1,8],[nMZ,0,0],3,1,wf8(:,27))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,27),G0H4(14),ngZl,m3h8x4(:,5),heltab2x32(:,:,595))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[22,1,8],[0,nMW,nMW],3,1,wf8(:,27))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(20),m3h8x4(:,6),heltab2x32(:,:,596))
  call Hloop_A_Q(ntryL,G0H4(20),22,0,G1H4(67),n2h4(140))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[18,4,9],[0,0,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(41),m3h4x8(:,25),heltab2x32(:,:,597))
  call Hloop_A_Q(ntryL,G0H8(41),18,0,G1H8(39),n2h8(111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[18,4,9],[0,0,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(41),ngZl,m3h4x8(:,26),heltab2x32(:,:,598))
  call Hloop_A_Q(ntryL,G0H8(41),18,0,G1H8(40),n2h8(112))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[18,4,9],[nMW,nMW,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(41),m3h4x8(:,27),heltab2x32(:,:,599))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,567),heltab2x32(:,:,600))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(133),n2h16(177))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,568),heltab2x32(:,:,601))
  call Hloop_Q_A(ntryL,G0H16(34),16,nMM,G1H16(134),n2h16(178))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[16,4,11],[nML,nML,nML],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,569),heltab2x32(:,:,602))
  call Hloop_Q_A(ntryL,G0H16(35),16,nML,G1H16(135),n2h16(179))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,570),heltab2x32(:,:,603))
  call Hloop_A_Q(ntryL,G0H16(36),16,0,G1H16(136),n2h16(180))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,571),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G0H16(37),16,nMM,G1H16(137),n2h16(181))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[16,4,11],[nML,nML,nML],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,572),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G0H16(38),16,nML,G1H16(138),n2h16(182))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,573),heltab2x32(:,:,606))
  call Hloop_Q_A(ntryL,G0H16(39),16,0,G1H16(149),n2h16(183))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,574),heltab2x32(:,:,607))
  call Hloop_Q_A(ntryL,G0H16(40),16,nMT,G1H16(140),n2h16(184))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,575),heltab2x32(:,:,608))
  call Hloop_A_Q(ntryL,G0H16(41),16,0,G1H16(141),n2h16(185))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,576),heltab2x32(:,:,609))
  call Hloop_A_Q(ntryL,G0H16(42),16,nMT,G1H16(151),n2h16(186))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,577),heltab2x32(:,:,610))
  call Hloop_Q_A(ntryL,G0H16(43),16,0,G1H16(143),n2h16(187))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,578),heltab2x32(:,:,611))
  call Hloop_Q_A(ntryL,G0H16(44),16,nMB,G1H16(144),n2h16(188))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,579),heltab2x32(:,:,612))
  call Hloop_A_Q(ntryL,G0H16(46),16,0,G1H16(146),n2h16(189))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,580),heltab2x32(:,:,613))
  call Hloop_A_Q(ntryL,G0H16(48),16,nMB,G1H16(148),n2h16(190))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,581),heltab2x32(:,:,614))
  call Hloop_Q_A(ntryL,G0H16(67),16,0,G1H16(150),n2h16(191))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,582),heltab2x32(:,:,615))
  call Hloop_Q_A(ntryL,G0H16(68),16,nMM,G1H16(152),n2h16(192))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[16,4,11],[nML,nML,nML],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,583),heltab2x32(:,:,616))
  call Hloop_Q_A(ntryL,G0H16(69),16,nML,G1H16(153),n2h16(193))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,584),heltab2x32(:,:,617))
  call Hloop_A_Q(ntryL,G0H16(70),16,0,G1H16(154),n2h16(194))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,585),heltab2x32(:,:,618))
  call Hloop_A_Q(ntryL,G0H16(71),16,nMM,G1H16(155),n2h16(195))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[16,4,11],[nML,nML,nML],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,586),heltab2x32(:,:,619))
  call Hloop_A_Q(ntryL,G0H16(72),16,nML,G1H16(156),n2h16(196))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,587),heltab2x32(:,:,620))
  call Hloop_Q_A(ntryL,G0H16(73),16,0,G1H16(157),n2h16(197))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,588),heltab2x32(:,:,621))
  call Hloop_Q_A(ntryL,G0H16(74),16,nMT,G1H16(158),n2h16(198))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,589),heltab2x32(:,:,622))
  call Hloop_A_Q(ntryL,G0H16(75),16,0,G1H16(159),n2h16(199))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,590),heltab2x32(:,:,623))
  call Hloop_A_Q(ntryL,G0H16(76),16,nMT,G1H16(160),n2h16(200))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,591),heltab2x32(:,:,624))
  call Hloop_Q_A(ntryL,G0H16(78),16,0,G1H16(161),n2h16(201))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,592),heltab2x32(:,:,625))
  call Hloop_Q_A(ntryL,G0H16(80),16,nMB,G1H16(162),n2h16(202))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,593),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G0H16(82),16,0,G1H16(163),n2h16(203))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,594),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G0H16(84),16,nMB,G1H16(164),n2h16(204))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(165),m3h2x16(:,595),heltab2x32(:,:,628))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(166),m3h2x16(:,596),heltab2x32(:,:,629))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,597),heltab2x32(:,:,630))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,598),heltab2x32(:,:,631))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,599),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(170),m3h2x16(:,600),heltab2x32(:,:,633))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,601),heltab2x32(:,:,634))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(174),m3h2x16(:,602),heltab2x32(:,:,635))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,603),heltab2x32(:,:,636))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(178),m3h2x16(:,604),heltab2x32(:,:,637))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(179),m3h2x16(:,605),heltab2x32(:,:,638))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(180),m3h2x16(:,606),heltab2x32(:,:,639))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(181),m3h2x16(:,607),heltab2x32(:,:,640))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(182),m3h2x16(:,608),heltab2x32(:,:,641))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,609),heltab2x32(:,:,642))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(184),m3h2x16(:,610),heltab2x32(:,:,643))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,611),heltab2x32(:,:,644))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,612),heltab2x32(:,:,645))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,613),heltab2x32(:,:,646))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,614),heltab2x32(:,:,647))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,615),heltab2x32(:,:,648))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(186),m3h2x16(:,616),heltab2x32(:,:,649))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(187),m3h2x16(:,617),heltab2x32(:,:,650))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(188),m3h2x16(:,618),heltab2x32(:,:,651))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,619),heltab2x32(:,:,652))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,620),heltab2x32(:,:,653))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,621),heltab2x32(:,:,654))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,622),heltab2x32(:,:,655))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,623),heltab2x32(:,:,656))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,624),heltab2x32(:,:,657))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,625),heltab2x32(:,:,658))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,626),heltab2x32(:,:,659))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(189),m3h2x16(:,627),heltab2x32(:,:,660))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(190),m3h2x16(:,628),heltab2x32(:,:,661))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(191),m3h2x16(:,629),heltab2x32(:,:,662))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(192),m3h2x16(:,630),heltab2x32(:,:,663))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,631),heltab2x32(:,:,664))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,632),heltab2x32(:,:,665))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,633),heltab2x32(:,:,666))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,634),heltab2x32(:,:,667))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[16,2,13],[0,0,0],3,1,wf8(:,34))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,635),heltab2x32(:,:,668))
  call Hloop_Q_A(ntryL,G0H16(101),16,0,G1H16(193),n2h16(205))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[16,2,13],[0,nMZ,0],3,1,wf8(:,34))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,636),heltab2x32(:,:,669))
  call Hloop_Q_A(ntryL,G0H16(102),16,0,G1H16(194),n2h16(206))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[16,2,13],[nMW,0,nMW],3,1,wf8(:,34))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(195),m3h2x16(:,637),heltab2x32(:,:,670))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[25,2,4],[0,0,0],3,1,wf8(:,28))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,28),G0H4(19),m3h8x4(:,7),heltab2x32(:,:,671))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[25,2,4],[nMZ,0,0],3,1,wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,28),G0H4(18),ngZl,m3h8x4(:,8),heltab2x32(:,:,672))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[25,2,4],[0,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(17),m3h8x4(:,9),heltab2x32(:,:,673))
  call Hloop_Q_A(ntryL,G0H4(17),25,0,G1H4(68),n2h4(141))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[17,4,10],[0,0,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(42),m3h4x8(:,28),heltab2x32(:,:,674))
  call Hloop_Q_A(ntryL,G0H8(42),17,0,G1H8(41),n2h8(113))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[17,4,10],[0,0,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(42),ngZl,m3h4x8(:,29),heltab2x32(:,:,675))
  call Hloop_Q_A(ntryL,G0H8(42),17,0,G1H8(42),n2h8(114))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[17,4,10],[nMW,nMW,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(42),m3h4x8(:,30),heltab2x32(:,:,676))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[16,4,11],[0,0,0],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,638),heltab2x32(:,:,677))
  call Hloop_Q_A(ntryL,G0H16(31),16,0,G1H16(196),n2h16(207))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,639),heltab2x32(:,:,678))
  call Hloop_Q_A(ntryL,G0H16(32),16,nMM,G1H16(197),n2h16(208))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[16,4,11],[nML,nML,nML],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,640),heltab2x32(:,:,679))
  call Hloop_Q_A(ntryL,G0H16(33),16,nML,G1H16(198),n2h16(209))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[16,4,11],[0,0,0],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,641),heltab2x32(:,:,680))
  call Hloop_A_Q(ntryL,G0H16(34),16,0,G1H16(199),n2h16(210))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,642),heltab2x32(:,:,681))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMM,G1H16(200),n2h16(211))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[16,4,11],[nML,nML,nML],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,643),heltab2x32(:,:,682))
  call Hloop_A_Q(ntryL,G0H16(36),16,nML,G1H16(201),n2h16(212))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[16,4,11],[0,0,0],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,644),heltab2x32(:,:,683))
  call Hloop_Q_A(ntryL,G0H16(37),16,0,G1H16(202),n2h16(213))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,645),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G0H16(38),16,nMT,G1H16(203),n2h16(214))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[16,4,11],[0,0,0],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,646),heltab2x32(:,:,685))
  call Hloop_A_Q(ntryL,G0H16(39),16,0,G1H16(204),n2h16(215))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,647),heltab2x32(:,:,686))
  call Hloop_A_Q(ntryL,G0H16(40),16,nMT,G1H16(205),n2h16(216))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[16,4,11],[0,0,0],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,648),heltab2x32(:,:,687))
  call Hloop_Q_A(ntryL,G0H16(41),16,0,G1H16(206),n2h16(217))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,649),heltab2x32(:,:,688))
  call Hloop_Q_A(ntryL,G0H16(42),16,nMB,G1H16(207),n2h16(218))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[16,4,11],[0,0,0],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,650),heltab2x32(:,:,689))
  call Hloop_A_Q(ntryL,G0H16(43),16,0,G1H16(208),n2h16(219))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,651),heltab2x32(:,:,690))
  call Hloop_A_Q(ntryL,G0H16(44),16,nMB,G1H16(209),n2h16(220))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[16,4,11],[0,0,0],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,652),heltab2x32(:,:,691))
  call Hloop_Q_A(ntryL,G0H16(46),16,0,G1H16(210),n2h16(221))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,653),heltab2x32(:,:,692))
  call Hloop_Q_A(ntryL,G0H16(48),16,nMM,G1H16(211),n2h16(222))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[16,4,11],[nML,nML,nML],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,654),heltab2x32(:,:,693))
  call Hloop_Q_A(ntryL,G0H16(67),16,nML,G1H16(212),n2h16(223))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[16,4,11],[0,0,0],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,655),heltab2x32(:,:,694))
  call Hloop_A_Q(ntryL,G0H16(68),16,0,G1H16(213),n2h16(224))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[16,4,11],[nMM,nMM,nMM],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,656),heltab2x32(:,:,695))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMM,G1H16(214),n2h16(225))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[16,4,11],[nML,nML,nML],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,657),heltab2x32(:,:,696))
  call Hloop_A_Q(ntryL,G0H16(70),16,nML,G1H16(215),n2h16(226))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[16,4,11],[0,0,0],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,658),heltab2x32(:,:,697))
  call Hloop_Q_A(ntryL,G0H16(71),16,0,G1H16(216),n2h16(227))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,659),heltab2x32(:,:,698))
  call Hloop_Q_A(ntryL,G0H16(72),16,nMT,G1H16(217),n2h16(228))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[16,4,11],[0,0,0],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,660),heltab2x32(:,:,699))
  call Hloop_A_Q(ntryL,G0H16(73),16,0,G1H16(218),n2h16(229))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,661),heltab2x32(:,:,700))
  call Hloop_A_Q(ntryL,G0H16(74),16,nMT,G1H16(219),n2h16(230))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[16,4,11],[0,0,0],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,662),heltab2x32(:,:,701))
  call Hloop_Q_A(ntryL,G0H16(75),16,0,G1H16(220),n2h16(231))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,45))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,663),heltab2x32(:,:,702))
  call Hloop_Q_A(ntryL,G0H16(76),16,nMB,G1H16(221),n2h16(232))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[16,4,11],[0,0,0],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,664),heltab2x32(:,:,703))
  call Hloop_A_Q(ntryL,G0H16(78),16,0,G1H16(222),n2h16(233))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,665),heltab2x32(:,:,704))
  call Hloop_A_Q(ntryL,G0H16(80),16,nMB,G1H16(223),n2h16(234))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,666),heltab2x32(:,:,705))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(225),m3h2x16(:,667),heltab2x32(:,:,706))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(226),m3h2x16(:,668),heltab2x32(:,:,707))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,669),heltab2x32(:,:,708))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(228),m3h2x16(:,670),heltab2x32(:,:,709))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(229),m3h2x16(:,671),heltab2x32(:,:,710))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,672),heltab2x32(:,:,711))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(231),m3h2x16(:,673),heltab2x32(:,:,712))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,674),heltab2x32(:,:,713))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(233),m3h2x16(:,675),heltab2x32(:,:,714))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(234),m3h2x16(:,676),heltab2x32(:,:,715))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(235),m3h2x16(:,677),heltab2x32(:,:,716))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(236),m3h2x16(:,678),heltab2x32(:,:,717))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(237),m3h2x16(:,679),heltab2x32(:,:,718))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(238),m3h2x16(:,680),heltab2x32(:,:,719))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,681),heltab2x32(:,:,720))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,682),heltab2x32(:,:,721))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,683),heltab2x32(:,:,722))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,684),heltab2x32(:,:,723))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,685),heltab2x32(:,:,724))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(240),m3h2x16(:,686),heltab2x32(:,:,725))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(241),m3h2x16(:,687),heltab2x32(:,:,726))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(242),m3h2x16(:,688),heltab2x32(:,:,727))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(243),m3h2x16(:,689),heltab2x32(:,:,728))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,690),heltab2x32(:,:,729))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,691),heltab2x32(:,:,730))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,692),heltab2x32(:,:,731))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,693),heltab2x32(:,:,732))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,694),heltab2x32(:,:,733))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,695),heltab2x32(:,:,734))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,696),heltab2x32(:,:,735))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,697),heltab2x32(:,:,736))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(244),m3h2x16(:,698),heltab2x32(:,:,737))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(245),m3h2x16(:,699),heltab2x32(:,:,738))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(246),m3h2x16(:,700),heltab2x32(:,:,739))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(247),m3h2x16(:,701),heltab2x32(:,:,740))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,702),heltab2x32(:,:,741))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,703),heltab2x32(:,:,742))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,704),heltab2x32(:,:,743))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,45))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,705),heltab2x32(:,:,744))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[16,1,14],[0,0,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,706),heltab2x32(:,:,745))
  call Hloop_A_Q(ntryL,G0H16(43),16,0,G1H16(248),n2h16(235))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[16,1,14],[0,nMZ,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,707),heltab2x32(:,:,746))
  call Hloop_A_Q(ntryL,G0H16(44),16,0,G1H16(249),n2h16(236))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[16,1,14],[nMW,0,nMW],3,1,wf8(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(250),m3h2x16(:,708),heltab2x32(:,:,747))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[26,1,4],[0,0,0],3,1,wf8(:,21))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,21),G0H4(26),m3h8x4(:,10),heltab2x32(:,:,748))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[26,1,4],[nMZ,0,0],3,1,wf8(:,21))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,21),G0H4(27),ngZl,m3h8x4(:,11),heltab2x32(:,:,749))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[26,1,4],[0,nMW,nMW],3,1,wf8(:,21))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,21),G0H4(28),m3h8x4(:,12),heltab2x32(:,:,750))
  call Hloop_A_Q(ntryL,G0H4(28),26,0,G1H4(73),n2h4(142))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(29),m3h8x4(:,13),heltab2x32(:,:,751))
  call Hloop_A_Q(ntryL,G0H4(29),19,0,G1H4(77),n2h4(143))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(30),m3h8x4(:,14),heltab2x32(:,:,752))
  call Hloop_A_Q(ntryL,G0H4(30),19,nMM,G1H4(78),n2h4(144))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[19,4,8],[nML,nML,nML],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(31),m3h8x4(:,15),heltab2x32(:,:,753))
  call Hloop_A_Q(ntryL,G0H4(31),19,nML,G1H4(90),n2h4(145))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(32),m3h8x4(:,16),heltab2x32(:,:,754))
  call Hloop_Q_A(ntryL,G0H4(32),19,0,G1H4(84),n2h4(146))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(13),m3h8x4(:,17),heltab2x32(:,:,755))
  call Hloop_Q_A(ntryL,G0H4(13),19,nMM,G1H4(89),n2h4(147))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[19,4,8],[nML,nML,nML],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(20),m3h8x4(:,18),heltab2x32(:,:,756))
  call Hloop_Q_A(ntryL,G0H4(20),19,nML,G1H4(93),n2h4(148))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(17),m3h8x4(:,19),heltab2x32(:,:,757))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(3),n2h4(149))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(28),m3h8x4(:,20),heltab2x32(:,:,758))
  call Hloop_A_Q(ntryL,G0H4(28),19,nMT,G1H4(53),n2h4(150))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(29),m3h8x4(:,21),heltab2x32(:,:,759))
  call Hloop_Q_A(ntryL,G0H4(29),19,0,G1H4(49),n2h4(151))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(30),m3h8x4(:,22),heltab2x32(:,:,760))
  call Hloop_Q_A(ntryL,G0H4(30),19,nMT,G1H4(4),n2h4(152))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(31),m3h8x4(:,23),heltab2x32(:,:,761))
  call Hloop_A_Q(ntryL,G0H4(31),19,0,G1H4(50),n2h4(153))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,46))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,46),G0H4(32),m3h8x4(:,24),heltab2x32(:,:,762))
  call Hloop_A_Q(ntryL,G0H4(32),19,nMB,G1H4(65),n2h4(154))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(13),m3h8x4(:,25),heltab2x32(:,:,763))
  call Hloop_Q_A(ntryL,G0H4(13),19,0,G1H4(59),n2h4(155))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,46))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,46),G0H4(20),m3h8x4(:,26),heltab2x32(:,:,764))
  call Hloop_Q_A(ntryL,G0H4(20),19,nMB,G1H4(55),n2h4(156))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[19,4,8],[0,0,0],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(17),ngZl,m3h8x4(:,27),heltab2x32(:,:,765))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(60),n2h4(157))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(28),ngZl,m3h8x4(:,28),heltab2x32(:,:,766))
  call Hloop_A_Q(ntryL,G0H4(28),19,nMM,G1H4(56),n2h4(158))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[19,4,8],[nML,nML,nML],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(29),ngZl,m3h8x4(:,29),heltab2x32(:,:,767))
  call Hloop_A_Q(ntryL,G0H4(29),19,nML,G1H4(81),n2h4(159))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[19,4,8],[0,0,0],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(30),ngZl,m3h8x4(:,30),heltab2x32(:,:,768))
  call Hloop_Q_A(ntryL,G0H4(30),19,0,G1H4(75),n2h4(160))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(31),ngZl,m3h8x4(:,31),heltab2x32(:,:,769))
  call Hloop_Q_A(ntryL,G0H4(31),19,nMM,G1H4(82),n2h4(161))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[19,4,8],[nML,nML,nML],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(32),ngZl,m3h8x4(:,32),heltab2x32(:,:,770))
  call Hloop_Q_A(ntryL,G0H4(32),19,nML,G1H4(76),n2h4(162))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[19,4,8],[0,0,0],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(13),ngZu,m3h8x4(:,33),heltab2x32(:,:,771))
  call Hloop_A_Q(ntryL,G0H4(13),19,0,G1H4(72),n2h4(163))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(20),ngZu,m3h8x4(:,34),heltab2x32(:,:,772))
  call Hloop_A_Q(ntryL,G0H4(20),19,nMT,G1H4(87),n2h4(164))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[19,4,8],[0,0,0],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(17),ngZu,m3h8x4(:,35),heltab2x32(:,:,773))
  call Hloop_Q_A(ntryL,G0H4(17),19,0,G1H4(5),n2h4(165))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(28),ngZu,m3h8x4(:,36),heltab2x32(:,:,774))
  call Hloop_Q_A(ntryL,G0H4(28),19,nMT,G1H4(88),n2h4(166))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[19,4,8],[0,0,0],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(29),ngZd,m3h8x4(:,37),heltab2x32(:,:,775))
  call Hloop_A_Q(ntryL,G0H4(29),19,0,G1H4(80),n2h4(167))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,47))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,47),G0H4(30),ngZd,m3h8x4(:,38),heltab2x32(:,:,776))
  call Hloop_A_Q(ntryL,G0H4(30),19,nMB,G1H4(6),n2h4(168))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[19,4,8],[0,0,0],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(31),ngZd,m3h8x4(:,39),heltab2x32(:,:,777))
  call Hloop_Q_A(ntryL,G0H4(31),19,0,G1H4(43),n2h4(169))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,47))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,47),G0H4(32),ngZd,m3h8x4(:,40),heltab2x32(:,:,778))
  call Hloop_Q_A(ntryL,G0H4(32),19,nMB,G1H4(41),n2h4(170))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(96),m3h8x4(:,41),heltab2x32(:,:,779))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(44),m3h8x4(:,42),heltab2x32(:,:,780))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(15),m3h8x4(:,43),heltab2x32(:,:,781))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(7),m3h8x4(:,44),heltab2x32(:,:,782))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,46),G1H4(47),m3h8x4(:,45),heltab2x32(:,:,783))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(16),m3h8x4(:,46),heltab2x32(:,:,784))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,46),G1H4(48),m3h8x4(:,47),heltab2x32(:,:,785))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(1),m3h8x4(:,48),heltab2x32(:,:,786))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,47),G1H4(25),m3h8x4(:,49),heltab2x32(:,:,787))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(21),m3h8x4(:,50),heltab2x32(:,:,788))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,47),G1H4(26),m3h8x4(:,51),heltab2x32(:,:,789))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(22),m3h8x4(:,52),heltab2x32(:,:,790))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(37),m3h8x4(:,53),heltab2x32(:,:,791))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(31),m3h8x4(:,54),heltab2x32(:,:,792))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(38),m3h8x4(:,55),heltab2x32(:,:,793))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(32),m3h8x4(:,56),heltab2x32(:,:,794))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,46),G0H4(13),m3h8x4(:,57),heltab2x32(:,:,795))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,46),G0H4(20),m3h8x4(:,58),heltab2x32(:,:,796))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,47),G0H4(17),m3h8x4(:,59),heltab2x32(:,:,797))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,47),G0H4(28),m3h8x4(:,60),heltab2x32(:,:,798))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,46),G0H4(29),m3h8x4(:,61),heltab2x32(:,:,799))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,46),G0H4(30),m3h8x4(:,62),heltab2x32(:,:,800))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,47),G0H4(31),m3h8x4(:,63),heltab2x32(:,:,801))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,47),G0H4(32),m3h8x4(:,64),heltab2x32(:,:,802))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(28),m3h8x4(:,65),heltab2x32(:,:,803))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(11),m3h8x4(:,66),heltab2x32(:,:,804))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(17),m3h8x4(:,67),heltab2x32(:,:,805))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(100),m3h8x4(:,68),heltab2x32(:,:,806))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(113),m3h8x4(:,69),heltab2x32(:,:,807))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(114),m3h8x4(:,70),heltab2x32(:,:,808))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(39),m3h8x4(:,71),heltab2x32(:,:,809))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(102),m3h8x4(:,72),heltab2x32(:,:,810))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,46),G0H4(33),m3h8x4(:,73),heltab2x32(:,:,811))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,46),G0H4(34),m3h8x4(:,74),heltab2x32(:,:,812))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,47),G0H4(35),m3h8x4(:,75),heltab2x32(:,:,813))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,47),G0H4(36),m3h8x4(:,76),heltab2x32(:,:,814))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,46),G0H4(37),m3h8x4(:,77),heltab2x32(:,:,815))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,46))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,46),G0H4(38),m3h8x4(:,78),heltab2x32(:,:,816))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,47),G0H4(39),m3h8x4(:,79),heltab2x32(:,:,817))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,47))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,47),G0H4(40),m3h8x4(:,80),heltab2x32(:,:,818))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[21,2,8],[0,0,0],3,1,wf8(:,37))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,37),G0H4(41),m3h8x4(:,81),heltab2x32(:,:,819))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[21,2,8],[nMZ,0,0],3,1,wf8(:,37))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,37),G0H4(42),ngZl,m3h8x4(:,82),heltab2x32(:,:,820))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[21,2,8],[0,nMW,nMW],3,1,wf8(:,37))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(43),m3h8x4(:,83),heltab2x32(:,:,821))
  call Hloop_Q_A(ntryL,G0H4(43),21,0,G1H4(45),n2h4(171))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[25,2,4],[0,0,0],3,1,wf8(:,31))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,31),G0H4(43),m3h8x4(:,84),heltab2x32(:,:,822))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[25,2,4],[nMZ,0,0],3,1,wf8(:,31))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,31),G0H4(44),ngZl,m3h8x4(:,85),heltab2x32(:,:,823))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[25,2,4],[0,nMW,nMW],3,1,wf8(:,31))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,31),G0H4(45),m3h8x4(:,86),heltab2x32(:,:,824))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(103),n2h4(172))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[19,4,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,87),heltab2x32(:,:,825))
  call Hloop_A_Q(ntryL,G0H4(45),19,0,G1H4(118),n2h4(173))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,88),heltab2x32(:,:,826))
  call Hloop_A_Q(ntryL,G0H4(45),19,nMM,G1H4(120),n2h4(174))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[19,4,8],[nML,nML,nML],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,89),heltab2x32(:,:,827))
  call Hloop_A_Q(ntryL,G0H4(45),19,nML,G1H4(105),n2h4(175))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[19,4,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,90),heltab2x32(:,:,828))
  call Hloop_Q_A(ntryL,G0H4(45),19,0,G1H4(106),n2h4(176))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,91),heltab2x32(:,:,829))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMM,G1H4(109),n2h4(177))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[19,4,8],[nML,nML,nML],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,92),heltab2x32(:,:,830))
  call Hloop_Q_A(ntryL,G0H4(45),19,nML,G1H4(110),n2h4(178))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[19,4,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,93),heltab2x32(:,:,831))
  call Hloop_A_Q(ntryL,G0H4(45),19,0,G1H4(112),n2h4(179))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,94),heltab2x32(:,:,832))
  call Hloop_A_Q(ntryL,G0H4(45),19,nMT,G1H4(13),n2h4(180))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[19,4,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,95),heltab2x32(:,:,833))
  call Hloop_Q_A(ntryL,G0H4(45),19,0,G1H4(121),n2h4(181))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,96),heltab2x32(:,:,834))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(122),n2h4(182))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[19,4,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,97),heltab2x32(:,:,835))
  call Hloop_A_Q(ntryL,G0H4(45),19,0,G1H4(123),n2h4(183))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,98),heltab2x32(:,:,836))
  call Hloop_A_Q(ntryL,G0H4(45),19,nMB,G1H4(124),n2h4(184))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[19,4,8],[0,0,0],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,99),heltab2x32(:,:,837))
  call Hloop_Q_A(ntryL,G0H4(45),19,0,G1H4(126),n2h4(185))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,48))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,100),heltab2x32(:,:,838))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMB,G1H4(127),n2h4(186))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[19,4,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZl,m3h8x4(:,101),heltab2x32(:,:,839))
  call Hloop_A_Q(ntryL,G0H4(45),19,0,G1H4(128),n2h4(187))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZl,m3h8x4(:,102),heltab2x32(:,:,840))
  call Hloop_A_Q(ntryL,G0H4(45),19,nMM,G1H4(129),n2h4(188))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[19,4,8],[nML,nML,nML],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZl,m3h8x4(:,103),heltab2x32(:,:,841))
  call Hloop_A_Q(ntryL,G0H4(45),19,nML,G1H4(131),n2h4(189))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[19,4,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZl,m3h8x4(:,104),heltab2x32(:,:,842))
  call Hloop_Q_A(ntryL,G0H4(45),19,0,G1H4(132),n2h4(190))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZl,m3h8x4(:,105),heltab2x32(:,:,843))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMM,G1H4(63),n2h4(191))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[19,4,8],[nML,nML,nML],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZl,m3h8x4(:,106),heltab2x32(:,:,844))
  call Hloop_Q_A(ntryL,G0H4(45),19,nML,G1H4(64),n2h4(192))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[19,4,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZu,m3h8x4(:,107),heltab2x32(:,:,845))
  call Hloop_A_Q(ntryL,G0H4(45),19,0,G1H4(70),n2h4(193))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZu,m3h8x4(:,108),heltab2x32(:,:,846))
  call Hloop_A_Q(ntryL,G0H4(45),19,nMT,G1H4(85),n2h4(194))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[19,4,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZu,m3h8x4(:,109),heltab2x32(:,:,847))
  call Hloop_Q_A(ntryL,G0H4(45),19,0,G1H4(86),n2h4(195))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZu,m3h8x4(:,110),heltab2x32(:,:,848))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(91),n2h4(196))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[19,4,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZd,m3h8x4(:,111),heltab2x32(:,:,849))
  call Hloop_A_Q(ntryL,G0H4(45),19,0,G1H4(133),n2h4(197))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,49))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZd,m3h8x4(:,112),heltab2x32(:,:,850))
  call Hloop_A_Q(ntryL,G0H4(45),19,nMB,G1H4(134),n2h4(198))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[19,4,8],[0,0,0],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZd,m3h8x4(:,113),heltab2x32(:,:,851))
  call Hloop_Q_A(ntryL,G0H4(45),19,0,G1H4(135),n2h4(199))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,49))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,49),G0H4(45),ngZd,m3h8x4(:,114),heltab2x32(:,:,852))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMB,G1H4(136),n2h4(200))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(138),m3h8x4(:,115),heltab2x32(:,:,853))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(139),m3h8x4(:,116),heltab2x32(:,:,854))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(140),m3h8x4(:,117),heltab2x32(:,:,855))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(141),m3h8x4(:,118),heltab2x32(:,:,856))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,48),G1H4(143),m3h8x4(:,119),heltab2x32(:,:,857))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(144),m3h8x4(:,120),heltab2x32(:,:,858))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,48),G1H4(145),m3h8x4(:,121),heltab2x32(:,:,859))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(146),m3h8x4(:,122),heltab2x32(:,:,860))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,49),G1H4(148),m3h8x4(:,123),heltab2x32(:,:,861))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(149),m3h8x4(:,124),heltab2x32(:,:,862))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,49),G1H4(150),m3h8x4(:,125),heltab2x32(:,:,863))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(151),m3h8x4(:,126),heltab2x32(:,:,864))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(153),m3h8x4(:,127),heltab2x32(:,:,865))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(154),m3h8x4(:,128),heltab2x32(:,:,866))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(155),m3h8x4(:,129),heltab2x32(:,:,867))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(156),m3h8x4(:,130),heltab2x32(:,:,868))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,48),G0H4(45),m3h8x4(:,131),heltab2x32(:,:,869))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,48),G0H4(46),m3h8x4(:,132),heltab2x32(:,:,870))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,49),G0H4(47),m3h8x4(:,133),heltab2x32(:,:,871))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,49),G0H4(48),m3h8x4(:,134),heltab2x32(:,:,872))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,48),G0H4(49),m3h8x4(:,135),heltab2x32(:,:,873))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,48),G0H4(50),m3h8x4(:,136),heltab2x32(:,:,874))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,49),G0H4(51),m3h8x4(:,137),heltab2x32(:,:,875))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,49),G0H4(52),m3h8x4(:,138),heltab2x32(:,:,876))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(158),m3h8x4(:,139),heltab2x32(:,:,877))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(159),m3h8x4(:,140),heltab2x32(:,:,878))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(160),m3h8x4(:,141),heltab2x32(:,:,879))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(161),m3h8x4(:,142),heltab2x32(:,:,880))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(163),m3h8x4(:,143),heltab2x32(:,:,881))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(164),m3h8x4(:,144),heltab2x32(:,:,882))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(165),m3h8x4(:,145),heltab2x32(:,:,883))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(166),m3h8x4(:,146),heltab2x32(:,:,884))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,48),G0H4(53),m3h8x4(:,147),heltab2x32(:,:,885))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,48),G0H4(54),m3h8x4(:,148),heltab2x32(:,:,886))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,49),G0H4(55),m3h8x4(:,149),heltab2x32(:,:,887))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,49),G0H4(56),m3h8x4(:,150),heltab2x32(:,:,888))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,48),G0H4(57),m3h8x4(:,151),heltab2x32(:,:,889))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,48))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,48),G0H4(58),m3h8x4(:,152),heltab2x32(:,:,890))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,49),G0H4(59),m3h8x4(:,153),heltab2x32(:,:,891))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,49))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,49),G0H4(60),m3h8x4(:,154),heltab2x32(:,:,892))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[22,1,8],[0,0,0],3,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,33),G0H4(61),m3h8x4(:,155),heltab2x32(:,:,893))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[22,1,8],[nMZ,0,0],3,1,wf8(:,33))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,33),G0H4(62),ngZl,m3h8x4(:,156),heltab2x32(:,:,894))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[22,1,8],[0,nMW,nMW],3,1,wf8(:,33))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(63),m3h8x4(:,157),heltab2x32(:,:,895))
  call Hloop_A_Q(ntryL,G0H4(63),22,0,G1H4(168),n2h4(201))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[26,1,4],[0,0,0],3,1,wf8(:,24))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,24),G0H4(63),m3h8x4(:,158),heltab2x32(:,:,896))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[26,1,4],[nMZ,0,0],3,1,wf8(:,24))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,24),G0H4(64),ngZl,m3h8x4(:,159),heltab2x32(:,:,897))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[26,1,4],[0,nMW,nMW],3,1,wf8(:,24))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,24),G0H4(65),m3h8x4(:,160),heltab2x32(:,:,898))
  call Hloop_A_Q(ntryL,G0H4(65),26,0,G1H4(169),n2h4(202))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(86),G1H4(132),G1H4(126),G1H4(121),G1H4(106) &
    ,G1H4(43),G1H4(5),G1H4(75),G1H4(59),G1H4(49),G1H4(84),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(154),G1H4(32),G1H4(31),G1H4(74),G0H4(12) &
    ,G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(70),G1H4(128),G1H4(123),G1H4(112),G1H4(118) &
    ,G1H4(80),G1H4(72),G1H4(60),G1H4(50),G1H4(3),G1H4(77),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(155),[G1H4(153),G1H4(38),G1H4(37),G1H4(66),G0H4(21) &
    ,G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(120),G1H4(56),G1H4(78),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(105),G1H4(81),G1H4(90),G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(109),G1H4(82),G1H4(89),G1H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(110),G1H4(76),G1H4(93),G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(13),G1H4(87),G1H4(53),G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(122),G1H4(88),G1H4(4),G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(124),G1H4(6),G1H4(65),G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(127),G1H4(41),G1H4(55),G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(138),G1H4(15),G1H4(96),G1H4(167),G0H4(22) &
    ,G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(139),G1H4(7),G1H4(44),G1H4(172),G0H4(11) &
    ,G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(148),G1H4(145),G1H4(143),G1H4(26),G1H4(25) &
    ,G1H4(48),G1H4(47),G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(149),G1H4(146),G1H4(144),G1H4(22),G1H4(21) &
    ,G1H4(1),G1H4(16),G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(156),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(161),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(166),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(191),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(196),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(201),[G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(206),[G0H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G0H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(161),[G1H4(160),G1H4(159),G1H4(158),G1H4(100),G1H4(17) &
    ,G1H4(11),G1H4(28),G0H4(4),G0H4(1),G0H4(3),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(165),G1H4(164),G1H4(163),G1H4(102),G1H4(39) &
    ,G1H4(114),G1H4(113),G0H4(6),G0H4(7),G0H4(8),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(15),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(19),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(47),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(51),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(2),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(79),[G0H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(83),[G0H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(6),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(8),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(26),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(28),[G0H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(30),[G0H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(32),[G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(10),[G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(2),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(4),[G0H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(12),G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(16),G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(63),[G1H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(41),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(42),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(76),G1H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(80),G1H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(112),[G1H16(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(113),[G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(116),[G1H16(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(117),[G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(123),[G1H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(125),[G1H16(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(127),[G1H16(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(129),[G1H16(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(61),[G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(62),[G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(143),[G1H16(149),G1H16(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(146),[G1H16(141),G1H16(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(173),[G1H16(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(174),[G1H16(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(179),[G1H16(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(180),[G1H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(186),[G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(190),[G1H16(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(192),[G1H16(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(43),[G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(44),[G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(206),[G1H16(202),G1H16(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(208),[G1H16(204),G1H16(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(230),[G1H16(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(231),[G1H16(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(234),[G1H16(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(235),[G1H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(241),[G1H16(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(243),[G1H16(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(245),[G1H16(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(247),[G1H16(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(63),[G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(64),[G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(47),[G0H4(45),G0H4(17),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(48),[G0H4(46),G0H4(28),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(51),[G0H4(49),G0H4(31),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(52),[G0H4(50),G0H4(32),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(55),[G0H4(53),G0H4(35),G0H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(56),[G0H4(54),G0H4(36),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(59),[G0H4(57),G0H4(39),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(60),[G0H4(58),G0H4(40),G0H4(38)])
  call Hloop_WQ_A(ntryL,G1H4(23),ex1(:),G1H2(202),m3h2x2(:,305),heltab2x4(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(202),29,0,G2H2(328),n2h2(243))
  call Hloop_WA_Q(ntryL,G1H4(34),ex2(:),G1H2(205),m3h2x2(:,306),heltab2x4(:,:,322))
  call Hloop_A_Q(ntryL,G1H2(205),30,0,G2H2(12),n2h2(244))
  call Hloop_QV_A(ntryL,G1H4(135),ex3(:),G1H2(206),m3h2x2(:,307),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(206),23,0,G2H2(325),n2h2(245))
  call Hloop_UV_W(ntryL,G1H4(156),19,ex3(:),4,G2H2(15),m3h2x2(:,308),heltab2x4(:,:,324))
  call Hloop_QV_A(ntryL,G1H4(83),ex4(:),G1H2(41),m3h2x2(:,309),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(41),27,0,G2H2(283),n2h2(246))
  call Hloop_UV_W(ntryL,G1H4(94),19,ex4(:),8,G2H2(268),m3h2x2(:,310),heltab2x4(:,:,326))
  call Hloop_AV_Q(ntryL,G1H4(133),ex3(:),G1H2(35),m3h2x2(:,311),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(35),23,0,G2H2(238),n2h2(247))
  call Hloop_UW_V(ntryL,G1H4(155),19,ex3(:),4,G2H2(23),m3h2x2(:,312),heltab2x4(:,:,328))
  call Hloop_AV_Q(ntryL,G1H4(71),ex4(:),G1H2(34),m3h2x2(:,313),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(34),27,0,G2H2(19),n2h2(248))
  call Hloop_UW_V(ntryL,G1H4(79),19,ex4(:),8,G2H2(27),m3h2x2(:,314),heltab2x4(:,:,330))
  call Hloop_QV_A(ntryL,G1H4(95),ex4(:),G1H2(16),m3h2x2(:,315),heltab2x4(:,:,331))
  call Hloop_Q_A(ntryL,G1H2(16),27,nMM,G2H2(31),n2h2(249))
  call Hloop_QV_A(ntryL,G1H4(42),ex4(:),G1H2(38),m3h2x2(:,316),heltab2x4(:,:,332))
  call Hloop_Q_A(ntryL,G1H2(38),27,nML,G2H2(35),n2h2(250))
  call Hloop_AV_Q(ntryL,G1H4(8),ex4(:),G1H2(60),m3h2x2(:,317),heltab2x4(:,:,333))
  call Hloop_A_Q(ntryL,G1H2(60),27,nMM,G2H2(277),n2h2(251))
  call Hloop_AV_Q(ntryL,G1H4(2),ex4(:),G1H2(182),m3h2x2(:,318),heltab2x4(:,:,334))
  call Hloop_A_Q(ntryL,G1H2(182),27,nML,G2H2(259),n2h2(252))
  call Hloop_QV_A(ntryL,G1H4(27),ex4(:),G1H2(71),m3h2x2(:,319),heltab2x4(:,:,335))
  call Hloop_Q_A(ntryL,G1H2(71),27,nMT,G2H2(229),n2h2(253))
  call Hloop_AV_Q(ntryL,G1H4(99),ex4(:),G1H2(80),m3h2x2(:,320),heltab2x4(:,:,336))
  call Hloop_A_Q(ntryL,G1H2(80),27,nMT,G2H2(43),n2h2(254))
  call Hloop_QV_A(ntryL,G1H4(116),ex4(:),G1H2(104),m3h2x2(:,321),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(104),27,nMB,G2H2(39),n2h2(255))
  call Hloop_AV_Q(ntryL,G1H4(117),ex4(:),G1H2(91),m3h2x2(:,322),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G1H2(91),27,nMB,G2H2(10),n2h2(256))
  call Hloop_TV_S(ntryL,G1H4(108),19,ex4(:),8,G2H2(47),m3h2x2(:,323),heltab2x4(:,:,339))
  call Hloop_SV_T(ntryL,G1H4(14),19,ex4(:),8,G2H2(13),m3h2x2(:,324),heltab2x4(:,:,340))
  call Hloop_CV_D(ntryL,G1H4(125),19,ex4(:),8,G2H2(51),m3h2x2(:,325),heltab2x4(:,:,341))
  call Hloop_DV_C(ntryL,G1H4(130),19,ex4(:),G2H2(36),m3h2x2(:,326),heltab2x4(:,:,342))
  call Hloop_AV_Q(ntryL,G1H4(129),ex3(:),G1H2(126),m3h2x2(:,327),heltab2x4(:,:,343))
  call Hloop_A_Q(ntryL,G1H2(126),23,nMM,G2H2(55),n2h2(257))
  call Hloop_AV_Q(ntryL,G1H4(131),ex3(:),G1H2(137),m3h2x2(:,328),heltab2x4(:,:,344))
  call Hloop_A_Q(ntryL,G1H2(137),23,nML,G2H2(59),n2h2(258))
  call Hloop_QV_A(ntryL,G1H4(63),ex3(:),G1H2(148),m3h2x2(:,329),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(148),23,nMM,G2H2(63),n2h2(259))
  call Hloop_QV_A(ntryL,G1H4(64),ex3(:),G1H2(25),m3h2x2(:,330),heltab2x4(:,:,346))
  call Hloop_Q_A(ntryL,G1H2(25),23,nML,G2H2(67),n2h2(260))
  call Hloop_AV_Q(ntryL,G1H4(85),ex3(:),G1H2(170),m3h2x2(:,331),heltab2x4(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(170),23,nMT,G2H2(3),n2h2(261))
  call Hloop_QV_A(ntryL,G1H4(91),ex3(:),G1H2(36),m3h2x2(:,332),heltab2x4(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMT,G2H2(71),n2h2(262))
  call Hloop_AV_Q(ntryL,G1H4(134),ex3(:),G1H2(192),m3h2x2(:,333),heltab2x4(:,:,349))
  call Hloop_A_Q(ntryL,G1H2(192),23,nMB,G2H2(5),n2h2(263))
  call Hloop_QV_A(ntryL,G1H4(136),ex3(:),G1H2(3),m3h2x2(:,334),heltab2x4(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(75),n2h2(264))
  call Hloop_SV_T(ntryL,G1H4(140),19,ex3(:),4,G2H2(33),m3h2x2(:,335),heltab2x4(:,:,351))
  call Hloop_TV_S(ntryL,G1H4(141),19,ex3(:),4,G2H2(79),m3h2x2(:,336),heltab2x4(:,:,352))
  call Hloop_DV_C(ntryL,G1H4(150),19,ex3(:),G2H2(330),m3h2x2(:,337),heltab2x4(:,:,353))
  call Hloop_CV_D(ntryL,G1H4(151),19,ex3(:),4,G2H2(327),m3h2x2(:,338),heltab2x4(:,:,354))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,13),G1H2(11),m3h4x2(:,183),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(11),23,0,G2H2(285),n2h2(265))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,13),G1H2(26),m3h4x2(:,184),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMM,G2H2(270),n2h2(266))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,13),G1H2(44),m3h4x2(:,185),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(44),23,nML,G2H2(240),n2h2(267))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,13),G1H2(33),m3h4x2(:,186),heltab2x8(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(33),23,0,G2H2(279),n2h2(268))
  call Hloop_AV_Q(ntryL,G1H8(22),wf4(:,13),G1H2(59),m3h4x2(:,187),heltab2x8(:,:,295))
  call Hloop_A_Q(ntryL,G1H2(59),23,nMM,G2H2(261),n2h2(269))
  call Hloop_AV_Q(ntryL,G1H8(56),wf4(:,13),G1H2(48),m3h4x2(:,188),heltab2x8(:,:,296))
  call Hloop_A_Q(ntryL,G1H2(48),23,nML,G2H2(231),n2h2(270))
  call Hloop_QV_A(ntryL,G1H8(61),wf4(:,13),G1H2(65),m3h4x2(:,189),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(65),23,nMT,G2H2(40),n2h2(271))
  call Hloop_AV_Q(ntryL,G1H8(66),wf4(:,13),G1H2(69),m3h4x2(:,190),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G1H2(69),23,nMT,G2H2(37),n2h2(272))
  call Hloop_QV_A(ntryL,G1H8(71),wf4(:,13),G1H2(19),m3h4x2(:,191),heltab2x8(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMB,G2H2(45),n2h2(273))
  call Hloop_AV_Q(ntryL,G1H8(76),wf4(:,13),G1H2(70),m3h4x2(:,192),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G1H2(70),23,nMB,G2H2(41),n2h2(274))
  call Hloop_QZ_A(ntryL,G1H8(81),wf4(:,14),G1H2(99),ngZl,m3h4x2(:,193),heltab2x8(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(99),23,0,G2H2(52),n2h2(275))
  call Hloop_QZ_A(ntryL,G1H8(86),wf4(:,14),G1H2(88),ngZl,m3h4x2(:,194),heltab2x8(:,:,302))
  call Hloop_Q_A(ntryL,G1H2(88),23,nMM,G2H2(49),n2h2(276))
  call Hloop_QZ_A(ntryL,G1H8(91),wf4(:,14),G1H2(92),ngZl,m3h4x2(:,195),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(92),23,nML,G2H2(57),n2h2(277))
  call Hloop_AZ_Q(ntryL,G1H8(96),wf4(:,14),G1H2(103),ngZl,m3h4x2(:,196),heltab2x8(:,:,304))
  call Hloop_A_Q(ntryL,G1H2(103),23,0,G2H2(53),n2h2(278))
  call Hloop_AZ_Q(ntryL,G1H8(101),wf4(:,14),G1H2(120),ngZl,m3h4x2(:,197),heltab2x8(:,:,305))
  call Hloop_A_Q(ntryL,G1H2(120),23,nMM,G2H2(77),n2h2(279))
  call Hloop_AZ_Q(ntryL,G1H8(106),wf4(:,14),G1H2(109),ngZl,m3h4x2(:,198),heltab2x8(:,:,306))
  call Hloop_A_Q(ntryL,G1H2(109),23,nML,G2H2(76),n2h2(280))
  call Hloop_QZ_A(ntryL,G1H8(111),wf4(:,14),G1H2(7),ngZu,m3h4x2(:,199),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(7),23,0,G2H2(73),n2h2(281))
  call Hloop_QZ_A(ntryL,G1H8(116),wf4(:,14),G1H2(125),ngZu,m3h4x2(:,200),heltab2x8(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(125),23,nMT,G2H2(64),n2h2(282))
  call Hloop_AZ_Q(ntryL,G1H8(121),wf4(:,14),G1H2(131),ngZu,m3h4x2(:,201),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(131),23,0,G2H2(61),n2h2(283))
  call Hloop_AZ_Q(ntryL,G1H8(126),wf4(:,14),G1H2(136),ngZu,m3h4x2(:,202),heltab2x8(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(136),23,nMT,G2H2(81),n2h2(284))
  call Hloop_QZ_A(ntryL,G1H8(131),wf4(:,14),G1H2(153),ngZd,m3h4x2(:,203),heltab2x8(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(153),23,0,G2H2(72),n2h2(285))
  call Hloop_QZ_A(ntryL,G1H8(136),wf4(:,14),G1H2(142),ngZd,m3h4x2(:,204),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(142),23,nMB,G2H2(69),n2h2(286))
  call Hloop_AZ_Q(ntryL,G1H8(141),wf4(:,14),G1H2(18),ngZd,m3h4x2(:,205),heltab2x8(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(18),23,0,G2H2(68),n2h2(287))
  call Hloop_AZ_Q(ntryL,G1H8(146),wf4(:,14),G1H2(158),ngZd,m3h4x2(:,206),heltab2x8(:,:,314))
  call Hloop_A_Q(ntryL,G1H2(158),23,nMB,G2H2(65),n2h2(288))
  call Hloop_TV_S(ntryL,G1H8(151),20,wf4(:,13),3,G2H2(301),m3h4x2(:,207),heltab2x8(:,:,315))
  call Hloop_SV_T(ntryL,G1H8(156),20,wf4(:,13),3,G2H2(304),m3h4x2(:,208),heltab2x8(:,:,316))
  call Hloop_TV_S(ntryL,G1H8(161),20,wf4(:,14),3,G2H2(232),m3h4x2(:,209),heltab2x8(:,:,317))
  call Hloop_SV_T(ntryL,G1H8(166),20,wf4(:,14),3,G2H2(234),m3h4x2(:,210),heltab2x8(:,:,318))
  call Hloop_CV_D(ntryL,G1H8(171),20,wf4(:,13),3,G2H2(235),m3h4x2(:,211),heltab2x8(:,:,319))
  call Hloop_DV_C(ntryL,G1H8(176),20,wf4(:,13),G2H2(237),m3h4x2(:,212),heltab2x8(:,:,320))
  call Hloop_CV_D(ntryL,G1H8(181),20,wf4(:,14),3,G2H2(241),m3h4x2(:,213),heltab2x8(:,:,321))
  call Hloop_DV_C(ntryL,G1H8(186),20,wf4(:,14),G2H2(243),m3h4x2(:,214),heltab2x8(:,:,322))
  call Hloop_UV_W(ntryL,G1H8(191),20,wf4(:,13),3,G2H2(244),m3h4x2(:,215),heltab2x8(:,:,323))
  call Hloop_UW_V(ntryL,G1H8(196),20,wf4(:,13),3,G2H2(246),m3h4x2(:,216),heltab2x8(:,:,324))
  call Hloop_UV_W(ntryL,G1H8(201),20,wf4(:,14),3,G2H2(247),m3h4x2(:,217),heltab2x8(:,:,325))
  call Hloop_UW_V(ntryL,G1H8(206),20,wf4(:,14),3,G2H2(249),m3h4x2(:,218),heltab2x8(:,:,326))
  call Hloop_WA_Q(ntryL,G1H8(27),ex2(:),G1H4(170),m3h2x4(:,109),heltab2x8(:,:,327))
  call Hloop_A_Q(ntryL,G1H4(170),22,0,G2H4(28),n2h4(203))
  call Hloop_WQ_A(ntryL,G1H8(32),ex1(:),G1H4(171),m3h2x4(:,110),heltab2x8(:,:,328))
  call Hloop_Q_A(ntryL,G1H4(171),21,0,G2H4(31),n2h4(204))
  call Hloop_SV_V(ntryL,G1H4(161),ex3(:),G1H2(164),m3h2x2(:,339),heltab2x4(:,:,355))
  call Hloop_VV_S(ntryL,G1H4(166),ex3(:),G1H2(169),m3h2x2(:,340),heltab2x4(:,:,356))
  call Hloop_TV_S(ntryL,G1H16(9),16,ex3(:),4,G2H8(21),m3h2x8(:,151),heltab2x16(:,:,335))
  call Hloop_SV_T(ntryL,G1H16(3),16,ex3(:),4,G2H8(22),m3h2x8(:,152),heltab2x16(:,:,336))
  call Hloop_TV_S(ntryL,G1H16(11),16,ex3(:),4,G2H8(23),m3h2x8(:,153),heltab2x16(:,:,337))
  call Hloop_SV_T(ntryL,G1H16(6),16,ex3(:),4,G2H8(24),m3h2x8(:,154),heltab2x16(:,:,338))
  call Hloop_UV_W(ntryL,G1H16(35),16,ex3(:),4,G2H8(25),m3h2x8(:,155),heltab2x16(:,:,339))
  call Hloop_UW_V(ntryL,G1H16(36),16,ex3(:),4,G2H8(26),m3h2x8(:,156),heltab2x16(:,:,340))
  call Hloop_UV_W(ntryL,G1H16(39),16,ex3(:),4,G2H8(27),m3h2x8(:,157),heltab2x16(:,:,341))
  call Hloop_UW_V(ntryL,G1H16(40),16,ex3(:),4,G2H8(28),m3h2x8(:,158),heltab2x16(:,:,342))
  call Hloop_VV_S(ntryL,G0H16(15),ex3(:),G0H8(20),m3h2x8(:,159),heltab2x16(:,:,343))
  call Hloop_VV_S(ntryL,G0H16(19),ex3(:),G0H8(15),m3h2x8(:,160),heltab2x16(:,:,344))
  call Hloop_SV_V(ntryL,G0H16(47),ex3(:),G0H8(16),m3h2x8(:,161),heltab2x16(:,:,345))
  call Hloop_SV_V(ntryL,G0H16(51),ex3(:),G0H8(1),m3h2x8(:,162),heltab2x16(:,:,346))
  call Hloop_TV_S(ntryL,G0H8(23),24,wf4(:,13),3,G1H2(186),m3h4x2(:,219),heltab2x8(:,:,329))
  call Hloop_SV_T(ntryL,G0H8(5),24,wf4(:,13),3,G1H2(175),m3h4x2(:,220),heltab2x8(:,:,330))
  call Hloop_TV_S(ntryL,G0H8(6),24,wf4(:,14),3,G1H2(8),m3h4x2(:,221),heltab2x8(:,:,331))
  call Hloop_SV_T(ntryL,G0H8(7),24,wf4(:,14),3,G1H2(191),m3h4x2(:,222),heltab2x8(:,:,332))
  call Hloop_UV_W(ntryL,G0H8(8),24,wf4(:,13),3,G1H2(197),m3h4x2(:,223),heltab2x8(:,:,333))
  call Hloop_UW_V(ntryL,G0H8(9),24,wf4(:,13),3,G1H2(12),m3h4x2(:,224),heltab2x8(:,:,334))
  call Hloop_UV_W(ntryL,G0H8(10),24,wf4(:,14),3,G1H2(13),m3h4x2(:,225),heltab2x8(:,:,335))
  call Hloop_UW_V(ntryL,G0H8(11),24,wf4(:,14),3,G1H2(29),m3h4x2(:,226),heltab2x8(:,:,336))
  call Hloop_SV_V(ntryL,G0H8(13),wf4(:,13),G0H2(1),m3h4x2(:,227),heltab2x8(:,:,337))
  call Hloop_SV_V(ntryL,G0H8(2),wf4(:,14),G0H2(2),m3h4x2(:,228),heltab2x8(:,:,338))
  call Hloop_VV_S(ntryL,G0H8(17),wf4(:,13),G0H2(3),m3h4x2(:,229),heltab2x8(:,:,339))
  call Hloop_VV_S(ntryL,G0H8(19),wf4(:,14),G0H2(4),m3h4x2(:,230),heltab2x8(:,:,340))
  call Hloop_SVV_S(ntryL,G1H16(77),ex3(:),wf4(:,13),G1H2(24),m4h2x4x2(:,1),heltab3x16(:,:,1))
  call Hloop_SVV_S(ntryL,G1H16(71),ex3(:),wf4(:,13),G1H2(106),m4h2x4x2(:,2),heltab3x16(:,:,2))
  call Hloop_SVV_S(ntryL,G1H16(79),ex3(:),wf4(:,14),G1H2(188),m4h2x4x2(:,3),heltab3x16(:,:,3))
  call Hloop_SVV_S(ntryL,G1H16(74),ex3(:),wf4(:,14),G1H2(134),m4h2x4x2(:,4),heltab3x16(:,:,4))
  call Hloop_VWW_V(ntryL,G1H16(103),ex3(:),wf4(:,13),G1H2(6),m4h2x4x2(:,5),heltab3x16(:,:,5))
  call Hloop_VWW_V(ntryL,G1H16(104),ex3(:),wf4(:,13),G1H2(133),m4h2x4x2(:,6),heltab3x16(:,:,6))
  call Hloop_VWW_V(ntryL,G1H16(107),ex3(:),wf4(:,14),G1H2(28),m4h2x4x2(:,7),heltab3x16(:,:,7))
  call Hloop_VWW_V(ntryL,G1H16(108),ex3(:),wf4(:,14),G1H2(94),m4h2x4x2(:,8),heltab3x16(:,:,8))
  call Hloop_SVV_S(ntryL,G0H16(79),ex3(:),wf4(:,13),G0H2(5),m4h2x4x2(:,9),heltab3x16(:,:,9))
  call Hloop_SVV_S(ntryL,G0H16(83),ex3(:),wf4(:,14),G0H2(6),m4h2x4x2(:,10),heltab3x16(:,:,10))
  call Hloop_VWW_V(ntryL,G0H16(6),ex3(:),wf4(:,13),G0H2(7),m4h2x4x2(:,11),heltab3x16(:,:,11))
  call Hloop_VWW_V(ntryL,G0H16(8),ex3(:),wf4(:,14),G0H2(8),m4h2x4x2(:,12),heltab3x16(:,:,12))
  call Hloop_SV_V(ntryL,G0H8(26),wf4(:,13),G0H2(9),m3h4x2(:,231),heltab2x8(:,:,341))
  call Hloop_SV_V(ntryL,G0H8(28),wf4(:,14),G0H2(10),m3h4x2(:,232),heltab2x8(:,:,342))
  call Hloop_VV_S(ntryL,G0H8(30),wf4(:,13),G0H2(11),m3h4x2(:,233),heltab2x8(:,:,343))
  call Hloop_VV_S(ntryL,G0H8(32),wf4(:,14),G0H2(12),m3h4x2(:,234),heltab2x8(:,:,344))
  call Hloop_SV_T(ntryL,G1H16(145),16,wf4(:,13),3,G2H4(1),m3h4x4(:,185),heltab2x16(:,:,347))
  call Hloop_TV_S(ntryL,G1H16(139),16,wf4(:,13),3,G2H4(2),m3h4x4(:,186),heltab2x16(:,:,348))
  call Hloop_SV_T(ntryL,G1H16(147),16,wf4(:,14),3,G2H4(4),m3h4x4(:,187),heltab2x16(:,:,349))
  call Hloop_TV_S(ntryL,G1H16(142),16,wf4(:,14),3,G2H4(6),m3h4x4(:,188),heltab2x16(:,:,350))
  call Hloop_UW_V(ntryL,G1H16(171),16,wf4(:,13),3,G2H4(8),m3h4x4(:,189),heltab2x16(:,:,351))
  call Hloop_UV_W(ntryL,G1H16(172),16,wf4(:,13),3,G2H4(10),m3h4x4(:,190),heltab2x16(:,:,352))
  call Hloop_UW_V(ntryL,G1H16(175),16,wf4(:,14),3,G2H4(33),m3h4x4(:,191),heltab2x16(:,:,353))
  call Hloop_UV_W(ntryL,G1H16(176),16,wf4(:,14),3,G2H4(34),m3h4x4(:,192),heltab2x16(:,:,354))
  call Hloop_VV_S(ntryL,G0H16(10),wf4(:,13),G0H4(65),m3h4x4(:,193),heltab2x16(:,:,355))
  call Hloop_VV_S(ntryL,G0H16(12),wf4(:,14),G0H4(12),m3h4x4(:,194),heltab2x16(:,:,356))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,13),G0H4(23),m3h4x4(:,195),heltab2x16(:,:,357))
  call Hloop_SV_V(ntryL,G0H16(4),wf4(:,14),G0H4(21),m3h4x4(:,196),heltab2x16(:,:,358))
  call Hloop_WA_Q(ntryL,G0H8(33),ex2(:),G0H4(9),m3h2x4(:,111),heltab2x8(:,:,345))
  call Hloop_A_Q(ntryL,G0H4(9),26,0,G1H4(173),n2h4(205))
  call Hloop_WQ_A(ntryL,G0H8(34),ex1(:),G0H4(22),m3h2x4(:,112),heltab2x8(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(22),25,0,G1H4(174),n2h4(206))
  call Hloop_QA_W(ntryL,G1H8(35),ex2(:),G1H4(175),m3h2x4(:,113),heltab2x8(:,:,347))
  call Hloop_AQ_W(ntryL,G1H8(36),ex1(:),G1H4(176),m3h2x4(:,114),heltab2x8(:,:,348))
  call Hloop_AQ_V(ntryL,G1H16(1),wf4(:,3),G1H4(178),m3h4x4(:,197),heltab2x16(:,:,359))
  call Hloop_AQ_Z(ntryL,G1H16(2),wf4(:,3),G1H4(179),ngZl,m3h4x4(:,198),heltab2x16(:,:,360))
  call Hloop_WQ_A(ntryL,G1H16(13),wf4(:,3),G1H4(180),m3h4x4(:,199),heltab2x16(:,:,361))
  call Hloop_Q_A(ntryL,G1H4(180),21,0,G2H4(37),n2h4(207))
  call Hloop_VQ_A(ntryL,G0H8(37),wf4(:,3),G0H2(13),m3h4x2(:,235),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G0H2(13),23,0,G1H2(101),n2h2(289))
  call Hloop_ZQ_A(ntryL,G0H8(38),wf4(:,3),G0H2(13),ngZl,m3h4x2(:,236),heltab2x8(:,:,350))
  call Hloop_Q_A(ntryL,G0H2(13),23,0,G1H2(172),n2h2(290))
  call Hloop_AQ_W(ntryL,G1H8(37),wf4(:,3),G1H2(83),m3h4x2(:,237),heltab2x8(:,:,351))
  call Hloop_AV_Q(ntryL,G1H16(18),wf8(:,38),G1H2(199),m3h8x2(:,1),heltab2x16(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(199),23,0,G2H2(250),n2h2(291))
  call Hloop_AV_Q(ntryL,G1H16(5),wf8(:,38),G1H2(204),m3h8x2(:,2),heltab2x16(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(204),23,nMM,G2H2(252),n2h2(292))
  call Hloop_AV_Q(ntryL,G1H16(15),wf8(:,38),G1H2(209),m3h8x2(:,3),heltab2x16(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(209),23,nML,G2H2(253),n2h2(293))
  call Hloop_QV_A(ntryL,G1H16(20),wf8(:,38),G1H2(210),m3h8x2(:,4),heltab2x16(:,:,365))
  call Hloop_Q_A(ntryL,G1H2(210),23,0,G2H2(255),n2h2(294))
  call Hloop_QV_A(ntryL,G1H16(8),wf8(:,38),G1H2(213),m3h8x2(:,5),heltab2x16(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(213),23,nMM,G2H2(256),n2h2(295))
  call Hloop_QV_A(ntryL,G1H16(10),wf8(:,38),G1H2(214),m3h8x2(:,6),heltab2x16(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(214),23,nML,G2H2(258),n2h2(296))
  call Hloop_AV_Q(ntryL,G1H16(14),wf8(:,38),G1H2(215),m3h8x2(:,7),heltab2x16(:,:,368))
  call Hloop_A_Q(ntryL,G1H2(215),23,nMT,G2H2(303),n2h2(297))
  call Hloop_QV_A(ntryL,G1H16(17),wf8(:,38),G1H2(218),m3h8x2(:,8),heltab2x16(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(218),23,nMT,G2H2(306),n2h2(298))
  call Hloop_AV_Q(ntryL,G1H16(19),wf8(:,38),G1H2(219),m3h8x2(:,9),heltab2x16(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(219),23,nMB,G2H2(313),n2h2(299))
  call Hloop_QV_A(ntryL,G1H16(21),wf8(:,38),G1H2(220),m3h8x2(:,10),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(220),23,nMB,G2H2(315),n2h2(300))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf8(:,39),G1H2(223),ngZl,m3h8x2(:,11),heltab2x16(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(223),23,0,G2H2(316),n2h2(301))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf8(:,39),G1H2(224),ngZl,m3h8x2(:,12),heltab2x16(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(224),23,nMM,G2H2(318),n2h2(302))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf8(:,39),G1H2(225),ngZl,m3h8x2(:,13),heltab2x16(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(225),23,nML,G2H2(334),n2h2(303))
  call Hloop_QZ_A(ntryL,G1H16(25),wf8(:,39),G1H2(228),ngZl,m3h8x2(:,14),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(228),23,0,G2H2(331),n2h2(304))
  call Hloop_QZ_A(ntryL,G1H16(26),wf8(:,39),G1H2(229),ngZl,m3h8x2(:,15),heltab2x16(:,:,376))
  call Hloop_Q_A(ntryL,G1H2(229),23,nMM,G2H2(18),n2h2(305))
  call Hloop_QZ_A(ntryL,G1H16(27),wf8(:,39),G1H2(230),ngZl,m3h8x2(:,16),heltab2x16(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(230),23,nML,G2H2(295),n2h2(306))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf8(:,39),G1H2(233),ngZu,m3h8x2(:,17),heltab2x16(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(233),23,0,G2H2(22),n2h2(307))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf8(:,39),G1H2(234),ngZu,m3h8x2(:,18),heltab2x16(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(234),23,nMT,G2H2(26),n2h2(308))
  call Hloop_QZ_A(ntryL,G1H16(30),wf8(:,39),G1H2(235),ngZu,m3h8x2(:,19),heltab2x16(:,:,380))
  call Hloop_Q_A(ntryL,G1H2(235),23,0,G2H2(83),n2h2(309))
  call Hloop_QZ_A(ntryL,G1H16(31),wf8(:,39),G1H2(238),ngZu,m3h8x2(:,20),heltab2x16(:,:,381))
  call Hloop_Q_A(ntryL,G1H2(238),23,nMT,G2H2(30),n2h2(310))
  call Hloop_AZ_Q(ntryL,G1H16(32),wf8(:,39),G1H2(239),ngZd,m3h8x2(:,21),heltab2x16(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(239),23,0,G2H2(84),n2h2(311))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf8(:,39),G1H2(240),ngZd,m3h8x2(:,22),heltab2x16(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(240),23,nMB,G2H2(34),n2h2(312))
  call Hloop_QZ_A(ntryL,G1H16(34),wf8(:,39),G1H2(243),ngZd,m3h8x2(:,23),heltab2x16(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(243),23,0,G2H2(85),n2h2(313))
  call Hloop_QZ_A(ntryL,G1H16(37),wf8(:,39),G1H2(244),ngZd,m3h8x2(:,24),heltab2x16(:,:,385))
  call Hloop_Q_A(ntryL,G1H2(244),23,nMB,G2H2(38),n2h2(314))
  call Hloop_SV_T(ntryL,G1H16(38),16,wf8(:,38),7,G2H2(289),m3h8x2(:,25),heltab2x16(:,:,386))
  call Hloop_TV_S(ntryL,G1H16(41),16,wf8(:,38),7,G2H2(42),m3h8x2(:,26),heltab2x16(:,:,387))
  call Hloop_SV_T(ntryL,G1H16(42),16,wf8(:,39),7,G2H2(46),m3h8x2(:,27),heltab2x16(:,:,388))
  call Hloop_TV_S(ntryL,G1H16(43),16,wf8(:,39),7,G2H2(89),m3h8x2(:,28),heltab2x16(:,:,389))
  call Hloop_DV_C(ntryL,G1H16(46),16,wf8(:,38),G2H2(50),m3h8x2(:,29),heltab2x16(:,:,390))
  call Hloop_CV_D(ntryL,G1H16(47),16,wf8(:,38),7,G2H2(90),m3h8x2(:,30),heltab2x16(:,:,391))
  call Hloop_DV_C(ntryL,G1H16(50),16,wf8(:,39),G2H2(54),m3h8x2(:,31),heltab2x16(:,:,392))
  call Hloop_CV_D(ntryL,G1H16(51),16,wf8(:,39),7,G2H2(91),m3h8x2(:,32),heltab2x16(:,:,393))
  call Hloop_UW_V(ntryL,G1H16(52),16,wf8(:,38),7,G2H2(58),m3h8x2(:,33),heltab2x16(:,:,394))
  call Hloop_UV_W(ntryL,G1H16(53),16,wf8(:,38),7,G2H2(86),m3h8x2(:,34),heltab2x16(:,:,395))
  call Hloop_UW_V(ntryL,G1H16(54),16,wf8(:,39),7,G2H2(62),m3h8x2(:,35),heltab2x16(:,:,396))
  call Hloop_UV_W(ntryL,G1H16(55),16,wf8(:,39),7,G2H2(87),m3h8x2(:,36),heltab2x16(:,:,397))
  call Hloop_VV_S(ntryL,G0H16(50),wf8(:,38),G0H2(13),m3h8x2(:,37),heltab2x16(:,:,398))
  call Hloop_VV_S(ntryL,G0H16(52),wf8(:,38),G0H2(14),m3h8x2(:,38),heltab2x16(:,:,399))
  call Hloop_VV_S(ntryL,G0H16(53),wf8(:,39),G0H2(15),m3h8x2(:,39),heltab2x16(:,:,400))
  call Hloop_VV_S(ntryL,G0H16(54),wf8(:,39),G0H2(16),m3h8x2(:,40),heltab2x16(:,:,401))
  call Hloop_SV_V(ntryL,G1H16(57),wf8(:,38),G1H2(245),m3h8x2(:,41),heltab2x16(:,:,402))
  call Hloop_SV_V(ntryL,G1H16(59),wf8(:,39),G1H2(248),m3h8x2(:,42),heltab2x16(:,:,403))
  call Hloop_SV_T(ntryL,G0H16(55),16,wf8(:,38),7,G1H2(249),m3h8x2(:,43),heltab2x16(:,:,404))
  call Hloop_TV_S(ntryL,G0H16(56),16,wf8(:,38),7,G1H2(250),m3h8x2(:,44),heltab2x16(:,:,405))
  call Hloop_SV_T(ntryL,G0H16(57),16,wf8(:,39),7,G1H2(253),m3h8x2(:,45),heltab2x16(:,:,406))
  call Hloop_TV_S(ntryL,G0H16(58),16,wf8(:,39),7,G1H2(254),m3h8x2(:,46),heltab2x16(:,:,407))
  call Hloop_UW_V(ntryL,G0H16(59),16,wf8(:,38),7,G1H2(255),m3h8x2(:,47),heltab2x16(:,:,408))
  call Hloop_UV_W(ntryL,G0H16(60),16,wf8(:,38),7,G1H2(258),m3h8x2(:,48),heltab2x16(:,:,409))
  call Hloop_UW_V(ntryL,G0H16(61),16,wf8(:,39),7,G1H2(259),m3h8x2(:,49),heltab2x16(:,:,410))
  call Hloop_UV_W(ntryL,G0H16(62),16,wf8(:,39),7,G1H2(260),m3h8x2(:,50),heltab2x16(:,:,411))
  call Hloop_VV_S(ntryL,G1H16(61),wf8(:,38),G1H2(263),m3h8x2(:,51),heltab2x16(:,:,412))
  call Hloop_VV_S(ntryL,G1H16(63),wf8(:,39),G1H2(9),m3h8x2(:,52),heltab2x16(:,:,413))
  call Hloop_SV_V(ntryL,G0H16(63),wf8(:,38),G0H2(17),m3h8x2(:,53),heltab2x16(:,:,414))
  call Hloop_SV_V(ntryL,G0H16(64),wf8(:,38),G0H2(18),m3h8x2(:,54),heltab2x16(:,:,415))
  call Hloop_SV_V(ntryL,G0H16(65),wf8(:,39),G0H2(19),m3h8x2(:,55),heltab2x16(:,:,416))
  call Hloop_SV_V(ntryL,G0H16(66),wf8(:,39),G0H2(20),m3h8x2(:,56),heltab2x16(:,:,417))
  call Hloop_QA_V(ntryL,G1H16(64),ex2(:),G1H8(43),m3h2x8(:,163),heltab2x16(:,:,418))
  call Hloop_QA_Z(ntryL,G1H16(65),ex2(:),G1H8(44),ngZl,m3h2x8(:,164),heltab2x16(:,:,419))
  call Hloop_WA_Q(ntryL,G1H16(66),ex2(:),G1H8(45),m3h2x8(:,165),heltab2x16(:,:,420))
  call Hloop_A_Q(ntryL,G1H8(45),18,0,G2H8(29),n2h8(115))
  call Hloop_VA_Q(ntryL,G0H4(41),ex2(:),G0H2(21),m3h2x2(:,341),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G0H2(21),23,0,G1H2(10),n2h2(315))
  call Hloop_ZA_Q(ntryL,G0H4(42),ex2(:),G0H2(21),ngZl,m3h2x2(:,342),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G0H2(21),23,0,G1H2(266),n2h2(316))
  call Hloop_QA_W(ntryL,G1H4(45),ex2(:),G1H2(20),m3h2x2(:,343),heltab2x4(:,:,359))
  call Hloop_QA_V(ntryL,G1H16(67),wf4(:,10),G1H4(181),m3h4x4(:,200),heltab2x16(:,:,421))
  call Hloop_QA_Z(ntryL,G1H16(68),wf4(:,10),G1H4(183),ngZl,m3h4x4(:,201),heltab2x16(:,:,422))
  call Hloop_WA_Q(ntryL,G1H16(69),wf4(:,10),G1H4(184),m3h4x4(:,202),heltab2x16(:,:,423))
  call Hloop_A_Q(ntryL,G1H4(184),22,0,G2H4(38),n2h4(208))
  call Hloop_VA_Q(ntryL,G0H8(39),wf4(:,10),G0H2(21),m3h4x2(:,238),heltab2x8(:,:,352))
  call Hloop_A_Q(ntryL,G0H2(21),23,0,G1H2(21),n2h2(317))
  call Hloop_ZA_Q(ntryL,G0H8(40),wf4(:,10),G0H2(21),ngZl,m3h4x2(:,239),heltab2x8(:,:,353))
  call Hloop_A_Q(ntryL,G0H2(21),23,0,G1H2(269),n2h2(318))
  call Hloop_QA_W(ntryL,G1H8(38),wf4(:,10),G1H2(31),m3h4x2(:,240),heltab2x8(:,:,354))
  call Hloop_AV_Q(ntryL,G1H16(84),wf8(:,40),G1H2(32),m3h8x2(:,57),heltab2x16(:,:,424))
  call Hloop_A_Q(ntryL,G1H2(32),23,0,G2H2(66),n2h2(319))
  call Hloop_AV_Q(ntryL,G1H16(81),wf8(:,40),G1H2(272),m3h8x2(:,58),heltab2x16(:,:,425))
  call Hloop_A_Q(ntryL,G1H2(272),23,nMM,G2H2(88),n2h2(320))
  call Hloop_AV_Q(ntryL,G1H16(72),wf8(:,40),G1H2(42),m3h8x2(:,59),heltab2x16(:,:,426))
  call Hloop_A_Q(ntryL,G1H2(42),23,nML,G2H2(70),n2h2(321))
  call Hloop_QV_A(ntryL,G1H16(86),wf8(:,40),G1H2(43),m3h8x2(:,60),heltab2x16(:,:,427))
  call Hloop_Q_A(ntryL,G1H2(43),23,0,G2H2(92),n2h2(322))
  call Hloop_QV_A(ntryL,G1H16(83),wf8(:,40),G1H2(275),m3h8x2(:,61),heltab2x16(:,:,428))
  call Hloop_Q_A(ntryL,G1H2(275),23,nMM,G2H2(74),n2h2(323))
  call Hloop_QV_A(ntryL,G1H16(75),wf8(:,40),G1H2(276),m3h8x2(:,62),heltab2x16(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(276),23,nML,G2H2(93),n2h2(324))
  call Hloop_AV_Q(ntryL,G1H16(78),wf8(:,40),G1H2(277),m3h8x2(:,63),heltab2x16(:,:,430))
  call Hloop_A_Q(ntryL,G1H2(277),23,nMT,G2H2(78),n2h2(325))
  call Hloop_QV_A(ntryL,G1H16(82),wf8(:,40),G1H2(280),m3h8x2(:,64),heltab2x16(:,:,431))
  call Hloop_Q_A(ntryL,G1H2(280),23,nMT,G2H2(94),n2h2(326))
  call Hloop_AV_Q(ntryL,G1H16(85),wf8(:,40),G1H2(53),m3h8x2(:,65),heltab2x16(:,:,432))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMB,G2H2(1),n2h2(327))
  call Hloop_QV_A(ntryL,G1H16(87),wf8(:,40),G1H2(55),m3h8x2(:,66),heltab2x16(:,:,433))
  call Hloop_Q_A(ntryL,G1H2(55),23,nMB,G2H2(336),n2h2(328))
  call Hloop_AZ_Q(ntryL,G1H16(88),wf8(:,41),G1H2(283),ngZl,m3h8x2(:,67),heltab2x16(:,:,434))
  call Hloop_A_Q(ntryL,G1H2(283),23,0,G2H2(2),n2h2(329))
  call Hloop_AZ_Q(ntryL,G1H16(89),wf8(:,41),G1H2(64),ngZl,m3h8x2(:,68),heltab2x16(:,:,435))
  call Hloop_A_Q(ntryL,G1H2(64),23,nMM,G2H2(333),n2h2(330))
  call Hloop_AZ_Q(ntryL,G1H16(90),wf8(:,41),G1H2(66),ngZl,m3h8x2(:,69),heltab2x16(:,:,436))
  call Hloop_A_Q(ntryL,G1H2(66),23,nML,G2H2(4),n2h2(331))
  call Hloop_QZ_A(ntryL,G1H16(91),wf8(:,41),G1H2(286),ngZl,m3h8x2(:,70),heltab2x16(:,:,437))
  call Hloop_Q_A(ntryL,G1H2(286),23,0,G2H2(297),n2h2(332))
  call Hloop_QZ_A(ntryL,G1H16(92),wf8(:,41),G1H2(287),ngZl,m3h8x2(:,71),heltab2x16(:,:,438))
  call Hloop_Q_A(ntryL,G1H2(287),23,nMM,G2H2(6),n2h2(333))
  call Hloop_QZ_A(ntryL,G1H16(93),wf8(:,41),G1H2(288),ngZl,m3h8x2(:,72),heltab2x16(:,:,439))
  call Hloop_Q_A(ntryL,G1H2(288),23,nML,G2H2(7),n2h2(334))
  call Hloop_AZ_Q(ntryL,G1H16(94),wf8(:,41),G1H2(291),ngZu,m3h8x2(:,73),heltab2x16(:,:,440))
  call Hloop_A_Q(ntryL,G1H2(291),23,0,G2H2(101),n2h2(335))
  call Hloop_AZ_Q(ntryL,G1H16(95),wf8(:,41),G1H2(75),ngZu,m3h8x2(:,74),heltab2x16(:,:,441))
  call Hloop_A_Q(ntryL,G1H2(75),23,nMT,G2H2(104),n2h2(336))
  call Hloop_QZ_A(ntryL,G1H16(96),wf8(:,41),G1H2(77),ngZu,m3h8x2(:,75),heltab2x16(:,:,442))
  call Hloop_Q_A(ntryL,G1H2(77),23,0,G2H2(8),n2h2(337))
  call Hloop_QZ_A(ntryL,G1H16(97),wf8(:,41),G1H2(294),ngZu,m3h8x2(:,76),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G1H2(294),23,nMT,G2H2(9),n2h2(338))
  call Hloop_AZ_Q(ntryL,G1H16(98),wf8(:,41),G1H2(86),ngZd,m3h8x2(:,77),heltab2x16(:,:,444))
  call Hloop_A_Q(ntryL,G1H2(86),23,0,G2H2(105),n2h2(339))
  call Hloop_AZ_Q(ntryL,G1H16(99),wf8(:,41),G1H2(87),ngZd,m3h8x2(:,78),heltab2x16(:,:,445))
  call Hloop_A_Q(ntryL,G1H2(87),23,nMB,G2H2(108),n2h2(340))
  call Hloop_QZ_A(ntryL,G1H16(100),wf8(:,41),G1H2(297),ngZd,m3h8x2(:,79),heltab2x16(:,:,446))
  call Hloop_Q_A(ntryL,G1H2(297),23,0,G2H2(11),n2h2(341))
  call Hloop_QZ_A(ntryL,G1H16(101),wf8(:,41),G1H2(97),ngZd,m3h8x2(:,80),heltab2x16(:,:,447))
  call Hloop_Q_A(ntryL,G1H2(97),23,nMB,G2H2(291),n2h2(342))
  call Hloop_SV_T(ntryL,G1H16(102),16,wf8(:,40),7,G2H2(14),m3h8x2(:,81),heltab2x16(:,:,448))
  call Hloop_TV_S(ntryL,G1H16(105),16,wf8(:,40),7,G2H2(16),m3h8x2(:,82),heltab2x16(:,:,449))
  call Hloop_SV_T(ntryL,G1H16(106),16,wf8(:,41),7,G2H2(109),m3h8x2(:,83),heltab2x16(:,:,450))
  call Hloop_TV_S(ntryL,G1H16(109),16,wf8(:,41),7,G2H2(112),m3h8x2(:,84),heltab2x16(:,:,451))
  call Hloop_DV_C(ntryL,G1H16(112),16,wf8(:,40),G2H2(17),m3h8x2(:,85),heltab2x16(:,:,452))
  call Hloop_CV_D(ntryL,G1H16(113),16,wf8(:,40),7,G2H2(20),m3h8x2(:,86),heltab2x16(:,:,453))
  call Hloop_DV_C(ntryL,G1H16(116),16,wf8(:,41),G2H2(113),m3h8x2(:,87),heltab2x16(:,:,454))
  call Hloop_CV_D(ntryL,G1H16(117),16,wf8(:,41),7,G2H2(116),m3h8x2(:,88),heltab2x16(:,:,455))
  call Hloop_UW_V(ntryL,G1H16(118),16,wf8(:,40),7,G2H2(21),m3h8x2(:,89),heltab2x16(:,:,456))
  call Hloop_UV_W(ntryL,G1H16(119),16,wf8(:,40),7,G2H2(117),m3h8x2(:,90),heltab2x16(:,:,457))
  call Hloop_UW_V(ntryL,G1H16(120),16,wf8(:,41),7,G2H2(120),m3h8x2(:,91),heltab2x16(:,:,458))
  call Hloop_UV_W(ntryL,G1H16(121),16,wf8(:,41),7,G2H2(24),m3h8x2(:,92),heltab2x16(:,:,459))
  call Hloop_VV_S(ntryL,G0H16(103),wf8(:,40),G0H2(21),m3h8x2(:,93),heltab2x16(:,:,460))
  call Hloop_VV_S(ntryL,G0H16(104),wf8(:,40),G0H2(22),m3h8x2(:,94),heltab2x16(:,:,461))
  call Hloop_VV_S(ntryL,G0H16(14),wf8(:,41),G0H2(23),m3h8x2(:,95),heltab2x16(:,:,462))
  call Hloop_VV_S(ntryL,G0H16(16),wf8(:,41),G0H2(24),m3h8x2(:,96),heltab2x16(:,:,463))
  call Hloop_SV_V(ntryL,G1H16(123),wf8(:,40),G1H2(98),m3h8x2(:,97),heltab2x16(:,:,464))
  call Hloop_SV_V(ntryL,G1H16(125),wf8(:,41),G1H2(300),m3h8x2(:,98),heltab2x16(:,:,465))
  call Hloop_SV_T(ntryL,G0H16(18),16,wf8(:,40),7,G1H2(301),m3h8x2(:,99),heltab2x16(:,:,466))
  call Hloop_TV_S(ntryL,G0H16(20),16,wf8(:,40),7,G1H2(302),m3h8x2(:,100),heltab2x16(:,:,467))
  call Hloop_SV_T(ntryL,G0H16(21),16,wf8(:,41),7,G1H2(305),m3h8x2(:,101),heltab2x16(:,:,468))
  call Hloop_TV_S(ntryL,G0H16(22),16,wf8(:,41),7,G1H2(108),m3h8x2(:,102),heltab2x16(:,:,469))
  call Hloop_UW_V(ntryL,G0H16(23),16,wf8(:,40),7,G1H2(110),m3h8x2(:,103),heltab2x16(:,:,470))
  call Hloop_UV_W(ntryL,G0H16(24),16,wf8(:,40),7,G1H2(308),m3h8x2(:,104),heltab2x16(:,:,471))
  call Hloop_UW_V(ntryL,G0H16(25),16,wf8(:,41),7,G1H2(119),m3h8x2(:,105),heltab2x16(:,:,472))
  call Hloop_UV_W(ntryL,G0H16(26),16,wf8(:,41),7,G1H2(121),m3h8x2(:,106),heltab2x16(:,:,473))
  call Hloop_VV_S(ntryL,G1H16(127),wf8(:,40),G1H2(311),m3h8x2(:,107),heltab2x16(:,:,474))
  call Hloop_VV_S(ntryL,G1H16(129),wf8(:,41),G1H2(312),m3h8x2(:,108),heltab2x16(:,:,475))
  call Hloop_SV_V(ntryL,G0H16(27),wf8(:,40),G0H2(25),m3h8x2(:,109),heltab2x16(:,:,476))
  call Hloop_SV_V(ntryL,G0H16(28),wf8(:,40),G0H2(26),m3h8x2(:,110),heltab2x16(:,:,477))
  call Hloop_SV_V(ntryL,G0H16(29),wf8(:,41),G0H2(27),m3h8x2(:,111),heltab2x16(:,:,478))
  call Hloop_SV_V(ntryL,G0H16(30),wf8(:,41),G0H2(28),m3h8x2(:,112),heltab2x16(:,:,479))
  call Hloop_AQ_V(ntryL,G1H16(130),ex1(:),G1H8(46),m3h2x8(:,166),heltab2x16(:,:,480))
  call Hloop_AQ_Z(ntryL,G1H16(131),ex1(:),G1H8(47),ngZl,m3h2x8(:,167),heltab2x16(:,:,481))
  call Hloop_WQ_A(ntryL,G1H16(132),ex1(:),G1H8(48),m3h2x8(:,168),heltab2x16(:,:,482))
  call Hloop_Q_A(ntryL,G1H8(48),17,0,G2H8(30),n2h8(116))
  call Hloop_VQ_A(ntryL,G0H4(61),ex1(:),G0H2(29),m3h2x2(:,344),heltab2x4(:,:,360))
  call Hloop_Q_A(ntryL,G0H2(29),23,0,G1H2(313),n2h2(343))
  call Hloop_ZQ_A(ntryL,G0H4(62),ex1(:),G0H2(29),ngZl,m3h2x2(:,345),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G0H2(29),23,0,G1H2(316),n2h2(344))
  call Hloop_AQ_W(ntryL,G1H4(168),ex1(:),G1H2(130),m3h2x2(:,346),heltab2x4(:,:,362))
  call Hloop_AV_Q(ntryL,G1H8(39),ex3(:),G1H4(9),m3h2x4(:,115),heltab2x8(:,:,355))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(46),n2h4(209))
  call Hloop_AV_Q(ntryL,G1H8(40),ex3(:),G1H4(10),m3h2x4(:,116),heltab2x8(:,:,356))
  call Hloop_A_Q(ntryL,G1H4(10),22,0,G2H4(50),n2h4(210))
  call Hloop_UW_V(ntryL,G0H8(41),18,ex3(:),4,G1H4(19),m3h2x4(:,117),heltab2x8(:,:,357))
  call Hloop_QV_A(ntryL,G1H16(143),ex3(:),G1H8(49),m3h2x8(:,169),heltab2x16(:,:,483))
  call Hloop_Q_A(ntryL,G1H8(49),20,0,G2H8(31),n2h8(117))
  call Hloop_QV_A(ntryL,G1H16(134),ex3(:),G1H8(50),m3h2x8(:,170),heltab2x16(:,:,484))
  call Hloop_Q_A(ntryL,G1H8(50),20,nMM,G2H8(32),n2h8(118))
  call Hloop_QV_A(ntryL,G1H16(135),ex3(:),G1H8(51),m3h2x8(:,171),heltab2x16(:,:,485))
  call Hloop_Q_A(ntryL,G1H8(51),20,nML,G2H8(33),n2h8(119))
  call Hloop_AV_Q(ntryL,G1H16(146),ex3(:),G1H8(52),m3h2x8(:,172),heltab2x16(:,:,486))
  call Hloop_A_Q(ntryL,G1H8(52),20,0,G2H8(34),n2h8(120))
  call Hloop_AV_Q(ntryL,G1H16(137),ex3(:),G1H8(53),m3h2x8(:,173),heltab2x16(:,:,487))
  call Hloop_A_Q(ntryL,G1H8(53),20,nMM,G2H8(35),n2h8(121))
  call Hloop_AV_Q(ntryL,G1H16(138),ex3(:),G1H8(9),m3h2x8(:,174),heltab2x16(:,:,488))
  call Hloop_A_Q(ntryL,G1H8(9),20,nML,G2H8(36),n2h8(122))
  call Hloop_QV_A(ntryL,G1H16(140),ex3(:),G1H8(11),m3h2x8(:,175),heltab2x16(:,:,489))
  call Hloop_Q_A(ntryL,G1H8(11),20,nMT,G2H8(37),n2h8(123))
  call Hloop_AV_Q(ntryL,G1H16(151),ex3(:),G1H8(12),m3h2x8(:,176),heltab2x16(:,:,490))
  call Hloop_A_Q(ntryL,G1H8(12),20,nMT,G2H8(38),n2h8(124))
  call Hloop_QV_A(ntryL,G1H16(144),ex3(:),G1H8(13),m3h2x8(:,177),heltab2x16(:,:,491))
  call Hloop_Q_A(ntryL,G1H8(13),20,nMB,G2H8(40),n2h8(125))
  call Hloop_AV_Q(ntryL,G1H16(148),ex3(:),G1H8(14),m3h2x8(:,178),heltab2x16(:,:,492))
  call Hloop_A_Q(ntryL,G1H8(14),20,nMB,G2H8(42),n2h8(126))
  call Hloop_QV_A(ntryL,G1H16(150),ex3(:),G1H8(16),m3h2x8(:,179),heltab2x16(:,:,493))
  call Hloop_Q_A(ntryL,G1H8(16),20,0,G2H8(44),n2h8(127))
  call Hloop_QV_A(ntryL,G1H16(152),ex3(:),G1H8(4),m3h2x8(:,180),heltab2x16(:,:,494))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMM,G2H8(46),n2h8(128))
  call Hloop_QV_A(ntryL,G1H16(153),ex3(:),G1H8(6),m3h2x8(:,181),heltab2x16(:,:,495))
  call Hloop_Q_A(ntryL,G1H8(6),20,nML,G2H8(47),n2h8(129))
  call Hloop_AV_Q(ntryL,G1H16(154),ex3(:),G1H8(8),m3h2x8(:,182),heltab2x16(:,:,496))
  call Hloop_A_Q(ntryL,G1H8(8),20,0,G2H8(48),n2h8(130))
  call Hloop_AV_Q(ntryL,G1H16(155),ex3(:),G1H8(7),m3h2x8(:,183),heltab2x16(:,:,497))
  call Hloop_A_Q(ntryL,G1H8(7),20,nMM,G2H8(49),n2h8(131))
  call Hloop_AV_Q(ntryL,G1H16(156),ex3(:),G1H8(5),m3h2x8(:,184),heltab2x16(:,:,498))
  call Hloop_A_Q(ntryL,G1H8(5),20,nML,G2H8(50),n2h8(132))
  call Hloop_QV_A(ntryL,G1H16(157),ex3(:),G1H8(17),m3h2x8(:,185),heltab2x16(:,:,499))
  call Hloop_Q_A(ntryL,G1H8(17),20,0,G2H8(51),n2h8(133))
  call Hloop_QV_A(ntryL,G1H16(158),ex3(:),G1H8(18),m3h2x8(:,186),heltab2x16(:,:,500))
  call Hloop_Q_A(ntryL,G1H8(18),20,nMT,G2H8(52),n2h8(134))
  call Hloop_AV_Q(ntryL,G1H16(159),ex3(:),G1H8(20),m3h2x8(:,187),heltab2x16(:,:,501))
  call Hloop_A_Q(ntryL,G1H8(20),20,0,G2H8(53),n2h8(135))
  call Hloop_AV_Q(ntryL,G1H16(160),ex3(:),G1H8(21),m3h2x8(:,188),heltab2x16(:,:,502))
  call Hloop_A_Q(ntryL,G1H8(21),20,nMT,G2H8(54),n2h8(136))
  call Hloop_QV_A(ntryL,G1H16(161),ex3(:),G1H8(1),m3h2x8(:,189),heltab2x16(:,:,503))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(55),n2h8(137))
  call Hloop_QV_A(ntryL,G1H16(162),ex3(:),G1H8(2),m3h2x8(:,190),heltab2x16(:,:,504))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMB,G2H8(56),n2h8(138))
  call Hloop_AV_Q(ntryL,G1H16(163),ex3(:),G1H8(23),m3h2x8(:,191),heltab2x16(:,:,505))
  call Hloop_A_Q(ntryL,G1H8(23),20,0,G2H8(39),n2h8(139))
  call Hloop_AV_Q(ntryL,G1H16(164),ex3(:),G1H8(3),m3h2x8(:,192),heltab2x16(:,:,506))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMB,G2H8(41),n2h8(140))
  call Hloop_TV_S(ntryL,G1H16(165),16,ex3(:),4,G2H8(43),m3h2x8(:,193),heltab2x16(:,:,507))
  call Hloop_SV_T(ntryL,G1H16(166),16,ex3(:),4,G2H8(45),m3h2x8(:,194),heltab2x16(:,:,508))
  call Hloop_TV_S(ntryL,G1H16(167),16,ex3(:),4,G2H8(1),m3h2x8(:,195),heltab2x16(:,:,509))
  call Hloop_SV_T(ntryL,G1H16(168),16,ex3(:),4,G2H8(2),m3h2x8(:,196),heltab2x16(:,:,510))
  call Hloop_CV_D(ntryL,G1H16(173),16,ex3(:),4,G2H8(3),m3h2x8(:,197),heltab2x16(:,:,511))
  call Hloop_DV_C(ntryL,G1H16(174),16,ex3(:),G2H8(4),m3h2x8(:,198),heltab2x16(:,:,512))
  call Hloop_CV_D(ntryL,G1H16(179),16,ex3(:),4,G2H8(5),m3h2x8(:,199),heltab2x16(:,:,513))
  call Hloop_DV_C(ntryL,G1H16(180),16,ex3(:),G2H8(6),m3h2x8(:,200),heltab2x16(:,:,514))
  call Hloop_UV_W(ntryL,G1H16(181),16,ex3(:),4,G2H8(7),m3h2x8(:,201),heltab2x16(:,:,515))
  call Hloop_UW_V(ntryL,G1H16(182),16,ex3(:),4,G2H8(8),m3h2x8(:,202),heltab2x16(:,:,516))
  call Hloop_UV_W(ntryL,G1H16(183),16,ex3(:),4,G2H8(9),m3h2x8(:,203),heltab2x16(:,:,517))
  call Hloop_UW_V(ntryL,G1H16(184),16,ex3(:),4,G2H8(10),m3h2x8(:,204),heltab2x16(:,:,518))
  call Hloop_TV_S(ntryL,G0H16(85),16,ex3(:),4,G1H8(54),m3h2x8(:,205),heltab2x16(:,:,519))
  call Hloop_SV_T(ntryL,G0H16(86),16,ex3(:),4,G1H8(55),m3h2x8(:,206),heltab2x16(:,:,520))
  call Hloop_TV_S(ntryL,G0H16(87),16,ex3(:),4,G1H8(57),m3h2x8(:,207),heltab2x16(:,:,521))
  call Hloop_SV_T(ntryL,G0H16(88),16,ex3(:),4,G1H8(58),m3h2x8(:,208),heltab2x16(:,:,522))
  call Hloop_SV_V(ntryL,G1H16(186),ex3(:),G1H8(59),m3h2x8(:,209),heltab2x16(:,:,523))
  call Hloop_SV_V(ntryL,G1H16(188),ex3(:),G1H8(60),m3h2x8(:,210),heltab2x16(:,:,524))
  call Hloop_VV_S(ntryL,G0H16(89),ex3(:),G0H8(14),m3h2x8(:,211),heltab2x16(:,:,525))
  call Hloop_VV_S(ntryL,G0H16(90),ex3(:),G0H8(21),m3h2x8(:,212),heltab2x16(:,:,526))
  call Hloop_VV_S(ntryL,G0H16(91),ex3(:),G0H8(22),m3h2x8(:,213),heltab2x16(:,:,527))
  call Hloop_VV_S(ntryL,G0H16(92),ex3(:),G0H8(24),m3h2x8(:,214),heltab2x16(:,:,528))
  call Hloop_SV_V(ntryL,G0H16(93),ex3(:),G0H8(35),m3h2x8(:,215),heltab2x16(:,:,529))
  call Hloop_SV_V(ntryL,G0H16(94),ex3(:),G0H8(36),m3h2x8(:,216),heltab2x16(:,:,530))
  call Hloop_SV_V(ntryL,G0H16(95),ex3(:),G0H8(12),m3h2x8(:,217),heltab2x16(:,:,531))
  call Hloop_SV_V(ntryL,G0H16(96),ex3(:),G0H8(4),m3h2x8(:,218),heltab2x16(:,:,532))
  call Hloop_VV_S(ntryL,G1H16(190),ex3(:),G1H8(62),m3h2x8(:,219),heltab2x16(:,:,533))
  call Hloop_VV_S(ntryL,G1H16(192),ex3(:),G1H8(63),m3h2x8(:,220),heltab2x16(:,:,534))
  call Hloop_UV_W(ntryL,G0H16(97),16,ex3(:),4,G1H8(64),m3h2x8(:,221),heltab2x16(:,:,535))
  call Hloop_UW_V(ntryL,G0H16(98),16,ex3(:),4,G1H8(65),m3h2x8(:,222),heltab2x16(:,:,536))
  call Hloop_UV_W(ntryL,G0H16(99),16,ex3(:),4,G1H8(67),m3h2x8(:,223),heltab2x16(:,:,537))
  call Hloop_UW_V(ntryL,G0H16(100),16,ex3(:),4,G1H8(68),m3h2x8(:,224),heltab2x16(:,:,538))
  call Hloop_QA_V(ntryL,G1H16(193),ex2(:),G1H8(69),m3h2x8(:,225),heltab2x16(:,:,539))
  call Hloop_QA_Z(ntryL,G1H16(194),ex2(:),G1H8(70),ngZl,m3h2x8(:,226),heltab2x16(:,:,540))
  call Hloop_WA_Q(ntryL,G1H16(195),ex2(:),G1H8(72),m3h2x8(:,227),heltab2x16(:,:,541))
  call Hloop_A_Q(ntryL,G1H8(72),18,0,G2H8(11),n2h8(141))
  call Hloop_VA_Q(ntryL,G0H4(43),ex2(:),G0H2(29),m3h2x2(:,347),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G0H2(29),27,0,G1H2(132),n2h2(345))
  call Hloop_ZA_Q(ntryL,G0H4(44),ex2(:),G0H2(29),ngZl,m3h2x2(:,348),heltab2x4(:,:,364))
  call Hloop_A_Q(ntryL,G0H2(29),27,0,G1H2(319),n2h2(346))
  call Hloop_QA_W(ntryL,G1H4(103),ex2(:),G1H2(320),m3h2x2(:,349),heltab2x4(:,:,365))
  call Hloop_QV_A(ntryL,G1H8(41),ex3(:),G1H4(20),m3h2x4(:,118),heltab2x8(:,:,358))
  call Hloop_Q_A(ntryL,G1H4(20),21,0,G2H4(62),n2h4(211))
  call Hloop_QV_A(ntryL,G1H8(42),ex3(:),G1H4(35),m3h2x4(:,119),heltab2x8(:,:,359))
  call Hloop_Q_A(ntryL,G1H4(35),21,0,G2H4(63),n2h4(212))
  call Hloop_UV_W(ntryL,G0H8(42),17,ex3(:),4,G1H4(36),m3h2x4(:,120),heltab2x8(:,:,360))
  call Hloop_QV_A(ntryL,G1H16(206),ex3(:),G1H8(73),m3h2x8(:,228),heltab2x16(:,:,542))
  call Hloop_Q_A(ntryL,G1H8(73),20,0,G2H8(12),n2h8(142))
  call Hloop_QV_A(ntryL,G1H16(197),ex3(:),G1H8(74),m3h2x8(:,229),heltab2x16(:,:,543))
  call Hloop_Q_A(ntryL,G1H8(74),20,nMM,G2H8(13),n2h8(143))
  call Hloop_QV_A(ntryL,G1H16(198),ex3(:),G1H8(75),m3h2x8(:,230),heltab2x16(:,:,544))
  call Hloop_Q_A(ntryL,G1H8(75),20,nML,G2H8(14),n2h8(144))
  call Hloop_AV_Q(ntryL,G1H16(208),ex3(:),G1H8(77),m3h2x8(:,231),heltab2x16(:,:,545))
  call Hloop_A_Q(ntryL,G1H8(77),20,0,G2H8(15),n2h8(145))
  call Hloop_AV_Q(ntryL,G1H16(200),ex3(:),G1H8(78),m3h2x8(:,232),heltab2x16(:,:,546))
  call Hloop_A_Q(ntryL,G1H8(78),20,nMM,G2H8(16),n2h8(146))
  call Hloop_AV_Q(ntryL,G1H16(201),ex3(:),G1H8(79),m3h2x8(:,233),heltab2x16(:,:,547))
  call Hloop_A_Q(ntryL,G1H8(79),20,nML,G2H8(17),n2h8(147))
  call Hloop_QV_A(ntryL,G1H16(203),ex3(:),G1H8(80),m3h2x8(:,234),heltab2x16(:,:,548))
  call Hloop_Q_A(ntryL,G1H8(80),20,nMT,G2H8(18),n2h8(148))
  call Hloop_AV_Q(ntryL,G1H16(205),ex3(:),G1H8(82),m3h2x8(:,235),heltab2x16(:,:,549))
  call Hloop_A_Q(ntryL,G1H8(82),20,nMT,G2H8(19),n2h8(149))
  call Hloop_QV_A(ntryL,G1H16(207),ex3(:),G1H8(83),m3h2x8(:,236),heltab2x16(:,:,550))
  call Hloop_Q_A(ntryL,G1H8(83),20,nMB,G2H8(20),n2h8(150))
  call Hloop_AV_Q(ntryL,G1H16(209),ex3(:),G1H8(84),m3h2x8(:,237),heltab2x16(:,:,551))
  call Hloop_A_Q(ntryL,G1H8(84),20,nMB,G2H8(57),n2h8(151))
  call Hloop_QV_A(ntryL,G1H16(210),ex3(:),G1H8(85),m3h2x8(:,238),heltab2x16(:,:,552))
  call Hloop_Q_A(ntryL,G1H8(85),20,0,G2H8(58),n2h8(152))
  call Hloop_QV_A(ntryL,G1H16(211),ex3(:),G1H8(87),m3h2x8(:,239),heltab2x16(:,:,553))
  call Hloop_Q_A(ntryL,G1H8(87),20,nMM,G2H8(59),n2h8(153))
  call Hloop_QV_A(ntryL,G1H16(212),ex3(:),G1H8(88),m3h2x8(:,240),heltab2x16(:,:,554))
  call Hloop_Q_A(ntryL,G1H8(88),20,nML,G2H8(60),n2h8(154))
  call Hloop_AV_Q(ntryL,G1H16(213),ex3(:),G1H8(89),m3h2x8(:,241),heltab2x16(:,:,555))
  call Hloop_A_Q(ntryL,G1H8(89),20,0,G2H8(61),n2h8(155))
  call Hloop_AV_Q(ntryL,G1H16(214),ex3(:),G1H8(90),m3h2x8(:,242),heltab2x16(:,:,556))
  call Hloop_A_Q(ntryL,G1H8(90),20,nMM,G2H8(62),n2h8(156))
  call Hloop_AV_Q(ntryL,G1H16(215),ex3(:),G1H8(92),m3h2x8(:,243),heltab2x16(:,:,557))
  call Hloop_A_Q(ntryL,G1H8(92),20,nML,G2H8(63),n2h8(157))
  call Hloop_QV_A(ntryL,G1H16(216),ex3(:),G1H8(93),m3h2x8(:,244),heltab2x16(:,:,558))
  call Hloop_Q_A(ntryL,G1H8(93),20,0,G2H8(64),n2h8(158))
  call Hloop_QV_A(ntryL,G1H16(217),ex3(:),G1H8(94),m3h2x8(:,245),heltab2x16(:,:,559))
  call Hloop_Q_A(ntryL,G1H8(94),20,nMT,G2H8(65),n2h8(159))
  call Hloop_AV_Q(ntryL,G1H16(218),ex3(:),G1H8(95),m3h2x8(:,246),heltab2x16(:,:,560))
  call Hloop_A_Q(ntryL,G1H8(95),20,0,G2H8(66),n2h8(160))
  call Hloop_AV_Q(ntryL,G1H16(219),ex3(:),G1H8(97),m3h2x8(:,247),heltab2x16(:,:,561))
  call Hloop_A_Q(ntryL,G1H8(97),20,nMT,G2H8(67),n2h8(161))
  call Hloop_QV_A(ntryL,G1H16(220),ex3(:),G1H8(98),m3h2x8(:,248),heltab2x16(:,:,562))
  call Hloop_Q_A(ntryL,G1H8(98),20,0,G2H8(68),n2h8(162))
  call Hloop_QV_A(ntryL,G1H16(221),ex3(:),G1H8(99),m3h2x8(:,249),heltab2x16(:,:,563))
  call Hloop_Q_A(ntryL,G1H8(99),20,nMB,G2H8(69),n2h8(163))
  call Hloop_AV_Q(ntryL,G1H16(222),ex3(:),G1H8(100),m3h2x8(:,250),heltab2x16(:,:,564))
  call Hloop_A_Q(ntryL,G1H8(100),20,0,G2H8(70),n2h8(164))
  call Hloop_AV_Q(ntryL,G1H16(223),ex3(:),G1H8(102),m3h2x8(:,251),heltab2x16(:,:,565))
  call Hloop_A_Q(ntryL,G1H8(102),20,nMB,G2H8(71),n2h8(165))
  call Hloop_TV_S(ntryL,G1H16(224),16,ex3(:),4,G2H8(72),m3h2x8(:,252),heltab2x16(:,:,566))
  call Hloop_SV_T(ntryL,G1H16(225),16,ex3(:),4,G2H8(73),m3h2x8(:,253),heltab2x16(:,:,567))
  call Hloop_TV_S(ntryL,G1H16(226),16,ex3(:),4,G2H8(74),m3h2x8(:,254),heltab2x16(:,:,568))
  call Hloop_SV_T(ntryL,G1H16(227),16,ex3(:),4,G2H8(75),m3h2x8(:,255),heltab2x16(:,:,569))
  call Hloop_CV_D(ntryL,G1H16(230),16,ex3(:),4,G2H8(76),m3h2x8(:,256),heltab2x16(:,:,570))
  call Hloop_DV_C(ntryL,G1H16(231),16,ex3(:),G2H8(77),m3h2x8(:,257),heltab2x16(:,:,571))
  call Hloop_CV_D(ntryL,G1H16(234),16,ex3(:),4,G2H8(78),m3h2x8(:,258),heltab2x16(:,:,572))
  call Hloop_DV_C(ntryL,G1H16(235),16,ex3(:),G2H8(79),m3h2x8(:,259),heltab2x16(:,:,573))
  call Hloop_UV_W(ntryL,G1H16(236),16,ex3(:),4,G2H8(80),m3h2x8(:,260),heltab2x16(:,:,574))
  call Hloop_UW_V(ntryL,G1H16(237),16,ex3(:),4,G2H8(81),m3h2x8(:,261),heltab2x16(:,:,575))
  call Hloop_UV_W(ntryL,G1H16(238),16,ex3(:),4,G2H8(82),m3h2x8(:,262),heltab2x16(:,:,576))
  call Hloop_UW_V(ntryL,G1H16(239),16,ex3(:),4,G2H8(83),m3h2x8(:,263),heltab2x16(:,:,577))
  call Hloop_TV_S(ntryL,G0H16(82),16,ex3(:),4,G1H8(103),m3h2x8(:,264),heltab2x16(:,:,578))
  call Hloop_SV_T(ntryL,G0H16(84),16,ex3(:),4,G1H8(104),m3h2x8(:,265),heltab2x16(:,:,579))
  call Hloop_TV_S(ntryL,G0H16(101),16,ex3(:),4,G1H8(105),m3h2x8(:,266),heltab2x16(:,:,580))
  call Hloop_SV_T(ntryL,G0H16(102),16,ex3(:),4,G1H8(107),m3h2x8(:,267),heltab2x16(:,:,581))
  call Hloop_SV_V(ntryL,G1H16(241),ex3(:),G1H8(108),m3h2x8(:,268),heltab2x16(:,:,582))
  call Hloop_SV_V(ntryL,G1H16(243),ex3(:),G1H8(109),m3h2x8(:,269),heltab2x16(:,:,583))
  call Hloop_VV_S(ntryL,G0H16(31),ex3(:),G0H8(3),m3h2x8(:,270),heltab2x16(:,:,584))
  call Hloop_VV_S(ntryL,G0H16(32),ex3(:),G0H8(18),m3h2x8(:,271),heltab2x16(:,:,585))
  call Hloop_VV_S(ntryL,G0H16(33),ex3(:),G0H8(25),m3h2x8(:,272),heltab2x16(:,:,586))
  call Hloop_VV_S(ntryL,G0H16(34),ex3(:),G0H8(27),m3h2x8(:,273),heltab2x16(:,:,587))
  call Hloop_SV_V(ntryL,G0H16(35),ex3(:),G0H8(29),m3h2x8(:,274),heltab2x16(:,:,588))
  call Hloop_SV_V(ntryL,G0H16(36),ex3(:),G0H8(31),m3h2x8(:,275),heltab2x16(:,:,589))
  call Hloop_SV_V(ntryL,G0H16(37),ex3(:),G0H8(23),m3h2x8(:,276),heltab2x16(:,:,590))
  call Hloop_SV_V(ntryL,G0H16(38),ex3(:),G0H8(5),m3h2x8(:,277),heltab2x16(:,:,591))
  call Hloop_VV_S(ntryL,G1H16(245),ex3(:),G1H8(110),m3h2x8(:,278),heltab2x16(:,:,592))
  call Hloop_VV_S(ntryL,G1H16(247),ex3(:),G1H8(112),m3h2x8(:,279),heltab2x16(:,:,593))
  call Hloop_UV_W(ntryL,G0H16(39),16,ex3(:),4,G1H8(113),m3h2x8(:,280),heltab2x16(:,:,594))
  call Hloop_UW_V(ntryL,G0H16(40),16,ex3(:),4,G1H8(114),m3h2x8(:,281),heltab2x16(:,:,595))
  call Hloop_UV_W(ntryL,G0H16(41),16,ex3(:),4,G1H8(115),m3h2x8(:,282),heltab2x16(:,:,596))
  call Hloop_UW_V(ntryL,G0H16(42),16,ex3(:),4,G1H8(117),m3h2x8(:,283),heltab2x16(:,:,597))
  call Hloop_AQ_V(ntryL,G1H16(248),ex1(:),G1H8(118),m3h2x8(:,284),heltab2x16(:,:,598))
  call Hloop_AQ_Z(ntryL,G1H16(249),ex1(:),G1H8(119),ngZl,m3h2x8(:,285),heltab2x16(:,:,599))
  call Hloop_WQ_A(ntryL,G1H16(250),ex1(:),G1H8(120),m3h2x8(:,286),heltab2x16(:,:,600))
  call Hloop_Q_A(ntryL,G1H8(120),17,0,G2H8(84),n2h8(166))
  call Hloop_VQ_A(ntryL,G0H4(63),ex1(:),G0H2(29),m3h2x2(:,350),heltab2x4(:,:,366))
  call Hloop_Q_A(ntryL,G0H2(29),27,0,G1H2(321),n2h2(347))
  call Hloop_ZQ_A(ntryL,G0H4(64),ex1(:),G0H2(29),ngZl,m3h2x2(:,351),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G0H2(29),27,0,G1H2(324),n2h2(348))
  call Hloop_AQ_W(ntryL,G1H4(169),ex1(:),G1H2(141),m3h2x2(:,352),heltab2x4(:,:,368))
  call Hloop_SV_T(ntryL,G0H4(47),19,ex3(:),4,G1H2(143),m3h2x2(:,353),heltab2x4(:,:,369))
  call Hloop_TV_S(ntryL,G0H4(48),19,ex3(:),4,G1H2(327),m3h2x2(:,354),heltab2x4(:,:,370))
  call Hloop_VV_S(ntryL,G0H4(51),ex3(:),G0H2(29),m3h2x2(:,355),heltab2x4(:,:,371))
  call Hloop_VV_S(ntryL,G0H4(52),ex3(:),G0H2(30),m3h2x2(:,356),heltab2x4(:,:,372))
  call Hloop_SV_V(ntryL,G0H4(55),ex3(:),G0H2(31),m3h2x2(:,357),heltab2x4(:,:,373))
  call Hloop_SV_V(ntryL,G0H4(56),ex3(:),G0H2(32),m3h2x2(:,358),heltab2x4(:,:,374))
  call Hloop_UW_V(ntryL,G0H4(59),19,ex3(:),4,G1H2(152),m3h2x2(:,359),heltab2x4(:,:,375))
  call Hloop_UV_W(ntryL,G0H4(60),19,ex3(:),4,G1H2(154),m3h2x2(:,360),heltab2x4(:,:,376))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(208),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(2)])
call HGT_OLR(G2H2(102),1,1,2)
call HGT_invQ_OLR(G2H2(102),2,5,2)
call HGT_OLR(G2H2(102),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(8),G2H2(297),G2H2(92),G2H2(85),G2H2(83) &
    ,G2H2(331),G2H2(255),G2H2(290),G2H2(278),G2H2(260),G2H2(230),G2H2(103),G1H2(296),G1H2(293),G1H2(279),G1H2(147),G1H2(58) &
    ,G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(197),G1H2(81)])
call HGT_lower_alpha_OLR(G2H2(106),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(106),2,5,2)
call HGT_lower_alpha_OLR(G2H2(106),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(117),G2H2(87),G2H2(86),G2H2(332),G2H2(326) &
    ,G2H2(107),G1H2(94),G1H2(133),G1H2(290),G1H2(265),G1H2(114),G1H2(49),G0H2(28),G0H2(26),G0H2(20),G0H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(73),G2H2(52),G2H2(285),G1H2(1),G1H2(180) &
    ,G1H2(135)])
call HGT_OLR(G2H2(110),1,1,2)
call HGT_invQ_OLR(G2H2(110),2,5,2)
call HGT_OLR(G2H2(110),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G1H2(304),G1H2(30),G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(247),[G2H2(244),G1H2(117),G1H2(27)])
call HGT_lower_alpha_OLR(G2H2(114),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(114),2,5,2)
call HGT_lower_alpha_OLR(G2H2(114),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G1H2(315),G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(212),[G1H2(156)])
call HGT_OLR(G2H2(118),1,1,2)
call HGT_invQ_OLR(G2H2(118),2,5,2)
call HGT_OLR(G2H2(118),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G2H2(101),G2H2(2),G2H2(66),G2H2(84),G2H2(22) &
    ,G2H2(316),G2H2(250),G2H2(296),G2H2(284),G2H2(269),G2H2(239),G2H2(119),G1H2(323),G1H2(271),G1H2(268),G1H2(217),G1H2(203) &
    ,G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(12),G1H2(222)])
call HGT_lower_alpha_OLR(G2H2(122),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(122),2,5,2)
call HGT_lower_alpha_OLR(G2H2(122),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(21),G2H2(62),G2H2(58),G2H2(335),G2H2(329) &
    ,G2H2(123),G1H2(28),G1H2(6),G1H2(334),G1H2(262),G1H2(227),G1H2(40),G0H2(27),G0H2(25),G0H2(19),G0H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(61),G2H2(53),G2H2(279),G1H2(242),G1H2(232) &
    ,G1H2(115)])
call HGT_OLR(G2H2(126),1,1,2)
call HGT_invQ_OLR(G2H2(126),2,5,2)
call HGT_OLR(G2H2(126),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(127),[G1H2(342),G1H2(247),G1H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(249),[G2H2(246),G1H2(252),G1H2(4)])
call HGT_lower_alpha_OLR(G2H2(130),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(130),2,5,2)
call HGT_lower_alpha_OLR(G2H2(130),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G2H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(131),[G1H2(353),G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(270),G1H2(442)])
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(240),G1H2(446)])
call HGT_OLR(G2H2(138),1,1,2)
call HGT_invQ_OLR(G2H2(138),2,5,2)
call HGT_OLR(G2H2(138),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G2H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(261),G1H2(449)])
call HGT_OLR(G2H2(142),1,1,2)
call HGT_invQ_OLR(G2H2(142),2,5,2)
call HGT_OLR(G2H2(142),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(231),G1H2(453)])
call HGT_OLR(G2H2(146),1,1,2)
call HGT_invQ_OLR(G2H2(146),2,5,2)
call HGT_OLR(G2H2(146),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(40),G1H2(457)])
call HGT_OLR(G2H2(150),1,1,2)
call HGT_invQ_OLR(G2H2(150),2,5,2)
call HGT_OLR(G2H2(150),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(151),[G1H2(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(37),G1H2(461)])
call HGT_OLR(G2H2(154),1,1,2)
call HGT_invQ_OLR(G2H2(154),2,5,2)
call HGT_OLR(G2H2(154),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(154),[G2H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G1H2(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(45),G1H2(465)])
call HGT_OLR(G2H2(158),1,1,2)
call HGT_invQ_OLR(G2H2(158),2,5,2)
call HGT_OLR(G2H2(158),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(41),G1H2(469)])
call HGT_OLR(G2H2(162),1,1,2)
call HGT_invQ_OLR(G2H2(162),2,5,2)
call HGT_OLR(G2H2(162),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G1H2(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(232),[G2H2(301),G1H2(375)])
call HGT_OLR(G2H2(166),1,1,2)
call HGT_invQ_OLR(G2H2(166),2,5,2)
call HGT_OLR(G2H2(166),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G2H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G2H2(304),G1H2(380)])
call HGT_OLR(G2H2(170),1,1,2)
call HGT_invQ_OLR(G2H2(170),2,5,2)
call HGT_OLR(G2H2(170),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G2H2(235),G1H2(118)])
call HGT_OLR(G2H2(174),1,1,2)
call HGT_invQ_OLR(G2H2(174),2,5,2)
call HGT_OLR(G2H2(174),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G2H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(237),G1H2(475)])
call HGT_OLR(G2H2(178),1,1,2)
call HGT_invQ_OLR(G2H2(178),2,5,2)
call HGT_OLR(G2H2(178),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G2H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G1H2(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(333),[G2H2(88),G2H2(318),G2H2(252),G2H2(272),G2H2(242) &
    ,G2H2(183),G1H2(450),G1H2(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(70),G2H2(334),G2H2(253),G2H2(275),G2H2(245) &
    ,G2H2(187),G1H2(454),G1H2(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(74),G2H2(18),G2H2(256),G2H2(263),G2H2(233) &
    ,G2H2(191),G1H2(443),G1H2(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(93),G2H2(295),G2H2(258),G2H2(266),G2H2(236) &
    ,G2H2(195),G1H2(447),G1H2(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(78),G2H2(26),G2H2(303),G2H2(287),G2H2(251) &
    ,G2H2(199),G1H2(462),G1H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(94),G2H2(30),G2H2(306),G2H2(281),G2H2(248) &
    ,G2H2(203),G1H2(458),G1H2(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G2H2(1),G2H2(34),G2H2(313),G2H2(299),G2H2(257) &
    ,G2H2(207),G1H2(470),G1H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(291),[G2H2(336),G2H2(38),G2H2(315),G2H2(293),G2H2(254) &
    ,G2H2(211),G1H2(466),G1H2(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(175)])
call HGT_OLR(G2H2(214),1,1,2)
call HGT_invQ_OLR(G2H2(214),2,5,2)
call HGT_OLR(G2H2(214),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(14),G2H2(46),G2H2(289),G2H2(311),G2H2(305) &
    ,G2H2(215),G1H2(188),G1H2(24),G1H2(381),G1H2(366),G0H2(23),G0H2(21),G0H2(15),G0H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(186)])
call HGT_OLR(G2H2(218),1,1,2)
call HGT_invQ_OLR(G2H2(218),2,5,2)
call HGT_OLR(G2H2(218),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(218),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(16),G2H2(89),G2H2(42),G2H2(308),G2H2(302) &
    ,G2H2(219),G1H2(134),G1H2(106),G1H2(376),G1H2(371),G0H2(24),G0H2(22),G0H2(16),G0H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(17),G2H2(54),G2H2(50),G2H2(323),G2H2(317) &
    ,G2H2(223),G1H2(476),G1H2(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(20),G2H2(91),G2H2(90),G2H2(320),G2H2(314) &
    ,G2H2(227),G1H2(472),G1H2(440)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(321),[G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(274),G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(324),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(282),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G1H2(285),G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(292),G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(316),[G1H2(295),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(307),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(130),[G1H2(264),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(310),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(318),G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(319),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(326),G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(320),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(329),G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(267),G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(337),[G1H2(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(266),[G1H2(270),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(345),[G1H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(261),G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(348),[G1H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(325),[G1H2(281),G1H2(278),G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(289),G1H2(284),G0H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(283),[G1H2(306),G1H2(303),G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(268),[G1H2(314),G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G1H2(325),G1H2(322),G1H2(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(333),G1H2(328),G0H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(344),G1H2(341),G1H2(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(352),G1H2(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(365),G0H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(370),G0H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(179),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(277),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(259),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(229),[G1H2(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G1H2(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(330),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(327),[G1H2(439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(152),G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(327),[G1H2(143),G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G2H8(21),G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(23),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G2H8(25),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(27),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(2),[G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(4),[G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(312),[G1H2(311),G1H2(108),G1H2(305),G1H2(302),G1H2(301) &
    ,G1H2(9),G1H2(263),G1H2(254),G1H2(253),G1H2(250),G1H2(249),G0H2(6),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(121),[G1H2(119),G1H2(308),G1H2(110),G1H2(300),G1H2(98) &
    ,G1H2(260),G1H2(259),G1H2(258),G1H2(255),G1H2(248),G1H2(245),G0H2(8),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(10),[G0H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(12),[G0H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(4),G2H4(2),G2H4(1),G0H4(12),G0H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(33),G2H4(10),G2H4(8),G0H4(21),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G0H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G0H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G1H8(55),G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(58),G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(64),G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(67),G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(72),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(73),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(74),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(75),[G0H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G0H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(81),[G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(82),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(83),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(110),[G1H8(104),G1H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(107),G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(114),[G1H8(113),G1H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(117),[G1H8(115),G1H8(109)])
call HGT_w2_OLR(G1H2(208),1,1,2)
call HGT_w2_invQ_OLR(G1H2(208),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(208),ex1(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(375))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(96),ex2(:),G2tensor(17),m3h2x1(:,522),heltab2x2(:,:,522))
call HGT_w2_OLR(G1H2(207),1,1,2)
call HGT_w2_invQ_OLR(G1H2(207),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(207),ex2(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(376))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(99),ex1(:),G2tensor(21),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hloop_QV_A(ntryL,G2H2(102),ex3(:),G2H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(49),n2h1(377))
  call Hloop_QV_A(ntryL,G2H2(11),ex4(:),G2H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(50),n2h1(378))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(106),27,ex3(:),4,G3tensor(51),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(24),23,ex4(:),8,G3tensor(52),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hloop_QV_A(ntryL,G2H2(110),ex4(:),G2H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(53),n2h1(379))
  call Hloop_QV_A(ntryL,G2H2(111),ex3(:),G2H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(54),n2h1(380))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(114),23,ex4(:),8,G3tensor(55),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(115),27,ex3(:),4,G3tensor(56),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hloop_AV_Q(ntryL,G2H2(118),ex3(:),G2H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(57),n2h1(381))
  call Hloop_AV_Q(ntryL,G2H2(105),ex4(:),G2H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(58),n2h1(382))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(122),27,ex3(:),4,G3tensor(59),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(120),23,ex4(:),8,G3tensor(60),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hloop_AV_Q(ntryL,G2H2(126),ex4(:),G2H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(61),n2h1(383))
  call Hloop_AV_Q(ntryL,G2H2(127),ex3(:),G2H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(62),n2h1(384))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(130),23,ex4(:),8,G3tensor(63),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(131),27,ex3(:),4,G3tensor(64),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hloop_QV_A(ntryL,G2H2(134),ex4(:),G2H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(65),n2h1(385))
  call Hloop_QV_A(ntryL,G2H2(135),ex3(:),G2H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(66),n2h1(386))
  call Hloop_QV_A(ntryL,G2H2(138),ex4(:),G2H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(67),n2h1(387))
  call Hloop_QV_A(ntryL,G2H2(139),ex3(:),G2H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(68),n2h1(388))
  call Hloop_AV_Q(ntryL,G2H2(142),ex4(:),G2H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(69),n2h1(389))
  call Hloop_AV_Q(ntryL,G2H2(143),ex3(:),G2H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(70),n2h1(390))
  call Hloop_AV_Q(ntryL,G2H2(146),ex4(:),G2H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(71),n2h1(391))
  call Hloop_AV_Q(ntryL,G2H2(147),ex3(:),G2H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(72),n2h1(392))
  call Hloop_QV_A(ntryL,G2H2(150),ex4(:),G2H1(1),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(73),n2h1(393))
  call Hloop_QV_A(ntryL,G2H2(151),ex3(:),G2H1(1),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(74),n2h1(394))
  call Hloop_AV_Q(ntryL,G2H2(154),ex4(:),G2H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(75),n2h1(395))
  call Hloop_AV_Q(ntryL,G2H2(155),ex3(:),G2H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(76),n2h1(396))
  call Hloop_QV_A(ntryL,G2H2(158),ex4(:),G2H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(77),n2h1(397))
  call Hloop_QV_A(ntryL,G2H2(159),ex3(:),G2H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(78),n2h1(398))
  call Hloop_AV_Q(ntryL,G2H2(162),ex4(:),G2H1(1),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(79),n2h1(399))
  call Hloop_AV_Q(ntryL,G2H2(163),ex3(:),G2H1(1),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(80),n2h1(400))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(166),23,ex4(:),8,G3tensor(81),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(167),27,ex3(:),4,G3tensor(82),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(170),23,ex4(:),8,G3tensor(83),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(171),27,ex3(:),4,G3tensor(84),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(174),23,ex4(:),8,G3tensor(85),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(175),27,ex3(:),4,G3tensor(86),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(178),23,ex4(:),G3tensor(87),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(179),27,ex3(:),G3tensor(88),m3h2x1(:,564),heltab2x2(:,:,564))
call HGT_OLR(G2H2(182),1,1,2)
call HGT_invQ_OLR(G2H2(182),2,5,2)
call HGT_OLR(G2H2(182),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(182),ex3(:),G2H1(1),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(89),n2h1(401))
  call Hloop_AV_Q(ntryL,G2H2(333),ex4(:),G2H1(1),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(90),n2h1(402))
call HGT_OLR(G2H2(186),1,1,2)
call HGT_invQ_OLR(G2H2(186),2,5,2)
call HGT_OLR(G2H2(186),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(186),ex3(:),G2H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(91),n2h1(403))
  call Hloop_AV_Q(ntryL,G2H2(4),ex4(:),G2H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(92),n2h1(404))
call HGT_OLR(G2H2(190),1,1,2)
call HGT_invQ_OLR(G2H2(190),2,5,2)
call HGT_OLR(G2H2(190),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(190),ex3(:),G2H1(1),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(93),n2h1(405))
  call Hloop_QV_A(ntryL,G2H2(6),ex4(:),G2H1(1),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(94),n2h1(406))
call HGT_OLR(G2H2(194),1,1,2)
call HGT_invQ_OLR(G2H2(194),2,5,2)
call HGT_OLR(G2H2(194),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(194),ex3(:),G2H1(1),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(95),n2h1(407))
  call Hloop_QV_A(ntryL,G2H2(7),ex4(:),G2H1(1),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(96),n2h1(408))
call HGT_OLR(G2H2(198),1,1,2)
call HGT_invQ_OLR(G2H2(198),2,5,2)
call HGT_OLR(G2H2(198),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(198),ex3(:),G2H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(97),n2h1(409))
  call Hloop_AV_Q(ntryL,G2H2(104),ex4(:),G2H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(98),n2h1(410))
call HGT_OLR(G2H2(202),1,1,2)
call HGT_invQ_OLR(G2H2(202),2,5,2)
call HGT_OLR(G2H2(202),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(202),ex3(:),G2H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(99),n2h1(411))
  call Hloop_QV_A(ntryL,G2H2(9),ex4(:),G2H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(100),n2h1(412))
call HGT_OLR(G2H2(206),1,1,2)
call HGT_invQ_OLR(G2H2(206),2,5,2)
call HGT_OLR(G2H2(206),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(206),ex3(:),G2H1(1),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(101),n2h1(413))
  call Hloop_AV_Q(ntryL,G2H2(108),ex4(:),G2H1(1),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(102),n2h1(414))
call HGT_OLR(G2H2(210),1,1,2)
call HGT_invQ_OLR(G2H2(210),2,5,2)
call HGT_OLR(G2H2(210),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(210),ex3(:),G2H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(103),n2h1(415))
  call Hloop_QV_A(ntryL,G2H2(291),ex4(:),G2H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(104),n2h1(416))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(214),27,ex3(:),4,G3tensor(105),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(109),23,ex4(:),8,G3tensor(106),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(218),27,ex3(:),4,G3tensor(107),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(112),23,ex4(:),8,G3tensor(108),m3h2x1(:,584),heltab2x2(:,:,584))
call HGT_OLR(G2H2(222),1,1,2)
call HGT_invQ_OLR(G2H2(222),2,5,2)
call HGT_OLR(G2H2(222),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(222),27,ex3(:),G3tensor(109),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(113),23,ex4(:),G3tensor(110),m3h2x1(:,586),heltab2x2(:,:,586))
call HGT_OLR(G2H2(226),1,1,2)
call HGT_invQ_OLR(G2H2(226),2,5,2)
call HGT_OLR(G2H2(226),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(226),27,ex3(:),4,G3tensor(111),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(116),23,ex4(:),8,G3tensor(112),m3h2x1(:,588),heltab2x2(:,:,588))
call HGT_OLR(G2H4(11),1,1,4)
call HGT_invQ_OLR(G2H4(11),2,5,4)
call HGT_OLR(G2H4(11),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(11),wf4(:,13),G2H1(1),m3h4x1(:,17),heltab2x4(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(113),n2h1(417))
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(12),wf4(:,13),G2H1(1),m3h4x1(:,18),heltab2x4(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(114),n2h1(418))
call HGT_OLR(G2H4(35),1,1,4)
call HGT_invQ_OLR(G2H4(35),2,5,4)
call HGT_OLR(G2H4(35),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(35),wf4(:,13),G2H1(1),m3h4x1(:,19),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(115),n2h1(419))
call HGT_OLR(G2H4(36),1,1,4)
call HGT_invQ_OLR(G2H4(36),2,5,4)
call HGT_OLR(G2H4(36),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(36),wf4(:,13),G2H1(1),m3h4x1(:,20),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(116),n2h1(420))
call HGT_OLR(G2H4(45),1,1,4)
call HGT_invQ_OLR(G2H4(45),2,5,4)
call HGT_OLR(G2H4(45),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(45),wf4(:,13),G2H1(1),m3h4x1(:,21),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(117),n2h1(421))
call HGT_OLR(G2H4(44),1,1,4)
call HGT_invQ_OLR(G2H4(44),2,5,4)
call HGT_OLR(G2H4(44),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(44),wf4(:,13),G2H1(1),m3h4x1(:,22),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(118),n2h1(422))
call HGT_OLR(G2H4(43),1,1,4)
call HGT_invQ_OLR(G2H4(43),2,5,4)
call HGT_OLR(G2H4(43),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(43),wf4(:,13),G2H1(1),m3h4x1(:,23),heltab2x4(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(119),n2h1(423))
call HGT_OLR(G2H4(49),1,1,4)
call HGT_invQ_OLR(G2H4(49),2,5,4)
call HGT_OLR(G2H4(49),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(49),wf4(:,13),G2H1(1),m3h4x1(:,24),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(120),n2h1(424))
call HGT_OLR(G2H4(48),1,1,4)
call HGT_invQ_OLR(G2H4(48),2,5,4)
call HGT_OLR(G2H4(48),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(48),wf4(:,13),G2H1(1),m3h4x1(:,25),heltab2x4(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(121),n2h1(425))
call HGT_OLR(G2H4(47),1,1,4)
call HGT_invQ_OLR(G2H4(47),2,5,4)
call HGT_OLR(G2H4(47),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(47),wf4(:,13),G2H1(1),m3h4x1(:,26),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(122),n2h1(426))
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(52),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,27),heltab2x4(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(123),n2h1(427))
call HGT_OLR(G2H4(53),1,1,4)
call HGT_invQ_OLR(G2H4(53),2,5,4)
call HGT_OLR(G2H4(53),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(53),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,28),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(124),n2h1(428))
call HGT_OLR(G2H4(55),1,1,4)
call HGT_invQ_OLR(G2H4(55),2,5,4)
call HGT_OLR(G2H4(55),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(55),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,29),heltab2x4(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(125),n2h1(429))
call HGT_OLR(G2H4(56),1,1,4)
call HGT_invQ_OLR(G2H4(56),2,5,4)
call HGT_OLR(G2H4(56),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(56),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,30),heltab2x4(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(126),n2h1(430))
call HGT_OLR(G2H4(57),1,1,4)
call HGT_invQ_OLR(G2H4(57),2,5,4)
call HGT_OLR(G2H4(57),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(57),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(127),n2h1(431))
call HGT_OLR(G2H4(58),1,1,4)
call HGT_invQ_OLR(G2H4(58),2,5,4)
call HGT_OLR(G2H4(58),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(58),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,32),heltab2x4(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(128),n2h1(432))
call HGT_OLR(G2H4(59),1,1,4)
call HGT_invQ_OLR(G2H4(59),2,5,4)
call HGT_OLR(G2H4(59),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(59),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,33),heltab2x4(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(129),n2h1(433))
call HGT_OLR(G2H4(60),1,1,4)
call HGT_invQ_OLR(G2H4(60),2,5,4)
call HGT_OLR(G2H4(60),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(60),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,34),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(130),n2h1(434))
call HGT_OLR(G2H4(75),1,1,4)
call HGT_invQ_OLR(G2H4(75),2,5,4)
call HGT_OLR(G2H4(75),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(75),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,35),heltab2x4(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(131),n2h1(435))
call HGT_OLR(G2H4(76),1,1,4)
call HGT_invQ_OLR(G2H4(76),2,5,4)
call HGT_OLR(G2H4(76),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(76),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,36),heltab2x4(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(132),n2h1(436))
call HGT_OLR(G2H4(79),1,1,4)
call HGT_invQ_OLR(G2H4(79),2,5,4)
call HGT_OLR(G2H4(79),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(79),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,37),heltab2x4(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(133),n2h1(437))
call HGT_OLR(G2H4(80),1,1,4)
call HGT_invQ_OLR(G2H4(80),2,5,4)
call HGT_OLR(G2H4(80),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(80),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,38),heltab2x4(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(134),n2h1(438))
call HGT_OLR(G2H4(89),1,1,4)
call HGT_invQ_OLR(G2H4(89),2,5,4)
call HGT_OLR(G2H4(89),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(89),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,39),heltab2x4(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(135),n2h1(439))
call HGT_OLR(G2H4(88),1,1,4)
call HGT_invQ_OLR(G2H4(88),2,5,4)
call HGT_OLR(G2H4(88),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(88),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,40),heltab2x4(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(136),n2h1(440))
call HGT_OLR(G2H4(87),1,1,4)
call HGT_invQ_OLR(G2H4(87),2,5,4)
call HGT_OLR(G2H4(87),6,15,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(87),28,wf4(:,13),3,G3tensor(137),m3h4x1(:,41),heltab2x4(:,:,401))
call HGT_OLR(G2H4(93),1,1,4)
call HGT_invQ_OLR(G2H4(93),2,5,4)
call HGT_OLR(G2H4(93),6,15,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(93),28,wf4(:,13),3,G3tensor(138),m3h4x1(:,42),heltab2x4(:,:,402))
call HGT_OLR(G2H4(92),1,1,4)
call HGT_invQ_OLR(G2H4(92),2,5,4)
call HGT_OLR(G2H4(92),6,15,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(92),28,wf4(:,14),3,G3tensor(139),m3h4x1(:,43),heltab2x4(:,:,403))
call HGT_OLR(G2H4(91),1,1,4)
call HGT_invQ_OLR(G2H4(91),2,5,4)
call HGT_OLR(G2H4(91),6,15,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(91),28,wf4(:,14),3,G3tensor(140),m3h4x1(:,44),heltab2x4(:,:,404))
call HGT_OLR(G2H4(24),1,1,4)
call HGT_invQ_OLR(G2H4(24),2,5,4)
call HGT_OLR(G2H4(24),6,15,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(24),28,wf4(:,13),3,G3tensor(141),m3h4x1(:,45),heltab2x4(:,:,405))
call HGT_OLR(G2H4(95),1,1,4)
call HGT_invQ_OLR(G2H4(95),2,5,4)
call HGT_OLR(G2H4(95),6,15,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(95),28,wf4(:,13),G3tensor(142),m3h4x1(:,46),heltab2x4(:,:,406))
call HGT_OLR(G2H4(29),1,1,4)
call HGT_invQ_OLR(G2H4(29),2,5,4)
call HGT_OLR(G2H4(29),6,15,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(29),28,wf4(:,14),3,G3tensor(143),m3h4x1(:,47),heltab2x4(:,:,407))
call HGT_OLR(G2H4(96),1,1,4)
call HGT_invQ_OLR(G2H4(96),2,5,4)
call HGT_OLR(G2H4(96),6,15,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(96),28,wf4(:,14),G3tensor(144),m3h4x1(:,48),heltab2x4(:,:,408))
call HGT_lower_alpha_OLR(G2H4(73),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(73),2,5,4)
call HGT_lower_alpha_OLR(G2H4(73),6,15,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(73),28,wf4(:,13),3,G3tensor(145),m3h4x1(:,49),heltab2x4(:,:,409))
call HGT_lower_alpha_OLR(G2H4(86),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(86),2,5,4)
call HGT_lower_alpha_OLR(G2H4(86),6,15,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(86),28,wf4(:,13),3,G3tensor(146),m3h4x1(:,50),heltab2x4(:,:,410))
call HGT_lower_alpha_OLR(G2H4(7),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(7),2,5,4)
call HGT_lower_alpha_OLR(G2H4(7),6,15,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(7),28,wf4(:,14),3,G3tensor(147),m3h4x1(:,51),heltab2x4(:,:,411))
call HGT_lower_alpha_OLR(G2H4(41),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(41),2,5,4)
call HGT_lower_alpha_OLR(G2H4(41),6,15,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(41),28,wf4(:,14),3,G3tensor(148),m3h4x1(:,52),heltab2x4(:,:,412))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(38),wf4(:,9),G2tensor(24),m3h4x1(:,53),heltab2x4(:,:,413))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(37),wf4(:,4),G2tensor(25),m3h4x1(:,54),heltab2x4(:,:,414))
  call Hloop_VA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(441))
  call Hloop_VA_Q(ntryL,G1H2(82),ex2(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(442))
  call Hloop_ZA_Q(ntryL,G1H2(193),ex2(:),G1H1(1),ngZl,m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(443))
  call Hloop_ZA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),ngZl,m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(444))
  call Hloop_QV_A(ntryL,G1H2(321),ex3(:),G1H1(1),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(445))
  call Hloop_QV_A(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(446))
  call Hloop_QV_A(ntryL,G1H2(324),ex3(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(447))
  call Hloop_QV_A(ntryL,G1H2(172),ex4(:),G1H1(1),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(448))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(141),27,ex3(:),4,G2tensor(41),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(83),23,ex4(:),8,G2tensor(44),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hloop_VQ_A(ntryL,G1H2(113),ex1(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(449))
  call Hloop_VQ_A(ntryL,G1H2(124),ex1(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(450))
  call Hloop_ZQ_A(ntryL,G1H2(146),ex1(:),G1H1(1),ngZl,m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(451))
  call Hloop_ZQ_A(ntryL,G1H2(157),ex1(:),G1H1(1),ngZl,m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(313),ex4(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(299),ex3(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(316),ex4(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(455))
  call Hloop_QV_A(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(456))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(130),23,ex4(:),8,G2tensor(68),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(310),27,ex3(:),4,G2tensor(69),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hloop_AV_Q(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(457))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H2(319),ex3(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H2(269),ex4(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(460))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(320),27,ex3(:),4,G2tensor(80),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(31),23,ex4(:),8,G2tensor(84),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hloop_AV_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(443),n2h1(461))
  call Hloop_AV_Q(ntryL,G1H2(337),ex3(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(344),n2h1(462))
  call Hloop_AV_Q(ntryL,G1H2(266),ex4(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(341),n2h1(463))
  call Hloop_AV_Q(ntryL,G1H2(345),ex3(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(158),n2h1(464))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(20),23,ex4(:),8,G2tensor(155),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(348),27,ex3(:),4,G2tensor(98),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hloop_QV_A(ntryL,G2H2(325),ex4(:),G2H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(149),n2h1(465))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(15),23,ex4(:),8,G3tensor(150),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hloop_QV_A(ntryL,G2H2(283),ex3(:),G2H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(151),n2h1(466))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(268),27,ex3(:),4,G3tensor(152),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hloop_AV_Q(ntryL,G2H2(238),ex4(:),G2H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(153),n2h1(467))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(23),23,ex4(:),8,G3tensor(154),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hloop_AV_Q(ntryL,G2H2(19),ex3(:),G2H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(155),n2h1(468))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(27),27,ex3(:),4,G3tensor(156),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(47),27,ex3(:),4,G3tensor(157),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(13),27,ex3(:),4,G3tensor(158),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(33),23,ex4(:),8,G3tensor(159),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(79),23,ex4(:),8,G3tensor(160),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hloop_VQ_A(ntryL,G1H4(101),wf4(:,9),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(469))
  call Hloop_VQ_A(ntryL,G1H4(181),wf4(:,9),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(413),n2h1(470))
  call Hloop_ZQ_A(ntryL,G1H4(119),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,57),heltab2x4(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(338),n2h1(471))
  call Hloop_ZQ_A(ntryL,G1H4(183),wf4(:,9),G1H1(1),ngZl,m3h4x1(:,58),heltab2x4(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(335),n2h1(472))
  call Hloop_VA_Q(ntryL,G1H4(29),wf4(:,4),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(311),n2h1(473))
  call Hloop_VA_Q(ntryL,G1H4(178),wf4(:,4),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(275),n2h1(474))
  call Hloop_ZA_Q(ntryL,G1H4(58),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,61),heltab2x4(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(96),n2h1(475))
  call Hloop_ZA_Q(ntryL,G1H4(179),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,62),heltab2x4(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(476))
  call Hloop_QV_A(ntryL,G2H2(31),ex3(:),G2H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(161),n2h1(477))
  call Hloop_QV_A(ntryL,G2H2(35),ex3(:),G2H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(162),n2h1(478))
  call Hloop_AV_Q(ntryL,G2H2(277),ex3(:),G2H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(163),n2h1(479))
  call Hloop_AV_Q(ntryL,G2H2(259),ex3(:),G2H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(164),n2h1(480))
  call Hloop_QV_A(ntryL,G2H2(229),ex3(:),G2H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(165),n2h1(481))
  call Hloop_AV_Q(ntryL,G2H2(43),ex3(:),G2H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(166),n2h1(482))
  call Hloop_QV_A(ntryL,G2H2(39),ex3(:),G2H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(167),n2h1(483))
  call Hloop_AV_Q(ntryL,G2H2(10),ex3(:),G2H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(168),n2h1(484))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(51),27,ex3(:),4,G3tensor(169),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(36),27,ex3(:),G3tensor(170),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hloop_AV_Q(ntryL,G2H2(55),ex4(:),G2H1(1),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(171),n2h1(485))
  call Hloop_AV_Q(ntryL,G2H2(59),ex4(:),G2H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(172),n2h1(486))
  call Hloop_QV_A(ntryL,G2H2(63),ex4(:),G2H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(173),n2h1(487))
  call Hloop_QV_A(ntryL,G2H2(67),ex4(:),G2H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(174),n2h1(488))
  call Hloop_AV_Q(ntryL,G2H2(3),ex4(:),G2H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(175),n2h1(489))
  call Hloop_QV_A(ntryL,G2H2(71),ex4(:),G2H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(176),n2h1(490))
  call Hloop_AV_Q(ntryL,G2H2(5),ex4(:),G2H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(177),n2h1(491))
  call Hloop_QV_A(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(178),n2h1(492))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(330),23,ex4(:),G3tensor(179),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(327),23,ex4(:),8,G3tensor(180),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(328),ex2(:),G2tensor(383),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(12),ex1(:),G2tensor(332),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(28),wf4(:,9),G2tensor(329),m3h4x1(:,63),heltab2x4(:,:,423))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(31),wf4(:,4),G2tensor(326),m3h4x1(:,64),heltab2x4(:,:,424))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(154),ex4(:),G1tensor(61),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(327),ex4(:),G1tensor(91),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H8(22),ex4(:),wf4(:,13),G2tensor(296),m4h2x4x1(:,1),heltab3x8(:,:,1))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H8(24),ex4(:),wf4(:,14),G2tensor(94),m4h2x4x1(:,2),heltab3x8(:,:,2))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H8(26),ex4(:),wf4(:,13),G2tensor(93),m4h2x4x1(:,3),heltab3x8(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H8(28),ex4(:),wf4(:,14),G2tensor(164),m4h2x4x1(:,4),heltab3x8(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H2(2),ex3(:),G0tensor(19),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(4),ex3(:),G0tensor(24),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(312),ex4(:),G1tensor(14),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(121),ex4(:),G1tensor(48),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H2(10),ex4(:),G0tensor(29),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(12),ex4(:),G0tensor(34),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H4(6),ex4(:),ex3(:),G2tensor(266),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(34),ex4(:),ex3(:),G2tensor(287),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(173),wf4(:,3),G1tensor(84),m3h4x1(:,65),heltab2x4(:,:,425))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(174),wf4(:,10),G1tensor(62),m3h4x1(:,66),heltab2x4(:,:,426))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(175),ex4(:),ex3(:),G1tensor(63),m4h2x2x1(:,5),heltab3x4(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(176),ex4(:),ex3(:),G1tensor(86),m4h2x2x1(:,6),heltab3x4(:,:,6))
  call Hloop_VQ_A(ntryL,G1H8(43),wf8(:,25),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(493))
  call Hloop_ZQ_A(ntryL,G1H8(44),wf8(:,25),G1H1(1),ngZl,m3h8x1(:,2),heltab2x8(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(494))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(29),wf8(:,25),G2tensor(132),m3h8x1(:,3),heltab2x8(:,:,363))
  call Hloop_VA_Q(ntryL,G1H8(46),wf8(:,30),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(495))
  call Hloop_ZA_Q(ntryL,G1H8(47),wf8(:,30),G1H1(1),ngZl,m3h8x1(:,5),heltab2x8(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(108),n2h1(496))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(30),wf8(:,30),G2tensor(104),m3h8x1(:,6),heltab2x8(:,:,366))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(46),wf4(:,9),G2tensor(105),m3h4x1(:,67),heltab2x4(:,:,427))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H4(50),wf4(:,9),G2tensor(121),ngZl,m3h4x1(:,68),heltab2x4(:,:,428))
  call Hloop_WQ_A(ntryL,G1H4(19),wf4(:,9),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(497))
  call Hloop_QV_A(ntryL,G2H8(31),wf8(:,42),G2H1(1),m3h8x1(:,7),heltab2x8(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(181),n2h1(498))
  call Hloop_QV_A(ntryL,G2H8(32),wf8(:,42),G2H1(1),m3h8x1(:,8),heltab2x8(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(182),n2h1(499))
  call Hloop_QV_A(ntryL,G2H8(33),wf8(:,42),G2H1(1),m3h8x1(:,9),heltab2x8(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(183),n2h1(500))
  call Hloop_AV_Q(ntryL,G2H8(34),wf8(:,42),G2H1(1),m3h8x1(:,10),heltab2x8(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(184),n2h1(501))
  call Hloop_AV_Q(ntryL,G2H8(35),wf8(:,42),G2H1(1),m3h8x1(:,11),heltab2x8(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(185),n2h1(502))
  call Hloop_AV_Q(ntryL,G2H8(36),wf8(:,42),G2H1(1),m3h8x1(:,12),heltab2x8(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(186),n2h1(503))
  call Hloop_QV_A(ntryL,G2H8(37),wf8(:,42),G2H1(1),m3h8x1(:,13),heltab2x8(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(187),n2h1(504))
  call Hloop_AV_Q(ntryL,G2H8(38),wf8(:,42),G2H1(1),m3h8x1(:,14),heltab2x8(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(188),n2h1(505))
  call Hloop_QV_A(ntryL,G2H8(40),wf8(:,42),G2H1(1),m3h8x1(:,15),heltab2x8(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(189),n2h1(506))
  call Hloop_AV_Q(ntryL,G2H8(42),wf8(:,42),G2H1(1),m3h8x1(:,16),heltab2x8(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(190),n2h1(507))
  call Hloop_QZ_A(ntryL,G2H8(44),wf8(:,43),G2H1(1),ngZl,m3h8x1(:,17),heltab2x8(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(191),n2h1(508))
  call Hloop_QZ_A(ntryL,G2H8(46),wf8(:,43),G2H1(1),ngZl,m3h8x1(:,18),heltab2x8(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(192),n2h1(509))
  call Hloop_QZ_A(ntryL,G2H8(47),wf8(:,43),G2H1(1),ngZl,m3h8x1(:,19),heltab2x8(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(193),n2h1(510))
  call Hloop_AZ_Q(ntryL,G2H8(48),wf8(:,43),G2H1(1),ngZl,m3h8x1(:,20),heltab2x8(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(194),n2h1(511))
  call Hloop_AZ_Q(ntryL,G2H8(49),wf8(:,43),G2H1(1),ngZl,m3h8x1(:,21),heltab2x8(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(195),n2h1(512))
  call Hloop_AZ_Q(ntryL,G2H8(50),wf8(:,43),G2H1(1),ngZl,m3h8x1(:,22),heltab2x8(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(196),n2h1(513))
  call Hloop_QZ_A(ntryL,G2H8(51),wf8(:,43),G2H1(1),ngZu,m3h8x1(:,23),heltab2x8(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(197),n2h1(514))
  call Hloop_QZ_A(ntryL,G2H8(52),wf8(:,43),G2H1(1),ngZu,m3h8x1(:,24),heltab2x8(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(198),n2h1(515))
  call Hloop_AZ_Q(ntryL,G2H8(53),wf8(:,43),G2H1(1),ngZu,m3h8x1(:,25),heltab2x8(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(199),n2h1(516))
  call Hloop_AZ_Q(ntryL,G2H8(54),wf8(:,43),G2H1(1),ngZu,m3h8x1(:,26),heltab2x8(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(200),n2h1(517))
  call Hloop_QZ_A(ntryL,G2H8(55),wf8(:,43),G2H1(1),ngZd,m3h8x1(:,27),heltab2x8(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(201),n2h1(518))
  call Hloop_QZ_A(ntryL,G2H8(56),wf8(:,43),G2H1(1),ngZd,m3h8x1(:,28),heltab2x8(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(202),n2h1(519))
  call Hloop_AZ_Q(ntryL,G2H8(39),wf8(:,43),G2H1(1),ngZd,m3h8x1(:,29),heltab2x8(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(203),n2h1(520))
  call Hloop_AZ_Q(ntryL,G2H8(41),wf8(:,43),G2H1(1),ngZd,m3h8x1(:,30),heltab2x8(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(204),n2h1(521))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H8(43),20,wf8(:,42),11,G3tensor(205),m3h8x1(:,31),heltab2x8(:,:,391))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H8(45),20,wf8(:,42),11,G3tensor(206),m3h8x1(:,32),heltab2x8(:,:,392))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H8(1),20,wf8(:,43),11,G3tensor(207),m3h8x1(:,33),heltab2x8(:,:,393))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H8(2),20,wf8(:,43),11,G3tensor(208),m3h8x1(:,34),heltab2x8(:,:,394))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(3),20,wf8(:,42),11,G3tensor(209),m3h8x1(:,35),heltab2x8(:,:,395))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(4),20,wf8(:,42),G3tensor(210),m3h8x1(:,36),heltab2x8(:,:,396))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(5),20,wf8(:,43),11,G3tensor(211),m3h8x1(:,37),heltab2x8(:,:,397))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(6),20,wf8(:,43),G3tensor(212),m3h8x1(:,38),heltab2x8(:,:,398))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(7),20,wf8(:,42),11,G3tensor(213),m3h8x1(:,39),heltab2x8(:,:,399))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H8(8),20,wf8(:,42),11,G3tensor(214),m3h8x1(:,40),heltab2x8(:,:,400))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(9),20,wf8(:,43),11,G3tensor(215),m3h8x1(:,41),heltab2x8(:,:,401))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H8(10),20,wf8(:,43),11,G3tensor(216),m3h8x1(:,42),heltab2x8(:,:,402))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(62),wf8(:,42),G1tensor(96),m3h8x1(:,43),heltab2x8(:,:,403))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(63),wf8(:,43),G1tensor(39),m3h8x1(:,44),heltab2x8(:,:,404))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H8(65),wf8(:,42),G1tensor(1),m3h8x1(:,45),heltab2x8(:,:,405))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H8(68),wf8(:,43),G1tensor(9),m3h8x1(:,46),heltab2x8(:,:,406))
  call Hloop_VQ_A(ntryL,G1H8(69),wf8(:,34),G1H1(1),m3h8x1(:,47),heltab2x8(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(522))
  call Hloop_ZQ_A(ntryL,G1H8(70),wf8(:,34),G1H1(1),ngZl,m3h8x1(:,48),heltab2x8(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(523))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(11),wf8(:,34),G2tensor(106),m3h8x1(:,49),heltab2x8(:,:,409))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(62),wf4(:,4),G2tensor(111),m3h4x1(:,70),heltab2x4(:,:,430))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H4(63),wf4(:,4),G2tensor(112),ngZl,m3h4x1(:,71),heltab2x4(:,:,431))
  call Hloop_WA_Q(ntryL,G1H4(36),wf4(:,4),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(524))
  call Hloop_QV_A(ntryL,G2H8(12),wf8(:,44),G2H1(1),m3h8x1(:,50),heltab2x8(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(217),n2h1(525))
  call Hloop_QV_A(ntryL,G2H8(13),wf8(:,44),G2H1(1),m3h8x1(:,51),heltab2x8(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(218),n2h1(526))
  call Hloop_QV_A(ntryL,G2H8(14),wf8(:,44),G2H1(1),m3h8x1(:,52),heltab2x8(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(219),n2h1(527))
  call Hloop_AV_Q(ntryL,G2H8(15),wf8(:,44),G2H1(1),m3h8x1(:,53),heltab2x8(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(220),n2h1(528))
  call Hloop_AV_Q(ntryL,G2H8(16),wf8(:,44),G2H1(1),m3h8x1(:,54),heltab2x8(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(221),n2h1(529))
  call Hloop_AV_Q(ntryL,G2H8(17),wf8(:,44),G2H1(1),m3h8x1(:,55),heltab2x8(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(222),n2h1(530))
  call Hloop_QV_A(ntryL,G2H8(18),wf8(:,44),G2H1(1),m3h8x1(:,56),heltab2x8(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(223),n2h1(531))
  call Hloop_AV_Q(ntryL,G2H8(19),wf8(:,44),G2H1(1),m3h8x1(:,57),heltab2x8(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(224),n2h1(532))
  call Hloop_QV_A(ntryL,G2H8(20),wf8(:,44),G2H1(1),m3h8x1(:,58),heltab2x8(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(225),n2h1(533))
  call Hloop_AV_Q(ntryL,G2H8(57),wf8(:,44),G2H1(1),m3h8x1(:,59),heltab2x8(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(226),n2h1(534))
  call Hloop_QZ_A(ntryL,G2H8(58),wf8(:,45),G2H1(1),ngZl,m3h8x1(:,60),heltab2x8(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(227),n2h1(535))
  call Hloop_QZ_A(ntryL,G2H8(59),wf8(:,45),G2H1(1),ngZl,m3h8x1(:,61),heltab2x8(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(228),n2h1(536))
  call Hloop_QZ_A(ntryL,G2H8(60),wf8(:,45),G2H1(1),ngZl,m3h8x1(:,62),heltab2x8(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(229),n2h1(537))
  call Hloop_AZ_Q(ntryL,G2H8(61),wf8(:,45),G2H1(1),ngZl,m3h8x1(:,63),heltab2x8(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(230),n2h1(538))
  call Hloop_AZ_Q(ntryL,G2H8(62),wf8(:,45),G2H1(1),ngZl,m3h8x1(:,64),heltab2x8(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(231),n2h1(539))
  call Hloop_AZ_Q(ntryL,G2H8(63),wf8(:,45),G2H1(1),ngZl,m3h8x1(:,65),heltab2x8(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(232),n2h1(540))
  call Hloop_QZ_A(ntryL,G2H8(64),wf8(:,45),G2H1(1),ngZu,m3h8x1(:,66),heltab2x8(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(233),n2h1(541))
  call Hloop_QZ_A(ntryL,G2H8(65),wf8(:,45),G2H1(1),ngZu,m3h8x1(:,67),heltab2x8(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(234),n2h1(542))
  call Hloop_AZ_Q(ntryL,G2H8(66),wf8(:,45),G2H1(1),ngZu,m3h8x1(:,68),heltab2x8(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(235),n2h1(543))
  call Hloop_AZ_Q(ntryL,G2H8(67),wf8(:,45),G2H1(1),ngZu,m3h8x1(:,69),heltab2x8(:,:,429))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(236),n2h1(544))
  call Hloop_QZ_A(ntryL,G2H8(68),wf8(:,45),G2H1(1),ngZd,m3h8x1(:,70),heltab2x8(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(237),n2h1(545))
  call Hloop_QZ_A(ntryL,G2H8(69),wf8(:,45),G2H1(1),ngZd,m3h8x1(:,71),heltab2x8(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(238),n2h1(546))
  call Hloop_AZ_Q(ntryL,G2H8(70),wf8(:,45),G2H1(1),ngZd,m3h8x1(:,72),heltab2x8(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(239),n2h1(547))
  call Hloop_AZ_Q(ntryL,G2H8(71),wf8(:,45),G2H1(1),ngZd,m3h8x1(:,73),heltab2x8(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(240),n2h1(548))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H8(72),20,wf8(:,44),11,G3tensor(241),m3h8x1(:,74),heltab2x8(:,:,434))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H8(73),20,wf8(:,44),11,G3tensor(242),m3h8x1(:,75),heltab2x8(:,:,435))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H8(74),20,wf8(:,45),11,G3tensor(243),m3h8x1(:,76),heltab2x8(:,:,436))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H8(75),20,wf8(:,45),11,G3tensor(244),m3h8x1(:,77),heltab2x8(:,:,437))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(76),20,wf8(:,44),11,G3tensor(245),m3h8x1(:,78),heltab2x8(:,:,438))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(77),20,wf8(:,44),G3tensor(246),m3h8x1(:,79),heltab2x8(:,:,439))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(78),20,wf8(:,45),11,G3tensor(247),m3h8x1(:,80),heltab2x8(:,:,440))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(79),20,wf8(:,45),G3tensor(248),m3h8x1(:,81),heltab2x8(:,:,441))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(80),20,wf8(:,44),11,G3tensor(249),m3h8x1(:,82),heltab2x8(:,:,442))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H8(81),20,wf8(:,44),11,G3tensor(250),m3h8x1(:,83),heltab2x8(:,:,443))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(82),20,wf8(:,45),11,G3tensor(251),m3h8x1(:,84),heltab2x8(:,:,444))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H8(83),20,wf8(:,45),11,G3tensor(252),m3h8x1(:,85),heltab2x8(:,:,445))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(110),wf8(:,44),G1tensor(13),m3h8x1(:,86),heltab2x8(:,:,446))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(112),wf8(:,45),G1tensor(22),m3h8x1(:,87),heltab2x8(:,:,447))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H8(114),wf8(:,44),G1tensor(19),m3h8x1(:,88),heltab2x8(:,:,448))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H8(117),wf8(:,45),G1tensor(35),m3h8x1(:,89),heltab2x8(:,:,449))
  call Hloop_VA_Q(ntryL,G1H8(118),wf8(:,36),G1H1(1),m3h8x1(:,90),heltab2x8(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(549))
  call Hloop_ZA_Q(ntryL,G1H8(119),wf8(:,36),G1H1(1),ngZl,m3h8x1(:,91),heltab2x8(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(550))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(84),wf8(:,36),G2tensor(124),m3h8x1(:,92),heltab2x8(:,:,452))
  call ol_merge_tensors(G2tensor(16),[G2tensor(18),G1tensor(97),G1tensor(67),G0tensor(25),G0tensor(20)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(22),G1tensor(50),G1tensor(18),G0tensor(35),G0tensor(30)])
  call ol_merge_tensors(G2tensor(354),[G2tensor(162),G2tensor(26),G1tensor(66),G1tensor(60),G0tensor(45),G0tensor(40)])
  call ol_merge_tensors(G2tensor(357),[G2tensor(168),G2tensor(30),G1tensor(102),G1tensor(80),G0tensor(55),G0tensor(50)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(198),G2tensor(171),G2tensor(54),G2tensor(34),G1tensor(70),G1tensor(43) &
    ,G1tensor(104),G1tensor(26),G0tensor(110),G0tensor(91),G0tensor(65),G0tensor(60)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(204),G2tensor(177),G2tensor(58),G2tensor(38),G1tensor(76),G1tensor(51),G1tensor(28) &
    ,G1tensor(4),G0tensor(115),G0tensor(101),G0tensor(75),G0tensor(70)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(210),G2tensor(183),G2tensor(62),G2tensor(42),G1tensor(89),G1tensor(25) &
    ,G1tensor(16),G1tensor(38),G0tensor(120),G0tensor(85),G0tensor(80),G0tensor(31)])
  call ol_merge_tensors(G2tensor(348),[G2tensor(189),G2tensor(46),G1tensor(40),G1tensor(29),G0tensor(95),G0tensor(90)])
  call ol_merge_tensors(G2tensor(351),[G2tensor(195),G2tensor(50),G1tensor(52),G1tensor(46),G0tensor(105),G0tensor(100)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(234),G2tensor(216),G2tensor(78),G2tensor(66),G1tensor(137),G1tensor(112) &
    ,G1tensor(105),G1tensor(8),G0tensor(155),G0tensor(130),G0tensor(125),G0tensor(41)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(240),G2tensor(222),G2tensor(82),G2tensor(70),G1tensor(142),G1tensor(122) &
    ,G1tensor(117),G1tensor(69),G0tensor(160),G0tensor(140),G0tensor(135),G0tensor(51)])
  call ol_merge_tensors(G2tensor(383),[G2tensor(246),G2tensor(228),G2tensor(86),G2tensor(74),G1tensor(147),G1tensor(132) &
    ,G1tensor(127),G1tensor(73),G0tensor(165),G0tensor(150),G0tensor(145),G0tensor(21)])
  call ol_merge_tensors(G2tensor(326),[G2tensor(249),G2tensor(247),G2tensor(1),G1tensor(212),G1tensor(150),G1tensor(103) &
    ,G0tensor(230),G0tensor(168),G0tensor(26)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(253),G2tensor(4),G1tensor(155),G1tensor(2),G0tensor(173),G0tensor(27)])
  call ol_merge_tensors(G3tensor(252),[G3tensor(251),G3tensor(250),G3tensor(249),G3tensor(248),G3tensor(247),G3tensor(246) &
    ,G3tensor(245),G3tensor(244),G3tensor(243),G3tensor(242),G3tensor(241),G3tensor(216),G3tensor(215),G3tensor(214),G3tensor(213) &
    ,G3tensor(212),G3tensor(211),G3tensor(210),G3tensor(209),G3tensor(208),G3tensor(207),G3tensor(206),G3tensor(205),G3tensor(48) &
    ,G3tensor(47),G3tensor(46),G3tensor(45),G3tensor(2),G3tensor(1),G2tensor(164),G2tensor(93),G2tensor(94),G2tensor(296) &
    ,G2tensor(448),G2tensor(445),G2tensor(346),G2tensor(343),G2tensor(160),G2tensor(157),G2tensor(154),G2tensor(152),G1tensor(35) &
    ,G1tensor(19),G1tensor(22),G1tensor(13),G1tensor(9),G1tensor(1),G1tensor(39),G1tensor(96),G1tensor(160),G1tensor(56) &
    ,G1tensor(6),G0tensor(178),G0tensor(38),G0tensor(28)])
  call ol_merge_tensors(G2tensor(329),[G2tensor(213),G2tensor(211),G2tensor(3),G1tensor(192),G1tensor(99),G1tensor(78) &
    ,G0tensor(210),G0tensor(123),G0tensor(36)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(256),G2tensor(2),G1tensor(180),G1tensor(54),G0tensor(198),G0tensor(37)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(237),G2tensor(235),G2tensor(5),G1tensor(317),G1tensor(140),G1tensor(68) &
    ,G0tensor(335),G0tensor(158),G0tensor(46)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(259),G2tensor(8),G1tensor(220),G1tensor(72),G0tensor(238),G0tensor(47)])
  call ol_merge_tensors(G3tensor(239),[G3tensor(237),G3tensor(235),G3tensor(233),G3tensor(230),G3tensor(227),G3tensor(220) &
    ,G3tensor(217),G3tensor(203),G3tensor(201),G3tensor(199),G3tensor(197),G3tensor(194),G3tensor(191),G3tensor(184),G3tensor(181) &
    ,G3tensor(6),G3tensor(3),G2tensor(358),G2tensor(355),G2tensor(352),G2tensor(349),G2tensor(193),G2tensor(166),G1tensor(225) &
    ,G1tensor(59),G1tensor(47),G1tensor(108),G1tensor(74),G0tensor(243),G0tensor(108),G0tensor(98),G0tensor(58),G0tensor(48)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(243),G2tensor(241),G2tensor(7),G1tensor(327),G1tensor(145),G1tensor(90) &
    ,G0tensor(345),G0tensor(163),G0tensor(56)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(262),G2tensor(6),G1tensor(230),G1tensor(92),G0tensor(248),G0tensor(57)])
  call ol_merge_tensors(G2tensor(286),[G2tensor(265),G2tensor(71),G2tensor(11),G1tensor(270),G1tensor(235),G1tensor(45) &
    ,G0tensor(288),G0tensor(253),G0tensor(66)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G3tensor(7),G3tensor(4),G2tensor(319),G2tensor(304),G2tensor(289),G2tensor(268) &
    ,G1tensor(275),G1tensor(240),G1tensor(124),G1tensor(114),G1tensor(7),G1tensor(32),G0tensor(293),G0tensor(258),G0tensor(142) &
    ,G0tensor(132),G0tensor(77),G0tensor(67)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(103),G2tensor(202),G2tensor(175),G2tensor(83),G2tensor(10),G1tensor(280) &
    ,G1tensor(245),G1tensor(3),G0tensor(298),G0tensor(263),G0tensor(68)])
  call ol_merge_tensors(G2tensor(292),[G2tensor(271),G2tensor(23),G2tensor(9),G1tensor(285),G1tensor(250),G1tensor(10) &
    ,G0tensor(303),G0tensor(268),G0tensor(76)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(133),G2tensor(208),G2tensor(181),G2tensor(27),G2tensor(14),G1tensor(290) &
    ,G1tensor(255),G1tensor(11),G0tensor(308),G0tensor(273),G0tensor(78)])
  call ol_merge_tensors(G2tensor(295),[G2tensor(274),G2tensor(31),G2tensor(13),G1tensor(86),G1tensor(185),G1tensor(165) &
    ,G1tensor(23),G0tensor(203),G0tensor(183),G0tensor(86)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G3tensor(34),G3tensor(33),G3tensor(24),G3tensor(23),G3tensor(22),G3tensor(21) &
    ,G3tensor(12),G3tensor(10),G3tensor(8),G3tensor(5),G2tensor(287),G2tensor(266),G2tensor(418),G2tensor(415),G2tensor(388) &
    ,G2tensor(385),G2tensor(340),G2tensor(337),G2tensor(334),G2tensor(331),G2tensor(328),G2tensor(313),G2tensor(298),G2tensor(277) &
    ,G1tensor(190),G1tensor(170),G1tensor(134),G1tensor(37),G0tensor(208),G0tensor(188),G0tensor(152),G0tensor(87)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(132),G2tensor(214),G2tensor(187),G2tensor(35),G2tensor(12),G1tensor(195) &
    ,G1tensor(175),G1tensor(27),G0tensor(213),G0tensor(193),G0tensor(88)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(201),G2tensor(199),G2tensor(15),G1tensor(277),G1tensor(100),G1tensor(71) &
    ,G0tensor(295),G0tensor(113),G0tensor(96)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(280),G2tensor(39),G1tensor(260),G1tensor(65),G0tensor(278),G0tensor(97)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(207),G2tensor(205),G2tensor(19),G1tensor(287),G1tensor(83),G1tensor(53) &
    ,G0tensor(305),G0tensor(118),G0tensor(106)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(283),G2tensor(59),G1tensor(265),G1tensor(57),G0tensor(283),G0tensor(107)])
  call ol_merge_tensors(G2tensor(316),[G2tensor(301),G2tensor(75),G2tensor(43),G1tensor(315),G1tensor(295),G1tensor(113) &
    ,G0tensor(333),G0tensor(313),G0tensor(131)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(131),G2tensor(238),G2tensor(220),G2tensor(79),G2tensor(47),G1tensor(320) &
    ,G1tensor(300),G1tensor(115),G0tensor(338),G0tensor(318),G0tensor(133)])
  call ol_merge_tensors(G2tensor(322),[G2tensor(307),G2tensor(87),G2tensor(51),G1tensor(325),G1tensor(305),G1tensor(123) &
    ,G0tensor(343),G0tensor(323),G0tensor(141)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(108),G2tensor(244),G2tensor(226),G2tensor(88),G2tensor(55),G1tensor(330) &
    ,G1tensor(310),G1tensor(125),G0tensor(348),G0tensor(328),G0tensor(143)])
  call ol_merge_tensors(G2tensor(325),[G2tensor(310),G2tensor(89),G2tensor(63),G1tensor(63),G1tensor(210),G1tensor(200) &
    ,G1tensor(133),G0tensor(228),G0tensor(218),G0tensor(151)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(104),G2tensor(250),G2tensor(232),G2tensor(90),G2tensor(67),G1tensor(215) &
    ,G1tensor(205),G1tensor(135),G0tensor(233),G0tensor(223),G0tensor(153)])
  call ol_merge_tensors(G3tensor(148),[G3tensor(147),G3tensor(146),G3tensor(145),G3tensor(144),G3tensor(143),G3tensor(142) &
    ,G3tensor(141),G3tensor(140),G3tensor(139),G3tensor(138),G3tensor(137),G2tensor(447),G2tensor(444),G2tensor(345),G2tensor(342) &
    ,G2tensor(159),G2tensor(156),G2tensor(102),G2tensor(100),G1tensor(157),G1tensor(44),G1tensor(85),G0tensor(175),G0tensor(33) &
    ,G0tensor(23)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G3tensor(15),G3tensor(13),G2tensor(397),G2tensor(391),G2tensor(367) &
    ,G2tensor(361),G1tensor(427),G1tensor(407),G0tensor(373),G0tensor(353)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G3tensor(16),G3tensor(14),G2tensor(400),G2tensor(394),G2tensor(370) &
    ,G2tensor(364),G1tensor(432),G1tensor(412),G0tensor(378),G0tensor(358)])
  call ol_merge_tensors(G3tensor(30),[G3tensor(29),G3tensor(18),G3tensor(17),G2tensor(406),G2tensor(403),G2tensor(376) &
    ,G2tensor(373),G1tensor(437),G1tensor(417),G0tensor(383),G0tensor(363)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(31),G3tensor(20),G3tensor(19),G2tensor(412),G2tensor(409),G2tensor(382) &
    ,G2tensor(379),G1tensor(442),G1tensor(422),G0tensor(388),G0tensor(368)])
  call ol_merge_tensors(G3tensor(231),[G3tensor(228),G3tensor(221),G3tensor(218),G3tensor(195),G3tensor(192),G3tensor(185) &
    ,G3tensor(182),G3tensor(39),G3tensor(37),G2tensor(427),G2tensor(421),G1tensor(447),G0tensor(393)])
  call ol_merge_tensors(G3tensor(232),[G3tensor(229),G3tensor(222),G3tensor(219),G3tensor(196),G3tensor(193),G3tensor(186) &
    ,G3tensor(183),G3tensor(40),G3tensor(38),G2tensor(430),G2tensor(424),G1tensor(452),G0tensor(398)])
  call ol_merge_tensors(G3tensor(236),[G3tensor(234),G3tensor(224),G3tensor(223),G3tensor(200),G3tensor(198),G3tensor(188) &
    ,G3tensor(187),G3tensor(42),G3tensor(41),G2tensor(436),G2tensor(433),G1tensor(457),G0tensor(403)])
  call ol_merge_tensors(G3tensor(240),[G3tensor(238),G3tensor(226),G3tensor(225),G3tensor(204),G3tensor(202),G3tensor(190) &
    ,G3tensor(189),G3tensor(44),G3tensor(43),G2tensor(442),G2tensor(439),G1tensor(462),G0tensor(408)])
  call ol_merge_tensors(G3tensor(135),[G3tensor(133),G3tensor(131),G3tensor(129),G3tensor(126),G3tensor(123),G3tensor(116) &
    ,G3tensor(113),G2tensor(196),G2tensor(192),G2tensor(190),G2tensor(169),G2tensor(165),G2tensor(163),G1tensor(222),G1tensor(88) &
    ,G1tensor(31),G1tensor(15),G1tensor(12),G0tensor(240),G0tensor(103),G0tensor(93),G0tensor(53),G0tensor(43)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(172),G1tensor(242),G1tensor(98),G0tensor(260),G0tensor(63)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(178),G1tensor(252),G1tensor(49),G0tensor(270),G0tensor(73)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(184),G1tensor(84),G1tensor(172),G1tensor(34),G0tensor(190),G0tensor(83)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(217),G1tensor(297),G1tensor(110),G0tensor(315),G0tensor(128)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(223),G1tensor(307),G1tensor(120),G0tensor(325),G0tensor(138)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(229),G1tensor(62),G1tensor(202),G1tensor(130),G0tensor(220),G0tensor(148)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(252),G1tensor(152),G1tensor(79),G0tensor(170),G0tensor(22)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(255),G1tensor(177),G1tensor(42),G0tensor(195),G0tensor(32)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(258),G1tensor(217),G1tensor(24),G0tensor(235),G0tensor(42)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(261),G1tensor(227),G1tensor(20),G0tensor(245),G0tensor(52)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(264),G1tensor(232),G1tensor(36),G0tensor(250),G0tensor(61)])
  call ol_merge_tensors(G3tensor(57),[G3tensor(49),G2tensor(303),G2tensor(267),G1tensor(237),G1tensor(119),G1tensor(109) &
    ,G1tensor(5),G1tensor(30),G0tensor(255),G0tensor(137),G0tensor(127),G0tensor(72),G0tensor(62)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(270),G1tensor(247),G1tensor(17),G0tensor(265),G0tensor(71)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(273),G1tensor(162),G1tensor(55),G0tensor(180),G0tensor(81)])
  call ol_merge_tensors(G3tensor(111),[G3tensor(109),G3tensor(107),G3tensor(105),G3tensor(59),G3tensor(51),G2tensor(417) &
    ,G2tensor(414),G2tensor(339),G2tensor(336),G2tensor(312),G2tensor(276),G1tensor(167),G1tensor(129),G1tensor(21),G0tensor(24) &
    ,G0tensor(19),G0tensor(185),G0tensor(147),G0tensor(82)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(279),G1tensor(257),G1tensor(33),G0tensor(275),G0tensor(92)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(282),G1tensor(262),G1tensor(94),G0tensor(280),G0tensor(102)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(285),G1tensor(267),G1tensor(258),G1tensor(75),G0tensor(285),G0tensor(276) &
    ,G0tensor(111)])
  call ol_merge_tensors(G3tensor(61),[G3tensor(53),G2tensor(318),G2tensor(288),G1tensor(272),G1tensor(223),G1tensor(144) &
    ,G1tensor(139),G1tensor(81),G1tensor(106),G0tensor(290),G0tensor(241),G0tensor(162),G0tensor(157),G0tensor(117) &
    ,G0tensor(112)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(291),G1tensor(282),G1tensor(263),G1tensor(77),G0tensor(300),G0tensor(281) &
    ,G0tensor(116)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(294),G1tensor(182),G1tensor(178),G1tensor(93),G0tensor(200),G0tensor(196) &
    ,G0tensor(121)])
  call ol_merge_tensors(G3tensor(87),[G3tensor(85),G3tensor(83),G3tensor(81),G3tensor(63),G3tensor(55),G2tensor(387),G2tensor(384) &
    ,G2tensor(333),G2tensor(330),G2tensor(327),G2tensor(297),G1tensor(187),G1tensor(158),G1tensor(149),G1tensor(95),G0tensor(34) &
    ,G0tensor(29),G0tensor(205),G0tensor(176),G0tensor(167),G0tensor(122)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(300),G1tensor(292),G1tensor(107),G0tensor(310),G0tensor(126)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(306),G1tensor(302),G1tensor(118),G0tensor(320),G0tensor(136)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(309),G1tensor(197),G1tensor(128),G0tensor(215),G0tensor(146)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(315),G1tensor(312),G1tensor(218),G1tensor(138),G0tensor(330),G0tensor(236) &
    ,G0tensor(156)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(321),G1tensor(322),G1tensor(228),G1tensor(143),G0tensor(340),G0tensor(246) &
    ,G0tensor(161)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(324),G1tensor(207),G1tensor(153),G1tensor(148),G0tensor(225),G0tensor(171) &
    ,G0tensor(166)])
  call ol_merge_tensors(G3tensor(69),[G3tensor(65),G2tensor(366),G2tensor(360),G1tensor(445),G1tensor(404),G0tensor(391) &
    ,G0tensor(350)])
  call ol_merge_tensors(G3tensor(71),[G3tensor(67),G2tensor(369),G2tensor(363),G1tensor(450),G1tensor(409),G0tensor(396) &
    ,G0tensor(355)])
  call ol_merge_tensors(G3tensor(75),[G3tensor(73),G2tensor(375),G2tensor(372),G1tensor(455),G1tensor(414),G0tensor(401) &
    ,G0tensor(360)])
  call ol_merge_tensors(G3tensor(79),[G3tensor(77),G2tensor(381),G2tensor(378),G1tensor(460),G1tensor(419),G0tensor(406) &
    ,G0tensor(365)])
  call ol_merge_tensors(G3tensor(93),[G3tensor(89),G2tensor(396),G2tensor(390),G1tensor(424),G0tensor(370)])
  call ol_merge_tensors(G3tensor(95),[G3tensor(91),G2tensor(399),G2tensor(393),G1tensor(429),G0tensor(375)])
  call ol_merge_tensors(G3tensor(99),[G3tensor(97),G2tensor(405),G2tensor(402),G1tensor(434),G0tensor(380)])
  call ol_merge_tensors(G3tensor(103),[G3tensor(101),G2tensor(411),G2tensor(408),G1tensor(439),G0tensor(385)])
  call ol_merge_tensors(G3tensor(127),[G3tensor(124),G3tensor(117),G3tensor(114),G2tensor(426),G2tensor(420),G1tensor(444) &
    ,G0tensor(390)])
  call ol_merge_tensors(G3tensor(128),[G3tensor(125),G3tensor(118),G3tensor(115),G2tensor(429),G2tensor(423),G1tensor(449) &
    ,G0tensor(395)])
  call ol_merge_tensors(G3tensor(132),[G3tensor(130),G3tensor(120),G3tensor(119),G2tensor(435),G2tensor(432),G1tensor(454) &
    ,G0tensor(400)])
  call ol_merge_tensors(G3tensor(136),[G3tensor(134),G3tensor(122),G3tensor(121),G2tensor(441),G2tensor(438),G1tensor(459) &
    ,G0tensor(405)])
  call ol_merge_tensors(G3tensor(112),[G3tensor(110),G3tensor(108),G3tensor(106),G3tensor(60),G3tensor(52),G1tensor(48) &
    ,G1tensor(14),G1tensor(204),G1tensor(179),G1tensor(174),G1tensor(169),G1tensor(159),G1tensor(154),G0tensor(222),G0tensor(197) &
    ,G0tensor(192),G0tensor(187),G0tensor(177),G0tensor(172)])
  call ol_merge_tensors(G3tensor(180),[G3tensor(179),G3tensor(160),G3tensor(159),G3tensor(154),G3tensor(150),G1tensor(91) &
    ,G1tensor(61),G1tensor(198),G1tensor(168),G1tensor(163),G0tensor(216),G0tensor(186),G0tensor(181)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(173),G1tensor(164),G0tensor(191),G0tensor(182)])
  call ol_merge_tensors(G3tensor(170),[G3tensor(169),G3tensor(158),G3tensor(157),G3tensor(156),G3tensor(152),G1tensor(208) &
    ,G1tensor(188),G1tensor(183),G0tensor(226),G0tensor(206),G0tensor(201)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(193),G1tensor(184),G0tensor(211),G0tensor(202)])
  call ol_merge_tensors(G3tensor(88),[G3tensor(86),G3tensor(84),G3tensor(82),G3tensor(64),G3tensor(56),G1tensor(214),G1tensor(194) &
    ,G1tensor(189),G0tensor(232),G0tensor(212),G0tensor(207)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(203),G1tensor(199),G0tensor(221),G0tensor(217)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(213),G1tensor(209),G0tensor(231),G0tensor(227)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(50),G1tensor(309),G1tensor(299),G1tensor(264),G1tensor(259),G1tensor(254) &
    ,G1tensor(244),G1tensor(239),G1tensor(229),G1tensor(224),G1tensor(219),G0tensor(327),G0tensor(317),G0tensor(282),G0tensor(277) &
    ,G0tensor(272),G0tensor(262),G0tensor(257),G0tensor(247),G0tensor(242),G0tensor(237)])
  call ol_merge_tensors(G3tensor(153),[G3tensor(149),G1tensor(303),G1tensor(293),G1tensor(248),G1tensor(238),G1tensor(233) &
    ,G0tensor(321),G0tensor(311),G0tensor(266),G0tensor(256),G0tensor(251)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(243),G1tensor(234),G0tensor(261),G0tensor(252)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(253),G1tensor(249),G0tensor(271),G0tensor(267)])
  call ol_merge_tensors(G3tensor(155),[G3tensor(151),G1tensor(323),G1tensor(313),G1tensor(283),G1tensor(273),G1tensor(268) &
    ,G0tensor(341),G0tensor(331),G0tensor(301),G0tensor(291),G0tensor(286)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(278),G1tensor(269),G0tensor(296),G0tensor(287)])
  call ol_merge_tensors(G3tensor(62),[G3tensor(54),G1tensor(329),G1tensor(319),G1tensor(289),G1tensor(279),G1tensor(274) &
    ,G0tensor(347),G0tensor(337),G0tensor(307),G0tensor(297),G0tensor(292)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(288),G1tensor(284),G0tensor(306),G0tensor(302)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(298),G1tensor(294),G0tensor(316),G0tensor(312)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(308),G1tensor(304),G0tensor(326),G0tensor(322)])
  call ol_merge_tensors(G2tensor(344),[G1tensor(318),G1tensor(314),G0tensor(336),G0tensor(332)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(328),G1tensor(324),G0tensor(346),G0tensor(342)])
  call ol_merge_tensors(G1tensor(382),[G1tensor(334)])
  call ol_merge_tensors(G1tensor(343),[G1tensor(335)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(338)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(339)])
  call ol_merge_tensors(G1tensor(381),[G1tensor(340)])
  call ol_merge_tensors(G1tensor(401),[G1tensor(344)])
  call ol_merge_tensors(G1tensor(385),[G1tensor(348)])
  call ol_merge_tensors(G1tensor(367),[G1tensor(351)])
  call ol_merge_tensors(G1tensor(389),[G1tensor(352)])
  call ol_merge_tensors(G1tensor(371),[G1tensor(355)])
  call ol_merge_tensors(G1tensor(393),[G1tensor(356)])
  call ol_merge_tensors(G1tensor(375),[G1tensor(359)])
  call ol_merge_tensors(G1tensor(397),[G1tensor(360)])
  call ol_merge_tensors(G1tensor(379),[G1tensor(363)])
  call ol_merge_tensors(G1tensor(386),[G1tensor(366)])
  call ol_merge_tensors(G1tensor(390),[G1tensor(370)])
  call ol_merge_tensors(G1tensor(394),[G1tensor(374)])
  call ol_merge_tensors(G1tensor(398),[G1tensor(378)])
  call ol_merge_tensors(G3tensor(163),[G3tensor(161),G1tensor(405),G0tensor(351)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(66),G1tensor(406),G0tensor(352)])
  call ol_merge_tensors(G3tensor(164),[G3tensor(162),G1tensor(410),G0tensor(356)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(68),G1tensor(411),G0tensor(357)])
  call ol_merge_tensors(G3tensor(166),[G3tensor(165),G1tensor(415),G0tensor(361)])
  call ol_merge_tensors(G3tensor(76),[G3tensor(74),G1tensor(416),G0tensor(362)])
  call ol_merge_tensors(G3tensor(168),[G3tensor(167),G1tensor(420),G0tensor(366)])
  call ol_merge_tensors(G3tensor(80),[G3tensor(78),G1tensor(421),G0tensor(367)])
  call ol_merge_tensors(G3tensor(173),[G3tensor(171),G1tensor(425),G0tensor(371)])
  call ol_merge_tensors(G3tensor(94),[G3tensor(90),G1tensor(446),G1tensor(426),G0tensor(392),G0tensor(372)])
  call ol_merge_tensors(G3tensor(174),[G3tensor(172),G1tensor(430),G0tensor(376)])
  call ol_merge_tensors(G3tensor(96),[G3tensor(92),G1tensor(451),G1tensor(431),G0tensor(397),G0tensor(377)])
  call ol_merge_tensors(G3tensor(176),[G3tensor(175),G1tensor(435),G0tensor(381)])
  call ol_merge_tensors(G3tensor(100),[G3tensor(98),G1tensor(456),G1tensor(436),G0tensor(402),G0tensor(382)])
  call ol_merge_tensors(G3tensor(178),[G3tensor(177),G1tensor(440),G0tensor(386)])
  call ol_merge_tensors(G3tensor(104),[G3tensor(102),G1tensor(461),G1tensor(441),G0tensor(407),G0tensor(387)])
  call TI_triangle_red(G2tensor(16),RedBasis(45),mass3set(:,1),G0tensor(39),G0tensor(44),G0tensor(49),G0tensor(54),M2L1R1,[nMW], &
    G0tensor(59))
  call TI_triangle_red(G2tensor(20),RedBasis(46),mass3set(:,1),G0tensor(64),G0tensor(69),G0tensor(74),G0tensor(79),M2L1R1,[nMW], &
    G0tensor(84))
  call TI_triangle_red(G2tensor(354),RedBasis(45),mass3set(:,2),G0tensor(89),G0tensor(94),G0tensor(99),G0tensor(104),M2L1R1)
  call TI_triangle_red(G2tensor(357),RedBasis(45),mass3set(:,3),G0tensor(109),G0tensor(114),G0tensor(119), &
    G0tensor(124),M2L1R1,[nMZ],G0tensor(129))
  call TI_triangle_red(G2tensor(45),RedBasis(39),mass3set(:,2),G0tensor(134),G0tensor(139),G0tensor(144),G0tensor(149),M2L1R1)
  call TI_triangle_red(G2tensor(49),RedBasis(39),mass3set(:,4),G0tensor(154),G0tensor(159),G0tensor(164), &
    G0tensor(169),M2L1R1,[nMZ],G0tensor(174))
  call TI_triangle_red(G2tensor(332),RedBasis(39),mass3set(:,5),G0tensor(179),G0tensor(184),G0tensor(189), &
    G0tensor(194),M2L1R1,[nMW],G0tensor(199))
  call TI_triangle_red(G2tensor(348),RedBasis(46),mass3set(:,2),G0tensor(204),G0tensor(209),G0tensor(214),G0tensor(219),M2L1R1)
  call TI_triangle_red(G2tensor(351),RedBasis(46),mass3set(:,3),G0tensor(224),G0tensor(229),G0tensor(234), &
    G0tensor(239),M2L1R1,[nMZ],G0tensor(244))
  call TI_triangle_red(G2tensor(28),RedBasis(37),mass3set(:,2),G0tensor(249),G0tensor(254),G0tensor(259),G0tensor(264),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(37),mass3set(:,4),G0tensor(269),G0tensor(274),G0tensor(279), &
    G0tensor(284),M2L1R1,[nMZ],G0tensor(289))
  call TI_triangle_red(G2tensor(383),RedBasis(37),mass3set(:,5),G0tensor(294),G0tensor(299),G0tensor(304), &
    G0tensor(309),M2L1R1,[nMW],G0tensor(314))
  call TI_triangle_red(G2tensor(326),RedBasis(4),mass3set(:,5),G0tensor(319),G0tensor(324),G0tensor(329), &
    G0tensor(334),M2L1R1,[nMW],G0tensor(339))
  call TI_triangle_red(G2tensor(25),RedBasis(2),mass3set(:,5),G0tensor(344),G0tensor(1),G0tensor(2),G0tensor(3),M2L1R1,[nMW], &
    G0tensor(4))
  call TI_triangle_red(G3tensor(252),RedBasis(1),mass3set(:,6),G0tensor(5),G0tensor(6),G0tensor(7),G0tensor(8),M2L1R1,[nMW], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(329),RedBasis(8),mass3set(:,5),G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),M2L1R1,[nMW], &
    G0tensor(14))
  call TI_triangle_red(G2tensor(24),RedBasis(7),mass3set(:,5),G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),M2L1R1,[nMW], &
    G0tensor(349))
  call TI_triangle_red(G2tensor(311),RedBasis(4),mass3set(:,2),G0tensor(354),G0tensor(359),G0tensor(364),G0tensor(369),M2L1R1)
  call TI_triangle_red(G2tensor(275),RedBasis(2),mass3set(:,2),G0tensor(374),G0tensor(379),G0tensor(384),G0tensor(389),M2L1R1)
  call TI_triangle_red(G3tensor(239),RedBasis(1),mass3set(:,2),G0tensor(394),G0tensor(399),G0tensor(404),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(96),RedBasis(4),mass3set(:,4),G0tensor(20),G0tensor(35),G0tensor(30),G0tensor(45),M2L1R1,[nMZ], &
    G0tensor(40))
  call TI_triangle_red(G2tensor(95),RedBasis(2),mass3set(:,4),G0tensor(55),G0tensor(50),G0tensor(110),G0tensor(91),M2L1R1,[nMZ], &
    G0tensor(65))
  call TI_triangle_red(G2tensor(286),RedBasis(12),mass3set(:,2),G0tensor(60),G0tensor(115),G0tensor(101),G0tensor(75),M2L1R1)
  call TI_triangle_red(G3tensor(11),RedBasis(11),mass3set(:,2),G0tensor(70),G0tensor(120),G0tensor(85),G0tensor(80),M2L1R1)
  call TI_triangle_red(G2tensor(119),RedBasis(10),mass3set(:,2),G0tensor(31),G0tensor(95),G0tensor(90),G0tensor(105),M2L1R1)
  call TI_triangle_red(G2tensor(292),RedBasis(12),mass3set(:,7),G0tensor(100),G0tensor(155),G0tensor(130), &
    G0tensor(125),M2L1R1,[nMZ],G0tensor(41))
  call TI_triangle_red(G2tensor(110),RedBasis(10),mass3set(:,4),G0tensor(160),G0tensor(140),G0tensor(135), &
    G0tensor(51),M2L1R1,[nMZ],G0tensor(165))
  call TI_triangle_red(G2tensor(295),RedBasis(12),mass3set(:,8),G0tensor(150),G0tensor(145),G0tensor(21), &
    G0tensor(230),M2L1R1,[nMW],G0tensor(168))
  call TI_triangle_red(G3tensor(36),RedBasis(11),mass3set(:,6),G0tensor(26),G0tensor(173),G0tensor(27),G0tensor(178),M2L1R1,[nMW], &
    G0tensor(38))
  call TI_triangle_red(G2tensor(106),RedBasis(10),mass3set(:,5),G0tensor(28),G0tensor(210),G0tensor(123), &
    G0tensor(36),M2L1R1,[nMW],G0tensor(198))
  call TI_triangle_red(G2tensor(97),RedBasis(8),mass3set(:,2),G0tensor(37),G0tensor(335),G0tensor(158),G0tensor(46),M2L1R1)
  call TI_triangle_red(G2tensor(413),RedBasis(7),mass3set(:,2),G0tensor(238),G0tensor(47),G0tensor(243),G0tensor(108),M2L1R1)
  call TI_triangle_red(G2tensor(338),RedBasis(8),mass3set(:,4),G0tensor(98),G0tensor(58),G0tensor(48),G0tensor(345),M2L1R1,[nMZ], &
    G0tensor(163))
  call TI_triangle_red(G2tensor(335),RedBasis(7),mass3set(:,4),G0tensor(56),G0tensor(248),G0tensor(57),G0tensor(288),M2L1R1,[nMZ], &
    G0tensor(253))
  call TI_triangle_red(G2tensor(316),RedBasis(19),mass3set(:,2),G0tensor(66),G0tensor(293),G0tensor(258),G0tensor(142),M2L1R1)
  call TI_triangle_red(G2tensor(117),RedBasis(18),mass3set(:,2),G0tensor(132),G0tensor(77),G0tensor(67),G0tensor(298),M2L1R1)
  call TI_triangle_red(G2tensor(322),RedBasis(19),mass3set(:,7),G0tensor(263),G0tensor(68),G0tensor(303), &
    G0tensor(268),M2L1R1,[nMZ],G0tensor(76))
  call TI_triangle_red(G2tensor(123),RedBasis(18),mass3set(:,4),G0tensor(308),G0tensor(273),G0tensor(78), &
    G0tensor(203),M2L1R1,[nMZ],G0tensor(183))
  call TI_triangle_red(G2tensor(325),RedBasis(19),mass3set(:,8),G0tensor(86),G0tensor(208),G0tensor(188), &
    G0tensor(152),M2L1R1,[nMW],G0tensor(87))
  call TI_triangle_red(G2tensor(124),RedBasis(18),mass3set(:,5),G0tensor(213),G0tensor(193),G0tensor(88), &
    G0tensor(295),M2L1R1,[nMW],G0tensor(113))
  call TI_triangle_red(G3tensor(148),RedBasis(35),mass3set(:,6),G0tensor(96),G0tensor(278),G0tensor(97), &
    G0tensor(305),M2L1R1,[nMW],G0tensor(118))
  call TI_triangle_red(G3tensor(27),RedBasis(11),mass3set(:,9),G0tensor(106),G0tensor(283),G0tensor(107), &
    G0tensor(333),M2L1R1,[nMM],G0tensor(313))
  call TI_triangle_red(G3tensor(28),RedBasis(11),mass3set(:,10),G0tensor(131),G0tensor(338),G0tensor(318), &
    G0tensor(133),M2L1R1,[nML],G0tensor(343))
  call TI_triangle_red(G3tensor(30),RedBasis(11),mass3set(:,11),G0tensor(323),G0tensor(141),G0tensor(348), &
    G0tensor(328),M2L1R1,[nMT],G0tensor(143))
  call TI_triangle_red(G3tensor(32),RedBasis(11),mass3set(:,12),G0tensor(228),G0tensor(218),G0tensor(151), &
    G0tensor(233),M2L1R1,[nMB],G0tensor(223))
  call TI_triangle_red(G3tensor(231),RedBasis(1),mass3set(:,9),G0tensor(153),G0tensor(175),G0tensor(33),G0tensor(23),M2L1R1,[nMM], &
    G0tensor(373))
  call TI_triangle_red(G3tensor(232),RedBasis(1),mass3set(:,10),G0tensor(353),G0tensor(378),G0tensor(358), &
    G0tensor(383),M2L1R1,[nML],G0tensor(363))
  call TI_triangle_red(G3tensor(236),RedBasis(1),mass3set(:,11),G0tensor(388),G0tensor(368),G0tensor(393), &
    G0tensor(398),M2L1R1,[nMT],G0tensor(403))
  call TI_triangle_red(G3tensor(240),RedBasis(1),mass3set(:,12),G0tensor(408),G0tensor(240),G0tensor(103), &
    G0tensor(93),M2L1R1,[nMB],G0tensor(53))
  call TI_triangle_red(G3tensor(135),RedBasis(35),mass3set(:,2),G0tensor(43),G0tensor(260),G0tensor(63),G0tensor(270),M2L1R1)
  call TI_triangle_red(G2tensor(174),RedBasis(40),mass3set(:,2),G0tensor(73),G0tensor(190),G0tensor(83),G0tensor(315),M2L1R1)
  call TI_triangle_red(G2tensor(180),RedBasis(40),mass3set(:,4),G0tensor(128),G0tensor(325),G0tensor(138), &
    G0tensor(220),M2L1R1,[nMZ],G0tensor(148))
  call TI_triangle_red(G2tensor(186),RedBasis(40),mass3set(:,5),G0tensor(170),G0tensor(22),G0tensor(195), &
    G0tensor(32),M2L1R1,[nMW],G0tensor(235))
  call TI_triangle_red(G2tensor(219),RedBasis(43),mass3set(:,2),G0tensor(42),G0tensor(245),G0tensor(52),G0tensor(250),M2L1R1)
  call TI_triangle_red(G2tensor(225),RedBasis(43),mass3set(:,4),G0tensor(61),G0tensor(255),G0tensor(137), &
    G0tensor(127),M2L1R1,[nMZ],G0tensor(72))
  call TI_triangle_red(G2tensor(231),RedBasis(43),mass3set(:,5),G0tensor(62),G0tensor(265),G0tensor(71), &
    G0tensor(180),M2L1R1,[nMW],G0tensor(81))
  call TI_triangle_red(G2tensor(17),RedBasis(36),mass3set(:,5),G0tensor(24),G0tensor(19),G0tensor(185),G0tensor(147),M2L1R1,[nMW], &
    G0tensor(82))
  call TI_triangle_red(G2tensor(21),RedBasis(38),mass3set(:,5),G0tensor(275),G0tensor(92),G0tensor(280), &
    G0tensor(102),M2L1R1,[nMW],G0tensor(285))
  call TI_triangle_red(G2tensor(29),RedBasis(36),mass3set(:,2),G0tensor(276),G0tensor(111),G0tensor(290),G0tensor(241),M2L1R1)
  call TI_triangle_red(G2tensor(33),RedBasis(36),mass3set(:,4),G0tensor(162),G0tensor(157),G0tensor(117), &
    G0tensor(112),M2L1R1,[nMZ],G0tensor(300))
  call TI_triangle_red(G2tensor(36),RedBasis(42),mass3set(:,2),G0tensor(281),G0tensor(116),G0tensor(200),G0tensor(196),M2L1R1)
  call TI_triangle_red(G3tensor(57),RedBasis(41),mass3set(:,2),G0tensor(121),G0tensor(34),G0tensor(29),G0tensor(205),M2L1R1)
  call TI_triangle_red(G2tensor(40),RedBasis(42),mass3set(:,7),G0tensor(176),G0tensor(167),G0tensor(122), &
    G0tensor(310),M2L1R1,[nMZ],G0tensor(126))
  call TI_triangle_red(G2tensor(41),RedBasis(42),mass3set(:,8),G0tensor(320),G0tensor(136),G0tensor(215), &
    G0tensor(146),M2L1R1,[nMW],G0tensor(330))
  call TI_triangle_red(G3tensor(111),RedBasis(41),mass3set(:,6),G0tensor(236),G0tensor(156),G0tensor(340), &
    G0tensor(246),M2L1R1,[nMW],G0tensor(161))
  call TI_triangle_red(G2tensor(48),RedBasis(38),mass3set(:,2),G0tensor(225),G0tensor(171),G0tensor(166),G0tensor(391),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(38),mass3set(:,4),G0tensor(350),G0tensor(396),G0tensor(355), &
    G0tensor(401),M2L1R1,[nMZ],G0tensor(360))
  call TI_triangle_red(G2tensor(56),RedBasis(9),mass3set(:,2),G0tensor(406),G0tensor(365),G0tensor(370),G0tensor(375),M2L1R1)
  call TI_triangle_red(G3tensor(61),RedBasis(5),mass3set(:,2),G0tensor(380),G0tensor(385),G0tensor(390),G0tensor(395),M2L1R1)
  call TI_triangle_red(G2tensor(64),RedBasis(9),mass3set(:,7),G0tensor(400),G0tensor(405),G0tensor(222), &
    G0tensor(197),M2L1R1,[nMZ],G0tensor(192))
  call TI_triangle_red(G2tensor(68),RedBasis(9),mass3set(:,8),G0tensor(187),G0tensor(177),G0tensor(172), &
    G0tensor(216),M2L1R1,[nMW],G0tensor(186))
  call TI_triangle_red(G3tensor(87),RedBasis(5),mass3set(:,6),G0tensor(181),G0tensor(191),G0tensor(182), &
    G0tensor(226),M2L1R1,[nMW],G0tensor(206))
  call TI_triangle_red(G2tensor(72),RedBasis(44),mass3set(:,2),G0tensor(201),G0tensor(211),G0tensor(202),G0tensor(232),M2L1R1)
  call TI_triangle_red(G2tensor(73),RedBasis(44),mass3set(:,7),G0tensor(212),G0tensor(207),G0tensor(221), &
    G0tensor(217),M2L1R1,[nMZ],G0tensor(231))
  call TI_triangle_red(G2tensor(80),RedBasis(44),mass3set(:,8),G0tensor(227),G0tensor(327),G0tensor(317), &
    G0tensor(282),M2L1R1,[nMW],G0tensor(277))
  call TI_triangle_red(G2tensor(443),RedBasis(6),mass3set(:,2),G0tensor(272),G0tensor(262),G0tensor(257),G0tensor(247),M2L1R1)
  call TI_triangle_red(G2tensor(341),RedBasis(6),mass3set(:,7),G0tensor(242),G0tensor(237),G0tensor(321), &
    G0tensor(311),M2L1R1,[nMZ],G0tensor(266))
  call TI_triangle_red(G2tensor(155),RedBasis(6),mass3set(:,8),G0tensor(256),G0tensor(251),G0tensor(261), &
    G0tensor(252),M2L1R1,[nMW],G0tensor(271))
  call TI_triangle_red(G3tensor(69),RedBasis(5),mass3set(:,9),G0tensor(267),G0tensor(341),G0tensor(331), &
    G0tensor(301),M2L1R1,[nMM],G0tensor(291))
  call TI_triangle_red(G3tensor(71),RedBasis(5),mass3set(:,10),G0tensor(286),G0tensor(296),G0tensor(287), &
    G0tensor(347),M2L1R1,[nML],G0tensor(337))
  call TI_triangle_red(G3tensor(75),RedBasis(5),mass3set(:,11),G0tensor(307),G0tensor(297),G0tensor(292), &
    G0tensor(306),M2L1R1,[nMT],G0tensor(302))
  call TI_triangle_red(G3tensor(79),RedBasis(5),mass3set(:,12),G0tensor(316),G0tensor(312),G0tensor(326), &
    G0tensor(322),M2L1R1,[nMB],G0tensor(336))
  call TI_triangle_red(G3tensor(93),RedBasis(41),mass3set(:,9),G0tensor(332),G0tensor(346),G0tensor(342), &
    G0tensor(351),M2L1R1,[nMM],G0tensor(352))
  call TI_triangle_red(G3tensor(95),RedBasis(41),mass3set(:,10),G0tensor(356),G0tensor(357),G0tensor(361), &
    G0tensor(362),M2L1R1,[nML],G0tensor(366))
  call TI_triangle_red(G3tensor(99),RedBasis(41),mass3set(:,11),G0tensor(367),G0tensor(371),G0tensor(392), &
    G0tensor(372),M2L1R1,[nMT],G0tensor(376))
  call TI_triangle_red(G3tensor(103),RedBasis(41),mass3set(:,12),G0tensor(397),G0tensor(377),G0tensor(381), &
    G0tensor(402),M2L1R1,[nMB],G0tensor(382))
  call TI_triangle_red(G3tensor(127),RedBasis(35),mass3set(:,9),G0tensor(386),G0tensor(407),G0tensor(387), &
    G0tensor(409),M2L1R1,[nMM],G0tensor(410))
  call TI_triangle_red(G3tensor(128),RedBasis(35),mass3set(:,10),G0tensor(411),G0tensor(412),G0tensor(413), &
    G0tensor(414),M2L1R1,[nML],G0tensor(415))
  call TI_triangle_red(G3tensor(132),RedBasis(35),mass3set(:,11),G0tensor(416),G0tensor(417),G0tensor(418), &
    G0tensor(419),M2L1R1,[nMT],G0tensor(420))
  call TI_triangle_red(G3tensor(136),RedBasis(35),mass3set(:,12),G0tensor(421),G0tensor(422),G0tensor(423), &
    G0tensor(424),M2L1R1,[nMB],G0tensor(425))
  call TI_triangle_red(G3tensor(112),RedBasis(3),mass3set(:,6),G0tensor(426),G0tensor(427),G0tensor(428), &
    G0tensor(429),M2L1R1,[nMW],G0tensor(430))
  call TI_triangle_red(G3tensor(180),RedBasis(14),mass3set(:,6),G0tensor(431),G0tensor(432),G0tensor(433), &
    G0tensor(434),M2L1R1,[nMW],G0tensor(435))
  call TI_triangle_red(G2tensor(44),RedBasis(13),mass3set(:,8),G0tensor(436),G0tensor(437),G0tensor(438), &
    G0tensor(439),M2L1R1,[nMW],G0tensor(440))
  call TI_triangle_red(G3tensor(170),RedBasis(17),mass3set(:,6),G0tensor(441),G0tensor(442),G0tensor(443), &
    G0tensor(444),M2L1R1,[nMW],G0tensor(445))
  call TI_triangle_red(G2tensor(69),RedBasis(16),mass3set(:,8),G0tensor(446),G0tensor(447),G0tensor(448), &
    G0tensor(449),M2L1R1,[nMW],G0tensor(450))
  call TI_triangle_red(G3tensor(88),RedBasis(15),mass3set(:,6),G0tensor(451),G0tensor(452),G0tensor(453), &
    G0tensor(454),M2L1R1,[nMW],G0tensor(455))
  call TI_triangle_red(G2tensor(84),RedBasis(20),mass3set(:,8),G0tensor(456),G0tensor(457),G0tensor(458), &
    G0tensor(459),M2L1R1,[nMW],G0tensor(460))
  call TI_triangle_red(G2tensor(98),RedBasis(21),mass3set(:,8),G0tensor(461),G0tensor(462),G0tensor(463), &
    G0tensor(464),M2L1R1,[nMW],G0tensor(465))
  call TI_triangle_red(G3tensor(58),RedBasis(3),mass3set(:,2),G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),M2L1R1)
  call TI_triangle_red(G3tensor(153),RedBasis(14),mass3set(:,2),G0tensor(470),G0tensor(471),G0tensor(472),G0tensor(473),M2L1R1)
  call TI_triangle_red(G2tensor(37),RedBasis(13),mass3set(:,2),G0tensor(474),G0tensor(475),G0tensor(476),G0tensor(477),M2L1R1)
  call TI_triangle_red(G2tensor(61),RedBasis(13),mass3set(:,7),G0tensor(478),G0tensor(479),G0tensor(480), &
    G0tensor(481),M2L1R1,[nMZ],G0tensor(482))
  call TI_triangle_red(G3tensor(155),RedBasis(17),mass3set(:,2),G0tensor(483),G0tensor(484),G0tensor(485),G0tensor(486),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(16),mass3set(:,2),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490),M2L1R1)
  call TI_triangle_red(G3tensor(62),RedBasis(15),mass3set(:,2),G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),M2L1R1)
  call TI_triangle_red(G2tensor(65),RedBasis(16),mass3set(:,7),G0tensor(495),G0tensor(496),G0tensor(497), &
    G0tensor(498),M2L1R1,[nMZ],G0tensor(499))
  call TI_triangle_red(G2tensor(85),RedBasis(20),mass3set(:,2),G0tensor(500),G0tensor(501),G0tensor(502),G0tensor(503),M2L1R1)
  call TI_triangle_red(G2tensor(76),RedBasis(20),mass3set(:,7),G0tensor(504),G0tensor(505),G0tensor(506), &
    G0tensor(507),M2L1R1,[nMZ],G0tensor(508))
  call TI_triangle_red(G2tensor(344),RedBasis(21),mass3set(:,2),G0tensor(509),G0tensor(510),G0tensor(511),G0tensor(512),M2L1R1)
  call TI_triangle_red(G2tensor(158),RedBasis(21),mass3set(:,7),G0tensor(513),G0tensor(514),G0tensor(515), &
    G0tensor(516),M2L1R1,[nMZ],G0tensor(517))
  call TI_triangle_red(G3tensor(163),RedBasis(17),mass3set(:,9),G0tensor(518),G0tensor(519),G0tensor(520), &
    G0tensor(521),M2L1R1,[nMM],G0tensor(522))
  call TI_triangle_red(G3tensor(70),RedBasis(15),mass3set(:,9),G0tensor(523),G0tensor(524),G0tensor(525), &
    G0tensor(526),M2L1R1,[nMM],G0tensor(527))
  call TI_triangle_red(G3tensor(164),RedBasis(17),mass3set(:,10),G0tensor(528),G0tensor(529),G0tensor(530), &
    G0tensor(531),M2L1R1,[nML],G0tensor(532))
  call TI_triangle_red(G3tensor(72),RedBasis(15),mass3set(:,10),G0tensor(533),G0tensor(534),G0tensor(535), &
    G0tensor(536),M2L1R1,[nML],G0tensor(537))
  call TI_triangle_red(G3tensor(166),RedBasis(17),mass3set(:,11),G0tensor(538),G0tensor(539),G0tensor(540), &
    G0tensor(541),M2L1R1,[nMT],G0tensor(542))
  call TI_triangle_red(G3tensor(76),RedBasis(15),mass3set(:,11),G0tensor(543),G0tensor(544),G0tensor(545), &
    G0tensor(546),M2L1R1,[nMT],G0tensor(547))
  call TI_triangle_red(G3tensor(168),RedBasis(17),mass3set(:,12),G0tensor(548),G0tensor(549),G0tensor(550), &
    G0tensor(551),M2L1R1,[nMB],G0tensor(552))
  call TI_triangle_red(G3tensor(80),RedBasis(15),mass3set(:,12),G0tensor(553),G0tensor(554),G0tensor(555), &
    G0tensor(556),M2L1R1,[nMB],G0tensor(557))
  call TI_triangle_red(G3tensor(173),RedBasis(14),mass3set(:,9),G0tensor(558),G0tensor(559),G0tensor(560), &
    G0tensor(561),M2L1R1,[nMM],G0tensor(562))
  call TI_triangle_red(G3tensor(94),RedBasis(3),mass3set(:,9),G0tensor(563),G0tensor(564),G0tensor(565), &
    G0tensor(566),M2L1R1,[nMM],G0tensor(567))
  call TI_triangle_red(G3tensor(174),RedBasis(14),mass3set(:,10),G0tensor(568),G0tensor(569),G0tensor(570), &
    G0tensor(571),M2L1R1,[nML],G0tensor(572))
  call TI_triangle_red(G3tensor(96),RedBasis(3),mass3set(:,10),G0tensor(573),G0tensor(574),G0tensor(575), &
    G0tensor(576),M2L1R1,[nML],G0tensor(577))
  call TI_triangle_red(G3tensor(176),RedBasis(14),mass3set(:,11),G0tensor(578),G0tensor(579),G0tensor(580), &
    G0tensor(581),M2L1R1,[nMT],G0tensor(582))
  call TI_triangle_red(G3tensor(100),RedBasis(3),mass3set(:,11),G0tensor(583),G0tensor(584),G0tensor(585), &
    G0tensor(586),M2L1R1,[nMT],G0tensor(587))
  call TI_triangle_red(G3tensor(178),RedBasis(14),mass3set(:,12),G0tensor(588),G0tensor(589),G0tensor(590), &
    G0tensor(591),M2L1R1,[nMB],G0tensor(592))
  call TI_triangle_red(G3tensor(104),RedBasis(3),mass3set(:,12),G0tensor(593),G0tensor(594),G0tensor(595), &
    G0tensor(596),M2L1R1,[nMB],G0tensor(597))
  call TI_triangle_red(G2tensor(105),RedBasis(47),mass3set(:,2),G0tensor(598),G0tensor(599),G0tensor(600),G0tensor(601),M2L1R1)
  call TI_triangle_red(G2tensor(121),RedBasis(47),mass3set(:,3),G0tensor(602),G0tensor(603),G0tensor(604), &
    G0tensor(605),M2L1R1,[nMZ],G0tensor(606))
  call TI_triangle_red(G2tensor(120),RedBasis(47),mass3set(:,1),G0tensor(607),G0tensor(608),G0tensor(609), &
    G0tensor(610),M2L1R1,[nMW],G0tensor(611))
  call TI_triangle_red(G2tensor(111),RedBasis(48),mass3set(:,2),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615),M2L1R1)
  call TI_triangle_red(G2tensor(112),RedBasis(48),mass3set(:,3),G0tensor(616),G0tensor(617),G0tensor(618), &
    G0tensor(619),M2L1R1,[nMZ],G0tensor(620))
  call TI_triangle_red(G2tensor(115),RedBasis(48),mass3set(:,1),G0tensor(621),G0tensor(622),G0tensor(623), &
    G0tensor(624),M2L1R1,[nMW],G0tensor(625))
  call ol_merge_tensors(T0sum(97),[G0tensor(39)])
  call ol_merge_tensors(T0sum(98),[G0tensor(64)])
  call ol_merge_tensors(T0sum(99),[G0tensor(89)])
  call ol_merge_tensors(T0sum(100),[G0tensor(109)])
  call ol_merge_tensors(T0sum(101),[G0tensor(134)])
  call ol_merge_tensors(T0sum(102),[G0tensor(154)])
  call ol_merge_tensors(T0sum(103),[G0tensor(179)])
  call ol_merge_tensors(T0sum(104),[G0tensor(204)])
  call ol_merge_tensors(T0sum(105),[G0tensor(224)])
  call ol_merge_tensors(T0sum(106),[G0tensor(249)])
  call ol_merge_tensors(T0sum(107),[G0tensor(269)])
  call ol_merge_tensors(T0sum(108),[G0tensor(294)])
  call ol_merge_tensors(T0sum(109),[G0tensor(319)])
  call ol_merge_tensors(T0sum(110),[G0tensor(344)])
  call ol_merge_tensors(T0sum(111),[G0tensor(5)])
  call ol_merge_tensors(T0sum(112),[G0tensor(10)])
  call ol_merge_tensors(T0sum(113),[G0tensor(15)])
  call ol_merge_tensors(T0sum(114),[G0tensor(354)])
  call ol_merge_tensors(T0sum(115),[G0tensor(374)])
  call ol_merge_tensors(T0sum(116),[G0tensor(394)])
  call ol_merge_tensors(T0sum(117),[G0tensor(20)])
  call ol_merge_tensors(T0sum(118),[G0tensor(55)])
  call ol_merge_tensors(T0sum(119),[G0tensor(60)])
  call ol_merge_tensors(T0sum(120),[G0tensor(70)])
  call ol_merge_tensors(T0sum(121),[G0tensor(31)])
  call ol_merge_tensors(T0sum(122),[G0tensor(100)])
  call ol_merge_tensors(T0sum(123),[G0tensor(160)])
  call ol_merge_tensors(T0sum(124),[G0tensor(150)])
  call ol_merge_tensors(T0sum(125),[G0tensor(26)])
  call ol_merge_tensors(T0sum(126),[G0tensor(28)])
  call ol_merge_tensors(T0sum(127),[G0tensor(37)])
  call ol_merge_tensors(T0sum(128),[G0tensor(238)])
  call ol_merge_tensors(T0sum(129),[G0tensor(98)])
  call ol_merge_tensors(T0sum(130),[G0tensor(56)])
  call ol_merge_tensors(T0sum(131),[G0tensor(66)])
  call ol_merge_tensors(T0sum(132),[G0tensor(132)])
  call ol_merge_tensors(T0sum(133),[G0tensor(263)])
  call ol_merge_tensors(T0sum(134),[G0tensor(308)])
  call ol_merge_tensors(T0sum(135),[G0tensor(86)])
  call ol_merge_tensors(T0sum(136),[G0tensor(213)])
  call ol_merge_tensors(T0sum(137),[G0tensor(96)])
  call ol_merge_tensors(T0sum(138),[G0tensor(106)])
  call ol_merge_tensors(T0sum(139),[G0tensor(131)])
  call ol_merge_tensors(T0sum(140),[G0tensor(323)])
  call ol_merge_tensors(T0sum(141),[G0tensor(228)])
  call ol_merge_tensors(T0sum(142),[G0tensor(153)])
  call ol_merge_tensors(T0sum(143),[G0tensor(353)])
  call ol_merge_tensors(T0sum(144),[G0tensor(388)])
  call ol_merge_tensors(T0sum(145),[G0tensor(408)])
  call ol_merge_tensors(T0sum(146),[G0tensor(43)])
  call ol_merge_tensors(T0sum(147),[G0tensor(73)])
  call ol_merge_tensors(T0sum(148),[G0tensor(128)])
  call ol_merge_tensors(T0sum(149),[G0tensor(170)])
  call ol_merge_tensors(T0sum(150),[G0tensor(42)])
  call ol_merge_tensors(T0sum(151),[G0tensor(61)])
  call ol_merge_tensors(T0sum(152),[G0tensor(62)])
  call ol_merge_tensors(T0sum(153),[G0tensor(24)])
  call ol_merge_tensors(T0sum(154),[G0tensor(275)])
  call ol_merge_tensors(T0sum(155),[G0tensor(276)])
  call ol_merge_tensors(T0sum(156),[G0tensor(162)])
  call ol_merge_tensors(T0sum(157),[G0tensor(281)])
  call ol_merge_tensors(T0sum(158),[G0tensor(121)])
  call ol_merge_tensors(T0sum(159),[G0tensor(176)])
  call ol_merge_tensors(T0sum(160),[G0tensor(320)])
  call ol_merge_tensors(T0sum(161),[G0tensor(236)])
  call ol_merge_tensors(T0sum(162),[G0tensor(225)])
  call ol_merge_tensors(T0sum(163),[G0tensor(350)])
  call ol_merge_tensors(T0sum(164),[G0tensor(406)])
  call ol_merge_tensors(T0sum(165),[G0tensor(380)])
  call ol_merge_tensors(T0sum(166),[G0tensor(400)])
  call ol_merge_tensors(T0sum(167),[G0tensor(187)])
  call ol_merge_tensors(T0sum(168),[G0tensor(181)])
  call ol_merge_tensors(T0sum(169),[G0tensor(201)])
  call ol_merge_tensors(T0sum(170),[G0tensor(212)])
  call ol_merge_tensors(T0sum(171),[G0tensor(227)])
  call ol_merge_tensors(T0sum(172),[G0tensor(272)])
  call ol_merge_tensors(T0sum(173),[G0tensor(242)])
  call ol_merge_tensors(T0sum(174),[G0tensor(256)])
  call ol_merge_tensors(T0sum(175),[G0tensor(267)])
  call ol_merge_tensors(T0sum(176),[G0tensor(286)])
  call ol_merge_tensors(T0sum(177),[G0tensor(307)])
  call ol_merge_tensors(T0sum(178),[G0tensor(316)])
  call ol_merge_tensors(T0sum(179),[G0tensor(332)])
  call ol_merge_tensors(T0sum(180),[G0tensor(356)])
  call ol_merge_tensors(T0sum(181),[G0tensor(367)])
  call ol_merge_tensors(T0sum(182),[G0tensor(397)])
  call ol_merge_tensors(T0sum(183),[G0tensor(386)])
  call ol_merge_tensors(T0sum(184),[G0tensor(411)])
  call ol_merge_tensors(T0sum(185),[G0tensor(416)])
  call ol_merge_tensors(T0sum(186),[G0tensor(421)])
  call ol_merge_tensors(T0sum(187),[G0tensor(426)])
  call ol_merge_tensors(T0sum(188),[G0tensor(431)])
  call ol_merge_tensors(T0sum(189),[G0tensor(436)])
  call ol_merge_tensors(T0sum(190),[G0tensor(441)])
  call ol_merge_tensors(T0sum(191),[G0tensor(446)])
  call ol_merge_tensors(T0sum(192),[G0tensor(451)])
  call ol_merge_tensors(T0sum(193),[G0tensor(456)])
  call ol_merge_tensors(T0sum(194),[G0tensor(461)])
  call ol_merge_tensors(T0sum(195),[G0tensor(466)])
  call ol_merge_tensors(T0sum(196),[G0tensor(470)])
  call ol_merge_tensors(T0sum(197),[G0tensor(474)])
  call ol_merge_tensors(T0sum(198),[G0tensor(478)])
  call ol_merge_tensors(T0sum(199),[G0tensor(483)])
  call ol_merge_tensors(T0sum(200),[G0tensor(487)])
  call ol_merge_tensors(T0sum(201),[G0tensor(491)])
  call ol_merge_tensors(T0sum(202),[G0tensor(495)])
  call ol_merge_tensors(T0sum(203),[G0tensor(500)])
  call ol_merge_tensors(T0sum(204),[G0tensor(504)])
  call ol_merge_tensors(T0sum(205),[G0tensor(509)])
  call ol_merge_tensors(T0sum(206),[G0tensor(513)])
  call ol_merge_tensors(T1sum(19),[G1tensor(332)])
  call ol_merge_tensors(T1sum(20),[G1tensor(333)])
  call ol_merge_tensors(T1sum(21),[G1tensor(382)])
  call ol_merge_tensors(T1sum(22),[G1tensor(343)])
  call ol_merge_tensors(T1sum(23),[G1tensor(336)])
  call ol_merge_tensors(T1sum(24),[G1tensor(337)])
  call ol_merge_tensors(T1sum(25),[G1tensor(402)])
  call ol_merge_tensors(T1sum(26),[G1tensor(347)])
  call ol_merge_tensors(T1sum(27),[G1tensor(381)])
  call ol_merge_tensors(T1sum(28),[G1tensor(341)])
  call ol_merge_tensors(T1sum(29),[G1tensor(342)])
  call ol_merge_tensors(T1sum(30),[G1tensor(401)])
  call ol_merge_tensors(T1sum(31),[G1tensor(345)])
  call ol_merge_tensors(T1sum(32),[G1tensor(346)])
  call ol_merge_tensors(T1sum(33),[G1tensor(385)])
  call ol_merge_tensors(T1sum(34),[G1tensor(349)])
  call ol_merge_tensors(T1sum(35),[G1tensor(350)])
  call ol_merge_tensors(T1sum(36),[G1tensor(367)])
  call ol_merge_tensors(T1sum(37),[G1tensor(389)])
  call ol_merge_tensors(T1sum(38),[G1tensor(353)])
  call ol_merge_tensors(T1sum(39),[G1tensor(354)])
  call ol_merge_tensors(T1sum(40),[G1tensor(371)])
  call ol_merge_tensors(T1sum(41),[G1tensor(393)])
  call ol_merge_tensors(T1sum(42),[G1tensor(357)])
  call ol_merge_tensors(T1sum(43),[G1tensor(358)])
  call ol_merge_tensors(T1sum(44),[G1tensor(375)])
  call ol_merge_tensors(T1sum(45),[G1tensor(397)])
  call ol_merge_tensors(T1sum(46),[G1tensor(361)])
  call ol_merge_tensors(T1sum(47),[G1tensor(362)])
  call ol_merge_tensors(T1sum(48),[G1tensor(379)])
  call ol_merge_tensors(T1sum(49),[G1tensor(364)])
  call ol_merge_tensors(T1sum(50),[G1tensor(365)])
  call ol_merge_tensors(T1sum(51),[G1tensor(386)])
  call ol_merge_tensors(T1sum(52),[G1tensor(368)])
  call ol_merge_tensors(T1sum(53),[G1tensor(369)])
  call ol_merge_tensors(T1sum(54),[G1tensor(390)])
  call ol_merge_tensors(T1sum(55),[G1tensor(372)])
  call ol_merge_tensors(T1sum(56),[G1tensor(373)])
  call ol_merge_tensors(T1sum(57),[G1tensor(394)])
  call ol_merge_tensors(T1sum(58),[G1tensor(376)])
  call ol_merge_tensors(T1sum(59),[G1tensor(377)])
  call ol_merge_tensors(T1sum(60),[G1tensor(398)])
  call ol_merge_tensors(T1sum(61),[G1tensor(380)])
  call ol_merge_tensors(T1sum(62),[G1tensor(383)])
  call ol_merge_tensors(T1sum(63),[G1tensor(384)])
  call ol_merge_tensors(T1sum(64),[G1tensor(387)])
  call ol_merge_tensors(T1sum(65),[G1tensor(388)])
  call ol_merge_tensors(T1sum(66),[G1tensor(391)])
  call ol_merge_tensors(T1sum(67),[G1tensor(392)])
  call ol_merge_tensors(T1sum(68),[G1tensor(395)])
  call ol_merge_tensors(T1sum(69),[G1tensor(396)])
  call ol_merge_tensors(T1sum(70),[G1tensor(399)])
  call ol_merge_tensors(T1sum(71),[G1tensor(400)])
  call ol_merge_tensors(T1sum(72),[G1tensor(403)])
  call ol_merge_tensors(T0sum(207),[G0tensor(518)])
  call ol_merge_tensors(T0sum(208),[G0tensor(523)])
  call ol_merge_tensors(T0sum(209),[G0tensor(528)])
  call ol_merge_tensors(T0sum(210),[G0tensor(533)])
  call ol_merge_tensors(T0sum(211),[G0tensor(538)])
  call ol_merge_tensors(T0sum(212),[G0tensor(543)])
  call ol_merge_tensors(T0sum(213),[G0tensor(548)])
  call ol_merge_tensors(T0sum(214),[G0tensor(553)])
  call ol_merge_tensors(T0sum(215),[G0tensor(558)])
  call ol_merge_tensors(T0sum(216),[G0tensor(563)])
  call ol_merge_tensors(T0sum(217),[G0tensor(568)])
  call ol_merge_tensors(T0sum(218),[G0tensor(573)])
  call ol_merge_tensors(T0sum(219),[G0tensor(578)])
  call ol_merge_tensors(T0sum(220),[G0tensor(583)])
  call ol_merge_tensors(T0sum(221),[G0tensor(588)])
  call ol_merge_tensors(T0sum(222),[G0tensor(593)])
  call ol_merge_tensors(T0sum(223),[G0tensor(598)])
  call ol_merge_tensors(T0sum(224),[G0tensor(602)])
  call ol_merge_tensors(T0sum(225),[G0tensor(607)])
  call ol_merge_tensors(T0sum(226),[G0tensor(612)])
  call ol_merge_tensors(T0sum(227),[G0tensor(616)])
  call ol_merge_tensors(T0sum(228),[G0tensor(621)])
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[19,12],[nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(25),m4h2x4x4(:,17),heltab3x32(:,:,57))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[19,12],[nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(11),m4h2x4x4(:,18),heltab3x32(:,:,58))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[19,12],[nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,13),G0H4(24),m4h2x4x4(:,19),heltab3x32(:,:,59))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[19,12],[nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(4),m4h2x4x4(:,20),heltab3x32(:,:,60))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[20,11],[nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(6),m4h2x2x8(:,41),heltab3x32(:,:,61))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[20,11],[nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(7),m4h2x2x8(:,42),heltab3x32(:,:,62))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[20,11],[nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(8),m4h2x2x8(:,43),heltab3x32(:,:,63))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[20,11],[nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(9),m4h2x2x8(:,44),heltab3x32(:,:,64))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[24,7],[nMW,nMW],4,1,wf4(:,13))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(10),m4h2x2x8(:,45),heltab3x32(:,:,65))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[24,7],[nMW,nMW],4,1,wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(11),m4h2x2x8(:,46),heltab3x32(:,:,66))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[24,7],[nMW,nMW],4,1,wf4(:,13))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(13),m4h2x2x8(:,47),heltab3x32(:,:,67))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[24,7],[nMW,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,48),heltab3x32(:,:,68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[23,8],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,38),G0H2(28),m4h2x8x2(:,1),heltab3x32(:,:,69))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,39),G0H2(26),m4h2x8x2(:,2),heltab3x32(:,:,70))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[23,8],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,38),G0H2(20),m4h2x8x2(:,3),heltab3x32(:,:,71))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,39),G0H2(18),m4h2x8x2(:,4),heltab3x32(:,:,72))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[16,15],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,709),heltab2x32(:,:,899))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[16,15],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,710),heltab2x32(:,:,900))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[16,15],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,711),heltab2x32(:,:,901))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[16,15],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,712),heltab2x32(:,:,902))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[24,7],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(17),m4h2x2x8(:,49),heltab3x32(:,:,73))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[24,7],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(19),m4h2x2x8(:,50),heltab3x32(:,:,74))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[24,7],[nMW,nMW],3,1,wf8(:,38))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(26),m4h2x2x8(:,51),heltab3x32(:,:,75))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[24,7],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(28),m4h2x2x8(:,52),heltab3x32(:,:,76))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,40),G0H2(27),m4h2x8x2(:,5),heltab3x32(:,:,77))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[23,8],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,41),G0H2(25),m4h2x8x2(:,6),heltab3x32(:,:,78))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,40),G0H2(19),m4h2x8x2(:,7),heltab3x32(:,:,79))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[23,8],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,41),G0H2(17),m4h2x8x2(:,8),heltab3x32(:,:,80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[16,15],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,713),heltab2x32(:,:,903))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[16,15],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,714),heltab2x32(:,:,904))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[16,15],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,715),heltab2x32(:,:,905))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[16,15],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,716),heltab2x32(:,:,906))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[24,7],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(30),m4h2x2x8(:,53),heltab3x32(:,:,81))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[24,7],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(32),m4h2x2x8(:,54),heltab3x32(:,:,82))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[24,7],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(33),m4h2x2x8(:,55),heltab3x32(:,:,83))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[24,7],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(34),m4h2x2x8(:,56),heltab3x32(:,:,84))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[27,4],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,42),G0H2(23),m4h2x8x2(:,9),heltab3x32(:,:,85))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[27,4],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,43),G0H2(21),m4h2x8x2(:,10),heltab3x32(:,:,86))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[27,4],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,42),G0H2(15),m4h2x8x2(:,11),heltab3x32(:,:,87))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[27,4],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,43),G0H2(13),m4h2x8x2(:,12),heltab3x32(:,:,88))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[27,4],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,44),G0H2(24),m4h2x8x2(:,13),heltab3x32(:,:,89))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[27,4],[nMW,nMW],3,1,wf8(:,45))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf8(:,45),G0H2(22),m4h2x8x2(:,14),heltab3x32(:,:,90))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[27,4],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,44),G0H2(16),m4h2x8x2(:,15),heltab3x32(:,:,91))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[27,4],[nMW,nMW],3,1,wf8(:,45))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf8(:,45),G0H2(14),m4h2x8x2(:,16),heltab3x32(:,:,92))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[27,4],[nMW,nMW],3,1,wf8(:,46))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,46),G0H2(32),m4h2x8x2(:,17),heltab3x32(:,:,93))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[27,4],[nMW,nMW],3,1,wf8(:,47))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,47),G0H2(31),m4h2x8x2(:,18),heltab3x32(:,:,94))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[27,4],[nMW,nMW],3,1,wf8(:,46))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,46),G0H2(29),m4h2x8x2(:,19),heltab3x32(:,:,95))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[27,4],[nMW,nMW],3,1,wf8(:,47))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,47),G0H2(30),m4h2x8x2(:,20),heltab3x32(:,:,96))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[27,4],[nMW,nMW],3,1,wf8(:,48))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,48),G0H2(1),m4h2x8x2(:,21),heltab3x32(:,:,97))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[27,4],[nMW,nMW],3,1,wf8(:,49))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,49),G0H2(3),m4h2x8x2(:,22),heltab3x32(:,:,98))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[27,4],[nMW,nMW],3,1,wf8(:,48))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,48),G0H2(6),m4h2x8x2(:,23),heltab3x32(:,:,99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[27,4],[nMW,nMW],3,1,wf8(:,49))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,49),G0H2(5),m4h2x8x2(:,24),heltab3x32(:,:,100))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[16,15],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,717),heltab2x32(:,:,907))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[16,15],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,718),heltab2x32(:,:,908))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[16,15],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,719),heltab2x32(:,:,909))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[16,15],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,720),heltab2x32(:,:,910))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[20,11],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(37),m4h2x2x8(:,57),heltab3x32(:,:,101))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[20,11],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(38),m4h2x2x8(:,58),heltab3x32(:,:,102))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[20,11],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(39),m4h2x2x8(:,59),heltab3x32(:,:,103))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[20,11],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(40),m4h2x2x8(:,60),heltab3x32(:,:,104))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[16,15],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(76),m3h2x16(:,721),heltab2x32(:,:,911))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[16,15],[nMW,nMW],3,1,wf8(:,45))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,722),heltab2x32(:,:,912))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[16,15],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,723),heltab2x32(:,:,913))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[16,15],[nMW,nMW],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(73),m3h2x16(:,724),heltab2x32(:,:,914))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[20,11],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(41),m4h2x2x8(:,61),heltab3x32(:,:,105))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[20,11],[nMW,nMW],3,1,wf8(:,45))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(42),m4h2x2x8(:,62),heltab3x32(:,:,106))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[20,11],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(20),m4h2x2x8(:,63),heltab3x32(:,:,107))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[20,11],[nMW,nMW],3,1,wf8(:,45))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,64),heltab3x32(:,:,108))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[23,8],[nMW,nMW],3,1,wf8(:,46))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,46),G0H2(8),m4h2x8x2(:,25),heltab3x32(:,:,109))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[23,8],[nMW,nMW],3,1,wf8(:,47))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,47),G0H2(7),m4h2x8x2(:,26),heltab3x32(:,:,110))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[23,8],[nMW,nMW],3,1,wf8(:,46))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,46),G0H2(9),m4h2x8x2(:,27),heltab3x32(:,:,111))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[23,8],[nMW,nMW],3,1,wf8(:,47))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,47),G0H2(11),m4h2x8x2(:,28),heltab3x32(:,:,112))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[23,8],[nMW,nMW],3,1,wf8(:,48))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,48),G0H2(2),m4h2x8x2(:,29),heltab3x32(:,:,113))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[23,8],[nMW,nMW],3,1,wf8(:,49))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,49),G0H2(4),m4h2x8x2(:,30),heltab3x32(:,:,114))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[23,8],[nMW,nMW],3,1,wf8(:,48))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,48),G0H2(10),m4h2x8x2(:,31),heltab3x32(:,:,115))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[23,8],[nMW,nMW],3,1,wf8(:,49))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,49),G0H2(12),m4h2x8x2(:,32),heltab3x32(:,:,116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[19,12],[nMW,nMW],3,1,wf8(:,46))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(97),m3h8x4(:,161),heltab2x32(:,:,915))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[19,12],[nMW,nMW],3,1,wf8(:,47))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(98),m3h8x4(:,162),heltab2x32(:,:,916))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[19,12],[nMW,nMW],3,1,wf8(:,46))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,46),19,G1H4(107),m3h8x4(:,163),heltab2x32(:,:,917))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[19,12],[nMW,nMW],3,1,wf8(:,47))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,47),19,G1H4(111),m3h8x4(:,164),heltab2x32(:,:,918))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[19,12],[nMW,nMW],3,1,wf8(:,48))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(115),m3h8x4(:,165),heltab2x32(:,:,919))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[19,12],[nMW,nMW],3,1,wf8(:,49))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(18),m3h8x4(:,166),heltab2x32(:,:,920))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[19,12],[nMW,nMW],3,1,wf8(:,48))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,48),19,G1H4(30),m3h8x4(:,167),heltab2x32(:,:,921))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[19,12],[nMW,nMW],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,49),19,G1H4(24),m3h8x4(:,168),heltab2x32(:,:,922))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[21,10],[0,0],2,2,wf8(:,22),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,22),G0H4(1),m3h8x4(:,169),heltab2x32(:,:,923))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(40),n2h4(213))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[21,10],[0,nMZ],2,2,wf8(:,22),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,22),G0H4(3),ngZl,m3h8x4(:,170),heltab2x32(:,:,924))
  call Hloop_Q_A(ntryL,G0H4(3),21,0,G1H4(46),n2h4(214))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[21,10],[0,nMW],2,2,wf8(:,22),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,22),G0H4(10),m3h8x4(:,171),heltab2x32(:,:,925))
  call Hloop_Q_A(ntryL,G0H4(10),21,0,G1H4(51),n2h4(215))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[26,5],[0,0],2,2,wf8(:,21),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,21),G0H4(6),m3h8x4(:,172),heltab2x32(:,:,926))
  call Hloop_A_Q(ntryL,G0H4(6),26,0,G1H4(61),n2h4(216))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[26,5],[0,nMZ],2,2,wf8(:,21),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,21),G0H4(7),ngZl,m3h8x4(:,173),heltab2x32(:,:,927))
  call Hloop_A_Q(ntryL,G0H4(7),26,0,G1H4(86),n2h4(217))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[26,5],[0,nMW],2,2,wf8(:,21),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,21),G0H4(8),m3h8x4(:,174),heltab2x32(:,:,928))
  call Hloop_A_Q(ntryL,G0H4(8),26,0,G1H4(132),n2h4(218))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[18,13],[0,0],2,2,wf4(:,6),wf8(:,25))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,31),heltab2x32(:,:,929))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,25))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(1),ngZl,m3h4x8(:,32),heltab2x32(:,:,930))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,25))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,33),heltab2x32(:,:,931))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[26,5],[0,0],2,2,wf8(:,24),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,24),G0H4(2),m3h8x4(:,175),heltab2x32(:,:,932))
  call Hloop_A_Q(ntryL,G0H4(2),26,0,G1H4(126),n2h4(219))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[26,5],[0,nMZ],2,2,wf8(:,24),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,24),G0H4(5),ngZl,m3h8x4(:,176),heltab2x32(:,:,933))
  call Hloop_A_Q(ntryL,G0H4(5),26,0,G1H4(121),n2h4(220))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[26,5],[0,nMW],2,2,wf8(:,24),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,24),G0H4(15),m3h8x4(:,177),heltab2x32(:,:,934))
  call Hloop_A_Q(ntryL,G0H4(15),26,0,G1H4(106),n2h4(221))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[25,6],[0,0],2,2,wf8(:,28),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(16),m3h8x4(:,178),heltab2x32(:,:,935))
  call Hloop_Q_A(ntryL,G0H4(16),25,0,G1H4(43),n2h4(222))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[25,6],[0,nMZ],2,2,wf8(:,28),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(14),ngZl,m3h8x4(:,179),heltab2x32(:,:,936))
  call Hloop_Q_A(ntryL,G0H4(14),25,0,G1H4(5),n2h4(223))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1053),h0tab(:,1053),[25,6],[0,nMW],2,2,wf8(:,28),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,28),G0H4(19),m3h8x4(:,180),heltab2x32(:,:,937))
  call Hloop_Q_A(ntryL,G0H4(19),25,0,G1H4(75),n2h4(224))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1054),h0tab(:,1054),[22,9],[0,0],2,2,wf8(:,27),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(18),m3h8x4(:,181),heltab2x32(:,:,938))
  call Hloop_A_Q(ntryL,G0H4(18),22,0,G1H4(59),n2h4(225))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1055),h0tab(:,1055),[22,9],[0,nMZ],2,2,wf8(:,27),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(26),ngZl,m3h8x4(:,182),heltab2x32(:,:,939))
  call Hloop_A_Q(ntryL,G0H4(26),22,0,G1H4(49),n2h4(226))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1056),h0tab(:,1056),[22,9],[0,nMW],2,2,wf8(:,27),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,27),G0H4(27),m3h8x4(:,183),heltab2x32(:,:,940))
  call Hloop_A_Q(ntryL,G0H4(27),22,0,G1H4(84),n2h4(227))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1057),h0tab(:,1057),[25,6],[0,0],2,2,wf8(:,31),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,31),G0H4(45),m3h8x4(:,184),heltab2x32(:,:,941))
  call Hloop_Q_A(ntryL,G0H4(45),25,0,G1H4(52),n2h4(228))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1058),h0tab(:,1058),[25,6],[0,nMZ],2,2,wf8(:,31),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,31),G0H4(17),ngZl,m3h8x4(:,185),heltab2x32(:,:,942))
  call Hloop_Q_A(ntryL,G0H4(17),25,0,G1H4(154),n2h4(229))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1059),h0tab(:,1059),[25,6],[0,nMW],2,2,wf8(:,31),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,31),G0H4(13),m3h8x4(:,186),heltab2x32(:,:,943))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(32),n2h4(230))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1060),h0tab(:,1060),[17,14],[0,0],2,2,wf4(:,12),wf8(:,30))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,34),heltab2x32(:,:,944))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1061),h0tab(:,1061),[17,14],[nMZ,0],2,2,wf4(:,12),wf8(:,30))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(22),ngZl,m3h4x8(:,35),heltab2x32(:,:,945))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1062),h0tab(:,1062),[17,14],[nMW,0],2,2,wf4(:,12),wf8(:,30))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(24),m3h4x8(:,36),heltab2x32(:,:,946))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1063),h0tab(:,1063),[18,13],[0,0],2,2,wf4(:,6),wf8(:,34))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(35),m3h4x8(:,37),heltab2x32(:,:,947))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1064),h0tab(:,1064),[18,13],[nMZ,0],2,2,wf4(:,6),wf8(:,34))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(36),ngZl,m3h4x8(:,38),heltab2x32(:,:,948))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1065),h0tab(:,1065),[18,13],[nMW,0],2,2,wf4(:,6),wf8(:,34))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(12),m3h4x8(:,39),heltab2x32(:,:,949))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1066),h0tab(:,1066),[22,9],[0,0],2,2,wf8(:,33),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(46),m3h8x4(:,187),heltab2x32(:,:,950))
  call Hloop_A_Q(ntryL,G0H4(46),22,0,G1H4(31),n2h4(231))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1067),h0tab(:,1067),[22,9],[0,nMZ],2,2,wf8(:,33),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(28),ngZl,m3h8x4(:,188),heltab2x32(:,:,951))
  call Hloop_A_Q(ntryL,G0H4(28),22,0,G1H4(74),n2h4(232))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1068),h0tab(:,1068),[22,9],[0,nMW],2,2,wf8(:,33),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,33),G0H4(20),m3h8x4(:,189),heltab2x32(:,:,952))
  call Hloop_A_Q(ntryL,G0H4(20),22,0,G1H4(70),n2h4(233))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1069),h0tab(:,1069),[21,10],[0,0],2,2,wf8(:,37),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(49),m3h8x4(:,190),heltab2x32(:,:,953))
  call Hloop_Q_A(ntryL,G0H4(49),21,0,G1H4(128),n2h4(234))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1070),h0tab(:,1070),[21,10],[0,nMZ],2,2,wf8(:,37),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(31),ngZl,m3h8x4(:,191),heltab2x32(:,:,954))
  call Hloop_Q_A(ntryL,G0H4(31),21,0,G1H4(123),n2h4(235))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1071),h0tab(:,1071),[21,10],[0,nMW],2,2,wf8(:,37),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,37),G0H4(29),m3h8x4(:,192),heltab2x32(:,:,955))
  call Hloop_Q_A(ntryL,G0H4(29),21,0,G1H4(112),n2h4(236))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1072),h0tab(:,1072),[17,14],[0,0],2,2,wf4(:,12),wf8(:,36))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,40),heltab2x32(:,:,956))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1073),h0tab(:,1073),[17,14],[nMZ,0],2,2,wf4(:,12),wf8(:,36))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(3),ngZl,m3h4x8(:,41),heltab2x32(:,:,957))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1074),h0tab(:,1074),[17,14],[nMW,0],2,2,wf4(:,12),wf8(:,36))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(18),m3h4x8(:,42),heltab2x32(:,:,958))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(115),G1H4(98),G1H4(97),G0H4(11),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(30),G1H4(111),G1H4(107),G0H4(4),G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(4),[G0H2(2),G0H2(7),G0H2(8),G0H2(25),G0H2(27),G0H2(26) &
    ,G0H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(12),[G0H2(10),G0H2(11),G0H2(9),G0H2(17),G0H2(19),G0H2(18) &
    ,G0H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(3),[G0H2(1),G0H2(31),G0H2(32),G0H2(22),G0H2(24),G0H2(21) &
    ,G0H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(5),[G0H2(6),G0H2(30),G0H2(29),G0H2(14),G0H2(16),G0H2(13) &
    ,G0H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(84)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(18),ex4(:),ex3(:),G1tensor(41),m4h2x2x1(:,7),heltab3x4(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(24),ex4(:),ex3(:),G1tensor(58),m4h2x2x1(:,8),heltab3x4(:,:,8))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H8(6),ex4(:),wf4(:,13),G0tensor(39),m4h2x4x1(:,5),heltab3x8(:,:,5))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H8(7),ex4(:),wf4(:,14),G0tensor(64),m4h2x4x1(:,6),heltab3x8(:,:,6))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H8(8),ex4(:),wf4(:,13),G0tensor(89),m4h2x4x1(:,7),heltab3x8(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H8(9),ex4(:),wf4(:,14),G0tensor(109),m4h2x4x1(:,8),heltab3x8(:,:,8))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H8(10),ex3(:),wf4(:,13),G0tensor(134),m4h2x4x1(:,9),heltab3x8(:,:,9))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H8(11),ex3(:),wf4(:,14),G0tensor(154),m4h2x4x1(:,10),heltab3x8(:,:,10))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H8(13),ex3(:),wf4(:,13),G0tensor(179),m4h2x4x1(:,11),heltab3x8(:,:,11))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H8(2),ex3(:),wf4(:,14),G0tensor(204),m4h2x4x1(:,12),heltab3x8(:,:,12))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(4),23,ex4(:),8,G1tensor(64),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(12),23,ex4(:),8,G1tensor(82),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(12),ex4(:),wf8(:,38),G1tensor(87),m4h2x8x1(:,1),heltab3x16(:,:,13))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(4),ex4(:),wf8(:,39),G1tensor(101),m4h2x8x1(:,2),heltab3x16(:,:,14))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(16),ex4(:),wf8(:,38),G1tensor(111),m4h2x8x1(:,3),heltab3x16(:,:,15))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(7),ex4(:),wf8(:,39),G1tensor(116),m4h2x8x1(:,4),heltab3x16(:,:,16))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(17),24,wf8(:,38),7,G1tensor(121),m3h8x1(:,93),heltab2x8(:,:,453))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(19),24,wf8(:,39),7,G1tensor(126),m3h8x1(:,94),heltab2x8(:,:,454))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(26),24,wf8(:,38),7,G1tensor(131),m3h8x1(:,95),heltab2x8(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(28),24,wf8(:,39),7,G1tensor(136),m3h8x1(:,96),heltab2x8(:,:,456))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(44),ex4(:),wf8(:,40),G1tensor(141),m4h2x8x1(:,5),heltab3x16(:,:,17))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(45),ex4(:),wf8(:,41),G1tensor(146),m4h2x8x1(:,6),heltab3x16(:,:,18))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(48),ex4(:),wf8(:,40),G1tensor(151),m4h2x8x1(:,7),heltab3x16(:,:,19))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(49),ex4(:),wf8(:,41),G1tensor(156),m4h2x8x1(:,8),heltab3x16(:,:,20))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(30),24,wf8(:,40),7,G1tensor(161),m3h8x1(:,97),heltab2x8(:,:,457))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(32),24,wf8(:,41),7,G1tensor(166),m3h8x1(:,98),heltab2x8(:,:,458))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(33),24,wf8(:,40),7,G1tensor(171),m3h8x1(:,99),heltab2x8(:,:,459))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(34),24,wf8(:,41),7,G1tensor(176),m3h8x1(:,100),heltab2x8(:,:,460))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(3),27,ex3(:),4,G1tensor(181),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(5),27,ex3(:),4,G1tensor(186),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(56),ex3(:),wf8(:,42),G1tensor(191),m4h2x8x1(:,9),heltab3x16(:,:,21))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(58),ex3(:),wf8(:,43),G1tensor(196),m4h2x8x1(:,10),heltab3x16(:,:,22))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(60),ex3(:),wf8(:,42),G1tensor(201),m4h2x8x1(:,11),heltab3x16(:,:,23))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(62),ex3(:),wf8(:,43),G1tensor(206),m4h2x8x1(:,12),heltab3x16(:,:,24))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(37),20,wf8(:,42),11,G1tensor(211),m3h8x1(:,101),heltab2x8(:,:,461))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(38),20,wf8(:,43),11,G1tensor(216),m3h8x1(:,102),heltab2x8(:,:,462))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(39),20,wf8(:,42),11,G1tensor(221),m3h8x1(:,103),heltab2x8(:,:,463))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(40),20,wf8(:,43),11,G1tensor(226),m3h8x1(:,104),heltab2x8(:,:,464))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(76),ex3(:),wf8(:,44),G1tensor(231),m4h2x8x1(:,13),heltab3x16(:,:,25))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(70),ex3(:),wf8(:,45),G1tensor(236),m4h2x8x1(:,14),heltab3x16(:,:,26))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(80),ex3(:),wf8(:,44),G1tensor(241),m4h2x8x1(:,15),heltab3x16(:,:,27))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(73),ex3(:),wf8(:,45),G1tensor(246),m4h2x8x1(:,16),heltab3x16(:,:,28))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(41),20,wf8(:,44),11,G1tensor(251),m3h8x1(:,105),heltab2x8(:,:,465))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H8(42),20,wf8(:,45),11,G1tensor(256),m3h8x1(:,106),heltab2x8(:,:,466))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(20),20,wf8(:,44),11,G1tensor(261),m3h8x1(:,107),heltab2x8(:,:,467))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H8(15),20,wf8(:,45),11,G1tensor(266),m3h8x1(:,108),heltab2x8(:,:,468))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(128),wf4(:,4),G1tensor(271),m3h4x1(:,73),heltab2x4(:,:,433))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(123),wf4(:,4),G1tensor(276),ngZl,m3h4x1(:,74),heltab2x4(:,:,434))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(112),wf4(:,4),G1tensor(281),m3h4x1(:,75),heltab2x4(:,:,435))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(126),wf4(:,3),G1tensor(286),m3h4x1(:,76),heltab2x4(:,:,436))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(121),wf4(:,3),G1tensor(291),ngZl,m3h4x1(:,77),heltab2x4(:,:,437))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(106),wf4(:,3),G1tensor(296),m3h4x1(:,78),heltab2x4(:,:,438))
  call Hloop_VQ_A(ntryL,G0H8(16),wf8(:,25),G0H1(1),m3h8x1(:,109),heltab2x8(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(301),n2h1(551))
  call Hloop_ZQ_A(ntryL,G0H8(1),wf8(:,25),G0H1(1),ngZl,m3h8x1(:,110),heltab2x8(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(306),n2h1(552))
  call Hloop_WQ_A(ntryL,G0H8(14),wf8(:,25),G0H1(1),m3h8x1(:,111),heltab2x8(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(311),n2h1(553))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(52),wf4(:,10),G1tensor(316),m3h4x1(:,79),heltab2x4(:,:,439))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(154),wf4(:,10),G1tensor(321),ngZl,m3h4x1(:,80),heltab2x4(:,:,440))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(32),wf4(:,10),G1tensor(326),m3h4x1(:,81),heltab2x4(:,:,441))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(31),wf4(:,9),G1tensor(331),m3h4x1(:,82),heltab2x4(:,:,442))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(74),wf4(:,9),G1tensor(408),ngZl,m3h4x1(:,83),heltab2x4(:,:,443))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(70),wf4(:,9),G1tensor(413),m3h4x1(:,84),heltab2x4(:,:,444))
  call Hloop_VA_Q(ntryL,G0H8(21),wf8(:,30),G0H1(1),m3h8x1(:,112),heltab2x8(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(418),n2h1(554))
  call Hloop_ZA_Q(ntryL,G0H8(22),wf8(:,30),G0H1(1),ngZl,m3h8x1(:,113),heltab2x8(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(423),n2h1(555))
  call Hloop_WA_Q(ntryL,G0H8(24),wf8(:,30),G0H1(1),m3h8x1(:,114),heltab2x8(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(428),n2h1(556))
  call Hloop_VQ_A(ntryL,G0H8(35),wf8(:,34),G0H1(1),m3h8x1(:,115),heltab2x8(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(433),n2h1(557))
  call Hloop_ZQ_A(ntryL,G0H8(36),wf8(:,34),G0H1(1),ngZl,m3h8x1(:,116),heltab2x8(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(438),n2h1(558))
  call Hloop_WQ_A(ntryL,G0H8(12),wf8(:,34),G0H1(1),m3h8x1(:,117),heltab2x8(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(443),n2h1(559))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,36),G0H1(1),m3h8x1(:,118),heltab2x8(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(448),n2h1(560))
  call Hloop_ZA_Q(ntryL,G0H8(3),wf8(:,36),G0H1(1),ngZl,m3h8x1(:,119),heltab2x8(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(453),n2h1(561))
  call Hloop_WA_Q(ntryL,G0H8(18),wf8(:,36),G0H1(1),m3h8x1(:,120),heltab2x8(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(458),n2h1(562))
  call ol_merge_tensors(G1tensor(186),[G1tensor(181),G0tensor(622),G0tensor(608),G0tensor(463),G0tensor(453),G0tensor(448) &
    ,G0tensor(443),G0tensor(432),G0tensor(317),G0tensor(340),G0tensor(215),G0tensor(278),G0tensor(6),G0tensor(69),G0tensor(44)])
  call ol_merge_tensors(G0tensor(265),[G0tensor(193),G0tensor(324),G0tensor(299),G0tensor(49)])
  call ol_merge_tensors(G0tensor(19),[G0tensor(1),G0tensor(54)])
  call ol_merge_tensors(G0tensor(625),[G0tensor(611),G0tensor(465),G0tensor(460),G0tensor(455),G0tensor(450),G0tensor(445) &
    ,G0tensor(440),G0tensor(435),G0tensor(430),G0tensor(271),G0tensor(277),G0tensor(206),G0tensor(186),G0tensor(161),G0tensor(330) &
    ,G0tensor(285),G0tensor(82),G0tensor(81),G0tensor(235),G0tensor(118),G0tensor(113),G0tensor(87),G0tensor(198),G0tensor(38) &
    ,G0tensor(168),G0tensor(349),G0tensor(14),G0tensor(9),G0tensor(4),G0tensor(339),G0tensor(314),G0tensor(199),G0tensor(84) &
    ,G0tensor(59)])
  call ol_merge_tensors(G0tensor(22),[G0tensor(210),G0tensor(11),G0tensor(184),G0tensor(74)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(16),G0tensor(79)])
  call ol_merge_tensors(G0tensor(617),[G0tensor(613),G0tensor(603),G0tensor(599),G0tensor(515),G0tensor(511),G0tensor(497) &
    ,G0tensor(493),G0tensor(489),G0tensor(485),G0tensor(471),G0tensor(221),G0tensor(202),G0tensor(122),G0tensor(29),G0tensor(200) &
    ,G0tensor(260),G0tensor(399),G0tensor(229),G0tensor(209),G0tensor(114),G0tensor(94)])
  call ol_merge_tensors(G0tensor(365),[G0tensor(166),G0tensor(116),G0tensor(245),G0tensor(77),G0tensor(115),G0tensor(359) &
    ,G0tensor(254),G0tensor(144),G0tensor(99)])
  call ol_merge_tensors(G1tensor(286),[G0tensor(475),G0tensor(196),G0tensor(111),G0tensor(83),G0tensor(379),G0tensor(104)])
  call ol_merge_tensors(G0tensor(255),[G0tensor(273),G0tensor(35),G0tensor(274),G0tensor(119)])
  call ol_merge_tensors(G1tensor(291),[G0tensor(157),G0tensor(50),G0tensor(124)])
  call ol_merge_tensors(G0tensor(620),[G0tensor(606),G0tensor(517),G0tensor(508),G0tensor(499),G0tensor(482),G0tensor(266) &
    ,G0tensor(231),G0tensor(192),G0tensor(360),G0tensor(126),G0tensor(300),G0tensor(72),G0tensor(148),G0tensor(183),G0tensor(76) &
    ,G0tensor(253),G0tensor(163),G0tensor(165),G0tensor(41),G0tensor(65),G0tensor(40),G0tensor(289),G0tensor(244),G0tensor(174) &
    ,G0tensor(129)])
  call ol_merge_tensors(G0tensor(262),[G0tensor(211),G0tensor(290),G0tensor(190),G0tensor(293),G0tensor(335),G0tensor(95) &
    ,G0tensor(259),G0tensor(214),G0tensor(139)])
  call ol_merge_tensors(G0tensor(385),[G0tensor(34),G0tensor(63),G0tensor(120),G0tensor(284),G0tensor(264),G0tensor(169) &
    ,G0tensor(149)])
  call ol_merge_tensors(G0tensor(325),[G0tensor(58),G0tensor(140),G0tensor(234),G0tensor(159)])
  call ol_merge_tensors(G0tensor(405),[G0tensor(355),G0tensor(167),G0tensor(155),G0tensor(164)])
  call ol_merge_tensors(G0tensor(177),[G0tensor(136),G0tensor(280),G0tensor(145),G0tensor(189)])
  call ol_merge_tensors(G0tensor(191),[G0tensor(156),G0tensor(97),G0tensor(173),G0tensor(309),G0tensor(194)])
  call ol_merge_tensors(G1tensor(316),[G0tensor(501),G0tensor(232),G0tensor(171),G0tensor(52),G0tensor(47),G0tensor(219)])
  call ol_merge_tensors(G1tensor(321),[G0tensor(396),G0tensor(248),G0tensor(239)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(207),G0tensor(117),G0tensor(68),G0tensor(279)])
  call ol_merge_tensors(G0tensor(251),[G0tensor(327),G0tensor(185),G0tensor(208),G0tensor(304)])
  call ol_merge_tensors(G1tensor(281),[G0tensor(462),G0tensor(252),G0tensor(2),G0tensor(329)])
  call ol_merge_tensors(G1tensor(266),[G1tensor(261),G1tensor(256),G1tensor(251),G1tensor(226),G1tensor(221),G1tensor(216) &
    ,G1tensor(211),G0tensor(109),G0tensor(89),G0tensor(64),G0tensor(39),G0tensor(452),G0tensor(226),G0tensor(13),G0tensor(7) &
    ,G0tensor(334)])
  call ol_merge_tensors(G1tensor(246),[G1tensor(241),G1tensor(236),G1tensor(231),G1tensor(206),G1tensor(201),G1tensor(196) &
    ,G1tensor(191),G1tensor(156),G1tensor(151),G1tensor(146),G1tensor(141),G1tensor(116),G1tensor(111),G1tensor(101),G1tensor(87) &
    ,G0tensor(454),G0tensor(429),G0tensor(295),G0tensor(36),G0tensor(178),G0tensor(18),G0tensor(8),G0tensor(3)])
  call ol_merge_tensors(G1tensor(413),[G0tensor(447),G0tensor(216),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(271),[G0tensor(614),G0tensor(510),G0tensor(247),G0tensor(384),G0tensor(364)])
  call ol_merge_tensors(G0tensor(492),[G0tensor(395),G0tensor(345),G0tensor(46),G0tensor(45),G0tensor(404),G0tensor(369)])
  call ol_merge_tensors(G0tensor(494),[G0tensor(469),G0tensor(203),G0tensor(298),G0tensor(288),G0tensor(108),G0tensor(51) &
    ,G0tensor(105),G0tensor(80),G0tensor(91),G0tensor(25),G0tensor(389)])
  call ol_merge_tensors(G0tensor(514),[G0tensor(311),G0tensor(110),G0tensor(30)])
  call ol_merge_tensors(G0tensor(486),[G0tensor(473),G0tensor(303),G0tensor(258),G0tensor(130),G0tensor(85),G0tensor(101)])
  call ol_merge_tensors(G1tensor(433),[G1tensor(301),G0tensor(601),G0tensor(490),G0tensor(477),G0tensor(90),G0tensor(75)])
  call ol_merge_tensors(G1tensor(438),[G1tensor(306),G0tensor(498),G0tensor(481),G0tensor(135),G0tensor(125)])
  call ol_merge_tensors(G1tensor(58),[G1tensor(41),G0tensor(444),G0tensor(434),G0tensor(188),G0tensor(27),G0tensor(21)])
  call ol_merge_tensors(G0tensor(449),[G0tensor(439),G0tensor(123),G0tensor(230)])
  call ol_merge_tensors(G1tensor(331),[G0tensor(600),G0tensor(488),G0tensor(375),G0tensor(243),G0tensor(158)])
  call ol_merge_tensors(G0tensor(496),[G0tensor(197),G0tensor(57),G0tensor(48)])
  call ol_merge_tensors(G1tensor(448),[G1tensor(418),G0tensor(615),G0tensor(512),G0tensor(503),G0tensor(67),G0tensor(142)])
  call ol_merge_tensors(G1tensor(453),[G1tensor(423),G0tensor(516),G0tensor(507),G0tensor(78),G0tensor(268)])
  call ol_merge_tensors(G0tensor(464),[G0tensor(459),G0tensor(88),G0tensor(152)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(171),G1tensor(166),G1tensor(161),G1tensor(136),G1tensor(131),G1tensor(126) &
    ,G1tensor(121),G0tensor(204),G0tensor(179),G0tensor(154),G0tensor(134),G0tensor(427),G0tensor(246),G0tensor(102),G0tensor(147) &
    ,G0tensor(180),G0tensor(32),G0tensor(305)])
  call ol_merge_tensors(G0tensor(387),[G0tensor(346),G0tensor(341),G0tensor(283)])
  call ol_merge_tensors(G0tensor(561),[G0tensor(521),G0tensor(107)])
  call ol_merge_tensors(G0tensor(566),[G0tensor(526),G0tensor(23),G0tensor(333)])
  call ol_merge_tensors(G0tensor(567),[G0tensor(562),G0tensor(527),G0tensor(522),G0tensor(410),G0tensor(352),G0tensor(291) &
    ,G0tensor(373),G0tensor(313)])
  call ol_merge_tensors(G0tensor(413),[G0tensor(357),G0tensor(296),G0tensor(338)])
  call ol_merge_tensors(G0tensor(571),[G0tensor(531),G0tensor(318)])
  call ol_merge_tensors(G0tensor(576),[G0tensor(536),G0tensor(383),G0tensor(133)])
  call ol_merge_tensors(G0tensor(577),[G0tensor(572),G0tensor(537),G0tensor(532),G0tensor(415),G0tensor(366),G0tensor(337) &
    ,G0tensor(363),G0tensor(343)])
  call ol_merge_tensors(G0tensor(418),[G0tensor(371),G0tensor(297),G0tensor(141)])
  call ol_merge_tensors(G0tensor(581),[G0tensor(541),G0tensor(348)])
  call ol_merge_tensors(G0tensor(586),[G0tensor(546),G0tensor(398),G0tensor(328)])
  call ol_merge_tensors(G0tensor(587),[G0tensor(582),G0tensor(547),G0tensor(542),G0tensor(420),G0tensor(376),G0tensor(302) &
    ,G0tensor(403),G0tensor(143)])
  call ol_merge_tensors(G0tensor(423),[G0tensor(377),G0tensor(312),G0tensor(218)])
  call ol_merge_tensors(G0tensor(591),[G0tensor(551),G0tensor(151)])
  call ol_merge_tensors(G0tensor(596),[G0tensor(556),G0tensor(93),G0tensor(233)])
  call ol_merge_tensors(G0tensor(597),[G0tensor(592),G0tensor(557),G0tensor(552),G0tensor(425),G0tensor(382),G0tensor(336) &
    ,G0tensor(53),G0tensor(223)])
  call ol_merge_tensors(G0tensor(559),[G0tensor(525),G0tensor(520),G0tensor(407),G0tensor(342),G0tensor(175)])
  call ol_merge_tensors(G0tensor(524),[G0tensor(301),G0tensor(33)])
  call ol_merge_tensors(G0tensor(569),[G0tensor(535),G0tensor(530),G0tensor(412),G0tensor(361),G0tensor(378)])
  call ol_merge_tensors(G0tensor(534),[G0tensor(347),G0tensor(358)])
  call ol_merge_tensors(G0tensor(579),[G0tensor(545),G0tensor(540),G0tensor(417),G0tensor(392),G0tensor(368)])
  call ol_merge_tensors(G0tensor(544),[G0tensor(306),G0tensor(393)])
  call ol_merge_tensors(G0tensor(589),[G0tensor(555),G0tensor(550),G0tensor(422),G0tensor(381),G0tensor(240)])
  call ol_merge_tensors(G0tensor(554),[G0tensor(322),G0tensor(103)])
  call ol_merge_tensors(G0tensor(467),[G0tensor(401),G0tensor(391),G0tensor(205),G0tensor(112),G0tensor(241),G0tensor(127) &
    ,G0tensor(250),G0tensor(220),G0tensor(315),G0tensor(270)])
  call ol_merge_tensors(G0tensor(479),[G0tensor(310),G0tensor(138)])
  call ol_merge_tensors(G1tensor(296),[G0tensor(437),G0tensor(146),G0tensor(195)])
  call ol_merge_tensors(G0tensor(505),[G0tensor(217),G0tensor(137)])
  call ol_merge_tensors(G1tensor(326),[G0tensor(457),G0tensor(282),G0tensor(71)])
  call ol_merge_tensors(G0tensor(506),[G0tensor(502),G0tensor(484),G0tensor(480),G0tensor(476),G0tensor(472),G0tensor(468) &
    ,G0tensor(321),G0tensor(257),G0tensor(222),G0tensor(390),G0tensor(370)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(64),G0tensor(458),G0tensor(442),G0tensor(438),G0tensor(433),G0tensor(428) &
    ,G0tensor(261),G0tensor(182),G0tensor(172)])
  call ol_merge_tensors(G0tensor(565),[G0tensor(560),G0tensor(519),G0tensor(331)])
  call ol_merge_tensors(G0tensor(575),[G0tensor(570),G0tensor(529),G0tensor(287)])
  call ol_merge_tensors(G0tensor(585),[G0tensor(580),G0tensor(539),G0tensor(292)])
  call ol_merge_tensors(G0tensor(595),[G0tensor(590),G0tensor(549),G0tensor(326)])
  call ol_merge_tensors(G0tensor(564),[G0tensor(409),G0tensor(351)])
  call ol_merge_tensors(G0tensor(574),[G0tensor(414),G0tensor(362)])
  call ol_merge_tensors(G0tensor(584),[G0tensor(419),G0tensor(372)])
  call ol_merge_tensors(G0tensor(594),[G0tensor(424),G0tensor(402)])
  call ol_merge_tensors(G1tensor(408),[G0tensor(604)])
  call ol_merge_tensors(G1tensor(443),[G1tensor(311),G0tensor(610)])
  call ol_merge_tensors(G1tensor(276),[G0tensor(618)])
  call ol_merge_tensors(G1tensor(458),[G1tensor(428),G0tensor(624)])
call TI_bubble_red(G1tensor(186),27,mass2set(:,1),G0tensor(224),M2L1R1,G0tensor(249))
call TI_bubble_red(G1tensor(286),26,mass2set(:,2),G0tensor(269),M2L1R1)
call TI_bubble_red(G1tensor(291),26,mass2set(:,3),G0tensor(294),M2L1R1,G0tensor(319))
call TI_bubble_red(G1tensor(316),25,mass2set(:,2),G0tensor(344),M2L1R1)
call TI_bubble_red(G1tensor(321),25,mass2set(:,3),G0tensor(5),M2L1R1,G0tensor(10))
call TI_bubble_red(G1tensor(281),21,mass2set(:,4),G0tensor(15),M2L1R1,G0tensor(354))
call TI_bubble_red(G1tensor(266),20,mass2set(:,1),G0tensor(374),M2L1R1,G0tensor(394))
call TI_bubble_red(G1tensor(246),16,mass2set(:,1),G0tensor(20),M2L1R1,G0tensor(55))
call TI_bubble_red(G1tensor(413),22,mass2set(:,4),G0tensor(60),M2L1R1,G0tensor(70))
call TI_bubble_red(G1tensor(271),21,mass2set(:,2),G0tensor(31),M2L1R1)
call TI_bubble_red(G1tensor(433),18,mass2set(:,2),G0tensor(100),M2L1R1)
call TI_bubble_red(G1tensor(438),18,mass2set(:,5),G0tensor(160),M2L1R1,G0tensor(150))
call TI_bubble_red(G1tensor(58),19,mass2set(:,1),G0tensor(26),M2L1R1,G0tensor(28))
call TI_bubble_red(G1tensor(331),22,mass2set(:,2),G0tensor(37),M2L1R1)
call TI_bubble_red(G1tensor(448),17,mass2set(:,2),G0tensor(238),M2L1R1)
call TI_bubble_red(G1tensor(453),17,mass2set(:,5),G0tensor(98),M2L1R1,G0tensor(56))
call TI_bubble_red(G1tensor(176),24,mass2set(:,1),G0tensor(66),M2L1R1,G0tensor(132))
call TI_bubble_red(G1tensor(296),26,mass2set(:,4),G0tensor(263),M2L1R1,G0tensor(308))
call TI_bubble_red(G1tensor(326),25,mass2set(:,4),G0tensor(86),M2L1R1,G0tensor(213))
call TI_bubble_red(G1tensor(82),23,mass2set(:,1),G0tensor(96),M2L1R1,G0tensor(106))
call TI_bubble_red(G1tensor(408),22,mass2set(:,3),G0tensor(131),M2L1R1,G0tensor(323))
call TI_bubble_red(G1tensor(443),18,mass2set(:,6),G0tensor(228),M2L1R1,G0tensor(153))
call TI_bubble_red(G1tensor(276),21,mass2set(:,3),G0tensor(353),M2L1R1,G0tensor(388))
call TI_bubble_red(G1tensor(458),17,mass2set(:,6),G0tensor(408),M2L1R1,G0tensor(43))
  call ol_merge_tensors(G0tensor(43),[G0tensor(153),G0tensor(106),G0tensor(213),G0tensor(308),G0tensor(132),G0tensor(28) &
    ,G0tensor(70),G0tensor(55),G0tensor(394),G0tensor(354),G0tensor(625),G0tensor(249)])
  call ol_merge_tensors(G0tensor(388),[G0tensor(323),G0tensor(56),G0tensor(150),G0tensor(10),G0tensor(620),G0tensor(319)])
  call ol_merge_tensors(T0sum(229),[G0tensor(224)])
  call ol_merge_tensors(T0sum(230),[G0tensor(43)])
  call ol_merge_tensors(T0sum(231),[G0tensor(265)])
  call ol_merge_tensors(T0sum(232),[G0tensor(19)])
  call ol_merge_tensors(T0sum(233),[G0tensor(22)])
  call ol_merge_tensors(T0sum(234),[G0tensor(92)])
  call ol_merge_tensors(T0sum(235),[G0tensor(617)])
  call ol_merge_tensors(T0sum(236),[G0tensor(365)])
  call ol_merge_tensors(T0sum(237),[G0tensor(269)])
  call ol_merge_tensors(T0sum(238),[G0tensor(255)])
  call ol_merge_tensors(T0sum(239),[G0tensor(294)])
  call ol_merge_tensors(T0sum(240),[G0tensor(388)])
  call ol_merge_tensors(T0sum(241),[G0tensor(262)])
  call ol_merge_tensors(T0sum(242),[G0tensor(385)])
  call ol_merge_tensors(T0sum(243),[G0tensor(325)])
  call ol_merge_tensors(T0sum(244),[G0tensor(405)])
  call ol_merge_tensors(T0sum(245),[G0tensor(177)])
  call ol_merge_tensors(T0sum(246),[G0tensor(191)])
  call ol_merge_tensors(T0sum(247),[G0tensor(344)])
  call ol_merge_tensors(T0sum(248),[G0tensor(5)])
  call ol_merge_tensors(T0sum(249),[G0tensor(237)])
  call ol_merge_tensors(T0sum(250),[G0tensor(251)])
  call ol_merge_tensors(T0sum(251),[G0tensor(15)])
  call ol_merge_tensors(T0sum(252),[G0tensor(374)])
  call ol_merge_tensors(T0sum(253),[G0tensor(20)])
  call ol_merge_tensors(T0sum(254),[G0tensor(60)])
  call ol_merge_tensors(T0sum(255),[G0tensor(31)])
  call ol_merge_tensors(T0sum(256),[G0tensor(492)])
  call ol_merge_tensors(T0sum(257),[G0tensor(494)])
  call ol_merge_tensors(T0sum(258),[G0tensor(514)])
  call ol_merge_tensors(T0sum(259),[G0tensor(486)])
  call ol_merge_tensors(T0sum(260),[G0tensor(100)])
  call ol_merge_tensors(T0sum(261),[G0tensor(160)])
  call ol_merge_tensors(T0sum(262),[G0tensor(26)])
  call ol_merge_tensors(T0sum(263),[G0tensor(449)])
  call ol_merge_tensors(T0sum(264),[G0tensor(37)])
  call ol_merge_tensors(T0sum(265),[G0tensor(496)])
  call ol_merge_tensors(T0sum(266),[G0tensor(238)])
  call ol_merge_tensors(T0sum(267),[G0tensor(98)])
  call ol_merge_tensors(T0sum(268),[G0tensor(464)])
  call ol_merge_tensors(T0sum(269),[G0tensor(66)])
  call ol_merge_tensors(T0sum(270),[G0tensor(387)])
  call ol_merge_tensors(T0sum(271),[G0tensor(561)])
  call ol_merge_tensors(T0sum(272),[G0tensor(566)])
  call ol_merge_tensors(T0sum(273),[G0tensor(567)])
  call ol_merge_tensors(T0sum(274),[G0tensor(413)])
  call ol_merge_tensors(T0sum(275),[G0tensor(571)])
  call ol_merge_tensors(T0sum(276),[G0tensor(576)])
  call ol_merge_tensors(T0sum(277),[G0tensor(577)])
  call ol_merge_tensors(T0sum(278),[G0tensor(418)])
  call ol_merge_tensors(T0sum(279),[G0tensor(581)])
  call ol_merge_tensors(T0sum(280),[G0tensor(586)])
  call ol_merge_tensors(T0sum(281),[G0tensor(587)])
  call ol_merge_tensors(T0sum(282),[G0tensor(423)])
  call ol_merge_tensors(T0sum(283),[G0tensor(591)])
  call ol_merge_tensors(T0sum(284),[G0tensor(596)])
  call ol_merge_tensors(T0sum(285),[G0tensor(597)])
  call ol_merge_tensors(T0sum(286),[G0tensor(559)])
  call ol_merge_tensors(T0sum(287),[G0tensor(524)])
  call ol_merge_tensors(T0sum(288),[G0tensor(569)])
  call ol_merge_tensors(T0sum(289),[G0tensor(534)])
  call ol_merge_tensors(T0sum(290),[G0tensor(579)])
  call ol_merge_tensors(T0sum(291),[G0tensor(544)])
  call ol_merge_tensors(T0sum(292),[G0tensor(589)])
  call ol_merge_tensors(T0sum(293),[G0tensor(554)])
  call ol_merge_tensors(T0sum(294),[G0tensor(467)])
  call ol_merge_tensors(T0sum(295),[G0tensor(479)])
  call ol_merge_tensors(T0sum(296),[G0tensor(263)])
  call ol_merge_tensors(T0sum(297),[G0tensor(505)])
  call ol_merge_tensors(T0sum(298),[G0tensor(86)])
  call ol_merge_tensors(T0sum(299),[G0tensor(506)])
  call ol_merge_tensors(T0sum(300),[G0tensor(96)])
  call ol_merge_tensors(T0sum(301),[G0tensor(565)])
  call ol_merge_tensors(T0sum(302),[G0tensor(575)])
  call ol_merge_tensors(T0sum(303),[G0tensor(585)])
  call ol_merge_tensors(T0sum(304),[G0tensor(595)])
  call ol_merge_tensors(T0sum(305),[G0tensor(564)])
  call ol_merge_tensors(T0sum(306),[G0tensor(574)])
  call ol_merge_tensors(T0sum(307),[G0tensor(584)])
  call ol_merge_tensors(T0sum(308),[G0tensor(594)])
  call ol_merge_tensors(T0sum(309),[G0tensor(131)])
  call ol_merge_tensors(T0sum(310),[G0tensor(605)])
  call ol_merge_tensors(T0sum(311),[G0tensor(609)])
  call ol_merge_tensors(T0sum(312),[G0tensor(228)])
  call ol_merge_tensors(T0sum(313),[G0tensor(353)])
  call ol_merge_tensors(T0sum(314),[G0tensor(619)])
  call ol_merge_tensors(T0sum(315),[G0tensor(623)])
  call ol_merge_tensors(T0sum(316),[G0tensor(408)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_35,RedSet_4(5),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_35,RedSet_4(6),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_37,RedSet_4(7),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_36,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_35,RedSet_4(8),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_29,RedSet_4(9),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_37,RedSet_4(10),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_35,RedSet_4(11),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_35,RedSet_4(3),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_29,RedSet_4(12),ScalarBoxes(10))
  call compute_scalar_box([ 20, 22, 23 ],masses2_35,RedSet_4(13),ScalarBoxes(11))
  call compute_scalar_box([ 16, 22, 23 ],masses2_35,RedSet_4(14),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 22 ],masses2_36,RedSet_4(2),ScalarBoxes(13))
  call compute_scalar_box([ 4, 6, 7 ],masses2_35,RedSet_4(15),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_29,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_37,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_35,RedSet_4(18),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_29,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 17, 19, 23 ],masses2_29,RedSet_4(20),ScalarBoxes(19))
  call compute_scalar_box([ 16, 17, 23 ],masses2_35,RedSet_4(21),ScalarBoxes(20))
  call compute_scalar_box([ 16, 17, 19 ],masses2_35,RedSet_4(4),ScalarBoxes(21))
  call compute_scalar_box([ 1, 3, 7 ],masses2_29,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 17, 19, 27 ],masses2_29,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 16, 17, 27 ],masses2_35,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 1, 3, 11 ],masses2_29,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 20, 21, 23 ],masses2_27,RedSet_4(5),ScalarBoxes(26))
  call compute_scalar_box([ 16, 21, 23 ],masses2_27,RedSet_4(6),ScalarBoxes(27))
  call compute_scalar_box([ 16, 20, 23 ],masses2_27,RedSet_4(7),ScalarBoxes(28))
  call compute_scalar_box([ 16, 20, 21 ],masses2_27,RedSet_4(1),ScalarBoxes(29))
  call compute_scalar_box([ 4, 5, 7 ],masses2_27,RedSet_4(8),ScalarBoxes(30))
  call compute_scalar_box([ 20, 21, 23 ],masses2_30,RedSet_4(5),ScalarBoxes(31))
  call compute_scalar_box([ 16, 21, 23 ],masses2_30,RedSet_4(6),ScalarBoxes(32))
  call compute_scalar_box([ 16, 20, 21 ],masses2_28,RedSet_4(1),ScalarBoxes(33))
  call compute_scalar_box([ 4, 5, 7 ],masses2_30,RedSet_4(8),ScalarBoxes(34))
  call compute_scalar_box([ 18, 19, 23 ],masses2_27,RedSet_4(9),ScalarBoxes(35))
  call compute_scalar_box([ 16, 19, 23 ],masses2_27,RedSet_4(10),ScalarBoxes(36))
  call compute_scalar_box([ 16, 18, 23 ],masses2_27,RedSet_4(11),ScalarBoxes(37))
  call compute_scalar_box([ 16, 18, 19 ],masses2_27,RedSet_4(3),ScalarBoxes(38))
  call compute_scalar_box([ 2, 3, 7 ],masses2_27,RedSet_4(12),ScalarBoxes(39))
  call compute_scalar_box([ 18, 19, 23 ],masses2_38,RedSet_4(9),ScalarBoxes(40))
  call compute_scalar_box([ 16, 18, 23 ],masses2_30,RedSet_4(11),ScalarBoxes(41))
  call compute_scalar_box([ 16, 18, 19 ],masses2_30,RedSet_4(3),ScalarBoxes(42))
  call compute_scalar_box([ 2, 3, 7 ],masses2_38,RedSet_4(12),ScalarBoxes(43))
  call compute_scalar_box([ 20, 22, 23 ],masses2_27,RedSet_4(13),ScalarBoxes(44))
  call compute_scalar_box([ 16, 22, 23 ],masses2_27,RedSet_4(14),ScalarBoxes(45))
  call compute_scalar_box([ 16, 20, 22 ],masses2_27,RedSet_4(2),ScalarBoxes(46))
  call compute_scalar_box([ 4, 6, 7 ],masses2_27,RedSet_4(15),ScalarBoxes(47))
  call compute_scalar_box([ 20, 22, 23 ],masses2_30,RedSet_4(13),ScalarBoxes(48))
  call compute_scalar_box([ 16, 22, 23 ],masses2_30,RedSet_4(14),ScalarBoxes(49))
  call compute_scalar_box([ 16, 20, 22 ],masses2_28,RedSet_4(2),ScalarBoxes(50))
  call compute_scalar_box([ 4, 6, 7 ],masses2_30,RedSet_4(15),ScalarBoxes(51))
  call compute_scalar_box([ 18, 19, 27 ],masses2_27,RedSet_4(16),ScalarBoxes(52))
  call compute_scalar_box([ 16, 19, 27 ],masses2_27,RedSet_4(17),ScalarBoxes(53))
  call compute_scalar_box([ 16, 18, 27 ],masses2_27,RedSet_4(18),ScalarBoxes(54))
  call compute_scalar_box([ 2, 3, 11 ],masses2_27,RedSet_4(19),ScalarBoxes(55))
  call compute_scalar_box([ 18, 19, 27 ],masses2_38,RedSet_4(16),ScalarBoxes(56))
  call compute_scalar_box([ 16, 18, 27 ],masses2_30,RedSet_4(18),ScalarBoxes(57))
  call compute_scalar_box([ 2, 3, 11 ],masses2_38,RedSet_4(19),ScalarBoxes(58))
  call compute_scalar_box([ 17, 19, 23 ],masses2_27,RedSet_4(20),ScalarBoxes(59))
  call compute_scalar_box([ 16, 17, 23 ],masses2_27,RedSet_4(21),ScalarBoxes(60))
  call compute_scalar_box([ 16, 17, 19 ],masses2_27,RedSet_4(4),ScalarBoxes(61))
  call compute_scalar_box([ 1, 3, 7 ],masses2_27,RedSet_4(22),ScalarBoxes(62))
  call compute_scalar_box([ 17, 19, 23 ],masses2_38,RedSet_4(20),ScalarBoxes(63))
  call compute_scalar_box([ 16, 17, 23 ],masses2_30,RedSet_4(21),ScalarBoxes(64))
  call compute_scalar_box([ 16, 17, 19 ],masses2_30,RedSet_4(4),ScalarBoxes(65))
  call compute_scalar_box([ 1, 3, 7 ],masses2_38,RedSet_4(22),ScalarBoxes(66))
  call compute_scalar_box([ 17, 19, 27 ],masses2_27,RedSet_4(23),ScalarBoxes(67))
  call compute_scalar_box([ 16, 17, 27 ],masses2_27,RedSet_4(24),ScalarBoxes(68))
  call compute_scalar_box([ 1, 3, 11 ],masses2_27,RedSet_4(25),ScalarBoxes(69))
  call compute_scalar_box([ 17, 19, 27 ],masses2_38,RedSet_4(23),ScalarBoxes(70))
  call compute_scalar_box([ 16, 17, 27 ],masses2_30,RedSet_4(24),ScalarBoxes(71))
  call compute_scalar_box([ 1, 3, 11 ],masses2_38,RedSet_4(25),ScalarBoxes(72))
! end of process

! end do

end subroutine vamp_1

end module ol_vamp_1_pplla_ew_eexaaa_1_/**/REALKIND
