
module ol_vamp_3_pplla_ew_eexddxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplla_ew_eexddxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplla_ew_eexddxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplla_ew_eexddxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplla_ew_eexddxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplla_ew_eexddxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplla_ew_eexddxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[19,12],[0,0],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZd,m3h8x4(:,172),heltab2x32(:,:,498))
  call Hloop_Q_A(ntryL,G0H4(35),19,0,G1H4(120),n2h4(233))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[19,12],[nMB,nMB],2,2,wf8(:,6),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,6),G0H4(35),ngZd,m3h8x4(:,173),heltab2x32(:,:,499))
  call Hloop_Q_A(ntryL,G0H4(35),19,nMB,G1H4(121),n2h4(234))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(122),m3h8x4(:,174),heltab2x32(:,:,500))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(123),m3h8x4(:,175),heltab2x32(:,:,501))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(124),m3h8x4(:,176),heltab2x32(:,:,502))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(125),m3h8x4(:,177),heltab2x32(:,:,503))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(126),m3h8x4(:,178),heltab2x32(:,:,504))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(127),m3h8x4(:,179),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(128),m3h8x4(:,180),heltab2x32(:,:,506))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(129),m3h8x4(:,181),heltab2x32(:,:,507))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(130),m3h8x4(:,182),heltab2x32(:,:,508))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(131),m3h8x4(:,183),heltab2x32(:,:,509))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(132),m3h8x4(:,184),heltab2x32(:,:,510))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(133),m3h8x4(:,185),heltab2x32(:,:,511))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(134),m3h8x4(:,186),heltab2x32(:,:,512))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(135),m3h8x4(:,187),heltab2x32(:,:,513))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(136),m3h8x4(:,188),heltab2x32(:,:,514))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(137),m3h8x4(:,189),heltab2x32(:,:,515))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(138),m3h8x4(:,190),heltab2x32(:,:,516))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(35),m3h8x4(:,191),heltab2x32(:,:,517))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(36),m3h8x4(:,192),heltab2x32(:,:,518))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(37),m3h8x4(:,193),heltab2x32(:,:,519))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[19,12],[nMW,nMW],2,2,wf8(:,5),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(38),m3h8x4(:,194),heltab2x32(:,:,520))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(39),m3h8x4(:,195),heltab2x32(:,:,521))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(40),m3h8x4(:,196),heltab2x32(:,:,522))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[19,12],[nMZ,nMH],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(41),m3h8x4(:,197),heltab2x32(:,:,523))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(42),m3h8x4(:,198),heltab2x32(:,:,524))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[19,12],[nMW,nMW],2,2,wf8(:,6),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(43),m3h8x4(:,199),heltab2x32(:,:,525))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[17,14],[0,0],2,2,wf4(:,9),wf8(:,38))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(12),m3h4x8(:,87),heltab2x32(:,:,526))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,38))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(13),ngZl,m3h4x8(:,88),heltab2x32(:,:,527))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,38))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(14),m3h4x8(:,89),heltab2x32(:,:,528))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[17,14],[0,0],2,2,wf4(:,9),wf8(:,40))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,9),G0H8(19),m3h4x8(:,90),heltab2x32(:,:,529))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[17,14],[nMZ,0],2,2,wf4(:,9),wf8(:,40))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,9),G0H8(1),ngZl,m3h4x8(:,91),heltab2x32(:,:,530))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[17,14],[nMW,0],2,2,wf4(:,9),wf8(:,40))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,9),G0H8(2),m3h4x8(:,92),heltab2x32(:,:,531))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,200),heltab2x32(:,:,532))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(139),n2h4(235))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,201),heltab2x32(:,:,533))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(140),n2h4(236))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,202),heltab2x32(:,:,534))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(141),n2h4(237))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,203),heltab2x32(:,:,535))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(142),n2h4(238))
  Gcoeff(:)%j = (c(63)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,204),heltab2x32(:,:,536))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(143),n2h4(239))
  Gcoeff(:)%j = (c(59)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[19,12],[0,0],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,205),heltab2x32(:,:,537))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(144),n2h4(240))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,206),heltab2x32(:,:,538))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(145),n2h4(241))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,207),heltab2x32(:,:,539))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(146),n2h4(242))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[19,12],[nMM,nMM],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,208),heltab2x32(:,:,540))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(147),n2h4(243))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[19,12],[nML,nML],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,209),heltab2x32(:,:,541))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(148),n2h4(244))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,210),heltab2x32(:,:,542))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(149),n2h4(245))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[19,12],[nMT,nMT],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,211),heltab2x32(:,:,543))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(150),n2h4(246))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[19,12],[0,0],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,212),heltab2x32(:,:,544))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(151),n2h4(247))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[19,12],[nMB,nMB],2,2,wf8(:,7),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,213),heltab2x32(:,:,545))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(152),n2h4(248))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,214),heltab2x32(:,:,546))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(153),n2h4(249))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,215),heltab2x32(:,:,547))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(154),n2h4(250))
  Gcoeff(:)%j = (c(67)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,216),heltab2x32(:,:,548))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(155),n2h4(251))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,217),heltab2x32(:,:,549))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(156),n2h4(252))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,218),heltab2x32(:,:,550))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(157),n2h4(253))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[19,12],[0,0],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,219),heltab2x32(:,:,551))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(158),n2h4(254))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,220),heltab2x32(:,:,552))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(159),n2h4(255))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZn,m3h8x4(:,221),heltab2x32(:,:,553))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(160),n2h4(256))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,222),heltab2x32(:,:,554))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(161),n2h4(257))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[19,12],[nMM,nMM],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,223),heltab2x32(:,:,555))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMM,G1H4(162),n2h4(258))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[19,12],[nML,nML],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZl,m3h8x4(:,224),heltab2x32(:,:,556))
  call Hloop_Q_A(ntryL,G0H4(44),19,nML,G1H4(163),n2h4(259))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,225),heltab2x32(:,:,557))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(164),n2h4(260))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[19,12],[nMT,nMT],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZu,m3h8x4(:,226),heltab2x32(:,:,558))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMT,G1H4(165),n2h4(261))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[19,12],[0,0],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,227),heltab2x32(:,:,559))
  call Hloop_Q_A(ntryL,G0H4(44),19,0,G1H4(166),n2h4(262))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[19,12],[nMB,nMB],2,2,wf8(:,8),wf4(:,10))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,8),G0H4(44),ngZd,m3h8x4(:,228),heltab2x32(:,:,560))
  call Hloop_Q_A(ntryL,G0H4(44),19,nMB,G1H4(167),n2h4(263))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(168),m3h8x4(:,229),heltab2x32(:,:,561))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(169),m3h8x4(:,230),heltab2x32(:,:,562))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(170),m3h8x4(:,231),heltab2x32(:,:,563))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(171),m3h8x4(:,232),heltab2x32(:,:,564))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(172),m3h8x4(:,233),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(173),m3h8x4(:,234),heltab2x32(:,:,566))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(174),m3h8x4(:,235),heltab2x32(:,:,567))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(175),m3h8x4(:,236),heltab2x32(:,:,568))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(176),m3h8x4(:,237),heltab2x32(:,:,569))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(177),m3h8x4(:,238),heltab2x32(:,:,570))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(178),m3h8x4(:,239),heltab2x32(:,:,571))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(179),m3h8x4(:,240),heltab2x32(:,:,572))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(180),m3h8x4(:,241),heltab2x32(:,:,573))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(181),m3h8x4(:,242),heltab2x32(:,:,574))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(182),m3h8x4(:,243),heltab2x32(:,:,575))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(183),m3h8x4(:,244),heltab2x32(:,:,576))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(184),m3h8x4(:,245),heltab2x32(:,:,577))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(44),m3h8x4(:,246),heltab2x32(:,:,578))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(45),m3h8x4(:,247),heltab2x32(:,:,579))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(46),m3h8x4(:,248),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[19,12],[nMW,nMW],2,2,wf8(:,7),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(47),m3h8x4(:,249),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(48),m3h8x4(:,250),heltab2x32(:,:,582))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(49),m3h8x4(:,251),heltab2x32(:,:,583))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[19,12],[nMZ,nMH],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(50),m3h8x4(:,252),heltab2x32(:,:,584))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(51),m3h8x4(:,253),heltab2x32(:,:,585))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[19,12],[nMW,nMW],2,2,wf8(:,8),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(52),m3h8x4(:,254),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[18,13],[0,0],2,2,wf4(:,12),wf8(:,42))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(3),m3h4x8(:,93),heltab2x32(:,:,587))
  call Hloop_A_Q(ntryL,G0H8(3),18,0,G1H8(29),n2h8(69))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,42))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(4),ngZl,m3h4x8(:,94),heltab2x32(:,:,588))
  call Hloop_A_Q(ntryL,G0H8(4),18,0,G1H8(10),n2h8(70))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,42))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,95),heltab2x32(:,:,589))
  call Hloop_A_Q(ntryL,G0H8(5),18,0,G1H8(11),n2h8(71))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[18,13],[0,0],2,2,wf4(:,12),wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(10),m3h4x8(:,96),heltab2x32(:,:,590))
  call Hloop_A_Q(ntryL,G0H8(10),18,0,G1H8(31),n2h8(72))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[18,13],[0,nMZ],2,2,wf4(:,12),wf8(:,44))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngZl,m3h4x8(:,97),heltab2x32(:,:,591))
  call Hloop_A_Q(ntryL,G0H8(11),18,0,G1H8(32),n2h8(73))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[18,13],[0,nMW],2,2,wf4(:,12),wf8(:,44))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(3),m3h4x8(:,98),heltab2x32(:,:,592))
  call Hloop_A_Q(ntryL,G0H8(3),18,0,G1H8(33),n2h8(74))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(76),G1H4(64),G1H4(63),G0H4(13),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(78),G1H4(62),G1H4(24),G0H4(15),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(89),G1H4(46),G1H4(9),G0H4(14),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(91),G1H4(22),G1H4(54),G0H4(16),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(170),[G1H4(168),G1H4(124),G1H4(122),G0H4(3),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(169),G1H4(126),G1H4(123),G0H4(6),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(181),G1H4(137),G1H4(135),G0H4(5),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(182),G1H4(138),G1H4(136),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(14),G1H4(11),G1H4(7),G1H4(1),G1H4(34),G1H4(28) &
    ,G1H4(16),G1H4(5),G1H4(48),G1H4(57),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(61),G1H4(17),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(3),G1H4(6),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(45),G1H4(21),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(8),G1H4(23),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30),G1H4(43),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(66),G1H4(50),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(67),G1H4(56),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(68),G1H4(51),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(70),G1H4(55),G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(71),G1H4(58),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(42),G1H4(59),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(83),G1H4(82),G1H4(81),G1H4(25),G1H4(60) &
    ,G1H4(19),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(87),G1H4(86),G1H4(85),G1H4(49),G1H4(13) &
    ,G1H4(41),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(29),[G0H4(28),G0H4(27),G0H4(26),G0H4(20),G0H4(19) &
    ,G0H4(18),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(34),[G0H4(33),G0H4(31),G0H4(30),G0H4(25),G0H4(24) &
    ,G0H4(22),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(32),[G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(156),G1H4(153),G1H4(144),G1H4(142),G1H4(139) &
    ,G1H4(112),G1H4(110),G1H4(107),G1H4(98),G1H4(96),G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(140),G1H4(108),G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(155),[G1H4(141),G1H4(109),G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(143),G1H4(111),G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(145),G1H4(113),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(161),[G1H4(146),G1H4(115),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(147),G1H4(116),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(148),G1H4(117),G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(149),G1H4(118),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(150),G1H4(119),G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(151),G1H4(120),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(152),G1H4(121),G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(160),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(177),G1H4(174),G1H4(173),G1H4(132),G1H4(131) &
    ,G1H4(128),G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(179),G1H4(176),G1H4(175),G1H4(134),G1H4(133) &
    ,G1H4(130),G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(49),[G0H4(48),G0H4(45),G0H4(44),G0H4(40),G0H4(39) &
    ,G0H4(36),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(52),[G0H4(51),G0H4(47),G0H4(46),G0H4(43),G0H4(42) &
    ,G0H4(38),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(50),[G0H4(41)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(3),wf4(:,1),wf4(:,8),G1tensor(12),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(1),wf4(:,1),wf4(:,10),G1tensor(26),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(6),wf4(:,4),wf4(:,8),G1tensor(54),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(15),wf4(:,4),wf4(:,10),G1tensor(50),m4h4x4x1(:,4),heltab3x16(:,:,4))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(65),wf4(:,1),wf4(:,8),G1tensor(78),m4h4x4x1(:,5),heltab3x16(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(66),wf4(:,1),wf4(:,10),G1tensor(84),m4h4x4x1(:,6),heltab3x16(:,:,6))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(69),wf4(:,4),wf4(:,8),G1tensor(98),m4h4x4x1(:,7),heltab3x16(:,:,7))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(70),wf4(:,4),wf4(:,10),G1tensor(63),m4h4x4x1(:,8),heltab3x16(:,:,8))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(77),28,wf4(:,1),3,G2tensor(29),m3h4x1(:,97),heltab2x4(:,:,181))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(80),28,wf4(:,4),3,G2tensor(32),m3h4x1(:,98),heltab2x4(:,:,182))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(90),28,wf4(:,1),3,G2tensor(35),m3h4x1(:,99),heltab2x4(:,:,183))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(92),28,wf4(:,4),3,G2tensor(38),m3h4x1(:,100),heltab2x4(:,:,184))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(170),19,wf4(:,8),12,G2tensor(41),m3h4x1(:,101),heltab2x4(:,:,185))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(172),19,wf4(:,10),12,G2tensor(44),m3h4x1(:,102),heltab2x4(:,:,186))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(183),19,wf4(:,8),12,G2tensor(47),m3h4x1(:,103),heltab2x4(:,:,187))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(184),19,wf4(:,10),12,G2tensor(50),m3h4x1(:,104),heltab2x4(:,:,188))
  call Hloop_VA_Q(ntryL,G0H8(15),wf8(:,31),G0H1(1),m3h8x1(:,21),heltab2x8(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(8),n2h1(211))
  call Hloop_ZA_Q(ntryL,G0H8(6),wf8(:,31),G0H1(1),ngZd,m3h8x1(:,22),heltab2x8(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(28),n2h1(212))
  call Hloop_WA_Q(ntryL,G0H8(7),wf8(:,31),G0H1(1),m3h8x1(:,23),heltab2x8(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(34),n2h1(213))
  call Hloop_VA_Q(ntryL,G0H8(18),wf8(:,32),G0H1(1),m3h8x1(:,24),heltab2x8(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(47),n2h1(214))
  call Hloop_ZA_Q(ntryL,G0H8(8),wf8(:,32),G0H1(1),ngZd,m3h8x1(:,25),heltab2x8(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(39),n2h1(215))
  call Hloop_WA_Q(ntryL,G0H8(9),wf8(:,32),G0H1(1),m3h8x1(:,26),heltab2x8(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(58),n2h1(216))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,1),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(217))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,1),G1H1(1),m3h4x1(:,106),heltab2x4(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(56),n2h1(218))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(57),n2h1(219))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(108),n2h1(220))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(221))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,110),heltab2x4(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(222))
  call Hloop_QZ_A(ntryL,G1H4(26),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,111),heltab2x4(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(60),n2h1(223))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,4),G1H1(1),ngZl,m3h4x1(:,112),heltab2x4(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(61),n2h1(224))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,113),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(225))
  call Hloop_QZ_A(ntryL,G1H4(73),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,114),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(226))
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,115),heltab2x4(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(227))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,4),G1H1(1),ngZd,m3h4x1(:,116),heltab2x4(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(228))
  call Hloop_QZ_A(ntryL,G1H4(52),wf4(:,4),G1H1(1),ngZn,m3h4x1(:,117),heltab2x4(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(229))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(79),28,wf4(:,4),3,G2tensor(67),m3h4x1(:,118),heltab2x4(:,:,202))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(84),28,wf4(:,1),3,G2tensor(68),m3h4x1(:,119),heltab2x4(:,:,203))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(88),28,wf4(:,4),3,G2tensor(69),m3h4x1(:,120),heltab2x4(:,:,204))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(29),wf4(:,1),G0tensor(1),m3h4x1(:,121),heltab2x4(:,:,205))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(34),wf4(:,4),G0tensor(26),m3h4x1(:,122),heltab2x4(:,:,206))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(32),wf4(:,4),G0tensor(51),m3h4x1(:,123),heltab2x4(:,:,207))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(26),wf8(:,35),G1tensor(69),m3h8x1(:,27),heltab2x8(:,:,143))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(22),wf8(:,35),G1tensor(75),ngZd,m3h8x1(:,28),heltab2x8(:,:,144))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(20),wf8(:,35),G1tensor(81),m3h8x1(:,29),heltab2x8(:,:,145))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(28),wf8(:,36),G1tensor(89),m3h8x1(:,30),heltab2x8(:,:,146))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(25),wf8(:,36),G1tensor(112),ngZd,m3h8x1(:,31),heltab2x8(:,:,147))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(30),wf8(:,36),G1tensor(116),m3h8x1(:,32),heltab2x8(:,:,148))
  call Hloop_QV_A(ntryL,G1H4(158),wf4(:,8),G1H1(1),m3h4x1(:,124),heltab2x4(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(230))
  call Hloop_QV_A(ntryL,G1H4(154),wf4(:,8),G1H1(1),m3h4x1(:,125),heltab2x4(:,:,209))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(71),n2h1(231))
  call Hloop_QV_A(ntryL,G1H4(155),wf4(:,8),G1H1(1),m3h4x1(:,126),heltab2x4(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(72),n2h1(232))
  call Hloop_QV_A(ntryL,G1H4(157),wf4(:,8),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(233))
  call Hloop_QV_A(ntryL,G1H4(159),wf4(:,8),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(76),n2h1(234))
  call Hloop_QZ_A(ntryL,G1H4(161),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,129),heltab2x4(:,:,213))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(235))
  call Hloop_QZ_A(ntryL,G1H4(162),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,130),heltab2x4(:,:,214))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(78),n2h1(236))
  call Hloop_QZ_A(ntryL,G1H4(163),wf4(:,10),G1H1(1),ngZl,m3h4x1(:,131),heltab2x4(:,:,215))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(79),n2h1(237))
  call Hloop_QZ_A(ntryL,G1H4(164),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,132),heltab2x4(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(238))
  call Hloop_QZ_A(ntryL,G1H4(165),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,133),heltab2x4(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(239))
  call Hloop_QZ_A(ntryL,G1H4(166),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,134),heltab2x4(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(240))
  call Hloop_QZ_A(ntryL,G1H4(167),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,135),heltab2x4(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(241))
  call Hloop_QZ_A(ntryL,G1H4(160),wf4(:,10),G1H1(1),ngZn,m3h4x1(:,136),heltab2x4(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(242))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(171),19,wf4(:,10),12,G2tensor(93),m3h4x1(:,137),heltab2x4(:,:,221))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(178),19,wf4(:,8),12,G2tensor(94),m3h4x1(:,138),heltab2x4(:,:,222))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(180),19,wf4(:,10),12,G2tensor(95),m3h4x1(:,139),heltab2x4(:,:,223))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(49),wf4(:,8),G0tensor(76),m3h4x1(:,140),heltab2x4(:,:,224))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(52),wf4(:,10),G0tensor(101),m3h4x1(:,141),heltab2x4(:,:,225))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(50),wf4(:,10),G0tensor(126),m3h4x1(:,142),heltab2x4(:,:,226))
  call Hloop_VA_Q(ntryL,G0H8(12),wf8(:,38),G0H1(1),m3h8x1(:,33),heltab2x8(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(121),n2h1(243))
  call Hloop_ZA_Q(ntryL,G0H8(13),wf8(:,38),G0H1(1),ngZl,m3h8x1(:,34),heltab2x8(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(126),n2h1(244))
  call Hloop_WA_Q(ntryL,G0H8(14),wf8(:,38),G0H1(1),m3h8x1(:,35),heltab2x8(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(131),n2h1(245))
  call Hloop_VA_Q(ntryL,G0H8(19),wf8(:,40),G0H1(1),m3h8x1(:,36),heltab2x8(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(136),n2h1(246))
  call Hloop_ZA_Q(ntryL,G0H8(1),wf8(:,40),G0H1(1),ngZl,m3h8x1(:,37),heltab2x8(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(141),n2h1(247))
  call Hloop_WA_Q(ntryL,G0H8(2),wf8(:,40),G0H1(1),m3h8x1(:,38),heltab2x8(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(146),n2h1(248))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(29),wf8(:,42),G1tensor(151),m3h8x1(:,39),heltab2x8(:,:,155))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(10),wf8(:,42),G1tensor(156),ngZl,m3h8x1(:,40),heltab2x8(:,:,156))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(11),wf8(:,42),G1tensor(161),m3h8x1(:,41),heltab2x8(:,:,157))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(31),wf8(:,44),G1tensor(166),m3h8x1(:,42),heltab2x8(:,:,158))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(32),wf8(:,44),G1tensor(171),ngZl,m3h8x1(:,43),heltab2x8(:,:,159))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(33),wf8(:,44),G1tensor(176),m3h8x1(:,44),heltab2x8(:,:,160))
  call ol_merge_tensors(G2tensor(69),[G2tensor(68),G2tensor(38),G2tensor(35),G2tensor(32),G2tensor(29),G0tensor(26),G0tensor(1) &
    ,G0tensor(490),G0tensor(90),G0tensor(4),G0tensor(391),G0tensor(86),G0tensor(6)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(94),G2tensor(50),G2tensor(47),G2tensor(44),G2tensor(41),G0tensor(101),G0tensor(76) &
    ,G0tensor(3),G0tensor(162),G0tensor(484),G0tensor(442),G0tensor(11)])
  call ol_merge_tensors(G1tensor(63),[G1tensor(98),G1tensor(84),G1tensor(78),G1tensor(50),G1tensor(54),G1tensor(26),G1tensor(12) &
    ,G0tensor(55),G0tensor(12),G0tensor(43),G0tensor(267),G0tensor(66),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(535),[G0tensor(530),G0tensor(525),G0tensor(520),G0tensor(515),G0tensor(259),G0tensor(209) &
    ,G0tensor(208),G0tensor(115),G0tensor(277),G0tensor(333),G0tensor(235),G0tensor(42),G0tensor(30),G0tensor(422),G0tensor(65) &
    ,G0tensor(23),G0tensor(89),G0tensor(187),G0tensor(170),G0tensor(2),G0tensor(485),G0tensor(7),G0tensor(320),G0tensor(474) &
    ,G0tensor(193),G0tensor(75),G0tensor(435),G0tensor(396),G0tensor(281),G0tensor(211),G0tensor(121),G0tensor(96),G0tensor(71) &
    ,G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(523),[G0tensor(44),G0tensor(62),G0tensor(20),G0tensor(5),G0tensor(142),G0tensor(31)])
  call ol_merge_tensors(G0tensor(54),[G0tensor(206),G0tensor(36)])
  call ol_merge_tensors(G0tensor(527),[G0tensor(39),G0tensor(381),G0tensor(56)])
  call ol_merge_tensors(G0tensor(534),[G0tensor(27),G0tensor(479),G0tensor(61)])
  call ol_merge_tensors(G0tensor(518),[G0tensor(203),G0tensor(49),G0tensor(232),G0tensor(105),G0tensor(271),G0tensor(106) &
    ,G0tensor(81)])
  call ol_merge_tensors(G1tensor(116),[G1tensor(81),G0tensor(229),G0tensor(205),G0tensor(276),G0tensor(91)])
  call ol_merge_tensors(G1tensor(58),[G1tensor(34),G0tensor(214),G0tensor(392),G0tensor(480),G0tensor(111)])
  call ol_merge_tensors(G0tensor(585),[G0tensor(571),G0tensor(438),G0tensor(153),G0tensor(302),G0tensor(250),G0tensor(40) &
    ,G0tensor(230),G0tensor(104),G0tensor(18),G0tensor(45),G0tensor(452),G0tensor(455),G0tensor(481),G0tensor(436),G0tensor(366) &
    ,G0tensor(321),G0tensor(161),G0tensor(116)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(64),G2tensor(62),G2tensor(59),G2tensor(53),G0tensor(297),G0tensor(282) &
    ,G0tensor(417),G0tensor(456),G0tensor(416),G0tensor(341),G0tensor(301),G0tensor(266),G0tensor(241),G0tensor(221),G0tensor(196) &
    ,G0tensor(171),G0tensor(151),G0tensor(131)])
  call ol_merge_tensors(G0tensor(603),[G0tensor(561),G0tensor(552),G0tensor(538),G0tensor(444),G0tensor(420),G0tensor(399) &
    ,G0tensor(352),G0tensor(278),G0tensor(192),G0tensor(475),G0tensor(394),G0tensor(136)])
  call ol_merge_tensors(G1tensor(47),[G1tensor(8),G0tensor(548),G0tensor(143),G0tensor(107),G0tensor(215),G0tensor(460) &
    ,G0tensor(141)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(82),G2tensor(80),G2tensor(77),G2tensor(70),G0tensor(565),G0tensor(272) &
    ,G0tensor(245),G0tensor(52),G0tensor(338),G0tensor(240),G0tensor(47),G0tensor(427),G0tensor(37),G0tensor(24),G0tensor(210) &
    ,G0tensor(285),G0tensor(412),G0tensor(462),G0tensor(156)])
  call ol_merge_tensors(G0tensor(607),[G0tensor(573),G0tensor(365),G0tensor(298),G0tensor(279),G0tensor(60),G0tensor(176)])
  call ol_merge_tensors(G0tensor(227),[G0tensor(181)])
  call ol_merge_tensors(G0tensor(671),[G0tensor(662),G0tensor(657),G0tensor(652),G0tensor(647),G0tensor(638),G0tensor(629) &
    ,G0tensor(624),G0tensor(619),G0tensor(614),G0tensor(609),G0tensor(596),G0tensor(591),G0tensor(586),G0tensor(581),G0tensor(576) &
    ,G0tensor(559),G0tensor(554),G0tensor(549),G0tensor(544),G0tensor(510),G0tensor(505),G0tensor(500),G0tensor(495),G0tensor(488) &
    ,G0tensor(453),G0tensor(405),G0tensor(370),G0tensor(367),G0tensor(359),G0tensor(354),G0tensor(423),G0tensor(308),G0tensor(339) &
    ,G0tensor(293),G0tensor(382),G0tensor(239),G0tensor(372),G0tensor(169),G0tensor(177),G0tensor(154),G0tensor(127),G0tensor(258) &
    ,G0tensor(332),G0tensor(340),G0tensor(129),G0tensor(443),G0tensor(238),G0tensor(108),G0tensor(315),G0tensor(402),G0tensor(242) &
    ,G0tensor(79),G0tensor(343),G0tensor(222),G0tensor(295),G0tensor(433),G0tensor(486),G0tensor(461),G0tensor(371),G0tensor(346) &
    ,G0tensor(256),G0tensor(186)])
  call ol_merge_tensors(G0tensor(533),[G0tensor(323),G0tensor(17),G0tensor(150),G0tensor(201)])
  call ol_merge_tensors(G0tensor(645),[G0tensor(632),G0tensor(599),G0tensor(498),G0tensor(404),G0tensor(284),G0tensor(283) &
    ,G0tensor(469),G0tensor(342),G0tensor(140),G0tensor(94),G0tensor(290),G0tensor(33),G0tensor(300),G0tensor(414),G0tensor(465) &
    ,G0tensor(226)])
  call ol_merge_tensors(G1tensor(89),[G1tensor(69),G0tensor(666),G0tensor(656),G0tensor(642),G0tensor(347),G0tensor(118) &
    ,G0tensor(125),G0tensor(292),G0tensor(14),G0tensor(231)])
  call ol_merge_tensors(G0tensor(636),[G0tensor(508),G0tensor(468),G0tensor(448),G0tensor(158),G0tensor(248),G0tensor(335) &
    ,G0tensor(122),G0tensor(265),G0tensor(445),G0tensor(246)])
  call ol_merge_tensors(G1tensor(112),[G1tensor(75),G0tensor(459),G0tensor(132),G0tensor(243),G0tensor(312),G0tensor(200) &
    ,G0tensor(251)])
  call ol_merge_tensors(G0tensor(664),[G0tensor(424),G0tensor(299),G0tensor(224),G0tensor(172),G0tensor(388),G0tensor(307) &
    ,G0tensor(408),G0tensor(275),G0tensor(472),G0tensor(411),G0tensor(311),G0tensor(291)])
  call ol_merge_tensors(G0tensor(640),[G0tensor(611),G0tensor(598),G0tensor(589),G0tensor(570),G0tensor(566),G0tensor(562) &
    ,G0tensor(537),G0tensor(179),G0tensor(263),G0tensor(128),G0tensor(113),G0tensor(93),G0tensor(19),G0tensor(426),G0tensor(406) &
    ,G0tensor(296)])
  call ol_merge_tensors(G1tensor(136),[G1tensor(121),G0tensor(633),G0tensor(623),G0tensor(604),G0tensor(580),G0tensor(567) &
    ,G0tensor(430),G0tensor(329),G0tensor(195),G0tensor(316)])
  call ol_merge_tensors(G0tensor(492),[G0tensor(374),G0tensor(375),G0tensor(349),G0tensor(189),G0tensor(183),G0tensor(174) &
    ,G0tensor(356),G0tensor(331)])
  call ol_merge_tensors(G0tensor(649),[G0tensor(594),G0tensor(584),G0tensor(579),G0tensor(574),G0tensor(194),G0tensor(173) &
    ,G0tensor(163),G0tensor(149),G0tensor(57),G0tensor(336)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(126),G0tensor(595),G0tensor(590),G0tensor(504),G0tensor(418),G0tensor(397) &
    ,G0tensor(361)])
  call ol_merge_tensors(G0tensor(522),[G0tensor(217),G0tensor(32),G0tensor(489),G0tensor(386)])
  call ol_merge_tensors(G1tensor(166),[G1tensor(151),G0tensor(569),G0tensor(429),G0tensor(369),G0tensor(273),G0tensor(182) &
    ,G0tensor(431)])
  call ol_merge_tensors(G0tensor(626),[G0tensor(621),G0tensor(616),G0tensor(541),G0tensor(139),G0tensor(368),G0tensor(130) &
    ,G0tensor(471),G0tensor(446)])
  call ol_merge_tensors(G0tensor(668),[G0tensor(337),G0tensor(134),G0tensor(322),G0tensor(117),G0tensor(260),G0tensor(451)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(476)])
  call ol_merge_tensors(G0tensor(244),[G0tensor(198),G0tensor(483),G0tensor(353),G0tensor(180),G0tensor(155)])
  call ol_merge_tensors(G0tensor(512),[G0tensor(254),G0tensor(84),G0tensor(80),G0tensor(9)])
  call ol_merge_tensors(G1tensor(176),[G1tensor(161),G0tensor(519),G0tensor(234),G0tensor(10)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(28),G0tensor(558),G0tensor(553),G0tensor(178),G0tensor(378),G0tensor(447)])
  call ol_merge_tensors(G0tensor(513),[G0tensor(348),G0tensor(190),G0tensor(135),G0tensor(477)])
  call ol_merge_tensors(G0tensor(529),[G0tensor(197),G0tensor(22),G0tensor(73)])
  call ol_merge_tensors(G0tensor(557),[G0tensor(547),G0tensor(542),G0tensor(507),G0tensor(502),G0tensor(497),G0tensor(493) &
    ,G0tensor(255),G0tensor(185)])
  call ol_merge_tensors(G0tensor(28),[G0tensor(207)])
  call ol_merge_tensors(G0tensor(660),[G0tensor(655),G0tensor(617),G0tensor(385),G0tensor(360),G0tensor(357),G0tensor(318) &
    ,G0tensor(70),G0tensor(35)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(56),G0tensor(63)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(71),G0tensor(252)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(57),G0tensor(257)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(72),G0tensor(68)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(108),G0tensor(74)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(73),G0tensor(157)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(58),G0tensor(393)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(76),G0tensor(92)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(131),G0tensor(83)])
  call ol_merge_tensors(G0tensor(650),[G0tensor(641),G0tensor(314),G0tensor(334),G0tensor(303),G0tensor(269),G0tensor(112) &
    ,G0tensor(103),G0tensor(97),G0tensor(287),G0tensor(88)])
  call ol_merge_tensors(G0tensor(635),[G0tensor(631),G0tensor(575),G0tensor(563),G0tensor(543),G0tensor(539),G0tensor(428) &
    ,G0tensor(274),G0tensor(119),G0tensor(363),G0tensor(403)])
  call ol_merge_tensors(G0tensor(654),[G0tensor(546),G0tensor(377),G0tensor(110),G0tensor(100)])
  call ol_merge_tensors(G0tensor(644),[G0tensor(551),G0tensor(164),G0tensor(325),G0tensor(327)])
  call ol_merge_tensors(G0tensor(659),[G0tensor(556),G0tensor(387),G0tensor(137),G0tensor(124)])
  call ol_merge_tensors(G0tensor(669),[G0tensor(665),G0tensor(618),G0tensor(606),G0tensor(602),G0tensor(600),G0tensor(532) &
    ,G0tensor(528),G0tensor(524),G0tensor(503),G0tensor(437),G0tensor(415),G0tensor(464),G0tensor(249),G0tensor(188),G0tensor(159) &
    ,G0tensor(152),G0tensor(133),G0tensor(350)])
  call ol_merge_tensors(G0tensor(517),[G0tensor(514),G0tensor(494),G0tensor(463),G0tensor(432),G0tensor(419),G0tensor(410) &
    ,G0tensor(218),G0tensor(168),G0tensor(144),G0tensor(147)])
  call ol_merge_tensors(G0tensor(612),[G0tensor(578),G0tensor(449),G0tensor(294),G0tensor(313)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(156),G0tensor(583),G0tensor(478),G0tensor(379),G0tensor(344),G0tensor(289)])
  call ol_merge_tensors(G0tensor(622),[G0tensor(588),G0tensor(499),G0tensor(355),G0tensor(364)])
  call ol_merge_tensors(G0tensor(627),[G0tensor(593),G0tensor(509),G0tensor(389),G0tensor(390)])
  call ol_merge_tensors(G0tensor(637),[G0tensor(628),G0tensor(613),G0tensor(608)])
  call ol_merge_tensors(G0tensor(670),[G0tensor(661),G0tensor(651),G0tensor(646)])
  call ol_merge_tensors(G2tensor(67),[G0tensor(51)])
  call ol_merge_tensors(G2tensor(93),[G0tensor(126)])
call TI_bubble_red(G2tensor(69),28,mass2set(:,1),G0tensor(146),M2L1R1,G0tensor(166))
call TI_bubble_red(G2tensor(95),19,mass2set(:,1),G0tensor(191),M2L1R1,G0tensor(216))
call TI_bubble_red(G2tensor(66),28,mass2set(:,2),G0tensor(236),M2L1R1)
call TI_bubble_red(G2tensor(92),19,mass2set(:,2),G0tensor(261),M2L1R1)
call TI_bubble_red(G2tensor(60),28,mass2set(:,3),G0tensor(286),M2L1R1,G0tensor(306))
call TI_bubble_red(G2tensor(78),19,mass2set(:,3),G0tensor(326),M2L1R1,G0tensor(351))
call TI_bubble_red(G2tensor(61),28,mass2set(:,4),G0tensor(376),M2L1R1,G0tensor(401))
call TI_bubble_red(G2tensor(79),19,mass2set(:,4),G0tensor(421),M2L1R1,G0tensor(441))
call TI_bubble_red(G2tensor(63),28,mass2set(:,5),G0tensor(466),M2L1R1,G0tensor(175))
call TI_bubble_red(G2tensor(81),19,mass2set(:,5),G0tensor(440),M2L1R1,G0tensor(270))
call TI_bubble_red(G2tensor(65),28,mass2set(:,6),G0tensor(184),M2L1R1,G0tensor(85))
call TI_bubble_red(G2tensor(83),19,mass2set(:,6),G0tensor(358),M2L1R1,G0tensor(109))
call TI_bubble_red(G2tensor(67),28,mass2set(:,7),G0tensor(95),M2L1R1,G0tensor(102),G0tensor(470))
call TI_bubble_red(G2tensor(93),19,mass2set(:,8),G0tensor(98),M2L1R1,G0tensor(305),G0tensor(317))
  call ol_merge_tensors(G0tensor(535),[G0tensor(216),G0tensor(166)])
  call ol_merge_tensors(G0tensor(317),[G0tensor(102),G0tensor(671)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(351),G0tensor(306)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(441),G0tensor(401)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(270),G0tensor(175)])
  call ol_merge_tensors(G0tensor(82),[G0tensor(109),G0tensor(85)])
  call ol_merge_tensors(G0tensor(305),[G0tensor(470)])
call TI_bubble_red(G1tensor(63),16,mass2set(:,1),G0tensor(233),M2L1R1,G0tensor(373))
call TI_bubble_red(G1tensor(116),24,mass2set(:,9),G0tensor(114),M2L1R1,G0tensor(330))
call TI_bubble_red(G1tensor(58),20,mass2set(:,10),G0tensor(450),M2L1R1,G0tensor(123))
call TI_bubble_red(G1tensor(47),20,mass2set(:,2),G0tensor(253),M2L1R1)
call TI_bubble_red(G1tensor(89),24,mass2set(:,2),G0tensor(383),M2L1R1)
call TI_bubble_red(G1tensor(112),24,mass2set(:,11),G0tensor(345),M2L1R1,G0tensor(138))
call TI_bubble_red(G1tensor(136),17,mass2set(:,2),G0tensor(268),M2L1R1)
call TI_bubble_red(G1tensor(141),17,mass2set(:,12),G0tensor(148),M2L1R1,G0tensor(167))
call TI_bubble_red(G1tensor(166),18,mass2set(:,2),G0tensor(165),M2L1R1)
call TI_bubble_red(G1tensor(176),18,mass2set(:,9),G0tensor(434),M2L1R1,G0tensor(213))
call TI_bubble_red(G1tensor(39),20,mass2set(:,12),G0tensor(219),M2L1R1,G0tensor(223))
call TI_bubble_red(G1tensor(146),17,mass2set(:,10),G0tensor(199),M2L1R1,G0tensor(204))
call TI_bubble_red(G1tensor(171),18,mass2set(:,11),G0tensor(228),M2L1R1,G0tensor(457))
  call ol_merge_tensors(G0tensor(204),[G0tensor(213),G0tensor(123),G0tensor(330),G0tensor(373),G0tensor(535)])
  call ol_merge_tensors(G0tensor(457),[G0tensor(223),G0tensor(167),G0tensor(138),G0tensor(317)])
  call ol_merge_tensors(T0sum(241),[G0tensor(146)])
  call ol_merge_tensors(T0sum(242),[G0tensor(204)])
  call ol_merge_tensors(T0sum(243),[G0tensor(191)])
  call ol_merge_tensors(T0sum(244),[G0tensor(233)])
  call ol_merge_tensors(T0sum(245),[G0tensor(523)])
  call ol_merge_tensors(T0sum(246),[G0tensor(54)])
  call ol_merge_tensors(T0sum(247),[G0tensor(527)])
  call ol_merge_tensors(T0sum(248),[G0tensor(534)])
  call ol_merge_tensors(T0sum(249),[G0tensor(518)])
  call ol_merge_tensors(T0sum(250),[G0tensor(114)])
  call ol_merge_tensors(T0sum(251),[G0tensor(450)])
  call ol_merge_tensors(T0sum(252),[G0tensor(585)])
  call ol_merge_tensors(T0sum(253),[G0tensor(236)])
  call ol_merge_tensors(T0sum(254),[G0tensor(603)])
  call ol_merge_tensors(T0sum(255),[G0tensor(253)])
  call ol_merge_tensors(T0sum(256),[G0tensor(261)])
  call ol_merge_tensors(T0sum(257),[G0tensor(607)])
  call ol_merge_tensors(T0sum(258),[G0tensor(227)])
  call ol_merge_tensors(T0sum(259),[G0tensor(457)])
  call ol_merge_tensors(T0sum(260),[G0tensor(533)])
  call ol_merge_tensors(T0sum(261),[G0tensor(645)])
  call ol_merge_tensors(T0sum(262),[G0tensor(383)])
  call ol_merge_tensors(T0sum(263),[G0tensor(636)])
  call ol_merge_tensors(T0sum(264),[G0tensor(345)])
  call ol_merge_tensors(T0sum(265),[G0tensor(664)])
  call ol_merge_tensors(T0sum(266),[G0tensor(640)])
  call ol_merge_tensors(T0sum(267),[G0tensor(268)])
  call ol_merge_tensors(T0sum(268),[G0tensor(492)])
  call ol_merge_tensors(T0sum(269),[G0tensor(649)])
  call ol_merge_tensors(T0sum(270),[G0tensor(148)])
  call ol_merge_tensors(T0sum(271),[G0tensor(522)])
  call ol_merge_tensors(T0sum(272),[G0tensor(165)])
  call ol_merge_tensors(T0sum(273),[G0tensor(626)])
  call ol_merge_tensors(T0sum(274),[G0tensor(668)])
  call ol_merge_tensors(T0sum(275),[G0tensor(58)])
  call ol_merge_tensors(T0sum(276),[G0tensor(244)])
  call ol_merge_tensors(T0sum(277),[G0tensor(512)])
  call ol_merge_tensors(T0sum(278),[G0tensor(434)])
  call ol_merge_tensors(T0sum(279),[G0tensor(219)])
  call ol_merge_tensors(T0sum(280),[G0tensor(513)])
  call ol_merge_tensors(T0sum(281),[G0tensor(529)])
  call ol_merge_tensors(T0sum(282),[G0tensor(557)])
  call ol_merge_tensors(T0sum(283),[G0tensor(28)])
  call ol_merge_tensors(T0sum(284),[G0tensor(660)])
  call ol_merge_tensors(T0sum(285),[G0tensor(286)])
  call ol_merge_tensors(T0sum(286),[G0tensor(64)])
  call ol_merge_tensors(T0sum(287),[G0tensor(326)])
  call ol_merge_tensors(T0sum(288),[G0tensor(69)])
  call ol_merge_tensors(T0sum(289),[G0tensor(376)])
  call ol_merge_tensors(T0sum(290),[G0tensor(72)])
  call ol_merge_tensors(T0sum(291),[G0tensor(421)])
  call ol_merge_tensors(T0sum(292),[G0tensor(77)])
  call ol_merge_tensors(T0sum(293),[G0tensor(466)])
  call ol_merge_tensors(T0sum(294),[G0tensor(78)])
  call ol_merge_tensors(T0sum(295),[G0tensor(440)])
  call ol_merge_tensors(T0sum(296),[G0tensor(145)])
  call ol_merge_tensors(T0sum(297),[G0tensor(184)])
  call ol_merge_tensors(T0sum(298),[G0tensor(82)])
  call ol_merge_tensors(T0sum(299),[G0tensor(358)])
  call ol_merge_tensors(T0sum(300),[G0tensor(87)])
  call ol_merge_tensors(T0sum(301),[G0tensor(199)])
  call ol_merge_tensors(T0sum(302),[G0tensor(650)])
  call ol_merge_tensors(T0sum(303),[G0tensor(635)])
  call ol_merge_tensors(T0sum(304),[G0tensor(654)])
  call ol_merge_tensors(T0sum(305),[G0tensor(644)])
  call ol_merge_tensors(T0sum(306),[G0tensor(659)])
  call ol_merge_tensors(T0sum(307),[G0tensor(669)])
  call ol_merge_tensors(T0sum(308),[G0tensor(517)])
  call ol_merge_tensors(T0sum(309),[G0tensor(612)])
  call ol_merge_tensors(T0sum(310),[G0tensor(228)])
  call ol_merge_tensors(T0sum(311),[G0tensor(622)])
  call ol_merge_tensors(T0sum(312),[G0tensor(627)])
  call ol_merge_tensors(T0sum(313),[G0tensor(637)])
  call ol_merge_tensors(T0sum(314),[G0tensor(670)])
  call ol_merge_tensors(T0sum(315),[G0tensor(95)])
  call ol_merge_tensors(T0sum(316),[G0tensor(305)])
  call ol_merge_tensors(T0sum(317),[G0tensor(98)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 27 ],masses2_42,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 27 ],masses2_50,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 27 ],masses2_47,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_49,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 11 ],masses2_42,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 17, 19, 23 ],masses2_42,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_50,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 23 ],masses2_47,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 16, 17, 19 ],masses2_49,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 1, 3, 7 ],masses2_42,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 20, 21, 23 ],masses2_37,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 21, 23 ],masses2_37,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 23 ],masses2_37,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 16, 20, 21 ],masses2_37,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 4, 5, 7 ],masses2_37,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 20, 21, 23 ],masses2_40,RedSet_4(11),ScalarBoxes(16))
  call compute_scalar_box([ 16, 21, 23 ],masses2_40,RedSet_4(12),ScalarBoxes(17))
  call compute_scalar_box([ 16, 20, 23 ],masses2_40,RedSet_4(13),ScalarBoxes(18))
  call compute_scalar_box([ 4, 5, 7 ],masses2_40,RedSet_4(15),ScalarBoxes(19))
  call compute_scalar_box([ 20, 21, 23 ],masses2_51,RedSet_4(11),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 23 ],masses2_44,RedSet_4(13),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 21 ],masses2_44,RedSet_4(14),ScalarBoxes(22))
  call compute_scalar_box([ 4, 5, 7 ],masses2_51,RedSet_4(15),ScalarBoxes(23))
  call compute_scalar_box([ 20, 21, 23 ],masses2_52,RedSet_4(11),ScalarBoxes(24))
  call compute_scalar_box([ 16, 20, 23 ],masses2_46,RedSet_4(13),ScalarBoxes(25))
  call compute_scalar_box([ 4, 5, 7 ],masses2_52,RedSet_4(15),ScalarBoxes(26))
  call compute_scalar_box([ 20, 22, 23 ],masses2_37,RedSet_4(16),ScalarBoxes(27))
  call compute_scalar_box([ 16, 22, 23 ],masses2_37,RedSet_4(17),ScalarBoxes(28))
  call compute_scalar_box([ 16, 20, 22 ],masses2_37,RedSet_4(18),ScalarBoxes(29))
  call compute_scalar_box([ 4, 6, 7 ],masses2_37,RedSet_4(19),ScalarBoxes(30))
  call compute_scalar_box([ 20, 22, 23 ],masses2_51,RedSet_4(16),ScalarBoxes(31))
  call compute_scalar_box([ 16, 20, 22 ],masses2_44,RedSet_4(18),ScalarBoxes(32))
  call compute_scalar_box([ 4, 6, 7 ],masses2_51,RedSet_4(19),ScalarBoxes(33))
  call compute_scalar_box([ 20, 22, 23 ],masses2_40,RedSet_4(16),ScalarBoxes(34))
  call compute_scalar_box([ 16, 22, 23 ],masses2_40,RedSet_4(17),ScalarBoxes(35))
  call compute_scalar_box([ 4, 6, 7 ],masses2_40,RedSet_4(19),ScalarBoxes(36))
  call compute_scalar_box([ 20, 22, 23 ],masses2_52,RedSet_4(16),ScalarBoxes(37))
  call compute_scalar_box([ 4, 6, 7 ],masses2_52,RedSet_4(19),ScalarBoxes(38))
  call compute_scalar_box([ 20, 22, 23 ],masses2_48,RedSet_4(16),ScalarBoxes(39))
  call compute_scalar_box([ 16, 22, 23 ],masses2_39,RedSet_4(17),ScalarBoxes(40))
  call compute_scalar_box([ 16, 20, 23 ],masses2_43,RedSet_4(13),ScalarBoxes(41))
  call compute_scalar_box([ 16, 20, 22 ],masses2_41,RedSet_4(18),ScalarBoxes(42))
  call compute_scalar_box([ 4, 6, 7 ],masses2_48,RedSet_4(19),ScalarBoxes(43))
  call compute_scalar_box([ 17, 21, 29 ],masses2_37,RedSet_4(20),ScalarBoxes(44))
  call compute_scalar_box([ 16, 21, 29 ],masses2_37,RedSet_4(21),ScalarBoxes(45))
  call compute_scalar_box([ 16, 17, 29 ],masses2_37,RedSet_4(22),ScalarBoxes(46))
  call compute_scalar_box([ 16, 17, 21 ],masses2_37,RedSet_4(23),ScalarBoxes(47))
  call compute_scalar_box([ 1, 5, 13 ],masses2_37,RedSet_4(24),ScalarBoxes(48))
  call compute_scalar_box([ 17, 21, 29 ],masses2_40,RedSet_4(20),ScalarBoxes(49))
  call compute_scalar_box([ 16, 21, 29 ],masses2_40,RedSet_4(21),ScalarBoxes(50))
  call compute_scalar_box([ 16, 17, 29 ],masses2_40,RedSet_4(22),ScalarBoxes(51))
  call compute_scalar_box([ 1, 5, 13 ],masses2_40,RedSet_4(24),ScalarBoxes(52))
  call compute_scalar_box([ 17, 21, 29 ],masses2_51,RedSet_4(20),ScalarBoxes(53))
  call compute_scalar_box([ 16, 17, 29 ],masses2_44,RedSet_4(22),ScalarBoxes(54))
  call compute_scalar_box([ 16, 17, 21 ],masses2_44,RedSet_4(23),ScalarBoxes(55))
  call compute_scalar_box([ 1, 5, 13 ],masses2_51,RedSet_4(24),ScalarBoxes(56))
  call compute_scalar_box([ 17, 21, 29 ],masses2_52,RedSet_4(20),ScalarBoxes(57))
  call compute_scalar_box([ 16, 17, 29 ],masses2_46,RedSet_4(22),ScalarBoxes(58))
  call compute_scalar_box([ 1, 5, 13 ],masses2_52,RedSet_4(24),ScalarBoxes(59))
  call compute_scalar_box([ 17, 25, 29 ],masses2_37,RedSet_4(25),ScalarBoxes(60))
  call compute_scalar_box([ 16, 25, 29 ],masses2_37,RedSet_4(26),ScalarBoxes(61))
  call compute_scalar_box([ 16, 17, 25 ],masses2_37,RedSet_4(27),ScalarBoxes(62))
  call compute_scalar_box([ 1, 9, 13 ],masses2_37,RedSet_4(28),ScalarBoxes(63))
  call compute_scalar_box([ 17, 25, 29 ],masses2_40,RedSet_4(25),ScalarBoxes(64))
  call compute_scalar_box([ 16, 25, 29 ],masses2_40,RedSet_4(26),ScalarBoxes(65))
  call compute_scalar_box([ 1, 9, 13 ],masses2_40,RedSet_4(28),ScalarBoxes(66))
  call compute_scalar_box([ 17, 25, 29 ],masses2_51,RedSet_4(25),ScalarBoxes(67))
  call compute_scalar_box([ 16, 17, 25 ],masses2_44,RedSet_4(27),ScalarBoxes(68))
  call compute_scalar_box([ 1, 9, 13 ],masses2_51,RedSet_4(28),ScalarBoxes(69))
  call compute_scalar_box([ 17, 25, 29 ],masses2_52,RedSet_4(25),ScalarBoxes(70))
  call compute_scalar_box([ 1, 9, 13 ],masses2_52,RedSet_4(28),ScalarBoxes(71))
! end of process


end subroutine vamp_3

end module ol_vamp_3_pplla_ew_eexddxa_1_/**/REALKIND
