
module ol_vamp_1_pplla_ew_nenexddxa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplla_ew_nenexddxa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplla_ew_nenexddxa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplla_ew_nenexddxa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplla_ew_nenexddxa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplla_ew_nenexddxa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplla_ew_nenexddxa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(6)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,nMW,0,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,2,1,4,8],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,2,1,8],[0,nMZ,0,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(3))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,1,2,8,4],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,1,4,8,2],[0,nMW,0,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(6),n2h16(4))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex3(:),G1H8(1),ngZd,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_W(ntryL,G1H16(2),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_WA_Q(ntryL,G1H16(3),ex2(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(3),18,0,G2H8(1),n2h8(1))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex3(:),G1H8(3),ngZd,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_WQ_A(ntryL,G1H16(5),ex1(:),G1H8(4),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(4),17,0,G2H8(2),n2h8(2))
  call Hloop_AQ_W(ntryL,G1H16(6),ex1(:),G1H8(4),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(2),n2h4(2))
  call Hloop_AQ_W(ntryL,G2H8(1),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_ZA_Q(ntryL,G1H8(3),ex2(:),G1H4(1),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(4),n2h4(3))
  call Hloop_QA_W(ntryL,G2H8(2),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_WQ_A(ntryL,G1H8(4),ex3(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(6),n2h4(4))
  call Hloop_QA_Z(ntryL,G2H4(1),ex2(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_W(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_AQ_Z(ntryL,G2H4(4),ex1(:),G2H2(3),ngZn,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_QA_W(ntryL,G2H4(6),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_WQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(5),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_WQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(2),23,0,G2H2(6),n2h2(2))
  call Hloop_WQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(2),23,0,G2H2(7),n2h2(3))
  call Hloop_WA_Q(ntryL,G1H4(7),ex4(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(2),27,0,G2H2(8),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_WA_Q(ntryL,G1H4(11),ex4(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(9),n2h2(5))
  call Hloop_WA_Q(ntryL,G1H4(12),ex4(:),G1H2(3),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(10),n2h2(6))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(3),G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(4),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(3),mass5set(:,3),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(4),mass5set(:,2),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,3),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),2,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_ZA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(1))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(2))
  call Hloop_ZA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),ngZd,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(9),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(6))
  call Hloop_ZA_Q(ntryL,G1H2(15),ex4(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(7))
  call Hloop_ZA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(8))
  call Hloop_ZA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_WA_Q(ntryL,G1H2(21),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(10))
  call Hloop_WA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(15),n2h1(11))
  call Hloop_WA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(3),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(4),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(5),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(1),n2h16(5))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,3,8,4],[0,0,nMZ,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(2),n2h16(6))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,3,8,4],[0,0,nMW,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(7))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(4),n2h16(8))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(6),n2h16(9))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,3,4,8],[0,0,nMZ,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(7),n2h16(10))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,3,4,8],[0,0,nMW,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(8),n2h16(11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(9),n2h16(12))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,3,8],[0,nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(11),n2h16(13))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,3,8],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,1,2,12],[0,nMW,0,0],4,1,wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(13),n2h16(14))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,1,2,12],[0,nMW,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(14),n2h16(15))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,27))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,23),heltab2x32(:,:,23))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,24),heltab2x32(:,:,24))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,25),heltab2x32(:,:,25))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,26),heltab2x32(:,:,26))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,12],[0,nMW,0,0],4,1,wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(17),n2h16(16))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,12],[0,nMW,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(18),n2h16(17))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,27))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,27))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,12,2],[0,nMW,nMW,0],4,1,wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(21),n2h16(18))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,12,2],[0,nMW,nMW,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(22),n2h16(19))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,36),heltab2x32(:,:,36))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[20,2,1,8],[nMZ,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[20,1,2,8],[nMZ,0,nMZ,0],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngZd,m3h4x8(:,2),heltab2x32(:,:,38))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[20,1,2,8],[nMW,0,nMW,0],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,39))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[24,2,1,4],[nMZ,0,nMZ,0],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,5),G0H8(4),ngZd,m3h4x8(:,4),heltab2x32(:,:,40))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[24,2,1,4],[nMW,0,nMW,0],4,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,5),G0H8(5),m3h4x8(:,5),heltab2x32(:,:,41))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[24,1,2,4],[nMZ,0,nMZ,0],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,5),G0H8(6),ngZd,m3h4x8(:,6),heltab2x32(:,:,42))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(6)])
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(1),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,1),G1H4(2),ngZd,m3h4x4(:,2),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(2),19,0,G2H4(2),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,1),G1H4(5),ngZu,m3h4x4(:,3),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(5),19,0,G2H4(3),n2h4(9))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,1),G0H4(1),m3h4x4(:,4),heltab2x16(:,:,10))
  call Hloop_UV_W(ntryL,G1H16(5),16,wf4(:,1),3,G2H4(4),m3h4x4(:,5),heltab2x16(:,:,11))
  call Hloop_AZ_Q(ntryL,G1H16(9),wf4(:,1),G1H4(6),ngZd,m3h4x4(:,6),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(6),19,0,G2H4(5),n2h4(10))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,1),G1H4(7),ngZd,m3h4x4(:,7),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(6),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,1),G1H4(8),ngZu,m3h4x4(:,8),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(8),19,0,G2H4(7),n2h4(12))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,1),G0H4(2),m3h4x4(:,9),heltab2x16(:,:,15))
  call Hloop_UW_V(ntryL,G1H16(10),16,wf4(:,1),3,G2H4(8),m3h4x4(:,10),heltab2x16(:,:,16))
  call Hloop_AQ_W(ntryL,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,17))
  call Hloop_WQ_A(ntryL,G1H16(12),ex3(:),G1H8(2),m3h2x8(:,8),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(2),20,0,G2H8(1),n2h8(3))
  call Hloop_AQ_W(ntryL,G1H16(13),ex1(:),G1H8(3),m3h2x8(:,9),heltab2x16(:,:,19))
  call Hloop_AQ_W(ntryL,G1H16(14),ex1(:),G1H8(4),m3h2x8(:,10),heltab2x16(:,:,20))
  call Hloop_WQ_A(ntryL,G0H16(3),ex1(:),G0H8(7),m3h2x8(:,11),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(2),n2h8(4))
  call Hloop_WQ_A(ntryL,G0H16(4),ex1(:),G0H8(7),m3h2x8(:,12),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(5),n2h8(5))
  call Hloop_WQ_A(ntryL,G1H16(15),ex1(:),G1H8(6),m3h2x8(:,13),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(6),17,0,G2H8(2),n2h8(6))
  call Hloop_WQ_A(ntryL,G1H16(16),ex1(:),G1H8(6),m3h2x8(:,14),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(6),17,0,G2H8(3),n2h8(7))
  call Hloop_QA_W(ntryL,G1H16(17),ex2(:),G1H8(6),m3h2x8(:,15),heltab2x16(:,:,25))
  call Hloop_QA_W(ntryL,G1H16(18),ex2(:),G1H8(7),m3h2x8(:,16),heltab2x16(:,:,26))
  call Hloop_WA_Q(ntryL,G0H16(5),ex2(:),G0H8(7),m3h2x8(:,17),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(7),18,0,G1H8(8),n2h8(8))
  call Hloop_WA_Q(ntryL,G0H16(6),ex2(:),G0H8(7),m3h2x8(:,18),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(7),18,0,G1H8(9),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(19),ex2(:),G1H8(10),m3h2x8(:,19),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(10),18,0,G2H8(4),n2h8(10))
  call Hloop_WA_Q(ntryL,G1H16(20),ex2(:),G1H8(10),m3h2x8(:,20),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(10),18,0,G2H8(5),n2h8(11))
  call Hloop_AQ_W(ntryL,G1H16(21),ex1(:),G1H8(10),m3h2x8(:,21),heltab2x16(:,:,31))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(11),m3h2x8(:,22),heltab2x16(:,:,32))
  call Hloop_WQ_A(ntryL,G1H16(23),ex1(:),G1H8(12),m3h2x8(:,23),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(12),17,0,G2H8(6),n2h8(12))
  call Hloop_WQ_A(ntryL,G1H16(24),ex1(:),G1H8(12),m3h2x8(:,24),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(12),17,0,G2H8(7),n2h8(13))
  call Hloop_ZA_Q(ntryL,G0H8(1),ex2(:),G0H4(3),ngZn,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(3),22,0,G1H4(11),n2h4(13))
  call Hloop_ZQ_A(ntryL,G0H8(2),ex1(:),G0H4(3),ngZn,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G0H4(3),21,0,G1H4(12),n2h4(14))
  call Hloop_WQ_A(ntryL,G0H8(3),ex1(:),G0H4(3),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(3),21,0,G1H4(1),n2h4(15))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(3),ngZn,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(3),26,0,G1H4(2),n2h4(16))
  call Hloop_WA_Q(ntryL,G0H8(5),ex2(:),G0H4(3),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(3),26,0,G1H4(5),n2h4(17))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex1(:),G0H4(3),ngZn,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(3),25,0,G1H4(6),n2h4(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(4),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(10),G0H4(1)])
  call Hloop_WQ_A(ntryL,G1H4(3),ex3(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(1),n2h2(7))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(2),mass4set(:,1),  & 
G1H4(7),G1H4(8),G1H4(4),G1H4(10),G1H4(3),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hloop_WA_Q(ntryL,G1H4(9),ex4(:),G1H2(4),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(4),27,0,G2H2(2),n2h2(8))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(7),mass4set(:,1),  & 
G1H4(9),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(13),4,4)
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(3),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(2),ex4(:),G2H2(4),ngZd,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_W(ntryL,G2H4(3),ex4(:),G2H2(5),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_V(ntryL,G2H4(5),ex3(:),G2H2(7),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_Z(ntryL,G2H4(6),ex3(:),G2H2(8),ngZd,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_W(ntryL,G2H4(7),ex3(:),G2H2(10),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_UV_W(ntryL,G1H8(1),20,wf4(:,1),3,G2H2(11),m3h4x2(:,1),heltab2x8(:,:,13))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(13),mass4set(:,2),  & 
G1H8(12),G1H8(1),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(17),m3h2x4(:,13),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(17),19,0,G2H4(8),n2h4(19))
  call Hloop_WA_Q(ntryL,G1H8(4),ex2(:),G1H4(17),m3h2x4(:,14),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(17),19,0,G2H4(4),n2h4(20))
  call Hloop_QA_W(ntryL,G1H8(2),ex2(:),G1H4(17),m3h2x4(:,15),heltab2x8(:,:,16))
  call Hloop_QA_W(ntryL,G1H8(5),ex2(:),G1H4(18),m3h2x4(:,16),heltab2x8(:,:,17))
  call Hloop_QA_W(ntryL,G2H8(2),ex2(:),G2H4(1),m3h2x4(:,17),heltab2x8(:,:,18))
  call Hloop_QA_W(ntryL,G2H8(3),ex2(:),G2H4(2),m3h2x4(:,18),heltab2x8(:,:,19))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(19),m3h2x4(:,19),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(19),19,0,G2H4(3),n2h4(21))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(19),m3h2x4(:,20),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(19),19,0,G2H4(5),n2h4(22))
  call Hloop_AQ_W(ntryL,G1H8(8),ex1(:),G1H4(19),m3h2x4(:,21),heltab2x8(:,:,22))
  call Hloop_AQ_W(ntryL,G1H8(9),ex1(:),G1H4(20),m3h2x4(:,22),heltab2x8(:,:,23))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(6),m3h2x4(:,23),heltab2x8(:,:,24))
  call Hloop_AQ_W(ntryL,G2H8(5),ex1(:),G2H4(7),m3h2x4(:,24),heltab2x8(:,:,25))
  call Hloop_UW_V(ntryL,G1H8(10),17,wf4(:,27),12,G2H2(12),m3h4x2(:,2),heltab2x8(:,:,26))
  call Hloop_UW_V(ntryL,G1H8(11),17,wf4(:,14),12,G2H2(13),m3h4x2(:,3),heltab2x8(:,:,27))
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(22),mass4set(:,2),  & 
G1H8(3),G1H8(4),G1H8(2),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(4),2,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(22),mass4set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(8),2,8)
  call Hloop_AQ_Z(ntryL,G1H4(11),ex1(:),G1H2(8),ngZn,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_Z(ntryL,G1H4(12),ex2(:),G1H2(9),ngZn,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_W(ntryL,G1H4(1),ex2(:),G1H2(10),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex1(:),G1H2(14),ngZn,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_W(ntryL,G1H4(5),ex1(:),G1H2(15),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_Z(ntryL,G1H4(6),ex2(:),G1H2(16),ngZn,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_WQ_A(ntryL,G1H4(7),ex3(:),G1H2(20),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(20),23,0,G2H2(14),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(8),ex4(:),G1H2(21),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_WQ_A(ntryL,G1H4(10),ex3(:),G1H2(22),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(22),23,0,G2H2(15),n2h2(10))
  call Hloop_WQ_A(ntryL,G1H4(3),ex3(:),G1H2(26),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(16),n2h2(11))
  call Hloop_WA_Q(ntryL,G1H4(9),ex4(:),G1H2(3),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(17),n2h2(12))
call HGT_raise_alpha_OLR(G1H4(13),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(13),ex3(:),G1H2(4),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_WA_Q(ntryL,G1H4(15),ex4(:),G1H2(20),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(20),27,0,G2H2(18),n2h2(13))
  call Hloop_WA_Q(ntryL,G1H4(16),ex4(:),G1H2(22),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(22),27,0,G2H2(19),n2h2(14))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,1),G1H2(26),ngZu,m3h4x2(:,4),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(20),n2h2(15))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(1),ex4(:),G1H4(11),m3h2x4(:,25),heltab2x8(:,:,29))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,1),G1H2(3),ngZu,m3h4x2(:,5),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(21),n2h2(16))
  call Hloop_QZ_A(ntryL,G1H8(15),wf4(:,1),G1H2(20),ngZu,m3h4x2(:,6),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(20),23,0,G2H2(22),n2h2(17))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,27),G1H2(22),m3h4x2(:,7),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(23),n2h2(18))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(4),ex2(:),G1H4(12),m3h2x4(:,26),heltab2x8(:,:,33))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,27),G1H2(26),m3h4x2(:,8),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(26),29,0,G2H2(24),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,27),G1H2(3),m3h4x2(:,9),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(3),29,0,G2H2(25),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,14),G1H2(20),ngZl,m3h4x2(:,10),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(26),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,37))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,14),G1H2(22),ngZl,m3h4x2(:,11),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(27),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,14),G1H2(26),ngZl,m3h4x2(:,12),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(26),29,0,G2H2(28),n2h2(23))
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(11)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(12),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(25)])
  call Hloop_WQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(13))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(3),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hloop_WA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(14))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(8),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hloop_ZA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),ngZd,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(15))
  call Hloop_ZA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngZd,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(16))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),ngZd,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(17))
  call Hloop_WA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(18))
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(13),mass4set(:,3),  & 
G1H2(3),G1H2(20),G1H2(22),G1H2(26),G1H2(15),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),ngZd,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(20))
  call Hloop_WA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(21))
  call Hloop_WA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(22))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(22),mass4set(:,3),  & 
G1H2(11),G1H2(10),G1H2(5),G1H2(7),G1H2(13),2)
  call HG1shiftOLR(G1H2(10),2,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(23),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(24),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(7),mass4set(:,4),  & 
G1H2(17),G1H2(25),G1H2(1),G1H2(2),G1H2(9),2)
  call HG1shiftOLR(G1H2(25),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(7),mass4set(:,5),  & 
G1H2(6),G1H2(19),G1H2(12),G1H2(8),G1H2(18),2)
  call HG1shiftOLR(G1H2(19),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,6),  & 
G1H2(23),G1H2(24),G1H2(27),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(2),mass4set(:,4),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(31),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(2),mass4set(:,5),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(2),mass4set(:,6),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),8,2)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(9),mass4set(:,7),  & 
G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(5),12,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(9),mass4set(:,7),  & 
G1H4(10),G1H4(3),G1H4(9),G1H4(13),G1H4(15),4)
  call HG1shiftOLR(G1H4(3),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(17),wf4(:,27),G1tensor(1),m3h4x1(:,1),heltab2x4(:,:,35))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(18),wf4(:,14),G1tensor(7),m3h4x1(:,2),heltab2x4(:,:,36))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(9),mass4set(:,8),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(17),12,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(9),mass4set(:,8),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),4)
  call HG1shiftOLR(G1H4(24),12,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(4),mass4set(:,7),  & 
G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(29),12,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(4),mass4set(:,7),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),4)
  call HG1shiftOLR(G1H4(34),12,4)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(19),wf4(:,27),G1tensor(13),m3h4x1(:,3),heltab2x4(:,:,37))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(20),wf4(:,14),G1tensor(19),m3h4x1(:,4),heltab2x4(:,:,38))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(4),mass4set(:,8),  & 
G1H4(19),G1H4(20),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(20),12,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(4),mass4set(:,8),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(42),12,4)
  call Hloop_ZQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(23))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(24))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(27),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(28),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(29),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(30),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(31),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(32),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(33),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(34),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hloop_WA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(26))
  call Hloop_WA_Q(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(27))
  call Hloop_WA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(28))
  call Hloop_WA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(39),n2h1(29))
  call Hloop_WA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(31))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(42),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),ngZd,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(45),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),ngZd,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(36))
  call Hloop_WQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(37))
  call Hloop_WQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(48),n2h1(38))
  call Hloop_WQ_A(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(51),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(42))
  call Hloop_ZA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),ngZd,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(43))
  call Hloop_ZA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(54),n2h1(44))
  call Hloop_ZA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),ngZd,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(45))
  call Hloop_WA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(46))
  call Hloop_WA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(57),n2h1(47))
  call Hloop_WA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(58),n2h1(48))
  call Hloop_AV_Q(ntryL,G1H4(2),wf4(:,27),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(49))
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,27),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(60),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,27),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(51))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,8),heltab2x4(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(52))
  call Hloop_AZ_Q(ntryL,G1H4(3),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,9),heltab2x4(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(63),n2h1(53))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,10),heltab2x4(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(54))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(16),19,wf4(:,27),12,G2tensor(65),m3h4x1(:,11),heltab2x4(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(17),0,wf4(:,27),12,G2tensor(66),m3h4x1(:,12),heltab2x4(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(22),19,wf4(:,27),12,G2tensor(67),m3h4x1(:,13),heltab2x4(:,:,47))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(23),19,wf4(:,14),12,G2tensor(68),m3h4x1(:,14),heltab2x4(:,:,48))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(24),0,wf4(:,14),12,G2tensor(69),m3h4x1(:,15),heltab2x4(:,:,49))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(27),19,wf4(:,14),12,G2tensor(70),m3h4x1(:,16),heltab2x4(:,:,50))
  call Hloop_QV_A(ntryL,G1H4(28),wf4(:,27),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(57))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,27),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(72),n2h1(58))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,27),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H4(33),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,20),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(74),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H4(34),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,21),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(75),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,22),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(62))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(19),19,wf4(:,27),12,G2tensor(77),m3h4x1(:,23),heltab2x4(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(20),0,wf4(:,27),12,G2tensor(78),m3h4x1(:,24),heltab2x4(:,:,58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(40),19,wf4(:,27),12,G2tensor(79),m3h4x1(:,25),heltab2x4(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(41),19,wf4(:,14),12,G2tensor(80),m3h4x1(:,26),heltab2x4(:,:,60))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(42),0,wf4(:,14),12,G2tensor(81),m3h4x1(:,27),heltab2x4(:,:,61))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(45),19,wf4(:,14),12,G2tensor(82),m3h4x1(:,28),heltab2x4(:,:,62))
  call ol_merge_tensors(G2tensor(80),[G2tensor(77),G2tensor(2),G1tensor(19),G1tensor(13),G1tensor(6)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(65),G2tensor(4),G1tensor(7),G1tensor(1),G1tensor(12)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(15),G1tensor(32),G1tensor(3)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(21),G1tensor(8)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(29),G1tensor(17)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(59)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(71)])
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(4),mass4set(:,8),  & 
G1tensor(25),G1tensor(31),G1tensor(19),G1tensor(13),G1tensor(6))
  call G_TensorShift(G1tensor(31),12)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(9),mass4set(:,8),  & 
G1tensor(7),G1tensor(1),G1tensor(12),G1tensor(14),G1tensor(18))
  call G_TensorShift(G1tensor(1),12)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(25),mass4set(:,9),  & 
G1tensor(20),G1tensor(24),G1tensor(26),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(24),2)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(14),mass4set(:,10),  & 
G1tensor(3),G1tensor(36),G1tensor(2),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(36),10)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(25),mass4set(:,11),  & 
G1tensor(21),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(14),mass4set(:,7),  & 
G1tensor(15),G1tensor(16),G1tensor(29),G1tensor(17),G1tensor(22))
  call G_TensorShift(G1tensor(16),10)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(26),mass4set(:,9),  & 
G1tensor(23),G1tensor(27),G1tensor(28),G1tensor(33),G1tensor(34))
  call G_TensorShift(G1tensor(27),1)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(18),mass4set(:,10),  & 
G1tensor(35),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),9)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(1),mass4set(:,11),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(23),mass4set(:,7),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),10)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(27),mass4set(:,12),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(2),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(11),mass4set(:,12),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(6),mass4set(:,11),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(7),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(8),mass4set(:,2),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(11),mass4set(:,13),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(12),mass4set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(13),mass4set(:,14),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),8)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(12),mass4set(:,6),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),8)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(13),mass4set(:,3),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(16),mass4set(:,13),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(17),mass4set(:,5),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(20),mass4set(:,12),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(21),mass4set(:,6),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(22),mass4set(:,3),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),2)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(27),mass4set(:,13),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),4)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(28),mass4set(:,13),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),4)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(13),mass4set(:,2),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(22),mass4set(:,2),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(7),mass4set(:,4),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),4)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(7),mass4set(:,5),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),4)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(7),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),4)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(2),mass4set(:,4),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),8)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(2),mass4set(:,5),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),8)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(2),mass4set(:,6),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(9),mass4set(:,7),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),12)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(4),mass4set(:,7),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),12)
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(4),mass4set(:,8),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(7),RedSet_4(9),mass4set(:,8),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(25),mass4set(:,9),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(14),mass4set(:,10),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(25),mass4set(:,11),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(14),mass4set(:,7),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(26),mass4set(:,9),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(18),mass4set(:,10),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,11),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(23),mass4set(:,7),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(27),mass4set(:,12),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(2),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,2),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(11),mass4set(:,12),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(6),mass4set(:,11),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(7),mass4set(:,1),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(8),mass4set(:,2),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(11),mass4set(:,13),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(12),mass4set(:,5),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(13),mass4set(:,14),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(12),mass4set(:,6),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(13),mass4set(:,3),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(16),mass4set(:,13),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(17),mass4set(:,5),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(20),mass4set(:,12),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(21),mass4set(:,6),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(22),mass4set(:,3),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(27),mass4set(:,13),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(28),mass4set(:,13),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(13),mass4set(:,2),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(22),mass4set(:,2),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(7),mass4set(:,4),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(7),mass4set(:,5),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(7),mass4set(:,6),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(2),mass4set(:,4),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(2),mass4set(:,5),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(2),mass4set(:,6),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(9),mass4set(:,7),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(4),mass4set(:,7),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[19,4,8],[nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[28,1,2],[nMW,0,nMW],4,1,wf4(:,27))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,27),G0H4(2),m4h2x4x4(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[28,1,2],[nMW,0,nMW],4,1,wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(1),m4h2x4x4(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,37),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(1),n2h16(20))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(6),n2h16(21))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,39),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(2),16,nML,G1H16(4),n2h16(22))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,40),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(2),n2h16(23))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,41),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMM,G1H16(3),n2h16(24))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,42),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(5),16,nML,G1H16(5),n2h16(25))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,43),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(6),16,0,G1H16(9),n2h16(26))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,44),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMT,G1H16(7),n2h16(27))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(28))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,46),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(10),n2h16(29))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,47),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(11),n2h16(30))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,27))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,48),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(12),n2h16(31))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,49),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(13),n2h16(32))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,27))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,50),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMB,G1H16(14),n2h16(33))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,51),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(15),n2h16(34))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMM,G1H16(16),n2h16(35))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,53),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(2),16,nML,G1H16(17),n2h16(36))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,54),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(18),n2h16(37))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,55),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMM,G1H16(19),n2h16(38))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,56),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(5),16,nML,G1H16(20),n2h16(39))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,57),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(6),16,0,G1H16(21),n2h16(40))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,58),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMT,G1H16(22),n2h16(41))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(23),n2h16(42))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,60),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(24),n2h16(43))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,61),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(25),n2h16(44))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,62),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(26),n2h16(45))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,63),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(27),n2h16(46))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,64),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMB,G1H16(28),n2h16(47))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,65),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,66),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,67),heltab2x32(:,:,73))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,68),heltab2x32(:,:,74))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(33),m3h2x16(:,69),heltab2x32(:,:,75))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,70),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(35),m3h2x16(:,71),heltab2x32(:,:,77))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,72),heltab2x32(:,:,78))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(37),m3h2x16(:,73),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,74),heltab2x32(:,:,80))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(39),m3h2x16(:,75),heltab2x32(:,:,81))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,76),heltab2x32(:,:,82))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,77),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,78),heltab2x32(:,:,84))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,79),heltab2x32(:,:,85))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,80),heltab2x32(:,:,86))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,81),heltab2x32(:,:,87))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,82),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,83),heltab2x32(:,:,89))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,84),heltab2x32(:,:,90))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,85),heltab2x32(:,:,91))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,92))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,87),heltab2x32(:,:,93))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,88),heltab2x32(:,:,94))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,89),heltab2x32(:,:,95))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,90),heltab2x32(:,:,96))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,91),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,92),heltab2x32(:,:,98))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,93),heltab2x32(:,:,99))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,94),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,95),heltab2x32(:,:,101))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,96),heltab2x32(:,:,102))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,97),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,98),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,99),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,100),heltab2x32(:,:,106))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,101),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,102),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,103),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,104),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,7),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G0H8(7),20,0,G1H8(12),n2h8(17))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[20,3,8],[0,0,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZd,m3h4x8(:,8),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(1),n2h8(18))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[20,3,8],[0,0,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,9),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H8(2),20,0,G1H8(14),n2h8(19))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,10),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(3),20,0,G1H8(15),n2h8(20))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[20,3,8],[nMW,nMW,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,11),heltab2x32(:,:,115))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(5),m3h4x8(:,12),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H8(5),24,0,G1H8(3),n2h8(21))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[24,3,4],[0,0,nMZ],3,2,wf4(:,5),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(6),ngZd,m3h4x8(:,13),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(6),24,0,G1H8(4),n2h8(22))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[24,3,4],[0,0,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(7),m3h4x8(:,14),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H8(7),24,0,G1H8(5),n2h8(23))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(1),m3h4x8(:,15),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H8(1),24,0,G1H8(6),n2h8(24))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[24,3,4],[nMW,nMW,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,16),heltab2x32(:,:,120))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,7,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,105),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(53),n2h16(48))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,7,8],[0,nMZ,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,106),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(54),n2h16(49))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,7,8],[0,nMW,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,107),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(55),n2h16(50))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,7,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,108),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(56),n2h16(51))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,7,8],[nMW,0,nMW],3,1,wf8(:,18))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,109),heltab2x32(:,:,125))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,4,11],[0,0,0],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,110),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(58),n2h16(52))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,4,11],[0,nMZ,0],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,111),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(59),n2h16(53))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,4,11],[0,nMW,0],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,112),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(60),n2h16(54))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,4,11],[0,0,0],3,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,113),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(61),n2h16(55))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,4,11],[nMW,0,nMW],3,1,wf8(:,15))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,114),heltab2x32(:,:,130))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,2,13],[0,nMW,0],3,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,115),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(17),16,0,G1H16(63),n2h16(56))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,2,13],[nMW,0,nMW],3,1,wf8(:,20))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,116),heltab2x32(:,:,132))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,1,14],[0,nMW,0],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,117),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(17),16,0,G1H16(65),n2h16(57))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,1,14],[nMW,0,nMW],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,118),heltab2x32(:,:,134))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[28,1,2],[0,nMW,0],3,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,13),G0H4(4),m3h8x4(:,1),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H4(4),28,0,G1H4(2),n2h4(25))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[28,1,2],[0,nMZ,0],3,1,wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,14),G0H4(4),ngZn,m3h8x4(:,2),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H4(4),28,0,G1H4(5),n2h4(26))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[28,1,2],[0,nMW,0],3,1,wf8(:,14))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,14),G0H4(4),ngZl,m3h8x4(:,3),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(4),28,0,G1H4(8),n2h4(27))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[28,1,2],[nMW,0,nMW],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(10),m3h8x4(:,4),heltab2x32(:,:,138))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[28,1,2],[nMW,0,nMW],3,1,wf8(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(3),m3h8x4(:,5),heltab2x32(:,:,139))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[28,1,2],[0,nMW,0],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,16),G0H4(4),m3h8x4(:,6),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H4(4),28,0,G1H4(15),n2h4(28))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[28,1,2],[0,nMZ,0],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,17),G0H4(4),ngZn,m3h8x4(:,7),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(4),28,0,G1H4(16),n2h4(29))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[28,1,2],[0,nMW,0],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,17),G0H4(4),ngZl,m3h8x4(:,8),heltab2x32(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(4),28,0,G1H4(17),n2h4(30))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[28,1,2],[nMW,0,nMW],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(22),m3h8x4(:,9),heltab2x32(:,:,143))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[28,1,2],[nMW,0,nMW],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(23),m3h8x4(:,10),heltab2x32(:,:,144))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(22),G1H4(3),G1H4(10),G0H4(1),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(39),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(15),G1H4(8),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(5)])
  call Hloop_WQ_A(ntryL,G1H4(4),ex3(:),G1H2(14),m3h2x2(:,35),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(14),23,0,G2H2(12),n2h2(24))
  call Hloop_WA_Q(ntryL,G1H4(14),ex4(:),G1H2(16),m3h2x2(:,36),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(16),27,0,G2H2(23),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,1),G1H2(3),ngZu,m3h4x2(:,13),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(25),n2h2(26))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,27),G1H2(20),m3h4x2(:,14),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(6),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(9),wf4(:,14),G1H2(15),ngZl,m3h4x2(:,15),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(9),n2h2(28))
  call Hloop_WQ_A(ntryL,G1H4(23),ex1(:),G1H2(11),m3h2x2(:,37),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(11),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,1),G1H4(24),ngZl,m3h4x4(:,11),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(24),19,0,G2H4(8),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,1),G1H4(27),ngZl,m3h4x4(:,12),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(27),19,nMM,G2H4(4),n2h4(32))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,1),G1H4(28),ngZl,m3h4x4(:,13),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(28),19,nML,G2H4(1),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,1),G1H4(29),ngZl,m3h4x4(:,14),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(29),19,0,G2H4(2),n2h4(34))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,1),G1H4(32),ngZl,m3h4x4(:,15),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(32),19,nMM,G2H4(3),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(5),wf4(:,1),G1H4(33),ngZl,m3h4x4(:,16),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(33),19,nML,G2H4(5),n2h4(36))
  call Hloop_AZ_Q(ntryL,G1H16(9),wf4(:,1),G1H4(34),ngZu,m3h4x4(:,17),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(34),19,0,G2H4(6),n2h4(37))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,1),G1H4(37),ngZu,m3h4x4(:,18),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(37),19,nMT,G2H4(7),n2h4(38))
  call Hloop_QZ_A(ntryL,G1H16(8),wf4(:,1),G1H4(19),ngZu,m3h4x4(:,19),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(19),19,0,G2H4(9),n2h4(39))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,1),G1H4(20),ngZu,m3h4x4(:,20),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(20),19,nMT,G2H4(10),n2h4(40))
  call Hloop_AZ_Q(ntryL,G1H16(11),wf4(:,1),G1H4(40),ngZd,m3h4x4(:,21),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(40),19,0,G2H4(11),n2h4(41))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,1),G1H4(41),ngZd,m3h4x4(:,22),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(41),19,nMB,G2H4(12),n2h4(42))
  call Hloop_QZ_A(ntryL,G1H16(13),wf4(:,1),G1H4(42),ngZd,m3h4x4(:,23),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(42),19,0,G2H4(13),n2h4(43))
  call Hloop_QZ_A(ntryL,G1H16(14),wf4(:,1),G1H4(45),ngZd,m3h4x4(:,24),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(45),19,nMB,G2H4(14),n2h4(44))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,1),G1H4(22),ngZl,m3h4x4(:,25),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(22),19,0,G2H4(15),n2h4(45))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,1),G1H4(3),ngZl,m3h4x4(:,26),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(3),19,nMM,G2H4(16),n2h4(46))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,1),G1H4(10),ngZl,m3h4x4(:,27),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(10),19,nML,G2H4(17),n2h4(47))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,1),G1H4(15),ngZl,m3h4x4(:,28),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(15),19,0,G2H4(18),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,1),G1H4(8),ngZl,m3h4x4(:,29),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(8),19,nMM,G2H4(19),n2h4(49))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,1),G1H4(2),ngZl,m3h4x4(:,30),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(2),19,nML,G2H4(20),n2h4(50))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,1),G1H4(5),ngZu,m3h4x4(:,31),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(21),n2h4(51))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,1),G1H4(4),ngZu,m3h4x4(:,32),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(4),19,nMT,G2H4(22),n2h4(52))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,1),G1H4(14),ngZu,m3h4x4(:,33),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(14),19,0,G2H4(23),n2h4(53))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,1),G1H4(23),ngZu,m3h4x4(:,34),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(23),19,nMT,G2H4(24),n2h4(54))
  call Hloop_AZ_Q(ntryL,G1H16(25),wf4(:,1),G1H4(24),ngZd,m3h4x4(:,35),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(24),19,0,G2H4(25),n2h4(55))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,1),G1H4(27),ngZd,m3h4x4(:,36),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(27),19,nMB,G2H4(26),n2h4(56))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,1),G1H4(28),ngZd,m3h4x4(:,37),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(28),19,0,G2H4(27),n2h4(57))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,1),G1H4(29),ngZd,m3h4x4(:,38),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(29),19,nMB,G2H4(28),n2h4(58))
  call Hloop_SV_T(ntryL,G1H16(29),16,wf4(:,1),3,G2H4(29),m3h4x4(:,39),heltab2x16(:,:,63))
  call Hloop_TV_S(ntryL,G1H16(30),16,wf4(:,1),3,G2H4(30),m3h4x4(:,40),heltab2x16(:,:,64))
  call Hloop_SV_T(ntryL,G1H16(31),16,wf4(:,1),3,G2H4(31),m3h4x4(:,41),heltab2x16(:,:,65))
  call Hloop_TV_S(ntryL,G1H16(32),16,wf4(:,1),3,G2H4(32),m3h4x4(:,42),heltab2x16(:,:,66))
  call Hloop_DV_C(ntryL,G1H16(35),16,wf4(:,1),G2H4(33),m3h4x4(:,43),heltab2x16(:,:,67))
  call Hloop_CV_D(ntryL,G1H16(36),16,wf4(:,1),3,G2H4(34),m3h4x4(:,44),heltab2x16(:,:,68))
  call Hloop_DV_C(ntryL,G1H16(39),16,wf4(:,1),G2H4(35),m3h4x4(:,45),heltab2x16(:,:,69))
  call Hloop_CV_D(ntryL,G1H16(40),16,wf4(:,1),3,G2H4(36),m3h4x4(:,46),heltab2x16(:,:,70))
  call Hloop_UW_V(ntryL,G1H16(41),16,wf4(:,1),3,G2H4(37),m3h4x4(:,47),heltab2x16(:,:,71))
  call Hloop_UV_W(ntryL,G1H16(42),16,wf4(:,1),3,G2H4(38),m3h4x4(:,48),heltab2x16(:,:,72))
  call Hloop_UW_V(ntryL,G1H16(43),16,wf4(:,1),3,G2H4(39),m3h4x4(:,49),heltab2x16(:,:,73))
  call Hloop_UV_W(ntryL,G1H16(44),16,wf4(:,1),3,G2H4(40),m3h4x4(:,50),heltab2x16(:,:,74))
  call Hloop_SV_V(ntryL,G1H16(46),wf4(:,1),G1H4(32),m3h4x4(:,51),heltab2x16(:,:,75))
  call Hloop_SV_V(ntryL,G1H16(48),wf4(:,1),G1H4(33),m3h4x4(:,52),heltab2x16(:,:,76))
  call Hloop_SV_T(ntryL,G0H16(7),16,wf4(:,1),3,G1H4(34),m3h4x4(:,53),heltab2x16(:,:,77))
  call Hloop_TV_S(ntryL,G0H16(1),16,wf4(:,1),3,G1H4(37),m3h4x4(:,54),heltab2x16(:,:,78))
  call Hloop_SV_T(ntryL,G0H16(2),16,wf4(:,1),3,G1H4(19),m3h4x4(:,55),heltab2x16(:,:,79))
  call Hloop_TV_S(ntryL,G0H16(3),16,wf4(:,1),3,G1H4(20),m3h4x4(:,56),heltab2x16(:,:,80))
  call Hloop_VV_S(ntryL,G0H16(4),wf4(:,1),G0H4(4),m3h4x4(:,57),heltab2x16(:,:,81))
  call Hloop_VV_S(ntryL,G0H16(5),wf4(:,1),G0H4(3),m3h4x4(:,58),heltab2x16(:,:,82))
  call Hloop_VV_S(ntryL,G0H16(6),wf4(:,1),G0H4(1),m3h4x4(:,59),heltab2x16(:,:,83))
  call Hloop_VV_S(ntryL,G0H16(8),wf4(:,1),G0H4(2),m3h4x4(:,60),heltab2x16(:,:,84))
  call Hloop_SV_V(ntryL,G0H16(9),wf4(:,1),G0H4(5),m3h4x4(:,61),heltab2x16(:,:,85))
  call Hloop_SV_V(ntryL,G0H16(10),wf4(:,1),G0H4(6),m3h4x4(:,62),heltab2x16(:,:,86))
  call Hloop_SV_V(ntryL,G0H16(11),wf4(:,1),G0H4(7),m3h4x4(:,63),heltab2x16(:,:,87))
  call Hloop_SV_V(ntryL,G0H16(12),wf4(:,1),G0H4(8),m3h4x4(:,64),heltab2x16(:,:,88))
  call Hloop_UW_V(ntryL,G0H16(13),16,wf4(:,1),3,G1H4(40),m3h4x4(:,65),heltab2x16(:,:,89))
  call Hloop_UV_W(ntryL,G0H16(14),16,wf4(:,1),3,G1H4(41),m3h4x4(:,66),heltab2x16(:,:,90))
  call Hloop_UW_V(ntryL,G0H16(15),16,wf4(:,1),3,G1H4(42),m3h4x4(:,67),heltab2x16(:,:,91))
  call Hloop_UV_W(ntryL,G0H16(16),16,wf4(:,1),3,G1H4(45),m3h4x4(:,68),heltab2x16(:,:,92))
  call Hloop_VV_S(ntryL,G1H16(50),wf4(:,1),G1H4(22),m3h4x4(:,69),heltab2x16(:,:,93))
  call Hloop_VV_S(ntryL,G1H16(52),wf4(:,1),G1H4(3),m3h4x4(:,70),heltab2x16(:,:,94))
  call Hloop_QZ_A(ntryL,G1H8(15),wf4(:,1),G1H2(10),ngZd,m3h4x2(:,16),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(10),23,0,G2H2(13),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,1),G1H2(13),ngZd,m3h4x2(:,17),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(13),23,0,G2H2(1),n2h2(31))
  call Hloop_UV_W(ntryL,G0H8(4),20,wf4(:,1),3,G1H2(17),m3h4x2(:,18),heltab2x8(:,:,45))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,1),G1H2(25),ngZd,m3h4x2(:,19),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(25),27,0,G2H2(2),n2h2(32))
  call Hloop_AZ_Q(ntryL,G1H8(4),wf4(:,1),G1H2(9),ngZd,m3h4x2(:,20),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(9),27,0,G2H2(3),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,1),G1H2(6),ngZu,m3h4x2(:,21),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(6),27,0,G2H2(4),n2h2(34))
  call Hloop_UW_V(ntryL,G0H8(2),24,wf4(:,1),3,G1H2(19),m3h4x2(:,22),heltab2x8(:,:,49))
  call Hloop_AQ_V(ntryL,G1H16(56),wf8(:,18),G1H2(18),m3h8x2(:,1),heltab2x16(:,:,95))
  call Hloop_AQ_Z(ntryL,G1H16(54),wf8(:,18),G1H2(23),ngZd,m3h8x2(:,2),heltab2x16(:,:,96))
  call Hloop_AQ_W(ntryL,G1H16(55),wf8(:,18),G1H2(24),m3h8x2(:,3),heltab2x16(:,:,97))
  call Hloop_WQ_A(ntryL,G1H16(57),wf8(:,18),G1H2(29),m3h8x2(:,4),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(29),23,0,G2H2(5),n2h2(35))
  call Hloop_AQ_V(ntryL,G1H16(61),ex3(:),G1H8(7),m3h2x8(:,25),heltab2x16(:,:,99))
  call Hloop_AQ_Z(ntryL,G1H16(59),ex3(:),G1H8(8),ngZd,m3h2x8(:,26),heltab2x16(:,:,100))
  call Hloop_AQ_W(ntryL,G1H16(60),ex3(:),G1H8(10),m3h2x8(:,27),heltab2x16(:,:,101))
  call Hloop_WQ_A(ntryL,G1H16(62),ex3(:),G1H8(11),m3h2x8(:,28),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(11),20,0,G2H8(1),n2h8(25))
  call Hloop_QA_W(ntryL,G1H16(63),ex2(:),G1H8(13),m3h2x8(:,29),heltab2x16(:,:,103))
  call Hloop_WA_Q(ntryL,G1H16(64),ex2(:),G1H8(12),m3h2x8(:,30),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(2),n2h8(26))
  call Hloop_AQ_W(ntryL,G1H16(65),ex1(:),G1H8(3),m3h2x8(:,31),heltab2x16(:,:,105))
  call Hloop_WQ_A(ntryL,G1H16(66),ex1(:),G1H8(14),m3h2x8(:,32),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H8(14),17,0,G2H8(3),n2h8(27))
  call Hloop_AQ_W(ntryL,G1H4(17),ex1(:),G1H2(30),m3h2x2(:,38),heltab2x4(:,:,66))
  call Hloop_AQ_Z(ntryL,G1H4(16),ex1(:),G1H2(31),ngZn,m3h2x2(:,39),heltab2x4(:,:,67))
call HGT_w2_OLR(G1H2(21),1,1,2)
call HGT_w2_invQ_OLR(G1H2(21),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(21),G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(22)])
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(17)])
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(24)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(43),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(6),G2H4(8),G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(21),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(26),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(9),G2H4(2),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(39),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(44),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(40),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(42),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(37),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(20),G1H4(19)])
  call Hloop_WQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(65))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(2),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hloop_WA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(66))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(4),m3h2x1(:,68),heltab2x2(:,:,68))
call HGT_w2_OLR(G1H4(11),1,1,4)
call HGT_w2_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,29),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(67))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,27),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(68))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(71),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,31),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(69))
  call Hloop_WA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(70))
  call Hloop_WA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(71))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(73))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(74))
  call Hloop_ZQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),ngZd,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(75))
  call Hloop_ZQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),ngZd,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(76))
  call Hloop_WQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(77))
  call Hloop_WQ_A(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(80))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngZd,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(81))
  call Hloop_ZA_Q(ntryL,G1H2(23),ex4(:),G1H1(1),ngZd,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(82))
  call Hloop_WA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,27),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(84))
  call Hloop_AV_Q(ntryL,G2H4(11),wf4(:,27),G2H1(1),m3h4x1(:,33),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H4(9),wf4(:,14),G1H1(1),ngZl,m3h4x1(:,34),heltab2x4(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(86))
  call Hloop_AZ_Q(ntryL,G2H4(15),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,35),heltab2x4(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(2),n2h1(87))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(18),19,wf4(:,27),12,G2tensor(11),m3h4x1(:,36),heltab2x4(:,:,75))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(38),19,wf4(:,27),12,G3tensor(3),m3h4x1(:,37),heltab2x4(:,:,76))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(25),19,wf4(:,14),12,G2tensor(14),m3h4x1(:,38),heltab2x4(:,:,77))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(40),19,wf4(:,14),12,G3tensor(4),m3h4x1(:,39),heltab2x4(:,:,78))
  call Hloop_QV_A(ntryL,G2H4(13),wf4(:,27),G2H1(1),m3h4x1(:,40),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(88))
  call Hloop_QZ_A(ntryL,G2H4(18),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,41),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(89))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(38),19,wf4(:,27),12,G2tensor(17),m3h4x1(:,42),heltab2x4(:,:,81))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(37),19,wf4(:,27),12,G3tensor(7),m3h4x1(:,43),heltab2x4(:,:,82))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(43),19,wf4(:,14),12,G2tensor(18),m3h4x1(:,44),heltab2x4(:,:,83))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H4(39),19,wf4(:,14),12,G3tensor(8),m3h4x1(:,45),heltab2x4(:,:,84))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(35),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(19),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(20),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(21),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(22),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,27),G2H1(1),m3h4x1(:,46),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(9),n2h1(90))
  call Hloop_AV_Q(ntryL,G2H4(1),wf4(:,27),G2H1(1),m3h4x1(:,47),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(10),n2h1(91))
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,27),G2H1(1),m3h4x1(:,48),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(11),n2h1(92))
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,27),G2H1(1),m3h4x1(:,49),heltab2x4(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(12),n2h1(93))
  call Hloop_AV_Q(ntryL,G2H4(7),wf4(:,27),G2H1(1),m3h4x1(:,50),heltab2x4(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(94))
  call Hloop_QV_A(ntryL,G2H4(10),wf4(:,27),G2H1(1),m3h4x1(:,51),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(95))
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,27),G2H1(1),m3h4x1(:,52),heltab2x4(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(96))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,27),G2H1(1),m3h4x1(:,53),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(16),n2h1(97))
  call Hloop_AZ_Q(ntryL,G2H4(16),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,54),heltab2x4(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(17),n2h1(98))
  call Hloop_AZ_Q(ntryL,G2H4(17),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,55),heltab2x4(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(18),n2h1(99))
  call Hloop_QZ_A(ntryL,G2H4(19),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,56),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(19),n2h1(100))
  call Hloop_QZ_A(ntryL,G2H4(20),wf4(:,14),G2H1(1),ngZl,m3h4x1(:,57),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(20),n2h1(101))
  call Hloop_AZ_Q(ntryL,G2H4(21),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,58),heltab2x4(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(102))
  call Hloop_AZ_Q(ntryL,G2H4(22),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,59),heltab2x4(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(22),n2h1(103))
  call Hloop_QZ_A(ntryL,G2H4(23),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,60),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(23),n2h1(104))
  call Hloop_QZ_A(ntryL,G2H4(24),wf4(:,14),G2H1(1),ngZu,m3h4x1(:,61),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(24),n2h1(105))
  call Hloop_AZ_Q(ntryL,G2H4(25),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,62),heltab2x4(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(25),n2h1(106))
  call Hloop_AZ_Q(ntryL,G2H4(26),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,63),heltab2x4(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(26),n2h1(107))
  call Hloop_QZ_A(ntryL,G2H4(27),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,64),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(27),n2h1(108))
  call Hloop_QZ_A(ntryL,G2H4(28),wf4(:,14),G2H1(1),ngZd,m3h4x1(:,65),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(28),n2h1(109))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(29),19,wf4(:,27),12,G3tensor(29),m3h4x1(:,66),heltab2x4(:,:,105))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(30),19,wf4(:,27),12,G3tensor(30),m3h4x1(:,67),heltab2x4(:,:,106))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H4(31),19,wf4(:,14),12,G3tensor(31),m3h4x1(:,68),heltab2x4(:,:,107))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H4(32),19,wf4(:,14),12,G3tensor(32),m3h4x1(:,69),heltab2x4(:,:,108))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(33),19,wf4(:,27),G3tensor(33),m3h4x1(:,70),heltab2x4(:,:,109))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(34),19,wf4(:,27),12,G3tensor(34),m3h4x1(:,71),heltab2x4(:,:,110))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(35),19,wf4(:,14),G3tensor(35),m3h4x1(:,72),heltab2x4(:,:,111))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(36),19,wf4(:,14),12,G3tensor(36),m3h4x1(:,73),heltab2x4(:,:,112))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(41),wf4(:,27),G1tensor(25),m3h4x1(:,74),heltab2x4(:,:,113))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(45),wf4(:,14),G1tensor(7),m3h4x1(:,75),heltab2x4(:,:,114))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(22),wf4(:,27),G1tensor(20),m3h4x1(:,76),heltab2x4(:,:,115))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(3),wf4(:,14),G1tensor(3),m3h4x1(:,77),heltab2x4(:,:,116))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(38),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(25),ngZd,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(26),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(31),ngZd,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(33),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hloop_VA_Q(ntryL,G1H8(7),wf8(:,15),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(110))
  call Hloop_ZA_Q(ntryL,G1H8(8),wf8(:,15),G1H1(1),ngZd,m3h8x1(:,2),heltab2x8(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(111))
  call Hloop_WA_Q(ntryL,G1H8(10),wf8(:,15),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(112))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(1),wf8(:,15),G2tensor(50),m3h8x1(:,4),heltab2x8(:,:,53))
  call Hloop_WQ_A(ntryL,G1H8(13),wf8(:,20),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(113))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(2),wf8(:,20),G2tensor(56),m3h8x1(:,6),heltab2x8(:,:,55))
  call Hloop_WA_Q(ntryL,G1H8(3),wf8(:,22),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(114))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H8(3),wf8(:,22),G2tensor(74),m3h8x1(:,8),heltab2x8(:,:,57))
  call Hloop_WA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(115))
  call Hloop_ZA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),ngZn,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(116))
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G3tensor(34),G3tensor(33),G3tensor(32),G3tensor(31),G3tensor(30),G3tensor(29) &
    ,G3tensor(8),G3tensor(7),G3tensor(4),G3tensor(3),G2tensor(30),G2tensor(28),G1tensor(3),G1tensor(20),G1tensor(7),G1tensor(25) &
    ,G1tensor(80),G1tensor(60),G1tensor(14),G1tensor(13),G0tensor(80),G0tensor(60),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(32),G1tensor(150),G0tensor(150)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(70),G2tensor(67),G2tensor(34),G1tensor(155),G1tensor(85),G1tensor(18),G0tensor(155) &
    ,G0tensor(85),G0tensor(10)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(107),G1tensor(11),G0tensor(107),G0tensor(25)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(37),G1tensor(110),G1tensor(22),G0tensor(110),G0tensor(30)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(17),G2tensor(39),G1tensor(132),G1tensor(45),G1tensor(19),G0tensor(132),G0tensor(45) &
    ,G0tensor(3)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(64),G2tensor(61),G2tensor(40),G1tensor(190),G1tensor(135),G1tensor(50) &
    ,G0tensor(190),G0tensor(135),G0tensor(50)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(42),G1tensor(157),G0tensor(157)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G3tensor(23),G3tensor(21),G3tensor(6),G3tensor(5),G3tensor(2),G3tensor(1) &
    ,G2tensor(58),G2tensor(55),G2tensor(52),G2tensor(49),G2tensor(46),G2tensor(43),G1tensor(194),G1tensor(189),G1tensor(185) &
    ,G1tensor(180),G1tensor(175),G1tensor(170),G1tensor(165),G1tensor(160),G0tensor(194),G0tensor(189),G0tensor(185),G0tensor(180) &
    ,G0tensor(175),G0tensor(170),G0tensor(165),G0tensor(160)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(45),G1tensor(162),G0tensor(162)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(48),G1tensor(167),G1tensor(148),G0tensor(167),G0tensor(148)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(51),G1tensor(172),G0tensor(172)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(54),G1tensor(177),G0tensor(177)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(57),G1tensor(182),G0tensor(182)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(63),G2tensor(60),G1tensor(187),G0tensor(187)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(69),G2tensor(66),G1tensor(67),G1tensor(9),G1tensor(1),G0tensor(67),G0tensor(23) &
    ,G0tensor(7)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(72),G1tensor(192),G0tensor(192)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(76),G2tensor(73),G1tensor(195),G0tensor(195)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(78),G1tensor(52),G1tensor(31),G0tensor(52),G0tensor(2)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(82),G2tensor(79),G1tensor(65),G1tensor(6),G0tensor(65),G0tensor(5)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(11),G1tensor(75),G1tensor(12),G0tensor(75),G0tensor(8)])
  call ol_merge_tensors(G1tensor(36),[G1tensor(24),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(87),G1tensor(26),G0tensor(142),G0tensor(87),G0tensor(13)])
  call ol_merge_tensors(G1tensor(92),[G1tensor(30),G0tensor(92),G0tensor(14)])
  call ol_merge_tensors(G1tensor(97),[G1tensor(34),G1tensor(32),G0tensor(97),G0tensor(35),G0tensor(15)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(2),G0tensor(90),G0tensor(18)])
  call ol_merge_tensors(G1tensor(130),[G1tensor(105),G1tensor(95),G1tensor(49),G1tensor(17),G1tensor(4),G0tensor(130) &
    ,G0tensor(105),G0tensor(95),G0tensor(49),G0tensor(29),G0tensor(19)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(100),G1tensor(40),G1tensor(5),G0tensor(100),G0tensor(40),G0tensor(20)])
  call ol_merge_tensors(G1tensor(16),[G1tensor(8),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G1tensor(102),[G1tensor(10),G0tensor(102),G0tensor(24)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(70),G1tensor(29),G0tensor(82),G0tensor(70),G0tensor(28)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(27),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G1tensor(137),[G1tensor(112),G1tensor(28),G0tensor(137),G0tensor(112),G0tensor(33)])
  call ol_merge_tensors(G1tensor(117),[G1tensor(33),G0tensor(117),G0tensor(34)])
  call ol_merge_tensors(G1tensor(115),[G1tensor(38),G0tensor(115),G0tensor(38)])
  call ol_merge_tensors(G1tensor(120),[G1tensor(39),G0tensor(120),G0tensor(39)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(47),G1tensor(42),G0tensor(53),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(122),G1tensor(58),G1tensor(43),G0tensor(122),G0tensor(58),G0tensor(43)])
  call ol_merge_tensors(G1tensor(127),[G1tensor(63),G1tensor(44),G0tensor(127),G0tensor(63),G0tensor(44)])
  call ol_merge_tensors(G1tensor(125),[G1tensor(48),G0tensor(125),G0tensor(48)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(57),G1tensor(54),G0tensor(57),G0tensor(54)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(55),G0tensor(62),G0tensor(55)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(149),G1tensor(64),G1tensor(59),G0tensor(149),G0tensor(64),G0tensor(59)])
  call ol_merge_tensors(G1tensor(103),[G1tensor(72),G1tensor(68),G0tensor(103),G0tensor(72),G0tensor(68)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(108),G1tensor(77),G1tensor(69),G0tensor(108),G0tensor(77),G0tensor(69)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(78),G1tensor(73),G0tensor(78),G0tensor(73)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(74),G0tensor(83),G0tensor(74)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(84),G1tensor(79),G0tensor(84),G0tensor(79)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(88),G0tensor(93),G0tensor(88)])
  call ol_merge_tensors(G1tensor(114),[G1tensor(98),G1tensor(89),G0tensor(114),G0tensor(98),G0tensor(89)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(179),G1tensor(119),G1tensor(99),G1tensor(94),G0tensor(179),G0tensor(119) &
    ,G0tensor(99),G0tensor(94)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(184),G1tensor(109),G1tensor(104),G0tensor(184),G0tensor(109),G0tensor(104)])
  call ol_merge_tensors(G1tensor(118),[G1tensor(113),G0tensor(118),G0tensor(113)])
  call ol_merge_tensors(G1tensor(128),[G1tensor(123),G0tensor(128),G0tensor(123)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(133),G1tensor(124),G0tensor(133),G0tensor(124)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(134),G1tensor(129),G0tensor(134),G0tensor(129)])
  call ol_merge_tensors(G1tensor(138),[G0tensor(138)])
  call ol_merge_tensors(G1tensor(144),[G1tensor(139),G0tensor(144),G0tensor(139)])
  call ol_merge_tensors(G1tensor(140),[G0tensor(140)])
  call ol_merge_tensors(G1tensor(143),[G0tensor(143)])
  call ol_merge_tensors(G1tensor(145),[G0tensor(145)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(147),G0tensor(147)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(59),G1tensor(193),G1tensor(152),G0tensor(193),G0tensor(152)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(153),G0tensor(153)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(154),G0tensor(154)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(158),G0tensor(158)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(159),G0tensor(159)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(163),G0tensor(163)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(164),G0tensor(164)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(168),G0tensor(168)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(169),G0tensor(169)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(173),G0tensor(173)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(174),G0tensor(174)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(178),G0tensor(178)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(183),G0tensor(183)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(29),G1tensor(188),G0tensor(188)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(17),G3tensor(11),G3tensor(9)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(18),G3tensor(12),G3tensor(10)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(22),G3tensor(14),G3tensor(13)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G3tensor(16),G3tensor(15)])
  call TI_triangle_red(G3tensor(36),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(50),RedBasis(12),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMW], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(74),RedBasis(7),mass3set(:,2),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMW], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(36),RedBasis(38),mass3set(:,3),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMW], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(47),RedBasis(12),mass3set(:,4),G0tensor(101),G0tensor(106),G0tensor(111), &
    G0tensor(116),M2L1R1,[nMW],G0tensor(121))
  call TI_triangle_red(G2tensor(18),RedBasis(4),mass3set(:,3),G0tensor(126),G0tensor(131),G0tensor(136), &
    G0tensor(141),M2L1R1,[nMW],G0tensor(146))
  call TI_triangle_red(G2tensor(62),RedBasis(7),mass3set(:,4),G0tensor(151),G0tensor(156),G0tensor(161), &
    G0tensor(166),M2L1R1,[nMW],G0tensor(171))
  call TI_triangle_red(G2tensor(38),RedBasis(15),mass3set(:,5),G0tensor(176),G0tensor(181),G0tensor(186),G0tensor(191),M2L1R1)
  call TI_triangle_red(G3tensor(27),RedBasis(2),mass3set(:,5),G0tensor(80),G0tensor(60),G0tensor(9),G0tensor(4),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(15),mass3set(:,6),G0tensor(150),G0tensor(155),G0tensor(85),G0tensor(10),M2L1R1,[nMZ], &
    G0tensor(107))
  call TI_triangle_red(G2tensor(20),RedBasis(15),mass3set(:,7),G0tensor(25),G0tensor(110),G0tensor(30),G0tensor(132),M2L1R1,[nMW], &
    G0tensor(45))
  call TI_triangle_red(G2tensor(26),RedBasis(44),mass3set(:,5),G0tensor(3),G0tensor(190),G0tensor(135),G0tensor(50),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(44),mass3set(:,6),G0tensor(157),G0tensor(194),G0tensor(189), &
    G0tensor(185),M2L1R1,[nMZ],G0tensor(180))
  call TI_triangle_red(G2tensor(33),RedBasis(44),mass3set(:,7),G0tensor(175),G0tensor(170),G0tensor(165), &
    G0tensor(160),M2L1R1,[nMW],G0tensor(162))
  call TI_triangle_red(G2tensor(83),RedBasis(40),mass3set(:,4),G0tensor(167),G0tensor(148),G0tensor(172), &
    G0tensor(177),M2L1R1,[nMW],G0tensor(182))
  call TI_triangle_red(G2tensor(22),RedBasis(40),mass3set(:,2),G0tensor(187),G0tensor(67),G0tensor(23),G0tensor(7),M2L1R1,[nMW], &
    G0tensor(192))
  call TI_triangle_red(G2tensor(75),RedBasis(42),mass3set(:,4),G0tensor(195),G0tensor(52),G0tensor(2),G0tensor(65),M2L1R1,[nMW], &
    G0tensor(5))
  call TI_triangle_red(G2tensor(53),RedBasis(1),mass3set(:,4),G0tensor(75),G0tensor(8),G0tensor(17),G0tensor(12),M2L1R1,[nMW], &
    G0tensor(142))
  call TI_triangle_red(G2tensor(81),RedBasis(42),mass3set(:,2),G0tensor(87),G0tensor(13),G0tensor(92),G0tensor(14),M2L1R1,[nMW], &
    G0tensor(97))
  call TI_triangle_red(G2tensor(56),RedBasis(1),mass3set(:,2),G0tensor(35),G0tensor(15),G0tensor(90),G0tensor(18),M2L1R1,[nMW], &
    G0tensor(130))
  call TI_triangle_red(G2tensor(14),RedBasis(9),mass3set(:,3),G0tensor(105),G0tensor(95),G0tensor(49),G0tensor(29),M2L1R1,[nMW], &
    G0tensor(19))
  call TI_triangle_red(G2tensor(44),RedBasis(12),mass3set(:,8),G0tensor(100),G0tensor(40),G0tensor(20),G0tensor(27),M2L1R1,[nMZ], &
    G0tensor(22))
  call TI_triangle_red(G2tensor(35),RedBasis(6),mass3set(:,2),G0tensor(102),G0tensor(24),G0tensor(82),G0tensor(70),M2L1R1,[nMW], &
    G0tensor(28))
  call TI_triangle_red(G2tensor(77),RedBasis(44),mass3set(:,9),G0tensor(37),G0tensor(32),G0tensor(137),G0tensor(112),M2L1R1,[nMW], &
    G0tensor(33))
  call TI_triangle_red(G2tensor(2),RedBasis(3),mass3set(:,2),G0tensor(117),G0tensor(34),G0tensor(115),G0tensor(38),M2L1R1,[nMW], &
    G0tensor(120))
  call TI_triangle_red(G2tensor(65),RedBasis(15),mass3set(:,9),G0tensor(39),G0tensor(53),G0tensor(47),G0tensor(42),M2L1R1,[nMW], &
    G0tensor(122))
  call TI_triangle_red(G2tensor(19),RedBasis(11),mass3set(:,2),G0tensor(58),G0tensor(43),G0tensor(127),G0tensor(63),M2L1R1,[nMW], &
    G0tensor(44))
  call TI_triangle_red(G2tensor(4),RedBasis(8),mass3set(:,2),G0tensor(125),G0tensor(48),G0tensor(57),G0tensor(54),M2L1R1,[nMW], &
    G0tensor(62))
  call TI_triangle_red(G2tensor(5),RedBasis(3),mass3set(:,8),G0tensor(55),G0tensor(149),G0tensor(64),G0tensor(59),M2L1R1,[nMZ], &
    G0tensor(103))
  call TI_triangle_red(G2tensor(68),RedBasis(3),mass3set(:,4),G0tensor(72),G0tensor(68),G0tensor(108),G0tensor(77),M2L1R1,[nMW], &
    G0tensor(69))
  call TI_triangle_red(G2tensor(6),RedBasis(22),mass3set(:,9),G0tensor(78),G0tensor(73),G0tensor(83),G0tensor(74),M2L1R1,[nMW], &
    G0tensor(84))
  call TI_triangle_red(G2tensor(7),RedBasis(20),mass3set(:,4),G0tensor(79),G0tensor(93),G0tensor(88),G0tensor(114),M2L1R1,[nMW], &
    G0tensor(98))
  call TI_triangle_red(G2tensor(15),RedBasis(38),mass3set(:,10),G0tensor(89),G0tensor(179),G0tensor(119), &
    G0tensor(99),M2L1R1,[nMW],G0tensor(94))
  call TI_triangle_red(G2tensor(80),RedBasis(4),mass3set(:,10),G0tensor(184),G0tensor(109),G0tensor(104), &
    G0tensor(118),M2L1R1,[nMW],G0tensor(113))
  call TI_triangle_red(G2tensor(21),RedBasis(22),mass3set(:,7),G0tensor(128),G0tensor(123),G0tensor(133), &
    G0tensor(124),M2L1R1,[nMW],G0tensor(134))
  call TI_triangle_red(G2tensor(71),RedBasis(20),mass3set(:,2),G0tensor(129),G0tensor(138),G0tensor(144), &
    G0tensor(139),M2L1R1,[nMW],G0tensor(140))
  call TI_triangle_red(G2tensor(9),RedBasis(11),mass3set(:,5),G0tensor(143),G0tensor(145),G0tensor(147),G0tensor(193),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(8),mass3set(:,5),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(158),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(11),mass3set(:,8),G0tensor(159),G0tensor(163),G0tensor(164), &
    G0tensor(168),M2L1R1,[nMZ],G0tensor(169))
  call TI_triangle_red(G2tensor(13),RedBasis(8),mass3set(:,8),G0tensor(173),G0tensor(174),G0tensor(178), &
    G0tensor(183),M2L1R1,[nMZ],G0tensor(188))
  call TI_triangle_red(G2tensor(23),RedBasis(11),mass3set(:,4),G0tensor(196),G0tensor(197),G0tensor(198), &
    G0tensor(199),M2L1R1,[nMW],G0tensor(200))
  call TI_triangle_red(G2tensor(16),RedBasis(8),mass3set(:,4),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMW],G0tensor(205))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,5),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),M2L1R1)
  call TI_triangle_red(G2tensor(27),RedBasis(3),mass3set(:,5),G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),M2L1R1)
  call TI_triangle_red(G2tensor(3),RedBasis(6),mass3set(:,8),G0tensor(214),G0tensor(215),G0tensor(216),G0tensor(217),M2L1R1,[nMZ], &
    G0tensor(218))
  call TI_triangle_red(G2tensor(24),RedBasis(6),mass3set(:,4),G0tensor(219),G0tensor(220),G0tensor(221), &
    G0tensor(222),M2L1R1,[nMW],G0tensor(223))
  call TI_triangle_red(G2tensor(8),RedBasis(9),mass3set(:,10),G0tensor(224),G0tensor(225),G0tensor(226), &
    G0tensor(227),M2L1R1,[nMW],G0tensor(228))
  call TI_triangle_red(G3tensor(19),RedBasis(2),mass3set(:,11),G0tensor(229),G0tensor(230),G0tensor(231), &
    G0tensor(232),M2L1R1,[nMM],G0tensor(233))
  call TI_triangle_red(G3tensor(20),RedBasis(2),mass3set(:,12),G0tensor(234),G0tensor(235),G0tensor(236), &
    G0tensor(237),M2L1R1,[nML],G0tensor(238))
  call TI_triangle_red(G3tensor(24),RedBasis(2),mass3set(:,13),G0tensor(239),G0tensor(240),G0tensor(241), &
    G0tensor(242),M2L1R1,[nMT],G0tensor(243))
  call TI_triangle_red(G3tensor(28),RedBasis(2),mass3set(:,14),G0tensor(244),G0tensor(245),G0tensor(246), &
    G0tensor(247),M2L1R1,[nMB],G0tensor(248))
  call TI_triangle_red(G2tensor(41),RedBasis(12),mass3set(:,5),G0tensor(249),G0tensor(250),G0tensor(251),G0tensor(252),M2L1R1)
  call TI_triangle_red(G2tensor(84),RedBasis(40),mass3set(:,8),G0tensor(253),G0tensor(254),G0tensor(255), &
    G0tensor(256),M2L1R1,[nMZ],G0tensor(257))
  call TI_triangle_red(G1tensor(36),RedBasis(48),mass3set(:,8),G0tensor(258),G0tensor(259),G0tensor(260), &
    G0tensor(261),M2L1R1,[nMZ],G0tensor(262))
  call TI_triangle_red(G1tensor(142),RedBasis(40),mass3set(:,15),G0tensor(263),G0tensor(264),G0tensor(265), &
    G0tensor(266),M2L1R1,[nMZ],G0tensor(267))
  call TI_triangle_red(G1tensor(92),RedBasis(39),mass3set(:,6),G0tensor(268),G0tensor(269),G0tensor(270), &
    G0tensor(271),M2L1R1,[nMZ],G0tensor(272))
  call TI_triangle_red(G1tensor(97),RedBasis(38),mass3set(:,16),G0tensor(273),G0tensor(274),G0tensor(275), &
    G0tensor(276),M2L1R1,[nMZ],G0tensor(277))
  call TI_triangle_red(G1tensor(90),RedBasis(14),mass3set(:,17),G0tensor(278),G0tensor(279),G0tensor(280), &
    G0tensor(281),M2L1R1,[nMZ],G0tensor(282))
  call TI_triangle_red(G1tensor(130),RedBasis(13),mass3set(:,5),G0tensor(283),G0tensor(284),G0tensor(285),G0tensor(286),M2L1R1)
  call TI_triangle_red(G1tensor(16),RedBasis(48),mass3set(:,4),G0tensor(287),G0tensor(288),G0tensor(289), &
    G0tensor(290),M2L1R1,[nMW],G0tensor(291))
  call TI_triangle_red(G1tensor(102),RedBasis(39),mass3set(:,7),G0tensor(292),G0tensor(293),G0tensor(294), &
    G0tensor(295),M2L1R1,[nMW],G0tensor(296))
  call TI_triangle_red(G1tensor(82),RedBasis(14),mass3set(:,10),G0tensor(297),G0tensor(298),G0tensor(299), &
    G0tensor(300),M2L1R1,[nMW],G0tensor(301))
  call TI_triangle_red(G1tensor(37),RedBasis(49),mass3set(:,8),G0tensor(302),G0tensor(303),G0tensor(304), &
    G0tensor(305),M2L1R1,[nMZ],G0tensor(306))
  call TI_triangle_red(G1tensor(137),RedBasis(42),mass3set(:,15),G0tensor(307),G0tensor(308),G0tensor(309), &
    G0tensor(310),M2L1R1,[nMZ],G0tensor(311))
  call TI_triangle_red(G1tensor(117),RedBasis(41),mass3set(:,6),G0tensor(312),G0tensor(313),G0tensor(314), &
    G0tensor(315),M2L1R1,[nMZ],G0tensor(316))
  call TI_triangle_red(G1tensor(115),RedBasis(18),mass3set(:,17),G0tensor(317),G0tensor(318),G0tensor(319), &
    G0tensor(320),M2L1R1,[nMZ],G0tensor(321))
  call TI_triangle_red(G1tensor(120),RedBasis(17),mass3set(:,5),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325),M2L1R1)
  call TI_triangle_red(G1tensor(53),RedBasis(45),mass3set(:,4),G0tensor(326),G0tensor(327),G0tensor(328), &
    G0tensor(329),M2L1R1,[nMW],G0tensor(330))
  call TI_triangle_red(G1tensor(127),RedBasis(5),mass3set(:,7),G0tensor(331),G0tensor(332),G0tensor(333), &
    G0tensor(334),M2L1R1,[nMW],G0tensor(335))
  call TI_triangle_red(G1tensor(125),RedBasis(21),mass3set(:,10),G0tensor(336),G0tensor(337),G0tensor(338), &
    G0tensor(339),M2L1R1,[nMW],G0tensor(340))
  call TI_triangle_red(G1tensor(62),RedBasis(43),mass3set(:,10),G0tensor(341),G0tensor(342),G0tensor(343), &
    G0tensor(344),M2L1R1,[nMW],G0tensor(345))
  call TI_triangle_red(G1tensor(103),RedBasis(16),mass3set(:,4),G0tensor(346),G0tensor(347),G0tensor(348), &
    G0tensor(349),M2L1R1,[nMW],G0tensor(350))
  call TI_triangle_red(G1tensor(83),RedBasis(10),mass3set(:,7),G0tensor(351),G0tensor(352),G0tensor(353), &
    G0tensor(354),M2L1R1,[nMW],G0tensor(355))
  call TI_triangle_red(G1tensor(93),RedBasis(16),mass3set(:,8),G0tensor(356),G0tensor(357),G0tensor(358), &
    G0tensor(359),M2L1R1,[nMZ],G0tensor(360))
  call TI_triangle_red(G1tensor(114),RedBasis(15),mass3set(:,18),G0tensor(361),G0tensor(362),G0tensor(363), &
    G0tensor(364),M2L1R1,[nMZ],G0tensor(365))
  call TI_triangle_red(G1tensor(118),RedBasis(19),mass3set(:,8),G0tensor(366),G0tensor(367),G0tensor(368), &
    G0tensor(369),M2L1R1,[nMZ],G0tensor(370))
  call TI_triangle_red(G1tensor(128),RedBasis(23),mass3set(:,4),G0tensor(371),G0tensor(372),G0tensor(373), &
    G0tensor(374),M2L1R1,[nMW],G0tensor(375))
  call TI_triangle_red(G1tensor(138),RedBasis(45),mass3set(:,8),G0tensor(376),G0tensor(377),G0tensor(378), &
    G0tensor(379),M2L1R1,[nMZ],G0tensor(380))
  call TI_triangle_red(G1tensor(144),RedBasis(44),mass3set(:,18),G0tensor(381),G0tensor(382),G0tensor(383), &
    G0tensor(384),M2L1R1,[nMZ],G0tensor(385))
  call TI_triangle_red(G1tensor(140),RedBasis(43),mass3set(:,17),G0tensor(386),G0tensor(387),G0tensor(388), &
    G0tensor(389),M2L1R1,[nMZ],G0tensor(390))
  call TI_triangle_red(G1tensor(143),RedBasis(47),mass3set(:,8),G0tensor(391),G0tensor(392),G0tensor(393), &
    G0tensor(394),M2L1R1,[nMZ],G0tensor(395))
  call TI_triangle_red(G1tensor(145),RedBasis(46),mass3set(:,17),G0tensor(396),G0tensor(397),G0tensor(398), &
    G0tensor(399),M2L1R1,[nMZ],G0tensor(400))
  call ol_merge_tensors(T0sum(40),[G0tensor(1)])
  call ol_merge_tensors(T0sum(41),[G0tensor(26)])
  call ol_merge_tensors(T0sum(42),[G0tensor(51)])
  call ol_merge_tensors(T0sum(43),[G0tensor(76)])
  call ol_merge_tensors(T0sum(44),[G0tensor(101)])
  call ol_merge_tensors(T0sum(45),[G0tensor(126)])
  call ol_merge_tensors(T0sum(46),[G0tensor(151)])
  call ol_merge_tensors(T0sum(47),[G0tensor(176)])
  call ol_merge_tensors(T0sum(48),[G0tensor(80)])
  call ol_merge_tensors(T0sum(49),[G0tensor(150)])
  call ol_merge_tensors(T0sum(50),[G0tensor(25)])
  call ol_merge_tensors(T0sum(51),[G0tensor(3)])
  call ol_merge_tensors(T0sum(52),[G0tensor(157)])
  call ol_merge_tensors(T0sum(53),[G0tensor(175)])
  call ol_merge_tensors(T0sum(54),[G0tensor(167)])
  call ol_merge_tensors(T0sum(55),[G0tensor(187)])
  call ol_merge_tensors(T0sum(56),[G0tensor(195)])
  call ol_merge_tensors(T0sum(57),[G0tensor(75)])
  call ol_merge_tensors(T0sum(58),[G0tensor(87)])
  call ol_merge_tensors(T0sum(59),[G0tensor(35)])
  call ol_merge_tensors(T0sum(60),[G0tensor(105)])
  call ol_merge_tensors(T0sum(61),[G0tensor(258)])
  call ol_merge_tensors(T0sum(62),[G0tensor(263)])
  call ol_merge_tensors(T0sum(63),[G0tensor(268)])
  call ol_merge_tensors(T0sum(64),[G0tensor(273)])
  call ol_merge_tensors(T0sum(65),[G0tensor(278)])
  call ol_merge_tensors(T0sum(66),[G0tensor(283)])
  call ol_merge_tensors(T0sum(67),[G0tensor(100)])
  call ol_merge_tensors(T0sum(68),[G0tensor(287)])
  call ol_merge_tensors(T0sum(69),[G0tensor(292)])
  call ol_merge_tensors(T0sum(70),[G0tensor(297)])
  call ol_merge_tensors(T0sum(71),[G0tensor(302)])
  call ol_merge_tensors(T0sum(72),[G0tensor(307)])
  call ol_merge_tensors(T0sum(73),[G0tensor(312)])
  call ol_merge_tensors(T0sum(74),[G0tensor(317)])
  call ol_merge_tensors(T0sum(75),[G0tensor(322)])
  call ol_merge_tensors(T0sum(76),[G0tensor(326)])
  call ol_merge_tensors(T0sum(77),[G0tensor(102)])
  call ol_merge_tensors(T0sum(78),[G0tensor(331)])
  call ol_merge_tensors(T0sum(79),[G0tensor(336)])
  call ol_merge_tensors(T0sum(80),[G0tensor(37)])
  call ol_merge_tensors(T0sum(81),[G0tensor(341)])
  call ol_merge_tensors(T0sum(82),[G0tensor(117)])
  call ol_merge_tensors(T0sum(83),[G0tensor(346)])
  call ol_merge_tensors(T0sum(84),[G0tensor(39)])
  call ol_merge_tensors(T0sum(85),[G0tensor(58)])
  call ol_merge_tensors(T0sum(86),[G0tensor(351)])
  call ol_merge_tensors(T0sum(87),[G0tensor(125)])
  call ol_merge_tensors(T0sum(88),[G0tensor(356)])
  call ol_merge_tensors(T0sum(89),[G0tensor(361)])
  call ol_merge_tensors(T0sum(90),[G0tensor(55)])
  call ol_merge_tensors(T0sum(91),[G0tensor(72)])
  call ol_merge_tensors(T0sum(92),[G0tensor(366)])
  call ol_merge_tensors(T0sum(93),[G0tensor(371)])
  call ol_merge_tensors(T0sum(94),[G0tensor(78)])
  call ol_merge_tensors(T0sum(95),[G0tensor(79)])
  call ol_merge_tensors(T0sum(96),[G0tensor(376)])
  call ol_merge_tensors(T0sum(97),[G0tensor(381)])
  call ol_merge_tensors(T0sum(98),[G0tensor(386)])
  call ol_merge_tensors(T0sum(99),[G0tensor(391)])
  call ol_merge_tensors(T0sum(100),[G0tensor(396)])
  call ol_merge_tensors(T0sum(101),[G0tensor(89)])
  call ol_merge_tensors(T0sum(102),[G0tensor(184)])
  call ol_merge_tensors(T0sum(103),[G0tensor(128)])
  call ol_merge_tensors(T0sum(104),[G0tensor(129)])
  call ol_merge_tensors(T0sum(105),[G0tensor(143)])
  call ol_merge_tensors(T0sum(106),[G0tensor(152)])
  call ol_merge_tensors(T0sum(107),[G0tensor(159)])
  call ol_merge_tensors(T0sum(108),[G0tensor(173)])
  call ol_merge_tensors(T0sum(109),[G0tensor(196)])
  call ol_merge_tensors(T0sum(110),[G0tensor(201)])
  call ol_merge_tensors(T0sum(111),[G0tensor(206)])
  call ol_merge_tensors(T0sum(112),[G0tensor(210)])
  call ol_merge_tensors(T0sum(113),[G0tensor(214)])
  call ol_merge_tensors(T0sum(114),[G0tensor(219)])
  call ol_merge_tensors(T0sum(115),[G0tensor(224)])
  call ol_merge_tensors(T0sum(116),[G0tensor(229)])
  call ol_merge_tensors(T0sum(117),[G0tensor(234)])
  call ol_merge_tensors(T0sum(118),[G0tensor(239)])
  call ol_merge_tensors(T0sum(119),[G0tensor(244)])
  call ol_merge_tensors(T0sum(120),[G0tensor(249)])
  call ol_merge_tensors(T0sum(121),[G0tensor(253)])
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,119),heltab2x32(:,:,145))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,120),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,121),heltab2x32(:,:,147))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,122),heltab2x32(:,:,148))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[28,3],[nMW,nMW],3,2,wf4(:,27),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,27),G0H4(6),m4h2x4x4(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[28,3],[nMW,nMW],3,2,wf4(:,14),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(8),m4h2x4x4(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[28,3],[nMW,nMW],3,2,wf4(:,27),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,27),G0H4(5),m4h2x4x4(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[28,3],[nMW,nMW],3,2,wf4(:,14),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,14),G0H4(7),m4h2x4x4(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(4),m4h2x4x4(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,27))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(1),m4h2x4x4(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,14))
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(2),m4h2x4x4(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[20,11],[0,0],2,2,wf4(:,3),wf8(:,15))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,17),heltab2x32(:,:,149))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[20,11],[nMZ,0],2,2,wf4(:,3),wf8(:,15))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(5),ngZd,m3h4x8(:,18),heltab2x32(:,:,150))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[20,11],[nMW,0],2,2,wf4(:,3),wf8(:,15))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,19),heltab2x32(:,:,151))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[20,11],[0,0],2,2,wf4(:,3),wf8(:,15))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,20),heltab2x32(:,:,152))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[28,3],[0,0],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,11),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(10),n2h4(59))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[28,3],[nMM,nMM],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,12),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G0H4(9),28,nMM,G1H4(15),n2h4(60))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[28,3],[nML,nML],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,13),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G0H4(9),28,nML,G1H4(8),n2h4(61))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[28,3],[0,0],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,14),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(2),n2h4(62))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[28,3],[nMT,nMT],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,15),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G0H4(9),28,nMT,G1H4(5),n2h4(63))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[28,3],[0,0],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,16),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(4),n2h4(64))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[28,3],[nMB,nMB],2,2,wf8(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,17),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(9),28,nMB,G1H4(14),n2h4(65))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZn,m3h8x4(:,18),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(23),n2h4(66))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZl,m3h8x4(:,19),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(24),n2h4(67))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[28,3],[nMM,nMM],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZl,m3h8x4(:,20),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H4(9),28,nMM,G1H4(27),n2h4(68))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[28,3],[nML,nML],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZl,m3h8x4(:,21),heltab2x32(:,:,163))
  call Hloop_Q_A(ntryL,G0H4(9),28,nML,G1H4(28),n2h4(69))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZu,m3h8x4(:,22),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(29),n2h4(70))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[28,3],[nMT,nMT],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZu,m3h8x4(:,23),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H4(9),28,nMT,G1H4(17),n2h4(71))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[28,3],[0,0],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZd,m3h8x4(:,24),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H4(9),28,0,G1H4(16),n2h4(72))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[28,3],[nMB,nMB],2,2,wf8(:,14),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,14),G0H4(9),ngZd,m3h8x4(:,25),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(9),28,nMB,G1H4(30),n2h4(73))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(35),m3h8x4(:,26),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[28,3],[nMH,nMZ],2,2,wf8(:,14),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(7),m3h8x4(:,27),heltab2x32(:,:,169))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(13),m3h8x4(:,28),heltab2x32(:,:,170))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(21),m3h8x4(:,29),heltab2x32(:,:,171))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(26),m3h8x4(:,30),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(31),m3h8x4(:,31),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(36),m3h8x4(:,32),heltab2x32(:,:,174))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,13),28,G1H4(39),m3h8x4(:,33),heltab2x32(:,:,175))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,14),28,G1H4(44),m3h8x4(:,34),heltab2x32(:,:,176))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,13),G0H4(9),m3h8x4(:,35),heltab2x32(:,:,177))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[28,3],[nMW,nMW],2,2,wf8(:,13),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,13),G0H4(10),m3h8x4(:,36),heltab2x32(:,:,178))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[28,3],[nMH,nMZ],2,2,wf8(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(11),m3h8x4(:,37),heltab2x32(:,:,179))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(12),m3h8x4(:,38),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[28,3],[nMW,nMW],2,2,wf8(:,14),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,14),G0H4(13),m3h8x4(:,39),heltab2x32(:,:,181))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[24,7],[0,0],2,2,wf4(:,5),wf8(:,18))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(1),m3h4x8(:,21),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H8(1),24,0,G1H8(2),n2h8(28))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[24,7],[0,nMZ],2,2,wf4(:,5),wf8(:,18))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(4),ngZd,m3h4x8(:,22),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G0H8(4),24,0,G1H8(9),n2h8(29))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[24,7],[0,nMW],2,2,wf4(:,5),wf8(:,18))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,23),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(2),24,0,G1H8(15),n2h8(30))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[24,7],[0,0],2,2,wf4(:,5),wf8(:,18))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,5),G0H8(1),m3h4x8(:,24),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(1),24,0,G1H8(1),n2h8(31))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,40),heltab2x32(:,:,186))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(40),n2h4(74))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[28,3],[nMM,nMM],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,41),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(32),n2h4(75))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[28,3],[nML,nML],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,42),heltab2x32(:,:,188))
  call Hloop_Q_A(ntryL,G0H4(14),28,nML,G1H4(42),n2h4(76))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,43),heltab2x32(:,:,189))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(33),n2h4(77))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[28,3],[nMT,nMT],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,44),heltab2x32(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMT,G1H4(37),n2h4(78))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,45),heltab2x32(:,:,191))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(34),n2h4(79))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[28,3],[nMB,nMB],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,46),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMB,G1H4(20),n2h4(80))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZn,m3h8x4(:,47),heltab2x32(:,:,193))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(19),n2h4(81))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZl,m3h8x4(:,48),heltab2x32(:,:,194))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(11),n2h4(82))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[28,3],[nMM,nMM],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZl,m3h8x4(:,49),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(12),n2h4(83))
  Gcoeff(:)%j = (c(41)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[28,3],[nML,nML],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZl,m3h8x4(:,50),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G0H4(14),28,nML,G1H4(1),n2h4(84))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZu,m3h8x4(:,51),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(6),n2h4(85))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[28,3],[nMT,nMT],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZu,m3h8x4(:,52),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMT,G1H4(9),n2h4(86))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZd,m3h8x4(:,53),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(18),n2h4(87))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[28,3],[nMB,nMB],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,17),G0H4(14),ngZd,m3h8x4(:,54),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMB,G1H4(25),n2h4(88))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(38),m3h8x4(:,55),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[28,3],[nMH,nMZ],2,2,wf8(:,17),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(43),m3h8x4(:,56),heltab2x32(:,:,202))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[28,3],[nMW,nMW],2,2,wf8(:,17),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(41),m3h8x4(:,57),heltab2x32(:,:,203))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(45),m3h8x4(:,58),heltab2x32(:,:,204))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(22),m3h8x4(:,59),heltab2x32(:,:,205))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[28,3],[nMW,nMW],2,2,wf8(:,17),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(3),m3h8x4(:,60),heltab2x32(:,:,206))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[28,3],[nMW,nMW],2,2,wf8(:,17),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(46),m3h8x4(:,61),heltab2x32(:,:,207))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(47),m3h8x4(:,62),heltab2x32(:,:,208))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[28,3],[nMW,nMW],2,2,wf8(:,17),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(48),m3h8x4(:,63),heltab2x32(:,:,209))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,16),G0H4(14),m3h8x4(:,64),heltab2x32(:,:,210))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[28,3],[nMW,nMW],2,2,wf8(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,16),G0H4(15),m3h8x4(:,65),heltab2x32(:,:,211))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[28,3],[nMH,nMZ],2,2,wf8(:,17),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,17),G0H4(16),m3h8x4(:,66),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[28,3],[nMW,nMW],2,2,wf8(:,17),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,17),G0H4(17),m3h8x4(:,67),heltab2x32(:,:,213))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[28,3],[nMW,nMW],2,2,wf8(:,17),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,17),G0H4(18),m3h8x4(:,68),heltab2x32(:,:,214))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(38),G1H4(13),G1H4(35),G0H4(8),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(47),G1H4(44),G1H4(39),G0H4(7),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(7),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(40),G1H4(24),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(32),G1H4(27),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(42),G1H4(28),G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(33),G1H4(29),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(37),G1H4(17),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(34),G1H4(16),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(20),G1H4(30),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(3),G1H4(22),G1H4(45),G1H4(36),G1H4(31),G1H4(26) &
    ,G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(18),[G0H4(17),G0H4(15),G0H4(14),G0H4(13),G0H4(12) &
    ,G0H4(10),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(16),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(2)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(33),wf4(:,1),wf4(:,27),G1tensor(21),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H16(34),wf4(:,1),wf4(:,14),G1tensor(15),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(37),wf4(:,1),wf4(:,27),G1tensor(23),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H16(38),wf4(:,1),wf4(:,14),G1tensor(35),m4h4x4x1(:,4),heltab3x16(:,:,4))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(41),28,wf4(:,1),3,G2tensor(30),m3h4x1(:,78),heltab2x4(:,:,117))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),28,wf4(:,1),3,G2tensor(28),m3h4x1(:,79),heltab2x4(:,:,118))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(4),19,wf4(:,27),12,G1tensor(41),m3h4x1(:,80),heltab2x4(:,:,119))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(3),19,wf4(:,14),12,G1tensor(46),m3h4x1(:,81),heltab2x4(:,:,120))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(1),19,wf4(:,27),12,G1tensor(51),m3h4x1(:,82),heltab2x4(:,:,121))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(2),19,wf4(:,14),12,G1tensor(56),m3h4x1(:,83),heltab2x4(:,:,122))
  call Hloop_VA_Q(ntryL,G0H8(7),wf8(:,15),G0H1(1),m3h8x1(:,9),heltab2x8(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(61),n2h1(117))
  call Hloop_ZA_Q(ntryL,G0H8(5),wf8(:,15),G0H1(1),ngZd,m3h8x1(:,10),heltab2x8(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(66),n2h1(118))
  call Hloop_WA_Q(ntryL,G0H8(6),wf8(:,15),G0H1(1),m3h8x1(:,11),heltab2x8(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(71),n2h1(119))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,84),heltab2x4(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(120))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,85),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(70),n2h1(121))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,86),heltab2x4(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(67),n2h1(122))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,87),heltab2x4(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(123))
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,88),heltab2x4(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(124))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,89),heltab2x4(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(125))
  call Hloop_QZ_A(ntryL,G1H4(25),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,90),heltab2x4(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(126))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,91),heltab2x4(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(127))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(43),28,wf4(:,1),3,G2tensor(61),m3h4x1(:,92),heltab2x4(:,:,131))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(46),28,wf4(:,1),3,G2tensor(40),m3h4x1(:,93),heltab2x4(:,:,132))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(18),wf4(:,1),G0tensor(1),m3h4x1(:,94),heltab2x4(:,:,133))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(16),wf4(:,1),G0tensor(26),m3h4x1(:,95),heltab2x4(:,:,134))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(1),wf8(:,18),G1tensor(76),m3h8x1(:,12),heltab2x8(:,:,61))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(9),wf8(:,18),G1tensor(81),ngZd,m3h8x1(:,13),heltab2x8(:,:,62))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(15),wf8(:,18),G1tensor(86),m3h8x1(:,14),heltab2x8(:,:,63))
  call ol_merge_tensors(G2tensor(40),[G2tensor(28),G2tensor(30),G0tensor(1),G0tensor(53),G0tensor(32),G0tensor(14),G0tensor(7) &
    ,G0tensor(86),G0tensor(6)])
  call ol_merge_tensors(G1tensor(56),[G1tensor(51),G1tensor(46),G1tensor(41),G0tensor(73),G0tensor(63),G0tensor(70),G0tensor(49) &
    ,G0tensor(136),G0tensor(11)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(23),G1tensor(15),G1tensor(21),G0tensor(139),G0tensor(54),G0tensor(38),G0tensor(18) &
    ,G0tensor(66),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(375),[G0tensor(355),G0tensor(350),G0tensor(345),G0tensor(340),G0tensor(335),G0tensor(330) &
    ,G0tensor(301),G0tensor(296),G0tensor(291),G0tensor(228),G0tensor(223),G0tensor(205),G0tensor(200),G0tensor(140),G0tensor(134) &
    ,G0tensor(113),G0tensor(94),G0tensor(98),G0tensor(84),G0tensor(69),G0tensor(62),G0tensor(44),G0tensor(122),G0tensor(120) &
    ,G0tensor(33),G0tensor(28),G0tensor(19),G0tensor(130),G0tensor(97),G0tensor(142),G0tensor(5),G0tensor(192),G0tensor(182) &
    ,G0tensor(162),G0tensor(45),G0tensor(171),G0tensor(146),G0tensor(121),G0tensor(96),G0tensor(71),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(337),[G0tensor(328),G0tensor(203),G0tensor(198),G0tensor(179),G0tensor(137),G0tensor(24) &
    ,G0tensor(31)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(132),G0tensor(36)])
  call ol_merge_tensors(G0tensor(298),[G0tensor(289),G0tensor(109),G0tensor(2),G0tensor(67),G0tensor(56)])



end subroutine vamp_1

end module ol_vamp_1_pplla_ew_nenexddxa_1_/**/REALKIND
