
module ol_vamp_1_pplla_ew_eexaaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplla_ew_eexaaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplla_ew_eexaaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplla_ew_eexaaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplla_ew_eexaaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplla_ew_eexaaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplla_ew_eexaaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(1,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,5),heltab2x32(:,:,5))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(5),n2h16(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(6),n2h16(4))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(9),n2h16(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(10),n2h16(6))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(13),n2h16(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(14),n2h16(8))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,21),heltab2x32(:,:,21))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,22),heltab2x32(:,:,22))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,23),heltab2x32(:,:,23))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,24),heltab2x32(:,:,24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(17),n2h16(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(18),n2h16(10))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(21),n2h16(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(22),n2h16(12))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_SV_V(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_SV_V(ntryL,G0H16(1),ex3(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_UW_V(ntryL,G0H16(2),16,ex3(:),4,G1H8(2),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_UW_V(ntryL,G1H16(4),16,ex3(:),4,G2H8(3),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G1H16(5),ex2(:),G1H8(3),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_Z(ntryL,G1H16(6),ex2(:),G1H8(4),ngZl,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_WA_Q(ntryL,G0H16(3),ex2(:),G0H8(2),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(2),18,0,G1H8(5),n2h8(3))
  call Hloop_WA_Q(ntryL,G1H16(7),ex2(:),G1H8(6),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(6),18,0,G2H8(4),n2h8(4))
  call Hloop_WA_Q(ntryL,G0H16(4),ex2(:),G0H8(2),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(2),18,0,G1H8(6),n2h8(5))
  call Hloop_WA_Q(ntryL,G1H16(8),ex2(:),G1H8(7),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(7),18,0,G2H8(5),n2h8(6))
  call Hloop_QV_A(ntryL,G1H16(9),ex3(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(7),20,0,G2H8(6),n2h8(7))
  call Hloop_QV_A(ntryL,G1H16(10),ex3(:),G1H8(7),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(7),20,0,G2H8(7),n2h8(8))
  call Hloop_SV_V(ntryL,G1H16(11),ex3(:),G1H8(7),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_SV_V(ntryL,G0H16(5),ex3(:),G0H8(2),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_UV_W(ntryL,G0H16(6),16,ex3(:),4,G1H8(8),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_UV_W(ntryL,G1H16(12),16,ex3(:),4,G2H8(8),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(9),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_Z(ntryL,G1H16(14),ex2(:),G1H8(10),ngZl,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_WA_Q(ntryL,G0H16(7),ex2(:),G0H8(3),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(3),18,0,G1H8(11),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(15),ex2(:),G1H8(12),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(9),n2h8(10))
  call Hloop_WA_Q(ntryL,G0H16(8),ex2(:),G0H8(3),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(3),18,0,G1H8(12),n2h8(11))
  call Hloop_WA_Q(ntryL,G1H16(16),ex2(:),G1H8(13),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(13),18,0,G2H8(10),n2h8(12))
  call Hloop_AQ_V(ntryL,G1H16(17),ex1(:),G1H8(13),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(14),ngZl,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_WQ_A(ntryL,G0H16(9),ex1(:),G0H8(3),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(15),n2h8(13))
  call Hloop_WQ_A(ntryL,G1H16(19),ex1(:),G1H8(16),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(11),n2h8(14))
  call Hloop_WQ_A(ntryL,G0H16(10),ex1(:),G0H8(3),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(16),n2h8(15))
  call Hloop_WQ_A(ntryL,G1H16(20),ex1(:),G1H8(17),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(17),17,0,G2H8(12),n2h8(16))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(17),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(18),ngZl,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_WQ_A(ntryL,G0H16(11),ex1(:),G0H8(3),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(19),n2h8(17))
  call Hloop_WQ_A(ntryL,G1H16(23),ex1(:),G1H8(20),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(20),17,0,G2H8(13),n2h8(18))
  call Hloop_WQ_A(ntryL,G0H16(12),ex1(:),G0H8(3),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(20),n2h8(19))
  call Hloop_WQ_A(ntryL,G1H16(24),ex1(:),G1H8(21),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(21),17,0,G2H8(14),n2h8(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(2)])
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(1))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(21),G1H8(1),G1H8(7),G1H8(2),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(4),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZl,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(5),n2h4(3))
  call Hloop_AQ_W(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(6),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_W(ntryL,G1H8(6),ex1(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_W(ntryL,G2H8(5),ex1(:),G2H4(7),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(6),ex2(:),G2H4(8),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_Z(ntryL,G2H8(7),ex2(:),G2H4(9),ngZl,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(3),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(10),n2h4(4))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(2),mass5set(:,1),  & 
G1H8(3),G1H8(4),G1H8(5),G1H8(6),G1H8(8),G1H8(24),8)
  call HG1shiftOLR(G1H8(4),8,8)
  call Hloop_VQ_A(ntryL,G1H8(9),ex1(:),G1H4(3),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(3),19,0,G2H4(11),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex1(:),G1H4(3),ngZl,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(3),19,0,G2H4(12),n2h4(6))
  call Hloop_AQ_W(ntryL,G1H8(11),ex1(:),G1H4(3),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_W(ntryL,G2H8(9),ex1(:),G2H4(13),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_W(ntryL,G1H8(12),ex1(:),G1H4(4),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G2H8(10),ex1(:),G2H4(14),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(5),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(15),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex2(:),G1H4(5),ngZl,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(16),n2h4(8))
  call Hloop_QA_W(ntryL,G1H8(15),ex2(:),G1H4(5),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_W(ntryL,G2H8(11),ex2(:),G2H4(17),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_W(ntryL,G1H8(16),ex2(:),G1H4(6),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(18),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(7),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(19),n2h4(9))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex2(:),G1H4(7),ngZl,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(20),n2h4(10))
  call Hloop_QA_W(ntryL,G1H8(19),ex2(:),G1H4(7),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_W(ntryL,G2H8(13),ex2(:),G2H4(21),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_W(ntryL,G1H8(20),ex2(:),G1H4(8),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_W(ntryL,G2H8(14),ex2(:),G2H4(22),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_WQ_A(ntryL,G1H8(21),ex1(:),G1H4(9),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(23),n2h4(11))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(1),-8,ex4(:),8,G2H4(24),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(9),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(25),n2h4(12))
  call Hloop_WQ_A(ntryL,G1H8(22),ex1(:),G1H4(9),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(26),n2h4(13))
  call Hloop_WQ_A(ntryL,G1H8(23),ex1(:),G1H4(9),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(27),n2h4(14))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(9),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(28),n2h4(15))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(4),-8,ex4(:),8,G2H4(29),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_WA_Q(ntryL,G1H8(6),ex2(:),G1H4(9),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(30),n2h4(16))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(9),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(31),n2h4(17))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(9),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(9),22,0,G2H4(32),n2h4(18))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,2),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,3),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hloop_QA_W(ntryL,G2H4(3),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(3),mass5set(:,2),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(3),mass5set(:,4),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hloop_VV_S(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VV_S(ntryL,G2H4(6),ex3(:),G2H2(2),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_UV_W(ntryL,G1H4(2),19,ex3(:),4,G2H2(3),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,5),  & 
G1H4(1),G1H4(2),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(2),mass5set(:,2),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(2),mass5set(:,3),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hloop_AQ_W(ntryL,G2H4(10),ex1(:),G2H2(4),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(4),mass5set(:,2),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(4),mass5set(:,4),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hloop_VV_S(ntryL,G1H4(3),ex4(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VV_S(ntryL,G2H4(13),ex4(:),G2H2(5),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_UV_W(ntryL,G1H4(4),19,ex4(:),8,G2H2(6),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(4),mass5set(:,5),  & 
G1H4(3),G1H4(4),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(4),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(5),mass5set(:,2),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(5),mass5set(:,4),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hloop_VV_S(ntryL,G1H4(5),ex3(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_VV_S(ntryL,G2H4(17),ex3(:),G2H2(7),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_UW_V(ntryL,G1H4(6),19,ex3(:),4,G2H2(8),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(5),mass5set(:,5),  & 
G1H4(5),G1H4(6),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(6),mass5set(:,2),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(6),mass5set(:,4),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),4,4)
  call Hloop_VV_S(ntryL,G1H4(7),ex4(:),G1H2(4),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VV_S(ntryL,G2H4(21),ex4(:),G2H2(9),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_UW_V(ntryL,G1H4(8),19,ex4(:),8,G2H2(10),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(6),mass5set(:,5),  & 
G1H4(7),G1H4(8),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_QA_W(ntryL,G2H4(23),ex2(:),G2H2(11),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_W(ntryL,G2H4(26),ex2(:),G2H2(12),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_W(ntryL,G2H4(27),ex2(:),G2H2(13),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_W(ntryL,G2H4(28),ex1(:),G2H2(14),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_W(ntryL,G2H4(31),ex1(:),G2H2(15),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_W(ntryL,G2H4(32),ex1(:),G2H2(16),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(17),n2h2(1))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-8,0,G2H4(1),n2h4(19))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(18),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(19),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(14),ex2(:),G1H2(5),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(20),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex2(:),G1H2(5),ngZl,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(21),n2h2(4))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-8,0,G2H4(2),n2h4(20))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(22),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex2(:),G1H2(5),ngZl,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(23),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(20),ex2(:),G1H2(5),ngZl,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(24),n2h2(6))
  call Hloop_QV_A(ntryL,G1H4(21),ex3(:),G1H2(5),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(25),n2h2(7))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-8,0,G2H4(3),n2h4(21))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(26),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(5),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(27),n2h2(8))
  call Hloop_QV_A(ntryL,G1H4(26),ex3(:),G1H2(5),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(28),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(27),ex3(:),G1H2(5),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(29),n2h2(10))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-8,0,G2H4(4),n2h4(22))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(30),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(31),ex3(:),G1H2(5),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(31),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(32),ex3(:),G1H2(5),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(32),n2h2(12))
  call Hloop_UV_W(ntryL,G1H4(1),19,ex3(:),4,G2H2(33),m3h2x2(:,37),heltab2x4(:,:,37))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(2),-8,ex4(:),8,G2H2(34),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_UV_W(ntryL,G1H4(35),19,ex3(:),4,G2H2(35),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_UV_W(ntryL,G1H4(36),19,ex3(:),4,G2H2(36),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(5),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(37),n2h2(13))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-8,0,G2H4(5),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(38),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(5),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(39),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H4(42),ex1(:),G1H2(5),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(40),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(43),ex1(:),G1H2(5),ngZl,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(41),n2h2(16))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,0,G2H4(6),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(42),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex1(:),G1H2(5),ngZl,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(43),n2h2(17))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex1(:),G1H2(5),ngZl,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(44),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(49),ex4(:),G1H2(5),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(45),n2h2(19))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-4,0,G2H4(7),n2h4(26))
  call Hloop_AV_Q(ntryL,G2H4(7),ex3(:),G2H2(46),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QV_A(ntryL,G1H4(53),ex4(:),G1H2(5),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(47),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(54),ex4(:),G1H2(5),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(48),n2h2(21))
  call Hloop_QV_A(ntryL,G1H4(55),ex4(:),G1H2(5),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(49),n2h2(22))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-4,0,G2H4(8),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(8),ex3(:),G2H2(50),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QV_A(ntryL,G1H4(59),ex4(:),G1H2(5),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(51),n2h2(23))
  call Hloop_QV_A(ntryL,G1H4(60),ex4(:),G1H2(5),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(5),27,0,G2H2(52),n2h2(24))
  call Hloop_UV_W(ntryL,G1H4(3),19,ex4(:),8,G2H2(53),m3h2x2(:,57),heltab2x4(:,:,57))
call HGT_raise_alpha_OLR(G1H4(4),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(4),-4,ex3(:),4,G2H2(54),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_UV_W(ntryL,G1H4(63),19,ex4(:),8,G2H2(55),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_UV_W(ntryL,G1H4(64),19,ex4(:),8,G2H2(56),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AV_Q(ntryL,G1H4(65),ex3(:),G1H2(5),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(57),n2h2(25))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(66),-8,0,G2H4(9),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(9),ex4(:),G2H2(58),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_AV_Q(ntryL,G1H4(69),ex3(:),G1H2(5),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(59),n2h2(26))
  call Hloop_AV_Q(ntryL,G1H4(70),ex3(:),G1H2(5),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(60),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H4(71),ex3(:),G1H2(5),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(61),n2h2(28))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(72),-8,0,G2H4(10),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(10),ex4(:),G2H2(62),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AV_Q(ntryL,G1H4(75),ex3(:),G1H2(5),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(63),n2h2(29))
  call Hloop_AV_Q(ntryL,G1H4(76),ex3(:),G1H2(5),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(5),23,0,G2H2(64),n2h2(30))
  call Hloop_UW_V(ntryL,G1H4(5),19,ex3(:),4,G2H2(65),m3h2x2(:,69),heltab2x4(:,:,69))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(6),-8,ex4(:),8,G2H2(66),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UW_V(ntryL,G1H4(79),19,ex3(:),4,G2H2(67),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_UW_V(ntryL,G1H4(80),19,ex3(:),4,G2H2(68),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AV_Q(ntryL,G1H4(81),ex4(:),G1H2(5),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(69),n2h2(31))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-4,0,G2H4(11),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(11),ex3(:),G2H2(70),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AV_Q(ntryL,G1H4(85),ex4(:),G1H2(5),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(71),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H4(86),ex4(:),G1H2(5),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(72),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(87),ex4(:),G1H2(5),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(73),n2h2(34))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-4,0,G2H4(12),n2h4(33))
  call Hloop_QV_A(ntryL,G2H4(12),ex3(:),G2H2(74),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AV_Q(ntryL,G1H4(91),ex4(:),G1H2(5),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(75),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H4(92),ex4(:),G1H2(5),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(5),27,0,G2H2(76),n2h2(36))
  call Hloop_UW_V(ntryL,G1H4(7),19,ex4(:),8,G2H2(77),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(8),-4,ex3(:),4,G2H2(78),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_UW_V(ntryL,G1H4(95),19,ex4(:),8,G2H2(79),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_UW_V(ntryL,G1H4(96),19,ex4(:),8,G2H2(80),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(1),23,ex4(:),8,G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(2),27,ex3(:),4,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(3),23,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(4),27,ex3(:),4,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(1),mass5set(:,1),  & 
G1H2(5),G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(6),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),10,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(2),mass5set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(2),mass4set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),9,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,2),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(1),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),10,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(1),mass5set(:,3),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(1),mass4set(:,3),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),10,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(3),mass5set(:,2),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(3),mass4set(:,2),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),12,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(3),mass5set(:,4),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(3),mass4set(:,4),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),12,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(3),mass5set(:,5),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(3),mass4set(:,5),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(74),12,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(2),mass5set(:,2),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(79),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,2),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(85),9,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(2),mass5set(:,3),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(2),mass4set(:,3),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(96),9,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(4),mass5set(:,2),  & 
G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),2)
  call HG1shiftOLR(G1H2(101),4,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(3),mass4set(:,2),  & 
G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(107),12,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(4),mass5set(:,4),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),4,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(3),mass4set(:,4),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(118),12,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(4),mass5set(:,5),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(123),4,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(3),mass4set(:,5),  & 
G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(129),12,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(5),mass5set(:,2),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(4),mass4set(:,2),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(140),12,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(5),mass5set(:,4),  & 
G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(145),8,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(4),mass4set(:,4),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(151),12,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(5),mass5set(:,5),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(156),8,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(4),mass4set(:,5),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),2)
  call HG1shiftOLR(G1H2(162),12,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(6),mass5set(:,2),  & 
G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(167),4,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(4),mass4set(:,2),  & 
G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(173),12,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(6),mass5set(:,4),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),4,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(4),mass4set(:,4),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),2)
  call HG1shiftOLR(G1H2(184),12,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(6),mass5set(:,5),  & 
G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(189),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(4),mass4set(:,5),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(195),12,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(161),[G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(172),[G1H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(183),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(193)])
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(5),23,ex4(:),8,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(1),0,ex4(:),8,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(7),23,ex4(:),8,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(8),2,ex4(:),8,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(13),0,ex4(:),8,G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),23,ex4(:),8,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),1,ex4(:),8,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_AV_Q(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(26),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(30),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(34),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(38),n2h1(20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(67),23,ex4(:),8,G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(68),0,ex4(:),8,G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(73),23,ex4(:),8,G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(74),4,ex4(:),8,G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(44),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(46),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(48),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(50),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(101),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(52),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(106),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(107),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(54),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(111),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(112),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(56),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(117),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(58),n2h1(38))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(122),27,ex3(:),4,G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(123),0,ex3(:),4,G2tensor(60),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(128),27,ex3(:),4,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(129),8,ex3(:),4,G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hloop_AV_Q(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(139),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(66),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(70),n2h1(48))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(155),23,ex4(:),8,G2tensor(71),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(156),0,ex4(:),8,G2tensor(72),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(161),23,ex4(:),8,G2tensor(73),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(162),4,ex4(:),8,G2tensor(74),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hloop_AV_Q(ntryL,G1H2(166),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(172),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(173),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(78),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(177),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(80),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(183),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(82),n2h1(58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(188),27,ex3(:),4,G2tensor(83),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(189),0,ex3(:),4,G2tensor(84),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(194),27,ex3(:),4,G2tensor(85),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(195),8,ex3(:),4,G2tensor(86),m3h2x1(:,86),heltab2x2(:,:,86))
  call ol_merge_tensors(G2tensor(15),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(4),G2tensor(3),G2tensor(2)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(8),G2tensor(7),G2tensor(6)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(11),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(14),G2tensor(13),G2tensor(12)])
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,5),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(4),mass5set(:,5),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(5),mass5set(:,5),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(6),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(1),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(1),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(3),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(3),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(2),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(2),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(4),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(4),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(5),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(5),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(6),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(6),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(2),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(4),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMM,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(3),16,nML,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(4),16,0,G1H16(6),n2h16(16))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMM,G1H16(7),n2h16(17))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(6),16,nML,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(7),16,0,G1H16(9),n2h16(19))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMT,G1H16(10),n2h16(20))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(11),n2h16(21))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(10),16,nMT,G1H16(12),n2h16(22))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(11),16,0,G1H16(13),n2h16(23))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMB,G1H16(14),n2h16(24))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(25))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(16),n2h16(26))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(17),n2h16(27))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMM,G1H16(18),n2h16(28))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(5),16,nML,G1H16(19),n2h16(29))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(6),16,0,G1H16(20),n2h16(30))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMM,G1H16(21),n2h16(31))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(8),16,nML,G1H16(22),n2h16(32))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(23),n2h16(33))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(10),16,nMT,G1H16(24),n2h16(34))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(25),n2h16(35))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMT,G1H16(26),n2h16(36))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(37))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMB,G1H16(28),n2h16(38))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(3),16,0,G1H16(29),n2h16(39))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(30),n2h16(40))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,67),heltab2x32(:,:,67))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,68),heltab2x32(:,:,68))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,69),heltab2x32(:,:,69))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,71),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(36),m3h2x16(:,72),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,73),heltab2x32(:,:,73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(38),m3h2x16(:,74),heltab2x32(:,:,74))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(40),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(42),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,81),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,82),heltab2x32(:,:,82))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,84),heltab2x32(:,:,84))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,85),heltab2x32(:,:,85))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,89),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,91),heltab2x32(:,:,91))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,93),heltab2x32(:,:,93))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,94),heltab2x32(:,:,94))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,95),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,96),heltab2x32(:,:,96))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,100),heltab2x32(:,:,100))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,101),heltab2x32(:,:,101))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,102),heltab2x32(:,:,102))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,104),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,105),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,107),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,112),heltab2x32(:,:,112))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,113),heltab2x32(:,:,113))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,114),heltab2x32(:,:,114))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,115),heltab2x32(:,:,115))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,116),heltab2x32(:,:,116))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,117),heltab2x32(:,:,117))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,120),heltab2x32(:,:,120))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,123),heltab2x32(:,:,123))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,124),heltab2x32(:,:,124))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,125),heltab2x32(:,:,125))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,127),heltab2x32(:,:,127))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,128),heltab2x32(:,:,128))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,129),heltab2x32(:,:,129))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,130),heltab2x32(:,:,130))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,131),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,132),heltab2x32(:,:,132))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,133),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,135),heltab2x32(:,:,135))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,136),heltab2x32(:,:,136))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(71),n2h16(41))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMM,G1H16(72),n2h16(42))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(73),n2h16(43))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(74),n2h16(44))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMM,G1H16(75),n2h16(45))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(33),16,nML,G1H16(76),n2h16(46))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(77),n2h16(47))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(78),n2h16(48))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(79),n2h16(49))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMT,G1H16(80),n2h16(50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(81),n2h16(51))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(82),n2h16(52))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(83),n2h16(53))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMB,G1H16(84),n2h16(54))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(85),n2h16(55))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMM,G1H16(86),n2h16(56))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(33),16,nML,G1H16(87),n2h16(57))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(88),n2h16(58))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMM,G1H16(89),n2h16(59))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H16(33),16,nML,G1H16(90),n2h16(60))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(91),n2h16(61))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(92),n2h16(62))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(93),n2h16(63))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMT,G1H16(94),n2h16(64))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G0H16(33),16,0,G1H16(95),n2h16(65))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(96),n2h16(66))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H16(33),16,0,G1H16(97),n2h16(67))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H16(33),16,nMB,G1H16(98),n2h16(68))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,170),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(103),m3h2x16(:,171),heltab2x32(:,:,171))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,172),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(105),m3h2x16(:,173),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,174),heltab2x32(:,:,174))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(107),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,176),heltab2x32(:,:,176))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(109),m3h2x16(:,177),heltab2x32(:,:,177))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,178),heltab2x32(:,:,178))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,179),heltab2x32(:,:,179))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,180),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,181),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,182),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,183),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,184),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,186),heltab2x32(:,:,186))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,187),heltab2x32(:,:,187))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,188),heltab2x32(:,:,188))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,189),heltab2x32(:,:,189))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,190),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,191),heltab2x32(:,:,191))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,192),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,193),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,194),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,195),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,196),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,197),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,198),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,199),heltab2x32(:,:,199))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,200),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,201),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,202),heltab2x32(:,:,202))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,203),heltab2x32(:,:,203))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,204),heltab2x32(:,:,204))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,205),heltab2x32(:,:,205))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,206),heltab2x32(:,:,206))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,207),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,208),heltab2x32(:,:,208))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,209),heltab2x32(:,:,209))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,210),heltab2x32(:,:,210))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,211),heltab2x32(:,:,211))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,212),heltab2x32(:,:,212))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,213),heltab2x32(:,:,213))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,214),heltab2x32(:,:,214))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,215),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,216),heltab2x32(:,:,216))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,217),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,218),heltab2x32(:,:,218))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,219),heltab2x32(:,:,219))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(128),m3h2x16(:,220),heltab2x32(:,:,220))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(129),m3h2x16(:,221),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(130),m3h2x16(:,222),heltab2x32(:,:,222))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(131),m3h2x16(:,223),heltab2x32(:,:,223))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,224),heltab2x32(:,:,224))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(133),m3h2x16(:,225),heltab2x32(:,:,225))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(134),m3h2x16(:,226),heltab2x32(:,:,226))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(135),m3h2x16(:,227),heltab2x32(:,:,227))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(136),m3h2x16(:,228),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(137),m3h2x16(:,229),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,230),heltab2x32(:,:,230))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,231),heltab2x32(:,:,231))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,232),heltab2x32(:,:,232))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,233),heltab2x32(:,:,233))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,234),heltab2x32(:,:,234))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,235),heltab2x32(:,:,235))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,236),heltab2x32(:,:,236))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,237),heltab2x32(:,:,237))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,238),heltab2x32(:,:,238))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,239),heltab2x32(:,:,239))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(139),n2h16(69))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,240),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMM,G1H16(140),n2h16(70))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,241),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G0H16(65),16,nML,G1H16(141),n2h16(71))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(142),n2h16(72))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMM,G1H16(143),n2h16(73))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(65),16,nML,G1H16(144),n2h16(74))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(145),n2h16(75))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMT,G1H16(146),n2h16(76))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(147),n2h16(77))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMT,G1H16(148),n2h16(78))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(149),n2h16(79))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,250),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMB,G1H16(150),n2h16(80))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,251),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(151),n2h16(81))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,252),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMB,G1H16(152),n2h16(82))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(153),n2h16(83))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMM,G1H16(154),n2h16(84))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G0H16(65),16,nML,G1H16(155),n2h16(85))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(156),n2h16(86))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMM,G1H16(157),n2h16(87))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(65),16,nML,G1H16(158),n2h16(88))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(159),n2h16(89))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMT,G1H16(160),n2h16(90))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,261),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(161),n2h16(91))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,262),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMT,G1H16(162),n2h16(92))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,263),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G0H16(65),16,0,G1H16(163),n2h16(93))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMB,G1H16(164),n2h16(94))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(65),16,0,G1H16(165),n2h16(95))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMB,G1H16(166),n2h16(96))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,267),heltab2x32(:,:,267))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,268),heltab2x32(:,:,268))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,269),heltab2x32(:,:,269))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,270),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,271),heltab2x32(:,:,271))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(172),m3h2x16(:,272),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,273),heltab2x32(:,:,273))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(174),m3h2x16(:,274),heltab2x32(:,:,274))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,275),heltab2x32(:,:,275))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(176),m3h2x16(:,276),heltab2x32(:,:,276))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,277),heltab2x32(:,:,277))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(178),m3h2x16(:,278),heltab2x32(:,:,278))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(179),m3h2x16(:,279),heltab2x32(:,:,279))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(180),m3h2x16(:,280),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(181),m3h2x16(:,281),heltab2x32(:,:,281))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(182),m3h2x16(:,282),heltab2x32(:,:,282))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(183),m3h2x16(:,283),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(184),m3h2x16(:,284),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(185),m3h2x16(:,285),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(186),m3h2x16(:,286),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,287),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,288),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,289),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,290),heltab2x32(:,:,290))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(187),m3h2x16(:,291),heltab2x32(:,:,291))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(188),m3h2x16(:,292),heltab2x32(:,:,292))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(189),m3h2x16(:,293),heltab2x32(:,:,293))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(190),m3h2x16(:,294),heltab2x32(:,:,294))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,295),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,296),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,297),heltab2x32(:,:,297))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,298),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,299),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,300),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,301),heltab2x32(:,:,301))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,302),heltab2x32(:,:,302))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(191),m3h2x16(:,303),heltab2x32(:,:,303))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(192),m3h2x16(:,304),heltab2x32(:,:,304))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(193),m3h2x16(:,305),heltab2x32(:,:,305))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(194),m3h2x16(:,306),heltab2x32(:,:,306))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,307),heltab2x32(:,:,307))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,308),heltab2x32(:,:,308))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,309),heltab2x32(:,:,309))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,310),heltab2x32(:,:,310))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,311),heltab2x32(:,:,311))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,312),heltab2x32(:,:,312))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,313),heltab2x32(:,:,313))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,314),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(195),m3h2x16(:,315),heltab2x32(:,:,315))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(196),m3h2x16(:,316),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(197),m3h2x16(:,317),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(198),m3h2x16(:,318),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,319),heltab2x32(:,:,319))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,320),heltab2x32(:,:,320))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,321),heltab2x32(:,:,321))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,322),heltab2x32(:,:,322))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,323),heltab2x32(:,:,323))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,324),heltab2x32(:,:,324))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,325),heltab2x32(:,:,325))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,326),heltab2x32(:,:,326))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(199),m3h2x16(:,327),heltab2x32(:,:,327))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(200),m3h2x16(:,328),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(201),m3h2x16(:,329),heltab2x32(:,:,329))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(202),m3h2x16(:,330),heltab2x32(:,:,330))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,331),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,332),heltab2x32(:,:,332))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,333),heltab2x32(:,:,333))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,334),heltab2x32(:,:,334))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(203),m3h2x16(:,335),heltab2x32(:,:,335))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(204),m3h2x16(:,336),heltab2x32(:,:,336))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(205),m3h2x16(:,337),heltab2x32(:,:,337))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(206),m3h2x16(:,338),heltab2x32(:,:,338))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,5,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,339),heltab2x32(:,:,339))
  call Hloop_A_Q(ntryL,G0H16(97),16,0,G1H16(207),n2h16(97))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,5,2,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,340),heltab2x32(:,:,340))
  call Hloop_A_Q(ntryL,G0H16(97),16,0,G1H16(208),n2h16(98))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,341),heltab2x32(:,:,341))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,5,2,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(209),m3h2x16(:,342),heltab2x32(:,:,342))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,2,5,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H16(98),16,0,G1H16(210),n2h16(99))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,2,5,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H16(98),16,0,G1H16(211),n2h16(100))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,345),heltab2x32(:,:,345))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,2,5,8],[nMW,0,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,346),heltab2x32(:,:,346))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,6,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G0H16(99),16,0,G1H16(213),n2h16(101))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,6,1,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G0H16(99),16,0,G1H16(214),n2h16(102))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,349),heltab2x32(:,:,349))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,6,1,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(215),m3h2x16(:,350),heltab2x32(:,:,350))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,1,6,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,351),heltab2x32(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(100),16,0,G1H16(216),n2h16(103))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,1,6,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(100),16,0,G1H16(217),n2h16(104))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,353),heltab2x32(:,:,353))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,1,6,8],[nMW,0,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,354),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,4,2,9],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H16(101),16,0,G1H16(219),n2h16(105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,4,2,9],[0,0,nMZ,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G0H16(101),16,0,G1H16(220),n2h16(106))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,357),heltab2x32(:,:,357))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,358),heltab2x32(:,:,358))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,2,9,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H16(102),16,0,G1H16(222),n2h16(107))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,2,9,4],[0,nMZ,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,360),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G0H16(102),16,0,G1H16(223),n2h16(108))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,361),heltab2x32(:,:,361))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,362),heltab2x32(:,:,362))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,4,1,10],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(103),16,0,G1H16(225),n2h16(109))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,4,1,10],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(103),16,0,G1H16(226),n2h16(110))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,365),heltab2x32(:,:,365))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,366),heltab2x32(:,:,366))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,1,10,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(104),16,0,G1H16(228),n2h16(111))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,1,10,4],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(104),16,0,G1H16(229),n2h16(112))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,369),heltab2x32(:,:,369))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,370),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[17,2,4,8],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,1),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(6),ngZl,m3h4x8(:,2),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,3),heltab2x32(:,:,373))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(9),n2h8(23))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,4),heltab2x32(:,:,374))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(10),n2h8(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[17,2,8,4],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,5),heltab2x32(:,:,375))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(8),ngZl,m3h4x8(:,6),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,7),heltab2x32(:,:,377))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(11),n2h8(25))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,8),heltab2x32(:,:,378))
  call Hloop_Q_A(ntryL,G0H8(9),17,0,G1H8(12),n2h8(26))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[18,1,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,9),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(10),ngZl,m3h4x8(:,10),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,11),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H8(11),18,0,G1H8(13),n2h8(27))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,12),heltab2x32(:,:,382))
  call Hloop_A_Q(ntryL,G0H8(11),18,0,G1H8(14),n2h8(28))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[18,1,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,13),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngZl,m3h4x8(:,14),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,15),heltab2x32(:,:,385))
  call Hloop_A_Q(ntryL,G0H8(13),18,0,G1H8(15),n2h8(29))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,16),heltab2x32(:,:,386))
  call Hloop_A_Q(ntryL,G0H8(13),18,0,G1H8(16),n2h8(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(9),G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(11),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(14),[G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(16),[G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(18),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(77),G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(83),[G1H16(79),G1H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(105),[G1H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G1H16(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(109),[G1H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(46),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(50),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(52),[G0H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(149),[G1H16(145),G1H16(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(151),[G1H16(147),G1H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(173),[G1H16(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(174),[G1H16(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(177),[G1H16(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(178),[G1H16(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(78),[G0H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(80),[G0H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(82),[G0H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(84),[G0H16(83)])
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(9),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(9),21,0,G2H4(13),n2h4(35))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(10),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(10),22,0,G2H4(14),n2h4(36))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(13),n2h4(37))
  call Hloop_WQ_A(ntryL,G0H8(1),ex1(:),G0H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(14),n2h4(38))
  call Hloop_WQ_A(ntryL,G1H16(1),ex1(:),G1H8(17),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(17),17,0,G2H8(1),n2h8(31))
  call Hloop_WA_Q(ntryL,G1H16(2),ex2(:),G1H8(18),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(18),18,0,G2H8(2),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,13),G1H4(15),m3h4x4(:,1),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(15),19,0,G2H4(15),n2h4(39))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,13),G1H4(16),m3h4x4(:,2),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMM,G2H4(16),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,13),G1H4(19),m3h4x4(:,3),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(19),19,nML,G2H4(17),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,13),G1H4(20),m3h4x4(:,4),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(20),19,0,G2H4(18),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,13),G1H4(21),m3h4x4(:,5),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(21),19,nMM,G2H4(19),n2h4(43))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,13),G1H4(22),m3h4x4(:,6),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(22),19,nML,G2H4(20),n2h4(44))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,13),G1H4(25),m3h4x4(:,7),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(25),19,nMT,G2H4(21),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,13),G1H4(26),m3h4x4(:,8),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(26),19,nMT,G2H4(22),n2h4(46))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,13),G1H4(27),m3h4x4(:,9),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(27),19,nMB,G2H4(23),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H16(16),wf4(:,13),G1H4(28),m3h4x4(:,10),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(28),19,nMB,G2H4(26),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,14),G1H4(31),ngZl,m3h4x4(:,11),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(31),19,0,G2H4(27),n2h4(49))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,14),G1H4(32),ngZl,m3h4x4(:,12),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(32),19,nMM,G2H4(28),n2h4(50))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,14),G1H4(1),ngZl,m3h4x4(:,13),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(31),n2h4(51))
  call Hloop_AZ_Q(ntryL,G1H16(20),wf4(:,14),G1H4(2),ngZl,m3h4x4(:,14),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(2),19,0,G2H4(32),n2h4(52))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,14),G1H4(35),ngZl,m3h4x4(:,15),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(35),19,nMM,G2H4(1),n2h4(53))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,14),G1H4(36),ngZl,m3h4x4(:,16),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(36),19,nML,G2H4(2),n2h4(54))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,14),G1H4(37),ngZu,m3h4x4(:,17),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(37),19,0,G2H4(3),n2h4(55))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,14),G1H4(38),ngZu,m3h4x4(:,18),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(38),19,nMT,G2H4(4),n2h4(56))
  call Hloop_AZ_Q(ntryL,G1H16(25),wf4(:,14),G1H4(41),ngZu,m3h4x4(:,19),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(41),19,0,G2H4(5),n2h4(57))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,14),G1H4(42),ngZu,m3h4x4(:,20),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(42),19,nMT,G2H4(6),n2h4(58))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,14),G1H4(43),ngZd,m3h4x4(:,21),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(43),19,0,G2H4(7),n2h4(59))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,14),G1H4(44),ngZd,m3h4x4(:,22),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(44),19,nMB,G2H4(8),n2h4(60))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,14),G1H4(47),ngZd,m3h4x4(:,23),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(47),19,0,G2H4(9),n2h4(61))
  call Hloop_AZ_Q(ntryL,G1H16(30),wf4(:,14),G1H4(48),ngZd,m3h4x4(:,24),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(48),19,nMB,G2H4(10),n2h4(62))
  call Hloop_TV_S(ntryL,G1H16(31),16,wf4(:,13),3,G2H4(11),m3h4x4(:,25),heltab2x16(:,:,63))
  call Hloop_SV_T(ntryL,G1H16(32),16,wf4(:,13),3,G2H4(12),m3h4x4(:,26),heltab2x16(:,:,64))
  call Hloop_TV_S(ntryL,G1H16(33),16,wf4(:,14),3,G2H4(33),m3h4x4(:,27),heltab2x16(:,:,65))
  call Hloop_SV_T(ntryL,G1H16(34),16,wf4(:,14),3,G2H4(34),m3h4x4(:,28),heltab2x16(:,:,66))
  call Hloop_CV_D(ntryL,G1H16(37),16,wf4(:,13),3,G2H4(35),m3h4x4(:,29),heltab2x16(:,:,67))
  call Hloop_DV_C(ntryL,G1H16(38),16,wf4(:,13),G2H4(36),m3h4x4(:,30),heltab2x16(:,:,68))
  call Hloop_CV_D(ntryL,G1H16(41),16,wf4(:,14),3,G2H4(37),m3h4x4(:,31),heltab2x16(:,:,69))
  call Hloop_DV_C(ntryL,G1H16(42),16,wf4(:,14),G2H4(38),m3h4x4(:,32),heltab2x16(:,:,70))
  call Hloop_UV_W(ntryL,G1H16(43),16,wf4(:,13),3,G2H4(39),m3h4x4(:,33),heltab2x16(:,:,71))
  call Hloop_UW_V(ntryL,G1H16(44),16,wf4(:,13),3,G2H4(40),m3h4x4(:,34),heltab2x16(:,:,72))
  call Hloop_UV_W(ntryL,G1H16(45),16,wf4(:,14),3,G2H4(41),m3h4x4(:,35),heltab2x16(:,:,73))
  call Hloop_UW_V(ntryL,G1H16(46),16,wf4(:,14),3,G2H4(42),m3h4x4(:,36),heltab2x16(:,:,74))
  call Hloop_VV_S(ntryL,G0H16(5),wf4(:,13),G0H4(1),m3h4x4(:,37),heltab2x16(:,:,75))
  call Hloop_VV_S(ntryL,G0H16(6),wf4(:,13),G0H4(2),m3h4x4(:,38),heltab2x16(:,:,76))
  call Hloop_VV_S(ntryL,G0H16(7),wf4(:,14),G0H4(3),m3h4x4(:,39),heltab2x16(:,:,77))
  call Hloop_VV_S(ntryL,G0H16(8),wf4(:,14),G0H4(4),m3h4x4(:,40),heltab2x16(:,:,78))
  call Hloop_SV_V(ntryL,G1H16(47),wf4(:,13),G1H4(49),m3h4x4(:,41),heltab2x16(:,:,79))
  call Hloop_SV_V(ntryL,G1H16(48),wf4(:,13),G1H4(50),m3h4x4(:,42),heltab2x16(:,:,80))
  call Hloop_SV_V(ntryL,G1H16(49),wf4(:,14),G1H4(53),m3h4x4(:,43),heltab2x16(:,:,81))
  call Hloop_SV_V(ntryL,G1H16(50),wf4(:,14),G1H4(54),m3h4x4(:,44),heltab2x16(:,:,82))
  call Hloop_TV_S(ntryL,G0H16(9),16,wf4(:,13),3,G1H4(55),m3h4x4(:,45),heltab2x16(:,:,83))
  call Hloop_SV_T(ntryL,G0H16(10),16,wf4(:,13),3,G1H4(56),m3h4x4(:,46),heltab2x16(:,:,84))
  call Hloop_TV_S(ntryL,G0H16(11),16,wf4(:,14),3,G1H4(59),m3h4x4(:,47),heltab2x16(:,:,85))
  call Hloop_SV_T(ntryL,G0H16(12),16,wf4(:,14),3,G1H4(60),m3h4x4(:,48),heltab2x16(:,:,86))
  call Hloop_TV_S(ntryL,G1H16(51),16,wf4(:,13),3,G2H4(43),m3h4x4(:,49),heltab2x16(:,:,87))
  call Hloop_SV_T(ntryL,G1H16(52),16,wf4(:,13),3,G2H4(44),m3h4x4(:,50),heltab2x16(:,:,88))
  call Hloop_TV_S(ntryL,G1H16(53),16,wf4(:,14),3,G2H4(45),m3h4x4(:,51),heltab2x16(:,:,89))
  call Hloop_SV_T(ntryL,G1H16(54),16,wf4(:,14),3,G2H4(46),m3h4x4(:,52),heltab2x16(:,:,90))
  call Hloop_UV_W(ntryL,G0H16(1),16,wf4(:,13),3,G1H4(3),m3h4x4(:,53),heltab2x16(:,:,91))
  call Hloop_UW_V(ntryL,G0H16(2),16,wf4(:,13),3,G1H4(4),m3h4x4(:,54),heltab2x16(:,:,92))
  call Hloop_UV_W(ntryL,G0H16(3),16,wf4(:,14),3,G1H4(63),m3h4x4(:,55),heltab2x16(:,:,93))
  call Hloop_UW_V(ntryL,G0H16(4),16,wf4(:,14),3,G1H4(64),m3h4x4(:,56),heltab2x16(:,:,94))
  call Hloop_VV_S(ntryL,G1H16(55),wf4(:,13),G1H4(65),m3h4x4(:,57),heltab2x16(:,:,95))
  call Hloop_VV_S(ntryL,G1H16(56),wf4(:,13),G1H4(66),m3h4x4(:,58),heltab2x16(:,:,96))
  call Hloop_VV_S(ntryL,G1H16(57),wf4(:,14),G1H4(69),m3h4x4(:,59),heltab2x16(:,:,97))
  call Hloop_VV_S(ntryL,G1H16(58),wf4(:,14),G1H4(70),m3h4x4(:,60),heltab2x16(:,:,98))
  call Hloop_SV_V(ntryL,G0H16(14),wf4(:,13),G0H4(5),m3h4x4(:,61),heltab2x16(:,:,99))
  call Hloop_SV_V(ntryL,G0H16(16),wf4(:,14),G0H4(6),m3h4x4(:,62),heltab2x16(:,:,100))
  call Hloop_VV_S(ntryL,G0H16(18),wf4(:,13),G0H4(7),m3h4x4(:,63),heltab2x16(:,:,101))
  call Hloop_VV_S(ntryL,G0H16(20),wf4(:,14),G0H4(8),m3h4x4(:,64),heltab2x16(:,:,102))
  call Hloop_SV_V(ntryL,G1H16(59),wf4(:,13),G1H4(71),m3h4x4(:,65),heltab2x16(:,:,103))
  call Hloop_SV_V(ntryL,G1H16(60),wf4(:,13),G1H4(72),m3h4x4(:,66),heltab2x16(:,:,104))
  call Hloop_SV_V(ntryL,G1H16(61),wf4(:,14),G1H4(75),m3h4x4(:,67),heltab2x16(:,:,105))
  call Hloop_SV_V(ntryL,G1H16(62),wf4(:,14),G1H4(76),m3h4x4(:,68),heltab2x16(:,:,106))
  call Hloop_TV_S(ntryL,G0H16(21),16,wf4(:,13),3,G1H4(5),m3h4x4(:,69),heltab2x16(:,:,107))
  call Hloop_SV_T(ntryL,G0H16(22),16,wf4(:,13),3,G1H4(6),m3h4x4(:,70),heltab2x16(:,:,108))
  call Hloop_TV_S(ntryL,G0H16(23),16,wf4(:,14),3,G1H4(79),m3h4x4(:,71),heltab2x16(:,:,109))
  call Hloop_SV_T(ntryL,G0H16(24),16,wf4(:,14),3,G1H4(80),m3h4x4(:,72),heltab2x16(:,:,110))
  call Hloop_UV_W(ntryL,G1H16(63),16,wf4(:,13),3,G2H4(47),m3h4x4(:,73),heltab2x16(:,:,111))
  call Hloop_UW_V(ntryL,G1H16(64),16,wf4(:,13),3,G2H4(48),m3h4x4(:,74),heltab2x16(:,:,112))
  call Hloop_UV_W(ntryL,G1H16(65),16,wf4(:,14),3,G2H4(49),m3h4x4(:,75),heltab2x16(:,:,113))
  call Hloop_UW_V(ntryL,G1H16(66),16,wf4(:,14),3,G2H4(50),m3h4x4(:,76),heltab2x16(:,:,114))
  call Hloop_UV_W(ntryL,G0H16(25),16,wf4(:,13),3,G1H4(81),m3h4x4(:,77),heltab2x16(:,:,115))
  call Hloop_UW_V(ntryL,G0H16(26),16,wf4(:,13),3,G1H4(82),m3h4x4(:,78),heltab2x16(:,:,116))
  call Hloop_UV_W(ntryL,G0H16(27),16,wf4(:,14),3,G1H4(85),m3h4x4(:,79),heltab2x16(:,:,117))
  call Hloop_UW_V(ntryL,G0H16(28),16,wf4(:,14),3,G1H4(86),m3h4x4(:,80),heltab2x16(:,:,118))
  call Hloop_VV_S(ntryL,G1H16(67),wf4(:,13),G1H4(87),m3h4x4(:,81),heltab2x16(:,:,119))
  call Hloop_VV_S(ntryL,G1H16(68),wf4(:,13),G1H4(88),m3h4x4(:,82),heltab2x16(:,:,120))
  call Hloop_VV_S(ntryL,G1H16(69),wf4(:,14),G1H4(91),m3h4x4(:,83),heltab2x16(:,:,121))
  call Hloop_VV_S(ntryL,G1H16(70),wf4(:,14),G1H4(92),m3h4x4(:,84),heltab2x16(:,:,122))
  call Hloop_SV_V(ntryL,G0H16(29),wf4(:,13),G0H4(9),m3h4x4(:,85),heltab2x16(:,:,123))
  call Hloop_SV_V(ntryL,G0H16(30),wf4(:,13),G0H4(10),m3h4x4(:,86),heltab2x16(:,:,124))
  call Hloop_SV_V(ntryL,G0H16(31),wf4(:,14),G0H4(11),m3h4x4(:,87),heltab2x16(:,:,125))
  call Hloop_SV_V(ntryL,G0H16(32),wf4(:,14),G0H4(12),m3h4x4(:,88),heltab2x16(:,:,126))
  call Hloop_AV_Q(ntryL,G1H16(81),wf4(:,13),G1H4(7),m3h4x4(:,89),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(7),19,0,G2H4(51),n2h4(63))
  call Hloop_AV_Q(ntryL,G1H16(72),wf4(:,13),G1H4(8),m3h4x4(:,90),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(8),19,nMM,G2H4(52),n2h4(64))
  call Hloop_AV_Q(ntryL,G1H16(73),wf4(:,13),G1H4(95),m3h4x4(:,91),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(95),19,nML,G2H4(53),n2h4(65))
  call Hloop_QV_A(ntryL,G1H16(83),wf4(:,13),G1H4(96),m3h4x4(:,92),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(96),19,0,G2H4(54),n2h4(66))
  call Hloop_QV_A(ntryL,G1H16(75),wf4(:,13),G1H4(9),m3h4x4(:,93),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMM,G2H4(55),n2h4(67))
  call Hloop_QV_A(ntryL,G1H16(76),wf4(:,13),G1H4(10),m3h4x4(:,94),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(10),19,nML,G2H4(56),n2h4(68))
  call Hloop_AV_Q(ntryL,G1H16(78),wf4(:,13),G1H4(15),m3h4x4(:,95),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMT,G2H4(57),n2h4(69))
  call Hloop_QV_A(ntryL,G1H16(80),wf4(:,13),G1H4(16),m3h4x4(:,96),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMT,G2H4(58),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H16(82),wf4(:,13),G1H4(19),m3h4x4(:,97),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(19),19,nMB,G2H4(59),n2h4(71))
  call Hloop_QV_A(ntryL,G1H16(84),wf4(:,13),G1H4(20),m3h4x4(:,98),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(20),19,nMB,G2H4(60),n2h4(72))
  call Hloop_AZ_Q(ntryL,G1H16(85),wf4(:,14),G1H4(21),ngZl,m3h4x4(:,99),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(21),19,0,G2H4(61),n2h4(73))
  call Hloop_AZ_Q(ntryL,G1H16(86),wf4(:,14),G1H4(22),ngZl,m3h4x4(:,100),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(22),19,nMM,G2H4(62),n2h4(74))
  call Hloop_AZ_Q(ntryL,G1H16(87),wf4(:,14),G1H4(25),ngZl,m3h4x4(:,101),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(25),19,nML,G2H4(63),n2h4(75))
  call Hloop_QZ_A(ntryL,G1H16(88),wf4(:,14),G1H4(26),ngZl,m3h4x4(:,102),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(26),19,0,G2H4(64),n2h4(76))
  call Hloop_QZ_A(ntryL,G1H16(89),wf4(:,14),G1H4(27),ngZl,m3h4x4(:,103),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(27),19,nMM,G2H4(65),n2h4(77))
  call Hloop_QZ_A(ntryL,G1H16(90),wf4(:,14),G1H4(28),ngZl,m3h4x4(:,104),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(28),19,nML,G2H4(66),n2h4(78))
  call Hloop_AZ_Q(ntryL,G1H16(91),wf4(:,14),G1H4(31),ngZu,m3h4x4(:,105),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(31),19,0,G2H4(67),n2h4(79))
  call Hloop_AZ_Q(ntryL,G1H16(92),wf4(:,14),G1H4(32),ngZu,m3h4x4(:,106),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(32),19,nMT,G2H4(68),n2h4(80))
  call Hloop_QZ_A(ntryL,G1H16(93),wf4(:,14),G1H4(1),ngZu,m3h4x4(:,107),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(69),n2h4(81))
  call Hloop_QZ_A(ntryL,G1H16(94),wf4(:,14),G1H4(2),ngZu,m3h4x4(:,108),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMT,G2H4(70),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H16(95),wf4(:,14),G1H4(35),ngZd,m3h4x4(:,109),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(35),19,0,G2H4(71),n2h4(83))
  call Hloop_AZ_Q(ntryL,G1H16(96),wf4(:,14),G1H4(36),ngZd,m3h4x4(:,110),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(36),19,nMB,G2H4(72),n2h4(84))
  call Hloop_QZ_A(ntryL,G1H16(97),wf4(:,14),G1H4(37),ngZd,m3h4x4(:,111),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(37),19,0,G2H4(73),n2h4(85))
  call Hloop_QZ_A(ntryL,G1H16(98),wf4(:,14),G1H4(38),ngZd,m3h4x4(:,112),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(38),19,nMB,G2H4(74),n2h4(86))
  call Hloop_SV_T(ntryL,G1H16(99),16,wf4(:,13),3,G2H4(75),m3h4x4(:,113),heltab2x16(:,:,151))
  call Hloop_TV_S(ntryL,G1H16(100),16,wf4(:,13),3,G2H4(76),m3h4x4(:,114),heltab2x16(:,:,152))
  call Hloop_SV_T(ntryL,G1H16(101),16,wf4(:,14),3,G2H4(77),m3h4x4(:,115),heltab2x16(:,:,153))
  call Hloop_TV_S(ntryL,G1H16(102),16,wf4(:,14),3,G2H4(78),m3h4x4(:,116),heltab2x16(:,:,154))
  call Hloop_DV_C(ntryL,G1H16(105),16,wf4(:,13),G2H4(79),m3h4x4(:,117),heltab2x16(:,:,155))
  call Hloop_CV_D(ntryL,G1H16(106),16,wf4(:,13),3,G2H4(80),m3h4x4(:,118),heltab2x16(:,:,156))
  call Hloop_DV_C(ntryL,G1H16(109),16,wf4(:,14),G2H4(81),m3h4x4(:,119),heltab2x16(:,:,157))
  call Hloop_CV_D(ntryL,G1H16(110),16,wf4(:,14),3,G2H4(82),m3h4x4(:,120),heltab2x16(:,:,158))
  call Hloop_UW_V(ntryL,G1H16(111),16,wf4(:,13),3,G2H4(83),m3h4x4(:,121),heltab2x16(:,:,159))
  call Hloop_UV_W(ntryL,G1H16(112),16,wf4(:,13),3,G2H4(84),m3h4x4(:,122),heltab2x16(:,:,160))
  call Hloop_UW_V(ntryL,G1H16(113),16,wf4(:,14),3,G2H4(85),m3h4x4(:,123),heltab2x16(:,:,161))
  call Hloop_UV_W(ntryL,G1H16(114),16,wf4(:,14),3,G2H4(86),m3h4x4(:,124),heltab2x16(:,:,162))
  call Hloop_VV_S(ntryL,G0H16(33),wf4(:,13),G0H4(13),m3h4x4(:,125),heltab2x16(:,:,163))
  call Hloop_VV_S(ntryL,G0H16(34),wf4(:,13),G0H4(14),m3h4x4(:,126),heltab2x16(:,:,164))
  call Hloop_VV_S(ntryL,G0H16(35),wf4(:,14),G0H4(15),m3h4x4(:,127),heltab2x16(:,:,165))
  call Hloop_VV_S(ntryL,G0H16(36),wf4(:,14),G0H4(16),m3h4x4(:,128),heltab2x16(:,:,166))
  call Hloop_SV_T(ntryL,G0H16(37),16,wf4(:,13),3,G1H4(41),m3h4x4(:,129),heltab2x16(:,:,167))
  call Hloop_TV_S(ntryL,G0H16(38),16,wf4(:,13),3,G1H4(42),m3h4x4(:,130),heltab2x16(:,:,168))
  call Hloop_SV_T(ntryL,G0H16(39),16,wf4(:,14),3,G1H4(43),m3h4x4(:,131),heltab2x16(:,:,169))
  call Hloop_TV_S(ntryL,G0H16(40),16,wf4(:,14),3,G1H4(44),m3h4x4(:,132),heltab2x16(:,:,170))
  call Hloop_SV_V(ntryL,G1H16(115),wf4(:,13),G1H4(47),m3h4x4(:,133),heltab2x16(:,:,171))
  call Hloop_SV_V(ntryL,G1H16(116),wf4(:,13),G1H4(48),m3h4x4(:,134),heltab2x16(:,:,172))
  call Hloop_SV_V(ntryL,G1H16(117),wf4(:,14),G1H4(7),m3h4x4(:,135),heltab2x16(:,:,173))
  call Hloop_SV_V(ntryL,G1H16(118),wf4(:,14),G1H4(8),m3h4x4(:,136),heltab2x16(:,:,174))
  call Hloop_SV_T(ntryL,G1H16(119),16,wf4(:,13),3,G2H4(87),m3h4x4(:,137),heltab2x16(:,:,175))
  call Hloop_TV_S(ntryL,G1H16(120),16,wf4(:,13),3,G2H4(88),m3h4x4(:,138),heltab2x16(:,:,176))
  call Hloop_SV_T(ntryL,G1H16(121),16,wf4(:,14),3,G2H4(89),m3h4x4(:,139),heltab2x16(:,:,177))
  call Hloop_TV_S(ntryL,G1H16(122),16,wf4(:,14),3,G2H4(90),m3h4x4(:,140),heltab2x16(:,:,178))
  call Hloop_VV_S(ntryL,G1H16(123),wf4(:,13),G1H4(95),m3h4x4(:,141),heltab2x16(:,:,179))
  call Hloop_VV_S(ntryL,G1H16(124),wf4(:,13),G1H4(96),m3h4x4(:,142),heltab2x16(:,:,180))
  call Hloop_VV_S(ntryL,G1H16(125),wf4(:,14),G1H4(9),m3h4x4(:,143),heltab2x16(:,:,181))
  call Hloop_VV_S(ntryL,G1H16(126),wf4(:,14),G1H4(10),m3h4x4(:,144),heltab2x16(:,:,182))
  call Hloop_UW_V(ntryL,G0H16(41),16,wf4(:,13),3,G1H4(15),m3h4x4(:,145),heltab2x16(:,:,183))
  call Hloop_UV_W(ntryL,G0H16(42),16,wf4(:,13),3,G1H4(16),m3h4x4(:,146),heltab2x16(:,:,184))
  call Hloop_UW_V(ntryL,G0H16(43),16,wf4(:,14),3,G1H4(19),m3h4x4(:,147),heltab2x16(:,:,185))
  call Hloop_UV_W(ntryL,G0H16(44),16,wf4(:,14),3,G1H4(20),m3h4x4(:,148),heltab2x16(:,:,186))
  call Hloop_SV_V(ntryL,G0H16(46),wf4(:,13),G0H4(17),m3h4x4(:,149),heltab2x16(:,:,187))
  call Hloop_SV_V(ntryL,G0H16(48),wf4(:,14),G0H4(18),m3h4x4(:,150),heltab2x16(:,:,188))
  call Hloop_VV_S(ntryL,G0H16(50),wf4(:,13),G0H4(19),m3h4x4(:,151),heltab2x16(:,:,189))
  call Hloop_VV_S(ntryL,G0H16(52),wf4(:,14),G0H4(20),m3h4x4(:,152),heltab2x16(:,:,190))
  call Hloop_SV_T(ntryL,G0H16(53),16,wf4(:,13),3,G1H4(21),m3h4x4(:,153),heltab2x16(:,:,191))
  call Hloop_TV_S(ntryL,G0H16(54),16,wf4(:,13),3,G1H4(22),m3h4x4(:,154),heltab2x16(:,:,192))
  call Hloop_SV_T(ntryL,G0H16(55),16,wf4(:,14),3,G1H4(25),m3h4x4(:,155),heltab2x16(:,:,193))
  call Hloop_TV_S(ntryL,G0H16(56),16,wf4(:,14),3,G1H4(26),m3h4x4(:,156),heltab2x16(:,:,194))
  call Hloop_SV_V(ntryL,G1H16(127),wf4(:,13),G1H4(27),m3h4x4(:,157),heltab2x16(:,:,195))
  call Hloop_SV_V(ntryL,G1H16(128),wf4(:,13),G1H4(28),m3h4x4(:,158),heltab2x16(:,:,196))
  call Hloop_SV_V(ntryL,G1H16(129),wf4(:,14),G1H4(31),m3h4x4(:,159),heltab2x16(:,:,197))
  call Hloop_SV_V(ntryL,G1H16(130),wf4(:,14),G1H4(32),m3h4x4(:,160),heltab2x16(:,:,198))
  call Hloop_UW_V(ntryL,G1H16(131),16,wf4(:,13),3,G2H4(91),m3h4x4(:,161),heltab2x16(:,:,199))
  call Hloop_UV_W(ntryL,G1H16(132),16,wf4(:,13),3,G2H4(92),m3h4x4(:,162),heltab2x16(:,:,200))
  call Hloop_UW_V(ntryL,G1H16(133),16,wf4(:,14),3,G2H4(93),m3h4x4(:,163),heltab2x16(:,:,201))
  call Hloop_UV_W(ntryL,G1H16(134),16,wf4(:,14),3,G2H4(94),m3h4x4(:,164),heltab2x16(:,:,202))
  call Hloop_VV_S(ntryL,G1H16(135),wf4(:,13),G1H4(1),m3h4x4(:,165),heltab2x16(:,:,203))
  call Hloop_VV_S(ntryL,G1H16(136),wf4(:,13),G1H4(2),m3h4x4(:,166),heltab2x16(:,:,204))
  call Hloop_VV_S(ntryL,G1H16(137),wf4(:,14),G1H4(35),m3h4x4(:,167),heltab2x16(:,:,205))
  call Hloop_VV_S(ntryL,G1H16(138),wf4(:,14),G1H4(36),m3h4x4(:,168),heltab2x16(:,:,206))
  call Hloop_UW_V(ntryL,G0H16(57),16,wf4(:,13),3,G1H4(37),m3h4x4(:,169),heltab2x16(:,:,207))
  call Hloop_UV_W(ntryL,G0H16(58),16,wf4(:,13),3,G1H4(38),m3h4x4(:,170),heltab2x16(:,:,208))
  call Hloop_UW_V(ntryL,G0H16(59),16,wf4(:,14),3,G1H4(97),m3h4x4(:,171),heltab2x16(:,:,209))
  call Hloop_UV_W(ntryL,G0H16(60),16,wf4(:,14),3,G1H4(98),m3h4x4(:,172),heltab2x16(:,:,210))
  call Hloop_SV_V(ntryL,G0H16(61),wf4(:,13),G0H4(21),m3h4x4(:,173),heltab2x16(:,:,211))
  call Hloop_SV_V(ntryL,G0H16(62),wf4(:,13),G0H4(22),m3h4x4(:,174),heltab2x16(:,:,212))
  call Hloop_SV_V(ntryL,G0H16(63),wf4(:,14),G0H4(23),m3h4x4(:,175),heltab2x16(:,:,213))
  call Hloop_SV_V(ntryL,G0H16(64),wf4(:,14),G0H4(24),m3h4x4(:,176),heltab2x16(:,:,214))
  call Hloop_QV_A(ntryL,G1H16(149),ex3(:),G1H8(19),m3h2x8(:,39),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H8(19),20,0,G2H8(3),n2h8(33))
  call Hloop_QV_A(ntryL,G1H16(140),ex3(:),G1H8(20),m3h2x8(:,40),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H8(20),20,nMM,G2H8(4),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(141),ex3(:),G1H8(21),m3h2x8(:,41),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H8(21),20,nML,G2H8(5),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(151),ex3(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(6),n2h8(36))
  call Hloop_AV_Q(ntryL,G1H16(143),ex3(:),G1H8(2),m3h2x8(:,43),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMM,G2H8(7),n2h8(37))
  call Hloop_AV_Q(ntryL,G1H16(144),ex3(:),G1H8(22),m3h2x8(:,44),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G1H8(22),20,nML,G2H8(8),n2h8(38))
  call Hloop_QV_A(ntryL,G1H16(146),ex3(:),G1H8(23),m3h2x8(:,45),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(9),n2h8(39))
  call Hloop_AV_Q(ntryL,G1H16(148),ex3(:),G1H8(3),m3h2x8(:,46),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMT,G2H8(10),n2h8(40))
  call Hloop_QV_A(ntryL,G1H16(150),ex3(:),G1H8(4),m3h2x8(:,47),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMB,G2H8(11),n2h8(41))
  call Hloop_AV_Q(ntryL,G1H16(152),ex3(:),G1H8(6),m3h2x8(:,48),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H8(6),20,nMB,G2H8(12),n2h8(42))
  call Hloop_QV_A(ntryL,G1H16(153),ex3(:),G1H8(8),m3h2x8(:,49),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H8(8),20,0,G2H8(13),n2h8(43))
  call Hloop_QV_A(ntryL,G1H16(154),ex3(:),G1H8(24),m3h2x8(:,50),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(24),20,nMM,G2H8(14),n2h8(44))
  call Hloop_QV_A(ntryL,G1H16(155),ex3(:),G1H8(7),m3h2x8(:,51),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(7),20,nML,G2H8(15),n2h8(45))
  call Hloop_AV_Q(ntryL,G1H16(156),ex3(:),G1H8(5),m3h2x8(:,52),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H8(5),20,0,G2H8(16),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(157),ex3(:),G1H8(17),m3h2x8(:,53),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G1H8(17),20,nMM,G2H8(17),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H16(158),ex3(:),G1H8(18),m3h2x8(:,54),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H8(18),20,nML,G2H8(18),n2h8(48))
  call Hloop_QV_A(ntryL,G1H16(159),ex3(:),G1H8(19),m3h2x8(:,55),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H8(19),20,0,G2H8(19),n2h8(49))
  call Hloop_QV_A(ntryL,G1H16(160),ex3(:),G1H8(20),m3h2x8(:,56),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(20),20,nMT,G2H8(20),n2h8(50))
  call Hloop_AV_Q(ntryL,G1H16(161),ex3(:),G1H8(21),m3h2x8(:,57),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G1H8(21),20,0,G2H8(21),n2h8(51))
  call Hloop_AV_Q(ntryL,G1H16(162),ex3(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(22),n2h8(52))
  call Hloop_QV_A(ntryL,G1H16(163),ex3(:),G1H8(2),m3h2x8(:,59),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H8(2),20,0,G2H8(23),n2h8(53))
  call Hloop_QV_A(ntryL,G1H16(164),ex3(:),G1H8(22),m3h2x8(:,60),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H8(22),20,nMB,G2H8(24),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H16(165),ex3(:),G1H8(23),m3h2x8(:,61),heltab2x16(:,:,237))
  call Hloop_A_Q(ntryL,G1H8(23),20,0,G2H8(25),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(166),ex3(:),G1H8(3),m3h2x8(:,62),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMB,G2H8(26),n2h8(56))
  call Hloop_TV_S(ntryL,G1H16(167),16,ex3(:),4,G2H8(27),m3h2x8(:,63),heltab2x16(:,:,239))
  call Hloop_SV_T(ntryL,G1H16(168),16,ex3(:),4,G2H8(28),m3h2x8(:,64),heltab2x16(:,:,240))
  call Hloop_TV_S(ntryL,G1H16(169),16,ex3(:),4,G2H8(29),m3h2x8(:,65),heltab2x16(:,:,241))
  call Hloop_SV_T(ntryL,G1H16(170),16,ex3(:),4,G2H8(30),m3h2x8(:,66),heltab2x16(:,:,242))
  call Hloop_CV_D(ntryL,G1H16(173),16,ex3(:),4,G2H8(31),m3h2x8(:,67),heltab2x16(:,:,243))
  call Hloop_DV_C(ntryL,G1H16(174),16,ex3(:),G2H8(32),m3h2x8(:,68),heltab2x16(:,:,244))
  call Hloop_CV_D(ntryL,G1H16(177),16,ex3(:),4,G2H8(33),m3h2x8(:,69),heltab2x16(:,:,245))
  call Hloop_DV_C(ntryL,G1H16(178),16,ex3(:),G2H8(34),m3h2x8(:,70),heltab2x16(:,:,246))
  call Hloop_UV_W(ntryL,G1H16(179),16,ex3(:),4,G2H8(35),m3h2x8(:,71),heltab2x16(:,:,247))
  call Hloop_UW_V(ntryL,G1H16(180),16,ex3(:),4,G2H8(36),m3h2x8(:,72),heltab2x16(:,:,248))
  call Hloop_UV_W(ntryL,G1H16(181),16,ex3(:),4,G2H8(37),m3h2x8(:,73),heltab2x16(:,:,249))
  call Hloop_UW_V(ntryL,G1H16(182),16,ex3(:),4,G2H8(38),m3h2x8(:,74),heltab2x16(:,:,250))
  call Hloop_TV_S(ntryL,G1H16(183),16,ex3(:),4,G2H8(39),m3h2x8(:,75),heltab2x16(:,:,251))
  call Hloop_SV_T(ntryL,G1H16(184),16,ex3(:),4,G2H8(40),m3h2x8(:,76),heltab2x16(:,:,252))
  call Hloop_TV_S(ntryL,G1H16(185),16,ex3(:),4,G2H8(41),m3h2x8(:,77),heltab2x16(:,:,253))
  call Hloop_SV_T(ntryL,G1H16(186),16,ex3(:),4,G2H8(42),m3h2x8(:,78),heltab2x16(:,:,254))
  call Hloop_TV_S(ntryL,G0H16(65),16,ex3(:),4,G1H8(4),m3h2x8(:,79),heltab2x16(:,:,255))
  call Hloop_SV_T(ntryL,G0H16(66),16,ex3(:),4,G1H8(6),m3h2x8(:,80),heltab2x16(:,:,256))
  call Hloop_TV_S(ntryL,G0H16(67),16,ex3(:),4,G1H8(8),m3h2x8(:,81),heltab2x16(:,:,257))
  call Hloop_SV_T(ntryL,G0H16(68),16,ex3(:),4,G1H8(24),m3h2x8(:,82),heltab2x16(:,:,258))
  call Hloop_SV_V(ntryL,G1H16(187),ex3(:),G1H8(7),m3h2x8(:,83),heltab2x16(:,:,259))
  call Hloop_SV_V(ntryL,G1H16(188),ex3(:),G1H8(5),m3h2x8(:,84),heltab2x16(:,:,260))
  call Hloop_SV_V(ntryL,G1H16(189),ex3(:),G1H8(17),m3h2x8(:,85),heltab2x16(:,:,261))
  call Hloop_SV_V(ntryL,G1H16(190),ex3(:),G1H8(18),m3h2x8(:,86),heltab2x16(:,:,262))
  call Hloop_VV_S(ntryL,G0H16(69),ex3(:),G0H8(13),m3h2x8(:,87),heltab2x16(:,:,263))
  call Hloop_VV_S(ntryL,G0H16(70),ex3(:),G0H8(4),m3h2x8(:,88),heltab2x16(:,:,264))
  call Hloop_VV_S(ntryL,G0H16(71),ex3(:),G0H8(2),m3h2x8(:,89),heltab2x16(:,:,265))
  call Hloop_VV_S(ntryL,G0H16(72),ex3(:),G0H8(3),m3h2x8(:,90),heltab2x16(:,:,266))
  call Hloop_TV_S(ntryL,G0H16(73),16,ex3(:),4,G1H8(19),m3h2x8(:,91),heltab2x16(:,:,267))
  call Hloop_SV_T(ntryL,G0H16(74),16,ex3(:),4,G1H8(20),m3h2x8(:,92),heltab2x16(:,:,268))
  call Hloop_TV_S(ntryL,G0H16(75),16,ex3(:),4,G1H8(21),m3h2x8(:,93),heltab2x16(:,:,269))
  call Hloop_SV_T(ntryL,G0H16(76),16,ex3(:),4,G1H8(1),m3h2x8(:,94),heltab2x16(:,:,270))
  call Hloop_SV_V(ntryL,G1H16(191),ex3(:),G1H8(2),m3h2x8(:,95),heltab2x16(:,:,271))
  call Hloop_SV_V(ntryL,G1H16(192),ex3(:),G1H8(22),m3h2x8(:,96),heltab2x16(:,:,272))
  call Hloop_SV_V(ntryL,G1H16(193),ex3(:),G1H8(23),m3h2x8(:,97),heltab2x16(:,:,273))
  call Hloop_SV_V(ntryL,G1H16(194),ex3(:),G1H8(3),m3h2x8(:,98),heltab2x16(:,:,274))
  call Hloop_SV_V(ntryL,G0H16(78),ex3(:),G0H8(1),m3h2x8(:,99),heltab2x16(:,:,275))
  call Hloop_SV_V(ntryL,G0H16(80),ex3(:),G0H8(14),m3h2x8(:,100),heltab2x16(:,:,276))
  call Hloop_VV_S(ntryL,G0H16(82),ex3(:),G0H8(15),m3h2x8(:,101),heltab2x16(:,:,277))
  call Hloop_VV_S(ntryL,G0H16(84),ex3(:),G0H8(16),m3h2x8(:,102),heltab2x16(:,:,278))
  call Hloop_VV_S(ntryL,G1H16(195),ex3(:),G1H8(25),m3h2x8(:,103),heltab2x16(:,:,279))
  call Hloop_VV_S(ntryL,G1H16(196),ex3(:),G1H8(26),m3h2x8(:,104),heltab2x16(:,:,280))
  call Hloop_VV_S(ntryL,G1H16(197),ex3(:),G1H8(27),m3h2x8(:,105),heltab2x16(:,:,281))
  call Hloop_VV_S(ntryL,G1H16(198),ex3(:),G1H8(28),m3h2x8(:,106),heltab2x16(:,:,282))
  call Hloop_UV_W(ntryL,G0H16(85),16,ex3(:),4,G1H8(29),m3h2x8(:,107),heltab2x16(:,:,283))
  call Hloop_UW_V(ntryL,G0H16(86),16,ex3(:),4,G1H8(30),m3h2x8(:,108),heltab2x16(:,:,284))
  call Hloop_UV_W(ntryL,G0H16(87),16,ex3(:),4,G1H8(31),m3h2x8(:,109),heltab2x16(:,:,285))
  call Hloop_UW_V(ntryL,G0H16(88),16,ex3(:),4,G1H8(32),m3h2x8(:,110),heltab2x16(:,:,286))
  call Hloop_SV_V(ntryL,G0H16(89),ex3(:),G0H8(17),m3h2x8(:,111),heltab2x16(:,:,287))
  call Hloop_SV_V(ntryL,G0H16(90),ex3(:),G0H8(18),m3h2x8(:,112),heltab2x16(:,:,288))
  call Hloop_SV_V(ntryL,G0H16(91),ex3(:),G0H8(19),m3h2x8(:,113),heltab2x16(:,:,289))
  call Hloop_SV_V(ntryL,G0H16(92),ex3(:),G0H8(20),m3h2x8(:,114),heltab2x16(:,:,290))
  call Hloop_VV_S(ntryL,G1H16(199),ex3(:),G1H8(33),m3h2x8(:,115),heltab2x16(:,:,291))
  call Hloop_VV_S(ntryL,G1H16(200),ex3(:),G1H8(34),m3h2x8(:,116),heltab2x16(:,:,292))
  call Hloop_VV_S(ntryL,G1H16(201),ex3(:),G1H8(35),m3h2x8(:,117),heltab2x16(:,:,293))
  call Hloop_VV_S(ntryL,G1H16(202),ex3(:),G1H8(36),m3h2x8(:,118),heltab2x16(:,:,294))
  call Hloop_UV_W(ntryL,G0H16(93),16,ex3(:),4,G1H8(37),m3h2x8(:,119),heltab2x16(:,:,295))
  call Hloop_UW_V(ntryL,G0H16(94),16,ex3(:),4,G1H8(38),m3h2x8(:,120),heltab2x16(:,:,296))
  call Hloop_UV_W(ntryL,G0H16(95),16,ex3(:),4,G1H8(39),m3h2x8(:,121),heltab2x16(:,:,297))
  call Hloop_UW_V(ntryL,G0H16(96),16,ex3(:),4,G1H8(40),m3h2x8(:,122),heltab2x16(:,:,298))
  call Hloop_UV_W(ntryL,G1H16(203),16,ex3(:),4,G2H8(43),m3h2x8(:,123),heltab2x16(:,:,299))
  call Hloop_UW_V(ntryL,G1H16(204),16,ex3(:),4,G2H8(44),m3h2x8(:,124),heltab2x16(:,:,300))
  call Hloop_UV_W(ntryL,G1H16(205),16,ex3(:),4,G2H8(45),m3h2x8(:,125),heltab2x16(:,:,301))
  call Hloop_UW_V(ntryL,G1H16(206),16,ex3(:),4,G2H8(46),m3h2x8(:,126),heltab2x16(:,:,302))
  call Hloop_AQ_V(ntryL,G1H16(207),wf4(:,3),G1H4(99),m3h4x4(:,177),heltab2x16(:,:,303))
  call Hloop_AQ_Z(ntryL,G1H16(208),wf4(:,3),G1H4(100),ngZl,m3h4x4(:,178),heltab2x16(:,:,304))
  call Hloop_WQ_A(ntryL,G0H16(97),wf4(:,3),G0H4(25),m3h4x4(:,179),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(25),21,0,G1H4(101),n2h4(87))
  call Hloop_WQ_A(ntryL,G1H16(209),wf4(:,3),G1H4(102),m3h4x4(:,180),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(102),21,0,G2H4(95),n2h4(88))
  call Hloop_QA_V(ntryL,G1H16(210),ex2(:),G1H8(41),m3h2x8(:,127),heltab2x16(:,:,307))
  call Hloop_QA_Z(ntryL,G1H16(211),ex2(:),G1H8(42),ngZl,m3h2x8(:,128),heltab2x16(:,:,308))
  call Hloop_WA_Q(ntryL,G0H16(98),ex2(:),G0H8(21),m3h2x8(:,129),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G0H8(21),18,0,G1H8(43),n2h8(57))
  call Hloop_WA_Q(ntryL,G1H16(212),ex2(:),G1H8(44),m3h2x8(:,130),heltab2x16(:,:,310))
  call Hloop_A_Q(ntryL,G1H8(44),18,0,G2H8(47),n2h8(58))
  call Hloop_QA_V(ntryL,G1H16(213),wf4(:,10),G1H4(102),m3h4x4(:,181),heltab2x16(:,:,311))
  call Hloop_QA_Z(ntryL,G1H16(214),wf4(:,10),G1H4(103),ngZl,m3h4x4(:,182),heltab2x16(:,:,312))
  call Hloop_WA_Q(ntryL,G0H16(99),wf4(:,10),G0H4(25),m3h4x4(:,183),heltab2x16(:,:,313))
  call Hloop_A_Q(ntryL,G0H4(25),22,0,G1H4(104),n2h4(89))
  call Hloop_WA_Q(ntryL,G1H16(215),wf4(:,10),G1H4(105),m3h4x4(:,184),heltab2x16(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(105),22,0,G2H4(96),n2h4(90))
  call Hloop_AQ_V(ntryL,G1H16(216),ex1(:),G1H8(44),m3h2x8(:,131),heltab2x16(:,:,315))
  call Hloop_AQ_Z(ntryL,G1H16(217),ex1(:),G1H8(45),ngZl,m3h2x8(:,132),heltab2x16(:,:,316))
  call Hloop_WQ_A(ntryL,G0H16(100),ex1(:),G0H8(21),m3h2x8(:,133),heltab2x16(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(21),17,0,G1H8(46),n2h8(59))
  call Hloop_WQ_A(ntryL,G1H16(218),ex1(:),G1H8(47),m3h2x8(:,134),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G1H8(47),17,0,G2H8(48),n2h8(60))
  call Hloop_QV_A(ntryL,G1H16(219),ex3(:),G1H8(47),m3h2x8(:,135),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G1H8(47),20,0,G2H8(49),n2h8(61))
  call Hloop_QV_A(ntryL,G1H16(220),ex3(:),G1H8(47),m3h2x8(:,136),heltab2x16(:,:,320))
  call Hloop_Q_A(ntryL,G1H8(47),20,0,G2H8(50),n2h8(62))
  call Hloop_SV_V(ntryL,G0H16(101),ex3(:),G0H8(21),m3h2x8(:,137),heltab2x16(:,:,321))
  call Hloop_UV_W(ntryL,G1H16(221),16,ex3(:),4,G2H8(51),m3h2x8(:,138),heltab2x16(:,:,322))
  call Hloop_QA_V(ntryL,G1H16(222),ex2(:),G1H8(47),m3h2x8(:,139),heltab2x16(:,:,323))
  call Hloop_QA_Z(ntryL,G1H16(223),ex2(:),G1H8(48),ngZl,m3h2x8(:,140),heltab2x16(:,:,324))
  call Hloop_WA_Q(ntryL,G0H16(102),ex2(:),G0H8(22),m3h2x8(:,141),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G0H8(22),18,0,G1H8(49),n2h8(63))
  call Hloop_WA_Q(ntryL,G1H16(224),ex2(:),G1H8(50),m3h2x8(:,142),heltab2x16(:,:,326))
  call Hloop_A_Q(ntryL,G1H8(50),18,0,G2H8(52),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H16(225),ex3(:),G1H8(50),m3h2x8(:,143),heltab2x16(:,:,327))
  call Hloop_A_Q(ntryL,G1H8(50),20,0,G2H8(53),n2h8(65))
  call Hloop_AV_Q(ntryL,G1H16(226),ex3(:),G1H8(50),m3h2x8(:,144),heltab2x16(:,:,328))
  call Hloop_A_Q(ntryL,G1H8(50),20,0,G2H8(54),n2h8(66))
  call Hloop_SV_V(ntryL,G0H16(103),ex3(:),G0H8(22),m3h2x8(:,145),heltab2x16(:,:,329))
  call Hloop_UW_V(ntryL,G1H16(227),16,ex3(:),4,G2H8(55),m3h2x8(:,146),heltab2x16(:,:,330))
  call Hloop_AQ_V(ntryL,G1H16(228),ex1(:),G1H8(50),m3h2x8(:,147),heltab2x16(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H16(229),ex1(:),G1H8(51),ngZl,m3h2x8(:,148),heltab2x16(:,:,332))
  call Hloop_WQ_A(ntryL,G0H16(104),ex1(:),G0H8(23),m3h2x8(:,149),heltab2x16(:,:,333))
  call Hloop_Q_A(ntryL,G0H8(23),17,0,G1H8(52),n2h8(67))
  call Hloop_WQ_A(ntryL,G1H16(230),ex1(:),G1H8(53),m3h2x8(:,150),heltab2x16(:,:,334))
  call Hloop_Q_A(ntryL,G1H8(53),17,0,G2H8(56),n2h8(68))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(25),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(105),n2h4(91))
  call Hloop_ZA_Q(ntryL,G0H8(6),ex2(:),G0H4(25),ngZl,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(106),n2h4(92))
  call Hloop_QA_W(ntryL,G1H8(9),ex2(:),G1H4(107),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QA_W(ntryL,G1H8(10),ex2(:),G1H4(108),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(25),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(109),n2h4(93))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex2(:),G0H4(25),ngZl,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(110),n2h4(94))
  call Hloop_QA_W(ntryL,G1H8(11),ex2(:),G1H4(111),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_QA_W(ntryL,G1H8(12),ex2(:),G1H4(112),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(25),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(113),n2h4(95))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(25),ngZl,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(114),n2h4(96))
  call Hloop_AQ_W(ntryL,G1H8(13),ex1(:),G1H4(115),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(116),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_VQ_A(ntryL,G0H8(11),ex1(:),G0H4(25),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(117),n2h4(97))
  call Hloop_ZQ_A(ntryL,G0H8(12),ex1(:),G0H4(25),ngZl,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(118),n2h4(98))
  call Hloop_AQ_W(ntryL,G1H8(15),ex1(:),G1H4(119),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_W(ntryL,G1H8(16),ex1(:),G1H4(120),m3h2x4(:,60),heltab2x8(:,:,60))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(69),G2H4(64),G2H4(54),G1H4(30),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G2H4(84),G1H4(34),G0H4(24),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(3),G2H4(27),G2H4(15),G1H4(58),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(39),G1H4(62),G0H4(11),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(67),G2H4(61),G2H4(51),G1H4(74),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G2H4(83),G1H4(78),G0H4(23),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(5),G2H4(32),G2H4(18),G1H4(90),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(110),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(40),G1H4(94),G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(11),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(12),G0H4(4),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(3),G1H4(53),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(4),G1H4(54),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(65),G1H4(59),G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(66),G1H4(60),G1H4(56)])



end subroutine vamp_1

end module ol_vamp_1_pplla_ew_eexaaa_1_/**/REALKIND
