
module ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(102,6), K2(102,8), KL(102,8), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [   0,  36,  12,  12,   0,   0]
  K1(  2,:) = [  36,   0,   0,   0,   0,   0]
  K1(  3,:) = [  12,   0,   0,   0,  12,   0]
  K1(  4,:) = [  12,   0,   0,   0,  12,   0]
  K1(  5,:) = [   0,   0,  12,  12,   0,  36]
  K1(  6,:) = [   0,   0,   0,   0,  36,   0]
  K1(  7,:) = [   0,  48,  16,  16,   0,   0]
  K1(  8,:) = [  48,   0,   0,   0,   0,   0]
  K1(  9,:) = [  16,   0,   0,   0,  16,   0]
  K1( 10,:) = [  16,   0,   0,   0,  16,   0]
  K1( 11,:) = [   0,   0,  16,  16,   0,  48]
  K1( 12,:) = [   0,   0,   0,   0,  48,   0]
  K1( 13,:) = [   0,   6,   2,   2,   0,   0]
  K1( 14,:) = [   6,   0,   0,   0,   0,   0]
  K1( 15,:) = [   2,   0,   0,   0, -16,   0]
  K1( 16,:) = [   2,   0,   0,   0, -16,   0]
  K1( 17,:) = [   0,   0, -16, -16,   0, -48]
  K1( 18,:) = [   0,   0,   0,   0, -48,   0]
  K1( 19,:) = [   0,  48,  16,  16,   0,   0]
  K1( 20,:) = [  48,   0,   0,   0,   0,   0]
  K1( 21,:) = [  16,   0,   0,   0,  16,   0]
  K1( 22,:) = [  16,   0,   0,   0,  16,   0]
  K1( 23,:) = [   0,   0,  16,  16,   0,  48]
  K1( 24,:) = [   0,   0,   0,   0,  48,   0]
  K1( 25,:) = [   0,   0,  16,  -2,   0,   6]
  K1( 26,:) = [   0,   0,   0,   0,   6,   0]
  K1( 27,:) = [  16,   0,   0,   0,  -2,   0]
  K1( 28,:) = [  -2,   0,   0,   0,  16,   0]
  K1( 29,:) = [   0,   6,  -2,  16,   0,   0]
  K1( 30,:) = [   6,   0,   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,   2, -16,   0,  -6]
  K1( 32,:) = [   0,   0,   0,   0,  -6,   0]
  K1( 33,:) = [   2,   0,   0,   0,   2,   0]
  K1( 34,:) = [ -16,   0,   0,   0, -16,   0]
  K1( 35,:) = [   0,  -6,   2, -16,   0,   0]
  K1( 36,:) = [  -6,   0,   0,   0,   0,   0]
  K1( 37,:) = [   0,  48,  16,  16,   0,   0]
  K1( 38,:) = [  48,   0,   0,   0,   0,   0]
  K1( 39,:) = [  16,   0,   0,   0,  16,   0]
  K1( 40,:) = [  16,   0,   0,   0,  16,   0]
  K1( 41,:) = [   0,   0,  16,  16,   0,  48]
  K1( 42,:) = [   0,   0,   0,   0,  48,   0]
  K1( 43,:) = [   0,   0, -16,   2,   0,  -6]
  K1( 44,:) = [   0,   0,   0,   0,  -6,   0]
  K1( 45,:) = [ -16,   0,   0,   0, -16,   0]
  K1( 46,:) = [   2,   0,   0,   0,   2,   0]
  K1( 47,:) = [   0,  -6, -16,   2,   0,   0]
  K1( 48,:) = [  -6,   0,   0,   0,   0,   0]
  K1( 49,:) = [   0,   0,  -2,  16,   0,   6]
  K1( 50,:) = [   0,   0,   0,   0,   6,   0]
  K1( 51,:) = [  -2,   0,   0,   0,  16,   0]
  K1( 52,:) = [  16,   0,   0,   0,  -2,   0]
  K1( 53,:) = [   0,   6,  16,  -2,   0,   0]
  K1( 54,:) = [   6,   0,   0,   0,   0,   0]
  K1( 55,:) = [   0, -48, -16, -16,   0,   0]
  K1( 56,:) = [ -48,   0,   0,   0,   0,   0]
  K1( 57,:) = [ -16,   0,   0,   0,   2,   0]
  K1( 58,:) = [ -16,   0,   0,   0,   2,   0]
  K1( 59,:) = [   0,   0,   2,   2,   0,   6]
  K1( 60,:) = [   0,   0,   0,   0,   6,   0]
  K1( 61,:) = [   0,  48,  16,  16,   0,   0]
  K1( 62,:) = [  48,   0,   0,   0,   0,   0]
  K1( 63,:) = [  16,   0,   0,   0,  16,   0]
  K1( 64,:) = [  16,   0,   0,   0,  16,   0]
  K1( 65,:) = [   0,   0,  16,  16,   0,  48]
  K1( 66,:) = [   0,   0,   0,   0,  48,   0]
  K1( 67,:) = [   0, -54, -18, -18,   0,   0]
  K1( 68,:) = [ -54,   0,   0,   0,   0,   0]
  K1( 69,:) = [ -18,   0,   0,   0,  18,   0]
  K1( 70,:) = [ -18,   0,   0,   0, -18,   0]
  K1( 71,:) = [   0,   0,  18, -18,   0,   0]
  K1( 72,:) = [   0,   0,   0,   0,   0,   0]
  K1( 73,:) = [   0, -54, -18, -18,   0,   0]
  K1( 74,:) = [ -54,   0,   0,   0,   0,   0]
  K1( 75,:) = [ -18,   0,   0,   0, -18,   0]
  K1( 76,:) = [ -18,   0,   0,   0,  18,   0]
  K1( 77,:) = [   0,   0, -18,  18,   0,   0]
  K1( 78,:) = [   0,   0,   0,   0,   0,   0]
  K1( 79,:) = [   0,   0, -18,  18,   0,   0]
  K1( 80,:) = [   0,   0,   0,   0,   0,   0]
  K1( 81,:) = [ -18,   0,   0,   0, -18,   0]
  K1( 82,:) = [  18,   0,   0,   0, -18,   0]
  K1( 83,:) = [   0,   0, -18, -18,   0, -54]
  K1( 84,:) = [   0,   0,   0,   0, -54,   0]
  K1( 85,:) = [   0,   0,  18, -18,   0,   0]
  K1( 86,:) = [   0,   0,   0,   0,   0,   0]
  K1( 87,:) = [  18,   0,   0,   0, -18,   0]
  K1( 88,:) = [ -18,   0,   0,   0, -18,   0]
  K1( 89,:) = [   0,   0, -18, -18,   0, -54]
  K1( 90,:) = [   0,   0,   0,   0, -54,   0]
  K1( 91,:) = [   0, 108,  36,  36,   0,   0]
  K1( 92,:) = [ 108,   0,   0,   0,   0,   0]
  K1( 93,:) = [  36,   0,   0,   0,  36,   0]
  K1( 94,:) = [  36,   0,   0,   0,  36,   0]
  K1( 95,:) = [   0,   0,  36,  36,   0, 108]
  K1( 96,:) = [   0,   0,   0,   0, 108,   0]
  K1( 97,:) = [   0,   0,   0,   0,   0,   0]
  K1( 98,:) = [   0,  36,  12,  12,   0,   0]
  K1( 99,:) = [   0,  12,  36,   0,   0,  12]
  K1(100,:) = [   0,  12,   0,  36,   0,  12]
  K1(101,:) = [   0,   0,   0,   0,   0,   0]
  K1(102,:) = [   0,   0,  12,  12,   0,  36]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(  1,:) = [   0,  36,   0,  12,   0,  12,   0,   0]
  K2(  2,:) = [  36,   0,  12,   0,  12,   0,   0,   0]
  K2(  3,:) = [  12,   0,  36,   0,   0,   0,   0,  12]
  K2(  4,:) = [  12,   0,   0,   0,  36,   0,   0,  12]
  K2(  5,:) = [   0,   0,   0,  12,   0,  12,  36,   0]
  K2(  6,:) = [   0,   0,  12,   0,  12,   0,   0,  36]
  K2(  7,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  K2(  8,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K2(  9,:) = [  16,   0,  48,   0,   0,   0,   0,  16]
  K2( 10,:) = [  16,   0,   0,   0,  48,   0,   0,  16]
  K2( 11,:) = [   0,   0,   0,  16,   0,  16,  48,   0]
  K2( 12,:) = [   0,   0,  16,   0,  16,   0,   0,  48]
  K2( 13,:) = [   0,   6,   0,   2,   0,   2,   0,   0]
  K2( 14,:) = [   6,   0,   2,   0,   2,   0,   0,   0]
  K2( 15,:) = [   2,   0,   0,   0,  -6,   0,   0, -16]
  K2( 16,:) = [   2,   0,  -6,   0,   0,   0,   0, -16]
  K2( 17,:) = [   0,   0,   0, -16,   0, -16, -48,   0]
  K2( 18,:) = [   0,   0, -16,   0, -16,   0,   0, -48]
  K2( 19,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  K2( 20,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K2( 21,:) = [  16,   0,  48,   0,   0,   0,   0,  16]
  K2( 22,:) = [  16,   0,   0,   0,  48,   0,   0,  16]
  K2( 23,:) = [   0,   0,   0,  16,   0,  16,  48,   0]
  K2( 24,:) = [   0,   0,  16,   0,  16,   0,   0,  48]
  K2( 25,:) = [   0,   0,   0,  16,   0,  -2,   6,   0]
  K2( 26,:) = [   0,   0,  16,   0,  -2,   0,   0,   6]
  K2( 27,:) = [  16,   0,   0,   0,   6,   0,   0,  -2]
  K2( 28,:) = [  -2,   0,   6,   0,   0,   0,   0,  16]
  K2( 29,:) = [   0,   6,   0,  -2,   0,  16,   0,   0]
  K2( 30,:) = [   6,   0,  -2,   0,  16,   0,   0,   0]
  K2( 31,:) = [   0,   0,   0,   2,   0, -16,  -6,   0]
  K2( 32,:) = [   0,   0,   2,   0, -16,   0,   0,  -6]
  K2( 33,:) = [   2,   0,   6,   0,   0,   0,   0,   2]
  K2( 34,:) = [ -16,   0,   0,   0, -48,   0,   0, -16]
  K2( 35,:) = [   0,  -6,   0,   2,   0, -16,   0,   0]
  K2( 36,:) = [  -6,   0,   2,   0, -16,   0,   0,   0]
  K2( 37,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  K2( 38,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K2( 39,:) = [  16,   0,  48,   0,   0,   0,   0,  16]
  K2( 40,:) = [  16,   0,   0,   0,  48,   0,   0,  16]
  K2( 41,:) = [   0,   0,   0,  16,   0,  16,  48,   0]
  K2( 42,:) = [   0,   0,  16,   0,  16,   0,   0,  48]
  K2( 43,:) = [   0,   0,   0, -16,   0,   2,  -6,   0]
  K2( 44,:) = [   0,   0, -16,   0,   2,   0,   0,  -6]
  K2( 45,:) = [ -16,   0, -48,   0,   0,   0,   0, -16]
  K2( 46,:) = [   2,   0,   0,   0,   6,   0,   0,   2]
  K2( 47,:) = [   0,  -6,   0, -16,   0,   2,   0,   0]
  K2( 48,:) = [  -6,   0, -16,   0,   2,   0,   0,   0]
  K2( 49,:) = [   0,   0,   0,  -2,   0,  16,   6,   0]
  K2( 50,:) = [   0,   0,  -2,   0,  16,   0,   0,   6]
  K2( 51,:) = [  -2,   0,   0,   0,   6,   0,   0,  16]
  K2( 52,:) = [  16,   0,   6,   0,   0,   0,   0,  -2]
  K2( 53,:) = [   0,   6,   0,  16,   0,  -2,   0,   0]
  K2( 54,:) = [   6,   0,  16,   0,  -2,   0,   0,   0]
  K2( 55,:) = [   0, -48,   0, -16,   0, -16,   0,   0]
  K2( 56,:) = [ -48,   0, -16,   0, -16,   0,   0,   0]
  K2( 57,:) = [ -16,   0,   0,   0,  -6,   0,   0,   2]
  K2( 58,:) = [ -16,   0,  -6,   0,   0,   0,   0,   2]
  K2( 59,:) = [   0,   0,   0,   2,   0,   2,   6,   0]
  K2( 60,:) = [   0,   0,   2,   0,   2,   0,   0,   6]
  K2( 61,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  K2( 62,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K2( 63,:) = [  16,   0,  48,   0,   0,   0,   0,  16]
  K2( 64,:) = [  16,   0,   0,   0,  48,   0,   0,  16]
  K2( 65,:) = [   0,   0,   0,  16,   0,  16,  48,   0]
  K2( 66,:) = [   0,   0,  16,   0,  16,   0,   0,  48]
  K2( 67,:) = [   0, -54,   0, -18,   0, -18,   0,   0]
  K2( 68,:) = [ -54,   0, -18,   0, -18,   0,   0,   0]
  K2( 69,:) = [ -18,   0,   0,   0,   0,   0,   0,  18]
  K2( 70,:) = [ -18,   0,   0,   0, -54,   0,   0, -18]
  K2( 71,:) = [   0,   0,   0,  18,   0, -18,   0,   0]
  K2( 72,:) = [   0,   0,  18,   0, -18,   0,   0,   0]
  K2( 73,:) = [   0, -54,   0, -18,   0, -18,   0,   0]
  K2( 74,:) = [ -54,   0, -18,   0, -18,   0,   0,   0]
  K2( 75,:) = [ -18,   0, -54,   0,   0,   0,   0, -18]
  K2( 76,:) = [ -18,   0,   0,   0,   0,   0,   0,  18]
  K2( 77,:) = [   0,   0,   0, -18,   0,  18,   0,   0]
  K2( 78,:) = [   0,   0, -18,   0,  18,   0,   0,   0]
  K2( 79,:) = [   0,   0,   0, -18,   0,  18,   0,   0]
  K2( 80,:) = [   0,   0, -18,   0,  18,   0,   0,   0]
  K2( 81,:) = [ -18,   0, -54,   0,   0,   0,   0, -18]
  K2( 82,:) = [  18,   0,   0,   0,   0,   0,   0, -18]
  K2( 83,:) = [   0,   0,   0, -18,   0, -18, -54,   0]
  K2( 84,:) = [   0,   0, -18,   0, -18,   0,   0, -54]
  K2( 85,:) = [   0,   0,   0,  18,   0, -18,   0,   0]
  K2( 86,:) = [   0,   0,  18,   0, -18,   0,   0,   0]
  K2( 87,:) = [  18,   0,   0,   0,   0,   0,   0, -18]
  K2( 88,:) = [ -18,   0,   0,   0, -54,   0,   0, -18]
  K2( 89,:) = [   0,   0,   0, -18,   0, -18, -54,   0]
  K2( 90,:) = [   0,   0, -18,   0, -18,   0,   0, -54]
  K2( 91,:) = [   0, 108,   0,  36,   0,  36,   0,   0]
  K2( 92,:) = [ 108,   0,  36,   0,  36,   0,   0,   0]
  K2( 93,:) = [  36,   0, 108,   0,   0,   0,   0,  36]
  K2( 94,:) = [  36,   0,   0,   0, 108,   0,   0,  36]
  K2( 95,:) = [   0,   0,   0,  36,   0,  36, 108,   0]
  K2( 96,:) = [   0,   0,  36,   0,  36,   0,   0, 108]
  K2( 97,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K2( 98,:) = [   0,  36,   0,  12,   0,  12,   0,   0]
  K2( 99,:) = [   0,  12,   0,  36,   0,   0,  12,   0]
  K2(100,:) = [   0,  12,   0,   0,   0,  36,  12,   0]
  K2(101,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K2(102,:) = [   0,   0,   0,  12,   0,  12,  36,   0]
  K2 = (1._/**/REALKIND / 3) * K2

  KL(  1,:) = [   0,  36,   0,  12,   0,  12,   0,   0]
  KL(  2,:) = [  36,   0,  12,   0,  12,   0,   0,   0]
  KL(  3,:) = [  12,   0,  36,   0,   0,   0,  12,   0]
  KL(  4,:) = [  12,   0,   0,   0,  36,   0,  12,   0]
  KL(  5,:) = [   0,   0,   0,  12,   0,  12,   0,  36]
  KL(  6,:) = [   0,   0,  12,   0,  12,   0,  36,   0]
  KL(  7,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  KL(  8,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  KL(  9,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  KL( 10,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  KL( 11,:) = [   0,   0,   0,  16,   0,  16,   0,  48]
  KL( 12,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  KL( 13,:) = [   0,   6,   0,   2,   0,   2,   0,   0]
  KL( 14,:) = [   6,   0,   2,   0,   2,   0,   0,   0]
  KL( 15,:) = [   2,   0,   0,   0,  -6,   0, -16,   0]
  KL( 16,:) = [   2,   0,  -6,   0,   0,   0, -16,   0]
  KL( 17,:) = [   0,   0,   0, -16,   0, -16,   0, -48]
  KL( 18,:) = [   0,   0, -16,   0, -16,   0, -48,   0]
  KL( 19,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  KL( 20,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  KL( 21,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  KL( 22,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  KL( 23,:) = [   0,   0,   0,  16,   0,  16,   0,  48]
  KL( 24,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  KL( 25,:) = [   0,   0,   0,  16,   0,  -2,   0,   6]
  KL( 26,:) = [   0,   0,  16,   0,  -2,   0,   6,   0]
  KL( 27,:) = [  16,   0,   0,   0,   6,   0,  -2,   0]
  KL( 28,:) = [  -2,   0,   6,   0,   0,   0,  16,   0]
  KL( 29,:) = [   0,   6,   0,  -2,   0,  16,   0,   0]
  KL( 30,:) = [   6,   0,  -2,   0,  16,   0,   0,   0]
  KL( 31,:) = [   0,   0,   0,   2,   0, -16,   0,  -6]
  KL( 32,:) = [   0,   0,   2,   0, -16,   0,  -6,   0]
  KL( 33,:) = [   2,   0,   6,   0,   0,   0,   2,   0]
  KL( 34,:) = [ -16,   0,   0,   0, -48,   0, -16,   0]
  KL( 35,:) = [   0,  -6,   0,   2,   0, -16,   0,   0]
  KL( 36,:) = [  -6,   0,   2,   0, -16,   0,   0,   0]
  KL( 37,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  KL( 38,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  KL( 39,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  KL( 40,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  KL( 41,:) = [   0,   0,   0,  16,   0,  16,   0,  48]
  KL( 42,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  KL( 43,:) = [   0,   0,   0, -16,   0,   2,   0,  -6]
  KL( 44,:) = [   0,   0, -16,   0,   2,   0,  -6,   0]
  KL( 45,:) = [ -16,   0, -48,   0,   0,   0, -16,   0]
  KL( 46,:) = [   2,   0,   0,   0,   6,   0,   2,   0]
  KL( 47,:) = [   0,  -6,   0, -16,   0,   2,   0,   0]
  KL( 48,:) = [  -6,   0, -16,   0,   2,   0,   0,   0]
  KL( 49,:) = [   0,   0,   0,  -2,   0,  16,   0,   6]
  KL( 50,:) = [   0,   0,  -2,   0,  16,   0,   6,   0]
  KL( 51,:) = [  -2,   0,   0,   0,   6,   0,  16,   0]
  KL( 52,:) = [  16,   0,   6,   0,   0,   0,  -2,   0]
  KL( 53,:) = [   0,   6,   0,  16,   0,  -2,   0,   0]
  KL( 54,:) = [   6,   0,  16,   0,  -2,   0,   0,   0]
  KL( 55,:) = [   0, -48,   0, -16,   0, -16,   0,   0]
  KL( 56,:) = [ -48,   0, -16,   0, -16,   0,   0,   0]
  KL( 57,:) = [ -16,   0,   0,   0,  -6,   0,   2,   0]
  KL( 58,:) = [ -16,   0,  -6,   0,   0,   0,   2,   0]
  KL( 59,:) = [   0,   0,   0,   2,   0,   2,   0,   6]
  KL( 60,:) = [   0,   0,   2,   0,   2,   0,   6,   0]
  KL( 61,:) = [   0,  48,   0,  16,   0,  16,   0,   0]
  KL( 62,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  KL( 63,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  KL( 64,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  KL( 65,:) = [   0,   0,   0,  16,   0,  16,   0,  48]
  KL( 66,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  KL( 67,:) = [   0, -54,   0, -18,   0, -18,   0,   0]
  KL( 68,:) = [ -54,   0, -18,   0, -18,   0,   0,   0]
  KL( 69,:) = [ -18,   0,   0,   0,   0,   0,  18,   0]
  KL( 70,:) = [ -18,   0,   0,   0, -54,   0, -18,   0]
  KL( 71,:) = [   0,   0,   0,  18,   0, -18,   0,   0]
  KL( 72,:) = [   0,   0,  18,   0, -18,   0,   0,   0]
  KL( 73,:) = [   0, -54,   0, -18,   0, -18,   0,   0]
  KL( 74,:) = [ -54,   0, -18,   0, -18,   0,   0,   0]
  KL( 75,:) = [ -18,   0, -54,   0,   0,   0, -18,   0]
  KL( 76,:) = [ -18,   0,   0,   0,   0,   0,  18,   0]
  KL( 77,:) = [   0,   0,   0, -18,   0,  18,   0,   0]
  KL( 78,:) = [   0,   0, -18,   0,  18,   0,   0,   0]
  KL( 79,:) = [   0,   0,   0, -18,   0,  18,   0,   0]
  KL( 80,:) = [   0,   0, -18,   0,  18,   0,   0,   0]
  KL( 81,:) = [ -18,   0, -54,   0,   0,   0, -18,   0]
  KL( 82,:) = [  18,   0,   0,   0,   0,   0, -18,   0]
  KL( 83,:) = [   0,   0,   0, -18,   0, -18,   0, -54]
  KL( 84,:) = [   0,   0, -18,   0, -18,   0, -54,   0]
  KL( 85,:) = [   0,   0,   0,  18,   0, -18,   0,   0]
  KL( 86,:) = [   0,   0,  18,   0, -18,   0,   0,   0]
  KL( 87,:) = [  18,   0,   0,   0,   0,   0, -18,   0]
  KL( 88,:) = [ -18,   0,   0,   0, -54,   0, -18,   0]
  KL( 89,:) = [   0,   0,   0, -18,   0, -18,   0, -54]
  KL( 90,:) = [   0,   0, -18,   0, -18,   0, -54,   0]
  KL( 91,:) = [   0, 108,   0,  36,   0,  36,   0,   0]
  KL( 92,:) = [ 108,   0,  36,   0,  36,   0,   0,   0]
  KL( 93,:) = [  36,   0, 108,   0,   0,   0,  36,   0]
  KL( 94,:) = [  36,   0,   0,   0, 108,   0,  36,   0]
  KL( 95,:) = [   0,   0,   0,  36,   0,  36,   0, 108]
  KL( 96,:) = [   0,   0,  36,   0,  36,   0, 108,   0]
  KL( 97,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  KL( 98,:) = [   0,  36,   0,  12,   0,  12,   0,   0]
  KL( 99,:) = [   0,  12,   0,  36,   0,   0,   0,  12]
  KL(100,:) = [   0,  12,   0,   0,   0,  36,   0,  12]
  KL(101,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  KL(102,:) = [   0,   0,   0,  12,   0,  12,   0,  36]
  KL = (1._/**/REALKIND / 3) * KL

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+6*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND



module ol_forced_parameters_ppjjj_ew_uuxccxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppjjj_ew_uuxccxg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppjjj_ew_uuxccxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 32 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(59)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,44), wf8(8,55), wf32(32,90)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(42), c(44)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppjjj_ew_uuxccxg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppjjj_ew_uuxccxg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppjjj_ew_uuxccxg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**2*gQCD)/9._/**/REALKIND
    f( 2) = CI*eQED**2*gQCD
    f( 3) = CI*gQCD**3
    f( 4) = gQCD**3
    f( 5) = (4*CI*countertermnorm*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**2*gQCD**3
    f( 7) = countertermnorm*eQED**2*gQCD**3
    f( 8) = (4*CI*countertermnorm*ctGcc*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 9) = CI*countertermnorm*ctGcc*eQED**2*gQCD**3
    f(10) = (4*CI*countertermnorm*ctGqq*eQED**2*gQCD**3)/9._/**/REALKIND
    f(11) = CI*countertermnorm*ctGqq*eQED**2*gQCD**3
    f(12) = (4*CI*countertermnorm*ctVcc*eQED**2*gQCD**3)/9._/**/REALKIND
    f(13) = CI*countertermnorm*ctVcc*eQED**2*gQCD**3
    f(14) = (4*CI*countertermnorm*ctVqq*eQED**2*gQCD**3)/9._/**/REALKIND
    f(15) = CI*countertermnorm*ctVqq*eQED**2*gQCD**3
    f(16) = countertermnorm*ctZGG*eQED**2*gQCD**3
    f(17) = CI*countertermnorm*gQCD**5
    f(18) = countertermnorm*gQCD**5
    f(19) = CI*countertermnorm*ctGcc*gQCD**5
    f(20) = countertermnorm*ctGcc*gQCD**5
    f(21) = CI*countertermnorm*ctGqq*gQCD**5
    f(22) = countertermnorm*ctGqq*gQCD**5
    f(23) = countertermnorm*ctVVV*gQCD**5
    f(24) = (4*CI*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(25) = CI*eQED**2*gQCD**3*integralnorm*SwB
    f(26) = (4*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(27) = eQED**2*gQCD**3*integralnorm*SwB
    f(28) = (CI*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(29) = CI*gQCD**5*integralnorm*SwB
    f(30) = (gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(31) = gQCD**5*integralnorm*SwB
    f(32) = (CI*eQED**2*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(33) = (eQED**2*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(34) = (2*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(35) = (4*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(36) = (8*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(37) = eQED**2*gQCD**3*integralnorm*SwF
    f(38) = 2*eQED**2*gQCD**3*integralnorm*SwF
    f(39) = CI*gQCD**5*integralnorm*SwF
    f(40) = 2*CI*gQCD**5*integralnorm*SwF
    f(41) = gQCD**5*integralnorm*SwF
    f(42) = 2*gQCD**5*integralnorm*SwF

  c = [ 18*CI*f(24), 54*CI*f(24), 18*CI*f(25), 54*CI*f(25), 6*f(26), 18*f(26), 48*f(26), 6*f(27), 18*f(27), 48*f(27), 27*CI*f(28) &
    , 54*CI*f(28), 3*CI*f(29), 9*CI*f(29), 24*CI*f(29), 27*CI*f(29), 54*CI*f(29), 18*f(30), 54*f(30), f(31), 3*f(31), 6*f(31) &
    , 8*f(31), 9*f(31), 10*f(31), 18*f(31), 21*f(31), 24*f(31), 27*f(31), 54*f(31), 18*CI*f(32), 6*f(33), 18*f(33), 18*f(34) &
    , 18*f(35), 18*f(36), 18*f(37), 18*f(38), 9*CI*f(39), 9*CI*f(40), 3*f(41), 9*f(41), 3*f(42), 9*f(42) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(4) = 1 /((L(5,20))+L(6,20))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(8) = 1 /((L(5,24))+L(6,24))
  den(11) = 1 /((L(5,17))+L(6,17))
  den(13) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(15) = 1 /((L(5,18))+L(6,18))
  den(20) = 1 /((L(5,28))+L(6,28))
  den(23) = 1 /((L(5,19))+L(6,19))
  den(28) = 1 /((L(5,11))+L(6,11))
  den(35) = 1 /((L(5,7))+L(6,7))
  den(40) = 1 /((L(5,14))+L(6,14))
  den(47) = 1 /((L(5,13))+L(6,13))
  den(54) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(57) = 1 /((L(5,28) - MZ2)+L(6,28))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(6)*den(8)
  den(12) = den(2)*den(11)
  den(14) = den(11)*den(13)
  den(16) = den(2)*den(15)
  den(17) = den(13)*den(15)
  den(18) = den(2)*den(6)
  den(19) = den(1)*den(13)
  den(21) = den(2)*den(20)
  den(22) = den(1)*den(21)
  den(24) = den(1)*den(23)
  den(25) = den(2)*den(24)
  den(26) = den(4)*den(20)
  den(27) = den(1)*den(26)
  den(29) = den(1)*den(28)
  den(30) = den(4)*den(29)
  den(31) = den(6)*den(28)
  den(32) = den(4)*den(31)
  den(33) = den(8)*den(20)
  den(34) = den(1)*den(33)
  den(36) = den(1)*den(35)
  den(37) = den(8)*den(36)
  den(38) = den(6)*den(35)
  den(39) = den(8)*den(38)
  den(41) = den(2)*den(40)
  den(42) = den(11)*den(41)
  den(43) = den(13)*den(40)
  den(44) = den(11)*den(43)
  den(45) = den(11)*den(23)
  den(46) = den(2)*den(45)
  den(48) = den(2)*den(47)
  den(49) = den(15)*den(48)
  den(50) = den(13)*den(47)
  den(51) = den(15)*den(50)
  den(52) = den(15)*den(23)
  den(53) = den(2)*den(52)
  den(55) = den(11)*den(54)
  den(56) = den(15)*den(54)
  den(58) = den(4)*den(57)
  den(59) = den(8)*den(57)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppjjj_ew_uuxccxg_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,90))
  allocate(M1helarray(6,hel_states))
  allocate(M1helarray_ct(8,hel_states))
  allocate(M0_col1_helarray(8,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(8,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppjjj_ew_uuxccxg_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up charm anti-charm glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppjjj_ew_uuxccxg_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppjjj_ew_uuxccxg_1, only: &
    & external_perm_ppjjj_ew_uuxccxg_1, &
    & external_perm_inv_ppjjj_ew_uuxccxg_1, &
    & extcomb_perm_ppjjj_ew_uuxccxg_1, &
    & average_factor_ppjjj_ew_uuxccxg_1
  use ol_external_ppjjj_ew_uuxccxg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppjjj_ew_uuxccxg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(6), M2(8)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(90)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,90))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppjjj_ew_uuxccxg_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,3), n3(:,4), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,3), 20, ZERO, 0_intkind1, wf4(:,4), n2(1))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,5), n3(:,6), t3x4(:,:,4))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,6), n3(:,8), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,6), 24, ZERO, 0_intkind1, wf4(:,7), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,4), n3(:,9), t3x8(:,:,4))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,5), n3(:,10), t3x8(:,:,5))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,8), n3(:,11), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,8), 17, ZERO, 0_intkind1, wf4(:,9), n2(3))
  call vert_QA_V(ntry, wf4(:,9), ex2(:), wf8(:,6), n3(:,12), t3x8(:,:,6))
  call vert_QA_Z(gZu,ntry, ex3(:), ex4(:), wf4(:,10), n3(:,13), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, wf4(:,9), ex2(:), wf8(:,7), n3(:,14), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,11), n3(:,15), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,11), 18, ZERO, 0_intkind1, wf4(:,12), n2(4))
  call vert_QA_V(ntry, ex1(:), wf4(:,12), wf8(:,8), n3(:,16), t3x8(:,:,8))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,12), wf8(:,9), n3(:,17), t3x8(:,:,9))
  call counter_VG_G(ntry, wf4(:,5), ex5(:), 16, wf8(:,10), 19, n3(:,18), t3x8(:,:,10))
  call counter_GG_V(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,11), n3(:,19), t3x8(:,:,11))
  call counter_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,12), n3(:,20), t3x8(:,:,12))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,13), n3(:,21), t3x8(:,:,13))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,5), wf8(:,14), n3(:,22), t3x8(:,:,14))
  call counter_AV_Q_LR(EWctGuu,ntry, ex4(:), wf4(:,1), wf8(:,15), n3(:,23), t3x8(:,:,15))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,13), n3(:,24), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,13), 24, ZERO, 0_intkind1, wf4(:,14), n2(5))
  call counter_AV_Q_LR(EWctGuu,ntry, ex4(:), ex5(:), wf4(:,15), n3(:,25), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,15), 24, ZERO, 0_intkind1, wf4(:,16), n2(6))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,16), n3(:,26), t3x8(:,:,16))
  call counter_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,17), n3(:,27), t3x8(:,:,17))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,1), ex3(:), wf8(:,18), n3(:,28), t3x8(:,:,18))
  call counter_VQ_A(ntry, ex5(:), ex3(:), wf4(:,17), n3(:,29), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,17), 20, ZERO, 0_intkind1, wf4(:,18), n2(7))
  call counter_VQ_A_LR(EWctGuu,ntry, ex5(:), ex3(:), wf4(:,19), n3(:,30), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,19), 20, ZERO, 0_intkind1, wf4(:,20), n2(8))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,21), n3(:,31), t3x4(:,:,13))
  call counter_QA_V_LR(EWctGuu,ntry, ex3(:), ex4(:), wf4(:,22), n3(:,32), t3x4(:,:,14))
  call counter_QA_Z(gZu,ntry, ex3(:), ex4(:), wf4(:,23), n3(:,33), t3x4(:,:,15))
  call counter_QA_V(ntry, wf4(:,9), ex2(:), wf8(:,19), n3(:,34), t3x8(:,:,19))
  call counter_QA_Z(gZu,ntry, wf4(:,9), ex2(:), wf8(:,20), n3(:,35), t3x8(:,:,20))
  call counter_QA_V_LR(EWctGuu,ntry, wf4(:,9), ex2(:), wf8(:,21), n3(:,36), t3x8(:,:,21))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,24), n3(:,37), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,24), 18, ZERO, 0_intkind1, wf4(:,25), n2(9))
  call vert_QA_V(ntry, ex1(:), wf4(:,25), wf8(:,22), n3(:,38), t3x8(:,:,22))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,25), wf8(:,23), n3(:,39), t3x8(:,:,23))
  call counter_AV_Q_LR(EWctGuu,ntry, ex2(:), ex5(:), wf4(:,26), n3(:,40), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,26), 18, ZERO, 0_intkind1, wf4(:,27), n2(10))
  call vert_QA_V(ntry, ex1(:), wf4(:,27), wf8(:,24), n3(:,41), t3x8(:,:,24))
  call counter_QA_V(ntry, ex1(:), wf4(:,12), wf8(:,25), n3(:,42), t3x8(:,:,25))
  call counter_QA_Z(gZu,ntry, ex1(:), wf4(:,12), wf8(:,26), n3(:,43), t3x8(:,:,26))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), wf4(:,12), wf8(:,27), n3(:,44), t3x8(:,:,27))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,28), n3(:,45), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,28), 17, ZERO, 0_intkind1, wf4(:,29), n2(11))
  call vert_QA_V(ntry, wf4(:,29), ex2(:), wf8(:,28), n3(:,46), t3x8(:,:,28))
  call vert_QA_Z(gZu,ntry, wf4(:,29), ex2(:), wf8(:,29), n3(:,47), t3x8(:,:,29))
  call counter_VQ_A_LR(EWctGuu,ntry, ex5(:), ex1(:), wf4(:,30), n3(:,48), t3x4(:,:,19))
  call prop_Q_A(ntry, wf4(:,30), 17, ZERO, 0_intkind1, wf4(:,31), n2(12))
  call vert_QA_V(ntry, wf4(:,31), ex2(:), wf8(:,30), n3(:,49), t3x8(:,:,30))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,32), n3(:,50), t3x4(:,:,20))
  call vert_UV_W(ntry, wf4(:,32), 3, ex5(:), 16, wf8(:,31), n3(:,51), t3x8(:,:,31))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), ex2(:), wf4(:,33), n3(:,52), t3x4(:,:,21))
  call vert_UV_W(ntry, wf4(:,33), 3, ex5(:), 16, wf8(:,32), n3(:,53), t3x8(:,:,32))
  call vert_AV_Q(ntry, ex4(:), wf4(:,32), wf8(:,33), n3(:,54), t3x8(:,:,33))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,34), n3(:,55), t3x4(:,:,22))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,34), wf8(:,34), n3(:,56), t3x8(:,:,34))
  call vert_AV_Q(ntry, ex4(:), wf4(:,33), wf8(:,35), n3(:,57), t3x8(:,:,35))
  call vert_VQ_A(ntry, wf4(:,32), ex3(:), wf8(:,36), n3(:,58), t3x8(:,:,36))
  call vert_ZQ_A(gZu,ntry, wf4(:,34), ex3(:), wf8(:,37), n3(:,59), t3x8(:,:,37))
  call vert_VQ_A(ntry, wf4(:,33), ex3(:), wf8(:,38), n3(:,60), t3x8(:,:,38))
  call vert_UV_W(ntry, wf4(:,2), 12, ex5(:), 16, wf8(:,39), n3(:,61), t3x8(:,:,39))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,35), n2(13))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,36), n2(14))
  call vert_QA_V(ntry, wf4(:,4), ex4(:), wf8(:,40), n3(:,62), t3x8(:,:,40))
  call counter_Q_A(ctcc,4,ntry, wf4(:,4), 20, wf4(:,37), n2(15))
  call prop_A_Q(ntry, wf8(:,2), 11, ZERO, 0_intkind1, wf8(:,41), n2(16))
  call prop_A_Q(ntry, wf8(:,3), 11, ZERO, 0_intkind1, wf8(:,42), n2(17))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,4), 20, wf4(:,38), n2(18))
  call vert_QA_V(ntry, ex3(:), wf4(:,7), wf8(:,43), n3(:,63), t3x8(:,:,41))
  call counter_A_Q(ctcc,4,ntry, wf4(:,7), 24, wf4(:,39), n2(19))
  call prop_Q_A(ntry, wf8(:,4), 7, ZERO, 0_intkind1, wf8(:,44), n2(20))
  call prop_Q_A(ntry, wf8(:,5), 7, ZERO, 0_intkind1, wf8(:,45), n2(21))
  call counter_A_Q_LR(EWctuu,ntry, wf4(:,7), 24, wf4(:,40), n2(22))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,46), n3(:,64), t3x8(:,:,42))
  call counter_Q_A(ctqq,2,ntry, wf4(:,9), 17, wf4(:,41), n2(23))
  call prop_A_Q(ntry, wf8(:,46), 14, ZERO, 0_intkind1, wf8(:,47), n2(24))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,10), wf8(:,48), n3(:,65), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,48), 14, ZERO, 0_intkind1, wf8(:,49), n2(25))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,9), 17, wf4(:,42), n2(26))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,50), n3(:,66), t3x8(:,:,44))
  call counter_A_Q(ctqq,2,ntry, wf4(:,12), 18, wf4(:,43), n2(27))
  call prop_Q_A(ntry, wf8(:,50), 13, ZERO, 0_intkind1, wf8(:,51), n2(28))
  call vert_ZQ_A(gZu,ntry, wf4(:,10), ex1(:), wf8(:,52), n3(:,67), t3x8(:,:,45))
  call prop_Q_A(ntry, wf8(:,52), 13, ZERO, 0_intkind1, wf8(:,53), n2(29))
  call counter_A_Q_LR(EWctuu,ntry, wf4(:,12), 18, wf4(:,44), n2(30))
  call vert_QA_Z(gZu,ntry, wf4(:,4), ex4(:), wf8(:,54), n3(:,68), t3x8(:,:,46))
  call vert_QA_Z(gZu,ntry, ex3(:), wf4(:,7), wf8(:,55), n3(:,69), t3x8(:,:,47))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf8(:,1), A(:,1), n3(:,70), t3x32(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,2), A(:,2), n3(:,71), t3x32(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,3), A(:,3), n3(:,72), t3x32(:,:,3), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,2), A(:,4), n3(:,73), t3x32(:,:,4), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,4), A(:,5), n3(:,74), t3x32(:,:,5), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,5), A(:,6), n3(:,75), t3x32(:,:,6), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,4), A(:,7), n3(:,76), t3x32(:,:,7), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,6), A(:,8), n3(:,77), t3x32(:,:,8), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,7), A(:,9), n3(:,78), t3x32(:,:,9), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,6), A(:,10), n3(:,79), t3x32(:,:,10), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,8), A(:,11), n3(:,80), t3x32(:,:,11), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,9), A(:,12), n3(:,81), t3x32(:,:,12), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,8), A(:,13), n3(:,82), t3x32(:,:,13), nhel, den(16))

    call Hcont_VV(nsync, wf4(:,2), wf8(:,10), A(:,14), n3(:,83), t3x32(:,:,14), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,11), A(:,15), n3(:,84), t3x32(:,:,15), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,12), A(:,16), n3(:,85), t3x32(:,:,16), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,13), A(:,17), n3(:,86), t3x32(:,:,17), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,14), A(:,18), n3(:,87), t3x32(:,:,18), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,13), A(:,19), n3(:,88), t3x32(:,:,19), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,15), A(:,20), n3(:,89), t3x32(:,:,20), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,14), A(:,21), n3(:,90), t3x32(:,:,21), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,14), A(:,22), n3(:,91), t3x32(:,:,22), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,14), A(:,23), n3(:,92), t3x32(:,:,23), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,16), A(:,24), n3(:,93), t3x32(:,:,24), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,16), A(:,25), n3(:,94), t3x32(:,:,25), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,17), A(:,26), n3(:,95), t3x32(:,:,26), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,16), A(:,27), n3(:,96), t3x32(:,:,27), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,18), A(:,28), n3(:,97), t3x32(:,:,28), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,18), A(:,29), n3(:,98), t3x32(:,:,29), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,18), A(:,30), n3(:,99), t3x32(:,:,30), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,18), A(:,31), n3(:,100), t3x32(:,:,31), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,20), A(:,32), n3(:,101), t3x32(:,:,32), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,21), A(:,33), n3(:,102), t3x32(:,:,33), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,22), A(:,34), n3(:,103), t3x32(:,:,34), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,21), A(:,35), n3(:,104), t3x32(:,:,35), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,23), A(:,36), n3(:,105), t3x32(:,:,36), nhel, den(14))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,21), A(:,37), n3(:,106), t3x32(:,:,37), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,22), A(:,38), n3(:,107), t3x32(:,:,38), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,21), A(:,39), n3(:,108), t3x32(:,:,39), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,23), A(:,40), n3(:,109), t3x32(:,:,40), nhel, den(17))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,21), A(:,41), n3(:,110), t3x32(:,:,41), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,22), A(:,42), n3(:,111), t3x32(:,:,42), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,19), A(:,43), n3(:,112), t3x32(:,:,43), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,20), A(:,44), n3(:,113), t3x32(:,:,44), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,19), A(:,45), n3(:,114), t3x32(:,:,45), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,21), A(:,46), n3(:,115), t3x32(:,:,46), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,22), A(:,47), n3(:,116), t3x32(:,:,47), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,23), A(:,48), n3(:,117), t3x32(:,:,48), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,22), A(:,49), n3(:,118), t3x32(:,:,49), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,24), A(:,50), n3(:,119), t3x32(:,:,50), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,25), A(:,51), n3(:,120), t3x32(:,:,51), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,26), A(:,52), n3(:,121), t3x32(:,:,52), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,25), A(:,53), n3(:,122), t3x32(:,:,53), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,27), A(:,54), n3(:,123), t3x32(:,:,54), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,28), A(:,55), n3(:,124), t3x32(:,:,55), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,29), A(:,56), n3(:,125), t3x32(:,:,56), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,28), A(:,57), n3(:,126), t3x32(:,:,57), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,30), A(:,58), n3(:,127), t3x32(:,:,58), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,31), A(:,59), n3(:,128), t3x32(:,:,59), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,32), A(:,60), n3(:,129), t3x32(:,:,60), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,33), A(:,61), n3(:,130), t3x32(:,:,61), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,34), A(:,62), n3(:,131), t3x32(:,:,62), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,33), A(:,63), n3(:,132), t3x32(:,:,63), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,35), A(:,64), n3(:,133), t3x32(:,:,64), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,36), A(:,65), n3(:,134), t3x32(:,:,65), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,37), A(:,66), n3(:,135), t3x32(:,:,66), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,36), A(:,67), n3(:,136), t3x32(:,:,67), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,38), A(:,68), n3(:,137), t3x32(:,:,68), nhel, den(9))
    call Hcont_VV(nsync, wf8(:,39), wf4(:,35), A(:,69), n3(:,138), t3x32(:,:,69), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,36), A(:,70), n3(:,139), t3x32(:,:,70), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,35), wf8(:,40), A(:,71), n3(:,140), t3x32(:,:,71), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,41), A(:,72), n3(:,141), t3x32(:,:,72), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,42), A(:,73), n3(:,142), t3x32(:,:,73), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,41), A(:,74), n3(:,143), t3x32(:,:,74), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,41), wf4(:,38), A(:,75), n3(:,144), t3x32(:,:,75), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,35), wf8(:,43), A(:,76), n3(:,145), t3x32(:,:,76), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,44), A(:,77), n3(:,146), t3x32(:,:,77), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,45), A(:,78), n3(:,147), t3x32(:,:,78), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,44), A(:,79), n3(:,148), t3x32(:,:,79), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,44), wf4(:,40), A(:,80), n3(:,149), t3x32(:,:,80), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,41), wf8(:,47), A(:,81), n3(:,150), t3x32(:,:,81), nhel, den(42))
    call Hcont_QA(nsync, wf4(:,41), wf8(:,49), A(:,82), n3(:,151), t3x32(:,:,82), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,41), wf8(:,47), A(:,83), n3(:,152), t3x32(:,:,83), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,47), wf4(:,42), A(:,84), n3(:,153), t3x32(:,:,84), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,36), A(:,85), n3(:,154), t3x32(:,:,85), nhel, den(46))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,51), A(:,86), n3(:,155), t3x32(:,:,86), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,53), A(:,87), n3(:,156), t3x32(:,:,87), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,51), A(:,88), n3(:,157), t3x32(:,:,88), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,51), wf4(:,44), A(:,89), n3(:,158), t3x32(:,:,89), nhel, den(49))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,36), A(:,90), n3(:,159), t3x32(:,:,90), nhel, den(53))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(8) ! M1helarray(8,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,8)%j+A(j,11)%j)*f(1)+(A(j,9)%j+A(j,12)%j)*f(2)
  M1(2)%j = ((-A(j,10)%j-A(j,13)%j)*f(3))/6._/**/REALKIND
  M1(3)%j = ((A(j,4)%j+A(j,13)%j)*f(3))/2._/**/REALKIND+(CI*A(j,1)%j*f(4))/2._/**/REALKIND
  M1(4)%j = ((A(j,7)%j+A(j,10)%j)*f(3))/2._/**/REALKIND-(CI*A(j,1)%j*f(4))/2._/**/REALKIND
  M1(5)%j = (A(j,2)%j+A(j,5)%j)*f(1)+(A(j,3)%j+A(j,6)%j)*f(2)
  M1(6)%j = ((-A(j,4)%j-A(j,7)%j)*f(3))/6._/**/REALKIND

  M2(1)%j = (-A(j,81)%j-A(j,86)%j)*f(5)+(-A(j,82)%j-A(j,87)%j)*f(6)+((-A(j,38)%j-A(j,42)%j-A(j,46)%j-A(j,50)%j-A(j,54)%j-A(j,58)%j &
       +A(j,84)%j+A(j,89)%j)*f(6))/6._/**/REALKIND+(A(j,47)%j+A(j,55)%j)*f(10)+(A(j,48)%j+A(j,56)%j)*f(11)+(A(j,35)%j &
       +A(j,39)%j)*f(12)+(A(j,36)%j+A(j,40)%j)*f(13)+(A(j,43)%j+A(j,51)%j)*f(14)+(A(j,44)%j+A(j,52)%j)*f(15)-A(j,15)%j*f(16)
  M2(2)%j = ((A(j,83)%j+A(j,85)%j+A(j,88)%j+A(j,90)%j)*f(17))/6._/**/REALKIND+((-A(j,37)%j-A(j,41)%j)*f(19))/6._/**/REALKIND+(( &
       -A(j,45)%j-A(j,49)%j-A(j,53)%j-A(j,57)%j)*f(21))/6._/**/REALKIND
  M2(3)%j = ((A(j,20)%j+A(j,32)%j+A(j,42)%j+A(j,50)%j+A(j,54)%j+A(j,64)%j-A(j,75)%j-A(j,89)%j)*f(6))/2._/**/REALKIND &
       +(CI*(A(j,34)%j+A(j,60)%j)*f(7))/2._/**/REALKIND
  M2(4)%j = ((-A(j,71)%j-A(j,74)%j-A(j,88)%j-A(j,90)%j)*f(17))/2._/**/REALKIND+(CI*(A(j,69)%j-A(j,70)%j)*f(18))/2._/**/REALKIND &
       +((A(j,19)%j+A(j,31)%j+A(j,41)%j)*f(19))/2._/**/REALKIND+(CI*A(j,33)%j*f(20))/2._/**/REALKIND+((A(j,49)%j+A(j,53)%j &
       +A(j,63)%j)*f(21))/2._/**/REALKIND+(CI*A(j,59)%j*f(22))/2._/**/REALKIND+(CI*A(j,16)%j*f(23))/2._/**/REALKIND
  M2(5)%j = ((A(j,24)%j+A(j,28)%j+A(j,38)%j+A(j,46)%j+A(j,58)%j+A(j,68)%j-A(j,80)%j-A(j,84)%j)*f(6))/2._/**/REALKIND+(CI*( &
       -A(j,34)%j-A(j,60)%j)*f(7))/2._/**/REALKIND
  M2(6)%j = ((-A(j,76)%j-A(j,79)%j-A(j,83)%j-A(j,85)%j)*f(17))/2._/**/REALKIND+(CI*(-A(j,69)%j+A(j,70)%j)*f(18))/2._/**/REALKIND &
       +((A(j,23)%j+A(j,27)%j+A(j,37)%j)*f(19))/2._/**/REALKIND-(CI*A(j,33)%j*f(20))/2._/**/REALKIND+((A(j,45)%j+A(j,57)%j &
       +A(j,67)%j)*f(21))/2._/**/REALKIND-(CI*A(j,59)%j*f(22))/2._/**/REALKIND-(CI*A(j,16)%j*f(23))/2._/**/REALKIND
  M2(7)%j = ((A(j,71)%j+A(j,74)%j+A(j,76)%j+A(j,79)%j)*f(17))/6._/**/REALKIND+((-A(j,19)%j-A(j,23)%j-A(j,27)%j &
       -A(j,31)%j)*f(19))/6._/**/REALKIND+((-A(j,63)%j-A(j,67)%j)*f(21))/6._/**/REALKIND
  M2(8)%j = (-A(j,72)%j-A(j,77)%j)*f(5)+(-A(j,73)%j-A(j,78)%j)*f(6)+((-A(j,20)%j-A(j,24)%j-A(j,28)%j-A(j,32)%j-A(j,64)%j-A(j,68)%j &
       +A(j,75)%j+A(j,80)%j)*f(6))/6._/**/REALKIND+(A(j,21)%j+A(j,29)%j)*f(8)+(A(j,22)%j+A(j,30)%j)*f(9)+(A(j,17)%j &
       +A(j,25)%j)*f(12)+(A(j,18)%j+A(j,26)%j)*f(13)+(A(j,61)%j+A(j,65)%j)*f(14)+(A(j,62)%j+A(j,66)%j)*f(15)-A(j,14)%j*f(16)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(6), Mct(8)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 6
    do j = 1, 8
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+6*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_uuxccxg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(8)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 8 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+6*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppjjj_ew_uuxccxg_1_/**/REALKIND
