
module ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(34,2), K2(34,6), KL(34,6), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 16, -2]
  K1( 2,:) = [ -2, 16]
  K1( 3,:) = [  0,  0]
  K1( 4,:) = [  0,  0]
  K1( 5,:) = [  0,  0]
  K1( 6,:) = [  0,  0]
  K1( 7,:) = [  0,  0]
  K1( 8,:) = [  0,  0]
  K1( 9,:) = [  0,  0]
  K1(10,:) = [  0,  0]
  K1(11,:) = [  0,  0]
  K1(12,:) = [  0,  0]
  K1(13,:) = [  0,  0]
  K1(14,:) = [  0,  0]
  K1(15,:) = [  0,  0]
  K1(16,:) = [  0,  0]
  K1(17,:) = [  0,  0]
  K1(18,:) = [  0,  0]
  K1(19,:) = [  0,  0]
  K1(20,:) = [  0,  0]
  K1(21,:) = [  0,  0]
  K1(22,:) = [  0,  0]
  K1(23,:) = [  0,  0]
  K1(24,:) = [  0,  0]
  K1(25,:) = [  0,  0]
  K1(26,:) = [  0,  0]
  K1(27,:) = [  0,  0]
  K1(28,:) = [  0,  0]
  K1(29,:) = [  0,  0]
  K1(30,:) = [  0,  0]
  K1(31,:) = [  0,  0]
  K1(32,:) = [  0,  0]
  K1(33,:) = [ 16, -2]
  K1(34,:) = [ -2, 16]
  K1 = (1._/**/REALKIND / 3) * K1

  K2( 1,:) = [  0, 16,  0, -2,  0,  6]
  K2( 2,:) = [  0, -2,  0, 16,  0,  6]
  K2( 3,:) = [  0,  0,  0,  0,  0,  0]
  K2( 4,:) = [  0,  0,  0,  0,  0,  0]
  K2( 5,:) = [  0,  0,  0,  0,  0,  0]
  K2( 6,:) = [  0,  0,  0,  0,  0,  0]
  K2( 7,:) = [  0,  0,  0,  0,  0,  0]
  K2( 8,:) = [  0,  0,  0,  0,  0,  0]
  K2( 9,:) = [  0,  0,  0,  0,  0,  0]
  K2(10,:) = [  0,  0,  0,  0,  0,  0]
  K2(11,:) = [  0,  0,  0,  0,  0,  0]
  K2(12,:) = [  0,  0,  0,  0,  0,  0]
  K2(13,:) = [  0,  0,  0,  0,  0,  0]
  K2(14,:) = [  0,  0,  0,  0,  0,  0]
  K2(15,:) = [  0,  0,  0,  0,  0,  0]
  K2(16,:) = [  0,  0,  0,  0,  0,  0]
  K2(17,:) = [  0,  0,  0,  0,  0,  0]
  K2(18,:) = [  0,  0,  0,  0,  0,  0]
  K2(19,:) = [  0,  0,  0,  0,  0,  0]
  K2(20,:) = [  0,  0,  0,  0,  0,  0]
  K2(21,:) = [  0,  0,  0,  0,  0,  0]
  K2(22,:) = [  0,  0,  0,  0,  0,  0]
  K2(23,:) = [  0,  0,  0,  0,  0,  0]
  K2(24,:) = [  0,  0,  0,  0,  0,  0]
  K2(25,:) = [  0,  0,  0,  0,  0,  0]
  K2(26,:) = [  0,  0,  0,  0,  0,  0]
  K2(27,:) = [  0,  0,  0,  0,  0,  0]
  K2(28,:) = [  0,  0,  0,  0,  0,  0]
  K2(29,:) = [  0,  0,  0,  0,  0,  0]
  K2(30,:) = [  0,  0,  0,  0,  0,  0]
  K2(31,:) = [  0,  0,  0,  0,  0,  0]
  K2(32,:) = [  0,  0,  0,  0,  0,  0]
  K2(33,:) = [  0, 16,  0, -2,  0,  6]
  K2(34,:) = [  0, -2,  0, 16,  0,  6]
  K2 = (1._/**/REALKIND / 3) * K2

  KL( 1,:) = [ 16,  0, -2,  0,  6,  0]
  KL( 2,:) = [ -2,  0, 16,  0,  6,  0]
  KL( 3,:) = [  0,  0,  0,  0,  0,  0]
  KL( 4,:) = [  0,  0,  0,  0,  0,  0]
  KL( 5,:) = [  0,  0,  0,  0,  0,  0]
  KL( 6,:) = [  0,  0,  0,  0,  0,  0]
  KL( 7,:) = [  0,  0,  0,  0,  0,  0]
  KL( 8,:) = [  0,  0,  0,  0,  0,  0]
  KL( 9,:) = [  0,  0,  0,  0,  0,  0]
  KL(10,:) = [  0,  0,  0,  0,  0,  0]
  KL(11,:) = [  0,  0,  0,  0,  0,  0]
  KL(12,:) = [  0,  0,  0,  0,  0,  0]
  KL(13,:) = [  0,  0,  0,  0,  0,  0]
  KL(14,:) = [  0,  0,  0,  0,  0,  0]
  KL(15,:) = [  0,  0,  0,  0,  0,  0]
  KL(16,:) = [  0,  0,  0,  0,  0,  0]
  KL(17,:) = [  0,  0,  0,  0,  0,  0]
  KL(18,:) = [  0,  0,  0,  0,  0,  0]
  KL(19,:) = [  0,  0,  0,  0,  0,  0]
  KL(20,:) = [  0,  0,  0,  0,  0,  0]
  KL(21,:) = [  0,  0,  0,  0,  0,  0]
  KL(22,:) = [  0,  0,  0,  0,  0,  0]
  KL(23,:) = [  0,  0,  0,  0,  0,  0]
  KL(24,:) = [  0,  0,  0,  0,  0,  0]
  KL(25,:) = [  0,  0,  0,  0,  0,  0]
  KL(26,:) = [  0,  0,  0,  0,  0,  0]
  KL(27,:) = [  0,  0,  0,  0,  0,  0]
  KL(28,:) = [  0,  0,  0,  0,  0,  0]
  KL(29,:) = [  0,  0,  0,  0,  0,  0]
  KL(30,:) = [  0,  0,  0,  0,  0,  0]
  KL(31,:) = [  0,  0,  0,  0,  0,  0]
  KL(32,:) = [  0,  0,  0,  0,  0,  0]
  KL(33,:) = [ 16,  0, -2,  0,  6,  0]
  KL(34,:) = [ -2,  0, 16,  0,  6,  0]
  KL = (1._/**/REALKIND / 3) * KL

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND



module ol_forced_parameters_ppjjj_ew_bbxagg_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppjjj_ew_bbxagg_2_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppjjj_ew_bbxagg_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 32 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(78)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,57), wf8(8,77), wf32(32,92)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(55), c(48)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppjjj_ew_bbxagg_2_/**/REALKIND






! **********************************************************************
module ol_loop_ppjjj_ew_bbxagg_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppjjj_ew_bbxagg_2_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED*gQCD**2)/3._/**/REALKIND
    f( 2) = (eQED*gQCD**2)/3._/**/REALKIND
    f( 3) = (CI*countertermnorm*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**3*gQCD**2
    f( 5) = (countertermnorm*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 6) = countertermnorm*eQED**3*gQCD**2
    f( 7) = (CI*countertermnorm*ctAAGG*eQED**3*gQCD**2)/3._/**/REALKIND
    f( 8) = CI*countertermnorm*ctAZGG*eQED**3*gQCD**2
    f( 9) = (countertermnorm*ctZGG*eQED**3*gQCD**2)/3._/**/REALKIND
    f(10) = (CI*countertermnorm*eQED*gQCD**4)/3._/**/REALKIND
    f(11) = CI*countertermnorm*eQED*gQCD**4
    f(12) = (countertermnorm*eQED*gQCD**4)/3._/**/REALKIND
    f(13) = (CI*countertermnorm*ctGbb*eQED*gQCD**4)/3._/**/REALKIND
    f(14) = (countertermnorm*ctGbb*eQED*gQCD**4)/3._/**/REALKIND
    f(15) = (CI*countertermnorm*ctVbb*eQED*gQCD**4)/3._/**/REALKIND
    f(16) = (countertermnorm*ctVbb*eQED*gQCD**4)/3._/**/REALKIND
    f(17) = (countertermnorm*ctVVV*eQED*gQCD**4)/3._/**/REALKIND
    f(18) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*MW*sw)
    f(19) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f(20) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(21) = (eQED**3*gQCD**2*integralnorm*SwB)/27._/**/REALKIND
    f(22) = (eQED**3*gQCD**2*integralnorm*SwB)/3._/**/REALKIND
    f(23) = (CI*eQED*gQCD**4*integralnorm*SwB)/6._/**/REALKIND
    f(24) = (CI*eQED*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(25) = (eQED*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(26) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/(6._/**/REALKIND*sw**2)
    f(27) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/(3._/**/REALKIND*sw**2)
    f(28) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(29) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(30) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(31) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(32) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/(6._/**/REALKIND*MW**2*sw**2)
    f(33) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/(3._/**/REALKIND*MW**2*sw**2)
    f(34) = (CI*eQED**3*gQCD**2*integralnorm*SwB)/(2._/**/REALKIND*MW**2*sw**2)
    f(35) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(36) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(37) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(38) = (CI*eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(12._/**/REALKIND*MW**2*sw**2)
    f(39) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(40) = (eQED**3*gQCD**2*integralnorm*SwF)/27._/**/REALKIND
    f(41) = (2*eQED**3*gQCD**2*integralnorm*SwF)/27._/**/REALKIND
    f(42) = (4*eQED**3*gQCD**2*integralnorm*SwF)/27._/**/REALKIND
    f(43) = (8*eQED**3*gQCD**2*integralnorm*SwF)/27._/**/REALKIND
    f(44) = (eQED**3*gQCD**2*integralnorm*SwF)/3._/**/REALKIND
    f(45) = (2*eQED**3*gQCD**2*integralnorm*SwF)/3._/**/REALKIND
    f(46) = (4*eQED**3*gQCD**2*integralnorm*SwF)/3._/**/REALKIND
    f(47) = (CI*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(48) = (2*CI*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(49) = (4*CI*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(50) = (eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(51) = (2*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(52) = (4*eQED*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(53) = (eQED**3*gQCD**2*integralnorm*MB**2*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(54) = (eQED**3*gQCD**2*integralnorm*MB*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(55) = (eQED**3*gQCD**2*integralnorm*MB*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)

  c = [ 6*CI*f(19), 6*CI*f(20), 6*f(21), 6*f(22), 9*CI*f(23), 18*CI*f(23), CI*f(24), 3*CI*f(24), 8*CI*f(24), 9*CI*f(24) &
    , 18*CI*f(24), f(25), 3*f(25), 8*f(25), 9*f(25), 6*CI*f(26), 6*CI*f(27), 6*CI*f(28), 6*f(29), 6*f(30), 6*f(31), 6*CI*f(32) &
    , 6*CI*f(33), 6*CI*f(34), 6*f(35), 6*f(36), 6*f(37), 6*CI*f(38), 6*f(39), 6*f(40), 6*f(41), 6*f(42), 6*f(43), 6*f(44), 6*f(45) &
    , 6*f(46), 3*CI*f(47), 3*CI*f(48), 3*CI*f(49), f(50), 3*f(50), f(51), 3*f(51), f(52), 3*f(52), 6*f(53), 6*f(54), 6*f(55) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MB2)+L(6,5))
  den(2) = 1 /((L(5,10) - MB2)+L(6,10))
  den(4) = 1 /((L(5,18) - MB2)+L(6,18))
  den(6) = 1 /((L(5,24))+L(6,24))
  den(8) = 1 /((L(5,9) - MB2)+L(6,9))
  den(9) = 1 /((L(5,6) - MB2)+L(6,6))
  den(11) = 1 /((L(5,17) - MB2)+L(6,17))
  den(16) = 1 /((L(5,3))+L(6,3))
  den(17) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(18) = 1 /((L(5,24) - MH2)+L(6,24))
  den(20) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(24) = 1 /((L(5,26) - MB2)+L(6,26))
  den(27) = 1 /((L(5,21) - MB2)+L(6,21))
  den(32) = 1 /((L(5,13) - MB2)+L(6,13))
  den(37) = 1 /((L(5,7))+L(6,7))
  den(40) = 1 /((L(5,22) - MB2)+L(6,22))
  den(43) = 1 /((L(5,25) - MB2)+L(6,25))
  den(46) = 1 /((L(5,14) - MB2)+L(6,14))
  den(63) = 1 /((L(5,11))+L(6,11))
  den(65) = 1 /((L(5,19))+L(6,19))
  den(67) = 1 /((L(5,3) - MH2)+L(6,3))
  den(68) = 1 /((L(5,7) - MH2)+L(6,7))
  den(70) = 1 /((L(5,7) - MZ2)+L(6,7))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(10) = den(8)*den(9)
  den(12) = den(9)*den(11)
  den(13) = den(6)*den(9)
  den(14) = den(4)*den(8)
  den(15) = den(2)*den(11)
  den(19) = den(1)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(9)*den(18)
  den(23) = den(9)*den(20)
  den(25) = den(2)*den(24)
  den(26) = den(1)*den(25)
  den(28) = den(1)*den(27)
  den(29) = den(2)*den(28)
  den(30) = den(4)*den(24)
  den(31) = den(1)*den(30)
  den(33) = den(1)*den(32)
  den(34) = den(4)*den(33)
  den(35) = den(6)*den(24)
  den(36) = den(1)*den(35)
  den(38) = den(1)*den(37)
  den(39) = den(6)*den(38)
  den(41) = den(9)*den(40)
  den(42) = den(8)*den(41)
  den(44) = den(8)*den(43)
  den(45) = den(9)*den(44)
  den(47) = den(9)*den(46)
  den(48) = den(11)*den(47)
  den(49) = den(11)*den(43)
  den(50) = den(9)*den(49)
  den(51) = den(6)*den(43)
  den(52) = den(9)*den(51)
  den(53) = den(9)*den(37)
  den(54) = den(6)*den(53)
  den(55) = den(4)*den(40)
  den(56) = den(8)*den(55)
  den(57) = den(8)*den(32)
  den(58) = den(4)*den(57)
  den(59) = den(2)*den(46)
  den(60) = den(11)*den(59)
  den(61) = den(11)*den(27)
  den(62) = den(2)*den(61)
  den(64) = den(16)*den(63)
  den(66) = den(16)*den(65)
  den(69) = den(1)*den(68)
  den(71) = den(1)*den(70)
  den(72) = den(9)*den(68)
  den(73) = den(9)*den(70)
  den(74) = den(8)*den(63)
  den(75) = den(2)*den(63)
  den(76) = den(11)*den(65)
  den(77) = den(4)*den(65)
  den(78) = den(6)*den(16)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppjjj_ew_bbxagg_2_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,92))
  allocate(M1helarray(2,hel_states))
  allocate(M1helarray_ct(6,hel_states))
  allocate(M0_col1_helarray(6,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(6,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppjjj_ew_bbxagg_2_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom gamma glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppjjj_ew_bbxagg_2, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppjjj_ew_bbxagg_2, only: &
    & external_perm_ppjjj_ew_bbxagg_2, &
    & external_perm_inv_ppjjj_ew_bbxagg_2, &
    & extcomb_perm_ppjjj_ew_bbxagg_2, &
    & average_factor_ppjjj_ew_bbxagg_2
  use ol_external_ppjjj_ew_bbxagg_2, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppjjj_ew_bbxagg_2_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppjjj_ew_bbxagg_2
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(2), M2(6)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(92)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,92))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppjjj_ew_bbxagg_2, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,1), 5, MB, 1_intkind1, wf4(:,3), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 10, MB, 1_intkind1, wf4(:,4), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf4(:,3), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,5), n3(:,4), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,5), 18, MB, 1_intkind1, wf4(:,6), n2(3))
  call vert_VQ_A(ntry, ex4(:), wf4(:,3), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,7), n3(:,6), t3x4(:,:,4))
  call vert_QA_V(ntry, wf4(:,3), ex2(:), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,8), n3(:,8), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,9), n3(:,9), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,8), 9, MB, 1_intkind1, wf4(:,10), n2(4))
  call prop_A_Q(ntry, wf4(:,9), 6, MB, 1_intkind1, wf4(:,11), n2(5))
  call vert_VQ_A(ntry, ex5(:), wf4(:,10), wf8(:,4), n3(:,10), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,12), n3(:,11), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,12), 17, MB, 1_intkind1, wf4(:,13), n2(6))
  call vert_VQ_A(ntry, ex4(:), wf4(:,13), wf8(:,5), n3(:,12), t3x8(:,:,5))
  call vert_QA_V(ntry, ex1(:), wf4(:,11), wf8(:,6), n3(:,13), t3x8(:,:,6))
  call vert_VQ_A(ntry, ex3(:), wf4(:,10), wf8(:,7), n3(:,14), t3x8(:,:,7))
  call vert_VQ_A(ntry, ex3(:), wf4(:,13), wf8(:,8), n3(:,15), t3x8(:,:,8))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,14), n3(:,16), t3x4(:,:,8))
  call counter_VVG_G(ntry, ex4(:), ex5(:), ex3(:), wf8(:,9), n4(:,1), t4x8(:,:,1))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,15), n3(:,17), t3x4(:,:,9))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex4(:), ex5(:), wf8(:,10), n4(:,2), t4x8(:,:,2))
  call counter_VGG_G(ctAGGG,ntry, ex3(:), ex5(:), ex4(:), wf8(:,11), n4(:,3), t4x8(:,:,3))
  call counter_VQ_A(ntry, ex5(:), wf4(:,3), wf8(:,12), n3(:,18), t3x8(:,:,9))
  call counter_VQ_A_LR(EWctGbb,ntry, ex5(:), wf4(:,3), wf8(:,13), n3(:,19), t3x8(:,:,10))
  call counter_VQ_A(ntry, ex4(:), wf4(:,3), wf8(:,14), n3(:,20), t3x8(:,:,11))
  call counter_VQ_A_LR(EWctGbb,ntry, ex4(:), wf4(:,3), wf8(:,15), n3(:,21), t3x8(:,:,12))
  call counter_GG_S(ntry, ex4(:), ex5(:), wf4(:,16), n3(:,22), t3x4(:,:,10))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,3), wf8(:,16), n3(:,23), t3x8(:,:,13))
  call counter_GG_V(ntry, ex4(:), 8, ex5(:), 16, wf4(:,17), n3(:,24), t3x4(:,:,11))
  call vert_QA_Z(gZd,ntry, wf4(:,3), ex2(:), wf8(:,17), n3(:,25), t3x8(:,:,14))
  call counter_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,18), n3(:,26), t3x4(:,:,12))
  call counter_VQ_A(ntry, ex5(:), wf4(:,10), wf8(:,18), n3(:,27), t3x8(:,:,15))
  call counter_VQ_A_LR(EWctGbb,ntry, ex5(:), wf4(:,10), wf8(:,19), n3(:,28), t3x8(:,:,16))
  call counter_VQ_A(ntry, ex4(:), wf4(:,13), wf8(:,20), n3(:,29), t3x8(:,:,17))
  call counter_VQ_A_LR(EWctGbb,ntry, ex4(:), wf4(:,13), wf8(:,21), n3(:,30), t3x8(:,:,18))
  call vert_AQ_S(gH,ntry, wf4(:,11), ex1(:), wf8(:,22), n3(:,31), t3x8(:,:,19))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,11), wf8(:,23), n3(:,32), t3x8(:,:,20))
  call counter_VQ_A(ntry, ex3(:), wf4(:,10), wf8(:,24), n3(:,33), t3x8(:,:,21))
  call counter_VQ_A_LR(EWctAbb,ntry, ex3(:), wf4(:,10), wf8(:,25), n3(:,34), t3x8(:,:,22))
  call counter_VQ_A(ntry, ex3(:), wf4(:,13), wf8(:,26), n3(:,35), t3x8(:,:,23))
  call counter_VQ_A_LR(EWctAbb,ntry, ex3(:), wf4(:,13), wf8(:,27), n3(:,36), t3x8(:,:,24))
  call counter_QA_V(ntry, wf4(:,3), ex2(:), wf8(:,28), n3(:,37), t3x8(:,:,25))
  call counter_QA_V_LR(EWctGbb,ntry, wf4(:,3), ex2(:), wf8(:,29), n3(:,38), t3x8(:,:,26))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,19), n3(:,39), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,19), 18, MB, 1_intkind1, wf4(:,20), n2(7))
  call counter_AV_Q_LR(EWctGbb,ntry, ex2(:), ex5(:), wf4(:,21), n3(:,40), t3x4(:,:,14))
  call prop_A_Q(ntry, wf4(:,21), 18, MB, 1_intkind1, wf4(:,22), n2(8))
  call counter_AV_Q(ntry, ex2(:), ex4(:), wf4(:,23), n3(:,41), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,23), 10, MB, 1_intkind1, wf4(:,24), n2(9))
  call counter_AV_Q_LR(EWctGbb,ntry, ex2(:), ex4(:), wf4(:,25), n3(:,42), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,25), 10, MB, 1_intkind1, wf4(:,26), n2(10))
  call counter_AV_Q(ntry, ex2(:), ex3(:), wf4(:,27), n3(:,43), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,27), 6, MB, 1_intkind1, wf4(:,28), n2(11))
  call counter_AV_Q_LR(EWctAbb,ntry, ex2(:), ex3(:), wf4(:,29), n3(:,44), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,29), 6, MB, 1_intkind1, wf4(:,30), n2(12))
  call vert_QA_V(ntry, ex1(:), wf4(:,28), wf8(:,30), n3(:,45), t3x8(:,:,27))
  call vert_QA_V(ntry, ex1(:), wf4(:,30), wf8(:,31), n3(:,46), t3x8(:,:,28))
  call counter_QA_V(ntry, ex1(:), wf4(:,11), wf8(:,32), n3(:,47), t3x8(:,:,29))
  call counter_QA_V_LR(EWctGbb,ntry, ex1(:), wf4(:,11), wf8(:,33), n3(:,48), t3x8(:,:,30))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,31), n3(:,49), t3x4(:,:,19))
  call prop_Q_A(ntry, wf4(:,31), 17, MB, 1_intkind1, wf4(:,32), n2(13))
  call vert_VQ_A(ntry, ex4(:), wf4(:,32), wf8(:,34), n3(:,50), t3x8(:,:,31))
  call counter_VQ_A_LR(EWctGbb,ntry, ex5(:), ex1(:), wf4(:,33), n3(:,51), t3x4(:,:,20))
  call prop_Q_A(ntry, wf4(:,33), 17, MB, 1_intkind1, wf4(:,34), n2(14))
  call vert_VQ_A(ntry, ex4(:), wf4(:,34), wf8(:,35), n3(:,52), t3x8(:,:,32))
  call counter_VQ_A(ntry, ex4(:), ex1(:), wf4(:,35), n3(:,53), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,35), 9, MB, 1_intkind1, wf4(:,36), n2(15))
  call vert_VQ_A(ntry, ex5(:), wf4(:,36), wf8(:,36), n3(:,54), t3x8(:,:,33))
  call counter_VQ_A_LR(EWctGbb,ntry, ex4(:), ex1(:), wf4(:,37), n3(:,55), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,37), 9, MB, 1_intkind1, wf4(:,38), n2(16))
  call vert_VQ_A(ntry, ex5(:), wf4(:,38), wf8(:,37), n3(:,56), t3x8(:,:,34))
  call vert_VQ_A(ntry, ex3(:), wf4(:,32), wf8(:,38), n3(:,57), t3x8(:,:,35))
  call vert_VQ_A(ntry, ex3(:), wf4(:,34), wf8(:,39), n3(:,58), t3x8(:,:,36))
  call vert_VQ_A(ntry, ex3(:), wf4(:,36), wf8(:,40), n3(:,59), t3x8(:,:,37))
  call vert_VQ_A(ntry, ex3(:), wf4(:,38), wf8(:,41), n3(:,60), t3x8(:,:,38))
  call counter_VQ_A(ntry, ex3(:), ex1(:), wf4(:,39), n3(:,61), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,39), 5, MB, 1_intkind1, wf4(:,40), n2(17))
  call vert_VQ_A(ntry, ex5(:), wf4(:,40), wf8(:,42), n3(:,62), t3x8(:,:,39))
  call counter_VQ_A_LR(EWctAbb,ntry, ex3(:), ex1(:), wf4(:,41), n3(:,63), t3x4(:,:,24))
  call prop_Q_A(ntry, wf4(:,41), 5, MB, 1_intkind1, wf4(:,42), n2(18))
  call vert_VQ_A(ntry, ex5(:), wf4(:,42), wf8(:,43), n3(:,64), t3x8(:,:,40))
  call vert_VQ_A(ntry, ex4(:), wf4(:,40), wf8(:,44), n3(:,65), t3x8(:,:,41))
  call vert_VQ_A(ntry, ex4(:), wf4(:,42), wf8(:,45), n3(:,66), t3x8(:,:,42))
  call vert_QA_V(ntry, wf4(:,40), ex2(:), wf8(:,46), n3(:,67), t3x8(:,:,43))
  call vert_QA_V(ntry, wf4(:,42), ex2(:), wf8(:,47), n3(:,68), t3x8(:,:,44))
  call vert_AV_Q(ntry, wf4(:,4), ex5(:), wf8(:,48), n3(:,69), t3x8(:,:,45))
  call counter_Q_A(ctbb,5,ntry, wf4(:,3), 5, wf4(:,43), n2(19))
  call prop_A_Q(ntry, wf8(:,48), 26, MB, 1_intkind1, wf8(:,49), n2(20))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,3), 5, wf4(:,44), n2(21))
  call counter_A_Q(ctbb,5,ntry, wf4(:,4), 10, wf4(:,45), n2(22))
  call prop_Q_A(ntry, wf8(:,1), 21, MB, 1_intkind1, wf8(:,50), n2(23))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,4), 10, wf4(:,46), n2(24))
  call vert_AV_Q(ntry, wf4(:,6), ex4(:), wf8(:,51), n3(:,70), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,51), 26, MB, 1_intkind1, wf8(:,52), n2(25))
  call counter_A_Q(ctbb,5,ntry, wf4(:,6), 18, wf4(:,47), n2(26))
  call prop_Q_A(ntry, wf8(:,2), 13, MB, 1_intkind1, wf8(:,53), n2(27))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,6), 18, wf4(:,48), n2(28))
  call vert_AV_Q(ntry, ex2(:), wf4(:,7), wf8(:,54), n3(:,71), t3x8(:,:,47))
  call prop_A_Q(ntry, wf8(:,54), 26, MB, 1_intkind1, wf8(:,55), n2(29))
  call counter_V_V(ctGG,21,ntry, wf4(:,7), 24, wf4(:,49), n2(30))
  call vert_AV_Q(ntry, wf4(:,11), ex5(:), wf8(:,56), n3(:,72), t3x8(:,:,48))
  call counter_Q_A(ctbb,5,ntry, wf4(:,10), 9, wf4(:,50), n2(31))
  call prop_A_Q(ntry, wf8(:,56), 22, MB, 1_intkind1, wf8(:,57), n2(32))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,10), 9, wf4(:,51), n2(33))
  call counter_A_Q(ctbb,5,ntry, wf4(:,11), 6, wf4(:,52), n2(34))
  call prop_Q_A(ntry, wf8(:,4), 25, MB, 1_intkind1, wf8(:,58), n2(35))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,11), 6, wf4(:,53), n2(36))
  call vert_AV_Q(ntry, wf4(:,11), ex4(:), wf8(:,59), n3(:,73), t3x8(:,:,49))
  call counter_Q_A(ctbb,5,ntry, wf4(:,13), 17, wf4(:,54), n2(37))
  call prop_A_Q(ntry, wf8(:,59), 14, MB, 1_intkind1, wf8(:,60), n2(38))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,13), 17, wf4(:,55), n2(39))
  call prop_Q_A(ntry, wf8(:,5), 25, MB, 1_intkind1, wf8(:,61), n2(40))
  call vert_VQ_A(ntry, wf4(:,7), ex1(:), wf8(:,62), n3(:,74), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,62), 25, MB, 1_intkind1, wf8(:,63), n2(41))
  call vert_AV_Q(ntry, wf4(:,6), ex3(:), wf8(:,64), n3(:,75), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,64), 22, MB, 1_intkind1, wf8(:,65), n2(42))
  call prop_Q_A(ntry, wf8(:,7), 13, MB, 1_intkind1, wf8(:,66), n2(43))
  call vert_AV_Q(ntry, wf4(:,4), ex3(:), wf8(:,67), n3(:,76), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,67), 14, MB, 1_intkind1, wf8(:,68), n2(44))
  call prop_Q_A(ntry, wf8(:,8), 21, MB, 1_intkind1, wf8(:,69), n2(45))
  call vert_UV_W(ntry, wf4(:,14), 3, ex4(:), 8, wf8(:,70), n3(:,77), t3x8(:,:,53))
  call vert_UV_W(ntry, wf4(:,14), 3, ex5(:), 16, wf8(:,71), n3(:,78), t3x8(:,:,54))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,56), n3(:,79), t3x4(:,:,25))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,57), n3(:,80), t3x4(:,:,26))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,3), wf8(:,72), n3(:,81), t3x8(:,:,55))
  call vert_AQ_S(gX,ntry, wf4(:,11), ex1(:), wf8(:,73), n3(:,82), t3x8(:,:,56))
  call vert_QA_V(ntry, wf4(:,10), ex2(:), wf8(:,74), n3(:,83), t3x8(:,:,57))
  call vert_QA_V(ntry, ex1(:), wf4(:,4), wf8(:,75), n3(:,84), t3x8(:,:,58))
  call vert_QA_V(ntry, wf4(:,13), ex2(:), wf8(:,76), n3(:,85), t3x8(:,:,59))
  call vert_QA_V(ntry, ex1(:), wf4(:,6), wf8(:,77), n3(:,86), t3x8(:,:,60))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,4), wf8(:,1), A(:,1), n3(:,87), t3x32(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,2), A(:,2), n3(:,88), t3x32(:,:,2), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,3), A(:,3), n3(:,89), t3x32(:,:,3), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,4), A(:,4), n3(:,90), t3x32(:,:,4), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,5), A(:,5), n3(:,91), t3x32(:,:,5), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,6), A(:,6), n3(:,92), t3x32(:,:,6), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,7), A(:,7), n3(:,93), t3x32(:,:,7), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,8), A(:,8), n3(:,94), t3x32(:,:,8), nhel, den(15))

    call Hcont_VV(nsync, wf4(:,14), wf8(:,9), A(:,9), n3(:,95), t3x32(:,:,9), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,15), A(:,10), n3(:,96), t3x32(:,:,10), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,10), A(:,11), n3(:,97), t3x32(:,:,11), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,14), wf8(:,11), A(:,12), n3(:,98), t3x32(:,:,12), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,12), A(:,13), n3(:,99), t3x32(:,:,13), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,13), A(:,14), n3(:,100), t3x32(:,:,14), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,14), A(:,15), n3(:,101), t3x32(:,:,15), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,15), A(:,16), n3(:,102), t3x32(:,:,16), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,16), wf8(:,16), A(:,17), n3(:,103), t3x32(:,:,17), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,17), A(:,18), n3(:,104), t3x32(:,:,18), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,18), A(:,19), n3(:,105), t3x32(:,:,19), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,18), A(:,20), n3(:,106), t3x32(:,:,20), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,19), A(:,21), n3(:,107), t3x32(:,:,21), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,20), A(:,22), n3(:,108), t3x32(:,:,22), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,21), A(:,23), n3(:,109), t3x32(:,:,23), nhel, den(12))
    call Hcont_SS(nsync, wf4(:,16), wf8(:,22), A(:,24), n3(:,110), t3x32(:,:,24), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,23), A(:,25), n3(:,111), t3x32(:,:,25), nhel, den(23))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,18), A(:,26), n3(:,112), t3x32(:,:,26), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,24), A(:,27), n3(:,113), t3x32(:,:,27), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,25), A(:,28), n3(:,114), t3x32(:,:,28), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,26), A(:,29), n3(:,115), t3x32(:,:,29), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,27), A(:,30), n3(:,116), t3x32(:,:,30), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,28), A(:,31), n3(:,117), t3x32(:,:,31), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,29), A(:,32), n3(:,118), t3x32(:,:,32), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,20), A(:,33), n3(:,119), t3x32(:,:,33), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,22), A(:,34), n3(:,120), t3x32(:,:,34), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,24), A(:,35), n3(:,121), t3x32(:,:,35), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,26), A(:,36), n3(:,122), t3x32(:,:,36), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,20), A(:,37), n3(:,123), t3x32(:,:,37), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,22), A(:,38), n3(:,124), t3x32(:,:,38), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,24), A(:,39), n3(:,125), t3x32(:,:,39), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,26), A(:,40), n3(:,126), t3x32(:,:,40), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,28), A(:,41), n3(:,127), t3x32(:,:,41), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,30), A(:,42), n3(:,128), t3x32(:,:,42), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,28), A(:,43), n3(:,129), t3x32(:,:,43), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,30), A(:,44), n3(:,130), t3x32(:,:,44), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,30), A(:,45), n3(:,131), t3x32(:,:,45), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,31), A(:,46), n3(:,132), t3x32(:,:,46), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,32), A(:,47), n3(:,133), t3x32(:,:,47), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,33), A(:,48), n3(:,134), t3x32(:,:,48), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,34), A(:,49), n3(:,135), t3x32(:,:,49), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,35), A(:,50), n3(:,136), t3x32(:,:,50), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,36), A(:,51), n3(:,137), t3x32(:,:,51), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,37), A(:,52), n3(:,138), t3x32(:,:,52), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,38), A(:,53), n3(:,139), t3x32(:,:,53), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,39), A(:,54), n3(:,140), t3x32(:,:,54), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,40), A(:,55), n3(:,141), t3x32(:,:,55), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,41), A(:,56), n3(:,142), t3x32(:,:,56), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,42), A(:,57), n3(:,143), t3x32(:,:,57), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,43), A(:,58), n3(:,144), t3x32(:,:,58), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,44), A(:,59), n3(:,145), t3x32(:,:,59), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,45), A(:,60), n3(:,146), t3x32(:,:,60), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,46), A(:,61), n3(:,147), t3x32(:,:,61), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,7), wf8(:,47), A(:,62), n3(:,148), t3x32(:,:,62), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,49), A(:,63), n3(:,149), t3x32(:,:,63), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,49), wf4(:,44), A(:,64), n3(:,150), t3x32(:,:,64), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,45), wf8(:,50), A(:,65), n3(:,151), t3x32(:,:,65), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,50), wf4(:,46), A(:,66), n3(:,152), t3x32(:,:,66), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,52), A(:,67), n3(:,153), t3x32(:,:,67), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,44), wf8(:,52), A(:,68), n3(:,154), t3x32(:,:,68), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,47), wf8(:,53), A(:,69), n3(:,155), t3x32(:,:,69), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,53), wf4(:,48), A(:,70), n3(:,156), t3x32(:,:,70), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,55), A(:,71), n3(:,157), t3x32(:,:,71), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,44), wf8(:,55), A(:,72), n3(:,158), t3x32(:,:,72), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,49), A(:,73), n3(:,159), t3x32(:,:,73), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,50), wf8(:,57), A(:,74), n3(:,160), t3x32(:,:,74), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,57), wf4(:,51), A(:,75), n3(:,161), t3x32(:,:,75), nhel, den(42))
    call Hcont_QA(nsync, wf4(:,52), wf8(:,58), A(:,76), n3(:,162), t3x32(:,:,76), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,58), wf4(:,53), A(:,77), n3(:,163), t3x32(:,:,77), nhel, den(45))
    call Hcont_QA(nsync, wf4(:,54), wf8(:,60), A(:,78), n3(:,164), t3x32(:,:,78), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,60), wf4(:,55), A(:,79), n3(:,165), t3x32(:,:,79), nhel, den(48))
    call Hcont_QA(nsync, wf4(:,52), wf8(:,61), A(:,80), n3(:,166), t3x32(:,:,80), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,53), wf8(:,61), A(:,81), n3(:,167), t3x32(:,:,81), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,52), wf8(:,63), A(:,82), n3(:,168), t3x32(:,:,82), nhel, den(52))
    call Hcont_QA(nsync, wf4(:,53), wf8(:,63), A(:,83), n3(:,169), t3x32(:,:,83), nhel, den(52))
    call Hcont_VV(nsync, wf8(:,6), wf4(:,49), A(:,84), n3(:,170), t3x32(:,:,84), nhel, den(54))
    call Hcont_QA(nsync, wf4(:,50), wf8(:,65), A(:,85), n3(:,171), t3x32(:,:,85), nhel, den(56))
    call Hcont_QA(nsync, wf4(:,51), wf8(:,65), A(:,86), n3(:,172), t3x32(:,:,86), nhel, den(56))
    call Hcont_QA(nsync, wf4(:,47), wf8(:,66), A(:,87), n3(:,173), t3x32(:,:,87), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,48), wf8(:,66), A(:,88), n3(:,174), t3x32(:,:,88), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,54), wf8(:,68), A(:,89), n3(:,175), t3x32(:,:,89), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,55), wf8(:,68), A(:,90), n3(:,176), t3x32(:,:,90), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,45), wf8(:,69), A(:,91), n3(:,177), t3x32(:,:,91), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,46), wf8(:,69), A(:,92), n3(:,178), t3x32(:,:,92), nhel, den(62))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(6) ! M1helarray(6,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j-A(j,5)%j-A(j,8)%j)*f(1)+CI*(-A(j,3)%j-A(j,6)%j)*f(2)
  M1(2)%j = (-A(j,2)%j-A(j,4)%j-A(j,7)%j)*f(1)+CI*(A(j,3)%j+A(j,6)%j)*f(2)

  M2(1)%j = (A(j,63)%j+A(j,65)%j+A(j,78)%j+A(j,80)%j+A(j,89)%j+A(j,91)%j)*f(10)-(A(j,11)%j*f(11))/2._/**/REALKIND+CI*(A(j,71)%j &
       +A(j,73)%j+A(j,82)%j+A(j,84)%j)*f(12)+(-A(j,13)%j-A(j,22)%j-A(j,35)%j-A(j,39)%j-A(j,49)%j-A(j,53)%j)*f(13)+CI*(-A(j,31)%j &
       -A(j,47)%j)*f(14)+(-A(j,29)%j-A(j,43)%j-A(j,57)%j)*f(15)+CI*(-A(j,45)%j-A(j,61)%j)*f(16)+CI*(-A(j,19)%j-A(j,26)%j)*f(17)
  M2(2)%j = (-A(j,14)%j-A(j,23)%j-A(j,36)%j-A(j,40)%j-A(j,50)%j-A(j,54)%j+A(j,64)%j+A(j,66)%j+A(j,79)%j+A(j,81)%j+A(j,90)%j &
       +A(j,92)%j)*f(3)+(-A(j,30)%j-A(j,44)%j-A(j,58)%j)*f(4)+CI*(-A(j,32)%j-A(j,48)%j+A(j,72)%j+A(j,83)%j)*f(5)+CI*(-A(j,46)%j &
       -A(j,62)%j)*f(6)
  M2(3)%j = (A(j,67)%j+A(j,69)%j+A(j,74)%j+A(j,76)%j+A(j,85)%j+A(j,87)%j)*f(10)-(A(j,12)%j*f(11))/2._/**/REALKIND+CI*(-A(j,71)%j &
       -A(j,73)%j-A(j,82)%j-A(j,84)%j)*f(12)+(-A(j,15)%j-A(j,20)%j-A(j,33)%j-A(j,37)%j-A(j,51)%j-A(j,55)%j)*f(13)+CI*(A(j,31)%j &
       +A(j,47)%j)*f(14)+(-A(j,27)%j-A(j,41)%j-A(j,59)%j)*f(15)+CI*(A(j,45)%j+A(j,61)%j)*f(16)+CI*(A(j,19)%j+A(j,26)%j)*f(17)
  M2(4)%j = (-A(j,16)%j-A(j,21)%j-A(j,34)%j-A(j,38)%j-A(j,52)%j-A(j,56)%j+A(j,68)%j+A(j,70)%j+A(j,75)%j+A(j,77)%j+A(j,86)%j &
       +A(j,88)%j)*f(3)+(-A(j,28)%j-A(j,42)%j-A(j,60)%j)*f(4)+CI*(A(j,32)%j+A(j,48)%j-A(j,72)%j-A(j,83)%j)*f(5)+CI*(A(j,46)%j &
       +A(j,62)%j)*f(6)
  M2(5)%j = ((A(j,11)%j+A(j,12)%j)*f(11))/6._/**/REALKIND
  M2(6)%j = -2*A(j,9)%j*f(7)-2*A(j,10)%j*f(8)+2*(A(j,18)%j+A(j,25)%j)*f(9)+2*(A(j,17)%j+A(j,24)%j)*f(18)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(6)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 6
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppjjj_ew_bbxagg_2_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(6)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 6 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppjjj_ew_bbxagg_2_/**/REALKIND
