
module ol_vamp_1_ppjjj_ew_uuxaag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ew_uuxaag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ew_uuxaag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjjj_ew_uuxaag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppjjj_ew_uuxaag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppjjj_ew_uuxaag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjjj_ew_uuxaag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,2,1,8],[0,0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,2,1,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,8,1,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(28))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(30),n2h16(29))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,1,8,2,4],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(31),n2h16(30))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(33),n2h16(31))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(34),n2h16(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(21)])
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(3),n2h8(3))
  call Hloop_QA_V(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_Z(ntryL,G1H16(6),ex2(:),G1H8(2),ngZu,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_W(ntryL,G1H16(7),ex2(:),G1H8(3),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QV_A(ntryL,G1H16(12),ex3(:),G1H8(4),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(4),n2h8(4))
  call Hloop_QV_A(ntryL,G1H16(10),ex3(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(5),n2h8(5))
  call Hloop_QV_A(ntryL,G1H16(11),ex3(:),G1H8(4),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(6),n2h8(6))
  call Hloop_QA_V(ntryL,G1H16(16),ex2(:),G1H8(4),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_QA_Z(ntryL,G1H16(14),ex2(:),G1H8(5),ngZu,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QA_W(ntryL,G1H16(15),ex2(:),G1H8(6),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(20),ex1(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(8),ngZu,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_W(ntryL,G1H16(19),ex1(:),G1H8(9),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(24),ex1(:),G1H8(10),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(11),ngZu,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_W(ntryL,G1H16(23),ex1(:),G1H8(12),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_W(ntryL,G1H16(25),ex2(:),G1H8(13),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_W(ntryL,G1H16(26),ex2(:),G1H8(14),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_W(ntryL,G1H16(27),ex1(:),G1H8(15),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(16),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(7),n2h8(7))
  call Hloop_AQ_W(ntryL,G1H16(29),ex1(:),G1H8(16),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G1H16(30),ex1(:),G1H8(17),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_W(ntryL,G1H16(31),ex1(:),G1H8(18),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_VQ_A(ntryL,G1H16(32),ex1(:),G1H8(19),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(19),17,0,G2H8(8),n2h8(8))
  call Hloop_AQ_W(ntryL,G1H16(33),ex1(:),G1H8(19),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_W(ntryL,G1H16(34),ex1(:),G1H8(20),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZu,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(4),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngZu,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(5),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(6),n2h4(3))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_Z(ntryL,G2H8(5),ex2(:),G2H4(8),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_W(ntryL,G2H8(6),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(10),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngZu,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(11),n2h4(5))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(12),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(13),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(14),n2h4(8))
  call Hloop_WA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(15),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(16),n2h4(10))
  call Hloop_ZA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),ngZu,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(17),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(18),n2h4(12))
  call Hloop_UV_W(ntryL,G1H8(13),18,ex3(:),4,G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_UV_W(ntryL,G1H8(14),18,ex4(:),8,G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_UW_V(ntryL,G1H8(15),17,ex3(:),4,G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),2,8)
  call Hloop_VV_S(ntryL,G1H8(16),ex3(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_UW_V(ntryL,G1H8(17),17,ex3(:),4,G2H4(22),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_UW_V(ntryL,G1H8(18),17,ex4(:),8,G2H4(23),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(2),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),2,8)
  call Hloop_VV_S(ntryL,G1H8(19),ex4(:),G1H4(2),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_UW_V(ntryL,G1H8(20),17,ex4(:),8,G2H4(24),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QV_A(ntryL,G1H8(1),ex3(:),G1H4(3),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(25),n2h4(13))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(3),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QV_A(ntryL,G1H8(4),ex3(:),G1H4(4),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(4),21,0,G2H4(26),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(5),ex3(:),G1H4(4),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(4),21,0,G2H4(27),n2h4(15))
  call Hloop_QV_A(ntryL,G1H8(6),ex3(:),G1H4(4),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(4),21,0,G2H4(28),n2h4(16))
  call Hloop_QV_A(ntryL,G1H8(7),ex4(:),G1H4(4),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(4),25,0,G2H4(29),n2h4(17))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex2(:),G1H4(4),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QV_A(ntryL,G1H8(10),ex4(:),G1H4(5),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(5),25,0,G2H4(30),n2h4(18))
  call Hloop_QV_A(ntryL,G1H8(11),ex4(:),G1H4(5),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(5),25,0,G2H4(31),n2h4(19))
  call Hloop_QV_A(ntryL,G1H8(12),ex4(:),G1H4(5),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(5),25,0,G2H4(32),n2h4(20))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(3),mass5set(:,1),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(3),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(3),mass5set(:,3),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(4),mass5set(:,1),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(4),mass5set(:,4),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(4),mass5set(:,5),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(5),mass5set(:,1),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(5),mass5set(:,2),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(5),mass5set(:,3),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(6),mass5set(:,1),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),4,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(6),mass5set(:,4),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(6),mass5set(:,5),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),4,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,1),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(7),mass5set(:,4),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(7),mass5set(:,5),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(8),mass5set(:,1),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(8),mass5set(:,4),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(8),mass5set(:,5),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),4,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(9),mass5set(:,6),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(10),mass5set(:,6),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(11),mass5set(:,6),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),8,4)
  call Hloop_SV_V(ntryL,G1H4(1),ex4(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(1),mass5set(:,7),  & 
G1H4(1),G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),4)
  call HG1shiftOLR(G1H4(131),2,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(12),mass5set(:,6),  & 
G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),4)
  call HG1shiftOLR(G1H4(137),4,4)
  call Hloop_SV_V(ntryL,G1H4(2),ex3(:),G1H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(2),mass5set(:,7),  & 
G1H4(2),G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
  call HG1shiftOLR(G1H4(142),2,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(1),mass5set(:,1),  & 
G1H4(147),G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),4)
  call HG1shiftOLR(G1H4(148),2,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(1),mass4set(:,1),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),4)
  call HG1shiftOLR(G1H4(154),2,4)
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(2),mass4set(:,1),  & 
G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(159),10,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(2),mass5set(:,1),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),2,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(1),mass4set(:,1),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),4)
  call HG1shiftOLR(G1H4(170),2,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(3),mass4set(:,1),  & 
G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(175),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(168)])
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(6),-8,0,G2H4(1),n2h4(21))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H4(9),ex2(:),G1H2(3),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(3),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(10),ex2(:),G1H2(3),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(4),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex2(:),G1H2(3),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(5),n2h2(4))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-8,0,G2H4(2),n2h4(22))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(6),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex2(:),G1H2(3),ngZu,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(7),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex2(:),G1H2(3),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(8),n2h2(6))
  call Hloop_WA_Q(ntryL,G1H4(17),ex2(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(9),n2h2(7))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(18),-8,0,G2H4(3),n2h4(23))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(10),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_WA_Q(ntryL,G1H4(21),ex2(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(11),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(22),ex2(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(12),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(23),ex3(:),G1H2(3),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(13),n2h2(10))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(24),-8,0,G2H4(4),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(14),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QV_A(ntryL,G1H4(27),ex3(:),G1H2(3),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(15),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(28),ex3(:),G1H2(3),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(16),n2h2(12))
  call Hloop_QV_A(ntryL,G1H4(29),ex3(:),G1H2(3),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(17),n2h2(13))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-8,0,G2H4(5),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(18),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(3),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(19),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(34),ex3(:),G1H2(3),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(20),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(35),ex3(:),G1H2(3),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(21),n2h2(16))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(36),-8,0,G2H4(6),n2h4(26))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(22),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(3),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(23),n2h2(17))
  call Hloop_QV_A(ntryL,G1H4(40),ex3(:),G1H2(3),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(24),n2h2(18))
  call Hloop_VQ_A(ntryL,G1H4(41),ex1(:),G1H2(3),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(25),n2h2(19))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(42),-8,0,G2H4(7),n2h4(27))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(26),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_VQ_A(ntryL,G1H4(45),ex1(:),G1H2(3),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(27),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(46),ex1(:),G1H2(3),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(28),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex1(:),G1H2(3),ngZu,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(29),n2h2(22))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(48),-8,0,G2H4(8),n2h4(28))
  call Hloop_AV_Q(ntryL,G2H4(8),ex4(:),G2H2(30),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_ZQ_A(ntryL,G1H4(51),ex1(:),G1H2(3),ngZu,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(31),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(52),ex1(:),G1H2(3),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(32),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(53),ex1(:),G1H2(3),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(33),n2h2(25))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(54),-8,0,G2H4(9),n2h4(29))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(34),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_WQ_A(ntryL,G1H4(57),ex1(:),G1H2(3),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(35),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(58),ex1(:),G1H2(3),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(36),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(59),ex4(:),G1H2(3),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(37),n2h2(28))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(60),-4,0,G2H4(10),n2h4(30))
  call Hloop_AV_Q(ntryL,G2H4(10),ex3(:),G2H2(38),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QV_A(ntryL,G1H4(63),ex4(:),G1H2(3),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(39),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(64),ex4(:),G1H2(3),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(40),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(65),ex4(:),G1H2(3),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(41),n2h2(31))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(66),-4,0,G2H4(11),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(11),ex3(:),G2H2(42),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(69),ex4(:),G1H2(3),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(43),n2h2(32))
  call Hloop_QV_A(ntryL,G1H4(70),ex4(:),G1H2(3),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(44),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(71),ex4(:),G1H2(3),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(45),n2h2(34))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(72),-4,0,G2H4(12),n2h4(32))
  call Hloop_AV_Q(ntryL,G2H4(12),ex3(:),G2H2(46),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_QV_A(ntryL,G1H4(75),ex4(:),G1H2(3),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(47),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(76),ex4(:),G1H2(3),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(48),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H4(77),ex3(:),G1H2(3),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(49),n2h2(37))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(78),-8,0,G2H4(13),n2h4(33))
  call Hloop_QV_A(ntryL,G2H4(13),ex4(:),G2H2(50),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AV_Q(ntryL,G1H4(81),ex3(:),G1H2(3),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(51),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H4(82),ex3(:),G1H2(3),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(52),n2h2(39))
  call Hloop_AV_Q(ntryL,G1H4(83),ex3(:),G1H2(3),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(53),n2h2(40))
call HGT_OLR(G1H4(84),1,1,4)
call HGT_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(84),-8,0,G2H4(14),n2h4(34))
  call Hloop_QV_A(ntryL,G2H4(14),ex4(:),G2H2(54),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AV_Q(ntryL,G1H4(87),ex3(:),G1H2(3),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(55),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H4(88),ex3(:),G1H2(3),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(56),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H4(89),ex3(:),G1H2(3),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(57),n2h2(43))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(90),-8,0,G2H4(15),n2h4(35))
  call Hloop_QV_A(ntryL,G2H4(15),ex4(:),G2H2(58),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AV_Q(ntryL,G1H4(93),ex3(:),G1H2(3),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(59),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(94),ex3(:),G1H2(3),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(60),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H4(95),ex4(:),G1H2(3),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(61),n2h2(46))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(96),-4,0,G2H4(16),n2h4(36))
  call Hloop_QV_A(ntryL,G2H4(16),ex3(:),G2H2(62),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AV_Q(ntryL,G1H4(99),ex4(:),G1H2(3),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(63),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H4(100),ex4(:),G1H2(3),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(64),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H4(101),ex4(:),G1H2(3),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(65),n2h2(49))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(102),-4,0,G2H4(17),n2h4(37))
  call Hloop_QV_A(ntryL,G2H4(17),ex3(:),G2H2(66),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AV_Q(ntryL,G1H4(105),ex4(:),G1H2(3),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(67),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(106),ex4(:),G1H2(3),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(68),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H4(107),ex4(:),G1H2(3),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(69),n2h2(52))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(108),-4,0,G2H4(18),n2h4(38))
  call Hloop_QV_A(ntryL,G2H4(18),ex3(:),G2H2(70),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AV_Q(ntryL,G1H4(111),ex4(:),G1H2(3),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(71),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H4(112),ex4(:),G1H2(3),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(72),n2h2(54))
  call Hloop_WQ_A(ntryL,G1H4(113),ex1(:),G1H2(3),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(73),n2h2(55))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-8,0,G2H4(19),n2h4(39))
  call Hloop_AV_Q(ntryL,G2H4(19),ex4(:),G2H2(74),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_WQ_A(ntryL,G1H4(117),ex1(:),G1H2(3),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(75),n2h2(56))
  call Hloop_WQ_A(ntryL,G1H4(118),ex1(:),G1H2(3),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(76),n2h2(57))
  call Hloop_WQ_A(ntryL,G1H4(119),ex1(:),G1H2(3),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(77),n2h2(58))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(120),-4,0,G2H4(20),n2h4(40))
  call Hloop_AV_Q(ntryL,G2H4(20),ex3(:),G2H2(78),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_WQ_A(ntryL,G1H4(123),ex1(:),G1H2(3),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(79),n2h2(59))
  call Hloop_WQ_A(ntryL,G1H4(124),ex1(:),G1H2(3),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(80),n2h2(60))
  call Hloop_WA_Q(ntryL,G1H4(125),ex2(:),G1H2(3),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(81),n2h2(61))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(126),-8,0,G2H4(21),n2h4(41))
  call Hloop_QV_A(ntryL,G2H4(21),ex4(:),G2H2(82),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_WA_Q(ntryL,G1H4(129),ex2(:),G1H2(3),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(83),n2h2(62))
  call Hloop_WA_Q(ntryL,G1H4(130),ex2(:),G1H2(3),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(3),23,0,G2H2(84),n2h2(63))
  call Hloop_UW_V(ntryL,G1H4(1),21,ex4(:),8,G2H2(85),m3h2x2(:,87),heltab2x4(:,:,87))
call HGT_OLR(G1H4(131),1,1,4)
call HGT_invQ_OLR(G1H4(131),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(131),-2,0,G2H4(22),n2h4(42))
  call Hloop_QA_W(ntryL,G2H4(22),ex2(:),G2H2(86),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_UW_V(ntryL,G1H4(134),21,ex4(:),8,G2H2(87),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UW_V(ntryL,G1H4(135),21,ex4(:),8,G2H2(88),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_WA_Q(ntryL,G1H4(136),ex2(:),G1H2(3),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(89),n2h2(64))
call HGT_OLR(G1H4(137),1,1,4)
call HGT_invQ_OLR(G1H4(137),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(137),-4,0,G2H4(23),n2h4(43))
  call Hloop_QV_A(ntryL,G2H4(23),ex3(:),G2H2(90),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_WA_Q(ntryL,G1H4(140),ex2(:),G1H2(3),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(91),n2h2(65))
  call Hloop_WA_Q(ntryL,G1H4(141),ex2(:),G1H2(3),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(3),27,0,G2H2(92),n2h2(66))
  call Hloop_UW_V(ntryL,G1H4(2),25,ex3(:),4,G2H2(93),m3h2x2(:,95),heltab2x4(:,:,95))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(142),-2,0,G2H4(24),n2h4(44))
  call Hloop_QA_W(ntryL,G2H4(24),ex2(:),G2H2(94),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_UW_V(ntryL,G1H4(145),25,ex3(:),4,G2H2(95),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_UW_V(ntryL,G1H4(146),25,ex3(:),4,G2H2(96),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QV_A(ntryL,G1H4(147),ex4(:),G1H2(3),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(3),29,0,G2H2(97),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(148),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(148),ex2(:),G1H2(3),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(4),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(98),n2h2(68))
  call Hloop_QV_A(ntryL,G1H4(158),ex4(:),G1H2(4),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(99),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(154),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(154),ex2(:),G1H2(4),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_QV_A(ntryL,G1H4(157),ex4(:),G1H2(5),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(100),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(159),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(159),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(159),ex2(:),G1H2(5),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_QV_A(ntryL,G1H4(162),ex4(:),G1H2(6),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(101),n2h2(71))
  call Hloop_QV_A(ntryL,G1H4(163),ex3(:),G1H2(6),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(102),n2h2(72))
call HGT_raise_alpha_OLR(G1H4(164),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(164),ex2(:),G1H2(6),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_QV_A(ntryL,G1H4(169),ex3(:),G1H2(7),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(103),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(174),ex3(:),G1H2(7),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(104),n2h2(74))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(170),ex2(:),G1H2(7),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_QV_A(ntryL,G1H4(173),ex3(:),G1H2(8),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(8),29,0,G2H2(105),n2h2(75))
call HGT_raise_alpha_OLR(G1H4(175),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(175),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(175),ex2(:),G1H2(8),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_QV_A(ntryL,G1H4(178),ex3(:),G1H2(9),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(9),29,0,G2H2(106),n2h2(76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(2)])
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(1),mass5set(:,7),  & 
G1H2(9),G1H2(1),G1H2(2),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(2),mass5set(:,7),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),2,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(4),mass4set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(26),10,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(3),mass5set(:,2),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(31),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(4),mass4set(:,2),  & 
G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(37),10,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(3),mass5set(:,3),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(4),mass4set(:,3),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(48),10,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(4),mass5set(:,1),  & 
G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(53),8,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(5),mass4set(:,1),  & 
G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(59),12,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(4),mass5set(:,4),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(5),mass4set(:,4),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(70),12,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(4),mass5set(:,5),  & 
G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),2)
  call HG1shiftOLR(G1H2(75),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(5),mass4set(:,5),  & 
G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(81),12,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(5),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(6),mass4set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(92),9,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(5),mass5set(:,2),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),2)
  call HG1shiftOLR(G1H2(97),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(6),mass4set(:,2),  & 
G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(103),9,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(5),mass5set(:,3),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(108),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(6),mass4set(:,3),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(114),9,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(6),mass5set(:,1),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),2)
  call HG1shiftOLR(G1H2(119),4,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(5),mass4set(:,1),  & 
G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(125),12,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(6),mass5set(:,4),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(130),4,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(5),mass4set(:,4),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(136),12,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(6),mass5set(:,5),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(141),4,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(5),mass4set(:,5),  & 
G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(147),12,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(7),mass5set(:,1),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(7),mass4set(:,1),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),2)
  call HG1shiftOLR(G1H2(158),12,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(7),mass5set(:,4),  & 
G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),2)
  call HG1shiftOLR(G1H2(163),8,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(7),mass4set(:,4),  & 
G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(169),12,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(7),mass5set(:,5),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(174),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(7),mass4set(:,5),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(180),12,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(8),mass5set(:,1),  & 
G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),G1H2(189),2)
  call HG1shiftOLR(G1H2(185),4,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(7),mass4set(:,1),  & 
G1H2(190),G1H2(191),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(191),12,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(8),mass5set(:,4),  & 
G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),G1H2(200),2)
  call HG1shiftOLR(G1H2(196),4,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(7),mass4set(:,4),  & 
G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),2)
  call HG1shiftOLR(G1H2(202),12,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(8),mass5set(:,5),  & 
G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(207),4,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(7),mass4set(:,5),  & 
G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(213),12,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(9),mass5set(:,6),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),8,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(8),mass4set(:,6),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),2)
  call HG1shiftOLR(G1H2(224),9,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(10),mass5set(:,6),  & 
G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(229),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(9),mass4set(:,6),  & 
G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(235),5,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(11),mass5set(:,6),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(240),8,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(2),mass4set(:,6),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),2)
  call HG1shiftOLR(G1H2(246),10,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(2),mass4set(:,6),  & 
G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(251),10,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(12),mass5set(:,6),  & 
G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),G1H2(260),2)
  call HG1shiftOLR(G1H2(256),4,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(3),mass4set(:,6),  & 
G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),2)
  call HG1shiftOLR(G1H2(262),6,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(3),mass4set(:,6),  & 
G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(267),6,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(97),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(104),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(250),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(266),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(80),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(124),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(135),[G1H2(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(146),[G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(157),[G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(168),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(190),[G1H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(212),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(223),[G1H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(234),[G1H2(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(245),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(261),[G1H2(260)])
  call Hloop_WA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(1))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(6),n2h1(2))
  call Hloop_WA_Q(ntryL,G1H2(250),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(9),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(266),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(14),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(16),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(18),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(22),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(26),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(30),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(34),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(38),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(40),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(42),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(44),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(46),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(119),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(48),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(125),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(50),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(129),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(52),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(135),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(54),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(56),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(147),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(58),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(60),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(62),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(64),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(66),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(174),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(179),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(180),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(70),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(185),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(72),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(191),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(74),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(195),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(196),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(201),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(202),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(78),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(207),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(80),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(213),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(82),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(84),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(223),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(86),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(228),ex3(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(229),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(88),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(234),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(235),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(90),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(239),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(240),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(92),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(246),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(94),n2h1(90))
  call Hloop_WA_Q(ntryL,G1H2(251),ex2(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(95),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(255),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(96),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(256),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(97),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(261),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(262),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(99),n2h1(95))
  call Hloop_WA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(100),n2h1(96))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,7),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(2),mass5set(:,7),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(3),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(3),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(4),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(4),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(5),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(5),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(6),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(6),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(6),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(7),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(7),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(7),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(8),mass5set(:,1),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(8),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(8),mass5set(:,5),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(9),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(10),mass5set(:,6),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(11),mass5set(:,6),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(96),RedSet_5(12),mass5set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,12,2],[0,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(33))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(34))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(35))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(13),n2h16(36))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(17),n2h16(37))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(21),n2h16(38))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(39))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(40))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(41))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(8),n2h16(42))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(43))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(44))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(45))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(10),n2h16(46))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(47))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(48))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(49))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(15),n2h16(50))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(20),n2h16(51))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(52))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(19),n2h16(53))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(24),n2h16(54))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(55))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(23),n2h16(56))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(57))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,2,8,5],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,60),heltab2x32(:,:,60))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,2,8,5],[0,nMW,nMW,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(58))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,5,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(28),n2h16(59))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,5,2,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(60))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,5,2,8],[0,nMW,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(30),n2h16(61))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,5,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(31),n2h16(62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,2,5,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(32),n2h16(63))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,2,5,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(33),n2h16(64))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,2,5,8],[0,nMW,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(34),n2h16(65))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,5,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(35),n2h16(66))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,1,8,6],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,1,8,6],[0,nMW,nMW,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(37),n2h16(67))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,6,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(38),n2h16(68))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,6,1,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(39),n2h16(69))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,6,1,8],[0,nMW,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(40),n2h16(70))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,6,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(41),n2h16(71))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,1,6,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(42),n2h16(72))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,1,6,8],[0,nMZ,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(43),n2h16(73))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,1,6,8],[0,nMW,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(44),n2h16(74))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,1,6,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(45),n2h16(75))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,4,9],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,2,4,9],[0,nMW,nMW,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(47),n2h16(76))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,4,2,9],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(48),n2h16(77))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,4,2,9],[0,0,nMZ,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(49),n2h16(78))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,4,2,9],[0,0,nMW,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(50),n2h16(79))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,4,2,9],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(51),n2h16(80))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,2,9,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(52),n2h16(81))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,2,9,4],[0,nMZ,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(53),n2h16(82))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,2,9,4],[0,nMW,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(54),n2h16(83))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,2,9,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(55),n2h16(84))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,4,10],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,1,4,10],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(57),n2h16(85))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,4,1,10],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(58),n2h16(86))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,4,1,10],[0,0,nMZ,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(59),n2h16(87))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,4,1,10],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(60),n2h16(88))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,4,1,10],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(61),n2h16(89))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,1,10,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(62),n2h16(90))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,10,4],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(63),n2h16(91))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,10,4],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(64),n2h16(92))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,10,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(65),n2h16(93))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[17,4,2,8],[0,0,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(13),n2h8(11))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[17,4,2,8],[nMW,nMW,0,0],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,101))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[17,2,4,8],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(2),m3h4x8(:,3),heltab2x32(:,:,102))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(3),ngZu,m3h4x8(:,4),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[17,2,4,8],[nMW,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,5),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[17,2,4,8],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(5),m3h4x8(:,6),heltab2x32(:,:,105))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,7),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(6),17,0,G1H8(14),n2h8(12))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,8),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G0H8(6),17,0,G1H8(15),n2h8(13))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[17,2,8,4],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,9),heltab2x32(:,:,108))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngZu,m3h4x8(:,10),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[17,2,8,4],[nMW,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,11),heltab2x32(:,:,110))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[17,2,8,4],[0,0,0,0],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,12),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(10),m3h4x8(:,13),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G0H8(10),17,0,G1H8(16),n2h8(14))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(10),m3h4x8(:,14),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H8(10),17,0,G1H8(17),n2h8(15))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[18,4,1,8],[0,0,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,15),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H8(10),18,0,G1H8(18),n2h8(16))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[18,4,1,8],[nMW,nMW,0,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,16),heltab2x32(:,:,115))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[18,1,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,17),heltab2x32(:,:,116))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngZu,m3h4x8(:,18),heltab2x32(:,:,117))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[18,1,4,8],[nMW,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,19),heltab2x32(:,:,118))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[18,1,4,8],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(14),m3h4x8(:,20),heltab2x32(:,:,119))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,21),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(19),n2h8(17))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,22),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(20),n2h8(18))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[18,1,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(15),m3h4x8(:,23),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(16),ngZu,m3h4x8(:,24),heltab2x32(:,:,123))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[18,1,8,4],[nMW,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(17),m3h4x8(:,25),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[18,1,8,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(18),m3h4x8(:,26),heltab2x32(:,:,125))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(19),m3h4x8(:,27),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H8(19),18,0,G1H8(1),n2h8(19))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(19),m3h4x8(:,28),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(19),18,0,G1H8(2),n2h8(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(21),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(45),[G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(55),[G1H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(15)])
  call Hloop_QV_A(ntryL,G1H8(3),ex3(:),G1H4(151),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(151),21,0,G2H4(25),n2h4(51))
  call Hloop_QV_A(ntryL,G1H8(9),ex4(:),G1H4(152),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(152),25,0,G2H4(27),n2h4(52))
  call Hloop_AQ_W(ntryL,G1H16(1),ex1(:),G1H8(4),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,13),G1H4(167),m3h4x4(:,1),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(167),19,0,G2H4(28),n2h4(53))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,13),G1H4(168),m3h4x4(:,2),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(168),19,nMT,G2H4(29),n2h4(54))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,13),G1H4(5),m3h4x4(:,3),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(31),n2h4(55))
  call Hloop_AV_Q(ntryL,G1H16(17),wf4(:,13),G1H4(6),m3h4x4(:,4),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(6),19,nMT,G2H4(32),n2h4(56))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,13),G1H4(9),m3h4x4(:,5),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMB,G2H4(1),n2h4(57))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,13),G1H4(10),m3h4x4(:,6),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(10),19,nMB,G2H4(2),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,13),G1H4(11),m3h4x4(:,7),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(11),19,0,G2H4(3),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,13),G1H4(12),m3h4x4(:,8),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(12),19,nMT,G2H4(4),n2h4(60))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,13),G1H4(15),m3h4x4(:,9),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(15),19,0,G2H4(5),n2h4(61))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,13),G1H4(16),m3h4x4(:,10),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMT,G2H4(6),n2h4(62))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,13),G1H4(17),m3h4x4(:,11),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(17),19,nMB,G2H4(7),n2h4(63))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,13),G1H4(18),m3h4x4(:,12),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(18),19,nMB,G2H4(8),n2h4(64))
  call Hloop_QV_A(ntryL,G1H16(24),ex3(:),G1H8(5),m3h2x8(:,30),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(5),20,0,G2H8(1),n2h8(21))
  call Hloop_QV_A(ntryL,G1H16(20),ex3(:),G1H8(6),m3h2x8(:,31),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMT,G2H8(2),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H16(23),ex3(:),G1H8(7),m3h2x8(:,32),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(7),20,0,G2H8(3),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(19),ex3(:),G1H8(8),m3h2x8(:,33),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(8),20,nMT,G2H8(4),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(22),ex3(:),G1H8(10),m3h2x8(:,34),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(10),20,nMB,G2H8(5),n2h8(25))
  call Hloop_AV_Q(ntryL,G1H16(25),ex3(:),G1H8(11),m3h2x8(:,35),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(11),20,nMB,G2H8(6),n2h8(26))
  call Hloop_VA_Q(ntryL,G1H16(26),ex2(:),G1H8(12),m3h2x8(:,36),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(7),n2h8(27))
  call Hloop_QA_W(ntryL,G1H16(27),ex2(:),G1H8(3),m3h2x8(:,37),heltab2x16(:,:,49))
  call Hloop_AQ_V(ntryL,G1H16(31),wf4(:,3),G1H4(21),m3h4x4(:,13),heltab2x16(:,:,50))
  call Hloop_AQ_Z(ntryL,G1H16(29),wf4(:,3),G1H4(22),ngZu,m3h4x4(:,14),heltab2x16(:,:,51))
  call Hloop_AQ_W(ntryL,G1H16(30),wf4(:,3),G1H4(23),m3h4x4(:,15),heltab2x16(:,:,52))
  call Hloop_QA_V(ntryL,G1H16(35),ex2(:),G1H8(9),m3h2x8(:,38),heltab2x16(:,:,53))
  call Hloop_QA_Z(ntryL,G1H16(33),ex2(:),G1H8(5),ngZu,m3h2x8(:,39),heltab2x16(:,:,54))
  call Hloop_QA_W(ntryL,G1H16(34),ex2(:),G1H8(6),m3h2x8(:,40),heltab2x16(:,:,55))
  call Hloop_VQ_A(ntryL,G1H16(36),ex1(:),G1H8(7),m3h2x8(:,41),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(7),17,0,G2H8(8),n2h8(28))
  call Hloop_AQ_W(ntryL,G1H16(37),ex1(:),G1H8(8),m3h2x8(:,42),heltab2x16(:,:,57))
  call Hloop_QA_V(ntryL,G1H16(41),wf4(:,10),G1H4(24),m3h4x4(:,16),heltab2x16(:,:,58))
  call Hloop_QA_Z(ntryL,G1H16(39),wf4(:,10),G1H4(27),ngZu,m3h4x4(:,17),heltab2x16(:,:,59))
  call Hloop_QA_W(ntryL,G1H16(40),wf4(:,10),G1H4(28),m3h4x4(:,18),heltab2x16(:,:,60))
  call Hloop_AQ_V(ntryL,G1H16(45),ex1(:),G1H8(10),m3h2x8(:,43),heltab2x16(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H16(43),ex1(:),G1H8(11),ngZu,m3h2x8(:,44),heltab2x16(:,:,62))
  call Hloop_AQ_W(ntryL,G1H16(44),ex1(:),G1H8(12),m3h2x8(:,45),heltab2x16(:,:,63))
  call Hloop_VA_Q(ntryL,G1H16(46),ex2(:),G1H8(7),m3h2x8(:,46),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(7),18,0,G2H8(9),n2h8(29))
  call Hloop_QA_W(ntryL,G1H16(47),ex2(:),G1H8(7),m3h2x8(:,47),heltab2x16(:,:,65))
  call Hloop_QV_A(ntryL,G1H16(51),ex3(:),G1H8(21),m3h2x8(:,48),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(10),n2h8(30))
  call Hloop_QV_A(ntryL,G1H16(49),ex3(:),G1H8(21),m3h2x8(:,49),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(11),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(50),ex3(:),G1H8(21),m3h2x8(:,50),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(12),n2h8(32))
  call Hloop_QA_V(ntryL,G1H16(55),ex2(:),G1H8(21),m3h2x8(:,51),heltab2x16(:,:,69))
  call Hloop_QA_Z(ntryL,G1H16(53),ex2(:),G1H8(22),ngZu,m3h2x8(:,52),heltab2x16(:,:,70))
  call Hloop_QA_W(ntryL,G1H16(54),ex2(:),G1H8(23),m3h2x8(:,53),heltab2x16(:,:,71))
  call Hloop_VQ_A(ntryL,G1H16(56),ex1(:),G1H8(24),m3h2x8(:,54),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(24),17,0,G2H8(13),n2h8(33))
  call Hloop_AQ_W(ntryL,G1H16(57),ex1(:),G1H8(24),m3h2x8(:,55),heltab2x16(:,:,73))
  call Hloop_AV_Q(ntryL,G1H16(61),ex3(:),G1H8(25),m3h2x8(:,56),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(25),20,0,G2H8(14),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(59),ex3(:),G1H8(25),m3h2x8(:,57),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(25),20,0,G2H8(15),n2h8(35))
  call Hloop_AV_Q(ntryL,G1H16(60),ex3(:),G1H8(25),m3h2x8(:,58),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(25),20,0,G2H8(16),n2h8(36))
  call Hloop_AQ_V(ntryL,G1H16(65),ex1(:),G1H8(25),m3h2x8(:,59),heltab2x16(:,:,77))
  call Hloop_AQ_Z(ntryL,G1H16(63),ex1(:),G1H8(26),ngZu,m3h2x8(:,60),heltab2x16(:,:,78))
  call Hloop_AQ_W(ntryL,G1H16(64),ex1(:),G1H8(27),m3h2x8(:,61),heltab2x16(:,:,79))
  call Hloop_QV_A(ntryL,G1H8(13),ex3(:),G1H4(29),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(29),21,0,G2H4(9),n2h4(65))
  call Hloop_UW_V(ntryL,G0H8(1),17,ex3(:),4,G1H4(30),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(33),n2h4(66))
  call Hloop_ZA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngZu,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(34),n2h4(67))
  call Hloop_WA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(35),n2h4(68))
  call Hloop_QA_W(ntryL,G1H8(14),ex2(:),G1H4(36),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_QA_W(ntryL,G1H8(15),ex2(:),G1H4(39),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_VA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(40),n2h4(69))
  call Hloop_ZA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),ngZu,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(41),n2h4(70))
  call Hloop_WA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(42),n2h4(71))
  call Hloop_QA_W(ntryL,G1H8(16),ex2(:),G1H4(45),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_QA_W(ntryL,G1H8(17),ex2(:),G1H4(46),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_AV_Q(ntryL,G1H8(18),ex3(:),G1H4(47),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(47),22,0,G2H4(10),n2h4(72))
  call Hloop_UV_W(ntryL,G0H8(10),18,ex3(:),4,G1H4(48),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(51),n2h4(73))
  call Hloop_ZQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),ngZu,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(52),n2h4(74))
  call Hloop_WQ_A(ntryL,G0H8(13),ex1(:),G0H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(53),n2h4(75))
  call Hloop_AQ_W(ntryL,G1H8(19),ex1(:),G1H4(54),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_AQ_W(ntryL,G1H8(20),ex1(:),G1H4(57),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(58),n2h4(76))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),ngZu,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(59),n2h4(77))
  call Hloop_WQ_A(ntryL,G0H8(17),ex1(:),G0H4(1),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(60),n2h4(78))
  call Hloop_AQ_W(ntryL,G1H8(1),ex1(:),G1H4(63),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_AQ_W(ntryL,G1H8(2),ex1(:),G1H4(64),m3h2x4(:,62),heltab2x8(:,:,62))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(25)])
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(61)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(128),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(38),G1H4(32),G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(116),G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(74),G1H4(68),G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(92),G1H4(86),G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(110),G1H4(104),G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(165)])
  call Hloop_QV_A(ntryL,G1H4(3),ex3(:),G1H2(12),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(12),23,0,G2H2(85),n2h2(77))
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(11),mass4set(:,1),  & 
G1H4(65),G1H4(66),G1H4(69),G1H4(70),G1H4(71),4)
  call HG1shiftOLR(G1H4(66),2,4)
  call Hloop_QV_A(ntryL,G1H4(4),ex4(:),G1H2(18),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(18),27,0,G2H2(93),n2h2(78))
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(14),mass4set(:,1),  & 
G1H4(72),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(75),2,4)
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(24),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(24),23,0,G2H2(1),n2h2(79))
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(35),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(35),23,0,G2H2(4),n2h2(80))
  call Hloop_ZA_Q(ntryL,G1H4(13),ex2(:),G1H2(46),ngZu,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(46),23,0,G2H2(5),n2h2(81))
  call Hloop_ZA_Q(ntryL,G1H4(22),ex2(:),G1H2(57),ngZu,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(57),23,0,G2H2(8),n2h2(82))
  call Hloop_WA_Q(ntryL,G1H4(19),ex2(:),G1H2(68),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(68),23,0,G2H2(9),n2h2(83))
  call Hloop_WA_Q(ntryL,G1H4(23),ex2(:),G1H2(79),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(79),23,0,G2H2(12),n2h2(84))
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(21),mass4set(:,1),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(87),G0H4(1),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hloop_QV_A(ntryL,G1H4(52),ex3(:),G1H2(90),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(90),23,0,G2H2(13),n2h2(85))
  call Hloop_QV_A(ntryL,G1H4(53),ex3(:),G1H2(101),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(101),23,0,G2H2(16),n2h2(86))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(112),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(112),23,0,G2H2(17),n2h2(87))
  call Hloop_VQ_A(ntryL,G1H4(24),ex1(:),G1H2(123),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(123),23,0,G2H2(20),n2h2(88))
  call Hloop_ZQ_A(ntryL,G1H4(49),ex1(:),G1H2(134),ngZu,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(134),23,0,G2H2(21),n2h2(89))
  call Hloop_ZQ_A(ntryL,G1H4(27),ex1(:),G1H2(145),ngZu,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(145),23,0,G2H2(24),n2h2(90))
  call Hloop_WQ_A(ntryL,G1H4(55),ex1(:),G1H2(156),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(156),23,0,G2H2(25),n2h2(91))
  call Hloop_WQ_A(ntryL,G1H4(28),ex1(:),G1H2(167),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(167),23,0,G2H2(28),n2h2(92))
  call Hotf_4pt_reduction(G2H4(28),RedSet_4(28),mass4set(:,1),  & 
G1H4(88),G1H4(89),G1H4(90),G1H4(93),G1H4(94),G0H4(2),4)
  call HG1shiftOLR(G1H4(89),4,4)
  call Hloop_QV_A(ntryL,G1H4(59),ex4(:),G1H2(178),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(178),27,0,G2H2(29),n2h2(93))
  call Hloop_QV_A(ntryL,G1H4(60),ex4(:),G1H2(189),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(189),27,0,G2H2(32),n2h2(94))
  call Hloop_AV_Q(ntryL,G1H4(33),ex3(:),G1H2(200),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(200),23,0,G2H2(33),n2h2(95))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(21),mass4set(:,1),  & 
G1H4(95),G1H4(96),G1H4(99),G1H4(100),G1H4(101),G0H4(3),4)
  call HG1shiftOLR(G1H4(96),8,4)
  call Hloop_AV_Q(ntryL,G1H4(34),ex3(:),G1H2(211),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(211),23,0,G2H2(36),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H4(35),ex3(:),G1H2(222),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(222),23,0,G2H2(37),n2h2(97))
  call Hloop_AV_Q(ntryL,G1H4(40),ex4(:),G1H2(233),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(233),27,0,G2H2(40),n2h2(98))
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(28),mass4set(:,1),  & 
G1H4(102),G1H4(105),G1H4(106),G1H4(107),G1H4(108),G0H4(4),4)
  call HG1shiftOLR(G1H4(105),4,4)
  call Hloop_AV_Q(ntryL,G1H4(41),ex4(:),G1H2(244),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(244),27,0,G2H2(41),n2h2(99))
  call Hloop_AV_Q(ntryL,G1H4(42),ex4(:),G1H2(260),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(260),27,0,G2H2(44),n2h2(100))
  call Hloop_WQ_A(ntryL,G1H4(48),ex1(:),G1H2(9),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(9),23,0,G2H2(45),n2h2(101))
  call Hloop_WQ_A(ntryL,G1H4(121),ex1(:),G1H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(48),n2h2(102))
  call Hloop_WQ_A(ntryL,G1H4(122),ex1(:),G1H2(250),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(250),27,0,G2H2(49),n2h2(103))
  call Hloop_WA_Q(ntryL,G1H4(30),ex2(:),G1H2(13),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(13),23,0,G2H2(52),n2h2(104))
  call Hloop_UW_V(ntryL,G1H4(132),21,ex4(:),8,G2H2(53),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_UW_V(ntryL,G1H4(133),21,ex4(:),8,G2H2(56),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_WA_Q(ntryL,G1H4(138),ex2(:),G1H2(14),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(14),27,0,G2H2(57),n2h2(105))
  call Hloop_WA_Q(ntryL,G1H4(139),ex2(:),G1H2(266),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(266),27,0,G2H2(60),n2h2(106))
  call Hloop_UW_V(ntryL,G1H4(143),25,ex3(:),4,G2H2(61),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_UW_V(ntryL,G1H4(144),25,ex3(:),4,G2H2(64),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(10),mass4set(:,1),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(117),4)
  call HG1shiftOLR(G1H4(112),2,4)
  call Hloop_QV_A(ntryL,G1H4(155),ex4(:),G1H2(19),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(19),29,0,G2H2(65),n2h2(107))
  call Hloop_QV_A(ntryL,G1H4(156),ex4(:),G1H2(20),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(20),29,0,G2H2(68),n2h2(108))
  call Hloop_QV_A(ntryL,G1H4(160),ex4(:),G1H2(25),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(25),29,0,G2H2(69),n2h2(109))
  call Hloop_QV_A(ntryL,G1H4(161),ex4(:),G1H2(26),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(26),29,0,G2H2(72),n2h2(110))
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(13),mass4set(:,1),  & 
G1H4(118),G1H4(119),G1H4(120),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(119),2,4)
  call Hloop_QV_A(ntryL,G1H4(171),ex3(:),G1H2(30),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(30),29,0,G2H2(73),n2h2(111))
  call Hloop_QV_A(ntryL,G1H4(172),ex3(:),G1H2(31),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(31),29,0,G2H2(76),n2h2(112))
  call Hloop_QV_A(ntryL,G1H4(176),ex3(:),G1H2(36),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(36),29,0,G2H2(77),n2h2(113))
  call Hloop_QV_A(ntryL,G1H4(177),ex3(:),G1H2(37),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(37),29,0,G2H2(80),n2h2(114))
  call Hloop_VWW_V(ntryL,G1H8(4),ex4(:),ex3(:),G1H2(41),m4h2x2x2(:,1),heltab3x8(:,:,1))
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(28),mass4set(:,7),  & 
G1H4(125),G1H4(126),G1H4(129),G1H4(130),G1H4(1),G0H4(5),4)
  call HG1shiftOLR(G1H4(126),4,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(28),mass4set(:,7),  & 
G1H4(131),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G0H4(6),4)
  call HG1shiftOLR(G1H4(134),4,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(28),mass4set(:,8),  & 
G1H4(140),G1H4(141),G1H4(2),G1H4(142),G1H4(145),G0H4(7),4)
  call HG1shiftOLR(G1H4(141),4,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(28),mass4set(:,8),  & 
G1H4(146),G1H4(147),G1H4(148),G1H4(153),G1H4(158),G0H4(8),4)
  call HG1shiftOLR(G1H4(147),4,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(21),mass4set(:,7),  & 
G1H4(154),G1H4(157),G1H4(159),G1H4(162),G1H4(163),G0H4(9),4)
  call HG1shiftOLR(G1H4(157),8,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(21),mass4set(:,7),  & 
G1H4(164),G1H4(169),G1H4(174),G1H4(170),G1H4(173),G0H4(10),4)
  call HG1shiftOLR(G1H4(169),8,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(21),mass4set(:,8),  & 
G1H4(175),G1H4(178),G1H4(151),G1H4(152),G1H4(167),G0H4(11),4)
  call HG1shiftOLR(G1H4(178),8,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(21),mass4set(:,8),  & 
G1H4(168),G1H4(5),G1H4(6),G1H4(9),G1H4(10),G0H4(12),4)
  call HG1shiftOLR(G1H4(5),8,4)
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(18),mass4set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G0H8(19),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(18),mass4set(:,7),  & 
G1H8(18),G1H8(19),G1H8(20),G1H8(1),G1H8(2),G0H8(2),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(18),mass4set(:,1),  & 
G1H8(4),G1H8(28),G1H8(29),G1H8(30),G1H8(31),G0H8(6),8)
  call HG1shiftOLR(G1H8(28),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(18),mass4set(:,7),  & 
G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),G0H8(11),8)
  call HG1shiftOLR(G1H8(33),8,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(18),mass4set(:,8),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G0H8(15),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(18),mass4set(:,8),  & 
G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),G0H8(1),8)
  call HG1shiftOLR(G1H8(43),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(9),mass4set(:,1),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),8)
  call HG1shiftOLR(G1H8(48),5,8)
  call Hloop_UV_W(ntryL,G1H8(3),18,ex4(:),8,G2H4(11),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_VQ_A(ntryL,G1H8(9),wf4(:,3),G1H2(42),m3h4x2(:,1),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(42),23,0,G2H2(81),n2h2(115))
  call Hloop_ZQ_A(ntryL,G1H8(5),wf4(:,3),G1H2(47),ngZu,m3h4x2(:,2),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(47),23,0,G2H2(84),n2h2(116))
  call Hloop_WQ_A(ntryL,G1H8(6),wf4(:,3),G1H2(48),m3h4x2(:,3),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(48),23,0,G2H2(88),n2h2(117))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(3),mass4set(:,1),  & 
G1H8(3),G1H8(9),G1H8(5),G1H8(6),G1H8(52),8)
  call HG1shiftOLR(G1H8(9),6,8)
  call Hloop_UW_V(ntryL,G1H8(8),17,ex4(:),8,G2H4(12),m3h2x4(:,64),heltab2x8(:,:,67))
  call Hloop_VA_Q(ntryL,G1H8(10),wf4(:,10),G1H2(52),m3h4x2(:,4),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(52),23,0,G2H2(89),n2h2(118))
  call Hloop_ZA_Q(ntryL,G1H8(11),wf4(:,10),G1H2(53),ngZu,m3h4x2(:,5),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(53),23,0,G2H2(92),n2h2(119))
  call Hloop_WA_Q(ntryL,G1H8(12),wf4(:,10),G1H2(58),m3h4x2(:,6),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(58),23,0,G2H2(96),n2h2(120))
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(8),mass4set(:,1),  & 
G1H8(8),G1H8(10),G1H8(11),G1H8(12),G1H8(53),8)
  call HG1shiftOLR(G1H8(10),9,8)
  call Hloop_UV_W(ntryL,G1H8(7),18,ex3(:),4,G2H4(13),m3h2x4(:,65),heltab2x8(:,:,71))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(14),m3h2x4(:,66),heltab2x8(:,:,72))
  call Hloop_QA_Z(ntryL,G2H8(11),ex2(:),G2H4(15),ngZu,m3h2x4(:,67),heltab2x8(:,:,73))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(16),m3h2x4(:,68),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H8(21),wf4(:,9),G1H2(59),m3h4x2(:,7),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(59),27,0,G2H2(97),n2h2(121))
  call Hloop_ZQ_A(ntryL,G1H8(22),wf4(:,9),G1H2(63),ngZu,m3h4x2(:,8),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(63),27,0,G2H2(99),n2h2(122))
  call Hloop_WQ_A(ntryL,G1H8(23),wf4(:,9),G1H2(64),m3h4x2(:,9),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(64),27,0,G2H2(102),n2h2(123))
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(2),mass4set(:,1),  & 
G1H8(7),G1H8(21),G1H8(22),G1H8(23),G1H8(54),8)
  call HG1shiftOLR(G1H8(21),10,8)
  call Hloop_UW_V(ntryL,G1H8(24),17,ex3(:),4,G2H4(17),m3h2x4(:,69),heltab2x8(:,:,78))
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(18),m3h2x4(:,70),heltab2x8(:,:,79))
  call Hloop_AQ_Z(ntryL,G2H8(15),ex1(:),G2H4(19),ngZu,m3h2x4(:,71),heltab2x8(:,:,80))
  call Hloop_AQ_W(ntryL,G2H8(16),ex1(:),G2H4(20),m3h2x4(:,72),heltab2x8(:,:,81))
  call Hloop_VA_Q(ntryL,G1H8(25),wf4(:,4),G1H2(69),m3h4x2(:,10),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(69),27,0,G2H2(104),n2h2(124))
  call Hloop_ZA_Q(ntryL,G1H8(26),wf4(:,4),G1H2(70),ngZu,m3h4x2(:,11),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(70),27,0,G2H2(107),n2h2(125))
  call Hloop_WA_Q(ntryL,G1H8(27),wf4(:,4),G1H2(74),m3h4x2(:,12),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(74),27,0,G2H2(108),n2h2(126))
  call Hloop_QA_W(ntryL,G2H4(9),ex2(:),G2H2(109),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_VV_S(ntryL,G1H4(36),ex3(:),G1H2(75),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_UV_W(ntryL,G1H4(39),19,ex3(:),4,G2H2(110),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_VV_S(ntryL,G1H4(45),ex4(:),G1H2(80),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_UV_W(ntryL,G1H4(46),19,ex4(:),8,G2H2(111),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_AQ_W(ntryL,G2H4(10),ex1(:),G2H2(112),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VV_S(ntryL,G1H4(54),ex3(:),G1H2(81),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_UW_V(ntryL,G1H4(57),19,ex3(:),4,G2H2(113),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_VV_S(ntryL,G1H4(63),ex4(:),G1H2(85),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_UW_V(ntryL,G1H4(64),19,ex4(:),8,G2H2(114),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_QV_A(ntryL,G1H4(65),ex4(:),G1H2(86),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(86),29,0,G2H2(115),n2h2(127))
call HGT_raise_alpha_OLR(G1H4(66),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(66),ex2(:),G1H2(91),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_QV_A(ntryL,G1H4(70),ex4(:),G1H2(92),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(92),29,0,G2H2(116),n2h2(128))
  call Hloop_QV_A(ntryL,G1H4(71),ex4(:),G1H2(96),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(96),29,0,G2H2(117),n2h2(129))
  call Hloop_QV_A(ntryL,G1H4(72),ex3(:),G1H2(97),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(97),29,0,G2H2(118),n2h2(130))
call HGT_raise_alpha_OLR(G1H4(75),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(75),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(75),ex2(:),G1H2(102),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_QV_A(ntryL,G1H4(77),ex3(:),G1H2(103),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(103),29,0,G2H2(119),n2h2(131))
  call Hloop_QV_A(ntryL,G1H4(78),ex3(:),G1H2(107),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(107),29,0,G2H2(120),n2h2(132))
  call Hloop_QV_A(ntryL,G1H4(81),ex3(:),G1H2(108),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(108),23,0,G2H2(121),n2h2(133))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(82),-8,0,G2H4(21),n2h4(81))
  call Hloop_AV_Q(ntryL,G2H4(21),ex4(:),G2H2(122),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_QV_A(ntryL,G1H4(84),ex3(:),G1H2(113),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(113),23,0,G2H2(123),n2h2(134))
  call Hloop_QV_A(ntryL,G1H4(87),ex3(:),G1H2(114),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(114),23,0,G2H2(124),n2h2(135))
  call Hloop_QV_A(ntryL,G0H4(1),ex3(:),G0H2(1),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(118),n2h2(136))
  call Hloop_QV_A(ntryL,G1H4(88),ex4(:),G1H2(119),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(119),27,0,G2H2(125),n2h2(137))
call HGT_OLR(G1H4(89),1,1,4)
call HGT_invQ_OLR(G1H4(89),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(89),-4,0,G2H4(22),n2h4(82))
  call Hloop_AV_Q(ntryL,G2H4(22),ex3(:),G2H2(126),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_QV_A(ntryL,G1H4(93),ex4(:),G1H2(124),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(124),27,0,G2H2(127),n2h2(138))
  call Hloop_QV_A(ntryL,G1H4(94),ex4(:),G1H2(125),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(125),27,0,G2H2(128),n2h2(139))
  call Hloop_QV_A(ntryL,G0H4(2),ex4(:),G0H2(1),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(129),n2h2(140))
  call Hloop_AV_Q(ntryL,G1H4(95),ex3(:),G1H2(130),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(130),23,0,G2H2(129),n2h2(141))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(96),-8,0,G2H4(23),n2h4(83))
  call Hloop_QV_A(ntryL,G2H4(23),ex4(:),G2H2(130),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_AV_Q(ntryL,G1H4(100),ex3(:),G1H2(135),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(135),23,0,G2H2(131),n2h2(142))
  call Hloop_AV_Q(ntryL,G1H4(101),ex3(:),G1H2(136),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(136),23,0,G2H2(132),n2h2(143))
  call Hloop_AV_Q(ntryL,G0H4(3),ex3(:),G0H2(1),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(140),n2h2(144))
  call Hloop_AV_Q(ntryL,G1H4(102),ex4(:),G1H2(141),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(141),27,0,G2H2(133),n2h2(145))
call HGT_OLR(G1H4(105),1,1,4)
call HGT_invQ_OLR(G1H4(105),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(105),-4,0,G2H4(24),n2h4(84))
  call Hloop_QV_A(ntryL,G2H4(24),ex3(:),G2H2(134),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_AV_Q(ntryL,G1H4(107),ex4(:),G1H2(146),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(146),27,0,G2H2(135),n2h2(146))
  call Hloop_AV_Q(ntryL,G1H4(108),ex4(:),G1H2(147),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(147),27,0,G2H2(136),n2h2(147))
  call Hloop_AV_Q(ntryL,G0H4(4),ex4(:),G0H2(1),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(151),n2h2(148))
  call Hloop_QV_A(ntryL,G1H4(111),ex4(:),G1H2(152),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(152),29,0,G2H2(137),n2h2(149))
call HGT_raise_alpha_OLR(G1H4(112),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(112),ex2(:),G1H2(157),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_QV_A(ntryL,G1H4(114),ex4(:),G1H2(158),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(158),29,0,G2H2(138),n2h2(150))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(162),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(162),29,0,G2H2(139),n2h2(151))
  call Hloop_QV_A(ntryL,G1H4(118),ex3(:),G1H2(163),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(163),29,0,G2H2(140),n2h2(152))
call HGT_raise_alpha_OLR(G1H4(119),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(119),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(119),ex2(:),G1H2(168),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_QV_A(ntryL,G1H4(123),ex3(:),G1H2(169),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(169),29,0,G2H2(141),n2h2(153))
  call Hloop_QV_A(ntryL,G1H4(124),ex3(:),G1H2(173),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(173),29,0,G2H2(142),n2h2(154))
  call Hloop_QV_A(ntryL,G1H4(125),ex4(:),G1H2(174),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(174),27,nMT,G2H2(143),n2h2(155))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(126),-4,nMT,G2H4(26),n2h4(87))
  call Hloop_AV_Q(ntryL,G2H4(26),ex3(:),G2H2(144),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_QV_A(ntryL,G1H4(130),ex4(:),G1H2(179),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(179),27,nMT,G2H2(145),n2h2(156))
  call Hloop_QV_A(ntryL,G1H4(1),ex4(:),G1H2(180),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_Q_A(ntryL,G1H2(180),27,nMT,G2H2(146),n2h2(157))
  call Hloop_QV_A(ntryL,G0H4(5),ex4(:),G0H2(1),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(184),n2h2(158))
  call Hloop_AV_Q(ntryL,G1H4(131),ex4(:),G1H2(185),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(185),27,nMT,G2H2(147),n2h2(159))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-4,nMT,G2H4(30),n2h4(88))
  call Hloop_QV_A(ntryL,G2H4(30),ex3(:),G2H2(148),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_AV_Q(ntryL,G1H4(136),ex4(:),G1H2(190),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_A_Q(ntryL,G1H2(190),27,nMT,G2H2(149),n2h2(160))
  call Hloop_AV_Q(ntryL,G1H4(137),ex4(:),G1H2(191),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(191),27,nMT,G2H2(150),n2h2(161))
  call Hloop_AV_Q(ntryL,G0H4(6),ex4(:),G0H2(1),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(195),n2h2(162))
  call Hloop_QV_A(ntryL,G1H4(140),ex4(:),G1H2(196),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(196),27,nMB,G2H2(151),n2h2(163))
call HGT_OLR(G1H4(141),1,1,4)
call HGT_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(141),-4,nMB,G2H4(5),n2h4(89))
  call Hloop_AV_Q(ntryL,G2H4(5),ex3(:),G2H2(152),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_QV_A(ntryL,G1H4(142),ex4(:),G1H2(201),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(201),27,nMB,G2H2(153),n2h2(164))
  call Hloop_QV_A(ntryL,G1H4(145),ex4(:),G1H2(202),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(202),27,nMB,G2H2(154),n2h2(165))
  call Hloop_QV_A(ntryL,G0H4(7),ex4(:),G0H2(1),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(206),n2h2(166))
  call Hloop_AV_Q(ntryL,G1H4(146),ex4(:),G1H2(207),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(207),27,nMB,G2H2(155),n2h2(167))
call HGT_OLR(G1H4(147),1,1,4)
call HGT_invQ_OLR(G1H4(147),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(147),-4,nMB,G2H4(28),n2h4(90))
  call Hloop_QV_A(ntryL,G2H4(28),ex3(:),G2H2(156),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_AV_Q(ntryL,G1H4(153),ex4(:),G1H2(212),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(212),27,nMB,G2H2(157),n2h2(168))
  call Hloop_AV_Q(ntryL,G1H4(158),ex4(:),G1H2(213),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(213),27,nMB,G2H2(158),n2h2(169))
  call Hloop_AV_Q(ntryL,G0H4(8),ex4(:),G0H2(1),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(217),n2h2(170))
  call Hloop_AV_Q(ntryL,G1H4(154),ex3(:),G1H2(218),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(218),23,nMT,G2H2(159),n2h2(171))
call HGT_OLR(G1H4(157),1,1,4)
call HGT_invQ_OLR(G1H4(157),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(157),-8,nMT,G2H4(3),n2h4(91))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(160),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_AV_Q(ntryL,G1H4(162),ex3(:),G1H2(223),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(223),23,nMT,G2H2(161),n2h2(172))
  call Hloop_AV_Q(ntryL,G1H4(163),ex3(:),G1H2(224),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(224),23,nMT,G2H2(162),n2h2(173))
  call Hloop_AV_Q(ntryL,G0H4(9),ex3(:),G0H2(1),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(228),n2h2(174))
  call Hloop_QV_A(ntryL,G1H4(164),ex3(:),G1H2(229),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(229),23,nMT,G2H2(163),n2h2(175))
call HGT_OLR(G1H4(169),1,1,4)
call HGT_invQ_OLR(G1H4(169),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(169),-8,nMT,G2H4(31),n2h4(92))
  call Hloop_AV_Q(ntryL,G2H4(31),ex4(:),G2H2(164),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_QV_A(ntryL,G1H4(170),ex3(:),G1H2(234),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(234),23,nMT,G2H2(165),n2h2(176))
  call Hloop_QV_A(ntryL,G1H4(173),ex3(:),G1H2(235),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(235),23,nMT,G2H2(166),n2h2(177))
  call Hloop_QV_A(ntryL,G0H4(10),ex3(:),G0H2(1),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(239),n2h2(178))
  call Hloop_AV_Q(ntryL,G1H4(175),ex3(:),G1H2(240),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(240),23,nMB,G2H2(167),n2h2(179))
call HGT_OLR(G1H4(178),1,1,4)
call HGT_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(178),-8,nMB,G2H4(25),n2h4(93))
  call Hloop_QV_A(ntryL,G2H4(25),ex4(:),G2H2(168),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_AV_Q(ntryL,G1H4(152),ex3(:),G1H2(245),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(245),23,nMB,G2H2(169),n2h2(180))
  call Hloop_AV_Q(ntryL,G1H4(167),ex3(:),G1H2(246),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(246),23,nMB,G2H2(170),n2h2(181))
  call Hloop_AV_Q(ntryL,G0H4(11),ex3(:),G0H2(1),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(251),n2h2(182))
  call Hloop_QV_A(ntryL,G1H4(168),ex3(:),G1H2(255),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(255),23,nMB,G2H2(171),n2h2(183))
call HGT_OLR(G1H4(5),1,1,4)
call HGT_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(5),-8,nMB,G2H4(27),n2h4(94))
  call Hloop_AV_Q(ntryL,G2H4(27),ex4(:),G2H2(172),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_QV_A(ntryL,G1H4(9),ex3(:),G1H2(256),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(256),23,nMB,G2H2(173),n2h2(184))
  call Hloop_QV_A(ntryL,G1H4(10),ex3(:),G1H2(261),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(261),23,nMB,G2H2(174),n2h2(185))
  call Hloop_QV_A(ntryL,G0H4(12),ex3(:),G0H2(1),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(262),n2h2(186))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,13),G1H2(267),m3h4x2(:,13),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(267),23,0,G2H2(175),n2h2(187))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-8,0,G2H8(1),n2h8(37))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(29),m3h2x4(:,73),heltab2x8(:,:,86))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,13),G1H2(12),m3h4x2(:,14),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(12),23,0,G2H2(176),n2h2(188))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,13),G1H2(18),m3h4x2(:,15),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(18),23,0,G2H2(177),n2h2(189))
  call Hloop_QV_A(ntryL,G0H8(19),wf4(:,13),G0H2(1),m3h4x2(:,16),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(24),n2h2(190))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,13),G1H2(35),m3h4x2(:,17),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(35),23,nMT,G2H2(178),n2h2(191))
call HGT_OLR(G1H8(19),1,1,8)
call HGT_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(19),-8,nMT,G2H8(2),n2h8(38))
  call Hloop_AV_Q(ntryL,G2H8(2),ex4(:),G2H4(32),m3h2x4(:,74),heltab2x8(:,:,91))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,13),G1H2(46),m3h4x2(:,18),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(46),23,nMT,G2H2(179),n2h2(192))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,13),G1H2(57),m3h4x2(:,19),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(57),23,nMT,G2H2(180),n2h2(193))
  call Hloop_QV_A(ntryL,G0H8(2),wf4(:,13),G0H2(1),m3h4x2(:,20),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(68),n2h2(194))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,13),G1H2(79),m3h4x2(:,21),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(79),23,0,G2H2(181),n2h2(195))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-8,0,G2H8(3),n2h8(39))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(1),m3h2x4(:,75),heltab2x8(:,:,96))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,13),G1H2(90),m3h4x2(:,22),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(90),23,0,G2H2(182),n2h2(196))
  call Hloop_AV_Q(ntryL,G1H8(31),wf4(:,13),G1H2(101),m3h4x2(:,23),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(101),23,0,G2H2(183),n2h2(197))
  call Hloop_AV_Q(ntryL,G0H8(6),wf4(:,13),G0H2(1),m3h4x2(:,24),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(112),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H8(32),wf4(:,13),G1H2(123),m3h4x2(:,25),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(123),23,nMT,G2H2(184),n2h2(199))
call HGT_OLR(G1H8(33),1,1,8)
call HGT_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(33),-8,nMT,G2H8(4),n2h8(40))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(2),m3h2x4(:,76),heltab2x8(:,:,101))
  call Hloop_AV_Q(ntryL,G1H8(35),wf4(:,13),G1H2(134),m3h4x2(:,26),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(134),23,nMT,G2H2(185),n2h2(200))
  call Hloop_AV_Q(ntryL,G1H8(36),wf4(:,13),G1H2(145),m3h4x2(:,27),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(145),23,nMT,G2H2(186),n2h2(201))
  call Hloop_AV_Q(ntryL,G0H8(11),wf4(:,13),G0H2(1),m3h4x2(:,28),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(156),n2h2(202))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,13),G1H2(167),m3h4x2(:,29),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(167),23,nMB,G2H2(187),n2h2(203))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-8,nMB,G2H8(5),n2h8(41))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(4),m3h2x4(:,77),heltab2x8(:,:,106))
  call Hloop_QV_A(ntryL,G1H8(40),wf4(:,13),G1H2(178),m3h4x2(:,30),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(178),23,nMB,G2H2(188),n2h2(204))
  call Hloop_QV_A(ntryL,G1H8(41),wf4(:,13),G1H2(189),m3h4x2(:,31),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(189),23,nMB,G2H2(189),n2h2(205))
  call Hloop_QV_A(ntryL,G0H8(15),wf4(:,13),G0H2(1),m3h4x2(:,32),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(200),n2h2(206))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,13),G1H2(211),m3h4x2(:,33),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(211),23,nMB,G2H2(190),n2h2(207))
call HGT_OLR(G1H8(43),1,1,8)
call HGT_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(43),-8,nMB,G2H8(6),n2h8(42))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(6),m3h2x4(:,78),heltab2x8(:,:,111))
  call Hloop_AV_Q(ntryL,G1H8(45),wf4(:,13),G1H2(222),m3h4x2(:,34),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(222),23,nMB,G2H2(191),n2h2(208))
  call Hloop_AV_Q(ntryL,G1H8(46),wf4(:,13),G1H2(233),m3h4x2(:,35),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(233),23,nMB,G2H2(192),n2h2(209))
  call Hloop_AV_Q(ntryL,G0H8(1),wf4(:,13),G0H2(1),m3h4x2(:,36),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(244),n2h2(210))
  call Hloop_AV_Q(ntryL,G1H8(47),ex4(:),G1H4(11),m3h2x4(:,79),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(11),26,0,G2H4(7),n2h4(95))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(48),wf4(:,3),G1H2(260),m3h4x2(:,37),heltab2x8(:,:,116))
  call Hloop_AV_Q(ntryL,G1H8(50),ex4(:),G1H4(12),m3h2x4(:,80),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(12),26,0,G2H4(8),n2h4(96))
  call Hloop_AV_Q(ntryL,G1H8(51),ex4(:),G1H4(15),m3h2x4(:,81),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(15),26,0,G2H4(9),n2h4(97))
  call Hloop_QV_A(ntryL,G1H8(3),ex4(:),G1H4(16),m3h2x4(:,82),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(16),25,0,G2H4(10),n2h4(98))
call HGT_raise_alpha_OLR(G1H8(9),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(9),wf4(:,10),G1H2(9),m3h4x2(:,38),heltab2x8(:,:,120))
  call Hloop_QV_A(ntryL,G1H8(6),ex4(:),G1H4(17),m3h2x4(:,83),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(17),25,0,G2H4(21),n2h4(99))
  call Hloop_QV_A(ntryL,G1H8(52),ex4(:),G1H4(18),m3h2x4(:,84),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(18),25,0,G2H4(22),n2h4(100))
  call Hloop_AV_Q(ntryL,G1H8(8),ex3(:),G1H4(29),m3h2x4(:,85),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(29),22,0,G2H4(23),n2h4(101))
call HGT_raise_alpha_OLR(G1H8(10),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(10),wf4(:,9),G1H2(1),m3h4x2(:,39),heltab2x8(:,:,124))
  call Hloop_AV_Q(ntryL,G1H8(12),ex3(:),G1H4(47),m3h2x4(:,86),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(47),22,0,G2H4(24),n2h4(102))
  call Hloop_AV_Q(ntryL,G1H8(53),ex3(:),G1H4(25),m3h2x4(:,87),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(25),22,0,G2H4(26),n2h4(103))
  call Hloop_QV_A(ntryL,G1H8(7),ex3(:),G1H4(51),m3h2x4(:,88),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(51),21,0,G2H4(30),n2h4(104))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(21),wf4(:,4),G1H2(250),m3h4x2(:,40),heltab2x8(:,:,128))
  call Hloop_QV_A(ntryL,G1H8(23),ex3(:),G1H4(150),m3h2x4(:,89),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(150),21,0,G2H4(5),n2h4(105))
  call Hloop_QV_A(ntryL,G1H8(54),ex3(:),G1H4(61),m3h2x4(:,90),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(61),21,0,G2H4(28),n2h4(106))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G2H2(11),G2H2(7),G2H2(3),G1H2(45),G1H2(34) &
    ,G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(15),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(19),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(75),G2H2(23),G1H2(221),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G2H2(35),G2H2(31),G2H2(27),G1H2(111),G1H2(100) &
    ,G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(87)])
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(39),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(98)])
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(43),G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(109)])
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(79),G2H2(47),G1H2(232),G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(51),G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(55),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(83),G2H2(59),G1H2(243),G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(21)])
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(63),G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(32)])
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(67),G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(43)])
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G2H2(91),G2H2(71),G1H2(259),G1H2(210)])
call HGT_lower_alpha_w2_OLR(G2H2(86),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(86),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(86),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(87),G1H2(41),G1H2(17),G1H2(11)])
call HGT_lower_alpha_w2_OLR(G2H2(94),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(94),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(94),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(54)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G2H2(98)])
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(105),G2H2(101),G2H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(120)])
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(6)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G1H2(51),G1H2(40),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(242),G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(248),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G1H2(77),G1H2(66),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G1H2(83),G1H2(72),G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G1H2(117),G1H2(106),G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(220),G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(226),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G1H2(143),G1H2(132),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G1H2(149),G1H2(138),G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(238),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(176),G1H2(165),G1H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G1H2(182),G1H2(171),G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(249),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G1H2(209),G1H2(198),G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G1H2(215),G1H2(204),G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(265),[G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(80)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(47),mass4set(:,1),  & 
G1H2(13),G1H2(14),G1H2(266),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(14),2,2)
  call Hotf_4pt_reduction(G2H2(181),RedSet_4(18),mass4set(:,1),  & 
G1H2(25),G1H2(26),G1H2(30),G1H2(31),G1H2(36),2)
  call HG1shiftOLR(G1H2(26),8,2)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(47),mass4set(:,2),  & 
G1H2(37),G1H2(42),G1H2(47),G1H2(48),G1H2(52),2)
  call HG1shiftOLR(G1H2(42),2,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(47),mass4set(:,3),  & 
G1H2(53),G1H2(58),G1H2(59),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(58),2,2)
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(48),mass4set(:,1),  & 
G1H2(69),G1H2(70),G1H2(74),G1H2(86),G1H2(92),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(22),mass4set(:,1),  & 
G1H2(96),G1H2(97),G1H2(103),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(97),8,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(48),mass4set(:,4),  & 
G1H2(113),G1H2(114),G1H2(119),G1H2(124),G1H2(125),2)
  call HG1shiftOLR(G1H2(114),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(22),mass4set(:,4),  & 
G1H2(130),G1H2(135),G1H2(136),G1H2(141),G1H2(146),2)
  call HG1shiftOLR(G1H2(135),8,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(48),mass4set(:,5),  & 
G1H2(147),G1H2(152),G1H2(158),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(152),4,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(22),mass4set(:,5),  & 
G1H2(169),G1H2(173),G1H2(174),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(173),8,2)
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(49),mass4set(:,1),  & 
G1H2(185),G1H2(190),G1H2(191),G1H2(196),G1H2(201),2)
  call HG1shiftOLR(G1H2(190),1,2)
  call Hotf_4pt_reduction(G2H2(175),RedSet_4(18),mass4set(:,1),  & 
G1H2(202),G1H2(207),G1H2(212),G1H2(213),G1H2(218),2)
  call HG1shiftOLR(G1H2(207),8,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(49),mass4set(:,2),  & 
G1H2(223),G1H2(224),G1H2(229),G1H2(234),G1H2(235),2)
  call HG1shiftOLR(G1H2(224),1,2)
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(49),mass4set(:,3),  & 
G1H2(240),G1H2(245),G1H2(246),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(245),1,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(24),mass4set(:,1),  & 
G1H2(261),G1H2(267),G1H2(12),G1H2(18),G1H2(35),2)
  call HG1shiftOLR(G1H2(267),8,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(29),mass4set(:,1),  & 
G1H2(46),G1H2(57),G1H2(79),G1H2(90),G1H2(101),2)
  call HG1shiftOLR(G1H2(57),4,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(24),mass4set(:,4),  & 
G1H2(123),G1H2(134),G1H2(145),G1H2(167),G1H2(178),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(29),mass4set(:,4),  & 
G1H2(189),G1H2(211),G1H2(222),G1H2(233),G1H2(45),2)
  call HG1shiftOLR(G1H2(211),4,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(24),mass4set(:,5),  & 
G1H2(34),G1H2(23),G1H2(56),G1H2(67),G1H2(221),2)
  call HG1shiftOLR(G1H2(23),8,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(29),mass4set(:,5),  & 
G1H2(78),G1H2(111),G1H2(100),G1H2(89),G1H2(87),2)
  call HG1shiftOLR(G1H2(111),4,2)
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(50),mass4set(:,1),  & 
G1H2(122),G1H2(98),G1H2(133),G1H2(109),G1H2(232),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(32),mass4set(:,1),  & 
G1H2(144),G1H2(155),G1H2(166),G1H2(243),G1H2(177),2)
  call HG1shiftOLR(G1H2(155),8,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(50),mass4set(:,4),  & 
G1H2(21),G1H2(188),G1H2(32),G1H2(199),G1H2(43),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(32),mass4set(:,4),  & 
G1H2(259),G1H2(210),G1H2(41),G1H2(17),G1H2(11),2)
  call HG1shiftOLR(G1H2(210),8,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(50),mass4set(:,5),  & 
G1H2(54),G1H2(3),G1H2(60),G1H2(120),G1H2(6),2)
  call HG1shiftOLR(G1H2(3),4,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(32),mass4set(:,5),  & 
G1H2(126),G1H2(2),G1H2(10),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(16),mass4set(:,1),  & 
G1H2(22),G1H2(51),G1H2(40),G1H2(29),G1H2(33),2)
  call HG1shiftOLR(G1H2(51),8,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(35),mass4set(:,1),  & 
G1H2(242),G1H2(44),G1H2(50),G1H2(77),G1H2(66),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(16),mass4set(:,4),  & 
G1H2(55),G1H2(83),G1H2(72),G1H2(61),G1H2(65),2)
  call HG1shiftOLR(G1H2(83),8,2)
  call Hotf_4pt_reduction(G2H2(107),RedSet_4(35),mass4set(:,4),  & 
G1H2(76),G1H2(84),G1H2(88),G1H2(117),G1H2(106),2)
  call HG1shiftOLR(G1H2(84),4,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(16),mass4set(:,5),  & 
G1H2(95),G1H2(99),G1H2(220),G1H2(110),G1H2(116),2)
  call HG1shiftOLR(G1H2(99),8,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(35),mass4set(:,5),  & 
G1H2(143),G1H2(132),G1H2(121),G1H2(149),G1H2(138),2)
  call HG1shiftOLR(G1H2(132),4,2)
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(51),mass4set(:,6),  & 
G1H2(127),G1H2(131),G1H2(142),G1H2(150),G1H2(153),2)
  call HG1shiftOLR(G1H2(131),1,2)
call HGT_OLR(G2H2(78),1,1,2)
call HGT_invQ_OLR(G2H2(78),2,5,2)
call HGT_OLR(G2H2(78),6,15,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(52),mass4set(:,6),  & 
G1H2(176),G1H2(165),G1H2(154),G1H2(182),G1H2(171),2)
  call HG1shiftOLR(G1H2(165),1,2)
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(53),mass4set(:,6),  & 
G1H2(160),G1H2(164),G1H2(175),G1H2(183),G1H2(186),2)
  call HG1shiftOLR(G1H2(164),2,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(20),mass4set(:,9),  & 
G1H2(209),G1H2(198),G1H2(187),G1H2(215),G1H2(204),2)
  call HG1shiftOLR(G1H2(198),8,2)
  call Hotf_4pt_reduction(G2H2(95),RedSet_4(1),mass4set(:,6),  & 
G1H2(193),G1H2(197),G1H2(208),G1H2(216),G1H2(219),2)
  call HG1shiftOLR(G1H2(197),2,2)
call HGT_OLR(G2H2(90),1,1,2)
call HGT_invQ_OLR(G2H2(90),2,5,2)
call HGT_OLR(G2H2(90),6,15,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(54),mass4set(:,6),  & 
G1H2(230),G1H2(231),G1H2(241),G1H2(254),G1H2(257),2)
  call HG1shiftOLR(G1H2(231),2,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(27),mass4set(:,9),  & 
G1H2(258),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(271),4,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(20),mass4set(:,1),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),2)
  call HG1shiftOLR(G1H2(276),8,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(103),ex2(:),G2tensor(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hloop_QV_A(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(97))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(5),m3h2x1(:,103),heltab2x2(:,:,103))
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(98))
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(27),mass4set(:,1),  & 
G1H2(4),G1H2(5),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(5),4,2)
  call Hloop_QV_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(99))
call HGT_w2_OLR(G1H2(8),1,1,2)
call HGT_w2_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(15),n2h1(100))
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(10),mass4set(:,10),  & 
G1H2(7),G1H2(8),G1H2(283),G1H2(284),G1H2(285),2)



end subroutine vamp_1

end module ol_vamp_1_ppjjj_ew_uuxaag_2_/**/REALKIND
