
module ol_vamp_1_ppjjj_ew_ddxggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ew_ddxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ew_ddxggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjjj_ew_ddxggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppjjj_ew_ddxggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppjjj_ew_ddxggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjjj_ew_ddxggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(22,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(3)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(4)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(23)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(16)*M(8,:)%j)+c(17)*M(20,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(10)*M(8,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  Gcoeff(:)%j = (c(3)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(5))
  Gcoeff(:)%j = (c(4)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(6))
  Gcoeff(:)%j = (c(23)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(7))
  Gcoeff(:)%j = (-(c(16)*M(12,:)%j)+c(17)*M(22,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(9),n2h16(8))
  Gcoeff(:)%j = (c(10)*M(12,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(11),n2h16(9))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(12),n2h16(10))
  Gcoeff(:)%j = (c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[0,0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(13),n2h16(11))
  Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(22,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(14),n2h16(12))
  Gcoeff(:)%j = (c(10)*M(4,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (c(3)*M(9,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(13))
  Gcoeff(:)%j = (c(4)*M(9,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(17),n2h16(14))
  Gcoeff(:)%j = (c(23)*M(9,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,2,1,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(18),n2h16(15))
  Gcoeff(:)%j = (-(c(16)*M(10,:)%j)+c(17)*M(20,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(19),n2h16(16))
  Gcoeff(:)%j = (c(10)*M(10,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(21),n2h16(17))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(22),n2h16(18))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(23),n2h16(19))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(20,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(24),n2h16(20))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
  Gcoeff(:)%j = (c(3)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(26),n2h16(21))
  Gcoeff(:)%j = (c(4)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(27),n2h16(22))
  Gcoeff(:)%j = (c(23)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(28),n2h16(23))
  Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(22,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(24))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (c(8)*(-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(31),n2h16(25))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(16,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(8)*(-M(16,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(33),n2h16(26))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (c(8)*(M(18,:)%j-M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(35),n2h16(27))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(16,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,36),heltab2x32(:,:,36))
  Gcoeff(:)%j = (c(8)*(-M(14,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (c(17)*(-M(16,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(38),n2h16(28))
  Gcoeff(:)%j = (c(8)*(M(16,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(39),n2h16(29))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,40),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(8)*(-M(14,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,41),heltab2x32(:,:,41))
  Gcoeff(:)%j = (c(17)*(-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(42),n2h16(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(26)])
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(3),n2h8(3))
  call Hloop_UV_W(ntryL,G1H16(5),16,ex3(:),4,G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_V(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_Z(ntryL,G1H16(7),ex2(:),G1H8(2),ngZd,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_W(ntryL,G1H16(8),ex2(:),G1H8(3),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(4),18,0,G2H8(5),n2h8(4))
  call Hloop_QV_A(ntryL,G1H16(14),ex3(:),G1H8(4),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(6),n2h8(5))
  call Hloop_QV_A(ntryL,G1H16(12),ex3(:),G1H8(4),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(7),n2h8(6))
  call Hloop_QV_A(ntryL,G1H16(13),ex3(:),G1H8(4),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(4),20,0,G2H8(8),n2h8(7))
  call Hloop_UV_W(ntryL,G1H16(15),16,ex3(:),4,G2H8(9),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G1H16(19),ex2(:),G1H8(4),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_QA_Z(ntryL,G1H16(17),ex2(:),G1H8(5),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QA_W(ntryL,G1H16(18),ex2(:),G1H8(6),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_VA_Q(ntryL,G1H16(20),ex2(:),G1H8(7),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(7),18,0,G2H8(10),n2h8(8))
  call Hloop_AQ_V(ntryL,G1H16(24),ex1(:),G1H8(7),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(8),ngZd,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_W(ntryL,G1H16(23),ex1(:),G1H8(9),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_VQ_A(ntryL,G1H16(25),ex1(:),G1H8(10),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(10),17,0,G2H8(11),n2h8(9))
  call Hloop_AQ_V(ntryL,G1H16(29),ex1(:),G1H8(10),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex1(:),G1H8(11),ngZd,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_W(ntryL,G1H16(28),ex1(:),G1H8(12),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_VQ_A(ntryL,G1H16(30),ex1(:),G1H8(13),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(13),17,0,G2H8(12),n2h8(10))
  call Hloop_QA_V(ntryL,G1H16(31),ex2(:),G1H8(13),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_VA_Q(ntryL,G1H16(32),ex2(:),G1H8(14),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(14),18,0,G2H8(13),n2h8(11))
  call Hloop_QA_V(ntryL,G1H16(33),ex2(:),G1H8(14),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_VA_Q(ntryL,G1H16(34),ex2(:),G1H8(15),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(15),18,0,G2H8(14),n2h8(12))
  call Hloop_AQ_V(ntryL,G1H16(35),ex1(:),G1H8(15),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_VQ_A(ntryL,G1H16(36),ex1(:),G1H8(16),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(15),n2h8(13))
  call Hloop_VQ_A(ntryL,G1H16(37),ex1(:),G1H8(16),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(16),n2h8(14))
  call Hloop_AQ_V(ntryL,G1H16(38),ex1(:),G1H8(16),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_AQ_V(ntryL,G1H16(39),ex1(:),G1H8(17),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_VQ_A(ntryL,G1H16(40),ex1(:),G1H8(18),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(18),17,0,G2H8(17),n2h8(15))
  call Hloop_VQ_A(ntryL,G1H16(41),ex1(:),G1H8(18),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(18),17,0,G2H8(18),n2h8(16))
  call Hloop_AQ_V(ntryL,G1H16(42),ex1(:),G1H8(18),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZd,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(1),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(4),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngZd,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(5),n2h4(2))
  call Hloop_WQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(6),n2h4(3))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(6),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_Z(ntryL,G2H8(7),ex2(:),G2H4(9),ngZd,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_W(ntryL,G2H8(8),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(2),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(11),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngZd,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(12),n2h4(5))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(13),n2h4(6))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(15),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZd,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(16),n2h4(8))
  call Hloop_WA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(17),n2h4(9))
  call Hloop_QA_V(ntryL,G2H8(11),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(19),n2h4(10))
  call Hloop_ZA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),ngZd,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(20),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(21),n2h4(12))
  call Hloop_QA_V(ntryL,G2H8(12),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_UV_W(ntryL,G1H8(13),18,ex3(:),4,G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(3),mass5set(:,1),  & 
G1H8(4),G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(5),8,8)
  call Hloop_UV_W(ntryL,G1H8(14),18,ex4(:),8,G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(4),mass5set(:,1),  & 
G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(28),8)
  call HG1shiftOLR(G1H8(11),4,8)
  call Hloop_UV_W(ntryL,G1H8(15),17,ex3(:),4,G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(5),mass5set(:,1),  & 
G1H8(15),G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),8)
  call HG1shiftOLR(G1H8(29),8,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(6),mass5set(:,1),  & 
G1H8(34),G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(39),8)
  call HG1shiftOLR(G1H8(35),2,8)
  call Hloop_UV_W(ntryL,G1H8(16),17,ex3(:),4,G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_UV_W(ntryL,G1H8(17),17,ex4(:),8,G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(7),mass5set(:,1),  & 
G1H8(16),G1H8(17),G1H8(40),G1H8(41),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(17),4,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(8),mass5set(:,1),  & 
G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(49),8)
  call HG1shiftOLR(G1H8(45),2,8)
  call Hloop_UV_W(ntryL,G1H8(18),17,ex4(:),8,G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(29),n2h4(13))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(20),-8,ex4(:),8,G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
call signflip_OLR(G2H4(30))
  call Hloop_VQ_A(ntryL,G1H8(22),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(31),n2h4(14))
  call Hloop_VQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(32),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(33),n2h4(16))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(34),n2h4(17))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(2),-8,ex4(:),8,G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
call signflip_OLR(G2H4(35))
  call Hloop_VA_Q(ntryL,G1H8(25),ex2(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(36),n2h4(18))
  call Hloop_VA_Q(ntryL,G1H8(26),ex2(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(37),n2h4(19))
  call Hloop_VA_Q(ntryL,G1H8(27),ex2(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(38),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H8(4),ex3(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(39),n2h4(21))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(5),-8,ex4(:),8,G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
call signflip_OLR(G2H4(40))
  call Hloop_AV_Q(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(41),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H8(8),ex3(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(42),n2h4(23))
  call Hloop_AV_Q(ntryL,G1H8(9),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(43),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H8(10),ex4(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(44),n2h4(25))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(11),-4,ex3(:),4,G2H4(45),m3h2x4(:,45),heltab2x8(:,:,45))
call signflip_OLR(G2H4(45))
  call Hloop_AV_Q(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(46),n2h4(26))
  call Hloop_AV_Q(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(47),n2h4(27))
  call Hloop_AV_Q(ntryL,G1H8(28),ex4(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(48),n2h4(28))
  call Hloop_QV_A(ntryL,G1H8(15),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(49),n2h4(29))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(29),-8,ex4(:),8,G2H4(50),m3h2x4(:,50),heltab2x8(:,:,50))
call signflip_OLR(G2H4(50))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(51),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(32),ex3(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(52),n2h4(31))
  call Hloop_QV_A(ntryL,G1H8(33),ex3(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(53),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(34),ex3(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(54),n2h4(33))
call HGT_raise_alpha_OLR(G1H8(35),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(35),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_QV_A(ntryL,G1H8(37),ex3(:),G1H4(2),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(55),n2h4(34))
  call Hloop_QV_A(ntryL,G1H8(38),ex3(:),G1H4(2),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(56),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(39),ex3(:),G1H4(2),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(57),n2h4(36))
  call Hloop_QV_A(ntryL,G1H8(16),ex4(:),G1H4(2),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(58),n2h4(37))
call HGT_raise_alpha_OLR(G1H8(17),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(17),-4,ex3(:),4,G2H4(59),m3h2x4(:,60),heltab2x8(:,:,60))
call signflip_OLR(G2H4(59))
  call Hloop_QV_A(ntryL,G1H8(41),ex4(:),G1H4(2),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(60),n2h4(38))
  call Hloop_QV_A(ntryL,G1H8(42),ex4(:),G1H4(2),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(61),n2h4(39))
  call Hloop_QV_A(ntryL,G1H8(43),ex4(:),G1H4(2),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(62),n2h4(40))
  call Hloop_QV_A(ntryL,G1H8(44),ex4(:),G1H4(2),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(2),25,0,G2H4(63),n2h4(41))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(45),ex2(:),G1H4(2),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_QV_A(ntryL,G1H8(47),ex4(:),G1H4(3),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(3),25,0,G2H4(64),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(48),ex4(:),G1H4(3),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(3),25,0,G2H4(65),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(3),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(3),25,0,G2H4(66),n2h4(44))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(9),mass5set(:,1),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(9),mass5set(:,4),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(9),mass5set(:,5),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(9),mass5set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(2),mass5set(:,1),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(2),mass5set(:,2),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,3),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(10),mass5set(:,1),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(10),mass5set(:,4),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),4,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(10),mass5set(:,5),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(10),mass5set(:,1),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(11),mass5set(:,1),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(11),mass5set(:,4),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(11),mass5set(:,5),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(11),mass5set(:,1),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
  call HG1shiftOLR(G1H4(106),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(12),mass5set(:,1),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
  call HG1shiftOLR(G1H4(112),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(12),mass5set(:,4),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(118),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(12),mass5set(:,5),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(124),4,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(12),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),4,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(3),mass5set(:,1),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
  call HG1shiftOLR(G1H4(136),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(4),mass5set(:,1),  & 
G1H4(141),G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
  call HG1shiftOLR(G1H4(142),4,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(5),mass5set(:,1),  & 
G1H4(147),G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),4)
  call HG1shiftOLR(G1H4(148),8,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(6),mass5set(:,1),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
  call HG1shiftOLR(G1H4(154),2,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(7),mass5set(:,1),  & 
G1H4(159),G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(160),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(8),mass5set(:,1),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(166),2,4)
  call Hloop_QA_V(ntryL,G2H4(29),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(32),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(33),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(34),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(37),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(38),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(39),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(42),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(43),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(44),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(47),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(48),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(49),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(52),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(53),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(6),mass5set(:,1),  & 
G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
  call HG1shiftOLR(G1H4(172),2,4)
  call Hotf_4pt_reduction(G2H4(56),RedSet_4(1),mass4set(:,1),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),4)
  call HG1shiftOLR(G1H4(178),2,4)
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(2),mass4set(:,1),  & 
G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(183),10,4)
  call Hloop_QA_V(ntryL,G2H4(58),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(61),ex2(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(62),ex2(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(8),mass5set(:,1),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),2,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(1),mass4set(:,1),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),4)
  call HG1shiftOLR(G1H4(194),2,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(3),mass4set(:,1),  & 
G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),4)
  call HG1shiftOLR(G1H4(199),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(182),[G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(192)])
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(19),n2h2(1))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(4),-8,0,G2H4(1),n2h4(45))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(21),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(8),ex2(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(22),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),ngZd,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(23),n2h2(4))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-8,0,G2H4(2),n2h4(46))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_ZA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),ngZd,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(25),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(14),ex2(:),G1H2(1),ngZd,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(26),n2h2(6))
  call Hloop_WA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(27),n2h2(7))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-8,0,G2H4(3),n2h4(47))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_WA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(29),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(20),ex2(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(30),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(21),ex3(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(31),n2h2(10))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-8,0,G2H4(4),n2h4(48))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QV_A(ntryL,G1H4(25),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(33),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(26),ex3(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(34),n2h2(12))
  call Hloop_QV_A(ntryL,G1H4(27),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(35),n2h2(13))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(28),-8,0,G2H4(5),n2h4(49))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QV_A(ntryL,G1H4(31),ex3(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(37),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(32),ex3(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(38),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(33),ex3(:),G1H2(1),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(39),n2h2(16))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-8,0,G2H4(6),n2h4(50))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QV_A(ntryL,G1H4(37),ex3(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(41),n2h2(17))
  call Hloop_QV_A(ntryL,G1H4(38),ex3(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(42),n2h2(18))
  call Hloop_UV_W(ntryL,G1H4(39),19,ex3(:),4,G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
call HGT_raise_alpha_OLR(G1H4(40),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(40),-8,ex4(:),8,G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
call signflip_OLR(G2H2(44))
  call Hloop_UV_W(ntryL,G1H4(43),19,ex3(:),4,G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_UV_W(ntryL,G1H4(44),19,ex3(:),4,G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(45),ex1(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(47),n2h2(19))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(46),-8,0,G2H4(7),n2h4(52))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(49),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(50),ex1(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(50),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(51),ex1(:),G1H2(1),ngZd,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(51),n2h2(22))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-8,0,G2H4(8),n2h4(53))
  call Hloop_AV_Q(ntryL,G2H4(8),ex4(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_ZQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),ngZd,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(53),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(56),ex1(:),G1H2(1),ngZd,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(54),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(57),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(55),n2h2(25))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-8,0,G2H4(9),n2h4(54))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_WQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(57),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(62),ex1(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(58),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(63),ex4(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(59),n2h2(28))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(64),-4,0,G2H4(10),n2h4(55))
  call Hloop_AV_Q(ntryL,G2H4(10),ex3(:),G2H2(60),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QV_A(ntryL,G1H4(67),ex4(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(61),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(68),ex4(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(62),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(69),ex4(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(63),n2h2(31))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-4,0,G2H4(11),n2h4(56))
  call Hloop_AV_Q(ntryL,G2H4(11),ex3(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QV_A(ntryL,G1H4(73),ex4(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(65),n2h2(32))
  call Hloop_QV_A(ntryL,G1H4(74),ex4(:),G1H2(1),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(66),n2h2(33))
  call Hloop_QV_A(ntryL,G1H4(75),ex4(:),G1H2(1),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(67),n2h2(34))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(76),-4,0,G2H4(12),n2h4(57))
  call Hloop_AV_Q(ntryL,G2H4(12),ex3(:),G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QV_A(ntryL,G1H4(79),ex4(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(69),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(80),ex4(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(70),n2h2(36))
  call Hloop_UV_W(ntryL,G1H4(81),19,ex4(:),8,G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(82),-4,ex3(:),4,G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
call signflip_OLR(G2H2(72))
  call Hloop_UV_W(ntryL,G1H4(85),19,ex4(:),8,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_UV_W(ntryL,G1H4(86),19,ex4(:),8,G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AV_Q(ntryL,G1H4(87),ex3(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(75),n2h2(37))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-8,0,G2H4(13),n2h4(59))
  call Hloop_QV_A(ntryL,G2H4(13),ex4(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_AV_Q(ntryL,G1H4(91),ex3(:),G1H2(1),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(77),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H4(92),ex3(:),G1H2(1),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(78),n2h2(39))
  call Hloop_AV_Q(ntryL,G1H4(93),ex3(:),G1H2(1),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(79),n2h2(40))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(94),-8,0,G2H4(14),n2h4(60))
  call Hloop_QV_A(ntryL,G2H4(14),ex4(:),G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AV_Q(ntryL,G1H4(97),ex3(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(81),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H4(98),ex3(:),G1H2(1),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(82),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H4(99),ex3(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(83),n2h2(43))
call HGT_OLR(G1H4(100),1,1,4)
call HGT_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(100),-8,0,G2H4(15),n2h4(61))
  call Hloop_QV_A(ntryL,G2H4(15),ex4(:),G2H2(84),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_AV_Q(ntryL,G1H4(103),ex3(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(85),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(104),ex3(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(86),n2h2(45))
  call Hloop_UV_W(ntryL,G1H4(105),19,ex3(:),4,G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
call HGT_raise_alpha_OLR(G1H4(106),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(106),-8,ex4(:),8,G2H2(88),m3h2x2(:,88),heltab2x4(:,:,88))
call signflip_OLR(G2H2(88))
  call Hloop_UV_W(ntryL,G1H4(109),19,ex3(:),4,G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UV_W(ntryL,G1H4(110),19,ex3(:),4,G2H2(90),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_AV_Q(ntryL,G1H4(111),ex4(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(91),n2h2(46))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(112),-4,0,G2H4(16),n2h4(63))
  call Hloop_QV_A(ntryL,G2H4(16),ex3(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AV_Q(ntryL,G1H4(115),ex4(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(93),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H4(116),ex4(:),G1H2(1),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(94),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H4(117),ex4(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(95),n2h2(49))
call HGT_OLR(G1H4(118),1,1,4)
call HGT_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(118),-4,0,G2H4(17),n2h4(64))
  call Hloop_QV_A(ntryL,G2H4(17),ex3(:),G2H2(96),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_AV_Q(ntryL,G1H4(121),ex4(:),G1H2(1),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(97),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(122),ex4(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(98),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H4(123),ex4(:),G1H2(1),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(99),n2h2(52))
call HGT_OLR(G1H4(124),1,1,4)
call HGT_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(124),-4,0,G2H4(18),n2h4(65))
  call Hloop_QV_A(ntryL,G2H4(18),ex3(:),G2H2(100),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AV_Q(ntryL,G1H4(127),ex4(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(101),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H4(128),ex4(:),G1H2(1),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(102),n2h2(54))
  call Hloop_UV_W(ntryL,G1H4(129),19,ex4(:),8,G2H2(103),m3h2x2(:,103),heltab2x4(:,:,103))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(130),-4,ex3(:),4,G2H2(104),m3h2x2(:,104),heltab2x4(:,:,104))
call signflip_OLR(G2H2(104))
  call Hloop_UV_W(ntryL,G1H4(133),19,ex4(:),8,G2H2(105),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_UV_W(ntryL,G1H4(134),19,ex4(:),8,G2H2(106),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_VQ_A(ntryL,G1H4(135),ex1(:),G1H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(107),n2h2(55))
call HGT_OLR(G1H4(136),1,1,4)
call HGT_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(136),-8,0,G2H4(19),n2h4(67))
  call Hloop_AV_Q(ntryL,G2H4(19),ex4(:),G2H2(108),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_VQ_A(ntryL,G1H4(139),ex1(:),G1H2(1),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(109),n2h2(56))
  call Hloop_VQ_A(ntryL,G1H4(140),ex1(:),G1H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(110),n2h2(57))
  call Hloop_VQ_A(ntryL,G1H4(141),ex1(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(111),n2h2(58))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(142),-4,0,G2H4(20),n2h4(68))
  call Hloop_AV_Q(ntryL,G2H4(20),ex3(:),G2H2(112),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_VQ_A(ntryL,G1H4(145),ex1(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(113),n2h2(59))
  call Hloop_VQ_A(ntryL,G1H4(146),ex1(:),G1H2(1),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(1),27,0,G2H2(114),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(147),ex2(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(115),n2h2(61))
call HGT_OLR(G1H4(148),1,1,4)
call HGT_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(148),-8,0,G2H4(21),n2h4(69))
  call Hloop_QV_A(ntryL,G2H4(21),ex4(:),G2H2(116),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_VA_Q(ntryL,G1H4(151),ex2(:),G1H2(1),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(117),n2h2(62))
  call Hloop_VA_Q(ntryL,G1H4(152),ex2(:),G1H2(1),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(118),n2h2(63))
  call Hloop_UV_W(ntryL,G1H4(153),21,ex4(:),8,G2H2(119),m3h2x2(:,119),heltab2x4(:,:,119))
call HGT_OLR(G1H4(154),1,1,4)
call HGT_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(154),-2,0,G2H4(22),n2h4(70))
  call Hloop_QA_V(ntryL,G2H4(22),ex2(:),G2H2(120),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_UV_W(ntryL,G1H4(157),21,ex4(:),8,G2H2(121),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_UV_W(ntryL,G1H4(158),21,ex4(:),8,G2H2(122),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_VA_Q(ntryL,G1H4(159),ex2(:),G1H2(1),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(123),n2h2(64))
call HGT_OLR(G1H4(160),1,1,4)
call HGT_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(160),-4,0,G2H4(23),n2h4(71))
  call Hloop_QV_A(ntryL,G2H4(23),ex3(:),G2H2(124),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_VA_Q(ntryL,G1H4(163),ex2(:),G1H2(1),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(125),n2h2(65))
  call Hloop_VA_Q(ntryL,G1H4(164),ex2(:),G1H2(1),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(126),n2h2(66))
  call Hloop_UV_W(ntryL,G1H4(165),25,ex3(:),4,G2H2(127),m3h2x2(:,127),heltab2x4(:,:,127))
call HGT_OLR(G1H4(166),1,1,4)
call HGT_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(166),-2,0,G2H4(24),n2h4(72))
  call Hloop_QA_V(ntryL,G2H4(24),ex2(:),G2H2(128),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_UV_W(ntryL,G1H4(169),25,ex3(:),4,G2H2(129),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_UV_W(ntryL,G1H4(170),25,ex3(:),4,G2H2(130),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_QV_A(ntryL,G1H4(171),ex4(:),G1H2(1),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(131),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(172),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(172),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(172),ex2(:),G1H2(1),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_QV_A(ntryL,G1H4(177),ex4(:),G1H2(2),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(132),n2h2(68))
  call Hloop_QV_A(ntryL,G1H4(182),ex4(:),G1H2(2),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(133),n2h2(69))
call HGT_raise_alpha_OLR(G1H4(178),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(178),ex2(:),G1H2(2),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_QV_A(ntryL,G1H4(181),ex4(:),G1H2(3),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(3),29,0,G2H2(134),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(183),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(183),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(183),ex2(:),G1H2(3),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_QV_A(ntryL,G1H4(186),ex4(:),G1H2(4),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(135),n2h2(71))
  call Hloop_QV_A(ntryL,G1H4(187),ex3(:),G1H2(4),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(136),n2h2(72))
call HGT_raise_alpha_OLR(G1H4(188),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(188),ex2(:),G1H2(4),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_QV_A(ntryL,G1H4(193),ex3(:),G1H2(5),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(137),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(198),ex3(:),G1H2(5),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(138),n2h2(74))
call HGT_raise_alpha_OLR(G1H4(194),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(194),ex2(:),G1H2(5),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_QV_A(ntryL,G1H4(197),ex3(:),G1H2(6),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(139),n2h2(75))
call HGT_raise_alpha_OLR(G1H4(199),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(199),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(199),ex2(:),G1H2(6),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_QV_A(ntryL,G1H4(202),ex3(:),G1H2(7),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(140),n2h2(76))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(14),10,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
  call HG1shiftOLR(G1H2(19),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(5),mass4set(:,1),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(25),9,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(3),mass5set(:,1),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(6),mass4set(:,1),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(36),9,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(41),4,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(7),mass4set(:,1),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(47),5,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(5),mass5set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(2),mass4set(:,1),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(58),10,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(7),mass5set(:,1),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),2)
  call HG1shiftOLR(G1H2(63),4,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(3),mass4set(:,1),  & 
G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(69),6,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(1),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(4),mass4set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(80),10,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(1),mass5set(:,2),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(85),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(4),mass4set(:,2),  & 
G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(91),10,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(1),mass5set(:,3),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(96),8,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(4),mass4set(:,3),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),2)
  call HG1shiftOLR(G1H2(102),10,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(9),mass5set(:,1),  & 
G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(107),8,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(8),mass4set(:,1),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(113),12,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(9),mass5set(:,4),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(118),8,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(8),mass4set(:,4),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(124),12,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(9),mass5set(:,5),  & 
G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(129),8,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(8),mass4set(:,5),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(135),12,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(9),mass5set(:,1),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(8),mass4set(:,1),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(146),12,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(2),mass5set(:,1),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(151),8,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(5),mass4set(:,1),  & 
G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),2)
  call HG1shiftOLR(G1H2(157),9,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(2),mass5set(:,2),  & 
G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(162),8,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(5),mass4set(:,2),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),2)
  call HG1shiftOLR(G1H2(168),9,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(2),mass5set(:,3),  & 
G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),2)
  call HG1shiftOLR(G1H2(173),8,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(5),mass4set(:,3),  & 
G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(179),9,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(10),mass5set(:,1),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(184),4,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(8),mass4set(:,1),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(190),12,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(10),mass5set(:,4),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(195),4,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(8),mass4set(:,4),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(201),12,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(10),mass5set(:,5),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(8),mass4set(:,5),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(212),12,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(10),mass5set(:,1),  & 
G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),2)
  call HG1shiftOLR(G1H2(217),4,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(8),mass4set(:,1),  & 
G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(223),12,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(11),mass5set(:,1),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(9),mass4set(:,1),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),2)
  call HG1shiftOLR(G1H2(234),12,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(11),mass5set(:,4),  & 
G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),2)
  call HG1shiftOLR(G1H2(239),8,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(9),mass4set(:,4),  & 
G1H2(244),G1H2(245),G1H2(246),G1H2(247),G1H2(248),2)
  call HG1shiftOLR(G1H2(245),12,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(11),mass5set(:,5),  & 
G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),G1H2(254),2)
  call HG1shiftOLR(G1H2(250),8,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(9),mass4set(:,5),  & 
G1H2(255),G1H2(256),G1H2(257),G1H2(258),G1H2(259),2)
  call HG1shiftOLR(G1H2(256),12,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(11),mass5set(:,1),  & 
G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),G1H2(265),2)
  call HG1shiftOLR(G1H2(261),8,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(9),mass4set(:,1),  & 
G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(267),12,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(12),mass5set(:,1),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),4,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(9),mass4set(:,1),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),2)
  call HG1shiftOLR(G1H2(278),12,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(12),mass5set(:,4),  & 
G1H2(282),G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),2)
  call HG1shiftOLR(G1H2(283),4,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(9),mass4set(:,4),  & 
G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(289),12,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(12),mass5set(:,5),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(294),4,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(9),mass4set(:,5),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),2)
  call HG1shiftOLR(G1H2(300),12,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(12),mass5set(:,1),  & 
G1H2(304),G1H2(305),G1H2(306),G1H2(307),G1H2(308),G1H2(309),2)
  call HG1shiftOLR(G1H2(305),4,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(9),mass4set(:,1),  & 
G1H2(310),G1H2(311),G1H2(312),G1H2(313),G1H2(314),2)
  call HG1shiftOLR(G1H2(311),12,2)
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(3),mass5set(:,1),  & 
G1H2(315),G1H2(316),G1H2(317),G1H2(318),G1H2(319),G1H2(320),2)
  call HG1shiftOLR(G1H2(316),8,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(6),mass4set(:,1),  & 
G1H2(321),G1H2(322),G1H2(323),G1H2(324),G1H2(325),2)
  call HG1shiftOLR(G1H2(322),9,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(4),mass5set(:,1),  & 
G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),2)
  call HG1shiftOLR(G1H2(327),4,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(7),mass4set(:,1),  & 
G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(333),5,2)
  call Hotf_5pt_reduction(G2H2(115),RedSet_5(5),mass5set(:,1),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),8,2)
  call Hotf_4pt_reduction(G2H2(118),RedSet_4(2),mass4set(:,1),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),2)
  call HG1shiftOLR(G1H2(344),10,2)
  call Hotf_5pt_reduction(G2H2(119),RedSet_5(6),mass5set(:,1),  & 
G1H2(348),G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),2)
  call HG1shiftOLR(G1H2(349),2,2)
  call Hotf_4pt_reduction(G2H2(122),RedSet_4(2),mass4set(:,1),  & 
G1H2(354),G1H2(355),G1H2(356),G1H2(357),G1H2(358),2)
  call HG1shiftOLR(G1H2(355),10,2)
  call Hotf_5pt_reduction(G2H2(123),RedSet_5(7),mass5set(:,1),  & 
G1H2(359),G1H2(360),G1H2(361),G1H2(362),G1H2(363),G1H2(364),2)
  call HG1shiftOLR(G1H2(360),4,2)
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(3),mass4set(:,1),  & 
G1H2(365),G1H2(366),G1H2(367),G1H2(368),G1H2(369),2)
  call HG1shiftOLR(G1H2(366),6,2)
  call Hotf_5pt_reduction(G2H2(127),RedSet_5(8),mass5set(:,1),  & 
G1H2(370),G1H2(371),G1H2(372),G1H2(373),G1H2(374),G1H2(375),2)
  call HG1shiftOLR(G1H2(371),2,2)
  call Hotf_4pt_reduction(G2H2(130),RedSet_4(3),mass4set(:,1),  & 
G1H2(376),G1H2(377),G1H2(378),G1H2(379),G1H2(380),2)
  call HG1shiftOLR(G1H2(377),6,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(131),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(133),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(136),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(138),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(68),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(134),[G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(156),[G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(178),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(200),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(211),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(222),[G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(233),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(244),[G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(255),[G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(266),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(277),[G1H2(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(288),[G1H2(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(310),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(321),[G1H2(320)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(332),[G1H2(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(343),[G1H2(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(354),[G1H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(365),[G1H2(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(376),[G1H2(375)])
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(7),23,ex4(:),8,G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(8),0,ex4(:),8,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(13),23,ex4(:),8,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(14),2,ex4(:),8,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),23,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),0,ex4(:),8,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(24),23,ex4(:),8,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(25),1,ex4(:),8,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(29),23,ex4(:),8,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(30),0,ex4(:),8,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),23,ex4(:),8,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(36),1,ex4(:),8,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(40),27,ex3(:),4,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(41),0,ex3(:),4,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(46),27,ex3(:),4,G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(47),1,ex3(:),4,G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(51),23,ex4(:),8,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(52),0,ex4(:),8,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(57),23,ex4(:),8,G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(58),2,ex4(:),8,G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(62),27,ex3(:),4,G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(63),0,ex3(:),4,G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(68),27,ex3(:),4,G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(69),2,ex3(:),4,G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hloop_AV_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(32),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(34),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(36),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(40),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(106),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(42),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(44),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(46),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(48),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(50),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(52),n2h1(36))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(139),23,ex4(:),8,G2tensor(53),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(140),0,ex4(:),8,G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(145),23,ex4(:),8,G2tensor(55),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(146),4,ex4(:),8,G2tensor(56),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hloop_QV_A(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(58),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(60),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(62),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(64),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(172),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(66),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(179),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(68),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(183),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(189),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(72),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(194),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(195),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(74),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(200),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(201),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(76),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(78),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(80),n2h1(62))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(216),27,ex3(:),4,G2tensor(81),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(217),0,ex3(:),4,G2tensor(82),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(222),27,ex3(:),4,G2tensor(83),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(223),8,ex3(:),4,G2tensor(84),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hloop_AV_Q(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(86),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(88),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(238),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(239),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(90),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(244),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(92),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(249),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(250),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(94),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(255),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(256),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(96),n2h1(76))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(260),23,ex4(:),8,G2tensor(97),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(261),0,ex4(:),8,G2tensor(98),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(266),23,ex4(:),8,G2tensor(99),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(267),4,ex4(:),8,G2tensor(100),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hloop_AV_Q(ntryL,G1H2(271),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(272),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(102),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(277),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(278),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(104),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(282),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(283),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(106),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(288),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(289),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(108),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(293),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(294),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(110),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(299),ex3(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(300),ex3(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(112),n2h1(90))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(304),27,ex3(:),4,G2tensor(113),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(305),0,ex3(:),4,G2tensor(114),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(310),27,ex3(:),4,G2tensor(115),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(311),8,ex3(:),4,G2tensor(116),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hloop_QV_A(ntryL,G1H2(315),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(316),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(118),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(321),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(322),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(120),n2h1(96))
  call Hloop_QV_A(ntryL,G1H2(326),ex3(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(327),ex3(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(122),n2h1(98))
  call Hloop_QV_A(ntryL,G1H2(332),ex3(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(99))
  call Hloop_QV_A(ntryL,G1H2(333),ex3(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(124),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(337),ex4(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(338),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(126),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(343),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(127),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H2(344),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(128),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H2(348),ex2(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H2(349),ex2(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(130),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H2(354),ex2(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(355),ex2(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(132),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(359),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(360),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(134),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(365),ex3(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(366),ex3(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(136),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H2(370),ex2(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H2(371),ex2(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(138),n2h1(114))
  call Hloop_VA_Q(ntryL,G1H2(376),ex2(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(139),n2h1(115))
  call Hloop_VA_Q(ntryL,G1H2(377),ex2(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(140),n2h1(116))
  call ol_merge_tensors(G2tensor(129),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(17)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(25)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(41)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(69)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(85)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(101)])
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(6),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(8),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(4),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(5),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(7),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(1),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(1),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(9),mass5set(:,4),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(9),mass5set(:,5),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(2),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(2),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(10),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(10),mass5set(:,4),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(10),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(11),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(11),mass5set(:,4),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(11),mass5set(:,5),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(12),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(12),mass5set(:,4),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(12),mass5set(:,5),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (c(10)*M(8,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(10)*M(12,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(2),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(10)*(-M(8,:)%j+M(12,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(10)*M(4,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(5),m4h2x2x8(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(10)*(-M(2,:)%j+M(4,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(16,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(16,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(8),m4h2x2x8(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(17)*(-M(20,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(10)*M(4,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(10)*M(10,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(11),m4h2x2x8(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (c(10)*(-M(4,:)%j+M(10,:)%j)+c(8)*(M(20,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (-(c(10)*M(8,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(14),m4h2x2x8(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(10)*(-M(6,:)%j+M(8,:)%j)+c(8)*(M(20,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(17)*(-M(14,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(17),m4h2x2x8(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(17)*(M(20,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(18),m4h2x2x8(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(8)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,44),heltab2x32(:,:,44))
  Gcoeff(:)%j = (c(10)*(-M(2,:)%j+M(6,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,45),heltab2x32(:,:,45))
  Gcoeff(:)%j = (c(10)*M(10,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,46),heltab2x32(:,:,46))
  Gcoeff(:)%j = (c(10)*M(12,:)%j+c(8)*(M(14,:)%j+M(16,:)%j+M(18,:)%j-M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,47),heltab2x32(:,:,47))
  Gcoeff(:)%j = (c(10)*(-M(10,:)%j+M(12,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(17)*(-M(16,:)%j-M(18,:)%j+M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(4),n2h16(31))
  Gcoeff(:)%j = (c(17)*(-M(16,:)%j-M(18,:)%j+M(20,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(2),n2h16(32))
  Gcoeff(:)%j = (c(17)*(M(20,:)%j-M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(33))
  Gcoeff(:)%j = (c(31)*M(19,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(34))
  Gcoeff(:)%j = (c(30)*M(19,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(35))
  Gcoeff(:)%j = (c(31)*M(21,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(7),n2h16(36))
  Gcoeff(:)%j = (c(30)*M(21,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(8),n2h16(37))
  Gcoeff(:)%j = (-(c(30)*M(19,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(10),n2h16(38))
  Gcoeff(:)%j = (-(c(29)*M(19,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(39))
  Gcoeff(:)%j = (-(c(30)*M(21,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(12),n2h16(40))
  Gcoeff(:)%j = (-(c(29)*M(21,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(41))
  Gcoeff(:)%j = (-(c(33)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,3,8,4],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(15),n2h16(42))
  Gcoeff(:)%j = (-(c(32)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(19),n2h16(43))
  Gcoeff(:)%j = (-(c(33)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,3,8,4],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(17),n2h16(44))
  Gcoeff(:)%j = (-(c(32)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(45))
  Gcoeff(:)%j = (-(c(33)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,3,8,4],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(20),n2h16(46))
  Gcoeff(:)%j = (-(c(32)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(24),n2h16(47))
  Gcoeff(:)%j = (-(c(33)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,3,8,4],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(22),n2h16(48))
  Gcoeff(:)%j = (-(c(32)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(49))
  Gcoeff(:)%j = (-(c(41)*M(10,:)%j)+c(40)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(25),n2h16(50))
  Gcoeff(:)%j = (-(c(39)*M(10,:)%j)+c(38)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(29),n2h16(51))
  Gcoeff(:)%j = (-(c(41)*M(6,:)%j)+c(40)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(27),n2h16(52))
  Gcoeff(:)%j = (-(c(39)*M(6,:)%j)+c(38)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(28),n2h16(53))
  Gcoeff(:)%j = (-(c(41)*M(10,:)%j)+c(40)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(30),n2h16(54))
  Gcoeff(:)%j = (-(c(39)*M(10,:)%j)+c(38)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(55))
  Gcoeff(:)%j = (-(c(41)*M(6,:)%j)+c(40)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(32),n2h16(56))
  Gcoeff(:)%j = (-(c(39)*M(6,:)%j)+c(38)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(57))
  Gcoeff(:)%j = (c(20)*(-M(6,:)%j-M(10,:)%j)+c(18)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j)+c(17)*(M(20,:)%j+M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(20)*(-M(6,:)%j-M(10,:)%j)+c(18)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j)+c(17)*(M(20,:)%j+M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(35),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (c(20)*(M(6,:)%j+M(10,:)%j)+c(18)*(M(14,:)%j+M(16,:)%j+M(18,:)%j)+c(17)*(-M(20,:)%j-M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (c(31)*M(19,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(37),n2h16(58))
  Gcoeff(:)%j = (c(30)*M(19,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(38),n2h16(59))
  Gcoeff(:)%j = (c(31)*M(21,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(39),n2h16(60))
  Gcoeff(:)%j = (c(30)*M(21,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(40),n2h16(61))
  Gcoeff(:)%j = (-(c(30)*M(19,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(41),n2h16(62))
  Gcoeff(:)%j = (-(c(29)*M(19,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(63))
  Gcoeff(:)%j = (-(c(30)*M(21,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(43),n2h16(64))
  Gcoeff(:)%j = (-(c(29)*M(21,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(65))
  Gcoeff(:)%j = (-(c(33)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,3,4,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(45),n2h16(66))
  Gcoeff(:)%j = (-(c(32)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(67))
  Gcoeff(:)%j = (-(c(33)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,3,4,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(47),n2h16(68))
  Gcoeff(:)%j = (-(c(32)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(69))
  Gcoeff(:)%j = (-(c(33)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,3,4,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(49),n2h16(70))
  Gcoeff(:)%j = (-(c(32)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(71))
  Gcoeff(:)%j = (-(c(33)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,3,4,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(51),n2h16(72))
  Gcoeff(:)%j = (-(c(32)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(73))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(40)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(53),n2h16(74))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)+c(38)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(54),n2h16(75))
  Gcoeff(:)%j = (-(c(41)*M(12,:)%j)+c(40)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(55),n2h16(76))
  Gcoeff(:)%j = (-(c(39)*M(12,:)%j)+c(38)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(77))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(40)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(57),n2h16(78))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)+c(38)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(79))
  Gcoeff(:)%j = (-(c(41)*M(12,:)%j)+c(40)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(59),n2h16(80))
  Gcoeff(:)%j = (-(c(39)*M(12,:)%j)+c(38)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(81))
  Gcoeff(:)%j = (c(20)*(-M(2,:)%j-M(12,:)%j)+c(18)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j)+c(17)*(M(20,:)%j+M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(61),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(20)*(-M(2,:)%j-M(12,:)%j)+c(18)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j)+c(17)*(M(20,:)%j+M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,104),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(20)*(M(2,:)%j+M(12,:)%j)+c(18)*(M(14,:)%j+M(16,:)%j+M(18,:)%j)+c(17)*(-M(20,:)%j-M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,105),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(31)*M(21,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(64),n2h16(82))
  Gcoeff(:)%j = (c(30)*M(21,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(83))
  Gcoeff(:)%j = (c(31)*M(19,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(66),n2h16(84))
  Gcoeff(:)%j = (c(30)*M(19,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(85))
  Gcoeff(:)%j = (-(c(30)*M(21,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(68),n2h16(86))
  Gcoeff(:)%j = (-(c(29)*M(21,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(69),n2h16(87))
  Gcoeff(:)%j = (-(c(30)*M(19,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(70),n2h16(88))
  Gcoeff(:)%j = (-(c(29)*M(19,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(71),n2h16(89))
  Gcoeff(:)%j = (-(c(33)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,4,3,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(72),n2h16(90))
  Gcoeff(:)%j = (-(c(32)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(73),n2h16(91))
  Gcoeff(:)%j = (-(c(33)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,4,3,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(74),n2h16(92))
  Gcoeff(:)%j = (-(c(32)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(93))
  Gcoeff(:)%j = (-(c(33)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,4,3,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(76),n2h16(94))
  Gcoeff(:)%j = (-(c(32)*M(21,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(77),n2h16(95))
  Gcoeff(:)%j = (-(c(33)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,4,3,8],[0,0,0,0],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(78),n2h16(96))
  Gcoeff(:)%j = (-(c(32)*M(19,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(79),n2h16(97))
  Gcoeff(:)%j = (-(c(41)*M(4,:)%j)+c(40)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(80),n2h16(98))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)+c(38)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(99))
  Gcoeff(:)%j = (-(c(41)*M(8,:)%j)+c(40)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(82),n2h16(100))
  Gcoeff(:)%j = (-(c(39)*M(8,:)%j)+c(38)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(83),n2h16(101))
  Gcoeff(:)%j = (-(c(41)*M(4,:)%j)+c(40)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(84),n2h16(102))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)+c(38)*M(22,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(85),n2h16(103))
  Gcoeff(:)%j = (-(c(41)*M(8,:)%j)+c(40)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(86),n2h16(104))
  Gcoeff(:)%j = (-(c(39)*M(8,:)%j)+c(38)*M(20,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(87),n2h16(105))
  Gcoeff(:)%j = (c(20)*(-M(4,:)%j-M(8,:)%j)+c(18)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j)+c(17)*(M(20,:)%j+M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,130),heltab2x32(:,:,130))
  Gcoeff(:)%j = (c(20)*(-M(4,:)%j-M(8,:)%j)+c(18)*(-M(14,:)%j-M(16,:)%j-M(18,:)%j)+c(17)*(M(20,:)%j+M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(89),m3h2x16(:,131),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(20)*(M(4,:)%j+M(8,:)%j)+c(18)*(M(14,:)%j+M(16,:)%j+M(18,:)%j)+c(17)*(-M(20,:)%j-M(22,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,132),heltab2x32(:,:,132))
  Gcoeff(:)%j = (-(c(8)*M(18,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,2,8,5],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,133),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(8)*M(18,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,2,8,5],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(92),n2h16(106))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,5,2,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(93),n2h16(107))
  Gcoeff(:)%j = (c(4)*M(7,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,5,2,8],[0,nMZ,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(94),n2h16(108))
  Gcoeff(:)%j = (c(23)*M(7,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,5,2,8],[0,nMW,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(95),n2h16(109))
  Gcoeff(:)%j = (-(c(16)*M(8,:)%j)+c(17)*M(18,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,5,2,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(96),n2h16(110))
  Gcoeff(:)%j = (c(20)*M(8,:)%j+c(17)*M(18,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,5,2,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,139),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(3)*M(11,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,2,5,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(98),n2h16(111))
  Gcoeff(:)%j = (c(4)*M(11,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,2,5,8],[0,nMZ,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(99),n2h16(112))
  Gcoeff(:)%j = (c(23)*M(11,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,2,5,8],[0,nMW,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(100),n2h16(113))
  Gcoeff(:)%j = (-(c(16)*M(12,:)%j)+c(17)*M(18,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,2,5,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(101),n2h16(114))
  Gcoeff(:)%j = (c(20)*M(12,:)%j+c(17)*M(18,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,2,5,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,144),heltab2x32(:,:,144))
  Gcoeff(:)%j = (c(8)*M(18,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,1,8,6],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,145),heltab2x32(:,:,145))
  Gcoeff(:)%j = (-(c(8)*M(18,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,1,8,6],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(104),n2h16(115))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,6,1,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(105),n2h16(116))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,6,1,8],[0,nMZ,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(106),n2h16(117))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,6,1,8],[0,nMW,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(107),n2h16(118))
  Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(18,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,6,1,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(108),n2h16(119))
  Gcoeff(:)%j = (c(20)*M(4,:)%j+c(17)*M(18,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,6,1,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,151),heltab2x32(:,:,151))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,1,6,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(110),n2h16(120))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,1,6,8],[0,nMZ,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(111),n2h16(121))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,1,6,8],[0,nMW,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(112),n2h16(122))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(18,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,1,6,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(113),n2h16(123))
  Gcoeff(:)%j = (c(20)*M(2,:)%j+c(17)*M(18,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,1,6,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,156),heltab2x32(:,:,156))
  Gcoeff(:)%j = (-(c(8)*M(16,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,2,4,9],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,157),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(8)*M(16,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,2,4,9],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(116),n2h16(124))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,4,2,9],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(117),n2h16(125))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,4,2,9],[0,0,nMZ,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(118),n2h16(126))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,4,2,9],[0,0,nMW,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(119),n2h16(127))
  Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(16,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,4,2,9],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(120),n2h16(128))
  Gcoeff(:)%j = (c(20)*M(4,:)%j+c(17)*M(16,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,4,2,9],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,163),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(3)*M(9,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,2,9,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(122),n2h16(129))
  Gcoeff(:)%j = (c(4)*M(9,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,2,9,4],[0,nMZ,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(123),n2h16(130))
  Gcoeff(:)%j = (c(23)*M(9,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,2,9,4],[0,nMW,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(124),n2h16(131))
  Gcoeff(:)%j = (-(c(16)*M(10,:)%j)+c(17)*M(16,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,2,9,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,167),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(125),n2h16(132))
  Gcoeff(:)%j = (c(20)*M(10,:)%j+c(17)*M(16,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,2,9,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(8)*M(16,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,1,4,10],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (-(c(8)*M(16,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,1,4,10],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(128),n2h16(133))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,4,1,10],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(129),n2h16(134))
  Gcoeff(:)%j = (c(4)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,4,1,10],[0,0,nMZ,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(130),n2h16(135))
  Gcoeff(:)%j = (c(23)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,4,1,10],[0,0,nMW,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(131),n2h16(136))
  Gcoeff(:)%j = (-(c(16)*M(8,:)%j)+c(17)*M(16,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,4,1,10],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(132),n2h16(137))
  Gcoeff(:)%j = (c(20)*M(8,:)%j+c(17)*M(16,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,4,1,10],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(133),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (c(3)*M(5,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,1,10,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(134),n2h16(138))
  Gcoeff(:)%j = (c(4)*M(5,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,1,10,4],[0,nMZ,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(135),n2h16(139))
  Gcoeff(:)%j = (c(23)*M(5,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,1,10,4],[0,nMW,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(136),n2h16(140))
  Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(16,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,1,10,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(137),n2h16(141))
  Gcoeff(:)%j = (c(20)*M(6,:)%j+c(17)*M(16,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,1,10,4],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,180),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(5,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,1,2,12],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(139),n2h16(142))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(5,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,1,2,12],[0,nMZ,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,182),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(140),n2h16(143))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(5,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,1,2,12],[0,nMW,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(141),n2h16(144))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(6,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,1,2,12],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(142),n2h16(145))
  Gcoeff(:)%j = (c(10)*(-M(2,:)%j+M(6,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,1,2,12],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(143),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(11,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,2,1,12],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,186),heltab2x32(:,:,186))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(144),n2h16(146))
  Gcoeff(:)%j = (c(2)*(-M(9,:)%j+M(11,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,2,1,12],[0,nMZ,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(145),n2h16(147))
  Gcoeff(:)%j = (c(22)*(-M(9,:)%j+M(11,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,2,1,12],[0,nMW,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(146),n2h16(148))
  Gcoeff(:)%j = (c(7)*(M(10,:)%j-M(12,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,2,1,12],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(147),n2h16(149))
  Gcoeff(:)%j = (c(10)*(-M(10,:)%j+M(12,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,2,1,12],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,190),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(17)*(M(20,:)%j-M(22,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,1,12,2],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(149),n2h16(150))
  Gcoeff(:)%j = (c(17)*(-M(20,:)%j+M(22,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,1,12,2],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(150),m3h2x16(:,192),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(8)*M(14,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[17,4,2,8],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(19),m3h4x8(:,1),heltab2x32(:,:,193))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(18),n2h8(25))
  Gcoeff(:)%j = (-(c(8)*M(14,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[17,4,2,8],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(19),m3h4x8(:,2),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[17,2,4,8],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(20),m3h4x8(:,3),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,16),G0H8(21),ngZd,m3h4x8(:,4),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[17,2,4,8],[nMW,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,16),G0H8(22),m3h4x8(:,5),heltab2x32(:,:,197))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(14,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[17,2,4,8],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(23),m3h4x8(:,6),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(20)*M(2,:)%j+c(17)*M(14,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[17,2,4,8],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(24),m3h4x8(:,7),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G0H8(24),17,0,G1H8(19),n2h8(26))
  Gcoeff(:)%j = (c(3)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[17,2,8,4],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(24),m3h4x8(:,8),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(4)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,16),G0H8(25),ngZd,m3h4x8(:,9),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(23)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[17,2,8,4],[nMW,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,16),G0H8(26),m3h4x8(:,10),heltab2x32(:,:,202))
  Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(14,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[17,2,8,4],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(27),m3h4x8(:,11),heltab2x32(:,:,203))
  Gcoeff(:)%j = (c(20)*M(6,:)%j+c(17)*M(14,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[17,2,8,4],[0,0,0,0],4,1,wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(28),m3h4x8(:,12),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G0H8(28),17,0,G1H8(20),n2h8(27))
  Gcoeff(:)%j = (-(c(8)*M(14,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[18,4,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(28),m3h4x8(:,13),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G0H8(28),18,0,G1H8(22),n2h8(28))
  Gcoeff(:)%j = (c(8)*M(14,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[18,4,1,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(28),m3h4x8(:,14),heltab2x32(:,:,206))
  Gcoeff(:)%j = (c(3)*M(11,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[18,1,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(29),m3h4x8(:,15),heltab2x32(:,:,207))
  Gcoeff(:)%j = (c(4)*M(11,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,10),G0H8(30),ngZd,m3h4x8(:,16),heltab2x32(:,:,208))
  Gcoeff(:)%j = (c(23)*M(11,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[18,1,4,8],[nMW,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,10),G0H8(31),m3h4x8(:,17),heltab2x32(:,:,209))
  Gcoeff(:)%j = (-(c(16)*M(12,:)%j)+c(17)*M(14,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[18,1,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(32),m3h4x8(:,18),heltab2x32(:,:,210))
  Gcoeff(:)%j = (c(20)*M(12,:)%j+c(17)*M(14,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[18,1,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(33),m3h4x8(:,19),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G0H8(33),18,0,G1H8(23),n2h8(29))
  Gcoeff(:)%j = (c(3)*M(9,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[18,1,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(33),m3h4x8(:,20),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(4)*M(9,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,10),G0H8(34),ngZd,m3h4x8(:,21),heltab2x32(:,:,213))
  Gcoeff(:)%j = (c(23)*M(9,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[18,1,8,4],[nMW,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,10),G0H8(35),m3h4x8(:,22),heltab2x32(:,:,214))
  Gcoeff(:)%j = (-(c(16)*M(10,:)%j)+c(17)*M(14,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[18,1,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(36),m3h4x8(:,23),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(20)*M(10,:)%j+c(17)*M(14,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[18,1,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,24),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(24),n2h8(30))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[20,2,1,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,25),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(1),n2h8(31))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[20,2,1,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,26),heltab2x32(:,:,218))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(2),n2h8(32))
  Gcoeff(:)%j = (c(22)*(-M(3,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[20,2,1,8],[0,nMW,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,27),heltab2x32(:,:,219))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(25),n2h8(33))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(10,:)%j)+c(8)*(M(20,:)%j-M(22,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[20,2,1,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,28),heltab2x32(:,:,220))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(26),n2h8(34))
  Gcoeff(:)%j = (c(10)*(-M(4,:)%j+M(10,:)%j)+c(8)*(M(20,:)%j-M(22,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[20,2,1,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,3),20,G1H8(27),m3h4x8(:,29),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(7,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[20,1,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,30),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(4),n2h8(35))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(7,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[20,1,2,8],[0,nMZ,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,31),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(5),n2h8(36))
  Gcoeff(:)%j = (c(22)*(-M(5,:)%j+M(7,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[20,1,2,8],[0,nMW,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,32),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(7),n2h8(37))
  Gcoeff(:)%j = (c(7)*(M(6,:)%j-M(8,:)%j)+c(8)*(M(20,:)%j-M(22,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[20,1,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,33),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(8),n2h8(38))
  Gcoeff(:)%j = (c(10)*(-M(6,:)%j+M(8,:)%j)+c(8)*(M(20,:)%j-M(22,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[20,1,2,8],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,3),20,G1H8(9),m3h4x8(:,34),heltab2x32(:,:,226))
  Gcoeff(:)%j = (c(17)*(M(20,:)%j-M(22,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[20,1,8,2],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,3),20,G1H8(10),m3h4x8(:,35),heltab2x32(:,:,227))
  Gcoeff(:)%j = (c(17)*(-M(20,:)%j+M(22,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[20,1,8,2],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,36),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(11),n2h8(39))
  Gcoeff(:)%j = (c(1)*(-M(7,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[24,2,1,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,37),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(13),n2h8(40))
  Gcoeff(:)%j = (c(2)*(-M(7,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[24,2,1,4],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,38),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(14),n2h8(41))
  Gcoeff(:)%j = (c(22)*(-M(7,:)%j+M(11,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[24,2,1,4],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,39),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(28),n2h8(42))
  Gcoeff(:)%j = (c(7)*(M(8,:)%j-M(12,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[24,2,1,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,40),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(15),n2h8(43))
  Gcoeff(:)%j = (c(10)*(-M(8,:)%j+M(12,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[24,2,1,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),24,G1H8(29),m3h4x8(:,41),heltab2x32(:,:,233))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(3,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[24,1,2,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,42),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(31),n2h8(44))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(3,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[24,1,2,4],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,43),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(32),n2h8(45))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(3,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[24,1,2,4],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,44),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(33),n2h8(46))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(4,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[24,1,2,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,45),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(34),n2h8(47))
  Gcoeff(:)%j = (c(10)*(-M(2,:)%j+M(4,:)%j)+c(8)*(-M(20,:)%j+M(22,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[24,1,2,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),24,G1H8(35),m3h4x8(:,46),heltab2x32(:,:,238))
  Gcoeff(:)%j = (c(17)*(-M(20,:)%j+M(22,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[24,1,4,2],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),24,G1H8(37),m3h4x8(:,47),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(17)*(M(20,:)%j-M(22,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[24,1,4,2],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,48),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(38),n2h8(48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(21),G0H8(15),G0H8(14),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(3),G0H8(12),G0H8(11),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G0H8(3),G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G0H8(6),G0H8(5),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G0H8(9),G0H8(8),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G0H8(18),G0H8(17),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(25),G1H16(10),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(27),G1H16(12),G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(53),G1H16(41),G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(55),G1H16(43),G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(80),G1H16(68),G1H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(82),G1H16(70),G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(83),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(85),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(87),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(101),[G1H16(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(108),[G1H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(113),[G1H16(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(120),[G1H16(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(125),[G1H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(132),[G1H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(137),[G1H16(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(142),[G1H16(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(147),[G1H16(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(27),[G0H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(32),[G0H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(36),[G0H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(31)])
  call Hloop_VQ_A(ntryL,G1H8(9),ex1(:),G1H4(175),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(175),21,0,G2H4(25),n2h4(79))
  call Hloop_VA_Q(ntryL,G1H8(27),ex2(:),G1H4(176),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(176),22,0,G2H4(26),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(22),ex3(:),G1H4(191),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(191),22,0,G2H4(27),n2h4(81))
  call Hloop_AV_Q(ntryL,G1H8(12),ex4(:),G1H4(192),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(192),26,0,G2H4(28),n2h4(82))
  call Hloop_QV_A(ntryL,G1H8(18),ex3(:),G1H4(3),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(3),21,0,G2H4(29),n2h4(83))
  call Hloop_QV_A(ntryL,G1H8(36),ex3(:),G1H4(4),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(4),21,0,G2H4(32),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(40),ex4(:),G1H4(7),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(7),25,0,G2H4(33),n2h4(85))
  call Hloop_QV_A(ntryL,G1H8(46),ex4(:),G1H4(8),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(8),25,0,G2H4(34),n2h4(86))
  call Hloop_VA_Q(ntryL,G1H8(29),ex2(:),G1H4(9),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(9),26,0,G2H4(37),n2h4(87))
  call Hloop_VQ_A(ntryL,G1H8(35),ex1(:),G1H4(10),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(10),25,0,G2H4(38),n2h4(88))
  call Hloop_VQ_A(ntryL,G1H8(37),ex1(:),G1H4(13),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(13),25,0,G2H4(39),n2h4(89))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(14),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(14),21,0,G2H4(42),n2h4(90))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(39),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(39),17,0,G2H8(1),n2h8(49))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(16),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(16),17,0,G2H8(2),n2h8(50))
  call Hloop_VQ_A(ntryL,G1H16(11),ex1(:),G1H8(17),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(17),17,0,G2H8(3),n2h8(51))
  call Hloop_VA_Q(ntryL,G1H16(16),ex2(:),G1H8(41),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(41),18,0,G2H8(4),n2h8(52))
  call Hloop_VA_Q(ntryL,G1H16(21),ex2(:),G1H8(42),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(42),18,0,G2H8(5),n2h8(53))
  call Hloop_VA_Q(ntryL,G1H16(26),ex2(:),G1H8(43),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(43),18,0,G2H8(6),n2h8(54))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(44),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(45),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(47),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QV_A(ntryL,G1H16(30),wf4(:,1),G1H4(15),m3h4x4(:,1),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(15),19,0,G2H4(43),n2h4(91))
  call Hloop_QV_A(ntryL,G1H16(29),wf4(:,1),G1H4(16),m3h4x4(:,2),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMT,G2H4(44),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H16(32),wf4(:,1),G1H4(19),m3h4x4(:,3),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(19),19,0,G2H4(47),n2h4(93))
  call Hloop_AV_Q(ntryL,G1H16(28),wf4(:,1),G1H4(20),m3h4x4(:,4),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(20),19,nMT,G2H4(48),n2h4(94))
  call Hloop_QV_A(ntryL,G1H16(31),wf4(:,1),G1H4(21),m3h4x4(:,5),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(21),19,nMB,G2H4(49),n2h4(95))
  call Hloop_AV_Q(ntryL,G1H16(33),wf4(:,1),G1H4(22),m3h4x4(:,6),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(22),19,nMB,G2H4(52),n2h4(96))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,17),G1H4(25),ngZu,m3h4x4(:,7),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(53),n2h4(97))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,17),G1H4(26),ngZu,m3h4x4(:,8),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(26),19,nMT,G2H4(54),n2h4(98))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,17),G1H4(27),ngZu,m3h4x4(:,9),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(27),19,0,G2H4(56),n2h4(99))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,17),G1H4(28),ngZu,m3h4x4(:,10),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(28),19,nMT,G2H4(57),n2h4(100))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,17),G1H4(31),ngZd,m3h4x4(:,11),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(31),19,0,G2H4(58),n2h4(101))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,17),G1H4(32),ngZd,m3h4x4(:,12),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(32),19,nMB,G2H4(61),n2h4(102))
  call Hloop_AZ_Q(ntryL,G1H16(22),wf4(:,17),G1H4(33),ngZd,m3h4x4(:,13),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(33),19,0,G2H4(62),n2h4(103))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,17),G1H4(34),ngZd,m3h4x4(:,14),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(34),19,nMB,G2H4(63),n2h4(104))
  call Hloop_CV_D(ntryL,G1H16(34),16,wf4(:,1),3,G2H4(65),m3h4x4(:,15),heltab2x16(:,:,60))
  call Hloop_DV_C(ntryL,G1H16(35),16,wf4(:,1),G2H4(66),m3h4x4(:,16),heltab2x16(:,:,61))
  call Hloop_UV_W(ntryL,G1H16(36),16,wf4(:,1),3,G2H4(1),m3h4x4(:,17),heltab2x16(:,:,62))
  call Hloop_AV_Q(ntryL,G1H16(57),wf4(:,1),G1H4(37),m3h4x4(:,18),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(37),19,0,G2H4(2),n2h4(105))
  call Hloop_AV_Q(ntryL,G1H16(54),wf4(:,1),G1H4(38),m3h4x4(:,19),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(38),19,nMT,G2H4(3),n2h4(106))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,1),G1H4(39),m3h4x4(:,20),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(39),19,0,G2H4(4),n2h4(107))
  call Hloop_QV_A(ntryL,G1H16(56),wf4(:,1),G1H4(40),m3h4x4(:,21),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(40),19,nMT,G2H4(5),n2h4(108))
  call Hloop_AV_Q(ntryL,G1H16(58),wf4(:,1),G1H4(43),m3h4x4(:,22),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(43),19,nMB,G2H4(6),n2h4(109))
  call Hloop_QV_A(ntryL,G1H16(60),wf4(:,1),G1H4(44),m3h4x4(:,23),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(44),19,nMB,G2H4(7),n2h4(110))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,17),G1H4(45),ngZu,m3h4x4(:,24),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(45),19,0,G2H4(8),n2h4(111))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,17),G1H4(46),ngZu,m3h4x4(:,25),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(46),19,nMT,G2H4(9),n2h4(112))
  call Hloop_QZ_A(ntryL,G1H16(47),wf4(:,17),G1H4(49),ngZu,m3h4x4(:,26),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(49),19,0,G2H4(10),n2h4(113))
  call Hloop_QZ_A(ntryL,G1H16(48),wf4(:,17),G1H4(50),ngZu,m3h4x4(:,27),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(50),19,nMT,G2H4(11),n2h4(114))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf4(:,17),G1H4(51),ngZd,m3h4x4(:,28),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(51),19,0,G2H4(12),n2h4(115))
  call Hloop_AZ_Q(ntryL,G1H16(50),wf4(:,17),G1H4(52),ngZd,m3h4x4(:,29),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(52),19,nMB,G2H4(13),n2h4(116))
  call Hloop_QZ_A(ntryL,G1H16(51),wf4(:,17),G1H4(55),ngZd,m3h4x4(:,30),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(55),19,0,G2H4(14),n2h4(117))
  call Hloop_QZ_A(ntryL,G1H16(52),wf4(:,17),G1H4(56),ngZd,m3h4x4(:,31),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(56),19,nMB,G2H4(15),n2h4(118))
  call Hloop_DV_C(ntryL,G1H16(61),16,wf4(:,1),G2H4(16),m3h4x4(:,32),heltab2x16(:,:,77))
  call Hloop_CV_D(ntryL,G1H16(62),16,wf4(:,1),3,G2H4(17),m3h4x4(:,33),heltab2x16(:,:,78))
  call Hloop_UV_W(ntryL,G1H16(63),16,wf4(:,1),3,G2H4(18),m3h4x4(:,34),heltab2x16(:,:,79))
  call Hloop_QV_A(ntryL,G1H16(84),ex3(:),G1H8(48),m3h2x8(:,46),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(48),20,0,G2H8(7),n2h8(55))
  call Hloop_QV_A(ntryL,G1H16(81),ex3(:),G1H8(49),m3h2x8(:,47),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(49),20,nMT,G2H8(8),n2h8(56))
  call Hloop_AV_Q(ntryL,G1H16(86),ex3(:),G1H8(21),m3h2x8(:,48),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(21),20,0,G2H8(9),n2h8(57))
  call Hloop_AV_Q(ntryL,G1H16(83),ex3(:),G1H8(3),m3h2x8(:,49),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMT,G2H8(10),n2h8(58))
  call Hloop_QV_A(ntryL,G1H16(85),ex3(:),G1H8(6),m3h2x8(:,50),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(11),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(87),ex3(:),G1H8(30),m3h2x8(:,51),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H8(30),20,nMB,G2H8(12),n2h8(60))
  call Hloop_QV_A(ntryL,G1H16(72),ex3(:),G1H8(1),m3h2x8(:,52),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(13),n2h8(61))
  call Hloop_QV_A(ntryL,G1H16(73),ex3(:),G1H8(4),m3h2x8(:,53),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMT,G2H8(14),n2h8(62))
  call Hloop_AV_Q(ntryL,G1H16(74),ex3(:),G1H8(13),m3h2x8(:,54),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(13),20,0,G2H8(15),n2h8(63))
  call Hloop_AV_Q(ntryL,G1H16(75),ex3(:),G1H8(31),m3h2x8(:,55),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(31),20,nMT,G2H8(16),n2h8(64))
  call Hloop_QV_A(ntryL,G1H16(76),ex3(:),G1H8(9),m3h2x8(:,56),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(9),20,0,G2H8(17),n2h8(65))
  call Hloop_QV_A(ntryL,G1H16(77),ex3(:),G1H8(27),m3h2x8(:,57),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(27),20,nMB,G2H8(18),n2h8(66))
  call Hloop_AV_Q(ntryL,G1H16(78),ex3(:),G1H8(22),m3h2x8(:,58),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(22),20,0,G2H8(19),n2h8(67))
  call Hloop_AV_Q(ntryL,G1H16(79),ex3(:),G1H8(12),m3h2x8(:,59),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(12),20,nMB,G2H8(20),n2h8(68))
  call Hloop_CV_D(ntryL,G1H16(88),16,ex3(:),4,G2H8(21),m3h2x8(:,60),heltab2x16(:,:,94))
  call Hloop_DV_C(ntryL,G1H16(89),16,ex3(:),G2H8(22),m3h2x8(:,61),heltab2x16(:,:,95))
  call Hloop_UV_W(ntryL,G1H16(90),16,ex3(:),4,G2H8(23),m3h2x8(:,62),heltab2x16(:,:,96))
  call Hloop_VA_Q(ntryL,G1H16(91),ex2(:),G1H8(18),m3h2x8(:,63),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(18),18,0,G2H8(24),n2h8(69))
  call Hloop_QA_V(ntryL,G1H16(92),ex2(:),G1H8(36),m3h2x8(:,64),heltab2x16(:,:,98))
  call Hloop_AQ_V(ntryL,G1H16(96),wf4(:,7),G1H4(57),m3h4x4(:,35),heltab2x16(:,:,99))
  call Hloop_AQ_Z(ntryL,G1H16(94),wf4(:,7),G1H4(58),ngZd,m3h4x4(:,36),heltab2x16(:,:,100))
  call Hloop_AQ_W(ntryL,G1H16(95),wf4(:,7),G1H4(61),m3h4x4(:,37),heltab2x16(:,:,101))
  call Hloop_VQ_A(ntryL,G1H16(97),wf4(:,7),G1H4(62),m3h4x4(:,38),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(62),21,0,G2H4(19),n2h4(119))
  call Hloop_QA_V(ntryL,G1H16(101),ex2(:),G1H8(40),m3h2x8(:,65),heltab2x16(:,:,103))
  call Hloop_QA_Z(ntryL,G1H16(99),ex2(:),G1H8(46),ngZd,m3h2x8(:,66),heltab2x16(:,:,104))
  call Hloop_QA_W(ntryL,G1H16(100),ex2(:),G1H8(29),m3h2x8(:,67),heltab2x16(:,:,105))
  call Hloop_VA_Q(ntryL,G1H16(102),ex2(:),G1H8(35),m3h2x8(:,68),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(35),18,0,G2H8(25),n2h8(70))
  call Hloop_VQ_A(ntryL,G1H16(103),ex1(:),G1H8(37),m3h2x8(:,69),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(37),17,0,G2H8(26),n2h8(71))
  call Hloop_AQ_V(ntryL,G1H16(104),ex1(:),G1H8(10),m3h2x8(:,70),heltab2x16(:,:,108))
  call Hloop_QA_V(ntryL,G1H16(108),wf4(:,14),G1H4(63),m3h4x4(:,39),heltab2x16(:,:,109))
  call Hloop_QA_Z(ntryL,G1H16(106),wf4(:,14),G1H4(64),ngZd,m3h4x4(:,40),heltab2x16(:,:,110))
  call Hloop_QA_W(ntryL,G1H16(107),wf4(:,14),G1H4(67),m3h4x4(:,41),heltab2x16(:,:,111))
  call Hloop_VA_Q(ntryL,G1H16(109),wf4(:,14),G1H4(68),m3h4x4(:,42),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(68),22,0,G2H4(20),n2h4(120))
  call Hloop_AQ_V(ntryL,G1H16(113),ex1(:),G1H8(39),m3h2x8(:,71),heltab2x16(:,:,113))
  call Hloop_AQ_Z(ntryL,G1H16(111),ex1(:),G1H8(16),ngZd,m3h2x8(:,72),heltab2x16(:,:,114))
  call Hloop_AQ_W(ntryL,G1H16(112),ex1(:),G1H8(17),m3h2x8(:,73),heltab2x16(:,:,115))
  call Hloop_VQ_A(ntryL,G1H16(114),ex1(:),G1H8(41),m3h2x8(:,74),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(41),17,0,G2H8(27),n2h8(72))
  call Hloop_VA_Q(ntryL,G1H16(115),ex2(:),G1H8(42),m3h2x8(:,75),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G1H8(42),18,0,G2H8(28),n2h8(73))
  call Hloop_QA_V(ntryL,G1H16(116),ex2(:),G1H8(43),m3h2x8(:,76),heltab2x16(:,:,118))
  call Hloop_QV_A(ntryL,G1H16(120),ex3(:),G1H8(48),m3h2x8(:,77),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(48),20,0,G2H8(29),n2h8(74))
  call Hloop_QV_A(ntryL,G1H16(118),ex3(:),G1H8(49),m3h2x8(:,78),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(49),20,0,G2H8(30),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(119),ex3(:),G1H8(21),m3h2x8(:,79),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(31),n2h8(76))
  call Hloop_UV_W(ntryL,G1H16(121),16,ex3(:),4,G2H8(32),m3h2x8(:,80),heltab2x16(:,:,122))
  call Hloop_QA_V(ntryL,G1H16(125),ex2(:),G1H8(3),m3h2x8(:,81),heltab2x16(:,:,123))
  call Hloop_QA_Z(ntryL,G1H16(123),ex2(:),G1H8(6),ngZd,m3h2x8(:,82),heltab2x16(:,:,124))
  call Hloop_QA_W(ntryL,G1H16(124),ex2(:),G1H8(30),m3h2x8(:,83),heltab2x16(:,:,125))
  call Hloop_VA_Q(ntryL,G1H16(126),ex2(:),G1H8(1),m3h2x8(:,84),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(1),18,0,G2H8(33),n2h8(77))
  call Hloop_VQ_A(ntryL,G1H16(127),ex1(:),G1H8(4),m3h2x8(:,85),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(4),17,0,G2H8(34),n2h8(78))
  call Hloop_AQ_V(ntryL,G1H16(128),ex1(:),G1H8(13),m3h2x8(:,86),heltab2x16(:,:,128))
  call Hloop_AV_Q(ntryL,G1H16(132),ex3(:),G1H8(31),m3h2x8(:,87),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G1H8(31),20,0,G2H8(35),n2h8(79))
  call Hloop_AV_Q(ntryL,G1H16(130),ex3(:),G1H8(9),m3h2x8(:,88),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G1H8(9),20,0,G2H8(36),n2h8(80))
  call Hloop_AV_Q(ntryL,G1H16(131),ex3(:),G1H8(27),m3h2x8(:,89),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H8(27),20,0,G2H8(37),n2h8(81))
  call Hloop_UV_W(ntryL,G1H16(133),16,ex3(:),4,G2H8(38),m3h2x8(:,90),heltab2x16(:,:,132))
  call Hloop_AQ_V(ntryL,G1H16(137),ex1(:),G1H8(22),m3h2x8(:,91),heltab2x16(:,:,133))
  call Hloop_AQ_Z(ntryL,G1H16(135),ex1(:),G1H8(12),ngZd,m3h2x8(:,92),heltab2x16(:,:,134))
  call Hloop_AQ_W(ntryL,G1H16(136),ex1(:),G1H8(18),m3h2x8(:,93),heltab2x16(:,:,135))
  call Hloop_VQ_A(ntryL,G1H16(138),ex1(:),G1H8(35),m3h2x8(:,94),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H8(35),17,0,G2H8(39),n2h8(82))
  call Hloop_AQ_V(ntryL,G1H16(142),ex1(:),G1H8(37),m3h2x8(:,95),heltab2x16(:,:,137))
  call Hloop_AQ_Z(ntryL,G1H16(140),ex1(:),G1H8(41),ngZd,m3h2x8(:,96),heltab2x16(:,:,138))
  call Hloop_AQ_W(ntryL,G1H16(141),ex1(:),G1H8(42),m3h2x8(:,97),heltab2x16(:,:,139))
  call Hloop_VQ_A(ntryL,G1H16(143),ex1(:),G1H8(48),m3h2x8(:,98),heltab2x16(:,:,140))



end subroutine vamp_1

end module ol_vamp_1_ppjjj_ew_ddxggg_1_/**/REALKIND
