
module ol_vamp_7_ppjjj_ggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_7(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ggggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppjjj_ggggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppjjj_ggggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(44)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,179) :: G0
  complex(REALKIND), dimension(4,5,4,336) :: G1
  complex(REALKIND), dimension(5,118) :: G1tensor
  complex(REALKIND), dimension(15,245) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,48),G0(:,:,:,2))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,1))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,55),G0(:,:,:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,3),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,2))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,55),wf(:,-2),G0(:,:,:,4))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,3))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,55),G0(:,:,:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,4))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,140),G0(:,:,:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,5))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,140),wf(:,-2),G0(:,:,:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,6))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,140),G0(:,:,:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,7))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,144),G0(:,:,:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,8))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,144),wf(:,-2),G0(:,:,:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,9))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,144),G0(:,:,:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,11),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,10))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,141),G0(:,:,:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,11))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,141),wf(:,-2),G0(:,:,:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,12))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,141),G0(:,:,:,14))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,13))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,19),G1(:,:,:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,-2),G1tensor(:,14))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,-3),G1tensor(:,15))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,-2),G1tensor(:,16))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,1))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,55),Q(:,19),G1(:,:,:,2))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-3),wf(:,-2),G1tensor(:,17))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-2),wf(:,-3),G1tensor(:,18))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,-3),wf(:,-2),G1tensor(:,19))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,2))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,44),G0(:,:,:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,20))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,-1),G0(:,:,:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,21))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,44),G0(:,:,:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,22))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,21),G1(:,:,:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-3),wf(:,-1),G1tensor(:,23))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-1),wf(:,-3),G1tensor(:,24))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,3),wf(:,-3),wf(:,-1),G1tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,3),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,26),ZERO,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,5),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,31),ZERO,G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,26),ZERO,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,5),G1(:,:,:,7))
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,31),ZERO,G2tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,26),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,5),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,31),ZERO,G2tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,26),MT,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,5),G1(:,:,:,11))
  call check_last_Q_A(l_switch,G1(:,:,:,11),Q(:,31),MT,G2tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,26),MT,G1(:,:,:,12))
  call loop_QV_A(G1(:,:,:,12),wf(:,5),G1(:,:,:,13))
  call check_last_Q_A(l_switch,G1(:,:,:,13),Q(:,31),MT,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,26),MT,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,5),G1(:,:,:,15))
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,31),MT,G2tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,26),MB,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,5),G1(:,:,:,17))
  call check_last_Q_A(l_switch,G1(:,:,:,17),Q(:,31),MB,G2tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,26),MB,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,5),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,31),MB,G2tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,26),MB,G1(:,:,:,20))
  call loop_QV_A(G1(:,:,:,20),wf(:,5),G1(:,:,:,21))
  call check_last_Q_A(l_switch,G1(:,:,:,21),Q(:,31),MB,G2tensor(:,12))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,26),G1(:,:,:,22))
  call check_last_CV_D(l_switch,G1(:,:,:,22),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,13))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,26),G1(:,:,:,23))
  call check_last_CV_D(l_switch,G1(:,:,:,23),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,8),Q(:,26),G1(:,:,:,24))
  call check_last_CV_D(l_switch,G1(:,:,:,24),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,15))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,47),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,26))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,47),wf(:,-1),G0(:,:,:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,27))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,47),G0(:,:,:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,28))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,136),G0(:,:,:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,29))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,136),wf(:,-1),G0(:,:,:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,30))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,136),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,31))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,52),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,32))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,52),wf(:,-1),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,33))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,52),G0(:,:,:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,34))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,48),G0(:,:,:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,35))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,48),wf(:,-1),G0(:,:,:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,36))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,48),G0(:,:,:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,37))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,148),G0(:,:,:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,38))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,148),wf(:,-1),G0(:,:,:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,39))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,148),G0(:,:,:,41))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,40))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,137),G0(:,:,:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,41))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,137),wf(:,-1),G0(:,:,:,43))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,42))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,137),G0(:,:,:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,43))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,144),G0(:,:,:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,44))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,144),wf(:,-1),G0(:,:,:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,45))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,144),G0(:,:,:,47))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,46))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,138),G0(:,:,:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,47))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,138),wf(:,-1),G0(:,:,:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,49),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,48))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,138),G0(:,:,:,50))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,49))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,21),G1(:,:,:,25))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,25),wf(:,-3),wf(:,-1),G1tensor(:,50))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,25),wf(:,-1),wf(:,-3),G1tensor(:,51))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,25),wf(:,-3),wf(:,-1),G1tensor(:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,25),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,148),Q(:,21),G1(:,:,:,26))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,26),wf(:,-3),wf(:,-1),G1tensor(:,53))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,26),wf(:,-1),wf(:,-3),G1tensor(:,54))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,26),wf(:,-3),wf(:,-1),G1tensor(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,26),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,17))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,47),Q(:,25),G1(:,:,:,27))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,27),wf(:,-2),wf(:,-1),G1tensor(:,56))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,27),wf(:,-1),wf(:,-2),G1tensor(:,57))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,27),wf(:,-2),wf(:,-1),G1tensor(:,58))
  call check_last_UV_W(l_switch,G1(:,:,:,27),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,22),ZERO,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,9),G1(:,:,:,29))
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,31),ZERO,G2tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,22),ZERO,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,9),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,31),ZERO,G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,22),ZERO,G1(:,:,:,32))
  call loop_QV_A(G1(:,:,:,32),wf(:,9),G1(:,:,:,33))
  call check_last_Q_A(l_switch,G1(:,:,:,33),Q(:,31),ZERO,G2tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,22),MT,G1(:,:,:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,9),G1(:,:,:,35))
  call check_last_Q_A(l_switch,G1(:,:,:,35),Q(:,31),MT,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,22),MT,G1(:,:,:,36))
  call loop_QV_A(G1(:,:,:,36),wf(:,9),G1(:,:,:,37))
  call check_last_Q_A(l_switch,G1(:,:,:,37),Q(:,31),MT,G2tensor(:,23))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,22),MT,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,9),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,31),MT,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,10),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,22),MB,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,9),G1(:,:,:,41))
  call check_last_Q_A(l_switch,G1(:,:,:,41),Q(:,31),MB,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,22),MB,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,9),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,31),MB,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,22),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,9),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,31),MB,G2tensor(:,27))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,22),G1(:,:,:,46))
  call check_last_CV_D(l_switch,G1(:,:,:,46),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,28))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,22),G1(:,:,:,47))
  call check_last_CV_D(l_switch,G1(:,:,:,47),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,29))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,22),G1(:,:,:,48))
  call check_last_CV_D(l_switch,G1(:,:,:,48),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,30))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,48),Q(:,25),G1(:,:,:,49))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,49),wf(:,-2),wf(:,-1),G1tensor(:,59))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,49),wf(:,-1),wf(:,-2),G1tensor(:,60))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,49),wf(:,-2),wf(:,-1),G1tensor(:,61))
  call check_last_UV_W(l_switch,G1(:,:,:,49),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,31))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,144),Q(:,25),G1(:,:,:,50))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,50),wf(:,-2),wf(:,-1),G1tensor(:,62))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,50),wf(:,-1),wf(:,-2),G1tensor(:,63))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,50),wf(:,-2),wf(:,-1),G1tensor(:,64))
  call check_last_UV_W(l_switch,G1(:,:,:,50),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,17),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,14),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,31),ZERO,G2tensor(:,33))
  call loop_QV_A(G1(:,:,:,51),wf(:,15),G1(:,:,:,53))
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,31),ZERO,G2tensor(:,34))
  call loop_QV_A(G1(:,:,:,51),wf(:,16),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,31),ZERO,G2tensor(:,35))
  call loop_QV_A(G1(:,:,:,51),wf(:,143),G1(:,:,:,55))
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,31),ZERO,G2tensor(:,36))
  call loop_QV_A(G1(:,:,:,51),wf(:,147),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,31),ZERO,G2tensor(:,37))
  call loop_QV_A(G1(:,:,:,51),wf(:,149),G1(:,:,:,57))
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,31),ZERO,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,17),MT,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,14),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,31),MT,G2tensor(:,39))
  call loop_QV_A(G1(:,:,:,58),wf(:,15),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,31),MT,G2tensor(:,40))
  call loop_QV_A(G1(:,:,:,58),wf(:,16),G1(:,:,:,61))
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,31),MT,G2tensor(:,41))
  call loop_QV_A(G1(:,:,:,58),wf(:,143),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,31),MT,G2tensor(:,42))
  call loop_QV_A(G1(:,:,:,58),wf(:,147),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,31),MT,G2tensor(:,43))
  call loop_QV_A(G1(:,:,:,58),wf(:,149),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,31),MT,G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,17),MB,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,14),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,31),MB,G2tensor(:,45))
  call loop_QV_A(G1(:,:,:,65),wf(:,15),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,31),MB,G2tensor(:,46))
  call loop_QV_A(G1(:,:,:,65),wf(:,16),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,31),MB,G2tensor(:,47))
  call loop_QV_A(G1(:,:,:,65),wf(:,143),G1(:,:,:,69))
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,31),MB,G2tensor(:,48))
  call loop_QV_A(G1(:,:,:,65),wf(:,147),G1(:,:,:,70))
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,31),MB,G2tensor(:,49))
  call loop_QV_A(G1(:,:,:,65),wf(:,149),G1(:,:,:,71))
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,31),MB,G2tensor(:,50))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,13),Q(:,17),G1(:,:,:,72))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,17),wf(:,14),Q(:,14),G2tensor(:,51))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,17),wf(:,15),Q(:,14),G2tensor(:,52))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,17),wf(:,16),Q(:,14),G2tensor(:,53))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,17),wf(:,143),Q(:,14),G2tensor(:,54))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,17),wf(:,147),Q(:,14),G2tensor(:,55))
  call check_last_CV_D(l_switch,G1(:,:,:,72),Q(:,17),wf(:,149),Q(:,14),G2tensor(:,56))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,142),G0(:,:,:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,65))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,142),wf(:,0),G0(:,:,:,64))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,66))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,142),G0(:,:,:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,67))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,142),Q(:,22),G1(:,:,:,73))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,73),wf(:,-3),wf(:,0),G1tensor(:,68))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,73),wf(:,0),wf(:,-3),G1tensor(:,69))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,73),wf(:,-3),wf(:,0),G1tensor(:,70))
  call check_last_UV_W(l_switch,G1(:,:,:,73),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,57))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,25),ZERO,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,17),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,31),ZERO,G2tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,25),ZERO,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,17),G1(:,:,:,77))
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,31),ZERO,G2tensor(:,59))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,25),ZERO,G1(:,:,:,78))
  call loop_QV_A(G1(:,:,:,78),wf(:,17),G1(:,:,:,79))
  call check_last_Q_A(l_switch,G1(:,:,:,79),Q(:,31),ZERO,G2tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,25),MT,G1(:,:,:,80))
  call loop_QV_A(G1(:,:,:,80),wf(:,17),G1(:,:,:,81))
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,31),MT,G2tensor(:,61))
  call loop_QV_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,70))
  call loop_Q_A(G0(:,:,:,70),Q(:,25),MT,G1(:,:,:,82))
  call loop_QV_A(G1(:,:,:,82),wf(:,17),G1(:,:,:,83))
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,31),MT,G2tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,71))
  call loop_Q_A(G0(:,:,:,71),Q(:,25),MT,G1(:,:,:,84))
  call loop_QV_A(G1(:,:,:,84),wf(:,17),G1(:,:,:,85))
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,31),MT,G2tensor(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,72))
  call loop_Q_A(G0(:,:,:,72),Q(:,25),MB,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,17),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,31),MB,G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,73))
  call loop_Q_A(G0(:,:,:,73),Q(:,25),MB,G1(:,:,:,88))
  call loop_QV_A(G1(:,:,:,88),wf(:,17),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,31),MB,G2tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,25),MB,G1(:,:,:,90))
  call loop_QV_A(G1(:,:,:,90),wf(:,17),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,31),MB,G2tensor(:,66))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,18),Q(:,25),G1(:,:,:,92))
  call check_last_CV_D(l_switch,G1(:,:,:,92),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,67))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,25),G1(:,:,:,93))
  call check_last_CV_D(l_switch,G1(:,:,:,93),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,68))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,20),Q(:,25),G1(:,:,:,94))
  call check_last_CV_D(l_switch,G1(:,:,:,94),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,69))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,139),G0(:,:,:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,71))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,139),wf(:,0),G0(:,:,:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,72))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,139),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,73))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,136),G0(:,:,:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,78),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,74))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,136),wf(:,0),G0(:,:,:,79))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,75))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,136),G0(:,:,:,80))
  call check_last_UV_W(l_switch,G0(:,:,:,80),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,76))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,145),G0(:,:,:,81))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,77))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,145),wf(:,0),G0(:,:,:,82))
  call check_last_UV_W(l_switch,G0(:,:,:,82),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,78))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,145),G0(:,:,:,83))
  call check_last_UV_W(l_switch,G0(:,:,:,83),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,79))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,140),G0(:,:,:,84))
  call check_last_UV_W(l_switch,G0(:,:,:,84),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,80))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,140),wf(:,0),G0(:,:,:,85))
  call check_last_UV_W(l_switch,G0(:,:,:,85),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,81))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,140),G0(:,:,:,86))
  call check_last_UV_W(l_switch,G0(:,:,:,86),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,82))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,146),G0(:,:,:,87))
  call check_last_UV_W(l_switch,G0(:,:,:,87),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,83))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,146),wf(:,0),G0(:,:,:,88))
  call check_last_UV_W(l_switch,G0(:,:,:,88),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,84))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,146),G0(:,:,:,89))
  call check_last_UV_W(l_switch,G0(:,:,:,89),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,85))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,137),G0(:,:,:,90))
  call check_last_UV_W(l_switch,G0(:,:,:,90),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,86))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,137),wf(:,0),G0(:,:,:,91))
  call check_last_UV_W(l_switch,G0(:,:,:,91),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,87))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,137),G0(:,:,:,92))
  call check_last_UV_W(l_switch,G0(:,:,:,92),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,88))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,141),G0(:,:,:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,93),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,89))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,141),wf(:,0),G0(:,:,:,94))
  call check_last_UV_W(l_switch,G0(:,:,:,94),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,90))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,141),G0(:,:,:,95))
  call check_last_UV_W(l_switch,G0(:,:,:,95),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,91))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,138),G0(:,:,:,96))
  call check_last_UV_W(l_switch,G0(:,:,:,96),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,92))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,138),wf(:,0),G0(:,:,:,97))
  call check_last_UV_W(l_switch,G0(:,:,:,97),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,93))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,138),G0(:,:,:,98))
  call check_last_UV_W(l_switch,G0(:,:,:,98),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,94))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,145),Q(:,22),G1(:,:,:,95))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,95),wf(:,-3),wf(:,0),G1tensor(:,95))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,95),wf(:,0),wf(:,-3),G1tensor(:,96))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,95),wf(:,-3),wf(:,0),G1tensor(:,97))
  call check_last_UV_W(l_switch,G1(:,:,:,95),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,70))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,146),Q(:,22),G1(:,:,:,96))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,-3),wf(:,0),G1tensor(:,98))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,96),wf(:,0),wf(:,-3),G1tensor(:,99))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,96),wf(:,-3),wf(:,0),G1tensor(:,100))
  call check_last_UV_W(l_switch,G1(:,:,:,96),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,71))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,139),Q(:,26),G1(:,:,:,97))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,-2),wf(:,0),G1tensor(:,101))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,97),wf(:,0),wf(:,-2),G1tensor(:,102))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,97),wf(:,-2),wf(:,0),G1tensor(:,103))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,99))
  call loop_Q_A(G0(:,:,:,99),Q(:,21),ZERO,G1(:,:,:,98))
  call loop_QV_A(G1(:,:,:,98),wf(:,21),G1(:,:,:,99))
  call check_last_Q_A(l_switch,G1(:,:,:,99),Q(:,31),ZERO,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,100))
  call loop_Q_A(G0(:,:,:,100),Q(:,21),ZERO,G1(:,:,:,100))
  call loop_QV_A(G1(:,:,:,100),wf(:,21),G1(:,:,:,101))
  call check_last_Q_A(l_switch,G1(:,:,:,101),Q(:,31),ZERO,G2tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,101))
  call loop_Q_A(G0(:,:,:,101),Q(:,21),ZERO,G1(:,:,:,102))
  call loop_QV_A(G1(:,:,:,102),wf(:,21),G1(:,:,:,103))
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,31),ZERO,G2tensor(:,75))
  call loop_QV_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,102))
  call loop_Q_A(G0(:,:,:,102),Q(:,21),MT,G1(:,:,:,104))
  call loop_QV_A(G1(:,:,:,104),wf(:,21),G1(:,:,:,105))
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,31),MT,G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,103))
  call loop_Q_A(G0(:,:,:,103),Q(:,21),MT,G1(:,:,:,106))
  call loop_QV_A(G1(:,:,:,106),wf(:,21),G1(:,:,:,107))
  call check_last_Q_A(l_switch,G1(:,:,:,107),Q(:,31),MT,G2tensor(:,77))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,104))
  call loop_Q_A(G0(:,:,:,104),Q(:,21),MT,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,21),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,31),MT,G2tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,22),G0(:,:,:,105))
  call loop_Q_A(G0(:,:,:,105),Q(:,21),MB,G1(:,:,:,110))
  call loop_QV_A(G1(:,:,:,110),wf(:,21),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,31),MB,G2tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,106))
  call loop_Q_A(G0(:,:,:,106),Q(:,21),MB,G1(:,:,:,112))
  call loop_QV_A(G1(:,:,:,112),wf(:,21),G1(:,:,:,113))
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,31),MB,G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,107))
  call loop_Q_A(G0(:,:,:,107),Q(:,21),MB,G1(:,:,:,114))
  call loop_QV_A(G1(:,:,:,114),wf(:,21),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,31),MB,G2tensor(:,81))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,22),Q(:,21),G1(:,:,:,116))
  call check_last_CV_D(l_switch,G1(:,:,:,116),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,82))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,23),Q(:,21),G1(:,:,:,117))
  call check_last_CV_D(l_switch,G1(:,:,:,117),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,83))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,24),Q(:,21),G1(:,:,:,118))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,84))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,140),Q(:,26),G1(:,:,:,119))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,119),wf(:,-2),wf(:,0),G1tensor(:,104))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,119),wf(:,0),wf(:,-2),G1tensor(:,105))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,119),wf(:,-2),wf(:,0),G1tensor(:,106))
  call check_last_UV_W(l_switch,G1(:,:,:,119),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,85))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,141),Q(:,26),G1(:,:,:,120))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,120),wf(:,-2),wf(:,0),G1tensor(:,107))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,120),wf(:,0),wf(:,-2),G1tensor(:,108))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,120),wf(:,-2),wf(:,0),G1tensor(:,109))
  call check_last_UV_W(l_switch,G1(:,:,:,120),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,86))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,108))
  call loop_Q_A(G0(:,:,:,108),Q(:,18),ZERO,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,26),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,31),ZERO,G2tensor(:,87))
  call loop_QV_A(G1(:,:,:,121),wf(:,27),G1(:,:,:,123))
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,31),ZERO,G2tensor(:,88))
  call loop_QV_A(G1(:,:,:,121),wf(:,28),G1(:,:,:,124))
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,31),ZERO,G2tensor(:,89))
  call loop_QV_A(G1(:,:,:,121),wf(:,45),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,31),ZERO,G2tensor(:,90))
  call loop_QV_A(G1(:,:,:,121),wf(:,50),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,31),ZERO,G2tensor(:,91))
  call loop_QV_A(G1(:,:,:,121),wf(:,150),G1(:,:,:,127))
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,31),ZERO,G2tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,109))
  call loop_Q_A(G0(:,:,:,109),Q(:,18),MT,G1(:,:,:,128))
  call loop_QV_A(G1(:,:,:,128),wf(:,26),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,31),MT,G2tensor(:,93))
  call loop_QV_A(G1(:,:,:,128),wf(:,27),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,31),MT,G2tensor(:,94))
  call loop_QV_A(G1(:,:,:,128),wf(:,28),G1(:,:,:,131))
  call check_last_Q_A(l_switch,G1(:,:,:,131),Q(:,31),MT,G2tensor(:,95))
  call loop_QV_A(G1(:,:,:,128),wf(:,45),G1(:,:,:,132))
  call check_last_Q_A(l_switch,G1(:,:,:,132),Q(:,31),MT,G2tensor(:,96))
  call loop_QV_A(G1(:,:,:,128),wf(:,50),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,31),MT,G2tensor(:,97))
  call loop_QV_A(G1(:,:,:,128),wf(:,150),G1(:,:,:,134))
  call check_last_Q_A(l_switch,G1(:,:,:,134),Q(:,31),MT,G2tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,110))
  call loop_Q_A(G0(:,:,:,110),Q(:,18),MB,G1(:,:,:,135))
  call loop_QV_A(G1(:,:,:,135),wf(:,26),G1(:,:,:,136))
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,31),MB,G2tensor(:,99))
  call loop_QV_A(G1(:,:,:,135),wf(:,27),G1(:,:,:,137))
  call check_last_Q_A(l_switch,G1(:,:,:,137),Q(:,31),MB,G2tensor(:,100))
  call loop_QV_A(G1(:,:,:,135),wf(:,28),G1(:,:,:,138))
  call check_last_Q_A(l_switch,G1(:,:,:,138),Q(:,31),MB,G2tensor(:,101))
  call loop_QV_A(G1(:,:,:,135),wf(:,45),G1(:,:,:,139))
  call check_last_Q_A(l_switch,G1(:,:,:,139),Q(:,31),MB,G2tensor(:,102))
  call loop_QV_A(G1(:,:,:,135),wf(:,50),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,31),MB,G2tensor(:,103))
  call loop_QV_A(G1(:,:,:,135),wf(:,150),G1(:,:,:,141))
  call check_last_Q_A(l_switch,G1(:,:,:,141),Q(:,31),MB,G2tensor(:,104))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,18),G1(:,:,:,142))
  call check_last_CV_D(l_switch,G1(:,:,:,142),Q(:,18),wf(:,26),Q(:,13),G2tensor(:,105))
  call check_last_CV_D(l_switch,G1(:,:,:,142),Q(:,18),wf(:,27),Q(:,13),G2tensor(:,106))
  call check_last_CV_D(l_switch,G1(:,:,:,142),Q(:,18),wf(:,28),Q(:,13),G2tensor(:,107))
  call check_last_CV_D(l_switch,G1(:,:,:,142),Q(:,18),wf(:,45),Q(:,13),G2tensor(:,108))
  call check_last_CV_D(l_switch,G1(:,:,:,142),Q(:,18),wf(:,50),Q(:,13),G2tensor(:,109))
  call check_last_CV_D(l_switch,G1(:,:,:,142),Q(:,18),wf(:,150),Q(:,13),G2tensor(:,110))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,136),Q(:,28),G1(:,:,:,143))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,143),wf(:,-1),wf(:,0),G1tensor(:,110))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,143),wf(:,0),wf(:,-1),G1tensor(:,111))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,143),wf(:,-1),wf(:,0),G1tensor(:,112))
  call check_last_UV_W(l_switch,G1(:,:,:,143),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,111))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,111))
  call loop_Q_A(G0(:,:,:,111),Q(:,19),ZERO,G1(:,:,:,144))
  call loop_QV_A(G1(:,:,:,144),wf(:,29),G1(:,:,:,145))
  call check_last_Q_A(l_switch,G1(:,:,:,145),Q(:,31),ZERO,G2tensor(:,112))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,112))
  call loop_Q_A(G0(:,:,:,112),Q(:,19),ZERO,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,29),G1(:,:,:,147))
  call check_last_Q_A(l_switch,G1(:,:,:,147),Q(:,31),ZERO,G2tensor(:,113))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,113))
  call loop_Q_A(G0(:,:,:,113),Q(:,19),ZERO,G1(:,:,:,148))
  call loop_QV_A(G1(:,:,:,148),wf(:,29),G1(:,:,:,149))
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,31),ZERO,G2tensor(:,114))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,114))
  call loop_Q_A(G0(:,:,:,114),Q(:,19),MT,G1(:,:,:,150))
  call loop_QV_A(G1(:,:,:,150),wf(:,29),G1(:,:,:,151))
  call check_last_Q_A(l_switch,G1(:,:,:,151),Q(:,31),MT,G2tensor(:,115))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,115))
  call loop_Q_A(G0(:,:,:,115),Q(:,19),MT,G1(:,:,:,152))
  call loop_QV_A(G1(:,:,:,152),wf(:,29),G1(:,:,:,153))
  call check_last_Q_A(l_switch,G1(:,:,:,153),Q(:,31),MT,G2tensor(:,116))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,116))
  call loop_Q_A(G0(:,:,:,116),Q(:,19),MT,G1(:,:,:,154))
  call loop_QV_A(G1(:,:,:,154),wf(:,29),G1(:,:,:,155))
  call check_last_Q_A(l_switch,G1(:,:,:,155),Q(:,31),MT,G2tensor(:,117))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,117))
  call loop_Q_A(G0(:,:,:,117),Q(:,19),MB,G1(:,:,:,156))
  call loop_QV_A(G1(:,:,:,156),wf(:,29),G1(:,:,:,157))
  call check_last_Q_A(l_switch,G1(:,:,:,157),Q(:,31),MB,G2tensor(:,118))
  call loop_QV_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,118))
  call loop_Q_A(G0(:,:,:,118),Q(:,19),MB,G1(:,:,:,158))
  call loop_QV_A(G1(:,:,:,158),wf(:,29),G1(:,:,:,159))
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,31),MB,G2tensor(:,119))
  call loop_QV_A(G0(:,:,:,1),wf(:,32),G0(:,:,:,119))
  call loop_Q_A(G0(:,:,:,119),Q(:,19),MB,G1(:,:,:,160))
  call loop_QV_A(G1(:,:,:,160),wf(:,29),G1(:,:,:,161))
  call check_last_Q_A(l_switch,G1(:,:,:,161),Q(:,31),MB,G2tensor(:,120))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,30),Q(:,19),G1(:,:,:,162))
  call check_last_CV_D(l_switch,G1(:,:,:,162),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,121))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,19),G1(:,:,:,163))
  call check_last_CV_D(l_switch,G1(:,:,:,163),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,122))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,32),Q(:,19),G1(:,:,:,164))
  call check_last_CV_D(l_switch,G1(:,:,:,164),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,123))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,137),Q(:,28),G1(:,:,:,165))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,165),wf(:,-1),wf(:,0),G1tensor(:,113))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,165),wf(:,0),wf(:,-1),G1tensor(:,114))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,165),wf(:,-1),wf(:,0),G1tensor(:,115))
  call check_last_UV_W(l_switch,G1(:,:,:,165),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,124))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,138),Q(:,28),G1(:,:,:,166))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,166),wf(:,-1),wf(:,0),G1tensor(:,116))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,166),wf(:,0),wf(:,-1),G1tensor(:,117))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,166),wf(:,-1),wf(:,0),G1tensor(:,118))
  call check_last_UV_W(l_switch,G1(:,:,:,166),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,125))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,120))
  call loop_Q_A(G0(:,:,:,120),Q(:,20),ZERO,G1(:,:,:,167))
  call loop_QV_A(G1(:,:,:,167),wf(:,34),G1(:,:,:,168))
  call check_last_Q_A(l_switch,G1(:,:,:,168),Q(:,31),ZERO,G2tensor(:,126))
  call loop_QV_A(G1(:,:,:,167),wf(:,35),G1(:,:,:,169))
  call check_last_Q_A(l_switch,G1(:,:,:,169),Q(:,31),ZERO,G2tensor(:,127))
  call loop_QV_A(G1(:,:,:,167),wf(:,36),G1(:,:,:,170))
  call check_last_Q_A(l_switch,G1(:,:,:,170),Q(:,31),ZERO,G2tensor(:,128))
  call loop_QV_A(G1(:,:,:,167),wf(:,42),G1(:,:,:,171))
  call check_last_Q_A(l_switch,G1(:,:,:,171),Q(:,31),ZERO,G2tensor(:,129))
  call loop_QV_A(G1(:,:,:,167),wf(:,51),G1(:,:,:,172))
  call check_last_Q_A(l_switch,G1(:,:,:,172),Q(:,31),ZERO,G2tensor(:,130))
  call loop_QV_A(G1(:,:,:,167),wf(:,53),G1(:,:,:,173))
  call check_last_Q_A(l_switch,G1(:,:,:,173),Q(:,31),ZERO,G2tensor(:,131))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,121))
  call loop_Q_A(G0(:,:,:,121),Q(:,20),MT,G1(:,:,:,174))
  call loop_QV_A(G1(:,:,:,174),wf(:,34),G1(:,:,:,175))
  call check_last_Q_A(l_switch,G1(:,:,:,175),Q(:,31),MT,G2tensor(:,132))
  call loop_QV_A(G1(:,:,:,174),wf(:,35),G1(:,:,:,176))
  call check_last_Q_A(l_switch,G1(:,:,:,176),Q(:,31),MT,G2tensor(:,133))
  call loop_QV_A(G1(:,:,:,174),wf(:,36),G1(:,:,:,177))
  call check_last_Q_A(l_switch,G1(:,:,:,177),Q(:,31),MT,G2tensor(:,134))
  call loop_QV_A(G1(:,:,:,174),wf(:,42),G1(:,:,:,178))
  call check_last_Q_A(l_switch,G1(:,:,:,178),Q(:,31),MT,G2tensor(:,135))
  call loop_QV_A(G1(:,:,:,174),wf(:,51),G1(:,:,:,179))
  call check_last_Q_A(l_switch,G1(:,:,:,179),Q(:,31),MT,G2tensor(:,136))
  call loop_QV_A(G1(:,:,:,174),wf(:,53),G1(:,:,:,180))
  call check_last_Q_A(l_switch,G1(:,:,:,180),Q(:,31),MT,G2tensor(:,137))
  call loop_QV_A(G0(:,:,:,1),wf(:,33),G0(:,:,:,122))
  call loop_Q_A(G0(:,:,:,122),Q(:,20),MB,G1(:,:,:,181))
  call loop_QV_A(G1(:,:,:,181),wf(:,34),G1(:,:,:,182))
  call check_last_Q_A(l_switch,G1(:,:,:,182),Q(:,31),MB,G2tensor(:,138))
  call loop_QV_A(G1(:,:,:,181),wf(:,35),G1(:,:,:,183))
  call check_last_Q_A(l_switch,G1(:,:,:,183),Q(:,31),MB,G2tensor(:,139))
  call loop_QV_A(G1(:,:,:,181),wf(:,36),G1(:,:,:,184))
  call check_last_Q_A(l_switch,G1(:,:,:,184),Q(:,31),MB,G2tensor(:,140))
  call loop_QV_A(G1(:,:,:,181),wf(:,42),G1(:,:,:,185))
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,31),MB,G2tensor(:,141))
  call loop_QV_A(G1(:,:,:,181),wf(:,51),G1(:,:,:,186))
  call check_last_Q_A(l_switch,G1(:,:,:,186),Q(:,31),MB,G2tensor(:,142))
  call loop_QV_A(G1(:,:,:,181),wf(:,53),G1(:,:,:,187))
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,31),MB,G2tensor(:,143))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,33),Q(:,20),G1(:,:,:,188))
  call check_last_CV_D(l_switch,G1(:,:,:,188),Q(:,20),wf(:,34),Q(:,11),G2tensor(:,144))
  call check_last_CV_D(l_switch,G1(:,:,:,188),Q(:,20),wf(:,35),Q(:,11),G2tensor(:,145))
  call check_last_CV_D(l_switch,G1(:,:,:,188),Q(:,20),wf(:,36),Q(:,11),G2tensor(:,146))
  call check_last_CV_D(l_switch,G1(:,:,:,188),Q(:,20),wf(:,42),Q(:,11),G2tensor(:,147))
  call check_last_CV_D(l_switch,G1(:,:,:,188),Q(:,20),wf(:,51),Q(:,11),G2tensor(:,148))
  call check_last_CV_D(l_switch,G1(:,:,:,188),Q(:,20),wf(:,53),Q(:,11),G2tensor(:,149))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,123))
  call loop_Q_A(G0(:,:,:,123),Q(:,24),ZERO,G1(:,:,:,189))
  call loop_QV_A(G1(:,:,:,189),wf(:,38),G1(:,:,:,190))
  call check_last_Q_A(l_switch,G1(:,:,:,190),Q(:,31),ZERO,G2tensor(:,150))
  call loop_QV_A(G1(:,:,:,189),wf(:,39),G1(:,:,:,191))
  call check_last_Q_A(l_switch,G1(:,:,:,191),Q(:,31),ZERO,G2tensor(:,151))
  call loop_QV_A(G1(:,:,:,189),wf(:,40),G1(:,:,:,192))
  call check_last_Q_A(l_switch,G1(:,:,:,192),Q(:,31),ZERO,G2tensor(:,152))
  call loop_QV_A(G1(:,:,:,189),wf(:,43),G1(:,:,:,193))
  call check_last_Q_A(l_switch,G1(:,:,:,193),Q(:,31),ZERO,G2tensor(:,153))
  call loop_QV_A(G1(:,:,:,189),wf(:,46),G1(:,:,:,194))
  call check_last_Q_A(l_switch,G1(:,:,:,194),Q(:,31),ZERO,G2tensor(:,154))
  call loop_QV_A(G1(:,:,:,189),wf(:,49),G1(:,:,:,195))
  call check_last_Q_A(l_switch,G1(:,:,:,195),Q(:,31),ZERO,G2tensor(:,155))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,124))
  call loop_Q_A(G0(:,:,:,124),Q(:,24),MT,G1(:,:,:,196))
  call loop_QV_A(G1(:,:,:,196),wf(:,38),G1(:,:,:,197))
  call check_last_Q_A(l_switch,G1(:,:,:,197),Q(:,31),MT,G2tensor(:,156))
  call loop_QV_A(G1(:,:,:,196),wf(:,39),G1(:,:,:,198))
  call check_last_Q_A(l_switch,G1(:,:,:,198),Q(:,31),MT,G2tensor(:,157))
  call loop_QV_A(G1(:,:,:,196),wf(:,40),G1(:,:,:,199))
  call check_last_Q_A(l_switch,G1(:,:,:,199),Q(:,31),MT,G2tensor(:,158))
  call loop_QV_A(G1(:,:,:,196),wf(:,43),G1(:,:,:,200))
  call check_last_Q_A(l_switch,G1(:,:,:,200),Q(:,31),MT,G2tensor(:,159))
  call loop_QV_A(G1(:,:,:,196),wf(:,46),G1(:,:,:,201))
  call check_last_Q_A(l_switch,G1(:,:,:,201),Q(:,31),MT,G2tensor(:,160))
  call loop_QV_A(G1(:,:,:,196),wf(:,49),G1(:,:,:,202))
  call check_last_Q_A(l_switch,G1(:,:,:,202),Q(:,31),MT,G2tensor(:,161))
  call loop_QV_A(G0(:,:,:,1),wf(:,37),G0(:,:,:,125))
  call loop_Q_A(G0(:,:,:,125),Q(:,24),MB,G1(:,:,:,203))
  call loop_QV_A(G1(:,:,:,203),wf(:,38),G1(:,:,:,204))
  call check_last_Q_A(l_switch,G1(:,:,:,204),Q(:,31),MB,G2tensor(:,162))
  call loop_QV_A(G1(:,:,:,203),wf(:,39),G1(:,:,:,205))
  call check_last_Q_A(l_switch,G1(:,:,:,205),Q(:,31),MB,G2tensor(:,163))
  call loop_QV_A(G1(:,:,:,203),wf(:,40),G1(:,:,:,206))
  call check_last_Q_A(l_switch,G1(:,:,:,206),Q(:,31),MB,G2tensor(:,164))
  call loop_QV_A(G1(:,:,:,203),wf(:,43),G1(:,:,:,207))
  call check_last_Q_A(l_switch,G1(:,:,:,207),Q(:,31),MB,G2tensor(:,165))
  call loop_QV_A(G1(:,:,:,203),wf(:,46),G1(:,:,:,208))
  call check_last_Q_A(l_switch,G1(:,:,:,208),Q(:,31),MB,G2tensor(:,166))
  call loop_QV_A(G1(:,:,:,203),wf(:,49),G1(:,:,:,209))
  call check_last_Q_A(l_switch,G1(:,:,:,209),Q(:,31),MB,G2tensor(:,167))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,24),G1(:,:,:,210))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,24),wf(:,38),Q(:,7),G2tensor(:,168))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,24),wf(:,39),Q(:,7),G2tensor(:,169))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,24),wf(:,40),Q(:,7),G2tensor(:,170))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,24),wf(:,43),Q(:,7),G2tensor(:,171))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,24),wf(:,46),Q(:,7),G2tensor(:,172))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,24),wf(:,49),Q(:,7),G2tensor(:,173))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,126))
  call loop_Q_A(G0(:,:,:,126),Q(:,19),ZERO,G1(:,:,:,211))
  call loop_QV_A(G1(:,:,:,211),wf(:,29),G1(:,:,:,212))
  call check_last_Q_A(l_switch,G1(:,:,:,212),Q(:,31),ZERO,G2tensor(:,174))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,127))
  call loop_Q_A(G0(:,:,:,127),Q(:,19),MT,G1(:,:,:,213))
  call loop_QV_A(G1(:,:,:,213),wf(:,29),G1(:,:,:,214))
  call check_last_Q_A(l_switch,G1(:,:,:,214),Q(:,31),MT,G2tensor(:,175))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,128))
  call loop_Q_A(G0(:,:,:,128),Q(:,19),MB,G1(:,:,:,215))
  call loop_QV_A(G1(:,:,:,215),wf(:,29),G1(:,:,:,216))
  call check_last_Q_A(l_switch,G1(:,:,:,216),Q(:,31),MB,G2tensor(:,176))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,41),Q(:,19),G1(:,:,:,217))
  call check_last_CV_D(l_switch,G1(:,:,:,217),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,177))
  call loop_QV_A(G0(:,:,:,1),wf(:,136),G0(:,:,:,129))
  call loop_Q_A(G0(:,:,:,129),Q(:,28),ZERO,G1(:,:,:,218))
  call loop_QV_A(G1(:,:,:,218),wf(:,1),G1(:,:,:,219))
  call check_last_Q_A(l_switch,G1(:,:,:,219),Q(:,31),ZERO,G2tensor(:,178))
  call loop_QV_A(G0(:,:,:,1),wf(:,136),G0(:,:,:,130))
  call loop_Q_A(G0(:,:,:,130),Q(:,28),MT,G1(:,:,:,220))
  call loop_QV_A(G1(:,:,:,220),wf(:,1),G1(:,:,:,221))
  call check_last_Q_A(l_switch,G1(:,:,:,221),Q(:,31),MT,G2tensor(:,179))
  call loop_QV_A(G0(:,:,:,1),wf(:,136),G0(:,:,:,131))
  call loop_Q_A(G0(:,:,:,131),Q(:,28),MB,G1(:,:,:,222))
  call loop_QV_A(G1(:,:,:,222),wf(:,1),G1(:,:,:,223))
  call check_last_Q_A(l_switch,G1(:,:,:,223),Q(:,31),MB,G2tensor(:,180))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,136),Q(:,28),G1(:,:,:,224))
  call check_last_CV_D(l_switch,G1(:,:,:,224),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,181))
  call loop_QV_A(G0(:,:,:,1),wf(:,137),G0(:,:,:,132))
  call loop_Q_A(G0(:,:,:,132),Q(:,28),ZERO,G1(:,:,:,225))
  call loop_QV_A(G1(:,:,:,225),wf(:,1),G1(:,:,:,226))
  call check_last_Q_A(l_switch,G1(:,:,:,226),Q(:,31),ZERO,G2tensor(:,182))
  call loop_QV_A(G0(:,:,:,1),wf(:,137),G0(:,:,:,133))
  call loop_Q_A(G0(:,:,:,133),Q(:,28),MT,G1(:,:,:,227))
  call loop_QV_A(G1(:,:,:,227),wf(:,1),G1(:,:,:,228))
  call check_last_Q_A(l_switch,G1(:,:,:,228),Q(:,31),MT,G2tensor(:,183))
  call loop_QV_A(G0(:,:,:,1),wf(:,137),G0(:,:,:,134))
  call loop_Q_A(G0(:,:,:,134),Q(:,28),MB,G1(:,:,:,229))
  call loop_QV_A(G1(:,:,:,229),wf(:,1),G1(:,:,:,230))
  call check_last_Q_A(l_switch,G1(:,:,:,230),Q(:,31),MB,G2tensor(:,184))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,137),Q(:,28),G1(:,:,:,231))
  call check_last_CV_D(l_switch,G1(:,:,:,231),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,185))
  call loop_QV_A(G0(:,:,:,1),wf(:,138),G0(:,:,:,135))
  call loop_Q_A(G0(:,:,:,135),Q(:,28),ZERO,G1(:,:,:,232))
  call loop_QV_A(G1(:,:,:,232),wf(:,1),G1(:,:,:,233))
  call check_last_Q_A(l_switch,G1(:,:,:,233),Q(:,31),ZERO,G2tensor(:,186))
  call loop_QV_A(G0(:,:,:,1),wf(:,138),G0(:,:,:,136))
  call loop_Q_A(G0(:,:,:,136),Q(:,28),MT,G1(:,:,:,234))
  call loop_QV_A(G1(:,:,:,234),wf(:,1),G1(:,:,:,235))
  call check_last_Q_A(l_switch,G1(:,:,:,235),Q(:,31),MT,G2tensor(:,187))
  call loop_QV_A(G0(:,:,:,1),wf(:,138),G0(:,:,:,137))
  call loop_Q_A(G0(:,:,:,137),Q(:,28),MB,G1(:,:,:,236))
  call loop_QV_A(G1(:,:,:,236),wf(:,1),G1(:,:,:,237))
  call check_last_Q_A(l_switch,G1(:,:,:,237),Q(:,31),MB,G2tensor(:,188))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,138),Q(:,28),G1(:,:,:,238))
  call check_last_CV_D(l_switch,G1(:,:,:,238),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,189))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,138))
  call loop_Q_A(G0(:,:,:,138),Q(:,21),ZERO,G1(:,:,:,239))
  call loop_QV_A(G1(:,:,:,239),wf(:,21),G1(:,:,:,240))
  call check_last_Q_A(l_switch,G1(:,:,:,240),Q(:,31),ZERO,G2tensor(:,190))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,139))
  call loop_Q_A(G0(:,:,:,139),Q(:,21),MT,G1(:,:,:,241))
  call loop_QV_A(G1(:,:,:,241),wf(:,21),G1(:,:,:,242))
  call check_last_Q_A(l_switch,G1(:,:,:,242),Q(:,31),MT,G2tensor(:,191))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,140))
  call loop_Q_A(G0(:,:,:,140),Q(:,21),MB,G1(:,:,:,243))
  call loop_QV_A(G1(:,:,:,243),wf(:,21),G1(:,:,:,244))
  call check_last_Q_A(l_switch,G1(:,:,:,244),Q(:,31),MB,G2tensor(:,192))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,21),G1(:,:,:,245))
  call check_last_CV_D(l_switch,G1(:,:,:,245),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,193))
  call loop_QV_A(G0(:,:,:,1),wf(:,139),G0(:,:,:,141))
  call loop_Q_A(G0(:,:,:,141),Q(:,26),ZERO,G1(:,:,:,246))
  call loop_QV_A(G1(:,:,:,246),wf(:,5),G1(:,:,:,247))
  call check_last_Q_A(l_switch,G1(:,:,:,247),Q(:,31),ZERO,G2tensor(:,194))
  call loop_QV_A(G0(:,:,:,1),wf(:,139),G0(:,:,:,142))
  call loop_Q_A(G0(:,:,:,142),Q(:,26),MT,G1(:,:,:,248))
  call loop_QV_A(G1(:,:,:,248),wf(:,5),G1(:,:,:,249))
  call check_last_Q_A(l_switch,G1(:,:,:,249),Q(:,31),MT,G2tensor(:,195))
  call loop_QV_A(G0(:,:,:,1),wf(:,139),G0(:,:,:,143))
  call loop_Q_A(G0(:,:,:,143),Q(:,26),MB,G1(:,:,:,250))
  call loop_QV_A(G1(:,:,:,250),wf(:,5),G1(:,:,:,251))
  call check_last_Q_A(l_switch,G1(:,:,:,251),Q(:,31),MB,G2tensor(:,196))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,139),Q(:,26),G1(:,:,:,252))
  call check_last_CV_D(l_switch,G1(:,:,:,252),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,197))
  call loop_QV_A(G0(:,:,:,1),wf(:,140),G0(:,:,:,144))
  call loop_Q_A(G0(:,:,:,144),Q(:,26),ZERO,G1(:,:,:,253))
  call loop_QV_A(G1(:,:,:,253),wf(:,5),G1(:,:,:,254))
  call check_last_Q_A(l_switch,G1(:,:,:,254),Q(:,31),ZERO,G2tensor(:,198))
  call loop_QV_A(G0(:,:,:,1),wf(:,140),G0(:,:,:,145))
  call loop_Q_A(G0(:,:,:,145),Q(:,26),MT,G1(:,:,:,255))
  call loop_QV_A(G1(:,:,:,255),wf(:,5),G1(:,:,:,256))
  call check_last_Q_A(l_switch,G1(:,:,:,256),Q(:,31),MT,G2tensor(:,199))
  call loop_QV_A(G0(:,:,:,1),wf(:,140),G0(:,:,:,146))
  call loop_Q_A(G0(:,:,:,146),Q(:,26),MB,G1(:,:,:,257))
  call loop_QV_A(G1(:,:,:,257),wf(:,5),G1(:,:,:,258))
  call check_last_Q_A(l_switch,G1(:,:,:,258),Q(:,31),MB,G2tensor(:,200))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,140),Q(:,26),G1(:,:,:,259))
  call check_last_CV_D(l_switch,G1(:,:,:,259),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,201))
  call loop_QV_A(G0(:,:,:,1),wf(:,141),G0(:,:,:,147))
  call loop_Q_A(G0(:,:,:,147),Q(:,26),ZERO,G1(:,:,:,260))
  call loop_QV_A(G1(:,:,:,260),wf(:,5),G1(:,:,:,261))
  call check_last_Q_A(l_switch,G1(:,:,:,261),Q(:,31),ZERO,G2tensor(:,202))
  call loop_QV_A(G0(:,:,:,1),wf(:,141),G0(:,:,:,148))
  call loop_Q_A(G0(:,:,:,148),Q(:,26),MT,G1(:,:,:,262))
  call loop_QV_A(G1(:,:,:,262),wf(:,5),G1(:,:,:,263))
  call check_last_Q_A(l_switch,G1(:,:,:,263),Q(:,31),MT,G2tensor(:,203))
  call loop_QV_A(G0(:,:,:,1),wf(:,141),G0(:,:,:,149))
  call loop_Q_A(G0(:,:,:,149),Q(:,26),MB,G1(:,:,:,264))
  call loop_QV_A(G1(:,:,:,264),wf(:,5),G1(:,:,:,265))
  call check_last_Q_A(l_switch,G1(:,:,:,265),Q(:,31),MB,G2tensor(:,204))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,141),Q(:,26),G1(:,:,:,266))
  call check_last_CV_D(l_switch,G1(:,:,:,266),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,205))
  call loop_QV_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,150))
  call loop_Q_A(G0(:,:,:,150),Q(:,25),ZERO,G1(:,:,:,267))
  call loop_QV_A(G1(:,:,:,267),wf(:,17),G1(:,:,:,268))
  call check_last_Q_A(l_switch,G1(:,:,:,268),Q(:,31),ZERO,G2tensor(:,206))
  call loop_QV_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,151))
  call loop_Q_A(G0(:,:,:,151),Q(:,25),MT,G1(:,:,:,269))
  call loop_QV_A(G1(:,:,:,269),wf(:,17),G1(:,:,:,270))
  call check_last_Q_A(l_switch,G1(:,:,:,270),Q(:,31),MT,G2tensor(:,207))
  call loop_QV_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,152))
  call loop_Q_A(G0(:,:,:,152),Q(:,25),MB,G1(:,:,:,271))
  call loop_QV_A(G1(:,:,:,271),wf(:,17),G1(:,:,:,272))
  call check_last_Q_A(l_switch,G1(:,:,:,272),Q(:,31),MB,G2tensor(:,208))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,47),Q(:,25),G1(:,:,:,273))
  call check_last_CV_D(l_switch,G1(:,:,:,273),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,209))
  call loop_QV_A(G0(:,:,:,1),wf(:,142),G0(:,:,:,153))
  call loop_Q_A(G0(:,:,:,153),Q(:,22),ZERO,G1(:,:,:,274))
  call loop_QV_A(G1(:,:,:,274),wf(:,9),G1(:,:,:,275))
  call check_last_Q_A(l_switch,G1(:,:,:,275),Q(:,31),ZERO,G2tensor(:,210))
  call loop_QV_A(G0(:,:,:,1),wf(:,142),G0(:,:,:,154))
  call loop_Q_A(G0(:,:,:,154),Q(:,22),MT,G1(:,:,:,276))
  call loop_QV_A(G1(:,:,:,276),wf(:,9),G1(:,:,:,277))
  call check_last_Q_A(l_switch,G1(:,:,:,277),Q(:,31),MT,G2tensor(:,211))
  call loop_QV_A(G0(:,:,:,1),wf(:,142),G0(:,:,:,155))
  call loop_Q_A(G0(:,:,:,155),Q(:,22),MB,G1(:,:,:,278))
  call loop_QV_A(G1(:,:,:,278),wf(:,9),G1(:,:,:,279))
  call check_last_Q_A(l_switch,G1(:,:,:,279),Q(:,31),MB,G2tensor(:,212))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,142),Q(:,22),G1(:,:,:,280))
  call check_last_CV_D(l_switch,G1(:,:,:,280),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,213))
  call loop_QV_A(G0(:,:,:,1),wf(:,48),G0(:,:,:,156))
  call loop_Q_A(G0(:,:,:,156),Q(:,25),ZERO,G1(:,:,:,281))
  call loop_QV_A(G1(:,:,:,281),wf(:,17),G1(:,:,:,282))
  call check_last_Q_A(l_switch,G1(:,:,:,282),Q(:,31),ZERO,G2tensor(:,214))
  call loop_QV_A(G0(:,:,:,1),wf(:,48),G0(:,:,:,157))
  call loop_Q_A(G0(:,:,:,157),Q(:,25),MT,G1(:,:,:,283))
  call loop_QV_A(G1(:,:,:,283),wf(:,17),G1(:,:,:,284))
  call check_last_Q_A(l_switch,G1(:,:,:,284),Q(:,31),MT,G2tensor(:,215))
  call loop_QV_A(G0(:,:,:,1),wf(:,48),G0(:,:,:,158))
  call loop_Q_A(G0(:,:,:,158),Q(:,25),MB,G1(:,:,:,285))
  call loop_QV_A(G1(:,:,:,285),wf(:,17),G1(:,:,:,286))
  call check_last_Q_A(l_switch,G1(:,:,:,286),Q(:,31),MB,G2tensor(:,216))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,48),Q(:,25),G1(:,:,:,287))
  call check_last_CV_D(l_switch,G1(:,:,:,287),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,217))
  call loop_QV_A(G0(:,:,:,1),wf(:,144),G0(:,:,:,159))
  call loop_Q_A(G0(:,:,:,159),Q(:,25),ZERO,G1(:,:,:,288))
  call loop_QV_A(G1(:,:,:,288),wf(:,17),G1(:,:,:,289))
  call check_last_Q_A(l_switch,G1(:,:,:,289),Q(:,31),ZERO,G2tensor(:,218))
  call loop_QV_A(G0(:,:,:,1),wf(:,144),G0(:,:,:,160))
  call loop_Q_A(G0(:,:,:,160),Q(:,25),MT,G1(:,:,:,290))
  call loop_QV_A(G1(:,:,:,290),wf(:,17),G1(:,:,:,291))
  call check_last_Q_A(l_switch,G1(:,:,:,291),Q(:,31),MT,G2tensor(:,219))
  call loop_QV_A(G0(:,:,:,1),wf(:,144),G0(:,:,:,161))
  call loop_Q_A(G0(:,:,:,161),Q(:,25),MB,G1(:,:,:,292))
  call loop_QV_A(G1(:,:,:,292),wf(:,17),G1(:,:,:,293))
  call check_last_Q_A(l_switch,G1(:,:,:,293),Q(:,31),MB,G2tensor(:,220))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,144),Q(:,25),G1(:,:,:,294))
  call check_last_CV_D(l_switch,G1(:,:,:,294),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,221))
  call loop_QV_A(G0(:,:,:,1),wf(:,145),G0(:,:,:,162))
  call loop_Q_A(G0(:,:,:,162),Q(:,22),ZERO,G1(:,:,:,295))
  call loop_QV_A(G1(:,:,:,295),wf(:,9),G1(:,:,:,296))
  call check_last_Q_A(l_switch,G1(:,:,:,296),Q(:,31),ZERO,G2tensor(:,222))
  call loop_QV_A(G0(:,:,:,1),wf(:,145),G0(:,:,:,163))
  call loop_Q_A(G0(:,:,:,163),Q(:,22),MT,G1(:,:,:,297))
  call loop_QV_A(G1(:,:,:,297),wf(:,9),G1(:,:,:,298))
  call check_last_Q_A(l_switch,G1(:,:,:,298),Q(:,31),MT,G2tensor(:,223))
  call loop_QV_A(G0(:,:,:,1),wf(:,145),G0(:,:,:,164))
  call loop_Q_A(G0(:,:,:,164),Q(:,22),MB,G1(:,:,:,299))
  call loop_QV_A(G1(:,:,:,299),wf(:,9),G1(:,:,:,300))
  call check_last_Q_A(l_switch,G1(:,:,:,300),Q(:,31),MB,G2tensor(:,224))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,145),Q(:,22),G1(:,:,:,301))
  call check_last_CV_D(l_switch,G1(:,:,:,301),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,225))
  call loop_QV_A(G0(:,:,:,1),wf(:,146),G0(:,:,:,165))
  call loop_Q_A(G0(:,:,:,165),Q(:,22),ZERO,G1(:,:,:,302))
  call loop_QV_A(G1(:,:,:,302),wf(:,9),G1(:,:,:,303))
  call check_last_Q_A(l_switch,G1(:,:,:,303),Q(:,31),ZERO,G2tensor(:,226))
  call loop_QV_A(G0(:,:,:,1),wf(:,146),G0(:,:,:,166))
  call loop_Q_A(G0(:,:,:,166),Q(:,22),MT,G1(:,:,:,304))
  call loop_QV_A(G1(:,:,:,304),wf(:,9),G1(:,:,:,305))
  call check_last_Q_A(l_switch,G1(:,:,:,305),Q(:,31),MT,G2tensor(:,227))
  call loop_QV_A(G0(:,:,:,1),wf(:,146),G0(:,:,:,167))
  call loop_Q_A(G0(:,:,:,167),Q(:,22),MB,G1(:,:,:,306))
  call loop_QV_A(G1(:,:,:,306),wf(:,9),G1(:,:,:,307))
  call check_last_Q_A(l_switch,G1(:,:,:,307),Q(:,31),MB,G2tensor(:,228))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,146),Q(:,22),G1(:,:,:,308))
  call check_last_CV_D(l_switch,G1(:,:,:,308),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,229))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,168))
  call loop_Q_A(G0(:,:,:,168),Q(:,21),ZERO,G1(:,:,:,309))
  call loop_QV_A(G1(:,:,:,309),wf(:,21),G1(:,:,:,310))
  call check_last_Q_A(l_switch,G1(:,:,:,310),Q(:,31),ZERO,G2tensor(:,230))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,169))
  call loop_Q_A(G0(:,:,:,169),Q(:,21),MT,G1(:,:,:,311))
  call loop_QV_A(G1(:,:,:,311),wf(:,21),G1(:,:,:,312))
  call check_last_Q_A(l_switch,G1(:,:,:,312),Q(:,31),MT,G2tensor(:,231))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,170))
  call loop_Q_A(G0(:,:,:,170),Q(:,21),MB,G1(:,:,:,313))
  call loop_QV_A(G1(:,:,:,313),wf(:,21),G1(:,:,:,314))
  call check_last_Q_A(l_switch,G1(:,:,:,314),Q(:,31),MB,G2tensor(:,232))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,21),G1(:,:,:,315))
  call check_last_CV_D(l_switch,G1(:,:,:,315),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,233))
  call loop_QV_A(G0(:,:,:,1),wf(:,148),G0(:,:,:,171))
  call loop_Q_A(G0(:,:,:,171),Q(:,21),ZERO,G1(:,:,:,316))
  call loop_QV_A(G1(:,:,:,316),wf(:,21),G1(:,:,:,317))
  call check_last_Q_A(l_switch,G1(:,:,:,317),Q(:,31),ZERO,G2tensor(:,234))
  call loop_QV_A(G0(:,:,:,1),wf(:,148),G0(:,:,:,172))
  call loop_Q_A(G0(:,:,:,172),Q(:,21),MT,G1(:,:,:,318))
  call loop_QV_A(G1(:,:,:,318),wf(:,21),G1(:,:,:,319))
  call check_last_Q_A(l_switch,G1(:,:,:,319),Q(:,31),MT,G2tensor(:,235))
  call loop_QV_A(G0(:,:,:,1),wf(:,148),G0(:,:,:,173))
  call loop_Q_A(G0(:,:,:,173),Q(:,21),MB,G1(:,:,:,320))
  call loop_QV_A(G1(:,:,:,320),wf(:,21),G1(:,:,:,321))
  call check_last_Q_A(l_switch,G1(:,:,:,321),Q(:,31),MB,G2tensor(:,236))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,148),Q(:,21),G1(:,:,:,322))
  call check_last_CV_D(l_switch,G1(:,:,:,322),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,237))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,174))
  call loop_Q_A(G0(:,:,:,174),Q(:,19),ZERO,G1(:,:,:,323))
  call loop_QV_A(G1(:,:,:,323),wf(:,29),G1(:,:,:,324))
  call check_last_Q_A(l_switch,G1(:,:,:,324),Q(:,31),ZERO,G2tensor(:,238))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,175))
  call loop_Q_A(G0(:,:,:,175),Q(:,19),MT,G1(:,:,:,325))
  call loop_QV_A(G1(:,:,:,325),wf(:,29),G1(:,:,:,326))
  call check_last_Q_A(l_switch,G1(:,:,:,326),Q(:,31),MT,G2tensor(:,239))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,176))
  call loop_Q_A(G0(:,:,:,176),Q(:,19),MB,G1(:,:,:,327))
  call loop_QV_A(G1(:,:,:,327),wf(:,29),G1(:,:,:,328))
  call check_last_Q_A(l_switch,G1(:,:,:,328),Q(:,31),MB,G2tensor(:,240))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,19),G1(:,:,:,329))
  call check_last_CV_D(l_switch,G1(:,:,:,329),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,241))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,177))
  call loop_Q_A(G0(:,:,:,177),Q(:,19),ZERO,G1(:,:,:,330))
  call loop_QV_A(G1(:,:,:,330),wf(:,29),G1(:,:,:,331))
  call check_last_Q_A(l_switch,G1(:,:,:,331),Q(:,31),ZERO,G2tensor(:,242))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,178))
  call loop_Q_A(G0(:,:,:,178),Q(:,19),MT,G1(:,:,:,332))
  call loop_QV_A(G1(:,:,:,332),wf(:,29),G1(:,:,:,333))
  call check_last_Q_A(l_switch,G1(:,:,:,333),Q(:,31),MT,G2tensor(:,243))
  call loop_QV_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,179))
  call loop_Q_A(G0(:,:,:,179),Q(:,19),MB,G1(:,:,:,334))
  call loop_QV_A(G1(:,:,:,334),wf(:,29),G1(:,:,:,335))
  call check_last_Q_A(l_switch,G1(:,:,:,335),Q(:,31),MB,G2tensor(:,244))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,55),Q(:,19),G1(:,:,:,336))
  call check_last_CV_D(l_switch,G1(:,:,:,336),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,245))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(76)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(104)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(104)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(104)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(62)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(62)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(3)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(62)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(78)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(78)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(78)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(66)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(66)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(66)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(100)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(100)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(100)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(104)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(104)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(104)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(60)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(60)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(60)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(60)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(60)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(60)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(9)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(9)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(8)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(37)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(8)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(37)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(37)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(9)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(9)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(8)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(37)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(8)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(37)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(37)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(7)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(7)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(7)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(72)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(72)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(72)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(46)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(46)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(46)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(92)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(92)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(92)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(76)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(76)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(76)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(94)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(94)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(94)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(50)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(50)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(3)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(50)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(78)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(78)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(78)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(54)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(54)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(54)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(92)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(92)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(92)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(94)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(94)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(94)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(72)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(72)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(72)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(9)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(9)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(9)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(8)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(38)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(8)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(38)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(8)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(38)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(9)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(9)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(9)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(8)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(38)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(8)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(38)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(8)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(38)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(7)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(7)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(7)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(76)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(76)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(76)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(78)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(78)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(78)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(9)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(9)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(39)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(8)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(39)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(8)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(39)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(9)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(9)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(39)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(8)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(39)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(8)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(39)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(7)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(7)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(7)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(70)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(70)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(70)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(70)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(70)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(70)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(9)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(9)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(8)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(40)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(8)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(40)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(40)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(9)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(9)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(8)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(40)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(8)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(40)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(40)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(7)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(7)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(7)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(58)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(58)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(58)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(46)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(46)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(46)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(82)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(82)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(82)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(62)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(62)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(62)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(86)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(86)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(86)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(50)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(50)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(50)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(66)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(66)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(66)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(54)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(54)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(54)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(82)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(82)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(82)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(86)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(86)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(86)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(58)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(58)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(58)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(9)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(9)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(9)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(8)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(41)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(8)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(41)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(8)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(41)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(9)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(9)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(9)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(8)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(41)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(8)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(41)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(8)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(41)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(7)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(7)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(7)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(62)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(62)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(62)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(66)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(66)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,108)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(66)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,109)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(9)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(9)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(42)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(8)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(42)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(8)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(42)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(9)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(9)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(42)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(8)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(42)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(8)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(42)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(7)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(7)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(7)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(46)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(46)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,111)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(46)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,112)
  Gcoeff = (c(9)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(9)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(9)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(8)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(43)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(8)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(43)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(8)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(43)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(9)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(9)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(9)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(8)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(43)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(8)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(43)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(8)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(43)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,120)
  Gcoeff = (c(7)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(7)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,122)
  Gcoeff = (c(7)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(50)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,113)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(50)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,114)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(50)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,115)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(54)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(54)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(54)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(9)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(9)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(44)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(8)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(44)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(8)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(44)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(9)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(9)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(44)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,138)
  Gcoeff = (c(8)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(44)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,139)
  Gcoeff = (c(8)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(44)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(7)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,144)
  Gcoeff = (c(7)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,145)
  Gcoeff = (c(7)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(9)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,150)
  Gcoeff = (c(9)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(9)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,152)
  Gcoeff = (c(8)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(45)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,156)
  Gcoeff = (c(8)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(45)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,157)
  Gcoeff = (c(8)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(45)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,158)
  Gcoeff = (c(9)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,150)
  Gcoeff = (c(9)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(9)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,152)
  Gcoeff = (c(8)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(45)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,162)
  Gcoeff = (c(8)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(45)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,163)
  Gcoeff = (c(8)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(45)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,164)
  Gcoeff = (c(7)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,168)
  Gcoeff = (c(7)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,169)
  Gcoeff = (c(7)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,170)
  Gcoeff = (c(9)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(49)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,174)
  Gcoeff = (c(8)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(49)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,175)
  Gcoeff = (c(9)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(49)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,174)
  Gcoeff = (c(8)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(49)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,176)
  Gcoeff = (c(7)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(49)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,177)
  Gcoeff = (c(9)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(47)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,178)
  Gcoeff = (c(8)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(47)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,179)
  Gcoeff = (c(9)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(47)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,178)
  Gcoeff = (c(8)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(47)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,180)
  Gcoeff = (c(7)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(47)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,181)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(47)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(53)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(53)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(53)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(53)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,141)
  Gcoeff = (c(7)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(53)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,147)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(51)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,182)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(51)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,183)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(51)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,182)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(51)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,184)
  Gcoeff = (c(7)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(51)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,185)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(51)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(9)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(57)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,153)
  Gcoeff = (c(8)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(57)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,159)
  Gcoeff = (c(9)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(57)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,153)
  Gcoeff = (c(8)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(57)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,165)
  Gcoeff = (c(7)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(57)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,171)
  Gcoeff = (c(9)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(55)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,186)
  Gcoeff = (c(8)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(55)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,187)
  Gcoeff = (c(9)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(55)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,186)
  Gcoeff = (c(8)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(55)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,188)
  Gcoeff = (c(7)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(55)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,189)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(55)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,125)
  Gcoeff = (c(9)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(61)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,190)
  Gcoeff = (c(8)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(61)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,191)
  Gcoeff = (c(9)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(61)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,190)
  Gcoeff = (c(8)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(61)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,192)
  Gcoeff = (c(7)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(61)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,193)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(61)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(9)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(59)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,194)
  Gcoeff = (c(8)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(59)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,195)
  Gcoeff = (c(9)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(59)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,194)
  Gcoeff = (c(8)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(59)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,196)
  Gcoeff = (c(7)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(59)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,197)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(59)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(65)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(65)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(65)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(65)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(7)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(65)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(63)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,198)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(63)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,199)
  Gcoeff = (c(9)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(63)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,198)
  Gcoeff = (c(8)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(63)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,200)
  Gcoeff = (c(7)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(63)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,201)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(63)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(9)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(69)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,154)
  Gcoeff = (c(8)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(69)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,160)
  Gcoeff = (c(9)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(69)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,154)
  Gcoeff = (c(8)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(69)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,166)
  Gcoeff = (c(7)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(69)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,172)
  Gcoeff = (c(9)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(67)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,202)
  Gcoeff = (c(8)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(67)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,203)
  Gcoeff = (c(9)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(67)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,202)
  Gcoeff = (c(8)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(67)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,204)
  Gcoeff = (c(7)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(67)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,205)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(67)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(9)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(73)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,206)
  Gcoeff = (c(8)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(73)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,207)
  Gcoeff = (c(9)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(73)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,206)
  Gcoeff = (c(8)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(73)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,208)
  Gcoeff = (c(7)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(73)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,209)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(73)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(9)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(71)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,210)
  Gcoeff = (c(8)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(71)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,211)
  Gcoeff = (c(9)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(71)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,210)
  Gcoeff = (c(8)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(71)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,212)
  Gcoeff = (c(7)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(71)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,213)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(71)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(77)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,214)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(77)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,215)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(77)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,214)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(77)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,216)
  Gcoeff = (c(7)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(77)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,217)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(77)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(75)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(75)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(9)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(75)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(8)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(75)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(7)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(75)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(9)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(81)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,155)
  Gcoeff = (c(8)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(81)
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,161)
  Gcoeff = (c(9)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(81)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,155)
  Gcoeff = (c(8)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(81)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,167)
  Gcoeff = (c(7)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(81)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,173)
  Gcoeff = (c(9)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(79)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,218)
  Gcoeff = (c(8)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(79)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,219)
  Gcoeff = (c(9)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(79)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,218)
  Gcoeff = (c(8)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(79)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,220)
  Gcoeff = (c(7)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(79)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,221)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(79)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(9)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(85)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(8)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(85)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(9)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(85)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(8)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(85)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(7)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(85)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(9)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(83)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,222)
  Gcoeff = (c(8)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(83)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,223)
  Gcoeff = (c(9)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(83)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,222)
  Gcoeff = (c(8)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(83)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,224)
  Gcoeff = (c(7)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(83)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,225)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(83)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(9)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(89)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(8)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(89)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(9)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(89)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(8)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(89)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(7)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(89)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(9)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(87)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,226)
  Gcoeff = (c(8)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(87)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,227)
  Gcoeff = (c(9)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(87)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,226)
  Gcoeff = (c(8)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(87)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,228)
  Gcoeff = (c(7)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(87)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,229)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(87)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(9)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(93)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,230)
  Gcoeff = (c(8)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(93)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,231)
  Gcoeff = (c(9)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(93)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,230)
  Gcoeff = (c(8)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(93)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,232)
  Gcoeff = (c(7)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(93)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,233)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(93)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(9)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(91)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(8)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(91)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(9)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(91)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(8)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(91)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(7)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(91)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(9)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(97)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(8)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(97)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(9)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(97)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(8)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(97)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,143)
  Gcoeff = (c(7)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(97)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,149)
  Gcoeff = (c(9)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(95)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,234)
  Gcoeff = (c(8)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(95)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,235)
  Gcoeff = (c(9)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(95)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,234)
  Gcoeff = (c(8)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(95)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,236)
  Gcoeff = (c(7)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(95)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,237)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(95)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(9)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(101)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,238)
  Gcoeff = (c(8)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(101)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,239)
  Gcoeff = (c(9)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(101)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,238)
  Gcoeff = (c(8)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(101)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,240)
  Gcoeff = (c(7)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(101)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,241)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(101)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(9)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(99)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(8)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(99)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(9)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(99)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(8)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(99)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(7)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(99)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(9)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(105)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,242)
  Gcoeff = (c(8)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(105)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,243)
  Gcoeff = (c(9)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(105)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,242)
  Gcoeff = (c(8)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(105)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,244)
  Gcoeff = (c(7)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(105)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,245)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(105)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(9)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(103)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(8)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(103)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(9)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(103)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(8)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(103)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(7)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(103)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,110)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_7

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_7_ppjjj_ggggg_1_/**/REALKIND
