
module ol_vamp_6_ppjjj_ggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_6(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ggggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppjjj_ggggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppjjj_ggggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(44)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,183) :: G0
  complex(REALKIND), dimension(4,5,4,45) :: G1
  complex(REALKIND), dimension(1,45) :: G0tensor
  complex(REALKIND), dimension(5,347) :: G1tensor
  complex(REALKIND), dimension(15,55) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,38),G1tensor(:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,39),G1tensor(:,2))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,40),G1tensor(:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,38),wf(:,-3),G1tensor(:,4))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,39),wf(:,-3),G1tensor(:,5))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,40),wf(:,-3),G1tensor(:,6))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,38),G1tensor(:,7))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,39),G1tensor(:,8))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,40),G1tensor(:,9))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,34),G1tensor(:,10))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,35),G1tensor(:,11))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,36),G1tensor(:,12))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,34),wf(:,-2),G1tensor(:,13))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,35),wf(:,-2),G1tensor(:,14))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,36),wf(:,-2),G1tensor(:,15))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,34),G1tensor(:,16))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,35),G1tensor(:,17))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,36),G1tensor(:,18))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,26),G1tensor(:,19))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,27),G1tensor(:,20))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,28),G1tensor(:,21))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,26),wf(:,-1),G1tensor(:,22))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,27),wf(:,-1),G1tensor(:,23))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,28),wf(:,-1),G1tensor(:,24))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,26),G1tensor(:,25))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,27),G1tensor(:,26))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,28),G1tensor(:,27))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,0),wf(:,14),G1tensor(:,28))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,14),wf(:,0),G1tensor(:,29))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,0),wf(:,14),G1tensor(:,30))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,0),wf(:,15),G1tensor(:,31))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,15),wf(:,0),G1tensor(:,32))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,0),wf(:,15),G1tensor(:,33))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,0),wf(:,16),G1tensor(:,34))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,16),wf(:,0),G1tensor(:,35))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,0),wf(:,16),G1tensor(:,36))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,1),wf(:,29),G1tensor(:,37))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,29),wf(:,1),G1tensor(:,38))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,1),wf(:,29),G1tensor(:,39))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,43),G1tensor(:,40))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,43),wf(:,-3),G1tensor(:,41))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,43),G1tensor(:,42))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,42),G1tensor(:,43))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,42),wf(:,-2),G1tensor(:,44))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,42),G1tensor(:,45))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,5),wf(:,21),G1tensor(:,46))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,21),wf(:,5),G1tensor(:,47))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,5),wf(:,21),G1tensor(:,48))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,46),G1tensor(:,49))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,46),wf(:,-3),G1tensor(:,50))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,46),G1tensor(:,51))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,9),wf(:,17),G1tensor(:,52))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,17),wf(:,9),G1tensor(:,53))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,9),wf(:,17),G1tensor(:,54))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,49),G1tensor(:,55))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,49),wf(:,-3),G1tensor(:,56))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,49),G1tensor(:,57))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,51),G1tensor(:,58))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,51),wf(:,-2),G1tensor(:,59))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,51),G1tensor(:,60))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,53),G1tensor(:,61))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,53),wf(:,-2),G1tensor(:,62))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-2),wf(:,53),G1tensor(:,63))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,45),G1tensor(:,64))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,45),wf(:,-1),G1tensor(:,65))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,45),G1tensor(:,66))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,50),G1tensor(:,67))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,50),wf(:,-1),G1tensor(:,68))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,50),G1tensor(:,69))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,150),G1tensor(:,70))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,150),wf(:,-1),G1tensor(:,71))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-1),wf(:,150),G1tensor(:,72))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,0),wf(:,143),G1tensor(:,73))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,143),wf(:,0),G1tensor(:,74))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,0),wf(:,143),G1tensor(:,75))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,0),wf(:,147),G1tensor(:,76))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,147),wf(:,0),G1tensor(:,77))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,0),wf(:,147),G1tensor(:,78))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,0),wf(:,149),G1tensor(:,79))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,149),wf(:,0),G1tensor(:,80))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,0),wf(:,149),G1tensor(:,81))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,37),G0(:,:,:,2))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,-1),wf(:,0),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,0),wf(:,-1),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,2),wf(:,-1),wf(:,0),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,82))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,-2),G0(:,:,:,3))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,3),wf(:,-1),wf(:,0),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,3),wf(:,0),wf(:,-1),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,3),wf(:,-1),wf(:,0),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,3),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,83))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,37),G0(:,:,:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,4),wf(:,-1),wf(:,0),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,4),wf(:,0),wf(:,-1),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,4),wf(:,-1),wf(:,0),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,84))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,30),G0(:,:,:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,85))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,31),G0(:,:,:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,86))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,32),G0(:,:,:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,87))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,30),wf(:,-2),G0(:,:,:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,88))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,31),wf(:,-2),G0(:,:,:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,89))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,-2),G0(:,:,:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,90))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,30),G0(:,:,:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,11),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,91))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,31),G0(:,:,:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,92))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,32),G0(:,:,:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,93))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,30),Q(:,19),G1(:,:,:,2))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-3),wf(:,-2),G1tensor(:,94))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,-2),wf(:,-3),G1tensor(:,95))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,-3),wf(:,-2),G1tensor(:,96))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,1))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,31),Q(:,19),G1(:,:,:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-3),wf(:,-2),G1tensor(:,97))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,3),wf(:,-2),wf(:,-3),G1tensor(:,98))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,3),wf(:,-3),wf(:,-2),G1tensor(:,99))
  call check_last_UV_W(l_switch,G1(:,:,:,3),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,2))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,32),Q(:,19),G1(:,:,:,4))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,4),wf(:,-3),wf(:,-2),G1tensor(:,100))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,4),wf(:,-2),wf(:,-3),G1tensor(:,101))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,4),wf(:,-3),wf(:,-2),G1tensor(:,102))
  call check_last_UV_W(l_switch,G1(:,:,:,4),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,3))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,28),G1(:,:,:,5))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,5),wf(:,-1),wf(:,0),G1tensor(:,103))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,5),wf(:,0),wf(:,-1),G1tensor(:,104))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,5),wf(:,-1),wf(:,0),G1tensor(:,105))
  call check_last_UV_W(l_switch,G1(:,:,:,5),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,4))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,28),G1(:,:,:,6))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,6),wf(:,-1),wf(:,0),G1tensor(:,106))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,6),wf(:,0),wf(:,-1),G1tensor(:,107))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,6),wf(:,-1),wf(:,0),G1tensor(:,108))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,5))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,28),G1(:,:,:,7))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,7),wf(:,-1),wf(:,0),G1tensor(:,109))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,7),wf(:,0),wf(:,-1),G1tensor(:,110))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,7),wf(:,-1),wf(:,0),G1tensor(:,111))
  call check_last_UV_W(l_switch,G1(:,:,:,7),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,6))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,33),G0(:,:,:,14))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,-3),wf(:,0),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,0),wf(:,-3),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,14),wf(:,-3),wf(:,0),G0tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,112))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,33),wf(:,-1),G0(:,:,:,15))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,0),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,0),wf(:,-3),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,0),G0tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,113))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,33),G0(:,:,:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,-3),wf(:,0),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,0),wf(:,-3),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,16),wf(:,-3),wf(:,0),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,114))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,18),G0(:,:,:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,115))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,19),G0(:,:,:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,116))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,20),G0(:,:,:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,117))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,18),wf(:,-1),G0(:,:,:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,118))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,19),wf(:,-1),G0(:,:,:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,119))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,-1),G0(:,:,:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,120))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,18),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,121))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,19),G0(:,:,:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,122))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,20),G0(:,:,:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,123))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,33),G0(:,:,:,26))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-3),wf(:,-1),G0tensor(:,19))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-1),wf(:,-3),G0tensor(:,20))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-3),wf(:,-1),G0tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,124))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,33),wf(:,0),G0(:,:,:,27))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-3),wf(:,-1),G0tensor(:,22))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-1),wf(:,-3),G0tensor(:,23))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,27),wf(:,-3),wf(:,-1),G0tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,125))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,33),G0(:,:,:,28))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,-3),wf(:,-1),G0tensor(:,25))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,28),wf(:,-1),wf(:,-3),G0tensor(:,26))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,28),wf(:,-3),wf(:,-1),G0tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,126))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,6),G0(:,:,:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,127))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,0),G0(:,:,:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,128))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,6),G0(:,:,:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,129))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,7),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,130))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,0),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,131))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,7),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,132))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,8),G0(:,:,:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,133))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,8),wf(:,0),G0(:,:,:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,134))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,8),G0(:,:,:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,135))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,37),G0(:,:,:,38))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,38),wf(:,-2),wf(:,0),G0tensor(:,28))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,38),wf(:,0),wf(:,-2),G0tensor(:,29))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,38),wf(:,-2),wf(:,0),G0tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,136))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,-1),G0(:,:,:,39))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,39),wf(:,-2),wf(:,0),G0tensor(:,31))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,39),wf(:,0),wf(:,-2),G0tensor(:,32))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,39),wf(:,-2),wf(:,0),G0tensor(:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,137))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,37),G0(:,:,:,40))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,40),wf(:,-2),wf(:,0),G0tensor(:,34))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,40),wf(:,0),wf(:,-2),G0tensor(:,35))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,40),wf(:,-2),wf(:,0),G0tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,138))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,22),G0(:,:,:,41))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,139))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,23),G0(:,:,:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,140))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,24),G0(:,:,:,43))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,141))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,22),wf(:,-1),G0(:,:,:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,142))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,23),wf(:,-1),G0(:,:,:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,143))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,-1),G0(:,:,:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,144))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,22),G0(:,:,:,47))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,145))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,23),G0(:,:,:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,146))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,24),G0(:,:,:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,49),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,147))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,22),Q(:,21),G1(:,:,:,8))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,8),wf(:,-3),wf(:,-1),G1tensor(:,148))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,8),wf(:,-1),wf(:,-3),G1tensor(:,149))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,8),wf(:,-3),wf(:,-1),G1tensor(:,150))
  call check_last_UV_W(l_switch,G1(:,:,:,8),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,7))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,23),Q(:,21),G1(:,:,:,9))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,9),wf(:,-3),wf(:,-1),G1tensor(:,151))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,9),wf(:,-1),wf(:,-3),G1tensor(:,152))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,9),wf(:,-3),wf(:,-1),G1tensor(:,153))
  call check_last_UV_W(l_switch,G1(:,:,:,9),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,8))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,24),Q(:,21),G1(:,:,:,10))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,10),wf(:,-3),wf(:,-1),G1tensor(:,154))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,10),wf(:,-1),wf(:,-3),G1tensor(:,155))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,10),wf(:,-3),wf(:,-1),G1tensor(:,156))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,21),wf(:,21),Q(:,10),G2tensor(:,9))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,26),G1(:,:,:,11))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,11),wf(:,-2),wf(:,0),G1tensor(:,157))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,11),wf(:,0),wf(:,-2),G1tensor(:,158))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,11),wf(:,-2),wf(:,0),G1tensor(:,159))
  call check_last_UV_W(l_switch,G1(:,:,:,11),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,10))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,26),G1(:,:,:,12))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,12),wf(:,-2),wf(:,0),G1tensor(:,160))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,12),wf(:,0),wf(:,-2),G1tensor(:,161))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,12),wf(:,-2),wf(:,0),G1tensor(:,162))
  call check_last_UV_W(l_switch,G1(:,:,:,12),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,11))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,8),Q(:,26),G1(:,:,:,13))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,13),wf(:,-2),wf(:,0),G1tensor(:,163))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,13),wf(:,0),wf(:,-2),G1tensor(:,164))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,13),wf(:,-2),wf(:,0),G1tensor(:,165))
  call check_last_UV_W(l_switch,G1(:,:,:,13),Q(:,26),wf(:,5),Q(:,5),G2tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,37),G0(:,:,:,50))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,50),wf(:,-2),wf(:,-1),G0tensor(:,37))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,50),wf(:,-1),wf(:,-2),G0tensor(:,38))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,50),wf(:,-2),wf(:,-1),G0tensor(:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,166))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,0),G0(:,:,:,51))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,51),wf(:,-2),wf(:,-1),G0tensor(:,40))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,51),wf(:,-1),wf(:,-2),G0tensor(:,41))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,51),wf(:,-2),wf(:,-1),G0tensor(:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,167))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,37),G0(:,:,:,52))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,52),wf(:,-2),wf(:,-1),G0tensor(:,43))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,52),wf(:,-1),wf(:,-2),G0tensor(:,44))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,52),wf(:,-2),wf(:,-1),G0tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,52),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,168))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,10),G0(:,:,:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,53),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,169))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,10),wf(:,0),G0(:,:,:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,54),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,170))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,10),G0(:,:,:,55))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,171))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,11),G0(:,:,:,56))
  call check_last_UV_W(l_switch,G0(:,:,:,56),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,172))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,0),G0(:,:,:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,173))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,11),G0(:,:,:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,58),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,174))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,12),G0(:,:,:,59))
  call check_last_UV_W(l_switch,G0(:,:,:,59),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,175))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,12),wf(:,0),G0(:,:,:,60))
  call check_last_UV_W(l_switch,G0(:,:,:,60),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,176))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,12),G0(:,:,:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,177))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,18),Q(:,25),G1(:,:,:,14))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,14),wf(:,-2),wf(:,-1),G1tensor(:,178))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,14),wf(:,-1),wf(:,-2),G1tensor(:,179))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,14),wf(:,-2),wf(:,-1),G1tensor(:,180))
  call check_last_UV_W(l_switch,G1(:,:,:,14),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,13))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,19),Q(:,25),G1(:,:,:,15))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,15),wf(:,-2),wf(:,-1),G1tensor(:,181))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,15),wf(:,-1),wf(:,-2),G1tensor(:,182))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,15),wf(:,-2),wf(:,-1),G1tensor(:,183))
  call check_last_UV_W(l_switch,G1(:,:,:,15),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,14))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,20),Q(:,25),G1(:,:,:,16))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,16),wf(:,-2),wf(:,-1),G1tensor(:,184))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,16),wf(:,-1),wf(:,-2),G1tensor(:,185))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,16),wf(:,-2),wf(:,-1),G1tensor(:,186))
  call check_last_UV_W(l_switch,G1(:,:,:,16),Q(:,25),wf(:,17),Q(:,6),G2tensor(:,15))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,22),G1(:,:,:,17))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,17),wf(:,-3),wf(:,0),G1tensor(:,187))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,17),wf(:,0),wf(:,-3),G1tensor(:,188))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,17),wf(:,-3),wf(:,0),G1tensor(:,189))
  call check_last_UV_W(l_switch,G1(:,:,:,17),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,16))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,22),G1(:,:,:,18))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,-3),wf(:,0),G1tensor(:,190))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,18),wf(:,0),wf(:,-3),G1tensor(:,191))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,18),wf(:,-3),wf(:,0),G1tensor(:,192))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,17))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,22),G1(:,:,:,19))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,19),wf(:,-3),wf(:,0),G1tensor(:,193))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,19),wf(:,0),wf(:,-3),G1tensor(:,194))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,19),wf(:,-3),wf(:,0),G1tensor(:,195))
  call check_last_UV_W(l_switch,G1(:,:,:,19),Q(:,22),wf(:,9),Q(:,9),G2tensor(:,18))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,33),G0(:,:,:,62))
  call check_last_UV_W(l_switch,G0(:,:,:,62),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,196))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,33),wf(:,1),G0(:,:,:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,197))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,33),G0(:,:,:,64))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,198))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,37),G0(:,:,:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,199))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,1),G0(:,:,:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,66),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,200))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,37),G0(:,:,:,67))
  call check_last_UV_W(l_switch,G0(:,:,:,67),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,201))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,43),G0(:,:,:,68))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,202))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,43),wf(:,-4),G0(:,:,:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,203))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,43),G0(:,:,:,70))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,204))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,42),G0(:,:,:,71))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,205))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,42),wf(:,-4),G0(:,:,:,72))
  call check_last_UV_W(l_switch,G0(:,:,:,72),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,206))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,42),G0(:,:,:,73))
  call check_last_UV_W(l_switch,G0(:,:,:,73),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,207))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,33),Q(:,20),G1(:,:,:,20))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,-3),wf(:,1),G1tensor(:,208))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,1),wf(:,-3),G1tensor(:,209))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,20),wf(:,-3),wf(:,1),G1tensor(:,210))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,-1),wf(:,9),G1tensor(:,211))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,9),wf(:,-1),G1tensor(:,212))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,20),wf(:,-1),wf(:,9),G1tensor(:,213))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,0),wf(:,21),G1tensor(:,214))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,20),wf(:,21),wf(:,0),G1tensor(:,215))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,20),wf(:,0),wf(:,21),G1tensor(:,216))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,20),wf(:,34),Q(:,11),G2tensor(:,19))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,20),wf(:,35),Q(:,11),G2tensor(:,20))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,20),wf(:,36),Q(:,11),G2tensor(:,21))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,20),wf(:,42),Q(:,11),G2tensor(:,22))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,20),wf(:,51),Q(:,11),G2tensor(:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,20),wf(:,53),Q(:,11),G2tensor(:,24))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,41),G0(:,:,:,74))
  call check_last_UV_W(l_switch,G0(:,:,:,74),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,217))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,41),wf(:,-3),G0(:,:,:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,218))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,41),G0(:,:,:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,219))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,37),Q(:,24),G1(:,:,:,21))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,-2),wf(:,1),G1tensor(:,220))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,1),wf(:,-2),G1tensor(:,221))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,21),wf(:,-2),wf(:,1),G1tensor(:,222))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,-1),wf(:,5),G1tensor(:,223))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,5),wf(:,-1),G1tensor(:,224))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,21),wf(:,-1),wf(:,5),G1tensor(:,225))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,0),wf(:,17),G1tensor(:,226))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,21),wf(:,17),wf(:,0),G1tensor(:,227))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,21),wf(:,0),wf(:,17),G1tensor(:,228))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,24),wf(:,38),Q(:,7),G2tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,24),wf(:,39),Q(:,7),G2tensor(:,26))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,24),wf(:,40),Q(:,7),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,24),wf(:,43),Q(:,7),G2tensor(:,28))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,24),wf(:,46),Q(:,7),G2tensor(:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,24),wf(:,49),Q(:,7),G2tensor(:,30))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,41),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,229))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,41),wf(:,-2),G0(:,:,:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,78),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,230))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,41),G0(:,:,:,79))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,231))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,41),Q(:,19),G1(:,:,:,22))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,22),wf(:,-3),wf(:,-2),G1tensor(:,232))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,22),wf(:,-2),wf(:,-3),G1tensor(:,233))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,22),wf(:,-3),wf(:,-2),G1tensor(:,234))
  call check_last_UV_W(l_switch,G1(:,:,:,22),Q(:,19),wf(:,29),Q(:,12),G2tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,80))
  call loop_Q_A(G0(:,:,:,80),Q(:,28),ZERO,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,1),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,31),ZERO,G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,81))
  call loop_Q_A(G0(:,:,:,81),Q(:,28),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,1),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,31),ZERO,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,82))
  call loop_Q_A(G0(:,:,:,82),Q(:,28),ZERO,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,1),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,31),ZERO,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,83))
  call loop_Q_A(G0(:,:,:,83),Q(:,28),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,1),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,31),MT,G2tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,84))
  call loop_Q_A(G0(:,:,:,84),Q(:,28),MT,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,1),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,31),MT,G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,85))
  call loop_Q_A(G0(:,:,:,85),Q(:,28),MT,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,31),MT,G2tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,86))
  call loop_Q_A(G0(:,:,:,86),Q(:,28),MB,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,1),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,31),MB,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,87))
  call loop_Q_A(G0(:,:,:,87),Q(:,28),MB,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,1),G1(:,:,:,38))
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,31),MB,G2tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,4),G0(:,:,:,88))
  call loop_Q_A(G0(:,:,:,88),Q(:,28),MB,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,1),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,31),MB,G2tensor(:,40))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,28),G1(:,:,:,41))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,41))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,28),G1(:,:,:,42))
  call check_last_CV_D(l_switch,G1(:,:,:,42),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,42))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,28),G1(:,:,:,43))
  call check_last_CV_D(l_switch,G1(:,:,:,43),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,43))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,5),wf(:,25),G0(:,:,:,89))
  call check_last_UV_W(l_switch,G0(:,:,:,89),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,235))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,5),G0(:,:,:,90))
  call check_last_UV_W(l_switch,G0(:,:,:,90),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,236))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,5),wf(:,25),G0(:,:,:,91))
  call check_last_UV_W(l_switch,G0(:,:,:,91),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,237))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,5),wf(:,37),G0(:,:,:,92))
  call check_last_UV_W(l_switch,G0(:,:,:,92),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,238))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,5),G0(:,:,:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,93),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,239))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,5),wf(:,37),G0(:,:,:,94))
  call check_last_UV_W(l_switch,G0(:,:,:,94),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,240))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,46),G0(:,:,:,95))
  call check_last_UV_W(l_switch,G0(:,:,:,95),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,241))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,46),wf(:,-4),G0(:,:,:,96))
  call check_last_UV_W(l_switch,G0(:,:,:,96),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,242))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,46),G0(:,:,:,97))
  call check_last_UV_W(l_switch,G0(:,:,:,97),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,243))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,45),G0(:,:,:,98))
  call check_last_UV_W(l_switch,G0(:,:,:,98),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,244))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,-4),G0(:,:,:,99))
  call check_last_UV_W(l_switch,G0(:,:,:,99),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,245))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,45),G0(:,:,:,100))
  call check_last_UV_W(l_switch,G0(:,:,:,100),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,246))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,25),Q(:,18),G1(:,:,:,44))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,44),wf(:,-3),wf(:,5),G1tensor(:,247))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,44),wf(:,5),wf(:,-3),G1tensor(:,248))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,44),wf(:,-3),wf(:,5),G1tensor(:,249))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,44),wf(:,-2),wf(:,9),G1tensor(:,250))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,44),wf(:,9),wf(:,-2),G1tensor(:,251))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,44),wf(:,-2),wf(:,9),G1tensor(:,252))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,44),wf(:,0),wf(:,29),G1tensor(:,253))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,44),wf(:,29),wf(:,0),G1tensor(:,254))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,44),wf(:,0),wf(:,29),G1tensor(:,255))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,18),wf(:,26),Q(:,13),G2tensor(:,44))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,18),wf(:,27),Q(:,13),G2tensor(:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,18),wf(:,28),Q(:,13),G2tensor(:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,18),wf(:,45),Q(:,13),G2tensor(:,47))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,18),wf(:,50),Q(:,13),G2tensor(:,48))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,18),wf(:,150),Q(:,13),G2tensor(:,49))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,44),G0(:,:,:,101))
  call check_last_UV_W(l_switch,G0(:,:,:,101),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,256))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,-3),G0(:,:,:,102))
  call check_last_UV_W(l_switch,G0(:,:,:,102),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,257))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,44),G0(:,:,:,103))
  call check_last_UV_W(l_switch,G0(:,:,:,103),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,258))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,17),G0(:,:,:,104))
  call check_last_UV_W(l_switch,G0(:,:,:,104),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,259))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,17),wf(:,13),G0(:,:,:,105))
  call check_last_UV_W(l_switch,G0(:,:,:,105),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,260))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,13),wf(:,17),G0(:,:,:,106))
  call check_last_UV_W(l_switch,G0(:,:,:,106),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,261))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,17),wf(:,37),G0(:,:,:,107))
  call check_last_UV_W(l_switch,G0(:,:,:,107),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,262))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,37),wf(:,17),G0(:,:,:,108))
  call check_last_UV_W(l_switch,G0(:,:,:,108),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,263))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,17),wf(:,37),G0(:,:,:,109))
  call check_last_UV_W(l_switch,G0(:,:,:,109),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,264))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,49),G0(:,:,:,110))
  call check_last_UV_W(l_switch,G0(:,:,:,110),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,265))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,49),wf(:,-4),G0(:,:,:,111))
  call check_last_UV_W(l_switch,G0(:,:,:,111),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,266))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,49),G0(:,:,:,112))
  call check_last_UV_W(l_switch,G0(:,:,:,112),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,267))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,143),G0(:,:,:,113))
  call check_last_UV_W(l_switch,G0(:,:,:,113),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,268))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,143),wf(:,-4),G0(:,:,:,114))
  call check_last_UV_W(l_switch,G0(:,:,:,114),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,269))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,143),G0(:,:,:,115))
  call check_last_UV_W(l_switch,G0(:,:,:,115),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,270))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,13),Q(:,17),G1(:,:,:,45))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,45),wf(:,-3),wf(:,17),G1tensor(:,271))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,45),wf(:,17),wf(:,-3),G1tensor(:,272))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,45),wf(:,-3),wf(:,17),G1tensor(:,273))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,45),wf(:,-2),wf(:,21),G1tensor(:,274))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,45),wf(:,21),wf(:,-2),G1tensor(:,275))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,45),wf(:,-2),wf(:,21),G1tensor(:,276))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,45),wf(:,-1),wf(:,29),G1tensor(:,277))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,45),wf(:,29),wf(:,-1),G1tensor(:,278))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,45),wf(:,-1),wf(:,29),G1tensor(:,279))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,17),wf(:,14),Q(:,14),G2tensor(:,50))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,17),wf(:,15),Q(:,14),G2tensor(:,51))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,17),wf(:,16),Q(:,14),G2tensor(:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,17),wf(:,143),Q(:,14),G2tensor(:,53))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,17),wf(:,147),Q(:,14),G2tensor(:,54))
  call check_last_UV_W(l_switch,G1(:,:,:,45),Q(:,17),wf(:,149),Q(:,14),G2tensor(:,55))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,142),G0(:,:,:,116))
  call check_last_UV_W(l_switch,G0(:,:,:,116),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,280))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,142),wf(:,-3),G0(:,:,:,117))
  call check_last_UV_W(l_switch,G0(:,:,:,117),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,281))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,142),G0(:,:,:,118))
  call check_last_UV_W(l_switch,G0(:,:,:,118),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,282))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,9),wf(:,25),G0(:,:,:,119))
  call check_last_UV_W(l_switch,G0(:,:,:,119),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,283))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,9),G0(:,:,:,120))
  call check_last_UV_W(l_switch,G0(:,:,:,120),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,284))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,9),wf(:,25),G0(:,:,:,121))
  call check_last_UV_W(l_switch,G0(:,:,:,121),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,285))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,9),wf(:,33),G0(:,:,:,122))
  call check_last_UV_W(l_switch,G0(:,:,:,122),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,286))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,33),wf(:,9),G0(:,:,:,123))
  call check_last_UV_W(l_switch,G0(:,:,:,123),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,287))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,9),wf(:,33),G0(:,:,:,124))
  call check_last_UV_W(l_switch,G0(:,:,:,124),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,288))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,51),G0(:,:,:,125))
  call check_last_UV_W(l_switch,G0(:,:,:,125),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,289))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,51),wf(:,-4),G0(:,:,:,126))
  call check_last_UV_W(l_switch,G0(:,:,:,126),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,290))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,51),G0(:,:,:,127))
  call check_last_UV_W(l_switch,G0(:,:,:,127),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,291))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,50),G0(:,:,:,128))
  call check_last_UV_W(l_switch,G0(:,:,:,128),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,292))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,50),wf(:,-4),G0(:,:,:,129))
  call check_last_UV_W(l_switch,G0(:,:,:,129),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,293))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,50),G0(:,:,:,130))
  call check_last_UV_W(l_switch,G0(:,:,:,130),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,294))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,21),G0(:,:,:,131))
  call check_last_UV_W(l_switch,G0(:,:,:,131),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,295))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,21),wf(:,13),G0(:,:,:,132))
  call check_last_UV_W(l_switch,G0(:,:,:,132),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,296))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,13),wf(:,21),G0(:,:,:,133))
  call check_last_UV_W(l_switch,G0(:,:,:,133),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,297))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,21),wf(:,33),G0(:,:,:,134))
  call check_last_UV_W(l_switch,G0(:,:,:,134),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,298))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,33),wf(:,21),G0(:,:,:,135))
  call check_last_UV_W(l_switch,G0(:,:,:,135),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,299))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,21),wf(:,33),G0(:,:,:,136))
  call check_last_UV_W(l_switch,G0(:,:,:,136),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,300))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,53),G0(:,:,:,137))
  call check_last_UV_W(l_switch,G0(:,:,:,137),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,301))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,53),wf(:,-4),G0(:,:,:,138))
  call check_last_UV_W(l_switch,G0(:,:,:,138),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,302))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,53),G0(:,:,:,139))
  call check_last_UV_W(l_switch,G0(:,:,:,139),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,303))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,147),G0(:,:,:,140))
  call check_last_UV_W(l_switch,G0(:,:,:,140),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,304))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,147),wf(:,-4),G0(:,:,:,141))
  call check_last_UV_W(l_switch,G0(:,:,:,141),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,305))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,147),G0(:,:,:,142))
  call check_last_UV_W(l_switch,G0(:,:,:,142),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,306))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,29),G0(:,:,:,143))
  call check_last_UV_W(l_switch,G0(:,:,:,143),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,307))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,29),wf(:,13),G0(:,:,:,144))
  call check_last_UV_W(l_switch,G0(:,:,:,144),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,308))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,13),wf(:,29),G0(:,:,:,145))
  call check_last_UV_W(l_switch,G0(:,:,:,145),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,309))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,29),G0(:,:,:,146))
  call check_last_UV_W(l_switch,G0(:,:,:,146),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,310))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,29),wf(:,25),G0(:,:,:,147))
  call check_last_UV_W(l_switch,G0(:,:,:,147),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,311))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,25),wf(:,29),G0(:,:,:,148))
  call check_last_UV_W(l_switch,G0(:,:,:,148),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,312))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,150),G0(:,:,:,149))
  call check_last_UV_W(l_switch,G0(:,:,:,149),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,313))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,150),wf(:,-4),G0(:,:,:,150))
  call check_last_UV_W(l_switch,G0(:,:,:,150),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,314))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,150),G0(:,:,:,151))
  call check_last_UV_W(l_switch,G0(:,:,:,151),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,315))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,149),G0(:,:,:,152))
  call check_last_UV_W(l_switch,G0(:,:,:,152),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,316))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,149),wf(:,-4),G0(:,:,:,153))
  call check_last_UV_W(l_switch,G0(:,:,:,153),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,317))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,149),G0(:,:,:,154))
  call check_last_UV_W(l_switch,G0(:,:,:,154),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,318))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,54),G0(:,:,:,155))
  call check_last_UV_W(l_switch,G0(:,:,:,155),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,319))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,54),wf(:,-3),G0(:,:,:,156))
  call check_last_UV_W(l_switch,G0(:,:,:,156),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,320))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,54),G0(:,:,:,157))
  call check_last_UV_W(l_switch,G0(:,:,:,157),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,321))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,52),G0(:,:,:,158))
  call check_last_UV_W(l_switch,G0(:,:,:,158),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,322))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,52),wf(:,-3),G0(:,:,:,159))
  call check_last_UV_W(l_switch,G0(:,:,:,159),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,323))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,52),G0(:,:,:,160))
  call check_last_UV_W(l_switch,G0(:,:,:,160),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,324))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,55),G0(:,:,:,161))
  call check_last_UV_W(l_switch,G0(:,:,:,161),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,325))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,55),wf(:,-3),G0(:,:,:,162))
  call check_last_UV_W(l_switch,G0(:,:,:,162),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,326))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,55),G0(:,:,:,163))
  call check_last_UV_W(l_switch,G0(:,:,:,163),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,327))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,145),G0(:,:,:,164))
  call check_last_UV_W(l_switch,G0(:,:,:,164),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,328))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,145),wf(:,-3),G0(:,:,:,165))
  call check_last_UV_W(l_switch,G0(:,:,:,165),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,329))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,145),G0(:,:,:,166))
  call check_last_UV_W(l_switch,G0(:,:,:,166),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,330))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,148),G0(:,:,:,167))
  call check_last_UV_W(l_switch,G0(:,:,:,167),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,331))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,148),wf(:,-3),G0(:,:,:,168))
  call check_last_UV_W(l_switch,G0(:,:,:,168),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,332))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,148),G0(:,:,:,169))
  call check_last_UV_W(l_switch,G0(:,:,:,169),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,333))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,146),G0(:,:,:,170))
  call check_last_UV_W(l_switch,G0(:,:,:,170),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,334))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,146),wf(:,-3),G0(:,:,:,171))
  call check_last_UV_W(l_switch,G0(:,:,:,171),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,335))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,146),G0(:,:,:,172))
  call check_last_UV_W(l_switch,G0(:,:,:,172),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,336))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,47),G0(:,:,:,173))
  call check_last_UV_W(l_switch,G0(:,:,:,173),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,337))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,47),wf(:,-2),G0(:,:,:,174))
  call check_last_UV_W(l_switch,G0(:,:,:,174),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,338))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,47),G0(:,:,:,175))
  call check_last_UV_W(l_switch,G0(:,:,:,175),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,339))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,139),G0(:,:,:,176))
  call check_last_UV_W(l_switch,G0(:,:,:,176),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,340))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,139),wf(:,-2),G0(:,:,:,177))
  call check_last_UV_W(l_switch,G0(:,:,:,177),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,341))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,139),G0(:,:,:,178))
  call check_last_UV_W(l_switch,G0(:,:,:,178),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,342))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,54),G0(:,:,:,179))
  call check_last_UV_W(l_switch,G0(:,:,:,179),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,343))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,54),wf(:,-2),G0(:,:,:,180))
  call check_last_UV_W(l_switch,G0(:,:,:,180),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,344))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,54),G0(:,:,:,181))
  call check_last_UV_W(l_switch,G0(:,:,:,181),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,345))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,48),G0(:,:,:,182))
  call check_last_UV_W(l_switch,G0(:,:,:,182),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,346))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,48),wf(:,-2),G0(:,:,:,183))
  call check_last_UV_W(l_switch,G0(:,:,:,183),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,347))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(26)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(24)+M(26)-M(30)+M(32))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(21)+M(22)-M(38)+M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(21)+M(22)-M(38)+M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(24)+M(26)-M(30)+M(32))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(10)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(28)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(27)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(28)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,108)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,109)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(35)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,111)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(22)+M(25)-M(36)+M(38))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,10)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(31)-M(33)+M(34)+M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(31)-M(33)+M(34)+M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(22)+M(25)-M(36)+M(38))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(9)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,115)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,119)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,120)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,121)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,122)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(31)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,123)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(23)+M(24)-M(32)+M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,19)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(31)-M(33)+M(34)+M(41))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,22)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,25)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(31)-M(33)+M(34)+M(41))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,20)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(23)+M(24)-M(32)+M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,23)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,26)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,21)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,24)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(9)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,27)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,127)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,128)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,129)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,130)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,131)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,132)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,133)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,134)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(34)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,135)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(24)+M(26)-M(30)+M(32))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,28)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(27)+M(28)-M(37)+M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,29)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,30)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(27)+M(28)-M(37)+M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,31)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(24)+M(26)-M(30)+M(32))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,32)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,33)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,34)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,35)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(10)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,36)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,139)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,140)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,141)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,142)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,143)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,144)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,145)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,146)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(30)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,147)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(29)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,148)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,151)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,154)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,149)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,152)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,155)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,150)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,153)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(30)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,156)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,157)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,158)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,159)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,160)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,161)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,162)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,163)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,164)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(34)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,165)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(21)+M(22)-M(38)+M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,37)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(27)+M(28)-M(37)+M(43))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,40)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,43)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(27)+M(28)-M(37)+M(43))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,38)
  Gcoeff = (c(1)*(-M(9)+M(12)-M(16)+M(18)-M(19)+M(20))+c(2)*(-M(21)+M(22)-M(38)+M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,41)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,44)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,39)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,42)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(10)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,45)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,169)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,170)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,171)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,172)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,173)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,174)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,175)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,176)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(33)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,177)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,178)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,181)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,184)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,179)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,182)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,185)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,180)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,183)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(31)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,186)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,187)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,188)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,189)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,190)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,191)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,192)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,193)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,194)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(33)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,195)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(32)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(11)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(11)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(11)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(12)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,196)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(12)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,197)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(12)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,198)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(13)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,199)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(13)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,200)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(13)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,201)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(56)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,202)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(56)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,203)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(56)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,204)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(52)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,205)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(52)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,206)
  Gcoeff = (c(3)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(52)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,207)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(12)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,208)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(12)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,209)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(12)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,210)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(56)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(56)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(56)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(48)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,217)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(48)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,218)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(48)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,219)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(13)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(13)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(13)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(13)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,220)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(13)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,221)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(13)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,222)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(52)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(52)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(52)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(48)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,229)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(48)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,230)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(48)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,231)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(48)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,232)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(48)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,233)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(48)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,234)
  Gcoeff = (c(9)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(9)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(8)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(36)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(8)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(36)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(36)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(9)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(9)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(9)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(8)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(36)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(8)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(36)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(8)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(36)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(7)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(7)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(7)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(36)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(14)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(14)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(14)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(15)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,235)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(15)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,236)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(15)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,237)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(16)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,238)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(16)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,239)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(16)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,240)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(68)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,241)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(68)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,242)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(68)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,243)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(64)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,244)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(64)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,245)
  Gcoeff = (c(3)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(64)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,246)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(15)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,247)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(15)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,248)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(15)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,249)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(68)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(68)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(68)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(60)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,256)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(60)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,257)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(60)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,258)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(17)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(17)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(17)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(18)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,259)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(18)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,260)
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(18)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,261)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(19)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,262)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(19)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,263)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(19)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,264)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(80)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,265)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(80)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,266)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(80)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,267)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(74)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,268)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(74)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,269)
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(74)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,270)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(18)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,271)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(18)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,272)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(18)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,273)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(80)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(80)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(80)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(70)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,280)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(70)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,281)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(70)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,282)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(20)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,283)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(20)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,284)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(20)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,285)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(21)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,286)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(21)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,287)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(21)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,288)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(88)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,289)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(88)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,290)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(88)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,291)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(84)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,292)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(84)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,293)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(84)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,294)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(22)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,295)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(22)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,296)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(22)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,297)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(23)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,298)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(23)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,299)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(23)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,300)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(96)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,301)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(96)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,302)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(96)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,303)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(90)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,304)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(90)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,305)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(90)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,306)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(24)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,307)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(24)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,308)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(24)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,309)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(25)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,310)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(25)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,311)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(25)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,312)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(102)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,313)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(102)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,314)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(102)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,315)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(98)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,316)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(98)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,317)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(98)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,318)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(100)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,319)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(100)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,320)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(100)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,321)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(92)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,322)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(92)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,323)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(92)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,324)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(104)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,325)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(104)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,326)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(104)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,327)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(82)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,328)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(82)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,329)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(82)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,330)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(94)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,331)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(94)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,332)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(94)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,333)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(86)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,334)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(86)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,335)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(86)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,336)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(20)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,250)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(20)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,251)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(20)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,252)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(88)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(88)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(88)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(72)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,337)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(72)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,338)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(72)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,339)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(22)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,274)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(22)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,275)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(22)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,276)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(96)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(96)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(96)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(58)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,340)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(58)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,341)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(58)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,342)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(100)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,343)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(100)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,344)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(100)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,345)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(76)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,346)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(76)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,347)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(16)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,136)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(16)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,137)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(16)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,138)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(16)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,223)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(16)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,224)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(16)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,225)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(64)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(64)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(64)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(37)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(21)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,112)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(21)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,113)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(21)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,114)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(21)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,211)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(21)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,212)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(21)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,213)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(84)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(84)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(84)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(24)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,277)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(24)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,278)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(24)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,279)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(102)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(102)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(102)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(39)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(19)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,166)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(19)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,167)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(19)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,168)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(19)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,226)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(19)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,227)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(19)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,228)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(74)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(74)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(74)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(40)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(23)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,124)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(23)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,125)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(23)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,126)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(23)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,214)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(23)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,215)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(23)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,216)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(90)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(90)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(90)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(25)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,253)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(25)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,254)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(25)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,255)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(98)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(98)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(98)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(41)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(43)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(44)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(45)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(49)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(53)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(57)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(65)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(69)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(75)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(81)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(85)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(89)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(91)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(97)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(99)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(103)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,49)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_6

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_6_ppjjj_ggggg_1_/**/REALKIND
