
module ol_vamp_5_ppjjj_ggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_5(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ggggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppjjj_ggggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppjjj_ggggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(44)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,151) :: G0
  complex(REALKIND), dimension(4,5,4,1) :: G1
  complex(REALKIND), dimension(4,15,4,1) :: G2
  complex(REALKIND), dimension(1,225) :: G0tensor
  complex(REALKIND), dimension(5,210) :: G1tensor
  complex(REALKIND), dimension(35,1) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,149),Q(:,14),G1(:,:,:,1))
  call loop_UV_W(G1(:,:,:,1),Q(:,14),wf(:,-4),Q(:,16),G2(:,:,:,1))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,30),wf(:,0),Q(:,1),G3tensor(:,1))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,2))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,-3),wf(:,-2),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,2),wf(:,-2),wf(:,-3),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,2),wf(:,-3),wf(:,-2),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,1))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,3))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,3),wf(:,-3),wf(:,-2),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,3),wf(:,-2),wf(:,-3),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,3),wf(:,-3),wf(:,-2),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,3),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,2))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,4),wf(:,-3),wf(:,-2),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,4),wf(:,-2),wf(:,-3),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,4),wf(:,-3),wf(:,-2),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,3))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-2),G0(:,:,:,5))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,-3),wf(:,1),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,1),wf(:,-3),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,5),wf(:,-3),wf(:,1),G0tensor(:,12))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,-1),wf(:,9),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,9),wf(:,-1),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,5),wf(:,-1),wf(:,9),G0tensor(:,15))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,0),wf(:,21),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,5),wf(:,21),wf(:,0),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,5),wf(:,0),wf(:,21),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,20),wf(:,34),Q(:,11),G1tensor(:,4))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,20),wf(:,35),Q(:,11),G1tensor(:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,20),wf(:,36),Q(:,11),G1tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,20),wf(:,42),Q(:,11),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,20),wf(:,51),Q(:,11),G1tensor(:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,20),wf(:,53),Q(:,11),G1tensor(:,9))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,-4),G0(:,:,:,6))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,6),wf(:,-3),wf(:,1),G0tensor(:,19))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,6),wf(:,1),wf(:,-3),G0tensor(:,20))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,6),wf(:,-3),wf(:,1),G0tensor(:,21))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,6),wf(:,-1),wf(:,9),G0tensor(:,22))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,6),wf(:,9),wf(:,-1),G0tensor(:,23))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,6),wf(:,-1),wf(:,9),G0tensor(:,24))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,6),wf(:,0),wf(:,21),G0tensor(:,25))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,6),wf(:,21),wf(:,0),G0tensor(:,26))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,6),wf(:,0),wf(:,21),G0tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,20),wf(:,34),Q(:,11),G1tensor(:,10))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,20),wf(:,35),Q(:,11),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,20),wf(:,36),Q(:,11),G1tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,20),wf(:,42),Q(:,11),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,20),wf(:,51),Q(:,11),G1tensor(:,14))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,20),wf(:,53),Q(:,11),G1tensor(:,15))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,-2),G0(:,:,:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,7),wf(:,-3),wf(:,1),G0tensor(:,28))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,7),wf(:,1),wf(:,-3),G0tensor(:,29))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,7),wf(:,-3),wf(:,1),G0tensor(:,30))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,7),wf(:,-1),wf(:,9),G0tensor(:,31))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,7),wf(:,9),wf(:,-1),G0tensor(:,32))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,7),wf(:,-1),wf(:,9),G0tensor(:,33))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,7),wf(:,0),wf(:,21),G0tensor(:,34))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,7),wf(:,21),wf(:,0),G0tensor(:,35))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,7),wf(:,0),wf(:,21),G0tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,20),wf(:,34),Q(:,11),G1tensor(:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,20),wf(:,35),Q(:,11),G1tensor(:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,20),wf(:,36),Q(:,11),G1tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,20),wf(:,42),Q(:,11),G1tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,20),wf(:,51),Q(:,11),G1tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,20),wf(:,53),Q(:,11),G1tensor(:,21))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-3),G0(:,:,:,8))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,8),wf(:,-2),wf(:,1),G0tensor(:,37))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,8),wf(:,1),wf(:,-2),G0tensor(:,38))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,8),wf(:,-2),wf(:,1),G0tensor(:,39))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,8),wf(:,-1),wf(:,5),G0tensor(:,40))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,8),wf(:,5),wf(:,-1),G0tensor(:,41))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,8),wf(:,-1),wf(:,5),G0tensor(:,42))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,8),wf(:,0),wf(:,17),G0tensor(:,43))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,8),wf(:,17),wf(:,0),G0tensor(:,44))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,8),wf(:,0),wf(:,17),G0tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,24),wf(:,38),Q(:,7),G1tensor(:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,24),wf(:,39),Q(:,7),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,24),wf(:,40),Q(:,7),G1tensor(:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,24),wf(:,43),Q(:,7),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,24),wf(:,46),Q(:,7),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,24),wf(:,49),Q(:,7),G1tensor(:,27))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-4),G0(:,:,:,9))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,9),wf(:,-2),wf(:,1),G0tensor(:,46))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,9),wf(:,1),wf(:,-2),G0tensor(:,47))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,9),wf(:,-2),wf(:,1),G0tensor(:,48))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,9),wf(:,-1),wf(:,5),G0tensor(:,49))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,9),wf(:,5),wf(:,-1),G0tensor(:,50))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,9),wf(:,-1),wf(:,5),G0tensor(:,51))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,9),wf(:,0),wf(:,17),G0tensor(:,52))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,9),wf(:,17),wf(:,0),G0tensor(:,53))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,9),wf(:,0),wf(:,17),G0tensor(:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,24),wf(:,38),Q(:,7),G1tensor(:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,24),wf(:,39),Q(:,7),G1tensor(:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,24),wf(:,40),Q(:,7),G1tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,24),wf(:,43),Q(:,7),G1tensor(:,31))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,24),wf(:,46),Q(:,7),G1tensor(:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,24),wf(:,49),Q(:,7),G1tensor(:,33))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,-3),G0(:,:,:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,10),wf(:,-2),wf(:,1),G0tensor(:,55))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,10),wf(:,1),wf(:,-2),G0tensor(:,56))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,10),wf(:,-2),wf(:,1),G0tensor(:,57))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,10),wf(:,-1),wf(:,5),G0tensor(:,58))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,10),wf(:,5),wf(:,-1),G0tensor(:,59))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,10),wf(:,-1),wf(:,5),G0tensor(:,60))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,10),wf(:,0),wf(:,17),G0tensor(:,61))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,10),wf(:,17),wf(:,0),G0tensor(:,62))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,10),wf(:,0),wf(:,17),G0tensor(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,24),wf(:,38),Q(:,7),G1tensor(:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,24),wf(:,39),Q(:,7),G1tensor(:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,24),wf(:,40),Q(:,7),G1tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,24),wf(:,43),Q(:,7),G1tensor(:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,24),wf(:,46),Q(:,7),G1tensor(:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,24),wf(:,49),Q(:,7),G1tensor(:,39))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,5),G0(:,:,:,11))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,11),wf(:,-3),wf(:,-1),G0tensor(:,64))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,11),wf(:,-1),wf(:,-3),G0tensor(:,65))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,11),wf(:,-3),wf(:,-1),G0tensor(:,66))
  call check_last_UV_W(l_switch,G0(:,:,:,11),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,40))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,5),wf(:,-4),G0(:,:,:,12))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,-3),wf(:,-1),G0tensor(:,67))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,12),wf(:,-1),wf(:,-3),G0tensor(:,68))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,12),wf(:,-3),wf(:,-1),G0tensor(:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,41))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,5),G0(:,:,:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,13),wf(:,-3),wf(:,-1),G0tensor(:,70))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,13),wf(:,-1),wf(:,-3),G0tensor(:,71))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,13),wf(:,-3),wf(:,-1),G0tensor(:,72))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,42))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,-1),G0(:,:,:,14))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,-3),wf(:,5),G0tensor(:,73))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,5),wf(:,-3),G0tensor(:,74))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,14),wf(:,-3),wf(:,5),G0tensor(:,75))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,-2),wf(:,9),G0tensor(:,76))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,9),wf(:,-2),G0tensor(:,77))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,14),wf(:,-2),wf(:,9),G0tensor(:,78))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,0),wf(:,29),G0tensor(:,79))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,14),wf(:,29),wf(:,0),G0tensor(:,80))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,14),wf(:,0),wf(:,29),G0tensor(:,81))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,18),wf(:,26),Q(:,13),G1tensor(:,43))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,18),wf(:,27),Q(:,13),G1tensor(:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,18),wf(:,28),Q(:,13),G1tensor(:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,18),wf(:,45),Q(:,13),G1tensor(:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,18),wf(:,50),Q(:,13),G1tensor(:,47))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,18),wf(:,150),Q(:,13),G1tensor(:,48))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,-4),G0(:,:,:,15))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,5),G0tensor(:,82))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,5),wf(:,-3),G0tensor(:,83))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,-3),wf(:,5),G0tensor(:,84))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,-2),wf(:,9),G0tensor(:,85))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,9),wf(:,-2),G0tensor(:,86))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,-2),wf(:,9),G0tensor(:,87))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,0),wf(:,29),G0tensor(:,88))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,15),wf(:,29),wf(:,0),G0tensor(:,89))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,15),wf(:,0),wf(:,29),G0tensor(:,90))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,18),wf(:,26),Q(:,13),G1tensor(:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,18),wf(:,27),Q(:,13),G1tensor(:,50))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,18),wf(:,28),Q(:,13),G1tensor(:,51))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,18),wf(:,45),Q(:,13),G1tensor(:,52))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,18),wf(:,50),Q(:,13),G1tensor(:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,18),wf(:,150),Q(:,13),G1tensor(:,54))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,-1),G0(:,:,:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,-3),wf(:,5),G0tensor(:,91))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,5),wf(:,-3),G0tensor(:,92))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,16),wf(:,-3),wf(:,5),G0tensor(:,93))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,-2),wf(:,9),G0tensor(:,94))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,9),wf(:,-2),G0tensor(:,95))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,16),wf(:,-2),wf(:,9),G0tensor(:,96))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,0),wf(:,29),G0tensor(:,97))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,16),wf(:,29),wf(:,0),G0tensor(:,98))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,16),wf(:,0),wf(:,29),G0tensor(:,99))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,18),wf(:,26),Q(:,13),G1tensor(:,55))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,18),wf(:,27),Q(:,13),G1tensor(:,56))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,18),wf(:,28),Q(:,13),G1tensor(:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,18),wf(:,45),Q(:,13),G1tensor(:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,18),wf(:,50),Q(:,13),G1tensor(:,59))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,18),wf(:,150),Q(:,13),G1tensor(:,60))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,9),G0(:,:,:,17))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,17),wf(:,-2),wf(:,-1),G0tensor(:,100))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,17),wf(:,-1),wf(:,-2),G0tensor(:,101))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,17),wf(:,-2),wf(:,-1),G0tensor(:,102))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,61))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,9),wf(:,-4),G0(:,:,:,18))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-2),wf(:,-1),G0tensor(:,103))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,18),wf(:,-1),wf(:,-2),G0tensor(:,104))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,18),wf(:,-2),wf(:,-1),G0tensor(:,105))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,62))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,9),G0(:,:,:,19))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-2),wf(:,-1),G0tensor(:,106))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,19),wf(:,-1),wf(:,-2),G0tensor(:,107))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,19),wf(:,-2),wf(:,-1),G0tensor(:,108))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,63))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,14),G0(:,:,:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,64))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,15),G0(:,:,:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,65))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,16),G0(:,:,:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,66))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,14),wf(:,-4),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,67))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,15),wf(:,-4),G0(:,:,:,24))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,68))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,-4),G0(:,:,:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,69))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,14),G0(:,:,:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,70))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,15),G0(:,:,:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,71))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,16),G0(:,:,:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,28),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,72))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,13),G0(:,:,:,29))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,-2),wf(:,-1),G0tensor(:,109))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,29),wf(:,-1),wf(:,-2),G0tensor(:,110))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,29),wf(:,-2),wf(:,-1),G0tensor(:,111))
  call check_last_UV_W(l_switch,G0(:,:,:,29),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,73))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-3),G0(:,:,:,30))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,-2),wf(:,-1),G0tensor(:,112))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,-1),wf(:,-2),G0tensor(:,113))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,30),wf(:,-2),wf(:,-1),G0tensor(:,114))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,74))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,13),G0(:,:,:,31))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,31),wf(:,-2),wf(:,-1),G0tensor(:,115))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,31),wf(:,-1),wf(:,-2),G0tensor(:,116))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,31),wf(:,-2),wf(:,-1),G0tensor(:,117))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,25),wf(:,17),Q(:,6),G1tensor(:,75))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,10),G0(:,:,:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,32),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,76))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,11),G0(:,:,:,33))
  call check_last_UV_W(l_switch,G0(:,:,:,33),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,77))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,12),G0(:,:,:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,78))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,10),wf(:,-3),G0(:,:,:,35))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,79))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,-3),G0(:,:,:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,36),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,80))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,12),wf(:,-3),G0(:,:,:,37))
  call check_last_UV_W(l_switch,G0(:,:,:,37),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,81))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,10),G0(:,:,:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,82))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,11),G0(:,:,:,39))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,83))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,12),G0(:,:,:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,84))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,13),G0(:,:,:,41))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,41),wf(:,-3),wf(:,-1),G0tensor(:,118))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,41),wf(:,-1),wf(:,-3),G0tensor(:,119))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,41),wf(:,-3),wf(:,-1),G0tensor(:,120))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,85))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-2),G0(:,:,:,42))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,42),wf(:,-3),wf(:,-1),G0tensor(:,121))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,42),wf(:,-1),wf(:,-3),G0tensor(:,122))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,42),wf(:,-3),wf(:,-1),G0tensor(:,123))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,86))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,13),G0(:,:,:,43))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,43),wf(:,-3),wf(:,-1),G0tensor(:,124))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,43),wf(:,-1),wf(:,-3),G0tensor(:,125))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,43),wf(:,-3),wf(:,-1),G0tensor(:,126))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,21),wf(:,21),Q(:,10),G1tensor(:,87))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,6),G0(:,:,:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,88))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,7),G0(:,:,:,45))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,89))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,8),G0(:,:,:,46))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,90))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,-2),G0(:,:,:,47))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,91))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,-2),G0(:,:,:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,92))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,8),wf(:,-2),G0(:,:,:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,49),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,93))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,6),G0(:,:,:,50))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,94))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,7),G0(:,:,:,51))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,95))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,8),G0(:,:,:,52))
  call check_last_UV_W(l_switch,G0(:,:,:,52),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,96))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,13),G0(:,:,:,53))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,53),wf(:,-3),wf(:,-2),G0tensor(:,127))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,53),wf(:,-2),wf(:,-3),G0tensor(:,128))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,53),wf(:,-3),wf(:,-2),G0tensor(:,129))
  call check_last_UV_W(l_switch,G0(:,:,:,53),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,97))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-1),G0(:,:,:,54))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,54),wf(:,-3),wf(:,-2),G0tensor(:,130))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,54),wf(:,-2),wf(:,-3),G0tensor(:,131))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,54),wf(:,-3),wf(:,-2),G0tensor(:,132))
  call check_last_UV_W(l_switch,G0(:,:,:,54),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,98))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,13),G0(:,:,:,55))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,55),wf(:,-3),wf(:,-2),G0tensor(:,133))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,55),wf(:,-2),wf(:,-3),G0tensor(:,134))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,55),wf(:,-3),wf(:,-2),G0tensor(:,135))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,99))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,2),G0(:,:,:,56))
  call check_last_UV_W(l_switch,G0(:,:,:,56),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,100))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,-1),G0(:,:,:,57))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,101))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,2),G0(:,:,:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,58),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,102))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,3),G0(:,:,:,59))
  call check_last_UV_W(l_switch,G0(:,:,:,59),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,103))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,-1),G0(:,:,:,60))
  call check_last_UV_W(l_switch,G0(:,:,:,60),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,104))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,3),G0(:,:,:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,105))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-1),wf(:,4),G0(:,:,:,62))
  call check_last_UV_W(l_switch,G0(:,:,:,62),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,106))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,-1),G0(:,:,:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,63),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,107))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-1),wf(:,4),G0(:,:,:,64))
  call check_last_UV_W(l_switch,G0(:,:,:,64),Q(:,30),wf(:,0),Q(:,1),G1tensor(:,108))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,17),G0(:,:,:,65))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,65),wf(:,-3),wf(:,0),G0tensor(:,136))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,65),wf(:,0),wf(:,-3),G0tensor(:,137))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,65),wf(:,-3),wf(:,0),G0tensor(:,138))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,109))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,17),wf(:,-4),G0(:,:,:,66))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,66),wf(:,-3),wf(:,0),G0tensor(:,139))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,66),wf(:,0),wf(:,-3),G0tensor(:,140))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,66),wf(:,-3),wf(:,0),G0tensor(:,141))
  call check_last_UV_W(l_switch,G0(:,:,:,66),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,110))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,17),G0(:,:,:,67))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,67),wf(:,-3),wf(:,0),G0tensor(:,142))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,67),wf(:,0),wf(:,-3),G0tensor(:,143))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,67),wf(:,-3),wf(:,0),G0tensor(:,144))
  call check_last_UV_W(l_switch,G0(:,:,:,67),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,111))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,0),G0(:,:,:,68))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,68),wf(:,-3),wf(:,17),G0tensor(:,145))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,68),wf(:,17),wf(:,-3),G0tensor(:,146))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,68),wf(:,-3),wf(:,17),G0tensor(:,147))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,68),wf(:,-2),wf(:,21),G0tensor(:,148))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,68),wf(:,21),wf(:,-2),G0tensor(:,149))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,68),wf(:,-2),wf(:,21),G0tensor(:,150))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,68),wf(:,-1),wf(:,29),G0tensor(:,151))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,68),wf(:,29),wf(:,-1),G0tensor(:,152))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,68),wf(:,-1),wf(:,29),G0tensor(:,153))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,17),wf(:,14),Q(:,14),G1tensor(:,112))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,17),wf(:,15),Q(:,14),G1tensor(:,113))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,17),wf(:,16),Q(:,14),G1tensor(:,114))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,17),wf(:,143),Q(:,14),G1tensor(:,115))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,17),wf(:,147),Q(:,14),G1tensor(:,116))
  call check_last_UV_W(l_switch,G0(:,:,:,68),Q(:,17),wf(:,149),Q(:,14),G1tensor(:,117))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,-4),G0(:,:,:,69))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,-3),wf(:,17),G0tensor(:,154))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,17),wf(:,-3),G0tensor(:,155))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,69),wf(:,-3),wf(:,17),G0tensor(:,156))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,-2),wf(:,21),G0tensor(:,157))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,21),wf(:,-2),G0tensor(:,158))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,69),wf(:,-2),wf(:,21),G0tensor(:,159))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,-1),wf(:,29),G0tensor(:,160))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,69),wf(:,29),wf(:,-1),G0tensor(:,161))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,69),wf(:,-1),wf(:,29),G0tensor(:,162))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,17),wf(:,14),Q(:,14),G1tensor(:,118))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,17),wf(:,15),Q(:,14),G1tensor(:,119))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,17),wf(:,16),Q(:,14),G1tensor(:,120))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,17),wf(:,143),Q(:,14),G1tensor(:,121))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,17),wf(:,147),Q(:,14),G1tensor(:,122))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,17),wf(:,149),Q(:,14),G1tensor(:,123))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,0),G0(:,:,:,70))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,-3),wf(:,17),G0tensor(:,163))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,17),wf(:,-3),G0tensor(:,164))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,70),wf(:,-3),wf(:,17),G0tensor(:,165))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,-2),wf(:,21),G0tensor(:,166))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,21),wf(:,-2),G0tensor(:,167))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,70),wf(:,-2),wf(:,21),G0tensor(:,168))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,-1),wf(:,29),G0tensor(:,169))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,70),wf(:,29),wf(:,-1),G0tensor(:,170))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,70),wf(:,-1),wf(:,29),G0tensor(:,171))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,17),wf(:,14),Q(:,14),G1tensor(:,124))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,17),wf(:,15),Q(:,14),G1tensor(:,125))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,17),wf(:,16),Q(:,14),G1tensor(:,126))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,17),wf(:,143),Q(:,14),G1tensor(:,127))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,17),wf(:,147),Q(:,14),G1tensor(:,128))
  call check_last_UV_W(l_switch,G0(:,:,:,70),Q(:,17),wf(:,149),Q(:,14),G1tensor(:,129))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,21),G0(:,:,:,71))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,71),wf(:,-2),wf(:,0),G0tensor(:,172))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,71),wf(:,0),wf(:,-2),G0tensor(:,173))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,71),wf(:,-2),wf(:,0),G0tensor(:,174))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,130))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,21),wf(:,-4),G0(:,:,:,72))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,72),wf(:,-2),wf(:,0),G0tensor(:,175))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,72),wf(:,0),wf(:,-2),G0tensor(:,176))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,72),wf(:,-2),wf(:,0),G0tensor(:,177))
  call check_last_UV_W(l_switch,G0(:,:,:,72),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,131))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,21),G0(:,:,:,73))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,73),wf(:,-2),wf(:,0),G0tensor(:,178))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,73),wf(:,0),wf(:,-2),G0tensor(:,179))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,73),wf(:,-2),wf(:,0),G0tensor(:,180))
  call check_last_UV_W(l_switch,G0(:,:,:,73),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,132))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,26),G0(:,:,:,74))
  call check_last_UV_W(l_switch,G0(:,:,:,74),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,133))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,27),G0(:,:,:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,134))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,28),G0(:,:,:,76))
  call check_last_UV_W(l_switch,G0(:,:,:,76),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,135))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,26),wf(:,-4),G0(:,:,:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,136))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,27),wf(:,-4),G0(:,:,:,78))
  call check_last_UV_W(l_switch,G0(:,:,:,78),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,137))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,28),wf(:,-4),G0(:,:,:,79))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,138))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,26),G0(:,:,:,80))
  call check_last_UV_W(l_switch,G0(:,:,:,80),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,139))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,27),G0(:,:,:,81))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,140))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,28),G0(:,:,:,82))
  call check_last_UV_W(l_switch,G0(:,:,:,82),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,141))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,25),G0(:,:,:,83))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,83),wf(:,-2),wf(:,0),G0tensor(:,181))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,83),wf(:,0),wf(:,-2),G0tensor(:,182))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,83),wf(:,-2),wf(:,0),G0tensor(:,183))
  call check_last_UV_W(l_switch,G0(:,:,:,83),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,142))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,-3),G0(:,:,:,84))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,84),wf(:,-2),wf(:,0),G0tensor(:,184))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,84),wf(:,0),wf(:,-2),G0tensor(:,185))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,84),wf(:,-2),wf(:,0),G0tensor(:,186))
  call check_last_UV_W(l_switch,G0(:,:,:,84),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,143))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,25),G0(:,:,:,85))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,85),wf(:,-2),wf(:,0),G0tensor(:,187))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,85),wf(:,0),wf(:,-2),G0tensor(:,188))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,85),wf(:,-2),wf(:,0),G0tensor(:,189))
  call check_last_UV_W(l_switch,G0(:,:,:,85),Q(:,26),wf(:,5),Q(:,5),G1tensor(:,144))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,22),G0(:,:,:,86))
  call check_last_UV_W(l_switch,G0(:,:,:,86),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,145))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,23),G0(:,:,:,87))
  call check_last_UV_W(l_switch,G0(:,:,:,87),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,146))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,24),G0(:,:,:,88))
  call check_last_UV_W(l_switch,G0(:,:,:,88),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,147))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,22),wf(:,-3),G0(:,:,:,89))
  call check_last_UV_W(l_switch,G0(:,:,:,89),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,148))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,23),wf(:,-3),G0(:,:,:,90))
  call check_last_UV_W(l_switch,G0(:,:,:,90),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,149))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,24),wf(:,-3),G0(:,:,:,91))
  call check_last_UV_W(l_switch,G0(:,:,:,91),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,150))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,22),G0(:,:,:,92))
  call check_last_UV_W(l_switch,G0(:,:,:,92),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,151))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,23),G0(:,:,:,93))
  call check_last_UV_W(l_switch,G0(:,:,:,93),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,152))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,24),G0(:,:,:,94))
  call check_last_UV_W(l_switch,G0(:,:,:,94),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,153))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,25),G0(:,:,:,95))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,95),wf(:,-3),wf(:,0),G0tensor(:,190))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,95),wf(:,0),wf(:,-3),G0tensor(:,191))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,95),wf(:,-3),wf(:,0),G0tensor(:,192))
  call check_last_UV_W(l_switch,G0(:,:,:,95),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,154))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,-2),G0(:,:,:,96))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,96),wf(:,-3),wf(:,0),G0tensor(:,193))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,96),wf(:,0),wf(:,-3),G0tensor(:,194))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,96),wf(:,-3),wf(:,0),G0tensor(:,195))
  call check_last_UV_W(l_switch,G0(:,:,:,96),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,155))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,25),G0(:,:,:,97))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,97),wf(:,-3),wf(:,0),G0tensor(:,196))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,97),wf(:,0),wf(:,-3),G0tensor(:,197))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,97),wf(:,-3),wf(:,0),G0tensor(:,198))
  call check_last_UV_W(l_switch,G0(:,:,:,97),Q(:,22),wf(:,9),Q(:,9),G1tensor(:,156))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,18),G0(:,:,:,98))
  call check_last_UV_W(l_switch,G0(:,:,:,98),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,157))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,19),G0(:,:,:,99))
  call check_last_UV_W(l_switch,G0(:,:,:,99),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,158))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,20),G0(:,:,:,100))
  call check_last_UV_W(l_switch,G0(:,:,:,100),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,159))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,18),wf(:,-2),G0(:,:,:,101))
  call check_last_UV_W(l_switch,G0(:,:,:,101),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,160))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,19),wf(:,-2),G0(:,:,:,102))
  call check_last_UV_W(l_switch,G0(:,:,:,102),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,161))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,20),wf(:,-2),G0(:,:,:,103))
  call check_last_UV_W(l_switch,G0(:,:,:,103),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,162))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,18),G0(:,:,:,104))
  call check_last_UV_W(l_switch,G0(:,:,:,104),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,163))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,19),G0(:,:,:,105))
  call check_last_UV_W(l_switch,G0(:,:,:,105),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,164))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-2),wf(:,20),G0(:,:,:,106))
  call check_last_UV_W(l_switch,G0(:,:,:,106),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,165))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,25),G0(:,:,:,107))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,107),wf(:,-3),wf(:,-2),G0tensor(:,199))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,107),wf(:,-2),wf(:,-3),G0tensor(:,200))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,107),wf(:,-3),wf(:,-2),G0tensor(:,201))
  call check_last_UV_W(l_switch,G0(:,:,:,107),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,166))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,25),wf(:,0),G0(:,:,:,108))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,108),wf(:,-3),wf(:,-2),G0tensor(:,202))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,108),wf(:,-2),wf(:,-3),G0tensor(:,203))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,108),wf(:,-3),wf(:,-2),G0tensor(:,204))
  call check_last_UV_W(l_switch,G0(:,:,:,108),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,167))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,25),G0(:,:,:,109))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,109),wf(:,-3),wf(:,-2),G0tensor(:,205))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,109),wf(:,-2),wf(:,-3),G0tensor(:,206))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,109),wf(:,-3),wf(:,-2),G0tensor(:,207))
  call check_last_UV_W(l_switch,G0(:,:,:,109),Q(:,19),wf(:,29),Q(:,12),G1tensor(:,168))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,2),G0(:,:,:,110))
  call check_last_UV_W(l_switch,G0(:,:,:,110),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,169))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,0),G0(:,:,:,111))
  call check_last_UV_W(l_switch,G0(:,:,:,111),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,170))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,2),G0(:,:,:,112))
  call check_last_UV_W(l_switch,G0(:,:,:,112),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,171))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,3),G0(:,:,:,113))
  call check_last_UV_W(l_switch,G0(:,:,:,113),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,172))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,0),G0(:,:,:,114))
  call check_last_UV_W(l_switch,G0(:,:,:,114),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,173))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,3),G0(:,:,:,115))
  call check_last_UV_W(l_switch,G0(:,:,:,115),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,174))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,0),wf(:,4),G0(:,:,:,116))
  call check_last_UV_W(l_switch,G0(:,:,:,116),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,175))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,4),wf(:,0),G0(:,:,:,117))
  call check_last_UV_W(l_switch,G0(:,:,:,117),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,176))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,0),wf(:,4),G0(:,:,:,118))
  call check_last_UV_W(l_switch,G0(:,:,:,118),Q(:,29),wf(:,-1),Q(:,2),G1tensor(:,177))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,29),G0(:,:,:,119))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,119),wf(:,-1),wf(:,0),G0tensor(:,208))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,119),wf(:,0),wf(:,-1),G0tensor(:,209))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,119),wf(:,-1),wf(:,0),G0tensor(:,210))
  call check_last_UV_W(l_switch,G0(:,:,:,119),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,178))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,29),wf(:,-4),G0(:,:,:,120))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,120),wf(:,-1),wf(:,0),G0tensor(:,211))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,120),wf(:,0),wf(:,-1),G0tensor(:,212))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,120),wf(:,-1),wf(:,0),G0tensor(:,213))
  call check_last_UV_W(l_switch,G0(:,:,:,120),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,179))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,29),G0(:,:,:,121))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,121),wf(:,-1),wf(:,0),G0tensor(:,214))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,121),wf(:,0),wf(:,-1),G0tensor(:,215))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,121),wf(:,-1),wf(:,0),G0tensor(:,216))
  call check_last_UV_W(l_switch,G0(:,:,:,121),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,180))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,34),G0(:,:,:,122))
  call check_last_UV_W(l_switch,G0(:,:,:,122),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,181))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,35),G0(:,:,:,123))
  call check_last_UV_W(l_switch,G0(:,:,:,123),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,182))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,36),G0(:,:,:,124))
  call check_last_UV_W(l_switch,G0(:,:,:,124),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,183))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,34),wf(:,-4),G0(:,:,:,125))
  call check_last_UV_W(l_switch,G0(:,:,:,125),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,184))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,35),wf(:,-4),G0(:,:,:,126))
  call check_last_UV_W(l_switch,G0(:,:,:,126),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,185))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,36),wf(:,-4),G0(:,:,:,127))
  call check_last_UV_W(l_switch,G0(:,:,:,127),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,186))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,34),G0(:,:,:,128))
  call check_last_UV_W(l_switch,G0(:,:,:,128),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,187))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,35),G0(:,:,:,129))
  call check_last_UV_W(l_switch,G0(:,:,:,129),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,188))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,36),G0(:,:,:,130))
  call check_last_UV_W(l_switch,G0(:,:,:,130),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,189))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,33),G0(:,:,:,131))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,131),wf(:,-1),wf(:,0),G0tensor(:,217))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,131),wf(:,0),wf(:,-1),G0tensor(:,218))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,131),wf(:,-1),wf(:,0),G0tensor(:,219))
  call check_last_UV_W(l_switch,G0(:,:,:,131),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,190))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,33),wf(:,-3),G0(:,:,:,132))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,132),wf(:,-1),wf(:,0),G0tensor(:,220))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,132),wf(:,0),wf(:,-1),G0tensor(:,221))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,132),wf(:,-1),wf(:,0),G0tensor(:,222))
  call check_last_UV_W(l_switch,G0(:,:,:,132),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,191))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,33),G0(:,:,:,133))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,133),wf(:,-1),wf(:,0),G0tensor(:,223))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,133),wf(:,0),wf(:,-1),G0tensor(:,224))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,133),wf(:,-1),wf(:,0),G0tensor(:,225))
  call check_last_UV_W(l_switch,G0(:,:,:,133),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,192))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,30),G0(:,:,:,134))
  call check_last_UV_W(l_switch,G0(:,:,:,134),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,193))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,31),G0(:,:,:,135))
  call check_last_UV_W(l_switch,G0(:,:,:,135),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,194))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,32),G0(:,:,:,136))
  call check_last_UV_W(l_switch,G0(:,:,:,136),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,195))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,30),wf(:,-3),G0(:,:,:,137))
  call check_last_UV_W(l_switch,G0(:,:,:,137),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,196))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,31),wf(:,-3),G0(:,:,:,138))
  call check_last_UV_W(l_switch,G0(:,:,:,138),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,197))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,32),wf(:,-3),G0(:,:,:,139))
  call check_last_UV_W(l_switch,G0(:,:,:,139),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,198))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,30),G0(:,:,:,140))
  call check_last_UV_W(l_switch,G0(:,:,:,140),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,199))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,31),G0(:,:,:,141))
  call check_last_UV_W(l_switch,G0(:,:,:,141),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,200))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,32),G0(:,:,:,142))
  call check_last_UV_W(l_switch,G0(:,:,:,142),Q(:,27),wf(:,-2),Q(:,4),G1tensor(:,201))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,38),G0(:,:,:,143))
  call check_last_UV_W(l_switch,G0(:,:,:,143),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,202))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,39),G0(:,:,:,144))
  call check_last_UV_W(l_switch,G0(:,:,:,144),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,203))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,40),G0(:,:,:,145))
  call check_last_UV_W(l_switch,G0(:,:,:,145),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,204))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,38),wf(:,-4),G0(:,:,:,146))
  call check_last_UV_W(l_switch,G0(:,:,:,146),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,205))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,39),wf(:,-4),G0(:,:,:,147))
  call check_last_UV_W(l_switch,G0(:,:,:,147),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,206))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,40),wf(:,-4),G0(:,:,:,148))
  call check_last_UV_W(l_switch,G0(:,:,:,148),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,207))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,38),G0(:,:,:,149))
  call check_last_UV_W(l_switch,G0(:,:,:,149),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,208))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,39),G0(:,:,:,150))
  call check_last_UV_W(l_switch,G0(:,:,:,150),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,209))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,40),G0(:,:,:,151))
  call check_last_UV_W(l_switch,G0(:,:,:,151),Q(:,23),wf(:,-3),Q(:,8),G1tensor(:,210))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(6)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(98)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(23)-M(25)+M(36)+M(42))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(21)-M(26)+M(30)+M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(21)-M(26)+M(30)+M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(23)-M(25)+M(36)+M(42))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(1)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(23)-M(25)+M(36)+M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,10)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(22)-M(24)+M(32)+M(38))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,19)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,28)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(22)-M(24)+M(32)+M(38))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(23)-M(25)+M(36)+M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,20)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,29)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,21)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(1)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,30)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(21)-M(26)+M(30)+M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,37)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(22)-M(24)+M(32)+M(38))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,38)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,39)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(22)-M(24)+M(32)+M(38))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,46)
  Gcoeff = (c(1)*(-M(1)-M(2)-M(3)+M(4)+M(7)+M(10))+c(2)*(-M(21)-M(26)+M(30)+M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,47)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,48)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,55)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,56)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(1)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,57)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(-M(29)-M(31)+M(34)+M(40))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,64)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(24)-M(27)-M(32)+M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,65)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,66)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(24)-M(27)-M(32)+M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,67)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(-M(29)-M(31)+M(34)+M(40))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,68)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,69)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,70)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,71)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(2)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,72)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(-M(29)-M(31)+M(34)+M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,73)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(26)-M(28)-M(30)+M(37))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,82)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,91)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(26)-M(28)-M(30)+M(37))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,74)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(-M(29)-M(31)+M(34)+M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,83)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,92)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,75)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,84)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(2)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,93)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(24)-M(27)-M(32)+M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,40)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(26)-M(28)-M(30)+M(37))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,41)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,42)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(26)-M(28)-M(30)+M(37))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,49)
  Gcoeff = (c(1)*(M(1)-M(4)-M(5)-M(6)+M(8)+M(11))+c(2)*(M(24)-M(27)-M(32)+M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,50)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,51)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,58)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,59)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(2)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,60)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(28)-M(35)-M(37)+M(39))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,100)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(22)-M(33)-M(38)+M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,101)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,102)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(22)-M(33)-M(38)+M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,103)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(28)-M(35)-M(37)+M(39))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,104)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,105)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,106)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,107)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(3)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,108)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(32)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(27)+M(33)-M(41)-M(43))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,109)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(21)+M(35)-M(39)-M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,110)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,111)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(21)+M(35)-M(39)-M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,112)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(27)+M(33)-M(41)-M(43))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,113)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,114)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,115)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,116)
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(4)
  T2sum(1:1,6) = T2sum(1:1,6) + Gcoeff * G0tensor(:,117)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,79)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,81)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,82)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,83)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,84)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(28)-M(35)-M(37)+M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,76)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(25)+M(31)-M(34)-M(36))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,85)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,94)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(25)+M(31)-M(34)-M(36))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,77)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(28)-M(35)-M(37)+M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,86)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,95)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,78)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,87)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,96)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(22)-M(33)-M(38)+M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(25)+M(31)-M(34)-M(36))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(25)+M(31)-M(34)-M(36))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,22)
  Gcoeff = (c(1)*(M(2)+M(5)-M(7)-M(8)-M(9)+M(12))+c(2)*(M(22)-M(33)-M(38)+M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,23)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,24)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,31)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,32)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,33)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(27)+M(33)-M(41)-M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,118)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(23)+M(29)-M(40)-M(42))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,119)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,120)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(23)+M(29)-M(40)-M(42))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,121)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(27)+M(33)-M(41)-M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,122)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,123)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,124)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,125)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(4)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,126)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,90)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,95)
  Gcoeff = (c(3)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(21)+M(35)-M(39)-M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,127)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(23)+M(29)-M(40)-M(42))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,130)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,133)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(23)+M(29)-M(40)-M(42))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,128)
  Gcoeff = (c(1)*(M(3)+M(6)+M(9)-M(10)-M(11)-M(12))+c(2)*(M(21)+M(35)-M(39)-M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,131)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,134)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,129)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,132)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(4)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,135)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,100)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,105)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,106)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,107)
  Gcoeff = (c(3)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(35)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,108)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(33)+M(35)-M(39)+M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,136)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(22)+M(28)-M(37)+M(38))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,137)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,138)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(22)+M(28)-M(37)+M(38))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,139)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(33)+M(35)-M(39)+M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,140)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,141)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,142)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,143)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(5)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,144)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(33)+M(35)-M(39)+M(41))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,145)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(21)+M(27)-M(43)+M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,154)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,163)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(21)+M(27)-M(43)+M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,146)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(33)+M(35)-M(39)+M(41))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,155)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,164)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,147)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,156)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(5)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,165)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(22)+M(28)-M(37)+M(38))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,43)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(21)+M(27)-M(43)+M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,44)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,45)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(21)+M(27)-M(43)+M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,52)
  Gcoeff = (c(1)*(-M(1)+M(4)-M(13)-M(14)+M(15)+M(17))+c(2)*(-M(22)+M(28)-M(37)+M(38))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,53)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,54)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,61)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,62)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(5)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,63)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(27)+M(29)-M(40)+M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,172)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(24)-M(31)+M(32)+M(34))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,173)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,174)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(24)-M(31)+M(32)+M(34))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,175)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(27)+M(29)-M(40)+M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,176)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,177)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,178)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,179)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(6)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,180)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,133)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,134)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,135)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,136)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,137)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,138)
  Gcoeff = (c(3)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,139)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,140)
  Gcoeff = (c(3)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(29)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,141)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(28)+M(31)-M(34)+M(37))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,181)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(26)-M(29)+M(30)+M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,182)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,183)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(26)-M(29)+M(30)+M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,184)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(28)+M(31)-M(34)+M(37))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,185)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,186)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,187)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,188)
  Gcoeff = (c(3)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(7)
  T2sum(1:1,9) = T2sum(1:1,9) + Gcoeff * G0tensor(:,189)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,145)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,146)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,147)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,148)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,149)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,150)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,151)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,152)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(30)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,153)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(27)+M(29)-M(40)+M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,148)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(23)+M(33)-M(41)+M(42))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,157)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,166)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(23)+M(33)-M(41)+M(42))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,149)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(27)+M(29)-M(40)+M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,158)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,167)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,150)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,159)
  Gcoeff = (c(3)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(6)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,168)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(24)-M(31)+M(32)+M(34))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(23)+M(33)-M(41)+M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(23)+M(33)-M(41)+M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,25)
  Gcoeff = (c(1)*(-M(2)+M(7)+M(13)-M(15)-M(16)+M(18))+c(2)*(-M(24)-M(31)+M(32)+M(34))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,26)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,27)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,34)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,35)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(6)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,36)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(28)+M(31)-M(34)+M(37))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,190)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(25)-M(35)+M(36)+M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,191)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,192)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(25)-M(35)+M(36)+M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,193)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(28)+M(31)-M(34)+M(37))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,194)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,195)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,196)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,197)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(7)
  T2sum(1:1,7) = T2sum(1:1,7) + Gcoeff * G0tensor(:,198)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,157)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,158)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,159)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,160)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,161)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,162)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,163)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,164)
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,165)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(26)-M(29)+M(30)+M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,199)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(25)-M(35)+M(36)+M(39))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,202)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,205)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(25)-M(35)+M(36)+M(39))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,200)
  Gcoeff = (c(1)*(-M(3)+M(10)+M(14)+M(16)-M(17)-M(18))+c(2)*(-M(26)-M(29)+M(30)+M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,203)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,206)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,201)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,204)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,207)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,169)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,170)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,171)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,172)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,173)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,174)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,175)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,176)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,177)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(21)+M(23)-M(42)+M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,208)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(25)+M(26)-M(30)+M(36))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,209)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,210)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(25)+M(26)-M(30)+M(36))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,211)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(21)+M(23)-M(42)+M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,212)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,213)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,214)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,215)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(8)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,216)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,181)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,182)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,183)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,184)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,185)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,186)
  Gcoeff = (c(3)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,187)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,188)
  Gcoeff = (c(3)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(27)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,189)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(22)+M(25)-M(36)+M(38))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,217)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(23)+M(24)-M(32)+M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,218)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,219)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(23)+M(24)-M(32)+M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,220)
  Gcoeff = (c(1)*(-M(6)+M(11)-M(14)+M(17)+M(19)-M(20))+c(2)*(-M(22)+M(25)-M(36)+M(38))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,221)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,222)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,223)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,224)
  Gcoeff = (c(3)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(9)
  T2sum(1:1,10) = T2sum(1:1,10) + Gcoeff * G0tensor(:,225)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,193)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,194)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,195)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,196)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,197)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,198)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,199)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,200)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(28)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,201)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,202)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,203)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,204)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,205)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,206)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,207)
  Gcoeff = (c(3)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,208)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,209)
  Gcoeff = (c(3)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(26)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,210)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(3)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(26)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(3)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(27)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(21)+M(23)-M(42)+M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,151)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(29)+M(35)-M(39)+M(40))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,160)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,169)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(29)+M(35)-M(39)+M(40))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,152)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(21)+M(23)-M(42)+M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,161)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,170)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,153)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,162)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(8)
  T2sum(1:1,8) = T2sum(1:1,8) + Gcoeff * G0tensor(:,171)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(25)+M(26)-M(30)+M(36))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,79)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(29)+M(35)-M(39)+M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,80)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,81)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(29)+M(35)-M(39)+M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,88)
  Gcoeff = (c(1)*(-M(5)+M(8)-M(13)+M(15)-M(19)+M(20))+c(2)*(-M(25)+M(26)-M(30)+M(36))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,89)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,90)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,97)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,98)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(8)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,99)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(3)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(29)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,112)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,124)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,113)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,119)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,125)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,114)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,120)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(32)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,126)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(11)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,178)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(11)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,179)
  Gcoeff = (c(3)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(11)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,180)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(25)-M(26)+M(30)-M(36)-M(42)+M(44))) * den(11)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(2)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(11)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(3)*(M(21)-M(23)-M(25)+M(26)-M(30)+M(36)+M(42)-M(44))) * den(11)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(12)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,190)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(12)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,191)
  Gcoeff = (c(3)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(12)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,192)
  Gcoeff = (c(2)*(M(21)-M(22)-M(24)+M(26)-M(30)+M(32)+M(38)-M(44))) * den(56)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(56)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(24)-M(26)+M(30)-M(32)-M(38)+M(44))) * den(56)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(2)*(-M(22)+M(23)-M(24)+M(25)+M(32)-M(36)+M(38)-M(42))) * den(52)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(2)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(52)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(3)*(M(22)-M(23)+M(24)-M(25)-M(32)+M(36)-M(38)+M(42))) * den(52)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(14)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,130)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(14)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,131)
  Gcoeff = (c(3)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(14)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,132)
  Gcoeff = (c(2)*(M(24)-M(27)+M(29)+M(31)-M(32)-M(34)-M(40)+M(43))) * den(14)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(2)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(14)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(3)*(-M(24)+M(27)-M(29)-M(31)+M(32)+M(34)+M(40)-M(43))) * den(14)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(15)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,142)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(15)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,143)
  Gcoeff = (c(3)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(15)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,144)
  Gcoeff = (c(2)*(M(24)-M(26)-M(27)+M(28)+M(30)-M(32)-M(37)+M(43))) * den(68)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(2)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(68)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(3)*(-M(24)+M(26)+M(27)-M(28)-M(30)+M(32)+M(37)-M(43))) * den(68)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(17)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,109)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(17)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(3)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(17)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,111)
  Gcoeff = (c(2)*(M(22)-M(28)-M(33)+M(35)+M(37)-M(38)-M(39)+M(41))) * den(17)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(2)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(17)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(3)*(-M(22)+M(28)+M(33)-M(35)-M(37)+M(38)+M(39)-M(41))) * den(17)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(18)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(18)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(3)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(18)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(2)*(M(21)-M(22)-M(27)+M(28)-M(37)+M(38)+M(43)-M(44))) * den(80)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(2)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(80)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(3)*(-M(21)+M(22)+M(27)-M(28)+M(37)-M(38)-M(43)+M(44))) * den(80)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(20)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,154)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(20)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,155)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(20)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,156)
  Gcoeff = (c(2)*(M(22)-M(25)-M(31)-M(33)+M(34)+M(36)-M(38)+M(41))) * den(88)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(2)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(88)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(3)*(-M(22)+M(25)+M(31)+M(33)-M(34)-M(36)+M(38)-M(41))) * den(88)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(22)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,85)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(22)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(22)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(2)*(M(23)-M(24)-M(31)+M(32)-M(33)+M(34)+M(41)-M(42))) * den(96)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(2)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(96)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(3)*(-M(23)+M(24)+M(31)-M(32)+M(33)-M(34)-M(41)+M(42))) * den(96)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(2)*(M(26)-M(28)+M(29)-M(30)+M(31)-M(34)+M(37)-M(40))) * den(64)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(2)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(64)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(3)*(-M(26)+M(28)-M(29)+M(30)-M(31)+M(34)-M(37)+M(40))) * den(64)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(2)*(-M(25)+M(28)-M(31)+M(34)-M(35)+M(36)-M(37)+M(39))) * den(84)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(2)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(84)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(3)*(M(25)-M(28)+M(31)-M(34)+M(35)-M(36)+M(37)-M(39))) * den(84)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(24)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(24)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(24)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(102)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(102)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(102)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(2)*(-M(21)+M(27)+M(33)-M(35)+M(39)-M(41)-M(43)+M(44))) * den(74)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,115)
  Gcoeff = (c(2)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(74)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,121)
  Gcoeff = (c(3)*(M(21)-M(27)-M(33)+M(35)-M(39)+M(41)+M(43)-M(44))) * den(74)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,127)
  Gcoeff = (c(2)*(M(23)-M(27)+M(29)-M(33)-M(40)+M(41)-M(42)+M(43))) * den(90)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(2)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(90)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,122)
  Gcoeff = (c(3)*(-M(23)+M(27)-M(29)+M(33)+M(40)-M(41)+M(42)-M(43))) * den(90)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,128)
  Gcoeff = (c(2)*(-M(25)+M(26)+M(29)-M(30)-M(35)+M(36)+M(39)-M(40))) * den(25)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,166)
  Gcoeff = (c(2)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(25)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,167)
  Gcoeff = (c(3)*(M(25)-M(26)-M(29)+M(30)+M(35)-M(36)-M(39)+M(40))) * den(25)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,168)
  Gcoeff = (c(2)*(-M(21)+M(23)+M(29)-M(35)+M(39)-M(40)-M(42)+M(44))) * den(98)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(2)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(98)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,123)
  Gcoeff = (c(3)*(M(21)-M(23)-M(29)+M(35)-M(39)+M(40)+M(42)-M(44))) * den(98)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,129)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_5

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_5_ppjjj_ggggg_1_/**/REALKIND
