
module ol_vamp_1_ppjjj_ggggg_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ggggg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ggggg_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjjj_ggggg_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppjjj_ggggg_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppjjj_ggggg_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjjj_ggggg_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(44,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j+M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(26,:)%j+M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(16),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,19),heltab2x32(:,:,19))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(28,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(20),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(22),m3h2x16(:,22),heltab2x32(:,:,22))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,23),heltab2x32(:,:,23))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,24),heltab2x32(:,:,24))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,26),heltab2x32(:,:,26))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(28),m3h2x16(:,28),heltab2x32(:,:,28))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(31),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_DV_C(ntryL,G1H16(1),16,ex3(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_CV_D(ntryL,G1H16(2),16,ex3(:),4,G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_UV_W(ntryL,G1H16(3),16,ex3(:),4,G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_CV_D(ntryL,G1H16(4),16,ex2(:),2,G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_DV_C(ntryL,G1H16(5),16,ex2(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_UV_W(ntryL,G1H16(6),16,ex2(:),2,G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_CV_D(ntryL,G1H16(7),16,ex3(:),4,G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_DV_C(ntryL,G1H16(8),16,ex3(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_UV_W(ntryL,G1H16(9),16,ex3(:),4,G2H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_CV_D(ntryL,G1H16(10),16,ex2(:),2,G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_DV_C(ntryL,G1H16(11),16,ex2(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_UV_W(ntryL,G1H16(12),16,ex2(:),2,G2H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_DV_C(ntryL,G1H16(13),16,ex1(:),G2H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_CV_D(ntryL,G1H16(14),16,ex1(:),1,G2H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_UV_W(ntryL,G1H16(15),16,ex1(:),1,G2H8(15),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_DV_C(ntryL,G1H16(16),16,ex1(:),G2H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_CV_D(ntryL,G1H16(17),16,ex1(:),1,G2H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_UV_W(ntryL,G1H16(18),16,ex1(:),1,G2H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_CV_D(ntryL,G1H16(19),16,ex2(:),2,G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_DV_C(ntryL,G1H16(20),16,ex2(:),G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_UV_W(ntryL,G1H16(21),16,ex2(:),2,G2H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_DV_C(ntryL,G1H16(22),16,ex2(:),G2H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_CV_D(ntryL,G1H16(23),16,ex2(:),2,G2H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_UV_W(ntryL,G1H16(24),16,ex2(:),2,G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_DV_C(ntryL,G1H16(25),16,ex1(:),G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_CV_D(ntryL,G1H16(26),16,ex1(:),1,G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_UV_W(ntryL,G1H16(27),16,ex1(:),1,G2H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_DV_C(ntryL,G1H16(28),16,ex1(:),G2H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_CV_D(ntryL,G1H16(29),16,ex1(:),1,G2H8(29),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_UV_W(ntryL,G1H16(30),16,ex1(:),1,G2H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_DV_C(ntryL,G1H16(31),16,ex1(:),G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_CV_D(ntryL,G1H16(32),16,ex1(:),1,G2H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_UV_W(ntryL,G1H16(33),16,ex1(:),1,G2H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_DV_C(ntryL,G1H16(34),16,ex1(:),G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_CV_D(ntryL,G1H16(35),16,ex1(:),1,G2H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_UV_W(ntryL,G1H16(36),16,ex1(:),1,G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(1),mass5set(:,1),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(2),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(2),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(2),mass5set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(3),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(3),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(3),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(4),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),4,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(4),mass5set(:,1),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),4,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(4),mass5set(:,1),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(5),mass5set(:,1),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),8,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(5),mass5set(:,1),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(5),mass5set(:,1),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(6),mass5set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),4,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(6),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),4,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(6),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),4,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(7),mass5set(:,1),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(7),mass5set(:,1),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(7),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(8),mass5set(:,1),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),4,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(8),mass5set(:,1),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),4,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(8),mass5set(:,1),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),4,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(9),mass5set(:,1),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(9),mass5set(:,1),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(9),mass5set(:,1),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(10),mass5set(:,1),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),2,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(10),mass5set(:,1),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),2,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(10),mass5set(:,1),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),2,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(11),mass5set(:,1),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(11),mass5set(:,1),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),4,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(11),mass5set(:,1),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),4,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(12),mass5set(:,1),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),2,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(12),mass5set(:,1),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),2,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(12),mass5set(:,1),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),2,8)
  call Hloop_DV_C(ntryL,G1H8(1),20,ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(2),-8,ex4(:),8,G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_DV_C(ntryL,G1H8(4),20,ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_DV_C(ntryL,G1H8(5),20,ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_DV_C(ntryL,G1H8(6),20,ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_CV_D(ntryL,G1H8(7),20,ex1(:),1,G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(8),-8,ex4(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_CV_D(ntryL,G1H8(10),20,ex1(:),1,G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_CV_D(ntryL,G1H8(11),20,ex1(:),1,G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_CV_D(ntryL,G1H8(12),20,ex1(:),1,G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_UV_W(ntryL,G1H8(13),20,ex1(:),1,G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(14),-8,ex4(:),8,G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
call signflip_OLR(G2H4(12))
  call Hloop_UV_W(ntryL,G1H8(16),20,ex1(:),1,G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_UV_W(ntryL,G1H8(17),20,ex1(:),1,G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_UV_W(ntryL,G1H8(18),20,ex1(:),1,G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_CV_D(ntryL,G1H8(19),18,ex1(:),1,G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(20),-8,ex4(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_CV_D(ntryL,G1H8(22),18,ex1(:),1,G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_CV_D(ntryL,G1H8(23),18,ex1(:),1,G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_CV_D(ntryL,G1H8(24),18,ex1(:),1,G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_DV_C(ntryL,G1H8(25),18,ex1(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(26),-8,ex4(:),8,G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_DV_C(ntryL,G1H8(28),18,ex1(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_DV_C(ntryL,G1H8(29),18,ex1(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_DV_C(ntryL,G1H8(30),18,ex1(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_UV_W(ntryL,G1H8(31),18,ex1(:),1,G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(32),-8,ex4(:),8,G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
call signflip_OLR(G2H4(27))
  call Hloop_UV_W(ntryL,G1H8(34),18,ex1(:),1,G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_UV_W(ntryL,G1H8(35),18,ex1(:),1,G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_UV_W(ntryL,G1H8(36),18,ex1(:),1,G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_CV_D(ntryL,G1H8(37),20,ex2(:),2,G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(38),-8,ex4(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_CV_D(ntryL,G1H8(40),20,ex2(:),2,G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_CV_D(ntryL,G1H8(41),20,ex2(:),2,G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_CV_D(ntryL,G1H8(42),20,ex2(:),2,G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_DV_C(ntryL,G1H8(43),20,ex2(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(44),-8,ex4(:),8,G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_DV_C(ntryL,G1H8(46),20,ex2(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_DV_C(ntryL,G1H8(47),20,ex2(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_DV_C(ntryL,G1H8(48),20,ex2(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_UV_W(ntryL,G1H8(49),20,ex2(:),2,G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(50),-8,ex4(:),8,G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
call signflip_OLR(G2H4(42))
  call Hloop_UV_W(ntryL,G1H8(52),20,ex2(:),2,G2H4(43),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_UV_W(ntryL,G1H8(53),20,ex2(:),2,G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_UV_W(ntryL,G1H8(54),20,ex2(:),2,G2H4(45),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_CV_D(ntryL,G1H8(55),18,ex1(:),1,G2H4(46),m3h2x4(:,46),heltab2x8(:,:,46))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(56),-4,ex3(:),G2H4(47),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_CV_D(ntryL,G1H8(58),18,ex1(:),1,G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_CV_D(ntryL,G1H8(59),18,ex1(:),1,G2H4(49),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_CV_D(ntryL,G1H8(60),18,ex1(:),1,G2H4(50),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_DV_C(ntryL,G1H8(61),18,ex1(:),G2H4(51),m3h2x4(:,51),heltab2x8(:,:,51))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(62),-4,ex3(:),4,G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_DV_C(ntryL,G1H8(64),18,ex1(:),G2H4(53),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_DV_C(ntryL,G1H8(65),18,ex1(:),G2H4(54),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_DV_C(ntryL,G1H8(66),18,ex1(:),G2H4(55),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_UV_W(ntryL,G1H8(67),18,ex1(:),1,G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(68),-4,ex3(:),4,G2H4(57),m3h2x4(:,57),heltab2x8(:,:,57))
call signflip_OLR(G2H4(57))
  call Hloop_UV_W(ntryL,G1H8(70),18,ex1(:),1,G2H4(58),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_UV_W(ntryL,G1H8(71),18,ex1(:),1,G2H4(59),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_UV_W(ntryL,G1H8(72),18,ex1(:),1,G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_DV_C(ntryL,G1H8(73),17,ex2(:),G2H4(61),m3h2x4(:,61),heltab2x8(:,:,61))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(74),-8,ex4(:),8,G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_DV_C(ntryL,G1H8(76),17,ex2(:),G2H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_DV_C(ntryL,G1H8(77),17,ex2(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_DV_C(ntryL,G1H8(78),17,ex2(:),G2H4(65),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_CV_D(ntryL,G1H8(79),17,ex2(:),2,G2H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(80),-8,ex4(:),G2H4(67),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_CV_D(ntryL,G1H8(82),17,ex2(:),2,G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_CV_D(ntryL,G1H8(83),17,ex2(:),2,G2H4(69),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_CV_D(ntryL,G1H8(84),17,ex2(:),2,G2H4(70),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_UV_W(ntryL,G1H8(85),17,ex2(:),2,G2H4(71),m3h2x4(:,71),heltab2x8(:,:,71))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(86),-8,ex4(:),8,G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
call signflip_OLR(G2H4(72))
  call Hloop_UV_W(ntryL,G1H8(88),17,ex2(:),2,G2H4(73),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_UV_W(ntryL,G1H8(89),17,ex2(:),2,G2H4(74),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_UV_W(ntryL,G1H8(90),17,ex2(:),2,G2H4(75),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_DV_C(ntryL,G1H8(91),17,ex2(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(92),-4,ex3(:),4,G2H4(77),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_DV_C(ntryL,G1H8(94),17,ex2(:),G2H4(78),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_DV_C(ntryL,G1H8(95),17,ex2(:),G2H4(79),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_DV_C(ntryL,G1H8(96),17,ex2(:),G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_CV_D(ntryL,G1H8(97),17,ex2(:),2,G2H4(81),m3h2x4(:,81),heltab2x8(:,:,81))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(98),-4,ex3(:),G2H4(82),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_CV_D(ntryL,G1H8(100),17,ex2(:),2,G2H4(83),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_CV_D(ntryL,G1H8(101),17,ex2(:),2,G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_CV_D(ntryL,G1H8(102),17,ex2(:),2,G2H4(85),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_UV_W(ntryL,G1H8(103),17,ex2(:),2,G2H4(86),m3h2x4(:,86),heltab2x8(:,:,86))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(104),-4,ex3(:),4,G2H4(87),m3h2x4(:,87),heltab2x8(:,:,87))
call signflip_OLR(G2H4(87))
  call Hloop_UV_W(ntryL,G1H8(106),17,ex2(:),2,G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_UV_W(ntryL,G1H8(107),17,ex2(:),2,G2H4(89),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_UV_W(ntryL,G1H8(108),17,ex2(:),2,G2H4(90),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_CV_D(ntryL,G1H8(109),18,ex3(:),4,G2H4(91),m3h2x4(:,91),heltab2x8(:,:,91))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(110),-8,ex4(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_CV_D(ntryL,G1H8(112),18,ex3(:),4,G2H4(93),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_CV_D(ntryL,G1H8(113),18,ex3(:),4,G2H4(94),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_CV_D(ntryL,G1H8(114),18,ex3(:),4,G2H4(95),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_DV_C(ntryL,G1H8(115),18,ex3(:),G2H4(96),m3h2x4(:,96),heltab2x8(:,:,96))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(116),-8,ex4(:),8,G2H4(97),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_DV_C(ntryL,G1H8(118),18,ex3(:),G2H4(98),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_DV_C(ntryL,G1H8(119),18,ex3(:),G2H4(99),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_DV_C(ntryL,G1H8(120),18,ex3(:),G2H4(100),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_UV_W(ntryL,G1H8(121),18,ex3(:),4,G2H4(101),m3h2x4(:,101),heltab2x8(:,:,101))
call HGT_raise_alpha_OLR(G1H8(122),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(122),-8,ex4(:),8,G2H4(102),m3h2x4(:,102),heltab2x8(:,:,102))
call signflip_OLR(G2H4(102))
  call Hloop_UV_W(ntryL,G1H8(124),18,ex3(:),4,G2H4(103),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_UV_W(ntryL,G1H8(125),18,ex3(:),4,G2H4(104),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_UV_W(ntryL,G1H8(126),18,ex3(:),4,G2H4(105),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_DV_C(ntryL,G1H8(127),18,ex4(:),G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(128),-4,ex3(:),4,G2H4(107),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_DV_C(ntryL,G1H8(130),18,ex4(:),G2H4(108),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_DV_C(ntryL,G1H8(131),18,ex4(:),G2H4(109),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_DV_C(ntryL,G1H8(132),18,ex4(:),G2H4(110),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_CV_D(ntryL,G1H8(133),18,ex4(:),8,G2H4(111),m3h2x4(:,111),heltab2x8(:,:,111))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(134),-4,ex3(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_CV_D(ntryL,G1H8(136),18,ex4(:),8,G2H4(113),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_CV_D(ntryL,G1H8(137),18,ex4(:),8,G2H4(114),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_CV_D(ntryL,G1H8(138),18,ex4(:),8,G2H4(115),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_UV_W(ntryL,G1H8(139),18,ex4(:),8,G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
call HGT_raise_alpha_OLR(G1H8(140),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(140),-4,ex3(:),4,G2H4(117),m3h2x4(:,117),heltab2x8(:,:,117))
call signflip_OLR(G2H4(117))
  call Hloop_UV_W(ntryL,G1H8(142),18,ex4(:),8,G2H4(118),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_UV_W(ntryL,G1H8(143),18,ex4(:),8,G2H4(119),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_UV_W(ntryL,G1H8(144),18,ex4(:),8,G2H4(120),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_DV_C(ntryL,G1H8(145),17,ex3(:),G2H4(121),m3h2x4(:,121),heltab2x8(:,:,121))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(146),-8,ex4(:),8,G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_DV_C(ntryL,G1H8(148),17,ex3(:),G2H4(123),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_DV_C(ntryL,G1H8(149),17,ex3(:),G2H4(124),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_DV_C(ntryL,G1H8(150),17,ex3(:),G2H4(125),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_CV_D(ntryL,G1H8(151),17,ex3(:),4,G2H4(126),m3h2x4(:,126),heltab2x8(:,:,126))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(152),-8,ex4(:),G2H4(127),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_CV_D(ntryL,G1H8(154),17,ex3(:),4,G2H4(128),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_CV_D(ntryL,G1H8(155),17,ex3(:),4,G2H4(129),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_CV_D(ntryL,G1H8(156),17,ex3(:),4,G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_UV_W(ntryL,G1H8(157),17,ex3(:),4,G2H4(131),m3h2x4(:,131),heltab2x8(:,:,131))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(158),-8,ex4(:),8,G2H4(132),m3h2x4(:,132),heltab2x8(:,:,132))
call signflip_OLR(G2H4(132))
  call Hloop_UV_W(ntryL,G1H8(160),17,ex3(:),4,G2H4(133),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_UV_W(ntryL,G1H8(161),17,ex3(:),4,G2H4(134),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_UV_W(ntryL,G1H8(162),17,ex3(:),4,G2H4(135),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_DV_C(ntryL,G1H8(163),17,ex3(:),G2H4(136),m3h2x4(:,136),heltab2x8(:,:,136))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(164),-2,ex2(:),2,G2H4(137),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_DV_C(ntryL,G1H8(166),17,ex3(:),G2H4(138),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_DV_C(ntryL,G1H8(167),17,ex3(:),G2H4(139),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_DV_C(ntryL,G1H8(168),17,ex3(:),G2H4(140),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_CV_D(ntryL,G1H8(169),17,ex3(:),4,G2H4(141),m3h2x4(:,141),heltab2x8(:,:,141))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(170),-2,ex2(:),G2H4(142),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_CV_D(ntryL,G1H8(172),17,ex3(:),4,G2H4(143),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_CV_D(ntryL,G1H8(173),17,ex3(:),4,G2H4(144),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_CV_D(ntryL,G1H8(174),17,ex3(:),4,G2H4(145),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_UV_W(ntryL,G1H8(175),17,ex3(:),4,G2H4(146),m3h2x4(:,146),heltab2x8(:,:,146))
call HGT_raise_alpha_OLR(G1H8(176),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(176),-2,ex2(:),2,G2H4(147),m3h2x4(:,147),heltab2x8(:,:,147))
call signflip_OLR(G2H4(147))
  call Hloop_UV_W(ntryL,G1H8(178),17,ex3(:),4,G2H4(148),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_UV_W(ntryL,G1H8(179),17,ex3(:),4,G2H4(149),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_UV_W(ntryL,G1H8(180),17,ex3(:),4,G2H4(150),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_DV_C(ntryL,G1H8(181),17,ex4(:),G2H4(151),m3h2x4(:,151),heltab2x8(:,:,151))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(182),-4,ex3(:),4,G2H4(152),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_DV_C(ntryL,G1H8(184),17,ex4(:),G2H4(153),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_DV_C(ntryL,G1H8(185),17,ex4(:),G2H4(154),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_DV_C(ntryL,G1H8(186),17,ex4(:),G2H4(155),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_CV_D(ntryL,G1H8(187),17,ex4(:),8,G2H4(156),m3h2x4(:,156),heltab2x8(:,:,156))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(188),-4,ex3(:),G2H4(157),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_CV_D(ntryL,G1H8(190),17,ex4(:),8,G2H4(158),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_CV_D(ntryL,G1H8(191),17,ex4(:),8,G2H4(159),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_CV_D(ntryL,G1H8(192),17,ex4(:),8,G2H4(160),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_UV_W(ntryL,G1H8(193),17,ex4(:),8,G2H4(161),m3h2x4(:,161),heltab2x8(:,:,161))
call HGT_raise_alpha_OLR(G1H8(194),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(194),-4,ex3(:),4,G2H4(162),m3h2x4(:,162),heltab2x8(:,:,162))
call signflip_OLR(G2H4(162))
  call Hloop_UV_W(ntryL,G1H8(196),17,ex4(:),8,G2H4(163),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_UV_W(ntryL,G1H8(197),17,ex4(:),8,G2H4(164),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_UV_W(ntryL,G1H8(198),17,ex4(:),8,G2H4(165),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_DV_C(ntryL,G1H8(199),17,ex4(:),G2H4(166),m3h2x4(:,166),heltab2x8(:,:,166))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(200),-2,ex2(:),2,G2H4(167),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_DV_C(ntryL,G1H8(202),17,ex4(:),G2H4(168),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_DV_C(ntryL,G1H8(203),17,ex4(:),G2H4(169),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_DV_C(ntryL,G1H8(204),17,ex4(:),G2H4(170),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_CV_D(ntryL,G1H8(205),17,ex4(:),8,G2H4(171),m3h2x4(:,171),heltab2x8(:,:,171))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(206),-2,ex2(:),G2H4(172),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_CV_D(ntryL,G1H8(208),17,ex4(:),8,G2H4(173),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_CV_D(ntryL,G1H8(209),17,ex4(:),8,G2H4(174),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_CV_D(ntryL,G1H8(210),17,ex4(:),8,G2H4(175),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_UV_W(ntryL,G1H8(211),17,ex4(:),8,G2H4(176),m3h2x4(:,176),heltab2x8(:,:,176))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(212),-2,ex2(:),2,G2H4(177),m3h2x4(:,177),heltab2x8(:,:,177))
call signflip_OLR(G2H4(177))
  call Hloop_UV_W(ntryL,G1H8(214),17,ex4(:),8,G2H4(178),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_UV_W(ntryL,G1H8(215),17,ex4(:),8,G2H4(179),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_UV_W(ntryL,G1H8(216),17,ex4(:),8,G2H4(180),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(1),mass4set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G0H4(1),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(2),mass4set(:,1),  & 
G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),G0H4(2),4)
  call HG1shiftOLR(G1H4(13),10,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,1),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(1),mass4set(:,1),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G0H4(3),4)
  call HG1shiftOLR(G1H4(24),8,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(2),mass4set(:,1),  & 
G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),G0H4(4),4)
  call HG1shiftOLR(G1H4(29),10,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(1),mass5set(:,1),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(1),mass4set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G0H4(5),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(2),mass4set(:,1),  & 
G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),G0H4(6),4)
  call HG1shiftOLR(G1H4(45),10,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(2),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(3),mass4set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G0H4(7),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(4),mass4set(:,1),  & 
G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),G0H4(8),4)
  call HG1shiftOLR(G1H4(61),12,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(2),mass5set(:,1),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(3),mass4set(:,1),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G0H4(9),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(4),mass4set(:,1),  & 
G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),G0H4(10),4)
  call HG1shiftOLR(G1H4(77),12,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(2),mass5set(:,1),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(3),mass4set(:,1),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G0H4(11),4)
  call HG1shiftOLR(G1H4(88),8,4)
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(4),mass4set(:,1),  & 
G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),G0H4(12),4)
  call HG1shiftOLR(G1H4(93),12,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(3),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(1),mass4set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G0H4(13),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(5),mass4set(:,1),  & 
G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),G0H4(14),4)
  call HG1shiftOLR(G1H4(109),9,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(3),mass5set(:,1),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),8,4)
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(1),mass4set(:,1),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G0H4(15),4)
  call HG1shiftOLR(G1H4(120),8,4)
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(5),mass4set(:,1),  & 
G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),G0H4(16),4)
  call HG1shiftOLR(G1H4(125),9,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(3),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),8,4)
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(1),mass4set(:,1),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G0H4(17),4)
  call HG1shiftOLR(G1H4(136),8,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(5),mass4set(:,1),  & 
G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),G0H4(18),4)
  call HG1shiftOLR(G1H4(141),9,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(4),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),4,4)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(6),mass4set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G0H4(19),4)
  call HG1shiftOLR(G1H4(152),4,4)
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(4),mass4set(:,1),  & 
G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),G0H4(20),4)
  call HG1shiftOLR(G1H4(157),12,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(4),mass5set(:,1),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),4,4)
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(6),mass4set(:,1),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G0H4(21),4)
  call HG1shiftOLR(G1H4(168),4,4)
  call Hotf_4pt_reduction(G2H4(55),RedSet_4(4),mass4set(:,1),  & 
G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),G0H4(22),4)
  call HG1shiftOLR(G1H4(173),12,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(4),mass5set(:,1),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(178),4,4)
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(6),mass4set(:,1),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),G0H4(23),4)
  call HG1shiftOLR(G1H4(184),4,4)
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(4),mass4set(:,1),  & 
G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),G0H4(24),4)
  call HG1shiftOLR(G1H4(189),12,4)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(5),mass5set(:,1),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(7),mass4set(:,1),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G0H4(25),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(8),mass4set(:,1),  & 
G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),G0H4(26),4)
  call HG1shiftOLR(G1H4(205),12,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(5),mass5set(:,1),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(210),8,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(7),mass4set(:,1),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G0H4(27),4)
  call HG1shiftOLR(G1H4(216),8,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(8),mass4set(:,1),  & 
G1H4(220),G1H4(221),G1H4(222),G1H4(223),G1H4(224),G0H4(28),4)
  call HG1shiftOLR(G1H4(221),12,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(5),mass5set(:,1),  & 
G1H4(225),G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(226),8,4)
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(7),mass4set(:,1),  & 
G1H4(231),G1H4(232),G1H4(233),G1H4(234),G1H4(235),G0H4(29),4)
  call HG1shiftOLR(G1H4(232),8,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(8),mass4set(:,1),  & 
G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),G0H4(30),4)
  call HG1shiftOLR(G1H4(237),12,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(6),mass5set(:,1),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),4,4)
  call Hotf_4pt_reduction(G2H4(79),RedSet_4(9),mass4set(:,1),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G0H4(31),4)
  call HG1shiftOLR(G1H4(248),4,4)
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(8),mass4set(:,1),  & 
G1H4(252),G1H4(253),G1H4(254),G1H4(255),G1H4(256),G0H4(32),4)
  call HG1shiftOLR(G1H4(253),12,4)
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(6),mass5set(:,1),  & 
G1H4(257),G1H4(258),G1H4(259),G1H4(260),G1H4(261),G1H4(262),4)
  call HG1shiftOLR(G1H4(258),4,4)
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(9),mass4set(:,1),  & 
G1H4(263),G1H4(264),G1H4(265),G1H4(266),G1H4(267),G0H4(33),4)
  call HG1shiftOLR(G1H4(264),4,4)
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(8),mass4set(:,1),  & 
G1H4(268),G1H4(269),G1H4(270),G1H4(271),G1H4(272),G0H4(34),4)
  call HG1shiftOLR(G1H4(269),12,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(6),mass5set(:,1),  & 
G1H4(273),G1H4(274),G1H4(275),G1H4(276),G1H4(277),G1H4(278),4)
  call HG1shiftOLR(G1H4(274),4,4)
  call Hotf_4pt_reduction(G2H4(89),RedSet_4(9),mass4set(:,1),  & 
G1H4(279),G1H4(280),G1H4(281),G1H4(282),G1H4(283),G0H4(35),4)
  call HG1shiftOLR(G1H4(280),4,4)
  call Hotf_4pt_reduction(G2H4(90),RedSet_4(8),mass4set(:,1),  & 
G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),G0H4(36),4)
  call HG1shiftOLR(G1H4(285),12,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(7),mass5set(:,1),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),8,4)
  call Hotf_4pt_reduction(G2H4(94),RedSet_4(3),mass4set(:,1),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G0H4(37),4)
  call HG1shiftOLR(G1H4(296),8,4)
  call Hotf_4pt_reduction(G2H4(95),RedSet_4(10),mass4set(:,1),  & 
G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),G0H4(38),4)
  call HG1shiftOLR(G1H4(301),9,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(7),mass5set(:,1),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),8,4)
  call Hotf_4pt_reduction(G2H4(99),RedSet_4(3),mass4set(:,1),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G0H4(39),4)
  call HG1shiftOLR(G1H4(312),8,4)
  call Hotf_4pt_reduction(G2H4(100),RedSet_4(10),mass4set(:,1),  & 
G1H4(316),G1H4(317),G1H4(318),G1H4(319),G1H4(320),G0H4(40),4)
  call HG1shiftOLR(G1H4(317),9,4)
  call Hotf_5pt_reduction(G2H4(101),RedSet_5(7),mass5set(:,1),  & 
G1H4(321),G1H4(322),G1H4(323),G1H4(324),G1H4(325),G1H4(326),4)
  call HG1shiftOLR(G1H4(322),8,4)
  call Hotf_4pt_reduction(G2H4(104),RedSet_4(3),mass4set(:,1),  & 
G1H4(327),G1H4(328),G1H4(329),G1H4(330),G1H4(331),G0H4(41),4)
  call HG1shiftOLR(G1H4(328),8,4)
  call Hotf_4pt_reduction(G2H4(105),RedSet_4(10),mass4set(:,1),  & 
G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),G0H4(42),4)
  call HG1shiftOLR(G1H4(333),9,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(8),mass5set(:,1),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),4,4)
  call Hotf_4pt_reduction(G2H4(109),RedSet_4(6),mass4set(:,1),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G0H4(43),4)
  call HG1shiftOLR(G1H4(344),4,4)
  call Hotf_4pt_reduction(G2H4(110),RedSet_4(11),mass4set(:,1),  & 
G1H4(348),G1H4(349),G1H4(350),G1H4(351),G1H4(352),G0H4(44),4)
  call HG1shiftOLR(G1H4(349),5,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(8),mass5set(:,1),  & 
G1H4(353),G1H4(354),G1H4(355),G1H4(356),G1H4(357),G1H4(358),4)
  call HG1shiftOLR(G1H4(354),4,4)
  call Hotf_4pt_reduction(G2H4(114),RedSet_4(6),mass4set(:,1),  & 
G1H4(359),G1H4(360),G1H4(361),G1H4(362),G1H4(363),G0H4(45),4)
  call HG1shiftOLR(G1H4(360),4,4)
  call Hotf_4pt_reduction(G2H4(115),RedSet_4(11),mass4set(:,1),  & 
G1H4(364),G1H4(365),G1H4(366),G1H4(367),G1H4(368),G0H4(46),4)
  call HG1shiftOLR(G1H4(365),5,4)
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(8),mass5set(:,1),  & 
G1H4(369),G1H4(370),G1H4(371),G1H4(372),G1H4(373),G1H4(374),4)
  call HG1shiftOLR(G1H4(370),4,4)
  call Hotf_4pt_reduction(G2H4(119),RedSet_4(6),mass4set(:,1),  & 
G1H4(375),G1H4(376),G1H4(377),G1H4(378),G1H4(379),G0H4(47),4)
  call HG1shiftOLR(G1H4(376),4,4)
  call Hotf_4pt_reduction(G2H4(120),RedSet_4(11),mass4set(:,1),  & 
G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),G0H4(48),4)
  call HG1shiftOLR(G1H4(381),5,4)
  call Hotf_5pt_reduction(G2H4(121),RedSet_5(9),mass5set(:,1),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),8,4)
  call Hotf_4pt_reduction(G2H4(124),RedSet_4(7),mass4set(:,1),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),G0H4(49),4)
  call HG1shiftOLR(G1H4(392),8,4)
  call Hotf_4pt_reduction(G2H4(125),RedSet_4(12),mass4set(:,1),  & 
G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),G0H4(50),4)
  call HG1shiftOLR(G1H4(397),10,4)
  call Hotf_5pt_reduction(G2H4(126),RedSet_5(9),mass5set(:,1),  & 
G1H4(401),G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),4)
  call HG1shiftOLR(G1H4(402),8,4)
  call Hotf_4pt_reduction(G2H4(129),RedSet_4(7),mass4set(:,1),  & 
G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),G0H4(51),4)
  call HG1shiftOLR(G1H4(408),8,4)
  call Hotf_4pt_reduction(G2H4(130),RedSet_4(12),mass4set(:,1),  & 
G1H4(412),G1H4(413),G1H4(414),G1H4(415),G1H4(416),G0H4(52),4)
  call HG1shiftOLR(G1H4(413),10,4)
  call Hotf_5pt_reduction(G2H4(131),RedSet_5(9),mass5set(:,1),  & 
G1H4(417),G1H4(418),G1H4(419),G1H4(420),G1H4(421),G1H4(422),4)
  call HG1shiftOLR(G1H4(418),8,4)
  call Hotf_4pt_reduction(G2H4(134),RedSet_4(7),mass4set(:,1),  & 
G1H4(423),G1H4(424),G1H4(425),G1H4(426),G1H4(427),G0H4(53),4)
  call HG1shiftOLR(G1H4(424),8,4)
  call Hotf_4pt_reduction(G2H4(135),RedSet_4(12),mass4set(:,1),  & 
G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),G0H4(54),4)
  call HG1shiftOLR(G1H4(429),10,4)
  call Hotf_5pt_reduction(G2H4(136),RedSet_5(10),mass5set(:,1),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),2,4)
  call Hotf_4pt_reduction(G2H4(139),RedSet_4(13),mass4set(:,1),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),G0H4(55),4)
  call HG1shiftOLR(G1H4(440),2,4)
  call Hotf_4pt_reduction(G2H4(140),RedSet_4(12),mass4set(:,1),  & 
G1H4(444),G1H4(445),G1H4(446),G1H4(447),G1H4(448),G0H4(56),4)
  call HG1shiftOLR(G1H4(445),10,4)
  call Hotf_5pt_reduction(G2H4(141),RedSet_5(10),mass5set(:,1),  & 
G1H4(449),G1H4(450),G1H4(451),G1H4(452),G1H4(453),G1H4(454),4)
  call HG1shiftOLR(G1H4(450),2,4)
  call Hotf_4pt_reduction(G2H4(144),RedSet_4(13),mass4set(:,1),  & 
G1H4(455),G1H4(456),G1H4(457),G1H4(458),G1H4(459),G0H4(57),4)
  call HG1shiftOLR(G1H4(456),2,4)
  call Hotf_4pt_reduction(G2H4(145),RedSet_4(12),mass4set(:,1),  & 
G1H4(460),G1H4(461),G1H4(462),G1H4(463),G1H4(464),G0H4(58),4)
  call HG1shiftOLR(G1H4(461),10,4)
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(10),mass5set(:,1),  & 
G1H4(465),G1H4(466),G1H4(467),G1H4(468),G1H4(469),G1H4(470),4)
  call HG1shiftOLR(G1H4(466),2,4)
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(13),mass4set(:,1),  & 
G1H4(471),G1H4(472),G1H4(473),G1H4(474),G1H4(475),G0H4(59),4)
  call HG1shiftOLR(G1H4(472),2,4)
  call Hotf_4pt_reduction(G2H4(150),RedSet_4(12),mass4set(:,1),  & 
G1H4(476),G1H4(477),G1H4(478),G1H4(479),G1H4(480),G0H4(60),4)
  call HG1shiftOLR(G1H4(477),10,4)
  call Hotf_5pt_reduction(G2H4(151),RedSet_5(11),mass5set(:,1),  & 
G1H4(481),G1H4(482),G1H4(483),G1H4(484),G1H4(485),G1H4(486),4)
  call HG1shiftOLR(G1H4(482),4,4)
  call Hotf_4pt_reduction(G2H4(154),RedSet_4(9),mass4set(:,1),  & 
G1H4(487),G1H4(488),G1H4(489),G1H4(490),G1H4(491),G0H4(61),4)
  call HG1shiftOLR(G1H4(488),4,4)
  call Hotf_4pt_reduction(G2H4(155),RedSet_4(14),mass4set(:,1),  & 
G1H4(492),G1H4(493),G1H4(494),G1H4(495),G1H4(496),G0H4(62),4)
  call HG1shiftOLR(G1H4(493),6,4)
  call Hotf_5pt_reduction(G2H4(156),RedSet_5(11),mass5set(:,1),  & 
G1H4(497),G1H4(498),G1H4(499),G1H4(500),G1H4(501),G1H4(502),4)
  call HG1shiftOLR(G1H4(498),4,4)
  call Hotf_4pt_reduction(G2H4(159),RedSet_4(9),mass4set(:,1),  & 
G1H4(503),G1H4(504),G1H4(505),G1H4(506),G1H4(507),G0H4(63),4)
  call HG1shiftOLR(G1H4(504),4,4)
  call Hotf_4pt_reduction(G2H4(160),RedSet_4(14),mass4set(:,1),  & 
G1H4(508),G1H4(509),G1H4(510),G1H4(511),G1H4(512),G0H4(64),4)
  call HG1shiftOLR(G1H4(509),6,4)
  call Hotf_5pt_reduction(G2H4(161),RedSet_5(11),mass5set(:,1),  & 
G1H4(513),G1H4(514),G1H4(515),G1H4(516),G1H4(517),G1H4(518),4)
  call HG1shiftOLR(G1H4(514),4,4)
  call Hotf_4pt_reduction(G2H4(164),RedSet_4(9),mass4set(:,1),  & 
G1H4(519),G1H4(520),G1H4(521),G1H4(522),G1H4(523),G0H4(65),4)
  call HG1shiftOLR(G1H4(520),4,4)
  call Hotf_4pt_reduction(G2H4(165),RedSet_4(14),mass4set(:,1),  & 
G1H4(524),G1H4(525),G1H4(526),G1H4(527),G1H4(528),G0H4(66),4)
  call HG1shiftOLR(G1H4(525),6,4)
  call Hotf_5pt_reduction(G2H4(166),RedSet_5(12),mass5set(:,1),  & 
G1H4(529),G1H4(530),G1H4(531),G1H4(532),G1H4(533),G1H4(534),4)
  call HG1shiftOLR(G1H4(530),2,4)
  call Hotf_4pt_reduction(G2H4(169),RedSet_4(13),mass4set(:,1),  & 
G1H4(535),G1H4(536),G1H4(537),G1H4(538),G1H4(539),G0H4(67),4)
  call HG1shiftOLR(G1H4(536),2,4)
  call Hotf_4pt_reduction(G2H4(170),RedSet_4(14),mass4set(:,1),  & 
G1H4(540),G1H4(541),G1H4(542),G1H4(543),G1H4(544),G0H4(68),4)
  call HG1shiftOLR(G1H4(541),6,4)
  call Hotf_5pt_reduction(G2H4(171),RedSet_5(12),mass5set(:,1),  & 
G1H4(545),G1H4(546),G1H4(547),G1H4(548),G1H4(549),G1H4(550),4)
  call HG1shiftOLR(G1H4(546),2,4)
  call Hotf_4pt_reduction(G2H4(174),RedSet_4(13),mass4set(:,1),  & 
G1H4(551),G1H4(552),G1H4(553),G1H4(554),G1H4(555),G0H4(69),4)
  call HG1shiftOLR(G1H4(552),2,4)
  call Hotf_4pt_reduction(G2H4(175),RedSet_4(14),mass4set(:,1),  & 
G1H4(556),G1H4(557),G1H4(558),G1H4(559),G1H4(560),G0H4(70),4)
  call HG1shiftOLR(G1H4(557),6,4)
  call Hotf_5pt_reduction(G2H4(176),RedSet_5(12),mass5set(:,1),  & 
G1H4(561),G1H4(562),G1H4(563),G1H4(564),G1H4(565),G1H4(566),4)
  call HG1shiftOLR(G1H4(562),2,4)
  call Hotf_4pt_reduction(G2H4(179),RedSet_4(13),mass4set(:,1),  & 
G1H4(567),G1H4(568),G1H4(569),G1H4(570),G1H4(571),G0H4(71),4)
  call HG1shiftOLR(G1H4(568),2,4)
  call Hotf_4pt_reduction(G2H4(180),RedSet_4(14),mass4set(:,1),  & 
G1H4(572),G1H4(573),G1H4(574),G1H4(575),G1H4(576),G0H4(72),4)
  call HG1shiftOLR(G1H4(573),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(215),[G1H4(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(220),[G1H4(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G1H4(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(263),[G1H4(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(279),[G1H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(284),[G1H4(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(300),[G1H4(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(311),[G1H4(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(316),[G1H4(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(327),[G1H4(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(332),[G1H4(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(343),[G1H4(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(348),[G1H4(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(359),[G1H4(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(364),[G1H4(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(375),[G1H4(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(380),[G1H4(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(391),[G1H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(423),[G1H4(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(428),[G1H4(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(439),[G1H4(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(444),[G1H4(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(455),[G1H4(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(460),[G1H4(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(471),[G1H4(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(476),[G1H4(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(487),[G1H4(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(492),[G1H4(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(503),[G1H4(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(508),[G1H4(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(519),[G1H4(517)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(524),[G1H4(518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(535),[G1H4(533)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(540),[G1H4(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(551),[G1H4(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(556),[G1H4(550)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(567),[G1H4(565)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(572),[G1H4(566)])
  call Hloop_DV_C(ntryL,G1H4(1),21,ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(2),-8,ex4(:),8,G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_DV_C(ntryL,G1H4(7),21,ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_DV_C(ntryL,G1H4(12),21,ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(8),-8,ex4(:),8,G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_DV_C(ntryL,G1H4(11),21,ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_DV_C(ntryL,G0H4(1),21,ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(13),-10,ex4(:),8,G2H2(7),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_DV_C(ntryL,G1H4(16),21,ex2(:),G2H2(8),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_DV_C(ntryL,G0H4(2),21,ex2(:),G1H2(2),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_CV_D(ntryL,G1H4(17),21,ex2(:),2,G2H2(9),m3h2x2(:,11),heltab2x4(:,:,11))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(18),-8,ex4(:),G2H2(10),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_CV_D(ntryL,G1H4(23),21,ex2(:),2,G2H2(11),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_CV_D(ntryL,G1H4(28),21,ex2(:),2,G2H2(12),m3h2x2(:,14),heltab2x4(:,:,14))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(24),-8,ex4(:),G2H2(13),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_CV_D(ntryL,G1H4(27),21,ex2(:),2,G2H2(14),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_CV_D(ntryL,G0H4(3),21,ex2(:),2,G1H2(3),m3h2x2(:,17),heltab2x4(:,:,17))
call HGT_OLR(G1H4(29),1,1,4)
call HGT_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(29),-10,ex4(:),G2H2(15),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_CV_D(ntryL,G1H4(32),21,ex2(:),2,G2H2(16),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_CV_D(ntryL,G0H4(4),21,ex2(:),2,G1H2(4),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_UV_W(ntryL,G1H4(33),21,ex2(:),2,G2H2(17),m3h2x2(:,21),heltab2x4(:,:,21))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(34),-8,ex4(:),8,G2H2(18),m3h2x2(:,22),heltab2x4(:,:,22))
call signflip_OLR(G2H2(18))
  call Hloop_UV_W(ntryL,G1H4(39),21,ex2(:),2,G2H2(19),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_UV_W(ntryL,G1H4(44),21,ex2(:),2,G2H2(20),m3h2x2(:,24),heltab2x4(:,:,24))
call HGT_raise_alpha_OLR(G1H4(40),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(40),-8,ex4(:),8,G2H2(21),m3h2x2(:,25),heltab2x4(:,:,25))
call signflip_OLR(G2H2(21))
  call Hloop_UV_W(ntryL,G1H4(43),21,ex2(:),2,G2H2(22),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_UV_W(ntryL,G0H4(5),21,ex2(:),2,G1H2(5),m3h2x2(:,27),heltab2x4(:,:,27))
call HGT_raise_alpha_OLR(G1H4(45),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(45),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(45),-10,ex4(:),8,G2H2(23),m3h2x2(:,28),heltab2x4(:,:,28))
call signflip_OLR(G2H2(23))
  call Hloop_UV_W(ntryL,G1H4(48),21,ex2(:),2,G2H2(24),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_UV_W(ntryL,G0H4(6),21,ex2(:),2,G1H2(6),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_CV_D(ntryL,G1H4(49),19,ex3(:),4,G2H2(25),m3h2x2(:,31),heltab2x4(:,:,31))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(50),-8,ex4(:),G2H2(26),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_CV_D(ntryL,G1H4(55),19,ex3(:),4,G2H2(27),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_CV_D(ntryL,G1H4(60),19,ex3(:),4,G2H2(28),m3h2x2(:,34),heltab2x4(:,:,34))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(56),-8,ex4(:),G2H2(29),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_CV_D(ntryL,G1H4(59),19,ex3(:),4,G2H2(30),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_CV_D(ntryL,G0H4(7),19,ex3(:),4,G1H2(7),m3h2x2(:,37),heltab2x4(:,:,37))
call HGT_OLR(G1H4(61),1,1,4)
call HGT_invQ_OLR(G1H4(61),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(61),-12,ex4(:),G2H2(31),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_CV_D(ntryL,G1H4(64),19,ex3(:),4,G2H2(32),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_CV_D(ntryL,G0H4(8),19,ex3(:),4,G1H2(8),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_DV_C(ntryL,G1H4(65),19,ex3(:),G2H2(33),m3h2x2(:,41),heltab2x4(:,:,41))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(66),-8,ex4(:),8,G2H2(34),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_DV_C(ntryL,G1H4(71),19,ex3(:),G2H2(35),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_DV_C(ntryL,G1H4(76),19,ex3(:),G2H2(36),m3h2x2(:,44),heltab2x4(:,:,44))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(72),-8,ex4(:),8,G2H2(37),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_DV_C(ntryL,G1H4(75),19,ex3(:),G2H2(38),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_DV_C(ntryL,G0H4(9),19,ex3(:),G1H2(9),m3h2x2(:,47),heltab2x4(:,:,47))
call HGT_OLR(G1H4(77),1,1,4)
call HGT_invQ_OLR(G1H4(77),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(77),-12,ex4(:),8,G2H2(39),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_DV_C(ntryL,G1H4(80),19,ex3(:),G2H2(40),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_DV_C(ntryL,G0H4(10),19,ex3(:),G1H2(10),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_UV_W(ntryL,G1H4(81),19,ex3(:),4,G2H2(41),m3h2x2(:,51),heltab2x4(:,:,51))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(82),-8,ex4(:),8,G2H2(42),m3h2x2(:,52),heltab2x4(:,:,52))
call signflip_OLR(G2H2(42))
  call Hloop_UV_W(ntryL,G1H4(87),19,ex3(:),4,G2H2(43),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_UV_W(ntryL,G1H4(92),19,ex3(:),4,G2H2(44),m3h2x2(:,54),heltab2x4(:,:,54))
call HGT_raise_alpha_OLR(G1H4(88),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(88),-8,ex4(:),8,G2H2(45),m3h2x2(:,55),heltab2x4(:,:,55))
call signflip_OLR(G2H2(45))
  call Hloop_UV_W(ntryL,G1H4(91),19,ex3(:),4,G2H2(46),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_UV_W(ntryL,G0H4(11),19,ex3(:),4,G1H2(11),m3h2x2(:,57),heltab2x4(:,:,57))
call HGT_raise_alpha_OLR(G1H4(93),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(93),-12,ex4(:),8,G2H2(47),m3h2x2(:,58),heltab2x4(:,:,58))
call signflip_OLR(G2H2(47))
  call Hloop_UV_W(ntryL,G1H4(96),19,ex3(:),4,G2H2(48),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_UV_W(ntryL,G0H4(12),19,ex3(:),4,G1H2(12),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_CV_D(ntryL,G1H4(97),22,ex1(:),1,G2H2(49),m3h2x2(:,61),heltab2x4(:,:,61))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(98),-8,ex4(:),G2H2(50),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_CV_D(ntryL,G1H4(103),22,ex1(:),1,G2H2(51),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_CV_D(ntryL,G1H4(108),22,ex1(:),1,G2H2(52),m3h2x2(:,64),heltab2x4(:,:,64))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(104),-8,ex4(:),G2H2(53),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_CV_D(ntryL,G1H4(107),22,ex1(:),1,G2H2(54),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_CV_D(ntryL,G0H4(13),22,ex1(:),1,G1H2(13),m3h2x2(:,67),heltab2x4(:,:,67))
call HGT_OLR(G1H4(109),1,1,4)
call HGT_invQ_OLR(G1H4(109),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(109),-9,ex4(:),G2H2(55),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_CV_D(ntryL,G1H4(112),22,ex1(:),1,G2H2(56),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_CV_D(ntryL,G0H4(14),22,ex1(:),1,G1H2(14),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_DV_C(ntryL,G1H4(113),22,ex1(:),G2H2(57),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(114),-8,ex4(:),8,G2H2(58),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_DV_C(ntryL,G1H4(119),22,ex1(:),G2H2(59),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_DV_C(ntryL,G1H4(124),22,ex1(:),G2H2(60),m3h2x2(:,74),heltab2x4(:,:,74))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(120),-8,ex4(:),8,G2H2(61),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_DV_C(ntryL,G1H4(123),22,ex1(:),G2H2(62),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_DV_C(ntryL,G0H4(15),22,ex1(:),G1H2(15),m3h2x2(:,77),heltab2x4(:,:,77))
call HGT_OLR(G1H4(125),1,1,4)
call HGT_invQ_OLR(G1H4(125),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(125),-9,ex4(:),8,G2H2(63),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_DV_C(ntryL,G1H4(128),22,ex1(:),G2H2(64),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_DV_C(ntryL,G0H4(16),22,ex1(:),G1H2(16),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_UV_W(ntryL,G1H4(129),22,ex1(:),1,G2H2(65),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(130),-8,ex4(:),8,G2H2(66),m3h2x2(:,82),heltab2x4(:,:,82))
call signflip_OLR(G2H2(66))
  call Hloop_UV_W(ntryL,G1H4(135),22,ex1(:),1,G2H2(67),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_UV_W(ntryL,G1H4(140),22,ex1(:),1,G2H2(68),m3h2x2(:,84),heltab2x4(:,:,84))
call HGT_raise_alpha_OLR(G1H4(136),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(136),-8,ex4(:),8,G2H2(69),m3h2x2(:,85),heltab2x4(:,:,85))
call signflip_OLR(G2H2(69))
  call Hloop_UV_W(ntryL,G1H4(139),22,ex1(:),1,G2H2(70),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_UV_W(ntryL,G0H4(17),22,ex1(:),1,G1H2(17),m3h2x2(:,87),heltab2x4(:,:,87))
call HGT_raise_alpha_OLR(G1H4(141),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(141),-9,ex4(:),8,G2H2(71),m3h2x2(:,88),heltab2x4(:,:,88))
call signflip_OLR(G2H2(71))
  call Hloop_UV_W(ntryL,G1H4(144),22,ex1(:),1,G2H2(72),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UV_W(ntryL,G0H4(18),22,ex1(:),1,G1H2(18),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_CV_D(ntryL,G1H4(145),19,ex4(:),8,G2H2(73),m3h2x2(:,91),heltab2x4(:,:,91))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(146),-4,ex3(:),G2H2(74),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_CV_D(ntryL,G1H4(151),19,ex4(:),8,G2H2(75),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_CV_D(ntryL,G1H4(156),19,ex4(:),8,G2H2(76),m3h2x2(:,94),heltab2x4(:,:,94))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(152),-4,ex3(:),G2H2(77),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_CV_D(ntryL,G1H4(155),19,ex4(:),8,G2H2(78),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_CV_D(ntryL,G0H4(19),19,ex4(:),8,G1H2(19),m3h2x2(:,97),heltab2x4(:,:,97))
call HGT_OLR(G1H4(157),1,1,4)
call HGT_invQ_OLR(G1H4(157),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(157),-12,ex3(:),G2H2(79),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_CV_D(ntryL,G1H4(160),19,ex4(:),8,G2H2(80),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_CV_D(ntryL,G0H4(20),19,ex4(:),8,G1H2(20),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_DV_C(ntryL,G1H4(161),19,ex4(:),G2H2(81),m3h2x2(:,101),heltab2x4(:,:,101))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(162),-4,ex3(:),4,G2H2(82),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_DV_C(ntryL,G1H4(167),19,ex4(:),G2H2(83),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_DV_C(ntryL,G1H4(172),19,ex4(:),G2H2(84),m3h2x2(:,104),heltab2x4(:,:,104))
call HGT_OLR(G1H4(168),1,1,4)
call HGT_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(168),-4,ex3(:),4,G2H2(85),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_DV_C(ntryL,G1H4(171),19,ex4(:),G2H2(86),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_DV_C(ntryL,G0H4(21),19,ex4(:),G1H2(21),m3h2x2(:,107),heltab2x4(:,:,107))
call HGT_OLR(G1H4(173),1,1,4)
call HGT_invQ_OLR(G1H4(173),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(173),-12,ex3(:),4,G2H2(87),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_DV_C(ntryL,G1H4(176),19,ex4(:),G2H2(88),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_DV_C(ntryL,G0H4(22),19,ex4(:),G1H2(22),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_UV_W(ntryL,G1H4(177),19,ex4(:),8,G2H2(89),m3h2x2(:,111),heltab2x4(:,:,111))
call HGT_raise_alpha_OLR(G1H4(178),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(178),-4,ex3(:),4,G2H2(90),m3h2x2(:,112),heltab2x4(:,:,112))
call signflip_OLR(G2H2(90))
  call Hloop_UV_W(ntryL,G1H4(183),19,ex4(:),8,G2H2(91),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_UV_W(ntryL,G1H4(188),19,ex4(:),8,G2H2(92),m3h2x2(:,114),heltab2x4(:,:,114))
call HGT_raise_alpha_OLR(G1H4(184),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(184),-4,ex3(:),4,G2H2(93),m3h2x2(:,115),heltab2x4(:,:,115))
call signflip_OLR(G2H2(93))
  call Hloop_UV_W(ntryL,G1H4(187),19,ex4(:),8,G2H2(94),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_UV_W(ntryL,G0H4(23),19,ex4(:),8,G1H2(23),m3h2x2(:,117),heltab2x4(:,:,117))
call HGT_raise_alpha_OLR(G1H4(189),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(189),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(189),-12,ex3(:),4,G2H2(95),m3h2x2(:,118),heltab2x4(:,:,118))
call signflip_OLR(G2H2(95))
  call Hloop_UV_W(ntryL,G1H4(192),19,ex4(:),8,G2H2(96),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_UV_W(ntryL,G0H4(24),19,ex4(:),8,G1H2(24),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_DV_C(ntryL,G1H4(193),19,ex3(:),G2H2(97),m3h2x2(:,121),heltab2x4(:,:,121))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(194),-8,ex4(:),8,G2H2(98),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_DV_C(ntryL,G1H4(199),19,ex3(:),G2H2(99),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_DV_C(ntryL,G1H4(204),19,ex3(:),G2H2(100),m3h2x2(:,124),heltab2x4(:,:,124))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(200),-8,ex4(:),8,G2H2(101),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_DV_C(ntryL,G1H4(203),19,ex3(:),G2H2(102),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_DV_C(ntryL,G0H4(25),19,ex3(:),G1H2(25),m3h2x2(:,127),heltab2x4(:,:,127))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(205),-12,ex4(:),8,G2H2(103),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_DV_C(ntryL,G1H4(208),19,ex3(:),G2H2(104),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_DV_C(ntryL,G0H4(26),19,ex3(:),G1H2(26),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_CV_D(ntryL,G1H4(209),19,ex3(:),4,G2H2(105),m3h2x2(:,131),heltab2x4(:,:,131))
call HGT_OLR(G1H4(210),1,1,4)
call HGT_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(210),-8,ex4(:),G2H2(106),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_CV_D(ntryL,G1H4(215),19,ex3(:),4,G2H2(107),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_CV_D(ntryL,G1H4(220),19,ex3(:),4,G2H2(108),m3h2x2(:,134),heltab2x4(:,:,134))
call HGT_OLR(G1H4(216),1,1,4)
call HGT_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(216),-8,ex4(:),G2H2(109),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_CV_D(ntryL,G1H4(219),19,ex3(:),4,G2H2(110),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_CV_D(ntryL,G0H4(27),19,ex3(:),4,G1H2(27),m3h2x2(:,137),heltab2x4(:,:,137))
call HGT_OLR(G1H4(221),1,1,4)
call HGT_invQ_OLR(G1H4(221),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(221),-12,ex4(:),G2H2(111),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_CV_D(ntryL,G1H4(224),19,ex3(:),4,G2H2(112),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_CV_D(ntryL,G0H4(28),19,ex3(:),4,G1H2(28),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_UV_W(ntryL,G1H4(225),19,ex3(:),4,G2H2(113),m3h2x2(:,141),heltab2x4(:,:,141))
call HGT_raise_alpha_OLR(G1H4(226),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(226),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(226),-8,ex4(:),8,G2H2(114),m3h2x2(:,142),heltab2x4(:,:,142))
call signflip_OLR(G2H2(114))
  call Hloop_UV_W(ntryL,G1H4(231),19,ex3(:),4,G2H2(115),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_UV_W(ntryL,G1H4(236),19,ex3(:),4,G2H2(116),m3h2x2(:,144),heltab2x4(:,:,144))
call HGT_raise_alpha_OLR(G1H4(232),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(232),-8,ex4(:),8,G2H2(117),m3h2x2(:,145),heltab2x4(:,:,145))
call signflip_OLR(G2H2(117))
  call Hloop_UV_W(ntryL,G1H4(235),19,ex3(:),4,G2H2(118),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_UV_W(ntryL,G0H4(29),19,ex3(:),4,G1H2(29),m3h2x2(:,147),heltab2x4(:,:,147))
call HGT_raise_alpha_OLR(G1H4(237),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(237),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(237),-12,ex4(:),8,G2H2(119),m3h2x2(:,148),heltab2x4(:,:,148))
call signflip_OLR(G2H2(119))
  call Hloop_UV_W(ntryL,G1H4(240),19,ex3(:),4,G2H2(120),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_UV_W(ntryL,G0H4(30),19,ex3(:),4,G1H2(30),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_DV_C(ntryL,G1H4(241),19,ex4(:),G2H2(121),m3h2x2(:,151),heltab2x4(:,:,151))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(242),-4,ex3(:),4,G2H2(122),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_DV_C(ntryL,G1H4(247),19,ex4(:),G2H2(123),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_DV_C(ntryL,G1H4(252),19,ex4(:),G2H2(124),m3h2x2(:,154),heltab2x4(:,:,154))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(248),-4,ex3(:),4,G2H2(125),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_DV_C(ntryL,G1H4(251),19,ex4(:),G2H2(126),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_DV_C(ntryL,G0H4(31),19,ex4(:),G1H2(31),m3h2x2(:,157),heltab2x4(:,:,157))
call HGT_OLR(G1H4(253),1,1,4)
call HGT_invQ_OLR(G1H4(253),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(253),-12,ex3(:),4,G2H2(127),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_DV_C(ntryL,G1H4(256),19,ex4(:),G2H2(128),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_DV_C(ntryL,G0H4(32),19,ex4(:),G1H2(32),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_CV_D(ntryL,G1H4(257),19,ex4(:),8,G2H2(129),m3h2x2(:,161),heltab2x4(:,:,161))
call HGT_OLR(G1H4(258),1,1,4)
call HGT_invQ_OLR(G1H4(258),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(258),-4,ex3(:),G2H2(130),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_CV_D(ntryL,G1H4(263),19,ex4(:),8,G2H2(131),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_CV_D(ntryL,G1H4(268),19,ex4(:),8,G2H2(132),m3h2x2(:,164),heltab2x4(:,:,164))
call HGT_OLR(G1H4(264),1,1,4)
call HGT_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(264),-4,ex3(:),G2H2(133),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_CV_D(ntryL,G1H4(267),19,ex4(:),8,G2H2(134),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_CV_D(ntryL,G0H4(33),19,ex4(:),8,G1H2(33),m3h2x2(:,167),heltab2x4(:,:,167))
call HGT_OLR(G1H4(269),1,1,4)
call HGT_invQ_OLR(G1H4(269),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(269),-12,ex3(:),G2H2(135),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_CV_D(ntryL,G1H4(272),19,ex4(:),8,G2H2(136),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_CV_D(ntryL,G0H4(34),19,ex4(:),8,G1H2(34),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_UV_W(ntryL,G1H4(273),19,ex4(:),8,G2H2(137),m3h2x2(:,171),heltab2x4(:,:,171))
call HGT_raise_alpha_OLR(G1H4(274),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(274),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(274),-4,ex3(:),4,G2H2(138),m3h2x2(:,172),heltab2x4(:,:,172))
call signflip_OLR(G2H2(138))
  call Hloop_UV_W(ntryL,G1H4(279),19,ex4(:),8,G2H2(139),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_UV_W(ntryL,G1H4(284),19,ex4(:),8,G2H2(140),m3h2x2(:,174),heltab2x4(:,:,174))
call HGT_raise_alpha_OLR(G1H4(280),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(280),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(280),-4,ex3(:),4,G2H2(141),m3h2x2(:,175),heltab2x4(:,:,175))
call signflip_OLR(G2H2(141))
  call Hloop_UV_W(ntryL,G1H4(283),19,ex4(:),8,G2H2(142),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_UV_W(ntryL,G0H4(35),19,ex4(:),8,G1H2(35),m3h2x2(:,177),heltab2x4(:,:,177))
call HGT_raise_alpha_OLR(G1H4(285),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(285),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(285),-12,ex3(:),4,G2H2(143),m3h2x2(:,178),heltab2x4(:,:,178))
call signflip_OLR(G2H2(143))
  call Hloop_UV_W(ntryL,G1H4(288),19,ex4(:),8,G2H2(144),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_UV_W(ntryL,G0H4(36),19,ex4(:),8,G1H2(36),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_CV_D(ntryL,G1H4(289),22,ex1(:),1,G2H2(145),m3h2x2(:,181),heltab2x4(:,:,181))
call HGT_OLR(G1H4(290),1,1,4)
call HGT_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(290),-8,ex4(:),G2H2(146),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_CV_D(ntryL,G1H4(295),22,ex1(:),1,G2H2(147),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_CV_D(ntryL,G1H4(300),22,ex1(:),1,G2H2(148),m3h2x2(:,184),heltab2x4(:,:,184))
call HGT_OLR(G1H4(296),1,1,4)
call HGT_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(296),-8,ex4(:),G2H2(149),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_CV_D(ntryL,G1H4(299),22,ex1(:),1,G2H2(150),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_CV_D(ntryL,G0H4(37),22,ex1(:),1,G1H2(37),m3h2x2(:,187),heltab2x4(:,:,187))
call HGT_OLR(G1H4(301),1,1,4)
call HGT_invQ_OLR(G1H4(301),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(301),-9,ex4(:),G2H2(151),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_CV_D(ntryL,G1H4(304),22,ex1(:),1,G2H2(152),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_CV_D(ntryL,G0H4(38),22,ex1(:),1,G1H2(38),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_DV_C(ntryL,G1H4(305),22,ex1(:),G2H2(153),m3h2x2(:,191),heltab2x4(:,:,191))
call HGT_OLR(G1H4(306),1,1,4)
call HGT_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(306),-8,ex4(:),8,G2H2(154),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_DV_C(ntryL,G1H4(311),22,ex1(:),G2H2(155),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_DV_C(ntryL,G1H4(316),22,ex1(:),G2H2(156),m3h2x2(:,194),heltab2x4(:,:,194))
call HGT_OLR(G1H4(312),1,1,4)
call HGT_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(312),-8,ex4(:),8,G2H2(157),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_DV_C(ntryL,G1H4(315),22,ex1(:),G2H2(158),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_DV_C(ntryL,G0H4(39),22,ex1(:),G1H2(39),m3h2x2(:,197),heltab2x4(:,:,197))
call HGT_OLR(G1H4(317),1,1,4)
call HGT_invQ_OLR(G1H4(317),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(317),-9,ex4(:),8,G2H2(159),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_DV_C(ntryL,G1H4(320),22,ex1(:),G2H2(160),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_DV_C(ntryL,G0H4(40),22,ex1(:),G1H2(40),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_UV_W(ntryL,G1H4(321),22,ex1(:),1,G2H2(161),m3h2x2(:,201),heltab2x4(:,:,201))
call HGT_raise_alpha_OLR(G1H4(322),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(322),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(322),-8,ex4(:),8,G2H2(162),m3h2x2(:,202),heltab2x4(:,:,202))
call signflip_OLR(G2H2(162))
  call Hloop_UV_W(ntryL,G1H4(327),22,ex1(:),1,G2H2(163),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_UV_W(ntryL,G1H4(332),22,ex1(:),1,G2H2(164),m3h2x2(:,204),heltab2x4(:,:,204))
call HGT_raise_alpha_OLR(G1H4(328),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(328),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(328),-8,ex4(:),8,G2H2(165),m3h2x2(:,205),heltab2x4(:,:,205))
call signflip_OLR(G2H2(165))
  call Hloop_UV_W(ntryL,G1H4(331),22,ex1(:),1,G2H2(166),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_UV_W(ntryL,G0H4(41),22,ex1(:),1,G1H2(41),m3h2x2(:,207),heltab2x4(:,:,207))
call HGT_raise_alpha_OLR(G1H4(333),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(333),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(333),-9,ex4(:),8,G2H2(167),m3h2x2(:,208),heltab2x4(:,:,208))
call signflip_OLR(G2H2(167))
  call Hloop_UV_W(ntryL,G1H4(336),22,ex1(:),1,G2H2(168),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_UV_W(ntryL,G0H4(42),22,ex1(:),1,G1H2(42),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_DV_C(ntryL,G1H4(337),26,ex1(:),G2H2(169),m3h2x2(:,211),heltab2x4(:,:,211))
call HGT_OLR(G1H4(338),1,1,4)
call HGT_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(338),-4,ex3(:),4,G2H2(170),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_DV_C(ntryL,G1H4(343),26,ex1(:),G2H2(171),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_DV_C(ntryL,G1H4(348),26,ex1(:),G2H2(172),m3h2x2(:,214),heltab2x4(:,:,214))
call HGT_OLR(G1H4(344),1,1,4)
call HGT_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(344),-4,ex3(:),4,G2H2(173),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_DV_C(ntryL,G1H4(347),26,ex1(:),G2H2(174),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_DV_C(ntryL,G0H4(43),26,ex1(:),G1H2(43),m3h2x2(:,217),heltab2x4(:,:,217))
call HGT_OLR(G1H4(349),1,1,4)
call HGT_invQ_OLR(G1H4(349),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(349),-5,ex3(:),4,G2H2(175),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_DV_C(ntryL,G1H4(352),26,ex1(:),G2H2(176),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_DV_C(ntryL,G0H4(44),26,ex1(:),G1H2(44),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_CV_D(ntryL,G1H4(353),26,ex1(:),1,G2H2(177),m3h2x2(:,221),heltab2x4(:,:,221))
call HGT_OLR(G1H4(354),1,1,4)
call HGT_invQ_OLR(G1H4(354),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(354),-4,ex3(:),G2H2(178),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_CV_D(ntryL,G1H4(359),26,ex1(:),1,G2H2(179),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_CV_D(ntryL,G1H4(364),26,ex1(:),1,G2H2(180),m3h2x2(:,224),heltab2x4(:,:,224))
call HGT_OLR(G1H4(360),1,1,4)
call HGT_invQ_OLR(G1H4(360),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(360),-4,ex3(:),G2H2(181),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_CV_D(ntryL,G1H4(363),26,ex1(:),1,G2H2(182),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_CV_D(ntryL,G0H4(45),26,ex1(:),1,G1H2(45),m3h2x2(:,227),heltab2x4(:,:,227))
call HGT_OLR(G1H4(365),1,1,4)
call HGT_invQ_OLR(G1H4(365),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(365),-5,ex3(:),G2H2(183),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_CV_D(ntryL,G1H4(368),26,ex1(:),1,G2H2(184),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_CV_D(ntryL,G0H4(46),26,ex1(:),1,G1H2(46),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_UV_W(ntryL,G1H4(369),26,ex1(:),1,G2H2(185),m3h2x2(:,231),heltab2x4(:,:,231))
call HGT_raise_alpha_OLR(G1H4(370),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(370),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(370),-4,ex3(:),4,G2H2(186),m3h2x2(:,232),heltab2x4(:,:,232))
call signflip_OLR(G2H2(186))
  call Hloop_UV_W(ntryL,G1H4(375),26,ex1(:),1,G2H2(187),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_UV_W(ntryL,G1H4(380),26,ex1(:),1,G2H2(188),m3h2x2(:,234),heltab2x4(:,:,234))
call HGT_raise_alpha_OLR(G1H4(376),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(376),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(376),-4,ex3(:),4,G2H2(189),m3h2x2(:,235),heltab2x4(:,:,235))
call signflip_OLR(G2H2(189))
  call Hloop_UV_W(ntryL,G1H4(379),26,ex1(:),1,G2H2(190),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_UV_W(ntryL,G0H4(47),26,ex1(:),1,G1H2(47),m3h2x2(:,237),heltab2x4(:,:,237))
call HGT_raise_alpha_OLR(G1H4(381),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(381),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(381),-5,ex3(:),4,G2H2(191),m3h2x2(:,238),heltab2x4(:,:,238))
call signflip_OLR(G2H2(191))
  call Hloop_UV_W(ntryL,G1H4(384),26,ex1(:),1,G2H2(192),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_UV_W(ntryL,G0H4(48),26,ex1(:),1,G1H2(48),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_DV_C(ntryL,G1H4(385),21,ex2(:),G2H2(193),m3h2x2(:,241),heltab2x4(:,:,241))
call HGT_OLR(G1H4(386),1,1,4)
call HGT_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(386),-8,ex4(:),8,G2H2(194),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_DV_C(ntryL,G1H4(391),21,ex2(:),G2H2(195),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_DV_C(ntryL,G1H4(396),21,ex2(:),G2H2(196),m3h2x2(:,244),heltab2x4(:,:,244))
call HGT_OLR(G1H4(392),1,1,4)
call HGT_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(392),-8,ex4(:),8,G2H2(197),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_DV_C(ntryL,G1H4(395),21,ex2(:),G2H2(198),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_DV_C(ntryL,G0H4(49),21,ex2(:),G1H2(49),m3h2x2(:,247),heltab2x4(:,:,247))
call HGT_OLR(G1H4(397),1,1,4)
call HGT_invQ_OLR(G1H4(397),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(397),-10,ex4(:),8,G2H2(199),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_DV_C(ntryL,G1H4(400),21,ex2(:),G2H2(200),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_DV_C(ntryL,G0H4(50),21,ex2(:),G1H2(50),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_CV_D(ntryL,G1H4(401),21,ex2(:),2,G2H2(201),m3h2x2(:,251),heltab2x4(:,:,251))
call HGT_OLR(G1H4(402),1,1,4)
call HGT_invQ_OLR(G1H4(402),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(402),-8,ex4(:),G2H2(202),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_CV_D(ntryL,G1H4(407),21,ex2(:),2,G2H2(203),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_CV_D(ntryL,G1H4(412),21,ex2(:),2,G2H2(204),m3h2x2(:,254),heltab2x4(:,:,254))
call HGT_OLR(G1H4(408),1,1,4)
call HGT_invQ_OLR(G1H4(408),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(408),-8,ex4(:),G2H2(205),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_CV_D(ntryL,G1H4(411),21,ex2(:),2,G2H2(206),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_CV_D(ntryL,G0H4(51),21,ex2(:),2,G1H2(51),m3h2x2(:,257),heltab2x4(:,:,257))
call HGT_OLR(G1H4(413),1,1,4)
call HGT_invQ_OLR(G1H4(413),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(413),-10,ex4(:),G2H2(207),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_CV_D(ntryL,G1H4(416),21,ex2(:),2,G2H2(208),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_CV_D(ntryL,G0H4(52),21,ex2(:),2,G1H2(52),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_UV_W(ntryL,G1H4(417),21,ex2(:),2,G2H2(209),m3h2x2(:,261),heltab2x4(:,:,261))
call HGT_raise_alpha_OLR(G1H4(418),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(418),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(418),-8,ex4(:),8,G2H2(210),m3h2x2(:,262),heltab2x4(:,:,262))
call signflip_OLR(G2H2(210))
  call Hloop_UV_W(ntryL,G1H4(423),21,ex2(:),2,G2H2(211),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_UV_W(ntryL,G1H4(428),21,ex2(:),2,G2H2(212),m3h2x2(:,264),heltab2x4(:,:,264))
call HGT_raise_alpha_OLR(G1H4(424),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(424),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(424),-8,ex4(:),8,G2H2(213),m3h2x2(:,265),heltab2x4(:,:,265))
call signflip_OLR(G2H2(213))
  call Hloop_UV_W(ntryL,G1H4(427),21,ex2(:),2,G2H2(214),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_UV_W(ntryL,G0H4(53),21,ex2(:),2,G1H2(53),m3h2x2(:,267),heltab2x4(:,:,267))
call HGT_raise_alpha_OLR(G1H4(429),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(429),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(429),-10,ex4(:),8,G2H2(215),m3h2x2(:,268),heltab2x4(:,:,268))
call signflip_OLR(G2H2(215))
  call Hloop_UV_W(ntryL,G1H4(432),21,ex2(:),2,G2H2(216),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_UV_W(ntryL,G0H4(54),21,ex2(:),2,G1H2(54),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_DV_C(ntryL,G1H4(433),21,ex4(:),G2H2(217),m3h2x2(:,271),heltab2x4(:,:,271))
call HGT_OLR(G1H4(434),1,1,4)
call HGT_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(434),-2,ex2(:),2,G2H2(218),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_DV_C(ntryL,G1H4(439),21,ex4(:),G2H2(219),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_DV_C(ntryL,G1H4(444),21,ex4(:),G2H2(220),m3h2x2(:,274),heltab2x4(:,:,274))
call HGT_OLR(G1H4(440),1,1,4)
call HGT_invQ_OLR(G1H4(440),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(440),-2,ex2(:),2,G2H2(221),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_DV_C(ntryL,G1H4(443),21,ex4(:),G2H2(222),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_DV_C(ntryL,G0H4(55),21,ex4(:),G1H2(55),m3h2x2(:,277),heltab2x4(:,:,277))
call HGT_OLR(G1H4(445),1,1,4)
call HGT_invQ_OLR(G1H4(445),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(445),-10,ex2(:),2,G2H2(223),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_DV_C(ntryL,G1H4(448),21,ex4(:),G2H2(224),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_DV_C(ntryL,G0H4(56),21,ex4(:),G1H2(56),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_CV_D(ntryL,G1H4(449),21,ex4(:),8,G2H2(225),m3h2x2(:,281),heltab2x4(:,:,281))
call HGT_OLR(G1H4(450),1,1,4)
call HGT_invQ_OLR(G1H4(450),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(450),-2,ex2(:),G2H2(226),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_CV_D(ntryL,G1H4(455),21,ex4(:),8,G2H2(227),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_CV_D(ntryL,G1H4(460),21,ex4(:),8,G2H2(228),m3h2x2(:,284),heltab2x4(:,:,284))
call HGT_OLR(G1H4(456),1,1,4)
call HGT_invQ_OLR(G1H4(456),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(456),-2,ex2(:),G2H2(229),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_CV_D(ntryL,G1H4(459),21,ex4(:),8,G2H2(230),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_CV_D(ntryL,G0H4(57),21,ex4(:),8,G1H2(57),m3h2x2(:,287),heltab2x4(:,:,287))
call HGT_OLR(G1H4(461),1,1,4)
call HGT_invQ_OLR(G1H4(461),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(461),-10,ex2(:),G2H2(231),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_CV_D(ntryL,G1H4(464),21,ex4(:),8,G2H2(232),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_CV_D(ntryL,G0H4(58),21,ex4(:),8,G1H2(58),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_UV_W(ntryL,G1H4(465),21,ex4(:),8,G2H2(233),m3h2x2(:,291),heltab2x4(:,:,291))
call HGT_raise_alpha_OLR(G1H4(466),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(466),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(466),-2,ex2(:),2,G2H2(234),m3h2x2(:,292),heltab2x4(:,:,292))
call signflip_OLR(G2H2(234))
  call Hloop_UV_W(ntryL,G1H4(471),21,ex4(:),8,G2H2(235),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_UV_W(ntryL,G1H4(476),21,ex4(:),8,G2H2(236),m3h2x2(:,294),heltab2x4(:,:,294))
call HGT_raise_alpha_OLR(G1H4(472),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(472),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(472),-2,ex2(:),2,G2H2(237),m3h2x2(:,295),heltab2x4(:,:,295))
call signflip_OLR(G2H2(237))
  call Hloop_UV_W(ntryL,G1H4(475),21,ex4(:),8,G2H2(238),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_UV_W(ntryL,G0H4(59),21,ex4(:),8,G1H2(59),m3h2x2(:,297),heltab2x4(:,:,297))
call HGT_raise_alpha_OLR(G1H4(477),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(477),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(477),-10,ex2(:),2,G2H2(239),m3h2x2(:,298),heltab2x4(:,:,298))
call signflip_OLR(G2H2(239))
  call Hloop_UV_W(ntryL,G1H4(480),21,ex4(:),8,G2H2(240),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_UV_W(ntryL,G0H4(60),21,ex4(:),8,G1H2(60),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_DV_C(ntryL,G1H4(481),25,ex2(:),G2H2(241),m3h2x2(:,301),heltab2x4(:,:,301))
call HGT_OLR(G1H4(482),1,1,4)
call HGT_invQ_OLR(G1H4(482),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(482),-4,ex3(:),4,G2H2(242),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_DV_C(ntryL,G1H4(487),25,ex2(:),G2H2(243),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_DV_C(ntryL,G1H4(492),25,ex2(:),G2H2(244),m3h2x2(:,304),heltab2x4(:,:,304))
call HGT_OLR(G1H4(488),1,1,4)
call HGT_invQ_OLR(G1H4(488),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(488),-4,ex3(:),4,G2H2(245),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_DV_C(ntryL,G1H4(491),25,ex2(:),G2H2(246),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_DV_C(ntryL,G0H4(61),25,ex2(:),G1H2(61),m3h2x2(:,307),heltab2x4(:,:,307))
call HGT_OLR(G1H4(493),1,1,4)
call HGT_invQ_OLR(G1H4(493),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(493),-6,ex3(:),4,G2H2(247),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_DV_C(ntryL,G1H4(496),25,ex2(:),G2H2(248),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_DV_C(ntryL,G0H4(62),25,ex2(:),G1H2(62),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_CV_D(ntryL,G1H4(497),25,ex2(:),2,G2H2(249),m3h2x2(:,311),heltab2x4(:,:,311))
call HGT_OLR(G1H4(498),1,1,4)
call HGT_invQ_OLR(G1H4(498),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(498),-4,ex3(:),G2H2(250),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_CV_D(ntryL,G1H4(503),25,ex2(:),2,G2H2(251),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_CV_D(ntryL,G1H4(508),25,ex2(:),2,G2H2(252),m3h2x2(:,314),heltab2x4(:,:,314))
call HGT_OLR(G1H4(504),1,1,4)
call HGT_invQ_OLR(G1H4(504),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(504),-4,ex3(:),G2H2(253),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_CV_D(ntryL,G1H4(507),25,ex2(:),2,G2H2(254),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_CV_D(ntryL,G0H4(63),25,ex2(:),2,G1H2(63),m3h2x2(:,317),heltab2x4(:,:,317))
call HGT_OLR(G1H4(509),1,1,4)
call HGT_invQ_OLR(G1H4(509),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(509),-6,ex3(:),G2H2(255),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_CV_D(ntryL,G1H4(512),25,ex2(:),2,G2H2(256),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_CV_D(ntryL,G0H4(64),25,ex2(:),2,G1H2(64),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_UV_W(ntryL,G1H4(513),25,ex2(:),2,G2H2(257),m3h2x2(:,321),heltab2x4(:,:,321))
call HGT_raise_alpha_OLR(G1H4(514),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(514),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(514),-4,ex3(:),4,G2H2(258),m3h2x2(:,322),heltab2x4(:,:,322))
call signflip_OLR(G2H2(258))
  call Hloop_UV_W(ntryL,G1H4(519),25,ex2(:),2,G2H2(259),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_UV_W(ntryL,G1H4(524),25,ex2(:),2,G2H2(260),m3h2x2(:,324),heltab2x4(:,:,324))
call HGT_raise_alpha_OLR(G1H4(520),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(520),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(520),-4,ex3(:),4,G2H2(261),m3h2x2(:,325),heltab2x4(:,:,325))
call signflip_OLR(G2H2(261))
  call Hloop_UV_W(ntryL,G1H4(523),25,ex2(:),2,G2H2(262),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_UV_W(ntryL,G0H4(65),25,ex2(:),2,G1H2(65),m3h2x2(:,327),heltab2x4(:,:,327))
call HGT_raise_alpha_OLR(G1H4(525),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(525),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(525),-6,ex3(:),4,G2H2(263),m3h2x2(:,328),heltab2x4(:,:,328))
call signflip_OLR(G2H2(263))
  call Hloop_UV_W(ntryL,G1H4(528),25,ex2(:),2,G2H2(264),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_UV_W(ntryL,G0H4(66),25,ex2(:),2,G1H2(66),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_DV_C(ntryL,G1H4(529),25,ex3(:),G2H2(265),m3h2x2(:,331),heltab2x4(:,:,331))
call HGT_OLR(G1H4(530),1,1,4)
call HGT_invQ_OLR(G1H4(530),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(530),-2,ex2(:),2,G2H2(266),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_DV_C(ntryL,G1H4(535),25,ex3(:),G2H2(267),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_DV_C(ntryL,G1H4(540),25,ex3(:),G2H2(268),m3h2x2(:,334),heltab2x4(:,:,334))
call HGT_OLR(G1H4(536),1,1,4)
call HGT_invQ_OLR(G1H4(536),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(536),-2,ex2(:),2,G2H2(269),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_DV_C(ntryL,G1H4(539),25,ex3(:),G2H2(270),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_DV_C(ntryL,G0H4(67),25,ex3(:),G1H2(67),m3h2x2(:,337),heltab2x4(:,:,337))
call HGT_OLR(G1H4(541),1,1,4)
call HGT_invQ_OLR(G1H4(541),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(541),-6,ex2(:),2,G2H2(271),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_DV_C(ntryL,G1H4(544),25,ex3(:),G2H2(272),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_DV_C(ntryL,G0H4(68),25,ex3(:),G1H2(68),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_CV_D(ntryL,G1H4(545),25,ex3(:),4,G2H2(273),m3h2x2(:,341),heltab2x4(:,:,341))
call HGT_OLR(G1H4(546),1,1,4)
call HGT_invQ_OLR(G1H4(546),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(546),-2,ex2(:),G2H2(274),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_CV_D(ntryL,G1H4(551),25,ex3(:),4,G2H2(275),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_CV_D(ntryL,G1H4(556),25,ex3(:),4,G2H2(276),m3h2x2(:,344),heltab2x4(:,:,344))
call HGT_OLR(G1H4(552),1,1,4)
call HGT_invQ_OLR(G1H4(552),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(552),-2,ex2(:),G2H2(277),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_CV_D(ntryL,G1H4(555),25,ex3(:),4,G2H2(278),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_CV_D(ntryL,G0H4(69),25,ex3(:),4,G1H2(69),m3h2x2(:,347),heltab2x4(:,:,347))
call HGT_OLR(G1H4(557),1,1,4)
call HGT_invQ_OLR(G1H4(557),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(557),-6,ex2(:),G2H2(279),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_CV_D(ntryL,G1H4(560),25,ex3(:),4,G2H2(280),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_CV_D(ntryL,G0H4(70),25,ex3(:),4,G1H2(70),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_UV_W(ntryL,G1H4(561),25,ex3(:),4,G2H2(281),m3h2x2(:,351),heltab2x4(:,:,351))
call HGT_raise_alpha_OLR(G1H4(562),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(562),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(562),-2,ex2(:),2,G2H2(282),m3h2x2(:,352),heltab2x4(:,:,352))
call signflip_OLR(G2H2(282))
  call Hloop_UV_W(ntryL,G1H4(567),25,ex3(:),4,G2H2(283),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_UV_W(ntryL,G1H4(572),25,ex3(:),4,G2H2(284),m3h2x2(:,354),heltab2x4(:,:,354))
call HGT_raise_alpha_OLR(G1H4(568),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(568),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(568),-2,ex2(:),2,G2H2(285),m3h2x2(:,355),heltab2x4(:,:,355))
call signflip_OLR(G2H2(285))
  call Hloop_UV_W(ntryL,G1H4(571),25,ex3(:),4,G2H2(286),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_UV_W(ntryL,G0H4(71),25,ex3(:),4,G1H2(71),m3h2x2(:,357),heltab2x4(:,:,357))
call HGT_raise_alpha_OLR(G1H4(573),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(573),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(573),-6,ex2(:),2,G2H2(287),m3h2x2(:,358),heltab2x4(:,:,358))
call signflip_OLR(G2H2(287))
  call Hloop_UV_W(ntryL,G1H4(576),25,ex3(:),4,G2H2(288),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_UV_W(ntryL,G0H4(72),25,ex3(:),4,G1H2(72),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(2),mass4set(:,1),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(80),10,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(2),23,ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,1),  & 
G1H2(2),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(84),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(2),mass4set(:,1),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),2)
  call HG1shiftOLR(G1H2(90),10,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(4),23,ex4(:),8,G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,1),  & 
G1H2(4),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(2),mass4set(:,1),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(100),10,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(6),23,ex4(:),8,G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(2),mass5set(:,1),  & 
G1H2(6),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(4),mass4set(:,1),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),2)
  call HG1shiftOLR(G1H2(110),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(8),23,ex4(:),8,G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(2),mass5set(:,1),  & 
G1H2(8),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(114),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(4),mass4set(:,1),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),2)
  call HG1shiftOLR(G1H2(120),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(10),23,ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(2),mass5set(:,1),  & 
G1H2(10),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(4),mass4set(:,1),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(130),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(3),mass5set(:,1),  & 
G1H2(12),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(5),mass4set(:,1),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(140),9,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(14),23,ex4(:),8,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(3),mass5set(:,1),  & 
G1H2(14),G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
  call HG1shiftOLR(G1H2(144),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(5),mass4set(:,1),  & 
G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),2)
  call HG1shiftOLR(G1H2(150),9,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(16),23,ex4(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(3),mass5set(:,1),  & 
G1H2(16),G1H2(154),G1H2(155),G1H2(156),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(154),8,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(5),mass4set(:,1),  & 
G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(160),9,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),23,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(4),mass5set(:,1),  & 
G1H2(18),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),4,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(4),mass4set(:,1),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),2)
  call HG1shiftOLR(G1H2(170),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(20),27,ex3(:),4,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(4),mass5set(:,1),  & 
G1H2(20),G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(174),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(4),mass4set(:,1),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(180),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(22),27,ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(4),mass5set(:,1),  & 
G1H2(22),G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(184),4,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(4),mass4set(:,1),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(190),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(24),27,ex3(:),4,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(5),mass5set(:,1),  & 
G1H2(24),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),8,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(8),mass4set(:,1),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),2)
  call HG1shiftOLR(G1H2(200),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(26),23,ex4(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(5),mass5set(:,1),  & 
G1H2(26),G1H2(204),G1H2(205),G1H2(206),G1H2(207),G1H2(208),2)
  call HG1shiftOLR(G1H2(204),8,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(8),mass4set(:,1),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),2)
  call HG1shiftOLR(G1H2(210),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(28),23,ex4(:),8,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(5),mass5set(:,1),  & 
G1H2(28),G1H2(214),G1H2(215),G1H2(216),G1H2(217),G1H2(218),2)
  call HG1shiftOLR(G1H2(214),8,2)
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(8),mass4set(:,1),  & 
G1H2(219),G1H2(220),G1H2(221),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(220),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(30),23,ex4(:),8,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(6),mass5set(:,1),  & 
G1H2(30),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),4,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(8),mass4set(:,1),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(230),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(32),27,ex3(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(6),mass5set(:,1),  & 
G1H2(32),G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),2)
  call HG1shiftOLR(G1H2(234),4,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(8),mass4set(:,1),  & 
G1H2(239),G1H2(240),G1H2(241),G1H2(242),G1H2(243),2)
  call HG1shiftOLR(G1H2(240),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(34),27,ex3(:),4,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(6),mass5set(:,1),  & 
G1H2(34),G1H2(244),G1H2(245),G1H2(246),G1H2(247),G1H2(248),2)
  call HG1shiftOLR(G1H2(244),4,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(8),mass4set(:,1),  & 
G1H2(249),G1H2(250),G1H2(251),G1H2(252),G1H2(253),2)
  call HG1shiftOLR(G1H2(250),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(36),27,ex3(:),4,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hotf_5pt_reduction(G2H2(145),RedSet_5(7),mass5set(:,1),  & 
G1H2(36),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),8,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(10),mass4set(:,1),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(260),9,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(38),23,ex4(:),8,G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(7),mass5set(:,1),  & 
G1H2(38),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),8,2)
  call Hotf_4pt_reduction(G2H2(156),RedSet_4(10),mass4set(:,1),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),2)
  call HG1shiftOLR(G1H2(270),9,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(40),23,ex4(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hotf_5pt_reduction(G2H2(161),RedSet_5(7),mass5set(:,1),  & 
G1H2(40),G1H2(274),G1H2(275),G1H2(276),G1H2(277),G1H2(278),2)
  call HG1shiftOLR(G1H2(274),8,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(10),mass4set(:,1),  & 
G1H2(279),G1H2(280),G1H2(281),G1H2(282),G1H2(283),2)
  call HG1shiftOLR(G1H2(280),9,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(42),23,ex4(:),8,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hotf_5pt_reduction(G2H2(169),RedSet_5(8),mass5set(:,1),  & 
G1H2(42),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),4,2)
  call Hotf_4pt_reduction(G2H2(172),RedSet_4(11),mass4set(:,1),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),2)
  call HG1shiftOLR(G1H2(290),5,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(44),27,ex3(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hotf_5pt_reduction(G2H2(177),RedSet_5(8),mass5set(:,1),  & 
G1H2(44),G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),2)
  call HG1shiftOLR(G1H2(294),4,2)
  call Hotf_4pt_reduction(G2H2(180),RedSet_4(11),mass4set(:,1),  & 
G1H2(299),G1H2(300),G1H2(301),G1H2(302),G1H2(303),2)
  call HG1shiftOLR(G1H2(300),5,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(46),27,ex3(:),4,G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hotf_5pt_reduction(G2H2(185),RedSet_5(8),mass5set(:,1),  & 
G1H2(46),G1H2(304),G1H2(305),G1H2(306),G1H2(307),G1H2(308),2)
  call HG1shiftOLR(G1H2(304),4,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(11),mass4set(:,1),  & 
G1H2(309),G1H2(310),G1H2(311),G1H2(312),G1H2(313),2)
  call HG1shiftOLR(G1H2(310),5,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(48),27,ex3(:),4,G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hotf_5pt_reduction(G2H2(193),RedSet_5(9),mass5set(:,1),  & 
G1H2(48),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),8,2)
  call Hotf_4pt_reduction(G2H2(196),RedSet_4(12),mass4set(:,1),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),2)
  call HG1shiftOLR(G1H2(320),10,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(50),23,ex4(:),G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(9),mass5set(:,1),  & 
G1H2(50),G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(324),8,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(12),mass4set(:,1),  & 
G1H2(329),G1H2(330),G1H2(331),G1H2(332),G1H2(333),2)
  call HG1shiftOLR(G1H2(330),10,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(52),23,ex4(:),8,G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hotf_5pt_reduction(G2H2(209),RedSet_5(9),mass5set(:,1),  & 
G1H2(52),G1H2(334),G1H2(335),G1H2(336),G1H2(337),G1H2(338),2)
  call HG1shiftOLR(G1H2(334),8,2)
  call Hotf_4pt_reduction(G2H2(212),RedSet_4(12),mass4set(:,1),  & 
G1H2(339),G1H2(340),G1H2(341),G1H2(342),G1H2(343),2)
  call HG1shiftOLR(G1H2(340),10,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(54),23,ex4(:),8,G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hotf_5pt_reduction(G2H2(217),RedSet_5(10),mass5set(:,1),  & 
G1H2(54),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),2,2)
  call Hotf_4pt_reduction(G2H2(220),RedSet_4(12),mass4set(:,1),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),2)
  call HG1shiftOLR(G1H2(350),10,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(56),29,ex2(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hotf_5pt_reduction(G2H2(225),RedSet_5(10),mass5set(:,1),  & 
G1H2(56),G1H2(354),G1H2(355),G1H2(356),G1H2(357),G1H2(358),2)
  call HG1shiftOLR(G1H2(354),2,2)
  call Hotf_4pt_reduction(G2H2(228),RedSet_4(12),mass4set(:,1),  & 
G1H2(359),G1H2(360),G1H2(361),G1H2(362),G1H2(363),2)
  call HG1shiftOLR(G1H2(360),10,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(58),29,ex2(:),2,G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hotf_5pt_reduction(G2H2(233),RedSet_5(10),mass5set(:,1),  & 
G1H2(58),G1H2(364),G1H2(365),G1H2(366),G1H2(367),G1H2(368),2)
  call HG1shiftOLR(G1H2(364),2,2)
  call Hotf_4pt_reduction(G2H2(236),RedSet_4(12),mass4set(:,1),  & 
G1H2(369),G1H2(370),G1H2(371),G1H2(372),G1H2(373),2)
  call HG1shiftOLR(G1H2(370),10,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(60),29,ex2(:),2,G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hotf_5pt_reduction(G2H2(241),RedSet_5(11),mass5set(:,1),  & 
G1H2(60),G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),2)
  call HG1shiftOLR(G1H2(374),4,2)
  call Hotf_4pt_reduction(G2H2(244),RedSet_4(14),mass4set(:,1),  & 
G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),2)
  call HG1shiftOLR(G1H2(380),6,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(62),27,ex3(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hotf_5pt_reduction(G2H2(249),RedSet_5(11),mass5set(:,1),  & 
G1H2(62),G1H2(384),G1H2(385),G1H2(386),G1H2(387),G1H2(388),2)
  call HG1shiftOLR(G1H2(384),4,2)
  call Hotf_4pt_reduction(G2H2(252),RedSet_4(14),mass4set(:,1),  & 
G1H2(389),G1H2(390),G1H2(391),G1H2(392),G1H2(393),2)
  call HG1shiftOLR(G1H2(390),6,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(64),27,ex3(:),4,G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hotf_5pt_reduction(G2H2(257),RedSet_5(11),mass5set(:,1),  & 
G1H2(64),G1H2(394),G1H2(395),G1H2(396),G1H2(397),G1H2(398),2)
  call HG1shiftOLR(G1H2(394),4,2)
  call Hotf_4pt_reduction(G2H2(260),RedSet_4(14),mass4set(:,1),  & 
G1H2(399),G1H2(400),G1H2(401),G1H2(402),G1H2(403),2)
  call HG1shiftOLR(G1H2(400),6,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(66),27,ex3(:),4,G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hotf_5pt_reduction(G2H2(265),RedSet_5(12),mass5set(:,1),  & 
G1H2(66),G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(404),2,2)
  call Hotf_4pt_reduction(G2H2(268),RedSet_4(14),mass4set(:,1),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),2)
  call HG1shiftOLR(G1H2(410),6,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(68),29,ex2(:),G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hotf_5pt_reduction(G2H2(273),RedSet_5(12),mass5set(:,1),  & 
G1H2(68),G1H2(414),G1H2(415),G1H2(416),G1H2(417),G1H2(418),2)
  call HG1shiftOLR(G1H2(414),2,2)
  call Hotf_4pt_reduction(G2H2(276),RedSet_4(14),mass4set(:,1),  & 
G1H2(419),G1H2(420),G1H2(421),G1H2(422),G1H2(423),2)
  call HG1shiftOLR(G1H2(420),6,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(70),29,ex2(:),2,G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hotf_5pt_reduction(G2H2(281),RedSet_5(12),mass5set(:,1),  & 
G1H2(70),G1H2(424),G1H2(425),G1H2(426),G1H2(427),G1H2(428),2)
  call HG1shiftOLR(G1H2(424),2,2)
  call Hotf_4pt_reduction(G2H2(284),RedSet_4(14),mass4set(:,1),  & 
G1H2(429),G1H2(430),G1H2(431),G1H2(432),G1H2(433),2)
  call HG1shiftOLR(G1H2(430),6,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(72),29,ex2(:),2,G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(149),[G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(179),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(199),[G1H2(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(209),[G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(239),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(249),[G1H2(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(259),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(289),[G1H2(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(309),[G1H2(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(319),[G1H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(339),[G1H2(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(349),[G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(359),[G1H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(369),[G1H2(368)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(379),[G1H2(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(389),[G1H2(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(399),[G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(409),[G1H2(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(419),[G1H2(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(429),[G1H2(428)])
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(73),23,ex4(:),G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(74),0,ex4(:),G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(79),23,ex4(:),G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(80),2,ex4(:),G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(2),23,ex4(:),8,G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(84),0,ex4(:),8,G2tensor(42),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(89),23,ex4(:),8,G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(90),2,ex4(:),8,G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(4),23,ex4(:),8,G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(94),0,ex4(:),8,G2tensor(46),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(99),23,ex4(:),8,G2tensor(47),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(100),2,ex4(:),8,G2tensor(48),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(6),23,ex4(:),8,G2tensor(49),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(104),0,ex4(:),8,G2tensor(50),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(109),23,ex4(:),8,G2tensor(51),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(110),4,ex4(:),8,G2tensor(52),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(8),23,ex4(:),G2tensor(53),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(114),0,ex4(:),G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(119),23,ex4(:),G2tensor(55),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(120),4,ex4(:),G2tensor(56),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),23,ex4(:),8,G2tensor(57),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(124),0,ex4(:),8,G2tensor(58),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(129),23,ex4(:),8,G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(130),4,ex4(:),8,G2tensor(60),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(134),0,ex4(:),8,G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(139),23,ex4(:),8,G2tensor(63),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(140),1,ex4(:),8,G2tensor(64),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(14),23,ex4(:),G2tensor(65),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(144),0,ex4(:),G2tensor(66),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(149),23,ex4(:),G2tensor(67),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(150),1,ex4(:),G2tensor(68),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(16),23,ex4(:),8,G2tensor(69),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(154),0,ex4(:),8,G2tensor(70),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(159),23,ex4(:),8,G2tensor(71),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(160),1,ex4(:),8,G2tensor(72),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(18),27,ex3(:),4,G2tensor(73),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(164),0,ex3(:),4,G2tensor(74),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(169),27,ex3(:),4,G2tensor(75),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(170),8,ex3(:),4,G2tensor(76),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(20),27,ex3(:),G2tensor(77),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(174),0,ex3(:),G2tensor(78),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(179),27,ex3(:),G2tensor(79),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(180),8,ex3(:),G2tensor(80),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(22),27,ex3(:),4,G2tensor(81),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(184),0,ex3(:),4,G2tensor(82),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(189),27,ex3(:),4,G2tensor(83),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(190),8,ex3(:),4,G2tensor(84),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(24),23,ex4(:),G2tensor(85),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(194),0,ex4(:),G2tensor(86),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(199),23,ex4(:),G2tensor(87),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(200),4,ex4(:),G2tensor(88),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(26),23,ex4(:),8,G2tensor(89),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(204),0,ex4(:),8,G2tensor(90),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(209),23,ex4(:),8,G2tensor(91),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(210),4,ex4(:),8,G2tensor(92),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),23,ex4(:),8,G2tensor(93),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(214),0,ex4(:),8,G2tensor(94),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(219),23,ex4(:),8,G2tensor(95),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(220),4,ex4(:),8,G2tensor(96),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(30),27,ex3(:),G2tensor(97),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(224),0,ex3(:),G2tensor(98),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(229),27,ex3(:),G2tensor(99),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(230),8,ex3(:),G2tensor(100),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(32),27,ex3(:),4,G2tensor(101),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(234),0,ex3(:),4,G2tensor(102),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(239),27,ex3(:),4,G2tensor(103),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(240),8,ex3(:),4,G2tensor(104),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),27,ex3(:),4,G2tensor(105),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(244),0,ex3(:),4,G2tensor(106),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(249),27,ex3(:),4,G2tensor(107),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(250),8,ex3(:),4,G2tensor(108),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(36),23,ex4(:),8,G2tensor(109),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(254),0,ex4(:),8,G2tensor(110),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(259),23,ex4(:),8,G2tensor(111),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(260),1,ex4(:),8,G2tensor(112),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(38),23,ex4(:),G2tensor(113),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(264),0,ex4(:),G2tensor(114),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(269),23,ex4(:),G2tensor(115),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(270),1,ex4(:),G2tensor(116),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(40),23,ex4(:),8,G2tensor(117),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(274),0,ex4(:),8,G2tensor(118),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(279),23,ex4(:),8,G2tensor(119),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(280),1,ex4(:),8,G2tensor(120),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(42),27,ex3(:),G2tensor(121),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(284),0,ex3(:),G2tensor(122),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(289),27,ex3(:),G2tensor(123),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(290),1,ex3(:),G2tensor(124),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(44),27,ex3(:),4,G2tensor(125),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(294),0,ex3(:),4,G2tensor(126),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(299),27,ex3(:),4,G2tensor(127),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(300),1,ex3(:),4,G2tensor(128),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(46),27,ex3(:),4,G2tensor(129),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(304),0,ex3(:),4,G2tensor(130),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(309),27,ex3(:),4,G2tensor(131),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(310),1,ex3(:),4,G2tensor(132),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(48),23,ex4(:),G2tensor(133),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(314),0,ex4(:),G2tensor(134),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(319),23,ex4(:),G2tensor(135),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(320),2,ex4(:),G2tensor(136),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(50),23,ex4(:),8,G2tensor(137),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(324),0,ex4(:),8,G2tensor(138),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(329),23,ex4(:),8,G2tensor(139),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(330),2,ex4(:),8,G2tensor(140),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(52),23,ex4(:),8,G2tensor(141),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(334),0,ex4(:),8,G2tensor(142),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(339),23,ex4(:),8,G2tensor(143),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(340),2,ex4(:),8,G2tensor(144),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(54),29,ex2(:),G2tensor(145),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(344),0,ex2(:),G2tensor(146),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(349),29,ex2(:),G2tensor(147),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(350),8,ex2(:),G2tensor(148),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(56),29,ex2(:),2,G2tensor(149),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(354),0,ex2(:),2,G2tensor(150),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(359),29,ex2(:),2,G2tensor(151),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(360),8,ex2(:),2,G2tensor(152),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(58),29,ex2(:),2,G2tensor(153),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(364),0,ex2(:),2,G2tensor(154),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(369),29,ex2(:),2,G2tensor(155),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(370),8,ex2(:),2,G2tensor(156),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(60),27,ex3(:),G2tensor(157),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(374),0,ex3(:),G2tensor(158),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(379),27,ex3(:),G2tensor(159),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(380),2,ex3(:),G2tensor(160),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(62),27,ex3(:),4,G2tensor(161),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(384),0,ex3(:),4,G2tensor(162),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(389),27,ex3(:),4,G2tensor(163),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(390),2,ex3(:),4,G2tensor(164),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(64),27,ex3(:),4,G2tensor(165),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(394),0,ex3(:),4,G2tensor(166),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(399),27,ex3(:),4,G2tensor(167),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(400),2,ex3(:),4,G2tensor(168),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(66),29,ex2(:),G2tensor(169),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(404),0,ex2(:),G2tensor(170),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(409),29,ex2(:),G2tensor(171),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(410),4,ex2(:),G2tensor(172),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(68),29,ex2(:),2,G2tensor(173),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(414),0,ex2(:),2,G2tensor(174),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(419),29,ex2(:),2,G2tensor(175),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(420),4,ex2(:),2,G2tensor(176),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(70),29,ex2(:),2,G2tensor(177),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(424),0,ex2(:),2,G2tensor(178),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(429),29,ex2(:),2,G2tensor(179),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(430),4,ex2(:),2,G2tensor(180),m3h2x1(:,180),heltab2x2(:,:,180))
  call ol_merge_tensors(G2tensor(45),[G2tensor(41),G2tensor(37)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(53),G2tensor(49)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(65),G2tensor(61)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(77),G2tensor(73)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(89),G2tensor(85)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(101),G2tensor(97)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(113),G2tensor(109)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(125),G2tensor(121)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(137),G2tensor(133)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(149),G2tensor(145)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(161),G2tensor(157)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(173),G2tensor(169)])
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(9),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(10),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),2)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(11),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(12),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(2),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(5),m4h2x2x8(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(28,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(8),m4h2x2x8(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(11),m4h2x2x8(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(14),m4h2x2x8(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(17),m4h2x2x8(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(18),m4h2x2x8(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,39),heltab2x32(:,:,39))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,40),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,41),heltab2x32(:,:,41))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,42),heltab2x32(:,:,42))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,44),heltab2x32(:,:,44))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,45),heltab2x32(:,:,45))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[18,4,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(19),m4h2x2x8(:,19),heltab3x32(:,:,19))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[18,4,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(20),m4h2x2x8(:,20),heltab3x32(:,:,20))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[18,4,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(21),m4h2x2x8(:,21),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[18,1,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(22),m4h2x2x8(:,22),heltab3x32(:,:,22))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[18,1,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(23),m4h2x2x8(:,23),heltab3x32(:,:,23))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[18,1,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(24),m4h2x2x8(:,24),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[18,1,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(25),m4h2x2x8(:,25),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[18,1,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(26),m4h2x2x8(:,26),heltab3x32(:,:,26))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[18,1,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(27),m4h2x2x8(:,27),heltab3x32(:,:,27))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,1,4,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,46),heltab2x32(:,:,46))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,1,4,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,47),heltab2x32(:,:,47))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,1,4,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,4,1,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,49),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,4,1,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,50),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,4,1,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,51),heltab2x32(:,:,51))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,1,10,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,52),heltab2x32(:,:,52))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,1,10,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,53),heltab2x32(:,:,53))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,1,10,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,54),heltab2x32(:,:,54))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,1,8,6],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,55),heltab2x32(:,:,55))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,1,8,6],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,56),heltab2x32(:,:,56))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,1,8,6],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,57),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,6,1,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,58),heltab2x32(:,:,58))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,6,1,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,59),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,6,1,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,60),heltab2x32(:,:,60))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,1,6,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,61),heltab2x32(:,:,61))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,6,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,62),heltab2x32(:,:,62))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,6,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,63),heltab2x32(:,:,63))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[17,4,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(28),m4h2x2x8(:,28),heltab3x32(:,:,28))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[17,4,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(29),m4h2x2x8(:,29),heltab3x32(:,:,29))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[17,4,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(30),m4h2x2x8(:,30),heltab3x32(:,:,30))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[17,2,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(31),m4h2x2x8(:,31),heltab3x32(:,:,31))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[17,2,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(32),m4h2x2x8(:,32),heltab3x32(:,:,32))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[17,2,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(33),m4h2x2x8(:,33),heltab3x32(:,:,33))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[17,2,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(34),m4h2x2x8(:,34),heltab3x32(:,:,34))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[17,2,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(35),m4h2x2x8(:,35),heltab3x32(:,:,35))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[17,2,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(36),m4h2x2x8(:,36),heltab3x32(:,:,36))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,2,4,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,64),heltab2x32(:,:,64))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,2,4,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,65),heltab2x32(:,:,65))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,2,4,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,66),heltab2x32(:,:,66))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,4,2,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,67),heltab2x32(:,:,67))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,4,2,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,68),heltab2x32(:,:,68))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,4,2,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,69),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,2,9,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,2,9,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,71),heltab2x32(:,:,71))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,2,9,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,72),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,2,8,5],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,73),heltab2x32(:,:,73))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,2,8,5],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,74),heltab2x32(:,:,74))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,2,8,5],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,5,2,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,5,2,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,5,2,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,2,5,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,2,5,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,2,5,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,81),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,3,8,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,82),heltab2x32(:,:,82))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,3,8,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,3,8,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,84),heltab2x32(:,:,84))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,3,4,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,85),heltab2x32(:,:,85))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,3,4,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,3,4,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,4,3,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,4,3,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,89),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,4,3,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,90),heltab2x32(:,:,90))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(23,:)%j+M(25,:)%j-M(36,:)%j-M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,91),heltab2x32(:,:,91))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(23,:)%j+M(25,:)%j-M(36,:)%j-M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(56),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,93),heltab2x32(:,:,93))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(21,:)%j+M(26,:)%j-M(30,:)%j-M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(58),m3h2x16(:,94),heltab2x32(:,:,94))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(21,:)%j+M(26,:)%j-M(30,:)%j-M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,95),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,96),heltab2x32(:,:,96))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(22,:)%j+M(24,:)%j-M(32,:)%j-M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(22,:)%j+M(24,:)%j-M(32,:)%j-M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(62),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(M(29,:)%j+M(31,:)%j-M(34,:)%j-M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(64),m3h2x16(:,100),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(M(29,:)%j+M(31,:)%j-M(34,:)%j-M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,101),heltab2x32(:,:,101))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,102),heltab2x32(:,:,102))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(24,:)%j+M(27,:)%j+M(32,:)%j-M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(67),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(24,:)%j+M(27,:)%j+M(32,:)%j-M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,104),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,105),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(26,:)%j+M(28,:)%j+M(30,:)%j-M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(26,:)%j+M(28,:)%j+M(30,:)%j-M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(71),m3h2x16(:,107),heltab2x32(:,:,107))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(73),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(75),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(22,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(76),m3h2x16(:,112),heltab2x32(:,:,112))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(22,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,113),heltab2x32(:,:,113))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,114),heltab2x32(:,:,114))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(21,:)%j-M(27,:)%j+M(43,:)%j-M(44,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,115),heltab2x32(:,:,115))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(21,:)%j-M(27,:)%j+M(43,:)%j-M(44,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(80),m3h2x16(:,116),heltab2x32(:,:,116))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,117),heltab2x32(:,:,117))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(28,:)%j+M(35,:)%j+M(37,:)%j-M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(82),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(28,:)%j+M(35,:)%j+M(37,:)%j-M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(83),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(84),m3h2x16(:,120),heltab2x32(:,:,120))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(22,:)%j+M(33,:)%j+M(38,:)%j-M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(85),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(22,:)%j+M(33,:)%j+M(38,:)%j-M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(86),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,123),heltab2x32(:,:,123))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(25,:)%j-M(31,:)%j+M(34,:)%j+M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,124),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(25,:)%j-M(31,:)%j+M(34,:)%j+M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(89),m3h2x16(:,125),heltab2x32(:,:,125))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(27,:)%j-M(29,:)%j+M(40,:)%j-M(43,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(91),m3h2x16(:,127),heltab2x32(:,:,127))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(27,:)%j-M(29,:)%j+M(40,:)%j-M(43,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(92),m3h2x16(:,128),heltab2x32(:,:,128))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,129),heltab2x32(:,:,129))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(24,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,130),heltab2x32(:,:,130))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(24,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(95),m3h2x16(:,131),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(96),m3h2x16(:,132),heltab2x32(:,:,132))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(23,:)%j-M(33,:)%j+M(41,:)%j-M(42,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,133),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(23,:)%j-M(33,:)%j+M(41,:)%j-M(42,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(98),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,135),heltab2x32(:,:,135))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(23,:)%j+M(42,:)%j-M(44,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(100),m3h2x16(:,136),heltab2x32(:,:,136))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(23,:)%j+M(42,:)%j-M(44,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,139),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(104),m3h2x16(:,140),heltab2x32(:,:,140))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,141),heltab2x32(:,:,141))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,142),heltab2x32(:,:,142))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(107),m3h2x16(:,143),heltab2x32(:,:,143))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,144),heltab2x32(:,:,144))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(27,:)%j-M(33,:)%j+M(41,:)%j &
    +M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(1),m3h4x8(:,1),heltab2x32(:,:,145))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(27,:)%j-M(33,:)%j+M(41,:)%j &
    +M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(2),m3h4x8(:,2),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(4),m3h4x8(:,3),heltab2x32(:,:,147))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(21,:)%j-M(35,:)%j+M(39,:)%j &
    +M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(5),m3h4x8(:,4),heltab2x32(:,:,148))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(21,:)%j-M(35,:)%j+M(39,:)%j &
    +M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(6),m3h4x8(:,5),heltab2x32(:,:,149))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(7),m3h4x8(:,6),heltab2x32(:,:,150))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(23,:)%j-M(29,:)%j+M(40,:)%j &
    +M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(8),m3h4x8(:,7),heltab2x32(:,:,151))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(23,:)%j-M(29,:)%j+M(40,:)%j &
    +M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(10),m3h4x8(:,8),heltab2x32(:,:,152))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(11),m3h4x8(:,9),heltab2x32(:,:,153))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(28,:)%j-M(31,:)%j+M(34,:)%j &
    -M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(12),m3h4x8(:,10),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(28,:)%j-M(31,:)%j+M(34,:)%j &
    -M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(13),m3h4x8(:,11),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(14),m3h4x8(:,12),heltab2x32(:,:,156))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(26,:)%j+M(29,:)%j-M(30,:)%j &
    -M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(16),m3h4x8(:,13),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(26,:)%j+M(29,:)%j-M(30,:)%j &
    -M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(17),m3h4x8(:,14),heltab2x32(:,:,158))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(18),m3h4x8(:,15),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(25,:)%j+M(35,:)%j-M(36,:)%j &
    -M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(19),m3h4x8(:,16),heltab2x32(:,:,160))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(25,:)%j+M(35,:)%j-M(36,:)%j &
    -M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(20),m3h4x8(:,17),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(22),m3h4x8(:,18),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(25,:)%j+M(36,:)%j &
    -M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(23),m3h4x8(:,19),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(25,:)%j+M(36,:)%j &
    -M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(24),m3h4x8(:,20),heltab2x32(:,:,164))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(25),m3h4x8(:,21),heltab2x32(:,:,165))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(24,:)%j+M(32,:)%j &
    -M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(26),m3h4x8(:,22),heltab2x32(:,:,166))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(24,:)%j+M(32,:)%j &
    -M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(28),m3h4x8(:,23),heltab2x32(:,:,167))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(29),m3h4x8(:,24),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j+M(33,:)%j-M(34,:)%j &
    -M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(30),m3h4x8(:,25),heltab2x32(:,:,169))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j+M(33,:)%j-M(34,:)%j &
    -M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(31),m3h4x8(:,26),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(32),m3h4x8(:,27),heltab2x32(:,:,171))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(26,:)%j+M(30,:)%j &
    -M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(34),m3h4x8(:,28),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(26,:)%j+M(30,:)%j &
    -M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(35),m3h4x8(:,29),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(36),m3h4x8(:,30),heltab2x32(:,:,174))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(22,:)%j+M(38,:)%j &
    -M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(37),m3h4x8(:,31),heltab2x32(:,:,175))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(22,:)%j+M(38,:)%j &
    -M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(38),m3h4x8(:,32),heltab2x32(:,:,176))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(40),m3h4x8(:,33),heltab2x32(:,:,177))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(28,:)%j+M(37,:)%j &
    -M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(41),m3h4x8(:,34),heltab2x32(:,:,178))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(28,:)%j+M(37,:)%j &
    -M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(42),m3h4x8(:,35),heltab2x32(:,:,179))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(43),m3h4x8(:,36),heltab2x32(:,:,180))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(15),G0H8(15),G0H8(14),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(33),G0H8(24),G0H8(23),G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(51),G0H8(12),G0H8(11),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(69),G0H8(27),G0H8(26),G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(87),G0H8(33),G0H8(32),G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(105),G0H8(36),G0H8(35),G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(123),G0H8(21),G0H8(20),G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(159),G0H8(30),G0H8(29),G0H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G0H8(3),G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G0H8(6),G0H8(5),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G0H8(9),G0H8(8),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G0H8(18),G0H8(17),G0H8(16)])
  call Hloop_DV_C(ntryL,G1H8(26),20,ex1(:),G2H4(1),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_CV_D(ntryL,G1H8(28),20,ex1(:),1,G2H4(4),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_UV_W(ntryL,G1H8(29),20,ex1(:),1,G2H4(5),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_CV_D(ntryL,G1H8(17),18,ex1(:),1,G2H4(6),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_DV_C(ntryL,G1H8(16),18,ex1(:),G2H4(9),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_UV_W(ntryL,G1H8(18),18,ex1(:),1,G2H4(10),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_CV_D(ntryL,G1H8(23),20,ex2(:),2,G2H4(11),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_DV_C(ntryL,G1H8(24),20,ex2(:),G2H4(14),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_UV_W(ntryL,G1H8(25),20,ex2(:),2,G2H4(15),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_CV_D(ntryL,G1H8(20),18,ex1(:),1,G2H4(16),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_DV_C(ntryL,G1H8(19),18,ex1(:),G2H4(19),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_UV_W(ntryL,G1H8(22),18,ex1(:),1,G2H4(20),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_DV_C(ntryL,G1H8(5),17,ex2(:),G2H4(21),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_CV_D(ntryL,G1H8(6),17,ex2(:),2,G2H4(24),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_UV_W(ntryL,G1H8(7),17,ex2(:),2,G2H4(25),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_DV_C(ntryL,G1H8(8),17,ex2(:),G2H4(26),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_CV_D(ntryL,G1H8(10),17,ex2(:),2,G2H4(29),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_UV_W(ntryL,G1H8(11),17,ex2(:),2,G2H4(30),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_CV_D(ntryL,G1H8(12),18,ex3(:),4,G2H4(31),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_DV_C(ntryL,G1H8(13),18,ex3(:),G2H4(34),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_UV_W(ntryL,G1H8(14),18,ex3(:),4,G2H4(35),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_DV_C(ntryL,G1H8(129),18,ex4(:),G2H4(36),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_CV_D(ntryL,G1H8(135),18,ex4(:),8,G2H4(39),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_UV_W(ntryL,G1H8(141),18,ex4(:),8,G2H4(40),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_DV_C(ntryL,G1H8(2),17,ex3(:),G2H4(41),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_CV_D(ntryL,G1H8(1),17,ex3(:),4,G2H4(44),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_UV_W(ntryL,G1H8(4),17,ex3(:),4,G2H4(45),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_DV_C(ntryL,G1H8(165),17,ex3(:),G2H4(46),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_CV_D(ntryL,G1H8(171),17,ex3(:),4,G2H4(49),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_UV_W(ntryL,G1H8(177),17,ex3(:),4,G2H4(50),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_DV_C(ntryL,G1H8(183),17,ex4(:),G2H4(51),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_CV_D(ntryL,G1H8(189),17,ex4(:),8,G2H4(54),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_UV_W(ntryL,G1H8(195),17,ex4(:),8,G2H4(55),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_DV_C(ntryL,G1H8(201),17,ex4(:),G2H4(56),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_CV_D(ntryL,G1H8(207),17,ex4(:),8,G2H4(59),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_UV_W(ntryL,G1H8(213),17,ex4(:),8,G2H4(60),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_UV_W(ntryL,G1H8(36),24,ex2(:),2,G2H4(61),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_UV_W(ntryL,G1H8(40),24,ex1(:),1,G2H4(64),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_UV_W(ntryL,G1H8(43),24,ex1(:),1,G2H4(65),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_UV_W(ntryL,G1H8(32),20,ex1(:),1,G2H4(66),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_UV_W(ntryL,G1H16(1),16,ex1(:),1,G2H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_UV_W(ntryL,G1H16(2),16,ex1(:),1,G2H8(2),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_UV_W(ntryL,G1H16(3),16,ex1(:),1,G2H8(3),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_UV_W(ntryL,G1H16(4),16,ex2(:),2,G2H8(4),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_UV_W(ntryL,G1H16(5),16,ex2(:),2,G2H8(5),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_UV_W(ntryL,G1H16(6),16,ex2(:),2,G2H8(6),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_UV_W(ntryL,G1H16(7),16,ex1(:),1,G2H8(7),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_UV_W(ntryL,G1H16(8),16,ex1(:),1,G2H8(8),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_UV_W(ntryL,G1H16(9),16,ex1(:),1,G2H8(9),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_UV_W(ntryL,G1H16(10),16,ex1(:),1,G2H8(10),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_UV_W(ntryL,G1H16(11),16,ex1(:),1,G2H8(11),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_UV_W(ntryL,G1H16(12),16,ex1(:),1,G2H8(12),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_UV_W(ntryL,G1H16(13),16,ex3(:),4,G2H8(13),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_UV_W(ntryL,G1H16(14),16,ex3(:),4,G2H8(14),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_UV_W(ntryL,G1H16(15),16,ex3(:),4,G2H8(15),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_UV_W(ntryL,G1H16(16),16,ex1(:),1,G2H8(16),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_UV_W(ntryL,G1H16(17),16,ex1(:),1,G2H8(17),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_UV_W(ntryL,G1H16(18),16,ex1(:),1,G2H8(18),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_UV_W(ntryL,G1H16(19),16,ex1(:),1,G2H8(19),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_UV_W(ntryL,G1H16(20),16,ex1(:),1,G2H8(20),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_UV_W(ntryL,G1H16(21),16,ex1(:),1,G2H8(21),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_GGG_G_12(ntryL,G1H16(22),ex3(:),ex2(:),G1H4(5),m4h2x2x4(:,1),heltab3x16(:,:,1))
  call Hloop_GGG_G_12(ntryL,G1H16(23),ex2(:),ex3(:),G1H4(6),m4h2x2x4(:,2),heltab3x16(:,:,2))
  call Hloop_GGG_G_23(ntryL,G1H16(24),ex3(:),ex2(:),G1H4(21),m4h2x2x4(:,3),heltab3x16(:,:,3))
  call Hloop_UV_W(ntryL,G1H16(25),16,ex1(:),1,G2H8(22),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_UV_W(ntryL,G1H16(26),16,ex1(:),1,G2H8(23),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_UV_W(ntryL,G1H16(27),16,ex1(:),1,G2H8(24),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_UV_W(ntryL,G1H16(28),16,ex2(:),2,G2H8(25),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_UV_W(ntryL,G1H16(29),16,ex2(:),2,G2H8(26),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_UV_W(ntryL,G1H16(30),16,ex2(:),2,G2H8(27),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_UV_W(ntryL,G1H16(31),16,ex3(:),4,G2H8(28),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_UV_W(ntryL,G1H16(32),16,ex3(:),4,G2H8(29),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_UV_W(ntryL,G1H16(33),16,ex3(:),4,G2H8(30),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_UV_W(ntryL,G1H16(34),16,ex2(:),2,G2H8(31),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_UV_W(ntryL,G1H16(35),16,ex2(:),2,G2H8(32),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_UV_W(ntryL,G1H16(36),16,ex2(:),2,G2H8(33),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_UV_W(ntryL,G1H16(37),16,ex2(:),2,G2H8(34),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_UV_W(ntryL,G1H16(38),16,ex2(:),2,G2H8(35),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_UV_W(ntryL,G1H16(39),16,ex2(:),2,G2H8(36),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_GGG_G_12(ntryL,G1H16(40),ex3(:),ex1(:),G1H4(22),m4h2x2x4(:,4),heltab3x16(:,:,4))
  call Hloop_GGG_G_12(ntryL,G1H16(41),ex1(:),ex3(:),G1H4(37),m4h2x2x4(:,5),heltab3x16(:,:,5))
  call Hloop_GGG_G_23(ntryL,G1H16(42),ex3(:),ex1(:),G1H4(38),m4h2x2x4(:,6),heltab3x16(:,:,6))
  call Hloop_UV_W(ntryL,G1H16(43),16,ex2(:),2,G2H8(37),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_UV_W(ntryL,G1H16(44),16,ex2(:),2,G2H8(38),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_UV_W(ntryL,G1H16(45),16,ex2(:),2,G2H8(39),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_GGG_G_12(ntryL,G1H16(46),ex2(:),ex1(:),G1H4(53),m4h2x2x4(:,7),heltab3x16(:,:,7))
  call Hloop_GGG_G_12(ntryL,G1H16(47),ex1(:),ex2(:),G1H4(54),m4h2x2x4(:,8),heltab3x16(:,:,8))
  call Hloop_GGG_G_23(ntryL,G1H16(48),ex2(:),ex1(:),G1H4(69),m4h2x2x4(:,9),heltab3x16(:,:,9))
  call Hloop_GGG_G_12(ntryL,G1H16(49),ex2(:),ex1(:),G1H4(70),m4h2x2x4(:,10),heltab3x16(:,:,10))
  call Hloop_GGG_G_12(ntryL,G1H16(50),ex1(:),ex2(:),G1H4(85),m4h2x2x4(:,11),heltab3x16(:,:,11))
  call Hloop_GGG_G_23(ntryL,G1H16(51),ex2(:),ex1(:),G1H4(86),m4h2x2x4(:,12),heltab3x16(:,:,12))
  call Hloop_UV_W(ntryL,G1H16(52),16,ex3(:),4,G2H8(40),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_UV_W(ntryL,G1H16(53),16,ex3(:),4,G2H8(41),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_UV_W(ntryL,G1H16(54),16,ex3(:),4,G2H8(42),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_CV_D(ntryL,G1H16(55),16,wf4(:,1),3,G2H4(69),m3h4x4(:,1),heltab2x16(:,:,79))
  call Hloop_DV_C(ntryL,G1H16(56),16,wf4(:,1),G2H4(70),m3h4x4(:,2),heltab2x16(:,:,80))
  call Hloop_UV_W(ntryL,G1H16(57),16,wf4(:,1),3,G2H4(71),m3h4x4(:,3),heltab2x16(:,:,81))
  call Hloop_DV_C(ntryL,G1H16(58),16,wf4(:,1),G2H4(74),m3h4x4(:,4),heltab2x16(:,:,82))
  call Hloop_CV_D(ntryL,G1H16(59),16,wf4(:,1),3,G2H4(75),m3h4x4(:,5),heltab2x16(:,:,83))
  call Hloop_UV_W(ntryL,G1H16(60),16,wf4(:,1),3,G2H4(76),m3h4x4(:,6),heltab2x16(:,:,84))
  call Hloop_CV_D(ntryL,G1H16(61),16,ex3(:),4,G2H8(43),m3h2x8(:,79),heltab2x16(:,:,85))
  call Hloop_DV_C(ntryL,G1H16(62),16,ex3(:),G2H8(44),m3h2x8(:,80),heltab2x16(:,:,86))
  call Hloop_UV_W(ntryL,G1H16(63),16,ex3(:),4,G2H8(45),m3h2x8(:,81),heltab2x16(:,:,87))
  call Hloop_DV_C(ntryL,G1H16(64),16,ex2(:),G2H8(46),m3h2x8(:,82),heltab2x16(:,:,88))
  call Hloop_CV_D(ntryL,G1H16(65),16,ex2(:),2,G2H8(47),m3h2x8(:,83),heltab2x16(:,:,89))
  call Hloop_UV_W(ntryL,G1H16(66),16,ex2(:),2,G2H8(48),m3h2x8(:,84),heltab2x16(:,:,90))
  call Hloop_DV_C(ntryL,G1H16(67),16,wf4(:,2),G2H4(79),m3h4x4(:,7),heltab2x16(:,:,91))
  call Hloop_CV_D(ntryL,G1H16(68),16,wf4(:,2),5,G2H4(80),m3h4x4(:,8),heltab2x16(:,:,92))
  call Hloop_UV_W(ntryL,G1H16(69),16,wf4(:,2),5,G2H4(81),m3h4x4(:,9),heltab2x16(:,:,93))
  call Hloop_CV_D(ntryL,G1H16(70),16,ex2(:),2,G2H8(49),m3h2x8(:,85),heltab2x16(:,:,94))
  call Hloop_DV_C(ntryL,G1H16(71),16,ex2(:),G2H8(50),m3h2x8(:,86),heltab2x16(:,:,95))
  call Hloop_UV_W(ntryL,G1H16(72),16,ex2(:),2,G2H8(51),m3h2x8(:,87),heltab2x16(:,:,96))
  call Hloop_DV_C(ntryL,G1H16(73),16,ex1(:),G2H8(52),m3h2x8(:,88),heltab2x16(:,:,97))
  call Hloop_CV_D(ntryL,G1H16(74),16,ex1(:),1,G2H8(53),m3h2x8(:,89),heltab2x16(:,:,98))
  call Hloop_UV_W(ntryL,G1H16(75),16,ex1(:),1,G2H8(54),m3h2x8(:,90),heltab2x16(:,:,99))
  call Hloop_DV_C(ntryL,G1H16(76),16,wf4(:,5),G2H4(84),m3h4x4(:,10),heltab2x16(:,:,100))
  call Hloop_CV_D(ntryL,G1H16(77),16,wf4(:,5),6,G2H4(85),m3h4x4(:,11),heltab2x16(:,:,101))
  call Hloop_UV_W(ntryL,G1H16(78),16,wf4(:,5),6,G2H4(86),m3h4x4(:,12),heltab2x16(:,:,102))
  call Hloop_CV_D(ntryL,G1H16(79),16,ex1(:),1,G2H8(55),m3h2x8(:,91),heltab2x16(:,:,103))
  call Hloop_DV_C(ntryL,G1H16(80),16,ex1(:),G2H8(56),m3h2x8(:,92),heltab2x16(:,:,104))
  call Hloop_UV_W(ntryL,G1H16(81),16,ex1(:),1,G2H8(57),m3h2x8(:,93),heltab2x16(:,:,105))
  call Hloop_DV_C(ntryL,G1H16(82),16,ex2(:),G2H8(58),m3h2x8(:,94),heltab2x16(:,:,106))
  call Hloop_CV_D(ntryL,G1H16(83),16,ex2(:),2,G2H8(59),m3h2x8(:,95),heltab2x16(:,:,107))
  call Hloop_UV_W(ntryL,G1H16(84),16,ex2(:),2,G2H8(60),m3h2x8(:,96),heltab2x16(:,:,108))
  call Hloop_CV_D(ntryL,G1H16(85),16,ex3(:),4,G2H8(61),m3h2x8(:,97),heltab2x16(:,:,109))
  call Hloop_DV_C(ntryL,G1H16(86),16,ex3(:),G2H8(62),m3h2x8(:,98),heltab2x16(:,:,110))
  call Hloop_UV_W(ntryL,G1H16(87),16,ex3(:),4,G2H8(63),m3h2x8(:,99),heltab2x16(:,:,111))
  call Hloop_CV_D(ntryL,G1H16(88),16,ex2(:),2,G2H8(64),m3h2x8(:,100),heltab2x16(:,:,112))
  call Hloop_DV_C(ntryL,G1H16(89),16,ex2(:),G2H8(65),m3h2x8(:,101),heltab2x16(:,:,113))
  call Hloop_UV_W(ntryL,G1H16(90),16,ex2(:),2,G2H8(66),m3h2x8(:,102),heltab2x16(:,:,114))
  call Hloop_DV_C(ntryL,G1H16(91),16,ex1(:),G2H8(67),m3h2x8(:,103),heltab2x16(:,:,115))
  call Hloop_CV_D(ntryL,G1H16(92),16,ex1(:),1,G2H8(68),m3h2x8(:,104),heltab2x16(:,:,116))
  call Hloop_UV_W(ntryL,G1H16(93),16,ex1(:),1,G2H8(69),m3h2x8(:,105),heltab2x16(:,:,117))
  call Hloop_CV_D(ntryL,G1H16(94),16,ex3(:),4,G2H8(70),m3h2x8(:,106),heltab2x16(:,:,118))
  call Hloop_DV_C(ntryL,G1H16(95),16,ex3(:),G2H8(71),m3h2x8(:,107),heltab2x16(:,:,119))
  call Hloop_UV_W(ntryL,G1H16(96),16,ex3(:),4,G2H8(72),m3h2x8(:,108),heltab2x16(:,:,120))
  call Hloop_CV_D(ntryL,G1H16(97),16,ex1(:),1,G2H8(73),m3h2x8(:,109),heltab2x16(:,:,121))
  call Hloop_DV_C(ntryL,G1H16(98),16,ex1(:),G2H8(74),m3h2x8(:,110),heltab2x16(:,:,122))
  call Hloop_UV_W(ntryL,G1H16(99),16,ex1(:),1,G2H8(75),m3h2x8(:,111),heltab2x16(:,:,123))
  call Hloop_DV_C(ntryL,G1H16(100),16,ex1(:),G2H8(76),m3h2x8(:,112),heltab2x16(:,:,124))
  call Hloop_CV_D(ntryL,G1H16(101),16,ex1(:),1,G2H8(77),m3h2x8(:,113),heltab2x16(:,:,125))
  call Hloop_UV_W(ntryL,G1H16(102),16,ex1(:),1,G2H8(78),m3h2x8(:,114),heltab2x16(:,:,126))
  call Hloop_CV_D(ntryL,G1H16(103),16,ex2(:),2,G2H8(79),m3h2x8(:,115),heltab2x16(:,:,127))
  call Hloop_DV_C(ntryL,G1H16(104),16,ex2(:),G2H8(80),m3h2x8(:,116),heltab2x16(:,:,128))
  call Hloop_UV_W(ntryL,G1H16(105),16,ex2(:),2,G2H8(81),m3h2x8(:,117),heltab2x16(:,:,129))
  call Hloop_CV_D(ntryL,G1H16(106),16,ex1(:),1,G2H8(82),m3h2x8(:,118),heltab2x16(:,:,130))
  call Hloop_DV_C(ntryL,G1H16(107),16,ex1(:),G2H8(83),m3h2x8(:,119),heltab2x16(:,:,131))
  call Hloop_UV_W(ntryL,G1H16(108),16,ex1(:),1,G2H8(84),m3h2x8(:,120),heltab2x16(:,:,132))
  call Hloop_DV_C(ntryL,G1H8(30),20,ex1(:),G2H4(89),m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_CV_D(ntryL,G1H8(31),20,ex1(:),1,G2H4(90),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_CV_D(ntryL,G1H8(34),24,ex2(:),2,G2H4(91),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_DV_C(ntryL,G1H8(35),24,ex2(:),G2H4(94),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_DV_C(ntryL,G1H8(37),24,ex1(:),G2H4(95),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_CV_D(ntryL,G1H8(38),24,ex1(:),1,G2H4(96),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_DV_C(ntryL,G1H8(41),24,ex1(:),G2H4(99),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_CV_D(ntryL,G1H8(42),24,ex1(:),1,G2H4(100),m3h2x4(:,228),heltab2x8(:,:,228))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G2H4(123),G2H4(3),G1H4(388),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G2H4(128),G2H4(8),G1H4(404),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G2H4(133),G2H4(13),G1H4(38),G1H4(37),G1H4(22) &
    ,G1H4(420),G1H4(36)])
call HGT_OLR(G2H4(17),1,1,4)
call HGT_invQ_OLR(G2H4(17),2,5,4)
call HGT_OLR(G2H4(17),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(68),G2H4(18),G1H4(212),G1H4(52)])
call HGT_OLR(G2H4(22),1,1,4)
call HGT_invQ_OLR(G2H4(22),2,5,4)
call HGT_OLR(G2H4(22),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(63),G2H4(23),G1H4(196),G1H4(68)])
call HGT_lower_alpha_OLR(G2H4(27),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(27),2,5,4)
call HGT_lower_alpha_OLR(G2H4(27),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(73),G2H4(28),G1H4(86),G1H4(85),G1H4(70) &
    ,G1H4(228),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G2H4(93),G2H4(33),G1H4(292),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(98),G2H4(38),G1H4(308),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G2H4(103),G2H4(43),G1H4(21),G1H4(6),G1H4(5) &
    ,G1H4(324),G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(99)])
call HGT_OLR(G2H4(47),1,1,4)
call HGT_invQ_OLR(G2H4(47),2,5,4)
call HGT_OLR(G2H4(47),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(83),G2H4(48),G1H4(260),G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(115)])
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(78),G2H4(53),G1H4(244),G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(131)])
call HGT_lower_alpha_OLR(G2H4(57),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(57),2,5,4)
call HGT_lower_alpha_OLR(G2H4(57),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(88),G2H4(58),G1H4(69),G1H4(54),G1H4(53) &
    ,G1H4(276),G1H4(180)])
call HGT_OLR(G2H4(62),1,1,4)
call HGT_invQ_OLR(G2H4(62),2,5,4)
call HGT_OLR(G2H4(62),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(95)])
call HGT_OLR(G2H4(67),1,1,4)
call HGT_invQ_OLR(G2H4(67),2,5,4)
call HGT_OLR(G2H4(67),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(96)])
call HGT_lower_alpha_OLR(G2H4(72),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(72),2,5,4)
call HGT_lower_alpha_OLR(G2H4(72),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(3)])
call HGT_OLR(G2H4(77),1,1,4)
call HGT_invQ_OLR(G2H4(77),2,5,4)
call HGT_OLR(G2H4(77),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(19)])
call HGT_OLR(G2H4(82),1,1,4)
call HGT_invQ_OLR(G2H4(82),2,5,4)
call HGT_OLR(G2H4(82),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(35)])
call HGT_lower_alpha_OLR(G2H4(87),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(87),2,5,4)
call HGT_lower_alpha_OLR(G2H4(87),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G1H4(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(113),[G1H4(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G1H4(372)])
call HGT_OLR(G2H4(122),1,1,4)
call HGT_invQ_OLR(G2H4(122),2,5,4)
call HGT_OLR(G2H4(122),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G2H4(99)])
call HGT_OLR(G2H4(127),1,1,4)
call HGT_invQ_OLR(G2H4(127),2,5,4)
call HGT_OLR(G2H4(127),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(127),[G2H4(100)])
call HGT_lower_alpha_OLR(G2H4(132),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(132),2,5,4)
call HGT_lower_alpha_OLR(G2H4(132),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(67)])
call HGT_OLR(G2H4(137),1,1,4)
call HGT_invQ_OLR(G2H4(137),2,5,4)
call HGT_OLR(G2H4(137),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(137),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G1H4(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(51)])
call HGT_OLR(G2H4(142),1,1,4)
call HGT_invQ_OLR(G2H4(142),2,5,4)
call HGT_OLR(G2H4(142),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G1H4(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(83)])
call HGT_lower_alpha_OLR(G2H4(147),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(147),2,5,4)
call HGT_lower_alpha_OLR(G2H4(147),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G1H4(468)])
call HGT_OLR(G2H4(152),1,1,4)
call HGT_invQ_OLR(G2H4(152),2,5,4)
call HGT_OLR(G2H4(152),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(153),[G1H4(484)])
call HGT_OLR(G2H4(157),1,1,4)
call HGT_invQ_OLR(G2H4(157),2,5,4)
call HGT_OLR(G2H4(157),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(157),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(158),[G1H4(500)])
call HGT_lower_alpha_OLR(G2H4(162),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(162),2,5,4)
call HGT_lower_alpha_OLR(G2H4(162),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(162),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(163),[G1H4(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(163)])
call HGT_OLR(G2H4(167),1,1,4)
call HGT_invQ_OLR(G2H4(167),2,5,4)
call HGT_OLR(G2H4(167),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(167),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(168),[G1H4(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(147)])
call HGT_OLR(G2H4(172),1,1,4)
call HGT_invQ_OLR(G2H4(172),2,5,4)
call HGT_OLR(G2H4(172),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(172),[G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(173),[G1H4(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(179)])
call HGT_lower_alpha_OLR(G2H4(177),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(177),2,5,4)
call HGT_lower_alpha_OLR(G2H4(177),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(177),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(178),[G1H4(564)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(394),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(399),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(410),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(415),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(426),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(431),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(218),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(207),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(239),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(298),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(303),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(314),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(319),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(330),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(335),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(266),[G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(250),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(282),[G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(287),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G1H4(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(483)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G1H4(499)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G1H4(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(547)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(563)])
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(47),mass4set(:,1),  & 
G1H4(101),G1H4(102),G1H4(117),G1H4(118),G1H4(133),G0H4(1),4)
  call HG1shiftOLR(G1H4(102),2,4)
  call Hotf_4pt_reduction(G2H4(79),RedSet_4(16),mass4set(:,1),  & 
G1H4(134),G1H4(149),G1H4(150),G1H4(165),G1H4(166),G0H4(2),4)
  call HG1shiftOLR(G1H4(149),8,4)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(47),mass4set(:,1),  & 
G1H4(181),G1H4(182),G1H4(197),G1H4(198),G1H4(213),G0H4(3),4)
  call HG1shiftOLR(G1H4(182),2,4)
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(16),mass4set(:,1),  & 
G1H4(214),G1H4(229),G1H4(230),G1H4(245),G1H4(246),G0H4(4),4)
  call HG1shiftOLR(G1H4(229),8,4)
call HGT_lower_alpha_OLR(G2H4(12),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(12),2,5,4)
call HGT_lower_alpha_OLR(G2H4(12),6,15,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(47),mass4set(:,1),  & 
G1H4(261),G1H4(262),G1H4(277),G1H4(278),G1H4(293),G0H4(5),4)
  call HG1shiftOLR(G1H4(262),2,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(16),mass4set(:,1),  & 
G1H4(294),G1H4(309),G1H4(310),G1H4(325),G1H4(326),G0H4(6),4)
  call HG1shiftOLR(G1H4(309),8,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(48),mass4set(:,1),  & 
G1H4(341),G1H4(342),G1H4(357),G1H4(358),G1H4(373),G0H4(7),4)
  call HG1shiftOLR(G1H4(342),4,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(19),mass4set(:,1),  & 
G1H4(374),G1H4(389),G1H4(390),G1H4(405),G1H4(406),G0H4(8),4)
  call HG1shiftOLR(G1H4(389),8,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(48),mass4set(:,1),  & 
G1H4(421),G1H4(422),G1H4(437),G1H4(438),G1H4(453),G0H4(9),4)
  call HG1shiftOLR(G1H4(422),4,4)
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(19),mass4set(:,1),  & 
G1H4(454),G1H4(469),G1H4(470),G1H4(485),G1H4(486),G0H4(10),4)
  call HG1shiftOLR(G1H4(469),8,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(48),mass4set(:,1),  & 
G1H4(501),G1H4(502),G1H4(517),G1H4(518),G1H4(533),G0H4(11),4)
  call HG1shiftOLR(G1H4(502),4,4)
  call Hotf_4pt_reduction(G2H4(76),RedSet_4(19),mass4set(:,1),  & 
G1H4(534),G1H4(549),G1H4(550),G1H4(565),G1H4(566),G0H4(12),4)
  call HG1shiftOLR(G1H4(549),8,4)
call HGT_OLR(G2H4(32),1,1,4)
call HGT_invQ_OLR(G2H4(32),2,5,4)
call HGT_OLR(G2H4(32),6,15,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(49),mass4set(:,1),  & 
G1H4(1),G1H4(2),G1H4(7),G1H4(12),G1H4(8),G0H4(13),4)
  call HG1shiftOLR(G1H4(2),1,4)
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(22),mass4set(:,1),  & 
G1H4(11),G1H4(13),G1H4(16),G1H4(17),G1H4(18),G0H4(14),4)
  call HG1shiftOLR(G1H4(13),8,4)
call HGT_OLR(G2H4(37),1,1,4)
call HGT_invQ_OLR(G2H4(37),2,5,4)
call HGT_OLR(G2H4(37),6,15,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(49),mass4set(:,1),  & 
G1H4(23),G1H4(28),G1H4(24),G1H4(27),G1H4(29),G0H4(15),4)
  call HG1shiftOLR(G1H4(28),1,4)
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(22),mass4set(:,1),  & 
G1H4(32),G1H4(33),G1H4(34),G1H4(39),G1H4(44),G0H4(16),4)
  call HG1shiftOLR(G1H4(33),8,4)
call HGT_lower_alpha_OLR(G2H4(42),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(42),2,5,4)
call HGT_lower_alpha_OLR(G2H4(42),6,15,4)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(49),mass4set(:,1),  & 
G1H4(40),G1H4(43),G1H4(45),G1H4(48),G1H4(49),G0H4(17),4)
  call HG1shiftOLR(G1H4(43),1,4)
  call Hotf_4pt_reduction(G2H4(86),RedSet_4(22),mass4set(:,1),  & 
G1H4(50),G1H4(55),G1H4(60),G1H4(56),G1H4(59),G0H4(18),4)
  call HG1shiftOLR(G1H4(55),8,4)
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(21),mass4set(:,1),  & 
G1H4(61),G1H4(64),G1H4(65),G1H4(66),G1H4(71),G0H4(19),4)
  call HG1shiftOLR(G1H4(64),8,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(25),mass4set(:,1),  & 
G1H4(76),G1H4(72),G1H4(75),G1H4(77),G1H4(80),G0H4(20),4)
  call HG1shiftOLR(G1H4(72),4,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(21),mass4set(:,1),  & 
G1H4(81),G1H4(82),G1H4(87),G1H4(92),G1H4(88),G0H4(21),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(25),mass4set(:,1),  & 
G1H4(91),G1H4(93),G1H4(96),G1H4(97),G1H4(98),G0H4(22),4)
  call HG1shiftOLR(G1H4(93),4,4)
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(21),mass4set(:,1),  & 
G1H4(103),G1H4(108),G1H4(104),G1H4(107),G1H4(109),G0H4(23),4)
  call HG1shiftOLR(G1H4(108),8,4)
  call Hotf_4pt_reduction(G2H4(71),RedSet_4(25),mass4set(:,1),  & 
G1H4(112),G1H4(113),G1H4(114),G1H4(119),G1H4(124),G0H4(24),4)
  call HG1shiftOLR(G1H4(113),4,4)
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(50),mass4set(:,1),  & 
G1H4(120),G1H4(123),G1H4(125),G1H4(128),G1H4(129),G0H4(25),4)
  call HG1shiftOLR(G1H4(123),4,4)
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(50),mass4set(:,1),  & 
G1H4(130),G1H4(135),G1H4(140),G1H4(136),G1H4(139),G0H4(26),4)
  call HG1shiftOLR(G1H4(135),4,4)
  call Hotf_4pt_reduction(G2H4(72),RedSet_4(50),mass4set(:,1),  & 
G1H4(141),G1H4(144),G1H4(145),G1H4(146),G1H4(151),G0H4(27),4)
  call HG1shiftOLR(G1H4(144),4,4)
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(15),mass4set(:,1),  & 
G1H4(156),G1H4(152),G1H4(155),G1H4(157),G1H4(160),G0H4(28),4)
  call HG1shiftOLR(G1H4(152),8,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(15),mass4set(:,1),  & 
G1H4(161),G1H4(162),G1H4(167),G1H4(172),G1H4(168),G0H4(29),4)
  call HG1shiftOLR(G1H4(162),8,4)
  call Hotf_4pt_reduction(G2H4(87),RedSet_4(15),mass4set(:,1),  & 
G1H4(171),G1H4(173),G1H4(176),G1H4(177),G1H4(178),G0H4(30),4)
  call HG1shiftOLR(G1H4(173),8,4)
call HGT_OLR(G2H4(92),1,1,4)
call HGT_invQ_OLR(G2H4(92),2,5,4)
call HGT_OLR(G2H4(92),6,15,4)
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(51),mass4set(:,1),  & 
G1H4(183),G1H4(188),G1H4(184),G1H4(187),G1H4(189),G0H4(31),4)
  call HG1shiftOLR(G1H4(188),1,4)
call HGT_OLR(G2H4(97),1,1,4)
call HGT_invQ_OLR(G2H4(97),2,5,4)
call HGT_OLR(G2H4(97),6,15,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(51),mass4set(:,1),  & 
G1H4(192),G1H4(193),G1H4(194),G1H4(199),G1H4(204),G0H4(32),4)
  call HG1shiftOLR(G1H4(193),1,4)
call HGT_lower_alpha_OLR(G2H4(102),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(102),2,5,4)
call HGT_lower_alpha_OLR(G2H4(102),6,15,4)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(51),mass4set(:,1),  & 
G1H4(200),G1H4(203),G1H4(205),G1H4(208),G1H4(209),G0H4(33),4)
  call HG1shiftOLR(G1H4(203),1,4)
call HGT_OLR(G2H4(107),1,1,4)
call HGT_invQ_OLR(G2H4(107),2,5,4)
call HGT_OLR(G2H4(107),6,15,4)
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(52),mass4set(:,1),  & 
G1H4(210),G1H4(215),G1H4(220),G1H4(216),G1H4(219),G0H4(34),4)
  call HG1shiftOLR(G1H4(215),1,4)
  call Hotf_4pt_reduction(G2H4(108),RedSet_4(34),mass4set(:,1),  & 
G1H4(221),G1H4(224),G1H4(225),G1H4(226),G1H4(231),G0H4(35),4)
  call HG1shiftOLR(G1H4(224),4,4)
call HGT_OLR(G2H4(112),1,1,4)
call HGT_invQ_OLR(G2H4(112),2,5,4)
call HGT_OLR(G2H4(112),6,15,4)
  call Hotf_4pt_reduction(G2H4(112),RedSet_4(52),mass4set(:,1),  & 
G1H4(236),G1H4(232),G1H4(235),G1H4(237),G1H4(240),G0H4(36),4)
  call HG1shiftOLR(G1H4(232),1,4)
  call Hotf_4pt_reduction(G2H4(113),RedSet_4(34),mass4set(:,1),  & 
G1H4(241),G1H4(242),G1H4(247),G1H4(252),G1H4(248),G0H4(37),4)
  call HG1shiftOLR(G1H4(242),4,4)
call HGT_lower_alpha_OLR(G2H4(117),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(117),2,5,4)
call HGT_lower_alpha_OLR(G2H4(117),6,15,4)
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(52),mass4set(:,1),  & 
G1H4(251),G1H4(253),G1H4(256),G1H4(257),G1H4(258),G0H4(38),4)
  call HG1shiftOLR(G1H4(253),1,4)
  call Hotf_4pt_reduction(G2H4(118),RedSet_4(34),mass4set(:,1),  & 
G1H4(263),G1H4(268),G1H4(264),G1H4(267),G1H4(269),G0H4(39),4)
  call HG1shiftOLR(G1H4(268),4,4)
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(53),mass4set(:,1),  & 
G1H4(272),G1H4(273),G1H4(274),G1H4(279),G1H4(284),G0H4(40),4)
  call HG1shiftOLR(G1H4(273),2,4)
  call Hotf_4pt_reduction(G2H4(127),RedSet_4(53),mass4set(:,1),  & 
G1H4(280),G1H4(283),G1H4(285),G1H4(288),G1H4(289),G0H4(41),4)
  call HG1shiftOLR(G1H4(283),2,4)
  call Hotf_4pt_reduction(G2H4(132),RedSet_4(53),mass4set(:,1),  & 
G1H4(290),G1H4(295),G1H4(300),G1H4(296),G1H4(299),G0H4(42),4)
  call HG1shiftOLR(G1H4(295),2,4)
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(18),mass4set(:,1),  & 
G1H4(301),G1H4(304),G1H4(305),G1H4(306),G1H4(311),G0H4(43),4)
  call HG1shiftOLR(G1H4(304),8,4)
  call Hotf_4pt_reduction(G2H4(138),RedSet_4(39),mass4set(:,1),  & 
G1H4(316),G1H4(312),G1H4(315),G1H4(317),G1H4(320),G0H4(44),4)
  call HG1shiftOLR(G1H4(312),2,4)
  call Hotf_4pt_reduction(G2H4(142),RedSet_4(18),mass4set(:,1),  & 
G1H4(321),G1H4(322),G1H4(327),G1H4(332),G1H4(328),G0H4(45),4)
  call HG1shiftOLR(G1H4(322),8,4)
  call Hotf_4pt_reduction(G2H4(143),RedSet_4(39),mass4set(:,1),  & 
G1H4(331),G1H4(333),G1H4(336),G1H4(337),G1H4(338),G0H4(46),4)
  call HG1shiftOLR(G1H4(333),2,4)
  call Hotf_4pt_reduction(G2H4(147),RedSet_4(18),mass4set(:,1),  & 
G1H4(343),G1H4(348),G1H4(344),G1H4(347),G1H4(349),G0H4(47),4)
  call HG1shiftOLR(G1H4(348),8,4)
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(39),mass4set(:,1),  & 
G1H4(352),G1H4(353),G1H4(354),G1H4(359),G1H4(364),G0H4(48),4)
  call HG1shiftOLR(G1H4(353),2,4)
  call Hotf_4pt_reduction(G2H4(152),RedSet_4(54),mass4set(:,1),  & 
G1H4(360),G1H4(363),G1H4(365),G1H4(368),G1H4(369),G0H4(49),4)
  call HG1shiftOLR(G1H4(363),2,4)
  call Hotf_4pt_reduction(G2H4(153),RedSet_4(42),mass4set(:,1),  & 
G1H4(370),G1H4(375),G1H4(380),G1H4(376),G1H4(379),G0H4(50),4)
  call HG1shiftOLR(G1H4(375),4,4)
  call Hotf_4pt_reduction(G2H4(157),RedSet_4(54),mass4set(:,1),  & 
G1H4(381),G1H4(384),G1H4(385),G1H4(386),G1H4(391),G0H4(51),4)
  call HG1shiftOLR(G1H4(384),2,4)
  call Hotf_4pt_reduction(G2H4(158),RedSet_4(42),mass4set(:,1),  & 
G1H4(396),G1H4(392),G1H4(395),G1H4(397),G1H4(400),G0H4(52),4)
  call HG1shiftOLR(G1H4(392),4,4)
  call Hotf_4pt_reduction(G2H4(162),RedSet_4(54),mass4set(:,1),  & 
G1H4(401),G1H4(402),G1H4(407),G1H4(412),G1H4(408),G0H4(53),4)
  call HG1shiftOLR(G1H4(402),2,4)
  call Hotf_4pt_reduction(G2H4(163),RedSet_4(42),mass4set(:,1),  & 
G1H4(411),G1H4(413),G1H4(416),G1H4(417),G1H4(418),G0H4(54),4)
  call HG1shiftOLR(G1H4(413),4,4)
  call Hotf_4pt_reduction(G2H4(167),RedSet_4(24),mass4set(:,1),  & 
G1H4(423),G1H4(428),G1H4(424),G1H4(427),G1H4(429),G0H4(55),4)
  call HG1shiftOLR(G1H4(428),4,4)
  call Hotf_4pt_reduction(G2H4(168),RedSet_4(45),mass4set(:,1),  & 
G1H4(432),G1H4(433),G1H4(434),G1H4(439),G1H4(444),G0H4(56),4)
  call HG1shiftOLR(G1H4(433),2,4)
  call Hotf_4pt_reduction(G2H4(172),RedSet_4(24),mass4set(:,1),  & 
G1H4(440),G1H4(443),G1H4(445),G1H4(448),G1H4(449),G0H4(57),4)
  call HG1shiftOLR(G1H4(443),4,4)
  call Hotf_4pt_reduction(G2H4(173),RedSet_4(45),mass4set(:,1),  & 
G1H4(450),G1H4(455),G1H4(460),G1H4(456),G1H4(459),G0H4(58),4)
  call HG1shiftOLR(G1H4(455),2,4)
  call Hotf_4pt_reduction(G2H4(177),RedSet_4(24),mass4set(:,1),  & 
G1H4(461),G1H4(464),G1H4(465),G1H4(466),G1H4(471),G0H4(59),4)
  call HG1shiftOLR(G1H4(464),4,4)
  call Hotf_4pt_reduction(G2H4(178),RedSet_4(45),mass4set(:,1),  & 
G1H4(476),G1H4(472),G1H4(475),G1H4(477),G1H4(480),G0H4(60),4)
  call HG1shiftOLR(G1H4(472),2,4)
  call Hloop_DV_C(ntryL,G1H4(9),21,ex2(:),G2H2(1),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_DV_C(ntryL,G1H4(394),21,ex2(:),G2H2(4),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_DV_C(ntryL,G1H4(14),21,ex2(:),G2H2(9),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_DV_C(ntryL,G1H4(399),21,ex2(:),G2H2(12),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_CV_D(ntryL,G1H4(25),21,ex2(:),2,G2H2(17),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_CV_D(ntryL,G1H4(410),21,ex2(:),2,G2H2(20),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_CV_D(ntryL,G1H4(30),21,ex2(:),2,G2H2(25),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_CV_D(ntryL,G1H4(415),21,ex2(:),2,G2H2(28),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_UV_W(ntryL,G1H4(41),21,ex2(:),2,G2H2(33),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_UV_W(ntryL,G1H4(426),21,ex2(:),2,G2H2(36),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_UV_W(ntryL,G1H4(46),21,ex2(:),2,G2H2(41),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_UV_W(ntryL,G1H4(431),21,ex2(:),2,G2H2(44),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_CV_D(ntryL,G1H4(57),19,ex3(:),4,G2H2(49),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_CV_D(ntryL,G1H4(218),19,ex3(:),4,G2H2(52),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_CV_D(ntryL,G1H4(62),19,ex3(:),4,G2H2(57),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_CV_D(ntryL,G1H4(223),19,ex3(:),4,G2H2(60),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_DV_C(ntryL,G1H4(73),19,ex3(:),G2H2(65),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_DV_C(ntryL,G1H4(202),19,ex3(:),G2H2(68),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_DV_C(ntryL,G1H4(78),19,ex3(:),G2H2(73),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_DV_C(ntryL,G1H4(207),19,ex3(:),G2H2(76),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_UV_W(ntryL,G1H4(89),19,ex3(:),4,G2H2(81),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_UV_W(ntryL,G1H4(234),19,ex3(:),4,G2H2(84),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_UV_W(ntryL,G1H4(94),19,ex3(:),4,G2H2(89),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_UV_W(ntryL,G1H4(239),19,ex3(:),4,G2H2(92),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_CV_D(ntryL,G1H4(105),22,ex1(:),1,G2H2(97),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_CV_D(ntryL,G1H4(298),22,ex1(:),1,G2H2(100),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_CV_D(ntryL,G1H4(110),22,ex1(:),1,G2H2(105),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_CV_D(ntryL,G1H4(303),22,ex1(:),1,G2H2(108),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_DV_C(ntryL,G1H4(121),22,ex1(:),G2H2(113),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_DV_C(ntryL,G1H4(314),22,ex1(:),G2H2(116),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_DV_C(ntryL,G1H4(126),22,ex1(:),G2H2(121),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_DV_C(ntryL,G1H4(319),22,ex1(:),G2H2(124),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_UV_W(ntryL,G1H4(137),22,ex1(:),1,G2H2(129),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_UV_W(ntryL,G1H4(330),22,ex1(:),1,G2H2(132),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_UV_W(ntryL,G1H4(142),22,ex1(:),1,G2H2(137),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_UV_W(ntryL,G1H4(335),22,ex1(:),1,G2H2(140),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_CV_D(ntryL,G1H4(153),19,ex4(:),8,G2H2(145),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_CV_D(ntryL,G1H4(266),19,ex4(:),8,G2H2(148),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_CV_D(ntryL,G1H4(158),19,ex4(:),8,G2H2(153),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_CV_D(ntryL,G1H4(271),19,ex4(:),8,G2H2(156),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_DV_C(ntryL,G1H4(169),19,ex4(:),G2H2(161),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_DV_C(ntryL,G1H4(250),19,ex4(:),G2H2(164),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_DV_C(ntryL,G1H4(174),19,ex4(:),G2H2(169),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_DV_C(ntryL,G1H4(255),19,ex4(:),G2H2(172),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_UV_W(ntryL,G1H4(185),19,ex4(:),8,G2H2(177),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_UV_W(ntryL,G1H4(282),19,ex4(:),8,G2H2(180),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_UV_W(ntryL,G1H4(190),19,ex4(:),8,G2H2(185),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_UV_W(ntryL,G1H4(287),19,ex4(:),8,G2H2(188),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(27),mass4set(:,1),  & 
G1H4(481),G1H4(482),G1H4(487),G1H4(492),G1H4(488),G0H4(61),4)
  call HG1shiftOLR(G1H4(482),8,4)
  call Hloop_DV_C(ntryL,G1H4(201),19,ex3(:),G2H2(193),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_DV_C(ntryL,G1H4(206),19,ex3(:),G2H2(196),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(27),mass4set(:,1),  & 
G1H4(491),G1H4(493),G1H4(496),G1H4(497),G1H4(498),G0H4(62),4)
  call HG1shiftOLR(G1H4(493),8,4)
  call Hloop_CV_D(ntryL,G1H4(217),19,ex3(:),4,G2H2(201),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_CV_D(ntryL,G1H4(222),19,ex3(:),4,G2H2(204),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(27),mass4set(:,1),  & 
G1H4(503),G1H4(508),G1H4(504),G1H4(507),G1H4(509),G0H4(63),4)
  call HG1shiftOLR(G1H4(508),8,4)
  call Hloop_UV_W(ntryL,G1H4(233),19,ex3(:),4,G2H2(209),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_UV_W(ntryL,G1H4(238),19,ex3(:),4,G2H2(212),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(29),mass4set(:,1),  & 
G1H4(512),G1H4(513),G1H4(514),G1H4(519),G1H4(524),G0H4(64),4)
  call HG1shiftOLR(G1H4(513),4,4)
  call Hloop_DV_C(ntryL,G1H4(249),19,ex4(:),G2H2(217),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_DV_C(ntryL,G1H4(254),19,ex4(:),G2H2(220),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(29),mass4set(:,1),  & 
G1H4(520),G1H4(523),G1H4(525),G1H4(528),G1H4(529),G0H4(65),4)
  call HG1shiftOLR(G1H4(523),4,4)
  call Hloop_CV_D(ntryL,G1H4(265),19,ex4(:),8,G2H2(225),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_CV_D(ntryL,G1H4(270),19,ex4(:),8,G2H2(228),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(29),mass4set(:,1),  & 
G1H4(530),G1H4(535),G1H4(540),G1H4(536),G1H4(539),G0H4(66),4)
  call HG1shiftOLR(G1H4(535),4,4)
  call Hloop_UV_W(ntryL,G1H4(281),19,ex4(:),8,G2H2(233),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_UV_W(ntryL,G1H4(286),19,ex4(:),8,G2H2(236),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(31),mass4set(:,1),  & 
G1H4(541),G1H4(544),G1H4(545),G1H4(546),G1H4(551),G0H4(67),4)
  call HG1shiftOLR(G1H4(544),8,4)
  call Hloop_CV_D(ntryL,G1H4(297),22,ex1(:),1,G2H2(241),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_CV_D(ntryL,G1H4(302),22,ex1(:),1,G2H2(244),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(31),mass4set(:,1),  & 
G1H4(556),G1H4(552),G1H4(555),G1H4(557),G1H4(560),G0H4(68),4)
  call HG1shiftOLR(G1H4(552),8,4)
  call Hloop_DV_C(ntryL,G1H4(313),22,ex1(:),G2H2(249),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_DV_C(ntryL,G1H4(318),22,ex1(:),G2H2(252),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(31),mass4set(:,1),  & 
G1H4(561),G1H4(562),G1H4(567),G1H4(572),G1H4(568),G0H4(69),4)
  call HG1shiftOLR(G1H4(562),8,4)
  call Hloop_UV_W(ntryL,G1H4(329),22,ex1(:),1,G2H2(257),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_UV_W(ntryL,G1H4(334),22,ex1(:),1,G2H2(260),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(33),mass4set(:,1),  & 
G1H4(571),G1H4(573),G1H4(576),G1H4(388),G1H4(4),G0H4(70),4)
  call HG1shiftOLR(G1H4(573),4,4)
  call Hloop_DV_C(ntryL,G1H4(345),26,ex1(:),G2H2(265),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_DV_C(ntryL,G1H4(346),26,ex1(:),G2H2(268),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_DV_C(ntryL,G1H4(350),26,ex1(:),G2H2(273),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_DV_C(ntryL,G1H4(351),26,ex1(:),G2H2(276),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(33),mass4set(:,1),  & 
G1H4(404),G1H4(20),G1H4(38),G1H4(37),G1H4(22),G0H4(71),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_CV_D(ntryL,G1H4(361),26,ex1(:),1,G2H2(281),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_CV_D(ntryL,G1H4(362),26,ex1(:),1,G2H2(284),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_CV_D(ntryL,G1H4(366),26,ex1(:),1,G2H2(289),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_CV_D(ntryL,G1H4(367),26,ex1(:),1,G2H2(290),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(33),mass4set(:,1),  & 
G1H4(420),G1H4(36),G1H4(212),G1H4(52),G1H4(196),G0H4(72),4)
  call HG1shiftOLR(G1H4(36),4,4)
  call Hloop_UV_W(ntryL,G1H4(377),26,ex1(:),1,G2H2(291),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_UV_W(ntryL,G1H4(378),26,ex1(:),1,G2H2(292),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_UV_W(ntryL,G1H4(382),26,ex1(:),1,G2H2(293),m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_UV_W(ntryL,G1H4(383),26,ex1(:),1,G2H2(294),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(36),mass4set(:,1),  & 
G1H4(68),G1H4(86),G1H4(85),G1H4(70),G1H4(228),G0H4(73),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hloop_DV_C(ntryL,G1H4(393),21,ex2(:),G2H2(295),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_DV_C(ntryL,G1H4(398),21,ex2(:),G2H2(296),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(36),mass4set(:,1),  & 
G1H4(84),G1H4(292),G1H4(100),G1H4(308),G1H4(116),G0H4(74),4)
  call HG1shiftOLR(G1H4(292),8,4)
  call Hloop_CV_D(ntryL,G1H4(409),21,ex2(:),2,G2H2(297),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_CV_D(ntryL,G1H4(414),21,ex2(:),2,G2H2(298),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(36),mass4set(:,1),  & 
G1H4(21),G1H4(6),G1H4(5),G1H4(324),G1H4(132),G0H4(75),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hloop_UV_W(ntryL,G1H4(425),21,ex2(:),2,G2H2(299),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_UV_W(ntryL,G1H4(430),21,ex2(:),2,G2H2(300),m3h2x2(:,444),heltab2x4(:,:,444))
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(38),mass4set(:,1),  & 
G1H4(99),G1H4(260),G1H4(148),G1H4(115),G1H4(244),G0H4(76),4)
  call HG1shiftOLR(G1H4(260),2,4)
  call Hloop_DV_C(ntryL,G1H4(441),21,ex4(:),G2H2(301),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_DV_C(ntryL,G1H4(442),21,ex4(:),G2H2(302),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_DV_C(ntryL,G1H4(446),21,ex4(:),G2H2(303),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_DV_C(ntryL,G1H4(447),21,ex4(:),G2H2(304),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(38),mass4set(:,1),  & 
G1H4(164),G1H4(131),G1H4(69),G1H4(54),G1H4(53),G0H4(77),4)
  call HG1shiftOLR(G1H4(131),2,4)
  call Hloop_CV_D(ntryL,G1H4(457),21,ex4(:),8,G2H2(305),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_CV_D(ntryL,G1H4(458),21,ex4(:),8,G2H2(306),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_CV_D(ntryL,G1H4(462),21,ex4(:),8,G2H2(307),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_CV_D(ntryL,G1H4(463),21,ex4(:),8,G2H2(308),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(38),mass4set(:,1),  & 
G1H4(276),G1H4(180),G1H4(3),G1H4(19),G1H4(35),G0H4(78),4)
  call HG1shiftOLR(G1H4(180),2,4)
  call Hloop_UV_W(ntryL,G1H4(473),21,ex4(:),8,G2H2(309),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_UV_W(ntryL,G1H4(474),21,ex4(:),8,G2H2(310),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_UV_W(ntryL,G1H4(478),21,ex4(:),8,G2H2(311),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_UV_W(ntryL,G1H4(479),21,ex4(:),8,G2H2(312),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(41),mass4set(:,1),  & 
G1H4(340),G1H4(356),G1H4(372),G1H4(67),G1H4(436),G0H4(79),4)
  call HG1shiftOLR(G1H4(356),4,4)
  call Hloop_DV_C(ntryL,G1H4(489),25,ex2(:),G2H2(313),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_DV_C(ntryL,G1H4(490),25,ex2(:),G2H2(314),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_DV_C(ntryL,G1H4(494),25,ex2(:),G2H2(315),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_DV_C(ntryL,G1H4(495),25,ex2(:),G2H2(316),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(41),mass4set(:,1),  & 
G1H4(51),G1H4(452),G1H4(83),G1H4(468),G1H4(484),G0H4(80),4)
  call HG1shiftOLR(G1H4(452),4,4)
  call Hloop_CV_D(ntryL,G1H4(505),25,ex2(:),2,G2H2(317),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_CV_D(ntryL,G1H4(506),25,ex2(:),2,G2H2(318),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_CV_D(ntryL,G1H4(510),25,ex2(:),2,G2H2(319),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_CV_D(ntryL,G1H4(511),25,ex2(:),2,G2H2(320),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hotf_4pt_reduction(G2H4(55),RedSet_4(41),mass4set(:,1),  & 
G1H4(500),G1H4(516),G1H4(163),G1H4(532),G1H4(147),G0H4(81),4)
  call HG1shiftOLR(G1H4(516),4,4)
  call Hloop_UV_W(ntryL,G1H4(521),25,ex2(:),2,G2H2(321),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_UV_W(ntryL,G1H4(522),25,ex2(:),2,G2H2(322),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_UV_W(ntryL,G1H4(526),25,ex2(:),2,G2H2(323),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_UV_W(ntryL,G1H4(527),25,ex2(:),2,G2H2(324),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hotf_4pt_reduction(G2H4(56),RedSet_4(44),mass4set(:,1),  & 
G1H4(548),G1H4(179),G1H4(564),G1H4(10),G1H4(15),G0H4(82),4)
  call HG1shiftOLR(G1H4(179),2,4)
  call Hloop_DV_C(ntryL,G1H4(537),25,ex3(:),G2H2(325),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_DV_C(ntryL,G1H4(538),25,ex3(:),G2H2(326),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_DV_C(ntryL,G1H4(542),25,ex3(:),G2H2(327),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_DV_C(ntryL,G1H4(543),25,ex3(:),G2H2(328),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(44),mass4set(:,1),  & 
G1H4(26),G1H4(31),G1H4(42),G1H4(47),G1H4(58),G0H4(83),4)
  call HG1shiftOLR(G1H4(31),2,4)
  call Hloop_CV_D(ntryL,G1H4(553),25,ex3(:),4,G2H2(329),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_CV_D(ntryL,G1H4(554),25,ex3(:),4,G2H2(330),m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_CV_D(ntryL,G1H4(558),25,ex3(:),4,G2H2(331),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_CV_D(ntryL,G1H4(559),25,ex3(:),4,G2H2(332),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(44),mass4set(:,1),  & 
G1H4(63),G1H4(74),G1H4(79),G1H4(90),G1H4(95),G0H4(84),4)
  call HG1shiftOLR(G1H4(74),2,4)
  call Hloop_UV_W(ntryL,G1H4(569),25,ex3(:),4,G2H2(333),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_UV_W(ntryL,G1H4(570),25,ex3(:),4,G2H2(334),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_UV_W(ntryL,G1H4(574),25,ex3(:),4,G2H2(335),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_UV_W(ntryL,G1H4(575),25,ex3(:),4,G2H2(336),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(8),mass4set(:,1),  & 
G1H8(44),G1H8(46),G1H8(47),G1H8(48),G1H8(49),8)
  call HG1shiftOLR(G1H8(46),12,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(8),mass4set(:,1),  & 
G1H8(50),G1H8(52),G1H8(53),G1H8(54),G1H8(55),8)
  call HG1shiftOLR(G1H8(52),12,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(8),mass4set(:,1),  & 
G1H8(56),G1H8(58),G1H8(59),G1H8(60),G1H8(61),8)
  call HG1shiftOLR(G1H8(58),12,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(4),mass4set(:,1),  & 
G1H8(62),G1H8(64),G1H8(65),G1H8(66),G1H8(67),8)
  call HG1shiftOLR(G1H8(64),12,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(4),mass4set(:,1),  & 
G1H8(68),G1H8(70),G1H8(71),G1H8(72),G1H8(73),8)
  call HG1shiftOLR(G1H8(70),12,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(4),mass4set(:,1),  & 
G1H8(74),G1H8(76),G1H8(77),G1H8(78),G1H8(79),8)
  call HG1shiftOLR(G1H8(76),12,8)
  call Hloop_GGG_G_12(ntryL,G2H8(7),ex4(:),ex3(:),G2H2(337),m4h2x2x2(:,1),heltab3x8(:,:,1))
  call Hloop_GGG_G_12(ntryL,G2H8(8),ex3(:),ex4(:),G2H2(338),m4h2x2x2(:,2),heltab3x8(:,:,2))
  call Hloop_GGG_G_23(ntryL,G2H8(9),ex4(:),ex3(:),G2H2(339),m4h2x2x2(:,3),heltab3x8(:,:,3))
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(12),mass4set(:,1),  & 
G1H8(80),G1H8(82),G1H8(83),G1H8(84),G1H8(85),8)
  call HG1shiftOLR(G1H8(82),10,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(12),mass4set(:,1),  & 
G1H8(86),G1H8(88),G1H8(89),G1H8(90),G1H8(91),8)
  call HG1shiftOLR(G1H8(88),10,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(12),mass4set(:,1),  & 
G1H8(92),G1H8(94),G1H8(95),G1H8(96),G1H8(97),8)
  call HG1shiftOLR(G1H8(94),10,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(2),mass4set(:,1),  & 
G1H8(98),G1H8(100),G1H8(101),G1H8(102),G1H8(103),8)
  call HG1shiftOLR(G1H8(100),10,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(2),mass4set(:,1),  & 
G1H8(104),G1H8(106),G1H8(107),G1H8(108),G1H8(109),8)
  call HG1shiftOLR(G1H8(106),10,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(2),mass4set(:,1),  & 
G1H8(110),G1H8(112),G1H8(113),G1H8(114),G1H8(115),8)
  call HG1shiftOLR(G1H8(112),10,8)
  call Hloop_GGG_G_12(ntryL,G2H8(16),ex4(:),ex2(:),G2H2(340),m4h2x2x2(:,4),heltab3x8(:,:,4))
  call Hloop_GGG_G_12(ntryL,G2H8(17),ex2(:),ex4(:),G2H2(341),m4h2x2x2(:,5),heltab3x8(:,:,5))
  call Hloop_GGG_G_23(ntryL,G2H8(18),ex4(:),ex2(:),G2H2(342),m4h2x2x2(:,6),heltab3x8(:,:,6))
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(14),mass4set(:,1),  & 
G1H8(116),G1H8(118),G1H8(119),G1H8(120),G1H8(121),8)
  call HG1shiftOLR(G1H8(118),6,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(14),mass4set(:,1),  & 
G1H8(122),G1H8(124),G1H8(125),G1H8(126),G1H8(127),8)
  call HG1shiftOLR(G1H8(124),6,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(14),mass4set(:,1),  & 
G1H8(128),G1H8(130),G1H8(131),G1H8(132),G1H8(133),8)
  call HG1shiftOLR(G1H8(130),6,8)
  call Hloop_GGG_G_12(ntryL,G2H8(22),ex3(:),ex2(:),G2H2(343),m4h2x2x2(:,7),heltab3x8(:,:,7))
  call Hloop_GGG_G_12(ntryL,G2H8(23),ex2(:),ex3(:),G2H2(344),m4h2x2x2(:,8),heltab3x8(:,:,8))
  call Hloop_GGG_G_23(ntryL,G2H8(24),ex3(:),ex2(:),G2H2(345),m4h2x2x2(:,9),heltab3x8(:,:,9))
  call Hotf_4pt_reduction(G2H8(25),RedSet_4(10),mass4set(:,1),  & 
G1H8(134),G1H8(136),G1H8(137),G1H8(138),G1H8(139),8)
  call HG1shiftOLR(G1H8(136),9,8)
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(10),mass4set(:,1),  & 
G1H8(140),G1H8(142),G1H8(143),G1H8(144),G1H8(145),8)
  call HG1shiftOLR(G1H8(142),9,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(10),mass4set(:,1),  & 
G1H8(146),G1H8(148),G1H8(149),G1H8(150),G1H8(151),8)
  call HG1shiftOLR(G1H8(148),9,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(5),mass4set(:,1),  & 
G1H8(152),G1H8(154),G1H8(155),G1H8(156),G1H8(157),8)
  call HG1shiftOLR(G1H8(154),9,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(5),mass4set(:,1),  & 
G1H8(158),G1H8(160),G1H8(161),G1H8(162),G1H8(163),8)
  call HG1shiftOLR(G1H8(160),9,8)
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(5),mass4set(:,1),  & 
G1H8(164),G1H8(166),G1H8(167),G1H8(168),G1H8(169),8)
  call HG1shiftOLR(G1H8(166),9,8)
  call Hloop_GGG_G_12(ntryL,G2H8(31),ex4(:),ex1(:),G2H2(346),m4h2x2x2(:,10),heltab3x8(:,:,10))
  call Hloop_GGG_G_12(ntryL,G2H8(32),ex1(:),ex4(:),G2H2(347),m4h2x2x2(:,11),heltab3x8(:,:,11))
  call Hloop_GGG_G_23(ntryL,G2H8(33),ex4(:),ex1(:),G2H2(348),m4h2x2x2(:,12),heltab3x8(:,:,12))
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(11),mass4set(:,1),  & 
G1H8(170),G1H8(172),G1H8(173),G1H8(174),G1H8(175),8)
  call HG1shiftOLR(G1H8(172),5,8)
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(11),mass4set(:,1),  & 
G1H8(176),G1H8(178),G1H8(179),G1H8(180),G1H8(181),8)
  call HG1shiftOLR(G1H8(178),5,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(11),mass4set(:,1),  & 
G1H8(182),G1H8(184),G1H8(185),G1H8(186),G1H8(187),8)
  call HG1shiftOLR(G1H8(184),5,8)
  call Hloop_GGG_G_12(ntryL,G2H8(37),ex3(:),ex1(:),G2H2(349),m4h2x2x2(:,13),heltab3x8(:,:,13))
  call Hloop_GGG_G_12(ntryL,G2H8(38),ex1(:),ex3(:),G2H2(350),m4h2x2x2(:,14),heltab3x8(:,:,14))
  call Hloop_GGG_G_23(ntryL,G2H8(39),ex3(:),ex1(:),G2H2(351),m4h2x2x2(:,15),heltab3x8(:,:,15))
  call Hloop_GGG_G_12(ntryL,G2H8(40),ex2(:),ex1(:),G2H2(352),m4h2x2x2(:,16),heltab3x8(:,:,16))
  call Hloop_GGG_G_12(ntryL,G2H8(41),ex1(:),ex2(:),G2H2(353),m4h2x2x2(:,17),heltab3x8(:,:,17))
  call Hloop_GGG_G_23(ntryL,G2H8(42),ex2(:),ex1(:),G2H2(354),m4h2x2x2(:,18),heltab3x8(:,:,18))
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(1),mass4set(:,1),  & 
G1H8(188),G1H8(190),G1H8(191),G1H8(192),G1H8(193),G0H8(15),8)
  call HG1shiftOLR(G1H8(190),8,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(1),mass4set(:,1),  & 
G1H8(194),G1H8(196),G1H8(197),G1H8(198),G1H8(199),G0H8(14),8)
  call HG1shiftOLR(G1H8(196),8,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(1),mass4set(:,1),  & 
G1H8(200),G1H8(202),G1H8(203),G1H8(204),G1H8(205),G0H8(13),8)
  call HG1shiftOLR(G1H8(202),8,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(11),mass4set(:,1),  & 
G1H8(206),G1H8(208),G1H8(209),G1H8(210),G1H8(211),G0H8(24),8)
  call HG1shiftOLR(G1H8(208),5,8)
  call Hotf_4pt_reduction(G2H8(47),RedSet_4(11),mass4set(:,1),  & 
G1H8(212),G1H8(214),G1H8(215),G1H8(216),G1H8(3),G0H8(23),8)
  call HG1shiftOLR(G1H8(214),5,8)
  call Hotf_4pt_reduction(G2H8(48),RedSet_4(11),mass4set(:,1),  & 
G1H8(9),G1H8(15),G1H8(21),G1H8(27),G1H8(33),G0H8(22),8)
  call HG1shiftOLR(G1H8(15),5,8)
  call Hotf_4pt_reduction(G2H8(49),RedSet_4(3),mass4set(:,1),  & 
G1H8(39),G1H8(45),G1H8(51),G1H8(57),G1H8(63),G0H8(12),8)
  call HG1shiftOLR(G1H8(45),8,8)
  call Hotf_4pt_reduction(G2H8(50),RedSet_4(3),mass4set(:,1),  & 
G1H8(69),G1H8(75),G1H8(81),G1H8(87),G1H8(93),G0H8(11),8)
  call HG1shiftOLR(G1H8(75),8,8)
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(3),mass4set(:,1),  & 
G1H8(99),G1H8(105),G1H8(111),G1H8(117),G1H8(123),G0H8(10),8)
  call HG1shiftOLR(G1H8(105),8,8)
  call Hotf_4pt_reduction(G2H8(52),RedSet_4(14),mass4set(:,1),  & 
G1H8(147),G1H8(153),G1H8(159),G1H8(26),G1H8(28),G0H8(27),8)
  call HG1shiftOLR(G1H8(153),6,8)
  call Hotf_4pt_reduction(G2H8(53),RedSet_4(14),mass4set(:,1),  & 
G1H8(29),G1H8(17),G1H8(16),G1H8(18),G1H8(23),G0H8(26),8)
  call HG1shiftOLR(G1H8(17),6,8)
  call Hotf_4pt_reduction(G2H8(54),RedSet_4(14),mass4set(:,1),  & 
G1H8(24),G1H8(25),G1H8(20),G1H8(19),G1H8(22),G0H8(25),8)
  call HG1shiftOLR(G1H8(25),6,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(7),mass4set(:,1),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(10),G0H8(33),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_4pt_reduction(G2H8(56),RedSet_4(7),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(129),G0H8(32),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(57),RedSet_4(7),mass4set(:,1),  & 
G1H8(135),G1H8(141),G1H8(2),G1H8(1),G1H8(4),G0H8(31),8)
  call HG1shiftOLR(G1H8(141),8,8)
  call Hotf_4pt_reduction(G2H8(58),RedSet_4(10),mass4set(:,1),  & 
G1H8(165),G1H8(171),G1H8(177),G1H8(183),G1H8(189),G0H8(36),8)
  call HG1shiftOLR(G1H8(171),9,8)
  call Hotf_4pt_reduction(G2H8(59),RedSet_4(10),mass4set(:,1),  & 
G1H8(195),G1H8(201),G1H8(207),G1H8(213),G1H8(36),G0H8(35),8)
  call HG1shiftOLR(G1H8(201),9,8)
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(10),mass4set(:,1),  & 
G1H8(40),G1H8(43),G1H8(32),G1H8(30),G1H8(31),G0H8(34),8)
  call HG1shiftOLR(G1H8(43),9,8)
  call Hotf_4pt_reduction(G2H8(61),RedSet_4(5),mass4set(:,1),  & 
G1H8(34),G1H8(35),G1H8(37),G1H8(38),G1H8(41),G0H8(21),8)
  call HG1shiftOLR(G1H8(35),9,8)
  call Hotf_4pt_reduction(G2H8(62),RedSet_4(5),mass4set(:,1),  & 
G1H8(42),G1H8(217),G1H8(218),G1H8(219),G1H8(220),G0H8(20),8)
  call HG1shiftOLR(G1H8(217),9,8)
  call Hotf_4pt_reduction(G2H8(63),RedSet_4(5),mass4set(:,1),  & 
G1H8(221),G1H8(222),G1H8(223),G1H8(224),G1H8(225),G0H8(19),8)
  call HG1shiftOLR(G1H8(222),9,8)
  call Hotf_4pt_reduction(G2H8(64),RedSet_4(6),mass4set(:,1),  & 
G1H8(226),G1H8(227),G1H8(228),G1H8(229),G1H8(230),G0H8(30),8)
  call HG1shiftOLR(G1H8(227),4,8)
  call Hotf_4pt_reduction(G2H8(65),RedSet_4(6),mass4set(:,1),  & 
G1H8(231),G1H8(232),G1H8(233),G1H8(234),G1H8(235),G0H8(29),8)
  call HG1shiftOLR(G1H8(232),4,8)
  call Hotf_4pt_reduction(G2H8(66),RedSet_4(6),mass4set(:,1),  & 
G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),G0H8(28),8)
  call HG1shiftOLR(G1H8(237),4,8)
  call Hotf_4pt_reduction(G2H8(67),RedSet_4(12),mass4set(:,1),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G0H8(3),8)
  call HG1shiftOLR(G1H8(242),10,8)
  call Hotf_4pt_reduction(G2H8(68),RedSet_4(12),mass4set(:,1),  & 
G1H8(246),G1H8(247),G1H8(248),G1H8(249),G1H8(250),G0H8(2),8)
  call HG1shiftOLR(G1H8(247),10,8)
  call Hotf_4pt_reduction(G2H8(69),RedSet_4(12),mass4set(:,1),  & 
G1H8(251),G1H8(252),G1H8(253),G1H8(254),G1H8(255),G0H8(1),8)
  call HG1shiftOLR(G1H8(252),10,8)
  call Hotf_4pt_reduction(G2H8(70),RedSet_4(2),mass4set(:,1),  & 
G1H8(256),G1H8(257),G1H8(258),G1H8(259),G1H8(260),G0H8(6),8)
  call HG1shiftOLR(G1H8(257),10,8)
  call Hotf_4pt_reduction(G2H8(71),RedSet_4(2),mass4set(:,1),  & 
G1H8(261),G1H8(262),G1H8(263),G1H8(264),G1H8(265),G0H8(5),8)
  call HG1shiftOLR(G1H8(262),10,8)
  call Hotf_4pt_reduction(G2H8(72),RedSet_4(2),mass4set(:,1),  & 
G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),G0H8(4),8)
  call HG1shiftOLR(G1H8(267),10,8)
  call Hotf_4pt_reduction(G2H8(73),RedSet_4(9),mass4set(:,1),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G0H8(9),8)
  call HG1shiftOLR(G1H8(272),4,8)
  call Hotf_4pt_reduction(G2H8(74),RedSet_4(9),mass4set(:,1),  & 
G1H8(276),G1H8(277),G1H8(278),G1H8(279),G1H8(280),G0H8(8),8)
  call HG1shiftOLR(G1H8(277),4,8)
  call Hotf_4pt_reduction(G2H8(75),RedSet_4(9),mass4set(:,1),  & 
G1H8(281),G1H8(282),G1H8(283),G1H8(284),G1H8(285),G0H8(7),8)
  call HG1shiftOLR(G1H8(282),4,8)
  call Hotf_4pt_reduction(G2H8(76),RedSet_4(8),mass4set(:,1),  & 
G1H8(286),G1H8(287),G1H8(288),G1H8(289),G1H8(290),G0H8(18),8)
  call HG1shiftOLR(G1H8(287),12,8)
  call Hotf_4pt_reduction(G2H8(77),RedSet_4(8),mass4set(:,1),  & 
G1H8(291),G1H8(292),G1H8(293),G1H8(294),G1H8(295),G0H8(17),8)
  call HG1shiftOLR(G1H8(292),12,8)
  call Hotf_4pt_reduction(G2H8(78),RedSet_4(8),mass4set(:,1),  & 
G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),G0H8(16),8)
  call HG1shiftOLR(G1H8(297),12,8)
  call Hotf_4pt_reduction(G2H8(79),RedSet_4(4),mass4set(:,1),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G0H8(37),8)
  call HG1shiftOLR(G1H8(302),12,8)
  call Hotf_4pt_reduction(G2H8(80),RedSet_4(4),mass4set(:,1),  & 
G1H8(306),G1H8(307),G1H8(308),G1H8(309),G1H8(310),G0H8(38),8)
  call HG1shiftOLR(G1H8(307),12,8)
  call Hotf_4pt_reduction(G2H8(81),RedSet_4(4),mass4set(:,1),  & 
G1H8(311),G1H8(312),G1H8(313),G1H8(314),G1H8(315),G0H8(39),8)
  call HG1shiftOLR(G1H8(312),12,8)
  call Hotf_4pt_reduction(G2H8(82),RedSet_4(13),mass4set(:,1),  & 
G1H8(316),G1H8(317),G1H8(318),G1H8(319),G1H8(320),G0H8(40),8)
  call HG1shiftOLR(G1H8(317),2,8)
  call Hotf_4pt_reduction(G2H8(83),RedSet_4(13),mass4set(:,1),  & 
G1H8(321),G1H8(322),G1H8(323),G1H8(324),G1H8(325),G0H8(41),8)
  call HG1shiftOLR(G1H8(322),2,8)
  call Hotf_4pt_reduction(G2H8(84),RedSet_4(13),mass4set(:,1),  & 
G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),G0H8(42),8)
  call HG1shiftOLR(G1H8(327),2,8)
  call Hloop_DV_C(ntryL,G1H4(101),28,ex1(:),G2H2(355),m3h2x2(:,481),heltab2x4(:,:,481))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(102),-2,ex2(:),2,G2H2(356),m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_DV_C(ntryL,G1H4(118),28,ex1(:),G2H2(357),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_DV_C(ntryL,G1H4(133),28,ex1(:),G2H2(358),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_DV_C(ntryL,G0H4(1),28,ex1(:),G1H2(72),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_DV_C(ntryL,G1H4(134),21,ex2(:),G2H2(359),m3h2x2(:,486),heltab2x4(:,:,486))
call HGT_OLR(G1H4(149),1,1,4)
call HGT_invQ_OLR(G1H4(149),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(149),-8,ex4(:),8,G2H2(360),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_DV_C(ntryL,G1H4(165),21,ex2(:),G2H2(361),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_DV_C(ntryL,G1H4(166),21,ex2(:),G2H2(362),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_DV_C(ntryL,G0H4(2),21,ex2(:),G1H2(78),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_CV_D(ntryL,G1H4(181),28,ex1(:),1,G2H2(363),m3h2x2(:,491),heltab2x4(:,:,491))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(182),-2,ex2(:),G2H2(364),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_CV_D(ntryL,G1H4(198),28,ex1(:),1,G2H2(365),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_CV_D(ntryL,G1H4(213),28,ex1(:),1,G2H2(366),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_CV_D(ntryL,G0H4(3),28,ex1(:),1,G1H2(88),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_CV_D(ntryL,G1H4(214),21,ex2(:),2,G2H2(367),m3h2x2(:,496),heltab2x4(:,:,496))
call HGT_OLR(G1H4(229),1,1,4)
call HGT_invQ_OLR(G1H4(229),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(229),-8,ex4(:),G2H2(368),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_CV_D(ntryL,G1H4(245),21,ex2(:),2,G2H2(369),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_CV_D(ntryL,G1H4(246),21,ex2(:),2,G2H2(370),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_CV_D(ntryL,G0H4(4),21,ex2(:),2,G1H2(98),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_UV_W(ntryL,G1H4(261),28,ex1(:),1,G2H2(371),m3h2x2(:,501),heltab2x4(:,:,501))
call HGT_raise_alpha_OLR(G1H4(262),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(262),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(262),-2,ex2(:),2,G2H2(372),m3h2x2(:,502),heltab2x4(:,:,502))
call signflip_OLR(G2H2(372))
  call Hloop_UV_W(ntryL,G1H4(278),28,ex1(:),1,G2H2(373),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_UV_W(ntryL,G1H4(293),28,ex1(:),1,G2H2(374),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_UV_W(ntryL,G0H4(5),28,ex1(:),1,G1H2(108),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_UV_W(ntryL,G1H4(294),21,ex2(:),2,G2H2(375),m3h2x2(:,506),heltab2x4(:,:,506))
call HGT_raise_alpha_OLR(G1H4(309),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(309),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(309),-8,ex4(:),8,G2H2(376),m3h2x2(:,507),heltab2x4(:,:,507))
call signflip_OLR(G2H2(376))
  call Hloop_UV_W(ntryL,G1H4(325),21,ex2(:),2,G2H2(377),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_UV_W(ntryL,G1H4(326),21,ex2(:),2,G2H2(378),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_UV_W(ntryL,G0H4(6),21,ex2(:),2,G1H2(118),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_CV_D(ntryL,G1H4(341),26,ex1(:),1,G2H2(379),m3h2x2(:,511),heltab2x4(:,:,511))
call HGT_OLR(G1H4(342),1,1,4)
call HGT_invQ_OLR(G1H4(342),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(342),-4,ex3(:),G2H2(380),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_CV_D(ntryL,G1H4(358),26,ex1(:),1,G2H2(381),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_CV_D(ntryL,G1H4(373),26,ex1(:),1,G2H2(382),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_CV_D(ntryL,G0H4(7),26,ex1(:),1,G1H2(128),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_CV_D(ntryL,G1H4(374),19,ex3(:),4,G2H2(383),m3h2x2(:,516),heltab2x4(:,:,516))
call HGT_OLR(G1H4(389),1,1,4)
call HGT_invQ_OLR(G1H4(389),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(389),-8,ex4(:),G2H2(384),m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_CV_D(ntryL,G1H4(405),19,ex3(:),4,G2H2(385),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_CV_D(ntryL,G1H4(406),19,ex3(:),4,G2H2(386),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_CV_D(ntryL,G0H4(8),19,ex3(:),4,G1H2(138),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_DV_C(ntryL,G1H4(421),26,ex1(:),G2H2(387),m3h2x2(:,521),heltab2x4(:,:,521))
call HGT_OLR(G1H4(422),1,1,4)
call HGT_invQ_OLR(G1H4(422),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(422),-4,ex3(:),4,G2H2(388),m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_DV_C(ntryL,G1H4(438),26,ex1(:),G2H2(389),m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_DV_C(ntryL,G1H4(453),26,ex1(:),G2H2(390),m3h2x2(:,524),heltab2x4(:,:,524))
  call Hloop_DV_C(ntryL,G0H4(9),26,ex1(:),G1H2(148),m3h2x2(:,525),heltab2x4(:,:,525))
  call Hloop_DV_C(ntryL,G1H4(454),19,ex3(:),G2H2(391),m3h2x2(:,526),heltab2x4(:,:,526))
call HGT_OLR(G1H4(469),1,1,4)
call HGT_invQ_OLR(G1H4(469),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(469),-8,ex4(:),8,G2H2(392),m3h2x2(:,527),heltab2x4(:,:,527))
  call Hloop_DV_C(ntryL,G1H4(485),19,ex3(:),G2H2(393),m3h2x2(:,528),heltab2x4(:,:,528))
  call Hloop_DV_C(ntryL,G1H4(486),19,ex3(:),G2H2(394),m3h2x2(:,529),heltab2x4(:,:,529))
  call Hloop_DV_C(ntryL,G0H4(10),19,ex3(:),G1H2(158),m3h2x2(:,530),heltab2x4(:,:,530))
  call Hloop_UV_W(ntryL,G1H4(501),26,ex1(:),1,G2H2(395),m3h2x2(:,531),heltab2x4(:,:,531))
call HGT_raise_alpha_OLR(G1H4(502),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(502),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(502),-4,ex3(:),4,G2H2(396),m3h2x2(:,532),heltab2x4(:,:,532))
call signflip_OLR(G2H2(396))
  call Hloop_UV_W(ntryL,G1H4(518),26,ex1(:),1,G2H2(397),m3h2x2(:,533),heltab2x4(:,:,533))
  call Hloop_UV_W(ntryL,G1H4(533),26,ex1(:),1,G2H2(398),m3h2x2(:,534),heltab2x4(:,:,534))
  call Hloop_UV_W(ntryL,G0H4(11),26,ex1(:),1,G1H2(168),m3h2x2(:,535),heltab2x4(:,:,535))
  call Hloop_UV_W(ntryL,G1H4(534),19,ex3(:),4,G2H2(399),m3h2x2(:,536),heltab2x4(:,:,536))
call HGT_raise_alpha_OLR(G1H4(549),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(549),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(549),-8,ex4(:),8,G2H2(400),m3h2x2(:,537),heltab2x4(:,:,537))
call signflip_OLR(G2H2(400))
  call Hloop_UV_W(ntryL,G1H4(565),19,ex3(:),4,G2H2(401),m3h2x2(:,538),heltab2x4(:,:,538))
  call Hloop_UV_W(ntryL,G1H4(566),19,ex3(:),4,G2H2(402),m3h2x2(:,539),heltab2x4(:,:,539))
  call Hloop_UV_W(ntryL,G0H4(12),19,ex3(:),4,G1H2(178),m3h2x2(:,540),heltab2x4(:,:,540))
  call Hloop_CV_D(ntryL,G1H4(1),28,ex2(:),2,G2H2(403),m3h2x2(:,541),heltab2x4(:,:,541))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(2),-1,ex1(:),G2H2(404),m3h2x2(:,542),heltab2x4(:,:,542))
  call Hloop_CV_D(ntryL,G1H4(12),28,ex2(:),2,G2H2(405),m3h2x2(:,543),heltab2x4(:,:,543))
  call Hloop_CV_D(ntryL,G1H4(8),28,ex2(:),2,G2H2(406),m3h2x2(:,544),heltab2x4(:,:,544))
  call Hloop_CV_D(ntryL,G0H4(13),28,ex2(:),2,G1H2(188),m3h2x2(:,545),heltab2x4(:,:,545))
  call Hloop_CV_D(ntryL,G1H4(11),22,ex1(:),1,G2H2(407),m3h2x2(:,546),heltab2x4(:,:,546))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(13),-8,ex4(:),G2H2(408),m3h2x2(:,547),heltab2x4(:,:,547))
  call Hloop_CV_D(ntryL,G1H4(17),22,ex1(:),1,G2H2(409),m3h2x2(:,548),heltab2x4(:,:,548))
  call Hloop_CV_D(ntryL,G1H4(18),22,ex1(:),1,G2H2(410),m3h2x2(:,549),heltab2x4(:,:,549))
  call Hloop_CV_D(ntryL,G0H4(14),22,ex1(:),1,G1H2(198),m3h2x2(:,550),heltab2x4(:,:,550))
  call Hloop_DV_C(ntryL,G1H4(23),28,ex2(:),G2H2(411),m3h2x2(:,551),heltab2x4(:,:,551))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(28),-1,ex1(:),1,G2H2(412),m3h2x2(:,552),heltab2x4(:,:,552))
  call Hloop_DV_C(ntryL,G1H4(27),28,ex2(:),G2H2(413),m3h2x2(:,553),heltab2x4(:,:,553))
  call Hloop_DV_C(ntryL,G1H4(29),28,ex2(:),G2H2(414),m3h2x2(:,554),heltab2x4(:,:,554))
  call Hloop_DV_C(ntryL,G0H4(15),28,ex2(:),G1H2(208),m3h2x2(:,555),heltab2x4(:,:,555))
  call Hloop_DV_C(ntryL,G1H4(32),22,ex1(:),G2H2(415),m3h2x2(:,556),heltab2x4(:,:,556))
call HGT_OLR(G1H4(33),1,1,4)
call HGT_invQ_OLR(G1H4(33),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(33),-8,ex4(:),8,G2H2(416),m3h2x2(:,557),heltab2x4(:,:,557))
  call Hloop_DV_C(ntryL,G1H4(39),22,ex1(:),G2H2(417),m3h2x2(:,558),heltab2x4(:,:,558))
  call Hloop_DV_C(ntryL,G1H4(44),22,ex1(:),G2H2(418),m3h2x2(:,559),heltab2x4(:,:,559))
  call Hloop_DV_C(ntryL,G0H4(16),22,ex1(:),G1H2(218),m3h2x2(:,560),heltab2x4(:,:,560))
  call Hloop_UV_W(ntryL,G1H4(40),28,ex2(:),2,G2H2(419),m3h2x2(:,561),heltab2x4(:,:,561))
call HGT_raise_alpha_OLR(G1H4(43),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(43),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(43),-1,ex1(:),1,G2H2(420),m3h2x2(:,562),heltab2x4(:,:,562))
call signflip_OLR(G2H2(420))
  call Hloop_UV_W(ntryL,G1H4(48),28,ex2(:),2,G2H2(421),m3h2x2(:,563),heltab2x4(:,:,563))
  call Hloop_UV_W(ntryL,G1H4(49),28,ex2(:),2,G2H2(422),m3h2x2(:,564),heltab2x4(:,:,564))
  call Hloop_UV_W(ntryL,G0H4(17),28,ex2(:),2,G1H2(228),m3h2x2(:,565),heltab2x4(:,:,565))
  call Hloop_UV_W(ntryL,G1H4(50),22,ex1(:),1,G2H2(423),m3h2x2(:,566),heltab2x4(:,:,566))
call HGT_raise_alpha_OLR(G1H4(55),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(55),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(55),-8,ex4(:),8,G2H2(424),m3h2x2(:,567),heltab2x4(:,:,567))
call signflip_OLR(G2H2(424))
  call Hloop_UV_W(ntryL,G1H4(56),22,ex1(:),1,G2H2(425),m3h2x2(:,568),heltab2x4(:,:,568))
  call Hloop_UV_W(ntryL,G1H4(59),22,ex1(:),1,G2H2(426),m3h2x2(:,569),heltab2x4(:,:,569))
  call Hloop_UV_W(ntryL,G0H4(18),22,ex1(:),1,G1H2(238),m3h2x2(:,570),heltab2x4(:,:,570))
  call Hloop_CV_D(ntryL,G1H4(61),22,ex1(:),1,G2H2(427),m3h2x2(:,571),heltab2x4(:,:,571))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(64),-8,ex4(:),G2H2(428),m3h2x2(:,572),heltab2x4(:,:,572))
  call Hloop_CV_D(ntryL,G1H4(66),22,ex1(:),1,G2H2(429),m3h2x2(:,573),heltab2x4(:,:,573))
  call Hloop_CV_D(ntryL,G1H4(71),22,ex1(:),1,G2H2(430),m3h2x2(:,574),heltab2x4(:,:,574))
  call Hloop_CV_D(ntryL,G0H4(19),22,ex1(:),1,G1H2(248),m3h2x2(:,575),heltab2x4(:,:,575))
  call Hloop_CV_D(ntryL,G1H4(76),19,ex4(:),8,G2H2(431),m3h2x2(:,576),heltab2x4(:,:,576))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(72),-4,ex3(:),G2H2(432),m3h2x2(:,577),heltab2x4(:,:,577))
  call Hloop_CV_D(ntryL,G1H4(77),19,ex4(:),8,G2H2(433),m3h2x2(:,578),heltab2x4(:,:,578))
  call Hloop_CV_D(ntryL,G1H4(80),19,ex4(:),8,G2H2(434),m3h2x2(:,579),heltab2x4(:,:,579))
  call Hloop_CV_D(ntryL,G0H4(20),19,ex4(:),8,G1H2(258),m3h2x2(:,580),heltab2x4(:,:,580))
  call Hloop_DV_C(ntryL,G1H4(81),22,ex1(:),G2H2(435),m3h2x2(:,581),heltab2x4(:,:,581))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(82),-8,ex4(:),8,G2H2(436),m3h2x2(:,582),heltab2x4(:,:,582))
  call Hloop_DV_C(ntryL,G1H4(92),22,ex1(:),G2H2(437),m3h2x2(:,583),heltab2x4(:,:,583))
  call Hloop_DV_C(ntryL,G1H4(88),22,ex1(:),G2H2(438),m3h2x2(:,584),heltab2x4(:,:,584))
  call Hloop_DV_C(ntryL,G0H4(21),22,ex1(:),G1H2(268),m3h2x2(:,585),heltab2x4(:,:,585))
  call Hloop_DV_C(ntryL,G1H4(91),19,ex4(:),G2H2(439),m3h2x2(:,586),heltab2x4(:,:,586))
call HGT_OLR(G1H4(93),1,1,4)
call HGT_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(93),-4,ex3(:),4,G2H2(440),m3h2x2(:,587),heltab2x4(:,:,587))
  call Hloop_DV_C(ntryL,G1H4(97),19,ex4(:),G2H2(441),m3h2x2(:,588),heltab2x4(:,:,588))
  call Hloop_DV_C(ntryL,G1H4(98),19,ex4(:),G2H2(442),m3h2x2(:,589),heltab2x4(:,:,589))
  call Hloop_DV_C(ntryL,G0H4(22),19,ex4(:),G1H2(278),m3h2x2(:,590),heltab2x4(:,:,590))
  call Hloop_UV_W(ntryL,G1H4(103),22,ex1(:),1,G2H2(443),m3h2x2(:,591),heltab2x4(:,:,591))
call HGT_raise_alpha_OLR(G1H4(108),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(108),-8,ex4(:),8,G2H2(444),m3h2x2(:,592),heltab2x4(:,:,592))
call signflip_OLR(G2H2(444))
  call Hloop_UV_W(ntryL,G1H4(107),22,ex1(:),1,G2H2(445),m3h2x2(:,593),heltab2x4(:,:,593))
  call Hloop_UV_W(ntryL,G1H4(109),22,ex1(:),1,G2H2(446),m3h2x2(:,594),heltab2x4(:,:,594))
  call Hloop_UV_W(ntryL,G0H4(23),22,ex1(:),1,G1H2(288),m3h2x2(:,595),heltab2x4(:,:,595))
  call Hloop_UV_W(ntryL,G1H4(112),19,ex4(:),8,G2H2(447),m3h2x2(:,596),heltab2x4(:,:,596))
call HGT_raise_alpha_OLR(G1H4(113),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(113),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(113),-4,ex3(:),4,G2H2(448),m3h2x2(:,597),heltab2x4(:,:,597))
call signflip_OLR(G2H2(448))
  call Hloop_UV_W(ntryL,G1H4(119),19,ex4(:),8,G2H2(449),m3h2x2(:,598),heltab2x4(:,:,598))
  call Hloop_UV_W(ntryL,G1H4(124),19,ex4(:),8,G2H2(450),m3h2x2(:,599),heltab2x4(:,:,599))
  call Hloop_UV_W(ntryL,G0H4(24),19,ex4(:),8,G1H2(298),m3h2x2(:,600),heltab2x4(:,:,600))
  call Hloop_DV_C(ntryL,G1H4(120),25,ex2(:),G2H2(451),m3h2x2(:,601),heltab2x4(:,:,601))
call HGT_OLR(G1H4(123),1,1,4)
call HGT_invQ_OLR(G1H4(123),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(123),-4,ex3(:),4,G2H2(452),m3h2x2(:,602),heltab2x4(:,:,602))
  call Hloop_DV_C(ntryL,G1H4(128),25,ex2(:),G2H2(453),m3h2x2(:,603),heltab2x4(:,:,603))
  call Hloop_DV_C(ntryL,G1H4(129),25,ex2(:),G2H2(454),m3h2x2(:,604),heltab2x4(:,:,604))
  call Hloop_DV_C(ntryL,G0H4(25),25,ex2(:),G1H2(308),m3h2x2(:,605),heltab2x4(:,:,605))
  call Hloop_CV_D(ntryL,G1H4(130),25,ex2(:),2,G2H2(455),m3h2x2(:,606),heltab2x4(:,:,606))
call HGT_OLR(G1H4(135),1,1,4)
call HGT_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(135),-4,ex3(:),G2H2(456),m3h2x2(:,607),heltab2x4(:,:,607))
  call Hloop_CV_D(ntryL,G1H4(136),25,ex2(:),2,G2H2(457),m3h2x2(:,608),heltab2x4(:,:,608))
  call Hloop_CV_D(ntryL,G1H4(139),25,ex2(:),2,G2H2(458),m3h2x2(:,609),heltab2x4(:,:,609))
  call Hloop_CV_D(ntryL,G0H4(26),25,ex2(:),2,G1H2(318),m3h2x2(:,610),heltab2x4(:,:,610))
  call Hloop_UV_W(ntryL,G1H4(141),25,ex2(:),2,G2H2(459),m3h2x2(:,611),heltab2x4(:,:,611))
call HGT_raise_alpha_OLR(G1H4(144),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(144),-4,ex3(:),4,G2H2(460),m3h2x2(:,612),heltab2x4(:,:,612))
call signflip_OLR(G2H2(460))
  call Hloop_UV_W(ntryL,G1H4(146),25,ex2(:),2,G2H2(461),m3h2x2(:,613),heltab2x4(:,:,613))
  call Hloop_UV_W(ntryL,G1H4(151),25,ex2(:),2,G2H2(462),m3h2x2(:,614),heltab2x4(:,:,614))
  call Hloop_UV_W(ntryL,G0H4(27),25,ex2(:),2,G1H2(328),m3h2x2(:,615),heltab2x4(:,:,615))
  call Hloop_DV_C(ntryL,G1H4(156),21,ex2(:),G2H2(463),m3h2x2(:,616),heltab2x4(:,:,616))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(152),-8,ex4(:),8,G2H2(464),m3h2x2(:,617),heltab2x4(:,:,617))
  call Hloop_DV_C(ntryL,G1H4(157),21,ex2(:),G2H2(465),m3h2x2(:,618),heltab2x4(:,:,618))
  call Hloop_DV_C(ntryL,G1H4(160),21,ex2(:),G2H2(466),m3h2x2(:,619),heltab2x4(:,:,619))
  call Hloop_DV_C(ntryL,G0H4(28),21,ex2(:),G1H2(338),m3h2x2(:,620),heltab2x4(:,:,620))
  call Hloop_CV_D(ntryL,G1H4(161),21,ex2(:),2,G2H2(467),m3h2x2(:,621),heltab2x4(:,:,621))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(162),-8,ex4(:),G2H2(468),m3h2x2(:,622),heltab2x4(:,:,622))
  call Hloop_CV_D(ntryL,G1H4(172),21,ex2(:),2,G2H2(469),m3h2x2(:,623),heltab2x4(:,:,623))
  call Hloop_CV_D(ntryL,G1H4(168),21,ex2(:),2,G2H2(470),m3h2x2(:,624),heltab2x4(:,:,624))
  call Hloop_CV_D(ntryL,G0H4(29),21,ex2(:),2,G1H2(348),m3h2x2(:,625),heltab2x4(:,:,625))
  call Hloop_UV_W(ntryL,G1H4(171),21,ex2(:),2,G2H2(471),m3h2x2(:,626),heltab2x4(:,:,626))
call HGT_raise_alpha_OLR(G1H4(173),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(173),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(173),-8,ex4(:),8,G2H2(472),m3h2x2(:,627),heltab2x4(:,:,627))
call signflip_OLR(G2H2(472))
  call Hloop_UV_W(ntryL,G1H4(177),21,ex2(:),2,G2H2(473),m3h2x2(:,628),heltab2x4(:,:,628))
  call Hloop_UV_W(ntryL,G1H4(178),21,ex2(:),2,G2H2(474),m3h2x2(:,629),heltab2x4(:,:,629))
  call Hloop_UV_W(ntryL,G0H4(30),21,ex2(:),2,G1H2(358),m3h2x2(:,630),heltab2x4(:,:,630))
  call Hloop_CV_D(ntryL,G1H4(183),26,ex3(:),4,G2H2(475),m3h2x2(:,631),heltab2x4(:,:,631))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(188),-1,ex1(:),G2H2(476),m3h2x2(:,632),heltab2x4(:,:,632))
  call Hloop_CV_D(ntryL,G1H4(187),26,ex3(:),4,G2H2(477),m3h2x2(:,633),heltab2x4(:,:,633))
  call Hloop_CV_D(ntryL,G1H4(189),26,ex3(:),4,G2H2(478),m3h2x2(:,634),heltab2x4(:,:,634))
  call Hloop_CV_D(ntryL,G0H4(31),26,ex3(:),4,G1H2(368),m3h2x2(:,635),heltab2x4(:,:,635))
  call Hloop_DV_C(ntryL,G1H4(192),26,ex3(:),G2H2(479),m3h2x2(:,636),heltab2x4(:,:,636))
call HGT_OLR(G1H4(193),1,1,4)
call HGT_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(193),-1,ex1(:),1,G2H2(480),m3h2x2(:,637),heltab2x4(:,:,637))
  call Hloop_DV_C(ntryL,G1H4(199),26,ex3(:),G2H2(481),m3h2x2(:,638),heltab2x4(:,:,638))
  call Hloop_DV_C(ntryL,G1H4(204),26,ex3(:),G2H2(482),m3h2x2(:,639),heltab2x4(:,:,639))
  call Hloop_DV_C(ntryL,G0H4(32),26,ex3(:),G1H2(378),m3h2x2(:,640),heltab2x4(:,:,640))
  call Hloop_UV_W(ntryL,G1H4(200),26,ex3(:),4,G2H2(483),m3h2x2(:,641),heltab2x4(:,:,641))
call HGT_raise_alpha_OLR(G1H4(203),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(203),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(203),-1,ex1(:),1,G2H2(484),m3h2x2(:,642),heltab2x4(:,:,642))
call signflip_OLR(G2H2(484))
  call Hloop_UV_W(ntryL,G1H4(208),26,ex3(:),4,G2H2(485),m3h2x2(:,643),heltab2x4(:,:,643))
  call Hloop_UV_W(ntryL,G1H4(209),26,ex3(:),4,G2H2(486),m3h2x2(:,644),heltab2x4(:,:,644))
  call Hloop_UV_W(ntryL,G0H4(33),26,ex3(:),4,G1H2(388),m3h2x2(:,645),heltab2x4(:,:,645))
  call Hloop_DV_C(ntryL,G1H4(210),22,ex4(:),G2H2(487),m3h2x2(:,646),heltab2x4(:,:,646))
call HGT_OLR(G1H4(215),1,1,4)
call HGT_invQ_OLR(G1H4(215),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(215),-1,ex1(:),1,G2H2(488),m3h2x2(:,647),heltab2x4(:,:,647))
  call Hloop_DV_C(ntryL,G1H4(216),22,ex4(:),G2H2(489),m3h2x2(:,648),heltab2x4(:,:,648))
  call Hloop_DV_C(ntryL,G1H4(219),22,ex4(:),G2H2(490),m3h2x2(:,649),heltab2x4(:,:,649))
  call Hloop_DV_C(ntryL,G0H4(34),22,ex4(:),G1H2(398),m3h2x2(:,650),heltab2x4(:,:,650))
  call Hloop_DV_C(ntryL,G1H4(221),26,ex1(:),G2H2(491),m3h2x2(:,651),heltab2x4(:,:,651))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(224),-4,ex3(:),4,G2H2(492),m3h2x2(:,652),heltab2x4(:,:,652))
  call Hloop_DV_C(ntryL,G1H4(226),26,ex1(:),G2H2(493),m3h2x2(:,653),heltab2x4(:,:,653))
  call Hloop_DV_C(ntryL,G1H4(231),26,ex1(:),G2H2(494),m3h2x2(:,654),heltab2x4(:,:,654))
  call Hloop_DV_C(ntryL,G0H4(35),26,ex1(:),G1H2(408),m3h2x2(:,655),heltab2x4(:,:,655))
  call Hloop_CV_D(ntryL,G1H4(236),22,ex4(:),8,G2H2(495),m3h2x2(:,656),heltab2x4(:,:,656))
call HGT_OLR(G1H4(232),1,1,4)
call HGT_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(232),-1,ex1(:),G2H2(496),m3h2x2(:,657),heltab2x4(:,:,657))
  call Hloop_CV_D(ntryL,G1H4(237),22,ex4(:),8,G2H2(497),m3h2x2(:,658),heltab2x4(:,:,658))
  call Hloop_CV_D(ntryL,G1H4(240),22,ex4(:),8,G2H2(498),m3h2x2(:,659),heltab2x4(:,:,659))
  call Hloop_CV_D(ntryL,G0H4(36),22,ex4(:),8,G1H2(418),m3h2x2(:,660),heltab2x4(:,:,660))
  call Hloop_CV_D(ntryL,G1H4(241),26,ex1(:),1,G2H2(499),m3h2x2(:,661),heltab2x4(:,:,661))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(242),-4,ex3(:),G2H2(500),m3h2x2(:,662),heltab2x4(:,:,662))
  call Hloop_CV_D(ntryL,G1H4(252),26,ex1(:),1,G2H2(501),m3h2x2(:,663),heltab2x4(:,:,663))
  call Hloop_CV_D(ntryL,G1H4(248),26,ex1(:),1,G2H2(502),m3h2x2(:,664),heltab2x4(:,:,664))
  call Hloop_CV_D(ntryL,G0H4(37),26,ex1(:),1,G1H2(428),m3h2x2(:,665),heltab2x4(:,:,665))
  call Hloop_UV_W(ntryL,G1H4(251),22,ex4(:),8,G2H2(503),m3h2x2(:,666),heltab2x4(:,:,666))
call HGT_raise_alpha_OLR(G1H4(253),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(253),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(253),-1,ex1(:),1,G2H2(504),m3h2x2(:,667),heltab2x4(:,:,667))
call signflip_OLR(G2H2(504))
  call Hloop_UV_W(ntryL,G1H4(257),22,ex4(:),8,G2H2(505),m3h2x2(:,668),heltab2x4(:,:,668))
  call Hloop_UV_W(ntryL,G1H4(258),22,ex4(:),8,G2H2(506),m3h2x2(:,669),heltab2x4(:,:,669))
  call Hloop_UV_W(ntryL,G0H4(38),22,ex4(:),8,G1H2(73),m3h2x2(:,670),heltab2x4(:,:,670))
  call Hloop_UV_W(ntryL,G1H4(263),26,ex1(:),1,G2H2(507),m3h2x2(:,671),heltab2x4(:,:,671))
call HGT_raise_alpha_OLR(G1H4(268),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(268),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(268),-4,ex3(:),4,G2H2(508),m3h2x2(:,672),heltab2x4(:,:,672))
call signflip_OLR(G2H2(508))
  call Hloop_UV_W(ntryL,G1H4(267),26,ex1(:),1,G2H2(509),m3h2x2(:,673),heltab2x4(:,:,673))
  call Hloop_UV_W(ntryL,G1H4(269),26,ex1(:),1,G2H2(510),m3h2x2(:,674),heltab2x4(:,:,674))
  call Hloop_UV_W(ntryL,G0H4(39),26,ex1(:),1,G1H2(74),m3h2x2(:,675),heltab2x4(:,:,675))
  call Hloop_DV_C(ntryL,G1H4(272),25,ex3(:),G2H2(511),m3h2x2(:,676),heltab2x4(:,:,676))
call HGT_OLR(G1H4(273),1,1,4)
call HGT_invQ_OLR(G1H4(273),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(273),-2,ex2(:),2,G2H2(512),m3h2x2(:,677),heltab2x4(:,:,677))
  call Hloop_DV_C(ntryL,G1H4(279),25,ex3(:),G2H2(513),m3h2x2(:,678),heltab2x4(:,:,678))
  call Hloop_DV_C(ntryL,G1H4(284),25,ex3(:),G2H2(514),m3h2x2(:,679),heltab2x4(:,:,679))
  call Hloop_DV_C(ntryL,G0H4(40),25,ex3(:),G1H2(79),m3h2x2(:,680),heltab2x4(:,:,680))
  call Hloop_CV_D(ntryL,G1H4(280),25,ex3(:),4,G2H2(515),m3h2x2(:,681),heltab2x4(:,:,681))
call HGT_OLR(G1H4(283),1,1,4)
call HGT_invQ_OLR(G1H4(283),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(283),-2,ex2(:),G2H2(516),m3h2x2(:,682),heltab2x4(:,:,682))
  call Hloop_CV_D(ntryL,G1H4(288),25,ex3(:),4,G2H2(517),m3h2x2(:,683),heltab2x4(:,:,683))
  call Hloop_CV_D(ntryL,G1H4(289),25,ex3(:),4,G2H2(518),m3h2x2(:,684),heltab2x4(:,:,684))
  call Hloop_CV_D(ntryL,G0H4(41),25,ex3(:),4,G1H2(80),m3h2x2(:,685),heltab2x4(:,:,685))
  call Hloop_UV_W(ntryL,G1H4(290),25,ex3(:),4,G2H2(519),m3h2x2(:,686),heltab2x4(:,:,686))
call HGT_raise_alpha_OLR(G1H4(295),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(295),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(295),-2,ex2(:),2,G2H2(520),m3h2x2(:,687),heltab2x4(:,:,687))
call signflip_OLR(G2H2(520))
  call Hloop_UV_W(ntryL,G1H4(296),25,ex3(:),4,G2H2(521),m3h2x2(:,688),heltab2x4(:,:,688))
  call Hloop_UV_W(ntryL,G1H4(299),25,ex3(:),4,G2H2(522),m3h2x2(:,689),heltab2x4(:,:,689))
  call Hloop_UV_W(ntryL,G0H4(42),25,ex3(:),4,G1H2(2),m3h2x2(:,690),heltab2x4(:,:,690))
  call Hloop_DV_C(ntryL,G1H4(301),19,ex3(:),G2H2(523),m3h2x2(:,691),heltab2x4(:,:,691))
call HGT_OLR(G1H4(304),1,1,4)
call HGT_invQ_OLR(G1H4(304),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(304),-8,ex4(:),8,G2H2(524),m3h2x2(:,692),heltab2x4(:,:,692))
  call Hloop_DV_C(ntryL,G1H4(306),19,ex3(:),G2H2(525),m3h2x2(:,693),heltab2x4(:,:,693))
  call Hloop_DV_C(ntryL,G1H4(311),19,ex3(:),G2H2(526),m3h2x2(:,694),heltab2x4(:,:,694))
  call Hloop_DV_C(ntryL,G0H4(43),19,ex3(:),G1H2(84),m3h2x2(:,695),heltab2x4(:,:,695))
  call Hloop_DV_C(ntryL,G1H4(316),21,ex4(:),G2H2(527),m3h2x2(:,696),heltab2x4(:,:,696))
call HGT_OLR(G1H4(312),1,1,4)
call HGT_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(312),-2,ex2(:),2,G2H2(528),m3h2x2(:,697),heltab2x4(:,:,697))
  call Hloop_DV_C(ntryL,G1H4(317),21,ex4(:),G2H2(529),m3h2x2(:,698),heltab2x4(:,:,698))
  call Hloop_DV_C(ntryL,G1H4(320),21,ex4(:),G2H2(530),m3h2x2(:,699),heltab2x4(:,:,699))
  call Hloop_DV_C(ntryL,G0H4(44),21,ex4(:),G1H2(89),m3h2x2(:,700),heltab2x4(:,:,700))
  call Hloop_CV_D(ntryL,G1H4(321),19,ex3(:),4,G2H2(531),m3h2x2(:,701),heltab2x4(:,:,701))
call HGT_OLR(G1H4(322),1,1,4)
call HGT_invQ_OLR(G1H4(322),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(322),-8,ex4(:),G2H2(532),m3h2x2(:,702),heltab2x4(:,:,702))
  call Hloop_CV_D(ntryL,G1H4(332),19,ex3(:),4,G2H2(533),m3h2x2(:,703),heltab2x4(:,:,703))
  call Hloop_CV_D(ntryL,G1H4(328),19,ex3(:),4,G2H2(534),m3h2x2(:,704),heltab2x4(:,:,704))
  call Hloop_CV_D(ntryL,G0H4(45),19,ex3(:),4,G1H2(90),m3h2x2(:,705),heltab2x4(:,:,705))
  call Hloop_CV_D(ntryL,G1H4(331),21,ex4(:),8,G2H2(535),m3h2x2(:,706),heltab2x4(:,:,706))
call HGT_OLR(G1H4(333),1,1,4)
call HGT_invQ_OLR(G1H4(333),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(333),-2,ex2(:),G2H2(536),m3h2x2(:,707),heltab2x4(:,:,707))
  call Hloop_CV_D(ntryL,G1H4(337),21,ex4(:),8,G2H2(537),m3h2x2(:,708),heltab2x4(:,:,708))
  call Hloop_CV_D(ntryL,G1H4(338),21,ex4(:),8,G2H2(538),m3h2x2(:,709),heltab2x4(:,:,709))
  call Hloop_CV_D(ntryL,G0H4(46),21,ex4(:),8,G1H2(4),m3h2x2(:,710),heltab2x4(:,:,710))
  call Hloop_UV_W(ntryL,G1H4(343),19,ex3(:),4,G2H2(539),m3h2x2(:,711),heltab2x4(:,:,711))
call HGT_raise_alpha_OLR(G1H4(348),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(348),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(348),-8,ex4(:),8,G2H2(540),m3h2x2(:,712),heltab2x4(:,:,712))
call signflip_OLR(G2H2(540))
  call Hloop_UV_W(ntryL,G1H4(347),19,ex3(:),4,G2H2(541),m3h2x2(:,713),heltab2x4(:,:,713))
  call Hloop_UV_W(ntryL,G1H4(349),19,ex3(:),4,G2H2(542),m3h2x2(:,714),heltab2x4(:,:,714))
  call Hloop_UV_W(ntryL,G0H4(47),19,ex3(:),4,G1H2(94),m3h2x2(:,715),heltab2x4(:,:,715))
  call Hloop_UV_W(ntryL,G1H4(352),21,ex4(:),8,G2H2(543),m3h2x2(:,716),heltab2x4(:,:,716))
call HGT_raise_alpha_OLR(G1H4(353),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(353),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(353),-2,ex2(:),2,G2H2(544),m3h2x2(:,717),heltab2x4(:,:,717))
call signflip_OLR(G2H2(544))
  call Hloop_UV_W(ntryL,G1H4(359),21,ex4(:),8,G2H2(545),m3h2x2(:,718),heltab2x4(:,:,718))
  call Hloop_UV_W(ntryL,G1H4(364),21,ex4(:),8,G2H2(546),m3h2x2(:,719),heltab2x4(:,:,719))
  call Hloop_UV_W(ntryL,G0H4(48),21,ex4(:),8,G1H2(99),m3h2x2(:,720),heltab2x4(:,:,720))
  call Hloop_DV_C(ntryL,G1H4(360),21,ex4(:),G2H2(547),m3h2x2(:,721),heltab2x4(:,:,721))
call HGT_OLR(G1H4(363),1,1,4)
call HGT_invQ_OLR(G1H4(363),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(363),-2,ex2(:),2,G2H2(548),m3h2x2(:,722),heltab2x4(:,:,722))
  call Hloop_DV_C(ntryL,G1H4(368),21,ex4(:),G2H2(549),m3h2x2(:,723),heltab2x4(:,:,723))
  call Hloop_DV_C(ntryL,G1H4(369),21,ex4(:),G2H2(550),m3h2x2(:,724),heltab2x4(:,:,724))
  call Hloop_DV_C(ntryL,G0H4(49),21,ex4(:),G1H2(100),m3h2x2(:,725),heltab2x4(:,:,725))
  call Hloop_DV_C(ntryL,G1H4(370),25,ex2(:),G2H2(551),m3h2x2(:,726),heltab2x4(:,:,726))
call HGT_OLR(G1H4(375),1,1,4)
call HGT_invQ_OLR(G1H4(375),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(375),-4,ex3(:),4,G2H2(552),m3h2x2(:,727),heltab2x4(:,:,727))
  call Hloop_DV_C(ntryL,G1H4(376),25,ex2(:),G2H2(553),m3h2x2(:,728),heltab2x4(:,:,728))
  call Hloop_DV_C(ntryL,G1H4(379),25,ex2(:),G2H2(554),m3h2x2(:,729),heltab2x4(:,:,729))
  call Hloop_DV_C(ntryL,G0H4(50),25,ex2(:),G1H2(6),m3h2x2(:,730),heltab2x4(:,:,730))
  call Hloop_CV_D(ntryL,G1H4(381),21,ex4(:),8,G2H2(555),m3h2x2(:,731),heltab2x4(:,:,731))
call HGT_OLR(G1H4(384),1,1,4)
call HGT_invQ_OLR(G1H4(384),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(384),-2,ex2(:),G2H2(556),m3h2x2(:,732),heltab2x4(:,:,732))
  call Hloop_CV_D(ntryL,G1H4(386),21,ex4(:),8,G2H2(557),m3h2x2(:,733),heltab2x4(:,:,733))
  call Hloop_CV_D(ntryL,G1H4(391),21,ex4(:),8,G2H2(558),m3h2x2(:,734),heltab2x4(:,:,734))
  call Hloop_CV_D(ntryL,G0H4(51),21,ex4(:),8,G1H2(104),m3h2x2(:,735),heltab2x4(:,:,735))
  call Hloop_CV_D(ntryL,G1H4(396),25,ex2(:),2,G2H2(559),m3h2x2(:,736),heltab2x4(:,:,736))
call HGT_OLR(G1H4(392),1,1,4)
call HGT_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(392),-4,ex3(:),G2H2(560),m3h2x2(:,737),heltab2x4(:,:,737))
  call Hloop_CV_D(ntryL,G1H4(397),25,ex2(:),2,G2H2(561),m3h2x2(:,738),heltab2x4(:,:,738))
  call Hloop_CV_D(ntryL,G1H4(400),25,ex2(:),2,G2H2(562),m3h2x2(:,739),heltab2x4(:,:,739))
  call Hloop_CV_D(ntryL,G0H4(52),25,ex2(:),2,G1H2(109),m3h2x2(:,740),heltab2x4(:,:,740))
  call Hloop_UV_W(ntryL,G1H4(401),21,ex4(:),8,G2H2(563),m3h2x2(:,741),heltab2x4(:,:,741))
call HGT_raise_alpha_OLR(G1H4(402),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(402),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(402),-2,ex2(:),2,G2H2(564),m3h2x2(:,742),heltab2x4(:,:,742))
call signflip_OLR(G2H2(564))
  call Hloop_UV_W(ntryL,G1H4(412),21,ex4(:),8,G2H2(565),m3h2x2(:,743),heltab2x4(:,:,743))
  call Hloop_UV_W(ntryL,G1H4(408),21,ex4(:),8,G2H2(566),m3h2x2(:,744),heltab2x4(:,:,744))
  call Hloop_UV_W(ntryL,G0H4(53),21,ex4(:),8,G1H2(110),m3h2x2(:,745),heltab2x4(:,:,745))
  call Hloop_UV_W(ntryL,G1H4(411),25,ex2(:),2,G2H2(567),m3h2x2(:,746),heltab2x4(:,:,746))
call HGT_raise_alpha_OLR(G1H4(413),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(413),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(413),-4,ex3(:),4,G2H2(568),m3h2x2(:,747),heltab2x4(:,:,747))
call signflip_OLR(G2H2(568))
  call Hloop_UV_W(ntryL,G1H4(417),25,ex2(:),2,G2H2(569),m3h2x2(:,748),heltab2x4(:,:,748))
  call Hloop_UV_W(ntryL,G1H4(418),25,ex2(:),2,G2H2(570),m3h2x2(:,749),heltab2x4(:,:,749))
  call Hloop_UV_W(ntryL,G0H4(54),25,ex2(:),2,G1H2(8),m3h2x2(:,750),heltab2x4(:,:,750))
  call Hloop_DV_C(ntryL,G1H4(423),19,ex4(:),G2H2(571),m3h2x2(:,751),heltab2x4(:,:,751))
call HGT_OLR(G1H4(428),1,1,4)
call HGT_invQ_OLR(G1H4(428),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(428),-4,ex3(:),4,G2H2(572),m3h2x2(:,752),heltab2x4(:,:,752))
  call Hloop_DV_C(ntryL,G1H4(427),19,ex4(:),G2H2(573),m3h2x2(:,753),heltab2x4(:,:,753))
  call Hloop_DV_C(ntryL,G1H4(429),19,ex4(:),G2H2(574),m3h2x2(:,754),heltab2x4(:,:,754))
  call Hloop_DV_C(ntryL,G0H4(55),19,ex4(:),G1H2(114),m3h2x2(:,755),heltab2x4(:,:,755))
  call Hloop_DV_C(ntryL,G1H4(432),25,ex3(:),G2H2(575),m3h2x2(:,756),heltab2x4(:,:,756))
call HGT_OLR(G1H4(433),1,1,4)
call HGT_invQ_OLR(G1H4(433),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(433),-2,ex2(:),2,G2H2(576),m3h2x2(:,757),heltab2x4(:,:,757))
  call Hloop_DV_C(ntryL,G1H4(439),25,ex3(:),G2H2(577),m3h2x2(:,758),heltab2x4(:,:,758))
  call Hloop_DV_C(ntryL,G1H4(444),25,ex3(:),G2H2(578),m3h2x2(:,759),heltab2x4(:,:,759))
  call Hloop_DV_C(ntryL,G0H4(56),25,ex3(:),G1H2(119),m3h2x2(:,760),heltab2x4(:,:,760))
  call Hloop_CV_D(ntryL,G1H4(440),19,ex4(:),8,G2H2(579),m3h2x2(:,761),heltab2x4(:,:,761))
call HGT_OLR(G1H4(443),1,1,4)
call HGT_invQ_OLR(G1H4(443),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(443),-4,ex3(:),G2H2(580),m3h2x2(:,762),heltab2x4(:,:,762))
  call Hloop_CV_D(ntryL,G1H4(448),19,ex4(:),8,G2H2(581),m3h2x2(:,763),heltab2x4(:,:,763))
  call Hloop_CV_D(ntryL,G1H4(449),19,ex4(:),8,G2H2(582),m3h2x2(:,764),heltab2x4(:,:,764))
  call Hloop_CV_D(ntryL,G0H4(57),19,ex4(:),8,G1H2(120),m3h2x2(:,765),heltab2x4(:,:,765))
  call Hloop_CV_D(ntryL,G1H4(450),25,ex3(:),4,G2H2(583),m3h2x2(:,766),heltab2x4(:,:,766))
call HGT_OLR(G1H4(455),1,1,4)
call HGT_invQ_OLR(G1H4(455),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(455),-2,ex2(:),G2H2(584),m3h2x2(:,767),heltab2x4(:,:,767))
  call Hloop_CV_D(ntryL,G1H4(456),25,ex3(:),4,G2H2(585),m3h2x2(:,768),heltab2x4(:,:,768))
  call Hloop_CV_D(ntryL,G1H4(459),25,ex3(:),4,G2H2(586),m3h2x2(:,769),heltab2x4(:,:,769))
  call Hloop_CV_D(ntryL,G0H4(58),25,ex3(:),4,G1H2(10),m3h2x2(:,770),heltab2x4(:,:,770))
  call Hloop_UV_W(ntryL,G1H4(461),19,ex4(:),8,G2H2(587),m3h2x2(:,771),heltab2x4(:,:,771))
call HGT_raise_alpha_OLR(G1H4(464),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(464),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(464),-4,ex3(:),4,G2H2(588),m3h2x2(:,772),heltab2x4(:,:,772))
call signflip_OLR(G2H2(588))
  call Hloop_UV_W(ntryL,G1H4(466),19,ex4(:),8,G2H2(589),m3h2x2(:,773),heltab2x4(:,:,773))
  call Hloop_UV_W(ntryL,G1H4(471),19,ex4(:),8,G2H2(590),m3h2x2(:,774),heltab2x4(:,:,774))
  call Hloop_UV_W(ntryL,G0H4(59),19,ex4(:),8,G1H2(124),m3h2x2(:,775),heltab2x4(:,:,775))
  call Hloop_UV_W(ntryL,G1H4(476),25,ex3(:),4,G2H2(591),m3h2x2(:,776),heltab2x4(:,:,776))
call HGT_raise_alpha_OLR(G1H4(472),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(472),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(472),-2,ex2(:),2,G2H2(592),m3h2x2(:,777),heltab2x4(:,:,777))
call signflip_OLR(G2H2(592))
  call Hloop_UV_W(ntryL,G1H4(477),25,ex3(:),4,G2H2(593),m3h2x2(:,778),heltab2x4(:,:,778))
  call Hloop_UV_W(ntryL,G1H4(480),25,ex3(:),4,G2H2(594),m3h2x2(:,779),heltab2x4(:,:,779))
  call Hloop_UV_W(ntryL,G0H4(60),25,ex3(:),4,G1H2(129),m3h2x2(:,780),heltab2x4(:,:,780))
  call Hloop_DV_C(ntryL,G1H4(481),19,ex3(:),G2H2(595),m3h2x2(:,781),heltab2x4(:,:,781))
call HGT_OLR(G1H4(482),1,1,4)
call HGT_invQ_OLR(G1H4(482),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(482),-8,ex4(:),8,G2H2(596),m3h2x2(:,782),heltab2x4(:,:,782))
  call Hloop_DV_C(ntryL,G1H4(492),19,ex3(:),G2H2(597),m3h2x2(:,783),heltab2x4(:,:,783))
  call Hloop_DV_C(ntryL,G1H4(488),19,ex3(:),G2H2(598),m3h2x2(:,784),heltab2x4(:,:,784))
  call Hloop_DV_C(ntryL,G0H4(61),19,ex3(:),G1H2(130),m3h2x2(:,785),heltab2x4(:,:,785))
  call Hloop_CV_D(ntryL,G1H4(491),19,ex3(:),4,G2H2(599),m3h2x2(:,786),heltab2x4(:,:,786))
call HGT_OLR(G1H4(493),1,1,4)
call HGT_invQ_OLR(G1H4(493),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(493),-8,ex4(:),G2H2(600),m3h2x2(:,787),heltab2x4(:,:,787))
  call Hloop_CV_D(ntryL,G1H4(497),19,ex3(:),4,G2H2(601),m3h2x2(:,788),heltab2x4(:,:,788))
  call Hloop_CV_D(ntryL,G1H4(498),19,ex3(:),4,G2H2(602),m3h2x2(:,789),heltab2x4(:,:,789))
  call Hloop_CV_D(ntryL,G0H4(62),19,ex3(:),4,G1H2(12),m3h2x2(:,790),heltab2x4(:,:,790))
  call Hloop_UV_W(ntryL,G1H4(503),19,ex3(:),4,G2H2(603),m3h2x2(:,791),heltab2x4(:,:,791))
call HGT_raise_alpha_OLR(G1H4(508),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(508),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(508),-8,ex4(:),8,G2H2(604),m3h2x2(:,792),heltab2x4(:,:,792))
call signflip_OLR(G2H2(604))
  call Hloop_UV_W(ntryL,G1H4(507),19,ex3(:),4,G2H2(605),m3h2x2(:,793),heltab2x4(:,:,793))
  call Hloop_UV_W(ntryL,G1H4(509),19,ex3(:),4,G2H2(606),m3h2x2(:,794),heltab2x4(:,:,794))
  call Hloop_UV_W(ntryL,G0H4(63),19,ex3(:),4,G1H2(134),m3h2x2(:,795),heltab2x4(:,:,795))
  call Hloop_DV_C(ntryL,G1H4(512),19,ex4(:),G2H2(607),m3h2x2(:,796),heltab2x4(:,:,796))
call HGT_OLR(G1H4(513),1,1,4)
call HGT_invQ_OLR(G1H4(513),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(513),-4,ex3(:),4,G2H2(608),m3h2x2(:,797),heltab2x4(:,:,797))
  call Hloop_DV_C(ntryL,G1H4(519),19,ex4(:),G2H2(609),m3h2x2(:,798),heltab2x4(:,:,798))
  call Hloop_DV_C(ntryL,G1H4(524),19,ex4(:),G2H2(610),m3h2x2(:,799),heltab2x4(:,:,799))
  call Hloop_DV_C(ntryL,G0H4(64),19,ex4(:),G1H2(139),m3h2x2(:,800),heltab2x4(:,:,800))
  call Hloop_CV_D(ntryL,G1H4(520),19,ex4(:),8,G2H2(611),m3h2x2(:,801),heltab2x4(:,:,801))
call HGT_OLR(G1H4(523),1,1,4)
call HGT_invQ_OLR(G1H4(523),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(523),-4,ex3(:),G2H2(612),m3h2x2(:,802),heltab2x4(:,:,802))
  call Hloop_CV_D(ntryL,G1H4(528),19,ex4(:),8,G2H2(613),m3h2x2(:,803),heltab2x4(:,:,803))
  call Hloop_CV_D(ntryL,G1H4(529),19,ex4(:),8,G2H2(614),m3h2x2(:,804),heltab2x4(:,:,804))
  call Hloop_CV_D(ntryL,G0H4(65),19,ex4(:),8,G1H2(140),m3h2x2(:,805),heltab2x4(:,:,805))
  call Hloop_UV_W(ntryL,G1H4(530),19,ex4(:),8,G2H2(615),m3h2x2(:,806),heltab2x4(:,:,806))
call HGT_raise_alpha_OLR(G1H4(535),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(535),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(535),-4,ex3(:),4,G2H2(616),m3h2x2(:,807),heltab2x4(:,:,807))
call signflip_OLR(G2H2(616))
  call Hloop_UV_W(ntryL,G1H4(536),19,ex4(:),8,G2H2(617),m3h2x2(:,808),heltab2x4(:,:,808))
  call Hloop_UV_W(ntryL,G1H4(539),19,ex4(:),8,G2H2(618),m3h2x2(:,809),heltab2x4(:,:,809))
  call Hloop_UV_W(ntryL,G0H4(66),19,ex4(:),8,G1H2(14),m3h2x2(:,810),heltab2x4(:,:,810))
  call Hloop_CV_D(ntryL,G1H4(541),22,ex1(:),1,G2H2(619),m3h2x2(:,811),heltab2x4(:,:,811))
call HGT_OLR(G1H4(544),1,1,4)
call HGT_invQ_OLR(G1H4(544),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(544),-8,ex4(:),G2H2(620),m3h2x2(:,812),heltab2x4(:,:,812))
  call Hloop_CV_D(ntryL,G1H4(546),22,ex1(:),1,G2H2(621),m3h2x2(:,813),heltab2x4(:,:,813))
  call Hloop_CV_D(ntryL,G1H4(551),22,ex1(:),1,G2H2(622),m3h2x2(:,814),heltab2x4(:,:,814))
  call Hloop_CV_D(ntryL,G0H4(67),22,ex1(:),1,G1H2(144),m3h2x2(:,815),heltab2x4(:,:,815))
  call Hloop_DV_C(ntryL,G1H4(556),22,ex1(:),G2H2(623),m3h2x2(:,816),heltab2x4(:,:,816))
call HGT_OLR(G1H4(552),1,1,4)
call HGT_invQ_OLR(G1H4(552),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(552),-8,ex4(:),8,G2H2(624),m3h2x2(:,817),heltab2x4(:,:,817))
  call Hloop_DV_C(ntryL,G1H4(557),22,ex1(:),G2H2(625),m3h2x2(:,818),heltab2x4(:,:,818))
  call Hloop_DV_C(ntryL,G1H4(560),22,ex1(:),G2H2(626),m3h2x2(:,819),heltab2x4(:,:,819))
  call Hloop_DV_C(ntryL,G0H4(68),22,ex1(:),G1H2(149),m3h2x2(:,820),heltab2x4(:,:,820))
  call Hloop_UV_W(ntryL,G1H4(561),22,ex1(:),1,G2H2(627),m3h2x2(:,821),heltab2x4(:,:,821))
call HGT_raise_alpha_OLR(G1H4(562),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(562),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(562),-8,ex4(:),8,G2H2(628),m3h2x2(:,822),heltab2x4(:,:,822))
call signflip_OLR(G2H2(628))
  call Hloop_UV_W(ntryL,G1H4(572),22,ex1(:),1,G2H2(629),m3h2x2(:,823),heltab2x4(:,:,823))
  call Hloop_UV_W(ntryL,G1H4(568),22,ex1(:),1,G2H2(630),m3h2x2(:,824),heltab2x4(:,:,824))
  call Hloop_UV_W(ntryL,G0H4(69),22,ex1(:),1,G1H2(150),m3h2x2(:,825),heltab2x4(:,:,825))
  call Hloop_DV_C(ntryL,G1H4(571),26,ex1(:),G2H2(631),m3h2x2(:,826),heltab2x4(:,:,826))
call HGT_OLR(G1H4(573),1,1,4)
call HGT_invQ_OLR(G1H4(573),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(573),-4,ex3(:),4,G2H2(632),m3h2x2(:,827),heltab2x4(:,:,827))
  call Hloop_DV_C(ntryL,G1H4(388),26,ex1(:),G2H2(633),m3h2x2(:,828),heltab2x4(:,:,828))
  call Hloop_DV_C(ntryL,G1H4(4),26,ex1(:),G2H2(634),m3h2x2(:,829),heltab2x4(:,:,829))
  call Hloop_DV_C(ntryL,G0H4(70),26,ex1(:),G1H2(16),m3h2x2(:,830),heltab2x4(:,:,830))
  call Hloop_CV_D(ntryL,G1H4(404),26,ex1(:),1,G2H2(635),m3h2x2(:,831),heltab2x4(:,:,831))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(20),-4,ex3(:),G2H2(636),m3h2x2(:,832),heltab2x4(:,:,832))
  call Hloop_CV_D(ntryL,G1H4(37),26,ex1(:),1,G2H2(637),m3h2x2(:,833),heltab2x4(:,:,833))
  call Hloop_CV_D(ntryL,G1H4(22),26,ex1(:),1,G2H2(638),m3h2x2(:,834),heltab2x4(:,:,834))
  call Hloop_CV_D(ntryL,G0H4(71),26,ex1(:),1,G1H2(154),m3h2x2(:,835),heltab2x4(:,:,835))
  call Hloop_UV_W(ntryL,G1H4(420),26,ex1(:),1,G2H2(639),m3h2x2(:,836),heltab2x4(:,:,836))
call HGT_raise_alpha_OLR(G1H4(36),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(36),-4,ex3(:),4,G2H2(640),m3h2x2(:,837),heltab2x4(:,:,837))
call signflip_OLR(G2H2(640))
  call Hloop_UV_W(ntryL,G1H4(52),26,ex1(:),1,G2H2(641),m3h2x2(:,838),heltab2x4(:,:,838))
  call Hloop_UV_W(ntryL,G1H4(196),26,ex1(:),1,G2H2(642),m3h2x2(:,839),heltab2x4(:,:,839))
  call Hloop_UV_W(ntryL,G0H4(72),26,ex1(:),1,G1H2(159),m3h2x2(:,840),heltab2x4(:,:,840))
  call Hloop_DV_C(ntryL,G1H4(68),21,ex2(:),G2H2(643),m3h2x2(:,841),heltab2x4(:,:,841))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(86),-8,ex4(:),8,G2H2(644),m3h2x2(:,842),heltab2x4(:,:,842))
  call Hloop_DV_C(ntryL,G1H4(70),21,ex2(:),G2H2(645),m3h2x2(:,843),heltab2x4(:,:,843))
  call Hloop_DV_C(ntryL,G1H4(228),21,ex2(:),G2H2(646),m3h2x2(:,844),heltab2x4(:,:,844))
  call Hloop_DV_C(ntryL,G0H4(73),21,ex2(:),G1H2(160),m3h2x2(:,845),heltab2x4(:,:,845))
  call Hloop_CV_D(ntryL,G1H4(84),21,ex2(:),2,G2H2(647),m3h2x2(:,846),heltab2x4(:,:,846))
call HGT_OLR(G1H4(292),1,1,4)
call HGT_invQ_OLR(G1H4(292),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(292),-8,ex4(:),G2H2(648),m3h2x2(:,847),heltab2x4(:,:,847))
  call Hloop_CV_D(ntryL,G1H4(308),21,ex2(:),2,G2H2(649),m3h2x2(:,848),heltab2x4(:,:,848))
  call Hloop_CV_D(ntryL,G1H4(116),21,ex2(:),2,G2H2(650),m3h2x2(:,849),heltab2x4(:,:,849))
  call Hloop_CV_D(ntryL,G0H4(74),21,ex2(:),2,G1H2(18),m3h2x2(:,850),heltab2x4(:,:,850))
  call Hloop_UV_W(ntryL,G1H4(21),21,ex2(:),2,G2H2(651),m3h2x2(:,851),heltab2x4(:,:,851))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(6),-8,ex4(:),8,G2H2(652),m3h2x2(:,852),heltab2x4(:,:,852))
call signflip_OLR(G2H2(652))
  call Hloop_UV_W(ntryL,G1H4(324),21,ex2(:),2,G2H2(653),m3h2x2(:,853),heltab2x4(:,:,853))
  call Hloop_UV_W(ntryL,G1H4(132),21,ex2(:),2,G2H2(654),m3h2x2(:,854),heltab2x4(:,:,854))
  call Hloop_UV_W(ntryL,G0H4(75),21,ex2(:),2,G1H2(164),m3h2x2(:,855),heltab2x4(:,:,855))
  call Hloop_DV_C(ntryL,G1H4(99),21,ex4(:),G2H2(655),m3h2x2(:,856),heltab2x4(:,:,856))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(260),-2,ex2(:),2,G2H2(656),m3h2x2(:,857),heltab2x4(:,:,857))
  call Hloop_DV_C(ntryL,G1H4(115),21,ex4(:),G2H2(657),m3h2x2(:,858),heltab2x4(:,:,858))
  call Hloop_DV_C(ntryL,G1H4(244),21,ex4(:),G2H2(658),m3h2x2(:,859),heltab2x4(:,:,859))
  call Hloop_DV_C(ntryL,G0H4(76),21,ex4(:),G1H2(169),m3h2x2(:,860),heltab2x4(:,:,860))
  call Hloop_CV_D(ntryL,G1H4(164),21,ex4(:),8,G2H2(659),m3h2x2(:,861),heltab2x4(:,:,861))
call HGT_OLR(G1H4(131),1,1,4)
call HGT_invQ_OLR(G1H4(131),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(131),-2,ex2(:),G2H2(660),m3h2x2(:,862),heltab2x4(:,:,862))
  call Hloop_CV_D(ntryL,G1H4(54),21,ex4(:),8,G2H2(661),m3h2x2(:,863),heltab2x4(:,:,863))
  call Hloop_CV_D(ntryL,G1H4(53),21,ex4(:),8,G2H2(662),m3h2x2(:,864),heltab2x4(:,:,864))
  call Hloop_CV_D(ntryL,G0H4(77),21,ex4(:),8,G1H2(170),m3h2x2(:,865),heltab2x4(:,:,865))
  call Hloop_UV_W(ntryL,G1H4(276),21,ex4(:),8,G2H2(663),m3h2x2(:,866),heltab2x4(:,:,866))
call HGT_raise_alpha_OLR(G1H4(180),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(180),-2,ex2(:),2,G2H2(664),m3h2x2(:,867),heltab2x4(:,:,867))
call signflip_OLR(G2H2(664))
  call Hloop_UV_W(ntryL,G1H4(19),21,ex4(:),8,G2H2(665),m3h2x2(:,868),heltab2x4(:,:,868))
  call Hloop_UV_W(ntryL,G1H4(35),21,ex4(:),8,G2H2(666),m3h2x2(:,869),heltab2x4(:,:,869))
  call Hloop_UV_W(ntryL,G0H4(78),21,ex4(:),8,G1H2(20),m3h2x2(:,870),heltab2x4(:,:,870))
  call Hloop_DV_C(ntryL,G1H4(340),25,ex2(:),G2H2(667),m3h2x2(:,871),heltab2x4(:,:,871))
call HGT_OLR(G1H4(356),1,1,4)
call HGT_invQ_OLR(G1H4(356),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(356),-4,ex3(:),4,G2H2(668),m3h2x2(:,872),heltab2x4(:,:,872))
  call Hloop_DV_C(ntryL,G1H4(67),25,ex2(:),G2H2(669),m3h2x2(:,873),heltab2x4(:,:,873))
  call Hloop_DV_C(ntryL,G1H4(436),25,ex2(:),G2H2(670),m3h2x2(:,874),heltab2x4(:,:,874))
  call Hloop_DV_C(ntryL,G0H4(79),25,ex2(:),G1H2(174),m3h2x2(:,875),heltab2x4(:,:,875))
  call Hloop_CV_D(ntryL,G1H4(51),25,ex2(:),2,G2H2(671),m3h2x2(:,876),heltab2x4(:,:,876))
call HGT_OLR(G1H4(452),1,1,4)
call HGT_invQ_OLR(G1H4(452),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(452),-4,ex3(:),G2H2(672),m3h2x2(:,877),heltab2x4(:,:,877))
  call Hloop_CV_D(ntryL,G1H4(468),25,ex2(:),2,G2H2(673),m3h2x2(:,878),heltab2x4(:,:,878))
  call Hloop_CV_D(ntryL,G1H4(484),25,ex2(:),2,G2H2(674),m3h2x2(:,879),heltab2x4(:,:,879))
  call Hloop_CV_D(ntryL,G0H4(80),25,ex2(:),2,G1H2(179),m3h2x2(:,880),heltab2x4(:,:,880))
  call Hloop_UV_W(ntryL,G1H4(500),25,ex2(:),2,G2H2(675),m3h2x2(:,881),heltab2x4(:,:,881))
call HGT_raise_alpha_OLR(G1H4(516),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(516),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(516),-4,ex3(:),4,G2H2(676),m3h2x2(:,882),heltab2x4(:,:,882))
call signflip_OLR(G2H2(676))
  call Hloop_UV_W(ntryL,G1H4(532),25,ex2(:),2,G2H2(677),m3h2x2(:,883),heltab2x4(:,:,883))
  call Hloop_UV_W(ntryL,G1H4(147),25,ex2(:),2,G2H2(678),m3h2x2(:,884),heltab2x4(:,:,884))
  call Hloop_UV_W(ntryL,G0H4(81),25,ex2(:),2,G1H2(180),m3h2x2(:,885),heltab2x4(:,:,885))
  call Hloop_DV_C(ntryL,G1H4(548),25,ex3(:),G2H2(679),m3h2x2(:,886),heltab2x4(:,:,886))
call HGT_OLR(G1H4(179),1,1,4)
call HGT_invQ_OLR(G1H4(179),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(179),-2,ex2(:),2,G2H2(680),m3h2x2(:,887),heltab2x4(:,:,887))
  call Hloop_DV_C(ntryL,G1H4(10),25,ex3(:),G2H2(681),m3h2x2(:,888),heltab2x4(:,:,888))
  call Hloop_DV_C(ntryL,G1H4(15),25,ex3(:),G2H2(682),m3h2x2(:,889),heltab2x4(:,:,889))
  call Hloop_DV_C(ntryL,G0H4(82),25,ex3(:),G1H2(22),m3h2x2(:,890),heltab2x4(:,:,890))
  call Hloop_CV_D(ntryL,G1H4(26),25,ex3(:),4,G2H2(683),m3h2x2(:,891),heltab2x4(:,:,891))
call HGT_OLR(G1H4(31),1,1,4)
call HGT_invQ_OLR(G1H4(31),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(31),-2,ex2(:),G2H2(684),m3h2x2(:,892),heltab2x4(:,:,892))
  call Hloop_CV_D(ntryL,G1H4(47),25,ex3(:),4,G2H2(685),m3h2x2(:,893),heltab2x4(:,:,893))
  call Hloop_CV_D(ntryL,G1H4(58),25,ex3(:),4,G2H2(686),m3h2x2(:,894),heltab2x4(:,:,894))
  call Hloop_CV_D(ntryL,G0H4(83),25,ex3(:),4,G1H2(184),m3h2x2(:,895),heltab2x4(:,:,895))
  call Hloop_UV_W(ntryL,G1H4(63),25,ex3(:),4,G2H2(687),m3h2x2(:,896),heltab2x4(:,:,896))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(74),-2,ex2(:),2,G2H2(688),m3h2x2(:,897),heltab2x4(:,:,897))
call signflip_OLR(G2H2(688))
  call Hloop_UV_W(ntryL,G1H4(90),25,ex3(:),4,G2H2(689),m3h2x2(:,898),heltab2x4(:,:,898))
  call Hloop_UV_W(ntryL,G1H4(95),25,ex3(:),4,G2H2(690),m3h2x2(:,899),heltab2x4(:,:,899))
  call Hloop_UV_W(ntryL,G0H4(84),25,ex3(:),4,G1H2(189),m3h2x2(:,900),heltab2x4(:,:,900))
  call Hloop_UV_W(ntryL,G1H8(44),17,ex2(:),2,G2H4(101),m3h2x4(:,229),heltab2x8(:,:,229))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(46),ex3(:),ex4(:),G1H2(190),m4h2x2x2(:,19),heltab3x8(:,:,19))
  call Hloop_UV_W(ntryL,G1H8(48),17,ex2(:),2,G2H4(104),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_UV_W(ntryL,G1H8(49),17,ex2(:),2,G2H4(105),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_UV_W(ntryL,G1H8(50),17,ex2(:),2,G2H4(106),m3h2x4(:,232),heltab2x8(:,:,232))
call HGT_raise_alpha_OLR(G1H8(52),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(52),ex4(:),ex3(:),G1H2(24),m4h2x2x2(:,20),heltab3x8(:,:,20))
  call Hloop_UV_W(ntryL,G1H8(54),17,ex2(:),2,G2H4(109),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_UV_W(ntryL,G1H8(55),17,ex2(:),2,G2H4(110),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_UV_W(ntryL,G1H8(56),17,ex2(:),2,G2H4(111),m3h2x4(:,235),heltab2x8(:,:,235))
call HGT_raise_alpha_OLR(G1H8(58),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(58),ex3(:),ex4(:),G1H2(194),m4h2x2x2(:,21),heltab3x8(:,:,21))
  call Hloop_UV_W(ntryL,G1H8(60),17,ex2(:),2,G2H4(114),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_UV_W(ntryL,G1H8(61),17,ex2(:),2,G2H4(115),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_UV_W(ntryL,G1H8(62),18,ex1(:),1,G2H4(116),m3h2x4(:,238),heltab2x8(:,:,238))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(64),ex3(:),ex4(:),G1H2(199),m4h2x2x2(:,22),heltab3x8(:,:,22))
  call Hloop_UV_W(ntryL,G1H8(66),18,ex1(:),1,G2H4(119),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_UV_W(ntryL,G1H8(67),18,ex1(:),1,G2H4(120),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_UV_W(ntryL,G1H8(68),18,ex1(:),1,G2H4(121),m3h2x4(:,241),heltab2x8(:,:,241))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(70),ex4(:),ex3(:),G1H2(200),m4h2x2x2(:,23),heltab3x8(:,:,23))
  call Hloop_UV_W(ntryL,G1H8(72),18,ex1(:),1,G2H4(124),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_UV_W(ntryL,G1H8(73),18,ex1(:),1,G2H4(125),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_UV_W(ntryL,G1H8(74),18,ex1(:),1,G2H4(126),m3h2x4(:,244),heltab2x8(:,:,244))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(76),ex3(:),ex4(:),G1H2(26),m4h2x2x2(:,24),heltab3x8(:,:,24))
  call Hloop_UV_W(ntryL,G1H8(78),18,ex1(:),1,G2H4(129),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_UV_W(ntryL,G1H8(79),18,ex1(:),1,G2H4(130),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_UV_W(ntryL,G1H8(80),17,ex3(:),4,G2H4(131),m3h2x4(:,247),heltab2x8(:,:,247))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(82),ex2(:),ex4(:),G1H2(204),m4h2x2x2(:,25),heltab3x8(:,:,25))
  call Hloop_UV_W(ntryL,G1H8(84),17,ex3(:),4,G2H4(134),m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_UV_W(ntryL,G1H8(85),17,ex3(:),4,G2H4(135),m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_UV_W(ntryL,G1H8(86),17,ex3(:),4,G2H4(136),m3h2x4(:,250),heltab2x8(:,:,250))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(88),ex4(:),ex2(:),G1H2(209),m4h2x2x2(:,26),heltab3x8(:,:,26))
  call Hloop_UV_W(ntryL,G1H8(90),17,ex3(:),4,G2H4(139),m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_UV_W(ntryL,G1H8(91),17,ex3(:),4,G2H4(140),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_UV_W(ntryL,G1H8(92),17,ex3(:),4,G2H4(141),m3h2x4(:,253),heltab2x8(:,:,253))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(94),ex2(:),ex4(:),G1H2(210),m4h2x2x2(:,27),heltab3x8(:,:,27))
  call Hloop_UV_W(ntryL,G1H8(96),17,ex3(:),4,G2H4(144),m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_UV_W(ntryL,G1H8(97),17,ex3(:),4,G2H4(145),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_UV_W(ntryL,G1H8(98),20,ex1(:),1,G2H4(146),m3h2x4(:,256),heltab2x8(:,:,256))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(100),ex2(:),ex4(:),G1H2(28),m4h2x2x2(:,28),heltab3x8(:,:,28))
  call Hloop_UV_W(ntryL,G1H8(102),20,ex1(:),1,G2H4(149),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_UV_W(ntryL,G1H8(103),20,ex1(:),1,G2H4(150),m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_UV_W(ntryL,G1H8(104),20,ex1(:),1,G2H4(151),m3h2x4(:,259),heltab2x8(:,:,259))
call HGT_raise_alpha_OLR(G1H8(106),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(106),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(106),ex4(:),ex2(:),G1H2(214),m4h2x2x2(:,29),heltab3x8(:,:,29))
  call Hloop_UV_W(ntryL,G1H8(108),20,ex1(:),1,G2H4(154),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_UV_W(ntryL,G1H8(109),20,ex1(:),1,G2H4(155),m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_UV_W(ntryL,G1H8(110),20,ex1(:),1,G2H4(156),m3h2x4(:,262),heltab2x8(:,:,262))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(112),ex2(:),ex4(:),G1H2(219),m4h2x2x2(:,30),heltab3x8(:,:,30))
  call Hloop_UV_W(ntryL,G1H8(114),20,ex1(:),1,G2H4(159),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_UV_W(ntryL,G1H8(115),20,ex1(:),1,G2H4(160),m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_UV_W(ntryL,G1H8(116),17,ex4(:),8,G2H4(161),m3h2x4(:,265),heltab2x8(:,:,265))
call HGT_raise_alpha_OLR(G1H8(118),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(118),ex2(:),ex3(:),G1H2(220),m4h2x2x2(:,31),heltab3x8(:,:,31))
  call Hloop_UV_W(ntryL,G1H8(120),17,ex4(:),8,G2H4(164),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_UV_W(ntryL,G1H8(121),17,ex4(:),8,G2H4(165),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_UV_W(ntryL,G1H8(122),17,ex4(:),8,G2H4(166),m3h2x4(:,268),heltab2x8(:,:,268))
call HGT_raise_alpha_OLR(G1H8(124),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(124),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(124),ex3(:),ex2(:),G1H2(30),m4h2x2x2(:,32),heltab3x8(:,:,32))
  call Hloop_UV_W(ntryL,G1H8(126),17,ex4(:),8,G2H4(169),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_UV_W(ntryL,G1H8(127),17,ex4(:),8,G2H4(170),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_UV_W(ntryL,G1H8(128),17,ex4(:),8,G2H4(171),m3h2x4(:,271),heltab2x8(:,:,271))
call HGT_raise_alpha_OLR(G1H8(130),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(130),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(130),ex2(:),ex3(:),G1H2(224),m4h2x2x2(:,33),heltab3x8(:,:,33))
  call Hloop_UV_W(ntryL,G1H8(132),17,ex4(:),8,G2H4(174),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_UV_W(ntryL,G1H8(133),17,ex4(:),8,G2H4(175),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_UV_W(ntryL,G1H8(134),18,ex3(:),4,G2H4(176),m3h2x4(:,274),heltab2x8(:,:,274))
call HGT_raise_alpha_OLR(G1H8(136),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(136),ex1(:),ex4(:),G1H2(229),m4h2x2x2(:,34),heltab3x8(:,:,34))
  call Hloop_UV_W(ntryL,G1H8(138),18,ex3(:),4,G2H4(179),m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_UV_W(ntryL,G1H8(139),18,ex3(:),4,G2H4(180),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_UV_W(ntryL,G1H8(140),18,ex3(:),4,G2H4(123),m3h2x4(:,277),heltab2x8(:,:,277))
call HGT_raise_alpha_OLR(G1H8(142),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(142),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(142),ex4(:),ex1(:),G1H2(230),m4h2x2x2(:,35),heltab3x8(:,:,35))
  call Hloop_UV_W(ntryL,G1H8(144),18,ex3(:),4,G2H4(3),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_UV_W(ntryL,G1H8(145),18,ex3(:),4,G2H4(128),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_UV_W(ntryL,G1H8(146),18,ex3(:),4,G2H4(8),m3h2x4(:,280),heltab2x8(:,:,280))
call HGT_raise_alpha_OLR(G1H8(148),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(148),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(148),ex1(:),ex4(:),G1H2(32),m4h2x2x2(:,36),heltab3x8(:,:,36))
  call Hloop_UV_W(ntryL,G1H8(150),18,ex3(:),4,G2H4(133),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_UV_W(ntryL,G1H8(151),18,ex3(:),4,G2H4(13),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_UV_W(ntryL,G1H8(152),20,ex2(:),2,G2H4(91),m3h2x4(:,283),heltab2x8(:,:,283))
call HGT_raise_alpha_OLR(G1H8(154),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(154),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(154),ex1(:),ex4(:),G1H2(234),m4h2x2x2(:,37),heltab3x8(:,:,37))
  call Hloop_UV_W(ntryL,G1H8(156),20,ex2(:),2,G2H4(68),m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_UV_W(ntryL,G1H8(157),20,ex2(:),2,G2H4(18),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_UV_W(ntryL,G1H8(158),20,ex2(:),2,G2H4(94),m3h2x4(:,286),heltab2x8(:,:,286))
call HGT_raise_alpha_OLR(G1H8(160),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(160),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(160),ex4(:),ex1(:),G1H2(239),m4h2x2x2(:,38),heltab3x8(:,:,38))
  call Hloop_UV_W(ntryL,G1H8(162),20,ex2(:),2,G2H4(63),m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_UV_W(ntryL,G1H8(163),20,ex2(:),2,G2H4(23),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_UV_W(ntryL,G1H8(164),20,ex2(:),2,G2H4(61),m3h2x4(:,289),heltab2x8(:,:,289))
call HGT_raise_alpha_OLR(G1H8(166),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(166),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(166),ex1(:),ex4(:),G1H2(240),m4h2x2x2(:,39),heltab3x8(:,:,39))
  call Hloop_UV_W(ntryL,G1H8(168),20,ex2(:),2,G2H4(73),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_UV_W(ntryL,G1H8(169),20,ex2(:),2,G2H4(28),m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_UV_W(ntryL,G1H8(170),18,ex4(:),8,G2H4(93),m3h2x4(:,292),heltab2x8(:,:,292))
call HGT_raise_alpha_OLR(G1H8(172),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(172),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(172),ex1(:),ex3(:),G1H2(34),m4h2x2x2(:,40),heltab3x8(:,:,40))
  call Hloop_UV_W(ntryL,G1H8(174),18,ex4(:),8,G2H4(33),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_UV_W(ntryL,G1H8(175),18,ex4(:),8,G2H4(98),m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_UV_W(ntryL,G1H8(176),18,ex4(:),8,G2H4(38),m3h2x4(:,295),heltab2x8(:,:,295))
call HGT_raise_alpha_OLR(G1H8(178),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(178),2,5,8)
  call Hloop_GGG_G_12(ntryL,G1H8(178),ex3(:),ex1(:),G1H2(244),m4h2x2x2(:,41),heltab3x8(:,:,41))
  call Hloop_UV_W(ntryL,G1H8(180),18,ex4(:),8,G2H4(103),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_UV_W(ntryL,G1H8(181),18,ex4(:),8,G2H4(43),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_UV_W(ntryL,G1H8(182),18,ex4(:),8,G2H4(11),m3h2x4(:,298),heltab2x8(:,:,298))
call HGT_raise_alpha_OLR(G1H8(184),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(184),2,5,8)
  call Hloop_GGG_G_23(ntryL,G1H8(184),ex1(:),ex3(:),G1H2(249),m4h2x2x2(:,42),heltab3x8(:,:,42))
  call Hloop_UV_W(ntryL,G1H8(186),18,ex4(:),8,G2H4(83),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_UV_W(ntryL,G1H8(187),18,ex4(:),8,G2H4(48),m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_CV_D(ntryL,G1H8(188),20,wf4(:,1),3,G2H2(691),m3h4x2(:,1),heltab2x8(:,:,301))
call HGT_OLR(G1H8(190),1,1,8)
call HGT_invQ_OLR(G1H8(190),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(190),-8,ex4(:),G2H4(14),m3h2x4(:,301),heltab2x8(:,:,302))
  call Hloop_CV_D(ntryL,G1H8(192),20,wf4(:,1),3,G2H2(692),m3h4x2(:,2),heltab2x8(:,:,303))
  call Hloop_CV_D(ntryL,G1H8(193),20,wf4(:,1),3,G2H2(693),m3h4x2(:,3),heltab2x8(:,:,304))
  call Hloop_CV_D(ntryL,G0H8(15),20,wf4(:,1),3,G1H2(250),m3h4x2(:,4),heltab2x8(:,:,305))
  call Hloop_DV_C(ntryL,G1H8(194),20,wf4(:,1),G2H2(694),m3h4x2(:,5),heltab2x8(:,:,306))
call HGT_OLR(G1H8(196),1,1,8)
call HGT_invQ_OLR(G1H8(196),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(196),-8,ex4(:),8,G2H4(78),m3h2x4(:,302),heltab2x8(:,:,307))
  call Hloop_DV_C(ntryL,G1H8(198),20,wf4(:,1),G2H2(695),m3h4x2(:,6),heltab2x8(:,:,308))
  call Hloop_DV_C(ntryL,G1H8(199),20,wf4(:,1),G2H2(696),m3h4x2(:,7),heltab2x8(:,:,309))
  call Hloop_DV_C(ntryL,G0H8(14),20,wf4(:,1),G1H2(36),m3h4x2(:,8),heltab2x8(:,:,310))
  call Hloop_UV_W(ntryL,G1H8(200),20,wf4(:,1),3,G2H2(697),m3h4x2(:,9),heltab2x8(:,:,311))
call HGT_raise_alpha_OLR(G1H8(202),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(202),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(202),-8,ex4(:),8,G2H4(53),m3h2x4(:,303),heltab2x8(:,:,312))
call signflip_OLR(G2H4(53))
  call Hloop_UV_W(ntryL,G1H8(204),20,wf4(:,1),3,G2H2(698),m3h4x2(:,10),heltab2x8(:,:,313))
  call Hloop_UV_W(ntryL,G1H8(205),20,wf4(:,1),3,G2H2(699),m3h4x2(:,11),heltab2x8(:,:,314))
  call Hloop_UV_W(ntryL,G0H8(13),20,wf4(:,1),3,G1H2(254),m3h4x2(:,12),heltab2x8(:,:,315))
  call Hloop_DV_C(ntryL,G1H8(206),18,ex4(:),G2H4(15),m3h2x4(:,304),heltab2x8(:,:,316))
call HGT_OLR(G1H8(208),1,1,8)
call HGT_invQ_OLR(G1H8(208),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(208),-5,wf4(:,2),5,G2H2(700),m3h4x2(:,13),heltab2x8(:,:,317))
  call Hloop_DV_C(ntryL,G1H8(210),18,ex4(:),G2H4(88),m3h2x4(:,305),heltab2x8(:,:,318))
  call Hloop_DV_C(ntryL,G1H8(211),18,ex4(:),G2H4(58),m3h2x4(:,306),heltab2x8(:,:,319))
  call Hloop_DV_C(ntryL,G0H8(24),18,ex4(:),G1H4(106),m3h2x4(:,307),heltab2x8(:,:,320))
  call Hloop_CV_D(ntryL,G1H8(212),18,ex4(:),8,G2H4(95),m3h2x4(:,308),heltab2x8(:,:,321))
call HGT_OLR(G1H8(214),1,1,8)
call HGT_invQ_OLR(G1H8(214),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(214),-5,wf4(:,2),G2H2(701),m3h4x2(:,14),heltab2x8(:,:,322))
  call Hloop_CV_D(ntryL,G1H8(216),18,ex4(:),8,G2H4(96),m3h2x4(:,309),heltab2x8(:,:,323))
  call Hloop_CV_D(ntryL,G1H8(3),18,ex4(:),8,G2H4(64),m3h2x4(:,310),heltab2x8(:,:,324))
  call Hloop_CV_D(ntryL,G0H8(23),18,ex4(:),8,G1H4(111),m3h2x4(:,311),heltab2x8(:,:,325))
  call Hloop_UV_W(ntryL,G1H8(9),18,ex4(:),8,G2H4(1),m3h2x4(:,312),heltab2x8(:,:,326))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(15),-5,wf4(:,2),5,G2H2(702),m3h4x2(:,15),heltab2x8(:,:,327))
call signflip_OLR(G2H2(702))
  call Hloop_UV_W(ntryL,G1H8(27),18,ex4(:),8,G2H4(4),m3h2x4(:,313),heltab2x8(:,:,328))
  call Hloop_UV_W(ntryL,G1H8(33),18,ex4(:),8,G2H4(5),m3h2x4(:,314),heltab2x8(:,:,329))
  call Hloop_UV_W(ntryL,G0H8(22),18,ex4(:),8,G1H4(122),m3h2x4(:,315),heltab2x8(:,:,330))
  call Hloop_CV_D(ntryL,G1H8(39),18,wf4(:,2),5,G2H2(703),m3h4x2(:,16),heltab2x8(:,:,331))
call HGT_OLR(G1H8(45),1,1,8)
call HGT_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(45),-8,ex4(:),G2H4(99),m3h2x4(:,316),heltab2x8(:,:,332))
  call Hloop_CV_D(ntryL,G1H8(57),18,wf4(:,2),5,G2H2(704),m3h4x2(:,17),heltab2x8(:,:,333))
  call Hloop_CV_D(ntryL,G1H8(63),18,wf4(:,2),5,G2H2(705),m3h4x2(:,18),heltab2x8(:,:,334))
  call Hloop_CV_D(ntryL,G0H8(12),18,wf4(:,2),5,G1H2(259),m3h4x2(:,19),heltab2x8(:,:,335))
  call Hloop_DV_C(ntryL,G1H8(69),18,wf4(:,2),G2H2(706),m3h4x2(:,20),heltab2x8(:,:,336))
call HGT_OLR(G1H8(75),1,1,8)
call HGT_invQ_OLR(G1H8(75),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(75),-8,ex4(:),8,G2H4(100),m3h2x4(:,317),heltab2x8(:,:,337))
  call Hloop_DV_C(ntryL,G1H8(87),18,wf4(:,2),G2H2(707),m3h4x2(:,21),heltab2x8(:,:,338))
  call Hloop_DV_C(ntryL,G1H8(93),18,wf4(:,2),G2H2(708),m3h4x2(:,22),heltab2x8(:,:,339))
  call Hloop_DV_C(ntryL,G0H8(11),18,wf4(:,2),G1H2(260),m3h4x2(:,23),heltab2x8(:,:,340))
  call Hloop_UV_W(ntryL,G1H8(99),18,wf4(:,2),5,G2H2(709),m3h4x2(:,24),heltab2x8(:,:,341))
call HGT_raise_alpha_OLR(G1H8(105),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(105),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(105),-8,ex4(:),8,G2H4(65),m3h2x4(:,318),heltab2x8(:,:,342))
call signflip_OLR(G2H4(65))
  call Hloop_UV_W(ntryL,G1H8(117),18,wf4(:,2),5,G2H2(710),m3h4x2(:,25),heltab2x8(:,:,343))
  call Hloop_UV_W(ntryL,G1H8(123),18,wf4(:,2),5,G2H2(711),m3h4x2(:,26),heltab2x8(:,:,344))
  call Hloop_UV_W(ntryL,G0H8(10),18,wf4(:,2),5,G1H2(38),m3h4x2(:,27),heltab2x8(:,:,345))
  call Hloop_DV_C(ntryL,G1H8(147),17,ex4(:),G2H4(9),m3h2x4(:,319),heltab2x8(:,:,346))
call HGT_OLR(G1H8(153),1,1,8)
call HGT_invQ_OLR(G1H8(153),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(153),-6,wf4(:,5),6,G2H2(712),m3h4x2(:,28),heltab2x8(:,:,347))
  call Hloop_DV_C(ntryL,G1H8(26),17,ex4(:),G2H4(6),m3h2x4(:,320),heltab2x8(:,:,348))
  call Hloop_DV_C(ntryL,G1H8(28),17,ex4(:),G2H4(10),m3h2x4(:,321),heltab2x8(:,:,349))
  call Hloop_DV_C(ntryL,G0H8(27),17,ex4(:),G1H4(127),m3h2x4(:,322),heltab2x8(:,:,350))
  call Hloop_CV_D(ntryL,G1H8(29),17,ex4(:),8,G2H4(89),m3h2x4(:,323),heltab2x8(:,:,351))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(17),-6,wf4(:,5),G2H2(713),m3h4x2(:,29),heltab2x8(:,:,352))
  call Hloop_CV_D(ntryL,G1H8(18),17,ex4(:),8,G2H4(90),m3h2x4(:,324),heltab2x8(:,:,353))
  call Hloop_CV_D(ntryL,G1H8(23),17,ex4(:),8,G2H4(66),m3h2x4(:,325),heltab2x8(:,:,354))
  call Hloop_CV_D(ntryL,G0H8(26),17,ex4(:),8,G1H4(138),m3h2x4(:,326),heltab2x8(:,:,355))
  call Hloop_UV_W(ntryL,G1H8(24),17,ex4(:),8,G2H4(19),m3h2x4(:,327),heltab2x8(:,:,356))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(25),-6,wf4(:,5),6,G2H2(714),m3h4x2(:,30),heltab2x8(:,:,357))
call signflip_OLR(G2H2(714))
  call Hloop_UV_W(ntryL,G1H8(19),17,ex4(:),8,G2H4(16),m3h2x4(:,328),heltab2x8(:,:,358))
  call Hloop_UV_W(ntryL,G1H8(22),17,ex4(:),8,G2H4(20),m3h2x4(:,329),heltab2x8(:,:,359))
  call Hloop_UV_W(ntryL,G0H8(25),17,ex4(:),8,G1H4(143),m3h2x4(:,330),heltab2x8(:,:,360))
  call Hloop_CV_D(ntryL,G1H8(5),17,wf4(:,5),6,G2H2(715),m3h4x2(:,31),heltab2x8(:,:,361))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(6),-8,ex4(:),G2H4(2),m3h2x4(:,331),heltab2x8(:,:,362))
  call Hloop_CV_D(ntryL,G1H8(8),17,wf4(:,5),6,G2H2(716),m3h4x2(:,32),heltab2x8(:,:,363))
  call Hloop_CV_D(ntryL,G1H8(10),17,wf4(:,5),6,G2H2(717),m3h4x2(:,33),heltab2x8(:,:,364))
  call Hloop_CV_D(ntryL,G0H8(33),17,wf4(:,5),6,G1H2(264),m3h4x2(:,34),heltab2x8(:,:,365))
  call Hloop_DV_C(ntryL,G1H8(11),17,wf4(:,5),G2H2(718),m3h4x2(:,35),heltab2x8(:,:,366))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(12),-8,ex4(:),8,G2H4(79),m3h2x4(:,332),heltab2x8(:,:,367))
  call Hloop_DV_C(ntryL,G1H8(14),17,wf4(:,5),G2H2(719),m3h4x2(:,36),heltab2x8(:,:,368))
  call Hloop_DV_C(ntryL,G1H8(129),17,wf4(:,5),G2H2(720),m3h4x2(:,37),heltab2x8(:,:,369))
  call Hloop_DV_C(ntryL,G0H8(32),17,wf4(:,5),G1H2(269),m3h4x2(:,38),heltab2x8(:,:,370))
  call Hloop_UV_W(ntryL,G1H8(135),17,wf4(:,5),6,G2H2(721),m3h4x2(:,39),heltab2x8(:,:,371))
call HGT_raise_alpha_OLR(G1H8(141),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(141),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(141),-8,ex4(:),8,G2H4(7),m3h2x4(:,333),heltab2x8(:,:,372))
call signflip_OLR(G2H4(7))
  call Hloop_UV_W(ntryL,G1H8(1),17,wf4(:,5),6,G2H2(722),m3h4x2(:,40),heltab2x8(:,:,373))
  call Hloop_UV_W(ntryL,G1H8(4),17,wf4(:,5),6,G2H2(723),m3h4x2(:,41),heltab2x8(:,:,374))
  call Hloop_UV_W(ntryL,G0H8(31),17,wf4(:,5),6,G1H2(270),m3h4x2(:,42),heltab2x8(:,:,375))
  call Hloop_DV_C(ntryL,G1H8(165),18,ex3(:),G2H4(80),m3h2x4(:,334),heltab2x8(:,:,376))
call HGT_OLR(G1H8(171),1,1,8)
call HGT_invQ_OLR(G1H8(171),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(171),-9,wf4(:,3),9,G2H2(724),m3h4x2(:,43),heltab2x8(:,:,377))
  call Hloop_DV_C(ntryL,G1H8(183),18,ex3(:),G2H4(12),m3h2x4(:,335),heltab2x8(:,:,378))
  call Hloop_DV_C(ntryL,G1H8(189),18,ex3(:),G2H4(81),m3h2x4(:,336),heltab2x8(:,:,379))
  call Hloop_DV_C(ntryL,G0H8(36),18,ex3(:),G1H4(154),m3h2x4(:,337),heltab2x8(:,:,380))
  call Hloop_CV_D(ntryL,G1H8(195),18,ex3(:),4,G2H4(17),m3h2x4(:,338),heltab2x8(:,:,381))
call HGT_OLR(G1H8(201),1,1,8)
call HGT_invQ_OLR(G1H8(201),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(201),-9,wf4(:,3),G2H2(725),m3h4x2(:,44),heltab2x8(:,:,382))
  call Hloop_CV_D(ntryL,G1H8(213),18,ex3(:),4,G2H4(75),m3h2x4(:,339),heltab2x8(:,:,383))
  call Hloop_CV_D(ntryL,G1H8(36),18,ex3(:),4,G2H4(22),m3h2x4(:,340),heltab2x8(:,:,384))
  call Hloop_CV_D(ntryL,G0H8(35),18,ex3(:),4,G1H4(159),m3h2x4(:,341),heltab2x8(:,:,385))
  call Hloop_UV_W(ntryL,G1H8(40),18,ex3(:),4,G2H4(74),m3h2x4(:,342),heltab2x8(:,:,386))
call HGT_raise_alpha_OLR(G1H8(43),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(43),-9,wf4(:,3),9,G2H2(726),m3h4x2(:,45),heltab2x8(:,:,387))
call signflip_OLR(G2H2(726))
  call Hloop_UV_W(ntryL,G1H8(30),18,ex3(:),4,G2H4(27),m3h2x4(:,343),heltab2x8(:,:,388))
  call Hloop_UV_W(ntryL,G1H8(31),18,ex3(:),4,G2H4(76),m3h2x4(:,344),heltab2x8(:,:,389))
  call Hloop_UV_W(ntryL,G0H8(34),18,ex3(:),4,G1H4(170),m3h2x4(:,345),heltab2x8(:,:,390))
  call Hloop_CV_D(ntryL,G1H8(34),20,ex2(:),2,G2H4(32),m3h2x4(:,346),heltab2x8(:,:,391))
call HGT_OLR(G1H8(35),1,1,8)
call HGT_invQ_OLR(G1H8(35),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(35),-9,wf4(:,3),G2H2(727),m3h4x2(:,46),heltab2x8(:,:,392))
  call Hloop_CV_D(ntryL,G1H8(38),20,ex2(:),2,G2H4(85),m3h2x4(:,347),heltab2x8(:,:,393))
  call Hloop_CV_D(ntryL,G1H8(41),20,ex2(:),2,G2H4(37),m3h2x4(:,348),heltab2x8(:,:,394))
  call Hloop_CV_D(ntryL,G0H8(21),20,ex2(:),2,G1H4(175),m3h2x4(:,349),heltab2x8(:,:,395))
  call Hloop_DV_C(ntryL,G1H8(42),20,ex2(:),G2H4(84),m3h2x4(:,350),heltab2x8(:,:,396))
call HGT_OLR(G1H8(217),1,1,8)
call HGT_invQ_OLR(G1H8(217),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(217),-9,wf4(:,3),9,G2H2(728),m3h4x2(:,47),heltab2x8(:,:,397))
  call Hloop_DV_C(ntryL,G1H8(219),20,ex2(:),G2H4(42),m3h2x4(:,351),heltab2x8(:,:,398))
  call Hloop_DV_C(ntryL,G1H8(220),20,ex2(:),G2H4(86),m3h2x4(:,352),heltab2x8(:,:,399))
  call Hloop_DV_C(ntryL,G0H8(20),20,ex2(:),G1H4(186),m3h2x4(:,353),heltab2x8(:,:,400))
  call Hloop_UV_W(ntryL,G1H8(221),20,ex2(:),2,G2H4(47),m3h2x4(:,354),heltab2x8(:,:,401))
call HGT_raise_alpha_OLR(G1H8(222),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(222),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(222),-9,wf4(:,3),9,G2H2(729),m3h4x2(:,48),heltab2x8(:,:,402))
call signflip_OLR(G2H2(729))
  call Hloop_UV_W(ntryL,G1H8(224),20,ex2(:),2,G2H4(69),m3h2x4(:,355),heltab2x8(:,:,403))
  call Hloop_UV_W(ntryL,G1H8(225),20,ex2(:),2,G2H4(52),m3h2x4(:,356),heltab2x8(:,:,404))
  call Hloop_UV_W(ntryL,G0H8(19),20,ex2(:),2,G1H4(191),m3h2x4(:,357),heltab2x8(:,:,405))
  call Hloop_CV_D(ntryL,G1H8(226),18,wf4(:,3),9,G2H2(730),m3h4x2(:,49),heltab2x8(:,:,406))
call HGT_OLR(G1H8(227),1,1,8)
call HGT_invQ_OLR(G1H8(227),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(227),-4,ex3(:),G2H4(70),m3h2x4(:,358),heltab2x8(:,:,407))
  call Hloop_CV_D(ntryL,G1H8(229),18,wf4(:,3),9,G2H2(731),m3h4x2(:,50),heltab2x8(:,:,408))
  call Hloop_CV_D(ntryL,G1H8(230),18,wf4(:,3),9,G2H2(732),m3h4x2(:,51),heltab2x8(:,:,409))
  call Hloop_CV_D(ntryL,G0H8(30),18,wf4(:,3),9,G1H2(40),m3h4x2(:,52),heltab2x8(:,:,410))
  call Hloop_DV_C(ntryL,G1H8(231),18,wf4(:,3),G2H2(733),m3h4x2(:,53),heltab2x8(:,:,411))
call HGT_OLR(G1H8(232),1,1,8)
call HGT_invQ_OLR(G1H8(232),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(232),-4,ex3(:),4,G2H4(57),m3h2x4(:,359),heltab2x8(:,:,412))
  call Hloop_DV_C(ntryL,G1H8(234),18,wf4(:,3),G2H2(734),m3h4x2(:,54),heltab2x8(:,:,413))
  call Hloop_DV_C(ntryL,G1H8(235),18,wf4(:,3),G2H2(735),m3h4x2(:,55),heltab2x8(:,:,414))
  call Hloop_DV_C(ntryL,G0H8(29),18,wf4(:,3),G1H2(274),m3h4x2(:,56),heltab2x8(:,:,415))
  call Hloop_UV_W(ntryL,G1H8(236),18,wf4(:,3),9,G2H2(736),m3h4x2(:,57),heltab2x8(:,:,416))
call HGT_raise_alpha_OLR(G1H8(237),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(237),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(237),-4,ex3(:),4,G2H4(71),m3h2x4(:,360),heltab2x8(:,:,417))
call signflip_OLR(G2H4(71))
  call Hloop_UV_W(ntryL,G1H8(239),18,wf4(:,3),9,G2H2(737),m3h4x2(:,58),heltab2x8(:,:,418))
  call Hloop_UV_W(ntryL,G1H8(240),18,wf4(:,3),9,G2H2(738),m3h4x2(:,59),heltab2x8(:,:,419))
  call Hloop_UV_W(ntryL,G0H8(28),18,wf4(:,3),9,G1H2(279),m3h4x2(:,60),heltab2x8(:,:,420))
  call Hloop_DV_C(ntryL,G1H8(241),17,ex3(:),G2H4(62),m3h2x4(:,361),heltab2x8(:,:,421))
call HGT_OLR(G1H8(242),1,1,8)
call HGT_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(242),-10,wf4(:,6),10,G2H2(739),m3h4x2(:,61),heltab2x8(:,:,422))
  call Hloop_DV_C(ntryL,G1H8(244),17,ex3(:),G2H4(67),m3h2x4(:,362),heltab2x8(:,:,423))
  call Hloop_DV_C(ntryL,G1H8(245),17,ex3(:),G2H4(72),m3h2x4(:,363),heltab2x8(:,:,424))
  call Hloop_DV_C(ntryL,G0H8(3),17,ex3(:),G1H4(195),m3h2x4(:,364),heltab2x8(:,:,425))
  call Hloop_CV_D(ntryL,G1H8(246),17,ex3(:),4,G2H4(77),m3h2x4(:,365),heltab2x8(:,:,426))
call HGT_OLR(G1H8(247),1,1,8)
call HGT_invQ_OLR(G1H8(247),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(247),-10,wf4(:,6),G2H2(740),m3h4x2(:,62),heltab2x8(:,:,427))
  call Hloop_CV_D(ntryL,G1H8(249),17,ex3(:),4,G2H4(82),m3h2x4(:,366),heltab2x8(:,:,428))
  call Hloop_CV_D(ntryL,G1H8(250),17,ex3(:),4,G2H4(87),m3h2x4(:,367),heltab2x8(:,:,429))
  call Hloop_CV_D(ntryL,G0H8(2),17,ex3(:),4,G1H4(211),m3h2x4(:,368),heltab2x8(:,:,430))
  call Hloop_UV_W(ntryL,G1H8(251),17,ex3(:),4,G2H4(92),m3h2x4(:,369),heltab2x8(:,:,431))
call HGT_raise_alpha_OLR(G1H8(252),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(252),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(252),-10,wf4(:,6),10,G2H2(741),m3h4x2(:,63),heltab2x8(:,:,432))
call signflip_OLR(G2H2(741))
  call Hloop_UV_W(ntryL,G1H8(254),17,ex3(:),4,G2H4(97),m3h2x4(:,370),heltab2x8(:,:,433))
  call Hloop_UV_W(ntryL,G1H8(255),17,ex3(:),4,G2H4(102),m3h2x4(:,371),heltab2x8(:,:,434))
  call Hloop_UV_W(ntryL,G0H8(1),17,ex3(:),4,G1H4(227),m3h2x4(:,372),heltab2x8(:,:,435))
  call Hloop_CV_D(ntryL,G1H8(256),20,ex1(:),1,G2H4(107),m3h2x4(:,373),heltab2x8(:,:,436))
call HGT_OLR(G1H8(257),1,1,8)
call HGT_invQ_OLR(G1H8(257),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(257),-10,wf4(:,6),G2H2(742),m3h4x2(:,64),heltab2x8(:,:,437))
  call Hloop_CV_D(ntryL,G1H8(259),20,ex1(:),1,G2H4(108),m3h2x4(:,374),heltab2x8(:,:,438))
  call Hloop_CV_D(ntryL,G1H8(260),20,ex1(:),1,G2H4(112),m3h2x4(:,375),heltab2x8(:,:,439))
  call Hloop_CV_D(ntryL,G0H8(6),20,ex1(:),1,G1H4(243),m3h2x4(:,376),heltab2x8(:,:,440))
  call Hloop_DV_C(ntryL,G1H8(261),20,ex1(:),G2H4(113),m3h2x4(:,377),heltab2x8(:,:,441))
call HGT_OLR(G1H8(262),1,1,8)
call HGT_invQ_OLR(G1H8(262),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(262),-10,wf4(:,6),10,G2H2(743),m3h4x2(:,65),heltab2x8(:,:,442))
  call Hloop_DV_C(ntryL,G1H8(264),20,ex1(:),G2H4(117),m3h2x4(:,378),heltab2x8(:,:,443))
  call Hloop_DV_C(ntryL,G1H8(265),20,ex1(:),G2H4(118),m3h2x4(:,379),heltab2x8(:,:,444))
  call Hloop_DV_C(ntryL,G0H8(5),20,ex1(:),G1H4(259),m3h2x4(:,380),heltab2x8(:,:,445))
  call Hloop_UV_W(ntryL,G1H8(266),20,ex1(:),1,G2H4(122),m3h2x4(:,381),heltab2x8(:,:,446))
call HGT_raise_alpha_OLR(G1H8(267),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(267),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(267),-10,wf4(:,6),10,G2H2(744),m3h4x2(:,66),heltab2x8(:,:,447))
call signflip_OLR(G2H2(744))
  call Hloop_UV_W(ntryL,G1H8(269),20,ex1(:),1,G2H4(127),m3h2x4(:,382),heltab2x8(:,:,448))
  call Hloop_UV_W(ntryL,G1H8(270),20,ex1(:),1,G2H4(132),m3h2x4(:,383),heltab2x8(:,:,449))
  call Hloop_UV_W(ntryL,G0H8(4),20,ex1(:),1,G1H4(275),m3h2x4(:,384),heltab2x8(:,:,450))
  call Hloop_CV_D(ntryL,G1H8(271),17,wf4(:,6),10,G2H2(745),m3h4x2(:,67),heltab2x8(:,:,451))
call HGT_OLR(G1H8(272),1,1,8)
call HGT_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(272),-4,ex3(:),G2H4(137),m3h2x4(:,385),heltab2x8(:,:,452))
  call Hloop_CV_D(ntryL,G1H8(274),17,wf4(:,6),10,G2H2(746),m3h4x2(:,68),heltab2x8(:,:,453))
  call Hloop_CV_D(ntryL,G1H8(275),17,wf4(:,6),10,G2H2(747),m3h4x2(:,69),heltab2x8(:,:,454))
  call Hloop_CV_D(ntryL,G0H8(9),17,wf4(:,6),10,G1H2(280),m3h4x2(:,70),heltab2x8(:,:,455))
  call Hloop_DV_C(ntryL,G1H8(276),17,wf4(:,6),G2H2(748),m3h4x2(:,71),heltab2x8(:,:,456))
call HGT_OLR(G1H8(277),1,1,8)
call HGT_invQ_OLR(G1H8(277),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(277),-4,ex3(:),4,G2H4(138),m3h2x4(:,386),heltab2x8(:,:,457))
  call Hloop_DV_C(ntryL,G1H8(279),17,wf4(:,6),G2H2(749),m3h4x2(:,72),heltab2x8(:,:,458))
  call Hloop_DV_C(ntryL,G1H8(280),17,wf4(:,6),G2H2(750),m3h4x2(:,73),heltab2x8(:,:,459))
  call Hloop_DV_C(ntryL,G0H8(8),17,wf4(:,6),G1H2(42),m3h4x2(:,74),heltab2x8(:,:,460))
  call Hloop_UV_W(ntryL,G1H8(281),17,wf4(:,6),10,G2H2(751),m3h4x2(:,75),heltab2x8(:,:,461))
call HGT_raise_alpha_OLR(G1H8(282),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(282),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(282),-4,ex3(:),4,G2H4(142),m3h2x4(:,387),heltab2x8(:,:,462))
call signflip_OLR(G2H4(142))
  call Hloop_UV_W(ntryL,G1H8(284),17,wf4(:,6),10,G2H2(752),m3h4x2(:,76),heltab2x8(:,:,463))
  call Hloop_UV_W(ntryL,G1H8(285),17,wf4(:,6),10,G2H2(753),m3h4x2(:,77),heltab2x8(:,:,464))
  call Hloop_UV_W(ntryL,G0H8(7),17,wf4(:,6),10,G1H2(284),m3h4x2(:,78),heltab2x8(:,:,465))
  call Hloop_DV_C(ntryL,G1H8(286),17,ex2(:),G2H4(143),m3h2x4(:,388),heltab2x8(:,:,466))
call HGT_OLR(G1H8(287),1,1,8)
call HGT_invQ_OLR(G1H8(287),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(287),-12,wf4(:,8),12,G2H2(754),m3h4x2(:,79),heltab2x8(:,:,467))
  call Hloop_DV_C(ntryL,G1H8(289),17,ex2(:),G2H4(147),m3h2x4(:,389),heltab2x8(:,:,468))
  call Hloop_DV_C(ntryL,G1H8(290),17,ex2(:),G2H4(148),m3h2x4(:,390),heltab2x8(:,:,469))
  call Hloop_DV_C(ntryL,G0H8(18),17,ex2(:),G1H4(291),m3h2x4(:,391),heltab2x8(:,:,470))
  call Hloop_CV_D(ntryL,G1H8(291),17,ex2(:),2,G2H4(152),m3h2x4(:,392),heltab2x8(:,:,471))
call HGT_OLR(G1H8(292),1,1,8)
call HGT_invQ_OLR(G1H8(292),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(292),-12,wf4(:,8),G2H2(755),m3h4x2(:,80),heltab2x8(:,:,472))
  call Hloop_CV_D(ntryL,G1H8(294),17,ex2(:),2,G2H4(153),m3h2x4(:,393),heltab2x8(:,:,473))
  call Hloop_CV_D(ntryL,G1H8(295),17,ex2(:),2,G2H4(157),m3h2x4(:,394),heltab2x8(:,:,474))
  call Hloop_CV_D(ntryL,G0H8(17),17,ex2(:),2,G1H4(307),m3h2x4(:,395),heltab2x8(:,:,475))
  call Hloop_UV_W(ntryL,G1H8(296),17,ex2(:),2,G2H4(158),m3h2x4(:,396),heltab2x8(:,:,476))
call HGT_raise_alpha_OLR(G1H8(297),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(297),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(297),-12,wf4(:,8),12,G2H2(756),m3h4x2(:,81),heltab2x8(:,:,477))
call signflip_OLR(G2H2(756))
  call Hloop_UV_W(ntryL,G1H8(299),17,ex2(:),2,G2H4(162),m3h2x4(:,397),heltab2x8(:,:,478))
  call Hloop_UV_W(ntryL,G1H8(300),17,ex2(:),2,G2H4(163),m3h2x4(:,398),heltab2x8(:,:,479))
  call Hloop_UV_W(ntryL,G0H8(16),17,ex2(:),2,G1H4(323),m3h2x4(:,399),heltab2x8(:,:,480))
  call Hloop_CV_D(ntryL,G1H8(301),18,ex1(:),1,G2H4(167),m3h2x4(:,400),heltab2x8(:,:,481))
call HGT_OLR(G1H8(302),1,1,8)
call HGT_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(302),-12,wf4(:,8),G2H2(757),m3h4x2(:,82),heltab2x8(:,:,482))
  call Hloop_CV_D(ntryL,G1H8(304),18,ex1(:),1,G2H4(168),m3h2x4(:,401),heltab2x8(:,:,483))
  call Hloop_CV_D(ntryL,G1H8(305),18,ex1(:),1,G2H4(172),m3h2x4(:,402),heltab2x8(:,:,484))
  call Hloop_CV_D(ntryL,G0H8(37),18,ex1(:),1,G1H4(339),m3h2x4(:,403),heltab2x8(:,:,485))
  call Hloop_DV_C(ntryL,G1H8(306),18,ex1(:),G2H4(173),m3h2x4(:,404),heltab2x8(:,:,486))
call HGT_OLR(G1H8(307),1,1,8)
call HGT_invQ_OLR(G1H8(307),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(307),-12,wf4(:,8),12,G2H2(758),m3h4x2(:,83),heltab2x8(:,:,487))
  call Hloop_DV_C(ntryL,G1H8(309),18,ex1(:),G2H4(177),m3h2x4(:,405),heltab2x8(:,:,488))
  call Hloop_DV_C(ntryL,G1H8(310),18,ex1(:),G2H4(178),m3h2x4(:,406),heltab2x8(:,:,489))
  call Hloop_DV_C(ntryL,G0H8(38),18,ex1(:),G1H4(355),m3h2x4(:,407),heltab2x8(:,:,490))
  call Hloop_UV_W(ntryL,G1H8(311),18,ex1(:),1,G2H4(21),m3h2x4(:,408),heltab2x8(:,:,491))
call HGT_raise_alpha_OLR(G1H8(312),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(312),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(312),-12,wf4(:,8),12,G2H2(759),m3h4x2(:,84),heltab2x8(:,:,492))
call signflip_OLR(G2H2(759))
  call Hloop_UV_W(ntryL,G1H8(314),18,ex1(:),1,G2H4(24),m3h2x4(:,409),heltab2x8(:,:,493))
  call Hloop_UV_W(ntryL,G1H8(315),18,ex1(:),1,G2H4(25),m3h2x4(:,410),heltab2x8(:,:,494))
  call Hloop_UV_W(ntryL,G0H8(39),18,ex1(:),1,G1H4(371),m3h2x4(:,411),heltab2x8(:,:,495))
  call Hloop_CV_D(ntryL,G1H8(316),17,wf4(:,8),12,G2H2(760),m3h4x2(:,85),heltab2x8(:,:,496))
call HGT_OLR(G1H8(317),1,1,8)
call HGT_invQ_OLR(G1H8(317),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(317),-2,ex2(:),G2H4(26),m3h2x4(:,412),heltab2x8(:,:,497))
  call Hloop_CV_D(ntryL,G1H8(319),17,wf4(:,8),12,G2H2(761),m3h4x2(:,86),heltab2x8(:,:,498))
  call Hloop_CV_D(ntryL,G1H8(320),17,wf4(:,8),12,G2H2(762),m3h4x2(:,87),heltab2x8(:,:,499))
  call Hloop_CV_D(ntryL,G0H8(40),17,wf4(:,8),12,G1H2(289),m3h4x2(:,88),heltab2x8(:,:,500))
  call Hloop_DV_C(ntryL,G1H8(321),17,wf4(:,8),G2H2(763),m3h4x2(:,89),heltab2x8(:,:,501))
call HGT_OLR(G1H8(322),1,1,8)
call HGT_invQ_OLR(G1H8(322),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(322),-2,ex2(:),2,G2H4(29),m3h2x4(:,413),heltab2x8(:,:,502))
  call Hloop_DV_C(ntryL,G1H8(324),17,wf4(:,8),G2H2(764),m3h4x2(:,90),heltab2x8(:,:,503))
  call Hloop_DV_C(ntryL,G1H8(325),17,wf4(:,8),G2H2(765),m3h4x2(:,91),heltab2x8(:,:,504))
  call Hloop_DV_C(ntryL,G0H8(41),17,wf4(:,8),G1H2(290),m3h4x2(:,92),heltab2x8(:,:,505))
  call Hloop_UV_W(ntryL,G1H8(326),17,wf4(:,8),12,G2H2(766),m3h4x2(:,93),heltab2x8(:,:,506))
call HGT_raise_alpha_OLR(G1H8(327),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(327),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(327),-2,ex2(:),2,G2H4(30),m3h2x4(:,414),heltab2x8(:,:,507))
call signflip_OLR(G2H4(30))
  call Hloop_UV_W(ntryL,G1H8(329),17,wf4(:,8),12,G2H2(767),m3h4x2(:,94),heltab2x8(:,:,508))
  call Hloop_UV_W(ntryL,G1H8(330),17,wf4(:,8),12,G2H2(768),m3h4x2(:,95),heltab2x8(:,:,509))
  call Hloop_UV_W(ntryL,G0H8(42),17,wf4(:,8),12,G1H2(44),m3h4x2(:,96),heltab2x8(:,:,510))
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(694),[G2H2(59),G2H2(3),G1H2(147),G1H2(77)])
call HGT_OLR(G2H2(5),1,1,2)
call HGT_invQ_OLR(G2H2(5),2,5,2)
call HGT_OLR(G2H2(5),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(696),[G2H2(64),G2H2(62),G2H2(8),G2H2(6),G1H2(153) &
    ,G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(15),G1H2(1)])
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(691),[G2H2(51),G2H2(11),G1H2(137),G1H2(87)])
call HGT_OLR(G2H2(13),1,1,2)
call HGT_invQ_OLR(G2H2(13),2,5,2)
call HGT_OLR(G2H2(13),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(693),[G2H2(56),G2H2(54),G2H2(16),G2H2(14),G1H2(143) &
    ,G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(250),[G1H2(13),G1H2(3)])
call HGT_lower_alpha_OLR(G2H2(18),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(18),2,5,2)
call HGT_lower_alpha_OLR(G2H2(18),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(697),[G2H2(354),G2H2(353),G2H2(352),G2H2(67),G2H2(19) &
    ,G1H2(157),G1H2(97)])
call HGT_lower_alpha_OLR(G2H2(21),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(21),2,5,2)
call HGT_lower_alpha_OLR(G2H2(21),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(699),[G2H2(72),G2H2(70),G2H2(24),G2H2(22),G1H2(163) &
    ,G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(254),[G1H2(17),G1H2(5)])
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(703),[G2H2(147),G2H2(27),G1H2(257),G1H2(107)])
call HGT_OLR(G2H2(29),1,1,2)
call HGT_invQ_OLR(G2H2(29),2,5,2)
call HGT_OLR(G2H2(29),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G2H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(705),[G2H2(152),G2H2(150),G2H2(32),G2H2(30),G1H2(263) &
    ,G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(259),[G1H2(37),G1H2(7)])
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(706),[G2H2(155),G2H2(35),G1H2(267),G1H2(117)])
call HGT_OLR(G2H2(37),1,1,2)
call HGT_invQ_OLR(G2H2(37),2,5,2)
call HGT_OLR(G2H2(37),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(708),[G2H2(160),G2H2(158),G2H2(40),G2H2(38),G1H2(273) &
    ,G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(260),[G1H2(39),G1H2(9)])
call HGT_lower_alpha_OLR(G2H2(42),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(42),2,5,2)
call HGT_lower_alpha_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(709),[G2H2(351),G2H2(350),G2H2(349),G2H2(163),G2H2(43) &
    ,G1H2(277),G1H2(127)])
call HGT_lower_alpha_OLR(G2H2(45),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(45),2,5,2)
call HGT_lower_alpha_OLR(G2H2(45),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(711),[G2H2(168),G2H2(166),G2H2(48),G2H2(46),G1H2(283) &
    ,G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(41),G1H2(11)])
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(403)])
call HGT_OLR(G2H2(53),1,1,2)
call HGT_invQ_OLR(G2H2(53),2,5,2)
call HGT_OLR(G2H2(53),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(406)])
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(411)])
call HGT_OLR(G2H2(61),1,1,2)
call HGT_invQ_OLR(G2H2(61),2,5,2)
call HGT_OLR(G2H2(61),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(414)])
call HGT_lower_alpha_OLR(G2H2(66),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(66),2,5,2)
call HGT_lower_alpha_OLR(G2H2(66),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(419)])
call HGT_lower_alpha_OLR(G2H2(69),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(69),2,5,2)
call HGT_lower_alpha_OLR(G2H2(69),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(427),[G1H2(135)])
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(730),[G2H2(179),G2H2(75),G1H2(297),G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G2H2(105),G1H2(141)])
call HGT_OLR(G2H2(77),1,1,2)
call HGT_invQ_OLR(G2H2(77),2,5,2)
call HGT_OLR(G2H2(77),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(732),[G2H2(184),G2H2(182),G2H2(80),G2H2(78),G1H2(303) &
    ,G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(45),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(435),[G1H2(145)])
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(733),[G2H2(171),G2H2(83),G1H2(287),G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(121),G1H2(151)])
call HGT_OLR(G2H2(85),1,1,2)
call HGT_invQ_OLR(G2H2(85),2,5,2)
call HGT_OLR(G2H2(85),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(735),[G2H2(176),G2H2(174),G2H2(88),G2H2(86),G1H2(293) &
    ,G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(274),[G1H2(43),G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(443),[G1H2(155)])
call HGT_lower_alpha_OLR(G2H2(90),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(90),2,5,2)
call HGT_lower_alpha_OLR(G2H2(90),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(736),[G2H2(348),G2H2(347),G2H2(346),G2H2(187),G2H2(91) &
    ,G1H2(307),G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(446),[G2H2(137),G1H2(161)])
call HGT_lower_alpha_OLR(G2H2(93),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(93),2,5,2)
call HGT_lower_alpha_OLR(G2H2(93),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G2H2(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(738),[G2H2(192),G2H2(190),G2H2(96),G2H2(94),G1H2(313) &
    ,G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(47),G1H2(23)])
call HGT_OLR(G2H2(98),1,1,2)
call HGT_invQ_OLR(G2H2(98),2,5,2)
call HGT_OLR(G2H2(98),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(718),[G2H2(195),G2H2(99),G1H2(317),G1H2(197)])
call HGT_OLR(G2H2(101),1,1,2)
call HGT_invQ_OLR(G2H2(101),2,5,2)
call HGT_OLR(G2H2(101),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(720),[G2H2(200),G2H2(198),G2H2(104),G2H2(102),G1H2(323) &
    ,G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(49),G1H2(25)])
call HGT_OLR(G2H2(106),1,1,2)
call HGT_invQ_OLR(G2H2(106),2,5,2)
call HGT_OLR(G2H2(106),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(715),[G2H2(203),G2H2(107),G1H2(327),G1H2(207)])
call HGT_OLR(G2H2(109),1,1,2)
call HGT_invQ_OLR(G2H2(109),2,5,2)
call HGT_OLR(G2H2(109),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(458)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(717),[G2H2(208),G2H2(206),G2H2(112),G2H2(110),G1H2(333) &
    ,G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(264),[G1H2(51),G1H2(27)])
call HGT_lower_alpha_OLR(G2H2(114),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(114),2,5,2)
call HGT_lower_alpha_OLR(G2H2(114),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(721),[G2H2(345),G2H2(344),G2H2(343),G2H2(211),G2H2(115) &
    ,G1H2(337),G1H2(217)])
call HGT_lower_alpha_OLR(G2H2(117),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(117),2,5,2)
call HGT_lower_alpha_OLR(G2H2(117),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(723),[G2H2(216),G2H2(214),G2H2(120),G2H2(118),G1H2(343) &
    ,G1H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(270),[G1H2(53),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(463),[G1H2(75)])
call HGT_OLR(G2H2(122),1,1,2)
call HGT_invQ_OLR(G2H2(122),2,5,2)
call HGT_OLR(G2H2(122),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G2H2(463)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(748),[G2H2(243),G2H2(123),G1H2(377),G1H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(466),[G2H2(9),G1H2(81)])
call HGT_OLR(G2H2(125),1,1,2)
call HGT_invQ_OLR(G2H2(125),2,5,2)
call HGT_OLR(G2H2(125),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(750),[G2H2(248),G2H2(246),G2H2(128),G2H2(126),G1H2(383) &
    ,G1H2(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(61),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(467),[G1H2(85)])
call HGT_OLR(G2H2(130),1,1,2)
call HGT_invQ_OLR(G2H2(130),2,5,2)
call HGT_OLR(G2H2(130),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G2H2(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(745),[G2H2(251),G2H2(131),G1H2(387),G1H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(470),[G2H2(25),G1H2(91)])
call HGT_OLR(G2H2(133),1,1,2)
call HGT_invQ_OLR(G2H2(133),2,5,2)
call HGT_OLR(G2H2(133),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(747),[G2H2(256),G2H2(254),G2H2(136),G2H2(134),G1H2(393) &
    ,G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(280),[G1H2(63),G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(471),[G1H2(95)])
call HGT_lower_alpha_OLR(G2H2(138),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(138),2,5,2)
call HGT_lower_alpha_OLR(G2H2(138),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G2H2(471)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(751),[G2H2(342),G2H2(341),G2H2(340),G2H2(259),G2H2(139) &
    ,G1H2(397),G1H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(474),[G2H2(41),G1H2(101)])
call HGT_lower_alpha_OLR(G2H2(141),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(141),2,5,2)
call HGT_lower_alpha_OLR(G2H2(141),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(753),[G2H2(264),G2H2(262),G2H2(144),G2H2(142),G1H2(403) &
    ,G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(284),[G1H2(65),G1H2(35)])
call HGT_OLR(G2H2(146),1,1,2)
call HGT_invQ_OLR(G2H2(146),2,5,2)
call HGT_OLR(G2H2(146),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(475)])
call HGT_OLR(G2H2(149),1,1,2)
call HGT_invQ_OLR(G2H2(149),2,5,2)
call HGT_OLR(G2H2(149),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G2H2(478)])
call HGT_OLR(G2H2(154),1,1,2)
call HGT_invQ_OLR(G2H2(154),2,5,2)
call HGT_OLR(G2H2(154),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(154),[G2H2(479)])
call HGT_OLR(G2H2(157),1,1,2)
call HGT_invQ_OLR(G2H2(157),2,5,2)
call HGT_OLR(G2H2(157),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G2H2(482)])
call HGT_lower_alpha_OLR(G2H2(162),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(162),2,5,2)
call HGT_lower_alpha_OLR(G2H2(162),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(483)])
call HGT_lower_alpha_OLR(G2H2(165),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(165),2,5,2)
call HGT_lower_alpha_OLR(G2H2(165),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G2H2(486)])
call HGT_OLR(G2H2(170),1,1,2)
call HGT_invQ_OLR(G2H2(170),2,5,2)
call HGT_OLR(G2H2(170),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(487)])
call HGT_OLR(G2H2(173),1,1,2)
call HGT_invQ_OLR(G2H2(173),2,5,2)
call HGT_OLR(G2H2(173),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(173),[G2H2(490)])
call HGT_OLR(G2H2(178),1,1,2)
call HGT_invQ_OLR(G2H2(178),2,5,2)
call HGT_OLR(G2H2(178),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G2H2(495)])
call HGT_OLR(G2H2(181),1,1,2)
call HGT_invQ_OLR(G2H2(181),2,5,2)
call HGT_OLR(G2H2(181),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G2H2(498)])
call HGT_lower_alpha_OLR(G2H2(186),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(186),2,5,2)
call HGT_lower_alpha_OLR(G2H2(186),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G2H2(503)])
call HGT_lower_alpha_OLR(G2H2(189),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(189),2,5,2)
call HGT_lower_alpha_OLR(G2H2(189),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G2H2(506)])
call HGT_OLR(G2H2(194),1,1,2)
call HGT_invQ_OLR(G2H2(194),2,5,2)
call HGT_OLR(G2H2(194),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G2H2(511)])
call HGT_OLR(G2H2(197),1,1,2)
call HGT_invQ_OLR(G2H2(197),2,5,2)
call HGT_OLR(G2H2(197),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G2H2(514)])
call HGT_OLR(G2H2(202),1,1,2)
call HGT_invQ_OLR(G2H2(202),2,5,2)
call HGT_OLR(G2H2(202),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(202),[G2H2(515)])
call HGT_OLR(G2H2(205),1,1,2)
call HGT_invQ_OLR(G2H2(205),2,5,2)
call HGT_OLR(G2H2(205),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G2H2(518)])
call HGT_lower_alpha_OLR(G2H2(210),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(210),2,5,2)
call HGT_lower_alpha_OLR(G2H2(210),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(210),[G2H2(519)])
call HGT_lower_alpha_OLR(G2H2(213),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(213),2,5,2)
call HGT_lower_alpha_OLR(G2H2(213),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G2H2(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(523),[G1H2(115)])
call HGT_OLR(G2H2(218),1,1,2)
call HGT_invQ_OLR(G2H2(218),2,5,2)
call HGT_OLR(G2H2(218),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(218),[G2H2(523)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(763),[G2H2(267),G2H2(219),G1H2(407),G1H2(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(526),[G2H2(73),G1H2(121)])
call HGT_OLR(G2H2(221),1,1,2)
call HGT_invQ_OLR(G2H2(221),2,5,2)
call HGT_OLR(G2H2(221),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G2H2(526)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(765),[G2H2(272),G2H2(270),G2H2(224),G2H2(222),G1H2(413) &
    ,G1H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(290),[G1H2(67),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(531),[G1H2(105)])
call HGT_OLR(G2H2(226),1,1,2)
call HGT_invQ_OLR(G2H2(226),2,5,2)
call HGT_OLR(G2H2(226),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(760),[G2H2(275),G2H2(227),G1H2(417),G1H2(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(534),[G2H2(57),G1H2(111)])
call HGT_OLR(G2H2(229),1,1,2)
call HGT_invQ_OLR(G2H2(229),2,5,2)
call HGT_OLR(G2H2(229),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(229),[G2H2(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(762),[G2H2(280),G2H2(278),G2H2(232),G2H2(230),G1H2(423) &
    ,G1H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(289),[G1H2(69),G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(539),[G1H2(125)])
call HGT_lower_alpha_OLR(G2H2(234),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(234),2,5,2)
call HGT_lower_alpha_OLR(G2H2(234),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G2H2(539)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(766),[G2H2(339),G2H2(338),G2H2(337),G2H2(283),G2H2(235) &
    ,G1H2(427),G1H2(367)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(542),[G2H2(89),G1H2(131)])
call HGT_lower_alpha_OLR(G2H2(237),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(237),2,5,2)
call HGT_lower_alpha_OLR(G2H2(237),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G2H2(542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(768),[G2H2(288),G2H2(286),G2H2(240),G2H2(238),G1H2(433) &
    ,G1H2(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(71),G1H2(59)])
call HGT_OLR(G2H2(242),1,1,2)
call HGT_invQ_OLR(G2H2(242),2,5,2)
call HGT_OLR(G2H2(242),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G2H2(547)])
call HGT_OLR(G2H2(245),1,1,2)
call HGT_invQ_OLR(G2H2(245),2,5,2)
call HGT_OLR(G2H2(245),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G2H2(550)])
call HGT_OLR(G2H2(250),1,1,2)
call HGT_invQ_OLR(G2H2(250),2,5,2)
call HGT_OLR(G2H2(250),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(250),[G2H2(555)])
call HGT_OLR(G2H2(253),1,1,2)
call HGT_invQ_OLR(G2H2(253),2,5,2)
call HGT_OLR(G2H2(253),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(253),[G2H2(558)])
call HGT_lower_alpha_OLR(G2H2(258),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(258),2,5,2)
call HGT_lower_alpha_OLR(G2H2(258),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G2H2(563)])
call HGT_lower_alpha_OLR(G2H2(261),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(261),2,5,2)
call HGT_lower_alpha_OLR(G2H2(261),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(261),[G2H2(566)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(571),[G1H2(175)])
call HGT_OLR(G2H2(266),1,1,2)
call HGT_invQ_OLR(G2H2(266),2,5,2)
call HGT_OLR(G2H2(266),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(266),[G2H2(571)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(574),[G2H2(169),G1H2(181)])
call HGT_OLR(G2H2(269),1,1,2)
call HGT_invQ_OLR(G2H2(269),2,5,2)
call HGT_OLR(G2H2(269),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(269),[G2H2(574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(579),[G1H2(165)])
call HGT_OLR(G2H2(274),1,1,2)
call HGT_invQ_OLR(G2H2(274),2,5,2)
call HGT_OLR(G2H2(274),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(274),[G2H2(579)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(582),[G2H2(153),G1H2(171)])
call HGT_OLR(G2H2(277),1,1,2)
call HGT_invQ_OLR(G2H2(277),2,5,2)
call HGT_OLR(G2H2(277),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(277),[G2H2(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(587),[G1H2(185)])
call HGT_lower_alpha_OLR(G2H2(282),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(282),2,5,2)
call HGT_lower_alpha_OLR(G2H2(282),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(282),[G2H2(587)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(590),[G2H2(185),G1H2(191)])
call HGT_lower_alpha_OLR(G2H2(285),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(285),2,5,2)
call HGT_lower_alpha_OLR(G2H2(285),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G2H2(590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(359),[G1H2(316),G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(362),[G2H2(12),G1H2(322),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(367),[G1H2(326),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(370),[G2H2(28),G1H2(332),G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(375),[G1H2(336),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(378),[G2H2(44),G1H2(342),G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(383),[G1H2(206),G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(386),[G2H2(60),G1H2(212),G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(391),[G1H2(196),G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(394),[G2H2(76),G1H2(202),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(399),[G1H2(216),G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(402),[G2H2(92),G1H2(222),G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(407),[G1H2(256),G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(410),[G2H2(108),G1H2(262),G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(415),[G1H2(266),G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(418),[G2H2(124),G1H2(272),G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(423),[G1H2(276),G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(426),[G2H2(140),G1H2(282),G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(431),[G1H2(236),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(434),[G2H2(156),G1H2(242),G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(439),[G1H2(226),G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(442),[G2H2(172),G1H2(232),G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(447),[G1H2(246),G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(450),[G2H2(188),G1H2(252),G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(595),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(598),[G2H2(196),G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(599),[G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(602),[G2H2(204),G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(603),[G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(606),[G2H2(212),G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(607),[G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(610),[G2H2(220),G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(611),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(614),[G2H2(228),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(615),[G1H2(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(618),[G2H2(236),G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(619),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(622),[G2H2(244),G1H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(623),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(626),[G2H2(252),G1H2(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(627),[G1H2(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(630),[G2H2(260),G1H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(631),[G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(491),[G1H2(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(634),[G2H2(273),G1H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(494),[G2H2(276),G1H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(635),[G1H2(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(499),[G1H2(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(638),[G2H2(289),G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(502),[G2H2(290),G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(639),[G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(507),[G1H2(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(642),[G2H2(293),G1H2(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(510),[G2H2(294),G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(643),[G1H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(646),[G2H2(296),G1H2(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(647),[G1H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(650),[G2H2(298),G1H2(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(651),[G1H2(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(654),[G2H2(300),G1H2(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(655),[G1H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(527),[G1H2(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(658),[G2H2(303),G1H2(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(530),[G2H2(304),G1H2(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(659),[G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(535),[G1H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(662),[G2H2(307),G1H2(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(538),[G2H2(308),G1H2(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(663),[G1H2(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(543),[G1H2(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(666),[G2H2(311),G1H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(546),[G2H2(312),G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(667),[G1H2(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(551),[G1H2(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(670),[G2H2(315),G1H2(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(554),[G2H2(316),G1H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(671),[G1H2(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(559),[G1H2(386)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(674),[G2H2(319),G1H2(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(562),[G2H2(320),G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(675),[G1H2(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(567),[G1H2(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(678),[G2H2(323),G1H2(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(570),[G2H2(324),G1H2(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(679),[G1H2(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(575),[G1H2(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(682),[G2H2(327),G1H2(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(578),[G2H2(328),G1H2(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(683),[G1H2(415)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(583),[G1H2(416)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(686),[G2H2(331),G1H2(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(586),[G2H2(332),G1H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(687),[G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(591),[G1H2(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(690),[G2H2(335),G1H2(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(594),[G2H2(336),G1H2(432)])
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(47),mass4set(:,1),  & 
G1H2(294),G1H2(299),G1H2(300),G1H2(46),G1H2(304),2)
  call HG1shiftOLR(G1H2(299),2,2)
  call Hotf_4pt_reduction(G2H2(694),RedSet_4(1),mass4set(:,1),  & 
G1H2(309),G1H2(310),G1H2(48),G1H2(314),G1H2(319),2)
  call HG1shiftOLR(G1H2(310),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(5),29,ex2(:),G3tensor(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(696),23,ex4(:),G3tensor(2),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(36),23,ex4(:),G2tensor(41),m3h2x1(:,183),heltab2x2(:,:,183))
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(7),0,ex2(:),G3tensor(3),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(47),mass4set(:,1),  & 
G1H2(320),G1H2(50),G1H2(324),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(50),2,2)
  call Hotf_4pt_reduction(G2H2(691),RedSet_4(1),mass4set(:,1),  & 
G1H2(52),G1H2(334),G1H2(339),G1H2(340),G1H2(54),2)
  call HG1shiftOLR(G1H2(334),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(13),29,ex2(:),2,G3tensor(4),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(693),23,ex4(:),8,G3tensor(5),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(250),23,ex4(:),8,G2tensor(37),m3h2x1(:,187),heltab2x2(:,:,187))
call HGT_OLR(G2H2(15),1,1,2)
call HGT_invQ_OLR(G2H2(15),2,5,2)
call HGT_OLR(G2H2(15),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(15),0,ex2(:),2,G3tensor(6),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(47),mass4set(:,1),  & 
G1H2(344),G1H2(349),G1H2(350),G1H2(56),G1H2(354),2)
  call HG1shiftOLR(G1H2(349),2,2)
  call Hotf_4pt_reduction(G2H2(697),RedSet_4(1),mass4set(:,1),  & 
G1H2(359),G1H2(360),G1H2(58),G1H2(364),G1H2(369),2)
  call HG1shiftOLR(G1H2(360),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(21),29,ex2(:),2,G3tensor(7),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(699),23,ex4(:),8,G3tensor(8),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(254),23,ex4(:),8,G2tensor(53),m3h2x1(:,191),heltab2x2(:,:,191))
call HGT_lower_alpha_OLR(G2H2(23),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(23),2,5,2)
call HGT_lower_alpha_OLR(G2H2(23),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(23),0,ex2(:),2,G3tensor(9),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(48),mass4set(:,1),  & 
G1H2(370),G1H2(60),G1H2(374),G1H2(379),G1H2(380),2)
  call HG1shiftOLR(G1H2(60),4,2)
  call Hotf_4pt_reduction(G2H2(703),RedSet_4(3),mass4set(:,1),  & 
G1H2(62),G1H2(384),G1H2(389),G1H2(390),G1H2(64),2)
  call HG1shiftOLR(G1H2(384),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(29),27,ex3(:),4,G3tensor(10),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(705),23,ex4(:),8,G3tensor(11),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(259),23,ex4(:),8,G2tensor(49),m3h2x1(:,195),heltab2x2(:,:,195))
call HGT_OLR(G2H2(31),1,1,2)
call HGT_invQ_OLR(G2H2(31),2,5,2)
call HGT_OLR(G2H2(31),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(31),0,ex3(:),4,G3tensor(12),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(48),mass4set(:,1),  & 
G1H2(394),G1H2(399),G1H2(400),G1H2(66),G1H2(404),2)
  call HG1shiftOLR(G1H2(399),4,2)
  call Hotf_4pt_reduction(G2H2(706),RedSet_4(3),mass4set(:,1),  & 
G1H2(409),G1H2(410),G1H2(68),G1H2(414),G1H2(419),2)
  call HG1shiftOLR(G1H2(410),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(37),27,ex3(:),G3tensor(13),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(708),23,ex4(:),G3tensor(14),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(260),23,ex4(:),G2tensor(65),m3h2x1(:,199),heltab2x2(:,:,199))
call HGT_OLR(G2H2(39),1,1,2)
call HGT_invQ_OLR(G2H2(39),2,5,2)
call HGT_OLR(G2H2(39),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(39),0,ex3(:),G3tensor(15),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(48),mass4set(:,1),  & 
G1H2(420),G1H2(70),G1H2(424),G1H2(429),G1H2(430),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hotf_4pt_reduction(G2H2(709),RedSet_4(3),mass4set(:,1),  & 
G1H2(147),G1H2(77),G1H2(153),G1H2(83),G1H2(15),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(45),27,ex3(:),4,G3tensor(16),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(711),23,ex4(:),8,G3tensor(17),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(38),23,ex4(:),8,G2tensor(61),m3h2x1(:,203),heltab2x2(:,:,203))
call HGT_lower_alpha_OLR(G2H2(47),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(47),2,5,2)
call HGT_lower_alpha_OLR(G2H2(47),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(47),0,ex3(:),4,G3tensor(18),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(49),mass4set(:,1),  & 
G1H2(1),G1H2(137),G1H2(87),G1H2(143),G1H2(93),2)
  call HG1shiftOLR(G1H2(137),1,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(53),30,ex1(:),1,G3tensor(19),m3h2x1(:,205),heltab2x2(:,:,205))
call HGT_OLR(G2H2(55),1,1,2)
call HGT_invQ_OLR(G2H2(55),2,5,2)
call HGT_OLR(G2H2(55),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(55),0,ex1(:),1,G3tensor(20),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(49),mass4set(:,1),  & 
G1H2(13),G1H2(3),G1H2(157),G1H2(97),G1H2(163),2)
  call HG1shiftOLR(G1H2(3),1,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(61),30,ex1(:),G3tensor(21),m3h2x1(:,207),heltab2x2(:,:,207))
call HGT_OLR(G2H2(63),1,1,2)
call HGT_invQ_OLR(G2H2(63),2,5,2)
call HGT_OLR(G2H2(63),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(63),0,ex1(:),G3tensor(22),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(49),mass4set(:,1),  & 
G1H2(103),G1H2(17),G1H2(5),G1H2(257),G1H2(107),2)
  call HG1shiftOLR(G1H2(17),1,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(69),30,ex1(:),1,G3tensor(23),m3h2x1(:,209),heltab2x2(:,:,209))
call HGT_lower_alpha_OLR(G2H2(71),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(71),2,5,2)
call HGT_lower_alpha_OLR(G2H2(71),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(71),0,ex1(:),1,G3tensor(24),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(21),mass4set(:,1),  & 
G1H2(263),G1H2(113),G1H2(37),G1H2(7),G1H2(267),2)
  call HG1shiftOLR(G1H2(113),8,2)
  call Hotf_4pt_reduction(G2H2(730),RedSet_4(6),mass4set(:,1),  & 
G1H2(117),G1H2(273),G1H2(123),G1H2(39),G1H2(9),2)
  call HG1shiftOLR(G1H2(273),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(77),23,ex4(:),8,G3tensor(25),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(732),27,ex3(:),4,G3tensor(26),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(40),27,ex3(:),4,G2tensor(77),m3h2x1(:,213),heltab2x2(:,:,213))
call HGT_OLR(G2H2(79),1,1,2)
call HGT_invQ_OLR(G2H2(79),2,5,2)
call HGT_OLR(G2H2(79),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(79),0,ex4(:),8,G3tensor(27),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(21),mass4set(:,1),  & 
G1H2(277),G1H2(127),G1H2(283),G1H2(133),G1H2(41),2)
  call HG1shiftOLR(G1H2(127),8,2)
  call Hotf_4pt_reduction(G2H2(733),RedSet_4(6),mass4set(:,1),  & 
G1H2(11),G1H2(135),G1H2(297),G1H2(167),G1H2(141),2)
  call HG1shiftOLR(G1H2(135),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(85),23,ex4(:),G3tensor(28),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(735),27,ex3(:),G3tensor(29),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(274),27,ex3(:),G2tensor(73),m3h2x1(:,217),heltab2x2(:,:,217))
call HGT_OLR(G2H2(87),1,1,2)
call HGT_invQ_OLR(G2H2(87),2,5,2)
call HGT_OLR(G2H2(87),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(87),0,ex4(:),G3tensor(30),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(21),mass4set(:,1),  & 
G1H2(303),G1H2(173),G1H2(45),G1H2(19),G1H2(145),2)
  call HG1shiftOLR(G1H2(173),8,2)
  call Hotf_4pt_reduction(G2H2(736),RedSet_4(6),mass4set(:,1),  & 
G1H2(287),G1H2(177),G1H2(151),G1H2(293),G1H2(183),2)
  call HG1shiftOLR(G1H2(177),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(93),23,ex4(:),8,G3tensor(31),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(738),27,ex3(:),4,G3tensor(32),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(279),27,ex3(:),4,G2tensor(89),m3h2x1(:,221),heltab2x2(:,:,221))
call HGT_lower_alpha_OLR(G2H2(95),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(95),2,5,2)
call HGT_lower_alpha_OLR(G2H2(95),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(95),0,ex4(:),8,G3tensor(33),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(50),mass4set(:,1),  & 
G1H2(43),G1H2(21),G1H2(155),G1H2(307),G1H2(187),2)
  call HG1shiftOLR(G1H2(21),4,2)
  call Hotf_4pt_reduction(G2H2(718),RedSet_4(7),mass4set(:,1),  & 
G1H2(161),G1H2(313),G1H2(193),G1H2(47),G1H2(23),2)
  call HG1shiftOLR(G1H2(313),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(101),27,ex3(:),G3tensor(34),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(720),23,ex4(:),G3tensor(35),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(269),23,ex4(:),G2tensor(85),m3h2x1(:,225),heltab2x2(:,:,225))
call HGT_OLR(G2H2(103),1,1,2)
call HGT_invQ_OLR(G2H2(103),2,5,2)
call HGT_OLR(G2H2(103),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(103),0,ex3(:),G3tensor(36),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(50),mass4set(:,1),  & 
G1H2(317),G1H2(197),G1H2(323),G1H2(203),G1H2(49),2)
  call HG1shiftOLR(G1H2(197),4,2)
  call Hotf_4pt_reduction(G2H2(715),RedSet_4(7),mass4set(:,1),  & 
G1H2(25),G1H2(327),G1H2(207),G1H2(333),G1H2(213),2)
  call HG1shiftOLR(G1H2(327),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(109),27,ex3(:),4,G3tensor(37),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(717),23,ex4(:),8,G3tensor(38),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(264),23,ex4(:),8,G2tensor(101),m3h2x1(:,229),heltab2x2(:,:,229))
call HGT_OLR(G2H2(111),1,1,2)
call HGT_invQ_OLR(G2H2(111),2,5,2)
call HGT_OLR(G2H2(111),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(111),0,ex3(:),4,G3tensor(39),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(50),mass4set(:,1),  & 
G1H2(51),G1H2(27),G1H2(337),G1H2(217),G1H2(343),2)
  call HG1shiftOLR(G1H2(27),4,2)
  call Hotf_4pt_reduction(G2H2(721),RedSet_4(7),mass4set(:,1),  & 
G1H2(223),G1H2(53),G1H2(29),G1H2(75),G1H2(377),2)
  call HG1shiftOLR(G1H2(53),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(117),27,ex3(:),4,G3tensor(40),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(723),23,ex4(:),8,G3tensor(41),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(270),23,ex4(:),8,G2tensor(97),m3h2x1(:,233),heltab2x2(:,:,233))
call HGT_lower_alpha_OLR(G2H2(119),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(119),2,5,2)
call HGT_lower_alpha_OLR(G2H2(119),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(119),0,ex3(:),4,G3tensor(42),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hotf_4pt_reduction(G2H2(122),RedSet_4(15),mass4set(:,1),  & 
G1H2(227),G1H2(81),G1H2(383),G1H2(233),G1H2(61),2)
  call HG1shiftOLR(G1H2(81),8,2)
  call Hotf_4pt_reduction(G2H2(748),RedSet_4(9),mass4set(:,1),  & 
G1H2(31),G1H2(85),G1H2(387),G1H2(237),G1H2(91),2)
  call HG1shiftOLR(G1H2(85),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(125),23,ex4(:),G3tensor(43),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(750),27,ex3(:),G3tensor(44),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(42),27,ex3(:),G2tensor(113),m3h2x1(:,237),heltab2x2(:,:,237))
call HGT_OLR(G2H2(127),1,1,2)
call HGT_invQ_OLR(G2H2(127),2,5,2)
call HGT_OLR(G2H2(127),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(127),0,ex4(:),G3tensor(45),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hotf_4pt_reduction(G2H2(130),RedSet_4(15),mass4set(:,1),  & 
G1H2(393),G1H2(243),G1H2(63),G1H2(33),G1H2(95),2)
  call HG1shiftOLR(G1H2(243),8,2)
  call Hotf_4pt_reduction(G2H2(745),RedSet_4(9),mass4set(:,1),  & 
G1H2(397),G1H2(247),G1H2(101),G1H2(403),G1H2(253),2)
  call HG1shiftOLR(G1H2(247),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(133),23,ex4(:),8,G3tensor(46),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(747),27,ex3(:),4,G3tensor(47),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(280),27,ex3(:),4,G2tensor(109),m3h2x1(:,241),heltab2x2(:,:,241))
call HGT_OLR(G2H2(135),1,1,2)
call HGT_invQ_OLR(G2H2(135),2,5,2)
call HGT_OLR(G2H2(135),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(135),0,ex4(:),8,G3tensor(48),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hotf_4pt_reduction(G2H2(138),RedSet_4(15),mass4set(:,1),  & 
G1H2(65),G1H2(35),G1H2(115),G1H2(407),G1H2(347),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hotf_4pt_reduction(G2H2(751),RedSet_4(9),mass4set(:,1),  & 
G1H2(121),G1H2(413),G1H2(353),G1H2(67),G1H2(55),2)
  call HG1shiftOLR(G1H2(413),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(141),23,ex4(:),8,G3tensor(49),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(753),27,ex3(:),4,G3tensor(50),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(284),27,ex3(:),4,G2tensor(125),m3h2x1(:,245),heltab2x2(:,:,245))
call HGT_lower_alpha_OLR(G2H2(143),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(143),2,5,2)
call HGT_lower_alpha_OLR(G2H2(143),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(143),0,ex4(:),8,G3tensor(51),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hotf_4pt_reduction(G2H2(146),RedSet_4(51),mass4set(:,1),  & 
G1H2(105),G1H2(417),G1H2(357),G1H2(111),G1H2(423),2)
  call HG1shiftOLR(G1H2(417),1,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(149),30,ex1(:),1,G3tensor(52),m3h2x1(:,247),heltab2x2(:,:,247))
call HGT_OLR(G2H2(151),1,1,2)
call HGT_invQ_OLR(G2H2(151),2,5,2)
call HGT_OLR(G2H2(151),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(151),0,ex1(:),1,G3tensor(53),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hotf_4pt_reduction(G2H2(154),RedSet_4(51),mass4set(:,1),  & 
G1H2(363),G1H2(69),G1H2(57),G1H2(125),G1H2(427),2)
  call HG1shiftOLR(G1H2(69),1,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(157),30,ex1(:),G3tensor(54),m3h2x1(:,249),heltab2x2(:,:,249))
call HGT_OLR(G2H2(159),1,1,2)
call HGT_invQ_OLR(G2H2(159),2,5,2)
call HGT_OLR(G2H2(159),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(159),0,ex1(:),G3tensor(55),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(51),mass4set(:,1),  & 
G1H2(367),G1H2(131),G1H2(433),G1H2(373),G1H2(71),2)
  call HG1shiftOLR(G1H2(131),1,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(165),30,ex1(:),1,G3tensor(56),m3h2x1(:,251),heltab2x2(:,:,251))
call HGT_lower_alpha_OLR(G2H2(167),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(167),2,5,2)
call HGT_lower_alpha_OLR(G2H2(167),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(167),0,ex1(:),1,G3tensor(57),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hotf_4pt_reduction(G2H2(170),RedSet_4(52),mass4set(:,1),  & 
G1H2(59),G1H2(175),G1H2(181),G1H2(165),G1H2(171),2)
  call HG1shiftOLR(G1H2(175),1,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(173),30,ex1(:),G3tensor(58),m3h2x1(:,253),heltab2x2(:,:,253))
call HGT_OLR(G2H2(175),1,1,2)
call HGT_invQ_OLR(G2H2(175),2,5,2)
call HGT_OLR(G2H2(175),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(175),0,ex1(:),G3tensor(59),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(52),mass4set(:,1),  & 
G1H2(185),G1H2(191),G1H2(316),G1H2(76),G1H2(322),2)
  call HG1shiftOLR(G1H2(191),1,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(181),30,ex1(:),1,G3tensor(60),m3h2x1(:,255),heltab2x2(:,:,255))
call HGT_OLR(G2H2(183),1,1,2)
call HGT_invQ_OLR(G2H2(183),2,5,2)
call HGT_OLR(G2H2(183),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(183),0,ex1(:),1,G3tensor(61),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hotf_4pt_reduction(G2H2(186),RedSet_4(52),mass4set(:,1),  & 
G1H2(82),G1H2(326),G1H2(86),G1H2(332),G1H2(92),2)
  call HG1shiftOLR(G1H2(326),1,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(189),30,ex1(:),1,G3tensor(62),m3h2x1(:,257),heltab2x2(:,:,257))
call HGT_lower_alpha_OLR(G2H2(191),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(191),2,5,2)
call HGT_lower_alpha_OLR(G2H2(191),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(191),0,ex1(:),1,G3tensor(63),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hotf_4pt_reduction(G2H2(194),RedSet_4(53),mass4set(:,1),  & 
G1H2(336),G1H2(96),G1H2(342),G1H2(102),G1H2(206),2)
  call HG1shiftOLR(G1H2(96),2,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(197),29,ex2(:),G3tensor(64),m3h2x1(:,259),heltab2x2(:,:,259))
call HGT_OLR(G2H2(199),1,1,2)
call HGT_invQ_OLR(G2H2(199),2,5,2)
call HGT_OLR(G2H2(199),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(199),0,ex2(:),G3tensor(65),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hotf_4pt_reduction(G2H2(202),RedSet_4(53),mass4set(:,1),  & 
G1H2(106),G1H2(212),G1H2(112),G1H2(196),G1H2(116),2)
  call HG1shiftOLR(G1H2(212),2,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(205),29,ex2(:),2,G3tensor(66),m3h2x1(:,261),heltab2x2(:,:,261))
call HGT_OLR(G2H2(207),1,1,2)
call HGT_invQ_OLR(G2H2(207),2,5,2)
call HGT_OLR(G2H2(207),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(207),0,ex2(:),2,G3tensor(67),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hotf_4pt_reduction(G2H2(210),RedSet_4(53),mass4set(:,1),  & 
G1H2(202),G1H2(122),G1H2(216),G1H2(126),G1H2(222),2)
  call HG1shiftOLR(G1H2(122),2,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(213),29,ex2(:),2,G3tensor(68),m3h2x1(:,263),heltab2x2(:,:,263))
call HGT_lower_alpha_OLR(G2H2(215),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(215),2,5,2)
call HGT_lower_alpha_OLR(G2H2(215),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(215),0,ex2(:),2,G3tensor(69),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hotf_4pt_reduction(G2H2(218),RedSet_4(18),mass4set(:,1),  & 
G1H2(132),G1H2(256),G1H2(136),G1H2(262),G1H2(142),2)
  call HG1shiftOLR(G1H2(256),8,2)
  call Hotf_4pt_reduction(G2H2(763),RedSet_4(13),mass4set(:,1),  & 
G1H2(266),G1H2(146),G1H2(272),G1H2(152),G1H2(276),2)
  call HG1shiftOLR(G1H2(146),2,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(221),23,ex4(:),G3tensor(70),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(765),29,ex2(:),G3tensor(71),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(290),29,ex2(:),G2tensor(121),m3h2x1(:,267),heltab2x2(:,:,267))
call HGT_OLR(G2H2(223),1,1,2)
call HGT_invQ_OLR(G2H2(223),2,5,2)
call HGT_OLR(G2H2(223),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(223),0,ex4(:),G3tensor(72),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hotf_4pt_reduction(G2H2(226),RedSet_4(18),mass4set(:,1),  & 
G1H2(156),G1H2(282),G1H2(162),G1H2(236),G1H2(166),2)
  call HG1shiftOLR(G1H2(282),8,2)
  call Hotf_4pt_reduction(G2H2(760),RedSet_4(13),mass4set(:,1),  & 
G1H2(242),G1H2(172),G1H2(226),G1H2(176),G1H2(232),2)
  call HG1shiftOLR(G1H2(172),2,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(229),23,ex4(:),8,G3tensor(73),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(762),29,ex2(:),2,G3tensor(74),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(289),29,ex2(:),2,G2tensor(137),m3h2x1(:,271),heltab2x2(:,:,271))
call HGT_OLR(G2H2(231),1,1,2)
call HGT_invQ_OLR(G2H2(231),2,5,2)
call HGT_OLR(G2H2(231),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(231),0,ex4(:),8,G3tensor(75),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hotf_4pt_reduction(G2H2(234),RedSet_4(18),mass4set(:,1),  & 
G1H2(182),G1H2(246),G1H2(186),G1H2(252),G1H2(192),2)
  call HG1shiftOLR(G1H2(246),8,2)
  call Hotf_4pt_reduction(G2H2(766),RedSet_4(13),mass4set(:,1),  & 
G1H2(195),G1H2(201),G1H2(205),G1H2(211),G1H2(215),2)
  call HG1shiftOLR(G1H2(201),2,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(237),23,ex4(:),8,G3tensor(76),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(768),29,ex2(:),2,G3tensor(77),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(44),29,ex2(:),2,G2tensor(133),m3h2x1(:,275),heltab2x2(:,:,275))
call HGT_lower_alpha_OLR(G2H2(239),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(239),2,5,2)
call HGT_lower_alpha_OLR(G2H2(239),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(239),0,ex4(:),8,G3tensor(78),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hotf_4pt_reduction(G2H2(242),RedSet_4(54),mass4set(:,1),  & 
G1H2(221),G1H2(225),G1H2(231),G1H2(235),G1H2(241),2)
  call HG1shiftOLR(G1H2(225),2,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(245),29,ex2(:),G3tensor(79),m3h2x1(:,277),heltab2x2(:,:,277))
call HGT_OLR(G2H2(247),1,1,2)
call HGT_invQ_OLR(G2H2(247),2,5,2)
call HGT_OLR(G2H2(247),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(247),0,ex2(:),G3tensor(80),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hotf_4pt_reduction(G2H2(250),RedSet_4(54),mass4set(:,1),  & 
G1H2(245),G1H2(251),G1H2(255),G1H2(261),G1H2(265),2)
  call HG1shiftOLR(G1H2(251),2,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(253),29,ex2(:),2,G3tensor(81),m3h2x1(:,279),heltab2x2(:,:,279))
call HGT_OLR(G2H2(255),1,1,2)
call HGT_invQ_OLR(G2H2(255),2,5,2)
call HGT_OLR(G2H2(255),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(255),0,ex2(:),2,G3tensor(82),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hotf_4pt_reduction(G2H2(258),RedSet_4(54),mass4set(:,1),  & 
G1H2(271),G1H2(275),G1H2(281),G1H2(285),G1H2(286),2)
  call HG1shiftOLR(G1H2(275),2,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(261),29,ex2(:),2,G3tensor(83),m3h2x1(:,281),heltab2x2(:,:,281))
call HGT_lower_alpha_OLR(G2H2(263),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(263),2,5,2)
call HGT_lower_alpha_OLR(G2H2(263),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(263),0,ex2(:),2,G3tensor(84),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hotf_4pt_reduction(G2H2(266),RedSet_4(24),mass4set(:,1),  & 
G1H2(291),G1H2(292),G1H2(295),G1H2(296),G1H2(301),2)
  call HG1shiftOLR(G1H2(292),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(269),27,ex3(:),G3tensor(85),m3h2x1(:,283),heltab2x2(:,:,283))
call HGT_OLR(G2H2(271),1,1,2)
call HGT_invQ_OLR(G2H2(271),2,5,2)
call HGT_OLR(G2H2(271),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(271),0,ex3(:),G3tensor(86),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hotf_4pt_reduction(G2H2(274),RedSet_4(24),mass4set(:,1),  & 
G1H2(302),G1H2(305),G1H2(306),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(305),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(277),27,ex3(:),4,G3tensor(87),m3h2x1(:,285),heltab2x2(:,:,285))
call HGT_OLR(G2H2(279),1,1,2)
call HGT_invQ_OLR(G2H2(279),2,5,2)
call HGT_OLR(G2H2(279),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(279),0,ex3(:),4,G3tensor(88),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hotf_4pt_reduction(G2H2(282),RedSet_4(24),mass4set(:,1),  & 
G1H2(315),G1H2(321),G1H2(325),G1H2(331),G1H2(335),2)
  call HG1shiftOLR(G1H2(321),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(285),27,ex3(:),4,G3tensor(89),m3h2x1(:,287),heltab2x2(:,:,287))
call HGT_lower_alpha_OLR(G2H2(287),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(287),2,5,2)
call HGT_lower_alpha_OLR(G2H2(287),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(287),0,ex3(:),4,G3tensor(90),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hotf_4pt_reduction(G2H2(359),RedSet_4(16),mass4set(:,1),  & 
G1H2(341),G1H2(345),G1H2(346),G1H2(351),G1H2(352),2)
  call HG1shiftOLR(G1H2(345),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(362),23,ex4(:),G3tensor(91),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hotf_4pt_reduction(G2H2(367),RedSet_4(16),mass4set(:,1),  & 
G1H2(355),G1H2(356),G1H2(361),G1H2(362),G1H2(365),2)
  call HG1shiftOLR(G1H2(356),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(370),23,ex4(:),8,G3tensor(92),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hotf_4pt_reduction(G2H2(375),RedSet_4(16),mass4set(:,1),  & 
G1H2(366),G1H2(371),G1H2(372),G1H2(375),G1H2(376),2)
  call HG1shiftOLR(G1H2(371),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(378),23,ex4(:),8,G3tensor(93),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hotf_4pt_reduction(G2H2(383),RedSet_4(19),mass4set(:,1),  & 
G1H2(381),G1H2(382),G1H2(385),G1H2(386),G1H2(391),2)
  call HG1shiftOLR(G1H2(382),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(386),23,ex4(:),8,G3tensor(94),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hotf_4pt_reduction(G2H2(391),RedSet_4(19),mass4set(:,1),  & 
G1H2(392),G1H2(395),G1H2(396),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(395),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(394),23,ex4(:),G3tensor(95),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hotf_4pt_reduction(G2H2(399),RedSet_4(19),mass4set(:,1),  & 
G1H2(405),G1H2(406),G1H2(411),G1H2(412),G1H2(415),2)
  call HG1shiftOLR(G1H2(406),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(402),23,ex4(:),8,G3tensor(96),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hotf_4pt_reduction(G2H2(407),RedSet_4(22),mass4set(:,1),  & 
G1H2(416),G1H2(421),G1H2(422),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(421),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(410),23,ex4(:),8,G3tensor(97),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hotf_4pt_reduction(G2H2(415),RedSet_4(22),mass4set(:,1),  & 
G1H2(431),G1H2(432),G1H2(36),G1H2(250),G1H2(254),2)
  call HG1shiftOLR(G1H2(432),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(418),23,ex4(:),G3tensor(98),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hotf_4pt_reduction(G2H2(423),RedSet_4(22),mass4set(:,1),  & 
G1H2(259),G1H2(260),G1H2(38),G1H2(40),G1H2(274),2)
  call HG1shiftOLR(G1H2(260),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(426),23,ex4(:),8,G3tensor(99),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hotf_4pt_reduction(G2H2(431),RedSet_4(25),mass4set(:,1),  & 
G1H2(279),G1H2(269),G1H2(264),G1H2(270),G1H2(42),2)
  call HG1shiftOLR(G1H2(269),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(434),27,ex3(:),4,G3tensor(100),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hotf_4pt_reduction(G2H2(439),RedSet_4(25),mass4set(:,1),  & 
G1H2(280),G1H2(284),G1H2(290),G1H2(289),G1H2(44),2)
  call HG1shiftOLR(G1H2(284),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(442),27,ex3(:),G3tensor(101),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hotf_4pt_reduction(G2H2(447),RedSet_4(25),mass4set(:,1),  & 
G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(435),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(450),27,ex3(:),4,G3tensor(102),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hotf_4pt_reduction(G2H2(595),RedSet_4(27),mass4set(:,1),  & 
G1H2(439),G1H2(440),G1H2(441),G1H2(442),G1H2(443),2)
  call HG1shiftOLR(G1H2(440),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(598),23,ex4(:),G3tensor(103),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hotf_4pt_reduction(G2H2(599),RedSet_4(27),mass4set(:,1),  & 
G1H2(444),G1H2(445),G1H2(446),G1H2(447),G1H2(448),2)
  call HG1shiftOLR(G1H2(445),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(602),23,ex4(:),8,G3tensor(104),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hotf_4pt_reduction(G2H2(603),RedSet_4(27),mass4set(:,1),  & 
G1H2(449),G1H2(450),G1H2(451),G1H2(452),G1H2(453),2)
  call HG1shiftOLR(G1H2(450),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(606),23,ex4(:),8,G3tensor(105),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hotf_4pt_reduction(G2H2(607),RedSet_4(29),mass4set(:,1),  & 
G1H2(454),G1H2(455),G1H2(456),G1H2(457),G1H2(458),2)
  call HG1shiftOLR(G1H2(455),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(610),27,ex3(:),G3tensor(106),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hotf_4pt_reduction(G2H2(611),RedSet_4(29),mass4set(:,1),  & 
G1H2(459),G1H2(460),G1H2(461),G1H2(462),G1H2(463),2)
  call HG1shiftOLR(G1H2(460),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(614),27,ex3(:),4,G3tensor(107),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hotf_4pt_reduction(G2H2(615),RedSet_4(29),mass4set(:,1),  & 
G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),2)
  call HG1shiftOLR(G1H2(465),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(618),27,ex3(:),4,G3tensor(108),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hotf_4pt_reduction(G2H2(619),RedSet_4(31),mass4set(:,1),  & 
G1H2(469),G1H2(470),G1H2(471),G1H2(472),G1H2(473),2)
  call HG1shiftOLR(G1H2(470),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(622),23,ex4(:),8,G3tensor(109),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hotf_4pt_reduction(G2H2(623),RedSet_4(31),mass4set(:,1),  & 
G1H2(474),G1H2(475),G1H2(476),G1H2(477),G1H2(478),2)
  call HG1shiftOLR(G1H2(475),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(626),23,ex4(:),G3tensor(110),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hotf_4pt_reduction(G2H2(627),RedSet_4(31),mass4set(:,1),  & 
G1H2(479),G1H2(480),G1H2(481),G1H2(482),G1H2(483),2)
  call HG1shiftOLR(G1H2(480),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(630),23,ex4(:),8,G3tensor(111),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hotf_4pt_reduction(G2H2(631),RedSet_4(33),mass4set(:,1),  & 
G1H2(484),G1H2(485),G1H2(486),G1H2(487),G1H2(488),2)
  call HG1shiftOLR(G1H2(485),4,2)
  call Hotf_4pt_reduction(G2H2(491),RedSet_4(34),mass4set(:,1),  & 
G1H2(489),G1H2(490),G1H2(491),G1H2(492),G1H2(493),2)
  call HG1shiftOLR(G1H2(490),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(634),27,ex3(:),G3tensor(112),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(494),27,ex3(:),G3tensor(113),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hotf_4pt_reduction(G2H2(635),RedSet_4(33),mass4set(:,1),  & 
G1H2(494),G1H2(495),G1H2(496),G1H2(497),G1H2(498),2)
  call HG1shiftOLR(G1H2(495),4,2)
  call Hotf_4pt_reduction(G2H2(499),RedSet_4(34),mass4set(:,1),  & 
G1H2(499),G1H2(500),G1H2(501),G1H2(502),G1H2(503),2)
  call HG1shiftOLR(G1H2(500),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(638),27,ex3(:),4,G3tensor(114),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(502),27,ex3(:),4,G3tensor(115),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hotf_4pt_reduction(G2H2(639),RedSet_4(33),mass4set(:,1),  & 
G1H2(504),G1H2(505),G1H2(506),G1H2(507),G1H2(508),2)
  call HG1shiftOLR(G1H2(505),4,2)
  call Hotf_4pt_reduction(G2H2(507),RedSet_4(34),mass4set(:,1),  & 
G1H2(509),G1H2(510),G1H2(511),G1H2(512),G1H2(513),2)
  call HG1shiftOLR(G1H2(510),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(642),27,ex3(:),4,G3tensor(116),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(510),27,ex3(:),4,G3tensor(117),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hotf_4pt_reduction(G2H2(643),RedSet_4(36),mass4set(:,1),  & 
G1H2(514),G1H2(515),G1H2(516),G1H2(517),G1H2(518),2)
  call HG1shiftOLR(G1H2(515),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(646),23,ex4(:),G3tensor(118),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hotf_4pt_reduction(G2H2(647),RedSet_4(36),mass4set(:,1),  & 
G1H2(519),G1H2(520),G1H2(521),G1H2(522),G1H2(523),2)
  call HG1shiftOLR(G1H2(520),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(650),23,ex4(:),8,G3tensor(119),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hotf_4pt_reduction(G2H2(651),RedSet_4(36),mass4set(:,1),  & 
G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(525),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(654),23,ex4(:),8,G3tensor(120),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hotf_4pt_reduction(G2H2(655),RedSet_4(38),mass4set(:,1),  & 
G1H2(529),G1H2(530),G1H2(531),G1H2(532),G1H2(533),2)
  call HG1shiftOLR(G1H2(530),2,2)
  call Hotf_4pt_reduction(G2H2(527),RedSet_4(39),mass4set(:,1),  & 
G1H2(534),G1H2(535),G1H2(536),G1H2(537),G1H2(538),2)
  call HG1shiftOLR(G1H2(535),2,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(658),29,ex2(:),G3tensor(121),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(530),29,ex2(:),G3tensor(122),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hotf_4pt_reduction(G2H2(659),RedSet_4(38),mass4set(:,1),  & 
G1H2(539),G1H2(540),G1H2(541),G1H2(542),G1H2(543),2)
  call HG1shiftOLR(G1H2(540),2,2)
  call Hotf_4pt_reduction(G2H2(535),RedSet_4(39),mass4set(:,1),  & 
G1H2(544),G1H2(545),G1H2(546),G1H2(547),G1H2(548),2)
  call HG1shiftOLR(G1H2(545),2,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(662),29,ex2(:),2,G3tensor(123),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(538),29,ex2(:),2,G3tensor(124),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hotf_4pt_reduction(G2H2(663),RedSet_4(38),mass4set(:,1),  & 
G1H2(549),G1H2(550),G1H2(551),G1H2(552),G1H2(553),2)
  call HG1shiftOLR(G1H2(550),2,2)
  call Hotf_4pt_reduction(G2H2(543),RedSet_4(39),mass4set(:,1),  & 
G1H2(554),G1H2(555),G1H2(556),G1H2(557),G1H2(558),2)
  call HG1shiftOLR(G1H2(555),2,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(666),29,ex2(:),2,G3tensor(125),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(546),29,ex2(:),2,G3tensor(126),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hotf_4pt_reduction(G2H2(667),RedSet_4(41),mass4set(:,1),  & 
G1H2(559),G1H2(560),G1H2(561),G1H2(562),G1H2(563),2)
  call HG1shiftOLR(G1H2(560),4,2)
  call Hotf_4pt_reduction(G2H2(551),RedSet_4(42),mass4set(:,1),  & 
G1H2(564),G1H2(565),G1H2(566),G1H2(567),G1H2(568),2)
  call HG1shiftOLR(G1H2(565),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(670),27,ex3(:),G3tensor(127),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(554),27,ex3(:),G3tensor(128),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hotf_4pt_reduction(G2H2(671),RedSet_4(41),mass4set(:,1),  & 
G1H2(569),G1H2(570),G1H2(571),G1H2(572),G1H2(573),2)
  call HG1shiftOLR(G1H2(570),4,2)
  call Hotf_4pt_reduction(G2H2(559),RedSet_4(42),mass4set(:,1),  & 
G1H2(574),G1H2(575),G1H2(576),G1H2(577),G1H2(578),2)
  call HG1shiftOLR(G1H2(575),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(674),27,ex3(:),4,G3tensor(129),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(562),27,ex3(:),4,G3tensor(130),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hotf_4pt_reduction(G2H2(675),RedSet_4(41),mass4set(:,1),  & 
G1H2(579),G1H2(580),G1H2(581),G1H2(582),G1H2(583),2)
  call HG1shiftOLR(G1H2(580),4,2)
  call Hotf_4pt_reduction(G2H2(567),RedSet_4(42),mass4set(:,1),  & 
G1H2(584),G1H2(585),G1H2(586),G1H2(587),G1H2(588),2)
  call HG1shiftOLR(G1H2(585),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(678),27,ex3(:),4,G3tensor(131),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(570),27,ex3(:),4,G3tensor(132),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hotf_4pt_reduction(G2H2(679),RedSet_4(44),mass4set(:,1),  & 
G1H2(589),G1H2(590),G1H2(591),G1H2(592),G1H2(593),2)
  call HG1shiftOLR(G1H2(590),2,2)
  call Hotf_4pt_reduction(G2H2(575),RedSet_4(45),mass4set(:,1),  & 
G1H2(594),G1H2(595),G1H2(596),G1H2(597),G1H2(598),2)
  call HG1shiftOLR(G1H2(595),2,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(682),29,ex2(:),G3tensor(133),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(578),29,ex2(:),G3tensor(134),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hotf_4pt_reduction(G2H2(683),RedSet_4(44),mass4set(:,1),  & 
G1H2(599),G1H2(600),G1H2(601),G1H2(602),G1H2(603),2)
  call HG1shiftOLR(G1H2(600),2,2)
  call Hotf_4pt_reduction(G2H2(583),RedSet_4(45),mass4set(:,1),  & 
G1H2(604),G1H2(605),G1H2(606),G1H2(607),G1H2(608),2)
  call HG1shiftOLR(G1H2(605),2,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(686),29,ex2(:),2,G3tensor(135),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(586),29,ex2(:),2,G3tensor(136),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hotf_4pt_reduction(G2H2(687),RedSet_4(44),mass4set(:,1),  & 
G1H2(609),G1H2(610),G1H2(611),G1H2(612),G1H2(613),2)
  call HG1shiftOLR(G1H2(610),2,2)
  call Hotf_4pt_reduction(G2H2(591),RedSet_4(45),mass4set(:,1),  & 
G1H2(614),G1H2(615),G1H2(616),G1H2(617),G1H2(618),2)
  call HG1shiftOLR(G1H2(615),2,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(690),29,ex2(:),2,G3tensor(137),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(594),29,ex2(:),2,G3tensor(138),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(72),29,ex2(:),G2tensor(149),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(78),23,ex4(:),G2tensor(145),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(88),29,ex2(:),2,G2tensor(161),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(98),23,ex4(:),8,G2tensor(157),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(108),29,ex2(:),2,G2tensor(173),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(118),23,ex4(:),8,G2tensor(169),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(128),27,ex3(:),4,G2tensor(45),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(138),23,ex4(:),8,G2tensor(57),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(148),27,ex3(:),G2tensor(69),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(158),23,ex4(:),G2tensor(81),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(168),27,ex3(:),4,G2tensor(93),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(178),23,ex4(:),8,G2tensor(105),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(188),30,ex1(:),1,G2tensor(117),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(198),23,ex4(:),8,G2tensor(129),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(208),30,ex1(:),G2tensor(141),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(218),23,ex4(:),G2tensor(153),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(228),30,ex1(:),1,G2tensor(165),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(238),23,ex4(:),8,G2tensor(177),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(248),23,ex4(:),8,G2tensor(181),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(258),27,ex3(:),4,G2tensor(182),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(268),23,ex4(:),G2tensor(183),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(278),27,ex3(:),G2tensor(184),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(288),23,ex4(:),8,G2tensor(185),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(298),27,ex3(:),4,G2tensor(186),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(308),27,ex3(:),G2tensor(187),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(318),27,ex3(:),4,G2tensor(188),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(328),27,ex3(:),4,G2tensor(189),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(338),23,ex4(:),G2tensor(190),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(348),23,ex4(:),8,G2tensor(191),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(358),23,ex4(:),8,G2tensor(192),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(368),30,ex1(:),1,G2tensor(193),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(378),30,ex1(:),G2tensor(194),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(388),30,ex1(:),1,G2tensor(195),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(398),30,ex1(:),G2tensor(196),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(408),27,ex3(:),G2tensor(197),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(418),30,ex1(:),1,G2tensor(198),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(428),27,ex3(:),4,G2tensor(199),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(73),30,ex1(:),1,G2tensor(200),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(74),27,ex3(:),4,G2tensor(201),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(79),29,ex2(:),G2tensor(202),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(80),29,ex2(:),2,G2tensor(203),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(2),29,ex2(:),2,G2tensor(204),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(84),23,ex4(:),G2tensor(205),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(89),29,ex2(:),G2tensor(206),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(90),23,ex4(:),8,G2tensor(207),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(4),29,ex2(:),2,G2tensor(208),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(94),23,ex4(:),8,G2tensor(209),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(99),29,ex2(:),2,G2tensor(210),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(100),29,ex2(:),G2tensor(211),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(6),27,ex3(:),G2tensor(212),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(104),29,ex2(:),2,G2tensor(213),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(109),27,ex3(:),4,G2tensor(214),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(110),29,ex2(:),2,G2tensor(215),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(8),27,ex3(:),4,G2tensor(216),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(114),27,ex3(:),G2tensor(217),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(119),29,ex2(:),G2tensor(218),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(120),27,ex3(:),4,G2tensor(219),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(10),29,ex2(:),2,G2tensor(220),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(124),27,ex3(:),4,G2tensor(221),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(129),29,ex2(:),2,G2tensor(222),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(130),23,ex4(:),G2tensor(223),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(224),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(134),23,ex4(:),8,G2tensor(225),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(139),27,ex3(:),G2tensor(226),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(140),27,ex3(:),4,G2tensor(227),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(14),27,ex3(:),4,G2tensor(228),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(144),23,ex4(:),8,G2tensor(229),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(149),23,ex4(:),G2tensor(230),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(150),23,ex4(:),8,G2tensor(231),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(16),27,ex3(:),G2tensor(232),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(154),27,ex3(:),4,G2tensor(233),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(159),27,ex3(:),4,G2tensor(234),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(160),23,ex4(:),G2tensor(235),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(18),23,ex4(:),8,G2tensor(236),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(164),23,ex4(:),8,G2tensor(237),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(169),29,ex2(:),G2tensor(238),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(170),29,ex2(:),2,G2tensor(239),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),29,ex2(:),2,G2tensor(240),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(174),27,ex3(:),G2tensor(241),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(179),27,ex3(:),4,G2tensor(242),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(180),27,ex3(:),4,G2tensor(243),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(22),29,ex2(:),G2tensor(244),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(184),29,ex2(:),2,G2tensor(245),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(189),29,ex2(:),2,G2tensor(246),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(101),ex4(:),ex3(:),G2tensor(247),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(105),ex4(:),ex3(:),G2tensor(248),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(106),ex3(:),ex4(:),G2tensor(249),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(110),ex3(:),ex4(:),G2tensor(250),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(111),ex4(:),ex3(:),G2tensor(251),m4h2x2x1(:,5),heltab3x4(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(115),ex4(:),ex3(:),G2tensor(252),m4h2x2x1(:,6),heltab3x4(:,:,6))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(116),ex4(:),ex3(:),G2tensor(253),m4h2x2x1(:,7),heltab3x4(:,:,7))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(120),ex4(:),ex3(:),G2tensor(254),m4h2x2x1(:,8),heltab3x4(:,:,8))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(121),ex3(:),ex4(:),G2tensor(255),m4h2x2x1(:,9),heltab3x4(:,:,9))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(125),ex3(:),ex4(:),G2tensor(256),m4h2x2x1(:,10),heltab3x4(:,:,10))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(126),ex4(:),ex3(:),G2tensor(257),m4h2x2x1(:,11),heltab3x4(:,:,11))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(130),ex4(:),ex3(:),G2tensor(258),m4h2x2x1(:,12),heltab3x4(:,:,12))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(131),ex4(:),ex2(:),G2tensor(259),m4h2x2x1(:,13),heltab3x4(:,:,13))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(135),ex4(:),ex2(:),G2tensor(260),m4h2x2x1(:,14),heltab3x4(:,:,14))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(136),ex2(:),ex4(:),G2tensor(261),m4h2x2x1(:,15),heltab3x4(:,:,15))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(140),ex2(:),ex4(:),G2tensor(262),m4h2x2x1(:,16),heltab3x4(:,:,16))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(141),ex4(:),ex2(:),G2tensor(263),m4h2x2x1(:,17),heltab3x4(:,:,17))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(145),ex4(:),ex2(:),G2tensor(264),m4h2x2x1(:,18),heltab3x4(:,:,18))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(146),ex4(:),ex2(:),G2tensor(265),m4h2x2x1(:,19),heltab3x4(:,:,19))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(150),ex4(:),ex2(:),G2tensor(266),m4h2x2x1(:,20),heltab3x4(:,:,20))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(151),ex2(:),ex4(:),G2tensor(267),m4h2x2x1(:,21),heltab3x4(:,:,21))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(155),ex2(:),ex4(:),G2tensor(268),m4h2x2x1(:,22),heltab3x4(:,:,22))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(156),ex4(:),ex2(:),G2tensor(269),m4h2x2x1(:,23),heltab3x4(:,:,23))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(160),ex4(:),ex2(:),G2tensor(270),m4h2x2x1(:,24),heltab3x4(:,:,24))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(161),ex3(:),ex2(:),G2tensor(271),m4h2x2x1(:,25),heltab3x4(:,:,25))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(165),ex3(:),ex2(:),G2tensor(272),m4h2x2x1(:,26),heltab3x4(:,:,26))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(166),ex2(:),ex3(:),G2tensor(273),m4h2x2x1(:,27),heltab3x4(:,:,27))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(170),ex2(:),ex3(:),G2tensor(274),m4h2x2x1(:,28),heltab3x4(:,:,28))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(171),ex3(:),ex2(:),G2tensor(275),m4h2x2x1(:,29),heltab3x4(:,:,29))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(175),ex3(:),ex2(:),G2tensor(276),m4h2x2x1(:,30),heltab3x4(:,:,30))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(176),ex4(:),ex1(:),G2tensor(277),m4h2x2x1(:,31),heltab3x4(:,:,31))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(180),ex4(:),ex1(:),G2tensor(278),m4h2x2x1(:,32),heltab3x4(:,:,32))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(123),ex1(:),ex4(:),G2tensor(279),m4h2x2x1(:,33),heltab3x4(:,:,33))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(128),ex1(:),ex4(:),G2tensor(280),m4h2x2x1(:,34),heltab3x4(:,:,34))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(8),ex4(:),ex1(:),G2tensor(281),m4h2x2x1(:,35),heltab3x4(:,:,35))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(13),ex4(:),ex1(:),G2tensor(282),m4h2x2x1(:,36),heltab3x4(:,:,36))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(91),ex4(:),ex1(:),G2tensor(283),m4h2x2x1(:,37),heltab3x4(:,:,37))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(18),ex4(:),ex1(:),G2tensor(284),m4h2x2x1(:,38),heltab3x4(:,:,38))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(94),ex1(:),ex4(:),G2tensor(285),m4h2x2x1(:,39),heltab3x4(:,:,39))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(23),ex1(:),ex4(:),G2tensor(286),m4h2x2x1(:,40),heltab3x4(:,:,40))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(61),ex4(:),ex1(:),G2tensor(287),m4h2x2x1(:,41),heltab3x4(:,:,41))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(28),ex4(:),ex1(:),G2tensor(288),m4h2x2x1(:,42),heltab3x4(:,:,42))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(93),ex3(:),ex1(:),G2tensor(289),m4h2x2x1(:,43),heltab3x4(:,:,43))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(98),ex3(:),ex1(:),G2tensor(290),m4h2x2x1(:,44),heltab3x4(:,:,44))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(38),ex1(:),ex3(:),G2tensor(291),m4h2x2x1(:,45),heltab3x4(:,:,45))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(43),ex1(:),ex3(:),G2tensor(292),m4h2x2x1(:,46),heltab3x4(:,:,46))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(11),ex3(:),ex1(:),G2tensor(293),m4h2x2x1(:,47),heltab3x4(:,:,47))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(48),ex3(:),ex1(:),G2tensor(294),m4h2x2x1(:,48),heltab3x4(:,:,48))
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(11),mass4set(:,1),  & 
G1H4(387),G1H4(403),G1H4(419),G1H4(435),G1H4(451),4)
  call HG1shiftOLR(G1H4(403),5,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(58),26,wf4(:,2),G3tensor(139),m3h4x1(:,1),heltab2x4(:,:,901))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(106),26,wf4(:,2),G2tensor(295),m3h4x1(:,2),heltab2x4(:,:,902))
  call Hotf_4pt_reduction(G2H4(95),RedSet_4(11),mass4set(:,1),  & 
G1H4(467),G1H4(483),G1H4(499),G1H4(515),G1H4(531),4)
  call HG1shiftOLR(G1H4(483),5,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(64),26,wf4(:,2),5,G3tensor(140),m3h4x1(:,3),heltab2x4(:,:,903))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(111),26,wf4(:,2),5,G2tensor(296),m3h4x1(:,4),heltab2x4(:,:,904))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(11),mass4set(:,1),  & 
G1H4(547),G1H4(563),G1H4(9),G1H4(394),G1H4(14),4)
  call HG1shiftOLR(G1H4(563),5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(5),26,wf4(:,2),5,G3tensor(141),m3h4x1(:,5),heltab2x4(:,:,905))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(122),26,wf4(:,2),5,G2tensor(297),m3h4x1(:,6),heltab2x4(:,:,906))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(14),mass4set(:,1),  & 
G1H4(399),G1H4(25),G1H4(410),G1H4(30),G1H4(415),4)
  call HG1shiftOLR(G1H4(25),6,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(10),25,wf4(:,5),G3tensor(142),m3h4x1(:,7),heltab2x4(:,:,907))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(127),25,wf4(:,5),G2tensor(298),m3h4x1(:,8),heltab2x4(:,:,908))
  call Hotf_4pt_reduction(G2H4(89),RedSet_4(14),mass4set(:,1),  & 
G1H4(41),G1H4(426),G1H4(46),G1H4(431),G1H4(57),4)
  call HG1shiftOLR(G1H4(426),6,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(66),25,wf4(:,5),6,G3tensor(143),m3h4x1(:,9),heltab2x4(:,:,909))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(138),25,wf4(:,5),6,G2tensor(299),m3h4x1(:,10),heltab2x4(:,:,910))
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(14),mass4set(:,1),  & 
G1H4(218),G1H4(62),G1H4(223),G1H4(73),G1H4(202),4)
  call HG1shiftOLR(G1H4(62),6,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(20),25,wf4(:,5),6,G3tensor(144),m3h4x1(:,11),heltab2x4(:,:,911))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(143),25,wf4(:,5),6,G2tensor(300),m3h4x1(:,12),heltab2x4(:,:,912))
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(10),mass4set(:,1),  & 
G1H4(78),G1H4(207),G1H4(89),G1H4(234),G1H4(94),4)
  call HG1shiftOLR(G1H4(207),9,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(81),22,wf4(:,3),G3tensor(145),m3h4x1(:,13),heltab2x4(:,:,913))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(154),22,wf4(:,3),G2tensor(301),m3h4x1(:,14),heltab2x4(:,:,914))
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(10),mass4set(:,1),  & 
G1H4(239),G1H4(105),G1H4(298),G1H4(110),G1H4(303),4)
  call HG1shiftOLR(G1H4(105),9,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(22),22,wf4(:,3),9,G3tensor(146),m3h4x1(:,15),heltab2x4(:,:,915))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(159),22,wf4(:,3),9,G2tensor(302),m3h4x1(:,16),heltab2x4(:,:,916))
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(10),mass4set(:,1),  & 
G1H4(121),G1H4(314),G1H4(126),G1H4(319),G1H4(137),4)
  call HG1shiftOLR(G1H4(314),9,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(76),22,wf4(:,3),9,G3tensor(147),m3h4x1(:,17),heltab2x4(:,:,917))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(170),22,wf4(:,3),9,G2tensor(303),m3h4x1(:,18),heltab2x4(:,:,918))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(5),mass4set(:,1),  & 
G1H4(330),G1H4(142),G1H4(335),G1H4(153),G1H4(266),4)
  call HG1shiftOLR(G1H4(142),9,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(37),22,wf4(:,3),9,G3tensor(148),m3h4x1(:,19),heltab2x4(:,:,919))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(175),22,wf4(:,3),9,G2tensor(304),m3h4x1(:,20),heltab2x4(:,:,920))
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(5),mass4set(:,1),  & 
G1H4(158),G1H4(271),G1H4(169),G1H4(250),G1H4(174),4)
  call HG1shiftOLR(G1H4(271),9,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(86),22,wf4(:,3),G3tensor(149),m3h4x1(:,21),heltab2x4(:,:,921))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(186),22,wf4(:,3),G2tensor(305),m3h4x1(:,22),heltab2x4(:,:,922))
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(5),mass4set(:,1),  & 
G1H4(255),G1H4(185),G1H4(282),G1H4(190),G1H4(287),4)
  call HG1shiftOLR(G1H4(185),9,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(52),22,wf4(:,3),9,G3tensor(150),m3h4x1(:,23),heltab2x4(:,:,923))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(191),22,wf4(:,3),9,G2tensor(306),m3h4x1(:,24),heltab2x4(:,:,924))
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(12),mass4set(:,1),  & 
G1H4(201),G1H4(206),G1H4(217),G1H4(222),G1H4(233),4)
  call HG1shiftOLR(G1H4(206),10,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(72),21,wf4(:,6),G3tensor(151),m3h4x1(:,25),heltab2x4(:,:,925))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(195),21,wf4(:,6),G2tensor(307),m3h4x1(:,26),heltab2x4(:,:,926))
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(12),mass4set(:,1),  & 
G1H4(238),G1H4(249),G1H4(254),G1H4(265),G1H4(270),4)
  call HG1shiftOLR(G1H4(249),10,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(87),21,wf4(:,6),10,G3tensor(152),m3h4x1(:,27),heltab2x4(:,:,927))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(211),21,wf4(:,6),10,G2tensor(308),m3h4x1(:,28),heltab2x4(:,:,928))
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(12),mass4set(:,1),  & 
G1H4(281),G1H4(286),G1H4(297),G1H4(302),G1H4(313),4)
  call HG1shiftOLR(G1H4(286),10,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(102),21,wf4(:,6),10,G3tensor(153),m3h4x1(:,29),heltab2x4(:,:,929))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(227),21,wf4(:,6),10,G2tensor(309),m3h4x1(:,30),heltab2x4(:,:,930))
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(2),mass4set(:,1),  & 
G1H4(318),G1H4(329),G1H4(334),G1H4(345),G1H4(346),4)
  call HG1shiftOLR(G1H4(329),10,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(112),21,wf4(:,6),10,G3tensor(154),m3h4x1(:,31),heltab2x4(:,:,931))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(243),21,wf4(:,6),10,G2tensor(310),m3h4x1(:,32),heltab2x4(:,:,932))
  call Hotf_4pt_reduction(G2H4(113),RedSet_4(2),mass4set(:,1),  & 
G1H4(350),G1H4(351),G1H4(361),G1H4(362),G1H4(366),4)
  call HG1shiftOLR(G1H4(351),10,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(118),21,wf4(:,6),G3tensor(155),m3h4x1(:,33),heltab2x4(:,:,933))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(259),21,wf4(:,6),G2tensor(311),m3h4x1(:,34),heltab2x4(:,:,934))
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(2),mass4set(:,1),  & 
G1H4(367),G1H4(377),G1H4(378),G1H4(382),G1H4(383),4)
  call HG1shiftOLR(G1H4(377),10,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(132),21,wf4(:,6),10,G3tensor(156),m3h4x1(:,35),heltab2x4(:,:,935))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(275),21,wf4(:,6),10,G2tensor(312),m3h4x1(:,36),heltab2x4(:,:,936))
  call Hotf_4pt_reduction(G2H4(143),RedSet_4(8),mass4set(:,1),  & 
G1H4(393),G1H4(398),G1H4(409),G1H4(414),G1H4(425),4)
  call HG1shiftOLR(G1H4(398),12,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(148),19,wf4(:,8),G3tensor(157),m3h4x1(:,37),heltab2x4(:,:,937))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(291),19,wf4(:,8),G2tensor(313),m3h4x1(:,38),heltab2x4(:,:,938))
  call Hotf_4pt_reduction(G2H4(152),RedSet_4(8),mass4set(:,1),  & 
G1H4(430),G1H4(441),G1H4(442),G1H4(446),G1H4(447),4)
  call HG1shiftOLR(G1H4(441),12,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(157),19,wf4(:,8),12,G3tensor(158),m3h4x1(:,39),heltab2x4(:,:,939))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(307),19,wf4(:,8),12,G2tensor(314),m3h4x1(:,40),heltab2x4(:,:,940))
  call Hotf_4pt_reduction(G2H4(158),RedSet_4(8),mass4set(:,1),  & 
G1H4(457),G1H4(458),G1H4(462),G1H4(463),G1H4(473),4)
  call HG1shiftOLR(G1H4(458),12,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(163),19,wf4(:,8),12,G3tensor(159),m3h4x1(:,41),heltab2x4(:,:,941))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(323),19,wf4(:,8),12,G2tensor(315),m3h4x1(:,42),heltab2x4(:,:,942))
  call Hotf_4pt_reduction(G2H4(167),RedSet_4(4),mass4set(:,1),  & 
G1H4(474),G1H4(478),G1H4(479),G1H4(489),G1H4(490),4)
  call HG1shiftOLR(G1H4(478),12,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(172),19,wf4(:,8),12,G3tensor(160),m3h4x1(:,43),heltab2x4(:,:,943))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(339),19,wf4(:,8),12,G2tensor(316),m3h4x1(:,44),heltab2x4(:,:,944))
  call Hotf_4pt_reduction(G2H4(173),RedSet_4(4),mass4set(:,1),  & 
G1H4(494),G1H4(495),G1H4(505),G1H4(506),G1H4(510),4)
  call HG1shiftOLR(G1H4(495),12,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(178),19,wf4(:,8),G3tensor(161),m3h4x1(:,45),heltab2x4(:,:,945))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(355),19,wf4(:,8),G2tensor(317),m3h4x1(:,46),heltab2x4(:,:,946))
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(4),mass4set(:,1),  & 
G1H4(511),G1H4(521),G1H4(522),G1H4(526),G1H4(527),4)
  call HG1shiftOLR(G1H4(521),12,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(25),19,wf4(:,8),12,G3tensor(162),m3h4x1(:,47),heltab2x4(:,:,947))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(371),19,wf4(:,8),12,G2tensor(318),m3h4x1(:,48),heltab2x4(:,:,948))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(294),29,ex2(:),G2tensor(319),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(299),0,ex2(:),G2tensor(320),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(304),29,ex2(:),G2tensor(321),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(309),23,ex4(:),G2tensor(322),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(310),0,ex4(:),G2tensor(323),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(319),23,ex4(:),G2tensor(324),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(320),29,ex2(:),2,G2tensor(325),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(50),0,ex2(:),2,G2tensor(326),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(330),29,ex2(:),2,G2tensor(327),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(52),23,ex4(:),8,G2tensor(328),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(334),0,ex4(:),8,G2tensor(329),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(54),23,ex4(:),8,G2tensor(330),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(344),29,ex2(:),2,G2tensor(331),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(349),0,ex2(:),2,G2tensor(332),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(354),29,ex2(:),2,G2tensor(333),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(359),23,ex4(:),8,G2tensor(334),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(360),0,ex4(:),8,G2tensor(335),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(369),23,ex4(:),8,G2tensor(336),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(370),27,ex3(:),4,G2tensor(337),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(60),0,ex3(:),4,G2tensor(338),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(380),27,ex3(:),4,G2tensor(339),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(62),23,ex4(:),8,G2tensor(340),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(384),0,ex4(:),8,G2tensor(341),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(64),23,ex4(:),8,G2tensor(342),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(394),27,ex3(:),G2tensor(343),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(399),0,ex3(:),G2tensor(344),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(404),27,ex3(:),G2tensor(345),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(409),23,ex4(:),G2tensor(346),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(410),0,ex4(:),G2tensor(347),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(419),23,ex4(:),G2tensor(348),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(420),27,ex3(:),4,G2tensor(349),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(70),0,ex3(:),4,G2tensor(350),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(430),27,ex3(:),4,G2tensor(351),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(147),23,ex4(:),8,G2tensor(352),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(77),0,ex4(:),8,G2tensor(353),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(354),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1),30,ex1(:),1,G2tensor(355),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(137),0,ex1(:),1,G2tensor(356),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(93),30,ex1(:),1,G2tensor(357),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(13),30,ex1(:),G2tensor(358),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(3),0,ex1(:),G2tensor(359),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(163),30,ex1(:),G2tensor(360),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(103),30,ex1(:),1,G2tensor(361),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(17),0,ex1(:),1,G2tensor(362),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(107),30,ex1(:),1,G2tensor(363),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(263),23,ex4(:),8,G2tensor(364),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(113),0,ex4(:),8,G2tensor(365),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(267),23,ex4(:),8,G2tensor(366),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(117),27,ex3(:),4,G2tensor(367),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(273),0,ex3(:),4,G2tensor(368),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(9),27,ex3(:),4,G2tensor(369),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(277),23,ex4(:),G2tensor(370),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(127),0,ex4(:),G2tensor(371),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(41),23,ex4(:),G2tensor(372),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(11),27,ex3(:),G2tensor(373),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(135),0,ex3(:),G2tensor(374),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(141),27,ex3(:),G2tensor(375),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(303),23,ex4(:),8,G2tensor(376),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(173),0,ex4(:),8,G2tensor(377),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(145),23,ex4(:),8,G2tensor(378),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(287),27,ex3(:),4,G2tensor(379),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(177),0,ex3(:),4,G2tensor(380),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(183),27,ex3(:),4,G2tensor(381),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(43),27,ex3(:),G2tensor(382),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(21),0,ex3(:),G2tensor(383),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(187),27,ex3(:),G2tensor(384),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(161),23,ex4(:),G2tensor(385),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(313),0,ex4(:),G2tensor(386),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(23),23,ex4(:),G2tensor(387),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(317),27,ex3(:),4,G2tensor(388),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(197),0,ex3(:),4,G2tensor(389),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(49),27,ex3(:),4,G2tensor(390),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(25),23,ex4(:),8,G2tensor(391),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(327),0,ex4(:),8,G2tensor(392),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(213),23,ex4(:),8,G2tensor(393),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(51),27,ex3(:),4,G2tensor(394),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),0,ex3(:),4,G2tensor(395),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(343),27,ex3(:),4,G2tensor(396),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(223),23,ex4(:),8,G2tensor(397),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(53),0,ex4(:),8,G2tensor(398),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(377),23,ex4(:),8,G2tensor(399),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(227),23,ex4(:),G2tensor(400),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(81),0,ex4(:),G2tensor(401),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(61),23,ex4(:),G2tensor(402),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(31),27,ex3(:),G2tensor(403),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(85),0,ex3(:),G2tensor(404),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(91),27,ex3(:),G2tensor(405),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(393),23,ex4(:),8,G2tensor(406),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(243),0,ex4(:),8,G2tensor(407),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(95),23,ex4(:),8,G2tensor(408),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(397),27,ex3(:),4,G2tensor(409),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(247),0,ex3(:),4,G2tensor(410),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(253),27,ex3(:),4,G2tensor(411),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(65),23,ex4(:),8,G2tensor(412),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),0,ex4(:),8,G2tensor(413),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(347),23,ex4(:),8,G2tensor(414),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(121),27,ex3(:),4,G2tensor(415),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(413),0,ex3(:),4,G2tensor(416),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(55),27,ex3(:),4,G2tensor(417),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(105),30,ex1(:),1,G2tensor(418),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(417),0,ex1(:),1,G2tensor(419),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(423),30,ex1(:),1,G2tensor(420),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(363),30,ex1(:),G2tensor(421),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(69),0,ex1(:),G2tensor(422),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(427),30,ex1(:),G2tensor(423),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(367),30,ex1(:),1,G2tensor(424),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(131),0,ex1(:),1,G2tensor(425),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(71),30,ex1(:),1,G2tensor(426),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(59),30,ex1(:),G2tensor(427),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(175),0,ex1(:),G2tensor(428),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(171),30,ex1(:),G2tensor(429),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(185),30,ex1(:),1,G2tensor(430),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(191),0,ex1(:),1,G2tensor(431),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(322),30,ex1(:),1,G2tensor(432),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(82),30,ex1(:),1,G2tensor(433),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(326),0,ex1(:),1,G2tensor(434),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(92),30,ex1(:),1,G2tensor(435),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(336),29,ex2(:),G2tensor(436),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(96),0,ex2(:),G2tensor(437),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(206),29,ex2(:),G2tensor(438),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(106),29,ex2(:),2,G2tensor(439),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(212),0,ex2(:),2,G2tensor(440),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(116),29,ex2(:),2,G2tensor(441),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(202),29,ex2(:),2,G2tensor(442),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(122),0,ex2(:),2,G2tensor(443),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(222),29,ex2(:),2,G2tensor(444),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(132),23,ex4(:),G2tensor(445),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(256),0,ex4(:),G2tensor(446),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(142),23,ex4(:),G2tensor(447),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(266),29,ex2(:),G2tensor(448),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(146),0,ex2(:),G2tensor(449),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(276),29,ex2(:),G2tensor(450),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(156),23,ex4(:),8,G2tensor(451),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(282),0,ex4(:),8,G2tensor(452),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(166),23,ex4(:),8,G2tensor(453),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(242),29,ex2(:),2,G2tensor(454),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(172),0,ex2(:),2,G2tensor(455),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(232),29,ex2(:),2,G2tensor(456),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(182),23,ex4(:),8,G2tensor(457),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(246),0,ex4(:),8,G2tensor(458),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(192),23,ex4(:),8,G2tensor(459),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(195),29,ex2(:),2,G2tensor(460),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(201),0,ex2(:),2,G2tensor(461),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(215),29,ex2(:),2,G2tensor(462),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(221),29,ex2(:),G2tensor(463),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(225),0,ex2(:),G2tensor(464),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(241),29,ex2(:),G2tensor(465),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(245),29,ex2(:),2,G2tensor(466),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(251),0,ex2(:),2,G2tensor(467),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(265),29,ex2(:),2,G2tensor(468),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(271),29,ex2(:),2,G2tensor(469),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(275),0,ex2(:),2,G2tensor(470),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(286),29,ex2(:),2,G2tensor(471),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(291),27,ex3(:),G2tensor(472),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(292),0,ex3(:),G2tensor(473),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(301),27,ex3(:),G2tensor(474),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(302),27,ex3(:),4,G2tensor(475),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(305),0,ex3(:),4,G2tensor(476),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(312),27,ex3(:),4,G2tensor(477),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(315),27,ex3(:),4,G2tensor(478),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(321),0,ex3(:),4,G2tensor(479),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(335),27,ex3(:),4,G2tensor(480),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(341),23,ex4(:),G2tensor(481),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(345),0,ex4(:),G2tensor(482),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(352),23,ex4(:),G2tensor(483),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(355),23,ex4(:),8,G2tensor(484),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(356),0,ex4(:),8,G2tensor(485),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(365),23,ex4(:),8,G2tensor(486),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(366),23,ex4(:),8,G2tensor(487),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(371),0,ex4(:),8,G2tensor(488),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(376),23,ex4(:),8,G2tensor(489),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(381),23,ex4(:),8,G2tensor(490),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(382),0,ex4(:),8,G2tensor(491),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(391),23,ex4(:),8,G2tensor(492),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(392),23,ex4(:),G2tensor(493),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(395),0,ex4(:),G2tensor(494),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(402),23,ex4(:),G2tensor(495),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(405),23,ex4(:),8,G2tensor(496),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(406),0,ex4(:),8,G2tensor(497),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(415),23,ex4(:),8,G2tensor(498),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(416),23,ex4(:),8,G2tensor(499),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(421),0,ex4(:),8,G2tensor(500),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(426),23,ex4(:),8,G2tensor(501),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(431),23,ex4(:),G2tensor(502),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(432),0,ex4(:),G2tensor(503),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(254),23,ex4(:),G2tensor(504),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(259),23,ex4(:),8,G2tensor(505),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(260),0,ex4(:),8,G2tensor(506),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(274),23,ex4(:),8,G2tensor(507),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(279),27,ex3(:),4,G2tensor(508),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(269),0,ex3(:),4,G2tensor(509),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(42),27,ex3(:),4,G2tensor(510),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(280),27,ex3(:),G2tensor(511),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(284),0,ex3(:),G2tensor(512),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(44),27,ex3(:),G2tensor(513),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(434),27,ex3(:),4,G2tensor(514),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(435),0,ex3(:),4,G2tensor(515),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(438),27,ex3(:),4,G2tensor(516),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(439),23,ex4(:),G2tensor(517),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(440),0,ex4(:),G2tensor(518),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(443),23,ex4(:),G2tensor(519),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(444),23,ex4(:),8,G2tensor(520),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(445),0,ex4(:),8,G2tensor(521),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(448),23,ex4(:),8,G2tensor(522),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(449),23,ex4(:),8,G2tensor(523),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(450),0,ex4(:),8,G2tensor(524),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(453),23,ex4(:),8,G2tensor(525),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(454),27,ex3(:),G2tensor(526),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(455),0,ex3(:),G2tensor(527),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(458),27,ex3(:),G2tensor(528),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(459),27,ex3(:),4,G2tensor(529),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(460),0,ex3(:),4,G2tensor(530),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(463),27,ex3(:),4,G2tensor(531),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(464),27,ex3(:),4,G2tensor(532),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(465),0,ex3(:),4,G2tensor(533),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(468),27,ex3(:),4,G2tensor(534),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(469),23,ex4(:),8,G2tensor(535),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(470),0,ex4(:),8,G2tensor(536),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(473),23,ex4(:),8,G2tensor(537),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(474),23,ex4(:),G2tensor(538),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(475),0,ex4(:),G2tensor(539),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(478),23,ex4(:),G2tensor(540),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(479),23,ex4(:),8,G2tensor(541),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(480),0,ex4(:),8,G2tensor(542),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(483),23,ex4(:),8,G2tensor(543),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(484),27,ex3(:),G2tensor(544),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(485),0,ex3(:),G2tensor(545),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(488),27,ex3(:),G2tensor(546),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(489),27,ex3(:),G2tensor(547),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(490),0,ex3(:),G2tensor(548),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(493),27,ex3(:),G2tensor(549),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(494),27,ex3(:),4,G2tensor(550),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(495),0,ex3(:),4,G2tensor(551),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(498),27,ex3(:),4,G2tensor(552),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(499),27,ex3(:),4,G2tensor(553),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(500),0,ex3(:),4,G2tensor(554),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(503),27,ex3(:),4,G2tensor(555),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(504),27,ex3(:),4,G2tensor(556),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(505),0,ex3(:),4,G2tensor(557),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(508),27,ex3(:),4,G2tensor(558),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(509),27,ex3(:),4,G2tensor(559),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(510),0,ex3(:),4,G2tensor(560),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(513),27,ex3(:),4,G2tensor(561),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(514),23,ex4(:),G2tensor(562),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(515),0,ex4(:),G2tensor(563),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(518),23,ex4(:),G2tensor(564),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(519),23,ex4(:),8,G2tensor(565),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(520),0,ex4(:),8,G2tensor(566),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(523),23,ex4(:),8,G2tensor(567),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(524),23,ex4(:),8,G2tensor(568),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(525),0,ex4(:),8,G2tensor(569),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(528),23,ex4(:),8,G2tensor(570),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(529),29,ex2(:),G2tensor(571),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(530),0,ex2(:),G2tensor(572),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(533),29,ex2(:),G2tensor(573),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(534),29,ex2(:),G2tensor(574),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(535),0,ex2(:),G2tensor(575),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(538),29,ex2(:),G2tensor(576),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(539),29,ex2(:),2,G2tensor(577),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(540),0,ex2(:),2,G2tensor(578),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(543),29,ex2(:),2,G2tensor(579),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(544),29,ex2(:),2,G2tensor(580),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(545),0,ex2(:),2,G2tensor(581),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(548),29,ex2(:),2,G2tensor(582),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(549),29,ex2(:),2,G2tensor(583),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(550),0,ex2(:),2,G2tensor(584),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(553),29,ex2(:),2,G2tensor(585),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(554),29,ex2(:),2,G2tensor(586),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(555),0,ex2(:),2,G2tensor(587),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(558),29,ex2(:),2,G2tensor(588),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(559),27,ex3(:),G2tensor(589),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(560),0,ex3(:),G2tensor(590),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(563),27,ex3(:),G2tensor(591),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(564),27,ex3(:),G2tensor(592),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(565),0,ex3(:),G2tensor(593),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(568),27,ex3(:),G2tensor(594),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(569),27,ex3(:),4,G2tensor(595),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(570),0,ex3(:),4,G2tensor(596),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(573),27,ex3(:),4,G2tensor(597),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(574),27,ex3(:),4,G2tensor(598),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(575),0,ex3(:),4,G2tensor(599),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(578),27,ex3(:),4,G2tensor(600),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(579),27,ex3(:),4,G2tensor(601),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(580),0,ex3(:),4,G2tensor(602),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(583),27,ex3(:),4,G2tensor(603),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(584),27,ex3(:),4,G2tensor(604),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(585),0,ex3(:),4,G2tensor(605),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(588),27,ex3(:),4,G2tensor(606),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(589),29,ex2(:),G2tensor(607),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(590),0,ex2(:),G2tensor(608),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(593),29,ex2(:),G2tensor(609),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(594),29,ex2(:),G2tensor(610),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(595),0,ex2(:),G2tensor(611),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(598),29,ex2(:),G2tensor(612),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(599),29,ex2(:),2,G2tensor(613),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(600),0,ex2(:),2,G2tensor(614),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(603),29,ex2(:),2,G2tensor(615),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(604),29,ex2(:),2,G2tensor(616),m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(605),0,ex2(:),2,G2tensor(617),m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(608),29,ex2(:),2,G2tensor(618),m3h2x1(:,720),heltab2x2(:,:,720))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(609),29,ex2(:),2,G2tensor(619),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(610),0,ex2(:),2,G2tensor(620),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(613),29,ex2(:),2,G2tensor(621),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(614),29,ex2(:),2,G2tensor(622),m3h2x1(:,724),heltab2x2(:,:,724))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(615),0,ex2(:),2,G2tensor(623),m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(618),29,ex2(:),2,G2tensor(624),m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(387),26,wf4(:,2),G2tensor(625),m3h4x1(:,49),heltab2x4(:,:,949))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(403),0,wf4(:,2),G2tensor(626),m3h4x1(:,50),heltab2x4(:,:,950))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(451),26,wf4(:,2),G2tensor(627),m3h4x1(:,51),heltab2x4(:,:,951))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(467),26,wf4(:,2),5,G2tensor(628),m3h4x1(:,52),heltab2x4(:,:,952))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(483),0,wf4(:,2),5,G2tensor(629),m3h4x1(:,53),heltab2x4(:,:,953))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(531),26,wf4(:,2),5,G2tensor(630),m3h4x1(:,54),heltab2x4(:,:,954))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(547),26,wf4(:,2),5,G2tensor(631),m3h4x1(:,55),heltab2x4(:,:,955))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(563),0,wf4(:,2),5,G2tensor(632),m3h4x1(:,56),heltab2x4(:,:,956))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(14),26,wf4(:,2),5,G2tensor(633),m3h4x1(:,57),heltab2x4(:,:,957))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(399),25,wf4(:,5),G2tensor(634),m3h4x1(:,58),heltab2x4(:,:,958))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(25),0,wf4(:,5),G2tensor(635),m3h4x1(:,59),heltab2x4(:,:,959))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(415),25,wf4(:,5),G2tensor(636),m3h4x1(:,60),heltab2x4(:,:,960))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(41),25,wf4(:,5),6,G2tensor(637),m3h4x1(:,61),heltab2x4(:,:,961))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(426),0,wf4(:,5),6,G2tensor(638),m3h4x1(:,62),heltab2x4(:,:,962))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(57),25,wf4(:,5),6,G2tensor(639),m3h4x1(:,63),heltab2x4(:,:,963))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(218),25,wf4(:,5),6,G2tensor(640),m3h4x1(:,64),heltab2x4(:,:,964))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(62),0,wf4(:,5),6,G2tensor(641),m3h4x1(:,65),heltab2x4(:,:,965))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(202),25,wf4(:,5),6,G2tensor(642),m3h4x1(:,66),heltab2x4(:,:,966))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(78),22,wf4(:,3),G2tensor(643),m3h4x1(:,67),heltab2x4(:,:,967))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(207),0,wf4(:,3),G2tensor(644),m3h4x1(:,68),heltab2x4(:,:,968))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(94),22,wf4(:,3),G2tensor(645),m3h4x1(:,69),heltab2x4(:,:,969))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(239),22,wf4(:,3),9,G2tensor(646),m3h4x1(:,70),heltab2x4(:,:,970))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(105),0,wf4(:,3),9,G2tensor(647),m3h4x1(:,71),heltab2x4(:,:,971))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(303),22,wf4(:,3),9,G2tensor(648),m3h4x1(:,72),heltab2x4(:,:,972))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(121),22,wf4(:,3),9,G2tensor(649),m3h4x1(:,73),heltab2x4(:,:,973))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(314),0,wf4(:,3),9,G2tensor(650),m3h4x1(:,74),heltab2x4(:,:,974))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(137),22,wf4(:,3),9,G2tensor(651),m3h4x1(:,75),heltab2x4(:,:,975))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(330),22,wf4(:,3),9,G2tensor(652),m3h4x1(:,76),heltab2x4(:,:,976))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(142),0,wf4(:,3),9,G2tensor(653),m3h4x1(:,77),heltab2x4(:,:,977))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(266),22,wf4(:,3),9,G2tensor(654),m3h4x1(:,78),heltab2x4(:,:,978))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(158),22,wf4(:,3),G2tensor(655),m3h4x1(:,79),heltab2x4(:,:,979))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(271),0,wf4(:,3),G2tensor(656),m3h4x1(:,80),heltab2x4(:,:,980))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(174),22,wf4(:,3),G2tensor(657),m3h4x1(:,81),heltab2x4(:,:,981))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(255),22,wf4(:,3),9,G2tensor(658),m3h4x1(:,82),heltab2x4(:,:,982))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(185),0,wf4(:,3),9,G2tensor(659),m3h4x1(:,83),heltab2x4(:,:,983))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(287),22,wf4(:,3),9,G2tensor(660),m3h4x1(:,84),heltab2x4(:,:,984))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(201),21,wf4(:,6),G2tensor(661),m3h4x1(:,85),heltab2x4(:,:,985))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(206),0,wf4(:,6),G2tensor(662),m3h4x1(:,86),heltab2x4(:,:,986))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(233),21,wf4(:,6),G2tensor(663),m3h4x1(:,87),heltab2x4(:,:,987))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(238),21,wf4(:,6),10,G2tensor(664),m3h4x1(:,88),heltab2x4(:,:,988))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(249),0,wf4(:,6),10,G2tensor(665),m3h4x1(:,89),heltab2x4(:,:,989))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(270),21,wf4(:,6),10,G2tensor(666),m3h4x1(:,90),heltab2x4(:,:,990))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(281),21,wf4(:,6),10,G2tensor(667),m3h4x1(:,91),heltab2x4(:,:,991))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(286),0,wf4(:,6),10,G2tensor(668),m3h4x1(:,92),heltab2x4(:,:,992))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(313),21,wf4(:,6),10,G2tensor(669),m3h4x1(:,93),heltab2x4(:,:,993))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(318),21,wf4(:,6),10,G2tensor(670),m3h4x1(:,94),heltab2x4(:,:,994))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(329),0,wf4(:,6),10,G2tensor(671),m3h4x1(:,95),heltab2x4(:,:,995))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(346),21,wf4(:,6),10,G2tensor(672),m3h4x1(:,96),heltab2x4(:,:,996))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(350),21,wf4(:,6),G2tensor(673),m3h4x1(:,97),heltab2x4(:,:,997))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(351),0,wf4(:,6),G2tensor(674),m3h4x1(:,98),heltab2x4(:,:,998))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(366),21,wf4(:,6),G2tensor(675),m3h4x1(:,99),heltab2x4(:,:,999))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(367),21,wf4(:,6),10,G2tensor(676),m3h4x1(:,100),heltab2x4(:,:,1000))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(377),0,wf4(:,6),10,G2tensor(677),m3h4x1(:,101),heltab2x4(:,:,1001))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(383),21,wf4(:,6),10,G2tensor(678),m3h4x1(:,102),heltab2x4(:,:,1002))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(393),19,wf4(:,8),G2tensor(679),m3h4x1(:,103),heltab2x4(:,:,1003))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(398),0,wf4(:,8),G2tensor(680),m3h4x1(:,104),heltab2x4(:,:,1004))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(425),19,wf4(:,8),G2tensor(681),m3h4x1(:,105),heltab2x4(:,:,1005))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(430),19,wf4(:,8),12,G2tensor(682),m3h4x1(:,106),heltab2x4(:,:,1006))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(441),0,wf4(:,8),12,G2tensor(683),m3h4x1(:,107),heltab2x4(:,:,1007))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(447),19,wf4(:,8),12,G2tensor(684),m3h4x1(:,108),heltab2x4(:,:,1008))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(457),19,wf4(:,8),12,G2tensor(685),m3h4x1(:,109),heltab2x4(:,:,1009))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(458),0,wf4(:,8),12,G2tensor(686),m3h4x1(:,110),heltab2x4(:,:,1010))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(473),19,wf4(:,8),12,G2tensor(687),m3h4x1(:,111),heltab2x4(:,:,1011))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(474),19,wf4(:,8),12,G2tensor(688),m3h4x1(:,112),heltab2x4(:,:,1012))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(478),0,wf4(:,8),12,G2tensor(689),m3h4x1(:,113),heltab2x4(:,:,1013))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(490),19,wf4(:,8),12,G2tensor(690),m3h4x1(:,114),heltab2x4(:,:,1014))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(494),19,wf4(:,8),G2tensor(691),m3h4x1(:,115),heltab2x4(:,:,1015))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(495),0,wf4(:,8),G2tensor(692),m3h4x1(:,116),heltab2x4(:,:,1016))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(510),19,wf4(:,8),G2tensor(693),m3h4x1(:,117),heltab2x4(:,:,1017))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(511),19,wf4(:,8),12,G2tensor(694),m3h4x1(:,118),heltab2x4(:,:,1018))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(521),0,wf4(:,8),12,G2tensor(695),m3h4x1(:,119),heltab2x4(:,:,1019))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(527),19,wf4(:,8),12,G2tensor(696),m3h4x1(:,120),heltab2x4(:,:,1020))
  call ol_merge_tensors(G2tensor(312),[G2tensor(311),G2tensor(310),G2tensor(3),G2tensor(2),G2tensor(1)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(317),G2tensor(316),G2tensor(12),G2tensor(11),G2tensor(10),G2tensor(6),G2tensor(5) &
    ,G2tensor(4)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(305),G2tensor(304),G2tensor(9),G2tensor(8),G2tensor(7)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(314),G2tensor(313),G2tensor(18),G2tensor(17),G2tensor(16),G2tensor(15) &
    ,G2tensor(14),G2tensor(13)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(302),G2tensor(301),G2tensor(21),G2tensor(20),G2tensor(19)])
  call ol_merge_tensors(G2tensor(297),[G2tensor(296),G2tensor(295),G2tensor(24),G2tensor(23),G2tensor(22)])
  call ol_merge_tensors(G2tensor(309),[G2tensor(308),G2tensor(307),G2tensor(30),G2tensor(29),G2tensor(28),G2tensor(27) &
    ,G2tensor(26),G2tensor(25)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(299),G2tensor(298),G2tensor(36),G2tensor(35),G2tensor(34),G2tensor(33) &
    ,G2tensor(32),G2tensor(31)])
  call ol_merge_tensors(G2tensor(331),[G2tensor(325),G2tensor(319),G2tensor(46),G2tensor(42),G2tensor(38),G1tensor(2)])
  call ol_merge_tensors(G2tensor(676),[G2tensor(673),G2tensor(670),G2tensor(269),G2tensor(267),G2tensor(265),G2tensor(47) &
    ,G2tensor(43),G2tensor(39),G1tensor(6)])
  call ol_merge_tensors(G2tensor(349),[G2tensor(343),G2tensor(337),G2tensor(58),G2tensor(54),G2tensor(50),G1tensor(8)])
  call ol_merge_tensors(G2tensor(694),[G2tensor(691),G2tensor(688),G2tensor(257),G2tensor(255),G2tensor(253),G2tensor(83) &
    ,G2tensor(79),G2tensor(75),G2tensor(59),G2tensor(55),G2tensor(51),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(361),[G2tensor(358),G2tensor(355),G2tensor(70),G2tensor(66),G2tensor(62),G1tensor(14)])
  call ol_merge_tensors(G2tensor(658),[G2tensor(655),G2tensor(652),G2tensor(287),G2tensor(285),G2tensor(283),G2tensor(71) &
    ,G2tensor(67),G2tensor(63),G1tensor(18)])
  call ol_merge_tensors(G2tensor(376),[G2tensor(370),G2tensor(364),G2tensor(82),G2tensor(78),G2tensor(74),G1tensor(20) &
    ,G1tensor(15)])
  call ol_merge_tensors(G2tensor(394),[G2tensor(388),G2tensor(382),G2tensor(94),G2tensor(90),G2tensor(86),G1tensor(26)])
  call ol_merge_tensors(G2tensor(685),[G2tensor(682),G2tensor(679),G2tensor(251),G2tensor(249),G2tensor(247),G2tensor(107) &
    ,G2tensor(103),G2tensor(99),G2tensor(95),G2tensor(91),G2tensor(87),G1tensor(36),G1tensor(30)])
  call ol_merge_tensors(G2tensor(412),[G2tensor(406),G2tensor(400),G2tensor(106),G2tensor(102),G2tensor(98),G1tensor(32) &
    ,G1tensor(3)])
  call ol_merge_tensors(G2tensor(424),[G2tensor(421),G2tensor(418),G2tensor(118),G2tensor(114),G2tensor(110),G1tensor(38)])
  call ol_merge_tensors(G2tensor(649),[G2tensor(646),G2tensor(643),G2tensor(281),G2tensor(279),G2tensor(277),G2tensor(119) &
    ,G2tensor(115),G2tensor(111),G1tensor(42)])
  call ol_merge_tensors(G2tensor(433),[G2tensor(430),G2tensor(427),G2tensor(130),G2tensor(126),G2tensor(122),G1tensor(44)])
  call ol_merge_tensors(G2tensor(631),[G2tensor(628),G2tensor(625),G2tensor(293),G2tensor(291),G2tensor(289),G2tensor(131) &
    ,G2tensor(127),G2tensor(123),G1tensor(48)])
  call ol_merge_tensors(G2tensor(442),[G2tensor(439),G2tensor(436),G2tensor(142),G2tensor(138),G2tensor(134),G1tensor(50)])
  call ol_merge_tensors(G2tensor(667),[G2tensor(664),G2tensor(661),G2tensor(263),G2tensor(261),G2tensor(259),G2tensor(155) &
    ,G2tensor(151),G2tensor(147),G2tensor(143),G2tensor(139),G2tensor(135),G1tensor(60),G1tensor(54)])
  call ol_merge_tensors(G2tensor(457),[G2tensor(451),G2tensor(445),G2tensor(154),G2tensor(150),G2tensor(146),G1tensor(56) &
    ,G1tensor(9)])
  call ol_merge_tensors(G2tensor(469),[G2tensor(466),G2tensor(463),G2tensor(166),G2tensor(162),G2tensor(158),G1tensor(62)])
  call ol_merge_tensors(G2tensor(640),[G2tensor(637),G2tensor(634),G2tensor(275),G2tensor(273),G2tensor(271),G2tensor(179) &
    ,G2tensor(175),G2tensor(171),G2tensor(167),G2tensor(163),G2tensor(159),G1tensor(72),G1tensor(66)])
  call ol_merge_tensors(G2tensor(478),[G2tensor(475),G2tensor(472),G2tensor(178),G2tensor(174),G2tensor(170),G1tensor(68) &
    ,G1tensor(21)])
  call ol_merge_tensors(G2tensor(487),[G2tensor(484),G2tensor(481),G1tensor(52),G1tensor(4)])
  call ol_merge_tensors(G2tensor(334),[G2tensor(328),G2tensor(322),G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(496),[G2tensor(493),G2tensor(490),G1tensor(28),G1tensor(10)])
  call ol_merge_tensors(G2tensor(352),[G2tensor(346),G2tensor(340),G1tensor(41),G1tensor(11)])
  call ol_merge_tensors(G2tensor(505),[G2tensor(502),G2tensor(499),G1tensor(40),G1tensor(16)])
  call ol_merge_tensors(G2tensor(514),[G2tensor(511),G2tensor(508),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(379),[G2tensor(373),G2tensor(367),G1tensor(47),G1tensor(23)])
  call ol_merge_tensors(G2tensor(523),[G2tensor(520),G2tensor(517),G1tensor(27)])
  call ol_merge_tensors(G2tensor(397),[G2tensor(391),G2tensor(385),G1tensor(53),G1tensor(29)])
  call ol_merge_tensors(G2tensor(532),[G2tensor(529),G2tensor(526),G1tensor(33)])
  call ol_merge_tensors(G2tensor(415),[G2tensor(409),G2tensor(403),G1tensor(65),G1tensor(35)])
  call ol_merge_tensors(G2tensor(541),[G2tensor(538),G2tensor(535),G1tensor(39)])
  call ol_merge_tensors(G2tensor(556),[G2tensor(550),G2tensor(544),G1tensor(45)])
  call ol_merge_tensors(G2tensor(559),[G2tensor(553),G2tensor(547),G1tensor(46)])
  call ol_merge_tensors(G2tensor(568),[G2tensor(565),G2tensor(562),G1tensor(51)])
  call ol_merge_tensors(G2tensor(583),[G2tensor(577),G2tensor(571),G1tensor(57)])
  call ol_merge_tensors(G2tensor(586),[G2tensor(580),G2tensor(574),G1tensor(58)])
  call ol_merge_tensors(G2tensor(460),[G2tensor(454),G2tensor(448),G1tensor(71),G1tensor(59)])
  call ol_merge_tensors(G2tensor(601),[G2tensor(595),G2tensor(589),G1tensor(63)])
  call ol_merge_tensors(G2tensor(604),[G2tensor(598),G2tensor(592),G1tensor(64)])
  call ol_merge_tensors(G2tensor(619),[G2tensor(613),G2tensor(607),G1tensor(69)])
  call ol_merge_tensors(G2tensor(622),[G2tensor(616),G2tensor(610),G1tensor(70)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(37),G2tensor(41)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(65),G2tensor(49)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(73),G2tensor(77)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(101),G2tensor(85)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(109),G2tensor(113)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(137),G2tensor(121)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(161),G2tensor(149)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(157),G2tensor(145)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(69),G2tensor(45)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(81),G2tensor(57)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(141),G2tensor(117)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(153),G2tensor(129)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(183),G2tensor(181)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(184),G2tensor(182)])
  call ol_merge_tensors(G2tensor(189),[G2tensor(188),G2tensor(187)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(191),G2tensor(190)])
  call ol_merge_tensors(G2tensor(195),[G2tensor(194),G2tensor(193)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(198),G2tensor(196)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(199),G2tensor(197)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(203),G2tensor(202)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(207),G2tensor(205)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(208),G2tensor(206)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(213),G2tensor(211)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(214),G2tensor(212)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(219),G2tensor(217)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(220),G2tensor(218)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(224),G2tensor(223)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(227),G2tensor(226)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(230),G2tensor(229)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(233),G2tensor(232)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(236),G2tensor(235)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(239),G2tensor(238)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(242),G2tensor(241)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(245),G2tensor(244)])
  call Hotf_4pt_reduction_last(G2tensor(312),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G0tensor(1))
  call G_TensorShift(G1tensor(7),10)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(4),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G0tensor(2))
  call G_TensorShift(G1tensor(37),12)
  call Hotf_4pt_reduction_last(G2tensor(306),RedSet_4(5),mass4set(:,1),  & 
G1tensor(61),G1tensor(67),G1tensor(2),G1tensor(6),G1tensor(8),G0tensor(3))
  call G_TensorShift(G1tensor(67),9)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(8),mass4set(:,1),  & 
G1tensor(24),G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(20),G0tensor(4))
  call G_TensorShift(G1tensor(12),12)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(10),mass4set(:,1),  & 
G1tensor(15),G1tensor(26),G1tensor(36),G1tensor(30),G1tensor(32),G0tensor(5))
  call G_TensorShift(G1tensor(26),9)
  call Hotf_4pt_reduction_last(G2tensor(297),RedSet_4(11),mass4set(:,1),  & 
G1tensor(3),G1tensor(38),G1tensor(42),G1tensor(44),G1tensor(48),G0tensor(6))
  call G_TensorShift(G1tensor(38),5)
  call Hotf_4pt_reduction_last(G2tensor(309),RedSet_4(12),mass4set(:,1),  & 
G1tensor(50),G1tensor(60),G1tensor(54),G1tensor(56),G1tensor(9),G0tensor(7))
  call G_TensorShift(G1tensor(60),10)
  call Hotf_4pt_reduction_last(G2tensor(300),RedSet_4(14),mass4set(:,1),  & 
G1tensor(62),G1tensor(72),G1tensor(66),G1tensor(68),G1tensor(21),G0tensor(8))
  call G_TensorShift(G1tensor(72),6)
  call Hotf_4pt_reduction_last(G2tensor(331),RedSet_4(47),mass4set(:,1),  & 
G1tensor(52),G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(28))
  call G_TensorShift(G1tensor(4),2)
  call Hotf_4pt_reduction_last(G2tensor(676),RedSet_4(2),mass4set(:,1),  & 
G1tensor(10),G1tensor(41),G1tensor(11),G1tensor(40),G1tensor(16))
  call G_TensorShift(G1tensor(41),10)
  call Hotf_4pt_reduction_last(G2tensor(349),RedSet_4(48),mass4set(:,1),  & 
G1tensor(34),G1tensor(22),G1tensor(47),G1tensor(23),G1tensor(27))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(694),RedSet_4(4),mass4set(:,1),  & 
G1tensor(53),G1tensor(29),G1tensor(33),G1tensor(65),G1tensor(35))
  call G_TensorShift(G1tensor(29),12)
  call Hotf_4pt_reduction_last(G2tensor(361),RedSet_4(49),mass4set(:,1),  & 
G1tensor(39),G1tensor(45),G1tensor(46),G1tensor(51),G1tensor(57))
  call G_TensorShift(G1tensor(45),1)
  call Hotf_4pt_reduction_last(G2tensor(658),RedSet_4(5),mass4set(:,1),  & 
G1tensor(58),G1tensor(71),G1tensor(59),G1tensor(63),G1tensor(64))
  call G_TensorShift(G1tensor(71),9)
  call Hotf_4pt_reduction_last(G2tensor(376),RedSet_4(21),mass4set(:,1),  & 
G1tensor(69),G1tensor(70),G1tensor(1),G1tensor(31),G1tensor(61))
  call G_TensorShift(G1tensor(70),8)
  call Hotf_4pt_reduction_last(G2tensor(394),RedSet_4(50),mass4set(:,1),  & 
G1tensor(24),G1tensor(15),G1tensor(3),G1tensor(50),G1tensor(62))
  call G_TensorShift(G1tensor(15),4)
  call Hotf_4pt_reduction_last(G2tensor(685),RedSet_4(8),mass4set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77))
  call G_TensorShift(G1tensor(74),12)
  call Hotf_4pt_reduction_last(G2tensor(412),RedSet_4(15),mass4set(:,1),  & 
G1tensor(78),G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82))
  call G_TensorShift(G1tensor(79),8)
  call Hotf_4pt_reduction_last(G2tensor(424),RedSet_4(51),mass4set(:,1),  & 
G1tensor(83),G1tensor(84),G1tensor(85),G1tensor(86),G1tensor(87))
  call G_TensorShift(G1tensor(84),1)
  call Hotf_4pt_reduction_last(G2tensor(649),RedSet_4(10),mass4set(:,1),  & 
G1tensor(88),G1tensor(89),G1tensor(90),G1tensor(91),G1tensor(92))
  call G_TensorShift(G1tensor(89),9)
  call Hotf_4pt_reduction_last(G2tensor(433),RedSet_4(52),mass4set(:,1),  & 
G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96),G1tensor(97))
  call G_TensorShift(G1tensor(94),1)
  call Hotf_4pt_reduction_last(G2tensor(631),RedSet_4(11),mass4set(:,1),  & 
G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(99),5)
  call Hotf_4pt_reduction_last(G2tensor(442),RedSet_4(53),mass4set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107))
  call G_TensorShift(G1tensor(104),2)
  call Hotf_4pt_reduction_last(G2tensor(667),RedSet_4(12),mass4set(:,1),  & 
G1tensor(108),G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112))
  call G_TensorShift(G1tensor(109),10)
  call Hotf_4pt_reduction_last(G2tensor(457),RedSet_4(18),mass4set(:,1),  & 
G1tensor(113),G1tensor(114),G1tensor(115),G1tensor(116),G1tensor(117))
  call G_TensorShift(G1tensor(114),8)
  call Hotf_4pt_reduction_last(G2tensor(469),RedSet_4(54),mass4set(:,1),  & 
G1tensor(118),G1tensor(119),G1tensor(120),G1tensor(121),G1tensor(122))
  call G_TensorShift(G1tensor(119),2)
  call Hotf_4pt_reduction_last(G2tensor(640),RedSet_4(14),mass4set(:,1),  & 
G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126),G1tensor(127))
  call G_TensorShift(G1tensor(124),6)
  call Hotf_4pt_reduction_last(G2tensor(478),RedSet_4(24),mass4set(:,1),  & 
G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(129),4)
  call Hotf_4pt_reduction_last(G2tensor(487),RedSet_4(16),mass4set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_4pt_reduction_last(G2tensor(334),RedSet_4(1),mass4set(:,1),  & 
G1tensor(138),G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142))
  call G_TensorShift(G1tensor(139),8)
  call Hotf_4pt_reduction_last(G2tensor(496),RedSet_4(19),mass4set(:,1),  & 
G1tensor(143),G1tensor(144),G1tensor(145),G1tensor(146),G1tensor(147))
  call G_TensorShift(G1tensor(144),8)
  call Hotf_4pt_reduction_last(G2tensor(352),RedSet_4(3),mass4set(:,1),  & 
G1tensor(148),G1tensor(149),G1tensor(150),G1tensor(151),G1tensor(152))
  call G_TensorShift(G1tensor(149),8)
  call Hotf_4pt_reduction_last(G2tensor(505),RedSet_4(22),mass4set(:,1),  & 
G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156),G1tensor(157))
  call G_TensorShift(G1tensor(154),8)
  call Hotf_4pt_reduction_last(G2tensor(514),RedSet_4(25),mass4set(:,1),  & 
G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(159),4)
  call Hotf_4pt_reduction_last(G2tensor(379),RedSet_4(6),mass4set(:,1),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_4pt_reduction_last(G2tensor(523),RedSet_4(27),mass4set(:,1),  & 
G1tensor(168),G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172))
  call G_TensorShift(G1tensor(169),8)
  call Hotf_4pt_reduction_last(G2tensor(397),RedSet_4(7),mass4set(:,1),  & 
G1tensor(173),G1tensor(174),G1tensor(175),G1tensor(176),G1tensor(177))
  call G_TensorShift(G1tensor(174),8)
  call Hotf_4pt_reduction_last(G2tensor(532),RedSet_4(29),mass4set(:,1),  & 
G1tensor(178),G1tensor(179),G1tensor(180),G1tensor(181),G1tensor(182))
  call G_TensorShift(G1tensor(179),4)
  call Hotf_4pt_reduction_last(G2tensor(415),RedSet_4(9),mass4set(:,1),  & 
G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186),G1tensor(187))
  call G_TensorShift(G1tensor(184),4)
  call Hotf_4pt_reduction_last(G2tensor(541),RedSet_4(31),mass4set(:,1),  & 
G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(189),8)
  call Hotf_4pt_reduction_last(G2tensor(556),RedSet_4(33),mass4set(:,1),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_4pt_reduction_last(G2tensor(559),RedSet_4(34),mass4set(:,1),  & 
G1tensor(198),G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202))
  call G_TensorShift(G1tensor(199),4)
  call Hotf_4pt_reduction_last(G2tensor(568),RedSet_4(36),mass4set(:,1),  & 
G1tensor(203),G1tensor(204),G1tensor(205),G1tensor(206),G1tensor(207))
  call G_TensorShift(G1tensor(204),8)
  call Hotf_4pt_reduction_last(G2tensor(583),RedSet_4(38),mass4set(:,1),  & 
G1tensor(208),G1tensor(209),G1tensor(210),G1tensor(211),G1tensor(212))
  call G_TensorShift(G1tensor(209),2)
  call Hotf_4pt_reduction_last(G2tensor(586),RedSet_4(39),mass4set(:,1),  & 
G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216),G1tensor(217))
  call G_TensorShift(G1tensor(214),2)
  call Hotf_4pt_reduction_last(G2tensor(460),RedSet_4(13),mass4set(:,1),  & 
G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(219),2)
  call Hotf_4pt_reduction_last(G2tensor(601),RedSet_4(41),mass4set(:,1),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_4pt_reduction_last(G2tensor(604),RedSet_4(42),mass4set(:,1),  & 
G1tensor(228),G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232))
  call G_TensorShift(G1tensor(229),4)
  call Hotf_4pt_reduction_last(G2tensor(619),RedSet_4(44),mass4set(:,1),  & 
G1tensor(233),G1tensor(234),G1tensor(235),G1tensor(236),G1tensor(237))
  call G_TensorShift(G1tensor(234),2)
  call Hotf_4pt_reduction_last(G2tensor(622),RedSet_4(45),mass4set(:,1),  & 
G1tensor(238),G1tensor(239),G1tensor(240),G1tensor(241),G1tensor(242))
  call G_TensorShift(G1tensor(239),2)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(1),mass4set(:,1),  & 
G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246),G1tensor(247),G0tensor(9))
  call G_TensorShift(G1tensor(244),8)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(3),mass4set(:,1),  & 
G1tensor(243),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G0tensor(10))
  call G_TensorShift(G1tensor(248),8)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(6),mass4set(:,1),  & 
G1tensor(243),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255),G0tensor(11))
  call G_TensorShift(G1tensor(252),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(7),mass4set(:,1),  & 
G1tensor(243),G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G0tensor(12))
  call G_TensorShift(G1tensor(256),8)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(9),mass4set(:,1),  & 
G1tensor(243),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G0tensor(13))
  call G_TensorShift(G1tensor(260),4)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(13),mass4set(:,1),  & 
G1tensor(243),G1tensor(264),G1tensor(265),G1tensor(266),G1tensor(267),G0tensor(14))
  call G_TensorShift(G1tensor(264),2)
  call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(47),mass4set(:,1),  & 
G1tensor(243),G1tensor(268),G1tensor(269),G1tensor(270),G1tensor(271),G0tensor(15))
  call G_TensorShift(G1tensor(268),2)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(16),mass4set(:,1),  & 
G1tensor(243),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G0tensor(16))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(48),mass4set(:,1),  & 
G1tensor(243),G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G0tensor(17))
  call G_TensorShift(G1tensor(276),4)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(19),mass4set(:,1),  & 
G1tensor(243),G1tensor(280),G1tensor(281),G1tensor(282),G1tensor(283),G0tensor(18))
  call G_TensorShift(G1tensor(280),8)
  call Hotf_4pt_reduction_last(G2tensor(165),RedSet_4(49),mass4set(:,1),  & 
G1tensor(243),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G0tensor(19))
  call G_TensorShift(G1tensor(284),1)
  call Hotf_4pt_reduction_last(G2tensor(177),RedSet_4(22),mass4set(:,1),  & 
G1tensor(243),G1tensor(288),G1tensor(289),G1tensor(290),G1tensor(291),G0tensor(20))
  call G_TensorShift(G1tensor(288),8)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(21),mass4set(:,1),  & 
G1tensor(243),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295),G0tensor(21))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(186),RedSet_4(25),mass4set(:,1),  & 
G1tensor(243),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G0tensor(22))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_4pt_reduction_last(G2tensor(189),RedSet_4(50),mass4set(:,1),  & 
G1tensor(243),G1tensor(300),G1tensor(301),G1tensor(302),G1tensor(303),G0tensor(23))
  call G_TensorShift(G1tensor(300),4)
  call Hotf_4pt_reduction_last(G2tensor(192),RedSet_4(15),mass4set(:,1),  & 
G1tensor(243),G1tensor(304),G1tensor(305),G1tensor(306),G1tensor(307),G0tensor(24))
  call G_TensorShift(G1tensor(304),8)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(51),mass4set(:,1),  & 
G1tensor(243),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G0tensor(25))
  call G_TensorShift(G1tensor(308),1)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(52),mass4set(:,1),  & 
G1tensor(243),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315),G0tensor(26))
  call G_TensorShift(G1tensor(312),1)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(34),mass4set(:,1),  & 
G1tensor(243),G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G0tensor(27))
  call G_TensorShift(G1tensor(316),4)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(53),mass4set(:,1),  & 
G1tensor(243),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G0tensor(28))
  call G_TensorShift(G1tensor(320),2)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(18),mass4set(:,1),  & 
G1tensor(243),G1tensor(324),G1tensor(325),G1tensor(326),G1tensor(327),G0tensor(29))
  call G_TensorShift(G1tensor(324),8)
  call Hotf_4pt_reduction_last(G2tensor(210),RedSet_4(39),mass4set(:,1),  & 
G1tensor(243),G1tensor(328),G1tensor(329),G1tensor(330),G1tensor(331),G0tensor(30))
  call G_TensorShift(G1tensor(328),2)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(54),mass4set(:,1),  & 
G1tensor(243),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G0tensor(31))
  call G_TensorShift(G1tensor(332),2)
  call Hotf_4pt_reduction_last(G2tensor(216),RedSet_4(42),mass4set(:,1),  & 
G1tensor(243),G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G0tensor(32))
  call G_TensorShift(G1tensor(336),4)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(24),mass4set(:,1),  & 
G1tensor(243),G1tensor(340),G1tensor(341),G1tensor(342),G1tensor(343),G0tensor(33))
  call G_TensorShift(G1tensor(340),4)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(45),mass4set(:,1),  & 
G1tensor(243),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G0tensor(34))
  call G_TensorShift(G1tensor(344),2)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(27),mass4set(:,1),  & 
G1tensor(243),G1tensor(348),G1tensor(349),G1tensor(350),G1tensor(351),G0tensor(35))
  call G_TensorShift(G1tensor(348),8)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(29),mass4set(:,1),  & 
G1tensor(243),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355),G0tensor(36))
  call G_TensorShift(G1tensor(352),4)
  call Hotf_4pt_reduction_last(G2tensor(231),RedSet_4(31),mass4set(:,1),  & 
G1tensor(243),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G0tensor(37))
  call G_TensorShift(G1tensor(356),8)
  call Hotf_4pt_reduction_last(G2tensor(234),RedSet_4(33),mass4set(:,1),  & 
G1tensor(243),G1tensor(360),G1tensor(361),G1tensor(362),G1tensor(363),G0tensor(38))
  call G_TensorShift(G1tensor(360),4)
  call Hotf_4pt_reduction_last(G2tensor(237),RedSet_4(36),mass4set(:,1),  & 
G1tensor(243),G1tensor(364),G1tensor(365),G1tensor(366),G1tensor(367),G0tensor(39))
  call G_TensorShift(G1tensor(364),8)
  call Hotf_4pt_reduction_last(G2tensor(240),RedSet_4(38),mass4set(:,1),  & 
G1tensor(243),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G0tensor(40))
  call G_TensorShift(G1tensor(368),2)
  call Hotf_4pt_reduction_last(G2tensor(243),RedSet_4(41),mass4set(:,1),  & 
G1tensor(243),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375),G0tensor(41))
  call G_TensorShift(G1tensor(372),4)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(44),mass4set(:,1),  & 
G1tensor(243),G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G0tensor(42))
  call G_TensorShift(G1tensor(376),2)
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(47),mass4set(:,1),  & 
G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46),G0tensor(47))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(2),mass4set(:,1),  & 
G0tensor(48),G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(48),mass4set(:,1),  & 
G0tensor(53),G0tensor(54),G0tensor(55),G0tensor(56),G0tensor(57))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(4),mass4set(:,1),  & 
G0tensor(58),G0tensor(59),G0tensor(60),G0tensor(61),G0tensor(62))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(49),mass4set(:,1),  & 
G0tensor(63),G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(5),mass4set(:,1),  & 
G0tensor(68),G0tensor(69),G0tensor(70),G0tensor(71),G0tensor(72))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(21),mass4set(:,1),  & 
G0tensor(73),G0tensor(74),G0tensor(75),G0tensor(76),G0tensor(77))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(50),mass4set(:,1),  & 
G0tensor(78),G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82))
  call Hotf_4pt_reduction_last(G1tensor(73),RedSet_4(8),mass4set(:,1),  & 
G0tensor(83),G0tensor(84),G0tensor(85),G0tensor(86),G0tensor(87))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(15),mass4set(:,1),  & 
G0tensor(88),G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(51),mass4set(:,1),  & 
G0tensor(93),G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97))
  call Hotf_4pt_reduction_last(G1tensor(88),RedSet_4(10),mass4set(:,1),  & 
G0tensor(98),G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(52),mass4set(:,1),  & 
G0tensor(103),G0tensor(104),G0tensor(105),G0tensor(106),G0tensor(107))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(11),mass4set(:,1),  & 
G0tensor(108),G0tensor(109),G0tensor(110),G0tensor(111),G0tensor(112))
  call Hotf_4pt_reduction_last(G1tensor(103),RedSet_4(53),mass4set(:,1),  & 
G0tensor(113),G0tensor(114),G0tensor(115),G0tensor(116),G0tensor(117))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(12),mass4set(:,1),  & 
G0tensor(118),G0tensor(119),G0tensor(120),G0tensor(121),G0tensor(122))
  call Hotf_4pt_reduction_last(G1tensor(113),RedSet_4(18),mass4set(:,1),  & 
G0tensor(123),G0tensor(124),G0tensor(125),G0tensor(126),G0tensor(127))
  call Hotf_4pt_reduction_last(G1tensor(118),RedSet_4(54),mass4set(:,1),  & 
G0tensor(128),G0tensor(129),G0tensor(130),G0tensor(131),G0tensor(132))
  call Hotf_4pt_reduction_last(G1tensor(123),RedSet_4(14),mass4set(:,1),  & 
G0tensor(133),G0tensor(134),G0tensor(135),G0tensor(136),G0tensor(137))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(24),mass4set(:,1),  & 
G0tensor(138),G0tensor(139),G0tensor(140),G0tensor(141),G0tensor(142))
  call Hotf_4pt_reduction_last(G1tensor(133),RedSet_4(16),mass4set(:,1),  & 
G0tensor(143),G0tensor(144),G0tensor(145),G0tensor(146),G0tensor(147))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(1),mass4set(:,1),  & 
G0tensor(148),G0tensor(149),G0tensor(150),G0tensor(151),G0tensor(152))
  call Hotf_4pt_reduction_last(G1tensor(143),RedSet_4(19),mass4set(:,1),  & 
G0tensor(153),G0tensor(154),G0tensor(155),G0tensor(156),G0tensor(157))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(3),mass4set(:,1),  & 
G0tensor(158),G0tensor(159),G0tensor(160),G0tensor(161),G0tensor(162))
  call Hotf_4pt_reduction_last(G1tensor(153),RedSet_4(22),mass4set(:,1),  & 
G0tensor(163),G0tensor(164),G0tensor(165),G0tensor(166),G0tensor(167))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(25),mass4set(:,1),  & 
G0tensor(168),G0tensor(169),G0tensor(170),G0tensor(171),G0tensor(172))
  call Hotf_4pt_reduction_last(G1tensor(163),RedSet_4(6),mass4set(:,1),  & 
G0tensor(173),G0tensor(174),G0tensor(175),G0tensor(176),G0tensor(177))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(27),mass4set(:,1),  & 
G0tensor(178),G0tensor(179),G0tensor(180),G0tensor(181),G0tensor(182))
  call Hotf_4pt_reduction_last(G1tensor(173),RedSet_4(7),mass4set(:,1),  & 
G0tensor(183),G0tensor(184),G0tensor(185),G0tensor(186),G0tensor(187))
  call Hotf_4pt_reduction_last(G1tensor(178),RedSet_4(29),mass4set(:,1),  & 
G0tensor(188),G0tensor(189),G0tensor(190),G0tensor(191),G0tensor(192))
  call Hotf_4pt_reduction_last(G1tensor(183),RedSet_4(9),mass4set(:,1),  & 
G0tensor(193),G0tensor(194),G0tensor(195),G0tensor(196),G0tensor(197))
  call Hotf_4pt_reduction_last(G1tensor(188),RedSet_4(31),mass4set(:,1),  & 
G0tensor(198),G0tensor(199),G0tensor(200),G0tensor(201),G0tensor(202))
  call Hotf_4pt_reduction_last(G1tensor(193),RedSet_4(33),mass4set(:,1),  & 
G0tensor(203),G0tensor(204),G0tensor(205),G0tensor(206),G0tensor(207))
  call Hotf_4pt_reduction_last(G1tensor(198),RedSet_4(34),mass4set(:,1),  & 
G0tensor(208),G0tensor(209),G0tensor(210),G0tensor(211),G0tensor(212))
  call Hotf_4pt_reduction_last(G1tensor(203),RedSet_4(36),mass4set(:,1),  & 
G0tensor(213),G0tensor(214),G0tensor(215),G0tensor(216),G0tensor(217))
  call Hotf_4pt_reduction_last(G1tensor(208),RedSet_4(38),mass4set(:,1),  & 
G0tensor(218),G0tensor(219),G0tensor(220),G0tensor(221),G0tensor(222))
  call Hotf_4pt_reduction_last(G1tensor(213),RedSet_4(39),mass4set(:,1),  & 
G0tensor(223),G0tensor(224),G0tensor(225),G0tensor(226),G0tensor(227))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(13),mass4set(:,1),  & 
G0tensor(228),G0tensor(229),G0tensor(230),G0tensor(231),G0tensor(232))
  call Hotf_4pt_reduction_last(G1tensor(223),RedSet_4(41),mass4set(:,1),  & 
G0tensor(233),G0tensor(234),G0tensor(235),G0tensor(236),G0tensor(237))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(42),mass4set(:,1),  & 
G0tensor(238),G0tensor(239),G0tensor(240),G0tensor(241),G0tensor(242))
  call Hotf_4pt_reduction_last(G1tensor(233),RedSet_4(44),mass4set(:,1),  & 
G0tensor(243),G0tensor(244),G0tensor(245),G0tensor(246),G0tensor(247))
  call Hotf_4pt_reduction_last(G1tensor(238),RedSet_4(45),mass4set(:,1),  & 
G0tensor(248),G0tensor(249),G0tensor(250),G0tensor(251),G0tensor(252))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(2)])
  call ol_merge_tensors(T0sum(3),[G0tensor(3)])
  call ol_merge_tensors(T0sum(4),[G0tensor(4)])
  call ol_merge_tensors(T0sum(5),[G0tensor(5)])
  call ol_merge_tensors(T0sum(6),[G0tensor(6)])
  call ol_merge_tensors(T0sum(7),[G0tensor(7)])
  call ol_merge_tensors(T0sum(8),[G0tensor(8)])
  call ol_merge_tensors(T0sum(9),[G0tensor(43)])
  call ol_merge_tensors(T0sum(10),[G0tensor(48)])
  call ol_merge_tensors(T0sum(11),[G0tensor(53)])
  call ol_merge_tensors(T0sum(12),[G0tensor(58)])
  call ol_merge_tensors(T0sum(13),[G0tensor(63)])
  call ol_merge_tensors(T0sum(14),[G0tensor(68)])
  call ol_merge_tensors(T0sum(15),[G0tensor(73)])
  call ol_merge_tensors(T0sum(16),[G0tensor(78)])
  call ol_merge_tensors(T0sum(17),[G0tensor(83)])
  call ol_merge_tensors(T0sum(18),[G0tensor(88)])
  call ol_merge_tensors(T0sum(19),[G0tensor(93)])
  call ol_merge_tensors(T0sum(20),[G0tensor(98)])
  call ol_merge_tensors(T0sum(21),[G0tensor(103)])
  call ol_merge_tensors(T0sum(22),[G0tensor(108)])
  call ol_merge_tensors(T0sum(23),[G0tensor(113)])
  call ol_merge_tensors(T0sum(24),[G0tensor(118)])
  call ol_merge_tensors(T0sum(25),[G0tensor(123)])
  call ol_merge_tensors(T0sum(26),[G0tensor(128)])
  call ol_merge_tensors(T0sum(27),[G0tensor(133)])
  call ol_merge_tensors(T0sum(28),[G0tensor(138)])
  call ol_merge_tensors(T0sum(29),[G0tensor(143)])
  call ol_merge_tensors(T0sum(30),[G0tensor(148)])
  call ol_merge_tensors(T0sum(31),[G0tensor(153)])
  call ol_merge_tensors(T0sum(32),[G0tensor(158)])
  call ol_merge_tensors(T0sum(33),[G0tensor(163)])
  call ol_merge_tensors(T0sum(34),[G0tensor(168)])
  call ol_merge_tensors(T0sum(35),[G0tensor(173)])
  call ol_merge_tensors(T0sum(36),[G0tensor(178)])
  call ol_merge_tensors(T0sum(37),[G0tensor(183)])
  call ol_merge_tensors(T0sum(38),[G0tensor(188)])
  call ol_merge_tensors(T0sum(39),[G0tensor(193)])
  call ol_merge_tensors(T0sum(40),[G0tensor(198)])
  call ol_merge_tensors(T0sum(41),[G0tensor(203)])
  call ol_merge_tensors(T0sum(42),[G0tensor(208)])
  call ol_merge_tensors(T0sum(43),[G0tensor(213)])
  call ol_merge_tensors(T0sum(44),[G0tensor(218)])
  call ol_merge_tensors(T0sum(45),[G0tensor(223)])
  call ol_merge_tensors(T0sum(46),[G0tensor(228)])
  call ol_merge_tensors(T0sum(47),[G0tensor(233)])
  call ol_merge_tensors(T0sum(48),[G0tensor(238)])
  call ol_merge_tensors(T0sum(49),[G0tensor(243)])
  call ol_merge_tensors(T0sum(50),[G0tensor(248)])
  call ol_merge_tensors(T0sum(51),[G0tensor(9)])
  call ol_merge_tensors(T0sum(52),[G0tensor(10)])
  call ol_merge_tensors(T0sum(53),[G0tensor(11)])
  call ol_merge_tensors(T0sum(54),[G0tensor(12)])
  call ol_merge_tensors(T0sum(55),[G0tensor(13)])
  call ol_merge_tensors(T0sum(56),[G0tensor(14)])
  call ol_merge_tensors(T0sum(57),[G0tensor(15)])
  call ol_merge_tensors(T0sum(58),[G0tensor(16)])
  call ol_merge_tensors(T0sum(59),[G0tensor(17)])
  call ol_merge_tensors(T0sum(60),[G0tensor(18)])
  call ol_merge_tensors(T0sum(61),[G0tensor(19)])
  call ol_merge_tensors(T0sum(62),[G0tensor(20)])
  call ol_merge_tensors(T0sum(63),[G0tensor(21)])
  call ol_merge_tensors(T0sum(64),[G0tensor(22)])
  call ol_merge_tensors(T0sum(65),[G0tensor(23)])
  call ol_merge_tensors(T0sum(66),[G0tensor(24)])
  call ol_merge_tensors(T0sum(67),[G0tensor(25)])
  call ol_merge_tensors(T0sum(68),[G0tensor(26)])
  call ol_merge_tensors(T0sum(69),[G0tensor(27)])
  call ol_merge_tensors(T0sum(70),[G0tensor(28)])
  call ol_merge_tensors(T0sum(71),[G0tensor(29)])
  call ol_merge_tensors(T0sum(72),[G0tensor(30)])
  call ol_merge_tensors(T0sum(73),[G0tensor(31)])
  call ol_merge_tensors(T0sum(74),[G0tensor(32)])
  call ol_merge_tensors(T0sum(75),[G0tensor(33)])
  call ol_merge_tensors(T0sum(76),[G0tensor(34)])
  call ol_merge_tensors(T0sum(77),[G0tensor(35)])
  call ol_merge_tensors(T0sum(78),[G0tensor(36)])
  call ol_merge_tensors(T0sum(79),[G0tensor(37)])
  call ol_merge_tensors(T0sum(80),[G0tensor(38)])
  call ol_merge_tensors(T0sum(81),[G0tensor(39)])
  call ol_merge_tensors(T0sum(82),[G0tensor(40)])
  call ol_merge_tensors(T0sum(83),[G0tensor(41)])
  call ol_merge_tensors(T0sum(84),[G0tensor(42)])
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(28,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(15),m4h2x2x8(:,37),heltab3x32(:,:,37))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(14),m4h2x2x8(:,38),heltab3x32(:,:,38))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(13),m4h2x2x8(:,39),heltab3x32(:,:,39))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(24),m4h2x2x8(:,40),heltab3x32(:,:,40))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(23),m4h2x2x8(:,41),heltab3x32(:,:,41))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(22),m4h2x2x8(:,42),heltab3x32(:,:,42))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(12),m4h2x2x8(:,43),heltab3x32(:,:,43))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(11),m4h2x2x8(:,44),heltab3x32(:,:,44))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[24,1,6],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(10),m4h2x2x8(:,45),heltab3x32(:,:,45))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(27),m4h2x2x8(:,46),heltab3x32(:,:,46))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(26),m4h2x2x8(:,47),heltab3x32(:,:,47))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(25),m4h2x2x8(:,48),heltab3x32(:,:,48))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(33),m4h2x2x8(:,49),heltab3x32(:,:,49))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(32),m4h2x2x8(:,50),heltab3x32(:,:,50))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(31),m4h2x2x8(:,51),heltab3x32(:,:,51))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(36),m4h2x2x8(:,52),heltab3x32(:,:,52))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(35),m4h2x2x8(:,53),heltab3x32(:,:,53))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[20,1,10],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(34),m4h2x2x8(:,54),heltab3x32(:,:,54))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(21),m4h2x2x8(:,55),heltab3x32(:,:,55))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(20),m4h2x2x8(:,56),heltab3x32(:,:,56))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(19),m4h2x2x8(:,57),heltab3x32(:,:,57))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(30),m4h2x2x8(:,58),heltab3x32(:,:,58))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(29),m4h2x2x8(:,59),heltab3x32(:,:,59))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(28),m4h2x2x8(:,60),heltab3x32(:,:,60))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(3),m4h2x2x8(:,61),heltab3x32(:,:,61))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(2),m4h2x2x8(:,62),heltab3x32(:,:,62))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[18,1,12],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(1),m4h2x2x8(:,63),heltab3x32(:,:,63))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,64),heltab3x32(:,:,64))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,65),heltab3x32(:,:,65))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,66),heltab3x32(:,:,66))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(9),m4h2x2x8(:,67),heltab3x32(:,:,67))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(8),m4h2x2x8(:,68),heltab3x32(:,:,68))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(7),m4h2x2x8(:,69),heltab3x32(:,:,69))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(18),m4h2x2x8(:,70),heltab3x32(:,:,70))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(17),m4h2x2x8(:,71),heltab3x32(:,:,71))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[24,2,5],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(16),m4h2x2x8(:,72),heltab3x32(:,:,72))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(37),m4h2x2x8(:,73),heltab3x32(:,:,73))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(38),m4h2x2x8(:,74),heltab3x32(:,:,74))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(39),m4h2x2x8(:,75),heltab3x32(:,:,75))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(40),m4h2x2x8(:,76),heltab3x32(:,:,76))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(41),m4h2x2x8(:,77),heltab3x32(:,:,77))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(42),m4h2x2x8(:,78),heltab3x32(:,:,78))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(43),m4h2x2x8(:,79),heltab3x32(:,:,79))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(44),m4h2x2x8(:,80),heltab3x32(:,:,80))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[20,2,9],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(45),m4h2x2x8(:,81),heltab3x32(:,:,81))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(46),m4h2x2x8(:,82),heltab3x32(:,:,82))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(47),m4h2x2x8(:,83),heltab3x32(:,:,83))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(48),m4h2x2x8(:,84),heltab3x32(:,:,84))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(49),m4h2x2x8(:,85),heltab3x32(:,:,85))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(50),m4h2x2x8(:,86),heltab3x32(:,:,86))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(51),m4h2x2x8(:,87),heltab3x32(:,:,87))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(52),m4h2x2x8(:,88),heltab3x32(:,:,88))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(53),m4h2x2x8(:,89),heltab3x32(:,:,89))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[17,2,12],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(54),m4h2x2x8(:,90),heltab3x32(:,:,90))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(55),m4h2x2x8(:,91),heltab3x32(:,:,91))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(56),m4h2x2x8(:,92),heltab3x32(:,:,92))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(57),m4h2x2x8(:,93),heltab3x32(:,:,93))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(58),m4h2x2x8(:,94),heltab3x32(:,:,94))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(59),m4h2x2x8(:,95),heltab3x32(:,:,95))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(60),m4h2x2x8(:,96),heltab3x32(:,:,96))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(61),m4h2x2x8(:,97),heltab3x32(:,:,97))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(62),m4h2x2x8(:,98),heltab3x32(:,:,98))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[24,3,4],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(63),m4h2x2x8(:,99),heltab3x32(:,:,99))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(64),m4h2x2x8(:,100),heltab3x32(:,:,100))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(65),m4h2x2x8(:,101),heltab3x32(:,:,101))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(66),m4h2x2x8(:,102),heltab3x32(:,:,102))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(67),m4h2x2x8(:,103),heltab3x32(:,:,103))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(68),m4h2x2x8(:,104),heltab3x32(:,:,104))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(69),m4h2x2x8(:,105),heltab3x32(:,:,105))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(70),m4h2x2x8(:,106),heltab3x32(:,:,106))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(71),m4h2x2x8(:,107),heltab3x32(:,:,107))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[20,3,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(72),m4h2x2x8(:,108),heltab3x32(:,:,108))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,145),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,146),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,147),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,148),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,149),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,150),heltab2x32(:,:,186))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,151),heltab2x32(:,:,187))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,152),heltab2x32(:,:,188))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,3,12],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,153),heltab2x32(:,:,189))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(73),m4h2x2x8(:,109),heltab3x32(:,:,109))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(74),m4h2x2x8(:,110),heltab3x32(:,:,110))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(75),m4h2x2x8(:,111),heltab3x32(:,:,111))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(76),m4h2x2x8(:,112),heltab3x32(:,:,112))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(77),m4h2x2x8(:,113),heltab3x32(:,:,113))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(78),m4h2x2x8(:,114),heltab3x32(:,:,114))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(79),m4h2x2x8(:,115),heltab3x32(:,:,115))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(80),m4h2x2x8(:,116),heltab3x32(:,:,116))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[18,4,9],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(81),m4h2x2x8(:,117),heltab3x32(:,:,117))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(82),m4h2x2x8(:,118),heltab3x32(:,:,118))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(83),m4h2x2x8(:,119),heltab3x32(:,:,119))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(84),m4h2x2x8(:,120),heltab3x32(:,:,120))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(85),m4h2x2x8(:,121),heltab3x32(:,:,121))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(86),m4h2x2x8(:,122),heltab3x32(:,:,122))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(87),m4h2x2x8(:,123),heltab3x32(:,:,123))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(88),m4h2x2x8(:,124),heltab3x32(:,:,124))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(89),m4h2x2x8(:,125),heltab3x32(:,:,125))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[17,4,10],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(90),m4h2x2x8(:,126),heltab3x32(:,:,126))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(91),m4h2x2x8(:,127),heltab3x32(:,:,127))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(92),m4h2x2x8(:,128),heltab3x32(:,:,128))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(93),m4h2x2x8(:,129),heltab3x32(:,:,129))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(94),m4h2x2x8(:,130),heltab3x32(:,:,130))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(95),m4h2x2x8(:,131),heltab3x32(:,:,131))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(96),m4h2x2x8(:,132),heltab3x32(:,:,132))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(97),m4h2x2x8(:,133),heltab3x32(:,:,133))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(98),m4h2x2x8(:,134),heltab3x32(:,:,134))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[18,5,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(99),m4h2x2x8(:,135),heltab3x32(:,:,135))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,154),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,155),heltab2x32(:,:,191))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,156),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,157),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,158),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,159),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,160),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,161),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,5,10],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,162),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(100),m4h2x2x8(:,136),heltab3x32(:,:,136))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(101),m4h2x2x8(:,137),heltab3x32(:,:,137))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(102),m4h2x2x8(:,138),heltab3x32(:,:,138))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(103),m4h2x2x8(:,139),heltab3x32(:,:,139))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(104),m4h2x2x8(:,140),heltab3x32(:,:,140))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(105),m4h2x2x8(:,141),heltab3x32(:,:,141))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(106),m4h2x2x8(:,142),heltab3x32(:,:,142))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(107),m4h2x2x8(:,143),heltab3x32(:,:,143))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[17,6,8],[0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(108),m4h2x2x8(:,144),heltab3x32(:,:,144))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,163),heltab2x32(:,:,199))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,164),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,165),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,166),heltab2x32(:,:,202))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,167),heltab2x32(:,:,203))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,168),heltab2x32(:,:,204))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,169),heltab2x32(:,:,205))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,170),heltab2x32(:,:,206))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,6,9],[0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,171),heltab2x32(:,:,207))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[19,4,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(1),m4h2x4x4(:,1),heltab3x32(:,:,145))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[19,4,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(2),m4h4x2x4(:,1),heltab3x32(:,:,146))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[19,4,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,2),heltab3x32(:,:,147))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,4,11],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,172),heltab2x32(:,:,208))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,4,11],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,173),heltab2x32(:,:,209))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,4,11],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,174),heltab2x32(:,:,210))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[24,3,4],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(109),m4h2x2x8(:,145),heltab3x32(:,:,148))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[24,3,4],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(110),m4h2x2x8(:,146),heltab3x32(:,:,149))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[24,3,4],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(111),m4h2x2x8(:,147),heltab3x32(:,:,150))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,7,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,175),heltab2x32(:,:,211))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,7,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,176),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,7,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,177),heltab2x32(:,:,213))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[20,3,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(112),m4h2x2x8(:,148),heltab3x32(:,:,151))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[20,3,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(113),m4h2x2x8(:,149),heltab3x32(:,:,152))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[20,3,8],[0,0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(114),m4h2x2x8(:,150),heltab3x32(:,:,153))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,3,12],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,178),heltab2x32(:,:,214))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,3,12],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,179),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,3,12],[0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,180),heltab2x32(:,:,216))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[21,2,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(4),m4h2x4x4(:,3),heltab3x32(:,:,154))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[21,2,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(5),m4h4x2x4(:,2),heltab3x32(:,:,155))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[21,2,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(6),m4h2x4x4(:,4),heltab3x32(:,:,156))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,2,13],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,181),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,2,13],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,182),heltab2x32(:,:,218))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,2,13],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,183),heltab2x32(:,:,219))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[24,2,5],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(115),m4h2x2x8(:,151),heltab3x32(:,:,157))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[24,2,5],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(116),m4h2x2x8(:,152),heltab3x32(:,:,158))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[24,2,5],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(117),m4h2x2x8(:,153),heltab3x32(:,:,159))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[22,1,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(7),m4h2x4x4(:,5),heltab3x32(:,:,160))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[22,1,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,5),ex5(:),G0H4(8),m4h4x2x4(:,3),heltab3x32(:,:,161))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[22,1,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(9),m4h2x4x4(:,6),heltab3x32(:,:,162))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[16,1,14],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,184),heltab2x32(:,:,220))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[16,1,14],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,185),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[16,1,14],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,186),heltab2x32(:,:,222))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[24,1,6],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(118),m4h2x2x8(:,154),heltab3x32(:,:,163))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[24,1,6],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(119),m4h2x2x8(:,155),heltab3x32(:,:,164))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[24,1,6],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(120),m4h2x2x8(:,156),heltab3x32(:,:,165))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[25,2,4],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(10),m4h2x4x4(:,7),heltab3x32(:,:,166))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[25,2,4],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,3),ex5(:),G0H4(11),m4h4x2x4(:,4),heltab3x32(:,:,167))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[25,2,4],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(12),m4h2x4x4(:,8),heltab3x32(:,:,168))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[26,1,4],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(13),m4h2x4x4(:,9),heltab3x32(:,:,169))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[26,1,4],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,6),ex5(:),G0H4(14),m4h4x2x4(:,5),heltab3x32(:,:,170))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[26,1,4],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(15),m4h2x4x4(:,10),heltab3x32(:,:,171))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[28,1,2],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(16),m4h2x4x4(:,11),heltab3x32(:,:,172))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[28,1,2],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,8),ex5(:),G0H4(17),m4h4x2x4(:,6),heltab3x32(:,:,173))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[28,1,2],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(18),m4h2x4x4(:,12),heltab3x32(:,:,174))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[25,2,4],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(19),m4h2x4x4(:,13),heltab3x32(:,:,175))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[25,2,4],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex4(:),G0H4(20),m4h4x2x4(:,7),heltab3x32(:,:,176))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[25,2,4],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(21),m4h2x4x4(:,14),heltab3x32(:,:,177))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[26,1,4],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(22),m4h2x4x4(:,15),heltab3x32(:,:,178))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[26,1,4],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex4(:),G0H4(23),m4h4x2x4(:,8),heltab3x32(:,:,179))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[26,1,4],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(24),m4h2x4x4(:,16),heltab3x32(:,:,180))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[28,1,2],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(25),m4h2x4x4(:,17),heltab3x32(:,:,181))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[28,1,2],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex4(:),G0H4(26),m4h4x2x4(:,9),heltab3x32(:,:,182))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[28,1,2],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(27),m4h2x4x4(:,18),heltab3x32(:,:,183))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,2,13],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,187),heltab2x32(:,:,223))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,2,13],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,188),heltab2x32(:,:,224))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,2,13],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,189),heltab2x32(:,:,225))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[20,2,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(121),m4h2x2x8(:,157),heltab3x32(:,:,184))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[20,2,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(122),m4h2x2x8(:,158),heltab3x32(:,:,185))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[20,2,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(123),m4h2x2x8(:,159),heltab3x32(:,:,186))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[16,1,14],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,190),heltab2x32(:,:,226))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[16,1,14],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,191),heltab2x32(:,:,227))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[16,1,14],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,192),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[20,1,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(124),m4h2x2x8(:,160),heltab3x32(:,:,187))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[20,1,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(125),m4h2x2x8(:,161),heltab3x32(:,:,188))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[20,1,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(126),m4h2x2x8(:,162),heltab3x32(:,:,189))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[21,2,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(28),m4h2x4x4(:,19),heltab3x32(:,:,190))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[21,2,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex3(:),G0H4(29),m4h4x2x4(:,10),heltab3x32(:,:,191))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[21,2,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(30),m4h2x4x4(:,20),heltab3x32(:,:,192))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[22,1,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(31),m4h2x4x4(:,21),heltab3x32(:,:,193))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[22,1,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex3(:),G0H4(32),m4h4x2x4(:,11),heltab3x32(:,:,194))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[22,1,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(33),m4h2x4x4(:,22),heltab3x32(:,:,195))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[28,1,2],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(34),m4h2x4x4(:,23),heltab3x32(:,:,196))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[28,1,2],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex3(:),G0H4(35),m4h4x2x4(:,12),heltab3x32(:,:,197))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[28,1,2],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(36),m4h2x4x4(:,24),heltab3x32(:,:,198))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[17,2,12],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(44),m3h4x8(:,37),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[17,2,12],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(46),m3h4x8(:,38),heltab2x32(:,:,230))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[17,2,12],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(48),m3h4x8(:,39),heltab2x32(:,:,231))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[18,1,12],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(49),m3h4x8(:,40),heltab2x32(:,:,232))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[18,1,12],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(50),m3h4x8(:,41),heltab2x32(:,:,233))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[18,1,12],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(52),m3h4x8(:,42),heltab2x32(:,:,234))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[28,1,2],[0,0,0],3,1,wf8(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,1),G1H4(537),m3h8x4(:,1),heltab2x32(:,:,235))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[28,1,2],[0,0,0],3,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,2),G1H4(538),m3h8x4(:,2),heltab2x32(:,:,236))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[28,1,2],[0,0,0],3,1,wf8(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,3),G1H4(542),m3h8x4(:,3),heltab2x32(:,:,237))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[28,1,2],[0,0,0],3,1,wf8(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,1),28,G1H4(543),m3h8x4(:,4),heltab2x32(:,:,238))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[28,1,2],[0,0,0],3,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,2),28,G1H4(553),m3h8x4(:,5),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[28,1,2],[0,0,0],3,1,wf8(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,3),28,G1H4(554),m3h8x4(:,6),heltab2x32(:,:,240))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[28,1,2],[0,0,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),28,G1H4(558),m3h8x4(:,7),heltab2x32(:,:,241))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[28,1,2],[0,0,0],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),28,G1H4(559),m3h8x4(:,8),heltab2x32(:,:,242))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[28,1,2],[0,0,0],3,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,3),28,G1H4(569),m3h8x4(:,9),heltab2x32(:,:,243))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,7,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,193),heltab2x32(:,:,244))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,7,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,194),heltab2x32(:,:,245))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,7,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,195),heltab2x32(:,:,246))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[18,5,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(127),m4h2x2x8(:,163),heltab3x32(:,:,199))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[18,5,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(128),m4h2x2x8(:,164),heltab3x32(:,:,200))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[18,5,8],[0,0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(129),m4h2x2x8(:,165),heltab3x32(:,:,201))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,5,10],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,196),heltab2x32(:,:,247))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,5,10],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,197),heltab2x32(:,:,248))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,5,10],[0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,198),heltab2x32(:,:,249))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,4,11],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,199),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,4,11],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,200),heltab2x32(:,:,251))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,4,11],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,201),heltab2x32(:,:,252))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[18,4,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(130),m4h2x2x8(:,166),heltab3x32(:,:,202))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[18,4,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(131),m4h2x2x8(:,167),heltab3x32(:,:,203))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[18,4,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(132),m4h2x2x8(:,168),heltab3x32(:,:,204))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,1,14],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,202),heltab2x32(:,:,253))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,1,14],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,203),heltab2x32(:,:,254))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,1,14],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,204),heltab2x32(:,:,255))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[18,1,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(133),m4h2x2x8(:,169),heltab3x32(:,:,205))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[18,1,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(134),m4h2x2x8(:,170),heltab3x32(:,:,206))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[18,1,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(135),m4h2x2x8(:,171),heltab3x32(:,:,207))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[19,4,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(37),m4h2x4x4(:,25),heltab3x32(:,:,208))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[19,4,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex2(:),G0H4(38),m4h4x2x4(:,13),heltab3x32(:,:,209))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[19,4,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(39),m4h2x4x4(:,26),heltab3x32(:,:,210))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[22,1,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(40),m4h2x4x4(:,27),heltab3x32(:,:,211))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[22,1,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex2(:),G0H4(41),m4h4x2x4(:,14),heltab3x32(:,:,212))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[22,1,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(42),m4h2x4x4(:,28),heltab3x32(:,:,213))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[26,1,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(43),m4h2x4x4(:,29),heltab3x32(:,:,214))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[26,1,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex2(:),G0H4(44),m4h4x2x4(:,15),heltab3x32(:,:,215))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[26,1,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(45),m4h2x4x4(:,30),heltab3x32(:,:,216))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[17,4,10],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(54),m3h4x8(:,43),heltab2x32(:,:,256))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[17,4,10],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(55),m3h4x8(:,44),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[17,4,10],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(56),m3h4x8(:,45),heltab2x32(:,:,258))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[20,1,10],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(58),m3h4x8(:,46),heltab2x32(:,:,259))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[20,1,10],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(60),m3h4x8(:,47),heltab2x32(:,:,260))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[20,1,10],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(61),m3h4x8(:,48),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[26,1,4],[0,0,0],3,1,wf8(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,4),G1H4(570),m3h8x4(:,10),heltab2x32(:,:,262))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[26,1,4],[0,0,0],3,1,wf8(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,5),G1H4(574),m3h8x4(:,11),heltab2x32(:,:,263))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[26,1,4],[0,0,0],3,1,wf8(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,6),G1H4(575),m3h8x4(:,12),heltab2x32(:,:,264))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[26,1,4],[0,0,0],3,1,wf8(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,4),26,G1H4(101),m3h8x4(:,13),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[26,1,4],[0,0,0],3,1,wf8(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),26,G1H4(102),m3h8x4(:,14),heltab2x32(:,:,266))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[26,1,4],[0,0,0],3,1,wf8(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,6),26,G1H4(118),m3h8x4(:,15),heltab2x32(:,:,267))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[26,1,4],[0,0,0],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,4),26,G1H4(133),m3h8x4(:,16),heltab2x32(:,:,268))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[26,1,4],[0,0,0],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),26,G1H4(134),m3h8x4(:,17),heltab2x32(:,:,269))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[26,1,4],[0,0,0],3,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),26,G1H4(149),m3h8x4(:,18),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[16,6,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(61),m3h2x16(:,205),heltab2x32(:,:,271))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[16,6,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,206),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[16,6,9],[0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,207),heltab2x32(:,:,273))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[17,6,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(62),m3h4x8(:,49),heltab2x32(:,:,274))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[17,6,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(64),m3h4x8(:,50),heltab2x32(:,:,275))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[17,6,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(66),m3h4x8(:,51),heltab2x32(:,:,276))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[24,1,6],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(67),m3h4x8(:,52),heltab2x32(:,:,277))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[24,1,6],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(68),m3h4x8(:,53),heltab2x32(:,:,278))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[24,1,6],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(70),m3h4x8(:,54),heltab2x32(:,:,279))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[22,1,8],[0,0,0],3,1,wf8(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,7),G1H4(165),m3h8x4(:,19),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[22,1,8],[0,0,0],3,1,wf8(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,8),G1H4(166),m3h8x4(:,20),heltab2x32(:,:,281))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[22,1,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,9),G1H4(181),m3h8x4(:,21),heltab2x32(:,:,282))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[22,1,8],[0,0,0],3,1,wf8(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,7),22,G1H4(182),m3h8x4(:,22),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[22,1,8],[0,0,0],3,1,wf8(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,8),22,G1H4(198),m3h8x4(:,23),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[22,1,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,9),22,G1H4(213),m3h8x4(:,24),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[22,1,8],[0,0,0],3,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),22,G1H4(214),m3h8x4(:,25),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[22,1,8],[0,0,0],3,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),22,G1H4(229),m3h8x4(:,26),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[22,1,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,9),22,G1H4(245),m3h8x4(:,27),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[16,1,14],[0,0,0],3,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,208),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[16,1,14],[0,0,0],3,1,wf8(:,11))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,209),heltab2x32(:,:,290))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[16,1,14],[0,0,0],3,1,wf8(:,12))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,210),heltab2x32(:,:,291))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[16,1,14],[0,0,0],3,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(67),m3h2x16(:,211),heltab2x32(:,:,292))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[16,1,14],[0,0,0],3,1,wf8(:,11))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(68),m3h2x16(:,212),heltab2x32(:,:,293))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[16,1,14],[0,0,0],3,1,wf8(:,12))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(69),m3h2x16(:,213),heltab2x32(:,:,294))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[16,1,14],[0,0,0],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,214),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[16,1,14],[0,0,0],3,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(71),m3h2x16(:,215),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[16,1,14],[0,0,0],3,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(72),m3h2x16(:,216),heltab2x32(:,:,297))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[16,7,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(73),m3h2x16(:,217),heltab2x32(:,:,298))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[16,7,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,218),heltab2x32(:,:,299))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[16,7,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(75),m3h2x16(:,219),heltab2x32(:,:,300))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[17,6,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(136),m4h2x2x8(:,172),heltab3x32(:,:,217))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[17,6,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(137),m4h2x2x8(:,173),heltab3x32(:,:,218))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[17,6,8],[0,0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(138),m4h2x2x8(:,174),heltab3x32(:,:,219))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[16,6,9],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(76),m3h2x16(:,220),heltab2x32(:,:,301))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[16,6,9],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,221),heltab2x32(:,:,302))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[16,6,9],[0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,222),heltab2x32(:,:,303))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[16,4,11],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,223),heltab2x32(:,:,304))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[16,4,11],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,224),heltab2x32(:,:,305))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[16,4,11],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,225),heltab2x32(:,:,306))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[17,4,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(139),m4h2x2x8(:,175),heltab3x32(:,:,220))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[17,4,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(140),m4h2x2x8(:,176),heltab3x32(:,:,221))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[17,4,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(141),m4h2x2x8(:,177),heltab3x32(:,:,222))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[16,2,13],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(82),m3h2x16(:,226),heltab2x32(:,:,307))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,2,13],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(83),m3h2x16(:,227),heltab2x32(:,:,308))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,2,13],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(84),m3h2x16(:,228),heltab2x32(:,:,309))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[17,2,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(142),m4h2x2x8(:,178),heltab3x32(:,:,223))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[17,2,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(143),m4h2x2x8(:,179),heltab3x32(:,:,224))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[17,2,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(144),m4h2x2x8(:,180),heltab3x32(:,:,225))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[19,4,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(46),m4h2x4x4(:,31),heltab3x32(:,:,226))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[19,4,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex1(:),G0H4(47),m4h4x2x4(:,16),heltab3x32(:,:,227))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[19,4,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(48),m4h2x4x4(:,32),heltab3x32(:,:,228))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[21,2,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(49),m4h2x4x4(:,33),heltab3x32(:,:,229))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[21,2,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex1(:),G0H4(50),m4h4x2x4(:,17),heltab3x32(:,:,230))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[21,2,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(51),m4h2x4x4(:,34),heltab3x32(:,:,231))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[25,2,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(52),m4h2x4x4(:,35),heltab3x32(:,:,232))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[25,2,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex1(:),G0H4(53),m4h4x2x4(:,18),heltab3x32(:,:,233))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[25,2,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(54),m4h2x4x4(:,36),heltab3x32(:,:,234))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[18,4,9],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(72),m3h4x8(:,55),heltab2x32(:,:,310))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[18,4,9],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(73),m3h4x8(:,56),heltab2x32(:,:,311))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[18,4,9],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(74),m3h4x8(:,57),heltab2x32(:,:,312))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[20,2,9],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(76),m3h4x8(:,58),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[20,2,9],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(78),m3h4x8(:,59),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[20,2,9],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(79),m3h4x8(:,60),heltab2x32(:,:,315))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[25,2,4],[0,0,0],3,1,wf8(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,13),G1H4(246),m3h8x4(:,28),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[25,2,4],[0,0,0],3,1,wf8(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,14),G1H4(261),m3h8x4(:,29),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[25,2,4],[0,0,0],3,1,wf8(:,15))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,15),G1H4(262),m3h8x4(:,30),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[25,2,4],[0,0,0],3,1,wf8(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,13),25,G1H4(278),m3h8x4(:,31),heltab2x32(:,:,319))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[25,2,4],[0,0,0],3,1,wf8(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,14),25,G1H4(293),m3h8x4(:,32),heltab2x32(:,:,320))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[25,2,4],[0,0,0],3,1,wf8(:,15))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,15),25,G1H4(294),m3h8x4(:,33),heltab2x32(:,:,321))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[25,2,4],[0,0,0],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,13),25,G1H4(309),m3h8x4(:,34),heltab2x32(:,:,322))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[25,2,4],[0,0,0],3,1,wf8(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,14),25,G1H4(325),m3h8x4(:,35),heltab2x32(:,:,323))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[25,2,4],[0,0,0],3,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,15),25,G1H4(326),m3h8x4(:,36),heltab2x32(:,:,324))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[16,5,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(85),m3h2x16(:,229),heltab2x32(:,:,325))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[16,5,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(86),m3h2x16(:,230),heltab2x32(:,:,326))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[16,5,10],[0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,231),heltab2x32(:,:,327))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[18,5,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(80),m3h4x8(:,61),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[18,5,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(82),m3h4x8(:,62),heltab2x32(:,:,329))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[18,5,8],[0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(84),m3h4x8(:,63),heltab2x32(:,:,330))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[24,2,5],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(85),m3h4x8(:,64),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[24,2,5],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(86),m3h4x8(:,65),heltab2x32(:,:,332))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[24,2,5],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(88),m3h4x8(:,66),heltab2x32(:,:,333))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[21,2,8],[0,0,0],3,1,wf8(:,16))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,16),G1H4(341),m3h8x4(:,37),heltab2x32(:,:,334))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[21,2,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,17),G1H4(342),m3h8x4(:,38),heltab2x32(:,:,335))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[21,2,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,18),G1H4(358),m3h8x4(:,39),heltab2x32(:,:,336))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[21,2,8],[0,0,0],3,1,wf8(:,16))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,16),21,G1H4(373),m3h8x4(:,40),heltab2x32(:,:,337))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[21,2,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,17),21,G1H4(374),m3h8x4(:,41),heltab2x32(:,:,338))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[21,2,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,18),21,G1H4(389),m3h8x4(:,42),heltab2x32(:,:,339))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[21,2,8],[0,0,0],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),21,G1H4(405),m3h8x4(:,43),heltab2x32(:,:,340))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[21,2,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),21,G1H4(406),m3h8x4(:,44),heltab2x32(:,:,341))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[21,2,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,18),21,G1H4(421),m3h8x4(:,45),heltab2x32(:,:,342))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[16,2,13],[0,0,0],3,1,wf8(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,232),heltab2x32(:,:,343))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[16,2,13],[0,0,0],3,1,wf8(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,233),heltab2x32(:,:,344))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[16,2,13],[0,0,0],3,1,wf8(:,21))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,234),heltab2x32(:,:,345))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[16,2,13],[0,0,0],3,1,wf8(:,19))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(91),m3h2x16(:,235),heltab2x32(:,:,346))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[16,2,13],[0,0,0],3,1,wf8(:,20))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(92),m3h2x16(:,236),heltab2x32(:,:,347))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[16,2,13],[0,0,0],3,1,wf8(:,21))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(93),m3h2x16(:,237),heltab2x32(:,:,348))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[16,2,13],[0,0,0],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,238),heltab2x32(:,:,349))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[16,2,13],[0,0,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,239),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[16,2,13],[0,0,0],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(96),m3h2x16(:,240),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[16,3,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,241),heltab2x32(:,:,352))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[16,3,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(98),m3h2x16(:,242),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[16,3,12],[0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,243),heltab2x32(:,:,354))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[20,3,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(90),m3h4x8(:,67),heltab2x32(:,:,355))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[20,3,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(91),m3h4x8(:,68),heltab2x32(:,:,356))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[20,3,8],[0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(92),m3h4x8(:,69),heltab2x32(:,:,357))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[24,3,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(94),m3h4x8(:,70),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[24,3,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(96),m3h4x8(:,71),heltab2x32(:,:,359))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[24,3,4],[0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(97),m3h4x8(:,72),heltab2x32(:,:,360))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,22),G1H4(422),m3h8x4(:,46),heltab2x32(:,:,361))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[19,4,8],[0,0,0],3,1,wf8(:,23))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,23),G1H4(438),m3h8x4(:,47),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[19,4,8],[0,0,0],3,1,wf8(:,24))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,24),G1H4(453),m3h8x4(:,48),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(454),m3h8x4(:,49),heltab2x32(:,:,364))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[19,4,8],[0,0,0],3,1,wf8(:,23))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(469),m3h8x4(:,50),heltab2x32(:,:,365))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[19,4,8],[0,0,0],3,1,wf8(:,24))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(485),m3h8x4(:,51),heltab2x32(:,:,366))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[19,4,8],[0,0,0],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(486),m3h8x4(:,52),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[19,4,8],[0,0,0],3,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(501),m3h8x4(:,53),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[19,4,8],[0,0,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(502),m3h8x4(:,54),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[16,4,11],[0,0,0],3,1,wf8(:,25))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,244),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[16,4,11],[0,0,0],3,1,wf8(:,26))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,245),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[16,4,11],[0,0,0],3,1,wf8(:,27))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,246),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[16,4,11],[0,0,0],3,1,wf8(:,25))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(103),m3h2x16(:,247),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[16,4,11],[0,0,0],3,1,wf8(:,26))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(104),m3h2x16(:,248),heltab2x32(:,:,374))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[16,4,11],[0,0,0],3,1,wf8(:,27))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(105),m3h2x16(:,249),heltab2x32(:,:,375))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[16,4,11],[0,0,0],3,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,250),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[16,4,11],[0,0,0],3,1,wf8(:,26))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,251),heltab2x32(:,:,377))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[16,4,11],[0,0,0],3,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,252),heltab2x32(:,:,378))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[16,7,8],[0,0,0],3,1,wf8(:,28))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(109),m3h2x16(:,253),heltab2x32(:,:,379))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[16,7,8],[0,0,0],3,1,wf8(:,29))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(110),m3h2x16(:,254),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[16,7,8],[0,0,0],3,1,wf8(:,30))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(111),m3h2x16(:,255),heltab2x32(:,:,381))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[16,7,8],[0,0,0],3,1,wf8(:,28))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,256),heltab2x32(:,:,382))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[16,7,8],[0,0,0],3,1,wf8(:,29))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,257),heltab2x32(:,:,383))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[16,7,8],[0,0,0],3,1,wf8(:,30))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,258),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[16,7,8],[0,0,0],3,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,259),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[16,7,8],[0,0,0],3,1,wf8(:,29))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,260),heltab2x32(:,:,386))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[16,7,8],[0,0,0],3,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,261),heltab2x32(:,:,387))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(118),m3h2x16(:,262),heltab2x32(:,:,388))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,263),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,264),heltab2x32(:,:,390))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[20,3,8],[0,0,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(98),m3h4x8(:,73),heltab2x32(:,:,391))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[20,3,8],[0,0,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(100),m3h4x8(:,74),heltab2x32(:,:,392))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[20,3,8],[0,0,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(102),m3h4x8(:,75),heltab2x32(:,:,393))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[24,3,4],[0,0,0],3,2,wf4(:,10),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(103),m3h4x8(:,76),heltab2x32(:,:,394))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[24,3,4],[0,0,0],3,2,wf4(:,10),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(104),m3h4x8(:,77),heltab2x32(:,:,395))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[24,3,4],[0,0,0],3,2,wf4(:,10),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(106),m3h4x8(:,78),heltab2x32(:,:,396))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[16,7,8],[0,0,0],3,1,wf8(:,33))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(121),m3h2x16(:,265),heltab2x32(:,:,397))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[16,7,8],[0,0,0],3,1,wf8(:,33))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,266),heltab2x32(:,:,398))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[16,7,8],[0,0,0],3,1,wf8(:,33))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,267),heltab2x32(:,:,399))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[16,4,11],[0,0,0],3,1,wf8(:,32))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,268),heltab2x32(:,:,400))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[16,4,11],[0,0,0],3,1,wf8(:,32))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(125),m3h2x16(:,269),heltab2x32(:,:,401))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[16,4,11],[0,0,0],3,1,wf8(:,32))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,270),heltab2x32(:,:,402))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[19,4,8],[0,0,0],3,1,wf8(:,31))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,31),G1H4(518),m3h8x4(:,55),heltab2x32(:,:,403))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[19,4,8],[0,0,0],3,1,wf8(:,31))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,31),19,G1H4(533),m3h8x4(:,56),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[19,4,8],[0,0,0],3,1,wf8(:,31))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,31),19,G1H4(534),m3h8x4(:,57),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[16,5,10],[0,0,0],3,2,wf4(:,2),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(127),m3h2x16(:,271),heltab2x32(:,:,406))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[16,5,10],[0,0,0],3,2,wf4(:,2),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(128),m3h2x16(:,272),heltab2x32(:,:,407))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[16,5,10],[0,0,0],3,2,wf4(:,2),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(129),m3h2x16(:,273),heltab2x32(:,:,408))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[18,5,8],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(108),m3h4x8(:,79),heltab2x32(:,:,409))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[18,5,8],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(109),m3h4x8(:,80),heltab2x32(:,:,410))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[18,5,8],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(110),m3h4x8(:,81),heltab2x32(:,:,411))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[24,2,5],[0,0,0],3,2,wf4(:,10),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(112),m3h4x8(:,82),heltab2x32(:,:,412))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[24,2,5],[0,0,0],3,2,wf4(:,10),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(114),m3h4x8(:,83),heltab2x32(:,:,413))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[24,2,5],[0,0,0],3,2,wf4(:,10),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(115),m3h4x8(:,84),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(130),m3h2x16(:,274),heltab2x32(:,:,415))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(131),m3h2x16(:,275),heltab2x32(:,:,416))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,276),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[16,2,13],[0,0,0],3,1,wf8(:,35))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(133),m3h2x16(:,277),heltab2x32(:,:,418))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[16,2,13],[0,0,0],3,1,wf8(:,35))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(134),m3h2x16(:,278),heltab2x32(:,:,419))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[16,2,13],[0,0,0],3,1,wf8(:,35))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(135),m3h2x16(:,279),heltab2x32(:,:,420))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[21,2,8],[0,0,0],3,1,wf8(:,34))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,34),G1H4(549),m3h8x4(:,58),heltab2x32(:,:,421))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[21,2,8],[0,0,0],3,1,wf8(:,34))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,34),21,G1H4(565),m3h8x4(:,59),heltab2x32(:,:,422))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[21,2,8],[0,0,0],3,1,wf8(:,34))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,34),21,G1H4(566),m3h8x4(:,60),heltab2x32(:,:,423))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[16,6,9],[0,0,0],3,2,wf4(:,5),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(136),m3h2x16(:,280),heltab2x32(:,:,424))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[16,6,9],[0,0,0],3,2,wf4(:,5),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(137),m3h2x16(:,281),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[16,6,9],[0,0,0],3,2,wf4(:,5),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,282),heltab2x32(:,:,426))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[17,6,8],[0,0,0],3,2,wf4(:,4),wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(116),m3h4x8(:,85),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[17,6,8],[0,0,0],3,2,wf4(:,4),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(118),m3h4x8(:,86),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[17,6,8],[0,0,0],3,2,wf4(:,4),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(120),m3h4x8(:,87),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[24,1,6],[0,0,0],3,2,wf4(:,10),wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(121),m3h4x8(:,88),heltab2x32(:,:,430))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[24,1,6],[0,0,0],3,2,wf4(:,10),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(122),m3h4x8(:,89),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[24,1,6],[0,0,0],3,2,wf4(:,10),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(124),m3h4x8(:,90),heltab2x32(:,:,432))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(139),m3h2x16(:,283),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(140),m3h2x16(:,284),heltab2x32(:,:,434))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[16,7,8],[0,0,0],3,1,wf8(:,39))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(141),m3h2x16(:,285),heltab2x32(:,:,435))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[16,1,14],[0,0,0],3,1,wf8(:,113))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(142),m3h2x16(:,286),heltab2x32(:,:,436))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[16,1,14],[0,0,0],3,1,wf8(:,113))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(143),m3h2x16(:,287),heltab2x32(:,:,437))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[16,1,14],[0,0,0],3,1,wf8(:,113))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(144),m3h2x16(:,288),heltab2x32(:,:,438))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[22,1,8],[0,0,0],3,1,wf8(:,112))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,112),G1H4(1),m3h8x4(:,61),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[22,1,8],[0,0,0],3,1,wf8(:,112))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,112),22,G1H4(2),m3h8x4(:,62),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[22,1,8],[0,0,0],3,1,wf8(:,112))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,112),22,G1H4(12),m3h8x4(:,63),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[18,4,9],[0,0,0],3,2,wf4(:,7),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(126),m3h4x8(:,91),heltab2x32(:,:,442))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[18,4,9],[0,0,0],3,2,wf4(:,7),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(127),m3h4x8(:,92),heltab2x32(:,:,443))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[18,4,9],[0,0,0],3,2,wf4(:,7),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(128),m3h4x8(:,93),heltab2x32(:,:,444))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[20,2,9],[0,0,0],3,2,wf4(:,9),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(130),m3h4x8(:,94),heltab2x32(:,:,445))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[20,2,9],[0,0,0],3,2,wf4(:,9),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(132),m3h4x8(:,95),heltab2x32(:,:,446))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[20,2,9],[0,0,0],3,2,wf4(:,9),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(133),m3h4x8(:,96),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(145),m3h2x16(:,289),heltab2x32(:,:,448))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(146),m3h2x16(:,290),heltab2x32(:,:,449))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[16,4,11],[0,0,0],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(147),m3h2x16(:,291),heltab2x32(:,:,450))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[16,2,13],[0,0,0],3,1,wf8(:,40))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,292),heltab2x32(:,:,451))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[16,2,13],[0,0,0],3,1,wf8(:,40))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(149),m3h2x16(:,293),heltab2x32(:,:,452))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[16,2,13],[0,0,0],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(150),m3h2x16(:,294),heltab2x32(:,:,453))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[25,2,4],[0,0,0],3,1,wf8(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,37),G1H4(8),m3h8x4(:,64),heltab2x32(:,:,454))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[25,2,4],[0,0,0],3,1,wf8(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,37),25,G1H4(11),m3h8x4(:,65),heltab2x32(:,:,455))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[25,2,4],[0,0,0],3,1,wf8(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,37),25,G1H4(13),m3h8x4(:,66),heltab2x32(:,:,456))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[17,4,10],[0,0,0],3,2,wf4(:,4),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(134),m3h4x8(:,97),heltab2x32(:,:,457))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[17,4,10],[0,0,0],3,2,wf4(:,4),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(136),m3h4x8(:,98),heltab2x32(:,:,458))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[17,4,10],[0,0,0],3,2,wf4(:,4),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(138),m3h4x8(:,99),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[20,1,10],[0,0,0],3,2,wf4(:,9),wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(139),m3h4x8(:,100),heltab2x32(:,:,460))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[20,1,10],[0,0,0],3,2,wf4(:,9),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(140),m3h4x8(:,101),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[20,1,10],[0,0,0],3,2,wf4(:,9),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(142),m3h4x8(:,102),heltab2x32(:,:,462))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(151),m3h2x16(:,295),heltab2x32(:,:,463))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(152),m3h2x16(:,296),heltab2x32(:,:,464))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[16,4,11],[0,0,0],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(153),m3h2x16(:,297),heltab2x32(:,:,465))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[16,1,14],[0,0,0],3,1,wf8(:,117))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(154),m3h2x16(:,298),heltab2x32(:,:,466))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[16,1,14],[0,0,0],3,1,wf8(:,117))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(155),m3h2x16(:,299),heltab2x32(:,:,467))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[16,1,14],[0,0,0],3,1,wf8(:,117))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(156),m3h2x16(:,300),heltab2x32(:,:,468))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[26,1,4],[0,0,0],3,1,wf8(:,109))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,109),G1H4(17),m3h8x4(:,67),heltab2x32(:,:,469))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[26,1,4],[0,0,0],3,1,wf8(:,109))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,109),26,G1H4(18),m3h8x4(:,68),heltab2x32(:,:,470))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[26,1,4],[0,0,0],3,1,wf8(:,109))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,109),26,G1H4(23),m3h8x4(:,69),heltab2x32(:,:,471))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[17,2,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(144),m3h4x8(:,103),heltab2x32(:,:,472))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[17,2,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(145),m3h4x8(:,104),heltab2x32(:,:,473))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[17,2,12],[0,0,0],3,2,wf4(:,4),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(146),m3h4x8(:,105),heltab2x32(:,:,474))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[18,1,12],[0,0,0],3,2,wf4(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(148),m3h4x8(:,106),heltab2x32(:,:,475))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[18,1,12],[0,0,0],3,2,wf4(:,7),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(150),m3h4x8(:,107),heltab2x32(:,:,476))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[18,1,12],[0,0,0],3,2,wf4(:,7),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(151),m3h4x8(:,108),heltab2x32(:,:,477))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[16,2,13],[0,0,0],3,1,wf8(:,120))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(157),m3h2x16(:,301),heltab2x32(:,:,478))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[16,2,13],[0,0,0],3,1,wf8(:,120))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(158),m3h2x16(:,302),heltab2x32(:,:,479))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[16,2,13],[0,0,0],3,1,wf8(:,120))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(159),m3h2x16(:,303),heltab2x32(:,:,480))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[16,1,14],[0,0,0],3,1,wf8(:,119))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,304),heltab2x32(:,:,481))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[16,1,14],[0,0,0],3,1,wf8(:,119))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(161),m3h2x16(:,305),heltab2x32(:,:,482))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[16,1,14],[0,0,0],3,1,wf8(:,119))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(162),m3h2x16(:,306),heltab2x32(:,:,483))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[28,1,2],[0,0,0],3,1,wf8(:,106))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,106),G1H4(28),m3h8x4(:,70),heltab2x32(:,:,484))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[28,1,2],[0,0,0],3,1,wf8(:,106))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,106),28,G1H4(27),m3h8x4(:,71),heltab2x32(:,:,485))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[28,1,2],[0,0,0],3,1,wf8(:,106))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,106),28,G1H4(29),m3h8x4(:,72),heltab2x32(:,:,486))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,44),G1H4(32),m3h8x4(:,73),heltab2x32(:,:,487))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(33),m3h8x4(:,74),heltab2x32(:,:,488))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(39),m3h8x4(:,75),heltab2x32(:,:,489))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[21,2,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,42),G1H4(44),m3h8x4(:,76),heltab2x32(:,:,490))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[21,2,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,42),21,G1H4(40),m3h8x4(:,77),heltab2x32(:,:,491))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[21,2,8],[0,0,0],3,1,wf8(:,42))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,42),21,G1H4(43),m3h8x4(:,78),heltab2x32(:,:,492))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[25,2,4],[0,0,0],3,1,wf8(:,38))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,38),G1H4(48),m3h8x4(:,79),heltab2x32(:,:,493))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[25,2,4],[0,0,0],3,1,wf8(:,38))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,38),25,G1H4(49),m3h8x4(:,80),heltab2x32(:,:,494))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[25,2,4],[0,0,0],3,1,wf8(:,38))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,38),25,G1H4(50),m3h8x4(:,81),heltab2x32(:,:,495))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[19,4,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,45),G1H4(55),m3h8x4(:,82),heltab2x32(:,:,496))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[19,4,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,45),19,G1H4(56),m3h8x4(:,83),heltab2x32(:,:,497))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[19,4,8],[0,0,0],3,1,wf8(:,45))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,45),19,G1H4(59),m3h8x4(:,84),heltab2x32(:,:,498))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[22,1,8],[0,0,0],3,1,wf8(:,115))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,115),G1H4(61),m3h8x4(:,85),heltab2x32(:,:,499))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[22,1,8],[0,0,0],3,1,wf8(:,115))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,115),22,G1H4(64),m3h8x4(:,86),heltab2x32(:,:,500))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[22,1,8],[0,0,0],3,1,wf8(:,115))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,115),22,G1H4(66),m3h8x4(:,87),heltab2x32(:,:,501))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[26,1,4],[0,0,0],3,1,wf8(:,110))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,110),G1H4(71),m3h8x4(:,88),heltab2x32(:,:,502))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[26,1,4],[0,0,0],3,1,wf8(:,110))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,110),26,G1H4(76),m3h8x4(:,89),heltab2x32(:,:,503))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[26,1,4],[0,0,0],3,1,wf8(:,110))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,110),26,G1H4(72),m3h8x4(:,90),heltab2x32(:,:,504))
  Gcoeff(:)%j = (c(6)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[21,2,8],[0,0,0],3,1,wf8(:,118))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,118),G1H4(77),m3h8x4(:,91),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[21,2,8],[0,0,0],3,1,wf8(:,118))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,118),21,G1H4(80),m3h8x4(:,92),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(6)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[21,2,8],[0,0,0],3,1,wf8(:,118))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,118),21,G1H4(81),m3h8x4(:,93),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[22,1,8],[0,0,0],3,1,wf8(:,116))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,116),G1H4(82),m3h8x4(:,94),heltab2x32(:,:,508))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[22,1,8],[0,0,0],3,1,wf8(:,116))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,116),22,G1H4(92),m3h8x4(:,95),heltab2x32(:,:,509))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[22,1,8],[0,0,0],3,1,wf8(:,116))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,116),22,G1H4(88),m3h8x4(:,96),heltab2x32(:,:,510))
  Gcoeff(:)%j = (c(6)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[28,1,2],[0,0,0],3,1,wf8(:,107))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,107),G1H4(91),m3h8x4(:,97),heltab2x32(:,:,511))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[28,1,2],[0,0,0],3,1,wf8(:,107))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,107),28,G1H4(93),m3h8x4(:,98),heltab2x32(:,:,512))
  Gcoeff(:)%j = (c(6)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[28,1,2],[0,0,0],3,1,wf8(:,107))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,107),28,G1H4(97),m3h8x4(:,99),heltab2x32(:,:,513))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[25,2,4],[0,0,0],3,1,wf8(:,114))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,114),G1H4(98),m3h8x4(:,100),heltab2x32(:,:,514))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[25,2,4],[0,0,0],3,1,wf8(:,114))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,114),25,G1H4(103),m3h8x4(:,101),heltab2x32(:,:,515))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[25,2,4],[0,0,0],3,1,wf8(:,114))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,114),25,G1H4(108),m3h8x4(:,102),heltab2x32(:,:,516))
  Gcoeff(:)%j = (c(6)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[26,1,4],[0,0,0],3,1,wf8(:,111))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,111),G1H4(107),m3h8x4(:,103),heltab2x32(:,:,517))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[26,1,4],[0,0,0],3,1,wf8(:,111))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,111),26,G1H4(109),m3h8x4(:,104),heltab2x32(:,:,518))
  Gcoeff(:)%j = (c(6)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[26,1,4],[0,0,0],3,1,wf8(:,111))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,111),26,G1H4(112),m3h8x4(:,105),heltab2x32(:,:,519))
  Gcoeff(:)%j = (c(6)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[28,1,2],[0,0,0],3,1,wf8(:,108))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,108),G1H4(113),m3h8x4(:,106),heltab2x32(:,:,520))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[28,1,2],[0,0,0],3,1,wf8(:,108))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,108),28,G1H4(119),m3h8x4(:,107),heltab2x32(:,:,521))
  Gcoeff(:)%j = (c(6)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[28,1,2],[0,0,0],3,1,wf8(:,108))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,108),28,G1H4(124),m3h8x4(:,108),heltab2x32(:,:,522))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(91),G1H4(28),G1H4(542),G1H4(538),G1H4(537) &
    ,G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(44),G1H4(549),G1H4(358),G1H4(342),G1H4(341) &
    ,G1H4(85),G1H4(155),G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(93),G1H4(27),G1H4(554),G1H4(553),G1H4(543) &
    ,G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(40),G1H4(565),G1H4(389),G1H4(374),G1H4(373) &
    ,G1H4(100),G1H4(167),G1H4(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(97),G1H4(29),G1H4(569),G1H4(559),G1H4(558) &
    ,G1H4(277),G0H4(36),G0H4(35),G0H4(34),G0H4(27),G0H4(26),G0H4(25),G0H4(18),G0H4(17),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G1H4(43),G1H4(566),G1H4(421),G1H4(406),G1H4(405) &
    ,G1H4(5),G1H4(176),G1H4(310),G0H4(51),G0H4(50),G0H4(49),G0H4(30),G0H4(29),G0H4(28),G0H4(6),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(76),G1H4(18),G1H4(118),G1H4(102),G1H4(101) &
    ,G1H4(38),G1H4(247),G1H4(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(33),G1H4(533),G1H4(485),G1H4(469),G1H4(454) &
    ,G1H4(496),G1H4(327),G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(71),G1H4(17),G1H4(575),G1H4(574),G1H4(570) &
    ,G1H4(576),G1H4(225),G1H4(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(32),G1H4(518),G1H4(453),G1H4(438),G1H4(422) &
    ,G1H4(487),G1H4(305),G1H4(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(72),G1H4(23),G1H4(149),G1H4(134),G1H4(133) &
    ,G1H4(212),G1H4(264),G1H4(517),G0H4(45),G0H4(44),G0H4(43),G0H4(24),G0H4(23),G0H4(22),G0H4(15),G0H4(14),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(39),G1H4(534),G1H4(502),G1H4(501),G1H4(486) &
    ,G1H4(504),G1H4(344),G1H4(550),G0H4(48),G0H4(47),G0H4(46),G0H4(39),G0H4(38),G0H4(37),G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(64),G1H4(2),G1H4(213),G1H4(198),G1H4(182) &
    ,G1H4(545),G1H4(65),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(61),G1H4(1),G1H4(181),G1H4(166),G1H4(165) &
    ,G1H4(555),G1H4(87),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(66),G1H4(12),G1H4(245),G1H4(229),G1H4(214) &
    ,G1H4(567),G1H4(104),G1H4(60),G0H4(42),G0H4(41),G0H4(40),G0H4(33),G0H4(32),G0H4(31),G0H4(9),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(525),[G1H4(445),G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(514),[G1H4(424),G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(540),[G1H4(465),G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(48),G1H4(8),G1H4(262),G1H4(261),G1H4(246) &
    ,G1H4(372),G1H4(380),G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(49),G1H4(11),G1H4(294),G1H4(293),G1H4(278) &
    ,G1H4(83),G1H4(395),G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(50),G1H4(13),G1H4(326),G1H4(325),G1H4(309) &
    ,G1H4(163),G1H4(416),G1H4(145),G0H4(54),G0H4(53),G0H4(52),G0H4(21),G0H4(20),G0H4(19),G0H4(12),G0H4(11),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(564),[G1H4(434),G1H4(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(460),G1H4(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(475),G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(365),G1H4(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(385),G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(407),G1H4(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(47),G0H8(48),G0H8(47),G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(53),G0H8(51),G0H8(50),G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(59),G0H8(54),G0H8(53),G0H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(65),G0H8(19),G0H8(20),G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(71),G0H8(28),G0H8(29),G0H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(77),G0H8(1),G0H8(2),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(54),[G1H8(83),G0H8(84),G0H8(83),G0H8(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(89),G0H8(87),G0H8(86),G0H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(56),[G1H8(95),G0H8(90),G0H8(89),G0H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(101),G0H8(36),G0H8(33),G0H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(107),G0H8(35),G0H8(32),G0H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(113),G0H8(34),G0H8(31),G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(72),[G1H8(137),G0H8(79),G0H8(76),G0H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(143),G0H8(80),G0H8(77),G0H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(149),G0H8(81),G0H8(78),G0H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(155),G0H8(43),G0H8(40),G0H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(161),G0H8(44),G0H8(41),G0H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(167),G0H8(45),G0H8(42),G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(100),[G1H8(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(203),G0H8(114),G0H8(113),G0H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(109),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(110),[G1H8(111),G0H8(129),G0H8(128),G0H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(118),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(116),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(120),[G1H8(2),G0H8(138),G0H8(137),G0H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(126),[G1H8(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(127),[G1H8(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(32),G0H8(132),G0H8(131),G0H8(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G1H8(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(223),G0H8(123),G0H8(122),G0H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(136),[G1H8(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(134),[G1H8(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(253),G0H8(141),G0H8(140),G0H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(142),[G1H8(268),G0H8(126),G0H8(125),G0H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(146),[G1H8(298),G0H8(144),G0H8(143),G0H8(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(148),[G1H8(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(150),[G1H8(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(313),G0H8(135),G0H8(134),G0H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(67),[G0H8(12),G0H8(24),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G0H8(11),G0H8(23),G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G0H8(10),G0H8(22),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G0H8(18),G0H8(9),G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G0H8(17),G0H8(8),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G0H8(16),G0H8(7),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G0H8(61),G0H8(58),G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G0H8(62),G0H8(59),G0H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G0H8(63),G0H8(60),G0H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G0H8(70),G0H8(67),G0H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G0H8(71),G0H8(68),G0H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G0H8(72),G0H8(69),G0H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(80),[G0H8(97),G0H8(94),G0H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G0H8(98),G0H8(95),G0H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G0H8(99),G0H8(96),G0H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G0H8(102),G0H8(101),G0H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G0H8(105),G0H8(104),G0H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G0H8(108),G0H8(107),G0H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(106),[G0H8(111),G0H8(110),G0H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G0H8(117),G0H8(116),G0H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G0H8(120),G0H8(119),G0H8(118)])
  call Hloop_DV_C(ntryL,G1H4(113),28,ex1(:),G2H2(355),m3h2x2(:,901),heltab2x4(:,:,1021))
  call Hloop_DV_C(ntryL,G1H4(77),21,ex2(:),G2H2(59),m3h2x2(:,902),heltab2x4(:,:,1022))
  call Hloop_CV_D(ntryL,G1H4(119),28,ex1(:),1,G2H2(3),m3h2x2(:,903),heltab2x4(:,:,1023))
  call Hloop_CV_D(ntryL,G1H4(80),21,ex2(:),2,G2H2(358),m3h2x2(:,904),heltab2x4(:,:,1024))
  call Hloop_UV_W(ntryL,G1H4(124),28,ex1(:),1,G2H2(64),m3h2x2(:,905),heltab2x4(:,:,1025))
  call Hloop_UV_W(ntryL,G1H4(81),21,ex2(:),2,G2H2(62),m3h2x2(:,906),heltab2x4(:,:,1026))
  call Hloop_CV_D(ntryL,G1H4(109),26,ex1(:),1,G2H2(8),m3h2x2(:,907),heltab2x4(:,:,1027))
  call Hloop_CV_D(ntryL,G1H4(56),19,ex3(:),4,G2H2(6),m3h2x2(:,908),heltab2x4(:,:,1028))
  call Hloop_DV_C(ntryL,G1H4(107),26,ex1(:),G2H2(363),m3h2x2(:,909),heltab2x4(:,:,1029))
  call Hloop_DV_C(ntryL,G1H4(55),19,ex3(:),G2H2(51),m3h2x2(:,910),heltab2x4(:,:,1030))
  call Hloop_UV_W(ntryL,G1H4(112),26,ex1(:),1,G2H2(11),m3h2x2(:,911),heltab2x4(:,:,1031))
  call Hloop_UV_W(ntryL,G1H4(59),19,ex3(:),4,G2H2(366),m3h2x2(:,912),heltab2x4(:,:,1032))
  call Hloop_CV_D(ntryL,G1H4(7),28,ex2(:),2,G2H2(56),m3h2x2(:,913),heltab2x4(:,:,1033))
  call Hloop_CV_D(ntryL,G1H4(92),22,ex1(:),1,G2H2(54),m3h2x2(:,914),heltab2x4(:,:,1034))
  call Hloop_DV_C(ntryL,G1H4(24),28,ex2(:),G2H2(16),m3h2x2(:,915),heltab2x4(:,:,1035))
  call Hloop_DV_C(ntryL,G1H4(82),22,ex1(:),G2H2(14),m3h2x2(:,916),heltab2x4(:,:,1036))
  call Hloop_UV_W(ntryL,G1H4(45),28,ex2(:),2,G2H2(371),m3h2x2(:,917),heltab2x4(:,:,1037))
  call Hloop_UV_W(ntryL,G1H4(88),22,ex1(:),1,G2H2(354),m3h2x2(:,918),heltab2x4(:,:,1038))
  call Hloop_CV_D(ntryL,G1H4(525),19,ex4(:),8,G2H2(353),m3h2x2(:,919),heltab2x4(:,:,1039))
  call Hloop_DV_C(ntryL,G1H4(514),19,ex4(:),G2H2(352),m3h2x2(:,920),heltab2x4(:,:,1040))
  call Hloop_UV_W(ntryL,G1H4(540),19,ex4(:),8,G2H2(67),m3h2x2(:,921),heltab2x4(:,:,1041))
  call Hloop_DV_C(ntryL,G1H4(98),25,ex2(:),G2H2(19),m3h2x2(:,922),heltab2x4(:,:,1042))
  call Hloop_CV_D(ntryL,G1H4(103),25,ex2(:),2,G2H2(374),m3h2x2(:,923),heltab2x4(:,:,1043))
  call Hloop_UV_W(ntryL,G1H4(108),25,ex2(:),2,G2H2(72),m3h2x2(:,924),heltab2x4(:,:,1044))
  call Hloop_CV_D(ntryL,G1H4(184),26,ex3(:),4,G2H2(70),m3h2x2(:,925),heltab2x4(:,:,1045))
  call Hloop_DV_C(ntryL,G1H4(194),26,ex3(:),G2H2(24),m3h2x2(:,926),heltab2x4(:,:,1046))
  call Hloop_UV_W(ntryL,G1H4(205),26,ex3(:),4,G2H2(22),m3h2x2(:,927),heltab2x4(:,:,1047))
  call Hloop_DV_C(ntryL,G1H4(220),22,ex4(:),G2H2(379),m3h2x2(:,928),heltab2x4(:,:,1048))
  call Hloop_CV_D(ntryL,G1H4(235),22,ex4(:),8,G2H2(147),m3h2x2(:,929),heltab2x4(:,:,1049))
  call Hloop_UV_W(ntryL,G1H4(256),22,ex4(:),8,G2H2(27),m3h2x2(:,930),heltab2x4(:,:,1050))
  call Hloop_DV_C(ntryL,G1H4(564),25,ex3(:),G2H2(382),m3h2x2(:,931),heltab2x4(:,:,1051))
  call Hloop_CV_D(ntryL,G1H4(42),25,ex3(:),4,G2H2(152),m3h2x2(:,932),heltab2x4(:,:,1052))
  call Hloop_UV_W(ntryL,G1H4(79),25,ex3(:),4,G2H2(150),m3h2x2(:,933),heltab2x4(:,:,1053))
  call Hloop_DV_C(ntryL,G1H4(148),21,ex4(:),G2H2(32),m3h2x2(:,934),heltab2x4(:,:,1054))
  call Hloop_CV_D(ntryL,G1H4(69),21,ex4(:),8,G2H2(30),m3h2x2(:,935),heltab2x4(:,:,1055))
  call Hloop_UV_W(ntryL,G1H4(3),21,ex4(:),8,G2H2(387),m3h2x2(:,936),heltab2x4(:,:,1056))
  call Hloop_UV_W(ntryL,G1H8(44),17,ex2(:),2,G2H4(31),m3h2x4(:,415),heltab2x8(:,:,511))
  call Hloop_UV_W(ntryL,G1H8(46),17,ex2(:),2,G2H4(34),m3h2x4(:,416),heltab2x8(:,:,512))
  call Hloop_UV_W(ntryL,G1H8(48),17,ex2(:),2,G2H4(35),m3h2x4(:,417),heltab2x8(:,:,513))
  call Hloop_UV_W(ntryL,G1H8(49),18,ex1(:),1,G2H4(36),m3h2x4(:,418),heltab2x8(:,:,514))
  call Hloop_UV_W(ntryL,G1H8(50),18,ex1(:),1,G2H4(39),m3h2x4(:,419),heltab2x8(:,:,515))
  call Hloop_UV_W(ntryL,G1H8(52),18,ex1(:),1,G2H4(40),m3h2x4(:,420),heltab2x8(:,:,516))
  call Hloop_UV_W(ntryL,G1H8(54),17,ex3(:),4,G2H4(41),m3h2x4(:,421),heltab2x8(:,:,517))
  call Hloop_UV_W(ntryL,G1H8(55),17,ex3(:),4,G2H4(44),m3h2x4(:,422),heltab2x8(:,:,518))
  call Hloop_UV_W(ntryL,G1H8(56),17,ex3(:),4,G2H4(45),m3h2x4(:,423),heltab2x8(:,:,519))
  call Hloop_UV_W(ntryL,G1H8(58),20,ex1(:),1,G2H4(46),m3h2x4(:,424),heltab2x8(:,:,520))
  call Hloop_UV_W(ntryL,G1H8(60),20,ex1(:),1,G2H4(49),m3h2x4(:,425),heltab2x8(:,:,521))
  call Hloop_UV_W(ntryL,G1H8(61),20,ex1(:),1,G2H4(50),m3h2x4(:,426),heltab2x8(:,:,522))
  call Hloop_UV_W(ntryL,G1H8(119),17,ex4(:),8,G2H4(51),m3h2x4(:,427),heltab2x8(:,:,523))
  call Hloop_UV_W(ntryL,G1H8(125),17,ex4(:),8,G2H4(54),m3h2x4(:,428),heltab2x8(:,:,524))
  call Hloop_UV_W(ntryL,G1H8(131),17,ex4(:),8,G2H4(55),m3h2x4(:,429),heltab2x8(:,:,525))
  call Hloop_UV_W(ntryL,G1H8(72),18,ex3(:),4,G2H4(56),m3h2x4(:,430),heltab2x8(:,:,526))
  call Hloop_UV_W(ntryL,G1H8(73),18,ex3(:),4,G2H4(59),m3h2x4(:,431),heltab2x8(:,:,527))
  call Hloop_UV_W(ntryL,G1H8(74),18,ex3(:),4,G2H4(60),m3h2x4(:,432),heltab2x8(:,:,528))
  call Hloop_UV_W(ntryL,G1H8(76),20,ex2(:),2,G2H4(101),m3h2x4(:,433),heltab2x8(:,:,529))
  call Hloop_UV_W(ntryL,G1H8(78),20,ex2(:),2,G2H4(105),m3h2x4(:,434),heltab2x8(:,:,530))
  call Hloop_UV_W(ntryL,G1H8(79),20,ex2(:),2,G2H4(106),m3h2x4(:,435),heltab2x8(:,:,531))
  call Hloop_UV_W(ntryL,G1H8(173),18,ex4(:),8,G2H4(110),m3h2x4(:,436),heltab2x8(:,:,532))
  call Hloop_UV_W(ntryL,G1H8(179),18,ex4(:),8,G2H4(111),m3h2x4(:,437),heltab2x8(:,:,533))
  call Hloop_UV_W(ntryL,G1H8(185),18,ex4(:),8,G2H4(115),m3h2x4(:,438),heltab2x8(:,:,534))
  call Hloop_CV_D(ntryL,G1H8(98),20,wf4(:,1),3,G2H2(155),m3h4x2(:,97),heltab2x8(:,:,535))
  call Hloop_DV_C(ntryL,G1H8(100),20,wf4(:,1),G2H2(35),m3h4x2(:,98),heltab2x8(:,:,536))
  call Hloop_UV_W(ntryL,G1H8(102),20,wf4(:,1),3,G2H2(390),m3h4x2(:,99),heltab2x8(:,:,537))
  call Hloop_DV_C(ntryL,G1H8(209),18,ex4(:),G2H4(116),m3h2x4(:,439),heltab2x8(:,:,538))
  call Hloop_CV_D(ntryL,G1H8(215),18,ex4(:),8,G2H4(120),m3h2x4(:,440),heltab2x8(:,:,539))
  call Hloop_UV_W(ntryL,G1H8(21),18,ex4(:),8,G2H4(121),m3h2x4(:,441),heltab2x8(:,:,540))
  call Hloop_CV_D(ntryL,G1H8(108),18,wf4(:,2),5,G2H2(160),m3h4x2(:,100),heltab2x8(:,:,541))
  call Hloop_DV_C(ntryL,G1H8(109),18,wf4(:,2),G2H2(158),m3h4x2(:,101),heltab2x8(:,:,542))
  call Hloop_UV_W(ntryL,G1H8(110),18,wf4(:,2),5,G2H2(40),m3h4x2(:,102),heltab2x8(:,:,543))
  call Hloop_DV_C(ntryL,G1H8(159),17,ex4(:),G2H4(125),m3h2x4(:,442),heltab2x8(:,:,544))
  call Hloop_CV_D(ntryL,G1H8(16),17,ex4(:),8,G2H4(126),m3h2x4(:,443),heltab2x8(:,:,545))
  call Hloop_UV_W(ntryL,G1H8(20),17,ex4(:),8,G2H4(130),m3h2x4(:,444),heltab2x8(:,:,546))
  call Hloop_CV_D(ntryL,G1H8(118),17,wf4(:,5),6,G2H2(38),m3h4x2(:,103),heltab2x8(:,:,547))
  call Hloop_DV_C(ntryL,G1H8(116),17,wf4(:,5),G2H2(395),m3h4x2(:,104),heltab2x8(:,:,548))
  call Hloop_UV_W(ntryL,G1H8(120),17,wf4(:,5),6,G2H2(351),m3h4x2(:,105),heltab2x8(:,:,549))
  call Hloop_DV_C(ntryL,G1H8(126),18,ex3(:),G2H4(131),m3h2x4(:,445),heltab2x8(:,:,550))
  call Hloop_CV_D(ntryL,G1H8(127),18,ex3(:),4,G2H4(135),m3h2x4(:,446),heltab2x8(:,:,551))
  call Hloop_UV_W(ntryL,G1H8(128),18,ex3(:),4,G2H4(136),m3h2x4(:,447),heltab2x8(:,:,552))
  call Hloop_CV_D(ntryL,G1H8(132),20,ex2(:),2,G2H4(140),m3h2x4(:,448),heltab2x8(:,:,553))
  call Hloop_DV_C(ntryL,G1H8(130),20,ex2(:),G2H4(141),m3h2x4(:,449),heltab2x8(:,:,554))
  call Hloop_UV_W(ntryL,G1H8(133),20,ex2(:),2,G2H4(145),m3h2x4(:,450),heltab2x8(:,:,555))
  call Hloop_CV_D(ntryL,G1H8(228),18,wf4(:,3),9,G2H2(350),m3h4x2(:,106),heltab2x8(:,:,556))
  call Hloop_DV_C(ntryL,G1H8(233),18,wf4(:,3),G2H2(349),m3h4x2(:,107),heltab2x8(:,:,557))
  call Hloop_UV_W(ntryL,G1H8(238),18,wf4(:,3),9,G2H2(163),m3h4x2(:,108),heltab2x8(:,:,558))
  call Hloop_DV_C(ntryL,G1H8(136),17,ex3(:),G2H4(146),m3h2x4(:,451),heltab2x8(:,:,559))
  call Hloop_CV_D(ntryL,G1H8(134),17,ex3(:),4,G2H4(150),m3h2x4(:,452),heltab2x8(:,:,560))
  call Hloop_UV_W(ntryL,G1H8(138),17,ex3(:),4,G2H4(151),m3h2x4(:,453),heltab2x8(:,:,561))
  call Hloop_CV_D(ntryL,G1H8(140),20,ex1(:),1,G2H4(155),m3h2x4(:,454),heltab2x8(:,:,562))
  call Hloop_DV_C(ntryL,G1H8(139),20,ex1(:),G2H4(156),m3h2x4(:,455),heltab2x8(:,:,563))
  call Hloop_UV_W(ntryL,G1H8(142),20,ex1(:),1,G2H4(160),m3h2x4(:,456),heltab2x8(:,:,564))
  call Hloop_CV_D(ntryL,G1H8(273),17,wf4(:,6),10,G2H2(43),m3h4x2(:,109),heltab2x8(:,:,565))
  call Hloop_DV_C(ntryL,G1H8(278),17,wf4(:,6),G2H2(398),m3h4x2(:,110),heltab2x8(:,:,566))
  call Hloop_UV_W(ntryL,G1H8(283),17,wf4(:,6),10,G2H2(168),m3h4x2(:,111),heltab2x8(:,:,567))
  call Hloop_DV_C(ntryL,G1H8(145),17,ex2(:),G2H4(161),m3h2x4(:,457),heltab2x8(:,:,568))
  call Hloop_CV_D(ntryL,G1H8(144),17,ex2(:),2,G2H4(165),m3h2x4(:,458),heltab2x8(:,:,569))
  call Hloop_UV_W(ntryL,G1H8(146),17,ex2(:),2,G2H4(166),m3h2x4(:,459),heltab2x8(:,:,570))
  call Hloop_CV_D(ntryL,G1H8(148),18,ex1(:),1,G2H4(170),m3h2x4(:,460),heltab2x8(:,:,571))
  call Hloop_DV_C(ntryL,G1H8(150),18,ex1(:),G2H4(171),m3h2x4(:,461),heltab2x8(:,:,572))
  call Hloop_UV_W(ntryL,G1H8(151),18,ex1(:),1,G2H4(175),m3h2x4(:,462),heltab2x8(:,:,573))
  call Hloop_CV_D(ntryL,G1H8(318),17,wf4(:,8),12,G2H2(166),m3h4x2(:,112),heltab2x8(:,:,574))
  call Hloop_DV_C(ntryL,G1H8(323),17,wf4(:,8),G2H2(48),m3h4x2(:,113),heltab2x8(:,:,575))
  call Hloop_UV_W(ntryL,G1H8(328),17,wf4(:,8),12,G2H2(46),m3h4x2(:,114),heltab2x8(:,:,576))
  call Hloop_UV_W(ntryL,G1H8(67),24,ex1(:),1,G2H4(176),m3h2x4(:,463),heltab2x8(:,:,577))
  call Hloop_UV_W(ntryL,G1H8(68),24,ex1(:),1,G2H4(180),m3h2x4(:,464),heltab2x8(:,:,578))
  call Hloop_UV_W(ntryL,G1H8(70),24,ex1(:),1,G2H4(123),m3h2x4(:,465),heltab2x8(:,:,579))
  call Hloop_UV_W(ntryL,G1H8(85),24,ex2(:),2,G2H4(128),m3h2x4(:,466),heltab2x8(:,:,580))
  call Hloop_UV_W(ntryL,G1H8(86),24,ex2(:),2,G2H4(8),m3h2x4(:,467),heltab2x8(:,:,581))
  call Hloop_UV_W(ntryL,G1H8(88),24,ex2(:),2,G2H4(13),m3h2x4(:,468),heltab2x8(:,:,582))
  call Hloop_GGG_G_12(ntryL,G1H8(94),ex2(:),ex1(:),G1H2(72),m4h2x2x2(:,43),heltab3x8(:,:,43))
  call Hloop_GGG_G_12(ntryL,G1H8(96),ex1(:),ex2(:),G1H2(78),m4h2x2x2(:,44),heltab3x8(:,:,44))
  call Hloop_GGG_G_23(ntryL,G1H8(97),ex2(:),ex1(:),G1H2(88),m4h2x2x2(:,45),heltab3x8(:,:,45))
  call Hloop_GGG_G_12(ntryL,G1H8(90),ex2(:),ex1(:),G1H2(98),m4h2x2x2(:,46),heltab3x8(:,:,46))
  call Hloop_GGG_G_12(ntryL,G1H8(91),ex1(:),ex2(:),G1H2(108),m4h2x2x2(:,47),heltab3x8(:,:,47))
  call Hloop_GGG_G_23(ntryL,G1H8(92),ex2(:),ex1(:),G1H2(118),m4h2x2x2(:,48),heltab3x8(:,:,48))
  call Hloop_GGG_G_12(ntryL,G1H16(1),ex2(:),ex1(:),G1H4(120),m4h2x2x4(:,13),heltab3x16(:,:,13))
  call Hloop_GGG_G_12(ntryL,G1H16(2),ex1(:),ex2(:),G1H4(123),m4h2x2x4(:,14),heltab3x16(:,:,14))
  call Hloop_GGG_G_23(ntryL,G1H16(3),ex2(:),ex1(:),G1H4(128),m4h2x2x4(:,15),heltab3x16(:,:,15))
  call Hloop_GGG_G_12(ntryL,G1H16(4),ex2(:),ex1(:),G1H4(129),m4h2x2x4(:,16),heltab3x16(:,:,16))
  call Hloop_GGG_G_12(ntryL,G1H16(5),ex1(:),ex2(:),G1H4(130),m4h2x2x4(:,17),heltab3x16(:,:,17))
  call Hloop_GGG_G_23(ntryL,G1H16(6),ex2(:),ex1(:),G1H4(135),m4h2x2x4(:,18),heltab3x16(:,:,18))
  call Hloop_GGG_G_12(ntryL,G1H16(7),ex2(:),ex1(:),G1H4(136),m4h2x2x4(:,19),heltab3x16(:,:,19))
  call Hloop_GGG_G_12(ntryL,G1H16(8),ex1(:),ex2(:),G1H4(139),m4h2x2x4(:,20),heltab3x16(:,:,20))
  call Hloop_GGG_G_23(ntryL,G1H16(9),ex2(:),ex1(:),G1H4(141),m4h2x2x4(:,21),heltab3x16(:,:,21))
  call Hloop_GGG_G_12(ntryL,G1H8(80),ex3(:),ex1(:),G1H2(128),m4h2x2x2(:,49),heltab3x8(:,:,49))
  call Hloop_GGG_G_12(ntryL,G1H8(82),ex1(:),ex3(:),G1H2(138),m4h2x2x2(:,50),heltab3x8(:,:,50))
  call Hloop_GGG_G_23(ntryL,G1H8(84),ex3(:),ex1(:),G1H2(148),m4h2x2x2(:,51),heltab3x8(:,:,51))
  call Hloop_GGG_G_12(ntryL,G1H16(10),ex3(:),ex1(:),G1H4(144),m4h2x2x4(:,22),heltab3x16(:,:,22))
  call Hloop_GGG_G_12(ntryL,G1H16(11),ex1(:),ex3(:),G1H4(146),m4h2x2x4(:,23),heltab3x16(:,:,23))
  call Hloop_GGG_G_23(ntryL,G1H16(12),ex3(:),ex1(:),G1H4(151),m4h2x2x4(:,24),heltab3x16(:,:,24))
  call Hloop_GGG_G_12(ntryL,G1H16(13),ex3(:),ex1(:),G1H4(156),m4h2x2x4(:,25),heltab3x16(:,:,25))
  call Hloop_GGG_G_12(ntryL,G1H16(14),ex1(:),ex3(:),G1H4(152),m4h2x2x4(:,26),heltab3x16(:,:,26))
  call Hloop_GGG_G_23(ntryL,G1H16(15),ex3(:),ex1(:),G1H4(157),m4h2x2x4(:,27),heltab3x16(:,:,27))
  call Hloop_GGG_G_12(ntryL,G1H16(16),ex3(:),ex1(:),G1H4(160),m4h2x2x4(:,28),heltab3x16(:,:,28))
  call Hloop_GGG_G_12(ntryL,G1H16(17),ex1(:),ex3(:),G1H4(161),m4h2x2x4(:,29),heltab3x16(:,:,29))
  call Hloop_GGG_G_23(ntryL,G1H16(18),ex3(:),ex1(:),G1H4(162),m4h2x2x4(:,30),heltab3x16(:,:,30))
  call Hloop_GGG_G_12(ntryL,G1H8(62),ex3(:),ex2(:),G1H2(158),m4h2x2x2(:,52),heltab3x8(:,:,52))
  call Hloop_GGG_G_12(ntryL,G1H8(64),ex2(:),ex3(:),G1H2(168),m4h2x2x2(:,53),heltab3x8(:,:,53))
  call Hloop_GGG_G_23(ntryL,G1H8(66),ex3(:),ex2(:),G1H2(178),m4h2x2x2(:,54),heltab3x8(:,:,54))
  call Hloop_GGG_G_12(ntryL,G1H16(19),ex3(:),ex2(:),G1H4(172),m4h2x2x4(:,31),heltab3x16(:,:,31))
  call Hloop_GGG_G_12(ntryL,G1H16(20),ex3(:),ex2(:),G1H4(168),m4h2x2x4(:,32),heltab3x16(:,:,32))
  call Hloop_GGG_G_12(ntryL,G1H16(21),ex3(:),ex2(:),G1H4(171),m4h2x2x4(:,33),heltab3x16(:,:,33))
  call Hloop_GGG_G_12(ntryL,G1H16(22),ex2(:),ex3(:),G1H4(173),m4h2x2x4(:,34),heltab3x16(:,:,34))
  call Hloop_GGG_G_12(ntryL,G1H16(23),ex2(:),ex3(:),G1H4(177),m4h2x2x4(:,35),heltab3x16(:,:,35))
  call Hloop_GGG_G_12(ntryL,G1H16(24),ex2(:),ex3(:),G1H4(178),m4h2x2x4(:,36),heltab3x16(:,:,36))
  call Hloop_GGG_G_23(ntryL,G1H16(25),ex3(:),ex2(:),G1H4(183),m4h2x2x4(:,37),heltab3x16(:,:,37))
  call Hloop_GGG_G_23(ntryL,G1H16(26),ex3(:),ex2(:),G1H4(188),m4h2x2x4(:,38),heltab3x16(:,:,38))
  call Hloop_GGG_G_23(ntryL,G1H16(27),ex3(:),ex2(:),G1H4(187),m4h2x2x4(:,39),heltab3x16(:,:,39))
  call Hloop_UV_W(ntryL,G1H16(28),16,ex3(:),4,G2H8(1),m3h2x8(:,121),heltab2x16(:,:,133))
  call Hloop_UV_W(ntryL,G1H16(29),16,ex3(:),4,G2H8(2),m3h2x8(:,122),heltab2x16(:,:,134))
  call Hloop_UV_W(ntryL,G1H16(30),16,ex3(:),4,G2H8(3),m3h2x8(:,123),heltab2x16(:,:,135))
  call Hloop_UV_W(ntryL,G1H8(106),24,wf4(:,1),3,G2H2(403),m3h4x2(:,115),heltab2x8(:,:,583))
  call Hloop_GGG_G_12(ntryL,G1H16(31),ex3(:),wf4(:,1),G1H2(188),m4h2x4x2(:,1),heltab3x16(:,:,40))
  call Hloop_GGG_G_12(ntryL,G1H16(32),wf4(:,1),ex3(:),G1H2(198),m4h4x2x2(:,1),heltab3x16(:,:,41))
  call Hloop_GGG_G_23(ntryL,G1H16(33),ex3(:),wf4(:,1),G1H2(208),m4h2x4x2(:,2),heltab3x16(:,:,42))
  call Hloop_UV_W(ntryL,G1H16(34),16,wf4(:,1),3,G2H4(91),m3h4x4(:,13),heltab2x16(:,:,136))
  call Hloop_UV_W(ntryL,G1H16(35),16,wf4(:,1),3,G2H4(18),m3h4x4(:,14),heltab2x16(:,:,137))
  call Hloop_UV_W(ntryL,G1H16(36),16,wf4(:,1),3,G2H4(94),m3h4x4(:,15),heltab2x16(:,:,138))
  call Hloop_UV_W(ntryL,G1H16(37),16,ex2(:),2,G2H8(4),m3h2x8(:,124),heltab2x16(:,:,139))
  call Hloop_UV_W(ntryL,G1H16(38),16,ex2(:),2,G2H8(5),m3h2x8(:,125),heltab2x16(:,:,140))
  call Hloop_UV_W(ntryL,G1H16(39),16,ex2(:),2,G2H8(6),m3h2x8(:,126),heltab2x16(:,:,141))
  call Hloop_UV_W(ntryL,G1H8(115),24,ex2(:),2,G2H4(23),m3h2x4(:,469),heltab2x8(:,:,584))
  call Hloop_UV_W(ntryL,G1H16(40),16,ex1(:),1,G2H8(7),m3h2x8(:,127),heltab2x16(:,:,142))
  call Hloop_UV_W(ntryL,G1H16(41),16,ex1(:),1,G2H8(8),m3h2x8(:,128),heltab2x16(:,:,143))
  call Hloop_UV_W(ntryL,G1H16(42),16,ex1(:),1,G2H8(9),m3h2x8(:,129),heltab2x16(:,:,144))
  call Hloop_UV_W(ntryL,G1H8(124),24,ex1(:),1,G2H4(61),m3h2x4(:,470),heltab2x8(:,:,585))
  call Hloop_UV_W(ntryL,G1H16(43),16,ex2(:),2,G2H8(10),m3h2x8(:,130),heltab2x16(:,:,145))
  call Hloop_UV_W(ntryL,G1H16(44),16,ex2(:),2,G2H8(11),m3h2x8(:,131),heltab2x16(:,:,146))
  call Hloop_UV_W(ntryL,G1H16(45),16,ex2(:),2,G2H8(12),m3h2x8(:,132),heltab2x16(:,:,147))
  call Hloop_UV_W(ntryL,G1H16(46),16,ex1(:),1,G2H8(13),m3h2x8(:,133),heltab2x16(:,:,148))
  call Hloop_UV_W(ntryL,G1H16(47),16,ex1(:),1,G2H8(14),m3h2x8(:,134),heltab2x16(:,:,149))
  call Hloop_UV_W(ntryL,G1H16(48),16,ex1(:),1,G2H8(15),m3h2x8(:,135),heltab2x16(:,:,150))
  call Hloop_GGG_G_12(ntryL,G1H16(49),ex2(:),wf4(:,2),G1H2(218),m4h2x4x2(:,3),heltab3x16(:,:,43))
  call Hloop_GGG_G_12(ntryL,G1H16(50),wf4(:,2),ex2(:),G1H2(228),m4h4x2x2(:,2),heltab3x16(:,:,44))
  call Hloop_GGG_G_23(ntryL,G1H16(51),ex2(:),wf4(:,2),G1H2(238),m4h2x4x2(:,4),heltab3x16(:,:,45))
  call Hloop_UV_W(ntryL,G1H16(52),16,wf4(:,2),5,G2H4(28),m3h4x4(:,16),heltab2x16(:,:,151))
  call Hloop_UV_W(ntryL,G1H16(53),16,wf4(:,2),5,G2H4(93),m3h4x4(:,17),heltab2x16(:,:,152))
  call Hloop_UV_W(ntryL,G1H16(54),16,wf4(:,2),5,G2H4(98),m3h4x4(:,18),heltab2x16(:,:,153))
  call Hloop_UV_W(ntryL,G1H16(55),16,ex3(:),4,G2H8(16),m3h2x8(:,136),heltab2x16(:,:,154))
  call Hloop_UV_W(ntryL,G1H16(56),16,ex3(:),4,G2H8(17),m3h2x8(:,137),heltab2x16(:,:,155))
  call Hloop_UV_W(ntryL,G1H16(57),16,ex3(:),4,G2H8(18),m3h2x8(:,138),heltab2x16(:,:,156))
  call Hloop_UV_W(ntryL,G1H16(58),16,ex1(:),1,G2H8(19),m3h2x8(:,139),heltab2x16(:,:,157))
  call Hloop_UV_W(ntryL,G1H16(59),16,ex1(:),1,G2H8(20),m3h2x8(:,140),heltab2x16(:,:,158))
  call Hloop_UV_W(ntryL,G1H16(60),16,ex1(:),1,G2H8(21),m3h2x8(:,141),heltab2x16(:,:,159))
  call Hloop_GGG_G_12(ntryL,G1H16(61),ex3(:),ex2(:),G1H4(189),m4h2x2x4(:,40),heltab3x16(:,:,46))
  call Hloop_GGG_G_12(ntryL,G1H16(62),ex2(:),ex3(:),G1H4(192),m4h2x2x4(:,41),heltab3x16(:,:,47))
  call Hloop_GGG_G_23(ntryL,G1H16(63),ex3(:),ex2(:),G1H4(193),m4h2x2x4(:,42),heltab3x16(:,:,48))
  call Hloop_CV_D(ntryL,G1H16(64),16,ex1(:),1,G2H8(22),m3h2x8(:,142),heltab2x16(:,:,160))
  call Hloop_CV_D(ntryL,G1H16(65),16,ex1(:),1,G2H8(23),m3h2x8(:,143),heltab2x16(:,:,161))
  call Hloop_CV_D(ntryL,G1H16(66),16,ex1(:),1,G2H8(24),m3h2x8(:,144),heltab2x16(:,:,162))
  call Hloop_DV_C(ntryL,G1H16(67),16,ex1(:),G2H8(25),m3h2x8(:,145),heltab2x16(:,:,163))
  call Hloop_DV_C(ntryL,G1H16(68),16,ex1(:),G2H8(26),m3h2x8(:,146),heltab2x16(:,:,164))
  call Hloop_DV_C(ntryL,G1H16(69),16,ex1(:),G2H8(27),m3h2x8(:,147),heltab2x16(:,:,165))
  call Hloop_UV_W(ntryL,G1H16(70),16,ex1(:),1,G2H8(28),m3h2x8(:,148),heltab2x16(:,:,166))
  call Hloop_UV_W(ntryL,G1H16(71),16,ex1(:),1,G2H8(29),m3h2x8(:,149),heltab2x16(:,:,167))
  call Hloop_UV_W(ntryL,G1H16(72),16,ex1(:),1,G2H8(30),m3h2x8(:,150),heltab2x16(:,:,168))
  call Hloop_GGG_G_12(ntryL,G1H16(73),ex1(:),wf4(:,5),G1H2(248),m4h2x4x2(:,5),heltab3x16(:,:,49))
  call Hloop_GGG_G_12(ntryL,G1H16(74),wf4(:,5),ex1(:),G1H2(258),m4h4x2x2(:,3),heltab3x16(:,:,50))
  call Hloop_GGG_G_23(ntryL,G1H16(75),ex1(:),wf4(:,5),G1H2(268),m4h2x4x2(:,6),heltab3x16(:,:,51))
  call Hloop_UV_W(ntryL,G1H16(76),16,wf4(:,5),6,G2H4(38),m3h4x4(:,19),heltab2x16(:,:,169))
  call Hloop_UV_W(ntryL,G1H16(77),16,wf4(:,5),6,G2H4(43),m3h4x4(:,20),heltab2x16(:,:,170))
  call Hloop_UV_W(ntryL,G1H16(78),16,wf4(:,5),6,G2H4(11),m3h4x4(:,21),heltab2x16(:,:,171))
  call Hloop_UV_W(ntryL,G1H16(79),16,ex3(:),4,G2H8(31),m3h2x8(:,151),heltab2x16(:,:,172))
  call Hloop_UV_W(ntryL,G1H16(80),16,ex3(:),4,G2H8(32),m3h2x8(:,152),heltab2x16(:,:,173))
  call Hloop_UV_W(ntryL,G1H16(81),16,ex3(:),4,G2H8(33),m3h2x8(:,153),heltab2x16(:,:,174))
  call Hloop_UV_W(ntryL,G1H16(82),16,ex2(:),2,G2H8(34),m3h2x8(:,154),heltab2x16(:,:,175))
  call Hloop_UV_W(ntryL,G1H16(83),16,ex2(:),2,G2H8(35),m3h2x8(:,155),heltab2x16(:,:,176))
  call Hloop_UV_W(ntryL,G1H16(84),16,ex2(:),2,G2H8(36),m3h2x8(:,156),heltab2x16(:,:,177))
  call Hloop_GGG_G_12(ntryL,G1H16(85),ex3(:),ex1(:),G1H4(199),m4h2x2x4(:,43),heltab3x16(:,:,52))
  call Hloop_GGG_G_12(ntryL,G1H16(86),ex1(:),ex3(:),G1H4(204),m4h2x2x4(:,44),heltab3x16(:,:,53))
  call Hloop_GGG_G_23(ntryL,G1H16(87),ex3(:),ex1(:),G1H4(200),m4h2x2x4(:,45),heltab3x16(:,:,54))
  call Hloop_CV_D(ntryL,G1H16(88),16,ex2(:),2,G2H8(37),m3h2x8(:,157),heltab2x16(:,:,178))
  call Hloop_CV_D(ntryL,G1H16(89),16,ex2(:),2,G2H8(38),m3h2x8(:,158),heltab2x16(:,:,179))
  call Hloop_CV_D(ntryL,G1H16(90),16,ex2(:),2,G2H8(39),m3h2x8(:,159),heltab2x16(:,:,180))
  call Hloop_DV_C(ntryL,G1H16(91),16,ex2(:),G2H8(40),m3h2x8(:,160),heltab2x16(:,:,181))
  call Hloop_DV_C(ntryL,G1H16(92),16,ex2(:),G2H8(41),m3h2x8(:,161),heltab2x16(:,:,182))
  call Hloop_DV_C(ntryL,G1H16(93),16,ex2(:),G2H8(42),m3h2x8(:,162),heltab2x16(:,:,183))
  call Hloop_UV_W(ntryL,G1H16(94),16,ex2(:),2,G2H8(43),m3h2x8(:,163),heltab2x16(:,:,184))
  call Hloop_UV_W(ntryL,G1H16(95),16,ex2(:),2,G2H8(44),m3h2x8(:,164),heltab2x16(:,:,185))
  call Hloop_UV_W(ntryL,G1H16(96),16,ex2(:),2,G2H8(45),m3h2x8(:,165),heltab2x16(:,:,186))
  call Hloop_GGG_G_12(ntryL,G1H16(97),ex2(:),ex1(:),G1H4(203),m4h2x2x4(:,46),heltab3x16(:,:,55))
  call Hloop_GGG_G_12(ntryL,G1H16(98),ex1(:),ex2(:),G1H4(208),m4h2x2x4(:,47),heltab3x16(:,:,56))
  call Hloop_GGG_G_23(ntryL,G1H16(99),ex2(:),ex1(:),G1H4(209),m4h2x2x4(:,48),heltab3x16(:,:,57))
  call Hloop_CV_D(ntryL,G1H16(100),16,ex3(:),4,G2H8(46),m3h2x8(:,166),heltab2x16(:,:,187))
  call Hloop_CV_D(ntryL,G1H16(101),16,ex3(:),4,G2H8(47),m3h2x8(:,167),heltab2x16(:,:,188))
  call Hloop_CV_D(ntryL,G1H16(102),16,ex3(:),4,G2H8(48),m3h2x8(:,168),heltab2x16(:,:,189))
  call Hloop_DV_C(ntryL,G1H16(103),16,ex3(:),G2H8(49),m3h2x8(:,169),heltab2x16(:,:,190))
  call Hloop_DV_C(ntryL,G1H16(104),16,ex3(:),G2H8(50),m3h2x8(:,170),heltab2x16(:,:,191))
  call Hloop_DV_C(ntryL,G1H16(105),16,ex3(:),G2H8(51),m3h2x8(:,171),heltab2x16(:,:,192))
  call Hloop_UV_W(ntryL,G1H16(106),16,ex3(:),4,G2H8(52),m3h2x8(:,172),heltab2x16(:,:,193))
  call Hloop_UV_W(ntryL,G1H16(107),16,ex3(:),4,G2H8(53),m3h2x8(:,173),heltab2x16(:,:,194))
  call Hloop_UV_W(ntryL,G1H16(108),16,ex3(:),4,G2H8(54),m3h2x8(:,174),heltab2x16(:,:,195))
  call Hloop_DV_C(ntryL,G1H16(109),16,wf8(:,28),G2H2(406),m3h8x2(:,1),heltab2x16(:,:,196))
  call Hloop_DV_C(ntryL,G1H16(110),16,wf8(:,29),G2H2(411),m3h8x2(:,2),heltab2x16(:,:,197))
  call Hloop_DV_C(ntryL,G1H16(111),16,wf8(:,30),G2H2(414),m3h8x2(:,3),heltab2x16(:,:,198))
  call Hloop_CV_D(ntryL,G1H16(112),16,wf8(:,28),7,G2H2(419),m3h8x2(:,4),heltab2x16(:,:,199))
  call Hloop_CV_D(ntryL,G1H16(113),16,wf8(:,29),7,G2H2(422),m3h8x2(:,5),heltab2x16(:,:,200))
  call Hloop_CV_D(ntryL,G1H16(114),16,wf8(:,30),7,G2H2(427),m3h8x2(:,6),heltab2x16(:,:,201))
  call Hloop_UV_W(ntryL,G1H16(115),16,wf8(:,28),7,G2H2(179),m3h8x2(:,7),heltab2x16(:,:,202))
  call Hloop_UV_W(ntryL,G1H16(116),16,wf8(:,29),7,G2H2(75),m3h8x2(:,8),heltab2x16(:,:,203))
  call Hloop_UV_W(ntryL,G1H16(117),16,wf8(:,30),7,G2H2(105),m3h8x2(:,9),heltab2x16(:,:,204))
  call Hloop_DV_C(ntryL,G1H16(118),16,wf4(:,1),G2H4(48),m3h4x4(:,22),heltab2x16(:,:,205))
  call Hloop_CV_D(ntryL,G1H16(119),16,wf4(:,1),3,G2H4(15),m3h4x4(:,23),heltab2x16(:,:,206))
  call Hloop_UV_W(ntryL,G1H16(120),16,wf4(:,1),3,G2H4(58),m3h4x4(:,24),heltab2x16(:,:,207))
  call Hloop_CV_D(ntryL,G1H8(103),24,wf4(:,1),3,G2H2(430),m3h4x2(:,116),heltab2x8(:,:,586))
  call Hloop_DV_C(ntryL,G1H8(104),24,wf4(:,1),G2H2(184),m3h4x2(:,117),heltab2x8(:,:,587))
  call Hloop_DV_C(ntryL,G1H16(121),16,wf8(:,33),G2H2(182),m3h8x2(:,10),heltab2x16(:,:,208))
  call Hloop_CV_D(ntryL,G1H16(122),16,wf8(:,33),7,G2H2(80),m3h8x2(:,11),heltab2x16(:,:,209))
  call Hloop_UV_W(ntryL,G1H16(123),16,wf8(:,33),7,G2H2(78),m3h8x2(:,12),heltab2x16(:,:,210))
  call Hloop_CV_D(ntryL,G1H16(124),16,ex3(:),4,G2H8(55),m3h2x8(:,175),heltab2x16(:,:,211))
  call Hloop_DV_C(ntryL,G1H16(125),16,ex3(:),G2H8(56),m3h2x8(:,176),heltab2x16(:,:,212))
  call Hloop_UV_W(ntryL,G1H16(126),16,ex3(:),4,G2H8(57),m3h2x8(:,177),heltab2x16(:,:,213))
  call Hloop_DV_C(ntryL,G1H16(127),16,wf4(:,2),G2H4(95),m3h4x4(:,25),heltab2x16(:,:,214))
  call Hloop_CV_D(ntryL,G1H16(128),16,wf4(:,2),5,G2H4(64),m3h4x4(:,26),heltab2x16(:,:,215))
  call Hloop_UV_W(ntryL,G1H16(129),16,wf4(:,2),5,G2H4(1),m3h4x4(:,27),heltab2x16(:,:,216))
  call Hloop_DV_C(ntryL,G1H8(112),24,ex2(:),G2H4(5),m3h2x4(:,471),heltab2x8(:,:,588))
  call Hloop_CV_D(ntryL,G1H8(114),24,ex2(:),2,G2H4(9),m3h2x4(:,472),heltab2x8(:,:,589))
  call Hloop_DV_C(ntryL,G1H16(130),16,wf8(:,36),G2H2(435),m3h8x2(:,13),heltab2x16(:,:,217))
  call Hloop_CV_D(ntryL,G1H16(131),16,wf8(:,36),7,G2H2(171),m3h8x2(:,14),heltab2x16(:,:,218))
  call Hloop_UV_W(ntryL,G1H16(132),16,wf8(:,36),7,G2H2(83),m3h8x2(:,15),heltab2x16(:,:,219))
  call Hloop_CV_D(ntryL,G1H16(133),16,ex2(:),2,G2H8(58),m3h2x8(:,178),heltab2x16(:,:,220))
  call Hloop_DV_C(ntryL,G1H16(134),16,ex2(:),G2H8(59),m3h2x8(:,179),heltab2x16(:,:,221))
  call Hloop_UV_W(ntryL,G1H16(135),16,ex2(:),2,G2H8(60),m3h2x8(:,180),heltab2x16(:,:,222))
  call Hloop_CV_D(ntryL,G1H16(136),16,wf4(:,5),6,G2H4(10),m3h4x4(:,28),heltab2x16(:,:,223))
  call Hloop_DV_C(ntryL,G1H16(137),16,wf4(:,5),G2H4(89),m3h4x4(:,29),heltab2x16(:,:,224))
  call Hloop_UV_W(ntryL,G1H16(138),16,wf4(:,5),6,G2H4(66),m3h4x4(:,30),heltab2x16(:,:,225))
  call Hloop_DV_C(ntryL,G1H8(121),24,ex1(:),G2H4(19),m3h2x4(:,473),heltab2x8(:,:,590))
  call Hloop_CV_D(ntryL,G1H8(122),24,ex1(:),1,G2H4(20),m3h2x4(:,474),heltab2x8(:,:,591))
  call Hloop_DV_C(ntryL,G1H16(139),16,wf8(:,39),G2H2(121),m3h8x2(:,16),heltab2x16(:,:,226))
  call Hloop_CV_D(ntryL,G1H16(140),16,wf8(:,39),7,G2H2(438),m3h8x2(:,17),heltab2x16(:,:,227))
  call Hloop_UV_W(ntryL,G1H16(141),16,wf8(:,39),7,G2H2(176),m3h8x2(:,18),heltab2x16(:,:,228))
  call Hloop_CV_D(ntryL,G1H16(142),16,ex1(:),1,G2H8(61),m3h2x8(:,181),heltab2x16(:,:,229))
  call Hloop_DV_C(ntryL,G1H16(143),16,ex1(:),G2H8(62),m3h2x8(:,182),heltab2x16(:,:,230))
  call Hloop_UV_W(ntryL,G1H16(144),16,ex1(:),1,G2H8(63),m3h2x8(:,183),heltab2x16(:,:,231))
  call Hloop_CV_D(ntryL,G1H16(145),16,ex3(:),4,G2H8(64),m3h2x8(:,184),heltab2x16(:,:,232))
  call Hloop_DV_C(ntryL,G1H16(146),16,ex3(:),G2H8(65),m3h2x8(:,185),heltab2x16(:,:,233))
  call Hloop_UV_W(ntryL,G1H16(147),16,ex3(:),4,G2H8(66),m3h2x8(:,186),heltab2x16(:,:,234))
  call Hloop_CV_D(ntryL,G1H16(148),16,ex2(:),2,G2H8(67),m3h2x8(:,187),heltab2x16(:,:,235))
  call Hloop_DV_C(ntryL,G1H16(149),16,ex2(:),G2H8(68),m3h2x8(:,188),heltab2x16(:,:,236))
  call Hloop_UV_W(ntryL,G1H16(150),16,ex2(:),2,G2H8(69),m3h2x8(:,189),heltab2x16(:,:,237))
  call Hloop_CV_D(ntryL,G1H16(151),16,ex3(:),4,G2H8(70),m3h2x8(:,190),heltab2x16(:,:,238))
  call Hloop_DV_C(ntryL,G1H16(152),16,ex3(:),G2H8(71),m3h2x8(:,191),heltab2x16(:,:,239))
  call Hloop_UV_W(ntryL,G1H16(153),16,ex3(:),4,G2H8(72),m3h2x8(:,192),heltab2x16(:,:,240))
  call Hloop_CV_D(ntryL,G1H16(154),16,ex1(:),1,G2H8(73),m3h2x8(:,193),heltab2x16(:,:,241))
  call Hloop_DV_C(ntryL,G1H16(155),16,ex1(:),G2H8(74),m3h2x8(:,194),heltab2x16(:,:,242))
  call Hloop_UV_W(ntryL,G1H16(156),16,ex1(:),1,G2H8(75),m3h2x8(:,195),heltab2x16(:,:,243))
  call Hloop_CV_D(ntryL,G1H16(157),16,ex2(:),2,G2H8(76),m3h2x8(:,196),heltab2x16(:,:,244))
  call Hloop_DV_C(ntryL,G1H16(158),16,ex2(:),G2H8(77),m3h2x8(:,197),heltab2x16(:,:,245))
  call Hloop_UV_W(ntryL,G1H16(159),16,ex2(:),2,G2H8(78),m3h2x8(:,198),heltab2x16(:,:,246))
  call Hloop_CV_D(ntryL,G1H16(160),16,ex1(:),1,G2H8(79),m3h2x8(:,199),heltab2x16(:,:,247))
  call Hloop_DV_C(ntryL,G1H16(161),16,ex1(:),G2H8(80),m3h2x8(:,200),heltab2x16(:,:,248))
  call Hloop_UV_W(ntryL,G1H16(162),16,ex1(:),1,G2H8(81),m3h2x8(:,201),heltab2x16(:,:,249))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(465),G2H2(437),G2H2(113),G2H2(1),G1H2(233) &
    ,G1H2(133),G1H2(48)])
call HGT_OLR(G2H2(440),1,1,2)
call HGT_invQ_OLR(G2H2(440),2,5,2)
call HGT_OLR(G2H2(440),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(440),[G2H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(435),G2H2(182),G2H2(414),G2H2(411),G2H2(406) &
    ,G2H2(719),G2H2(707),G2H2(695),G2H2(417),G2H2(393),G2H2(361),G2H2(116),G2H2(68),G2H2(4),G1H2(250),G1H2(401),G1H2(351),G1H2(47) &
    ,G1H2(414),G1H2(314)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(155),[G2H2(469),G2H2(429),G2H2(97),G2H2(17),G1H2(33) &
    ,G1H2(7),G1H2(339)])
call HGT_OLR(G2H2(432),1,1,2)
call HGT_invQ_OLR(G2H2(432),2,5,2)
call HGT_OLR(G2H2(432),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(432),[G2H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G2H2(171),G2H2(80),G2H2(427),G2H2(422),G2H2(419) &
    ,G2H2(716),G2H2(704),G2H2(692),G2H2(409),G2H2(385),G2H2(369),G2H2(100),G2H2(52),G2H2(20),G1H2(425),G1H2(386),G1H2(362) &
    ,G1H2(333),G1H2(390),G1H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(390),[G2H2(473),G2H2(445),G2H2(129),G2H2(33),G1H2(118) &
    ,G1H2(108),G1H2(98),G1H2(407),G1H2(19),G1H2(58)])
call HGT_lower_alpha_OLR(G2H2(448),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(448),2,5,2)
call HGT_lower_alpha_OLR(G2H2(448),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(448),[G2H2(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G2H2(83),G2H2(78),G2H2(105),G2H2(75),G2H2(179) &
    ,G2H2(722),G2H2(710),G2H2(698),G2H2(425),G2H2(401),G2H2(377),G2H2(132),G2H2(84),G2H2(36),G1H2(268),G1H2(258),G1H2(248) &
    ,G1H2(238),G1H2(228),G1H2(218),G1H2(208),G1H2(198),G1H2(188),G1H2(40),G1H2(412),G1H2(375),G1H2(75),G1H2(83),G1H2(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(621),G2H2(533),G2H2(241),G2H2(49),G1H2(472) &
    ,G1H2(236),G1H2(389)])
call HGT_OLR(G2H2(536),1,1,2)
call HGT_invQ_OLR(G2H2(536),2,5,2)
call HGT_OLR(G2H2(536),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(536),[G2H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(625),G2H2(525),G2H2(249),G2H2(65),G1H2(477) &
    ,G1H2(262),G1H2(68)])
call HGT_OLR(G2H2(528),1,1,2)
call HGT_invQ_OLR(G2H2(528),2,5,2)
call HGT_OLR(G2H2(528),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(528),[G2H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(629),G2H2(541),G2H2(257),G2H2(81),G1H2(148) &
    ,G1H2(138),G1H2(128),G1H2(482),G1H2(252),G1H2(153)])
call HGT_lower_alpha_OLR(G2H2(544),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(544),2,5,2)
call HGT_lower_alpha_OLR(G2H2(544),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(544),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(350),[G2H2(637),G2H2(581),G2H2(281),G2H2(145),G1H2(497) &
    ,G1H2(311),G1H2(123)])
call HGT_OLR(G2H2(584),1,1,2)
call HGT_invQ_OLR(G2H2(584),2,5,2)
call HGT_OLR(G2H2(584),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(584),[G2H2(350)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(746),[G2H2(731),G2H2(561),G2H2(501),G2H2(433),G2H2(318) &
    ,G2H2(284),G2H2(148),G1H2(577),G1H2(502),G1H2(270),G1H2(403),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(349),[G2H2(633),G2H2(573),G2H2(265),G2H2(161),G1H2(487) &
    ,G1H2(296),G1H2(297)])
call HGT_OLR(G2H2(576),1,1,2)
call HGT_invQ_OLR(G2H2(576),2,5,2)
call HGT_OLR(G2H2(576),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(576),[G2H2(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(749),[G2H2(734),G2H2(553),G2H2(493),G2H2(441),G2H2(314) &
    ,G2H2(268),G2H2(164),G1H2(567),G1H2(492),G1H2(289),G1H2(237),G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G2H2(641),G2H2(589),G2H2(291),G2H2(177),G1H2(507) &
    ,G1H2(331),G1H2(151)])
call HGT_lower_alpha_OLR(G2H2(592),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(592),2,5,2)
call HGT_lower_alpha_OLR(G2H2(592),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(592),[G2H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(752),[G2H2(737),G2H2(569),G2H2(509),G2H2(449),G2H2(322) &
    ,G2H2(292),G2H2(180),G1H2(587),G1H2(512),G1H2(437),G1H2(67),G1H2(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(395),[G2H2(645),G2H2(597),G2H2(295),G2H2(193),G1H2(517) &
    ,G1H2(442),G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(649),G2H2(601),G2H2(297),G2H2(201),G1H2(522) &
    ,G1H2(447),G1H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(351),[G2H2(653),G2H2(605),G2H2(299),G2H2(209),G1H2(178) &
    ,G1H2(168),G1H2(158),G1H2(527),G1H2(452),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(398),[G2H2(669),G2H2(609),G2H2(313),G2H2(217),G1H2(562) &
    ,G1H2(457),G1H2(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(673),G2H2(613),G2H2(317),G2H2(225),G1H2(572) &
    ,G1H2(462),G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G2H2(677),G2H2(617),G2H2(321),G2H2(233),G1H2(582) &
    ,G1H2(467),G1H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(681),G2H2(657),G2H2(325),G2H2(301),G1H2(592) &
    ,G1H2(532),G1H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(764),[G2H2(577),G2H2(529),G2H2(326),G2H2(302),G1H2(597) &
    ,G1H2(537),G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G2H2(685),G2H2(661),G2H2(329),G2H2(305),G1H2(602) &
    ,G1H2(542),G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(761),[G2H2(585),G2H2(537),G2H2(330),G2H2(306),G1H2(607) &
    ,G1H2(547),G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(689),G2H2(665),G2H2(333),G2H2(309),G1H2(612) &
    ,G1H2(552),G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(767),[G2H2(593),G2H2(545),G2H2(334),G2H2(310),G1H2(617) &
    ,G1H2(557),G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(743),[G2H2(624),G2H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(57)])
call HGT_OLR(G2H2(743),1,1,2)
call HGT_invQ_OLR(G2H2(743),2,5,2)
call HGT_OLR(G2H2(743),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(743),[G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(513),[G2H2(357),G1H2(102),G1H2(46)])
call HGT_OLR(G2H2(360),1,1,2)
call HGT_invQ_OLR(G2H2(360),2,5,2)
call HGT_OLR(G2H2(360),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(360),[G2H2(513)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(742),[G2H2(620),G2H2(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G1H2(357)])
call HGT_OLR(G2H2(742),1,1,2)
call HGT_invQ_OLR(G2H2(742),2,5,2)
call HGT_OLR(G2H2(742),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(742),[G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(517),[G2H2(365),G1H2(196),G1H2(329)])
call HGT_OLR(G2H2(368),1,1,2)
call HGT_invQ_OLR(G2H2(368),2,5,2)
call HGT_OLR(G2H2(368),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(368),[G2H2(517)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(744),[G2H2(628),G2H2(372),G1H2(219),G1H2(214),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(433)])
call HGT_lower_alpha_OLR(G2H2(744),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(744),2,5,2)
call HGT_lower_alpha_OLR(G2H2(744),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(744),[G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(521),[G2H2(373),G1H2(126),G1H2(56)])
call HGT_lower_alpha_OLR(G2H2(376),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(376),2,5,2)
call HGT_lower_alpha_OLR(G2H2(376),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(376),[G2H2(521)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(757),[G2H2(428),G2H2(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(87)])
call HGT_OLR(G2H2(757),1,1,2)
call HGT_invQ_OLR(G2H2(757),2,5,2)
call HGT_OLR(G2H2(757),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(757),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G2H2(457),G2H2(381),G1H2(203),G1H2(379)])
call HGT_OLR(G2H2(384),1,1,2)
call HGT_invQ_OLR(G2H2(384),2,5,2)
call HGT_OLR(G2H2(384),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(384),[G2H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(758),[G2H2(436),G2H2(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(157)])
call HGT_OLR(G2H2(758),1,1,2)
call HGT_invQ_OLR(G2H2(758),2,5,2)
call HGT_OLR(G2H2(758),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(758),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G2H2(453),G2H2(389),G1H2(307),G1H2(66)])
call HGT_OLR(G2H2(392),1,1,2)
call HGT_invQ_OLR(G2H2(392),2,5,2)
call HGT_OLR(G2H2(392),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(392),[G2H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(759),[G2H2(444),G2H2(396),G1H2(26),G1H2(200),G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(371),[G1H2(5)])
call HGT_lower_alpha_OLR(G2H2(759),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(759),2,5,2)
call HGT_lower_alpha_OLR(G2H2(759),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(759),[G2H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(403),[G2H2(461),G2H2(397),G1H2(88),G1H2(78),G1H2(72) &
    ,G1H2(217),G1H2(429)])
call HGT_lower_alpha_OLR(G2H2(400),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(400),2,5,2)
call HGT_lower_alpha_OLR(G2H2(400),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(400),[G2H2(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(727),[G2H2(648),G2H2(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(606),G1H2(601),G1H2(112)])
call HGT_OLR(G2H2(727),1,1,2)
call HGT_invQ_OLR(G2H2(727),2,5,2)
call HGT_OLR(G2H2(727),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(727),[G2H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(477),[G2H2(405),G1H2(111),G1H2(143)])
call HGT_OLR(G2H2(408),1,1,2)
call HGT_invQ_OLR(G2H2(408),2,5,2)
call HGT_OLR(G2H2(408),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(408),[G2H2(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(728),[G2H2(644),G2H2(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(382),[G1H2(596),G1H2(591),G1H2(342)])
call HGT_OLR(G2H2(728),1,1,2)
call HGT_invQ_OLR(G2H2(728),2,5,2)
call HGT_OLR(G2H2(728),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(728),[G2H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(481),[G2H2(413),G1H2(125),G1H2(97)])
call HGT_OLR(G2H2(416),1,1,2)
call HGT_invQ_OLR(G2H2(416),2,5,2)
call HGT_OLR(G2H2(416),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(416),[G2H2(481)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(729),[G2H2(652),G2H2(420),G1H2(240),G1H2(239) &
    ,G1H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G1H2(616),G1H2(611),G1H2(216)])
call HGT_lower_alpha_OLR(G2H2(729),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(729),2,5,2)
call HGT_lower_alpha_OLR(G2H2(729),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(729),[G2H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(485),[G2H2(421),G1H2(373),G1H2(257)])
call HGT_lower_alpha_OLR(G2H2(424),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(424),2,5,2)
call HGT_lower_alpha_OLR(G2H2(424),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(424),[G2H2(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(754),[G2H2(464),G2H2(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(355),[G1H2(300)])
call HGT_OLR(G2H2(754),1,1,2)
call HGT_invQ_OLR(G2H2(754),2,5,2)
call HGT_OLR(G2H2(754),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(754),[G2H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(755),[G2H2(468),G2H2(456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(324)])
call HGT_OLR(G2H2(755),1,1,2)
call HGT_invQ_OLR(G2H2(755),2,5,2)
call HGT_OLR(G2H2(755),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(755),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(756),[G2H2(472),G2H2(460),G1H2(194),G1H2(24),G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(350)])
call HGT_lower_alpha_OLR(G2H2(756),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(756),2,5,2)
call HGT_lower_alpha_OLR(G2H2(756),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(756),[G2H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(725),[G2H2(600),G2H2(476)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(374),[G1H2(576),G1H2(571),G1H2(323)])
call HGT_OLR(G2H2(725),1,1,2)
call HGT_invQ_OLR(G2H2(725),2,5,2)
call HGT_OLR(G2H2(725),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(725),[G2H2(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(724),[G2H2(596),G2H2(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(566),G1H2(561),G1H2(155)])
call HGT_OLR(G2H2(724),1,1,2)
call HGT_invQ_OLR(G2H2(724),2,5,2)
call HGT_OLR(G2H2(724),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(724),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(726),[G2H2(604),G2H2(484),G1H2(32),G1H2(230),G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G1H2(586),G1H2(581),G1H2(337)])
call HGT_lower_alpha_OLR(G2H2(726),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(726),2,5,2)
call HGT_lower_alpha_OLR(G2H2(726),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(726),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(700),[G2H2(608),G2H2(488)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(516),G1H2(346),G1H2(383)])
call HGT_OLR(G2H2(700),1,1,2)
call HGT_invQ_OLR(G2H2(700),2,5,2)
call HGT_OLR(G2H2(700),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(700),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(489),[G1H2(165)])
call HGT_OLR(G2H2(492),1,1,2)
call HGT_invQ_OLR(G2H2(492),2,5,2)
call HGT_OLR(G2H2(492),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(492),[G2H2(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(701),[G2H2(612),G2H2(496)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(358),[G1H2(521),G1H2(361),G1H2(63)])
call HGT_OLR(G2H2(701),1,1,2)
call HGT_invQ_OLR(G2H2(701),2,5,2)
call HGT_OLR(G2H2(701),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(701),[G2H2(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(497),[G1H2(76)])
call HGT_OLR(G2H2(500),1,1,2)
call HGT_invQ_OLR(G2H2(500),2,5,2)
call HGT_OLR(G2H2(500),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(500),[G2H2(497)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(702),[G2H2(616),G2H2(504),G1H2(249),G1H2(244),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G1H2(526),G1H2(372),G1H2(115)])
call HGT_lower_alpha_OLR(G2H2(702),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(702),2,5,2)
call HGT_lower_alpha_OLR(G2H2(702),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(702),[G2H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(505),[G1H2(332)])
call HGT_lower_alpha_OLR(G2H2(508),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(508),2,5,2)
call HGT_lower_alpha_OLR(G2H2(508),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(508),[G2H2(505)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(739),[G2H2(524),G2H2(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(363),[G1H2(491),G1H2(486),G1H2(400)])
call HGT_OLR(G2H2(739),1,1,2)
call HGT_invQ_OLR(G2H2(739),2,5,2)
call HGT_OLR(G2H2(739),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(739),[G2H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(740),[G2H2(532),G2H2(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(501),G1H2(496),G1H2(374)])
call HGT_OLR(G2H2(740),1,1,2)
call HGT_invQ_OLR(G2H2(740),2,5,2)
call HGT_OLR(G2H2(740),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(740),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(741),[G2H2(540),G2H2(520),G1H2(210),G1H2(209) &
    ,G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(511),G1H2(506),G1H2(424)])
call HGT_lower_alpha_OLR(G2H2(741),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(741),2,5,2)
call HGT_lower_alpha_OLR(G2H2(741),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(741),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(712),[G2H2(572),G2H2(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(476),G1H2(36),G1H2(283)])
call HGT_OLR(G2H2(712),1,1,2)
call HGT_invQ_OLR(G2H2(712),2,5,2)
call HGT_OLR(G2H2(712),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(712),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(549),[G1H2(235)])
call HGT_OLR(G2H2(552),1,1,2)
call HGT_invQ_OLR(G2H2(552),2,5,2)
call HGT_OLR(G2H2(552),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(552),[G2H2(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(713),[G2H2(580),G2H2(556)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G1H2(471),G1H2(422),G1H2(37)])
call HGT_OLR(G2H2(713),1,1,2)
call HGT_invQ_OLR(G2H2(713),2,5,2)
call HGT_OLR(G2H2(713),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(713),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(557),[G1H2(261)])
call HGT_OLR(G2H2(560),1,1,2)
call HGT_invQ_OLR(G2H2(560),2,5,2)
call HGT_OLR(G2H2(560),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(560),[G2H2(557)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(714),[G2H2(588),G2H2(564),G1H2(224),G1H2(30),G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(354),[G1H2(481),G1H2(38),G1H2(45)])
call HGT_lower_alpha_OLR(G2H2(714),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(714),2,5,2)
call HGT_lower_alpha_OLR(G2H2(714),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(714),[G2H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(565),[G1H2(285)])
call HGT_lower_alpha_OLR(G2H2(568),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(568),2,5,2)
call HGT_lower_alpha_OLR(G2H2(568),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(568),[G2H2(565)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(379),[G1H2(181)])
call HGT_OLR(G2H2(632),1,1,2)
call HGT_invQ_OLR(G2H2(632),2,5,2)
call HGT_OLR(G2H2(632),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(632),[G2H2(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(316)])
call HGT_OLR(G2H2(636),1,1,2)
call HGT_invQ_OLR(G2H2(636),2,5,2)
call HGT_OLR(G2H2(636),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(636),[G2H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(86)])
call HGT_lower_alpha_OLR(G2H2(640),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(640),2,5,2)
call HGT_lower_alpha_OLR(G2H2(640),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(640),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(441),G1H2(396),G1H2(136)])
call HGT_OLR(G2H2(656),1,1,2)
call HGT_invQ_OLR(G2H2(656),2,5,2)
call HGT_OLR(G2H2(656),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(656),[G2H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(446),G1H2(385),G1H2(162)])
call HGT_OLR(G2H2(660),1,1,2)
call HGT_invQ_OLR(G2H2(660),2,5,2)
call HGT_OLR(G2H2(660),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(660),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(366),[G1H2(451),G1H2(411),G1H2(186)])
call HGT_lower_alpha_OLR(G2H2(664),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(664),2,5,2)
call HGT_lower_alpha_OLR(G2H2(664),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(664),[G2H2(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(536),G1H2(531),G1H2(231)])
call HGT_OLR(G2H2(668),1,1,2)
call HGT_invQ_OLR(G2H2(668),2,5,2)
call HGT_OLR(G2H2(668),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(668),[G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(546),G1H2(541),G1H2(255)])
call HGT_OLR(G2H2(672),1,1,2)
call HGT_invQ_OLR(G2H2(672),2,5,2)
call HGT_OLR(G2H2(672),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(672),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(387),[G1H2(556),G1H2(551),G1H2(281)])
call HGT_lower_alpha_OLR(G2H2(676),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(676),2,5,2)
call HGT_lower_alpha_OLR(G2H2(676),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(676),[G2H2(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(352),[G1H2(456),G1H2(290),G1H2(295)])
call HGT_OLR(G2H2(680),1,1,2)
call HGT_invQ_OLR(G2H2(680),2,5,2)
call HGT_OLR(G2H2(680),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(680),[G2H2(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(353),[G1H2(461),G1H2(264),G1H2(306)])
call HGT_OLR(G2H2(684),1,1,2)
call HGT_invQ_OLR(G2H2(684),2,5,2)
call HGT_OLR(G2H2(684),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(684),[G2H2(353)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G1H2(466),G1H2(436),G1H2(325)])
call HGT_lower_alpha_OLR(G2H2(688),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(688),2,5,2)
call HGT_lower_alpha_OLR(G2H2(688),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(688),[G2H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(119),G2H4(104),G1H4(128),G1H4(123),G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(124),G2H4(109),G1H4(135),G1H4(130),G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(129),G2H4(114),G1H4(141),G1H4(139),G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(149),G2H4(134),G1H4(151),G1H4(146),G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G2H4(154),G2H4(139),G1H4(157),G1H4(152),G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(159),G2H4(144),G1H4(162),G1H4(161),G1H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(68),G2H4(179),G1H4(183),G1H4(173),G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(63),G2H4(3),G1H4(188),G1H4(177),G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(73),G2H4(133),G1H4(187),G1H4(178),G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G1H4(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G1H4(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(394)])
call HGT_OLR(G2H4(99),1,1,4)
call HGT_invQ_OLR(G2H4(99),2,5,4)
call HGT_OLR(G2H4(99),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(9)])
call HGT_OLR(G2H4(100),1,1,4)
call HGT_invQ_OLR(G2H4(100),2,5,4)
call HGT_OLR(G2H4(100),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(5)])
call HGT_lower_alpha_OLR(G2H4(65),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(65),2,5,4)
call HGT_lower_alpha_OLR(G2H4(65),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G1H4(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(73)])
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(20)])
call HGT_OLR(G2H4(79),1,1,4)
call HGT_invQ_OLR(G2H4(79),2,5,4)
call HGT_OLR(G2H4(79),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G2H4(19)])
call HGT_lower_alpha_OLR(G2H4(7),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(7),2,5,4)
call HGT_lower_alpha_OLR(G2H4(7),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(89),[G2H4(42),G2H4(12),G1H4(250),G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(85),G2H4(75),G1H4(153),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G2H4(69),G2H4(27),G1H4(193),G1H4(192),G1H4(189) &
    ,G1H4(190),G1H4(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G1H4(335)])
call HGT_OLR(G2H4(70),1,1,4)
call HGT_invQ_OLR(G2H4(70),2,5,4)
call HGT_OLR(G2H4(70),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(141),[G1H4(169)])
call HGT_OLR(G2H4(57),1,1,4)
call HGT_invQ_OLR(G2H4(57),2,5,4)
call HGT_OLR(G2H4(57),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G1H4(282)])
call HGT_lower_alpha_OLR(G2H4(71),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(71),2,5,4)
call HGT_lower_alpha_OLR(G2H4(71),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(117),G2H4(67),G1H4(362),G1H4(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(108),G2H4(82),G1H4(345),G1H4(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(127),G2H4(97),G1H4(200),G1H4(204),G1H4(199) &
    ,G1H4(382),G1H4(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(155),[G1H4(334)])
call HGT_OLR(G2H4(137),1,1,4)
call HGT_invQ_OLR(G2H4(137),2,5,4)
call HGT_OLR(G2H4(137),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(137),[G2H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(156),[G1H4(361)])
call HGT_OLR(G2H4(138),1,1,4)
call HGT_invQ_OLR(G2H4(138),2,5,4)
call HGT_OLR(G2H4(138),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(138),[G2H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(160),[G1H4(378)])
call HGT_lower_alpha_OLR(G2H4(142),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(142),2,5,4)
call HGT_lower_alpha_OLR(G2H4(142),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(177),G2H4(147),G1H4(506),G1H4(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(168),G2H4(153),G1H4(489),G1H4(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G2H4(24),G2H4(162),G1H4(209),G1H4(208),G1H4(203) &
    ,G1H4(526),G1H4(463)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(170),[G1H4(479)])
call HGT_OLR(G2H4(26),1,1,4)
call HGT_invQ_OLR(G2H4(26),2,5,4)
call HGT_OLR(G2H4(26),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(171),[G1H4(505)])
call HGT_OLR(G2H4(29),1,1,4)
call HGT_invQ_OLR(G2H4(29),2,5,4)
call HGT_OLR(G2H4(29),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(175),[G1H4(522)])
call HGT_lower_alpha_OLR(G2H4(30),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(30),2,5,4)
call HGT_lower_alpha_OLR(G2H4(30),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G1H4(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G1H4(499)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(125),[G1H4(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(126),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G1H4(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(146),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(150),[G1H4(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(151),[G1H4(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(161),[G1H4(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(165),[G1H4(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(166),[G1H4(462)])
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(440),23,ex4(:),G3tensor(163),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(121),23,ex4(:),G3tensor(164),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(432),23,ex4(:),8,G3tensor(165),m3h2x1(:,729),heltab2x2(:,:,729))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(438),23,ex4(:),8,G3tensor(166),m3h2x1(:,730),heltab2x2(:,:,730))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(448),23,ex4(:),8,G3tensor(167),m3h2x1(:,731),heltab2x2(:,:,731))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(176),23,ex4(:),8,G3tensor(168),m3h2x1(:,732),heltab2x2(:,:,732))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(536),23,ex4(:),8,G3tensor(169),m3h2x1(:,733),heltab2x2(:,:,733))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(528),23,ex4(:),G3tensor(170),m3h2x1(:,734),heltab2x2(:,:,734))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(544),23,ex4(:),8,G3tensor(171),m3h2x1(:,735),heltab2x2(:,:,735))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(584),27,ex3(:),4,G3tensor(172),m3h2x1(:,736),heltab2x2(:,:,736))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(746),27,ex3(:),4,G3tensor(173),m3h2x1(:,737),heltab2x2(:,:,737))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(576),27,ex3(:),G3tensor(174),m3h2x1(:,738),heltab2x2(:,:,738))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(749),27,ex3(:),G3tensor(175),m3h2x1(:,739),heltab2x2(:,:,739))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(592),27,ex3(:),4,G3tensor(176),m3h2x1(:,740),heltab2x2(:,:,740))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(752),27,ex3(:),4,G3tensor(177),m3h2x1(:,741),heltab2x2(:,:,741))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(395),23,ex4(:),G3tensor(178),m3h2x1(:,742),heltab2x2(:,:,742))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(38),23,ex4(:),8,G3tensor(179),m3h2x1(:,743),heltab2x2(:,:,743))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(351),23,ex4(:),8,G3tensor(180),m3h2x1(:,744),heltab2x2(:,:,744))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(398),27,ex3(:),G3tensor(181),m3h2x1(:,745),heltab2x2(:,:,745))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(43),27,ex3(:),4,G3tensor(182),m3h2x1(:,746),heltab2x2(:,:,746))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(168),27,ex3(:),4,G3tensor(183),m3h2x1(:,747),heltab2x2(:,:,747))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(48),29,ex2(:),G3tensor(184),m3h2x1(:,748),heltab2x2(:,:,748))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(764),29,ex2(:),G3tensor(185),m3h2x1(:,749),heltab2x2(:,:,749))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(166),29,ex2(:),2,G3tensor(186),m3h2x1(:,750),heltab2x2(:,:,750))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(761),29,ex2(:),2,G3tensor(187),m3h2x1(:,751),heltab2x2(:,:,751))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(46),29,ex2(:),2,G3tensor(188),m3h2x1(:,752),heltab2x2(:,:,752))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(767),29,ex2(:),2,G3tensor(189),m3h2x1(:,753),heltab2x2(:,:,753))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(743),30,ex1(:),G3tensor(190),m3h2x1(:,754),heltab2x2(:,:,754))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(360),29,ex2(:),G3tensor(191),m3h2x1(:,755),heltab2x2(:,:,755))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(742),30,ex1(:),1,G3tensor(192),m3h2x1(:,756),heltab2x2(:,:,756))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(368),29,ex2(:),2,G3tensor(193),m3h2x1(:,757),heltab2x2(:,:,757))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(744),30,ex1(:),1,G3tensor(194),m3h2x1(:,758),heltab2x2(:,:,758))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(376),29,ex2(:),2,G3tensor(195),m3h2x1(:,759),heltab2x2(:,:,759))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(757),30,ex1(:),1,G3tensor(196),m3h2x1(:,760),heltab2x2(:,:,760))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(384),27,ex3(:),4,G3tensor(197),m3h2x1(:,761),heltab2x2(:,:,761))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(758),30,ex1(:),G3tensor(198),m3h2x1(:,762),heltab2x2(:,:,762))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(392),27,ex3(:),G3tensor(199),m3h2x1(:,763),heltab2x2(:,:,763))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(759),30,ex1(:),1,G3tensor(200),m3h2x1(:,764),heltab2x2(:,:,764))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(400),27,ex3(:),4,G3tensor(201),m3h2x1(:,765),heltab2x2(:,:,765))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(727),29,ex2(:),2,G3tensor(202),m3h2x1(:,766),heltab2x2(:,:,766))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(408),30,ex1(:),1,G3tensor(203),m3h2x1(:,767),heltab2x2(:,:,767))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(728),29,ex2(:),G3tensor(204),m3h2x1(:,768),heltab2x2(:,:,768))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(416),30,ex1(:),G3tensor(205),m3h2x1(:,769),heltab2x2(:,:,769))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(729),29,ex2(:),2,G3tensor(206),m3h2x1(:,770),heltab2x2(:,:,770))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(424),30,ex1(:),1,G3tensor(207),m3h2x1(:,771),heltab2x2(:,:,771))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(754),29,ex2(:),G3tensor(208),m3h2x1(:,772),heltab2x2(:,:,772))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(755),29,ex2(:),2,G3tensor(209),m3h2x1(:,773),heltab2x2(:,:,773))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(756),29,ex2(:),2,G3tensor(210),m3h2x1(:,774),heltab2x2(:,:,774))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(725),27,ex3(:),4,G3tensor(211),m3h2x1(:,775),heltab2x2(:,:,775))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(724),27,ex3(:),G3tensor(212),m3h2x1(:,776),heltab2x2(:,:,776))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(726),27,ex3(:),4,G3tensor(213),m3h2x1(:,777),heltab2x2(:,:,777))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(700),23,ex4(:),G3tensor(214),m3h2x1(:,778),heltab2x2(:,:,778))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(492),30,ex1(:),G3tensor(215),m3h2x1(:,779),heltab2x2(:,:,779))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(701),23,ex4(:),8,G3tensor(216),m3h2x1(:,780),heltab2x2(:,:,780))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(500),30,ex1(:),1,G3tensor(217),m3h2x1(:,781),heltab2x2(:,:,781))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(702),23,ex4(:),8,G3tensor(218),m3h2x1(:,782),heltab2x2(:,:,782))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(508),30,ex1(:),1,G3tensor(219),m3h2x1(:,783),heltab2x2(:,:,783))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(739),27,ex3(:),G3tensor(220),m3h2x1(:,784),heltab2x2(:,:,784))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(740),27,ex3(:),4,G3tensor(221),m3h2x1(:,785),heltab2x2(:,:,785))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(741),27,ex3(:),4,G3tensor(222),m3h2x1(:,786),heltab2x2(:,:,786))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(712),23,ex4(:),G3tensor(223),m3h2x1(:,787),heltab2x2(:,:,787))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(552),29,ex2(:),G3tensor(224),m3h2x1(:,788),heltab2x2(:,:,788))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(713),23,ex4(:),8,G3tensor(225),m3h2x1(:,789),heltab2x2(:,:,789))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(560),29,ex2(:),2,G3tensor(226),m3h2x1(:,790),heltab2x2(:,:,790))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(714),23,ex4(:),8,G3tensor(227),m3h2x1(:,791),heltab2x2(:,:,791))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(568),29,ex2(:),2,G3tensor(228),m3h2x1(:,792),heltab2x2(:,:,792))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(632),30,ex1(:),G3tensor(229),m3h2x1(:,793),heltab2x2(:,:,793))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(636),30,ex1(:),1,G3tensor(230),m3h2x1(:,794),heltab2x2(:,:,794))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(640),30,ex1(:),1,G3tensor(231),m3h2x1(:,795),heltab2x2(:,:,795))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(656),23,ex4(:),G3tensor(232),m3h2x1(:,796),heltab2x2(:,:,796))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(660),23,ex4(:),8,G3tensor(233),m3h2x1(:,797),heltab2x2(:,:,797))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(664),23,ex4(:),8,G3tensor(234),m3h2x1(:,798),heltab2x2(:,:,798))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(668),29,ex2(:),G3tensor(235),m3h2x1(:,799),heltab2x2(:,:,799))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(672),29,ex2(:),2,G3tensor(236),m3h2x1(:,800),heltab2x2(:,:,800))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(676),29,ex2(:),2,G3tensor(237),m3h2x1(:,801),heltab2x2(:,:,801))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(680),27,ex3(:),G3tensor(238),m3h2x1(:,802),heltab2x2(:,:,802))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(684),27,ex3(:),4,G3tensor(239),m3h2x1(:,803),heltab2x2(:,:,803))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(688),27,ex3(:),4,G3tensor(240),m3h2x1(:,804),heltab2x2(:,:,804))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(91),ex4(:),ex3(:),G2tensor(311),m4h2x2x1(:,49),heltab3x4(:,:,49))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(18),ex3(:),ex4(:),G2tensor(310),m4h2x2x1(:,50),heltab3x4(:,:,50))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(94),ex4(:),ex3(:),G2tensor(3),m4h2x2x1(:,51),heltab3x4(:,:,51))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(28),ex4(:),ex2(:),G2tensor(2),m4h2x2x1(:,52),heltab3x4(:,:,52))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(93),ex2(:),ex4(:),G2tensor(1),m4h2x2x1(:,53),heltab3x4(:,:,53))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(98),ex4(:),ex2(:),G2tensor(317),m4h2x2x1(:,54),heltab3x4(:,:,54))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(164),ex3(:),ex2(:),G2tensor(316),m4h2x2x1(:,55),heltab3x4(:,:,55))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(169),ex2(:),ex3(:),G2tensor(12),m4h2x2x1(:,56),heltab3x4(:,:,56))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(174),ex3(:),ex2(:),G2tensor(11),m4h2x2x1(:,57),heltab3x4(:,:,57))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(38),ex4(:),ex1(:),G2tensor(10),m4h2x2x1(:,58),heltab3x4(:,:,58))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(43),ex1(:),ex4(:),G2tensor(6),m4h2x2x1(:,59),heltab3x4(:,:,59))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(11),ex4(:),ex1(:),G2tensor(5),m4h2x2x1(:,60),heltab3x4(:,:,60))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(33),ex3(:),ex1(:),G2tensor(4),m4h2x2x1(:,61),heltab3x4(:,:,61))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(103),ex1(:),ex3(:),G2tensor(305),m4h2x2x1(:,62),heltab3x4(:,:,62))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(83),ex3(:),ex1(:),G2tensor(304),m4h2x2x1(:,63),heltab3x4(:,:,63))
call HGT_OLR(G2H4(14),1,1,4)
call HGT_invQ_OLR(G2H4(14),2,5,4)
call HGT_OLR(G2H4(14),6,15,4)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(14),28,wf4(:,1),3,G3tensor(241),m3h4x1(:,121),heltab2x4(:,:,1057))
call HGT_OLR(G2H4(78),1,1,4)
call HGT_invQ_OLR(G2H4(78),2,5,4)
call HGT_OLR(G2H4(78),6,15,4)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(78),28,wf4(:,1),G3tensor(242),m3h4x1(:,122),heltab2x4(:,:,1058))
call HGT_lower_alpha_OLR(G2H4(53),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(53),2,5,4)
call HGT_lower_alpha_OLR(G2H4(53),6,15,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(53),28,wf4(:,1),3,G3tensor(243),m3h4x1(:,123),heltab2x4(:,:,1059))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(88),26,wf4(:,2),G3tensor(244),m3h4x1(:,124),heltab2x4(:,:,1060))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(96),26,wf4(:,2),5,G3tensor(245),m3h4x1(:,125),heltab2x4(:,:,1061))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(4),26,wf4(:,2),5,G3tensor(246),m3h4x1(:,126),heltab2x4(:,:,1062))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(99),26,wf4(:,2),5,G3tensor(247),m3h4x1(:,127),heltab2x4(:,:,1063))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(100),26,wf4(:,2),G3tensor(248),m3h4x1(:,128),heltab2x4(:,:,1064))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(65),26,wf4(:,2),5,G3tensor(249),m3h4x1(:,129),heltab2x4(:,:,1065))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(6),25,wf4(:,5),G3tensor(250),m3h4x1(:,130),heltab2x4(:,:,1066))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(90),25,wf4(:,5),6,G3tensor(251),m3h4x1(:,131),heltab2x4(:,:,1067))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(16),25,wf4(:,5),6,G3tensor(252),m3h4x1(:,132),heltab2x4(:,:,1068))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(2),25,wf4(:,5),6,G3tensor(253),m3h4x1(:,133),heltab2x4(:,:,1069))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(79),25,wf4(:,5),G3tensor(254),m3h4x1(:,134),heltab2x4(:,:,1070))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(7),25,wf4(:,5),6,G3tensor(255),m3h4x1(:,135),heltab2x4(:,:,1071))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(89),22,wf4(:,3),G3tensor(256),m3h4x1(:,136),heltab2x4(:,:,1072))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(10),22,wf4(:,3),9,G3tensor(257),m3h4x1(:,137),heltab2x4(:,:,1073))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(66),22,wf4(:,3),9,G3tensor(258),m3h4x1(:,138),heltab2x4(:,:,1074))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(70),22,wf4(:,3),9,G3tensor(259),m3h4x1(:,139),heltab2x4(:,:,1075))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(57),22,wf4(:,3),G3tensor(260),m3h4x1(:,140),heltab2x4(:,:,1076))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(71),22,wf4(:,3),9,G3tensor(261),m3h4x1(:,141),heltab2x4(:,:,1077))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(95),21,wf4(:,6),G3tensor(262),m3h4x1(:,142),heltab2x4(:,:,1078))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(64),21,wf4(:,6),10,G3tensor(263),m3h4x1(:,143),heltab2x4(:,:,1079))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(1),21,wf4(:,6),10,G3tensor(264),m3h4x1(:,144),heltab2x4(:,:,1080))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(137),21,wf4(:,6),10,G3tensor(265),m3h4x1(:,145),heltab2x4(:,:,1081))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(138),21,wf4(:,6),G3tensor(266),m3h4x1(:,146),heltab2x4(:,:,1082))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(142),21,wf4(:,6),10,G3tensor(267),m3h4x1(:,147),heltab2x4(:,:,1083))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(48),19,wf4(:,8),G3tensor(268),m3h4x1(:,148),heltab2x4(:,:,1084))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(15),19,wf4(:,8),12,G3tensor(269),m3h4x1(:,149),heltab2x4(:,:,1085))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(58),19,wf4(:,8),12,G3tensor(270),m3h4x1(:,150),heltab2x4(:,:,1086))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(26),19,wf4(:,8),12,G3tensor(271),m3h4x1(:,151),heltab2x4(:,:,1087))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(29),19,wf4(:,8),G3tensor(272),m3h4x1(:,152),heltab2x4(:,:,1088))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(30),19,wf4(:,8),12,G3tensor(273),m3h4x1(:,153),heltab2x4(:,:,1089))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(116),26,wf4(:,2),G3tensor(274),m3h4x1(:,154),heltab2x4(:,:,1090))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(120),26,wf4(:,2),5,G3tensor(275),m3h4x1(:,155),heltab2x4(:,:,1091))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(121),26,wf4(:,2),5,G3tensor(276),m3h4x1(:,156),heltab2x4(:,:,1092))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(125),25,wf4(:,5),G3tensor(277),m3h4x1(:,157),heltab2x4(:,:,1093))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(126),25,wf4(:,5),6,G3tensor(278),m3h4x1(:,158),heltab2x4(:,:,1094))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(130),25,wf4(:,5),6,G3tensor(279),m3h4x1(:,159),heltab2x4(:,:,1095))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(131),22,wf4(:,3),G3tensor(280),m3h4x1(:,160),heltab2x4(:,:,1096))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(135),22,wf4(:,3),9,G3tensor(281),m3h4x1(:,161),heltab2x4(:,:,1097))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(136),22,wf4(:,3),9,G3tensor(282),m3h4x1(:,162),heltab2x4(:,:,1098))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(146),21,wf4(:,6),G3tensor(283),m3h4x1(:,163),heltab2x4(:,:,1099))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(150),21,wf4(:,6),10,G3tensor(284),m3h4x1(:,164),heltab2x4(:,:,1100))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(151),21,wf4(:,6),10,G3tensor(285),m3h4x1(:,165),heltab2x4(:,:,1101))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(161),19,wf4(:,8),G3tensor(286),m3h4x1(:,166),heltab2x4(:,:,1102))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(165),19,wf4(:,8),12,G3tensor(287),m3h4x1(:,167),heltab2x4(:,:,1103))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(166),19,wf4(:,8),12,G3tensor(288),m3h4x1(:,168),heltab2x4(:,:,1104))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(31),ex4(:),ex3(:),G2tensor(9),m4h2x2x1(:,64),heltab3x4(:,:,64))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(34),ex3(:),ex4(:),G2tensor(8),m4h2x2x1(:,65),heltab3x4(:,:,65))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(35),ex4(:),ex3(:),G2tensor(7),m4h2x2x1(:,66),heltab3x4(:,:,66))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(36),ex4(:),ex3(:),G2tensor(314),m4h2x2x1(:,67),heltab3x4(:,:,67))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(39),ex3(:),ex4(:),G2tensor(313),m4h2x2x1(:,68),heltab3x4(:,:,68))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(40),ex4(:),ex3(:),G2tensor(18),m4h2x2x1(:,69),heltab3x4(:,:,69))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(41),ex4(:),ex2(:),G2tensor(17),m4h2x2x1(:,70),heltab3x4(:,:,70))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(44),ex2(:),ex4(:),G2tensor(16),m4h2x2x1(:,71),heltab3x4(:,:,71))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(45),ex4(:),ex2(:),G2tensor(15),m4h2x2x1(:,72),heltab3x4(:,:,72))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(46),ex4(:),ex2(:),G2tensor(14),m4h2x2x1(:,73),heltab3x4(:,:,73))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(49),ex2(:),ex4(:),G2tensor(13),m4h2x2x1(:,74),heltab3x4(:,:,74))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(50),ex4(:),ex2(:),G2tensor(302),m4h2x2x1(:,75),heltab3x4(:,:,75))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(51),ex3(:),ex2(:),G2tensor(301),m4h2x2x1(:,76),heltab3x4(:,:,76))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(54),ex2(:),ex3(:),G2tensor(21),m4h2x2x1(:,77),heltab3x4(:,:,77))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(55),ex3(:),ex2(:),G2tensor(20),m4h2x2x1(:,78),heltab3x4(:,:,78))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(56),ex4(:),ex1(:),G2tensor(19),m4h2x2x1(:,79),heltab3x4(:,:,79))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(59),ex1(:),ex4(:),G2tensor(296),m4h2x2x1(:,80),heltab3x4(:,:,80))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(60),ex4(:),ex1(:),G2tensor(295),m4h2x2x1(:,81),heltab3x4(:,:,81))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(101),ex4(:),ex1(:),G2tensor(24),m4h2x2x1(:,82),heltab3x4(:,:,82))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(105),ex1(:),ex4(:),G2tensor(23),m4h2x2x1(:,83),heltab3x4(:,:,83))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(106),ex4(:),ex1(:),G2tensor(22),m4h2x2x1(:,84),heltab3x4(:,:,84))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(110),ex3(:),ex1(:),G2tensor(308),m4h2x2x1(:,85),heltab3x4(:,:,85))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(111),ex1(:),ex3(:),G2tensor(307),m4h2x2x1(:,86),heltab3x4(:,:,86))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(115),ex3(:),ex1(:),G2tensor(30),m4h2x2x1(:,87),heltab3x4(:,:,87))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(176),ex3(:),ex2(:),G2tensor(29),m4h2x2x1(:,88),heltab3x4(:,:,88))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(180),ex2(:),ex3(:),G2tensor(28),m4h2x2x1(:,89),heltab3x4(:,:,89))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(123),ex3(:),ex2(:),G2tensor(27),m4h2x2x1(:,90),heltab3x4(:,:,90))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(128),ex3(:),ex1(:),G2tensor(26),m4h2x2x1(:,91),heltab3x4(:,:,91))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(8),ex1(:),ex3(:),G2tensor(25),m4h2x2x1(:,92),heltab3x4(:,:,92))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(13),ex3(:),ex1(:),G2tensor(299),m4h2x2x1(:,93),heltab3x4(:,:,93))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(1),ex4(:),wf4(:,1),G2tensor(298),m4h2x4x1(:,1),heltab3x8(:,:,55))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(2),wf4(:,1),ex4(:),G2tensor(36),m4h4x2x1(:,1),heltab3x8(:,:,56))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(3),ex4(:),wf4(:,1),G2tensor(35),m4h2x4x1(:,2),heltab3x8(:,:,57))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(4),ex4(:),wf4(:,2),G2tensor(34),m4h2x4x1(:,3),heltab3x8(:,:,58))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(5),wf4(:,2),ex4(:),G2tensor(33),m4h4x2x1(:,2),heltab3x8(:,:,59))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(6),ex4(:),wf4(:,2),G2tensor(32),m4h2x4x1(:,4),heltab3x8(:,:,60))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(7),ex4(:),wf4(:,5),G2tensor(31),m4h2x4x1(:,5),heltab3x8(:,:,61))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(8),wf4(:,5),ex4(:),G2tensor(325),m4h4x2x1(:,3),heltab3x8(:,:,62))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(9),ex4(:),wf4(:,5),G2tensor(319),m4h2x4x1(:,6),heltab3x8(:,:,63))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(10),ex3(:),wf4(:,3),G2tensor(46),m4h2x4x1(:,7),heltab3x8(:,:,64))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(11),wf4(:,3),ex3(:),G2tensor(42),m4h4x2x1(:,4),heltab3x8(:,:,65))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(12),ex3(:),wf4(:,3),G2tensor(38),m4h2x4x1(:,8),heltab3x8(:,:,66))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(13),ex3(:),wf4(:,6),G2tensor(673),m4h2x4x1(:,9),heltab3x8(:,:,67))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(14),wf4(:,6),ex3(:),G2tensor(670),m4h4x2x1(:,5),heltab3x8(:,:,68))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(15),ex3(:),wf4(:,6),G2tensor(269),m4h2x4x1(:,10),heltab3x8(:,:,69))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(16),ex2(:),wf4(:,3),G2tensor(267),m4h2x4x1(:,11),heltab3x8(:,:,70))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(17),wf4(:,3),ex2(:),G2tensor(265),m4h4x2x1(:,6),heltab3x8(:,:,71))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(18),ex2(:),wf4(:,3),G2tensor(47),m4h2x4x1(:,12),heltab3x8(:,:,72))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(19),ex2(:),wf4(:,8),G2tensor(43),m4h2x4x1(:,13),heltab3x8(:,:,73))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(20),wf4(:,8),ex2(:),G2tensor(39),m4h4x2x1(:,7),heltab3x8(:,:,74))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(21),ex2(:),wf4(:,8),G2tensor(343),m4h2x4x1(:,14),heltab3x8(:,:,75))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(22),17,wf8(:,10),14,G3tensor(289),m3h8x1(:,1),heltab2x8(:,:,592))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(23),17,wf8(:,11),14,G3tensor(290),m3h8x1(:,2),heltab2x8(:,:,593))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(24),17,wf8(:,12),14,G3tensor(291),m3h8x1(:,3),heltab2x8(:,:,594))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(25),17,wf8(:,10),G3tensor(292),m3h8x1(:,4),heltab2x8(:,:,595))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(26),17,wf8(:,11),G3tensor(293),m3h8x1(:,5),heltab2x8(:,:,596))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(27),17,wf8(:,12),G3tensor(294),m3h8x1(:,6),heltab2x8(:,:,597))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(28),17,wf8(:,10),14,G3tensor(295),m3h8x1(:,7),heltab2x8(:,:,598))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(29),17,wf8(:,11),14,G3tensor(296),m3h8x1(:,8),heltab2x8(:,:,599))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(30),17,wf8(:,12),14,G3tensor(297),m3h8x1(:,9),heltab2x8(:,:,600))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(31),ex1(:),wf4(:,6),G2tensor(337),m4h2x4x1(:,15),heltab3x8(:,:,76))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(32),wf4(:,6),ex1(:),G2tensor(58),m4h4x2x1(:,8),heltab3x8(:,:,77))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(33),ex1(:),wf4(:,6),G2tensor(54),m4h2x4x1(:,16),heltab3x8(:,:,78))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(34),ex1(:),wf4(:,8),G2tensor(50),m4h2x4x1(:,17),heltab3x8(:,:,79))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H8(35),wf4(:,8),ex1(:),G2tensor(691),m4h4x2x1(:,9),heltab3x8(:,:,80))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H8(36),ex1(:),wf4(:,8),G2tensor(688),m4h2x4x1(:,18),heltab3x8(:,:,81))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(37),18,wf8(:,19),13,G3tensor(298),m3h8x1(:,10),heltab2x8(:,:,601))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(38),18,wf8(:,20),13,G3tensor(299),m3h8x1(:,11),heltab2x8(:,:,602))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(39),18,wf8(:,21),13,G3tensor(300),m3h8x1(:,12),heltab2x8(:,:,603))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(40),18,wf8(:,19),G3tensor(301),m3h8x1(:,13),heltab2x8(:,:,604))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(41),18,wf8(:,20),G3tensor(302),m3h8x1(:,14),heltab2x8(:,:,605))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(42),18,wf8(:,21),G3tensor(303),m3h8x1(:,15),heltab2x8(:,:,606))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(43),18,wf8(:,19),13,G3tensor(304),m3h8x1(:,16),heltab2x8(:,:,607))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(44),18,wf8(:,20),13,G3tensor(305),m3h8x1(:,17),heltab2x8(:,:,608))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(45),18,wf8(:,21),13,G3tensor(306),m3h8x1(:,18),heltab2x8(:,:,609))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(46),20,wf8(:,25),11,G3tensor(307),m3h8x1(:,19),heltab2x8(:,:,610))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(47),20,wf8(:,26),11,G3tensor(308),m3h8x1(:,20),heltab2x8(:,:,611))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(48),20,wf8(:,27),11,G3tensor(309),m3h8x1(:,21),heltab2x8(:,:,612))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(49),20,wf8(:,25),G3tensor(310),m3h8x1(:,22),heltab2x8(:,:,613))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(50),20,wf8(:,26),G3tensor(311),m3h8x1(:,23),heltab2x8(:,:,614))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(51),20,wf8(:,27),G3tensor(312),m3h8x1(:,24),heltab2x8(:,:,615))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(52),20,wf8(:,25),11,G3tensor(313),m3h8x1(:,25),heltab2x8(:,:,616))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(53),20,wf8(:,26),11,G3tensor(314),m3h8x1(:,26),heltab2x8(:,:,617))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(54),20,wf8(:,27),11,G3tensor(315),m3h8x1(:,27),heltab2x8(:,:,618))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(55),20,wf8(:,32),11,G3tensor(316),m3h8x1(:,28),heltab2x8(:,:,619))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(56),20,wf8(:,32),G3tensor(317),m3h8x1(:,29),heltab2x8(:,:,620))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(57),20,wf8(:,32),11,G3tensor(318),m3h8x1(:,30),heltab2x8(:,:,621))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(58),18,wf8(:,35),13,G3tensor(319),m3h8x1(:,31),heltab2x8(:,:,622))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(59),18,wf8(:,35),G3tensor(320),m3h8x1(:,32),heltab2x8(:,:,623))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(60),18,wf8(:,35),13,G3tensor(321),m3h8x1(:,33),heltab2x8(:,:,624))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(61),17,wf8(:,113),14,G3tensor(322),m3h8x1(:,34),heltab2x8(:,:,625))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(62),17,wf8(:,113),G3tensor(323),m3h8x1(:,35),heltab2x8(:,:,626))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(63),17,wf8(:,113),14,G3tensor(324),m3h8x1(:,36),heltab2x8(:,:,627))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(64),20,wf8(:,41),11,G3tensor(325),m3h8x1(:,37),heltab2x8(:,:,628))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(65),20,wf8(:,41),G3tensor(326),m3h8x1(:,38),heltab2x8(:,:,629))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(66),20,wf8(:,41),11,G3tensor(327),m3h8x1(:,39),heltab2x8(:,:,630))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(67),18,wf8(:,40),13,G3tensor(328),m3h8x1(:,40),heltab2x8(:,:,631))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(68),18,wf8(:,40),G3tensor(329),m3h8x1(:,41),heltab2x8(:,:,632))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(69),18,wf8(:,40),13,G3tensor(330),m3h8x1(:,42),heltab2x8(:,:,633))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(70),20,wf8(:,43),11,G3tensor(331),m3h8x1(:,43),heltab2x8(:,:,634))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(71),20,wf8(:,43),G3tensor(332),m3h8x1(:,44),heltab2x8(:,:,635))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(72),20,wf8(:,43),11,G3tensor(333),m3h8x1(:,45),heltab2x8(:,:,636))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(73),17,wf8(:,117),14,G3tensor(334),m3h8x1(:,46),heltab2x8(:,:,637))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(74),17,wf8(:,117),G3tensor(335),m3h8x1(:,47),heltab2x8(:,:,638))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(75),17,wf8(:,117),14,G3tensor(336),m3h8x1(:,48),heltab2x8(:,:,639))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(76),18,wf8(:,120),13,G3tensor(337),m3h8x1(:,49),heltab2x8(:,:,640))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(77),18,wf8(:,120),G3tensor(338),m3h8x1(:,50),heltab2x8(:,:,641))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(78),18,wf8(:,120),13,G3tensor(339),m3h8x1(:,51),heltab2x8(:,:,642))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H8(79),17,wf8(:,119),14,G3tensor(340),m3h8x1(:,52),heltab2x8(:,:,643))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H8(80),17,wf8(:,119),G3tensor(341),m3h8x1(:,53),heltab2x8(:,:,644))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H8(81),17,wf8(:,119),14,G3tensor(342),m3h8x1(:,54),heltab2x8(:,:,645))
  call ol_merge_tensors(G3tensor(194),[G3tensor(192),G3tensor(190),G3tensor(9),G3tensor(6),G3tensor(3),G2tensor(677),G2tensor(674) &
    ,G2tensor(671),G2tensor(542),G2tensor(539),G2tensor(536),G2tensor(332),G2tensor(326),G2tensor(320),G2tensor(48),G2tensor(44) &
    ,G2tensor(40),G1tensor(189),G1tensor(85),G1tensor(41),G1tensor(4),G0tensor(199),G0tensor(95),G0tensor(49),G0tensor(44)])
  call ol_merge_tensors(G3tensor(200),[G3tensor(198),G3tensor(196),G3tensor(33),G3tensor(30),G3tensor(27),G3tensor(18) &
    ,G3tensor(15),G3tensor(12),G2tensor(695),G2tensor(692),G2tensor(689),G2tensor(377),G2tensor(371),G2tensor(365),G2tensor(350) &
    ,G2tensor(344),G2tensor(338),G2tensor(84),G2tensor(80),G2tensor(76),G2tensor(60),G2tensor(56),G2tensor(52),G1tensor(70) &
    ,G1tensor(46),G1tensor(29),G1tensor(22),G0tensor(74),G0tensor(65),G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G3tensor(206),[G3tensor(204),G3tensor(202),G3tensor(24),G3tensor(22),G3tensor(20),G2tensor(659) &
    ,G2tensor(656),G2tensor(653),G2tensor(569),G2tensor(566),G2tensor(563),G2tensor(362),G2tensor(359),G2tensor(356),G2tensor(72) &
    ,G2tensor(68),G2tensor(64),G1tensor(240),G1tensor(235),G1tensor(204),G1tensor(105),G1tensor(71),G1tensor(45),G0tensor(250) &
    ,G0tensor(245),G0tensor(214),G0tensor(115),G0tensor(69),G0tensor(64)])
  call ol_merge_tensors(G3tensor(210),[G3tensor(209),G3tensor(208),G3tensor(51),G3tensor(48),G3tensor(45),G3tensor(42) &
    ,G3tensor(39),G3tensor(36),G2tensor(686),G2tensor(683),G2tensor(680),G2tensor(413),G2tensor(407),G2tensor(401),G2tensor(395) &
    ,G2tensor(389),G2tensor(383),G2tensor(108),G2tensor(104),G2tensor(100),G2tensor(96),G2tensor(92),G2tensor(88),G1tensor(79) &
    ,G1tensor(74),G1tensor(15),G1tensor(17),G0tensor(89),G0tensor(84),G0tensor(79),G0tensor(45)])
  call ol_merge_tensors(G3tensor(213),[G3tensor(212),G3tensor(211),G3tensor(57),G3tensor(55),G3tensor(53),G2tensor(650) &
    ,G2tensor(647),G2tensor(644),G2tensor(524),G2tensor(521),G2tensor(518),G2tensor(425),G2tensor(422),G2tensor(419),G2tensor(120) &
    ,G2tensor(116),G2tensor(112),G1tensor(230),G1tensor(225),G1tensor(169),G1tensor(89),G1tensor(84),G1tensor(3),G0tensor(240) &
    ,G0tensor(235),G0tensor(179),G0tensor(99),G0tensor(94),G0tensor(80)])
  call ol_merge_tensors(G3tensor(218),[G3tensor(216),G3tensor(214),G3tensor(63),G3tensor(61),G3tensor(59),G2tensor(632) &
    ,G2tensor(629),G2tensor(626),G2tensor(533),G2tensor(530),G2tensor(527),G2tensor(434),G2tensor(431),G2tensor(428),G2tensor(132) &
    ,G2tensor(128),G2tensor(124),G1tensor(205),G1tensor(179),G1tensor(135),G1tensor(99),G1tensor(94),G1tensor(80),G0tensor(215) &
    ,G0tensor(189),G0tensor(145),G0tensor(109),G0tensor(104),G0tensor(90)])
  call ol_merge_tensors(G3tensor(222),[G3tensor(221),G3tensor(220),G3tensor(78),G3tensor(75),G3tensor(72),G3tensor(69) &
    ,G3tensor(67),G3tensor(65),G2tensor(668),G2tensor(665),G2tensor(662),G2tensor(458),G2tensor(452),G2tensor(446),G2tensor(443) &
    ,G2tensor(440),G2tensor(437),G2tensor(156),G2tensor(152),G2tensor(148),G2tensor(144),G2tensor(140),G2tensor(136),G1tensor(200) &
    ,G1tensor(195),G1tensor(114),G1tensor(109),G1tensor(104),G1tensor(47),G0tensor(210),G0tensor(205),G0tensor(124),G0tensor(119) &
    ,G0tensor(114),G0tensor(55)])
  call ol_merge_tensors(G3tensor(227),[G3tensor(225),G3tensor(223),G3tensor(90),G3tensor(88),G3tensor(86),G3tensor(84) &
    ,G3tensor(82),G3tensor(80),G2tensor(641),G2tensor(638),G2tensor(635),G2tensor(479),G2tensor(476),G2tensor(473),G2tensor(470) &
    ,G2tensor(467),G2tensor(464),G2tensor(180),G2tensor(176),G2tensor(172),G2tensor(168),G2tensor(164),G2tensor(160),G1tensor(190) &
    ,G1tensor(155),G1tensor(129),G1tensor(124),G1tensor(119),G1tensor(1),G0tensor(200),G0tensor(165),G0tensor(139),G0tensor(134) &
    ,G0tensor(129),G0tensor(75)])
  call ol_merge_tensors(G3tensor(243),[G3tensor(242),G3tensor(241),G3tensor(23),G3tensor(21),G3tensor(19),G3tensor(7),G3tensor(4) &
    ,G3tensor(1),G2tensor(363),G2tensor(360),G2tensor(357),G2tensor(335),G2tensor(333),G2tensor(329),G2tensor(327),G2tensor(323) &
    ,G2tensor(321),G1tensor(139),G1tensor(57),G1tensor(28),G0tensor(149),G0tensor(67),G0tensor(47)])
  call ol_merge_tensors(G3tensor(333),[G3tensor(332),G3tensor(331),G3tensor(327),G3tensor(326),G3tensor(325),G3tensor(318) &
    ,G3tensor(317),G3tensor(316),G3tensor(315),G3tensor(314),G3tensor(313),G3tensor(312),G3tensor(311),G3tensor(310),G3tensor(309) &
    ,G3tensor(308),G3tensor(307),G3tensor(156),G3tensor(155),G3tensor(154),G3tensor(150),G3tensor(149),G3tensor(148),G3tensor(8) &
    ,G3tensor(5),G3tensor(2),G2tensor(54),G2tensor(58),G2tensor(337),G2tensor(47),G2tensor(265),G2tensor(267),G2tensor(35) &
    ,G2tensor(36),G2tensor(298),G2tensor(678),G2tensor(675),G2tensor(672),G2tensor(660),G2tensor(657),G2tensor(654),G2tensor(336) &
    ,G2tensor(330),G2tensor(324),G2tensor(288),G2tensor(286),G2tensor(284),G2tensor(270),G2tensor(268),G2tensor(266),G1tensor(142) &
    ,G1tensor(64),G1tensor(16),G0tensor(152),G0tensor(72),G0tensor(52)])
  call ol_merge_tensors(G3tensor(249),[G3tensor(248),G3tensor(247),G3tensor(56),G3tensor(54),G3tensor(52),G3tensor(16) &
    ,G3tensor(13),G3tensor(10),G2tensor(299),G2tensor(25),G2tensor(26),G2tensor(426),G2tensor(423),G2tensor(420),G2tensor(353) &
    ,G2tensor(351),G2tensor(347),G2tensor(345),G2tensor(341),G2tensor(339),G1tensor(149),G1tensor(87),G1tensor(27),G0tensor(159) &
    ,G0tensor(97),G0tensor(57)])
  call ol_merge_tensors(G3tensor(339),[G3tensor(338),G3tensor(337),G3tensor(330),G3tensor(329),G3tensor(328),G3tensor(321) &
    ,G3tensor(320),G3tensor(319),G3tensor(306),G3tensor(305),G3tensor(304),G3tensor(303),G3tensor(302),G3tensor(301),G3tensor(300) &
    ,G3tensor(299),G3tensor(298),G3tensor(162),G3tensor(161),G3tensor(160),G3tensor(147),G3tensor(146),G3tensor(145),G3tensor(141) &
    ,G3tensor(140),G3tensor(139),G3tensor(32),G3tensor(29),G3tensor(26),G3tensor(17),G3tensor(14),G3tensor(11),G2tensor(688) &
    ,G2tensor(691),G2tensor(50),G2tensor(38),G2tensor(42),G2tensor(46),G2tensor(32),G2tensor(33),G2tensor(34),G2tensor(696) &
    ,G2tensor(693),G2tensor(690),G2tensor(651),G2tensor(648),G2tensor(645),G2tensor(633),G2tensor(630),G2tensor(627),G2tensor(381) &
    ,G2tensor(375),G2tensor(369),G2tensor(354),G2tensor(348),G2tensor(342),G2tensor(294),G2tensor(292),G2tensor(290),G2tensor(282) &
    ,G2tensor(280),G2tensor(278),G2tensor(258),G2tensor(256),G2tensor(254),G1tensor(167),G1tensor(152),G1tensor(102),G1tensor(92) &
    ,G1tensor(35),G0tensor(177),G0tensor(162),G0tensor(112),G0tensor(102),G0tensor(62)])
  call ol_merge_tensors(G3tensor(261),[G3tensor(260),G3tensor(259),G3tensor(62),G3tensor(60),G3tensor(58),G3tensor(31) &
    ,G3tensor(28),G3tensor(25),G2tensor(22),G2tensor(23),G2tensor(24),G2tensor(435),G2tensor(432),G2tensor(429),G2tensor(380) &
    ,G2tensor(378),G2tensor(374),G2tensor(372),G2tensor(368),G2tensor(366),G1tensor(164),G1tensor(97),G1tensor(61),G1tensor(59) &
    ,G0tensor(174),G0tensor(107),G0tensor(77),G0tensor(70)])
  call ol_merge_tensors(G3tensor(255),[G3tensor(254),G3tensor(253),G3tensor(68),G3tensor(66),G3tensor(64),G3tensor(40) &
    ,G3tensor(37),G3tensor(34),G2tensor(27),G2tensor(28),G2tensor(29),G2tensor(444),G2tensor(441),G2tensor(438),G2tensor(398) &
    ,G2tensor(396),G2tensor(392),G2tensor(390),G2tensor(386),G2tensor(384),G1tensor(174),G1tensor(107),G1tensor(62),G0tensor(184) &
    ,G0tensor(117),G0tensor(82)])
  call ol_merge_tensors(G3tensor(342),[G3tensor(341),G3tensor(340),G3tensor(336),G3tensor(335),G3tensor(334),G3tensor(324) &
    ,G3tensor(323),G3tensor(322),G3tensor(297),G3tensor(296),G3tensor(295),G3tensor(294),G3tensor(293),G3tensor(292),G3tensor(291) &
    ,G3tensor(290),G3tensor(289),G3tensor(159),G3tensor(158),G3tensor(157),G3tensor(153),G3tensor(152),G3tensor(151),G3tensor(144) &
    ,G3tensor(143),G3tensor(142),G3tensor(77),G3tensor(74),G3tensor(71),G3tensor(50),G3tensor(47),G3tensor(44),G3tensor(41) &
    ,G3tensor(38),G3tensor(35),G2tensor(343),G2tensor(39),G2tensor(43),G2tensor(269),G2tensor(670),G2tensor(673),G2tensor(319) &
    ,G2tensor(325),G2tensor(31),G2tensor(687),G2tensor(684),G2tensor(681),G2tensor(669),G2tensor(666),G2tensor(663),G2tensor(642) &
    ,G2tensor(639),G2tensor(636),G2tensor(462),G2tensor(456),G2tensor(450),G2tensor(417),G2tensor(411),G2tensor(405),G2tensor(399) &
    ,G2tensor(393),G2tensor(387),G2tensor(276),G2tensor(274),G2tensor(272),G2tensor(264),G2tensor(262),G2tensor(260),G2tensor(252) &
    ,G2tensor(250),G2tensor(248),G1tensor(222),G1tensor(187),G1tensor(177),G1tensor(127),G1tensor(112),G1tensor(77),G0tensor(232) &
    ,G0tensor(197),G0tensor(187),G0tensor(137),G0tensor(122),G0tensor(87)])
  call ol_merge_tensors(G3tensor(267),[G3tensor(266),G3tensor(265),G3tensor(83),G3tensor(81),G3tensor(79),G3tensor(49) &
    ,G3tensor(46),G3tensor(43),G2tensor(302),G2tensor(13),G2tensor(14),G2tensor(471),G2tensor(468),G2tensor(465),G2tensor(416) &
    ,G2tensor(414),G2tensor(410),G2tensor(408),G2tensor(404),G2tensor(402),G1tensor(184),G1tensor(122),G1tensor(82),G1tensor(11) &
    ,G0tensor(194),G0tensor(132),G0tensor(92),G0tensor(50)])
  call ol_merge_tensors(G3tensor(273),[G3tensor(272),G3tensor(271),G3tensor(89),G3tensor(87),G3tensor(85),G3tensor(76) &
    ,G3tensor(73),G3tensor(70),G2tensor(18),G2tensor(313),G2tensor(314),G2tensor(480),G2tensor(477),G2tensor(474),G2tensor(461) &
    ,G2tensor(459),G2tensor(455),G2tensor(453),G2tensor(449),G2tensor(447),G1tensor(219),G1tensor(132),G1tensor(117),G1tensor(33) &
    ,G0tensor(229),G0tensor(142),G0tensor(127),G0tensor(60)])
  call ol_merge_tensors(G3tensor(264),[G3tensor(263),G3tensor(262),G3tensor(126),G3tensor(124),G3tensor(122),G3tensor(93) &
    ,G3tensor(92),G3tensor(91),G2tensor(317),G2tensor(1),G2tensor(2),G2tensor(588),G2tensor(582),G2tensor(576),G2tensor(489) &
    ,G2tensor(486),G2tensor(483),G1tensor(217),G1tensor(137),G1tensor(111),G1tensor(40),G0tensor(227),G0tensor(147),G0tensor(121) &
    ,G0tensor(51)])
  call ol_merge_tensors(G3tensor(270),[G3tensor(269),G3tensor(268),G3tensor(102),G3tensor(101),G3tensor(100),G3tensor(96) &
    ,G3tensor(95),G3tensor(94),G2tensor(3),G2tensor(310),G2tensor(311),G2tensor(516),G2tensor(513),G2tensor(510),G2tensor(498) &
    ,G2tensor(495),G2tensor(492),G1tensor(162),G1tensor(147),G1tensor(76),G1tensor(65),G0tensor(172),G0tensor(157),G0tensor(86) &
    ,G0tensor(61)])
  call ol_merge_tensors(G3tensor(258),[G3tensor(257),G3tensor(256),G3tensor(99),G3tensor(98),G3tensor(97),G2tensor(5),G2tensor(6) &
    ,G2tensor(10),G2tensor(507),G2tensor(504),G2tensor(501),G1tensor(157),G1tensor(91),G1tensor(63),G0tensor(167),G0tensor(101) &
    ,G0tensor(71)])
  call ol_merge_tensors(G3tensor(288),[G3tensor(287),G3tensor(286),G3tensor(108),G3tensor(107),G3tensor(106),G3tensor(105) &
    ,G3tensor(104),G3tensor(103),G2tensor(7),G2tensor(8),G2tensor(9),G2tensor(534),G2tensor(531),G2tensor(528),G2tensor(525) &
    ,G2tensor(522),G2tensor(519),G1tensor(182),G1tensor(172),G1tensor(75),G0tensor(192),G0tensor(182),G0tensor(85)])
  call ol_merge_tensors(G3tensor(282),[G3tensor(281),G3tensor(280),G3tensor(111),G3tensor(110),G3tensor(109),G2tensor(295) &
    ,G2tensor(296),G2tensor(19),G2tensor(543),G2tensor(540),G2tensor(537),G1tensor(192),G1tensor(90),G0tensor(202) &
    ,G0tensor(100)])
  call ol_merge_tensors(G3tensor(276),[G3tensor(275),G3tensor(274),G3tensor(116),G3tensor(114),G3tensor(112),G2tensor(30) &
    ,G2tensor(307),G2tensor(308),G2tensor(558),G2tensor(552),G2tensor(546),G1tensor(197),G1tensor(100),G0tensor(207) &
    ,G0tensor(110)])
  call ol_merge_tensors(G3tensor(246),[G3tensor(245),G3tensor(244),G3tensor(117),G3tensor(115),G3tensor(113),G2tensor(304) &
    ,G2tensor(305),G2tensor(4),G2tensor(561),G2tensor(555),G2tensor(549),G1tensor(202),G1tensor(101),G0tensor(212) &
    ,G0tensor(111)])
  call ol_merge_tensors(G3tensor(285),[G3tensor(284),G3tensor(283),G3tensor(125),G3tensor(123),G3tensor(121),G3tensor(120) &
    ,G3tensor(119),G3tensor(118),G2tensor(15),G2tensor(16),G2tensor(17),G2tensor(585),G2tensor(579),G2tensor(573),G2tensor(570) &
    ,G2tensor(567),G2tensor(564),G1tensor(212),G1tensor(207),G1tensor(110),G0tensor(222),G0tensor(217),G0tensor(120)])
  call ol_merge_tensors(G3tensor(279),[G3tensor(278),G3tensor(277),G3tensor(137),G3tensor(135),G3tensor(133),G3tensor(131) &
    ,G3tensor(129),G3tensor(127),G2tensor(20),G2tensor(21),G2tensor(301),G2tensor(621),G2tensor(615),G2tensor(609),G2tensor(603) &
    ,G2tensor(597),G2tensor(591),G1tensor(237),G1tensor(227),G1tensor(125),G0tensor(247),G0tensor(237),G0tensor(135)])
  call ol_merge_tensors(G3tensor(252),[G3tensor(251),G3tensor(250),G3tensor(138),G3tensor(136),G3tensor(134),G3tensor(132) &
    ,G3tensor(130),G3tensor(128),G2tensor(11),G2tensor(12),G2tensor(316),G2tensor(624),G2tensor(618),G2tensor(612),G2tensor(606) &
    ,G2tensor(600),G2tensor(594),G1tensor(242),G1tensor(232),G1tensor(126),G0tensor(252),G0tensor(242),G0tensor(136)])
  call ol_merge_tensors(G3tensor(195),[G3tensor(193),G3tensor(191),G2tensor(488),G2tensor(485),G2tensor(482),G1tensor(134) &
    ,G1tensor(106),G1tensor(5),G0tensor(144),G0tensor(116),G0tensor(46)])
  call ol_merge_tensors(G3tensor(201),[G3tensor(199),G3tensor(197),G2tensor(497),G2tensor(494),G2tensor(491),G1tensor(144) &
    ,G1tensor(50),G1tensor(23),G0tensor(154),G0tensor(81),G0tensor(56)])
  call ol_merge_tensors(G3tensor(207),[G3tensor(205),G3tensor(203),G2tensor(506),G2tensor(503),G2tensor(500),G1tensor(154) &
    ,G1tensor(86),G1tensor(51),G0tensor(164),G0tensor(96),G0tensor(66)])
  call ol_merge_tensors(G3tensor(167),[G3tensor(165),G3tensor(163),G2tensor(515),G2tensor(512),G2tensor(509),G1tensor(159) &
    ,G1tensor(140),G1tensor(81),G1tensor(31),G0tensor(169),G0tensor(150),G0tensor(91),G0tensor(76)])
  call ol_merge_tensors(G3tensor(231),[G3tensor(230),G3tensor(229),G2tensor(557),G2tensor(551),G2tensor(545),G1tensor(194) &
    ,G1tensor(95),G0tensor(204),G0tensor(105)])
  call ol_merge_tensors(G3tensor(219),[G3tensor(217),G3tensor(215),G2tensor(560),G2tensor(554),G2tensor(548),G1tensor(199) &
    ,G1tensor(96),G0tensor(209),G0tensor(106)])
  call ol_merge_tensors(G3tensor(234),[G3tensor(233),G3tensor(232),G2tensor(584),G2tensor(578),G2tensor(572),G1tensor(209) &
    ,G1tensor(170),G1tensor(145),G1tensor(115),G0tensor(219),G0tensor(180),G0tensor(155),G0tensor(125)])
  call ol_merge_tensors(G3tensor(171),[G3tensor(170),G3tensor(169),G2tensor(587),G2tensor(581),G2tensor(575),G1tensor(214) &
    ,G1tensor(191),G1tensor(150),G1tensor(116),G0tensor(224),G0tensor(201),G0tensor(160),G0tensor(126)])
  call ol_merge_tensors(G3tensor(237),[G3tensor(236),G3tensor(235),G2tensor(602),G2tensor(596),G2tensor(590),G1tensor(224) &
    ,G1tensor(215),G1tensor(210),G1tensor(120),G0tensor(234),G0tensor(225),G0tensor(220),G0tensor(130)])
  call ol_merge_tensors(G3tensor(228),[G3tensor(226),G3tensor(224),G2tensor(605),G2tensor(599),G2tensor(593),G1tensor(229) &
    ,G1tensor(121),G0tensor(239),G0tensor(131)])
  call ol_merge_tensors(G3tensor(240),[G3tensor(239),G3tensor(238),G2tensor(620),G2tensor(614),G2tensor(608),G1tensor(234) &
    ,G1tensor(180),G1tensor(160),G1tensor(130),G0tensor(244),G0tensor(190),G0tensor(170),G0tensor(140)])
  call ol_merge_tensors(G3tensor(176),[G3tensor(174),G3tensor(172),G2tensor(623),G2tensor(617),G2tensor(611),G1tensor(239) &
    ,G1tensor(196),G1tensor(165),G1tensor(131),G0tensor(249),G0tensor(206),G0tensor(175),G0tensor(141)])
  call ol_merge_tensors(G1tensor(356),[G1tensor(309),G1tensor(268),G1tensor(7)])
  call ol_merge_tensors(G1tensor(335),[G1tensor(307),G1tensor(260),G1tensor(13)])
  call ol_merge_tensors(G1tensor(331),[G1tensor(275),G1tensor(56),G1tensor(19)])
  call ol_merge_tensors(G1tensor(247),[G1tensor(8),G1tensor(25)])
  call ol_merge_tensors(G1tensor(292),[G1tensor(285),G1tensor(276),G1tensor(37)])
  call ol_merge_tensors(G1tensor(343),[G1tensor(327),G1tensor(264),G1tensor(43)])
  call ol_merge_tensors(G1tensor(299),[G1tensor(283),G1tensor(18),G1tensor(49)])
  call ol_merge_tensors(G1tensor(255),[G1tensor(251),G1tensor(48),G1tensor(32),G1tensor(55)])
  call ol_merge_tensors(G1tensor(377),[G1tensor(364),G1tensor(345),G1tensor(321),G1tensor(284),G1tensor(67)])
  call ol_merge_tensors(G1tensor(315),[G1tensor(295),G1tensor(252),G1tensor(2)])
  call ol_merge_tensors(G1tensor(291),[G1tensor(30),G1tensor(6)])
  call ol_merge_tensors(G1tensor(304),[G1tensor(300),G1tensor(269),G1tensor(12)])
  call ol_merge_tensors(G1tensor(355),[G1tensor(351),G1tensor(14)])
  call ol_merge_tensors(G1tensor(267),[G1tensor(263),G1tensor(259),G1tensor(21),G1tensor(9),G1tensor(20)])
  call ol_merge_tensors(G1tensor(373),[G1tensor(348),G1tensor(337),G1tensor(308),G1tensor(301),G1tensor(26)])
  call ol_merge_tensors(G1tensor(359),[G1tensor(36)])
  call ol_merge_tensors(G1tensor(365),[G1tensor(352),G1tensor(312),G1tensor(305),G1tensor(273),G1tensor(38)])
  call ol_merge_tensors(G1tensor(363),[G1tensor(42)])
  call ol_merge_tensors(G1tensor(319),[G1tensor(44)])
  call ol_merge_tensors(G1tensor(361),[G1tensor(324),G1tensor(320),G1tensor(317),G1tensor(277),G1tensor(60)])
  call ol_merge_tensors(G1tensor(371),[G1tensor(367),G1tensor(54)])
  call ol_merge_tensors(G1tensor(357),[G1tensor(340),G1tensor(332),G1tensor(293),G1tensor(289),G1tensor(72)])
  call ol_merge_tensors(G1tensor(379),[G1tensor(375),G1tensor(66)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(339),G1tensor(68)])
  call ol_merge_tensors(G3tensor(168),[G3tensor(166),G3tensor(164),G1tensor(176),G1tensor(156),G1tensor(151),G1tensor(146) &
    ,G1tensor(141),G1tensor(136),G0tensor(186),G0tensor(166),G0tensor(161),G0tensor(156),G0tensor(151),G0tensor(146)])
  call ol_merge_tensors(G3tensor(177),[G3tensor(175),G3tensor(173),G1tensor(231),G1tensor(201),G1tensor(186),G1tensor(166) &
    ,G1tensor(161),G0tensor(241),G0tensor(211),G0tensor(196),G0tensor(176),G0tensor(171)])
  call ol_merge_tensors(G3tensor(180),[G3tensor(179),G3tensor(178),G1tensor(206),G1tensor(175),G1tensor(171),G0tensor(216) &
    ,G0tensor(185),G0tensor(181)])
  call ol_merge_tensors(G3tensor(183),[G3tensor(182),G3tensor(181),G1tensor(226),G1tensor(185),G1tensor(181),G0tensor(236) &
    ,G0tensor(195),G0tensor(191)])
  call ol_merge_tensors(G3tensor(188),[G3tensor(186),G3tensor(184),G1tensor(236),G1tensor(220),G1tensor(211),G0tensor(246) &
    ,G0tensor(230),G0tensor(221)])
  call ol_merge_tensors(G3tensor(189),[G3tensor(187),G3tensor(185),G1tensor(241),G1tensor(221),G1tensor(216),G0tensor(251) &
    ,G0tensor(231),G0tensor(226)])
  call ol_merge_tensors(G1tensor(287),[G1tensor(271),G1tensor(244)])
  call ol_merge_tensors(G1tensor(306),[G1tensor(296),G1tensor(294),G1tensor(245)])
  call ol_merge_tensors(G1tensor(290),[G1tensor(282),G1tensor(274),G1tensor(258),G1tensor(250),G1tensor(246)])
  call ol_merge_tensors(G1tensor(311),[G1tensor(279),G1tensor(248)])
  call ol_merge_tensors(G1tensor(358),[G1tensor(328),G1tensor(326),G1tensor(249)])
  call ol_merge_tensors(G1tensor(362),[G1tensor(344),G1tensor(342),G1tensor(253)])
  call ol_merge_tensors(G1tensor(338),[G1tensor(318),G1tensor(298),G1tensor(262),G1tensor(254)])
  call ol_merge_tensors(G1tensor(323),[G1tensor(303),G1tensor(256)])
  call ol_merge_tensors(G1tensor(366),[G1tensor(350),G1tensor(257)])
  call ol_merge_tensors(G1tensor(374),[G1tensor(354),G1tensor(261)])
  call ol_merge_tensors(G1tensor(378),[G1tensor(370),G1tensor(265)])
  call ol_merge_tensors(G1tensor(346),[G1tensor(330),G1tensor(266)])
  call ol_merge_tensors(G1tensor(322),[G1tensor(272),G1tensor(270)])
  call ol_merge_tensors(G1tensor(302),[G1tensor(280),G1tensor(278)])
  call ol_merge_tensors(G1tensor(368),[G1tensor(349),G1tensor(325),G1tensor(281)])
  call ol_merge_tensors(G1tensor(310),[G1tensor(288),G1tensor(286)])
  call ol_merge_tensors(G1tensor(376),[G1tensor(353),G1tensor(341),G1tensor(297)])
  call ol_merge_tensors(G1tensor(360),[G1tensor(313)])
  call ol_merge_tensors(G1tensor(316),[G1tensor(314)])
  call ol_merge_tensors(G1tensor(372),[G1tensor(369),G1tensor(333),G1tensor(329)])
  call ol_merge_tensors(G1tensor(336),[G1tensor(334)])
  call TI_triangle_red(G3tensor(194),RedBasis(64),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1)
  call TI_triangle_red(G3tensor(200),RedBasis(62),mass3set(:,1),G0tensor(5),G0tensor(6),G0tensor(7),G0tensor(8),M2L1R1)
  call TI_triangle_red(G3tensor(206),RedBasis(33),mass3set(:,1),G0tensor(43),G0tensor(48),G0tensor(53),G0tensor(58),M2L1R1)
  call TI_triangle_red(G3tensor(210),RedBasis(58),mass3set(:,1),G0tensor(63),G0tensor(68),G0tensor(73),G0tensor(78),M2L1R1)
  call TI_triangle_red(G3tensor(213),RedBasis(32),mass3set(:,1),G0tensor(83),G0tensor(88),G0tensor(93),G0tensor(98),M2L1R1)
  call TI_triangle_red(G3tensor(218),RedBasis(6),mass3set(:,1),G0tensor(103),G0tensor(108),G0tensor(113),G0tensor(118),M2L1R1)
  call TI_triangle_red(G3tensor(222),RedBasis(25),mass3set(:,1),G0tensor(123),G0tensor(128),G0tensor(133),G0tensor(138),M2L1R1)
  call TI_triangle_red(G3tensor(227),RedBasis(14),mass3set(:,1),G0tensor(143),G0tensor(148),G0tensor(153),G0tensor(158),M2L1R1)
  call TI_triangle_red(G3tensor(243),RedBasis(56),mass3set(:,1),G0tensor(163),G0tensor(168),G0tensor(173),G0tensor(178),M2L1R1)
  call TI_triangle_red(G3tensor(333),RedBasis(1),mass3set(:,1),G0tensor(183),G0tensor(188),G0tensor(193),G0tensor(198),M2L1R1)
  call TI_triangle_red(G3tensor(249),RedBasis(59),mass3set(:,1),G0tensor(203),G0tensor(208),G0tensor(213),G0tensor(218),M2L1R1)
  call TI_triangle_red(G3tensor(339),RedBasis(7),mass3set(:,1),G0tensor(223),G0tensor(228),G0tensor(233),G0tensor(238),M2L1R1)
  call TI_triangle_red(G3tensor(261),RedBasis(13),mass3set(:,1),G0tensor(243),G0tensor(248),G0tensor(9),G0tensor(10),M2L1R1)
  call TI_triangle_red(G3tensor(255),RedBasis(63),mass3set(:,1),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),M2L1R1)
  call TI_triangle_red(G3tensor(342),RedBasis(18),mass3set(:,1),G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),M2L1R1)
  call TI_triangle_red(G3tensor(267),RedBasis(4),mass3set(:,1),G0tensor(19),G0tensor(20),G0tensor(21),G0tensor(22),M2L1R1)
  call TI_triangle_red(G3tensor(273),RedBasis(9),mass3set(:,1),G0tensor(23),G0tensor(24),G0tensor(25),G0tensor(26),M2L1R1)
  call TI_triangle_red(G3tensor(264),RedBasis(2),mass3set(:,1),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30),M2L1R1)
  call TI_triangle_red(G3tensor(270),RedBasis(8),mass3set(:,1),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),M2L1R1)
  call TI_triangle_red(G3tensor(258),RedBasis(12),mass3set(:,1),G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),M2L1R1)
  call TI_triangle_red(G3tensor(288),RedBasis(19),mass3set(:,1),G0tensor(39),G0tensor(40),G0tensor(41),G0tensor(42),M2L1R1)
  call TI_triangle_red(G3tensor(282),RedBasis(22),mass3set(:,1),G0tensor(199),G0tensor(95),G0tensor(49),G0tensor(44),M2L1R1)
  call TI_triangle_red(G3tensor(276),RedBasis(24),mass3set(:,1),G0tensor(74),G0tensor(65),G0tensor(59),G0tensor(54),M2L1R1)
  call TI_triangle_red(G3tensor(246),RedBasis(23),mass3set(:,1),G0tensor(250),G0tensor(245),G0tensor(214),G0tensor(115),M2L1R1)
  call TI_triangle_red(G3tensor(285),RedBasis(26),mass3set(:,1),G0tensor(69),G0tensor(64),G0tensor(89),G0tensor(84),M2L1R1)
  call TI_triangle_red(G3tensor(279),RedBasis(31),mass3set(:,1),G0tensor(79),G0tensor(45),G0tensor(240),G0tensor(235),M2L1R1)
  call TI_triangle_red(G3tensor(252),RedBasis(30),mass3set(:,1),G0tensor(179),G0tensor(99),G0tensor(94),G0tensor(80),M2L1R1)
  call TI_triangle_red(G3tensor(195),RedBasis(57),mass3set(:,1),G0tensor(215),G0tensor(189),G0tensor(145),G0tensor(109),M2L1R1)
  call TI_triangle_red(G3tensor(201),RedBasis(60),mass3set(:,1),G0tensor(104),G0tensor(90),G0tensor(210),G0tensor(205),M2L1R1)
  call TI_triangle_red(G3tensor(207),RedBasis(61),mass3set(:,1),G0tensor(124),G0tensor(119),G0tensor(114),G0tensor(55),M2L1R1)
  call TI_triangle_red(G3tensor(167),RedBasis(5),mass3set(:,1),G0tensor(200),G0tensor(165),G0tensor(139),G0tensor(134),M2L1R1)
  call TI_triangle_red(G3tensor(231),RedBasis(66),mass3set(:,1),G0tensor(129),G0tensor(75),G0tensor(149),G0tensor(67),M2L1R1)
  call TI_triangle_red(G3tensor(219),RedBasis(65),mass3set(:,1),G0tensor(47),G0tensor(152),G0tensor(72),G0tensor(52),M2L1R1)
  call TI_triangle_red(G3tensor(234),RedBasis(11),mass3set(:,1),G0tensor(159),G0tensor(97),G0tensor(57),G0tensor(177),M2L1R1)
  call TI_triangle_red(G3tensor(171),RedBasis(10),mass3set(:,1),G0tensor(162),G0tensor(112),G0tensor(102),G0tensor(62),M2L1R1)
  call TI_triangle_red(G3tensor(237),RedBasis(29),mass3set(:,1),G0tensor(174),G0tensor(107),G0tensor(77),G0tensor(70),M2L1R1)
  call TI_triangle_red(G3tensor(228),RedBasis(67),mass3set(:,1),G0tensor(184),G0tensor(117),G0tensor(82),G0tensor(232),M2L1R1)
  call TI_triangle_red(G3tensor(240),RedBasis(17),mass3set(:,1),G0tensor(197),G0tensor(187),G0tensor(137),G0tensor(122),M2L1R1)
  call TI_triangle_red(G3tensor(176),RedBasis(16),mass3set(:,1),G0tensor(87),G0tensor(194),G0tensor(132),G0tensor(92),M2L1R1)
  call TI_triangle_red(G3tensor(168),RedBasis(3),mass3set(:,1),G0tensor(50),G0tensor(229),G0tensor(142),G0tensor(127),M2L1R1)
  call TI_triangle_red(G3tensor(177),RedBasis(15),mass3set(:,1),G0tensor(60),G0tensor(227),G0tensor(147),G0tensor(121),M2L1R1)
  call TI_triangle_red(G3tensor(180),RedBasis(20),mass3set(:,1),G0tensor(51),G0tensor(172),G0tensor(157),G0tensor(86),M2L1R1)
  call TI_triangle_red(G3tensor(183),RedBasis(21),mass3set(:,1),G0tensor(61),G0tensor(167),G0tensor(101),G0tensor(71),M2L1R1)
  call TI_triangle_red(G3tensor(188),RedBasis(28),mass3set(:,1),G0tensor(192),G0tensor(182),G0tensor(85),G0tensor(202),M2L1R1)
  call TI_triangle_red(G3tensor(189),RedBasis(27),mass3set(:,1),G0tensor(100),G0tensor(207),G0tensor(110),G0tensor(212),M2L1R1)
  call ol_merge_tensors(T0sum(85),[G0tensor(1)])
  call ol_merge_tensors(T0sum(86),[G0tensor(5)])
  call ol_merge_tensors(T0sum(87),[G0tensor(43)])
  call ol_merge_tensors(T0sum(88),[G0tensor(63)])
  call ol_merge_tensors(T0sum(89),[G0tensor(83)])
  call ol_merge_tensors(T0sum(90),[G0tensor(103)])
  call ol_merge_tensors(T0sum(91),[G0tensor(123)])
  call ol_merge_tensors(T0sum(92),[G0tensor(143)])
  call ol_merge_tensors(T0sum(93),[G0tensor(163)])
  call ol_merge_tensors(T0sum(94),[G0tensor(183)])
  call ol_merge_tensors(T0sum(95),[G0tensor(203)])
  call ol_merge_tensors(T0sum(96),[G0tensor(223)])
  call ol_merge_tensors(T0sum(97),[G0tensor(243)])
  call ol_merge_tensors(T0sum(98),[G0tensor(11)])
  call ol_merge_tensors(T0sum(99),[G0tensor(15)])
  call ol_merge_tensors(T0sum(100),[G0tensor(19)])
  call ol_merge_tensors(T0sum(101),[G0tensor(23)])
  call ol_merge_tensors(T0sum(102),[G0tensor(27)])
  call ol_merge_tensors(T0sum(103),[G0tensor(31)])
  call ol_merge_tensors(T0sum(104),[G0tensor(35)])
  call ol_merge_tensors(T0sum(105),[G0tensor(39)])
  call ol_merge_tensors(T0sum(106),[G0tensor(199)])
  call ol_merge_tensors(T0sum(107),[G0tensor(74)])
  call ol_merge_tensors(T0sum(108),[G0tensor(250)])
  call ol_merge_tensors(T0sum(109),[G0tensor(69)])
  call ol_merge_tensors(T0sum(110),[G0tensor(79)])
  call ol_merge_tensors(T0sum(111),[G0tensor(179)])
  call ol_merge_tensors(T0sum(112),[G0tensor(215)])
  call ol_merge_tensors(T0sum(113),[G0tensor(104)])
  call ol_merge_tensors(T0sum(114),[G0tensor(124)])
  call ol_merge_tensors(T0sum(115),[G0tensor(200)])
  call ol_merge_tensors(T0sum(116),[G0tensor(129)])
  call ol_merge_tensors(T0sum(117),[G0tensor(47)])
  call ol_merge_tensors(T0sum(118),[G0tensor(159)])
  call ol_merge_tensors(T0sum(119),[G0tensor(162)])
  call ol_merge_tensors(T0sum(120),[G0tensor(174)])
  call ol_merge_tensors(T0sum(121),[G0tensor(184)])
  call ol_merge_tensors(T0sum(122),[G0tensor(197)])
  call ol_merge_tensors(T0sum(123),[G0tensor(87)])
  call ol_merge_tensors(T1sum(13),[G1tensor(356)])
  call ol_merge_tensors(T1sum(14),[G1tensor(335)])
  call ol_merge_tensors(T1sum(15),[G1tensor(331)])
  call ol_merge_tensors(T1sum(16),[G1tensor(247)])
  call ol_merge_tensors(T1sum(17),[G1tensor(292)])
  call ol_merge_tensors(T1sum(18),[G1tensor(343)])
  call ol_merge_tensors(T1sum(19),[G1tensor(299)])
  call ol_merge_tensors(T1sum(20),[G1tensor(255)])
  call ol_merge_tensors(T1sum(21),[G1tensor(377)])
  call ol_merge_tensors(T1sum(22),[G1tensor(315)])
  call ol_merge_tensors(T1sum(23),[G1tensor(291)])
  call ol_merge_tensors(T1sum(24),[G1tensor(304)])
  call ol_merge_tensors(T1sum(25),[G1tensor(355)])
  call ol_merge_tensors(T1sum(26),[G1tensor(267)])
  call ol_merge_tensors(T1sum(27),[G1tensor(373)])
  call ol_merge_tensors(T1sum(28),[G1tensor(359)])
  call ol_merge_tensors(T1sum(29),[G1tensor(365)])
  call ol_merge_tensors(T1sum(30),[G1tensor(363)])
  call ol_merge_tensors(T1sum(31),[G1tensor(319)])
  call ol_merge_tensors(T1sum(32),[G1tensor(361)])
  call ol_merge_tensors(T1sum(33),[G1tensor(371)])
  call ol_merge_tensors(T1sum(34),[G1tensor(357)])
  call ol_merge_tensors(T1sum(35),[G1tensor(379)])
  call ol_merge_tensors(T1sum(36),[G1tensor(347)])
  call ol_merge_tensors(T0sum(124),[G0tensor(50)])
  call ol_merge_tensors(T0sum(125),[G0tensor(60)])
  call ol_merge_tensors(T0sum(126),[G0tensor(51)])
  call ol_merge_tensors(T0sum(127),[G0tensor(61)])
  call ol_merge_tensors(T0sum(128),[G0tensor(192)])
  call ol_merge_tensors(T0sum(129),[G0tensor(100)])
  call ol_merge_tensors(T1sum(37),[G1tensor(287)])
  call ol_merge_tensors(T1sum(38),[G1tensor(306)])
  call ol_merge_tensors(T1sum(39),[G1tensor(290)])
  call ol_merge_tensors(T1sum(40),[G1tensor(311)])
  call ol_merge_tensors(T1sum(41),[G1tensor(358)])
  call ol_merge_tensors(T1sum(42),[G1tensor(362)])
  call ol_merge_tensors(T1sum(43),[G1tensor(338)])
  call ol_merge_tensors(T1sum(44),[G1tensor(323)])
  call ol_merge_tensors(T1sum(45),[G1tensor(366)])
  call ol_merge_tensors(T1sum(46),[G1tensor(374)])
  call ol_merge_tensors(T1sum(47),[G1tensor(378)])
  call ol_merge_tensors(T1sum(48),[G1tensor(346)])
  call ol_merge_tensors(T1sum(49),[G1tensor(322)])
  call ol_merge_tensors(T1sum(50),[G1tensor(302)])
  call ol_merge_tensors(T1sum(51),[G1tensor(368)])
  call ol_merge_tensors(T1sum(52),[G1tensor(310)])
  call ol_merge_tensors(T1sum(53),[G1tensor(376)])
  call ol_merge_tensors(T1sum(54),[G1tensor(360)])
  call ol_merge_tensors(T1sum(55),[G1tensor(316)])
  call ol_merge_tensors(T1sum(56),[G1tensor(372)])
  call ol_merge_tensors(T1sum(57),[G1tensor(336)])
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(55),m4h2x4x4(:,37),heltab3x32(:,:,235))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(56),m4h2x4x4(:,38),heltab3x32(:,:,236))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(57),m4h2x4x4(:,39),heltab3x32(:,:,237))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(58),m4h4x2x4(:,19),heltab3x32(:,:,238))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(59),m4h4x2x4(:,20),heltab3x32(:,:,239))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(60),m4h4x2x4(:,21),heltab3x32(:,:,240))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(61),m4h2x4x4(:,40),heltab3x32(:,:,241))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(62),m4h2x4x4(:,41),heltab3x32(:,:,242))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[19,12],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(63),m4h2x4x4(:,42),heltab3x32(:,:,243))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(48),m4h2x2x8(:,181),heltab3x32(:,:,244))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(47),m4h2x2x8(:,182),heltab3x32(:,:,245))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(46),m4h2x2x8(:,183),heltab3x32(:,:,246))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(51),m4h2x2x8(:,184),heltab3x32(:,:,247))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(50),m4h2x2x8(:,185),heltab3x32(:,:,248))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(49),m4h2x2x8(:,186),heltab3x32(:,:,249))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(54),m4h2x2x8(:,187),heltab3x32(:,:,250))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(53),m4h2x2x8(:,188),heltab3x32(:,:,251))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[20,11],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(52),m4h2x2x8(:,189),heltab3x32(:,:,252))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(19),m4h2x2x8(:,190),heltab3x32(:,:,253))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(20),m4h2x2x8(:,191),heltab3x32(:,:,254))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(21),m4h2x2x8(:,192),heltab3x32(:,:,255))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(28),m4h2x2x8(:,193),heltab3x32(:,:,256))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(2)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(29),m4h2x2x8(:,194),heltab3x32(:,:,257))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(30),m4h2x2x8(:,195),heltab3x32(:,:,258))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,196),heltab3x32(:,:,259))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,197),heltab3x32(:,:,260))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[24,7],[0,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,198),heltab3x32(:,:,261))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(64),m4h2x4x4(:,43),heltab3x32(:,:,262))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(65),m4h2x4x4(:,44),heltab3x32(:,:,263))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(66),m4h2x4x4(:,45),heltab3x32(:,:,264))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(67),m4h4x2x4(:,22),heltab3x32(:,:,265))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(68),m4h4x2x4(:,23),heltab3x32(:,:,266))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(69),m4h4x2x4(:,24),heltab3x32(:,:,267))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(70),m4h2x4x4(:,46),heltab3x32(:,:,268))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(71),m4h2x4x4(:,47),heltab3x32(:,:,269))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[21,10],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(72),m4h2x4x4(:,48),heltab3x32(:,:,270))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(84),m4h2x2x8(:,199),heltab3x32(:,:,271))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(83),m4h2x2x8(:,200),heltab3x32(:,:,272))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(82),m4h2x2x8(:,201),heltab3x32(:,:,273))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(87),m4h2x2x8(:,202),heltab3x32(:,:,274))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(86),m4h2x2x8(:,203),heltab3x32(:,:,275))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(85),m4h2x2x8(:,204),heltab3x32(:,:,276))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(90),m4h2x2x8(:,205),heltab3x32(:,:,277))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(89),m4h2x2x8(:,206),heltab3x32(:,:,278))
  Gcoeff(:)%j = (c(3)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[18,13],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(88),m4h2x2x8(:,207),heltab3x32(:,:,279))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(36),m4h2x2x8(:,208),heltab3x32(:,:,280))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(33),m4h2x2x8(:,209),heltab3x32(:,:,281))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(27),m4h2x2x8(:,210),heltab3x32(:,:,282))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(35),m4h2x2x8(:,211),heltab3x32(:,:,283))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(2)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(32),m4h2x2x8(:,212),heltab3x32(:,:,284))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(26),m4h2x2x8(:,213),heltab3x32(:,:,285))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(34),m4h2x2x8(:,214),heltab3x32(:,:,286))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(31),m4h2x2x8(:,215),heltab3x32(:,:,287))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[24,7],[0,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(25),m4h2x2x8(:,216),heltab3x32(:,:,288))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(73),m4h2x4x4(:,49),heltab3x32(:,:,289))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(74),m4h2x4x4(:,50),heltab3x32(:,:,290))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(75),m4h2x4x4(:,51),heltab3x32(:,:,291))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,3),ex5(:),G0H4(76),m4h4x2x4(:,25),heltab3x32(:,:,292))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,3),ex5(:),G0H4(77),m4h4x2x4(:,26),heltab3x32(:,:,293))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,3),ex5(:),G0H4(78),m4h4x2x4(:,27),heltab3x32(:,:,294))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(79),m4h2x4x4(:,52),heltab3x32(:,:,295))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(80),m4h2x4x4(:,53),heltab3x32(:,:,296))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[25,6],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,3),G0H4(81),m4h2x4x4(:,54),heltab3x32(:,:,297))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[30,1],[0,0],3,1,wf8(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,10),G0H2(1),m4h2x8x2(:,1),heltab3x32(:,:,298))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[30,1],[0,0],3,1,wf8(:,11))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,11),G0H2(2),m4h2x8x2(:,2),heltab3x32(:,:,299))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[30,1],[0,0],3,1,wf8(:,12))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,12),G0H2(3),m4h2x8x2(:,3),heltab3x32(:,:,300))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[30,1],[0,0],3,1,wf8(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,10),ex5(:),G0H2(4),m4h8x2x2(:,1),heltab3x32(:,:,301))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[30,1],[0,0],3,1,wf8(:,11))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,11),ex5(:),G0H2(5),m4h8x2x2(:,2),heltab3x32(:,:,302))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[30,1],[0,0],3,1,wf8(:,12))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,12),ex5(:),G0H2(6),m4h8x2x2(:,3),heltab3x32(:,:,303))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[30,1],[0,0],3,1,wf8(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,10),G0H2(7),m4h2x8x2(:,4),heltab3x32(:,:,304))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[30,1],[0,0],3,1,wf8(:,11))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,11),G0H2(8),m4h2x8x2(:,5),heltab3x32(:,:,305))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[30,1],[0,0],3,1,wf8(:,12))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,12),G0H2(9),m4h2x8x2(:,6),heltab3x32(:,:,306))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(82),m4h2x4x4(:,55),heltab3x32(:,:,307))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(83),m4h2x4x4(:,56),heltab3x32(:,:,308))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(84),m4h2x4x4(:,57),heltab3x32(:,:,309))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex4(:),G0H4(36),m4h4x2x4(:,28),heltab3x32(:,:,310))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex4(:),G0H4(35),m4h4x2x4(:,29),heltab3x32(:,:,311))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex4(:),G0H4(34),m4h4x2x4(:,30),heltab3x32(:,:,312))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(27),m4h2x4x4(:,58),heltab3x32(:,:,313))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(26),m4h2x4x4(:,59),heltab3x32(:,:,314))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[25,6],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,4),G0H4(25),m4h2x4x4(:,60),heltab3x32(:,:,315))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[30,1],[0,0],3,1,wf8(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,7),G0H2(10),m4h2x8x2(:,7),heltab3x32(:,:,316))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[30,1],[0,0],3,1,wf8(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,8),G0H2(11),m4h2x8x2(:,8),heltab3x32(:,:,317))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[30,1],[0,0],3,1,wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,9),G0H2(12),m4h2x8x2(:,9),heltab3x32(:,:,318))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[30,1],[0,0],3,1,wf8(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,7),ex4(:),G0H2(13),m4h8x2x2(:,4),heltab3x32(:,:,319))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[30,1],[0,0],3,1,wf8(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,8),ex4(:),G0H2(14),m4h8x2x2(:,5),heltab3x32(:,:,320))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[30,1],[0,0],3,1,wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,9),ex4(:),G0H2(15),m4h8x2x2(:,6),heltab3x32(:,:,321))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[30,1],[0,0],3,1,wf8(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,7),G0H2(16),m4h2x8x2(:,10),heltab3x32(:,:,322))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[30,1],[0,0],3,1,wf8(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,8),G0H2(17),m4h2x8x2(:,11),heltab3x32(:,:,323))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[30,1],[0,0],3,1,wf8(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,9),G0H2(18),m4h2x8x2(:,12),heltab3x32(:,:,324))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(79),m4h2x2x8(:,217),heltab3x32(:,:,325))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(76),m4h2x2x8(:,218),heltab3x32(:,:,326))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(73),m4h2x2x8(:,219),heltab3x32(:,:,327))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(80),m4h2x2x8(:,220),heltab3x32(:,:,328))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(77),m4h2x2x8(:,221),heltab3x32(:,:,329))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(74),m4h2x2x8(:,222),heltab3x32(:,:,330))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(81),m4h2x2x8(:,223),heltab3x32(:,:,331))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(78),m4h2x2x8(:,224),heltab3x32(:,:,332))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[18,13],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(75),m4h2x2x8(:,225),heltab3x32(:,:,333))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(43),m4h2x2x8(:,226),heltab3x32(:,:,334))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(40),m4h2x2x8(:,227),heltab3x32(:,:,335))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(37),m4h2x2x8(:,228),heltab3x32(:,:,336))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(44),m4h2x2x8(:,229),heltab3x32(:,:,337))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(2)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(41),m4h2x2x8(:,230),heltab3x32(:,:,338))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(38),m4h2x2x8(:,231),heltab3x32(:,:,339))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(45),m4h2x2x8(:,232),heltab3x32(:,:,340))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(42),m4h2x2x8(:,233),heltab3x32(:,:,341))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[20,11],[0,0],4,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(39),m4h2x2x8(:,234),heltab3x32(:,:,342))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(18),m4h2x4x4(:,61),heltab3x32(:,:,343))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(17),m4h2x4x4(:,62),heltab3x32(:,:,344))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(16),m4h2x4x4(:,63),heltab3x32(:,:,345))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex3(:),G0H4(51),m4h4x2x4(:,31),heltab3x32(:,:,346))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex3(:),G0H4(50),m4h4x2x4(:,32),heltab3x32(:,:,347))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex3(:),G0H4(49),m4h4x2x4(:,33),heltab3x32(:,:,348))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(30),m4h2x4x4(:,64),heltab3x32(:,:,349))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(29),m4h2x4x4(:,65),heltab3x32(:,:,350))
  Gcoeff(:)%j = (c(3)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[21,10],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,4),G0H4(28),m4h2x4x4(:,66),heltab3x32(:,:,351))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[30,1],[0,0],3,1,wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,4),G0H2(19),m4h2x8x2(:,13),heltab3x32(:,:,352))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[30,1],[0,0],3,1,wf8(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,5),G0H2(20),m4h2x8x2(:,14),heltab3x32(:,:,353))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[30,1],[0,0],3,1,wf8(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,6),G0H2(21),m4h2x8x2(:,15),heltab3x32(:,:,354))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[30,1],[0,0],3,1,wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,4),ex3(:),G0H2(22),m4h8x2x2(:,7),heltab3x32(:,:,355))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[30,1],[0,0],3,1,wf8(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,5),ex3(:),G0H2(23),m4h8x2x2(:,8),heltab3x32(:,:,356))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[30,1],[0,0],3,1,wf8(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,6),ex3(:),G0H2(24),m4h8x2x2(:,9),heltab3x32(:,:,357))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[30,1],[0,0],3,1,wf8(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,4),G0H2(25),m4h2x8x2(:,16),heltab3x32(:,:,358))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[30,1],[0,0],3,1,wf8(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,5),G0H2(26),m4h2x8x2(:,17),heltab3x32(:,:,359))
  Gcoeff(:)%j = (c(3)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[30,1],[0,0],3,1,wf8(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,6),G0H2(27),m4h2x8x2(:,18),heltab3x32(:,:,360))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(6),m4h2x4x4(:,67),heltab3x32(:,:,361))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex2(:),G0H4(5),m4h4x2x4(:,34),heltab3x32(:,:,362))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(4),m4h2x4x4(:,68),heltab3x32(:,:,363))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(45),m4h2x4x4(:,69),heltab3x32(:,:,364))
  Gcoeff(:)%j = (c(1)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(2)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex2(:),G0H4(44),m4h4x2x4(:,35),heltab3x32(:,:,365))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(43),m4h2x4x4(:,70),heltab3x32(:,:,366))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(24),m4h2x4x4(:,71),heltab3x32(:,:,367))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex2(:),G0H4(23),m4h4x2x4(:,36),heltab3x32(:,:,368))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[19,12],[0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,4),G0H4(22),m4h2x4x4(:,72),heltab3x32(:,:,369))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[30,1],[0,0],3,1,wf8(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,1),G0H2(28),m4h2x8x2(:,19),heltab3x32(:,:,370))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[30,1],[0,0],3,1,wf8(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,1),ex2(:),G0H2(29),m4h8x2x2(:,10),heltab3x32(:,:,371))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[30,1],[0,0],3,1,wf8(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,1),G0H2(30),m4h2x8x2(:,20),heltab3x32(:,:,372))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[30,1],[0,0],3,1,wf8(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,2),G0H2(31),m4h2x8x2(:,21),heltab3x32(:,:,373))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[30,1],[0,0],3,1,wf8(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,2),ex2(:),G0H2(32),m4h8x2x2(:,11),heltab3x32(:,:,374))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[30,1],[0,0],3,1,wf8(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,2),G0H2(33),m4h2x8x2(:,22),heltab3x32(:,:,375))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[30,1],[0,0],3,1,wf8(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,3),G0H2(34),m4h2x8x2(:,23),heltab3x32(:,:,376))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[30,1],[0,0],3,1,wf8(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,3),ex2(:),G0H2(35),m4h8x2x2(:,12),heltab3x32(:,:,377))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[30,1],[0,0],3,1,wf8(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,3),G0H2(36),m4h2x8x2(:,24),heltab3x32(:,:,378))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(15),m4h2x4x4(:,73),heltab3x32(:,:,379))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(14),m4h2x4x4(:,74),heltab3x32(:,:,380))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(13),m4h2x4x4(:,75),heltab3x32(:,:,381))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,5),ex5(:),G0H4(48),m4h4x2x4(:,37),heltab3x32(:,:,382))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,5),ex5(:),G0H4(47),m4h4x2x4(:,38),heltab3x32(:,:,383))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,5),ex5(:),G0H4(46),m4h4x2x4(:,39),heltab3x32(:,:,384))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(39),m4h2x4x4(:,76),heltab3x32(:,:,385))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(38),m4h2x4x4(:,77),heltab3x32(:,:,386))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[22,9],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,5),G0H4(37),m4h2x4x4(:,78),heltab3x32(:,:,387))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(114),m4h2x2x8(:,235),heltab3x32(:,:,388))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(113),m4h2x2x8(:,236),heltab3x32(:,:,389))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(112),m4h2x2x8(:,237),heltab3x32(:,:,390))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(129),m4h2x2x8(:,238),heltab3x32(:,:,391))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(128),m4h2x2x8(:,239),heltab3x32(:,:,392))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(127),m4h2x2x8(:,240),heltab3x32(:,:,393))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(138),m4h2x2x8(:,241),heltab3x32(:,:,394))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(137),m4h2x2x8(:,242),heltab3x32(:,:,395))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[17,14],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(136),m4h2x2x8(:,243),heltab3x32(:,:,396))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(132),m4h2x2x8(:,244),heltab3x32(:,:,397))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(131),m4h2x2x8(:,245),heltab3x32(:,:,398))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(130),m4h2x2x8(:,246),heltab3x32(:,:,399))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(123),m4h2x2x8(:,247),heltab3x32(:,:,400))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(2)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(122),m4h2x2x8(:,248),heltab3x32(:,:,401))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(121),m4h2x2x8(:,249),heltab3x32(:,:,402))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(141),m4h2x2x8(:,250),heltab3x32(:,:,403))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(140),m4h2x2x8(:,251),heltab3x32(:,:,404))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[24,7],[0,0],4,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(139),m4h2x2x8(:,252),heltab3x32(:,:,405))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(3),m4h2x4x4(:,79),heltab3x32(:,:,406))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(2),m4h2x4x4(:,80),heltab3x32(:,:,407))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(1),m4h2x4x4(:,81),heltab3x32(:,:,408))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,6),ex5(:),G0H4(42),m4h4x2x4(:,40),heltab3x32(:,:,409))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,6),ex5(:),G0H4(41),m4h4x2x4(:,41),heltab3x32(:,:,410))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,6),ex5(:),G0H4(40),m4h4x2x4(:,42),heltab3x32(:,:,411))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(33),m4h2x4x4(:,82),heltab3x32(:,:,412))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(32),m4h2x4x4(:,83),heltab3x32(:,:,413))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[26,5],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,6),G0H4(31),m4h2x4x4(:,84),heltab3x32(:,:,414))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[29,2],[0,0],3,1,wf8(:,19))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,19),G0H2(37),m4h2x8x2(:,25),heltab3x32(:,:,415))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[29,2],[0,0],3,1,wf8(:,20))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,20),G0H2(38),m4h2x8x2(:,26),heltab3x32(:,:,416))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[29,2],[0,0],3,1,wf8(:,21))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,21),G0H2(39),m4h2x8x2(:,27),heltab3x32(:,:,417))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[29,2],[0,0],3,1,wf8(:,19))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,19),ex5(:),G0H2(40),m4h8x2x2(:,13),heltab3x32(:,:,418))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[29,2],[0,0],3,1,wf8(:,20))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,20),ex5(:),G0H2(41),m4h8x2x2(:,14),heltab3x32(:,:,419))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[29,2],[0,0],3,1,wf8(:,21))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,21),ex5(:),G0H2(42),m4h8x2x2(:,15),heltab3x32(:,:,420))
  Gcoeff(:)%j = (c(3)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[29,2],[0,0],3,1,wf8(:,19))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,19),G0H2(43),m4h2x8x2(:,28),heltab3x32(:,:,421))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[29,2],[0,0],3,1,wf8(:,20))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,20),G0H2(44),m4h2x8x2(:,29),heltab3x32(:,:,422))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[29,2],[0,0],3,1,wf8(:,21))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,21),G0H2(45),m4h2x8x2(:,30),heltab3x32(:,:,423))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(9),m4h2x4x4(:,85),heltab3x32(:,:,424))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(8),m4h2x4x4(:,86),heltab3x32(:,:,425))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(7),m4h2x4x4(:,87),heltab3x32(:,:,426))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex4(:),G0H4(54),m4h4x2x4(:,43),heltab3x32(:,:,427))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex4(:),G0H4(53),m4h4x2x4(:,44),heltab3x32(:,:,428))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex4(:),G0H4(52),m4h4x2x4(:,45),heltab3x32(:,:,429))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(21),m4h2x4x4(:,88),heltab3x32(:,:,430))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(20),m4h2x4x4(:,89),heltab3x32(:,:,431))
  Gcoeff(:)%j = (c(3)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[26,5],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,7),G0H4(19),m4h2x4x4(:,90),heltab3x32(:,:,432))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[29,2],[0,0],3,1,wf8(:,16))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,16),G0H2(46),m4h2x8x2(:,31),heltab3x32(:,:,433))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[29,2],[0,0],3,1,wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,17),G0H2(47),m4h2x8x2(:,32),heltab3x32(:,:,434))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[29,2],[0,0],3,1,wf8(:,18))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,18),G0H2(48),m4h2x8x2(:,33),heltab3x32(:,:,435))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[29,2],[0,0],3,1,wf8(:,16))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,16),ex4(:),G0H2(49),m4h8x2x2(:,16),heltab3x32(:,:,436))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[29,2],[0,0],3,1,wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,17),ex4(:),G0H2(50),m4h8x2x2(:,17),heltab3x32(:,:,437))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[29,2],[0,0],3,1,wf8(:,18))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,18),ex4(:),G0H2(51),m4h8x2x2(:,18),heltab3x32(:,:,438))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[29,2],[0,0],3,1,wf8(:,16))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,16),G0H2(52),m4h2x8x2(:,34),heltab3x32(:,:,439))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[29,2],[0,0],3,1,wf8(:,17))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,17),G0H2(53),m4h2x8x2(:,35),heltab3x32(:,:,440))
  Gcoeff(:)%j = (c(3)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[29,2],[0,0],3,1,wf8(:,18))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,18),G0H2(54),m4h2x8x2(:,36),heltab3x32(:,:,441))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(126),m4h2x2x8(:,253),heltab3x32(:,:,442))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(125),m4h2x2x8(:,254),heltab3x32(:,:,443))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(124),m4h2x2x8(:,255),heltab3x32(:,:,444))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(144),m4h2x2x8(:,256),heltab3x32(:,:,445))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(143),m4h2x2x8(:,257),heltab3x32(:,:,446))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(142),m4h2x2x8(:,258),heltab3x32(:,:,447))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(135),m4h2x2x8(:,259),heltab3x32(:,:,448))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(134),m4h2x2x8(:,260),heltab3x32(:,:,449))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[17,14],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(133),m4h2x2x8(:,261),heltab3x32(:,:,450))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,262),heltab3x32(:,:,451))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(24),m4h2x2x8(:,263),heltab3x32(:,:,452))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,264),heltab3x32(:,:,453))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(11),m4h2x2x8(:,265),heltab3x32(:,:,454))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(2)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(23),m4h2x2x8(:,266),heltab3x32(:,:,455))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(14),m4h2x2x8(:,267),heltab3x32(:,:,456))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,268),heltab3x32(:,:,457))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(22),m4h2x2x8(:,269),heltab3x32(:,:,458))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[20,11],[0,0],4,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,270),heltab3x32(:,:,459))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(12),m4h2x4x4(:,91),heltab3x32(:,:,460))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(11),m4h2x4x4(:,92),heltab3x32(:,:,461))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(10),m4h2x4x4(:,93),heltab3x32(:,:,462))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex3(:),G0H4(85),m4h4x2x4(:,46),heltab3x32(:,:,463))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex3(:),G0H4(86),m4h4x2x4(:,47),heltab3x32(:,:,464))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex3(:),G0H4(87),m4h4x2x4(:,48),heltab3x32(:,:,465))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(88),m4h2x4x4(:,94),heltab3x32(:,:,466))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(89),m4h2x4x4(:,95),heltab3x32(:,:,467))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[22,9],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,7),G0H4(90),m4h2x4x4(:,96),heltab3x32(:,:,468))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[29,2],[0,0],3,1,wf8(:,13))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,13),G0H2(55),m4h2x8x2(:,37),heltab3x32(:,:,469))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[29,2],[0,0],3,1,wf8(:,14))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,14),G0H2(56),m4h2x8x2(:,38),heltab3x32(:,:,470))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[29,2],[0,0],3,1,wf8(:,15))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,15),G0H2(57),m4h2x8x2(:,39),heltab3x32(:,:,471))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[29,2],[0,0],3,1,wf8(:,13))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,13),ex3(:),G0H2(58),m4h8x2x2(:,19),heltab3x32(:,:,472))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[29,2],[0,0],3,1,wf8(:,14))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,14),ex3(:),G0H2(59),m4h8x2x2(:,20),heltab3x32(:,:,473))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[29,2],[0,0],3,1,wf8(:,15))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,15),ex3(:),G0H2(60),m4h8x2x2(:,21),heltab3x32(:,:,474))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[29,2],[0,0],3,1,wf8(:,13))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,13),G0H2(61),m4h2x8x2(:,40),heltab3x32(:,:,475))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[29,2],[0,0],3,1,wf8(:,14))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,14),G0H2(62),m4h2x8x2(:,41),heltab3x32(:,:,476))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[29,2],[0,0],3,1,wf8(:,15))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,15),G0H2(63),m4h2x8x2(:,42),heltab3x32(:,:,477))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(91),m4h2x4x4(:,97),heltab3x32(:,:,478))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex1(:),G0H4(92),m4h4x2x4(:,49),heltab3x32(:,:,479))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(93),m4h2x4x4(:,98),heltab3x32(:,:,480))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(94),m4h2x4x4(:,99),heltab3x32(:,:,481))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(2)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex1(:),G0H4(95),m4h4x2x4(:,50),heltab3x32(:,:,482))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(96),m4h2x4x4(:,100),heltab3x32(:,:,483))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(97),m4h2x4x4(:,101),heltab3x32(:,:,484))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,7),ex1(:),G0H4(98),m4h4x2x4(:,51),heltab3x32(:,:,485))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[19,12],[0,0],4,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,7),G0H4(99),m4h2x4x4(:,102),heltab3x32(:,:,486))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[29,2],[0,0],3,1,wf8(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,1),G0H2(64),m4h2x8x2(:,43),heltab3x32(:,:,487))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[29,2],[0,0],3,1,wf8(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,1),ex1(:),G0H2(65),m4h8x2x2(:,22),heltab3x32(:,:,488))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[29,2],[0,0],3,1,wf8(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,1),G0H2(66),m4h2x8x2(:,44),heltab3x32(:,:,489))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[29,2],[0,0],3,1,wf8(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,2),G0H2(67),m4h2x8x2(:,45),heltab3x32(:,:,490))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[29,2],[0,0],3,1,wf8(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,2),ex1(:),G0H2(68),m4h8x2x2(:,23),heltab3x32(:,:,491))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[29,2],[0,0],3,1,wf8(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,2),G0H2(69),m4h2x8x2(:,46),heltab3x32(:,:,492))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[29,2],[0,0],3,1,wf8(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,3),G0H2(70),m4h2x8x2(:,47),heltab3x32(:,:,493))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[29,2],[0,0],3,1,wf8(:,3))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,3),ex1(:),G0H2(71),m4h8x2x2(:,24),heltab3x32(:,:,494))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[29,2],[0,0],3,1,wf8(:,3))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,3),G0H2(72),m4h2x8x2(:,48),heltab3x32(:,:,495))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(100),m4h2x4x4(:,103),heltab3x32(:,:,496))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(101),m4h2x4x4(:,104),heltab3x32(:,:,497))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(102),m4h2x4x4(:,105),heltab3x32(:,:,498))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,8),ex5(:),G0H4(103),m4h4x2x4(:,52),heltab3x32(:,:,499))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,8),ex5(:),G0H4(104),m4h4x2x4(:,53),heltab3x32(:,:,500))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,8),ex5(:),G0H4(105),m4h4x2x4(:,54),heltab3x32(:,:,501))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(106),m4h2x4x4(:,106),heltab3x32(:,:,502))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(107),m4h2x4x4(:,107),heltab3x32(:,:,503))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[28,3],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,8),G0H4(108),m4h2x4x4(:,108),heltab3x32(:,:,504))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[27,4],[0,0],3,1,wf8(:,25))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,25),G0H2(73),m4h2x8x2(:,49),heltab3x32(:,:,505))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[27,4],[0,0],3,1,wf8(:,26))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,26),G0H2(74),m4h2x8x2(:,50),heltab3x32(:,:,506))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[27,4],[0,0],3,1,wf8(:,27))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,27),G0H2(75),m4h2x8x2(:,51),heltab3x32(:,:,507))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[27,4],[0,0],3,1,wf8(:,25))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,25),ex5(:),G0H2(76),m4h8x2x2(:,25),heltab3x32(:,:,508))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[27,4],[0,0],3,1,wf8(:,26))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,26),ex5(:),G0H2(77),m4h8x2x2(:,26),heltab3x32(:,:,509))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[27,4],[0,0],3,1,wf8(:,27))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,27),ex5(:),G0H2(78),m4h8x2x2(:,27),heltab3x32(:,:,510))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[27,4],[0,0],3,1,wf8(:,25))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,25),G0H2(79),m4h2x8x2(:,52),heltab3x32(:,:,511))
  Gcoeff(:)%j = (c(3)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[27,4],[0,0],3,1,wf8(:,26))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,26),G0H2(80),m4h2x8x2(:,53),heltab3x32(:,:,512))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[27,4],[0,0],3,1,wf8(:,27))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,27),G0H2(81),m4h2x8x2(:,54),heltab3x32(:,:,513))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(109),m4h2x4x4(:,109),heltab3x32(:,:,514))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(110),m4h2x4x4(:,110),heltab3x32(:,:,515))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(111),m4h2x4x4(:,111),heltab3x32(:,:,516))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex4(:),G0H4(112),m4h4x2x4(:,55),heltab3x32(:,:,517))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex4(:),G0H4(113),m4h4x2x4(:,56),heltab3x32(:,:,518))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex4(:),G0H4(114),m4h4x2x4(:,57),heltab3x32(:,:,519))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(115),m4h2x4x4(:,112),heltab3x32(:,:,520))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(116),m4h2x4x4(:,113),heltab3x32(:,:,521))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[28,3],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf4(:,9),G0H4(117),m4h2x4x4(:,114),heltab3x32(:,:,522))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[27,4],[0,0],3,1,wf8(:,22))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,22),G0H2(82),m4h2x8x2(:,55),heltab3x32(:,:,523))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[27,4],[0,0],3,1,wf8(:,23))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,23),G0H2(83),m4h2x8x2(:,56),heltab3x32(:,:,524))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[27,4],[0,0],3,1,wf8(:,24))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),wf8(:,24),G0H2(84),m4h2x8x2(:,57),heltab3x32(:,:,525))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[27,4],[0,0],3,1,wf8(:,22))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,22),ex4(:),G0H2(85),m4h8x2x2(:,28),heltab3x32(:,:,526))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[27,4],[0,0],3,1,wf8(:,23))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,23),ex4(:),G0H2(86),m4h8x2x2(:,29),heltab3x32(:,:,527))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[27,4],[0,0],3,1,wf8(:,24))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,24),ex4(:),G0H2(87),m4h8x2x2(:,30),heltab3x32(:,:,528))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[27,4],[0,0],3,1,wf8(:,22))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,22),G0H2(88),m4h2x8x2(:,58),heltab3x32(:,:,529))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[27,4],[0,0],3,1,wf8(:,23))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,23),G0H2(89),m4h2x8x2(:,59),heltab3x32(:,:,530))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1053),h0tab(:,1053),[27,4],[0,0],3,1,wf8(:,24))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex4(:),wf8(:,24),G0H2(90),m4h2x8x2(:,60),heltab3x32(:,:,531))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1054),h0tab(:,1054),[23,8],[0,0],3,1,wf8(:,28))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,28),G0H2(91),m4h2x8x2(:,61),heltab3x32(:,:,532))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1055),h0tab(:,1055),[23,8],[0,0],3,1,wf8(:,29))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,29),G0H2(92),m4h2x8x2(:,62),heltab3x32(:,:,533))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1056),h0tab(:,1056),[23,8],[0,0],3,1,wf8(:,30))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf8(:,30),G0H2(93),m4h2x8x2(:,63),heltab3x32(:,:,534))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1057),h0tab(:,1057),[23,8],[0,0],3,1,wf8(:,28))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,28),ex5(:),G0H2(94),m4h8x2x2(:,31),heltab3x32(:,:,535))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1058),h0tab(:,1058),[23,8],[0,0],3,1,wf8(:,29))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,29),ex5(:),G0H2(95),m4h8x2x2(:,32),heltab3x32(:,:,536))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1059),h0tab(:,1059),[23,8],[0,0],3,1,wf8(:,30))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,30),ex5(:),G0H2(96),m4h8x2x2(:,33),heltab3x32(:,:,537))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1060),h0tab(:,1060),[23,8],[0,0],3,1,wf8(:,28))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,28),G0H2(97),m4h2x8x2(:,64),heltab3x32(:,:,538))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1061),h0tab(:,1061),[23,8],[0,0],3,1,wf8(:,29))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,29),G0H2(98),m4h2x8x2(:,65),heltab3x32(:,:,539))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1062),h0tab(:,1062),[23,8],[0,0],3,1,wf8(:,30))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf8(:,30),G0H2(99),m4h2x8x2(:,66),heltab3x32(:,:,540))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1063),h0tab(:,1063),[16,15],[0,0],3,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,307),heltab2x32(:,:,523))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1064),h0tab(:,1064),[16,15],[0,0],3,1,wf8(:,29))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,308),heltab2x32(:,:,524))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1065),h0tab(:,1065),[16,15],[0,0],3,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,309),heltab2x32(:,:,525))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1066),h0tab(:,1066),[16,15],[0,0],3,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,310),heltab2x32(:,:,526))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1067),h0tab(:,1067),[16,15],[0,0],3,1,wf8(:,29))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,311),heltab2x32(:,:,527))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1068),h0tab(:,1068),[16,15],[0,0],3,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,312),heltab2x32(:,:,528))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1069),h0tab(:,1069),[16,15],[0,0],3,1,wf8(:,28))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,313),heltab2x32(:,:,529))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1070),h0tab(:,1070),[16,15],[0,0],3,1,wf8(:,29))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,314),heltab2x32(:,:,530))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1071),h0tab(:,1071),[16,15],[0,0],3,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,315),heltab2x32(:,:,531))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1072),h0tab(:,1072),[24,7],[0,0],3,1,wf8(:,28))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(18),m4h2x2x8(:,271),heltab3x32(:,:,541))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1073),h0tab(:,1073),[24,7],[0,0],3,1,wf8(:,29))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,272),heltab3x32(:,:,542))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1074),h0tab(:,1074),[24,7],[0,0],3,1,wf8(:,30))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,273),heltab3x32(:,:,543))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1075),h0tab(:,1075),[24,7],[0,0],3,1,wf8(:,28))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(17),m4h2x2x8(:,274),heltab3x32(:,:,544))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1076),h0tab(:,1076),[24,7],[0,0],3,1,wf8(:,29))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(8),m4h2x2x8(:,275),heltab3x32(:,:,545))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1077),h0tab(:,1077),[24,7],[0,0],3,1,wf8(:,30))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(5),m4h2x2x8(:,276),heltab3x32(:,:,546))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1078),h0tab(:,1078),[24,7],[0,0],3,1,wf8(:,28))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(16),m4h2x2x8(:,277),heltab3x32(:,:,547))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1079),h0tab(:,1079),[24,7],[0,0],3,1,wf8(:,29))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,278),heltab3x32(:,:,548))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1080),h0tab(:,1080),[24,7],[0,0],3,1,wf8(:,30))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,279),heltab3x32(:,:,549))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1081),h0tab(:,1081),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(118),m4h2x4x4(:,115),heltab3x32(:,:,550))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1082),h0tab(:,1082),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(119),m4h2x4x4(:,116),heltab3x32(:,:,551))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1083),h0tab(:,1083),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(120),m4h2x4x4(:,117),heltab3x32(:,:,552))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1084),h0tab(:,1084),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex3(:),G0H4(121),m4h4x2x4(:,58),heltab3x32(:,:,553))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1085),h0tab(:,1085),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex3(:),G0H4(122),m4h4x2x4(:,59),heltab3x32(:,:,554))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1086),h0tab(:,1086),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex3(:),G0H4(123),m4h4x2x4(:,60),heltab3x32(:,:,555))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1087),h0tab(:,1087),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(124),m4h2x4x4(:,118),heltab3x32(:,:,556))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1088),h0tab(:,1088),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(125),m4h2x4x4(:,119),heltab3x32(:,:,557))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1089),h0tab(:,1089),[28,3],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf4(:,10),G0H4(126),m4h2x4x4(:,120),heltab3x32(:,:,558))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1090),h0tab(:,1090),[23,8],[0,0],3,1,wf8(:,22))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,22),G0H2(100),m4h2x8x2(:,67),heltab3x32(:,:,559))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1091),h0tab(:,1091),[23,8],[0,0],3,1,wf8(:,23))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,23),G0H2(101),m4h2x8x2(:,68),heltab3x32(:,:,560))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1092),h0tab(:,1092),[23,8],[0,0],3,1,wf8(:,24))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),wf8(:,24),G0H2(102),m4h2x8x2(:,69),heltab3x32(:,:,561))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1093),h0tab(:,1093),[23,8],[0,0],3,1,wf8(:,22))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,22),ex3(:),G0H2(103),m4h8x2x2(:,34),heltab3x32(:,:,562))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1094),h0tab(:,1094),[23,8],[0,0],3,1,wf8(:,23))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,23),ex3(:),G0H2(104),m4h8x2x2(:,35),heltab3x32(:,:,563))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1095),h0tab(:,1095),[23,8],[0,0],3,1,wf8(:,24))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,24),ex3(:),G0H2(105),m4h8x2x2(:,36),heltab3x32(:,:,564))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1096),h0tab(:,1096),[23,8],[0,0],3,1,wf8(:,22))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,22),G0H2(106),m4h2x8x2(:,70),heltab3x32(:,:,565))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1097),h0tab(:,1097),[23,8],[0,0],3,1,wf8(:,23))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,23),G0H2(107),m4h2x8x2(:,71),heltab3x32(:,:,566))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1098),h0tab(:,1098),[23,8],[0,0],3,1,wf8(:,24))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex3(:),wf8(:,24),G0H2(108),m4h2x8x2(:,72),heltab3x32(:,:,567))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1099),h0tab(:,1099),[16,15],[0,0],3,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,316),heltab2x32(:,:,532))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1100),h0tab(:,1100),[16,15],[0,0],3,1,wf8(:,26))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,317),heltab2x32(:,:,533))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1101),h0tab(:,1101),[16,15],[0,0],3,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,318),heltab2x32(:,:,534))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1102),h0tab(:,1102),[16,15],[0,0],3,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,319),heltab2x32(:,:,535))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1103),h0tab(:,1103),[16,15],[0,0],3,1,wf8(:,26))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,320),heltab2x32(:,:,536))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1104),h0tab(:,1104),[16,15],[0,0],3,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,321),heltab2x32(:,:,537))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1105),h0tab(:,1105),[16,15],[0,0],3,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,322),heltab2x32(:,:,538))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1106),h0tab(:,1106),[16,15],[0,0],3,1,wf8(:,26))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,323),heltab2x32(:,:,539))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1107),h0tab(:,1107),[16,15],[0,0],3,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,324),heltab2x32(:,:,540))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1108),h0tab(:,1108),[20,11],[0,0],3,1,wf8(:,25))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(61),m4h2x2x8(:,280),heltab3x32(:,:,568))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1109),h0tab(:,1109),[20,11],[0,0],3,1,wf8(:,26))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(58),m4h2x2x8(:,281),heltab3x32(:,:,569))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1110),h0tab(:,1110),[20,11],[0,0],3,1,wf8(:,27))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(55),m4h2x2x8(:,282),heltab3x32(:,:,570))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1111),h0tab(:,1111),[20,11],[0,0],3,1,wf8(:,25))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(62),m4h2x2x8(:,283),heltab3x32(:,:,571))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1112),h0tab(:,1112),[20,11],[0,0],3,1,wf8(:,26))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(59),m4h2x2x8(:,284),heltab3x32(:,:,572))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1113),h0tab(:,1113),[20,11],[0,0],3,1,wf8(:,27))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(56),m4h2x2x8(:,285),heltab3x32(:,:,573))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1114),h0tab(:,1114),[20,11],[0,0],3,1,wf8(:,25))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(63),m4h2x2x8(:,286),heltab3x32(:,:,574))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1115),h0tab(:,1115),[20,11],[0,0],3,1,wf8(:,26))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(60),m4h2x2x8(:,287),heltab3x32(:,:,575))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1116),h0tab(:,1116),[20,11],[0,0],3,1,wf8(:,27))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(57),m4h2x2x8(:,288),heltab3x32(:,:,576))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1117),h0tab(:,1117),[19,12],[0,0],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(210),m3h8x4(:,109),heltab2x32(:,:,541))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1118),h0tab(:,1118),[19,12],[0,0],3,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(215),m3h8x4(:,110),heltab2x32(:,:,542))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1119),h0tab(:,1119),[19,12],[0,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(216),m3h8x4(:,111),heltab2x32(:,:,543))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1120),h0tab(:,1120),[19,12],[0,0],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(219),m3h8x4(:,112),heltab2x32(:,:,544))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1121),h0tab(:,1121),[19,12],[0,0],3,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(221),m3h8x4(:,113),heltab2x32(:,:,545))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1122),h0tab(:,1122),[19,12],[0,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(224),m3h8x4(:,114),heltab2x32(:,:,546))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1123),h0tab(:,1123),[19,12],[0,0],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(226),m3h8x4(:,115),heltab2x32(:,:,547))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1124),h0tab(:,1124),[19,12],[0,0],3,1,wf8(:,23))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(231),m3h8x4(:,116),heltab2x32(:,:,548))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1125),h0tab(:,1125),[19,12],[0,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(236),m3h8x4(:,117),heltab2x32(:,:,549))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(25,:)%j+M(26,:)%j-M(30,:)%j+M(36,:)%j+M(42,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1126),h0tab(:,1126),[28,3],[0,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),28,G1H4(232),m3h8x4(:,118),heltab2x32(:,:,550))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1127),h0tab(:,1127),[28,3],[0,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),28,G1H4(237),m3h8x4(:,119),heltab2x32(:,:,551))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j-M(42,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1128),h0tab(:,1128),[28,3],[0,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),28,G1H4(240),m3h8x4(:,120),heltab2x32(:,:,552))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(24,:)%j-M(26,:)%j+M(30,:)%j-M(32,:)%j-M(38,:)%j+M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1129),h0tab(:,1129),[28,3],[0,0],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),28,G1H4(241),m3h8x4(:,121),heltab2x32(:,:,553))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1130),h0tab(:,1130),[28,3],[0,0],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),28,G1H4(242),m3h8x4(:,122),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(22,:)%j-M(24,:)%j+M(26,:)%j-M(30,:)%j+M(32,:)%j+M(38,:)%j-M(44,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1131),h0tab(:,1131),[28,3],[0,0],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),28,G1H4(252),m3h8x4(:,123),heltab2x32(:,:,555))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(23,:)%j-M(24,:)%j+M(25,:)%j+M(32,:)%j-M(36,:)%j+M(38,:)%j-M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1132),h0tab(:,1132),[28,3],[0,0],3,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,3),28,G1H4(248),m3h8x4(:,124),heltab2x32(:,:,556))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1133),h0tab(:,1133),[28,3],[0,0],3,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,3),28,G1H4(251),m3h8x4(:,125),heltab2x32(:,:,557))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(23,:)%j+M(24,:)%j-M(25,:)%j-M(32,:)%j+M(36,:)%j-M(38,:)%j+M(42,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1134),h0tab(:,1134),[28,3],[0,0],3,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,3),28,G1H4(253),m3h8x4(:,126),heltab2x32(:,:,558))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1135),h0tab(:,1135),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(70),m4h2x2x8(:,289),heltab3x32(:,:,577))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1136),h0tab(:,1136),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(67),m4h2x2x8(:,290),heltab3x32(:,:,578))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1137),h0tab(:,1137),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(64),m4h2x2x8(:,291),heltab3x32(:,:,579))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1138),h0tab(:,1138),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(71),m4h2x2x8(:,292),heltab3x32(:,:,580))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1139),h0tab(:,1139),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(68),m4h2x2x8(:,293),heltab3x32(:,:,581))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1140),h0tab(:,1140),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(65),m4h2x2x8(:,294),heltab3x32(:,:,582))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(23,:)%j-M(29,:)%j+M(35,:)%j-M(39,:)%j+M(40,:)%j+M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1141),h0tab(:,1141),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(72),m4h2x2x8(:,295),heltab3x32(:,:,583))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1142),h0tab(:,1142),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(69),m4h2x2x8(:,296),heltab3x32(:,:,584))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(23,:)%j+M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j-M(42,:)%j+M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1143),h0tab(:,1143),[17,14],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(66),m4h2x2x8(:,297),heltab3x32(:,:,585))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1144),h0tab(:,1144),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(97),m4h2x2x8(:,298),heltab3x32(:,:,586))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1145),h0tab(:,1145),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(94),m4h2x2x8(:,299),heltab3x32(:,:,587))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1146),h0tab(:,1146),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(91),m4h2x2x8(:,300),heltab3x32(:,:,588))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1147),h0tab(:,1147),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(98),m4h2x2x8(:,301),heltab3x32(:,:,589))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1148),h0tab(:,1148),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(95),m4h2x2x8(:,302),heltab3x32(:,:,590))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1149),h0tab(:,1149),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(92),m4h2x2x8(:,303),heltab3x32(:,:,591))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1150),h0tab(:,1150),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(99),m4h2x2x8(:,304),heltab3x32(:,:,592))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1151),h0tab(:,1151),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(96),m4h2x2x8(:,305),heltab3x32(:,:,593))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1152),h0tab(:,1152),[18,13],[0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(93),m4h2x2x8(:,306),heltab3x32(:,:,594))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1153),h0tab(:,1153),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(127),m4h2x4x4(:,121),heltab3x32(:,:,595))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1154),h0tab(:,1154),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(128),m4h2x4x4(:,122),heltab3x32(:,:,596))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1155),h0tab(:,1155),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(129),m4h2x4x4(:,123),heltab3x32(:,:,597))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1156),h0tab(:,1156),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex2(:),G0H4(130),m4h4x2x4(:,61),heltab3x32(:,:,598))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1157),h0tab(:,1157),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex2(:),G0H4(131),m4h4x2x4(:,62),heltab3x32(:,:,599))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1158),h0tab(:,1158),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex2(:),G0H4(132),m4h4x2x4(:,63),heltab3x32(:,:,600))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1159),h0tab(:,1159),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(133),m4h2x4x4(:,124),heltab3x32(:,:,601))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1160),h0tab(:,1160),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(134),m4h2x4x4(:,125),heltab3x32(:,:,602))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1161),h0tab(:,1161),[22,9],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,9),G0H4(135),m4h2x4x4(:,126),heltab3x32(:,:,603))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1162),h0tab(:,1162),[27,4],[0,0],3,1,wf8(:,13))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,13),G0H2(109),m4h2x8x2(:,73),heltab3x32(:,:,604))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1163),h0tab(:,1163),[27,4],[0,0],3,1,wf8(:,14))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,14),G0H2(110),m4h2x8x2(:,74),heltab3x32(:,:,605))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(27,:)%j+M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1164),h0tab(:,1164),[27,4],[0,0],3,1,wf8(:,15))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,15),G0H2(111),m4h2x8x2(:,75),heltab3x32(:,:,606))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1165),h0tab(:,1165),[27,4],[0,0],3,1,wf8(:,13))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,13),ex2(:),G0H2(112),m4h8x2x2(:,37),heltab3x32(:,:,607))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1166),h0tab(:,1166),[27,4],[0,0],3,1,wf8(:,14))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,14),ex2(:),G0H2(113),m4h8x2x2(:,38),heltab3x32(:,:,608))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1167),h0tab(:,1167),[27,4],[0,0],3,1,wf8(:,15))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,15),ex2(:),G0H2(114),m4h8x2x2(:,39),heltab3x32(:,:,609))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1168),h0tab(:,1168),[27,4],[0,0],3,1,wf8(:,13))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,13),G0H2(115),m4h2x8x2(:,76),heltab3x32(:,:,610))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1169),h0tab(:,1169),[27,4],[0,0],3,1,wf8(:,14))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,14),G0H2(116),m4h2x8x2(:,77),heltab3x32(:,:,611))
  Gcoeff(:)%j = (c(3)*(M(21,:)%j-M(27,:)%j-M(33,:)%j+M(35,:)%j-M(39,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1170),h0tab(:,1170),[27,4],[0,0],3,1,wf8(:,15))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,15),G0H2(117),m4h2x8x2(:,78),heltab3x32(:,:,612))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1171),h0tab(:,1171),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(136),m4h2x4x4(:,127),heltab3x32(:,:,613))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1172),h0tab(:,1172),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex1(:),G0H4(137),m4h4x2x4(:,64),heltab3x32(:,:,614))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1173),h0tab(:,1173),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(138),m4h2x4x4(:,128),heltab3x32(:,:,615))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1174),h0tab(:,1174),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(139),m4h2x4x4(:,129),heltab3x32(:,:,616))
  Gcoeff(:)%j = (c(1)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(2)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1175),h0tab(:,1175),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex1(:),G0H4(140),m4h4x2x4(:,65),heltab3x32(:,:,617))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1176),h0tab(:,1176),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(141),m4h2x4x4(:,130),heltab3x32(:,:,618))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1177),h0tab(:,1177),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(142),m4h2x4x4(:,131),heltab3x32(:,:,619))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1178),h0tab(:,1178),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,9),ex1(:),G0H4(143),m4h4x2x4(:,66),heltab3x32(:,:,620))
  Gcoeff(:)%j = (c(3)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1179),h0tab(:,1179),[21,10],[0,0],4,1,wf4(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,9),G0H4(144),m4h2x4x4(:,132),heltab3x32(:,:,621))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1180),h0tab(:,1180),[27,4],[0,0],3,1,wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,4),G0H2(118),m4h2x8x2(:,79),heltab3x32(:,:,622))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1181),h0tab(:,1181),[27,4],[0,0],3,1,wf8(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,4),ex1(:),G0H2(119),m4h8x2x2(:,40),heltab3x32(:,:,623))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1182),h0tab(:,1182),[27,4],[0,0],3,1,wf8(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,4),G0H2(120),m4h2x8x2(:,80),heltab3x32(:,:,624))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1183),h0tab(:,1183),[27,4],[0,0],3,1,wf8(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,5),G0H2(121),m4h2x8x2(:,81),heltab3x32(:,:,625))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1184),h0tab(:,1184),[27,4],[0,0],3,1,wf8(:,5))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,5),ex1(:),G0H2(122),m4h8x2x2(:,41),heltab3x32(:,:,626))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1185),h0tab(:,1185),[27,4],[0,0],3,1,wf8(:,5))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,5),G0H2(123),m4h2x8x2(:,82),heltab3x32(:,:,627))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1186),h0tab(:,1186),[27,4],[0,0],3,1,wf8(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,6),G0H2(124),m4h2x8x2(:,83),heltab3x32(:,:,628))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1187),h0tab(:,1187),[27,4],[0,0],3,1,wf8(:,6))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,6),ex1(:),G0H2(125),m4h8x2x2(:,42),heltab3x32(:,:,629))
  Gcoeff(:)%j = (c(3)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1188),h0tab(:,1188),[27,4],[0,0],3,1,wf8(:,6))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,6),G0H2(126),m4h2x8x2(:,84),heltab3x32(:,:,630))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1189),h0tab(:,1189),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(145),m4h2x4x4(:,133),heltab3x32(:,:,631))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1190),h0tab(:,1190),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(146),m4h2x4x4(:,134),heltab3x32(:,:,632))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1191),h0tab(:,1191),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(147),m4h2x4x4(:,135),heltab3x32(:,:,633))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1192),h0tab(:,1192),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex2(:),G0H4(148),m4h4x2x4(:,67),heltab3x32(:,:,634))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1193),h0tab(:,1193),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex2(:),G0H4(149),m4h4x2x4(:,68),heltab3x32(:,:,635))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1194),h0tab(:,1194),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex2(:),G0H4(150),m4h4x2x4(:,69),heltab3x32(:,:,636))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1195),h0tab(:,1195),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(151),m4h2x4x4(:,136),heltab3x32(:,:,637))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1196),h0tab(:,1196),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(152),m4h2x4x4(:,137),heltab3x32(:,:,638))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1197),h0tab(:,1197),[26,5],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf4(:,10),G0H4(153),m4h2x4x4(:,138),heltab3x32(:,:,639))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1198),h0tab(:,1198),[23,8],[0,0],3,1,wf8(:,16))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,16),G0H2(127),m4h2x8x2(:,85),heltab3x32(:,:,640))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1199),h0tab(:,1199),[23,8],[0,0],3,1,wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,17),G0H2(128),m4h2x8x2(:,86),heltab3x32(:,:,641))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1200),h0tab(:,1200),[23,8],[0,0],3,1,wf8(:,18))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),wf8(:,18),G0H2(129),m4h2x8x2(:,87),heltab3x32(:,:,642))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1201),h0tab(:,1201),[23,8],[0,0],3,1,wf8(:,16))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,16),ex2(:),G0H2(130),m4h8x2x2(:,43),heltab3x32(:,:,643))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1202),h0tab(:,1202),[23,8],[0,0],3,1,wf8(:,17))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,17),ex2(:),G0H2(131),m4h8x2x2(:,44),heltab3x32(:,:,644))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1203),h0tab(:,1203),[23,8],[0,0],3,1,wf8(:,18))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,18),ex2(:),G0H2(132),m4h8x2x2(:,45),heltab3x32(:,:,645))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1204),h0tab(:,1204),[23,8],[0,0],3,1,wf8(:,16))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,16),G0H2(133),m4h2x8x2(:,88),heltab3x32(:,:,646))
  Gcoeff(:)%j = (c(3)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1205),h0tab(:,1205),[23,8],[0,0],3,1,wf8(:,17))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,17),G0H2(134),m4h2x8x2(:,89),heltab3x32(:,:,647))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1206),h0tab(:,1206),[23,8],[0,0],3,1,wf8(:,18))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex2(:),wf8(:,18),G0H2(135),m4h2x8x2(:,90),heltab3x32(:,:,648))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1207),h0tab(:,1207),[16,15],[0,0],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,325),heltab2x32(:,:,559))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1208),h0tab(:,1208),[16,15],[0,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,326),heltab2x32(:,:,560))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1209),h0tab(:,1209),[16,15],[0,0],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,327),heltab2x32(:,:,561))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1210),h0tab(:,1210),[16,15],[0,0],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,328),heltab2x32(:,:,562))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1211),h0tab(:,1211),[16,15],[0,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,329),heltab2x32(:,:,563))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1212),h0tab(:,1212),[16,15],[0,0],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,330),heltab2x32(:,:,564))
  Gcoeff(:)%j = (c(3)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1213),h0tab(:,1213),[16,15],[0,0],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,331),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1214),h0tab(:,1214),[16,15],[0,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,332),heltab2x32(:,:,566))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1215),h0tab(:,1215),[16,15],[0,0],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,333),heltab2x32(:,:,567))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1216),h0tab(:,1216),[18,13],[0,0],3,1,wf8(:,19))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(102),m4h2x2x8(:,307),heltab3x32(:,:,649))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j-M(36,:)%j-M(39,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1217),h0tab(:,1217),[18,13],[0,0],3,1,wf8(:,20))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(101),m4h2x2x8(:,308),heltab3x32(:,:,650))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1218),h0tab(:,1218),[18,13],[0,0],3,1,wf8(:,21))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(100),m4h2x2x8(:,309),heltab3x32(:,:,651))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1219),h0tab(:,1219),[18,13],[0,0],3,1,wf8(:,19))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(105),m4h2x2x8(:,310),heltab3x32(:,:,652))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1220),h0tab(:,1220),[18,13],[0,0],3,1,wf8(:,20))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(104),m4h2x2x8(:,311),heltab3x32(:,:,653))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1221),h0tab(:,1221),[18,13],[0,0],3,1,wf8(:,21))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(103),m4h2x2x8(:,312),heltab3x32(:,:,654))
  Gcoeff(:)%j = (c(3)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1222),h0tab(:,1222),[18,13],[0,0],3,1,wf8(:,19))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(108),m4h2x2x8(:,313),heltab3x32(:,:,655))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j+M(36,:)%j+M(39,:)%j-M(40,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1223),h0tab(:,1223),[18,13],[0,0],3,1,wf8(:,20))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(107),m4h2x2x8(:,314),heltab3x32(:,:,656))
  Gcoeff(:)%j = (c(3)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1224),h0tab(:,1224),[18,13],[0,0],3,1,wf8(:,21))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(106),m4h2x2x8(:,315),heltab3x32(:,:,657))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1225),h0tab(:,1225),[21,10],[0,0],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),21,G1H4(257),m3h8x4(:,127),heltab2x32(:,:,568))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(24,:)%j-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j+M(41,:)%j-M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1226),h0tab(:,1226),[21,10],[0,0],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),21,G1H4(258),m3h8x4(:,128),heltab2x32(:,:,569))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(27,:)%j-M(29,:)%j+M(33,:)%j+M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1227),h0tab(:,1227),[21,10],[0,0],3,1,wf8(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,18),21,G1H4(263),m3h8x4(:,129),heltab2x32(:,:,570))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1228),h0tab(:,1228),[21,10],[0,0],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),21,G1H4(268),m3h8x4(:,130),heltab2x32(:,:,571))
  Gcoeff(:)%j = (c(2)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1229),h0tab(:,1229),[21,10],[0,0],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),21,G1H4(267),m3h8x4(:,131),heltab2x32(:,:,572))
  Gcoeff(:)%j = (c(2)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1230),h0tab(:,1230),[21,10],[0,0],3,1,wf8(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,18),21,G1H4(269),m3h8x4(:,132),heltab2x32(:,:,573))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1231),h0tab(:,1231),[21,10],[0,0],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),21,G1H4(272),m3h8x4(:,133),heltab2x32(:,:,574))
  Gcoeff(:)%j = (c(3)*(-M(23,:)%j+M(24,:)%j+M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j-M(41,:)%j+M(42,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1232),h0tab(:,1232),[21,10],[0,0],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),21,G1H4(273),m3h8x4(:,134),heltab2x32(:,:,575))
  Gcoeff(:)%j = (c(3)*(M(23,:)%j-M(27,:)%j+M(29,:)%j-M(33,:)%j-M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1233),h0tab(:,1233),[21,10],[0,0],3,1,wf8(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,18),21,G1H4(279),m3h8x4(:,135),heltab2x32(:,:,576))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(27,:)%j-M(29,:)%j-M(31,:)%j+M(32,:)%j+M(34,:)%j+M(40,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1234),h0tab(:,1234),[26,5],[0,0],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,4),26,G1H4(284),m3h8x4(:,136),heltab2x32(:,:,577))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1235),h0tab(:,1235),[26,5],[0,0],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,4),26,G1H4(280),m3h8x4(:,137),heltab2x32(:,:,578))
  Gcoeff(:)%j = (c(3)*(M(24,:)%j-M(27,:)%j+M(29,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j-M(40,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1236),h0tab(:,1236),[26,5],[0,0],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,4),26,G1H4(283),m3h8x4(:,138),heltab2x32(:,:,579))
  Gcoeff(:)%j = (c(2)*(M(24,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j+M(30,:)%j-M(32,:)%j-M(37,:)%j+M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1237),h0tab(:,1237),[26,5],[0,0],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),26,G1H4(288),m3h8x4(:,139),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(2)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1238),h0tab(:,1238),[26,5],[0,0],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),26,G1H4(289),m3h8x4(:,140),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(3)*(-M(24,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j-M(30,:)%j+M(32,:)%j+M(37,:)%j-M(43,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1239),h0tab(:,1239),[26,5],[0,0],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),26,G1H4(290),m3h8x4(:,141),heltab2x32(:,:,582))
  Gcoeff(:)%j = (c(2)*(M(26,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(34,:)%j+M(37,:)%j-M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1240),h0tab(:,1240),[26,5],[0,0],3,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),26,G1H4(295),m3h8x4(:,142),heltab2x32(:,:,583))
  Gcoeff(:)%j = (c(2)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1241),h0tab(:,1241),[26,5],[0,0],3,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),26,G1H4(296),m3h8x4(:,143),heltab2x32(:,:,584))
  Gcoeff(:)%j = (c(3)*(-M(26,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(34,:)%j-M(37,:)%j+M(40,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1242),h0tab(:,1242),[26,5],[0,0],3,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),26,G1H4(299),m3h8x4(:,144),heltab2x32(:,:,585))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1243),h0tab(:,1243),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(154),m4h2x4x4(:,139),heltab3x32(:,:,658))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1244),h0tab(:,1244),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex1(:),G0H4(155),m4h4x2x4(:,70),heltab3x32(:,:,659))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1245),h0tab(:,1245),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(156),m4h2x4x4(:,140),heltab3x32(:,:,660))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1246),h0tab(:,1246),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(157),m4h2x4x4(:,141),heltab3x32(:,:,661))
  Gcoeff(:)%j = (c(1)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(2)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1247),h0tab(:,1247),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex1(:),G0H4(158),m4h4x2x4(:,71),heltab3x32(:,:,662))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1248),h0tab(:,1248),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(159),m4h2x4x4(:,142),heltab3x32(:,:,663))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1249),h0tab(:,1249),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(160),m4h2x4x4(:,143),heltab3x32(:,:,664))
  Gcoeff(:)%j = (c(2)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1250),h0tab(:,1250),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,10),ex1(:),G0H4(161),m4h4x2x4(:,72),heltab3x32(:,:,665))
  Gcoeff(:)%j = (c(3)*(-M(21,:)%j+M(22,:)%j+M(27,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j-M(43,:)%j+M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1251),h0tab(:,1251),[25,6],[0,0],4,1,wf4(:,10))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf4(:,10),G0H4(162),m4h2x4x4(:,144),heltab3x32(:,:,666))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(28,:)%j+M(33,:)%j-M(35,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1252),h0tab(:,1252),[23,8],[0,0],3,1,wf8(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,7),G0H2(136),m4h2x8x2(:,91),heltab3x32(:,:,667))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1253),h0tab(:,1253),[23,8],[0,0],3,1,wf8(:,7))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,7),ex1(:),G0H2(137),m4h8x2x2(:,46),heltab3x32(:,:,668))
  Gcoeff(:)%j = (c(3)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1254),h0tab(:,1254),[23,8],[0,0],3,1,wf8(:,7))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,7),G0H2(138),m4h2x8x2(:,92),heltab3x32(:,:,669))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(25,:)%j-M(31,:)%j-M(33,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j+M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1255),h0tab(:,1255),[23,8],[0,0],3,1,wf8(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,8),G0H2(139),m4h2x8x2(:,93),heltab3x32(:,:,670))
  Gcoeff(:)%j = (c(2)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1256),h0tab(:,1256),[23,8],[0,0],3,1,wf8(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,8),ex1(:),G0H2(140),m4h8x2x2(:,47),heltab3x32(:,:,671))
  Gcoeff(:)%j = (c(3)*(-M(22,:)%j+M(25,:)%j+M(31,:)%j+M(33,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1257),h0tab(:,1257),[23,8],[0,0],3,1,wf8(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,8),G0H2(141),m4h2x8x2(:,94),heltab3x32(:,:,672))
  Gcoeff(:)%j = (c(2)*(M(25,:)%j-M(28,:)%j+M(31,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1258),h0tab(:,1258),[23,8],[0,0],3,1,wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),wf8(:,9),G0H2(142),m4h2x8x2(:,95),heltab3x32(:,:,673))
  Gcoeff(:)%j = (c(2)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1259),h0tab(:,1259),[23,8],[0,0],3,1,wf8(:,9))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf8(:,9),ex1(:),G0H2(143),m4h8x2x2(:,48),heltab3x32(:,:,674))
  Gcoeff(:)%j = (c(3)*(-M(25,:)%j+M(28,:)%j-M(31,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(39,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1260),h0tab(:,1260),[23,8],[0,0],3,1,wf8(:,9))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex1(:),wf8(:,9),G0H2(144),m4h2x8x2(:,96),heltab3x32(:,:,675))
  Gcoeff(:)%j = (c(2)*(M(22,:)%j-M(28,:)%j-M(33,:)%j+M(35,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j+M(41,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1261),h0tab(:,1261),[25,6],[0,0],3,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,13),25,G1H4(301),m3h8x4(:,145),heltab2x32(:,:,586))
  Gcoeff(:)%j = (c(2)*(M(21,:)%j-M(22,:)%j-M(27,:)%j+M(28,:)%j-M(37,:)%j+M(38,:)%j+M(43,:)%j-M(44,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1262),h0tab(:,1262),[25,6],[0,0],3,1,wf8(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,14),25,G1H4(304),m3h8x4(:,146),heltab2x32(:,:,587))
  Gcoeff(:)%j = (c