
module ol_vamp_1_ppjjj_ggggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjjj_ggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjjj_ggggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch !, kloopmax
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjjj_ggggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppjjj_ggggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppjjj_ggggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjjj_ggggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(44,hel_states)
  integer :: kloop


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

! do kloop = 1, kloopmax
  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(11)*M(24,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(10)*M(24,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(11)*M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(10)*M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(11)*M(24,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(10)*M(24,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(11)*M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(10)*M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (-(c(11)*M(26,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(12),n2h16(9))
  Gcoeff(:)%j = (-(c(10)*M(26,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(13),n2h16(10))
  Gcoeff(:)%j = (-(c(11)*M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(11))
  Gcoeff(:)%j = (-(c(10)*M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,2,1,4,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(12))
  Gcoeff(:)%j = (-(c(11)*M(26,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(13))
  Gcoeff(:)%j = (-(c(10)*M(26,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,2,1,4,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(14))
  Gcoeff(:)%j = (-(c(11)*M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(15))
  Gcoeff(:)%j = (-(c(10)*M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,1,4,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(16))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j+M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(26,:)%j+M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(21),m3h2x16(:,21),heltab2x32(:,:,21))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,22),heltab2x32(:,:,22))
  Gcoeff(:)%j = (-(c(11)*M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(23),n2h16(17))
  Gcoeff(:)%j = (-(c(10)*M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,4,2,1,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(18))
  Gcoeff(:)%j = (-(c(11)*M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(25),n2h16(19))
  Gcoeff(:)%j = (-(c(10)*M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,4,2,1,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(26),n2h16(20))
  Gcoeff(:)%j = (-(c(11)*M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(21))
  Gcoeff(:)%j = (-(c(10)*M(22,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,4,2,1,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(22))
  Gcoeff(:)%j = (-(c(11)*M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(23))
  Gcoeff(:)%j = (-(c(10)*M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,4,2,1,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(24))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(11)*M(25,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(34),n2h16(25))
  Gcoeff(:)%j = (-(c(10)*M(25,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,2,1,8,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(35),n2h16(26))
  Gcoeff(:)%j = (-(c(11)*M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(36),n2h16(27))
  Gcoeff(:)%j = (-(c(10)*M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,2,1,8,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(37),n2h16(28))
  Gcoeff(:)%j = (-(c(11)*M(25,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(38),n2h16(29))
  Gcoeff(:)%j = (-(c(10)*M(25,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,2,1,8,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(39),n2h16(30))
  Gcoeff(:)%j = (-(c(11)*M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(40),n2h16(31))
  Gcoeff(:)%j = (-(c(10)*M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,2,1,8,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(32))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(43),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,44),heltab2x32(:,:,44))
  Gcoeff(:)%j = (-(c(11)*M(21,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(45),n2h16(33))
  Gcoeff(:)%j = (-(c(10)*M(21,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,1,2,4,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(34))
  Gcoeff(:)%j = (-(c(11)*M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(47),n2h16(35))
  Gcoeff(:)%j = (-(c(10)*M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,1,2,4,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(36))
  Gcoeff(:)%j = (-(c(11)*M(21,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(49),n2h16(37))
  Gcoeff(:)%j = (-(c(10)*M(21,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,1,2,4,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(38))
  Gcoeff(:)%j = (-(c(11)*M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(51),n2h16(39))
  Gcoeff(:)%j = (-(c(10)*M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,1,2,4,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(40))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(53),m3h2x16(:,53),heltab2x32(:,:,53))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,54),heltab2x32(:,:,54))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,55),heltab2x32(:,:,55))
  Gcoeff(:)%j = (-(c(11)*M(23,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(56),n2h16(41))
  Gcoeff(:)%j = (-(c(10)*M(23,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,2,8,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(42))
  Gcoeff(:)%j = (-(c(11)*M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(58),n2h16(43))
  Gcoeff(:)%j = (-(c(10)*M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,1,2,8,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(44))
  Gcoeff(:)%j = (-(c(11)*M(23,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(60),n2h16(45))
  Gcoeff(:)%j = (-(c(10)*M(23,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,2,8,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(61),n2h16(46))
  Gcoeff(:)%j = (-(c(11)*M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(62),n2h16(47))
  Gcoeff(:)%j = (-(c(10)*M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,2,8,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(63),n2h16(48))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(64),m3h2x16(:,64),heltab2x32(:,:,64))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,65),heltab2x32(:,:,65))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,66),heltab2x32(:,:,66))
  Gcoeff(:)%j = (-(c(11)*M(28,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(67),n2h16(49))
  Gcoeff(:)%j = (-(c(10)*M(28,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,2,4,1,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(50))
  Gcoeff(:)%j = (-(c(11)*M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(69),n2h16(51))
  Gcoeff(:)%j = (-(c(10)*M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,2,4,1,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(70),n2h16(52))
  Gcoeff(:)%j = (-(c(11)*M(28,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(71),n2h16(53))
  Gcoeff(:)%j = (-(c(10)*M(28,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,4,1,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(72),n2h16(54))
  Gcoeff(:)%j = (-(c(11)*M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(73),n2h16(55))
  Gcoeff(:)%j = (-(c(10)*M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,4,1,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(74),n2h16(56))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(75),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(28,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(76),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(11)*M(31,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(78),n2h16(57))
  Gcoeff(:)%j = (-(c(10)*M(31,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,2,8,1,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(79),n2h16(58))
  Gcoeff(:)%j = (-(c(11)*M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(80),n2h16(59))
  Gcoeff(:)%j = (-(c(10)*M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,2,8,1,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(60))
  Gcoeff(:)%j = (-(c(11)*M(31,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(82),n2h16(61))
  Gcoeff(:)%j = (-(c(10)*M(31,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,2,8,1,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(83),n2h16(62))
  Gcoeff(:)%j = (-(c(11)*M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(84),n2h16(63))
  Gcoeff(:)%j = (-(c(10)*M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,2,8,1,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(85),n2h16(64))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(86),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(11)*M(27,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(89),n2h16(65))
  Gcoeff(:)%j = (-(c(10)*M(27,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,4,2,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(90),n2h16(66))
  Gcoeff(:)%j = (-(c(11)*M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(91),n2h16(67))
  Gcoeff(:)%j = (-(c(10)*M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,1,4,2,8],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(92),n2h16(68))
  Gcoeff(:)%j = (-(c(11)*M(27,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(93),n2h16(69))
  Gcoeff(:)%j = (-(c(10)*M(27,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,1,4,2,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(94),n2h16(70))
  Gcoeff(:)%j = (-(c(11)*M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(95),n2h16(71))
  Gcoeff(:)%j = (-(c(10)*M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,1,4,2,8],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(96),n2h16(72))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(97),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(98),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (-(c(11)*M(29,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(100),n2h16(73))
  Gcoeff(:)%j = (-(c(10)*M(29,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,1,4,8,2],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(101),n2h16(74))
  Gcoeff(:)%j = (-(c(11)*M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(102),n2h16(75))
  Gcoeff(:)%j = (-(c(10)*M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,1,4,8,2],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(103),n2h16(76))
  Gcoeff(:)%j = (-(c(11)*M(29,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(104),n2h16(77))
  Gcoeff(:)%j = (-(c(10)*M(29,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,1,4,8,2],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(105),n2h16(78))
  Gcoeff(:)%j = (-(c(11)*M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(106),n2h16(79))
  Gcoeff(:)%j = (-(c(10)*M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,1,4,8,2],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(107),n2h16(80))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(108),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(11)*M(33,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(111),n2h16(81))
  Gcoeff(:)%j = (-(c(10)*M(33,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,8,2,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(112),n2h16(82))
  Gcoeff(:)%j = (-(c(11)*M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(113),n2h16(83))
  Gcoeff(:)%j = (-(c(10)*M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,1,8,2,4],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(114),n2h16(84))
  Gcoeff(:)%j = (-(c(11)*M(33,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(115),n2h16(85))
  Gcoeff(:)%j = (-(c(10)*M(33,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,8,2,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(116),n2h16(86))
  Gcoeff(:)%j = (-(c(11)*M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(117),n2h16(87))
  Gcoeff(:)%j = (-(c(10)*M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,1,8,2,4],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(118),n2h16(88))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(119),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,120),heltab2x32(:,:,120))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (-(c(11)*M(35,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(122),n2h16(89))
  Gcoeff(:)%j = (-(c(10)*M(35,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,1,8,4,2],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(123),n2h16(90))
  Gcoeff(:)%j = (-(c(11)*M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(124),n2h16(91))
  Gcoeff(:)%j = (-(c(10)*M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,1,8,4,2],[nMT,nMT,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(92))
  Gcoeff(:)%j = (-(c(11)*M(35,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(126),n2h16(93))
  Gcoeff(:)%j = (-(c(10)*M(35,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,1,8,4,2],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(127),n2h16(94))
  Gcoeff(:)%j = (-(c(11)*M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(128),n2h16(95))
  Gcoeff(:)%j = (-(c(10)*M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,8,4,2],[nMB,nMB,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(129),n2h16(96))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(130),m3h2x16(:,130),heltab2x32(:,:,130))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(131),m3h2x16(:,131),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,132),heltab2x32(:,:,132))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(82),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(93),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(95),[G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G1H16(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(115),[G1H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(117),[G1H16(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(126),[G1H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(128),[G1H16(124)])
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(2))
  call Hloop_QV_A(ntryL,G1H16(7),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(3),n2h8(3))
  call Hloop_QV_A(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(6),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(5),n2h8(5))
  call Hloop_QV_A(ntryL,G1H16(8),ex3(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(6),n2h8(6))
  call Hloop_DV_C(ntryL,G1H16(9),16,ex3(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_CV_D(ntryL,G1H16(10),16,ex3(:),4,G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_UV_W(ntryL,G1H16(11),16,ex3(:),4,G2H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QV_A(ntryL,G1H16(16),ex2(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),18,0,G2H8(10),n2h8(7))
  call Hloop_QV_A(ntryL,G1H16(13),ex2(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMT,G2H8(11),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H16(18),ex2(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),18,0,G2H8(12),n2h8(9))
  call Hloop_AV_Q(ntryL,G1H16(15),ex2(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMT,G2H8(13),n2h8(10))
  call Hloop_QV_A(ntryL,G1H16(17),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMB,G2H8(14),n2h8(11))
  call Hloop_AV_Q(ntryL,G1H16(19),ex2(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMB,G2H8(15),n2h8(12))
  call Hloop_CV_D(ntryL,G1H16(20),16,ex2(:),2,G2H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_DV_C(ntryL,G1H16(21),16,ex2(:),G2H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_UV_W(ntryL,G1H16(22),16,ex2(:),2,G2H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QV_A(ntryL,G1H16(27),ex3(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(19),n2h8(13))
  call Hloop_QV_A(ntryL,G1H16(24),ex3(:),G1H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(20),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H16(29),ex3(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(21),n2h8(15))
  call Hloop_AV_Q(ntryL,G1H16(26),ex3(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(22),n2h8(16))
  call Hloop_QV_A(ntryL,G1H16(28),ex3(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(23),n2h8(17))
  call Hloop_AV_Q(ntryL,G1H16(30),ex3(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(24),n2h8(18))
  call Hloop_CV_D(ntryL,G1H16(31),16,ex3(:),4,G2H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_DV_C(ntryL,G1H16(32),16,ex3(:),G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_UV_W(ntryL,G1H16(33),16,ex3(:),4,G2H8(27),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QV_A(ntryL,G1H16(38),ex2(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(1),18,0,G2H8(28),n2h8(19))
  call Hloop_QV_A(ntryL,G1H16(35),ex2(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMT,G2H8(29),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(40),ex2(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),18,0,G2H8(30),n2h8(21))
  call Hloop_AV_Q(ntryL,G1H16(37),ex2(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMT,G2H8(31),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(39),ex2(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMB,G2H8(32),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(41),ex2(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMB,G2H8(33),n2h8(24))
  call Hloop_CV_D(ntryL,G1H16(42),16,ex2(:),2,G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_DV_C(ntryL,G1H16(43),16,ex2(:),G2H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_UV_W(ntryL,G1H16(44),16,ex2(:),2,G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AV_Q(ntryL,G1H16(49),ex1(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(1),17,0,G2H8(37),n2h8(25))
  call Hloop_AV_Q(ntryL,G1H16(46),ex1(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMT,G2H8(38),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(51),ex1(:),G1H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),17,0,G2H8(39),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(48),ex1(:),G1H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMT,G2H8(40),n2h8(28))
  call Hloop_AV_Q(ntryL,G1H16(50),ex1(:),G1H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMB,G2H8(41),n2h8(29))
  call Hloop_QV_A(ntryL,G1H16(52),ex1(:),G1H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMB,G2H8(42),n2h8(30))
  call Hloop_DV_C(ntryL,G1H16(53),16,ex1(:),G2H8(43),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_CV_D(ntryL,G1H16(54),16,ex1(:),1,G2H8(44),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_UV_W(ntryL,G1H16(55),16,ex1(:),1,G2H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AV_Q(ntryL,G1H16(60),ex1(:),G1H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),17,0,G2H8(46),n2h8(31))
  call Hloop_AV_Q(ntryL,G1H16(57),ex1(:),G1H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMT,G2H8(47),n2h8(32))
  call Hloop_QV_A(ntryL,G1H16(62),ex1(:),G1H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(1),17,0,G2H8(48),n2h8(33))
  call Hloop_QV_A(ntryL,G1H16(59),ex1(:),G1H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMT,G2H8(49),n2h8(34))
  call Hloop_AV_Q(ntryL,G1H16(61),ex1(:),G1H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMB,G2H8(50),n2h8(35))
  call Hloop_QV_A(ntryL,G1H16(63),ex1(:),G1H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMB,G2H8(51),n2h8(36))
  call Hloop_DV_C(ntryL,G1H16(64),16,ex1(:),G2H8(52),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_CV_D(ntryL,G1H16(65),16,ex1(:),1,G2H8(53),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_UV_W(ntryL,G1H16(66),16,ex1(:),1,G2H8(54),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_QV_A(ntryL,G1H16(71),ex2(:),G1H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),18,0,G2H8(55),n2h8(37))
  call Hloop_QV_A(ntryL,G1H16(68),ex2(:),G1H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMT,G2H8(56),n2h8(38))
  call Hloop_AV_Q(ntryL,G1H16(73),ex2(:),G1H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(1),18,0,G2H8(57),n2h8(39))
  call Hloop_AV_Q(ntryL,G1H16(70),ex2(:),G1H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMT,G2H8(58),n2h8(40))
  call Hloop_QV_A(ntryL,G1H16(72),ex2(:),G1H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMB,G2H8(59),n2h8(41))
  call Hloop_AV_Q(ntryL,G1H16(74),ex2(:),G1H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMB,G2H8(60),n2h8(42))
  call Hloop_CV_D(ntryL,G1H16(75),16,ex2(:),2,G2H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_DV_C(ntryL,G1H16(76),16,ex2(:),G2H8(62),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_UV_W(ntryL,G1H16(77),16,ex2(:),2,G2H8(63),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AV_Q(ntryL,G1H16(82),ex2(:),G1H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),18,0,G2H8(64),n2h8(43))
  call Hloop_AV_Q(ntryL,G1H16(79),ex2(:),G1H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMT,G2H8(65),n2h8(44))
  call Hloop_QV_A(ntryL,G1H16(84),ex2(:),G1H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),18,0,G2H8(66),n2h8(45))
  call Hloop_QV_A(ntryL,G1H16(81),ex2(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMT,G2H8(67),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(83),ex2(:),G1H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(1),18,nMB,G2H8(68),n2h8(47))
  call Hloop_QV_A(ntryL,G1H16(85),ex2(:),G1H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(1),18,nMB,G2H8(69),n2h8(48))
  call Hloop_DV_C(ntryL,G1H16(86),16,ex2(:),G2H8(70),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_CV_D(ntryL,G1H16(87),16,ex2(:),2,G2H8(71),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_UV_W(ntryL,G1H16(88),16,ex2(:),2,G2H8(72),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_AV_Q(ntryL,G1H16(93),ex1(:),G1H8(1),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(1),17,0,G2H8(73),n2h8(49))
  call Hloop_AV_Q(ntryL,G1H16(90),ex1(:),G1H8(1),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMT,G2H8(74),n2h8(50))
  call Hloop_QV_A(ntryL,G1H16(95),ex1(:),G1H8(1),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(1),17,0,G2H8(75),n2h8(51))
  call Hloop_QV_A(ntryL,G1H16(92),ex1(:),G1H8(1),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMT,G2H8(76),n2h8(52))
  call Hloop_AV_Q(ntryL,G1H16(94),ex1(:),G1H8(1),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMB,G2H8(77),n2h8(53))
  call Hloop_QV_A(ntryL,G1H16(96),ex1(:),G1H8(1),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMB,G2H8(78),n2h8(54))
  call Hloop_DV_C(ntryL,G1H16(97),16,ex1(:),G2H8(79),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_CV_D(ntryL,G1H16(98),16,ex1(:),1,G2H8(80),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_UV_W(ntryL,G1H16(99),16,ex1(:),1,G2H8(81),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_AV_Q(ntryL,G1H16(104),ex1(:),G1H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(1),17,0,G2H8(82),n2h8(55))
  call Hloop_AV_Q(ntryL,G1H16(101),ex1(:),G1H8(1),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMT,G2H8(83),n2h8(56))
  call Hloop_QV_A(ntryL,G1H16(106),ex1(:),G1H8(1),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(1),17,0,G2H8(84),n2h8(57))
  call Hloop_QV_A(ntryL,G1H16(103),ex1(:),G1H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMT,G2H8(85),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H16(105),ex1(:),G1H8(1),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMB,G2H8(86),n2h8(59))
  call Hloop_QV_A(ntryL,G1H16(107),ex1(:),G1H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMB,G2H8(87),n2h8(60))
  call Hloop_DV_C(ntryL,G1H16(108),16,ex1(:),G2H8(88),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_CV_D(ntryL,G1H16(109),16,ex1(:),1,G2H8(89),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_UV_W(ntryL,G1H16(110),16,ex1(:),1,G2H8(90),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_AV_Q(ntryL,G1H16(115),ex1(:),G1H8(1),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(1),17,0,G2H8(91),n2h8(61))
  call Hloop_AV_Q(ntryL,G1H16(112),ex1(:),G1H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMT,G2H8(92),n2h8(62))
  call Hloop_QV_A(ntryL,G1H16(117),ex1(:),G1H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(1),17,0,G2H8(93),n2h8(63))
  call Hloop_QV_A(ntryL,G1H16(114),ex1(:),G1H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMT,G2H8(94),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H16(116),ex1(:),G1H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMB,G2H8(95),n2h8(65))
  call Hloop_QV_A(ntryL,G1H16(118),ex1(:),G1H8(1),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMB,G2H8(96),n2h8(66))
  call Hloop_DV_C(ntryL,G1H16(119),16,ex1(:),G2H8(97),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_CV_D(ntryL,G1H16(120),16,ex1(:),1,G2H8(98),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_UV_W(ntryL,G1H16(121),16,ex1(:),1,G2H8(99),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AV_Q(ntryL,G1H16(126),ex1(:),G1H8(1),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(1),17,0,G2H8(100),n2h8(67))
  call Hloop_AV_Q(ntryL,G1H16(123),ex1(:),G1H8(1),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMT,G2H8(101),n2h8(68))
  call Hloop_QV_A(ntryL,G1H16(128),ex1(:),G1H8(1),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(1),17,0,G2H8(102),n2h8(69))
  call Hloop_QV_A(ntryL,G1H16(125),ex1(:),G1H8(1),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMT,G2H8(103),n2h8(70))
  call Hloop_AV_Q(ntryL,G1H16(127),ex1(:),G1H8(1),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(1),17,nMB,G2H8(104),n2h8(71))
  call Hloop_QV_A(ntryL,G1H16(129),ex1(:),G1H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(1),17,nMB,G2H8(105),n2h8(72))
  call Hloop_DV_C(ntryL,G1H16(130),16,ex1(:),G2H8(106),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_CV_D(ntryL,G1H16(131),16,ex1(:),1,G2H8(107),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_UV_W(ntryL,G1H16(132),16,ex1(:),1,G2H8(108),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(1),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(1),mass5set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(1),mass5set(:,2),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(1),mass5set(:,3),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(1),mass5set(:,3),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(1),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(2),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(2),mass5set(:,2),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(2),mass5set(:,1),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(2),mass5set(:,2),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),8,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(2),mass5set(:,3),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(2),mass5set(:,3),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(2),mass5set(:,1),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(2),mass5set(:,1),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(2),mass5set(:,1),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(3),mass5set(:,1),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(3),mass5set(:,2),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),8,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(3),mass5set(:,1),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(3),mass5set(:,2),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(3),mass5set(:,3),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),8,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(3),mass5set(:,3),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),8,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(3),mass5set(:,1),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(3),mass5set(:,1),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(3),mass5set(:,1),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(4),mass5set(:,1),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),4,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(4),mass5set(:,2),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),4,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(4),mass5set(:,1),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),4,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(4),mass5set(:,2),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),4,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(4),mass5set(:,3),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),4,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(4),mass5set(:,3),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),4,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(4),mass5set(:,1),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),4,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(4),mass5set(:,1),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),4,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(4),mass5set(:,1),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),4,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(5),mass5set(:,1),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),8,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(5),mass5set(:,2),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),8,8)
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(5),mass5set(:,1),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(5),mass5set(:,2),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(5),mass5set(:,3),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(5),mass5set(:,3),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),8,8)
  call Hotf_5pt_reduction(G2H8(43),RedSet_5(5),mass5set(:,1),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),8,8)
  call Hotf_5pt_reduction(G2H8(44),RedSet_5(5),mass5set(:,1),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),8,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(5),mass5set(:,1),  & 
G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),8)
  call HG1shiftOLR(G1H8(266),8,8)
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(6),mass5set(:,1),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),4,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(6),mass5set(:,2),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G1H8(282),8)
  call HG1shiftOLR(G1H8(278),4,8)
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(6),mass5set(:,1),  & 
G1H8(283),G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(284),4,8)
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(6),mass5set(:,2),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),4,8)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(6),mass5set(:,3),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(296),4,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(6),mass5set(:,3),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G1H8(306),8)
  call HG1shiftOLR(G1H8(302),4,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(6),mass5set(:,1),  & 
G1H8(307),G1H8(308),G1H8(309),G1H8(310),G1H8(311),G1H8(312),8)
  call HG1shiftOLR(G1H8(308),4,8)
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(6),mass5set(:,1),  & 
G1H8(313),G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),8)
  call HG1shiftOLR(G1H8(314),4,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(6),mass5set(:,1),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),4,8)
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(7),mass5set(:,1),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),8)
  call HG1shiftOLR(G1H8(326),8,8)
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(7),mass5set(:,2),  & 
G1H8(331),G1H8(332),G1H8(333),G1H8(334),G1H8(335),G1H8(336),8)
  call HG1shiftOLR(G1H8(332),8,8)
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(7),mass5set(:,1),  & 
G1H8(337),G1H8(338),G1H8(339),G1H8(340),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(338),8,8)
  call Hotf_5pt_reduction(G2H8(58),RedSet_5(7),mass5set(:,2),  & 
G1H8(343),G1H8(344),G1H8(345),G1H8(346),G1H8(347),G1H8(348),8)
  call HG1shiftOLR(G1H8(344),8,8)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(7),mass5set(:,3),  & 
G1H8(349),G1H8(350),G1H8(351),G1H8(352),G1H8(353),G1H8(354),8)
  call HG1shiftOLR(G1H8(350),8,8)
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(7),mass5set(:,3),  & 
G1H8(355),G1H8(356),G1H8(357),G1H8(358),G1H8(359),G1H8(360),8)
  call HG1shiftOLR(G1H8(356),8,8)
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(7),mass5set(:,1),  & 
G1H8(361),G1H8(362),G1H8(363),G1H8(364),G1H8(365),G1H8(366),8)
  call HG1shiftOLR(G1H8(362),8,8)
  call Hotf_5pt_reduction(G2H8(62),RedSet_5(7),mass5set(:,1),  & 
G1H8(367),G1H8(368),G1H8(369),G1H8(370),G1H8(371),G1H8(372),8)
  call HG1shiftOLR(G1H8(368),8,8)
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(7),mass5set(:,1),  & 
G1H8(373),G1H8(374),G1H8(375),G1H8(376),G1H8(377),G1H8(378),8)
  call HG1shiftOLR(G1H8(374),8,8)
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(8),mass5set(:,1),  & 
G1H8(379),G1H8(380),G1H8(381),G1H8(382),G1H8(383),G1H8(384),8)
  call HG1shiftOLR(G1H8(380),4,8)
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(8),mass5set(:,2),  & 
G1H8(385),G1H8(386),G1H8(387),G1H8(388),G1H8(389),G1H8(390),8)
  call HG1shiftOLR(G1H8(386),4,8)
  call Hotf_5pt_reduction(G2H8(66),RedSet_5(8),mass5set(:,1),  & 
G1H8(391),G1H8(392),G1H8(393),G1H8(394),G1H8(395),G1H8(396),8)
  call HG1shiftOLR(G1H8(392),4,8)
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(8),mass5set(:,2),  & 
G1H8(397),G1H8(398),G1H8(399),G1H8(400),G1H8(401),G1H8(402),8)
  call HG1shiftOLR(G1H8(398),4,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(8),mass5set(:,3),  & 
G1H8(403),G1H8(404),G1H8(405),G1H8(406),G1H8(407),G1H8(408),8)
  call HG1shiftOLR(G1H8(404),4,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(8),mass5set(:,3),  & 
G1H8(409),G1H8(410),G1H8(411),G1H8(412),G1H8(413),G1H8(414),8)
  call HG1shiftOLR(G1H8(410),4,8)
  call Hotf_5pt_reduction(G2H8(70),RedSet_5(8),mass5set(:,1),  & 
G1H8(415),G1H8(416),G1H8(417),G1H8(418),G1H8(419),G1H8(420),8)
  call HG1shiftOLR(G1H8(416),4,8)
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(8),mass5set(:,1),  & 
G1H8(421),G1H8(422),G1H8(423),G1H8(424),G1H8(425),G1H8(426),8)
  call HG1shiftOLR(G1H8(422),4,8)
  call Hotf_5pt_reduction(G2H8(72),RedSet_5(8),mass5set(:,1),  & 
G1H8(427),G1H8(428),G1H8(429),G1H8(430),G1H8(431),G1H8(432),8)
  call HG1shiftOLR(G1H8(428),4,8)
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(9),mass5set(:,1),  & 
G1H8(433),G1H8(434),G1H8(435),G1H8(436),G1H8(437),G1H8(438),8)
  call HG1shiftOLR(G1H8(434),8,8)
  call Hotf_5pt_reduction(G2H8(74),RedSet_5(9),mass5set(:,2),  & 
G1H8(439),G1H8(440),G1H8(441),G1H8(442),G1H8(443),G1H8(444),8)
  call HG1shiftOLR(G1H8(440),8,8)
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(9),mass5set(:,1),  & 
G1H8(445),G1H8(446),G1H8(447),G1H8(448),G1H8(449),G1H8(450),8)
  call HG1shiftOLR(G1H8(446),8,8)
  call Hotf_5pt_reduction(G2H8(76),RedSet_5(9),mass5set(:,2),  & 
G1H8(451),G1H8(452),G1H8(453),G1H8(454),G1H8(455),G1H8(456),8)
  call HG1shiftOLR(G1H8(452),8,8)
  call Hotf_5pt_reduction(G2H8(77),RedSet_5(9),mass5set(:,3),  & 
G1H8(457),G1H8(458),G1H8(459),G1H8(460),G1H8(461),G1H8(462),8)
  call HG1shiftOLR(G1H8(458),8,8)
  call Hotf_5pt_reduction(G2H8(78),RedSet_5(9),mass5set(:,3),  & 
G1H8(463),G1H8(464),G1H8(465),G1H8(466),G1H8(467),G1H8(468),8)
  call HG1shiftOLR(G1H8(464),8,8)
  call Hotf_5pt_reduction(G2H8(79),RedSet_5(9),mass5set(:,1),  & 
G1H8(469),G1H8(470),G1H8(471),G1H8(472),G1H8(473),G1H8(474),8)
  call HG1shiftOLR(G1H8(470),8,8)
  call Hotf_5pt_reduction(G2H8(80),RedSet_5(9),mass5set(:,1),  & 
G1H8(475),G1H8(476),G1H8(477),G1H8(478),G1H8(479),G1H8(480),8)
  call HG1shiftOLR(G1H8(476),8,8)
  call Hotf_5pt_reduction(G2H8(81),RedSet_5(9),mass5set(:,1),  & 
G1H8(481),G1H8(482),G1H8(483),G1H8(484),G1H8(485),G1H8(486),8)
  call HG1shiftOLR(G1H8(482),8,8)
  call Hotf_5pt_reduction(G2H8(82),RedSet_5(10),mass5set(:,1),  & 
G1H8(487),G1H8(488),G1H8(489),G1H8(490),G1H8(491),G1H8(492),8)
  call HG1shiftOLR(G1H8(488),2,8)
  call Hotf_5pt_reduction(G2H8(83),RedSet_5(10),mass5set(:,2),  & 
G1H8(493),G1H8(494),G1H8(495),G1H8(496),G1H8(497),G1H8(498),8)
  call HG1shiftOLR(G1H8(494),2,8)
  call Hotf_5pt_reduction(G2H8(84),RedSet_5(10),mass5set(:,1),  & 
G1H8(499),G1H8(500),G1H8(501),G1H8(502),G1H8(503),G1H8(504),8)
  call HG1shiftOLR(G1H8(500),2,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(10),mass5set(:,2),  & 
G1H8(505),G1H8(506),G1H8(507),G1H8(508),G1H8(509),G1H8(510),8)
  call HG1shiftOLR(G1H8(506),2,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(10),mass5set(:,3),  & 
G1H8(511),G1H8(512),G1H8(513),G1H8(514),G1H8(515),G1H8(516),8)
  call HG1shiftOLR(G1H8(512),2,8)
  call Hotf_5pt_reduction(G2H8(87),RedSet_5(10),mass5set(:,3),  & 
G1H8(517),G1H8(518),G1H8(519),G1H8(520),G1H8(521),G1H8(522),8)
  call HG1shiftOLR(G1H8(518),2,8)
  call Hotf_5pt_reduction(G2H8(88),RedSet_5(10),mass5set(:,1),  & 
G1H8(523),G1H8(524),G1H8(525),G1H8(526),G1H8(527),G1H8(528),8)
  call HG1shiftOLR(G1H8(524),2,8)
  call Hotf_5pt_reduction(G2H8(89),RedSet_5(10),mass5set(:,1),  & 
G1H8(529),G1H8(530),G1H8(531),G1H8(532),G1H8(533),G1H8(534),8)
  call HG1shiftOLR(G1H8(530),2,8)
  call Hotf_5pt_reduction(G2H8(90),RedSet_5(10),mass5set(:,1),  & 
G1H8(535),G1H8(536),G1H8(537),G1H8(538),G1H8(539),G1H8(540),8)
  call HG1shiftOLR(G1H8(536),2,8)
  call Hotf_5pt_reduction(G2H8(91),RedSet_5(11),mass5set(:,1),  & 
G1H8(541),G1H8(542),G1H8(543),G1H8(544),G1H8(545),G1H8(546),8)
  call HG1shiftOLR(G1H8(542),4,8)
  call Hotf_5pt_reduction(G2H8(92),RedSet_5(11),mass5set(:,2),  & 
G1H8(547),G1H8(548),G1H8(549),G1H8(550),G1H8(551),G1H8(552),8)
  call HG1shiftOLR(G1H8(548),4,8)
  call Hotf_5pt_reduction(G2H8(93),RedSet_5(11),mass5set(:,1),  & 
G1H8(553),G1H8(554),G1H8(555),G1H8(556),G1H8(557),G1H8(558),8)
  call HG1shiftOLR(G1H8(554),4,8)
  call Hotf_5pt_reduction(G2H8(94),RedSet_5(11),mass5set(:,2),  & 
G1H8(559),G1H8(560),G1H8(561),G1H8(562),G1H8(563),G1H8(564),8)
  call HG1shiftOLR(G1H8(560),4,8)
  call Hotf_5pt_reduction(G2H8(95),RedSet_5(11),mass5set(:,3),  & 
G1H8(565),G1H8(566),G1H8(567),G1H8(568),G1H8(569),G1H8(570),8)
  call HG1shiftOLR(G1H8(566),4,8)
  call Hotf_5pt_reduction(G2H8(96),RedSet_5(11),mass5set(:,3),  & 
G1H8(571),G1H8(572),G1H8(573),G1H8(574),G1H8(575),G1H8(576),8)
  call HG1shiftOLR(G1H8(572),4,8)
  call Hotf_5pt_reduction(G2H8(97),RedSet_5(11),mass5set(:,1),  & 
G1H8(577),G1H8(578),G1H8(579),G1H8(580),G1H8(581),G1H8(582),8)
  call HG1shiftOLR(G1H8(578),4,8)
  call Hotf_5pt_reduction(G2H8(98),RedSet_5(11),mass5set(:,1),  & 
G1H8(583),G1H8(584),G1H8(585),G1H8(586),G1H8(587),G1H8(588),8)
  call HG1shiftOLR(G1H8(584),4,8)
  call Hotf_5pt_reduction(G2H8(99),RedSet_5(11),mass5set(:,1),  & 
G1H8(589),G1H8(590),G1H8(591),G1H8(592),G1H8(593),G1H8(594),8)
  call HG1shiftOLR(G1H8(590),4,8)
  call Hotf_5pt_reduction(G2H8(100),RedSet_5(12),mass5set(:,1),  & 
G1H8(595),G1H8(596),G1H8(597),G1H8(598),G1H8(599),G1H8(600),8)
  call HG1shiftOLR(G1H8(596),2,8)
  call Hotf_5pt_reduction(G2H8(101),RedSet_5(12),mass5set(:,2),  & 
G1H8(601),G1H8(602),G1H8(603),G1H8(604),G1H8(605),G1H8(606),8)
  call HG1shiftOLR(G1H8(602),2,8)
  call Hotf_5pt_reduction(G2H8(102),RedSet_5(12),mass5set(:,1),  & 
G1H8(607),G1H8(608),G1H8(609),G1H8(610),G1H8(611),G1H8(612),8)
  call HG1shiftOLR(G1H8(608),2,8)
  call Hotf_5pt_reduction(G2H8(103),RedSet_5(12),mass5set(:,2),  & 
G1H8(613),G1H8(614),G1H8(615),G1H8(616),G1H8(617),G1H8(618),8)
  call HG1shiftOLR(G1H8(614),2,8)
  call Hotf_5pt_reduction(G2H8(104),RedSet_5(12),mass5set(:,3),  & 
G1H8(619),G1H8(620),G1H8(621),G1H8(622),G1H8(623),G1H8(624),8)
  call HG1shiftOLR(G1H8(620),2,8)
  call Hotf_5pt_reduction(G2H8(105),RedSet_5(12),mass5set(:,3),  & 
G1H8(625),G1H8(626),G1H8(627),G1H8(628),G1H8(629),G1H8(630),8)
  call HG1shiftOLR(G1H8(626),2,8)
  call Hotf_5pt_reduction(G2H8(106),RedSet_5(12),mass5set(:,1),  & 
G1H8(631),G1H8(632),G1H8(633),G1H8(634),G1H8(635),G1H8(636),8)
  call HG1shiftOLR(G1H8(632),2,8)
  call Hotf_5pt_reduction(G2H8(107),RedSet_5(12),mass5set(:,1),  & 
G1H8(637),G1H8(638),G1H8(639),G1H8(640),G1H8(641),G1H8(642),8)
  call HG1shiftOLR(G1H8(638),2,8)
  call Hotf_5pt_reduction(G2H8(108),RedSet_5(12),mass5set(:,1),  & 
G1H8(643),G1H8(644),G1H8(645),G1H8(646),G1H8(647),G1H8(648),8)
  call HG1shiftOLR(G1H8(644),2,8)
  call Hloop_AV_Q(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-8,0,G2H8(1),n2h8(73))
  call Hloop_QV_A(ntryL,G2H8(1),ex4(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AV_Q(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(3),n2h4(2))
  call Hloop_AV_Q(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(4),n2h4(3))
  call Hloop_AV_Q(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(5),n2h4(4))
  call Hloop_AV_Q(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(6),n2h4(5))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-8,nMT,G2H8(2),n2h8(74))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AV_Q(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(8),n2h4(6))
  call Hloop_AV_Q(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(9),n2h4(7))
  call Hloop_AV_Q(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(10),n2h4(8))
  call Hloop_QV_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(11),n2h4(9))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-8,0,G2H8(3),n2h8(75))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QV_A(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(13),n2h4(10))
  call Hloop_QV_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(14),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(15),n2h4(12))
  call Hloop_QV_A(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(16),n2h4(13))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-8,nMT,G2H8(4),n2h8(76))
  call Hloop_AV_Q(ntryL,G2H8(4),ex4(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QV_A(ntryL,G1H8(22),ex1(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(18),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(23),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(19),n2h4(15))
  call Hloop_QV_A(ntryL,G1H8(24),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(20),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H8(25),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(21),n2h4(17))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-8,nMB,G2H8(5),n2h8(77))
  call Hloop_QV_A(ntryL,G2H8(5),ex4(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AV_Q(ntryL,G1H8(28),ex1(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(23),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H8(29),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(24),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H8(30),ex1(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(25),n2h4(20))
  call Hloop_QV_A(ntryL,G1H8(31),ex1(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(26),n2h4(21))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-8,nMB,G2H8(6),n2h8(78))
  call Hloop_AV_Q(ntryL,G2H8(6),ex4(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QV_A(ntryL,G1H8(34),ex1(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(28),n2h4(22))
  call Hloop_QV_A(ntryL,G1H8(35),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(29),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(36),ex1(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(30),n2h4(24))
  call Hloop_DV_C(ntryL,G1H8(37),20,ex1(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(38),-8,ex4(:),8,G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_DV_C(ntryL,G1H8(40),20,ex1(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_DV_C(ntryL,G1H8(41),20,ex1(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_DV_C(ntryL,G1H8(42),20,ex1(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_CV_D(ntryL,G1H8(43),20,ex1(:),1,G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(44),-8,ex4(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_CV_D(ntryL,G1H8(46),20,ex1(:),1,G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_CV_D(ntryL,G1H8(47),20,ex1(:),1,G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_CV_D(ntryL,G1H8(48),20,ex1(:),1,G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_UV_W(ntryL,G1H8(49),20,ex1(:),1,G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(50),-8,ex4(:),8,G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
call signflip_OLR(G2H4(42))
  call Hloop_UV_W(ntryL,G1H8(52),20,ex1(:),1,G2H4(43),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_UV_W(ntryL,G1H8(53),20,ex1(:),1,G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_UV_W(ntryL,G1H8(54),20,ex1(:),1,G2H4(45),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_QV_A(ntryL,G1H8(55),ex1(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(46),n2h4(25))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-8,0,G2H8(7),n2h8(82))
  call Hloop_AV_Q(ntryL,G2H8(7),ex4(:),G2H4(47),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_QV_A(ntryL,G1H8(58),ex1(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(48),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(59),ex1(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(49),n2h4(27))
  call Hloop_QV_A(ntryL,G1H8(60),ex1(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(50),n2h4(28))
  call Hloop_QV_A(ntryL,G1H8(61),ex1(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(51),n2h4(29))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-8,nMT,G2H8(8),n2h8(83))
  call Hloop_AV_Q(ntryL,G2H8(8),ex4(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_QV_A(ntryL,G1H8(64),ex1(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(53),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(65),ex1(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(54),n2h4(31))
  call Hloop_QV_A(ntryL,G1H8(66),ex1(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(55),n2h4(32))
  call Hloop_AV_Q(ntryL,G1H8(67),ex1(:),G1H4(1),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(56),n2h4(33))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(68),-8,0,G2H8(9),n2h8(84))
  call Hloop_QV_A(ntryL,G2H8(9),ex4(:),G2H4(57),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_AV_Q(ntryL,G1H8(70),ex1(:),G1H4(1),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(58),n2h4(34))
  call Hloop_AV_Q(ntryL,G1H8(71),ex1(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(59),n2h4(35))
  call Hloop_AV_Q(ntryL,G1H8(72),ex1(:),G1H4(1),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(60),n2h4(36))
  call Hloop_AV_Q(ntryL,G1H8(73),ex1(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(61),n2h4(37))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(74),-8,nMT,G2H8(10),n2h8(85))
  call Hloop_QV_A(ntryL,G2H8(10),ex4(:),G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_AV_Q(ntryL,G1H8(76),ex1(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(63),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(77),ex1(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(64),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H8(78),ex1(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(65),n2h4(40))
  call Hloop_QV_A(ntryL,G1H8(79),ex1(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(66),n2h4(41))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-8,nMB,G2H8(11),n2h8(86))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(67),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_QV_A(ntryL,G1H8(82),ex1(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(68),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(83),ex1(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(69),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(84),ex1(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(70),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(85),ex1(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(71),n2h4(45))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(86),-8,nMB,G2H8(12),n2h8(87))
  call Hloop_QV_A(ntryL,G2H8(12),ex4(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_AV_Q(ntryL,G1H8(88),ex1(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(73),n2h4(46))
  call Hloop_AV_Q(ntryL,G1H8(89),ex1(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(74),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(90),ex1(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(75),n2h4(48))
  call Hloop_CV_D(ntryL,G1H8(91),18,ex1(:),1,G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(92),-8,ex4(:),G2H4(77),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_CV_D(ntryL,G1H8(94),18,ex1(:),1,G2H4(78),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_CV_D(ntryL,G1H8(95),18,ex1(:),1,G2H4(79),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_CV_D(ntryL,G1H8(96),18,ex1(:),1,G2H4(80),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_DV_C(ntryL,G1H8(97),18,ex1(:),G2H4(81),m3h2x4(:,81),heltab2x8(:,:,81))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(98),-8,ex4(:),8,G2H4(82),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_DV_C(ntryL,G1H8(100),18,ex1(:),G2H4(83),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_DV_C(ntryL,G1H8(101),18,ex1(:),G2H4(84),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_DV_C(ntryL,G1H8(102),18,ex1(:),G2H4(85),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_UV_W(ntryL,G1H8(103),18,ex1(:),1,G2H4(86),m3h2x4(:,86),heltab2x8(:,:,86))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(104),-8,ex4(:),8,G2H4(87),m3h2x4(:,87),heltab2x8(:,:,87))
call signflip_OLR(G2H4(87))
  call Hloop_UV_W(ntryL,G1H8(106),18,ex1(:),1,G2H4(88),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_UV_W(ntryL,G1H8(107),18,ex1(:),1,G2H4(89),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_UV_W(ntryL,G1H8(108),18,ex1(:),1,G2H4(90),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_QV_A(ntryL,G1H8(109),ex2(:),G1H4(1),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(91),n2h4(49))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(110),-8,0,G2H8(13),n2h8(91))
  call Hloop_AV_Q(ntryL,G2H8(13),ex4(:),G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_QV_A(ntryL,G1H8(112),ex2(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(93),n2h4(50))
  call Hloop_QV_A(ntryL,G1H8(113),ex2(:),G1H4(1),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(94),n2h4(51))
  call Hloop_QV_A(ntryL,G1H8(114),ex2(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(95),n2h4(52))
  call Hloop_QV_A(ntryL,G1H8(115),ex2(:),G1H4(1),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(96),n2h4(53))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(116),-8,nMT,G2H8(14),n2h8(92))
  call Hloop_AV_Q(ntryL,G2H8(14),ex4(:),G2H4(97),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_QV_A(ntryL,G1H8(118),ex2(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(98),n2h4(54))
  call Hloop_QV_A(ntryL,G1H8(119),ex2(:),G1H4(1),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(99),n2h4(55))
  call Hloop_QV_A(ntryL,G1H8(120),ex2(:),G1H4(1),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(100),n2h4(56))
  call Hloop_AV_Q(ntryL,G1H8(121),ex2(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(101),n2h4(57))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(122),-8,0,G2H8(15),n2h8(93))
  call Hloop_QV_A(ntryL,G2H8(15),ex4(:),G2H4(102),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_AV_Q(ntryL,G1H8(124),ex2(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(103),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H8(125),ex2(:),G1H4(1),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(104),n2h4(59))
  call Hloop_AV_Q(ntryL,G1H8(126),ex2(:),G1H4(1),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(105),n2h4(60))
  call Hloop_AV_Q(ntryL,G1H8(127),ex2(:),G1H4(1),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(106),n2h4(61))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(128),-8,nMT,G2H8(16),n2h8(94))
  call Hloop_QV_A(ntryL,G2H8(16),ex4(:),G2H4(107),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_AV_Q(ntryL,G1H8(130),ex2(:),G1H4(1),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(108),n2h4(62))
  call Hloop_AV_Q(ntryL,G1H8(131),ex2(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(109),n2h4(63))
  call Hloop_AV_Q(ntryL,G1H8(132),ex2(:),G1H4(1),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(110),n2h4(64))
  call Hloop_QV_A(ntryL,G1H8(133),ex2(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(111),n2h4(65))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(134),-8,nMB,G2H8(17),n2h8(95))
  call Hloop_AV_Q(ntryL,G2H8(17),ex4(:),G2H4(112),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_QV_A(ntryL,G1H8(136),ex2(:),G1H4(1),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(113),n2h4(66))
  call Hloop_QV_A(ntryL,G1H8(137),ex2(:),G1H4(1),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(114),n2h4(67))
  call Hloop_QV_A(ntryL,G1H8(138),ex2(:),G1H4(1),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(115),n2h4(68))
  call Hloop_AV_Q(ntryL,G1H8(139),ex2(:),G1H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(116),n2h4(69))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(140),-8,nMB,G2H8(18),n2h8(96))
  call Hloop_QV_A(ntryL,G2H8(18),ex4(:),G2H4(117),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_AV_Q(ntryL,G1H8(142),ex2(:),G1H4(1),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(118),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H8(143),ex2(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(119),n2h4(71))
  call Hloop_AV_Q(ntryL,G1H8(144),ex2(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(120),n2h4(72))
  call Hloop_CV_D(ntryL,G1H8(145),20,ex2(:),2,G2H4(121),m3h2x4(:,121),heltab2x8(:,:,121))
call HGT_OLR(G1H8(146),1,1,8)
call HGT_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(146),-8,ex4(:),G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_CV_D(ntryL,G1H8(148),20,ex2(:),2,G2H4(123),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_CV_D(ntryL,G1H8(149),20,ex2(:),2,G2H4(124),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_CV_D(ntryL,G1H8(150),20,ex2(:),2,G2H4(125),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_DV_C(ntryL,G1H8(151),20,ex2(:),G2H4(126),m3h2x4(:,126),heltab2x8(:,:,126))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(152),-8,ex4(:),8,G2H4(127),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_DV_C(ntryL,G1H8(154),20,ex2(:),G2H4(128),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_DV_C(ntryL,G1H8(155),20,ex2(:),G2H4(129),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_DV_C(ntryL,G1H8(156),20,ex2(:),G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_UV_W(ntryL,G1H8(157),20,ex2(:),2,G2H4(131),m3h2x4(:,131),heltab2x8(:,:,131))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(158),-8,ex4(:),8,G2H4(132),m3h2x4(:,132),heltab2x8(:,:,132))
call signflip_OLR(G2H4(132))
  call Hloop_UV_W(ntryL,G1H8(160),20,ex2(:),2,G2H4(133),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_UV_W(ntryL,G1H8(161),20,ex2(:),2,G2H4(134),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_UV_W(ntryL,G1H8(162),20,ex2(:),2,G2H4(135),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_QV_A(ntryL,G1H8(163),ex1(:),G1H4(1),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(136),n2h4(73))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(164),-4,0,G2H8(19),n2h8(100))
  call Hloop_AV_Q(ntryL,G2H8(19),ex3(:),G2H4(137),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_QV_A(ntryL,G1H8(166),ex1(:),G1H4(1),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(138),n2h4(74))
  call Hloop_QV_A(ntryL,G1H8(167),ex1(:),G1H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(139),n2h4(75))
  call Hloop_QV_A(ntryL,G1H8(168),ex1(:),G1H4(1),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(140),n2h4(76))
  call Hloop_QV_A(ntryL,G1H8(169),ex1(:),G1H4(1),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(141),n2h4(77))
call HGT_OLR(G1H8(170),1,1,8)
call HGT_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(170),-4,nMT,G2H8(20),n2h8(101))
  call Hloop_AV_Q(ntryL,G2H8(20),ex3(:),G2H4(142),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_QV_A(ntryL,G1H8(172),ex1(:),G1H4(1),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(143),n2h4(78))
  call Hloop_QV_A(ntryL,G1H8(173),ex1(:),G1H4(1),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(144),n2h4(79))
  call Hloop_QV_A(ntryL,G1H8(174),ex1(:),G1H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(145),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(175),ex1(:),G1H4(1),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(146),n2h4(81))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(176),-4,0,G2H8(21),n2h8(102))
  call Hloop_QV_A(ntryL,G2H8(21),ex3(:),G2H4(147),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_AV_Q(ntryL,G1H8(178),ex1(:),G1H4(1),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(148),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H8(179),ex1(:),G1H4(1),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(149),n2h4(83))
  call Hloop_AV_Q(ntryL,G1H8(180),ex1(:),G1H4(1),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(150),n2h4(84))
  call Hloop_AV_Q(ntryL,G1H8(181),ex1(:),G1H4(1),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(151),n2h4(85))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(182),-4,nMT,G2H8(22),n2h8(103))
  call Hloop_QV_A(ntryL,G2H8(22),ex3(:),G2H4(152),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_AV_Q(ntryL,G1H8(184),ex1(:),G1H4(1),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(153),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H8(185),ex1(:),G1H4(1),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(154),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H8(186),ex1(:),G1H4(1),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(155),n2h4(88))
  call Hloop_QV_A(ntryL,G1H8(187),ex1(:),G1H4(1),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(156),n2h4(89))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(188),-4,nMB,G2H8(23),n2h8(104))
  call Hloop_AV_Q(ntryL,G2H8(23),ex3(:),G2H4(157),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_QV_A(ntryL,G1H8(190),ex1(:),G1H4(1),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(158),n2h4(90))
  call Hloop_QV_A(ntryL,G1H8(191),ex1(:),G1H4(1),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(159),n2h4(91))
  call Hloop_QV_A(ntryL,G1H8(192),ex1(:),G1H4(1),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(160),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H8(193),ex1(:),G1H4(1),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(161),n2h4(93))
call HGT_OLR(G1H8(194),1,1,8)
call HGT_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(194),-4,nMB,G2H8(24),n2h8(105))
  call Hloop_QV_A(ntryL,G2H8(24),ex3(:),G2H4(162),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AV_Q(ntryL,G1H8(196),ex1(:),G1H4(1),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(163),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H8(197),ex1(:),G1H4(1),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(164),n2h4(95))
  call Hloop_AV_Q(ntryL,G1H8(198),ex1(:),G1H4(1),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(165),n2h4(96))
  call Hloop_CV_D(ntryL,G1H8(199),18,ex1(:),1,G2H4(166),m3h2x4(:,166),heltab2x8(:,:,166))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(200),-4,ex3(:),G2H4(167),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_CV_D(ntryL,G1H8(202),18,ex1(:),1,G2H4(168),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_CV_D(ntryL,G1H8(203),18,ex1(:),1,G2H4(169),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_CV_D(ntryL,G1H8(204),18,ex1(:),1,G2H4(170),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_DV_C(ntryL,G1H8(205),18,ex1(:),G2H4(171),m3h2x4(:,171),heltab2x8(:,:,171))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(206),-4,ex3(:),4,G2H4(172),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_DV_C(ntryL,G1H8(208),18,ex1(:),G2H4(173),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_DV_C(ntryL,G1H8(209),18,ex1(:),G2H4(174),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_DV_C(ntryL,G1H8(210),18,ex1(:),G2H4(175),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_UV_W(ntryL,G1H8(211),18,ex1(:),1,G2H4(176),m3h2x4(:,176),heltab2x8(:,:,176))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(212),-4,ex3(:),4,G2H4(177),m3h2x4(:,177),heltab2x8(:,:,177))
call signflip_OLR(G2H4(177))
  call Hloop_UV_W(ntryL,G1H8(214),18,ex1(:),1,G2H4(178),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_UV_W(ntryL,G1H8(215),18,ex1(:),1,G2H4(179),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_UV_W(ntryL,G1H8(216),18,ex1(:),1,G2H4(180),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_AV_Q(ntryL,G1H8(217),ex2(:),G1H4(1),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(181),n2h4(97))
call HGT_OLR(G1H8(218),1,1,8)
call HGT_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(218),-8,0,G2H8(25),n2h8(109))
  call Hloop_QV_A(ntryL,G2H8(25),ex4(:),G2H4(182),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_AV_Q(ntryL,G1H8(220),ex2(:),G1H4(1),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(183),n2h4(98))
  call Hloop_AV_Q(ntryL,G1H8(221),ex2(:),G1H4(1),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(184),n2h4(99))
  call Hloop_AV_Q(ntryL,G1H8(222),ex2(:),G1H4(1),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(185),n2h4(100))
  call Hloop_AV_Q(ntryL,G1H8(223),ex2(:),G1H4(1),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(186),n2h4(101))
call HGT_OLR(G1H8(224),1,1,8)
call HGT_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(224),-8,nMT,G2H8(26),n2h8(110))
  call Hloop_QV_A(ntryL,G2H8(26),ex4(:),G2H4(187),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_AV_Q(ntryL,G1H8(226),ex2(:),G1H4(1),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(188),n2h4(102))
  call Hloop_AV_Q(ntryL,G1H8(227),ex2(:),G1H4(1),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(189),n2h4(103))
  call Hloop_AV_Q(ntryL,G1H8(228),ex2(:),G1H4(1),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(190),n2h4(104))
  call Hloop_QV_A(ntryL,G1H8(229),ex2(:),G1H4(1),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(191),n2h4(105))
call HGT_OLR(G1H8(230),1,1,8)
call HGT_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(230),-8,0,G2H8(27),n2h8(111))
  call Hloop_AV_Q(ntryL,G2H8(27),ex4(:),G2H4(192),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_QV_A(ntryL,G1H8(232),ex2(:),G1H4(1),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(193),n2h4(106))
  call Hloop_QV_A(ntryL,G1H8(233),ex2(:),G1H4(1),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(194),n2h4(107))
  call Hloop_QV_A(ntryL,G1H8(234),ex2(:),G1H4(1),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(195),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(235),ex2(:),G1H4(1),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(196),n2h4(109))
call HGT_OLR(G1H8(236),1,1,8)
call HGT_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(236),-8,nMT,G2H8(28),n2h8(112))
  call Hloop_AV_Q(ntryL,G2H8(28),ex4(:),G2H4(197),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QV_A(ntryL,G1H8(238),ex2(:),G1H4(1),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(198),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(239),ex2(:),G1H4(1),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(199),n2h4(111))
  call Hloop_QV_A(ntryL,G1H8(240),ex2(:),G1H4(1),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(200),n2h4(112))
  call Hloop_AV_Q(ntryL,G1H8(241),ex2(:),G1H4(1),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(201),n2h4(113))
call HGT_OLR(G1H8(242),1,1,8)
call HGT_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(242),-8,nMB,G2H8(29),n2h8(113))
  call Hloop_QV_A(ntryL,G2H8(29),ex4(:),G2H4(202),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_AV_Q(ntryL,G1H8(244),ex2(:),G1H4(1),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(203),n2h4(114))
  call Hloop_AV_Q(ntryL,G1H8(245),ex2(:),G1H4(1),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(204),n2h4(115))
  call Hloop_AV_Q(ntryL,G1H8(246),ex2(:),G1H4(1),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(205),n2h4(116))
  call Hloop_QV_A(ntryL,G1H8(247),ex2(:),G1H4(1),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(206),n2h4(117))
call HGT_OLR(G1H8(248),1,1,8)
call HGT_invQ_OLR(G1H8(248),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(248),-8,nMB,G2H8(30),n2h8(114))
  call Hloop_AV_Q(ntryL,G2H8(30),ex4(:),G2H4(207),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_QV_A(ntryL,G1H8(250),ex2(:),G1H4(1),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(208),n2h4(118))
  call Hloop_QV_A(ntryL,G1H8(251),ex2(:),G1H4(1),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(209),n2h4(119))
  call Hloop_QV_A(ntryL,G1H8(252),ex2(:),G1H4(1),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(210),n2h4(120))
  call Hloop_DV_C(ntryL,G1H8(253),17,ex2(:),G2H4(211),m3h2x4(:,211),heltab2x8(:,:,211))
call HGT_OLR(G1H8(254),1,1,8)
call HGT_invQ_OLR(G1H8(254),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(254),-8,ex4(:),8,G2H4(212),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_DV_C(ntryL,G1H8(256),17,ex2(:),G2H4(213),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_DV_C(ntryL,G1H8(257),17,ex2(:),G2H4(214),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_DV_C(ntryL,G1H8(258),17,ex2(:),G2H4(215),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_CV_D(ntryL,G1H8(259),17,ex2(:),2,G2H4(216),m3h2x4(:,216),heltab2x8(:,:,216))
call HGT_OLR(G1H8(260),1,1,8)
call HGT_invQ_OLR(G1H8(260),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(260),-8,ex4(:),G2H4(217),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_CV_D(ntryL,G1H8(262),17,ex2(:),2,G2H4(218),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_CV_D(ntryL,G1H8(263),17,ex2(:),2,G2H4(219),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_CV_D(ntryL,G1H8(264),17,ex2(:),2,G2H4(220),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_UV_W(ntryL,G1H8(265),17,ex2(:),2,G2H4(221),m3h2x4(:,221),heltab2x8(:,:,221))
call HGT_raise_alpha_OLR(G1H8(266),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(266),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(266),-8,ex4(:),8,G2H4(222),m3h2x4(:,222),heltab2x8(:,:,222))
call signflip_OLR(G2H4(222))
  call Hloop_UV_W(ntryL,G1H8(268),17,ex2(:),2,G2H4(223),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_UV_W(ntryL,G1H8(269),17,ex2(:),2,G2H4(224),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_UV_W(ntryL,G1H8(270),17,ex2(:),2,G2H4(225),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_AV_Q(ntryL,G1H8(271),ex2(:),G1H4(1),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(226),n2h4(121))
call HGT_OLR(G1H8(272),1,1,8)
call HGT_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(272),-4,0,G2H8(31),n2h8(118))
  call Hloop_QV_A(ntryL,G2H8(31),ex3(:),G2H4(227),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_AV_Q(ntryL,G1H8(274),ex2(:),G1H4(1),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(228),n2h4(122))
  call Hloop_AV_Q(ntryL,G1H8(275),ex2(:),G1H4(1),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(229),n2h4(123))
  call Hloop_AV_Q(ntryL,G1H8(276),ex2(:),G1H4(1),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(230),n2h4(124))
  call Hloop_AV_Q(ntryL,G1H8(277),ex2(:),G1H4(1),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(231),n2h4(125))
call HGT_OLR(G1H8(278),1,1,8)
call HGT_invQ_OLR(G1H8(278),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(278),-4,nMT,G2H8(32),n2h8(119))
  call Hloop_QV_A(ntryL,G2H8(32),ex3(:),G2H4(232),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_AV_Q(ntryL,G1H8(280),ex2(:),G1H4(1),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(233),n2h4(126))
  call Hloop_AV_Q(ntryL,G1H8(281),ex2(:),G1H4(1),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(234),n2h4(127))
  call Hloop_AV_Q(ntryL,G1H8(282),ex2(:),G1H4(1),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(235),n2h4(128))
  call Hloop_QV_A(ntryL,G1H8(283),ex2(:),G1H4(1),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(236),n2h4(129))
call HGT_OLR(G1H8(284),1,1,8)
call HGT_invQ_OLR(G1H8(284),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(284),-4,0,G2H8(33),n2h8(120))
  call Hloop_AV_Q(ntryL,G2H8(33),ex3(:),G2H4(237),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_QV_A(ntryL,G1H8(286),ex2(:),G1H4(1),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(238),n2h4(130))
  call Hloop_QV_A(ntryL,G1H8(287),ex2(:),G1H4(1),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(239),n2h4(131))
  call Hloop_QV_A(ntryL,G1H8(288),ex2(:),G1H4(1),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(240),n2h4(132))
  call Hloop_QV_A(ntryL,G1H8(289),ex2(:),G1H4(1),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(241),n2h4(133))
call HGT_OLR(G1H8(290),1,1,8)
call HGT_invQ_OLR(G1H8(290),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(290),-4,nMT,G2H8(34),n2h8(121))
  call Hloop_AV_Q(ntryL,G2H8(34),ex3(:),G2H4(242),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_QV_A(ntryL,G1H8(292),ex2(:),G1H4(1),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(243),n2h4(134))
  call Hloop_QV_A(ntryL,G1H8(293),ex2(:),G1H4(1),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(244),n2h4(135))
  call Hloop_QV_A(ntryL,G1H8(294),ex2(:),G1H4(1),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(245),n2h4(136))
  call Hloop_AV_Q(ntryL,G1H8(295),ex2(:),G1H4(1),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(246),n2h4(137))
call HGT_OLR(G1H8(296),1,1,8)
call HGT_invQ_OLR(G1H8(296),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(296),-4,nMB,G2H8(35),n2h8(122))
  call Hloop_QV_A(ntryL,G2H8(35),ex3(:),G2H4(247),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_AV_Q(ntryL,G1H8(298),ex2(:),G1H4(1),m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(248),n2h4(138))
  call Hloop_AV_Q(ntryL,G1H8(299),ex2(:),G1H4(1),m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(249),n2h4(139))
  call Hloop_AV_Q(ntryL,G1H8(300),ex2(:),G1H4(1),m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(250),n2h4(140))
  call Hloop_QV_A(ntryL,G1H8(301),ex2(:),G1H4(1),m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(251),n2h4(141))
call HGT_OLR(G1H8(302),1,1,8)
call HGT_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(302),-4,nMB,G2H8(36),n2h8(123))
  call Hloop_AV_Q(ntryL,G2H8(36),ex3(:),G2H4(252),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_QV_A(ntryL,G1H8(304),ex2(:),G1H4(1),m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(253),n2h4(142))
  call Hloop_QV_A(ntryL,G1H8(305),ex2(:),G1H4(1),m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(254),n2h4(143))
  call Hloop_QV_A(ntryL,G1H8(306),ex2(:),G1H4(1),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(255),n2h4(144))
  call Hloop_DV_C(ntryL,G1H8(307),17,ex2(:),G2H4(256),m3h2x4(:,256),heltab2x8(:,:,256))
call HGT_OLR(G1H8(308),1,1,8)
call HGT_invQ_OLR(G1H8(308),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(308),-4,ex3(:),4,G2H4(257),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_DV_C(ntryL,G1H8(310),17,ex2(:),G2H4(258),m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_DV_C(ntryL,G1H8(311),17,ex2(:),G2H4(259),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_DV_C(ntryL,G1H8(312),17,ex2(:),G2H4(260),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_CV_D(ntryL,G1H8(313),17,ex2(:),2,G2H4(261),m3h2x4(:,261),heltab2x8(:,:,261))
call HGT_OLR(G1H8(314),1,1,8)
call HGT_invQ_OLR(G1H8(314),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(314),-4,ex3(:),G2H4(262),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_CV_D(ntryL,G1H8(316),17,ex2(:),2,G2H4(263),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_CV_D(ntryL,G1H8(317),17,ex2(:),2,G2H4(264),m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_CV_D(ntryL,G1H8(318),17,ex2(:),2,G2H4(265),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_UV_W(ntryL,G1H8(319),17,ex2(:),2,G2H4(266),m3h2x4(:,266),heltab2x8(:,:,266))
call HGT_raise_alpha_OLR(G1H8(320),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(320),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(320),-4,ex3(:),4,G2H4(267),m3h2x4(:,267),heltab2x8(:,:,267))
call signflip_OLR(G2H4(267))
  call Hloop_UV_W(ntryL,G1H8(322),17,ex2(:),2,G2H4(268),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_UV_W(ntryL,G1H8(323),17,ex2(:),2,G2H4(269),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_UV_W(ntryL,G1H8(324),17,ex2(:),2,G2H4(270),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_QV_A(ntryL,G1H8(325),ex3(:),G1H4(1),m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(271),n2h4(145))
call HGT_OLR(G1H8(326),1,1,8)
call HGT_invQ_OLR(G1H8(326),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(326),-8,0,G2H8(37),n2h8(127))
  call Hloop_AV_Q(ntryL,G2H8(37),ex4(:),G2H4(272),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_QV_A(ntryL,G1H8(328),ex3(:),G1H4(1),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(273),n2h4(146))
  call Hloop_QV_A(ntryL,G1H8(329),ex3(:),G1H4(1),m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(274),n2h4(147))
  call Hloop_QV_A(ntryL,G1H8(330),ex3(:),G1H4(1),m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G1H4(1),22,0,G2H4(275),n2h4(148))
  call Hloop_QV_A(ntryL,G1H8(331),ex3(:),G1H4(1),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(276),n2h4(149))
call HGT_OLR(G1H8(332),1,1,8)
call HGT_invQ_OLR(G1H8(332),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(332),-8,nMT,G2H8(38),n2h8(128))
  call Hloop_AV_Q(ntryL,G2H8(38),ex4(:),G2H4(277),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_QV_A(ntryL,G1H8(334),ex3(:),G1H4(1),m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(278),n2h4(150))
  call Hloop_QV_A(ntryL,G1H8(335),ex3(:),G1H4(1),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(279),n2h4(151))
  call Hloop_QV_A(ntryL,G1H8(336),ex3(:),G1H4(1),m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMT,G2H4(280),n2h4(152))
  call Hloop_AV_Q(ntryL,G1H8(337),ex3(:),G1H4(1),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(281),n2h4(153))
call HGT_OLR(G1H8(338),1,1,8)
call HGT_invQ_OLR(G1H8(338),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(338),-8,0,G2H8(39),n2h8(129))
  call Hloop_QV_A(ntryL,G2H8(39),ex4(:),G2H4(282),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_AV_Q(ntryL,G1H8(340),ex3(:),G1H4(1),m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(283),n2h4(154))
  call Hloop_AV_Q(ntryL,G1H8(341),ex3(:),G1H4(1),m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(284),n2h4(155))
  call Hloop_AV_Q(ntryL,G1H8(342),ex3(:),G1H4(1),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(285),n2h4(156))
  call Hloop_AV_Q(ntryL,G1H8(343),ex3(:),G1H4(1),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(286),n2h4(157))
call HGT_OLR(G1H8(344),1,1,8)
call HGT_invQ_OLR(G1H8(344),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(344),-8,nMT,G2H8(40),n2h8(130))
  call Hloop_QV_A(ntryL,G2H8(40),ex4(:),G2H4(287),m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_AV_Q(ntryL,G1H8(346),ex3(:),G1H4(1),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(288),n2h4(158))
  call Hloop_AV_Q(ntryL,G1H8(347),ex3(:),G1H4(1),m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(289),n2h4(159))
  call Hloop_AV_Q(ntryL,G1H8(348),ex3(:),G1H4(1),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(290),n2h4(160))
  call Hloop_QV_A(ntryL,G1H8(349),ex3(:),G1H4(1),m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(291),n2h4(161))
call HGT_OLR(G1H8(350),1,1,8)
call HGT_invQ_OLR(G1H8(350),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(350),-8,nMB,G2H8(41),n2h8(131))
  call Hloop_AV_Q(ntryL,G2H8(41),ex4(:),G2H4(292),m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_QV_A(ntryL,G1H8(352),ex3(:),G1H4(1),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(293),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(353),ex3(:),G1H4(1),m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(294),n2h4(163))
  call Hloop_QV_A(ntryL,G1H8(354),ex3(:),G1H4(1),m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(1),22,nMB,G2H4(295),n2h4(164))
  call Hloop_AV_Q(ntryL,G1H8(355),ex3(:),G1H4(1),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(296),n2h4(165))
call HGT_OLR(G1H8(356),1,1,8)
call HGT_invQ_OLR(G1H8(356),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(356),-8,nMB,G2H8(42),n2h8(132))
  call Hloop_QV_A(ntryL,G2H8(42),ex4(:),G2H4(297),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_AV_Q(ntryL,G1H8(358),ex3(:),G1H4(1),m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(298),n2h4(166))
  call Hloop_AV_Q(ntryL,G1H8(359),ex3(:),G1H4(1),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(299),n2h4(167))
  call Hloop_AV_Q(ntryL,G1H8(360),ex3(:),G1H4(1),m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(300),n2h4(168))
  call Hloop_CV_D(ntryL,G1H8(361),18,ex3(:),4,G2H4(301),m3h2x4(:,301),heltab2x8(:,:,301))
call HGT_OLR(G1H8(362),1,1,8)
call HGT_invQ_OLR(G1H8(362),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(362),-8,ex4(:),G2H4(302),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_CV_D(ntryL,G1H8(364),18,ex3(:),4,G2H4(303),m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_CV_D(ntryL,G1H8(365),18,ex3(:),4,G2H4(304),m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_CV_D(ntryL,G1H8(366),18,ex3(:),4,G2H4(305),m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_DV_C(ntryL,G1H8(367),18,ex3(:),G2H4(306),m3h2x4(:,306),heltab2x8(:,:,306))
call HGT_OLR(G1H8(368),1,1,8)
call HGT_invQ_OLR(G1H8(368),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(368),-8,ex4(:),8,G2H4(307),m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_DV_C(ntryL,G1H8(370),18,ex3(:),G2H4(308),m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_DV_C(ntryL,G1H8(371),18,ex3(:),G2H4(309),m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_DV_C(ntryL,G1H8(372),18,ex3(:),G2H4(310),m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_UV_W(ntryL,G1H8(373),18,ex3(:),4,G2H4(311),m3h2x4(:,311),heltab2x8(:,:,311))
call HGT_raise_alpha_OLR(G1H8(374),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(374),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(374),-8,ex4(:),8,G2H4(312),m3h2x4(:,312),heltab2x8(:,:,312))
call signflip_OLR(G2H4(312))
  call Hloop_UV_W(ntryL,G1H8(376),18,ex3(:),4,G2H4(313),m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_UV_W(ntryL,G1H8(377),18,ex3(:),4,G2H4(314),m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_UV_W(ntryL,G1H8(378),18,ex3(:),4,G2H4(315),m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_AV_Q(ntryL,G1H8(379),ex4(:),G1H4(1),m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(316),n2h4(169))
call HGT_OLR(G1H8(380),1,1,8)
call HGT_invQ_OLR(G1H8(380),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(380),-4,0,G2H8(43),n2h8(136))
  call Hloop_QV_A(ntryL,G2H8(43),ex3(:),G2H4(317),m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_AV_Q(ntryL,G1H8(382),ex4(:),G1H4(1),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(318),n2h4(170))
  call Hloop_AV_Q(ntryL,G1H8(383),ex4(:),G1H4(1),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(319),n2h4(171))
  call Hloop_AV_Q(ntryL,G1H8(384),ex4(:),G1H4(1),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_A_Q(ntryL,G1H4(1),26,0,G2H4(320),n2h4(172))
  call Hloop_AV_Q(ntryL,G1H8(385),ex4(:),G1H4(1),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(321),n2h4(173))
call HGT_OLR(G1H8(386),1,1,8)
call HGT_invQ_OLR(G1H8(386),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(386),-4,nMT,G2H8(44),n2h8(137))
  call Hloop_QV_A(ntryL,G2H8(44),ex3(:),G2H4(322),m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_AV_Q(ntryL,G1H8(388),ex4(:),G1H4(1),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(323),n2h4(174))
  call Hloop_AV_Q(ntryL,G1H8(389),ex4(:),G1H4(1),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(324),n2h4(175))
  call Hloop_AV_Q(ntryL,G1H8(390),ex4(:),G1H4(1),m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(325),n2h4(176))
  call Hloop_QV_A(ntryL,G1H8(391),ex4(:),G1H4(1),m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G1H4(1),26,0,G2H4(326),n2h4(177))
call HGT_OLR(G1H8(392),1,1,8)
call HGT_invQ_OLR(G1H8(392),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(392),-4,0,G2H8(45),n2h8(138))
  call Hloop_AV_Q(ntryL,G2H8(45),ex3(:),G2H4(327),m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_QV_A(ntryL,G1H8(394),ex4(:),G1H4(1),m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_Q_A(ntryL,G1H4(1),26,0,G2H4(328),n2h4(178))
  call Hloop_QV_A(ntryL,G1H8(395),ex4(:),G1H4(1),m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G1H4(1),26,0,G2H4(329),n2h4(179))
  call Hloop_QV_A(ntryL,G1H8(396),ex4(:),G1H4(1),m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G1H4(1),26,0,G2H4(330),n2h4(180))
  call Hloop_QV_A(ntryL,G1H8(397),ex4(:),G1H4(1),m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMT,G2H4(331),n2h4(181))
call HGT_OLR(G1H8(398),1,1,8)
call HGT_invQ_OLR(G1H8(398),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(398),-4,nMT,G2H8(46),n2h8(139))
  call Hloop_AV_Q(ntryL,G2H8(46),ex3(:),G2H4(332),m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_QV_A(ntryL,G1H8(400),ex4(:),G1H4(1),m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMT,G2H4(333),n2h4(182))
  call Hloop_QV_A(ntryL,G1H8(401),ex4(:),G1H4(1),m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMT,G2H4(334),n2h4(183))
  call Hloop_QV_A(ntryL,G1H8(402),ex4(:),G1H4(1),m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMT,G2H4(335),n2h4(184))
  call Hloop_AV_Q(ntryL,G1H8(403),ex4(:),G1H4(1),m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(336),n2h4(185))
call HGT_OLR(G1H8(404),1,1,8)
call HGT_invQ_OLR(G1H8(404),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(404),-4,nMB,G2H8(47),n2h8(140))
  call Hloop_QV_A(ntryL,G2H8(47),ex3(:),G2H4(337),m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_AV_Q(ntryL,G1H8(406),ex4(:),G1H4(1),m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(338),n2h4(186))
  call Hloop_AV_Q(ntryL,G1H8(407),ex4(:),G1H4(1),m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(339),n2h4(187))
  call Hloop_AV_Q(ntryL,G1H8(408),ex4(:),G1H4(1),m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(340),n2h4(188))
  call Hloop_QV_A(ntryL,G1H8(409),ex4(:),G1H4(1),m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMB,G2H4(341),n2h4(189))
call HGT_OLR(G1H8(410),1,1,8)
call HGT_invQ_OLR(G1H8(410),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(410),-4,nMB,G2H8(48),n2h8(141))
  call Hloop_AV_Q(ntryL,G2H8(48),ex3(:),G2H4(342),m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_QV_A(ntryL,G1H8(412),ex4(:),G1H4(1),m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMB,G2H4(343),n2h4(190))
  call Hloop_QV_A(ntryL,G1H8(413),ex4(:),G1H4(1),m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMB,G2H4(344),n2h4(191))
  call Hloop_QV_A(ntryL,G1H8(414),ex4(:),G1H4(1),m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G1H4(1),26,nMB,G2H4(345),n2h4(192))
  call Hloop_DV_C(ntryL,G1H8(415),18,ex4(:),G2H4(346),m3h2x4(:,346),heltab2x8(:,:,346))
call HGT_OLR(G1H8(416),1,1,8)
call HGT_invQ_OLR(G1H8(416),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(416),-4,ex3(:),4,G2H4(347),m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_DV_C(ntryL,G1H8(418),18,ex4(:),G2H4(348),m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_DV_C(ntryL,G1H8(419),18,ex4(:),G2H4(349),m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_DV_C(ntryL,G1H8(420),18,ex4(:),G2H4(350),m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_CV_D(ntryL,G1H8(421),18,ex4(:),8,G2H4(351),m3h2x4(:,351),heltab2x8(:,:,351))
call HGT_OLR(G1H8(422),1,1,8)
call HGT_invQ_OLR(G1H8(422),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(422),-4,ex3(:),G2H4(352),m3h2x4(:,352),heltab2x8(:,:,352))
  call Hloop_CV_D(ntryL,G1H8(424),18,ex4(:),8,G2H4(353),m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_CV_D(ntryL,G1H8(425),18,ex4(:),8,G2H4(354),m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_CV_D(ntryL,G1H8(426),18,ex4(:),8,G2H4(355),m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_UV_W(ntryL,G1H8(427),18,ex4(:),8,G2H4(356),m3h2x4(:,356),heltab2x8(:,:,356))
call HGT_raise_alpha_OLR(G1H8(428),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(428),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(428),-4,ex3(:),4,G2H4(357),m3h2x4(:,357),heltab2x8(:,:,357))
call signflip_OLR(G2H4(357))
  call Hloop_UV_W(ntryL,G1H8(430),18,ex4(:),8,G2H4(358),m3h2x4(:,358),heltab2x8(:,:,358))
  call Hloop_UV_W(ntryL,G1H8(431),18,ex4(:),8,G2H4(359),m3h2x4(:,359),heltab2x8(:,:,359))
  call Hloop_UV_W(ntryL,G1H8(432),18,ex4(:),8,G2H4(360),m3h2x4(:,360),heltab2x8(:,:,360))
  call Hloop_AV_Q(ntryL,G1H8(433),ex3(:),G1H4(1),m3h2x4(:,361),heltab2x8(:,:,361))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(361),n2h4(193))
call HGT_OLR(G1H8(434),1,1,8)
call HGT_invQ_OLR(G1H8(434),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(434),-8,0,G2H8(49),n2h8(145))
  call Hloop_QV_A(ntryL,G2H8(49),ex4(:),G2H4(362),m3h2x4(:,362),heltab2x8(:,:,362))
  call Hloop_AV_Q(ntryL,G1H8(436),ex3(:),G1H4(1),m3h2x4(:,363),heltab2x8(:,:,363))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(363),n2h4(194))
  call Hloop_AV_Q(ntryL,G1H8(437),ex3(:),G1H4(1),m3h2x4(:,364),heltab2x8(:,:,364))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(364),n2h4(195))
  call Hloop_AV_Q(ntryL,G1H8(438),ex3(:),G1H4(1),m3h2x4(:,365),heltab2x8(:,:,365))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(365),n2h4(196))
  call Hloop_AV_Q(ntryL,G1H8(439),ex3(:),G1H4(1),m3h2x4(:,366),heltab2x8(:,:,366))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(366),n2h4(197))
call HGT_OLR(G1H8(440),1,1,8)
call HGT_invQ_OLR(G1H8(440),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(440),-8,nMT,G2H8(50),n2h8(146))
  call Hloop_QV_A(ntryL,G2H8(50),ex4(:),G2H4(367),m3h2x4(:,367),heltab2x8(:,:,367))
  call Hloop_AV_Q(ntryL,G1H8(442),ex3(:),G1H4(1),m3h2x4(:,368),heltab2x8(:,:,368))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(368),n2h4(198))
  call Hloop_AV_Q(ntryL,G1H8(443),ex3(:),G1H4(1),m3h2x4(:,369),heltab2x8(:,:,369))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(369),n2h4(199))
  call Hloop_AV_Q(ntryL,G1H8(444),ex3(:),G1H4(1),m3h2x4(:,370),heltab2x8(:,:,370))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(370),n2h4(200))
  call Hloop_QV_A(ntryL,G1H8(445),ex3(:),G1H4(1),m3h2x4(:,371),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(371),n2h4(201))
call HGT_OLR(G1H8(446),1,1,8)
call HGT_invQ_OLR(G1H8(446),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(446),-8,0,G2H8(51),n2h8(147))
  call Hloop_AV_Q(ntryL,G2H8(51),ex4(:),G2H4(372),m3h2x4(:,372),heltab2x8(:,:,372))
  call Hloop_QV_A(ntryL,G1H8(448),ex3(:),G1H4(1),m3h2x4(:,373),heltab2x8(:,:,373))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(373),n2h4(202))
  call Hloop_QV_A(ntryL,G1H8(449),ex3(:),G1H4(1),m3h2x4(:,374),heltab2x8(:,:,374))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(374),n2h4(203))
  call Hloop_QV_A(ntryL,G1H8(450),ex3(:),G1H4(1),m3h2x4(:,375),heltab2x8(:,:,375))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(375),n2h4(204))
  call Hloop_QV_A(ntryL,G1H8(451),ex3(:),G1H4(1),m3h2x4(:,376),heltab2x8(:,:,376))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(376),n2h4(205))
call HGT_OLR(G1H8(452),1,1,8)
call HGT_invQ_OLR(G1H8(452),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(452),-8,nMT,G2H8(52),n2h8(148))
  call Hloop_AV_Q(ntryL,G2H8(52),ex4(:),G2H4(377),m3h2x4(:,377),heltab2x8(:,:,377))
  call Hloop_QV_A(ntryL,G1H8(454),ex3(:),G1H4(1),m3h2x4(:,378),heltab2x8(:,:,378))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(378),n2h4(206))
  call Hloop_QV_A(ntryL,G1H8(455),ex3(:),G1H4(1),m3h2x4(:,379),heltab2x8(:,:,379))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(379),n2h4(207))
  call Hloop_QV_A(ntryL,G1H8(456),ex3(:),G1H4(1),m3h2x4(:,380),heltab2x8(:,:,380))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(380),n2h4(208))
  call Hloop_AV_Q(ntryL,G1H8(457),ex3(:),G1H4(1),m3h2x4(:,381),heltab2x8(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(381),n2h4(209))
call HGT_OLR(G1H8(458),1,1,8)
call HGT_invQ_OLR(G1H8(458),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(458),-8,nMB,G2H8(53),n2h8(149))
  call Hloop_QV_A(ntryL,G2H8(53),ex4(:),G2H4(382),m3h2x4(:,382),heltab2x8(:,:,382))
  call Hloop_AV_Q(ntryL,G1H8(460),ex3(:),G1H4(1),m3h2x4(:,383),heltab2x8(:,:,383))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(383),n2h4(210))
  call Hloop_AV_Q(ntryL,G1H8(461),ex3(:),G1H4(1),m3h2x4(:,384),heltab2x8(:,:,384))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(384),n2h4(211))
  call Hloop_AV_Q(ntryL,G1H8(462),ex3(:),G1H4(1),m3h2x4(:,385),heltab2x8(:,:,385))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(385),n2h4(212))
  call Hloop_QV_A(ntryL,G1H8(463),ex3(:),G1H4(1),m3h2x4(:,386),heltab2x8(:,:,386))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(386),n2h4(213))
call HGT_OLR(G1H8(464),1,1,8)
call HGT_invQ_OLR(G1H8(464),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(464),-8,nMB,G2H8(54),n2h8(150))
  call Hloop_AV_Q(ntryL,G2H8(54),ex4(:),G2H4(387),m3h2x4(:,387),heltab2x8(:,:,387))
  call Hloop_QV_A(ntryL,G1H8(466),ex3(:),G1H4(1),m3h2x4(:,388),heltab2x8(:,:,388))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(388),n2h4(214))
  call Hloop_QV_A(ntryL,G1H8(467),ex3(:),G1H4(1),m3h2x4(:,389),heltab2x8(:,:,389))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(389),n2h4(215))
  call Hloop_QV_A(ntryL,G1H8(468),ex3(:),G1H4(1),m3h2x4(:,390),heltab2x8(:,:,390))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(390),n2h4(216))
  call Hloop_DV_C(ntryL,G1H8(469),17,ex3(:),G2H4(391),m3h2x4(:,391),heltab2x8(:,:,391))
call HGT_OLR(G1H8(470),1,1,8)
call HGT_invQ_OLR(G1H8(470),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(470),-8,ex4(:),8,G2H4(392),m3h2x4(:,392),heltab2x8(:,:,392))
  call Hloop_DV_C(ntryL,G1H8(472),17,ex3(:),G2H4(393),m3h2x4(:,393),heltab2x8(:,:,393))
  call Hloop_DV_C(ntryL,G1H8(473),17,ex3(:),G2H4(394),m3h2x4(:,394),heltab2x8(:,:,394))
  call Hloop_DV_C(ntryL,G1H8(474),17,ex3(:),G2H4(395),m3h2x4(:,395),heltab2x8(:,:,395))
  call Hloop_CV_D(ntryL,G1H8(475),17,ex3(:),4,G2H4(396),m3h2x4(:,396),heltab2x8(:,:,396))
call HGT_OLR(G1H8(476),1,1,8)
call HGT_invQ_OLR(G1H8(476),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(476),-8,ex4(:),G2H4(397),m3h2x4(:,397),heltab2x8(:,:,397))
  call Hloop_CV_D(ntryL,G1H8(478),17,ex3(:),4,G2H4(398),m3h2x4(:,398),heltab2x8(:,:,398))
  call Hloop_CV_D(ntryL,G1H8(479),17,ex3(:),4,G2H4(399),m3h2x4(:,399),heltab2x8(:,:,399))
  call Hloop_CV_D(ntryL,G1H8(480),17,ex3(:),4,G2H4(400),m3h2x4(:,400),heltab2x8(:,:,400))
  call Hloop_UV_W(ntryL,G1H8(481),17,ex3(:),4,G2H4(401),m3h2x4(:,401),heltab2x8(:,:,401))
call HGT_raise_alpha_OLR(G1H8(482),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(482),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(482),-8,ex4(:),8,G2H4(402),m3h2x4(:,402),heltab2x8(:,:,402))
call signflip_OLR(G2H4(402))
  call Hloop_UV_W(ntryL,G1H8(484),17,ex3(:),4,G2H4(403),m3h2x4(:,403),heltab2x8(:,:,403))
  call Hloop_UV_W(ntryL,G1H8(485),17,ex3(:),4,G2H4(404),m3h2x4(:,404),heltab2x8(:,:,404))
  call Hloop_UV_W(ntryL,G1H8(486),17,ex3(:),4,G2H4(405),m3h2x4(:,405),heltab2x8(:,:,405))
  call Hloop_AV_Q(ntryL,G1H8(487),ex3(:),G1H4(1),m3h2x4(:,406),heltab2x8(:,:,406))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(406),n2h4(217))
call HGT_OLR(G1H8(488),1,1,8)
call HGT_invQ_OLR(G1H8(488),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(488),-2,0,G2H8(55),n2h8(154))
  call Hloop_QV_A(ntryL,G2H8(55),ex2(:),G2H4(407),m3h2x4(:,407),heltab2x8(:,:,407))
  call Hloop_AV_Q(ntryL,G1H8(490),ex3(:),G1H4(1),m3h2x4(:,408),heltab2x8(:,:,408))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(408),n2h4(218))
  call Hloop_AV_Q(ntryL,G1H8(491),ex3(:),G1H4(1),m3h2x4(:,409),heltab2x8(:,:,409))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(409),n2h4(219))
  call Hloop_AV_Q(ntryL,G1H8(492),ex3(:),G1H4(1),m3h2x4(:,410),heltab2x8(:,:,410))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(410),n2h4(220))
  call Hloop_AV_Q(ntryL,G1H8(493),ex3(:),G1H4(1),m3h2x4(:,411),heltab2x8(:,:,411))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(411),n2h4(221))
call HGT_OLR(G1H8(494),1,1,8)
call HGT_invQ_OLR(G1H8(494),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(494),-2,nMT,G2H8(56),n2h8(155))
  call Hloop_QV_A(ntryL,G2H8(56),ex2(:),G2H4(412),m3h2x4(:,412),heltab2x8(:,:,412))
  call Hloop_AV_Q(ntryL,G1H8(496),ex3(:),G1H4(1),m3h2x4(:,413),heltab2x8(:,:,413))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(413),n2h4(222))
  call Hloop_AV_Q(ntryL,G1H8(497),ex3(:),G1H4(1),m3h2x4(:,414),heltab2x8(:,:,414))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(414),n2h4(223))
  call Hloop_AV_Q(ntryL,G1H8(498),ex3(:),G1H4(1),m3h2x4(:,415),heltab2x8(:,:,415))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMT,G2H4(415),n2h4(224))
  call Hloop_QV_A(ntryL,G1H8(499),ex3(:),G1H4(1),m3h2x4(:,416),heltab2x8(:,:,416))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(416),n2h4(225))
call HGT_OLR(G1H8(500),1,1,8)
call HGT_invQ_OLR(G1H8(500),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(500),-2,0,G2H8(57),n2h8(156))
  call Hloop_AV_Q(ntryL,G2H8(57),ex2(:),G2H4(417),m3h2x4(:,417),heltab2x8(:,:,417))
  call Hloop_QV_A(ntryL,G1H8(502),ex3(:),G1H4(1),m3h2x4(:,418),heltab2x8(:,:,418))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(418),n2h4(226))
  call Hloop_QV_A(ntryL,G1H8(503),ex3(:),G1H4(1),m3h2x4(:,419),heltab2x8(:,:,419))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(419),n2h4(227))
  call Hloop_QV_A(ntryL,G1H8(504),ex3(:),G1H4(1),m3h2x4(:,420),heltab2x8(:,:,420))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(420),n2h4(228))
  call Hloop_QV_A(ntryL,G1H8(505),ex3(:),G1H4(1),m3h2x4(:,421),heltab2x8(:,:,421))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(421),n2h4(229))
call HGT_OLR(G1H8(506),1,1,8)
call HGT_invQ_OLR(G1H8(506),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(506),-2,nMT,G2H8(58),n2h8(157))
  call Hloop_AV_Q(ntryL,G2H8(58),ex2(:),G2H4(422),m3h2x4(:,422),heltab2x8(:,:,422))
  call Hloop_QV_A(ntryL,G1H8(508),ex3(:),G1H4(1),m3h2x4(:,423),heltab2x8(:,:,423))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(423),n2h4(230))
  call Hloop_QV_A(ntryL,G1H8(509),ex3(:),G1H4(1),m3h2x4(:,424),heltab2x8(:,:,424))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(424),n2h4(231))
  call Hloop_QV_A(ntryL,G1H8(510),ex3(:),G1H4(1),m3h2x4(:,425),heltab2x8(:,:,425))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(425),n2h4(232))
  call Hloop_AV_Q(ntryL,G1H8(511),ex3(:),G1H4(1),m3h2x4(:,426),heltab2x8(:,:,426))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(426),n2h4(233))
call HGT_OLR(G1H8(512),1,1,8)
call HGT_invQ_OLR(G1H8(512),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(512),-2,nMB,G2H8(59),n2h8(158))
  call Hloop_QV_A(ntryL,G2H8(59),ex2(:),G2H4(427),m3h2x4(:,427),heltab2x8(:,:,427))
  call Hloop_AV_Q(ntryL,G1H8(514),ex3(:),G1H4(1),m3h2x4(:,428),heltab2x8(:,:,428))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(428),n2h4(234))
  call Hloop_AV_Q(ntryL,G1H8(515),ex3(:),G1H4(1),m3h2x4(:,429),heltab2x8(:,:,429))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(429),n2h4(235))
  call Hloop_AV_Q(ntryL,G1H8(516),ex3(:),G1H4(1),m3h2x4(:,430),heltab2x8(:,:,430))
  call Hloop_A_Q(ntryL,G1H4(1),21,nMB,G2H4(430),n2h4(236))
  call Hloop_QV_A(ntryL,G1H8(517),ex3(:),G1H4(1),m3h2x4(:,431),heltab2x8(:,:,431))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(431),n2h4(237))
call HGT_OLR(G1H8(518),1,1,8)
call HGT_invQ_OLR(G1H8(518),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(518),-2,nMB,G2H8(60),n2h8(159))
  call Hloop_AV_Q(ntryL,G2H8(60),ex2(:),G2H4(432),m3h2x4(:,432),heltab2x8(:,:,432))
  call Hloop_QV_A(ntryL,G1H8(520),ex3(:),G1H4(1),m3h2x4(:,433),heltab2x8(:,:,433))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(433),n2h4(238))
  call Hloop_QV_A(ntryL,G1H8(521),ex3(:),G1H4(1),m3h2x4(:,434),heltab2x8(:,:,434))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(434),n2h4(239))
  call Hloop_QV_A(ntryL,G1H8(522),ex3(:),G1H4(1),m3h2x4(:,435),heltab2x8(:,:,435))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(435),n2h4(240))
  call Hloop_DV_C(ntryL,G1H8(523),17,ex3(:),G2H4(436),m3h2x4(:,436),heltab2x8(:,:,436))
call HGT_OLR(G1H8(524),1,1,8)
call HGT_invQ_OLR(G1H8(524),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(524),-2,ex2(:),2,G2H4(437),m3h2x4(:,437),heltab2x8(:,:,437))
  call Hloop_DV_C(ntryL,G1H8(526),17,ex3(:),G2H4(438),m3h2x4(:,438),heltab2x8(:,:,438))
  call Hloop_DV_C(ntryL,G1H8(527),17,ex3(:),G2H4(439),m3h2x4(:,439),heltab2x8(:,:,439))
  call Hloop_DV_C(ntryL,G1H8(528),17,ex3(:),G2H4(440),m3h2x4(:,440),heltab2x8(:,:,440))
  call Hloop_CV_D(ntryL,G1H8(529),17,ex3(:),4,G2H4(441),m3h2x4(:,441),heltab2x8(:,:,441))
call HGT_OLR(G1H8(530),1,1,8)
call HGT_invQ_OLR(G1H8(530),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(530),-2,ex2(:),G2H4(442),m3h2x4(:,442),heltab2x8(:,:,442))
  call Hloop_CV_D(ntryL,G1H8(532),17,ex3(:),4,G2H4(443),m3h2x4(:,443),heltab2x8(:,:,443))
  call Hloop_CV_D(ntryL,G1H8(533),17,ex3(:),4,G2H4(444),m3h2x4(:,444),heltab2x8(:,:,444))
  call Hloop_CV_D(ntryL,G1H8(534),17,ex3(:),4,G2H4(445),m3h2x4(:,445),heltab2x8(:,:,445))
  call Hloop_UV_W(ntryL,G1H8(535),17,ex3(:),4,G2H4(446),m3h2x4(:,446),heltab2x8(:,:,446))
call HGT_raise_alpha_OLR(G1H8(536),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(536),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(536),-2,ex2(:),2,G2H4(447),m3h2x4(:,447),heltab2x8(:,:,447))
call signflip_OLR(G2H4(447))
  call Hloop_UV_W(ntryL,G1H8(538),17,ex3(:),4,G2H4(448),m3h2x4(:,448),heltab2x8(:,:,448))
  call Hloop_UV_W(ntryL,G1H8(539),17,ex3(:),4,G2H4(449),m3h2x4(:,449),heltab2x8(:,:,449))
  call Hloop_UV_W(ntryL,G1H8(540),17,ex3(:),4,G2H4(450),m3h2x4(:,450),heltab2x8(:,:,450))
  call Hloop_AV_Q(ntryL,G1H8(541),ex4(:),G1H4(1),m3h2x4(:,451),heltab2x8(:,:,451))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(451),n2h4(241))
call HGT_OLR(G1H8(542),1,1,8)
call HGT_invQ_OLR(G1H8(542),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(542),-4,0,G2H8(61),n2h8(163))
  call Hloop_QV_A(ntryL,G2H8(61),ex3(:),G2H4(452),m3h2x4(:,452),heltab2x8(:,:,452))
  call Hloop_AV_Q(ntryL,G1H8(544),ex4(:),G1H4(1),m3h2x4(:,453),heltab2x8(:,:,453))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(453),n2h4(242))
  call Hloop_AV_Q(ntryL,G1H8(545),ex4(:),G1H4(1),m3h2x4(:,454),heltab2x8(:,:,454))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(454),n2h4(243))
  call Hloop_AV_Q(ntryL,G1H8(546),ex4(:),G1H4(1),m3h2x4(:,455),heltab2x8(:,:,455))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(455),n2h4(244))
  call Hloop_AV_Q(ntryL,G1H8(547),ex4(:),G1H4(1),m3h2x4(:,456),heltab2x8(:,:,456))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(456),n2h4(245))
call HGT_OLR(G1H8(548),1,1,8)
call HGT_invQ_OLR(G1H8(548),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(548),-4,nMT,G2H8(62),n2h8(164))
  call Hloop_QV_A(ntryL,G2H8(62),ex3(:),G2H4(457),m3h2x4(:,457),heltab2x8(:,:,457))
  call Hloop_AV_Q(ntryL,G1H8(550),ex4(:),G1H4(1),m3h2x4(:,458),heltab2x8(:,:,458))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(458),n2h4(246))
  call Hloop_AV_Q(ntryL,G1H8(551),ex4(:),G1H4(1),m3h2x4(:,459),heltab2x8(:,:,459))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(459),n2h4(247))
  call Hloop_AV_Q(ntryL,G1H8(552),ex4(:),G1H4(1),m3h2x4(:,460),heltab2x8(:,:,460))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(460),n2h4(248))
  call Hloop_QV_A(ntryL,G1H8(553),ex4(:),G1H4(1),m3h2x4(:,461),heltab2x8(:,:,461))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(461),n2h4(249))
call HGT_OLR(G1H8(554),1,1,8)
call HGT_invQ_OLR(G1H8(554),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(554),-4,0,G2H8(63),n2h8(165))
  call Hloop_AV_Q(ntryL,G2H8(63),ex3(:),G2H4(462),m3h2x4(:,462),heltab2x8(:,:,462))
  call Hloop_QV_A(ntryL,G1H8(556),ex4(:),G1H4(1),m3h2x4(:,463),heltab2x8(:,:,463))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(463),n2h4(250))
  call Hloop_QV_A(ntryL,G1H8(557),ex4(:),G1H4(1),m3h2x4(:,464),heltab2x8(:,:,464))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(464),n2h4(251))
  call Hloop_QV_A(ntryL,G1H8(558),ex4(:),G1H4(1),m3h2x4(:,465),heltab2x8(:,:,465))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(465),n2h4(252))
  call Hloop_QV_A(ntryL,G1H8(559),ex4(:),G1H4(1),m3h2x4(:,466),heltab2x8(:,:,466))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(466),n2h4(253))
call HGT_OLR(G1H8(560),1,1,8)
call HGT_invQ_OLR(G1H8(560),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(560),-4,nMT,G2H8(64),n2h8(166))
  call Hloop_AV_Q(ntryL,G2H8(64),ex3(:),G2H4(467),m3h2x4(:,467),heltab2x8(:,:,467))
  call Hloop_QV_A(ntryL,G1H8(562),ex4(:),G1H4(1),m3h2x4(:,468),heltab2x8(:,:,468))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(468),n2h4(254))
  call Hloop_QV_A(ntryL,G1H8(563),ex4(:),G1H4(1),m3h2x4(:,469),heltab2x8(:,:,469))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(469),n2h4(255))
  call Hloop_QV_A(ntryL,G1H8(564),ex4(:),G1H4(1),m3h2x4(:,470),heltab2x8(:,:,470))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(470),n2h4(256))
  call Hloop_AV_Q(ntryL,G1H8(565),ex4(:),G1H4(1),m3h2x4(:,471),heltab2x8(:,:,471))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(471),n2h4(257))
call HGT_OLR(G1H8(566),1,1,8)
call HGT_invQ_OLR(G1H8(566),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(566),-4,nMB,G2H8(65),n2h8(167))
  call Hloop_QV_A(ntryL,G2H8(65),ex3(:),G2H4(472),m3h2x4(:,472),heltab2x8(:,:,472))
  call Hloop_AV_Q(ntryL,G1H8(568),ex4(:),G1H4(1),m3h2x4(:,473),heltab2x8(:,:,473))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(473),n2h4(258))
  call Hloop_AV_Q(ntryL,G1H8(569),ex4(:),G1H4(1),m3h2x4(:,474),heltab2x8(:,:,474))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(474),n2h4(259))
  call Hloop_AV_Q(ntryL,G1H8(570),ex4(:),G1H4(1),m3h2x4(:,475),heltab2x8(:,:,475))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(475),n2h4(260))
  call Hloop_QV_A(ntryL,G1H8(571),ex4(:),G1H4(1),m3h2x4(:,476),heltab2x8(:,:,476))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(476),n2h4(261))
call HGT_OLR(G1H8(572),1,1,8)
call HGT_invQ_OLR(G1H8(572),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(572),-4,nMB,G2H8(66),n2h8(168))
  call Hloop_AV_Q(ntryL,G2H8(66),ex3(:),G2H4(477),m3h2x4(:,477),heltab2x8(:,:,477))
  call Hloop_QV_A(ntryL,G1H8(574),ex4(:),G1H4(1),m3h2x4(:,478),heltab2x8(:,:,478))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(478),n2h4(262))
  call Hloop_QV_A(ntryL,G1H8(575),ex4(:),G1H4(1),m3h2x4(:,479),heltab2x8(:,:,479))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(479),n2h4(263))
  call Hloop_QV_A(ntryL,G1H8(576),ex4(:),G1H4(1),m3h2x4(:,480),heltab2x8(:,:,480))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(480),n2h4(264))
  call Hloop_DV_C(ntryL,G1H8(577),17,ex4(:),G2H4(481),m3h2x4(:,481),heltab2x8(:,:,481))
call HGT_OLR(G1H8(578),1,1,8)
call HGT_invQ_OLR(G1H8(578),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(578),-4,ex3(:),4,G2H4(482),m3h2x4(:,482),heltab2x8(:,:,482))
  call Hloop_DV_C(ntryL,G1H8(580),17,ex4(:),G2H4(483),m3h2x4(:,483),heltab2x8(:,:,483))
  call Hloop_DV_C(ntryL,G1H8(581),17,ex4(:),G2H4(484),m3h2x4(:,484),heltab2x8(:,:,484))
  call Hloop_DV_C(ntryL,G1H8(582),17,ex4(:),G2H4(485),m3h2x4(:,485),heltab2x8(:,:,485))
  call Hloop_CV_D(ntryL,G1H8(583),17,ex4(:),8,G2H4(486),m3h2x4(:,486),heltab2x8(:,:,486))
call HGT_OLR(G1H8(584),1,1,8)
call HGT_invQ_OLR(G1H8(584),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(584),-4,ex3(:),G2H4(487),m3h2x4(:,487),heltab2x8(:,:,487))
  call Hloop_CV_D(ntryL,G1H8(586),17,ex4(:),8,G2H4(488),m3h2x4(:,488),heltab2x8(:,:,488))
  call Hloop_CV_D(ntryL,G1H8(587),17,ex4(:),8,G2H4(489),m3h2x4(:,489),heltab2x8(:,:,489))
  call Hloop_CV_D(ntryL,G1H8(588),17,ex4(:),8,G2H4(490),m3h2x4(:,490),heltab2x8(:,:,490))
  call Hloop_UV_W(ntryL,G1H8(589),17,ex4(:),8,G2H4(491),m3h2x4(:,491),heltab2x8(:,:,491))
call HGT_raise_alpha_OLR(G1H8(590),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(590),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(590),-4,ex3(:),4,G2H4(492),m3h2x4(:,492),heltab2x8(:,:,492))
call signflip_OLR(G2H4(492))
  call Hloop_UV_W(ntryL,G1H8(592),17,ex4(:),8,G2H4(493),m3h2x4(:,493),heltab2x8(:,:,493))
  call Hloop_UV_W(ntryL,G1H8(593),17,ex4(:),8,G2H4(494),m3h2x4(:,494),heltab2x8(:,:,494))
  call Hloop_UV_W(ntryL,G1H8(594),17,ex4(:),8,G2H4(495),m3h2x4(:,495),heltab2x8(:,:,495))
  call Hloop_AV_Q(ntryL,G1H8(595),ex4(:),G1H4(1),m3h2x4(:,496),heltab2x8(:,:,496))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(496),n2h4(265))
call HGT_OLR(G1H8(596),1,1,8)
call HGT_invQ_OLR(G1H8(596),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(596),-2,0,G2H8(67),n2h8(172))
  call Hloop_QV_A(ntryL,G2H8(67),ex2(:),G2H4(497),m3h2x4(:,497),heltab2x8(:,:,497))
  call Hloop_AV_Q(ntryL,G1H8(598),ex4(:),G1H4(1),m3h2x4(:,498),heltab2x8(:,:,498))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(498),n2h4(266))
  call Hloop_AV_Q(ntryL,G1H8(599),ex4(:),G1H4(1),m3h2x4(:,499),heltab2x8(:,:,499))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(499),n2h4(267))
  call Hloop_AV_Q(ntryL,G1H8(600),ex4(:),G1H4(1),m3h2x4(:,500),heltab2x8(:,:,500))
  call Hloop_A_Q(ntryL,G1H4(1),25,0,G2H4(500),n2h4(268))
  call Hloop_AV_Q(ntryL,G1H8(601),ex4(:),G1H4(1),m3h2x4(:,501),heltab2x8(:,:,501))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(501),n2h4(269))
call HGT_OLR(G1H8(602),1,1,8)
call HGT_invQ_OLR(G1H8(602),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(602),-2,nMT,G2H8(68),n2h8(173))
  call Hloop_QV_A(ntryL,G2H8(68),ex2(:),G2H4(502),m3h2x4(:,502),heltab2x8(:,:,502))
  call Hloop_AV_Q(ntryL,G1H8(604),ex4(:),G1H4(1),m3h2x4(:,503),heltab2x8(:,:,503))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(503),n2h4(270))
  call Hloop_AV_Q(ntryL,G1H8(605),ex4(:),G1H4(1),m3h2x4(:,504),heltab2x8(:,:,504))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(504),n2h4(271))
  call Hloop_AV_Q(ntryL,G1H8(606),ex4(:),G1H4(1),m3h2x4(:,505),heltab2x8(:,:,505))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMT,G2H4(505),n2h4(272))
  call Hloop_QV_A(ntryL,G1H8(607),ex4(:),G1H4(1),m3h2x4(:,506),heltab2x8(:,:,506))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(506),n2h4(273))
call HGT_OLR(G1H8(608),1,1,8)
call HGT_invQ_OLR(G1H8(608),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(608),-2,0,G2H8(69),n2h8(174))
  call Hloop_AV_Q(ntryL,G2H8(69),ex2(:),G2H4(507),m3h2x4(:,507),heltab2x8(:,:,507))
  call Hloop_QV_A(ntryL,G1H8(610),ex4(:),G1H4(1),m3h2x4(:,508),heltab2x8(:,:,508))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(508),n2h4(274))
  call Hloop_QV_A(ntryL,G1H8(611),ex4(:),G1H4(1),m3h2x4(:,509),heltab2x8(:,:,509))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(509),n2h4(275))
  call Hloop_QV_A(ntryL,G1H8(612),ex4(:),G1H4(1),m3h2x4(:,510),heltab2x8(:,:,510))
  call Hloop_Q_A(ntryL,G1H4(1),25,0,G2H4(510),n2h4(276))
  call Hloop_QV_A(ntryL,G1H8(613),ex4(:),G1H4(1),m3h2x4(:,511),heltab2x8(:,:,511))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(511),n2h4(277))
call HGT_OLR(G1H8(614),1,1,8)
call HGT_invQ_OLR(G1H8(614),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(614),-2,nMT,G2H8(70),n2h8(175))
  call Hloop_AV_Q(ntryL,G2H8(70),ex2(:),G2H4(512),m3h2x4(:,512),heltab2x8(:,:,512))
  call Hloop_QV_A(ntryL,G1H8(616),ex4(:),G1H4(1),m3h2x4(:,513),heltab2x8(:,:,513))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(513),n2h4(278))
  call Hloop_QV_A(ntryL,G1H8(617),ex4(:),G1H4(1),m3h2x4(:,514),heltab2x8(:,:,514))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(514),n2h4(279))
  call Hloop_QV_A(ntryL,G1H8(618),ex4(:),G1H4(1),m3h2x4(:,515),heltab2x8(:,:,515))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMT,G2H4(515),n2h4(280))
  call Hloop_AV_Q(ntryL,G1H8(619),ex4(:),G1H4(1),m3h2x4(:,516),heltab2x8(:,:,516))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(516),n2h4(281))
call HGT_OLR(G1H8(620),1,1,8)
call HGT_invQ_OLR(G1H8(620),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(620),-2,nMB,G2H8(71),n2h8(176))
  call Hloop_QV_A(ntryL,G2H8(71),ex2(:),G2H4(517),m3h2x4(:,517),heltab2x8(:,:,517))
  call Hloop_AV_Q(ntryL,G1H8(622),ex4(:),G1H4(1),m3h2x4(:,518),heltab2x8(:,:,518))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(518),n2h4(282))
  call Hloop_AV_Q(ntryL,G1H8(623),ex4(:),G1H4(1),m3h2x4(:,519),heltab2x8(:,:,519))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(519),n2h4(283))
  call Hloop_AV_Q(ntryL,G1H8(624),ex4(:),G1H4(1),m3h2x4(:,520),heltab2x8(:,:,520))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(520),n2h4(284))
  call Hloop_QV_A(ntryL,G1H8(625),ex4(:),G1H4(1),m3h2x4(:,521),heltab2x8(:,:,521))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(521),n2h4(285))
call HGT_OLR(G1H8(626),1,1,8)
call HGT_invQ_OLR(G1H8(626),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(626),-2,nMB,G2H8(72),n2h8(177))
  call Hloop_AV_Q(ntryL,G2H8(72),ex2(:),G2H4(522),m3h2x4(:,522),heltab2x8(:,:,522))
  call Hloop_QV_A(ntryL,G1H8(628),ex4(:),G1H4(1),m3h2x4(:,523),heltab2x8(:,:,523))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(523),n2h4(286))
  call Hloop_QV_A(ntryL,G1H8(629),ex4(:),G1H4(1),m3h2x4(:,524),heltab2x8(:,:,524))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(524),n2h4(287))
  call Hloop_QV_A(ntryL,G1H8(630),ex4(:),G1H4(1),m3h2x4(:,525),heltab2x8(:,:,525))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(525),n2h4(288))
  call Hloop_DV_C(ntryL,G1H8(631),17,ex4(:),G2H4(526),m3h2x4(:,526),heltab2x8(:,:,526))
call HGT_OLR(G1H8(632),1,1,8)
call HGT_invQ_OLR(G1H8(632),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(632),-2,ex2(:),2,G2H4(527),m3h2x4(:,527),heltab2x8(:,:,527))
  call Hloop_DV_C(ntryL,G1H8(634),17,ex4(:),G2H4(528),m3h2x4(:,528),heltab2x8(:,:,528))
  call Hloop_DV_C(ntryL,G1H8(635),17,ex4(:),G2H4(529),m3h2x4(:,529),heltab2x8(:,:,529))
  call Hloop_DV_C(ntryL,G1H8(636),17,ex4(:),G2H4(530),m3h2x4(:,530),heltab2x8(:,:,530))
  call Hloop_CV_D(ntryL,G1H8(637),17,ex4(:),8,G2H4(531),m3h2x4(:,531),heltab2x8(:,:,531))
call HGT_OLR(G1H8(638),1,1,8)
call HGT_invQ_OLR(G1H8(638),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(638),-2,ex2(:),G2H4(532),m3h2x4(:,532),heltab2x8(:,:,532))
  call Hloop_CV_D(ntryL,G1H8(640),17,ex4(:),8,G2H4(533),m3h2x4(:,533),heltab2x8(:,:,533))
  call Hloop_CV_D(ntryL,G1H8(641),17,ex4(:),8,G2H4(534),m3h2x4(:,534),heltab2x8(:,:,534))
  call Hloop_CV_D(ntryL,G1H8(642),17,ex4(:),8,G2H4(535),m3h2x4(:,535),heltab2x8(:,:,535))
  call Hloop_UV_W(ntryL,G1H8(643),17,ex4(:),8,G2H4(536),m3h2x4(:,536),heltab2x8(:,:,536))
call HGT_raise_alpha_OLR(G1H8(644),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(644),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(644),-2,ex2(:),2,G2H4(537),m3h2x4(:,537),heltab2x8(:,:,537))
call signflip_OLR(G2H4(537))
  call Hloop_UV_W(ntryL,G1H8(646),17,ex4(:),8,G2H4(538),m3h2x4(:,538),heltab2x8(:,:,538))
  call Hloop_UV_W(ntryL,G1H8(647),17,ex4(:),8,G2H4(539),m3h2x4(:,539),heltab2x8(:,:,539))
  call Hloop_UV_W(ntryL,G1H8(648),17,ex4(:),8,G2H4(540),m3h2x4(:,540),heltab2x8(:,:,540))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(1),mass4set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G0H4(1),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(2),mass4set(:,1),  & 
G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),G0H4(2),4)
  call HG1shiftOLR(G1H4(13),10,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,2),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(1),mass4set(:,2),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G0H4(3),4)
  call HG1shiftOLR(G1H4(24),8,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(2),mass4set(:,2),  & 
G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),G0H4(4),4)
  call HG1shiftOLR(G1H4(29),10,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(1),mass5set(:,1),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(1),mass4set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G0H4(5),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(2),mass4set(:,1),  & 
G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),G0H4(6),4)
  call HG1shiftOLR(G1H4(45),10,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(1),mass5set(:,2),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(1),mass4set(:,2),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G0H4(7),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(2),mass4set(:,2),  & 
G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),G0H4(8),4)
  call HG1shiftOLR(G1H4(61),10,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(1),mass5set(:,3),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(1),mass4set(:,3),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G0H4(9),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(2),mass4set(:,3),  & 
G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),G0H4(10),4)
  call HG1shiftOLR(G1H4(77),10,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(1),mass5set(:,3),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(1),mass4set(:,3),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G0H4(11),4)
  call HG1shiftOLR(G1H4(88),8,4)
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(2),mass4set(:,3),  & 
G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),G0H4(12),4)
  call HG1shiftOLR(G1H4(93),10,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(1),mass5set(:,1),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(1),mass4set(:,1),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G0H4(13),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(2),mass4set(:,1),  & 
G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),G0H4(14),4)
  call HG1shiftOLR(G1H4(109),10,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(1),mass5set(:,1),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),8,4)
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(1),mass4set(:,1),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G0H4(15),4)
  call HG1shiftOLR(G1H4(120),8,4)
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(2),mass4set(:,1),  & 
G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),G0H4(16),4)
  call HG1shiftOLR(G1H4(125),10,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(1),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),8,4)
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(1),mass4set(:,1),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G0H4(17),4)
  call HG1shiftOLR(G1H4(136),8,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(2),mass4set(:,1),  & 
G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),G0H4(18),4)
  call HG1shiftOLR(G1H4(141),10,4)
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(2),mass5set(:,1),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(3),mass4set(:,1),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G0H4(19),4)
  call HG1shiftOLR(G1H4(152),8,4)
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(4),mass4set(:,1),  & 
G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),G0H4(20),4)
  call HG1shiftOLR(G1H4(157),12,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(2),mass5set(:,2),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),8,4)
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(3),mass4set(:,2),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G0H4(21),4)
  call HG1shiftOLR(G1H4(168),8,4)
  call Hotf_4pt_reduction(G2H4(55),RedSet_4(4),mass4set(:,2),  & 
G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),G0H4(22),4)
  call HG1shiftOLR(G1H4(173),12,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(2),mass5set(:,1),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(178),8,4)
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(3),mass4set(:,1),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),G0H4(23),4)
  call HG1shiftOLR(G1H4(184),8,4)
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(4),mass4set(:,1),  & 
G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),G0H4(24),4)
  call HG1shiftOLR(G1H4(189),12,4)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(2),mass5set(:,2),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(3),mass4set(:,2),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G0H4(25),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(4),mass4set(:,2),  & 
G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),G0H4(26),4)
  call HG1shiftOLR(G1H4(205),12,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(2),mass5set(:,3),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(210),8,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(3),mass4set(:,3),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G0H4(27),4)
  call HG1shiftOLR(G1H4(216),8,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(4),mass4set(:,3),  & 
G1H4(220),G1H4(221),G1H4(222),G1H4(223),G1H4(224),G0H4(28),4)
  call HG1shiftOLR(G1H4(221),12,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(2),mass5set(:,3),  & 
G1H4(225),G1H4(226),G1H4(227),G1H4(228),G1H4(229),G1H4(230),4)
  call HG1shiftOLR(G1H4(226),8,4)
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(3),mass4set(:,3),  & 
G1H4(231),G1H4(232),G1H4(233),G1H4(234),G1H4(235),G0H4(29),4)
  call HG1shiftOLR(G1H4(232),8,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(4),mass4set(:,3),  & 
G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),G0H4(30),4)
  call HG1shiftOLR(G1H4(237),12,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(2),mass5set(:,1),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),8,4)
  call Hotf_4pt_reduction(G2H4(79),RedSet_4(3),mass4set(:,1),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G0H4(31),4)
  call HG1shiftOLR(G1H4(248),8,4)
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(4),mass4set(:,1),  & 
G1H4(252),G1H4(253),G1H4(254),G1H4(255),G1H4(256),G0H4(32),4)
  call HG1shiftOLR(G1H4(253),12,4)
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(2),mass5set(:,1),  & 
G1H4(257),G1H4(258),G1H4(259),G1H4(260),G1H4(261),G1H4(262),4)
  call HG1shiftOLR(G1H4(258),8,4)
  call Hotf_4pt_reduction(G2H4(84),RedSet_4(3),mass4set(:,1),  & 
G1H4(263),G1H4(264),G1H4(265),G1H4(266),G1H4(267),G0H4(33),4)
  call HG1shiftOLR(G1H4(264),8,4)
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(4),mass4set(:,1),  & 
G1H4(268),G1H4(269),G1H4(270),G1H4(271),G1H4(272),G0H4(34),4)
  call HG1shiftOLR(G1H4(269),12,4)
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(2),mass5set(:,1),  & 
G1H4(273),G1H4(274),G1H4(275),G1H4(276),G1H4(277),G1H4(278),4)
  call HG1shiftOLR(G1H4(274),8,4)
  call Hotf_4pt_reduction(G2H4(89),RedSet_4(3),mass4set(:,1),  & 
G1H4(279),G1H4(280),G1H4(281),G1H4(282),G1H4(283),G0H4(35),4)
  call HG1shiftOLR(G1H4(280),8,4)
  call Hotf_4pt_reduction(G2H4(90),RedSet_4(4),mass4set(:,1),  & 
G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),G0H4(36),4)
  call HG1shiftOLR(G1H4(285),12,4)
  call Hotf_5pt_reduction(G2H4(91),RedSet_5(3),mass5set(:,1),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
  call HG1shiftOLR(G1H4(290),8,4)
  call Hotf_4pt_reduction(G2H4(94),RedSet_4(1),mass4set(:,1),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G0H4(37),4)
  call HG1shiftOLR(G1H4(296),8,4)
  call Hotf_4pt_reduction(G2H4(95),RedSet_4(5),mass4set(:,1),  & 
G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),G0H4(38),4)
  call HG1shiftOLR(G1H4(301),9,4)
  call Hotf_5pt_reduction(G2H4(96),RedSet_5(3),mass5set(:,2),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),8,4)
  call Hotf_4pt_reduction(G2H4(99),RedSet_4(1),mass4set(:,2),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G0H4(39),4)
  call HG1shiftOLR(G1H4(312),8,4)
  call Hotf_4pt_reduction(G2H4(100),RedSet_4(5),mass4set(:,2),  & 
G1H4(316),G1H4(317),G1H4(318),G1H4(319),G1H4(320),G0H4(40),4)
  call HG1shiftOLR(G1H4(317),9,4)
  call Hotf_5pt_reduction(G2H4(101),RedSet_5(3),mass5set(:,1),  & 
G1H4(321),G1H4(322),G1H4(323),G1H4(324),G1H4(325),G1H4(326),4)
  call HG1shiftOLR(G1H4(322),8,4)
  call Hotf_4pt_reduction(G2H4(104),RedSet_4(1),mass4set(:,1),  & 
G1H4(327),G1H4(328),G1H4(329),G1H4(330),G1H4(331),G0H4(41),4)
  call HG1shiftOLR(G1H4(328),8,4)
  call Hotf_4pt_reduction(G2H4(105),RedSet_4(5),mass4set(:,1),  & 
G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),G0H4(42),4)
  call HG1shiftOLR(G1H4(333),9,4)
  call Hotf_5pt_reduction(G2H4(106),RedSet_5(3),mass5set(:,2),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
  call HG1shiftOLR(G1H4(338),8,4)
  call Hotf_4pt_reduction(G2H4(109),RedSet_4(1),mass4set(:,2),  & 
G1H4(343),G1H4(344),G1H4(345),G1H4(346),G1H4(347),G0H4(43),4)
  call HG1shiftOLR(G1H4(344),8,4)
  call Hotf_4pt_reduction(G2H4(110),RedSet_4(5),mass4set(:,2),  & 
G1H4(348),G1H4(349),G1H4(350),G1H4(351),G1H4(352),G0H4(44),4)
  call HG1shiftOLR(G1H4(349),9,4)
  call Hotf_5pt_reduction(G2H4(111),RedSet_5(3),mass5set(:,3),  & 
G1H4(353),G1H4(354),G1H4(355),G1H4(356),G1H4(357),G1H4(358),4)
  call HG1shiftOLR(G1H4(354),8,4)
  call Hotf_4pt_reduction(G2H4(114),RedSet_4(1),mass4set(:,3),  & 
G1H4(359),G1H4(360),G1H4(361),G1H4(362),G1H4(363),G0H4(45),4)
  call HG1shiftOLR(G1H4(360),8,4)
  call Hotf_4pt_reduction(G2H4(115),RedSet_4(5),mass4set(:,3),  & 
G1H4(364),G1H4(365),G1H4(366),G1H4(367),G1H4(368),G0H4(46),4)
  call HG1shiftOLR(G1H4(365),9,4)
  call Hotf_5pt_reduction(G2H4(116),RedSet_5(3),mass5set(:,3),  & 
G1H4(369),G1H4(370),G1H4(371),G1H4(372),G1H4(373),G1H4(374),4)
  call HG1shiftOLR(G1H4(370),8,4)
  call Hotf_4pt_reduction(G2H4(119),RedSet_4(1),mass4set(:,3),  & 
G1H4(375),G1H4(376),G1H4(377),G1H4(378),G1H4(379),G0H4(47),4)
  call HG1shiftOLR(G1H4(376),8,4)
  call Hotf_4pt_reduction(G2H4(120),RedSet_4(5),mass4set(:,3),  & 
G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),G0H4(48),4)
  call HG1shiftOLR(G1H4(381),9,4)
  call Hotf_5pt_reduction(G2H4(121),RedSet_5(3),mass5set(:,1),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),8,4)
  call Hotf_4pt_reduction(G2H4(124),RedSet_4(1),mass4set(:,1),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),G0H4(49),4)
  call HG1shiftOLR(G1H4(392),8,4)
  call Hotf_4pt_reduction(G2H4(125),RedSet_4(5),mass4set(:,1),  & 
G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),G0H4(50),4)
  call HG1shiftOLR(G1H4(397),9,4)
  call Hotf_5pt_reduction(G2H4(126),RedSet_5(3),mass5set(:,1),  & 
G1H4(401),G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),4)
  call HG1shiftOLR(G1H4(402),8,4)
  call Hotf_4pt_reduction(G2H4(129),RedSet_4(1),mass4set(:,1),  & 
G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),G0H4(51),4)
  call HG1shiftOLR(G1H4(408),8,4)
  call Hotf_4pt_reduction(G2H4(130),RedSet_4(5),mass4set(:,1),  & 
G1H4(412),G1H4(413),G1H4(414),G1H4(415),G1H4(416),G0H4(52),4)
  call HG1shiftOLR(G1H4(413),9,4)
  call Hotf_5pt_reduction(G2H4(131),RedSet_5(3),mass5set(:,1),  & 
G1H4(417),G1H4(418),G1H4(419),G1H4(420),G1H4(421),G1H4(422),4)
  call HG1shiftOLR(G1H4(418),8,4)
  call Hotf_4pt_reduction(G2H4(134),RedSet_4(1),mass4set(:,1),  & 
G1H4(423),G1H4(424),G1H4(425),G1H4(426),G1H4(427),G0H4(53),4)
  call HG1shiftOLR(G1H4(424),8,4)
  call Hotf_4pt_reduction(G2H4(135),RedSet_4(5),mass4set(:,1),  & 
G1H4(428),G1H4(429),G1H4(430),G1H4(431),G1H4(432),G0H4(54),4)
  call HG1shiftOLR(G1H4(429),9,4)
  call Hotf_5pt_reduction(G2H4(136),RedSet_5(4),mass5set(:,1),  & 
G1H4(433),G1H4(434),G1H4(435),G1H4(436),G1H4(437),G1H4(438),4)
  call HG1shiftOLR(G1H4(434),4,4)
  call Hotf_4pt_reduction(G2H4(139),RedSet_4(6),mass4set(:,1),  & 
G1H4(439),G1H4(440),G1H4(441),G1H4(442),G1H4(443),G0H4(55),4)
  call HG1shiftOLR(G1H4(440),4,4)
  call Hotf_4pt_reduction(G2H4(140),RedSet_4(4),mass4set(:,1),  & 
G1H4(444),G1H4(445),G1H4(446),G1H4(447),G1H4(448),G0H4(56),4)
  call HG1shiftOLR(G1H4(445),12,4)
  call Hotf_5pt_reduction(G2H4(141),RedSet_5(4),mass5set(:,2),  & 
G1H4(449),G1H4(450),G1H4(451),G1H4(452),G1H4(453),G1H4(454),4)
  call HG1shiftOLR(G1H4(450),4,4)
  call Hotf_4pt_reduction(G2H4(144),RedSet_4(6),mass4set(:,2),  & 
G1H4(455),G1H4(456),G1H4(457),G1H4(458),G1H4(459),G0H4(57),4)
  call HG1shiftOLR(G1H4(456),4,4)
  call Hotf_4pt_reduction(G2H4(145),RedSet_4(4),mass4set(:,2),  & 
G1H4(460),G1H4(461),G1H4(462),G1H4(463),G1H4(464),G0H4(58),4)
  call HG1shiftOLR(G1H4(461),12,4)
  call Hotf_5pt_reduction(G2H4(146),RedSet_5(4),mass5set(:,1),  & 
G1H4(465),G1H4(466),G1H4(467),G1H4(468),G1H4(469),G1H4(470),4)
  call HG1shiftOLR(G1H4(466),4,4)
  call Hotf_4pt_reduction(G2H4(149),RedSet_4(6),mass4set(:,1),  & 
G1H4(471),G1H4(472),G1H4(473),G1H4(474),G1H4(475),G0H4(59),4)
  call HG1shiftOLR(G1H4(472),4,4)
  call Hotf_4pt_reduction(G2H4(150),RedSet_4(4),mass4set(:,1),  & 
G1H4(476),G1H4(477),G1H4(478),G1H4(479),G1H4(480),G0H4(60),4)
  call HG1shiftOLR(G1H4(477),12,4)
  call Hotf_5pt_reduction(G2H4(151),RedSet_5(4),mass5set(:,2),  & 
G1H4(481),G1H4(482),G1H4(483),G1H4(484),G1H4(485),G1H4(486),4)
  call HG1shiftOLR(G1H4(482),4,4)
  call Hotf_4pt_reduction(G2H4(154),RedSet_4(6),mass4set(:,2),  & 
G1H4(487),G1H4(488),G1H4(489),G1H4(490),G1H4(491),G0H4(61),4)
  call HG1shiftOLR(G1H4(488),4,4)
  call Hotf_4pt_reduction(G2H4(155),RedSet_4(4),mass4set(:,2),  & 
G1H4(492),G1H4(493),G1H4(494),G1H4(495),G1H4(496),G0H4(62),4)
  call HG1shiftOLR(G1H4(493),12,4)
  call Hotf_5pt_reduction(G2H4(156),RedSet_5(4),mass5set(:,3),  & 
G1H4(497),G1H4(498),G1H4(499),G1H4(500),G1H4(501),G1H4(502),4)
  call HG1shiftOLR(G1H4(498),4,4)
  call Hotf_4pt_reduction(G2H4(159),RedSet_4(6),mass4set(:,3),  & 
G1H4(503),G1H4(504),G1H4(505),G1H4(506),G1H4(507),G0H4(63),4)
  call HG1shiftOLR(G1H4(504),4,4)
  call Hotf_4pt_reduction(G2H4(160),RedSet_4(4),mass4set(:,3),  & 
G1H4(508),G1H4(509),G1H4(510),G1H4(511),G1H4(512),G0H4(64),4)
  call HG1shiftOLR(G1H4(509),12,4)
  call Hotf_5pt_reduction(G2H4(161),RedSet_5(4),mass5set(:,3),  & 
G1H4(513),G1H4(514),G1H4(515),G1H4(516),G1H4(517),G1H4(518),4)
  call HG1shiftOLR(G1H4(514),4,4)
  call Hotf_4pt_reduction(G2H4(164),RedSet_4(6),mass4set(:,3),  & 
G1H4(519),G1H4(520),G1H4(521),G1H4(522),G1H4(523),G0H4(65),4)
  call HG1shiftOLR(G1H4(520),4,4)
  call Hotf_4pt_reduction(G2H4(165),RedSet_4(4),mass4set(:,3),  & 
G1H4(524),G1H4(525),G1H4(526),G1H4(527),G1H4(528),G0H4(66),4)
  call HG1shiftOLR(G1H4(525),12,4)
  call Hotf_5pt_reduction(G2H4(166),RedSet_5(4),mass5set(:,1),  & 
G1H4(529),G1H4(530),G1H4(531),G1H4(532),G1H4(533),G1H4(534),4)
  call HG1shiftOLR(G1H4(530),4,4)
  call Hotf_4pt_reduction(G2H4(169),RedSet_4(6),mass4set(:,1),  & 
G1H4(535),G1H4(536),G1H4(537),G1H4(538),G1H4(539),G0H4(67),4)
  call HG1shiftOLR(G1H4(536),4,4)
  call Hotf_4pt_reduction(G2H4(170),RedSet_4(4),mass4set(:,1),  & 
G1H4(540),G1H4(541),G1H4(542),G1H4(543),G1H4(544),G0H4(68),4)
  call HG1shiftOLR(G1H4(541),12,4)
  call Hotf_5pt_reduction(G2H4(171),RedSet_5(4),mass5set(:,1),  & 
G1H4(545),G1H4(546),G1H4(547),G1H4(548),G1H4(549),G1H4(550),4)
  call HG1shiftOLR(G1H4(546),4,4)
  call Hotf_4pt_reduction(G2H4(174),RedSet_4(6),mass4set(:,1),  & 
G1H4(551),G1H4(552),G1H4(553),G1H4(554),G1H4(555),G0H4(69),4)
  call HG1shiftOLR(G1H4(552),4,4)
  call Hotf_4pt_reduction(G2H4(175),RedSet_4(4),mass4set(:,1),  & 
G1H4(556),G1H4(557),G1H4(558),G1H4(559),G1H4(560),G0H4(70),4)
  call HG1shiftOLR(G1H4(557),12,4)
  call Hotf_5pt_reduction(G2H4(176),RedSet_5(4),mass5set(:,1),  & 
G1H4(561),G1H4(562),G1H4(563),G1H4(564),G1H4(565),G1H4(566),4)
  call HG1shiftOLR(G1H4(562),4,4)
  call Hotf_4pt_reduction(G2H4(179),RedSet_4(6),mass4set(:,1),  & 
G1H4(567),G1H4(568),G1H4(569),G1H4(570),G1H4(571),G0H4(71),4)
  call HG1shiftOLR(G1H4(568),4,4)
  call Hotf_4pt_reduction(G2H4(180),RedSet_4(4),mass4set(:,1),  & 
G1H4(572),G1H4(573),G1H4(574),G1H4(575),G1H4(576),G0H4(72),4)
  call HG1shiftOLR(G1H4(573),12,4)
  call Hotf_5pt_reduction(G2H4(181),RedSet_5(5),mass5set(:,1),  & 
G1H4(577),G1H4(578),G1H4(579),G1H4(580),G1H4(581),G1H4(582),4)
  call HG1shiftOLR(G1H4(578),8,4)
  call Hotf_4pt_reduction(G2H4(184),RedSet_4(7),mass4set(:,1),  & 
G1H4(583),G1H4(584),G1H4(585),G1H4(586),G1H4(587),G0H4(73),4)
  call HG1shiftOLR(G1H4(584),8,4)
  call Hotf_4pt_reduction(G2H4(185),RedSet_4(8),mass4set(:,1),  & 
G1H4(588),G1H4(589),G1H4(590),G1H4(591),G1H4(592),G0H4(74),4)
  call HG1shiftOLR(G1H4(589),12,4)
  call Hotf_5pt_reduction(G2H4(186),RedSet_5(5),mass5set(:,2),  & 
G1H4(593),G1H4(594),G1H4(595),G1H4(596),G1H4(597),G1H4(598),4)
  call HG1shiftOLR(G1H4(594),8,4)
  call Hotf_4pt_reduction(G2H4(189),RedSet_4(7),mass4set(:,2),  & 
G1H4(599),G1H4(600),G1H4(601),G1H4(602),G1H4(603),G0H4(75),4)
  call HG1shiftOLR(G1H4(600),8,4)
  call Hotf_4pt_reduction(G2H4(190),RedSet_4(8),mass4set(:,2),  & 
G1H4(604),G1H4(605),G1H4(606),G1H4(607),G1H4(608),G0H4(76),4)
  call HG1shiftOLR(G1H4(605),12,4)
  call Hotf_5pt_reduction(G2H4(191),RedSet_5(5),mass5set(:,1),  & 
G1H4(609),G1H4(610),G1H4(611),G1H4(612),G1H4(613),G1H4(614),4)
  call HG1shiftOLR(G1H4(610),8,4)
  call Hotf_4pt_reduction(G2H4(194),RedSet_4(7),mass4set(:,1),  & 
G1H4(615),G1H4(616),G1H4(617),G1H4(618),G1H4(619),G0H4(77),4)
  call HG1shiftOLR(G1H4(616),8,4)
  call Hotf_4pt_reduction(G2H4(195),RedSet_4(8),mass4set(:,1),  & 
G1H4(620),G1H4(621),G1H4(622),G1H4(623),G1H4(624),G0H4(78),4)
  call HG1shiftOLR(G1H4(621),12,4)
  call Hotf_5pt_reduction(G2H4(196),RedSet_5(5),mass5set(:,2),  & 
G1H4(625),G1H4(626),G1H4(627),G1H4(628),G1H4(629),G1H4(630),4)
  call HG1shiftOLR(G1H4(626),8,4)
  call Hotf_4pt_reduction(G2H4(199),RedSet_4(7),mass4set(:,2),  & 
G1H4(631),G1H4(632),G1H4(633),G1H4(634),G1H4(635),G0H4(79),4)
  call HG1shiftOLR(G1H4(632),8,4)
  call Hotf_4pt_reduction(G2H4(200),RedSet_4(8),mass4set(:,2),  & 
G1H4(636),G1H4(637),G1H4(638),G1H4(639),G1H4(640),G0H4(80),4)
  call HG1shiftOLR(G1H4(637),12,4)
  call Hotf_5pt_reduction(G2H4(201),RedSet_5(5),mass5set(:,3),  & 
G1H4(641),G1H4(642),G1H4(643),G1H4(644),G1H4(645),G1H4(646),4)
  call HG1shiftOLR(G1H4(642),8,4)
  call Hotf_4pt_reduction(G2H4(204),RedSet_4(7),mass4set(:,3),  & 
G1H4(647),G1H4(648),G1H4(649),G1H4(650),G1H4(651),G0H4(81),4)
  call HG1shiftOLR(G1H4(648),8,4)
  call Hotf_4pt_reduction(G2H4(205),RedSet_4(8),mass4set(:,3),  & 
G1H4(652),G1H4(653),G1H4(654),G1H4(655),G1H4(656),G0H4(82),4)
  call HG1shiftOLR(G1H4(653),12,4)
  call Hotf_5pt_reduction(G2H4(206),RedSet_5(5),mass5set(:,3),  & 
G1H4(657),G1H4(658),G1H4(659),G1H4(660),G1H4(661),G1H4(662),4)
  call HG1shiftOLR(G1H4(658),8,4)
  call Hotf_4pt_reduction(G2H4(209),RedSet_4(7),mass4set(:,3),  & 
G1H4(663),G1H4(664),G1H4(665),G1H4(666),G1H4(667),G0H4(83),4)
  call HG1shiftOLR(G1H4(664),8,4)
  call Hotf_4pt_reduction(G2H4(210),RedSet_4(8),mass4set(:,3),  & 
G1H4(668),G1H4(669),G1H4(670),G1H4(671),G1H4(672),G0H4(84),4)
  call HG1shiftOLR(G1H4(669),12,4)
  call Hotf_5pt_reduction(G2H4(211),RedSet_5(5),mass5set(:,1),  & 
G1H4(673),G1H4(674),G1H4(675),G1H4(676),G1H4(677),G1H4(678),4)
  call HG1shiftOLR(G1H4(674),8,4)
  call Hotf_4pt_reduction(G2H4(214),RedSet_4(7),mass4set(:,1),  & 
G1H4(679),G1H4(680),G1H4(681),G1H4(682),G1H4(683),G0H4(85),4)
  call HG1shiftOLR(G1H4(680),8,4)
  call Hotf_4pt_reduction(G2H4(215),RedSet_4(8),mass4set(:,1),  & 
G1H4(684),G1H4(685),G1H4(686),G1H4(687),G1H4(688),G0H4(86),4)
  call HG1shiftOLR(G1H4(685),12,4)
  call Hotf_5pt_reduction(G2H4(216),RedSet_5(5),mass5set(:,1),  & 
G1H4(689),G1H4(690),G1H4(691),G1H4(692),G1H4(693),G1H4(694),4)
  call HG1shiftOLR(G1H4(690),8,4)
  call Hotf_4pt_reduction(G2H4(219),RedSet_4(7),mass4set(:,1),  & 
G1H4(695),G1H4(696),G1H4(697),G1H4(698),G1H4(699),G0H4(87),4)
  call HG1shiftOLR(G1H4(696),8,4)
  call Hotf_4pt_reduction(G2H4(220),RedSet_4(8),mass4set(:,1),  & 
G1H4(700),G1H4(701),G1H4(702),G1H4(703),G1H4(704),G0H4(88),4)
  call HG1shiftOLR(G1H4(701),12,4)
  call Hotf_5pt_reduction(G2H4(221),RedSet_5(5),mass5set(:,1),  & 
G1H4(705),G1H4(706),G1H4(707),G1H4(708),G1H4(709),G1H4(710),4)
  call HG1shiftOLR(G1H4(706),8,4)
  call Hotf_4pt_reduction(G2H4(224),RedSet_4(7),mass4set(:,1),  & 
G1H4(711),G1H4(712),G1H4(713),G1H4(714),G1H4(715),G0H4(89),4)
  call HG1shiftOLR(G1H4(712),8,4)
  call Hotf_4pt_reduction(G2H4(225),RedSet_4(8),mass4set(:,1),  & 
G1H4(716),G1H4(717),G1H4(718),G1H4(719),G1H4(720),G0H4(90),4)
  call HG1shiftOLR(G1H4(717),12,4)
  call Hotf_5pt_reduction(G2H4(226),RedSet_5(6),mass5set(:,1),  & 
G1H4(721),G1H4(722),G1H4(723),G1H4(724),G1H4(725),G1H4(726),4)
  call HG1shiftOLR(G1H4(722),4,4)
  call Hotf_4pt_reduction(G2H4(229),RedSet_4(9),mass4set(:,1),  & 
G1H4(727),G1H4(728),G1H4(729),G1H4(730),G1H4(731),G0H4(91),4)
  call HG1shiftOLR(G1H4(728),4,4)
  call Hotf_4pt_reduction(G2H4(230),RedSet_4(8),mass4set(:,1),  & 
G1H4(732),G1H4(733),G1H4(734),G1H4(735),G1H4(736),G0H4(92),4)
  call HG1shiftOLR(G1H4(733),12,4)
  call Hotf_5pt_reduction(G2H4(231),RedSet_5(6),mass5set(:,2),  & 
G1H4(737),G1H4(738),G1H4(739),G1H4(740),G1H4(741),G1H4(742),4)
  call HG1shiftOLR(G1H4(738),4,4)
  call Hotf_4pt_reduction(G2H4(234),RedSet_4(9),mass4set(:,2),  & 
G1H4(743),G1H4(744),G1H4(745),G1H4(746),G1H4(747),G0H4(93),4)
  call HG1shiftOLR(G1H4(744),4,4)
  call Hotf_4pt_reduction(G2H4(235),RedSet_4(8),mass4set(:,2),  & 
G1H4(748),G1H4(749),G1H4(750),G1H4(751),G1H4(752),G0H4(94),4)
  call HG1shiftOLR(G1H4(749),12,4)
  call Hotf_5pt_reduction(G2H4(236),RedSet_5(6),mass5set(:,1),  & 
G1H4(753),G1H4(754),G1H4(755),G1H4(756),G1H4(757),G1H4(758),4)
  call HG1shiftOLR(G1H4(754),4,4)
  call Hotf_4pt_reduction(G2H4(239),RedSet_4(9),mass4set(:,1),  & 
G1H4(759),G1H4(760),G1H4(761),G1H4(762),G1H4(763),G0H4(95),4)
  call HG1shiftOLR(G1H4(760),4,4)
  call Hotf_4pt_reduction(G2H4(240),RedSet_4(8),mass4set(:,1),  & 
G1H4(764),G1H4(765),G1H4(766),G1H4(767),G1H4(768),G0H4(96),4)
  call HG1shiftOLR(G1H4(765),12,4)
  call Hotf_5pt_reduction(G2H4(241),RedSet_5(6),mass5set(:,2),  & 
G1H4(769),G1H4(770),G1H4(771),G1H4(772),G1H4(773),G1H4(774),4)
  call HG1shiftOLR(G1H4(770),4,4)
  call Hotf_4pt_reduction(G2H4(244),RedSet_4(9),mass4set(:,2),  & 
G1H4(775),G1H4(776),G1H4(777),G1H4(778),G1H4(779),G0H4(97),4)
  call HG1shiftOLR(G1H4(776),4,4)
  call Hotf_4pt_reduction(G2H4(245),RedSet_4(8),mass4set(:,2),  & 
G1H4(780),G1H4(781),G1H4(782),G1H4(783),G1H4(784),G0H4(98),4)
  call HG1shiftOLR(G1H4(781),12,4)
  call Hotf_5pt_reduction(G2H4(246),RedSet_5(6),mass5set(:,3),  & 
G1H4(785),G1H4(786),G1H4(787),G1H4(788),G1H4(789),G1H4(790),4)
  call HG1shiftOLR(G1H4(786),4,4)
  call Hotf_4pt_reduction(G2H4(249),RedSet_4(9),mass4set(:,3),  & 
G1H4(791),G1H4(792),G1H4(793),G1H4(794),G1H4(795),G0H4(99),4)
  call HG1shiftOLR(G1H4(792),4,4)
  call Hotf_4pt_reduction(G2H4(250),RedSet_4(8),mass4set(:,3),  & 
G1H4(796),G1H4(797),G1H4(798),G1H4(799),G1H4(800),G0H4(100),4)
  call HG1shiftOLR(G1H4(797),12,4)
  call Hotf_5pt_reduction(G2H4(251),RedSet_5(6),mass5set(:,3),  & 
G1H4(801),G1H4(802),G1H4(803),G1H4(804),G1H4(805),G1H4(806),4)
  call HG1shiftOLR(G1H4(802),4,4)
  call Hotf_4pt_reduction(G2H4(254),RedSet_4(9),mass4set(:,3),  & 
G1H4(807),G1H4(808),G1H4(809),G1H4(810),G1H4(811),G0H4(101),4)
  call HG1shiftOLR(G1H4(808),4,4)
  call Hotf_4pt_reduction(G2H4(255),RedSet_4(8),mass4set(:,3),  & 
G1H4(812),G1H4(813),G1H4(814),G1H4(815),G1H4(816),G0H4(102),4)
  call HG1shiftOLR(G1H4(813),12,4)
  call Hotf_5pt_reduction(G2H4(256),RedSet_5(6),mass5set(:,1),  & 
G1H4(817),G1H4(818),G1H4(819),G1H4(820),G1H4(821),G1H4(822),4)
  call HG1shiftOLR(G1H4(818),4,4)
  call Hotf_4pt_reduction(G2H4(259),RedSet_4(9),mass4set(:,1),  & 
G1H4(823),G1H4(824),G1H4(825),G1H4(826),G1H4(827),G0H4(103),4)
  call HG1shiftOLR(G1H4(824),4,4)
  call Hotf_4pt_reduction(G2H4(260),RedSet_4(8),mass4set(:,1),  & 
G1H4(828),G1H4(829),G1H4(830),G1H4(831),G1H4(832),G0H4(104),4)
  call HG1shiftOLR(G1H4(829),12,4)
  call Hotf_5pt_reduction(G2H4(261),RedSet_5(6),mass5set(:,1),  & 
G1H4(833),G1H4(834),G1H4(835),G1H4(836),G1H4(837),G1H4(838),4)
  call HG1shiftOLR(G1H4(834),4,4)
  call Hotf_4pt_reduction(G2H4(264),RedSet_4(9),mass4set(:,1),  & 
G1H4(839),G1H4(840),G1H4(841),G1H4(842),G1H4(843),G0H4(105),4)
  call HG1shiftOLR(G1H4(840),4,4)
  call Hotf_4pt_reduction(G2H4(265),RedSet_4(8),mass4set(:,1),  & 
G1H4(844),G1H4(845),G1H4(846),G1H4(847),G1H4(848),G0H4(106),4)
  call HG1shiftOLR(G1H4(845),12,4)
  call Hotf_5pt_reduction(G2H4(266),RedSet_5(6),mass5set(:,1),  & 
G1H4(849),G1H4(850),G1H4(851),G1H4(852),G1H4(853),G1H4(854),4)
  call HG1shiftOLR(G1H4(850),4,4)
  call Hotf_4pt_reduction(G2H4(269),RedSet_4(9),mass4set(:,1),  & 
G1H4(855),G1H4(856),G1H4(857),G1H4(858),G1H4(859),G0H4(107),4)
  call HG1shiftOLR(G1H4(856),4,4)
  call Hotf_4pt_reduction(G2H4(270),RedSet_4(8),mass4set(:,1),  & 
G1H4(860),G1H4(861),G1H4(862),G1H4(863),G1H4(864),G0H4(108),4)
  call HG1shiftOLR(G1H4(861),12,4)
  call Hotf_5pt_reduction(G2H4(271),RedSet_5(7),mass5set(:,1),  & 
G1H4(865),G1H4(866),G1H4(867),G1H4(868),G1H4(869),G1H4(870),4)
  call HG1shiftOLR(G1H4(866),8,4)
  call Hotf_4pt_reduction(G2H4(274),RedSet_4(3),mass4set(:,1),  & 
G1H4(871),G1H4(872),G1H4(873),G1H4(874),G1H4(875),G0H4(109),4)
  call HG1shiftOLR(G1H4(872),8,4)
  call Hotf_4pt_reduction(G2H4(275),RedSet_4(10),mass4set(:,1),  & 
G1H4(876),G1H4(877),G1H4(878),G1H4(879),G1H4(880),G0H4(110),4)
  call HG1shiftOLR(G1H4(877),9,4)
  call Hotf_5pt_reduction(G2H4(276),RedSet_5(7),mass5set(:,2),  & 
G1H4(881),G1H4(882),G1H4(883),G1H4(884),G1H4(885),G1H4(886),4)
  call HG1shiftOLR(G1H4(882),8,4)
  call Hotf_4pt_reduction(G2H4(279),RedSet_4(3),mass4set(:,2),  & 
G1H4(887),G1H4(888),G1H4(889),G1H4(890),G1H4(891),G0H4(111),4)
  call HG1shiftOLR(G1H4(888),8,4)
  call Hotf_4pt_reduction(G2H4(280),RedSet_4(10),mass4set(:,2),  & 
G1H4(892),G1H4(893),G1H4(894),G1H4(895),G1H4(896),G0H4(112),4)
  call HG1shiftOLR(G1H4(893),9,4)
  call Hotf_5pt_reduction(G2H4(281),RedSet_5(7),mass5set(:,1),  & 
G1H4(897),G1H4(898),G1H4(899),G1H4(900),G1H4(901),G1H4(902),4)
  call HG1shiftOLR(G1H4(898),8,4)
  call Hotf_4pt_reduction(G2H4(284),RedSet_4(3),mass4set(:,1),  & 
G1H4(903),G1H4(904),G1H4(905),G1H4(906),G1H4(907),G0H4(113),4)
  call HG1shiftOLR(G1H4(904),8,4)
  call Hotf_4pt_reduction(G2H4(285),RedSet_4(10),mass4set(:,1),  & 
G1H4(908),G1H4(909),G1H4(910),G1H4(911),G1H4(912),G0H4(114),4)
  call HG1shiftOLR(G1H4(909),9,4)
  call Hotf_5pt_reduction(G2H4(286),RedSet_5(7),mass5set(:,2),  & 
G1H4(913),G1H4(914),G1H4(915),G1H4(916),G1H4(917),G1H4(918),4)
  call HG1shiftOLR(G1H4(914),8,4)
  call Hotf_4pt_reduction(G2H4(289),RedSet_4(3),mass4set(:,2),  & 
G1H4(919),G1H4(920),G1H4(921),G1H4(922),G1H4(923),G0H4(115),4)
  call HG1shiftOLR(G1H4(920),8,4)
  call Hotf_4pt_reduction(G2H4(290),RedSet_4(10),mass4set(:,2),  & 
G1H4(924),G1H4(925),G1H4(926),G1H4(927),G1H4(928),G0H4(116),4)
  call HG1shiftOLR(G1H4(925),9,4)
  call Hotf_5pt_reduction(G2H4(291),RedSet_5(7),mass5set(:,3),  & 
G1H4(929),G1H4(930),G1H4(931),G1H4(932),G1H4(933),G1H4(934),4)
  call HG1shiftOLR(G1H4(930),8,4)
  call Hotf_4pt_reduction(G2H4(294),RedSet_4(3),mass4set(:,3),  & 
G1H4(935),G1H4(936),G1H4(937),G1H4(938),G1H4(939),G0H4(117),4)
  call HG1shiftOLR(G1H4(936),8,4)
  call Hotf_4pt_reduction(G2H4(295),RedSet_4(10),mass4set(:,3),  & 
G1H4(940),G1H4(941),G1H4(942),G1H4(943),G1H4(944),G0H4(118),4)
  call HG1shiftOLR(G1H4(941),9,4)
  call Hotf_5pt_reduction(G2H4(296),RedSet_5(7),mass5set(:,3),  & 
G1H4(945),G1H4(946),G1H4(947),G1H4(948),G1H4(949),G1H4(950),4)
  call HG1shiftOLR(G1H4(946),8,4)
  call Hotf_4pt_reduction(G2H4(299),RedSet_4(3),mass4set(:,3),  & 
G1H4(951),G1H4(952),G1H4(953),G1H4(954),G1H4(955),G0H4(119),4)
  call HG1shiftOLR(G1H4(952),8,4)
  call Hotf_4pt_reduction(G2H4(300),RedSet_4(10),mass4set(:,3),  & 
G1H4(956),G1H4(957),G1H4(958),G1H4(959),G1H4(960),G0H4(120),4)
  call HG1shiftOLR(G1H4(957),9,4)
  call Hotf_5pt_reduction(G2H4(301),RedSet_5(7),mass5set(:,1),  & 
G1H4(961),G1H4(962),G1H4(963),G1H4(964),G1H4(965),G1H4(966),4)
  call HG1shiftOLR(G1H4(962),8,4)
  call Hotf_4pt_reduction(G2H4(304),RedSet_4(3),mass4set(:,1),  & 
G1H4(967),G1H4(968),G1H4(969),G1H4(970),G1H4(971),G0H4(121),4)
  call HG1shiftOLR(G1H4(968),8,4)
  call Hotf_4pt_reduction(G2H4(305),RedSet_4(10),mass4set(:,1),  & 
G1H4(972),G1H4(973),G1H4(974),G1H4(975),G1H4(976),G0H4(122),4)
  call HG1shiftOLR(G1H4(973),9,4)
  call Hotf_5pt_reduction(G2H4(306),RedSet_5(7),mass5set(:,1),  & 
G1H4(977),G1H4(978),G1H4(979),G1H4(980),G1H4(981),G1H4(982),4)
  call HG1shiftOLR(G1H4(978),8,4)
  call Hotf_4pt_reduction(G2H4(309),RedSet_4(3),mass4set(:,1),  & 
G1H4(983),G1H4(984),G1H4(985),G1H4(986),G1H4(987),G0H4(123),4)
  call HG1shiftOLR(G1H4(984),8,4)
  call Hotf_4pt_reduction(G2H4(310),RedSet_4(10),mass4set(:,1),  & 
G1H4(988),G1H4(989),G1H4(990),G1H4(991),G1H4(992),G0H4(124),4)
  call HG1shiftOLR(G1H4(989),9,4)
  call Hotf_5pt_reduction(G2H4(311),RedSet_5(7),mass5set(:,1),  & 
G1H4(993),G1H4(994),G1H4(995),G1H4(996),G1H4(997),G1H4(998),4)
  call HG1shiftOLR(G1H4(994),8,4)
  call Hotf_4pt_reduction(G2H4(314),RedSet_4(3),mass4set(:,1),  & 
G1H4(999),G1H4(1000),G1H4(1001),G1H4(1002),G1H4(1003),G0H4(125),4)
  call HG1shiftOLR(G1H4(1000),8,4)
  call Hotf_4pt_reduction(G2H4(315),RedSet_4(10),mass4set(:,1),  & 
G1H4(1004),G1H4(1005),G1H4(1006),G1H4(1007),G1H4(1008),G0H4(126),4)
  call HG1shiftOLR(G1H4(1005),9,4)
  call Hotf_5pt_reduction(G2H4(316),RedSet_5(8),mass5set(:,1),  & 
G1H4(1009),G1H4(1010),G1H4(1011),G1H4(1012),G1H4(1013),G1H4(1014),4)
  call HG1shiftOLR(G1H4(1010),4,4)
  call Hotf_4pt_reduction(G2H4(319),RedSet_4(6),mass4set(:,1),  & 
G1H4(1015),G1H4(1016),G1H4(1017),G1H4(1018),G1H4(1019),G0H4(127),4)
  call HG1shiftOLR(G1H4(1016),4,4)
  call Hotf_4pt_reduction(G2H4(320),RedSet_4(11),mass4set(:,1),  & 
G1H4(1020),G1H4(1021),G1H4(1022),G1H4(1023),G1H4(1024),G0H4(128),4)
  call HG1shiftOLR(G1H4(1021),5,4)
  call Hotf_5pt_reduction(G2H4(321),RedSet_5(8),mass5set(:,2),  & 
G1H4(1025),G1H4(1026),G1H4(1027),G1H4(1028),G1H4(1029),G1H4(1030),4)
  call HG1shiftOLR(G1H4(1026),4,4)
  call Hotf_4pt_reduction(G2H4(324),RedSet_4(6),mass4set(:,2),  & 
G1H4(1031),G1H4(1032),G1H4(1033),G1H4(1034),G1H4(1035),G0H4(129),4)
  call HG1shiftOLR(G1H4(1032),4,4)
  call Hotf_4pt_reduction(G2H4(325),RedSet_4(11),mass4set(:,2),  & 
G1H4(1036),G1H4(1037),G1H4(1038),G1H4(1039),G1H4(1040),G0H4(130),4)
  call HG1shiftOLR(G1H4(1037),5,4)
  call Hotf_5pt_reduction(G2H4(326),RedSet_5(8),mass5set(:,1),  & 
G1H4(1041),G1H4(1042),G1H4(1043),G1H4(1044),G1H4(1045),G1H4(1046),4)
  call HG1shiftOLR(G1H4(1042),4,4)
  call Hotf_4pt_reduction(G2H4(329),RedSet_4(6),mass4set(:,1),  & 
G1H4(1047),G1H4(1048),G1H4(1049),G1H4(1050),G1H4(1051),G0H4(131),4)
  call HG1shiftOLR(G1H4(1048),4,4)
  call Hotf_4pt_reduction(G2H4(330),RedSet_4(11),mass4set(:,1),  & 
G1H4(1052),G1H4(1053),G1H4(1054),G1H4(1055),G1H4(1056),G0H4(132),4)
  call HG1shiftOLR(G1H4(1053),5,4)
  call Hotf_5pt_reduction(G2H4(331),RedSet_5(8),mass5set(:,2),  & 
G1H4(1057),G1H4(1058),G1H4(1059),G1H4(1060),G1H4(1061),G1H4(1062),4)
  call HG1shiftOLR(G1H4(1058),4,4)
  call Hotf_4pt_reduction(G2H4(334),RedSet_4(6),mass4set(:,2),  & 
G1H4(1063),G1H4(1064),G1H4(1065),G1H4(1066),G1H4(1067),G0H4(133),4)
  call HG1shiftOLR(G1H4(1064),4,4)
  call Hotf_4pt_reduction(G2H4(335),RedSet_4(11),mass4set(:,2),  & 
G1H4(1068),G1H4(1069),G1H4(1070),G1H4(1071),G1H4(1072),G0H4(134),4)
  call HG1shiftOLR(G1H4(1069),5,4)
  call Hotf_5pt_reduction(G2H4(336),RedSet_5(8),mass5set(:,3),  & 
G1H4(1073),G1H4(1074),G1H4(1075),G1H4(1076),G1H4(1077),G1H4(1078),4)
  call HG1shiftOLR(G1H4(1074),4,4)
  call Hotf_4pt_reduction(G2H4(339),RedSet_4(6),mass4set(:,3),  & 
G1H4(1079),G1H4(1080),G1H4(1081),G1H4(1082),G1H4(1083),G0H4(135),4)
  call HG1shiftOLR(G1H4(1080),4,4)
  call Hotf_4pt_reduction(G2H4(340),RedSet_4(11),mass4set(:,3),  & 
G1H4(1084),G1H4(1085),G1H4(1086),G1H4(1087),G1H4(1088),G0H4(136),4)
  call HG1shiftOLR(G1H4(1085),5,4)
  call Hotf_5pt_reduction(G2H4(341),RedSet_5(8),mass5set(:,3),  & 
G1H4(1089),G1H4(1090),G1H4(1091),G1H4(1092),G1H4(1093),G1H4(1094),4)
  call HG1shiftOLR(G1H4(1090),4,4)
  call Hotf_4pt_reduction(G2H4(344),RedSet_4(6),mass4set(:,3),  & 
G1H4(1095),G1H4(1096),G1H4(1097),G1H4(1098),G1H4(1099),G0H4(137),4)
  call HG1shiftOLR(G1H4(1096),4,4)
  call Hotf_4pt_reduction(G2H4(345),RedSet_4(11),mass4set(:,3),  & 
G1H4(1100),G1H4(1101),G1H4(1102),G1H4(1103),G1H4(1104),G0H4(138),4)
  call HG1shiftOLR(G1H4(1101),5,4)
  call Hotf_5pt_reduction(G2H4(346),RedSet_5(8),mass5set(:,1),  & 
G1H4(1105),G1H4(1106),G1H4(1107),G1H4(1108),G1H4(1109),G1H4(1110),4)
  call HG1shiftOLR(G1H4(1106),4,4)
  call Hotf_4pt_reduction(G2H4(349),RedSet_4(6),mass4set(:,1),  & 
G1H4(1111),G1H4(1112),G1H4(1113),G1H4(1114),G1H4(1115),G0H4(139),4)
  call HG1shiftOLR(G1H4(1112),4,4)
  call Hotf_4pt_reduction(G2H4(350),RedSet_4(11),mass4set(:,1),  & 
G1H4(1116),G1H4(1117),G1H4(1118),G1H4(1119),G1H4(1120),G0H4(140),4)
  call HG1shiftOLR(G1H4(1117),5,4)
  call Hotf_5pt_reduction(G2H4(351),RedSet_5(8),mass5set(:,1),  & 
G1H4(1121),G1H4(1122),G1H4(1123),G1H4(1124),G1H4(1125),G1H4(1126),4)
  call HG1shiftOLR(G1H4(1122),4,4)
  call Hotf_4pt_reduction(G2H4(354),RedSet_4(6),mass4set(:,1),  & 
G1H4(1127),G1H4(1128),G1H4(1129),G1H4(1130),G1H4(1131),G0H4(141),4)
  call HG1shiftOLR(G1H4(1128),4,4)
  call Hotf_4pt_reduction(G2H4(355),RedSet_4(11),mass4set(:,1),  & 
G1H4(1132),G1H4(1133),G1H4(1134),G1H4(1135),G1H4(1136),G0H4(142),4)
  call HG1shiftOLR(G1H4(1133),5,4)
  call Hotf_5pt_reduction(G2H4(356),RedSet_5(8),mass5set(:,1),  & 
G1H4(1137),G1H4(1138),G1H4(1139),G1H4(1140),G1H4(1141),G1H4(1142),4)
  call HG1shiftOLR(G1H4(1138),4,4)
  call Hotf_4pt_reduction(G2H4(359),RedSet_4(6),mass4set(:,1),  & 
G1H4(1143),G1H4(1144),G1H4(1145),G1H4(1146),G1H4(1147),G0H4(143),4)
  call HG1shiftOLR(G1H4(1144),4,4)
  call Hotf_4pt_reduction(G2H4(360),RedSet_4(11),mass4set(:,1),  & 
G1H4(1148),G1H4(1149),G1H4(1150),G1H4(1151),G1H4(1152),G0H4(144),4)
  call HG1shiftOLR(G1H4(1149),5,4)
  call Hotf_5pt_reduction(G2H4(361),RedSet_5(9),mass5set(:,1),  & 
G1H4(1153),G1H4(1154),G1H4(1155),G1H4(1156),G1H4(1157),G1H4(1158),4)
  call HG1shiftOLR(G1H4(1154),8,4)
  call Hotf_4pt_reduction(G2H4(364),RedSet_4(7),mass4set(:,1),  & 
G1H4(1159),G1H4(1160),G1H4(1161),G1H4(1162),G1H4(1163),G0H4(145),4)
  call HG1shiftOLR(G1H4(1160),8,4)
  call Hotf_4pt_reduction(G2H4(365),RedSet_4(12),mass4set(:,1),  & 
G1H4(1164),G1H4(1165),G1H4(1166),G1H4(1167),G1H4(1168),G0H4(146),4)
  call HG1shiftOLR(G1H4(1165),10,4)
  call Hotf_5pt_reduction(G2H4(366),RedSet_5(9),mass5set(:,2),  & 
G1H4(1169),G1H4(1170),G1H4(1171),G1H4(1172),G1H4(1173),G1H4(1174),4)
  call HG1shiftOLR(G1H4(1170),8,4)
  call Hotf_4pt_reduction(G2H4(369),RedSet_4(7),mass4set(:,2),  & 
G1H4(1175),G1H4(1176),G1H4(1177),G1H4(1178),G1H4(1179),G0H4(147),4)
  call HG1shiftOLR(G1H4(1176),8,4)
  call Hotf_4pt_reduction(G2H4(370),RedSet_4(12),mass4set(:,2),  & 
G1H4(1180),G1H4(1181),G1H4(1182),G1H4(1183),G1H4(1184),G0H4(148),4)
  call HG1shiftOLR(G1H4(1181),10,4)
  call Hotf_5pt_reduction(G2H4(371),RedSet_5(9),mass5set(:,1),  & 
G1H4(1185),G1H4(1186),G1H4(1187),G1H4(1188),G1H4(1189),G1H4(1190),4)
  call HG1shiftOLR(G1H4(1186),8,4)
  call Hotf_4pt_reduction(G2H4(374),RedSet_4(7),mass4set(:,1),  & 
G1H4(1191),G1H4(1192),G1H4(1193),G1H4(1194),G1H4(1195),G0H4(149),4)
  call HG1shiftOLR(G1H4(1192),8,4)
  call Hotf_4pt_reduction(G2H4(375),RedSet_4(12),mass4set(:,1),  & 
G1H4(1196),G1H4(1197),G1H4(1198),G1H4(1199),G1H4(1200),G0H4(150),4)
  call HG1shiftOLR(G1H4(1197),10,4)
  call Hotf_5pt_reduction(G2H4(376),RedSet_5(9),mass5set(:,2),  & 
G1H4(1201),G1H4(1202),G1H4(1203),G1H4(1204),G1H4(1205),G1H4(1206),4)
  call HG1shiftOLR(G1H4(1202),8,4)
  call Hotf_4pt_reduction(G2H4(379),RedSet_4(7),mass4set(:,2),  & 
G1H4(1207),G1H4(1208),G1H4(1209),G1H4(1210),G1H4(1211),G0H4(151),4)
  call HG1shiftOLR(G1H4(1208),8,4)
  call Hotf_4pt_reduction(G2H4(380),RedSet_4(12),mass4set(:,2),  & 
G1H4(1212),G1H4(1213),G1H4(1214),G1H4(1215),G1H4(1216),G0H4(152),4)
  call HG1shiftOLR(G1H4(1213),10,4)
  call Hotf_5pt_reduction(G2H4(381),RedSet_5(9),mass5set(:,3),  & 
G1H4(1217),G1H4(1218),G1H4(1219),G1H4(1220),G1H4(1221),G1H4(1222),4)
  call HG1shiftOLR(G1H4(1218),8,4)
  call Hotf_4pt_reduction(G2H4(384),RedSet_4(7),mass4set(:,3),  & 
G1H4(1223),G1H4(1224),G1H4(1225),G1H4(1226),G1H4(1227),G0H4(153),4)
  call HG1shiftOLR(G1H4(1224),8,4)
  call Hotf_4pt_reduction(G2H4(385),RedSet_4(12),mass4set(:,3),  & 
G1H4(1228),G1H4(1229),G1H4(1230),G1H4(1231),G1H4(1232),G0H4(154),4)
  call HG1shiftOLR(G1H4(1229),10,4)
  call Hotf_5pt_reduction(G2H4(386),RedSet_5(9),mass5set(:,3),  & 
G1H4(1233),G1H4(1234),G1H4(1235),G1H4(1236),G1H4(1237),G1H4(1238),4)
  call HG1shiftOLR(G1H4(1234),8,4)
  call Hotf_4pt_reduction(G2H4(389),RedSet_4(7),mass4set(:,3),  & 
G1H4(1239),G1H4(1240),G1H4(1241),G1H4(1242),G1H4(1243),G0H4(155),4)
  call HG1shiftOLR(G1H4(1240),8,4)
  call Hotf_4pt_reduction(G2H4(390),RedSet_4(12),mass4set(:,3),  & 
G1H4(1244),G1H4(1245),G1H4(1246),G1H4(1247),G1H4(1248),G0H4(156),4)
  call HG1shiftOLR(G1H4(1245),10,4)
  call Hotf_5pt_reduction(G2H4(391),RedSet_5(9),mass5set(:,1),  & 
G1H4(1249),G1H4(1250),G1H4(1251),G1H4(1252),G1H4(1253),G1H4(1254),4)
  call HG1shiftOLR(G1H4(1250),8,4)
  call Hotf_4pt_reduction(G2H4(394),RedSet_4(7),mass4set(:,1),  & 
G1H4(1255),G1H4(1256),G1H4(1257),G1H4(1258),G1H4(1259),G0H4(157),4)
  call HG1shiftOLR(G1H4(1256),8,4)
  call Hotf_4pt_reduction(G2H4(395),RedSet_4(12),mass4set(:,1),  & 
G1H4(1260),G1H4(1261),G1H4(1262),G1H4(1263),G1H4(1264),G0H4(158),4)
  call HG1shiftOLR(G1H4(1261),10,4)
  call Hotf_5pt_reduction(G2H4(396),RedSet_5(9),mass5set(:,1),  & 
G1H4(1265),G1H4(1266),G1H4(1267),G1H4(1268),G1H4(1269),G1H4(1270),4)
  call HG1shiftOLR(G1H4(1266),8,4)
  call Hotf_4pt_reduction(G2H4(399),RedSet_4(7),mass4set(:,1),  & 
G1H4(1271),G1H4(1272),G1H4(1273),G1H4(1274),G1H4(1275),G0H4(159),4)
  call HG1shiftOLR(G1H4(1272),8,4)
  call Hotf_4pt_reduction(G2H4(400),RedSet_4(12),mass4set(:,1),  & 
G1H4(1276),G1H4(1277),G1H4(1278),G1H4(1279),G1H4(1280),G0H4(160),4)
  call HG1shiftOLR(G1H4(1277),10,4)
  call Hotf_5pt_reduction(G2H4(401),RedSet_5(9),mass5set(:,1),  & 
G1H4(1281),G1H4(1282),G1H4(1283),G1H4(1284),G1H4(1285),G1H4(1286),4)
  call HG1shiftOLR(G1H4(1282),8,4)
  call Hotf_4pt_reduction(G2H4(404),RedSet_4(7),mass4set(:,1),  & 
G1H4(1287),G1H4(1288),G1H4(1289),G1H4(1290),G1H4(1291),G0H4(161),4)
  call HG1shiftOLR(G1H4(1288),8,4)
  call Hotf_4pt_reduction(G2H4(405),RedSet_4(12),mass4set(:,1),  & 
G1H4(1292),G1H4(1293),G1H4(1294),G1H4(1295),G1H4(1296),G0H4(162),4)
  call HG1shiftOLR(G1H4(1293),10,4)
  call Hotf_5pt_reduction(G2H4(406),RedSet_5(10),mass5set(:,1),  & 
G1H4(1297),G1H4(1298),G1H4(1299),G1H4(1300),G1H4(1301),G1H4(1302),4)
  call HG1shiftOLR(G1H4(1298),2,4)
  call Hotf_4pt_reduction(G2H4(409),RedSet_4(13),mass4set(:,1),  & 
G1H4(1303),G1H4(1304),G1H4(1305),G1H4(1306),G1H4(1307),G0H4(163),4)
  call HG1shiftOLR(G1H4(1304),2,4)
  call Hotf_4pt_reduction(G2H4(410),RedSet_4(12),mass4set(:,1),  & 
G1H4(1308),G1H4(1309),G1H4(1310),G1H4(1311),G1H4(1312),G0H4(164),4)
  call HG1shiftOLR(G1H4(1309),10,4)
  call Hotf_5pt_reduction(G2H4(411),RedSet_5(10),mass5set(:,2),  & 
G1H4(1313),G1H4(1314),G1H4(1315),G1H4(1316),G1H4(1317),G1H4(1318),4)
  call HG1shiftOLR(G1H4(1314),2,4)
  call Hotf_4pt_reduction(G2H4(414),RedSet_4(13),mass4set(:,2),  & 
G1H4(1319),G1H4(1320),G1H4(1321),G1H4(1322),G1H4(1323),G0H4(165),4)
  call HG1shiftOLR(G1H4(1320),2,4)
  call Hotf_4pt_reduction(G2H4(415),RedSet_4(12),mass4set(:,2),  & 
G1H4(1324),G1H4(1325),G1H4(1326),G1H4(1327),G1H4(1328),G0H4(166),4)
  call HG1shiftOLR(G1H4(1325),10,4)
  call Hotf_5pt_reduction(G2H4(416),RedSet_5(10),mass5set(:,1),  & 
G1H4(1329),G1H4(1330),G1H4(1331),G1H4(1332),G1H4(1333),G1H4(1334),4)
  call HG1shiftOLR(G1H4(1330),2,4)
  call Hotf_4pt_reduction(G2H4(419),RedSet_4(13),mass4set(:,1),  & 
G1H4(1335),G1H4(1336),G1H4(1337),G1H4(1338),G1H4(1339),G0H4(167),4)
  call HG1shiftOLR(G1H4(1336),2,4)
  call Hotf_4pt_reduction(G2H4(420),RedSet_4(12),mass4set(:,1),  & 
G1H4(1340),G1H4(1341),G1H4(1342),G1H4(1343),G1H4(1344),G0H4(168),4)
  call HG1shiftOLR(G1H4(1341),10,4)
  call Hotf_5pt_reduction(G2H4(421),RedSet_5(10),mass5set(:,2),  & 
G1H4(1345),G1H4(1346),G1H4(1347),G1H4(1348),G1H4(1349),G1H4(1350),4)
  call HG1shiftOLR(G1H4(1346),2,4)
  call Hotf_4pt_reduction(G2H4(424),RedSet_4(13),mass4set(:,2),  & 
G1H4(1351),G1H4(1352),G1H4(1353),G1H4(1354),G1H4(1355),G0H4(169),4)
  call HG1shiftOLR(G1H4(1352),2,4)
  call Hotf_4pt_reduction(G2H4(425),RedSet_4(12),mass4set(:,2),  & 
G1H4(1356),G1H4(1357),G1H4(1358),G1H4(1359),G1H4(1360),G0H4(170),4)
  call HG1shiftOLR(G1H4(1357),10,4)
  call Hotf_5pt_reduction(G2H4(426),RedSet_5(10),mass5set(:,3),  & 
G1H4(1361),G1H4(1362),G1H4(1363),G1H4(1364),G1H4(1365),G1H4(1366),4)
  call HG1shiftOLR(G1H4(1362),2,4)
  call Hotf_4pt_reduction(G2H4(429),RedSet_4(13),mass4set(:,3),  & 
G1H4(1367),G1H4(1368),G1H4(1369),G1H4(1370),G1H4(1371),G0H4(171),4)
  call HG1shiftOLR(G1H4(1368),2,4)
  call Hotf_4pt_reduction(G2H4(430),RedSet_4(12),mass4set(:,3),  & 
G1H4(1372),G1H4(1373),G1H4(1374),G1H4(1375),G1H4(1376),G0H4(172),4)
  call HG1shiftOLR(G1H4(1373),10,4)
  call Hotf_5pt_reduction(G2H4(431),RedSet_5(10),mass5set(:,3),  & 
G1H4(1377),G1H4(1378),G1H4(1379),G1H4(1380),G1H4(1381),G1H4(1382),4)
  call HG1shiftOLR(G1H4(1378),2,4)
  call Hotf_4pt_reduction(G2H4(434),RedSet_4(13),mass4set(:,3),  & 
G1H4(1383),G1H4(1384),G1H4(1385),G1H4(1386),G1H4(1387),G0H4(173),4)
  call HG1shiftOLR(G1H4(1384),2,4)
  call Hotf_4pt_reduction(G2H4(435),RedSet_4(12),mass4set(:,3),  & 
G1H4(1388),G1H4(1389),G1H4(1390),G1H4(1391),G1H4(1392),G0H4(174),4)
  call HG1shiftOLR(G1H4(1389),10,4)
  call Hotf_5pt_reduction(G2H4(436),RedSet_5(10),mass5set(:,1),  & 
G1H4(1393),G1H4(1394),G1H4(1395),G1H4(1396),G1H4(1397),G1H4(1398),4)
  call HG1shiftOLR(G1H4(1394),2,4)
  call Hotf_4pt_reduction(G2H4(439),RedSet_4(13),mass4set(:,1),  & 
G1H4(1399),G1H4(1400),G1H4(1401),G1H4(1402),G1H4(1403),G0H4(175),4)
  call HG1shiftOLR(G1H4(1400),2,4)
  call Hotf_4pt_reduction(G2H4(440),RedSet_4(12),mass4set(:,1),  & 
G1H4(1404),G1H4(1405),G1H4(1406),G1H4(1407),G1H4(1408),G0H4(176),4)
  call HG1shiftOLR(G1H4(1405),10,4)
  call Hotf_5pt_reduction(G2H4(441),RedSet_5(10),mass5set(:,1),  & 
G1H4(1409),G1H4(1410),G1H4(1411),G1H4(1412),G1H4(1413),G1H4(1414),4)
  call HG1shiftOLR(G1H4(1410),2,4)
  call Hotf_4pt_reduction(G2H4(444),RedSet_4(13),mass4set(:,1),  & 
G1H4(1415),G1H4(1416),G1H4(1417),G1H4(1418),G1H4(1419),G0H4(177),4)
  call HG1shiftOLR(G1H4(1416),2,4)
  call Hotf_4pt_reduction(G2H4(445),RedSet_4(12),mass4set(:,1),  & 
G1H4(1420),G1H4(1421),G1H4(1422),G1H4(1423),G1H4(1424),G0H4(178),4)
  call HG1shiftOLR(G1H4(1421),10,4)
  call Hotf_5pt_reduction(G2H4(446),RedSet_5(10),mass5set(:,1),  & 
G1H4(1425),G1H4(1426),G1H4(1427),G1H4(1428),G1H4(1429),G1H4(1430),4)
  call HG1shiftOLR(G1H4(1426),2,4)
  call Hotf_4pt_reduction(G2H4(449),RedSet_4(13),mass4set(:,1),  & 
G1H4(1431),G1H4(1432),G1H4(1433),G1H4(1434),G1H4(1435),G0H4(179),4)
  call HG1shiftOLR(G1H4(1432),2,4)
  call Hotf_4pt_reduction(G2H4(450),RedSet_4(12),mass4set(:,1),  & 
G1H4(1436),G1H4(1437),G1H4(1438),G1H4(1439),G1H4(1440),G0H4(180),4)
  call HG1shiftOLR(G1H4(1437),10,4)
  call Hotf_5pt_reduction(G2H4(451),RedSet_5(11),mass5set(:,1),  & 
G1H4(1441),G1H4(1442),G1H4(1443),G1H4(1444),G1H4(1445),G1H4(1446),4)
  call HG1shiftOLR(G1H4(1442),4,4)
  call Hotf_4pt_reduction(G2H4(454),RedSet_4(9),mass4set(:,1),  & 
G1H4(1447),G1H4(1448),G1H4(1449),G1H4(1450),G1H4(1451),G0H4(181),4)
  call HG1shiftOLR(G1H4(1448),4,4)
  call Hotf_4pt_reduction(G2H4(455),RedSet_4(14),mass4set(:,1),  & 
G1H4(1452),G1H4(1453),G1H4(1454),G1H4(1455),G1H4(1456),G0H4(182),4)
  call HG1shiftOLR(G1H4(1453),6,4)
  call Hotf_5pt_reduction(G2H4(456),RedSet_5(11),mass5set(:,2),  & 
G1H4(1457),G1H4(1458),G1H4(1459),G1H4(1460),G1H4(1461),G1H4(1462),4)
  call HG1shiftOLR(G1H4(1458),4,4)
  call Hotf_4pt_reduction(G2H4(459),RedSet_4(9),mass4set(:,2),  & 
G1H4(1463),G1H4(1464),G1H4(1465),G1H4(1466),G1H4(1467),G0H4(183),4)
  call HG1shiftOLR(G1H4(1464),4,4)
  call Hotf_4pt_reduction(G2H4(460),RedSet_4(14),mass4set(:,2),  & 
G1H4(1468),G1H4(1469),G1H4(1470),G1H4(1471),G1H4(1472),G0H4(184),4)
  call HG1shiftOLR(G1H4(1469),6,4)
  call Hotf_5pt_reduction(G2H4(461),RedSet_5(11),mass5set(:,1),  & 
G1H4(1473),G1H4(1474),G1H4(1475),G1H4(1476),G1H4(1477),G1H4(1478),4)
  call HG1shiftOLR(G1H4(1474),4,4)
  call Hotf_4pt_reduction(G2H4(464),RedSet_4(9),mass4set(:,1),  & 
G1H4(1479),G1H4(1480),G1H4(1481),G1H4(1482),G1H4(1483),G0H4(185),4)
  call HG1shiftOLR(G1H4(1480),4,4)
  call Hotf_4pt_reduction(G2H4(465),RedSet_4(14),mass4set(:,1),  & 
G1H4(1484),G1H4(1485),G1H4(1486),G1H4(1487),G1H4(1488),G0H4(186),4)
  call HG1shiftOLR(G1H4(1485),6,4)
  call Hotf_5pt_reduction(G2H4(466),RedSet_5(11),mass5set(:,2),  & 
G1H4(1489),G1H4(1490),G1H4(1491),G1H4(1492),G1H4(1493),G1H4(1494),4)
  call HG1shiftOLR(G1H4(1490),4,4)
  call Hotf_4pt_reduction(G2H4(469),RedSet_4(9),mass4set(:,2),  & 
G1H4(1495),G1H4(1496),G1H4(1497),G1H4(1498),G1H4(1499),G0H4(187),4)
  call HG1shiftOLR(G1H4(1496),4,4)
  call Hotf_4pt_reduction(G2H4(470),RedSet_4(14),mass4set(:,2),  & 
G1H4(1500),G1H4(1501),G1H4(1502),G1H4(1503),G1H4(1504),G0H4(188),4)
  call HG1shiftOLR(G1H4(1501),6,4)
  call Hotf_5pt_reduction(G2H4(471),RedSet_5(11),mass5set(:,3),  & 
G1H4(1505),G1H4(1506),G1H4(1507),G1H4(1508),G1H4(1509),G1H4(1510),4)
  call HG1shiftOLR(G1H4(1506),4,4)
  call Hotf_4pt_reduction(G2H4(474),RedSet_4(9),mass4set(:,3),  & 
G1H4(1511),G1H4(1512),G1H4(1513),G1H4(1514),G1H4(1515),G0H4(189),4)
  call HG1shiftOLR(G1H4(1512),4,4)
  call Hotf_4pt_reduction(G2H4(475),RedSet_4(14),mass4set(:,3),  & 
G1H4(1516),G1H4(1517),G1H4(1518),G1H4(1519),G1H4(1520),G0H4(190),4)
  call HG1shiftOLR(G1H4(1517),6,4)
  call Hotf_5pt_reduction(G2H4(476),RedSet_5(11),mass5set(:,3),  & 
G1H4(1521),G1H4(1522),G1H4(1523),G1H4(1524),G1H4(1525),G1H4(1526),4)
  call HG1shiftOLR(G1H4(1522),4,4)
  call Hotf_4pt_reduction(G2H4(479),RedSet_4(9),mass4set(:,3),  & 
G1H4(1527),G1H4(1528),G1H4(1529),G1H4(1530),G1H4(1531),G0H4(191),4)
  call HG1shiftOLR(G1H4(1528),4,4)
  call Hotf_4pt_reduction(G2H4(480),RedSet_4(14),mass4set(:,3),  & 
G1H4(1532),G1H4(1533),G1H4(1534),G1H4(1535),G1H4(1536),G0H4(192),4)
  call HG1shiftOLR(G1H4(1533),6,4)
  call Hotf_5pt_reduction(G2H4(481),RedSet_5(11),mass5set(:,1),  & 
G1H4(1537),G1H4(1538),G1H4(1539),G1H4(1540),G1H4(1541),G1H4(1542),4)
  call HG1shiftOLR(G1H4(1538),4,4)
  call Hotf_4pt_reduction(G2H4(484),RedSet_4(9),mass4set(:,1),  & 
G1H4(1543),G1H4(1544),G1H4(1545),G1H4(1546),G1H4(1547),G0H4(193),4)
  call HG1shiftOLR(G1H4(1544),4,4)
  call Hotf_4pt_reduction(G2H4(485),RedSet_4(14),mass4set(:,1),  & 
G1H4(1548),G1H4(1549),G1H4(1550),G1H4(1551),G1H4(1552),G0H4(194),4)
  call HG1shiftOLR(G1H4(1549),6,4)
  call Hotf_5pt_reduction(G2H4(486),RedSet_5(11),mass5set(:,1),  & 
G1H4(1553),G1H4(1554),G1H4(1555),G1H4(1556),G1H4(1557),G1H4(1558),4)
  call HG1shiftOLR(G1H4(1554),4,4)
  call Hotf_4pt_reduction(G2H4(489),RedSet_4(9),mass4set(:,1),  & 
G1H4(1559),G1H4(1560),G1H4(1561),G1H4(1562),G1H4(1563),G0H4(195),4)
  call HG1shiftOLR(G1H4(1560),4,4)
  call Hotf_4pt_reduction(G2H4(490),RedSet_4(14),mass4set(:,1),  & 
G1H4(1564),G1H4(1565),G1H4(1566),G1H4(1567),G1H4(1568),G0H4(196),4)
  call HG1shiftOLR(G1H4(1565),6,4)
  call Hotf_5pt_reduction(G2H4(491),RedSet_5(11),mass5set(:,1),  & 
G1H4(1569),G1H4(1570),G1H4(1571),G1H4(1572),G1H4(1573),G1H4(1574),4)
  call HG1shiftOLR(G1H4(1570),4,4)
  call Hotf_4pt_reduction(G2H4(494),RedSet_4(9),mass4set(:,1),  & 
G1H4(1575),G1H4(1576),G1H4(1577),G1H4(1578),G1H4(1579),G0H4(197),4)
  call HG1shiftOLR(G1H4(1576),4,4)
  call Hotf_4pt_reduction(G2H4(495),RedSet_4(14),mass4set(:,1),  & 
G1H4(1580),G1H4(1581),G1H4(1582),G1H4(1583),G1H4(1584),G0H4(198),4)
  call HG1shiftOLR(G1H4(1581),6,4)
  call Hotf_5pt_reduction(G2H4(496),RedSet_5(12),mass5set(:,1),  & 
G1H4(1585),G1H4(1586),G1H4(1587),G1H4(1588),G1H4(1589),G1H4(1590),4)
  call HG1shiftOLR(G1H4(1586),2,4)
  call Hotf_4pt_reduction(G2H4(499),RedSet_4(13),mass4set(:,1),  & 
G1H4(1591),G1H4(1592),G1H4(1593),G1H4(1594),G1H4(1595),G0H4(199),4)
  call HG1shiftOLR(G1H4(1592),2,4)
  call Hotf_4pt_reduction(G2H4(500),RedSet_4(14),mass4set(:,1),  & 
G1H4(1596),G1H4(1597),G1H4(1598),G1H4(1599),G1H4(1600),G0H4(200),4)
  call HG1shiftOLR(G1H4(1597),6,4)
  call Hotf_5pt_reduction(G2H4(501),RedSet_5(12),mass5set(:,2),  & 
G1H4(1601),G1H4(1602),G1H4(1603),G1H4(1604),G1H4(1605),G1H4(1606),4)
  call HG1shiftOLR(G1H4(1602),2,4)
  call Hotf_4pt_reduction(G2H4(504),RedSet_4(13),mass4set(:,2),  & 
G1H4(1607),G1H4(1608),G1H4(1609),G1H4(1610),G1H4(1611),G0H4(201),4)
  call HG1shiftOLR(G1H4(1608),2,4)
  call Hotf_4pt_reduction(G2H4(505),RedSet_4(14),mass4set(:,2),  & 
G1H4(1612),G1H4(1613),G1H4(1614),G1H4(1615),G1H4(1616),G0H4(202),4)
  call HG1shiftOLR(G1H4(1613),6,4)
  call Hotf_5pt_reduction(G2H4(506),RedSet_5(12),mass5set(:,1),  & 
G1H4(1617),G1H4(1618),G1H4(1619),G1H4(1620),G1H4(1621),G1H4(1622),4)
  call HG1shiftOLR(G1H4(1618),2,4)
  call Hotf_4pt_reduction(G2H4(509),RedSet_4(13),mass4set(:,1),  & 
G1H4(1623),G1H4(1624),G1H4(1625),G1H4(1626),G1H4(1627),G0H4(203),4)
  call HG1shiftOLR(G1H4(1624),2,4)
  call Hotf_4pt_reduction(G2H4(510),RedSet_4(14),mass4set(:,1),  & 
G1H4(1628),G1H4(1629),G1H4(1630),G1H4(1631),G1H4(1632),G0H4(204),4)
  call HG1shiftOLR(G1H4(1629),6,4)
  call Hotf_5pt_reduction(G2H4(511),RedSet_5(12),mass5set(:,2),  & 
G1H4(1633),G1H4(1634),G1H4(1635),G1H4(1636),G1H4(1637),G1H4(1638),4)
  call HG1shiftOLR(G1H4(1634),2,4)
  call Hotf_4pt_reduction(G2H4(514),RedSet_4(13),mass4set(:,2),  & 
G1H4(1639),G1H4(1640),G1H4(1641),G1H4(1642),G1H4(1643),G0H4(205),4)
  call HG1shiftOLR(G1H4(1640),2,4)
  call Hotf_4pt_reduction(G2H4(515),RedSet_4(14),mass4set(:,2),  & 
G1H4(1644),G1H4(1645),G1H4(1646),G1H4(1647),G1H4(1648),G0H4(206),4)
  call HG1shiftOLR(G1H4(1645),6,4)
  call Hotf_5pt_reduction(G2H4(516),RedSet_5(12),mass5set(:,3),  & 
G1H4(1649),G1H4(1650),G1H4(1651),G1H4(1652),G1H4(1653),G1H4(1654),4)
  call HG1shiftOLR(G1H4(1650),2,4)
  call Hotf_4pt_reduction(G2H4(519),RedSet_4(13),mass4set(:,3),  & 
G1H4(1655),G1H4(1656),G1H4(1657),G1H4(1658),G1H4(1659),G0H4(207),4)
  call HG1shiftOLR(G1H4(1656),2,4)
  call Hotf_4pt_reduction(G2H4(520),RedSet_4(14),mass4set(:,3),  & 
G1H4(1660),G1H4(1661),G1H4(1662),G1H4(1663),G1H4(1664),G0H4(208),4)
  call HG1shiftOLR(G1H4(1661),6,4)
  call Hotf_5pt_reduction(G2H4(521),RedSet_5(12),mass5set(:,3),  & 
G1H4(1665),G1H4(1666),G1H4(1667),G1H4(1668),G1H4(1669),G1H4(1670),4)
  call HG1shiftOLR(G1H4(1666),2,4)
  call Hotf_4pt_reduction(G2H4(524),RedSet_4(13),mass4set(:,3),  & 
G1H4(1671),G1H4(1672),G1H4(1673),G1H4(1674),G1H4(1675),G0H4(209),4)
  call HG1shiftOLR(G1H4(1672),2,4)
  call Hotf_4pt_reduction(G2H4(525),RedSet_4(14),mass4set(:,3),  & 
G1H4(1676),G1H4(1677),G1H4(1678),G1H4(1679),G1H4(1680),G0H4(210),4)
  call HG1shiftOLR(G1H4(1677),6,4)
  call Hotf_5pt_reduction(G2H4(526),RedSet_5(12),mass5set(:,1),  & 
G1H4(1681),G1H4(1682),G1H4(1683),G1H4(1684),G1H4(1685),G1H4(1686),4)
  call HG1shiftOLR(G1H4(1682),2,4)
  call Hotf_4pt_reduction(G2H4(529),RedSet_4(13),mass4set(:,1),  & 
G1H4(1687),G1H4(1688),G1H4(1689),G1H4(1690),G1H4(1691),G0H4(211),4)
  call HG1shiftOLR(G1H4(1688),2,4)
  call Hotf_4pt_reduction(G2H4(530),RedSet_4(14),mass4set(:,1),  & 
G1H4(1692),G1H4(1693),G1H4(1694),G1H4(1695),G1H4(1696),G0H4(212),4)
  call HG1shiftOLR(G1H4(1693),6,4)
  call Hotf_5pt_reduction(G2H4(531),RedSet_5(12),mass5set(:,1),  & 
G1H4(1697),G1H4(1698),G1H4(1699),G1H4(1700),G1H4(1701),G1H4(1702),4)
  call HG1shiftOLR(G1H4(1698),2,4)
  call Hotf_4pt_reduction(G2H4(534),RedSet_4(13),mass4set(:,1),  & 
G1H4(1703),G1H4(1704),G1H4(1705),G1H4(1706),G1H4(1707),G0H4(213),4)
  call HG1shiftOLR(G1H4(1704),2,4)
  call Hotf_4pt_reduction(G2H4(535),RedSet_4(14),mass4set(:,1),  & 
G1H4(1708),G1H4(1709),G1H4(1710),G1H4(1711),G1H4(1712),G0H4(214),4)
  call HG1shiftOLR(G1H4(1709),6,4)
  call Hotf_5pt_reduction(G2H4(536),RedSet_5(12),mass5set(:,1),  & 
G1H4(1713),G1H4(1714),G1H4(1715),G1H4(1716),G1H4(1717),G1H4(1718),4)
  call HG1shiftOLR(G1H4(1714),2,4)
  call Hotf_4pt_reduction(G2H4(539),RedSet_4(13),mass4set(:,1),  & 
G1H4(1719),G1H4(1720),G1H4(1721),G1H4(1722),G1H4(1723),G0H4(215),4)
  call HG1shiftOLR(G1H4(1720),2,4)
  call Hotf_4pt_reduction(G2H4(540),RedSet_4(14),mass4set(:,1),  & 
G1H4(1724),G1H4(1725),G1H4(1726),G1H4(1727),G1H4(1728),G0H4(216),4)
  call HG1shiftOLR(G1H4(1725),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(215),[G1H4(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(220),[G1H4(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G1H4(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(263),[G1H4(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(279),[G1H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(284),[G1H4(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(300),[G1H4(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(311),[G1H4(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(316),[G1H4(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(327),[G1H4(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(332),[G1H4(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(343),[G1H4(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(348),[G1H4(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(359),[G1H4(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(364),[G1H4(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(375),[G1H4(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(380),[G1H4(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(391),[G1H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(423),[G1H4(421)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(428),[G1H4(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(439),[G1H4(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(444),[G1H4(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(455),[G1H4(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(460),[G1H4(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(471),[G1H4(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(476),[G1H4(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(487),[G1H4(485)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(492),[G1H4(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(503),[G1H4(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(508),[G1H4(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(519),[G1H4(517)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(524),[G1H4(518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(535),[G1H4(533)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(540),[G1H4(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(551),[G1H4(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(556),[G1H4(550)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(567),[G1H4(565)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(572),[G1H4(566)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(583),[G1H4(581)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(588),[G1H4(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(599),[G1H4(597)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(604),[G1H4(598)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(615),[G1H4(613)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(620),[G1H4(614)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(631),[G1H4(629)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(636),[G1H4(630)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(647),[G1H4(645)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(652),[G1H4(646)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(663),[G1H4(661)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(668),[G1H4(662)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(679),[G1H4(677)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(684),[G1H4(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(695),[G1H4(693)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(700),[G1H4(694)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(711),[G1H4(709)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(716),[G1H4(710)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(727),[G1H4(725)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(732),[G1H4(726)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(743),[G1H4(741)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(748),[G1H4(742)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(759),[G1H4(757)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(764),[G1H4(758)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(775),[G1H4(773)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(780),[G1H4(774)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(791),[G1H4(789)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(796),[G1H4(790)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(807),[G1H4(805)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(812),[G1H4(806)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(823),[G1H4(821)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(828),[G1H4(822)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(839),[G1H4(837)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(844),[G1H4(838)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(855),[G1H4(853)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(860),[G1H4(854)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(871),[G1H4(869)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(876),[G1H4(870)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(887),[G1H4(885)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(892),[G1H4(886)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(903),[G1H4(901)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(908),[G1H4(902)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(919),[G1H4(917)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(924),[G1H4(918)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(935),[G1H4(933)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(940),[G1H4(934)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(951),[G1H4(949)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(956),[G1H4(950)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(967),[G1H4(965)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(972),[G1H4(966)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(983),[G1H4(981)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(988),[G1H4(982)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(999),[G1H4(997)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1004),[G1H4(998)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1015),[G1H4(1013)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1020),[G1H4(1014)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1031),[G1H4(1029)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1036),[G1H4(1030)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1047),[G1H4(1045)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1052),[G1H4(1046)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1063),[G1H4(1061)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1068),[G1H4(1062)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1079),[G1H4(1077)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1084),[G1H4(1078)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1095),[G1H4(1093)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1100),[G1H4(1094)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1111),[G1H4(1109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1116),[G1H4(1110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1127),[G1H4(1125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1132),[G1H4(1126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1143),[G1H4(1141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1148),[G1H4(1142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1159),[G1H4(1157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1164),[G1H4(1158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1175),[G1H4(1173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1180),[G1H4(1174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1191),[G1H4(1189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1196),[G1H4(1190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1207),[G1H4(1205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1212),[G1H4(1206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1223),[G1H4(1221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1228),[G1H4(1222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1239),[G1H4(1237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1244),[G1H4(1238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1255),[G1H4(1253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1260),[G1H4(1254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1271),[G1H4(1269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1276),[G1H4(1270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1287),[G1H4(1285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1292),[G1H4(1286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1303),[G1H4(1301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1308),[G1H4(1302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1319),[G1H4(1317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1324),[G1H4(1318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1335),[G1H4(1333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1340),[G1H4(1334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1351),[G1H4(1349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1356),[G1H4(1350)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1367),[G1H4(1365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1372),[G1H4(1366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1383),[G1H4(1381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1388),[G1H4(1382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1399),[G1H4(1397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1404),[G1H4(1398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1415),[G1H4(1413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1420),[G1H4(1414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1431),[G1H4(1429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1436),[G1H4(1430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1447),[G1H4(1445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1452),[G1H4(1446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1463),[G1H4(1461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1468),[G1H4(1462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1479),[G1H4(1477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1484),[G1H4(1478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1495),[G1H4(1493)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1500),[G1H4(1494)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1511),[G1H4(1509)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1516),[G1H4(1510)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1527),[G1H4(1525)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1532),[G1H4(1526)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1543),[G1H4(1541)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1548),[G1H4(1542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1559),[G1H4(1557)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1564),[G1H4(1558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1575),[G1H4(1573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1580),[G1H4(1574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1591),[G1H4(1589)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1596),[G1H4(1590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1607),[G1H4(1605)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1612),[G1H4(1606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1623),[G1H4(1621)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1628),[G1H4(1622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1639),[G1H4(1637)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1644),[G1H4(1638)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1655),[G1H4(1653)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1660),[G1H4(1654)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1671),[G1H4(1669)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1676),[G1H4(1670)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1687),[G1H4(1685)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1692),[G1H4(1686)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1703),[G1H4(1701)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1708),[G1H4(1702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1719),[G1H4(1717)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1724),[G1H4(1718)])
  call Hloop_AV_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,0,G2H4(1),n2h4(289))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AV_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(3),n2h2(2))
  call Hloop_AV_Q(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(4),n2h2(3))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-8,0,G2H4(4),n2h4(290))
  call Hloop_QV_A(ntryL,G2H4(4),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AV_Q(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(6),n2h2(4))
  call Hloop_AV_Q(ntryL,G0H4(1),ex2(:),G0H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(1),n2h2(5))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(13),-10,0,G2H4(5),n2h4(291))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(7),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AV_Q(ntryL,G1H4(16),ex2(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(2),23,0,G2H2(8),n2h2(6))
  call Hloop_AV_Q(ntryL,G0H4(2),ex2(:),G0H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(2),n2h2(7))
  call Hloop_AV_Q(ntryL,G1H4(17),ex2(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMT,G2H2(9),n2h2(8))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(18),-8,nMT,G2H4(6),n2h4(292))
  call Hloop_QV_A(ntryL,G2H4(6),ex4(:),G2H2(10),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AV_Q(ntryL,G1H4(23),ex2(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMT,G2H2(11),n2h2(9))
  call Hloop_AV_Q(ntryL,G1H4(28),ex2(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMT,G2H2(12),n2h2(10))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(24),-8,nMT,G2H4(9),n2h4(293))
  call Hloop_QV_A(ntryL,G2H4(9),ex4(:),G2H2(13),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AV_Q(ntryL,G1H4(27),ex2(:),G1H2(3),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMT,G2H2(14),n2h2(11))
  call Hloop_AV_Q(ntryL,G0H4(3),ex2(:),G0H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(3),n2h2(12))
call HGT_OLR(G1H4(29),1,1,4)
call HGT_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(29),-10,nMT,G2H4(10),n2h4(294))
  call Hloop_QV_A(ntryL,G2H4(10),ex4(:),G2H2(15),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AV_Q(ntryL,G1H4(32),ex2(:),G1H2(4),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(4),23,nMT,G2H2(16),n2h2(13))
  call Hloop_AV_Q(ntryL,G0H4(4),ex2(:),G0H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(4),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(33),ex2(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(17),n2h2(15))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(34),-8,0,G2H4(11),n2h4(295))
  call Hloop_AV_Q(ntryL,G2H4(11),ex4(:),G2H2(18),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QV_A(ntryL,G1H4(39),ex2(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(19),n2h2(16))
  call Hloop_QV_A(ntryL,G1H4(44),ex2(:),G1H2(5),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(20),n2h2(17))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-8,0,G2H4(14),n2h4(296))
  call Hloop_AV_Q(ntryL,G2H4(14),ex4(:),G2H2(21),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QV_A(ntryL,G1H4(43),ex2(:),G1H2(5),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(5),23,0,G2H2(22),n2h2(18))
  call Hloop_QV_A(ntryL,G0H4(5),ex2(:),G0H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(5),n2h2(19))
call HGT_OLR(G1H4(45),1,1,4)
call HGT_invQ_OLR(G1H4(45),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(45),-10,0,G2H4(15),n2h4(297))
  call Hloop_AV_Q(ntryL,G2H4(15),ex4(:),G2H2(23),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QV_A(ntryL,G1H4(48),ex2(:),G1H2(6),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(6),23,0,G2H2(24),n2h2(20))
  call Hloop_QV_A(ntryL,G0H4(6),ex2(:),G0H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(6),n2h2(21))
  call Hloop_QV_A(ntryL,G1H4(49),ex2(:),G1H2(7),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(25),n2h2(22))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-8,nMT,G2H4(16),n2h4(298))
  call Hloop_AV_Q(ntryL,G2H4(16),ex4(:),G2H2(26),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QV_A(ntryL,G1H4(55),ex2(:),G1H2(7),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(27),n2h2(23))
  call Hloop_QV_A(ntryL,G1H4(60),ex2(:),G1H2(7),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(28),n2h2(24))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-8,nMT,G2H4(19),n2h4(299))
  call Hloop_AV_Q(ntryL,G2H4(19),ex4(:),G2H2(29),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QV_A(ntryL,G1H4(59),ex2(:),G1H2(7),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(30),n2h2(25))
  call Hloop_QV_A(ntryL,G0H4(7),ex2(:),G0H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(7),n2h2(26))
call HGT_OLR(G1H4(61),1,1,4)
call HGT_invQ_OLR(G1H4(61),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(61),-10,nMT,G2H4(20),n2h4(300))
  call Hloop_AV_Q(ntryL,G2H4(20),ex4(:),G2H2(31),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QV_A(ntryL,G1H4(64),ex2(:),G1H2(8),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(32),n2h2(27))
  call Hloop_QV_A(ntryL,G0H4(8),ex2(:),G0H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(8),n2h2(28))
  call Hloop_AV_Q(ntryL,G1H4(65),ex2(:),G1H2(9),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(33),n2h2(29))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(66),-8,nMB,G2H4(21),n2h4(301))
  call Hloop_QV_A(ntryL,G2H4(21),ex4(:),G2H2(34),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AV_Q(ntryL,G1H4(71),ex2(:),G1H2(9),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(35),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H4(76),ex2(:),G1H2(9),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(36),n2h2(31))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(72),-8,nMB,G2H4(24),n2h4(302))
  call Hloop_QV_A(ntryL,G2H4(24),ex4(:),G2H2(37),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AV_Q(ntryL,G1H4(75),ex2(:),G1H2(9),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(38),n2h2(32))
  call Hloop_AV_Q(ntryL,G0H4(9),ex2(:),G0H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(9),n2h2(33))
call HGT_OLR(G1H4(77),1,1,4)
call HGT_invQ_OLR(G1H4(77),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(77),-10,nMB,G2H4(25),n2h4(303))
  call Hloop_QV_A(ntryL,G2H4(25),ex4(:),G2H2(39),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AV_Q(ntryL,G1H4(80),ex2(:),G1H2(10),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(10),23,nMB,G2H2(40),n2h2(34))
  call Hloop_AV_Q(ntryL,G0H4(10),ex2(:),G0H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(10),n2h2(35))
  call Hloop_QV_A(ntryL,G1H4(81),ex2(:),G1H2(11),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(41),n2h2(36))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(82),-8,nMB,G2H4(26),n2h4(304))
  call Hloop_AV_Q(ntryL,G2H4(26),ex4(:),G2H2(42),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QV_A(ntryL,G1H4(87),ex2(:),G1H2(11),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(43),n2h2(37))
  call Hloop_QV_A(ntryL,G1H4(92),ex2(:),G1H2(11),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(44),n2h2(38))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(88),-8,nMB,G2H4(29),n2h4(305))
  call Hloop_AV_Q(ntryL,G2H4(29),ex4(:),G2H2(45),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_QV_A(ntryL,G1H4(91),ex2(:),G1H2(11),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(46),n2h2(39))
  call Hloop_QV_A(ntryL,G0H4(11),ex2(:),G0H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(11),n2h2(40))
call HGT_OLR(G1H4(93),1,1,4)
call HGT_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(93),-10,nMB,G2H4(30),n2h4(306))
  call Hloop_AV_Q(ntryL,G2H4(30),ex4(:),G2H2(47),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QV_A(ntryL,G1H4(96),ex2(:),G1H2(12),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(48),n2h2(41))
  call Hloop_QV_A(ntryL,G0H4(12),ex2(:),G0H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(12),n2h2(42))
  call Hloop_DV_C(ntryL,G1H4(97),21,ex2(:),G2H2(49),m3h2x2(:,61),heltab2x4(:,:,61))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(98),-8,ex4(:),8,G2H2(50),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_DV_C(ntryL,G1H4(103),21,ex2(:),G2H2(51),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_DV_C(ntryL,G1H4(108),21,ex2(:),G2H2(52),m3h2x2(:,64),heltab2x4(:,:,64))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(104),-8,ex4(:),8,G2H2(53),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_DV_C(ntryL,G1H4(107),21,ex2(:),G2H2(54),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_DV_C(ntryL,G0H4(13),21,ex2(:),G1H2(13),m3h2x2(:,67),heltab2x4(:,:,67))
call HGT_OLR(G1H4(109),1,1,4)
call HGT_invQ_OLR(G1H4(109),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(109),-10,ex4(:),8,G2H2(55),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_DV_C(ntryL,G1H4(112),21,ex2(:),G2H2(56),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_DV_C(ntryL,G0H4(14),21,ex2(:),G1H2(14),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_CV_D(ntryL,G1H4(113),21,ex2(:),2,G2H2(57),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(114),-8,ex4(:),G2H2(58),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_CV_D(ntryL,G1H4(119),21,ex2(:),2,G2H2(59),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_CV_D(ntryL,G1H4(124),21,ex2(:),2,G2H2(60),m3h2x2(:,74),heltab2x4(:,:,74))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(120),-8,ex4(:),G2H2(61),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_CV_D(ntryL,G1H4(123),21,ex2(:),2,G2H2(62),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_CV_D(ntryL,G0H4(15),21,ex2(:),2,G1H2(15),m3h2x2(:,77),heltab2x4(:,:,77))
call HGT_OLR(G1H4(125),1,1,4)
call HGT_invQ_OLR(G1H4(125),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(125),-10,ex4(:),G2H2(63),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_CV_D(ntryL,G1H4(128),21,ex2(:),2,G2H2(64),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_CV_D(ntryL,G0H4(16),21,ex2(:),2,G1H2(16),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_UV_W(ntryL,G1H4(129),21,ex2(:),2,G2H2(65),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(130),-8,ex4(:),8,G2H2(66),m3h2x2(:,82),heltab2x4(:,:,82))
call signflip_OLR(G2H2(66))
  call Hloop_UV_W(ntryL,G1H4(135),21,ex2(:),2,G2H2(67),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_UV_W(ntryL,G1H4(140),21,ex2(:),2,G2H2(68),m3h2x2(:,84),heltab2x4(:,:,84))
call HGT_raise_alpha_OLR(G1H4(136),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(136),-8,ex4(:),8,G2H2(69),m3h2x2(:,85),heltab2x4(:,:,85))
call signflip_OLR(G2H2(69))
  call Hloop_UV_W(ntryL,G1H4(139),21,ex2(:),2,G2H2(70),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_UV_W(ntryL,G0H4(17),21,ex2(:),2,G1H2(17),m3h2x2(:,87),heltab2x4(:,:,87))
call HGT_raise_alpha_OLR(G1H4(141),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(141),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(141),-10,ex4(:),8,G2H2(71),m3h2x2(:,88),heltab2x4(:,:,88))
call signflip_OLR(G2H2(71))
  call Hloop_UV_W(ntryL,G1H4(144),21,ex2(:),2,G2H2(72),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UV_W(ntryL,G0H4(18),21,ex2(:),2,G1H2(18),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QV_A(ntryL,G1H4(145),ex3(:),G1H2(19),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(19),23,0,G2H2(73),n2h2(43))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(146),-8,0,G2H4(31),n2h4(316))
  call Hloop_AV_Q(ntryL,G2H4(31),ex4(:),G2H2(74),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_QV_A(ntryL,G1H4(151),ex3(:),G1H2(19),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(19),23,0,G2H2(75),n2h2(44))
  call Hloop_QV_A(ntryL,G1H4(156),ex3(:),G1H2(19),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(19),23,0,G2H2(76),n2h2(45))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(152),-8,0,G2H4(34),n2h4(317))
  call Hloop_AV_Q(ntryL,G2H4(34),ex4(:),G2H2(77),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_QV_A(ntryL,G1H4(155),ex3(:),G1H2(19),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(19),23,0,G2H2(78),n2h2(46))
  call Hloop_QV_A(ntryL,G0H4(19),ex3(:),G0H2(1),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(19),n2h2(47))
call HGT_OLR(G1H4(157),1,1,4)
call HGT_invQ_OLR(G1H4(157),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(157),-12,0,G2H4(35),n2h4(318))
  call Hloop_AV_Q(ntryL,G2H4(35),ex4(:),G2H2(79),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QV_A(ntryL,G1H4(160),ex3(:),G1H2(20),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(20),23,0,G2H2(80),n2h2(48))
  call Hloop_QV_A(ntryL,G0H4(20),ex3(:),G0H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(20),n2h2(49))
  call Hloop_QV_A(ntryL,G1H4(161),ex3(:),G1H2(21),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(81),n2h2(50))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(162),-8,nMT,G2H4(36),n2h4(319))
  call Hloop_AV_Q(ntryL,G2H4(36),ex4(:),G2H2(82),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(167),ex3(:),G1H2(21),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(83),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(172),ex3(:),G1H2(21),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(84),n2h2(52))
call HGT_OLR(G1H4(168),1,1,4)
call HGT_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(168),-8,nMT,G2H4(39),n2h4(320))
  call Hloop_AV_Q(ntryL,G2H4(39),ex4(:),G2H2(85),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_QV_A(ntryL,G1H4(171),ex3(:),G1H2(21),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(86),n2h2(53))
  call Hloop_QV_A(ntryL,G0H4(21),ex3(:),G0H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(21),n2h2(54))
call HGT_OLR(G1H4(173),1,1,4)
call HGT_invQ_OLR(G1H4(173),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(173),-12,nMT,G2H4(40),n2h4(321))
  call Hloop_AV_Q(ntryL,G2H4(40),ex4(:),G2H2(87),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_QV_A(ntryL,G1H4(176),ex3(:),G1H2(22),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(22),23,nMT,G2H2(88),n2h2(55))
  call Hloop_QV_A(ntryL,G0H4(22),ex3(:),G0H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(22),n2h2(56))
  call Hloop_AV_Q(ntryL,G1H4(177),ex3(:),G1H2(23),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(23),23,0,G2H2(89),n2h2(57))
call HGT_OLR(G1H4(178),1,1,4)
call HGT_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(178),-8,0,G2H4(41),n2h4(322))
  call Hloop_QV_A(ntryL,G2H4(41),ex4(:),G2H2(90),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_AV_Q(ntryL,G1H4(183),ex3(:),G1H2(23),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(23),23,0,G2H2(91),n2h2(58))
  call Hloop_AV_Q(ntryL,G1H4(188),ex3(:),G1H2(23),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(23),23,0,G2H2(92),n2h2(59))
call HGT_OLR(G1H4(184),1,1,4)
call HGT_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(184),-8,0,G2H4(44),n2h4(323))
  call Hloop_QV_A(ntryL,G2H4(44),ex4(:),G2H2(93),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_AV_Q(ntryL,G1H4(187),ex3(:),G1H2(23),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(23),23,0,G2H2(94),n2h2(60))
  call Hloop_AV_Q(ntryL,G0H4(23),ex3(:),G0H2(1),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(23),n2h2(61))
call HGT_OLR(G1H4(189),1,1,4)
call HGT_invQ_OLR(G1H4(189),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(189),-12,0,G2H4(45),n2h4(324))
  call Hloop_QV_A(ntryL,G2H4(45),ex4(:),G2H2(95),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_AV_Q(ntryL,G1H4(192),ex3(:),G1H2(24),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(24),23,0,G2H2(96),n2h2(62))
  call Hloop_AV_Q(ntryL,G0H4(24),ex3(:),G0H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(24),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(193),ex3(:),G1H2(25),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(25),23,nMT,G2H2(97),n2h2(64))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(194),-8,nMT,G2H4(46),n2h4(325))
  call Hloop_QV_A(ntryL,G2H4(46),ex4(:),G2H2(98),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_AV_Q(ntryL,G1H4(199),ex3(:),G1H2(25),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(25),23,nMT,G2H2(99),n2h2(65))
  call Hloop_AV_Q(ntryL,G1H4(204),ex3(:),G1H2(25),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(25),23,nMT,G2H2(100),n2h2(66))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(200),-8,nMT,G2H4(49),n2h4(326))
  call Hloop_QV_A(ntryL,G2H4(49),ex4(:),G2H2(101),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_AV_Q(ntryL,G1H4(203),ex3(:),G1H2(25),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(25),23,nMT,G2H2(102),n2h2(67))
  call Hloop_AV_Q(ntryL,G0H4(25),ex3(:),G0H2(1),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(25),n2h2(68))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(205),-12,nMT,G2H4(50),n2h4(327))
  call Hloop_QV_A(ntryL,G2H4(50),ex4(:),G2H2(103),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AV_Q(ntryL,G1H4(208),ex3(:),G1H2(26),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(26),23,nMT,G2H2(104),n2h2(69))
  call Hloop_AV_Q(ntryL,G0H4(26),ex3(:),G0H2(1),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(26),n2h2(70))
  call Hloop_QV_A(ntryL,G1H4(209),ex3(:),G1H2(27),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMB,G2H2(105),n2h2(71))
call HGT_OLR(G1H4(210),1,1,4)
call HGT_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(210),-8,nMB,G2H4(51),n2h4(328))
  call Hloop_AV_Q(ntryL,G2H4(51),ex4(:),G2H2(106),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_QV_A(ntryL,G1H4(215),ex3(:),G1H2(27),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMB,G2H2(107),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(220),ex3(:),G1H2(27),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMB,G2H2(108),n2h2(73))
call HGT_OLR(G1H4(216),1,1,4)
call HGT_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(216),-8,nMB,G2H4(54),n2h4(329))
  call Hloop_AV_Q(ntryL,G2H4(54),ex4(:),G2H2(109),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_QV_A(ntryL,G1H4(219),ex3(:),G1H2(27),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMB,G2H2(110),n2h2(74))
  call Hloop_QV_A(ntryL,G0H4(27),ex3(:),G0H2(1),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(27),n2h2(75))
call HGT_OLR(G1H4(221),1,1,4)
call HGT_invQ_OLR(G1H4(221),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(221),-12,nMB,G2H4(55),n2h4(330))
  call Hloop_AV_Q(ntryL,G2H4(55),ex4(:),G2H2(111),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_QV_A(ntryL,G1H4(224),ex3(:),G1H2(28),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(28),23,nMB,G2H2(112),n2h2(76))
  call Hloop_QV_A(ntryL,G0H4(28),ex3(:),G0H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(28),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H4(225),ex3(:),G1H2(29),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMB,G2H2(113),n2h2(78))
call HGT_OLR(G1H4(226),1,1,4)
call HGT_invQ_OLR(G1H4(226),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(226),-8,nMB,G2H4(56),n2h4(331))
  call Hloop_QV_A(ntryL,G2H4(56),ex4(:),G2H2(114),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_AV_Q(ntryL,G1H4(231),ex3(:),G1H2(29),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMB,G2H2(115),n2h2(79))
  call Hloop_AV_Q(ntryL,G1H4(236),ex3(:),G1H2(29),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMB,G2H2(116),n2h2(80))
call HGT_OLR(G1H4(232),1,1,4)
call HGT_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(232),-8,nMB,G2H4(59),n2h4(332))
  call Hloop_QV_A(ntryL,G2H4(59),ex4(:),G2H2(117),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_AV_Q(ntryL,G1H4(235),ex3(:),G1H2(29),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMB,G2H2(118),n2h2(81))
  call Hloop_AV_Q(ntryL,G0H4(29),ex3(:),G0H2(1),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(29),n2h2(82))
call HGT_OLR(G1H4(237),1,1,4)
call HGT_invQ_OLR(G1H4(237),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(237),-12,nMB,G2H4(60),n2h4(333))
  call Hloop_QV_A(ntryL,G2H4(60),ex4(:),G2H2(119),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_AV_Q(ntryL,G1H4(240),ex3(:),G1H2(30),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(30),23,nMB,G2H2(120),n2h2(83))
  call Hloop_AV_Q(ntryL,G0H4(30),ex3(:),G0H2(1),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(30),n2h2(84))
  call Hloop_CV_D(ntryL,G1H4(241),19,ex3(:),4,G2H2(121),m3h2x2(:,151),heltab2x4(:,:,151))
call HGT_OLR(G1H4(242),1,1,4)
call HGT_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(242),-8,ex4(:),G2H2(122),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_CV_D(ntryL,G1H4(247),19,ex3(:),4,G2H2(123),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_CV_D(ntryL,G1H4(252),19,ex3(:),4,G2H2(124),m3h2x2(:,154),heltab2x4(:,:,154))
call HGT_OLR(G1H4(248),1,1,4)
call HGT_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(248),-8,ex4(:),G2H2(125),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_CV_D(ntryL,G1H4(251),19,ex3(:),4,G2H2(126),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_CV_D(ntryL,G0H4(31),19,ex3(:),4,G1H2(31),m3h2x2(:,157),heltab2x4(:,:,157))
call HGT_OLR(G1H4(253),1,1,4)
call HGT_invQ_OLR(G1H4(253),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(253),-12,ex4(:),G2H2(127),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_CV_D(ntryL,G1H4(256),19,ex3(:),4,G2H2(128),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_CV_D(ntryL,G0H4(32),19,ex3(:),4,G1H2(32),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_DV_C(ntryL,G1H4(257),19,ex3(:),G2H2(129),m3h2x2(:,161),heltab2x4(:,:,161))
call HGT_OLR(G1H4(258),1,1,4)
call HGT_invQ_OLR(G1H4(258),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(258),-8,ex4(:),8,G2H2(130),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_DV_C(ntryL,G1H4(263),19,ex3(:),G2H2(131),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_DV_C(ntryL,G1H4(268),19,ex3(:),G2H2(132),m3h2x2(:,164),heltab2x4(:,:,164))
call HGT_OLR(G1H4(264),1,1,4)
call HGT_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(264),-8,ex4(:),8,G2H2(133),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_DV_C(ntryL,G1H4(267),19,ex3(:),G2H2(134),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_DV_C(ntryL,G0H4(33),19,ex3(:),G1H2(33),m3h2x2(:,167),heltab2x4(:,:,167))
call HGT_OLR(G1H4(269),1,1,4)
call HGT_invQ_OLR(G1H4(269),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(269),-12,ex4(:),8,G2H2(135),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_DV_C(ntryL,G1H4(272),19,ex3(:),G2H2(136),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_DV_C(ntryL,G0H4(34),19,ex3(:),G1H2(34),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_UV_W(ntryL,G1H4(273),19,ex3(:),4,G2H2(137),m3h2x2(:,171),heltab2x4(:,:,171))
call HGT_raise_alpha_OLR(G1H4(274),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(274),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(274),-8,ex4(:),8,G2H2(138),m3h2x2(:,172),heltab2x4(:,:,172))
call signflip_OLR(G2H2(138))
  call Hloop_UV_W(ntryL,G1H4(279),19,ex3(:),4,G2H2(139),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_UV_W(ntryL,G1H4(284),19,ex3(:),4,G2H2(140),m3h2x2(:,174),heltab2x4(:,:,174))
call HGT_raise_alpha_OLR(G1H4(280),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(280),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(280),-8,ex4(:),8,G2H2(141),m3h2x2(:,175),heltab2x4(:,:,175))
call signflip_OLR(G2H2(141))
  call Hloop_UV_W(ntryL,G1H4(283),19,ex3(:),4,G2H2(142),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_UV_W(ntryL,G0H4(35),19,ex3(:),4,G1H2(35),m3h2x2(:,177),heltab2x4(:,:,177))
call HGT_raise_alpha_OLR(G1H4(285),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(285),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(285),-12,ex4(:),8,G2H2(143),m3h2x2(:,178),heltab2x4(:,:,178))
call signflip_OLR(G2H2(143))
  call Hloop_UV_W(ntryL,G1H4(288),19,ex3(:),4,G2H2(144),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_UV_W(ntryL,G0H4(36),19,ex3(:),4,G1H2(36),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_QV_A(ntryL,G1H4(289),ex1(:),G1H2(37),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(37),23,0,G2H2(145),n2h2(85))
call HGT_OLR(G1H4(290),1,1,4)
call HGT_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(290),-8,0,G2H4(61),n2h4(343))
  call Hloop_AV_Q(ntryL,G2H4(61),ex4(:),G2H2(146),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_QV_A(ntryL,G1H4(295),ex1(:),G1H2(37),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(37),23,0,G2H2(147),n2h2(86))
  call Hloop_QV_A(ntryL,G1H4(300),ex1(:),G1H2(37),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(37),23,0,G2H2(148),n2h2(87))
call HGT_OLR(G1H4(296),1,1,4)
call HGT_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(296),-8,0,G2H4(64),n2h4(344))
  call Hloop_AV_Q(ntryL,G2H4(64),ex4(:),G2H2(149),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_QV_A(ntryL,G1H4(299),ex1(:),G1H2(37),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(37),23,0,G2H2(150),n2h2(88))
  call Hloop_QV_A(ntryL,G0H4(37),ex1(:),G0H2(1),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(37),n2h2(89))
call HGT_OLR(G1H4(301),1,1,4)
call HGT_invQ_OLR(G1H4(301),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(301),-9,0,G2H4(65),n2h4(345))
  call Hloop_AV_Q(ntryL,G2H4(65),ex4(:),G2H2(151),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_QV_A(ntryL,G1H4(304),ex1(:),G1H2(38),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(38),23,0,G2H2(152),n2h2(90))
  call Hloop_QV_A(ntryL,G0H4(38),ex1(:),G0H2(1),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(38),n2h2(91))
  call Hloop_QV_A(ntryL,G1H4(305),ex1(:),G1H2(39),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMT,G2H2(153),n2h2(92))
call HGT_OLR(G1H4(306),1,1,4)
call HGT_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(306),-8,nMT,G2H4(66),n2h4(346))
  call Hloop_AV_Q(ntryL,G2H4(66),ex4(:),G2H2(154),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_QV_A(ntryL,G1H4(311),ex1(:),G1H2(39),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMT,G2H2(155),n2h2(93))
  call Hloop_QV_A(ntryL,G1H4(316),ex1(:),G1H2(39),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMT,G2H2(156),n2h2(94))
call HGT_OLR(G1H4(312),1,1,4)
call HGT_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(312),-8,nMT,G2H4(69),n2h4(347))
  call Hloop_AV_Q(ntryL,G2H4(69),ex4(:),G2H2(157),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_QV_A(ntryL,G1H4(315),ex1(:),G1H2(39),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMT,G2H2(158),n2h2(95))
  call Hloop_QV_A(ntryL,G0H4(39),ex1(:),G0H2(1),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(39),n2h2(96))
call HGT_OLR(G1H4(317),1,1,4)
call HGT_invQ_OLR(G1H4(317),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(317),-9,nMT,G2H4(70),n2h4(348))
  call Hloop_AV_Q(ntryL,G2H4(70),ex4(:),G2H2(159),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_QV_A(ntryL,G1H4(320),ex1(:),G1H2(40),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(40),23,nMT,G2H2(160),n2h2(97))
  call Hloop_QV_A(ntryL,G0H4(40),ex1(:),G0H2(1),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(40),n2h2(98))
  call Hloop_AV_Q(ntryL,G1H4(321),ex1(:),G1H2(41),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(41),23,0,G2H2(161),n2h2(99))
call HGT_OLR(G1H4(322),1,1,4)
call HGT_invQ_OLR(G1H4(322),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(322),-8,0,G2H4(71),n2h4(349))
  call Hloop_QV_A(ntryL,G2H4(71),ex4(:),G2H2(162),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_AV_Q(ntryL,G1H4(327),ex1(:),G1H2(41),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(41),23,0,G2H2(163),n2h2(100))
  call Hloop_AV_Q(ntryL,G1H4(332),ex1(:),G1H2(41),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(41),23,0,G2H2(164),n2h2(101))
call HGT_OLR(G1H4(328),1,1,4)
call HGT_invQ_OLR(G1H4(328),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(328),-8,0,G2H4(74),n2h4(350))
  call Hloop_QV_A(ntryL,G2H4(74),ex4(:),G2H2(165),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_AV_Q(ntryL,G1H4(331),ex1(:),G1H2(41),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(41),23,0,G2H2(166),n2h2(102))
  call Hloop_AV_Q(ntryL,G0H4(41),ex1(:),G0H2(1),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(41),n2h2(103))
call HGT_OLR(G1H4(333),1,1,4)
call HGT_invQ_OLR(G1H4(333),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(333),-9,0,G2H4(75),n2h4(351))
  call Hloop_QV_A(ntryL,G2H4(75),ex4(:),G2H2(167),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_AV_Q(ntryL,G1H4(336),ex1(:),G1H2(42),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(42),23,0,G2H2(168),n2h2(104))
  call Hloop_AV_Q(ntryL,G0H4(42),ex1(:),G0H2(1),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(42),n2h2(105))
  call Hloop_AV_Q(ntryL,G1H4(337),ex1(:),G1H2(43),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMT,G2H2(169),n2h2(106))
call HGT_OLR(G1H4(338),1,1,4)
call HGT_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(338),-8,nMT,G2H4(76),n2h4(352))
  call Hloop_QV_A(ntryL,G2H4(76),ex4(:),G2H2(170),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_AV_Q(ntryL,G1H4(343),ex1(:),G1H2(43),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMT,G2H2(171),n2h2(107))
  call Hloop_AV_Q(ntryL,G1H4(348),ex1(:),G1H2(43),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMT,G2H2(172),n2h2(108))
call HGT_OLR(G1H4(344),1,1,4)
call HGT_invQ_OLR(G1H4(344),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(344),-8,nMT,G2H4(79),n2h4(353))
  call Hloop_QV_A(ntryL,G2H4(79),ex4(:),G2H2(173),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_AV_Q(ntryL,G1H4(347),ex1(:),G1H2(43),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMT,G2H2(174),n2h2(109))
  call Hloop_AV_Q(ntryL,G0H4(43),ex1(:),G0H2(1),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(43),n2h2(110))
call HGT_OLR(G1H4(349),1,1,4)
call HGT_invQ_OLR(G1H4(349),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(349),-9,nMT,G2H4(80),n2h4(354))
  call Hloop_QV_A(ntryL,G2H4(80),ex4(:),G2H2(175),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_AV_Q(ntryL,G1H4(352),ex1(:),G1H2(44),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMT,G2H2(176),n2h2(111))
  call Hloop_AV_Q(ntryL,G0H4(44),ex1(:),G0H2(1),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(44),n2h2(112))
  call Hloop_QV_A(ntryL,G1H4(353),ex1(:),G1H2(45),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(45),23,nMB,G2H2(177),n2h2(113))
call HGT_OLR(G1H4(354),1,1,4)
call HGT_invQ_OLR(G1H4(354),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(354),-8,nMB,G2H4(81),n2h4(355))
  call Hloop_AV_Q(ntryL,G2H4(81),ex4(:),G2H2(178),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_QV_A(ntryL,G1H4(359),ex1(:),G1H2(45),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(45),23,nMB,G2H2(179),n2h2(114))
  call Hloop_QV_A(ntryL,G1H4(364),ex1(:),G1H2(45),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(45),23,nMB,G2H2(180),n2h2(115))
call HGT_OLR(G1H4(360),1,1,4)
call HGT_invQ_OLR(G1H4(360),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(360),-8,nMB,G2H4(84),n2h4(356))
  call Hloop_AV_Q(ntryL,G2H4(84),ex4(:),G2H2(181),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_QV_A(ntryL,G1H4(363),ex1(:),G1H2(45),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_Q_A(ntryL,G1H2(45),23,nMB,G2H2(182),n2h2(116))
  call Hloop_QV_A(ntryL,G0H4(45),ex1(:),G0H2(1),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(45),n2h2(117))
call HGT_OLR(G1H4(365),1,1,4)
call HGT_invQ_OLR(G1H4(365),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(365),-9,nMB,G2H4(85),n2h4(357))
  call Hloop_AV_Q(ntryL,G2H4(85),ex4(:),G2H2(183),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_QV_A(ntryL,G1H4(368),ex1(:),G1H2(46),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(46),23,nMB,G2H2(184),n2h2(118))
  call Hloop_QV_A(ntryL,G0H4(46),ex1(:),G0H2(1),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(46),n2h2(119))
  call Hloop_AV_Q(ntryL,G1H4(369),ex1(:),G1H2(47),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMB,G2H2(185),n2h2(120))
call HGT_OLR(G1H4(370),1,1,4)
call HGT_invQ_OLR(G1H4(370),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(370),-8,nMB,G2H4(86),n2h4(358))
  call Hloop_QV_A(ntryL,G2H4(86),ex4(:),G2H2(186),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_AV_Q(ntryL,G1H4(375),ex1(:),G1H2(47),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMB,G2H2(187),n2h2(121))
  call Hloop_AV_Q(ntryL,G1H4(380),ex1(:),G1H2(47),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMB,G2H2(188),n2h2(122))
call HGT_OLR(G1H4(376),1,1,4)
call HGT_invQ_OLR(G1H4(376),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(376),-8,nMB,G2H4(89),n2h4(359))
  call Hloop_QV_A(ntryL,G2H4(89),ex4(:),G2H2(189),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_AV_Q(ntryL,G1H4(379),ex1(:),G1H2(47),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMB,G2H2(190),n2h2(123))
  call Hloop_AV_Q(ntryL,G0H4(47),ex1(:),G0H2(1),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(47),n2h2(124))
call HGT_OLR(G1H4(381),1,1,4)
call HGT_invQ_OLR(G1H4(381),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(381),-9,nMB,G2H4(90),n2h4(360))
  call Hloop_QV_A(ntryL,G2H4(90),ex4(:),G2H2(191),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_AV_Q(ntryL,G1H4(384),ex1(:),G1H2(48),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(48),23,nMB,G2H2(192),n2h2(125))
  call Hloop_AV_Q(ntryL,G0H4(48),ex1(:),G0H2(1),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(48),n2h2(126))
  call Hloop_CV_D(ntryL,G1H4(385),22,ex1(:),1,G2H2(193),m3h2x2(:,241),heltab2x4(:,:,241))
call HGT_OLR(G1H4(386),1,1,4)
call HGT_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(386),-8,ex4(:),G2H2(194),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_CV_D(ntryL,G1H4(391),22,ex1(:),1,G2H2(195),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_CV_D(ntryL,G1H4(396),22,ex1(:),1,G2H2(196),m3h2x2(:,244),heltab2x4(:,:,244))
call HGT_OLR(G1H4(392),1,1,4)
call HGT_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(392),-8,ex4(:),G2H2(197),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_CV_D(ntryL,G1H4(395),22,ex1(:),1,G2H2(198),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_CV_D(ntryL,G0H4(49),22,ex1(:),1,G1H2(49),m3h2x2(:,247),heltab2x4(:,:,247))
call HGT_OLR(G1H4(397),1,1,4)
call HGT_invQ_OLR(G1H4(397),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(397),-9,ex4(:),G2H2(199),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_CV_D(ntryL,G1H4(400),22,ex1(:),1,G2H2(200),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_CV_D(ntryL,G0H4(50),22,ex1(:),1,G1H2(50),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_DV_C(ntryL,G1H4(401),22,ex1(:),G2H2(201),m3h2x2(:,251),heltab2x4(:,:,251))
call HGT_OLR(G1H4(402),1,1,4)
call HGT_invQ_OLR(G1H4(402),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(402),-8,ex4(:),8,G2H2(202),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_DV_C(ntryL,G1H4(407),22,ex1(:),G2H2(203),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_DV_C(ntryL,G1H4(412),22,ex1(:),G2H2(204),m3h2x2(:,254),heltab2x4(:,:,254))
call HGT_OLR(G1H4(408),1,1,4)
call HGT_invQ_OLR(G1H4(408),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(408),-8,ex4(:),8,G2H2(205),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_DV_C(ntryL,G1H4(411),22,ex1(:),G2H2(206),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_DV_C(ntryL,G0H4(51),22,ex1(:),G1H2(51),m3h2x2(:,257),heltab2x4(:,:,257))
call HGT_OLR(G1H4(413),1,1,4)
call HGT_invQ_OLR(G1H4(413),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(413),-9,ex4(:),8,G2H2(207),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_DV_C(ntryL,G1H4(416),22,ex1(:),G2H2(208),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_DV_C(ntryL,G0H4(52),22,ex1(:),G1H2(52),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_UV_W(ntryL,G1H4(417),22,ex1(:),1,G2H2(209),m3h2x2(:,261),heltab2x4(:,:,261))
call HGT_raise_alpha_OLR(G1H4(418),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(418),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(418),-8,ex4(:),8,G2H2(210),m3h2x2(:,262),heltab2x4(:,:,262))
call signflip_OLR(G2H2(210))
  call Hloop_UV_W(ntryL,G1H4(423),22,ex1(:),1,G2H2(211),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_UV_W(ntryL,G1H4(428),22,ex1(:),1,G2H2(212),m3h2x2(:,264),heltab2x4(:,:,264))
call HGT_raise_alpha_OLR(G1H4(424),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(424),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(424),-8,ex4(:),8,G2H2(213),m3h2x2(:,265),heltab2x4(:,:,265))
call signflip_OLR(G2H2(213))
  call Hloop_UV_W(ntryL,G1H4(427),22,ex1(:),1,G2H2(214),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_UV_W(ntryL,G0H4(53),22,ex1(:),1,G1H2(53),m3h2x2(:,267),heltab2x4(:,:,267))
call HGT_raise_alpha_OLR(G1H4(429),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(429),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(429),-9,ex4(:),8,G2H2(215),m3h2x2(:,268),heltab2x4(:,:,268))
call signflip_OLR(G2H2(215))
  call Hloop_UV_W(ntryL,G1H4(432),22,ex1(:),1,G2H2(216),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_UV_W(ntryL,G0H4(54),22,ex1(:),1,G1H2(54),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_QV_A(ntryL,G1H4(433),ex4(:),G1H2(55),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(55),27,0,G2H2(217),n2h2(127))
call HGT_OLR(G1H4(434),1,1,4)
call HGT_invQ_OLR(G1H4(434),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(434),-4,0,G2H4(91),n2h4(370))
  call Hloop_AV_Q(ntryL,G2H4(91),ex3(:),G2H2(218),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_QV_A(ntryL,G1H4(439),ex4(:),G1H2(55),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(55),27,0,G2H2(219),n2h2(128))
  call Hloop_QV_A(ntryL,G1H4(444),ex4(:),G1H2(55),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_Q_A(ntryL,G1H2(55),27,0,G2H2(220),n2h2(129))
call HGT_OLR(G1H4(440),1,1,4)
call HGT_invQ_OLR(G1H4(440),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(440),-4,0,G2H4(94),n2h4(371))
  call Hloop_AV_Q(ntryL,G2H4(94),ex3(:),G2H2(221),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_QV_A(ntryL,G1H4(443),ex4(:),G1H2(55),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_Q_A(ntryL,G1H2(55),27,0,G2H2(222),n2h2(130))
  call Hloop_QV_A(ntryL,G0H4(55),ex4(:),G0H2(1),m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(55),n2h2(131))
call HGT_OLR(G1H4(445),1,1,4)
call HGT_invQ_OLR(G1H4(445),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(445),-12,0,G2H4(95),n2h4(372))
  call Hloop_AV_Q(ntryL,G2H4(95),ex3(:),G2H2(223),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_QV_A(ntryL,G1H4(448),ex4(:),G1H2(56),m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(56),27,0,G2H2(224),n2h2(132))
  call Hloop_QV_A(ntryL,G0H4(56),ex4(:),G0H2(1),m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(56),n2h2(133))
  call Hloop_QV_A(ntryL,G1H4(449),ex4(:),G1H2(57),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(57),27,nMT,G2H2(225),n2h2(134))
call HGT_OLR(G1H4(450),1,1,4)
call HGT_invQ_OLR(G1H4(450),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(450),-4,nMT,G2H4(96),n2h4(373))
  call Hloop_AV_Q(ntryL,G2H4(96),ex3(:),G2H2(226),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_QV_A(ntryL,G1H4(455),ex4(:),G1H2(57),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(57),27,nMT,G2H2(227),n2h2(135))
  call Hloop_QV_A(ntryL,G1H4(460),ex4(:),G1H2(57),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(57),27,nMT,G2H2(228),n2h2(136))
call HGT_OLR(G1H4(456),1,1,4)
call HGT_invQ_OLR(G1H4(456),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(456),-4,nMT,G2H4(99),n2h4(374))
  call Hloop_AV_Q(ntryL,G2H4(99),ex3(:),G2H2(229),m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_QV_A(ntryL,G1H4(459),ex4(:),G1H2(57),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(57),27,nMT,G2H2(230),n2h2(137))
  call Hloop_QV_A(ntryL,G0H4(57),ex4(:),G0H2(1),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(57),n2h2(138))
call HGT_OLR(G1H4(461),1,1,4)
call HGT_invQ_OLR(G1H4(461),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(461),-12,nMT,G2H4(100),n2h4(375))
  call Hloop_AV_Q(ntryL,G2H4(100),ex3(:),G2H2(231),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_QV_A(ntryL,G1H4(464),ex4(:),G1H2(58),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(58),27,nMT,G2H2(232),n2h2(139))
  call Hloop_QV_A(ntryL,G0H4(58),ex4(:),G0H2(1),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(58),n2h2(140))
  call Hloop_AV_Q(ntryL,G1H4(465),ex4(:),G1H2(59),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(59),27,0,G2H2(233),n2h2(141))
call HGT_OLR(G1H4(466),1,1,4)
call HGT_invQ_OLR(G1H4(466),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(466),-4,0,G2H4(101),n2h4(376))
  call Hloop_QV_A(ntryL,G2H4(101),ex3(:),G2H2(234),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_AV_Q(ntryL,G1H4(471),ex4(:),G1H2(59),m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_A_Q(ntryL,G1H2(59),27,0,G2H2(235),n2h2(142))
  call Hloop_AV_Q(ntryL,G1H4(476),ex4(:),G1H2(59),m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(59),27,0,G2H2(236),n2h2(143))
call HGT_OLR(G1H4(472),1,1,4)
call HGT_invQ_OLR(G1H4(472),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(472),-4,0,G2H4(104),n2h4(377))
  call Hloop_QV_A(ntryL,G2H4(104),ex3(:),G2H2(237),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_AV_Q(ntryL,G1H4(475),ex4(:),G1H2(59),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_A_Q(ntryL,G1H2(59),27,0,G2H2(238),n2h2(144))
  call Hloop_AV_Q(ntryL,G0H4(59),ex4(:),G0H2(1),m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(59),n2h2(145))
call HGT_OLR(G1H4(477),1,1,4)
call HGT_invQ_OLR(G1H4(477),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(477),-12,0,G2H4(105),n2h4(378))
  call Hloop_QV_A(ntryL,G2H4(105),ex3(:),G2H2(239),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_AV_Q(ntryL,G1H4(480),ex4(:),G1H2(60),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(60),27,0,G2H2(240),n2h2(146))
  call Hloop_AV_Q(ntryL,G0H4(60),ex4(:),G0H2(1),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(60),n2h2(147))
  call Hloop_AV_Q(ntryL,G1H4(481),ex4(:),G1H2(61),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMT,G2H2(241),n2h2(148))
call HGT_OLR(G1H4(482),1,1,4)
call HGT_invQ_OLR(G1H4(482),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(482),-4,nMT,G2H4(106),n2h4(379))
  call Hloop_QV_A(ntryL,G2H4(106),ex3(:),G2H2(242),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_AV_Q(ntryL,G1H4(487),ex4(:),G1H2(61),m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMT,G2H2(243),n2h2(149))
  call Hloop_AV_Q(ntryL,G1H4(492),ex4(:),G1H2(61),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMT,G2H2(244),n2h2(150))
call HGT_OLR(G1H4(488),1,1,4)
call HGT_invQ_OLR(G1H4(488),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(488),-4,nMT,G2H4(109),n2h4(380))
  call Hloop_QV_A(ntryL,G2H4(109),ex3(:),G2H2(245),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_AV_Q(ntryL,G1H4(491),ex4(:),G1H2(61),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMT,G2H2(246),n2h2(151))
  call Hloop_AV_Q(ntryL,G0H4(61),ex4(:),G0H2(1),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(61),n2h2(152))
call HGT_OLR(G1H4(493),1,1,4)
call HGT_invQ_OLR(G1H4(493),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(493),-12,nMT,G2H4(110),n2h4(381))
  call Hloop_QV_A(ntryL,G2H4(110),ex3(:),G2H2(247),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_AV_Q(ntryL,G1H4(496),ex4(:),G1H2(62),m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(62),27,nMT,G2H2(248),n2h2(153))
  call Hloop_AV_Q(ntryL,G0H4(62),ex4(:),G0H2(1),m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(62),n2h2(154))
  call Hloop_QV_A(ntryL,G1H4(497),ex4(:),G1H2(63),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(63),27,nMB,G2H2(249),n2h2(155))
call HGT_OLR(G1H4(498),1,1,4)
call HGT_invQ_OLR(G1H4(498),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(498),-4,nMB,G2H4(111),n2h4(382))
  call Hloop_AV_Q(ntryL,G2H4(111),ex3(:),G2H2(250),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_QV_A(ntryL,G1H4(503),ex4(:),G1H2(63),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(63),27,nMB,G2H2(251),n2h2(156))
  call Hloop_QV_A(ntryL,G1H4(508),ex4(:),G1H2(63),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(63),27,nMB,G2H2(252),n2h2(157))
call HGT_OLR(G1H4(504),1,1,4)
call HGT_invQ_OLR(G1H4(504),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(504),-4,nMB,G2H4(114),n2h4(383))
  call Hloop_AV_Q(ntryL,G2H4(114),ex3(:),G2H2(253),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_QV_A(ntryL,G1H4(507),ex4(:),G1H2(63),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(63),27,nMB,G2H2(254),n2h2(158))
  call Hloop_QV_A(ntryL,G0H4(63),ex4(:),G0H2(1),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(63),n2h2(159))
call HGT_OLR(G1H4(509),1,1,4)
call HGT_invQ_OLR(G1H4(509),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(509),-12,nMB,G2H4(115),n2h4(384))
  call Hloop_AV_Q(ntryL,G2H4(115),ex3(:),G2H2(255),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_QV_A(ntryL,G1H4(512),ex4(:),G1H2(64),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(64),27,nMB,G2H2(256),n2h2(160))
  call Hloop_QV_A(ntryL,G0H4(64),ex4(:),G0H2(1),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(64),n2h2(161))
  call Hloop_AV_Q(ntryL,G1H4(513),ex4(:),G1H2(65),m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(257),n2h2(162))
call HGT_OLR(G1H4(514),1,1,4)
call HGT_invQ_OLR(G1H4(514),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(514),-4,nMB,G2H4(116),n2h4(385))
  call Hloop_QV_A(ntryL,G2H4(116),ex3(:),G2H2(258),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_AV_Q(ntryL,G1H4(519),ex4(:),G1H2(65),m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(259),n2h2(163))
  call Hloop_AV_Q(ntryL,G1H4(524),ex4(:),G1H2(65),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(260),n2h2(164))
call HGT_OLR(G1H4(520),1,1,4)
call HGT_invQ_OLR(G1H4(520),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(520),-4,nMB,G2H4(119),n2h4(386))
  call Hloop_QV_A(ntryL,G2H4(119),ex3(:),G2H2(261),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_AV_Q(ntryL,G1H4(523),ex4(:),G1H2(65),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(262),n2h2(165))
  call Hloop_AV_Q(ntryL,G0H4(65),ex4(:),G0H2(1),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(65),n2h2(166))
call HGT_OLR(G1H4(525),1,1,4)
call HGT_invQ_OLR(G1H4(525),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(525),-12,nMB,G2H4(120),n2h4(387))
  call Hloop_QV_A(ntryL,G2H4(120),ex3(:),G2H2(263),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_AV_Q(ntryL,G1H4(528),ex4(:),G1H2(66),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(66),27,nMB,G2H2(264),n2h2(167))
  call Hloop_AV_Q(ntryL,G0H4(66),ex4(:),G0H2(1),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(66),n2h2(168))
  call Hloop_CV_D(ntryL,G1H4(529),19,ex4(:),8,G2H2(265),m3h2x2(:,331),heltab2x4(:,:,331))
call HGT_OLR(G1H4(530),1,1,4)
call HGT_invQ_OLR(G1H4(530),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(530),-4,ex3(:),G2H2(266),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_CV_D(ntryL,G1H4(535),19,ex4(:),8,G2H2(267),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_CV_D(ntryL,G1H4(540),19,ex4(:),8,G2H2(268),m3h2x2(:,334),heltab2x4(:,:,334))
call HGT_OLR(G1H4(536),1,1,4)
call HGT_invQ_OLR(G1H4(536),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(536),-4,ex3(:),G2H2(269),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_CV_D(ntryL,G1H4(539),19,ex4(:),8,G2H2(270),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_CV_D(ntryL,G0H4(67),19,ex4(:),8,G1H2(67),m3h2x2(:,337),heltab2x4(:,:,337))
call HGT_OLR(G1H4(541),1,1,4)
call HGT_invQ_OLR(G1H4(541),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(541),-12,ex3(:),G2H2(271),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_CV_D(ntryL,G1H4(544),19,ex4(:),8,G2H2(272),m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_CV_D(ntryL,G0H4(68),19,ex4(:),8,G1H2(68),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_DV_C(ntryL,G1H4(545),19,ex4(:),G2H2(273),m3h2x2(:,341),heltab2x4(:,:,341))
call HGT_OLR(G1H4(546),1,1,4)
call HGT_invQ_OLR(G1H4(546),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(546),-4,ex3(:),4,G2H2(274),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_DV_C(ntryL,G1H4(551),19,ex4(:),G2H2(275),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_DV_C(ntryL,G1H4(556),19,ex4(:),G2H2(276),m3h2x2(:,344),heltab2x4(:,:,344))
call HGT_OLR(G1H4(552),1,1,4)
call HGT_invQ_OLR(G1H4(552),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(552),-4,ex3(:),4,G2H2(277),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_DV_C(ntryL,G1H4(555),19,ex4(:),G2H2(278),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_DV_C(ntryL,G0H4(69),19,ex4(:),G1H2(69),m3h2x2(:,347),heltab2x4(:,:,347))
call HGT_OLR(G1H4(557),1,1,4)
call HGT_invQ_OLR(G1H4(557),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(557),-12,ex3(:),4,G2H2(279),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_DV_C(ntryL,G1H4(560),19,ex4(:),G2H2(280),m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_DV_C(ntryL,G0H4(70),19,ex4(:),G1H2(70),m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_UV_W(ntryL,G1H4(561),19,ex4(:),8,G2H2(281),m3h2x2(:,351),heltab2x4(:,:,351))
call HGT_raise_alpha_OLR(G1H4(562),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(562),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(562),-4,ex3(:),4,G2H2(282),m3h2x2(:,352),heltab2x4(:,:,352))
call signflip_OLR(G2H2(282))
  call Hloop_UV_W(ntryL,G1H4(567),19,ex4(:),8,G2H2(283),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_UV_W(ntryL,G1H4(572),19,ex4(:),8,G2H2(284),m3h2x2(:,354),heltab2x4(:,:,354))
call HGT_raise_alpha_OLR(G1H4(568),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(568),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(568),-4,ex3(:),4,G2H2(285),m3h2x2(:,355),heltab2x4(:,:,355))
call signflip_OLR(G2H2(285))
  call Hloop_UV_W(ntryL,G1H4(571),19,ex4(:),8,G2H2(286),m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_UV_W(ntryL,G0H4(71),19,ex4(:),8,G1H2(71),m3h2x2(:,357),heltab2x4(:,:,357))
call HGT_raise_alpha_OLR(G1H4(573),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(573),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(573),-12,ex3(:),4,G2H2(287),m3h2x2(:,358),heltab2x4(:,:,358))
call signflip_OLR(G2H2(287))
  call Hloop_UV_W(ntryL,G1H4(576),19,ex4(:),8,G2H2(288),m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_UV_W(ntryL,G0H4(72),19,ex4(:),8,G1H2(72),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_AV_Q(ntryL,G1H4(577),ex3(:),G1H2(73),m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_A_Q(ntryL,G1H2(73),23,0,G2H2(289),n2h2(169))
call HGT_OLR(G1H4(578),1,1,4)
call HGT_invQ_OLR(G1H4(578),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(578),-8,0,G2H4(121),n2h4(397))
  call Hloop_QV_A(ntryL,G2H4(121),ex4(:),G2H2(290),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_AV_Q(ntryL,G1H4(583),ex3(:),G1H2(73),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G1H2(73),23,0,G2H2(291),n2h2(170))
  call Hloop_AV_Q(ntryL,G1H4(588),ex3(:),G1H2(73),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(73),23,0,G2H2(292),n2h2(171))
call HGT_OLR(G1H4(584),1,1,4)
call HGT_invQ_OLR(G1H4(584),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(584),-8,0,G2H4(124),n2h4(398))
  call Hloop_QV_A(ntryL,G2H4(124),ex4(:),G2H2(293),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_AV_Q(ntryL,G1H4(587),ex3(:),G1H2(73),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_A_Q(ntryL,G1H2(73),23,0,G2H2(294),n2h2(172))
  call Hloop_AV_Q(ntryL,G0H4(73),ex3(:),G0H2(1),m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(73),n2h2(173))
call HGT_OLR(G1H4(589),1,1,4)
call HGT_invQ_OLR(G1H4(589),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(589),-12,0,G2H4(125),n2h4(399))
  call Hloop_QV_A(ntryL,G2H4(125),ex4(:),G2H2(295),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_AV_Q(ntryL,G1H4(592),ex3(:),G1H2(74),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_A_Q(ntryL,G1H2(74),23,0,G2H2(296),n2h2(174))
  call Hloop_AV_Q(ntryL,G0H4(74),ex3(:),G0H2(1),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(74),n2h2(175))
  call Hloop_AV_Q(ntryL,G1H4(593),ex3(:),G1H2(75),m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(75),23,nMT,G2H2(297),n2h2(176))
call HGT_OLR(G1H4(594),1,1,4)
call HGT_invQ_OLR(G1H4(594),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(594),-8,nMT,G2H4(126),n2h4(400))
  call Hloop_QV_A(ntryL,G2H4(126),ex4(:),G2H2(298),m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_AV_Q(ntryL,G1H4(599),ex3(:),G1H2(75),m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(75),23,nMT,G2H2(299),n2h2(177))
  call Hloop_AV_Q(ntryL,G1H4(604),ex3(:),G1H2(75),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(75),23,nMT,G2H2(300),n2h2(178))
call HGT_OLR(G1H4(600),1,1,4)
call HGT_invQ_OLR(G1H4(600),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(600),-8,nMT,G2H4(129),n2h4(401))
  call Hloop_QV_A(ntryL,G2H4(129),ex4(:),G2H2(301),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_AV_Q(ntryL,G1H4(603),ex3(:),G1H2(75),m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_A_Q(ntryL,G1H2(75),23,nMT,G2H2(302),n2h2(179))
  call Hloop_AV_Q(ntryL,G0H4(75),ex3(:),G0H2(1),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(75),n2h2(180))
call HGT_OLR(G1H4(605),1,1,4)
call HGT_invQ_OLR(G1H4(605),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(605),-12,nMT,G2H4(130),n2h4(402))
  call Hloop_QV_A(ntryL,G2H4(130),ex4(:),G2H2(303),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_AV_Q(ntryL,G1H4(608),ex3(:),G1H2(76),m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(76),23,nMT,G2H2(304),n2h2(181))
  call Hloop_AV_Q(ntryL,G0H4(76),ex3(:),G0H2(1),m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(76),n2h2(182))
  call Hloop_QV_A(ntryL,G1H4(609),ex3(:),G1H2(77),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_Q_A(ntryL,G1H2(77),23,0,G2H2(305),n2h2(183))
call HGT_OLR(G1H4(610),1,1,4)
call HGT_invQ_OLR(G1H4(610),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(610),-8,0,G2H4(131),n2h4(403))
  call Hloop_AV_Q(ntryL,G2H4(131),ex4(:),G2H2(306),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_QV_A(ntryL,G1H4(615),ex3(:),G1H2(77),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_Q_A(ntryL,G1H2(77),23,0,G2H2(307),n2h2(184))
  call Hloop_QV_A(ntryL,G1H4(620),ex3(:),G1H2(77),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(77),23,0,G2H2(308),n2h2(185))
call HGT_OLR(G1H4(616),1,1,4)
call HGT_invQ_OLR(G1H4(616),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(616),-8,0,G2H4(134),n2h4(404))
  call Hloop_AV_Q(ntryL,G2H4(134),ex4(:),G2H2(309),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_QV_A(ntryL,G1H4(619),ex3(:),G1H2(77),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_Q_A(ntryL,G1H2(77),23,0,G2H2(310),n2h2(186))
  call Hloop_QV_A(ntryL,G0H4(77),ex3(:),G0H2(1),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(77),n2h2(187))
call HGT_OLR(G1H4(621),1,1,4)
call HGT_invQ_OLR(G1H4(621),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(621),-12,0,G2H4(135),n2h4(405))
  call Hloop_AV_Q(ntryL,G2H4(135),ex4(:),G2H2(311),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_QV_A(ntryL,G1H4(624),ex3(:),G1H2(78),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_Q_A(ntryL,G1H2(78),23,0,G2H2(312),n2h2(188))
  call Hloop_QV_A(ntryL,G0H4(78),ex3(:),G0H2(1),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(78),n2h2(189))
  call Hloop_QV_A(ntryL,G1H4(625),ex3(:),G1H2(79),m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(79),23,nMT,G2H2(313),n2h2(190))
call HGT_OLR(G1H4(626),1,1,4)
call HGT_invQ_OLR(G1H4(626),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(626),-8,nMT,G2H4(136),n2h4(406))
  call Hloop_AV_Q(ntryL,G2H4(136),ex4(:),G2H2(314),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_QV_A(ntryL,G1H4(631),ex3(:),G1H2(79),m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(79),23,nMT,G2H2(315),n2h2(191))
  call Hloop_QV_A(ntryL,G1H4(636),ex3(:),G1H2(79),m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(79),23,nMT,G2H2(316),n2h2(192))
call HGT_OLR(G1H4(632),1,1,4)
call HGT_invQ_OLR(G1H4(632),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(632),-8,nMT,G2H4(139),n2h4(407))
  call Hloop_AV_Q(ntryL,G2H4(139),ex4(:),G2H2(317),m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_QV_A(ntryL,G1H4(635),ex3(:),G1H2(79),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(79),23,nMT,G2H2(318),n2h2(193))
  call Hloop_QV_A(ntryL,G0H4(79),ex3(:),G0H2(1),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(79),n2h2(194))
call HGT_OLR(G1H4(637),1,1,4)
call HGT_invQ_OLR(G1H4(637),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(637),-12,nMT,G2H4(140),n2h4(408))
  call Hloop_AV_Q(ntryL,G2H4(140),ex4(:),G2H2(319),m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_QV_A(ntryL,G1H4(640),ex3(:),G1H2(80),m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(80),23,nMT,G2H2(320),n2h2(195))
  call Hloop_QV_A(ntryL,G0H4(80),ex3(:),G0H2(1),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(80),n2h2(196))
  call Hloop_AV_Q(ntryL,G1H4(641),ex3(:),G1H2(81),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMB,G2H2(321),n2h2(197))
call HGT_OLR(G1H4(642),1,1,4)
call HGT_invQ_OLR(G1H4(642),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(642),-8,nMB,G2H4(141),n2h4(409))
  call Hloop_QV_A(ntryL,G2H4(141),ex4(:),G2H2(322),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_AV_Q(ntryL,G1H4(647),ex3(:),G1H2(81),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMB,G2H2(323),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H4(652),ex3(:),G1H2(81),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMB,G2H2(324),n2h2(199))
call HGT_OLR(G1H4(648),1,1,4)
call HGT_invQ_OLR(G1H4(648),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(648),-8,nMB,G2H4(144),n2h4(410))
  call Hloop_QV_A(ntryL,G2H4(144),ex4(:),G2H2(325),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_AV_Q(ntryL,G1H4(651),ex3(:),G1H2(81),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMB,G2H2(326),n2h2(200))
  call Hloop_AV_Q(ntryL,G0H4(81),ex3(:),G0H2(1),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(81),n2h2(201))
call HGT_OLR(G1H4(653),1,1,4)
call HGT_invQ_OLR(G1H4(653),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(653),-12,nMB,G2H4(145),n2h4(411))
  call Hloop_QV_A(ntryL,G2H4(145),ex4(:),G2H2(327),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_AV_Q(ntryL,G1H4(656),ex3(:),G1H2(82),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_A_Q(ntryL,G1H2(82),23,nMB,G2H2(328),n2h2(202))
  call Hloop_AV_Q(ntryL,G0H4(82),ex3(:),G0H2(1),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(82),n2h2(203))
  call Hloop_QV_A(ntryL,G1H4(657),ex3(:),G1H2(83),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(329),n2h2(204))
call HGT_OLR(G1H4(658),1,1,4)
call HGT_invQ_OLR(G1H4(658),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(658),-8,nMB,G2H4(146),n2h4(412))
  call Hloop_AV_Q(ntryL,G2H4(146),ex4(:),G2H2(330),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_QV_A(ntryL,G1H4(663),ex3(:),G1H2(83),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(331),n2h2(205))
  call Hloop_QV_A(ntryL,G1H4(668),ex3(:),G1H2(83),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(332),n2h2(206))
call HGT_OLR(G1H4(664),1,1,4)
call HGT_invQ_OLR(G1H4(664),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(664),-8,nMB,G2H4(149),n2h4(413))
  call Hloop_AV_Q(ntryL,G2H4(149),ex4(:),G2H2(333),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_QV_A(ntryL,G1H4(667),ex3(:),G1H2(83),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(334),n2h2(207))
  call Hloop_QV_A(ntryL,G0H4(83),ex3(:),G0H2(1),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(83),n2h2(208))
call HGT_OLR(G1H4(669),1,1,4)
call HGT_invQ_OLR(G1H4(669),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(669),-12,nMB,G2H4(150),n2h4(414))
  call Hloop_AV_Q(ntryL,G2H4(150),ex4(:),G2H2(335),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_QV_A(ntryL,G1H4(672),ex3(:),G1H2(84),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(84),23,nMB,G2H2(336),n2h2(209))
  call Hloop_QV_A(ntryL,G0H4(84),ex3(:),G0H2(1),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(84),n2h2(210))
  call Hloop_DV_C(ntryL,G1H4(673),19,ex3(:),G2H2(337),m3h2x2(:,421),heltab2x4(:,:,421))
call HGT_OLR(G1H4(674),1,1,4)
call HGT_invQ_OLR(G1H4(674),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(674),-8,ex4(:),8,G2H2(338),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_DV_C(ntryL,G1H4(679),19,ex3(:),G2H2(339),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_DV_C(ntryL,G1H4(684),19,ex3(:),G2H2(340),m3h2x2(:,424),heltab2x4(:,:,424))
call HGT_OLR(G1H4(680),1,1,4)
call HGT_invQ_OLR(G1H4(680),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(680),-8,ex4(:),8,G2H2(341),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_DV_C(ntryL,G1H4(683),19,ex3(:),G2H2(342),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_DV_C(ntryL,G0H4(85),19,ex3(:),G1H2(85),m3h2x2(:,427),heltab2x4(:,:,427))
call HGT_OLR(G1H4(685),1,1,4)
call HGT_invQ_OLR(G1H4(685),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(685),-12,ex4(:),8,G2H2(343),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_DV_C(ntryL,G1H4(688),19,ex3(:),G2H2(344),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_DV_C(ntryL,G0H4(86),19,ex3(:),G1H2(86),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_CV_D(ntryL,G1H4(689),19,ex3(:),4,G2H2(345),m3h2x2(:,431),heltab2x4(:,:,431))
call HGT_OLR(G1H4(690),1,1,4)
call HGT_invQ_OLR(G1H4(690),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(690),-8,ex4(:),G2H2(346),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_CV_D(ntryL,G1H4(695),19,ex3(:),4,G2H2(347),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_CV_D(ntryL,G1H4(700),19,ex3(:),4,G2H2(348),m3h2x2(:,434),heltab2x4(:,:,434))
call HGT_OLR(G1H4(696),1,1,4)
call HGT_invQ_OLR(G1H4(696),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(696),-8,ex4(:),G2H2(349),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_CV_D(ntryL,G1H4(699),19,ex3(:),4,G2H2(350),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_CV_D(ntryL,G0H4(87),19,ex3(:),4,G1H2(87),m3h2x2(:,437),heltab2x4(:,:,437))
call HGT_OLR(G1H4(701),1,1,4)
call HGT_invQ_OLR(G1H4(701),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(701),-12,ex4(:),G2H2(351),m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_CV_D(ntryL,G1H4(704),19,ex3(:),4,G2H2(352),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_CV_D(ntryL,G0H4(88),19,ex3(:),4,G1H2(88),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_UV_W(ntryL,G1H4(705),19,ex3(:),4,G2H2(353),m3h2x2(:,441),heltab2x4(:,:,441))
call HGT_raise_alpha_OLR(G1H4(706),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(706),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(706),-8,ex4(:),8,G2H2(354),m3h2x2(:,442),heltab2x4(:,:,442))
call signflip_OLR(G2H2(354))
  call Hloop_UV_W(ntryL,G1H4(711),19,ex3(:),4,G2H2(355),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_UV_W(ntryL,G1H4(716),19,ex3(:),4,G2H2(356),m3h2x2(:,444),heltab2x4(:,:,444))
call HGT_raise_alpha_OLR(G1H4(712),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(712),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(712),-8,ex4(:),8,G2H2(357),m3h2x2(:,445),heltab2x4(:,:,445))
call signflip_OLR(G2H2(357))
  call Hloop_UV_W(ntryL,G1H4(715),19,ex3(:),4,G2H2(358),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_UV_W(ntryL,G0H4(89),19,ex3(:),4,G1H2(89),m3h2x2(:,447),heltab2x4(:,:,447))
call HGT_raise_alpha_OLR(G1H4(717),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(717),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(717),-12,ex4(:),8,G2H2(359),m3h2x2(:,448),heltab2x4(:,:,448))
call signflip_OLR(G2H2(359))
  call Hloop_UV_W(ntryL,G1H4(720),19,ex3(:),4,G2H2(360),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_UV_W(ntryL,G0H4(90),19,ex3(:),4,G1H2(90),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_AV_Q(ntryL,G1H4(721),ex4(:),G1H2(91),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_A_Q(ntryL,G1H2(91),27,0,G2H2(361),n2h2(211))
call HGT_OLR(G1H4(722),1,1,4)
call HGT_invQ_OLR(G1H4(722),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(722),-4,0,G2H4(151),n2h4(424))
  call Hloop_QV_A(ntryL,G2H4(151),ex3(:),G2H2(362),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_AV_Q(ntryL,G1H4(727),ex4(:),G1H2(91),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_A_Q(ntryL,G1H2(91),27,0,G2H2(363),n2h2(212))
  call Hloop_AV_Q(ntryL,G1H4(732),ex4(:),G1H2(91),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_A_Q(ntryL,G1H2(91),27,0,G2H2(364),n2h2(213))
call HGT_OLR(G1H4(728),1,1,4)
call HGT_invQ_OLR(G1H4(728),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(728),-4,0,G2H4(154),n2h4(425))
  call Hloop_QV_A(ntryL,G2H4(154),ex3(:),G2H2(365),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_AV_Q(ntryL,G1H4(731),ex4(:),G1H2(91),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_A_Q(ntryL,G1H2(91),27,0,G2H2(366),n2h2(214))
  call Hloop_AV_Q(ntryL,G0H4(91),ex4(:),G0H2(1),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(91),n2h2(215))
call HGT_OLR(G1H4(733),1,1,4)
call HGT_invQ_OLR(G1H4(733),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(733),-12,0,G2H4(155),n2h4(426))
  call Hloop_QV_A(ntryL,G2H4(155),ex3(:),G2H2(367),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_AV_Q(ntryL,G1H4(736),ex4(:),G1H2(92),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(92),27,0,G2H2(368),n2h2(216))
  call Hloop_AV_Q(ntryL,G0H4(92),ex4(:),G0H2(1),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(92),n2h2(217))
  call Hloop_AV_Q(ntryL,G1H4(737),ex4(:),G1H2(93),m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_A_Q(ntryL,G1H2(93),27,nMT,G2H2(369),n2h2(218))
call HGT_OLR(G1H4(738),1,1,4)
call HGT_invQ_OLR(G1H4(738),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(738),-4,nMT,G2H4(156),n2h4(427))
  call Hloop_QV_A(ntryL,G2H4(156),ex3(:),G2H2(370),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_AV_Q(ntryL,G1H4(743),ex4(:),G1H2(93),m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_A_Q(ntryL,G1H2(93),27,nMT,G2H2(371),n2h2(219))
  call Hloop_AV_Q(ntryL,G1H4(748),ex4(:),G1H2(93),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_A_Q(ntryL,G1H2(93),27,nMT,G2H2(372),n2h2(220))
call HGT_OLR(G1H4(744),1,1,4)
call HGT_invQ_OLR(G1H4(744),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(744),-4,nMT,G2H4(159),n2h4(428))
  call Hloop_QV_A(ntryL,G2H4(159),ex3(:),G2H2(373),m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_AV_Q(ntryL,G1H4(747),ex4(:),G1H2(93),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_A_Q(ntryL,G1H2(93),27,nMT,G2H2(374),n2h2(221))
  call Hloop_AV_Q(ntryL,G0H4(93),ex4(:),G0H2(1),m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(93),n2h2(222))
call HGT_OLR(G1H4(749),1,1,4)
call HGT_invQ_OLR(G1H4(749),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(749),-12,nMT,G2H4(160),n2h4(429))
  call Hloop_QV_A(ntryL,G2H4(160),ex3(:),G2H2(375),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_AV_Q(ntryL,G1H4(752),ex4(:),G1H2(94),m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_A_Q(ntryL,G1H2(94),27,nMT,G2H2(376),n2h2(223))
  call Hloop_AV_Q(ntryL,G0H4(94),ex4(:),G0H2(1),m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(94),n2h2(224))
  call Hloop_QV_A(ntryL,G1H4(753),ex4(:),G1H2(95),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_Q_A(ntryL,G1H2(95),27,0,G2H2(377),n2h2(225))
call HGT_OLR(G1H4(754),1,1,4)
call HGT_invQ_OLR(G1H4(754),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(754),-4,0,G2H4(161),n2h4(430))
  call Hloop_AV_Q(ntryL,G2H4(161),ex3(:),G2H2(378),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_QV_A(ntryL,G1H4(759),ex4(:),G1H2(95),m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_Q_A(ntryL,G1H2(95),27,0,G2H2(379),n2h2(226))
  call Hloop_QV_A(ntryL,G1H4(764),ex4(:),G1H2(95),m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_Q_A(ntryL,G1H2(95),27,0,G2H2(380),n2h2(227))
call HGT_OLR(G1H4(760),1,1,4)
call HGT_invQ_OLR(G1H4(760),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(760),-4,0,G2H4(164),n2h4(431))
  call Hloop_AV_Q(ntryL,G2H4(164),ex3(:),G2H2(381),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_QV_A(ntryL,G1H4(763),ex4(:),G1H2(95),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_Q_A(ntryL,G1H2(95),27,0,G2H2(382),n2h2(228))
  call Hloop_QV_A(ntryL,G0H4(95),ex4(:),G0H2(1),m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(95),n2h2(229))
call HGT_OLR(G1H4(765),1,1,4)
call HGT_invQ_OLR(G1H4(765),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(765),-12,0,G2H4(165),n2h4(432))
  call Hloop_AV_Q(ntryL,G2H4(165),ex3(:),G2H2(383),m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_QV_A(ntryL,G1H4(768),ex4(:),G1H2(96),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_Q_A(ntryL,G1H2(96),27,0,G2H2(384),n2h2(230))
  call Hloop_QV_A(ntryL,G0H4(96),ex4(:),G0H2(1),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(96),n2h2(231))
  call Hloop_QV_A(ntryL,G1H4(769),ex4(:),G1H2(97),m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_Q_A(ntryL,G1H2(97),27,nMT,G2H2(385),n2h2(232))
call HGT_OLR(G1H4(770),1,1,4)
call HGT_invQ_OLR(G1H4(770),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(770),-4,nMT,G2H4(166),n2h4(433))
  call Hloop_AV_Q(ntryL,G2H4(166),ex3(:),G2H2(386),m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_QV_A(ntryL,G1H4(775),ex4(:),G1H2(97),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_Q_A(ntryL,G1H2(97),27,nMT,G2H2(387),n2h2(233))
  call Hloop_QV_A(ntryL,G1H4(780),ex4(:),G1H2(97),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_Q_A(ntryL,G1H2(97),27,nMT,G2H2(388),n2h2(234))
call HGT_OLR(G1H4(776),1,1,4)
call HGT_invQ_OLR(G1H4(776),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(776),-4,nMT,G2H4(169),n2h4(434))
  call Hloop_AV_Q(ntryL,G2H4(169),ex3(:),G2H2(389),m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_QV_A(ntryL,G1H4(779),ex4(:),G1H2(97),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_Q_A(ntryL,G1H2(97),27,nMT,G2H2(390),n2h2(235))
  call Hloop_QV_A(ntryL,G0H4(97),ex4(:),G0H2(1),m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(97),n2h2(236))
call HGT_OLR(G1H4(781),1,1,4)
call HGT_invQ_OLR(G1H4(781),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(781),-12,nMT,G2H4(170),n2h4(435))
  call Hloop_AV_Q(ntryL,G2H4(170),ex3(:),G2H2(391),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_QV_A(ntryL,G1H4(784),ex4(:),G1H2(98),m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_Q_A(ntryL,G1H2(98),27,nMT,G2H2(392),n2h2(237))
  call Hloop_QV_A(ntryL,G0H4(98),ex4(:),G0H2(1),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(98),n2h2(238))
  call Hloop_AV_Q(ntryL,G1H4(785),ex4(:),G1H2(99),m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_A_Q(ntryL,G1H2(99),27,nMB,G2H2(393),n2h2(239))
call HGT_OLR(G1H4(786),1,1,4)
call HGT_invQ_OLR(G1H4(786),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(786),-4,nMB,G2H4(171),n2h4(436))
  call Hloop_QV_A(ntryL,G2H4(171),ex3(:),G2H2(394),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_AV_Q(ntryL,G1H4(791),ex4(:),G1H2(99),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_A_Q(ntryL,G1H2(99),27,nMB,G2H2(395),n2h2(240))
  call Hloop_AV_Q(ntryL,G1H4(796),ex4(:),G1H2(99),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_A_Q(ntryL,G1H2(99),27,nMB,G2H2(396),n2h2(241))
call HGT_OLR(G1H4(792),1,1,4)
call HGT_invQ_OLR(G1H4(792),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(792),-4,nMB,G2H4(174),n2h4(437))
  call Hloop_QV_A(ntryL,G2H4(174),ex3(:),G2H2(397),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_AV_Q(ntryL,G1H4(795),ex4(:),G1H2(99),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_A_Q(ntryL,G1H2(99),27,nMB,G2H2(398),n2h2(242))
  call Hloop_AV_Q(ntryL,G0H4(99),ex4(:),G0H2(1),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(99),n2h2(243))
call HGT_OLR(G1H4(797),1,1,4)
call HGT_invQ_OLR(G1H4(797),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(797),-12,nMB,G2H4(175),n2h4(438))
  call Hloop_QV_A(ntryL,G2H4(175),ex3(:),G2H2(399),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hloop_AV_Q(ntryL,G1H4(800),ex4(:),G1H2(100),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(100),27,nMB,G2H2(400),n2h2(244))
  call Hloop_AV_Q(ntryL,G0H4(100),ex4(:),G0H2(1),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(100),n2h2(245))
  call Hloop_QV_A(ntryL,G1H4(801),ex4(:),G1H2(101),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_Q_A(ntryL,G1H2(101),27,nMB,G2H2(401),n2h2(246))
call HGT_OLR(G1H4(802),1,1,4)
call HGT_invQ_OLR(G1H4(802),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(802),-4,nMB,G2H4(176),n2h4(439))
  call Hloop_AV_Q(ntryL,G2H4(176),ex3(:),G2H2(402),m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_QV_A(ntryL,G1H4(807),ex4(:),G1H2(101),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_Q_A(ntryL,G1H2(101),27,nMB,G2H2(403),n2h2(247))
  call Hloop_QV_A(ntryL,G1H4(812),ex4(:),G1H2(101),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hloop_Q_A(ntryL,G1H2(101),27,nMB,G2H2(404),n2h2(248))
call HGT_OLR(G1H4(808),1,1,4)
call HGT_invQ_OLR(G1H4(808),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(808),-4,nMB,G2H4(179),n2h4(440))
  call Hloop_AV_Q(ntryL,G2H4(179),ex3(:),G2H2(405),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_QV_A(ntryL,G1H4(811),ex4(:),G1H2(101),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_Q_A(ntryL,G1H2(101),27,nMB,G2H2(406),n2h2(249))
  call Hloop_QV_A(ntryL,G0H4(101),ex4(:),G0H2(1),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(101),n2h2(250))
call HGT_OLR(G1H4(813),1,1,4)
call HGT_invQ_OLR(G1H4(813),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(813),-12,nMB,G2H4(180),n2h4(441))
  call Hloop_AV_Q(ntryL,G2H4(180),ex3(:),G2H2(407),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_QV_A(ntryL,G1H4(816),ex4(:),G1H2(102),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_Q_A(ntryL,G1H2(102),27,nMB,G2H2(408),n2h2(251))
  call Hloop_QV_A(ntryL,G0H4(102),ex4(:),G0H2(1),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(102),n2h2(252))
  call Hloop_DV_C(ntryL,G1H4(817),19,ex4(:),G2H2(409),m3h2x2(:,511),heltab2x4(:,:,511))
call HGT_OLR(G1H4(818),1,1,4)
call HGT_invQ_OLR(G1H4(818),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(818),-4,ex3(:),4,G2H2(410),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_DV_C(ntryL,G1H4(823),19,ex4(:),G2H2(411),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_DV_C(ntryL,G1H4(828),19,ex4(:),G2H2(412),m3h2x2(:,514),heltab2x4(:,:,514))
call HGT_OLR(G1H4(824),1,1,4)
call HGT_invQ_OLR(G1H4(824),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(824),-4,ex3(:),4,G2H2(413),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_DV_C(ntryL,G1H4(827),19,ex4(:),G2H2(414),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_DV_C(ntryL,G0H4(103),19,ex4(:),G1H2(103),m3h2x2(:,517),heltab2x4(:,:,517))
call HGT_OLR(G1H4(829),1,1,4)
call HGT_invQ_OLR(G1H4(829),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(829),-12,ex3(:),4,G2H2(415),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_DV_C(ntryL,G1H4(832),19,ex4(:),G2H2(416),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_DV_C(ntryL,G0H4(104),19,ex4(:),G1H2(104),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_CV_D(ntryL,G1H4(833),19,ex4(:),8,G2H2(417),m3h2x2(:,521),heltab2x4(:,:,521))
call HGT_OLR(G1H4(834),1,1,4)
call HGT_invQ_OLR(G1H4(834),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(834),-4,ex3(:),G2H2(418),m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_CV_D(ntryL,G1H4(839),19,ex4(:),8,G2H2(419),m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_CV_D(ntryL,G1H4(844),19,ex4(:),8,G2H2(420),m3h2x2(:,524),heltab2x4(:,:,524))
call HGT_OLR(G1H4(840),1,1,4)
call HGT_invQ_OLR(G1H4(840),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(840),-4,ex3(:),G2H2(421),m3h2x2(:,525),heltab2x4(:,:,525))
  call Hloop_CV_D(ntryL,G1H4(843),19,ex4(:),8,G2H2(422),m3h2x2(:,526),heltab2x4(:,:,526))
  call Hloop_CV_D(ntryL,G0H4(105),19,ex4(:),8,G1H2(105),m3h2x2(:,527),heltab2x4(:,:,527))
call HGT_OLR(G1H4(845),1,1,4)
call HGT_invQ_OLR(G1H4(845),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(845),-12,ex3(:),G2H2(423),m3h2x2(:,528),heltab2x4(:,:,528))
  call Hloop_CV_D(ntryL,G1H4(848),19,ex4(:),8,G2H2(424),m3h2x2(:,529),heltab2x4(:,:,529))
  call Hloop_CV_D(ntryL,G0H4(106),19,ex4(:),8,G1H2(106),m3h2x2(:,530),heltab2x4(:,:,530))
  call Hloop_UV_W(ntryL,G1H4(849),19,ex4(:),8,G2H2(425),m3h2x2(:,531),heltab2x4(:,:,531))
call HGT_raise_alpha_OLR(G1H4(850),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(850),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(850),-4,ex3(:),4,G2H2(426),m3h2x2(:,532),heltab2x4(:,:,532))
call signflip_OLR(G2H2(426))
  call Hloop_UV_W(ntryL,G1H4(855),19,ex4(:),8,G2H2(427),m3h2x2(:,533),heltab2x4(:,:,533))
  call Hloop_UV_W(ntryL,G1H4(860),19,ex4(:),8,G2H2(428),m3h2x2(:,534),heltab2x4(:,:,534))
call HGT_raise_alpha_OLR(G1H4(856),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(856),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(856),-4,ex3(:),4,G2H2(429),m3h2x2(:,535),heltab2x4(:,:,535))
call signflip_OLR(G2H2(429))
  call Hloop_UV_W(ntryL,G1H4(859),19,ex4(:),8,G2H2(430),m3h2x2(:,536),heltab2x4(:,:,536))
  call Hloop_UV_W(ntryL,G0H4(107),19,ex4(:),8,G1H2(107),m3h2x2(:,537),heltab2x4(:,:,537))
call HGT_raise_alpha_OLR(G1H4(861),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(861),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(861),-12,ex3(:),4,G2H2(431),m3h2x2(:,538),heltab2x4(:,:,538))
call signflip_OLR(G2H2(431))
  call Hloop_UV_W(ntryL,G1H4(864),19,ex4(:),8,G2H2(432),m3h2x2(:,539),heltab2x4(:,:,539))
  call Hloop_UV_W(ntryL,G0H4(108),19,ex4(:),8,G1H2(108),m3h2x2(:,540),heltab2x4(:,:,540))
  call Hloop_QV_A(ntryL,G1H4(865),ex1(:),G1H2(109),m3h2x2(:,541),heltab2x4(:,:,541))
  call Hloop_Q_A(ntryL,G1H2(109),23,0,G2H2(433),n2h2(253))
call HGT_OLR(G1H4(866),1,1,4)
call HGT_invQ_OLR(G1H4(866),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(866),-8,0,G2H4(181),n2h4(451))
  call Hloop_AV_Q(ntryL,G2H4(181),ex4(:),G2H2(434),m3h2x2(:,542),heltab2x4(:,:,542))
  call Hloop_QV_A(ntryL,G1H4(871),ex1(:),G1H2(109),m3h2x2(:,543),heltab2x4(:,:,543))
  call Hloop_Q_A(ntryL,G1H2(109),23,0,G2H2(435),n2h2(254))
  call Hloop_QV_A(ntryL,G1H4(876),ex1(:),G1H2(109),m3h2x2(:,544),heltab2x4(:,:,544))
  call Hloop_Q_A(ntryL,G1H2(109),23,0,G2H2(436),n2h2(255))
call HGT_OLR(G1H4(872),1,1,4)
call HGT_invQ_OLR(G1H4(872),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(872),-8,0,G2H4(184),n2h4(452))
  call Hloop_AV_Q(ntryL,G2H4(184),ex4(:),G2H2(437),m3h2x2(:,545),heltab2x4(:,:,545))
  call Hloop_QV_A(ntryL,G1H4(875),ex1(:),G1H2(109),m3h2x2(:,546),heltab2x4(:,:,546))
  call Hloop_Q_A(ntryL,G1H2(109),23,0,G2H2(438),n2h2(256))
  call Hloop_QV_A(ntryL,G0H4(109),ex1(:),G0H2(1),m3h2x2(:,547),heltab2x4(:,:,547))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(109),n2h2(257))
call HGT_OLR(G1H4(877),1,1,4)
call HGT_invQ_OLR(G1H4(877),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(877),-9,0,G2H4(185),n2h4(453))
  call Hloop_AV_Q(ntryL,G2H4(185),ex4(:),G2H2(439),m3h2x2(:,548),heltab2x4(:,:,548))
  call Hloop_QV_A(ntryL,G1H4(880),ex1(:),G1H2(110),m3h2x2(:,549),heltab2x4(:,:,549))
  call Hloop_Q_A(ntryL,G1H2(110),23,0,G2H2(440),n2h2(258))
  call Hloop_QV_A(ntryL,G0H4(110),ex1(:),G0H2(1),m3h2x2(:,550),heltab2x4(:,:,550))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(110),n2h2(259))
  call Hloop_QV_A(ntryL,G1H4(881),ex1(:),G1H2(111),m3h2x2(:,551),heltab2x4(:,:,551))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMT,G2H2(441),n2h2(260))
call HGT_OLR(G1H4(882),1,1,4)
call HGT_invQ_OLR(G1H4(882),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(882),-8,nMT,G2H4(186),n2h4(454))
  call Hloop_AV_Q(ntryL,G2H4(186),ex4(:),G2H2(442),m3h2x2(:,552),heltab2x4(:,:,552))
  call Hloop_QV_A(ntryL,G1H4(887),ex1(:),G1H2(111),m3h2x2(:,553),heltab2x4(:,:,553))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMT,G2H2(443),n2h2(261))
  call Hloop_QV_A(ntryL,G1H4(892),ex1(:),G1H2(111),m3h2x2(:,554),heltab2x4(:,:,554))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMT,G2H2(444),n2h2(262))
call HGT_OLR(G1H4(888),1,1,4)
call HGT_invQ_OLR(G1H4(888),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(888),-8,nMT,G2H4(189),n2h4(455))
  call Hloop_AV_Q(ntryL,G2H4(189),ex4(:),G2H2(445),m3h2x2(:,555),heltab2x4(:,:,555))
  call Hloop_QV_A(ntryL,G1H4(891),ex1(:),G1H2(111),m3h2x2(:,556),heltab2x4(:,:,556))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMT,G2H2(446),n2h2(263))
  call Hloop_QV_A(ntryL,G0H4(111),ex1(:),G0H2(1),m3h2x2(:,557),heltab2x4(:,:,557))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(111),n2h2(264))
call HGT_OLR(G1H4(893),1,1,4)
call HGT_invQ_OLR(G1H4(893),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(893),-9,nMT,G2H4(190),n2h4(456))
  call Hloop_AV_Q(ntryL,G2H4(190),ex4(:),G2H2(447),m3h2x2(:,558),heltab2x4(:,:,558))
  call Hloop_QV_A(ntryL,G1H4(896),ex1(:),G1H2(112),m3h2x2(:,559),heltab2x4(:,:,559))
  call Hloop_Q_A(ntryL,G1H2(112),23,nMT,G2H2(448),n2h2(265))
  call Hloop_QV_A(ntryL,G0H4(112),ex1(:),G0H2(1),m3h2x2(:,560),heltab2x4(:,:,560))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(112),n2h2(266))
  call Hloop_AV_Q(ntryL,G1H4(897),ex1(:),G1H2(113),m3h2x2(:,561),heltab2x4(:,:,561))
  call Hloop_A_Q(ntryL,G1H2(113),23,0,G2H2(449),n2h2(267))
call HGT_OLR(G1H4(898),1,1,4)
call HGT_invQ_OLR(G1H4(898),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(898),-8,0,G2H4(191),n2h4(457))
  call Hloop_QV_A(ntryL,G2H4(191),ex4(:),G2H2(450),m3h2x2(:,562),heltab2x4(:,:,562))
  call Hloop_AV_Q(ntryL,G1H4(903),ex1(:),G1H2(113),m3h2x2(:,563),heltab2x4(:,:,563))
  call Hloop_A_Q(ntryL,G1H2(113),23,0,G2H2(451),n2h2(268))
  call Hloop_AV_Q(ntryL,G1H4(908),ex1(:),G1H2(113),m3h2x2(:,564),heltab2x4(:,:,564))
  call Hloop_A_Q(ntryL,G1H2(113),23,0,G2H2(452),n2h2(269))
call HGT_OLR(G1H4(904),1,1,4)
call HGT_invQ_OLR(G1H4(904),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(904),-8,0,G2H4(194),n2h4(458))
  call Hloop_QV_A(ntryL,G2H4(194),ex4(:),G2H2(453),m3h2x2(:,565),heltab2x4(:,:,565))
  call Hloop_AV_Q(ntryL,G1H4(907),ex1(:),G1H2(113),m3h2x2(:,566),heltab2x4(:,:,566))
  call Hloop_A_Q(ntryL,G1H2(113),23,0,G2H2(454),n2h2(270))
  call Hloop_AV_Q(ntryL,G0H4(113),ex1(:),G0H2(1),m3h2x2(:,567),heltab2x4(:,:,567))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(113),n2h2(271))
call HGT_OLR(G1H4(909),1,1,4)
call HGT_invQ_OLR(G1H4(909),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(909),-9,0,G2H4(195),n2h4(459))
  call Hloop_QV_A(ntryL,G2H4(195),ex4(:),G2H2(455),m3h2x2(:,568),heltab2x4(:,:,568))
  call Hloop_AV_Q(ntryL,G1H4(912),ex1(:),G1H2(114),m3h2x2(:,569),heltab2x4(:,:,569))
  call Hloop_A_Q(ntryL,G1H2(114),23,0,G2H2(456),n2h2(272))
  call Hloop_AV_Q(ntryL,G0H4(114),ex1(:),G0H2(1),m3h2x2(:,570),heltab2x4(:,:,570))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(114),n2h2(273))
  call Hloop_AV_Q(ntryL,G1H4(913),ex1(:),G1H2(115),m3h2x2(:,571),heltab2x4(:,:,571))
  call Hloop_A_Q(ntryL,G1H2(115),23,nMT,G2H2(457),n2h2(274))
call HGT_OLR(G1H4(914),1,1,4)
call HGT_invQ_OLR(G1H4(914),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(914),-8,nMT,G2H4(196),n2h4(460))
  call Hloop_QV_A(ntryL,G2H4(196),ex4(:),G2H2(458),m3h2x2(:,572),heltab2x4(:,:,572))
  call Hloop_AV_Q(ntryL,G1H4(919),ex1(:),G1H2(115),m3h2x2(:,573),heltab2x4(:,:,573))
  call Hloop_A_Q(ntryL,G1H2(115),23,nMT,G2H2(459),n2h2(275))
  call Hloop_AV_Q(ntryL,G1H4(924),ex1(:),G1H2(115),m3h2x2(:,574),heltab2x4(:,:,574))
  call Hloop_A_Q(ntryL,G1H2(115),23,nMT,G2H2(460),n2h2(276))
call HGT_OLR(G1H4(920),1,1,4)
call HGT_invQ_OLR(G1H4(920),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(920),-8,nMT,G2H4(199),n2h4(461))
  call Hloop_QV_A(ntryL,G2H4(199),ex4(:),G2H2(461),m3h2x2(:,575),heltab2x4(:,:,575))
  call Hloop_AV_Q(ntryL,G1H4(923),ex1(:),G1H2(115),m3h2x2(:,576),heltab2x4(:,:,576))
  call Hloop_A_Q(ntryL,G1H2(115),23,nMT,G2H2(462),n2h2(277))
  call Hloop_AV_Q(ntryL,G0H4(115),ex1(:),G0H2(1),m3h2x2(:,577),heltab2x4(:,:,577))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(115),n2h2(278))
call HGT_OLR(G1H4(925),1,1,4)
call HGT_invQ_OLR(G1H4(925),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(925),-9,nMT,G2H4(200),n2h4(462))
  call Hloop_QV_A(ntryL,G2H4(200),ex4(:),G2H2(463),m3h2x2(:,578),heltab2x4(:,:,578))
  call Hloop_AV_Q(ntryL,G1H4(928),ex1(:),G1H2(116),m3h2x2(:,579),heltab2x4(:,:,579))
  call Hloop_A_Q(ntryL,G1H2(116),23,nMT,G2H2(464),n2h2(279))
  call Hloop_AV_Q(ntryL,G0H4(116),ex1(:),G0H2(1),m3h2x2(:,580),heltab2x4(:,:,580))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(116),n2h2(280))
  call Hloop_QV_A(ntryL,G1H4(929),ex1(:),G1H2(117),m3h2x2(:,581),heltab2x4(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(117),23,nMB,G2H2(465),n2h2(281))
call HGT_OLR(G1H4(930),1,1,4)
call HGT_invQ_OLR(G1H4(930),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(930),-8,nMB,G2H4(201),n2h4(463))
  call Hloop_AV_Q(ntryL,G2H4(201),ex4(:),G2H2(466),m3h2x2(:,582),heltab2x4(:,:,582))
  call Hloop_QV_A(ntryL,G1H4(935),ex1(:),G1H2(117),m3h2x2(:,583),heltab2x4(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(117),23,nMB,G2H2(467),n2h2(282))
  call Hloop_QV_A(ntryL,G1H4(940),ex1(:),G1H2(117),m3h2x2(:,584),heltab2x4(:,:,584))
  call Hloop_Q_A(ntryL,G1H2(117),23,nMB,G2H2(468),n2h2(283))
call HGT_OLR(G1H4(936),1,1,4)
call HGT_invQ_OLR(G1H4(936),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(936),-8,nMB,G2H4(204),n2h4(464))
  call Hloop_AV_Q(ntryL,G2H4(204),ex4(:),G2H2(469),m3h2x2(:,585),heltab2x4(:,:,585))
  call Hloop_QV_A(ntryL,G1H4(939),ex1(:),G1H2(117),m3h2x2(:,586),heltab2x4(:,:,586))
  call Hloop_Q_A(ntryL,G1H2(117),23,nMB,G2H2(470),n2h2(284))
  call Hloop_QV_A(ntryL,G0H4(117),ex1(:),G0H2(1),m3h2x2(:,587),heltab2x4(:,:,587))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(117),n2h2(285))
call HGT_OLR(G1H4(941),1,1,4)
call HGT_invQ_OLR(G1H4(941),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(941),-9,nMB,G2H4(205),n2h4(465))
  call Hloop_AV_Q(ntryL,G2H4(205),ex4(:),G2H2(471),m3h2x2(:,588),heltab2x4(:,:,588))
  call Hloop_QV_A(ntryL,G1H4(944),ex1(:),G1H2(118),m3h2x2(:,589),heltab2x4(:,:,589))
  call Hloop_Q_A(ntryL,G1H2(118),23,nMB,G2H2(472),n2h2(286))
  call Hloop_QV_A(ntryL,G0H4(118),ex1(:),G0H2(1),m3h2x2(:,590),heltab2x4(:,:,590))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(118),n2h2(287))
  call Hloop_AV_Q(ntryL,G1H4(945),ex1(:),G1H2(119),m3h2x2(:,591),heltab2x4(:,:,591))
  call Hloop_A_Q(ntryL,G1H2(119),23,nMB,G2H2(473),n2h2(288))
call HGT_OLR(G1H4(946),1,1,4)
call HGT_invQ_OLR(G1H4(946),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(946),-8,nMB,G2H4(206),n2h4(466))
  call Hloop_QV_A(ntryL,G2H4(206),ex4(:),G2H2(474),m3h2x2(:,592),heltab2x4(:,:,592))
  call Hloop_AV_Q(ntryL,G1H4(951),ex1(:),G1H2(119),m3h2x2(:,593),heltab2x4(:,:,593))
  call Hloop_A_Q(ntryL,G1H2(119),23,nMB,G2H2(475),n2h2(289))
  call Hloop_AV_Q(ntryL,G1H4(956),ex1(:),G1H2(119),m3h2x2(:,594),heltab2x4(:,:,594))
  call Hloop_A_Q(ntryL,G1H2(119),23,nMB,G2H2(476),n2h2(290))
call HGT_OLR(G1H4(952),1,1,4)
call HGT_invQ_OLR(G1H4(952),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(952),-8,nMB,G2H4(209),n2h4(467))
  call Hloop_QV_A(ntryL,G2H4(209),ex4(:),G2H2(477),m3h2x2(:,595),heltab2x4(:,:,595))
  call Hloop_AV_Q(ntryL,G1H4(955),ex1(:),G1H2(119),m3h2x2(:,596),heltab2x4(:,:,596))
  call Hloop_A_Q(ntryL,G1H2(119),23,nMB,G2H2(478),n2h2(291))
  call Hloop_AV_Q(ntryL,G0H4(119),ex1(:),G0H2(1),m3h2x2(:,597),heltab2x4(:,:,597))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(119),n2h2(292))
call HGT_OLR(G1H4(957),1,1,4)
call HGT_invQ_OLR(G1H4(957),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(957),-9,nMB,G2H4(210),n2h4(468))
  call Hloop_QV_A(ntryL,G2H4(210),ex4(:),G2H2(479),m3h2x2(:,598),heltab2x4(:,:,598))
  call Hloop_AV_Q(ntryL,G1H4(960),ex1(:),G1H2(120),m3h2x2(:,599),heltab2x4(:,:,599))
  call Hloop_A_Q(ntryL,G1H2(120),23,nMB,G2H2(480),n2h2(293))
  call Hloop_AV_Q(ntryL,G0H4(120),ex1(:),G0H2(1),m3h2x2(:,600),heltab2x4(:,:,600))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(120),n2h2(294))
  call Hloop_CV_D(ntryL,G1H4(961),22,ex1(:),1,G2H2(481),m3h2x2(:,601),heltab2x4(:,:,601))
call HGT_OLR(G1H4(962),1,1,4)
call HGT_invQ_OLR(G1H4(962),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(962),-8,ex4(:),G2H2(482),m3h2x2(:,602),heltab2x4(:,:,602))
  call Hloop_CV_D(ntryL,G1H4(967),22,ex1(:),1,G2H2(483),m3h2x2(:,603),heltab2x4(:,:,603))
  call Hloop_CV_D(ntryL,G1H4(972),22,ex1(:),1,G2H2(484),m3h2x2(:,604),heltab2x4(:,:,604))
call HGT_OLR(G1H4(968),1,1,4)
call HGT_invQ_OLR(G1H4(968),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(968),-8,ex4(:),G2H2(485),m3h2x2(:,605),heltab2x4(:,:,605))
  call Hloop_CV_D(ntryL,G1H4(971),22,ex1(:),1,G2H2(486),m3h2x2(:,606),heltab2x4(:,:,606))
  call Hloop_CV_D(ntryL,G0H4(121),22,ex1(:),1,G1H2(121),m3h2x2(:,607),heltab2x4(:,:,607))
call HGT_OLR(G1H4(973),1,1,4)
call HGT_invQ_OLR(G1H4(973),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(973),-9,ex4(:),G2H2(487),m3h2x2(:,608),heltab2x4(:,:,608))
  call Hloop_CV_D(ntryL,G1H4(976),22,ex1(:),1,G2H2(488),m3h2x2(:,609),heltab2x4(:,:,609))
  call Hloop_CV_D(ntryL,G0H4(122),22,ex1(:),1,G1H2(122),m3h2x2(:,610),heltab2x4(:,:,610))
  call Hloop_DV_C(ntryL,G1H4(977),22,ex1(:),G2H2(489),m3h2x2(:,611),heltab2x4(:,:,611))
call HGT_OLR(G1H4(978),1,1,4)
call HGT_invQ_OLR(G1H4(978),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(978),-8,ex4(:),8,G2H2(490),m3h2x2(:,612),heltab2x4(:,:,612))
  call Hloop_DV_C(ntryL,G1H4(983),22,ex1(:),G2H2(491),m3h2x2(:,613),heltab2x4(:,:,613))
  call Hloop_DV_C(ntryL,G1H4(988),22,ex1(:),G2H2(492),m3h2x2(:,614),heltab2x4(:,:,614))
call HGT_OLR(G1H4(984),1,1,4)
call HGT_invQ_OLR(G1H4(984),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(984),-8,ex4(:),8,G2H2(493),m3h2x2(:,615),heltab2x4(:,:,615))
  call Hloop_DV_C(ntryL,G1H4(987),22,ex1(:),G2H2(494),m3h2x2(:,616),heltab2x4(:,:,616))
  call Hloop_DV_C(ntryL,G0H4(123),22,ex1(:),G1H2(123),m3h2x2(:,617),heltab2x4(:,:,617))
call HGT_OLR(G1H4(989),1,1,4)
call HGT_invQ_OLR(G1H4(989),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(989),-9,ex4(:),8,G2H2(495),m3h2x2(:,618),heltab2x4(:,:,618))
  call Hloop_DV_C(ntryL,G1H4(992),22,ex1(:),G2H2(496),m3h2x2(:,619),heltab2x4(:,:,619))
  call Hloop_DV_C(ntryL,G0H4(124),22,ex1(:),G1H2(124),m3h2x2(:,620),heltab2x4(:,:,620))
  call Hloop_UV_W(ntryL,G1H4(993),22,ex1(:),1,G2H2(497),m3h2x2(:,621),heltab2x4(:,:,621))
call HGT_raise_alpha_OLR(G1H4(994),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(994),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(994),-8,ex4(:),8,G2H2(498),m3h2x2(:,622),heltab2x4(:,:,622))
call signflip_OLR(G2H2(498))
  call Hloop_UV_W(ntryL,G1H4(999),22,ex1(:),1,G2H2(499),m3h2x2(:,623),heltab2x4(:,:,623))
  call Hloop_UV_W(ntryL,G1H4(1004),22,ex1(:),1,G2H2(500),m3h2x2(:,624),heltab2x4(:,:,624))
call HGT_raise_alpha_OLR(G1H4(1000),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1000),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1000),-8,ex4(:),8,G2H2(501),m3h2x2(:,625),heltab2x4(:,:,625))
call signflip_OLR(G2H2(501))
  call Hloop_UV_W(ntryL,G1H4(1003),22,ex1(:),1,G2H2(502),m3h2x2(:,626),heltab2x4(:,:,626))
  call Hloop_UV_W(ntryL,G0H4(125),22,ex1(:),1,G1H2(125),m3h2x2(:,627),heltab2x4(:,:,627))
call HGT_raise_alpha_OLR(G1H4(1005),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1005),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1005),-9,ex4(:),8,G2H2(503),m3h2x2(:,628),heltab2x4(:,:,628))
call signflip_OLR(G2H2(503))
  call Hloop_UV_W(ntryL,G1H4(1008),22,ex1(:),1,G2H2(504),m3h2x2(:,629),heltab2x4(:,:,629))
  call Hloop_UV_W(ntryL,G0H4(126),22,ex1(:),1,G1H2(126),m3h2x2(:,630),heltab2x4(:,:,630))
  call Hloop_AV_Q(ntryL,G1H4(1009),ex1(:),G1H2(127),m3h2x2(:,631),heltab2x4(:,:,631))
  call Hloop_A_Q(ntryL,G1H2(127),27,0,G2H2(505),n2h2(295))
call HGT_OLR(G1H4(1010),1,1,4)
call HGT_invQ_OLR(G1H4(1010),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1010),-4,0,G2H4(211),n2h4(478))
  call Hloop_QV_A(ntryL,G2H4(211),ex3(:),G2H2(506),m3h2x2(:,632),heltab2x4(:,:,632))
  call Hloop_AV_Q(ntryL,G1H4(1015),ex1(:),G1H2(127),m3h2x2(:,633),heltab2x4(:,:,633))
  call Hloop_A_Q(ntryL,G1H2(127),27,0,G2H2(507),n2h2(296))
  call Hloop_AV_Q(ntryL,G1H4(1020),ex1(:),G1H2(127),m3h2x2(:,634),heltab2x4(:,:,634))
  call Hloop_A_Q(ntryL,G1H2(127),27,0,G2H2(508),n2h2(297))
call HGT_OLR(G1H4(1016),1,1,4)
call HGT_invQ_OLR(G1H4(1016),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1016),-4,0,G2H4(214),n2h4(479))
  call Hloop_QV_A(ntryL,G2H4(214),ex3(:),G2H2(509),m3h2x2(:,635),heltab2x4(:,:,635))
  call Hloop_AV_Q(ntryL,G1H4(1019),ex1(:),G1H2(127),m3h2x2(:,636),heltab2x4(:,:,636))
  call Hloop_A_Q(ntryL,G1H2(127),27,0,G2H2(510),n2h2(298))
  call Hloop_AV_Q(ntryL,G0H4(127),ex1(:),G0H2(1),m3h2x2(:,637),heltab2x4(:,:,637))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(127),n2h2(299))
call HGT_OLR(G1H4(1021),1,1,4)
call HGT_invQ_OLR(G1H4(1021),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1021),-5,0,G2H4(215),n2h4(480))
  call Hloop_QV_A(ntryL,G2H4(215),ex3(:),G2H2(511),m3h2x2(:,638),heltab2x4(:,:,638))
  call Hloop_AV_Q(ntryL,G1H4(1024),ex1(:),G1H2(128),m3h2x2(:,639),heltab2x4(:,:,639))
  call Hloop_A_Q(ntryL,G1H2(128),27,0,G2H2(512),n2h2(300))
  call Hloop_AV_Q(ntryL,G0H4(128),ex1(:),G0H2(1),m3h2x2(:,640),heltab2x4(:,:,640))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(128),n2h2(301))
  call Hloop_AV_Q(ntryL,G1H4(1025),ex1(:),G1H2(129),m3h2x2(:,641),heltab2x4(:,:,641))
  call Hloop_A_Q(ntryL,G1H2(129),27,nMT,G2H2(513),n2h2(302))
call HGT_OLR(G1H4(1026),1,1,4)
call HGT_invQ_OLR(G1H4(1026),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1026),-4,nMT,G2H4(216),n2h4(481))
  call Hloop_QV_A(ntryL,G2H4(216),ex3(:),G2H2(514),m3h2x2(:,642),heltab2x4(:,:,642))
  call Hloop_AV_Q(ntryL,G1H4(1031),ex1(:),G1H2(129),m3h2x2(:,643),heltab2x4(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(129),27,nMT,G2H2(515),n2h2(303))
  call Hloop_AV_Q(ntryL,G1H4(1036),ex1(:),G1H2(129),m3h2x2(:,644),heltab2x4(:,:,644))
  call Hloop_A_Q(ntryL,G1H2(129),27,nMT,G2H2(516),n2h2(304))
call HGT_OLR(G1H4(1032),1,1,4)
call HGT_invQ_OLR(G1H4(1032),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1032),-4,nMT,G2H4(219),n2h4(482))
  call Hloop_QV_A(ntryL,G2H4(219),ex3(:),G2H2(517),m3h2x2(:,645),heltab2x4(:,:,645))
  call Hloop_AV_Q(ntryL,G1H4(1035),ex1(:),G1H2(129),m3h2x2(:,646),heltab2x4(:,:,646))
  call Hloop_A_Q(ntryL,G1H2(129),27,nMT,G2H2(518),n2h2(305))
  call Hloop_AV_Q(ntryL,G0H4(129),ex1(:),G0H2(1),m3h2x2(:,647),heltab2x4(:,:,647))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(129),n2h2(306))
call HGT_OLR(G1H4(1037),1,1,4)
call HGT_invQ_OLR(G1H4(1037),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1037),-5,nMT,G2H4(220),n2h4(483))
  call Hloop_QV_A(ntryL,G2H4(220),ex3(:),G2H2(519),m3h2x2(:,648),heltab2x4(:,:,648))
  call Hloop_AV_Q(ntryL,G1H4(1040),ex1(:),G1H2(130),m3h2x2(:,649),heltab2x4(:,:,649))
  call Hloop_A_Q(ntryL,G1H2(130),27,nMT,G2H2(520),n2h2(307))
  call Hloop_AV_Q(ntryL,G0H4(130),ex1(:),G0H2(1),m3h2x2(:,650),heltab2x4(:,:,650))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(130),n2h2(308))
  call Hloop_QV_A(ntryL,G1H4(1041),ex1(:),G1H2(131),m3h2x2(:,651),heltab2x4(:,:,651))
  call Hloop_Q_A(ntryL,G1H2(131),27,0,G2H2(521),n2h2(309))
call HGT_OLR(G1H4(1042),1,1,4)
call HGT_invQ_OLR(G1H4(1042),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1042),-4,0,G2H4(221),n2h4(484))
  call Hloop_AV_Q(ntryL,G2H4(221),ex3(:),G2H2(522),m3h2x2(:,652),heltab2x4(:,:,652))
  call Hloop_QV_A(ntryL,G1H4(1047),ex1(:),G1H2(131),m3h2x2(:,653),heltab2x4(:,:,653))
  call Hloop_Q_A(ntryL,G1H2(131),27,0,G2H2(523),n2h2(310))
  call Hloop_QV_A(ntryL,G1H4(1052),ex1(:),G1H2(131),m3h2x2(:,654),heltab2x4(:,:,654))
  call Hloop_Q_A(ntryL,G1H2(131),27,0,G2H2(524),n2h2(311))
call HGT_OLR(G1H4(1048),1,1,4)
call HGT_invQ_OLR(G1H4(1048),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1048),-4,0,G2H4(224),n2h4(485))
  call Hloop_AV_Q(ntryL,G2H4(224),ex3(:),G2H2(525),m3h2x2(:,655),heltab2x4(:,:,655))
  call Hloop_QV_A(ntryL,G1H4(1051),ex1(:),G1H2(131),m3h2x2(:,656),heltab2x4(:,:,656))
  call Hloop_Q_A(ntryL,G1H2(131),27,0,G2H2(526),n2h2(312))
  call Hloop_QV_A(ntryL,G0H4(131),ex1(:),G0H2(1),m3h2x2(:,657),heltab2x4(:,:,657))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(131),n2h2(313))
call HGT_OLR(G1H4(1053),1,1,4)
call HGT_invQ_OLR(G1H4(1053),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1053),-5,0,G2H4(225),n2h4(486))
  call Hloop_AV_Q(ntryL,G2H4(225),ex3(:),G2H2(527),m3h2x2(:,658),heltab2x4(:,:,658))
  call Hloop_QV_A(ntryL,G1H4(1056),ex1(:),G1H2(132),m3h2x2(:,659),heltab2x4(:,:,659))
  call Hloop_Q_A(ntryL,G1H2(132),27,0,G2H2(528),n2h2(314))
  call Hloop_QV_A(ntryL,G0H4(132),ex1(:),G0H2(1),m3h2x2(:,660),heltab2x4(:,:,660))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(132),n2h2(315))
  call Hloop_QV_A(ntryL,G1H4(1057),ex1(:),G1H2(133),m3h2x2(:,661),heltab2x4(:,:,661))
  call Hloop_Q_A(ntryL,G1H2(133),27,nMT,G2H2(529),n2h2(316))
call HGT_OLR(G1H4(1058),1,1,4)
call HGT_invQ_OLR(G1H4(1058),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1058),-4,nMT,G2H4(226),n2h4(487))
  call Hloop_AV_Q(ntryL,G2H4(226),ex3(:),G2H2(530),m3h2x2(:,662),heltab2x4(:,:,662))
  call Hloop_QV_A(ntryL,G1H4(1063),ex1(:),G1H2(133),m3h2x2(:,663),heltab2x4(:,:,663))
  call Hloop_Q_A(ntryL,G1H2(133),27,nMT,G2H2(531),n2h2(317))
  call Hloop_QV_A(ntryL,G1H4(1068),ex1(:),G1H2(133),m3h2x2(:,664),heltab2x4(:,:,664))
  call Hloop_Q_A(ntryL,G1H2(133),27,nMT,G2H2(532),n2h2(318))
call HGT_OLR(G1H4(1064),1,1,4)
call HGT_invQ_OLR(G1H4(1064),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1064),-4,nMT,G2H4(229),n2h4(488))
  call Hloop_AV_Q(ntryL,G2H4(229),ex3(:),G2H2(533),m3h2x2(:,665),heltab2x4(:,:,665))
  call Hloop_QV_A(ntryL,G1H4(1067),ex1(:),G1H2(133),m3h2x2(:,666),heltab2x4(:,:,666))
  call Hloop_Q_A(ntryL,G1H2(133),27,nMT,G2H2(534),n2h2(319))
  call Hloop_QV_A(ntryL,G0H4(133),ex1(:),G0H2(1),m3h2x2(:,667),heltab2x4(:,:,667))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(133),n2h2(320))
call HGT_OLR(G1H4(1069),1,1,4)
call HGT_invQ_OLR(G1H4(1069),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1069),-5,nMT,G2H4(230),n2h4(489))
  call Hloop_AV_Q(ntryL,G2H4(230),ex3(:),G2H2(535),m3h2x2(:,668),heltab2x4(:,:,668))
  call Hloop_QV_A(ntryL,G1H4(1072),ex1(:),G1H2(134),m3h2x2(:,669),heltab2x4(:,:,669))
  call Hloop_Q_A(ntryL,G1H2(134),27,nMT,G2H2(536),n2h2(321))
  call Hloop_QV_A(ntryL,G0H4(134),ex1(:),G0H2(1),m3h2x2(:,670),heltab2x4(:,:,670))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(134),n2h2(322))
  call Hloop_AV_Q(ntryL,G1H4(1073),ex1(:),G1H2(135),m3h2x2(:,671),heltab2x4(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(135),27,nMB,G2H2(537),n2h2(323))
call HGT_OLR(G1H4(1074),1,1,4)
call HGT_invQ_OLR(G1H4(1074),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1074),-4,nMB,G2H4(231),n2h4(490))
  call Hloop_QV_A(ntryL,G2H4(231),ex3(:),G2H2(538),m3h2x2(:,672),heltab2x4(:,:,672))
  call Hloop_AV_Q(ntryL,G1H4(1079),ex1(:),G1H2(135),m3h2x2(:,673),heltab2x4(:,:,673))
  call Hloop_A_Q(ntryL,G1H2(135),27,nMB,G2H2(539),n2h2(324))
  call Hloop_AV_Q(ntryL,G1H4(1084),ex1(:),G1H2(135),m3h2x2(:,674),heltab2x4(:,:,674))
  call Hloop_A_Q(ntryL,G1H2(135),27,nMB,G2H2(540),n2h2(325))
call HGT_OLR(G1H4(1080),1,1,4)
call HGT_invQ_OLR(G1H4(1080),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1080),-4,nMB,G2H4(234),n2h4(491))
  call Hloop_QV_A(ntryL,G2H4(234),ex3(:),G2H2(541),m3h2x2(:,675),heltab2x4(:,:,675))
  call Hloop_AV_Q(ntryL,G1H4(1083),ex1(:),G1H2(135),m3h2x2(:,676),heltab2x4(:,:,676))
  call Hloop_A_Q(ntryL,G1H2(135),27,nMB,G2H2(542),n2h2(326))
  call Hloop_AV_Q(ntryL,G0H4(135),ex1(:),G0H2(1),m3h2x2(:,677),heltab2x4(:,:,677))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(135),n2h2(327))
call HGT_OLR(G1H4(1085),1,1,4)
call HGT_invQ_OLR(G1H4(1085),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1085),-5,nMB,G2H4(235),n2h4(492))
  call Hloop_QV_A(ntryL,G2H4(235),ex3(:),G2H2(543),m3h2x2(:,678),heltab2x4(:,:,678))
  call Hloop_AV_Q(ntryL,G1H4(1088),ex1(:),G1H2(136),m3h2x2(:,679),heltab2x4(:,:,679))
  call Hloop_A_Q(ntryL,G1H2(136),27,nMB,G2H2(544),n2h2(328))
  call Hloop_AV_Q(ntryL,G0H4(136),ex1(:),G0H2(1),m3h2x2(:,680),heltab2x4(:,:,680))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(136),n2h2(329))
  call Hloop_QV_A(ntryL,G1H4(1089),ex1(:),G1H2(137),m3h2x2(:,681),heltab2x4(:,:,681))
  call Hloop_Q_A(ntryL,G1H2(137),27,nMB,G2H2(545),n2h2(330))
call HGT_OLR(G1H4(1090),1,1,4)
call HGT_invQ_OLR(G1H4(1090),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1090),-4,nMB,G2H4(236),n2h4(493))
  call Hloop_AV_Q(ntryL,G2H4(236),ex3(:),G2H2(546),m3h2x2(:,682),heltab2x4(:,:,682))
  call Hloop_QV_A(ntryL,G1H4(1095),ex1(:),G1H2(137),m3h2x2(:,683),heltab2x4(:,:,683))
  call Hloop_Q_A(ntryL,G1H2(137),27,nMB,G2H2(547),n2h2(331))
  call Hloop_QV_A(ntryL,G1H4(1100),ex1(:),G1H2(137),m3h2x2(:,684),heltab2x4(:,:,684))
  call Hloop_Q_A(ntryL,G1H2(137),27,nMB,G2H2(548),n2h2(332))
call HGT_OLR(G1H4(1096),1,1,4)
call HGT_invQ_OLR(G1H4(1096),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1096),-4,nMB,G2H4(239),n2h4(494))
  call Hloop_AV_Q(ntryL,G2H4(239),ex3(:),G2H2(549),m3h2x2(:,685),heltab2x4(:,:,685))
  call Hloop_QV_A(ntryL,G1H4(1099),ex1(:),G1H2(137),m3h2x2(:,686),heltab2x4(:,:,686))
  call Hloop_Q_A(ntryL,G1H2(137),27,nMB,G2H2(550),n2h2(333))
  call Hloop_QV_A(ntryL,G0H4(137),ex1(:),G0H2(1),m3h2x2(:,687),heltab2x4(:,:,687))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(137),n2h2(334))
call HGT_OLR(G1H4(1101),1,1,4)
call HGT_invQ_OLR(G1H4(1101),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1101),-5,nMB,G2H4(240),n2h4(495))
  call Hloop_AV_Q(ntryL,G2H4(240),ex3(:),G2H2(551),m3h2x2(:,688),heltab2x4(:,:,688))
  call Hloop_QV_A(ntryL,G1H4(1104),ex1(:),G1H2(138),m3h2x2(:,689),heltab2x4(:,:,689))
  call Hloop_Q_A(ntryL,G1H2(138),27,nMB,G2H2(552),n2h2(335))
  call Hloop_QV_A(ntryL,G0H4(138),ex1(:),G0H2(1),m3h2x2(:,690),heltab2x4(:,:,690))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(138),n2h2(336))
  call Hloop_DV_C(ntryL,G1H4(1105),26,ex1(:),G2H2(553),m3h2x2(:,691),heltab2x4(:,:,691))
call HGT_OLR(G1H4(1106),1,1,4)
call HGT_invQ_OLR(G1H4(1106),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1106),-4,ex3(:),4,G2H2(554),m3h2x2(:,692),heltab2x4(:,:,692))
  call Hloop_DV_C(ntryL,G1H4(1111),26,ex1(:),G2H2(555),m3h2x2(:,693),heltab2x4(:,:,693))
  call Hloop_DV_C(ntryL,G1H4(1116),26,ex1(:),G2H2(556),m3h2x2(:,694),heltab2x4(:,:,694))
call HGT_OLR(G1H4(1112),1,1,4)
call HGT_invQ_OLR(G1H4(1112),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1112),-4,ex3(:),4,G2H2(557),m3h2x2(:,695),heltab2x4(:,:,695))
  call Hloop_DV_C(ntryL,G1H4(1115),26,ex1(:),G2H2(558),m3h2x2(:,696),heltab2x4(:,:,696))
  call Hloop_DV_C(ntryL,G0H4(139),26,ex1(:),G1H2(139),m3h2x2(:,697),heltab2x4(:,:,697))
call HGT_OLR(G1H4(1117),1,1,4)
call HGT_invQ_OLR(G1H4(1117),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1117),-5,ex3(:),4,G2H2(559),m3h2x2(:,698),heltab2x4(:,:,698))
  call Hloop_DV_C(ntryL,G1H4(1120),26,ex1(:),G2H2(560),m3h2x2(:,699),heltab2x4(:,:,699))
  call Hloop_DV_C(ntryL,G0H4(140),26,ex1(:),G1H2(140),m3h2x2(:,700),heltab2x4(:,:,700))
  call Hloop_CV_D(ntryL,G1H4(1121),26,ex1(:),1,G2H2(561),m3h2x2(:,701),heltab2x4(:,:,701))
call HGT_OLR(G1H4(1122),1,1,4)
call HGT_invQ_OLR(G1H4(1122),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1122),-4,ex3(:),G2H2(562),m3h2x2(:,702),heltab2x4(:,:,702))
  call Hloop_CV_D(ntryL,G1H4(1127),26,ex1(:),1,G2H2(563),m3h2x2(:,703),heltab2x4(:,:,703))
  call Hloop_CV_D(ntryL,G1H4(1132),26,ex1(:),1,G2H2(564),m3h2x2(:,704),heltab2x4(:,:,704))
call HGT_OLR(G1H4(1128),1,1,4)
call HGT_invQ_OLR(G1H4(1128),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1128),-4,ex3(:),G2H2(565),m3h2x2(:,705),heltab2x4(:,:,705))
  call Hloop_CV_D(ntryL,G1H4(1131),26,ex1(:),1,G2H2(566),m3h2x2(:,706),heltab2x4(:,:,706))
  call Hloop_CV_D(ntryL,G0H4(141),26,ex1(:),1,G1H2(141),m3h2x2(:,707),heltab2x4(:,:,707))
call HGT_OLR(G1H4(1133),1,1,4)
call HGT_invQ_OLR(G1H4(1133),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1133),-5,ex3(:),G2H2(567),m3h2x2(:,708),heltab2x4(:,:,708))
  call Hloop_CV_D(ntryL,G1H4(1136),26,ex1(:),1,G2H2(568),m3h2x2(:,709),heltab2x4(:,:,709))
  call Hloop_CV_D(ntryL,G0H4(142),26,ex1(:),1,G1H2(142),m3h2x2(:,710),heltab2x4(:,:,710))
  call Hloop_UV_W(ntryL,G1H4(1137),26,ex1(:),1,G2H2(569),m3h2x2(:,711),heltab2x4(:,:,711))
call HGT_raise_alpha_OLR(G1H4(1138),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1138),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1138),-4,ex3(:),4,G2H2(570),m3h2x2(:,712),heltab2x4(:,:,712))
call signflip_OLR(G2H2(570))
  call Hloop_UV_W(ntryL,G1H4(1143),26,ex1(:),1,G2H2(571),m3h2x2(:,713),heltab2x4(:,:,713))
  call Hloop_UV_W(ntryL,G1H4(1148),26,ex1(:),1,G2H2(572),m3h2x2(:,714),heltab2x4(:,:,714))
call HGT_raise_alpha_OLR(G1H4(1144),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1144),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1144),-4,ex3(:),4,G2H2(573),m3h2x2(:,715),heltab2x4(:,:,715))
call signflip_OLR(G2H2(573))
  call Hloop_UV_W(ntryL,G1H4(1147),26,ex1(:),1,G2H2(574),m3h2x2(:,716),heltab2x4(:,:,716))
  call Hloop_UV_W(ntryL,G0H4(143),26,ex1(:),1,G1H2(143),m3h2x2(:,717),heltab2x4(:,:,717))
call HGT_raise_alpha_OLR(G1H4(1149),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1149),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1149),-5,ex3(:),4,G2H2(575),m3h2x2(:,718),heltab2x4(:,:,718))
call signflip_OLR(G2H2(575))
  call Hloop_UV_W(ntryL,G1H4(1152),26,ex1(:),1,G2H2(576),m3h2x2(:,719),heltab2x4(:,:,719))
  call Hloop_UV_W(ntryL,G0H4(144),26,ex1(:),1,G1H2(144),m3h2x2(:,720),heltab2x4(:,:,720))
  call Hloop_AV_Q(ntryL,G1H4(1153),ex2(:),G1H2(145),m3h2x2(:,721),heltab2x4(:,:,721))
  call Hloop_A_Q(ntryL,G1H2(145),23,0,G2H2(577),n2h2(337))
call HGT_OLR(G1H4(1154),1,1,4)
call HGT_invQ_OLR(G1H4(1154),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1154),-8,0,G2H4(241),n2h4(505))
  call Hloop_QV_A(ntryL,G2H4(241),ex4(:),G2H2(578),m3h2x2(:,722),heltab2x4(:,:,722))
  call Hloop_AV_Q(ntryL,G1H4(1159),ex2(:),G1H2(145),m3h2x2(:,723),heltab2x4(:,:,723))
  call Hloop_A_Q(ntryL,G1H2(145),23,0,G2H2(579),n2h2(338))
  call Hloop_AV_Q(ntryL,G1H4(1164),ex2(:),G1H2(145),m3h2x2(:,724),heltab2x4(:,:,724))
  call Hloop_A_Q(ntryL,G1H2(145),23,0,G2H2(580),n2h2(339))
call HGT_OLR(G1H4(1160),1,1,4)
call HGT_invQ_OLR(G1H4(1160),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1160),-8,0,G2H4(244),n2h4(506))
  call Hloop_QV_A(ntryL,G2H4(244),ex4(:),G2H2(581),m3h2x2(:,725),heltab2x4(:,:,725))
  call Hloop_AV_Q(ntryL,G1H4(1163),ex2(:),G1H2(145),m3h2x2(:,726),heltab2x4(:,:,726))
  call Hloop_A_Q(ntryL,G1H2(145),23,0,G2H2(582),n2h2(340))
  call Hloop_AV_Q(ntryL,G0H4(145),ex2(:),G0H2(1),m3h2x2(:,727),heltab2x4(:,:,727))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(145),n2h2(341))
call HGT_OLR(G1H4(1165),1,1,4)
call HGT_invQ_OLR(G1H4(1165),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1165),-10,0,G2H4(245),n2h4(507))
  call Hloop_QV_A(ntryL,G2H4(245),ex4(:),G2H2(583),m3h2x2(:,728),heltab2x4(:,:,728))
  call Hloop_AV_Q(ntryL,G1H4(1168),ex2(:),G1H2(146),m3h2x2(:,729),heltab2x4(:,:,729))
  call Hloop_A_Q(ntryL,G1H2(146),23,0,G2H2(584),n2h2(342))
  call Hloop_AV_Q(ntryL,G0H4(146),ex2(:),G0H2(1),m3h2x2(:,730),heltab2x4(:,:,730))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(146),n2h2(343))
  call Hloop_AV_Q(ntryL,G1H4(1169),ex2(:),G1H2(147),m3h2x2(:,731),heltab2x4(:,:,731))
  call Hloop_A_Q(ntryL,G1H2(147),23,nMT,G2H2(585),n2h2(344))
call HGT_OLR(G1H4(1170),1,1,4)
call HGT_invQ_OLR(G1H4(1170),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1170),-8,nMT,G2H4(246),n2h4(508))
  call Hloop_QV_A(ntryL,G2H4(246),ex4(:),G2H2(586),m3h2x2(:,732),heltab2x4(:,:,732))
  call Hloop_AV_Q(ntryL,G1H4(1175),ex2(:),G1H2(147),m3h2x2(:,733),heltab2x4(:,:,733))
  call Hloop_A_Q(ntryL,G1H2(147),23,nMT,G2H2(587),n2h2(345))
  call Hloop_AV_Q(ntryL,G1H4(1180),ex2(:),G1H2(147),m3h2x2(:,734),heltab2x4(:,:,734))
  call Hloop_A_Q(ntryL,G1H2(147),23,nMT,G2H2(588),n2h2(346))
call HGT_OLR(G1H4(1176),1,1,4)
call HGT_invQ_OLR(G1H4(1176),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1176),-8,nMT,G2H4(249),n2h4(509))
  call Hloop_QV_A(ntryL,G2H4(249),ex4(:),G2H2(589),m3h2x2(:,735),heltab2x4(:,:,735))
  call Hloop_AV_Q(ntryL,G1H4(1179),ex2(:),G1H2(147),m3h2x2(:,736),heltab2x4(:,:,736))
  call Hloop_A_Q(ntryL,G1H2(147),23,nMT,G2H2(590),n2h2(347))
  call Hloop_AV_Q(ntryL,G0H4(147),ex2(:),G0H2(1),m3h2x2(:,737),heltab2x4(:,:,737))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(147),n2h2(348))
call HGT_OLR(G1H4(1181),1,1,4)
call HGT_invQ_OLR(G1H4(1181),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1181),-10,nMT,G2H4(250),n2h4(510))
  call Hloop_QV_A(ntryL,G2H4(250),ex4(:),G2H2(591),m3h2x2(:,738),heltab2x4(:,:,738))
  call Hloop_AV_Q(ntryL,G1H4(1184),ex2(:),G1H2(148),m3h2x2(:,739),heltab2x4(:,:,739))
  call Hloop_A_Q(ntryL,G1H2(148),23,nMT,G2H2(592),n2h2(349))
  call Hloop_AV_Q(ntryL,G0H4(148),ex2(:),G0H2(1),m3h2x2(:,740),heltab2x4(:,:,740))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(148),n2h2(350))
  call Hloop_QV_A(ntryL,G1H4(1185),ex2(:),G1H2(149),m3h2x2(:,741),heltab2x4(:,:,741))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(593),n2h2(351))
call HGT_OLR(G1H4(1186),1,1,4)
call HGT_invQ_OLR(G1H4(1186),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1186),-8,0,G2H4(251),n2h4(511))
  call Hloop_AV_Q(ntryL,G2H4(251),ex4(:),G2H2(594),m3h2x2(:,742),heltab2x4(:,:,742))
  call Hloop_QV_A(ntryL,G1H4(1191),ex2(:),G1H2(149),m3h2x2(:,743),heltab2x4(:,:,743))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(595),n2h2(352))
  call Hloop_QV_A(ntryL,G1H4(1196),ex2(:),G1H2(149),m3h2x2(:,744),heltab2x4(:,:,744))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(596),n2h2(353))
call HGT_OLR(G1H4(1192),1,1,4)
call HGT_invQ_OLR(G1H4(1192),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1192),-8,0,G2H4(254),n2h4(512))
  call Hloop_AV_Q(ntryL,G2H4(254),ex4(:),G2H2(597),m3h2x2(:,745),heltab2x4(:,:,745))
  call Hloop_QV_A(ntryL,G1H4(1195),ex2(:),G1H2(149),m3h2x2(:,746),heltab2x4(:,:,746))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(598),n2h2(354))
  call Hloop_QV_A(ntryL,G0H4(149),ex2(:),G0H2(1),m3h2x2(:,747),heltab2x4(:,:,747))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(149),n2h2(355))
call HGT_OLR(G1H4(1197),1,1,4)
call HGT_invQ_OLR(G1H4(1197),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1197),-10,0,G2H4(255),n2h4(513))
  call Hloop_AV_Q(ntryL,G2H4(255),ex4(:),G2H2(599),m3h2x2(:,748),heltab2x4(:,:,748))
  call Hloop_QV_A(ntryL,G1H4(1200),ex2(:),G1H2(150),m3h2x2(:,749),heltab2x4(:,:,749))
  call Hloop_Q_A(ntryL,G1H2(150),23,0,G2H2(600),n2h2(356))
  call Hloop_QV_A(ntryL,G0H4(150),ex2(:),G0H2(1),m3h2x2(:,750),heltab2x4(:,:,750))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(150),n2h2(357))
  call Hloop_QV_A(ntryL,G1H4(1201),ex2(:),G1H2(151),m3h2x2(:,751),heltab2x4(:,:,751))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMT,G2H2(601),n2h2(358))
call HGT_OLR(G1H4(1202),1,1,4)
call HGT_invQ_OLR(G1H4(1202),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1202),-8,nMT,G2H4(256),n2h4(514))
  call Hloop_AV_Q(ntryL,G2H4(256),ex4(:),G2H2(602),m3h2x2(:,752),heltab2x4(:,:,752))
  call Hloop_QV_A(ntryL,G1H4(1207),ex2(:),G1H2(151),m3h2x2(:,753),heltab2x4(:,:,753))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMT,G2H2(603),n2h2(359))
  call Hloop_QV_A(ntryL,G1H4(1212),ex2(:),G1H2(151),m3h2x2(:,754),heltab2x4(:,:,754))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMT,G2H2(604),n2h2(360))
call HGT_OLR(G1H4(1208),1,1,4)
call HGT_invQ_OLR(G1H4(1208),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1208),-8,nMT,G2H4(259),n2h4(515))
  call Hloop_AV_Q(ntryL,G2H4(259),ex4(:),G2H2(605),m3h2x2(:,755),heltab2x4(:,:,755))
  call Hloop_QV_A(ntryL,G1H4(1211),ex2(:),G1H2(151),m3h2x2(:,756),heltab2x4(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMT,G2H2(606),n2h2(361))
  call Hloop_QV_A(ntryL,G0H4(151),ex2(:),G0H2(1),m3h2x2(:,757),heltab2x4(:,:,757))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(151),n2h2(362))
call HGT_OLR(G1H4(1213),1,1,4)
call HGT_invQ_OLR(G1H4(1213),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1213),-10,nMT,G2H4(260),n2h4(516))
  call Hloop_AV_Q(ntryL,G2H4(260),ex4(:),G2H2(607),m3h2x2(:,758),heltab2x4(:,:,758))
  call Hloop_QV_A(ntryL,G1H4(1216),ex2(:),G1H2(152),m3h2x2(:,759),heltab2x4(:,:,759))
  call Hloop_Q_A(ntryL,G1H2(152),23,nMT,G2H2(608),n2h2(363))
  call Hloop_QV_A(ntryL,G0H4(152),ex2(:),G0H2(1),m3h2x2(:,760),heltab2x4(:,:,760))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(152),n2h2(364))
  call Hloop_AV_Q(ntryL,G1H4(1217),ex2(:),G1H2(153),m3h2x2(:,761),heltab2x4(:,:,761))
  call Hloop_A_Q(ntryL,G1H2(153),23,nMB,G2H2(609),n2h2(365))
call HGT_OLR(G1H4(1218),1,1,4)
call HGT_invQ_OLR(G1H4(1218),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1218),-8,nMB,G2H4(261),n2h4(517))
  call Hloop_QV_A(ntryL,G2H4(261),ex4(:),G2H2(610),m3h2x2(:,762),heltab2x4(:,:,762))
  call Hloop_AV_Q(ntryL,G1H4(1223),ex2(:),G1H2(153),m3h2x2(:,763),heltab2x4(:,:,763))
  call Hloop_A_Q(ntryL,G1H2(153),23,nMB,G2H2(611),n2h2(366))
  call Hloop_AV_Q(ntryL,G1H4(1228),ex2(:),G1H2(153),m3h2x2(:,764),heltab2x4(:,:,764))
  call Hloop_A_Q(ntryL,G1H2(153),23,nMB,G2H2(612),n2h2(367))
call HGT_OLR(G1H4(1224),1,1,4)
call HGT_invQ_OLR(G1H4(1224),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1224),-8,nMB,G2H4(264),n2h4(518))
  call Hloop_QV_A(ntryL,G2H4(264),ex4(:),G2H2(613),m3h2x2(:,765),heltab2x4(:,:,765))
  call Hloop_AV_Q(ntryL,G1H4(1227),ex2(:),G1H2(153),m3h2x2(:,766),heltab2x4(:,:,766))
  call Hloop_A_Q(ntryL,G1H2(153),23,nMB,G2H2(614),n2h2(368))
  call Hloop_AV_Q(ntryL,G0H4(153),ex2(:),G0H2(1),m3h2x2(:,767),heltab2x4(:,:,767))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(153),n2h2(369))
call HGT_OLR(G1H4(1229),1,1,4)
call HGT_invQ_OLR(G1H4(1229),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1229),-10,nMB,G2H4(265),n2h4(519))
  call Hloop_QV_A(ntryL,G2H4(265),ex4(:),G2H2(615),m3h2x2(:,768),heltab2x4(:,:,768))
  call Hloop_AV_Q(ntryL,G1H4(1232),ex2(:),G1H2(154),m3h2x2(:,769),heltab2x4(:,:,769))
  call Hloop_A_Q(ntryL,G1H2(154),23,nMB,G2H2(616),n2h2(370))
  call Hloop_AV_Q(ntryL,G0H4(154),ex2(:),G0H2(1),m3h2x2(:,770),heltab2x4(:,:,770))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(154),n2h2(371))
  call Hloop_QV_A(ntryL,G1H4(1233),ex2(:),G1H2(155),m3h2x2(:,771),heltab2x4(:,:,771))
  call Hloop_Q_A(ntryL,G1H2(155),23,nMB,G2H2(617),n2h2(372))
call HGT_OLR(G1H4(1234),1,1,4)
call HGT_invQ_OLR(G1H4(1234),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1234),-8,nMB,G2H4(266),n2h4(520))
  call Hloop_AV_Q(ntryL,G2H4(266),ex4(:),G2H2(618),m3h2x2(:,772),heltab2x4(:,:,772))
  call Hloop_QV_A(ntryL,G1H4(1239),ex2(:),G1H2(155),m3h2x2(:,773),heltab2x4(:,:,773))
  call Hloop_Q_A(ntryL,G1H2(155),23,nMB,G2H2(619),n2h2(373))
  call Hloop_QV_A(ntryL,G1H4(1244),ex2(:),G1H2(155),m3h2x2(:,774),heltab2x4(:,:,774))
  call Hloop_Q_A(ntryL,G1H2(155),23,nMB,G2H2(620),n2h2(374))
call HGT_OLR(G1H4(1240),1,1,4)
call HGT_invQ_OLR(G1H4(1240),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1240),-8,nMB,G2H4(269),n2h4(521))
  call Hloop_AV_Q(ntryL,G2H4(269),ex4(:),G2H2(621),m3h2x2(:,775),heltab2x4(:,:,775))
  call Hloop_QV_A(ntryL,G1H4(1243),ex2(:),G1H2(155),m3h2x2(:,776),heltab2x4(:,:,776))
  call Hloop_Q_A(ntryL,G1H2(155),23,nMB,G2H2(622),n2h2(375))
  call Hloop_QV_A(ntryL,G0H4(155),ex2(:),G0H2(1),m3h2x2(:,777),heltab2x4(:,:,777))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(155),n2h2(376))
call HGT_OLR(G1H4(1245),1,1,4)
call HGT_invQ_OLR(G1H4(1245),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1245),-10,nMB,G2H4(270),n2h4(522))
  call Hloop_AV_Q(ntryL,G2H4(270),ex4(:),G2H2(623),m3h2x2(:,778),heltab2x4(:,:,778))
  call Hloop_QV_A(ntryL,G1H4(1248),ex2(:),G1H2(156),m3h2x2(:,779),heltab2x4(:,:,779))
  call Hloop_Q_A(ntryL,G1H2(156),23,nMB,G2H2(624),n2h2(377))
  call Hloop_QV_A(ntryL,G0H4(156),ex2(:),G0H2(1),m3h2x2(:,780),heltab2x4(:,:,780))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(156),n2h2(378))
  call Hloop_DV_C(ntryL,G1H4(1249),21,ex2(:),G2H2(625),m3h2x2(:,781),heltab2x4(:,:,781))
call HGT_OLR(G1H4(1250),1,1,4)
call HGT_invQ_OLR(G1H4(1250),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1250),-8,ex4(:),8,G2H2(626),m3h2x2(:,782),heltab2x4(:,:,782))
  call Hloop_DV_C(ntryL,G1H4(1255),21,ex2(:),G2H2(627),m3h2x2(:,783),heltab2x4(:,:,783))
  call Hloop_DV_C(ntryL,G1H4(1260),21,ex2(:),G2H2(628),m3h2x2(:,784),heltab2x4(:,:,784))
call HGT_OLR(G1H4(1256),1,1,4)
call HGT_invQ_OLR(G1H4(1256),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1256),-8,ex4(:),8,G2H2(629),m3h2x2(:,785),heltab2x4(:,:,785))
  call Hloop_DV_C(ntryL,G1H4(1259),21,ex2(:),G2H2(630),m3h2x2(:,786),heltab2x4(:,:,786))
  call Hloop_DV_C(ntryL,G0H4(157),21,ex2(:),G1H2(157),m3h2x2(:,787),heltab2x4(:,:,787))
call HGT_OLR(G1H4(1261),1,1,4)
call HGT_invQ_OLR(G1H4(1261),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1261),-10,ex4(:),8,G2H2(631),m3h2x2(:,788),heltab2x4(:,:,788))
  call Hloop_DV_C(ntryL,G1H4(1264),21,ex2(:),G2H2(632),m3h2x2(:,789),heltab2x4(:,:,789))
  call Hloop_DV_C(ntryL,G0H4(158),21,ex2(:),G1H2(158),m3h2x2(:,790),heltab2x4(:,:,790))
  call Hloop_CV_D(ntryL,G1H4(1265),21,ex2(:),2,G2H2(633),m3h2x2(:,791),heltab2x4(:,:,791))
call HGT_OLR(G1H4(1266),1,1,4)
call HGT_invQ_OLR(G1H4(1266),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1266),-8,ex4(:),G2H2(634),m3h2x2(:,792),heltab2x4(:,:,792))
  call Hloop_CV_D(ntryL,G1H4(1271),21,ex2(:),2,G2H2(635),m3h2x2(:,793),heltab2x4(:,:,793))
  call Hloop_CV_D(ntryL,G1H4(1276),21,ex2(:),2,G2H2(636),m3h2x2(:,794),heltab2x4(:,:,794))
call HGT_OLR(G1H4(1272),1,1,4)
call HGT_invQ_OLR(G1H4(1272),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1272),-8,ex4(:),G2H2(637),m3h2x2(:,795),heltab2x4(:,:,795))
  call Hloop_CV_D(ntryL,G1H4(1275),21,ex2(:),2,G2H2(638),m3h2x2(:,796),heltab2x4(:,:,796))
  call Hloop_CV_D(ntryL,G0H4(159),21,ex2(:),2,G1H2(159),m3h2x2(:,797),heltab2x4(:,:,797))
call HGT_OLR(G1H4(1277),1,1,4)
call HGT_invQ_OLR(G1H4(1277),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1277),-10,ex4(:),G2H2(639),m3h2x2(:,798),heltab2x4(:,:,798))
  call Hloop_CV_D(ntryL,G1H4(1280),21,ex2(:),2,G2H2(640),m3h2x2(:,799),heltab2x4(:,:,799))
  call Hloop_CV_D(ntryL,G0H4(160),21,ex2(:),2,G1H2(160),m3h2x2(:,800),heltab2x4(:,:,800))
  call Hloop_UV_W(ntryL,G1H4(1281),21,ex2(:),2,G2H2(641),m3h2x2(:,801),heltab2x4(:,:,801))
call HGT_raise_alpha_OLR(G1H4(1282),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1282),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1282),-8,ex4(:),8,G2H2(642),m3h2x2(:,802),heltab2x4(:,:,802))
call signflip_OLR(G2H2(642))
  call Hloop_UV_W(ntryL,G1H4(1287),21,ex2(:),2,G2H2(643),m3h2x2(:,803),heltab2x4(:,:,803))
  call Hloop_UV_W(ntryL,G1H4(1292),21,ex2(:),2,G2H2(644),m3h2x2(:,804),heltab2x4(:,:,804))
call HGT_raise_alpha_OLR(G1H4(1288),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1288),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1288),-8,ex4(:),8,G2H2(645),m3h2x2(:,805),heltab2x4(:,:,805))
call signflip_OLR(G2H2(645))
  call Hloop_UV_W(ntryL,G1H4(1291),21,ex2(:),2,G2H2(646),m3h2x2(:,806),heltab2x4(:,:,806))
  call Hloop_UV_W(ntryL,G0H4(161),21,ex2(:),2,G1H2(161),m3h2x2(:,807),heltab2x4(:,:,807))
call HGT_raise_alpha_OLR(G1H4(1293),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1293),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1293),-10,ex4(:),8,G2H2(647),m3h2x2(:,808),heltab2x4(:,:,808))
call signflip_OLR(G2H2(647))
  call Hloop_UV_W(ntryL,G1H4(1296),21,ex2(:),2,G2H2(648),m3h2x2(:,809),heltab2x4(:,:,809))
  call Hloop_UV_W(ntryL,G0H4(162),21,ex2(:),2,G1H2(162),m3h2x2(:,810),heltab2x4(:,:,810))
  call Hloop_AV_Q(ntryL,G1H4(1297),ex4(:),G1H2(163),m3h2x2(:,811),heltab2x4(:,:,811))
  call Hloop_A_Q(ntryL,G1H2(163),29,0,G2H2(649),n2h2(379))
call HGT_OLR(G1H4(1298),1,1,4)
call HGT_invQ_OLR(G1H4(1298),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1298),-2,0,G2H4(271),n2h4(532))
  call Hloop_QV_A(ntryL,G2H4(271),ex2(:),G2H2(650),m3h2x2(:,812),heltab2x4(:,:,812))
  call Hloop_AV_Q(ntryL,G1H4(1303),ex4(:),G1H2(163),m3h2x2(:,813),heltab2x4(:,:,813))
  call Hloop_A_Q(ntryL,G1H2(163),29,0,G2H2(651),n2h2(380))
  call Hloop_AV_Q(ntryL,G1H4(1308),ex4(:),G1H2(163),m3h2x2(:,814),heltab2x4(:,:,814))
  call Hloop_A_Q(ntryL,G1H2(163),29,0,G2H2(652),n2h2(381))
call HGT_OLR(G1H4(1304),1,1,4)
call HGT_invQ_OLR(G1H4(1304),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1304),-2,0,G2H4(274),n2h4(533))
  call Hloop_QV_A(ntryL,G2H4(274),ex2(:),G2H2(653),m3h2x2(:,815),heltab2x4(:,:,815))
  call Hloop_AV_Q(ntryL,G1H4(1307),ex4(:),G1H2(163),m3h2x2(:,816),heltab2x4(:,:,816))
  call Hloop_A_Q(ntryL,G1H2(163),29,0,G2H2(654),n2h2(382))
  call Hloop_AV_Q(ntryL,G0H4(163),ex4(:),G0H2(1),m3h2x2(:,817),heltab2x4(:,:,817))
  call Hloop_A_Q(ntryL,G0H2(1),29,0,G1H2(163),n2h2(383))
call HGT_OLR(G1H4(1309),1,1,4)
call HGT_invQ_OLR(G1H4(1309),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1309),-10,0,G2H4(275),n2h4(534))
  call Hloop_QV_A(ntryL,G2H4(275),ex2(:),G2H2(655),m3h2x2(:,818),heltab2x4(:,:,818))
  call Hloop_AV_Q(ntryL,G1H4(1312),ex4(:),G1H2(164),m3h2x2(:,819),heltab2x4(:,:,819))
  call Hloop_A_Q(ntryL,G1H2(164),29,0,G2H2(656),n2h2(384))
  call Hloop_AV_Q(ntryL,G0H4(164),ex4(:),G0H2(1),m3h2x2(:,820),heltab2x4(:,:,820))
  call Hloop_A_Q(ntryL,G0H2(1),29,0,G1H2(164),n2h2(385))
  call Hloop_AV_Q(ntryL,G1H4(1313),ex4(:),G1H2(165),m3h2x2(:,821),heltab2x4(:,:,821))
  call Hloop_A_Q(ntryL,G1H2(165),29,nMT,G2H2(657),n2h2(386))
call HGT_OLR(G1H4(1314),1,1,4)
call HGT_invQ_OLR(G1H4(1314),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1314),-2,nMT,G2H4(276),n2h4(535))
  call Hloop_QV_A(ntryL,G2H4(276),ex2(:),G2H2(658),m3h2x2(:,822),heltab2x4(:,:,822))
  call Hloop_AV_Q(ntryL,G1H4(1319),ex4(:),G1H2(165),m3h2x2(:,823),heltab2x4(:,:,823))
  call Hloop_A_Q(ntryL,G1H2(165),29,nMT,G2H2(659),n2h2(387))
  call Hloop_AV_Q(ntryL,G1H4(1324),ex4(:),G1H2(165),m3h2x2(:,824),heltab2x4(:,:,824))
  call Hloop_A_Q(ntryL,G1H2(165),29,nMT,G2H2(660),n2h2(388))
call HGT_OLR(G1H4(1320),1,1,4)
call HGT_invQ_OLR(G1H4(1320),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1320),-2,nMT,G2H4(279),n2h4(536))
  call Hloop_QV_A(ntryL,G2H4(279),ex2(:),G2H2(661),m3h2x2(:,825),heltab2x4(:,:,825))
  call Hloop_AV_Q(ntryL,G1H4(1323),ex4(:),G1H2(165),m3h2x2(:,826),heltab2x4(:,:,826))
  call Hloop_A_Q(ntryL,G1H2(165),29,nMT,G2H2(662),n2h2(389))
  call Hloop_AV_Q(ntryL,G0H4(165),ex4(:),G0H2(1),m3h2x2(:,827),heltab2x4(:,:,827))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMT,G1H2(165),n2h2(390))
call HGT_OLR(G1H4(1325),1,1,4)
call HGT_invQ_OLR(G1H4(1325),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1325),-10,nMT,G2H4(280),n2h4(537))
  call Hloop_QV_A(ntryL,G2H4(280),ex2(:),G2H2(663),m3h2x2(:,828),heltab2x4(:,:,828))
  call Hloop_AV_Q(ntryL,G1H4(1328),ex4(:),G1H2(166),m3h2x2(:,829),heltab2x4(:,:,829))
  call Hloop_A_Q(ntryL,G1H2(166),29,nMT,G2H2(664),n2h2(391))
  call Hloop_AV_Q(ntryL,G0H4(166),ex4(:),G0H2(1),m3h2x2(:,830),heltab2x4(:,:,830))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMT,G1H2(166),n2h2(392))
  call Hloop_QV_A(ntryL,G1H4(1329),ex4(:),G1H2(167),m3h2x2(:,831),heltab2x4(:,:,831))
  call Hloop_Q_A(ntryL,G1H2(167),29,0,G2H2(665),n2h2(393))
call HGT_OLR(G1H4(1330),1,1,4)
call HGT_invQ_OLR(G1H4(1330),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1330),-2,0,G2H4(281),n2h4(538))
  call Hloop_AV_Q(ntryL,G2H4(281),ex2(:),G2H2(666),m3h2x2(:,832),heltab2x4(:,:,832))
  call Hloop_QV_A(ntryL,G1H4(1335),ex4(:),G1H2(167),m3h2x2(:,833),heltab2x4(:,:,833))
  call Hloop_Q_A(ntryL,G1H2(167),29,0,G2H2(667),n2h2(394))
  call Hloop_QV_A(ntryL,G1H4(1340),ex4(:),G1H2(167),m3h2x2(:,834),heltab2x4(:,:,834))
  call Hloop_Q_A(ntryL,G1H2(167),29,0,G2H2(668),n2h2(395))
call HGT_OLR(G1H4(1336),1,1,4)
call HGT_invQ_OLR(G1H4(1336),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1336),-2,0,G2H4(284),n2h4(539))
  call Hloop_AV_Q(ntryL,G2H4(284),ex2(:),G2H2(669),m3h2x2(:,835),heltab2x4(:,:,835))
  call Hloop_QV_A(ntryL,G1H4(1339),ex4(:),G1H2(167),m3h2x2(:,836),heltab2x4(:,:,836))
  call Hloop_Q_A(ntryL,G1H2(167),29,0,G2H2(670),n2h2(396))
  call Hloop_QV_A(ntryL,G0H4(167),ex4(:),G0H2(1),m3h2x2(:,837),heltab2x4(:,:,837))
  call Hloop_Q_A(ntryL,G0H2(1),29,0,G1H2(167),n2h2(397))
call HGT_OLR(G1H4(1341),1,1,4)
call HGT_invQ_OLR(G1H4(1341),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1341),-10,0,G2H4(285),n2h4(540))
  call Hloop_AV_Q(ntryL,G2H4(285),ex2(:),G2H2(671),m3h2x2(:,838),heltab2x4(:,:,838))
  call Hloop_QV_A(ntryL,G1H4(1344),ex4(:),G1H2(168),m3h2x2(:,839),heltab2x4(:,:,839))
  call Hloop_Q_A(ntryL,G1H2(168),29,0,G2H2(672),n2h2(398))
  call Hloop_QV_A(ntryL,G0H4(168),ex4(:),G0H2(1),m3h2x2(:,840),heltab2x4(:,:,840))
  call Hloop_Q_A(ntryL,G0H2(1),29,0,G1H2(168),n2h2(399))
  call Hloop_QV_A(ntryL,G1H4(1345),ex4(:),G1H2(169),m3h2x2(:,841),heltab2x4(:,:,841))
  call Hloop_Q_A(ntryL,G1H2(169),29,nMT,G2H2(673),n2h2(400))
call HGT_OLR(G1H4(1346),1,1,4)
call HGT_invQ_OLR(G1H4(1346),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1346),-2,nMT,G2H4(286),n2h4(541))
  call Hloop_AV_Q(ntryL,G2H4(286),ex2(:),G2H2(674),m3h2x2(:,842),heltab2x4(:,:,842))
  call Hloop_QV_A(ntryL,G1H4(1351),ex4(:),G1H2(169),m3h2x2(:,843),heltab2x4(:,:,843))
  call Hloop_Q_A(ntryL,G1H2(169),29,nMT,G2H2(675),n2h2(401))
  call Hloop_QV_A(ntryL,G1H4(1356),ex4(:),G1H2(169),m3h2x2(:,844),heltab2x4(:,:,844))
  call Hloop_Q_A(ntryL,G1H2(169),29,nMT,G2H2(676),n2h2(402))
call HGT_OLR(G1H4(1352),1,1,4)
call HGT_invQ_OLR(G1H4(1352),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1352),-2,nMT,G2H4(289),n2h4(542))
  call Hloop_AV_Q(ntryL,G2H4(289),ex2(:),G2H2(677),m3h2x2(:,845),heltab2x4(:,:,845))
  call Hloop_QV_A(ntryL,G1H4(1355),ex4(:),G1H2(169),m3h2x2(:,846),heltab2x4(:,:,846))
  call Hloop_Q_A(ntryL,G1H2(169),29,nMT,G2H2(678),n2h2(403))
  call Hloop_QV_A(ntryL,G0H4(169),ex4(:),G0H2(1),m3h2x2(:,847),heltab2x4(:,:,847))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMT,G1H2(169),n2h2(404))
call HGT_OLR(G1H4(1357),1,1,4)
call HGT_invQ_OLR(G1H4(1357),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1357),-10,nMT,G2H4(290),n2h4(543))
  call Hloop_AV_Q(ntryL,G2H4(290),ex2(:),G2H2(679),m3h2x2(:,848),heltab2x4(:,:,848))
  call Hloop_QV_A(ntryL,G1H4(1360),ex4(:),G1H2(170),m3h2x2(:,849),heltab2x4(:,:,849))
  call Hloop_Q_A(ntryL,G1H2(170),29,nMT,G2H2(680),n2h2(405))
  call Hloop_QV_A(ntryL,G0H4(170),ex4(:),G0H2(1),m3h2x2(:,850),heltab2x4(:,:,850))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMT,G1H2(170),n2h2(406))
  call Hloop_AV_Q(ntryL,G1H4(1361),ex4(:),G1H2(171),m3h2x2(:,851),heltab2x4(:,:,851))
  call Hloop_A_Q(ntryL,G1H2(171),29,nMB,G2H2(681),n2h2(407))
call HGT_OLR(G1H4(1362),1,1,4)
call HGT_invQ_OLR(G1H4(1362),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1362),-2,nMB,G2H4(291),n2h4(544))
  call Hloop_QV_A(ntryL,G2H4(291),ex2(:),G2H2(682),m3h2x2(:,852),heltab2x4(:,:,852))
  call Hloop_AV_Q(ntryL,G1H4(1367),ex4(:),G1H2(171),m3h2x2(:,853),heltab2x4(:,:,853))
  call Hloop_A_Q(ntryL,G1H2(171),29,nMB,G2H2(683),n2h2(408))
  call Hloop_AV_Q(ntryL,G1H4(1372),ex4(:),G1H2(171),m3h2x2(:,854),heltab2x4(:,:,854))
  call Hloop_A_Q(ntryL,G1H2(171),29,nMB,G2H2(684),n2h2(409))
call HGT_OLR(G1H4(1368),1,1,4)
call HGT_invQ_OLR(G1H4(1368),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1368),-2,nMB,G2H4(294),n2h4(545))
  call Hloop_QV_A(ntryL,G2H4(294),ex2(:),G2H2(685),m3h2x2(:,855),heltab2x4(:,:,855))
  call Hloop_AV_Q(ntryL,G1H4(1371),ex4(:),G1H2(171),m3h2x2(:,856),heltab2x4(:,:,856))
  call Hloop_A_Q(ntryL,G1H2(171),29,nMB,G2H2(686),n2h2(410))
  call Hloop_AV_Q(ntryL,G0H4(171),ex4(:),G0H2(1),m3h2x2(:,857),heltab2x4(:,:,857))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMB,G1H2(171),n2h2(411))
call HGT_OLR(G1H4(1373),1,1,4)
call HGT_invQ_OLR(G1H4(1373),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1373),-10,nMB,G2H4(295),n2h4(546))
  call Hloop_QV_A(ntryL,G2H4(295),ex2(:),G2H2(687),m3h2x2(:,858),heltab2x4(:,:,858))
  call Hloop_AV_Q(ntryL,G1H4(1376),ex4(:),G1H2(172),m3h2x2(:,859),heltab2x4(:,:,859))
  call Hloop_A_Q(ntryL,G1H2(172),29,nMB,G2H2(688),n2h2(412))
  call Hloop_AV_Q(ntryL,G0H4(172),ex4(:),G0H2(1),m3h2x2(:,860),heltab2x4(:,:,860))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMB,G1H2(172),n2h2(413))
  call Hloop_QV_A(ntryL,G1H4(1377),ex4(:),G1H2(173),m3h2x2(:,861),heltab2x4(:,:,861))
  call Hloop_Q_A(ntryL,G1H2(173),29,nMB,G2H2(689),n2h2(414))
call HGT_OLR(G1H4(1378),1,1,4)
call HGT_invQ_OLR(G1H4(1378),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1378),-2,nMB,G2H4(296),n2h4(547))
  call Hloop_AV_Q(ntryL,G2H4(296),ex2(:),G2H2(690),m3h2x2(:,862),heltab2x4(:,:,862))
  call Hloop_QV_A(ntryL,G1H4(1383),ex4(:),G1H2(173),m3h2x2(:,863),heltab2x4(:,:,863))
  call Hloop_Q_A(ntryL,G1H2(173),29,nMB,G2H2(691),n2h2(415))
  call Hloop_QV_A(ntryL,G1H4(1388),ex4(:),G1H2(173),m3h2x2(:,864),heltab2x4(:,:,864))
  call Hloop_Q_A(ntryL,G1H2(173),29,nMB,G2H2(692),n2h2(416))
call HGT_OLR(G1H4(1384),1,1,4)
call HGT_invQ_OLR(G1H4(1384),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1384),-2,nMB,G2H4(299),n2h4(548))
  call Hloop_AV_Q(ntryL,G2H4(299),ex2(:),G2H2(693),m3h2x2(:,865),heltab2x4(:,:,865))
  call Hloop_QV_A(ntryL,G1H4(1387),ex4(:),G1H2(173),m3h2x2(:,866),heltab2x4(:,:,866))
  call Hloop_Q_A(ntryL,G1H2(173),29,nMB,G2H2(694),n2h2(417))
  call Hloop_QV_A(ntryL,G0H4(173),ex4(:),G0H2(1),m3h2x2(:,867),heltab2x4(:,:,867))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMB,G1H2(173),n2h2(418))
call HGT_OLR(G1H4(1389),1,1,4)
call HGT_invQ_OLR(G1H4(1389),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1389),-10,nMB,G2H4(300),n2h4(549))
  call Hloop_AV_Q(ntryL,G2H4(300),ex2(:),G2H2(695),m3h2x2(:,868),heltab2x4(:,:,868))
  call Hloop_QV_A(ntryL,G1H4(1392),ex4(:),G1H2(174),m3h2x2(:,869),heltab2x4(:,:,869))
  call Hloop_Q_A(ntryL,G1H2(174),29,nMB,G2H2(696),n2h2(419))
  call Hloop_QV_A(ntryL,G0H4(174),ex4(:),G0H2(1),m3h2x2(:,870),heltab2x4(:,:,870))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMB,G1H2(174),n2h2(420))
  call Hloop_DV_C(ntryL,G1H4(1393),21,ex4(:),G2H2(697),m3h2x2(:,871),heltab2x4(:,:,871))
call HGT_OLR(G1H4(1394),1,1,4)
call HGT_invQ_OLR(G1H4(1394),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1394),-2,ex2(:),2,G2H2(698),m3h2x2(:,872),heltab2x4(:,:,872))
  call Hloop_DV_C(ntryL,G1H4(1399),21,ex4(:),G2H2(699),m3h2x2(:,873),heltab2x4(:,:,873))
  call Hloop_DV_C(ntryL,G1H4(1404),21,ex4(:),G2H2(700),m3h2x2(:,874),heltab2x4(:,:,874))
call HGT_OLR(G1H4(1400),1,1,4)
call HGT_invQ_OLR(G1H4(1400),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1400),-2,ex2(:),2,G2H2(701),m3h2x2(:,875),heltab2x4(:,:,875))
  call Hloop_DV_C(ntryL,G1H4(1403),21,ex4(:),G2H2(702),m3h2x2(:,876),heltab2x4(:,:,876))
  call Hloop_DV_C(ntryL,G0H4(175),21,ex4(:),G1H2(175),m3h2x2(:,877),heltab2x4(:,:,877))
call HGT_OLR(G1H4(1405),1,1,4)
call HGT_invQ_OLR(G1H4(1405),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1405),-10,ex2(:),2,G2H2(703),m3h2x2(:,878),heltab2x4(:,:,878))
  call Hloop_DV_C(ntryL,G1H4(1408),21,ex4(:),G2H2(704),m3h2x2(:,879),heltab2x4(:,:,879))
  call Hloop_DV_C(ntryL,G0H4(176),21,ex4(:),G1H2(176),m3h2x2(:,880),heltab2x4(:,:,880))
  call Hloop_CV_D(ntryL,G1H4(1409),21,ex4(:),8,G2H2(705),m3h2x2(:,881),heltab2x4(:,:,881))
call HGT_OLR(G1H4(1410),1,1,4)
call HGT_invQ_OLR(G1H4(1410),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1410),-2,ex2(:),G2H2(706),m3h2x2(:,882),heltab2x4(:,:,882))
  call Hloop_CV_D(ntryL,G1H4(1415),21,ex4(:),8,G2H2(707),m3h2x2(:,883),heltab2x4(:,:,883))
  call Hloop_CV_D(ntryL,G1H4(1420),21,ex4(:),8,G2H2(708),m3h2x2(:,884),heltab2x4(:,:,884))
call HGT_OLR(G1H4(1416),1,1,4)
call HGT_invQ_OLR(G1H4(1416),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1416),-2,ex2(:),G2H2(709),m3h2x2(:,885),heltab2x4(:,:,885))
  call Hloop_CV_D(ntryL,G1H4(1419),21,ex4(:),8,G2H2(710),m3h2x2(:,886),heltab2x4(:,:,886))
  call Hloop_CV_D(ntryL,G0H4(177),21,ex4(:),8,G1H2(177),m3h2x2(:,887),heltab2x4(:,:,887))
call HGT_OLR(G1H4(1421),1,1,4)
call HGT_invQ_OLR(G1H4(1421),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1421),-10,ex2(:),G2H2(711),m3h2x2(:,888),heltab2x4(:,:,888))
  call Hloop_CV_D(ntryL,G1H4(1424),21,ex4(:),8,G2H2(712),m3h2x2(:,889),heltab2x4(:,:,889))
  call Hloop_CV_D(ntryL,G0H4(178),21,ex4(:),8,G1H2(178),m3h2x2(:,890),heltab2x4(:,:,890))
  call Hloop_UV_W(ntryL,G1H4(1425),21,ex4(:),8,G2H2(713),m3h2x2(:,891),heltab2x4(:,:,891))
call HGT_raise_alpha_OLR(G1H4(1426),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1426),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1426),-2,ex2(:),2,G2H2(714),m3h2x2(:,892),heltab2x4(:,:,892))
call signflip_OLR(G2H2(714))
  call Hloop_UV_W(ntryL,G1H4(1431),21,ex4(:),8,G2H2(715),m3h2x2(:,893),heltab2x4(:,:,893))
  call Hloop_UV_W(ntryL,G1H4(1436),21,ex4(:),8,G2H2(716),m3h2x2(:,894),heltab2x4(:,:,894))
call HGT_raise_alpha_OLR(G1H4(1432),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1432),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1432),-2,ex2(:),2,G2H2(717),m3h2x2(:,895),heltab2x4(:,:,895))
call signflip_OLR(G2H2(717))
  call Hloop_UV_W(ntryL,G1H4(1435),21,ex4(:),8,G2H2(718),m3h2x2(:,896),heltab2x4(:,:,896))
  call Hloop_UV_W(ntryL,G0H4(179),21,ex4(:),8,G1H2(179),m3h2x2(:,897),heltab2x4(:,:,897))
call HGT_raise_alpha_OLR(G1H4(1437),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1437),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1437),-10,ex2(:),2,G2H2(719),m3h2x2(:,898),heltab2x4(:,:,898))
call signflip_OLR(G2H2(719))
  call Hloop_UV_W(ntryL,G1H4(1440),21,ex4(:),8,G2H2(720),m3h2x2(:,899),heltab2x4(:,:,899))
  call Hloop_UV_W(ntryL,G0H4(180),21,ex4(:),8,G1H2(180),m3h2x2(:,900),heltab2x4(:,:,900))
  call Hloop_AV_Q(ntryL,G1H4(1441),ex2(:),G1H2(181),m3h2x2(:,901),heltab2x4(:,:,901))
  call Hloop_A_Q(ntryL,G1H2(181),27,0,G2H2(721),n2h2(421))
call HGT_OLR(G1H4(1442),1,1,4)
call HGT_invQ_OLR(G1H4(1442),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1442),-4,0,G2H4(301),n2h4(559))
  call Hloop_QV_A(ntryL,G2H4(301),ex3(:),G2H2(722),m3h2x2(:,902),heltab2x4(:,:,902))
  call Hloop_AV_Q(ntryL,G1H4(1447),ex2(:),G1H2(181),m3h2x2(:,903),heltab2x4(:,:,903))
  call Hloop_A_Q(ntryL,G1H2(181),27,0,G2H2(723),n2h2(422))
  call Hloop_AV_Q(ntryL,G1H4(1452),ex2(:),G1H2(181),m3h2x2(:,904),heltab2x4(:,:,904))
  call Hloop_A_Q(ntryL,G1H2(181),27,0,G2H2(724),n2h2(423))
call HGT_OLR(G1H4(1448),1,1,4)
call HGT_invQ_OLR(G1H4(1448),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1448),-4,0,G2H4(304),n2h4(560))
  call Hloop_QV_A(ntryL,G2H4(304),ex3(:),G2H2(725),m3h2x2(:,905),heltab2x4(:,:,905))
  call Hloop_AV_Q(ntryL,G1H4(1451),ex2(:),G1H2(181),m3h2x2(:,906),heltab2x4(:,:,906))
  call Hloop_A_Q(ntryL,G1H2(181),27,0,G2H2(726),n2h2(424))
  call Hloop_AV_Q(ntryL,G0H4(181),ex2(:),G0H2(1),m3h2x2(:,907),heltab2x4(:,:,907))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(181),n2h2(425))
call HGT_OLR(G1H4(1453),1,1,4)
call HGT_invQ_OLR(G1H4(1453),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1453),-6,0,G2H4(305),n2h4(561))
  call Hloop_QV_A(ntryL,G2H4(305),ex3(:),G2H2(727),m3h2x2(:,908),heltab2x4(:,:,908))
  call Hloop_AV_Q(ntryL,G1H4(1456),ex2(:),G1H2(182),m3h2x2(:,909),heltab2x4(:,:,909))
  call Hloop_A_Q(ntryL,G1H2(182),27,0,G2H2(728),n2h2(426))
  call Hloop_AV_Q(ntryL,G0H4(182),ex2(:),G0H2(1),m3h2x2(:,910),heltab2x4(:,:,910))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(182),n2h2(427))
  call Hloop_AV_Q(ntryL,G1H4(1457),ex2(:),G1H2(183),m3h2x2(:,911),heltab2x4(:,:,911))
  call Hloop_A_Q(ntryL,G1H2(183),27,nMT,G2H2(729),n2h2(428))
call HGT_OLR(G1H4(1458),1,1,4)
call HGT_invQ_OLR(G1H4(1458),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1458),-4,nMT,G2H4(306),n2h4(562))
  call Hloop_QV_A(ntryL,G2H4(306),ex3(:),G2H2(730),m3h2x2(:,912),heltab2x4(:,:,912))
  call Hloop_AV_Q(ntryL,G1H4(1463),ex2(:),G1H2(183),m3h2x2(:,913),heltab2x4(:,:,913))
  call Hloop_A_Q(ntryL,G1H2(183),27,nMT,G2H2(731),n2h2(429))
  call Hloop_AV_Q(ntryL,G1H4(1468),ex2(:),G1H2(183),m3h2x2(:,914),heltab2x4(:,:,914))
  call Hloop_A_Q(ntryL,G1H2(183),27,nMT,G2H2(732),n2h2(430))
call HGT_OLR(G1H4(1464),1,1,4)
call HGT_invQ_OLR(G1H4(1464),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1464),-4,nMT,G2H4(309),n2h4(563))
  call Hloop_QV_A(ntryL,G2H4(309),ex3(:),G2H2(733),m3h2x2(:,915),heltab2x4(:,:,915))
  call Hloop_AV_Q(ntryL,G1H4(1467),ex2(:),G1H2(183),m3h2x2(:,916),heltab2x4(:,:,916))
  call Hloop_A_Q(ntryL,G1H2(183),27,nMT,G2H2(734),n2h2(431))
  call Hloop_AV_Q(ntryL,G0H4(183),ex2(:),G0H2(1),m3h2x2(:,917),heltab2x4(:,:,917))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(183),n2h2(432))
call HGT_OLR(G1H4(1469),1,1,4)
call HGT_invQ_OLR(G1H4(1469),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1469),-6,nMT,G2H4(310),n2h4(564))
  call Hloop_QV_A(ntryL,G2H4(310),ex3(:),G2H2(735),m3h2x2(:,918),heltab2x4(:,:,918))
  call Hloop_AV_Q(ntryL,G1H4(1472),ex2(:),G1H2(184),m3h2x2(:,919),heltab2x4(:,:,919))
  call Hloop_A_Q(ntryL,G1H2(184),27,nMT,G2H2(736),n2h2(433))
  call Hloop_AV_Q(ntryL,G0H4(184),ex2(:),G0H2(1),m3h2x2(:,920),heltab2x4(:,:,920))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(184),n2h2(434))
  call Hloop_QV_A(ntryL,G1H4(1473),ex2(:),G1H2(185),m3h2x2(:,921),heltab2x4(:,:,921))
  call Hloop_Q_A(ntryL,G1H2(185),27,0,G2H2(737),n2h2(435))
call HGT_OLR(G1H4(1474),1,1,4)
call HGT_invQ_OLR(G1H4(1474),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1474),-4,0,G2H4(311),n2h4(565))
  call Hloop_AV_Q(ntryL,G2H4(311),ex3(:),G2H2(738),m3h2x2(:,922),heltab2x4(:,:,922))
  call Hloop_QV_A(ntryL,G1H4(1479),ex2(:),G1H2(185),m3h2x2(:,923),heltab2x4(:,:,923))
  call Hloop_Q_A(ntryL,G1H2(185),27,0,G2H2(739),n2h2(436))
  call Hloop_QV_A(ntryL,G1H4(1484),ex2(:),G1H2(185),m3h2x2(:,924),heltab2x4(:,:,924))
  call Hloop_Q_A(ntryL,G1H2(185),27,0,G2H2(740),n2h2(437))
call HGT_OLR(G1H4(1480),1,1,4)
call HGT_invQ_OLR(G1H4(1480),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1480),-4,0,G2H4(314),n2h4(566))
  call Hloop_AV_Q(ntryL,G2H4(314),ex3(:),G2H2(741),m3h2x2(:,925),heltab2x4(:,:,925))
  call Hloop_QV_A(ntryL,G1H4(1483),ex2(:),G1H2(185),m3h2x2(:,926),heltab2x4(:,:,926))
  call Hloop_Q_A(ntryL,G1H2(185),27,0,G2H2(742),n2h2(438))
  call Hloop_QV_A(ntryL,G0H4(185),ex2(:),G0H2(1),m3h2x2(:,927),heltab2x4(:,:,927))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(185),n2h2(439))
call HGT_OLR(G1H4(1485),1,1,4)
call HGT_invQ_OLR(G1H4(1485),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1485),-6,0,G2H4(315),n2h4(567))
  call Hloop_AV_Q(ntryL,G2H4(315),ex3(:),G2H2(743),m3h2x2(:,928),heltab2x4(:,:,928))
  call Hloop_QV_A(ntryL,G1H4(1488),ex2(:),G1H2(186),m3h2x2(:,929),heltab2x4(:,:,929))
  call Hloop_Q_A(ntryL,G1H2(186),27,0,G2H2(744),n2h2(440))
  call Hloop_QV_A(ntryL,G0H4(186),ex2(:),G0H2(1),m3h2x2(:,930),heltab2x4(:,:,930))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(186),n2h2(441))
  call Hloop_QV_A(ntryL,G1H4(1489),ex2(:),G1H2(187),m3h2x2(:,931),heltab2x4(:,:,931))
  call Hloop_Q_A(ntryL,G1H2(187),27,nMT,G2H2(745),n2h2(442))
call HGT_OLR(G1H4(1490),1,1,4)
call HGT_invQ_OLR(G1H4(1490),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1490),-4,nMT,G2H4(316),n2h4(568))
  call Hloop_AV_Q(ntryL,G2H4(316),ex3(:),G2H2(746),m3h2x2(:,932),heltab2x4(:,:,932))
  call Hloop_QV_A(ntryL,G1H4(1495),ex2(:),G1H2(187),m3h2x2(:,933),heltab2x4(:,:,933))
  call Hloop_Q_A(ntryL,G1H2(187),27,nMT,G2H2(747),n2h2(443))
  call Hloop_QV_A(ntryL,G1H4(1500),ex2(:),G1H2(187),m3h2x2(:,934),heltab2x4(:,:,934))
  call Hloop_Q_A(ntryL,G1H2(187),27,nMT,G2H2(748),n2h2(444))
call HGT_OLR(G1H4(1496),1,1,4)
call HGT_invQ_OLR(G1H4(1496),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1496),-4,nMT,G2H4(319),n2h4(569))
  call Hloop_AV_Q(ntryL,G2H4(319),ex3(:),G2H2(749),m3h2x2(:,935),heltab2x4(:,:,935))
  call Hloop_QV_A(ntryL,G1H4(1499),ex2(:),G1H2(187),m3h2x2(:,936),heltab2x4(:,:,936))
  call Hloop_Q_A(ntryL,G1H2(187),27,nMT,G2H2(750),n2h2(445))
  call Hloop_QV_A(ntryL,G0H4(187),ex2(:),G0H2(1),m3h2x2(:,937),heltab2x4(:,:,937))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(187),n2h2(446))
call HGT_OLR(G1H4(1501),1,1,4)
call HGT_invQ_OLR(G1H4(1501),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1501),-6,nMT,G2H4(320),n2h4(570))
  call Hloop_AV_Q(ntryL,G2H4(320),ex3(:),G2H2(751),m3h2x2(:,938),heltab2x4(:,:,938))
  call Hloop_QV_A(ntryL,G1H4(1504),ex2(:),G1H2(188),m3h2x2(:,939),heltab2x4(:,:,939))
  call Hloop_Q_A(ntryL,G1H2(188),27,nMT,G2H2(752),n2h2(447))
  call Hloop_QV_A(ntryL,G0H4(188),ex2(:),G0H2(1),m3h2x2(:,940),heltab2x4(:,:,940))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(188),n2h2(448))
  call Hloop_AV_Q(ntryL,G1H4(1505),ex2(:),G1H2(189),m3h2x2(:,941),heltab2x4(:,:,941))
  call Hloop_A_Q(ntryL,G1H2(189),27,nMB,G2H2(753),n2h2(449))
call HGT_OLR(G1H4(1506),1,1,4)
call HGT_invQ_OLR(G1H4(1506),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1506),-4,nMB,G2H4(321),n2h4(571))
  call Hloop_QV_A(ntryL,G2H4(321),ex3(:),G2H2(754),m3h2x2(:,942),heltab2x4(:,:,942))
  call Hloop_AV_Q(ntryL,G1H4(1511),ex2(:),G1H2(189),m3h2x2(:,943),heltab2x4(:,:,943))
  call Hloop_A_Q(ntryL,G1H2(189),27,nMB,G2H2(755),n2h2(450))
  call Hloop_AV_Q(ntryL,G1H4(1516),ex2(:),G1H2(189),m3h2x2(:,944),heltab2x4(:,:,944))
  call Hloop_A_Q(ntryL,G1H2(189),27,nMB,G2H2(756),n2h2(451))
call HGT_OLR(G1H4(1512),1,1,4)
call HGT_invQ_OLR(G1H4(1512),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1512),-4,nMB,G2H4(324),n2h4(572))
  call Hloop_QV_A(ntryL,G2H4(324),ex3(:),G2H2(757),m3h2x2(:,945),heltab2x4(:,:,945))
  call Hloop_AV_Q(ntryL,G1H4(1515),ex2(:),G1H2(189),m3h2x2(:,946),heltab2x4(:,:,946))
  call Hloop_A_Q(ntryL,G1H2(189),27,nMB,G2H2(758),n2h2(452))
  call Hloop_AV_Q(ntryL,G0H4(189),ex2(:),G0H2(1),m3h2x2(:,947),heltab2x4(:,:,947))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(189),n2h2(453))
call HGT_OLR(G1H4(1517),1,1,4)
call HGT_invQ_OLR(G1H4(1517),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1517),-6,nMB,G2H4(325),n2h4(573))
  call Hloop_QV_A(ntryL,G2H4(325),ex3(:),G2H2(759),m3h2x2(:,948),heltab2x4(:,:,948))
  call Hloop_AV_Q(ntryL,G1H4(1520),ex2(:),G1H2(190),m3h2x2(:,949),heltab2x4(:,:,949))
  call Hloop_A_Q(ntryL,G1H2(190),27,nMB,G2H2(760),n2h2(454))
  call Hloop_AV_Q(ntryL,G0H4(190),ex2(:),G0H2(1),m3h2x2(:,950),heltab2x4(:,:,950))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(190),n2h2(455))
  call Hloop_QV_A(ntryL,G1H4(1521),ex2(:),G1H2(191),m3h2x2(:,951),heltab2x4(:,:,951))
  call Hloop_Q_A(ntryL,G1H2(191),27,nMB,G2H2(761),n2h2(456))
call HGT_OLR(G1H4(1522),1,1,4)
call HGT_invQ_OLR(G1H4(1522),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1522),-4,nMB,G2H4(326),n2h4(574))
  call Hloop_AV_Q(ntryL,G2H4(326),ex3(:),G2H2(762),m3h2x2(:,952),heltab2x4(:,:,952))
  call Hloop_QV_A(ntryL,G1H4(1527),ex2(:),G1H2(191),m3h2x2(:,953),heltab2x4(:,:,953))
  call Hloop_Q_A(ntryL,G1H2(191),27,nMB,G2H2(763),n2h2(457))
  call Hloop_QV_A(ntryL,G1H4(1532),ex2(:),G1H2(191),m3h2x2(:,954),heltab2x4(:,:,954))
  call Hloop_Q_A(ntryL,G1H2(191),27,nMB,G2H2(764),n2h2(458))
call HGT_OLR(G1H4(1528),1,1,4)
call HGT_invQ_OLR(G1H4(1528),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1528),-4,nMB,G2H4(329),n2h4(575))
  call Hloop_AV_Q(ntryL,G2H4(329),ex3(:),G2H2(765),m3h2x2(:,955),heltab2x4(:,:,955))
  call Hloop_QV_A(ntryL,G1H4(1531),ex2(:),G1H2(191),m3h2x2(:,956),heltab2x4(:,:,956))
  call Hloop_Q_A(ntryL,G1H2(191),27,nMB,G2H2(766),n2h2(459))
  call Hloop_QV_A(ntryL,G0H4(191),ex2(:),G0H2(1),m3h2x2(:,957),heltab2x4(:,:,957))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(191),n2h2(460))
call HGT_OLR(G1H4(1533),1,1,4)
call HGT_invQ_OLR(G1H4(1533),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1533),-6,nMB,G2H4(330),n2h4(576))
  call Hloop_AV_Q(ntryL,G2H4(330),ex3(:),G2H2(767),m3h2x2(:,958),heltab2x4(:,:,958))
  call Hloop_QV_A(ntryL,G1H4(1536),ex2(:),G1H2(192),m3h2x2(:,959),heltab2x4(:,:,959))
  call Hloop_Q_A(ntryL,G1H2(192),27,nMB,G2H2(768),n2h2(461))
  call Hloop_QV_A(ntryL,G0H4(192),ex2(:),G0H2(1),m3h2x2(:,960),heltab2x4(:,:,960))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(192),n2h2(462))
  call Hloop_DV_C(ntryL,G1H4(1537),25,ex2(:),G2H2(769),m3h2x2(:,961),heltab2x4(:,:,961))
call HGT_OLR(G1H4(1538),1,1,4)
call HGT_invQ_OLR(G1H4(1538),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1538),-4,ex3(:),4,G2H2(770),m3h2x2(:,962),heltab2x4(:,:,962))
  call Hloop_DV_C(ntryL,G1H4(1543),25,ex2(:),G2H2(771),m3h2x2(:,963),heltab2x4(:,:,963))
  call Hloop_DV_C(ntryL,G1H4(1548),25,ex2(:),G2H2(772),m3h2x2(:,964),heltab2x4(:,:,964))
call HGT_OLR(G1H4(1544),1,1,4)
call HGT_invQ_OLR(G1H4(1544),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1544),-4,ex3(:),4,G2H2(773),m3h2x2(:,965),heltab2x4(:,:,965))
  call Hloop_DV_C(ntryL,G1H4(1547),25,ex2(:),G2H2(774),m3h2x2(:,966),heltab2x4(:,:,966))
  call Hloop_DV_C(ntryL,G0H4(193),25,ex2(:),G1H2(193),m3h2x2(:,967),heltab2x4(:,:,967))
call HGT_OLR(G1H4(1549),1,1,4)
call HGT_invQ_OLR(G1H4(1549),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1549),-6,ex3(:),4,G2H2(775),m3h2x2(:,968),heltab2x4(:,:,968))
  call Hloop_DV_C(ntryL,G1H4(1552),25,ex2(:),G2H2(776),m3h2x2(:,969),heltab2x4(:,:,969))
  call Hloop_DV_C(ntryL,G0H4(194),25,ex2(:),G1H2(194),m3h2x2(:,970),heltab2x4(:,:,970))
  call Hloop_CV_D(ntryL,G1H4(1553),25,ex2(:),2,G2H2(777),m3h2x2(:,971),heltab2x4(:,:,971))
call HGT_OLR(G1H4(1554),1,1,4)
call HGT_invQ_OLR(G1H4(1554),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1554),-4,ex3(:),G2H2(778),m3h2x2(:,972),heltab2x4(:,:,972))
  call Hloop_CV_D(ntryL,G1H4(1559),25,ex2(:),2,G2H2(779),m3h2x2(:,973),heltab2x4(:,:,973))
  call Hloop_CV_D(ntryL,G1H4(1564),25,ex2(:),2,G2H2(780),m3h2x2(:,974),heltab2x4(:,:,974))
call HGT_OLR(G1H4(1560),1,1,4)
call HGT_invQ_OLR(G1H4(1560),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1560),-4,ex3(:),G2H2(781),m3h2x2(:,975),heltab2x4(:,:,975))
  call Hloop_CV_D(ntryL,G1H4(1563),25,ex2(:),2,G2H2(782),m3h2x2(:,976),heltab2x4(:,:,976))
  call Hloop_CV_D(ntryL,G0H4(195),25,ex2(:),2,G1H2(195),m3h2x2(:,977),heltab2x4(:,:,977))
call HGT_OLR(G1H4(1565),1,1,4)
call HGT_invQ_OLR(G1H4(1565),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1565),-6,ex3(:),G2H2(783),m3h2x2(:,978),heltab2x4(:,:,978))
  call Hloop_CV_D(ntryL,G1H4(1568),25,ex2(:),2,G2H2(784),m3h2x2(:,979),heltab2x4(:,:,979))
  call Hloop_CV_D(ntryL,G0H4(196),25,ex2(:),2,G1H2(196),m3h2x2(:,980),heltab2x4(:,:,980))
  call Hloop_UV_W(ntryL,G1H4(1569),25,ex2(:),2,G2H2(785),m3h2x2(:,981),heltab2x4(:,:,981))
call HGT_raise_alpha_OLR(G1H4(1570),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1570),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1570),-4,ex3(:),4,G2H2(786),m3h2x2(:,982),heltab2x4(:,:,982))
call signflip_OLR(G2H2(786))
  call Hloop_UV_W(ntryL,G1H4(1575),25,ex2(:),2,G2H2(787),m3h2x2(:,983),heltab2x4(:,:,983))
  call Hloop_UV_W(ntryL,G1H4(1580),25,ex2(:),2,G2H2(788),m3h2x2(:,984),heltab2x4(:,:,984))
call HGT_raise_alpha_OLR(G1H4(1576),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1576),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1576),-4,ex3(:),4,G2H2(789),m3h2x2(:,985),heltab2x4(:,:,985))
call signflip_OLR(G2H2(789))
  call Hloop_UV_W(ntryL,G1H4(1579),25,ex2(:),2,G2H2(790),m3h2x2(:,986),heltab2x4(:,:,986))
  call Hloop_UV_W(ntryL,G0H4(197),25,ex2(:),2,G1H2(197),m3h2x2(:,987),heltab2x4(:,:,987))
call HGT_raise_alpha_OLR(G1H4(1581),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1581),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1581),-6,ex3(:),4,G2H2(791),m3h2x2(:,988),heltab2x4(:,:,988))
call signflip_OLR(G2H2(791))
  call Hloop_UV_W(ntryL,G1H4(1584),25,ex2(:),2,G2H2(792),m3h2x2(:,989),heltab2x4(:,:,989))
  call Hloop_UV_W(ntryL,G0H4(198),25,ex2(:),2,G1H2(198),m3h2x2(:,990),heltab2x4(:,:,990))
  call Hloop_AV_Q(ntryL,G1H4(1585),ex3(:),G1H2(199),m3h2x2(:,991),heltab2x4(:,:,991))
  call Hloop_A_Q(ntryL,G1H2(199),29,0,G2H2(793),n2h2(463))
call HGT_OLR(G1H4(1586),1,1,4)
call HGT_invQ_OLR(G1H4(1586),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1586),-2,0,G2H4(331),n2h4(586))
  call Hloop_QV_A(ntryL,G2H4(331),ex2(:),G2H2(794),m3h2x2(:,992),heltab2x4(:,:,992))
  call Hloop_AV_Q(ntryL,G1H4(1591),ex3(:),G1H2(199),m3h2x2(:,993),heltab2x4(:,:,993))
  call Hloop_A_Q(ntryL,G1H2(199),29,0,G2H2(795),n2h2(464))
  call Hloop_AV_Q(ntryL,G1H4(1596),ex3(:),G1H2(199),m3h2x2(:,994),heltab2x4(:,:,994))
  call Hloop_A_Q(ntryL,G1H2(199),29,0,G2H2(796),n2h2(465))
call HGT_OLR(G1H4(1592),1,1,4)
call HGT_invQ_OLR(G1H4(1592),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1592),-2,0,G2H4(334),n2h4(587))
  call Hloop_QV_A(ntryL,G2H4(334),ex2(:),G2H2(797),m3h2x2(:,995),heltab2x4(:,:,995))
  call Hloop_AV_Q(ntryL,G1H4(1595),ex3(:),G1H2(199),m3h2x2(:,996),heltab2x4(:,:,996))
  call Hloop_A_Q(ntryL,G1H2(199),29,0,G2H2(798),n2h2(466))
  call Hloop_AV_Q(ntryL,G0H4(199),ex3(:),G0H2(1),m3h2x2(:,997),heltab2x4(:,:,997))
  call Hloop_A_Q(ntryL,G0H2(1),29,0,G1H2(199),n2h2(467))
call HGT_OLR(G1H4(1597),1,1,4)
call HGT_invQ_OLR(G1H4(1597),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1597),-6,0,G2H4(335),n2h4(588))
  call Hloop_QV_A(ntryL,G2H4(335),ex2(:),G2H2(799),m3h2x2(:,998),heltab2x4(:,:,998))
  call Hloop_AV_Q(ntryL,G1H4(1600),ex3(:),G1H2(200),m3h2x2(:,999),heltab2x4(:,:,999))
  call Hloop_A_Q(ntryL,G1H2(200),29,0,G2H2(800),n2h2(468))
  call Hloop_AV_Q(ntryL,G0H4(200),ex3(:),G0H2(1),m3h2x2(:,1000),heltab2x4(:,:,1000))
  call Hloop_A_Q(ntryL,G0H2(1),29,0,G1H2(200),n2h2(469))
  call Hloop_AV_Q(ntryL,G1H4(1601),ex3(:),G1H2(201),m3h2x2(:,1001),heltab2x4(:,:,1001))
  call Hloop_A_Q(ntryL,G1H2(201),29,nMT,G2H2(801),n2h2(470))
call HGT_OLR(G1H4(1602),1,1,4)
call HGT_invQ_OLR(G1H4(1602),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1602),-2,nMT,G2H4(336),n2h4(589))
  call Hloop_QV_A(ntryL,G2H4(336),ex2(:),G2H2(802),m3h2x2(:,1002),heltab2x4(:,:,1002))
  call Hloop_AV_Q(ntryL,G1H4(1607),ex3(:),G1H2(201),m3h2x2(:,1003),heltab2x4(:,:,1003))
  call Hloop_A_Q(ntryL,G1H2(201),29,nMT,G2H2(803),n2h2(471))
  call Hloop_AV_Q(ntryL,G1H4(1612),ex3(:),G1H2(201),m3h2x2(:,1004),heltab2x4(:,:,1004))
  call Hloop_A_Q(ntryL,G1H2(201),29,nMT,G2H2(804),n2h2(472))
call HGT_OLR(G1H4(1608),1,1,4)
call HGT_invQ_OLR(G1H4(1608),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1608),-2,nMT,G2H4(339),n2h4(590))
  call Hloop_QV_A(ntryL,G2H4(339),ex2(:),G2H2(805),m3h2x2(:,1005),heltab2x4(:,:,1005))
  call Hloop_AV_Q(ntryL,G1H4(1611),ex3(:),G1H2(201),m3h2x2(:,1006),heltab2x4(:,:,1006))
  call Hloop_A_Q(ntryL,G1H2(201),29,nMT,G2H2(806),n2h2(473))
  call Hloop_AV_Q(ntryL,G0H4(201),ex3(:),G0H2(1),m3h2x2(:,1007),heltab2x4(:,:,1007))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMT,G1H2(201),n2h2(474))
call HGT_OLR(G1H4(1613),1,1,4)
call HGT_invQ_OLR(G1H4(1613),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1613),-6,nMT,G2H4(340),n2h4(591))
  call Hloop_QV_A(ntryL,G2H4(340),ex2(:),G2H2(807),m3h2x2(:,1008),heltab2x4(:,:,1008))
  call Hloop_AV_Q(ntryL,G1H4(1616),ex3(:),G1H2(202),m3h2x2(:,1009),heltab2x4(:,:,1009))
  call Hloop_A_Q(ntryL,G1H2(202),29,nMT,G2H2(808),n2h2(475))
  call Hloop_AV_Q(ntryL,G0H4(202),ex3(:),G0H2(1),m3h2x2(:,1010),heltab2x4(:,:,1010))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMT,G1H2(202),n2h2(476))
  call Hloop_QV_A(ntryL,G1H4(1617),ex3(:),G1H2(203),m3h2x2(:,1011),heltab2x4(:,:,1011))
  call Hloop_Q_A(ntryL,G1H2(203),29,0,G2H2(809),n2h2(477))
call HGT_OLR(G1H4(1618),1,1,4)
call HGT_invQ_OLR(G1H4(1618),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1618),-2,0,G2H4(341),n2h4(592))
  call Hloop_AV_Q(ntryL,G2H4(341),ex2(:),G2H2(810),m3h2x2(:,1012),heltab2x4(:,:,1012))
  call Hloop_QV_A(ntryL,G1H4(1623),ex3(:),G1H2(203),m3h2x2(:,1013),heltab2x4(:,:,1013))
  call Hloop_Q_A(ntryL,G1H2(203),29,0,G2H2(811),n2h2(478))
  call Hloop_QV_A(ntryL,G1H4(1628),ex3(:),G1H2(203),m3h2x2(:,1014),heltab2x4(:,:,1014))
  call Hloop_Q_A(ntryL,G1H2(203),29,0,G2H2(812),n2h2(479))
call HGT_OLR(G1H4(1624),1,1,4)
call HGT_invQ_OLR(G1H4(1624),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1624),-2,0,G2H4(344),n2h4(593))
  call Hloop_AV_Q(ntryL,G2H4(344),ex2(:),G2H2(813),m3h2x2(:,1015),heltab2x4(:,:,1015))
  call Hloop_QV_A(ntryL,G1H4(1627),ex3(:),G1H2(203),m3h2x2(:,1016),heltab2x4(:,:,1016))
  call Hloop_Q_A(ntryL,G1H2(203),29,0,G2H2(814),n2h2(480))
  call Hloop_QV_A(ntryL,G0H4(203),ex3(:),G0H2(1),m3h2x2(:,1017),heltab2x4(:,:,1017))
  call Hloop_Q_A(ntryL,G0H2(1),29,0,G1H2(203),n2h2(481))
call HGT_OLR(G1H4(1629),1,1,4)
call HGT_invQ_OLR(G1H4(1629),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1629),-6,0,G2H4(345),n2h4(594))
  call Hloop_AV_Q(ntryL,G2H4(345),ex2(:),G2H2(815),m3h2x2(:,1018),heltab2x4(:,:,1018))
  call Hloop_QV_A(ntryL,G1H4(1632),ex3(:),G1H2(204),m3h2x2(:,1019),heltab2x4(:,:,1019))
  call Hloop_Q_A(ntryL,G1H2(204),29,0,G2H2(816),n2h2(482))
  call Hloop_QV_A(ntryL,G0H4(204),ex3(:),G0H2(1),m3h2x2(:,1020),heltab2x4(:,:,1020))
  call Hloop_Q_A(ntryL,G0H2(1),29,0,G1H2(204),n2h2(483))
  call Hloop_QV_A(ntryL,G1H4(1633),ex3(:),G1H2(205),m3h2x2(:,1021),heltab2x4(:,:,1021))
  call Hloop_Q_A(ntryL,G1H2(205),29,nMT,G2H2(817),n2h2(484))
call HGT_OLR(G1H4(1634),1,1,4)
call HGT_invQ_OLR(G1H4(1634),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1634),-2,nMT,G2H4(346),n2h4(595))
  call Hloop_AV_Q(ntryL,G2H4(346),ex2(:),G2H2(818),m3h2x2(:,1022),heltab2x4(:,:,1022))
  call Hloop_QV_A(ntryL,G1H4(1639),ex3(:),G1H2(205),m3h2x2(:,1023),heltab2x4(:,:,1023))
  call Hloop_Q_A(ntryL,G1H2(205),29,nMT,G2H2(819),n2h2(485))
  call Hloop_QV_A(ntryL,G1H4(1644),ex3(:),G1H2(205),m3h2x2(:,1024),heltab2x4(:,:,1024))
  call Hloop_Q_A(ntryL,G1H2(205),29,nMT,G2H2(820),n2h2(486))
call HGT_OLR(G1H4(1640),1,1,4)
call HGT_invQ_OLR(G1H4(1640),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1640),-2,nMT,G2H4(349),n2h4(596))
  call Hloop_AV_Q(ntryL,G2H4(349),ex2(:),G2H2(821),m3h2x2(:,1025),heltab2x4(:,:,1025))
  call Hloop_QV_A(ntryL,G1H4(1643),ex3(:),G1H2(205),m3h2x2(:,1026),heltab2x4(:,:,1026))
  call Hloop_Q_A(ntryL,G1H2(205),29,nMT,G2H2(822),n2h2(487))
  call Hloop_QV_A(ntryL,G0H4(205),ex3(:),G0H2(1),m3h2x2(:,1027),heltab2x4(:,:,1027))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMT,G1H2(205),n2h2(488))
call HGT_OLR(G1H4(1645),1,1,4)
call HGT_invQ_OLR(G1H4(1645),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1645),-6,nMT,G2H4(350),n2h4(597))
  call Hloop_AV_Q(ntryL,G2H4(350),ex2(:),G2H2(823),m3h2x2(:,1028),heltab2x4(:,:,1028))
  call Hloop_QV_A(ntryL,G1H4(1648),ex3(:),G1H2(206),m3h2x2(:,1029),heltab2x4(:,:,1029))
  call Hloop_Q_A(ntryL,G1H2(206),29,nMT,G2H2(824),n2h2(489))
  call Hloop_QV_A(ntryL,G0H4(206),ex3(:),G0H2(1),m3h2x2(:,1030),heltab2x4(:,:,1030))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMT,G1H2(206),n2h2(490))
  call Hloop_AV_Q(ntryL,G1H4(1649),ex3(:),G1H2(207),m3h2x2(:,1031),heltab2x4(:,:,1031))
  call Hloop_A_Q(ntryL,G1H2(207),29,nMB,G2H2(825),n2h2(491))
call HGT_OLR(G1H4(1650),1,1,4)
call HGT_invQ_OLR(G1H4(1650),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1650),-2,nMB,G2H4(351),n2h4(598))
  call Hloop_QV_A(ntryL,G2H4(351),ex2(:),G2H2(826),m3h2x2(:,1032),heltab2x4(:,:,1032))
  call Hloop_AV_Q(ntryL,G1H4(1655),ex3(:),G1H2(207),m3h2x2(:,1033),heltab2x4(:,:,1033))
  call Hloop_A_Q(ntryL,G1H2(207),29,nMB,G2H2(827),n2h2(492))
  call Hloop_AV_Q(ntryL,G1H4(1660),ex3(:),G1H2(207),m3h2x2(:,1034),heltab2x4(:,:,1034))
  call Hloop_A_Q(ntryL,G1H2(207),29,nMB,G2H2(828),n2h2(493))
call HGT_OLR(G1H4(1656),1,1,4)
call HGT_invQ_OLR(G1H4(1656),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1656),-2,nMB,G2H4(354),n2h4(599))
  call Hloop_QV_A(ntryL,G2H4(354),ex2(:),G2H2(829),m3h2x2(:,1035),heltab2x4(:,:,1035))
  call Hloop_AV_Q(ntryL,G1H4(1659),ex3(:),G1H2(207),m3h2x2(:,1036),heltab2x4(:,:,1036))
  call Hloop_A_Q(ntryL,G1H2(207),29,nMB,G2H2(830),n2h2(494))
  call Hloop_AV_Q(ntryL,G0H4(207),ex3(:),G0H2(1),m3h2x2(:,1037),heltab2x4(:,:,1037))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMB,G1H2(207),n2h2(495))
call HGT_OLR(G1H4(1661),1,1,4)
call HGT_invQ_OLR(G1H4(1661),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1661),-6,nMB,G2H4(355),n2h4(600))
  call Hloop_QV_A(ntryL,G2H4(355),ex2(:),G2H2(831),m3h2x2(:,1038),heltab2x4(:,:,1038))
  call Hloop_AV_Q(ntryL,G1H4(1664),ex3(:),G1H2(208),m3h2x2(:,1039),heltab2x4(:,:,1039))
  call Hloop_A_Q(ntryL,G1H2(208),29,nMB,G2H2(832),n2h2(496))
  call Hloop_AV_Q(ntryL,G0H4(208),ex3(:),G0H2(1),m3h2x2(:,1040),heltab2x4(:,:,1040))
  call Hloop_A_Q(ntryL,G0H2(1),29,nMB,G1H2(208),n2h2(497))
  call Hloop_QV_A(ntryL,G1H4(1665),ex3(:),G1H2(209),m3h2x2(:,1041),heltab2x4(:,:,1041))
  call Hloop_Q_A(ntryL,G1H2(209),29,nMB,G2H2(833),n2h2(498))
call HGT_OLR(G1H4(1666),1,1,4)
call HGT_invQ_OLR(G1H4(1666),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1666),-2,nMB,G2H4(356),n2h4(601))
  call Hloop_AV_Q(ntryL,G2H4(356),ex2(:),G2H2(834),m3h2x2(:,1042),heltab2x4(:,:,1042))
  call Hloop_QV_A(ntryL,G1H4(1671),ex3(:),G1H2(209),m3h2x2(:,1043),heltab2x4(:,:,1043))
  call Hloop_Q_A(ntryL,G1H2(209),29,nMB,G2H2(835),n2h2(499))
  call Hloop_QV_A(ntryL,G1H4(1676),ex3(:),G1H2(209),m3h2x2(:,1044),heltab2x4(:,:,1044))
  call Hloop_Q_A(ntryL,G1H2(209),29,nMB,G2H2(836),n2h2(500))
call HGT_OLR(G1H4(1672),1,1,4)
call HGT_invQ_OLR(G1H4(1672),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1672),-2,nMB,G2H4(359),n2h4(602))
  call Hloop_AV_Q(ntryL,G2H4(359),ex2(:),G2H2(837),m3h2x2(:,1045),heltab2x4(:,:,1045))
  call Hloop_QV_A(ntryL,G1H4(1675),ex3(:),G1H2(209),m3h2x2(:,1046),heltab2x4(:,:,1046))
  call Hloop_Q_A(ntryL,G1H2(209),29,nMB,G2H2(838),n2h2(501))
  call Hloop_QV_A(ntryL,G0H4(209),ex3(:),G0H2(1),m3h2x2(:,1047),heltab2x4(:,:,1047))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMB,G1H2(209),n2h2(502))
call HGT_OLR(G1H4(1677),1,1,4)
call HGT_invQ_OLR(G1H4(1677),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1677),-6,nMB,G2H4(360),n2h4(603))
  call Hloop_AV_Q(ntryL,G2H4(360),ex2(:),G2H2(839),m3h2x2(:,1048),heltab2x4(:,:,1048))
  call Hloop_QV_A(ntryL,G1H4(1680),ex3(:),G1H2(210),m3h2x2(:,1049),heltab2x4(:,:,1049))
  call Hloop_Q_A(ntryL,G1H2(210),29,nMB,G2H2(840),n2h2(503))
  call Hloop_QV_A(ntryL,G0H4(210),ex3(:),G0H2(1),m3h2x2(:,1050),heltab2x4(:,:,1050))
  call Hloop_Q_A(ntryL,G0H2(1),29,nMB,G1H2(210),n2h2(504))
  call Hloop_DV_C(ntryL,G1H4(1681),25,ex3(:),G2H2(841),m3h2x2(:,1051),heltab2x4(:,:,1051))
call HGT_OLR(G1H4(1682),1,1,4)
call HGT_invQ_OLR(G1H4(1682),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1682),-2,ex2(:),2,G2H2(842),m3h2x2(:,1052),heltab2x4(:,:,1052))
  call Hloop_DV_C(ntryL,G1H4(1687),25,ex3(:),G2H2(843),m3h2x2(:,1053),heltab2x4(:,:,1053))
  call Hloop_DV_C(ntryL,G1H4(1692),25,ex3(:),G2H2(844),m3h2x2(:,1054),heltab2x4(:,:,1054))
call HGT_OLR(G1H4(1688),1,1,4)
call HGT_invQ_OLR(G1H4(1688),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1688),-2,ex2(:),2,G2H2(845),m3h2x2(:,1055),heltab2x4(:,:,1055))
  call Hloop_DV_C(ntryL,G1H4(1691),25,ex3(:),G2H2(846),m3h2x2(:,1056),heltab2x4(:,:,1056))
  call Hloop_DV_C(ntryL,G0H4(211),25,ex3(:),G1H2(211),m3h2x2(:,1057),heltab2x4(:,:,1057))
call HGT_OLR(G1H4(1693),1,1,4)
call HGT_invQ_OLR(G1H4(1693),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(1693),-6,ex2(:),2,G2H2(847),m3h2x2(:,1058),heltab2x4(:,:,1058))
  call Hloop_DV_C(ntryL,G1H4(1696),25,ex3(:),G2H2(848),m3h2x2(:,1059),heltab2x4(:,:,1059))
  call Hloop_DV_C(ntryL,G0H4(212),25,ex3(:),G1H2(212),m3h2x2(:,1060),heltab2x4(:,:,1060))
  call Hloop_CV_D(ntryL,G1H4(1697),25,ex3(:),4,G2H2(849),m3h2x2(:,1061),heltab2x4(:,:,1061))
call HGT_OLR(G1H4(1698),1,1,4)
call HGT_invQ_OLR(G1H4(1698),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1698),-2,ex2(:),G2H2(850),m3h2x2(:,1062),heltab2x4(:,:,1062))
  call Hloop_CV_D(ntryL,G1H4(1703),25,ex3(:),4,G2H2(851),m3h2x2(:,1063),heltab2x4(:,:,1063))
  call Hloop_CV_D(ntryL,G1H4(1708),25,ex3(:),4,G2H2(852),m3h2x2(:,1064),heltab2x4(:,:,1064))
call HGT_OLR(G1H4(1704),1,1,4)
call HGT_invQ_OLR(G1H4(1704),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1704),-2,ex2(:),G2H2(853),m3h2x2(:,1065),heltab2x4(:,:,1065))
  call Hloop_CV_D(ntryL,G1H4(1707),25,ex3(:),4,G2H2(854),m3h2x2(:,1066),heltab2x4(:,:,1066))
  call Hloop_CV_D(ntryL,G0H4(213),25,ex3(:),4,G1H2(213),m3h2x2(:,1067),heltab2x4(:,:,1067))
call HGT_OLR(G1H4(1709),1,1,4)
call HGT_invQ_OLR(G1H4(1709),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(1709),-6,ex2(:),G2H2(855),m3h2x2(:,1068),heltab2x4(:,:,1068))
  call Hloop_CV_D(ntryL,G1H4(1712),25,ex3(:),4,G2H2(856),m3h2x2(:,1069),heltab2x4(:,:,1069))
  call Hloop_CV_D(ntryL,G0H4(214),25,ex3(:),4,G1H2(214),m3h2x2(:,1070),heltab2x4(:,:,1070))
  call Hloop_UV_W(ntryL,G1H4(1713),25,ex3(:),4,G2H2(857),m3h2x2(:,1071),heltab2x4(:,:,1071))
call HGT_raise_alpha_OLR(G1H4(1714),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1714),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1714),-2,ex2(:),2,G2H2(858),m3h2x2(:,1072),heltab2x4(:,:,1072))
call signflip_OLR(G2H2(858))
  call Hloop_UV_W(ntryL,G1H4(1719),25,ex3(:),4,G2H2(859),m3h2x2(:,1073),heltab2x4(:,:,1073))
  call Hloop_UV_W(ntryL,G1H4(1724),25,ex3(:),4,G2H2(860),m3h2x2(:,1074),heltab2x4(:,:,1074))
call HGT_raise_alpha_OLR(G1H4(1720),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1720),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1720),-2,ex2(:),2,G2H2(861),m3h2x2(:,1075),heltab2x4(:,:,1075))
call signflip_OLR(G2H2(861))
  call Hloop_UV_W(ntryL,G1H4(1723),25,ex3(:),4,G2H2(862),m3h2x2(:,1076),heltab2x4(:,:,1076))
  call Hloop_UV_W(ntryL,G0H4(215),25,ex3(:),4,G1H2(215),m3h2x2(:,1077),heltab2x4(:,:,1077))
call HGT_raise_alpha_OLR(G1H4(1725),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1725),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(1725),-6,ex2(:),2,G2H2(863),m3h2x2(:,1078),heltab2x4(:,:,1078))
call signflip_OLR(G2H2(863))
  call Hloop_UV_W(ntryL,G1H4(1728),25,ex3(:),4,G2H2(864),m3h2x2(:,1079),heltab2x4(:,:,1079))
  call Hloop_UV_W(ntryL,G0H4(216),25,ex3(:),4,G1H2(216),m3h2x2(:,1080),heltab2x4(:,:,1080))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(2),mass4set(:,1),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),2)
  call HG1shiftOLR(G1H2(224),10,2)
  call Hloop_AV_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,2),  & 
G1H2(2),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(2),mass4set(:,2),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),2)
  call HG1shiftOLR(G1H2(234),10,2)
  call Hloop_AV_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(2),n2h1(2))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,1),  & 
G1H2(4),G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(238),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(2),mass4set(:,1),  & 
G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(244),10,2)
  call Hloop_QV_A(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(1),mass5set(:,2),  & 
G1H2(6),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(2),mass4set(:,2),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),2)
  call HG1shiftOLR(G1H2(254),10,2)
  call Hloop_QV_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(4))
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(1),mass5set(:,3),  & 
G1H2(8),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(2),mass4set(:,3),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),2)
  call HG1shiftOLR(G1H2(264),10,2)
  call Hloop_AV_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(5),n2h1(5))
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(1),mass5set(:,3),  & 
G1H2(10),G1H2(268),G1H2(269),G1H2(270),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(268),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(2),mass4set(:,3),  & 
G1H2(273),G1H2(274),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(274),10,2)
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(1),mass5set(:,1),  & 
G1H2(12),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(2),mass4set(:,1),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),2)
  call HG1shiftOLR(G1H2(284),10,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(14),23,ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(1),mass5set(:,1),  & 
G1H2(14),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(2),mass4set(:,1),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),2)
  call HG1shiftOLR(G1H2(294),10,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(16),23,ex4(:),8,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(1),mass5set(:,1),  & 
G1H2(16),G1H2(298),G1H2(299),G1H2(300),G1H2(301),G1H2(302),2)
  call HG1shiftOLR(G1H2(298),8,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(2),mass4set(:,1),  & 
G1H2(303),G1H2(304),G1H2(305),G1H2(306),G1H2(307),2)
  call HG1shiftOLR(G1H2(304),10,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),23,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(2),mass5set(:,1),  & 
G1H2(18),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),8,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(4),mass4set(:,1),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),2)
  call HG1shiftOLR(G1H2(314),12,2)
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(7))
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(2),mass5set(:,2),  & 
G1H2(20),G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(318),8,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(4),mass4set(:,2),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),2)
  call HG1shiftOLR(G1H2(324),12,2)
  call Hloop_QV_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(8))
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(2),mass5set(:,1),  & 
G1H2(22),G1H2(328),G1H2(329),G1H2(330),G1H2(331),G1H2(332),2)
  call HG1shiftOLR(G1H2(328),8,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(4),mass4set(:,1),  & 
G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(334),12,2)
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(9))
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(2),mass5set(:,2),  & 
G1H2(24),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),8,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(4),mass4set(:,2),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),2)
  call HG1shiftOLR(G1H2(344),12,2)
  call Hloop_AV_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(13),n2h1(10))
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(2),mass5set(:,3),  & 
G1H2(26),G1H2(348),G1H2(349),G1H2(350),G1H2(351),G1H2(352),2)
  call HG1shiftOLR(G1H2(348),8,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(4),mass4set(:,3),  & 
G1H2(353),G1H2(354),G1H2(355),G1H2(356),G1H2(357),2)
  call HG1shiftOLR(G1H2(354),12,2)
  call Hloop_QV_A(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(11))
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(2),mass5set(:,3),  & 
G1H2(28),G1H2(358),G1H2(359),G1H2(360),G1H2(361),G1H2(362),2)
  call HG1shiftOLR(G1H2(358),8,2)
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(4),mass4set(:,3),  & 
G1H2(363),G1H2(364),G1H2(365),G1H2(366),G1H2(367),2)
  call HG1shiftOLR(G1H2(364),12,2)
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(12))
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(2),mass5set(:,1),  & 
G1H2(30),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),8,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(4),mass4set(:,1),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(374),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(32),23,ex4(:),8,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(2),mass5set(:,1),  & 
G1H2(32),G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),2)
  call HG1shiftOLR(G1H2(378),8,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(4),mass4set(:,1),  & 
G1H2(383),G1H2(384),G1H2(385),G1H2(386),G1H2(387),2)
  call HG1shiftOLR(G1H2(384),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(34),23,ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(2),mass5set(:,1),  & 
G1H2(34),G1H2(388),G1H2(389),G1H2(390),G1H2(391),G1H2(392),2)
  call HG1shiftOLR(G1H2(388),8,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(4),mass4set(:,1),  & 
G1H2(393),G1H2(394),G1H2(395),G1H2(396),G1H2(397),2)
  call HG1shiftOLR(G1H2(394),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(36),23,ex4(:),8,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hotf_5pt_reduction(G2H2(145),RedSet_5(3),mass5set(:,1),  & 
G1H2(36),G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(398),8,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(5),mass4set(:,1),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),2)
  call HG1shiftOLR(G1H2(404),9,2)
  call Hloop_QV_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(13))
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(3),mass5set(:,2),  & 
G1H2(38),G1H2(408),G1H2(409),G1H2(410),G1H2(411),G1H2(412),2)
  call HG1shiftOLR(G1H2(408),8,2)
  call Hotf_4pt_reduction(G2H2(156),RedSet_4(5),mass4set(:,2),  & 
G1H2(413),G1H2(414),G1H2(415),G1H2(416),G1H2(417),2)
  call HG1shiftOLR(G1H2(414),9,2)
  call Hloop_QV_A(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(20),n2h1(14))
  call Hotf_5pt_reduction(G2H2(161),RedSet_5(3),mass5set(:,1),  & 
G1H2(40),G1H2(418),G1H2(419),G1H2(420),G1H2(421),G1H2(422),2)
  call HG1shiftOLR(G1H2(418),8,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(5),mass4set(:,1),  & 
G1H2(423),G1H2(424),G1H2(425),G1H2(426),G1H2(427),2)
  call HG1shiftOLR(G1H2(424),9,2)
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(15))
  call Hotf_5pt_reduction(G2H2(169),RedSet_5(3),mass5set(:,2),  & 
G1H2(42),G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(428),8,2)
  call Hotf_4pt_reduction(G2H2(172),RedSet_4(5),mass4set(:,2),  & 
G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),2)
  call HG1shiftOLR(G1H2(434),9,2)
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(22),n2h1(16))
  call Hotf_5pt_reduction(G2H2(177),RedSet_5(3),mass5set(:,3),  & 
G1H2(44),G1H2(438),G1H2(439),G1H2(440),G1H2(441),G1H2(442),2)
  call HG1shiftOLR(G1H2(438),8,2)
  call Hotf_4pt_reduction(G2H2(180),RedSet_4(5),mass4set(:,3),  & 
G1H2(443),G1H2(444),G1H2(445),G1H2(446),G1H2(447),2)
  call HG1shiftOLR(G1H2(444),9,2)
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(17))
  call Hotf_5pt_reduction(G2H2(185),RedSet_5(3),mass5set(:,3),  & 
G1H2(46),G1H2(448),G1H2(449),G1H2(450),G1H2(451),G1H2(452),2)
  call HG1shiftOLR(G1H2(448),8,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(5),mass4set(:,3),  & 
G1H2(453),G1H2(454),G1H2(455),G1H2(456),G1H2(457),2)
  call HG1shiftOLR(G1H2(454),9,2)
  call Hloop_AV_Q(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(24),n2h1(18))
  call Hotf_5pt_reduction(G2H2(193),RedSet_5(3),mass5set(:,1),  & 
G1H2(48),G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),2)
  call HG1shiftOLR(G1H2(458),8,2)
  call Hotf_4pt_reduction(G2H2(196),RedSet_4(5),mass4set(:,1),  & 
G1H2(463),G1H2(464),G1H2(465),G1H2(466),G1H2(467),2)
  call HG1shiftOLR(G1H2(464),9,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(50),23,ex4(:),8,G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(3),mass5set(:,1),  & 
G1H2(50),G1H2(468),G1H2(469),G1H2(470),G1H2(471),G1H2(472),2)
  call HG1shiftOLR(G1H2(468),8,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(5),mass4set(:,1),  & 
G1H2(473),G1H2(474),G1H2(475),G1H2(476),G1H2(477),2)
  call HG1shiftOLR(G1H2(474),9,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(52),23,ex4(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hotf_5pt_reduction(G2H2(209),RedSet_5(3),mass5set(:,1),  & 
G1H2(52),G1H2(478),G1H2(479),G1H2(480),G1H2(481),G1H2(482),2)
  call HG1shiftOLR(G1H2(478),8,2)
  call Hotf_4pt_reduction(G2H2(212),RedSet_4(5),mass4set(:,1),  & 
G1H2(483),G1H2(484),G1H2(485),G1H2(486),G1H2(487),2)
  call HG1shiftOLR(G1H2(484),9,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(54),23,ex4(:),8,G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hotf_5pt_reduction(G2H2(217),RedSet_5(4),mass5set(:,1),  & 
G1H2(54),G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),2)
  call HG1shiftOLR(G1H2(488),4,2)
  call Hotf_4pt_reduction(G2H2(220),RedSet_4(4),mass4set(:,1),  & 
G1H2(493),G1H2(494),G1H2(495),G1H2(496),G1H2(497),2)
  call HG1shiftOLR(G1H2(494),12,2)
  call Hloop_QV_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(19))
  call Hotf_5pt_reduction(G2H2(225),RedSet_5(4),mass5set(:,2),  & 
G1H2(56),G1H2(498),G1H2(499),G1H2(500),G1H2(501),G1H2(502),2)
  call HG1shiftOLR(G1H2(498),4,2)
  call Hotf_4pt_reduction(G2H2(228),RedSet_4(4),mass4set(:,2),  & 
G1H2(503),G1H2(504),G1H2(505),G1H2(506),G1H2(507),2)
  call HG1shiftOLR(G1H2(504),12,2)
  call Hloop_QV_A(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(29),n2h1(20))
  call Hotf_5pt_reduction(G2H2(233),RedSet_5(4),mass5set(:,1),  & 
G1H2(58),G1H2(508),G1H2(509),G1H2(510),G1H2(511),G1H2(512),2)
  call HG1shiftOLR(G1H2(508),4,2)
  call Hotf_4pt_reduction(G2H2(236),RedSet_4(4),mass4set(:,1),  & 
G1H2(513),G1H2(514),G1H2(515),G1H2(516),G1H2(517),2)
  call HG1shiftOLR(G1H2(514),12,2)
  call Hloop_AV_Q(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(21))
  call Hotf_5pt_reduction(G2H2(241),RedSet_5(4),mass5set(:,2),  & 
G1H2(60),G1H2(518),G1H2(519),G1H2(520),G1H2(521),G1H2(522),2)
  call HG1shiftOLR(G1H2(518),4,2)
  call Hotf_4pt_reduction(G2H2(244),RedSet_4(4),mass4set(:,2),  & 
G1H2(523),G1H2(524),G1H2(525),G1H2(526),G1H2(527),2)
  call HG1shiftOLR(G1H2(524),12,2)
  call Hloop_AV_Q(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(22))
  call Hotf_5pt_reduction(G2H2(249),RedSet_5(4),mass5set(:,3),  & 
G1H2(62),G1H2(528),G1H2(529),G1H2(530),G1H2(531),G1H2(532),2)
  call HG1shiftOLR(G1H2(528),4,2)
  call Hotf_4pt_reduction(G2H2(252),RedSet_4(4),mass4set(:,3),  & 
G1H2(533),G1H2(534),G1H2(535),G1H2(536),G1H2(537),2)
  call HG1shiftOLR(G1H2(534),12,2)
  call Hloop_QV_A(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(32),n2h1(23))
  call Hotf_5pt_reduction(G2H2(257),RedSet_5(4),mass5set(:,3),  & 
G1H2(64),G1H2(538),G1H2(539),G1H2(540),G1H2(541),G1H2(542),2)
  call HG1shiftOLR(G1H2(538),4,2)
  call Hotf_4pt_reduction(G2H2(260),RedSet_4(4),mass4set(:,3),  & 
G1H2(543),G1H2(544),G1H2(545),G1H2(546),G1H2(547),2)
  call HG1shiftOLR(G1H2(544),12,2)
  call Hloop_AV_Q(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(24))
  call Hotf_5pt_reduction(G2H2(265),RedSet_5(4),mass5set(:,1),  & 
G1H2(66),G1H2(548),G1H2(549),G1H2(550),G1H2(551),G1H2(552),2)
  call HG1shiftOLR(G1H2(548),4,2)
  call Hotf_4pt_reduction(G2H2(268),RedSet_4(4),mass4set(:,1),  & 
G1H2(553),G1H2(554),G1H2(555),G1H2(556),G1H2(557),2)
  call HG1shiftOLR(G1H2(554),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(68),27,ex3(:),4,G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hotf_5pt_reduction(G2H2(273),RedSet_5(4),mass5set(:,1),  & 
G1H2(68),G1H2(558),G1H2(559),G1H2(560),G1H2(561),G1H2(562),2)
  call HG1shiftOLR(G1H2(558),4,2)
  call Hotf_4pt_reduction(G2H2(276),RedSet_4(4),mass4set(:,1),  & 
G1H2(563),G1H2(564),G1H2(565),G1H2(566),G1H2(567),2)
  call HG1shiftOLR(G1H2(564),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(70),27,ex3(:),G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hotf_5pt_reduction(G2H2(281),RedSet_5(4),mass5set(:,1),  & 
G1H2(70),G1H2(568),G1H2(569),G1H2(570),G1H2(571),G1H2(572),2)
  call HG1shiftOLR(G1H2(568),4,2)
  call Hotf_4pt_reduction(G2H2(284),RedSet_4(4),mass4set(:,1),  & 
G1H2(573),G1H2(574),G1H2(575),G1H2(576),G1H2(577),2)
  call HG1shiftOLR(G1H2(574),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(72),27,ex3(:),4,G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hotf_5pt_reduction(G2H2(289),RedSet_5(5),mass5set(:,1),  & 
G1H2(72),G1H2(578),G1H2(579),G1H2(580),G1H2(581),G1H2(582),2)
  call HG1shiftOLR(G1H2(578),8,2)
  call Hotf_4pt_reduction(G2H2(292),RedSet_4(8),mass4set(:,1),  & 
G1H2(583),G1H2(584),G1H2(585),G1H2(586),G1H2(587),2)
  call HG1shiftOLR(G1H2(584),12,2)
  call Hloop_AV_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(25))
  call Hotf_5pt_reduction(G2H2(297),RedSet_5(5),mass5set(:,2),  & 
G1H2(74),G1H2(588),G1H2(589),G1H2(590),G1H2(591),G1H2(592),2)
  call HG1shiftOLR(G1H2(588),8,2)
  call Hotf_4pt_reduction(G2H2(300),RedSet_4(8),mass4set(:,2),  & 
G1H2(593),G1H2(594),G1H2(595),G1H2(596),G1H2(597),2)
  call HG1shiftOLR(G1H2(594),12,2)
  call Hloop_AV_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(38),n2h1(26))
  call Hotf_5pt_reduction(G2H2(305),RedSet_5(5),mass5set(:,1),  & 
G1H2(76),G1H2(598),G1H2(599),G1H2(600),G1H2(601),G1H2(602),2)
  call HG1shiftOLR(G1H2(598),8,2)
  call Hotf_4pt_reduction(G2H2(308),RedSet_4(8),mass4set(:,1),  & 
G1H2(603),G1H2(604),G1H2(605),G1H2(606),G1H2(607),2)
  call HG1shiftOLR(G1H2(604),12,2)
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(27))
  call Hotf_5pt_reduction(G2H2(313),RedSet_5(5),mass5set(:,2),  & 
G1H2(78),G1H2(608),G1H2(609),G1H2(610),G1H2(611),G1H2(612),2)
  call HG1shiftOLR(G1H2(608),8,2)
  call Hotf_4pt_reduction(G2H2(316),RedSet_4(8),mass4set(:,2),  & 
G1H2(613),G1H2(614),G1H2(615),G1H2(616),G1H2(617),2)
  call HG1shiftOLR(G1H2(614),12,2)
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(28))
  call Hotf_5pt_reduction(G2H2(321),RedSet_5(5),mass5set(:,3),  & 
G1H2(80),G1H2(618),G1H2(619),G1H2(620),G1H2(621),G1H2(622),2)
  call HG1shiftOLR(G1H2(618),8,2)
  call Hotf_4pt_reduction(G2H2(324),RedSet_4(8),mass4set(:,3),  & 
G1H2(623),G1H2(624),G1H2(625),G1H2(626),G1H2(627),2)
  call HG1shiftOLR(G1H2(624),12,2)
  call Hloop_AV_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(29))
  call Hotf_5pt_reduction(G2H2(329),RedSet_5(5),mass5set(:,3),  & 
G1H2(82),G1H2(628),G1H2(629),G1H2(630),G1H2(631),G1H2(632),2)
  call HG1shiftOLR(G1H2(628),8,2)
  call Hotf_4pt_reduction(G2H2(332),RedSet_4(8),mass4set(:,3),  & 
G1H2(633),G1H2(634),G1H2(635),G1H2(636),G1H2(637),2)
  call HG1shiftOLR(G1H2(634),12,2)
  call Hloop_QV_A(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(30))
  call Hotf_5pt_reduction(G2H2(337),RedSet_5(5),mass5set(:,1),  & 
G1H2(84),G1H2(638),G1H2(639),G1H2(640),G1H2(641),G1H2(642),2)
  call HG1shiftOLR(G1H2(638),8,2)
  call Hotf_4pt_reduction(G2H2(340),RedSet_4(8),mass4set(:,1),  & 
G1H2(643),G1H2(644),G1H2(645),G1H2(646),G1H2(647),2)
  call HG1shiftOLR(G1H2(644),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(86),23,ex4(:),G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hotf_5pt_reduction(G2H2(345),RedSet_5(5),mass5set(:,1),  & 
G1H2(86),G1H2(648),G1H2(649),G1H2(650),G1H2(651),G1H2(652),2)
  call HG1shiftOLR(G1H2(648),8,2)
  call Hotf_4pt_reduction(G2H2(348),RedSet_4(8),mass4set(:,1),  & 
G1H2(653),G1H2(654),G1H2(655),G1H2(656),G1H2(657),2)
  call HG1shiftOLR(G1H2(654),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(88),23,ex4(:),8,G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hotf_5pt_reduction(G2H2(353),RedSet_5(5),mass5set(:,1),  & 
G1H2(88),G1H2(658),G1H2(659),G1H2(660),G1H2(661),G1H2(662),2)
  call HG1shiftOLR(G1H2(658),8,2)
  call Hotf_4pt_reduction(G2H2(356),RedSet_4(8),mass4set(:,1),  & 
G1H2(663),G1H2(664),G1H2(665),G1H2(666),G1H2(667),2)
  call HG1shiftOLR(G1H2(664),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(90),23,ex4(:),8,G2tensor(45),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hotf_5pt_reduction(G2H2(361),RedSet_5(6),mass5set(:,1),  & 
G1H2(90),G1H2(668),G1H2(669),G1H2(670),G1H2(671),G1H2(672),2)
  call HG1shiftOLR(G1H2(668),4,2)
  call Hotf_4pt_reduction(G2H2(364),RedSet_4(8),mass4set(:,1),  & 
G1H2(673),G1H2(674),G1H2(675),G1H2(676),G1H2(677),2)
  call HG1shiftOLR(G1H2(674),12,2)
  call Hloop_AV_Q(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(31))
  call Hotf_5pt_reduction(G2H2(369),RedSet_5(6),mass5set(:,2),  & 
G1H2(92),G1H2(678),G1H2(679),G1H2(680),G1H2(681),G1H2(682),2)
  call HG1shiftOLR(G1H2(678),4,2)
  call Hotf_4pt_reduction(G2H2(372),RedSet_4(8),mass4set(:,2),  & 
G1H2(683),G1H2(684),G1H2(685),G1H2(686),G1H2(687),2)
  call HG1shiftOLR(G1H2(684),12,2)
  call Hloop_AV_Q(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(32))
  call Hotf_5pt_reduction(G2H2(377),RedSet_5(6),mass5set(:,1),  & 
G1H2(94),G1H2(688),G1H2(689),G1H2(690),G1H2(691),G1H2(692),2)
  call HG1shiftOLR(G1H2(688),4,2)
  call Hotf_4pt_reduction(G2H2(380),RedSet_4(8),mass4set(:,1),  & 
G1H2(693),G1H2(694),G1H2(695),G1H2(696),G1H2(697),2)
  call HG1shiftOLR(G1H2(694),12,2)
  call Hloop_QV_A(ntryL,G1H2(96),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(33))
  call Hotf_5pt_reduction(G2H2(385),RedSet_5(6),mass5set(:,2),  & 
G1H2(96),G1H2(698),G1H2(699),G1H2(700),G1H2(701),G1H2(702),2)
  call HG1shiftOLR(G1H2(698),4,2)
  call Hotf_4pt_reduction(G2H2(388),RedSet_4(8),mass4set(:,2),  & 
G1H2(703),G1H2(704),G1H2(705),G1H2(706),G1H2(707),2)
  call HG1shiftOLR(G1H2(704),12,2)
  call Hloop_QV_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(34))
  call Hotf_5pt_reduction(G2H2(393),RedSet_5(6),mass5set(:,3),  & 
G1H2(98),G1H2(708),G1H2(709),G1H2(710),G1H2(711),G1H2(712),2)
  call HG1shiftOLR(G1H2(708),4,2)
  call Hotf_4pt_reduction(G2H2(396),RedSet_4(8),mass4set(:,3),  & 
G1H2(713),G1H2(714),G1H2(715),G1H2(716),G1H2(717),2)
  call HG1shiftOLR(G1H2(714),12,2)
  call Hloop_AV_Q(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(35))
  call Hotf_5pt_reduction(G2H2(401),RedSet_5(6),mass5set(:,3),  & 
G1H2(100),G1H2(718),G1H2(719),G1H2(720),G1H2(721),G1H2(722),2)
  call HG1shiftOLR(G1H2(718),4,2)
  call Hotf_4pt_reduction(G2H2(404),RedSet_4(8),mass4set(:,3),  & 
G1H2(723),G1H2(724),G1H2(725),G1H2(726),G1H2(727),2)
  call HG1shiftOLR(G1H2(724),12,2)
  call Hloop_QV_A(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(36))
  call Hotf_5pt_reduction(G2H2(409),RedSet_5(6),mass5set(:,1),  & 
G1H2(102),G1H2(728),G1H2(729),G1H2(730),G1H2(731),G1H2(732),2)
  call HG1shiftOLR(G1H2(728),4,2)
  call Hotf_4pt_reduction(G2H2(412),RedSet_4(8),mass4set(:,1),  & 
G1H2(733),G1H2(734),G1H2(735),G1H2(736),G1H2(737),2)
  call HG1shiftOLR(G1H2(734),12,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(104),27,ex3(:),G2tensor(52),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hotf_5pt_reduction(G2H2(417),RedSet_5(6),mass5set(:,1),  & 
G1H2(104),G1H2(738),G1H2(739),G1H2(740),G1H2(741),G1H2(742),2)
  call HG1shiftOLR(G1H2(738),4,2)
  call Hotf_4pt_reduction(G2H2(420),RedSet_4(8),mass4set(:,1),  & 
G1H2(743),G1H2(744),G1H2(745),G1H2(746),G1H2(747),2)
  call HG1shiftOLR(G1H2(744),12,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(106),27,ex3(:),4,G2tensor(53),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hotf_5pt_reduction(G2H2(425),RedSet_5(6),mass5set(:,1),  & 
G1H2(106),G1H2(748),G1H2(749),G1H2(750),G1H2(751),G1H2(752),2)
  call HG1shiftOLR(G1H2(748),4,2)
  call Hotf_4pt_reduction(G2H2(428),RedSet_4(8),mass4set(:,1),  & 
G1H2(753),G1H2(754),G1H2(755),G1H2(756),G1H2(757),2)
  call HG1shiftOLR(G1H2(754),12,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(108),27,ex3(:),4,G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hotf_5pt_reduction(G2H2(433),RedSet_5(7),mass5set(:,1),  & 
G1H2(108),G1H2(758),G1H2(759),G1H2(760),G1H2(761),G1H2(762),2)
  call HG1shiftOLR(G1H2(758),8,2)
  call Hotf_4pt_reduction(G2H2(436),RedSet_4(10),mass4set(:,1),  & 
G1H2(763),G1H2(764),G1H2(765),G1H2(766),G1H2(767),2)
  call HG1shiftOLR(G1H2(764),9,2)
  call Hloop_QV_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(37))
  call Hotf_5pt_reduction(G2H2(441),RedSet_5(7),mass5set(:,2),  & 
G1H2(110),G1H2(768),G1H2(769),G1H2(770),G1H2(771),G1H2(772),2)
  call HG1shiftOLR(G1H2(768),8,2)
  call Hotf_4pt_reduction(G2H2(444),RedSet_4(10),mass4set(:,2),  & 
G1H2(773),G1H2(774),G1H2(775),G1H2(776),G1H2(777),2)
  call HG1shiftOLR(G1H2(774),9,2)
  call Hloop_QV_A(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(38))
  call Hotf_5pt_reduction(G2H2(449),RedSet_5(7),mass5set(:,1),  & 
G1H2(112),G1H2(778),G1H2(779),G1H2(780),G1H2(781),G1H2(782),2)
  call HG1shiftOLR(G1H2(778),8,2)
  call Hotf_4pt_reduction(G2H2(452),RedSet_4(10),mass4set(:,1),  & 
G1H2(783),G1H2(784),G1H2(785),G1H2(786),G1H2(787),2)
  call HG1shiftOLR(G1H2(784),9,2)
  call Hloop_AV_Q(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(39))
  call Hotf_5pt_reduction(G2H2(457),RedSet_5(7),mass5set(:,2),  & 
G1H2(114),G1H2(788),G1H2(789),G1H2(790),G1H2(791),G1H2(792),2)
  call HG1shiftOLR(G1H2(788),8,2)
  call Hotf_4pt_reduction(G2H2(460),RedSet_4(10),mass4set(:,2),  & 
G1H2(793),G1H2(794),G1H2(795),G1H2(796),G1H2(797),2)
  call HG1shiftOLR(G1H2(794),9,2)
  call Hloop_AV_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(58),n2h1(40))
  call Hotf_5pt_reduction(G2H2(465),RedSet_5(7),mass5set(:,3),  & 
G1H2(116),G1H2(798),G1H2(799),G1H2(800),G1H2(801),G1H2(802),2)
  call HG1shiftOLR(G1H2(798),8,2)
  call Hotf_4pt_reduction(G2H2(468),RedSet_4(10),mass4set(:,3),  & 
G1H2(803),G1H2(804),G1H2(805),G1H2(806),G1H2(807),2)
  call HG1shiftOLR(G1H2(804),9,2)
  call Hloop_QV_A(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(41))
  call Hotf_5pt_reduction(G2H2(473),RedSet_5(7),mass5set(:,3),  & 
G1H2(118),G1H2(808),G1H2(809),G1H2(810),G1H2(811),G1H2(812),2)
  call HG1shiftOLR(G1H2(808),8,2)
  call Hotf_4pt_reduction(G2H2(476),RedSet_4(10),mass4set(:,3),  & 
G1H2(813),G1H2(814),G1H2(815),G1H2(816),G1H2(817),2)
  call HG1shiftOLR(G1H2(814),9,2)
  call Hloop_AV_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(42))
  call Hotf_5pt_reduction(G2H2(481),RedSet_5(7),mass5set(:,1),  & 
G1H2(120),G1H2(818),G1H2(819),G1H2(820),G1H2(821),G1H2(822),2)
  call HG1shiftOLR(G1H2(818),8,2)
  call Hotf_4pt_reduction(G2H2(484),RedSet_4(10),mass4set(:,1),  & 
G1H2(823),G1H2(824),G1H2(825),G1H2(826),G1H2(827),2)
  call HG1shiftOLR(G1H2(824),9,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(122),23,ex4(:),8,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hotf_5pt_reduction(G2H2(489),RedSet_5(7),mass5set(:,1),  & 
G1H2(122),G1H2(828),G1H2(829),G1H2(830),G1H2(831),G1H2(832),2)
  call HG1shiftOLR(G1H2(828),8,2)
  call Hotf_4pt_reduction(G2H2(492),RedSet_4(10),mass4set(:,1),  & 
G1H2(833),G1H2(834),G1H2(835),G1H2(836),G1H2(837),2)
  call HG1shiftOLR(G1H2(834),9,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(124),23,ex4(:),G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hotf_5pt_reduction(G2H2(497),RedSet_5(7),mass5set(:,1),  & 
G1H2(124),G1H2(838),G1H2(839),G1H2(840),G1H2(841),G1H2(842),2)
  call HG1shiftOLR(G1H2(838),8,2)
  call Hotf_4pt_reduction(G2H2(500),RedSet_4(10),mass4set(:,1),  & 
G1H2(843),G1H2(844),G1H2(845),G1H2(846),G1H2(847),2)
  call HG1shiftOLR(G1H2(844),9,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(126),23,ex4(:),8,G2tensor(63),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hotf_5pt_reduction(G2H2(505),RedSet_5(8),mass5set(:,1),  & 
G1H2(126),G1H2(848),G1H2(849),G1H2(850),G1H2(851),G1H2(852),2)
  call HG1shiftOLR(G1H2(848),4,2)
  call Hotf_4pt_reduction(G2H2(508),RedSet_4(11),mass4set(:,1),  & 
G1H2(853),G1H2(854),G1H2(855),G1H2(856),G1H2(857),2)
  call HG1shiftOLR(G1H2(854),5,2)
  call Hloop_AV_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(43))
  call Hotf_5pt_reduction(G2H2(513),RedSet_5(8),mass5set(:,2),  & 
G1H2(128),G1H2(858),G1H2(859),G1H2(860),G1H2(861),G1H2(862),2)
  call HG1shiftOLR(G1H2(858),4,2)
  call Hotf_4pt_reduction(G2H2(516),RedSet_4(11),mass4set(:,2),  & 
G1H2(863),G1H2(864),G1H2(865),G1H2(866),G1H2(867),2)
  call HG1shiftOLR(G1H2(864),5,2)
  call Hloop_AV_Q(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(44))
  call Hotf_5pt_reduction(G2H2(521),RedSet_5(8),mass5set(:,1),  & 
G1H2(130),G1H2(868),G1H2(869),G1H2(870),G1H2(871),G1H2(872),2)
  call HG1shiftOLR(G1H2(868),4,2)
  call Hotf_4pt_reduction(G2H2(524),RedSet_4(11),mass4set(:,1),  & 
G1H2(873),G1H2(874),G1H2(875),G1H2(876),G1H2(877),2)
  call HG1shiftOLR(G1H2(874),5,2)
  call Hloop_QV_A(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(45))
  call Hotf_5pt_reduction(G2H2(529),RedSet_5(8),mass5set(:,2),  & 
G1H2(132),G1H2(878),G1H2(879),G1H2(880),G1H2(881),G1H2(882),2)
  call HG1shiftOLR(G1H2(878),4,2)
  call Hotf_4pt_reduction(G2H2(532),RedSet_4(11),mass4set(:,2),  & 
G1H2(883),G1H2(884),G1H2(885),G1H2(886),G1H2(887),2)
  call HG1shiftOLR(G1H2(884),5,2)
  call Hloop_QV_A(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(46))
  call Hotf_5pt_reduction(G2H2(537),RedSet_5(8),mass5set(:,3),  & 
G1H2(134),G1H2(888),G1H2(889),G1H2(890),G1H2(891),G1H2(892),2)
  call HG1shiftOLR(G1H2(888),4,2)
  call Hotf_4pt_reduction(G2H2(540),RedSet_4(11),mass4set(:,3),  & 
G1H2(893),G1H2(894),G1H2(895),G1H2(896),G1H2(897),2)
  call HG1shiftOLR(G1H2(894),5,2)
  call Hloop_AV_Q(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(68),n2h1(47))
  call Hotf_5pt_reduction(G2H2(545),RedSet_5(8),mass5set(:,3),  & 
G1H2(136),G1H2(898),G1H2(899),G1H2(900),G1H2(901),G1H2(902),2)
  call HG1shiftOLR(G1H2(898),4,2)
  call Hotf_4pt_reduction(G2H2(548),RedSet_4(11),mass4set(:,3),  & 
G1H2(903),G1H2(904),G1H2(905),G1H2(906),G1H2(907),2)
  call HG1shiftOLR(G1H2(904),5,2)
  call Hloop_QV_A(ntryL,G1H2(138),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(48))
  call Hotf_5pt_reduction(G2H2(553),RedSet_5(8),mass5set(:,1),  & 
G1H2(138),G1H2(908),G1H2(909),G1H2(910),G1H2(911),G1H2(912),2)
  call HG1shiftOLR(G1H2(908),4,2)
  call Hotf_4pt_reduction(G2H2(556),RedSet_4(11),mass4set(:,1),  & 
G1H2(913),G1H2(914),G1H2(915),G1H2(916),G1H2(917),2)
  call HG1shiftOLR(G1H2(914),5,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(140),27,ex3(:),G2tensor(70),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hotf_5pt_reduction(G2H2(561),RedSet_5(8),mass5set(:,1),  & 
G1H2(140),G1H2(918),G1H2(919),G1H2(920),G1H2(921),G1H2(922),2)
  call HG1shiftOLR(G1H2(918),4,2)
  call Hotf_4pt_reduction(G2H2(564),RedSet_4(11),mass4set(:,1),  & 
G1H2(923),G1H2(924),G1H2(925),G1H2(926),G1H2(927),2)
  call HG1shiftOLR(G1H2(924),5,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(142),27,ex3(:),4,G2tensor(71),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hotf_5pt_reduction(G2H2(569),RedSet_5(8),mass5set(:,1),  & 
G1H2(142),G1H2(928),G1H2(929),G1H2(930),G1H2(931),G1H2(932),2)
  call HG1shiftOLR(G1H2(928),4,2)
  call Hotf_4pt_reduction(G2H2(572),RedSet_4(11),mass4set(:,1),  & 
G1H2(933),G1H2(934),G1H2(935),G1H2(936),G1H2(937),2)
  call HG1shiftOLR(G1H2(934),5,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(144),27,ex3(:),4,G2tensor(72),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hotf_5pt_reduction(G2H2(577),RedSet_5(9),mass5set(:,1),  & 
G1H2(144),G1H2(938),G1H2(939),G1H2(940),G1H2(941),G1H2(942),2)
  call HG1shiftOLR(G1H2(938),8,2)
  call Hotf_4pt_reduction(G2H2(580),RedSet_4(12),mass4set(:,1),  & 
G1H2(943),G1H2(944),G1H2(945),G1H2(946),G1H2(947),2)
  call HG1shiftOLR(G1H2(944),10,2)
  call Hloop_AV_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(49))
  call Hotf_5pt_reduction(G2H2(585),RedSet_5(9),mass5set(:,2),  & 
G1H2(146),G1H2(948),G1H2(949),G1H2(950),G1H2(951),G1H2(952),2)
  call HG1shiftOLR(G1H2(948),8,2)
  call Hotf_4pt_reduction(G2H2(588),RedSet_4(12),mass4set(:,2),  & 
G1H2(953),G1H2(954),G1H2(955),G1H2(956),G1H2(957),2)
  call HG1shiftOLR(G1H2(954),10,2)
  call Hloop_AV_Q(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(50))
  call Hotf_5pt_reduction(G2H2(593),RedSet_5(9),mass5set(:,1),  & 
G1H2(148),G1H2(958),G1H2(959),G1H2(960),G1H2(961),G1H2(962),2)
  call HG1shiftOLR(G1H2(958),8,2)
  call Hotf_4pt_reduction(G2H2(596),RedSet_4(12),mass4set(:,1),  & 
G1H2(963),G1H2(964),G1H2(965),G1H2(966),G1H2(967),2)
  call HG1shiftOLR(G1H2(964),10,2)
  call Hloop_QV_A(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(51))
  call Hotf_5pt_reduction(G2H2(601),RedSet_5(9),mass5set(:,2),  & 
G1H2(150),G1H2(968),G1H2(969),G1H2(970),G1H2(971),G1H2(972),2)
  call HG1shiftOLR(G1H2(968),8,2)
  call Hotf_4pt_reduction(G2H2(604),RedSet_4(12),mass4set(:,2),  & 
G1H2(973),G1H2(974),G1H2(975),G1H2(976),G1H2(977),2)
  call HG1shiftOLR(G1H2(974),10,2)
  call Hloop_QV_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(76),n2h1(52))
  call Hotf_5pt_reduction(G2H2(609),RedSet_5(9),mass5set(:,3),  & 
G1H2(152),G1H2(978),G1H2(979),G1H2(980),G1H2(981),G1H2(982),2)
  call HG1shiftOLR(G1H2(978),8,2)
  call Hotf_4pt_reduction(G2H2(612),RedSet_4(12),mass4set(:,3),  & 
G1H2(983),G1H2(984),G1H2(985),G1H2(986),G1H2(987),2)
  call HG1shiftOLR(G1H2(984),10,2)
  call Hloop_AV_Q(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(53))
  call Hotf_5pt_reduction(G2H2(617),RedSet_5(9),mass5set(:,3),  & 
G1H2(154),G1H2(988),G1H2(989),G1H2(990),G1H2(991),G1H2(992),2)
  call HG1shiftOLR(G1H2(988),8,2)
  call Hotf_4pt_reduction(G2H2(620),RedSet_4(12),mass4set(:,3),  & 
G1H2(993),G1H2(994),G1H2(995),G1H2(996),G1H2(997),2)
  call HG1shiftOLR(G1H2(994),10,2)
  call Hloop_QV_A(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(54))
  call Hotf_5pt_reduction(G2H2(625),RedSet_5(9),mass5set(:,1),  & 
G1H2(156),G1H2(998),G1H2(999),G1H2(1000),G1H2(1001),G1H2(1002),2)
  call HG1shiftOLR(G1H2(998),8,2)
  call Hotf_4pt_reduction(G2H2(628),RedSet_4(12),mass4set(:,1),  & 
G1H2(1003),G1H2(1004),G1H2(1005),G1H2(1006),G1H2(1007),2)
  call HG1shiftOLR(G1H2(1004),10,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(158),23,ex4(:),G2tensor(79),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hotf_5pt_reduction(G2H2(633),RedSet_5(9),mass5set(:,1),  & 
G1H2(158),G1H2(1008),G1H2(1009),G1H2(1010),G1H2(1011),G1H2(1012),2)
  call HG1shiftOLR(G1H2(1008),8,2)
  call Hotf_4pt_reduction(G2H2(636),RedSet_4(12),mass4set(:,1),  & 
G1H2(1013),G1H2(1014),G1H2(1015),G1H2(1016),G1H2(1017),2)
  call HG1shiftOLR(G1H2(1014),10,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(160),23,ex4(:),8,G2tensor(80),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hotf_5pt_reduction(G2H2(641),RedSet_5(9),mass5set(:,1),  & 
G1H2(160),G1H2(1018),G1H2(1019),G1H2(1020),G1H2(1021),G1H2(1022),2)
  call HG1shiftOLR(G1H2(1018),8,2)
  call Hotf_4pt_reduction(G2H2(644),RedSet_4(12),mass4set(:,1),  & 
G1H2(1023),G1H2(1024),G1H2(1025),G1H2(1026),G1H2(1027),2)
  call HG1shiftOLR(G1H2(1024),10,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(162),23,ex4(:),8,G2tensor(81),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hotf_5pt_reduction(G2H2(649),RedSet_5(10),mass5set(:,1),  & 
G1H2(162),G1H2(1028),G1H2(1029),G1H2(1030),G1H2(1031),G1H2(1032),2)
  call HG1shiftOLR(G1H2(1028),2,2)
  call Hotf_4pt_reduction(G2H2(652),RedSet_4(12),mass4set(:,1),  & 
G1H2(1033),G1H2(1034),G1H2(1035),G1H2(1036),G1H2(1037),2)
  call HG1shiftOLR(G1H2(1034),10,2)
  call Hloop_AV_Q(ntryL,G1H2(164),ex2(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(55))
  call Hotf_5pt_reduction(G2H2(657),RedSet_5(10),mass5set(:,2),  & 
G1H2(164),G1H2(1038),G1H2(1039),G1H2(1040),G1H2(1041),G1H2(1042),2)
  call HG1shiftOLR(G1H2(1038),2,2)
  call Hotf_4pt_reduction(G2H2(660),RedSet_4(12),mass4set(:,2),  & 
G1H2(1043),G1H2(1044),G1H2(1045),G1H2(1046),G1H2(1047),2)
  call HG1shiftOLR(G1H2(1044),10,2)
  call Hloop_AV_Q(ntryL,G1H2(166),ex2(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(83),n2h1(56))
  call Hotf_5pt_reduction(G2H2(665),RedSet_5(10),mass5set(:,1),  & 
G1H2(166),G1H2(1048),G1H2(1049),G1H2(1050),G1H2(1051),G1H2(1052),2)
  call HG1shiftOLR(G1H2(1048),2,2)
  call Hotf_4pt_reduction(G2H2(668),RedSet_4(12),mass4set(:,1),  & 
G1H2(1053),G1H2(1054),G1H2(1055),G1H2(1056),G1H2(1057),2)
  call HG1shiftOLR(G1H2(1054),10,2)
  call Hloop_QV_A(ntryL,G1H2(168),ex2(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(57))
  call Hotf_5pt_reduction(G2H2(673),RedSet_5(10),mass5set(:,2),  & 
G1H2(168),G1H2(1058),G1H2(1059),G1H2(1060),G1H2(1061),G1H2(1062),2)
  call HG1shiftOLR(G1H2(1058),2,2)
  call Hotf_4pt_reduction(G2H2(676),RedSet_4(12),mass4set(:,2),  & 
G1H2(1063),G1H2(1064),G1H2(1065),G1H2(1066),G1H2(1067),2)
  call HG1shiftOLR(G1H2(1064),10,2)
  call Hloop_QV_A(ntryL,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(85),n2h1(58))
  call Hotf_5pt_reduction(G2H2(681),RedSet_5(10),mass5set(:,3),  & 
G1H2(170),G1H2(1068),G1H2(1069),G1H2(1070),G1H2(1071),G1H2(1072),2)
  call HG1shiftOLR(G1H2(1068),2,2)
  call Hotf_4pt_reduction(G2H2(684),RedSet_4(12),mass4set(:,3),  & 
G1H2(1073),G1H2(1074),G1H2(1075),G1H2(1076),G1H2(1077),2)
  call HG1shiftOLR(G1H2(1074),10,2)
  call Hloop_AV_Q(ntryL,G1H2(172),ex2(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(86),n2h1(59))
  call Hotf_5pt_reduction(G2H2(689),RedSet_5(10),mass5set(:,3),  & 
G1H2(172),G1H2(1078),G1H2(1079),G1H2(1080),G1H2(1081),G1H2(1082),2)
  call HG1shiftOLR(G1H2(1078),2,2)
  call Hotf_4pt_reduction(G2H2(692),RedSet_4(12),mass4set(:,3),  & 
G1H2(1083),G1H2(1084),G1H2(1085),G1H2(1086),G1H2(1087),2)
  call HG1shiftOLR(G1H2(1084),10,2)
  call Hloop_QV_A(ntryL,G1H2(174),ex2(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(60))
  call Hotf_5pt_reduction(G2H2(697),RedSet_5(10),mass5set(:,1),  & 
G1H2(174),G1H2(1088),G1H2(1089),G1H2(1090),G1H2(1091),G1H2(1092),2)
  call HG1shiftOLR(G1H2(1088),2,2)
  call Hotf_4pt_reduction(G2H2(700),RedSet_4(12),mass4set(:,1),  & 
G1H2(1093),G1H2(1094),G1H2(1095),G1H2(1096),G1H2(1097),2)
  call HG1shiftOLR(G1H2(1094),10,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(176),29,ex2(:),G2tensor(88),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hotf_5pt_reduction(G2H2(705),RedSet_5(10),mass5set(:,1),  & 
G1H2(176),G1H2(1098),G1H2(1099),G1H2(1100),G1H2(1101),G1H2(1102),2)
  call HG1shiftOLR(G1H2(1098),2,2)
  call Hotf_4pt_reduction(G2H2(708),RedSet_4(12),mass4set(:,1),  & 
G1H2(1103),G1H2(1104),G1H2(1105),G1H2(1106),G1H2(1107),2)
  call HG1shiftOLR(G1H2(1104),10,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(178),29,ex2(:),2,G2tensor(89),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hotf_5pt_reduction(G2H2(713),RedSet_5(10),mass5set(:,1),  & 
G1H2(178),G1H2(1108),G1H2(1109),G1H2(1110),G1H2(1111),G1H2(1112),2)
  call HG1shiftOLR(G1H2(1108),2,2)
  call Hotf_4pt_reduction(G2H2(716),RedSet_4(12),mass4set(:,1),  & 
G1H2(1113),G1H2(1114),G1H2(1115),G1H2(1116),G1H2(1117),2)
  call HG1shiftOLR(G1H2(1114),10,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(180),29,ex2(:),2,G2tensor(90),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hotf_5pt_reduction(G2H2(721),RedSet_5(11),mass5set(:,1),  & 
G1H2(180),G1H2(1118),G1H2(1119),G1H2(1120),G1H2(1121),G1H2(1122),2)
  call HG1shiftOLR(G1H2(1118),4,2)
  call Hotf_4pt_reduction(G2H2(724),RedSet_4(14),mass4set(:,1),  & 
G1H2(1123),G1H2(1124),G1H2(1125),G1H2(1126),G1H2(1127),2)
  call HG1shiftOLR(G1H2(1124),6,2)
  call Hloop_AV_Q(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(61))
  call Hotf_5pt_reduction(G2H2(729),RedSet_5(11),mass5set(:,2),  & 
G1H2(182),G1H2(1128),G1H2(1129),G1H2(1130),G1H2(1131),G1H2(1132),2)
  call HG1shiftOLR(G1H2(1128),4,2)
  call Hotf_4pt_reduction(G2H2(732),RedSet_4(14),mass4set(:,2),  & 
G1H2(1133),G1H2(1134),G1H2(1135),G1H2(1136),G1H2(1137),2)
  call HG1shiftOLR(G1H2(1134),6,2)
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(92),n2h1(62))
  call Hotf_5pt_reduction(G2H2(737),RedSet_5(11),mass5set(:,1),  & 
G1H2(184),G1H2(1138),G1H2(1139),G1H2(1140),G1H2(1141),G1H2(1142),2)
  call HG1shiftOLR(G1H2(1138),4,2)
  call Hotf_4pt_reduction(G2H2(740),RedSet_4(14),mass4set(:,1),  & 
G1H2(1143),G1H2(1144),G1H2(1145),G1H2(1146),G1H2(1147),2)
  call HG1shiftOLR(G1H2(1144),6,2)
  call Hloop_QV_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(63))
  call Hotf_5pt_reduction(G2H2(745),RedSet_5(11),mass5set(:,2),  & 
G1H2(186),G1H2(1148),G1H2(1149),G1H2(1150),G1H2(1151),G1H2(1152),2)
  call HG1shiftOLR(G1H2(1148),4,2)
  call Hotf_4pt_reduction(G2H2(748),RedSet_4(14),mass4set(:,2),  & 
G1H2(1153),G1H2(1154),G1H2(1155),G1H2(1156),G1H2(1157),2)
  call HG1shiftOLR(G1H2(1154),6,2)
  call Hloop_QV_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(94),n2h1(64))
  call Hotf_5pt_reduction(G2H2(753),RedSet_5(11),mass5set(:,3),  & 
G1H2(188),G1H2(1158),G1H2(1159),G1H2(1160),G1H2(1161),G1H2(1162),2)
  call HG1shiftOLR(G1H2(1158),4,2)
  call Hotf_4pt_reduction(G2H2(756),RedSet_4(14),mass4set(:,3),  & 
G1H2(1163),G1H2(1164),G1H2(1165),G1H2(1166),G1H2(1167),2)
  call HG1shiftOLR(G1H2(1164),6,2)
  call Hloop_AV_Q(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(95),n2h1(65))
  call Hotf_5pt_reduction(G2H2(761),RedSet_5(11),mass5set(:,3),  & 
G1H2(190),G1H2(1168),G1H2(1169),G1H2(1170),G1H2(1171),G1H2(1172),2)
  call HG1shiftOLR(G1H2(1168),4,2)
  call Hotf_4pt_reduction(G2H2(764),RedSet_4(14),mass4set(:,3),  & 
G1H2(1173),G1H2(1174),G1H2(1175),G1H2(1176),G1H2(1177),2)
  call HG1shiftOLR(G1H2(1174),6,2)
  call Hloop_QV_A(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(96),n2h1(66))
  call Hotf_5pt_reduction(G2H2(769),RedSet_5(11),mass5set(:,1),  & 
G1H2(192),G1H2(1178),G1H2(1179),G1H2(1180),G1H2(1181),G1H2(1182),2)
  call HG1shiftOLR(G1H2(1178),4,2)
  call Hotf_4pt_reduction(G2H2(772),RedSet_4(14),mass4set(:,1),  & 
G1H2(1183),G1H2(1184),G1H2(1185),G1H2(1186),G1H2(1187),2)
  call HG1shiftOLR(G1H2(1184),6,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(194),27,ex3(:),G2tensor(97),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hotf_5pt_reduction(G2H2(777),RedSet_5(11),mass5set(:,1),  & 
G1H2(194),G1H2(1188),G1H2(1189),G1H2(1190),G1H2(1191),G1H2(1192),2)
  call HG1shiftOLR(G1H2(1188),4,2)
  call Hotf_4pt_reduction(G2H2(780),RedSet_4(14),mass4set(:,1),  & 
G1H2(1193),G1H2(1194),G1H2(1195),G1H2(1196),G1H2(1197),2)
  call HG1shiftOLR(G1H2(1194),6,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(196),27,ex3(:),4,G2tensor(98),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hotf_5pt_reduction(G2H2(785),RedSet_5(11),mass5set(:,1),  & 
G1H2(196),G1H2(1198),G1H2(1199),G1H2(1200),G1H2(1201),G1H2(1202),2)
  call HG1shiftOLR(G1H2(1198),4,2)
  call Hotf_4pt_reduction(G2H2(788),RedSet_4(14),mass4set(:,1),  & 
G1H2(1203),G1H2(1204),G1H2(1205),G1H2(1206),G1H2(1207),2)
  call HG1shiftOLR(G1H2(1204),6,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(198),27,ex3(:),4,G2tensor(99),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hotf_5pt_reduction(G2H2(793),RedSet_5(12),mass5set(:,1),  & 
G1H2(198),G1H2(1208),G1H2(1209),G1H2(1210),G1H2(1211),G1H2(1212),2)
  call HG1shiftOLR(G1H2(1208),2,2)
  call Hotf_4pt_reduction(G2H2(796),RedSet_4(14),mass4set(:,1),  & 
G1H2(1213),G1H2(1214),G1H2(1215),G1H2(1216),G1H2(1217),2)
  call HG1shiftOLR(G1H2(1214),6,2)
  call Hloop_AV_Q(ntryL,G1H2(200),ex2(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(67))
  call Hotf_5pt_reduction(G2H2(801),RedSet_5(12),mass5set(:,2),  & 
G1H2(200),G1H2(1218),G1H2(1219),G1H2(1220),G1H2(1221),G1H2(1222),2)
  call HG1shiftOLR(G1H2(1218),2,2)
  call Hotf_4pt_reduction(G2H2(804),RedSet_4(14),mass4set(:,2),  & 
G1H2(1223),G1H2(1224),G1H2(1225),G1H2(1226),G1H2(1227),2)
  call HG1shiftOLR(G1H2(1224),6,2)
  call Hloop_AV_Q(ntryL,G1H2(202),ex2(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(68))
  call Hotf_5pt_reduction(G2H2(809),RedSet_5(12),mass5set(:,1),  & 
G1H2(202),G1H2(1228),G1H2(1229),G1H2(1230),G1H2(1231),G1H2(1232),2)
  call HG1shiftOLR(G1H2(1228),2,2)
  call Hotf_4pt_reduction(G2H2(812),RedSet_4(14),mass4set(:,1),  & 
G1H2(1233),G1H2(1234),G1H2(1235),G1H2(1236),G1H2(1237),2)
  call HG1shiftOLR(G1H2(1234),6,2)
  call Hloop_QV_A(ntryL,G1H2(204),ex2(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(69))
  call Hotf_5pt_reduction(G2H2(817),RedSet_5(12),mass5set(:,2),  & 
G1H2(204),G1H2(1238),G1H2(1239),G1H2(1240),G1H2(1241),G1H2(1242),2)
  call HG1shiftOLR(G1H2(1238),2,2)
  call Hotf_4pt_reduction(G2H2(820),RedSet_4(14),mass4set(:,2),  & 
G1H2(1243),G1H2(1244),G1H2(1245),G1H2(1246),G1H2(1247),2)
  call HG1shiftOLR(G1H2(1244),6,2)
  call Hloop_QV_A(ntryL,G1H2(206),ex2(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(103),n2h1(70))
  call Hotf_5pt_reduction(G2H2(825),RedSet_5(12),mass5set(:,3),  & 
G1H2(206),G1H2(1248),G1H2(1249),G1H2(1250),G1H2(1251),G1H2(1252),2)
  call HG1shiftOLR(G1H2(1248),2,2)
  call Hotf_4pt_reduction(G2H2(828),RedSet_4(14),mass4set(:,3),  & 
G1H2(1253),G1H2(1254),G1H2(1255),G1H2(1256),G1H2(1257),2)
  call HG1shiftOLR(G1H2(1254),6,2)
  call Hloop_AV_Q(ntryL,G1H2(208),ex2(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(104),n2h1(71))
  call Hotf_5pt_reduction(G2H2(833),RedSet_5(12),mass5set(:,3),  & 
G1H2(208),G1H2(1258),G1H2(1259),G1H2(1260),G1H2(1261),G1H2(1262),2)
  call HG1shiftOLR(G1H2(1258),2,2)
  call Hotf_4pt_reduction(G2H2(836),RedSet_4(14),mass4set(:,3),  & 
G1H2(1263),G1H2(1264),G1H2(1265),G1H2(1266),G1H2(1267),2)
  call HG1shiftOLR(G1H2(1264),6,2)
  call Hloop_QV_A(ntryL,G1H2(210),ex2(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(105),n2h1(72))
  call Hotf_5pt_reduction(G2H2(841),RedSet_5(12),mass5set(:,1),  & 
G1H2(210),G1H2(1268),G1H2(1269),G1H2(1270),G1H2(1271),G1H2(1272),2)
  call HG1shiftOLR(G1H2(1268),2,2)
  call Hotf_4pt_reduction(G2H2(844),RedSet_4(14),mass4set(:,1),  & 
G1H2(1273),G1H2(1274),G1H2(1275),G1H2(1276),G1H2(1277),2)
  call HG1shiftOLR(G1H2(1274),6,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(212),29,ex2(:),G2tensor(106),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hotf_5pt_reduction(G2H2(849),RedSet_5(12),mass5set(:,1),  & 
G1H2(212),G1H2(1278),G1H2(1279),G1H2(1280),G1H2(1281),G1H2(1282),2)
  call HG1shiftOLR(G1H2(1278),2,2)
  call Hotf_4pt_reduction(G2H2(852),RedSet_4(14),mass4set(:,1),  & 
G1H2(1283),G1H2(1284),G1H2(1285),G1H2(1286),G1H2(1287),2)
  call HG1shiftOLR(G1H2(1284),6,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(214),29,ex2(:),2,G2tensor(107),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hotf_5pt_reduction(G2H2(857),RedSet_5(12),mass5set(:,1),  & 
G1H2(214),G1H2(1288),G1H2(1289),G1H2(1290),G1H2(1291),G1H2(1292),2)
  call HG1shiftOLR(G1H2(1288),2,2)
  call Hotf_4pt_reduction(G2H2(860),RedSet_4(14),mass4set(:,1),  & 
G1H2(1293),G1H2(1294),G1H2(1295),G1H2(1296),G1H2(1297),2)
  call HG1shiftOLR(G1H2(1294),6,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(216),29,ex2(:),2,G2tensor(108),m3h2x1(:,108),heltab2x2(:,:,108))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(223),[G1H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(233),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(253),[G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(283),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(293),[G1H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(303),[G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(323),[G1H2(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(333),[G1H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(343),[G1H2(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(353),[G1H2(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(363),[G1H2(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(373),[G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(383),[G1H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(393),[G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(403),[G1H2(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(413),[G1H2(412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(423),[G1H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(433),[G1H2(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(443),[G1H2(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(453),[G1H2(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(463),[G1H2(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(473),[G1H2(472)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(483),[G1H2(482)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(493),[G1H2(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(503),[G1H2(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(513),[G1H2(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(523),[G1H2(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(533),[G1H2(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(543),[G1H2(542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(553),[G1H2(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(563),[G1H2(562)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(573),[G1H2(572)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(583),[G1H2(582)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(593),[G1H2(592)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(603),[G1H2(602)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(613),[G1H2(612)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(623),[G1H2(622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(633),[G1H2(632)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(643),[G1H2(642)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(653),[G1H2(652)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(663),[G1H2(662)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(673),[G1H2(672)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(683),[G1H2(682)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(693),[G1H2(692)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(703),[G1H2(702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(713),[G1H2(712)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(723),[G1H2(722)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(733),[G1H2(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(743),[G1H2(742)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(753),[G1H2(752)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(763),[G1H2(762)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(773),[G1H2(772)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(783),[G1H2(782)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(793),[G1H2(792)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(803),[G1H2(802)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(813),[G1H2(812)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(823),[G1H2(822)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(833),[G1H2(832)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(843),[G1H2(842)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(853),[G1H2(852)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(863),[G1H2(862)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(873),[G1H2(872)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(883),[G1H2(882)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(893),[G1H2(892)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(903),[G1H2(902)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(913),[G1H2(912)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(923),[G1H2(922)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(933),[G1H2(932)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(943),[G1H2(942)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(953),[G1H2(952)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(963),[G1H2(962)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(973),[G1H2(972)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(983),[G1H2(982)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(993),[G1H2(992)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1003),[G1H2(1002)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1013),[G1H2(1012)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1023),[G1H2(1022)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1033),[G1H2(1032)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1043),[G1H2(1042)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1053),[G1H2(1052)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1063),[G1H2(1062)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1073),[G1H2(1072)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1083),[G1H2(1082)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1093),[G1H2(1092)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1103),[G1H2(1102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1113),[G1H2(1112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1123),[G1H2(1122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1133),[G1H2(1132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1143),[G1H2(1142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1153),[G1H2(1152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1163),[G1H2(1162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1173),[G1H2(1172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1183),[G1H2(1182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1193),[G1H2(1192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1203),[G1H2(1202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1213),[G1H2(1212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1223),[G1H2(1222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1233),[G1H2(1232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1243),[G1H2(1242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1253),[G1H2(1252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1263),[G1H2(1262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1273),[G1H2(1272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1283),[G1H2(1282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1293),[G1H2(1292)])
  call Hloop_AV_Q(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(110),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(223),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(112),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(114),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(115),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(116),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(238),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(118),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(243),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(244),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(120),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(121),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(122),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(123),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(254),ex4(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(124),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(125),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(258),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(126),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(263),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(127),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(264),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(128),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(129),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(268),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(130),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(273),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(131),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(274),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(132),n2h1(96))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(12),23,ex4(:),G2tensor(133),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(278),0,ex4(:),G2tensor(134),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(283),23,ex4(:),G2tensor(135),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(284),2,ex4(:),G2tensor(136),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(14),23,ex4(:),8,G2tensor(137),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(288),0,ex4(:),8,G2tensor(138),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(293),23,ex4(:),8,G2tensor(139),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(294),2,ex4(:),8,G2tensor(140),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(16),23,ex4(:),8,G2tensor(141),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(298),0,ex4(:),8,G2tensor(142),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(303),23,ex4(:),8,G2tensor(143),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(304),2,ex4(:),8,G2tensor(144),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(145),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(308),ex4(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(146),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(313),ex4(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(314),ex4(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(148),n2h1(106))
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(149),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(318),ex4(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(150),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(323),ex4(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(151),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(324),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(152),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(153),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(328),ex4(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(154),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H2(333),ex4(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(155),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(334),ex4(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(156),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(157),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(338),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(158),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(343),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(159),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(344),ex4(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(160),n2h1(118))
  call Hloop_QV_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(161),n2h1(119))
  call Hloop_QV_A(ntryL,G1H2(348),ex4(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(162),n2h1(120))
  call Hloop_QV_A(ntryL,G1H2(353),ex4(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(163),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(354),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(164),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(165),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(358),ex4(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(166),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H2(363),ex4(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(167),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H2(364),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(168),n2h1(126))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(30),23,ex4(:),8,G2tensor(169),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(368),0,ex4(:),8,G2tensor(170),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(373),23,ex4(:),8,G2tensor(171),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(374),4,ex4(:),8,G2tensor(172),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(32),23,ex4(:),G2tensor(173),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(378),0,ex4(:),G2tensor(174),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(383),23,ex4(:),G2tensor(175),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(384),4,ex4(:),G2tensor(176),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(34),23,ex4(:),8,G2tensor(177),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(388),0,ex4(:),8,G2tensor(178),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(393),23,ex4(:),8,G2tensor(179),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(394),4,ex4(:),8,G2tensor(180),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hloop_QV_A(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(181),n2h1(133))
  call Hloop_QV_A(ntryL,G1H2(398),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(182),n2h1(134))
  call Hloop_QV_A(ntryL,G1H2(403),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(183),n2h1(135))
  call Hloop_QV_A(ntryL,G1H2(404),ex4(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(184),n2h1(136))
  call Hloop_QV_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(185),n2h1(137))
  call Hloop_QV_A(ntryL,G1H2(408),ex4(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(186),n2h1(138))
  call Hloop_QV_A(ntryL,G1H2(413),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(187),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(414),ex4(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(188),n2h1(140))
  call Hloop_AV_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(189),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(418),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(190),n2h1(142))
  call Hloop_AV_Q(ntryL,G1H2(423),ex4(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(424),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(192),n2h1(144))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(193),n2h1(145))
  call Hloop_AV_Q(ntryL,G1H2(428),ex4(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(194),n2h1(146))
  call Hloop_AV_Q(ntryL,G1H2(433),ex4(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(195),n2h1(147))
  call Hloop_AV_Q(ntryL,G1H2(434),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(196),n2h1(148))
  call Hloop_QV_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(197),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(438),ex4(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(198),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(443),ex4(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(199),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(444),ex4(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(200),n2h1(152))
  call Hloop_AV_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(201),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H2(448),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(202),n2h1(154))
  call Hloop_AV_Q(ntryL,G1H2(453),ex4(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(203),n2h1(155))
  call Hloop_AV_Q(ntryL,G1H2(454),ex4(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(204),n2h1(156))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(48),23,ex4(:),8,G2tensor(205),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(458),0,ex4(:),8,G2tensor(206),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(463),23,ex4(:),8,G2tensor(207),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(464),1,ex4(:),8,G2tensor(208),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(50),23,ex4(:),G2tensor(209),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(468),0,ex4(:),G2tensor(210),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(473),23,ex4(:),G2tensor(211),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(474),1,ex4(:),G2tensor(212),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(52),23,ex4(:),8,G2tensor(213),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(478),0,ex4(:),8,G2tensor(214),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(483),23,ex4(:),8,G2tensor(215),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(484),1,ex4(:),8,G2tensor(216),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hloop_QV_A(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(217),n2h1(163))
  call Hloop_QV_A(ntryL,G1H2(488),ex3(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(218),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(493),ex3(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(219),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(494),ex3(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(220),n2h1(166))
  call Hloop_QV_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(221),n2h1(167))
  call Hloop_QV_A(ntryL,G1H2(498),ex3(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(222),n2h1(168))
  call Hloop_QV_A(ntryL,G1H2(503),ex3(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(223),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(504),ex3(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(224),n2h1(170))
  call Hloop_AV_Q(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(225),n2h1(171))
  call Hloop_AV_Q(ntryL,G1H2(508),ex3(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(226),n2h1(172))
  call Hloop_AV_Q(ntryL,G1H2(513),ex3(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(227),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H2(514),ex3(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(228),n2h1(174))
  call Hloop_AV_Q(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(229),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H2(518),ex3(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(230),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H2(523),ex3(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(231),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H2(524),ex3(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(232),n2h1(178))
  call Hloop_QV_A(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(233),n2h1(179))
  call Hloop_QV_A(ntryL,G1H2(528),ex3(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(234),n2h1(180))
  call Hloop_QV_A(ntryL,G1H2(533),ex3(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(235),n2h1(181))
  call Hloop_QV_A(ntryL,G1H2(534),ex3(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(236),n2h1(182))
  call Hloop_AV_Q(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(237),n2h1(183))
  call Hloop_AV_Q(ntryL,G1H2(538),ex3(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(238),n2h1(184))
  call Hloop_AV_Q(ntryL,G1H2(543),ex3(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(239),n2h1(185))
  call Hloop_AV_Q(ntryL,G1H2(544),ex3(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(240),n2h1(186))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(66),27,ex3(:),4,G2tensor(241),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(548),0,ex3(:),4,G2tensor(242),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(553),27,ex3(:),4,G2tensor(243),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(554),8,ex3(:),4,G2tensor(244),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(68),27,ex3(:),G2tensor(245),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(558),0,ex3(:),G2tensor(246),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(563),27,ex3(:),G2tensor(247),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(564),8,ex3(:),G2tensor(248),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(70),27,ex3(:),4,G2tensor(249),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(568),0,ex3(:),4,G2tensor(250),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(573),27,ex3(:),4,G2tensor(251),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(574),8,ex3(:),4,G2tensor(252),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hloop_AV_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(253),n2h1(193))
  call Hloop_AV_Q(ntryL,G1H2(578),ex4(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(254),n2h1(194))
  call Hloop_AV_Q(ntryL,G1H2(583),ex4(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(255),n2h1(195))
  call Hloop_AV_Q(ntryL,G1H2(584),ex4(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(256),n2h1(196))
  call Hloop_AV_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(257),n2h1(197))
  call Hloop_AV_Q(ntryL,G1H2(588),ex4(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(258),n2h1(198))
  call Hloop_AV_Q(ntryL,G1H2(593),ex4(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(259),n2h1(199))
  call Hloop_AV_Q(ntryL,G1H2(594),ex4(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(260),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(261),n2h1(201))
  call Hloop_QV_A(ntryL,G1H2(598),ex4(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(262),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(603),ex4(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(263),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(604),ex4(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(264),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(265),n2h1(205))
  call Hloop_QV_A(ntryL,G1H2(608),ex4(:),G1H1(1),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(266),n2h1(206))
  call Hloop_QV_A(ntryL,G1H2(613),ex4(:),G1H1(1),m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(267),n2h1(207))
  call Hloop_QV_A(ntryL,G1H2(614),ex4(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(268),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(269),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(618),ex4(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(270),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(623),ex4(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(271),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(624),ex4(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(272),n2h1(212))
  call Hloop_QV_A(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(273),n2h1(213))
  call Hloop_QV_A(ntryL,G1H2(628),ex4(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(274),n2h1(214))
  call Hloop_QV_A(ntryL,G1H2(633),ex4(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(275),n2h1(215))
  call Hloop_QV_A(ntryL,G1H2(634),ex4(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(276),n2h1(216))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(84),23,ex4(:),G2tensor(277),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(638),0,ex4(:),G2tensor(278),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(643),23,ex4(:),G2tensor(279),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(644),4,ex4(:),G2tensor(280),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(86),23,ex4(:),8,G2tensor(281),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(648),0,ex4(:),8,G2tensor(282),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(653),23,ex4(:),8,G2tensor(283),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(654),4,ex4(:),8,G2tensor(284),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(88),23,ex4(:),8,G2tensor(285),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(658),0,ex4(:),8,G2tensor(286),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(663),23,ex4(:),8,G2tensor(287),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(664),4,ex4(:),8,G2tensor(288),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hloop_AV_Q(ntryL,G1H2(90),ex3(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(289),n2h1(223))
  call Hloop_AV_Q(ntryL,G1H2(668),ex3(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(290),n2h1(224))
  call Hloop_AV_Q(ntryL,G1H2(673),ex3(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(291),n2h1(225))
  call Hloop_AV_Q(ntryL,G1H2(674),ex3(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(292),n2h1(226))
  call Hloop_AV_Q(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(293),n2h1(227))
  call Hloop_AV_Q(ntryL,G1H2(678),ex3(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(294),n2h1(228))
  call Hloop_AV_Q(ntryL,G1H2(683),ex3(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(295),n2h1(229))
  call Hloop_AV_Q(ntryL,G1H2(684),ex3(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(296),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(297),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(688),ex3(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(298),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(693),ex3(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(299),n2h1(233))
  call Hloop_QV_A(ntryL,G1H2(694),ex3(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(300),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(96),ex3(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(301),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(698),ex3(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(302),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(703),ex3(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(303),n2h1(237))
  call Hloop_QV_A(ntryL,G1H2(704),ex3(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(304),n2h1(238))
  call Hloop_AV_Q(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(305),n2h1(239))
  call Hloop_AV_Q(ntryL,G1H2(708),ex3(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(306),n2h1(240))
  call Hloop_AV_Q(ntryL,G1H2(713),ex3(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(307),n2h1(241))
  call Hloop_AV_Q(ntryL,G1H2(714),ex3(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(308),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(309),n2h1(243))
  call Hloop_QV_A(ntryL,G1H2(718),ex3(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(310),n2h1(244))
  call Hloop_QV_A(ntryL,G1H2(723),ex3(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(311),n2h1(245))
  call Hloop_QV_A(ntryL,G1H2(724),ex3(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(312),n2h1(246))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(102),27,ex3(:),G2tensor(313),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(728),0,ex3(:),G2tensor(314),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(733),27,ex3(:),G2tensor(315),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(734),8,ex3(:),G2tensor(316),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(104),27,ex3(:),4,G2tensor(317),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(738),0,ex3(:),4,G2tensor(318),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(743),27,ex3(:),4,G2tensor(319),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(744),8,ex3(:),4,G2tensor(320),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(106),27,ex3(:),4,G2tensor(321),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(748),0,ex3(:),4,G2tensor(322),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(753),27,ex3(:),4,G2tensor(323),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(754),8,ex3(:),4,G2tensor(324),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hloop_QV_A(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(325),n2h1(253))
  call Hloop_QV_A(ntryL,G1H2(758),ex4(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(326),n2h1(254))
  call Hloop_QV_A(ntryL,G1H2(763),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(327),n2h1(255))
  call Hloop_QV_A(ntryL,G1H2(764),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(328),n2h1(256))
  call Hloop_QV_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(329),n2h1(257))
  call Hloop_QV_A(ntryL,G1H2(768),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(330),n2h1(258))
  call Hloop_QV_A(ntryL,G1H2(773),ex4(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(331),n2h1(259))
  call Hloop_QV_A(ntryL,G1H2(774),ex4(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(332),n2h1(260))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(333),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H2(778),ex4(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(334),n2h1(262))
  call Hloop_AV_Q(ntryL,G1H2(783),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(335),n2h1(263))
  call Hloop_AV_Q(ntryL,G1H2(784),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,0,G2tensor(336),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(337),n2h1(265))
  call Hloop_AV_Q(ntryL,G1H2(788),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(338),n2h1(266))
  call Hloop_AV_Q(ntryL,G1H2(793),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(339),n2h1(267))
  call Hloop_AV_Q(ntryL,G1H2(794),ex4(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(340),n2h1(268))
  call Hloop_QV_A(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(341),n2h1(269))
  call Hloop_QV_A(ntryL,G1H2(798),ex4(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(342),n2h1(270))
  call Hloop_QV_A(ntryL,G1H2(803),ex4(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(343),n2h1(271))
  call Hloop_QV_A(ntryL,G1H2(804),ex4(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(344),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(345),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(808),ex4(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(346),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(813),ex4(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(347),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(814),ex4(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(348),n2h1(276))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(120),23,ex4(:),8,G2tensor(349),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(818),0,ex4(:),8,G2tensor(350),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(823),23,ex4(:),8,G2tensor(351),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(824),1,ex4(:),8,G2tensor(352),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(122),23,ex4(:),G2tensor(353),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(828),0,ex4(:),G2tensor(354),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(833),23,ex4(:),G2tensor(355),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(834),1,ex4(:),G2tensor(356),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(124),23,ex4(:),8,G2tensor(357),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(838),0,ex4(:),8,G2tensor(358),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(843),23,ex4(:),8,G2tensor(359),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(844),1,ex4(:),8,G2tensor(360),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hloop_AV_Q(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(361),n2h1(283))
  call Hloop_AV_Q(ntryL,G1H2(848),ex3(:),G1H1(1),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(362),n2h1(284))
  call Hloop_AV_Q(ntryL,G1H2(853),ex3(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(363),n2h1(285))
  call Hloop_AV_Q(ntryL,G1H2(854),ex3(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,0,G2tensor(364),n2h1(286))
  call Hloop_AV_Q(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(365),n2h1(287))
  call Hloop_AV_Q(ntryL,G1H2(858),ex3(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(366),n2h1(288))
  call Hloop_AV_Q(ntryL,G1H2(863),ex3(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(367),n2h1(289))
  call Hloop_AV_Q(ntryL,G1H2(864),ex3(:),G1H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,nMT,G2tensor(368),n2h1(290))
  call Hloop_QV_A(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(369),n2h1(291))
  call Hloop_QV_A(ntryL,G1H2(868),ex3(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(370),n2h1(292))
  call Hloop_QV_A(ntryL,G1H2(873),ex3(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(371),n2h1(293))
  call Hloop_QV_A(ntryL,G1H2(874),ex3(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(372),n2h1(294))
  call Hloop_QV_A(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(373),n2h1(295))
  call Hloop_QV_A(ntryL,G1H2(878),ex3(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(374),n2h1(296))
  call Hloop_QV_A(ntryL,G1H2(883),ex3(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(375),n2h1(297))
  call Hloop_QV_A(ntryL,G1H2(884),ex3(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMT,G2tensor(376),n2h1(298))
  call Hloop_AV_Q(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(377),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(888),ex3(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(378),n2h1(300))
  call Hloop_AV_Q(ntryL,G1H2(893),ex3(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(379),n2h1(301))
  call Hloop_AV_Q(ntryL,G1H2(894),ex3(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(380),n2h1(302))
  call Hloop_QV_A(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(381),n2h1(303))
  call Hloop_QV_A(ntryL,G1H2(898),ex3(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(382),n2h1(304))
  call Hloop_QV_A(ntryL,G1H2(903),ex3(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(383),n2h1(305))
  call Hloop_QV_A(ntryL,G1H2(904),ex3(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(384),n2h1(306))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(138),27,ex3(:),G2tensor(385),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(908),0,ex3(:),G2tensor(386),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(913),27,ex3(:),G2tensor(387),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(914),1,ex3(:),G2tensor(388),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(140),27,ex3(:),4,G2tensor(389),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(918),0,ex3(:),4,G2tensor(390),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(923),27,ex3(:),4,G2tensor(391),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(924),1,ex3(:),4,G2tensor(392),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(142),27,ex3(:),4,G2tensor(393),m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(928),0,ex3(:),4,G2tensor(394),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(933),27,ex3(:),4,G2tensor(395),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(934),1,ex3(:),4,G2tensor(396),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(397),n2h1(313))
  call Hloop_AV_Q(ntryL,G1H2(938),ex4(:),G1H1(1),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(398),n2h1(314))
  call Hloop_AV_Q(ntryL,G1H2(943),ex4(:),G1H1(1),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(399),n2h1(315))
  call Hloop_AV_Q(ntryL,G1H2(944),ex4(:),G1H1(1),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(400),n2h1(316))
  call Hloop_AV_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(401),n2h1(317))
  call Hloop_AV_Q(ntryL,G1H2(948),ex4(:),G1H1(1),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(402),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H2(953),ex4(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(403),n2h1(319))
  call Hloop_AV_Q(ntryL,G1H2(954),ex4(:),G1H1(1),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(404),n2h1(320))
  call Hloop_QV_A(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(405),n2h1(321))
  call Hloop_QV_A(ntryL,G1H2(958),ex4(:),G1H1(1),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(406),n2h1(322))
  call Hloop_QV_A(ntryL,G1H2(963),ex4(:),G1H1(1),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(407),n2h1(323))
  call Hloop_QV_A(ntryL,G1H2(964),ex4(:),G1H1(1),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(408),n2h1(324))
  call Hloop_QV_A(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(409),n2h1(325))
  call Hloop_QV_A(ntryL,G1H2(968),ex4(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(410),n2h1(326))
  call Hloop_QV_A(ntryL,G1H2(973),ex4(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(411),n2h1(327))
  call Hloop_QV_A(ntryL,G1H2(974),ex4(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(412),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(413),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(978),ex4(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(414),n2h1(330))
  call Hloop_AV_Q(ntryL,G1H2(983),ex4(:),G1H1(1),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(415),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(984),ex4(:),G1H1(1),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(416),n2h1(332))
  call Hloop_QV_A(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(417),n2h1(333))
  call Hloop_QV_A(ntryL,G1H2(988),ex4(:),G1H1(1),m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(418),n2h1(334))
  call Hloop_QV_A(ntryL,G1H2(993),ex4(:),G1H1(1),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(419),n2h1(335))
  call Hloop_QV_A(ntryL,G1H2(994),ex4(:),G1H1(1),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(420),n2h1(336))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(156),23,ex4(:),G2tensor(421),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(998),0,ex4(:),G2tensor(422),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1003),23,ex4(:),G2tensor(423),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1004),2,ex4(:),G2tensor(424),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(158),23,ex4(:),8,G2tensor(425),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1008),0,ex4(:),8,G2tensor(426),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1013),23,ex4(:),8,G2tensor(427),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1014),2,ex4(:),8,G2tensor(428),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(160),23,ex4(:),8,G2tensor(429),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1018),0,ex4(:),8,G2tensor(430),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1023),23,ex4(:),8,G2tensor(431),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1024),2,ex4(:),8,G2tensor(432),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hloop_AV_Q(ntryL,G1H2(162),ex2(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(433),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(1028),ex2(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(434),n2h1(344))
  call Hloop_AV_Q(ntryL,G1H2(1033),ex2(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(435),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H2(1034),ex2(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(436),n2h1(346))
  call Hloop_AV_Q(ntryL,G1H2(164),ex2(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(437),n2h1(347))
  call Hloop_AV_Q(ntryL,G1H2(1038),ex2(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(438),n2h1(348))
  call Hloop_AV_Q(ntryL,G1H2(1043),ex2(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(439),n2h1(349))
  call Hloop_AV_Q(ntryL,G1H2(1044),ex2(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(440),n2h1(350))
  call Hloop_QV_A(ntryL,G1H2(166),ex2(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(441),n2h1(351))
  call Hloop_QV_A(ntryL,G1H2(1048),ex2(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(442),n2h1(352))
  call Hloop_QV_A(ntryL,G1H2(1053),ex2(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(443),n2h1(353))
  call Hloop_QV_A(ntryL,G1H2(1054),ex2(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,0,G2tensor(444),n2h1(354))
  call Hloop_QV_A(ntryL,G1H2(168),ex2(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(445),n2h1(355))
  call Hloop_QV_A(ntryL,G1H2(1058),ex2(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(446),n2h1(356))
  call Hloop_QV_A(ntryL,G1H2(1063),ex2(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(447),n2h1(357))
  call Hloop_QV_A(ntryL,G1H2(1064),ex2(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(448),n2h1(358))
  call Hloop_AV_Q(ntryL,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(449),n2h1(359))
  call Hloop_AV_Q(ntryL,G1H2(1068),ex2(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(450),n2h1(360))
  call Hloop_AV_Q(ntryL,G1H2(1073),ex2(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(451),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H2(1074),ex2(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(452),n2h1(362))
  call Hloop_QV_A(ntryL,G1H2(172),ex2(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(453),n2h1(363))
  call Hloop_QV_A(ntryL,G1H2(1078),ex2(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(454),n2h1(364))
  call Hloop_QV_A(ntryL,G1H2(1083),ex2(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(455),n2h1(365))
  call Hloop_QV_A(ntryL,G1H2(1084),ex2(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(456),n2h1(366))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(174),29,ex2(:),G2tensor(457),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1088),0,ex2(:),G2tensor(458),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1093),29,ex2(:),G2tensor(459),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1094),8,ex2(:),G2tensor(460),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(176),29,ex2(:),2,G2tensor(461),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1098),0,ex2(:),2,G2tensor(462),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1103),29,ex2(:),2,G2tensor(463),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1104),8,ex2(:),2,G2tensor(464),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(178),29,ex2(:),2,G2tensor(465),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1108),0,ex2(:),2,G2tensor(466),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1113),29,ex2(:),2,G2tensor(467),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1114),8,ex2(:),2,G2tensor(468),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hloop_AV_Q(ntryL,G1H2(180),ex3(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(469),n2h1(373))
  call Hloop_AV_Q(ntryL,G1H2(1118),ex3(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(470),n2h1(374))
  call Hloop_AV_Q(ntryL,G1H2(1123),ex3(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(471),n2h1(375))
  call Hloop_AV_Q(ntryL,G1H2(1124),ex3(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(472),n2h1(376))
  call Hloop_AV_Q(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(473),n2h1(377))
  call Hloop_AV_Q(ntryL,G1H2(1128),ex3(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(474),n2h1(378))
  call Hloop_AV_Q(ntryL,G1H2(1133),ex3(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(475),n2h1(379))
  call Hloop_AV_Q(ntryL,G1H2(1134),ex3(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(476),n2h1(380))
  call Hloop_QV_A(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(477),n2h1(381))
  call Hloop_QV_A(ntryL,G1H2(1138),ex3(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(478),n2h1(382))
  call Hloop_QV_A(ntryL,G1H2(1143),ex3(:),G1H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(479),n2h1(383))
  call Hloop_QV_A(ntryL,G1H2(1144),ex3(:),G1H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(480),n2h1(384))
  call Hloop_QV_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(481),n2h1(385))
  call Hloop_QV_A(ntryL,G1H2(1148),ex3(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(482),n2h1(386))
  call Hloop_QV_A(ntryL,G1H2(1153),ex3(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(483),n2h1(387))
  call Hloop_QV_A(ntryL,G1H2(1154),ex3(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(484),n2h1(388))
  call Hloop_AV_Q(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(485),n2h1(389))
  call Hloop_AV_Q(ntryL,G1H2(1158),ex3(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(486),n2h1(390))
  call Hloop_AV_Q(ntryL,G1H2(1163),ex3(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(487),n2h1(391))
  call Hloop_AV_Q(ntryL,G1H2(1164),ex3(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(488),n2h1(392))
  call Hloop_QV_A(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(489),n2h1(393))
  call Hloop_QV_A(ntryL,G1H2(1168),ex3(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(490),n2h1(394))
  call Hloop_QV_A(ntryL,G1H2(1173),ex3(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(491),n2h1(395))
  call Hloop_QV_A(ntryL,G1H2(1174),ex3(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(492),n2h1(396))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(192),27,ex3(:),G2tensor(493),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1178),0,ex3(:),G2tensor(494),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1183),27,ex3(:),G2tensor(495),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1184),2,ex3(:),G2tensor(496),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(194),27,ex3(:),4,G2tensor(497),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1188),0,ex3(:),4,G2tensor(498),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1193),27,ex3(:),4,G2tensor(499),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1194),2,ex3(:),4,G2tensor(500),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(196),27,ex3(:),4,G2tensor(501),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1198),0,ex3(:),4,G2tensor(502),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1203),27,ex3(:),4,G2tensor(503),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1204),2,ex3(:),4,G2tensor(504),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hloop_AV_Q(ntryL,G1H2(198),ex2(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(505),n2h1(403))
  call Hloop_AV_Q(ntryL,G1H2(1208),ex2(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(506),n2h1(404))
  call Hloop_AV_Q(ntryL,G1H2(1213),ex2(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(507),n2h1(405))
  call Hloop_AV_Q(ntryL,G1H2(1214),ex2(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(508),n2h1(406))
  call Hloop_AV_Q(ntryL,G1H2(200),ex2(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(509),n2h1(407))
  call Hloop_AV_Q(ntryL,G1H2(1218),ex2(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(510),n2h1(408))
  call Hloop_AV_Q(ntryL,G1H2(1223),ex2(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(511),n2h1(409))
  call Hloop_AV_Q(ntryL,G1H2(1224),ex2(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(512),n2h1(410))
  call Hloop_QV_A(ntryL,G1H2(202),ex2(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(513),n2h1(411))
  call Hloop_QV_A(ntryL,G1H2(1228),ex2(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(514),n2h1(412))
  call Hloop_QV_A(ntryL,G1H2(1233),ex2(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(515),n2h1(413))
  call Hloop_QV_A(ntryL,G1H2(1234),ex2(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,0,G2tensor(516),n2h1(414))
  call Hloop_QV_A(ntryL,G1H2(204),ex2(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(517),n2h1(415))
  call Hloop_QV_A(ntryL,G1H2(1238),ex2(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(518),n2h1(416))
  call Hloop_QV_A(ntryL,G1H2(1243),ex2(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(519),n2h1(417))
  call Hloop_QV_A(ntryL,G1H2(1244),ex2(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(520),n2h1(418))
  call Hloop_AV_Q(ntryL,G1H2(206),ex2(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(521),n2h1(419))
  call Hloop_AV_Q(ntryL,G1H2(1248),ex2(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(522),n2h1(420))
  call Hloop_AV_Q(ntryL,G1H2(1253),ex2(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(523),n2h1(421))
  call Hloop_AV_Q(ntryL,G1H2(1254),ex2(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(524),n2h1(422))
  call Hloop_QV_A(ntryL,G1H2(208),ex2(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(525),n2h1(423))
  call Hloop_QV_A(ntryL,G1H2(1258),ex2(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(526),n2h1(424))
  call Hloop_QV_A(ntryL,G1H2(1263),ex2(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(527),n2h1(425))
  call Hloop_QV_A(ntryL,G1H2(1264),ex2(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(528),n2h1(426))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(210),29,ex2(:),G2tensor(529),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1268),0,ex2(:),G2tensor(530),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1273),29,ex2(:),G2tensor(531),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(1274),4,ex2(:),G2tensor(532),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(212),29,ex2(:),2,G2tensor(533),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1278),0,ex2(:),2,G2tensor(534),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1283),29,ex2(:),2,G2tensor(535),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(1284),4,ex2(:),2,G2tensor(536),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(214),29,ex2(:),2,G2tensor(537),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1288),0,ex2(:),2,G2tensor(538),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1293),29,ex2(:),2,G2tensor(539),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1294),4,ex2(:),2,G2tensor(540),m3h2x1(:,540),heltab2x2(:,:,540))
  call ol_merge_tensors(G2tensor(141),[G2tensor(137),G2tensor(133),G2tensor(117),G2tensor(109)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(113)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(125)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(173),G2tensor(169),G2tensor(153),G2tensor(145)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(149)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(161)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(209),G2tensor(205),G2tensor(189),G2tensor(181)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(185)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(197)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(245),G2tensor(241),G2tensor(225),G2tensor(217)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(221)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(233)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(281),G2tensor(277),G2tensor(261),G2tensor(253)])
  call ol_merge_tensors(G2tensor(265),[G2tensor(257)])
  call ol_merge_tensors(G2tensor(273),[G2tensor(269)])
  call ol_merge_tensors(G2tensor(321),[G2tensor(317),G2tensor(313),G2tensor(297),G2tensor(289)])
  call ol_merge_tensors(G2tensor(301),[G2tensor(293)])
  call ol_merge_tensors(G2tensor(309),[G2tensor(305)])
  call ol_merge_tensors(G2tensor(357),[G2tensor(353),G2tensor(349),G2tensor(333),G2tensor(325)])
  call ol_merge_tensors(G2tensor(337),[G2tensor(329)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(341)])
  call ol_merge_tensors(G2tensor(393),[G2tensor(389),G2tensor(385),G2tensor(369),G2tensor(361)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(365)])
  call ol_merge_tensors(G2tensor(381),[G2tensor(377)])
  call ol_merge_tensors(G2tensor(429),[G2tensor(425),G2tensor(421),G2tensor(405),G2tensor(397)])
  call ol_merge_tensors(G2tensor(409),[G2tensor(401)])
  call ol_merge_tensors(G2tensor(417),[G2tensor(413)])
  call ol_merge_tensors(G2tensor(465),[G2tensor(461),G2tensor(457),G2tensor(441),G2tensor(433)])
  call ol_merge_tensors(G2tensor(445),[G2tensor(437)])
  call ol_merge_tensors(G2tensor(453),[G2tensor(449)])
  call ol_merge_tensors(G2tensor(501),[G2tensor(497),G2tensor(493),G2tensor(477),G2tensor(469)])
  call ol_merge_tensors(G2tensor(481),[G2tensor(473)])
  call ol_merge_tensors(G2tensor(489),[G2tensor(485)])
  call ol_merge_tensors(G2tensor(537),[G2tensor(533),G2tensor(529),G2tensor(513),G2tensor(505)])
  call ol_merge_tensors(G2tensor(517),[G2tensor(509)])
  call ol_merge_tensors(G2tensor(525),[G2tensor(521)])
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(2),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(2),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(193),RedSet_5(3),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(3),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(249),RedSet_5(4),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(4),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(4),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(285),RedSet_5(5),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(265),RedSet_5(5),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(273),RedSet_5(5),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(321),RedSet_5(6),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(301),RedSet_5(6),mass5set(:,2),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(309),RedSet_5(6),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(357),RedSet_5(7),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(337),RedSet_5(7),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(345),RedSet_5(7),mass5set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(393),RedSet_5(8),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(373),RedSet_5(8),mass5set(:,2),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(381),RedSet_5(8),mass5set(:,3),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(429),RedSet_5(9),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(409),RedSet_5(9),mass5set(:,2),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(417),RedSet_5(9),mass5set(:,3),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(465),RedSet_5(10),mass5set(:,1),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),2)
  call Hotf_5pt_reduction_last(G2tensor(445),RedSet_5(10),mass5set(:,2),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),2)
  call Hotf_5pt_reduction_last(G2tensor(453),RedSet_5(10),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),2)
  call Hotf_5pt_reduction_last(G2tensor(501),RedSet_5(11),mass5set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(481),RedSet_5(11),mass5set(:,2),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(489),RedSet_5(11),mass5set(:,3),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(537),RedSet_5(12),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),2)
  call Hotf_5pt_reduction_last(G2tensor(517),RedSet_5(12),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),2)
  call Hotf_5pt_reduction_last(G2tensor(525),RedSet_5(12),mass5set(:,3),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(2),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[24,2,1,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(5),m4h2x2x8(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[24,1,2,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j+M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(28,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex4(:),ex5(:),G0H8(8),m4h2x2x8(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(10),m4h2x2x8(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(11),m4h2x2x8(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[20,2,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(14),m4h2x2x8(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[20,1,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex3(:),ex5(:),G0H8(17),m4h2x2x8(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[20,1,8,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(18),m4h2x2x8(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,133),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,1,2,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,135),heltab2x32(:,:,135))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,136),heltab2x32(:,:,136))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,2,1,12],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,139),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,140),heltab2x32(:,:,140))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,1,12,2],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,141),heltab2x32(:,:,141))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[18,4,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(19),m4h2x2x8(:,19),heltab3x32(:,:,19))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[18,4,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(20),m4h2x2x8(:,20),heltab3x32(:,:,20))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[18,4,1,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(21),m4h2x2x8(:,21),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[18,1,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(22),m4h2x2x8(:,22),heltab3x32(:,:,22))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[18,1,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(23),m4h2x2x8(:,23),heltab3x32(:,:,23))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[18,1,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(24),m4h2x2x8(:,24),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[18,1,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(25),m4h2x2x8(:,25),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[18,1,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex2(:),ex5(:),G0H8(26),m4h2x2x8(:,26),heltab3x32(:,:,26))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[18,1,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex2(:),G0H8(27),m4h2x2x8(:,27),heltab3x32(:,:,27))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,1,4,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,142),heltab2x32(:,:,142))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,1,4,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,143),heltab2x32(:,:,143))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,1,4,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,144),heltab2x32(:,:,144))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j+M(14,:)%j+M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j-M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,4,1,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,145),heltab2x32(:,:,145))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,4,1,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,146),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,4,1,10],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,147),heltab2x32(:,:,147))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,1,10,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,148),heltab2x32(:,:,148))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,1,10,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,149),heltab2x32(:,:,149))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,1,10,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,150),heltab2x32(:,:,150))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j-M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(35,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,1,8,6],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,151),heltab2x32(:,:,151))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(16,:)%j+M(17,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(33,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,1,8,6],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,152),heltab2x32(:,:,152))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,1,8,6],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,153),heltab2x32(:,:,153))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,6,1,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,154),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,6,1,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,155),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,6,1,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,156),heltab2x32(:,:,156))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,1,6,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,157),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,1,6,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,158),heltab2x32(:,:,158))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,1,6,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(7),m3h2x16(:,159),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[17,4,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(28),m4h2x2x8(:,28),heltab3x32(:,:,28))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[17,4,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(29),m4h2x2x8(:,29),heltab3x32(:,:,29))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[17,4,2,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(30),m4h2x2x8(:,30),heltab3x32(:,:,30))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[17,2,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(31),m4h2x2x8(:,31),heltab3x32(:,:,31))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[17,2,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(32),m4h2x2x8(:,32),heltab3x32(:,:,32))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[17,2,4,8],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(33),m4h2x2x8(:,33),heltab3x32(:,:,33))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[17,2,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(34),m4h2x2x8(:,34),heltab3x32(:,:,34))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[17,2,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex1(:),ex5(:),G0H8(35),m4h2x2x8(:,35),heltab3x32(:,:,35))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[17,2,8,4],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),ex1(:),G0H8(36),m4h2x2x8(:,36),heltab3x32(:,:,36))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(35,:)%j-M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,2,4,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,160),heltab2x32(:,:,160))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,2,4,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,161),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,2,4,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,162),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j+M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(33,:)%j-M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,4,2,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,163),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,4,2,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,164),heltab2x32(:,:,164))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,4,2,9],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,165),heltab2x32(:,:,165))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,2,9,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,166),heltab2x32(:,:,166))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,2,9,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,2,9,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,2,8,5],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j &
    -M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j+M(34,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,2,8,5],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,170),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,2,8,5],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,171),heltab2x32(:,:,171))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,5,2,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(20),m3h2x16(:,172),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,5,2,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,173),heltab2x32(:,:,173))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,5,2,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,174),heltab2x32(:,:,174))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(28,:)%j-M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,2,5,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,175),heltab2x32(:,:,175))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,2,5,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,176),heltab2x32(:,:,176))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,2,5,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,177),heltab2x32(:,:,177))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j-M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(36,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,3,8,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,178),heltab2x32(:,:,178))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j+M(13,:)%j-M(14,:)%j-M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,3,8,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,179),heltab2x32(:,:,179))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,3,8,4],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,180),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j-M(7,:)%j+M(8,:)%j-M(9,:)%j-M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(26,:)%j-M(30,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,3,4,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,181),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j-M(6,:)%j+M(7,:)%j+M(8,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j &
    +M(12,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,3,4,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,182),heltab2x32(:,:,182))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,3,4,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,183),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j+M(6,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j-M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,4,3,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,184),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j+M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j &
    +M(12,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(16,:)%j-M(17,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(32,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,4,3,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,4,3,8],[0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,186),heltab2x32(:,:,186))
  Gcoeff(:)%j = (c(9)*(M(25,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(37),n2h16(97))
  Gcoeff(:)%j = (c(8)*(M(25,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(98))
  Gcoeff(:)%j = (c(9)*(M(23,:)%j-M(36,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(41),n2h16(99))
  Gcoeff(:)%j = (c(8)*(M(23,:)%j-M(36,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(100))
  Gcoeff(:)%j = (c(9)*(M(25,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(43),n2h16(101))
  Gcoeff(:)%j = (c(8)*(M(25,:)%j-M(42,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(102))
  Gcoeff(:)%j = (c(9)*(M(23,:)%j-M(36,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(49),n2h16(103))
  Gcoeff(:)%j = (c(8)*(M(23,:)%j-M(36,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(104))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(23,:)%j+M(25,:)%j-M(36,:)%j-M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,195),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(23,:)%j+M(25,:)%j-M(36,:)%j-M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(48),m3h2x16(:,196),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(23,:)%j-M(25,:)%j+M(36,:)%j+M(42,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,3,8,4],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,197),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(30,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(52),n2h16(105))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(30,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(106))
  Gcoeff(:)%j = (c(9)*(M(26,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,200),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(54),n2h16(107))
  Gcoeff(:)%j = (c(8)*(M(26,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(55),n2h16(108))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(30,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(60),n2h16(109))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(30,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(110))
  Gcoeff(:)%j = (c(9)*(M(26,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(62),n2h16(111))
  Gcoeff(:)%j = (c(8)*(M(26,:)%j-M(44,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(59),n2h16(112))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(21,:)%j+M(26,:)%j-M(30,:)%j-M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(61),m3h2x16(:,206),heltab2x32(:,:,206))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(21,:)%j+M(26,:)%j-M(30,:)%j-M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(63),m3h2x16(:,207),heltab2x32(:,:,207))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(21,:)%j-M(26,:)%j+M(30,:)%j+M(44,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,3,4,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,208),heltab2x32(:,:,208))
  Gcoeff(:)%j = (c(9)*(M(22,:)%j-M(32,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(65),n2h16(113))
  Gcoeff(:)%j = (c(8)*(M(22,:)%j-M(32,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(66),n2h16(114))
  Gcoeff(:)%j = (c(9)*(M(24,:)%j-M(38,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(71),n2h16(115))
  Gcoeff(:)%j = (c(8)*(M(24,:)%j-M(38,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(116))
  Gcoeff(:)%j = (c(9)*(M(22,:)%j-M(32,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(73),n2h16(117))
  Gcoeff(:)%j = (c(8)*(M(22,:)%j-M(32,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(70),n2h16(118))
  Gcoeff(:)%j = (c(9)*(M(24,:)%j-M(38,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(72),n2h16(119))
  Gcoeff(:)%j = (c(8)*(M(24,:)%j-M(38,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(74),n2h16(120))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(22,:)%j+M(24,:)%j-M(32,:)%j-M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(75),m3h2x16(:,217),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j+M(2,:)%j+M(3,:)%j-M(4,:)%j-M(7,:)%j-M(10,:)%j)+c(6)*(M(22,:)%j+M(24,:)%j-M(32,:)%j-M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(76),m3h2x16(:,218),heltab2x32(:,:,218))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j+M(4,:)%j+M(7,:)%j+M(10,:)%j)+c(6)*(-M(22,:)%j-M(24,:)%j+M(32,:)%j+M(38,:)%j))  &
    * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,4,3,8],[0,0,0,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(77),m3h2x16(:,219),heltab2x32(:,:,219))
  Gcoeff(:)%j = (c(9)*(M(31,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(82),n2h16(121))
  Gcoeff(:)%j = (c(8)*(M(31,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,2,8,5],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(79),n2h16(122))
  Gcoeff(:)%j = (c(9)*(M(29,:)%j-M(34,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(84),n2h16(123))
  Gcoeff(:)%j = (c(8)*(M(29,:)%j-M(34,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,2,8,5],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(124))
  Gcoeff(:)%j = (c(9)*(M(31,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(83),n2h16(125))
  Gcoeff(:)%j = (c(8)*(M(31,:)%j-M(40,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,2,8,5],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(85),n2h16(126))
  Gcoeff(:)%j = (c(9)*(M(29,:)%j-M(34,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(86),n2h16(127))
  Gcoeff(:)%j = (c(8)*(M(29,:)%j-M(34,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,2,8,5],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(87),n2h16(128))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(M(29,:)%j+M(31,:)%j-M(34,:)%j-M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(88),m3h2x16(:,228),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(M(29,:)%j+M(31,:)%j-M(34,:)%j-M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,229),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(-M(29,:)%j-M(31,:)%j+M(34,:)%j+M(40,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,2,8,5],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,230),heltab2x32(:,:,230))
  Gcoeff(:)%j = (c(9)*(-M(24,:)%j+M(27,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(95),n2h16(129))
  Gcoeff(:)%j = (c(8)*(-M(24,:)%j+M(27,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,5,2,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(92),n2h16(130))
  Gcoeff(:)%j = (c(9)*(M(32,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,233),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(94),n2h16(131))
  Gcoeff(:)%j = (c(8)*(M(32,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,5,2,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(96),n2h16(132))
  Gcoeff(:)%j = (c(9)*(-M(24,:)%j+M(27,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(97),n2h16(133))
  Gcoeff(:)%j = (c(8)*(-M(24,:)%j+M(27,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,5,2,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,236),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(98),n2h16(134))
  Gcoeff(:)%j = (c(9)*(M(32,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,237))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(99),n2h16(135))
  Gcoeff(:)%j = (c(8)*(M(32,:)%j-M(43,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,5,2,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,238),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(104),n2h16(136))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(24,:)%j+M(27,:)%j+M(32,:)%j-M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(101),m3h2x16(:,239),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(24,:)%j+M(27,:)%j+M(32,:)%j-M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,240),heltab2x32(:,:,240))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(24,:)%j-M(27,:)%j-M(32,:)%j+M(43,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,5,2,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,241),heltab2x32(:,:,241))
  Gcoeff(:)%j = (c(9)*(-M(26,:)%j+M(28,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(105),n2h16(137))
  Gcoeff(:)%j = (c(8)*(-M(26,:)%j+M(28,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,2,5,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(107),n2h16(138))
  Gcoeff(:)%j = (c(9)*(M(30,:)%j-M(37,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(108),n2h16(139))
  Gcoeff(:)%j = (c(8)*(M(30,:)%j-M(37,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,2,5,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(109),n2h16(140))
  Gcoeff(:)%j = (c(9)*(-M(26,:)%j+M(28,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(110),n2h16(141))
  Gcoeff(:)%j = (c(8)*(-M(26,:)%j+M(28,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,2,5,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(115),n2h16(142))
  Gcoeff(:)%j = (c(9)*(M(30,:)%j-M(37,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(112),n2h16(143))
  Gcoeff(:)%j = (c(8)*(M(30,:)%j-M(37,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,2,5,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(117),n2h16(144))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(26,:)%j+M(28,:)%j+M(30,:)%j-M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,250),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j+M(5,:)%j+M(6,:)%j-M(8,:)%j-M(11,:)%j)+c(6)*(-M(26,:)%j+M(28,:)%j+M(30,:)%j-M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(116),m3h2x16(:,251),heltab2x32(:,:,251))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j-M(5,:)%j-M(6,:)%j+M(8,:)%j+M(11,:)%j)+c(6)*(M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j))  &
    * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,2,5,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,252),heltab2x32(:,:,252))
  Gcoeff(:)%j = (c(9)*(M(33,:)%j-M(35,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(119),n2h16(145))
  Gcoeff(:)%j = (c(8)*(M(33,:)%j-M(35,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,1,8,6],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(120),n2h16(146))
  Gcoeff(:)%j = (c(9)*(M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(121),n2h16(147))
  Gcoeff(:)%j = (c(8)*(M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,1,8,6],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(126),n2h16(148))
  Gcoeff(:)%j = (c(9)*(M(33,:)%j-M(35,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(123),n2h16(149))
  Gcoeff(:)%j = (c(8)*(M(33,:)%j-M(35,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,1,8,6],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(128),n2h16(150))
  Gcoeff(:)%j = (c(9)*(M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(125),n2h16(151))
  Gcoeff(:)%j = (c(8)*(M(39,:)%j-M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,1,8,6],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(127),n2h16(152))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(129),m3h2x16(:,261),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(33,:)%j-M(35,:)%j+M(39,:)%j-M(41,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(130),m3h2x16(:,262),heltab2x32(:,:,262))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(33,:)%j+M(35,:)%j-M(39,:)%j &
    +M(41,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,1,8,6],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(131),m3h2x16(:,263),heltab2x32(:,:,263))
  Gcoeff(:)%j = (c(9)*(M(37,:)%j-M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(132),n2h16(153))
  Gcoeff(:)%j = (c(8)*(M(37,:)%j-M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,6,1,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(133),n2h16(154))
  Gcoeff(:)%j = (c(9)*(M(22,:)%j-M(28,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(134),n2h16(155))
  Gcoeff(:)%j = (c(8)*(M(22,:)%j-M(28,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,6,1,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,267),heltab2x32(:,:,267))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(135),n2h16(156))
  Gcoeff(:)%j = (c(9)*(M(37,:)%j-M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,268),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(136),n2h16(157))
  Gcoeff(:)%j = (c(8)*(M(37,:)%j-M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,6,1,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,269),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(137),n2h16(158))
  Gcoeff(:)%j = (c(9)*(M(22,:)%j-M(28,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,270),heltab2x32(:,:,270))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(138),n2h16(159))
  Gcoeff(:)%j = (c(8)*(M(22,:)%j-M(28,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,6,1,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,271),heltab2x32(:,:,271))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(139),n2h16(160))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(22,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(140),m3h2x16(:,272),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(22,:)%j-M(28,:)%j+M(37,:)%j-M(38,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(141),m3h2x16(:,273),heltab2x32(:,:,273))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(22,:)%j+M(28,:)%j-M(37,:)%j &
    +M(38,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,6,1,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(142),m3h2x16(:,274),heltab2x32(:,:,274))
  Gcoeff(:)%j = (c(9)*(M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,275),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(143),n2h16(161))
  Gcoeff(:)%j = (c(8)*(M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,1,6,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,276),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(144),n2h16(162))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(27,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,277),heltab2x32(:,:,277))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(145),n2h16(163))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(27,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,1,6,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,278),heltab2x32(:,:,278))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(146),n2h16(164))
  Gcoeff(:)%j = (c(9)*(M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,279),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(147),n2h16(165))
  Gcoeff(:)%j = (c(8)*(M(43,:)%j-M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,1,6,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,280),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(148),n2h16(166))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(27,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,281),heltab2x32(:,:,281))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(149),n2h16(167))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(27,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,1,6,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,282),heltab2x32(:,:,282))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(150),n2h16(168))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(21,:)%j-M(27,:)%j+M(43,:)%j-M(44,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(151),m3h2x16(:,283),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(4,:)%j+M(13,:)%j+M(14,:)%j-M(15,:)%j-M(17,:)%j)+c(6)*(M(21,:)%j-M(27,:)%j+M(43,:)%j-M(44,:)%j))  &
    * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(152),m3h2x16(:,284),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(4,:)%j-M(13,:)%j-M(14,:)%j+M(15,:)%j+M(17,:)%j)+c(6)*(-M(21,:)%j+M(27,:)%j-M(43,:)%j &
    +M(44,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,1,6,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(153),m3h2x16(:,285),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(9)*(M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,286),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(154),n2h16(169))
  Gcoeff(:)%j = (c(8)*(M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,2,4,9],[nMT,nMT,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,287),heltab2x32(:,:,287))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(155),n2h16(170))
  Gcoeff(:)%j = (c(9)*(-M(28,:)%j+M(35,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,288),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(156),n2h16(171))
  Gcoeff(:)%j = (c(8)*(-M(28,:)%j+M(35,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,2,4,9],[nMT,nMT,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,289),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(157),n2h16(172))
  Gcoeff(:)%j = (c(9)*(M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,290),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(158),n2h16(173))
  Gcoeff(:)%j = (c(8)*(M(37,:)%j-M(39,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,2,4,9],[nMB,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,291),heltab2x32(:,:,291))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(159),n2h16(174))
  Gcoeff(:)%j = (c(9)*(-M(28,:)%j+M(35,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,292),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(160),n2h16(175))
  Gcoeff(:)%j = (c(8)*(-M(28,:)%j+M(35,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,2,4,9],[nMB,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,293),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(161),n2h16(176))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(28,:)%j+M(35,:)%j+M(37,:)%j-M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(162),m3h2x16(:,294),heltab2x32(:,:,294))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(28,:)%j+M(35,:)%j+M(37,:)%j-M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(163),m3h2x16(:,295),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(28,:)%j-M(35,:)%j-M(37,:)%j+M(39,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,2,4,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(164),m3h2x16(:,296),heltab2x32(:,:,296))
  Gcoeff(:)%j = (c(9)*(-M(22,:)%j+M(33,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,297),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(165),n2h16(177))
  Gcoeff(:)%j = (c(8)*(-M(22,:)%j+M(33,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,4,2,9],[nMT,nMT,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,298),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(166),n2h16(178))
  Gcoeff(:)%j = (c(9)*(M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,299),heltab2x32(:,:,299))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(167),n2h16(179))
  Gcoeff(:)%j = (c(8)*(M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,4,2,9],[nMT,nMT,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,300),heltab2x32(:,:,300))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(168),n2h16(180))
  Gcoeff(:)%j = (c(9)*(-M(22,:)%j+M(33,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,301),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(169),n2h16(181))
  Gcoeff(:)%j = (c(8)*(-M(22,:)%j+M(33,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,4,2,9],[nMB,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,302),heltab2x32(:,:,302))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(170),n2h16(182))
  Gcoeff(:)%j = (c(9)*(M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,303),heltab2x32(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(171),n2h16(183))
  Gcoeff(:)%j = (c(8)*(M(38,:)%j-M(41,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,4,2,9],[nMB,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,304),heltab2x32(:,:,304))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(172),n2h16(184))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(22,:)%j+M(33,:)%j+M(38,:)%j-M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,305),heltab2x32(:,:,305))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(22,:)%j+M(33,:)%j+M(38,:)%j-M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(174),m3h2x16(:,306),heltab2x32(:,:,306))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(22,:)%j-M(33,:)%j-M(38,:)%j+M(41,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,4,2,9],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,307),heltab2x32(:,:,307))
  Gcoeff(:)%j = (c(9)*(-M(25,:)%j+M(34,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(176),n2h16(185))
  Gcoeff(:)%j = (c(8)*(-M(25,:)%j+M(34,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,2,9,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(177),n2h16(186))
  Gcoeff(:)%j = (c(9)*(-M(31,:)%j+M(36,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(178),n2h16(187))
  Gcoeff(:)%j = (c(8)*(-M(31,:)%j+M(36,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,2,9,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(179),n2h16(188))
  Gcoeff(:)%j = (c(9)*(-M(25,:)%j+M(34,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(180),n2h16(189))
  Gcoeff(:)%j = (c(8)*(-M(25,:)%j+M(34,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,2,9,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(181),n2h16(190))
  Gcoeff(:)%j = (c(9)*(-M(31,:)%j+M(36,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(182),n2h16(191))
  Gcoeff(:)%j = (c(8)*(-M(31,:)%j+M(36,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,2,9,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(183),n2h16(192))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(25,:)%j-M(31,:)%j+M(34,:)%j+M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(184),m3h2x16(:,316),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j-M(5,:)%j+M(7,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)+c(6)*(-M(25,:)%j-M(31,:)%j+M(34,:)%j+M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(185),m3h2x16(:,317),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j+M(5,:)%j-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)+c(6)*(M(25,:)%j+M(31,:)%j-M(34,:)%j-M(36,:)%j))  &
    * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,2,9,4],[0,0,0,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(186),m3h2x16(:,318),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(9)*(M(27,:)%j-M(29,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,319),heltab2x32(:,:,319))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(187),n2h16(193))
  Gcoeff(:)%j = (c(8)*(M(27,:)%j-M(29,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,1,4,10],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,320),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(188),n2h16(194))
  Gcoeff(:)%j = (c(9)*(M(40,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,321),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(189),n2h16(195))
  Gcoeff(:)%j = (c(8)*(M(40,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,1,4,10],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,322),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(190),n2h16(196))
  Gcoeff(:)%j = (c(9)*(M(27,:)%j-M(29,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,323),heltab2x32(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(191),n2h16(197))
  Gcoeff(:)%j = (c(8)*(M(27,:)%j-M(29,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,1,4,10],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,324),heltab2x32(:,:,324))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(192),n2h16(198))
  Gcoeff(:)%j = (c(9)*(M(40,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,325),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(193),n2h16(199))
  Gcoeff(:)%j = (c(8)*(M(40,:)%j-M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,1,4,10],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,326),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(194),n2h16(200))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(27,:)%j-M(29,:)%j+M(40,:)%j-M(43,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(195),m3h2x16(:,327),heltab2x32(:,:,327))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(27,:)%j-M(29,:)%j+M(40,:)%j-M(43,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(196),m3h2x16(:,328),heltab2x32(:,:,328))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(27,:)%j+M(29,:)%j-M(40,:)%j &
    +M(43,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,1,4,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(197),m3h2x16(:,329),heltab2x32(:,:,329))
  Gcoeff(:)%j = (c(9)*(M(31,:)%j-M(32,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,330),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(198),n2h16(201))
  Gcoeff(:)%j = (c(8)*(M(31,:)%j-M(32,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,4,1,10],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,331),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(199),n2h16(202))
  Gcoeff(:)%j = (c(9)*(M(24,:)%j-M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,332),heltab2x32(:,:,332))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(200),n2h16(203))
  Gcoeff(:)%j = (c(8)*(M(24,:)%j-M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,4,1,10],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,333),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(201),n2h16(204))
  Gcoeff(:)%j = (c(9)*(M(31,:)%j-M(32,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,334),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(202),n2h16(205))
  Gcoeff(:)%j = (c(8)*(M(31,:)%j-M(32,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,4,1,10],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,335),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(203),n2h16(206))
  Gcoeff(:)%j = (c(9)*(M(24,:)%j-M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,336),heltab2x32(:,:,336))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(204),n2h16(207))
  Gcoeff(:)%j = (c(8)*(M(24,:)%j-M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,4,1,10],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,337),heltab2x32(:,:,337))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(205),n2h16(208))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(24,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(206),m3h2x16(:,338),heltab2x32(:,:,338))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(24,:)%j+M(31,:)%j-M(32,:)%j-M(34,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(207),m3h2x16(:,339),heltab2x32(:,:,339))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(24,:)%j-M(31,:)%j+M(32,:)%j &
    +M(34,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[16,4,1,10],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(208),m3h2x16(:,340),heltab2x32(:,:,340))
  Gcoeff(:)%j = (c(9)*(M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,341),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(209),n2h16(209))
  Gcoeff(:)%j = (c(8)*(M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[16,1,10,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,342),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(210),n2h16(210))
  Gcoeff(:)%j = (c(9)*(M(23,:)%j-M(33,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(211),n2h16(211))
  Gcoeff(:)%j = (c(8)*(M(23,:)%j-M(33,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[16,1,10,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(212),n2h16(212))
  Gcoeff(:)%j = (c(9)*(M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,345),heltab2x32(:,:,345))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(213),n2h16(213))
  Gcoeff(:)%j = (c(8)*(M(41,:)%j-M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[16,1,10,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,346),heltab2x32(:,:,346))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(214),n2h16(214))
  Gcoeff(:)%j = (c(9)*(M(23,:)%j-M(33,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(215),n2h16(215))
  Gcoeff(:)%j = (c(8)*(M(23,:)%j-M(33,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[16,1,10,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(216),n2h16(216))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(23,:)%j-M(33,:)%j+M(41,:)%j-M(42,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(217),m3h2x16(:,349),heltab2x32(:,:,349))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j+M(16,:)%j-M(18,:)%j)+c(6)*(M(23,:)%j-M(33,:)%j+M(41,:)%j-M(42,:)%j))  &
    * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(218),m3h2x16(:,350),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j-M(16,:)%j+M(18,:)%j)+c(6)*(-M(23,:)%j+M(33,:)%j-M(41,:)%j &
    +M(42,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[16,1,10,4],[0,0,0,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(219),m3h2x16(:,351),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(23,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(220),n2h16(217))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(23,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[16,1,2,12],[nMT,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,353),heltab2x32(:,:,353))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(221),n2h16(218))
  Gcoeff(:)%j = (c(9)*(M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,354),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(222),n2h16(219))
  Gcoeff(:)%j = (c(8)*(M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,1,2,12],[nMT,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(223),n2h16(220))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(23,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(224),n2h16(221))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(23,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,1,2,12],[nMB,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,357),heltab2x32(:,:,357))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(225),n2h16(222))
  Gcoeff(:)%j = (c(9)*(M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,358),heltab2x32(:,:,358))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(226),n2h16(223))
  Gcoeff(:)%j = (c(8)*(M(42,:)%j-M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,1,2,12],[nMB,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(227),n2h16(224))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(23,:)%j+M(42,:)%j-M(44,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(228),m3h2x16(:,360),heltab2x32(:,:,360))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(23,:)%j+M(42,:)%j-M(44,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(229),m3h2x16(:,361),heltab2x32(:,:,361))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(23,:)%j-M(42,:)%j &
    +M(44,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[16,1,2,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,362),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(9)*(M(25,:)%j-M(26,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(231),n2h16(225))
  Gcoeff(:)%j = (c(8)*(M(25,:)%j-M(26,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[16,2,1,12],[nMT,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(232),n2h16(226))
  Gcoeff(:)%j = (c(9)*(M(30,:)%j-M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,365),heltab2x32(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(233),n2h16(227))
  Gcoeff(:)%j = (c(8)*(M(30,:)%j-M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,2,1,12],[nMT,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,366),heltab2x32(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(234),n2h16(228))
  Gcoeff(:)%j = (c(9)*(M(25,:)%j-M(26,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(235),n2h16(229))
  Gcoeff(:)%j = (c(8)*(M(25,:)%j-M(26,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,2,1,12],[nMB,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(236),n2h16(230))
  Gcoeff(:)%j = (c(9)*(M(30,:)%j-M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,369),heltab2x32(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(237),n2h16(231))
  Gcoeff(:)%j = (c(8)*(M(30,:)%j-M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,2,1,12],[nMB,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,370),heltab2x32(:,:,370))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(238),n2h16(232))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,371),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(30,:)%j-M(36,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(240),m3h2x16(:,372),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(30,:)%j &
    +M(36,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,2,1,12],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(241),m3h2x16(:,373),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(9)*(M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,374),heltab2x32(:,:,374))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(242),n2h16(233))
  Gcoeff(:)%j = (c(8)*(M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[16,1,12,2],[nMT,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,375),heltab2x32(:,:,375))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(243),n2h16(234))
  Gcoeff(:)%j = (c(9)*(M(29,:)%j-M(35,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,376),heltab2x32(:,:,376))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(244),n2h16(235))
  Gcoeff(:)%j = (c(8)*(M(29,:)%j-M(35,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[16,1,12,2],[nMT,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,377),heltab2x32(:,:,377))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(245),n2h16(236))
  Gcoeff(:)%j = (c(9)*(M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,378),heltab2x32(:,:,378))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(246),n2h16(237))
  Gcoeff(:)%j = (c(8)*(M(39,:)%j-M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[16,1,12,2],[nMB,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,379),heltab2x32(:,:,379))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(247),n2h16(238))
  Gcoeff(:)%j = (c(9)*(M(29,:)%j-M(35,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,380),heltab2x32(:,:,380))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(248),n2h16(239))
  Gcoeff(:)%j = (c(8)*(M(29,:)%j-M(35,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[16,1,12,2],[nMB,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,381),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(249),n2h16(240))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(250),m3h2x16(:,382),heltab2x32(:,:,382))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(8,:)%j+M(13,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(29,:)%j-M(35,:)%j+M(39,:)%j-M(40,:)%j))  &
    * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(251),m3h2x16(:,383),heltab2x32(:,:,383))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(8,:)%j-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(29,:)%j+M(35,:)%j-M(39,:)%j &
    +M(40,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[16,1,12,2],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(252),m3h2x16(:,384),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(9)*(-M(33,:)%j+M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,1),heltab2x32(:,:,385))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(1),n2h8(181))
  Gcoeff(:)%j = (c(8)*(-M(33,:)%j+M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[17,4,2,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,2),heltab2x32(:,:,386))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMT,G1H8(2),n2h8(182))
  Gcoeff(:)%j = (c(9)*(-M(27,:)%j+M(41,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,3),heltab2x32(:,:,387))
  call Hloop_A_Q(ntryL,G0H8(37),17,0,G1H8(4),n2h8(183))
  Gcoeff(:)%j = (c(8)*(-M(27,:)%j+M(41,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[17,4,2,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,4),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G0H8(37),17,nMT,G1H8(5),n2h8(184))
  Gcoeff(:)%j = (c(9)*(-M(33,:)%j+M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,5),heltab2x32(:,:,389))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(6),n2h8(185))
  Gcoeff(:)%j = (c(8)*(-M(33,:)%j+M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[17,4,2,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,6),heltab2x32(:,:,390))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(7),n2h8(186))
  Gcoeff(:)%j = (c(9)*(-M(27,:)%j+M(41,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,7),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G0H8(37),17,0,G1H8(8),n2h8(187))
  Gcoeff(:)%j = (c(8)*(-M(27,:)%j+M(41,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[17,4,2,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,8),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H8(37),17,nMB,G1H8(10),n2h8(188))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(27,:)%j-M(33,:)%j+M(41,:)%j &
    +M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(11),m3h4x8(:,9),heltab2x32(:,:,393))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(27,:)%j-M(33,:)%j+M(41,:)%j &
    +M(43,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(12),m3h4x8(:,10),heltab2x32(:,:,394))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(27,:)%j+M(33,:)%j-M(41,:)%j-M(43,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[17,4,2,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(13),m3h4x8(:,11),heltab2x32(:,:,395))
  Gcoeff(:)%j = (c(9)*(-M(21,:)%j+M(39,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,12),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G0H8(37),17,0,G1H8(14),n2h8(189))
  Gcoeff(:)%j = (c(8)*(-M(21,:)%j+M(39,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[17,2,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,13),heltab2x32(:,:,397))
  call Hloop_A_Q(ntryL,G0H8(37),17,nMT,G1H8(16),n2h8(190))
  Gcoeff(:)%j = (c(9)*(-M(35,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,14),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(17),n2h8(191))
  Gcoeff(:)%j = (c(8)*(-M(35,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[17,2,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,15),heltab2x32(:,:,399))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMT,G1H8(18),n2h8(192))
  Gcoeff(:)%j = (c(9)*(-M(21,:)%j+M(39,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,16),heltab2x32(:,:,400))
  call Hloop_A_Q(ntryL,G0H8(37),17,0,G1H8(19),n2h8(193))
  Gcoeff(:)%j = (c(8)*(-M(21,:)%j+M(39,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[17,2,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,17),heltab2x32(:,:,401))
  call Hloop_A_Q(ntryL,G0H8(37),17,nMB,G1H8(20),n2h8(194))
  Gcoeff(:)%j = (c(9)*(-M(35,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,18),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(22),n2h8(195))
  Gcoeff(:)%j = (c(8)*(-M(35,:)%j+M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[17,2,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,19),heltab2x32(:,:,403))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(23),n2h8(196))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(21,:)%j-M(35,:)%j+M(39,:)%j &
    +M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(24),m3h4x8(:,20),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(21,:)%j-M(35,:)%j+M(39,:)%j &
    +M(44,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(25),m3h4x8(:,21),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(21,:)%j+M(35,:)%j-M(39,:)%j-M(44,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(26),m3h4x8(:,22),heltab2x32(:,:,406))
  Gcoeff(:)%j = (c(9)*(-M(23,:)%j+M(40,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,23),heltab2x32(:,:,407))
  call Hloop_A_Q(ntryL,G0H8(37),17,0,G1H8(28),n2h8(197))
  Gcoeff(:)%j = (c(8)*(-M(23,:)%j+M(40,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[17,2,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,24),heltab2x32(:,:,408))
  call Hloop_A_Q(ntryL,G0H8(37),17,nMT,G1H8(29),n2h8(198))
  Gcoeff(:)%j = (c(9)*(-M(29,:)%j+M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,25),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(30),n2h8(199))
  Gcoeff(:)%j = (c(8)*(-M(29,:)%j+M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[17,2,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,26),heltab2x32(:,:,410))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMT,G1H8(31),n2h8(200))
  Gcoeff(:)%j = (c(9)*(-M(23,:)%j+M(40,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,27),heltab2x32(:,:,411))
  call Hloop_A_Q(ntryL,G0H8(37),17,0,G1H8(32),n2h8(201))
  Gcoeff(:)%j = (c(8)*(-M(23,:)%j+M(40,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[17,2,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,28),heltab2x32(:,:,412))
  call Hloop_A_Q(ntryL,G0H8(37),17,nMB,G1H8(34),n2h8(202))
  Gcoeff(:)%j = (c(9)*(-M(29,:)%j+M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,29),heltab2x32(:,:,413))
  call Hloop_Q_A(ntryL,G0H8(37),17,0,G1H8(35),n2h8(203))
  Gcoeff(:)%j = (c(8)*(-M(29,:)%j+M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[17,2,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(37),m3h4x8(:,30),heltab2x32(:,:,414))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(36),n2h8(204))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(23,:)%j-M(29,:)%j+M(40,:)%j &
    +M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,4),G1H8(37),m3h4x8(:,31),heltab2x32(:,:,415))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(11,:)%j+M(12,:)%j)+c(6)*(-M(23,:)%j-M(29,:)%j+M(40,:)%j &
    +M(42,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(38),m3h4x8(:,32),heltab2x32(:,:,416))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j+M(6,:)%j+M(9,:)%j-M(10,:)%j-M(11,:)%j-M(12,:)%j)+c(6)*(M(23,:)%j+M(29,:)%j-M(40,:)%j-M(42,:)%j))  &
    * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,4),17,G1H8(40),m3h4x8(:,33),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(9)*(M(28,:)%j-M(31,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,34),heltab2x32(:,:,418))
  call Hloop_Q_A(ntryL,G0H8(37),18,0,G1H8(41),n2h8(205))
  Gcoeff(:)%j = (c(8)*(M(28,:)%j-M(31,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[18,4,1,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,35),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G0H8(37),18,nMT,G1H8(42),n2h8(206))
  Gcoeff(:)%j = (c(9)*(M(34,:)%j-M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,36),heltab2x32(:,:,420))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(43),n2h8(207))
  Gcoeff(:)%j = (c(8)*(M(34,:)%j-M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[18,4,1,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,37),heltab2x32(:,:,421))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(44),n2h8(208))
  Gcoeff(:)%j = (c(9)*(M(28,:)%j-M(31,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,38),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G0H8(37),18,0,G1H8(46),n2h8(209))
  Gcoeff(:)%j = (c(8)*(M(28,:)%j-M(31,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[18,4,1,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,39),heltab2x32(:,:,423))
  call Hloop_Q_A(ntryL,G0H8(37),18,nMB,G1H8(47),n2h8(210))
  Gcoeff(:)%j = (c(9)*(M(34,:)%j-M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,40),heltab2x32(:,:,424))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(48),n2h8(211))
  Gcoeff(:)%j = (c(8)*(M(34,:)%j-M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[18,4,1,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,41),heltab2x32(:,:,425))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMB,G1H8(49),n2h8(212))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(28,:)%j-M(31,:)%j+M(34,:)%j &
    -M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(50),m3h4x8(:,42),heltab2x32(:,:,426))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(28,:)%j-M(31,:)%j+M(34,:)%j &
    -M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(52),m3h4x8(:,43),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(28,:)%j+M(31,:)%j-M(34,:)%j &
    +M(37,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[18,4,1,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(53),m3h4x8(:,44),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(9)*(M(29,:)%j-M(30,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,45),heltab2x32(:,:,429))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(54),n2h8(213))
  Gcoeff(:)%j = (c(8)*(M(29,:)%j-M(30,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[18,1,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,46),heltab2x32(:,:,430))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(55),n2h8(214))
  Gcoeff(:)%j = (c(9)*(M(26,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,47),heltab2x32(:,:,431))
  call Hloop_Q_A(ntryL,G0H8(37),18,0,G1H8(56),n2h8(215))
  Gcoeff(:)%j = (c(8)*(M(26,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[18,1,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,48),heltab2x32(:,:,432))
  call Hloop_Q_A(ntryL,G0H8(37),18,nMT,G1H8(58),n2h8(216))
  Gcoeff(:)%j = (c(9)*(M(29,:)%j-M(30,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,49),heltab2x32(:,:,433))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(59),n2h8(217))
  Gcoeff(:)%j = (c(8)*(M(29,:)%j-M(30,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[18,1,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,50),heltab2x32(:,:,434))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMB,G1H8(60),n2h8(218))
  Gcoeff(:)%j = (c(9)*(M(26,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,51),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G0H8(37),18,0,G1H8(61),n2h8(219))
  Gcoeff(:)%j = (c(8)*(M(26,:)%j-M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[18,1,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,52),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G0H8(37),18,nMB,G1H8(62),n2h8(220))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(26,:)%j+M(29,:)%j-M(30,:)%j &
    -M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(64),m3h4x8(:,53),heltab2x32(:,:,437))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(26,:)%j+M(29,:)%j-M(30,:)%j &
    -M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(65),m3h4x8(:,54),heltab2x32(:,:,438))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j+M(30,:)%j &
    +M(40,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[18,1,4,8],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(66),m3h4x8(:,55),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(9)*(M(35,:)%j-M(36,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,56),heltab2x32(:,:,440))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(67),n2h8(221))
  Gcoeff(:)%j = (c(8)*(M(35,:)%j-M(36,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[18,1,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,57),heltab2x32(:,:,441))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(68),n2h8(222))
  Gcoeff(:)%j = (c(9)*(M(25,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,58),heltab2x32(:,:,442))
  call Hloop_Q_A(ntryL,G0H8(37),18,0,G1H8(70),n2h8(223))
  Gcoeff(:)%j = (c(8)*(M(25,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[18,1,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,59),heltab2x32(:,:,443))
  call Hloop_Q_A(ntryL,G0H8(37),18,nMT,G1H8(71),n2h8(224))
  Gcoeff(:)%j = (c(9)*(M(35,:)%j-M(36,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,60),heltab2x32(:,:,444))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(72),n2h8(225))
  Gcoeff(:)%j = (c(8)*(M(35,:)%j-M(36,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[18,1,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,61),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMB,G1H8(73),n2h8(226))
  Gcoeff(:)%j = (c(9)*(M(25,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,62),heltab2x32(:,:,446))
  call Hloop_Q_A(ntryL,G0H8(37),18,0,G1H8(74),n2h8(227))
  Gcoeff(:)%j = (c(8)*(M(25,:)%j-M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[18,1,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,7),G0H8(37),m3h4x8(:,63),heltab2x32(:,:,447))
  call Hloop_Q_A(ntryL,G0H8(37),18,nMB,G1H8(76),n2h8(228))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(25,:)%j+M(35,:)%j-M(36,:)%j &
    -M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,7),G1H8(77),m3h4x8(:,64),heltab2x32(:,:,448))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(10,:)%j-M(14,:)%j-M(16,:)%j+M(17,:)%j+M(18,:)%j)+c(6)*(M(25,:)%j+M(35,:)%j-M(36,:)%j &
    -M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(78),m3h4x8(:,65),heltab2x32(:,:,449))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(10,:)%j+M(14,:)%j+M(16,:)%j-M(17,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j-M(35,:)%j+M(36,:)%j &
    +M(39,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[18,1,8,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,7),18,G1H8(79),m3h4x8(:,66),heltab2x32(:,:,450))
  Gcoeff(:)%j = (c(9)*(M(22,:)%j-M(25,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,67),heltab2x32(:,:,451))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(80),n2h8(229))
  Gcoeff(:)%j = (c(8)*(M(22,:)%j-M(25,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[20,2,1,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,68),heltab2x32(:,:,452))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMT,G1H8(82),n2h8(230))
  Gcoeff(:)%j = (c(9)*(M(36,:)%j-M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,69),heltab2x32(:,:,453))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(83),n2h8(231))
  Gcoeff(:)%j = (c(8)*(M(36,:)%j-M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[20,2,1,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,70),heltab2x32(:,:,454))
  call Hloop_A_Q(ntryL,G0H8(37),20,nMT,G1H8(84),n2h8(232))
  Gcoeff(:)%j = (c(9)*(M(22,:)%j-M(25,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,71),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(85),n2h8(233))
  Gcoeff(:)%j = (c(8)*(M(22,:)%j-M(25,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[20,2,1,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,72),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMB,G1H8(86),n2h8(234))
  Gcoeff(:)%j = (c(9)*(M(36,:)%j-M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,73),heltab2x32(:,:,457))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(88),n2h8(235))
  Gcoeff(:)%j = (c(8)*(M(36,:)%j-M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[20,2,1,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,74),heltab2x32(:,:,458))
  call Hloop_A_Q(ntryL,G0H8(37),20,nMB,G1H8(89),n2h8(236))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(25,:)%j+M(36,:)%j &
    -M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(90),m3h4x8(:,75),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(22,:)%j-M(25,:)%j+M(36,:)%j &
    -M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(91),m3h4x8(:,76),heltab2x32(:,:,460))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(22,:)%j+M(25,:)%j-M(36,:)%j &
    +M(38,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[20,2,1,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(92),m3h4x8(:,77),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(9)*(M(23,:)%j-M(24,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,78),heltab2x32(:,:,462))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(94),n2h8(237))
  Gcoeff(:)%j = (c(8)*(M(23,:)%j-M(24,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[20,1,2,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,79),heltab2x32(:,:,463))
  call Hloop_A_Q(ntryL,G0H8(37),20,nMT,G1H8(95),n2h8(238))
  Gcoeff(:)%j = (c(9)*(M(32,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,80),heltab2x32(:,:,464))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(96),n2h8(239))
  Gcoeff(:)%j = (c(8)*(M(32,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[20,1,2,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,81),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMT,G1H8(97),n2h8(240))
  Gcoeff(:)%j = (c(9)*(M(23,:)%j-M(24,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,82),heltab2x32(:,:,466))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(98),n2h8(241))
  Gcoeff(:)%j = (c(8)*(M(23,:)%j-M(24,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[20,1,2,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,83),heltab2x32(:,:,467))
  call Hloop_A_Q(ntryL,G0H8(37),20,nMB,G1H8(100),n2h8(242))
  Gcoeff(:)%j = (c(9)*(M(32,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,84),heltab2x32(:,:,468))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(101),n2h8(243))
  Gcoeff(:)%j = (c(8)*(M(32,:)%j-M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[20,1,2,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,85),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMB,G1H8(102),n2h8(244))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(24,:)%j+M(32,:)%j &
    -M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(103),m3h4x8(:,86),heltab2x32(:,:,470))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(23,:)%j-M(24,:)%j+M(32,:)%j &
    -M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(104),m3h4x8(:,87),heltab2x32(:,:,471))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(23,:)%j+M(24,:)%j-M(32,:)%j &
    +M(42,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[20,1,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(106),m3h4x8(:,88),heltab2x32(:,:,472))
  Gcoeff(:)%j = (c(9)*(M(33,:)%j-M(34,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,89),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(107),n2h8(245))
  Gcoeff(:)%j = (c(8)*(M(33,:)%j-M(34,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[20,1,8,2],[nMT,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,90),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H8(37),20,nMT,G1H8(108),n2h8(246))
  Gcoeff(:)%j = (c(9)*(M(31,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,91),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(109),n2h8(247))
  Gcoeff(:)%j = (c(8)*(M(31,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[20,1,8,2],[nMT,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,92),heltab2x32(:,:,476))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMT,G1H8(110),n2h8(248))
  Gcoeff(:)%j = (c(9)*(M(33,:)%j-M(34,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,93),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G0H8(37),20,0,G1H8(112),n2h8(249))
  Gcoeff(:)%j = (c(8)*(M(33,:)%j-M(34,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[20,1,8,2],[nMB,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,94),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H8(37),20,nMB,G1H8(113),n2h8(250))
  Gcoeff(:)%j = (c(9)*(M(31,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,95),heltab2x32(:,:,479))
  call Hloop_Q_A(ntryL,G0H8(37),20,0,G1H8(114),n2h8(251))
  Gcoeff(:)%j = (c(8)*(M(31,:)%j-M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[20,1,8,2],[nMB,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,9),G0H8(37),m3h4x8(:,96),heltab2x32(:,:,480))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMB,G1H8(115),n2h8(252))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j+M(33,:)%j-M(34,:)%j &
    -M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,9),G1H8(116),m3h4x8(:,97),heltab2x32(:,:,481))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(M(31,:)%j+M(33,:)%j-M(34,:)%j &
    -M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(118),m3h4x8(:,98),heltab2x32(:,:,482))
  Gcoeff(:)%j = (c(5)*(-M(6,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j+M(34,:)%j &
    +M(41,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[20,1,8,2],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,9),20,G1H8(119),m3h4x8(:,99),heltab2x32(:,:,483))
  Gcoeff(:)%j = (c(9)*(M(24,:)%j-M(26,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,100),heltab2x32(:,:,484))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(120),n2h8(253))
  Gcoeff(:)%j = (c(8)*(M(24,:)%j-M(26,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,101),heltab2x32(:,:,485))
  call Hloop_Q_A(ntryL,G0H8(37),24,nMT,G1H8(121),n2h8(254))
  Gcoeff(:)%j = (c(9)*(M(30,:)%j-M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,102),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(122),n2h8(255))
  Gcoeff(:)%j = (c(8)*(M(30,:)%j-M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,103),heltab2x32(:,:,487))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMT,G1H8(124),n2h8(256))
  Gcoeff(:)%j = (c(9)*(M(24,:)%j-M(26,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,104),heltab2x32(:,:,488))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(125),n2h8(257))
  Gcoeff(:)%j = (c(8)*(M(24,:)%j-M(26,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,105),heltab2x32(:,:,489))
  call Hloop_Q_A(ntryL,G0H8(37),24,nMB,G1H8(126),n2h8(258))
  Gcoeff(:)%j = (c(9)*(M(30,:)%j-M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,106),heltab2x32(:,:,490))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(127),n2h8(259))
  Gcoeff(:)%j = (c(8)*(M(30,:)%j-M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,107),heltab2x32(:,:,491))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMB,G1H8(128),n2h8(260))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(26,:)%j+M(30,:)%j &
    -M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(130),m3h4x8(:,108),heltab2x32(:,:,492))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(24,:)%j-M(26,:)%j+M(30,:)%j &
    -M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(131),m3h4x8(:,109),heltab2x32(:,:,493))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(24,:)%j+M(26,:)%j-M(30,:)%j &
    +M(32,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[24,2,1,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(132),m3h4x8(:,110),heltab2x32(:,:,494))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(22,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,111),heltab2x32(:,:,495))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(133),n2h8(261))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(22,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,112),heltab2x32(:,:,496))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMT,G1H8(134),n2h8(262))
  Gcoeff(:)%j = (c(9)*(M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,113),heltab2x32(:,:,497))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(136),n2h8(263))
  Gcoeff(:)%j = (c(8)*(M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,114),heltab2x32(:,:,498))
  call Hloop_Q_A(ntryL,G0H8(37),24,nMT,G1H8(137),n2h8(264))
  Gcoeff(:)%j = (c(9)*(M(21,:)%j-M(22,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,115),heltab2x32(:,:,499))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(138),n2h8(265))
  Gcoeff(:)%j = (c(8)*(M(21,:)%j-M(22,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,116),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMB,G1H8(139),n2h8(266))
  Gcoeff(:)%j = (c(9)*(M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,117),heltab2x32(:,:,501))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(140),n2h8(267))
  Gcoeff(:)%j = (c(8)*(M(38,:)%j-M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,118),heltab2x32(:,:,502))
  call Hloop_Q_A(ntryL,G0H8(37),24,nMB,G1H8(142),n2h8(268))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(22,:)%j+M(38,:)%j &
    -M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(143),m3h4x8(:,119),heltab2x32(:,:,503))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(21,:)%j-M(22,:)%j+M(38,:)%j &
    -M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(144),m3h4x8(:,120),heltab2x32(:,:,504))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(21,:)%j+M(22,:)%j-M(38,:)%j &
    +M(44,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[24,1,2,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(145),m3h4x8(:,121),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(9)*(M(27,:)%j-M(28,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,122),heltab2x32(:,:,506))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(146),n2h8(269))
  Gcoeff(:)%j = (c(8)*(M(27,:)%j-M(28,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,123),heltab2x32(:,:,507))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMT,G1H8(148),n2h8(270))
  Gcoeff(:)%j = (c(9)*(M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,124),heltab2x32(:,:,508))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(149),n2h8(271))
  Gcoeff(:)%j = (c(8)*(M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,125),heltab2x32(:,:,509))
  call Hloop_Q_A(ntryL,G0H8(37),24,nMT,G1H8(150),n2h8(272))
  Gcoeff(:)%j = (c(9)*(M(27,:)%j-M(28,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,126),heltab2x32(:,:,510))
  call Hloop_A_Q(ntryL,G0H8(37),24,0,G1H8(151),n2h8(273))
  Gcoeff(:)%j = (c(8)*(M(27,:)%j-M(28,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,127),heltab2x32(:,:,511))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMB,G1H8(152),n2h8(274))
  Gcoeff(:)%j = (c(9)*(M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,128),heltab2x32(:,:,512))
  call Hloop_Q_A(ntryL,G0H8(37),24,0,G1H8(154),n2h8(275))
  Gcoeff(:)%j = (c(8)*(M(37,:)%j-M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,10),G0H8(37),m3h4x8(:,129),heltab2x32(:,:,513))
  call Hloop_Q_A(ntryL,G0H8(37),24,nMB,G1H8(155),n2h8(276))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(28,:)%j+M(37,:)%j &
    -M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf4(:,10),G1H8(156),m3h4x8(:,130),heltab2x32(:,:,514))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(19,:)%j-M(20,:)%j)+c(6)*(M(27,:)%j-M(28,:)%j+M(37,:)%j &
    -M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(157),m3h4x8(:,131),heltab2x32(:,:,515))
  Gcoeff(:)%j = (c(5)*(-M(9,:)%j+M(12,:)%j-M(16,:)%j+M(18,:)%j-M(19,:)%j+M(20,:)%j)+c(6)*(-M(27,:)%j+M(28,:)%j-M(37,:)%j &
    +M(43,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[24,1,4,2],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf4(:,10),24,G1H8(158),m3h4x8(:,132),heltab2x32(:,:,516))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(94),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(95),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(101),[G1H8(96),G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(100),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(103),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(106),[G1H8(51),G0H8(15),G0H8(14),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(56),G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(58),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(59),[G1H8(54),G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(105),G0H8(24),G0H8(23),G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G1H8(80),G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(83),G1H8(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(84),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(89),[G1H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G1H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(159),G0H8(12),G0H8(11),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(70),G1H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(72),[G1H8(67),G1H8(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G1H8(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(213),G0H8(27),G0H8(26),G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(14),G1H8(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(17),G1H8(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(267),G0H8(33),G0H8(32),G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(28),G1H8(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(30),G1H8(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(321),G0H8(36),G0H8(35),G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(41),G1H8(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(43),G1H8(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(375),G0H8(21),G0H8(20),G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(4),G1H8(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(1),G1H8(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(471)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(483),G0H8(30),G0H8(29),G0H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G0H8(3),G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G0H8(6),G0H8(5),G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(158),[G0H8(9),G0H8(8),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G0H8(18),G0H8(17),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(73),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(83),[G1H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(97),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(99),[G1H16(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(112),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(123),[G1H16(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(125),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(136),[G1H16(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(138),[G1H16(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(147),[G1H16(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(149),[G1H16(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(158),[G1H16(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(160),[G1H16(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(169),[G1H16(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(171),[G1H16(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(180),[G1H16(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(182),[G1H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(191),[G1H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(193),[G1H16(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(202),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(204),[G1H16(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(213),[G1H16(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(215),[G1H16(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(224),[G1H16(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(226),[G1H16(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(235),[G1H16(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(237),[G1H16(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(246),[G1H16(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(248),[G1H16(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(114),[G1H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(125),[G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(127),[G1H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(154),[G1H8(149)])
  call Hloop_AV_Q(ntryL,G1H8(98),ex1(:),G1H4(5),m3h2x4(:,541),heltab2x8(:,:,541))
  call Hloop_A_Q(ntryL,G1H4(5),21,0,G2H4(361),n2h4(613))
  call Hloop_AV_Q(ntryL,G1H8(95),ex1(:),G1H4(6),m3h2x4(:,542),heltab2x8(:,:,542))
  call Hloop_A_Q(ntryL,G1H4(6),21,nMT,G2H4(364),n2h4(614))
  call Hloop_QV_A(ntryL,G1H8(101),ex1(:),G1H4(21),m3h2x4(:,543),heltab2x8(:,:,543))
  call Hloop_Q_A(ntryL,G1H4(21),21,0,G2H4(365),n2h4(615))
  call Hloop_QV_A(ntryL,G1H8(97),ex1(:),G1H4(22),m3h2x4(:,544),heltab2x8(:,:,544))
  call Hloop_Q_A(ntryL,G1H4(22),21,nMT,G2H4(366),n2h4(616))
  call Hloop_AV_Q(ntryL,G1H8(100),ex1(:),G1H4(37),m3h2x4(:,545),heltab2x8(:,:,545))
  call Hloop_A_Q(ntryL,G1H4(37),21,nMB,G2H4(369),n2h4(617))
  call Hloop_QV_A(ntryL,G1H8(102),ex1(:),G1H4(38),m3h2x4(:,546),heltab2x8(:,:,546))
  call Hloop_Q_A(ntryL,G1H4(38),21,nMB,G2H4(370),n2h4(618))
  call Hloop_DV_C(ntryL,G1H8(103),20,ex1(:),G2H4(371),m3h2x4(:,547),heltab2x8(:,:,547))
  call Hloop_CV_D(ntryL,G1H8(104),20,ex1(:),1,G2H4(374),m3h2x4(:,548),heltab2x8(:,:,548))
  call Hloop_UV_W(ntryL,G1H8(106),20,ex1(:),1,G2H4(375),m3h2x4(:,549),heltab2x8(:,:,549))
  call Hloop_QV_A(ntryL,G1H8(61),ex1(:),G1H4(53),m3h2x4(:,550),heltab2x8(:,:,550))
  call Hloop_Q_A(ntryL,G1H4(53),19,0,G2H4(376),n2h4(619))
  call Hloop_QV_A(ntryL,G1H8(58),ex1(:),G1H4(54),m3h2x4(:,551),heltab2x8(:,:,551))
  call Hloop_Q_A(ntryL,G1H4(54),19,nMT,G2H4(379),n2h4(620))
  call Hloop_AV_Q(ntryL,G1H8(59),ex1(:),G1H4(69),m3h2x4(:,552),heltab2x8(:,:,552))
  call Hloop_A_Q(ntryL,G1H4(69),19,0,G2H4(380),n2h4(621))
  call Hloop_AV_Q(ntryL,G1H8(55),ex1(:),G1H4(70),m3h2x4(:,553),heltab2x8(:,:,553))
  call Hloop_A_Q(ntryL,G1H4(70),19,nMT,G2H4(381),n2h4(622))
  call Hloop_QV_A(ntryL,G1H8(62),ex1(:),G1H4(85),m3h2x4(:,554),heltab2x8(:,:,554))
  call Hloop_Q_A(ntryL,G1H4(85),19,nMB,G2H4(384),n2h4(623))
  call Hloop_AV_Q(ntryL,G1H8(60),ex1(:),G1H4(86),m3h2x4(:,555),heltab2x8(:,:,555))
  call Hloop_A_Q(ntryL,G1H4(86),19,nMB,G2H4(385),n2h4(624))
  call Hloop_CV_D(ntryL,G1H8(65),18,ex1(:),1,G2H4(386),m3h2x4(:,556),heltab2x8(:,:,556))
  call Hloop_DV_C(ntryL,G1H8(64),18,ex1(:),G2H4(389),m3h2x4(:,557),heltab2x8(:,:,557))
  call Hloop_UV_W(ntryL,G1H8(66),18,ex1(:),1,G2H4(390),m3h2x4(:,558),heltab2x8(:,:,558))
  call Hloop_QV_A(ntryL,G1H8(85),ex2(:),G1H4(101),m3h2x4(:,559),heltab2x8(:,:,559))
  call Hloop_Q_A(ntryL,G1H4(101),22,0,G2H4(391),n2h4(625))
  call Hloop_QV_A(ntryL,G1H8(82),ex2(:),G1H4(102),m3h2x4(:,560),heltab2x8(:,:,560))
  call Hloop_Q_A(ntryL,G1H4(102),22,nMT,G2H4(394),n2h4(626))
  call Hloop_AV_Q(ntryL,G1H8(88),ex2(:),G1H4(117),m3h2x4(:,561),heltab2x8(:,:,561))
  call Hloop_A_Q(ntryL,G1H4(117),22,0,G2H4(395),n2h4(627))
  call Hloop_AV_Q(ntryL,G1H8(84),ex2(:),G1H4(118),m3h2x4(:,562),heltab2x8(:,:,562))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMT,G2H4(396),n2h4(628))
  call Hloop_QV_A(ntryL,G1H8(86),ex2(:),G1H4(133),m3h2x4(:,563),heltab2x8(:,:,563))
  call Hloop_Q_A(ntryL,G1H4(133),22,nMB,G2H4(399),n2h4(629))
  call Hloop_AV_Q(ntryL,G1H8(89),ex2(:),G1H4(134),m3h2x4(:,564),heltab2x8(:,:,564))
  call Hloop_A_Q(ntryL,G1H4(134),22,nMB,G2H4(400),n2h4(630))
  call Hloop_CV_D(ntryL,G1H8(90),20,ex2(:),2,G2H4(401),m3h2x4(:,565),heltab2x8(:,:,565))
  call Hloop_DV_C(ntryL,G1H8(91),20,ex2(:),G2H4(404),m3h2x4(:,566),heltab2x8(:,:,566))
  call Hloop_UV_W(ntryL,G1H8(92),20,ex2(:),2,G2H4(405),m3h2x4(:,567),heltab2x8(:,:,567))
  call Hloop_QV_A(ntryL,G1H8(74),ex1(:),G1H4(149),m3h2x4(:,568),heltab2x8(:,:,568))
  call Hloop_Q_A(ntryL,G1H4(149),19,0,G2H4(406),n2h4(631))
  call Hloop_QV_A(ntryL,G1H8(71),ex1(:),G1H4(150),m3h2x4(:,569),heltab2x8(:,:,569))
  call Hloop_Q_A(ntryL,G1H4(150),19,nMT,G2H4(409),n2h4(632))
  call Hloop_AV_Q(ntryL,G1H8(72),ex1(:),G1H4(165),m3h2x4(:,570),heltab2x8(:,:,570))
  call Hloop_A_Q(ntryL,G1H4(165),19,0,G2H4(410),n2h4(633))
  call Hloop_AV_Q(ntryL,G1H8(68),ex1(:),G1H4(166),m3h2x4(:,571),heltab2x8(:,:,571))
  call Hloop_A_Q(ntryL,G1H4(166),19,nMT,G2H4(411),n2h4(634))
  call Hloop_QV_A(ntryL,G1H8(76),ex1(:),G1H4(181),m3h2x4(:,572),heltab2x8(:,:,572))
  call Hloop_Q_A(ntryL,G1H4(181),19,nMB,G2H4(414),n2h4(635))
  call Hloop_AV_Q(ntryL,G1H8(73),ex1(:),G1H4(182),m3h2x4(:,573),heltab2x8(:,:,573))
  call Hloop_A_Q(ntryL,G1H4(182),19,nMB,G2H4(415),n2h4(636))
  call Hloop_CV_D(ntryL,G1H8(78),18,ex1(:),1,G2H4(416),m3h2x4(:,574),heltab2x8(:,:,574))
  call Hloop_DV_C(ntryL,G1H8(77),18,ex1(:),G2H4(419),m3h2x4(:,575),heltab2x8(:,:,575))
  call Hloop_UV_W(ntryL,G1H8(79),18,ex1(:),1,G2H4(420),m3h2x4(:,576),heltab2x8(:,:,576))
  call Hloop_AV_Q(ntryL,G1H8(19),ex2(:),G1H4(197),m3h2x4(:,577),heltab2x8(:,:,577))
  call Hloop_A_Q(ntryL,G1H4(197),19,0,G2H4(421),n2h4(637))
  call Hloop_AV_Q(ntryL,G1H8(16),ex2(:),G1H4(198),m3h2x4(:,578),heltab2x8(:,:,578))
  call Hloop_A_Q(ntryL,G1H4(198),19,nMT,G2H4(424),n2h4(638))
  call Hloop_QV_A(ntryL,G1H8(22),ex2(:),G1H4(213),m3h2x4(:,579),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H4(213),19,0,G2H4(425),n2h4(639))
  call Hloop_QV_A(ntryL,G1H8(18),ex2(:),G1H4(214),m3h2x4(:,580),heltab2x8(:,:,580))
  call Hloop_Q_A(ntryL,G1H4(214),19,nMT,G2H4(426),n2h4(640))
  call Hloop_AV_Q(ntryL,G1H8(20),ex2(:),G1H4(229),m3h2x4(:,581),heltab2x8(:,:,581))
  call Hloop_A_Q(ntryL,G1H4(229),19,nMB,G2H4(429),n2h4(641))
  call Hloop_QV_A(ntryL,G1H8(23),ex2(:),G1H4(230),m3h2x4(:,582),heltab2x8(:,:,582))
  call Hloop_Q_A(ntryL,G1H4(230),19,nMB,G2H4(430),n2h4(642))
  call Hloop_DV_C(ntryL,G1H8(24),17,ex2(:),G2H4(431),m3h2x4(:,583),heltab2x8(:,:,583))
  call Hloop_CV_D(ntryL,G1H8(25),17,ex2(:),2,G2H4(434),m3h2x4(:,584),heltab2x8(:,:,584))
  call Hloop_UV_W(ntryL,G1H8(26),17,ex2(:),2,G2H4(435),m3h2x4(:,585),heltab2x8(:,:,585))
  call Hloop_AV_Q(ntryL,G1H8(32),ex2(:),G1H4(245),m3h2x4(:,586),heltab2x8(:,:,586))
  call Hloop_A_Q(ntryL,G1H4(245),19,0,G2H4(436),n2h4(643))
  call Hloop_AV_Q(ntryL,G1H8(29),ex2(:),G1H4(246),m3h2x4(:,587),heltab2x8(:,:,587))
  call Hloop_A_Q(ntryL,G1H4(246),19,nMT,G2H4(439),n2h4(644))
  call Hloop_QV_A(ntryL,G1H8(35),ex2(:),G1H4(261),m3h2x4(:,588),heltab2x8(:,:,588))
  call Hloop_Q_A(ntryL,G1H4(261),19,0,G2H4(440),n2h4(645))
  call Hloop_QV_A(ntryL,G1H8(31),ex2(:),G1H4(262),m3h2x4(:,589),heltab2x8(:,:,589))
  call Hloop_Q_A(ntryL,G1H4(262),19,nMT,G2H4(441),n2h4(646))
  call Hloop_AV_Q(ntryL,G1H8(34),ex2(:),G1H4(277),m3h2x4(:,590),heltab2x8(:,:,590))
  call Hloop_A_Q(ntryL,G1H4(277),19,nMB,G2H4(444),n2h4(647))
  call Hloop_QV_A(ntryL,G1H8(36),ex2(:),G1H4(278),m3h2x4(:,591),heltab2x8(:,:,591))
  call Hloop_Q_A(ntryL,G1H4(278),19,nMB,G2H4(445),n2h4(648))
  call Hloop_DV_C(ntryL,G1H8(37),17,ex2(:),G2H4(446),m3h2x4(:,592),heltab2x8(:,:,592))
  call Hloop_CV_D(ntryL,G1H8(38),17,ex2(:),2,G2H4(449),m3h2x4(:,593),heltab2x8(:,:,593))
  call Hloop_UV_W(ntryL,G1H8(40),17,ex2(:),2,G2H4(450),m3h2x4(:,594),heltab2x8(:,:,594))
  call Hloop_QV_A(ntryL,G1H8(46),ex3(:),G1H4(293),m3h2x4(:,595),heltab2x8(:,:,595))
  call Hloop_Q_A(ntryL,G1H4(293),22,0,G2H4(451),n2h4(649))
  call Hloop_QV_A(ntryL,G1H8(42),ex3(:),G1H4(294),m3h2x4(:,596),heltab2x8(:,:,596))
  call Hloop_Q_A(ntryL,G1H4(294),22,nMT,G2H4(454),n2h4(650))
  call Hloop_AV_Q(ntryL,G1H8(48),ex3(:),G1H4(309),m3h2x4(:,597),heltab2x8(:,:,597))
  call Hloop_A_Q(ntryL,G1H4(309),22,0,G2H4(455),n2h4(651))
  call Hloop_AV_Q(ntryL,G1H8(44),ex3(:),G1H4(310),m3h2x4(:,598),heltab2x8(:,:,598))
  call Hloop_A_Q(ntryL,G1H4(310),22,nMT,G2H4(456),n2h4(652))
  call Hloop_QV_A(ntryL,G1H8(47),ex3(:),G1H4(325),m3h2x4(:,599),heltab2x8(:,:,599))
  call Hloop_Q_A(ntryL,G1H4(325),22,nMB,G2H4(459),n2h4(653))
  call Hloop_AV_Q(ntryL,G1H8(49),ex3(:),G1H4(326),m3h2x4(:,600),heltab2x8(:,:,600))
  call Hloop_A_Q(ntryL,G1H4(326),22,nMB,G2H4(460),n2h4(654))
  call Hloop_CV_D(ntryL,G1H8(50),18,ex3(:),4,G2H4(461),m3h2x4(:,601),heltab2x8(:,:,601))
  call Hloop_DV_C(ntryL,G1H8(52),18,ex3(:),G2H4(464),m3h2x4(:,602),heltab2x8(:,:,602))
  call Hloop_UV_W(ntryL,G1H8(53),18,ex3(:),4,G2H4(465),m3h2x4(:,603),heltab2x8(:,:,603))
  call Hloop_AV_Q(ntryL,G1H8(381),ex4(:),G1H4(341),m3h2x4(:,604),heltab2x8(:,:,604))
  call Hloop_A_Q(ntryL,G1H4(341),26,0,G2H4(466),n2h4(655))
  call Hloop_AV_Q(ntryL,G1H8(387),ex4(:),G1H4(342),m3h2x4(:,605),heltab2x8(:,:,605))
  call Hloop_A_Q(ntryL,G1H4(342),26,nMT,G2H4(469),n2h4(656))
  call Hloop_QV_A(ntryL,G1H8(393),ex4(:),G1H4(357),m3h2x4(:,606),heltab2x8(:,:,606))
  call Hloop_Q_A(ntryL,G1H4(357),26,0,G2H4(470),n2h4(657))
  call Hloop_QV_A(ntryL,G1H8(399),ex4(:),G1H4(358),m3h2x4(:,607),heltab2x8(:,:,607))
  call Hloop_Q_A(ntryL,G1H4(358),26,nMT,G2H4(471),n2h4(658))
  call Hloop_AV_Q(ntryL,G1H8(405),ex4(:),G1H4(373),m3h2x4(:,608),heltab2x8(:,:,608))
  call Hloop_A_Q(ntryL,G1H4(373),26,nMB,G2H4(474),n2h4(659))
  call Hloop_QV_A(ntryL,G1H8(411),ex4(:),G1H4(374),m3h2x4(:,609),heltab2x8(:,:,609))
  call Hloop_Q_A(ntryL,G1H4(374),26,nMB,G2H4(475),n2h4(660))
  call Hloop_DV_C(ntryL,G1H8(417),18,ex4(:),G2H4(476),m3h2x4(:,610),heltab2x8(:,:,610))
  call Hloop_CV_D(ntryL,G1H8(423),18,ex4(:),8,G2H4(479),m3h2x4(:,611),heltab2x8(:,:,611))
  call Hloop_UV_W(ntryL,G1H8(429),18,ex4(:),8,G2H4(480),m3h2x4(:,612),heltab2x8(:,:,612))
  call Hloop_AV_Q(ntryL,G1H8(8),ex3(:),G1H4(389),m3h2x4(:,613),heltab2x8(:,:,613))
  call Hloop_A_Q(ntryL,G1H4(389),21,0,G2H4(481),n2h4(661))
  call Hloop_AV_Q(ntryL,G1H8(5),ex3(:),G1H4(390),m3h2x4(:,614),heltab2x8(:,:,614))
  call Hloop_A_Q(ntryL,G1H4(390),21,nMT,G2H4(484),n2h4(662))
  call Hloop_QV_A(ntryL,G1H8(6),ex3(:),G1H4(405),m3h2x4(:,615),heltab2x8(:,:,615))
  call Hloop_Q_A(ntryL,G1H4(405),21,0,G2H4(485),n2h4(663))
  call Hloop_QV_A(ntryL,G1H8(2),ex3(:),G1H4(406),m3h2x4(:,616),heltab2x8(:,:,616))
  call Hloop_Q_A(ntryL,G1H4(406),21,nMT,G2H4(486),n2h4(664))
  call Hloop_AV_Q(ntryL,G1H8(10),ex3(:),G1H4(421),m3h2x4(:,617),heltab2x8(:,:,617))
  call Hloop_A_Q(ntryL,G1H4(421),21,nMB,G2H4(489),n2h4(665))
  call Hloop_QV_A(ntryL,G1H8(7),ex3(:),G1H4(422),m3h2x4(:,618),heltab2x8(:,:,618))
  call Hloop_Q_A(ntryL,G1H4(422),21,nMB,G2H4(490),n2h4(666))
  call Hloop_DV_C(ntryL,G1H8(12),17,ex3(:),G2H4(491),m3h2x4(:,619),heltab2x8(:,:,619))
  call Hloop_CV_D(ntryL,G1H8(11),17,ex3(:),4,G2H4(494),m3h2x4(:,620),heltab2x8(:,:,620))
  call Hloop_UV_W(ntryL,G1H8(13),17,ex3(:),4,G2H4(495),m3h2x4(:,621),heltab2x8(:,:,621))
  call Hloop_AV_Q(ntryL,G1H8(489),ex3(:),G1H4(437),m3h2x4(:,622),heltab2x8(:,:,622))
  call Hloop_A_Q(ntryL,G1H4(437),21,0,G2H4(496),n2h4(667))
  call Hloop_AV_Q(ntryL,G1H8(495),ex3(:),G1H4(438),m3h2x4(:,623),heltab2x8(:,:,623))
  call Hloop_A_Q(ntryL,G1H4(438),21,nMT,G2H4(499),n2h4(668))
  call Hloop_QV_A(ntryL,G1H8(501),ex3(:),G1H4(453),m3h2x4(:,624),heltab2x8(:,:,624))
  call Hloop_Q_A(ntryL,G1H4(453),21,0,G2H4(500),n2h4(669))
  call Hloop_QV_A(ntryL,G1H8(507),ex3(:),G1H4(454),m3h2x4(:,625),heltab2x8(:,:,625))
  call Hloop_Q_A(ntryL,G1H4(454),21,nMT,G2H4(501),n2h4(670))
  call Hloop_AV_Q(ntryL,G1H8(513),ex3(:),G1H4(469),m3h2x4(:,626),heltab2x8(:,:,626))
  call Hloop_A_Q(ntryL,G1H4(469),21,nMB,G2H4(504),n2h4(671))
  call Hloop_QV_A(ntryL,G1H8(519),ex3(:),G1H4(470),m3h2x4(:,627),heltab2x8(:,:,627))
  call Hloop_Q_A(ntryL,G1H4(470),21,nMB,G2H4(505),n2h4(672))
  call Hloop_DV_C(ntryL,G1H8(525),17,ex3(:),G2H4(506),m3h2x4(:,628),heltab2x8(:,:,628))
  call Hloop_CV_D(ntryL,G1H8(531),17,ex3(:),4,G2H4(509),m3h2x4(:,629),heltab2x8(:,:,629))
  call Hloop_UV_W(ntryL,G1H8(537),17,ex3(:),4,G2H4(510),m3h2x4(:,630),heltab2x8(:,:,630))
  call Hloop_AV_Q(ntryL,G1H8(543),ex4(:),G1H4(485),m3h2x4(:,631),heltab2x8(:,:,631))
  call Hloop_A_Q(ntryL,G1H4(485),25,0,G2H4(511),n2h4(673))
  call Hloop_AV_Q(ntryL,G1H8(549),ex4(:),G1H4(486),m3h2x4(:,632),heltab2x8(:,:,632))
  call Hloop_A_Q(ntryL,G1H4(486),25,nMT,G2H4(514),n2h4(674))
  call Hloop_QV_A(ntryL,G1H8(555),ex4(:),G1H4(501),m3h2x4(:,633),heltab2x8(:,:,633))
  call Hloop_Q_A(ntryL,G1H4(501),25,0,G2H4(515),n2h4(675))
  call Hloop_QV_A(ntryL,G1H8(561),ex4(:),G1H4(502),m3h2x4(:,634),heltab2x8(:,:,634))
  call Hloop_Q_A(ntryL,G1H4(502),25,nMT,G2H4(516),n2h4(676))
  call Hloop_AV_Q(ntryL,G1H8(567),ex4(:),G1H4(517),m3h2x4(:,635),heltab2x8(:,:,635))
  call Hloop_A_Q(ntryL,G1H4(517),25,nMB,G2H4(519),n2h4(677))
  call Hloop_QV_A(ntryL,G1H8(573),ex4(:),G1H4(518),m3h2x4(:,636),heltab2x8(:,:,636))
  call Hloop_Q_A(ntryL,G1H4(518),25,nMB,G2H4(520),n2h4(678))
  call Hloop_DV_C(ntryL,G1H8(579),17,ex4(:),G2H4(521),m3h2x4(:,637),heltab2x8(:,:,637))
  call Hloop_CV_D(ntryL,G1H8(585),17,ex4(:),8,G2H4(524),m3h2x4(:,638),heltab2x8(:,:,638))
  call Hloop_UV_W(ntryL,G1H8(591),17,ex4(:),8,G2H4(525),m3h2x4(:,639),heltab2x8(:,:,639))
  call Hloop_AV_Q(ntryL,G1H8(597),ex4(:),G1H4(533),m3h2x4(:,640),heltab2x8(:,:,640))
  call Hloop_A_Q(ntryL,G1H4(533),25,0,G2H4(526),n2h4(679))
  call Hloop_AV_Q(ntryL,G1H8(603),ex4(:),G1H4(534),m3h2x4(:,641),heltab2x8(:,:,641))
  call Hloop_A_Q(ntryL,G1H4(534),25,nMT,G2H4(529),n2h4(680))
  call Hloop_QV_A(ntryL,G1H8(609),ex4(:),G1H4(549),m3h2x4(:,642),heltab2x8(:,:,642))
  call Hloop_Q_A(ntryL,G1H4(549),25,0,G2H4(530),n2h4(681))
  call Hloop_QV_A(ntryL,G1H8(615),ex4(:),G1H4(550),m3h2x4(:,643),heltab2x8(:,:,643))
  call Hloop_Q_A(ntryL,G1H4(550),25,nMT,G2H4(531),n2h4(682))
  call Hloop_AV_Q(ntryL,G1H8(621),ex4(:),G1H4(565),m3h2x4(:,644),heltab2x8(:,:,644))
  call Hloop_A_Q(ntryL,G1H4(565),25,nMB,G2H4(534),n2h4(683))
  call Hloop_QV_A(ntryL,G1H8(627),ex4(:),G1H4(566),m3h2x4(:,645),heltab2x8(:,:,645))
  call Hloop_Q_A(ntryL,G1H4(566),25,nMB,G2H4(535),n2h4(684))
  call Hloop_DV_C(ntryL,G1H8(633),17,ex4(:),G2H4(536),m3h2x4(:,646),heltab2x8(:,:,646))
  call Hloop_CV_D(ntryL,G1H8(639),17,ex4(:),8,G2H4(539),m3h2x4(:,647),heltab2x8(:,:,647))
  call Hloop_UV_W(ntryL,G1H8(645),17,ex4(:),8,G2H4(540),m3h2x4(:,648),heltab2x8(:,:,648))
  call Hloop_UV_W(ntryL,G1H8(132),24,ex2(:),2,G2H4(1),m3h2x4(:,649),heltab2x8(:,:,649))
  call Hloop_UV_W(ntryL,G1H8(145),24,ex1(:),1,G2H4(4),m3h2x4(:,650),heltab2x8(:,:,650))
  call Hloop_UV_W(ntryL,G1H8(158),24,ex1(:),1,G2H4(5),m3h2x4(:,651),heltab2x8(:,:,651))
  call Hloop_UV_W(ntryL,G1H8(119),20,ex1(:),1,G2H4(6),m3h2x4(:,652),heltab2x8(:,:,652))
  call Hloop_UV_W(ntryL,G1H16(1),16,ex1(:),1,G2H8(73),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_UV_W(ntryL,G1H16(3),16,ex1(:),1,G2H8(74),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_UV_W(ntryL,G1H16(12),16,ex1(:),1,G2H8(75),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_UV_W(ntryL,G1H16(14),16,ex2(:),2,G2H8(76),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_UV_W(ntryL,G1H16(23),16,ex2(:),2,G2H8(77),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_UV_W(ntryL,G1H16(25),16,ex2(:),2,G2H8(78),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_UV_W(ntryL,G1H16(34),16,ex1(:),1,G2H8(79),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_UV_W(ntryL,G1H16(36),16,ex1(:),1,G2H8(80),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_UV_W(ntryL,G1H16(45),16,ex1(:),1,G2H8(81),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_UV_W(ntryL,G1H16(47),16,ex1(:),1,G2H8(82),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_UV_W(ntryL,G1H16(56),16,ex1(:),1,G2H8(83),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_UV_W(ntryL,G1H16(58),16,ex1(:),1,G2H8(84),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_UV_W(ntryL,G1H16(67),16,ex3(:),4,G2H8(85),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_UV_W(ntryL,G1H16(69),16,ex3(:),4,G2H8(86),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_UV_W(ntryL,G1H16(78),16,ex3(:),4,G2H8(87),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_UV_W(ntryL,G1H16(80),16,ex1(:),1,G2H8(88),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_UV_W(ntryL,G1H16(89),16,ex1(:),1,G2H8(89),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_UV_W(ntryL,G1H16(91),16,ex1(:),1,G2H8(90),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_UV_W(ntryL,G1H16(100),16,ex1(:),1,G2H8(91),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_UV_W(ntryL,G1H16(102),16,ex1(:),1,G2H8(92),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_UV_W(ntryL,G1H16(111),16,ex1(:),1,G2H8(93),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_GGG_G_12(ntryL,G1H16(113),ex3(:),ex2(:),G1H4(581),m4h2x2x4(:,1),heltab3x16(:,:,1))
  call Hloop_GGG_G_12(ntryL,G1H16(122),ex2(:),ex3(:),G1H4(582),m4h2x2x4(:,2),heltab3x16(:,:,2))
  call Hloop_GGG_G_23(ntryL,G1H16(124),ex3(:),ex2(:),G1H4(597),m4h2x2x4(:,3),heltab3x16(:,:,3))
  call Hloop_UV_W(ntryL,G1H16(5),16,ex1(:),1,G2H8(94),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_UV_W(ntryL,G1H16(2),16,ex1(:),1,G2H8(95),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_UV_W(ntryL,G1H16(7),16,ex1(:),1,G2H8(96),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_UV_W(ntryL,G1H16(4),16,ex2(:),2,G2H8(97),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_UV_W(ntryL,G1H16(6),16,ex2(:),2,G2H8(98),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_UV_W(ntryL,G1H16(8),16,ex2(:),2,G2H8(99),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_UV_W(ntryL,G1H16(9),16,ex3(:),4,G2H8(100),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_UV_W(ntryL,G1H16(10),16,ex3(:),4,G2H8(101),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_UV_W(ntryL,G1H16(11),16,ex3(:),4,G2H8(102),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_UV_W(ntryL,G1H16(16),16,ex2(:),2,G2H8(103),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_UV_W(ntryL,G1H16(13),16,ex2(:),2,G2H8(104),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_UV_W(ntryL,G1H16(18),16,ex2(:),2,G2H8(105),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_UV_W(ntryL,G1H16(15),16,ex2(:),2,G2H8(106),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_UV_W(ntryL,G1H16(17),16,ex2(:),2,G2H8(107),m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_UV_W(ntryL,G1H16(19),16,ex2(:),2,G2H8(108),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_GGG_G_12(ntryL,G1H16(20),ex3(:),ex1(:),G1H4(598),m4h2x2x4(:,4),heltab3x16(:,:,4))
  call Hloop_GGG_G_12(ntryL,G1H16(21),ex1(:),ex3(:),G1H4(613),m4h2x2x4(:,5),heltab3x16(:,:,5))
  call Hloop_GGG_G_23(ntryL,G1H16(22),ex3(:),ex1(:),G1H4(614),m4h2x2x4(:,6),heltab3x16(:,:,6))
  call Hloop_UV_W(ntryL,G1H16(27),16,ex2(:),2,G2H8(1),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_UV_W(ntryL,G1H16(24),16,ex2(:),2,G2H8(2),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_UV_W(ntryL,G1H16(29),16,ex2(:),2,G2H8(3),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_GGG_G_12(ntryL,G1H16(26),ex2(:),ex1(:),G1H4(629),m4h2x2x4(:,7),heltab3x16(:,:,7))
  call Hloop_GGG_G_12(ntryL,G1H16(28),ex1(:),ex2(:),G1H4(630),m4h2x2x4(:,8),heltab3x16(:,:,8))
  call Hloop_GGG_G_23(ntryL,G1H16(30),ex2(:),ex1(:),G1H4(645),m4h2x2x4(:,9),heltab3x16(:,:,9))
  call Hloop_GGG_G_12(ntryL,G1H16(31),ex2(:),ex1(:),G1H4(646),m4h2x2x4(:,10),heltab3x16(:,:,10))
  call Hloop_GGG_G_12(ntryL,G1H16(32),ex1(:),ex2(:),G1H4(661),m4h2x2x4(:,11),heltab3x16(:,:,11))
  call Hloop_GGG_G_23(ntryL,G1H16(33),ex2(:),ex1(:),G1H4(662),m4h2x2x4(:,12),heltab3x16(:,:,12))
  call Hloop_UV_W(ntryL,G1H16(38),16,ex3(:),4,G2H8(4),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_UV_W(ntryL,G1H16(35),16,ex3(:),4,G2H8(5),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_UV_W(ntryL,G1H16(40),16,ex3(:),4,G2H8(6),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_QV_A(ntryL,G1H16(43),wf4(:,1),G1H4(677),m3h4x4(:,1),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(677),19,0,G2H4(9),n2h4(685))
  call Hloop_QV_A(ntryL,G1H16(39),wf4(:,1),G1H4(678),m3h4x4(:,2),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(678),19,nMT,G2H4(10),n2h4(686))
  call Hloop_AV_Q(ntryL,G1H16(49),wf4(:,1),G1H4(693),m3h4x4(:,3),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(693),19,0,G2H4(11),n2h4(687))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,1),G1H4(694),m3h4x4(:,4),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(694),19,nMT,G2H4(14),n2h4(688))
  call Hloop_QV_A(ntryL,G1H16(44),wf4(:,1),G1H4(709),m3h4x4(:,5),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(709),19,nMB,G2H4(15),n2h4(689))
  call Hloop_AV_Q(ntryL,G1H16(46),wf4(:,1),G1H4(710),m3h4x4(:,6),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(710),19,nMB,G2H4(16),n2h4(690))
  call Hloop_CV_D(ntryL,G1H16(51),16,wf4(:,1),3,G2H4(19),m3h4x4(:,7),heltab2x16(:,:,157))
  call Hloop_DV_C(ntryL,G1H16(48),16,wf4(:,1),G2H4(20),m3h4x4(:,8),heltab2x16(:,:,158))
  call Hloop_UV_W(ntryL,G1H16(50),16,wf4(:,1),3,G2H4(21),m3h4x4(:,9),heltab2x16(:,:,159))
  call Hloop_AV_Q(ntryL,G1H16(60),wf4(:,1),G1H4(725),m3h4x4(:,10),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(725),19,0,G2H4(24),n2h4(691))
  call Hloop_AV_Q(ntryL,G1H16(53),wf4(:,1),G1H4(726),m3h4x4(:,11),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(726),19,nMT,G2H4(25),n2h4(692))
  call Hloop_QV_A(ntryL,G1H16(62),wf4(:,1),G1H4(741),m3h4x4(:,12),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(741),19,0,G2H4(26),n2h4(693))
  call Hloop_QV_A(ntryL,G1H16(55),wf4(:,1),G1H4(742),m3h4x4(:,13),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(742),19,nMT,G2H4(29),n2h4(694))
  call Hloop_AV_Q(ntryL,G1H16(57),wf4(:,1),G1H4(757),m3h4x4(:,14),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(757),19,nMB,G2H4(30),n2h4(695))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,1),G1H4(758),m3h4x4(:,15),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(758),19,nMB,G2H4(31),n2h4(696))
  call Hloop_DV_C(ntryL,G1H16(61),16,wf4(:,1),G2H4(34),m3h4x4(:,16),heltab2x16(:,:,166))
  call Hloop_CV_D(ntryL,G1H16(63),16,wf4(:,1),3,G2H4(35),m3h4x4(:,17),heltab2x16(:,:,167))
  call Hloop_UV_W(ntryL,G1H16(64),16,wf4(:,1),3,G2H4(36),m3h4x4(:,18),heltab2x16(:,:,168))
  call Hloop_QV_A(ntryL,G1H16(73),ex3(:),G1H8(160),m3h2x8(:,151),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(160),20,0,G2H8(7),n2h8(277))
  call Hloop_QV_A(ntryL,G1H16(66),ex3(:),G1H8(161),m3h2x8(:,152),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H8(161),20,nMT,G2H8(8),n2h8(278))
  call Hloop_AV_Q(ntryL,G1H16(72),ex3(:),G1H8(162),m3h2x8(:,153),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G1H8(162),20,0,G2H8(9),n2h8(279))
  call Hloop_AV_Q(ntryL,G1H16(68),ex3(:),G1H8(163),m3h2x8(:,154),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(163),20,nMT,G2H8(10),n2h8(280))
  call Hloop_QV_A(ntryL,G1H16(70),ex3(:),G1H8(164),m3h2x8(:,155),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G1H8(164),20,nMB,G2H8(11),n2h8(281))
  call Hloop_AV_Q(ntryL,G1H16(74),ex3(:),G1H8(166),m3h2x8(:,156),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(166),20,nMB,G2H8(12),n2h8(282))
  call Hloop_CV_D(ntryL,G1H16(75),16,ex3(:),4,G2H8(13),m3h2x8(:,157),heltab2x16(:,:,175))
  call Hloop_DV_C(ntryL,G1H16(76),16,ex3(:),G2H8(14),m3h2x8(:,158),heltab2x16(:,:,176))
  call Hloop_UV_W(ntryL,G1H16(77),16,ex3(:),4,G2H8(15),m3h2x8(:,159),heltab2x16(:,:,177))
  call Hloop_AV_Q(ntryL,G1H16(83),ex2(:),G1H8(167),m3h2x8(:,160),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H8(167),18,0,G2H8(16),n2h8(283))
  call Hloop_AV_Q(ntryL,G1H16(79),ex2(:),G1H8(168),m3h2x8(:,161),heltab2x16(:,:,179))
  call Hloop_A_Q(ntryL,G1H8(168),18,nMT,G2H8(17),n2h8(284))
  call Hloop_QV_A(ntryL,G1H16(86),ex2(:),G1H8(169),m3h2x8(:,162),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H8(169),18,0,G2H8(18),n2h8(285))
  call Hloop_QV_A(ntryL,G1H16(81),ex2(:),G1H8(170),m3h2x8(:,163),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H8(170),18,nMT,G2H8(19),n2h8(286))
  call Hloop_AV_Q(ntryL,G1H16(85),ex2(:),G1H8(172),m3h2x8(:,164),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H8(172),18,nMB,G2H8(20),n2h8(287))
  call Hloop_QV_A(ntryL,G1H16(87),ex2(:),G1H8(173),m3h2x8(:,165),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H8(173),18,nMB,G2H8(21),n2h8(288))
  call Hloop_DV_C(ntryL,G1H16(88),16,ex2(:),G2H8(22),m3h2x8(:,166),heltab2x16(:,:,184))
  call Hloop_CV_D(ntryL,G1H16(93),16,ex2(:),2,G2H8(23),m3h2x8(:,167),heltab2x16(:,:,185))
  call Hloop_UV_W(ntryL,G1H16(90),16,ex2(:),2,G2H8(24),m3h2x8(:,168),heltab2x16(:,:,186))
  call Hloop_AV_Q(ntryL,G1H16(97),wf4(:,2),G1H4(773),m3h4x4(:,19),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(773),21,0,G2H4(39),n2h4(697))
  call Hloop_AV_Q(ntryL,G1H16(92),wf4(:,2),G1H4(774),m3h4x4(:,20),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(774),21,nMT,G2H4(40),n2h4(698))
  call Hloop_QV_A(ntryL,G1H16(99),wf4(:,2),G1H4(789),m3h4x4(:,21),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(789),21,0,G2H4(41),n2h4(699))
  call Hloop_QV_A(ntryL,G1H16(96),wf4(:,2),G1H4(790),m3h4x4(:,22),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(790),21,nMT,G2H4(44),n2h4(700))
  call Hloop_AV_Q(ntryL,G1H16(98),wf4(:,2),G1H4(805),m3h4x4(:,23),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(805),21,nMB,G2H4(45),n2h4(701))
  call Hloop_QV_A(ntryL,G1H16(104),wf4(:,2),G1H4(806),m3h4x4(:,24),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(806),21,nMB,G2H4(46),n2h4(702))
  call Hloop_DV_C(ntryL,G1H16(101),16,wf4(:,2),G2H4(49),m3h4x4(:,25),heltab2x16(:,:,193))
  call Hloop_CV_D(ntryL,G1H16(106),16,wf4(:,2),5,G2H4(50),m3h4x4(:,26),heltab2x16(:,:,194))
  call Hloop_UV_W(ntryL,G1H16(103),16,wf4(:,2),5,G2H4(51),m3h4x4(:,27),heltab2x16(:,:,195))
  call Hloop_QV_A(ntryL,G1H16(110),ex2(:),G1H8(174),m3h2x8(:,169),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(174),18,0,G2H8(25),n2h8(289))
  call Hloop_QV_A(ntryL,G1H16(107),ex2(:),G1H8(175),m3h2x8(:,170),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(175),18,nMT,G2H8(26),n2h8(290))
  call Hloop_AV_Q(ntryL,G1H16(112),ex2(:),G1H8(176),m3h2x8(:,171),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G1H8(176),18,0,G2H8(27),n2h8(291))
  call Hloop_AV_Q(ntryL,G1H16(109),ex2(:),G1H8(178),m3h2x8(:,172),heltab2x16(:,:,199))
  call Hloop_A_Q(ntryL,G1H8(178),18,nMT,G2H8(28),n2h8(292))
  call Hloop_QV_A(ntryL,G1H16(115),ex2(:),G1H8(179),m3h2x8(:,173),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(179),18,nMB,G2H8(29),n2h8(293))
  call Hloop_AV_Q(ntryL,G1H16(117),ex2(:),G1H8(180),m3h2x8(:,174),heltab2x16(:,:,201))
  call Hloop_A_Q(ntryL,G1H8(180),18,nMB,G2H8(30),n2h8(294))
  call Hloop_CV_D(ntryL,G1H16(114),16,ex2(:),2,G2H8(31),m3h2x8(:,175),heltab2x16(:,:,202))
  call Hloop_DV_C(ntryL,G1H16(116),16,ex2(:),G2H8(32),m3h2x8(:,176),heltab2x16(:,:,203))
  call Hloop_UV_W(ntryL,G1H16(118),16,ex2(:),2,G2H8(33),m3h2x8(:,177),heltab2x16(:,:,204))
  call Hloop_AV_Q(ntryL,G1H16(123),ex1(:),G1H8(181),m3h2x8(:,178),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H8(181),17,0,G2H8(34),n2h8(295))
  call Hloop_AV_Q(ntryL,G1H16(120),ex1(:),G1H8(182),m3h2x8(:,179),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H8(182),17,nMT,G2H8(35),n2h8(296))
  call Hloop_QV_A(ntryL,G1H16(125),ex1(:),G1H8(184),m3h2x8(:,180),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(184),17,0,G2H8(36),n2h8(297))
  call Hloop_QV_A(ntryL,G1H16(126),ex1(:),G1H8(185),m3h2x8(:,181),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(185),17,nMT,G2H8(37),n2h8(298))
  call Hloop_AV_Q(ntryL,G1H16(128),ex1(:),G1H8(186),m3h2x8(:,182),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H8(186),17,nMB,G2H8(38),n2h8(299))
  call Hloop_QV_A(ntryL,G1H16(127),ex1(:),G1H8(187),m3h2x8(:,183),heltab2x16(:,:,210))
  call Hloop_Q_A(ntryL,G1H8(187),17,nMB,G2H8(39),n2h8(300))
  call Hloop_DV_C(ntryL,G1H16(129),16,ex1(:),G2H8(40),m3h2x8(:,184),heltab2x16(:,:,211))
  call Hloop_CV_D(ntryL,G1H16(130),16,ex1(:),1,G2H8(41),m3h2x8(:,185),heltab2x16(:,:,212))
  call Hloop_UV_W(ntryL,G1H16(131),16,ex1(:),1,G2H8(42),m3h2x8(:,186),heltab2x16(:,:,213))
  call Hloop_AV_Q(ntryL,G1H16(136),wf4(:,5),G1H4(821),m3h4x4(:,28),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(821),22,0,G2H4(54),n2h4(703))
  call Hloop_AV_Q(ntryL,G1H16(133),wf4(:,5),G1H4(822),m3h4x4(:,29),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H4(822),22,nMT,G2H4(55),n2h4(704))
  call Hloop_QV_A(ntryL,G1H16(138),wf4(:,5),G1H4(837),m3h4x4(:,30),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(837),22,0,G2H4(56),n2h4(705))
  call Hloop_QV_A(ntryL,G1H16(135),wf4(:,5),G1H4(838),m3h4x4(:,31),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(838),22,nMT,G2H4(59),n2h4(706))
  call Hloop_AV_Q(ntryL,G1H16(137),wf4(:,5),G1H4(853),m3h4x4(:,32),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H4(853),22,nMB,G2H4(60),n2h4(707))
  call Hloop_QV_A(ntryL,G1H16(139),wf4(:,5),G1H4(854),m3h4x4(:,33),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(854),22,nMB,G2H4(61),n2h4(708))
  call Hloop_DV_C(ntryL,G1H16(140),16,wf4(:,5),G2H4(64),m3h4x4(:,34),heltab2x16(:,:,220))
  call Hloop_CV_D(ntryL,G1H16(141),16,wf4(:,5),6,G2H4(65),m3h4x4(:,35),heltab2x16(:,:,221))
  call Hloop_UV_W(ntryL,G1H16(142),16,wf4(:,5),6,G2H4(66),m3h4x4(:,36),heltab2x16(:,:,222))
  call Hloop_QV_A(ntryL,G1H16(147),ex1(:),G1H8(188),m3h2x8(:,187),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H8(188),17,0,G2H8(43),n2h8(301))
  call Hloop_QV_A(ntryL,G1H16(144),ex1(:),G1H8(190),m3h2x8(:,188),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H8(190),17,nMT,G2H8(44),n2h8(302))
  call Hloop_AV_Q(ntryL,G1H16(149),ex1(:),G1H8(191),m3h2x8(:,189),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H8(191),17,0,G2H8(45),n2h8(303))
  call Hloop_AV_Q(ntryL,G1H16(146),ex1(:),G1H8(192),m3h2x8(:,190),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H8(192),17,nMT,G2H8(46),n2h8(304))
  call Hloop_QV_A(ntryL,G1H16(148),ex1(:),G1H8(193),m3h2x8(:,191),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(193),17,nMB,G2H8(47),n2h8(305))
  call Hloop_AV_Q(ntryL,G1H16(150),ex1(:),G1H8(194),m3h2x8(:,192),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H8(194),17,nMB,G2H8(48),n2h8(306))
  call Hloop_CV_D(ntryL,G1H16(151),16,ex1(:),1,G2H8(49),m3h2x8(:,193),heltab2x16(:,:,229))
  call Hloop_DV_C(ntryL,G1H16(152),16,ex1(:),G2H8(50),m3h2x8(:,194),heltab2x16(:,:,230))
  call Hloop_UV_W(ntryL,G1H16(153),16,ex1(:),1,G2H8(51),m3h2x8(:,195),heltab2x16(:,:,231))
  call Hloop_AV_Q(ntryL,G1H16(158),ex2(:),G1H8(196),m3h2x8(:,196),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G1H8(196),18,0,G2H8(52),n2h8(307))
  call Hloop_AV_Q(ntryL,G1H16(155),ex2(:),G1H8(197),m3h2x8(:,197),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G1H8(197),18,nMT,G2H8(53),n2h8(308))
  call Hloop_QV_A(ntryL,G1H16(160),ex2(:),G1H8(198),m3h2x8(:,198),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H8(198),18,0,G2H8(54),n2h8(309))
  call Hloop_QV_A(ntryL,G1H16(157),ex2(:),G1H8(199),m3h2x8(:,199),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H8(199),18,nMT,G2H8(55),n2h8(310))
  call Hloop_AV_Q(ntryL,G1H16(159),ex2(:),G1H8(200),m3h2x8(:,200),heltab2x16(:,:,236))
  call Hloop_A_Q(ntryL,G1H8(200),18,nMB,G2H8(56),n2h8(311))
  call Hloop_QV_A(ntryL,G1H16(161),ex2(:),G1H8(202),m3h2x8(:,201),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G1H8(202),18,nMB,G2H8(57),n2h8(312))
  call Hloop_DV_C(ntryL,G1H16(162),16,ex2(:),G2H8(58),m3h2x8(:,202),heltab2x16(:,:,238))
  call Hloop_CV_D(ntryL,G1H16(163),16,ex2(:),2,G2H8(59),m3h2x8(:,203),heltab2x16(:,:,239))
  call Hloop_UV_W(ntryL,G1H16(164),16,ex2(:),2,G2H8(60),m3h2x8(:,204),heltab2x16(:,:,240))
  call Hloop_QV_A(ntryL,G1H16(169),ex3(:),G1H8(203),m3h2x8(:,205),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H8(203),20,0,G2H8(61),n2h8(313))
  call Hloop_QV_A(ntryL,G1H16(166),ex3(:),G1H8(204),m3h2x8(:,206),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G1H8(204),20,nMT,G2H8(62),n2h8(314))
  call Hloop_AV_Q(ntryL,G1H16(171),ex3(:),G1H8(205),m3h2x8(:,207),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H8(205),20,0,G2H8(63),n2h8(315))
  call Hloop_AV_Q(ntryL,G1H16(168),ex3(:),G1H8(206),m3h2x8(:,208),heltab2x16(:,:,244))
  call Hloop_A_Q(ntryL,G1H8(206),20,nMT,G2H8(64),n2h8(316))
  call Hloop_QV_A(ntryL,G1H16(170),ex3(:),G1H8(208),m3h2x8(:,209),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H8(208),20,nMB,G2H8(65),n2h8(317))
  call Hloop_AV_Q(ntryL,G1H16(172),ex3(:),G1H8(209),m3h2x8(:,210),heltab2x16(:,:,246))
  call Hloop_A_Q(ntryL,G1H8(209),20,nMB,G2H8(66),n2h8(318))
  call Hloop_CV_D(ntryL,G1H16(173),16,ex3(:),4,G2H8(67),m3h2x8(:,211),heltab2x16(:,:,247))
  call Hloop_DV_C(ntryL,G1H16(174),16,ex3(:),G2H8(68),m3h2x8(:,212),heltab2x16(:,:,248))
  call Hloop_UV_W(ntryL,G1H16(175),16,ex3(:),4,G2H8(69),m3h2x8(:,213),heltab2x16(:,:,249))
  call Hloop_QV_A(ntryL,G1H16(180),ex2(:),G1H8(210),m3h2x8(:,214),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G1H8(210),18,0,G2H8(70),n2h8(319))
  call Hloop_QV_A(ntryL,G1H16(177),ex2(:),G1H8(211),m3h2x8(:,215),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G1H8(211),18,nMT,G2H8(71),n2h8(320))
  call Hloop_AV_Q(ntryL,G1H16(182),ex2(:),G1H8(212),m3h2x8(:,216),heltab2x16(:,:,252))
  call Hloop_A_Q(ntryL,G1H8(212),18,0,G2H8(72),n2h8(321))
  call Hloop_AV_Q(ntryL,G1H16(179),ex2(:),G1H8(214),m3h2x8(:,217),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H8(214),18,nMT,G2H8(109),n2h8(322))
  call Hloop_QV_A(ntryL,G1H16(181),ex2(:),G1H8(215),m3h2x8(:,218),heltab2x16(:,:,254))
  call Hloop_Q_A(ntryL,G1H8(215),18,nMB,G2H8(110),n2h8(323))
  call Hloop_AV_Q(ntryL,G1H16(183),ex2(:),G1H8(216),m3h2x8(:,219),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H8(216),18,nMB,G2H8(111),n2h8(324))
  call Hloop_CV_D(ntryL,G1H16(184),16,ex2(:),2,G2H8(112),m3h2x8(:,220),heltab2x16(:,:,256))
  call Hloop_DV_C(ntryL,G1H16(185),16,ex2(:),G2H8(113),m3h2x8(:,221),heltab2x16(:,:,257))
  call Hloop_UV_W(ntryL,G1H16(186),16,ex2(:),2,G2H8(114),m3h2x8(:,222),heltab2x16(:,:,258))
  call Hloop_AV_Q(ntryL,G1H16(191),ex1(:),G1H8(217),m3h2x8(:,223),heltab2x16(:,:,259))
  call Hloop_A_Q(ntryL,G1H8(217),17,0,G2H8(115),n2h8(325))
  call Hloop_AV_Q(ntryL,G1H16(188),ex1(:),G1H8(218),m3h2x8(:,224),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G1H8(218),17,nMT,G2H8(116),n2h8(326))
  call Hloop_QV_A(ntryL,G1H16(193),ex1(:),G1H8(220),m3h2x8(:,225),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H8(220),17,0,G2H8(117),n2h8(327))
  call Hloop_QV_A(ntryL,G1H16(190),ex1(:),G1H8(221),m3h2x8(:,226),heltab2x16(:,:,262))
  call Hloop_Q_A(ntryL,G1H8(221),17,nMT,G2H8(118),n2h8(328))
  call Hloop_AV_Q(ntryL,G1H16(192),ex1(:),G1H8(222),m3h2x8(:,227),heltab2x16(:,:,263))
  call Hloop_A_Q(ntryL,G1H8(222),17,nMB,G2H8(119),n2h8(329))
  call Hloop_QV_A(ntryL,G1H16(194),ex1(:),G1H8(223),m3h2x8(:,228),heltab2x16(:,:,264))
  call Hloop_Q_A(ntryL,G1H8(223),17,nMB,G2H8(120),n2h8(330))
  call Hloop_DV_C(ntryL,G1H16(195),16,ex1(:),G2H8(121),m3h2x8(:,229),heltab2x16(:,:,265))
  call Hloop_CV_D(ntryL,G1H16(196),16,ex1(:),1,G2H8(122),m3h2x8(:,230),heltab2x16(:,:,266))
  call Hloop_UV_W(ntryL,G1H16(197),16,ex1(:),1,G2H8(123),m3h2x8(:,231),heltab2x16(:,:,267))
  call Hloop_QV_A(ntryL,G1H16(202),ex3(:),G1H8(224),m3h2x8(:,232),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G1H8(224),20,0,G2H8(124),n2h8(331))
  call Hloop_QV_A(ntryL,G1H16(199),ex3(:),G1H8(226),m3h2x8(:,233),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G1H8(226),20,nMT,G2H8(125),n2h8(332))
  call Hloop_AV_Q(ntryL,G1H16(204),ex3(:),G1H8(227),m3h2x8(:,234),heltab2x16(:,:,270))
  call Hloop_A_Q(ntryL,G1H8(227),20,0,G2H8(126),n2h8(333))
  call Hloop_AV_Q(ntryL,G1H16(201),ex3(:),G1H8(228),m3h2x8(:,235),heltab2x16(:,:,271))
  call Hloop_A_Q(ntryL,G1H8(228),20,nMT,G2H8(127),n2h8(334))
  call Hloop_QV_A(ntryL,G1H16(203),ex3(:),G1H8(229),m3h2x8(:,236),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G1H8(229),20,nMB,G2H8(128),n2h8(335))
  call Hloop_AV_Q(ntryL,G1H16(205),ex3(:),G1H8(230),m3h2x8(:,237),heltab2x16(:,:,273))
  call Hloop_A_Q(ntryL,G1H8(230),20,nMB,G2H8(129),n2h8(336))
  call Hloop_CV_D(ntryL,G1H16(206),16,ex3(:),4,G2H8(130),m3h2x8(:,238),heltab2x16(:,:,274))
  call Hloop_DV_C(ntryL,G1H16(207),16,ex3(:),G2H8(131),m3h2x8(:,239),heltab2x16(:,:,275))
  call Hloop_UV_W(ntryL,G1H16(208),16,ex3(:),4,G2H8(132),m3h2x8(:,240),heltab2x16(:,:,276))
  call Hloop_QV_A(ntryL,G1H16(213),ex1(:),G1H8(232),m3h2x8(:,241),heltab2x16(:,:,277))
  call Hloop_Q_A(ntryL,G1H8(232),17,0,G2H8(133),n2h8(337))
  call Hloop_QV_A(ntryL,G1H16(210),ex1(:),G1H8(233),m3h2x8(:,242),heltab2x16(:,:,278))
  call Hloop_Q_A(ntryL,G1H8(233),17,nMT,G2H8(134),n2h8(338))
  call Hloop_AV_Q(ntryL,G1H16(215),ex1(:),G1H8(234),m3h2x8(:,243),heltab2x16(:,:,279))
  call Hloop_A_Q(ntryL,G1H8(234),17,0,G2H8(135),n2h8(339))
  call Hloop_AV_Q(ntryL,G1H16(212),ex1(:),G1H8(235),m3h2x8(:,244),heltab2x16(:,:,280))
  call Hloop_A_Q(ntryL,G1H8(235),17,nMT,G2H8(136),n2h8(340))
  call Hloop_QV_A(ntryL,G1H16(214),ex1(:),G1H8(236),m3h2x8(:,245),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H8(236),17,nMB,G2H8(137),n2h8(341))
  call Hloop_AV_Q(ntryL,G1H16(216),ex1(:),G1H8(238),m3h2x8(:,246),heltab2x16(:,:,282))
  call Hloop_A_Q(ntryL,G1H8(238),17,nMB,G2H8(138),n2h8(342))
  call Hloop_CV_D(ntryL,G1H16(217),16,ex1(:),1,G2H8(139),m3h2x8(:,247),heltab2x16(:,:,283))
  call Hloop_DV_C(ntryL,G1H16(218),16,ex1(:),G2H8(140),m3h2x8(:,248),heltab2x16(:,:,284))
  call Hloop_UV_W(ntryL,G1H16(219),16,ex1(:),1,G2H8(141),m3h2x8(:,249),heltab2x16(:,:,285))
  call Hloop_AV_Q(ntryL,G1H16(224),ex1(:),G1H8(239),m3h2x8(:,250),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H8(239),17,0,G2H8(142),n2h8(343))
  call Hloop_AV_Q(ntryL,G1H16(221),ex1(:),G1H8(240),m3h2x8(:,251),heltab2x16(:,:,287))
  call Hloop_A_Q(ntryL,G1H8(240),17,nMT,G2H8(143),n2h8(344))
  call Hloop_QV_A(ntryL,G1H16(226),ex1(:),G1H8(241),m3h2x8(:,252),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H8(241),17,0,G2H8(144),n2h8(345))
  call Hloop_QV_A(ntryL,G1H16(223),ex1(:),G1H8(242),m3h2x8(:,253),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H8(242),17,nMT,G2H8(145),n2h8(346))
  call Hloop_AV_Q(ntryL,G1H16(225),ex1(:),G1H8(244),m3h2x8(:,254),heltab2x16(:,:,290))
  call Hloop_A_Q(ntryL,G1H8(244),17,nMB,G2H8(146),n2h8(347))
  call Hloop_QV_A(ntryL,G1H16(227),ex1(:),G1H8(245),m3h2x8(:,255),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G1H8(245),17,nMB,G2H8(147),n2h8(348))
  call Hloop_DV_C(ntryL,G1H16(228),16,ex1(:),G2H8(148),m3h2x8(:,256),heltab2x16(:,:,292))
  call Hloop_CV_D(ntryL,G1H16(229),16,ex1(:),1,G2H8(149),m3h2x8(:,257),heltab2x16(:,:,293))
  call Hloop_UV_W(ntryL,G1H16(230),16,ex1(:),1,G2H8(150),m3h2x8(:,258),heltab2x16(:,:,294))
  call Hloop_QV_A(ntryL,G1H16(235),ex2(:),G1H8(246),m3h2x8(:,259),heltab2x16(:,:,295))
  call Hloop_Q_A(ntryL,G1H8(246),18,0,G2H8(151),n2h8(349))
  call Hloop_QV_A(ntryL,G1H16(232),ex2(:),G1H8(247),m3h2x8(:,260),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G1H8(247),18,nMT,G2H8(152),n2h8(350))
  call Hloop_AV_Q(ntryL,G1H16(237),ex2(:),G1H8(248),m3h2x8(:,261),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G1H8(248),18,0,G2H8(153),n2h8(351))
  call Hloop_AV_Q(ntryL,G1H16(234),ex2(:),G1H8(250),m3h2x8(:,262),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H8(250),18,nMT,G2H8(154),n2h8(352))
  call Hloop_QV_A(ntryL,G1H16(236),ex2(:),G1H8(251),m3h2x8(:,263),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H8(251),18,nMB,G2H8(155),n2h8(353))
  call Hloop_AV_Q(ntryL,G1H16(238),ex2(:),G1H8(252),m3h2x8(:,264),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H8(252),18,nMB,G2H8(156),n2h8(354))
  call Hloop_CV_D(ntryL,G1H16(239),16,ex2(:),2,G2H8(157),m3h2x8(:,265),heltab2x16(:,:,301))
  call Hloop_DV_C(ntryL,G1H16(240),16,ex2(:),G2H8(158),m3h2x8(:,266),heltab2x16(:,:,302))
  call Hloop_UV_W(ntryL,G1H16(241),16,ex2(:),2,G2H8(159),m3h2x8(:,267),heltab2x16(:,:,303))
  call Hloop_QV_A(ntryL,G1H16(246),ex1(:),G1H8(253),m3h2x8(:,268),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H8(253),17,0,G2H8(160),n2h8(355))
  call Hloop_QV_A(ntryL,G1H16(243),ex1(:),G1H8(254),m3h2x8(:,269),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G1H8(254),17,nMT,G2H8(161),n2h8(356))
  call Hloop_AV_Q(ntryL,G1H16(248),ex1(:),G1H8(256),m3h2x8(:,270),heltab2x16(:,:,306))
  call Hloop_A_Q(ntryL,G1H8(256),17,0,G2H8(162),n2h8(357))
  call Hloop_AV_Q(ntryL,G1H16(245),ex1(:),G1H8(257),m3h2x8(:,271),heltab2x16(:,:,307))
  call Hloop_A_Q(ntryL,G1H8(257),17,nMT,G2H8(163),n2h8(358))
  call Hloop_QV_A(ntryL,G1H16(247),ex1(:),G1H8(258),m3h2x8(:,272),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G1H8(258),17,nMB,G2H8(164),n2h8(359))
  call Hloop_AV_Q(ntryL,G1H16(249),ex1(:),G1H8(259),m3h2x8(:,273),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G1H8(259),17,nMB,G2H8(165),n2h8(360))
  call Hloop_CV_D(ntryL,G1H16(250),16,ex1(:),1,G2H8(166),m3h2x8(:,274),heltab2x16(:,:,310))
  call Hloop_DV_C(ntryL,G1H16(251),16,ex1(:),G2H8(167),m3h2x8(:,275),heltab2x16(:,:,311))
  call Hloop_UV_W(ntryL,G1H16(252),16,ex1(:),1,G2H8(168),m3h2x8(:,276),heltab2x16(:,:,312))
  call Hloop_AV_Q(ntryL,G1H8(112),ex1(:),G1H4(869),m3h2x4(:,653),heltab2x8(:,:,653))
  call Hloop_A_Q(ntryL,G1H4(869),21,0,G2H4(69),n2h4(709))
  call Hloop_AV_Q(ntryL,G1H8(108),ex1(:),G1H4(870),m3h2x4(:,654),heltab2x8(:,:,654))
  call Hloop_A_Q(ntryL,G1H4(870),21,nMT,G2H4(70),n2h4(710))
  call Hloop_QV_A(ntryL,G1H8(114),ex1(:),G1H4(885),m3h2x4(:,655),heltab2x8(:,:,655))
  call Hloop_Q_A(ntryL,G1H4(885),21,0,G2H4(71),n2h4(711))
  call Hloop_QV_A(ntryL,G1H8(110),ex1(:),G1H4(886),m3h2x4(:,656),heltab2x8(:,:,656))
  call Hloop_Q_A(ntryL,G1H4(886),21,nMT,G2H4(74),n2h4(712))
  call Hloop_AV_Q(ntryL,G1H8(113),ex1(:),G1H4(901),m3h2x4(:,657),heltab2x8(:,:,657))
  call Hloop_A_Q(ntryL,G1H4(901),21,nMB,G2H4(75),n2h4(713))
  call Hloop_QV_A(ntryL,G1H8(115),ex1(:),G1H4(902),m3h2x4(:,658),heltab2x8(:,:,658))
  call Hloop_Q_A(ntryL,G1H4(902),21,nMB,G2H4(76),n2h4(714))
  call Hloop_DV_C(ntryL,G1H8(116),20,ex1(:),G2H4(79),m3h2x4(:,659),heltab2x8(:,:,659))
  call Hloop_CV_D(ntryL,G1H8(118),20,ex1(:),1,G2H4(80),m3h2x4(:,660),heltab2x8(:,:,660))
  call Hloop_QV_A(ntryL,G1H8(125),ex2(:),G1H4(917),m3h2x4(:,661),heltab2x8(:,:,661))
  call Hloop_Q_A(ntryL,G1H4(917),26,0,G2H4(81),n2h4(715))
  call Hloop_QV_A(ntryL,G1H8(121),ex2(:),G1H4(918),m3h2x4(:,662),heltab2x8(:,:,662))
  call Hloop_Q_A(ntryL,G1H4(918),26,nMT,G2H4(84),n2h4(716))
  call Hloop_AV_Q(ntryL,G1H8(127),ex2(:),G1H4(933),m3h2x4(:,663),heltab2x8(:,:,663))
  call Hloop_A_Q(ntryL,G1H4(933),26,0,G2H4(85),n2h4(717))
  call Hloop_AV_Q(ntryL,G1H8(124),ex2(:),G1H4(934),m3h2x4(:,664),heltab2x8(:,:,664))
  call Hloop_A_Q(ntryL,G1H4(934),26,nMT,G2H4(86),n2h4(718))
  call Hloop_QV_A(ntryL,G1H8(126),ex2(:),G1H4(949),m3h2x4(:,665),heltab2x8(:,:,665))
  call Hloop_Q_A(ntryL,G1H4(949),26,nMB,G2H4(89),n2h4(719))
  call Hloop_AV_Q(ntryL,G1H8(128),ex2(:),G1H4(950),m3h2x4(:,666),heltab2x8(:,:,666))
  call Hloop_A_Q(ntryL,G1H4(950),26,nMB,G2H4(90),n2h4(720))
  call Hloop_CV_D(ntryL,G1H8(130),24,ex2(:),2,G2H4(91),m3h2x4(:,667),heltab2x8(:,:,667))
  call Hloop_DV_C(ntryL,G1H8(131),24,ex2(:),G2H4(94),m3h2x4(:,668),heltab2x8(:,:,668))
  call Hloop_AV_Q(ntryL,G1H8(138),ex1(:),G1H4(965),m3h2x4(:,669),heltab2x8(:,:,669))
  call Hloop_A_Q(ntryL,G1H4(965),25,0,G2H4(95),n2h4(721))
  call Hloop_AV_Q(ntryL,G1H8(134),ex1(:),G1H4(966),m3h2x4(:,670),heltab2x8(:,:,670))
  call Hloop_A_Q(ntryL,G1H4(966),25,nMT,G2H4(96),n2h4(722))
  call Hloop_QV_A(ntryL,G1H8(140),ex1(:),G1H4(981),m3h2x4(:,671),heltab2x8(:,:,671))
  call Hloop_Q_A(ntryL,G1H4(981),25,0,G2H4(99),n2h4(723))
  call Hloop_QV_A(ntryL,G1H8(137),ex1(:),G1H4(982),m3h2x4(:,672),heltab2x8(:,:,672))
  call Hloop_Q_A(ntryL,G1H4(982),25,nMT,G2H4(100),n2h4(724))
  call Hloop_AV_Q(ntryL,G1H8(139),ex1(:),G1H4(997),m3h2x4(:,673),heltab2x8(:,:,673))
  call Hloop_A_Q(ntryL,G1H4(997),25,nMB,G2H4(101),n2h4(725))
  call Hloop_QV_A(ntryL,G1H8(142),ex1(:),G1H4(998),m3h2x4(:,674),heltab2x8(:,:,674))
  call Hloop_Q_A(ntryL,G1H4(998),25,nMB,G2H4(104),n2h4(726))
  call Hloop_DV_C(ntryL,G1H8(143),24,ex1(:),G2H4(105),m3h2x4(:,675),heltab2x8(:,:,675))
  call Hloop_CV_D(ntryL,G1H8(144),24,ex1(:),1,G2H4(106),m3h2x4(:,676),heltab2x8(:,:,676))
  call Hloop_AV_Q(ntryL,G1H8(151),ex1(:),G1H4(1013),m3h2x4(:,677),heltab2x8(:,:,677))
  call Hloop_A_Q(ntryL,G1H4(1013),25,0,G2H4(109),n2h4(727))
  call Hloop_AV_Q(ntryL,G1H8(148),ex1(:),G1H4(1014),m3h2x4(:,678),heltab2x8(:,:,678))
  call Hloop_A_Q(ntryL,G1H4(1014),25,nMT,G2H4(110),n2h4(728))
  call Hloop_QV_A(ntryL,G1H8(154),ex1(:),G1H4(1029),m3h2x4(:,679),heltab2x8(:,:,679))
  call Hloop_Q_A(ntryL,G1H4(1029),25,0,G2H4(111),n2h4(729))
  call Hloop_QV_A(ntryL,G1H8(150),ex1(:),G1H4(1030),m3h2x4(:,680),heltab2x8(:,:,680))
  call Hloop_Q_A(ntryL,G1H4(1030),25,nMT,G2H4(114),n2h4(730))
  call Hloop_AV_Q(ntryL,G1H8(152),ex1(:),G1H4(1045),m3h2x4(:,681),heltab2x8(:,:,681))
  call Hloop_A_Q(ntryL,G1H4(1045),25,nMB,G2H4(115),n2h4(731))
  call Hloop_QV_A(ntryL,G1H8(155),ex1(:),G1H4(1046),m3h2x4(:,682),heltab2x8(:,:,682))
  call Hloop_Q_A(ntryL,G1H4(1046),25,nMB,G2H4(116),n2h4(732))
  call Hloop_DV_C(ntryL,G1H8(156),24,ex1(:),G2H4(119),m3h2x4(:,683),heltab2x8(:,:,683))
  call Hloop_CV_D(ntryL,G1H8(157),24,ex1(:),1,G2H4(120),m3h2x4(:,684),heltab2x8(:,:,684))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(363),G2H4(3),G1H4(1156),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(368),G2H4(8),G1H4(1172),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(373),G2H4(13),G1H4(1188),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(378),G2H4(18),G1H4(1204),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G2H4(383),G2H4(23),G1H4(1220),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(388),G2H4(28),G1H4(1236),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(393),G2H4(33),G1H4(1252),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(398),G2H4(38),G1H4(1268),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(403),G2H4(43),G1H4(614),G1H4(613),G1H4(598) &
    ,G1H4(1284),G1H4(132)])
call HGT_OLR(G2H4(47),1,1,4)
call HGT_invQ_OLR(G2H4(47),2,5,4)
call HGT_OLR(G2H4(47),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(193),G2H4(48),G1H4(612),G1H4(148)])
call HGT_OLR(G2H4(52),1,1,4)
call HGT_invQ_OLR(G2H4(52),2,5,4)
call HGT_OLR(G2H4(52),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(198),G2H4(53),G1H4(628),G1H4(164)])
call HGT_OLR(G2H4(57),1,1,4)
call HGT_invQ_OLR(G2H4(57),2,5,4)
call HGT_OLR(G2H4(57),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G2H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(183),G2H4(58),G1H4(580),G1H4(180)])
call HGT_OLR(G2H4(62),1,1,4)
call HGT_invQ_OLR(G2H4(62),2,5,4)
call HGT_OLR(G2H4(62),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(188),G2H4(63),G1H4(596),G1H4(196)])
call HGT_OLR(G2H4(67),1,1,4)
call HGT_invQ_OLR(G2H4(67),2,5,4)
call HGT_OLR(G2H4(67),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(208),G2H4(68),G1H4(660),G1H4(212)])
call HGT_OLR(G2H4(72),1,1,4)
call HGT_invQ_OLR(G2H4(72),2,5,4)
call HGT_OLR(G2H4(72),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(203),G2H4(73),G1H4(644),G1H4(228)])
call HGT_OLR(G2H4(77),1,1,4)
call HGT_invQ_OLR(G2H4(77),2,5,4)
call HGT_OLR(G2H4(77),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G2H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(218),G2H4(78),G1H4(692),G1H4(244)])
call HGT_OLR(G2H4(82),1,1,4)
call HGT_invQ_OLR(G2H4(82),2,5,4)
call HGT_OLR(G2H4(82),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(213),G2H4(83),G1H4(676),G1H4(260)])
call HGT_lower_alpha_OLR(G2H4(87),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(87),2,5,4)
call HGT_lower_alpha_OLR(G2H4(87),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(223),G2H4(88),G1H4(662),G1H4(661),G1H4(646) &
    ,G1H4(708),G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(273),G2H4(93),G1H4(868),G1H4(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G2H4(278),G2H4(98),G1H4(884),G1H4(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(283),G2H4(103),G1H4(900),G1H4(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G2H4(288),G2H4(108),G1H4(916),G1H4(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G2H4(293),G2H4(113),G1H4(932),G1H4(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(298),G2H4(118),G1H4(948),G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(303),G2H4(123),G1H4(964),G1H4(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(308),G2H4(128),G1H4(980),G1H4(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G2H4(313),G2H4(133),G1H4(597),G1H4(582),G1H4(581) &
    ,G1H4(996),G1H4(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(391),[G1H4(291)])
call HGT_OLR(G2H4(137),1,1,4)
call HGT_invQ_OLR(G2H4(137),2,5,4)
call HGT_OLR(G2H4(137),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(137),[G2H4(391)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(238),G2H4(138),G1H4(756),G1H4(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(394),[G1H4(307)])
call HGT_OLR(G2H4(142),1,1,4)
call HGT_invQ_OLR(G2H4(142),2,5,4)
call HGT_OLR(G2H4(142),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(243),G2H4(143),G1H4(772),G1H4(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(395),[G1H4(323)])
call HGT_OLR(G2H4(147),1,1,4)
call HGT_invQ_OLR(G2H4(147),2,5,4)
call HGT_OLR(G2H4(147),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G2H4(395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(228),G2H4(148),G1H4(724),G1H4(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(396),[G1H4(339)])
call HGT_OLR(G2H4(152),1,1,4)
call HGT_invQ_OLR(G2H4(152),2,5,4)
call HGT_OLR(G2H4(152),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(152),[G2H4(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(233),G2H4(153),G1H4(740),G1H4(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(399),[G1H4(355)])
call HGT_OLR(G2H4(157),1,1,4)
call HGT_invQ_OLR(G2H4(157),2,5,4)
call HGT_OLR(G2H4(157),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(157),[G2H4(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(253),G2H4(158),G1H4(804),G1H4(500)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(400),[G1H4(371)])
call HGT_OLR(G2H4(162),1,1,4)
call HGT_invQ_OLR(G2H4(162),2,5,4)
call HGT_OLR(G2H4(162),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(162),[G2H4(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(248),G2H4(163),G1H4(788),G1H4(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(401),[G1H4(387)])
call HGT_OLR(G2H4(167),1,1,4)
call HGT_invQ_OLR(G2H4(167),2,5,4)
call HGT_OLR(G2H4(167),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(167),[G2H4(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(263),G2H4(168),G1H4(836),G1H4(532)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(404),[G1H4(403)])
call HGT_OLR(G2H4(172),1,1,4)
call HGT_invQ_OLR(G2H4(172),2,5,4)
call HGT_OLR(G2H4(172),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(172),[G2H4(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(258),G2H4(173),G1H4(820),G1H4(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(405),[G1H4(419)])
call HGT_lower_alpha_OLR(G2H4(177),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(177),2,5,4)
call HGT_lower_alpha_OLR(G2H4(177),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(177),[G2H4(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(268),G2H4(178),G1H4(645),G1H4(630),G1H4(629) &
    ,G1H4(852),G1H4(564)])
call HGT_OLR(G2H4(182),1,1,4)
call HGT_invQ_OLR(G2H4(182),2,5,4)
call HGT_OLR(G2H4(182),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(182),[G2H4(95)])
call HGT_OLR(G2H4(187),1,1,4)
call HGT_invQ_OLR(G2H4(187),2,5,4)
call HGT_OLR(G2H4(187),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(187),[G2H4(96)])
call HGT_OLR(G2H4(192),1,1,4)
call HGT_invQ_OLR(G2H4(192),2,5,4)
call HGT_OLR(G2H4(192),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(192),[G2H4(99)])
call HGT_OLR(G2H4(197),1,1,4)
call HGT_invQ_OLR(G2H4(197),2,5,4)
call HGT_OLR(G2H4(197),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(197),[G2H4(100)])
call HGT_OLR(G2H4(202),1,1,4)
call HGT_invQ_OLR(G2H4(202),2,5,4)
call HGT_OLR(G2H4(202),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(202),[G2H4(101)])
call HGT_OLR(G2H4(207),1,1,4)
call HGT_invQ_OLR(G2H4(207),2,5,4)
call HGT_OLR(G2H4(207),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(207),[G2H4(104)])
call HGT_OLR(G2H4(212),1,1,4)
call HGT_invQ_OLR(G2H4(212),2,5,4)
call HGT_OLR(G2H4(212),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(212),[G2H4(105)])
call HGT_OLR(G2H4(217),1,1,4)
call HGT_invQ_OLR(G2H4(217),2,5,4)
call HGT_OLR(G2H4(217),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(217),[G2H4(106)])
call HGT_lower_alpha_OLR(G2H4(222),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(222),2,5,4)
call HGT_lower_alpha_OLR(G2H4(222),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(222),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(361),[G1H4(3)])
call HGT_OLR(G2H4(227),1,1,4)
call HGT_invQ_OLR(G2H4(227),2,5,4)
call HGT_OLR(G2H4(227),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(227),[G2H4(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(364),[G1H4(19)])
call HGT_OLR(G2H4(232),1,1,4)
call HGT_invQ_OLR(G2H4(232),2,5,4)
call HGT_OLR(G2H4(232),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(232),[G2H4(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(365),[G1H4(35)])
call HGT_OLR(G2H4(237),1,1,4)
call HGT_invQ_OLR(G2H4(237),2,5,4)
call HGT_OLR(G2H4(237),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(237),[G2H4(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(366),[G1H4(51)])
call HGT_OLR(G2H4(242),1,1,4)
call HGT_invQ_OLR(G2H4(242),2,5,4)
call HGT_OLR(G2H4(242),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(242),[G2H4(366)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(369),[G1H4(67)])
call HGT_OLR(G2H4(247),1,1,4)
call HGT_invQ_OLR(G2H4(247),2,5,4)
call HGT_OLR(G2H4(247),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(247),[G2H4(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(370),[G1H4(83)])
call HGT_OLR(G2H4(252),1,1,4)
call HGT_invQ_OLR(G2H4(252),2,5,4)
call HGT_OLR(G2H4(252),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(252),[G2H4(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(371),[G1H4(99)])
call HGT_OLR(G2H4(257),1,1,4)
call HGT_invQ_OLR(G2H4(257),2,5,4)
call HGT_OLR(G2H4(257),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(257),[G2H4(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(374),[G1H4(115)])
call HGT_OLR(G2H4(262),1,1,4)
call HGT_invQ_OLR(G2H4(262),2,5,4)
call HGT_OLR(G2H4(262),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(262),[G2H4(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(375),[G1H4(131)])
call HGT_lower_alpha_OLR(G2H4(267),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(267),2,5,4)
call HGT_lower_alpha_OLR(G2H4(267),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(267),[G2H4(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(318),[G1H4(1012)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(323),[G1H4(1028)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(328),[G1H4(1044)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(333),[G1H4(1060)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(338),[G1H4(1076)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(343),[G1H4(1092)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(348),[G1H4(1108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(353),[G1H4(1124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(358),[G1H4(1140)])
call HGT_OLR(G2H4(362),1,1,4)
call HGT_invQ_OLR(G2H4(362),2,5,4)
call HGT_OLR(G2H4(362),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(362),[G2H4(109)])
call HGT_OLR(G2H4(367),1,1,4)
call HGT_invQ_OLR(G2H4(367),2,5,4)
call HGT_OLR(G2H4(367),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(367),[G2H4(110)])
call HGT_OLR(G2H4(372),1,1,4)
call HGT_invQ_OLR(G2H4(372),2,5,4)
call HGT_OLR(G2H4(372),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(372),[G2H4(111)])
call HGT_OLR(G2H4(377),1,1,4)
call HGT_invQ_OLR(G2H4(377),2,5,4)
call HGT_OLR(G2H4(377),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(377),[G2H4(114)])
call HGT_OLR(G2H4(382),1,1,4)
call HGT_invQ_OLR(G2H4(382),2,5,4)
call HGT_OLR(G2H4(382),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(382),[G2H4(115)])
call HGT_OLR(G2H4(387),1,1,4)
call HGT_invQ_OLR(G2H4(387),2,5,4)
call HGT_OLR(G2H4(387),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(387),[G2H4(116)])
call HGT_OLR(G2H4(392),1,1,4)
call HGT_invQ_OLR(G2H4(392),2,5,4)
call HGT_OLR(G2H4(392),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(392),[G2H4(119)])
call HGT_OLR(G2H4(397),1,1,4)
call HGT_invQ_OLR(G2H4(397),2,5,4)
call HGT_OLR(G2H4(397),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(397),[G2H4(120)])
call HGT_lower_alpha_OLR(G2H4(402),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(402),2,5,4)
call HGT_lower_alpha_OLR(G2H4(402),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(402),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(380),[G1H4(179)])
call HGT_OLR(G2H4(407),1,1,4)
call HGT_invQ_OLR(G2H4(407),2,5,4)
call HGT_OLR(G2H4(407),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(407),[G2H4(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(408),[G1H4(1300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(381),[G1H4(195)])
call HGT_OLR(G2H4(412),1,1,4)
call HGT_invQ_OLR(G2H4(412),2,5,4)
call HGT_OLR(G2H4(412),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(412),[G2H4(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(413),[G1H4(1316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(376),[G1H4(147)])
call HGT_OLR(G2H4(417),1,1,4)
call HGT_invQ_OLR(G2H4(417),2,5,4)
call HGT_OLR(G2H4(417),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(417),[G2H4(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(418),[G1H4(1332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(379),[G1H4(163)])
call HGT_OLR(G2H4(422),1,1,4)
call HGT_invQ_OLR(G2H4(422),2,5,4)
call HGT_OLR(G2H4(422),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(422),[G2H4(379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(423),[G1H4(1348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(385),[G1H4(227)])
call HGT_OLR(G2H4(427),1,1,4)
call HGT_invQ_OLR(G2H4(427),2,5,4)
call HGT_OLR(G2H4(427),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(427),[G2H4(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(428),[G1H4(1364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(384),[G1H4(211)])
call HGT_OLR(G2H4(432),1,1,4)
call HGT_invQ_OLR(G2H4(432),2,5,4)
call HGT_OLR(G2H4(432),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(432),[G2H4(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(433),[G1H4(1380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(389),[G1H4(259)])
call HGT_OLR(G2H4(437),1,1,4)
call HGT_invQ_OLR(G2H4(437),2,5,4)
call HGT_OLR(G2H4(437),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(437),[G2H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(438),[G1H4(1396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(386),[G1H4(243)])
call HGT_OLR(G2H4(442),1,1,4)
call HGT_invQ_OLR(G2H4(442),2,5,4)
call HGT_OLR(G2H4(442),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(442),[G2H4(386)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(443),[G1H4(1412)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(390),[G1H4(275)])
call HGT_lower_alpha_OLR(G2H4(447),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(447),2,5,4)
call HGT_lower_alpha_OLR(G2H4(447),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(447),[G2H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(448),[G1H4(1428)])
call HGT_OLR(G2H4(452),1,1,4)
call HGT_invQ_OLR(G2H4(452),2,5,4)
call HGT_OLR(G2H4(452),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(452),[G2H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(453),[G1H4(1444)])
call HGT_OLR(G2H4(457),1,1,4)
call HGT_invQ_OLR(G2H4(457),2,5,4)
call HGT_OLR(G2H4(457),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(457),[G2H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(458),[G1H4(1460)])
call HGT_OLR(G2H4(462),1,1,4)
call HGT_invQ_OLR(G2H4(462),2,5,4)
call HGT_OLR(G2H4(462),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(462),[G2H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(463),[G1H4(1476)])
call HGT_OLR(G2H4(467),1,1,4)
call HGT_invQ_OLR(G2H4(467),2,5,4)
call HGT_OLR(G2H4(467),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(467),[G2H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(468),[G1H4(1492)])
call HGT_OLR(G2H4(472),1,1,4)
call HGT_invQ_OLR(G2H4(472),2,5,4)
call HGT_OLR(G2H4(472),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(472),[G2H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(473),[G1H4(1508)])
call HGT_OLR(G2H4(477),1,1,4)
call HGT_invQ_OLR(G2H4(477),2,5,4)
call HGT_OLR(G2H4(477),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(477),[G2H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(478),[G1H4(1524)])
call HGT_OLR(G2H4(482),1,1,4)
call HGT_invQ_OLR(G2H4(482),2,5,4)
call HGT_OLR(G2H4(482),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(482),[G2H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(483),[G1H4(1540)])
call HGT_OLR(G2H4(487),1,1,4)
call HGT_invQ_OLR(G2H4(487),2,5,4)
call HGT_OLR(G2H4(487),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(487),[G2H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(488),[G1H4(1556)])
call HGT_lower_alpha_OLR(G2H4(492),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(492),2,5,4)
call HGT_lower_alpha_OLR(G2H4(492),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(492),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(493),[G1H4(1572)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(410),[G1H4(467)])
call HGT_OLR(G2H4(497),1,1,4)
call HGT_invQ_OLR(G2H4(497),2,5,4)
call HGT_OLR(G2H4(497),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(497),[G2H4(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(498),[G1H4(1588)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(411),[G1H4(483)])
call HGT_OLR(G2H4(502),1,1,4)
call HGT_invQ_OLR(G2H4(502),2,5,4)
call HGT_OLR(G2H4(502),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(502),[G2H4(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(503),[G1H4(1604)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(406),[G1H4(435)])
call HGT_OLR(G2H4(507),1,1,4)
call HGT_invQ_OLR(G2H4(507),2,5,4)
call HGT_OLR(G2H4(507),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(507),[G2H4(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(508),[G1H4(1620)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(409),[G1H4(451)])
call HGT_OLR(G2H4(512),1,1,4)
call HGT_invQ_OLR(G2H4(512),2,5,4)
call HGT_OLR(G2H4(512),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(512),[G2H4(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(513),[G1H4(1636)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(415),[G1H4(515)])
call HGT_OLR(G2H4(517),1,1,4)
call HGT_invQ_OLR(G2H4(517),2,5,4)
call HGT_OLR(G2H4(517),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(517),[G2H4(415)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(518),[G1H4(1652)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(414),[G1H4(499)])
call HGT_OLR(G2H4(522),1,1,4)
call HGT_invQ_OLR(G2H4(522),2,5,4)
call HGT_OLR(G2H4(522),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(522),[G2H4(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(523),[G1H4(1668)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(419),[G1H4(547)])
call HGT_OLR(G2H4(527),1,1,4)
call HGT_invQ_OLR(G2H4(527),2,5,4)
call HGT_OLR(G2H4(527),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(527),[G2H4(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(528),[G1H4(1684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(416),[G1H4(531)])
call HGT_OLR(G2H4(532),1,1,4)
call HGT_invQ_OLR(G2H4(532),2,5,4)
call HGT_OLR(G2H4(532),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(532),[G2H4(416)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(533),[G1H4(1700)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(420),[G1H4(563)])
call HGT_lower_alpha_OLR(G2H4(537),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(537),2,5,4)
call HGT_lower_alpha_OLR(G2H4(537),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(537),[G2H4(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(538),[G1H4(1716)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1162),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1167),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1178),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1183),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1194),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1199),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1210),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1215),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1226),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1231),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1242),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1247),[G1H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1258),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1263),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1274),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1279),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1290),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1295),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(618),[G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(623),[G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(634),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(639),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(586),[G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(591),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(602),[G1H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(607),[G1H4(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(666),[G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(671),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(650),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(655),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(698),[G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(703),[G1H4(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(682),[G1H4(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(687),[G1H4(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(714),[G1H4(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(719),[G1H4(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(874),[G1H4(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(879),[G1H4(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(890),[G1H4(314)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(895),[G1H4(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(906),[G1H4(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(911),[G1H4(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(922),[G1H4(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(927),[G1H4(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(938),[G1H4(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(943),[G1H4(367)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(954),[G1H4(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(959),[G1H4(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(970),[G1H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(975),[G1H4(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(986),[G1H4(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(991),[G1H4(415)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1002),[G1H4(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1007),[G1H4(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(762),[G1H4(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(767),[G1H4(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(778),[G1H4(458)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(783),[G1H4(463)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(730),[G1H4(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(735),[G1H4(479)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(746),[G1H4(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(751),[G1H4(495)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(810),[G1H4(506)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(815),[G1H4(511)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(794),[G1H4(522)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(799),[G1H4(527)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(842),[G1H4(538)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(847),[G1H4(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(826),[G1H4(554)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(831),[G1H4(559)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(858),[G1H4(570)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(863),[G1H4(575)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(421),[G1H4(579)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(424),[G1H4(595)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(425),[G1H4(611)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(426),[G1H4(627)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(429),[G1H4(643)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(430),[G1H4(659)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(431),[G1H4(675)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(434),[G1H4(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(435),[G1H4(707)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(436),[G1H4(723)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(439),[G1H4(739)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(440),[G1H4(755)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(441),[G1H4(771)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(444),[G1H4(787)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(445),[G1H4(803)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(446),[G1H4(819)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(449),[G1H4(835)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(450),[G1H4(851)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(451),[G1H4(867)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(454),[G1H4(883)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(455),[G1H4(899)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(456),[G1H4(915)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(459),[G1H4(931)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(460),[G1H4(947)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(461),[G1H4(963)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(464),[G1H4(979)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(465),[G1H4(995)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(466),[G1H4(1011)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(469),[G1H4(1027)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(470),[G1H4(1043)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(471),[G1H4(1059)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(474),[G1H4(1075)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(475),[G1H4(1091)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(476),[G1H4(1107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(479),[G1H4(1123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(480),[G1H4(1139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(481),[G1H4(1155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(484),[G1H4(1171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(485),[G1H4(1187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(486),[G1H4(1203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(489),[G1H4(1219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(490),[G1H4(1235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(491),[G1H4(1251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(494),[G1H4(1267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(495),[G1H4(1283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(496),[G1H4(1299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(499),[G1H4(1315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(500),[G1H4(1331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(501),[G1H4(1347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(504),[G1H4(1363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(505),[G1H4(1379)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(506),[G1H4(1395)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(509),[G1H4(1411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(510),[G1H4(1427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(511),[G1H4(1443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(514),[G1H4(1459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(515),[G1H4(1475)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(516),[G1H4(1491)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(519),[G1H4(1507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(520),[G1H4(1523)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(521),[G1H4(1539)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(524),[G1H4(1555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(525),[G1H4(1571)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(526),[G1H4(1587)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(529),[G1H4(1603)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(530),[G1H4(1619)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(531),[G1H4(1635)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(534),[G1H4(1651)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(535),[G1H4(1667)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(536),[G1H4(1683)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(539),[G1H4(1699)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(540),[G1H4(1715)])
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(47),mass4set(:,1),  & 
G1H4(1061),G1H4(1062),G1H4(1077),G1H4(1078),G1H4(1093),G0H4(1),4)
  call HG1shiftOLR(G1H4(1062),2,4)
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(16),mass4set(:,1),  & 
G1H4(1094),G1H4(1109),G1H4(1110),G1H4(1125),G1H4(1126),G0H4(2),4)
  call HG1shiftOLR(G1H4(1109),8,4)
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(47),mass4set(:,2),  & 
G1H4(1141),G1H4(1142),G1H4(1157),G1H4(1158),G1H4(1173),G0H4(3),4)
  call HG1shiftOLR(G1H4(1142),2,4)
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(16),mass4set(:,2),  & 
G1H4(1174),G1H4(1189),G1H4(1190),G1H4(1205),G1H4(1206),G0H4(4),4)
  call HG1shiftOLR(G1H4(1189),8,4)
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(47),mass4set(:,1),  & 
G1H4(1221),G1H4(1222),G1H4(1237),G1H4(1238),G1H4(1253),G0H4(5),4)
  call HG1shiftOLR(G1H4(1222),2,4)
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(16),mass4set(:,1),  & 
G1H4(1254),G1H4(1269),G1H4(1270),G1H4(1285),G1H4(1286),G0H4(6),4)
  call HG1shiftOLR(G1H4(1269),8,4)
call HGT_OLR(G2H4(17),1,1,4)
call HGT_invQ_OLR(G2H4(17),2,5,4)
call HGT_OLR(G2H4(17),6,15,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(47),mass4set(:,2),  & 
G1H4(1301),G1H4(1302),G1H4(1317),G1H4(1318),G1H4(1333),G0H4(7),4)
  call HG1shiftOLR(G1H4(1302),2,4)
  call Hotf_4pt_reduction(G2H4(44),RedSet_4(16),mass4set(:,2),  & 
G1H4(1334),G1H4(1349),G1H4(1350),G1H4(1365),G1H4(1366),G0H4(8),4)
  call HG1shiftOLR(G1H4(1349),8,4)
call HGT_OLR(G2H4(22),1,1,4)
call HGT_invQ_OLR(G2H4(22),2,5,4)
call HGT_OLR(G2H4(22),6,15,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(47),mass4set(:,3),  & 
G1H4(1381),G1H4(1382),G1H4(1397),G1H4(1398),G1H4(1413),G0H4(9),4)
  call HG1shiftOLR(G1H4(1382),2,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(16),mass4set(:,3),  & 
G1H4(1414),G1H4(1429),G1H4(1430),G1H4(1445),G1H4(1446),G0H4(10),4)
  call HG1shiftOLR(G1H4(1429),8,4)
call HGT_OLR(G2H4(27),1,1,4)
call HGT_invQ_OLR(G2H4(27),2,5,4)
call HGT_OLR(G2H4(27),6,15,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(47),mass4set(:,3),  & 
G1H4(1461),G1H4(1462),G1H4(1477),G1H4(1478),G1H4(1493),G0H4(11),4)
  call HG1shiftOLR(G1H4(1462),2,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(16),mass4set(:,3),  & 
G1H4(1494),G1H4(1509),G1H4(1510),G1H4(1525),G1H4(1526),G0H4(12),4)
  call HG1shiftOLR(G1H4(1509),8,4)
call HGT_OLR(G2H4(32),1,1,4)
call HGT_invQ_OLR(G2H4(32),2,5,4)
call HGT_OLR(G2H4(32),6,15,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(47),mass4set(:,1),  & 
G1H4(1541),G1H4(1542),G1H4(1557),G1H4(1558),G1H4(1573),G0H4(13),4)
  call HG1shiftOLR(G1H4(1542),2,4)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(16),mass4set(:,1),  & 
G1H4(1574),G1H4(1589),G1H4(1590),G1H4(1605),G1H4(1606),G0H4(14),4)
  call HG1shiftOLR(G1H4(1589),8,4)
call HGT_OLR(G2H4(37),1,1,4)
call HGT_invQ_OLR(G2H4(37),2,5,4)
call HGT_OLR(G2H4(37),6,15,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(47),mass4set(:,1),  & 
G1H4(1621),G1H4(1622),G1H4(1637),G1H4(1638),G1H4(1653),G0H4(15),4)
  call HG1shiftOLR(G1H4(1622),2,4)
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(16),mass4set(:,1),  & 
G1H4(1654),G1H4(1669),G1H4(1670),G1H4(1685),G1H4(1686),G0H4(16),4)
  call HG1shiftOLR(G1H4(1669),8,4)
call HGT_lower_alpha_OLR(G2H4(42),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(42),2,5,4)
call HGT_lower_alpha_OLR(G2H4(42),6,15,4)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(47),mass4set(:,1),  & 
G1H4(1701),G1H4(1702),G1H4(1717),G1H4(1718),G1H4(1),G0H4(17),4)
  call HG1shiftOLR(G1H4(1702),2,4)
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(16),mass4set(:,1),  & 
G1H4(2),G1H4(7),G1H4(12),G1H4(8),G1H4(11),G0H4(18),4)
  call HG1shiftOLR(G1H4(7),8,4)
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(48),mass4set(:,1),  & 
G1H4(13),G1H4(16),G1H4(17),G1H4(18),G1H4(23),G0H4(19),4)
  call HG1shiftOLR(G1H4(16),4,4)
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(19),mass4set(:,1),  & 
G1H4(28),G1H4(24),G1H4(27),G1H4(29),G1H4(32),G0H4(20),4)
  call HG1shiftOLR(G1H4(24),8,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(48),mass4set(:,2),  & 
G1H4(33),G1H4(34),G1H4(39),G1H4(44),G1H4(40),G0H4(21),4)
  call HG1shiftOLR(G1H4(34),4,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(19),mass4set(:,2),  & 
G1H4(43),G1H4(45),G1H4(48),G1H4(49),G1H4(50),G0H4(22),4)
  call HG1shiftOLR(G1H4(45),8,4)
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(48),mass4set(:,1),  & 
G1H4(55),G1H4(60),G1H4(56),G1H4(59),G1H4(61),G0H4(23),4)
  call HG1shiftOLR(G1H4(60),4,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(19),mass4set(:,1),  & 
G1H4(64),G1H4(65),G1H4(66),G1H4(71),G1H4(76),G0H4(24),4)
  call HG1shiftOLR(G1H4(65),8,4)
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(48),mass4set(:,2),  & 
G1H4(72),G1H4(75),G1H4(77),G1H4(80),G1H4(81),G0H4(25),4)
  call HG1shiftOLR(G1H4(75),4,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(19),mass4set(:,2),  & 
G1H4(82),G1H4(87),G1H4(92),G1H4(88),G1H4(91),G0H4(26),4)
  call HG1shiftOLR(G1H4(87),8,4)
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(48),mass4set(:,3),  & 
G1H4(93),G1H4(96),G1H4(97),G1H4(98),G1H4(103),G0H4(27),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(19),mass4set(:,3),  & 
G1H4(108),G1H4(104),G1H4(107),G1H4(109),G1H4(112),G0H4(28),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_4pt_reduction(G2H4(72),RedSet_4(48),mass4set(:,3),  & 
G1H4(113),G1H4(114),G1H4(119),G1H4(124),G1H4(120),G0H4(29),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(19),mass4set(:,3),  & 
G1H4(123),G1H4(125),G1H4(128),G1H4(129),G1H4(130),G0H4(30),4)
  call HG1shiftOLR(G1H4(125),8,4)
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(48),mass4set(:,1),  & 
G1H4(135),G1H4(140),G1H4(136),G1H4(139),G1H4(141),G0H4(31),4)
  call HG1shiftOLR(G1H4(140),4,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(19),mass4set(:,1),  & 
G1H4(144),G1H4(145),G1H4(146),G1H4(151),G1H4(156),G0H4(32),4)
  call HG1shiftOLR(G1H4(145),8,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(48),mass4set(:,1),  & 
G1H4(152),G1H4(155),G1H4(157),G1H4(160),G1H4(161),G0H4(33),4)
  call HG1shiftOLR(G1H4(155),4,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(19),mass4set(:,1),  & 
G1H4(162),G1H4(167),G1H4(172),G1H4(168),G1H4(171),G0H4(34),4)
  call HG1shiftOLR(G1H4(167),8,4)
  call Hotf_4pt_reduction(G2H4(87),RedSet_4(48),mass4set(:,1),  & 
G1H4(173),G1H4(176),G1H4(177),G1H4(178),G1H4(183),G0H4(35),4)
  call HG1shiftOLR(G1H4(176),4,4)
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(19),mass4set(:,1),  & 
G1H4(188),G1H4(184),G1H4(187),G1H4(189),G1H4(192),G0H4(36),4)
  call HG1shiftOLR(G1H4(184),8,4)
call HGT_OLR(G2H4(92),1,1,4)
call HGT_invQ_OLR(G2H4(92),2,5,4)
call HGT_OLR(G2H4(92),6,15,4)
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(49),mass4set(:,1),  & 
G1H4(193),G1H4(194),G1H4(199),G1H4(204),G1H4(200),G0H4(37),4)
  call HG1shiftOLR(G1H4(194),1,4)
  call Hotf_4pt_reduction(G2H4(56),RedSet_4(22),mass4set(:,1),  & 
G1H4(203),G1H4(205),G1H4(208),G1H4(209),G1H4(210),G0H4(38),4)
  call HG1shiftOLR(G1H4(205),8,4)
call HGT_OLR(G2H4(97),1,1,4)
call HGT_invQ_OLR(G2H4(97),2,5,4)
call HGT_OLR(G2H4(97),6,15,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(49),mass4set(:,2),  & 
G1H4(215),G1H4(220),G1H4(216),G1H4(219),G1H4(221),G0H4(39),4)
  call HG1shiftOLR(G1H4(220),1,4)
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(22),mass4set(:,2),  & 
G1H4(224),G1H4(225),G1H4(226),G1H4(231),G1H4(236),G0H4(40),4)
  call HG1shiftOLR(G1H4(225),8,4)
call HGT_OLR(G2H4(102),1,1,4)
call HGT_invQ_OLR(G2H4(102),2,5,4)
call HGT_OLR(G2H4(102),6,15,4)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(49),mass4set(:,1),  & 
G1H4(232),G1H4(235),G1H4(237),G1H4(240),G1H4(241),G0H4(41),4)
  call HG1shiftOLR(G1H4(235),1,4)
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(22),mass4set(:,1),  & 
G1H4(242),G1H4(247),G1H4(252),G1H4(248),G1H4(251),G0H4(42),4)
  call HG1shiftOLR(G1H4(247),8,4)
call HGT_OLR(G2H4(107),1,1,4)
call HGT_invQ_OLR(G2H4(107),2,5,4)
call HGT_OLR(G2H4(107),6,15,4)
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(49),mass4set(:,2),  & 
G1H4(253),G1H4(256),G1H4(257),G1H4(258),G1H4(263),G0H4(43),4)
  call HG1shiftOLR(G1H4(256),1,4)
  call Hotf_4pt_reduction(G2H4(55),RedSet_4(22),mass4set(:,2),  & 
G1H4(268),G1H4(264),G1H4(267),G1H4(269),G1H4(272),G0H4(44),4)
  call HG1shiftOLR(G1H4(264),8,4)
call HGT_OLR(G2H4(112),1,1,4)
call HGT_invQ_OLR(G2H4(112),2,5,4)
call HGT_OLR(G2H4(112),6,15,4)
  call Hotf_4pt_reduction(G2H4(112),RedSet_4(49),mass4set(:,3),  & 
G1H4(273),G1H4(274),G1H4(279),G1H4(284),G1H4(280),G0H4(45),4)
  call HG1shiftOLR(G1H4(274),1,4)
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(22),mass4set(:,3),  & 
G1H4(283),G1H4(285),G1H4(288),G1H4(289),G1H4(290),G0H4(46),4)
  call HG1shiftOLR(G1H4(285),8,4)
call HGT_OLR(G2H4(117),1,1,4)
call HGT_invQ_OLR(G2H4(117),2,5,4)
call HGT_OLR(G2H4(117),6,15,4)
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(49),mass4set(:,3),  & 
G1H4(295),G1H4(300),G1H4(296),G1H4(299),G1H4(301),G0H4(47),4)
  call HG1shiftOLR(G1H4(300),1,4)
  call Hotf_4pt_reduction(G2H4(60),RedSet_4(22),mass4set(:,3),  & 
G1H4(304),G1H4(305),G1H4(306),G1H4(311),G1H4(316),G0H4(48),4)
  call HG1shiftOLR(G1H4(305),8,4)
call HGT_OLR(G2H4(122),1,1,4)
call HGT_invQ_OLR(G2H4(122),2,5,4)
call HGT_OLR(G2H4(122),6,15,4)
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(49),mass4set(:,1),  & 
G1H4(312),G1H4(315),G1H4(317),G1H4(320),G1H4(321),G0H4(49),4)
  call HG1shiftOLR(G1H4(315),1,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(22),mass4set(:,1),  & 
G1H4(322),G1H4(327),G1H4(332),G1H4(328),G1H4(331),G0H4(50),4)
  call HG1shiftOLR(G1H4(327),8,4)
call HGT_OLR(G2H4(127),1,1,4)
call HGT_invQ_OLR(G2H4(127),2,5,4)
call HGT_OLR(G2H4(127),6,15,4)
  call Hotf_4pt_reduction(G2H4(127),RedSet_4(49),mass4set(:,1),  & 
G1H4(333),G1H4(336),G1H4(337),G1H4(338),G1H4(343),G0H4(51),4)
  call HG1shiftOLR(G1H4(336),1,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(22),mass4set(:,1),  & 
G1H4(348),G1H4(344),G1H4(347),G1H4(349),G1H4(352),G0H4(52),4)
  call HG1shiftOLR(G1H4(344),8,4)
call HGT_lower_alpha_OLR(G2H4(132),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(132),2,5,4)
call HGT_lower_alpha_OLR(G2H4(132),6,15,4)
  call Hotf_4pt_reduction(G2H4(132),RedSet_4(49),mass4set(:,1),  & 
G1H4(353),G1H4(354),G1H4(359),G1H4(364),G1H4(360),G0H4(53),4)
  call HG1shiftOLR(G1H4(354),1,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(22),mass4set(:,1),  & 
G1H4(363),G1H4(365),G1H4(368),G1H4(369),G1H4(370),G0H4(54),4)
  call HG1shiftOLR(G1H4(365),8,4)
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(21),mass4set(:,1),  & 
G1H4(375),G1H4(380),G1H4(376),G1H4(379),G1H4(381),G0H4(55),4)
  call HG1shiftOLR(G1H4(380),8,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(25),mass4set(:,1),  & 
G1H4(384),G1H4(385),G1H4(386),G1H4(391),G1H4(396),G0H4(56),4)
  call HG1shiftOLR(G1H4(385),4,4)
  call Hotf_4pt_reduction(G2H4(142),RedSet_4(21),mass4set(:,2),  & 
G1H4(392),G1H4(395),G1H4(397),G1H4(400),G1H4(401),G0H4(57),4)
  call HG1shiftOLR(G1H4(395),8,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(25),mass4set(:,2),  & 
G1H4(402),G1H4(407),G1H4(412),G1H4(408),G1H4(411),G0H4(58),4)
  call HG1shiftOLR(G1H4(407),4,4)
  call Hotf_4pt_reduction(G2H4(147),RedSet_4(21),mass4set(:,1),  & 
G1H4(413),G1H4(416),G1H4(417),G1H4(418),G1H4(423),G0H4(59),4)
  call HG1shiftOLR(G1H4(416),8,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(25),mass4set(:,1),  & 
G1H4(428),G1H4(424),G1H4(427),G1H4(429),G1H4(432),G0H4(60),4)
  call HG1shiftOLR(G1H4(424),4,4)
  call Hotf_4pt_reduction(G2H4(152),RedSet_4(21),mass4set(:,2),  & 
G1H4(433),G1H4(434),G1H4(439),G1H4(444),G1H4(440),G0H4(61),4)
  call HG1shiftOLR(G1H4(434),8,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(25),mass4set(:,2),  & 
G1H4(443),G1H4(445),G1H4(448),G1H4(449),G1H4(450),G0H4(62),4)
  call HG1shiftOLR(G1H4(445),4,4)
  call Hotf_4pt_reduction(G2H4(157),RedSet_4(21),mass4set(:,3),  & 
G1H4(455),G1H4(460),G1H4(456),G1H4(459),G1H4(461),G0H4(63),4)
  call HG1shiftOLR(G1H4(460),8,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(25),mass4set(:,3),  & 
G1H4(464),G1H4(465),G1H4(466),G1H4(471),G1H4(476),G0H4(64),4)
  call HG1shiftOLR(G1H4(465),4,4)
  call Hotf_4pt_reduction(G2H4(162),RedSet_4(21),mass4set(:,3),  & 
G1H4(472),G1H4(475),G1H4(477),G1H4(480),G1H4(481),G0H4(65),4)
  call HG1shiftOLR(G1H4(475),8,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(25),mass4set(:,3),  & 
G1H4(482),G1H4(487),G1H4(492),G1H4(488),G1H4(491),G0H4(66),4)
  call HG1shiftOLR(G1H4(487),4,4)
  call Hotf_4pt_reduction(G2H4(167),RedSet_4(21),mass4set(:,1),  & 
G1H4(493),G1H4(496),G1H4(497),G1H4(498),G1H4(503),G0H4(67),4)
  call HG1shiftOLR(G1H4(496),8,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(25),mass4set(:,1),  & 
G1H4(508),G1H4(504),G1H4(507),G1H4(509),G1H4(512),G0H4(68),4)
  call HG1shiftOLR(G1H4(504),4,4)
  call Hotf_4pt_reduction(G2H4(172),RedSet_4(21),mass4set(:,1),  & 
G1H4(513),G1H4(514),G1H4(519),G1H4(524),G1H4(520),G0H4(69),4)
  call HG1shiftOLR(G1H4(514),8,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(25),mass4set(:,1),  & 
G1H4(523),G1H4(525),G1H4(528),G1H4(529),G1H4(530),G0H4(70),4)
  call HG1shiftOLR(G1H4(525),4,4)
  call Hotf_4pt_reduction(G2H4(177),RedSet_4(21),mass4set(:,1),  & 
G1H4(535),G1H4(540),G1H4(536),G1H4(539),G1H4(541),G0H4(71),4)
  call HG1shiftOLR(G1H4(540),8,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(25),mass4set(:,1),  & 
G1H4(544),G1H4(545),G1H4(546),G1H4(551),G1H4(556),G0H4(72),4)
  call HG1shiftOLR(G1H4(545),4,4)
  call Hotf_4pt_reduction(G2H4(182),RedSet_4(50),mass4set(:,1),  & 
G1H4(552),G1H4(555),G1H4(557),G1H4(560),G1H4(561),G0H4(73),4)
  call HG1shiftOLR(G1H4(555),4,4)
  call Hotf_4pt_reduction(G2H4(187),RedSet_4(50),mass4set(:,2),  & 
G1H4(562),G1H4(567),G1H4(572),G1H4(568),G1H4(571),G0H4(74),4)
  call HG1shiftOLR(G1H4(567),4,4)
  call Hotf_4pt_reduction(G2H4(192),RedSet_4(50),mass4set(:,1),  & 
G1H4(573),G1H4(576),G1H4(577),G1H4(578),G1H4(583),G0H4(75),4)
  call HG1shiftOLR(G1H4(576),4,4)
  call Hotf_4pt_reduction(G2H4(197),RedSet_4(50),mass4set(:,2),  & 
G1H4(588),G1H4(584),G1H4(587),G1H4(589),G1H4(592),G0H4(76),4)
  call HG1shiftOLR(G1H4(584),4,4)
  call Hotf_4pt_reduction(G2H4(202),RedSet_4(50),mass4set(:,3),  & 
G1H4(593),G1H4(594),G1H4(599),G1H4(604),G1H4(600),G0H4(77),4)
  call HG1shiftOLR(G1H4(594),4,4)
  call Hotf_4pt_reduction(G2H4(207),RedSet_4(50),mass4set(:,3),  & 
G1H4(603),G1H4(605),G1H4(608),G1H4(609),G1H4(610),G0H4(78),4)
  call HG1shiftOLR(G1H4(605),4,4)
  call Hotf_4pt_reduction(G2H4(212),RedSet_4(50),mass4set(:,1),  & 
G1H4(615),G1H4(620),G1H4(616),G1H4(619),G1H4(621),G0H4(79),4)
  call HG1shiftOLR(G1H4(620),4,4)
  call Hotf_4pt_reduction(G2H4(217),RedSet_4(50),mass4set(:,1),  & 
G1H4(624),G1H4(625),G1H4(626),G1H4(631),G1H4(636),G0H4(80),4)
  call HG1shiftOLR(G1H4(625),4,4)
  call Hotf_4pt_reduction(G2H4(222),RedSet_4(50),mass4set(:,1),  & 
G1H4(632),G1H4(635),G1H4(637),G1H4(640),G1H4(641),G0H4(81),4)
  call HG1shiftOLR(G1H4(635),4,4)
  call Hotf_4pt_reduction(G2H4(227),RedSet_4(15),mass4set(:,1),  & 
G1H4(642),G1H4(647),G1H4(652),G1H4(648),G1H4(651),G0H4(82),4)
  call HG1shiftOLR(G1H4(647),8,4)
  call Hotf_4pt_reduction(G2H4(232),RedSet_4(15),mass4set(:,2),  & 
G1H4(653),G1H4(656),G1H4(657),G1H4(658),G1H4(663),G0H4(83),4)
  call HG1shiftOLR(G1H4(656),8,4)
  call Hotf_4pt_reduction(G2H4(237),RedSet_4(15),mass4set(:,1),  & 
G1H4(668),G1H4(664),G1H4(667),G1H4(669),G1H4(672),G0H4(84),4)
  call HG1shiftOLR(G1H4(664),8,4)
  call Hotf_4pt_reduction(G2H4(242),RedSet_4(15),mass4set(:,2),  & 
G1H4(673),G1H4(674),G1H4(679),G1H4(684),G1H4(680),G0H4(85),4)
  call HG1shiftOLR(G1H4(674),8,4)
  call Hotf_4pt_reduction(G2H4(247),RedSet_4(15),mass4set(:,3),  & 
G1H4(683),G1H4(685),G1H4(688),G1H4(689),G1H4(690),G0H4(86),4)
  call HG1shiftOLR(G1H4(685),8,4)
  call Hotf_4pt_reduction(G2H4(252),RedSet_4(15),mass4set(:,3),  & 
G1H4(695),G1H4(700),G1H4(696),G1H4(699),G1H4(701),G0H4(87),4)
  call HG1shiftOLR(G1H4(700),8,4)
  call Hotf_4pt_reduction(G2H4(257),RedSet_4(15),mass4set(:,1),  & 
G1H4(704),G1H4(705),G1H4(706),G1H4(711),G1H4(716),G0H4(88),4)
  call HG1shiftOLR(G1H4(705),8,4)
  call Hotf_4pt_reduction(G2H4(262),RedSet_4(15),mass4set(:,1),  & 
G1H4(712),G1H4(715),G1H4(717),G1H4(720),G1H4(721),G0H4(89),4)
  call HG1shiftOLR(G1H4(715),8,4)
  call Hotf_4pt_reduction(G2H4(267),RedSet_4(15),mass4set(:,1),  & 
G1H4(722),G1H4(727),G1H4(732),G1H4(728),G1H4(731),G0H4(90),4)
  call HG1shiftOLR(G1H4(727),8,4)
call HGT_OLR(G2H4(272),1,1,4)
call HGT_invQ_OLR(G2H4(272),2,5,4)
call HGT_OLR(G2H4(272),6,15,4)
  call Hotf_4pt_reduction(G2H4(272),RedSet_4(51),mass4set(:,1),  & 
G1H4(733),G1H4(736),G1H4(737),G1H4(738),G1H4(743),G0H4(91),4)
  call HG1shiftOLR(G1H4(736),1,4)
call HGT_OLR(G2H4(277),1,1,4)
call HGT_invQ_OLR(G2H4(277),2,5,4)
call HGT_OLR(G2H4(277),6,15,4)
  call Hotf_4pt_reduction(G2H4(277),RedSet_4(51),mass4set(:,2),  & 
G1H4(748),G1H4(744),G1H4(747),G1H4(749),G1H4(752),G0H4(92),4)
  call HG1shiftOLR(G1H4(744),1,4)
call HGT_OLR(G2H4(282),1,1,4)
call HGT_invQ_OLR(G2H4(282),2,5,4)
call HGT_OLR(G2H4(282),6,15,4)
  call Hotf_4pt_reduction(G2H4(282),RedSet_4(51),mass4set(:,1),  & 
G1H4(753),G1H4(754),G1H4(759),G1H4(764),G1H4(760),G0H4(93),4)
  call HG1shiftOLR(G1H4(754),1,4)
call HGT_OLR(G2H4(287),1,1,4)
call HGT_invQ_OLR(G2H4(287),2,5,4)
call HGT_OLR(G2H4(287),6,15,4)
  call Hotf_4pt_reduction(G2H4(287),RedSet_4(51),mass4set(:,2),  & 
G1H4(763),G1H4(765),G1H4(768),G1H4(769),G1H4(770),G0H4(94),4)
  call HG1shiftOLR(G1H4(765),1,4)
call HGT_OLR(G2H4(292),1,1,4)
call HGT_invQ_OLR(G2H4(292),2,5,4)
call HGT_OLR(G2H4(292),6,15,4)
  call Hotf_4pt_reduction(G2H4(292),RedSet_4(51),mass4set(:,3),  & 
G1H4(775),G1H4(780),G1H4(776),G1H4(779),G1H4(781),G0H4(95),4)
  call HG1shiftOLR(G1H4(780),1,4)
call HGT_OLR(G2H4(297),1,1,4)
call HGT_invQ_OLR(G2H4(297),2,5,4)
call HGT_OLR(G2H4(297),6,15,4)
  call Hotf_4pt_reduction(G2H4(297),RedSet_4(51),mass4set(:,3),  & 
G1H4(784),G1H4(785),G1H4(786),G1H4(791),G1H4(796),G0H4(96),4)
  call HG1shiftOLR(G1H4(785),1,4)
call HGT_OLR(G2H4(302),1,1,4)
call HGT_invQ_OLR(G2H4(302),2,5,4)
call HGT_OLR(G2H4(302),6,15,4)
  call Hotf_4pt_reduction(G2H4(302),RedSet_4(51),mass4set(:,1),  & 
G1H4(792),G1H4(795),G1H4(797),G1H4(800),G1H4(801),G0H4(97),4)
  call HG1shiftOLR(G1H4(795),1,4)
call HGT_OLR(G2H4(307),1,1,4)
call HGT_invQ_OLR(G2H4(307),2,5,4)
call HGT_OLR(G2H4(307),6,15,4)
  call Hotf_4pt_reduction(G2H4(307),RedSet_4(51),mass4set(:,1),  & 
G1H4(802),G1H4(807),G1H4(812),G1H4(808),G1H4(811),G0H4(98),4)
  call HG1shiftOLR(G1H4(807),1,4)
call HGT_lower_alpha_OLR(G2H4(312),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(312),2,5,4)
call HGT_lower_alpha_OLR(G2H4(312),6,15,4)
  call Hotf_4pt_reduction(G2H4(312),RedSet_4(51),mass4set(:,1),  & 
G1H4(813),G1H4(816),G1H4(817),G1H4(818),G1H4(823),G0H4(99),4)
  call HG1shiftOLR(G1H4(816),1,4)
call HGT_OLR(G2H4(317),1,1,4)
call HGT_invQ_OLR(G2H4(317),2,5,4)
call HGT_OLR(G2H4(317),6,15,4)
  call Hotf_4pt_reduction(G2H4(317),RedSet_4(52),mass4set(:,1),  & 
G1H4(828),G1H4(824),G1H4(827),G1H4(829),G1H4(832),G0H4(100),4)
  call HG1shiftOLR(G1H4(824),1,4)
  call Hotf_4pt_reduction(G2H4(318),RedSet_4(34),mass4set(:,1),  & 
G1H4(833),G1H4(834),G1H4(839),G1H4(844),G1H4(840),G0H4(101),4)
  call HG1shiftOLR(G1H4(834),4,4)
call HGT_OLR(G2H4(322),1,1,4)
call HGT_invQ_OLR(G2H4(322),2,5,4)
call HGT_OLR(G2H4(322),6,15,4)
  call Hotf_4pt_reduction(G2H4(322),RedSet_4(52),mass4set(:,2),  & 
G1H4(843),G1H4(845),G1H4(848),G1H4(849),G1H4(850),G0H4(102),4)
  call HG1shiftOLR(G1H4(845),1,4)
  call Hotf_4pt_reduction(G2H4(323),RedSet_4(34),mass4set(:,2),  & 
G1H4(855),G1H4(860),G1H4(856),G1H4(859),G1H4(861),G0H4(103),4)
  call HG1shiftOLR(G1H4(860),4,4)
call HGT_OLR(G2H4(327),1,1,4)
call HGT_invQ_OLR(G2H4(327),2,5,4)
call HGT_OLR(G2H4(327),6,15,4)
  call Hotf_4pt_reduction(G2H4(327),RedSet_4(52),mass4set(:,1),  & 
G1H4(864),G1H4(865),G1H4(866),G1H4(871),G1H4(876),G0H4(104),4)
  call HG1shiftOLR(G1H4(865),1,4)
  call Hotf_4pt_reduction(G2H4(328),RedSet_4(34),mass4set(:,1),  & 
G1H4(872),G1H4(875),G1H4(877),G1H4(880),G1H4(881),G0H4(105),4)
  call HG1shiftOLR(G1H4(875),4,4)
call HGT_OLR(G2H4(332),1,1,4)
call HGT_invQ_OLR(G2H4(332),2,5,4)
call HGT_OLR(G2H4(332),6,15,4)
  call Hotf_4pt_reduction(G2H4(332),RedSet_4(52),mass4set(:,2),  & 
G1H4(882),G1H4(887),G1H4(892),G1H4(888),G1H4(891),G0H4(106),4)
  call HG1shiftOLR(G1H4(887),1,4)
  call Hotf_4pt_reduction(G2H4(333),RedSet_4(34),mass4set(:,2),  & 
G1H4(893),G1H4(896),G1H4(897),G1H4(898),G1H4(903),G0H4(107),4)
  call HG1shiftOLR(G1H4(896),4,4)
call HGT_OLR(G2H4(337),1,1,4)
call HGT_invQ_OLR(G2H4(337),2,5,4)
call HGT_OLR(G2H4(337),6,15,4)
  call Hotf_4pt_reduction(G2H4(337),RedSet_4(52),mass4set(:,3),  & 
G1H4(908),G1H4(904),G1H4(907),G1H4(909),G1H4(912),G0H4(108),4)
  call HG1shiftOLR(G1H4(904),1,4)
  call Hotf_4pt_reduction(G2H4(338),RedSet_4(34),mass4set(:,3),  & 
G1H4(913),G1H4(914),G1H4(919),G1H4(924),G1H4(920),G0H4(109),4)
  call HG1shiftOLR(G1H4(914),4,4)
call HGT_OLR(G2H4(342),1,1,4)
call HGT_invQ_OLR(G2H4(342),2,5,4)
call HGT_OLR(G2H4(342),6,15,4)
  call Hotf_4pt_reduction(G2H4(342),RedSet_4(52),mass4set(:,3),  & 
G1H4(923),G1H4(925),G1H4(928),G1H4(929),G1H4(930),G0H4(110),4)
  call HG1shiftOLR(G1H4(925),1,4)
  call Hotf_4pt_reduction(G2H4(343),RedSet_4(34),mass4set(:,3),  & 
G1H4(935),G1H4(940),G1H4(936),G1H4(939),G1H4(941),G0H4(111),4)
  call HG1shiftOLR(G1H4(940),4,4)
call HGT_OLR(G2H4(347),1,1,4)
call HGT_invQ_OLR(G2H4(347),2,5,4)
call HGT_OLR(G2H4(347),6,15,4)
  call Hotf_4pt_reduction(G2H4(347),RedSet_4(52),mass4set(:,1),  & 
G1H4(944),G1H4(945),G1H4(946),G1H4(951),G1H4(956),G0H4(112),4)
  call HG1shiftOLR(G1H4(945),1,4)
  call Hotf_4pt_reduction(G2H4(348),RedSet_4(34),mass4set(:,1),  & 
G1H4(952),G1H4(955),G1H4(957),G1H4(960),G1H4(961),G0H4(113),4)
  call HG1shiftOLR(G1H4(955),4,4)
call HGT_OLR(G2H4(352),1,1,4)
call HGT_invQ_OLR(G2H4(352),2,5,4)
call HGT_OLR(G2H4(352),6,15,4)
  call Hotf_4pt_reduction(G2H4(352),RedSet_4(52),mass4set(:,1),  & 
G1H4(962),G1H4(967),G1H4(972),G1H4(968),G1H4(971),G0H4(114),4)
  call HG1shiftOLR(G1H4(967),1,4)
  call Hotf_4pt_reduction(G2H4(353),RedSet_4(34),mass4set(:,1),  & 
G1H4(973),G1H4(976),G1H4(977),G1H4(978),G1H4(983),G0H4(115),4)
  call HG1shiftOLR(G1H4(976),4,4)
call HGT_lower_alpha_OLR(G2H4(357),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(357),2,5,4)
call HGT_lower_alpha_OLR(G2H4(357),6,15,4)
  call Hotf_4pt_reduction(G2H4(357),RedSet_4(52),mass4set(:,1),  & 
G1H4(988),G1H4(984),G1H4(987),G1H4(989),G1H4(992),G0H4(116),4)
  call HG1shiftOLR(G1H4(984),1,4)
  call Hotf_4pt_reduction(G2H4(358),RedSet_4(34),mass4set(:,1),  & 
G1H4(993),G1H4(994),G1H4(999),G1H4(1004),G1H4(1000),G0H4(117),4)
  call HG1shiftOLR(G1H4(994),4,4)
  call Hotf_4pt_reduction(G2H4(362),RedSet_4(53),mass4set(:,1),  & 
G1H4(1003),G1H4(1005),G1H4(1008),G1H4(1009),G1H4(1010),G0H4(118),4)
  call HG1shiftOLR(G1H4(1005),2,4)
  call Hotf_4pt_reduction(G2H4(367),RedSet_4(53),mass4set(:,2),  & 
G1H4(1015),G1H4(1020),G1H4(1016),G1H4(1019),G1H4(1021),G0H4(119),4)
  call HG1shiftOLR(G1H4(1020),2,4)
  call Hotf_4pt_reduction(G2H4(372),RedSet_4(53),mass4set(:,1),  & 
G1H4(1024),G1H4(1025),G1H4(1026),G1H4(1031),G1H4(1036),G0H4(120),4)
  call HG1shiftOLR(G1H4(1025),2,4)
  call Hotf_4pt_reduction(G2H4(377),RedSet_4(53),mass4set(:,2),  & 
G1H4(1032),G1H4(1035),G1H4(1037),G1H4(1040),G1H4(1041),G0H4(121),4)
  call HG1shiftOLR(G1H4(1035),2,4)
  call Hotf_4pt_reduction(G2H4(382),RedSet_4(53),mass4set(:,3),  & 
G1H4(1042),G1H4(1047),G1H4(1052),G1H4(1048),G1H4(1051),G0H4(122),4)
  call HG1shiftOLR(G1H4(1047),2,4)
  call Hotf_4pt_reduction(G2H4(387),RedSet_4(53),mass4set(:,3),  & 
G1H4(1053),G1H4(1056),G1H4(1057),G1H4(1058),G1H4(1063),G0H4(123),4)
  call HG1shiftOLR(G1H4(1056),2,4)
  call Hotf_4pt_reduction(G2H4(392),RedSet_4(53),mass4set(:,1),  & 
G1H4(1068),G1H4(1064),G1H4(1067),G1H4(1069),G1H4(1072),G0H4(124),4)
  call HG1shiftOLR(G1H4(1064),2,4)
  call Hotf_4pt_reduction(G2H4(397),RedSet_4(53),mass4set(:,1),  & 
G1H4(1073),G1H4(1074),G1H4(1079),G1H4(1084),G1H4(1080),G0H4(125),4)
  call HG1shiftOLR(G1H4(1074),2,4)
  call Hotf_4pt_reduction(G2H4(402),RedSet_4(53),mass4set(:,1),  & 
G1H4(1083),G1H4(1085),G1H4(1088),G1H4(1089),G1H4(1090),G0H4(126),4)
  call HG1shiftOLR(G1H4(1085),2,4)
  call Hotf_4pt_reduction(G2H4(407),RedSet_4(18),mass4set(:,1),  & 
G1H4(1095),G1H4(1100),G1H4(1096),G1H4(1099),G1H4(1101),G0H4(127),4)
  call HG1shiftOLR(G1H4(1100),8,4)
  call Hotf_4pt_reduction(G2H4(408),RedSet_4(39),mass4set(:,1),  & 
G1H4(1104),G1H4(1105),G1H4(1106),G1H4(1111),G1H4(1116),G0H4(128),4)
  call HG1shiftOLR(G1H4(1105),2,4)
  call Hotf_4pt_reduction(G2H4(412),RedSet_4(18),mass4set(:,2),  & 
G1H4(1112),G1H4(1115),G1H4(1117),G1H4(1120),G1H4(1121),G0H4(129),4)
  call HG1shiftOLR(G1H4(1115),8,4)
  call Hotf_4pt_reduction(G2H4(413),RedSet_4(39),mass4set(:,2),  & 
G1H4(1122),G1H4(1127),G1H4(1132),G1H4(1128),G1H4(1131),G0H4(130),4)
  call HG1shiftOLR(G1H4(1127),2,4)
  call Hotf_4pt_reduction(G2H4(417),RedSet_4(18),mass4set(:,1),  & 
G1H4(1133),G1H4(1136),G1H4(1137),G1H4(1138),G1H4(1143),G0H4(131),4)
  call HG1shiftOLR(G1H4(1136),8,4)
  call Hotf_4pt_reduction(G2H4(418),RedSet_4(39),mass4set(:,1),  & 
G1H4(1148),G1H4(1144),G1H4(1147),G1H4(1149),G1H4(1152),G0H4(132),4)
  call HG1shiftOLR(G1H4(1144),2,4)
  call Hotf_4pt_reduction(G2H4(422),RedSet_4(18),mass4set(:,2),  & 
G1H4(1153),G1H4(1154),G1H4(1159),G1H4(1164),G1H4(1160),G0H4(133),4)
  call HG1shiftOLR(G1H4(1154),8,4)
  call Hotf_4pt_reduction(G2H4(423),RedSet_4(39),mass4set(:,2),  & 
G1H4(1163),G1H4(1165),G1H4(1168),G1H4(1169),G1H4(1170),G0H4(134),4)
  call HG1shiftOLR(G1H4(1165),2,4)
  call Hotf_4pt_reduction(G2H4(427),RedSet_4(18),mass4set(:,3),  & 
G1H4(1175),G1H4(1180),G1H4(1176),G1H4(1179),G1H4(1181),G0H4(135),4)
  call HG1shiftOLR(G1H4(1180),8,4)
  call Hotf_4pt_reduction(G2H4(428),RedSet_4(39),mass4set(:,3),  & 
G1H4(1184),G1H4(1185),G1H4(1186),G1H4(1191),G1H4(1196),G0H4(136),4)
  call HG1shiftOLR(G1H4(1185),2,4)
  call Hotf_4pt_reduction(G2H4(432),RedSet_4(18),mass4set(:,3),  & 
G1H4(1192),G1H4(1195),G1H4(1197),G1H4(1200),G1H4(1201),G0H4(137),4)
  call HG1shiftOLR(G1H4(1195),8,4)
  call Hotf_4pt_reduction(G2H4(433),RedSet_4(39),mass4set(:,3),  & 
G1H4(1202),G1H4(1207),G1H4(1212),G1H4(1208),G1H4(1211),G0H4(138),4)
  call HG1shiftOLR(G1H4(1207),2,4)
  call Hotf_4pt_reduction(G2H4(437),RedSet_4(18),mass4set(:,1),  & 
G1H4(1213),G1H4(1216),G1H4(1217),G1H4(1218),G1H4(1223),G0H4(139),4)
  call HG1shiftOLR(G1H4(1216),8,4)
  call Hotf_4pt_reduction(G2H4(438),RedSet_4(39),mass4set(:,1),  & 
G1H4(1228),G1H4(1224),G1H4(1227),G1H4(1229),G1H4(1232),G0H4(140),4)
  call HG1shiftOLR(G1H4(1224),2,4)
  call Hotf_4pt_reduction(G2H4(442),RedSet_4(18),mass4set(:,1),  & 
G1H4(1233),G1H4(1234),G1H4(1239),G1H4(1244),G1H4(1240),G0H4(141),4)
  call HG1shiftOLR(G1H4(1234),8,4)
  call Hotf_4pt_reduction(G2H4(443),RedSet_4(39),mass4set(:,1),  & 
G1H4(1243),G1H4(1245),G1H4(1248),G1H4(1249),G1H4(1250),G0H4(142),4)
  call HG1shiftOLR(G1H4(1245),2,4)
  call Hotf_4pt_reduction(G2H4(447),RedSet_4(18),mass4set(:,1),  & 
G1H4(1255),G1H4(1260),G1H4(1256),G1H4(1259),G1H4(1261),G0H4(143),4)
  call HG1shiftOLR(G1H4(1260),8,4)
  call Hotf_4pt_reduction(G2H4(448),RedSet_4(39),mass4set(:,1),  & 
G1H4(1264),G1H4(1265),G1H4(1266),G1H4(1271),G1H4(1276),G0H4(144),4)
  call HG1shiftOLR(G1H4(1265),2,4)
  call Hotf_4pt_reduction(G2H4(452),RedSet_4(54),mass4set(:,1),  & 
G1H4(1272),G1H4(1275),G1H4(1277),G1H4(1280),G1H4(1281),G0H4(145),4)
  call HG1shiftOLR(G1H4(1275),2,4)
  call Hotf_4pt_reduction(G2H4(453),RedSet_4(42),mass4set(:,1),  & 
G1H4(1282),G1H4(1287),G1H4(1292),G1H4(1288),G1H4(1291),G0H4(146),4)
  call HG1shiftOLR(G1H4(1287),4,4)
  call Hotf_4pt_reduction(G2H4(457),RedSet_4(54),mass4set(:,2),  & 
G1H4(1293),G1H4(1296),G1H4(1297),G1H4(1298),G1H4(1303),G0H4(147),4)
  call HG1shiftOLR(G1H4(1296),2,4)
  call Hotf_4pt_reduction(G2H4(458),RedSet_4(42),mass4set(:,2),  & 
G1H4(1308),G1H4(1304),G1H4(1307),G1H4(1309),G1H4(1312),G0H4(148),4)
  call HG1shiftOLR(G1H4(1304),4,4)
  call Hotf_4pt_reduction(G2H4(462),RedSet_4(54),mass4set(:,1),  & 
G1H4(1313),G1H4(1314),G1H4(1319),G1H4(1324),G1H4(1320),G0H4(149),4)
  call HG1shiftOLR(G1H4(1314),2,4)
  call Hotf_4pt_reduction(G2H4(463),RedSet_4(42),mass4set(:,1),  & 
G1H4(1323),G1H4(1325),G1H4(1328),G1H4(1329),G1H4(1330),G0H4(150),4)
  call HG1shiftOLR(G1H4(1325),4,4)
  call Hotf_4pt_reduction(G2H4(467),RedSet_4(54),mass4set(:,2),  & 
G1H4(1335),G1H4(1340),G1H4(1336),G1H4(1339),G1H4(1341),G0H4(151),4)
  call HG1shiftOLR(G1H4(1340),2,4)
  call Hotf_4pt_reduction(G2H4(468),RedSet_4(42),mass4set(:,2),  & 
G1H4(1344),G1H4(1345),G1H4(1346),G1H4(1351),G1H4(1356),G0H4(152),4)
  call HG1shiftOLR(G1H4(1345),4,4)
  call Hotf_4pt_reduction(G2H4(472),RedSet_4(54),mass4set(:,3),  & 
G1H4(1352),G1H4(1355),G1H4(1357),G1H4(1360),G1H4(1361),G0H4(153),4)
  call HG1shiftOLR(G1H4(1355),2,4)
  call Hotf_4pt_reduction(G2H4(473),RedSet_4(42),mass4set(:,3),  & 
G1H4(1362),G1H4(1367),G1H4(1372),G1H4(1368),G1H4(1371),G0H4(154),4)
  call HG1shiftOLR(G1H4(1367),4,4)
  call Hotf_4pt_reduction(G2H4(477),RedSet_4(54),mass4set(:,3),  & 
G1H4(1373),G1H4(1376),G1H4(1377),G1H4(1378),G1H4(1383),G0H4(155),4)
  call HG1shiftOLR(G1H4(1376),2,4)
  call Hotf_4pt_reduction(G2H4(478),RedSet_4(42),mass4set(:,3),  & 
G1H4(1388),G1H4(1384),G1H4(1387),G1H4(1389),G1H4(1392),G0H4(156),4)
  call HG1shiftOLR(G1H4(1384),4,4)
  call Hotf_4pt_reduction(G2H4(482),RedSet_4(54),mass4set(:,1),  & 
G1H4(1393),G1H4(1394),G1H4(1399),G1H4(1404),G1H4(1400),G0H4(157),4)
  call HG1shiftOLR(G1H4(1394),2,4)
  call Hotf_4pt_reduction(G2H4(483),RedSet_4(42),mass4set(:,1),  & 
G1H4(1403),G1H4(1405),G1H4(1408),G1H4(1409),G1H4(1410),G0H4(158),4)
  call HG1shiftOLR(G1H4(1405),4,4)
  call Hotf_4pt_reduction(G2H4(487),RedSet_4(54),mass4set(:,1),  & 
G1H4(1415),G1H4(1420),G1H4(1416),G1H4(1419),G1H4(1421),G0H4(159),4)
  call HG1shiftOLR(G1H4(1420),2,4)
  call Hotf_4pt_reduction(G2H4(488),RedSet_4(42),mass4set(:,1),  & 
G1H4(1424),G1H4(1425),G1H4(1426),G1H4(1431),G1H4(1436),G0H4(160),4)
  call HG1shiftOLR(G1H4(1425),4,4)
  call Hotf_4pt_reduction(G2H4(492),RedSet_4(54),mass4set(:,1),  & 
G1H4(1432),G1H4(1435),G1H4(1437),G1H4(1440),G1H4(1441),G0H4(161),4)
  call HG1shiftOLR(G1H4(1435),2,4)
  call Hotf_4pt_reduction(G2H4(493),RedSet_4(42),mass4set(:,1),  & 
G1H4(1442),G1H4(1447),G1H4(1452),G1H4(1448),G1H4(1451),G0H4(162),4)
  call HG1shiftOLR(G1H4(1447),4,4)
  call Hotf_4pt_reduction(G2H4(497),RedSet_4(24),mass4set(:,1),  & 
G1H4(1453),G1H4(1456),G1H4(1457),G1H4(1458),G1H4(1463),G0H4(163),4)
  call HG1shiftOLR(G1H4(1456),4,4)
  call Hotf_4pt_reduction(G2H4(498),RedSet_4(45),mass4set(:,1),  & 
G1H4(1468),G1H4(1464),G1H4(1467),G1H4(1469),G1H4(1472),G0H4(164),4)
  call HG1shiftOLR(G1H4(1464),2,4)
  call Hotf_4pt_reduction(G2H4(502),RedSet_4(24),mass4set(:,2),  & 
G1H4(1473),G1H4(1474),G1H4(1479),G1H4(1484),G1H4(1480),G0H4(165),4)
  call HG1shiftOLR(G1H4(1474),4,4)
  call Hotf_4pt_reduction(G2H4(503),RedSet_4(45),mass4set(:,2),  & 
G1H4(1483),G1H4(1485),G1H4(1488),G1H4(1489),G1H4(1490),G0H4(166),4)
  call HG1shiftOLR(G1H4(1485),2,4)
  call Hotf_4pt_reduction(G2H4(507),RedSet_4(24),mass4set(:,1),  & 
G1H4(1495),G1H4(1500),G1H4(1496),G1H4(1499),G1H4(1501),G0H4(167),4)
  call HG1shiftOLR(G1H4(1500),4,4)
  call Hotf_4pt_reduction(G2H4(508),RedSet_4(45),mass4set(:,1),  & 
G1H4(1504),G1H4(1505),G1H4(1506),G1H4(1511),G1H4(1516),G0H4(168),4)
  call HG1shiftOLR(G1H4(1505),2,4)
  call Hotf_4pt_reduction(G2H4(512),RedSet_4(24),mass4set(:,2),  & 
G1H4(1512),G1H4(1515),G1H4(1517),G1H4(1520),G1H4(1521),G0H4(169),4)
  call HG1shiftOLR(G1H4(1515),4,4)
  call Hotf_4pt_reduction(G2H4(513),RedSet_4(45),mass4set(:,2),  & 
G1H4(1522),G1H4(1527),G1H4(1532),G1H4(1528),G1H4(1531),G0H4(170),4)
  call HG1shiftOLR(G1H4(1527),2,4)
  call Hotf_4pt_reduction(G2H4(517),RedSet_4(24),mass4set(:,3),  & 
G1H4(1533),G1H4(1536),G1H4(1537),G1H4(1538),G1H4(1543),G0H4(171),4)
  call HG1shiftOLR(G1H4(1536),4,4)
  call Hotf_4pt_reduction(G2H4(518),RedSet_4(45),mass4set(:,3),  & 
G1H4(1548),G1H4(1544),G1H4(1547),G1H4(1549),G1H4(1552),G0H4(172),4)
  call HG1shiftOLR(G1H4(1544),2,4)
  call Hotf_4pt_reduction(G2H4(522),RedSet_4(24),mass4set(:,3),  & 
G1H4(1553),G1H4(1554),G1H4(1559),G1H4(1564),G1H4(1560),G0H4(173),4)
  call HG1shiftOLR(G1H4(1554),4,4)
  call Hotf_4pt_reduction(G2H4(523),RedSet_4(45),mass4set(:,3),  & 
G1H4(1563),G1H4(1565),G1H4(1568),G1H4(1569),G1H4(1570),G0H4(174),4)
  call HG1shiftOLR(G1H4(1565),2,4)
  call Hotf_4pt_reduction(G2H4(527),RedSet_4(24),mass4set(:,1),  & 
G1H4(1575),G1H4(1580),G1H4(1576),G1H4(1579),G1H4(1581),G0H4(175),4)
  call HG1shiftOLR(G1H4(1580),4,4)
  call Hotf_4pt_reduction(G2H4(528),RedSet_4(45),mass4set(:,1),  & 
G1H4(1584),G1H4(1585),G1H4(1586),G1H4(1591),G1H4(1596),G0H4(176),4)
  call HG1shiftOLR(G1H4(1585),2,4)
  call Hotf_4pt_reduction(G2H4(532),RedSet_4(24),mass4set(:,1),  & 
G1H4(1592),G1H4(1595),G1H4(1597),G1H4(1600),G1H4(1601),G0H4(177),4)
  call HG1shiftOLR(G1H4(1595),4,4)
  call Hotf_4pt_reduction(G2H4(533),RedSet_4(45),mass4set(:,1),  & 
G1H4(1602),G1H4(1607),G1H4(1612),G1H4(1608),G1H4(1611),G0H4(178),4)
  call HG1shiftOLR(G1H4(1607),2,4)
  call Hotf_4pt_reduction(G2H4(537),RedSet_4(24),mass4set(:,1),  & 
G1H4(1613),G1H4(1616),G1H4(1617),G1H4(1618),G1H4(1623),G0H4(179),4)
  call HG1shiftOLR(G1H4(1616),4,4)
  call Hotf_4pt_reduction(G2H4(538),RedSet_4(45),mass4set(:,1),  & 
G1H4(1628),G1H4(1624),G1H4(1627),G1H4(1629),G1H4(1632),G0H4(180),4)
  call HG1shiftOLR(G1H4(1624),2,4)
  call Hloop_AV_Q(ntryL,G1H4(9),ex2(:),G1H2(216),m3h2x2(:,1081),heltab2x4(:,:,1081))
  call Hloop_A_Q(ntryL,G1H2(216),23,0,G2H2(1),n2h2(505))
  call Hloop_AV_Q(ntryL,G1H4(1162),ex2(:),G1H2(222),m3h2x2(:,1082),heltab2x4(:,:,1082))
  call Hloop_A_Q(ntryL,G1H2(222),23,0,G2H2(4),n2h2(506))
  call Hloop_AV_Q(ntryL,G1H4(14),ex2(:),G1H2(232),m3h2x2(:,1083),heltab2x4(:,:,1083))
  call Hloop_A_Q(ntryL,G1H2(232),23,0,G2H2(9),n2h2(507))
  call Hloop_AV_Q(ntryL,G1H4(1167),ex2(:),G1H2(242),m3h2x2(:,1084),heltab2x4(:,:,1084))
  call Hloop_A_Q(ntryL,G1H2(242),23,0,G2H2(12),n2h2(508))
  call Hloop_AV_Q(ntryL,G1H4(25),ex2(:),G1H2(252),m3h2x2(:,1085),heltab2x4(:,:,1085))
  call Hloop_A_Q(ntryL,G1H2(252),23,nMT,G2H2(17),n2h2(509))
  call Hloop_AV_Q(ntryL,G1H4(1178),ex2(:),G1H2(262),m3h2x2(:,1086),heltab2x4(:,:,1086))
  call Hloop_A_Q(ntryL,G1H2(262),23,nMT,G2H2(20),n2h2(510))
  call Hloop_AV_Q(ntryL,G1H4(30),ex2(:),G1H2(272),m3h2x2(:,1087),heltab2x4(:,:,1087))
  call Hloop_A_Q(ntryL,G1H2(272),23,nMT,G2H2(25),n2h2(511))
  call Hloop_AV_Q(ntryL,G1H4(1183),ex2(:),G1H2(282),m3h2x2(:,1088),heltab2x4(:,:,1088))
  call Hloop_A_Q(ntryL,G1H2(282),23,nMT,G2H2(28),n2h2(512))
  call Hloop_QV_A(ntryL,G1H4(41),ex2(:),G1H2(292),m3h2x2(:,1089),heltab2x4(:,:,1089))
  call Hloop_Q_A(ntryL,G1H2(292),23,0,G2H2(33),n2h2(513))
  call Hloop_QV_A(ntryL,G1H4(1194),ex2(:),G1H2(302),m3h2x2(:,1090),heltab2x4(:,:,1090))
  call Hloop_Q_A(ntryL,G1H2(302),23,0,G2H2(36),n2h2(514))
  call Hloop_QV_A(ntryL,G1H4(46),ex2(:),G1H2(312),m3h2x2(:,1091),heltab2x4(:,:,1091))
  call Hloop_Q_A(ntryL,G1H2(312),23,0,G2H2(41),n2h2(515))
  call Hloop_QV_A(ntryL,G1H4(1199),ex2(:),G1H2(322),m3h2x2(:,1092),heltab2x4(:,:,1092))
  call Hloop_Q_A(ntryL,G1H2(322),23,0,G2H2(44),n2h2(516))
  call Hloop_QV_A(ntryL,G1H4(57),ex2(:),G1H2(332),m3h2x2(:,1093),heltab2x4(:,:,1093))
  call Hloop_Q_A(ntryL,G1H2(332),23,nMT,G2H2(49),n2h2(517))
  call Hloop_QV_A(ntryL,G1H4(1210),ex2(:),G1H2(342),m3h2x2(:,1094),heltab2x4(:,:,1094))
  call Hloop_Q_A(ntryL,G1H2(342),23,nMT,G2H2(52),n2h2(518))
  call Hloop_QV_A(ntryL,G1H4(62),ex2(:),G1H2(352),m3h2x2(:,1095),heltab2x4(:,:,1095))
  call Hloop_Q_A(ntryL,G1H2(352),23,nMT,G2H2(57),n2h2(519))
  call Hloop_QV_A(ntryL,G1H4(1215),ex2(:),G1H2(362),m3h2x2(:,1096),heltab2x4(:,:,1096))
  call Hloop_Q_A(ntryL,G1H2(362),23,nMT,G2H2(60),n2h2(520))
  call Hloop_AV_Q(ntryL,G1H4(73),ex2(:),G1H2(372),m3h2x2(:,1097),heltab2x4(:,:,1097))
  call Hloop_A_Q(ntryL,G1H2(372),23,nMB,G2H2(65),n2h2(521))
  call Hloop_AV_Q(ntryL,G1H4(1226),ex2(:),G1H2(382),m3h2x2(:,1098),heltab2x4(:,:,1098))
  call Hloop_A_Q(ntryL,G1H2(382),23,nMB,G2H2(68),n2h2(522))
  call Hloop_AV_Q(ntryL,G1H4(78),ex2(:),G1H2(392),m3h2x2(:,1099),heltab2x4(:,:,1099))
  call Hloop_A_Q(ntryL,G1H2(392),23,nMB,G2H2(73),n2h2(523))
  call Hloop_AV_Q(ntryL,G1H4(1231),ex2(:),G1H2(402),m3h2x2(:,1100),heltab2x4(:,:,1100))
  call Hloop_A_Q(ntryL,G1H2(402),23,nMB,G2H2(76),n2h2(524))
  call Hloop_QV_A(ntryL,G1H4(89),ex2(:),G1H2(412),m3h2x2(:,1101),heltab2x4(:,:,1101))
  call Hloop_Q_A(ntryL,G1H2(412),23,nMB,G2H2(81),n2h2(525))
  call Hloop_QV_A(ntryL,G1H4(1242),ex2(:),G1H2(422),m3h2x2(:,1102),heltab2x4(:,:,1102))
  call Hloop_Q_A(ntryL,G1H2(422),23,nMB,G2H2(84),n2h2(526))
  call Hloop_QV_A(ntryL,G1H4(94),ex2(:),G1H2(432),m3h2x2(:,1103),heltab2x4(:,:,1103))
  call Hloop_Q_A(ntryL,G1H2(432),23,nMB,G2H2(89),n2h2(527))
  call Hloop_QV_A(ntryL,G1H4(1247),ex2(:),G1H2(442),m3h2x2(:,1104),heltab2x4(:,:,1104))
  call Hloop_Q_A(ntryL,G1H2(442),23,nMB,G2H2(92),n2h2(528))
  call Hloop_DV_C(ntryL,G1H4(105),21,ex2(:),G2H2(97),m3h2x2(:,1105),heltab2x4(:,:,1105))
  call Hloop_DV_C(ntryL,G1H4(1258),21,ex2(:),G2H2(100),m3h2x2(:,1106),heltab2x4(:,:,1106))
  call Hloop_DV_C(ntryL,G1H4(110),21,ex2(:),G2H2(105),m3h2x2(:,1107),heltab2x4(:,:,1107))
  call Hloop_DV_C(ntryL,G1H4(1263),21,ex2(:),G2H2(108),m3h2x2(:,1108),heltab2x4(:,:,1108))
  call Hloop_CV_D(ntryL,G1H4(121),21,ex2(:),2,G2H2(113),m3h2x2(:,1109),heltab2x4(:,:,1109))
  call Hloop_CV_D(ntryL,G1H4(1274),21,ex2(:),2,G2H2(116),m3h2x2(:,1110),heltab2x4(:,:,1110))
  call Hloop_CV_D(ntryL,G1H4(126),21,ex2(:),2,G2H2(121),m3h2x2(:,1111),heltab2x4(:,:,1111))
  call Hloop_CV_D(ntryL,G1H4(1279),21,ex2(:),2,G2H2(124),m3h2x2(:,1112),heltab2x4(:,:,1112))
  call Hloop_UV_W(ntryL,G1H4(137),21,ex2(:),2,G2H2(129),m3h2x2(:,1113),heltab2x4(:,:,1113))
  call Hloop_UV_W(ntryL,G1H4(1290),21,ex2(:),2,G2H2(132),m3h2x2(:,1114),heltab2x4(:,:,1114))
  call Hloop_UV_W(ntryL,G1H4(142),21,ex2(:),2,G2H2(137),m3h2x2(:,1115),heltab2x4(:,:,1115))
  call Hloop_UV_W(ntryL,G1H4(1295),21,ex2(:),2,G2H2(140),m3h2x2(:,1116),heltab2x4(:,:,1116))
  call Hloop_QV_A(ntryL,G1H4(153),ex3(:),G1H2(452),m3h2x2(:,1117),heltab2x4(:,:,1117))
  call Hloop_Q_A(ntryL,G1H2(452),23,0,G2H2(145),n2h2(529))
  call Hloop_QV_A(ntryL,G1H4(618),ex3(:),G1H2(462),m3h2x2(:,1118),heltab2x4(:,:,1118))
  call Hloop_Q_A(ntryL,G1H2(462),23,0,G2H2(148),n2h2(530))
  call Hloop_QV_A(ntryL,G1H4(158),ex3(:),G1H2(472),m3h2x2(:,1119),heltab2x4(:,:,1119))
  call Hloop_Q_A(ntryL,G1H2(472),23,0,G2H2(153),n2h2(531))
  call Hloop_QV_A(ntryL,G1H4(623),ex3(:),G1H2(482),m3h2x2(:,1120),heltab2x4(:,:,1120))
  call Hloop_Q_A(ntryL,G1H2(482),23,0,G2H2(156),n2h2(532))
  call Hloop_QV_A(ntryL,G1H4(169),ex3(:),G1H2(492),m3h2x2(:,1121),heltab2x4(:,:,1121))
  call Hloop_Q_A(ntryL,G1H2(492),23,nMT,G2H2(161),n2h2(533))
  call Hloop_QV_A(ntryL,G1H4(634),ex3(:),G1H2(502),m3h2x2(:,1122),heltab2x4(:,:,1122))
  call Hloop_Q_A(ntryL,G1H2(502),23,nMT,G2H2(164),n2h2(534))
  call Hloop_QV_A(ntryL,G1H4(174),ex3(:),G1H2(512),m3h2x2(:,1123),heltab2x4(:,:,1123))
  call Hloop_Q_A(ntryL,G1H2(512),23,nMT,G2H2(169),n2h2(535))
  call Hloop_QV_A(ntryL,G1H4(639),ex3(:),G1H2(522),m3h2x2(:,1124),heltab2x4(:,:,1124))
  call Hloop_Q_A(ntryL,G1H2(522),23,nMT,G2H2(172),n2h2(536))
  call Hloop_AV_Q(ntryL,G1H4(185),ex3(:),G1H2(532),m3h2x2(:,1125),heltab2x4(:,:,1125))
  call Hloop_A_Q(ntryL,G1H2(532),23,0,G2H2(177),n2h2(537))
  call Hloop_AV_Q(ntryL,G1H4(586),ex3(:),G1H2(542),m3h2x2(:,1126),heltab2x4(:,:,1126))
  call Hloop_A_Q(ntryL,G1H2(542),23,0,G2H2(180),n2h2(538))
  call Hloop_AV_Q(ntryL,G1H4(190),ex3(:),G1H2(552),m3h2x2(:,1127),heltab2x4(:,:,1127))
  call Hloop_A_Q(ntryL,G1H2(552),23,0,G2H2(185),n2h2(539))
  call Hloop_AV_Q(ntryL,G1H4(591),ex3(:),G1H2(562),m3h2x2(:,1128),heltab2x4(:,:,1128))
  call Hloop_A_Q(ntryL,G1H2(562),23,0,G2H2(188),n2h2(540))
  call Hloop_AV_Q(ntryL,G1H4(201),ex3(:),G1H2(572),m3h2x2(:,1129),heltab2x4(:,:,1129))
  call Hloop_A_Q(ntryL,G1H2(572),23,nMT,G2H2(193),n2h2(541))
  call Hloop_AV_Q(ntryL,G1H4(602),ex3(:),G1H2(582),m3h2x2(:,1130),heltab2x4(:,:,1130))
  call Hloop_A_Q(ntryL,G1H2(582),23,nMT,G2H2(196),n2h2(542))
  call Hloop_AV_Q(ntryL,G1H4(206),ex3(:),G1H2(592),m3h2x2(:,1131),heltab2x4(:,:,1131))
  call Hloop_A_Q(ntryL,G1H2(592),23,nMT,G2H2(201),n2h2(543))
  call Hloop_AV_Q(ntryL,G1H4(607),ex3(:),G1H2(602),m3h2x2(:,1132),heltab2x4(:,:,1132))
  call Hloop_A_Q(ntryL,G1H2(602),23,nMT,G2H2(204),n2h2(544))
  call Hloop_QV_A(ntryL,G1H4(217),ex3(:),G1H2(612),m3h2x2(:,1133),heltab2x4(:,:,1133))
  call Hloop_Q_A(ntryL,G1H2(612),23,nMB,G2H2(209),n2h2(545))
  call Hloop_QV_A(ntryL,G1H4(666),ex3(:),G1H2(622),m3h2x2(:,1134),heltab2x4(:,:,1134))
  call Hloop_Q_A(ntryL,G1H2(622),23,nMB,G2H2(212),n2h2(546))
  call Hloop_QV_A(ntryL,G1H4(222),ex3(:),G1H2(632),m3h2x2(:,1135),heltab2x4(:,:,1135))
  call Hloop_Q_A(ntryL,G1H2(632),23,nMB,G2H2(217),n2h2(547))
  call Hloop_QV_A(ntryL,G1H4(671),ex3(:),G1H2(642),m3h2x2(:,1136),heltab2x4(:,:,1136))
  call Hloop_Q_A(ntryL,G1H2(642),23,nMB,G2H2(220),n2h2(548))
  call Hloop_AV_Q(ntryL,G1H4(233),ex3(:),G1H2(652),m3h2x2(:,1137),heltab2x4(:,:,1137))
  call Hloop_A_Q(ntryL,G1H2(652),23,nMB,G2H2(225),n2h2(549))
  call Hloop_AV_Q(ntryL,G1H4(650),ex3(:),G1H2(662),m3h2x2(:,1138),heltab2x4(:,:,1138))
  call Hloop_A_Q(ntryL,G1H2(662),23,nMB,G2H2(228),n2h2(550))
  call Hloop_AV_Q(ntryL,G1H4(238),ex3(:),G1H2(672),m3h2x2(:,1139),heltab2x4(:,:,1139))
  call Hloop_A_Q(ntryL,G1H2(672),23,nMB,G2H2(233),n2h2(551))
  call Hloop_AV_Q(ntryL,G1H4(655),ex3(:),G1H2(682),m3h2x2(:,1140),heltab2x4(:,:,1140))
  call Hloop_A_Q(ntryL,G1H2(682),23,nMB,G2H2(236),n2h2(552))
  call Hloop_CV_D(ntryL,G1H4(249),19,ex3(:),4,G2H2(241),m3h2x2(:,1141),heltab2x4(:,:,1141))
  call Hloop_CV_D(ntryL,G1H4(698),19,ex3(:),4,G2H2(244),m3h2x2(:,1142),heltab2x4(:,:,1142))
  call Hloop_CV_D(ntryL,G1H4(254),19,ex3(:),4,G2H2(249),m3h2x2(:,1143),heltab2x4(:,:,1143))
  call Hloop_CV_D(ntryL,G1H4(703),19,ex3(:),4,G2H2(252),m3h2x2(:,1144),heltab2x4(:,:,1144))
  call Hloop_DV_C(ntryL,G1H4(265),19,ex3(:),G2H2(257),m3h2x2(:,1145),heltab2x4(:,:,1145))
  call Hloop_DV_C(ntryL,G1H4(682),19,ex3(:),G2H2(260),m3h2x2(:,1146),heltab2x4(:,:,1146))
  call Hloop_DV_C(ntryL,G1H4(270),19,ex3(:),G2H2(265),m3h2x2(:,1147),heltab2x4(:,:,1147))
  call Hloop_DV_C(ntryL,G1H4(687),19,ex3(:),G2H2(268),m3h2x2(:,1148),heltab2x4(:,:,1148))
  call Hloop_UV_W(ntryL,G1H4(281),19,ex3(:),4,G2H2(273),m3h2x2(:,1149),heltab2x4(:,:,1149))
  call Hloop_UV_W(ntryL,G1H4(714),19,ex3(:),4,G2H2(276),m3h2x2(:,1150),heltab2x4(:,:,1150))
  call Hloop_UV_W(ntryL,G1H4(286),19,ex3(:),4,G2H2(281),m3h2x2(:,1151),heltab2x4(:,:,1151))
  call Hloop_UV_W(ntryL,G1H4(719),19,ex3(:),4,G2H2(284),m3h2x2(:,1152),heltab2x4(:,:,1152))
  call Hloop_QV_A(ntryL,G1H4(297),ex1(:),G1H2(692),m3h2x2(:,1153),heltab2x4(:,:,1153))
  call Hloop_Q_A(ntryL,G1H2(692),23,0,G2H2(289),n2h2(553))
  call Hloop_QV_A(ntryL,G1H4(874),ex1(:),G1H2(702),m3h2x2(:,1154),heltab2x4(:,:,1154))
  call Hloop_Q_A(ntryL,G1H2(702),23,0,G2H2(292),n2h2(554))
  call Hloop_QV_A(ntryL,G1H4(302),ex1(:),G1H2(712),m3h2x2(:,1155),heltab2x4(:,:,1155))
  call Hloop_Q_A(ntryL,G1H2(712),23,0,G2H2(297),n2h2(555))
  call Hloop_QV_A(ntryL,G1H4(879),ex1(:),G1H2(722),m3h2x2(:,1156),heltab2x4(:,:,1156))
  call Hloop_Q_A(ntryL,G1H2(722),23,0,G2H2(300),n2h2(556))
  call Hloop_QV_A(ntryL,G1H4(313),ex1(:),G1H2(732),m3h2x2(:,1157),heltab2x4(:,:,1157))
  call Hloop_Q_A(ntryL,G1H2(732),23,nMT,G2H2(305),n2h2(557))
  call Hloop_QV_A(ntryL,G1H4(890),ex1(:),G1H2(742),m3h2x2(:,1158),heltab2x4(:,:,1158))
  call Hloop_Q_A(ntryL,G1H2(742),23,nMT,G2H2(308),n2h2(558))
  call Hloop_QV_A(ntryL,G1H4(318),ex1(:),G1H2(752),m3h2x2(:,1159),heltab2x4(:,:,1159))
  call Hloop_Q_A(ntryL,G1H2(752),23,nMT,G2H2(313),n2h2(559))
  call Hloop_QV_A(ntryL,G1H4(895),ex1(:),G1H2(762),m3h2x2(:,1160),heltab2x4(:,:,1160))
  call Hloop_Q_A(ntryL,G1H2(762),23,nMT,G2H2(316),n2h2(560))
  call Hloop_AV_Q(ntryL,G1H4(329),ex1(:),G1H2(772),m3h2x2(:,1161),heltab2x4(:,:,1161))
  call Hloop_A_Q(ntryL,G1H2(772),23,0,G2H2(321),n2h2(561))
  call Hloop_AV_Q(ntryL,G1H4(906),ex1(:),G1H2(782),m3h2x2(:,1162),heltab2x4(:,:,1162))
  call Hloop_A_Q(ntryL,G1H2(782),23,0,G2H2(324),n2h2(562))
  call Hloop_AV_Q(ntryL,G1H4(334),ex1(:),G1H2(792),m3h2x2(:,1163),heltab2x4(:,:,1163))
  call Hloop_A_Q(ntryL,G1H2(792),23,0,G2H2(329),n2h2(563))
  call Hloop_AV_Q(ntryL,G1H4(911),ex1(:),G1H2(802),m3h2x2(:,1164),heltab2x4(:,:,1164))
  call Hloop_A_Q(ntryL,G1H2(802),23,0,G2H2(332),n2h2(564))
  call Hloop_AV_Q(ntryL,G1H4(345),ex1(:),G1H2(812),m3h2x2(:,1165),heltab2x4(:,:,1165))
  call Hloop_A_Q(ntryL,G1H2(812),23,nMT,G2H2(337),n2h2(565))
  call Hloop_AV_Q(ntryL,G1H4(922),ex1(:),G1H2(822),m3h2x2(:,1166),heltab2x4(:,:,1166))
  call Hloop_A_Q(ntryL,G1H2(822),23,nMT,G2H2(340),n2h2(566))
  call Hloop_AV_Q(ntryL,G1H4(350),ex1(:),G1H2(832),m3h2x2(:,1167),heltab2x4(:,:,1167))
  call Hloop_A_Q(ntryL,G1H2(832),23,nMT,G2H2(345),n2h2(567))
  call Hloop_AV_Q(ntryL,G1H4(927),ex1(:),G1H2(842),m3h2x2(:,1168),heltab2x4(:,:,1168))
  call Hloop_A_Q(ntryL,G1H2(842),23,nMT,G2H2(348),n2h2(568))
  call Hloop_QV_A(ntryL,G1H4(361),ex1(:),G1H2(852),m3h2x2(:,1169),heltab2x4(:,:,1169))
  call Hloop_Q_A(ntryL,G1H2(852),23,nMB,G2H2(353),n2h2(569))
  call Hloop_QV_A(ntryL,G1H4(938),ex1(:),G1H2(862),m3h2x2(:,1170),heltab2x4(:,:,1170))
  call Hloop_Q_A(ntryL,G1H2(862),23,nMB,G2H2(356),n2h2(570))
  call Hloop_QV_A(ntryL,G1H4(366),ex1(:),G1H2(872),m3h2x2(:,1171),heltab2x4(:,:,1171))
  call Hloop_Q_A(ntryL,G1H2(872),23,nMB,G2H2(361),n2h2(571))
  call Hloop_QV_A(ntryL,G1H4(943),ex1(:),G1H2(882),m3h2x2(:,1172),heltab2x4(:,:,1172))
  call Hloop_Q_A(ntryL,G1H2(882),23,nMB,G2H2(364),n2h2(572))
  call Hloop_AV_Q(ntryL,G1H4(377),ex1(:),G1H2(892),m3h2x2(:,1173),heltab2x4(:,:,1173))
  call Hloop_A_Q(ntryL,G1H2(892),23,nMB,G2H2(369),n2h2(573))
  call Hloop_AV_Q(ntryL,G1H4(954),ex1(:),G1H2(902),m3h2x2(:,1174),heltab2x4(:,:,1174))
  call Hloop_A_Q(ntryL,G1H2(902),23,nMB,G2H2(372),n2h2(574))
  call Hloop_AV_Q(ntryL,G1H4(382),ex1(:),G1H2(912),m3h2x2(:,1175),heltab2x4(:,:,1175))
  call Hloop_A_Q(ntryL,G1H2(912),23,nMB,G2H2(377),n2h2(575))
  call Hloop_AV_Q(ntryL,G1H4(959),ex1(:),G1H2(922),m3h2x2(:,1176),heltab2x4(:,:,1176))
  call Hloop_A_Q(ntryL,G1H2(922),23,nMB,G2H2(380),n2h2(576))
  call Hloop_CV_D(ntryL,G1H4(393),22,ex1(:),1,G2H2(385),m3h2x2(:,1177),heltab2x4(:,:,1177))
  call Hloop_CV_D(ntryL,G1H4(970),22,ex1(:),1,G2H2(388),m3h2x2(:,1178),heltab2x4(:,:,1178))
  call Hloop_CV_D(ntryL,G1H4(398),22,ex1(:),1,G2H2(393),m3h2x2(:,1179),heltab2x4(:,:,1179))
  call Hloop_CV_D(ntryL,G1H4(975),22,ex1(:),1,G2H2(396),m3h2x2(:,1180),heltab2x4(:,:,1180))
  call Hloop_DV_C(ntryL,G1H4(409),22,ex1(:),G2H2(401),m3h2x2(:,1181),heltab2x4(:,:,1181))
  call Hloop_DV_C(ntryL,G1H4(986),22,ex1(:),G2H2(404),m3h2x2(:,1182),heltab2x4(:,:,1182))
  call Hloop_DV_C(ntryL,G1H4(414),22,ex1(:),G2H2(409),m3h2x2(:,1183),heltab2x4(:,:,1183))
  call Hloop_DV_C(ntryL,G1H4(991),22,ex1(:),G2H2(412),m3h2x2(:,1184),heltab2x4(:,:,1184))
  call Hloop_UV_W(ntryL,G1H4(425),22,ex1(:),1,G2H2(417),m3h2x2(:,1185),heltab2x4(:,:,1185))
  call Hloop_UV_W(ntryL,G1H4(1002),22,ex1(:),1,G2H2(420),m3h2x2(:,1186),heltab2x4(:,:,1186))
  call Hloop_UV_W(ntryL,G1H4(430),22,ex1(:),1,G2H2(425),m3h2x2(:,1187),heltab2x4(:,:,1187))
  call Hloop_UV_W(ntryL,G1H4(1007),22,ex1(:),1,G2H2(428),m3h2x2(:,1188),heltab2x4(:,:,1188))
  call Hloop_QV_A(ntryL,G1H4(441),ex4(:),G1H2(932),m3h2x2(:,1189),heltab2x4(:,:,1189))
  call Hloop_Q_A(ntryL,G1H2(932),27,0,G2H2(433),n2h2(577))
  call Hloop_QV_A(ntryL,G1H4(762),ex4(:),G1H2(942),m3h2x2(:,1190),heltab2x4(:,:,1190))
  call Hloop_Q_A(ntryL,G1H2(942),27,0,G2H2(436),n2h2(578))
  call Hloop_QV_A(ntryL,G1H4(446),ex4(:),G1H2(952),m3h2x2(:,1191),heltab2x4(:,:,1191))
  call Hloop_Q_A(ntryL,G1H2(952),27,0,G2H2(441),n2h2(579))
  call Hloop_QV_A(ntryL,G1H4(767),ex4(:),G1H2(962),m3h2x2(:,1192),heltab2x4(:,:,1192))
  call Hloop_Q_A(ntryL,G1H2(962),27,0,G2H2(444),n2h2(580))
  call Hloop_QV_A(ntryL,G1H4(457),ex4(:),G1H2(972),m3h2x2(:,1193),heltab2x4(:,:,1193))
  call Hloop_Q_A(ntryL,G1H2(972),27,nMT,G2H2(449),n2h2(581))
  call Hloop_QV_A(ntryL,G1H4(778),ex4(:),G1H2(982),m3h2x2(:,1194),heltab2x4(:,:,1194))
  call Hloop_Q_A(ntryL,G1H2(982),27,nMT,G2H2(452),n2h2(582))
  call Hloop_QV_A(ntryL,G1H4(462),ex4(:),G1H2(992),m3h2x2(:,1195),heltab2x4(:,:,1195))
  call Hloop_Q_A(ntryL,G1H2(992),27,nMT,G2H2(457),n2h2(583))
  call Hloop_QV_A(ntryL,G1H4(783),ex4(:),G1H2(1002),m3h2x2(:,1196),heltab2x4(:,:,1196))
  call Hloop_Q_A(ntryL,G1H2(1002),27,nMT,G2H2(460),n2h2(584))
  call Hloop_AV_Q(ntryL,G1H4(473),ex4(:),G1H2(1012),m3h2x2(:,1197),heltab2x4(:,:,1197))
  call Hloop_A_Q(ntryL,G1H2(1012),27,0,G2H2(465),n2h2(585))
  call Hloop_AV_Q(ntryL,G1H4(730),ex4(:),G1H2(1022),m3h2x2(:,1198),heltab2x4(:,:,1198))
  call Hloop_A_Q(ntryL,G1H2(1022),27,0,G2H2(468),n2h2(586))
  call Hloop_AV_Q(ntryL,G1H4(478),ex4(:),G1H2(1032),m3h2x2(:,1199),heltab2x4(:,:,1199))
  call Hloop_A_Q(ntryL,G1H2(1032),27,0,G2H2(473),n2h2(587))
  call Hloop_AV_Q(ntryL,G1H4(735),ex4(:),G1H2(1042),m3h2x2(:,1200),heltab2x4(:,:,1200))
  call Hloop_A_Q(ntryL,G1H2(1042),27,0,G2H2(476),n2h2(588))
  call Hloop_AV_Q(ntryL,G1H4(489),ex4(:),G1H2(1052),m3h2x2(:,1201),heltab2x4(:,:,1201))
  call Hloop_A_Q(ntryL,G1H2(1052),27,nMT,G2H2(481),n2h2(589))
  call Hloop_AV_Q(ntryL,G1H4(746),ex4(:),G1H2(1062),m3h2x2(:,1202),heltab2x4(:,:,1202))
  call Hloop_A_Q(ntryL,G1H2(1062),27,nMT,G2H2(484),n2h2(590))
  call Hloop_AV_Q(ntryL,G1H4(494),ex4(:),G1H2(1072),m3h2x2(:,1203),heltab2x4(:,:,1203))
  call Hloop_A_Q(ntryL,G1H2(1072),27,nMT,G2H2(489),n2h2(591))
  call Hloop_AV_Q(ntryL,G1H4(751),ex4(:),G1H2(1082),m3h2x2(:,1204),heltab2x4(:,:,1204))
  call Hloop_A_Q(ntryL,G1H2(1082),27,nMT,G2H2(492),n2h2(592))
  call Hloop_QV_A(ntryL,G1H4(505),ex4(:),G1H2(1092),m3h2x2(:,1205),heltab2x4(:,:,1205))
  call Hloop_Q_A(ntryL,G1H2(1092),27,nMB,G2H2(497),n2h2(593))
  call Hloop_QV_A(ntryL,G1H4(810),ex4(:),G1H2(1102),m3h2x2(:,1206),heltab2x4(:,:,1206))
  call Hloop_Q_A(ntryL,G1H2(1102),27,nMB,G2H2(500),n2h2(594))
  call Hloop_QV_A(ntryL,G1H4(510),ex4(:),G1H2(1112),m3h2x2(:,1207),heltab2x4(:,:,1207))
  call Hloop_Q_A(ntryL,G1H2(1112),27,nMB,G2H2(505),n2h2(595))
  call Hloop_QV_A(ntryL,G1H4(815),ex4(:),G1H2(1122),m3h2x2(:,1208),heltab2x4(:,:,1208))
  call Hloop_Q_A(ntryL,G1H2(1122),27,nMB,G2H2(508),n2h2(596))
  call Hloop_AV_Q(ntryL,G1H4(521),ex4(:),G1H2(1132),m3h2x2(:,1209),heltab2x4(:,:,1209))
  call Hloop_A_Q(ntryL,G1H2(1132),27,nMB,G2H2(513),n2h2(597))
  call Hloop_AV_Q(ntryL,G1H4(794),ex4(:),G1H2(1142),m3h2x2(:,1210),heltab2x4(:,:,1210))
  call Hloop_A_Q(ntryL,G1H2(1142),27,nMB,G2H2(516),n2h2(598))
  call Hloop_AV_Q(ntryL,G1H4(526),ex4(:),G1H2(1152),m3h2x2(:,1211),heltab2x4(:,:,1211))
  call Hloop_A_Q(ntryL,G1H2(1152),27,nMB,G2H2(521),n2h2(599))
  call Hloop_AV_Q(ntryL,G1H4(799),ex4(:),G1H2(1162),m3h2x2(:,1212),heltab2x4(:,:,1212))
  call Hloop_A_Q(ntryL,G1H2(1162),27,nMB,G2H2(524),n2h2(600))
  call Hloop_CV_D(ntryL,G1H4(537),19,ex4(:),8,G2H2(529),m3h2x2(:,1213),heltab2x4(:,:,1213))
  call Hloop_CV_D(ntryL,G1H4(842),19,ex4(:),8,G2H2(532),m3h2x2(:,1214),heltab2x4(:,:,1214))
  call Hloop_CV_D(ntryL,G1H4(542),19,ex4(:),8,G2H2(537),m3h2x2(:,1215),heltab2x4(:,:,1215))
  call Hloop_CV_D(ntryL,G1H4(847),19,ex4(:),8,G2H2(540),m3h2x2(:,1216),heltab2x4(:,:,1216))
  call Hloop_DV_C(ntryL,G1H4(553),19,ex4(:),G2H2(545),m3h2x2(:,1217),heltab2x4(:,:,1217))
  call Hloop_DV_C(ntryL,G1H4(826),19,ex4(:),G2H2(548),m3h2x2(:,1218),heltab2x4(:,:,1218))
  call Hloop_DV_C(ntryL,G1H4(558),19,ex4(:),G2H2(553),m3h2x2(:,1219),heltab2x4(:,:,1219))
  call Hloop_DV_C(ntryL,G1H4(831),19,ex4(:),G2H2(556),m3h2x2(:,1220),heltab2x4(:,:,1220))
  call Hloop_UV_W(ntryL,G1H4(569),19,ex4(:),8,G2H2(561),m3h2x2(:,1221),heltab2x4(:,:,1221))
  call Hloop_UV_W(ntryL,G1H4(858),19,ex4(:),8,G2H2(564),m3h2x2(:,1222),heltab2x4(:,:,1222))
  call Hloop_UV_W(ntryL,G1H4(574),19,ex4(:),8,G2H2(569),m3h2x2(:,1223),heltab2x4(:,:,1223))
  call Hloop_UV_W(ntryL,G1H4(863),19,ex4(:),8,G2H2(572),m3h2x2(:,1224),heltab2x4(:,:,1224))
  call Hotf_4pt_reduction(G2H4(421),RedSet_4(27),mass4set(:,1),  & 
G1H4(1633),G1H4(1634),G1H4(1639),G1H4(1644),G1H4(1640),G0H4(181),4)
  call HG1shiftOLR(G1H4(1634),8,4)
  call Hloop_AV_Q(ntryL,G1H4(585),ex3(:),G1H2(1172),m3h2x2(:,1225),heltab2x4(:,:,1225))
  call Hloop_A_Q(ntryL,G1H2(1172),23,0,G2H2(577),n2h2(601))
  call Hloop_AV_Q(ntryL,G1H4(590),ex3(:),G1H2(1182),m3h2x2(:,1226),heltab2x4(:,:,1226))
  call Hloop_A_Q(ntryL,G1H2(1182),23,0,G2H2(580),n2h2(602))
  call Hotf_4pt_reduction(G2H4(424),RedSet_4(27),mass4set(:,2),  & 
G1H4(1643),G1H4(1645),G1H4(1648),G1H4(1649),G1H4(1650),G0H4(182),4)
  call HG1shiftOLR(G1H4(1645),8,4)
  call Hloop_AV_Q(ntryL,G1H4(601),ex3(:),G1H2(1192),m3h2x2(:,1227),heltab2x4(:,:,1227))
  call Hloop_A_Q(ntryL,G1H2(1192),23,nMT,G2H2(585),n2h2(603))
  call Hloop_AV_Q(ntryL,G1H4(606),ex3(:),G1H2(1202),m3h2x2(:,1228),heltab2x4(:,:,1228))
  call Hloop_A_Q(ntryL,G1H2(1202),23,nMT,G2H2(588),n2h2(604))
  call Hotf_4pt_reduction(G2H4(425),RedSet_4(27),mass4set(:,1),  & 
G1H4(1655),G1H4(1660),G1H4(1656),G1H4(1659),G1H4(1661),G0H4(183),4)
  call HG1shiftOLR(G1H4(1660),8,4)
  call Hloop_QV_A(ntryL,G1H4(617),ex3(:),G1H2(1212),m3h2x2(:,1229),heltab2x4(:,:,1229))
  call Hloop_Q_A(ntryL,G1H2(1212),23,0,G2H2(593),n2h2(605))
  call Hloop_QV_A(ntryL,G1H4(622),ex3(:),G1H2(1222),m3h2x2(:,1230),heltab2x4(:,:,1230))
  call Hloop_Q_A(ntryL,G1H2(1222),23,0,G2H2(596),n2h2(606))
  call Hotf_4pt_reduction(G2H4(426),RedSet_4(27),mass4set(:,2),  & 
G1H4(1664),G1H4(1665),G1H4(1666),G1H4(1671),G1H4(1676),G0H4(184),4)
  call HG1shiftOLR(G1H4(1665),8,4)
  call Hloop_QV_A(ntryL,G1H4(633),ex3(:),G1H2(1232),m3h2x2(:,1231),heltab2x4(:,:,1231))
  call Hloop_Q_A(ntryL,G1H2(1232),23,nMT,G2H2(601),n2h2(607))
  call Hloop_QV_A(ntryL,G1H4(638),ex3(:),G1H2(1242),m3h2x2(:,1232),heltab2x4(:,:,1232))
  call Hloop_Q_A(ntryL,G1H2(1242),23,nMT,G2H2(604),n2h2(608))
  call Hotf_4pt_reduction(G2H4(429),RedSet_4(27),mass4set(:,3),  & 
G1H4(1672),G1H4(1675),G1H4(1677),G1H4(1680),G1H4(1681),G0H4(185),4)
  call HG1shiftOLR(G1H4(1675),8,4)
  call Hloop_AV_Q(ntryL,G1H4(649),ex3(:),G1H2(1252),m3h2x2(:,1233),heltab2x4(:,:,1233))
  call Hloop_A_Q(ntryL,G1H2(1252),23,nMB,G2H2(609),n2h2(609))
  call Hloop_AV_Q(ntryL,G1H4(654),ex3(:),G1H2(1262),m3h2x2(:,1234),heltab2x4(:,:,1234))
  call Hloop_A_Q(ntryL,G1H2(1262),23,nMB,G2H2(612),n2h2(610))
  call Hotf_4pt_reduction(G2H4(430),RedSet_4(27),mass4set(:,3),  & 
G1H4(1682),G1H4(1687),G1H4(1692),G1H4(1688),G1H4(1691),G0H4(186),4)
  call HG1shiftOLR(G1H4(1687),8,4)
  call Hloop_QV_A(ntryL,G1H4(665),ex3(:),G1H2(1272),m3h2x2(:,1235),heltab2x4(:,:,1235))
  call Hloop_Q_A(ntryL,G1H2(1272),23,nMB,G2H2(617),n2h2(611))
  call Hloop_QV_A(ntryL,G1H4(670),ex3(:),G1H2(1282),m3h2x2(:,1236),heltab2x4(:,:,1236))
  call Hloop_Q_A(ntryL,G1H2(1282),23,nMB,G2H2(620),n2h2(612))
  call Hotf_4pt_reduction(G2H4(431),RedSet_4(27),mass4set(:,1),  & 
G1H4(1693),G1H4(1696),G1H4(1697),G1H4(1698),G1H4(1703),G0H4(187),4)
  call HG1shiftOLR(G1H4(1696),8,4)
  call Hloop_DV_C(ntryL,G1H4(681),19,ex3(:),G2H2(625),m3h2x2(:,1237),heltab2x4(:,:,1237))
  call Hloop_DV_C(ntryL,G1H4(686),19,ex3(:),G2H2(628),m3h2x2(:,1238),heltab2x4(:,:,1238))
  call Hotf_4pt_reduction(G2H4(434),RedSet_4(27),mass4set(:,1),  & 
G1H4(1708),G1H4(1704),G1H4(1707),G1H4(1709),G1H4(1712),G0H4(188),4)
  call HG1shiftOLR(G1H4(1704),8,4)
  call Hloop_CV_D(ntryL,G1H4(697),19,ex3(:),4,G2H2(633),m3h2x2(:,1239),heltab2x4(:,:,1239))
  call Hloop_CV_D(ntryL,G1H4(702),19,ex3(:),4,G2H2(636),m3h2x2(:,1240),heltab2x4(:,:,1240))
  call Hotf_4pt_reduction(G2H4(435),RedSet_4(27),mass4set(:,1),  & 
G1H4(1713),G1H4(1714),G1H4(1719),G1H4(1724),G1H4(1720),G0H4(189),4)
  call HG1shiftOLR(G1H4(1714),8,4)
  call Hloop_UV_W(ntryL,G1H4(713),19,ex3(:),4,G2H2(641),m3h2x2(:,1241),heltab2x4(:,:,1241))
  call Hloop_UV_W(ntryL,G1H4(718),19,ex3(:),4,G2H2(644),m3h2x2(:,1242),heltab2x4(:,:,1242))
  call Hotf_4pt_reduction(G2H4(436),RedSet_4(29),mass4set(:,1),  & 
G1H4(1723),G1H4(1725),G1H4(1728),G1H4(5),G1H4(6),G0H4(190),4)
  call HG1shiftOLR(G1H4(1725),4,4)
  call Hloop_AV_Q(ntryL,G1H4(729),ex4(:),G1H2(1292),m3h2x2(:,1243),heltab2x4(:,:,1243))
  call Hloop_A_Q(ntryL,G1H2(1292),27,0,G2H2(649),n2h2(613))
  call Hloop_AV_Q(ntryL,G1H4(734),ex4(:),G1H2(217),m3h2x2(:,1244),heltab2x4(:,:,1244))
  call Hloop_A_Q(ntryL,G1H2(217),27,0,G2H2(652),n2h2(614))
  call Hotf_4pt_reduction(G2H4(439),RedSet_4(29),mass4set(:,2),  & 
G1H4(21),G1H4(22),G1H4(37),G1H4(38),G1H4(53),G0H4(191),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hloop_AV_Q(ntryL,G1H4(745),ex4(:),G1H2(218),m3h2x2(:,1245),heltab2x4(:,:,1245))
  call Hloop_A_Q(ntryL,G1H2(218),27,nMT,G2H2(657),n2h2(615))
  call Hloop_AV_Q(ntryL,G1H4(750),ex4(:),G1H2(223),m3h2x2(:,1246),heltab2x4(:,:,1246))
  call Hloop_A_Q(ntryL,G1H2(223),27,nMT,G2H2(660),n2h2(616))
  call Hotf_4pt_reduction(G2H4(440),RedSet_4(29),mass4set(:,1),  & 
G1H4(54),G1H4(69),G1H4(70),G1H4(85),G1H4(86),G0H4(192),4)
  call HG1shiftOLR(G1H4(69),4,4)
  call Hloop_QV_A(ntryL,G1H4(761),ex4(:),G1H2(224),m3h2x2(:,1247),heltab2x4(:,:,1247))
  call Hloop_Q_A(ntryL,G1H2(224),27,0,G2H2(665),n2h2(617))
  call Hloop_QV_A(ntryL,G1H4(766),ex4(:),G1H2(2),m3h2x2(:,1248),heltab2x4(:,:,1248))
  call Hloop_Q_A(ntryL,G1H2(2),27,0,G2H2(668),n2h2(618))
  call Hotf_4pt_reduction(G2H4(441),RedSet_4(29),mass4set(:,2),  & 
G1H4(101),G1H4(102),G1H4(117),G1H4(118),G1H4(133),G0H4(193),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hloop_QV_A(ntryL,G1H4(777),ex4(:),G1H2(228),m3h2x2(:,1249),heltab2x4(:,:,1249))
  call Hloop_Q_A(ntryL,G1H2(228),27,nMT,G2H2(673),n2h2(619))
  call Hloop_QV_A(ntryL,G1H4(782),ex4(:),G1H2(233),m3h2x2(:,1250),heltab2x4(:,:,1250))
  call Hloop_Q_A(ntryL,G1H2(233),27,nMT,G2H2(676),n2h2(620))
  call Hotf_4pt_reduction(G2H4(444),RedSet_4(29),mass4set(:,3),  & 
G1H4(134),G1H4(149),G1H4(150),G1H4(165),G1H4(166),G0H4(194),4)
  call HG1shiftOLR(G1H4(149),4,4)
  call Hloop_AV_Q(ntryL,G1H4(793),ex4(:),G1H2(234),m3h2x2(:,1251),heltab2x4(:,:,1251))
  call Hloop_A_Q(ntryL,G1H2(234),27,nMB,G2H2(681),n2h2(621))
  call Hloop_AV_Q(ntryL,G1H4(798),ex4(:),G1H2(4),m3h2x2(:,1252),heltab2x4(:,:,1252))
  call Hloop_A_Q(ntryL,G1H2(4),27,nMB,G2H2(684),n2h2(622))
  call Hotf_4pt_reduction(G2H4(445),RedSet_4(29),mass4set(:,3),  & 
G1H4(181),G1H4(182),G1H4(197),G1H4(198),G1H4(213),G0H4(195),4)
  call HG1shiftOLR(G1H4(182),4,4)
  call Hloop_QV_A(ntryL,G1H4(809),ex4(:),G1H2(238),m3h2x2(:,1253),heltab2x4(:,:,1253))
  call Hloop_Q_A(ntryL,G1H2(238),27,nMB,G2H2(689),n2h2(623))
  call Hloop_QV_A(ntryL,G1H4(814),ex4(:),G1H2(243),m3h2x2(:,1254),heltab2x4(:,:,1254))
  call Hloop_Q_A(ntryL,G1H2(243),27,nMB,G2H2(692),n2h2(624))
  call Hotf_4pt_reduction(G2H4(446),RedSet_4(29),mass4set(:,1),  & 
G1H4(214),G1H4(229),G1H4(230),G1H4(245),G1H4(246),G0H4(196),4)
  call HG1shiftOLR(G1H4(229),4,4)
  call Hloop_DV_C(ntryL,G1H4(825),19,ex4(:),G2H2(697),m3h2x2(:,1255),heltab2x4(:,:,1255))
  call Hloop_DV_C(ntryL,G1H4(830),19,ex4(:),G2H2(700),m3h2x2(:,1256),heltab2x4(:,:,1256))
  call Hotf_4pt_reduction(G2H4(449),RedSet_4(29),mass4set(:,1),  & 
G1H4(261),G1H4(262),G1H4(277),G1H4(278),G1H4(293),G0H4(197),4)
  call HG1shiftOLR(G1H4(262),4,4)
  call Hloop_CV_D(ntryL,G1H4(841),19,ex4(:),8,G2H2(705),m3h2x2(:,1257),heltab2x4(:,:,1257))
  call Hloop_CV_D(ntryL,G1H4(846),19,ex4(:),8,G2H2(708),m3h2x2(:,1258),heltab2x4(:,:,1258))
  call Hotf_4pt_reduction(G2H4(450),RedSet_4(29),mass4set(:,1),  & 
G1H4(294),G1H4(309),G1H4(310),G1H4(325),G1H4(326),G0H4(198),4)
  call HG1shiftOLR(G1H4(309),4,4)
  call Hloop_UV_W(ntryL,G1H4(857),19,ex4(:),8,G2H2(713),m3h2x2(:,1259),heltab2x4(:,:,1259))
  call Hloop_UV_W(ntryL,G1H4(862),19,ex4(:),8,G2H2(716),m3h2x2(:,1260),heltab2x4(:,:,1260))
  call Hotf_4pt_reduction(G2H4(451),RedSet_4(31),mass4set(:,1),  & 
G1H4(341),G1H4(342),G1H4(357),G1H4(358),G1H4(373),G0H4(199),4)
  call HG1shiftOLR(G1H4(342),8,4)
  call Hloop_QV_A(ntryL,G1H4(873),ex1(:),G1H2(244),m3h2x2(:,1261),heltab2x4(:,:,1261))
  call Hloop_Q_A(ntryL,G1H2(244),23,0,G2H2(721),n2h2(625))
  call Hloop_QV_A(ntryL,G1H4(878),ex1(:),G1H2(6),m3h2x2(:,1262),heltab2x4(:,:,1262))
  call Hloop_Q_A(ntryL,G1H2(6),23,0,G2H2(724),n2h2(626))
  call Hotf_4pt_reduction(G2H4(454),RedSet_4(31),mass4set(:,2),  & 
G1H4(374),G1H4(389),G1H4(390),G1H4(405),G1H4(406),G0H4(200),4)
  call HG1shiftOLR(G1H4(389),8,4)
  call Hloop_QV_A(ntryL,G1H4(889),ex1(:),G1H2(248),m3h2x2(:,1263),heltab2x4(:,:,1263))
  call Hloop_Q_A(ntryL,G1H2(248),23,nMT,G2H2(729),n2h2(627))
  call Hloop_QV_A(ntryL,G1H4(894),ex1(:),G1H2(253),m3h2x2(:,1264),heltab2x4(:,:,1264))
  call Hloop_Q_A(ntryL,G1H2(253),23,nMT,G2H2(732),n2h2(628))
  call Hotf_4pt_reduction(G2H4(455),RedSet_4(31),mass4set(:,1),  & 
G1H4(421),G1H4(422),G1H4(437),G1H4(438),G1H4(453),G0H4(201),4)
  call HG1shiftOLR(G1H4(422),8,4)
  call Hloop_AV_Q(ntryL,G1H4(905),ex1(:),G1H2(254),m3h2x2(:,1265),heltab2x4(:,:,1265))
  call Hloop_A_Q(ntryL,G1H2(254),23,0,G2H2(737),n2h2(629))
  call Hloop_AV_Q(ntryL,G1H4(910),ex1(:),G1H2(8),m3h2x2(:,1266),heltab2x4(:,:,1266))
  call Hloop_A_Q(ntryL,G1H2(8),23,0,G2H2(740),n2h2(630))
  call Hotf_4pt_reduction(G2H4(456),RedSet_4(31),mass4set(:,2),  & 
G1H4(454),G1H4(469),G1H4(470),G1H4(485),G1H4(486),G0H4(202),4)
  call HG1shiftOLR(G1H4(469),8,4)
  call Hloop_AV_Q(ntryL,G1H4(921),ex1(:),G1H2(258),m3h2x2(:,1267),heltab2x4(:,:,1267))
  call Hloop_A_Q(ntryL,G1H2(258),23,nMT,G2H2(745),n2h2(631))
  call Hloop_AV_Q(ntryL,G1H4(926),ex1(:),G1H2(263),m3h2x2(:,1268),heltab2x4(:,:,1268))
  call Hloop_A_Q(ntryL,G1H2(263),23,nMT,G2H2(748),n2h2(632))
  call Hotf_4pt_reduction(G2H4(459),RedSet_4(31),mass4set(:,3),  & 
G1H4(501),G1H4(502),G1H4(517),G1H4(518),G1H4(533),G0H4(203),4)
  call HG1shiftOLR(G1H4(502),8,4)
  call Hloop_QV_A(ntryL,G1H4(937),ex1(:),G1H2(264),m3h2x2(:,1269),heltab2x4(:,:,1269))
  call Hloop_Q_A(ntryL,G1H2(264),23,nMB,G2H2(753),n2h2(633))
  call Hloop_QV_A(ntryL,G1H4(942),ex1(:),G1H2(10),m3h2x2(:,1270),heltab2x4(:,:,1270))
  call Hloop_Q_A(ntryL,G1H2(10),23,nMB,G2H2(756),n2h2(634))
  call Hotf_4pt_reduction(G2H4(460),RedSet_4(31),mass4set(:,3),  & 
G1H4(534),G1H4(549),G1H4(550),G1H4(565),G1H4(566),G0H4(204),4)
  call HG1shiftOLR(G1H4(549),8,4)
  call Hloop_AV_Q(ntryL,G1H4(953),ex1(:),G1H2(268),m3h2x2(:,1271),heltab2x4(:,:,1271))
  call Hloop_A_Q(ntryL,G1H2(268),23,nMB,G2H2(761),n2h2(635))
  call Hloop_AV_Q(ntryL,G1H4(958),ex1(:),G1H2(273),m3h2x2(:,1272),heltab2x4(:,:,1272))
  call Hloop_A_Q(ntryL,G1H2(273),23,nMB,G2H2(764),n2h2(636))
  call Hotf_4pt_reduction(G2H4(461),RedSet_4(31),mass4set(:,1),  & 
G1H4(677),G1H4(678),G1H4(693),G1H4(694),G1H4(709),G0H4(205),4)
  call HG1shiftOLR(G1H4(678),8,4)
  call Hloop_CV_D(ntryL,G1H4(969),22,ex1(:),1,G2H2(769),m3h2x2(:,1273),heltab2x4(:,:,1273))
  call Hloop_CV_D(ntryL,G1H4(974),22,ex1(:),1,G2H2(772),m3h2x2(:,1274),heltab2x4(:,:,1274))
  call Hotf_4pt_reduction(G2H4(464),RedSet_4(31),mass4set(:,1),  & 
G1H4(710),G1H4(725),G1H4(726),G1H4(741),G1H4(742),G0H4(206),4)
  call HG1shiftOLR(G1H4(725),8,4)
  call Hloop_DV_C(ntryL,G1H4(985),22,ex1(:),G2H2(777),m3h2x2(:,1275),heltab2x4(:,:,1275))
  call Hloop_DV_C(ntryL,G1H4(990),22,ex1(:),G2H2(780),m3h2x2(:,1276),heltab2x4(:,:,1276))
  call Hotf_4pt_reduction(G2H4(465),RedSet_4(31),mass4set(:,1),  & 
G1H4(757),G1H4(758),G1H4(773),G1H4(774),G1H4(789),G0H4(207),4)
  call HG1shiftOLR(G1H4(758),8,4)
  call Hloop_UV_W(ntryL,G1H4(1001),22,ex1(:),1,G2H2(785),m3h2x2(:,1277),heltab2x4(:,:,1277))
  call Hloop_UV_W(ntryL,G1H4(1006),22,ex1(:),1,G2H2(788),m3h2x2(:,1278),heltab2x4(:,:,1278))
  call Hotf_4pt_reduction(G2H4(466),RedSet_4(33),mass4set(:,1),  & 
G1H4(790),G1H4(805),G1H4(806),G1H4(821),G1H4(822),G0H4(208),4)
  call HG1shiftOLR(G1H4(805),4,4)
  call Hloop_AV_Q(ntryL,G1H4(1017),ex1(:),G1H2(274),m3h2x2(:,1279),heltab2x4(:,:,1279))
  call Hloop_A_Q(ntryL,G1H2(274),27,0,G2H2(793),n2h2(637))
  call Hloop_AV_Q(ntryL,G1H4(1018),ex1(:),G1H2(12),m3h2x2(:,1280),heltab2x4(:,:,1280))
  call Hloop_A_Q(ntryL,G1H2(12),27,0,G2H2(796),n2h2(638))
  call Hloop_AV_Q(ntryL,G1H4(1022),ex1(:),G1H2(278),m3h2x2(:,1281),heltab2x4(:,:,1281))
  call Hloop_A_Q(ntryL,G1H2(278),27,0,G2H2(801),n2h2(639))
  call Hloop_AV_Q(ntryL,G1H4(1023),ex1(:),G1H2(283),m3h2x2(:,1282),heltab2x4(:,:,1282))
  call Hloop_A_Q(ntryL,G1H2(283),27,0,G2H2(804),n2h2(640))
  call Hotf_4pt_reduction(G2H4(469),RedSet_4(33),mass4set(:,2),  & 
G1H4(837),G1H4(838),G1H4(853),G1H4(854),G1H4(869),G0H4(209),4)
  call HG1shiftOLR(G1H4(838),4,4)
  call Hloop_AV_Q(ntryL,G1H4(1033),ex1(:),G1H2(284),m3h2x2(:,1283),heltab2x4(:,:,1283))
  call Hloop_A_Q(ntryL,G1H2(284),27,nMT,G2H2(809),n2h2(641))
  call Hloop_AV_Q(ntryL,G1H4(1034),ex1(:),G1H2(14),m3h2x2(:,1284),heltab2x4(:,:,1284))
  call Hloop_A_Q(ntryL,G1H2(14),27,nMT,G2H2(812),n2h2(642))
  call Hloop_AV_Q(ntryL,G1H4(1038),ex1(:),G1H2(288),m3h2x2(:,1285),heltab2x4(:,:,1285))
  call Hloop_A_Q(ntryL,G1H2(288),27,nMT,G2H2(817),n2h2(643))
  call Hloop_AV_Q(ntryL,G1H4(1039),ex1(:),G1H2(293),m3h2x2(:,1286),heltab2x4(:,:,1286))
  call Hloop_A_Q(ntryL,G1H2(293),27,nMT,G2H2(820),n2h2(644))
  call Hotf_4pt_reduction(G2H4(470),RedSet_4(33),mass4set(:,1),  & 
G1H4(870),G1H4(885),G1H4(886),G1H4(901),G1H4(902),G0H4(210),4)
  call HG1shiftOLR(G1H4(885),4,4)
  call Hloop_QV_A(ntryL,G1H4(1049),ex1(:),G1H2(294),m3h2x2(:,1287),heltab2x4(:,:,1287))
  call Hloop_Q_A(ntryL,G1H2(294),27,0,G2H2(825),n2h2(645))
  call Hloop_QV_A(ntryL,G1H4(1050),ex1(:),G1H2(16),m3h2x2(:,1288),heltab2x4(:,:,1288))
  call Hloop_Q_A(ntryL,G1H2(16),27,0,G2H2(828),n2h2(646))
  call Hloop_QV_A(ntryL,G1H4(1054),ex1(:),G1H2(298),m3h2x2(:,1289),heltab2x4(:,:,1289))
  call Hloop_Q_A(ntryL,G1H2(298),27,0,G2H2(833),n2h2(647))
  call Hloop_QV_A(ntryL,G1H4(1055),ex1(:),G1H2(303),m3h2x2(:,1290),heltab2x4(:,:,1290))
  call Hloop_Q_A(ntryL,G1H2(303),27,0,G2H2(836),n2h2(648))
  call Hotf_4pt_reduction(G2H4(471),RedSet_4(33),mass4set(:,2),  & 
G1H4(917),G1H4(918),G1H4(933),G1H4(934),G1H4(949),G0H4(211),4)
  call HG1shiftOLR(G1H4(918),4,4)
  call Hloop_QV_A(ntryL,G1H4(1065),ex1(:),G1H2(304),m3h2x2(:,1291),heltab2x4(:,:,1291))
  call Hloop_Q_A(ntryL,G1H2(304),27,nMT,G2H2(841),n2h2(649))
  call Hloop_QV_A(ntryL,G1H4(1066),ex1(:),G1H2(18),m3h2x2(:,1292),heltab2x4(:,:,1292))
  call Hloop_Q_A(ntryL,G1H2(18),27,nMT,G2H2(844),n2h2(650))
  call Hloop_QV_A(ntryL,G1H4(1070),ex1(:),G1H2(308),m3h2x2(:,1293),heltab2x4(:,:,1293))
  call Hloop_Q_A(ntryL,G1H2(308),27,nMT,G2H2(849),n2h2(651))
  call Hloop_QV_A(ntryL,G1H4(1071),ex1(:),G1H2(313),m3h2x2(:,1294),heltab2x4(:,:,1294))
  call Hloop_Q_A(ntryL,G1H2(313),27,nMT,G2H2(852),n2h2(652))
  call Hotf_4pt_reduction(G2H4(474),RedSet_4(33),mass4set(:,3),  & 
G1H4(950),G1H4(965),G1H4(966),G1H4(981),G1H4(982),G0H4(212),4)
  call HG1shiftOLR(G1H4(965),4,4)
  call Hloop_AV_Q(ntryL,G1H4(1081),ex1(:),G1H2(314),m3h2x2(:,1295),heltab2x4(:,:,1295))
  call Hloop_A_Q(ntryL,G1H2(314),27,nMB,G2H2(857),n2h2(653))
  call Hloop_AV_Q(ntryL,G1H4(1082),ex1(:),G1H2(20),m3h2x2(:,1296),heltab2x4(:,:,1296))
  call Hloop_A_Q(ntryL,G1H2(20),27,nMB,G2H2(860),n2h2(654))
  call Hloop_AV_Q(ntryL,G1H4(1086),ex1(:),G1H2(318),m3h2x2(:,1297),heltab2x4(:,:,1297))
  call Hloop_A_Q(ntryL,G1H2(318),27,nMB,G2H2(865),n2h2(655))
  call Hloop_AV_Q(ntryL,G1H4(1087),ex1(:),G1H2(323),m3h2x2(:,1298),heltab2x4(:,:,1298))
  call Hloop_A_Q(ntryL,G1H2(323),27,nMB,G2H2(866),n2h2(656))
  call Hotf_4pt_reduction(G2H4(475),RedSet_4(33),mass4set(:,3),  & 
G1H4(997),G1H4(998),G1H4(1013),G1H4(1014),G1H4(1029),G0H4(213),4)
  call HG1shiftOLR(G1H4(998),4,4)
  call Hloop_QV_A(ntryL,G1H4(1097),ex1(:),G1H2(324),m3h2x2(:,1299),heltab2x4(:,:,1299))
  call Hloop_Q_A(ntryL,G1H2(324),27,nMB,G2H2(867),n2h2(657))
  call Hloop_QV_A(ntryL,G1H4(1098),ex1(:),G1H2(22),m3h2x2(:,1300),heltab2x4(:,:,1300))
  call Hloop_Q_A(ntryL,G1H2(22),27,nMB,G2H2(868),n2h2(658))
  call Hloop_QV_A(ntryL,G1H4(1102),ex1(:),G1H2(328),m3h2x2(:,1301),heltab2x4(:,:,1301))
  call Hloop_Q_A(ntryL,G1H2(328),27,nMB,G2H2(869),n2h2(659))
  call Hloop_QV_A(ntryL,G1H4(1103),ex1(:),G1H2(333),m3h2x2(:,1302),heltab2x4(:,:,1302))
  call Hloop_Q_A(ntryL,G1H2(333),27,nMB,G2H2(870),n2h2(660))
  call Hotf_4pt_reduction(G2H4(476),RedSet_4(33),mass4set(:,1),  & 
G1H4(1030),G1H4(1045),G1H4(1046),G1H4(1156),G1H4(4),G0H4(214),4)
  call HG1shiftOLR(G1H4(1045),4,4)
  call Hloop_DV_C(ntryL,G1H4(1113),26,ex1(:),G2H2(871),m3h2x2(:,1303),heltab2x4(:,:,1303))
  call Hloop_DV_C(ntryL,G1H4(1114),26,ex1(:),G2H2(872),m3h2x2(:,1304),heltab2x4(:,:,1304))
  call Hloop_DV_C(ntryL,G1H4(1118),26,ex1(:),G2H2(873),m3h2x2(:,1305),heltab2x4(:,:,1305))
  call Hloop_DV_C(ntryL,G1H4(1119),26,ex1(:),G2H2(874),m3h2x2(:,1306),heltab2x4(:,:,1306))
  call Hotf_4pt_reduction(G2H4(479),RedSet_4(33),mass4set(:,1),  & 
G1H4(1172),G1H4(20),G1H4(1188),G1H4(36),G1H4(1204),G0H4(215),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_CV_D(ntryL,G1H4(1129),26,ex1(:),1,G2H2(875),m3h2x2(:,1307),heltab2x4(:,:,1307))
  call Hloop_CV_D(ntryL,G1H4(1130),26,ex1(:),1,G2H2(876),m3h2x2(:,1308),heltab2x4(:,:,1308))
  call Hloop_CV_D(ntryL,G1H4(1134),26,ex1(:),1,G2H2(877),m3h2x2(:,1309),heltab2x4(:,:,1309))
  call Hloop_CV_D(ntryL,G1H4(1135),26,ex1(:),1,G2H2(878),m3h2x2(:,1310),heltab2x4(:,:,1310))
  call Hotf_4pt_reduction(G2H4(480),RedSet_4(33),mass4set(:,1),  & 
G1H4(52),G1H4(1220),G1H4(68),G1H4(1236),G1H4(84),G0H4(216),4)
  call HG1shiftOLR(G1H4(1220),4,4)
  call Hloop_UV_W(ntryL,G1H4(1145),26,ex1(:),1,G2H2(879),m3h2x2(:,1311),heltab2x4(:,:,1311))
  call Hloop_UV_W(ntryL,G1H4(1146),26,ex1(:),1,G2H2(880),m3h2x2(:,1312),heltab2x4(:,:,1312))
  call Hloop_UV_W(ntryL,G1H4(1150),26,ex1(:),1,G2H2(881),m3h2x2(:,1313),heltab2x4(:,:,1313))
  call Hloop_UV_W(ntryL,G1H4(1151),26,ex1(:),1,G2H2(882),m3h2x2(:,1314),heltab2x4(:,:,1314))
  call Hotf_4pt_reduction(G2H4(481),RedSet_4(36),mass4set(:,1),  & 
G1H4(1252),G1H4(100),G1H4(1268),G1H4(116),G1H4(614),G0H4(217),4)
  call HG1shiftOLR(G1H4(100),8,4)
  call Hloop_AV_Q(ntryL,G1H4(1161),ex2(:),G1H2(334),m3h2x2(:,1315),heltab2x4(:,:,1315))
  call Hloop_A_Q(ntryL,G1H2(334),23,0,G2H2(883),n2h2(661))
  call Hloop_AV_Q(ntryL,G1H4(1166),ex2(:),G1H2(24),m3h2x2(:,1316),heltab2x4(:,:,1316))
  call Hloop_A_Q(ntryL,G1H2(24),23,0,G2H2(884),n2h2(662))
  call Hotf_4pt_reduction(G2H4(484),RedSet_4(36),mass4set(:,2),  & 
G1H4(613),G1H4(598),G1H4(1284),G1H4(132),G1H4(612),G0H4(218),4)
  call HG1shiftOLR(G1H4(598),8,4)
  call Hloop_AV_Q(ntryL,G1H4(1177),ex2(:),G1H2(338),m3h2x2(:,1317),heltab2x4(:,:,1317))
  call Hloop_A_Q(ntryL,G1H2(338),23,nMT,G2H2(885),n2h2(663))
  call Hloop_AV_Q(ntryL,G1H4(1182),ex2(:),G1H2(343),m3h2x2(:,1318),heltab2x4(:,:,1318))
  call Hloop_A_Q(ntryL,G1H2(343),23,nMT,G2H2(886),n2h2(664))
  call Hotf_4pt_reduction(G2H4(485),RedSet_4(36),mass4set(:,1),  & 
G1H4(148),G1H4(628),G1H4(164),G1H4(580),G1H4(180),G0H4(219),4)
  call HG1shiftOLR(G1H4(628),8,4)
  call Hloop_QV_A(ntryL,G1H4(1193),ex2(:),G1H2(344),m3h2x2(:,1319),heltab2x4(:,:,1319))
  call Hloop_Q_A(ntryL,G1H2(344),23,0,G2H2(887),n2h2(665))
  call Hloop_QV_A(ntryL,G1H4(1198),ex2(:),G1H2(26),m3h2x2(:,1320),heltab2x4(:,:,1320))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(888),n2h2(666))
  call Hotf_4pt_reduction(G2H4(486),RedSet_4(36),mass4set(:,2),  & 
G1H4(596),G1H4(196),G1H4(660),G1H4(212),G1H4(644),G0H4(220),4)
  call HG1shiftOLR(G1H4(196),8,4)
  call Hloop_QV_A(ntryL,G1H4(1209),ex2(:),G1H2(348),m3h2x2(:,1321),heltab2x4(:,:,1321))
  call Hloop_Q_A(ntryL,G1H2(348),23,nMT,G2H2(889),n2h2(667))
  call Hloop_QV_A(ntryL,G1H4(1214),ex2(:),G1H2(353),m3h2x2(:,1322),heltab2x4(:,:,1322))
  call Hloop_Q_A(ntryL,G1H2(353),23,nMT,G2H2(890),n2h2(668))
  call Hotf_4pt_reduction(G2H4(489),RedSet_4(36),mass4set(:,3),  & 
G1H4(228),G1H4(692),G1H4(244),G1H4(676),G1H4(260),G0H4(221),4)
  call HG1shiftOLR(G1H4(692),8,4)
  call Hloop_AV_Q(ntryL,G1H4(1225),ex2(:),G1H2(354),m3h2x2(:,1323),heltab2x4(:,:,1323))
  call Hloop_A_Q(ntryL,G1H2(354),23,nMB,G2H2(891),n2h2(669))
  call Hloop_AV_Q(ntryL,G1H4(1230),ex2(:),G1H2(28),m3h2x2(:,1324),heltab2x4(:,:,1324))
  call Hloop_A_Q(ntryL,G1H2(28),23,nMB,G2H2(892),n2h2(670))
  call Hotf_4pt_reduction(G2H4(490),RedSet_4(36),mass4set(:,3),  & 
G1H4(662),G1H4(661),G1H4(646),G1H4(708),G1H4(276),G0H4(222),4)
  call HG1shiftOLR(G1H4(661),8,4)
  call Hloop_QV_A(ntryL,G1H4(1241),ex2(:),G1H2(358),m3h2x2(:,1325),heltab2x4(:,:,1325))
  call Hloop_Q_A(ntryL,G1H2(358),23,nMB,G2H2(893),n2h2(671))
  call Hloop_QV_A(ntryL,G1H4(1246),ex2(:),G1H2(363),m3h2x2(:,1326),heltab2x4(:,:,1326))
  call Hloop_Q_A(ntryL,G1H2(363),23,nMB,G2H2(894),n2h2(672))
  call Hotf_4pt_reduction(G2H4(491),RedSet_4(36),mass4set(:,1),  & 
G1H4(868),G1H4(292),G1H4(884),G1H4(308),G1H4(900),G0H4(223),4)
  call HG1shiftOLR(G1H4(292),8,4)
  call Hloop_DV_C(ntryL,G1H4(1257),21,ex2(:),G2H2(895),m3h2x2(:,1327),heltab2x4(:,:,1327))
  call Hloop_DV_C(ntryL,G1H4(1262),21,ex2(:),G2H2(896),m3h2x2(:,1328),heltab2x4(:,:,1328))
  call Hotf_4pt_reduction(G2H4(494),RedSet_4(36),mass4set(:,1),  & 
G1H4(324),G1H4(916),G1H4(340),G1H4(932),G1H4(356),G0H4(224),4)
  call HG1shiftOLR(G1H4(916),8,4)
  call Hloop_CV_D(ntryL,G1H4(1273),21,ex2(:),2,G2H2(897),m3h2x2(:,1329),heltab2x4(:,:,1329))
  call Hloop_CV_D(ntryL,G1H4(1278),21,ex2(:),2,G2H2(898),m3h2x2(:,1330),heltab2x4(:,:,1330))
  call Hotf_4pt_reduction(G2H4(495),RedSet_4(36),mass4set(:,1),  & 
G1H4(948),G1H4(372),G1H4(964),G1H4(388),G1H4(980),G0H4(225),4)
  call HG1shiftOLR(G1H4(372),8,4)
  call Hloop_UV_W(ntryL,G1H4(1289),21,ex2(:),2,G2H2(899),m3h2x2(:,1331),heltab2x4(:,:,1331))
  call Hloop_UV_W(ntryL,G1H4(1294),21,ex2(:),2,G2H2(900),m3h2x2(:,1332),heltab2x4(:,:,1332))
  call Hotf_4pt_reduction(G2H4(496),RedSet_4(38),mass4set(:,1),  & 
G1H4(404),G1H4(597),G1H4(582),G1H4(581),G1H4(996),G0H4(226),4)
  call HG1shiftOLR(G1H4(597),2,4)
  call Hloop_AV_Q(ntryL,G1H4(1305),ex4(:),G1H2(364),m3h2x2(:,1333),heltab2x4(:,:,1333))
  call Hloop_A_Q(ntryL,G1H2(364),29,0,G2H2(901),n2h2(673))
  call Hloop_AV_Q(ntryL,G1H4(1306),ex4(:),G1H2(30),m3h2x2(:,1334),heltab2x4(:,:,1334))
  call Hloop_A_Q(ntryL,G1H2(30),29,0,G2H2(902),n2h2(674))
  call Hloop_AV_Q(ntryL,G1H4(1310),ex4(:),G1H2(368),m3h2x2(:,1335),heltab2x4(:,:,1335))
  call Hloop_A_Q(ntryL,G1H2(368),29,0,G2H2(903),n2h2(675))
  call Hloop_AV_Q(ntryL,G1H4(1311),ex4(:),G1H2(373),m3h2x2(:,1336),heltab2x4(:,:,1336))
  call Hloop_A_Q(ntryL,G1H2(373),29,0,G2H2(904),n2h2(676))
  call Hotf_4pt_reduction(G2H4(499),RedSet_4(38),mass4set(:,2),  & 
G1H4(420),G1H4(291),G1H4(756),G1H4(436),G1H4(307),G0H4(227),4)
  call HG1shiftOLR(G1H4(291),2,4)
  call Hloop_AV_Q(ntryL,G1H4(1321),ex4(:),G1H2(374),m3h2x2(:,1337),heltab2x4(:,:,1337))
  call Hloop_A_Q(ntryL,G1H2(374),29,nMT,G2H2(905),n2h2(677))
  call Hloop_AV_Q(ntryL,G1H4(1322),ex4(:),G1H2(32),m3h2x2(:,1338),heltab2x4(:,:,1338))
  call Hloop_A_Q(ntryL,G1H2(32),29,nMT,G2H2(906),n2h2(678))
  call Hloop_AV_Q(ntryL,G1H4(1326),ex4(:),G1H2(378),m3h2x2(:,1339),heltab2x4(:,:,1339))
  call Hloop_A_Q(ntryL,G1H2(378),29,nMT,G2H2(907),n2h2(679))
  call Hloop_AV_Q(ntryL,G1H4(1327),ex4(:),G1H2(383),m3h2x2(:,1340),heltab2x4(:,:,1340))
  call Hloop_A_Q(ntryL,G1H2(383),29,nMT,G2H2(908),n2h2(680))
  call Hotf_4pt_reduction(G2H4(500),RedSet_4(38),mass4set(:,1),  & 
G1H4(772),G1H4(452),G1H4(323),G1H4(724),G1H4(468),G0H4(228),4)
  call HG1shiftOLR(G1H4(452),2,4)
  call Hloop_QV_A(ntryL,G1H4(1337),ex4(:),G1H2(384),m3h2x2(:,1341),heltab2x4(:,:,1341))
  call Hloop_Q_A(ntryL,G1H2(384),29,0,G2H2(909),n2h2(681))
  call Hloop_QV_A(ntryL,G1H4(1338),ex4(:),G1H2(34),m3h2x2(:,1342),heltab2x4(:,:,1342))
  call Hloop_Q_A(ntryL,G1H2(34),29,0,G2H2(910),n2h2(682))
  call Hloop_QV_A(ntryL,G1H4(1342),ex4(:),G1H2(388),m3h2x2(:,1343),heltab2x4(:,:,1343))
  call Hloop_Q_A(ntryL,G1H2(388),29,0,G2H2(911),n2h2(683))
  call Hloop_QV_A(ntryL,G1H4(1343),ex4(:),G1H2(393),m3h2x2(:,1344),heltab2x4(:,:,1344))
  call Hloop_Q_A(ntryL,G1H2(393),29,0,G2H2(912),n2h2(684))
  call Hotf_4pt_reduction(G2H4(501),RedSet_4(38),mass4set(:,2),  & 
G1H4(339),G1H4(740),G1H4(484),G1H4(355),G1H4(804),G0H4(229),4)
  call HG1shiftOLR(G1H4(740),2,4)
  call Hloop_QV_A(ntryL,G1H4(1353),ex4(:),G1H2(394),m3h2x2(:,1345),heltab2x4(:,:,1345))
  call Hloop_Q_A(ntryL,G1H2(394),29,nMT,G2H2(913),n2h2(685))
  call Hloop_QV_A(ntryL,G1H4(1354),ex4(:),G1H2(36),m3h2x2(:,1346),heltab2x4(:,:,1346))
  call Hloop_Q_A(ntryL,G1H2(36),29,nMT,G2H2(914),n2h2(686))
  call Hloop_QV_A(ntryL,G1H4(1358),ex4(:),G1H2(398),m3h2x2(:,1347),heltab2x4(:,:,1347))
  call Hloop_Q_A(ntryL,G1H2(398),29,nMT,G2H2(915),n2h2(687))
  call Hloop_QV_A(ntryL,G1H4(1359),ex4(:),G1H2(403),m3h2x2(:,1348),heltab2x4(:,:,1348))
  call Hloop_Q_A(ntryL,G1H2(403),29,nMT,G2H2(916),n2h2(688))
  call Hotf_4pt_reduction(G2H4(504),RedSet_4(38),mass4set(:,3),  & 
G1H4(500),G1H4(371),G1H4(788),G1H4(516),G1H4(387),G0H4(230),4)
  call HG1shiftOLR(G1H4(371),2,4)
  call Hloop_AV_Q(ntryL,G1H4(1369),ex4(:),G1H2(404),m3h2x2(:,1349),heltab2x4(:,:,1349))
  call Hloop_A_Q(ntryL,G1H2(404),29,nMB,G2H2(917),n2h2(689))
  call Hloop_AV_Q(ntryL,G1H4(1370),ex4(:),G1H2(38),m3h2x2(:,1350),heltab2x4(:,:,1350))
  call Hloop_A_Q(ntryL,G1H2(38),29,nMB,G2H2(918),n2h2(690))
  call Hloop_AV_Q(ntryL,G1H4(1374),ex4(:),G1H2(408),m3h2x2(:,1351),heltab2x4(:,:,1351))
  call Hloop_A_Q(ntryL,G1H2(408),29,nMB,G2H2(919),n2h2(691))
  call Hloop_AV_Q(ntryL,G1H4(1375),ex4(:),G1H2(413),m3h2x2(:,1352),heltab2x4(:,:,1352))
  call Hloop_A_Q(ntryL,G1H2(413),29,nMB,G2H2(920),n2h2(692))
  call Hotf_4pt_reduction(G2H4(505),RedSet_4(38),mass4set(:,3),  & 
G1H4(836),G1H4(532),G1H4(403),G1H4(820),G1H4(548),G0H4(231),4)
  call HG1shiftOLR(G1H4(532),2,4)
  call Hloop_QV_A(ntryL,G1H4(1385),ex4(:),G1H2(414),m3h2x2(:,1353),heltab2x4(:,:,1353))
  call Hloop_Q_A(ntryL,G1H2(414),29,nMB,G2H2(921),n2h2(693))
  call Hloop_QV_A(ntryL,G1H4(1386),ex4(:),G1H2(40),m3h2x2(:,1354),heltab2x4(:,:,1354))
  call Hloop_Q_A(ntryL,G1H2(40),29,nMB,G2H2(922),n2h2(694))
  call Hloop_QV_A(ntryL,G1H4(1390),ex4(:),G1H2(418),m3h2x2(:,1355),heltab2x4(:,:,1355))
  call Hloop_Q_A(ntryL,G1H2(418),29,nMB,G2H2(923),n2h2(695))
  call Hloop_QV_A(ntryL,G1H4(1391),ex4(:),G1H2(423),m3h2x2(:,1356),heltab2x4(:,:,1356))
  call Hloop_Q_A(ntryL,G1H2(423),29,nMB,G2H2(924),n2h2(696))
  call Hotf_4pt_reduction(G2H4(506),RedSet_4(38),mass4set(:,1),  & 
G1H4(419),G1H4(645),G1H4(630),G1H4(629),G1H4(852),G0H4(232),4)
  call HG1shiftOLR(G1H4(645),2,4)
  call Hloop_DV_C(ntryL,G1H4(1401),21,ex4(:),G2H2(925),m3h2x2(:,1357),heltab2x4(:,:,1357))
  call Hloop_DV_C(ntryL,G1H4(1402),21,ex4(:),G2H2(926),m3h2x2(:,1358),heltab2x4(:,:,1358))
  call Hloop_DV_C(ntryL,G1H4(1406),21,ex4(:),G2H2(927),m3h2x2(:,1359),heltab2x4(:,:,1359))
  call Hloop_DV_C(ntryL,G1H4(1407),21,ex4(:),G2H2(928),m3h2x2(:,1360),heltab2x4(:,:,1360))
  call Hotf_4pt_reduction(G2H4(509),RedSet_4(38),mass4set(:,1),  & 
G1H4(564),G1H4(3),G1H4(19),G1H4(35),G1H4(51),G0H4(233),4)
  call HG1shiftOLR(G1H4(3),2,4)
  call Hloop_CV_D(ntryL,G1H4(1417),21,ex4(:),8,G2H2(929),m3h2x2(:,1361),heltab2x4(:,:,1361))
  call Hloop_CV_D(ntryL,G1H4(1418),21,ex4(:),8,G2H2(930),m3h2x2(:,1362),heltab2x4(:,:,1362))
  call Hloop_CV_D(ntryL,G1H4(1422),21,ex4(:),8,G2H2(931),m3h2x2(:,1363),heltab2x4(:,:,1363))
  call Hloop_CV_D(ntryL,G1H4(1423),21,ex4(:),8,G2H2(932),m3h2x2(:,1364),heltab2x4(:,:,1364))
  call Hotf_4pt_reduction(G2H4(510),RedSet_4(38),mass4set(:,1),  & 
G1H4(67),G1H4(83),G1H4(99),G1H4(115),G1H4(131),G0H4(234),4)
  call HG1shiftOLR(G1H4(83),2,4)
  call Hloop_UV_W(ntryL,G1H4(1433),21,ex4(:),8,G2H2(933),m3h2x2(:,1365),heltab2x4(:,:,1365))
  call Hloop_UV_W(ntryL,G1H4(1434),21,ex4(:),8,G2H2(934),m3h2x2(:,1366),heltab2x4(:,:,1366))
  call Hloop_UV_W(ntryL,G1H4(1438),21,ex4(:),8,G2H2(935),m3h2x2(:,1367),heltab2x4(:,:,1367))
  call Hloop_UV_W(ntryL,G1H4(1439),21,ex4(:),8,G2H2(936),m3h2x2(:,1368),heltab2x4(:,:,1368))
  call Hotf_4pt_reduction(G2H4(511),RedSet_4(41),mass4set(:,1),  & 
G1H4(1012),G1H4(1028),G1H4(1044),G1H4(1060),G1H4(1076),G0H4(235),4)
  call HG1shiftOLR(G1H4(1028),4,4)
  call Hloop_AV_Q(ntryL,G1H4(1449),ex2(:),G1H2(424),m3h2x2(:,1369),heltab2x4(:,:,1369))
  call Hloop_A_Q(ntryL,G1H2(424),27,0,G2H2(937),n2h2(697))
  call Hloop_AV_Q(ntryL,G1H4(1450),ex2(:),G1H2(42),m3h2x2(:,1370),heltab2x4(:,:,1370))
  call Hloop_A_Q(ntryL,G1H2(42),27,0,G2H2(938),n2h2(698))
  call Hloop_AV_Q(ntryL,G1H4(1454),ex2(:),G1H2(428),m3h2x2(:,1371),heltab2x4(:,:,1371))
  call Hloop_A_Q(ntryL,G1H2(428),27,0,G2H2(939),n2h2(699))
  call Hloop_AV_Q(ntryL,G1H4(1455),ex2(:),G1H2(433),m3h2x2(:,1372),heltab2x4(:,:,1372))
  call Hloop_A_Q(ntryL,G1H2(433),27,0,G2H2(940),n2h2(700))
  call Hotf_4pt_reduction(G2H4(514),RedSet_4(41),mass4set(:,2),  & 
G1H4(1092),G1H4(1108),G1H4(1124),G1H4(1140),G1H4(179),G0H4(236),4)
  call HG1shiftOLR(G1H4(1108),4,4)
  call Hloop_AV_Q(ntryL,G1H4(1465),ex2(:),G1H2(434),m3h2x2(:,1373),heltab2x4(:,:,1373))
  call Hloop_A_Q(ntryL,G1H2(434),27,nMT,G2H2(941),n2h2(701))
  call Hloop_AV_Q(ntryL,G1H4(1466),ex2(:),G1H2(44),m3h2x2(:,1374),heltab2x4(:,:,1374))
  call Hloop_A_Q(ntryL,G1H2(44),27,nMT,G2H2(942),n2h2(702))
  call Hloop_AV_Q(ntryL,G1H4(1470),ex2(:),G1H2(438),m3h2x2(:,1375),heltab2x4(:,:,1375))
  call Hloop_A_Q(ntryL,G1H2(438),27,nMT,G2H2(943),n2h2(703))
  call Hloop_AV_Q(ntryL,G1H4(1471),ex2(:),G1H2(443),m3h2x2(:,1376),heltab2x4(:,:,1376))
  call Hloop_A_Q(ntryL,G1H2(443),27,nMT,G2H2(944),n2h2(704))
  call Hotf_4pt_reduction(G2H4(515),RedSet_4(41),mass4set(:,1),  & 
G1H4(1300),G1H4(195),G1H4(1316),G1H4(147),G1H4(1332),G0H4(237),4)
  call HG1shiftOLR(G1H4(195),4,4)
  call Hloop_QV_A(ntryL,G1H4(1481),ex2(:),G1H2(444),m3h2x2(:,1377),heltab2x4(:,:,1377))
  call Hloop_Q_A(ntryL,G1H2(444),27,0,G2H2(945),n2h2(705))
  call Hloop_QV_A(ntryL,G1H4(1482),ex2(:),G1H2(46),m3h2x2(:,1378),heltab2x4(:,:,1378))
  call Hloop_Q_A(ntryL,G1H2(46),27,0,G2H2(946),n2h2(706))
  call Hloop_QV_A(ntryL,G1H4(1486),ex2(:),G1H2(448),m3h2x2(:,1379),heltab2x4(:,:,1379))
  call Hloop_Q_A(ntryL,G1H2(448),27,0,G2H2(947),n2h2(707))
  call Hloop_QV_A(ntryL,G1H4(1487),ex2(:),G1H2(453),m3h2x2(:,1380),heltab2x4(:,:,1380))
  call Hloop_Q_A(ntryL,G1H2(453),27,0,G2H2(948),n2h2(708))
  call Hotf_4pt_reduction(G2H4(516),RedSet_4(41),mass4set(:,2),  & 
G1H4(163),G1H4(1348),G1H4(227),G1H4(1364),G1H4(211),G0H4(238),4)
  call HG1shiftOLR(G1H4(1348),4,4)
  call Hloop_QV_A(ntryL,G1H4(1497),ex2(:),G1H2(454),m3h2x2(:,1381),heltab2x4(:,:,1381))
  call Hloop_Q_A(ntryL,G1H2(454),27,nMT,G2H2(949),n2h2(709))
  call Hloop_QV_A(ntryL,G1H4(1498),ex2(:),G1H2(48),m3h2x2(:,1382),heltab2x4(:,:,1382))
  call Hloop_Q_A(ntryL,G1H2(48),27,nMT,G2H2(950),n2h2(710))
  call Hloop_QV_A(ntryL,G1H4(1502),ex2(:),G1H2(458),m3h2x2(:,1383),heltab2x4(:,:,1383))
  call Hloop_Q_A(ntryL,G1H2(458),27,nMT,G2H2(951),n2h2(711))
  call Hloop_QV_A(ntryL,G1H4(1503),ex2(:),G1H2(463),m3h2x2(:,1384),heltab2x4(:,:,1384))
  call Hloop_Q_A(ntryL,G1H2(463),27,nMT,G2H2(952),n2h2(712))
  call Hotf_4pt_reduction(G2H4(519),RedSet_4(41),mass4set(:,3),  & 
G1H4(1380),G1H4(259),G1H4(1396),G1H4(243),G1H4(1412),G0H4(239),4)
  call HG1shiftOLR(G1H4(259),4,4)
  call Hloop_AV_Q(ntryL,G1H4(1513),ex2(:),G1H2(464),m3h2x2(:,1385),heltab2x4(:,:,1385))
  call Hloop_A_Q(ntryL,G1H2(464),27,nMB,G2H2(953),n2h2(713))
  call Hloop_AV_Q(ntryL,G1H4(1514),ex2(:),G1H2(50),m3h2x2(:,1386),heltab2x4(:,:,1386))
  call Hloop_A_Q(ntryL,G1H2(50),27,nMB,G2H2(954),n2h2(714))
  call Hloop_AV_Q(ntryL,G1H4(1518),ex2(:),G1H2(468),m3h2x2(:,1387),heltab2x4(:,:,1387))
  call Hloop_A_Q(ntryL,G1H2(468),27,nMB,G2H2(955),n2h2(715))
  call Hloop_AV_Q(ntryL,G1H4(1519),ex2(:),G1H2(473),m3h2x2(:,1388),heltab2x4(:,:,1388))
  call Hloop_A_Q(ntryL,G1H2(473),27,nMB,G2H2(956),n2h2(716))
  call Hotf_4pt_reduction(G2H4(520),RedSet_4(41),mass4set(:,3),  & 
G1H4(275),G1H4(1428),G1H4(1444),G1H4(1460),G1H4(1476),G0H4(240),4)
  call HG1shiftOLR(G1H4(1428),4,4)
  call Hloop_QV_A(ntryL,G1H4(1529),ex2(:),G1H2(474),m3h2x2(:,1389),heltab2x4(:,:,1389))
  call Hloop_Q_A(ntryL,G1H2(474),27,nMB,G2H2(957),n2h2(717))
  call Hloop_QV_A(ntryL,G1H4(1530),ex2(:),G1H2(52),m3h2x2(:,1390),heltab2x4(:,:,1390))
  call Hloop_Q_A(ntryL,G1H2(52),27,nMB,G2H2(958),n2h2(718))
  call Hloop_QV_A(ntryL,G1H4(1534),ex2(:),G1H2(478),m3h2x2(:,1391),heltab2x4(:,:,1391))
  call Hloop_Q_A(ntryL,G1H2(478),27,nMB,G2H2(959),n2h2(719))
  call Hloop_QV_A(ntryL,G1H4(1535),ex2(:),G1H2(483),m3h2x2(:,1392),heltab2x4(:,:,1392))
  call Hloop_Q_A(ntryL,G1H2(483),27,nMB,G2H2(960),n2h2(720))
  call Hotf_4pt_reduction(G2H4(521),RedSet_4(41),mass4set(:,1),  & 
G1H4(1492),G1H4(1508),G1H4(1524),G1H4(1540),G1H4(1556),G0H4(241),4)
  call HG1shiftOLR(G1H4(1508),4,4)
  call Hloop_DV_C(ntryL,G1H4(1545),25,ex2(:),G2H2(961),m3h2x2(:,1393),heltab2x4(:,:,1393))
  call Hloop_DV_C(ntryL,G1H4(1546),25,ex2(:),G2H2(962),m3h2x2(:,1394),heltab2x4(:,:,1394))
  call Hloop_DV_C(ntryL,G1H4(1550),25,ex2(:),G2H2(963),m3h2x2(:,1395),heltab2x4(:,:,1395))
  call Hloop_DV_C(ntryL,G1H4(1551),25,ex2(:),G2H2(964),m3h2x2(:,1396),heltab2x4(:,:,1396))
  call Hotf_4pt_reduction(G2H4(524),RedSet_4(41),mass4set(:,1),  & 
G1H4(1572),G1H4(467),G1H4(1588),G1H4(483),G1H4(1604),G0H4(242),4)
  call HG1shiftOLR(G1H4(467),4,4)
  call Hloop_CV_D(ntryL,G1H4(1561),25,ex2(:),2,G2H2(965),m3h2x2(:,1397),heltab2x4(:,:,1397))
  call Hloop_CV_D(ntryL,G1H4(1562),25,ex2(:),2,G2H2(966),m3h2x2(:,1398),heltab2x4(:,:,1398))
  call Hloop_CV_D(ntryL,G1H4(1566),25,ex2(:),2,G2H2(967),m3h2x2(:,1399),heltab2x4(:,:,1399))
  call Hloop_CV_D(ntryL,G1H4(1567),25,ex2(:),2,G2H2(968),m3h2x2(:,1400),heltab2x4(:,:,1400))


! end do

end subroutine vamp_1

end module ol_vamp_1_ppjjj_ggggg_1_/**/REALKIND
