
module ol_colourmatrix_ppjjj_gggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(2760,120)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(   1,:) = [   7282,   -908,   -908,    100,    100,   1144,   -908,    136,    100,    100,    -26,   -152,    100,    -26, &
                  1144,   -152,   1108,    856,    100,   -152,   -152,    856,    856,   -368,   -908,    136,    136,   -152, &
                  -152,    -80,    100,   -152,    100,   -908,    -26,    136,    -26,     10,   -152,    136,    -26,   -152, &
                   -26,   -116,     10,   -152,   -116,    -80,    100,   -152,    -26,    -26,     10,   -116,   1144,    -80, &
                  -152,    136,   -116,    208,   1108,    -26,    856,   -152,    100,   1144,    -26,     10,   -116,   -116, &
                  -152,    -80,    100,    -26,   -152,     10,    -26,   -116,   -152,   -116,    856,   -152,     10,   -116, &
                   856,   -116,   -368,    -80,   -152,    -80,    100,   -152,   -152,    856,    856,   -368,   -908,    136, &
                   136,   -152,   -152,    -80,    136,    208,   -152,   1144,   -116,    -80,   -152,   -116,    -80,    -80, &
                   856,   -368,   1144,    -80,    -80,   -368,   -368,    352]
  K1(   2,:) = [   -908,   7282,    100,   1144,   -908,    100,    136,   -908,    -26,   -152,    100,    100,    100,   -152, &
                  -152,    856,    856,   -368,    100,    -26,   1144,   -152,   1108,    856,    136,   -908,   -152,    -80, &
                   136,   -152,   -152,    100,    -26,    136,    100,   -908,    -26,   -116,     10,   -152,   -116,    -80, &
                   -26,     10,   -152,    136,    -26,   -152,   -152,    100,     10,   -116,    -26,    -26,    -80,   1144, &
                  -116,    208,   -152,    136,    -26,     10,   -116,   -116,   -152,    -80,   1108,    -26,    856,   -152, &
                   100,   1144,   -908,    136,    136,   -152,   -152,    -80,    136,    208,   -152,   1144,   -116,    -80, &
                  -152,   -116,    -80,    -80,    856,   -368,   1144,    -80,    -80,   -368,   -368,    352,    100,    -26, &
                  -152,     10,    -26,   -116,   -152,   -116,    856,   -152,     10,   -116,    856,   -116,   -368,    -80, &
                  -152,    -80,    100,   -152,   -152,    856,    856,   -368]
  K1(   3,:) = [   -908,    100,   7282,   -908,   1144,    100,    100,    -26,   1144,   -152,   1108,    856,   -908,    136, &
                   100,    100,    -26,   -152,   -152,    100,    856,   -368,   -152,    856,    136,   -152,   -908,    136, &
                   -80,   -152,    -26,     10,   -152,    136,    -26,   -152,    100,   -152,    100,   -908,    -26,    136, &
                  -116,    -26,   -116,    -80,     10,   -152,    100,    -26,   -152,     10,    -26,   -116,   -152,   -116, &
                   856,   -152,     10,   -116,    856,   -116,   -368,    -80,   -152,    -80,    100,   -152,   -152,    856, &
                   856,   -368,    100,   -152,    -26,    -26,     10,   -116,   1144,    -80,   -152,    136,   -116,    208, &
                  1108,    -26,    856,   -152,    100,   1144,    -26,     10,   -116,   -116,   -152,    -80,    136,   -908, &
                  -152,    -80,    136,   -152,    208,    136,   -116,    -80,   -152,   1144,   1144,    -80,    -80,   -368, &
                  -368,    352,   -152,   -116,    -80,    -80,    856,   -368]
  K1(   4,:) = [    100,   1144,   -908,   7282,    100,   -908,    100,   -152,   -152,    856,    856,   -368,    136,   -908, &
                   -26,   -152,    100,    100,    -26,    100,   1108,    856,   1144,   -152,   -152,    -80,    136,   -908, &
                  -152,    136,    -26,   -116,     10,   -152,   -116,    -80,   -152,    100,    -26,    136,    100,   -908, &
                    10,    -26,    -26,   -152,   -152,    136,   -908,    136,    136,   -152,   -152,    -80,    136,    208, &
                  -152,   1144,   -116,    -80,   -152,   -116,    -80,    -80,    856,   -368,   1144,    -80,    -80,   -368, &
                  -368,    352,   -152,    100,     10,   -116,    -26,    -26,    -80,   1144,   -116,    208,   -152,    136, &
                   -26,     10,   -116,   -116,   -152,    -80,   1108,    -26,    856,   -152,    100,   1144,    -26,    100, &
                   -26,   -116,   -152,     10,   -116,   -152,     10,   -116,    856,   -152,    100,   -152,   -152,    856, &
                   856,   -368,    856,   -116,   -368,    -80,   -152,    -80]
  K1(   5,:) = [    100,   -908,   1144,    100,   7282,   -908,    -26,    100,   1108,    856,   1144,   -152,   -152,    100, &
                   856,   -368,   -152,    856,   -908,    136,    100,    100,    -26,   -152,   -152,    136,    -80,   -152, &
                  -908,    136,     10,    -26,    -26,   -152,   -152,    136,   -116,    -26,   -116,    -80,     10,   -152, &
                   100,   -152,    100,   -908,    -26,    136,    -26,    100,    -26,   -116,   -152,     10,   -116,   -152, &
                    10,   -116,    856,   -152,    100,   -152,   -152,    856,    856,   -368,    856,   -116,   -368,    -80, &
                  -152,    -80,    136,   -908,   -152,    -80,    136,   -152,    208,    136,   -116,    -80,   -152,   1144, &
                  1144,    -80,    -80,   -368,   -368,    352,   -152,   -116,    -80,    -80,    856,   -368,    100,   -152, &
                   -26,    -26,     10,   -116,   1144,    -80,   -152,    136,   -116,    208,   1108,    -26,    856,   -152, &
                   100,   1144,    -26,     10,   -116,   -116,   -152,    -80]
  K1(   6,:) = [   1144,    100,    100,   -908,   -908,   7282,   -152,    100,    856,   -368,   -152,    856,    -26,    100, &
                  1108,    856,   1144,   -152,    136,   -908,    -26,   -152,    100,    100,    -80,   -152,   -152,    136, &
                   136,   -908,   -116,    -26,   -116,    -80,     10,   -152,     10,    -26,    -26,   -152,   -152,    136, &
                  -152,    100,    -26,    136,    100,   -908,    136,   -908,   -152,    -80,    136,   -152,    208,    136, &
                  -116,    -80,   -152,   1144,   1144,    -80,    -80,   -368,   -368,    352,   -152,   -116,    -80,    -80, &
                   856,   -368,    -26,    100,    -26,   -116,   -152,     10,   -116,   -152,     10,   -116,    856,   -152, &
                   100,   -152,   -152,    856,    856,   -368,    856,   -116,   -368,    -80,   -152,    -80,   -152,    100, &
                    10,   -116,    -26,    -26,    -80,   1144,   -116,    208,   -152,    136,    -26,     10,   -116,   -116, &
                  -152,    -80,   1108,    -26,    856,   -152,    100,   1144]
  K1(   7,:) = [   -908,    136,    100,    100,    -26,   -152,   7282,   -908,   -908,    100,    100,   1144,   1144,   -152, &
                   100,    -26,    856,   1108,   -152,    856,    100,   -152,   -368,    856,    100,   -152,    -26,    -26, &
                    10,   -116,   1144,    -80,   -152,    136,   -116,    208,   1108,    -26,    856,   -152,    100,   1144, &
                   -26,     10,   -116,   -116,   -152,    -80,   -908,    136,    136,   -152,   -152,    -80,    100,   -152, &
                   100,   -908,    -26,    136,    -26,     10,   -152,    136,    -26,   -152,    -26,   -116,     10,   -152, &
                  -116,    -80,   -152,     10,    100,    -26,   -116,    -26,    856,   -116,   -368,    -80,   -152,    -80, &
                  -152,   -116,    856,   -152,     10,   -116,   -152,    100,    856,   -368,   -152,    856,    136,   -152, &
                  -908,    136,    -80,   -152,   -152,   -116,    -80,    -80,    856,   -368,    136,    208,   -152,   1144, &
                  -116,    -80,    -80,   1144,   -368,    352,    -80,   -368]
  K1(   8,:) = [    136,   -908,    -26,   -152,    100,    100,   -908,   7282,    100,   1144,   -908,    100,   -152,    856, &
                   100,   -152,   -368,    856,   1144,   -152,    100,    -26,    856,   1108,   -152,    100,     10,   -116, &
                   -26,    -26,    -80,   1144,   -116,    208,   -152,    136,    -26,     10,   -116,   -116,   -152,    -80, &
                  1108,    -26,    856,   -152,    100,   1144,    136,   -908,   -152,    -80,    136,   -152,   -152,    100, &
                   -26,    136,    100,   -908,    -26,   -116,     10,   -152,   -116,    -80,    -26,     10,   -152,    136, &
                   -26,   -152,    136,   -152,   -908,    136,    -80,   -152,   -152,   -116,    -80,    -80,    856,   -368, &
                   136,    208,   -152,   1144,   -116,    -80,    -80,   1144,   -368,    352,    -80,   -368,   -152,     10, &
                   100,    -26,   -116,    -26,    856,   -116,   -368,    -80,   -152,    -80,   -152,   -116,    856,   -152, &
                    10,   -116,   -152,    100,    856,   -368,   -152,    856]
  K1(   9,:) = [    100,    -26,   1144,   -152,   1108,    856,   -908,    100,   7282,   -908,   1144,    100,    100,    100, &
                  -908,    136,   -152,    -26,    856,   -368,   -152,    100,    856,   -152,    100,    -26,   -152,     10, &
                   -26,   -116,   -152,   -116,    856,   -152,     10,   -116,    856,   -116,   -368,    -80,   -152,    -80, &
                   100,   -152,   -152,    856,    856,   -368,    136,   -152,   -908,    136,    -80,   -152,    -26,     10, &
                  -152,    136,    -26,   -152,    100,   -152,    100,   -908,    -26,    136,   -116,    -26,   -116,    -80, &
                    10,   -152,    -26,    -26,    100,   -152,   -116,     10,   1108,    -26,    856,   -152,    100,   1144, &
                  1144,    -80,   -152,    136,   -116,    208,     10,    -26,   -152,    -80,   -116,   -116,   -152,    -80, &
                   136,   -908,   -152,    136,   1144,    -80,    -80,   -368,   -368,    352,    208,    136,   -116,    -80, &
                  -152,   1144,   -116,   -152,    856,   -368,    -80,    -80]
  K1(  10,:) = [    100,   -152,   -152,    856,    856,   -368,    100,   1144,   -908,   7282,    100,   -908,    -26,   -152, &
                   136,   -908,    100,    100,   1108,    856,    -26,    100,   -152,   1144,   -908,    136,    136,   -152, &
                  -152,    -80,    136,    208,   -152,   1144,   -116,    -80,   -152,   -116,    -80,    -80,    856,   -368, &
                  1144,    -80,    -80,   -368,   -368,    352,   -152,    -80,    136,   -908,   -152,    136,    -26,   -116, &
                    10,   -152,   -116,    -80,   -152,    100,    -26,    136,    100,   -908,     10,    -26,    -26,   -152, &
                  -152,    136,     10,   -116,   -152,    100,    -26,    -26,    -26,     10,   -116,   -116,   -152,    -80, &
                   -80,   1144,   -116,    208,   -152,    136,    -26,   1108,    100,   1144,    856,   -152,    -26,   -116, &
                   -26,    100,     10,   -152,    100,   -152,   -152,    856,    856,   -368,   -116,   -152,     10,   -116, &
                   856,   -152,   -116,    856,   -152,    -80,   -368,    -80]
  K1(  11,:) = [    -26,    100,   1108,    856,   1144,   -152,    100,   -908,   1144,    100,   7282,   -908,    856,   -368, &
                  -152,    100,    856,   -152,    100,    100,   -908,    136,   -152,    -26,    -26,    100,    -26,   -116, &
                  -152,     10,   -116,   -152,     10,   -116,    856,   -152,    100,   -152,   -152,    856,    856,   -368, &
                   856,   -116,   -368,    -80,   -152,    -80,   -152,    136,    -80,   -152,   -908,    136,     10,    -26, &
                   -26,   -152,   -152,    136,   -116,    -26,   -116,    -80,     10,   -152,    100,   -152,    100,   -908, &
                   -26,    136,   -152,    -80,    136,   -908,   -152,    136,   1144,    -80,    -80,   -368,   -368,    352, &
                   208,    136,   -116,    -80,   -152,   1144,   -116,   -152,    856,   -368,    -80,    -80,    -26,    -26, &
                   100,   -152,   -116,     10,   1108,    -26,    856,   -152,    100,   1144,   1144,    -80,   -152,    136, &
                  -116,    208,     10,    -26,   -152,    -80,   -116,   -116]
  K1(  12,:) = [   -152,    100,    856,   -368,   -152,    856,   1144,    100,    100,   -908,   -908,   7282,   1108,    856, &
                   -26,    100,   -152,   1144,    -26,   -152,    136,   -908,    100,    100,    136,   -908,   -152,    -80, &
                   136,   -152,    208,    136,   -116,    -80,   -152,   1144,   1144,    -80,    -80,   -368,   -368,    352, &
                  -152,   -116,    -80,    -80,    856,   -368,    -80,   -152,   -152,    136,    136,   -908,   -116,    -26, &
                  -116,    -80,     10,   -152,     10,    -26,    -26,   -152,   -152,    136,   -152,    100,    -26,    136, &
                   100,   -908,    -26,   -116,    -26,    100,     10,   -152,    100,   -152,   -152,    856,    856,   -368, &
                  -116,   -152,     10,   -116,    856,   -152,   -116,    856,   -152,    -80,   -368,    -80,     10,   -116, &
                  -152,    100,    -26,    -26,    -26,     10,   -116,   -116,   -152,    -80,    -80,   1144,   -116,    208, &
                  -152,    136,    -26,   1108,    100,   1144,    856,   -152]
  K1(  13,:) = [    100,    100,   -908,    136,   -152,    -26,   1144,   -152,    100,    -26,    856,   1108,   7282,   -908, &
                  -908,    100,    100,   1144,    856,   -152,   -368,    856,    100,   -152,    -26,    -26,    100,   -152, &
                  -116,     10,   1108,    -26,    856,   -152,    100,   1144,   1144,    -80,   -152,    136,   -116,    208, &
                    10,    -26,   -152,    -80,   -116,   -116,   -152,     10,    100,    -26,   -116,    -26,    856,   -116, &
                  -368,    -80,   -152,    -80,   -152,   -116,    856,   -152,     10,   -116,   -152,    100,    856,   -368, &
                  -152,    856,   -908,    136,    136,   -152,   -152,    -80,    100,   -152,    100,   -908,    -26,    136, &
                   -26,     10,   -152,    136,    -26,   -152,    -26,   -116,     10,   -152,   -116,    -80,   -152,    136, &
                   -80,   -152,   -908,    136,   -116,   -152,    856,   -368,    -80,    -80,    -80,   1144,   -368,    352, &
                   -80,   -368,    136,    208,   -152,   1144,   -116,    -80]
  K1(  14,:) = [    -26,   -152,    136,   -908,    100,    100,   -152,    856,    100,   -152,   -368,    856,   -908,   7282, &
                   100,   1144,   -908,    100,   -152,   1144,    856,   1108,    100,    -26,     10,   -116,   -152,    100, &
                   -26,    -26,    -26,     10,   -116,   -116,   -152,    -80,    -80,   1144,   -116,    208,   -152,    136, &
                   -26,   1108,    100,   1144,    856,   -152,    136,   -152,   -908,    136,    -80,   -152,   -152,   -116, &
                   -80,    -80,    856,   -368,    136,    208,   -152,   1144,   -116,    -80,    -80,   1144,   -368,    352, &
                   -80,   -368,    136,   -908,   -152,    -80,    136,   -152,   -152,    100,    -26,    136,    100,   -908, &
                   -26,   -116,     10,   -152,   -116,    -80,    -26,     10,   -152,    136,    -26,   -152,     10,   -152, &
                  -116,    -26,    100,    -26,   -116,    856,   -152,    -80,   -368,    -80,   -152,    100,    856,   -368, &
                  -152,    856,   -152,   -116,    856,   -152,     10,   -116]
  K1(  15,:) = [   1144,   -152,    100,    -26,    856,   1108,    100,    100,   -908,    136,   -152,    -26,   -908,    100, &
                  7282,   -908,   1144,    100,   -368,    856,    856,   -152,   -152,    100,   -152,     10,    100,    -26, &
                  -116,    -26,    856,   -116,   -368,    -80,   -152,    -80,   -152,   -116,    856,   -152,     10,   -116, &
                  -152,    100,    856,   -368,   -152,    856,    -26,    -26,    100,   -152,   -116,     10,   1108,    -26, &
                   856,   -152,    100,   1144,   1144,    -80,   -152,    136,   -116,    208,     10,    -26,   -152,    -80, &
                  -116,   -116,    136,   -152,   -908,    136,    -80,   -152,    -26,     10,   -152,    136,    -26,   -152, &
                   100,   -152,    100,   -908,    -26,    136,   -116,    -26,   -116,    -80,     10,   -152,    -80,   -152, &
                  -152,    136,    136,   -908,    -80,   1144,   -368,    352,    -80,   -368,   -116,   -152,    856,   -368, &
                   -80,    -80,    208,    136,   -116,    -80,   -152,   1144]
  K1(  16,:) = [   -152,    856,    100,   -152,   -368,    856,    -26,   -152,    136,   -908,    100,    100,    100,   1144, &
                  -908,   7282,    100,   -908,    856,   1108,   -152,   1144,    -26,    100,    136,   -152,   -908,    136, &
                   -80,   -152,   -152,   -116,    -80,    -80,    856,   -368,    136,    208,   -152,   1144,   -116,    -80, &
                   -80,   1144,   -368,    352,    -80,   -368,     10,   -116,   -152,    100,    -26,    -26,    -26,     10, &
                  -116,   -116,   -152,    -80,    -80,   1144,   -116,    208,   -152,    136,    -26,   1108,    100,   1144, &
                   856,   -152,   -152,    -80,    136,   -908,   -152,    136,    -26,   -116,     10,   -152,   -116,    -80, &
                  -152,    100,    -26,    136,    100,   -908,     10,    -26,    -26,   -152,   -152,    136,   -116,    -26, &
                    10,   -152,    -26,    100,   -152,    100,    856,   -368,   -152,    856,   -116,    856,   -152,    -80, &
                  -368,    -80,   -116,   -152,     10,   -116,    856,   -152]
  K1(  17,:) = [   1108,    856,    -26,    100,   -152,   1144,    856,   -368,   -152,    100,    856,   -152,    100,   -908, &
                  1144,    100,   7282,   -908,    100,    100,   -152,    -26,   -908,    136,    -26,   -116,    -26,    100, &
                    10,   -152,    100,   -152,   -152,    856,    856,   -368,   -116,   -152,     10,   -116,    856,   -152, &
                  -116,    856,   -152,    -80,   -368,    -80,   -152,    -80,    136,   -908,   -152,    136,   1144,    -80, &
                   -80,   -368,   -368,    352,    208,    136,   -116,    -80,   -152,   1144,   -116,   -152,    856,   -368, &
                   -80,    -80,   -152,    136,    -80,   -152,   -908,    136,     10,    -26,    -26,   -152,   -152,    136, &
                  -116,    -26,   -116,    -80,     10,   -152,    100,   -152,    100,   -908,    -26,    136,    -26,    -26, &
                  -116,     10,    100,   -152,    -26,   1108,    100,   1144,    856,   -152,     10,    -26,   -152,    -80, &
                  -116,   -116,   1144,    -80,   -152,    136,   -116,    208]
  K1(  18,:) = [    856,   -368,   -152,    100,    856,   -152,   1108,    856,    -26,    100,   -152,   1144,   1144,    100, &
                   100,   -908,   -908,   7282,   -152,    -26,    100,    100,    136,   -908,   -152,    -80,    136,   -908, &
                  -152,    136,   1144,    -80,    -80,   -368,   -368,    352,    208,    136,   -116,    -80,   -152,   1144, &
                  -116,   -152,    856,   -368,    -80,    -80,    -26,   -116,    -26,    100,     10,   -152,    100,   -152, &
                  -152,    856,    856,   -368,   -116,   -152,     10,   -116,    856,   -152,   -116,    856,   -152,    -80, &
                  -368,    -80,    -80,   -152,   -152,    136,    136,   -908,   -116,    -26,   -116,    -80,     10,   -152, &
                    10,    -26,    -26,   -152,   -152,    136,   -152,    100,    -26,    136,    100,   -908,   -116,     10, &
                   -26,    -26,   -152,    100,     10,    -26,   -152,    -80,   -116,   -116,    -26,   1108,    100,   1144, &
                   856,   -152,    -80,   1144,   -116,    208,   -152,    136]
  K1(  19,:) = [    100,    100,   -152,    -26,   -908,    136,   -152,   1144,    856,   1108,    100,    -26,    856,   -152, &
                  -368,    856,    100,   -152,   7282,   -908,   -908,    100,    100,   1144,    -26,    -26,   -116,     10, &
                   100,   -152,    -26,   1108,    100,   1144,    856,   -152,     10,    -26,   -152,    -80,   -116,   -116, &
                  1144,    -80,   -152,    136,   -116,    208,     10,   -152,   -116,    -26,    100,    -26,   -116,    856, &
                  -152,    -80,   -368,    -80,   -152,    100,    856,   -368,   -152,    856,   -152,   -116,    856,   -152, &
                    10,   -116,   -152,    136,    -80,   -152,   -908,    136,   -116,   -152,    856,   -368,    -80,    -80, &
                   -80,   1144,   -368,    352,    -80,   -368,    136,    208,   -152,   1144,   -116,    -80,   -908,    136, &
                   136,   -152,   -152,    -80,    100,   -152,    100,   -908,    -26,    136,    -26,     10,   -152,    136, &
                   -26,   -152,    -26,   -116,     10,   -152,   -116,    -80]
  K1(  20,:) = [   -152,    -26,    100,    100,    136,   -908,    856,   -152,   -368,    856,    100,   -152,   -152,   1144, &
                   856,   1108,    100,    -26,   -908,   7282,    100,   1144,   -908,    100,   -116,     10,    -26,    -26, &
                  -152,    100,     10,    -26,   -152,    -80,   -116,   -116,    -26,   1108,    100,   1144,    856,   -152, &
                   -80,   1144,   -116,    208,   -152,    136,   -152,    136,    -80,   -152,   -908,    136,   -116,   -152, &
                   856,   -368,    -80,    -80,    -80,   1144,   -368,    352,    -80,   -368,    136,    208,   -152,   1144, &
                  -116,    -80,     10,   -152,   -116,    -26,    100,    -26,   -116,    856,   -152,    -80,   -368,    -80, &
                  -152,    100,    856,   -368,   -152,    856,   -152,   -116,    856,   -152,     10,   -116,    136,   -908, &
                  -152,    -80,    136,   -152,   -152,    100,    -26,    136,    100,   -908,    -26,   -116,     10,   -152, &
                  -116,    -80,    -26,     10,   -152,    136,    -26,   -152]
  K1(  21,:) = [   -152,   1144,    856,   1108,    100,    -26,    100,    100,   -152,    -26,   -908,    136,   -368,    856, &
                   856,   -152,   -152,    100,   -908,    100,   7282,   -908,   1144,    100,     10,   -152,   -116,    -26, &
                   100,    -26,   -116,    856,   -152,    -80,   -368,    -80,   -152,    100,    856,   -368,   -152,    856, &
                  -152,   -116,    856,   -152,     10,   -116,    -26,    -26,   -116,     10,    100,   -152,    -26,   1108, &
                   100,   1144,    856,   -152,     10,    -26,   -152,    -80,   -116,   -116,   1144,    -80,   -152,    136, &
                  -116,    208,    -80,   -152,   -152,    136,    136,   -908,    -80,   1144,   -368,    352,    -80,   -368, &
                  -116,   -152,    856,   -368,    -80,    -80,    208,    136,   -116,    -80,   -152,   1144,    136,   -152, &
                  -908,    136,    -80,   -152,    -26,     10,   -152,    136,    -26,   -152,    100,   -152,    100,   -908, &
                   -26,    136,   -116,    -26,   -116,    -80,     10,   -152]
  K1(  22,:) = [    856,   -152,   -368,    856,    100,   -152,   -152,    -26,    100,    100,    136,   -908,    856,   1108, &
                  -152,   1144,    -26,    100,    100,   1144,   -908,   7282,    100,   -908,   -152,    136,    -80,   -152, &
                  -908,    136,   -116,   -152,    856,   -368,    -80,    -80,    -80,   1144,   -368,    352,    -80,   -368, &
                   136,    208,   -152,   1144,   -116,    -80,   -116,     10,    -26,    -26,   -152,    100,     10,    -26, &
                  -152,    -80,   -116,   -116,    -26,   1108,    100,   1144,    856,   -152,    -80,   1144,   -116,    208, &
                  -152,    136,   -116,    -26,     10,   -152,    -26,    100,   -152,    100,    856,   -368,   -152,    856, &
                  -116,    856,   -152,    -80,   -368,    -80,   -116,   -152,     10,   -116,    856,   -152,   -152,    -80, &
                   136,   -908,   -152,    136,    -26,   -116,     10,   -152,   -116,    -80,   -152,    100,    -26,    136, &
                   100,   -908,     10,    -26,    -26,   -152,   -152,    136]
  K1(  23,:) = [    856,   1108,   -152,   1144,    -26,    100,   -368,    856,    856,   -152,   -152,    100,    100,    100, &
                  -152,    -26,   -908,    136,    100,   -908,   1144,    100,   7282,   -908,   -116,    -26,     10,   -152, &
                   -26,    100,   -152,    100,    856,   -368,   -152,    856,   -116,    856,   -152,    -80,   -368,    -80, &
                  -116,   -152,     10,   -116,    856,   -152,    -80,   -152,   -152,    136,    136,   -908,    -80,   1144, &
                  -368,    352,    -80,   -368,   -116,   -152,    856,   -368,    -80,    -80,    208,    136,   -116,    -80, &
                  -152,   1144,    -26,    -26,   -116,     10,    100,   -152,    -26,   1108,    100,   1144,    856,   -152, &
                    10,    -26,   -152,    -80,   -116,   -116,   1144,    -80,   -152,    136,   -116,    208,   -152,    136, &
                   -80,   -152,   -908,    136,     10,    -26,    -26,   -152,   -152,    136,   -116,    -26,   -116,    -80, &
                    10,   -152,    100,   -152,    100,   -908,    -26,    136]
  K1(  24,:) = [   -368,    856,    856,   -152,   -152,    100,    856,   1108,   -152,   1144,    -26,    100,   -152,    -26, &
                   100,    100,    136,   -908,   1144,    100,    100,   -908,   -908,   7282,    -80,   -152,   -152,    136, &
                   136,   -908,    -80,   1144,   -368,    352,    -80,   -368,   -116,   -152,    856,   -368,    -80,    -80, &
                   208,    136,   -116,    -80,   -152,   1144,   -116,    -26,     10,   -152,    -26,    100,   -152,    100, &
                   856,   -368,   -152,    856,   -116,    856,   -152,    -80,   -368,    -80,   -116,   -152,     10,   -116, &
                   856,   -152,   -116,     10,    -26,    -26,   -152,    100,     10,    -26,   -152,    -80,   -116,   -116, &
                   -26,   1108,    100,   1144,    856,   -152,    -80,   1144,   -116,    208,   -152,    136,    -80,   -152, &
                  -152,    136,    136,   -908,   -116,    -26,   -116,    -80,     10,   -152,     10,    -26,    -26,   -152, &
                  -152,    136,   -152,    100,    -26,    136,    100,   -908]
  K1(  25,:) = [   -908,    136,    136,   -152,   -152,    -80,    100,   -152,    100,   -908,    -26,    136,    -26,     10, &
                  -152,    136,    -26,   -152,    -26,   -116,     10,   -152,   -116,    -80,   7282,   -908,   -908,    100, &
                   100,   1144,   -908,    136,    100,    100,    -26,   -152,    100,    -26,   1144,   -152,   1108,    856, &
                   100,   -152,   -152,    856,    856,   -368,   1144,    -80,   -152,    136,   -116,    208,    100,   -152, &
                   -26,    -26,     10,   -116,    856,   -152,   1108,    -26,   1144,    100,   -116,   -116,    -26,     10, &
                   -80,   -152,   -152,   -116,    856,   -152,     10,   -116,    100,    -26,   -152,     10,    -26,   -116, &
                  -368,    -80,    856,   -116,    -80,   -152,   -152,    856,    100,   -152,   -368,    856,    136,    208, &
                  -152,   1144,   -116,    -80,   -908,    136,    136,   -152,   -152,    -80,    -80,    -80,   -152,   -116, &
                  -368,    856,    -80,   -368,   1144,    -80,    352,   -368]
  K1(  26,:) = [    136,   -908,   -152,    -80,    136,   -152,   -152,    100,    -26,    136,    100,   -908,    -26,   -116, &
                    10,   -152,   -116,    -80,    -26,     10,   -152,    136,    -26,   -152,   -908,   7282,    100,   1144, &
                  -908,    100,    136,   -908,    -26,   -152,    100,    100,    100,   -152,   -152,    856,    856,   -368, &
                   100,    -26,   1144,   -152,   1108,    856,    -80,   1144,   -116,    208,   -152,    136,   -152,    100, &
                    10,   -116,    -26,    -26,   -116,   -116,    -26,     10,    -80,   -152,    856,   -152,   1108,    -26, &
                  1144,    100,    136,    208,   -152,   1144,   -116,    -80,   -908,    136,    136,   -152,   -152,    -80, &
                   -80,    -80,   -152,   -116,   -368,    856,    -80,   -368,   1144,    -80,    352,   -368,   -152,   -116, &
                   856,   -152,     10,   -116,    100,    -26,   -152,     10,    -26,   -116,   -368,    -80,    856,   -116, &
                   -80,   -152,   -152,    856,    100,   -152,   -368,    856]
  K1(  27,:) = [    136,   -152,   -908,    136,    -80,   -152,    -26,     10,   -152,    136,    -26,   -152,    100,   -152, &
                   100,   -908,    -26,    136,   -116,    -26,   -116,    -80,     10,   -152,   -908,    100,   7282,   -908, &
                  1144,    100,    100,    -26,   1144,   -152,   1108,    856,   -908,    136,    100,    100,    -26,   -152, &
                  -152,    100,    856,   -368,   -152,    856,   -152,   -116,    856,   -152,     10,   -116,    100,    -26, &
                  -152,     10,    -26,   -116,   -368,    -80,    856,   -116,    -80,   -152,   -152,    856,    100,   -152, &
                  -368,    856,   1144,    -80,   -152,    136,   -116,    208,    100,   -152,    -26,    -26,     10,   -116, &
                   856,   -152,   1108,    -26,   1144,    100,   -116,   -116,    -26,     10,    -80,   -152,    208,    136, &
                  -116,    -80,   -152,   1144,    136,   -908,   -152,    -80,    136,   -152,    -80,   -368,   1144,    -80, &
                   352,   -368,    -80,    -80,   -152,   -116,   -368,    856]
  K1(  28,:) = [   -152,    -80,    136,   -908,   -152,    136,    -26,   -116,     10,   -152,   -116,    -80,   -152,    100, &
                   -26,    136,    100,   -908,     10,    -26,    -26,   -152,   -152,    136,    100,   1144,   -908,   7282, &
                   100,   -908,    100,   -152,   -152,    856,    856,   -368,    136,   -908,    -26,   -152,    100,    100, &
                   -26,    100,   1108,    856,   1144,   -152,    136,    208,   -152,   1144,   -116,    -80,   -908,    136, &
                   136,   -152,   -152,    -80,    -80,    -80,   -152,   -116,   -368,    856,    -80,   -368,   1144,    -80, &
                   352,   -368,    -80,   1144,   -116,    208,   -152,    136,   -152,    100,     10,   -116,    -26,    -26, &
                  -116,   -116,    -26,     10,    -80,   -152,    856,   -152,   1108,    -26,   1144,    100,   -116,   -152, &
                    10,   -116,    856,   -152,    -26,    100,    -26,   -116,   -152,     10,   -152,    856,    100,   -152, &
                  -368,    856,   -368,    -80,    856,   -116,    -80,   -152]
  K1(  29,:) = [   -152,    136,    -80,   -152,   -908,    136,     10,    -26,    -26,   -152,   -152,    136,   -116,    -26, &
                  -116,    -80,     10,   -152,    100,   -152,    100,   -908,    -26,    136,    100,   -908,   1144,    100, &
                  7282,   -908,    -26,    100,   1108,    856,   1144,   -152,   -152,    100,    856,   -368,   -152,    856, &
                  -908,    136,    100,    100,    -26,   -152,   -116,   -152,     10,   -116,    856,   -152,    -26,    100, &
                   -26,   -116,   -152,     10,   -152,    856,    100,   -152,   -368,    856,   -368,    -80,    856,   -116, &
                   -80,   -152,    208,    136,   -116,    -80,   -152,   1144,    136,   -908,   -152,    -80,    136,   -152, &
                   -80,   -368,   1144,    -80,    352,   -368,    -80,    -80,   -152,   -116,   -368,    856,   1144,    -80, &
                  -152,    136,   -116,    208,    100,   -152,    -26,    -26,     10,   -116,    856,   -152,   1108,    -26, &
                  1144,    100,   -116,   -116,    -26,     10,    -80,   -152]
  K1(  30,:) = [    -80,   -152,   -152,    136,    136,   -908,   -116,    -26,   -116,    -80,     10,   -152,     10,    -26, &
                   -26,   -152,   -152,    136,   -152,    100,    -26,    136,    100,   -908,   1144,    100,    100,   -908, &
                  -908,   7282,   -152,    100,    856,   -368,   -152,    856,    -26,    100,   1108,    856,   1144,   -152, &
                   136,   -908,    -26,   -152,    100,    100,    208,    136,   -116,    -80,   -152,   1144,    136,   -908, &
                  -152,    -80,    136,   -152,    -80,   -368,   1144,    -80,    352,   -368,    -80,    -80,   -152,   -116, &
                  -368,    856,   -116,   -152,     10,   -116,    856,   -152,    -26,    100,    -26,   -116,   -152,     10, &
                  -152,    856,    100,   -152,   -368,    856,   -368,    -80,    856,   -116,    -80,   -152,    -80,   1144, &
                  -116,    208,   -152,    136,   -152,    100,     10,   -116,    -26,    -26,   -116,   -116,    -26,     10, &
                   -80,   -152,    856,   -152,   1108,    -26,   1144,    100]
  K1(  31,:) = [    100,   -152,    -26,    -26,     10,   -116,   1144,    -80,   -152,    136,   -116,    208,   1108,    -26, &
                   856,   -152,    100,   1144,    -26,     10,   -116,   -116,   -152,    -80,   -908,    136,    100,    100, &
                   -26,   -152,   7282,   -908,   -908,    100,    100,   1144,   1144,   -152,    100,    -26,    856,   1108, &
                  -152,    856,    100,   -152,   -368,    856,    100,   -152,    100,   -908,    -26,    136,   -908,    136, &
                   136,   -152,   -152,    -80,   -152,    136,    -26,     10,   -152,    -26,     10,   -152,    -26,   -116, &
                   -80,   -116,    856,   -116,   -368,    -80,   -152,    -80,   -152,     10,    100,    -26,   -116,    -26, &
                   856,   -152,   -152,   -116,   -116,     10,    856,   -368,   -152,    100,    856,   -152,   -152,   -116, &
                   -80,    -80,    856,   -368,    136,   -152,   -908,    136,    -80,   -152,   -152,   1144,    136,    208, &
                   -80,   -116,   -368,    352,    -80,   1144,   -368,    -80]
  K1(  32,:) = [   -152,    100,     10,   -116,    -26,    -26,    -80,   1144,   -116,    208,   -152,    136,    -26,     10, &
                  -116,   -116,   -152,    -80,   1108,    -26,    856,   -152,    100,   1144,    136,   -908,    -26,   -152, &
                   100,    100,   -908,   7282,    100,   1144,   -908,    100,   -152,    856,    100,   -152,   -368,    856, &
                  1144,   -152,    100,    -26,    856,   1108,   -152,    100,    -26,    136,    100,   -908,    136,   -908, &
                  -152,    -80,    136,   -152,     10,   -152,    -26,   -116,    -80,   -116,   -152,    136,    -26,     10, &
                  -152,    -26,   -152,   -116,    -80,    -80,    856,   -368,    136,   -152,   -908,    136,    -80,   -152, &
                  -152,   1144,    136,    208,    -80,   -116,   -368,    352,    -80,   1144,   -368,    -80,    856,   -116, &
                  -368,    -80,   -152,    -80,   -152,     10,    100,    -26,   -116,    -26,    856,   -152,   -152,   -116, &
                  -116,     10,    856,   -368,   -152,    100,    856,   -152]
  K1(  33,:) = [    100,    -26,   -152,     10,    -26,   -116,   -152,   -116,    856,   -152,     10,   -116,    856,   -116, &
                  -368,    -80,   -152,    -80,    100,   -152,   -152,    856,    856,   -368,    100,    -26,   1144,   -152, &
                  1108,    856,   -908,    100,   7282,   -908,   1144,    100,    100,    100,   -908,    136,   -152,    -26, &
                   856,   -368,   -152,    100,    856,   -152,    -26,     10,   -152,    136,    -26,   -152,    136,   -152, &
                  -908,    136,    -80,   -152,    100,   -908,    100,   -152,    136,    -26,   -116,    -80,   -116,    -26, &
                  -152,     10,   1108,    -26,    856,   -152,    100,   1144,    -26,    -26,    100,   -152,   -116,     10, &
                  -152,    136,   1144,    -80,    208,   -116,   -152,    -80,     10,    -26,   -116,   -116,   1144,    -80, &
                   -80,   -368,   -368,    352,   -152,    -80,    136,   -908,   -152,    136,   -116,    -80,    208,    136, &
                  1144,   -152,    856,   -368,   -116,   -152,    -80,    -80]
  K1(  34,:) = [   -908,    136,    136,   -152,   -152,    -80,    136,    208,   -152,   1144,   -116,    -80,   -152,   -116, &
                   -80,    -80,    856,   -368,   1144,    -80,    -80,   -368,   -368,    352,    100,   -152,   -152,    856, &
                   856,   -368,    100,   1144,   -908,   7282,    100,   -908,    -26,   -152,    136,   -908,    100,    100, &
                  1108,    856,    -26,    100,   -152,   1144,    -26,   -116,     10,   -152,   -116,    -80,   -152,    -80, &
                   136,   -908,   -152,    136,    -26,    136,   -152,    100,   -908,    100,    -26,   -152,     10,    -26, &
                   136,   -152,    -26,     10,   -116,   -116,   -152,    -80,     10,   -116,   -152,    100,    -26,    -26, &
                  -116,    208,    -80,   1144,    136,   -152,    100,   1144,    -26,   1108,   -152,    856,    100,   -152, &
                  -152,    856,    856,   -368,    -26,   -116,    -26,    100,     10,   -152,     10,   -116,   -116,   -152, &
                  -152,    856,   -152,    -80,   -116,    856,    -80,   -368]
  K1(  35,:) = [    -26,    100,    -26,   -116,   -152,     10,   -116,   -152,     10,   -116,    856,   -152,    100,   -152, &
                  -152,    856,    856,   -368,    856,   -116,   -368,    -80,   -152,    -80,    -26,    100,   1108,    856, &
                  1144,   -152,    100,   -908,   1144,    100,   7282,   -908,    856,   -368,   -152,    100,    856,   -152, &
                   100,    100,   -908,    136,   -152,    -26,     10,    -26,    -26,   -152,   -152,    136,   -152,    136, &
                   -80,   -152,   -908,    136,   -116,    -80,   -116,    -26,   -152,     10,    100,   -908,    100,   -152, &
                   136,    -26,   1144,    -80,    -80,   -368,   -368,    352,   -152,    -80,    136,   -908,   -152,    136, &
                  -116,    -80,    208,    136,   1144,   -152,    856,   -368,   -116,   -152,    -80,    -80,   1108,    -26, &
                   856,   -152,    100,   1144,    -26,    -26,    100,   -152,   -116,     10,   -152,    136,   1144,    -80, &
                   208,   -116,   -152,    -80,     10,    -26,   -116,   -116]
  K1(  36,:) = [    136,   -908,   -152,    -80,    136,   -152,    208,    136,   -116,    -80,   -152,   1144,   1144,    -80, &
                   -80,   -368,   -368,    352,   -152,   -116,    -80,    -80,    856,   -368,   -152,    100,    856,   -368, &
                  -152,    856,   1144,    100,    100,   -908,   -908,   7282,   1108,    856,    -26,    100,   -152,   1144, &
                   -26,   -152,    136,   -908,    100,    100,   -116,    -26,   -116,    -80,     10,   -152,    -80,   -152, &
                  -152,    136,    136,   -908,    -26,   -152,     10,    -26,    136,   -152,    -26,    136,   -152,    100, &
                  -908,    100,    100,   -152,   -152,    856,    856,   -368,    -26,   -116,    -26,    100,     10,   -152, &
                    10,   -116,   -116,   -152,   -152,    856,   -152,    -80,   -116,    856,    -80,   -368,    -26,     10, &
                  -116,   -116,   -152,    -80,     10,   -116,   -152,    100,    -26,    -26,   -116,    208,    -80,   1144, &
                   136,   -152,    100,   1144,    -26,   1108,   -152,    856]
  K1(  37,:) = [    -26,    -26,    100,   -152,   -116,     10,   1108,    -26,    856,   -152,    100,   1144,   1144,    -80, &
                  -152,    136,   -116,    208,     10,    -26,   -152,    -80,   -116,   -116,    100,    100,   -908,    136, &
                  -152,    -26,   1144,   -152,    100,    -26,    856,   1108,   7282,   -908,   -908,    100,    100,   1144, &
                   856,   -152,   -368,    856,    100,   -152,    856,   -116,   -368,    -80,   -152,    -80,   -152,     10, &
                   100,    -26,   -116,    -26,    856,   -152,   -152,   -116,   -116,     10,    856,   -368,   -152,    100, &
                   856,   -152,    100,   -152,    100,   -908,    -26,    136,   -908,    136,    136,   -152,   -152,    -80, &
                  -152,    136,    -26,     10,   -152,    -26,     10,   -152,    -26,   -116,    -80,   -116,   -116,   -152, &
                   856,   -368,    -80,    -80,   -152,    136,    -80,   -152,   -908,    136,   -368,    352,    -80,   1144, &
                  -368,    -80,   -152,   1144,    136,    208,    -80,   -116]
  K1(  38,:) = [     10,   -116,   -152,    100,    -26,    -26,    -26,     10,   -116,   -116,   -152,    -80,    -80,   1144, &
                  -116,    208,   -152,    136,    -26,   1108,    100,   1144,    856,   -152,    -26,   -152,    136,   -908, &
                   100,    100,   -152,    856,    100,   -152,   -368,    856,   -908,   7282,    100,   1144,   -908,    100, &
                  -152,   1144,    856,   1108,    100,    -26,   -152,   -116,    -80,    -80,    856,   -368,    136,   -152, &
                  -908,    136,    -80,   -152,   -152,   1144,    136,    208,    -80,   -116,   -368,    352,    -80,   1144, &
                  -368,    -80,   -152,    100,    -26,    136,    100,   -908,    136,   -908,   -152,    -80,    136,   -152, &
                    10,   -152,    -26,   -116,    -80,   -116,   -152,    136,    -26,     10,   -152,    -26,   -116,    856, &
                  -152,    -80,   -368,    -80,     10,   -152,   -116,    -26,    100,    -26,    856,   -368,   -152,    100, &
                   856,   -152,    856,   -152,   -152,   -116,   -116,     10]
  K1(  39,:) = [   -152,     10,    100,    -26,   -116,    -26,    856,   -116,   -368,    -80,   -152,    -80,   -152,   -116, &
                   856,   -152,     10,   -116,   -152,    100,    856,   -368,   -152,    856,   1144,   -152,    100,    -26, &
                   856,   1108,    100,    100,   -908,    136,   -152,    -26,   -908,    100,   7282,   -908,   1144,    100, &
                  -368,    856,    856,   -152,   -152,    100,   1108,    -26,    856,   -152,    100,   1144,    -26,    -26, &
                   100,   -152,   -116,     10,   -152,    136,   1144,    -80,    208,   -116,   -152,    -80,     10,    -26, &
                  -116,   -116,    -26,     10,   -152,    136,    -26,   -152,    136,   -152,   -908,    136,    -80,   -152, &
                   100,   -908,    100,   -152,    136,    -26,   -116,    -80,   -116,    -26,   -152,     10,    -80,   1144, &
                  -368,    352,    -80,   -368,    -80,   -152,   -152,    136,    136,   -908,    856,   -368,   -116,   -152, &
                   -80,    -80,   -116,    -80,    208,    136,   1144,   -152]
  K1(  40,:) = [    136,   -152,   -908,    136,    -80,   -152,   -152,   -116,    -80,    -80,    856,   -368,    136,    208, &
                  -152,   1144,   -116,    -80,    -80,   1144,   -368,    352,    -80,   -368,   -152,    856,    100,   -152, &
                  -368,    856,    -26,   -152,    136,   -908,    100,    100,    100,   1144,   -908,   7282,    100,   -908, &
                   856,   1108,   -152,   1144,    -26,    100,    -26,     10,   -116,   -116,   -152,    -80,     10,   -116, &
                  -152,    100,    -26,    -26,   -116,    208,    -80,   1144,    136,   -152,    100,   1144,    -26,   1108, &
                  -152,    856,    -26,   -116,     10,   -152,   -116,    -80,   -152,    -80,    136,   -908,   -152,    136, &
                   -26,    136,   -152,    100,   -908,    100,    -26,   -152,     10,    -26,    136,   -152,   -152,    100, &
                   856,   -368,   -152,    856,   -116,    -26,     10,   -152,    -26,    100,   -152,    -80,   -116,    856, &
                   -80,   -368,     10,   -116,   -116,   -152,   -152,    856]
  K1(  41,:) = [    -26,   -116,    -26,    100,     10,   -152,    100,   -152,   -152,    856,    856,   -368,   -116,   -152, &
                    10,   -116,    856,   -152,   -116,    856,   -152,    -80,   -368,    -80,   1108,    856,    -26,    100, &
                  -152,   1144,    856,   -368,   -152,    100,    856,   -152,    100,   -908,   1144,    100,   7282,   -908, &
                   100,    100,   -152,    -26,   -908,    136,   1144,    -80,    -80,   -368,   -368,    352,   -152,    -80, &
                   136,   -908,   -152,    136,   -116,    -80,    208,    136,   1144,   -152,    856,   -368,   -116,   -152, &
                   -80,    -80,     10,    -26,    -26,   -152,   -152,    136,   -152,    136,    -80,   -152,   -908,    136, &
                  -116,    -80,   -116,    -26,   -152,     10,    100,   -908,    100,   -152,    136,    -26,    -26,   1108, &
                   100,   1144,    856,   -152,    -26,    -26,   -116,     10,    100,   -152,   -152,    -80,     10,    -26, &
                  -116,   -116,   -152,    136,   1144,    -80,    208,   -116]
  K1(  42,:) = [   -152,    -80,    136,   -908,   -152,    136,   1144,    -80,    -80,   -368,   -368,    352,    208,    136, &
                  -116,    -80,   -152,   1144,   -116,   -152,    856,   -368,    -80,    -80,    856,   -368,   -152,    100, &
                   856,   -152,   1108,    856,    -26,    100,   -152,   1144,   1144,    100,    100,   -908,   -908,   7282, &
                  -152,    -26,    100,    100,    136,   -908,    100,   -152,   -152,    856,    856,   -368,    -26,   -116, &
                   -26,    100,     10,   -152,     10,   -116,   -116,   -152,   -152,    856,   -152,    -80,   -116,    856, &
                   -80,   -368,   -116,    -26,   -116,    -80,     10,   -152,    -80,   -152,   -152,    136,    136,   -908, &
                   -26,   -152,     10,    -26,    136,   -152,    -26,    136,   -152,    100,   -908,    100,     10,    -26, &
                  -152,    -80,   -116,   -116,   -116,     10,    -26,    -26,   -152,    100,    100,   1144,    -26,   1108, &
                  -152,    856,   -116,    208,    -80,   1144,    136,   -152]
  K1(  43,:) = [    -26,    -26,   -116,     10,    100,   -152,    -26,   1108,    100,   1144,    856,   -152,     10,    -26, &
                  -152,    -80,   -116,   -116,   1144,    -80,   -152,    136,   -116,    208,    100,    100,   -152,    -26, &
                  -908,    136,   -152,   1144,    856,   1108,    100,    -26,    856,   -152,   -368,    856,    100,   -152, &
                  7282,   -908,   -908,    100,    100,   1144,   -116,    856,   -152,    -80,   -368,    -80,     10,   -152, &
                  -116,    -26,    100,    -26,    856,   -368,   -152,    100,    856,   -152,    856,   -152,   -152,   -116, &
                  -116,     10,   -116,   -152,    856,   -368,    -80,    -80,   -152,    136,    -80,   -152,   -908,    136, &
                  -368,    352,    -80,   1144,   -368,    -80,   -152,   1144,    136,    208,    -80,   -116,    100,   -152, &
                   100,   -908,    -26,    136,   -908,    136,    136,   -152,   -152,    -80,   -152,    136,    -26,     10, &
                  -152,    -26,     10,   -152,    -26,   -116,    -80,   -116]
  K1(  44,:) = [   -116,     10,    -26,    -26,   -152,    100,     10,    -26,   -152,    -80,   -116,   -116,    -26,   1108, &
                   100,   1144,    856,   -152,    -80,   1144,   -116,    208,   -152,    136,   -152,    -26,    100,    100, &
                   136,   -908,    856,   -152,   -368,    856,    100,   -152,   -152,   1144,    856,   1108,    100,    -26, &
                  -908,   7282,    100,   1144,   -908,    100,   -116,   -152,    856,   -368,    -80,    -80,   -152,    136, &
                   -80,   -152,   -908,    136,   -368,    352,    -80,   1144,   -368,    -80,   -152,   1144,    136,    208, &
                   -80,   -116,   -116,    856,   -152,    -80,   -368,    -80,     10,   -152,   -116,    -26,    100,    -26, &
                   856,   -368,   -152,    100,    856,   -152,    856,   -152,   -152,   -116,   -116,     10,   -152,    100, &
                   -26,    136,    100,   -908,    136,   -908,   -152,    -80,    136,   -152,     10,   -152,    -26,   -116, &
                   -80,   -116,   -152,    136,    -26,     10,   -152,    -26]
  K1(  45,:) = [     10,   -152,   -116,    -26,    100,    -26,   -116,    856,   -152,    -80,   -368,    -80,   -152,    100, &
                   856,   -368,   -152,    856,   -152,   -116,    856,   -152,     10,   -116,   -152,   1144,    856,   1108, &
                   100,    -26,    100,    100,   -152,    -26,   -908,    136,   -368,    856,    856,   -152,   -152,    100, &
                  -908,    100,   7282,   -908,   1144,    100,    -26,   1108,    100,   1144,    856,   -152,    -26,    -26, &
                  -116,     10,    100,   -152,   -152,    -80,     10,    -26,   -116,   -116,   -152,    136,   1144,    -80, &
                   208,   -116,    -80,   1144,   -368,    352,    -80,   -368,    -80,   -152,   -152,    136,    136,   -908, &
                   856,   -368,   -116,   -152,    -80,    -80,   -116,    -80,    208,    136,   1144,   -152,    -26,     10, &
                  -152,    136,    -26,   -152,    136,   -152,   -908,    136,    -80,   -152,    100,   -908,    100,   -152, &
                   136,    -26,   -116,    -80,   -116,    -26,   -152,     10]
  K1(  46,:) = [   -152,    136,    -80,   -152,   -908,    136,   -116,   -152,    856,   -368,    -80,    -80,    -80,   1144, &
                  -368,    352,    -80,   -368,    136,    208,   -152,   1144,   -116,    -80,    856,   -152,   -368,    856, &
                   100,   -152,   -152,    -26,    100,    100,    136,   -908,    856,   1108,   -152,   1144,    -26,    100, &
                   100,   1144,   -908,   7282,    100,   -908,     10,    -26,   -152,    -80,   -116,   -116,   -116,     10, &
                   -26,    -26,   -152,    100,    100,   1144,    -26,   1108,   -152,    856,   -116,    208,    -80,   1144, &
                   136,   -152,   -152,    100,    856,   -368,   -152,    856,   -116,    -26,     10,   -152,    -26,    100, &
                  -152,    -80,   -116,    856,    -80,   -368,     10,   -116,   -116,   -152,   -152,    856,    -26,   -116, &
                    10,   -152,   -116,    -80,   -152,    -80,    136,   -908,   -152,    136,    -26,    136,   -152,    100, &
                  -908,    100,    -26,   -152,     10,    -26,    136,   -152]
  K1(  47,:) = [   -116,    -26,     10,   -152,    -26,    100,   -152,    100,    856,   -368,   -152,    856,   -116,    856, &
                  -152,    -80,   -368,    -80,   -116,   -152,     10,   -116,    856,   -152,    856,   1108,   -152,   1144, &
                   -26,    100,   -368,    856,    856,   -152,   -152,    100,    100,    100,   -152,    -26,   -908,    136, &
                   100,   -908,   1144,    100,   7282,   -908,    -80,   1144,   -368,    352,    -80,   -368,    -80,   -152, &
                  -152,    136,    136,   -908,    856,   -368,   -116,   -152,    -80,    -80,   -116,    -80,    208,    136, &
                  1144,   -152,    -26,   1108,    100,   1144,    856,   -152,    -26,    -26,   -116,     10,    100,   -152, &
                  -152,    -80,     10,    -26,   -116,   -116,   -152,    136,   1144,    -80,    208,   -116,     10,    -26, &
                   -26,   -152,   -152,    136,   -152,    136,    -80,   -152,   -908,    136,   -116,    -80,   -116,    -26, &
                  -152,     10,    100,   -908,    100,   -152,    136,    -26]
  K1(  48,:) = [    -80,   -152,   -152,    136,    136,   -908,    -80,   1144,   -368,    352,    -80,   -368,   -116,   -152, &
                   856,   -368,    -80,    -80,    208,    136,   -116,    -80,   -152,   1144,   -368,    856,    856,   -152, &
                  -152,    100,    856,   1108,   -152,   1144,    -26,    100,   -152,    -26,    100,    100,    136,   -908, &
                  1144,    100,    100,   -908,   -908,   7282,   -152,    100,    856,   -368,   -152,    856,   -116,    -26, &
                    10,   -152,    -26,    100,   -152,    -80,   -116,    856,    -80,   -368,     10,   -116,   -116,   -152, &
                  -152,    856,     10,    -26,   -152,    -80,   -116,   -116,   -116,     10,    -26,    -26,   -152,    100, &
                   100,   1144,    -26,   1108,   -152,    856,   -116,    208,    -80,   1144,    136,   -152,   -116,    -26, &
                  -116,    -80,     10,   -152,    -80,   -152,   -152,    136,    136,   -908,    -26,   -152,     10,    -26, &
                   136,   -152,    -26,    136,   -152,    100,   -908,    100]
  K1(  49,:) = [    100,   -152,    100,   -908,    -26,    136,   -908,    136,    136,   -152,   -152,    -80,   -152,    136, &
                   -26,     10,   -152,    -26,     10,   -152,    -26,   -116,    -80,   -116,   1144,    -80,   -152,    136, &
                  -116,    208,    100,   -152,    -26,    -26,     10,   -116,    856,   -152,   1108,    -26,   1144,    100, &
                  -116,   -116,    -26,     10,    -80,   -152,   7282,   -908,   -908,    100,    100,   1144,   -908,    136, &
                   100,    100,    -26,   -152,    100,    -26,   1144,   -152,   1108,    856,    100,   -152,   -152,    856, &
                   856,   -368,    856,   -152,   -152,   -116,   -116,     10,   -368,    -80,    856,   -116,    -80,   -152, &
                   100,    -26,   -152,     10,    -26,   -116,    856,   -152,   -368,    856,    100,   -152,   -152,   1144, &
                   136,    208,    -80,   -116,    -80,    -80,   -152,   -116,   -368,    856,   -908,    136,    136,   -152, &
                  -152,    -80,   -368,    -80,    352,   -368,   1144,    -80]
  K1(  50,:) = [   -152,    100,    -26,    136,    100,   -908,    136,   -908,   -152,    -80,    136,   -152,     10,   -152, &
                   -26,   -116,    -80,   -116,   -152,    136,    -26,     10,   -152,    -26,    -80,   1144,   -116,    208, &
                  -152,    136,   -152,    100,     10,   -116,    -26,    -26,   -116,   -116,    -26,     10,    -80,   -152, &
                   856,   -152,   1108,    -26,   1144,    100,   -908,   7282,    100,   1144,   -908,    100,    136,   -908, &
                   -26,   -152,    100,    100,    100,   -152,   -152,    856,    856,   -368,    100,    -26,   1144,   -152, &
                  1108,    856,   -152,   1144,    136,    208,    -80,   -116,    -80,    -80,   -152,   -116,   -368,    856, &
                  -908,    136,    136,   -152,   -152,    -80,   -368,    -80,    352,   -368,   1144,    -80,    856,   -152, &
                  -152,   -116,   -116,     10,   -368,    -80,    856,   -116,    -80,   -152,    100,    -26,   -152,     10, &
                   -26,   -116,    856,   -152,   -368,    856,    100,   -152]
  K1(  51,:) = [    -26,     10,   -152,    136,    -26,   -152,    136,   -152,   -908,    136,    -80,   -152,    100,   -908, &
                   100,   -152,    136,    -26,   -116,    -80,   -116,    -26,   -152,     10,   -152,   -116,    856,   -152, &
                    10,   -116,    100,    -26,   -152,     10,    -26,   -116,   -368,    -80,    856,   -116,    -80,   -152, &
                  -152,    856,    100,   -152,   -368,    856,   -908,    100,   7282,   -908,   1144,    100,    100,    -26, &
                  1144,   -152,   1108,    856,   -908,    136,    100,    100,    -26,   -152,   -152,    100,    856,   -368, &
                  -152,    856,   -152,    136,   1144,    -80,    208,   -116,    856,   -152,   1108,    -26,   1144,    100, &
                   100,   -152,    -26,    -26,     10,   -116,   -116,   -116,    -80,   -152,    -26,     10,   -116,    -80, &
                   208,    136,   1144,   -152,    -80,   -368,   1144,    -80,    352,   -368,    136,   -908,   -152,    -80, &
                   136,   -152,    -80,    -80,   -368,    856,   -152,   -116]
  K1(  52,:) = [    -26,   -116,     10,   -152,   -116,    -80,   -152,    -80,    136,   -908,   -152,    136,    -26,    136, &
                  -152,    100,   -908,    100,    -26,   -152,     10,    -26,    136,   -152,    136,    208,   -152,   1144, &
                  -116,    -80,   -908,    136,    136,   -152,   -152,    -80,    -80,    -80,   -152,   -116,   -368,    856, &
                   -80,   -368,   1144,    -80,    352,   -368,    100,   1144,   -908,   7282,    100,   -908,    100,   -152, &
                  -152,    856,    856,   -368,    136,   -908,    -26,   -152,    100,    100,    -26,    100,   1108,    856, &
                  1144,   -152,   -116,    208,    -80,   1144,    136,   -152,   -116,   -116,    -26,     10,    -80,   -152, &
                  -152,    100,     10,   -116,    -26,    -26,   -152,    856,   1144,    100,   1108,    -26,     10,   -116, &
                  -116,   -152,   -152,    856,   -152,    856,    100,   -152,   -368,    856,    -26,    100,    -26,   -116, &
                  -152,     10,    -80,   -368,    -80,   -152,    856,   -116]
  K1(  53,:) = [     10,    -26,    -26,   -152,   -152,    136,   -152,    136,    -80,   -152,   -908,    136,   -116,    -80, &
                  -116,    -26,   -152,     10,    100,   -908,    100,   -152,    136,    -26,   -116,   -152,     10,   -116, &
                   856,   -152,    -26,    100,    -26,   -116,   -152,     10,   -152,    856,    100,   -152,   -368,    856, &
                  -368,    -80,    856,   -116,    -80,   -152,    100,   -908,   1144,    100,   7282,   -908,    -26,    100, &
                  1108,    856,   1144,   -152,   -152,    100,    856,   -368,   -152,    856,   -908,    136,    100,    100, &
                   -26,   -152,   -116,    -80,    208,    136,   1144,   -152,    -80,   -368,   1144,    -80,    352,   -368, &
                   136,   -908,   -152,    -80,    136,   -152,    -80,    -80,   -368,    856,   -152,   -116,   -152,    136, &
                  1144,    -80,    208,   -116,    856,   -152,   1108,    -26,   1144,    100,    100,   -152,    -26,    -26, &
                    10,   -116,   -116,   -116,    -80,   -152,    -26,     10]
  K1(  54,:) = [   -116,    -26,   -116,    -80,     10,   -152,    -80,   -152,   -152,    136,    136,   -908,    -26,   -152, &
                    10,    -26,    136,   -152,    -26,    136,   -152,    100,   -908,    100,    208,    136,   -116,    -80, &
                  -152,   1144,    136,   -908,   -152,    -80,    136,   -152,    -80,   -368,   1144,    -80,    352,   -368, &
                   -80,    -80,   -152,   -116,   -368,    856,   1144,    100,    100,   -908,   -908,   7282,   -152,    100, &
                   856,   -368,   -152,    856,    -26,    100,   1108,    856,   1144,   -152,    136,   -908,    -26,   -152, &
                   100,    100,     10,   -116,   -116,   -152,   -152,    856,   -152,    856,    100,   -152,   -368,    856, &
                   -26,    100,    -26,   -116,   -152,     10,    -80,   -368,    -80,   -152,    856,   -116,   -116,    208, &
                   -80,   1144,    136,   -152,   -116,   -116,    -26,     10,    -80,   -152,   -152,    100,     10,   -116, &
                   -26,    -26,   -152,    856,   1144,    100,   1108,    -26]
  K1(  55,:) = [   1144,    -80,   -152,    136,   -116,    208,    100,   -152,    -26,    -26,     10,   -116,    856,   -152, &
                  1108,    -26,   1144,    100,   -116,   -116,    -26,     10,    -80,   -152,    100,   -152,    100,   -908, &
                   -26,    136,   -908,    136,    136,   -152,   -152,    -80,   -152,    136,    -26,     10,   -152,    -26, &
                    10,   -152,    -26,   -116,    -80,   -116,   -908,    136,    100,    100,    -26,   -152,   7282,   -908, &
                  -908,    100,    100,   1144,   1144,   -152,    100,    -26,    856,   1108,   -152,    856,    100,   -152, &
                  -368,    856,   -368,    -80,    856,   -116,    -80,   -152,    856,   -152,   -152,   -116,   -116,     10, &
                  -152,     10,    100,    -26,   -116,    -26,   -368,    856,    856,   -152,   -152,    100,    -80,    -80, &
                  -152,   -116,   -368,    856,   -152,   1144,    136,    208,    -80,   -116,    136,   -152,   -908,    136, &
                   -80,   -152,    352,   -368,   -368,    -80,    -80,   1144]
  K1(  56,:) = [    -80,   1144,   -116,    208,   -152,    136,   -152,    100,     10,   -116,    -26,    -26,   -116,   -116, &
                   -26,     10,    -80,   -152,    856,   -152,   1108,    -26,   1144,    100,   -152,    100,    -26,    136, &
                   100,   -908,    136,   -908,   -152,    -80,    136,   -152,     10,   -152,    -26,   -116,    -80,   -116, &
                  -152,    136,    -26,     10,   -152,    -26,    136,   -908,    -26,   -152,    100,    100,   -908,   7282, &
                   100,   1144,   -908,    100,   -152,    856,    100,   -152,   -368,    856,   1144,   -152,    100,    -26, &
                   856,   1108,    -80,    -80,   -152,   -116,   -368,    856,   -152,   1144,    136,    208,    -80,   -116, &
                   136,   -152,   -908,    136,    -80,   -152,    352,   -368,   -368,    -80,    -80,   1144,   -368,    -80, &
                   856,   -116,    -80,   -152,    856,   -152,   -152,   -116,   -116,     10,   -152,     10,    100,    -26, &
                  -116,    -26,   -368,    856,    856,   -152,   -152,    100]
  K1(  57,:) = [   -152,   -116,    856,   -152,     10,   -116,    100,    -26,   -152,     10,    -26,   -116,   -368,    -80, &
                   856,   -116,    -80,   -152,   -152,    856,    100,   -152,   -368,    856,    -26,     10,   -152,    136, &
                   -26,   -152,    136,   -152,   -908,    136,    -80,   -152,    100,   -908,    100,   -152,    136,    -26, &
                  -116,    -80,   -116,    -26,   -152,     10,    100,    -26,   1144,   -152,   1108,    856,   -908,    100, &
                  7282,   -908,   1144,    100,    100,    100,   -908,    136,   -152,    -26,    856,   -368,   -152,    100, &
                   856,   -152,    856,   -152,   1108,    -26,   1144,    100,   -152,    136,   1144,    -80,    208,   -116, &
                   -26,    -26,    100,   -152,   -116,     10,    -80,   -152,   -116,   -116,     10,    -26,    -80,   -368, &
                  1144,    -80,    352,   -368,   -116,    -80,    208,    136,   1144,   -152,   -152,    -80,    136,   -908, &
                  -152,    136,   -368,    856,    -80,    -80,   -116,   -152]
  K1(  58,:) = [    136,    208,   -152,   1144,   -116,    -80,   -908,    136,    136,   -152,   -152,    -80,    -80,    -80, &
                  -152,   -116,   -368,    856,    -80,   -368,   1144,    -80,    352,   -368,    -26,   -116,     10,   -152, &
                  -116,    -80,   -152,    -80,    136,   -908,   -152,    136,    -26,    136,   -152,    100,   -908,    100, &
                   -26,   -152,     10,    -26,    136,   -152,    100,   -152,   -152,    856,    856,   -368,    100,   1144, &
                  -908,   7282,    100,   -908,    -26,   -152,    136,   -908,    100,    100,   1108,    856,    -26,    100, &
                  -152,   1144,   -116,   -116,    -26,     10,    -80,   -152,   -116,    208,    -80,   1144,    136,   -152, &
                    10,   -116,   -152,    100,    -26,    -26,   1144,    100,   -152,    856,    -26,   1108,   -152,    856, &
                   100,   -152,   -368,    856,     10,   -116,   -116,   -152,   -152,    856,    -26,   -116,    -26,    100, &
                    10,   -152,    -80,   -152,    -80,   -368,   -116,    856]
  K1(  59,:) = [   -116,   -152,     10,   -116,    856,   -152,    -26,    100,    -26,   -116,   -152,     10,   -152,    856, &
                   100,   -152,   -368,    856,   -368,    -80,    856,   -116,    -80,   -152,     10,    -26,    -26,   -152, &
                  -152,    136,   -152,    136,    -80,   -152,   -908,    136,   -116,    -80,   -116,    -26,   -152,     10, &
                   100,   -908,    100,   -152,    136,    -26,    -26,    100,   1108,    856,   1144,   -152,    100,   -908, &
                  1144,    100,   7282,   -908,    856,   -368,   -152,    100,    856,   -152,    100,    100,   -908,    136, &
                  -152,    -26,    -80,   -368,   1144,    -80,    352,   -368,   -116,    -80,    208,    136,   1144,   -152, &
                  -152,    -80,    136,   -908,   -152,    136,   -368,    856,    -80,    -80,   -116,   -152,    856,   -152, &
                  1108,    -26,   1144,    100,   -152,    136,   1144,    -80,    208,   -116,    -26,    -26,    100,   -152, &
                  -116,     10,    -80,   -152,   -116,   -116,     10,    -26]
  K1(  60,:) = [    208,    136,   -116,    -80,   -152,   1144,    136,   -908,   -152,    -80,    136,   -152,    -80,   -368, &
                  1144,    -80,    352,   -368,    -80,    -80,   -152,   -116,   -368,    856,   -116,    -26,   -116,    -80, &
                    10,   -152,    -80,   -152,   -152,    136,    136,   -908,    -26,   -152,     10,    -26,    136,   -152, &
                   -26,    136,   -152,    100,   -908,    100,   -152,    100,    856,   -368,   -152,    856,   1144,    100, &
                   100,   -908,   -908,   7282,   1108,    856,    -26,    100,   -152,   1144,    -26,   -152,    136,   -908, &
                   100,    100,   -152,    856,    100,   -152,   -368,    856,     10,   -116,   -116,   -152,   -152,    856, &
                   -26,   -116,    -26,    100,     10,   -152,    -80,   -152,    -80,   -368,   -116,    856,   -116,   -116, &
                   -26,     10,    -80,   -152,   -116,    208,    -80,   1144,    136,   -152,     10,   -116,   -152,    100, &
                   -26,    -26,   1144,    100,   -152,    856,    -26,   1108]
  K1(  61,:) = [   1108,    -26,    856,   -152,    100,   1144,    -26,    -26,    100,   -152,   -116,     10,   -152,    136, &
                  1144,    -80,    208,   -116,   -152,    -80,     10,    -26,   -116,   -116,    856,   -116,   -368,    -80, &
                  -152,    -80,   -152,     10,    100,    -26,   -116,    -26,    856,   -152,   -152,   -116,   -116,     10, &
                   856,   -368,   -152,    100,    856,   -152,    100,    100,   -908,    136,   -152,    -26,   1144,   -152, &
                   100,    -26,    856,   1108,   7282,   -908,   -908,    100,    100,   1144,    856,   -152,   -368,    856, &
                   100,   -152,    100,   -908,    100,   -152,    136,    -26,   -152,    136,    -26,     10,   -152,    -26, &
                  -908,    136,    136,   -152,   -152,    -80,   -152,     10,    -80,   -116,    -26,   -116,    856,   -368, &
                  -116,   -152,    -80,    -80,   -368,    352,    -80,   1144,   -368,    -80,   -152,    136,    -80,   -152, &
                  -908,    136,   1144,   -152,    -80,   -116,    136,    208]
  K1(  62,:) = [    -26,     10,   -116,   -116,   -152,    -80,     10,   -116,   -152,    100,    -26,    -26,   -116,    208, &
                   -80,   1144,    136,   -152,    100,   1144,    -26,   1108,   -152,    856,   -152,   -116,    -80,    -80, &
                   856,   -368,    136,   -152,   -908,    136,    -80,   -152,   -152,   1144,    136,    208,    -80,   -116, &
                  -368,    352,    -80,   1144,   -368,    -80,    -26,   -152,    136,   -908,    100,    100,   -152,    856, &
                   100,   -152,   -368,    856,   -908,   7282,    100,   1144,   -908,    100,   -152,   1144,    856,   1108, &
                   100,    -26,    -26,    136,   -152,    100,   -908,    100,     10,   -152,    -26,   -116,    -80,   -116, &
                   136,   -908,   -152,    -80,    136,   -152,    136,   -152,   -152,    -26,    -26,     10,   -152,    -80, &
                  -116,    856,    -80,   -368,    856,   -368,   -152,    100,    856,   -152,     10,   -152,   -116,    -26, &
                   100,    -26,   -152,    856,   -116,     10,   -152,   -116]
  K1(  63,:) = [    856,   -116,   -368,    -80,   -152,    -80,   -152,     10,    100,    -26,   -116,    -26,    856,   -152, &
                  -152,   -116,   -116,     10,    856,   -368,   -152,    100,    856,   -152,   1108,    -26,    856,   -152, &
                   100,   1144,    -26,    -26,    100,   -152,   -116,     10,   -152,    136,   1144,    -80,    208,   -116, &
                  -152,    -80,     10,    -26,   -116,   -116,   1144,   -152,    100,    -26,    856,   1108,    100,    100, &
                  -908,    136,   -152,    -26,   -908,    100,   7282,   -908,   1144,    100,   -368,    856,    856,   -152, &
                  -152,    100,   -152,    136,    -26,     10,   -152,    -26,    100,   -908,    100,   -152,    136,    -26, &
                   136,   -152,   -908,    136,    -80,   -152,    -80,   -116,   -152,     10,   -116,    -26,   -368,    352, &
                   -80,   1144,   -368,    -80,    856,   -368,   -116,   -152,    -80,    -80,    -80,   -152,   -152,    136, &
                   136,   -908,    -80,   -116,   1144,   -152,    208,    136]
  K1(  64,:) = [   -152,   -116,    -80,    -80,    856,   -368,    136,   -152,   -908,    136,    -80,   -152,   -152,   1144, &
                   136,    208,    -80,   -116,   -368,    352,    -80,   1144,   -368,    -80,    -26,     10,   -116,   -116, &
                  -152,    -80,     10,   -116,   -152,    100,    -26,    -26,   -116,    208,    -80,   1144,    136,   -152, &
                   100,   1144,    -26,   1108,   -152,    856,   -152,    856,    100,   -152,   -368,    856,    -26,   -152, &
                   136,   -908,    100,    100,    100,   1144,   -908,   7282,    100,   -908,    856,   1108,   -152,   1144, &
                   -26,    100,     10,   -152,    -26,   -116,    -80,   -116,    -26,    136,   -152,    100,   -908,    100, &
                  -152,    -80,    136,   -908,   -152,    136,   -152,    -26,    136,   -152,     10,    -26,    856,   -368, &
                  -152,    100,    856,   -152,   -152,    -80,   -116,    856,    -80,   -368,   -116,    -26,     10,   -152, &
                   -26,    100,   -116,     10,   -152,    856,   -116,   -152]
  K1(  65,:) = [    100,   -152,   -152,    856,    856,   -368,    -26,   -116,    -26,    100,     10,   -152,     10,   -116, &
                  -116,   -152,   -152,    856,   -152,    -80,   -116,    856,    -80,   -368,   1144,    -80,    -80,   -368, &
                  -368,    352,   -152,    -80,    136,   -908,   -152,    136,   -116,    -80,    208,    136,   1144,   -152, &
                   856,   -368,   -116,   -152,    -80,    -80,   1108,    856,    -26,    100,   -152,   1144,    856,   -368, &
                  -152,    100,    856,   -152,    100,   -908,   1144,    100,   7282,   -908,    100,    100,   -152,    -26, &
                  -908,    136,    -26,   -152,     10,    -26,    136,   -152,   -116,    -80,   -116,    -26,   -152,     10, &
                  -152,    136,    -80,   -152,   -908,    136,   -908,    100,    136,    -26,    100,   -152,    100,   1144, &
                   -26,   1108,   -152,    856,   -152,    -80,     10,    -26,   -116,   -116,    -26,    -26,   -116,     10, &
                   100,   -152,    136,   -152,    208,   -116,   1144,    -80]
  K1(  66,:) = [   1144,    -80,    -80,   -368,   -368,    352,   -152,    -80,    136,   -908,   -152,    136,   -116,    -80, &
                   208,    136,   1144,   -152,    856,   -368,   -116,   -152,    -80,    -80,    100,   -152,   -152,    856, &
                   856,   -368,    -26,   -116,    -26,    100,     10,   -152,     10,   -116,   -116,   -152,   -152,    856, &
                  -152,    -80,   -116,    856,    -80,   -368,    856,   -368,   -152,    100,    856,   -152,   1108,    856, &
                   -26,    100,   -152,   1144,   1144,    100,    100,   -908,   -908,   7282,   -152,    -26,    100,    100, &
                   136,   -908,   -116,    -80,   -116,    -26,   -152,     10,    -26,   -152,     10,    -26,    136,   -152, &
                   -80,   -152,   -152,    136,    136,   -908,    136,    -26,   -908,    100,   -152,    100,   -152,    -80, &
                    10,    -26,   -116,   -116,    100,   1144,    -26,   1108,   -152,    856,   -116,     10,    -26,    -26, &
                  -152,    100,    208,   -116,    136,   -152,    -80,   1144]
  K1(  67,:) = [    -26,   1108,    100,   1144,    856,   -152,    -26,    -26,   -116,     10,    100,   -152,   -152,    -80, &
                    10,    -26,   -116,   -116,   -152,    136,   1144,    -80,    208,   -116,   -116,    856,   -152,    -80, &
                  -368,    -80,     10,   -152,   -116,    -26,    100,    -26,    856,   -368,   -152,    100,    856,   -152, &
                   856,   -152,   -152,   -116,   -116,     10,    100,    100,   -152,    -26,   -908,    136,   -152,   1144, &
                   856,   1108,    100,    -26,    856,   -152,   -368,    856,    100,   -152,   7282,   -908,   -908,    100, &
                   100,   1144,    856,   -368,   -116,   -152,    -80,    -80,   -368,    352,    -80,   1144,   -368,    -80, &
                  -152,    136,    -80,   -152,   -908,    136,   1144,   -152,    -80,   -116,    136,    208,    100,   -908, &
                   100,   -152,    136,    -26,   -152,    136,    -26,     10,   -152,    -26,   -908,    136,    136,   -152, &
                  -152,    -80,   -152,     10,    -80,   -116,    -26,   -116]
  K1(  68,:) = [     10,    -26,   -152,    -80,   -116,   -116,   -116,     10,    -26,    -26,   -152,    100,    100,   1144, &
                   -26,   1108,   -152,    856,   -116,    208,    -80,   1144,    136,   -152,   -116,   -152,    856,   -368, &
                   -80,    -80,   -152,    136,    -80,   -152,   -908,    136,   -368,    352,    -80,   1144,   -368,    -80, &
                  -152,   1144,    136,    208,    -80,   -116,   -152,    -26,    100,    100,    136,   -908,    856,   -152, &
                  -368,    856,    100,   -152,   -152,   1144,    856,   1108,    100,    -26,   -908,   7282,    100,   1144, &
                  -908,    100,   -152,    -80,   -116,    856,    -80,   -368,    856,   -368,   -152,    100,    856,   -152, &
                    10,   -152,   -116,    -26,    100,    -26,   -152,    856,   -116,     10,   -152,   -116,    -26,    136, &
                  -152,    100,   -908,    100,     10,   -152,    -26,   -116,    -80,   -116,    136,   -908,   -152,    -80, &
                   136,   -152,    136,   -152,   -152,    -26,    -26,     10]
  K1(  69,:) = [   -116,    856,   -152,    -80,   -368,    -80,     10,   -152,   -116,    -26,    100,    -26,    856,   -368, &
                  -152,    100,    856,   -152,    856,   -152,   -152,   -116,   -116,     10,    -26,   1108,    100,   1144, &
                   856,   -152,    -26,    -26,   -116,     10,    100,   -152,   -152,    -80,     10,    -26,   -116,   -116, &
                  -152,    136,   1144,    -80,    208,   -116,   -152,   1144,    856,   1108,    100,    -26,    100,    100, &
                  -152,    -26,   -908,    136,   -368,    856,    856,   -152,   -152,    100,   -908,    100,   7282,   -908, &
                  1144,    100,   -368,    352,    -80,   1144,   -368,    -80,    856,   -368,   -116,   -152,    -80,    -80, &
                   -80,   -152,   -152,    136,    136,   -908,    -80,   -116,   1144,   -152,    208,    136,   -152,    136, &
                   -26,     10,   -152,    -26,    100,   -908,    100,   -152,    136,    -26,    136,   -152,   -908,    136, &
                   -80,   -152,    -80,   -116,   -152,     10,   -116,    -26]
  K1(  70,:) = [   -116,   -152,    856,   -368,    -80,    -80,   -152,    136,    -80,   -152,   -908,    136,   -368,    352, &
                   -80,   1144,   -368,    -80,   -152,   1144,    136,    208,    -80,   -116,     10,    -26,   -152,    -80, &
                  -116,   -116,   -116,     10,    -26,    -26,   -152,    100,    100,   1144,    -26,   1108,   -152,    856, &
                  -116,    208,    -80,   1144,    136,   -152,    856,   -152,   -368,    856,    100,   -152,   -152,    -26, &
                   100,    100,    136,   -908,    856,   1108,   -152,   1144,    -26,    100,    100,   1144,   -908,   7282, &
                   100,   -908,    856,   -368,   -152,    100,    856,   -152,   -152,    -80,   -116,    856,    -80,   -368, &
                  -116,    -26,     10,   -152,    -26,    100,   -116,     10,   -152,    856,   -116,   -152,     10,   -152, &
                   -26,   -116,    -80,   -116,    -26,    136,   -152,    100,   -908,    100,   -152,    -80,    136,   -908, &
                  -152,    136,   -152,    -26,    136,   -152,     10,    -26]
  K1(  71,:) = [   -152,    100,    856,   -368,   -152,    856,   -116,    -26,     10,   -152,    -26,    100,   -152,    -80, &
                  -116,    856,    -80,   -368,     10,   -116,   -116,   -152,   -152,    856,    -80,   1144,   -368,    352, &
                   -80,   -368,    -80,   -152,   -152,    136,    136,   -908,    856,   -368,   -116,   -152,    -80,    -80, &
                  -116,    -80,    208,    136,   1144,   -152,    856,   1108,   -152,   1144,    -26,    100,   -368,    856, &
                   856,   -152,   -152,    100,    100,    100,   -152,    -26,   -908,    136,    100,   -908,   1144,    100, &
                  7282,   -908,    100,   1144,    -26,   1108,   -152,    856,   -152,    -80,     10,    -26,   -116,   -116, &
                   -26,    -26,   -116,     10,    100,   -152,    136,   -152,    208,   -116,   1144,    -80,    -26,   -152, &
                    10,    -26,    136,   -152,   -116,    -80,   -116,    -26,   -152,     10,   -152,    136,    -80,   -152, &
                  -908,    136,   -908,    100,    136,    -26,    100,   -152]
  K1(  72,:) = [    -80,   1144,   -368,    352,    -80,   -368,    -80,   -152,   -152,    136,    136,   -908,    856,   -368, &
                  -116,   -152,    -80,    -80,   -116,    -80,    208,    136,   1144,   -152,   -152,    100,    856,   -368, &
                  -152,    856,   -116,    -26,     10,   -152,    -26,    100,   -152,    -80,   -116,    856,    -80,   -368, &
                    10,   -116,   -116,   -152,   -152,    856,   -368,    856,    856,   -152,   -152,    100,    856,   1108, &
                  -152,   1144,    -26,    100,   -152,    -26,    100,    100,    136,   -908,   1144,    100,    100,   -908, &
                  -908,   7282,   -152,    -80,     10,    -26,   -116,   -116,    100,   1144,    -26,   1108,   -152,    856, &
                  -116,     10,    -26,    -26,   -152,    100,    208,   -116,    136,   -152,    -80,   1144,   -116,    -80, &
                  -116,    -26,   -152,     10,    -26,   -152,     10,    -26,    136,   -152,    -80,   -152,   -152,    136, &
                   136,   -908,    136,    -26,   -908,    100,   -152,    100]
  K1(  73,:) = [    100,   -908,    100,   -152,    136,    -26,   -152,    136,    -26,     10,   -152,    -26,   -908,    136, &
                   136,   -152,   -152,    -80,   -152,     10,    -80,   -116,    -26,   -116,   -152,    136,   1144,    -80, &
                   208,   -116,    856,   -152,   1108,    -26,   1144,    100,    100,   -152,    -26,    -26,     10,   -116, &
                  -116,   -116,    -80,   -152,    -26,     10,    856,   -152,   -152,   -116,   -116,     10,   -368,    -80, &
                   856,   -116,    -80,   -152,    100,    -26,   -152,     10,    -26,   -116,    856,   -152,   -368,    856, &
                   100,   -152,   7282,   -908,   -908,    100,    100,   1144,   -908,    136,    100,    100,    -26,   -152, &
                   100,    -26,   1144,   -152,   1108,    856,    100,   -152,   -152,    856,    856,   -368,   1144,   -152, &
                   -80,   -116,    136,    208,    -80,    -80,   -368,    856,   -152,   -116,   -368,    -80,    352,   -368, &
                  1144,    -80,   -908,    136,    136,   -152,   -152,    -80]
  K1(  74,:) = [    -26,    136,   -152,    100,   -908,    100,     10,   -152,    -26,   -116,    -80,   -116,    136,   -908, &
                  -152,    -80,    136,   -152,    136,   -152,   -152,    -26,    -26,     10,   -116,    208,    -80,   1144, &
                   136,   -152,   -116,   -116,    -26,     10,    -80,   -152,   -152,    100,     10,   -116,    -26,    -26, &
                  -152,    856,   1144,    100,   1108,    -26,   -152,   1144,    136,    208,    -80,   -116,    -80,    -80, &
                  -152,   -116,   -368,    856,   -908,    136,    136,   -152,   -152,    -80,   -368,    -80,    352,   -368, &
                  1144,    -80,   -908,   7282,    100,   1144,   -908,    100,    136,   -908,    -26,   -152,    100,    100, &
                   100,   -152,   -152,    856,    856,   -368,    100,    -26,   1144,   -152,   1108,    856,   -152,    856, &
                  -116,     10,   -152,   -116,    -80,   -368,    -80,   -152,    856,   -116,    856,   -152,   -368,    856, &
                   100,   -152,    100,    -26,   -152,     10,    -26,   -116]
  K1(  75,:) = [   -152,    136,    -26,     10,   -152,    -26,    100,   -908,    100,   -152,    136,    -26,    136,   -152, &
                  -908,    136,    -80,   -152,    -80,   -116,   -152,     10,   -116,    -26,    856,   -152,   -152,   -116, &
                  -116,     10,   -368,    -80,    856,   -116,    -80,   -152,    100,    -26,   -152,     10,    -26,   -116, &
                   856,   -152,   -368,    856,    100,   -152,   -152,    136,   1144,    -80,    208,   -116,    856,   -152, &
                  1108,    -26,   1144,    100,    100,   -152,    -26,    -26,     10,   -116,   -116,   -116,    -80,   -152, &
                   -26,     10,   -908,    100,   7282,   -908,   1144,    100,    100,    -26,   1144,   -152,   1108,    856, &
                  -908,    136,    100,    100,    -26,   -152,   -152,    100,    856,   -368,   -152,    856,    -80,   -116, &
                  1144,   -152,    208,    136,   -368,    -80,    352,   -368,   1144,    -80,    -80,    -80,   -368,    856, &
                  -152,   -116,    136,   -908,   -152,    -80,    136,   -152]
  K1(  76,:) = [     10,   -152,    -26,   -116,    -80,   -116,    -26,    136,   -152,    100,   -908,    100,   -152,    -80, &
                   136,   -908,   -152,    136,   -152,    -26,    136,   -152,     10,    -26,   -152,   1144,    136,    208, &
                   -80,   -116,    -80,    -80,   -152,   -116,   -368,    856,   -908,    136,    136,   -152,   -152,    -80, &
                  -368,    -80,    352,   -368,   1144,    -80,   -116,    208,    -80,   1144,    136,   -152,   -116,   -116, &
                   -26,     10,    -80,   -152,   -152,    100,     10,   -116,    -26,    -26,   -152,    856,   1144,    100, &
                  1108,    -26,    100,   1144,   -908,   7282,    100,   -908,    100,   -152,   -152,    856,    856,   -368, &
                   136,   -908,    -26,   -152,    100,    100,    -26,    100,   1108,    856,   1144,   -152,   -116,     10, &
                  -152,    856,   -116,   -152,    856,   -152,   -368,    856,    100,   -152,    -80,   -368,    -80,   -152, &
                   856,   -116,    -26,    100,    -26,   -116,   -152,     10]
  K1(  77,:) = [    -26,   -152,     10,    -26,    136,   -152,   -116,    -80,   -116,    -26,   -152,     10,   -152,    136, &
                   -80,   -152,   -908,    136,   -908,    100,    136,    -26,    100,   -152,     10,   -116,   -116,   -152, &
                  -152,    856,   -152,    856,    100,   -152,   -368,    856,    -26,    100,    -26,   -116,   -152,     10, &
                   -80,   -368,    -80,   -152,    856,   -116,   -116,    -80,    208,    136,   1144,   -152,    -80,   -368, &
                  1144,    -80,    352,   -368,    136,   -908,   -152,    -80,    136,   -152,    -80,    -80,   -368,    856, &
                  -152,   -116,    100,   -908,   1144,    100,   7282,   -908,    -26,    100,   1108,    856,   1144,   -152, &
                  -152,    100,    856,   -368,   -152,    856,   -908,    136,    100,    100,    -26,   -152,    136,   -152, &
                   208,   -116,   1144,    -80,   -152,    856,   1144,    100,   1108,    -26,   -116,   -116,    -80,   -152, &
                   -26,     10,    100,   -152,    -26,    -26,     10,   -116]
  K1(  78,:) = [   -116,    -80,   -116,    -26,   -152,     10,    -26,   -152,     10,    -26,    136,   -152,    -80,   -152, &
                  -152,    136,    136,   -908,    136,    -26,   -908,    100,   -152,    100,   -116,    -80,    208,    136, &
                  1144,   -152,    -80,   -368,   1144,    -80,    352,   -368,    136,   -908,   -152,    -80,    136,   -152, &
                   -80,    -80,   -368,    856,   -152,   -116,     10,   -116,   -116,   -152,   -152,    856,   -152,    856, &
                   100,   -152,   -368,    856,    -26,    100,    -26,   -116,   -152,     10,    -80,   -368,    -80,   -152, &
                   856,   -116,   1144,    100,    100,   -908,   -908,   7282,   -152,    100,    856,   -368,   -152,    856, &
                   -26,    100,   1108,    856,   1144,   -152,    136,   -908,    -26,   -152,    100,    100,    208,   -116, &
                   136,   -152,    -80,   1144,   -116,   -116,    -80,   -152,    -26,     10,   -152,    856,   1144,    100, &
                  1108,    -26,   -152,    100,     10,   -116,    -26,    -26]
  K1(  79,:) = [   -152,    136,   1144,    -80,    208,   -116,    856,   -152,   1108,    -26,   1144,    100,    100,   -152, &
                   -26,    -26,     10,   -116,   -116,   -116,    -80,   -152,    -26,     10,    100,   -908,    100,   -152, &
                   136,    -26,   -152,    136,    -26,     10,   -152,    -26,   -908,    136,    136,   -152,   -152,    -80, &
                  -152,     10,    -80,   -116,    -26,   -116,   -368,    -80,    856,   -116,    -80,   -152,    856,   -152, &
                  -152,   -116,   -116,     10,   -152,     10,    100,    -26,   -116,    -26,   -368,    856,    856,   -152, &
                  -152,    100,   -908,    136,    100,    100,    -26,   -152,   7282,   -908,   -908,    100,    100,   1144, &
                  1144,   -152,    100,    -26,    856,   1108,   -152,    856,    100,   -152,   -368,    856,    -80,    -80, &
                  -368,    856,   -152,   -116,   1144,   -152,    -80,   -116,    136,    208,    352,   -368,   -368,    -80, &
                   -80,   1144,    136,   -152,   -908,    136,    -80,   -152]
  K1(  80,:) = [   -116,    208,    -80,   1144,    136,   -152,   -116,   -116,    -26,     10,    -80,   -152,   -152,    100, &
                    10,   -116,    -26,    -26,   -152,    856,   1144,    100,   1108,    -26,    -26,    136,   -152,    100, &
                  -908,    100,     10,   -152,    -26,   -116,    -80,   -116,    136,   -908,   -152,    -80,    136,   -152, &
                   136,   -152,   -152,    -26,    -26,     10,    -80,    -80,   -152,   -116,   -368,    856,   -152,   1144, &
                   136,    208,    -80,   -116,    136,   -152,   -908,    136,    -80,   -152,    352,   -368,   -368,    -80, &
                   -80,   1144,    136,   -908,    -26,   -152,    100,    100,   -908,   7282,    100,   1144,   -908,    100, &
                  -152,    856,    100,   -152,   -368,    856,   1144,   -152,    100,    -26,    856,   1108,    -80,   -368, &
                   -80,   -152,    856,   -116,   -152,    856,   -116,     10,   -152,   -116,   -368,    856,    856,   -152, &
                  -152,    100,   -152,     10,    100,    -26,   -116,    -26]
  K1(  81,:) = [    856,   -152,   -152,   -116,   -116,     10,   -368,    -80,    856,   -116,    -80,   -152,    100,    -26, &
                  -152,     10,    -26,   -116,    856,   -152,   -368,    856,    100,   -152,   -152,    136,    -26,     10, &
                  -152,    -26,    100,   -908,    100,   -152,    136,    -26,    136,   -152,   -908,    136,    -80,   -152, &
                   -80,   -116,   -152,     10,   -116,    -26,    856,   -152,   1108,    -26,   1144,    100,   -152,    136, &
                  1144,    -80,    208,   -116,    -26,    -26,    100,   -152,   -116,     10,    -80,   -152,   -116,   -116, &
                    10,    -26,    100,    -26,   1144,   -152,   1108,    856,   -908,    100,   7282,   -908,   1144,    100, &
                   100,    100,   -908,    136,   -152,    -26,    856,   -368,   -152,    100,    856,   -152,   -368,    -80, &
                   352,   -368,   1144,    -80,    -80,   -116,   1144,   -152,    208,    136,   -368,    856,    -80,    -80, &
                  -116,   -152,   -152,    -80,    136,   -908,   -152,    136]
  K1(  82,:) = [   -152,   1144,    136,    208,    -80,   -116,    -80,    -80,   -152,   -116,   -368,    856,   -908,    136, &
                   136,   -152,   -152,    -80,   -368,    -80,    352,   -368,   1144,    -80,     10,   -152,    -26,   -116, &
                   -80,   -116,    -26,    136,   -152,    100,   -908,    100,   -152,    -80,    136,   -908,   -152,    136, &
                  -152,    -26,    136,   -152,     10,    -26,   -116,   -116,    -26,     10,    -80,   -152,   -116,    208, &
                   -80,   1144,    136,   -152,     10,   -116,   -152,    100,    -26,    -26,   1144,    100,   -152,    856, &
                   -26,   1108,    100,   -152,   -152,    856,    856,   -368,    100,   1144,   -908,   7282,    100,   -908, &
                   -26,   -152,    136,   -908,    100,    100,   1108,    856,    -26,    100,   -152,   1144,    856,   -152, &
                  -368,    856,    100,   -152,   -116,     10,   -152,    856,   -116,   -152,    -80,   -152,    -80,   -368, &
                  -116,    856,    -26,   -116,    -26,    100,     10,   -152]
  K1(  83,:) = [     10,   -116,   -116,   -152,   -152,    856,   -152,    856,    100,   -152,   -368,    856,    -26,    100, &
                   -26,   -116,   -152,     10,    -80,   -368,    -80,   -152,    856,   -116,    -26,   -152,     10,    -26, &
                   136,   -152,   -116,    -80,   -116,    -26,   -152,     10,   -152,    136,    -80,   -152,   -908,    136, &
                  -908,    100,    136,    -26,    100,   -152,    -80,   -368,   1144,    -80,    352,   -368,   -116,    -80, &
                   208,    136,   1144,   -152,   -152,    -80,    136,   -908,   -152,    136,   -368,    856,    -80,    -80, &
                  -116,   -152,    -26,    100,   1108,    856,   1144,   -152,    100,   -908,   1144,    100,   7282,   -908, &
                   856,   -368,   -152,    100,    856,   -152,    100,    100,   -908,    136,   -152,    -26,   -152,    856, &
                  1144,    100,   1108,    -26,    136,   -152,    208,   -116,   1144,    -80,    -80,   -152,   -116,   -116, &
                    10,    -26,    -26,    -26,    100,   -152,   -116,     10]
  K1(  84,:) = [   -116,    -80,    208,    136,   1144,   -152,    -80,   -368,   1144,    -80,    352,   -368,    136,   -908, &
                  -152,    -80,    136,   -152,    -80,    -80,   -368,    856,   -152,   -116,   -116,    -80,   -116,    -26, &
                  -152,     10,    -26,   -152,     10,    -26,    136,   -152,    -80,   -152,   -152,    136,    136,   -908, &
                   136,    -26,   -908,    100,   -152,    100,   -152,    856,    100,   -152,   -368,    856,     10,   -116, &
                  -116,   -152,   -152,    856,    -26,   -116,    -26,    100,     10,   -152,    -80,   -152,    -80,   -368, &
                  -116,    856,   -152,    100,    856,   -368,   -152,    856,   1144,    100,    100,   -908,   -908,   7282, &
                  1108,    856,    -26,    100,   -152,   1144,    -26,   -152,    136,   -908,    100,    100,   -116,   -116, &
                   -80,   -152,    -26,     10,    208,   -116,    136,   -152,    -80,   1144,   1144,    100,   -152,    856, &
                   -26,   1108,     10,   -116,   -152,    100,    -26,    -26]
  K1(  85,:) = [    856,   -152,   1108,    -26,   1144,    100,   -152,    136,   1144,    -80,    208,   -116,    -26,    -26, &
                   100,   -152,   -116,     10,    -80,   -152,   -116,   -116,     10,    -26,   -368,    -80,    856,   -116, &
                   -80,   -152,    856,   -152,   -152,   -116,   -116,     10,   -152,     10,    100,    -26,   -116,    -26, &
                  -368,    856,    856,   -152,   -152,    100,    100,   -908,    100,   -152,    136,    -26,   -152,    136, &
                   -26,     10,   -152,    -26,   -908,    136,    136,   -152,   -152,    -80,   -152,     10,    -80,   -116, &
                   -26,   -116,    100,    100,   -908,    136,   -152,    -26,   1144,   -152,    100,    -26,    856,   1108, &
                  7282,   -908,   -908,    100,    100,   1144,    856,   -152,   -368,    856,    100,   -152,   -368,    856, &
                   -80,    -80,   -116,   -152,    352,   -368,   -368,    -80,    -80,   1144,   1144,   -152,    -80,   -116, &
                   136,    208,   -152,    136,    -80,   -152,   -908,    136]
  K1(  86,:) = [   -116,   -116,    -26,     10,    -80,   -152,   -116,    208,    -80,   1144,    136,   -152,     10,   -116, &
                  -152,    100,    -26,    -26,   1144,    100,   -152,    856,    -26,   1108,    -80,    -80,   -152,   -116, &
                  -368,    856,   -152,   1144,    136,    208,    -80,   -116,    136,   -152,   -908,    136,    -80,   -152, &
                   352,   -368,   -368,    -80,    -80,   1144,    -26,    136,   -152,    100,   -908,    100,     10,   -152, &
                   -26,   -116,    -80,   -116,    136,   -908,   -152,    -80,    136,   -152,    136,   -152,   -152,    -26, &
                   -26,     10,    -26,   -152,    136,   -908,    100,    100,   -152,    856,    100,   -152,   -368,    856, &
                  -908,   7282,    100,   1144,   -908,    100,   -152,   1144,    856,   1108,    100,    -26,    -80,   -152, &
                   -80,   -368,   -116,    856,   -368,    856,    856,   -152,   -152,    100,   -152,    856,   -116,     10, &
                  -152,   -116,     10,   -152,   -116,    -26,    100,    -26]
  K1(  87,:) = [   -368,    -80,    856,   -116,    -80,   -152,    856,   -152,   -152,   -116,   -116,     10,   -152,     10, &
                   100,    -26,   -116,    -26,   -368,    856,    856,   -152,   -152,    100,    856,   -152,   1108,    -26, &
                  1144,    100,   -152,    136,   1144,    -80,    208,   -116,    -26,    -26,    100,   -152,   -116,     10, &
                   -80,   -152,   -116,   -116,     10,    -26,   -152,    136,    -26,     10,   -152,    -26,    100,   -908, &
                   100,   -152,    136,    -26,    136,   -152,   -908,    136,    -80,   -152,    -80,   -116,   -152,     10, &
                  -116,    -26,   1144,   -152,    100,    -26,    856,   1108,    100,    100,   -908,    136,   -152,    -26, &
                  -908,    100,   7282,   -908,   1144,    100,   -368,    856,    856,   -152,   -152,    100,    352,   -368, &
                  -368,    -80,    -80,   1144,   -368,    856,    -80,    -80,   -116,   -152,    -80,   -116,   1144,   -152, &
                   208,    136,    -80,   -152,   -152,    136,    136,   -908]
  K1(  88,:) = [    -80,    -80,   -152,   -116,   -368,    856,   -152,   1144,    136,    208,    -80,   -116,    136,   -152, &
                  -908,    136,    -80,   -152,    352,   -368,   -368,    -80,    -80,   1144,   -116,   -116,    -26,     10, &
                   -80,   -152,   -116,    208,    -80,   1144,    136,   -152,     10,   -116,   -152,    100,    -26,    -26, &
                  1144,    100,   -152,    856,    -26,   1108,     10,   -152,    -26,   -116,    -80,   -116,    -26,    136, &
                  -152,    100,   -908,    100,   -152,    -80,    136,   -908,   -152,    136,   -152,    -26,    136,   -152, &
                    10,    -26,   -152,    856,    100,   -152,   -368,    856,    -26,   -152,    136,   -908,    100,    100, &
                   100,   1144,   -908,   7282,    100,   -908,    856,   1108,   -152,   1144,    -26,    100,   -368,    856, &
                   856,   -152,   -152,    100,    -80,   -152,    -80,   -368,   -116,    856,   -116,     10,   -152,    856, &
                  -116,   -152,   -116,    -26,     10,   -152,    -26,    100]
  K1(  89,:) = [   -152,    856,    100,   -152,   -368,    856,     10,   -116,   -116,   -152,   -152,    856,    -26,   -116, &
                   -26,    100,     10,   -152,    -80,   -152,    -80,   -368,   -116,    856,    -80,   -368,   1144,    -80, &
                   352,   -368,   -116,    -80,    208,    136,   1144,   -152,   -152,    -80,    136,   -908,   -152,    136, &
                  -368,    856,    -80,    -80,   -116,   -152,    -26,   -152,     10,    -26,    136,   -152,   -116,    -80, &
                  -116,    -26,   -152,     10,   -152,    136,    -80,   -152,   -908,    136,   -908,    100,    136,    -26, &
                   100,   -152,   1108,    856,    -26,    100,   -152,   1144,    856,   -368,   -152,    100,    856,   -152, &
                   100,   -908,   1144,    100,   7282,   -908,    100,    100,   -152,    -26,   -908,    136,   1144,    100, &
                  -152,    856,    -26,   1108,    -80,   -152,   -116,   -116,     10,    -26,    136,   -152,    208,   -116, &
                  1144,    -80,    -26,    -26,   -116,     10,    100,   -152]
  K1(  90,:) = [    -80,   -368,   1144,    -80,    352,   -368,   -116,    -80,    208,    136,   1144,   -152,   -152,    -80, &
                   136,   -908,   -152,    136,   -368,    856,    -80,    -80,   -116,   -152,   -152,    856,    100,   -152, &
                  -368,    856,     10,   -116,   -116,   -152,   -152,    856,    -26,   -116,    -26,    100,     10,   -152, &
                   -80,   -152,    -80,   -368,   -116,    856,   -116,    -80,   -116,    -26,   -152,     10,    -26,   -152, &
                    10,    -26,    136,   -152,    -80,   -152,   -152,    136,    136,   -908,    136,    -26,   -908,    100, &
                  -152,    100,    856,   -368,   -152,    100,    856,   -152,   1108,    856,    -26,    100,   -152,   1144, &
                  1144,    100,    100,   -908,   -908,   7282,   -152,    -26,    100,    100,    136,   -908,    -80,   -152, &
                  -116,   -116,     10,    -26,   1144,    100,   -152,    856,    -26,   1108,    208,   -116,    136,   -152, &
                   -80,   1144,   -116,     10,    -26,    -26,   -152,    100]
  K1(  91,:) = [    100,   1144,    -26,   1108,   -152,    856,   -152,    -80,     10,    -26,   -116,   -116,    -26,    -26, &
                  -116,     10,    100,   -152,    136,   -152,    208,   -116,   1144,    -80,   -152,    -80,   -116,    856, &
                   -80,   -368,    856,   -368,   -152,    100,    856,   -152,     10,   -152,   -116,    -26,    100,    -26, &
                  -152,    856,   -116,     10,   -152,   -116,    856,   -368,   -116,   -152,    -80,    -80,   -368,    352, &
                   -80,   1144,   -368,    -80,   -152,    136,    -80,   -152,   -908,    136,   1144,   -152,    -80,   -116, &
                   136,    208,    100,    100,   -152,    -26,   -908,    136,   -152,   1144,    856,   1108,    100,    -26, &
                   856,   -152,   -368,    856,    100,   -152,   7282,   -908,   -908,    100,    100,   1144,   -908,    100, &
                   136,    -26,    100,   -152,    136,   -152,   -152,    -26,    -26,     10,   -152,     10,    -80,   -116, &
                   -26,   -116,   -908,    136,    136,   -152,   -152,    -80]
  K1(  92,:) = [   -152,    -80,     10,    -26,   -116,   -116,    100,   1144,    -26,   1108,   -152,    856,   -116,     10, &
                   -26,    -26,   -152,    100,    208,   -116,    136,   -152,    -80,   1144,    856,   -368,   -116,   -152, &
                   -80,    -80,   -368,    352,    -80,   1144,   -368,    -80,   -152,    136,    -80,   -152,   -908,    136, &
                  1144,   -152,    -80,   -116,    136,    208,   -152,    -80,   -116,    856,    -80,   -368,    856,   -368, &
                  -152,    100,    856,   -152,     10,   -152,   -116,    -26,    100,    -26,   -152,    856,   -116,     10, &
                  -152,   -116,   -152,    -26,    100,    100,    136,   -908,    856,   -152,   -368,    856,    100,   -152, &
                  -152,   1144,    856,   1108,    100,    -26,   -908,   7282,    100,   1144,   -908,    100,    136,    -26, &
                  -908,    100,   -152,    100,   -152,     10,    -80,   -116,    -26,   -116,    136,   -152,   -152,    -26, &
                   -26,     10,    136,   -908,   -152,    -80,    136,   -152]
  K1(  93,:) = [   -152,    -80,   -116,    856,    -80,   -368,    856,   -368,   -152,    100,    856,   -152,     10,   -152, &
                  -116,    -26,    100,    -26,   -152,    856,   -116,     10,   -152,   -116,    100,   1144,    -26,   1108, &
                  -152,    856,   -152,    -80,     10,    -26,   -116,   -116,    -26,    -26,   -116,     10,    100,   -152, &
                   136,   -152,    208,   -116,   1144,    -80,   -368,    352,    -80,   1144,   -368,    -80,    856,   -368, &
                  -116,   -152,    -80,    -80,    -80,   -152,   -152,    136,    136,   -908,    -80,   -116,   1144,   -152, &
                   208,    136,   -152,   1144,    856,   1108,    100,    -26,    100,    100,   -152,    -26,   -908,    136, &
                  -368,    856,    856,   -152,   -152,    100,   -908,    100,   7282,   -908,   1144,    100,    136,   -152, &
                  -152,    -26,    -26,     10,   -908,    100,    136,    -26,    100,   -152,    -80,   -116,   -152,     10, &
                  -116,    -26,    136,   -152,   -908,    136,    -80,   -152]
  K1(  94,:) = [    856,   -368,   -116,   -152,    -80,    -80,   -368,    352,    -80,   1144,   -368,    -80,   -152,    136, &
                   -80,   -152,   -908,    136,   1144,   -152,    -80,   -116,    136,    208,   -152,    -80,     10,    -26, &
                  -116,   -116,    100,   1144,    -26,   1108,   -152,    856,   -116,     10,    -26,    -26,   -152,    100, &
                   208,   -116,    136,   -152,    -80,   1144,    856,   -368,   -152,    100,    856,   -152,   -152,    -80, &
                  -116,    856,    -80,   -368,   -116,    -26,     10,   -152,    -26,    100,   -116,     10,   -152,    856, &
                  -116,   -152,    856,   -152,   -368,    856,    100,   -152,   -152,    -26,    100,    100,    136,   -908, &
                   856,   1108,   -152,   1144,    -26,    100,    100,   1144,   -908,   7282,    100,   -908,   -152,     10, &
                   -80,   -116,    -26,   -116,    136,    -26,   -908,    100,   -152,    100,   -152,    -26,    136,   -152, &
                    10,    -26,   -152,    -80,    136,   -908,   -152,    136]
  K1(  95,:) = [    856,   -368,   -152,    100,    856,   -152,   -152,    -80,   -116,    856,    -80,   -368,   -116,    -26, &
                    10,   -152,    -26,    100,   -116,     10,   -152,    856,   -116,   -152,   -368,    352,    -80,   1144, &
                  -368,    -80,    856,   -368,   -116,   -152,    -80,    -80,    -80,   -152,   -152,    136,    136,   -908, &
                   -80,   -116,   1144,   -152,    208,    136,    100,   1144,    -26,   1108,   -152,    856,   -152,    -80, &
                    10,    -26,   -116,   -116,    -26,    -26,   -116,     10,    100,   -152,    136,   -152,    208,   -116, &
                  1144,    -80,    856,   1108,   -152,   1144,    -26,    100,   -368,    856,    856,   -152,   -152,    100, &
                   100,    100,   -152,    -26,   -908,    136,    100,   -908,   1144,    100,   7282,   -908,   -152,    -26, &
                   136,   -152,     10,    -26,    -80,   -116,   -152,     10,   -116,    -26,   -908,    100,    136,    -26, &
                   100,   -152,   -152,    136,    -80,   -152,   -908,    136]
  K1(  96,:) = [   -368,    352,    -80,   1144,   -368,    -80,    856,   -368,   -116,   -152,    -80,    -80,    -80,   -152, &
                  -152,    136,    136,   -908,    -80,   -116,   1144,   -152,    208,    136,    856,   -368,   -152,    100, &
                   856,   -152,   -152,    -80,   -116,    856,    -80,   -368,   -116,    -26,     10,   -152,    -26,    100, &
                  -116,     10,   -152,    856,   -116,   -152,   -152,    -80,     10,    -26,   -116,   -116,    100,   1144, &
                   -26,   1108,   -152,    856,   -116,     10,    -26,    -26,   -152,    100,    208,   -116,    136,   -152, &
                   -80,   1144,   -368,    856,    856,   -152,   -152,    100,    856,   1108,   -152,   1144,    -26,    100, &
                  -152,    -26,    100,    100,    136,   -908,   1144,    100,    100,   -908,   -908,   7282,    -80,   -116, &
                  -152,     10,   -116,    -26,   -152,    -26,    136,   -152,     10,    -26,    136,    -26,   -908,    100, &
                  -152,    100,    -80,   -152,   -152,    136,    136,   -908]
  K1(  97,:) = [   -908,    100,    136,    -26,    100,   -152,    136,   -152,   -152,    -26,    -26,     10,   -152,     10, &
                   -80,   -116,    -26,   -116,   -908,    136,    136,   -152,   -152,    -80,    136,   -152,    208,   -116, &
                  1144,    -80,   -152,    856,   1144,    100,   1108,    -26,   -116,   -116,    -80,   -152,    -26,     10, &
                   100,   -152,    -26,    -26,     10,   -116,   -152,    856,   -116,     10,   -152,   -116,    -80,   -368, &
                   -80,   -152,    856,   -116,    856,   -152,   -368,    856,    100,   -152,    100,    -26,   -152,     10, &
                   -26,   -116,   1144,   -152,    -80,   -116,    136,    208,    -80,    -80,   -368,    856,   -152,   -116, &
                  -368,    -80,    352,   -368,   1144,    -80,   -908,    136,    136,   -152,   -152,    -80,   7282,   -908, &
                  -908,    100,    100,   1144,   -908,    136,    100,    100,    -26,   -152,    100,    -26,   1144,   -152, &
                  1108,    856,    100,   -152,   -152,    856,    856,   -368]
  K1(  98,:) = [    136,    -26,   -908,    100,   -152,    100,   -152,     10,    -80,   -116,    -26,   -116,    136,   -152, &
                  -152,    -26,    -26,     10,    136,   -908,   -152,    -80,    136,   -152,    208,   -116,    136,   -152, &
                   -80,   1144,   -116,   -116,    -80,   -152,    -26,     10,   -152,    856,   1144,    100,   1108,    -26, &
                  -152,    100,     10,   -116,    -26,    -26,   1144,   -152,    -80,   -116,    136,    208,    -80,    -80, &
                  -368,    856,   -152,   -116,   -368,    -80,    352,   -368,   1144,    -80,   -908,    136,    136,   -152, &
                  -152,    -80,   -152,    856,   -116,     10,   -152,   -116,    -80,   -368,    -80,   -152,    856,   -116, &
                   856,   -152,   -368,    856,    100,   -152,    100,    -26,   -152,     10,    -26,   -116,   -908,   7282, &
                   100,   1144,   -908,    100,    136,   -908,    -26,   -152,    100,    100,    100,   -152,   -152,    856, &
                   856,   -368,    100,    -26,   1144,   -152,   1108,    856]
  K1(  99,:) = [    136,   -152,   -152,    -26,    -26,     10,   -908,    100,    136,    -26,    100,   -152,    -80,   -116, &
                  -152,     10,   -116,    -26,    136,   -152,   -908,    136,    -80,   -152,   -152,    856,   -116,     10, &
                  -152,   -116,    -80,   -368,    -80,   -152,    856,   -116,    856,   -152,   -368,    856,    100,   -152, &
                   100,    -26,   -152,     10,    -26,   -116,    136,   -152,    208,   -116,   1144,    -80,   -152,    856, &
                  1144,    100,   1108,    -26,   -116,   -116,    -80,   -152,    -26,     10,    100,   -152,    -26,    -26, &
                    10,   -116,    -80,   -116,   1144,   -152,    208,    136,   -368,    -80,    352,   -368,   1144,    -80, &
                   -80,    -80,   -368,    856,   -152,   -116,    136,   -908,   -152,    -80,    136,   -152,   -908,    100, &
                  7282,   -908,   1144,    100,    100,    -26,   1144,   -152,   1108,    856,   -908,    136,    100,    100, &
                   -26,   -152,   -152,    100,    856,   -368,   -152,    856]
  K1( 100,:) = [   -152,     10,    -80,   -116,    -26,   -116,    136,    -26,   -908,    100,   -152,    100,   -152,    -26, &
                   136,   -152,     10,    -26,   -152,    -80,    136,   -908,   -152,    136,   1144,   -152,    -80,   -116, &
                   136,    208,    -80,    -80,   -368,    856,   -152,   -116,   -368,    -80,    352,   -368,   1144,    -80, &
                  -908,    136,    136,   -152,   -152,    -80,    208,   -116,    136,   -152,    -80,   1144,   -116,   -116, &
                   -80,   -152,    -26,     10,   -152,    856,   1144,    100,   1108,    -26,   -152,    100,     10,   -116, &
                   -26,    -26,   -116,     10,   -152,    856,   -116,   -152,    856,   -152,   -368,    856,    100,   -152, &
                   -80,   -368,    -80,   -152,    856,   -116,    -26,    100,    -26,   -116,   -152,     10,    100,   1144, &
                  -908,   7282,    100,   -908,    100,   -152,   -152,    856,    856,   -368,    136,   -908,    -26,   -152, &
                   100,    100,    -26,    100,   1108,    856,   1144,   -152]
  K1( 101,:) = [   -152,    -26,    136,   -152,     10,    -26,    -80,   -116,   -152,     10,   -116,    -26,   -908,    100, &
                   136,    -26,    100,   -152,   -152,    136,    -80,   -152,   -908,    136,   -116,     10,   -152,    856, &
                  -116,   -152,    856,   -152,   -368,    856,    100,   -152,    -80,   -368,    -80,   -152,    856,   -116, &
                   -26,    100,    -26,   -116,   -152,     10,    -80,   -116,   1144,   -152,    208,    136,   -368,    -80, &
                   352,   -368,   1144,    -80,    -80,    -80,   -368,    856,   -152,   -116,    136,   -908,   -152,    -80, &
                   136,   -152,    136,   -152,    208,   -116,   1144,    -80,   -152,    856,   1144,    100,   1108,    -26, &
                  -116,   -116,    -80,   -152,    -26,     10,    100,   -152,    -26,    -26,     10,   -116,    100,   -908, &
                  1144,    100,   7282,   -908,    -26,    100,   1108,    856,   1144,   -152,   -152,    100,    856,   -368, &
                  -152,    856,   -908,    136,    100,    100,    -26,   -152]
  K1( 102,:) = [    -80,   -116,   -152,     10,   -116,    -26,   -152,    -26,    136,   -152,     10,    -26,    136,    -26, &
                  -908,    100,   -152,    100,    -80,   -152,   -152,    136,    136,   -908,    -80,   -116,   1144,   -152, &
                   208,    136,   -368,    -80,    352,   -368,   1144,    -80,    -80,    -80,   -368,    856,   -152,   -116, &
                   136,   -908,   -152,    -80,    136,   -152,   -116,     10,   -152,    856,   -116,   -152,    856,   -152, &
                  -368,    856,    100,   -152,    -80,   -368,    -80,   -152,    856,   -116,    -26,    100,    -26,   -116, &
                  -152,     10,    208,   -116,    136,   -152,    -80,   1144,   -116,   -116,    -80,   -152,    -26,     10, &
                  -152,    856,   1144,    100,   1108,    -26,   -152,    100,     10,   -116,    -26,    -26,   1144,    100, &
                   100,   -908,   -908,   7282,   -152,    100,    856,   -368,   -152,    856,    -26,    100,   1108,    856, &
                  1144,   -152,    136,   -908,    -26,   -152,    100,    100]
  K1( 103,:) = [    136,   -152,    208,   -116,   1144,    -80,   -152,    856,   1144,    100,   1108,    -26,   -116,   -116, &
                   -80,   -152,    -26,     10,    100,   -152,    -26,    -26,     10,   -116,   -908,    100,    136,    -26, &
                   100,   -152,    136,   -152,   -152,    -26,    -26,     10,   -152,     10,    -80,   -116,    -26,   -116, &
                  -908,    136,    136,   -152,   -152,    -80,    -80,   -368,    -80,   -152,    856,   -116,   -152,    856, &
                  -116,     10,   -152,   -116,   -368,    856,    856,   -152,   -152,    100,   -152,     10,    100,    -26, &
                  -116,    -26,    -80,    -80,   -368,    856,   -152,   -116,   1144,   -152,    -80,   -116,    136,    208, &
                   352,   -368,   -368,    -80,    -80,   1144,    136,   -152,   -908,    136,    -80,   -152,   -908,    136, &
                   100,    100,    -26,   -152,   7282,   -908,   -908,    100,    100,   1144,   1144,   -152,    100,    -26, &
                   856,   1108,   -152,    856,    100,   -152,   -368,    856]
  K1( 104,:) = [    208,   -116,    136,   -152,    -80,   1144,   -116,   -116,    -80,   -152,    -26,     10,   -152,    856, &
                  1144,    100,   1108,    -26,   -152,    100,     10,   -116,    -26,    -26,    136,    -26,   -908,    100, &
                  -152,    100,   -152,     10,    -80,   -116,    -26,   -116,    136,   -152,   -152,    -26,    -26,     10, &
                   136,   -908,   -152,    -80,    136,   -152,    -80,    -80,   -368,    856,   -152,   -116,   1144,   -152, &
                   -80,   -116,    136,    208,    352,   -368,   -368,    -80,    -80,   1144,    136,   -152,   -908,    136, &
                   -80,   -152,    -80,   -368,    -80,   -152,    856,   -116,   -152,    856,   -116,     10,   -152,   -116, &
                  -368,    856,    856,   -152,   -152,    100,   -152,     10,    100,    -26,   -116,    -26,    136,   -908, &
                   -26,   -152,    100,    100,   -908,   7282,    100,   1144,   -908,    100,   -152,    856,    100,   -152, &
                  -368,    856,   1144,   -152,    100,    -26,    856,   1108]
  K1( 105,:) = [   -152,    856,   -116,     10,   -152,   -116,    -80,   -368,    -80,   -152,    856,   -116,    856,   -152, &
                  -368,    856,    100,   -152,    100,    -26,   -152,     10,    -26,   -116,    136,   -152,   -152,    -26, &
                   -26,     10,   -908,    100,    136,    -26,    100,   -152,    -80,   -116,   -152,     10,   -116,    -26, &
                   136,   -152,   -908,    136,    -80,   -152,   -152,    856,   1144,    100,   1108,    -26,    136,   -152, &
                   208,   -116,   1144,    -80,    -80,   -152,   -116,   -116,     10,    -26,    -26,    -26,    100,   -152, &
                  -116,     10,   -368,    -80,    352,   -368,   1144,    -80,    -80,   -116,   1144,   -152,    208,    136, &
                  -368,    856,    -80,    -80,   -116,   -152,   -152,    -80,    136,   -908,   -152,    136,    100,    -26, &
                  1144,   -152,   1108,    856,   -908,    100,   7282,   -908,   1144,    100,    100,    100,   -908,    136, &
                  -152,    -26,    856,   -368,   -152,    100,    856,   -152]
  K1( 106,:) = [   1144,   -152,    -80,   -116,    136,    208,    -80,    -80,   -368,    856,   -152,   -116,   -368,    -80, &
                   352,   -368,   1144,    -80,   -908,    136,    136,   -152,   -152,    -80,   -152,     10,    -80,   -116, &
                   -26,   -116,    136,    -26,   -908,    100,   -152,    100,   -152,    -26,    136,   -152,     10,    -26, &
                  -152,    -80,    136,   -908,   -152,    136,   -116,   -116,    -80,   -152,    -26,     10,    208,   -116, &
                   136,   -152,    -80,   1144,   1144,    100,   -152,    856,    -26,   1108,     10,   -116,   -152,    100, &
                   -26,    -26,    856,   -152,   -368,    856,    100,   -152,   -116,     10,   -152,    856,   -116,   -152, &
                   -80,   -152,    -80,   -368,   -116,    856,    -26,   -116,    -26,    100,     10,   -152,    100,   -152, &
                  -152,    856,    856,   -368,    100,   1144,   -908,   7282,    100,   -908,    -26,   -152,    136,   -908, &
                   100,    100,   1108,    856,    -26,    100,   -152,   1144]
  K1( 107,:) = [   -116,     10,   -152,    856,   -116,   -152,    856,   -152,   -368,    856,    100,   -152,    -80,   -368, &
                   -80,   -152,    856,   -116,    -26,    100,    -26,   -116,   -152,     10,   -152,    -26,    136,   -152, &
                    10,    -26,    -80,   -116,   -152,     10,   -116,    -26,   -908,    100,    136,    -26,    100,   -152, &
                  -152,    136,    -80,   -152,   -908,    136,   -368,    -80,    352,   -368,   1144,    -80,    -80,   -116, &
                  1144,   -152,    208,    136,   -368,    856,    -80,    -80,   -116,   -152,   -152,    -80,    136,   -908, &
                  -152,    136,   -152,    856,   1144,    100,   1108,    -26,    136,   -152,    208,   -116,   1144,    -80, &
                   -80,   -152,   -116,   -116,     10,    -26,    -26,    -26,    100,   -152,   -116,     10,    -26,    100, &
                  1108,    856,   1144,   -152,    100,   -908,   1144,    100,   7282,   -908,    856,   -368,   -152,    100, &
                   856,   -152,    100,    100,   -908,    136,   -152,    -26]
  K1( 108,:) = [    -80,   -116,   1144,   -152,    208,    136,   -368,    -80,    352,   -368,   1144,    -80,    -80,    -80, &
                  -368,    856,   -152,   -116,    136,   -908,   -152,    -80,    136,   -152,    -80,   -116,   -152,     10, &
                  -116,    -26,   -152,    -26,    136,   -152,     10,    -26,    136,    -26,   -908,    100,   -152,    100, &
                   -80,   -152,   -152,    136,    136,   -908,    856,   -152,   -368,    856,    100,   -152,   -116,     10, &
                  -152,    856,   -116,   -152,    -80,   -152,    -80,   -368,   -116,    856,    -26,   -116,    -26,    100, &
                    10,   -152,   -116,   -116,    -80,   -152,    -26,     10,    208,   -116,    136,   -152,    -80,   1144, &
                  1144,    100,   -152,    856,    -26,   1108,     10,   -116,   -152,    100,    -26,    -26,   -152,    100, &
                   856,   -368,   -152,    856,   1144,    100,    100,   -908,   -908,   7282,   1108,    856,    -26,    100, &
                  -152,   1144,    -26,   -152,    136,   -908,    100,    100]
  K1( 109,:) = [   -152,    856,   1144,    100,   1108,    -26,    136,   -152,    208,   -116,   1144,    -80,    -80,   -152, &
                  -116,   -116,     10,    -26,    -26,    -26,    100,   -152,   -116,     10,    -80,   -368,    -80,   -152, &
                   856,   -116,   -152,    856,   -116,     10,   -152,   -116,   -368,    856,    856,   -152,   -152,    100, &
                  -152,     10,    100,    -26,   -116,    -26,   -908,    100,    136,    -26,    100,   -152,    136,   -152, &
                  -152,    -26,    -26,     10,   -152,     10,    -80,   -116,    -26,   -116,   -908,    136,    136,   -152, &
                  -152,    -80,   -368,    856,    -80,    -80,   -116,   -152,    352,   -368,   -368,    -80,    -80,   1144, &
                  1144,   -152,    -80,   -116,    136,    208,   -152,    136,    -80,   -152,   -908,    136,    100,    100, &
                  -908,    136,   -152,    -26,   1144,   -152,    100,    -26,    856,   1108,   7282,   -908,   -908,    100, &
                   100,   1144,    856,   -152,   -368,    856,    100,   -152]
  K1( 110,:) = [   -116,   -116,    -80,   -152,    -26,     10,    208,   -116,    136,   -152,    -80,   1144,   1144,    100, &
                  -152,    856,    -26,   1108,     10,   -116,   -152,    100,    -26,    -26,    -80,    -80,   -368,    856, &
                  -152,   -116,   1144,   -152,    -80,   -116,    136,    208,    352,   -368,   -368,    -80,    -80,   1144, &
                   136,   -152,   -908,    136,    -80,   -152,    136,    -26,   -908,    100,   -152,    100,   -152,     10, &
                   -80,   -116,    -26,   -116,    136,   -152,   -152,    -26,    -26,     10,    136,   -908,   -152,    -80, &
                   136,   -152,    -80,   -152,    -80,   -368,   -116,    856,   -368,    856,    856,   -152,   -152,    100, &
                  -152,    856,   -116,     10,   -152,   -116,     10,   -152,   -116,    -26,    100,    -26,    -26,   -152, &
                   136,   -908,    100,    100,   -152,    856,    100,   -152,   -368,    856,   -908,   7282,    100,   1144, &
                  -908,    100,   -152,   1144,    856,   1108,    100,    -26]
  K1( 111,:) = [    -80,   -368,    -80,   -152,    856,   -116,   -152,    856,   -116,     10,   -152,   -116,   -368,    856, &
                   856,   -152,   -152,    100,   -152,     10,    100,    -26,   -116,    -26,   -152,    856,   1144,    100, &
                  1108,    -26,    136,   -152,    208,   -116,   1144,    -80,    -80,   -152,   -116,   -116,     10,    -26, &
                   -26,    -26,    100,   -152,   -116,     10,    136,   -152,   -152,    -26,    -26,     10,   -908,    100, &
                   136,    -26,    100,   -152,    -80,   -116,   -152,     10,   -116,    -26,    136,   -152,   -908,    136, &
                   -80,   -152,    352,   -368,   -368,    -80,    -80,   1144,   -368,    856,    -80,    -80,   -116,   -152, &
                   -80,   -116,   1144,   -152,    208,    136,    -80,   -152,   -152,    136,    136,   -908,   1144,   -152, &
                   100,    -26,    856,   1108,    100,    100,   -908,    136,   -152,    -26,   -908,    100,   7282,   -908, &
                  1144,    100,   -368,    856,    856,   -152,   -152,    100]
  K1( 112,:) = [    -80,    -80,   -368,    856,   -152,   -116,   1144,   -152,    -80,   -116,    136,    208,    352,   -368, &
                  -368,    -80,    -80,   1144,    136,   -152,   -908,    136,    -80,   -152,   -116,   -116,    -80,   -152, &
                   -26,     10,    208,   -116,    136,   -152,    -80,   1144,   1144,    100,   -152,    856,    -26,   1108, &
                    10,   -116,   -152,    100,    -26,    -26,   -152,     10,    -80,   -116,    -26,   -116,    136,    -26, &
                  -908,    100,   -152,    100,   -152,    -26,    136,   -152,     10,    -26,   -152,    -80,    136,   -908, &
                  -152,    136,   -368,    856,    856,   -152,   -152,    100,    -80,   -152,    -80,   -368,   -116,    856, &
                  -116,     10,   -152,    856,   -116,   -152,   -116,    -26,     10,   -152,    -26,    100,   -152,    856, &
                   100,   -152,   -368,    856,    -26,   -152,    136,   -908,    100,    100,    100,   1144,   -908,   7282, &
                   100,   -908,    856,   1108,   -152,   1144,    -26,    100]
  K1( 113,:) = [    856,   -152,   -368,    856,    100,   -152,   -116,     10,   -152,    856,   -116,   -152,    -80,   -152, &
                   -80,   -368,   -116,    856,    -26,   -116,    -26,    100,     10,   -152,   -368,    -80,    352,   -368, &
                  1144,    -80,    -80,   -116,   1144,   -152,    208,    136,   -368,    856,    -80,    -80,   -116,   -152, &
                  -152,    -80,    136,   -908,   -152,    136,   -152,    -26,    136,   -152,     10,    -26,    -80,   -116, &
                  -152,     10,   -116,    -26,   -908,    100,    136,    -26,    100,   -152,   -152,    136,    -80,   -152, &
                  -908,    136,   1144,    100,   -152,    856,    -26,   1108,    -80,   -152,   -116,   -116,     10,    -26, &
                   136,   -152,    208,   -116,   1144,    -80,    -26,    -26,   -116,     10,    100,   -152,   1108,    856, &
                   -26,    100,   -152,   1144,    856,   -368,   -152,    100,    856,   -152,    100,   -908,   1144,    100, &
                  7282,   -908,    100,    100,   -152,    -26,   -908,    136]
  K1( 114,:) = [   -368,    -80,    352,   -368,   1144,    -80,    -80,   -116,   1144,   -152,    208,    136,   -368,    856, &
                   -80,    -80,   -116,   -152,   -152,    -80,    136,   -908,   -152,    136,    856,   -152,   -368,    856, &
                   100,   -152,   -116,     10,   -152,    856,   -116,   -152,    -80,   -152,    -80,   -368,   -116,    856, &
                   -26,   -116,    -26,    100,     10,   -152,    -80,   -116,   -152,     10,   -116,    -26,   -152,    -26, &
                   136,   -152,     10,    -26,    136,    -26,   -908,    100,   -152,    100,    -80,   -152,   -152,    136, &
                   136,   -908,    -80,   -152,   -116,   -116,     10,    -26,   1144,    100,   -152,    856,    -26,   1108, &
                   208,   -116,    136,   -152,    -80,   1144,   -116,     10,    -26,    -26,   -152,    100,    856,   -368, &
                  -152,    100,    856,   -152,   1108,    856,    -26,    100,   -152,   1144,   1144,    100,    100,   -908, &
                  -908,   7282,   -152,    -26,    100,    100,    136,   -908]
  K1( 115,:) = [   1144,    100,   -152,    856,    -26,   1108,    -80,   -152,   -116,   -116,     10,    -26,    136,   -152, &
                   208,   -116,   1144,    -80,    -26,    -26,   -116,     10,    100,   -152,    -80,   -152,    -80,   -368, &
                  -116,    856,   -368,    856,    856,   -152,   -152,    100,   -152,    856,   -116,     10,   -152,   -116, &
                    10,   -152,   -116,    -26,    100,    -26,   -368,    856,    -80,    -80,   -116,   -152,    352,   -368, &
                  -368,    -80,    -80,   1144,   1144,   -152,    -80,   -116,    136,    208,   -152,    136,    -80,   -152, &
                  -908,    136,   -908,    100,    136,    -26,    100,   -152,    136,   -152,   -152,    -26,    -26,     10, &
                  -152,     10,    -80,   -116,    -26,   -116,   -908,    136,    136,   -152,   -152,    -80,    100,    100, &
                  -152,    -26,   -908,    136,   -152,   1144,    856,   1108,    100,    -26,    856,   -152,   -368,    856, &
                   100,   -152,   7282,   -908,   -908,    100,    100,   1144]
  K1( 116,:) = [    -80,   -152,   -116,   -116,     10,    -26,   1144,    100,   -152,    856,    -26,   1108,    208,   -116, &
                   136,   -152,    -80,   1144,   -116,     10,    -26,    -26,   -152,    100,   -368,    856,    -80,    -80, &
                  -116,   -152,    352,   -368,   -368,    -80,    -80,   1144,   1144,   -152,    -80,   -116,    136,    208, &
                  -152,    136,    -80,   -152,   -908,    136,    -80,   -152,    -80,   -368,   -116,    856,   -368,    856, &
                   856,   -152,   -152,    100,   -152,    856,   -116,     10,   -152,   -116,     10,   -152,   -116,    -26, &
                   100,    -26,    136,    -26,   -908,    100,   -152,    100,   -152,     10,    -80,   -116,    -26,   -116, &
                   136,   -152,   -152,    -26,    -26,     10,    136,   -908,   -152,    -80,    136,   -152,   -152,    -26, &
                   100,    100,    136,   -908,    856,   -152,   -368,    856,    100,   -152,   -152,   1144,    856,   1108, &
                   100,    -26,   -908,   7282,    100,   1144,   -908,    100]
  K1( 117,:) = [    -80,   -152,    -80,   -368,   -116,    856,   -368,    856,    856,   -152,   -152,    100,   -152,    856, &
                  -116,     10,   -152,   -116,     10,   -152,   -116,    -26,    100,    -26,   1144,    100,   -152,    856, &
                   -26,   1108,    -80,   -152,   -116,   -116,     10,    -26,    136,   -152,    208,   -116,   1144,    -80, &
                   -26,    -26,   -116,     10,    100,   -152,    352,   -368,   -368,    -80,    -80,   1144,   -368,    856, &
                   -80,    -80,   -116,   -152,    -80,   -116,   1144,   -152,    208,    136,    -80,   -152,   -152,    136, &
                   136,   -908,    136,   -152,   -152,    -26,    -26,     10,   -908,    100,    136,    -26,    100,   -152, &
                   -80,   -116,   -152,     10,   -116,    -26,    136,   -152,   -908,    136,    -80,   -152,   -152,   1144, &
                   856,   1108,    100,    -26,    100,    100,   -152,    -26,   -908,    136,   -368,    856,    856,   -152, &
                  -152,    100,   -908,    100,   7282,   -908,   1144,    100]
  K1( 118,:) = [   -368,    856,    -80,    -80,   -116,   -152,    352,   -368,   -368,    -80,    -80,   1144,   1144,   -152, &
                   -80,   -116,    136,    208,   -152,    136,    -80,   -152,   -908,    136,    -80,   -152,   -116,   -116, &
                    10,    -26,   1144,    100,   -152,    856,    -26,   1108,    208,   -116,    136,   -152,    -80,   1144, &
                  -116,     10,    -26,    -26,   -152,    100,   -368,    856,    856,   -152,   -152,    100,    -80,   -152, &
                   -80,   -368,   -116,    856,   -116,     10,   -152,    856,   -116,   -152,   -116,    -26,     10,   -152, &
                   -26,    100,   -152,     10,    -80,   -116,    -26,   -116,    136,    -26,   -908,    100,   -152,    100, &
                  -152,    -26,    136,   -152,     10,    -26,   -152,    -80,    136,   -908,   -152,    136,    856,   -152, &
                  -368,    856,    100,   -152,   -152,    -26,    100,    100,    136,   -908,    856,   1108,   -152,   1144, &
                   -26,    100,    100,   1144,   -908,   7282,    100,   -908]
  K1( 119,:) = [   -368,    856,    856,   -152,   -152,    100,    -80,   -152,    -80,   -368,   -116,    856,   -116,     10, &
                  -152,    856,   -116,   -152,   -116,    -26,     10,   -152,    -26,    100,    352,   -368,   -368,    -80, &
                   -80,   1144,   -368,    856,    -80,    -80,   -116,   -152,    -80,   -116,   1144,   -152,    208,    136, &
                   -80,   -152,   -152,    136,    136,   -908,   1144,    100,   -152,    856,    -26,   1108,    -80,   -152, &
                  -116,   -116,     10,    -26,    136,   -152,    208,   -116,   1144,    -80,    -26,    -26,   -116,     10, &
                   100,   -152,   -152,    -26,    136,   -152,     10,    -26,    -80,   -116,   -152,     10,   -116,    -26, &
                  -908,    100,    136,    -26,    100,   -152,   -152,    136,    -80,   -152,   -908,    136,    856,   1108, &
                  -152,   1144,    -26,    100,   -368,    856,    856,   -152,   -152,    100,    100,    100,   -152,    -26, &
                  -908,    136,    100,   -908,   1144,    100,   7282,   -908]
  K1( 120,:) = [    352,   -368,   -368,    -80,    -80,   1144,   -368,    856,    -80,    -80,   -116,   -152,    -80,   -116, &
                  1144,   -152,    208,    136,    -80,   -152,   -152,    136,    136,   -908,   -368,    856,    856,   -152, &
                  -152,    100,    -80,   -152,    -80,   -368,   -116,    856,   -116,     10,   -152,    856,   -116,   -152, &
                  -116,    -26,     10,   -152,    -26,    100,    -80,   -152,   -116,   -116,     10,    -26,   1144,    100, &
                  -152,    856,    -26,   1108,    208,   -116,    136,   -152,    -80,   1144,   -116,     10,    -26,    -26, &
                  -152,    100,    -80,   -116,   -152,     10,   -116,    -26,   -152,    -26,    136,   -152,     10,    -26, &
                   136,    -26,   -908,    100,   -152,    100,    -80,   -152,   -152,    136,    136,   -908,   -368,    856, &
                   856,   -152,   -152,    100,    856,   1108,   -152,   1144,    -26,    100,   -152,    -26,    100,    100, &
                   136,   -908,   1144,    100,    100,   -908,   -908,   7282]
  K1( 121,:) = [  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78, &
                  3432,   -456,   3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104,  -2724,    408,    408,   -456, &
                  -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30,   -456,    408,    -78,   -456, &
                   -78,   -348,     30,   -456,   -348,   -240,    300,   -456,    -78,    -78,     30,   -348,   3432,   -240, &
                  -456,    408,   -348,    624,   3324,    -78,   2568,   -456,    300,   3432,    -78,     30,   -348,   -348, &
                  -456,   -240,    300,    -78,   -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348, &
                  2568,   -348,  -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104,  -2724,    408, &
                   408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240, &
                  2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056]
  K1( 122,:) = [  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456, &
                  -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568,    408,  -2724,   -456,   -240, &
                   408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348,     30,   -456,   -348,   -240, &
                   -78,     30,   -456,    408,    -78,   -456,   -456,    300,     30,   -348,    -78,    -78,   -240,   3432, &
                  -348,    624,   -456,    408,    -78,     30,   -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456, &
                   300,   3432,  -2724,    408,    408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240, &
                  -456,   -348,   -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056,    300,    -78, &
                  -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240, &
                  -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104]
  K1( 123,:) = [  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408, &
                   300,    300,    -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568,    408,   -456,  -2724,    408, &
                  -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456,    300,  -2724,    -78,    408, &
                  -348,    -78,   -348,   -240,     30,   -456,    300,    -78,   -456,     30,    -78,   -348,   -456,   -348, &
                  2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,   -456,    -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624, &
                  3324,    -78,   2568,   -456,    300,   3432,    -78,     30,   -348,   -348,   -456,   -240,    408,  -2724, &
                  -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104]
  K1( 124,:) = [    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724, &
                   -78,   -456,    300,    300,    -78,    300,   3324,   2568,   3432,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300,    -78,    408,    300,  -2724, &
                    30,    -78,    -78,   -456,   -456,    408,  -2724,    408,    408,   -456,   -456,   -240,    408,    624, &
                  -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,    300,     30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408, &
                   -78,     30,   -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456,    300,   3432,    -78,    300, &
                   -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456,   -456,   2568, &
                  2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240]
  K1( 125,:) = [    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300, &
                  2568,  -1104,   -456,   2568,  -2724,    408,    300,    300,    -78,   -456,   -456,    408,   -240,   -456, &
                 -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78,   -348,   -240,     30,   -456, &
                   300,   -456,    300,  -2724,    -78,    408,    -78,    300,    -78,   -348,   -456,     30,   -348,   -456, &
                    30,   -348,   2568,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240, &
                  -456,   -240,    408,  -2724,   -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432, &
                  3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104,    300,   -456, &
                   -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78,   2568,   -456, &
                   300,   3432,    -78,     30,   -348,   -348,   -456,   -240]
  K1( 126,:) = [   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300, &
                  3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456,    300,    300,   -240,   -456,   -456,    408, &
                   408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78,    -78,   -456,   -456,    408, &
                  -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,    624,    408, &
                  -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240, &
                  2568,  -1104,    -78,    300,    -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456, &
                   300,   -456,   -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,    300, &
                    30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30,   -348,   -348, &
                  -456,   -240,   3324,    -78,   2568,   -456,    300,   3432]
  K1( 127,:) = [  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456, &
                   300,    -78,   2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568,    300,   -456,    -78,    -78, &
                    30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78,   2568,   -456,    300,   3432, &
                   -78,     30,   -348,   -348,   -456,   -240,  -2724,    408,    408,   -456,   -456,   -240,    300,   -456, &
                   300,  -2724,    -78,    408,    -78,     30,   -456,    408,    -78,   -456,    -78,   -348,     30,   -456, &
                  -348,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240, &
                  -456,   -348,   2568,   -456,     30,   -348,   -456,    300,   2568,  -1104,   -456,   2568,    408,   -456, &
                 -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624,   -456,   3432, &
                  -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104]
  K1( 128,:) = [    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324,   -456,    300,     30,   -348, &
                   -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30,   -348,   -348,   -456,   -240, &
                  3324,    -78,   2568,   -456,    300,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -456,    300, &
                   -78,    408,    300,  -2724,    -78,   -348,     30,   -456,   -348,   -240,    -78,     30,   -456,    408, &
                   -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104, &
                   408,    624,   -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,   -456,     30, &
                   300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456, &
                    30,   -348,   -456,    300,   2568,  -1104,   -456,   2568]
  K1( 129,:) = [    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300, &
                 -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240,   -456,   -240, &
                   300,   -456,   -456,   2568,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,    -78,     30, &
                  -456,    408,    -78,   -456,    300,   -456,    300,  -2724,    -78,    408,   -348,    -78,   -348,   -240, &
                    30,   -456,    -78,    -78,    300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432, &
                  3432,   -240,   -456,    408,   -348,    624,     30,    -78,   -456,   -240,   -348,   -348,   -456,   -240, &
                   408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240, &
                  -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240]
  K1( 130,:) = [    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456, &
                   408,  -2724,    300,    300,   3324,   2568,    -78,    300,   -456,   3432,  -2724,    408,    408,   -456, &
                  -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240,   2568,  -1104, &
                  3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348, &
                    30,   -456,   -348,   -240,   -456,    300,    -78,    408,    300,  -2724,     30,    -78,    -78,   -456, &
                  -456,    408,     30,   -348,   -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240, &
                  -240,   3432,   -348,    624,   -456,    408,    -78,   3324,    300,   3432,   2568,   -456,    -78,   -348, &
                   -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348, &
                  2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240]
  K1( 131,:) = [    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104, &
                  -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,    -78,    300,    -78,   -348, &
                  -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456,   -456,   2568,   2568,  -1104, &
                  2568,   -348,  -1104,   -240,   -456,   -240,   -456,    408,   -240,   -456,  -2724,    408,     30,    -78, &
                   -78,   -456,   -456,    408,   -348,    -78,   -348,   -240,     30,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056, &
                   624,    408,   -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240,    -78,    -78, &
                   300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240,   -456,    408, &
                  -348,    624,     30,    -78,   -456,   -240,   -348,   -348]
  K1( 132,:) = [   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568, &
                   -78,    300,   -456,   3432,    -78,   -456,    408,  -2724,    300,    300,    408,  -2724,   -456,   -240, &
                   408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104,  -1104,   1056, &
                  -456,   -348,   -240,   -240,   2568,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78, &
                  -348,   -240,     30,   -456,     30,    -78,    -78,   -456,   -456,    408,   -456,    300,    -78,    408, &
                   300,  -2724,    -78,   -348,    -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104, &
                  -348,   -456,     30,   -348,   2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -348, &
                  -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432,   -348,    624, &
                  -456,    408,    -78,   3324,    300,   3432,   2568,   -456]
  K1( 133,:) = [    300,    300,  -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724, &
                 -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568,    300,   -456,    -78,    -78,    300,   -456, &
                  -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240,   -456,    408,   -348,    624, &
                    30,    -78,   -456,   -240,   -348,   -348,   -456,     30,    300,    -78,   -348,    -78,   2568,   -348, &
                 -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456,     30,   -348,   -456,    300,   2568,  -1104, &
                  -456,   2568,  -2724,    408,    408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408, &
                   -78,     30,   -456,    408,    -78,   -456,    -78,   -348,     30,   -456,   -348,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,    408,    624,   -456,   3432,   -348,   -240]
  K1( 134,:) = [    -78,   -456,    408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846, &
                   300,   3432,  -2724,    300,   -456,   3432,   2568,   3324,    300,    -78,     30,   -348,   -456,    300, &
                   -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432,   -348,    624,   -456,    408, &
                   -78,   3324,    300,   3432,   2568,   -456,    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348, &
                  -240,   -240,   2568,  -1104,    408,    624,   -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,    408,  -2724,   -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724, &
                   -78,   -348,     30,   -456,   -348,   -240,    -78,     30,   -456,    408,    -78,   -456,     30,   -456, &
                  -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -456,   -348,   2568,   -456,     30,   -348]
  K1( 135,:) = [   3432,   -456,    300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300, &
                 21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78, &
                  -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456,     30,   -348, &
                  -456,    300,   2568,  -1104,   -456,   2568,    -78,    -78,    300,   -456,   -348,     30,   3324,    -78, &
                  2568,   -456,    300,   3432,   3432,   -240,   -456,    408,   -348,    624,     30,    -78,   -456,   -240, &
                  -348,   -348,    408,   -456,  -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456, &
                   300,   -456,    300,  -2724,    -78,    408,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104, &
                  -240,   -240,    624,    408,   -348,   -240,   -456,   3432]
  K1( 136,:) = [   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432, &
                 -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432,    -78,    300,    408,   -456,  -2724,    408, &
                  -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624,   -456,   3432,   -348,   -240, &
                  -240,   3432,  -1104,   1056,   -240,  -1104,     30,   -348,   -456,    300,    -78,    -78,    -78,     30, &
                  -348,   -348,   -456,   -240,   -240,   3432,   -348,    624,   -456,    408,    -78,   3324,    300,   3432, &
                  2568,   -456,   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240, &
                  -456,    300,    -78,    408,    300,  -2724,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78, &
                    30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240, &
                 -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456]
  K1( 137,:) = [   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724, &
                  3432,    300,  21846,  -2724,    300,    300,   -456,    -78,  -2724,    408,    -78,   -348,    -78,    300, &
                    30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348,   2568,   -456, &
                  -348,   2568,   -456,   -240,  -1104,   -240,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104, &
                  -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408, &
                  -348,    -78,   -348,   -240,     30,   -456,    300,   -456,    300,  -2724,    -78,    408,    -78,    -78, &
                  -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78,   -456,   -240, &
                  -348,   -348,   3432,   -240,   -456,    408,   -348,    624]
  K1( 138,:) = [   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300, &
                   300,  -2724,  -2724,  21846,   -456,    -78,    300,    300,    408,  -2724,   -456,   -240,    408,  -2724, &
                  -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240,   -456,   3432, &
                  -348,   -456,   2568,  -1104,   -240,   -240,    -78,   -348,    -78,    300,     30,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348,   2568,   -456,   -348,   2568,   -456,   -240, &
                 -1104,   -240,   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456, &
                    30,    -78,    -78,   -456,   -456,    408,   -456,    300,    -78,    408,    300,  -2724,   -348,     30, &
                   -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324,    300,   3432, &
                  2568,   -456,   -240,   3432,   -348,    624,   -456,    408]
  K1( 139,:) = [    300,    300,   -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456, &
                 -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,    -78,    -78,   -348,     30, &
                   300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78,   -456,   -240,   -348,   -348, &
                  3432,   -240,   -456,    408,   -348,    624,     30,   -456,   -348,    -78,    300,    -78,   -348,   2568, &
                  -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456, &
                    30,   -348,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240, &
                  -240,   3432,  -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408, &
                   408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30,   -456,    408, &
                   -78,   -456,    -78,   -348,     30,   -456,   -348,   -240]
  K1( 140,:) = [   -456,    -78,    300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432, &
                  2568,   3324,    300,    -78,  -2724,  21846,    300,   3432,  -2724,    300,   -348,     30,    -78,    -78, &
                  -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324,    300,   3432,   2568,   -456, &
                  -240,   3432,   -348,    624,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456, &
                  2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432, &
                  -348,   -240,     30,   -456,   -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240, &
                  -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,    408,  -2724, &
                  -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348,     30,   -456, &
                  -348,   -240,    -78,     30,   -456,    408,    -78,   -456]
  K1( 141,:) = [   -456,   3432,   2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568, &
                  2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724,   3432,    300,     30,   -456,   -348,    -78, &
                   300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104,   -456,   2568, &
                  -456,   -348,   2568,   -456,     30,   -348,    -78,    -78,   -348,     30,    300,   -456,    -78,   3324, &
                   300,   3432,   2568,   -456,     30,    -78,   -456,   -240,   -348,   -348,   3432,   -240,   -456,    408, &
                  -348,    624,   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104, &
                  -348,   -456,   2568,  -1104,   -240,   -240,    624,    408,   -348,   -240,   -456,   3432,    408,   -456, &
                 -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,   -348,    -78,   -348,   -240,     30,   -456]
  K1( 142,:) = [   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324, &
                  -456,   3432,    -78,    300,    300,   3432,  -2724,  21846,    300,  -2724,   -456,    408,   -240,   -456, &
                 -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104, &
                   408,    624,   -456,   3432,   -348,   -240,   -348,     30,    -78,    -78,   -456,    300,     30,    -78, &
                  -456,   -240,   -348,   -348,    -78,   3324,    300,   3432,   2568,   -456,   -240,   3432,   -348,    624, &
                  -456,    408,   -348,    -78,     30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568, &
                  -348,   2568,   -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456,   -456,   -240, &
                   408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300,    -78,    408, &
                   300,  -2724,     30,    -78,    -78,   -456,   -456,    408]
  K1( 143,:) = [   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300, &
                  -456,    -78,  -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724,   -348,    -78,     30,   -456, &
                   -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240,  -1104,   -240, &
                  -348,   -456,     30,   -348,   2568,   -456,   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104,   -240,   -240,    624,    408,   -348,   -240, &
                  -456,   3432,    -78,    -78,   -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456, &
                    30,    -78,   -456,   -240,   -348,   -348,   3432,   -240,   -456,    408,   -348,    624,   -456,    408, &
                  -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78,   -348,   -240, &
                    30,   -456,    300,   -456,    300,  -2724,    -78,    408]
  K1( 144,:) = [  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78, &
                   300,    300,    408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104,   -240,   -240, &
                   624,    408,   -348,   -240,   -456,   3432,   -348,    -78,     30,   -456,    -78,    300,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348, &
                  2568,   -456,   -348,     30,    -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348, &
                   -78,   3324,    300,   3432,   2568,   -456,   -240,   3432,   -348,    624,   -456,    408,   -240,   -456, &
                  -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78,    -78,   -456, &
                  -456,    408,   -456,    300,    -78,    408,    300,  -2724]
  K1( 145,:) = [  -2724,    408,    408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30, &
                  -456,    408,    -78,   -456,    -78,   -348,     30,   -456,   -348,   -240,  21846,  -2724,  -2724,    300, &
                   300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78,   3432,   -456,   3324,   2568, &
                   300,   -456,   -456,   2568,   2568,  -1104,   3432,   -240,   -456,    408,   -348,    624,    300,   -456, &
                   -78,    -78,     30,   -348,   2568,   -456,   3324,    -78,   3432,    300,   -348,   -348,    -78,     30, &
                  -240,   -456,   -456,   -348,   2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348, &
                 -1104,   -240,   2568,   -348,   -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568,    408,    624, &
                  -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104]
  K1( 146,:) = [    408,  -2724,   -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348, &
                    30,   -456,   -348,   -240,    -78,     30,   -456,    408,    -78,   -456,  -2724,  21846,    300,   3432, &
                 -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456,   -456,   2568,   2568,  -1104, &
                   300,    -78,   3432,   -456,   3324,   2568,   -240,   3432,   -348,    624,   -456,    408,   -456,    300, &
                    30,   -348,    -78,    -78,   -348,   -348,    -78,     30,   -240,   -456,   2568,   -456,   3324,    -78, &
                  3432,    300,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240, &
                  -240,   -240,   -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104,   -456,   -348, &
                  2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348, &
                  -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568]
  K1( 147,:) = [    408,   -456,  -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456, &
                   300,  -2724,    -78,    408,   -348,    -78,   -348,   -240,     30,   -456,  -2724,    300,  21846,  -2724, &
                  3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408,    300,    300,    -78,   -456, &
                  -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,    300,    -78, &
                  -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456,   -456,   2568,    300,   -456, &
                 -1104,   2568,   3432,   -240,   -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348, &
                  2568,   -456,   3324,    -78,   3432,    300,   -348,   -348,    -78,     30,   -240,   -456,    624,    408, &
                  -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568]
  K1( 148,:) = [   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300, &
                   -78,    408,    300,  -2724,     30,    -78,    -78,   -456,   -456,    408,    300,   3432,  -2724,  21846, &
                   300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456,    300,    300, &
                   -78,    300,   3324,   2568,   3432,   -456,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408, &
                   408,   -456,   -456,   -240,   -240,   -240,   -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -240,   3432,   -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78, &
                  -348,   -348,    -78,     30,   -240,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -348,   -456, &
                    30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568,    300,   -456, &
                 -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456]
  K1( 149,:) = [   -456,    408,   -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78, &
                  -348,   -240,     30,   -456,    300,   -456,    300,  -2724,    -78,    408,    300,  -2724,   3432,    300, &
                 21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104,   -456,   2568, &
                 -2724,    408,    300,    300,    -78,   -456,   -348,   -456,     30,   -348,   2568,   -456,    -78,    300, &
                   -78,   -348,   -456,     30,   -456,   2568,    300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348, &
                  -240,   -456,    624,    408,   -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456, &
                  -240,  -1104,   3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568,   3432,   -240, &
                  -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456,   3324,    -78, &
                  3432,    300,   -348,   -348,    -78,     30,   -240,   -456]
  K1( 150,:) = [   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78, &
                   -78,   -456,   -456,    408,   -456,    300,    -78,    408,    300,  -2724,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568,   3432,   -456, &
                   408,  -2724,    -78,   -456,    300,    300,    624,    408,   -348,   -240,   -456,   3432,    408,  -2724, &
                  -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -348,   -456,     30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30, &
                  -456,   2568,    300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,   -240,   3432, &
                  -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348,    -78,     30, &
                  -240,   -456,   2568,   -456,   3324,    -78,   3432,    300]
  K1( 151,:) = [    300,   -456,    -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78, &
                  2568,   -456,    300,   3432,    -78,     30,   -348,   -348,   -456,   -240,  -2724,    408,    300,    300, &
                   -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456,    300,    -78,   2568,   3324, &
                  -456,   2568,    300,   -456,  -1104,   2568,    300,   -456,    300,  -2724,    -78,    408,  -2724,    408, &
                   408,   -456,   -456,   -240,   -456,    408,    -78,     30,   -456,    -78,     30,   -456,    -78,   -348, &
                  -240,   -348,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78, &
                  2568,   -456,   -456,   -348,   -348,     30,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -348, &
                  -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432,    408,    624, &
                  -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240]
  K1( 152,:) = [   -456,    300,     30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30, &
                  -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456,    300,   3432,    408,  -2724,    -78,   -456, &
                   300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568,    300,   -456,  -1104,   2568, &
                  3432,   -456,    300,    -78,   2568,   3324,   -456,    300,    -78,    408,    300,  -2724,    408,  -2724, &
                  -456,   -240,    408,   -456,     30,   -456,    -78,   -348,   -240,   -348,   -456,    408,    -78,     30, &
                  -456,    -78,   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456, &
                  -456,   3432,    408,    624,   -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,   -348, &
                 -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456,   -456,   -348, &
                  -348,     30,   2568,  -1104,   -456,    300,   2568,   -456]
  K1( 153,:) = [    300,    -78,   -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348, &
                 -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456, &
                  3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300,  -2724,    408,   -456,    -78, &
                  2568,  -1104,   -456,    300,   2568,   -456,    -78,     30,   -456,    408,    -78,   -456,    408,   -456, &
                 -2724,    408,   -240,   -456,    300,  -2724,    300,   -456,    408,    -78,   -348,   -240,   -348,    -78, &
                  -456,     30,   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30, &
                  -456,    408,   3432,   -240,    624,   -348,   -456,   -240,     30,    -78,   -348,   -348,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240,    624,    408, &
                  3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240]
  K1( 154,:) = [  -2724,    408,    408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348, &
                  -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724,    300,    300, &
                  3324,   2568,    -78,    300,   -456,   3432,    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240, &
                   408,  -2724,   -456,    408,    -78,    408,   -456,    300,  -2724,    300,    -78,   -456,     30,    -78, &
                   408,   -456,    -78,     30,   -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78, &
                  -348,    624,   -240,   3432,    408,   -456,    300,   3432,    -78,   3324,   -456,   2568,    300,   -456, &
                  -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348,   -348,   -456, &
                  -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104]
  K1( 155,:) = [    -78,    300,    -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240,    -78,    300,   3324,   2568, &
                  3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300,   2568,   -456, &
                   300,    300,  -2724,    408,   -456,    -78,     30,    -78,    -78,   -456,   -456,    408,   -456,    408, &
                  -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78,   -456,     30,    300,  -2724,    300,   -456, &
                   408,    -78,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408, &
                  -348,   -240,    624,    408,   3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240,   3324,    -78, &
                  2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408,   3432,   -240, &
                   624,   -348,   -456,   -240,     30,    -78,   -348,   -348]
  K1( 156,:) = [    408,  -2724,   -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104,   -456,    300,   2568,  -1104, &
                  -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300,   -456,   3432, &
                   -78,   -456,    408,  -2724,    300,    300,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,    -78,   -456,     30,    -78,    408,   -456,    -78,    408,   -456,    300, &
                 -2724,    300,    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456, &
                    30,   -348,   -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104,    -78,     30, &
                  -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624,   -240,   3432, &
                   408,   -456,    300,   3432,    -78,   3324,   -456,   2568]
  K1( 157,:) = [    -78,    -78,    300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240, &
                  -456,    408,   -348,    624,     30,    -78,   -456,   -240,   -348,   -348,    300,    300,  -2724,    408, &
                  -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300,    300,   3432, &
                  2568,   -456,  -1104,   2568,    300,   -456,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30, &
                   300,    -78,   -348,    -78,   2568,   -456,   -456,   -348,   -348,     30,   2568,  -1104,   -456,    300, &
                  2568,   -456,    300,   -456,    300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240, &
                  -456,    408,    -78,     30,   -456,    -78,     30,   -456,    -78,   -348,   -240,   -348,   -348,   -456, &
                  2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   -456,   3432,    408,    624,   -240,   -348]
  K1( 158,:) = [     30,   -348,   -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432, &
                  -348,    624,   -456,    408,    -78,   3324,    300,   3432,   2568,   -456,    -78,   -456,    408,  -2724, &
                   300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432,  -2724,    300, &
                  -456,   3432,   2568,   3324,    300,    -78,   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456, &
                 -2724,    408,   -240,   -456,   -456,   3432,    408,    624,   -240,   -348,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456, &
                    30,   -456,    -78,   -348,   -240,   -348,   -456,    408,    -78,     30,   -456,    -78,   -348,   2568, &
                  -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104,   -456,    300, &
                  2568,   -456,   2568,   -456,   -456,   -348,   -348,     30]
  K1( 159,:) = [   -456,     30,    300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348, &
                  2568,   -456,     30,   -348,   -456,    300,   2568,  -1104,   -456,   2568,   3432,   -456,    300,    -78, &
                  2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724,   3432,    300, &
                 -1104,   2568,   2568,   -456,   -456,    300,   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78, &
                   300,   -456,   -348,     30,   -456,    408,   3432,   -240,    624,   -348,   -456,   -240,     30,    -78, &
                  -348,   -348,    -78,     30,   -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456, &
                   300,  -2724,    300,   -456,    408,    -78,   -348,   -240,   -348,    -78,   -456,     30,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456, &
                  -240,   -240,   -348,   -240,    624,    408,   3432,   -456]
  K1( 160,:) = [    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624, &
                  -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,   -456,   2568,    300,   -456, &
                 -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432,  -2724,  21846,    300,  -2724, &
                  2568,   3324,   -456,   3432,    -78,    300,    -78,     30,   -348,   -348,   -456,   -240,     30,   -348, &
                  -456,    300,    -78,    -78,   -348,    624,   -240,   3432,    408,   -456,    300,   3432,    -78,   3324, &
                  -456,   2568,    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408, &
                   -78,    408,   -456,    300,  -2724,    300,    -78,   -456,     30,    -78,    408,   -456,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240,   -348,   2568, &
                  -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568]
  K1( 161,:) = [    -78,   -348,    -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456, &
                    30,   -348,   2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240,   3324,   2568,    -78,    300, &
                  -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724,   3432,    300,  21846,  -2724, &
                   300,    300,   -456,    -78,  -2724,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240, &
                   408,  -2724,   -456,    408,   -348,   -240,    624,    408,   3432,   -456,   2568,  -1104,   -348,   -456, &
                  -240,   -240,     30,    -78,    -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408, &
                  -348,   -240,   -348,    -78,   -456,     30,    300,  -2724,    300,   -456,    408,    -78,    -78,   3324, &
                   300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240,     30,    -78, &
                  -348,   -348,   -456,    408,   3432,   -240,    624,   -348]
  K1( 162,:) = [   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408, &
                  -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240,   2568,  -1104,   -456,    300, &
                  2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300,    300,  -2724,  -2724,  21846, &
                  -456,    -78,    300,    300,    408,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348, &
                   -78,    300,     30,   -456,     30,   -348,   -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568, &
                  -240,  -1104,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724, &
                   -78,   -456,     30,    -78,    408,   -456,    -78,    408,   -456,    300,  -2724,    300,     30,    -78, &
                  -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432,    -78,   3324, &
                  -456,   2568,   -348,    624,   -240,   3432,    408,   -456]
  K1( 163,:) = [    -78,    -78,   -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78, &
                  -456,   -240,   -348,   -348,   3432,   -240,   -456,    408,   -348,    624,    300,    300,   -456,    -78, &
                 -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568,    300,   -456, &
                 21846,  -2724,  -2724,    300,    300,   3432,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456, &
                  -348,    -78,    300,    -78,   2568,  -1104,   -456,    300,   2568,   -456,   2568,   -456,   -456,   -348, &
                  -348,     30,   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408, &
                 -1104,   1056,   -240,   3432,  -1104,   -240,   -456,   3432,    408,    624,   -240,   -348,    300,   -456, &
                   300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408,    -78,     30, &
                  -456,    -78,     30,   -456,    -78,   -348,   -240,   -348]
  K1( 164,:) = [   -348,     30,    -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324, &
                   300,   3432,   2568,   -456,   -240,   3432,   -348,    624,   -456,    408,   -456,    -78,    300,    300, &
                   408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324,    300,    -78, &
                 -2724,  21846,    300,   3432,  -2724,    300,   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,   3432,    408,    624, &
                  -240,   -348,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78, &
                  2568,  -1104,   -456,    300,   2568,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,    300, &
                   -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456,    -78,   -348, &
                  -240,   -348,   -456,    408,    -78,     30,   -456,    -78]
  K1( 165,:) = [     30,   -456,   -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,   -456,   3432,   2568,   3324, &
                   300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456,   -456,    300, &
                 -2724,    300,  21846,  -2724,   3432,    300,    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78, &
                  -348,     30,    300,   -456,   -456,   -240,     30,    -78,   -348,   -348,   -456,    408,   3432,   -240, &
                   624,   -348,   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724, &
                  2568,  -1104,   -348,   -456,   -240,   -240,   -348,   -240,    624,    408,   3432,   -456,    -78,     30, &
                  -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724,    300,   -456, &
                   408,    -78,   -348,   -240,   -348,    -78,   -456,     30]
  K1( 166,:) = [   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432,   -348,   -240,   2568,   -456,  -1104,   2568, &
                   300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324,   -456,   3432,    -78,    300, &
                   300,   3432,  -2724,  21846,    300,  -2724,     30,    -78,   -456,   -240,   -348,   -348,   -348,     30, &
                   -78,    -78,   -456,    300,    300,   3432,    -78,   3324,   -456,   2568,   -348,    624,   -240,   3432, &
                   408,   -456,   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300, &
                  -456,   -240,   -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348, &
                    30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408,   -456,    300, &
                 -2724,    300,    -78,   -456,     30,    -78,    408,   -456]
  K1( 167,:) = [   -348,    -78,     30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568, &
                  -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456,   2568,   3324,   -456,   3432, &
                   -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300,   -456,    -78,  -2724,    408, &
                   300,  -2724,   3432,    300,  21846,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456, &
                  -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456,   -240,   -240,   -348,   -240,    624,    408, &
                  3432,   -456,    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456, &
                  -456,   -240,     30,    -78,   -348,   -348,   -456,    408,   3432,   -240,    624,   -348,     30,    -78, &
                   -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78, &
                  -456,     30,    300,  -2724,    300,   -456,    408,    -78]
  K1( 168,:) = [   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456, &
                  2568,  -1104,   -240,   -240,    624,    408,   -348,   -240,   -456,   3432,  -1104,   2568,   2568,   -456, &
                  -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78,    300,    300,    408,  -2724, &
                  3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78, &
                    30,   -456,    -78,    300,   -456,   -240,   -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456, &
                  -456,   2568,     30,    -78,   -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300, &
                   300,   3432,    -78,   3324,   -456,   2568,   -348,    624,   -240,   3432,    408,   -456,   -348,    -78, &
                  -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456,     30,    -78, &
                   408,   -456,    -78,    408,   -456,    300,  -2724,    300]
  K1( 169,:) = [    300,   -456,    300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408, &
                   -78,     30,   -456,    -78,     30,   -456,    -78,   -348,   -240,   -348,   3432,   -240,   -456,    408, &
                  -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456,   3324,    -78,   3432,    300, &
                  -348,   -348,    -78,     30,   -240,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408, &
                   300,    300,    -78,   -456,    300,    -78,   3432,   -456,   3324,   2568,    300,   -456,   -456,   2568, &
                  2568,  -1104,   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456, &
                   300,    -78,   -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432, &
                   408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456, &
                  -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240]
  K1( 170,:) = [   -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456, &
                   -78,   -348,   -240,   -348,   -456,    408,    -78,     30,   -456,    -78,   -240,   3432,   -348,    624, &
                  -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348,    -78,     30,   -240,   -456, &
                  2568,   -456,   3324,    -78,   3432,    300,  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724, &
                   -78,   -456,    300,    300,    300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456, &
                  3324,   2568,   -456,   3432,    408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568, &
                 -2724,    408,    408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240,   2568,   -456, &
                  -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456]
  K1( 171,:) = [    -78,     30,   -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724, &
                   300,   -456,    408,    -78,   -348,   -240,   -348,    -78,   -456,     30,   -456,   -348,   2568,   -456, &
                    30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456, &
                  -456,   2568,    300,   -456,  -1104,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78, &
                  3432,   -456,   3324,   2568,  -2724,    408,    300,    300,    -78,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -456,    408,   3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300, &
                   300,   -456,    -78,    -78,     30,   -348,   -348,   -348,   -240,   -456,    -78,     30,   -348,   -240, &
                   624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240, &
                   408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348]
  K1( 172,:) = [    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408, &
                  -456,    300,  -2724,    300,    -78,   -456,     30,    -78,    408,   -456,    408,    624,   -456,   3432, &
                  -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240,   -456,   -348,  -1104,   2568, &
                  -240,  -1104,   3432,   -240,   1056,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456, &
                  -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456,    300,    300,    -78,    300,   3324,   2568, &
                  3432,   -456,   -348,    624,   -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456, &
                  -456,    300,     30,   -348,    -78,    -78,   -456,   2568,   3432,    300,   3324,    -78,     30,   -348, &
                  -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300,    -78,   -348, &
                  -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348]
  K1( 173,:) = [     30,    -78,    -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240, &
                  -348,    -78,   -456,     30,    300,  -2724,    300,   -456,    408,    -78,   -348,   -456,     30,   -348, &
                  2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568,    300,   -456,  -1104,   2568, &
                 -1104,   -240,   2568,   -348,   -240,   -456,    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300, &
                  3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104,   -456,   2568,  -2724,    408,    300,    300, &
                   -78,   -456,   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104, &
                   408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   -456,    408, &
                  3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456,    -78,    -78, &
                    30,   -348,   -348,   -348,   -240,   -456,    -78,     30]
  K1( 174,:) = [   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456, &
                    30,    -78,    408,   -456,    -78,    408,   -456,    300,  -2724,    300,    624,    408,   -348,   -240, &
                  -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104, &
                  -240,   -240,   -456,   -348,  -1104,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300, &
                  2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456, &
                   300,    300,     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568, &
                   -78,    300,    -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348,   -348,    624, &
                  -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300,     30,   -348, &
                   -78,    -78,   -456,   2568,   3432,    300,   3324,    -78]
  K1( 175,:) = [   3432,   -240,   -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456, &
                  3324,    -78,   3432,    300,   -348,   -348,    -78,     30,   -240,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408,    -78,     30,   -456,    -78, &
                    30,   -456,    -78,   -348,   -240,   -348,  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724, &
                 -2724,    300,    300,   3432,   3432,   -456,    300,    -78,   2568,   3324,   -456,   2568,    300,   -456, &
                 -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30, &
                  -456,     30,    300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -240, &
                  -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456,  -2724,    408, &
                  -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432]
  K1( 176,:) = [   -240,   3432,   -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348, &
                   -78,     30,   -240,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -456,    300,    -78,    408, &
                   300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456,    -78,   -348,   -240,   -348, &
                  -456,    408,    -78,     30,   -456,    -78,    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846, &
                   300,   3432,  -2724,    300,   -456,   2568,    300,   -456,  -1104,   2568,   3432,   -456,    300,    -78, &
                  2568,   3324,   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348, &
                   408,   -456,  -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   -240, &
                  2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30,    300,    -78, &
                  -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300]
  K1( 177,:) = [   -456,   -348,   2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240, &
                  2568,   -348,   -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568,    -78,     30,   -456,    408, &
                   -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724,    300,   -456,    408,    -78, &
                  -348,   -240,   -348,    -78,   -456,     30,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300, &
                 21846,  -2724,   3432,    300,    300,    300,  -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300, &
                  2568,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348, &
                   -78,    -78,    300,   -456,   -348,     30,   -240,   -456,   -348,   -348,     30,    -78,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456]
  K1( 178,:) = [    408,    624,   -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240, &
                  -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104,    -78,   -348,     30,   -456, &
                  -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408,   -456,    300,  -2724,    300, &
                   -78,   -456,     30,    -78,    408,   -456,    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432, &
                 -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724,    300,    300,   3324,   2568,    -78,    300, &
                  -456,   3432,   -348,   -348,    -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456, &
                    30,   -348,   -456,    300,    -78,    -78,   3432,    300,   -456,   2568,    -78,   3324,   -456,   2568, &
                   300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348,    -78,    300, &
                    30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568]
  K1( 179,:) = [   -348,   -456,     30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568, &
                   300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,     30,    -78,    -78,   -456, &
                  -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78,   -456,     30, &
                   300,  -2724,    300,   -456,    408,    -78,    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724, &
                  3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408, &
                  -456,    -78,   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456, &
                  -456,   -240,    408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   2568,   -456, &
                  3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78,    300,   -456, &
                  -348,     30,   -240,   -456,   -348,   -348,     30,    -78]
  K1( 180,:) = [    624,    408,   -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568,   -348,    -78,   -348,   -240, &
                    30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456,     30,    -78,    408,   -456, &
                   -78,    408,   -456,    300,  -2724,    300,   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300, &
                   300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300,   -456,   3432,    -78,   -456,    408,  -2724, &
                   300,    300,   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568, &
                   -78,   -348,    -78,    300,     30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,   -348, &
                   -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348,   -456,    300, &
                   -78,    -78,   3432,    300,   -456,   2568,    -78,   3324]
  K1( 181,:) = [   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408, &
                  3432,   -240,    624,   -348,   -456,   -240,     30,    -78,   -348,   -348,   2568,   -348,  -1104,   -240, &
                  -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456,   -456,   -348,   -348,     30, &
                  2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,   3432,   -456, &
                   300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568, &
                   300,   -456,    300,  -2724,    300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78, &
                 -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348,    -78,   -348,   2568,  -1104, &
                  -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456, &
                 -2724,    408,   3432,   -456,   -240,   -348,    408,    624]
  K1( 182,:) = [    -78,     30,   -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624, &
                  -240,   3432,    408,   -456,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -348,   -240,   -240, &
                  2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432,    408,    624,   -240,   -348, &
                 -1104,   1056,   -240,   3432,  -1104,   -240,    -78,   -456,    408,  -2724,    300,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   3432,   2568,   3324, &
                   300,    -78,    -78,    408,   -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348, &
                   408,  -2724,   -456,   -240,    408,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,   -240, &
                  -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456,   -348,    -78, &
                   300,    -78,   -456,   2568,   -348,     30,   -456,   -348]
  K1( 183,:) = [   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456, &
                  -456,   -348,   -348,     30,   2568,  -1104,   -456,    300,   2568,   -456,   3324,    -78,   2568,   -456, &
                   300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408,   3432,   -240,    624,   -348, &
                  -456,   -240,     30,    -78,   -348,   -348,   3432,   -456,    300,    -78,   2568,   3324,    300,    300, &
                 -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -456,    408,    -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78, &
                   408,   -456,  -2724,    408,   -240,   -456,   -240,   -348,   -456,     30,   -348,    -78,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   -348,   3432,   -456,    624,    408]
  K1( 184,:) = [   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432, &
                   408,    624,   -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240,    -78,     30,   -348,   -348, &
                  -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624,   -240,   3432,    408,   -456, &
                   300,   3432,    -78,   3324,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456, &
                   408,  -2724,    300,    300,    300,   3432,  -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432, &
                   -78,    300,     30,   -456,    -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300, &
                  -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   2568,  -1104, &
                  -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456, &
                   -78,    300,   -348,     30,   -456,   2568,   -348,   -456]
  K1( 185,:) = [    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348, &
                  -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240,    624,    408,   3432,   -456, &
                  2568,  -1104,   -348,   -456,   -240,   -240,   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104, &
                  -456,    300,   2568,   -456,    300,  -2724,   3432,    300,  21846,  -2724,    300,    300,   -456,    -78, &
                 -2724,    408,    -78,   -456,     30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30, &
                  -456,    408,   -240,   -456,  -2724,    408,  -2724,    300,    408,    -78,    300,   -456,    300,   3432, &
                   -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78,   -348,     30, &
                   300,   -456,    408,   -456,    624,   -348,   3432,   -240]
  K1( 186,:) = [   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240, &
                   624,    408,   3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240,    300,   -456,   -456,   2568, &
                  2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348,   -348,   -456,   -456,   2568, &
                  -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568, &
                   -78,    300,   -456,   3432,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    -78,    300,    300, &
                   408,  -2724,   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456, &
                  -240,   -456,   -456,    408,    408,  -2724,    408,    -78,  -2724,    300,   -456,    300,   -456,   -240, &
                    30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30,    -78,    -78, &
                  -456,    300,    624,   -348,    408,   -456,   -240,   3432]
  K1( 187,:) = [    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240, &
                    30,    -78,   -348,   -348,   -456,    408,   3432,   -240,    624,   -348,   -348,   2568,   -456,   -240, &
                 -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104,   -456,    300,   2568,   -456, &
                  2568,   -456,   -456,   -348,   -348,     30,    300,    300,   -456,    -78,  -2724,    408,   -456,   3432, &
                  2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300, &
                   300,   3432,   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240, &
                  -456,    408,   -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348,    408,    624,    300,  -2724, &
                   300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408,    408,   -456, &
                  -456,   -240,   -456,     30,   -240,   -348,    -78,   -348]
  K1( 188,:) = [     30,    -78,   -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432, &
                   -78,   3324,   -456,   2568,   -348,    624,   -240,   3432,    408,   -456,   -348,   -456,   2568,  -1104, &
                  -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432,  -1104,   -240, &
                  -456,   3432,    408,    624,   -240,   -348,   -456,    -78,    300,    300,    408,  -2724,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324,    300,    -78,  -2724,  21846,    300,   3432, &
                 -2724,    300,   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456, &
                    30,   -456,   -348,    -78,    300,    -78,   -456,   2568,   -348,     30,   -456,   -348,    -78,    408, &
                  -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240, &
                   408,   -456,    408,   -456,   -456,    -78,    -78,     30]
  K1( 189,:) = [   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104, &
                  -456,    300,   2568,   -456,   2568,   -456,   -456,   -348,   -348,     30,    -78,   3324,    300,   3432, &
                  2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240,     30,    -78,   -348,   -348, &
                  -456,    408,   3432,   -240,    624,   -348,   -456,   3432,   2568,   3324,    300,    -78,    300,    300, &
                  -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724, &
                  3432,    300,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240, &
                  -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456,    624,    408,   -456,    408, &
                   -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456,  -2724,    408, &
                  -240,   -456,   -240,   -348,   -456,     30,   -348,    -78]
  K1( 190,:) = [   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   -456,   3432,    408,    624,   -240,   -348,     30,    -78,   -456,   -240, &
                  -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432,    -78,   3324,   -456,   2568, &
                  -348,    624,   -240,   3432,    408,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78, &
                   300,    300,    408,  -2724,   2568,   3324,   -456,   3432,    -78,    300,    300,   3432,  -2724,  21846, &
                   300,  -2724,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104, &
                  -348,    -78,     30,   -456,    -78,    300,   -348,     30,   -456,   2568,   -348,   -456,     30,   -456, &
                   -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240,    408,  -2724, &
                  -456,    408,   -456,    -78,    408,   -456,     30,    -78]
  K1( 191,:) = [   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240, &
                  -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456,   -240,   -240, &
                  -348,   -240,    624,    408,   3432,   -456,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568, &
                  2568,   -456,   -456,    300,    300,    300,   -456,    -78,  -2724,    408,    300,  -2724,   3432,    300, &
                 21846,  -2724,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348, &
                   -78,    -78,   -348,     30,    300,   -456,    408,   -456,    624,   -348,   3432,   -240,    -78,   -456, &
                    30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408,   -240,   -456, &
                 -2724,    408,  -2724,    300,    408,    -78,    300,   -456]
  K1( 192,:) = [   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104, &
                  -348,   -456,   -240,   -240,   -348,   -240,    624,    408,   3432,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240,   -348,   2568,   -240,  -1104, &
                    30,   -348,   -348,   -456,   -456,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324, &
                  -456,   3432,    -78,    300,   -456,    -78,    300,    300,    408,  -2724,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,   -240,     30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568, &
                  -348,     30,    -78,    -78,   -456,    300,    624,   -348,    408,   -456,   -240,   3432,   -348,   -240, &
                  -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456,   -456,    408, &
                   408,  -2724,    408,    -78,  -2724,    300,   -456,    300]
  K1( 193,:) = [    300,  -2724,    300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408, &
                   408,   -456,   -456,   -240,   -456,     30,   -240,   -348,    -78,   -348,   -456,    408,   3432,   -240, &
                   624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456,    -78,    -78,     30,   -348, &
                  -348,   -348,   -240,   -456,    -78,     30,   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240, &
                  2568,   -348,   -240,   -456,    300,    -78,   -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568, &
                   300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456, &
                   300,    -78,   3432,   -456,   3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104,   3432,   -456, &
                  -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,  -2724,    408,    408,   -456,   -456,   -240]
  K1( 194,:) = [    -78,    408,   -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724, &
                  -456,   -240,    408,   -456,    408,   -456,   -456,    -78,    -78,     30,   -348,    624,   -240,   3432, &
                   408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300,     30,   -348,    -78,    -78, &
                  -456,   2568,   3432,    300,   3324,    -78,   -456,   3432,    408,    624,   -240,   -348,   -240,   -240, &
                  -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300, &
                   300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568,   -456,   2568, &
                  -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568, &
                   300,   -456,    300,    -78,   -456,     30,    -78,   -348]
  K1( 195,:) = [   -456,    408,    -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456, &
                 -2724,    408,   -240,   -456,   -240,   -348,   -456,     30,   -348,    -78,   2568,   -456,   -456,   -348, &
                  -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78,   -456,     30,    -78,   -348, &
                  2568,   -456,  -1104,   2568,    300,   -456,   -456,    408,   3432,   -240,    624,   -348,   2568,   -456, &
                  3324,    -78,   3432,    300,    300,   -456,    -78,    -78,     30,   -348,   -348,   -348,   -240,   -456, &
                   -78,     30,  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568, &
                 -2724,    408,    300,    300,    -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568,   -240,   -348, &
                  3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568, &
                  -456,   -348,    408,  -2724,   -456,   -240,    408,   -456]
  K1( 196,:) = [     30,   -456,    -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240, &
                   408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   -456,   3432,    408,    624, &
                  -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456,   -456,   -240, &
                 -1104,   -240,   1056,  -1104,   3432,   -240,   -348,    624,   -240,   3432,    408,   -456,   -348,   -348, &
                   -78,     30,   -240,   -456,   -456,    300,     30,   -348,    -78,    -78,   -456,   2568,   3432,    300, &
                  3324,    -78,    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104, &
                   408,  -2724,    -78,   -456,    300,    300,    -78,    300,   3324,   2568,   3432,   -456,   -348,     30, &
                  -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456, &
                  2568,   -348,    -78,    300,    -78,   -348,   -456,     30]
  K1( 197,:) = [    -78,   -456,     30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408, &
                  -240,   -456,  -2724,    408,  -2724,    300,    408,    -78,    300,   -456,     30,   -348,   -348,   -456, &
                  -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300,    -78,   -348,   -456,     30, &
                  -240,  -1104,   -240,   -456,   2568,   -348,   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568, &
                  -456,   -348,    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456, &
                  -456,    300,   2568,  -1104,   -456,   2568,  -2724,    408,    300,    300,    -78,   -456,    408,   -456, &
                   624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348,   -240,   -456, &
                   -78,     30,    300,   -456,    -78,    -78,     30,   -348]
  K1( 198,:) = [   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,    408,    -78,  -2724,    300,   -456,    300,   -348,   -240,    624,    408, &
                  3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240,    408,   -456, &
                  -240,   -240,  -1104,   2568,   -456,   -348,     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568, &
                   300,   -456,  -1104,   2568,    -78,    300,    -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456, &
                  2568,   -348,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568, &
                   -78,    300,   3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456,    300,    300,    624,   -348, &
                   408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568,   3432,    300, &
                  3324,    -78,   -456,    300,     30,   -348,    -78,    -78]
  K1( 199,:) = [   -456,    408,   3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456, &
                   -78,    -78,     30,   -348,   -348,   -348,   -240,   -456,    -78,     30,    300,  -2724,    300,   -456, &
                   408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408,    408,   -456,   -456,   -240, &
                  -456,     30,   -240,   -348,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456, &
                  -456,   -348,   -348,     30,   -456,     30,    300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456, &
                  -456,    300,  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432, &
                  3432,   -456,    300,    -78,   2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568,   -240,   -240, &
                 -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,    408,   -456,  -2724,    408,   -240,   -456]
  K1( 200,:) = [   -348,    624,   -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300, &
                    30,   -348,    -78,    -78,   -456,   2568,   3432,    300,   3324,    -78,    -78,    408,   -456,    300, &
                 -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240,    408,   -456, &
                   408,   -456,   -456,    -78,    -78,     30,   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432, &
                   408,    624,   -240,   -348,    408,   -456,  -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300, &
                  -456,   2568,    300,   -456,  -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324,   -240,  -1104, &
                  -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -456,     30,    300,    -78,   -348,    -78]
  K1( 201,:) = [   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78, &
                  -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    408,    -78,     30, &
                  -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456,  -2724,    408,   -240,   -456, &
                  -240,   -348,   -456,     30,   -348,    -78,   2568,   -456,   3324,    -78,   3432,    300,   -456,    408, &
                  3432,   -240,    624,   -348,    -78,    -78,    300,   -456,   -348,     30,   -240,   -456,   -348,   -348, &
                    30,    -78,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300, &
                   300,    300,  -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568,   -240,   -240, &
                  -348,   -456,   -456,   -240,    408,  -2724,   -456,    408]
  K1( 202,:) = [   -456,   3432,    408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408, &
                   408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240,     30,   -456,    -78,   -348, &
                  -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240,    408,  -2724,   -456,    408, &
                  -456,    -78,    408,   -456,     30,    -78,   -348,   -348,    -78,     30,   -240,   -456,   -348,    624, &
                  -240,   3432,    408,   -456,     30,   -348,   -456,    300,    -78,    -78,   3432,    300,   -456,   2568, &
                   -78,   3324,    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724, &
                   -78,   -456,    408,  -2724,    300,    300,   3324,   2568,    -78,    300,   -456,   3432,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,    -78,   -348,    -78,    300,     30,   -456]
  K1( 203,:) = [     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300, &
                   -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348,    -78,   -456,     30,    -78, &
                   408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408,   -240,   -456,  -2724,    408, &
                 -2724,    300,    408,    -78,    300,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240, &
                   624,    408,   3432,   -456,   -456,   -240,    408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240, &
                  -348,   -456,    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724, &
                  2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,   -456,   2568, &
                  3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456,   -348,   -348, &
                    30,    -78,    -78,    -78,    300,   -456,   -348,     30]
  K1( 204,:) = [   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724, &
                  -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   -348,   -240,   -348,    -78, &
                  -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456,   -456,    408,    408,  -2724, &
                   408,    -78,  -2724,    300,   -456,    300,   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348, &
                  -348,   -456,   -456,   2568,    -78,   -348,    -78,    300,     30,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846, &
                  3324,   2568,    -78,    300,   -456,   3432,    -78,   -456,    408,  -2724,    300,    300,   -348,   -348, &
                  -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300,   -456,   2568, &
                   -78,   3324,     30,   -348,   -456,    300,    -78,    -78]
  K1( 205,:) = [   2568,   -456,   3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78, &
                   300,   -456,   -348,     30,   -240,   -456,   -348,   -348,     30,    -78,  -1104,   -240,   2568,   -348, &
                  -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30,    300,    -78,   -348,    -78, &
                 -1104,   2568,   2568,   -456,   -456,    300,    300,  -2724,    300,   -456,    408,    -78,   -456,    408, &
                   -78,     30,   -456,    -78,  -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348, &
                   -78,   -348,    300,    300,  -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324, &
                 21846,  -2724,  -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568,    300,   -456,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348, &
                   408,    624,   -456,    408,   -240,   -456,  -2724,    408]
  K1( 206,:) = [   -348,   -348,    -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348, &
                  -456,    300,    -78,    -78,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456,  -2724,    408,   -240,   -456, &
                  1056,  -1104,  -1104,   -240,   -240,   3432,    -78,    408,   -456,    300,  -2724,    300,     30,   -456, &
                   -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240,    408,   -456,    408,   -456,   -456,    -78, &
                   -78,     30,    -78,   -456,    408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568, &
                 -2724,  21846,    300,   3432,  -2724,    300,   -456,   3432,   2568,   3324,    300,    -78,   -240,   -456, &
                  -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568,   -348,     30, &
                  -456,   -348,     30,   -456,   -348,    -78,    300,    -78]
  K1( 207,:) = [  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30, &
                   300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   -456,   3324,    -78, &
                  3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78,    300,   -456,   -348,     30, &
                  -240,   -456,   -348,   -348,     30,    -78,   -456,    408,    -78,     30,   -456,    -78,    300,  -2724, &
                   300,   -456,    408,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,   3432,   -456,    300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78, &
                 -2724,    300,  21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456,   -456,    300,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456, &
                   624,    408,   -240,   -456,   -456,    408,    408,  -2724]
  K1( 208,:) = [   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456, &
                 -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   -348,   -348,    -78,     30, &
                  -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348,   -456,    300,    -78,    -78, &
                  3432,    300,   -456,   2568,    -78,   3324,     30,   -456,    -78,   -348,   -240,   -348,    -78,    408, &
                  -456,    300,  -2724,    300,   -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456, &
                    30,    -78,   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300, &
                   300,   3432,  -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568, &
                  -348,   -456,   -348,    -78,     30,   -456,    -78,    300]
  K1( 209,:) = [   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348, &
                   -78,    300,     30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240,    408,  -2724,   -456,    408, &
                 -1104,   2568,   -240,   -240,   -348,   -456,    -78,   -456,     30,    -78,    408,   -456,   -348,   -240, &
                  -348,    -78,   -456,     30,   -456,    408,   -240,   -456,  -2724,    408,  -2724,    300,    408,    -78, &
                   300,   -456,   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456, &
                   300,  -2724,   3432,    300,  21846,  -2724,    300,    300,   -456,    -78,  -2724,    408,   3432,    300, &
                  -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456,    624,   -348, &
                  3432,   -240,    -78,    -78,   -348,     30,    300,   -456]
  K1( 210,:) = [   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240, &
                   408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   -456,   2568,    300,   -456, &
                 -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348,    -78,    300,     30,   -456, &
                  -240,   -456,   -240,  -1104,   -348,   2568,   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456, &
                    30,    -78,    408,   -456,   -240,   -456,   -456,    408,    408,  -2724,    408,    -78,  -2724,    300, &
                  -456,    300,   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432, &
                  3432,    300,    300,  -2724,  -2724,  21846,   -456,    -78,    300,    300,    408,  -2724,   -240,   -456, &
                  -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348,    408,   -456, &
                  -240,   3432,   -348,     30,    -78,    -78,   -456,    300]
  K1( 211,:) = [    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78, &
                  -348,     30,    300,   -456,    408,   -456,    624,   -348,   3432,   -240,   -456,   -240,   -348,   2568, &
                  -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456,   -348,    -78,    300,    -78, &
                  -456,   2568,   -348,     30,   -456,   -348,   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348, &
                   408,    624,    300,    300,   -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78, &
                  2568,   -456,  -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    300, &
                   408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30,   -240,   -348, &
                   -78,   -348,  -2724,    408,    408,   -456,   -456,   -240]
  K1( 212,:) = [   -456,   -240,     30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30, &
                   -78,    -78,   -456,    300,    624,   -348,    408,   -456,   -240,   3432,   2568,  -1104,   -348,   -456, &
                  -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456,  -2724,    408, &
                  3432,   -456,   -240,   -348,    408,    624,   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104, &
                  -456,    300,   2568,   -456,     30,   -456,   -348,    -78,    300,    -78,   -456,   2568,   -348,     30, &
                  -456,   -348,   -456,    -78,    300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456, &
                  -456,   3432,   2568,   3324,    300,    -78,  -2724,  21846,    300,   3432,  -2724,    300,    408,    -78, &
                 -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456,   -456,    -78, &
                   -78,     30,    408,  -2724,   -456,   -240,    408,   -456]
  K1( 213,:) = [   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456, &
                  -348,    -78,    300,    -78,   -456,   2568,   -348,     30,   -456,   -348,    300,   3432,    -78,   3324, &
                  -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78,   -348,     30,    300,   -456, &
                   408,   -456,    624,   -348,   3432,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104, &
                  -348,   -456,   -240,   -240,   -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456, &
                   624,    408,   -456,   3432,   2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408, &
                 -1104,   2568,   2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724,   3432,    300,    408,   -456, &
                  -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,    408,   -456,  -2724,    408,   -240,   -456]
  K1( 214,:) = [   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348,    408,    624,   -456,   -240,     30,    -78, &
                  -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30,    -78,    -78,   -456,    300, &
                   624,   -348,    408,   -456,   -240,   3432,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240, &
                  -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456,    -78,    300,   -348,     30,   -456,   2568, &
                  -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724, &
                  2568,   3324,   -456,   3432,    -78,    300,    300,   3432,  -2724,  21846,    300,  -2724,   -456,     30, &
                  -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78,    408,   -456, &
                    30,    -78,   -456,   -240,    408,  -2724,   -456,    408]
  K1( 215,:) = [   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78, &
                    30,   -456,    -78,    300,   -348,     30,   -456,   2568,   -348,   -456,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456,   -456,    408,    408,  -2724, &
                  -240,   -348,   3432,   -456,    624,    408,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240, &
                    30,    -78,   -348,   -348,    -78,    -78,   -348,     30,    300,   -456,    408,   -456,    624,   -348, &
                  3432,   -240,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300, &
                   300,    300,   -456,    -78,  -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724,   -456,    -78, &
                   408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300,    408,    -78, &
                   300,   -456,   -456,    408,   -240,   -456,  -2724,    408]
  K1( 216,:) = [  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456, &
                  -456,    408,    408,  -2724,   -240,   -348,   3432,   -456,    624,    408,   2568,  -1104,   -456,    300, &
                  2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456,    -78,    300, &
                  -348,     30,   -456,   2568,   -348,   -456,   -456,   -240,     30,    -78,   -348,   -348,    300,   3432, &
                   -78,   3324,   -456,   2568,   -348,     30,    -78,    -78,   -456,    300,    624,   -348,    408,   -456, &
                  -240,   3432,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300, &
                  -456,    -78,    300,    300,    408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846,   -240,   -348, &
                  -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78,  -2724,    300, &
                  -456,    300,   -240,   -456,   -456,    408,    408,  -2724]
  K1( 217,:) = [  -2724,    300,    408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30, &
                  -240,   -348,    -78,   -348,  -2724,    408,    408,   -456,   -456,   -240,    408,   -456,    624,   -348, &
                  3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348,   -240,   -456,    -78,     30, &
                   300,   -456,    -78,    -78,     30,   -348,   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104, &
                  -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568,    300,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   3432,   -456,   -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348, &
                 -1104,   -240,   1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456,   -456,   -240,  21846,  -2724, &
                 -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78,   3432,   -456, &
                  3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104]
  K1( 218,:) = [    408,    -78,  -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456, &
                  -456,    -78,    -78,     30,    408,  -2724,   -456,   -240,    408,   -456,    624,   -348,    408,   -456, &
                  -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568,   3432,    300,   3324,    -78, &
                  -456,    300,     30,   -348,    -78,    -78,   3432,   -456,   -240,   -348,    408,    624,   -240,   -240, &
                 -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456, &
                  -456,   -240,   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348, &
                  2568,   -456,  -1104,   2568,    300,   -456,    300,    -78,   -456,     30,    -78,   -348,  -2724,  21846, &
                   300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568]
  K1( 219,:) = [    408,   -456,   -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348, &
                  -456,     30,   -348,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -456,   2568,   -348,     30, &
                  -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568,    300,   -456, &
                   300,    -78,   -456,     30,    -78,   -348,    408,   -456,    624,   -348,   3432,   -240,   -456,   2568, &
                  3432,    300,   3324,    -78,   -348,   -348,   -240,   -456,    -78,     30,    300,   -456,    -78,    -78, &
                    30,   -348,   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240, &
                  -240,   -240,  -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240,    408,   -456,  -2724,    300, &
                 21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408,    300,    300, &
                   -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568]
  K1( 220,:) = [   -456,     30,   -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78, &
                   408,   -456,     30,    -78,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -456,   -240,   -348, &
                   408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104,   3432,   -240, &
                 -2724,    408,    408,   -456,   -456,   -240,    624,   -348,    408,   -456,   -240,   3432,   -348,   -348, &
                  -240,   -456,    -78,     30,   -456,   2568,   3432,    300,   3324,    -78,   -456,    300,     30,   -348, &
                   -78,    -78,   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456, &
                  -240,  -1104,   -240,   -456,   2568,   -348,    -78,    300,    -78,   -348,   -456,     30,    300,   3432, &
                 -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456, &
                   300,    300,    -78,    300,   3324,   2568,   3432,   -456]
  K1( 221,:) = [   -456,    -78,    408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300, &
                   408,    -78,    300,   -456,   -456,    408,   -240,   -456,  -2724,    408,   -348,     30,   -456,   2568, &
                  -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456,   2568,   -348, &
                   -78,    300,    -78,   -348,   -456,     30,   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240, &
                   408,   -456,    408,   -456,    624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78, &
                  -348,   -348,   -240,   -456,    -78,     30,    300,   -456,    -78,    -78,     30,   -348,    300,  -2724, &
                  3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,  -2724,    408,    300,    300,    -78,   -456]
  K1( 222,:) = [   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78, &
                 -2724,    300,   -456,    300,   -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456, &
                   624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568,   -456,   -348, &
                   408,  -2724,   -456,   -240,    408,   -456,   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456,   2568,   -348,    -78,    300,    -78,   -348, &
                  -456,     30,    624,   -348,    408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30, &
                  -456,   2568,   3432,    300,   3324,    -78,   -456,    300,     30,   -348,    -78,    -78,   3432,    300, &
                   300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568, &
                  3432,   -456,    408,  -2724,    -78,   -456,    300,    300]
  K1( 223,:) = [    408,   -456,    624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348, &
                  -240,   -456,    -78,     30,    300,   -456,    -78,    -78,     30,   -348,  -2724,    300,    408,    -78, &
                   300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30,   -240,   -348,    -78,   -348, &
                 -2724,    408,    408,   -456,   -456,   -240,   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568, &
                  -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78, &
                  -348,    -78,   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624, &
                  1056,  -1104,  -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408,   -240,   -456,  -2724,    408, &
                   300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456,    300,    -78, &
                  2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568]
  K1( 224,:) = [    624,   -348,    408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568, &
                  3432,    300,   3324,    -78,   -456,    300,     30,   -348,    -78,    -78,    408,    -78,  -2724,    300, &
                  -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456,   -456,    -78,    -78,     30, &
                   408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456, &
                  -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408, &
                  -240,   -456,   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348, &
                 -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78,   -348,    -78,    408,  -2724, &
                   -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568,    300,   -456, &
                 -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324]
  K1( 225,:) = [   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456, &
                 -1104,   2568,    300,   -456,    300,    -78,   -456,     30,    -78,   -348,    408,   -456,   -456,    -78, &
                   -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348,   -456,     30,   -348,    -78, &
                   408,   -456,  -2724,    408,   -240,   -456,   -456,   2568,   3432,    300,   3324,    -78,    408,   -456, &
                   624,   -348,   3432,   -240,   -240,   -456,   -348,   -348,     30,    -78,    -78,    -78,    300,   -456, &
                  -348,     30,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408, &
                 -1104,   2568,   -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724,   -456,    408,    300,    -78, &
                  3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300,  -2724,    408, &
                  -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456]
  K1( 226,:) = [   3432,   -456,   -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348, &
                   -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78,    408,   -456,     30,    -78, &
                  -456,   -240,    408,  -2724,   -456,    408,   -348,   -348,   -240,   -456,    -78,     30,    624,   -348, &
                   408,   -456,   -240,   3432,   3432,    300,   -456,   2568,    -78,   3324,     30,   -348,   -456,    300, &
                   -78,    -78,   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456, &
                  -240,   -456,   -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300,     30,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724, &
                   300,    300,   3324,   2568,    -78,    300,   -456,   3432]
  K1( 227,:) = [   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104, &
                  -240,   -456,   2568,   -348,    -78,    300,    -78,   -348,   -456,     30,   -456,    -78,    408,   -456, &
                    30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456, &
                  -456,    408,   -240,   -456,  -2724,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348, &
                  3432,   -456,    624,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,   -456,   2568,   3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240, &
                  -240,   -456,   -348,   -348,     30,    -78,    -78,    -78,    300,   -456,   -348,     30,    -78,    300, &
                  3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300, &
                  2568,   -456,    300,    300,  -2724,    408,   -456,    -78]
  K1( 228,:) = [   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240, &
                 -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240,    408,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78,  -2724,    300,   -456,    300, &
                  -240,   -456,   -456,    408,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30, &
                  -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300, &
                    30,   -456,   -348,   -348,   -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432, &
                  3432,    300,   -456,   2568,    -78,   3324,     30,   -348,   -456,    300,    -78,    -78,   -456,    300, &
                  2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300, &
                  -456,   3432,    -78,   -456,    408,  -2724,    300,    300]
  K1( 229,:) = [   -456,   2568,   3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456, &
                  -348,   -348,     30,    -78,    -78,    -78,    300,   -456,   -348,     30,   -240,  -1104,   -240,   -456, &
                  2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456,   -456,    300, &
                  -456,     30,    300,    -78,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456,    408,   -456, &
                  -456,    -78,    -78,     30,   -456,     30,   -240,   -348,    -78,   -348,  -2724,    408,    408,   -456, &
                  -456,   -240,  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432, &
                  3432,   -456,   -240,   -348,    408,    624,   -456,    408,   -240,   -456,  -2724,    408,    300,    300, &
                 -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300, &
                   300,   3432,   2568,   -456,  -1104,   2568,    300,   -456]
  K1( 230,:) = [   -348,   -348,   -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300, &
                  -456,   2568,    -78,   3324,     30,   -348,   -456,    300,    -78,    -78,   -240,   -240,  -1104,   2568, &
                  -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240,   -240,   3432, &
                   408,   -456,  -2724,    408,   -240,   -456,    408,    -78,  -2724,    300,   -456,    300,   -456,     30, &
                  -240,   -348,    -78,   -348,    408,   -456,   -456,    -78,    -78,     30,    408,  -2724,   -456,   -240, &
                   408,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300, &
                  -456,   2568,   -348,     30,   -456,   -348,     30,   -456,   -348,    -78,    300,    -78,    -78,   -456, &
                   408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432, &
                 -2724,    300,   -456,   3432,   2568,   3324,    300,    -78]
  K1( 231,:) = [   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -456,     30,    300,    -78,   -348,    -78,   -456,   2568,   3432,    300, &
                  3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456,   -348,   -348,     30,    -78, &
                   -78,    -78,    300,   -456,   -348,     30,    408,   -456,   -456,    -78,    -78,     30,  -2724,    300, &
                   408,    -78,    300,   -456,   -240,   -348,   -456,     30,   -348,    -78,    408,   -456,  -2724,    408, &
                  -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456, &
                  -240,   -348,   3432,   -456,    624,    408,   -240,   -456,   -456,    408,    408,  -2724,   3432,   -456, &
                   300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724, &
                  3432,    300,  -1104,   2568,   2568,   -456,   -456,    300]
  K1( 232,:) = [   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408,   -240,   -456,   -348,   -348,   -240,   -456, &
                   -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300,   -456,   2568,    -78,   3324, &
                    30,   -348,   -456,    300,    -78,    -78,   -456,     30,   -240,   -348,    -78,   -348,    408,    -78, &
                 -2724,    300,   -456,    300,   -456,    -78,    408,   -456,     30,    -78,   -456,   -240,    408,  -2724, &
                  -456,    408,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568, &
                  -348,     30,   -456,   2568,   -348,   -456,   -348,    -78,     30,   -456,    -78,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432,  -2724,  21846, &
                   300,  -2724,   2568,   3324,   -456,   3432,    -78,    300]
  K1( 233,:) = [   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456, &
                  -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300,     30,   -456,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568,   -240,   -240,   -348,   -456, &
                  -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   -240,   -348, &
                  -456,     30,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456,   -456,    408,   -240,   -456, &
                 -2724,    408,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78, &
                   408,   -456,    624,   -348,   3432,   -240,    -78,    -78,   -348,     30,    300,   -456,   3324,   2568, &
                   -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724,   3432,    300, &
                 21846,  -2724,    300,    300,   -456,    -78,  -2724,    408]
  K1( 234,:) = [  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724,   -456,    408,   2568,   -456,  -1104,   2568, &
                   300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104,   -348,   2568, &
                   -78,   -348,    -78,    300,     30,   -456,   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78, &
                   408,   -456,     30,    -78,    408,    -78,  -2724,    300,   -456,    300,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   -456,   -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324, &
                   624,   -348,    408,   -456,   -240,   3432,   -348,     30,    -78,    -78,   -456,    300,   2568,  -1104, &
                  -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,    -78,    300,    300,    408,  -2724]
  K1( 235,:) = [   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456, &
                   624,   -348,   3432,   -240,    -78,    -78,   -348,     30,    300,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568,   -348,     30,   -456,   -348, &
                    30,   -456,   -348,    -78,    300,    -78,  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348,    408,    624,   -456,    408,   -240,   -456, &
                 -2724,    408,  -2724,    300,    408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30, &
                  -456,     30,   -240,   -348,    -78,   -348,  -2724,    408,    408,   -456,   -456,   -240,    300,    300, &
                  -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568, &
                   300,   -456,  21846,  -2724,  -2724,    300,    300,   3432]
  K1( 236,:) = [   -240,   -456,   -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348, &
                   408,   -456,   -240,   3432,   -348,     30,    -78,    -78,   -456,    300,  -1104,   2568,   -240,   -240, &
                  -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348,    408,    624, &
                  -456,    408,   -240,   -456,  -2724,    408,   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -456,   2568,   -348,     30,   -456,   -348,     30,   -456,   -348,    -78, &
                   300,    -78,    408,    -78,  -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348, &
                   408,   -456,   -456,    -78,    -78,     30,    408,  -2724,   -456,   -240,    408,   -456,   -456,    -78, &
                   300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324, &
                   300,    -78,  -2724,  21846,    300,   3432,  -2724,    300]
  K1( 237,:) = [   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568, &
                  -348,     30,   -456,   -348,     30,   -456,   -348,    -78,    300,    -78,   3432,    300,   -456,   2568, &
                   -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456,    624,   -348,   3432,   -240, &
                   -78,    -78,   -348,     30,    300,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456,    624,    408,   -240,   -456,   -456,    408, &
                   408,  -2724,    408,   -456,   -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456, &
                  -240,   -348,   -456,     30,   -348,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432, &
                  2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456, &
                  -456,    300,  -2724,    300,  21846,  -2724,   3432,    300]
  K1( 238,:) = [  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456, &
                  -240,   -348,    408,    624,   -456,    408,   -240,   -456,  -2724,    408,   -240,   -456,   -348,   -348, &
                    30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348,    408,   -456,   -240,   3432, &
                  -348,     30,    -78,    -78,   -456,    300,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456, &
                  -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568,   -348,   -456,   -348,    -78,     30,   -456, &
                   -78,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300, &
                  -456,    -78,    408,   -456,     30,    -78,   -456,   -240,    408,  -2724,   -456,    408,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324,   -456,   3432, &
                   -78,    300,    300,   3432,  -2724,  21846,    300,  -2724]
  K1( 239,:) = [  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30, &
                  -456,   2568,   -348,   -456,   -348,    -78,     30,   -456,    -78,    300,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456,    624,    408, &
                  -240,   -456,   -456,    408,    408,  -2724,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456, &
                  -348,   -348,     30,    -78,    408,   -456,    624,   -348,   3432,   -240,    -78,    -78,   -348,     30, &
                   300,   -456,   -456,    -78,    408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78, &
                 -2724,    300,    408,    -78,    300,   -456,   -456,    408,   -240,   -456,  -2724,    408,   2568,   3324, &
                  -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300,   -456,    -78, &
                 -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724]
  K1( 240,:) = [   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348, &
                  3432,   -456,    624,    408,   -240,   -456,   -456,    408,    408,  -2724,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568,   -348,   -456, &
                  -348,    -78,     30,   -456,    -78,    300,   -240,   -456,   -348,   -348,     30,    -78,   3432,    300, &
                  -456,   2568,    -78,   3324,    624,   -348,    408,   -456,   -240,   3432,   -348,     30,    -78,    -78, &
                  -456,    300,   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78, &
                   408,    -78,  -2724,    300,   -456,    300,   -240,   -456,   -456,    408,    408,  -2724,  -1104,   2568, &
                  2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78,    300,    300, &
                   408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846]
  K1( 241,:) = [ -12291,   1506,   1506,     -6,     -6,  -2004,   1506,   -492,     -6,  -1518,    183,    372,     -6,    183, &
                 -2004,    372,  -3030,  -1140,  -1518,    372,    372,  -1140,  -1140,    264,   1533,   -222,   -222,    210, &
                   210,    156,   -195,     -6,     21,     -6,     21,    -60,     48,     -6,    210,    -60,     21,    372, &
                  -195,     -6,    -33,    372,    210,   -168,   -168,    264,     21,    210,    -33,    156,  -1950,    -60, &
                   210,    -60,    210,   -600,  -1896,     -6,  -1302,    372,     21,  -3084,     48,     -6,    156,    318, &
                   210,    264,   -168,     21,    264,    -33,    210,    156,    237,    183,  -1302,    372,    -33,    318, &
                 -1464,    -60,    588,   -168,    210,    264,   -195,     -6,    399,  -2652,  -1302,    696,   1533,   -222, &
                  -222,    210,    210,    156,   -249,   -546,    399,  -3084,    156,    264,    237,    183,    102,    264, &
                 -1302,    696,  -1950,    -60,    102,    696,    588,   -816]
  K1( 242,:) = [   1506, -12291,     -6,  -2004,   1506,     -6,   -492,   1506,    183,    372,     -6,  -1518,  -1518,    372, &
                   372,  -1140,  -1140,    264,     -6,    183,  -2004,    372,  -3030,  -1140,   -222,   1533,    210,    156, &
                  -222,    210,     -6,   -195,     21,    -60,     21,     -6,   -195,     -6,    -33,    372,    210,   -168, &
                    48,     -6,    210,    -60,     21,    372,    264,   -168,    -33,    156,     21,    210,    -60,  -1950, &
                   210,   -600,    210,    -60,     48,     -6,    156,    318,    210,    264,  -1896,     -6,  -1302,    372, &
                    21,  -3084,   1533,   -222,   -222,    210,    210,    156,   -249,   -546,    399,  -3084,    156,    264, &
                   237,    183,    102,    264,  -1302,    696,  -1950,    -60,    102,    696,    588,   -816,   -168,     21, &
                   264,    -33,    210,    156,    237,    183,  -1302,    372,    -33,    318,  -1464,    -60,    588,   -168, &
                   210,    264,   -195,     -6,    399,  -2652,  -1302,    696]
  K1( 243,:) = [   1506,     -6, -12291,   1506,  -2004,     -6,     -6,    183,  -2004,    372,  -3030,  -1140,   1506,   -492, &
                    -6,  -1518,    183,    372,    372,  -1518,  -1140,    264,    372,  -1140,   -222,    210,   1533,   -222, &
                   156,    210,     48,     -6,    210,    -60,     21,    372,   -195,     -6,     21,     -6,     21,    -60, &
                    -6,   -195,    210,   -168,    -33,    372,   -168,     21,    264,    -33,    210,    156,    237,    183, &
                 -1302,    372,    -33,    318,  -1464,    -60,    588,   -168,    210,    264,   -195,     -6,    399,  -2652, &
                 -1302,    696,   -168,    264,     21,    210,    -33,    156,  -1950,    -60,    210,    -60,    210,   -600, &
                 -1896,     -6,  -1302,    372,     21,  -3084,     48,     -6,    156,    318,    210,    264,   -222,   1533, &
                   210,    156,   -222,    210,   -546,   -249,    156,    264,    399,  -3084,  -1950,    -60,    102,    696, &
                   588,   -816,    237,    183,    102,    264,  -1302,    696]
  K1( 244,:) = [     -6,  -2004,   1506, -12291,     -6,   1506,  -1518,    372,    372,  -1140,  -1140,    264,   -492,   1506, &
                   183,    372,     -6,  -1518,    183,     -6,  -3030,  -1140,  -2004,    372,    210,    156,   -222,   1533, &
                   210,   -222,   -195,     -6,    -33,    372,    210,   -168,     -6,   -195,     21,    -60,     21,     -6, &
                    -6,     48,     21,    372,    210,    -60,   1533,   -222,   -222,    210,    210,    156,   -249,   -546, &
                   399,  -3084,    156,    264,    237,    183,    102,    264,  -1302,    696,  -1950,    -60,    102,    696, &
                   588,   -816,    264,   -168,    -33,    156,     21,    210,    -60,  -1950,    210,   -600,    210,    -60, &
                    48,     -6,    156,    318,    210,    264,  -1896,     -6,  -1302,    372,     21,  -3084,     21,   -168, &
                   210,    156,    264,    -33,    183,    237,    -33,    318,  -1302,    372,   -195,     -6,    399,  -2652, &
                 -1302,    696,  -1464,    -60,    588,   -168,    210,    264]
  K1( 245,:) = [     -6,   1506,  -2004,     -6, -12291,   1506,    183,     -6,  -3030,  -1140,  -2004,    372,    372,  -1518, &
                 -1140,    264,    372,  -1140,   1506,   -492,     -6,  -1518,    183,    372,    210,   -222,    156,    210, &
                  1533,   -222,     -6,     48,     21,    372,    210,    -60,     -6,   -195,    210,   -168,    -33,    372, &
                  -195,     -6,     21,     -6,     21,    -60,     21,   -168,    210,    156,    264,    -33,    183,    237, &
                   -33,    318,  -1302,    372,   -195,     -6,    399,  -2652,  -1302,    696,  -1464,    -60,    588,   -168, &
                   210,    264,   -222,   1533,    210,    156,   -222,    210,   -546,   -249,    156,    264,    399,  -3084, &
                 -1950,    -60,    102,    696,    588,   -816,    237,    183,    102,    264,  -1302,    696,   -168,    264, &
                    21,    210,    -33,    156,  -1950,    -60,    210,    -60,    210,   -600,  -1896,     -6,  -1302,    372, &
                    21,  -3084,     48,     -6,    156,    318,    210,    264]
  K1( 246,:) = [  -2004,     -6,     -6,   1506,   1506, -12291,    372,  -1518,  -1140,    264,    372,  -1140,    183,     -6, &
                 -3030,  -1140,  -2004,    372,   -492,   1506,    183,    372,     -6,  -1518,    156,    210,    210,   -222, &
                  -222,   1533,     -6,   -195,    210,   -168,    -33,    372,     -6,     48,     21,    372,    210,    -60, &
                    -6,   -195,     21,    -60,     21,     -6,   -222,   1533,    210,    156,   -222,    210,   -546,   -249, &
                   156,    264,    399,  -3084,  -1950,    -60,    102,    696,    588,   -816,    237,    183,    102,    264, &
                 -1302,    696,     21,   -168,    210,    156,    264,    -33,    183,    237,    -33,    318,  -1302,    372, &
                  -195,     -6,    399,  -2652,  -1302,    696,  -1464,    -60,    588,   -168,    210,    264,    264,   -168, &
                   -33,    156,     21,    210,    -60,  -1950,    210,   -600,    210,    -60,     48,     -6,    156,    318, &
                   210,    264,  -1896,     -6,  -1302,    372,     21,  -3084]
  K1( 247,:) = [   1506,   -492,     -6,  -1518,    183,    372, -12291,   1506,   1506,     -6,     -6,  -2004,  -2004,    372, &
                    -6,    183,  -1140,  -3030,    372,  -1140,  -1518,    372,    264,  -1140,   -168,    264,     21,    210, &
                   -33,    156,  -1950,    -60,    210,    -60,    210,   -600,  -1896,     -6,  -1302,    372,     21,  -3084, &
                    48,     -6,    156,    318,    210,    264,   1533,   -222,   -222,    210,    210,    156,   -195,     -6, &
                    21,     -6,     21,    -60,     48,     -6,    210,    -60,     21,    372,   -195,     -6,    -33,    372, &
                   210,   -168,    264,    -33,   -168,     21,    156,    210,  -1464,    -60,    588,   -168,    210,    264, &
                   237,    183,  -1302,    372,    -33,    318,     -6,   -195,  -1302,    696,    399,  -2652,   -222,    210, &
                  1533,   -222,    156,    210,    237,    183,    102,    264,  -1302,    696,   -249,   -546,    399,  -3084, &
                   156,    264,    -60,  -1950,    588,   -816,    102,    696]
  K1( 248,:) = [   -492,   1506,    183,    372,     -6,  -1518,   1506, -12291,     -6,  -2004,   1506,     -6,    372,  -1140, &
                 -1518,    372,    264,  -1140,  -2004,    372,     -6,    183,  -1140,  -3030,    264,   -168,    -33,    156, &
                    21,    210,    -60,  -1950,    210,   -600,    210,    -60,     48,     -6,    156,    318,    210,    264, &
                 -1896,     -6,  -1302,    372,     21,  -3084,   -222,   1533,    210,    156,   -222,    210,     -6,   -195, &
                    21,    -60,     21,     -6,   -195,     -6,    -33,    372,    210,   -168,     48,     -6,    210,    -60, &
                    21,    372,   -222,    210,   1533,   -222,    156,    210,    237,    183,    102,    264,  -1302,    696, &
                  -249,   -546,    399,  -3084,    156,    264,    -60,  -1950,    588,   -816,    102,    696,    264,    -33, &
                  -168,     21,    156,    210,  -1464,    -60,    588,   -168,    210,    264,    237,    183,  -1302,    372, &
                   -33,    318,     -6,   -195,  -1302,    696,    399,  -2652]
  K1( 249,:) = [     -6,    183,  -2004,    372,  -3030,  -1140,   1506,     -6, -12291,   1506,  -2004,     -6,     -6,  -1518, &
                  1506,   -492,    372,    183,  -1140,    264,    372,  -1518,  -1140,    372,   -168,     21,    264,    -33, &
                   210,    156,    237,    183,  -1302,    372,    -33,    318,  -1464,    -60,    588,   -168,    210,    264, &
                  -195,     -6,    399,  -2652,  -1302,    696,   -222,    210,   1533,   -222,    156,    210,     48,     -6, &
                   210,    -60,     21,    372,   -195,     -6,     21,     -6,     21,    -60,     -6,   -195,    210,   -168, &
                   -33,    372,     21,    210,   -168,    264,    156,    -33,  -1896,     -6,  -1302,    372,     21,  -3084, &
                 -1950,    -60,    210,    -60,    210,   -600,     -6,     48,    210,    264,    156,    318,    210,    156, &
                  -222,   1533,    210,   -222,  -1950,    -60,    102,    696,    588,   -816,   -546,   -249,    156,    264, &
                   399,  -3084,    183,    237,  -1302,    696,    102,    264]
  K1( 250,:) = [  -1518,    372,    372,  -1140,  -1140,    264,     -6,  -2004,   1506, -12291,     -6,   1506,    183,    372, &
                  -492,   1506,  -1518,     -6,  -3030,  -1140,    183,     -6,    372,  -2004,   1533,   -222,   -222,    210, &
                   210,    156,   -249,   -546,    399,  -3084,    156,    264,    237,    183,    102,    264,  -1302,    696, &
                 -1950,    -60,    102,    696,    588,   -816,    210,    156,   -222,   1533,    210,   -222,   -195,     -6, &
                   -33,    372,    210,   -168,     -6,   -195,     21,    -60,     21,     -6,     -6,     48,     21,    372, &
                   210,    -60,    -33,    156,    264,   -168,    210,     21,     48,     -6,    156,    318,    210,    264, &
                   -60,  -1950,    210,   -600,    210,    -60,     -6,  -1896,     21,  -3084,  -1302,    372,    210,    156, &
                    21,   -168,    -33,    264,   -195,     -6,    399,  -2652,  -1302,    696,    183,    237,    -33,    318, &
                 -1302,    372,    -60,  -1464,    210,    264,    588,   -168]
  K1( 251,:) = [    183,     -6,  -3030,  -1140,  -2004,    372,     -6,   1506,  -2004,     -6, -12291,   1506,  -1140,    264, &
                   372,  -1518,  -1140,    372,     -6,  -1518,   1506,   -492,    372,    183,     21,   -168,    210,    156, &
                   264,    -33,    183,    237,    -33,    318,  -1302,    372,   -195,     -6,    399,  -2652,  -1302,    696, &
                 -1464,    -60,    588,   -168,    210,    264,    210,   -222,    156,    210,   1533,   -222,     -6,     48, &
                    21,    372,    210,    -60,     -6,   -195,    210,   -168,    -33,    372,   -195,     -6,     21,     -6, &
                    21,    -60,    210,    156,   -222,   1533,    210,   -222,  -1950,    -60,    102,    696,    588,   -816, &
                  -546,   -249,    156,    264,    399,  -3084,    183,    237,  -1302,    696,    102,    264,     21,    210, &
                  -168,    264,    156,    -33,  -1896,     -6,  -1302,    372,     21,  -3084,  -1950,    -60,    210,    -60, &
                   210,   -600,     -6,     48,    210,    264,    156,    318]
  K1( 252,:) = [    372,  -1518,  -1140,    264,    372,  -1140,  -2004,     -6,     -6,   1506,   1506, -12291,  -3030,  -1140, &
                   183,     -6,    372,  -2004,    183,    372,   -492,   1506,  -1518,     -6,   -222,   1533,    210,    156, &
                  -222,    210,   -546,   -249,    156,    264,    399,  -3084,  -1950,    -60,    102,    696,    588,   -816, &
                   237,    183,    102,    264,  -1302,    696,    156,    210,    210,   -222,   -222,   1533,     -6,   -195, &
                   210,   -168,    -33,    372,     -6,     48,     21,    372,    210,    -60,     -6,   -195,     21,    -60, &
                    21,     -6,    210,    156,     21,   -168,    -33,    264,   -195,     -6,    399,  -2652,  -1302,    696, &
                   183,    237,    -33,    318,  -1302,    372,    -60,  -1464,    210,    264,    588,   -168,    -33,    156, &
                   264,   -168,    210,     21,     48,     -6,    156,    318,    210,    264,    -60,  -1950,    210,   -600, &
                   210,    -60,     -6,  -1896,     21,  -3084,  -1302,    372]
  K1( 253,:) = [     -6,  -1518,   1506,   -492,    372,    183,  -2004,    372,     -6,    183,  -1140,  -3030, -12291,   1506, &
                  1506,     -6,     -6,  -2004,  -1140,    372,    264,  -1140,  -1518,    372,     21,    210,   -168,    264, &
                   156,    -33,  -1896,     -6,  -1302,    372,     21,  -3084,  -1950,    -60,    210,    -60,    210,   -600, &
                    -6,     48,    210,    264,    156,    318,    264,    -33,   -168,     21,    156,    210,  -1464,    -60, &
                   588,   -168,    210,    264,    237,    183,  -1302,    372,    -33,    318,     -6,   -195,  -1302,    696, &
                   399,  -2652,   1533,   -222,   -222,    210,    210,    156,   -195,     -6,     21,     -6,     21,    -60, &
                    48,     -6,    210,    -60,     21,    372,   -195,     -6,    -33,    372,    210,   -168,    210,   -222, &
                   156,    210,   1533,   -222,    183,    237,  -1302,    696,    102,    264,    -60,  -1950,    588,   -816, &
                   102,    696,   -249,   -546,    399,  -3084,    156,    264]
  K1( 254,:) = [    183,    372,   -492,   1506,  -1518,     -6,    372,  -1140,  -1518,    372,    264,  -1140,   1506, -12291, &
                    -6,  -2004,   1506,     -6,    372,  -2004,  -1140,  -3030,     -6,    183,    -33,    156,    264,   -168, &
                   210,     21,     48,     -6,    156,    318,    210,    264,    -60,  -1950,    210,   -600,    210,    -60, &
                    -6,  -1896,     21,  -3084,  -1302,    372,   -222,    210,   1533,   -222,    156,    210,    237,    183, &
                   102,    264,  -1302,    696,   -249,   -546,    399,  -3084,    156,    264,    -60,  -1950,    588,   -816, &
                   102,    696,   -222,   1533,    210,    156,   -222,    210,     -6,   -195,     21,    -60,     21,     -6, &
                  -195,     -6,    -33,    372,    210,   -168,     48,     -6,    210,    -60,     21,    372,    -33,    264, &
                   156,    210,   -168,     21,    -60,  -1464,    210,    264,    588,   -168,     -6,   -195,  -1302,    696, &
                   399,  -2652,    237,    183,  -1302,    372,    -33,    318]
  K1( 255,:) = [  -2004,    372,     -6,    183,  -1140,  -3030,     -6,  -1518,   1506,   -492,    372,    183,   1506,     -6, &
                -12291,   1506,  -2004,     -6,    264,  -1140,  -1140,    372,    372,  -1518,    264,    -33,   -168,     21, &
                   156,    210,  -1464,    -60,    588,   -168,    210,    264,    237,    183,  -1302,    372,    -33,    318, &
                    -6,   -195,  -1302,    696,    399,  -2652,     21,    210,   -168,    264,    156,    -33,  -1896,     -6, &
                 -1302,    372,     21,  -3084,  -1950,    -60,    210,    -60,    210,   -600,     -6,     48,    210,    264, &
                   156,    318,   -222,    210,   1533,   -222,    156,    210,     48,     -6,    210,    -60,     21,    372, &
                  -195,     -6,     21,     -6,     21,    -60,     -6,   -195,    210,   -168,    -33,    372,    156,    210, &
                   210,   -222,   -222,   1533,    -60,  -1950,    588,   -816,    102,    696,    183,    237,  -1302,    696, &
                   102,    264,   -546,   -249,    156,    264,    399,  -3084]
  K1( 256,:) = [    372,  -1140,  -1518,    372,    264,  -1140,    183,    372,   -492,   1506,  -1518,     -6,     -6,  -2004, &
                  1506, -12291,     -6,   1506,  -1140,  -3030,    372,  -2004,    183,     -6,   -222,    210,   1533,   -222, &
                   156,    210,    237,    183,    102,    264,  -1302,    696,   -249,   -546,    399,  -3084,    156,    264, &
                   -60,  -1950,    588,   -816,    102,    696,    -33,    156,    264,   -168,    210,     21,     48,     -6, &
                   156,    318,    210,    264,    -60,  -1950,    210,   -600,    210,    -60,     -6,  -1896,     21,  -3084, &
                 -1302,    372,    210,    156,   -222,   1533,    210,   -222,   -195,     -6,    -33,    372,    210,   -168, &
                    -6,   -195,     21,    -60,     21,     -6,     -6,     48,     21,    372,    210,    -60,    156,    210, &
                   -33,    264,     21,   -168,     -6,   -195,  -1302,    696,    399,  -2652,    -60,  -1464,    210,    264, &
                   588,   -168,    183,    237,    -33,    318,  -1302,    372]
  K1( 257,:) = [  -3030,  -1140,    183,     -6,    372,  -2004,  -1140,    264,    372,  -1518,  -1140,    372,     -6,   1506, &
                 -2004,     -6, -12291,   1506,  -1518,     -6,    372,    183,   1506,   -492,    210,    156,     21,   -168, &
                   -33,    264,   -195,     -6,    399,  -2652,  -1302,    696,    183,    237,    -33,    318,  -1302,    372, &
                   -60,  -1464,    210,    264,    588,   -168,    210,    156,   -222,   1533,    210,   -222,  -1950,    -60, &
                   102,    696,    588,   -816,   -546,   -249,    156,    264,    399,  -3084,    183,    237,  -1302,    696, &
                   102,    264,    210,   -222,    156,    210,   1533,   -222,     -6,     48,     21,    372,    210,    -60, &
                    -6,   -195,    210,   -168,    -33,    372,   -195,     -6,     21,     -6,     21,    -60,    210,     21, &
                   156,    -33,   -168,    264,     -6,  -1896,     21,  -3084,  -1302,    372,     -6,     48,    210,    264, &
                   156,    318,  -1950,    -60,    210,    -60,    210,   -600]
  K1( 258,:) = [  -1140,    264,    372,  -1518,  -1140,    372,  -3030,  -1140,    183,     -6,    372,  -2004,  -2004,     -6, &
                    -6,   1506,   1506, -12291,    372,    183,  -1518,     -6,   -492,   1506,    210,    156,   -222,   1533, &
                   210,   -222,  -1950,    -60,    102,    696,    588,   -816,   -546,   -249,    156,    264,    399,  -3084, &
                   183,    237,  -1302,    696,    102,    264,    210,    156,     21,   -168,    -33,    264,   -195,     -6, &
                   399,  -2652,  -1302,    696,    183,    237,    -33,    318,  -1302,    372,    -60,  -1464,    210,    264, &
                   588,   -168,    156,    210,    210,   -222,   -222,   1533,     -6,   -195,    210,   -168,    -33,    372, &
                    -6,     48,     21,    372,    210,    -60,     -6,   -195,     21,    -60,     21,     -6,    156,    -33, &
                   210,     21,    264,   -168,     -6,     48,    210,    264,    156,    318,     -6,  -1896,     21,  -3084, &
                 -1302,    372,    -60,  -1950,    210,   -600,    210,    -60]
  K1( 259,:) = [  -1518,     -6,    372,    183,   1506,   -492,    372,  -2004,  -1140,  -3030,     -6,    183,  -1140,    372, &
                   264,  -1140,  -1518,    372, -12291,   1506,   1506,     -6,     -6,  -2004,    210,     21,    156,    -33, &
                  -168,    264,     -6,  -1896,     21,  -3084,  -1302,    372,     -6,     48,    210,    264,    156,    318, &
                 -1950,    -60,    210,    -60,    210,   -600,    -33,    264,    156,    210,   -168,     21,    -60,  -1464, &
                   210,    264,    588,   -168,     -6,   -195,  -1302,    696,    399,  -2652,    237,    183,  -1302,    372, &
                   -33,    318,    210,   -222,    156,    210,   1533,   -222,    183,    237,  -1302,    696,    102,    264, &
                   -60,  -1950,    588,   -816,    102,    696,   -249,   -546,    399,  -3084,    156,    264,   1533,   -222, &
                  -222,    210,    210,    156,   -195,     -6,     21,     -6,     21,    -60,     48,     -6,    210,    -60, &
                    21,    372,   -195,     -6,    -33,    372,    210,   -168]
  K1( 260,:) = [    372,    183,  -1518,     -6,   -492,   1506,  -1140,    372,    264,  -1140,  -1518,    372,    372,  -2004, &
                 -1140,  -3030,     -6,    183,   1506, -12291,     -6,  -2004,   1506,     -6,    156,    -33,    210,     21, &
                   264,   -168,     -6,     48,    210,    264,    156,    318,     -6,  -1896,     21,  -3084,  -1302,    372, &
                   -60,  -1950,    210,   -600,    210,    -60,    210,   -222,    156,    210,   1533,   -222,    183,    237, &
                 -1302,    696,    102,    264,    -60,  -1950,    588,   -816,    102,    696,   -249,   -546,    399,  -3084, &
                   156,    264,    -33,    264,    156,    210,   -168,     21,    -60,  -1464,    210,    264,    588,   -168, &
                    -6,   -195,  -1302,    696,    399,  -2652,    237,    183,  -1302,    372,    -33,    318,   -222,   1533, &
                   210,    156,   -222,    210,     -6,   -195,     21,    -60,     21,     -6,   -195,     -6,    -33,    372, &
                   210,   -168,     48,     -6,    210,    -60,     21,    372]
  K1( 261,:) = [    372,  -2004,  -1140,  -3030,     -6,    183,  -1518,     -6,    372,    183,   1506,   -492,    264,  -1140, &
                 -1140,    372,    372,  -1518,   1506,     -6, -12291,   1506,  -2004,     -6,    -33,    264,    156,    210, &
                  -168,     21,    -60,  -1464,    210,    264,    588,   -168,     -6,   -195,  -1302,    696,    399,  -2652, &
                   237,    183,  -1302,    372,    -33,    318,    210,     21,    156,    -33,   -168,    264,     -6,  -1896, &
                    21,  -3084,  -1302,    372,     -6,     48,    210,    264,    156,    318,  -1950,    -60,    210,    -60, &
                   210,   -600,    156,    210,    210,   -222,   -222,   1533,    -60,  -1950,    588,   -816,    102,    696, &
                   183,    237,  -1302,    696,    102,    264,   -546,   -249,    156,    264,    399,  -3084,   -222,    210, &
                  1533,   -222,    156,    210,     48,     -6,    210,    -60,     21,    372,   -195,     -6,     21,     -6, &
                    21,    -60,     -6,   -195,    210,   -168,    -33,    372]
  K1( 262,:) = [  -1140,    372,    264,  -1140,  -1518,    372,    372,    183,  -1518,     -6,   -492,   1506,  -1140,  -3030, &
                   372,  -2004,    183,     -6,     -6,  -2004,   1506, -12291,     -6,   1506,    210,   -222,    156,    210, &
                  1533,   -222,    183,    237,  -1302,    696,    102,    264,    -60,  -1950,    588,   -816,    102,    696, &
                  -249,   -546,    399,  -3084,    156,    264,    156,    -33,    210,     21,    264,   -168,     -6,     48, &
                   210,    264,    156,    318,     -6,  -1896,     21,  -3084,  -1302,    372,    -60,  -1950,    210,   -600, &
                   210,    -60,    156,    210,    -33,    264,     21,   -168,     -6,   -195,  -1302,    696,    399,  -2652, &
                   -60,  -1464,    210,    264,    588,   -168,    183,    237,    -33,    318,  -1302,    372,    210,    156, &
                  -222,   1533,    210,   -222,   -195,     -6,    -33,    372,    210,   -168,     -6,   -195,     21,    -60, &
                    21,     -6,     -6,     48,     21,    372,    210,    -60]
  K1( 263,:) = [  -1140,  -3030,    372,  -2004,    183,     -6,    264,  -1140,  -1140,    372,    372,  -1518,  -1518,     -6, &
                   372,    183,   1506,   -492,     -6,   1506,  -2004,     -6, -12291,   1506,    156,    210,    -33,    264, &
                    21,   -168,     -6,   -195,  -1302,    696,    399,  -2652,    -60,  -1464,    210,    264,    588,   -168, &
                   183,    237,    -33,    318,  -1302,    372,    156,    210,    210,   -222,   -222,   1533,    -60,  -1950, &
                   588,   -816,    102,    696,    183,    237,  -1302,    696,    102,    264,   -546,   -249,    156,    264, &
                   399,  -3084,    210,     21,    156,    -33,   -168,    264,     -6,  -1896,     21,  -3084,  -1302,    372, &
                    -6,     48,    210,    264,    156,    318,  -1950,    -60,    210,    -60,    210,   -600,    210,   -222, &
                   156,    210,   1533,   -222,     -6,     48,     21,    372,    210,    -60,     -6,   -195,    210,   -168, &
                   -33,    372,   -195,     -6,     21,     -6,     21,    -60]
  K1( 264,:) = [    264,  -1140,  -1140,    372,    372,  -1518,  -1140,  -3030,    372,  -2004,    183,     -6,    372,    183, &
                 -1518,     -6,   -492,   1506,  -2004,     -6,     -6,   1506,   1506, -12291,    156,    210,    210,   -222, &
                  -222,   1533,    -60,  -1950,    588,   -816,    102,    696,    183,    237,  -1302,    696,    102,    264, &
                  -546,   -249,    156,    264,    399,  -3084,    156,    210,    -33,    264,     21,   -168,     -6,   -195, &
                 -1302,    696,    399,  -2652,    -60,  -1464,    210,    264,    588,   -168,    183,    237,    -33,    318, &
                 -1302,    372,    156,    -33,    210,     21,    264,   -168,     -6,     48,    210,    264,    156,    318, &
                    -6,  -1896,     21,  -3084,  -1302,    372,    -60,  -1950,    210,   -600,    210,    -60,    156,    210, &
                   210,   -222,   -222,   1533,     -6,   -195,    210,   -168,    -33,    372,     -6,     48,     21,    372, &
                   210,    -60,     -6,   -195,     21,    -60,     21,     -6]
  K1( 265,:) = [   1533,   -222,   -222,    210,    210,    156,   -168,    264,   -168,   1533,     21,   -222,     21,    -33, &
                   264,   -222,    210,    210,    210,    156,    -33,    210,    156,    156,   1560,     48,     48,  -1464, &
                 -1464,    912,   -168,    264,     48,     21,   -195,    210,   -168,     21,    480,    210,   1749,  -1302, &
                  1533,   -222,     -6,  -1302,     -6,    588,   1560,     48,   -141,   -141,   -195,    534,   1533,   -222, &
                  -195,     21,     48,    210,   1344,   -357,   1749,     21,   3072,     21,   -114,   -114,   -195,    -33, &
                  -384,    210,   -141,   -195,   -141,   -141,     48,   -195,   -168,     21,     -6,    -33,   -195,    156, &
                  -168,    318,     -6,    210,   -384,    210,   -357,   1344,     48,    399,     48,  -1302,   -141,    534, &
                  -141,   1560,   -195,     48,   -168,    264,     -6,    399,     -6,    102,   -168,   -168,     -6,    156, &
                    48,  -1302,    318,   -168,    480,    102,    480,    588]
  K1( 266,:) = [   -222,   1533,    210,    156,   -222,    210,    264,   -168,     21,   -222,   -168,   1533,    210,    156, &
                   -33,    210,    156,    156,     21,    -33,    264,   -222,    210,    210,     48,   1560,  -1464,    912, &
                    48,  -1464,    264,   -168,   -195,    210,     48,     21,   1533,   -222,     -6,  -1302,     -6,    588, &
                  -168,     21,    480,    210,   1749,  -1302,     48,   1560,   -195,    534,   -141,   -141,   -222,   1533, &
                    48,    210,   -195,     21,   -114,   -114,   -195,    -33,   -384,    210,   1344,   -357,   1749,     21, &
                  3072,     21,   -141,    534,   -141,   1560,   -195,     48,   -168,    264,     -6,    399,     -6,    102, &
                  -168,   -168,     -6,    156,     48,  -1302,    318,   -168,    480,    102,    480,    588,   -141,   -195, &
                  -141,   -141,     48,   -195,   -168,     21,     -6,    -33,   -195,    156,   -168,    318,     -6,    210, &
                  -384,    210,   -357,   1344,     48,    399,     48,  -1302]
  K1( 267,:) = [   -222,    210,   1533,   -222,    156,    210,     21,    -33,    264,   -222,    210,    210,   -168,    264, &
                  -168,   1533,     21,   -222,    156,    210,    156,    156,    -33,    210,     48,  -1464,   1560,     48, &
                   912,  -1464,   -168,     21,    480,    210,   1749,  -1302,   -168,    264,     48,     21,   -195,    210, &
                  -222,   1533,     -6,    588,     -6,  -1302,   -141,   -195,   -141,   -141,     48,   -195,   -168,     21, &
                    -6,    -33,   -195,    156,   -168,    318,     -6,    210,   -384,    210,   -357,   1344,     48,    399, &
                    48,  -1302,   1560,     48,   -141,   -141,   -195,    534,   1533,   -222,   -195,     21,     48,    210, &
                  1344,   -357,   1749,     21,   3072,     21,   -114,   -114,   -195,    -33,   -384,    210,    534,   -141, &
                  -195,     48,   -141,   1560,    264,   -168,     -6,    102,     -6,    399,    318,   -168,    480,    102, &
                   480,    588,   -168,   -168,     -6,    156,     48,  -1302]
  K1( 268,:) = [    210,    156,   -222,   1533,    210,   -222,    210,    156,    -33,    210,    156,    156,    264,   -168, &
                    21,   -222,   -168,   1533,    -33,     21,    210,    210,    264,   -222,  -1464,    912,     48,   1560, &
                 -1464,     48,   1533,   -222,     -6,  -1302,     -6,    588,    264,   -168,   -195,    210,     48,     21, &
                    21,   -168,   1749,  -1302,    480,    210,   -141,    534,   -141,   1560,   -195,     48,   -168,    264, &
                    -6,    399,     -6,    102,   -168,   -168,     -6,    156,     48,  -1302,    318,   -168,    480,    102, &
                   480,    588,     48,   1560,   -195,    534,   -141,   -141,   -222,   1533,     48,    210,   -195,     21, &
                  -114,   -114,   -195,    -33,   -384,    210,   1344,   -357,   1749,     21,   3072,     21,   -195,   -141, &
                    48,   -195,   -141,   -141,     21,   -168,   -195,    156,     -6,    -33,   -357,   1344,     48,    399, &
                    48,  -1302,   -168,    318,     -6,    210,   -384,    210]
  K1( 269,:) = [    210,   -222,    156,    210,   1533,   -222,    -33,     21,    210,    210,    264,   -222,    156,    210, &
                   156,    156,    -33,    210,   -168,    264,   -168,   1533,     21,   -222,  -1464,     48,    912,  -1464, &
                  1560,     48,     21,   -168,   1749,  -1302,    480,    210,   -222,   1533,     -6,    588,     -6,  -1302, &
                  -168,    264,     48,     21,   -195,    210,   -195,   -141,     48,   -195,   -141,   -141,     21,   -168, &
                  -195,    156,     -6,    -33,   -357,   1344,     48,    399,     48,  -1302,   -168,    318,     -6,    210, &
                  -384,    210,    534,   -141,   -195,     48,   -141,   1560,    264,   -168,     -6,    102,     -6,    399, &
                   318,   -168,    480,    102,    480,    588,   -168,   -168,     -6,    156,     48,  -1302,   1560,     48, &
                  -141,   -141,   -195,    534,   1533,   -222,   -195,     21,     48,    210,   1344,   -357,   1749,     21, &
                  3072,     21,   -114,   -114,   -195,    -33,   -384,    210]
  K1( 270,:) = [    156,    210,    210,   -222,   -222,   1533,    156,    210,    156,    156,    -33,    210,    -33,     21, &
                   210,    210,    264,   -222,    264,   -168,     21,   -222,   -168,   1533,    912,  -1464,  -1464,     48, &
                    48,   1560,   -222,   1533,     -6,    588,     -6,  -1302,     21,   -168,   1749,  -1302,    480,    210, &
                   264,   -168,   -195,    210,     48,     21,    534,   -141,   -195,     48,   -141,   1560,    264,   -168, &
                    -6,    102,     -6,    399,    318,   -168,    480,    102,    480,    588,   -168,   -168,     -6,    156, &
                    48,  -1302,   -195,   -141,     48,   -195,   -141,   -141,     21,   -168,   -195,    156,     -6,    -33, &
                  -357,   1344,     48,    399,     48,  -1302,   -168,    318,     -6,    210,   -384,    210,     48,   1560, &
                  -195,    534,   -141,   -141,   -222,   1533,     48,    210,   -195,     21,   -114,   -114,   -195,    -33, &
                  -384,    210,   1344,   -357,   1749,     21,   3072,     21]
  K1( 271,:) = [   -195,     -6,     48,   -195,     -6,     -6,  -1950,    -60,    237,   -249,    183,   -546,  -1896,     48, &
                 -1464,    237,   -195,  -1950,     -6,     -6,    -60,    183,     -6,    -60,   -168,    264,   -168,   1533, &
                    21,   -222,   -384,  -1896,   -168,   -195,   1533,  -1950,   -384,   -384,   -168,     48,   1344,  -1896, &
                  -384,   1317,   -168,    237,   -168,  -1464,   1533,   -222,   -168,   -168,     21,    264,  -1896,    480, &
                   264,     -6,   -222,    -60,   -384,    102,     21,     -6,   -357,     -6,    102,   -384,     21,    183, &
                   318,    -60,   1344,   -114,   -168,   -168,   -357,    318,   -384,    102,   1533,   -195,   -114,     48, &
                  1317,   -384,   -222,     -6,   -114,     -6,   2640,   -816,   -357,   -195,   1344,     -6,   -357,   -114, &
                   318,   -168,   1344,   -168,    102,   -384,   -168,   -249,   -168,    237,   -384,   -384,    264,   -546, &
                  -168,    183,   -816,   -384,    318,  -1950,   -168,    -60]
  K1( 272,:) = [     -6,   -195,     -6,     -6,     48,   -195,    -60,  -1950,    183,   -546,    237,   -249,     -6,     -6, &
                   -60,    183,     -6,    -60,  -1896,     48,  -1464,    237,   -195,  -1950,    264,   -168,     21,   -222, &
                  -168,   1533,  -1896,   -384,   1533,  -1950,   -168,   -195,   -384,   1317,   -168,    237,   -168,  -1464, &
                  -384,   -384,   -168,     48,   1344,  -1896,   -222,   1533,     21,    264,   -168,   -168,    480,  -1896, &
                  -222,    -60,    264,     -6,    102,   -384,     21,    183,    318,    -60,   -384,    102,     21,     -6, &
                  -357,     -6,   -357,   -114,    318,   -168,   1344,   -168,    102,   -384,   -168,   -249,   -168,    237, &
                  -384,   -384,    264,   -546,   -168,    183,   -816,   -384,    318,  -1950,   -168,    -60,   1344,   -114, &
                  -168,   -168,   -357,    318,   -384,    102,   1533,   -195,   -114,     48,   1317,   -384,   -222,     -6, &
                  -114,     -6,   2640,   -816,   -357,   -195,   1344,     -6]
  K1( 273,:) = [     21,     21,    210,    -33,     21,    210,    210,    210,  -1302,    399,    -33,    156,  -1302,    156, &
                   588,    102,    399,    102,     21,    210,    210,  -1302,  -1302,    588,     48,   -195,    480,     -6, &
                  1749,     -6,   -168,   1533,   1560,   1533,   1560,   -168,   -168,   -168,     48,   -222,   -141,     21, &
                  1344,   -168,   -141,   -168,   -141,    264,   -195,     48,     -6,     -6,   -195,     -6,    264,   -222, &
                    48,   -222,     48,    264,   1533,   -168,  -1464,    210,   -141,    210,   -114,   -168,   -195,     21, &
                  -141,    -33,   1749,   -195,     -6,     -6,     48,    480,     21,     21,  -1464,    210,   -195,    -33, &
                  -222,    264,    912,    156,    534,    156,   -357,    318,     48,    210,   -195,    156,   3072,   -384, &
                  -384,     48,     48,    480,   -357,    318,   -141,   1533,   -141,   -222,   -114,   -168,    534,   -222, &
                  1560,    210,   1344,   -168,   -195,    210,     48,    156]
  K1( 274,:) = [     -6,    -60,    -60,    372,    372,   -168,    -60,   -600,    372,  -3084,    318,    264,    372,    318, &
                  -168,    264,  -2652,    696,  -3084,    264,    264,    696,    696,   -816,     21,    210,    210,  -1302, &
                 -1302,    588,   -195,  -1950,   1533, -12291,   -168,   1506,     48,    237,   -222,   1506,   -168,     -6, &
                 -1896,  -1464,     21,     -6,    264,  -2004,     21,    210,    -33,    399,    156,    102,     -6,    -60, &
                  -222,   1506,    264,   -492,   -195,   -249,    210,     -6,   1533,  -1518,     48,    237,    -33,    183, &
                  -222,    372,     21,    -33,    210,    156,    399,    102,     -6,    183,    210,     -6,     21,    183, &
                    -6,   -546,    156,  -2004,   -222,    372,   -195,  -1950,    210,  -3030,    210,  -1140,     21,    210, &
                   210,  -1302,  -1302,    588,     -6,    -60,    210,  -1518,    -33,    372,     -6,    183,    156,    372, &
                   210,  -1140,     -6,    -60,    156,  -1140,    156,    264]
  K1( 275,:) = [     21,     21,     21,    210,    210,    -33,    210,    210,    -33,    156,  -1302,    399,     21,    210, &
                   210,  -1302,  -1302,    588,  -1302,    156,    588,    102,    399,    102,   -195,     48,   1749,     -6, &
                   480,     -6,   1533,   -168,   1560,   -168,   1560,   1533,   1344,   -168,   -141,   -168,   -141,    264, &
                  -168,   -168,     48,   -222,   -141,     21,     48,   -195,   -195,     -6,     -6,     -6,   -222,    264, &
                    48,    264,     48,   -222,   -114,   -168,   -195,     21,   -141,    -33,   1533,   -168,  -1464,    210, &
                  -141,    210,   3072,   -384,   -384,     48,     48,    480,   -357,    318,   -141,   1533,   -141,   -222, &
                  -114,   -168,    534,   -222,   1560,    210,   1344,   -168,   -195,    210,     48,    156,   1749,   -195, &
                    -6,     -6,     48,    480,     21,     21,  -1464,    210,   -195,    -33,   -222,    264,    912,    156, &
                   534,    156,   -357,    318,     48,    210,   -195,    156]
  K1( 276,:) = [    -60,     -6,    372,   -168,    -60,    372,   -600,    -60,    318,    264,    372,  -3084,  -3084,    264, &
                   264,    696,    696,   -816,    372,    318,   -168,    264,  -2652,    696,    210,     21,  -1302,    588, &
                   210,  -1302,  -1950,   -195,   -168,   1506,   1533, -12291,  -1896,  -1464,     21,     -6,    264,  -2004, &
                    48,    237,   -222,   1506,   -168,     -6,    210,     21,    156,    102,    -33,    399,    -60,     -6, &
                   264,   -492,   -222,   1506,     48,    237,    -33,    183,   -222,    372,   -195,   -249,    210,     -6, &
                  1533,  -1518,     21,    210,    210,  -1302,  -1302,    588,     -6,    -60,    210,  -1518,    -33,    372, &
                    -6,    183,    156,    372,    210,  -1140,     -6,    -60,    156,  -1140,    156,    264,     21,    -33, &
                   210,    156,    399,    102,     -6,    183,    210,     -6,     21,    183,     -6,   -546,    156,  -2004, &
                  -222,    372,   -195,  -1950,    210,  -3030,    210,  -1140]
  K1( 277,:) = [     48,   -195,   -195,     -6,     -6,     -6,  -1896,     48,  -1464,    237,   -195,  -1950,  -1950,    -60, &
                   237,   -249,    183,   -546,     -6,     -6,     -6,    -60,    -60,    183,   -168,   1533,   -168,    264, &
                  -222,     21,   -384,   -384,   -168,     48,   1344,  -1896,   -384,  -1896,   -168,   -195,   1533,  -1950, &
                  1317,   -384,   -168,  -1464,   -168,    237,   1344,   -114,   -168,   -168,   -357,    318,   -384,    102, &
                  1533,   -195,   -114,     48,   1317,   -384,   -222,     -6,   -114,     -6,   2640,   -816,   -357,   -195, &
                  1344,     -6,   1533,   -222,   -168,   -168,     21,    264,  -1896,    480,    264,     -6,   -222,    -60, &
                  -384,    102,     21,     -6,   -357,     -6,    102,   -384,     21,    183,    318,    -60,   -114,   -357, &
                  1344,   -168,    318,   -168,   -384,    102,   -168,    237,   -168,   -249,   -816,   -384,    318,  -1950, &
                  -168,    -60,   -384,   -384,    264,   -546,   -168,    183]
  K1( 278,:) = [     -6,     -6,     -6,   -195,   -195,     48,     -6,     -6,    -60,    183,     -6,    -60,    -60,  -1950, &
                   183,   -546,    237,   -249,     48,  -1896,   -195,  -1950,  -1464,    237,     21,   -222,    264,   -168, &
                  1533,   -168,   -384,   1317,   -168,    237,   -168,  -1464,  -1896,   -384,   1533,  -1950,   -168,   -195, &
                  -384,   -384,   1344,  -1896,   -168,     48,   -357,   -114,    318,   -168,   1344,   -168,    102,   -384, &
                  -168,   -249,   -168,    237,   -384,   -384,    264,   -546,   -168,    183,   -816,   -384,    318,  -1950, &
                  -168,    -60,   -222,   1533,     21,    264,   -168,   -168,    480,  -1896,   -222,    -60,    264,     -6, &
                   102,   -384,     21,    183,    318,    -60,   -384,    102,     21,     -6,   -357,     -6,   -114,   1344, &
                  -357,    318,   -168,   -168,    102,   -384,   -114,     48,   1533,   -195,   2640,   -816,   -357,   -195, &
                  1344,     -6,   1317,   -384,   -222,     -6,   -114,     -6]
  K1( 279,:) = [    210,    -33,     21,     21,    210,     21,  -1302,    156,    588,    102,    399,    102,    210,    210, &
                 -1302,    399,    -33,    156,    210,     21,  -1302,    588,    210,  -1302,    480,     -6,     48,   -195, &
                    -6,   1749,   -168,   -168,     48,   -222,   -141,     21,   -168,   1533,   1560,   1533,   1560,   -168, &
                  -168,   1344,   -141,    264,   -141,   -168,   1749,   -195,     -6,     -6,     48,    480,     21,     21, &
                 -1464,    210,   -195,    -33,   -222,    264,    912,    156,    534,    156,   -357,    318,     48,    210, &
                  -195,    156,   -195,     48,     -6,     -6,   -195,     -6,    264,   -222,     48,   -222,     48,    264, &
                  1533,   -168,  -1464,    210,   -141,    210,   -114,   -168,   -195,     21,   -141,    -33,   -384,   3072, &
                    48,    480,   -384,     48,    318,   -357,   -141,   -222,   -141,   1533,   1344,   -168,   -195,    210, &
                    48,    156,   -114,   -168,    534,   -222,   1560,    210]
  K1( 280,:) = [    -60,    372,     -6,    -60,   -168,    372,    372,    318,   -168,    264,  -2652,    696,    -60,   -600, &
                   372,  -3084,    318,    264,    264,  -3084,    696,   -816,    264,    696,    210,  -1302,     21,    210, &
                   588,  -1302,     48,    237,   -222,   1506,   -168,     -6,   -195,  -1950,   1533, -12291,   -168,   1506, &
                 -1464,  -1896,    264,  -2004,     21,     -6,     21,    -33,    210,    156,    399,    102,     -6,    183, &
                   210,     -6,     21,    183,     -6,   -546,    156,  -2004,   -222,    372,   -195,  -1950,    210,  -3030, &
                   210,  -1140,     21,    210,    -33,    399,    156,    102,     -6,    -60,   -222,   1506,    264,   -492, &
                  -195,   -249,    210,     -6,   1533,  -1518,     48,    237,    -33,    183,   -222,    372,    210,     21, &
                 -1302,    588,    210,  -1302,    -60,     -6,    -33,    372,    210,  -1518,     -6,    -60,    156,  -1140, &
                   156,    264,     -6,    183,    156,    372,    210,  -1140]
  K1( 281,:) = [     21,    210,     21,     21,    -33,    210,     21,    210,    210,  -1302,  -1302,    588,    210,    210, &
                   -33,    156,  -1302,    399,    156,  -1302,    399,    102,    588,    102,   1749,     -6,   -195,     48, &
                    -6,    480,   1344,   -168,   -141,   -168,   -141,    264,   1533,   -168,   1560,   -168,   1560,   1533, &
                  -168,   -168,   -141,     21,     48,   -222,   3072,   -384,   -384,     48,     48,    480,   -357,    318, &
                  -141,   1533,   -141,   -222,   -114,   -168,    534,   -222,   1560,    210,   1344,   -168,   -195,    210, &
                    48,    156,     48,   -195,   -195,     -6,     -6,     -6,   -222,    264,     48,    264,     48,   -222, &
                  -114,   -168,   -195,     21,   -141,    -33,   1533,   -168,  -1464,    210,   -141,    210,   -195,   1749, &
                    48,    480,     -6,     -6,     21,     21,   -195,    -33,  -1464,    210,   -357,    318,     48,    210, &
                  -195,    156,   -222,    264,    912,    156,    534,    156]
  K1( 282,:) = [    372,   -168,    -60,     -6,    372,    -60,  -3084,    264,    264,    696,    696,   -816,   -600,    -60, &
                   318,    264,    372,  -3084,    318,    372,  -2652,    696,   -168,    264,  -1302,    588,    210,     21, &
                 -1302,    210,  -1896,  -1464,     21,     -6,    264,  -2004,  -1950,   -195,   -168,   1506,   1533, -12291, &
                   237,     48,   -168,     -6,   -222,   1506,     21,    210,    210,  -1302,  -1302,    588,     -6,    -60, &
                   210,  -1518,    -33,    372,     -6,    183,    156,    372,    210,  -1140,     -6,    -60,    156,  -1140, &
                   156,    264,    210,     21,    156,    102,    -33,    399,    -60,     -6,    264,   -492,   -222,   1506, &
                    48,    237,    -33,    183,   -222,    372,   -195,   -249,    210,     -6,   1533,  -1518,    -33,     21, &
                   399,    102,    210,    156,    183,     -6,     21,    183,    210,     -6,   -195,  -1950,    210,  -3030, &
                   210,  -1140,     -6,   -546,    156,  -2004,   -222,    372]
  K1( 283,:) = [   -195,     48,     -6,     -6,   -195,     -6,     48,  -1896,   -195,  -1950,  -1464,    237,     -6,     -6, &
                    -6,    -60,    -60,    183,  -1950,    -60,    237,   -249,    183,   -546,   1533,   -168,   -222,     21, &
                  -168,    264,   -384,   -384,   1344,  -1896,   -168,     48,   1317,   -384,   -168,  -1464,   -168,    237, &
                  -384,  -1896,   -168,   -195,   1533,  -1950,   -114,   1344,   -357,    318,   -168,   -168,    102,   -384, &
                  -114,     48,   1533,   -195,   2640,   -816,   -357,   -195,   1344,     -6,   1317,   -384,   -222,     -6, &
                  -114,     -6,   -114,   -357,   1344,   -168,    318,   -168,   -384,    102,   -168,    237,   -168,   -249, &
                  -816,   -384,    318,  -1950,   -168,    -60,   -384,   -384,    264,   -546,   -168,    183,   1533,   -222, &
                  -168,   -168,     21,    264,  -1896,    480,    264,     -6,   -222,    -60,   -384,    102,     21,     -6, &
                  -357,     -6,    102,   -384,     21,    183,    318,    -60]
  K1( 284,:) = [     -6,     -6,   -195,     48,     -6,   -195,     -6,     -6,     -6,    -60,    -60,    183,     48,  -1896, &
                  -195,  -1950,  -1464,    237,    -60,  -1950,    183,   -546,    237,   -249,   -222,     21,   1533,   -168, &
                   264,   -168,   1317,   -384,   -168,  -1464,   -168,    237,   -384,   -384,   1344,  -1896,   -168,     48, &
                 -1896,   -384,   1533,  -1950,   -168,   -195,   -114,   -357,   1344,   -168,    318,   -168,   -384,    102, &
                  -168,    237,   -168,   -249,   -816,   -384,    318,  -1950,   -168,    -60,   -384,   -384,    264,   -546, &
                  -168,    183,   -114,   1344,   -357,    318,   -168,   -168,    102,   -384,   -114,     48,   1533,   -195, &
                  2640,   -816,   -357,   -195,   1344,     -6,   1317,   -384,   -222,     -6,   -114,     -6,   -222,   1533, &
                    21,    264,   -168,   -168,    480,  -1896,   -222,    -60,    264,     -6,    102,   -384,     21,    183, &
                   318,    -60,   -384,    102,     21,     -6,   -357,     -6]
  K1( 285,:) = [    -33,    210,    210,     21,     21,     21,    156,  -1302,    399,    102,    588,    102,    210,     21, &
                 -1302,    588,    210,  -1302,    210,    210,  -1302,    399,    -33,    156,     -6,    480,     -6,   1749, &
                    48,   -195,   -168,   -168,   -141,     21,     48,   -222,   -168,   1344,   -141,    264,   -141,   -168, &
                  -168,   1533,   1560,   1533,   1560,   -168,   -195,   1749,     48,    480,     -6,     -6,     21,     21, &
                  -195,    -33,  -1464,    210,   -357,    318,     48,    210,   -195,    156,   -222,    264,    912,    156, &
                   534,    156,   -384,   3072,     48,    480,   -384,     48,    318,   -357,   -141,   -222,   -141,   1533, &
                  1344,   -168,   -195,    210,     48,    156,   -114,   -168,    534,   -222,   1560,    210,   -195,     48, &
                    -6,     -6,   -195,     -6,    264,   -222,     48,   -222,     48,    264,   1533,   -168,  -1464,    210, &
                  -141,    210,   -114,   -168,   -195,     21,   -141,    -33]
  K1( 286,:) = [    372,    -60,   -168,    372,     -6,    -60,    318,    372,  -2652,    696,   -168,    264,    264,  -3084, &
                   696,   -816,    264,    696,    -60,   -600,    372,  -3084,    318,    264,  -1302,    210,    588,  -1302, &
                    21,    210,    237,     48,   -168,     -6,   -222,   1506,  -1464,  -1896,    264,  -2004,     21,     -6, &
                  -195,  -1950,   1533, -12291,   -168,   1506,    -33,     21,    399,    102,    210,    156,    183,     -6, &
                    21,    183,    210,     -6,   -195,  -1950,    210,  -3030,    210,  -1140,     -6,   -546,    156,  -2004, &
                  -222,    372,    210,     21,  -1302,    588,    210,  -1302,    -60,     -6,    -33,    372,    210,  -1518, &
                    -6,    -60,    156,  -1140,    156,    264,     -6,    183,    156,    372,    210,  -1140,     21,    210, &
                   -33,    399,    156,    102,     -6,    -60,   -222,   1506,    264,   -492,   -195,   -249,    210,     -6, &
                  1533,  -1518,     48,    237,    -33,    183,   -222,    372]
  K1( 287,:) = [    210,     21,    -33,    210,     21,     21,    210,     21,  -1302,    588,    210,  -1302,    156,  -1302, &
                   399,    102,    588,    102,    210,    210,    -33,    156,  -1302,    399,     -6,   1749,     -6,    480, &
                  -195,     48,   -168,   1344,   -141,    264,   -141,   -168,   -168,   -168,   -141,     21,     48,   -222, &
                  1533,   -168,   1560,   -168,   1560,   1533,   -384,   3072,     48,    480,   -384,     48,    318,   -357, &
                  -141,   -222,   -141,   1533,   1344,   -168,   -195,    210,     48,    156,   -114,   -168,    534,   -222, &
                  1560,    210,   -195,   1749,     48,    480,     -6,     -6,     21,     21,   -195,    -33,  -1464,    210, &
                  -357,    318,     48,    210,   -195,    156,   -222,    264,    912,    156,    534,    156,     48,   -195, &
                  -195,     -6,     -6,     -6,   -222,    264,     48,    264,     48,   -222,   -114,   -168,   -195,     21, &
                  -141,    -33,   1533,   -168,  -1464,    210,   -141,    210]
  K1( 288,:) = [   -168,    372,    372,    -60,    -60,     -6,    264,  -3084,    696,   -816,    264,    696,    318,    372, &
                 -2652,    696,   -168,    264,   -600,    -60,    318,    264,    372,  -3084,    588,  -1302,  -1302,    210, &
                   210,     21,  -1464,  -1896,    264,  -2004,     21,     -6,    237,     48,   -168,     -6,   -222,   1506, &
                 -1950,   -195,   -168,   1506,   1533, -12291,    210,     21,  -1302,    588,    210,  -1302,    -60,     -6, &
                   -33,    372,    210,  -1518,     -6,    -60,    156,  -1140,    156,    264,     -6,    183,    156,    372, &
                   210,  -1140,    -33,     21,    399,    102,    210,    156,    183,     -6,     21,    183,    210,     -6, &
                  -195,  -1950,    210,  -3030,    210,  -1140,     -6,   -546,    156,  -2004,   -222,    372,    210,     21, &
                   156,    102,    -33,    399,    -60,     -6,    264,   -492,   -222,   1506,     48,    237,    -33,    183, &
                  -222,    372,   -195,   -249,    210,     -6,   1533,  -1518]
  K1( 289,:) = [   -168,    264,   -168,   1533,     21,   -222,   1533,   -222,   -222,    210,    210,    156,    264,   -222, &
                    21,    -33,    210,    210,    -33,    210,    210,    156,    156,    156,   1560,     48,   -141,   -141, &
                  -195,    534,   1533,   -222,   -195,     21,     48,    210,   1344,   -357,   1749,     21,   3072,     21, &
                  -114,   -114,   -195,    -33,   -384,    210,   1560,     48,     48,  -1464,  -1464,    912,   -168,    264, &
                    48,     21,   -195,    210,   -168,     21,    480,    210,   1749,  -1302,   1533,   -222,     -6,  -1302, &
                    -6,    588,   -141,   -141,   -141,   -195,   -195,     48,   -168,    318,     -6,    210,   -384,    210, &
                  -168,     21,     -6,    -33,   -195,    156,   1344,   -357,     48,  -1302,     48,    399,   -141,   1560, &
                  -141,    534,     48,   -195,   -168,   -168,     -6,    156,     48,  -1302,   -168,    264,     -6,    399, &
                    -6,    102,   -168,    318,    480,    588,    480,    102]
  K1( 290,:) = [    264,   -168,     21,   -222,   -168,   1533,   -222,   1533,    210,    156,   -222,    210,    -33,    210, &
                   210,    156,    156,    156,    264,   -222,     21,    -33,    210,    210,     48,   1560,   -195,    534, &
                  -141,   -141,   -222,   1533,     48,    210,   -195,     21,   -114,   -114,   -195,    -33,   -384,    210, &
                  1344,   -357,   1749,     21,   3072,     21,     48,   1560,  -1464,    912,     48,  -1464,    264,   -168, &
                  -195,    210,     48,     21,   1533,   -222,     -6,  -1302,     -6,    588,   -168,     21,    480,    210, &
                  1749,  -1302,   -141,   1560,   -141,    534,     48,   -195,   -168,   -168,     -6,    156,     48,  -1302, &
                  -168,    264,     -6,    399,     -6,    102,   -168,    318,    480,    588,    480,    102,   -141,   -141, &
                  -141,   -195,   -195,     48,   -168,    318,     -6,    210,   -384,    210,   -168,     21,     -6,    -33, &
                  -195,    156,   1344,   -357,     48,  -1302,     48,    399]
  K1( 291,:) = [     21,    -33,    264,   -222,    210,    210,   -222,    210,   1533,   -222,    156,    210,   -168,   1533, &
                  -168,    264,   -222,     21,    156,    156,    156,    210,    210,    -33,   -141,   -195,   -141,   -141, &
                    48,   -195,   -168,     21,     -6,    -33,   -195,    156,   -168,    318,     -6,    210,   -384,    210, &
                  -357,   1344,     48,    399,     48,  -1302,     48,  -1464,   1560,     48,    912,  -1464,   -168,     21, &
                   480,    210,   1749,  -1302,   -168,    264,     48,     21,   -195,    210,   -222,   1533,     -6,    588, &
                    -6,  -1302,   -141,   -141,   1560,     48,    534,   -195,   1344,   -357,   1749,     21,   3072,     21, &
                  1533,   -222,   -195,     21,     48,    210,   -114,   -114,   -384,    210,   -195,    -33,   -195,     48, &
                   534,   -141,   1560,   -141,    318,   -168,    480,    102,    480,    588,    264,   -168,     -6,    102, &
                    -6,    399,   -168,   -168,     48,  -1302,     -6,    156]
  K1( 292,:) = [    210,    156,    -33,    210,    156,    156,    210,    156,   -222,   1533,    210,   -222,     21,   -222, &
                   264,   -168,   1533,   -168,    210,    210,    -33,     21,   -222,    264,   -141,    534,   -141,   1560, &
                  -195,     48,   -168,    264,     -6,    399,     -6,    102,   -168,   -168,     -6,    156,     48,  -1302, &
                   318,   -168,    480,    102,    480,    588,  -1464,    912,     48,   1560,  -1464,     48,   1533,   -222, &
                    -6,  -1302,     -6,    588,    264,   -168,   -195,    210,     48,     21,     21,   -168,   1749,  -1302, &
                   480,    210,   -195,    534,     48,   1560,   -141,   -141,   -114,   -114,   -195,    -33,   -384,    210, &
                  -222,   1533,     48,    210,   -195,     21,   -357,   1344,   3072,     21,   1749,     21,     48,   -195, &
                  -195,   -141,   -141,   -141,   -357,   1344,     48,    399,     48,  -1302,     21,   -168,   -195,    156, &
                    -6,    -33,    318,   -168,   -384,    210,     -6,    210]
  K1( 293,:) = [    -33,     21,    210,    210,    264,   -222,    210,   -222,    156,    210,   1533,   -222,    156,    156, &
                   156,    210,    210,    -33,   -168,   1533,   -168,    264,   -222,     21,   -195,   -141,     48,   -195, &
                  -141,   -141,     21,   -168,   -195,    156,     -6,    -33,   -357,   1344,     48,    399,     48,  -1302, &
                  -168,    318,     -6,    210,   -384,    210,  -1464,     48,    912,  -1464,   1560,     48,     21,   -168, &
                  1749,  -1302,    480,    210,   -222,   1533,     -6,    588,     -6,  -1302,   -168,    264,     48,     21, &
                  -195,    210,   -195,     48,    534,   -141,   1560,   -141,    318,   -168,    480,    102,    480,    588, &
                   264,   -168,     -6,    102,     -6,    399,   -168,   -168,     48,  -1302,     -6,    156,   -141,   -141, &
                  1560,     48,    534,   -195,   1344,   -357,   1749,     21,   3072,     21,   1533,   -222,   -195,     21, &
                    48,    210,   -114,   -114,   -384,    210,   -195,    -33]
  K1( 294,:) = [    156,    210,    156,    156,    -33,    210,    156,    210,    210,   -222,   -222,   1533,    210,    210, &
                   -33,     21,   -222,    264,     21,   -222,    264,   -168,   1533,   -168,    534,   -141,   -195,     48, &
                  -141,   1560,    264,   -168,     -6,    102,     -6,    399,    318,   -168,    480,    102,    480,    588, &
                  -168,   -168,     -6,    156,     48,  -1302,    912,  -1464,  -1464,     48,     48,   1560,   -222,   1533, &
                    -6,    588,     -6,  -1302,     21,   -168,   1749,  -1302,    480,    210,    264,   -168,   -195,    210, &
                    48,     21,     48,   -195,   -195,   -141,   -141,   -141,   -357,   1344,     48,    399,     48,  -1302, &
                    21,   -168,   -195,    156,     -6,    -33,    318,   -168,   -384,    210,     -6,    210,   -195,    534, &
                    48,   1560,   -141,   -141,   -114,   -114,   -195,    -33,   -384,    210,   -222,   1533,     48,    210, &
                  -195,     21,   -357,   1344,   3072,     21,   1749,     21]
  K1( 295,:) = [  -1950,    -60,    237,   -249,    183,   -546,   -195,     -6,     48,   -195,     -6,     -6,  -1464,    237, &
                 -1896,     48,  -1950,   -195,    -60,    183,     -6,     -6,    -60,     -6,   1533,   -222,   -168,   -168, &
                    21,    264,  -1896,    480,    264,     -6,   -222,    -60,   -384,    102,     21,     -6,   -357,     -6, &
                   102,   -384,     21,    183,    318,    -60,   -168,    264,   -168,   1533,     21,   -222,   -384,  -1896, &
                  -168,   -195,   1533,  -1950,   -384,   -384,   -168,     48,   1344,  -1896,   -384,   1317,   -168,    237, &
                  -168,  -1464,   -168,   -168,   1344,   -114,    318,   -357,   1317,   -384,   -222,     -6,   -114,     -6, &
                  -384,    102,   1533,   -195,   -114,     48,   -816,   2640,   1344,     -6,   -357,   -195,    318,   -168, &
                  -357,   -114,   -168,   1344,   -384,   -384,    264,   -546,   -168,    183,    102,   -384,   -168,   -249, &
                  -168,    237,   -384,   -816,   -168,    -60,    318,  -1950]
  K1( 296,:) = [    -60,  -1950,    183,   -546,    237,   -249,     -6,   -195,     -6,     -6,     48,   -195,    -60,    183, &
                    -6,     -6,    -60,     -6,  -1464,    237,  -1896,     48,  -1950,   -195,   -222,   1533,     21,    264, &
                  -168,   -168,    480,  -1896,   -222,    -60,    264,     -6,    102,   -384,     21,    183,    318,    -60, &
                  -384,    102,     21,     -6,   -357,     -6,    264,   -168,     21,   -222,   -168,   1533,  -1896,   -384, &
                  1533,  -1950,   -168,   -195,   -384,   1317,   -168,    237,   -168,  -1464,   -384,   -384,   -168,     48, &
                  1344,  -1896,    318,   -168,   -357,   -114,   -168,   1344,   -384,   -384,    264,   -546,   -168,    183, &
                   102,   -384,   -168,   -249,   -168,    237,   -384,   -816,   -168,    -60,    318,  -1950,   -168,   -168, &
                  1344,   -114,    318,   -357,   1317,   -384,   -222,     -6,   -114,     -6,   -384,    102,   1533,   -195, &
                  -114,     48,   -816,   2640,   1344,     -6,   -357,   -195]
  K1( 297,:) = [    210,    210,  -1302,    399,    -33,    156,     21,     21,    210,    -33,     21,    210,    588,    102, &
                 -1302,    156,    102,    399,    210,  -1302,     21,    210,    588,  -1302,   -195,     48,     -6,     -6, &
                  -195,     -6,    264,   -222,     48,   -222,     48,    264,   1533,   -168,  -1464,    210,   -141,    210, &
                  -114,   -168,   -195,     21,   -141,    -33,     48,   -195,    480,     -6,   1749,     -6,   -168,   1533, &
                  1560,   1533,   1560,   -168,   -168,   -168,     48,   -222,   -141,     21,   1344,   -168,   -141,   -168, &
                  -141,    264,     -6,     -6,   1749,   -195,    480,     48,   -222,    264,    912,    156,    534,    156, &
                    21,     21,  -1464,    210,   -195,    -33,    318,   -357,   -195,    156,     48,    210,   -384,     48, &
                  3072,   -384,    480,     48,   -114,   -168,    534,   -222,   1560,    210,   -357,    318,   -141,   1533, &
                  -141,   -222,   -168,   1344,     48,    156,   -195,    210]
  K1( 298,:) = [    -60,   -600,    372,  -3084,    318,    264,     -6,    -60,    -60,    372,    372,   -168,   -168,    264, &
                   372,    318,    696,  -2652,    264,    696,  -3084,    264,   -816,    696,     21,    210,    -33,    399, &
                   156,    102,     -6,    -60,   -222,   1506,    264,   -492,   -195,   -249,    210,     -6,   1533,  -1518, &
                    48,    237,    -33,    183,   -222,    372,     21,    210,    210,  -1302,  -1302,    588,   -195,  -1950, &
                  1533, -12291,   -168,   1506,     48,    237,   -222,   1506,   -168,     -6,  -1896,  -1464,     21,     -6, &
                   264,  -2004,    210,    156,     21,    -33,    102,    399,     -6,   -546,    156,  -2004,   -222,    372, &
                    -6,    183,    210,     -6,     21,    183,  -1950,   -195,    210,  -1140,    210,  -3030,    210,  -1302, &
                    21,    210,    588,  -1302,     -6,    183,    156,    372,    210,  -1140,     -6,    -60,    210,  -1518, &
                   -33,    372,    -60,     -6,    156,    264,    156,  -1140]
  K1( 299,:) = [    210,    210,    -33,    156,  -1302,    399,     21,     21,     21,    210,    210,    -33,    210,  -1302, &
                    21,    210,    588,  -1302,    588,    102,  -1302,    156,    102,    399,     48,   -195,   -195,     -6, &
                    -6,     -6,   -222,    264,     48,    264,     48,   -222,   -114,   -168,   -195,     21,   -141,    -33, &
                  1533,   -168,  -1464,    210,   -141,    210,   -195,     48,   1749,     -6,    480,     -6,   1533,   -168, &
                  1560,   -168,   1560,   1533,   1344,   -168,   -141,   -168,   -141,    264,   -168,   -168,     48,   -222, &
                  -141,     21,   -384,     48,   3072,   -384,    480,     48,   -114,   -168,    534,   -222,   1560,    210, &
                  -357,    318,   -141,   1533,   -141,   -222,   -168,   1344,     48,    156,   -195,    210,     -6,     -6, &
                  1749,   -195,    480,     48,   -222,    264,    912,    156,    534,    156,     21,     21,  -1464,    210, &
                  -195,    -33,    318,   -357,   -195,    156,     48,    210]
  K1( 300,:) = [   -600,    -60,    318,    264,    372,  -3084,    -60,     -6,    372,   -168,    -60,    372,    264,    696, &
                 -3084,    264,   -816,    696,   -168,    264,    372,    318,    696,  -2652,    210,     21,    156,    102, &
                   -33,    399,    -60,     -6,    264,   -492,   -222,   1506,     48,    237,    -33,    183,   -222,    372, &
                  -195,   -249,    210,     -6,   1533,  -1518,    210,     21,  -1302,    588,    210,  -1302,  -1950,   -195, &
                  -168,   1506,   1533, -12291,  -1896,  -1464,     21,     -6,    264,  -2004,     48,    237,   -222,   1506, &
                  -168,     -6,    210,  -1302,     21,    210,    588,  -1302,     -6,    183,    156,    372,    210,  -1140, &
                    -6,    -60,    210,  -1518,    -33,    372,    -60,     -6,    156,    264,    156,  -1140,    210,    156, &
                    21,    -33,    102,    399,     -6,   -546,    156,  -2004,   -222,    372,     -6,    183,    210,     -6, &
                    21,    183,  -1950,   -195,    210,  -1140,    210,  -3030]
  K1( 301,:) = [  -1896,     48,  -1464,    237,   -195,  -1950,     48,   -195,   -195,     -6,     -6,     -6,    237,   -249, &
                 -1950,    -60,   -546,    183,     -6,    -60,     -6,     -6,    183,    -60,   1344,   -114,   -168,   -168, &
                  -357,    318,   -384,    102,   1533,   -195,   -114,     48,   1317,   -384,   -222,     -6,   -114,     -6, &
                  2640,   -816,   -357,   -195,   1344,     -6,   -168,   1533,   -168,    264,   -222,     21,   -384,   -384, &
                  -168,     48,   1344,  -1896,   -384,  -1896,   -168,   -195,   1533,  -1950,   1317,   -384,   -168,  -1464, &
                  -168,    237,   -168,   -168,   1533,   -222,    264,     21,   -384,    102,     21,     -6,   -357,     -6, &
                 -1896,    480,    264,     -6,   -222,    -60,   -384,    102,    318,    -60,     21,    183,   1344,   -168, &
                  -114,   -357,   -168,    318,   -816,   -384,    318,  -1950,   -168,    -60,   -384,    102,   -168,    237, &
                  -168,   -249,   -384,   -384,   -168,    183,    264,   -546]
  K1( 302,:) = [     -6,     -6,    -60,    183,     -6,    -60,     -6,     -6,     -6,   -195,   -195,     48,    183,   -546, &
                   -60,  -1950,   -249,    237,   -195,  -1950,     48,  -1896,    237,  -1464,   -357,   -114,    318,   -168, &
                  1344,   -168,    102,   -384,   -168,   -249,   -168,    237,   -384,   -384,    264,   -546,   -168,    183, &
                  -816,   -384,    318,  -1950,   -168,    -60,     21,   -222,    264,   -168,   1533,   -168,   -384,   1317, &
                  -168,    237,   -168,  -1464,  -1896,   -384,   1533,  -1950,   -168,   -195,   -384,   -384,   1344,  -1896, &
                  -168,     48,     21,    264,   -222,   1533,   -168,   -168,    102,   -384,     21,    183,    318,    -60, &
                   480,  -1896,   -222,    -60,    264,     -6,    102,   -384,   -357,     -6,     21,     -6,   -357,    318, &
                  -114,   1344,   -168,   -168,   2640,   -816,   -357,   -195,   1344,     -6,    102,   -384,   -114,     48, &
                  1533,   -195,   -384,   1317,   -114,     -6,   -222,     -6]
  K1( 303,:) = [  -1302,    156,    588,    102,    399,    102,    210,    -33,     21,     21,    210,     21,  -1302,    399, &
                   210,    210,    156,    -33,  -1302,    588,    210,     21,  -1302,    210,   1749,   -195,     -6,     -6, &
                    48,    480,     21,     21,  -1464,    210,   -195,    -33,   -222,    264,    912,    156,    534,    156, &
                  -357,    318,     48,    210,   -195,    156,    480,     -6,     48,   -195,     -6,   1749,   -168,   -168, &
                    48,   -222,   -141,     21,   -168,   1533,   1560,   1533,   1560,   -168,   -168,   1344,   -141,    264, &
                  -141,   -168,     -6,     -6,   -195,     48,     -6,   -195,   1533,   -168,  -1464,    210,   -141,    210, &
                   264,   -222,     48,   -222,     48,    264,   -168,   -114,   -141,    -33,   -195,     21,     48,    480, &
                  -384,   3072,     48,   -384,   1344,   -168,   -195,    210,     48,    156,    318,   -357,   -141,   -222, &
                  -141,   1533,   -168,   -114,   1560,    210,    534,   -222]
  K1( 304,:) = [    372,    318,   -168,    264,  -2652,    696,    -60,    372,     -6,    -60,   -168,    372,    372,  -3084, &
                   -60,   -600,    264,    318,    696,   -816,    264,  -3084,    696,    264,     21,    -33,    210,    156, &
                   399,    102,     -6,    183,    210,     -6,     21,    183,     -6,   -546,    156,  -2004,   -222,    372, &
                  -195,  -1950,    210,  -3030,    210,  -1140,    210,  -1302,     21,    210,    588,  -1302,     48,    237, &
                  -222,   1506,   -168,     -6,   -195,  -1950,   1533, -12291,   -168,   1506,  -1464,  -1896,    264,  -2004, &
                    21,     -6,    -33,    399,     21,    210,    102,    156,   -195,   -249,    210,     -6,   1533,  -1518, &
                    -6,    -60,   -222,   1506,    264,   -492,    237,     48,   -222,    372,    -33,    183,  -1302,    588, &
                   210,     21,  -1302,    210,     -6,    -60,    156,  -1140,    156,    264,    -60,     -6,    -33,    372, &
                   210,  -1518,    183,     -6,    210,  -1140,    156,    372]
  K1( 305,:) = [     21,    210,    210,  -1302,  -1302,    588,     21,    210,     21,     21,    -33,    210,    -33,    156, &
                   210,    210,    399,  -1302,    399,    102,    156,  -1302,    102,    588,   3072,   -384,   -384,     48, &
                    48,    480,   -357,    318,   -141,   1533,   -141,   -222,   -114,   -168,    534,   -222,   1560,    210, &
                  1344,   -168,   -195,    210,     48,    156,   1749,     -6,   -195,     48,     -6,    480,   1344,   -168, &
                  -141,   -168,   -141,    264,   1533,   -168,   1560,   -168,   1560,   1533,   -168,   -168,   -141,     21, &
                    48,   -222,   -195,     -6,     48,   -195,     -6,     -6,   -114,   -168,   -195,     21,   -141,    -33, &
                  -222,    264,     48,    264,     48,   -222,   -168,   1533,   -141,    210,  -1464,    210,     48,    480, &
                  -195,   1749,     -6,     -6,   -357,    318,     48,    210,   -195,    156,     21,     21,   -195,    -33, &
                 -1464,    210,    264,   -222,    534,    156,    912,    156]
  K1( 306,:) = [  -3084,    264,    264,    696,    696,   -816,    372,   -168,    -60,     -6,    372,    -60,    318,    264, &
                  -600,    -60,  -3084,    372,  -2652,    696,    318,    372,    264,   -168,     21,    210,    210,  -1302, &
                 -1302,    588,     -6,    -60,    210,  -1518,    -33,    372,     -6,    183,    156,    372,    210,  -1140, &
                    -6,    -60,    156,  -1140,    156,    264,  -1302,    588,    210,     21,  -1302,    210,  -1896,  -1464, &
                    21,     -6,    264,  -2004,  -1950,   -195,   -168,   1506,   1533, -12291,    237,     48,   -168,     -6, &
                  -222,   1506,    156,    102,    210,     21,    399,    -33,     48,    237,    -33,    183,   -222,    372, &
                   -60,     -6,    264,   -492,   -222,   1506,   -249,   -195,   1533,  -1518,    210,     -6,    399,    102, &
                   -33,     21,    156,    210,   -195,  -1950,    210,  -3030,    210,  -1140,    183,     -6,     21,    183, &
                   210,     -6,   -546,     -6,   -222,    372,    156,  -2004]
  K1( 307,:) = [     48,  -1896,   -195,  -1950,  -1464,    237,   -195,     48,     -6,     -6,   -195,     -6,     -6,    -60, &
                    -6,     -6,    183,    -60,    237,   -249,  -1950,    -60,   -546,    183,   -114,   1344,   -357,    318, &
                  -168,   -168,    102,   -384,   -114,     48,   1533,   -195,   2640,   -816,   -357,   -195,   1344,     -6, &
                  1317,   -384,   -222,     -6,   -114,     -6,   1533,   -168,   -222,     21,   -168,    264,   -384,   -384, &
                  1344,  -1896,   -168,     48,   1317,   -384,   -168,  -1464,   -168,    237,   -384,  -1896,   -168,   -195, &
                  1533,  -1950,   1344,   -168,   -114,   -357,   -168,    318,   -816,   -384,    318,  -1950,   -168,    -60, &
                  -384,    102,   -168,    237,   -168,   -249,   -384,   -384,   -168,    183,    264,   -546,   -168,   -168, &
                  1533,   -222,    264,     21,   -384,    102,     21,     -6,   -357,     -6,  -1896,    480,    264,     -6, &
                  -222,    -60,   -384,    102,    318,    -60,     21,    183]
  K1( 308,:) = [     -6,     -6,     -6,    -60,    -60,    183,     -6,     -6,   -195,     48,     -6,   -195,   -195,  -1950, &
                    48,  -1896,    237,  -1464,    183,   -546,    -60,  -1950,   -249,    237,   -114,   -357,   1344,   -168, &
                   318,   -168,   -384,    102,   -168,    237,   -168,   -249,   -816,   -384,    318,  -1950,   -168,    -60, &
                  -384,   -384,    264,   -546,   -168,    183,   -222,     21,   1533,   -168,    264,   -168,   1317,   -384, &
                  -168,  -1464,   -168,    237,   -384,   -384,   1344,  -1896,   -168,     48,  -1896,   -384,   1533,  -1950, &
                  -168,   -195,   -357,    318,   -114,   1344,   -168,   -168,   2640,   -816,   -357,   -195,   1344,     -6, &
                   102,   -384,   -114,     48,   1533,   -195,   -384,   1317,   -114,     -6,   -222,     -6,     21,    264, &
                  -222,   1533,   -168,   -168,    102,   -384,     21,    183,    318,    -60,    480,  -1896,   -222,    -60, &
                   264,     -6,    102,   -384,   -357,     -6,     21,     -6]
  K1( 309,:) = [    156,  -1302,    399,    102,    588,    102,    -33,    210,    210,     21,     21,     21,  -1302,    588, &
                   210,     21,  -1302,    210,  -1302,    399,    210,    210,    156,    -33,   -195,   1749,     48,    480, &
                    -6,     -6,     21,     21,   -195,    -33,  -1464,    210,   -357,    318,     48,    210,   -195,    156, &
                  -222,    264,    912,    156,    534,    156,     -6,    480,     -6,   1749,     48,   -195,   -168,   -168, &
                  -141,     21,     48,   -222,   -168,   1344,   -141,    264,   -141,   -168,   -168,   1533,   1560,   1533, &
                  1560,   -168,     48,    480,   -384,   3072,     48,   -384,   1344,   -168,   -195,    210,     48,    156, &
                   318,   -357,   -141,   -222,   -141,   1533,   -168,   -114,   1560,    210,    534,   -222,     -6,     -6, &
                  -195,     48,     -6,   -195,   1533,   -168,  -1464,    210,   -141,    210,    264,   -222,     48,   -222, &
                    48,    264,   -168,   -114,   -141,    -33,   -195,     21]
  K1( 310,:) = [    318,    372,  -2652,    696,   -168,    264,    372,    -60,   -168,    372,     -6,    -60,    696,   -816, &
                   264,  -3084,    696,    264,    372,  -3084,    -60,   -600,    264,    318,    -33,     21,    399,    102, &
                   210,    156,    183,     -6,     21,    183,    210,     -6,   -195,  -1950,    210,  -3030,    210,  -1140, &
                    -6,   -546,    156,  -2004,   -222,    372,  -1302,    210,    588,  -1302,     21,    210,    237,     48, &
                  -168,     -6,   -222,   1506,  -1464,  -1896,    264,  -2004,     21,     -6,   -195,  -1950,   1533, -12291, &
                  -168,   1506,  -1302,    588,    210,     21,  -1302,    210,     -6,    -60,    156,  -1140,    156,    264, &
                   -60,     -6,    -33,    372,    210,  -1518,    183,     -6,    210,  -1140,    156,    372,    -33,    399, &
                    21,    210,    102,    156,   -195,   -249,    210,     -6,   1533,  -1518,     -6,    -60,   -222,   1506, &
                   264,   -492,    237,     48,   -222,    372,    -33,    183]
  K1( 311,:) = [    210,     21,  -1302,    588,    210,  -1302,    210,     21,    -33,    210,     21,     21,    399,    102, &
                   156,  -1302,    102,    588,    -33,    156,    210,    210,    399,  -1302,   -384,   3072,     48,    480, &
                  -384,     48,    318,   -357,   -141,   -222,   -141,   1533,   1344,   -168,   -195,    210,     48,    156, &
                  -114,   -168,    534,   -222,   1560,    210,     -6,   1749,     -6,    480,   -195,     48,   -168,   1344, &
                  -141,    264,   -141,   -168,   -168,   -168,   -141,     21,     48,   -222,   1533,   -168,   1560,   -168, &
                  1560,   1533,     48,    480,   -195,   1749,     -6,     -6,   -357,    318,     48,    210,   -195,    156, &
                    21,     21,   -195,    -33,  -1464,    210,    264,   -222,    534,    156,    912,    156,   -195,     -6, &
                    48,   -195,     -6,     -6,   -114,   -168,   -195,     21,   -141,    -33,   -222,    264,     48,    264, &
                    48,   -222,   -168,   1533,   -141,    210,  -1464,    210]
  K1( 312,:) = [    264,  -3084,    696,   -816,    264,    696,   -168,    372,    372,    -60,    -60,     -6,  -2652,    696, &
                   318,    372,    264,   -168,    318,    264,   -600,    -60,  -3084,    372,    210,     21,  -1302,    588, &
                   210,  -1302,    -60,     -6,    -33,    372,    210,  -1518,     -6,    -60,    156,  -1140,    156,    264, &
                    -6,    183,    156,    372,    210,  -1140,    588,  -1302,  -1302,    210,    210,     21,  -1464,  -1896, &
                   264,  -2004,     21,     -6,    237,     48,   -168,     -6,   -222,   1506,  -1950,   -195,   -168,   1506, &
                  1533, -12291,    399,    102,    -33,     21,    156,    210,   -195,  -1950,    210,  -3030,    210,  -1140, &
                   183,     -6,     21,    183,    210,     -6,   -546,     -6,   -222,    372,    156,  -2004,    156,    102, &
                   210,     21,    399,    -33,     48,    237,    -33,    183,   -222,    372,    -60,     -6,    264,   -492, &
                  -222,   1506,   -249,   -195,   1533,  -1518,    210,     -6]
  K1( 313,:) = [   -168,   1533,   -168,    264,   -222,     21,    264,   -222,     21,    -33,    210,    210,   1533,   -222, &
                  -222,    210,    210,    156,    210,    -33,    156,    156,    210,    156,   -141,   -141,   1560,     48, &
                   534,   -195,   1344,   -357,   1749,     21,   3072,     21,   1533,   -222,   -195,     21,     48,    210, &
                  -114,   -114,   -384,    210,   -195,    -33,   -141,   -141,   -141,   -195,   -195,     48,   -168,    318, &
                    -6,    210,   -384,    210,   -168,     21,     -6,    -33,   -195,    156,   1344,   -357,     48,  -1302, &
                    48,    399,   1560,     48,     48,  -1464,  -1464,    912,   -168,    264,     48,     21,   -195,    210, &
                  -168,     21,    480,    210,   1749,  -1302,   1533,   -222,     -6,  -1302,     -6,    588,   1560,   -141, &
                    48,   -195,   -141,    534,   -168,   -168,     48,  -1302,     -6,    156,   -168,    318,    480,    588, &
                   480,    102,   -168,    264,     -6,    399,     -6,    102]
  K1( 314,:) = [     21,   -222,    264,   -168,   1533,   -168,    -33,    210,    210,    156,    156,    156,   -222,   1533, &
                   210,    156,   -222,    210,   -222,    264,    210,    210,     21,    -33,   -195,    534,     48,   1560, &
                  -141,   -141,   -114,   -114,   -195,    -33,   -384,    210,   -222,   1533,     48,    210,   -195,     21, &
                  -357,   1344,   3072,     21,   1749,     21,   -141,   1560,   -141,    534,     48,   -195,   -168,   -168, &
                    -6,    156,     48,  -1302,   -168,    264,     -6,    399,     -6,    102,   -168,    318,    480,    588, &
                   480,    102,     48,   1560,  -1464,    912,     48,  -1464,    264,   -168,   -195,    210,     48,     21, &
                  1533,   -222,     -6,  -1302,     -6,    588,   -168,     21,    480,    210,   1749,  -1302,   -141,   -141, &
                  -195,     48,   -141,   -195,    318,   -168,   -384,    210,     -6,    210,   1344,   -357,     48,  -1302, &
                    48,    399,   -168,     21,     -6,    -33,   -195,    156]
  K1( 315,:) = [    264,   -222,     21,    -33,    210,    210,   -168,   1533,   -168,    264,   -222,     21,   -222,    210, &
                  1533,   -222,    156,    210,    156,    156,    210,    -33,    156,    210,   -141,   -141,   -141,   -195, &
                  -195,     48,   -168,    318,     -6,    210,   -384,    210,   -168,     21,     -6,    -33,   -195,    156, &
                  1344,   -357,     48,  -1302,     48,    399,   -141,   -141,   1560,     48,    534,   -195,   1344,   -357, &
                  1749,     21,   3072,     21,   1533,   -222,   -195,     21,     48,    210,   -114,   -114,   -384,    210, &
                  -195,    -33,     48,  -1464,   1560,     48,    912,  -1464,   -168,     21,    480,    210,   1749,  -1302, &
                  -168,    264,     48,     21,   -195,    210,   -222,   1533,     -6,    588,     -6,  -1302,     48,   -195, &
                  1560,   -141,    534,   -141,   -168,    318,    480,    588,    480,    102,   -168,   -168,     48,  -1302, &
                    -6,    156,    264,   -168,     -6,    102,     -6,    399]
  K1( 316,:) = [    -33,    210,    210,    156,    156,    156,     21,   -222,    264,   -168,   1533,   -168,    210,    156, &
                  -222,   1533,    210,   -222,    210,    210,   -222,    264,    -33,     21,   -141,   1560,   -141,    534, &
                    48,   -195,   -168,   -168,     -6,    156,     48,  -1302,   -168,    264,     -6,    399,     -6,    102, &
                  -168,    318,    480,    588,    480,    102,   -195,    534,     48,   1560,   -141,   -141,   -114,   -114, &
                  -195,    -33,   -384,    210,   -222,   1533,     48,    210,   -195,     21,   -357,   1344,   3072,     21, &
                  1749,     21,  -1464,    912,     48,   1560,  -1464,     48,   1533,   -222,     -6,  -1302,     -6,    588, &
                   264,   -168,   -195,    210,     48,     21,     21,   -168,   1749,  -1302,    480,    210,   -195,     48, &
                  -141,   -141,   -195,   -141,   1344,   -357,     48,  -1302,     48,    399,    318,   -168,   -384,    210, &
                    -6,    210,     21,   -168,   -195,    156,     -6,    -33]
  K1( 317,:) = [    210,    210,    -33,     21,   -222,    264,    156,    156,    156,    210,    210,    -33,    210,   -222, &
                   156,    210,   1533,   -222,   1533,   -168,   -222,     21,   -168,    264,     48,   -195,   -195,   -141, &
                  -141,   -141,   -357,   1344,     48,    399,     48,  -1302,     21,   -168,   -195,    156,     -6,    -33, &
                   318,   -168,   -384,    210,     -6,    210,   -195,     48,    534,   -141,   1560,   -141,    318,   -168, &
                   480,    102,    480,    588,    264,   -168,     -6,    102,     -6,    399,   -168,   -168,     48,  -1302, &
                    -6,    156,  -1464,     48,    912,  -1464,   1560,     48,     21,   -168,   1749,  -1302,    480,    210, &
                  -222,   1533,     -6,    588,     -6,  -1302,   -168,    264,     48,     21,   -195,    210,   -141,   -141, &
                   534,   -195,   1560,     48,   -357,   1344,   3072,     21,   1749,     21,   -114,   -114,   -384,    210, &
                  -195,    -33,   1533,   -222,   -195,     21,     48,    210]
  K1( 318,:) = [    156,    156,    156,    210,    210,    -33,    210,    210,    -33,     21,   -222,    264,    156,    210, &
                   210,   -222,   -222,   1533,   -222,     21,   1533,   -168,    264,   -168,   -195,     48,    534,   -141, &
                  1560,   -141,    318,   -168,    480,    102,    480,    588,    264,   -168,     -6,    102,     -6,    399, &
                  -168,   -168,     48,  -1302,     -6,    156,     48,   -195,   -195,   -141,   -141,   -141,   -357,   1344, &
                    48,    399,     48,  -1302,     21,   -168,   -195,    156,     -6,    -33,    318,   -168,   -384,    210, &
                    -6,    210,    912,  -1464,  -1464,     48,     48,   1560,   -222,   1533,     -6,    588,     -6,  -1302, &
                    21,   -168,   1749,  -1302,    480,    210,    264,   -168,   -195,    210,     48,     21,    534,   -195, &
                  -141,   -141,     48,   1560,   -114,   -114,   -384,    210,   -195,    -33,   -357,   1344,   3072,     21, &
                  1749,     21,   -222,   1533,     48,    210,   -195,     21]
  K1( 319,:) = [    237,   -249,  -1950,    -60,   -546,    183,  -1464,    237,  -1896,     48,  -1950,   -195,   -195,     -6, &
                    48,   -195,     -6,     -6,    183,    -60,    -60,     -6,     -6,     -6,   -168,   -168,   1533,   -222, &
                   264,     21,   -384,    102,     21,     -6,   -357,     -6,  -1896,    480,    264,     -6,   -222,    -60, &
                  -384,    102,    318,    -60,     21,    183,   -168,   -168,   1344,   -114,    318,   -357,   1317,   -384, &
                  -222,     -6,   -114,     -6,   -384,    102,   1533,   -195,   -114,     48,   -816,   2640,   1344,     -6, &
                  -357,   -195,   -168,    264,   -168,   1533,     21,   -222,   -384,  -1896,   -168,   -195,   1533,  -1950, &
                  -384,   -384,   -168,     48,   1344,  -1896,   -384,   1317,   -168,    237,   -168,  -1464,   -168,    318, &
                  -168,   1344,   -357,   -114,   -384,   -384,   -168,    183,    264,   -546,   -384,   -816,   -168,    -60, &
                   318,  -1950,    102,   -384,   -168,   -249,   -168,    237]
  K1( 320,:) = [    183,   -546,    -60,  -1950,   -249,    237,    -60,    183,     -6,     -6,    -60,     -6,     -6,   -195, &
                    -6,     -6,     48,   -195,    237,  -1464,  -1950,   -195,  -1896,     48,     21,    264,   -222,   1533, &
                  -168,   -168,    102,   -384,     21,    183,    318,    -60,    480,  -1896,   -222,    -60,    264,     -6, &
                   102,   -384,   -357,     -6,     21,     -6,    318,   -168,   -357,   -114,   -168,   1344,   -384,   -384, &
                   264,   -546,   -168,    183,    102,   -384,   -168,   -249,   -168,    237,   -384,   -816,   -168,    -60, &
                   318,  -1950,    264,   -168,     21,   -222,   -168,   1533,  -1896,   -384,   1533,  -1950,   -168,   -195, &
                  -384,   1317,   -168,    237,   -168,  -1464,   -384,   -384,   -168,     48,   1344,  -1896,   -168,   -168, &
                   318,   -357,   1344,   -114,   -384,   1317,   -114,     -6,   -222,     -6,   -816,   2640,   1344,     -6, &
                  -357,   -195,   -384,    102,   1533,   -195,   -114,     48]
  K1( 321,:) = [  -1302,    399,    210,    210,    156,    -33,    588,    102,  -1302,    156,    102,    399,     21,     21, &
                   210,    -33,     21,    210,  -1302,    210,    588,  -1302,     21,    210,     -6,     -6,   -195,     48, &
                    -6,   -195,   1533,   -168,  -1464,    210,   -141,    210,    264,   -222,     48,   -222,     48,    264, &
                  -168,   -114,   -141,    -33,   -195,     21,     -6,     -6,   1749,   -195,    480,     48,   -222,    264, &
                   912,    156,    534,    156,     21,     21,  -1464,    210,   -195,    -33,    318,   -357,   -195,    156, &
                    48,    210,     48,   -195,    480,     -6,   1749,     -6,   -168,   1533,   1560,   1533,   1560,   -168, &
                  -168,   -168,     48,   -222,   -141,     21,   1344,   -168,   -141,   -168,   -141,    264,     48,   -384, &
                   480,     48,   3072,   -384,   -168,   -114,   1560,    210,    534,   -222,   -168,   1344,     48,    156, &
                  -195,    210,   -357,    318,   -141,   1533,   -141,   -222]
  K1( 322,:) = [    372,  -3084,    -60,   -600,    264,    318,   -168,    264,    372,    318,    696,  -2652,     -6,    -60, &
                   -60,    372,    372,   -168,    696,    264,   -816,    696,  -3084,    264,    -33,    399,     21,    210, &
                   102,    156,   -195,   -249,    210,     -6,   1533,  -1518,     -6,    -60,   -222,   1506,    264,   -492, &
                   237,     48,   -222,    372,    -33,    183,    210,    156,     21,    -33,    102,    399,     -6,   -546, &
                   156,  -2004,   -222,    372,     -6,    183,    210,     -6,     21,    183,  -1950,   -195,    210,  -1140, &
                   210,  -3030,     21,    210,    210,  -1302,  -1302,    588,   -195,  -1950,   1533, -12291,   -168,   1506, &
                    48,    237,   -222,   1506,   -168,     -6,  -1896,  -1464,     21,     -6,    264,  -2004,  -1302,    210, &
                   588,  -1302,     21,    210,    183,     -6,    210,  -1140,    156,    372,    -60,     -6,    156,    264, &
                   156,  -1140,     -6,    -60,    210,  -1518,    -33,    372]
  K1( 323,:) = [    -33,    156,    210,    210,    399,  -1302,    210,  -1302,     21,    210,    588,  -1302,     21,     21, &
                    21,    210,    210,    -33,    102,    588,    102,    399,  -1302,    156,   -195,     -6,     48,   -195, &
                    -6,     -6,   -114,   -168,   -195,     21,   -141,    -33,   -222,    264,     48,    264,     48,   -222, &
                  -168,   1533,   -141,    210,  -1464,    210,   -384,     48,   3072,   -384,    480,     48,   -114,   -168, &
                   534,   -222,   1560,    210,   -357,    318,   -141,   1533,   -141,   -222,   -168,   1344,     48,    156, &
                  -195,    210,   -195,     48,   1749,     -6,    480,     -6,   1533,   -168,   1560,   -168,   1560,   1533, &
                  1344,   -168,   -141,   -168,   -141,    264,   -168,   -168,     48,   -222,   -141,     21,     -6,     -6, &
                   480,     48,   1749,   -195,    264,   -222,    534,    156,    912,    156,    318,   -357,   -195,    156, &
                    48,    210,     21,     21,  -1464,    210,   -195,    -33]
  K1( 324,:) = [    318,    264,   -600,    -60,  -3084,    372,    264,    696,  -3084,    264,   -816,    696,    -60,     -6, &
                   372,   -168,    -60,    372,    264,   -168,    696,  -2652,    372,    318,    156,    102,    210,     21, &
                   399,    -33,     48,    237,    -33,    183,   -222,    372,    -60,     -6,    264,   -492,   -222,   1506, &
                  -249,   -195,   1533,  -1518,    210,     -6,    210,  -1302,     21,    210,    588,  -1302,     -6,    183, &
                   156,    372,    210,  -1140,     -6,    -60,    210,  -1518,    -33,    372,    -60,     -6,    156,    264, &
                   156,  -1140,    210,     21,  -1302,    588,    210,  -1302,  -1950,   -195,   -168,   1506,   1533, -12291, &
                 -1896,  -1464,     21,     -6,    264,  -2004,     48,    237,   -222,   1506,   -168,     -6,    156,    210, &
                   102,    399,     21,    -33,   -546,     -6,   -222,    372,    156,  -2004,  -1950,   -195,    210,  -1140, &
                   210,  -3030,     -6,    183,    210,     -6,     21,    183]
  K1( 325,:) = [  -1464,    237,  -1896,     48,  -1950,   -195,    237,   -249,  -1950,    -60,   -546,    183,     48,   -195, &
                  -195,     -6,     -6,     -6,    -60,     -6,    183,    -60,     -6,     -6,   -168,   -168,   1344,   -114, &
                   318,   -357,   1317,   -384,   -222,     -6,   -114,     -6,   -384,    102,   1533,   -195,   -114,     48, &
                  -816,   2640,   1344,     -6,   -357,   -195,   -168,   -168,   1533,   -222,    264,     21,   -384,    102, &
                    21,     -6,   -357,     -6,  -1896,    480,    264,     -6,   -222,    -60,   -384,    102,    318,    -60, &
                    21,    183,   -168,   1533,   -168,    264,   -222,     21,   -384,   -384,   -168,     48,   1344,  -1896, &
                  -384,  -1896,   -168,   -195,   1533,  -1950,   1317,   -384,   -168,  -1464,   -168,    237,   -168,   1344, &
                  -168,    318,   -114,   -357,   -384,   -816,   -168,    -60,    318,  -1950,   -384,   -384,   -168,    183, &
                   264,   -546,   -384,    102,   -168,    237,   -168,   -249]
  K1( 326,:) = [    -60,    183,     -6,     -6,    -60,     -6,    183,   -546,    -60,  -1950,   -249,    237,     -6,     -6, &
                    -6,   -195,   -195,     48,  -1950,   -195,    237,  -1464,     48,  -1896,    318,   -168,   -357,   -114, &
                  -168,   1344,   -384,   -384,    264,   -546,   -168,    183,    102,   -384,   -168,   -249,   -168,    237, &
                  -384,   -816,   -168,    -60,    318,  -1950,     21,    264,   -222,   1533,   -168,   -168,    102,   -384, &
                    21,    183,    318,    -60,    480,  -1896,   -222,    -60,    264,     -6,    102,   -384,   -357,     -6, &
                    21,     -6,     21,   -222,    264,   -168,   1533,   -168,   -384,   1317,   -168,    237,   -168,  -1464, &
                 -1896,   -384,   1533,  -1950,   -168,   -195,   -384,   -384,   1344,  -1896,   -168,     48,    318,   -357, &
                  -168,   -168,   -114,   1344,   -816,   2640,   1344,     -6,   -357,   -195,   -384,   1317,   -114,     -6, &
                  -222,     -6,    102,   -384,   -114,     48,   1533,   -195]
  K1( 327,:) = [    588,    102,  -1302,    156,    102,    399,  -1302,    399,    210,    210,    156,    -33,    210,    -33, &
                    21,     21,    210,     21,    588,  -1302,  -1302,    210,    210,     21,     -6,     -6,   1749,   -195, &
                   480,     48,   -222,    264,    912,    156,    534,    156,     21,     21,  -1464,    210,   -195,    -33, &
                   318,   -357,   -195,    156,     48,    210,     -6,     -6,   -195,     48,     -6,   -195,   1533,   -168, &
                 -1464,    210,   -141,    210,    264,   -222,     48,   -222,     48,    264,   -168,   -114,   -141,    -33, &
                  -195,     21,    480,     -6,     48,   -195,     -6,   1749,   -168,   -168,     48,   -222,   -141,     21, &
                  -168,   1533,   1560,   1533,   1560,   -168,   -168,   1344,   -141,    264,   -141,   -168,    480,     48, &
                    48,   -384,   -384,   3072,   -168,   1344,     48,    156,   -195,    210,   -168,   -114,   1560,    210, &
                   534,   -222,    318,   -357,   -141,   -222,   -141,   1533]
  K1( 328,:) = [   -168,    264,    372,    318,    696,  -2652,    372,  -3084,    -60,   -600,    264,    318,    -60,    372, &
                    -6,    -60,   -168,    372,   -816,    696,    696,    264,    264,  -3084,    210,    156,     21,    -33, &
                   102,    399,     -6,   -546,    156,  -2004,   -222,    372,     -6,    183,    210,     -6,     21,    183, &
                 -1950,   -195,    210,  -1140,    210,  -3030,    -33,    399,     21,    210,    102,    156,   -195,   -249, &
                   210,     -6,   1533,  -1518,     -6,    -60,   -222,   1506,    264,   -492,    237,     48,   -222,    372, &
                   -33,    183,    210,  -1302,     21,    210,    588,  -1302,     48,    237,   -222,   1506,   -168,     -6, &
                  -195,  -1950,   1533, -12291,   -168,   1506,  -1464,  -1896,    264,  -2004,     21,     -6,    588,  -1302, &
                 -1302,    210,    210,     21,    -60,     -6,    156,    264,    156,  -1140,    183,     -6,    210,  -1140, &
                   156,    372,    -60,     -6,    -33,    372,    210,  -1518]
  K1( 329,:) = [    210,  -1302,     21,    210,    588,  -1302,    -33,    156,    210,    210,    399,  -1302,     21,    210, &
                    21,     21,    -33,    210,    102,    399,    102,    588,    156,  -1302,   -384,     48,   3072,   -384, &
                   480,     48,   -114,   -168,    534,   -222,   1560,    210,   -357,    318,   -141,   1533,   -141,   -222, &
                  -168,   1344,     48,    156,   -195,    210,   -195,     -6,     48,   -195,     -6,     -6,   -114,   -168, &
                  -195,     21,   -141,    -33,   -222,    264,     48,    264,     48,   -222,   -168,   1533,   -141,    210, &
                 -1464,    210,   1749,     -6,   -195,     48,     -6,    480,   1344,   -168,   -141,   -168,   -141,    264, &
                  1533,   -168,   1560,   -168,   1560,   1533,   -168,   -168,   -141,     21,     48,   -222,    480,     48, &
                    -6,     -6,   -195,   1749,    318,   -357,   -195,    156,     48,    210,    264,   -222,    534,    156, &
                   912,    156,     21,     21,   -195,    -33,  -1464,    210]
  K1( 330,:) = [    264,    696,  -3084,    264,   -816,    696,    318,    264,   -600,    -60,  -3084,    372,    372,   -168, &
                   -60,     -6,    372,    -60,    696,  -2652,    264,   -168,    318,    372,    210,  -1302,     21,    210, &
                   588,  -1302,     -6,    183,    156,    372,    210,  -1140,     -6,    -60,    210,  -1518,    -33,    372, &
                   -60,     -6,    156,    264,    156,  -1140,    156,    102,    210,     21,    399,    -33,     48,    237, &
                   -33,    183,   -222,    372,    -60,     -6,    264,   -492,   -222,   1506,   -249,   -195,   1533,  -1518, &
                   210,     -6,  -1302,    588,    210,     21,  -1302,    210,  -1896,  -1464,     21,     -6,    264,  -2004, &
                 -1950,   -195,   -168,   1506,   1533, -12291,    237,     48,   -168,     -6,   -222,   1506,    102,    399, &
                   156,    210,    -33,     21,  -1950,   -195,    210,  -1140,    210,  -3030,   -546,     -6,   -222,    372, &
                   156,  -2004,    183,     -6,     21,    183,    210,     -6]
  K1( 331,:) = [   -195,  -1950,     48,  -1896,    237,  -1464,     -6,    -60,     -6,     -6,    183,    -60,   -195,     48, &
                    -6,     -6,   -195,     -6,   -249,    237,   -546,    183,  -1950,    -60,   -357,    318,   -114,   1344, &
                  -168,   -168,   2640,   -816,   -357,   -195,   1344,     -6,    102,   -384,   -114,     48,   1533,   -195, &
                  -384,   1317,   -114,     -6,   -222,     -6,   1344,   -168,   -114,   -357,   -168,    318,   -816,   -384, &
                   318,  -1950,   -168,    -60,   -384,    102,   -168,    237,   -168,   -249,   -384,   -384,   -168,    183, &
                   264,   -546,   1533,   -168,   -222,     21,   -168,    264,   -384,   -384,   1344,  -1896,   -168,     48, &
                  1317,   -384,   -168,  -1464,   -168,    237,   -384,  -1896,   -168,   -195,   1533,  -1950,   -168,   -168, &
                   264,     21,   1533,   -222,    102,   -384,   -357,     -6,     21,     -6,   -384,    102,    318,    -60, &
                    21,    183,  -1896,    480,    264,     -6,   -222,    -60]
  K1( 332,:) = [     -6,    -60,     -6,     -6,    183,    -60,   -195,  -1950,     48,  -1896,    237,  -1464,     -6,     -6, &
                  -195,     48,     -6,   -195,   -546,    183,   -249,    237,    -60,  -1950,   1344,   -168,   -114,   -357, &
                  -168,    318,   -816,   -384,    318,  -1950,   -168,    -60,   -384,    102,   -168,    237,   -168,   -249, &
                  -384,   -384,   -168,    183,    264,   -546,   -357,    318,   -114,   1344,   -168,   -168,   2640,   -816, &
                  -357,   -195,   1344,     -6,    102,   -384,   -114,     48,   1533,   -195,   -384,   1317,   -114,     -6, &
                  -222,     -6,   -222,     21,   1533,   -168,    264,   -168,   1317,   -384,   -168,  -1464,   -168,    237, &
                  -384,   -384,   1344,  -1896,   -168,     48,  -1896,   -384,   1533,  -1950,   -168,   -195,    264,     21, &
                  -168,   -168,   -222,   1533,   -384,    102,    318,    -60,     21,    183,    102,   -384,   -357,     -6, &
                    21,     -6,    480,  -1896,   -222,    -60,    264,     -6]
  K1( 333,:) = [    399,    102,    156,  -1302,    102,    588,  -1302,    588,    210,     21,  -1302,    210,    -33,    210, &
                   210,     21,     21,     21,    399,  -1302,    156,    -33,    210,    210,     48,    480,   -195,   1749, &
                    -6,     -6,   -357,    318,     48,    210,   -195,    156,     21,     21,   -195,    -33,  -1464,    210, &
                   264,   -222,    534,    156,    912,    156,     48,    480,   -384,   3072,     48,   -384,   1344,   -168, &
                  -195,    210,     48,    156,    318,   -357,   -141,   -222,   -141,   1533,   -168,   -114,   1560,    210, &
                   534,   -222,     -6,    480,     -6,   1749,     48,   -195,   -168,   -168,   -141,     21,     48,   -222, &
                  -168,   1344,   -141,    264,   -141,   -168,   -168,   1533,   1560,   1533,   1560,   -168,     -6,     -6, &
                    -6,   -195,   -195,     48,   -168,   1533,   -141,    210,  -1464,    210,   -168,   -114,   -141,    -33, &
                  -195,     21,    264,   -222,     48,   -222,     48,    264]
  K1( 334,:) = [  -2652,    696,    318,    372,    264,   -168,    696,   -816,    264,  -3084,    696,    264,    372,    -60, &
                  -168,    372,     -6,    -60,  -3084,    372,    264,    318,    -60,   -600,    399,    102,    -33,     21, &
                   156,    210,   -195,  -1950,    210,  -3030,    210,  -1140,    183,     -6,     21,    183,    210,     -6, &
                  -546,     -6,   -222,    372,    156,  -2004,  -1302,    588,    210,     21,  -1302,    210,     -6,    -60, &
                   156,  -1140,    156,    264,    -60,     -6,    -33,    372,    210,  -1518,    183,     -6,    210,  -1140, &
                   156,    372,  -1302,    210,    588,  -1302,     21,    210,    237,     48,   -168,     -6,   -222,   1506, &
                 -1464,  -1896,    264,  -2004,     21,     -6,   -195,  -1950,   1533, -12291,   -168,   1506,    399,    -33, &
                   102,    156,     21,    210,   -249,   -195,   1533,  -1518,    210,     -6,    237,     48,   -222,    372, &
                   -33,    183,     -6,    -60,   -222,   1506,    264,   -492]
  K1( 335,:) = [  -1302,    588,    210,     21,  -1302,    210,    399,    102,    156,  -1302,    102,    588,    210,     21, &
                   -33,    210,     21,     21,    156,    -33,    399,  -1302,    210,    210,     48,    480,   -384,   3072, &
                    48,   -384,   1344,   -168,   -195,    210,     48,    156,    318,   -357,   -141,   -222,   -141,   1533, &
                  -168,   -114,   1560,    210,    534,   -222,     48,    480,   -195,   1749,     -6,     -6,   -357,    318, &
                    48,    210,   -195,    156,     21,     21,   -195,    -33,  -1464,    210,    264,   -222,    534,    156, &
                   912,    156,     -6,   1749,     -6,    480,   -195,     48,   -168,   1344,   -141,    264,   -141,   -168, &
                  -168,   -168,   -141,     21,     48,   -222,   1533,   -168,   1560,   -168,   1560,   1533,     -6,   -195, &
                    -6,     -6,     48,   -195,   -168,   -114,   -141,    -33,   -195,     21,   -168,   1533,   -141,    210, &
                 -1464,    210,   -222,    264,     48,    264,     48,   -222]
  K1( 336,:) = [    696,   -816,    264,  -3084,    696,    264,  -2652,    696,    318,    372,    264,   -168,   -168,    372, &
                   372,    -60,    -60,     -6,    264,    318,  -3084,    372,   -600,    -60,  -1302,    588,    210,     21, &
                 -1302,    210,     -6,    -60,    156,  -1140,    156,    264,    -60,     -6,    -33,    372,    210,  -1518, &
                   183,     -6,    210,  -1140,    156,    372,    399,    102,    -33,     21,    156,    210,   -195,  -1950, &
                   210,  -3030,    210,  -1140,    183,     -6,     21,    183,    210,     -6,   -546,     -6,   -222,    372, &
                   156,  -2004,    588,  -1302,  -1302,    210,    210,     21,  -1464,  -1896,    264,  -2004,     21,     -6, &
                   237,     48,   -168,     -6,   -222,   1506,  -1950,   -195,   -168,   1506,   1533, -12291,    102,    156, &
                   399,    -33,    210,     21,    237,     48,   -222,    372,    -33,    183,   -249,   -195,   1533,  -1518, &
                   210,     -6,    -60,     -6,    264,   -492,   -222,   1506]
  K1( 337,:) = [   1533,   -168,   -222,     21,   -168,    264,   -222,    264,    210,    210,     21,    -33,    210,    -33, &
                   156,    156,    210,    156,   1533,   -222,   -222,    210,    210,    156,   -141,   -141,    534,   -195, &
                  1560,     48,   -357,   1344,   3072,     21,   1749,     21,   -114,   -114,   -384,    210,   -195,    -33, &
                  1533,   -222,   -195,     21,     48,    210,   -141,   -141,   -195,     48,   -141,   -195,    318,   -168, &
                  -384,    210,     -6,    210,   1344,   -357,     48,  -1302,     48,    399,   -168,     21,     -6,    -33, &
                  -195,    156,   1560,   -141,     48,   -195,   -141,    534,   -168,   -168,     48,  -1302,     -6,    156, &
                  -168,    318,    480,    588,    480,    102,   -168,    264,     -6,    399,     -6,    102,   1560,     48, &
                    48,  -1464,  -1464,    912,   -168,    264,     48,     21,   -195,    210,   -168,     21,    480,    210, &
                  1749,  -1302,   1533,   -222,     -6,  -1302,     -6,    588]
  K1( 338,:) = [   -222,     21,   1533,   -168,    264,   -168,    210,    -33,    156,    156,    210,    156,   -222,    264, &
                   210,    210,     21,    -33,   -222,   1533,    210,    156,   -222,    210,    534,   -195,   -141,   -141, &
                    48,   1560,   -114,   -114,   -384,    210,   -195,    -33,   -357,   1344,   3072,     21,   1749,     21, &
                  -222,   1533,     48,    210,   -195,     21,   1560,   -141,     48,   -195,   -141,    534,   -168,   -168, &
                    48,  -1302,     -6,    156,   -168,    318,    480,    588,    480,    102,   -168,    264,     -6,    399, &
                    -6,    102,   -141,   -141,   -195,     48,   -141,   -195,    318,   -168,   -384,    210,     -6,    210, &
                  1344,   -357,     48,  -1302,     48,    399,   -168,     21,     -6,    -33,   -195,    156,     48,   1560, &
                 -1464,    912,     48,  -1464,    264,   -168,   -195,    210,     48,     21,   1533,   -222,     -6,  -1302, &
                    -6,    588,   -168,     21,    480,    210,   1749,  -1302]
  K1( 339,:) = [   -222,    264,    210,    210,     21,    -33,   1533,   -168,   -222,     21,   -168,    264,    156,    156, &
                   210,    -33,    156,    210,   -222,    210,   1533,   -222,    156,    210,   -141,   -141,   -195,     48, &
                  -141,   -195,    318,   -168,   -384,    210,     -6,    210,   1344,   -357,     48,  -1302,     48,    399, &
                  -168,     21,     -6,    -33,   -195,    156,   -141,   -141,    534,   -195,   1560,     48,   -357,   1344, &
                  3072,     21,   1749,     21,   -114,   -114,   -384,    210,   -195,    -33,   1533,   -222,   -195,     21, &
                    48,    210,     48,   -195,   1560,   -141,    534,   -141,   -168,    318,    480,    588,    480,    102, &
                  -168,   -168,     48,  -1302,     -6,    156,    264,   -168,     -6,    102,     -6,    399,     48,  -1464, &
                  1560,     48,    912,  -1464,   -168,     21,    480,    210,   1749,  -1302,   -168,    264,     48,     21, &
                  -195,    210,   -222,   1533,     -6,    588,     -6,  -1302]
  K1( 340,:) = [    210,    -33,    156,    156,    210,    156,   -222,     21,   1533,   -168,    264,   -168,    210,    210, &
                  -222,    264,    -33,     21,    210,    156,   -222,   1533,    210,   -222,   1560,   -141,     48,   -195, &
                  -141,    534,   -168,   -168,     48,  -1302,     -6,    156,   -168,    318,    480,    588,    480,    102, &
                  -168,    264,     -6,    399,     -6,    102,    534,   -195,   -141,   -141,     48,   1560,   -114,   -114, &
                  -384,    210,   -195,    -33,   -357,   1344,   3072,     21,   1749,     21,   -222,   1533,     48,    210, &
                  -195,     21,   -195,     48,   -141,   -141,   -195,   -141,   1344,   -357,     48,  -1302,     48,    399, &
                   318,   -168,   -384,    210,     -6,    210,     21,   -168,   -195,    156,     -6,    -33,  -1464,    912, &
                    48,   1560,  -1464,     48,   1533,   -222,     -6,  -1302,     -6,    588,    264,   -168,   -195,    210, &
                    48,     21,     21,   -168,   1749,  -1302,    480,    210]
  K1( 341,:) = [    210,    210,   -222,    264,    -33,     21,    156,    156,    210,    -33,    156,    210,   1533,   -168, &
                  -222,     21,   -168,    264,    210,   -222,    156,    210,   1533,   -222,   -195,     48,   -141,   -141, &
                  -195,   -141,   1344,   -357,     48,  -1302,     48,    399,    318,   -168,   -384,    210,     -6,    210, &
                    21,   -168,   -195,    156,     -6,    -33,     48,   -195,   1560,   -141,    534,   -141,   -168,    318, &
                   480,    588,    480,    102,   -168,   -168,     48,  -1302,     -6,    156,    264,   -168,     -6,    102, &
                    -6,    399,   -141,   -141,    534,   -195,   1560,     48,   -357,   1344,   3072,     21,   1749,     21, &
                  -114,   -114,   -384,    210,   -195,    -33,   1533,   -222,   -195,     21,     48,    210,  -1464,     48, &
                   912,  -1464,   1560,     48,     21,   -168,   1749,  -1302,    480,    210,   -222,   1533,     -6,    588, &
                    -6,  -1302,   -168,    264,     48,     21,   -195,    210]
  K1( 342,:) = [    156,    156,    210,    -33,    156,    210,    210,    210,   -222,    264,    -33,     21,   -222,     21, &
                  1533,   -168,    264,   -168,    156,    210,    210,   -222,   -222,   1533,     48,   -195,   1560,   -141, &
                   534,   -141,   -168,    318,    480,    588,    480,    102,   -168,   -168,     48,  -1302,     -6,    156, &
                   264,   -168,     -6,    102,     -6,    399,   -195,     48,   -141,   -141,   -195,   -141,   1344,   -357, &
                    48,  -1302,     48,    399,    318,   -168,   -384,    210,     -6,    210,     21,   -168,   -195,    156, &
                    -6,    -33,    534,   -195,   -141,   -141,     48,   1560,   -114,   -114,   -384,    210,   -195,    -33, &
                  -357,   1344,   3072,     21,   1749,     21,   -222,   1533,     48,    210,   -195,     21,    912,  -1464, &
                 -1464,     48,     48,   1560,   -222,   1533,     -6,    588,     -6,  -1302,     21,   -168,   1749,  -1302, &
                   480,    210,    264,   -168,   -195,    210,     48,     21]
  K1( 343,:) = [   -249,    237,   -546,    183,  -1950,    -60,    237,  -1464,  -1950,   -195,  -1896,     48,    183,    -60, &
                   -60,     -6,     -6,     -6,   -195,     -6,     48,   -195,     -6,     -6,   -168,   -168,    264,     21, &
                  1533,   -222,    102,   -384,   -357,     -6,     21,     -6,   -384,    102,    318,    -60,     21,    183, &
                 -1896,    480,    264,     -6,   -222,    -60,   -168,   -168,    318,   -357,   1344,   -114,   -384,   1317, &
                  -114,     -6,   -222,     -6,   -816,   2640,   1344,     -6,   -357,   -195,   -384,    102,   1533,   -195, &
                  -114,     48,   -168,    318,   -168,   1344,   -357,   -114,   -384,   -384,   -168,    183,    264,   -546, &
                  -384,   -816,   -168,    -60,    318,  -1950,    102,   -384,   -168,   -249,   -168,    237,   -168,    264, &
                  -168,   1533,     21,   -222,   -384,  -1896,   -168,   -195,   1533,  -1950,   -384,   -384,   -168,     48, &
                  1344,  -1896,   -384,   1317,   -168,    237,   -168,  -1464]
  K1( 344,:) = [   -546,    183,   -249,    237,    -60,  -1950,    183,    -60,    -60,     -6,     -6,     -6,    237,  -1464, &
                 -1950,   -195,  -1896,     48,     -6,   -195,     -6,     -6,     48,   -195,    264,     21,   -168,   -168, &
                  -222,   1533,   -384,    102,    318,    -60,     21,    183,    102,   -384,   -357,     -6,     21,     -6, &
                   480,  -1896,   -222,    -60,    264,     -6,   -168,    318,   -168,   1344,   -357,   -114,   -384,   -384, &
                  -168,    183,    264,   -546,   -384,   -816,   -168,    -60,    318,  -1950,    102,   -384,   -168,   -249, &
                  -168,    237,   -168,   -168,    318,   -357,   1344,   -114,   -384,   1317,   -114,     -6,   -222,     -6, &
                  -816,   2640,   1344,     -6,   -357,   -195,   -384,    102,   1533,   -195,   -114,     48,    264,   -168, &
                    21,   -222,   -168,   1533,  -1896,   -384,   1533,  -1950,   -168,   -195,   -384,   1317,   -168,    237, &
                  -168,  -1464,   -384,   -384,   -168,     48,   1344,  -1896]
  K1( 345,:) = [    399,  -1302,    156,    -33,    210,    210,    102,    588,    102,    399,  -1302,    156,  -1302,    210, &
                   588,  -1302,     21,    210,     21,     21,    210,    -33,     21,    210,     -6,     -6,     -6,   -195, &
                  -195,     48,   -168,   1533,   -141,    210,  -1464,    210,   -168,   -114,   -141,    -33,   -195,     21, &
                   264,   -222,     48,   -222,     48,    264,     -6,     -6,    480,     48,   1749,   -195,    264,   -222, &
                   534,    156,    912,    156,    318,   -357,   -195,    156,     48,    210,     21,     21,  -1464,    210, &
                  -195,    -33,     48,   -384,    480,     48,   3072,   -384,   -168,   -114,   1560,    210,    534,   -222, &
                  -168,   1344,     48,    156,   -195,    210,   -357,    318,   -141,   1533,   -141,   -222,     48,   -195, &
                   480,     -6,   1749,     -6,   -168,   1533,   1560,   1533,   1560,   -168,   -168,   -168,     48,   -222, &
                  -141,     21,   1344,   -168,   -141,   -168,   -141,    264]
  K1( 346,:) = [  -3084,    372,    264,    318,    -60,   -600,    264,   -168,    696,  -2652,    372,    318,    696,    264, &
                  -816,    696,  -3084,    264,     -6,    -60,    -60,    372,    372,   -168,    399,    -33,    102,    156, &
                    21,    210,   -249,   -195,   1533,  -1518,    210,     -6,    237,     48,   -222,    372,    -33,    183, &
                    -6,    -60,   -222,   1506,    264,   -492,    156,    210,    102,    399,     21,    -33,   -546,     -6, &
                  -222,    372,    156,  -2004,  -1950,   -195,    210,  -1140,    210,  -3030,     -6,    183,    210,     -6, &
                    21,    183,  -1302,    210,    588,  -1302,     21,    210,    183,     -6,    210,  -1140,    156,    372, &
                   -60,     -6,    156,    264,    156,  -1140,     -6,    -60,    210,  -1518,    -33,    372,     21,    210, &
                   210,  -1302,  -1302,    588,   -195,  -1950,   1533, -12291,   -168,   1506,     48,    237,   -222,   1506, &
                  -168,     -6,  -1896,  -1464,     21,     -6,    264,  -2004]
  K1( 347,:) = [    156,    -33,    399,  -1302,    210,    210,  -1302,    210,    588,  -1302,     21,    210,    102,    588, &
                   102,    399,  -1302,    156,     21,     21,     21,    210,    210,    -33,     -6,   -195,     -6,     -6, &
                    48,   -195,   -168,   -114,   -141,    -33,   -195,     21,   -168,   1533,   -141,    210,  -1464,    210, &
                  -222,    264,     48,    264,     48,   -222,     48,   -384,    480,     48,   3072,   -384,   -168,   -114, &
                  1560,    210,    534,   -222,   -168,   1344,     48,    156,   -195,    210,   -357,    318,   -141,   1533, &
                  -141,   -222,     -6,     -6,    480,     48,   1749,   -195,    264,   -222,    534,    156,    912,    156, &
                   318,   -357,   -195,    156,     48,    210,     21,     21,  -1464,    210,   -195,    -33,   -195,     48, &
                  1749,     -6,    480,     -6,   1533,   -168,   1560,   -168,   1560,   1533,   1344,   -168,   -141,   -168, &
                  -141,    264,   -168,   -168,     48,   -222,   -141,     21]
  K1( 348,:) = [    264,    318,  -3084,    372,   -600,    -60,    696,    264,   -816,    696,  -3084,    264,    264,   -168, &
                   696,  -2652,    372,    318,    -60,     -6,    372,   -168,    -60,    372,    102,    156,    399,    -33, &
                   210,     21,    237,     48,   -222,    372,    -33,    183,   -249,   -195,   1533,  -1518,    210,     -6, &
                   -60,     -6,    264,   -492,   -222,   1506,  -1302,    210,    588,  -1302,     21,    210,    183,     -6, &
                   210,  -1140,    156,    372,    -60,     -6,    156,    264,    156,  -1140,     -6,    -60,    210,  -1518, &
                   -33,    372,    156,    210,    102,    399,     21,    -33,   -546,     -6,   -222,    372,    156,  -2004, &
                 -1950,   -195,    210,  -1140,    210,  -3030,     -6,    183,    210,     -6,     21,    183,    210,     21, &
                 -1302,    588,    210,  -1302,  -1950,   -195,   -168,   1506,   1533, -12291,  -1896,  -1464,     21,     -6, &
                   264,  -2004,     48,    237,   -222,   1506,   -168,     -6]
  K1( 349,:) = [    237,  -1464,  -1950,   -195,  -1896,     48,   -249,    237,   -546,    183,  -1950,    -60,    -60,     -6, &
                   183,    -60,     -6,     -6,     48,   -195,   -195,     -6,     -6,     -6,   -168,   -168,    318,   -357, &
                  1344,   -114,   -384,   1317,   -114,     -6,   -222,     -6,   -816,   2640,   1344,     -6,   -357,   -195, &
                  -384,    102,   1533,   -195,   -114,     48,   -168,   -168,    264,     21,   1533,   -222,    102,   -384, &
                  -357,     -6,     21,     -6,   -384,    102,    318,    -60,     21,    183,  -1896,    480,    264,     -6, &
                  -222,    -60,   -168,   1344,   -168,    318,   -114,   -357,   -384,   -816,   -168,    -60,    318,  -1950, &
                  -384,   -384,   -168,    183,    264,   -546,   -384,    102,   -168,    237,   -168,   -249,   -168,   1533, &
                  -168,    264,   -222,     21,   -384,   -384,   -168,     48,   1344,  -1896,   -384,  -1896,   -168,   -195, &
                  1533,  -1950,   1317,   -384,   -168,  -1464,   -168,    237]
  K1( 350,:) = [    183,    -60,    -60,     -6,     -6,     -6,   -546,    183,   -249,    237,    -60,  -1950,  -1950,   -195, &
                   237,  -1464,     48,  -1896,     -6,     -6,     -6,   -195,   -195,     48,   -168,    318,   -168,   1344, &
                  -357,   -114,   -384,   -384,   -168,    183,    264,   -546,   -384,   -816,   -168,    -60,    318,  -1950, &
                   102,   -384,   -168,   -249,   -168,    237,    264,     21,   -168,   -168,   -222,   1533,   -384,    102, &
                   318,    -60,     21,    183,    102,   -384,   -357,     -6,     21,     -6,    480,  -1896,   -222,    -60, &
                   264,     -6,    318,   -357,   -168,   -168,   -114,   1344,   -816,   2640,   1344,     -6,   -357,   -195, &
                  -384,   1317,   -114,     -6,   -222,     -6,    102,   -384,   -114,     48,   1533,   -195,     21,   -222, &
                   264,   -168,   1533,   -168,   -384,   1317,   -168,    237,   -168,  -1464,  -1896,   -384,   1533,  -1950, &
                  -168,   -195,   -384,   -384,   1344,  -1896,   -168,     48]
  K1( 351,:) = [    102,    588,    102,    399,  -1302,    156,    399,  -1302,    156,    -33,    210,    210,    588,  -1302, &
                 -1302,    210,    210,     21,    210,    -33,     21,     21,    210,     21,     -6,     -6,    480,     48, &
                  1749,   -195,    264,   -222,    534,    156,    912,    156,    318,   -357,   -195,    156,     48,    210, &
                    21,     21,  -1464,    210,   -195,    -33,     -6,     -6,     -6,   -195,   -195,     48,   -168,   1533, &
                  -141,    210,  -1464,    210,   -168,   -114,   -141,    -33,   -195,     21,    264,   -222,     48,   -222, &
                    48,    264,    480,     48,     48,   -384,   -384,   3072,   -168,   1344,     48,    156,   -195,    210, &
                  -168,   -114,   1560,    210,    534,   -222,    318,   -357,   -141,   -222,   -141,   1533,    480,     -6, &
                    48,   -195,     -6,   1749,   -168,   -168,     48,   -222,   -141,     21,   -168,   1533,   1560,   1533, &
                  1560,   -168,   -168,   1344,   -141,    264,   -141,   -168]
  K1( 352,:) = [    264,   -168,    696,  -2652,    372,    318,  -3084,    372,    264,    318,    -60,   -600,   -816,    696, &
                   696,    264,    264,  -3084,    -60,    372,     -6,    -60,   -168,    372,    156,    210,    102,    399, &
                    21,    -33,   -546,     -6,   -222,    372,    156,  -2004,  -1950,   -195,    210,  -1140,    210,  -3030, &
                    -6,    183,    210,     -6,     21,    183,    399,    -33,    102,    156,     21,    210,   -249,   -195, &
                  1533,  -1518,    210,     -6,    237,     48,   -222,    372,    -33,    183,     -6,    -60,   -222,   1506, &
                   264,   -492,    588,  -1302,  -1302,    210,    210,     21,    -60,     -6,    156,    264,    156,  -1140, &
                   183,     -6,    210,  -1140,    156,    372,    -60,     -6,    -33,    372,    210,  -1518,    210,  -1302, &
                    21,    210,    588,  -1302,     48,    237,   -222,   1506,   -168,     -6,   -195,  -1950,   1533, -12291, &
                  -168,   1506,  -1464,  -1896,    264,  -2004,     21,     -6]
  K1( 353,:) = [  -1302,    210,    588,  -1302,     21,    210,    156,    -33,    399,  -1302,    210,    210,    102,    399, &
                   102,    588,    156,  -1302,     21,    210,     21,     21,    -33,    210,     48,   -384,    480,     48, &
                  3072,   -384,   -168,   -114,   1560,    210,    534,   -222,   -168,   1344,     48,    156,   -195,    210, &
                  -357,    318,   -141,   1533,   -141,   -222,     -6,   -195,     -6,     -6,     48,   -195,   -168,   -114, &
                  -141,    -33,   -195,     21,   -168,   1533,   -141,    210,  -1464,    210,   -222,    264,     48,    264, &
                    48,   -222,    480,     48,     -6,     -6,   -195,   1749,    318,   -357,   -195,    156,     48,    210, &
                   264,   -222,    534,    156,    912,    156,     21,     21,   -195,    -33,  -1464,    210,   1749,     -6, &
                  -195,     48,     -6,    480,   1344,   -168,   -141,   -168,   -141,    264,   1533,   -168,   1560,   -168, &
                  1560,   1533,   -168,   -168,   -141,     21,     48,   -222]
  K1( 354,:) = [    696,    264,   -816,    696,  -3084,    264,    264,    318,  -3084,    372,   -600,    -60,    696,  -2652, &
                   264,   -168,    318,    372,    372,   -168,    -60,     -6,    372,    -60,  -1302,    210,    588,  -1302, &
                    21,    210,    183,     -6,    210,  -1140,    156,    372,    -60,     -6,    156,    264,    156,  -1140, &
                    -6,    -60,    210,  -1518,    -33,    372,    102,    156,    399,    -33,    210,     21,    237,     48, &
                  -222,    372,    -33,    183,   -249,   -195,   1533,  -1518,    210,     -6,    -60,     -6,    264,   -492, &
                  -222,   1506,    102,    399,    156,    210,    -33,     21,  -1950,   -195,    210,  -1140,    210,  -3030, &
                  -546,     -6,   -222,    372,    156,  -2004,    183,     -6,     21,    183,    210,     -6,  -1302,    588, &
                   210,     21,  -1302,    210,  -1896,  -1464,     21,     -6,    264,  -2004,  -1950,   -195,   -168,   1506, &
                  1533, -12291,    237,     48,   -168,     -6,   -222,   1506]
  K1( 355,:) = [  -1950,   -195,    237,  -1464,     48,  -1896,    -60,     -6,    183,    -60,     -6,     -6,   -249,    237, &
                  -546,    183,  -1950,    -60,   -195,     48,     -6,     -6,   -195,     -6,    318,   -357,   -168,   -168, &
                  -114,   1344,   -816,   2640,   1344,     -6,   -357,   -195,   -384,   1317,   -114,     -6,   -222,     -6, &
                   102,   -384,   -114,     48,   1533,   -195,   -168,   1344,   -168,    318,   -114,   -357,   -384,   -816, &
                  -168,    -60,    318,  -1950,   -384,   -384,   -168,    183,    264,   -546,   -384,    102,   -168,    237, &
                  -168,   -249,   -168,   -168,    264,     21,   1533,   -222,    102,   -384,   -357,     -6,     21,     -6, &
                  -384,    102,    318,    -60,     21,    183,  -1896,    480,    264,     -6,   -222,    -60,   1533,   -168, &
                  -222,     21,   -168,    264,   -384,   -384,   1344,  -1896,   -168,     48,   1317,   -384,   -168,  -1464, &
                  -168,    237,   -384,  -1896,   -168,   -195,   1533,  -1950]
  K1( 356,:) = [    -60,     -6,    183,    -60,     -6,     -6,  -1950,   -195,    237,  -1464,     48,  -1896,   -546,    183, &
                  -249,    237,    -60,  -1950,     -6,     -6,   -195,     48,     -6,   -195,   -168,   1344,   -168,    318, &
                  -114,   -357,   -384,   -816,   -168,    -60,    318,  -1950,   -384,   -384,   -168,    183,    264,   -546, &
                  -384,    102,   -168,    237,   -168,   -249,    318,   -357,   -168,   -168,   -114,   1344,   -816,   2640, &
                  1344,     -6,   -357,   -195,   -384,   1317,   -114,     -6,   -222,     -6,    102,   -384,   -114,     48, &
                  1533,   -195,    264,     21,   -168,   -168,   -222,   1533,   -384,    102,    318,    -60,     21,    183, &
                   102,   -384,   -357,     -6,     21,     -6,    480,  -1896,   -222,    -60,    264,     -6,   -222,     21, &
                  1533,   -168,    264,   -168,   1317,   -384,   -168,  -1464,   -168,    237,   -384,   -384,   1344,  -1896, &
                  -168,     48,  -1896,   -384,   1533,  -1950,   -168,   -195]
  K1( 357,:) = [    102,    399,    102,    588,    156,  -1302,    588,  -1302,  -1302,    210,    210,     21,    399,  -1302, &
                   156,    -33,    210,    210,    -33,    210,    210,     21,     21,     21,    480,     48,     -6,     -6, &
                  -195,   1749,    318,   -357,   -195,    156,     48,    210,    264,   -222,    534,    156,    912,    156, &
                    21,     21,   -195,    -33,  -1464,    210,    480,     48,     48,   -384,   -384,   3072,   -168,   1344, &
                    48,    156,   -195,    210,   -168,   -114,   1560,    210,    534,   -222,    318,   -357,   -141,   -222, &
                  -141,   1533,     -6,     -6,     -6,   -195,   -195,     48,   -168,   1533,   -141,    210,  -1464,    210, &
                  -168,   -114,   -141,    -33,   -195,     21,    264,   -222,     48,   -222,     48,    264,     -6,    480, &
                    -6,   1749,     48,   -195,   -168,   -168,   -141,     21,     48,   -222,   -168,   1344,   -141,    264, &
                  -141,   -168,   -168,   1533,   1560,   1533,   1560,   -168]
  K1( 358,:) = [    696,  -2652,    264,   -168,    318,    372,   -816,    696,    696,    264,    264,  -3084,  -3084,    372, &
                   264,    318,    -60,   -600,    372,    -60,   -168,    372,     -6,    -60,    102,    399,    156,    210, &
                   -33,     21,  -1950,   -195,    210,  -1140,    210,  -3030,   -546,     -6,   -222,    372,    156,  -2004, &
                   183,     -6,     21,    183,    210,     -6,    588,  -1302,  -1302,    210,    210,     21,    -60,     -6, &
                   156,    264,    156,  -1140,    183,     -6,    210,  -1140,    156,    372,    -60,     -6,    -33,    372, &
                   210,  -1518,    399,    -33,    102,    156,     21,    210,   -249,   -195,   1533,  -1518,    210,     -6, &
                   237,     48,   -222,    372,    -33,    183,     -6,    -60,   -222,   1506,    264,   -492,  -1302,    210, &
                   588,  -1302,     21,    210,    237,     48,   -168,     -6,   -222,   1506,  -1464,  -1896,    264,  -2004, &
                    21,     -6,   -195,  -1950,   1533, -12291,   -168,   1506]
  K1( 359,:) = [    588,  -1302,  -1302,    210,    210,     21,    102,    399,    102,    588,    156,  -1302,    156,    -33, &
                   399,  -1302,    210,    210,    210,     21,    -33,    210,     21,     21,    480,     48,     48,   -384, &
                  -384,   3072,   -168,   1344,     48,    156,   -195,    210,   -168,   -114,   1560,    210,    534,   -222, &
                   318,   -357,   -141,   -222,   -141,   1533,    480,     48,     -6,     -6,   -195,   1749,    318,   -357, &
                  -195,    156,     48,    210,    264,   -222,    534,    156,    912,    156,     21,     21,   -195,    -33, &
                 -1464,    210,     -6,   -195,     -6,     -6,     48,   -195,   -168,   -114,   -141,    -33,   -195,     21, &
                  -168,   1533,   -141,    210,  -1464,    210,   -222,    264,     48,    264,     48,   -222,     -6,   1749, &
                    -6,    480,   -195,     48,   -168,   1344,   -141,    264,   -141,   -168,   -168,   -168,   -141,     21, &
                    48,   -222,   1533,   -168,   1560,   -168,   1560,   1533]
  K1( 360,:) = [   -816,    696,    696,    264,    264,  -3084,    696,  -2652,    264,   -168,    318,    372,    264,    318, &
                 -3084,    372,   -600,    -60,   -168,    372,    372,    -60,    -60,     -6,    588,  -1302,  -1302,    210, &
                   210,     21,    -60,     -6,    156,    264,    156,  -1140,    183,     -6,    210,  -1140,    156,    372, &
                   -60,     -6,    -33,    372,    210,  -1518,    102,    399,    156,    210,    -33,     21,  -1950,   -195, &
                   210,  -1140,    210,  -3030,   -546,     -6,   -222,    372,    156,  -2004,    183,     -6,     21,    183, &
                   210,     -6,    102,    156,    399,    -33,    210,     21,    237,     48,   -222,    372,    -33,    183, &
                  -249,   -195,   1533,  -1518,    210,     -6,    -60,     -6,    264,   -492,   -222,   1506,    588,  -1302, &
                 -1302,    210,    210,     21,  -1464,  -1896,    264,  -2004,     21,     -6,    237,     48,   -168,     -6, &
                  -222,   1506,  -1950,   -195,   -168,   1506,   1533, -12291]
  K1( 361,:) = [  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78, &
                  3432,   -456,   3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104,  -2724,    408,    408,   -456, &
                  -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30,   -456,    408,    -78,   -456, &
                   -78,   -348,     30,   -456,   -348,   -240,    300,   -456,    -78,    -78,     30,   -348,   3432,   -240, &
                  -456,    408,   -348,    624,   3324,    -78,   2568,   -456,    300,   3432,    -78,     30,   -348,   -348, &
                  -456,   -240,    300,    -78,   -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348, &
                  2568,   -348,  -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104,  -2724,    408, &
                   408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240, &
                  2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056]
  K1( 362,:) = [  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456, &
                  -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568,    408,  -2724,   -456,   -240, &
                   408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348,     30,   -456,   -348,   -240, &
                   -78,     30,   -456,    408,    -78,   -456,   -456,    300,     30,   -348,    -78,    -78,   -240,   3432, &
                  -348,    624,   -456,    408,    -78,     30,   -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456, &
                   300,   3432,  -2724,    408,    408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240, &
                  -456,   -348,   -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056,    300,    -78, &
                  -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240, &
                  -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104]
  K1( 363,:) = [  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408, &
                   300,    300,    -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568,    408,   -456,  -2724,    408, &
                  -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456,    300,  -2724,    -78,    408, &
                  -348,    -78,   -348,   -240,     30,   -456,    300,    -78,   -456,     30,    -78,   -348,   -456,   -348, &
                  2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,   -456,    -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624, &
                  3324,    -78,   2568,   -456,    300,   3432,    -78,     30,   -348,   -348,   -456,   -240,    408,  -2724, &
                  -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104]
  K1( 364,:) = [    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724, &
                   -78,   -456,    300,    300,    -78,    300,   3324,   2568,   3432,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300,    -78,    408,    300,  -2724, &
                    30,    -78,    -78,   -456,   -456,    408,  -2724,    408,    408,   -456,   -456,   -240,    408,    624, &
                  -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,    300,     30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408, &
                   -78,     30,   -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456,    300,   3432,    -78,    300, &
                   -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456,   -456,   2568, &
                  2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240]
  K1( 365,:) = [    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300, &
                  2568,  -1104,   -456,   2568,  -2724,    408,    300,    300,    -78,   -456,   -456,    408,   -240,   -456, &
                 -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78,   -348,   -240,     30,   -456, &
                   300,   -456,    300,  -2724,    -78,    408,    -78,    300,    -78,   -348,   -456,     30,   -348,   -456, &
                    30,   -348,   2568,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240, &
                  -456,   -240,    408,  -2724,   -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432, &
                  3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104,    300,   -456, &
                   -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78,   2568,   -456, &
                   300,   3432,    -78,     30,   -348,   -348,   -456,   -240]
  K1( 366,:) = [   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300, &
                  3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456,    300,    300,   -240,   -456,   -456,    408, &
                   408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78,    -78,   -456,   -456,    408, &
                  -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,    624,    408, &
                  -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240, &
                  2568,  -1104,    -78,    300,    -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456, &
                   300,   -456,   -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,    300, &
                    30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30,   -348,   -348, &
                  -456,   -240,   3324,    -78,   2568,   -456,    300,   3432]
  K1( 367,:) = [  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456, &
                   300,    -78,   2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568,    300,   -456,    -78,    -78, &
                    30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78,   2568,   -456,    300,   3432, &
                   -78,     30,   -348,   -348,   -456,   -240,  -2724,    408,    408,   -456,   -456,   -240,    300,   -456, &
                   300,  -2724,    -78,    408,    -78,     30,   -456,    408,    -78,   -456,    -78,   -348,     30,   -456, &
                  -348,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240, &
                  -456,   -348,   2568,   -456,     30,   -348,   -456,    300,   2568,  -1104,   -456,   2568,    408,   -456, &
                 -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624,   -456,   3432, &
                  -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104]
  K1( 368,:) = [    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324,   -456,    300,     30,   -348, &
                   -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30,   -348,   -348,   -456,   -240, &
                  3324,    -78,   2568,   -456,    300,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -456,    300, &
                   -78,    408,    300,  -2724,    -78,   -348,     30,   -456,   -348,   -240,    -78,     30,   -456,    408, &
                   -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104, &
                   408,    624,   -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,   -456,     30, &
                   300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456, &
                    30,   -348,   -456,    300,   2568,  -1104,   -456,   2568]
  K1( 369,:) = [    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300, &
                 -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240,   -456,   -240, &
                   300,   -456,   -456,   2568,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,    -78,     30, &
                  -456,    408,    -78,   -456,    300,   -456,    300,  -2724,    -78,    408,   -348,    -78,   -348,   -240, &
                    30,   -456,    -78,    -78,    300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432, &
                  3432,   -240,   -456,    408,   -348,    624,     30,    -78,   -456,   -240,   -348,   -348,   -456,   -240, &
                   408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240, &
                  -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240]
  K1( 370,:) = [    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456, &
                   408,  -2724,    300,    300,   3324,   2568,    -78,    300,   -456,   3432,  -2724,    408,    408,   -456, &
                  -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240,   2568,  -1104, &
                  3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348, &
                    30,   -456,   -348,   -240,   -456,    300,    -78,    408,    300,  -2724,     30,    -78,    -78,   -456, &
                  -456,    408,     30,   -348,   -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240, &
                  -240,   3432,   -348,    624,   -456,    408,    -78,   3324,    300,   3432,   2568,   -456,    -78,   -348, &
                   -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348, &
                  2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240]
  K1( 371,:) = [    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104, &
                  -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,    -78,    300,    -78,   -348, &
                  -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456,   -456,   2568,   2568,  -1104, &
                  2568,   -348,  -1104,   -240,   -456,   -240,   -456,    408,   -240,   -456,  -2724,    408,     30,    -78, &
                   -78,   -456,   -456,    408,   -348,    -78,   -348,   -240,     30,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056, &
                   624,    408,   -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240,    -78,    -78, &
                   300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240,   -456,    408, &
                  -348,    624,     30,    -78,   -456,   -240,   -348,   -348]
  K1( 372,:) = [   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568, &
                   -78,    300,   -456,   3432,    -78,   -456,    408,  -2724,    300,    300,    408,  -2724,   -456,   -240, &
                   408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104,  -1104,   1056, &
                  -456,   -348,   -240,   -240,   2568,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78, &
                  -348,   -240,     30,   -456,     30,    -78,    -78,   -456,   -456,    408,   -456,    300,    -78,    408, &
                   300,  -2724,    -78,   -348,    -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104, &
                  -348,   -456,     30,   -348,   2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -348, &
                  -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432,   -348,    624, &
                  -456,    408,    -78,   3324,    300,   3432,   2568,   -456]
  K1( 373,:) = [    300,    300,  -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724, &
                 -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568,    300,   -456,    -78,    -78,    300,   -456, &
                  -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240,   -456,    408,   -348,    624, &
                    30,    -78,   -456,   -240,   -348,   -348,   -456,     30,    300,    -78,   -348,    -78,   2568,   -348, &
                 -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456,     30,   -348,   -456,    300,   2568,  -1104, &
                  -456,   2568,  -2724,    408,    408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408, &
                   -78,     30,   -456,    408,    -78,   -456,    -78,   -348,     30,   -456,   -348,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,    408,    624,   -456,   3432,   -348,   -240]
  K1( 374,:) = [    -78,   -456,    408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846, &
                   300,   3432,  -2724,    300,   -456,   3432,   2568,   3324,    300,    -78,     30,   -348,   -456,    300, &
                   -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432,   -348,    624,   -456,    408, &
                   -78,   3324,    300,   3432,   2568,   -456,    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348, &
                  -240,   -240,   2568,  -1104,    408,    624,   -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,    408,  -2724,   -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724, &
                   -78,   -348,     30,   -456,   -348,   -240,    -78,     30,   -456,    408,    -78,   -456,     30,   -456, &
                  -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -456,   -348,   2568,   -456,     30,   -348]
  K1( 375,:) = [   3432,   -456,    300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300, &
                 21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78, &
                  -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456,     30,   -348, &
                  -456,    300,   2568,  -1104,   -456,   2568,    -78,    -78,    300,   -456,   -348,     30,   3324,    -78, &
                  2568,   -456,    300,   3432,   3432,   -240,   -456,    408,   -348,    624,     30,    -78,   -456,   -240, &
                  -348,   -348,    408,   -456,  -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456, &
                   300,   -456,    300,  -2724,    -78,    408,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104, &
                  -240,   -240,    624,    408,   -348,   -240,   -456,   3432]
  K1( 376,:) = [   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432, &
                 -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432,    -78,    300,    408,   -456,  -2724,    408, &
                  -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624,   -456,   3432,   -348,   -240, &
                  -240,   3432,  -1104,   1056,   -240,  -1104,     30,   -348,   -456,    300,    -78,    -78,    -78,     30, &
                  -348,   -348,   -456,   -240,   -240,   3432,   -348,    624,   -456,    408,    -78,   3324,    300,   3432, &
                  2568,   -456,   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240, &
                  -456,    300,    -78,    408,    300,  -2724,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78, &
                    30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240, &
                 -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456]
  K1( 377,:) = [   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724, &
                  3432,    300,  21846,  -2724,    300,    300,   -456,    -78,  -2724,    408,    -78,   -348,    -78,    300, &
                    30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348,   2568,   -456, &
                  -348,   2568,   -456,   -240,  -1104,   -240,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104, &
                  -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408, &
                  -348,    -78,   -348,   -240,     30,   -456,    300,   -456,    300,  -2724,    -78,    408,    -78,    -78, &
                  -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78,   -456,   -240, &
                  -348,   -348,   3432,   -240,   -456,    408,   -348,    624]
  K1( 378,:) = [   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300, &
                   300,  -2724,  -2724,  21846,   -456,    -78,    300,    300,    408,  -2724,   -456,   -240,    408,  -2724, &
                  -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240,   -456,   3432, &
                  -348,   -456,   2568,  -1104,   -240,   -240,    -78,   -348,    -78,    300,     30,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348,   2568,   -456,   -348,   2568,   -456,   -240, &
                 -1104,   -240,   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456, &
                    30,    -78,    -78,   -456,   -456,    408,   -456,    300,    -78,    408,    300,  -2724,   -348,     30, &
                   -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324,    300,   3432, &
                  2568,   -456,   -240,   3432,   -348,    624,   -456,    408]
  K1( 379,:) = [    300,    300,   -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456, &
                 -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,    -78,    -78,   -348,     30, &
                   300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78,   -456,   -240,   -348,   -348, &
                  3432,   -240,   -456,    408,   -348,    624,     30,   -456,   -348,    -78,    300,    -78,   -348,   2568, &
                  -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456, &
                    30,   -348,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240, &
                  -240,   3432,  -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408, &
                   408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30,   -456,    408, &
                   -78,   -456,    -78,   -348,     30,   -456,   -348,   -240]
  K1( 380,:) = [   -456,    -78,    300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432, &
                  2568,   3324,    300,    -78,  -2724,  21846,    300,   3432,  -2724,    300,   -348,     30,    -78,    -78, &
                  -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324,    300,   3432,   2568,   -456, &
                  -240,   3432,   -348,    624,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456, &
                  2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432, &
                  -348,   -240,     30,   -456,   -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240, &
                  -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,    408,  -2724, &
                  -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348,     30,   -456, &
                  -348,   -240,    -78,     30,   -456,    408,    -78,   -456]
  K1( 381,:) = [   -456,   3432,   2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568, &
                  2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724,   3432,    300,     30,   -456,   -348,    -78, &
                   300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104,   -456,   2568, &
                  -456,   -348,   2568,   -456,     30,   -348,    -78,    -78,   -348,     30,    300,   -456,    -78,   3324, &
                   300,   3432,   2568,   -456,     30,    -78,   -456,   -240,   -348,   -348,   3432,   -240,   -456,    408, &
                  -348,    624,   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104, &
                  -348,   -456,   2568,  -1104,   -240,   -240,    624,    408,   -348,   -240,   -456,   3432,    408,   -456, &
                 -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,   -348,    -78,   -348,   -240,     30,   -456]
  K1( 382,:) = [   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324, &
                  -456,   3432,    -78,    300,    300,   3432,  -2724,  21846,    300,  -2724,   -456,    408,   -240,   -456, &
                 -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104, &
                   408,    624,   -456,   3432,   -348,   -240,   -348,     30,    -78,    -78,   -456,    300,     30,    -78, &
                  -456,   -240,   -348,   -348,    -78,   3324,    300,   3432,   2568,   -456,   -240,   3432,   -348,    624, &
                  -456,    408,   -348,    -78,     30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568, &
                  -348,   2568,   -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456,   -456,   -240, &
                   408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300,    -78,    408, &
                   300,  -2724,     30,    -78,    -78,   -456,   -456,    408]
  K1( 383,:) = [   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300, &
                  -456,    -78,  -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724,   -348,    -78,     30,   -456, &
                   -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240,  -1104,   -240, &
                  -348,   -456,     30,   -348,   2568,   -456,   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104,   -240,   -240,    624,    408,   -348,   -240, &
                  -456,   3432,    -78,    -78,   -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456, &
                    30,    -78,   -456,   -240,   -348,   -348,   3432,   -240,   -456,    408,   -348,    624,   -456,    408, &
                  -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78,   -348,   -240, &
                    30,   -456,    300,   -456,    300,  -2724,    -78,    408]
  K1( 384,:) = [  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78, &
                   300,    300,    408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104,   -240,   -240, &
                   624,    408,   -348,   -240,   -456,   3432,   -348,    -78,     30,   -456,    -78,    300,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348, &
                  2568,   -456,   -348,     30,    -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348, &
                   -78,   3324,    300,   3432,   2568,   -456,   -240,   3432,   -348,    624,   -456,    408,   -240,   -456, &
                  -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78,    -78,   -456, &
                  -456,    408,   -456,    300,    -78,    408,    300,  -2724]
  K1( 385,:) = [  -2724,    408,    408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30, &
                  -456,    408,    -78,   -456,    -78,   -348,     30,   -456,   -348,   -240,  21846,  -2724,  -2724,    300, &
                   300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78,   3432,   -456,   3324,   2568, &
                   300,   -456,   -456,   2568,   2568,  -1104,   3432,   -240,   -456,    408,   -348,    624,    300,   -456, &
                   -78,    -78,     30,   -348,   2568,   -456,   3324,    -78,   3432,    300,   -348,   -348,    -78,     30, &
                  -240,   -456,   -456,   -348,   2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348, &
                 -1104,   -240,   2568,   -348,   -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568,    408,    624, &
                  -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104]
  K1( 386,:) = [    408,  -2724,   -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348, &
                    30,   -456,   -348,   -240,    -78,     30,   -456,    408,    -78,   -456,  -2724,  21846,    300,   3432, &
                 -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456,   -456,   2568,   2568,  -1104, &
                   300,    -78,   3432,   -456,   3324,   2568,   -240,   3432,   -348,    624,   -456,    408,   -456,    300, &
                    30,   -348,    -78,    -78,   -348,   -348,    -78,     30,   -240,   -456,   2568,   -456,   3324,    -78, &
                  3432,    300,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240, &
                  -240,   -240,   -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104,   -456,   -348, &
                  2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348, &
                  -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568]
  K1( 387,:) = [    408,   -456,  -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456, &
                   300,  -2724,    -78,    408,   -348,    -78,   -348,   -240,     30,   -456,  -2724,    300,  21846,  -2724, &
                  3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408,    300,    300,    -78,   -456, &
                  -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,    300,    -78, &
                  -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456,   -456,   2568,    300,   -456, &
                 -1104,   2568,   3432,   -240,   -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348, &
                  2568,   -456,   3324,    -78,   3432,    300,   -348,   -348,    -78,     30,   -240,   -456,    624,    408, &
                  -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568]
  K1( 388,:) = [   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300, &
                   -78,    408,    300,  -2724,     30,    -78,    -78,   -456,   -456,    408,    300,   3432,  -2724,  21846, &
                   300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456,    300,    300, &
                   -78,    300,   3324,   2568,   3432,   -456,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408, &
                   408,   -456,   -456,   -240,   -240,   -240,   -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -240,   3432,   -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78, &
                  -348,   -348,    -78,     30,   -240,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -348,   -456, &
                    30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568,    300,   -456, &
                 -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456]
  K1( 389,:) = [   -456,    408,   -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78, &
                  -348,   -240,     30,   -456,    300,   -456,    300,  -2724,    -78,    408,    300,  -2724,   3432,    300, &
                 21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104,   -456,   2568, &
                 -2724,    408,    300,    300,    -78,   -456,   -348,   -456,     30,   -348,   2568,   -456,    -78,    300, &
                   -78,   -348,   -456,     30,   -456,   2568,    300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348, &
                  -240,   -456,    624,    408,   -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456, &
                  -240,  -1104,   3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568,   3432,   -240, &
                  -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456,   3324,    -78, &
                  3432,    300,   -348,   -348,    -78,     30,   -240,   -456]
  K1( 390,:) = [   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78, &
                   -78,   -456,   -456,    408,   -456,    300,    -78,    408,    300,  -2724,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568,   3432,   -456, &
                   408,  -2724,    -78,   -456,    300,    300,    624,    408,   -348,   -240,   -456,   3432,    408,  -2724, &
                  -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -348,   -456,     30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30, &
                  -456,   2568,    300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,   -240,   3432, &
                  -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348,    -78,     30, &
                  -240,   -456,   2568,   -456,   3324,    -78,   3432,    300]
  K1( 391,:) = [    300,   -456,    -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78, &
                  2568,   -456,    300,   3432,    -78,     30,   -348,   -348,   -456,   -240,  -2724,    408,    300,    300, &
                   -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456,    300,    -78,   2568,   3324, &
                  -456,   2568,    300,   -456,  -1104,   2568,    300,   -456,    300,  -2724,    -78,    408,  -2724,    408, &
                   408,   -456,   -456,   -240,   -456,    408,    -78,     30,   -456,    -78,     30,   -456,    -78,   -348, &
                  -240,   -348,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78, &
                  2568,   -456,   -456,   -348,   -348,     30,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -348, &
                  -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432,    408,    624, &
                  -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240]
  K1( 392,:) = [   -456,    300,     30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30, &
                  -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456,    300,   3432,    408,  -2724,    -78,   -456, &
                   300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568,    300,   -456,  -1104,   2568, &
                  3432,   -456,    300,    -78,   2568,   3324,   -456,    300,    -78,    408,    300,  -2724,    408,  -2724, &
                  -456,   -240,    408,   -456,     30,   -456,    -78,   -348,   -240,   -348,   -456,    408,    -78,     30, &
                  -456,    -78,   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456, &
                  -456,   3432,    408,    624,   -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,   -348, &
                 -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456,   -456,   -348, &
                  -348,     30,   2568,  -1104,   -456,    300,   2568,   -456]
  K1( 393,:) = [    300,    -78,   -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348, &
                 -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456, &
                  3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300,  -2724,    408,   -456,    -78, &
                  2568,  -1104,   -456,    300,   2568,   -456,    -78,     30,   -456,    408,    -78,   -456,    408,   -456, &
                 -2724,    408,   -240,   -456,    300,  -2724,    300,   -456,    408,    -78,   -348,   -240,   -348,    -78, &
                  -456,     30,   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30, &
                  -456,    408,   3432,   -240,    624,   -348,   -456,   -240,     30,    -78,   -348,   -348,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240,    624,    408, &
                  3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240]
  K1( 394,:) = [  -2724,    408,    408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348, &
                  -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724,    300,    300, &
                  3324,   2568,    -78,    300,   -456,   3432,    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240, &
                   408,  -2724,   -456,    408,    -78,    408,   -456,    300,  -2724,    300,    -78,   -456,     30,    -78, &
                   408,   -456,    -78,     30,   -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78, &
                  -348,    624,   -240,   3432,    408,   -456,    300,   3432,    -78,   3324,   -456,   2568,    300,   -456, &
                  -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348,   -348,   -456, &
                  -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104]
  K1( 395,:) = [    -78,    300,    -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240,    -78,    300,   3324,   2568, &
                  3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300,   2568,   -456, &
                   300,    300,  -2724,    408,   -456,    -78,     30,    -78,    -78,   -456,   -456,    408,   -456,    408, &
                  -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78,   -456,     30,    300,  -2724,    300,   -456, &
                   408,    -78,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408, &
                  -348,   -240,    624,    408,   3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240,   3324,    -78, &
                  2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408,   3432,   -240, &
                   624,   -348,   -456,   -240,     30,    -78,   -348,   -348]
  K1( 396,:) = [    408,  -2724,   -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104,   -456,    300,   2568,  -1104, &
                  -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300,   -456,   3432, &
                   -78,   -456,    408,  -2724,    300,    300,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,    -78,   -456,     30,    -78,    408,   -456,    -78,    408,   -456,    300, &
                 -2724,    300,    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456, &
                    30,   -348,   -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104,    -78,     30, &
                  -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624,   -240,   3432, &
                   408,   -456,    300,   3432,    -78,   3324,   -456,   2568]
  K1( 397,:) = [    -78,    -78,    300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240, &
                  -456,    408,   -348,    624,     30,    -78,   -456,   -240,   -348,   -348,    300,    300,  -2724,    408, &
                  -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300,    300,   3432, &
                  2568,   -456,  -1104,   2568,    300,   -456,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30, &
                   300,    -78,   -348,    -78,   2568,   -456,   -456,   -348,   -348,     30,   2568,  -1104,   -456,    300, &
                  2568,   -456,    300,   -456,    300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240, &
                  -456,    408,    -78,     30,   -456,    -78,     30,   -456,    -78,   -348,   -240,   -348,   -348,   -456, &
                  2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   -456,   3432,    408,    624,   -240,   -348]
  K1( 398,:) = [     30,   -348,   -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432, &
                  -348,    624,   -456,    408,    -78,   3324,    300,   3432,   2568,   -456,    -78,   -456,    408,  -2724, &
                   300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432,  -2724,    300, &
                  -456,   3432,   2568,   3324,    300,    -78,   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456, &
                 -2724,    408,   -240,   -456,   -456,   3432,    408,    624,   -240,   -348,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456, &
                    30,   -456,    -78,   -348,   -240,   -348,   -456,    408,    -78,     30,   -456,    -78,   -348,   2568, &
                  -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104,   -456,    300, &
                  2568,   -456,   2568,   -456,   -456,   -348,   -348,     30]
  K1( 399,:) = [   -456,     30,    300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348, &
                  2568,   -456,     30,   -348,   -456,    300,   2568,  -1104,   -456,   2568,   3432,   -456,    300,    -78, &
                  2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724,   3432,    300, &
                 -1104,   2568,   2568,   -456,   -456,    300,   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78, &
                   300,   -456,   -348,     30,   -456,    408,   3432,   -240,    624,   -348,   -456,   -240,     30,    -78, &
                  -348,   -348,    -78,     30,   -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456, &
                   300,  -2724,    300,   -456,    408,    -78,   -348,   -240,   -348,    -78,   -456,     30,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456, &
                  -240,   -240,   -348,   -240,    624,    408,   3432,   -456]
  K1( 400,:) = [    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624, &
                  -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,   -456,   2568,    300,   -456, &
                 -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432,  -2724,  21846,    300,  -2724, &
                  2568,   3324,   -456,   3432,    -78,    300,    -78,     30,   -348,   -348,   -456,   -240,     30,   -348, &
                  -456,    300,    -78,    -78,   -348,    624,   -240,   3432,    408,   -456,    300,   3432,    -78,   3324, &
                  -456,   2568,    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408, &
                   -78,    408,   -456,    300,  -2724,    300,    -78,   -456,     30,    -78,    408,   -456,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240,   -348,   2568, &
                  -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568]
  K1( 401,:) = [    -78,   -348,    -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456, &
                    30,   -348,   2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240,   3324,   2568,    -78,    300, &
                  -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724,   3432,    300,  21846,  -2724, &
                   300,    300,   -456,    -78,  -2724,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240, &
                   408,  -2724,   -456,    408,   -348,   -240,    624,    408,   3432,   -456,   2568,  -1104,   -348,   -456, &
                  -240,   -240,     30,    -78,    -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408, &
                  -348,   -240,   -348,    -78,   -456,     30,    300,  -2724,    300,   -456,    408,    -78,    -78,   3324, &
                   300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240,     30,    -78, &
                  -348,   -348,   -456,    408,   3432,   -240,    624,   -348]
  K1( 402,:) = [   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408, &
                  -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240,   2568,  -1104,   -456,    300, &
                  2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300,    300,  -2724,  -2724,  21846, &
                  -456,    -78,    300,    300,    408,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348, &
                   -78,    300,     30,   -456,     30,   -348,   -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568, &
                  -240,  -1104,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724, &
                   -78,   -456,     30,    -78,    408,   -456,    -78,    408,   -456,    300,  -2724,    300,     30,    -78, &
                  -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432,    -78,   3324, &
                  -456,   2568,   -348,    624,   -240,   3432,    408,   -456]
  K1( 403,:) = [    -78,    -78,   -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78, &
                  -456,   -240,   -348,   -348,   3432,   -240,   -456,    408,   -348,    624,    300,    300,   -456,    -78, &
                 -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568,    300,   -456, &
                 21846,  -2724,  -2724,    300,    300,   3432,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456, &
                  -348,    -78,    300,    -78,   2568,  -1104,   -456,    300,   2568,   -456,   2568,   -456,   -456,   -348, &
                  -348,     30,   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408, &
                 -1104,   1056,   -240,   3432,  -1104,   -240,   -456,   3432,    408,    624,   -240,   -348,    300,   -456, &
                   300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408,    -78,     30, &
                  -456,    -78,     30,   -456,    -78,   -348,   -240,   -348]
  K1( 404,:) = [   -348,     30,    -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324, &
                   300,   3432,   2568,   -456,   -240,   3432,   -348,    624,   -456,    408,   -456,    -78,    300,    300, &
                   408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324,    300,    -78, &
                 -2724,  21846,    300,   3432,  -2724,    300,   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,   3432,    408,    624, &
                  -240,   -348,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78, &
                  2568,  -1104,   -456,    300,   2568,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,    300, &
                   -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456,    -78,   -348, &
                  -240,   -348,   -456,    408,    -78,     30,   -456,    -78]
  K1( 405,:) = [     30,   -456,   -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,   -456,   3432,   2568,   3324, &
                   300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456,   -456,    300, &
                 -2724,    300,  21846,  -2724,   3432,    300,    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78, &
                  -348,     30,    300,   -456,   -456,   -240,     30,    -78,   -348,   -348,   -456,    408,   3432,   -240, &
                   624,   -348,   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724, &
                  2568,  -1104,   -348,   -456,   -240,   -240,   -348,   -240,    624,    408,   3432,   -456,    -78,     30, &
                  -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724,    300,   -456, &
                   408,    -78,   -348,   -240,   -348,    -78,   -456,     30]
  K1( 406,:) = [   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432,   -348,   -240,   2568,   -456,  -1104,   2568, &
                   300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324,   -456,   3432,    -78,    300, &
                   300,   3432,  -2724,  21846,    300,  -2724,     30,    -78,   -456,   -240,   -348,   -348,   -348,     30, &
                   -78,    -78,   -456,    300,    300,   3432,    -78,   3324,   -456,   2568,   -348,    624,   -240,   3432, &
                   408,   -456,   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300, &
                  -456,   -240,   -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348, &
                    30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408,   -456,    300, &
                 -2724,    300,    -78,   -456,     30,    -78,    408,   -456]
  K1( 407,:) = [   -348,    -78,     30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568, &
                  -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456,   2568,   3324,   -456,   3432, &
                   -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300,   -456,    -78,  -2724,    408, &
                   300,  -2724,   3432,    300,  21846,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456, &
                  -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456,   -240,   -240,   -348,   -240,    624,    408, &
                  3432,   -456,    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456, &
                  -456,   -240,     30,    -78,   -348,   -348,   -456,    408,   3432,   -240,    624,   -348,     30,    -78, &
                   -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78, &
                  -456,     30,    300,  -2724,    300,   -456,    408,    -78]
  K1( 408,:) = [   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456, &
                  2568,  -1104,   -240,   -240,    624,    408,   -348,   -240,   -456,   3432,  -1104,   2568,   2568,   -456, &
                  -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78,    300,    300,    408,  -2724, &
                  3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78, &
                    30,   -456,    -78,    300,   -456,   -240,   -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456, &
                  -456,   2568,     30,    -78,   -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300, &
                   300,   3432,    -78,   3324,   -456,   2568,   -348,    624,   -240,   3432,    408,   -456,   -348,    -78, &
                  -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456,     30,    -78, &
                   408,   -456,    -78,    408,   -456,    300,  -2724,    300]
  K1( 409,:) = [    300,   -456,    300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408, &
                   -78,     30,   -456,    -78,     30,   -456,    -78,   -348,   -240,   -348,   3432,   -240,   -456,    408, &
                  -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456,   3324,    -78,   3432,    300, &
                  -348,   -348,    -78,     30,   -240,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408, &
                   300,    300,    -78,   -456,    300,    -78,   3432,   -456,   3324,   2568,    300,   -456,   -456,   2568, &
                  2568,  -1104,   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456, &
                   300,    -78,   -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432, &
                   408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456, &
                  -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240]
  K1( 410,:) = [   -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456, &
                   -78,   -348,   -240,   -348,   -456,    408,    -78,     30,   -456,    -78,   -240,   3432,   -348,    624, &
                  -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348,    -78,     30,   -240,   -456, &
                  2568,   -456,   3324,    -78,   3432,    300,  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724, &
                   -78,   -456,    300,    300,    300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456, &
                  3324,   2568,   -456,   3432,    408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568, &
                 -2724,    408,    408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240,   2568,   -456, &
                  -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456]
  K1( 411,:) = [    -78,     30,   -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724, &
                   300,   -456,    408,    -78,   -348,   -240,   -348,    -78,   -456,     30,   -456,   -348,   2568,   -456, &
                    30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456, &
                  -456,   2568,    300,   -456,  -1104,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78, &
                  3432,   -456,   3324,   2568,  -2724,    408,    300,    300,    -78,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -456,    408,   3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300, &
                   300,   -456,    -78,    -78,     30,   -348,   -348,   -348,   -240,   -456,    -78,     30,   -348,   -240, &
                   624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240, &
                   408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348]
  K1( 412,:) = [    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408, &
                  -456,    300,  -2724,    300,    -78,   -456,     30,    -78,    408,   -456,    408,    624,   -456,   3432, &
                  -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240,   -456,   -348,  -1104,   2568, &
                  -240,  -1104,   3432,   -240,   1056,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456, &
                  -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456,    300,    300,    -78,    300,   3324,   2568, &
                  3432,   -456,   -348,    624,   -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456, &
                  -456,    300,     30,   -348,    -78,    -78,   -456,   2568,   3432,    300,   3324,    -78,     30,   -348, &
                  -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300,    -78,   -348, &
                  -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348]
  K1( 413,:) = [     30,    -78,    -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240, &
                  -348,    -78,   -456,     30,    300,  -2724,    300,   -456,    408,    -78,   -348,   -456,     30,   -348, &
                  2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568,    300,   -456,  -1104,   2568, &
                 -1104,   -240,   2568,   -348,   -240,   -456,    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300, &
                  3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104,   -456,   2568,  -2724,    408,    300,    300, &
                   -78,   -456,   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104, &
                   408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   -456,    408, &
                  3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456,    -78,    -78, &
                    30,   -348,   -348,   -348,   -240,   -456,    -78,     30]
  K1( 414,:) = [   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456, &
                    30,    -78,    408,   -456,    -78,    408,   -456,    300,  -2724,    300,    624,    408,   -348,   -240, &
                  -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104, &
                  -240,   -240,   -456,   -348,  -1104,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300, &
                  2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456, &
                   300,    300,     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568, &
                   -78,    300,    -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348,   -348,    624, &
                  -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300,     30,   -348, &
                   -78,    -78,   -456,   2568,   3432,    300,   3324,    -78]
  K1( 415,:) = [   3432,   -240,   -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456, &
                  3324,    -78,   3432,    300,   -348,   -348,    -78,     30,   -240,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408,    -78,     30,   -456,    -78, &
                    30,   -456,    -78,   -348,   -240,   -348,  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724, &
                 -2724,    300,    300,   3432,   3432,   -456,    300,    -78,   2568,   3324,   -456,   2568,    300,   -456, &
                 -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30, &
                  -456,     30,    300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -240, &
                  -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456,  -2724,    408, &
                  -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432]
  K1( 416,:) = [   -240,   3432,   -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348, &
                   -78,     30,   -240,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -456,    300,    -78,    408, &
                   300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456,    -78,   -348,   -240,   -348, &
                  -456,    408,    -78,     30,   -456,    -78,    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846, &
                   300,   3432,  -2724,    300,   -456,   2568,    300,   -456,  -1104,   2568,   3432,   -456,    300,    -78, &
                  2568,   3324,   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348, &
                   408,   -456,  -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   -240, &
                  2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30,    300,    -78, &
                  -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300]
  K1( 417,:) = [   -456,   -348,   2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240, &
                  2568,   -348,   -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568,    -78,     30,   -456,    408, &
                   -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724,    300,   -456,    408,    -78, &
                  -348,   -240,   -348,    -78,   -456,     30,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300, &
                 21846,  -2724,   3432,    300,    300,    300,  -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300, &
                  2568,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348, &
                   -78,    -78,    300,   -456,   -348,     30,   -240,   -456,   -348,   -348,     30,    -78,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456]
  K1( 418,:) = [    408,    624,   -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240, &
                  -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104,    -78,   -348,     30,   -456, &
                  -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408,   -456,    300,  -2724,    300, &
                   -78,   -456,     30,    -78,    408,   -456,    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432, &
                 -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724,    300,    300,   3324,   2568,    -78,    300, &
                  -456,   3432,   -348,   -348,    -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456, &
                    30,   -348,   -456,    300,    -78,    -78,   3432,    300,   -456,   2568,    -78,   3324,   -456,   2568, &
                   300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348,    -78,    300, &
                    30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568]
  K1( 419,:) = [   -348,   -456,     30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568, &
                   300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,     30,    -78,    -78,   -456, &
                  -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78,   -456,     30, &
                   300,  -2724,    300,   -456,    408,    -78,    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724, &
                  3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408, &
                  -456,    -78,   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456, &
                  -456,   -240,    408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   2568,   -456, &
                  3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78,    300,   -456, &
                  -348,     30,   -240,   -456,   -348,   -348,     30,    -78]
  K1( 420,:) = [    624,    408,   -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568,   -348,    -78,   -348,   -240, &
                    30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456,     30,    -78,    408,   -456, &
                   -78,    408,   -456,    300,  -2724,    300,   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300, &
                   300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300,   -456,   3432,    -78,   -456,    408,  -2724, &
                   300,    300,   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568, &
                   -78,   -348,    -78,    300,     30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,   -348, &
                   -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348,   -456,    300, &
                   -78,    -78,   3432,    300,   -456,   2568,    -78,   3324]
  K1( 421,:) = [   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408, &
                  3432,   -240,    624,   -348,   -456,   -240,     30,    -78,   -348,   -348,   2568,   -348,  -1104,   -240, &
                  -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456,   -456,   -348,   -348,     30, &
                  2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,   3432,   -456, &
                   300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568, &
                   300,   -456,    300,  -2724,    300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78, &
                 -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348,    -78,   -348,   2568,  -1104, &
                  -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456, &
                 -2724,    408,   3432,   -456,   -240,   -348,    408,    624]
  K1( 422,:) = [    -78,     30,   -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624, &
                  -240,   3432,    408,   -456,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -348,   -240,   -240, &
                  2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432,    408,    624,   -240,   -348, &
                 -1104,   1056,   -240,   3432,  -1104,   -240,    -78,   -456,    408,  -2724,    300,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   3432,   2568,   3324, &
                   300,    -78,    -78,    408,   -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348, &
                   408,  -2724,   -456,   -240,    408,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,   -240, &
                  -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456,   -348,    -78, &
                   300,    -78,   -456,   2568,   -348,     30,   -456,   -348]
  K1( 423,:) = [   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456, &
                  -456,   -348,   -348,     30,   2568,  -1104,   -456,    300,   2568,   -456,   3324,    -78,   2568,   -456, &
                   300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408,   3432,   -240,    624,   -348, &
                  -456,   -240,     30,    -78,   -348,   -348,   3432,   -456,    300,    -78,   2568,   3324,    300,    300, &
                 -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -456,    408,    -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78, &
                   408,   -456,  -2724,    408,   -240,   -456,   -240,   -348,   -456,     30,   -348,    -78,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   -348,   3432,   -456,    624,    408]
  K1( 424,:) = [   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432, &
                   408,    624,   -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240,    -78,     30,   -348,   -348, &
                  -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624,   -240,   3432,    408,   -456, &
                   300,   3432,    -78,   3324,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456, &
                   408,  -2724,    300,    300,    300,   3432,  -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432, &
                   -78,    300,     30,   -456,    -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300, &
                  -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   2568,  -1104, &
                  -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456, &
                   -78,    300,   -348,     30,   -456,   2568,   -348,   -456]
  K1( 425,:) = [    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348, &
                  -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240,    624,    408,   3432,   -456, &
                  2568,  -1104,   -348,   -456,   -240,   -240,   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104, &
                  -456,    300,   2568,   -456,    300,  -2724,   3432,    300,  21846,  -2724,    300,    300,   -456,    -78, &
                 -2724,    408,    -78,   -456,     30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30, &
                  -456,    408,   -240,   -456,  -2724,    408,  -2724,    300,    408,    -78,    300,   -456,    300,   3432, &
                   -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78,   -348,     30, &
                   300,   -456,    408,   -456,    624,   -348,   3432,   -240]
  K1( 426,:) = [   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240, &
                   624,    408,   3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240,    300,   -456,   -456,   2568, &
                  2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348,   -348,   -456,   -456,   2568, &
                  -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568, &
                   -78,    300,   -456,   3432,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    -78,    300,    300, &
                   408,  -2724,   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456, &
                  -240,   -456,   -456,    408,    408,  -2724,    408,    -78,  -2724,    300,   -456,    300,   -456,   -240, &
                    30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30,    -78,    -78, &
                  -456,    300,    624,   -348,    408,   -456,   -240,   3432]
  K1( 427,:) = [    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240, &
                    30,    -78,   -348,   -348,   -456,    408,   3432,   -240,    624,   -348,   -348,   2568,   -456,   -240, &
                 -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104,   -456,    300,   2568,   -456, &
                  2568,   -456,   -456,   -348,   -348,     30,    300,    300,   -456,    -78,  -2724,    408,   -456,   3432, &
                  2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300, &
                   300,   3432,   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240, &
                  -456,    408,   -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348,    408,    624,    300,  -2724, &
                   300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408,    408,   -456, &
                  -456,   -240,   -456,     30,   -240,   -348,    -78,   -348]
  K1( 428,:) = [     30,    -78,   -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432, &
                   -78,   3324,   -456,   2568,   -348,    624,   -240,   3432,    408,   -456,   -348,   -456,   2568,  -1104, &
                  -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432,  -1104,   -240, &
                  -456,   3432,    408,    624,   -240,   -348,   -456,    -78,    300,    300,    408,  -2724,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324,    300,    -78,  -2724,  21846,    300,   3432, &
                 -2724,    300,   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456, &
                    30,   -456,   -348,    -78,    300,    -78,   -456,   2568,   -348,     30,   -456,   -348,    -78,    408, &
                  -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240, &
                   408,   -456,    408,   -456,   -456,    -78,    -78,     30]
  K1( 429,:) = [   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104, &
                  -456,    300,   2568,   -456,   2568,   -456,   -456,   -348,   -348,     30,    -78,   3324,    300,   3432, &
                  2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240,     30,    -78,   -348,   -348, &
                  -456,    408,   3432,   -240,    624,   -348,   -456,   3432,   2568,   3324,    300,    -78,    300,    300, &
                  -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724, &
                  3432,    300,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240, &
                  -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456,    624,    408,   -456,    408, &
                   -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456,  -2724,    408, &
                  -240,   -456,   -240,   -348,   -456,     30,   -348,    -78]
  K1( 430,:) = [   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   -456,   3432,    408,    624,   -240,   -348,     30,    -78,   -456,   -240, &
                  -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432,    -78,   3324,   -456,   2568, &
                  -348,    624,   -240,   3432,    408,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78, &
                   300,    300,    408,  -2724,   2568,   3324,   -456,   3432,    -78,    300,    300,   3432,  -2724,  21846, &
                   300,  -2724,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104, &
                  -348,    -78,     30,   -456,    -78,    300,   -348,     30,   -456,   2568,   -348,   -456,     30,   -456, &
                   -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240,    408,  -2724, &
                  -456,    408,   -456,    -78,    408,   -456,     30,    -78]
  K1( 431,:) = [   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240, &
                  -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456,   -240,   -240, &
                  -348,   -240,    624,    408,   3432,   -456,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568, &
                  2568,   -456,   -456,    300,    300,    300,   -456,    -78,  -2724,    408,    300,  -2724,   3432,    300, &
                 21846,  -2724,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348, &
                   -78,    -78,   -348,     30,    300,   -456,    408,   -456,    624,   -348,   3432,   -240,    -78,   -456, &
                    30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408,   -240,   -456, &
                 -2724,    408,  -2724,    300,    408,    -78,    300,   -456]
  K1( 432,:) = [   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104, &
                  -348,   -456,   -240,   -240,   -348,   -240,    624,    408,   3432,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240,   -348,   2568,   -240,  -1104, &
                    30,   -348,   -348,   -456,   -456,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324, &
                  -456,   3432,    -78,    300,   -456,    -78,    300,    300,    408,  -2724,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,   -240,     30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568, &
                  -348,     30,    -78,    -78,   -456,    300,    624,   -348,    408,   -456,   -240,   3432,   -348,   -240, &
                  -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456,   -456,    408, &
                   408,  -2724,    408,    -78,  -2724,    300,   -456,    300]
  K1( 433,:) = [    300,  -2724,    300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408, &
                   408,   -456,   -456,   -240,   -456,     30,   -240,   -348,    -78,   -348,   -456,    408,   3432,   -240, &
                   624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456,    -78,    -78,     30,   -348, &
                  -348,   -348,   -240,   -456,    -78,     30,   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240, &
                  2568,   -348,   -240,   -456,    300,    -78,   -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568, &
                   300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456, &
                   300,    -78,   3432,   -456,   3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104,   3432,   -456, &
                  -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,  -2724,    408,    408,   -456,   -456,   -240]
  K1( 434,:) = [    -78,    408,   -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724, &
                  -456,   -240,    408,   -456,    408,   -456,   -456,    -78,    -78,     30,   -348,    624,   -240,   3432, &
                   408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300,     30,   -348,    -78,    -78, &
                  -456,   2568,   3432,    300,   3324,    -78,   -456,   3432,    408,    624,   -240,   -348,   -240,   -240, &
                  -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300, &
                   300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568,   -456,   2568, &
                  -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568, &
                   300,   -456,    300,    -78,   -456,     30,    -78,   -348]
  K1( 435,:) = [   -456,    408,    -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456, &
                 -2724,    408,   -240,   -456,   -240,   -348,   -456,     30,   -348,    -78,   2568,   -456,   -456,   -348, &
                  -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78,   -456,     30,    -78,   -348, &
                  2568,   -456,  -1104,   2568,    300,   -456,   -456,    408,   3432,   -240,    624,   -348,   2568,   -456, &
                  3324,    -78,   3432,    300,    300,   -456,    -78,    -78,     30,   -348,   -348,   -348,   -240,   -456, &
                   -78,     30,  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568, &
                 -2724,    408,    300,    300,    -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568,   -240,   -348, &
                  3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568, &
                  -456,   -348,    408,  -2724,   -456,   -240,    408,   -456]
  K1( 436,:) = [     30,   -456,    -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240, &
                   408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   -456,   3432,    408,    624, &
                  -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456,   -456,   -240, &
                 -1104,   -240,   1056,  -1104,   3432,   -240,   -348,    624,   -240,   3432,    408,   -456,   -348,   -348, &
                   -78,     30,   -240,   -456,   -456,    300,     30,   -348,    -78,    -78,   -456,   2568,   3432,    300, &
                  3324,    -78,    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104, &
                   408,  -2724,    -78,   -456,    300,    300,    -78,    300,   3324,   2568,   3432,   -456,   -348,     30, &
                  -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456, &
                  2568,   -348,    -78,    300,    -78,   -348,   -456,     30]
  K1( 437,:) = [    -78,   -456,     30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408, &
                  -240,   -456,  -2724,    408,  -2724,    300,    408,    -78,    300,   -456,     30,   -348,   -348,   -456, &
                  -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300,    -78,   -348,   -456,     30, &
                  -240,  -1104,   -240,   -456,   2568,   -348,   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568, &
                  -456,   -348,    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456, &
                  -456,    300,   2568,  -1104,   -456,   2568,  -2724,    408,    300,    300,    -78,   -456,    408,   -456, &
                   624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348,   -240,   -456, &
                   -78,     30,    300,   -456,    -78,    -78,     30,   -348]
  K1( 438,:) = [   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,    408,    -78,  -2724,    300,   -456,    300,   -348,   -240,    624,    408, &
                  3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240,    408,   -456, &
                  -240,   -240,  -1104,   2568,   -456,   -348,     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568, &
                   300,   -456,  -1104,   2568,    -78,    300,    -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456, &
                  2568,   -348,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568, &
                   -78,    300,   3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456,    300,    300,    624,   -348, &
                   408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568,   3432,    300, &
                  3324,    -78,   -456,    300,     30,   -348,    -78,    -78]
  K1( 439,:) = [   -456,    408,   3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456, &
                   -78,    -78,     30,   -348,   -348,   -348,   -240,   -456,    -78,     30,    300,  -2724,    300,   -456, &
                   408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408,    408,   -456,   -456,   -240, &
                  -456,     30,   -240,   -348,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456, &
                  -456,   -348,   -348,     30,   -456,     30,    300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456, &
                  -456,    300,  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432, &
                  3432,   -456,    300,    -78,   2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568,   -240,   -240, &
                 -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,    408,   -456,  -2724,    408,   -240,   -456]
  K1( 440,:) = [   -348,    624,   -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300, &
                    30,   -348,    -78,    -78,   -456,   2568,   3432,    300,   3324,    -78,    -78,    408,   -456,    300, &
                 -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240,    408,   -456, &
                   408,   -456,   -456,    -78,    -78,     30,   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432, &
                   408,    624,   -240,   -348,    408,   -456,  -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300, &
                  -456,   2568,    300,   -456,  -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324,   -240,  -1104, &
                  -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -456,     30,    300,    -78,   -348,    -78]
  K1( 441,:) = [   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78, &
                  -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    408,    -78,     30, &
                  -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456,  -2724,    408,   -240,   -456, &
                  -240,   -348,   -456,     30,   -348,    -78,   2568,   -456,   3324,    -78,   3432,    300,   -456,    408, &
                  3432,   -240,    624,   -348,    -78,    -78,    300,   -456,   -348,     30,   -240,   -456,   -348,   -348, &
                    30,    -78,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300, &
                   300,    300,  -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568,   -240,   -240, &
                  -348,   -456,   -456,   -240,    408,  -2724,   -456,    408]
  K1( 442,:) = [   -456,   3432,    408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408, &
                   408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240,     30,   -456,    -78,   -348, &
                  -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240,    408,  -2724,   -456,    408, &
                  -456,    -78,    408,   -456,     30,    -78,   -348,   -348,    -78,     30,   -240,   -456,   -348,    624, &
                  -240,   3432,    408,   -456,     30,   -348,   -456,    300,    -78,    -78,   3432,    300,   -456,   2568, &
                   -78,   3324,    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724, &
                   -78,   -456,    408,  -2724,    300,    300,   3324,   2568,    -78,    300,   -456,   3432,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,    -78,   -348,    -78,    300,     30,   -456]
  K1( 443,:) = [     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300, &
                   -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348,    -78,   -456,     30,    -78, &
                   408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408,   -240,   -456,  -2724,    408, &
                 -2724,    300,    408,    -78,    300,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240, &
                   624,    408,   3432,   -456,   -456,   -240,    408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240, &
                  -348,   -456,    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724, &
                  2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,   -456,   2568, &
                  3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456,   -348,   -348, &
                    30,    -78,    -78,    -78,    300,   -456,   -348,     30]
  K1( 444,:) = [   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724, &
                  -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   -348,   -240,   -348,    -78, &
                  -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456,   -456,    408,    408,  -2724, &
                   408,    -78,  -2724,    300,   -456,    300,   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348, &
                  -348,   -456,   -456,   2568,    -78,   -348,    -78,    300,     30,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846, &
                  3324,   2568,    -78,    300,   -456,   3432,    -78,   -456,    408,  -2724,    300,    300,   -348,   -348, &
                  -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300,   -456,   2568, &
                   -78,   3324,     30,   -348,   -456,    300,    -78,    -78]
  K1( 445,:) = [   2568,   -456,   3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78, &
                   300,   -456,   -348,     30,   -240,   -456,   -348,   -348,     30,    -78,  -1104,   -240,   2568,   -348, &
                  -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30,    300,    -78,   -348,    -78, &
                 -1104,   2568,   2568,   -456,   -456,    300,    300,  -2724,    300,   -456,    408,    -78,   -456,    408, &
                   -78,     30,   -456,    -78,  -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348, &
                   -78,   -348,    300,    300,  -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324, &
                 21846,  -2724,  -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568,    300,   -456,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348, &
                   408,    624,   -456,    408,   -240,   -456,  -2724,    408]
  K1( 446,:) = [   -348,   -348,    -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348, &
                  -456,    300,    -78,    -78,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456,  -2724,    408,   -240,   -456, &
                  1056,  -1104,  -1104,   -240,   -240,   3432,    -78,    408,   -456,    300,  -2724,    300,     30,   -456, &
                   -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240,    408,   -456,    408,   -456,   -456,    -78, &
                   -78,     30,    -78,   -456,    408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568, &
                 -2724,  21846,    300,   3432,  -2724,    300,   -456,   3432,   2568,   3324,    300,    -78,   -240,   -456, &
                  -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568,   -348,     30, &
                  -456,   -348,     30,   -456,   -348,    -78,    300,    -78]
  K1( 447,:) = [  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30, &
                   300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   -456,   3324,    -78, &
                  3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78,    300,   -456,   -348,     30, &
                  -240,   -456,   -348,   -348,     30,    -78,   -456,    408,    -78,     30,   -456,    -78,    300,  -2724, &
                   300,   -456,    408,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,   3432,   -456,    300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78, &
                 -2724,    300,  21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456,   -456,    300,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456, &
                   624,    408,   -240,   -456,   -456,    408,    408,  -2724]
  K1( 448,:) = [   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456, &
                 -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   -348,   -348,    -78,     30, &
                  -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348,   -456,    300,    -78,    -78, &
                  3432,    300,   -456,   2568,    -78,   3324,     30,   -456,    -78,   -348,   -240,   -348,    -78,    408, &
                  -456,    300,  -2724,    300,   -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456, &
                    30,    -78,   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300, &
                   300,   3432,  -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568, &
                  -348,   -456,   -348,    -78,     30,   -456,    -78,    300]
  K1( 449,:) = [   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348, &
                   -78,    300,     30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240,    408,  -2724,   -456,    408, &
                 -1104,   2568,   -240,   -240,   -348,   -456,    -78,   -456,     30,    -78,    408,   -456,   -348,   -240, &
                  -348,    -78,   -456,     30,   -456,    408,   -240,   -456,  -2724,    408,  -2724,    300,    408,    -78, &
                   300,   -456,   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456, &
                   300,  -2724,   3432,    300,  21846,  -2724,    300,    300,   -456,    -78,  -2724,    408,   3432,    300, &
                  -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456,    624,   -348, &
                  3432,   -240,    -78,    -78,   -348,     30,    300,   -456]
  K1( 450,:) = [   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240, &
                   408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   -456,   2568,    300,   -456, &
                 -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348,    -78,    300,     30,   -456, &
                  -240,   -456,   -240,  -1104,   -348,   2568,   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456, &
                    30,    -78,    408,   -456,   -240,   -456,   -456,    408,    408,  -2724,    408,    -78,  -2724,    300, &
                  -456,    300,   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432, &
                  3432,    300,    300,  -2724,  -2724,  21846,   -456,    -78,    300,    300,    408,  -2724,   -240,   -456, &
                  -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348,    408,   -456, &
                  -240,   3432,   -348,     30,    -78,    -78,   -456,    300]
  K1( 451,:) = [    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78, &
                  -348,     30,    300,   -456,    408,   -456,    624,   -348,   3432,   -240,   -456,   -240,   -348,   2568, &
                  -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456,   -348,    -78,    300,    -78, &
                  -456,   2568,   -348,     30,   -456,   -348,   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348, &
                   408,    624,    300,    300,   -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78, &
                  2568,   -456,  -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    300, &
                   408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30,   -240,   -348, &
                   -78,   -348,  -2724,    408,    408,   -456,   -456,   -240]
  K1( 452,:) = [   -456,   -240,     30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30, &
                   -78,    -78,   -456,    300,    624,   -348,    408,   -456,   -240,   3432,   2568,  -1104,   -348,   -456, &
                  -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456,  -2724,    408, &
                  3432,   -456,   -240,   -348,    408,    624,   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104, &
                  -456,    300,   2568,   -456,     30,   -456,   -348,    -78,    300,    -78,   -456,   2568,   -348,     30, &
                  -456,   -348,   -456,    -78,    300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456, &
                  -456,   3432,   2568,   3324,    300,    -78,  -2724,  21846,    300,   3432,  -2724,    300,    408,    -78, &
                 -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456,   -456,    -78, &
                   -78,     30,    408,  -2724,   -456,   -240,    408,   -456]
  K1( 453,:) = [   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456, &
                  -348,    -78,    300,    -78,   -456,   2568,   -348,     30,   -456,   -348,    300,   3432,    -78,   3324, &
                  -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78,   -348,     30,    300,   -456, &
                   408,   -456,    624,   -348,   3432,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104, &
                  -348,   -456,   -240,   -240,   -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456, &
                   624,    408,   -456,   3432,   2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408, &
                 -1104,   2568,   2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724,   3432,    300,    408,   -456, &
                  -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,    408,   -456,  -2724,    408,   -240,   -456]
  K1( 454,:) = [   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348,    408,    624,   -456,   -240,     30,    -78, &
                  -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30,    -78,    -78,   -456,    300, &
                   624,   -348,    408,   -456,   -240,   3432,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240, &
                  -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456,    -78,    300,   -348,     30,   -456,   2568, &
                  -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724, &
                  2568,   3324,   -456,   3432,    -78,    300,    300,   3432,  -2724,  21846,    300,  -2724,   -456,     30, &
                  -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78,    408,   -456, &
                    30,    -78,   -456,   -240,    408,  -2724,   -456,    408]
  K1( 455,:) = [   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78, &
                    30,   -456,    -78,    300,   -348,     30,   -456,   2568,   -348,   -456,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456,   -456,    408,    408,  -2724, &
                  -240,   -348,   3432,   -456,    624,    408,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240, &
                    30,    -78,   -348,   -348,    -78,    -78,   -348,     30,    300,   -456,    408,   -456,    624,   -348, &
                  3432,   -240,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300, &
                   300,    300,   -456,    -78,  -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724,   -456,    -78, &
                   408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300,    408,    -78, &
                   300,   -456,   -456,    408,   -240,   -456,  -2724,    408]
  K1( 456,:) = [  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456, &
                  -456,    408,    408,  -2724,   -240,   -348,   3432,   -456,    624,    408,   2568,  -1104,   -456,    300, &
                  2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456,    -78,    300, &
                  -348,     30,   -456,   2568,   -348,   -456,   -456,   -240,     30,    -78,   -348,   -348,    300,   3432, &
                   -78,   3324,   -456,   2568,   -348,     30,    -78,    -78,   -456,    300,    624,   -348,    408,   -456, &
                  -240,   3432,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300, &
                  -456,    -78,    300,    300,    408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846,   -240,   -348, &
                  -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78,  -2724,    300, &
                  -456,    300,   -240,   -456,   -456,    408,    408,  -2724]
  K1( 457,:) = [  -2724,    300,    408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30, &
                  -240,   -348,    -78,   -348,  -2724,    408,    408,   -456,   -456,   -240,    408,   -456,    624,   -348, &
                  3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348,   -240,   -456,    -78,     30, &
                   300,   -456,    -78,    -78,     30,   -348,   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104, &
                  -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568,    300,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   3432,   -456,   -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348, &
                 -1104,   -240,   1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456,   -456,   -240,  21846,  -2724, &
                 -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78,   3432,   -456, &
                  3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104]
  K1( 458,:) = [    408,    -78,  -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456, &
                  -456,    -78,    -78,     30,    408,  -2724,   -456,   -240,    408,   -456,    624,   -348,    408,   -456, &
                  -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568,   3432,    300,   3324,    -78, &
                  -456,    300,     30,   -348,    -78,    -78,   3432,   -456,   -240,   -348,    408,    624,   -240,   -240, &
                 -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456, &
                  -456,   -240,   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348, &
                  2568,   -456,  -1104,   2568,    300,   -456,    300,    -78,   -456,     30,    -78,   -348,  -2724,  21846, &
                   300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568]
  K1( 459,:) = [    408,   -456,   -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348, &
                  -456,     30,   -348,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -456,   2568,   -348,     30, &
                  -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568,    300,   -456, &
                   300,    -78,   -456,     30,    -78,   -348,    408,   -456,    624,   -348,   3432,   -240,   -456,   2568, &
                  3432,    300,   3324,    -78,   -348,   -348,   -240,   -456,    -78,     30,    300,   -456,    -78,    -78, &
                    30,   -348,   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240, &
                  -240,   -240,  -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240,    408,   -456,  -2724,    300, &
                 21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408,    300,    300, &
                   -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568]
  K1( 460,:) = [   -456,     30,   -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78, &
                   408,   -456,     30,    -78,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -456,   -240,   -348, &
                   408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104,   3432,   -240, &
                 -2724,    408,    408,   -456,   -456,   -240,    624,   -348,    408,   -456,   -240,   3432,   -348,   -348, &
                  -240,   -456,    -78,     30,   -456,   2568,   3432,    300,   3324,    -78,   -456,    300,     30,   -348, &
                   -78,    -78,   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456, &
                  -240,  -1104,   -240,   -456,   2568,   -348,    -78,    300,    -78,   -348,   -456,     30,    300,   3432, &
                 -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456, &
                   300,    300,    -78,    300,   3324,   2568,   3432,   -456]
  K1( 461,:) = [   -456,    -78,    408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300, &
                   408,    -78,    300,   -456,   -456,    408,   -240,   -456,  -2724,    408,   -348,     30,   -456,   2568, &
                  -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456,   2568,   -348, &
                   -78,    300,    -78,   -348,   -456,     30,   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240, &
                   408,   -456,    408,   -456,    624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78, &
                  -348,   -348,   -240,   -456,    -78,     30,    300,   -456,    -78,    -78,     30,   -348,    300,  -2724, &
                  3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,  -2724,    408,    300,    300,    -78,   -456]
  K1( 462,:) = [   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78, &
                 -2724,    300,   -456,    300,   -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456, &
                   624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568,   -456,   -348, &
                   408,  -2724,   -456,   -240,    408,   -456,   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456,   2568,   -348,    -78,    300,    -78,   -348, &
                  -456,     30,    624,   -348,    408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30, &
                  -456,   2568,   3432,    300,   3324,    -78,   -456,    300,     30,   -348,    -78,    -78,   3432,    300, &
                   300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568, &
                  3432,   -456,    408,  -2724,    -78,   -456,    300,    300]
  K1( 463,:) = [    408,   -456,    624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348, &
                  -240,   -456,    -78,     30,    300,   -456,    -78,    -78,     30,   -348,  -2724,    300,    408,    -78, &
                   300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30,   -240,   -348,    -78,   -348, &
                 -2724,    408,    408,   -456,   -456,   -240,   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568, &
                  -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78, &
                  -348,    -78,   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624, &
                  1056,  -1104,  -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408,   -240,   -456,  -2724,    408, &
                   300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456,    300,    -78, &
                  2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568]
  K1( 464,:) = [    624,   -348,    408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568, &
                  3432,    300,   3324,    -78,   -456,    300,     30,   -348,    -78,    -78,    408,    -78,  -2724,    300, &
                  -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456,   -456,    -78,    -78,     30, &
                   408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456, &
                  -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408, &
                  -240,   -456,   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348, &
                 -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78,   -348,    -78,    408,  -2724, &
                   -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568,    300,   -456, &
                 -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324]
  K1( 465,:) = [   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456, &
                 -1104,   2568,    300,   -456,    300,    -78,   -456,     30,    -78,   -348,    408,   -456,   -456,    -78, &
                   -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348,   -456,     30,   -348,    -78, &
                   408,   -456,  -2724,    408,   -240,   -456,   -456,   2568,   3432,    300,   3324,    -78,    408,   -456, &
                   624,   -348,   3432,   -240,   -240,   -456,   -348,   -348,     30,    -78,    -78,    -78,    300,   -456, &
                  -348,     30,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408, &
                 -1104,   2568,   -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724,   -456,    408,    300,    -78, &
                  3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300,  -2724,    408, &
                  -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456]
  K1( 466,:) = [   3432,   -456,   -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348, &
                   -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78,    408,   -456,     30,    -78, &
                  -456,   -240,    408,  -2724,   -456,    408,   -348,   -348,   -240,   -456,    -78,     30,    624,   -348, &
                   408,   -456,   -240,   3432,   3432,    300,   -456,   2568,    -78,   3324,     30,   -348,   -456,    300, &
                   -78,    -78,   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456, &
                  -240,   -456,   -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300,     30,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724, &
                   300,    300,   3324,   2568,    -78,    300,   -456,   3432]
  K1( 467,:) = [   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104, &
                  -240,   -456,   2568,   -348,    -78,    300,    -78,   -348,   -456,     30,   -456,    -78,    408,   -456, &
                    30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456, &
                  -456,    408,   -240,   -456,  -2724,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348, &
                  3432,   -456,    624,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,   -456,   2568,   3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240, &
                  -240,   -456,   -348,   -348,     30,    -78,    -78,    -78,    300,   -456,   -348,     30,    -78,    300, &
                  3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300, &
                  2568,   -456,    300,    300,  -2724,    408,   -456,    -78]
  K1( 468,:) = [   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240, &
                 -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240,    408,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78,  -2724,    300,   -456,    300, &
                  -240,   -456,   -456,    408,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30, &
                  -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300, &
                    30,   -456,   -348,   -348,   -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432, &
                  3432,    300,   -456,   2568,    -78,   3324,     30,   -348,   -456,    300,    -78,    -78,   -456,    300, &
                  2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300, &
                  -456,   3432,    -78,   -456,    408,  -2724,    300,    300]
  K1( 469,:) = [   -456,   2568,   3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456, &
                  -348,   -348,     30,    -78,    -78,    -78,    300,   -456,   -348,     30,   -240,  -1104,   -240,   -456, &
                  2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456,   -456,    300, &
                  -456,     30,    300,    -78,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456,    408,   -456, &
                  -456,    -78,    -78,     30,   -456,     30,   -240,   -348,    -78,   -348,  -2724,    408,    408,   -456, &
                  -456,   -240,  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432, &
                  3432,   -456,   -240,   -348,    408,    624,   -456,    408,   -240,   -456,  -2724,    408,    300,    300, &
                 -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300, &
                   300,   3432,   2568,   -456,  -1104,   2568,    300,   -456]
  K1( 470,:) = [   -348,   -348,   -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300, &
                  -456,   2568,    -78,   3324,     30,   -348,   -456,    300,    -78,    -78,   -240,   -240,  -1104,   2568, &
                  -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240,   -240,   3432, &
                   408,   -456,  -2724,    408,   -240,   -456,    408,    -78,  -2724,    300,   -456,    300,   -456,     30, &
                  -240,   -348,    -78,   -348,    408,   -456,   -456,    -78,    -78,     30,    408,  -2724,   -456,   -240, &
                   408,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300, &
                  -456,   2568,   -348,     30,   -456,   -348,     30,   -456,   -348,    -78,    300,    -78,    -78,   -456, &
                   408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432, &
                 -2724,    300,   -456,   3432,   2568,   3324,    300,    -78]
  K1( 471,:) = [   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -456,     30,    300,    -78,   -348,    -78,   -456,   2568,   3432,    300, &
                  3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456,   -348,   -348,     30,    -78, &
                   -78,    -78,    300,   -456,   -348,     30,    408,   -456,   -456,    -78,    -78,     30,  -2724,    300, &
                   408,    -78,    300,   -456,   -240,   -348,   -456,     30,   -348,    -78,    408,   -456,  -2724,    408, &
                  -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456, &
                  -240,   -348,   3432,   -456,    624,    408,   -240,   -456,   -456,    408,    408,  -2724,   3432,   -456, &
                   300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724, &
                  3432,    300,  -1104,   2568,   2568,   -456,   -456,    300]
  K1( 472,:) = [   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408,   -240,   -456,   -348,   -348,   -240,   -456, &
                   -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300,   -456,   2568,    -78,   3324, &
                    30,   -348,   -456,    300,    -78,    -78,   -456,     30,   -240,   -348,    -78,   -348,    408,    -78, &
                 -2724,    300,   -456,    300,   -456,    -78,    408,   -456,     30,    -78,   -456,   -240,    408,  -2724, &
                  -456,    408,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568, &
                  -348,     30,   -456,   2568,   -348,   -456,   -348,    -78,     30,   -456,    -78,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432,  -2724,  21846, &
                   300,  -2724,   2568,   3324,   -456,   3432,    -78,    300]
  K1( 473,:) = [   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456, &
                  -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300,     30,   -456,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568,   -240,   -240,   -348,   -456, &
                  -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   -240,   -348, &
                  -456,     30,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456,   -456,    408,   -240,   -456, &
                 -2724,    408,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78, &
                   408,   -456,    624,   -348,   3432,   -240,    -78,    -78,   -348,     30,    300,   -456,   3324,   2568, &
                   -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724,   3432,    300, &
                 21846,  -2724,    300,    300,   -456,    -78,  -2724,    408]
  K1( 474,:) = [  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724,   -456,    408,   2568,   -456,  -1104,   2568, &
                   300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104,   -348,   2568, &
                   -78,   -348,    -78,    300,     30,   -456,   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78, &
                   408,   -456,     30,    -78,    408,    -78,  -2724,    300,   -456,    300,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   -456,   -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324, &
                   624,   -348,    408,   -456,   -240,   3432,   -348,     30,    -78,    -78,   -456,    300,   2568,  -1104, &
                  -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,    -78,    300,    300,    408,  -2724]
  K1( 475,:) = [   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456, &
                   624,   -348,   3432,   -240,    -78,    -78,   -348,     30,    300,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568,   -348,     30,   -456,   -348, &
                    30,   -456,   -348,    -78,    300,    -78,  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348,    408,    624,   -456,    408,   -240,   -456, &
                 -2724,    408,  -2724,    300,    408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30, &
                  -456,     30,   -240,   -348,    -78,   -348,  -2724,    408,    408,   -456,   -456,   -240,    300,    300, &
                  -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568, &
                   300,   -456,  21846,  -2724,  -2724,    300,    300,   3432]
  K1( 476,:) = [   -240,   -456,   -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348, &
                   408,   -456,   -240,   3432,   -348,     30,    -78,    -78,   -456,    300,  -1104,   2568,   -240,   -240, &
                  -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348,    408,    624, &
                  -456,    408,   -240,   -456,  -2724,    408,   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -456,   2568,   -348,     30,   -456,   -348,     30,   -456,   -348,    -78, &
                   300,    -78,    408,    -78,  -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348, &
                   408,   -456,   -456,    -78,    -78,     30,    408,  -2724,   -456,   -240,    408,   -456,   -456,    -78, &
                   300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324, &
                   300,    -78,  -2724,  21846,    300,   3432,  -2724,    300]
  K1( 477,:) = [   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568, &
                  -348,     30,   -456,   -348,     30,   -456,   -348,    -78,    300,    -78,   3432,    300,   -456,   2568, &
                   -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456,    624,   -348,   3432,   -240, &
                   -78,    -78,   -348,     30,    300,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456,    624,    408,   -240,   -456,   -456,    408, &
                   408,  -2724,    408,   -456,   -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456, &
                  -240,   -348,   -456,     30,   -348,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432, &
                  2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456, &
                  -456,    300,  -2724,    300,  21846,  -2724,   3432,    300]
  K1( 478,:) = [  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456, &
                  -240,   -348,    408,    624,   -456,    408,   -240,   -456,  -2724,    408,   -240,   -456,   -348,   -348, &
                    30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348,    408,   -456,   -240,   3432, &
                  -348,     30,    -78,    -78,   -456,    300,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456, &
                  -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568,   -348,   -456,   -348,    -78,     30,   -456, &
                   -78,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300, &
                  -456,    -78,    408,   -456,     30,    -78,   -456,   -240,    408,  -2724,   -456,    408,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324,   -456,   3432, &
                   -78,    300,    300,   3432,  -2724,  21846,    300,  -2724]
  K1( 479,:) = [  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30, &
                  -456,   2568,   -348,   -456,   -348,    -78,     30,   -456,    -78,    300,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456,    624,    408, &
                  -240,   -456,   -456,    408,    408,  -2724,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456, &
                  -348,   -348,     30,    -78,    408,   -456,    624,   -348,   3432,   -240,    -78,    -78,   -348,     30, &
                   300,   -456,   -456,    -78,    408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78, &
                 -2724,    300,    408,    -78,    300,   -456,   -456,    408,   -240,   -456,  -2724,    408,   2568,   3324, &
                  -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300,   -456,    -78, &
                 -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724]
  K1( 480,:) = [   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348, &
                  3432,   -456,    624,    408,   -240,   -456,   -456,    408,    408,  -2724,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568,   -348,   -456, &
                  -348,    -78,     30,   -456,    -78,    300,   -240,   -456,   -348,   -348,     30,    -78,   3432,    300, &
                  -456,   2568,    -78,   3324,    624,   -348,    408,   -456,   -240,   3432,   -348,     30,    -78,    -78, &
                  -456,    300,   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78, &
                   408,    -78,  -2724,    300,   -456,    300,   -240,   -456,   -456,    408,    408,  -2724,  -1104,   2568, &
                  2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78,    300,    300, &
                   408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846]
  K1( 481,:) = [   1560,     48,     48,  -1464,  -1464,    912,   -168,    264,     48,     21,   -195,    210,   -168,     21, &
                   480,    210,   1749,  -1302,   1533,   -222,     -6,  -1302,     -6,    588,   1533,   -222,   -222,    210, &
                   210,    156,   -168,    264,   -168,   1533,     21,   -222,     21,    -33,    264,   -222,    210,    210, &
                   210,    156,    -33,    210,    156,    156,   1533,   -222,   -195,     21,     48,    210,   1560,     48, &
                  -141,   -141,   -195,    534,   1749,     21,   1344,   -357,     21,   3072,   -195,    -33,   -114,   -114, &
                   210,   -384,   -168,     21,     -6,    -33,   -195,    156,   -141,   -195,   -141,   -141,     48,   -195, &
                    -6,    210,   -168,    318,    210,   -384,     48,    399,   -357,   1344,  -1302,     48,   -168,    264, &
                    -6,    399,     -6,    102,   -141,    534,   -141,   1560,   -195,     48,     -6,    156,   -168,   -168, &
                 -1302,     48,    480,    102,    318,   -168,    588,    480]
  K1( 482,:) = [     48,   1560,  -1464,    912,     48,  -1464,    264,   -168,   -195,    210,     48,     21,   1533,   -222, &
                    -6,  -1302,     -6,    588,   -168,     21,    480,    210,   1749,  -1302,   -222,   1533,    210,    156, &
                  -222,    210,    264,   -168,     21,   -222,   -168,   1533,    210,    156,    -33,    210,    156,    156, &
                    21,    -33,    264,   -222,    210,    210,   -222,   1533,     48,    210,   -195,     21,     48,   1560, &
                  -195,    534,   -141,   -141,   -195,    -33,   -114,   -114,    210,   -384,   1749,     21,   1344,   -357, &
                    21,   3072,   -168,    264,     -6,    399,     -6,    102,   -141,    534,   -141,   1560,   -195,     48, &
                    -6,    156,   -168,   -168,  -1302,     48,    480,    102,    318,   -168,    588,    480,   -168,     21, &
                    -6,    -33,   -195,    156,   -141,   -195,   -141,   -141,     48,   -195,     -6,    210,   -168,    318, &
                   210,   -384,     48,    399,   -357,   1344,  -1302,     48]
  K1( 483,:) = [     48,  -1464,   1560,     48,    912,  -1464,   -168,     21,    480,    210,   1749,  -1302,   -168,    264, &
                    48,     21,   -195,    210,   -222,   1533,     -6,    588,     -6,  -1302,   -222,    210,   1533,   -222, &
                   156,    210,     21,    -33,    264,   -222,    210,    210,   -168,    264,   -168,   1533,     21,   -222, &
                   156,    210,    156,    156,    -33,    210,   -168,     21,     -6,    -33,   -195,    156,   -141,   -195, &
                  -141,   -141,     48,   -195,     -6,    210,   -168,    318,    210,   -384,     48,    399,   -357,   1344, &
                 -1302,     48,   1533,   -222,   -195,     21,     48,    210,   1560,     48,   -141,   -141,   -195,    534, &
                  1749,     21,   1344,   -357,     21,   3072,   -195,    -33,   -114,   -114,    210,   -384,    264,   -168, &
                    -6,    102,     -6,    399,    534,   -141,   -195,     48,   -141,   1560,    480,    102,    318,   -168, &
                   588,    480,     -6,    156,   -168,   -168,  -1302,     48]
  K1( 484,:) = [  -1464,    912,     48,   1560,  -1464,     48,   1533,   -222,     -6,  -1302,     -6,    588,    264,   -168, &
                  -195,    210,     48,     21,     21,   -168,   1749,  -1302,    480,    210,    210,    156,   -222,   1533, &
                   210,   -222,    210,    156,    -33,    210,    156,    156,    264,   -168,     21,   -222,   -168,   1533, &
                   -33,     21,    210,    210,    264,   -222,   -168,    264,     -6,    399,     -6,    102,   -141,    534, &
                  -141,   1560,   -195,     48,     -6,    156,   -168,   -168,  -1302,     48,    480,    102,    318,   -168, &
                   588,    480,   -222,   1533,     48,    210,   -195,     21,     48,   1560,   -195,    534,   -141,   -141, &
                  -195,    -33,   -114,   -114,    210,   -384,   1749,     21,   1344,   -357,     21,   3072,     21,   -168, &
                  -195,    156,     -6,    -33,   -195,   -141,     48,   -195,   -141,   -141,     48,    399,   -357,   1344, &
                 -1302,     48,     -6,    210,   -168,    318,    210,   -384]
  K1( 485,:) = [  -1464,     48,    912,  -1464,   1560,     48,     21,   -168,   1749,  -1302,    480,    210,   -222,   1533, &
                    -6,    588,     -6,  -1302,   -168,    264,     48,     21,   -195,    210,    210,   -222,    156,    210, &
                  1533,   -222,    -33,     21,    210,    210,    264,   -222,    156,    210,    156,    156,    -33,    210, &
                  -168,    264,   -168,   1533,     21,   -222,     21,   -168,   -195,    156,     -6,    -33,   -195,   -141, &
                    48,   -195,   -141,   -141,     48,    399,   -357,   1344,  -1302,     48,     -6,    210,   -168,    318, &
                   210,   -384,    264,   -168,     -6,    102,     -6,    399,    534,   -141,   -195,     48,   -141,   1560, &
                   480,    102,    318,   -168,    588,    480,     -6,    156,   -168,   -168,  -1302,     48,   1533,   -222, &
                  -195,     21,     48,    210,   1560,     48,   -141,   -141,   -195,    534,   1749,     21,   1344,   -357, &
                    21,   3072,   -195,    -33,   -114,   -114,    210,   -384]
  K1( 486,:) = [    912,  -1464,  -1464,     48,     48,   1560,   -222,   1533,     -6,    588,     -6,  -1302,     21,   -168, &
                  1749,  -1302,    480,    210,    264,   -168,   -195,    210,     48,     21,    156,    210,    210,   -222, &
                  -222,   1533,    156,    210,    156,    156,    -33,    210,    -33,     21,    210,    210,    264,   -222, &
                   264,   -168,     21,   -222,   -168,   1533,    264,   -168,     -6,    102,     -6,    399,    534,   -141, &
                  -195,     48,   -141,   1560,    480,    102,    318,   -168,    588,    480,     -6,    156,   -168,   -168, &
                 -1302,     48,     21,   -168,   -195,    156,     -6,    -33,   -195,   -141,     48,   -195,   -141,   -141, &
                    48,    399,   -357,   1344,  -1302,     48,     -6,    210,   -168,    318,    210,   -384,   -222,   1533, &
                    48,    210,   -195,     21,     48,   1560,   -195,    534,   -141,   -141,   -195,    -33,   -114,   -114, &
                   210,   -384,   1749,     21,   1344,   -357,     21,   3072]
  K1( 487,:) = [   -168,    264,   -168,   1533,     21,   -222,   -384,  -1896,   -168,   -195,   1533,  -1950,   -384,   -384, &
                  -168,     48,   1344,  -1896,   -384,   1317,   -168,    237,   -168,  -1464,   -195,     -6,     48,   -195, &
                    -6,     -6,  -1950,    -60,    237,   -249,    183,   -546,  -1896,     48,  -1464,    237,   -195,  -1950, &
                    -6,     -6,    -60,    183,     -6,    -60,  -1896,    480,    264,     -6,   -222,    -60,   1533,   -222, &
                  -168,   -168,     21,    264,     21,     -6,   -384,    102,     -6,   -357,     21,    183,    102,   -384, &
                   -60,    318,   -384,    102,   1533,   -195,   -114,     48,   1344,   -114,   -168,   -168,   -357,    318, &
                  -222,     -6,   1317,   -384,     -6,   -114,   -357,   -195,   2640,   -816,     -6,   1344,    102,   -384, &
                  -168,   -249,   -168,    237,   -357,   -114,    318,   -168,   1344,   -168,    264,   -546,   -384,   -384, &
                   183,   -168,    318,  -1950,   -816,   -384,    -60,   -168]
  K1( 488,:) = [    264,   -168,     21,   -222,   -168,   1533,  -1896,   -384,   1533,  -1950,   -168,   -195,   -384,   1317, &
                  -168,    237,   -168,  -1464,   -384,   -384,   -168,     48,   1344,  -1896,     -6,   -195,     -6,     -6, &
                    48,   -195,    -60,  -1950,    183,   -546,    237,   -249,     -6,     -6,    -60,    183,     -6,    -60, &
                 -1896,     48,  -1464,    237,   -195,  -1950,    480,  -1896,   -222,    -60,    264,     -6,   -222,   1533, &
                    21,    264,   -168,   -168,     21,    183,    102,   -384,    -60,    318,     21,     -6,   -384,    102, &
                    -6,   -357,    102,   -384,   -168,   -249,   -168,    237,   -357,   -114,    318,   -168,   1344,   -168, &
                   264,   -546,   -384,   -384,    183,   -168,    318,  -1950,   -816,   -384,    -60,   -168,   -384,    102, &
                  1533,   -195,   -114,     48,   1344,   -114,   -168,   -168,   -357,    318,   -222,     -6,   1317,   -384, &
                    -6,   -114,   -357,   -195,   2640,   -816,     -6,   1344]
  K1( 489,:) = [     48,   -195,    480,     -6,   1749,     -6,   -168,   1533,   1560,   1533,   1560,   -168,   -168,   -168, &
                    48,   -222,   -141,     21,   1344,   -168,   -141,   -168,   -141,    264,     21,     21,    210,    -33, &
                    21,    210,    210,    210,  -1302,    399,    -33,    156,  -1302,    156,    588,    102,    399,    102, &
                    21,    210,    210,  -1302,  -1302,    588,    264,   -222,     48,   -222,     48,    264,   -195,     48, &
                    -6,     -6,   -195,     -6,  -1464,    210,   1533,   -168,    210,   -141,   -195,     21,   -114,   -168, &
                   -33,   -141,     21,     21,  -1464,    210,   -195,    -33,   1749,   -195,     -6,     -6,     48,    480, &
                   912,    156,   -222,    264,    156,    534,     48,    210,   -357,    318,    156,   -195,   -357,    318, &
                  -141,   1533,   -141,   -222,   3072,   -384,   -384,     48,     48,    480,    534,   -222,   -114,   -168, &
                   210,   1560,   -195,    210,   1344,   -168,    156,     48]
  K1( 490,:) = [     21,    210,    210,  -1302,  -1302,    588,   -195,  -1950,   1533, -12291,   -168,   1506,     48,    237, &
                  -222,   1506,   -168,     -6,  -1896,  -1464,     21,     -6,    264,  -2004,     -6,    -60,    -60,    372, &
                   372,   -168,    -60,   -600,    372,  -3084,    318,    264,    372,    318,   -168,    264,  -2652,    696, &
                 -3084,    264,    264,    696,    696,   -816,     -6,    -60,   -222,   1506,    264,   -492,     21,    210, &
                   -33,    399,    156,    102,    210,     -6,   -195,   -249,  -1518,   1533,    -33,    183,     48,    237, &
                   372,   -222,     -6,    183,    210,     -6,     21,    183,     21,    -33,    210,    156,    399,    102, &
                   156,  -2004,     -6,   -546,    372,   -222,    210,  -3030,   -195,  -1950,  -1140,    210,     -6,    -60, &
                   210,  -1518,    -33,    372,     21,    210,    210,  -1302,  -1302,    588,    156,    372,     -6,    183, &
                 -1140,    210,    156,  -1140,     -6,    -60,    264,    156]
  K1( 491,:) = [   -195,     48,   1749,     -6,    480,     -6,   1533,   -168,   1560,   -168,   1560,   1533,   1344,   -168, &
                  -141,   -168,   -141,    264,   -168,   -168,     48,   -222,   -141,     21,     21,     21,     21,    210, &
                   210,    -33,    210,    210,    -33,    156,  -1302,    399,     21,    210,    210,  -1302,  -1302,    588, &
                 -1302,    156,    588,    102,    399,    102,   -222,    264,     48,    264,     48,   -222,     48,   -195, &
                  -195,     -6,     -6,     -6,   -195,     21,   -114,   -168,    -33,   -141,  -1464,    210,   1533,   -168, &
                   210,   -141,   -357,    318,   -141,   1533,   -141,   -222,   3072,   -384,   -384,     48,     48,    480, &
                   534,   -222,   -114,   -168,    210,   1560,   -195,    210,   1344,   -168,    156,     48,     21,     21, &
                 -1464,    210,   -195,    -33,   1749,   -195,     -6,     -6,     48,    480,    912,    156,   -222,    264, &
                   156,    534,     48,    210,   -357,    318,    156,   -195]
  K1( 492,:) = [    210,     21,  -1302,    588,    210,  -1302,  -1950,   -195,   -168,   1506,   1533, -12291,  -1896,  -1464, &
                    21,     -6,    264,  -2004,     48,    237,   -222,   1506,   -168,     -6,    -60,     -6,    372,   -168, &
                   -60,    372,   -600,    -60,    318,    264,    372,  -3084,  -3084,    264,    264,    696,    696,   -816, &
                   372,    318,   -168,    264,  -2652,    696,    -60,     -6,    264,   -492,   -222,   1506,    210,     21, &
                   156,    102,    -33,    399,    -33,    183,     48,    237,    372,   -222,    210,     -6,   -195,   -249, &
                 -1518,   1533,     -6,    -60,    210,  -1518,    -33,    372,     21,    210,    210,  -1302,  -1302,    588, &
                   156,    372,     -6,    183,  -1140,    210,    156,  -1140,     -6,    -60,    264,    156,     -6,    183, &
                   210,     -6,     21,    183,     21,    -33,    210,    156,    399,    102,    156,  -2004,     -6,   -546, &
                   372,   -222,    210,  -3030,   -195,  -1950,  -1140,    210]
  K1( 493,:) = [   -168,   1533,   -168,    264,   -222,     21,   -384,   -384,   -168,     48,   1344,  -1896,   -384,  -1896, &
                  -168,   -195,   1533,  -1950,   1317,   -384,   -168,  -1464,   -168,    237,     48,   -195,   -195,     -6, &
                    -6,     -6,  -1896,     48,  -1464,    237,   -195,  -1950,  -1950,    -60,    237,   -249,    183,   -546, &
                    -6,     -6,     -6,    -60,    -60,    183,   -384,    102,   1533,   -195,   -114,     48,   1344,   -114, &
                  -168,   -168,   -357,    318,   -222,     -6,   1317,   -384,     -6,   -114,   -357,   -195,   2640,   -816, &
                    -6,   1344,  -1896,    480,    264,     -6,   -222,    -60,   1533,   -222,   -168,   -168,     21,    264, &
                    21,     -6,   -384,    102,     -6,   -357,     21,    183,    102,   -384,    -60,    318,   -384,    102, &
                  -168,    237,   -168,   -249,   -114,   -357,   1344,   -168,    318,   -168,    318,  -1950,   -816,   -384, &
                   -60,   -168,    264,   -546,   -384,   -384,    183,   -168]
  K1( 494,:) = [     21,   -222,    264,   -168,   1533,   -168,   -384,   1317,   -168,    237,   -168,  -1464,  -1896,   -384, &
                  1533,  -1950,   -168,   -195,   -384,   -384,   1344,  -1896,   -168,     48,     -6,     -6,     -6,   -195, &
                  -195,     48,     -6,     -6,    -60,    183,     -6,    -60,    -60,  -1950,    183,   -546,    237,   -249, &
                    48,  -1896,   -195,  -1950,  -1464,    237,    102,   -384,   -168,   -249,   -168,    237,   -357,   -114, &
                   318,   -168,   1344,   -168,    264,   -546,   -384,   -384,    183,   -168,    318,  -1950,   -816,   -384, &
                   -60,   -168,    480,  -1896,   -222,    -60,    264,     -6,   -222,   1533,     21,    264,   -168,   -168, &
                    21,    183,    102,   -384,    -60,    318,     21,     -6,   -384,    102,     -6,   -357,    102,   -384, &
                  -114,     48,   1533,   -195,   -114,   1344,   -357,    318,   -168,   -168,   -357,   -195,   2640,   -816, &
                    -6,   1344,   -222,     -6,   1317,   -384,     -6,   -114]
  K1( 495,:) = [    480,     -6,     48,   -195,     -6,   1749,   -168,   -168,     48,   -222,   -141,     21,   -168,   1533, &
                  1560,   1533,   1560,   -168,   -168,   1344,   -141,    264,   -141,   -168,    210,    -33,     21,     21, &
                   210,     21,  -1302,    156,    588,    102,    399,    102,    210,    210,  -1302,    399,    -33,    156, &
                   210,     21,  -1302,    588,    210,  -1302,     21,     21,  -1464,    210,   -195,    -33,   1749,   -195, &
                    -6,     -6,     48,    480,    912,    156,   -222,    264,    156,    534,     48,    210,   -357,    318, &
                   156,   -195,    264,   -222,     48,   -222,     48,    264,   -195,     48,     -6,     -6,   -195,     -6, &
                 -1464,    210,   1533,   -168,    210,   -141,   -195,     21,   -114,   -168,    -33,   -141,    318,   -357, &
                  -141,   -222,   -141,   1533,   -384,   3072,     48,    480,   -384,     48,   -195,    210,   1344,   -168, &
                   156,     48,    534,   -222,   -114,   -168,    210,   1560]
  K1( 496,:) = [    210,  -1302,     21,    210,    588,  -1302,     48,    237,   -222,   1506,   -168,     -6,   -195,  -1950, &
                  1533, -12291,   -168,   1506,  -1464,  -1896,    264,  -2004,     21,     -6,    -60,    372,     -6,    -60, &
                  -168,    372,    372,    318,   -168,    264,  -2652,    696,    -60,   -600,    372,  -3084,    318,    264, &
                   264,  -3084,    696,   -816,    264,    696,     -6,    183,    210,     -6,     21,    183,     21,    -33, &
                   210,    156,    399,    102,    156,  -2004,     -6,   -546,    372,   -222,    210,  -3030,   -195,  -1950, &
                 -1140,    210,     -6,    -60,   -222,   1506,    264,   -492,     21,    210,    -33,    399,    156,    102, &
                   210,     -6,   -195,   -249,  -1518,   1533,    -33,    183,     48,    237,    372,   -222,    -60,     -6, &
                   -33,    372,    210,  -1518,    210,     21,  -1302,    588,    210,  -1302,    156,  -1140,     -6,    -60, &
                   264,    156,    156,    372,     -6,    183,  -1140,    210]
  K1( 497,:) = [   1749,     -6,   -195,     48,     -6,    480,   1344,   -168,   -141,   -168,   -141,    264,   1533,   -168, &
                  1560,   -168,   1560,   1533,   -168,   -168,   -141,     21,     48,   -222,     21,    210,     21,     21, &
                   -33,    210,     21,    210,    210,  -1302,  -1302,    588,    210,    210,    -33,    156,  -1302,    399, &
                   156,  -1302,    399,    102,    588,    102,   -357,    318,   -141,   1533,   -141,   -222,   3072,   -384, &
                  -384,     48,     48,    480,    534,   -222,   -114,   -168,    210,   1560,   -195,    210,   1344,   -168, &
                   156,     48,   -222,    264,     48,    264,     48,   -222,     48,   -195,   -195,     -6,     -6,     -6, &
                  -195,     21,   -114,   -168,    -33,   -141,  -1464,    210,   1533,   -168,    210,   -141,     21,     21, &
                  -195,    -33,  -1464,    210,   -195,   1749,     48,    480,     -6,     -6,     48,    210,   -357,    318, &
                   156,   -195,    912,    156,   -222,    264,    156,    534]
  K1( 498,:) = [  -1302,    588,    210,     21,  -1302,    210,  -1896,  -1464,     21,     -6,    264,  -2004,  -1950,   -195, &
                  -168,   1506,   1533, -12291,    237,     48,   -168,     -6,   -222,   1506,    372,   -168,    -60,     -6, &
                   372,    -60,  -3084,    264,    264,    696,    696,   -816,   -600,    -60,    318,    264,    372,  -3084, &
                   318,    372,  -2652,    696,   -168,    264,     -6,    -60,    210,  -1518,    -33,    372,     21,    210, &
                   210,  -1302,  -1302,    588,    156,    372,     -6,    183,  -1140,    210,    156,  -1140,     -6,    -60, &
                   264,    156,    -60,     -6,    264,   -492,   -222,   1506,    210,     21,    156,    102,    -33,    399, &
                   -33,    183,     48,    237,    372,   -222,    210,     -6,   -195,   -249,  -1518,   1533,    183,     -6, &
                    21,    183,    210,     -6,    -33,     21,    399,    102,    210,    156,    210,  -3030,   -195,  -1950, &
                 -1140,    210,    156,  -2004,     -6,   -546,    372,   -222]
  K1( 499,:) = [   1533,   -168,   -222,     21,   -168,    264,   -384,   -384,   1344,  -1896,   -168,     48,   1317,   -384, &
                  -168,  -1464,   -168,    237,   -384,  -1896,   -168,   -195,   1533,  -1950,   -195,     48,     -6,     -6, &
                  -195,     -6,     48,  -1896,   -195,  -1950,  -1464,    237,     -6,     -6,     -6,    -60,    -60,    183, &
                 -1950,    -60,    237,   -249,    183,   -546,    102,   -384,   -114,     48,   1533,   -195,   -114,   1344, &
                  -357,    318,   -168,   -168,   -357,   -195,   2640,   -816,     -6,   1344,   -222,     -6,   1317,   -384, &
                    -6,   -114,   -384,    102,   -168,    237,   -168,   -249,   -114,   -357,   1344,   -168,    318,   -168, &
                   318,  -1950,   -816,   -384,    -60,   -168,    264,   -546,   -384,   -384,    183,   -168,  -1896,    480, &
                   264,     -6,   -222,    -60,   1533,   -222,   -168,   -168,     21,    264,     21,     -6,   -384,    102, &
                    -6,   -357,     21,    183,    102,   -384,    -60,    318]
  K1( 500,:) = [   -222,     21,   1533,   -168,    264,   -168,   1317,   -384,   -168,  -1464,   -168,    237,   -384,   -384, &
                  1344,  -1896,   -168,     48,  -1896,   -384,   1533,  -1950,   -168,   -195,     -6,     -6,   -195,     48, &
                    -6,   -195,     -6,     -6,     -6,    -60,    -60,    183,     48,  -1896,   -195,  -1950,  -1464,    237, &
                   -60,  -1950,    183,   -546,    237,   -249,   -384,    102,   -168,    237,   -168,   -249,   -114,   -357, &
                  1344,   -168,    318,   -168,    318,  -1950,   -816,   -384,    -60,   -168,    264,   -546,   -384,   -384, &
                   183,   -168,    102,   -384,   -114,     48,   1533,   -195,   -114,   1344,   -357,    318,   -168,   -168, &
                  -357,   -195,   2640,   -816,     -6,   1344,   -222,     -6,   1317,   -384,     -6,   -114,    480,  -1896, &
                  -222,    -60,    264,     -6,   -222,   1533,     21,    264,   -168,   -168,     21,    183,    102,   -384, &
                   -60,    318,     21,     -6,   -384,    102,     -6,   -357]
  K1( 501,:) = [     -6,    480,     -6,   1749,     48,   -195,   -168,   -168,   -141,     21,     48,   -222,   -168,   1344, &
                  -141,    264,   -141,   -168,   -168,   1533,   1560,   1533,   1560,   -168,    -33,    210,    210,     21, &
                    21,     21,    156,  -1302,    399,    102,    588,    102,    210,     21,  -1302,    588,    210,  -1302, &
                   210,    210,  -1302,    399,    -33,    156,     21,     21,   -195,    -33,  -1464,    210,   -195,   1749, &
                    48,    480,     -6,     -6,     48,    210,   -357,    318,    156,   -195,    912,    156,   -222,    264, &
                   156,    534,    318,   -357,   -141,   -222,   -141,   1533,   -384,   3072,     48,    480,   -384,     48, &
                  -195,    210,   1344,   -168,    156,     48,    534,   -222,   -114,   -168,    210,   1560,    264,   -222, &
                    48,   -222,     48,    264,   -195,     48,     -6,     -6,   -195,     -6,  -1464,    210,   1533,   -168, &
                   210,   -141,   -195,     21,   -114,   -168,    -33,   -141]
  K1( 502,:) = [  -1302,    210,    588,  -1302,     21,    210,    237,     48,   -168,     -6,   -222,   1506,  -1464,  -1896, &
                   264,  -2004,     21,     -6,   -195,  -1950,   1533, -12291,   -168,   1506,    372,    -60,   -168,    372, &
                    -6,    -60,    318,    372,  -2652,    696,   -168,    264,    264,  -3084,    696,   -816,    264,    696, &
                   -60,   -600,    372,  -3084,    318,    264,    183,     -6,     21,    183,    210,     -6,    -33,     21, &
                   399,    102,    210,    156,    210,  -3030,   -195,  -1950,  -1140,    210,    156,  -2004,     -6,   -546, &
                   372,   -222,    -60,     -6,    -33,    372,    210,  -1518,    210,     21,  -1302,    588,    210,  -1302, &
                   156,  -1140,     -6,    -60,    264,    156,    156,    372,     -6,    183,  -1140,    210,     -6,    -60, &
                  -222,   1506,    264,   -492,     21,    210,    -33,    399,    156,    102,    210,     -6,   -195,   -249, &
                 -1518,   1533,    -33,    183,     48,    237,    372,   -222]
  K1( 503,:) = [     -6,   1749,     -6,    480,   -195,     48,   -168,   1344,   -141,    264,   -141,   -168,   -168,   -168, &
                  -141,     21,     48,   -222,   1533,   -168,   1560,   -168,   1560,   1533,    210,     21,    -33,    210, &
                    21,     21,    210,     21,  -1302,    588,    210,  -1302,    156,  -1302,    399,    102,    588,    102, &
                   210,    210,    -33,    156,  -1302,    399,    318,   -357,   -141,   -222,   -141,   1533,   -384,   3072, &
                    48,    480,   -384,     48,   -195,    210,   1344,   -168,    156,     48,    534,   -222,   -114,   -168, &
                   210,   1560,     21,     21,   -195,    -33,  -1464,    210,   -195,   1749,     48,    480,     -6,     -6, &
                    48,    210,   -357,    318,    156,   -195,    912,    156,   -222,    264,    156,    534,   -222,    264, &
                    48,    264,     48,   -222,     48,   -195,   -195,     -6,     -6,     -6,   -195,     21,   -114,   -168, &
                   -33,   -141,  -1464,    210,   1533,   -168,    210,   -141]
  K1( 504,:) = [    588,  -1302,  -1302,    210,    210,     21,  -1464,  -1896,    264,  -2004,     21,     -6,    237,     48, &
                  -168,     -6,   -222,   1506,  -1950,   -195,   -168,   1506,   1533, -12291,   -168,    372,    372,    -60, &
                   -60,     -6,    264,  -3084,    696,   -816,    264,    696,    318,    372,  -2652,    696,   -168,    264, &
                  -600,    -60,    318,    264,    372,  -3084,    -60,     -6,    -33,    372,    210,  -1518,    210,     21, &
                 -1302,    588,    210,  -1302,    156,  -1140,     -6,    -60,    264,    156,    156,    372,     -6,    183, &
                 -1140,    210,    183,     -6,     21,    183,    210,     -6,    -33,     21,    399,    102,    210,    156, &
                   210,  -3030,   -195,  -1950,  -1140,    210,    156,  -2004,     -6,   -546,    372,   -222,    -60,     -6, &
                   264,   -492,   -222,   1506,    210,     21,    156,    102,    -33,    399,    -33,    183,     48,    237, &
                   372,   -222,    210,     -6,   -195,   -249,  -1518,   1533]
  K1( 505,:) = [   1533,   -222,   -222,    210,    210,    156,   -195,     -6,     21,     -6,     21,    -60,     48,     -6, &
                   210,    -60,     21,    372,   -195,     -6,    -33,    372,    210,   -168, -12291,   1506,   1506,     -6, &
                    -6,  -2004,   1506,   -492,     -6,  -1518,    183,    372,     -6,    183,  -2004,    372,  -3030,  -1140, &
                 -1518,    372,    372,  -1140,  -1140,    264,  -1950,    -60,    210,    -60,    210,   -600,   -168,    264, &
                    21,    210,    -33,    156,  -1302,    372,  -1896,     -6,  -3084,     21,    156,    318,     48,     -6, &
                   264,    210,    237,    183,  -1302,    372,    -33,    318,   -168,     21,    264,    -33,    210,    156, &
                   588,   -168,  -1464,    -60,    264,    210,    399,  -2652,   -195,     -6,    696,  -1302,   -249,   -546, &
                   399,  -3084,    156,    264,   1533,   -222,   -222,    210,    210,    156,    102,    264,    237,    183, &
                   696,  -1302,    102,    696,  -1950,    -60,   -816,    588]
  K1( 506,:) = [   -222,   1533,    210,    156,   -222,    210,     -6,   -195,     21,    -60,     21,     -6,   -195,     -6, &
                   -33,    372,    210,   -168,     48,     -6,    210,    -60,     21,    372,   1506, -12291,     -6,  -2004, &
                  1506,     -6,   -492,   1506,    183,    372,     -6,  -1518,  -1518,    372,    372,  -1140,  -1140,    264, &
                    -6,    183,  -2004,    372,  -3030,  -1140,    -60,  -1950,    210,   -600,    210,    -60,    264,   -168, &
                   -33,    156,     21,    210,    156,    318,     48,     -6,    264,    210,  -1302,    372,  -1896,     -6, &
                 -3084,     21,   -249,   -546,    399,  -3084,    156,    264,   1533,   -222,   -222,    210,    210,    156, &
                   102,    264,    237,    183,    696,  -1302,    102,    696,  -1950,    -60,   -816,    588,    237,    183, &
                 -1302,    372,    -33,    318,   -168,     21,    264,    -33,    210,    156,    588,   -168,  -1464,    -60, &
                   264,    210,    399,  -2652,   -195,     -6,    696,  -1302]
  K1( 507,:) = [   -222,    210,   1533,   -222,    156,    210,     48,     -6,    210,    -60,     21,    372,   -195,     -6, &
                    21,     -6,     21,    -60,     -6,   -195,    210,   -168,    -33,    372,   1506,     -6, -12291,   1506, &
                 -2004,     -6,     -6,    183,  -2004,    372,  -3030,  -1140,   1506,   -492,     -6,  -1518,    183,    372, &
                   372,  -1518,  -1140,    264,    372,  -1140,    237,    183,  -1302,    372,    -33,    318,   -168,     21, &
                   264,    -33,    210,    156,    588,   -168,  -1464,    -60,    264,    210,    399,  -2652,   -195,     -6, &
                   696,  -1302,  -1950,    -60,    210,    -60,    210,   -600,   -168,    264,     21,    210,    -33,    156, &
                 -1302,    372,  -1896,     -6,  -3084,     21,    156,    318,     48,     -6,    264,    210,   -546,   -249, &
                   156,    264,    399,  -3084,   -222,   1533,    210,    156,   -222,    210,    102,    696,  -1950,    -60, &
                  -816,    588,    102,    264,    237,    183,    696,  -1302]
  K1( 508,:) = [    210,    156,   -222,   1533,    210,   -222,   -195,     -6,    -33,    372,    210,   -168,     -6,   -195, &
                    21,    -60,     21,     -6,     -6,     48,     21,    372,    210,    -60,     -6,  -2004,   1506, -12291, &
                    -6,   1506,  -1518,    372,    372,  -1140,  -1140,    264,   -492,   1506,    183,    372,     -6,  -1518, &
                   183,     -6,  -3030,  -1140,  -2004,    372,   -249,   -546,    399,  -3084,    156,    264,   1533,   -222, &
                  -222,    210,    210,    156,    102,    264,    237,    183,    696,  -1302,    102,    696,  -1950,    -60, &
                  -816,    588,    -60,  -1950,    210,   -600,    210,    -60,    264,   -168,    -33,    156,     21,    210, &
                   156,    318,     48,     -6,    264,    210,  -1302,    372,  -1896,     -6,  -3084,     21,    183,    237, &
                   -33,    318,  -1302,    372,     21,   -168,    210,    156,    264,    -33,    399,  -2652,   -195,     -6, &
                   696,  -1302,    588,   -168,  -1464,    -60,    264,    210]
  K1( 509,:) = [    210,   -222,    156,    210,   1533,   -222,     -6,     48,     21,    372,    210,    -60,     -6,   -195, &
                   210,   -168,    -33,    372,   -195,     -6,     21,     -6,     21,    -60,     -6,   1506,  -2004,     -6, &
                -12291,   1506,    183,     -6,  -3030,  -1140,  -2004,    372,    372,  -1518,  -1140,    264,    372,  -1140, &
                  1506,   -492,     -6,  -1518,    183,    372,    183,    237,    -33,    318,  -1302,    372,     21,   -168, &
                   210,    156,    264,    -33,    399,  -2652,   -195,     -6,    696,  -1302,    588,   -168,  -1464,    -60, &
                   264,    210,   -546,   -249,    156,    264,    399,  -3084,   -222,   1533,    210,    156,   -222,    210, &
                   102,    696,  -1950,    -60,   -816,    588,    102,    264,    237,    183,    696,  -1302,  -1950,    -60, &
                   210,    -60,    210,   -600,   -168,    264,     21,    210,    -33,    156,  -1302,    372,  -1896,     -6, &
                 -3084,     21,    156,    318,     48,     -6,    264,    210]
  K1( 510,:) = [    156,    210,    210,   -222,   -222,   1533,     -6,   -195,    210,   -168,    -33,    372,     -6,     48, &
                    21,    372,    210,    -60,     -6,   -195,     21,    -60,     21,     -6,  -2004,     -6,     -6,   1506, &
                  1506, -12291,    372,  -1518,  -1140,    264,    372,  -1140,    183,     -6,  -3030,  -1140,  -2004,    372, &
                  -492,   1506,    183,    372,     -6,  -1518,   -546,   -249,    156,    264,    399,  -3084,   -222,   1533, &
                   210,    156,   -222,    210,    102,    696,  -1950,    -60,   -816,    588,    102,    264,    237,    183, &
                   696,  -1302,    183,    237,    -33,    318,  -1302,    372,     21,   -168,    210,    156,    264,    -33, &
                   399,  -2652,   -195,     -6,    696,  -1302,    588,   -168,  -1464,    -60,    264,    210,    -60,  -1950, &
                   210,   -600,    210,    -60,    264,   -168,    -33,    156,     21,    210,    156,    318,     48,     -6, &
                   264,    210,  -1302,    372,  -1896,     -6,  -3084,     21]
  K1( 511,:) = [   -168,    264,     21,    210,    -33,    156,  -1950,    -60,    210,    -60,    210,   -600,  -1896,     -6, &
                 -1302,    372,     21,  -3084,     48,     -6,    156,    318,    210,    264,   1506,   -492,     -6,  -1518, &
                   183,    372, -12291,   1506,   1506,     -6,     -6,  -2004,  -2004,    372,     -6,    183,  -1140,  -3030, &
                   372,  -1140,  -1518,    372,    264,  -1140,   -195,     -6,     21,     -6,     21,    -60,   1533,   -222, &
                  -222,    210,    210,    156,    210,    -60,     48,     -6,    372,     21,    -33,    372,   -195,     -6, &
                  -168,    210,  -1464,    -60,    588,   -168,    210,    264,    264,    -33,   -168,     21,    156,    210, &
                 -1302,    372,    237,    183,    318,    -33,  -1302,    696,     -6,   -195,  -2652,    399,    237,    183, &
                   102,    264,  -1302,    696,   -222,    210,   1533,   -222,    156,    210,    399,  -3084,   -249,   -546, &
                   264,    156,    588,   -816,    -60,  -1950,    696,    102]
  K1( 512,:) = [    264,   -168,    -33,    156,     21,    210,    -60,  -1950,    210,   -600,    210,    -60,     48,     -6, &
                   156,    318,    210,    264,  -1896,     -6,  -1302,    372,     21,  -3084,   -492,   1506,    183,    372, &
                    -6,  -1518,   1506, -12291,     -6,  -2004,   1506,     -6,    372,  -1140,  -1518,    372,    264,  -1140, &
                 -2004,    372,     -6,    183,  -1140,  -3030,     -6,   -195,     21,    -60,     21,     -6,   -222,   1533, &
                   210,    156,   -222,    210,    -33,    372,   -195,     -6,   -168,    210,    210,    -60,     48,     -6, &
                   372,     21,    237,    183,    102,    264,  -1302,    696,   -222,    210,   1533,   -222,    156,    210, &
                   399,  -3084,   -249,   -546,    264,    156,    588,   -816,    -60,  -1950,    696,    102,  -1464,    -60, &
                   588,   -168,    210,    264,    264,    -33,   -168,     21,    156,    210,  -1302,    372,    237,    183, &
                   318,    -33,  -1302,    696,     -6,   -195,  -2652,    399]
  K1( 513,:) = [   -168,     21,    264,    -33,    210,    156,    237,    183,  -1302,    372,    -33,    318,  -1464,    -60, &
                   588,   -168,    210,    264,   -195,     -6,    399,  -2652,  -1302,    696,     -6,    183,  -2004,    372, &
                 -3030,  -1140,   1506,     -6, -12291,   1506,  -2004,     -6,     -6,  -1518,   1506,   -492,    372,    183, &
                 -1140,    264,    372,  -1518,  -1140,    372,     48,     -6,    210,    -60,     21,    372,   -222,    210, &
                  1533,   -222,    156,    210,     21,     -6,   -195,     -6,    -60,     21,    210,   -168,     -6,   -195, &
                   372,    -33,  -1896,     -6,  -1302,    372,     21,  -3084,     21,    210,   -168,    264,    156,    -33, &
                   210,    -60,  -1950,    -60,   -600,    210,    210,    264,     -6,     48,    318,    156,  -1950,    -60, &
                   102,    696,    588,   -816,    210,    156,   -222,   1533,    210,   -222,    156,    264,   -546,   -249, &
                 -3084,    399,  -1302,    696,    183,    237,    264,    102]
  K1( 514,:) = [   1533,   -222,   -222,    210,    210,    156,   -249,   -546,    399,  -3084,    156,    264,    237,    183, &
                   102,    264,  -1302,    696,  -1950,    -60,    102,    696,    588,   -816,  -1518,    372,    372,  -1140, &
                 -1140,    264,     -6,  -2004,   1506, -12291,     -6,   1506,    183,    372,   -492,   1506,  -1518,     -6, &
                 -3030,  -1140,    183,     -6,    372,  -2004,   -195,     -6,    -33,    372,    210,   -168,    210,    156, &
                  -222,   1533,    210,   -222,     21,    -60,     -6,   -195,     -6,     21,     21,    372,     -6,     48, &
                   -60,    210,     48,     -6,    156,    318,    210,    264,    -33,    156,    264,   -168,    210,     21, &
                   210,   -600,    -60,  -1950,    -60,    210,     21,  -3084,     -6,  -1896,    372,  -1302,   -195,     -6, &
                   399,  -2652,  -1302,    696,    210,    156,     21,   -168,    -33,    264,    -33,    318,    183,    237, &
                   372,  -1302,    210,    264,    -60,  -1464,   -168,    588]
  K1( 515,:) = [     21,   -168,    210,    156,    264,    -33,    183,    237,    -33,    318,  -1302,    372,   -195,     -6, &
                   399,  -2652,  -1302,    696,  -1464,    -60,    588,   -168,    210,    264,    183,     -6,  -3030,  -1140, &
                 -2004,    372,     -6,   1506,  -2004,     -6, -12291,   1506,  -1140,    264,    372,  -1518,  -1140,    372, &
                    -6,  -1518,   1506,   -492,    372,    183,     -6,     48,     21,    372,    210,    -60,    210,   -222, &
                   156,    210,   1533,   -222,    210,   -168,     -6,   -195,    372,    -33,     21,     -6,   -195,     -6, &
                   -60,     21,  -1950,    -60,    102,    696,    588,   -816,    210,    156,   -222,   1533,    210,   -222, &
                   156,    264,   -546,   -249,  -3084,    399,  -1302,    696,    183,    237,    264,    102,  -1896,     -6, &
                 -1302,    372,     21,  -3084,     21,    210,   -168,    264,    156,    -33,    210,    -60,  -1950,    -60, &
                  -600,    210,    210,    264,     -6,     48,    318,    156]
  K1( 516,:) = [   -222,   1533,    210,    156,   -222,    210,   -546,   -249,    156,    264,    399,  -3084,  -1950,    -60, &
                   102,    696,    588,   -816,    237,    183,    102,    264,  -1302,    696,    372,  -1518,  -1140,    264, &
                   372,  -1140,  -2004,     -6,     -6,   1506,   1506, -12291,  -3030,  -1140,    183,     -6,    372,  -2004, &
                   183,    372,   -492,   1506,  -1518,     -6,     -6,   -195,    210,   -168,    -33,    372,    156,    210, &
                   210,   -222,   -222,   1533,     21,    372,     -6,     48,    -60,    210,     21,    -60,     -6,   -195, &
                    -6,     21,   -195,     -6,    399,  -2652,  -1302,    696,    210,    156,     21,   -168,    -33,    264, &
                   -33,    318,    183,    237,    372,  -1302,    210,    264,    -60,  -1464,   -168,    588,     48,     -6, &
                   156,    318,    210,    264,    -33,    156,    264,   -168,    210,     21,    210,   -600,    -60,  -1950, &
                   -60,    210,     21,  -3084,     -6,  -1896,    372,  -1302]
  K1( 517,:) = [     21,    210,   -168,    264,    156,    -33,  -1896,     -6,  -1302,    372,     21,  -3084,  -1950,    -60, &
                   210,    -60,    210,   -600,     -6,     48,    210,    264,    156,    318,     -6,  -1518,   1506,   -492, &
                   372,    183,  -2004,    372,     -6,    183,  -1140,  -3030, -12291,   1506,   1506,     -6,     -6,  -2004, &
                 -1140,    372,    264,  -1140,  -1518,    372,  -1464,    -60,    588,   -168,    210,    264,    264,    -33, &
                  -168,     21,    156,    210,  -1302,    372,    237,    183,    318,    -33,  -1302,    696,     -6,   -195, &
                 -2652,    399,   -195,     -6,     21,     -6,     21,    -60,   1533,   -222,   -222,    210,    210,    156, &
                   210,    -60,     48,     -6,    372,     21,    -33,    372,   -195,     -6,   -168,    210,    183,    237, &
                 -1302,    696,    102,    264,    210,   -222,    156,    210,   1533,   -222,    588,   -816,    -60,  -1950, &
                   696,    102,    399,  -3084,   -249,   -546,    264,    156]
  K1( 518,:) = [    -33,    156,    264,   -168,    210,     21,     48,     -6,    156,    318,    210,    264,    -60,  -1950, &
                   210,   -600,    210,    -60,     -6,  -1896,     21,  -3084,  -1302,    372,    183,    372,   -492,   1506, &
                 -1518,     -6,    372,  -1140,  -1518,    372,    264,  -1140,   1506, -12291,     -6,  -2004,   1506,     -6, &
                   372,  -2004,  -1140,  -3030,     -6,    183,    237,    183,    102,    264,  -1302,    696,   -222,    210, &
                  1533,   -222,    156,    210,    399,  -3084,   -249,   -546,    264,    156,    588,   -816,    -60,  -1950, &
                   696,    102,     -6,   -195,     21,    -60,     21,     -6,   -222,   1533,    210,    156,   -222,    210, &
                   -33,    372,   -195,     -6,   -168,    210,    210,    -60,     48,     -6,    372,     21,    -60,  -1464, &
                   210,    264,    588,   -168,    -33,    264,    156,    210,   -168,     21,  -1302,    696,     -6,   -195, &
                 -2652,    399,  -1302,    372,    237,    183,    318,    -33]
  K1( 519,:) = [    264,    -33,   -168,     21,    156,    210,  -1464,    -60,    588,   -168,    210,    264,    237,    183, &
                 -1302,    372,    -33,    318,     -6,   -195,  -1302,    696,    399,  -2652,  -2004,    372,     -6,    183, &
                 -1140,  -3030,     -6,  -1518,   1506,   -492,    372,    183,   1506,     -6, -12291,   1506,  -2004,     -6, &
                   264,  -1140,  -1140,    372,    372,  -1518,  -1896,     -6,  -1302,    372,     21,  -3084,     21,    210, &
                  -168,    264,    156,    -33,    210,    -60,  -1950,    -60,   -600,    210,    210,    264,     -6,     48, &
                   318,    156,     48,     -6,    210,    -60,     21,    372,   -222,    210,   1533,   -222,    156,    210, &
                    21,     -6,   -195,     -6,    -60,     21,    210,   -168,     -6,   -195,    372,    -33,    -60,  -1950, &
                   588,   -816,    102,    696,    156,    210,    210,   -222,   -222,   1533,  -1302,    696,    183,    237, &
                   264,    102,    156,    264,   -546,   -249,  -3084,    399]
  K1( 520,:) = [   -222,    210,   1533,   -222,    156,    210,    237,    183,    102,    264,  -1302,    696,   -249,   -546, &
                   399,  -3084,    156,    264,    -60,  -1950,    588,   -816,    102,    696,    372,  -1140,  -1518,    372, &
                   264,  -1140,    183,    372,   -492,   1506,  -1518,     -6,     -6,  -2004,   1506, -12291,     -6,   1506, &
                 -1140,  -3030,    372,  -2004,    183,     -6,     48,     -6,    156,    318,    210,    264,    -33,    156, &
                   264,   -168,    210,     21,    210,   -600,    -60,  -1950,    -60,    210,     21,  -3084,     -6,  -1896, &
                   372,  -1302,   -195,     -6,    -33,    372,    210,   -168,    210,    156,   -222,   1533,    210,   -222, &
                    21,    -60,     -6,   -195,     -6,     21,     21,    372,     -6,     48,    -60,    210,     -6,   -195, &
                 -1302,    696,    399,  -2652,    156,    210,    -33,    264,     21,   -168,    210,    264,    -60,  -1464, &
                  -168,    588,    -33,    318,    183,    237,    372,  -1302]
  K1( 521,:) = [    210,    156,     21,   -168,    -33,    264,   -195,     -6,    399,  -2652,  -1302,    696,    183,    237, &
                   -33,    318,  -1302,    372,    -60,  -1464,    210,    264,    588,   -168,  -3030,  -1140,    183,     -6, &
                   372,  -2004,  -1140,    264,    372,  -1518,  -1140,    372,     -6,   1506,  -2004,     -6, -12291,   1506, &
                 -1518,     -6,    372,    183,   1506,   -492,  -1950,    -60,    102,    696,    588,   -816,    210,    156, &
                  -222,   1533,    210,   -222,    156,    264,   -546,   -249,  -3084,    399,  -1302,    696,    183,    237, &
                   264,    102,     -6,     48,     21,    372,    210,    -60,    210,   -222,    156,    210,   1533,   -222, &
                   210,   -168,     -6,   -195,    372,    -33,     21,     -6,   -195,     -6,    -60,     21,     -6,  -1896, &
                    21,  -3084,  -1302,    372,    210,     21,    156,    -33,   -168,    264,    210,    264,     -6,     48, &
                   318,    156,    210,    -60,  -1950,    -60,   -600,    210]
  K1( 522,:) = [    210,    156,   -222,   1533,    210,   -222,  -1950,    -60,    102,    696,    588,   -816,   -546,   -249, &
                   156,    264,    399,  -3084,    183,    237,  -1302,    696,    102,    264,  -1140,    264,    372,  -1518, &
                 -1140,    372,  -3030,  -1140,    183,     -6,    372,  -2004,  -2004,     -6,     -6,   1506,   1506, -12291, &
                   372,    183,  -1518,     -6,   -492,   1506,   -195,     -6,    399,  -2652,  -1302,    696,    210,    156, &
                    21,   -168,    -33,    264,    -33,    318,    183,    237,    372,  -1302,    210,    264,    -60,  -1464, &
                  -168,    588,     -6,   -195,    210,   -168,    -33,    372,    156,    210,    210,   -222,   -222,   1533, &
                    21,    372,     -6,     48,    -60,    210,     21,    -60,     -6,   -195,     -6,     21,     -6,     48, &
                   210,    264,    156,    318,    156,    -33,    210,     21,    264,   -168,     21,  -3084,     -6,  -1896, &
                   372,  -1302,    210,   -600,    -60,  -1950,    -60,    210]
  K1( 523,:) = [    210,     21,    156,    -33,   -168,    264,     -6,  -1896,     21,  -3084,  -1302,    372,     -6,     48, &
                   210,    264,    156,    318,  -1950,    -60,    210,    -60,    210,   -600,  -1518,     -6,    372,    183, &
                  1506,   -492,    372,  -2004,  -1140,  -3030,     -6,    183,  -1140,    372,    264,  -1140,  -1518,    372, &
                -12291,   1506,   1506,     -6,     -6,  -2004,    -60,  -1464,    210,    264,    588,   -168,    -33,    264, &
                   156,    210,   -168,     21,  -1302,    696,     -6,   -195,  -2652,    399,  -1302,    372,    237,    183, &
                   318,    -33,    183,    237,  -1302,    696,    102,    264,    210,   -222,    156,    210,   1533,   -222, &
                   588,   -816,    -60,  -1950,    696,    102,    399,  -3084,   -249,   -546,    264,    156,   -195,     -6, &
                    21,     -6,     21,    -60,   1533,   -222,   -222,    210,    210,    156,    210,    -60,     48,     -6, &
                   372,     21,    -33,    372,   -195,     -6,   -168,    210]
  K1( 524,:) = [    156,    -33,    210,     21,    264,   -168,     -6,     48,    210,    264,    156,    318,     -6,  -1896, &
                    21,  -3084,  -1302,    372,    -60,  -1950,    210,   -600,    210,    -60,    372,    183,  -1518,     -6, &
                  -492,   1506,  -1140,    372,    264,  -1140,  -1518,    372,    372,  -2004,  -1140,  -3030,     -6,    183, &
                  1506, -12291,     -6,  -2004,   1506,     -6,    183,    237,  -1302,    696,    102,    264,    210,   -222, &
                   156,    210,   1533,   -222,    588,   -816,    -60,  -1950,    696,    102,    399,  -3084,   -249,   -546, &
                   264,    156,    -60,  -1464,    210,    264,    588,   -168,    -33,    264,    156,    210,   -168,     21, &
                 -1302,    696,     -6,   -195,  -2652,    399,  -1302,    372,    237,    183,    318,    -33,     -6,   -195, &
                    21,    -60,     21,     -6,   -222,   1533,    210,    156,   -222,    210,    -33,    372,   -195,     -6, &
                  -168,    210,    210,    -60,     48,     -6,    372,     21]
  K1( 525,:) = [    -33,    264,    156,    210,   -168,     21,    -60,  -1464,    210,    264,    588,   -168,     -6,   -195, &
                 -1302,    696,    399,  -2652,    237,    183,  -1302,    372,    -33,    318,    372,  -2004,  -1140,  -3030, &
                    -6,    183,  -1518,     -6,    372,    183,   1506,   -492,    264,  -1140,  -1140,    372,    372,  -1518, &
                  1506,     -6, -12291,   1506,  -2004,     -6,     -6,  -1896,     21,  -3084,  -1302,    372,    210,     21, &
                   156,    -33,   -168,    264,    210,    264,     -6,     48,    318,    156,    210,    -60,  -1950,    -60, &
                  -600,    210,    -60,  -1950,    588,   -816,    102,    696,    156,    210,    210,   -222,   -222,   1533, &
                 -1302,    696,    183,    237,    264,    102,    156,    264,   -546,   -249,  -3084,    399,     48,     -6, &
                   210,    -60,     21,    372,   -222,    210,   1533,   -222,    156,    210,     21,     -6,   -195,     -6, &
                   -60,     21,    210,   -168,     -6,   -195,    372,    -33]
  K1( 526,:) = [    210,   -222,    156,    210,   1533,   -222,    183,    237,  -1302,    696,    102,    264,    -60,  -1950, &
                   588,   -816,    102,    696,   -249,   -546,    399,  -3084,    156,    264,  -1140,    372,    264,  -1140, &
                 -1518,    372,    372,    183,  -1518,     -6,   -492,   1506,  -1140,  -3030,    372,  -2004,    183,     -6, &
                    -6,  -2004,   1506, -12291,     -6,   1506,     -6,     48,    210,    264,    156,    318,    156,    -33, &
                   210,     21,    264,   -168,     21,  -3084,     -6,  -1896,    372,  -1302,    210,   -600,    -60,  -1950, &
                   -60,    210,     -6,   -195,  -1302,    696,    399,  -2652,    156,    210,    -33,    264,     21,   -168, &
                   210,    264,    -60,  -1464,   -168,    588,    -33,    318,    183,    237,    372,  -1302,   -195,     -6, &
                   -33,    372,    210,   -168,    210,    156,   -222,   1533,    210,   -222,     21,    -60,     -6,   -195, &
                    -6,     21,     21,    372,     -6,     48,    -60,    210]
  K1( 527,:) = [    156,    210,    -33,    264,     21,   -168,     -6,   -195,  -1302,    696,    399,  -2652,    -60,  -1464, &
                   210,    264,    588,   -168,    183,    237,    -33,    318,  -1302,    372,  -1140,  -3030,    372,  -2004, &
                   183,     -6,    264,  -1140,  -1140,    372,    372,  -1518,  -1518,     -6,    372,    183,   1506,   -492, &
                    -6,   1506,  -2004,     -6, -12291,   1506,    -60,  -1950,    588,   -816,    102,    696,    156,    210, &
                   210,   -222,   -222,   1533,  -1302,    696,    183,    237,    264,    102,    156,    264,   -546,   -249, &
                 -3084,    399,     -6,  -1896,     21,  -3084,  -1302,    372,    210,     21,    156,    -33,   -168,    264, &
                   210,    264,     -6,     48,    318,    156,    210,    -60,  -1950,    -60,   -600,    210,     -6,     48, &
                    21,    372,    210,    -60,    210,   -222,    156,    210,   1533,   -222,    210,   -168,     -6,   -195, &
                   372,    -33,     21,     -6,   -195,     -6,    -60,     21]
  K1( 528,:) = [    156,    210,    210,   -222,   -222,   1533,    -60,  -1950,    588,   -816,    102,    696,    183,    237, &
                 -1302,    696,    102,    264,   -546,   -249,    156,    264,    399,  -3084,    264,  -1140,  -1140,    372, &
                   372,  -1518,  -1140,  -3030,    372,  -2004,    183,     -6,    372,    183,  -1518,     -6,   -492,   1506, &
                 -2004,     -6,     -6,   1506,   1506, -12291,     -6,   -195,  -1302,    696,    399,  -2652,    156,    210, &
                   -33,    264,     21,   -168,    210,    264,    -60,  -1464,   -168,    588,    -33,    318,    183,    237, &
                   372,  -1302,     -6,     48,    210,    264,    156,    318,    156,    -33,    210,     21,    264,   -168, &
                    21,  -3084,     -6,  -1896,    372,  -1302,    210,   -600,    -60,  -1950,    -60,    210,     -6,   -195, &
                   210,   -168,    -33,    372,    156,    210,    210,   -222,   -222,   1533,     21,    372,     -6,     48, &
                   -60,    210,     21,    -60,     -6,   -195,     -6,     21]
  K1( 529,:) = [   1533,   -222,   -168,   -168,     21,    264,  -1896,    480,    264,     -6,   -222,    -60,   -384,    102, &
                    21,     -6,   -357,     -6,    102,   -384,     21,    183,    318,    -60,  -1950,    -60,    237,   -249, &
                   183,   -546,   -195,     -6,     48,   -195,     -6,     -6,  -1464,    237,  -1896,     48,  -1950,   -195, &
                   -60,    183,     -6,     -6,    -60,     -6,   -384,  -1896,   -168,   -195,   1533,  -1950,   -168,    264, &
                  -168,   1533,     21,   -222,   -168,     48,   -384,   -384,  -1896,   1344,   -168,    237,   -384,   1317, &
                 -1464,   -168,   1317,   -384,   -222,     -6,   -114,     -6,   -168,   -168,   1344,   -114,    318,   -357, &
                  1533,   -195,   -384,    102,     48,   -114,   1344,     -6,   -816,   2640,   -195,   -357,   -384,   -384, &
                   264,   -546,   -168,    183,    318,   -168,   -357,   -114,   -168,   1344,   -168,   -249,    102,   -384, &
                   237,   -168,   -168,    -60,   -384,   -816,  -1950,    318]
  K1( 530,:) = [   -222,   1533,     21,    264,   -168,   -168,    480,  -1896,   -222,    -60,    264,     -6,    102,   -384, &
                    21,    183,    318,    -60,   -384,    102,     21,     -6,   -357,     -6,    -60,  -1950,    183,   -546, &
                   237,   -249,     -6,   -195,     -6,     -6,     48,   -195,    -60,    183,     -6,     -6,    -60,     -6, &
                 -1464,    237,  -1896,     48,  -1950,   -195,  -1896,   -384,   1533,  -1950,   -168,   -195,    264,   -168, &
                    21,   -222,   -168,   1533,   -168,    237,   -384,   1317,  -1464,   -168,   -168,     48,   -384,   -384, &
                 -1896,   1344,   -384,   -384,    264,   -546,   -168,    183,    318,   -168,   -357,   -114,   -168,   1344, &
                  -168,   -249,    102,   -384,    237,   -168,   -168,    -60,   -384,   -816,  -1950,    318,   1317,   -384, &
                  -222,     -6,   -114,     -6,   -168,   -168,   1344,   -114,    318,   -357,   1533,   -195,   -384,    102, &
                    48,   -114,   1344,     -6,   -816,   2640,   -195,   -357]
  K1( 531,:) = [   -195,     48,     -6,     -6,   -195,     -6,    264,   -222,     48,   -222,     48,    264,   1533,   -168, &
                 -1464,    210,   -141,    210,   -114,   -168,   -195,     21,   -141,    -33,    210,    210,  -1302,    399, &
                   -33,    156,     21,     21,    210,    -33,     21,    210,    588,    102,  -1302,    156,    102,    399, &
                   210,  -1302,     21,    210,    588,  -1302,   -168,   1533,   1560,   1533,   1560,   -168,     48,   -195, &
                   480,     -6,   1749,     -6,     48,   -222,   -168,   -168,     21,   -141,   -141,   -168,   1344,   -168, &
                   264,   -141,   -222,    264,    912,    156,    534,    156,     -6,     -6,   1749,   -195,    480,     48, &
                 -1464,    210,     21,     21,    -33,   -195,   -195,    156,    318,   -357,    210,     48,   -114,   -168, &
                   534,   -222,   1560,    210,   -384,     48,   3072,   -384,    480,     48,   -141,   1533,   -357,    318, &
                  -222,   -141,     48,    156,   -168,   1344,    210,   -195]
  K1( 532,:) = [     21,    210,    -33,    399,    156,    102,     -6,    -60,   -222,   1506,    264,   -492,   -195,   -249, &
                   210,     -6,   1533,  -1518,     48,    237,    -33,    183,   -222,    372,    -60,   -600,    372,  -3084, &
                   318,    264,     -6,    -60,    -60,    372,    372,   -168,   -168,    264,    372,    318,    696,  -2652, &
                   264,    696,  -3084,    264,   -816,    696,   -195,  -1950,   1533, -12291,   -168,   1506,     21,    210, &
                   210,  -1302,  -1302,    588,   -222,   1506,     48,    237,     -6,   -168,     21,     -6,  -1896,  -1464, &
                 -2004,    264,     -6,   -546,    156,  -2004,   -222,    372,    210,    156,     21,    -33,    102,    399, &
                   210,     -6,     -6,    183,    183,     21,    210,  -1140,  -1950,   -195,  -3030,    210,     -6,    183, &
                   156,    372,    210,  -1140,    210,  -1302,     21,    210,    588,  -1302,    210,  -1518,     -6,    -60, &
                   372,    -33,    156,    264,    -60,     -6,  -1140,    156]
  K1( 533,:) = [     48,   -195,   -195,     -6,     -6,     -6,   -222,    264,     48,    264,     48,   -222,   -114,   -168, &
                  -195,     21,   -141,    -33,   1533,   -168,  -1464,    210,   -141,    210,    210,    210,    -33,    156, &
                 -1302,    399,     21,     21,     21,    210,    210,    -33,    210,  -1302,     21,    210,    588,  -1302, &
                   588,    102,  -1302,    156,    102,    399,   1533,   -168,   1560,   -168,   1560,   1533,   -195,     48, &
                  1749,     -6,    480,     -6,   -141,   -168,   1344,   -168,    264,   -141,     48,   -222,   -168,   -168, &
                    21,   -141,   -114,   -168,    534,   -222,   1560,    210,   -384,     48,   3072,   -384,    480,     48, &
                  -141,   1533,   -357,    318,   -222,   -141,     48,    156,   -168,   1344,    210,   -195,   -222,    264, &
                   912,    156,    534,    156,     -6,     -6,   1749,   -195,    480,     48,  -1464,    210,     21,     21, &
                   -33,   -195,   -195,    156,    318,   -357,    210,     48]
  K1( 534,:) = [    210,     21,    156,    102,    -33,    399,    -60,     -6,    264,   -492,   -222,   1506,     48,    237, &
                   -33,    183,   -222,    372,   -195,   -249,    210,     -6,   1533,  -1518,   -600,    -60,    318,    264, &
                   372,  -3084,    -60,     -6,    372,   -168,    -60,    372,    264,    696,  -3084,    264,   -816,    696, &
                  -168,    264,    372,    318,    696,  -2652,  -1950,   -195,   -168,   1506,   1533, -12291,    210,     21, &
                 -1302,    588,    210,  -1302,     21,     -6,  -1896,  -1464,  -2004,    264,   -222,   1506,     48,    237, &
                    -6,   -168,     -6,    183,    156,    372,    210,  -1140,    210,  -1302,     21,    210,    588,  -1302, &
                   210,  -1518,     -6,    -60,    372,    -33,    156,    264,    -60,     -6,  -1140,    156,     -6,   -546, &
                   156,  -2004,   -222,    372,    210,    156,     21,    -33,    102,    399,    210,     -6,     -6,    183, &
                   183,     21,    210,  -1140,  -1950,   -195,  -3030,    210]
  K1( 535,:) = [   1560,     48,   -141,   -141,   -195,    534,   1533,   -222,   -195,     21,     48,    210,   1344,   -357, &
                  1749,     21,   3072,     21,   -114,   -114,   -195,    -33,   -384,    210,   -168,    264,   -168,   1533, &
                    21,   -222,   1533,   -222,   -222,    210,    210,    156,    264,   -222,     21,    -33,    210,    210, &
                   -33,    210,    210,    156,    156,    156,   -168,    264,     48,     21,   -195,    210,   1560,     48, &
                    48,  -1464,  -1464,    912,    480,    210,   -168,     21,  -1302,   1749,     -6,  -1302,   1533,   -222, &
                   588,     -6,   -168,    318,     -6,    210,   -384,    210,   -141,   -141,   -141,   -195,   -195,     48, &
                    -6,    -33,   -168,     21,    156,   -195,     48,  -1302,   1344,   -357,    399,     48,   -168,   -168, &
                    -6,    156,     48,  -1302,   -141,   1560,   -141,    534,     48,   -195,     -6,    399,   -168,    264, &
                   102,     -6,    480,    588,   -168,    318,    102,    480]
  K1( 536,:) = [     48,   1560,   -195,    534,   -141,   -141,   -222,   1533,     48,    210,   -195,     21,   -114,   -114, &
                  -195,    -33,   -384,    210,   1344,   -357,   1749,     21,   3072,     21,    264,   -168,     21,   -222, &
                  -168,   1533,   -222,   1533,    210,    156,   -222,    210,    -33,    210,    210,    156,    156,    156, &
                   264,   -222,     21,    -33,    210,    210,    264,   -168,   -195,    210,     48,     21,     48,   1560, &
                 -1464,    912,     48,  -1464,     -6,  -1302,   1533,   -222,    588,     -6,    480,    210,   -168,     21, &
                 -1302,   1749,   -168,   -168,     -6,    156,     48,  -1302,   -141,   1560,   -141,    534,     48,   -195, &
                    -6,    399,   -168,    264,    102,     -6,    480,    588,   -168,    318,    102,    480,   -168,    318, &
                    -6,    210,   -384,    210,   -141,   -141,   -141,   -195,   -195,     48,     -6,    -33,   -168,     21, &
                   156,   -195,     48,  -1302,   1344,   -357,    399,     48]
  K1( 537,:) = [   -141,   -195,   -141,   -141,     48,   -195,   -168,     21,     -6,    -33,   -195,    156,   -168,    318, &
                    -6,    210,   -384,    210,   -357,   1344,     48,    399,     48,  -1302,     21,    -33,    264,   -222, &
                   210,    210,   -222,    210,   1533,   -222,    156,    210,   -168,   1533,   -168,    264,   -222,     21, &
                   156,    156,    156,    210,    210,    -33,   -168,     21,    480,    210,   1749,  -1302,     48,  -1464, &
                  1560,     48,    912,  -1464,     48,     21,   -168,    264,    210,   -195,     -6,    588,   -222,   1533, &
                 -1302,     -6,   1344,   -357,   1749,     21,   3072,     21,   -141,   -141,   1560,     48,    534,   -195, &
                  -195,     21,   1533,   -222,    210,     48,   -384,    210,   -114,   -114,    -33,   -195,    318,   -168, &
                   480,    102,    480,    588,   -195,     48,    534,   -141,   1560,   -141,     -6,    102,    264,   -168, &
                   399,     -6,     48,  -1302,   -168,   -168,    156,     -6]
  K1( 538,:) = [   -141,    534,   -141,   1560,   -195,     48,   -168,    264,     -6,    399,     -6,    102,   -168,   -168, &
                    -6,    156,     48,  -1302,    318,   -168,    480,    102,    480,    588,    210,    156,    -33,    210, &
                   156,    156,    210,    156,   -222,   1533,    210,   -222,     21,   -222,    264,   -168,   1533,   -168, &
                   210,    210,    -33,     21,   -222,    264,   1533,   -222,     -6,  -1302,     -6,    588,  -1464,    912, &
                    48,   1560,  -1464,     48,   -195,    210,    264,   -168,     21,     48,   1749,  -1302,     21,   -168, &
                   210,    480,   -114,   -114,   -195,    -33,   -384,    210,   -195,    534,     48,   1560,   -141,   -141, &
                    48,    210,   -222,   1533,     21,   -195,   3072,     21,   -357,   1344,     21,   1749,   -357,   1344, &
                    48,    399,     48,  -1302,     48,   -195,   -195,   -141,   -141,   -141,   -195,    156,     21,   -168, &
                   -33,     -6,   -384,    210,    318,   -168,    210,     -6]
  K1( 539,:) = [   -195,   -141,     48,   -195,   -141,   -141,     21,   -168,   -195,    156,     -6,    -33,   -357,   1344, &
                    48,    399,     48,  -1302,   -168,    318,     -6,    210,   -384,    210,    -33,     21,    210,    210, &
                   264,   -222,    210,   -222,    156,    210,   1533,   -222,    156,    156,    156,    210,    210,    -33, &
                  -168,   1533,   -168,    264,   -222,     21,     21,   -168,   1749,  -1302,    480,    210,  -1464,     48, &
                   912,  -1464,   1560,     48,     -6,    588,   -222,   1533,  -1302,     -6,     48,     21,   -168,    264, &
                   210,   -195,    318,   -168,    480,    102,    480,    588,   -195,     48,    534,   -141,   1560,   -141, &
                    -6,    102,    264,   -168,    399,     -6,     48,  -1302,   -168,   -168,    156,     -6,   1344,   -357, &
                  1749,     21,   3072,     21,   -141,   -141,   1560,     48,    534,   -195,   -195,     21,   1533,   -222, &
                   210,     48,   -384,    210,   -114,   -114,    -33,   -195]
  K1( 540,:) = [    534,   -141,   -195,     48,   -141,   1560,    264,   -168,     -6,    102,     -6,    399,    318,   -168, &
                   480,    102,    480,    588,   -168,   -168,     -6,    156,     48,  -1302,    156,    210,    156,    156, &
                   -33,    210,    156,    210,    210,   -222,   -222,   1533,    210,    210,    -33,     21,   -222,    264, &
                    21,   -222,    264,   -168,   1533,   -168,   -222,   1533,     -6,    588,     -6,  -1302,    912,  -1464, &
                 -1464,     48,     48,   1560,   1749,  -1302,     21,   -168,    210,    480,   -195,    210,    264,   -168, &
                    21,     48,   -357,   1344,     48,    399,     48,  -1302,     48,   -195,   -195,   -141,   -141,   -141, &
                  -195,    156,     21,   -168,    -33,     -6,   -384,    210,    318,   -168,    210,     -6,   -114,   -114, &
                  -195,    -33,   -384,    210,   -195,    534,     48,   1560,   -141,   -141,     48,    210,   -222,   1533, &
                    21,   -195,   3072,     21,   -357,   1344,     21,   1749]
  K1( 541,:) = [   1749,   -195,     -6,     -6,     48,    480,     21,     21,  -1464,    210,   -195,    -33,   -222,    264, &
                   912,    156,    534,    156,   -357,    318,     48,    210,   -195,    156,  -1302,    156,    588,    102, &
                   399,    102,    210,    -33,     21,     21,    210,     21,  -1302,    399,    210,    210,    156,    -33, &
                 -1302,    588,    210,     21,  -1302,    210,   -168,   -168,     48,   -222,   -141,     21,    480,     -6, &
                    48,   -195,     -6,   1749,   1560,   1533,   -168,   1533,   -168,   1560,   -141,    264,   -168,   1344, &
                  -168,   -141,   1533,   -168,  -1464,    210,   -141,    210,     -6,     -6,   -195,     48,     -6,   -195, &
                    48,   -222,    264,   -222,    264,     48,   -141,    -33,   -168,   -114,     21,   -195,   1344,   -168, &
                  -195,    210,     48,    156,     48,    480,   -384,   3072,     48,   -384,   -141,   -222,    318,   -357, &
                  1533,   -141,   1560,    210,   -168,   -114,   -222,    534]
  K1( 542,:) = [     21,    -33,    210,    156,    399,    102,     -6,    183,    210,     -6,     21,    183,     -6,   -546, &
                   156,  -2004,   -222,    372,   -195,  -1950,    210,  -3030,    210,  -1140,    372,    318,   -168,    264, &
                 -2652,    696,    -60,    372,     -6,    -60,   -168,    372,    372,  -3084,    -60,   -600,    264,    318, &
                   696,   -816,    264,  -3084,    696,    264,     48,    237,   -222,   1506,   -168,     -6,    210,  -1302, &
                    21,    210,    588,  -1302,   1533, -12291,   -195,  -1950,   1506,   -168,    264,  -2004,  -1464,  -1896, &
                    -6,     21,   -195,   -249,    210,     -6,   1533,  -1518,    -33,    399,     21,    210,    102,    156, &
                  -222,   1506,     -6,    -60,   -492,    264,   -222,    372,    237,     48,    183,    -33,     -6,    -60, &
                   156,  -1140,    156,    264,  -1302,    588,    210,     21,  -1302,    210,    -33,    372,    -60,     -6, &
                 -1518,    210,    210,  -1140,    183,     -6,    372,    156]
  K1( 543,:) = [   1344,   -114,   -168,   -168,   -357,    318,   -384,    102,   1533,   -195,   -114,     48,   1317,   -384, &
                  -222,     -6,   -114,     -6,   2640,   -816,   -357,   -195,   1344,     -6,  -1896,     48,  -1464,    237, &
                  -195,  -1950,     48,   -195,   -195,     -6,     -6,     -6,    237,   -249,  -1950,    -60,   -546,    183, &
                    -6,    -60,     -6,     -6,    183,    -60,   -384,   -384,   -168,     48,   1344,  -1896,   -168,   1533, &
                  -168,    264,   -222,     21,   -168,   -195,   -384,  -1896,  -1950,   1533,   -168,  -1464,   1317,   -384, &
                   237,   -168,   -384,    102,     21,     -6,   -357,     -6,   -168,   -168,   1533,   -222,    264,     21, &
                   264,     -6,  -1896,    480,    -60,   -222,    318,    -60,   -384,    102,    183,     21,   -816,   -384, &
                   318,  -1950,   -168,    -60,   1344,   -168,   -114,   -357,   -168,    318,   -168,    237,   -384,    102, &
                  -249,   -168,   -168,    183,   -384,   -384,   -546,    264]
  K1( 544,:) = [   -357,   -114,    318,   -168,   1344,   -168,    102,   -384,   -168,   -249,   -168,    237,   -384,   -384, &
                   264,   -546,   -168,    183,   -816,   -384,    318,  -1950,   -168,    -60,     -6,     -6,    -60,    183, &
                    -6,    -60,     -6,     -6,     -6,   -195,   -195,     48,    183,   -546,    -60,  -1950,   -249,    237, &
                  -195,  -1950,     48,  -1896,    237,  -1464,   -384,   1317,   -168,    237,   -168,  -1464,     21,   -222, &
                   264,   -168,   1533,   -168,   1533,  -1950,  -1896,   -384,   -195,   -168,   1344,  -1896,   -384,   -384, &
                    48,   -168,    102,   -384,     21,    183,    318,    -60,     21,    264,   -222,   1533,   -168,   -168, &
                  -222,    -60,    480,  -1896,     -6,    264,   -357,     -6,    102,   -384,     -6,     21,   2640,   -816, &
                  -357,   -195,   1344,     -6,   -357,    318,   -114,   1344,   -168,   -168,   -114,     48,    102,   -384, &
                  -195,   1533,   -114,     -6,   -384,   1317,     -6,   -222]
  K1( 545,:) = [     21,    210,    210,  -1302,  -1302,    588,     -6,    -60,    210,  -1518,    -33,    372,     -6,    183, &
                   156,    372,    210,  -1140,     -6,    -60,    156,  -1140,    156,    264,  -3084,    264,    264,    696, &
                   696,   -816,    372,   -168,    -60,     -6,    372,    -60,    318,    264,   -600,    -60,  -3084,    372, &
                 -2652,    696,    318,    372,    264,   -168,  -1896,  -1464,     21,     -6,    264,  -2004,  -1302,    588, &
                   210,     21,  -1302,    210,   -168,   1506,  -1950,   -195, -12291,   1533,   -168,     -6,    237,     48, &
                  1506,   -222,     48,    237,    -33,    183,   -222,    372,    156,    102,    210,     21,    399,    -33, &
                   264,   -492,    -60,     -6,   1506,   -222,   1533,  -1518,   -249,   -195,     -6,    210,   -195,  -1950, &
                   210,  -3030,    210,  -1140,    399,    102,    -33,     21,    156,    210,     21,    183,    183,     -6, &
                    -6,    210,   -222,    372,   -546,     -6,  -2004,    156]
  K1( 546,:) = [   3072,   -384,   -384,     48,     48,    480,   -357,    318,   -141,   1533,   -141,   -222,   -114,   -168, &
                   534,   -222,   1560,    210,   1344,   -168,   -195,    210,     48,    156,     21,    210,    210,  -1302, &
                 -1302,    588,     21,    210,     21,     21,    -33,    210,    -33,    156,    210,    210,    399,  -1302, &
                   399,    102,    156,  -1302,    102,    588,   1344,   -168,   -141,   -168,   -141,    264,   1749,     -6, &
                  -195,     48,     -6,    480,   1560,   -168,   1533,   -168,   1533,   1560,   -141,     21,   -168,   -168, &
                  -222,     48,   -114,   -168,   -195,     21,   -141,    -33,   -195,     -6,     48,   -195,     -6,     -6, &
                    48,    264,   -222,    264,   -222,     48,   -141,    210,   -168,   1533,    210,  -1464,   -357,    318, &
                    48,    210,   -195,    156,     48,    480,   -195,   1749,     -6,     -6,   -195,    -33,     21,     21, &
                   210,  -1464,    534,    156,    264,   -222,    156,    912]
  K1( 547,:) = [   -195,   1749,     48,    480,     -6,     -6,     21,     21,   -195,    -33,  -1464,    210,   -357,    318, &
                    48,    210,   -195,    156,   -222,    264,    912,    156,    534,    156,    156,  -1302,    399,    102, &
                   588,    102,    -33,    210,    210,     21,     21,     21,  -1302,    588,    210,     21,  -1302,    210, &
                 -1302,    399,    210,    210,    156,    -33,   -168,   -168,   -141,     21,     48,   -222,     -6,    480, &
                    -6,   1749,     48,   -195,   -141,    264,   -168,   1344,   -168,   -141,   1560,   1533,   -168,   1533, &
                  -168,   1560,   1344,   -168,   -195,    210,     48,    156,     48,    480,   -384,   3072,     48,   -384, &
                  -141,   -222,    318,   -357,   1533,   -141,   1560,    210,   -168,   -114,   -222,    534,   1533,   -168, &
                 -1464,    210,   -141,    210,     -6,     -6,   -195,     48,     -6,   -195,     48,   -222,    264,   -222, &
                   264,     48,   -141,    -33,   -168,   -114,     21,   -195]
  K1( 548,:) = [    -33,     21,    399,    102,    210,    156,    183,     -6,     21,    183,    210,     -6,   -195,  -1950, &
                   210,  -3030,    210,  -1140,     -6,   -546,    156,  -2004,   -222,    372,    318,    372,  -2652,    696, &
                  -168,    264,    372,    -60,   -168,    372,     -6,    -60,    696,   -816,    264,  -3084,    696,    264, &
                   372,  -3084,    -60,   -600,    264,    318,    237,     48,   -168,     -6,   -222,   1506,  -1302,    210, &
                   588,  -1302,     21,    210,    264,  -2004,  -1464,  -1896,     -6,     21,   1533, -12291,   -195,  -1950, &
                  1506,   -168,     -6,    -60,    156,  -1140,    156,    264,  -1302,    588,    210,     21,  -1302,    210, &
                   -33,    372,    -60,     -6,  -1518,    210,    210,  -1140,    183,     -6,    372,    156,   -195,   -249, &
                   210,     -6,   1533,  -1518,    -33,    399,     21,    210,    102,    156,   -222,   1506,     -6,    -60, &
                  -492,    264,   -222,    372,    237,     48,    183,    -33]
  K1( 549,:) = [   -114,   1344,   -357,    318,   -168,   -168,    102,   -384,   -114,     48,   1533,   -195,   2640,   -816, &
                  -357,   -195,   1344,     -6,   1317,   -384,   -222,     -6,   -114,     -6,     48,  -1896,   -195,  -1950, &
                 -1464,    237,   -195,     48,     -6,     -6,   -195,     -6,     -6,    -60,     -6,     -6,    183,    -60, &
                   237,   -249,  -1950,    -60,   -546,    183,   -384,   -384,   1344,  -1896,   -168,     48,   1533,   -168, &
                  -222,     21,   -168,    264,   -168,  -1464,   1317,   -384,    237,   -168,   -168,   -195,   -384,  -1896, &
                 -1950,   1533,   -816,   -384,    318,  -1950,   -168,    -60,   1344,   -168,   -114,   -357,   -168,    318, &
                  -168,    237,   -384,    102,   -249,   -168,   -168,    183,   -384,   -384,   -546,    264,   -384,    102, &
                    21,     -6,   -357,     -6,   -168,   -168,   1533,   -222,    264,     21,    264,     -6,  -1896,    480, &
                   -60,   -222,    318,    -60,   -384,    102,    183,     21]
  K1( 550,:) = [   -114,   -357,   1344,   -168,    318,   -168,   -384,    102,   -168,    237,   -168,   -249,   -816,   -384, &
                   318,  -1950,   -168,    -60,   -384,   -384,    264,   -546,   -168,    183,     -6,     -6,     -6,    -60, &
                   -60,    183,     -6,     -6,   -195,     48,     -6,   -195,   -195,  -1950,     48,  -1896,    237,  -1464, &
                   183,   -546,    -60,  -1950,   -249,    237,   1317,   -384,   -168,  -1464,   -168,    237,   -222,     21, &
                  1533,   -168,    264,   -168,   1344,  -1896,   -384,   -384,     48,   -168,   1533,  -1950,  -1896,   -384, &
                  -195,   -168,   2640,   -816,   -357,   -195,   1344,     -6,   -357,    318,   -114,   1344,   -168,   -168, &
                  -114,     48,    102,   -384,   -195,   1533,   -114,     -6,   -384,   1317,     -6,   -222,    102,   -384, &
                    21,    183,    318,    -60,     21,    264,   -222,   1533,   -168,   -168,   -222,    -60,    480,  -1896, &
                    -6,    264,   -357,     -6,    102,   -384,     -6,     21]
  K1( 551,:) = [    210,     21,  -1302,    588,    210,  -1302,    -60,     -6,    -33,    372,    210,  -1518,     -6,    -60, &
                   156,  -1140,    156,    264,     -6,    183,    156,    372,    210,  -1140,    264,  -3084,    696,   -816, &
                   264,    696,   -168,    372,    372,    -60,    -60,     -6,  -2652,    696,    318,    372,    264,   -168, &
                   318,    264,   -600,    -60,  -3084,    372,  -1464,  -1896,    264,  -2004,     21,     -6,    588,  -1302, &
                 -1302,    210,    210,     21,   -168,     -6,    237,     48,   1506,   -222,   -168,   1506,  -1950,   -195, &
                -12291,   1533,   -195,  -1950,    210,  -3030,    210,  -1140,    399,    102,    -33,     21,    156,    210, &
                    21,    183,    183,     -6,     -6,    210,   -222,    372,   -546,     -6,  -2004,    156,     48,    237, &
                   -33,    183,   -222,    372,    156,    102,    210,     21,    399,    -33,    264,   -492,    -60,     -6, &
                  1506,   -222,   1533,  -1518,   -249,   -195,     -6,    210]
  K1( 552,:) = [   -384,   3072,     48,    480,   -384,     48,    318,   -357,   -141,   -222,   -141,   1533,   1344,   -168, &
                  -195,    210,     48,    156,   -114,   -168,    534,   -222,   1560,    210,    210,     21,  -1302,    588, &
                   210,  -1302,    210,     21,    -33,    210,     21,     21,    399,    102,    156,  -1302,    102,    588, &
                   -33,    156,    210,    210,    399,  -1302,   -168,   1344,   -141,    264,   -141,   -168,     -6,   1749, &
                    -6,    480,   -195,     48,   -141,     21,   -168,   -168,   -222,     48,   1560,   -168,   1533,   -168, &
                  1533,   1560,   -357,    318,     48,    210,   -195,    156,     48,    480,   -195,   1749,     -6,     -6, &
                  -195,    -33,     21,     21,    210,  -1464,    534,    156,    264,   -222,    156,    912,   -114,   -168, &
                  -195,     21,   -141,    -33,   -195,     -6,     48,   -195,     -6,     -6,     48,    264,   -222,    264, &
                  -222,     48,   -141,    210,   -168,   1533,    210,  -1464]
  K1( 553,:) = [   -168,   -168,   1533,   -222,    264,     21,   -384,    102,     21,     -6,   -357,     -6,  -1896,    480, &
                   264,     -6,   -222,    -60,   -384,    102,    318,    -60,     21,    183,    237,   -249,  -1950,    -60, &
                  -546,    183,  -1464,    237,  -1896,     48,  -1950,   -195,   -195,     -6,     48,   -195,     -6,     -6, &
                   183,    -60,    -60,     -6,     -6,     -6,   1317,   -384,   -222,     -6,   -114,     -6,   -168,   -168, &
                  1344,   -114,    318,   -357,   1533,   -195,   -384,    102,     48,   -114,   1344,     -6,   -816,   2640, &
                  -195,   -357,   -384,  -1896,   -168,   -195,   1533,  -1950,   -168,    264,   -168,   1533,     21,   -222, &
                  -168,     48,   -384,   -384,  -1896,   1344,   -168,    237,   -384,   1317,  -1464,   -168,   -384,   -384, &
                  -168,    183,    264,   -546,   -168,    318,   -168,   1344,   -357,   -114,   -168,    -60,   -384,   -816, &
                 -1950,    318,   -168,   -249,    102,   -384,    237,   -168]
  K1( 554,:) = [     21,    264,   -222,   1533,   -168,   -168,    102,   -384,     21,    183,    318,    -60,    480,  -1896, &
                  -222,    -60,    264,     -6,    102,   -384,   -357,     -6,     21,     -6,    183,   -546,    -60,  -1950, &
                  -249,    237,    -60,    183,     -6,     -6,    -60,     -6,     -6,   -195,     -6,     -6,     48,   -195, &
                   237,  -1464,  -1950,   -195,  -1896,     48,   -384,   -384,    264,   -546,   -168,    183,    318,   -168, &
                  -357,   -114,   -168,   1344,   -168,   -249,    102,   -384,    237,   -168,   -168,    -60,   -384,   -816, &
                 -1950,    318,  -1896,   -384,   1533,  -1950,   -168,   -195,    264,   -168,     21,   -222,   -168,   1533, &
                  -168,    237,   -384,   1317,  -1464,   -168,   -168,     48,   -384,   -384,  -1896,   1344,   -384,   1317, &
                  -114,     -6,   -222,     -6,   -168,   -168,    318,   -357,   1344,   -114,   1344,     -6,   -816,   2640, &
                  -195,   -357,   1533,   -195,   -384,    102,     48,   -114]
  K1( 555,:) = [     -6,     -6,   -195,     48,     -6,   -195,   1533,   -168,  -1464,    210,   -141,    210,    264,   -222, &
                    48,   -222,     48,    264,   -168,   -114,   -141,    -33,   -195,     21,  -1302,    399,    210,    210, &
                   156,    -33,    588,    102,  -1302,    156,    102,    399,     21,     21,    210,    -33,     21,    210, &
                 -1302,    210,    588,  -1302,     21,    210,   -222,    264,    912,    156,    534,    156,     -6,     -6, &
                  1749,   -195,    480,     48,  -1464,    210,     21,     21,    -33,   -195,   -195,    156,    318,   -357, &
                   210,     48,   -168,   1533,   1560,   1533,   1560,   -168,     48,   -195,    480,     -6,   1749,     -6, &
                    48,   -222,   -168,   -168,     21,   -141,   -141,   -168,   1344,   -168,    264,   -141,   -168,   -114, &
                  1560,    210,    534,   -222,     48,   -384,    480,     48,   3072,   -384,     48,    156,   -168,   1344, &
                   210,   -195,   -141,   1533,   -357,    318,   -222,   -141]
  K1( 556,:) = [    -33,    399,     21,    210,    102,    156,   -195,   -249,    210,     -6,   1533,  -1518,     -6,    -60, &
                  -222,   1506,    264,   -492,    237,     48,   -222,    372,    -33,    183,    372,  -3084,    -60,   -600, &
                   264,    318,   -168,    264,    372,    318,    696,  -2652,     -6,    -60,    -60,    372,    372,   -168, &
                   696,    264,   -816,    696,  -3084,    264,     -6,   -546,    156,  -2004,   -222,    372,    210,    156, &
                    21,    -33,    102,    399,    210,     -6,     -6,    183,    183,     21,    210,  -1140,  -1950,   -195, &
                 -3030,    210,   -195,  -1950,   1533, -12291,   -168,   1506,     21,    210,    210,  -1302,  -1302,    588, &
                  -222,   1506,     48,    237,     -6,   -168,     21,     -6,  -1896,  -1464,  -2004,    264,    183,     -6, &
                   210,  -1140,    156,    372,  -1302,    210,    588,  -1302,     21,    210,    156,    264,    -60,     -6, &
                 -1140,    156,    210,  -1518,     -6,    -60,    372,    -33]
  K1( 557,:) = [   -195,     -6,     48,   -195,     -6,     -6,   -114,   -168,   -195,     21,   -141,    -33,   -222,    264, &
                    48,    264,     48,   -222,   -168,   1533,   -141,    210,  -1464,    210,    -33,    156,    210,    210, &
                   399,  -1302,    210,  -1302,     21,    210,    588,  -1302,     21,     21,     21,    210,    210,    -33, &
                   102,    588,    102,    399,  -1302,    156,   -114,   -168,    534,   -222,   1560,    210,   -384,     48, &
                  3072,   -384,    480,     48,   -141,   1533,   -357,    318,   -222,   -141,     48,    156,   -168,   1344, &
                   210,   -195,   1533,   -168,   1560,   -168,   1560,   1533,   -195,     48,   1749,     -6,    480,     -6, &
                  -141,   -168,   1344,   -168,    264,   -141,     48,   -222,   -168,   -168,     21,   -141,    264,   -222, &
                   534,    156,    912,    156,     -6,     -6,    480,     48,   1749,   -195,   -195,    156,    318,   -357, &
                   210,     48,  -1464,    210,     21,     21,    -33,   -195]
  K1( 558,:) = [    156,    102,    210,     21,    399,    -33,     48,    237,    -33,    183,   -222,    372,    -60,     -6, &
                   264,   -492,   -222,   1506,   -249,   -195,   1533,  -1518,    210,     -6,    318,    264,   -600,    -60, &
                 -3084,    372,    264,    696,  -3084,    264,   -816,    696,    -60,     -6,    372,   -168,    -60,    372, &
                   264,   -168,    696,  -2652,    372,    318,     -6,    183,    156,    372,    210,  -1140,    210,  -1302, &
                    21,    210,    588,  -1302,    210,  -1518,     -6,    -60,    372,    -33,    156,    264,    -60,     -6, &
                 -1140,    156,  -1950,   -195,   -168,   1506,   1533, -12291,    210,     21,  -1302,    588,    210,  -1302, &
                    21,     -6,  -1896,  -1464,  -2004,    264,   -222,   1506,     48,    237,     -6,   -168,   -546,     -6, &
                  -222,    372,    156,  -2004,    156,    210,    102,    399,     21,    -33,    210,  -1140,  -1950,   -195, &
                 -3030,    210,    210,     -6,     -6,    183,    183,     21]
  K1( 559,:) = [   -141,   -141,   1560,     48,    534,   -195,   1344,   -357,   1749,     21,   3072,     21,   1533,   -222, &
                  -195,     21,     48,    210,   -114,   -114,   -384,    210,   -195,    -33,   -168,   1533,   -168,    264, &
                  -222,     21,    264,   -222,     21,    -33,    210,    210,   1533,   -222,   -222,    210,    210,    156, &
                   210,    -33,    156,    156,    210,    156,   -168,    318,     -6,    210,   -384,    210,   -141,   -141, &
                  -141,   -195,   -195,     48,     -6,    -33,   -168,     21,    156,   -195,     48,  -1302,   1344,   -357, &
                   399,     48,   -168,    264,     48,     21,   -195,    210,   1560,     48,     48,  -1464,  -1464,    912, &
                   480,    210,   -168,     21,  -1302,   1749,     -6,  -1302,   1533,   -222,    588,     -6,   -168,   -168, &
                    48,  -1302,     -6,    156,   1560,   -141,     48,   -195,   -141,    534,    480,    588,   -168,    318, &
                   102,    480,     -6,    399,   -168,    264,    102,     -6]
  K1( 560,:) = [   -195,    534,     48,   1560,   -141,   -141,   -114,   -114,   -195,    -33,   -384,    210,   -222,   1533, &
                    48,    210,   -195,     21,   -357,   1344,   3072,     21,   1749,     21,     21,   -222,    264,   -168, &
                  1533,   -168,    -33,    210,    210,    156,    156,    156,   -222,   1533,    210,    156,   -222,    210, &
                  -222,    264,    210,    210,     21,    -33,   -168,   -168,     -6,    156,     48,  -1302,   -141,   1560, &
                  -141,    534,     48,   -195,     -6,    399,   -168,    264,    102,     -6,    480,    588,   -168,    318, &
                   102,    480,    264,   -168,   -195,    210,     48,     21,     48,   1560,  -1464,    912,     48,  -1464, &
                    -6,  -1302,   1533,   -222,    588,     -6,    480,    210,   -168,     21,  -1302,   1749,    318,   -168, &
                  -384,    210,     -6,    210,   -141,   -141,   -195,     48,   -141,   -195,     48,  -1302,   1344,   -357, &
                   399,     48,     -6,    -33,   -168,     21,    156,   -195]
  K1( 561,:) = [   -141,   -141,   -141,   -195,   -195,     48,   -168,    318,     -6,    210,   -384,    210,   -168,     21, &
                    -6,    -33,   -195,    156,   1344,   -357,     48,  -1302,     48,    399,    264,   -222,     21,    -33, &
                   210,    210,   -168,   1533,   -168,    264,   -222,     21,   -222,    210,   1533,   -222,    156,    210, &
                   156,    156,    210,    -33,    156,    210,   1344,   -357,   1749,     21,   3072,     21,   -141,   -141, &
                  1560,     48,    534,   -195,   -195,     21,   1533,   -222,    210,     48,   -384,    210,   -114,   -114, &
                   -33,   -195,   -168,     21,    480,    210,   1749,  -1302,     48,  -1464,   1560,     48,    912,  -1464, &
                    48,     21,   -168,    264,    210,   -195,     -6,    588,   -222,   1533,  -1302,     -6,   -168,    318, &
                   480,    588,    480,    102,     48,   -195,   1560,   -141,    534,   -141,     48,  -1302,   -168,   -168, &
                   156,     -6,     -6,    102,    264,   -168,    399,     -6]
  K1( 562,:) = [   -141,   1560,   -141,    534,     48,   -195,   -168,   -168,     -6,    156,     48,  -1302,   -168,    264, &
                    -6,    399,     -6,    102,   -168,    318,    480,    588,    480,    102,    -33,    210,    210,    156, &
                   156,    156,     21,   -222,    264,   -168,   1533,   -168,    210,    156,   -222,   1533,    210,   -222, &
                   210,    210,   -222,    264,    -33,     21,   -114,   -114,   -195,    -33,   -384,    210,   -195,    534, &
                    48,   1560,   -141,   -141,     48,    210,   -222,   1533,     21,   -195,   3072,     21,   -357,   1344, &
                    21,   1749,   1533,   -222,     -6,  -1302,     -6,    588,  -1464,    912,     48,   1560,  -1464,     48, &
                  -195,    210,    264,   -168,     21,     48,   1749,  -1302,     21,   -168,    210,    480,   1344,   -357, &
                    48,  -1302,     48,    399,   -195,     48,   -141,   -141,   -195,   -141,   -384,    210,    318,   -168, &
                   210,     -6,   -195,    156,     21,   -168,    -33,     -6]
  K1( 563,:) = [     48,   -195,   -195,   -141,   -141,   -141,   -357,   1344,     48,    399,     48,  -1302,     21,   -168, &
                  -195,    156,     -6,    -33,    318,   -168,   -384,    210,     -6,    210,    210,    210,    -33,     21, &
                  -222,    264,    156,    156,    156,    210,    210,    -33,    210,   -222,    156,    210,   1533,   -222, &
                  1533,   -168,   -222,     21,   -168,    264,    318,   -168,    480,    102,    480,    588,   -195,     48, &
                   534,   -141,   1560,   -141,     -6,    102,    264,   -168,    399,     -6,     48,  -1302,   -168,   -168, &
                   156,     -6,     21,   -168,   1749,  -1302,    480,    210,  -1464,     48,    912,  -1464,   1560,     48, &
                    -6,    588,   -222,   1533,  -1302,     -6,     48,     21,   -168,    264,    210,   -195,   -357,   1344, &
                  3072,     21,   1749,     21,   -141,   -141,    534,   -195,   1560,     48,   -384,    210,   -114,   -114, &
                   -33,   -195,   -195,     21,   1533,   -222,    210,     48]
  K1( 564,:) = [   -195,     48,    534,   -141,   1560,   -141,    318,   -168,    480,    102,    480,    588,    264,   -168, &
                    -6,    102,     -6,    399,   -168,   -168,     48,  -1302,     -6,    156,    156,    156,    156,    210, &
                   210,    -33,    210,    210,    -33,     21,   -222,    264,    156,    210,    210,   -222,   -222,   1533, &
                  -222,     21,   1533,   -168,    264,   -168,   -357,   1344,     48,    399,     48,  -1302,     48,   -195, &
                  -195,   -141,   -141,   -141,   -195,    156,     21,   -168,    -33,     -6,   -384,    210,    318,   -168, &
                   210,     -6,   -222,   1533,     -6,    588,     -6,  -1302,    912,  -1464,  -1464,     48,     48,   1560, &
                  1749,  -1302,     21,   -168,    210,    480,   -195,    210,    264,   -168,     21,     48,   -114,   -114, &
                  -384,    210,   -195,    -33,    534,   -195,   -141,   -141,     48,   1560,   3072,     21,   -357,   1344, &
                    21,   1749,     48,    210,   -222,   1533,     21,   -195]
  K1( 565,:) = [     -6,     -6,   1749,   -195,    480,     48,   -222,    264,    912,    156,    534,    156,     21,     21, &
                 -1464,    210,   -195,    -33,    318,   -357,   -195,    156,     48,    210,    588,    102,  -1302,    156, &
                   102,    399,  -1302,    399,    210,    210,    156,    -33,    210,    -33,     21,     21,    210,     21, &
                   588,  -1302,  -1302,    210,    210,     21,   1533,   -168,  -1464,    210,   -141,    210,     -6,     -6, &
                  -195,     48,     -6,   -195,     48,   -222,    264,   -222,    264,     48,   -141,    -33,   -168,   -114, &
                    21,   -195,   -168,   -168,     48,   -222,   -141,     21,    480,     -6,     48,   -195,     -6,   1749, &
                  1560,   1533,   -168,   1533,   -168,   1560,   -141,    264,   -168,   1344,   -168,   -141,   -168,   1344, &
                    48,    156,   -195,    210,    480,     48,     48,   -384,   -384,   3072,   1560,    210,   -168,   -114, &
                  -222,    534,   -141,   -222,    318,   -357,   1533,   -141]
  K1( 566,:) = [    210,    156,     21,    -33,    102,    399,     -6,   -546,    156,  -2004,   -222,    372,     -6,    183, &
                   210,     -6,     21,    183,  -1950,   -195,    210,  -1140,    210,  -3030,   -168,    264,    372,    318, &
                   696,  -2652,    372,  -3084,    -60,   -600,    264,    318,    -60,    372,     -6,    -60,   -168,    372, &
                  -816,    696,    696,    264,    264,  -3084,   -195,   -249,    210,     -6,   1533,  -1518,    -33,    399, &
                    21,    210,    102,    156,   -222,   1506,     -6,    -60,   -492,    264,   -222,    372,    237,     48, &
                   183,    -33,     48,    237,   -222,   1506,   -168,     -6,    210,  -1302,     21,    210,    588,  -1302, &
                  1533, -12291,   -195,  -1950,   1506,   -168,    264,  -2004,  -1464,  -1896,     -6,     21,    -60,     -6, &
                   156,    264,    156,  -1140,    588,  -1302,  -1302,    210,    210,     21,    210,  -1140,    183,     -6, &
                   372,    156,    -33,    372,    -60,     -6,  -1518,    210]
  K1( 567,:) = [   -168,   -168,   1344,   -114,    318,   -357,   1317,   -384,   -222,     -6,   -114,     -6,   -384,    102, &
                  1533,   -195,   -114,     48,   -816,   2640,   1344,     -6,   -357,   -195,  -1464,    237,  -1896,     48, &
                 -1950,   -195,    237,   -249,  -1950,    -60,   -546,    183,     48,   -195,   -195,     -6,     -6,     -6, &
                   -60,     -6,    183,    -60,     -6,     -6,   -384,    102,     21,     -6,   -357,     -6,   -168,   -168, &
                  1533,   -222,    264,     21,    264,     -6,  -1896,    480,    -60,   -222,    318,    -60,   -384,    102, &
                   183,     21,   -384,   -384,   -168,     48,   1344,  -1896,   -168,   1533,   -168,    264,   -222,     21, &
                  -168,   -195,   -384,  -1896,  -1950,   1533,   -168,  -1464,   1317,   -384,    237,   -168,   -384,   -816, &
                  -168,    -60,    318,  -1950,   -168,   1344,   -168,    318,   -114,   -357,   -168,    183,   -384,   -384, &
                  -546,    264,   -168,    237,   -384,    102,   -249,   -168]
  K1( 568,:) = [    318,   -168,   -357,   -114,   -168,   1344,   -384,   -384,    264,   -546,   -168,    183,    102,   -384, &
                  -168,   -249,   -168,    237,   -384,   -816,   -168,    -60,    318,  -1950,    -60,    183,     -6,     -6, &
                   -60,     -6,    183,   -546,    -60,  -1950,   -249,    237,     -6,     -6,     -6,   -195,   -195,     48, &
                 -1950,   -195,    237,  -1464,     48,  -1896,    102,   -384,     21,    183,    318,    -60,     21,    264, &
                  -222,   1533,   -168,   -168,   -222,    -60,    480,  -1896,     -6,    264,   -357,     -6,    102,   -384, &
                    -6,     21,   -384,   1317,   -168,    237,   -168,  -1464,     21,   -222,    264,   -168,   1533,   -168, &
                  1533,  -1950,  -1896,   -384,   -195,   -168,   1344,  -1896,   -384,   -384,     48,   -168,   -816,   2640, &
                  1344,     -6,   -357,   -195,    318,   -357,   -168,   -168,   -114,   1344,   -114,     -6,   -384,   1317, &
                    -6,   -222,   -114,     48,    102,   -384,   -195,   1533]
  K1( 569,:) = [    210,  -1302,     21,    210,    588,  -1302,     -6,    183,    156,    372,    210,  -1140,     -6,    -60, &
                   210,  -1518,    -33,    372,    -60,     -6,    156,    264,    156,  -1140,    264,    696,  -3084,    264, &
                  -816,    696,    318,    264,   -600,    -60,  -3084,    372,    372,   -168,    -60,     -6,    372,    -60, &
                   696,  -2652,    264,   -168,    318,    372,     48,    237,    -33,    183,   -222,    372,    156,    102, &
                   210,     21,    399,    -33,    264,   -492,    -60,     -6,   1506,   -222,   1533,  -1518,   -249,   -195, &
                    -6,    210,  -1896,  -1464,     21,     -6,    264,  -2004,  -1302,    588,    210,     21,  -1302,    210, &
                  -168,   1506,  -1950,   -195, -12291,   1533,   -168,     -6,    237,     48,   1506,   -222,  -1950,   -195, &
                   210,  -1140,    210,  -3030,    102,    399,    156,    210,    -33,     21,   -222,    372,   -546,     -6, &
                 -2004,    156,     21,    183,    183,     -6,     -6,    210]
  K1( 570,:) = [   -384,     48,   3072,   -384,    480,     48,   -114,   -168,    534,   -222,   1560,    210,   -357,    318, &
                  -141,   1533,   -141,   -222,   -168,   1344,     48,    156,   -195,    210,    210,  -1302,     21,    210, &
                   588,  -1302,    -33,    156,    210,    210,    399,  -1302,     21,    210,     21,     21,    -33,    210, &
                   102,    399,    102,    588,    156,  -1302,   -114,   -168,   -195,     21,   -141,    -33,   -195,     -6, &
                    48,   -195,     -6,     -6,     48,    264,   -222,    264,   -222,     48,   -141,    210,   -168,   1533, &
                   210,  -1464,   1344,   -168,   -141,   -168,   -141,    264,   1749,     -6,   -195,     48,     -6,    480, &
                  1560,   -168,   1533,   -168,   1533,   1560,   -141,     21,   -168,   -168,   -222,     48,    318,   -357, &
                  -195,    156,     48,    210,    480,     48,     -6,     -6,   -195,   1749,    534,    156,    264,   -222, &
                   156,    912,   -195,    -33,     21,     21,    210,  -1464]
  K1( 571,:) = [     48,    480,   -195,   1749,     -6,     -6,   -357,    318,     48,    210,   -195,    156,     21,     21, &
                  -195,    -33,  -1464,    210,    264,   -222,    534,    156,    912,    156,    399,    102,    156,  -1302, &
                   102,    588,  -1302,    588,    210,     21,  -1302,    210,    -33,    210,    210,     21,     21,     21, &
                   399,  -1302,    156,    -33,    210,    210,   1344,   -168,   -195,    210,     48,    156,     48,    480, &
                  -384,   3072,     48,   -384,   -141,   -222,    318,   -357,   1533,   -141,   1560,    210,   -168,   -114, &
                  -222,    534,   -168,   -168,   -141,     21,     48,   -222,     -6,    480,     -6,   1749,     48,   -195, &
                  -141,    264,   -168,   1344,   -168,   -141,   1560,   1533,   -168,   1533,   -168,   1560,   -168,   1533, &
                  -141,    210,  -1464,    210,     -6,     -6,     -6,   -195,   -195,     48,   -141,    -33,   -168,   -114, &
                    21,   -195,     48,   -222,    264,   -222,    264,     48]
  K1( 572,:) = [    399,    102,    -33,     21,    156,    210,   -195,  -1950,    210,  -3030,    210,  -1140,    183,     -6, &
                    21,    183,    210,     -6,   -546,     -6,   -222,    372,    156,  -2004,  -2652,    696,    318,    372, &
                   264,   -168,    696,   -816,    264,  -3084,    696,    264,    372,    -60,   -168,    372,     -6,    -60, &
                 -3084,    372,    264,    318,    -60,   -600,     -6,    -60,    156,  -1140,    156,    264,  -1302,    588, &
                   210,     21,  -1302,    210,    -33,    372,    -60,     -6,  -1518,    210,    210,  -1140,    183,     -6, &
                   372,    156,    237,     48,   -168,     -6,   -222,   1506,  -1302,    210,    588,  -1302,     21,    210, &
                   264,  -2004,  -1464,  -1896,     -6,     21,   1533, -12291,   -195,  -1950,   1506,   -168,   -249,   -195, &
                  1533,  -1518,    210,     -6,    399,    -33,    102,    156,     21,    210,   -222,    372,    237,     48, &
                   183,    -33,   -222,   1506,     -6,    -60,   -492,    264]
  K1( 573,:) = [   -357,    318,   -114,   1344,   -168,   -168,   2640,   -816,   -357,   -195,   1344,     -6,    102,   -384, &
                  -114,     48,   1533,   -195,   -384,   1317,   -114,     -6,   -222,     -6,   -195,  -1950,     48,  -1896, &
                   237,  -1464,     -6,    -60,     -6,     -6,    183,    -60,   -195,     48,     -6,     -6,   -195,     -6, &
                  -249,    237,   -546,    183,  -1950,    -60,   -816,   -384,    318,  -1950,   -168,    -60,   1344,   -168, &
                  -114,   -357,   -168,    318,   -168,    237,   -384,    102,   -249,   -168,   -168,    183,   -384,   -384, &
                  -546,    264,   -384,   -384,   1344,  -1896,   -168,     48,   1533,   -168,   -222,     21,   -168,    264, &
                  -168,  -1464,   1317,   -384,    237,   -168,   -168,   -195,   -384,  -1896,  -1950,   1533,    102,   -384, &
                  -357,     -6,     21,     -6,   -168,   -168,    264,     21,   1533,   -222,    318,    -60,   -384,    102, &
                   183,     21,    264,     -6,  -1896,    480,    -60,   -222]
  K1( 574,:) = [   1344,   -168,   -114,   -357,   -168,    318,   -816,   -384,    318,  -1950,   -168,    -60,   -384,    102, &
                  -168,    237,   -168,   -249,   -384,   -384,   -168,    183,    264,   -546,     -6,    -60,     -6,     -6, &
                   183,    -60,   -195,  -1950,     48,  -1896,    237,  -1464,     -6,     -6,   -195,     48,     -6,   -195, &
                  -546,    183,   -249,    237,    -60,  -1950,   2640,   -816,   -357,   -195,   1344,     -6,   -357,    318, &
                  -114,   1344,   -168,   -168,   -114,     48,    102,   -384,   -195,   1533,   -114,     -6,   -384,   1317, &
                    -6,   -222,   1317,   -384,   -168,  -1464,   -168,    237,   -222,     21,   1533,   -168,    264,   -168, &
                  1344,  -1896,   -384,   -384,     48,   -168,   1533,  -1950,  -1896,   -384,   -195,   -168,   -384,    102, &
                   318,    -60,     21,    183,    264,     21,   -168,   -168,   -222,   1533,   -357,     -6,    102,   -384, &
                    -6,     21,   -222,    -60,    480,  -1896,     -6,    264]
  K1( 575,:) = [  -1302,    588,    210,     21,  -1302,    210,     -6,    -60,    156,  -1140,    156,    264,    -60,     -6, &
                   -33,    372,    210,  -1518,    183,     -6,    210,  -1140,    156,    372,    696,   -816,    264,  -3084, &
                   696,    264,  -2652,    696,    318,    372,    264,   -168,   -168,    372,    372,    -60,    -60,     -6, &
                   264,    318,  -3084,    372,   -600,    -60,   -195,  -1950,    210,  -3030,    210,  -1140,    399,    102, &
                   -33,     21,    156,    210,     21,    183,    183,     -6,     -6,    210,   -222,    372,   -546,     -6, &
                 -2004,    156,  -1464,  -1896,    264,  -2004,     21,     -6,    588,  -1302,  -1302,    210,    210,     21, &
                  -168,     -6,    237,     48,   1506,   -222,   -168,   1506,  -1950,   -195, -12291,   1533,    237,     48, &
                  -222,    372,    -33,    183,    102,    156,    399,    -33,    210,     21,   1533,  -1518,   -249,   -195, &
                    -6,    210,    264,   -492,    -60,     -6,   1506,   -222]
  K1( 576,:) = [     48,    480,   -384,   3072,     48,   -384,   1344,   -168,   -195,    210,     48,    156,    318,   -357, &
                  -141,   -222,   -141,   1533,   -168,   -114,   1560,    210,    534,   -222,  -1302,    588,    210,     21, &
                 -1302,    210,    399,    102,    156,  -1302,    102,    588,    210,     21,    -33,    210,     21,     21, &
                   156,    -33,    399,  -1302,    210,    210,   -357,    318,     48,    210,   -195,    156,     48,    480, &
                  -195,   1749,     -6,     -6,   -195,    -33,     21,     21,    210,  -1464,    534,    156,    264,   -222, &
                   156,    912,   -168,   1344,   -141,    264,   -141,   -168,     -6,   1749,     -6,    480,   -195,     48, &
                  -141,     21,   -168,   -168,   -222,     48,   1560,   -168,   1533,   -168,   1533,   1560,   -168,   -114, &
                  -141,    -33,   -195,     21,     -6,   -195,     -6,     -6,     48,   -195,   -141,    210,   -168,   1533, &
                   210,  -1464,     48,    264,   -222,    264,   -222,     48]
  K1( 577,:) = [   -168,   -168,    264,     21,   1533,   -222,    102,   -384,   -357,     -6,     21,     -6,   -384,    102, &
                   318,    -60,     21,    183,  -1896,    480,    264,     -6,   -222,    -60,   -249,    237,   -546,    183, &
                 -1950,    -60,    237,  -1464,  -1950,   -195,  -1896,     48,    183,    -60,    -60,     -6,     -6,     -6, &
                  -195,     -6,     48,   -195,     -6,     -6,   -384,   1317,   -114,     -6,   -222,     -6,   -168,   -168, &
                   318,   -357,   1344,   -114,   1344,     -6,   -816,   2640,   -195,   -357,   1533,   -195,   -384,    102, &
                    48,   -114,   -384,   -384,   -168,    183,    264,   -546,   -168,    318,   -168,   1344,   -357,   -114, &
                  -168,    -60,   -384,   -816,  -1950,    318,   -168,   -249,    102,   -384,    237,   -168,   -384,  -1896, &
                  -168,   -195,   1533,  -1950,   -168,    264,   -168,   1533,     21,   -222,   -168,     48,   -384,   -384, &
                 -1896,   1344,   -168,    237,   -384,   1317,  -1464,   -168]
  K1( 578,:) = [    264,     21,   -168,   -168,   -222,   1533,   -384,    102,    318,    -60,     21,    183,    102,   -384, &
                  -357,     -6,     21,     -6,    480,  -1896,   -222,    -60,    264,     -6,   -546,    183,   -249,    237, &
                   -60,  -1950,    183,    -60,    -60,     -6,     -6,     -6,    237,  -1464,  -1950,   -195,  -1896,     48, &
                    -6,   -195,     -6,     -6,     48,   -195,   -384,   -384,   -168,    183,    264,   -546,   -168,    318, &
                  -168,   1344,   -357,   -114,   -168,    -60,   -384,   -816,  -1950,    318,   -168,   -249,    102,   -384, &
                   237,   -168,   -384,   1317,   -114,     -6,   -222,     -6,   -168,   -168,    318,   -357,   1344,   -114, &
                  1344,     -6,   -816,   2640,   -195,   -357,   1533,   -195,   -384,    102,     48,   -114,  -1896,   -384, &
                  1533,  -1950,   -168,   -195,    264,   -168,     21,   -222,   -168,   1533,   -168,    237,   -384,   1317, &
                 -1464,   -168,   -168,     48,   -384,   -384,  -1896,   1344]
  K1( 579,:) = [     -6,     -6,     -6,   -195,   -195,     48,   -168,   1533,   -141,    210,  -1464,    210,   -168,   -114, &
                  -141,    -33,   -195,     21,    264,   -222,     48,   -222,     48,    264,    399,  -1302,    156,    -33, &
                   210,    210,    102,    588,    102,    399,  -1302,    156,  -1302,    210,    588,  -1302,     21,    210, &
                    21,     21,    210,    -33,     21,    210,    264,   -222,    534,    156,    912,    156,     -6,     -6, &
                   480,     48,   1749,   -195,   -195,    156,    318,   -357,    210,     48,  -1464,    210,     21,     21, &
                   -33,   -195,   -168,   -114,   1560,    210,    534,   -222,     48,   -384,    480,     48,   3072,   -384, &
                    48,    156,   -168,   1344,    210,   -195,   -141,   1533,   -357,    318,   -222,   -141,   -168,   1533, &
                  1560,   1533,   1560,   -168,     48,   -195,    480,     -6,   1749,     -6,     48,   -222,   -168,   -168, &
                    21,   -141,   -141,   -168,   1344,   -168,    264,   -141]
  K1( 580,:) = [    399,    -33,    102,    156,     21,    210,   -249,   -195,   1533,  -1518,    210,     -6,    237,     48, &
                  -222,    372,    -33,    183,     -6,    -60,   -222,   1506,    264,   -492,  -3084,    372,    264,    318, &
                   -60,   -600,    264,   -168,    696,  -2652,    372,    318,    696,    264,   -816,    696,  -3084,    264, &
                    -6,    -60,    -60,    372,    372,   -168,   -546,     -6,   -222,    372,    156,  -2004,    156,    210, &
                   102,    399,     21,    -33,    210,  -1140,  -1950,   -195,  -3030,    210,    210,     -6,     -6,    183, &
                   183,     21,    183,     -6,    210,  -1140,    156,    372,  -1302,    210,    588,  -1302,     21,    210, &
                   156,    264,    -60,     -6,  -1140,    156,    210,  -1518,     -6,    -60,    372,    -33,   -195,  -1950, &
                  1533, -12291,   -168,   1506,     21,    210,    210,  -1302,  -1302,    588,   -222,   1506,     48,    237, &
                    -6,   -168,     21,     -6,  -1896,  -1464,  -2004,    264]
  K1( 581,:) = [     -6,   -195,     -6,     -6,     48,   -195,   -168,   -114,   -141,    -33,   -195,     21,   -168,   1533, &
                  -141,    210,  -1464,    210,   -222,    264,     48,    264,     48,   -222,    156,    -33,    399,  -1302, &
                   210,    210,  -1302,    210,    588,  -1302,     21,    210,    102,    588,    102,    399,  -1302,    156, &
                    21,     21,     21,    210,    210,    -33,   -168,   -114,   1560,    210,    534,   -222,     48,   -384, &
                   480,     48,   3072,   -384,     48,    156,   -168,   1344,    210,   -195,   -141,   1533,   -357,    318, &
                  -222,   -141,    264,   -222,    534,    156,    912,    156,     -6,     -6,    480,     48,   1749,   -195, &
                  -195,    156,    318,   -357,    210,     48,  -1464,    210,     21,     21,    -33,   -195,   1533,   -168, &
                  1560,   -168,   1560,   1533,   -195,     48,   1749,     -6,    480,     -6,   -141,   -168,   1344,   -168, &
                   264,   -141,     48,   -222,   -168,   -168,     21,   -141]
  K1( 582,:) = [    102,    156,    399,    -33,    210,     21,    237,     48,   -222,    372,    -33,    183,   -249,   -195, &
                  1533,  -1518,    210,     -6,    -60,     -6,    264,   -492,   -222,   1506,    264,    318,  -3084,    372, &
                  -600,    -60,    696,    264,   -816,    696,  -3084,    264,    264,   -168,    696,  -2652,    372,    318, &
                   -60,     -6,    372,   -168,    -60,    372,    183,     -6,    210,  -1140,    156,    372,  -1302,    210, &
                   588,  -1302,     21,    210,    156,    264,    -60,     -6,  -1140,    156,    210,  -1518,     -6,    -60, &
                   372,    -33,   -546,     -6,   -222,    372,    156,  -2004,    156,    210,    102,    399,     21,    -33, &
                   210,  -1140,  -1950,   -195,  -3030,    210,    210,     -6,     -6,    183,    183,     21,  -1950,   -195, &
                  -168,   1506,   1533, -12291,    210,     21,  -1302,    588,    210,  -1302,     21,     -6,  -1896,  -1464, &
                 -2004,    264,   -222,   1506,     48,    237,     -6,   -168]
  K1( 583,:) = [   -141,   -141,    534,   -195,   1560,     48,   -357,   1344,   3072,     21,   1749,     21,   -114,   -114, &
                  -384,    210,   -195,    -33,   1533,   -222,   -195,     21,     48,    210,   1533,   -168,   -222,     21, &
                  -168,    264,   -222,    264,    210,    210,     21,    -33,    210,    -33,    156,    156,    210,    156, &
                  1533,   -222,   -222,    210,    210,    156,    318,   -168,   -384,    210,     -6,    210,   -141,   -141, &
                  -195,     48,   -141,   -195,     48,  -1302,   1344,   -357,    399,     48,     -6,    -33,   -168,     21, &
                   156,   -195,   -168,   -168,     48,  -1302,     -6,    156,   1560,   -141,     48,   -195,   -141,    534, &
                   480,    588,   -168,    318,    102,    480,     -6,    399,   -168,    264,    102,     -6,   -168,    264, &
                    48,     21,   -195,    210,   1560,     48,     48,  -1464,  -1464,    912,    480,    210,   -168,     21, &
                 -1302,   1749,     -6,  -1302,   1533,   -222,    588,     -6]
  K1( 584,:) = [    534,   -195,   -141,   -141,     48,   1560,   -114,   -114,   -384,    210,   -195,    -33,   -357,   1344, &
                  3072,     21,   1749,     21,   -222,   1533,     48,    210,   -195,     21,   -222,     21,   1533,   -168, &
                   264,   -168,    210,    -33,    156,    156,    210,    156,   -222,    264,    210,    210,     21,    -33, &
                  -222,   1533,    210,    156,   -222,    210,   -168,   -168,     48,  -1302,     -6,    156,   1560,   -141, &
                    48,   -195,   -141,    534,    480,    588,   -168,    318,    102,    480,     -6,    399,   -168,    264, &
                   102,     -6,    318,   -168,   -384,    210,     -6,    210,   -141,   -141,   -195,     48,   -141,   -195, &
                    48,  -1302,   1344,   -357,    399,     48,     -6,    -33,   -168,     21,    156,   -195,    264,   -168, &
                  -195,    210,     48,     21,     48,   1560,  -1464,    912,     48,  -1464,     -6,  -1302,   1533,   -222, &
                   588,     -6,    480,    210,   -168,     21,  -1302,   1749]
  K1( 585,:) = [   -141,   -141,   -195,     48,   -141,   -195,    318,   -168,   -384,    210,     -6,    210,   1344,   -357, &
                    48,  -1302,     48,    399,   -168,     21,     -6,    -33,   -195,    156,   -222,    264,    210,    210, &
                    21,    -33,   1533,   -168,   -222,     21,   -168,    264,    156,    156,    210,    -33,    156,    210, &
                  -222,    210,   1533,   -222,    156,    210,   -357,   1344,   3072,     21,   1749,     21,   -141,   -141, &
                   534,   -195,   1560,     48,   -384,    210,   -114,   -114,    -33,   -195,   -195,     21,   1533,   -222, &
                   210,     48,   -168,    318,    480,    588,    480,    102,     48,   -195,   1560,   -141,    534,   -141, &
                    48,  -1302,   -168,   -168,    156,     -6,     -6,    102,    264,   -168,    399,     -6,   -168,     21, &
                   480,    210,   1749,  -1302,     48,  -1464,   1560,     48,    912,  -1464,     48,     21,   -168,    264, &
                   210,   -195,     -6,    588,   -222,   1533,  -1302,     -6]
  K1( 586,:) = [   1560,   -141,     48,   -195,   -141,    534,   -168,   -168,     48,  -1302,     -6,    156,   -168,    318, &
                   480,    588,    480,    102,   -168,    264,     -6,    399,     -6,    102,    210,    -33,    156,    156, &
                   210,    156,   -222,     21,   1533,   -168,    264,   -168,    210,    210,   -222,    264,    -33,     21, &
                   210,    156,   -222,   1533,    210,   -222,   -114,   -114,   -384,    210,   -195,    -33,    534,   -195, &
                  -141,   -141,     48,   1560,   3072,     21,   -357,   1344,     21,   1749,     48,    210,   -222,   1533, &
                    21,   -195,   1344,   -357,     48,  -1302,     48,    399,   -195,     48,   -141,   -141,   -195,   -141, &
                  -384,    210,    318,   -168,    210,     -6,   -195,    156,     21,   -168,    -33,     -6,   1533,   -222, &
                    -6,  -1302,     -6,    588,  -1464,    912,     48,   1560,  -1464,     48,   -195,    210,    264,   -168, &
                    21,     48,   1749,  -1302,     21,   -168,    210,    480]
  K1( 587,:) = [   -195,     48,   -141,   -141,   -195,   -141,   1344,   -357,     48,  -1302,     48,    399,    318,   -168, &
                  -384,    210,     -6,    210,     21,   -168,   -195,    156,     -6,    -33,    210,    210,   -222,    264, &
                   -33,     21,    156,    156,    210,    -33,    156,    210,   1533,   -168,   -222,     21,   -168,    264, &
                   210,   -222,    156,    210,   1533,   -222,   -168,    318,    480,    588,    480,    102,     48,   -195, &
                  1560,   -141,    534,   -141,     48,  -1302,   -168,   -168,    156,     -6,     -6,    102,    264,   -168, &
                   399,     -6,   -357,   1344,   3072,     21,   1749,     21,   -141,   -141,    534,   -195,   1560,     48, &
                  -384,    210,   -114,   -114,    -33,   -195,   -195,     21,   1533,   -222,    210,     48,     21,   -168, &
                  1749,  -1302,    480,    210,  -1464,     48,    912,  -1464,   1560,     48,     -6,    588,   -222,   1533, &
                 -1302,     -6,     48,     21,   -168,    264,    210,   -195]
  K1( 588,:) = [     48,   -195,   1560,   -141,    534,   -141,   -168,    318,    480,    588,    480,    102,   -168,   -168, &
                    48,  -1302,     -6,    156,    264,   -168,     -6,    102,     -6,    399,    156,    156,    210,    -33, &
                   156,    210,    210,    210,   -222,    264,    -33,     21,   -222,     21,   1533,   -168,    264,   -168, &
                   156,    210,    210,   -222,   -222,   1533,   1344,   -357,     48,  -1302,     48,    399,   -195,     48, &
                  -141,   -141,   -195,   -141,   -384,    210,    318,   -168,    210,     -6,   -195,    156,     21,   -168, &
                   -33,     -6,   -114,   -114,   -384,    210,   -195,    -33,    534,   -195,   -141,   -141,     48,   1560, &
                  3072,     21,   -357,   1344,     21,   1749,     48,    210,   -222,   1533,     21,   -195,   -222,   1533, &
                    -6,    588,     -6,  -1302,    912,  -1464,  -1464,     48,     48,   1560,   1749,  -1302,     21,   -168, &
                   210,    480,   -195,    210,    264,   -168,     21,     48]
  K1( 589,:) = [     -6,     -6,    480,     48,   1749,   -195,    264,   -222,    534,    156,    912,    156,    318,   -357, &
                  -195,    156,     48,    210,     21,     21,  -1464,    210,   -195,    -33,    102,    588,    102,    399, &
                 -1302,    156,    399,  -1302,    156,    -33,    210,    210,    588,  -1302,  -1302,    210,    210,     21, &
                   210,    -33,     21,     21,    210,     21,   -168,   1533,   -141,    210,  -1464,    210,     -6,     -6, &
                    -6,   -195,   -195,     48,   -141,    -33,   -168,   -114,     21,   -195,     48,   -222,    264,   -222, &
                   264,     48,   -168,   1344,     48,    156,   -195,    210,    480,     48,     48,   -384,   -384,   3072, &
                  1560,    210,   -168,   -114,   -222,    534,   -141,   -222,    318,   -357,   1533,   -141,   -168,   -168, &
                    48,   -222,   -141,     21,    480,     -6,     48,   -195,     -6,   1749,   1560,   1533,   -168,   1533, &
                  -168,   1560,   -141,    264,   -168,   1344,   -168,   -141]
  K1( 590,:) = [    156,    210,    102,    399,     21,    -33,   -546,     -6,   -222,    372,    156,  -2004,  -1950,   -195, &
                   210,  -1140,    210,  -3030,     -6,    183,    210,     -6,     21,    183,    264,   -168,    696,  -2652, &
                   372,    318,  -3084,    372,    264,    318,    -60,   -600,   -816,    696,    696,    264,    264,  -3084, &
                   -60,    372,     -6,    -60,   -168,    372,   -249,   -195,   1533,  -1518,    210,     -6,    399,    -33, &
                   102,    156,     21,    210,   -222,    372,    237,     48,    183,    -33,   -222,   1506,     -6,    -60, &
                  -492,    264,    -60,     -6,    156,    264,    156,  -1140,    588,  -1302,  -1302,    210,    210,     21, &
                   210,  -1140,    183,     -6,    372,    156,    -33,    372,    -60,     -6,  -1518,    210,     48,    237, &
                  -222,   1506,   -168,     -6,    210,  -1302,     21,    210,    588,  -1302,   1533, -12291,   -195,  -1950, &
                  1506,   -168,    264,  -2004,  -1464,  -1896,     -6,     21]
  K1( 591,:) = [   -168,   -168,    318,   -357,   1344,   -114,   -384,   1317,   -114,     -6,   -222,     -6,   -816,   2640, &
                  1344,     -6,   -357,   -195,   -384,    102,   1533,   -195,   -114,     48,    237,  -1464,  -1950,   -195, &
                 -1896,     48,   -249,    237,   -546,    183,  -1950,    -60,    -60,     -6,    183,    -60,     -6,     -6, &
                    48,   -195,   -195,     -6,     -6,     -6,    102,   -384,   -357,     -6,     21,     -6,   -168,   -168, &
                   264,     21,   1533,   -222,    318,    -60,   -384,    102,    183,     21,    264,     -6,  -1896,    480, &
                   -60,   -222,   -384,   -816,   -168,    -60,    318,  -1950,   -168,   1344,   -168,    318,   -114,   -357, &
                  -168,    183,   -384,   -384,   -546,    264,   -168,    237,   -384,    102,   -249,   -168,   -384,   -384, &
                  -168,     48,   1344,  -1896,   -168,   1533,   -168,    264,   -222,     21,   -168,   -195,   -384,  -1896, &
                 -1950,   1533,   -168,  -1464,   1317,   -384,    237,   -168]
  K1( 592,:) = [   -168,    318,   -168,   1344,   -357,   -114,   -384,   -384,   -168,    183,    264,   -546,   -384,   -816, &
                  -168,    -60,    318,  -1950,    102,   -384,   -168,   -249,   -168,    237,    183,    -60,    -60,     -6, &
                    -6,     -6,   -546,    183,   -249,    237,    -60,  -1950,  -1950,   -195,    237,  -1464,     48,  -1896, &
                    -6,     -6,     -6,   -195,   -195,     48,   -384,    102,    318,    -60,     21,    183,    264,     21, &
                  -168,   -168,   -222,   1533,   -357,     -6,    102,   -384,     -6,     21,   -222,    -60,    480,  -1896, &
                    -6,    264,   -816,   2640,   1344,     -6,   -357,   -195,    318,   -357,   -168,   -168,   -114,   1344, &
                  -114,     -6,   -384,   1317,     -6,   -222,   -114,     48,    102,   -384,   -195,   1533,   -384,   1317, &
                  -168,    237,   -168,  -1464,     21,   -222,    264,   -168,   1533,   -168,   1533,  -1950,  -1896,   -384, &
                  -195,   -168,   1344,  -1896,   -384,   -384,     48,   -168]
  K1( 593,:) = [  -1302,    210,    588,  -1302,     21,    210,    183,     -6,    210,  -1140,    156,    372,    -60,     -6, &
                   156,    264,    156,  -1140,     -6,    -60,    210,  -1518,    -33,    372,    696,    264,   -816,    696, &
                 -3084,    264,    264,    318,  -3084,    372,   -600,    -60,    696,  -2652,    264,   -168,    318,    372, &
                   372,   -168,    -60,     -6,    372,    -60,    237,     48,   -222,    372,    -33,    183,    102,    156, &
                   399,    -33,    210,     21,   1533,  -1518,   -249,   -195,     -6,    210,    264,   -492,    -60,     -6, &
                  1506,   -222,  -1950,   -195,    210,  -1140,    210,  -3030,    102,    399,    156,    210,    -33,     21, &
                  -222,    372,   -546,     -6,  -2004,    156,     21,    183,    183,     -6,     -6,    210,  -1896,  -1464, &
                    21,     -6,    264,  -2004,  -1302,    588,    210,     21,  -1302,    210,   -168,   1506,  -1950,   -195, &
                -12291,   1533,   -168,     -6,    237,     48,   1506,   -222]
  K1( 594,:) = [     48,   -384,    480,     48,   3072,   -384,   -168,   -114,   1560,    210,    534,   -222,   -168,   1344, &
                    48,    156,   -195,    210,   -357,    318,   -141,   1533,   -141,   -222,  -1302,    210,    588,  -1302, &
                    21,    210,    156,    -33,    399,  -1302,    210,    210,    102,    399,    102,    588,    156,  -1302, &
                    21,    210,     21,     21,    -33,    210,   -168,   -114,   -141,    -33,   -195,     21,     -6,   -195, &
                    -6,     -6,     48,   -195,   -141,    210,   -168,   1533,    210,  -1464,     48,    264,   -222,    264, &
                  -222,     48,    318,   -357,   -195,    156,     48,    210,    480,     48,     -6,     -6,   -195,   1749, &
                   534,    156,    264,   -222,    156,    912,   -195,    -33,     21,     21,    210,  -1464,   1344,   -168, &
                  -141,   -168,   -141,    264,   1749,     -6,   -195,     48,     -6,    480,   1560,   -168,   1533,   -168, &
                  1533,   1560,   -141,     21,   -168,   -168,   -222,     48]
  K1( 595,:) = [    480,     48,     -6,     -6,   -195,   1749,    318,   -357,   -195,    156,     48,    210,    264,   -222, &
                   534,    156,    912,    156,     21,     21,   -195,    -33,  -1464,    210,    102,    399,    102,    588, &
                   156,  -1302,    588,  -1302,  -1302,    210,    210,     21,    399,  -1302,    156,    -33,    210,    210, &
                   -33,    210,    210,     21,     21,     21,   -168,   1344,     48,    156,   -195,    210,    480,     48, &
                    48,   -384,   -384,   3072,   1560,    210,   -168,   -114,   -222,    534,   -141,   -222,    318,   -357, &
                  1533,   -141,   -168,   1533,   -141,    210,  -1464,    210,     -6,     -6,     -6,   -195,   -195,     48, &
                  -141,    -33,   -168,   -114,     21,   -195,     48,   -222,    264,   -222,    264,     48,   -168,   -168, &
                  -141,     21,     48,   -222,     -6,    480,     -6,   1749,     48,   -195,   -141,    264,   -168,   1344, &
                  -168,   -141,   1560,   1533,   -168,   1533,   -168,   1560]
  K1( 596,:) = [    102,    399,    156,    210,    -33,     21,  -1950,   -195,    210,  -1140,    210,  -3030,   -546,     -6, &
                  -222,    372,    156,  -2004,    183,     -6,     21,    183,    210,     -6,    696,  -2652,    264,   -168, &
                   318,    372,   -816,    696,    696,    264,    264,  -3084,  -3084,    372,    264,    318,    -60,   -600, &
                   372,    -60,   -168,    372,     -6,    -60,    -60,     -6,    156,    264,    156,  -1140,    588,  -1302, &
                 -1302,    210,    210,     21,    210,  -1140,    183,     -6,    372,    156,    -33,    372,    -60,     -6, &
                 -1518,    210,   -249,   -195,   1533,  -1518,    210,     -6,    399,    -33,    102,    156,     21,    210, &
                  -222,    372,    237,     48,    183,    -33,   -222,   1506,     -6,    -60,   -492,    264,    237,     48, &
                  -168,     -6,   -222,   1506,  -1302,    210,    588,  -1302,     21,    210,    264,  -2004,  -1464,  -1896, &
                    -6,     21,   1533, -12291,   -195,  -1950,   1506,   -168]
  K1( 597,:) = [    318,   -357,   -168,   -168,   -114,   1344,   -816,   2640,   1344,     -6,   -357,   -195,   -384,   1317, &
                  -114,     -6,   -222,     -6,    102,   -384,   -114,     48,   1533,   -195,  -1950,   -195,    237,  -1464, &
                    48,  -1896,    -60,     -6,    183,    -60,     -6,     -6,   -249,    237,   -546,    183,  -1950,    -60, &
                  -195,     48,     -6,     -6,   -195,     -6,   -384,   -816,   -168,    -60,    318,  -1950,   -168,   1344, &
                  -168,    318,   -114,   -357,   -168,    183,   -384,   -384,   -546,    264,   -168,    237,   -384,    102, &
                  -249,   -168,    102,   -384,   -357,     -6,     21,     -6,   -168,   -168,    264,     21,   1533,   -222, &
                   318,    -60,   -384,    102,    183,     21,    264,     -6,  -1896,    480,    -60,   -222,   -384,   -384, &
                  1344,  -1896,   -168,     48,   1533,   -168,   -222,     21,   -168,    264,   -168,  -1464,   1317,   -384, &
                   237,   -168,   -168,   -195,   -384,  -1896,  -1950,   1533]
  K1( 598,:) = [   -168,   1344,   -168,    318,   -114,   -357,   -384,   -816,   -168,    -60,    318,  -1950,   -384,   -384, &
                  -168,    183,    264,   -546,   -384,    102,   -168,    237,   -168,   -249,    -60,     -6,    183,    -60, &
                    -6,     -6,  -1950,   -195,    237,  -1464,     48,  -1896,   -546,    183,   -249,    237,    -60,  -1950, &
                    -6,     -6,   -195,     48,     -6,   -195,   -816,   2640,   1344,     -6,   -357,   -195,    318,   -357, &
                  -168,   -168,   -114,   1344,   -114,     -6,   -384,   1317,     -6,   -222,   -114,     48,    102,   -384, &
                  -195,   1533,   -384,    102,    318,    -60,     21,    183,    264,     21,   -168,   -168,   -222,   1533, &
                  -357,     -6,    102,   -384,     -6,     21,   -222,    -60,    480,  -1896,     -6,    264,   1317,   -384, &
                  -168,  -1464,   -168,    237,   -222,     21,   1533,   -168,    264,   -168,   1344,  -1896,   -384,   -384, &
                    48,   -168,   1533,  -1950,  -1896,   -384,   -195,   -168]
  K1( 599,:) = [    588,  -1302,  -1302,    210,    210,     21,    -60,     -6,    156,    264,    156,  -1140,    183,     -6, &
                   210,  -1140,    156,    372,    -60,     -6,    -33,    372,    210,  -1518,   -816,    696,    696,    264, &
                   264,  -3084,    696,  -2652,    264,   -168,    318,    372,    264,    318,  -3084,    372,   -600,    -60, &
                  -168,    372,    372,    -60,    -60,     -6,  -1950,   -195,    210,  -1140,    210,  -3030,    102,    399, &
                   156,    210,    -33,     21,   -222,    372,   -546,     -6,  -2004,    156,     21,    183,    183,     -6, &
                    -6,    210,    237,     48,   -222,    372,    -33,    183,    102,    156,    399,    -33,    210,     21, &
                  1533,  -1518,   -249,   -195,     -6,    210,    264,   -492,    -60,     -6,   1506,   -222,  -1464,  -1896, &
                   264,  -2004,     21,     -6,    588,  -1302,  -1302,    210,    210,     21,   -168,     -6,    237,     48, &
                  1506,   -222,   -168,   1506,  -1950,   -195, -12291,   1533]
  K1( 600,:) = [    480,     48,     48,   -384,   -384,   3072,   -168,   1344,     48,    156,   -195,    210,   -168,   -114, &
                  1560,    210,    534,   -222,    318,   -357,   -141,   -222,   -141,   1533,    588,  -1302,  -1302,    210, &
                   210,     21,    102,    399,    102,    588,    156,  -1302,    156,    -33,    399,  -1302,    210,    210, &
                   210,     21,    -33,    210,     21,     21,    318,   -357,   -195,    156,     48,    210,    480,     48, &
                    -6,     -6,   -195,   1749,    534,    156,    264,   -222,    156,    912,   -195,    -33,     21,     21, &
                   210,  -1464,   -168,   -114,   -141,    -33,   -195,     21,     -6,   -195,     -6,     -6,     48,   -195, &
                  -141,    210,   -168,   1533,    210,  -1464,     48,    264,   -222,    264,   -222,     48,   -168,   1344, &
                  -141,    264,   -141,   -168,     -6,   1749,     -6,    480,   -195,     48,   -141,     21,   -168,   -168, &
                  -222,     48,   1560,   -168,   1533,   -168,   1533,   1560]
  K1( 601,:) = [ -12291,   1506,   1506,     -6,     -6,  -2004,   1533,   -222,   -195,     21,     48,    210,   -168,     21, &
                 -1950,    210,  -1896,  -1302,   -168,    264,    237,  -1302,  -1464,    588,     -6,    -60,    -60,    372, &
                   372,   -168,     21,    210,   -195,   1533,     48,   -222,     21,    -33,     -6,   -222,   -195,    210, &
                    21,    210,     -6,    210,     -6,    156,  -1518,    372,    210,     -6,    -33,    -60,  -3084,    264, &
                   399,   -249,    156,   -546,  -3030,    210,  -2652,    399,  -1518,  -3084,    183,    -33,    318,    156, &
                   372,    264,     -6,    183,    210,     -6,     21,    183,    372,    318,  -1302,    237,    -33,    183, &
                 -1140,    156,    696,    102,    372,    264,     -6,    210,    372,  -1302,  -1140,    696,   1506,   -492, &
                  -222,     -6,    264,    -60,    -60,   -600,    210,  -1950,    210,    -60,    372,    156,    264,    102, &
                 -1140,    696,  -2004,    156,   -168,    588,    264,   -816]
  K1( 602,:) = [   1506, -12291,     -6,  -2004,   1506,     -6,   -222,   1533,     48,    210,   -195,     21,   -168,    264, &
                   237,  -1302,  -1464,    588,   -168,     21,  -1950,    210,  -1896,  -1302,    -60,     -6,    372,   -168, &
                   -60,    372,    210,     21,     48,   -222,   -195,   1533,     21,    210,     -6,    210,     -6,    156, &
                    21,    -33,     -6,   -222,   -195,    210,    372,  -1518,    -33,    -60,    210,     -6,    264,  -3084, &
                   156,   -546,    399,   -249,    183,    -33,    318,    156,    372,    264,  -3030,    210,  -2652,    399, &
                 -1518,  -3084,   1506,   -492,   -222,     -6,    264,    -60,    -60,   -600,    210,  -1950,    210,    -60, &
                   372,    156,    264,    102,  -1140,    696,  -2004,    156,   -168,    588,    264,   -816,     -6,    183, &
                   210,     -6,     21,    183,    372,    318,  -1302,    237,    -33,    183,  -1140,    156,    696,    102, &
                   372,    264,     -6,    210,    372,  -1302,  -1140,    696]
  K1( 603,:) = [   1506,     -6, -12291,   1506,  -2004,     -6,   -168,     21,  -1950,    210,  -1896,  -1302,   1533,   -222, &
                  -195,     21,     48,    210,    264,   -168,  -1464,    588,    237,  -1302,    -60,    372,     -6,    -60, &
                  -168,    372,     21,    -33,     -6,   -222,   -195,    210,     21,    210,   -195,   1533,     48,   -222, &
                   210,     21,     -6,    156,     -6,    210,     -6,    183,    210,     -6,     21,    183,    372,    318, &
                 -1302,    237,    -33,    183,  -1140,    156,    696,    102,    372,    264,     -6,    210,    372,  -1302, &
                 -1140,    696,  -1518,    372,    210,     -6,    -33,    -60,  -3084,    264,    399,   -249,    156,   -546, &
                 -3030,    210,  -2652,    399,  -1518,  -3084,    183,    -33,    318,    156,    372,    264,   -492,   1506, &
                   264,    -60,   -222,     -6,   -600,    -60,    210,    -60,    210,  -1950,  -2004,    156,   -168,    588, &
                   264,   -816,    372,    156,    264,    102,  -1140,    696]
  K1( 604,:) = [     -6,  -2004,   1506, -12291,     -6,   1506,   -168,    264,    237,  -1302,  -1464,    588,   -222,   1533, &
                    48,    210,   -195,     21,     21,   -168,  -1896,  -1302,  -1950,    210,    372,   -168,    -60,     -6, &
                   372,    -60,     21,    210,     -6,    210,     -6,    156,    210,     21,     48,   -222,   -195,   1533, &
                   -33,     21,   -195,    210,     -6,   -222,   1506,   -492,   -222,     -6,    264,    -60,    -60,   -600, &
                   210,  -1950,    210,    -60,    372,    156,    264,    102,  -1140,    696,  -2004,    156,   -168,    588, &
                   264,   -816,    372,  -1518,    -33,    -60,    210,     -6,    264,  -3084,    156,   -546,    399,   -249, &
                   183,    -33,    318,    156,    372,    264,  -3030,    210,  -2652,    399,  -1518,  -3084,    183,     -6, &
                    21,    183,    210,     -6,    318,    372,    -33,    183,  -1302,    237,     -6,    210,    372,  -1302, &
                 -1140,    696,  -1140,    156,    696,    102,    372,    264]
  K1( 605,:) = [     -6,   1506,  -2004,     -6, -12291,   1506,     21,   -168,  -1896,  -1302,  -1950,    210,    264,   -168, &
                 -1464,    588,    237,  -1302,   1533,   -222,   -195,     21,     48,    210,    372,    -60,   -168,    372, &
                    -6,    -60,    -33,     21,   -195,    210,     -6,   -222,    210,     21,     -6,    156,     -6,    210, &
                    21,    210,   -195,   1533,     48,   -222,    183,     -6,     21,    183,    210,     -6,    318,    372, &
                   -33,    183,  -1302,    237,     -6,    210,    372,  -1302,  -1140,    696,  -1140,    156,    696,    102, &
                   372,    264,   -492,   1506,    264,    -60,   -222,     -6,   -600,    -60,    210,    -60,    210,  -1950, &
                 -2004,    156,   -168,    588,    264,   -816,    372,    156,    264,    102,  -1140,    696,  -1518,    372, &
                   210,     -6,    -33,    -60,  -3084,    264,    399,   -249,    156,   -546,  -3030,    210,  -2652,    399, &
                 -1518,  -3084,    183,    -33,    318,    156,    372,    264]
  K1( 606,:) = [  -2004,     -6,     -6,   1506,   1506, -12291,    264,   -168,  -1464,    588,    237,  -1302,     21,   -168, &
                 -1896,  -1302,  -1950,    210,   -222,   1533,     48,    210,   -195,     21,   -168,    372,    372,    -60, &
                   -60,     -6,    210,     21,     -6,    156,     -6,    210,    -33,     21,   -195,    210,     -6,   -222, &
                   210,     21,     48,   -222,   -195,   1533,   -492,   1506,    264,    -60,   -222,     -6,   -600,    -60, &
                   210,    -60,    210,  -1950,  -2004,    156,   -168,    588,    264,   -816,    372,    156,    264,    102, &
                 -1140,    696,    183,     -6,     21,    183,    210,     -6,    318,    372,    -33,    183,  -1302,    237, &
                    -6,    210,    372,  -1302,  -1140,    696,  -1140,    156,    696,    102,    372,    264,    372,  -1518, &
                   -33,    -60,    210,     -6,    264,  -3084,    156,   -546,    399,   -249,    183,    -33,    318,    156, &
                   372,    264,  -3030,    210,  -2652,    399,  -1518,  -3084]
  K1( 607,:) = [   1533,   -222,   -168,   -168,     21,    264,   1560,     48,   -168,     48,   -168,    480,   1560,   -141, &
                  1533,   -195,   1344,   1749,   -141,   -141,   -168,     -6,   -168,     -6,     21,    210,     21,     21, &
                   -33,    210,   3072,   -384,   -357,   -141,   -114,    534,   1749,   -195,   1344,   -141,   1533,   1560, &
                  -195,     48,   -114,   -195,   -222,     48,   1533,   -222,   -141,   -357,   -141,    318,     21,    210, &
                    48,   -168,   -195,    264,    210,     48,    399,     -6,    210,    399,     21,   -195,    -33,     -6, &
                   156,    102,    210,    -33,  -1464,     21,   -195,     21,  -1302,    156,     48,   -168,     -6,   -168, &
                   210,   -195,  -1302,     -6,    -33,    156,    210,  -1464,  -1302,     48,    210,  -1302,   -222,    264, &
                    48,    264,     48,   -222,    210,    210,   -384,    318,     -6,   -168,   -222,    534,    210,    480, &
                   156,    102,    156,    912,    588,    480,    156,    588]
  K1( 608,:) = [   -222,   1533,     21,    264,   -168,   -168,     48,   1560,   -168,    480,   -168,     48,   -141,   -141, &
                  -168,     -6,   -168,     -6,   1560,   -141,   1533,   -195,   1344,   1749,    210,     21,    -33,    210, &
                    21,     21,   -384,   3072,   -114,    534,   -357,   -141,   -195,     48,   -114,   -195,   -222,     48, &
                  1749,   -195,   1344,   -141,   1533,   1560,   -222,   1533,   -141,    318,   -141,   -357,    210,     21, &
                  -195,    264,     48,   -168,     21,   -195,    -33,     -6,    156,    102,    210,     48,    399,     -6, &
                   210,    399,   -222,    264,     48,    264,     48,   -222,    210,    210,   -384,    318,     -6,   -168, &
                  -222,    534,    210,    480,    156,    102,    156,    912,    588,    480,    156,    588,    210,    -33, &
                 -1464,     21,   -195,     21,  -1302,    156,     48,   -168,     -6,   -168,    210,   -195,  -1302,     -6, &
                   -33,    156,    210,  -1464,  -1302,     48,    210,  -1302]
  K1( 609,:) = [   -195,     48,  -1950,    237,  -1896,  -1464,   -168,   -168,   -384,   -168,   -384,   -168,   1533,   -168, &
                 -1896,    264,   -384,     21,   1344,   -168,   -384,   1533,   1317,   -222,   -195,     48,     -6,     -6, &
                  -195,     -6,   -357,   -114,   2640,   -357,    102,   -114,   1344,   -114,   -816,    318,   -384,   -168, &
                  1533,   -222,   -384,   1344,   1317,   -168,   -249,    237,   -168,    102,   -168,   -384,     -6,     -6, &
                  -357,    102,     21,   -384,   -195,   -357,   -195,   -168,     -6,   -249,    183,     21,    183,   -168, &
                    -6,    237,   -195,     48,   1533,   -384,   -114,    102,  -1896,     48,   1344,   -384,   -168,   -384, &
                 -1950,    318,     -6,    264,    -60,   -546,     -6,     21,    237,   -168,    183,    183,     -6,    -60, &
                   264,  -1896,   -222,    480,  -1950,    -60,    318,   -816,   -168,   -384,   -546,    264,    -60,    318, &
                    -6,  -1950,     -6,   -222,  -1464,   -168,    -60,    -60]
  K1( 610,:) = [     21,    210,    210,  -1302,  -1302,    588,     48,    480,   -168,   1560,   -168,     48,   -195,     -6, &
                   264,     48,   1533,  -1464,   1749,     -6,     21,  -1464,   -222,    912,   1533,   -222,   -222,    210, &
                   210,    156,   -141,    534,   -357,   3072,   -114,   -384,   -141,   -195,    318,   -384,   1344,     48, &
                  1560,     48,   -168,     48,   -168,    480,    399,    102,     -6,   -168,     -6,    264,    210,    156, &
                    48,   -357,   -195,    318,    399,     48,    210,   -141,     21,   1533,    -33,   -195,     21,   -141, &
                   210,   -222,    -33,    156,     -6,   -168,   -195,     21,     21,    -33,   -195,   -114,   -141,   -168, &
                   102,    480,    156,    534,    210,   -222,     21,   1749,   -168,   1560,  -1302,    210,     21,    210, &
                  -195,   1533,     48,   -222,   -168,    264,   -141,   1344,   -141,   -168,    156,     -6,    -33,   -195, &
                 -1302,    210,    210,     -6,    264,     48,    588,    156]
  K1( 611,:) = [     48,   -195,  -1896,  -1464,  -1950,    237,   -168,   -168,   -384,   -168,   -384,   -168,   1344,   -168, &
                  -384,   1533,   1317,   -222,   1533,   -168,  -1896,    264,   -384,     21,     48,   -195,   -195,     -6, &
                    -6,     -6,   -114,   -357,    102,   -114,   2640,   -357,   1533,   -222,   -384,   1344,   1317,   -168, &
                  1344,   -114,   -816,    318,   -384,   -168,    237,   -249,   -168,   -384,   -168,    102,     -6,     -6, &
                    21,   -384,   -357,    102,    183,     21,    183,   -168,     -6,    237,   -195,   -357,   -195,   -168, &
                    -6,   -249,     -6,    -60,    264,  -1896,   -222,    480,  -1950,    -60,    318,   -816,   -168,   -384, &
                  -546,    264,    -60,    318,     -6,  -1950,     -6,   -222,  -1464,   -168,    -60,    -60,   -195,     48, &
                  1533,   -384,   -114,    102,  -1896,     48,   1344,   -384,   -168,   -384,  -1950,    318,     -6,    264, &
                   -60,   -546,     -6,     21,    237,   -168,    183,    183]
  K1( 612,:) = [    210,     21,  -1302,    588,    210,  -1302,    480,     48,   -168,     48,   -168,   1560,   1749,     -6, &
                    21,  -1464,   -222,    912,   -195,     -6,    264,     48,   1533,  -1464,   -222,   1533,    210,    156, &
                  -222,    210,    534,   -141,   -114,   -384,   -357,   3072,   1560,     48,   -168,     48,   -168,    480, &
                  -141,   -195,    318,   -384,   1344,     48,    102,    399,     -6,    264,     -6,   -168,    156,    210, &
                  -195,    318,     48,   -357,    -33,   -195,     21,   -141,    210,   -222,    399,     48,    210,   -141, &
                    21,   1533,     21,    210,   -195,   1533,     48,   -222,   -168,    264,   -141,   1344,   -141,   -168, &
                   156,     -6,    -33,   -195,  -1302,    210,    210,     -6,    264,     48,    588,    156,    -33,    156, &
                    -6,   -168,   -195,     21,     21,    -33,   -195,   -114,   -141,   -168,    102,    480,    156,    534, &
                   210,   -222,     21,   1749,   -168,   1560,  -1302,    210]
  K1( 613,:) = [   -168,   -168,   1533,   -222,    264,     21,   1560,   -141,   1533,   -195,   1344,   1749,   1560,     48, &
                  -168,     48,   -168,    480,   -141,   -141,   -168,     -6,   -168,     -6,     21,     21,     21,    210, &
                   210,    -33,   1749,   -195,   1344,   -141,   1533,   1560,   3072,   -384,   -357,   -141,   -114,    534, &
                    48,   -195,   -222,     48,   -114,   -195,    210,    -33,  -1464,     21,   -195,     21,  -1302,    156, &
                    48,   -168,     -6,   -168,    210,   -195,  -1302,     -6,    -33,    156,    210,  -1464,  -1302,     48, &
                   210,  -1302,   1533,   -222,   -141,   -357,   -141,    318,     21,    210,     48,   -168,   -195,    264, &
                   210,     48,    399,     -6,    210,    399,     21,   -195,    -33,     -6,    156,    102,    264,   -222, &
                    48,   -222,     48,    264,    210,    210,     -6,   -168,   -384,    318,    156,    912,    588,    480, &
                   156,    588,   -222,    534,    210,    480,    156,    102]
  K1( 614,:) = [     21,    264,   -222,   1533,   -168,   -168,   -141,   -141,   -168,     -6,   -168,     -6,     48,   1560, &
                  -168,    480,   -168,     48,   -141,   1560,   1344,   1749,   1533,   -195,    -33,    210,    210,     21, &
                    21,     21,   -195,     48,   -114,   -195,   -222,     48,   -384,   3072,   -114,    534,   -357,   -141, &
                  -195,   1749,   1533,   1560,   1344,   -141,   -222,    264,     48,    264,     48,   -222,    210,    210, &
                  -384,    318,     -6,   -168,   -222,    534,    210,    480,    156,    102,    156,    912,    588,    480, &
                   156,    588,   -222,   1533,   -141,    318,   -141,   -357,    210,     21,   -195,    264,     48,   -168, &
                    21,   -195,    -33,     -6,    156,    102,    210,     48,    399,     -6,    210,    399,    -33,    210, &
                  -195,     21,  -1464,     21,    156,  -1302,     -6,   -168,     48,   -168,    210,  -1464,  -1302,     48, &
                   210,  -1302,    210,   -195,  -1302,     -6,    -33,    156]
  K1( 615,:) = [  -1950,    237,   -195,     48,  -1464,  -1896,   1533,   -168,  -1896,    264,   -384,     21,   -168,   -168, &
                  -384,   -168,   -384,   -168,   -168,   1344,   1317,   -222,   -384,   1533,     -6,     -6,   -195,     48, &
                    -6,   -195,   1344,   -114,   -816,    318,   -384,   -168,   -357,   -114,   2640,   -357,    102,   -114, &
                  -222,   1533,   1317,   -168,   -384,   1344,   -195,     48,   1533,   -384,   -114,    102,  -1896,     48, &
                  1344,   -384,   -168,   -384,  -1950,    318,     -6,    264,    -60,   -546,     -6,     21,    237,   -168, &
                   183,    183,   -249,    237,   -168,    102,   -168,   -384,     -6,     -6,   -357,    102,     21,   -384, &
                  -195,   -357,   -195,   -168,     -6,   -249,    183,     21,    183,   -168,     -6,    237,    -60,     -6, &
                  -222,    480,    264,  -1896,    -60,  -1950,   -168,   -384,    318,   -816,     -6,   -222,  -1464,   -168, &
                   -60,    -60,   -546,    264,    -60,    318,     -6,  -1950]
  K1( 616,:) = [    210,  -1302,     21,    210,    588,  -1302,   -195,     -6,    264,     48,   1533,  -1464,     48,    480, &
                  -168,   1560,   -168,     48,     -6,   1749,   -222,    912,     21,  -1464,   -222,    210,   1533,   -222, &
                   156,    210,   -141,   -195,    318,   -384,   1344,     48,   -141,    534,   -357,   3072,   -114,   -384, &
                    48,   1560,   -168,    480,   -168,     48,    -33,    156,     -6,   -168,   -195,     21,     21,    -33, &
                  -195,   -114,   -141,   -168,    102,    480,    156,    534,    210,   -222,     21,   1749,   -168,   1560, &
                 -1302,    210,    399,    102,     -6,   -168,     -6,    264,    210,    156,     48,   -357,   -195,    318, &
                   399,     48,    210,   -141,     21,   1533,    -33,   -195,     21,   -141,    210,   -222,    210,     21, &
                    48,   -222,   -195,   1533,    264,   -168,   -141,   -168,   -141,   1344,    210,     -6,    264,     48, &
                   588,    156,    156,     -6,    -33,   -195,  -1302,    210]
  K1( 617,:) = [  -1896,  -1464,     48,   -195,    237,  -1950,   1344,   -168,   -384,   1533,   1317,   -222,   -168,   -168, &
                  -384,   -168,   -384,   -168,   -168,   1533,   -384,     21,  -1896,    264,   -195,     -6,     48,   -195, &
                    -6,     -6,   1533,   -222,   -384,   1344,   1317,   -168,   -114,   -357,    102,   -114,   2640,   -357, &
                  -114,   1344,   -384,   -168,   -816,    318,     -6,    -60,    264,  -1896,   -222,    480,  -1950,    -60, &
                   318,   -816,   -168,   -384,   -546,    264,    -60,    318,     -6,  -1950,     -6,   -222,  -1464,   -168, &
                   -60,    -60,    237,   -249,   -168,   -384,   -168,    102,     -6,     -6,     21,   -384,   -357,    102, &
                   183,     21,    183,   -168,     -6,    237,   -195,   -357,   -195,   -168,     -6,   -249,     48,   -195, &
                  -114,    102,   1533,   -384,     48,  -1896,   -168,   -384,   1344,   -384,     -6,     21,    237,   -168, &
                   183,    183,  -1950,    318,     -6,    264,    -60,   -546]
  K1( 618,:) = [  -1302,    588,    210,     21,  -1302,    210,   1749,     -6,     21,  -1464,   -222,    912,    480,     48, &
                  -168,     48,   -168,   1560,     -6,   -195,   1533,  -1464,    264,     48,    210,    156,   -222,   1533, &
                   210,   -222,   1560,     48,   -168,     48,   -168,    480,    534,   -141,   -114,   -384,   -357,   3072, &
                  -195,   -141,   1344,     48,    318,   -384,     21,    210,   -195,   1533,     48,   -222,   -168,    264, &
                  -141,   1344,   -141,   -168,    156,     -6,    -33,   -195,  -1302,    210,    210,     -6,    264,     48, &
                   588,    156,    102,    399,     -6,    264,     -6,   -168,    156,    210,   -195,    318,     48,   -357, &
                   -33,   -195,     21,   -141,    210,   -222,    399,     48,    210,   -141,     21,   1533,    156,    -33, &
                  -195,     21,     -6,   -168,    -33,     21,   -141,   -168,   -195,   -114,     21,   1749,   -168,   1560, &
                 -1302,    210,    102,    480,    156,    534,    210,   -222]
  K1( 619,:) = [   -168,   -168,    264,     21,   1533,   -222,   -141,   1560,   1344,   1749,   1533,   -195,   -141,   -141, &
                  -168,     -6,   -168,     -6,   1560,     48,   -168,     48,   -168,    480,     21,     21,    210,    -33, &
                    21,    210,   -195,   1749,   1533,   1560,   1344,   -141,     48,   -195,   -222,     48,   -114,   -195, &
                  3072,   -384,   -357,   -141,   -114,    534,    -33,    210,   -195,     21,  -1464,     21,    156,  -1302, &
                    -6,   -168,     48,   -168,    210,  -1464,  -1302,     48,    210,  -1302,    210,   -195,  -1302,     -6, &
                   -33,    156,    264,   -222,     48,   -222,     48,    264,    210,    210,     -6,   -168,   -384,    318, &
                   156,    912,    588,    480,    156,    588,   -222,    534,    210,    480,    156,    102,   1533,   -222, &
                  -141,   -357,   -141,    318,     21,    210,     48,   -168,   -195,    264,    210,     48,    399,     -6, &
                   210,    399,     21,   -195,    -33,     -6,    156,    102]
  K1( 620,:) = [    264,     21,   -168,   -168,   -222,   1533,   -141,   -141,   -168,     -6,   -168,     -6,   -141,   1560, &
                  1344,   1749,   1533,   -195,     48,   1560,   -168,    480,   -168,     48,    210,    -33,     21,     21, &
                   210,     21,     48,   -195,   -222,     48,   -114,   -195,   -195,   1749,   1533,   1560,   1344,   -141, &
                  -384,   3072,   -114,    534,   -357,   -141,    264,   -222,     48,   -222,     48,    264,    210,    210, &
                    -6,   -168,   -384,    318,    156,    912,    588,    480,    156,    588,   -222,    534,    210,    480, &
                   156,    102,    -33,    210,   -195,     21,  -1464,     21,    156,  -1302,     -6,   -168,     48,   -168, &
                   210,  -1464,  -1302,     48,    210,  -1302,    210,   -195,  -1302,     -6,    -33,    156,   -222,   1533, &
                  -141,    318,   -141,   -357,    210,     21,   -195,    264,     48,   -168,     21,   -195,    -33,     -6, &
                   156,    102,    210,     48,    399,     -6,    210,    399]
  K1( 621,:) = [    237,  -1950,  -1464,  -1896,   -195,     48,   -168,   1533,   -384,     21,  -1896,    264,   -168,   1344, &
                  1317,   -222,   -384,   1533,   -168,   -168,   -384,   -168,   -384,   -168,     -6,     -6,     -6,   -195, &
                  -195,     48,   -114,   1344,   -384,   -168,   -816,    318,   -222,   1533,   1317,   -168,   -384,   1344, &
                  -357,   -114,   2640,   -357,    102,   -114,     48,   -195,   -114,    102,   1533,   -384,     48,  -1896, &
                  -168,   -384,   1344,   -384,     -6,     21,    237,   -168,    183,    183,  -1950,    318,     -6,    264, &
                   -60,   -546,    -60,     -6,   -222,    480,    264,  -1896,    -60,  -1950,   -168,   -384,    318,   -816, &
                    -6,   -222,  -1464,   -168,    -60,    -60,   -546,    264,    -60,    318,     -6,  -1950,   -249,    237, &
                  -168,    102,   -168,   -384,     -6,     -6,   -357,    102,     21,   -384,   -195,   -357,   -195,   -168, &
                    -6,   -249,    183,     21,    183,   -168,     -6,    237]
  K1( 622,:) = [  -1302,    210,    588,  -1302,     21,    210,     -6,   -195,   1533,  -1464,    264,     48,     -6,   1749, &
                  -222,    912,     21,  -1464,     48,    480,   -168,   1560,   -168,     48,    210,   -222,    156,    210, &
                  1533,   -222,   -195,   -141,   1344,     48,    318,   -384,     48,   1560,   -168,    480,   -168,     48, &
                  -141,    534,   -357,   3072,   -114,   -384,    156,    -33,   -195,     21,     -6,   -168,    -33,     21, &
                  -141,   -168,   -195,   -114,     21,   1749,   -168,   1560,  -1302,    210,    102,    480,    156,    534, &
                   210,   -222,    210,     21,     48,   -222,   -195,   1533,    264,   -168,   -141,   -168,   -141,   1344, &
                   210,     -6,    264,     48,    588,    156,    156,     -6,    -33,   -195,  -1302,    210,    399,    102, &
                    -6,   -168,     -6,    264,    210,    156,     48,   -357,   -195,    318,    399,     48,    210,   -141, &
                    21,   1533,    -33,   -195,     21,   -141,    210,   -222]
  K1( 623,:) = [  -1464,  -1896,    237,  -1950,     48,   -195,   -168,   1344,   1317,   -222,   -384,   1533,   -168,   1533, &
                  -384,     21,  -1896,    264,   -168,   -168,   -384,   -168,   -384,   -168,     -6,   -195,     -6,     -6, &
                    48,   -195,   -222,   1533,   1317,   -168,   -384,   1344,   -114,   1344,   -384,   -168,   -816,    318, &
                  -114,   -357,    102,   -114,   2640,   -357,    -60,     -6,   -222,    480,    264,  -1896,    -60,  -1950, &
                  -168,   -384,    318,   -816,     -6,   -222,  -1464,   -168,    -60,    -60,   -546,    264,    -60,    318, &
                    -6,  -1950,     48,   -195,   -114,    102,   1533,   -384,     48,  -1896,   -168,   -384,   1344,   -384, &
                    -6,     21,    237,   -168,    183,    183,  -1950,    318,     -6,    264,    -60,   -546,    237,   -249, &
                  -168,   -384,   -168,    102,     -6,     -6,     21,   -384,   -357,    102,    183,     21,    183,   -168, &
                    -6,    237,   -195,   -357,   -195,   -168,     -6,   -249]
  K1( 624,:) = [    588,  -1302,  -1302,    210,    210,     21,     -6,   1749,   -222,    912,     21,  -1464,     -6,   -195, &
                  1533,  -1464,    264,     48,    480,     48,   -168,     48,   -168,   1560,    156,    210,    210,   -222, &
                  -222,   1533,     48,   1560,   -168,    480,   -168,     48,   -195,   -141,   1344,     48,    318,   -384, &
                   534,   -141,   -114,   -384,   -357,   3072,    210,     21,     48,   -222,   -195,   1533,    264,   -168, &
                  -141,   -168,   -141,   1344,    210,     -6,    264,     48,    588,    156,    156,     -6,    -33,   -195, &
                 -1302,    210,    156,    -33,   -195,     21,     -6,   -168,    -33,     21,   -141,   -168,   -195,   -114, &
                    21,   1749,   -168,   1560,  -1302,    210,    102,    480,    156,    534,    210,   -222,    102,    399, &
                    -6,    264,     -6,   -168,    156,    210,   -195,    318,     48,   -357,    -33,   -195,     21,   -141, &
                   210,   -222,    399,     48,    210,   -141,     21,   1533]
  K1( 625,:) = [     -6,    -60,    -60,    372,    372,   -168,     21,    210,   -195,   1533,     48,   -222,     21,    -33, &
                    -6,   -222,   -195,    210,     21,    210,     -6,    210,     -6,    156, -12291,   1506,   1506,     -6, &
                    -6,  -2004,   1533,   -222,   -195,     21,     48,    210,   -168,     21,  -1950,    210,  -1896,  -1302, &
                  -168,    264,    237,  -1302,  -1464,    588,  -3084,    264,    399,   -249,    156,   -546,  -1518,    372, &
                   210,     -6,    -33,    -60,  -2652,    399,  -3030,    210,  -3084,  -1518,    318,    156,    183,    -33, &
                   264,    372,    372,    318,  -1302,    237,    -33,    183,     -6,    183,    210,     -6,     21,    183, &
                   696,    102,  -1140,    156,    264,    372,    372,  -1302,     -6,    210,    696,  -1140,    -60,   -600, &
                   210,  -1950,    210,    -60,   1506,   -492,   -222,     -6,    264,    -60,    264,    102,    372,    156, &
                   696,  -1140,   -168,    588,  -2004,    156,   -816,    264]
  K1( 626,:) = [    -60,     -6,    372,   -168,    -60,    372,    210,     21,     48,   -222,   -195,   1533,     21,    210, &
                    -6,    210,     -6,    156,     21,    -33,     -6,   -222,   -195,    210,   1506, -12291,     -6,  -2004, &
                  1506,     -6,   -222,   1533,     48,    210,   -195,     21,   -168,    264,    237,  -1302,  -1464,    588, &
                  -168,     21,  -1950,    210,  -1896,  -1302,    264,  -3084,    156,   -546,    399,   -249,    372,  -1518, &
                   -33,    -60,    210,     -6,    318,    156,    183,    -33,    264,    372,  -2652,    399,  -3030,    210, &
                 -3084,  -1518,    -60,   -600,    210,  -1950,    210,    -60,   1506,   -492,   -222,     -6,    264,    -60, &
                   264,    102,    372,    156,    696,  -1140,   -168,    588,  -2004,    156,   -816,    264,    372,    318, &
                 -1302,    237,    -33,    183,     -6,    183,    210,     -6,     21,    183,    696,    102,  -1140,    156, &
                   264,    372,    372,  -1302,     -6,    210,    696,  -1140]
  K1( 627,:) = [    -60,    372,     -6,    -60,   -168,    372,     21,    -33,     -6,   -222,   -195,    210,     21,    210, &
                  -195,   1533,     48,   -222,    210,     21,     -6,    156,     -6,    210,   1506,     -6, -12291,   1506, &
                 -2004,     -6,   -168,     21,  -1950,    210,  -1896,  -1302,   1533,   -222,   -195,     21,     48,    210, &
                   264,   -168,  -1464,    588,    237,  -1302,    372,    318,  -1302,    237,    -33,    183,     -6,    183, &
                   210,     -6,     21,    183,    696,    102,  -1140,    156,    264,    372,    372,  -1302,     -6,    210, &
                   696,  -1140,  -3084,    264,    399,   -249,    156,   -546,  -1518,    372,    210,     -6,    -33,    -60, &
                 -2652,    399,  -3030,    210,  -3084,  -1518,    318,    156,    183,    -33,    264,    372,   -600,    -60, &
                   210,    -60,    210,  -1950,   -492,   1506,    264,    -60,   -222,     -6,   -168,    588,  -2004,    156, &
                  -816,    264,    264,    102,    372,    156,    696,  -1140]
  K1( 628,:) = [    372,   -168,    -60,     -6,    372,    -60,     21,    210,     -6,    210,     -6,    156,    210,     21, &
                    48,   -222,   -195,   1533,    -33,     21,   -195,    210,     -6,   -222,     -6,  -2004,   1506, -12291, &
                    -6,   1506,   -168,    264,    237,  -1302,  -1464,    588,   -222,   1533,     48,    210,   -195,     21, &
                    21,   -168,  -1896,  -1302,  -1950,    210,    -60,   -600,    210,  -1950,    210,    -60,   1506,   -492, &
                  -222,     -6,    264,    -60,    264,    102,    372,    156,    696,  -1140,   -168,    588,  -2004,    156, &
                  -816,    264,    264,  -3084,    156,   -546,    399,   -249,    372,  -1518,    -33,    -60,    210,     -6, &
                   318,    156,    183,    -33,    264,    372,  -2652,    399,  -3030,    210,  -3084,  -1518,    318,    372, &
                   -33,    183,  -1302,    237,    183,     -6,     21,    183,    210,     -6,    372,  -1302,     -6,    210, &
                   696,  -1140,    696,    102,  -1140,    156,    264,    372]
  K1( 629,:) = [    372,    -60,   -168,    372,     -6,    -60,    -33,     21,   -195,    210,     -6,   -222,    210,     21, &
                    -6,    156,     -6,    210,     21,    210,   -195,   1533,     48,   -222,     -6,   1506,  -2004,     -6, &
                -12291,   1506,     21,   -168,  -1896,  -1302,  -1950,    210,    264,   -168,  -1464,    588,    237,  -1302, &
                  1533,   -222,   -195,     21,     48,    210,    318,    372,    -33,    183,  -1302,    237,    183,     -6, &
                    21,    183,    210,     -6,    372,  -1302,     -6,    210,    696,  -1140,    696,    102,  -1140,    156, &
                   264,    372,   -600,    -60,    210,    -60,    210,  -1950,   -492,   1506,    264,    -60,   -222,     -6, &
                  -168,    588,  -2004,    156,   -816,    264,    264,    102,    372,    156,    696,  -1140,  -3084,    264, &
                   399,   -249,    156,   -546,  -1518,    372,    210,     -6,    -33,    -60,  -2652,    399,  -3030,    210, &
                 -3084,  -1518,    318,    156,    183,    -33,    264,    372]
  K1( 630,:) = [   -168,    372,    372,    -60,    -60,     -6,    210,     21,     -6,    156,     -6,    210,    -33,     21, &
                  -195,    210,     -6,   -222,    210,     21,     48,   -222,   -195,   1533,  -2004,     -6,     -6,   1506, &
                  1506, -12291,    264,   -168,  -1464,    588,    237,  -1302,     21,   -168,  -1896,  -1302,  -1950,    210, &
                  -222,   1533,     48,    210,   -195,     21,   -600,    -60,    210,    -60,    210,  -1950,   -492,   1506, &
                   264,    -60,   -222,     -6,   -168,    588,  -2004,    156,   -816,    264,    264,    102,    372,    156, &
                   696,  -1140,    318,    372,    -33,    183,  -1302,    237,    183,     -6,     21,    183,    210,     -6, &
                   372,  -1302,     -6,    210,    696,  -1140,    696,    102,  -1140,    156,    264,    372,    264,  -3084, &
                   156,   -546,    399,   -249,    372,  -1518,    -33,    -60,    210,     -6,    318,    156,    183,    -33, &
                   264,    372,  -2652,    399,  -3030,    210,  -3084,  -1518]
  K1( 631,:) = [     21,    210,     21,     21,    -33,    210,   3072,   -384,   -357,   -141,   -114,    534,   1749,   -195, &
                  1344,   -141,   1533,   1560,   -195,     48,   -114,   -195,   -222,     48,   1533,   -222,   -168,   -168, &
                    21,    264,   1560,     48,   -168,     48,   -168,    480,   1560,   -141,   1533,   -195,   1344,   1749, &
                  -141,   -141,   -168,     -6,   -168,     -6,     21,    210,     48,   -168,   -195,    264,   1533,   -222, &
                  -141,   -357,   -141,    318,    399,     -6,    210,     48,    399,    210,    -33,     -6,     21,   -195, &
                   102,    156,  -1302,    156,     48,   -168,     -6,   -168,    210,    -33,  -1464,     21,   -195,     21, &
                 -1302,     -6,    210,   -195,    156,    -33,  -1302,     48,    210,  -1464,  -1302,    210,    210,    210, &
                  -384,    318,     -6,   -168,   -222,    264,     48,    264,     48,   -222,    210,    480,   -222,    534, &
                   102,    156,    588,    480,    156,    912,    588,    156]
  K1( 632,:) = [    210,     21,    -33,    210,     21,     21,   -384,   3072,   -114,    534,   -357,   -141,   -195,     48, &
                  -114,   -195,   -222,     48,   1749,   -195,   1344,   -141,   1533,   1560,   -222,   1533,     21,    264, &
                  -168,   -168,     48,   1560,   -168,    480,   -168,     48,   -141,   -141,   -168,     -6,   -168,     -6, &
                  1560,   -141,   1533,   -195,   1344,   1749,    210,     21,   -195,    264,     48,   -168,   -222,   1533, &
                  -141,    318,   -141,   -357,    -33,     -6,     21,   -195,    102,    156,    399,     -6,    210,     48, &
                   399,    210,    210,    210,   -384,    318,     -6,   -168,   -222,    264,     48,    264,     48,   -222, &
                   210,    480,   -222,    534,    102,    156,    588,    480,    156,    912,    588,    156,  -1302,    156, &
                    48,   -168,     -6,   -168,    210,    -33,  -1464,     21,   -195,     21,  -1302,     -6,    210,   -195, &
                   156,    -33,  -1302,     48,    210,  -1464,  -1302,    210]
  K1( 633,:) = [   -195,     48,     -6,     -6,   -195,     -6,   -357,   -114,   2640,   -357,    102,   -114,   1344,   -114, &
                  -816,    318,   -384,   -168,   1533,   -222,   -384,   1344,   1317,   -168,   -195,     48,  -1950,    237, &
                 -1896,  -1464,   -168,   -168,   -384,   -168,   -384,   -168,   1533,   -168,  -1896,    264,   -384,     21, &
                  1344,   -168,   -384,   1533,   1317,   -222,     -6,     -6,   -357,    102,     21,   -384,   -249,    237, &
                  -168,    102,   -168,   -384,   -195,   -168,   -195,   -357,   -249,     -6,    183,   -168,    183,     21, &
                   237,     -6,  -1896,     48,   1344,   -384,   -168,   -384,   -195,     48,   1533,   -384,   -114,    102, &
                    -6,    264,  -1950,    318,   -546,    -60,    237,   -168,     -6,     21,    183,    183,  -1950,    -60, &
                   318,   -816,   -168,   -384,     -6,    -60,    264,  -1896,   -222,    480,    -60,    318,   -546,    264, &
                 -1950,     -6,  -1464,   -168,     -6,   -222,    -60,    -60]
  K1( 634,:) = [   1533,   -222,   -222,    210,    210,    156,   -141,    534,   -357,   3072,   -114,   -384,   -141,   -195, &
                   318,   -384,   1344,     48,   1560,     48,   -168,     48,   -168,    480,     21,    210,    210,  -1302, &
                 -1302,    588,     48,    480,   -168,   1560,   -168,     48,   -195,     -6,    264,     48,   1533,  -1464, &
                  1749,     -6,     21,  -1464,   -222,    912,    210,    156,     48,   -357,   -195,    318,    399,    102, &
                    -6,   -168,     -6,    264,    210,   -141,    399,     48,   1533,     21,     21,   -141,    -33,   -195, &
                  -222,    210,     21,    -33,   -195,   -114,   -141,   -168,    -33,    156,     -6,   -168,   -195,     21, &
                   156,    534,    102,    480,   -222,    210,   -168,   1560,     21,   1749,    210,  -1302,   -168,    264, &
                  -141,   1344,   -141,   -168,     21,    210,   -195,   1533,     48,   -222,    -33,   -195,    156,     -6, &
                   210,  -1302,    264,     48,    210,     -6,    156,    588]
  K1( 635,:) = [     48,   -195,   -195,     -6,     -6,     -6,   -114,   -357,    102,   -114,   2640,   -357,   1533,   -222, &
                  -384,   1344,   1317,   -168,   1344,   -114,   -816,    318,   -384,   -168,     48,   -195,  -1896,  -1464, &
                 -1950,    237,   -168,   -168,   -384,   -168,   -384,   -168,   1344,   -168,   -384,   1533,   1317,   -222, &
                  1533,   -168,  -1896,    264,   -384,     21,     -6,     -6,     21,   -384,   -357,    102,    237,   -249, &
                  -168,   -384,   -168,    102,    183,   -168,    183,     21,    237,     -6,   -195,   -168,   -195,   -357, &
                  -249,     -6,  -1950,    -60,    318,   -816,   -168,   -384,     -6,    -60,    264,  -1896,   -222,    480, &
                   -60,    318,   -546,    264,  -1950,     -6,  -1464,   -168,     -6,   -222,    -60,    -60,  -1896,     48, &
                  1344,   -384,   -168,   -384,   -195,     48,   1533,   -384,   -114,    102,     -6,    264,  -1950,    318, &
                  -546,    -60,    237,   -168,     -6,     21,    183,    183]
  K1( 636,:) = [   -222,   1533,    210,    156,   -222,    210,    534,   -141,   -114,   -384,   -357,   3072,   1560,     48, &
                  -168,     48,   -168,    480,   -141,   -195,    318,   -384,   1344,     48,    210,     21,  -1302,    588, &
                   210,  -1302,    480,     48,   -168,     48,   -168,   1560,   1749,     -6,     21,  -1464,   -222,    912, &
                  -195,     -6,    264,     48,   1533,  -1464,    156,    210,   -195,    318,     48,   -357,    102,    399, &
                    -6,    264,     -6,   -168,     21,   -141,    -33,   -195,   -222,    210,    210,   -141,    399,     48, &
                  1533,     21,   -168,    264,   -141,   1344,   -141,   -168,     21,    210,   -195,   1533,     48,   -222, &
                   -33,   -195,    156,     -6,    210,  -1302,    264,     48,    210,     -6,    156,    588,     21,    -33, &
                  -195,   -114,   -141,   -168,    -33,    156,     -6,   -168,   -195,     21,    156,    534,    102,    480, &
                  -222,    210,   -168,   1560,     21,   1749,    210,  -1302]
  K1( 637,:) = [     21,     21,     21,    210,    210,    -33,   1749,   -195,   1344,   -141,   1533,   1560,   3072,   -384, &
                  -357,   -141,   -114,    534,     48,   -195,   -222,     48,   -114,   -195,   -168,   -168,   1533,   -222, &
                   264,     21,   1560,   -141,   1533,   -195,   1344,   1749,   1560,     48,   -168,     48,   -168,    480, &
                  -141,   -141,   -168,     -6,   -168,     -6,  -1302,    156,     48,   -168,     -6,   -168,    210,    -33, &
                 -1464,     21,   -195,     21,  -1302,     -6,    210,   -195,    156,    -33,  -1302,     48,    210,  -1464, &
                 -1302,    210,     21,    210,     48,   -168,   -195,    264,   1533,   -222,   -141,   -357,   -141,    318, &
                   399,     -6,    210,     48,    399,    210,    -33,     -6,     21,   -195,    102,    156,    210,    210, &
                    -6,   -168,   -384,    318,    264,   -222,     48,   -222,     48,    264,    588,    480,    156,    912, &
                   588,    156,    210,    480,   -222,    534,    102,    156]
  K1( 638,:) = [    -33,    210,    210,     21,     21,     21,   -195,     48,   -114,   -195,   -222,     48,   -384,   3072, &
                  -114,    534,   -357,   -141,   -195,   1749,   1533,   1560,   1344,   -141,     21,    264,   -222,   1533, &
                  -168,   -168,   -141,   -141,   -168,     -6,   -168,     -6,     48,   1560,   -168,    480,   -168,     48, &
                  -141,   1560,   1344,   1749,   1533,   -195,    210,    210,   -384,    318,     -6,   -168,   -222,    264, &
                    48,    264,     48,   -222,    210,    480,   -222,    534,    102,    156,    588,    480,    156,    912, &
                   588,    156,    210,     21,   -195,    264,     48,   -168,   -222,   1533,   -141,    318,   -141,   -357, &
                   -33,     -6,     21,   -195,    102,    156,    399,     -6,    210,     48,    399,    210,    156,  -1302, &
                    -6,   -168,     48,   -168,    -33,    210,   -195,     21,  -1464,     21,  -1302,     48,    210,  -1464, &
                 -1302,    210,  -1302,     -6,    210,   -195,    156,    -33]
  K1( 639,:) = [     -6,     -6,   -195,     48,     -6,   -195,   1344,   -114,   -816,    318,   -384,   -168,   -357,   -114, &
                  2640,   -357,    102,   -114,   -222,   1533,   1317,   -168,   -384,   1344,  -1950,    237,   -195,     48, &
                 -1464,  -1896,   1533,   -168,  -1896,    264,   -384,     21,   -168,   -168,   -384,   -168,   -384,   -168, &
                  -168,   1344,   1317,   -222,   -384,   1533,  -1896,     48,   1344,   -384,   -168,   -384,   -195,     48, &
                  1533,   -384,   -114,    102,     -6,    264,  -1950,    318,   -546,    -60,    237,   -168,     -6,     21, &
                   183,    183,     -6,     -6,   -357,    102,     21,   -384,   -249,    237,   -168,    102,   -168,   -384, &
                  -195,   -168,   -195,   -357,   -249,     -6,    183,   -168,    183,     21,    237,     -6,    -60,  -1950, &
                  -168,   -384,    318,   -816,    -60,     -6,   -222,    480,    264,  -1896,  -1464,   -168,     -6,   -222, &
                   -60,    -60,    -60,    318,   -546,    264,  -1950,     -6]
  K1( 640,:) = [   -222,    210,   1533,   -222,    156,    210,   -141,   -195,    318,   -384,   1344,     48,   -141,    534, &
                  -357,   3072,   -114,   -384,     48,   1560,   -168,    480,   -168,     48,    210,  -1302,     21,    210, &
                   588,  -1302,   -195,     -6,    264,     48,   1533,  -1464,     48,    480,   -168,   1560,   -168,     48, &
                    -6,   1749,   -222,    912,     21,  -1464,     21,    -33,   -195,   -114,   -141,   -168,    -33,    156, &
                    -6,   -168,   -195,     21,    156,    534,    102,    480,   -222,    210,   -168,   1560,     21,   1749, &
                   210,  -1302,    210,    156,     48,   -357,   -195,    318,    399,    102,     -6,   -168,     -6,    264, &
                   210,   -141,    399,     48,   1533,     21,     21,   -141,    -33,   -195,   -222,    210,    264,   -168, &
                  -141,   -168,   -141,   1344,    210,     21,     48,   -222,   -195,   1533,    264,     48,    210,     -6, &
                   156,    588,    -33,   -195,    156,     -6,    210,  -1302]
  K1( 641,:) = [   -195,     -6,     48,   -195,     -6,     -6,   1533,   -222,   -384,   1344,   1317,   -168,   -114,   -357, &
                   102,   -114,   2640,   -357,   -114,   1344,   -384,   -168,   -816,    318,  -1896,  -1464,     48,   -195, &
                   237,  -1950,   1344,   -168,   -384,   1533,   1317,   -222,   -168,   -168,   -384,   -168,   -384,   -168, &
                  -168,   1533,   -384,     21,  -1896,    264,  -1950,    -60,    318,   -816,   -168,   -384,     -6,    -60, &
                   264,  -1896,   -222,    480,    -60,    318,   -546,    264,  -1950,     -6,  -1464,   -168,     -6,   -222, &
                   -60,    -60,     -6,     -6,     21,   -384,   -357,    102,    237,   -249,   -168,   -384,   -168,    102, &
                   183,   -168,    183,     21,    237,     -6,   -195,   -168,   -195,   -357,   -249,     -6,     48,  -1896, &
                  -168,   -384,   1344,   -384,     48,   -195,   -114,    102,   1533,   -384,    237,   -168,     -6,     21, &
                   183,    183,     -6,    264,  -1950,    318,   -546,    -60]
  K1( 642,:) = [    210,    156,   -222,   1533,    210,   -222,   1560,     48,   -168,     48,   -168,    480,    534,   -141, &
                  -114,   -384,   -357,   3072,   -195,   -141,   1344,     48,    318,   -384,  -1302,    588,    210,     21, &
                 -1302,    210,   1749,     -6,     21,  -1464,   -222,    912,    480,     48,   -168,     48,   -168,   1560, &
                    -6,   -195,   1533,  -1464,    264,     48,   -168,    264,   -141,   1344,   -141,   -168,     21,    210, &
                  -195,   1533,     48,   -222,    -33,   -195,    156,     -6,    210,  -1302,    264,     48,    210,     -6, &
                   156,    588,    156,    210,   -195,    318,     48,   -357,    102,    399,     -6,    264,     -6,   -168, &
                    21,   -141,    -33,   -195,   -222,    210,    210,   -141,    399,     48,   1533,     21,    -33,     21, &
                  -141,   -168,   -195,   -114,    156,    -33,   -195,     21,     -6,   -168,   -168,   1560,     21,   1749, &
                   210,  -1302,    156,    534,    102,    480,   -222,    210]
  K1( 643,:) = [     21,     21,    210,    -33,     21,    210,   -195,   1749,   1533,   1560,   1344,   -141,     48,   -195, &
                  -222,     48,   -114,   -195,   3072,   -384,   -357,   -141,   -114,    534,   -168,   -168,    264,     21, &
                  1533,   -222,   -141,   1560,   1344,   1749,   1533,   -195,   -141,   -141,   -168,     -6,   -168,     -6, &
                  1560,     48,   -168,     48,   -168,    480,    156,  -1302,     -6,   -168,     48,   -168,    -33,    210, &
                  -195,     21,  -1464,     21,  -1302,     48,    210,  -1464,  -1302,    210,  -1302,     -6,    210,   -195, &
                   156,    -33,    210,    210,     -6,   -168,   -384,    318,    264,   -222,     48,   -222,     48,    264, &
                   588,    480,    156,    912,    588,    156,    210,    480,   -222,    534,    102,    156,     21,    210, &
                    48,   -168,   -195,    264,   1533,   -222,   -141,   -357,   -141,    318,    399,     -6,    210,     48, &
                   399,    210,    -33,     -6,     21,   -195,    102,    156]
  K1( 644,:) = [    210,    -33,     21,     21,    210,     21,     48,   -195,   -222,     48,   -114,   -195,   -195,   1749, &
                  1533,   1560,   1344,   -141,   -384,   3072,   -114,    534,   -357,   -141,    264,     21,   -168,   -168, &
                  -222,   1533,   -141,   -141,   -168,     -6,   -168,     -6,   -141,   1560,   1344,   1749,   1533,   -195, &
                    48,   1560,   -168,    480,   -168,     48,    210,    210,     -6,   -168,   -384,    318,    264,   -222, &
                    48,   -222,     48,    264,    588,    480,    156,    912,    588,    156,    210,    480,   -222,    534, &
                   102,    156,    156,  -1302,     -6,   -168,     48,   -168,    -33,    210,   -195,     21,  -1464,     21, &
                 -1302,     48,    210,  -1464,  -1302,    210,  -1302,     -6,    210,   -195,    156,    -33,    210,     21, &
                  -195,    264,     48,   -168,   -222,   1533,   -141,    318,   -141,   -357,    -33,     -6,     21,   -195, &
                   102,    156,    399,     -6,    210,     48,    399,    210]
  K1( 645,:) = [     -6,     -6,     -6,   -195,   -195,     48,   -114,   1344,   -384,   -168,   -816,    318,   -222,   1533, &
                  1317,   -168,   -384,   1344,   -357,   -114,   2640,   -357,    102,   -114,    237,  -1950,  -1464,  -1896, &
                  -195,     48,   -168,   1533,   -384,     21,  -1896,    264,   -168,   1344,   1317,   -222,   -384,   1533, &
                  -168,   -168,   -384,   -168,   -384,   -168,     48,  -1896,   -168,   -384,   1344,   -384,     48,   -195, &
                  -114,    102,   1533,   -384,    237,   -168,     -6,     21,    183,    183,     -6,    264,  -1950,    318, &
                  -546,    -60,    -60,  -1950,   -168,   -384,    318,   -816,    -60,     -6,   -222,    480,    264,  -1896, &
                 -1464,   -168,     -6,   -222,    -60,    -60,    -60,    318,   -546,    264,  -1950,     -6,     -6,     -6, &
                  -357,    102,     21,   -384,   -249,    237,   -168,    102,   -168,   -384,   -195,   -168,   -195,   -357, &
                  -249,     -6,    183,   -168,    183,     21,    237,     -6]
  K1( 646,:) = [    210,   -222,    156,    210,   1533,   -222,   -195,   -141,   1344,     48,    318,   -384,     48,   1560, &
                  -168,    480,   -168,     48,   -141,    534,   -357,   3072,   -114,   -384,  -1302,    210,    588,  -1302, &
                    21,    210,     -6,   -195,   1533,  -1464,    264,     48,     -6,   1749,   -222,    912,     21,  -1464, &
                    48,    480,   -168,   1560,   -168,     48,    -33,     21,   -141,   -168,   -195,   -114,    156,    -33, &
                  -195,     21,     -6,   -168,   -168,   1560,     21,   1749,    210,  -1302,    156,    534,    102,    480, &
                  -222,    210,    264,   -168,   -141,   -168,   -141,   1344,    210,     21,     48,   -222,   -195,   1533, &
                   264,     48,    210,     -6,    156,    588,    -33,   -195,    156,     -6,    210,  -1302,    210,    156, &
                    48,   -357,   -195,    318,    399,    102,     -6,   -168,     -6,    264,    210,   -141,    399,     48, &
                  1533,     21,     21,   -141,    -33,   -195,   -222,    210]
  K1( 647,:) = [     -6,   -195,     -6,     -6,     48,   -195,   -222,   1533,   1317,   -168,   -384,   1344,   -114,   1344, &
                  -384,   -168,   -816,    318,   -114,   -357,    102,   -114,   2640,   -357,  -1464,  -1896,    237,  -1950, &
                    48,   -195,   -168,   1344,   1317,   -222,   -384,   1533,   -168,   1533,   -384,     21,  -1896,    264, &
                  -168,   -168,   -384,   -168,   -384,   -168,    -60,  -1950,   -168,   -384,    318,   -816,    -60,     -6, &
                  -222,    480,    264,  -1896,  -1464,   -168,     -6,   -222,    -60,    -60,    -60,    318,   -546,    264, &
                 -1950,     -6,     48,  -1896,   -168,   -384,   1344,   -384,     48,   -195,   -114,    102,   1533,   -384, &
                   237,   -168,     -6,     21,    183,    183,     -6,    264,  -1950,    318,   -546,    -60,     -6,     -6, &
                    21,   -384,   -357,    102,    237,   -249,   -168,   -384,   -168,    102,    183,   -168,    183,     21, &
                   237,     -6,   -195,   -168,   -195,   -357,   -249,     -6]
  K1( 648,:) = [    156,    210,    210,   -222,   -222,   1533,     48,   1560,   -168,    480,   -168,     48,   -195,   -141, &
                  1344,     48,    318,   -384,    534,   -141,   -114,   -384,   -357,   3072,    588,  -1302,  -1302,    210, &
                   210,     21,     -6,   1749,   -222,    912,     21,  -1464,     -6,   -195,   1533,  -1464,    264,     48, &
                   480,     48,   -168,     48,   -168,   1560,    264,   -168,   -141,   -168,   -141,   1344,    210,     21, &
                    48,   -222,   -195,   1533,    264,     48,    210,     -6,    156,    588,    -33,   -195,    156,     -6, &
                   210,  -1302,    -33,     21,   -141,   -168,   -195,   -114,    156,    -33,   -195,     21,     -6,   -168, &
                  -168,   1560,     21,   1749,    210,  -1302,    156,    534,    102,    480,   -222,    210,    156,    210, &
                  -195,    318,     48,   -357,    102,    399,     -6,    264,     -6,   -168,     21,   -141,    -33,   -195, &
                  -222,    210,    210,   -141,    399,     48,   1533,     21]
  K1( 649,:) = [  -1518,    372,     -6,   1506,    183,   -492,   1533,   -222,   -249,    399,    237,    102,    210,   -222, &
                  -195,    -33,     -6,     21,    -33,    264,     48,    156,    -60,    210,  -3084,    264,    372,    -60, &
                   318,   -600,     21,    210,     -6,    210,     -6,    156,  -1302,    210,  -1896,     21,  -1950,   -168, &
                   156,    210,     48,    -33,    -60,    264, -12291,   1506,   1533,   -195,   -168,  -1950,     -6,    -60, &
                    21,   -195,     21,     -6,  -1518,    210,  -3084,    399,  -3030,  -2652,     -6,    210,    372,  -1302, &
                 -1140,    696,  -1140,    372,    210,    183,    156,     -6,    696,    264,  -1302,    183,    102,    237, &
                    -6,     21,    372,    -33,    183,    318,  -1140,    210,    696,  -1302,     -6,    372,    372,  -2004, &
                  -222,   -546,    156,     -6,    264,   -168,    210,    -60,    588,  -1464,   1506,   -222,    -60,    210, &
                   372,    264,    264,    156,   -816,    588,  -2004,   -168]
  K1( 650,:) = [    372,  -1518,    183,   -492,     -6,   1506,   -222,   1533,    237,    102,   -249,    399,    -33,    264, &
                    48,    156,    -60,    210,    210,   -222,   -195,    -33,     -6,     21,    264,  -3084,    318,   -600, &
                   372,    -60,    210,     21,     -6,    156,     -6,    210,    156,    210,     48,    -33,    -60,    264, &
                 -1302,    210,  -1896,     21,  -1950,   -168,   1506, -12291,   -168,  -1950,   1533,   -195,    -60,     -6, &
                    21,     -6,     21,   -195,     -6,    210,    372,  -1302,  -1140,    696,  -1518,    210,  -3084,    399, &
                 -3030,  -2652,    372,  -2004,   -222,   -546,    156,     -6,    264,   -168,    210,    -60,    588,  -1464, &
                  1506,   -222,    -60,    210,    372,    264,    264,    156,   -816,    588,  -2004,   -168,  -1140,    372, &
                   210,    183,    156,     -6,    696,    264,  -1302,    183,    102,    237,     -6,     21,    372,    -33, &
                   183,    318,  -1140,    210,    696,  -1302,     -6,    372]
  K1( 651,:) = [    210,    -33,    210,   -222,     21,    264,   -141,   -141,   -168,     -6,   -168,     -6,  -1464,     48, &
                  1533,     -6,    264,   -195,   -195,     48,   -114,   -195,   -222,     48,    399,    156,  -1302,    210, &
                   -33,    210,     48,   -195,   -357,     48,     21,   -195,     48,   -384,   1344,   -195,    318,   -141, &
                    -6,     -6,   -168,   -141,   -168,   -141,   1533,   -168,   1560,   -168,   1560,   1533,     21,     21, &
                  3072,   -357,   1749,   1344,   1533,   -141,     21,     48,    210,    399,    210,  -1464,  -1302,     48, &
                   210,  -1302,    210,   -222,   1560,   -168,    534,   -114,  -1302,    210,   1749,     21,    480,   -168, &
                  -168,   -141,     21,   -195,    -33,    156,    156,   -195,    102,     -6,     21,    -33,    156,    156, &
                   534,    264,    912,   -222,    102,    588,    480,    318,    480,   -168,   -222,     48,    210,   -384, &
                  -222,    210,    156,     48,    588,     -6,    264,    210]
  K1( 652,:) = [     -6,    -60,     -6,     -6,    183,    -60,   -357,    318,    102,   -168,   -384,    264,     21,    264, &
                  -384,   -168,  -1896,   1533,     21,   -222,    102,     21,    480,   -222,   -249,   -546,    237,  -1950, &
                   183,    -60,   -168,    264,    102,   -357,   -384,    318,   -168,    318,   -384,   -114,   -816,   1344, &
                  -168,   -168,   -384,   -168,   -384,   -168,   -195,  -1950,   -168,   -384,   1533,  -1896,   -195,     -6, &
                  -357,   2640,   1344,   -816,   -249,   -168,     -6,   -357,   -195,   -195,   -195,   1533,  -1896,   1344, &
                 -1950,     -6,    183,   -546,   -168,   -384,    264,   -384,    183,    -60,     21,    102,    318,   -384, &
                   237,   -168,     -6,   -114,     48,     48,     -6,   1344,  -1950,   1533,  -1896,   -195,     -6,     -6, &
                  -114,   -384,   -222,   1317,    237,  -1464,   -168,   -384,   -168,   1317,     48,   -168,     48,   -114, &
                   237,     -6,    -60,   -168,    -60,   -222,  -1464,     -6]
  K1( 653,:) = [    -33,    210,     21,    264,    210,   -222,   -141,   -141,   -168,     -6,   -168,     -6,   -195,     48, &
                  -114,   -195,   -222,     48,  -1464,     48,   1533,     -6,    264,   -195,    156,    399,    -33,    210, &
                 -1302,    210,   -195,     48,     21,   -195,   -357,     48,     -6,     -6,   -168,   -141,   -168,   -141, &
                    48,   -384,   1344,   -195,    318,   -141,   -168,   1533,   1560,   1533,   1560,   -168,     21,     21, &
                  1749,   1344,   3072,   -357,    210,  -1464,  -1302,     48,    210,  -1302,   1533,   -141,     21,     48, &
                   210,    399,    156,    156,    534,    264,    912,   -222,    102,    588,    480,    318,    480,   -168, &
                  -222,     48,    210,   -384,   -222,    210,    156,     48,    588,     -6,    264,    210,    210,   -222, &
                  1560,   -168,    534,   -114,  -1302,    210,   1749,     21,    480,   -168,   -168,   -141,     21,   -195, &
                   -33,    156,    156,   -195,    102,     -6,     21,    -33]
  K1( 654,:) = [    -60,     -6,    183,    -60,     -6,     -6,    318,   -357,   -384,    264,    102,   -168,     21,   -222, &
                   102,     21,    480,   -222,     21,    264,   -384,   -168,  -1896,   1533,   -546,   -249,    183,    -60, &
                   237,  -1950,    264,   -168,   -384,    318,    102,   -357,   -168,   -168,   -384,   -168,   -384,   -168, &
                  -168,    318,   -384,   -114,   -816,   1344,  -1950,   -195,   1533,  -1896,   -168,   -384,     -6,   -195, &
                  1344,   -816,   -357,   2640,   -195,   1533,  -1896,   1344,  -1950,     -6,   -249,   -168,     -6,   -357, &
                  -195,   -195,     -6,     -6,   -114,   -384,   -222,   1317,    237,  -1464,   -168,   -384,   -168,   1317, &
                    48,   -168,     48,   -114,    237,     -6,    -60,   -168,    -60,   -222,  -1464,     -6,    183,   -546, &
                  -168,   -384,    264,   -384,    183,    -60,     21,    102,    318,   -384,    237,   -168,     -6,   -114, &
                    48,     48,     -6,   1344,  -1950,   1533,  -1896,   -195]
  K1( 655,:) = [  -3084,    264,    372,    -60,    318,   -600,     21,    210,     -6,    210,     -6,    156,  -1302,    210, &
                 -1896,     21,  -1950,   -168,    156,    210,     48,    -33,    -60,    264,  -1518,    372,     -6,   1506, &
                   183,   -492,   1533,   -222,   -249,    399,    237,    102,    210,   -222,   -195,    -33,     -6,     21, &
                   -33,    264,     48,    156,    -60,    210,     -6,    -60,     21,   -195,     21,     -6, -12291,   1506, &
                  1533,   -195,   -168,  -1950,  -3084,    399,  -1518,    210,  -2652,  -3030,    372,  -1302,     -6,    210, &
                   696,  -1140,    696,    264,  -1302,    183,    102,    237,  -1140,    372,    210,    183,    156,     -6, &
                   372,    -33,     -6,     21,    318,    183,    696,  -1302,  -1140,    210,    372,     -6,    264,   -168, &
                   210,    -60,    588,  -1464,    372,  -2004,   -222,   -546,    156,     -6,    -60,    210,   1506,   -222, &
                   264,    372,   -816,    588,    264,    156,   -168,  -2004]
  K1( 656,:) = [    264,  -3084,    318,   -600,    372,    -60,    210,     21,     -6,    156,     -6,    210,    156,    210, &
                    48,    -33,    -60,    264,  -1302,    210,  -1896,     21,  -1950,   -168,    372,  -1518,    183,   -492, &
                    -6,   1506,   -222,   1533,    237,    102,   -249,    399,    -33,    264,     48,    156,    -60,    210, &
                   210,   -222,   -195,    -33,     -6,     21,    -60,     -6,     21,     -6,     21,   -195,   1506, -12291, &
                  -168,  -1950,   1533,   -195,    372,  -1302,     -6,    210,    696,  -1140,  -3084,    399,  -1518,    210, &
                 -2652,  -3030,    264,   -168,    210,    -60,    588,  -1464,    372,  -2004,   -222,   -546,    156,     -6, &
                   -60,    210,   1506,   -222,    264,    372,   -816,    588,    264,    156,   -168,  -2004,    696,    264, &
                 -1302,    183,    102,    237,  -1140,    372,    210,    183,    156,     -6,    372,    -33,     -6,     21, &
                   318,    183,    696,  -1302,  -1140,    210,    372,     -6]
  K1( 657,:) = [    399,    156,  -1302,    210,    -33,    210,     48,   -195,   -357,     48,     21,   -195,     48,   -384, &
                  1344,   -195,    318,   -141,     -6,     -6,   -168,   -141,   -168,   -141,    210,    -33,    210,   -222, &
                    21,    264,   -141,   -141,   -168,     -6,   -168,     -6,  -1464,     48,   1533,     -6,    264,   -195, &
                  -195,     48,   -114,   -195,   -222,     48,     21,     21,   3072,   -357,   1749,   1344,   1533,   -168, &
                  1560,   -168,   1560,   1533,     21,     48,   1533,   -141,    399,    210,  -1302,     48,    210,  -1464, &
                 -1302,    210,  -1302,    210,   1749,     21,    480,   -168,    210,   -222,   1560,   -168,    534,   -114, &
                    21,   -195,   -168,   -141,    156,    -33,    102,     -6,    156,   -195,    -33,     21,    102,    588, &
                   480,    318,    480,   -168,    156,    156,    534,    264,    912,   -222,    210,   -384,   -222,     48, &
                   210,   -222,    588,     -6,    156,     48,    210,    264]
  K1( 658,:) = [   -249,   -546,    237,  -1950,    183,    -60,   -168,    264,    102,   -357,   -384,    318,   -168,    318, &
                  -384,   -114,   -816,   1344,   -168,   -168,   -384,   -168,   -384,   -168,     -6,    -60,     -6,     -6, &
                   183,    -60,   -357,    318,    102,   -168,   -384,    264,     21,    264,   -384,   -168,  -1896,   1533, &
                    21,   -222,    102,     21,    480,   -222,   -195,     -6,   -357,   2640,   1344,   -816,   -195,  -1950, &
                  -168,   -384,   1533,  -1896,     -6,   -357,   -249,   -168,   -195,   -195,  -1896,   1344,   -195,   1533, &
                    -6,  -1950,    183,    -60,     21,    102,    318,   -384,    183,   -546,   -168,   -384,    264,   -384, &
                    -6,   -114,    237,   -168,     48,     48,  -1950,   1533,     -6,   1344,   -195,  -1896,    237,  -1464, &
                  -168,   -384,   -168,   1317,     -6,     -6,   -114,   -384,   -222,   1317,     48,   -114,     48,   -168, &
                    -6,    237,    -60,   -222,    -60,   -168,     -6,  -1464]
  K1( 659,:) = [    156,    399,    -33,    210,  -1302,    210,   -195,     48,     21,   -195,   -357,     48,     -6,     -6, &
                  -168,   -141,   -168,   -141,     48,   -384,   1344,   -195,    318,   -141,    -33,    210,     21,    264, &
                   210,   -222,   -141,   -141,   -168,     -6,   -168,     -6,   -195,     48,   -114,   -195,   -222,     48, &
                 -1464,     48,   1533,     -6,    264,   -195,     21,     21,   1749,   1344,   3072,   -357,   -168,   1533, &
                  1560,   1533,   1560,   -168,  -1302,     48,    210,  -1464,  -1302,    210,     21,     48,   1533,   -141, &
                   399,    210,    102,    588,    480,    318,    480,   -168,    156,    156,    534,    264,    912,   -222, &
                   210,   -384,   -222,     48,    210,   -222,    588,     -6,    156,     48,    210,    264,  -1302,    210, &
                  1749,     21,    480,   -168,    210,   -222,   1560,   -168,    534,   -114,     21,   -195,   -168,   -141, &
                   156,    -33,    102,     -6,    156,   -195,    -33,     21]
  K1( 660,:) = [   -546,   -249,    183,    -60,    237,  -1950,    264,   -168,   -384,    318,    102,   -357,   -168,   -168, &
                  -384,   -168,   -384,   -168,   -168,    318,   -384,   -114,   -816,   1344,    -60,     -6,    183,    -60, &
                    -6,     -6,    318,   -357,   -384,    264,    102,   -168,     21,   -222,    102,     21,    480,   -222, &
                    21,    264,   -384,   -168,  -1896,   1533,     -6,   -195,   1344,   -816,   -357,   2640,  -1950,   -195, &
                  1533,  -1896,   -168,   -384,  -1896,   1344,   -195,   1533,     -6,  -1950,     -6,   -357,   -249,   -168, &
                  -195,   -195,    237,  -1464,   -168,   -384,   -168,   1317,     -6,     -6,   -114,   -384,   -222,   1317, &
                    48,   -114,     48,   -168,     -6,    237,    -60,   -222,    -60,   -168,     -6,  -1464,    183,    -60, &
                    21,    102,    318,   -384,    183,   -546,   -168,   -384,    264,   -384,     -6,   -114,    237,   -168, &
                    48,     48,  -1950,   1533,     -6,   1344,   -195,  -1896]
  K1( 661,:) = [  -3030,    183,  -1140,    372,     -6,  -2004,    210,     21,   -195,    399,    183,    -33,    210,   -222, &
                 -1950,    102,   -546,    156,    210,    156,     -6,     21,     -6,    210,  -2652,    318,    696,    264, &
                   372,   -168,    399,    -33,   -195,    210,    183,     21,  -1302,    210,     -6,    156,    -60,    -33, &
                 -1302,    588,    237,   -168,  -1464,    264,  -1518,     -6,   1533,   -249,    210,   -195,  -3084,    372, &
                    21,     -6,  -1302,  -1896, -12291,   1533,     -6,     21,  -1518,  -3084,  -1140,    210,    696,  -1302, &
                    -6,    372,     -6,   1506,   -168,    237,   -222,     48,    372,    -60,     21,     -6,    210,     48, &
                  1506,   -222,    -60,    210,    372,    264,    372,    -33,    264,    156,    183,    318,  -1140,    264, &
                   156,     -6,    156,    -60,    696,   -816,    102,  -1950,    588,    -60,    372,   -222,    264,    210, &
                  1506,    -60,  -2004,    264,   -168,    210,   -492,   -600]
  K1( 662,:) = [    210,    -33,    156,    156,    210,    156,     48,   -195,   -357,     48,     21,   -195,   -195,    534, &
                   318,    480,    264,     -6,  -1464,    912,     21,   1749,   -222,     -6,    399,    156,    102,    102, &
                 -1302,    588,     -6,     -6,   -168,   -141,   -168,   -141,     -6,    480,    264,    534,    318,   -195, &
                    48,    480,   -168,   1560,   -168,     48,    210,    210,   -141,   -168,  -1464,   1533,    399,  -1302, &
                    48,   -357,     48,   1344,   1533,   1560,     21,   3072,   1533,     21,    210,   1560,  -1302,   1749, &
                  -168,     21,     21,   -222,   -141,   -168,     48,   -168,    -33,    210,   -195,   -114,   -384,   -114, &
                  -222,     48,    210,   -384,   -222,    210,   -222,   -141,    210,   -195,     21,    -33,    210,    156, &
                  -195,   1344,     48,   -168,  -1302,    588,     -6,   1533,     -6,   -222,    -33,   -141,    156,   -195, &
                  -168,     21,    264,   -141,    210,     48,    264,    210]
  K1( 663,:) = [  -2652,    318,    696,    264,    372,   -168,    399,    -33,   -195,    210,    183,     21,  -1302,    210, &
                    -6,    156,    -60,    -33,  -1302,    588,    237,   -168,  -1464,    264,  -3030,    183,  -1140,    372, &
                    -6,  -2004,    210,     21,   -195,    399,    183,    -33,    210,   -222,  -1950,    102,   -546,    156, &
                   210,    156,     -6,     21,     -6,    210,  -3084,    372,     21,     -6,  -1302,  -1896,  -1518,     -6, &
                  1533,   -249,    210,   -195,     -6,     21, -12291,   1533,  -3084,  -1518,    696,  -1302,  -1140,    210, &
                   372,     -6,    372,    -60,     21,     -6,    210,     48,     -6,   1506,   -168,    237,   -222,     48, &
                   -60,    210,   1506,   -222,    264,    372,    264,    156,    372,    -33,    318,    183,    696,   -816, &
                   102,  -1950,    588,    -60,  -1140,    264,    156,     -6,    156,    -60,    264,    210,    372,   -222, &
                   -60,   1506,   -168,    210,  -2004,    264,   -600,   -492]
  K1( 664,:) = [    399,    156,    102,    102,  -1302,    588,     -6,     -6,   -168,   -141,   -168,   -141,     -6,    480, &
                   264,    534,    318,   -195,     48,    480,   -168,   1560,   -168,     48,    210,    -33,    156,    156, &
                   210,    156,     48,   -195,   -357,     48,     21,   -195,   -195,    534,    318,    480,    264,     -6, &
                 -1464,    912,     21,   1749,   -222,     -6,    399,  -1302,     48,   -357,     48,   1344,    210,    210, &
                  -141,   -168,  -1464,   1533,     21,   3072,   1533,   1560,     21,   1533,  -1302,   1749,    210,   1560, &
                    21,   -168,    -33,    210,   -195,   -114,   -384,   -114,     21,   -222,   -141,   -168,     48,   -168, &
                   210,   -384,   -222,     48,    210,   -222,    210,   -195,   -222,   -141,    -33,     21,  -1302,    588, &
                    -6,   1533,     -6,   -222,    210,    156,   -195,   1344,     48,   -168,    156,   -195,    -33,   -141, &
                    21,   -168,    210,     48,    264,   -141,    210,    264]
  K1( 665,:) = [  -1518,    372,    372,  -1140,  -1140,    264,    210,    156,     -6,     21,     -6,    210,    -33,    156, &
                   -60,    210,     -6,  -1302,    210,    156,    183,  -1302,    -60,    588,  -3084,    264,    264,    696, &
                   696,   -816,    399,    102,   -249,   1533,    237,   -222,    156,    102,   -546,   -222,  -1950,    210, &
                 -1302,    588,    183,    210,    -60,    156,  -3030,  -1140,    210,   -195,    210,  -1950,  -2652,    696, &
                   399,   -195,  -1302,     -6,  -1518,   1533,  -3084,     21, -12291,     -6,     -6,   -168,    372,     21, &
                  1506,    -60,    183,    372,    -33,     48,   -222,    237,    318,    264,    156,     48,    210,     -6, &
                   372,   -222,    264,    210,   1506,    -60,   1506,   -168,    -60,     21,     -6,    372,     -6,  -2004, &
                    21,  -1896,    264,  -1464,    372,   -168,    -33,   -195,    210,     -6,    183,     21,    318,    -33, &
                    -6,    372,   -492,    264,   -600,    210,  -2004,   -168]
  K1( 666,:) = [  -3084,    264,    264,    696,    696,   -816,    399,    102,   -249,   1533,    237,   -222,    156,    102, &
                  -546,   -222,  -1950,    210,  -1302,    588,    183,    210,    -60,    156,  -1518,    372,    372,  -1140, &
                 -1140,    264,    210,    156,     -6,     21,     -6,    210,    -33,    156,    -60,    210,     -6,  -1302, &
                   210,    156,    183,  -1302,    -60,    588,  -2652,    696,    399,   -195,  -1302,     -6,  -3030,  -1140, &
                   210,   -195,    210,  -1950,  -3084,     21,  -1518,   1533,     -6, -12291,    372,     21,     -6,   -168, &
                   -60,   1506,    318,    264,    156,     48,    210,     -6,    183,    372,    -33,     48,   -222,    237, &
                   264,    210,    372,   -222,    -60,   1506,    -60,     21,   1506,   -168,    372,     -6,    372,   -168, &
                   -33,   -195,    210,     -6,     -6,  -2004,     21,  -1896,    264,  -1464,    318,    -33,    183,     21, &
                   372,     -6,   -600,    210,   -492,    264,   -168,  -2004]
  K1( 667,:) = [    183,  -3030,     -6,  -2004,  -1140,    372,     21,    210,    183,    -33,   -195,    399,    210,    156, &
                    -6,     21,     -6,    210,    210,   -222,  -1950,    102,   -546,    156,    318,  -2652,    372,   -168, &
                   696,    264,    -33,    399,    183,     21,   -195,    210,  -1302,    588,    237,   -168,  -1464,    264, &
                 -1302,    210,     -6,    156,    -60,    -33,     -6,  -1518,    210,   -195,   1533,   -249,    372,  -3084, &
                 -1302,  -1896,     21,     -6,  -1140,    210,    696,  -1302,     -6,    372, -12291,   1533,     -6,     21, &
                 -1518,  -3084,  -1140,    264,    156,     -6,    156,    -60,    696,   -816,    102,  -1950,    588,    -60, &
                   372,   -222,    264,    210,   1506,    -60,  -2004,    264,   -168,    210,   -492,   -600,     -6,   1506, &
                  -168,    237,   -222,     48,    372,    -60,     21,     -6,    210,     48,   1506,   -222,    -60,    210, &
                   372,    264,    372,    -33,    264,    156,    183,    318]
  K1( 668,:) = [    -33,    210,    210,    156,    156,    156,   -195,     48,     21,   -195,   -357,     48,  -1464,    912, &
                    21,   1749,   -222,     -6,   -195,    534,    318,    480,    264,     -6,    156,    399,  -1302,    588, &
                   102,    102,     -6,     -6,   -168,   -141,   -168,   -141,     48,    480,   -168,   1560,   -168,     48, &
                    -6,    480,    264,    534,    318,   -195,    210,    210,  -1464,   1533,   -141,   -168,  -1302,    399, &
                    48,   1344,     48,   -357,    210,   1560,  -1302,   1749,   -168,     21,   1533,   1560,     21,   3072, &
                  1533,     21,    210,    156,   -195,   1344,     48,   -168,  -1302,    588,     -6,   1533,     -6,   -222, &
                   -33,   -141,    156,   -195,   -168,     21,    264,   -141,    210,     48,    264,    210,     21,   -222, &
                  -141,   -168,     48,   -168,    -33,    210,   -195,   -114,   -384,   -114,   -222,     48,    210,   -384, &
                  -222,    210,   -222,   -141,    210,   -195,     21,    -33]
  K1( 669,:) = [    318,  -2652,    372,   -168,    696,    264,    -33,    399,    183,     21,   -195,    210,  -1302,    588, &
                   237,   -168,  -1464,    264,  -1302,    210,     -6,    156,    -60,    -33,    183,  -3030,     -6,  -2004, &
                 -1140,    372,     21,    210,    183,    -33,   -195,    399,    210,    156,     -6,     21,     -6,    210, &
                   210,   -222,  -1950,    102,   -546,    156,    372,  -3084,  -1302,  -1896,     21,     -6,     -6,  -1518, &
                   210,   -195,   1533,   -249,    696,  -1302,  -1140,    210,    372,     -6,     -6,     21, -12291,   1533, &
                 -3084,  -1518,    696,   -816,    102,  -1950,    588,    -60,  -1140,    264,    156,     -6,    156,    -60, &
                   264,    210,    372,   -222,    -60,   1506,   -168,    210,  -2004,    264,   -600,   -492,    372,    -60, &
                    21,     -6,    210,     48,     -6,   1506,   -168,    237,   -222,     48,    -60,    210,   1506,   -222, &
                   264,    372,    264,    156,    372,    -33,    318,    183]
  K1( 670,:) = [    156,    399,  -1302,    588,    102,    102,     -6,     -6,   -168,   -141,   -168,   -141,     48,    480, &
                  -168,   1560,   -168,     48,     -6,    480,    264,    534,    318,   -195,    -33,    210,    210,    156, &
                   156,    156,   -195,     48,     21,   -195,   -357,     48,  -1464,    912,     21,   1749,   -222,     -6, &
                  -195,    534,    318,    480,    264,     -6,  -1302,    399,     48,   1344,     48,   -357,    210,    210, &
                 -1464,   1533,   -141,   -168,  -1302,   1749,    210,   1560,     21,   -168,     21,   3072,   1533,   1560, &
                    21,   1533,  -1302,    588,     -6,   1533,     -6,   -222,    210,    156,   -195,   1344,     48,   -168, &
                   156,   -195,    -33,   -141,     21,   -168,    210,     48,    264,   -141,    210,    264,    -33,    210, &
                  -195,   -114,   -384,   -114,     21,   -222,   -141,   -168,     48,   -168,    210,   -384,   -222,     48, &
                   210,   -222,    210,   -195,   -222,   -141,    -33,     21]
  K1( 671,:) = [    372,  -1518,  -1140,    264,    372,  -1140,    156,    210,     -6,    210,     -6,     21,    210,    156, &
                   183,  -1302,    -60,    588,    -33,    156,    -60,    210,     -6,  -1302,    264,  -3084,    696,   -816, &
                   264,    696,    102,    399,    237,   -222,   -249,   1533,  -1302,    588,    183,    210,    -60,    156, &
                   156,    102,   -546,   -222,  -1950,    210,  -1140,  -3030,    210,  -1950,    210,   -195,    696,  -2652, &
                 -1302,     -6,    399,   -195,     -6,   -168,    372,     21,   1506,    -60,  -1518,   1533,  -3084,     21, &
                -12291,     -6,     -6,  -2004,     21,  -1896,    264,  -1464,    372,   -168,    -33,   -195,    210,     -6, &
                   183,     21,    318,    -33,     -6,    372,   -492,    264,   -600,    210,  -2004,   -168,    183,    372, &
                   -33,     48,   -222,    237,    318,    264,    156,     48,    210,     -6,    372,   -222,    264,    210, &
                  1506,    -60,   1506,   -168,    -60,     21,     -6,    372]
  K1( 672,:) = [    264,  -3084,    696,   -816,    264,    696,    102,    399,    237,   -222,   -249,   1533,  -1302,    588, &
                   183,    210,    -60,    156,    156,    102,   -546,   -222,  -1950,    210,    372,  -1518,  -1140,    264, &
                   372,  -1140,    156,    210,     -6,    210,     -6,     21,    210,    156,    183,  -1302,    -60,    588, &
                   -33,    156,    -60,    210,     -6,  -1302,    696,  -2652,  -1302,     -6,    399,   -195,  -1140,  -3030, &
                   210,  -1950,    210,   -195,    372,     21,     -6,   -168,    -60,   1506,  -3084,     21,  -1518,   1533, &
                    -6, -12291,    372,   -168,    -33,   -195,    210,     -6,     -6,  -2004,     21,  -1896,    264,  -1464, &
                   318,    -33,    183,     21,    372,     -6,   -600,    210,   -492,    264,   -168,  -2004,    318,    264, &
                   156,     48,    210,     -6,    183,    372,    -33,     48,   -222,    237,    264,    210,    372,   -222, &
                   -60,   1506,    -60,     21,   1506,   -168,    372,     -6]
  K1( 673,:) = [     -6,   1506,  -1518,    372,   -492,    183,    210,   -222,   -195,    -33,     -6,     21,   1533,   -222, &
                  -249,    399,    237,    102,    264,    -33,    -60,    210,     48,    156,    372,    -60,  -3084,    264, &
                  -600,    318,  -1302,    210,  -1896,     21,  -1950,   -168,     21,    210,     -6,    210,     -6,    156, &
                   210,    156,    -60,    264,     48,    -33,  -1140,    372,    210,    183,    156,     -6,    696,    264, &
                 -1302,    183,    102,    237,     -6,     21,    372,    -33,    183,    318,  -1140,    210,    696,  -1302, &
                    -6,    372, -12291,   1506,   1533,   -195,   -168,  -1950,     -6,    -60,     21,   -195,     21,     -6, &
                 -1518,    210,  -3084,    399,  -3030,  -2652,     -6,    210,    372,  -1302,  -1140,    696,  -2004,    372, &
                   156,     -6,   -222,   -546,   -168,    264,    588,  -1464,    210,    -60,    264,    156,   -816,    588, &
                 -2004,   -168,   1506,   -222,    -60,    210,    372,    264]
  K1( 674,:) = [    183,   -492,    372,  -1518,   1506,     -6,    -33,    264,     48,    156,    -60,    210,   -222,   1533, &
                   237,    102,   -249,    399,   -222,    210,     -6,     21,   -195,    -33,    318,   -600,    264,  -3084, &
                   -60,    372,    156,    210,     48,    -33,    -60,    264,    210,     21,     -6,    156,     -6,    210, &
                   210,  -1302,  -1950,   -168,  -1896,     21,    372,  -2004,   -222,   -546,    156,     -6,    264,   -168, &
                   210,    -60,    588,  -1464,   1506,   -222,    -60,    210,    372,    264,    264,    156,   -816,    588, &
                 -2004,   -168,   1506, -12291,   -168,  -1950,   1533,   -195,    -60,     -6,     21,     -6,     21,   -195, &
                    -6,    210,    372,  -1302,  -1140,    696,  -1518,    210,  -3084,    399,  -3030,  -2652,    372,  -1140, &
                   156,     -6,    210,    183,    264,    696,    102,    237,  -1302,    183,  -1140,    210,    696,  -1302, &
                    -6,    372,     -6,     21,    372,    -33,    183,    318]
  K1( 675,:) = [    210,   -222,    210,    -33,    264,     21,  -1464,     48,   1533,     -6,    264,   -195,   -141,   -141, &
                  -168,     -6,   -168,     -6,     48,   -195,   -222,     48,   -114,   -195,  -1302,    210,    399,    156, &
                   210,    -33,     48,   -384,   1344,   -195,    318,   -141,     48,   -195,   -357,     48,     21,   -195, &
                    -6,     -6,   -168,   -141,   -168,   -141,    210,   -222,   1560,   -168,    534,   -114,  -1302,    210, &
                  1749,     21,    480,   -168,   -168,   -141,     21,   -195,    -33,    156,    156,   -195,    102,     -6, &
                    21,    -33,   1533,   -168,   1560,   -168,   1560,   1533,     21,     21,   3072,   -357,   1749,   1344, &
                  1533,   -141,     21,     48,    210,    399,    210,  -1464,  -1302,     48,    210,  -1302,    156,    156, &
                   912,   -222,    534,    264,    588,    102,    480,   -168,    480,    318,    156,     48,    588,     -6, &
                   264,    210,   -222,     48,    210,   -384,   -222,    210]
  K1( 676,:) = [     -6,     -6,     -6,    -60,    -60,    183,     21,    264,   -384,   -168,  -1896,   1533,   -357,    318, &
                   102,   -168,   -384,    264,   -222,     21,    480,   -222,    102,     21,    237,  -1950,   -249,   -546, &
                   -60,    183,   -168,    318,   -384,   -114,   -816,   1344,   -168,    264,    102,   -357,   -384,    318, &
                  -168,   -168,   -384,   -168,   -384,   -168,    183,   -546,   -168,   -384,    264,   -384,    183,    -60, &
                    21,    102,    318,   -384,    237,   -168,     -6,   -114,     48,     48,     -6,   1344,  -1950,   1533, &
                 -1896,   -195,   -195,  -1950,   -168,   -384,   1533,  -1896,   -195,     -6,   -357,   2640,   1344,   -816, &
                  -249,   -168,     -6,   -357,   -195,   -195,   -195,   1533,  -1896,   1344,  -1950,     -6,     -6,     -6, &
                  -222,   1317,   -114,   -384,  -1464,    237,   -168,   1317,   -168,   -384,    -60,   -168,    -60,   -222, &
                 -1464,     -6,     48,   -168,     48,   -114,    237,     -6]
  K1( 677,:) = [     21,    264,    -33,    210,   -222,    210,   -195,     48,   -114,   -195,   -222,     48,   -141,   -141, &
                  -168,     -6,   -168,     -6,     48,  -1464,    264,   -195,   1533,     -6,    -33,    210,    156,    399, &
                   210,  -1302,     -6,     -6,   -168,   -141,   -168,   -141,   -195,     48,     21,   -195,   -357,     48, &
                  -384,     48,    318,   -141,   1344,   -195,    156,    156,    534,    264,    912,   -222,    102,    588, &
                   480,    318,    480,   -168,   -222,     48,    210,   -384,   -222,    210,    156,     48,    588,     -6, &
                   264,    210,   -168,   1533,   1560,   1533,   1560,   -168,     21,     21,   1749,   1344,   3072,   -357, &
                   210,  -1464,  -1302,     48,    210,  -1302,   1533,   -141,     21,     48,    210,    399,   -222,    210, &
                   534,   -114,   1560,   -168,    210,  -1302,    480,   -168,   1749,     21,    156,   -195,    102,     -6, &
                    21,    -33,   -168,   -141,     21,   -195,    -33,    156]
  K1( 678,:) = [    183,    -60,    -60,     -6,     -6,     -6,     21,   -222,    102,     21,    480,   -222,    318,   -357, &
                  -384,    264,    102,   -168,    264,     21,  -1896,   1533,   -384,   -168,    183,    -60,   -546,   -249, &
                 -1950,    237,   -168,   -168,   -384,   -168,   -384,   -168,    264,   -168,   -384,    318,    102,   -357, &
                   318,   -168,   -816,   1344,   -384,   -114,     -6,     -6,   -114,   -384,   -222,   1317,    237,  -1464, &
                  -168,   -384,   -168,   1317,     48,   -168,     48,   -114,    237,     -6,    -60,   -168,    -60,   -222, &
                 -1464,     -6,  -1950,   -195,   1533,  -1896,   -168,   -384,     -6,   -195,   1344,   -816,   -357,   2640, &
                  -195,   1533,  -1896,   1344,  -1950,     -6,   -249,   -168,     -6,   -357,   -195,   -195,   -546,    183, &
                   264,   -384,   -168,   -384,    -60,    183,    318,   -384,     21,    102,     -6,   1344,  -1950,   1533, &
                 -1896,   -195,    237,   -168,     -6,   -114,     48,     48]
  K1( 679,:) = [    372,    -60,  -3084,    264,   -600,    318,  -1302,    210,  -1896,     21,  -1950,   -168,     21,    210, &
                    -6,    210,     -6,    156,    210,    156,    -60,    264,     48,    -33,     -6,   1506,  -1518,    372, &
                  -492,    183,    210,   -222,   -195,    -33,     -6,     21,   1533,   -222,   -249,    399,    237,    102, &
                   264,    -33,    -60,    210,     48,    156,    696,    264,  -1302,    183,    102,    237,  -1140,    372, &
                   210,    183,    156,     -6,    372,    -33,     -6,     21,    318,    183,    696,  -1302,  -1140,    210, &
                   372,     -6,     -6,    -60,     21,   -195,     21,     -6, -12291,   1506,   1533,   -195,   -168,  -1950, &
                 -3084,    399,  -1518,    210,  -2652,  -3030,    372,  -1302,     -6,    210,    696,  -1140,   -168,    264, &
                   588,  -1464,    210,    -60,  -2004,    372,    156,     -6,   -222,   -546,   -816,    588,    264,    156, &
                  -168,  -2004,    -60,    210,   1506,   -222,    264,    372]
  K1( 680,:) = [    318,   -600,    264,  -3084,    -60,    372,    156,    210,     48,    -33,    -60,    264,    210,     21, &
                    -6,    156,     -6,    210,    210,  -1302,  -1950,   -168,  -1896,     21,    183,   -492,    372,  -1518, &
                  1506,     -6,    -33,    264,     48,    156,    -60,    210,   -222,   1533,    237,    102,   -249,    399, &
                  -222,    210,     -6,     21,   -195,    -33,    264,   -168,    210,    -60,    588,  -1464,    372,  -2004, &
                  -222,   -546,    156,     -6,    -60,    210,   1506,   -222,    264,    372,   -816,    588,    264,    156, &
                  -168,  -2004,    -60,     -6,     21,     -6,     21,   -195,   1506, -12291,   -168,  -1950,   1533,   -195, &
                   372,  -1302,     -6,    210,    696,  -1140,  -3084,    399,  -1518,    210,  -2652,  -3030,    264,    696, &
                   102,    237,  -1302,    183,    372,  -1140,    156,     -6,    210,    183,    696,  -1302,  -1140,    210, &
                   372,     -6,    372,    -33,     -6,     21,    318,    183]
  K1( 681,:) = [  -1302,    210,    399,    156,    210,    -33,     48,   -384,   1344,   -195,    318,   -141,     48,   -195, &
                  -357,     48,     21,   -195,     -6,     -6,   -168,   -141,   -168,   -141,    210,   -222,    210,    -33, &
                   264,     21,  -1464,     48,   1533,     -6,    264,   -195,   -141,   -141,   -168,     -6,   -168,     -6, &
                    48,   -195,   -222,     48,   -114,   -195,  -1302,    210,   1749,     21,    480,   -168,    210,   -222, &
                  1560,   -168,    534,   -114,     21,   -195,   -168,   -141,    156,    -33,    102,     -6,    156,   -195, &
                   -33,     21,     21,     21,   3072,   -357,   1749,   1344,   1533,   -168,   1560,   -168,   1560,   1533, &
                    21,     48,   1533,   -141,    399,    210,  -1302,     48,    210,  -1464,  -1302,    210,    588,    102, &
                   480,   -168,    480,    318,    156,    156,    912,   -222,    534,    264,    588,     -6,    156,     48, &
                   210,    264,    210,   -384,   -222,     48,    210,   -222]
  K1( 682,:) = [    237,  -1950,   -249,   -546,    -60,    183,   -168,    318,   -384,   -114,   -816,   1344,   -168,    264, &
                   102,   -357,   -384,    318,   -168,   -168,   -384,   -168,   -384,   -168,     -6,     -6,     -6,    -60, &
                   -60,    183,     21,    264,   -384,   -168,  -1896,   1533,   -357,    318,    102,   -168,   -384,    264, &
                  -222,     21,    480,   -222,    102,     21,    183,    -60,     21,    102,    318,   -384,    183,   -546, &
                  -168,   -384,    264,   -384,     -6,   -114,    237,   -168,     48,     48,  -1950,   1533,     -6,   1344, &
                  -195,  -1896,   -195,     -6,   -357,   2640,   1344,   -816,   -195,  -1950,   -168,   -384,   1533,  -1896, &
                    -6,   -357,   -249,   -168,   -195,   -195,  -1896,   1344,   -195,   1533,     -6,  -1950,  -1464,    237, &
                  -168,   1317,   -168,   -384,     -6,     -6,   -222,   1317,   -114,   -384,    -60,   -222,    -60,   -168, &
                    -6,  -1464,     48,   -114,     48,   -168,     -6,    237]
  K1( 683,:) = [    -33,    210,    156,    399,    210,  -1302,     -6,     -6,   -168,   -141,   -168,   -141,   -195,     48, &
                    21,   -195,   -357,     48,   -384,     48,    318,   -141,   1344,   -195,     21,    264,    -33,    210, &
                  -222,    210,   -195,     48,   -114,   -195,   -222,     48,   -141,   -141,   -168,     -6,   -168,     -6, &
                    48,  -1464,    264,   -195,   1533,     -6,    102,    588,    480,    318,    480,   -168,    156,    156, &
                   534,    264,    912,   -222,    210,   -384,   -222,     48,    210,   -222,    588,     -6,    156,     48, &
                   210,    264,     21,     21,   1749,   1344,   3072,   -357,   -168,   1533,   1560,   1533,   1560,   -168, &
                 -1302,     48,    210,  -1464,  -1302,    210,     21,     48,   1533,   -141,    399,    210,    210,  -1302, &
                   480,   -168,   1749,     21,   -222,    210,    534,   -114,   1560,   -168,    102,     -6,    156,   -195, &
                   -33,     21,     21,   -195,   -168,   -141,    156,    -33]
  K1( 684,:) = [    183,    -60,   -546,   -249,  -1950,    237,   -168,   -168,   -384,   -168,   -384,   -168,    264,   -168, &
                  -384,    318,    102,   -357,    318,   -168,   -816,   1344,   -384,   -114,    183,    -60,    -60,     -6, &
                    -6,     -6,     21,   -222,    102,     21,    480,   -222,    318,   -357,   -384,    264,    102,   -168, &
                   264,     21,  -1896,   1533,   -384,   -168,    237,  -1464,   -168,   -384,   -168,   1317,     -6,     -6, &
                  -114,   -384,   -222,   1317,     48,   -114,     48,   -168,     -6,    237,    -60,   -222,    -60,   -168, &
                    -6,  -1464,     -6,   -195,   1344,   -816,   -357,   2640,  -1950,   -195,   1533,  -1896,   -168,   -384, &
                 -1896,   1344,   -195,   1533,     -6,  -1950,     -6,   -357,   -249,   -168,   -195,   -195,    -60,    183, &
                   318,   -384,     21,    102,   -546,    183,    264,   -384,   -168,   -384,  -1950,   1533,     -6,   1344, &
                  -195,  -1896,     -6,   -114,    237,   -168,     48,     48]
  K1( 685,:) = [  -1140,    372,  -3030,    183,  -2004,     -6,    210,   -222,  -1950,    102,   -546,    156,    210,     21, &
                  -195,    399,    183,    -33,    156,    210,     -6,    210,     -6,     21,    696,    264,  -2652,    318, &
                  -168,    372,  -1302,    210,     -6,    156,    -60,    -33,    399,    -33,   -195,    210,    183,     21, &
                   588,  -1302,  -1464,    264,    237,   -168,     -6,   1506,   -168,    237,   -222,     48,    372,    -60, &
                    21,     -6,    210,     48,   1506,   -222,    -60,    210,    372,    264,    372,    -33,    264,    156, &
                   183,    318,  -1518,     -6,   1533,   -249,    210,   -195,  -3084,    372,     21,     -6,  -1302,  -1896, &
                -12291,   1533,     -6,     21,  -1518,  -3084,  -1140,    210,    696,  -1302,     -6,    372,    264,  -1140, &
                   156,    -60,    156,     -6,   -816,    696,    588,    -60,    102,  -1950,  -2004,    264,   -168,    210, &
                  -492,   -600,    372,   -222,    264,    210,   1506,    -60]
  K1( 686,:) = [    156,    156,    210,    -33,    156,    210,   -195,    534,    318,    480,    264,     -6,     48,   -195, &
                  -357,     48,     21,   -195,    912,  -1464,   -222,     -6,     21,   1749,    102,    102,    399,    156, &
                   588,  -1302,     -6,    480,    264,    534,    318,   -195,     -6,     -6,   -168,   -141,   -168,   -141, &
                   480,     48,   -168,     48,   -168,   1560,     21,   -222,   -141,   -168,     48,   -168,    -33,    210, &
                  -195,   -114,   -384,   -114,   -222,     48,    210,   -384,   -222,    210,   -222,   -141,    210,   -195, &
                    21,    -33,    210,    210,   -141,   -168,  -1464,   1533,    399,  -1302,     48,   -357,     48,   1344, &
                  1533,   1560,     21,   3072,   1533,     21,    210,   1560,  -1302,   1749,   -168,     21,    156,    210, &
                    48,   -168,   -195,   1344,    588,  -1302,     -6,   -222,     -6,   1533,    264,   -141,    210,     48, &
                   264,    210,    -33,   -141,    156,   -195,   -168,     21]
  K1( 687,:) = [    696,    264,  -2652,    318,   -168,    372,  -1302,    210,     -6,    156,    -60,    -33,    399,    -33, &
                  -195,    210,    183,     21,    588,  -1302,  -1464,    264,    237,   -168,  -1140,    372,  -3030,    183, &
                 -2004,     -6,    210,   -222,  -1950,    102,   -546,    156,    210,     21,   -195,    399,    183,    -33, &
                   156,    210,     -6,    210,     -6,     21,    372,    -60,     21,     -6,    210,     48,     -6,   1506, &
                  -168,    237,   -222,     48,    -60,    210,   1506,   -222,    264,    372,    264,    156,    372,    -33, &
                   318,    183,  -3084,    372,     21,     -6,  -1302,  -1896,  -1518,     -6,   1533,   -249,    210,   -195, &
                    -6,     21, -12291,   1533,  -3084,  -1518,    696,  -1302,  -1140,    210,    372,     -6,   -816,    696, &
                   588,    -60,    102,  -1950,    264,  -1140,    156,    -60,    156,     -6,   -168,    210,  -2004,    264, &
                  -600,   -492,    264,    210,    372,   -222,    -60,   1506]
  K1( 688,:) = [    102,    102,    399,    156,    588,  -1302,     -6,    480,    264,    534,    318,   -195,     -6,     -6, &
                  -168,   -141,   -168,   -141,    480,     48,   -168,     48,   -168,   1560,    156,    156,    210,    -33, &
                   156,    210,   -195,    534,    318,    480,    264,     -6,     48,   -195,   -357,     48,     21,   -195, &
                   912,  -1464,   -222,     -6,     21,   1749,    -33,    210,   -195,   -114,   -384,   -114,     21,   -222, &
                  -141,   -168,     48,   -168,    210,   -384,   -222,     48,    210,   -222,    210,   -195,   -222,   -141, &
                   -33,     21,    399,  -1302,     48,   -357,     48,   1344,    210,    210,   -141,   -168,  -1464,   1533, &
                    21,   3072,   1533,   1560,     21,   1533,  -1302,   1749,    210,   1560,     21,   -168,    588,  -1302, &
                    -6,   -222,     -6,   1533,    156,    210,     48,   -168,   -195,   1344,    210,     48,    264,   -141, &
                   210,    264,    156,   -195,    -33,   -141,     21,   -168]
  K1( 689,:) = [    372,  -1140,  -1518,    372,    264,  -1140,    -33,    156,    -60,    210,     -6,  -1302,    210,    156, &
                    -6,     21,     -6,    210,    156,    210,    -60,    588,    183,  -1302,    264,    696,  -3084,    264, &
                  -816,    696,    156,    102,   -546,   -222,  -1950,    210,    399,    102,   -249,   1533,    237,   -222, &
                   588,  -1302,    -60,    156,    183,    210,    183,    372,    -33,     48,   -222,    237,    318,    264, &
                   156,     48,    210,     -6,    372,   -222,    264,    210,   1506,    -60,   1506,   -168,    -60,     21, &
                    -6,    372,  -3030,  -1140,    210,   -195,    210,  -1950,  -2652,    696,    399,   -195,  -1302,     -6, &
                 -1518,   1533,  -3084,     21, -12291,     -6,     -6,   -168,    372,     21,   1506,    -60,  -2004,     -6, &
                   264,  -1464,     21,  -1896,   -168,    372,    210,     -6,    -33,   -195,   -492,    264,   -600,    210, &
                 -2004,   -168,    183,     21,    318,    -33,     -6,    372]
  K1( 690,:) = [    264,    696,  -3084,    264,   -816,    696,    156,    102,   -546,   -222,  -1950,    210,    399,    102, &
                  -249,   1533,    237,   -222,    588,  -1302,    -60,    156,    183,    210,    372,  -1140,  -1518,    372, &
                   264,  -1140,    -33,    156,    -60,    210,     -6,  -1302,    210,    156,     -6,     21,     -6,    210, &
                   156,    210,    -60,    588,    183,  -1302,    318,    264,    156,     48,    210,     -6,    183,    372, &
                   -33,     48,   -222,    237,    264,    210,    372,   -222,    -60,   1506,    -60,     21,   1506,   -168, &
                   372,     -6,  -2652,    696,    399,   -195,  -1302,     -6,  -3030,  -1140,    210,   -195,    210,  -1950, &
                 -3084,     21,  -1518,   1533,     -6, -12291,    372,     21,     -6,   -168,    -60,   1506,   -168,    372, &
                   210,     -6,    -33,   -195,  -2004,     -6,    264,  -1464,     21,  -1896,   -600,    210,   -492,    264, &
                  -168,  -2004,    318,    -33,    183,     21,    372,     -6]
  K1( 691,:) = [     -6,  -2004,    183,  -3030,    372,  -1140,    210,    156,     -6,     21,     -6,    210,     21,    210, &
                   183,    -33,   -195,    399,   -222,    210,   -546,    156,  -1950,    102,    372,   -168,    318,  -2652, &
                   264,    696,  -1302,    588,    237,   -168,  -1464,    264,    -33,    399,    183,     21,   -195,    210, &
                   210,  -1302,    -60,    -33,     -6,    156,  -1140,    264,    156,     -6,    156,    -60,    696,   -816, &
                   102,  -1950,    588,    -60,    372,   -222,    264,    210,   1506,    -60,  -2004,    264,   -168,    210, &
                  -492,   -600,     -6,  -1518,    210,   -195,   1533,   -249,    372,  -3084,  -1302,  -1896,     21,     -6, &
                 -1140,    210,    696,  -1302,     -6,    372, -12291,   1533,     -6,     21,  -1518,  -3084,   1506,     -6, &
                  -222,     48,   -168,    237,    -60,    372,    210,     48,     21,     -6,    372,    -33,    264,    156, &
                   183,    318,   1506,   -222,    -60,    210,    372,    264]
  K1( 692,:) = [    210,    156,    -33,    210,    156,    156,  -1464,    912,     21,   1749,   -222,     -6,   -195,     48, &
                    21,   -195,   -357,     48,    534,   -195,    264,     -6,    318,    480,  -1302,    588,    156,    399, &
                   102,    102,     48,    480,   -168,   1560,   -168,     48,     -6,     -6,   -168,   -141,   -168,   -141, &
                   480,     -6,    318,   -195,    264,    534,    210,    156,   -195,   1344,     48,   -168,  -1302,    588, &
                    -6,   1533,     -6,   -222,    -33,   -141,    156,   -195,   -168,     21,    264,   -141,    210,     48, &
                   264,    210,    210,    210,  -1464,   1533,   -141,   -168,  -1302,    399,     48,   1344,     48,   -357, &
                   210,   1560,  -1302,   1749,   -168,     21,   1533,   1560,     21,   3072,   1533,     21,   -222,     21, &
                    48,   -168,   -141,   -168,    210,    -33,   -384,   -114,   -195,   -114,   -222,   -141,    210,   -195, &
                    21,    -33,   -222,     48,    210,   -384,   -222,    210]
  K1( 693,:) = [    372,   -168,    318,  -2652,    264,    696,  -1302,    588,    237,   -168,  -1464,    264,    -33,    399, &
                   183,     21,   -195,    210,    210,  -1302,    -60,    -33,     -6,    156,     -6,  -2004,    183,  -3030, &
                   372,  -1140,    210,    156,     -6,     21,     -6,    210,     21,    210,    183,    -33,   -195,    399, &
                  -222,    210,   -546,    156,  -1950,    102,    696,   -816,    102,  -1950,    588,    -60,  -1140,    264, &
                   156,     -6,    156,    -60,    264,    210,    372,   -222,    -60,   1506,   -168,    210,  -2004,    264, &
                  -600,   -492,    372,  -3084,  -1302,  -1896,     21,     -6,     -6,  -1518,    210,   -195,   1533,   -249, &
                   696,  -1302,  -1140,    210,    372,     -6,     -6,     21, -12291,   1533,  -3084,  -1518,    -60,    372, &
                   210,     48,     21,     -6,   1506,     -6,   -222,     48,   -168,    237,    264,    156,    372,    -33, &
                   318,    183,    -60,    210,   1506,   -222,    264,    372]
  K1( 694,:) = [  -1302,    588,    156,    399,    102,    102,     48,    480,   -168,   1560,   -168,     48,     -6,     -6, &
                  -168,   -141,   -168,   -141,    480,     -6,    318,   -195,    264,    534,    210,    156,    -33,    210, &
                   156,    156,  -1464,    912,     21,   1749,   -222,     -6,   -195,     48,     21,   -195,   -357,     48, &
                   534,   -195,    264,     -6,    318,    480,  -1302,    588,     -6,   1533,     -6,   -222,    210,    156, &
                  -195,   1344,     48,   -168,    156,   -195,    -33,   -141,     21,   -168,    210,     48,    264,   -141, &
                   210,    264,  -1302,    399,     48,   1344,     48,   -357,    210,    210,  -1464,   1533,   -141,   -168, &
                 -1302,   1749,    210,   1560,     21,   -168,     21,   3072,   1533,   1560,     21,   1533,    210,    -33, &
                  -384,   -114,   -195,   -114,   -222,     21,     48,   -168,   -141,   -168,    210,   -195,   -222,   -141, &
                   -33,     21,    210,   -384,   -222,     48,    210,   -222]
  K1( 695,:) = [  -1140,    264,    372,  -1518,  -1140,    372,    210,    156,    183,  -1302,    -60,    588,    156,    210, &
                    -6,    210,     -6,     21,    156,    -33,     -6,  -1302,    -60,    210,    696,   -816,    264,  -3084, &
                   696,    264,  -1302,    588,    183,    210,    -60,    156,    102,    399,    237,   -222,   -249,   1533, &
                   102,    156,  -1950,    210,   -546,   -222,     -6,  -2004,     21,  -1896,    264,  -1464,    372,   -168, &
                   -33,   -195,    210,     -6,    183,     21,    318,    -33,     -6,    372,   -492,    264,   -600,    210, &
                 -2004,   -168,  -1140,  -3030,    210,  -1950,    210,   -195,    696,  -2652,  -1302,     -6,    399,   -195, &
                    -6,   -168,    372,     21,   1506,    -60,  -1518,   1533,  -3084,     21, -12291,     -6,    372,    183, &
                  -222,    237,    -33,     48,    264,    318,    210,     -6,    156,     48,   1506,   -168,    -60,     21, &
                    -6,    372,    372,   -222,    264,    210,   1506,    -60]
  K1( 696,:) = [    696,   -816,    264,  -3084,    696,    264,  -1302,    588,    183,    210,    -60,    156,    102,    399, &
                   237,   -222,   -249,   1533,    102,    156,  -1950,    210,   -546,   -222,  -1140,    264,    372,  -1518, &
                 -1140,    372,    210,    156,    183,  -1302,    -60,    588,    156,    210,     -6,    210,     -6,     21, &
                   156,    -33,     -6,  -1302,    -60,    210,    372,   -168,    -33,   -195,    210,     -6,     -6,  -2004, &
                    21,  -1896,    264,  -1464,    318,    -33,    183,     21,    372,     -6,   -600,    210,   -492,    264, &
                  -168,  -2004,    696,  -2652,  -1302,     -6,    399,   -195,  -1140,  -3030,    210,  -1950,    210,   -195, &
                   372,     21,     -6,   -168,    -60,   1506,  -3084,     21,  -1518,   1533,     -6, -12291,    264,    318, &
                   210,     -6,    156,     48,    372,    183,   -222,    237,    -33,     48,    -60,     21,   1506,   -168, &
                   372,     -6,    264,    210,    372,   -222,    -60,   1506]
  K1( 697,:) = [   1506,     -6,   -492,    183,  -1518,    372,   -222,    210,     -6,     21,   -195,    -33,    264,    -33, &
                   -60,    210,     48,    156,   1533,   -222,   -249,    399,    237,    102,    -60,    372,   -600,    318, &
                 -3084,    264,    210,  -1302,  -1950,   -168,  -1896,     21,    210,    156,    -60,    264,     48,    -33, &
                    21,    210,     -6,    210,     -6,    156,    372,  -1140,    156,     -6,    210,    183,    264,    696, &
                   102,    237,  -1302,    183,  -1140,    210,    696,  -1302,     -6,    372,     -6,     21,    372,    -33, &
                   183,    318,  -2004,    372,    156,     -6,   -222,   -546,   -168,    264,    588,  -1464,    210,    -60, &
                   264,    156,   -816,    588,  -2004,   -168,   1506,   -222,    -60,    210,    372,    264, -12291,   1506, &
                  1533,   -195,   -168,  -1950,     -6,    -60,     21,   -195,     21,     -6,  -1518,    210,  -3084,    399, &
                 -3030,  -2652,     -6,    210,    372,  -1302,  -1140,    696]
  K1( 698,:) = [   -492,    183,   1506,     -6,    372,  -1518,    264,    -33,    -60,    210,     48,    156,   -222,    210, &
                    -6,     21,   -195,    -33,   -222,   1533,    237,    102,   -249,    399,   -600,    318,    -60,    372, &
                   264,  -3084,    210,    156,    -60,    264,     48,    -33,    210,  -1302,  -1950,   -168,  -1896,     21, &
                   210,     21,     -6,    156,     -6,    210,  -2004,    372,    156,     -6,   -222,   -546,   -168,    264, &
                   588,  -1464,    210,    -60,    264,    156,   -816,    588,  -2004,   -168,   1506,   -222,    -60,    210, &
                   372,    264,    372,  -1140,    156,     -6,    210,    183,    264,    696,    102,    237,  -1302,    183, &
                 -1140,    210,    696,  -1302,     -6,    372,     -6,     21,    372,    -33,    183,    318,   1506, -12291, &
                  -168,  -1950,   1533,   -195,    -60,     -6,     21,     -6,     21,   -195,     -6,    210,    372,  -1302, &
                 -1140,    696,  -1518,    210,  -3084,    399,  -3030,  -2652]
  K1( 699,:) = [   -222,    210,    264,     21,    210,    -33,     48,  -1464,    264,   -195,   1533,     -6,     48,   -195, &
                  -222,     48,   -114,   -195,   -141,   -141,   -168,     -6,   -168,     -6,    210,  -1302,    210,    -33, &
                   399,    156,   -384,     48,    318,   -141,   1344,   -195,     -6,     -6,   -168,   -141,   -168,   -141, &
                    48,   -195,   -357,     48,     21,   -195,   -222,    210,    534,   -114,   1560,   -168,    210,  -1302, &
                   480,   -168,   1749,     21,    156,   -195,    102,     -6,     21,    -33,   -168,   -141,     21,   -195, &
                   -33,    156,    156,    156,    912,   -222,    534,    264,    588,    102,    480,   -168,    480,    318, &
                   156,     48,    588,     -6,    264,    210,   -222,     48,    210,   -384,   -222,    210,   1533,   -168, &
                  1560,   -168,   1560,   1533,     21,     21,   3072,   -357,   1749,   1344,   1533,   -141,     21,     48, &
                   210,    399,    210,  -1464,  -1302,     48,    210,  -1302]
  K1( 700,:) = [     -6,     -6,    -60,    183,     -6,    -60,    264,     21,  -1896,   1533,   -384,   -168,   -222,     21, &
                   480,   -222,    102,     21,   -357,    318,    102,   -168,   -384,    264,  -1950,    237,    -60,    183, &
                  -249,   -546,    318,   -168,   -816,   1344,   -384,   -114,   -168,   -168,   -384,   -168,   -384,   -168, &
                  -168,    264,    102,   -357,   -384,    318,   -546,    183,    264,   -384,   -168,   -384,    -60,    183, &
                   318,   -384,     21,    102,     -6,   1344,  -1950,   1533,  -1896,   -195,    237,   -168,     -6,   -114, &
                    48,     48,     -6,     -6,   -222,   1317,   -114,   -384,  -1464,    237,   -168,   1317,   -168,   -384, &
                   -60,   -168,    -60,   -222,  -1464,     -6,     48,   -168,     48,   -114,    237,     -6,   -195,  -1950, &
                  -168,   -384,   1533,  -1896,   -195,     -6,   -357,   2640,   1344,   -816,   -249,   -168,     -6,   -357, &
                  -195,   -195,   -195,   1533,  -1896,   1344,  -1950,     -6]
  K1( 701,:) = [    264,     21,   -222,    210,    -33,    210,     48,   -195,   -222,     48,   -114,   -195,     48,  -1464, &
                   264,   -195,   1533,     -6,   -141,   -141,   -168,     -6,   -168,     -6,    210,    -33,    210,  -1302, &
                   156,    399,     -6,     -6,   -168,   -141,   -168,   -141,   -384,     48,    318,   -141,   1344,   -195, &
                  -195,     48,     21,   -195,   -357,     48,    156,    156,    912,   -222,    534,    264,    588,    102, &
                   480,   -168,    480,    318,    156,     48,    588,     -6,    264,    210,   -222,     48,    210,   -384, &
                  -222,    210,   -222,    210,    534,   -114,   1560,   -168,    210,  -1302,    480,   -168,   1749,     21, &
                   156,   -195,    102,     -6,     21,    -33,   -168,   -141,     21,   -195,    -33,    156,   -168,   1533, &
                  1560,   1533,   1560,   -168,     21,     21,   1749,   1344,   3072,   -357,    210,  -1464,  -1302,     48, &
                   210,  -1302,   1533,   -141,     21,     48,    210,    399]
  K1( 702,:) = [    -60,    183,     -6,     -6,    -60,     -6,   -222,     21,    480,   -222,    102,     21,    264,     21, &
                 -1896,   1533,   -384,   -168,    318,   -357,   -384,    264,    102,   -168,    -60,    183,  -1950,    237, &
                  -546,   -249,   -168,   -168,   -384,   -168,   -384,   -168,    318,   -168,   -816,   1344,   -384,   -114, &
                   264,   -168,   -384,    318,    102,   -357,     -6,     -6,   -222,   1317,   -114,   -384,  -1464,    237, &
                  -168,   1317,   -168,   -384,    -60,   -168,    -60,   -222,  -1464,     -6,     48,   -168,     48,   -114, &
                   237,     -6,   -546,    183,    264,   -384,   -168,   -384,    -60,    183,    318,   -384,     21,    102, &
                    -6,   1344,  -1950,   1533,  -1896,   -195,    237,   -168,     -6,   -114,     48,     48,  -1950,   -195, &
                  1533,  -1896,   -168,   -384,     -6,   -195,   1344,   -816,   -357,   2640,   -195,   1533,  -1896,   1344, &
                 -1950,     -6,   -249,   -168,     -6,   -357,   -195,   -195]
  K1( 703,:) = [    -60,    372,   -600,    318,  -3084,    264,    210,  -1302,  -1950,   -168,  -1896,     21,    210,    156, &
                   -60,    264,     48,    -33,     21,    210,     -6,    210,     -6,    156,   1506,     -6,   -492,    183, &
                 -1518,    372,   -222,    210,     -6,     21,   -195,    -33,    264,    -33,    -60,    210,     48,    156, &
                  1533,   -222,   -249,    399,    237,    102,    264,    696,    102,    237,  -1302,    183,    372,  -1140, &
                   156,     -6,    210,    183,    696,  -1302,  -1140,    210,    372,     -6,    372,    -33,     -6,     21, &
                   318,    183,   -168,    264,    588,  -1464,    210,    -60,  -2004,    372,    156,     -6,   -222,   -546, &
                  -816,    588,    264,    156,   -168,  -2004,    -60,    210,   1506,   -222,    264,    372,     -6,    -60, &
                    21,   -195,     21,     -6, -12291,   1506,   1533,   -195,   -168,  -1950,  -3084,    399,  -1518,    210, &
                 -2652,  -3030,    372,  -1302,     -6,    210,    696,  -1140]
  K1( 704,:) = [   -600,    318,    -60,    372,    264,  -3084,    210,    156,    -60,    264,     48,    -33,    210,  -1302, &
                 -1950,   -168,  -1896,     21,    210,     21,     -6,    156,     -6,    210,   -492,    183,   1506,     -6, &
                   372,  -1518,    264,    -33,    -60,    210,     48,    156,   -222,    210,     -6,     21,   -195,    -33, &
                  -222,   1533,    237,    102,   -249,    399,   -168,    264,    588,  -1464,    210,    -60,  -2004,    372, &
                   156,     -6,   -222,   -546,   -816,    588,    264,    156,   -168,  -2004,    -60,    210,   1506,   -222, &
                   264,    372,    264,    696,    102,    237,  -1302,    183,    372,  -1140,    156,     -6,    210,    183, &
                   696,  -1302,  -1140,    210,    372,     -6,    372,    -33,     -6,     21,    318,    183,    -60,     -6, &
                    21,     -6,     21,   -195,   1506, -12291,   -168,  -1950,   1533,   -195,    372,  -1302,     -6,    210, &
                   696,  -1140,  -3084,    399,  -1518,    210,  -2652,  -3030]
  K1( 705,:) = [    210,  -1302,    210,    -33,    399,    156,   -384,     48,    318,   -141,   1344,   -195,     -6,     -6, &
                  -168,   -141,   -168,   -141,     48,   -195,   -357,     48,     21,   -195,   -222,    210,    264,     21, &
                   210,    -33,     48,  -1464,    264,   -195,   1533,     -6,     48,   -195,   -222,     48,   -114,   -195, &
                  -141,   -141,   -168,     -6,   -168,     -6,    210,  -1302,    480,   -168,   1749,     21,   -222,    210, &
                   534,   -114,   1560,   -168,    102,     -6,    156,   -195,    -33,     21,     21,   -195,   -168,   -141, &
                   156,    -33,    588,    102,    480,   -168,    480,    318,    156,    156,    912,   -222,    534,    264, &
                   588,     -6,    156,     48,    210,    264,    210,   -384,   -222,     48,    210,   -222,     21,     21, &
                  3072,   -357,   1749,   1344,   1533,   -168,   1560,   -168,   1560,   1533,     21,     48,   1533,   -141, &
                   399,    210,  -1302,     48,    210,  -1464,  -1302,    210]
  K1( 706,:) = [  -1950,    237,    -60,    183,   -249,   -546,    318,   -168,   -816,   1344,   -384,   -114,   -168,   -168, &
                  -384,   -168,   -384,   -168,   -168,    264,    102,   -357,   -384,    318,     -6,     -6,    -60,    183, &
                    -6,    -60,    264,     21,  -1896,   1533,   -384,   -168,   -222,     21,    480,   -222,    102,     21, &
                  -357,    318,    102,   -168,   -384,    264,    -60,    183,    318,   -384,     21,    102,   -546,    183, &
                   264,   -384,   -168,   -384,  -1950,   1533,     -6,   1344,   -195,  -1896,     -6,   -114,    237,   -168, &
                    48,     48,  -1464,    237,   -168,   1317,   -168,   -384,     -6,     -6,   -222,   1317,   -114,   -384, &
                   -60,   -222,    -60,   -168,     -6,  -1464,     48,   -114,     48,   -168,     -6,    237,   -195,     -6, &
                  -357,   2640,   1344,   -816,   -195,  -1950,   -168,   -384,   1533,  -1896,     -6,   -357,   -249,   -168, &
                  -195,   -195,  -1896,   1344,   -195,   1533,     -6,  -1950]
  K1( 707,:) = [    210,    -33,    210,  -1302,    156,    399,     -6,     -6,   -168,   -141,   -168,   -141,   -384,     48, &
                   318,   -141,   1344,   -195,   -195,     48,     21,   -195,   -357,     48,    264,     21,   -222,    210, &
                   -33,    210,     48,   -195,   -222,     48,   -114,   -195,     48,  -1464,    264,   -195,   1533,     -6, &
                  -141,   -141,   -168,     -6,   -168,     -6,    588,    102,    480,   -168,    480,    318,    156,    156, &
                   912,   -222,    534,    264,    588,     -6,    156,     48,    210,    264,    210,   -384,   -222,     48, &
                   210,   -222,    210,  -1302,    480,   -168,   1749,     21,   -222,    210,    534,   -114,   1560,   -168, &
                   102,     -6,    156,   -195,    -33,     21,     21,   -195,   -168,   -141,    156,    -33,     21,     21, &
                  1749,   1344,   3072,   -357,   -168,   1533,   1560,   1533,   1560,   -168,  -1302,     48,    210,  -1464, &
                 -1302,    210,     21,     48,   1533,   -141,    399,    210]
  K1( 708,:) = [    -60,    183,  -1950,    237,   -546,   -249,   -168,   -168,   -384,   -168,   -384,   -168,    318,   -168, &
                  -816,   1344,   -384,   -114,    264,   -168,   -384,    318,    102,   -357,    -60,    183,     -6,     -6, &
                   -60,     -6,   -222,     21,    480,   -222,    102,     21,    264,     21,  -1896,   1533,   -384,   -168, &
                   318,   -357,   -384,    264,    102,   -168,  -1464,    237,   -168,   1317,   -168,   -384,     -6,     -6, &
                  -222,   1317,   -114,   -384,    -60,   -222,    -60,   -168,     -6,  -1464,     48,   -114,     48,   -168, &
                    -6,    237,    -60,    183,    318,   -384,     21,    102,   -546,    183,    264,   -384,   -168,   -384, &
                 -1950,   1533,     -6,   1344,   -195,  -1896,     -6,   -114,    237,   -168,     48,     48,     -6,   -195, &
                  1344,   -816,   -357,   2640,  -1950,   -195,   1533,  -1896,   -168,   -384,  -1896,   1344,   -195,   1533, &
                    -6,  -1950,     -6,   -357,   -249,   -168,   -195,   -195]
  K1( 709,:) = [    372,  -1140,  -2004,     -6,  -3030,    183,   -222,    210,   -546,    156,  -1950,    102,    156,    210, &
                    -6,    210,     -6,     21,    210,     21,   -195,    399,    183,    -33,    264,    696,   -168,    372, &
                 -2652,    318,    210,  -1302,    -60,    -33,     -6,    156,    588,  -1302,  -1464,    264,    237,   -168, &
                   399,    -33,   -195,    210,    183,     21,   1506,     -6,   -222,     48,   -168,    237,    -60,    372, &
                   210,     48,     21,     -6,    372,    -33,    264,    156,    183,    318,   1506,   -222,    -60,    210, &
                   372,    264,    264,  -1140,    156,    -60,    156,     -6,   -816,    696,    588,    -60,    102,  -1950, &
                 -2004,    264,   -168,    210,   -492,   -600,    372,   -222,    264,    210,   1506,    -60,  -1518,     -6, &
                  1533,   -249,    210,   -195,  -3084,    372,     21,     -6,  -1302,  -1896, -12291,   1533,     -6,     21, &
                 -1518,  -3084,  -1140,    210,    696,  -1302,     -6,    372]
  K1( 710,:) = [    156,    156,    156,    210,    210,    -33,    534,   -195,    264,     -6,    318,    480,    912,  -1464, &
                  -222,     -6,     21,   1749,     48,   -195,   -357,     48,     21,   -195,    102,    102,    588,  -1302, &
                   399,    156,    480,     -6,    318,   -195,    264,    534,    480,     48,   -168,     48,   -168,   1560, &
                    -6,     -6,   -168,   -141,   -168,   -141,   -222,     21,     48,   -168,   -141,   -168,    210,    -33, &
                  -384,   -114,   -195,   -114,   -222,   -141,    210,   -195,     21,    -33,   -222,     48,    210,   -384, &
                  -222,    210,    156,    210,     48,   -168,   -195,   1344,    588,  -1302,     -6,   -222,     -6,   1533, &
                   264,   -141,    210,     48,    264,    210,    -33,   -141,    156,   -195,   -168,     21,    210,    210, &
                  -141,   -168,  -1464,   1533,    399,  -1302,     48,   -357,     48,   1344,   1533,   1560,     21,   3072, &
                  1533,     21,    210,   1560,  -1302,   1749,   -168,     21]
  K1( 711,:) = [    264,    696,   -168,    372,  -2652,    318,    210,  -1302,    -60,    -33,     -6,    156,    588,  -1302, &
                 -1464,    264,    237,   -168,    399,    -33,   -195,    210,    183,     21,    372,  -1140,  -2004,     -6, &
                 -3030,    183,   -222,    210,   -546,    156,  -1950,    102,    156,    210,     -6,    210,     -6,     21, &
                   210,     21,   -195,    399,    183,    -33,    -60,    372,    210,     48,     21,     -6,   1506,     -6, &
                  -222,     48,   -168,    237,    264,    156,    372,    -33,    318,    183,    -60,    210,   1506,   -222, &
                   264,    372,   -816,    696,    588,    -60,    102,  -1950,    264,  -1140,    156,    -60,    156,     -6, &
                  -168,    210,  -2004,    264,   -600,   -492,    264,    210,    372,   -222,    -60,   1506,  -3084,    372, &
                    21,     -6,  -1302,  -1896,  -1518,     -6,   1533,   -249,    210,   -195,     -6,     21, -12291,   1533, &
                 -3084,  -1518,    696,  -1302,  -1140,    210,    372,     -6]
  K1( 712,:) = [    102,    102,    588,  -1302,    399,    156,    480,     -6,    318,   -195,    264,    534,    480,     48, &
                  -168,     48,   -168,   1560,     -6,     -6,   -168,   -141,   -168,   -141,    156,    156,    156,    210, &
                   210,    -33,    534,   -195,    264,     -6,    318,    480,    912,  -1464,   -222,     -6,     21,   1749, &
                    48,   -195,   -357,     48,     21,   -195,    210,    -33,   -384,   -114,   -195,   -114,   -222,     21, &
                    48,   -168,   -141,   -168,    210,   -195,   -222,   -141,    -33,     21,    210,   -384,   -222,     48, &
                   210,   -222,    588,  -1302,     -6,   -222,     -6,   1533,    156,    210,     48,   -168,   -195,   1344, &
                   210,     48,    264,   -141,    210,    264,    156,   -195,    -33,   -141,     21,   -168,    399,  -1302, &
                    48,   -357,     48,   1344,    210,    210,   -141,   -168,  -1464,   1533,     21,   3072,   1533,   1560, &
                    21,   1533,  -1302,   1749,    210,   1560,     21,   -168]
  K1( 713,:) = [  -1140,    372,    264,  -1140,  -1518,    372,    156,    -33,     -6,  -1302,    -60,    210,    156,    210, &
                   -60,    588,    183,  -1302,    210,    156,     -6,     21,     -6,    210,    696,    264,   -816,    696, &
                 -3084,    264,    102,    156,  -1950,    210,   -546,   -222,    588,  -1302,    -60,    156,    183,    210, &
                   399,    102,   -249,   1533,    237,   -222,    372,    183,   -222,    237,    -33,     48,    264,    318, &
                   210,     -6,    156,     48,   1506,   -168,    -60,     21,     -6,    372,    372,   -222,    264,    210, &
                  1506,    -60,  -2004,     -6,    264,  -1464,     21,  -1896,   -168,    372,    210,     -6,    -33,   -195, &
                  -492,    264,   -600,    210,  -2004,   -168,    183,     21,    318,    -33,     -6,    372,  -3030,  -1140, &
                   210,   -195,    210,  -1950,  -2652,    696,    399,   -195,  -1302,     -6,  -1518,   1533,  -3084,     21, &
                -12291,     -6,     -6,   -168,    372,     21,   1506,    -60]
  K1( 714,:) = [    696,    264,   -816,    696,  -3084,    264,    102,    156,  -1950,    210,   -546,   -222,    588,  -1302, &
                   -60,    156,    183,    210,    399,    102,   -249,   1533,    237,   -222,  -1140,    372,    264,  -1140, &
                 -1518,    372,    156,    -33,     -6,  -1302,    -60,    210,    156,    210,    -60,    588,    183,  -1302, &
                   210,    156,     -6,     21,     -6,    210,    264,    318,    210,     -6,    156,     48,    372,    183, &
                  -222,    237,    -33,     48,    -60,     21,   1506,   -168,    372,     -6,    264,    210,    372,   -222, &
                   -60,   1506,   -168,    372,    210,     -6,    -33,   -195,  -2004,     -6,    264,  -1464,     21,  -1896, &
                  -600,    210,   -492,    264,   -168,  -2004,    318,    -33,    183,     21,    372,     -6,  -2652,    696, &
                   399,   -195,  -1302,     -6,  -3030,  -1140,    210,   -195,    210,  -1950,  -3084,     21,  -1518,   1533, &
                    -6, -12291,    372,     21,     -6,   -168,    -60,   1506]
  K1( 715,:) = [  -2004,     -6,    372,  -1140,    183,  -3030,    156,    210,     -6,    210,     -6,     21,   -222,    210, &
                  -546,    156,  -1950,    102,     21,    210,    183,    -33,   -195,    399,   -168,    372,    264,    696, &
                   318,  -2652,    588,  -1302,  -1464,    264,    237,   -168,    210,  -1302,    -60,    -33,     -6,    156, &
                   -33,    399,    183,     21,   -195,    210,    264,  -1140,    156,    -60,    156,     -6,   -816,    696, &
                   588,    -60,    102,  -1950,  -2004,    264,   -168,    210,   -492,   -600,    372,   -222,    264,    210, &
                  1506,    -60,   1506,     -6,   -222,     48,   -168,    237,    -60,    372,    210,     48,     21,     -6, &
                   372,    -33,    264,    156,    183,    318,   1506,   -222,    -60,    210,    372,    264,     -6,  -1518, &
                   210,   -195,   1533,   -249,    372,  -3084,  -1302,  -1896,     21,     -6,  -1140,    210,    696,  -1302, &
                    -6,    372, -12291,   1533,     -6,     21,  -1518,  -3084]
  K1( 716,:) = [    156,    210,    156,    156,    -33,    210,    912,  -1464,   -222,     -6,     21,   1749,    534,   -195, &
                   264,     -6,    318,    480,   -195,     48,     21,   -195,   -357,     48,    588,  -1302,    102,    102, &
                   156,    399,    480,     48,   -168,     48,   -168,   1560,    480,     -6,    318,   -195,    264,    534, &
                    -6,     -6,   -168,   -141,   -168,   -141,    156,    210,     48,   -168,   -195,   1344,    588,  -1302, &
                    -6,   -222,     -6,   1533,    264,   -141,    210,     48,    264,    210,    -33,   -141,    156,   -195, &
                  -168,     21,   -222,     21,     48,   -168,   -141,   -168,    210,    -33,   -384,   -114,   -195,   -114, &
                  -222,   -141,    210,   -195,     21,    -33,   -222,     48,    210,   -384,   -222,    210,    210,    210, &
                 -1464,   1533,   -141,   -168,  -1302,    399,     48,   1344,     48,   -357,    210,   1560,  -1302,   1749, &
                  -168,     21,   1533,   1560,     21,   3072,   1533,     21]
  K1( 717,:) = [   -168,    372,    264,    696,    318,  -2652,    588,  -1302,  -1464,    264,    237,   -168,    210,  -1302, &
                   -60,    -33,     -6,    156,    -33,    399,    183,     21,   -195,    210,  -2004,     -6,    372,  -1140, &
                   183,  -3030,    156,    210,     -6,    210,     -6,     21,   -222,    210,   -546,    156,  -1950,    102, &
                    21,    210,    183,    -33,   -195,    399,   -816,    696,    588,    -60,    102,  -1950,    264,  -1140, &
                   156,    -60,    156,     -6,   -168,    210,  -2004,    264,   -600,   -492,    264,    210,    372,   -222, &
                   -60,   1506,    -60,    372,    210,     48,     21,     -6,   1506,     -6,   -222,     48,   -168,    237, &
                   264,    156,    372,    -33,    318,    183,    -60,    210,   1506,   -222,    264,    372,    372,  -3084, &
                 -1302,  -1896,     21,     -6,     -6,  -1518,    210,   -195,   1533,   -249,    696,  -1302,  -1140,    210, &
                   372,     -6,     -6,     21, -12291,   1533,  -3084,  -1518]
  K1( 718,:) = [    588,  -1302,    102,    102,    156,    399,    480,     48,   -168,     48,   -168,   1560,    480,     -6, &
                   318,   -195,    264,    534,     -6,     -6,   -168,   -141,   -168,   -141,    156,    210,    156,    156, &
                   -33,    210,    912,  -1464,   -222,     -6,     21,   1749,    534,   -195,    264,     -6,    318,    480, &
                  -195,     48,     21,   -195,   -357,     48,    588,  -1302,     -6,   -222,     -6,   1533,    156,    210, &
                    48,   -168,   -195,   1344,    210,     48,    264,   -141,    210,    264,    156,   -195,    -33,   -141, &
                    21,   -168,    210,    -33,   -384,   -114,   -195,   -114,   -222,     21,     48,   -168,   -141,   -168, &
                   210,   -195,   -222,   -141,    -33,     21,    210,   -384,   -222,     48,    210,   -222,  -1302,    399, &
                    48,   1344,     48,   -357,    210,    210,  -1464,   1533,   -141,   -168,  -1302,   1749,    210,   1560, &
                    21,   -168,     21,   3072,   1533,   1560,     21,   1533]
  K1( 719,:) = [    264,  -1140,  -1140,    372,    372,  -1518,    156,    210,    -60,    588,    183,  -1302,    156,    -33, &
                    -6,  -1302,    -60,    210,    156,    210,     -6,    210,     -6,     21,   -816,    696,    696,    264, &
                   264,  -3084,    588,  -1302,    -60,    156,    183,    210,    102,    156,  -1950,    210,   -546,   -222, &
                   102,    399,    237,   -222,   -249,   1533,  -2004,     -6,    264,  -1464,     21,  -1896,   -168,    372, &
                   210,     -6,    -33,   -195,   -492,    264,   -600,    210,  -2004,   -168,    183,     21,    318,    -33, &
                    -6,    372,    372,    183,   -222,    237,    -33,     48,    264,    318,    210,     -6,    156,     48, &
                  1506,   -168,    -60,     21,     -6,    372,    372,   -222,    264,    210,   1506,    -60,  -1140,  -3030, &
                   210,  -1950,    210,   -195,    696,  -2652,  -1302,     -6,    399,   -195,     -6,   -168,    372,     21, &
                  1506,    -60,  -1518,   1533,  -3084,     21, -12291,     -6]
  K1( 720,:) = [   -816,    696,    696,    264,    264,  -3084,    588,  -1302,    -60,    156,    183,    210,    102,    156, &
                 -1950,    210,   -546,   -222,    102,    399,    237,   -222,   -249,   1533,    264,  -1140,  -1140,    372, &
                   372,  -1518,    156,    210,    -60,    588,    183,  -1302,    156,    -33,     -6,  -1302,    -60,    210, &
                   156,    210,     -6,    210,     -6,     21,   -168,    372,    210,     -6,    -33,   -195,  -2004,     -6, &
                   264,  -1464,     21,  -1896,   -600,    210,   -492,    264,   -168,  -2004,    318,    -33,    183,     21, &
                   372,     -6,    264,    318,    210,     -6,    156,     48,    372,    183,   -222,    237,    -33,     48, &
                   -60,     21,   1506,   -168,    372,     -6,    264,    210,    372,   -222,    -60,   1506,    696,  -2652, &
                 -1302,     -6,    399,   -195,  -1140,  -3030,    210,  -1950,    210,   -195,    372,     21,     -6,   -168, &
                   -60,   1506,  -3084,     21,  -1518,   1533,     -6, -12291]
  K1( 721,:) = [  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78, &
                  3432,   -456,   3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104,  -2724,    408,    408,   -456, &
                  -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30,   -456,    408,    -78,   -456, &
                   -78,   -348,     30,   -456,   -348,   -240,    300,   -456,    -78,    -78,     30,   -348,   3432,   -240, &
                  -456,    408,   -348,    624,   3324,    -78,   2568,   -456,    300,   3432,    -78,     30,   -348,   -348, &
                  -456,   -240,    300,    -78,   -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348, &
                  2568,   -348,  -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104,  -2724,    408, &
                   408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240, &
                  2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056]
  K1( 722,:) = [  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456, &
                  -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568,    408,  -2724,   -456,   -240, &
                   408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348,     30,   -456,   -348,   -240, &
                   -78,     30,   -456,    408,    -78,   -456,   -456,    300,     30,   -348,    -78,    -78,   -240,   3432, &
                  -348,    624,   -456,    408,    -78,     30,   -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456, &
                   300,   3432,  -2724,    408,    408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240, &
                  -456,   -348,   -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056,    300,    -78, &
                  -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240, &
                  -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104]
  K1( 723,:) = [  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408, &
                   300,    300,    -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568,    408,   -456,  -2724,    408, &
                  -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456,    300,  -2724,    -78,    408, &
                  -348,    -78,   -348,   -240,     30,   -456,    300,    -78,   -456,     30,    -78,   -348,   -456,   -348, &
                  2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,   -456,    -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624, &
                  3324,    -78,   2568,   -456,    300,   3432,    -78,     30,   -348,   -348,   -456,   -240,    408,  -2724, &
                  -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104]
  K1( 724,:) = [    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724, &
                   -78,   -456,    300,    300,    -78,    300,   3324,   2568,   3432,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300,    -78,    408,    300,  -2724, &
                    30,    -78,    -78,   -456,   -456,    408,  -2724,    408,    408,   -456,   -456,   -240,    408,    624, &
                  -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,    300,     30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408, &
                   -78,     30,   -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456,    300,   3432,    -78,    300, &
                   -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456,   -456,   2568, &
                  2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240]
  K1( 725,:) = [    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300, &
                  2568,  -1104,   -456,   2568,  -2724,    408,    300,    300,    -78,   -456,   -456,    408,   -240,   -456, &
                 -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78,   -348,   -240,     30,   -456, &
                   300,   -456,    300,  -2724,    -78,    408,    -78,    300,    -78,   -348,   -456,     30,   -348,   -456, &
                    30,   -348,   2568,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240, &
                  -456,   -240,    408,  -2724,   -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432, &
                  3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104,    300,   -456, &
                   -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78,   2568,   -456, &
                   300,   3432,    -78,     30,   -348,   -348,   -456,   -240]
  K1( 726,:) = [   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300, &
                  3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456,    300,    300,   -240,   -456,   -456,    408, &
                   408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78,    -78,   -456,   -456,    408, &
                  -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,    624,    408, &
                  -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240, &
                  2568,  -1104,    -78,    300,    -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456, &
                   300,   -456,   -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,    300, &
                    30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30,   -348,   -348, &
                  -456,   -240,   3324,    -78,   2568,   -456,    300,   3432]
  K1( 727,:) = [  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456, &
                   300,    -78,   2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568,    300,   -456,    -78,    -78, &
                    30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78,   2568,   -456,    300,   3432, &
                   -78,     30,   -348,   -348,   -456,   -240,  -2724,    408,    408,   -456,   -456,   -240,    300,   -456, &
                   300,  -2724,    -78,    408,    -78,     30,   -456,    408,    -78,   -456,    -78,   -348,     30,   -456, &
                  -348,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240, &
                  -456,   -348,   2568,   -456,     30,   -348,   -456,    300,   2568,  -1104,   -456,   2568,    408,   -456, &
                 -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624,   -456,   3432, &
                  -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104]
  K1( 728,:) = [    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324,   -456,    300,     30,   -348, &
                   -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30,   -348,   -348,   -456,   -240, &
                  3324,    -78,   2568,   -456,    300,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -456,    300, &
                   -78,    408,    300,  -2724,    -78,   -348,     30,   -456,   -348,   -240,    -78,     30,   -456,    408, &
                   -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104, &
                   408,    624,   -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,   -456,     30, &
                   300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456, &
                    30,   -348,   -456,    300,   2568,  -1104,   -456,   2568]
  K1( 729,:) = [    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300, &
                 -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348,  -1104,   -240,   -456,   -240, &
                   300,   -456,   -456,   2568,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,    -78,     30, &
                  -456,    408,    -78,   -456,    300,   -456,    300,  -2724,    -78,    408,   -348,    -78,   -348,   -240, &
                    30,   -456,    -78,    -78,    300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432, &
                  3432,   -240,   -456,    408,   -348,    624,     30,    -78,   -456,   -240,   -348,   -348,   -456,   -240, &
                   408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240, &
                  -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240]
  K1( 730,:) = [    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456, &
                   408,  -2724,    300,    300,   3324,   2568,    -78,    300,   -456,   3432,  -2724,    408,    408,   -456, &
                  -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348,   -240,   -240,   2568,  -1104, &
                  3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348, &
                    30,   -456,   -348,   -240,   -456,    300,    -78,    408,    300,  -2724,     30,    -78,    -78,   -456, &
                  -456,    408,     30,   -348,   -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240, &
                  -240,   3432,   -348,    624,   -456,    408,    -78,   3324,    300,   3432,   2568,   -456,    -78,   -348, &
                   -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348, &
                  2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240]
  K1( 731,:) = [    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104, &
                  -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,    -78,    300,    -78,   -348, &
                  -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456,   -456,   2568,   2568,  -1104, &
                  2568,   -348,  -1104,   -240,   -456,   -240,   -456,    408,   -240,   -456,  -2724,    408,     30,    -78, &
                   -78,   -456,   -456,    408,   -348,    -78,   -348,   -240,     30,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056, &
                   624,    408,   -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240,    -78,    -78, &
                   300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240,   -456,    408, &
                  -348,    624,     30,    -78,   -456,   -240,   -348,   -348]
  K1( 732,:) = [   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568, &
                   -78,    300,   -456,   3432,    -78,   -456,    408,  -2724,    300,    300,    408,  -2724,   -456,   -240, &
                   408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240,   -240,  -1104,  -1104,   1056, &
                  -456,   -348,   -240,   -240,   2568,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78, &
                  -348,   -240,     30,   -456,     30,    -78,    -78,   -456,   -456,    408,   -456,    300,    -78,    408, &
                   300,  -2724,    -78,   -348,    -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104, &
                  -348,   -456,     30,   -348,   2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -348, &
                  -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432,   -348,    624, &
                  -456,    408,    -78,   3324,    300,   3432,   2568,   -456]
  K1( 733,:) = [    300,    300,  -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724, &
                 -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568,    300,   -456,    -78,    -78,    300,   -456, &
                  -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240,   -456,    408,   -348,    624, &
                    30,    -78,   -456,   -240,   -348,   -348,   -456,     30,    300,    -78,   -348,    -78,   2568,   -348, &
                 -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456,     30,   -348,   -456,    300,   2568,  -1104, &
                  -456,   2568,  -2724,    408,    408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408, &
                   -78,     30,   -456,    408,    -78,   -456,    -78,   -348,     30,   -456,   -348,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,    408,    624,   -456,   3432,   -348,   -240]
  K1( 734,:) = [    -78,   -456,    408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846, &
                   300,   3432,  -2724,    300,   -456,   3432,   2568,   3324,    300,    -78,     30,   -348,   -456,    300, &
                   -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432,   -348,    624,   -456,    408, &
                   -78,   3324,    300,   3432,   2568,   -456,    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348, &
                  -240,   -240,   2568,  -1104,    408,    624,   -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,    408,  -2724,   -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724, &
                   -78,   -348,     30,   -456,   -348,   -240,    -78,     30,   -456,    408,    -78,   -456,     30,   -456, &
                  -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -456,   -348,   2568,   -456,     30,   -348]
  K1( 735,:) = [   3432,   -456,    300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300, &
                 21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78, &
                  -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348,   2568,   -456,     30,   -348, &
                  -456,    300,   2568,  -1104,   -456,   2568,    -78,    -78,    300,   -456,   -348,     30,   3324,    -78, &
                  2568,   -456,    300,   3432,   3432,   -240,   -456,    408,   -348,    624,     30,    -78,   -456,   -240, &
                  -348,   -348,    408,   -456,  -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456, &
                   300,   -456,    300,  -2724,    -78,    408,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104, &
                  -240,   -240,    624,    408,   -348,   -240,   -456,   3432]
  K1( 736,:) = [   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432, &
                 -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432,    -78,    300,    408,   -456,  -2724,    408, &
                  -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624,   -456,   3432,   -348,   -240, &
                  -240,   3432,  -1104,   1056,   -240,  -1104,     30,   -348,   -456,    300,    -78,    -78,    -78,     30, &
                  -348,   -348,   -456,   -240,   -240,   3432,   -348,    624,   -456,    408,    -78,   3324,    300,   3432, &
                  2568,   -456,   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240, &
                  -456,    300,    -78,    408,    300,  -2724,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78, &
                    30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240, &
                 -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456]
  K1( 737,:) = [   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724, &
                  3432,    300,  21846,  -2724,    300,    300,   -456,    -78,  -2724,    408,    -78,   -348,    -78,    300, &
                    30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348,   2568,   -456, &
                  -348,   2568,   -456,   -240,  -1104,   -240,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104, &
                  -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408, &
                  -348,    -78,   -348,   -240,     30,   -456,    300,   -456,    300,  -2724,    -78,    408,    -78,    -78, &
                  -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78,   -456,   -240, &
                  -348,   -348,   3432,   -240,   -456,    408,   -348,    624]
  K1( 738,:) = [   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300, &
                   300,  -2724,  -2724,  21846,   -456,    -78,    300,    300,    408,  -2724,   -456,   -240,    408,  -2724, &
                  -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408,   -348,   -240,   -456,   3432, &
                  -348,   -456,   2568,  -1104,   -240,   -240,    -78,   -348,    -78,    300,     30,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,   -348,   -456,     30,   -348,   2568,   -456,   -348,   2568,   -456,   -240, &
                 -1104,   -240,   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456, &
                    30,    -78,    -78,   -456,   -456,    408,   -456,    300,    -78,    408,    300,  -2724,   -348,     30, &
                   -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324,    300,   3432, &
                  2568,   -456,   -240,   3432,   -348,    624,   -456,    408]
  K1( 739,:) = [    300,    300,   -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456, &
                 -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,    -78,    -78,   -348,     30, &
                   300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78,   -456,   -240,   -348,   -348, &
                  3432,   -240,   -456,    408,   -348,    624,     30,   -456,   -348,    -78,    300,    -78,   -348,   2568, &
                  -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456, &
                    30,   -348,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240, &
                  -240,   3432,  -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408, &
                   408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30,   -456,    408, &
                   -78,   -456,    -78,   -348,     30,   -456,   -348,   -240]
  K1( 740,:) = [   -456,    -78,    300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432, &
                  2568,   3324,    300,    -78,  -2724,  21846,    300,   3432,  -2724,    300,   -348,     30,    -78,    -78, &
                  -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324,    300,   3432,   2568,   -456, &
                  -240,   3432,   -348,    624,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456, &
                  2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432, &
                  -348,   -240,     30,   -456,   -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240, &
                  -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,    408,  -2724, &
                  -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348,     30,   -456, &
                  -348,   -240,    -78,     30,   -456,    408,    -78,   -456]
  K1( 741,:) = [   -456,   3432,   2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568, &
                  2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724,   3432,    300,     30,   -456,   -348,    -78, &
                   300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300,   2568,  -1104,   -456,   2568, &
                  -456,   -348,   2568,   -456,     30,   -348,    -78,    -78,   -348,     30,    300,   -456,    -78,   3324, &
                   300,   3432,   2568,   -456,     30,    -78,   -456,   -240,   -348,   -348,   3432,   -240,   -456,    408, &
                  -348,    624,   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104, &
                  -348,   -456,   2568,  -1104,   -240,   -240,    624,    408,   -348,   -240,   -456,   3432,    408,   -456, &
                 -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,   -348,    -78,   -348,   -240,     30,   -456]
  K1( 742,:) = [   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324, &
                  -456,   3432,    -78,    300,    300,   3432,  -2724,  21846,    300,  -2724,   -456,    408,   -240,   -456, &
                 -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104, &
                   408,    624,   -456,   3432,   -348,   -240,   -348,     30,    -78,    -78,   -456,    300,     30,    -78, &
                  -456,   -240,   -348,   -348,    -78,   3324,    300,   3432,   2568,   -456,   -240,   3432,   -348,    624, &
                  -456,    408,   -348,    -78,     30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568, &
                  -348,   2568,   -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456,   -456,   -240, &
                   408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300,    -78,    408, &
                   300,  -2724,     30,    -78,    -78,   -456,   -456,    408]
  K1( 743,:) = [   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300, &
                  -456,    -78,  -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724,   -348,    -78,     30,   -456, &
                   -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240,  -1104,   -240, &
                  -348,   -456,     30,   -348,   2568,   -456,   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104,   -240,   -240,    624,    408,   -348,   -240, &
                  -456,   3432,    -78,    -78,   -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456, &
                    30,    -78,   -456,   -240,   -348,   -348,   3432,   -240,   -456,    408,   -348,    624,   -456,    408, &
                  -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78,   -348,   -240, &
                    30,   -456,    300,   -456,    300,  -2724,    -78,    408]
  K1( 744,:) = [  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78, &
                   300,    300,    408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456,   2568,  -1104,   -240,   -240, &
                   624,    408,   -348,   -240,   -456,   3432,   -348,    -78,     30,   -456,    -78,    300,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -348,   2568,   -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348, &
                  2568,   -456,   -348,     30,    -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348, &
                   -78,   3324,    300,   3432,   2568,   -456,   -240,   3432,   -348,    624,   -456,    408,   -240,   -456, &
                  -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78,    -78,   -456, &
                  -456,    408,   -456,    300,    -78,    408,    300,  -2724]
  K1( 745,:) = [  -2724,    408,    408,   -456,   -456,   -240,    300,   -456,    300,  -2724,    -78,    408,    -78,     30, &
                  -456,    408,    -78,   -456,    -78,   -348,     30,   -456,   -348,   -240,  21846,  -2724,  -2724,    300, &
                   300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78,   3432,   -456,   3324,   2568, &
                   300,   -456,   -456,   2568,   2568,  -1104,   3432,   -240,   -456,    408,   -348,    624,    300,   -456, &
                   -78,    -78,     30,   -348,   2568,   -456,   3324,    -78,   3432,    300,   -348,   -348,    -78,     30, &
                  -240,   -456,   -456,   -348,   2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348, &
                 -1104,   -240,   2568,   -348,   -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568,    408,    624, &
                  -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104]
  K1( 746,:) = [    408,  -2724,   -456,   -240,    408,   -456,   -456,    300,    -78,    408,    300,  -2724,    -78,   -348, &
                    30,   -456,   -348,   -240,    -78,     30,   -456,    408,    -78,   -456,  -2724,  21846,    300,   3432, &
                 -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456,   -456,   2568,   2568,  -1104, &
                   300,    -78,   3432,   -456,   3324,   2568,   -240,   3432,   -348,    624,   -456,    408,   -456,    300, &
                    30,   -348,    -78,    -78,   -348,   -348,    -78,     30,   -240,   -456,   2568,   -456,   3324,    -78, &
                  3432,    300,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240, &
                  -240,   -240,   -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104,   -456,   -348, &
                  2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348, &
                  -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568]
  K1( 747,:) = [    408,   -456,  -2724,    408,   -240,   -456,    -78,     30,   -456,    408,    -78,   -456,    300,   -456, &
                   300,  -2724,    -78,    408,   -348,    -78,   -348,   -240,     30,   -456,  -2724,    300,  21846,  -2724, &
                  3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408,    300,    300,    -78,   -456, &
                  -456,    300,   2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,    300,    -78, &
                  -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456,   -456,   2568,    300,   -456, &
                 -1104,   2568,   3432,   -240,   -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348, &
                  2568,   -456,   3324,    -78,   3432,    300,   -348,   -348,    -78,     30,   -240,   -456,    624,    408, &
                  -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568]
  K1( 748,:) = [   -456,   -240,    408,  -2724,   -456,    408,    -78,   -348,     30,   -456,   -348,   -240,   -456,    300, &
                   -78,    408,    300,  -2724,     30,    -78,    -78,   -456,   -456,    408,    300,   3432,  -2724,  21846, &
                   300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456,    300,    300, &
                   -78,    300,   3324,   2568,   3432,   -456,    408,    624,   -456,   3432,   -348,   -240,  -2724,    408, &
                   408,   -456,   -456,   -240,   -240,   -240,   -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -240,   3432,   -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78, &
                  -348,   -348,    -78,     30,   -240,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -348,   -456, &
                    30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568,    300,   -456, &
                 -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456]
  K1( 749,:) = [   -456,    408,   -240,   -456,  -2724,    408,     30,    -78,    -78,   -456,   -456,    408,   -348,    -78, &
                  -348,   -240,     30,   -456,    300,   -456,    300,  -2724,    -78,    408,    300,  -2724,   3432,    300, &
                 21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104,   -456,   2568, &
                 -2724,    408,    300,    300,    -78,   -456,   -348,   -456,     30,   -348,   2568,   -456,    -78,    300, &
                   -78,   -348,   -456,     30,   -456,   2568,    300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348, &
                  -240,   -456,    624,    408,   -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456, &
                  -240,  -1104,   3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568,   3432,   -240, &
                  -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456,   3324,    -78, &
                  3432,    300,   -348,   -348,    -78,     30,   -240,   -456]
  K1( 750,:) = [   -240,   -456,   -456,    408,    408,  -2724,   -348,    -78,   -348,   -240,     30,   -456,     30,    -78, &
                   -78,   -456,   -456,    408,   -456,    300,    -78,    408,    300,  -2724,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568,   3432,   -456, &
                   408,  -2724,    -78,   -456,    300,    300,    624,    408,   -348,   -240,   -456,   3432,    408,  -2724, &
                  -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -348,   -456,     30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30, &
                  -456,   2568,    300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,   -240,   3432, &
                  -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348,    -78,     30, &
                  -240,   -456,   2568,   -456,   3324,    -78,   3432,    300]
  K1( 751,:) = [    300,   -456,    -78,    -78,     30,   -348,   3432,   -240,   -456,    408,   -348,    624,   3324,    -78, &
                  2568,   -456,    300,   3432,    -78,     30,   -348,   -348,   -456,   -240,  -2724,    408,    300,    300, &
                   -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456,    300,    -78,   2568,   3324, &
                  -456,   2568,    300,   -456,  -1104,   2568,    300,   -456,    300,  -2724,    -78,    408,  -2724,    408, &
                   408,   -456,   -456,   -240,   -456,    408,    -78,     30,   -456,    -78,     30,   -456,    -78,   -348, &
                  -240,   -348,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78, &
                  2568,   -456,   -456,   -348,   -348,     30,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -348, &
                  -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432,    408,    624, &
                  -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240]
  K1( 752,:) = [   -456,    300,     30,   -348,    -78,    -78,   -240,   3432,   -348,    624,   -456,    408,    -78,     30, &
                  -348,   -348,   -456,   -240,   3324,    -78,   2568,   -456,    300,   3432,    408,  -2724,    -78,   -456, &
                   300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568,    300,   -456,  -1104,   2568, &
                  3432,   -456,    300,    -78,   2568,   3324,   -456,    300,    -78,    408,    300,  -2724,    408,  -2724, &
                  -456,   -240,    408,   -456,     30,   -456,    -78,   -348,   -240,   -348,   -456,    408,    -78,     30, &
                  -456,    -78,   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456, &
                  -456,   3432,    408,    624,   -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,   -348, &
                 -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456,   -456,   -348, &
                  -348,     30,   2568,  -1104,   -456,    300,   2568,   -456]
  K1( 753,:) = [    300,    -78,   -456,     30,    -78,   -348,   -456,   -348,   2568,   -456,     30,   -348,   2568,   -348, &
                 -1104,   -240,   -456,   -240,    300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456, &
                  3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300,  -2724,    408,   -456,    -78, &
                  2568,  -1104,   -456,    300,   2568,   -456,    -78,     30,   -456,    408,    -78,   -456,    408,   -456, &
                 -2724,    408,   -240,   -456,    300,  -2724,    300,   -456,    408,    -78,   -348,   -240,   -348,    -78, &
                  -456,     30,   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30, &
                  -456,    408,   3432,   -240,    624,   -348,   -456,   -240,     30,    -78,   -348,   -348,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240,    624,    408, &
                  3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240]
  K1( 754,:) = [  -2724,    408,    408,   -456,   -456,   -240,    408,    624,   -456,   3432,   -348,   -240,   -456,   -348, &
                  -240,   -240,   2568,  -1104,   3432,   -240,   -240,  -1104,  -1104,   1056,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724,    300,    300, &
                  3324,   2568,    -78,    300,   -456,   3432,    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240, &
                   408,  -2724,   -456,    408,    -78,    408,   -456,    300,  -2724,    300,    -78,   -456,     30,    -78, &
                   408,   -456,    -78,     30,   -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78, &
                  -348,    624,   -240,   3432,    408,   -456,    300,   3432,    -78,   3324,   -456,   2568,    300,   -456, &
                  -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348,   -348,   -456, &
                  -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104]
  K1( 755,:) = [    -78,    300,    -78,   -348,   -456,     30,   -348,   -456,     30,   -348,   2568,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,   2568,   -348,  -1104,   -240,   -456,   -240,    -78,    300,   3324,   2568, &
                  3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300,   2568,   -456, &
                   300,    300,  -2724,    408,   -456,    -78,     30,    -78,    -78,   -456,   -456,    408,   -456,    408, &
                  -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78,   -456,     30,    300,  -2724,    300,   -456, &
                   408,    -78,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408, &
                  -348,   -240,    624,    408,   3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240,   3324,    -78, &
                  2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408,   3432,   -240, &
                   624,   -348,   -456,   -240,     30,    -78,   -348,   -348]
  K1( 756,:) = [    408,  -2724,   -456,   -240,    408,   -456,    624,    408,   -348,   -240,   -456,   3432,   3432,   -240, &
                  -240,  -1104,  -1104,   1056,   -456,   -348,   -240,   -240,   2568,  -1104,   -456,    300,   2568,  -1104, &
                  -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300,   -456,   3432, &
                   -78,   -456,    408,  -2724,    300,    300,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,    -78,   -456,     30,    -78,    408,   -456,    -78,    408,   -456,    300, &
                 -2724,    300,    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456, &
                    30,   -348,   -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104,    -78,     30, &
                  -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624,   -240,   3432, &
                   408,   -456,    300,   3432,    -78,   3324,   -456,   2568]
  K1( 757,:) = [    -78,    -78,    300,   -456,   -348,     30,   3324,    -78,   2568,   -456,    300,   3432,   3432,   -240, &
                  -456,    408,   -348,    624,     30,    -78,   -456,   -240,   -348,   -348,    300,    300,  -2724,    408, &
                  -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300,    300,   3432, &
                  2568,   -456,  -1104,   2568,    300,   -456,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30, &
                   300,    -78,   -348,    -78,   2568,   -456,   -456,   -348,   -348,     30,   2568,  -1104,   -456,    300, &
                  2568,   -456,    300,   -456,    300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240, &
                  -456,    408,    -78,     30,   -456,    -78,     30,   -456,    -78,   -348,   -240,   -348,   -348,   -456, &
                  2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   -456,   3432,    408,    624,   -240,   -348]
  K1( 758,:) = [     30,   -348,   -456,    300,    -78,    -78,    -78,     30,   -348,   -348,   -456,   -240,   -240,   3432, &
                  -348,    624,   -456,    408,    -78,   3324,    300,   3432,   2568,   -456,    -78,   -456,    408,  -2724, &
                   300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432,  -2724,    300, &
                  -456,   3432,   2568,   3324,    300,    -78,   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456, &
                 -2724,    408,   -240,   -456,   -456,   3432,    408,    624,   -240,   -348,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456, &
                    30,   -456,    -78,   -348,   -240,   -348,   -456,    408,    -78,     30,   -456,    -78,   -348,   2568, &
                  -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104,   -456,    300, &
                  2568,   -456,   2568,   -456,   -456,   -348,   -348,     30]
  K1( 759,:) = [   -456,     30,    300,    -78,   -348,    -78,   2568,   -348,  -1104,   -240,   -456,   -240,   -456,   -348, &
                  2568,   -456,     30,   -348,   -456,    300,   2568,  -1104,   -456,   2568,   3432,   -456,    300,    -78, &
                  2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724,   3432,    300, &
                 -1104,   2568,   2568,   -456,   -456,    300,   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78, &
                   300,   -456,   -348,     30,   -456,    408,   3432,   -240,    624,   -348,   -456,   -240,     30,    -78, &
                  -348,   -348,    -78,     30,   -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456, &
                   300,  -2724,    300,   -456,    408,    -78,   -348,   -240,   -348,    -78,   -456,     30,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456, &
                  -240,   -240,   -348,   -240,    624,    408,   3432,   -456]
  K1( 760,:) = [    408,   -456,  -2724,    408,   -240,   -456,   -456,   -348,   -240,   -240,   2568,  -1104,    408,    624, &
                  -456,   3432,   -348,   -240,   -240,   3432,  -1104,   1056,   -240,  -1104,   -456,   2568,    300,   -456, &
                 -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432,  -2724,  21846,    300,  -2724, &
                  2568,   3324,   -456,   3432,    -78,    300,    -78,     30,   -348,   -348,   -456,   -240,     30,   -348, &
                  -456,    300,    -78,    -78,   -348,    624,   -240,   3432,    408,   -456,    300,   3432,    -78,   3324, &
                  -456,   2568,    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408, &
                   -78,    408,   -456,    300,  -2724,    300,    -78,   -456,     30,    -78,    408,   -456,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240,   -348,   2568, &
                  -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568]
  K1( 761,:) = [    -78,   -348,    -78,    300,     30,   -456,    300,   -456,   -456,   2568,   2568,  -1104,   -348,   -456, &
                    30,   -348,   2568,   -456,   -348,   2568,   -456,   -240,  -1104,   -240,   3324,   2568,    -78,    300, &
                  -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724,   3432,    300,  21846,  -2724, &
                   300,    300,   -456,    -78,  -2724,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240, &
                   408,  -2724,   -456,    408,   -348,   -240,    624,    408,   3432,   -456,   2568,  -1104,   -348,   -456, &
                  -240,   -240,     30,    -78,    -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408, &
                  -348,   -240,   -348,    -78,   -456,     30,    300,  -2724,    300,   -456,    408,    -78,    -78,   3324, &
                   300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240,     30,    -78, &
                  -348,   -348,   -456,    408,   3432,   -240,    624,   -348]
  K1( 762,:) = [   -456,   -240,    408,  -2724,   -456,    408,   3432,   -240,   -240,  -1104,  -1104,   1056,    624,    408, &
                  -348,   -240,   -456,   3432,   -348,   -456,   2568,  -1104,   -240,   -240,   2568,  -1104,   -456,    300, &
                  2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300,    300,  -2724,  -2724,  21846, &
                  -456,    -78,    300,    300,    408,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348, &
                   -78,    300,     30,   -456,     30,   -348,   -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568, &
                  -240,  -1104,   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724, &
                   -78,   -456,     30,    -78,    408,   -456,    -78,    408,   -456,    300,  -2724,    300,     30,    -78, &
                  -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432,    -78,   3324, &
                  -456,   2568,   -348,    624,   -240,   3432,    408,   -456]
  K1( 763,:) = [    -78,    -78,   -348,     30,    300,   -456,    -78,   3324,    300,   3432,   2568,   -456,     30,    -78, &
                  -456,   -240,   -348,   -348,   3432,   -240,   -456,    408,   -348,    624,    300,    300,   -456,    -78, &
                 -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568,    300,   -456, &
                 21846,  -2724,  -2724,    300,    300,   3432,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456, &
                  -348,    -78,    300,    -78,   2568,  -1104,   -456,    300,   2568,   -456,   2568,   -456,   -456,   -348, &
                  -348,     30,   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408, &
                 -1104,   1056,   -240,   3432,  -1104,   -240,   -456,   3432,    408,    624,   -240,   -348,    300,   -456, &
                   300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408,    -78,     30, &
                  -456,    -78,     30,   -456,    -78,   -348,   -240,   -348]
  K1( 764,:) = [   -348,     30,    -78,    -78,   -456,    300,     30,    -78,   -456,   -240,   -348,   -348,    -78,   3324, &
                   300,   3432,   2568,   -456,   -240,   3432,   -348,    624,   -456,    408,   -456,    -78,    300,    300, &
                   408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324,    300,    -78, &
                 -2724,  21846,    300,   3432,  -2724,    300,   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,   3432,    408,    624, &
                  -240,   -348,   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78, &
                  2568,  -1104,   -456,    300,   2568,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,    300, &
                   -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456,    -78,   -348, &
                  -240,   -348,   -456,    408,    -78,     30,   -456,    -78]
  K1( 765,:) = [     30,   -456,   -348,    -78,    300,    -78,   -348,   2568,   -456,   -240,  -1104,   -240,   -456,    300, &
                  2568,  -1104,   -456,   2568,   -456,   -348,   2568,   -456,     30,   -348,   -456,   3432,   2568,   3324, &
                   300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456,   -456,    300, &
                 -2724,    300,  21846,  -2724,   3432,    300,    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78, &
                  -348,     30,    300,   -456,   -456,   -240,     30,    -78,   -348,   -348,   -456,    408,   3432,   -240, &
                   624,   -348,   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724, &
                  2568,  -1104,   -348,   -456,   -240,   -240,   -348,   -240,    624,    408,   3432,   -456,    -78,     30, &
                  -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724,    300,   -456, &
                   408,    -78,   -348,   -240,   -348,    -78,   -456,     30]
  K1( 766,:) = [   -456,    408,   -240,   -456,  -2724,    408,   -348,   -456,   2568,  -1104,   -240,   -240,   -240,   3432, &
                 -1104,   1056,   -240,  -1104,    408,    624,   -456,   3432,   -348,   -240,   2568,   -456,  -1104,   2568, &
                   300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324,   -456,   3432,    -78,    300, &
                   300,   3432,  -2724,  21846,    300,  -2724,     30,    -78,   -456,   -240,   -348,   -348,   -348,     30, &
                   -78,    -78,   -456,    300,    300,   3432,    -78,   3324,   -456,   2568,   -348,    624,   -240,   3432, &
                   408,   -456,   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300, &
                  -456,   -240,   -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348, &
                    30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408,   -456,    300, &
                 -2724,    300,    -78,   -456,     30,    -78,    408,   -456]
  K1( 767,:) = [   -348,    -78,     30,   -456,    -78,    300,   -456,    300,   2568,  -1104,   -456,   2568,   -348,   2568, &
                  -456,   -240,  -1104,   -240,   -348,   -456,     30,   -348,   2568,   -456,   2568,   3324,   -456,   3432, &
                   -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300,   -456,    -78,  -2724,    408, &
                   300,  -2724,   3432,    300,  21846,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456, &
                  -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456,   -240,   -240,   -348,   -240,    624,    408, &
                  3432,   -456,    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456, &
                  -456,   -240,     30,    -78,   -348,   -348,   -456,    408,   3432,   -240,    624,   -348,     30,    -78, &
                   -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78, &
                  -456,     30,    300,  -2724,    300,   -456,    408,    -78]
  K1( 768,:) = [   -240,   -456,   -456,    408,    408,  -2724,   -240,   3432,  -1104,   1056,   -240,  -1104,   -348,   -456, &
                  2568,  -1104,   -240,   -240,    624,    408,   -348,   -240,   -456,   3432,  -1104,   2568,   2568,   -456, &
                  -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78,    300,    300,    408,  -2724, &
                  3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78, &
                    30,   -456,    -78,    300,   -456,   -240,   -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456, &
                  -456,   2568,     30,    -78,   -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300, &
                   300,   3432,    -78,   3324,   -456,   2568,   -348,    624,   -240,   3432,    408,   -456,   -348,    -78, &
                  -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456,     30,    -78, &
                   408,   -456,    -78,    408,   -456,    300,  -2724,    300]
  K1( 769,:) = [    300,   -456,    300,  -2724,    -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408, &
                   -78,     30,   -456,    -78,     30,   -456,    -78,   -348,   -240,   -348,   3432,   -240,   -456,    408, &
                  -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456,   3324,    -78,   3432,    300, &
                  -348,   -348,    -78,     30,   -240,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408, &
                   300,    300,    -78,   -456,    300,    -78,   3432,   -456,   3324,   2568,    300,   -456,   -456,   2568, &
                  2568,  -1104,   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456, &
                   300,    -78,   -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432, &
                   408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456, &
                  -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240]
  K1( 770,:) = [   -456,    300,    -78,    408,    300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456, &
                   -78,   -348,   -240,   -348,   -456,    408,    -78,     30,   -456,    -78,   -240,   3432,   -348,    624, &
                  -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348,    -78,     30,   -240,   -456, &
                  2568,   -456,   3324,    -78,   3432,    300,  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724, &
                   -78,   -456,    300,    300,    300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456, &
                  3324,   2568,   -456,   3432,    408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568, &
                 -2724,    408,    408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240,   2568,   -456, &
                  -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456]
  K1( 771,:) = [    -78,     30,   -456,    408,    -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724, &
                   300,   -456,    408,    -78,   -348,   -240,   -348,    -78,   -456,     30,   -456,   -348,   2568,   -456, &
                    30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456, &
                  -456,   2568,    300,   -456,  -1104,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78, &
                  3432,   -456,   3324,   2568,  -2724,    408,    300,    300,    -78,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -456,    408,   3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300, &
                   300,   -456,    -78,    -78,     30,   -348,   -348,   -348,   -240,   -456,    -78,     30,   -348,   -240, &
                   624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240, &
                   408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348]
  K1( 772,:) = [    -78,   -348,     30,   -456,   -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408, &
                  -456,    300,  -2724,    300,    -78,   -456,     30,    -78,    408,   -456,    408,    624,   -456,   3432, &
                  -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240,   -456,   -348,  -1104,   2568, &
                  -240,  -1104,   3432,   -240,   1056,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456, &
                  -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456,    300,    300,    -78,    300,   3324,   2568, &
                  3432,   -456,   -348,    624,   -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456, &
                  -456,    300,     30,   -348,    -78,    -78,   -456,   2568,   3432,    300,   3324,    -78,     30,   -348, &
                  -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300,    -78,   -348, &
                  -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348]
  K1( 773,:) = [     30,    -78,    -78,   -456,   -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240, &
                  -348,    -78,   -456,     30,    300,  -2724,    300,   -456,    408,    -78,   -348,   -456,     30,   -348, &
                  2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568,    300,   -456,  -1104,   2568, &
                 -1104,   -240,   2568,   -348,   -240,   -456,    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300, &
                  3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104,   -456,   2568,  -2724,    408,    300,    300, &
                   -78,   -456,   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104, &
                   408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   -456,    408, &
                  3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456,    -78,    -78, &
                    30,   -348,   -348,   -348,   -240,   -456,    -78,     30]
  K1( 774,:) = [   -348,    -78,   -348,   -240,     30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456, &
                    30,    -78,    408,   -456,    -78,    408,   -456,    300,  -2724,    300,    624,    408,   -348,   -240, &
                  -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104, &
                  -240,   -240,   -456,   -348,  -1104,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300, &
                  2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456, &
                   300,    300,     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568, &
                   -78,    300,    -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348,   -348,    624, &
                  -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300,     30,   -348, &
                   -78,    -78,   -456,   2568,   3432,    300,   3324,    -78]
  K1( 775,:) = [   3432,   -240,   -456,    408,   -348,    624,    300,   -456,    -78,    -78,     30,   -348,   2568,   -456, &
                  3324,    -78,   3432,    300,   -348,   -348,    -78,     30,   -240,   -456,    300,   -456,    300,  -2724, &
                   -78,    408,  -2724,    408,    408,   -456,   -456,   -240,   -456,    408,    -78,     30,   -456,    -78, &
                    30,   -456,    -78,   -348,   -240,   -348,  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724, &
                 -2724,    300,    300,   3432,   3432,   -456,    300,    -78,   2568,   3324,   -456,   2568,    300,   -456, &
                 -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30, &
                  -456,     30,    300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -240, &
                  -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456,  -2724,    408, &
                  -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432]
  K1( 776,:) = [   -240,   3432,   -348,    624,   -456,    408,   -456,    300,     30,   -348,    -78,    -78,   -348,   -348, &
                   -78,     30,   -240,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -456,    300,    -78,    408, &
                   300,  -2724,    408,  -2724,   -456,   -240,    408,   -456,     30,   -456,    -78,   -348,   -240,   -348, &
                  -456,    408,    -78,     30,   -456,    -78,    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846, &
                   300,   3432,  -2724,    300,   -456,   2568,    300,   -456,  -1104,   2568,   3432,   -456,    300,    -78, &
                  2568,   3324,   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348, &
                   408,   -456,  -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   -240, &
                  2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30,    300,    -78, &
                  -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300]
  K1( 777,:) = [   -456,   -348,   2568,   -456,     30,   -348,    300,    -78,   -456,     30,    -78,   -348,  -1104,   -240, &
                  2568,   -348,   -240,   -456,   -456,   2568,    300,   -456,  -1104,   2568,    -78,     30,   -456,    408, &
                   -78,   -456,    408,   -456,  -2724,    408,   -240,   -456,    300,  -2724,    300,   -456,    408,    -78, &
                  -348,   -240,   -348,    -78,   -456,     30,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300, &
                 21846,  -2724,   3432,    300,    300,    300,  -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300, &
                  2568,   -456,   2568,   -456,   3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348, &
                   -78,    -78,    300,   -456,   -348,     30,   -240,   -456,   -348,   -348,     30,    -78,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456]
  K1( 778,:) = [    408,    624,   -456,   3432,   -348,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -240,   -240, &
                  -456,   -348,  -1104,   2568,   -240,  -1104,   3432,   -240,   1056,  -1104,    -78,   -348,     30,   -456, &
                  -348,   -240,   -456,   -240,    408,  -2724,   -456,    408,    -78,    408,   -456,    300,  -2724,    300, &
                   -78,   -456,     30,    -78,    408,   -456,    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432, &
                 -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724,    300,    300,   3324,   2568,    -78,    300, &
                  -456,   3432,   -348,   -348,    -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456, &
                    30,   -348,   -456,    300,    -78,    -78,   3432,    300,   -456,   2568,    -78,   3324,   -456,   2568, &
                   300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348,    -78,    300, &
                    30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568]
  K1( 779,:) = [   -348,   -456,     30,   -348,   2568,   -456,    -78,    300,    -78,   -348,   -456,     30,   -456,   2568, &
                   300,   -456,  -1104,   2568,  -1104,   -240,   2568,   -348,   -240,   -456,     30,    -78,    -78,   -456, &
                  -456,    408,   -456,    408,   -240,   -456,  -2724,    408,   -348,   -240,   -348,    -78,   -456,     30, &
                   300,  -2724,    300,   -456,    408,    -78,    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724, &
                  3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408, &
                  -456,    -78,   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456, &
                  -456,   -240,    408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   2568,   -456, &
                  3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78,    300,   -456, &
                  -348,     30,   -240,   -456,   -348,   -348,     30,    -78]
  K1( 780,:) = [    624,    408,   -348,   -240,   -456,   3432,    408,  -2724,   -456,   -240,    408,   -456,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,   -240,   -240,   -456,   -348,  -1104,   2568,   -348,    -78,   -348,   -240, &
                    30,   -456,   -240,   -456,   -456,    408,    408,  -2724,    -78,   -456,     30,    -78,    408,   -456, &
                   -78,    408,   -456,    300,  -2724,    300,   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300, &
                   300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300,   -456,   3432,    -78,   -456,    408,  -2724, &
                   300,    300,   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568, &
                   -78,   -348,    -78,    300,     30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,   -348, &
                   -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348,   -456,    300, &
                   -78,    -78,   3432,    300,   -456,   2568,    -78,   3324]
  K1( 781,:) = [   3324,    -78,   2568,   -456,    300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408, &
                  3432,   -240,    624,   -348,   -456,   -240,     30,    -78,   -348,   -348,   2568,   -348,  -1104,   -240, &
                  -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456,   -456,   -348,   -348,     30, &
                  2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,   3432,   -456, &
                   300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568, &
                   300,   -456,    300,  -2724,    300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78, &
                 -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348,    -78,   -348,   2568,  -1104, &
                  -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456, &
                 -2724,    408,   3432,   -456,   -240,   -348,    408,    624]
  K1( 782,:) = [    -78,     30,   -348,   -348,   -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624, &
                  -240,   3432,    408,   -456,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -348,   -240,   -240, &
                  2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432,    408,    624,   -240,   -348, &
                 -1104,   1056,   -240,   3432,  -1104,   -240,    -78,   -456,    408,  -2724,    300,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   3432,   2568,   3324, &
                   300,    -78,    -78,    408,   -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348, &
                   408,  -2724,   -456,   -240,    408,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,   -240, &
                  -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456,   -348,    -78, &
                   300,    -78,   -456,   2568,   -348,     30,   -456,   -348]
  K1( 783,:) = [   2568,   -348,  -1104,   -240,   -456,   -240,   -456,     30,    300,    -78,   -348,    -78,   2568,   -456, &
                  -456,   -348,   -348,     30,   2568,  -1104,   -456,    300,   2568,   -456,   3324,    -78,   2568,   -456, &
                   300,   3432,    -78,    -78,    300,   -456,   -348,     30,   -456,    408,   3432,   -240,    624,   -348, &
                  -456,   -240,     30,    -78,   -348,   -348,   3432,   -456,    300,    -78,   2568,   3324,    300,    300, &
                 -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -456,    408,    -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78, &
                   408,   -456,  -2724,    408,   -240,   -456,   -240,   -348,   -456,     30,   -348,    -78,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   -348,   3432,   -456,    624,    408]
  K1( 784,:) = [   -456,   -348,   -240,   -240,   2568,  -1104,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432, &
                   408,    624,   -240,   -348,  -1104,   1056,   -240,   3432,  -1104,   -240,    -78,     30,   -348,   -348, &
                  -456,   -240,     30,   -348,   -456,    300,    -78,    -78,   -348,    624,   -240,   3432,    408,   -456, &
                   300,   3432,    -78,   3324,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456, &
                   408,  -2724,    300,    300,    300,   3432,  -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432, &
                   -78,    300,     30,   -456,    -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300, &
                  -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   2568,  -1104, &
                  -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456, &
                   -78,    300,   -348,     30,   -456,   2568,   -348,   -456]
  K1( 785,:) = [    300,   -456,   -456,   2568,   2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348, &
                  -348,   -456,   -456,   2568,   -456,   -240,   -348,   2568,   -240,  -1104,   3432,   -240,   -240,  -1104, &
                 -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240,    624,    408,   3432,   -456, &
                  2568,  -1104,   -348,   -456,   -240,   -240,   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104, &
                  -456,    300,   2568,   -456,    300,  -2724,   3432,    300,  21846,  -2724,    300,    300,   -456,    -78, &
                 -2724,    408,    -78,   -456,     30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30, &
                  -456,    408,   -240,   -456,  -2724,    408,  -2724,    300,    408,    -78,    300,   -456,    300,   3432, &
                   -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78,   -348,     30, &
                   300,   -456,    408,   -456,    624,   -348,   3432,   -240]
  K1( 786,:) = [   3432,   -240,   -240,  -1104,  -1104,   1056,   -456,   -240,    408,  -2724,   -456,    408,   -348,   -240, &
                   624,    408,   3432,   -456,   2568,  -1104,   -348,   -456,   -240,   -240,    300,   -456,   -456,   2568, &
                  2568,  -1104,    -78,   -348,    -78,    300,     30,   -456,     30,   -348,   -348,   -456,   -456,   2568, &
                  -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568, &
                   -78,    300,   -456,   3432,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    -78,    300,    300, &
                   408,  -2724,   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456, &
                  -240,   -456,   -456,    408,    408,  -2724,    408,    -78,  -2724,    300,   -456,    300,   -456,   -240, &
                    30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30,    -78,    -78, &
                  -456,    300,    624,   -348,    408,   -456,   -240,   3432]
  K1( 787,:) = [    -78,   3324,    300,   3432,   2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240, &
                    30,    -78,   -348,   -348,   -456,    408,   3432,   -240,    624,   -348,   -348,   2568,   -456,   -240, &
                 -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104,   -456,    300,   2568,   -456, &
                  2568,   -456,   -456,   -348,   -348,     30,    300,    300,   -456,    -78,  -2724,    408,   -456,   3432, &
                  2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300, &
                   300,   3432,   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240, &
                  -456,    408,   -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348,    408,    624,    300,  -2724, &
                   300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408,    408,   -456, &
                  -456,   -240,   -456,     30,   -240,   -348,    -78,   -348]
  K1( 788,:) = [     30,    -78,   -456,   -240,   -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432, &
                   -78,   3324,   -456,   2568,   -348,    624,   -240,   3432,    408,   -456,   -348,   -456,   2568,  -1104, &
                  -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056,   -240,   3432,  -1104,   -240, &
                  -456,   3432,    408,    624,   -240,   -348,   -456,    -78,    300,    300,    408,  -2724,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324,    300,    -78,  -2724,  21846,    300,   3432, &
                 -2724,    300,   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456, &
                    30,   -456,   -348,    -78,    300,    -78,   -456,   2568,   -348,     30,   -456,   -348,    -78,    408, &
                  -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240, &
                   408,   -456,    408,   -456,   -456,    -78,    -78,     30]
  K1( 789,:) = [   -348,   2568,   -456,   -240,  -1104,   -240,     30,   -456,   -348,    -78,    300,    -78,   2568,  -1104, &
                  -456,    300,   2568,   -456,   2568,   -456,   -456,   -348,   -348,     30,    -78,   3324,    300,   3432, &
                  2568,   -456,    -78,    -78,   -348,     30,    300,   -456,   -456,   -240,     30,    -78,   -348,   -348, &
                  -456,    408,   3432,   -240,    624,   -348,   -456,   3432,   2568,   3324,    300,    -78,    300,    300, &
                  -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724, &
                  3432,    300,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240, &
                  -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456,    624,    408,   -456,    408, &
                   -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456,  -2724,    408, &
                  -240,   -456,   -240,   -348,   -456,     30,   -348,    -78]
  K1( 790,:) = [   -348,   -456,   2568,  -1104,   -240,   -240,   -456,    408,   -240,   -456,  -2724,    408,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   -456,   3432,    408,    624,   -240,   -348,     30,    -78,   -456,   -240, &
                  -348,   -348,   -348,     30,    -78,    -78,   -456,    300,    300,   3432,    -78,   3324,   -456,   2568, &
                  -348,    624,   -240,   3432,    408,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78, &
                   300,    300,    408,  -2724,   2568,   3324,   -456,   3432,    -78,    300,    300,   3432,  -2724,  21846, &
                   300,  -2724,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104, &
                  -348,    -78,     30,   -456,    -78,    300,   -348,     30,   -456,   2568,   -348,   -456,     30,   -456, &
                   -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240,    408,  -2724, &
                  -456,    408,   -456,    -78,    408,   -456,     30,    -78]
  K1( 791,:) = [   -456,    300,   2568,  -1104,   -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240, &
                  -348,   2568,   -240,  -1104,     30,   -348,   -348,   -456,   -456,   2568,   -240,   3432,  -1104,   1056, &
                  -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104,   -348,   -456,   -240,   -240, &
                  -348,   -240,    624,    408,   3432,   -456,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568, &
                  2568,   -456,   -456,    300,    300,    300,   -456,    -78,  -2724,    408,    300,  -2724,   3432,    300, &
                 21846,  -2724,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348, &
                   -78,    -78,   -348,     30,    300,   -456,    408,   -456,    624,   -348,   3432,   -240,    -78,   -456, &
                    30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408,   -240,   -456, &
                 -2724,    408,  -2724,    300,    408,    -78,    300,   -456]
  K1( 792,:) = [   -240,   3432,  -1104,   1056,   -240,  -1104,   -240,   -456,   -456,    408,    408,  -2724,   2568,  -1104, &
                  -348,   -456,   -240,   -240,   -348,   -240,    624,    408,   3432,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,   -348,    -78,     30,   -456,    -78,    300,   -456,   -240,   -348,   2568,   -240,  -1104, &
                    30,   -348,   -348,   -456,   -456,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324, &
                  -456,   3432,    -78,    300,   -456,    -78,    300,    300,    408,  -2724,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,   -240,     30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568, &
                  -348,     30,    -78,    -78,   -456,    300,    624,   -348,    408,   -456,   -240,   3432,   -348,   -240, &
                  -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456,   -456,    408, &
                   408,  -2724,    408,    -78,  -2724,    300,   -456,    300]
  K1( 793,:) = [    300,  -2724,    300,   -456,    408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408, &
                   408,   -456,   -456,   -240,   -456,     30,   -240,   -348,    -78,   -348,   -456,    408,   3432,   -240, &
                   624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456,    -78,    -78,     30,   -348, &
                  -348,   -348,   -240,   -456,    -78,     30,   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240, &
                  2568,   -348,   -240,   -456,    300,    -78,   -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568, &
                   300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456, &
                   300,    -78,   3432,   -456,   3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104,   3432,   -456, &
                  -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,  -2724,    408,    408,   -456,   -456,   -240]
  K1( 794,:) = [    -78,    408,   -456,    300,  -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724, &
                  -456,   -240,    408,   -456,    408,   -456,   -456,    -78,    -78,     30,   -348,    624,   -240,   3432, &
                   408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300,     30,   -348,    -78,    -78, &
                  -456,   2568,   3432,    300,   3324,    -78,   -456,   3432,    408,    624,   -240,   -348,   -240,   -240, &
                  -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,  -2724,  21846,    300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300, &
                   300,   -456,   -456,   2568,   2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568,   -456,   2568, &
                  -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568, &
                   300,   -456,    300,    -78,   -456,     30,    -78,   -348]
  K1( 795,:) = [   -456,    408,    -78,     30,   -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456, &
                 -2724,    408,   -240,   -456,   -240,   -348,   -456,     30,   -348,    -78,   2568,   -456,   -456,   -348, &
                  -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78,   -456,     30,    -78,   -348, &
                  2568,   -456,  -1104,   2568,    300,   -456,   -456,    408,   3432,   -240,    624,   -348,   2568,   -456, &
                  3324,    -78,   3432,    300,    300,   -456,    -78,    -78,     30,   -348,   -348,   -348,   -240,   -456, &
                   -78,     30,  -2724,    300,  21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568, &
                 -2724,    408,    300,    300,    -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568,   -240,   -348, &
                  3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568, &
                  -456,   -348,    408,  -2724,   -456,   -240,    408,   -456]
  K1( 796,:) = [     30,   -456,    -78,   -348,   -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240, &
                   408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   -456,   3432,    408,    624, &
                  -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408,    408,   -456,   -456,   -240, &
                 -1104,   -240,   1056,  -1104,   3432,   -240,   -348,    624,   -240,   3432,    408,   -456,   -348,   -348, &
                   -78,     30,   -240,   -456,   -456,    300,     30,   -348,    -78,    -78,   -456,   2568,   3432,    300, &
                  3324,    -78,    300,   3432,  -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104, &
                   408,  -2724,    -78,   -456,    300,    300,    -78,    300,   3324,   2568,   3432,   -456,   -348,     30, &
                  -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456, &
                  2568,   -348,    -78,    300,    -78,   -348,   -456,     30]
  K1( 797,:) = [    -78,   -456,     30,    -78,    408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408, &
                  -240,   -456,  -2724,    408,  -2724,    300,    408,    -78,    300,   -456,     30,   -348,   -348,   -456, &
                  -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300,    -78,   -348,   -456,     30, &
                  -240,  -1104,   -240,   -456,   2568,   -348,   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104, &
                  3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568, &
                  -456,   -348,    300,  -2724,   3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456, &
                  -456,    300,   2568,  -1104,   -456,   2568,  -2724,    408,    300,    300,    -78,   -456,    408,   -456, &
                   624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348,   -240,   -456, &
                   -78,     30,    300,   -456,    -78,    -78,     30,   -348]
  K1( 798,:) = [   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456, &
                  -456,    408,    408,  -2724,    408,    -78,  -2724,    300,   -456,    300,   -348,   -240,    624,    408, &
                  3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724,   -456,   -240,    408,   -456, &
                  -240,   -240,  -1104,   2568,   -456,   -348,     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568, &
                   300,   -456,  -1104,   2568,    -78,    300,    -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456, &
                  2568,   -348,   3432,    300,    300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568, &
                   -78,    300,   3324,   2568,   3432,   -456,    408,  -2724,    -78,   -456,    300,    300,    624,   -348, &
                   408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568,   3432,    300, &
                  3324,    -78,   -456,    300,     30,   -348,    -78,    -78]
  K1( 799,:) = [   -456,    408,   3432,   -240,    624,   -348,   2568,   -456,   3324,    -78,   3432,    300,    300,   -456, &
                   -78,    -78,     30,   -348,   -348,   -348,   -240,   -456,    -78,     30,    300,  -2724,    300,   -456, &
                   408,    -78,   -456,    408,    -78,     30,   -456,    -78,  -2724,    408,    408,   -456,   -456,   -240, &
                  -456,     30,   -240,   -348,    -78,   -348,  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456, &
                  -456,   -348,   -348,     30,   -456,     30,    300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456, &
                  -456,    300,  -2724,    408,    300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432, &
                  3432,   -456,    300,    -78,   2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568,   -240,   -240, &
                 -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,    408,   -456,  -2724,    408,   -240,   -456]
  K1( 800,:) = [   -348,    624,   -240,   3432,    408,   -456,   -348,   -348,    -78,     30,   -240,   -456,   -456,    300, &
                    30,   -348,    -78,    -78,   -456,   2568,   3432,    300,   3324,    -78,    -78,    408,   -456,    300, &
                 -2724,    300,     30,   -456,    -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240,    408,   -456, &
                   408,   -456,   -456,    -78,    -78,     30,   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432, &
                   408,    624,   -240,   -348,    408,   -456,  -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,    408,  -2724,    -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300, &
                  -456,   2568,    300,   -456,  -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324,   -240,  -1104, &
                  -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -456,     30,    300,    -78,   -348,    -78]
  K1( 801,:) = [   2568,   -456,   -456,   -348,   -348,     30,  -1104,   -240,   2568,   -348,   -240,   -456,    300,    -78, &
                  -456,     30,    -78,   -348,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    408,    -78,     30, &
                  -456,    -78,    300,  -2724,    300,   -456,    408,    -78,    408,   -456,  -2724,    408,   -240,   -456, &
                  -240,   -348,   -456,     30,   -348,    -78,   2568,   -456,   3324,    -78,   3432,    300,   -456,    408, &
                  3432,   -240,    624,   -348,    -78,    -78,    300,   -456,   -348,     30,   -240,   -456,   -348,   -348, &
                    30,    -78,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300, &
                   300,    300,  -2724,    408,   -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568,   -240,   -240, &
                  -348,   -456,   -456,   -240,    408,  -2724,   -456,    408]
  K1( 802,:) = [   -456,   3432,    408,    624,   -240,   -348,   -240,   -240,   -456,   -348,  -1104,   2568,  -2724,    408, &
                   408,   -456,   -456,   -240,  -1104,   -240,   1056,  -1104,   3432,   -240,     30,   -456,    -78,   -348, &
                  -240,   -348,    -78,    408,   -456,    300,  -2724,    300,   -456,   -240,    408,  -2724,   -456,    408, &
                  -456,    -78,    408,   -456,     30,    -78,   -348,   -348,    -78,     30,   -240,   -456,   -348,    624, &
                  -240,   3432,    408,   -456,     30,   -348,   -456,    300,    -78,    -78,   3432,    300,   -456,   2568, &
                   -78,   3324,    300,   -456,   -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724, &
                   -78,   -456,    408,  -2724,    300,    300,   3324,   2568,    -78,    300,   -456,   3432,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,    -78,   -348,    -78,    300,     30,   -456]
  K1( 803,:) = [     30,   -348,   -348,   -456,   -456,   2568,   -456,   2568,    300,   -456,  -1104,   2568,    -78,    300, &
                   -78,   -348,   -456,     30,   -240,  -1104,   -240,   -456,   2568,   -348,    -78,   -456,     30,    -78, &
                   408,   -456,   -348,   -240,   -348,    -78,   -456,     30,   -456,    408,   -240,   -456,  -2724,    408, &
                 -2724,    300,    408,    -78,    300,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240, &
                   624,    408,   3432,   -456,   -456,   -240,    408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240, &
                  -348,   -456,    -78,    300,   3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724, &
                  2568,  -1104,   -456,    300,   2568,   -456,    300,    300,  -2724,    408,   -456,    -78,   -456,   2568, &
                  3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456,   -348,   -348, &
                    30,    -78,    -78,    -78,    300,   -456,   -348,     30]
  K1( 804,:) = [   -348,   -240,    624,    408,   3432,   -456,   -240,  -1104,   3432,   -240,   1056,  -1104,    408,  -2724, &
                  -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   -348,   -240,   -348,    -78, &
                  -456,     30,    -78,   -456,     30,    -78,    408,   -456,   -240,   -456,   -456,    408,    408,  -2724, &
                   408,    -78,  -2724,    300,   -456,    300,   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348, &
                  -348,   -456,   -456,   2568,    -78,   -348,    -78,    300,     30,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,   -456,    300,   2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846, &
                  3324,   2568,    -78,    300,   -456,   3432,    -78,   -456,    408,  -2724,    300,    300,   -348,   -348, &
                  -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300,   -456,   2568, &
                   -78,   3324,     30,   -348,   -456,    300,    -78,    -78]
  K1( 805,:) = [   2568,   -456,   3324,    -78,   3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78, &
                   300,   -456,   -348,     30,   -240,   -456,   -348,   -348,     30,    -78,  -1104,   -240,   2568,   -348, &
                  -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30,    300,    -78,   -348,    -78, &
                 -1104,   2568,   2568,   -456,   -456,    300,    300,  -2724,    300,   -456,    408,    -78,   -456,    408, &
                   -78,     30,   -456,    -78,  -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348, &
                   -78,   -348,    300,    300,  -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324, &
                 21846,  -2724,  -2724,    300,    300,   3432,   2568,   -456,  -1104,   2568,    300,   -456,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348, &
                   408,    624,   -456,    408,   -240,   -456,  -2724,    408]
  K1( 806,:) = [   -348,   -348,    -78,     30,   -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348, &
                  -456,    300,    -78,    -78,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -240,   -456,   -348, &
                 -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456,  -2724,    408,   -240,   -456, &
                  1056,  -1104,  -1104,   -240,   -240,   3432,    -78,    408,   -456,    300,  -2724,    300,     30,   -456, &
                   -78,   -348,   -240,   -348,    408,  -2724,   -456,   -240,    408,   -456,    408,   -456,   -456,    -78, &
                   -78,     30,    -78,   -456,    408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568, &
                 -2724,  21846,    300,   3432,  -2724,    300,   -456,   3432,   2568,   3324,    300,    -78,   -240,   -456, &
                  -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568,   -348,     30, &
                  -456,   -348,     30,   -456,   -348,    -78,    300,    -78]
  K1( 807,:) = [  -1104,   -240,   2568,   -348,   -240,   -456,   2568,   -456,   -456,   -348,   -348,     30,   -456,     30, &
                   300,    -78,   -348,    -78,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   -456,   3324,    -78, &
                  3432,    300,   -456,    408,   3432,   -240,    624,   -348,    -78,    -78,    300,   -456,   -348,     30, &
                  -240,   -456,   -348,   -348,     30,    -78,   -456,    408,    -78,     30,   -456,    -78,    300,  -2724, &
                   300,   -456,    408,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,   3432,   -456,    300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78, &
                 -2724,    300,  21846,  -2724,   3432,    300,  -1104,   2568,   2568,   -456,   -456,    300,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456, &
                   624,    408,   -240,   -456,   -456,    408,    408,  -2724]
  K1( 808,:) = [   -240,   -240,   -456,   -348,  -1104,   2568,   -456,   3432,    408,    624,   -240,   -348,    408,   -456, &
                 -2724,    408,   -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   -348,   -348,    -78,     30, &
                  -240,   -456,   -348,    624,   -240,   3432,    408,   -456,     30,   -348,   -456,    300,    -78,    -78, &
                  3432,    300,   -456,   2568,    -78,   3324,     30,   -456,    -78,   -348,   -240,   -348,    -78,    408, &
                  -456,    300,  -2724,    300,   -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456, &
                    30,    -78,   -456,   2568,    300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300, &
                   300,   3432,  -2724,  21846,    300,  -2724,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568, &
                  -348,   -456,   -348,    -78,     30,   -456,    -78,    300]
  K1( 809,:) = [   -456,   2568,    300,   -456,  -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348, &
                   -78,    300,     30,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,   -240,  -1104,   3432,   -240, &
                  1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240,    408,  -2724,   -456,    408, &
                 -1104,   2568,   -240,   -240,   -348,   -456,    -78,   -456,     30,    -78,    408,   -456,   -348,   -240, &
                  -348,    -78,   -456,     30,   -456,    408,   -240,   -456,  -2724,    408,  -2724,    300,    408,    -78, &
                   300,   -456,   3324,   2568,    -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456, &
                   300,  -2724,   3432,    300,  21846,  -2724,    300,    300,   -456,    -78,  -2724,    408,   3432,    300, &
                  -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456,    624,   -348, &
                  3432,   -240,    -78,    -78,   -348,     30,    300,   -456]
  K1( 810,:) = [   -240,  -1104,   3432,   -240,   1056,  -1104,   -348,   -240,    624,    408,   3432,   -456,   -456,   -240, &
                   408,  -2724,   -456,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   -456,   2568,    300,   -456, &
                 -1104,   2568,     30,   -348,   -348,   -456,   -456,   2568,    -78,   -348,    -78,    300,     30,   -456, &
                  -240,   -456,   -240,  -1104,   -348,   2568,   -348,   -240,   -348,    -78,   -456,     30,    -78,   -456, &
                    30,    -78,    408,   -456,   -240,   -456,   -456,    408,    408,  -2724,    408,    -78,  -2724,    300, &
                  -456,    300,   2568,  -1104,   -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432, &
                  3432,    300,    300,  -2724,  -2724,  21846,   -456,    -78,    300,    300,    408,  -2724,   -240,   -456, &
                  -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348,    408,   -456, &
                  -240,   3432,   -348,     30,    -78,    -78,   -456,    300]
  K1( 811,:) = [    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78, &
                  -348,     30,    300,   -456,    408,   -456,    624,   -348,   3432,   -240,   -456,   -240,   -348,   2568, &
                  -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456,   -348,    -78,    300,    -78, &
                  -456,   2568,   -348,     30,   -456,   -348,   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056, &
                  -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348, &
                   408,    624,    300,    300,   -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78, &
                  2568,   -456,  -1104,   2568,    300,   -456,  21846,  -2724,  -2724,    300,    300,   3432,  -2724,    300, &
                   408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30,   -240,   -348, &
                   -78,   -348,  -2724,    408,    408,   -456,   -456,   -240]
  K1( 812,:) = [   -456,   -240,     30,    -78,   -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30, &
                   -78,    -78,   -456,    300,    624,   -348,    408,   -456,   -240,   3432,   2568,  -1104,   -348,   -456, &
                  -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408,   -240,   -456,  -2724,    408, &
                  3432,   -456,   -240,   -348,    408,    624,   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104, &
                  -456,    300,   2568,   -456,     30,   -456,   -348,    -78,    300,    -78,   -456,   2568,   -348,     30, &
                  -456,   -348,   -456,    -78,    300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456, &
                  -456,   3432,   2568,   3324,    300,    -78,  -2724,  21846,    300,   3432,  -2724,    300,    408,    -78, &
                 -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456,   -456,    -78, &
                   -78,     30,    408,  -2724,   -456,   -240,    408,   -456]
  K1( 813,:) = [   -456,   -240,   -348,   2568,   -240,  -1104,   2568,  -1104,   -456,    300,   2568,   -456,     30,   -456, &
                  -348,    -78,    300,    -78,   -456,   2568,   -348,     30,   -456,   -348,    300,   3432,    -78,   3324, &
                  -456,   2568,   -456,   -240,     30,    -78,   -348,   -348,    -78,    -78,   -348,     30,    300,   -456, &
                   408,   -456,    624,   -348,   3432,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104, &
                  -348,   -456,   -240,   -240,   -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456, &
                   624,    408,   -456,   3432,   2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408, &
                 -1104,   2568,   2568,   -456,   -456,    300,  -2724,    300,  21846,  -2724,   3432,    300,    408,   -456, &
                  -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,    408,   -456,  -2724,    408,   -240,   -456]
  K1( 814,:) = [   2568,  -1104,   -348,   -456,   -240,   -240,  -1104,   1056,   -240,   3432,  -1104,   -240,   -456,    408, &
                  -240,   -456,  -2724,    408,   3432,   -456,   -240,   -348,    408,    624,   -456,   -240,     30,    -78, &
                  -348,   -348,    300,   3432,    -78,   3324,   -456,   2568,   -348,     30,    -78,    -78,   -456,    300, &
                   624,   -348,    408,   -456,   -240,   3432,   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240, &
                  -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456,    -78,    300,   -348,     30,   -456,   2568, &
                  -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724, &
                  2568,   3324,   -456,   3432,    -78,    300,    300,   3432,  -2724,  21846,    300,  -2724,   -456,     30, &
                  -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78,    408,   -456, &
                    30,    -78,   -456,   -240,    408,  -2724,   -456,    408]
  K1( 815,:) = [   2568,  -1104,   -456,    300,   2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78, &
                    30,   -456,    -78,    300,   -348,     30,   -456,   2568,   -348,   -456,  -1104,   1056,   -240,   3432, &
                 -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456,   -456,    408,    408,  -2724, &
                  -240,   -348,   3432,   -456,    624,    408,    300,   3432,    -78,   3324,   -456,   2568,   -456,   -240, &
                    30,    -78,   -348,   -348,    -78,    -78,   -348,     30,    300,   -456,    408,   -456,    624,   -348, &
                  3432,   -240,   2568,   3324,   -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300, &
                   300,    300,   -456,    -78,  -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724,   -456,    -78, &
                   408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300,    408,    -78, &
                   300,   -456,   -456,    408,   -240,   -456,  -2724,    408]
  K1( 816,:) = [  -1104,   1056,   -240,   3432,  -1104,   -240,   2568,  -1104,   -348,   -456,   -240,   -240,   -240,   -456, &
                  -456,    408,    408,  -2724,   -240,   -348,   3432,   -456,    624,    408,   2568,  -1104,   -456,    300, &
                  2568,   -456,   -456,   -240,   -348,   2568,   -240,  -1104,   -348,    -78,     30,   -456,    -78,    300, &
                  -348,     30,   -456,   2568,   -348,   -456,   -456,   -240,     30,    -78,   -348,   -348,    300,   3432, &
                   -78,   3324,   -456,   2568,   -348,     30,    -78,    -78,   -456,    300,    624,   -348,    408,   -456, &
                  -240,   3432,  -1104,   2568,   2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300, &
                  -456,    -78,    300,    300,    408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846,   -240,   -348, &
                  -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78,  -2724,    300, &
                  -456,    300,   -240,   -456,   -456,    408,    408,  -2724]
  K1( 817,:) = [  -2724,    300,    408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30, &
                  -240,   -348,    -78,   -348,  -2724,    408,    408,   -456,   -456,   -240,    408,   -456,    624,   -348, &
                  3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348,   -240,   -456,    -78,     30, &
                   300,   -456,    -78,    -78,     30,   -348,   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104, &
                  -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568,    300,   -456,    300,    -78,   -456,     30, &
                   -78,   -348,   3432,   -456,   -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348, &
                 -1104,   -240,   1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456,   -456,   -240,  21846,  -2724, &
                 -2724,    300,    300,   3432,  -2724,    408,    300,    300,    -78,   -456,    300,    -78,   3432,   -456, &
                  3324,   2568,    300,   -456,   -456,   2568,   2568,  -1104]
  K1( 818,:) = [    408,    -78,  -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456, &
                  -456,    -78,    -78,     30,    408,  -2724,   -456,   -240,    408,   -456,    624,   -348,    408,   -456, &
                  -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568,   3432,    300,   3324,    -78, &
                  -456,    300,     30,   -348,    -78,    -78,   3432,   -456,   -240,   -348,    408,    624,   -240,   -240, &
                 -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456, &
                  -456,   -240,   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348, &
                  2568,   -456,  -1104,   2568,    300,   -456,    300,    -78,   -456,     30,    -78,   -348,  -2724,  21846, &
                   300,   3432,  -2724,    300,    408,  -2724,    -78,   -456,    300,    300,    300,   -456,   -456,   2568, &
                  2568,  -1104,    300,    -78,   3432,   -456,   3324,   2568]
  K1( 819,:) = [    408,   -456,   -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348, &
                  -456,     30,   -348,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -456,   2568,   -348,     30, &
                  -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456,  -1104,   2568,    300,   -456, &
                   300,    -78,   -456,     30,    -78,   -348,    408,   -456,    624,   -348,   3432,   -240,   -456,   2568, &
                  3432,    300,   3324,    -78,   -348,   -348,   -240,   -456,    -78,     30,    300,   -456,    -78,    -78, &
                    30,   -348,   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240, &
                  -240,   -240,  -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240,    408,   -456,  -2724,    300, &
                 21846,  -2724,   3432,    300,    300,    -78,   3432,   -456,   3324,   2568,  -2724,    408,    300,    300, &
                   -78,   -456,   -456,    300,   2568,  -1104,   -456,   2568]
  K1( 820,:) = [   -456,     30,   -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78, &
                   408,   -456,     30,    -78,   -456,   -240,    408,  -2724,   -456,    408,   3432,   -456,   -240,   -348, &
                   408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240,   1056,  -1104,   3432,   -240, &
                 -2724,    408,    408,   -456,   -456,   -240,    624,   -348,    408,   -456,   -240,   3432,   -348,   -348, &
                  -240,   -456,    -78,     30,   -456,   2568,   3432,    300,   3324,    -78,   -456,    300,     30,   -348, &
                   -78,    -78,   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456, &
                  -240,  -1104,   -240,   -456,   2568,   -348,    -78,    300,    -78,   -348,   -456,     30,    300,   3432, &
                 -2724,  21846,    300,  -2724,    300,   -456,   -456,   2568,   2568,  -1104,    408,  -2724,    -78,   -456, &
                   300,    300,    -78,    300,   3324,   2568,   3432,   -456]
  K1( 821,:) = [   -456,    -78,    408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300, &
                   408,    -78,    300,   -456,   -456,    408,   -240,   -456,  -2724,    408,   -348,     30,   -456,   2568, &
                  -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456,   2568,   -348, &
                   -78,    300,    -78,   -348,   -456,     30,   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240, &
                   408,   -456,    408,   -456,    624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78, &
                  -348,   -348,   -240,   -456,    -78,     30,    300,   -456,    -78,    -78,     30,   -348,    300,  -2724, &
                  3432,    300,  21846,  -2724,    -78,    300,   3324,   2568,   3432,   -456,   -456,    300,   2568,  -1104, &
                  -456,   2568,  -2724,    408,    300,    300,    -78,   -456]
  K1( 822,:) = [   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78, &
                 -2724,    300,   -456,    300,   -240,   -456,   -456,    408,    408,  -2724,   -240,   -348,   3432,   -456, &
                   624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240,  -1104,   2568,   -456,   -348, &
                   408,  -2724,   -456,   -240,    408,   -456,   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -240,  -1104,   -240,   -456,   2568,   -348,    -78,    300,    -78,   -348, &
                  -456,     30,    624,   -348,    408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30, &
                  -456,   2568,   3432,    300,   3324,    -78,   -456,    300,     30,   -348,    -78,    -78,   3432,    300, &
                   300,  -2724,  -2724,  21846,   -456,    300,   2568,  -1104,   -456,   2568,    -78,    300,   3324,   2568, &
                  3432,   -456,    408,  -2724,    -78,   -456,    300,    300]
  K1( 823,:) = [    408,   -456,    624,   -348,   3432,   -240,   -456,   2568,   3432,    300,   3324,    -78,   -348,   -348, &
                  -240,   -456,    -78,     30,    300,   -456,    -78,    -78,     30,   -348,  -2724,    300,    408,    -78, &
                   300,   -456,    408,   -456,   -456,    -78,    -78,     30,   -456,     30,   -240,   -348,    -78,   -348, &
                 -2724,    408,    408,   -456,   -456,   -240,   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568, &
                  -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78, &
                  -348,    -78,   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624, &
                  1056,  -1104,  -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408,   -240,   -456,  -2724,    408, &
                   300,    300,    -78,   -456,  21846,  -2724,  -2724,    300,    300,   3432,   3432,   -456,    300,    -78, &
                  2568,   3324,   -456,   2568,    300,   -456,  -1104,   2568]
  K1( 824,:) = [    624,   -348,    408,   -456,   -240,   3432,   -348,   -348,   -240,   -456,    -78,     30,   -456,   2568, &
                  3432,    300,   3324,    -78,   -456,    300,     30,   -348,    -78,    -78,    408,    -78,  -2724,    300, &
                  -456,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,   -456,   -456,    -78,    -78,     30, &
                   408,  -2724,   -456,   -240,    408,   -456,   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456, &
                  -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408, &
                  -240,   -456,   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348, &
                 -1104,   2568,   2568,   -456,   -456,    300,   -456,     30,    300,    -78,   -348,    -78,    408,  -2724, &
                   -78,   -456,    300,    300,  -2724,  21846,    300,   3432,  -2724,    300,   -456,   2568,    300,   -456, &
                 -1104,   2568,   3432,   -456,    300,    -78,   2568,   3324]
  K1( 825,:) = [   -456,   2568,   -348,     30,   -456,   -348,   -240,  -1104,   -240,   -456,   2568,   -348,   2568,   -456, &
                 -1104,   2568,    300,   -456,    300,    -78,   -456,     30,    -78,   -348,    408,   -456,   -456,    -78, &
                   -78,     30,  -2724,    300,    408,    -78,    300,   -456,   -240,   -348,   -456,     30,   -348,    -78, &
                   408,   -456,  -2724,    408,   -240,   -456,   -456,   2568,   3432,    300,   3324,    -78,    408,   -456, &
                   624,   -348,   3432,   -240,   -240,   -456,   -348,   -348,     30,    -78,    -78,    -78,    300,   -456, &
                  -348,     30,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408, &
                 -1104,   2568,   -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724,   -456,    408,    300,    -78, &
                  3432,   -456,   3324,   2568,  -2724,    300,  21846,  -2724,   3432,    300,    300,    300,  -2724,    408, &
                  -456,    -78,   2568,  -1104,   -456,    300,   2568,   -456]
  K1( 826,:) = [   3432,   -456,   -240,   -348,    408,    624,   -240,   -240,  -1104,   2568,   -456,   -348,  -1104,   -240, &
                  1056,  -1104,   3432,   -240,  -2724,    408,    408,   -456,   -456,   -240,   -456,     30,   -240,   -348, &
                   -78,   -348,    408,    -78,  -2724,    300,   -456,    300,   -456,    -78,    408,   -456,     30,    -78, &
                  -456,   -240,    408,  -2724,   -456,    408,   -348,   -348,   -240,   -456,    -78,     30,    624,   -348, &
                   408,   -456,   -240,   3432,   3432,    300,   -456,   2568,    -78,   3324,     30,   -348,   -456,    300, &
                   -78,    -78,   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456, &
                  -240,   -456,   -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300,     30,   -456,    300,   -456, &
                  -456,   2568,   2568,  -1104,    300,   3432,  -2724,  21846,    300,  -2724,    -78,   -456,    408,  -2724, &
                   300,    300,   3324,   2568,    -78,    300,   -456,   3432]
  K1( 827,:) = [   -348,     30,   -456,   2568,   -348,   -456,   2568,   -456,  -1104,   2568,    300,   -456,   -240,  -1104, &
                  -240,   -456,   2568,   -348,    -78,    300,    -78,   -348,   -456,     30,   -456,    -78,    408,   -456, &
                    30,    -78,   -240,   -348,   -456,     30,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456, &
                  -456,    408,   -240,   -456,  -2724,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348, &
                  3432,   -456,    624,    408,  -1104,   2568,   -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724, &
                  -456,    408,   -456,   2568,   3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240, &
                  -240,   -456,   -348,   -348,     30,    -78,    -78,    -78,    300,   -456,   -348,     30,    -78,    300, &
                  3324,   2568,   3432,   -456,    300,  -2724,   3432,    300,  21846,  -2724,   2568,  -1104,   -456,    300, &
                  2568,   -456,    300,    300,  -2724,    408,   -456,    -78]
  K1( 828,:) = [   -240,   -348,   3432,   -456,    624,    408,  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -240, &
                 -1104,   2568,   -456,   -348,    408,  -2724,   -456,   -240,    408,   -456,   -240,   -348,   -456,     30, &
                  -348,    -78,   -456,    -78,    408,   -456,     30,    -78,    408,    -78,  -2724,    300,   -456,    300, &
                  -240,   -456,   -456,    408,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30, &
                  -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300, &
                    30,   -456,   -348,   -348,   -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432, &
                  3432,    300,   -456,   2568,    -78,   3324,     30,   -348,   -456,    300,    -78,    -78,   -456,    300, &
                  2568,  -1104,   -456,   2568,   3432,    300,    300,  -2724,  -2724,  21846,   3324,   2568,    -78,    300, &
                  -456,   3432,    -78,   -456,    408,  -2724,    300,    300]
  K1( 829,:) = [   -456,   2568,   3432,    300,   3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456, &
                  -348,   -348,     30,    -78,    -78,    -78,    300,   -456,   -348,     30,   -240,  -1104,   -240,   -456, &
                  2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568,   2568,   -456,   -456,    300, &
                  -456,     30,    300,    -78,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456,    408,   -456, &
                  -456,    -78,    -78,     30,   -456,     30,   -240,   -348,    -78,   -348,  -2724,    408,    408,   -456, &
                  -456,   -240,  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432, &
                  3432,   -456,   -240,   -348,    408,    624,   -456,    408,   -240,   -456,  -2724,    408,    300,    300, &
                 -2724,    408,   -456,    -78,   3432,   -456,    300,    -78,   2568,   3324,  21846,  -2724,  -2724,    300, &
                   300,   3432,   2568,   -456,  -1104,   2568,    300,   -456]
  K1( 830,:) = [   -348,   -348,   -240,   -456,    -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300, &
                  -456,   2568,    -78,   3324,     30,   -348,   -456,    300,    -78,    -78,   -240,   -240,  -1104,   2568, &
                  -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104,  -1104,   -240,   -240,   3432, &
                   408,   -456,  -2724,    408,   -240,   -456,    408,    -78,  -2724,    300,   -456,    300,   -456,     30, &
                  -240,   -348,    -78,   -348,    408,   -456,   -456,    -78,    -78,     30,    408,  -2724,   -456,   -240, &
                   408,   -456,   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300, &
                  -456,   2568,   -348,     30,   -456,   -348,     30,   -456,   -348,    -78,    300,    -78,    -78,   -456, &
                   408,  -2724,    300,    300,   -456,   2568,    300,   -456,  -1104,   2568,  -2724,  21846,    300,   3432, &
                 -2724,    300,   -456,   3432,   2568,   3324,    300,    -78]
  K1( 831,:) = [   -240,  -1104,   -240,   -456,   2568,   -348,   -456,   2568,   -348,     30,   -456,   -348,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -456,     30,    300,    -78,   -348,    -78,   -456,   2568,   3432,    300, &
                  3324,    -78,    408,   -456,    624,   -348,   3432,   -240,   -240,   -456,   -348,   -348,     30,    -78, &
                   -78,    -78,    300,   -456,   -348,     30,    408,   -456,   -456,    -78,    -78,     30,  -2724,    300, &
                   408,    -78,    300,   -456,   -240,   -348,   -456,     30,   -348,    -78,    408,   -456,  -2724,    408, &
                  -240,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456, &
                  -240,   -348,   3432,   -456,    624,    408,   -240,   -456,   -456,    408,    408,  -2724,   3432,   -456, &
                   300,    -78,   2568,   3324,    300,    300,  -2724,    408,   -456,    -78,  -2724,    300,  21846,  -2724, &
                  3432,    300,  -1104,   2568,   2568,   -456,   -456,    300]
  K1( 832,:) = [   -240,   -240,  -1104,   2568,   -456,   -348,   3432,   -456,   -240,   -348,    408,    624,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,    408,   -456,  -2724,    408,   -240,   -456,   -348,   -348,   -240,   -456, &
                   -78,     30,    624,   -348,    408,   -456,   -240,   3432,   3432,    300,   -456,   2568,    -78,   3324, &
                    30,   -348,   -456,    300,    -78,    -78,   -456,     30,   -240,   -348,    -78,   -348,    408,    -78, &
                 -2724,    300,   -456,    300,   -456,    -78,    408,   -456,     30,    -78,   -456,   -240,    408,  -2724, &
                  -456,    408,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568, &
                  -348,     30,   -456,   2568,   -348,   -456,   -348,    -78,     30,   -456,    -78,    300,   -456,   2568, &
                   300,   -456,  -1104,   2568,    -78,   -456,    408,  -2724,    300,    300,    300,   3432,  -2724,  21846, &
                   300,  -2724,   2568,   3324,   -456,   3432,    -78,    300]
  K1( 833,:) = [   2568,   -456,  -1104,   2568,    300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456, &
                  -240,  -1104,   -348,   2568,    -78,   -348,    -78,    300,     30,   -456,  -1104,   -240,   1056,  -1104, &
                  3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568,   -240,   -240,   -348,   -456, &
                  -456,   -240,    408,  -2724,   -456,    408,   -456,    -78,    408,   -456,     30,    -78,   -240,   -348, &
                  -456,     30,   -348,    -78,  -2724,    300,    408,    -78,    300,   -456,   -456,    408,   -240,   -456, &
                 -2724,    408,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78, &
                   408,   -456,    624,   -348,   3432,   -240,    -78,    -78,   -348,     30,    300,   -456,   3324,   2568, &
                   -78,    300,   -456,   3432,   2568,  -1104,   -456,    300,   2568,   -456,    300,  -2724,   3432,    300, &
                 21846,  -2724,    300,    300,   -456,    -78,  -2724,    408]
  K1( 834,:) = [  -1104,   -240,   1056,  -1104,   3432,   -240,   -240,   -348,   3432,   -456,    624,    408,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   -456,   -240,    408,  -2724,   -456,    408,   2568,   -456,  -1104,   2568, &
                   300,   -456,   -348,     30,   -456,   2568,   -348,   -456,   -240,   -456,   -240,  -1104,   -348,   2568, &
                   -78,   -348,    -78,    300,     30,   -456,   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78, &
                   408,   -456,     30,    -78,    408,    -78,  -2724,    300,   -456,    300,   -240,   -456,   -456,    408, &
                   408,  -2724,   -240,   -456,   -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324, &
                   624,   -348,    408,   -456,   -240,   3432,   -348,     30,    -78,    -78,   -456,    300,   2568,  -1104, &
                  -456,    300,   2568,   -456,   3324,   2568,    -78,    300,   -456,   3432,   3432,    300,    300,  -2724, &
                 -2724,  21846,   -456,    -78,    300,    300,    408,  -2724]
  K1( 835,:) = [   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456, &
                   624,   -348,   3432,   -240,    -78,    -78,   -348,     30,    300,   -456,   -240,   -456,   -240,  -1104, &
                  -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568,   -348,     30,   -456,   -348, &
                    30,   -456,   -348,    -78,    300,    -78,  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104, &
                 -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348,    408,    624,   -456,    408,   -240,   -456, &
                 -2724,    408,  -2724,    300,    408,    -78,    300,   -456,    408,   -456,   -456,    -78,    -78,     30, &
                  -456,     30,   -240,   -348,    -78,   -348,  -2724,    408,    408,   -456,   -456,   -240,    300,    300, &
                  -456,    -78,  -2724,    408,   -456,   3432,   2568,   3324,    300,    -78,   2568,   -456,  -1104,   2568, &
                   300,   -456,  21846,  -2724,  -2724,    300,    300,   3432]
  K1( 836,:) = [   -240,   -456,   -348,   -348,     30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348, &
                   408,   -456,   -240,   3432,   -348,     30,    -78,    -78,   -456,    300,  -1104,   2568,   -240,   -240, &
                  -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456,   -240,   -348,    408,    624, &
                  -456,    408,   -240,   -456,  -2724,    408,   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568, &
                  2568,   -456,   -456,    300,   -456,   2568,   -348,     30,   -456,   -348,     30,   -456,   -348,    -78, &
                   300,    -78,    408,    -78,  -2724,    300,   -456,    300,   -456,     30,   -240,   -348,    -78,   -348, &
                   408,   -456,   -456,    -78,    -78,     30,    408,  -2724,   -456,   -240,    408,   -456,   -456,    -78, &
                   300,    300,    408,  -2724,   2568,   -456,  -1104,   2568,    300,   -456,   -456,   3432,   2568,   3324, &
                   300,    -78,  -2724,  21846,    300,   3432,  -2724,    300]
  K1( 837,:) = [   -240,   -456,   -240,  -1104,   -348,   2568,  -1104,   2568,   2568,   -456,   -456,    300,   -456,   2568, &
                  -348,     30,   -456,   -348,     30,   -456,   -348,    -78,    300,    -78,   3432,    300,   -456,   2568, &
                   -78,   3324,   -240,   -456,   -348,   -348,     30,    -78,    408,   -456,    624,   -348,   3432,   -240, &
                   -78,    -78,   -348,     30,    300,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568, &
                  -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456,    624,    408,   -240,   -456,   -456,    408, &
                   408,  -2724,    408,   -456,   -456,    -78,    -78,     30,  -2724,    300,    408,    -78,    300,   -456, &
                  -240,   -348,   -456,     30,   -348,    -78,    408,   -456,  -2724,    408,   -240,   -456,   -456,   3432, &
                  2568,   3324,    300,    -78,    300,    300,   -456,    -78,  -2724,    408,  -1104,   2568,   2568,   -456, &
                  -456,    300,  -2724,    300,  21846,  -2724,   3432,    300]
  K1( 838,:) = [  -1104,   2568,   -240,   -240,   -348,   -456,   1056,  -1104,  -1104,   -240,   -240,   3432,   3432,   -456, &
                  -240,   -348,    408,    624,   -456,    408,   -240,   -456,  -2724,    408,   -240,   -456,   -348,   -348, &
                    30,    -78,   3432,    300,   -456,   2568,    -78,   3324,    624,   -348,    408,   -456,   -240,   3432, &
                  -348,     30,    -78,    -78,   -456,    300,  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456, &
                  -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568,   -348,   -456,   -348,    -78,     30,   -456, &
                   -78,    300,   -456,     30,   -240,   -348,    -78,   -348,    408,    -78,  -2724,    300,   -456,    300, &
                  -456,    -78,    408,   -456,     30,    -78,   -456,   -240,    408,  -2724,   -456,    408,   2568,   -456, &
                 -1104,   2568,    300,   -456,   -456,    -78,    300,    300,    408,  -2724,   2568,   3324,   -456,   3432, &
                   -78,    300,    300,   3432,  -2724,  21846,    300,  -2724]
  K1( 839,:) = [  -1104,   2568,   2568,   -456,   -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30, &
                  -456,   2568,   -348,   -456,   -348,    -78,     30,   -456,    -78,    300,   1056,  -1104,  -1104,   -240, &
                  -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348,   3432,   -456,    624,    408, &
                  -240,   -456,   -456,    408,    408,  -2724,   3432,    300,   -456,   2568,    -78,   3324,   -240,   -456, &
                  -348,   -348,     30,    -78,    408,   -456,    624,   -348,   3432,   -240,    -78,    -78,   -348,     30, &
                   300,   -456,   -456,    -78,    408,   -456,     30,    -78,   -240,   -348,   -456,     30,   -348,    -78, &
                 -2724,    300,    408,    -78,    300,   -456,   -456,    408,   -240,   -456,  -2724,    408,   2568,   3324, &
                  -456,   3432,    -78,    300,  -1104,   2568,   2568,   -456,   -456,    300,    300,    300,   -456,    -78, &
                 -2724,    408,    300,  -2724,   3432,    300,  21846,  -2724]
  K1( 840,:) = [   1056,  -1104,  -1104,   -240,   -240,   3432,  -1104,   2568,   -240,   -240,   -348,   -456,   -240,   -348, &
                  3432,   -456,    624,    408,   -240,   -456,   -456,    408,    408,  -2724,  -1104,   2568,   2568,   -456, &
                  -456,    300,   -240,   -456,   -240,  -1104,   -348,   2568,   -348,     30,   -456,   2568,   -348,   -456, &
                  -348,    -78,     30,   -456,    -78,    300,   -240,   -456,   -348,   -348,     30,    -78,   3432,    300, &
                  -456,   2568,    -78,   3324,    624,   -348,    408,   -456,   -240,   3432,   -348,     30,    -78,    -78, &
                  -456,    300,   -240,   -348,   -456,     30,   -348,    -78,   -456,    -78,    408,   -456,     30,    -78, &
                   408,    -78,  -2724,    300,   -456,    300,   -240,   -456,   -456,    408,    408,  -2724,  -1104,   2568, &
                  2568,   -456,   -456,    300,   2568,   3324,   -456,   3432,    -78,    300,   -456,    -78,    300,    300, &
                   408,  -2724,   3432,    300,    300,  -2724,  -2724,  21846]
  K1( 841,:) = [   -384,  -1896,   -168,   -195,   1533,  -1950,   -168,    264,   -168,   1533,     21,   -222,   -168,     48, &
                  -384,   -384,  -1896,   1344,   -168,    237,   -384,   1317,  -1464,   -168,  -1896,    480,    264,     -6, &
                  -222,    -60,   1533,   -222,   -168,   -168,     21,    264,     21,     -6,   -384,    102,     -6,   -357, &
                    21,    183,    102,   -384,    -60,    318,   -195,     -6,     48,   -195,     -6,     -6,  -1950,    -60, &
                   237,   -249,    183,   -546,  -1896,     48,  -1464,    237,   -195,  -1950,     -6,     -6,    -60,    183, &
                    -6,    -60,   1533,   -195,   -384,    102,     48,   -114,   -222,     -6,   1317,   -384,     -6,   -114, &
                  1344,   -114,   -168,   -168,   -357,    318,   -195,   -357,     -6,   1344,   2640,   -816,   -168,   -249, &
                   102,   -384,    237,   -168,    264,   -546,   -384,   -384,    183,   -168,   -357,   -114,    318,   -168, &
                  1344,   -168,  -1950,    318,    -60,   -168,   -816,   -384]
  K1( 842,:) = [  -1896,   -384,   1533,  -1950,   -168,   -195,    264,   -168,     21,   -222,   -168,   1533,   -168,    237, &
                  -384,   1317,  -1464,   -168,   -168,     48,   -384,   -384,  -1896,   1344,    480,  -1896,   -222,    -60, &
                   264,     -6,   -222,   1533,     21,    264,   -168,   -168,     21,    183,    102,   -384,    -60,    318, &
                    21,     -6,   -384,    102,     -6,   -357,     -6,   -195,     -6,     -6,     48,   -195,    -60,  -1950, &
                   183,   -546,    237,   -249,     -6,     -6,    -60,    183,     -6,    -60,  -1896,     48,  -1464,    237, &
                  -195,  -1950,   -168,   -249,    102,   -384,    237,   -168,    264,   -546,   -384,   -384,    183,   -168, &
                  -357,   -114,    318,   -168,   1344,   -168,  -1950,    318,    -60,   -168,   -816,   -384,   1533,   -195, &
                  -384,    102,     48,   -114,   -222,     -6,   1317,   -384,     -6,   -114,   1344,   -114,   -168,   -168, &
                  -357,    318,   -195,   -357,     -6,   1344,   2640,   -816]
  K1( 843,:) = [   -168,   1533,   1560,   1533,   1560,   -168,     48,   -195,    480,     -6,   1749,     -6,     48,   -222, &
                  -168,   -168,     21,   -141,   -141,   -168,   1344,   -168,    264,   -141,    264,   -222,     48,   -222, &
                    48,    264,   -195,     48,     -6,     -6,   -195,     -6,  -1464,    210,   1533,   -168,    210,   -141, &
                  -195,     21,   -114,   -168,    -33,   -141,     21,     21,    210,    -33,     21,    210,    210,    210, &
                 -1302,    399,    -33,    156,  -1302,    156,    588,    102,    399,    102,     21,    210,    210,  -1302, &
                 -1302,    588,  -1464,    210,     21,     21,    -33,   -195,    912,    156,   -222,    264,    156,    534, &
                  1749,   -195,     -6,     -6,     48,    480,    210,     48,    156,   -195,   -357,    318,   -141,   1533, &
                  -357,    318,   -222,   -141,    534,   -222,   -114,   -168,    210,   1560,   3072,   -384,   -384,     48, &
                    48,    480,    210,   -195,    156,     48,   1344,   -168]
  K1( 844,:) = [   -195,  -1950,   1533, -12291,   -168,   1506,     21,    210,    210,  -1302,  -1302,    588,   -222,   1506, &
                    48,    237,     -6,   -168,     21,     -6,  -1896,  -1464,  -2004,    264,     -6,    -60,   -222,   1506, &
                   264,   -492,     21,    210,    -33,    399,    156,    102,    210,     -6,   -195,   -249,  -1518,   1533, &
                   -33,    183,     48,    237,    372,   -222,     -6,    -60,    -60,    372,    372,   -168,    -60,   -600, &
                   372,  -3084,    318,    264,    372,    318,   -168,    264,  -2652,    696,  -3084,    264,    264,    696, &
                   696,   -816,    210,     -6,     -6,    183,    183,     21,    156,  -2004,     -6,   -546,    372,   -222, &
                    21,    -33,    210,    156,    399,    102,  -3030,    210,  -1140,    210,   -195,  -1950,    210,  -1518, &
                    -6,    -60,    372,    -33,    156,    372,     -6,    183,  -1140,    210,     21,    210,    210,  -1302, &
                 -1302,    588,  -1140,    156,    264,    156,     -6,    -60]
  K1( 845,:) = [   1533,   -168,   1560,   -168,   1560,   1533,   -195,     48,   1749,     -6,    480,     -6,   -141,   -168, &
                  1344,   -168,    264,   -141,     48,   -222,   -168,   -168,     21,   -141,   -222,    264,     48,    264, &
                    48,   -222,     48,   -195,   -195,     -6,     -6,     -6,   -195,     21,   -114,   -168,    -33,   -141, &
                 -1464,    210,   1533,   -168,    210,   -141,     21,     21,     21,    210,    210,    -33,    210,    210, &
                   -33,    156,  -1302,    399,     21,    210,    210,  -1302,  -1302,    588,  -1302,    156,    588,    102, &
                   399,    102,   -141,   1533,   -357,    318,   -222,   -141,    534,   -222,   -114,   -168,    210,   1560, &
                  3072,   -384,   -384,     48,     48,    480,    210,   -195,    156,     48,   1344,   -168,  -1464,    210, &
                    21,     21,    -33,   -195,    912,    156,   -222,    264,    156,    534,   1749,   -195,     -6,     -6, &
                    48,    480,    210,     48,    156,   -195,   -357,    318]
  K1( 846,:) = [  -1950,   -195,   -168,   1506,   1533, -12291,    210,     21,  -1302,    588,    210,  -1302,     21,     -6, &
                 -1896,  -1464,  -2004,    264,   -222,   1506,     48,    237,     -6,   -168,    -60,     -6,    264,   -492, &
                  -222,   1506,    210,     21,    156,    102,    -33,    399,    -33,    183,     48,    237,    372,   -222, &
                   210,     -6,   -195,   -249,  -1518,   1533,    -60,     -6,    372,   -168,    -60,    372,   -600,    -60, &
                   318,    264,    372,  -3084,  -3084,    264,    264,    696,    696,   -816,    372,    318,   -168,    264, &
                 -2652,    696,    210,  -1518,     -6,    -60,    372,    -33,    156,    372,     -6,    183,  -1140,    210, &
                    21,    210,    210,  -1302,  -1302,    588,  -1140,    156,    264,    156,     -6,    -60,    210,     -6, &
                    -6,    183,    183,     21,    156,  -2004,     -6,   -546,    372,   -222,     21,    -33,    210,    156, &
                   399,    102,  -3030,    210,  -1140,    210,   -195,  -1950]
  K1( 847,:) = [   -168,    264,     48,     21,   -195,    210,   1560,     48,     48,  -1464,  -1464,    912,    480,    210, &
                  -168,     21,  -1302,   1749,     -6,  -1302,   1533,   -222,    588,     -6,   1533,   -222,   -195,     21, &
                    48,    210,   1560,     48,   -141,   -141,   -195,    534,   1749,     21,   1344,   -357,     21,   3072, &
                  -195,    -33,   -114,   -114,    210,   -384,   1533,   -222,   -222,    210,    210,    156,   -168,    264, &
                  -168,   1533,     21,   -222,     21,    -33,    264,   -222,    210,    210,    210,    156,    -33,    210, &
                   156,    156,     -6,    -33,   -168,     21,    156,   -195,     -6,    210,   -168,    318,    210,   -384, &
                  -141,   -195,   -141,   -141,     48,   -195,    399,     48,  -1302,     48,   -357,   1344,     -6,    399, &
                  -168,    264,    102,     -6,     -6,    156,   -168,   -168,  -1302,     48,   -141,    534,   -141,   1560, &
                  -195,     48,    102,    480,    588,    480,    318,   -168]
  K1( 848,:) = [    264,   -168,   -195,    210,     48,     21,     48,   1560,  -1464,    912,     48,  -1464,     -6,  -1302, &
                  1533,   -222,    588,     -6,    480,    210,   -168,     21,  -1302,   1749,   -222,   1533,     48,    210, &
                  -195,     21,     48,   1560,   -195,    534,   -141,   -141,   -195,    -33,   -114,   -114,    210,   -384, &
                  1749,     21,   1344,   -357,     21,   3072,   -222,   1533,    210,    156,   -222,    210,    264,   -168, &
                    21,   -222,   -168,   1533,    210,    156,    -33,    210,    156,    156,     21,    -33,    264,   -222, &
                   210,    210,     -6,    399,   -168,    264,    102,     -6,     -6,    156,   -168,   -168,  -1302,     48, &
                  -141,    534,   -141,   1560,   -195,     48,    102,    480,    588,    480,    318,   -168,     -6,    -33, &
                  -168,     21,    156,   -195,     -6,    210,   -168,    318,    210,   -384,   -141,   -195,   -141,   -141, &
                    48,   -195,    399,     48,  -1302,     48,   -357,   1344]
  K1( 849,:) = [   -168,     21,    480,    210,   1749,  -1302,     48,  -1464,   1560,     48,    912,  -1464,     48,     21, &
                  -168,    264,    210,   -195,     -6,    588,   -222,   1533,  -1302,     -6,   -168,     21,     -6,    -33, &
                  -195,    156,   -141,   -195,   -141,   -141,     48,   -195,     -6,    210,   -168,    318,    210,   -384, &
                    48,    399,   -357,   1344,  -1302,     48,   -222,    210,   1533,   -222,    156,    210,     21,    -33, &
                   264,   -222,    210,    210,   -168,    264,   -168,   1533,     21,   -222,    156,    210,    156,    156, &
                   -33,    210,   -195,     21,   1533,   -222,    210,     48,   1749,     21,   1344,   -357,     21,   3072, &
                  1560,     48,   -141,   -141,   -195,    534,    -33,   -195,    210,   -384,   -114,   -114,     -6,    102, &
                   264,   -168,    399,     -6,    480,    102,    318,   -168,    588,    480,    534,   -141,   -195,     48, &
                  -141,   1560,    156,     -6,  -1302,     48,   -168,   -168]
  K1( 850,:) = [   1533,   -222,     -6,  -1302,     -6,    588,  -1464,    912,     48,   1560,  -1464,     48,   -195,    210, &
                   264,   -168,     21,     48,   1749,  -1302,     21,   -168,    210,    480,   -168,    264,     -6,    399, &
                    -6,    102,   -141,    534,   -141,   1560,   -195,     48,     -6,    156,   -168,   -168,  -1302,     48, &
                   480,    102,    318,   -168,    588,    480,    210,    156,   -222,   1533,    210,   -222,    210,    156, &
                   -33,    210,    156,    156,    264,   -168,     21,   -222,   -168,   1533,    -33,     21,    210,    210, &
                   264,   -222,     48,    210,   -222,   1533,     21,   -195,   -195,    -33,   -114,   -114,    210,   -384, &
                    48,   1560,   -195,    534,   -141,   -141,     21,   1749,     21,   3072,   1344,   -357,   -195,    156, &
                    21,   -168,    -33,     -6,     48,    399,   -357,   1344,  -1302,     48,   -195,   -141,     48,   -195, &
                  -141,   -141,    210,     -6,    210,   -384,   -168,    318]
  K1( 851,:) = [     21,   -168,   1749,  -1302,    480,    210,  -1464,     48,    912,  -1464,   1560,     48,     -6,    588, &
                  -222,   1533,  -1302,     -6,     48,     21,   -168,    264,    210,   -195,     21,   -168,   -195,    156, &
                    -6,    -33,   -195,   -141,     48,   -195,   -141,   -141,     48,    399,   -357,   1344,  -1302,     48, &
                    -6,    210,   -168,    318,    210,   -384,    210,   -222,    156,    210,   1533,   -222,    -33,     21, &
                   210,    210,    264,   -222,    156,    210,    156,    156,    -33,    210,   -168,    264,   -168,   1533, &
                    21,   -222,     -6,    102,    264,   -168,    399,     -6,    480,    102,    318,   -168,    588,    480, &
                   534,   -141,   -195,     48,   -141,   1560,    156,     -6,  -1302,     48,   -168,   -168,   -195,     21, &
                  1533,   -222,    210,     48,   1749,     21,   1344,   -357,     21,   3072,   1560,     48,   -141,   -141, &
                  -195,    534,    -33,   -195,    210,   -384,   -114,   -114]
  K1( 852,:) = [   -222,   1533,     -6,    588,     -6,  -1302,    912,  -1464,  -1464,     48,     48,   1560,   1749,  -1302, &
                    21,   -168,    210,    480,   -195,    210,    264,   -168,     21,     48,    264,   -168,     -6,    102, &
                    -6,    399,    534,   -141,   -195,     48,   -141,   1560,    480,    102,    318,   -168,    588,    480, &
                    -6,    156,   -168,   -168,  -1302,     48,    156,    210,    210,   -222,   -222,   1533,    156,    210, &
                   156,    156,    -33,    210,    -33,     21,    210,    210,    264,   -222,    264,   -168,     21,   -222, &
                  -168,   1533,   -195,    156,     21,   -168,    -33,     -6,     48,    399,   -357,   1344,  -1302,     48, &
                  -195,   -141,     48,   -195,   -141,   -141,    210,     -6,    210,   -384,   -168,    318,     48,    210, &
                  -222,   1533,     21,   -195,   -195,    -33,   -114,   -114,    210,   -384,     48,   1560,   -195,    534, &
                  -141,   -141,     21,   1749,     21,   3072,   1344,   -357]
  K1( 853,:) = [   -168,   -168,     48,   -222,   -141,     21,    480,     -6,     48,   -195,     -6,   1749,   1560,   1533, &
                  -168,   1533,   -168,   1560,   -141,    264,   -168,   1344,   -168,   -141,     21,     21,  -1464,    210, &
                  -195,    -33,   1749,   -195,     -6,     -6,     48,    480,    912,    156,   -222,    264,    156,    534, &
                    48,    210,   -357,    318,    156,   -195,    210,    -33,     21,     21,    210,     21,  -1302,    156, &
                   588,    102,    399,    102,    210,    210,  -1302,    399,    -33,    156,    210,     21,  -1302,    588, &
                   210,  -1302,     48,   -222,    264,   -222,    264,     48,  -1464,    210,   1533,   -168,    210,   -141, &
                  -195,     48,     -6,     -6,   -195,     -6,     21,   -195,    -33,   -141,   -114,   -168,   -141,   -222, &
                   318,   -357,   1533,   -141,   -195,    210,   1344,   -168,    156,     48,   -384,   3072,     48,    480, &
                  -384,     48,   -222,    534,    210,   1560,   -114,   -168]
  K1( 854,:) = [     48,    237,   -222,   1506,   -168,     -6,    210,  -1302,     21,    210,    588,  -1302,   1533, -12291, &
                  -195,  -1950,   1506,   -168,    264,  -2004,  -1464,  -1896,     -6,     21,     -6,    183,    210,     -6, &
                    21,    183,     21,    -33,    210,    156,    399,    102,    156,  -2004,     -6,   -546,    372,   -222, &
                   210,  -3030,   -195,  -1950,  -1140,    210,    -60,    372,     -6,    -60,   -168,    372,    372,    318, &
                  -168,    264,  -2652,    696,    -60,   -600,    372,  -3084,    318,    264,    264,  -3084,    696,   -816, &
                   264,    696,   -222,   1506,     -6,    -60,   -492,    264,    210,     -6,   -195,   -249,  -1518,   1533, &
                    21,    210,    -33,    399,    156,    102,    183,    -33,    372,   -222,     48,    237,    -33,    372, &
                   -60,     -6,  -1518,    210,    156,  -1140,     -6,    -60,    264,    156,    210,     21,  -1302,    588, &
                   210,  -1302,    372,    156,  -1140,    210,     -6,    183]
  K1( 855,:) = [   -384,   -384,   -168,     48,   1344,  -1896,   -168,   1533,   -168,    264,   -222,     21,   -168,   -195, &
                  -384,  -1896,  -1950,   1533,   -168,  -1464,   1317,   -384,    237,   -168,   -384,    102,   1533,   -195, &
                  -114,     48,   1344,   -114,   -168,   -168,   -357,    318,   -222,     -6,   1317,   -384,     -6,   -114, &
                  -357,   -195,   2640,   -816,     -6,   1344,     48,   -195,   -195,     -6,     -6,     -6,  -1896,     48, &
                 -1464,    237,   -195,  -1950,  -1950,    -60,    237,   -249,    183,   -546,     -6,     -6,     -6,    -60, &
                   -60,    183,    264,     -6,  -1896,    480,    -60,   -222,     21,     -6,   -384,    102,     -6,   -357, &
                  1533,   -222,   -168,   -168,     21,    264,    183,     21,    -60,    318,    102,   -384,   -168,    237, &
                  -384,    102,   -249,   -168,    318,  -1950,   -816,   -384,    -60,   -168,   -114,   -357,   1344,   -168, &
                   318,   -168,   -546,    264,    183,   -168,   -384,   -384]
  K1( 856,:) = [   -384,   1317,   -168,    237,   -168,  -1464,     21,   -222,    264,   -168,   1533,   -168,   1533,  -1950, &
                 -1896,   -384,   -195,   -168,   1344,  -1896,   -384,   -384,     48,   -168,    102,   -384,   -168,   -249, &
                  -168,    237,   -357,   -114,    318,   -168,   1344,   -168,    264,   -546,   -384,   -384,    183,   -168, &
                   318,  -1950,   -816,   -384,    -60,   -168,     -6,     -6,     -6,   -195,   -195,     48,     -6,     -6, &
                   -60,    183,     -6,    -60,    -60,  -1950,    183,   -546,    237,   -249,     48,  -1896,   -195,  -1950, &
                 -1464,    237,   -222,    -60,    480,  -1896,     -6,    264,     21,    183,    102,   -384,    -60,    318, &
                  -222,   1533,     21,    264,   -168,   -168,     -6,     21,     -6,   -357,   -384,    102,   -114,     48, &
                   102,   -384,   -195,   1533,   -357,   -195,   2640,   -816,     -6,   1344,   -114,   1344,   -357,    318, &
                  -168,   -168,     -6,   -222,     -6,   -114,   1317,   -384]
  K1( 857,:) = [  -1896,  -1464,     21,     -6,    264,  -2004,  -1302,    588,    210,     21,  -1302,    210,   -168,   1506, &
                 -1950,   -195, -12291,   1533,   -168,     -6,    237,     48,   1506,   -222,     -6,    -60,    210,  -1518, &
                   -33,    372,     21,    210,    210,  -1302,  -1302,    588,    156,    372,     -6,    183,  -1140,    210, &
                   156,  -1140,     -6,    -60,    264,    156,    372,   -168,    -60,     -6,    372,    -60,  -3084,    264, &
                   264,    696,    696,   -816,   -600,    -60,    318,    264,    372,  -3084,    318,    372,  -2652,    696, &
                  -168,    264,    264,   -492,    -60,     -6,   1506,   -222,    -33,    183,     48,    237,    372,   -222, &
                   210,     21,    156,    102,    -33,    399,     -6,    210,  -1518,   1533,   -195,   -249,     21,    183, &
                   183,     -6,     -6,    210,    210,  -3030,   -195,  -1950,  -1140,    210,    -33,     21,    399,    102, &
                   210,    156,  -2004,    156,    372,   -222,     -6,   -546]
  K1( 858,:) = [   1344,   -168,   -141,   -168,   -141,    264,   1749,     -6,   -195,     48,     -6,    480,   1560,   -168, &
                  1533,   -168,   1533,   1560,   -141,     21,   -168,   -168,   -222,     48,   -357,    318,   -141,   1533, &
                  -141,   -222,   3072,   -384,   -384,     48,     48,    480,    534,   -222,   -114,   -168,    210,   1560, &
                  -195,    210,   1344,   -168,    156,     48,     21,    210,     21,     21,    -33,    210,     21,    210, &
                   210,  -1302,  -1302,    588,    210,    210,    -33,    156,  -1302,    399,    156,  -1302,    399,    102, &
                   588,    102,     48,    264,   -222,    264,   -222,     48,   -195,     21,   -114,   -168,    -33,   -141, &
                    48,   -195,   -195,     -6,     -6,     -6,    210,  -1464,    210,   -141,   1533,   -168,   -195,    -33, &
                    21,     21,    210,  -1464,     48,    210,   -357,    318,    156,   -195,   -195,   1749,     48,    480, &
                    -6,     -6,    156,    912,    156,    534,   -222,    264]
  K1( 859,:) = [   -168,   -168,   -141,     21,     48,   -222,     -6,    480,     -6,   1749,     48,   -195,   -141,    264, &
                  -168,   1344,   -168,   -141,   1560,   1533,   -168,   1533,   -168,   1560,     21,     21,   -195,    -33, &
                 -1464,    210,   -195,   1749,     48,    480,     -6,     -6,     48,    210,   -357,    318,    156,   -195, &
                   912,    156,   -222,    264,    156,    534,    -33,    210,    210,     21,     21,     21,    156,  -1302, &
                   399,    102,    588,    102,    210,     21,  -1302,    588,    210,  -1302,    210,    210,  -1302,    399, &
                   -33,    156,   -141,   -222,    318,   -357,   1533,   -141,   -195,    210,   1344,   -168,    156,     48, &
                  -384,   3072,     48,    480,   -384,     48,   -222,    534,    210,   1560,   -114,   -168,     48,   -222, &
                   264,   -222,    264,     48,  -1464,    210,   1533,   -168,    210,   -141,   -195,     48,     -6,     -6, &
                  -195,     -6,     21,   -195,    -33,   -141,   -114,   -168]
  K1( 860,:) = [    237,     48,   -168,     -6,   -222,   1506,  -1302,    210,    588,  -1302,     21,    210,    264,  -2004, &
                 -1464,  -1896,     -6,     21,   1533, -12291,   -195,  -1950,   1506,   -168,    183,     -6,     21,    183, &
                   210,     -6,    -33,     21,    399,    102,    210,    156,    210,  -3030,   -195,  -1950,  -1140,    210, &
                   156,  -2004,     -6,   -546,    372,   -222,    372,    -60,   -168,    372,     -6,    -60,    318,    372, &
                 -2652,    696,   -168,    264,    264,  -3084,    696,   -816,    264,    696,    -60,   -600,    372,  -3084, &
                   318,    264,    -33,    372,    -60,     -6,  -1518,    210,    156,  -1140,     -6,    -60,    264,    156, &
                   210,     21,  -1302,    588,    210,  -1302,    372,    156,  -1140,    210,     -6,    183,   -222,   1506, &
                    -6,    -60,   -492,    264,    210,     -6,   -195,   -249,  -1518,   1533,     21,    210,    -33,    399, &
                   156,    102,    183,    -33,    372,   -222,     48,    237]
  K1( 861,:) = [   -384,   -384,   1344,  -1896,   -168,     48,   1533,   -168,   -222,     21,   -168,    264,   -168,  -1464, &
                  1317,   -384,    237,   -168,   -168,   -195,   -384,  -1896,  -1950,   1533,    102,   -384,   -114,     48, &
                  1533,   -195,   -114,   1344,   -357,    318,   -168,   -168,   -357,   -195,   2640,   -816,     -6,   1344, &
                  -222,     -6,   1317,   -384,     -6,   -114,   -195,     48,     -6,     -6,   -195,     -6,     48,  -1896, &
                  -195,  -1950,  -1464,    237,     -6,     -6,     -6,    -60,    -60,    183,  -1950,    -60,    237,   -249, &
                   183,   -546,   -168,    237,   -384,    102,   -249,   -168,    318,  -1950,   -816,   -384,    -60,   -168, &
                  -114,   -357,   1344,   -168,    318,   -168,   -546,    264,    183,   -168,   -384,   -384,    264,     -6, &
                 -1896,    480,    -60,   -222,     21,     -6,   -384,    102,     -6,   -357,   1533,   -222,   -168,   -168, &
                    21,    264,    183,     21,    -60,    318,    102,   -384]
  K1( 862,:) = [   1317,   -384,   -168,  -1464,   -168,    237,   -222,     21,   1533,   -168,    264,   -168,   1344,  -1896, &
                  -384,   -384,     48,   -168,   1533,  -1950,  -1896,   -384,   -195,   -168,   -384,    102,   -168,    237, &
                  -168,   -249,   -114,   -357,   1344,   -168,    318,   -168,    318,  -1950,   -816,   -384,    -60,   -168, &
                   264,   -546,   -384,   -384,    183,   -168,     -6,     -6,   -195,     48,     -6,   -195,     -6,     -6, &
                    -6,    -60,    -60,    183,     48,  -1896,   -195,  -1950,  -1464,    237,    -60,  -1950,    183,   -546, &
                   237,   -249,   -114,     48,    102,   -384,   -195,   1533,   -357,   -195,   2640,   -816,     -6,   1344, &
                  -114,   1344,   -357,    318,   -168,   -168,     -6,   -222,     -6,   -114,   1317,   -384,   -222,    -60, &
                   480,  -1896,     -6,    264,     21,    183,    102,   -384,    -60,    318,   -222,   1533,     21,    264, &
                  -168,   -168,     -6,     21,     -6,   -357,   -384,    102]
  K1( 863,:) = [  -1464,  -1896,    264,  -2004,     21,     -6,    588,  -1302,  -1302,    210,    210,     21,   -168,     -6, &
                   237,     48,   1506,   -222,   -168,   1506,  -1950,   -195, -12291,   1533,    -60,     -6,    -33,    372, &
                   210,  -1518,    210,     21,  -1302,    588,    210,  -1302,    156,  -1140,     -6,    -60,    264,    156, &
                   156,    372,     -6,    183,  -1140,    210,   -168,    372,    372,    -60,    -60,     -6,    264,  -3084, &
                   696,   -816,    264,    696,    318,    372,  -2652,    696,   -168,    264,   -600,    -60,    318,    264, &
                   372,  -3084,     21,    183,    183,     -6,     -6,    210,    210,  -3030,   -195,  -1950,  -1140,    210, &
                   -33,     21,    399,    102,    210,    156,  -2004,    156,    372,   -222,     -6,   -546,    264,   -492, &
                   -60,     -6,   1506,   -222,    -33,    183,     48,    237,    372,   -222,    210,     21,    156,    102, &
                   -33,    399,     -6,    210,  -1518,   1533,   -195,   -249]
  K1( 864,:) = [   -168,   1344,   -141,    264,   -141,   -168,     -6,   1749,     -6,    480,   -195,     48,   -141,     21, &
                  -168,   -168,   -222,     48,   1560,   -168,   1533,   -168,   1533,   1560,    318,   -357,   -141,   -222, &
                  -141,   1533,   -384,   3072,     48,    480,   -384,     48,   -195,    210,   1344,   -168,    156,     48, &
                   534,   -222,   -114,   -168,    210,   1560,    210,     21,    -33,    210,     21,     21,    210,     21, &
                 -1302,    588,    210,  -1302,    156,  -1302,    399,    102,    588,    102,    210,    210,    -33,    156, &
                 -1302,    399,   -195,    -33,     21,     21,    210,  -1464,     48,    210,   -357,    318,    156,   -195, &
                  -195,   1749,     48,    480,     -6,     -6,    156,    912,    156,    534,   -222,    264,     48,    264, &
                  -222,    264,   -222,     48,   -195,     21,   -114,   -168,    -33,   -141,     48,   -195,   -195,     -6, &
                    -6,     -6,    210,  -1464,    210,   -141,   1533,   -168]
  K1( 865,:) = [  -1896,    480,    264,     -6,   -222,    -60,   1533,   -222,   -168,   -168,     21,    264,     21,     -6, &
                  -384,    102,     -6,   -357,     21,    183,    102,   -384,    -60,    318,   -384,  -1896,   -168,   -195, &
                  1533,  -1950,   -168,    264,   -168,   1533,     21,   -222,   -168,     48,   -384,   -384,  -1896,   1344, &
                  -168,    237,   -384,   1317,  -1464,   -168,  -1950,    -60,    237,   -249,    183,   -546,   -195,     -6, &
                    48,   -195,     -6,     -6,  -1464,    237,  -1896,     48,  -1950,   -195,    -60,    183,     -6,     -6, &
                   -60,     -6,   -222,     -6,   1317,   -384,     -6,   -114,   1533,   -195,   -384,    102,     48,   -114, &
                  -168,   -168,   1344,   -114,    318,   -357,     -6,   1344,   -195,   -357,   -816,   2640,    264,   -546, &
                  -384,   -384,    183,   -168,   -168,   -249,    102,   -384,    237,   -168,    318,   -168,   -357,   -114, &
                  -168,   1344,    -60,   -168,  -1950,    318,   -384,   -816]
  K1( 866,:) = [    480,  -1896,   -222,    -60,    264,     -6,   -222,   1533,     21,    264,   -168,   -168,     21,    183, &
                   102,   -384,    -60,    318,     21,     -6,   -384,    102,     -6,   -357,  -1896,   -384,   1533,  -1950, &
                  -168,   -195,    264,   -168,     21,   -222,   -168,   1533,   -168,    237,   -384,   1317,  -1464,   -168, &
                  -168,     48,   -384,   -384,  -1896,   1344,    -60,  -1950,    183,   -546,    237,   -249,     -6,   -195, &
                    -6,     -6,     48,   -195,    -60,    183,     -6,     -6,    -60,     -6,  -1464,    237,  -1896,     48, &
                 -1950,   -195,    264,   -546,   -384,   -384,    183,   -168,   -168,   -249,    102,   -384,    237,   -168, &
                   318,   -168,   -357,   -114,   -168,   1344,    -60,   -168,  -1950,    318,   -384,   -816,   -222,     -6, &
                  1317,   -384,     -6,   -114,   1533,   -195,   -384,    102,     48,   -114,   -168,   -168,   1344,   -114, &
                   318,   -357,     -6,   1344,   -195,   -357,   -816,   2640]
  K1( 867,:) = [    264,   -222,     48,   -222,     48,    264,   -195,     48,     -6,     -6,   -195,     -6,  -1464,    210, &
                  1533,   -168,    210,   -141,   -195,     21,   -114,   -168,    -33,   -141,   -168,   1533,   1560,   1533, &
                  1560,   -168,     48,   -195,    480,     -6,   1749,     -6,     48,   -222,   -168,   -168,     21,   -141, &
                  -141,   -168,   1344,   -168,    264,   -141,    210,    210,  -1302,    399,    -33,    156,     21,     21, &
                   210,    -33,     21,    210,    588,    102,  -1302,    156,    102,    399,    210,  -1302,     21,    210, &
                   588,  -1302,    912,    156,   -222,    264,    156,    534,  -1464,    210,     21,     21,    -33,   -195, &
                    -6,     -6,   1749,   -195,    480,     48,    156,   -195,    210,     48,    318,   -357,    534,   -222, &
                  -114,   -168,    210,   1560,   -141,   1533,   -357,    318,   -222,   -141,   -384,     48,   3072,   -384, &
                   480,     48,    156,     48,    210,   -195,   -168,   1344]
  K1( 868,:) = [     -6,    -60,   -222,   1506,    264,   -492,     21,    210,    -33,    399,    156,    102,    210,     -6, &
                  -195,   -249,  -1518,   1533,    -33,    183,     48,    237,    372,   -222,   -195,  -1950,   1533, -12291, &
                  -168,   1506,     21,    210,    210,  -1302,  -1302,    588,   -222,   1506,     48,    237,     -6,   -168, &
                    21,     -6,  -1896,  -1464,  -2004,    264,    -60,   -600,    372,  -3084,    318,    264,     -6,    -60, &
                   -60,    372,    372,   -168,   -168,    264,    372,    318,    696,  -2652,    264,    696,  -3084,    264, &
                  -816,    696,    156,  -2004,     -6,   -546,    372,   -222,    210,     -6,     -6,    183,    183,     21, &
                   210,    156,     21,    -33,    102,    399,  -1140,    210,  -3030,    210,  -1950,   -195,    156,    372, &
                    -6,    183,  -1140,    210,    210,  -1518,     -6,    -60,    372,    -33,    210,  -1302,     21,    210, &
                   588,  -1302,    264,    156,  -1140,    156,    -60,     -6]
  K1( 869,:) = [   -222,    264,     48,    264,     48,   -222,     48,   -195,   -195,     -6,     -6,     -6,   -195,     21, &
                  -114,   -168,    -33,   -141,  -1464,    210,   1533,   -168,    210,   -141,   1533,   -168,   1560,   -168, &
                  1560,   1533,   -195,     48,   1749,     -6,    480,     -6,   -141,   -168,   1344,   -168,    264,   -141, &
                    48,   -222,   -168,   -168,     21,   -141,    210,    210,    -33,    156,  -1302,    399,     21,     21, &
                    21,    210,    210,    -33,    210,  -1302,     21,    210,    588,  -1302,    588,    102,  -1302,    156, &
                   102,    399,    534,   -222,   -114,   -168,    210,   1560,   -141,   1533,   -357,    318,   -222,   -141, &
                  -384,     48,   3072,   -384,    480,     48,    156,     48,    210,   -195,   -168,   1344,    912,    156, &
                  -222,    264,    156,    534,  -1464,    210,     21,     21,    -33,   -195,     -6,     -6,   1749,   -195, &
                   480,     48,    156,   -195,    210,     48,    318,   -357]
  K1( 870,:) = [    -60,     -6,    264,   -492,   -222,   1506,    210,     21,    156,    102,    -33,    399,    -33,    183, &
                    48,    237,    372,   -222,    210,     -6,   -195,   -249,  -1518,   1533,  -1950,   -195,   -168,   1506, &
                  1533, -12291,    210,     21,  -1302,    588,    210,  -1302,     21,     -6,  -1896,  -1464,  -2004,    264, &
                  -222,   1506,     48,    237,     -6,   -168,   -600,    -60,    318,    264,    372,  -3084,    -60,     -6, &
                   372,   -168,    -60,    372,    264,    696,  -3084,    264,   -816,    696,   -168,    264,    372,    318, &
                   696,  -2652,    156,    372,     -6,    183,  -1140,    210,    210,  -1518,     -6,    -60,    372,    -33, &
                   210,  -1302,     21,    210,    588,  -1302,    264,    156,  -1140,    156,    -60,     -6,    156,  -2004, &
                    -6,   -546,    372,   -222,    210,     -6,     -6,    183,    183,     21,    210,    156,     21,    -33, &
                   102,    399,  -1140,    210,  -3030,    210,  -1950,   -195]
  K1( 871,:) = [   1533,   -222,   -195,     21,     48,    210,   1560,     48,   -141,   -141,   -195,    534,   1749,     21, &
                  1344,   -357,     21,   3072,   -195,    -33,   -114,   -114,    210,   -384,   -168,    264,     48,     21, &
                  -195,    210,   1560,     48,     48,  -1464,  -1464,    912,    480,    210,   -168,     21,  -1302,   1749, &
                    -6,  -1302,   1533,   -222,    588,     -6,   -168,    264,   -168,   1533,     21,   -222,   1533,   -222, &
                  -222,    210,    210,    156,    264,   -222,     21,    -33,    210,    210,    -33,    210,    210,    156, &
                   156,    156,     -6,    210,   -168,    318,    210,   -384,     -6,    -33,   -168,     21,    156,   -195, &
                  -141,   -141,   -141,   -195,   -195,     48,  -1302,     48,    399,     48,   1344,   -357,     -6,    156, &
                  -168,   -168,  -1302,     48,     -6,    399,   -168,    264,    102,     -6,   -141,   1560,   -141,    534, &
                    48,   -195,    588,    480,    102,    480,   -168,    318]
  K1( 872,:) = [   -222,   1533,     48,    210,   -195,     21,     48,   1560,   -195,    534,   -141,   -141,   -195,    -33, &
                  -114,   -114,    210,   -384,   1749,     21,   1344,   -357,     21,   3072,    264,   -168,   -195,    210, &
                    48,     21,     48,   1560,  -1464,    912,     48,  -1464,     -6,  -1302,   1533,   -222,    588,     -6, &
                   480,    210,   -168,     21,  -1302,   1749,    264,   -168,     21,   -222,   -168,   1533,   -222,   1533, &
                   210,    156,   -222,    210,    -33,    210,    210,    156,    156,    156,    264,   -222,     21,    -33, &
                   210,    210,     -6,    156,   -168,   -168,  -1302,     48,     -6,    399,   -168,    264,    102,     -6, &
                  -141,   1560,   -141,    534,     48,   -195,    588,    480,    102,    480,   -168,    318,     -6,    210, &
                  -168,    318,    210,   -384,     -6,    -33,   -168,     21,    156,   -195,   -141,   -141,   -141,   -195, &
                  -195,     48,  -1302,     48,    399,     48,   1344,   -357]
  K1( 873,:) = [   -168,     21,     -6,    -33,   -195,    156,   -141,   -195,   -141,   -141,     48,   -195,     -6,    210, &
                  -168,    318,    210,   -384,     48,    399,   -357,   1344,  -1302,     48,   -168,     21,    480,    210, &
                  1749,  -1302,     48,  -1464,   1560,     48,    912,  -1464,     48,     21,   -168,    264,    210,   -195, &
                    -6,    588,   -222,   1533,  -1302,     -6,     21,    -33,    264,   -222,    210,    210,   -222,    210, &
                  1533,   -222,    156,    210,   -168,   1533,   -168,    264,   -222,     21,    156,    156,    156,    210, &
                   210,    -33,   1749,     21,   1344,   -357,     21,   3072,   -195,     21,   1533,   -222,    210,     48, &
                  -141,   -141,   1560,     48,    534,   -195,    210,   -384,    -33,   -195,   -114,   -114,    480,    102, &
                   318,   -168,    588,    480,     -6,    102,    264,   -168,    399,     -6,   -195,     48,    534,   -141, &
                  1560,   -141,  -1302,     48,    156,     -6,   -168,   -168]
  K1( 874,:) = [   -168,    264,     -6,    399,     -6,    102,   -141,    534,   -141,   1560,   -195,     48,     -6,    156, &
                  -168,   -168,  -1302,     48,    480,    102,    318,   -168,    588,    480,   1533,   -222,     -6,  -1302, &
                    -6,    588,  -1464,    912,     48,   1560,  -1464,     48,   -195,    210,    264,   -168,     21,     48, &
                  1749,  -1302,     21,   -168,    210,    480,    210,    156,    -33,    210,    156,    156,    210,    156, &
                  -222,   1533,    210,   -222,     21,   -222,    264,   -168,   1533,   -168,    210,    210,    -33,     21, &
                  -222,    264,   -195,    -33,   -114,   -114,    210,   -384,     48,    210,   -222,   1533,     21,   -195, &
                  -195,    534,     48,   1560,   -141,   -141,     21,   3072,     21,   1749,   -357,   1344,     48,    399, &
                  -357,   1344,  -1302,     48,   -195,    156,     21,   -168,    -33,     -6,     48,   -195,   -195,   -141, &
                  -141,   -141,    210,   -384,    210,     -6,    318,   -168]
  K1( 875,:) = [     21,   -168,   -195,    156,     -6,    -33,   -195,   -141,     48,   -195,   -141,   -141,     48,    399, &
                  -357,   1344,  -1302,     48,     -6,    210,   -168,    318,    210,   -384,     21,   -168,   1749,  -1302, &
                   480,    210,  -1464,     48,    912,  -1464,   1560,     48,     -6,    588,   -222,   1533,  -1302,     -6, &
                    48,     21,   -168,    264,    210,   -195,    -33,     21,    210,    210,    264,   -222,    210,   -222, &
                   156,    210,   1533,   -222,    156,    156,    156,    210,    210,    -33,   -168,   1533,   -168,    264, &
                  -222,     21,    480,    102,    318,   -168,    588,    480,     -6,    102,    264,   -168,    399,     -6, &
                  -195,     48,    534,   -141,   1560,   -141,  -1302,     48,    156,     -6,   -168,   -168,   1749,     21, &
                  1344,   -357,     21,   3072,   -195,     21,   1533,   -222,    210,     48,   -141,   -141,   1560,     48, &
                   534,   -195,    210,   -384,    -33,   -195,   -114,   -114]
  K1( 876,:) = [    264,   -168,     -6,    102,     -6,    399,    534,   -141,   -195,     48,   -141,   1560,    480,    102, &
                   318,   -168,    588,    480,     -6,    156,   -168,   -168,  -1302,     48,   -222,   1533,     -6,    588, &
                    -6,  -1302,    912,  -1464,  -1464,     48,     48,   1560,   1749,  -1302,     21,   -168,    210,    480, &
                  -195,    210,    264,   -168,     21,     48,    156,    210,    156,    156,    -33,    210,    156,    210, &
                   210,   -222,   -222,   1533,    210,    210,    -33,     21,   -222,    264,     21,   -222,    264,   -168, &
                  1533,   -168,     48,    399,   -357,   1344,  -1302,     48,   -195,    156,     21,   -168,    -33,     -6, &
                    48,   -195,   -195,   -141,   -141,   -141,    210,   -384,    210,     -6,    318,   -168,   -195,    -33, &
                  -114,   -114,    210,   -384,     48,    210,   -222,   1533,     21,   -195,   -195,    534,     48,   1560, &
                  -141,   -141,     21,   3072,     21,   1749,   -357,   1344]
  K1( 877,:) = [     21,     21,  -1464,    210,   -195,    -33,   1749,   -195,     -6,     -6,     48,    480,    912,    156, &
                  -222,    264,    156,    534,     48,    210,   -357,    318,    156,   -195,   -168,   -168,     48,   -222, &
                  -141,     21,    480,     -6,     48,   -195,     -6,   1749,   1560,   1533,   -168,   1533,   -168,   1560, &
                  -141,    264,   -168,   1344,   -168,   -141,  -1302,    156,    588,    102,    399,    102,    210,    -33, &
                    21,     21,    210,     21,  -1302,    399,    210,    210,    156,    -33,  -1302,    588,    210,     21, &
                 -1302,    210,  -1464,    210,   1533,   -168,    210,   -141,     48,   -222,    264,   -222,    264,     48, &
                    -6,     -6,   -195,     48,     -6,   -195,    -33,   -141,     21,   -195,   -168,   -114,   -195,    210, &
                  1344,   -168,    156,     48,   -141,   -222,    318,   -357,   1533,   -141,     48,    480,   -384,   3072, &
                    48,   -384,    210,   1560,   -222,    534,   -168,   -114]
  K1( 878,:) = [     -6,    183,    210,     -6,     21,    183,     21,    -33,    210,    156,    399,    102,    156,  -2004, &
                    -6,   -546,    372,   -222,    210,  -3030,   -195,  -1950,  -1140,    210,     48,    237,   -222,   1506, &
                  -168,     -6,    210,  -1302,     21,    210,    588,  -1302,   1533, -12291,   -195,  -1950,   1506,   -168, &
                   264,  -2004,  -1464,  -1896,     -6,     21,    372,    318,   -168,    264,  -2652,    696,    -60,    372, &
                    -6,    -60,   -168,    372,    372,  -3084,    -60,   -600,    264,    318,    696,   -816,    264,  -3084, &
                   696,    264,    210,     -6,   -195,   -249,  -1518,   1533,   -222,   1506,     -6,    -60,   -492,    264, &
                   -33,    399,     21,    210,    102,    156,    372,   -222,    183,    -33,    237,     48,    156,  -1140, &
                    -6,    -60,    264,    156,    -33,    372,    -60,     -6,  -1518,    210,  -1302,    588,    210,     21, &
                 -1302,    210,  -1140,    210,    372,    156,    183,     -6]
  K1( 879,:) = [   -384,    102,   1533,   -195,   -114,     48,   1344,   -114,   -168,   -168,   -357,    318,   -222,     -6, &
                  1317,   -384,     -6,   -114,   -357,   -195,   2640,   -816,     -6,   1344,   -384,   -384,   -168,     48, &
                  1344,  -1896,   -168,   1533,   -168,    264,   -222,     21,   -168,   -195,   -384,  -1896,  -1950,   1533, &
                  -168,  -1464,   1317,   -384,    237,   -168,  -1896,     48,  -1464,    237,   -195,  -1950,     48,   -195, &
                  -195,     -6,     -6,     -6,    237,   -249,  -1950,    -60,   -546,    183,     -6,    -60,     -6,     -6, &
                   183,    -60,     21,     -6,   -384,    102,     -6,   -357,    264,     -6,  -1896,    480,    -60,   -222, &
                  -168,   -168,   1533,   -222,    264,     21,    -60,    318,    183,     21,   -384,    102,    318,  -1950, &
                  -816,   -384,    -60,   -168,   -168,    237,   -384,    102,   -249,   -168,   1344,   -168,   -114,   -357, &
                  -168,    318,    183,   -168,   -546,    264,   -384,   -384]
  K1( 880,:) = [    102,   -384,   -168,   -249,   -168,    237,   -357,   -114,    318,   -168,   1344,   -168,    264,   -546, &
                  -384,   -384,    183,   -168,    318,  -1950,   -816,   -384,    -60,   -168,   -384,   1317,   -168,    237, &
                  -168,  -1464,     21,   -222,    264,   -168,   1533,   -168,   1533,  -1950,  -1896,   -384,   -195,   -168, &
                  1344,  -1896,   -384,   -384,     48,   -168,     -6,     -6,    -60,    183,     -6,    -60,     -6,     -6, &
                    -6,   -195,   -195,     48,    183,   -546,    -60,  -1950,   -249,    237,   -195,  -1950,     48,  -1896, &
                   237,  -1464,     21,    183,    102,   -384,    -60,    318,   -222,    -60,    480,  -1896,     -6,    264, &
                    21,    264,   -222,   1533,   -168,   -168,     -6,   -357,     -6,     21,    102,   -384,   -357,   -195, &
                  2640,   -816,     -6,   1344,   -114,     48,    102,   -384,   -195,   1533,   -357,    318,   -114,   1344, &
                  -168,   -168,     -6,   -114,     -6,   -222,   -384,   1317]
  K1( 881,:) = [     -6,    -60,    210,  -1518,    -33,    372,     21,    210,    210,  -1302,  -1302,    588,    156,    372, &
                    -6,    183,  -1140,    210,    156,  -1140,     -6,    -60,    264,    156,  -1896,  -1464,     21,     -6, &
                   264,  -2004,  -1302,    588,    210,     21,  -1302,    210,   -168,   1506,  -1950,   -195, -12291,   1533, &
                  -168,     -6,    237,     48,   1506,   -222,  -3084,    264,    264,    696,    696,   -816,    372,   -168, &
                   -60,     -6,    372,    -60,    318,    264,   -600,    -60,  -3084,    372,  -2652,    696,    318,    372, &
                   264,   -168,    -33,    183,     48,    237,    372,   -222,    264,   -492,    -60,     -6,   1506,   -222, &
                   156,    102,    210,     21,    399,    -33,  -1518,   1533,     -6,    210,   -249,   -195,    210,  -3030, &
                  -195,  -1950,  -1140,    210,     21,    183,    183,     -6,     -6,    210,    399,    102,    -33,     21, &
                   156,    210,    372,   -222,  -2004,    156,   -546,     -6]
  K1( 882,:) = [   -357,    318,   -141,   1533,   -141,   -222,   3072,   -384,   -384,     48,     48,    480,    534,   -222, &
                  -114,   -168,    210,   1560,   -195,    210,   1344,   -168,    156,     48,   1344,   -168,   -141,   -168, &
                  -141,    264,   1749,     -6,   -195,     48,     -6,    480,   1560,   -168,   1533,   -168,   1533,   1560, &
                  -141,     21,   -168,   -168,   -222,     48,     21,    210,    210,  -1302,  -1302,    588,     21,    210, &
                    21,     21,    -33,    210,    -33,    156,    210,    210,    399,  -1302,    399,    102,    156,  -1302, &
                   102,    588,   -195,     21,   -114,   -168,    -33,   -141,     48,    264,   -222,    264,   -222,     48, &
                  -195,     -6,     48,   -195,     -6,     -6,    210,   -141,    210,  -1464,   -168,   1533,     48,    210, &
                  -357,    318,    156,   -195,   -195,    -33,     21,     21,    210,  -1464,     48,    480,   -195,   1749, &
                    -6,     -6,    156,    534,    156,    912,    264,   -222]
  K1( 883,:) = [     21,     21,   -195,    -33,  -1464,    210,   -195,   1749,     48,    480,     -6,     -6,     48,    210, &
                  -357,    318,    156,   -195,    912,    156,   -222,    264,    156,    534,   -168,   -168,   -141,     21, &
                    48,   -222,     -6,    480,     -6,   1749,     48,   -195,   -141,    264,   -168,   1344,   -168,   -141, &
                  1560,   1533,   -168,   1533,   -168,   1560,    156,  -1302,    399,    102,    588,    102,    -33,    210, &
                   210,     21,     21,     21,  -1302,    588,    210,     21,  -1302,    210,  -1302,    399,    210,    210, &
                   156,    -33,   -195,    210,   1344,   -168,    156,     48,   -141,   -222,    318,   -357,   1533,   -141, &
                    48,    480,   -384,   3072,     48,   -384,    210,   1560,   -222,    534,   -168,   -114,  -1464,    210, &
                  1533,   -168,    210,   -141,     48,   -222,    264,   -222,    264,     48,     -6,     -6,   -195,     48, &
                    -6,   -195,    -33,   -141,     21,   -195,   -168,   -114]
  K1( 884,:) = [    183,     -6,     21,    183,    210,     -6,    -33,     21,    399,    102,    210,    156,    210,  -3030, &
                  -195,  -1950,  -1140,    210,    156,  -2004,     -6,   -546,    372,   -222,    237,     48,   -168,     -6, &
                  -222,   1506,  -1302,    210,    588,  -1302,     21,    210,    264,  -2004,  -1464,  -1896,     -6,     21, &
                  1533, -12291,   -195,  -1950,   1506,   -168,    318,    372,  -2652,    696,   -168,    264,    372,    -60, &
                  -168,    372,     -6,    -60,    696,   -816,    264,  -3084,    696,    264,    372,  -3084,    -60,   -600, &
                   264,    318,    156,  -1140,     -6,    -60,    264,    156,    -33,    372,    -60,     -6,  -1518,    210, &
                 -1302,    588,    210,     21,  -1302,    210,  -1140,    210,    372,    156,    183,     -6,    210,     -6, &
                  -195,   -249,  -1518,   1533,   -222,   1506,     -6,    -60,   -492,    264,    -33,    399,     21,    210, &
                   102,    156,    372,   -222,    183,    -33,    237,     48]
  K1( 885,:) = [    102,   -384,   -114,     48,   1533,   -195,   -114,   1344,   -357,    318,   -168,   -168,   -357,   -195, &
                  2640,   -816,     -6,   1344,   -222,     -6,   1317,   -384,     -6,   -114,   -384,   -384,   1344,  -1896, &
                  -168,     48,   1533,   -168,   -222,     21,   -168,    264,   -168,  -1464,   1317,   -384,    237,   -168, &
                  -168,   -195,   -384,  -1896,  -1950,   1533,     48,  -1896,   -195,  -1950,  -1464,    237,   -195,     48, &
                    -6,     -6,   -195,     -6,     -6,    -60,     -6,     -6,    183,    -60,    237,   -249,  -1950,    -60, &
                  -546,    183,    318,  -1950,   -816,   -384,    -60,   -168,   -168,    237,   -384,    102,   -249,   -168, &
                  1344,   -168,   -114,   -357,   -168,    318,    183,   -168,   -546,    264,   -384,   -384,     21,     -6, &
                  -384,    102,     -6,   -357,    264,     -6,  -1896,    480,    -60,   -222,   -168,   -168,   1533,   -222, &
                   264,     21,    -60,    318,    183,     21,   -384,    102]
  K1( 886,:) = [   -384,    102,   -168,    237,   -168,   -249,   -114,   -357,   1344,   -168,    318,   -168,    318,  -1950, &
                  -816,   -384,    -60,   -168,    264,   -546,   -384,   -384,    183,   -168,   1317,   -384,   -168,  -1464, &
                  -168,    237,   -222,     21,   1533,   -168,    264,   -168,   1344,  -1896,   -384,   -384,     48,   -168, &
                  1533,  -1950,  -1896,   -384,   -195,   -168,     -6,     -6,     -6,    -60,    -60,    183,     -6,     -6, &
                  -195,     48,     -6,   -195,   -195,  -1950,     48,  -1896,    237,  -1464,    183,   -546,    -60,  -1950, &
                  -249,    237,   -357,   -195,   2640,   -816,     -6,   1344,   -114,     48,    102,   -384,   -195,   1533, &
                  -357,    318,   -114,   1344,   -168,   -168,     -6,   -114,     -6,   -222,   -384,   1317,     21,    183, &
                   102,   -384,    -60,    318,   -222,    -60,    480,  -1896,     -6,    264,     21,    264,   -222,   1533, &
                  -168,   -168,     -6,   -357,     -6,     21,    102,   -384]
  K1( 887,:) = [    -60,     -6,    -33,    372,    210,  -1518,    210,     21,  -1302,    588,    210,  -1302,    156,  -1140, &
                    -6,    -60,    264,    156,    156,    372,     -6,    183,  -1140,    210,  -1464,  -1896,    264,  -2004, &
                    21,     -6,    588,  -1302,  -1302,    210,    210,     21,   -168,     -6,    237,     48,   1506,   -222, &
                  -168,   1506,  -1950,   -195, -12291,   1533,    264,  -3084,    696,   -816,    264,    696,   -168,    372, &
                   372,    -60,    -60,     -6,  -2652,    696,    318,    372,    264,   -168,    318,    264,   -600,    -60, &
                 -3084,    372,    210,  -3030,   -195,  -1950,  -1140,    210,     21,    183,    183,     -6,     -6,    210, &
                   399,    102,    -33,     21,    156,    210,    372,   -222,  -2004,    156,   -546,     -6,    -33,    183, &
                    48,    237,    372,   -222,    264,   -492,    -60,     -6,   1506,   -222,    156,    102,    210,     21, &
                   399,    -33,  -1518,   1533,     -6,    210,   -249,   -195]
  K1( 888,:) = [    318,   -357,   -141,   -222,   -141,   1533,   -384,   3072,     48,    480,   -384,     48,   -195,    210, &
                  1344,   -168,    156,     48,    534,   -222,   -114,   -168,    210,   1560,   -168,   1344,   -141,    264, &
                  -141,   -168,     -6,   1749,     -6,    480,   -195,     48,   -141,     21,   -168,   -168,   -222,     48, &
                  1560,   -168,   1533,   -168,   1533,   1560,    210,     21,  -1302,    588,    210,  -1302,    210,     21, &
                   -33,    210,     21,     21,    399,    102,    156,  -1302,    102,    588,    -33,    156,    210,    210, &
                   399,  -1302,     48,    210,   -357,    318,    156,   -195,   -195,    -33,     21,     21,    210,  -1464, &
                    48,    480,   -195,   1749,     -6,     -6,    156,    534,    156,    912,    264,   -222,   -195,     21, &
                  -114,   -168,    -33,   -141,     48,    264,   -222,    264,   -222,     48,   -195,     -6,     48,   -195, &
                    -6,     -6,    210,   -141,    210,  -1464,   -168,   1533]
  K1( 889,:) = [   -195,     -6,     21,     -6,     21,    -60,   1533,   -222,   -222,    210,    210,    156,    210,    -60, &
                    48,     -6,    372,     21,    -33,    372,   -195,     -6,   -168,    210,  -1950,    -60,    210,    -60, &
                   210,   -600,   -168,    264,     21,    210,    -33,    156,  -1302,    372,  -1896,     -6,  -3084,     21, &
                   156,    318,     48,     -6,    264,    210, -12291,   1506,   1506,     -6,     -6,  -2004,   1506,   -492, &
                    -6,  -1518,    183,    372,     -6,    183,  -2004,    372,  -3030,  -1140,  -1518,    372,    372,  -1140, &
                 -1140,    264,  -1302,    372,    237,    183,    318,    -33,    588,   -168,  -1464,    -60,    264,    210, &
                  -168,     21,    264,    -33,    210,    156,  -2652,    399,    696,  -1302,   -195,     -6,    399,  -3084, &
                  -249,   -546,    264,    156,    102,    264,    237,    183,    696,  -1302,   1533,   -222,   -222,    210, &
                   210,    156,    696,    102,   -816,    588,  -1950,    -60]
  K1( 890,:) = [     -6,   -195,     21,    -60,     21,     -6,   -222,   1533,    210,    156,   -222,    210,    -33,    372, &
                  -195,     -6,   -168,    210,    210,    -60,     48,     -6,    372,     21,    -60,  -1950,    210,   -600, &
                   210,    -60,    264,   -168,    -33,    156,     21,    210,    156,    318,     48,     -6,    264,    210, &
                 -1302,    372,  -1896,     -6,  -3084,     21,   1506, -12291,     -6,  -2004,   1506,     -6,   -492,   1506, &
                   183,    372,     -6,  -1518,  -1518,    372,    372,  -1140,  -1140,    264,     -6,    183,  -2004,    372, &
                 -3030,  -1140,    399,  -3084,   -249,   -546,    264,    156,    102,    264,    237,    183,    696,  -1302, &
                  1533,   -222,   -222,    210,    210,    156,    696,    102,   -816,    588,  -1950,    -60,  -1302,    372, &
                   237,    183,    318,    -33,    588,   -168,  -1464,    -60,    264,    210,   -168,     21,    264,    -33, &
                   210,    156,  -2652,    399,    696,  -1302,   -195,     -6]
  K1( 891,:) = [     48,     -6,    210,    -60,     21,    372,   -222,    210,   1533,   -222,    156,    210,     21,     -6, &
                  -195,     -6,    -60,     21,    210,   -168,     -6,   -195,    372,    -33,    237,    183,  -1302,    372, &
                   -33,    318,   -168,     21,    264,    -33,    210,    156,    588,   -168,  -1464,    -60,    264,    210, &
                   399,  -2652,   -195,     -6,    696,  -1302,   1506,     -6, -12291,   1506,  -2004,     -6,     -6,    183, &
                 -2004,    372,  -3030,  -1140,   1506,   -492,     -6,  -1518,    183,    372,    372,  -1518,  -1140,    264, &
                   372,  -1140,    210,    -60,  -1950,    -60,   -600,    210,  -1302,    372,  -1896,     -6,  -3084,     21, &
                  -168,    264,     21,    210,    -33,    156,    318,    156,    264,    210,     48,     -6,    156,    264, &
                  -546,   -249,  -3084,    399,    102,    696,  -1950,    -60,   -816,    588,   -222,   1533,    210,    156, &
                  -222,    210,    264,    102,    696,  -1302,    237,    183]
  K1( 892,:) = [   -195,     -6,    -33,    372,    210,   -168,    210,    156,   -222,   1533,    210,   -222,     21,    -60, &
                    -6,   -195,     -6,     21,     21,    372,     -6,     48,    -60,    210,   -249,   -546,    399,  -3084, &
                   156,    264,   1533,   -222,   -222,    210,    210,    156,    102,    264,    237,    183,    696,  -1302, &
                   102,    696,  -1950,    -60,   -816,    588,     -6,  -2004,   1506, -12291,     -6,   1506,  -1518,    372, &
                   372,  -1140,  -1140,    264,   -492,   1506,    183,    372,     -6,  -1518,    183,     -6,  -3030,  -1140, &
                 -2004,    372,    210,   -600,    -60,  -1950,    -60,    210,    156,    318,     48,     -6,    264,    210, &
               