
module ol_vamp_1_ppjj_ew_uxcdsx_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjj_ew_uxcdsx_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjj_ew_uxcdsx_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjj_ew_uxcdsx_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppjj_ew_uxcdsx_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppjj_ew_uxcdsx_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjj_ew_uxcdsx_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,nMW,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,nMZ,0,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[0,nMW,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZd,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,1,4,2],[0,0,nMW,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,1,4,2],[nMW,0,0,0],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,1,4,2],[nMZ,0,nMW,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(3),ngZd,m3h2x8(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,1,4,2],[nMW,0,nMZ,0],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_W(ntryL,G1H8(2),ex2(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H8(3),ex2(:),G1H4(3),ngZu,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_W(ntryL,G1H8(4),ex2(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_VA_Q(ntryL,G0H8(1),ex1(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(5),n2h4(1))
  call Hloop_WA_Q(ntryL,G0H8(2),ex1(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(6),n2h4(2))
  call Hloop_ZA_Q(ntryL,G0H8(3),ex1(:),G0H4(1),ngZu,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(7),n2h4(3))
  call Hloop_WA_Q(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(8),n2h4(4))
  call Hloop_VA_Q(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_WA_Q(ntryL,G1H4(2),ex1(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(2),n2h2(2))
  call Hloop_ZA_Q(ntryL,G1H4(3),ex1(:),G1H2(1),ngZu,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(3),n2h2(3))
  call Hloop_WA_Q(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(4),n2h2(4))
  call Hloop_AQ_W(ntryL,G1H4(5),ex3(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_W(ntryL,G1H4(7),ex3(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H4(8),ex3(:),G1H2(4),ngZd,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(4),ngZd,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_WQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(2))
  call Hloop_WQ_A(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(7),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(4),ex2(:),G1H1(1),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(8),n2h1(4))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),2)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,6),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),2)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(2),mass4set(:,7),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,8),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,6),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,7),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,8),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,2,5],[0,0,0],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,2,5],[nMZ,0,0],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(2),ngZd,m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,2,5],[0,0,nMW],3,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(3),8,0,G1H8(1),n2h8(5))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,2,5],[0,nMW,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(4),8,0,G1H8(2),n2h8(6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,2,5],[0,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(3),8,0,G1H8(3),n2h8(7))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,2,5],[0,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(4),8,0,G1H8(4),n2h8(8))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[10,1,4],[0,0,0],3,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,1),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(1),n2h4(5))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[10,1,4],[0,nMZ,0],3,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,2),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(2),n2h4(6))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[10,1,4],[0,0,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(3),m3h4x4(:,3),heltab2x16(:,:,17))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[10,1,4],[nMW,0,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(4),m3h4x4(:,4),heltab2x16(:,:,18))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[10,1,4],[nMZ,0,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(5),m3h4x4(:,5),heltab2x16(:,:,19))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[10,1,4],[nMW,0,nMZ],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(6),m3h4x4(:,6),heltab2x16(:,:,20))
  call Hloop_VQ_A(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(7),n2h4(7))
  call Hloop_ZQ_A(ntryL,G0H8(2),ex2(:),G0H4(1),ngZu,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(8),n2h4(8))
  call Hloop_AQ_V(ntryL,G1H8(1),ex2(:),G1H4(9),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_W(ntryL,G1H8(2),ex2(:),G1H4(10),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H8(3),ex2(:),G1H4(11),ngZu,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_W(ntryL,G1H8(4),ex2(:),G1H4(12),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G1H4(2),ex1(:),G1H2(2),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VA_Q(ntryL,G1H4(3),ex1(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),11,0,G2H2(1),n2h2(5))
  call Hloop_WA_Q(ntryL,G1H4(4),ex1(:),G1H2(4),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(4),11,0,G2H2(2),n2h2(6))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex1(:),G1H2(3),ngZu,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(3),11,0,G2H2(3),n2h2(7))
  call Hloop_WA_Q(ntryL,G1H4(6),ex1(:),G1H2(4),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(4),11,0,G2H2(4),n2h2(8))
  call Hloop_QW_A(ntryL,G1H4(7),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(5))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(6))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(9),10,wf4(:,1),5,G2tensor(3),m3h4x1(:,3),heltab2x4(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(10),10,wf4(:,1),5,G2tensor(4),m3h4x1(:,4),heltab2x4(:,:,18))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(11),10,wf4(:,1),5,G2tensor(5),m3h4x1(:,5),heltab2x4(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),10,wf4(:,1),5,G2tensor(6),m3h4x1(:,6),heltab2x4(:,:,20))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(7),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(8),n2h1(8))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(9),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(10),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(11),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(12),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(22),G1tensor(3),G0tensor(22),G0tensor(3)])
  call ol_merge_tensors(G1tensor(14),[G1tensor(4),G0tensor(14),G0tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(7),G0tensor(17),G0tensor(7)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(27),G1tensor(8),G0tensor(27),G0tensor(8)])
  call ol_merge_tensors(G1tensor(9),[G0tensor(9)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(32),G1tensor(13),G0tensor(32),G0tensor(13)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(37),G1tensor(18),G0tensor(37),G0tensor(18)])
  call ol_merge_tensors(G1tensor(19),[G0tensor(19)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(20),G0tensor(20)])
  call ol_merge_tensors(G1tensor(33),[G1tensor(23),G0tensor(33),G0tensor(23)])
  call ol_merge_tensors(G1tensor(24),[G0tensor(24)])
  call ol_merge_tensors(G1tensor(25),[G0tensor(25)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(28)])
  call ol_merge_tensors(G1tensor(29),[G0tensor(29)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(30),G0tensor(40),G0tensor(30)])
  call ol_merge_tensors(G1tensor(34),[G0tensor(34)])
  call ol_merge_tensors(G1tensor(35),[G0tensor(35)])
  call ol_merge_tensors(G1tensor(38),[G0tensor(38)])
  call ol_merge_tensors(G1tensor(39),[G0tensor(39)])
  call TI_triangle_red(G2tensor(9),RedBasis(3),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(3),RedBasis(1),mass3set(:,1),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(2),M2L1R1,[nMW], &
    G0tensor(22))
  call TI_triangle_red(G2tensor(10),RedBasis(3),mass3set(:,2),G0tensor(3),G0tensor(14),G0tensor(4),G0tensor(5),M2L1R1,[nMW], &
    G0tensor(17))
  call TI_triangle_red(G2tensor(4),RedBasis(1),mass3set(:,3),G0tensor(7),G0tensor(27),G0tensor(8),G0tensor(9),M2L1R1,[nMW], &
    G0tensor(10))
  call TI_triangle_red(G2tensor(11),RedBasis(3),mass3set(:,4),G0tensor(12),G0tensor(32),G0tensor(13), &
    G0tensor(15),M2L1R1,[nMW,nMZ],G0tensor(37),G0tensor(18))
  call TI_triangle_red(G2tensor(5),RedBasis(1),mass3set(:,5),G0tensor(19),G0tensor(20),G0tensor(33),G0tensor(23),M2L1R1,[nMW,nMZ], &
    G0tensor(24),G0tensor(25))
  call TI_triangle_red(G2tensor(12),RedBasis(3),mass3set(:,6),G0tensor(28),G0tensor(29),G0tensor(40), &
    G0tensor(30),M2L1R1,[nMZ,nMW],G0tensor(34),G0tensor(35))
  call TI_triangle_red(G2tensor(6),RedBasis(1),mass3set(:,7),G0tensor(38),G0tensor(39),G0tensor(41),G0tensor(42),M2L1R1,[nMZ,nMW], &
    G0tensor(43),G0tensor(44))
  call TI_triangle_red(G2tensor(1),RedBasis(1),mass3set(:,8),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(1),mass3set(:,9),G0tensor(49),G0tensor(50),G0tensor(51),G0tensor(52),M2L1R1,[nMZ], &
    G0tensor(53))
  call TI_triangle_red(G2tensor(7),RedBasis(3),mass3set(:,8),G0tensor(54),G0tensor(55),G0tensor(56),G0tensor(57),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(3),mass3set(:,10),G0tensor(58),G0tensor(59),G0tensor(60),G0tensor(61),M2L1R1,[nMZ], &
    G0tensor(62))
  call TI_triangle_red(G1tensor(2),RedBasis(7),mass3set(:,8),G0tensor(63),G0tensor(64),G0tensor(65),G0tensor(66),M2L1R1)
  call TI_triangle_red(G1tensor(14),RedBasis(2),mass3set(:,1),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),M2L1R1,[nMW], &
    G0tensor(71))
  call TI_triangle_red(G1tensor(17),RedBasis(7),mass3set(:,3),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(76))
  call TI_triangle_red(G1tensor(9),RedBasis(2),mass3set(:,8),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),M2L1R1)
  call TI_triangle_red(G1tensor(12),RedBasis(7),mass3set(:,10),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1,[nMZ], &
    G0tensor(85))
  call TI_triangle_red(G1tensor(19),RedBasis(2),mass3set(:,11),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),M2L1R1,[nMZ], &
    G0tensor(90))
  call TI_triangle_red(G1tensor(33),RedBasis(6),mass3set(:,3),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),M2L1R1,[nMW], &
    G0tensor(95))
  call TI_triangle_red(G1tensor(24),RedBasis(5),mass3set(:,3),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),M2L1R1,[nMW], &
    G0tensor(100))
  call TI_triangle_red(G1tensor(25),RedBasis(4),mass3set(:,8),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),M2L1R1)
  call TI_triangle_red(G1tensor(28),RedBasis(6),mass3set(:,8),G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),M2L1R1)
  call TI_triangle_red(G1tensor(29),RedBasis(5),mass3set(:,2),G0tensor(109),G0tensor(110),G0tensor(111), &
    G0tensor(112),M2L1R1,[nMW],G0tensor(113))
  call TI_triangle_red(G1tensor(40),RedBasis(4),mass3set(:,2),G0tensor(114),G0tensor(115),G0tensor(116), &
    G0tensor(117),M2L1R1,[nMW],G0tensor(118))
  call TI_triangle_red(G1tensor(34),RedBasis(5),mass3set(:,12),G0tensor(119),G0tensor(120),G0tensor(121), &
    G0tensor(122),M2L1R1,[nMZ,nMW],G0tensor(123),G0tensor(124))
  call TI_triangle_red(G1tensor(35),RedBasis(4),mass3set(:,9),G0tensor(125),G0tensor(126),G0tensor(127), &
    G0tensor(128),M2L1R1,[nMZ],G0tensor(129))
  call TI_triangle_red(G1tensor(38),RedBasis(6),mass3set(:,10),G0tensor(130),G0tensor(131),G0tensor(132), &
    G0tensor(133),M2L1R1,[nMZ],G0tensor(134))
  call TI_triangle_red(G1tensor(39),RedBasis(5),mass3set(:,13),G0tensor(135),G0tensor(136),G0tensor(137), &
    G0tensor(138),M2L1R1,[nMW,nMZ],G0tensor(139),G0tensor(140))
  call ol_merge_tensors(T0sum(9),[G0tensor(63)])
  call ol_merge_tensors(T0sum(10),[G0tensor(1)])
  call ol_merge_tensors(T0sum(11),[G0tensor(67)])
  call ol_merge_tensors(T0sum(12),[G0tensor(26)])
  call ol_merge_tensors(T0sum(13),[G0tensor(72)])
  call ol_merge_tensors(T0sum(14),[G0tensor(3)])
  call ol_merge_tensors(T0sum(15),[G0tensor(77)])
  call ol_merge_tensors(T0sum(16),[G0tensor(7)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(12)])
  call ol_merge_tensors(T0sum(19),[G0tensor(19)])
  call ol_merge_tensors(T0sum(20),[G0tensor(28)])
  call ol_merge_tensors(T0sum(21),[G0tensor(86)])
  call ol_merge_tensors(T0sum(22),[G0tensor(38)])
  call ol_merge_tensors(T0sum(23),[G0tensor(91)])
  call ol_merge_tensors(T0sum(24),[G0tensor(96)])
  call ol_merge_tensors(T0sum(25),[G0tensor(101)])
  call ol_merge_tensors(T0sum(26),[G0tensor(105)])
  call ol_merge_tensors(T0sum(27),[G0tensor(109)])
  call ol_merge_tensors(T0sum(28),[G0tensor(114)])
  call ol_merge_tensors(T0sum(29),[G0tensor(119)])
  call ol_merge_tensors(T0sum(30),[G0tensor(125)])
  call ol_merge_tensors(T0sum(31),[G0tensor(130)])
  call ol_merge_tensors(T0sum(32),[G0tensor(135)])
  call ol_merge_tensors(T0sum(33),[G0tensor(45)])
  call ol_merge_tensors(T0sum(34),[G0tensor(49)])
  call ol_merge_tensors(T0sum(35),[G0tensor(54)])
  call ol_merge_tensors(T0sum(36),[G0tensor(58)])
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[10,5],[0,nME],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,7),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(1),n2h4(9))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[10,5],[0,nMM],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,8),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(2),n2h4(10))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[10,5],[0,nML],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,9),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(3),n2h4(11))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[10,5],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,10),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(4),n2h4(12))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[10,5],[nMT,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(5),n2h4(13))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[10,5],[nMH,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(6),m3h4x4(:,12),heltab2x16(:,:,26))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[10,5],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(7),m3h4x4(:,13),heltab2x16(:,:,27))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[10,5],[0,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(8),m3h4x4(:,14),heltab2x16(:,:,28))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[10,5],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(9),m3h4x4(:,15),heltab2x16(:,:,29))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[10,5],[0,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,2),G1H4(10),m3h4x4(:,16),heltab2x16(:,:,30))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[10,5],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,2),G1H4(11),m3h4x4(:,17),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[10,5],[0,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(12),m3h4x4(:,18),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[10,5],[nMZ,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(13),m3h4x4(:,19),heltab2x16(:,:,33))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[10,5],[nMW,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,20),heltab2x16(:,:,34))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[10,5],[nMW,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,21),heltab2x16(:,:,35))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[10,5],[nMH,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,22),heltab2x16(:,:,36))
  call Hloop_QW_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(9),n2h1(9))
  call Hloop_QW_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(3),n2h1(10))
  call Hloop_QW_A(ntryL,G1H4(3),wf4(:,1),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(10),n2h1(11))
  call Hloop_QW_A(ntryL,G1H4(4),wf4(:,1),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(12))
  call Hloop_QW_A(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(13))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(6),10,wf4(:,1),5,G2tensor(5),m3h4x1(:,12),heltab2x4(:,:,26))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(7),10,wf4(:,1),5,G2tensor(12),m3h4x1(:,13),heltab2x4(:,:,27))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(8),10,wf4(:,1),5,G2tensor(6),m3h4x1(:,14),heltab2x4(:,:,28))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(9),10,wf4(:,1),5,G2tensor(1),m3h4x1(:,15),heltab2x4(:,:,29))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(10),10,wf4(:,1),G2tensor(2),m3h4x1(:,16),heltab2x4(:,:,30))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(11),10,wf4(:,1),G2tensor(7),m3h4x1(:,17),heltab2x4(:,:,31))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(12),10,wf4(:,1),5,G2tensor(8),m3h4x1(:,18),heltab2x4(:,:,32))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(13),10,wf4(:,1),5,G2tensor(13),m3h4x1(:,19),heltab2x4(:,:,33))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(1),wf4(:,1),G0tensor(63),m3h4x1(:,20),heltab2x4(:,:,34))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(2),wf4(:,1),G0tensor(1),m3h4x1(:,21),heltab2x4(:,:,35))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(3),wf4(:,1),G0tensor(67),m3h4x1(:,22),heltab2x4(:,:,36))
  call ol_merge_tensors(G0tensor(102),[G0tensor(65),G0tensor(55),G0tensor(6)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(69),G0tensor(13),G0tensor(11)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(2),G2tensor(6),G0tensor(97),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(139),[G0tensor(124),G0tensor(118),G0tensor(113),G0tensor(100),G0tensor(95),G0tensor(76) &
    ,G0tensor(71),G0tensor(44),G0tensor(35),G0tensor(24),G0tensor(37),G0tensor(10),G0tensor(17),G0tensor(22),G0tensor(21)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(107),G0tensor(64),G0tensor(46),G0tensor(31)])
  call ol_merge_tensors(G0tensor(70),[G0tensor(23),G0tensor(2)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(74),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G0tensor(106),[G0tensor(79),G0tensor(56),G0tensor(4)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(110),G0tensor(8),G0tensor(5)])
  call ol_merge_tensors(G0tensor(73),[G0tensor(39),G0tensor(27)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(99),G0tensor(80),G0tensor(48),G0tensor(9)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(83),G0tensor(32)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(7),G2tensor(1),G2tensor(12),G0tensor(120),G0tensor(33),G0tensor(15)])
  call ol_merge_tensors(G0tensor(140),[G0tensor(134),G0tensor(129),G0tensor(123),G0tensor(90),G0tensor(85),G0tensor(62) &
    ,G0tensor(53),G0tensor(43),G0tensor(34),G0tensor(25),G0tensor(18)])
  call ol_merge_tensors(G0tensor(82),[G0tensor(20)])
  call ol_merge_tensors(G0tensor(131),[G0tensor(88),G0tensor(40)])
  call ol_merge_tensors(G0tensor(1),[G0tensor(136),G0tensor(41),G0tensor(30)])
  call ol_merge_tensors(G0tensor(89),[G0tensor(42)])
  call ol_merge_tensors(G2tensor(4),[G0tensor(61),G0tensor(57),G0tensor(51),G0tensor(47)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(132),G0tensor(50)])
  call ol_merge_tensors(G0tensor(128),[G0tensor(122),G0tensor(52)])
  call ol_merge_tensors(G0tensor(87),[G0tensor(84),G0tensor(78),G0tensor(75),G0tensor(68),G0tensor(66)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(98),G0tensor(93)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(127),G0tensor(116),G0tensor(108),G0tensor(103),G0tensor(94)])
  call ol_merge_tensors(G0tensor(138),[G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G2tensor(5),[G0tensor(67)])
call TI_bubble_red(G2tensor(8),10,mass2set(:,1),G0tensor(26),M2L1R1,G0tensor(72))
call TI_bubble_red(G2tensor(13),10,mass2set(:,2),G0tensor(3),M2L1R1,G0tensor(77),G0tensor(7))
call TI_bubble_red(G2tensor(4),10,mass2set(:,3),G0tensor(81),M2L1R1)
call TI_bubble_red(G2tensor(9),10,mass2set(:,4),G0tensor(12),M2L1R1,G0tensor(19))
call TI_bubble_red(G2tensor(3),10,mass2set(:,5),G0tensor(28),M2L1R1,G0tensor(86))
call TI_bubble_red(G2tensor(10),10,mass2set(:,6),G0tensor(38),M2L1R1,G0tensor(91))
call TI_bubble_red(G2tensor(11),10,mass2set(:,7),G0tensor(96),M2L1R1,G0tensor(101),G0tensor(105))
call TI_bubble_red(G2tensor(5),10,mass2set(:,8),G0tensor(109),M2L1R1,G0tensor(114),G0tensor(119))
  call ol_merge_tensors(G0tensor(114),[G0tensor(77),G0tensor(139),G0tensor(72)])
  call ol_merge_tensors(G0tensor(140),[G0tensor(7)])
  call ol_merge_tensors(T0sum(37),[G0tensor(102)])
  call ol_merge_tensors(T0sum(38),[G0tensor(92)])
  call ol_merge_tensors(T0sum(39),[G0tensor(26)])
  call ol_merge_tensors(T0sum(40),[G0tensor(114)])
  call ol_merge_tensors(T0sum(41),[G0tensor(111)])
  call ol_merge_tensors(T0sum(42),[G0tensor(70)])
  call ol_merge_tensors(T0sum(43),[G0tensor(115)])
  call ol_merge_tensors(T0sum(44),[G0tensor(106)])
  call ol_merge_tensors(T0sum(45),[G0tensor(63)])
  call ol_merge_tensors(T0sum(46),[G0tensor(73)])
  call ol_merge_tensors(T0sum(47),[G0tensor(104)])
  call ol_merge_tensors(T0sum(48),[G0tensor(126)])
  call ol_merge_tensors(T0sum(49),[G0tensor(3)])
  call ol_merge_tensors(T0sum(50),[G0tensor(140)])
  call ol_merge_tensors(T0sum(51),[G0tensor(82)])
  call ol_merge_tensors(T0sum(52),[G0tensor(131)])
  call ol_merge_tensors(T0sum(53),[G0tensor(1)])
  call ol_merge_tensors(T0sum(54),[G0tensor(89)])
  call ol_merge_tensors(T0sum(55),[G0tensor(81)])
  call ol_merge_tensors(T0sum(56),[G0tensor(137)])
  call ol_merge_tensors(T0sum(57),[G0tensor(128)])
  call ol_merge_tensors(T0sum(58),[G0tensor(59)])
  call ol_merge_tensors(T0sum(59),[G0tensor(60)])
  call ol_merge_tensors(T0sum(60),[G0tensor(87)])
  call ol_merge_tensors(T0sum(61),[G0tensor(121)])
  call ol_merge_tensors(T0sum(62),[G0tensor(133)])
  call ol_merge_tensors(T0sum(63),[G0tensor(138)])
  call ol_merge_tensors(T0sum(64),[G0tensor(12)])
  call ol_merge_tensors(T0sum(65),[G0tensor(19)])
  call ol_merge_tensors(T0sum(66),[G0tensor(28)])
  call ol_merge_tensors(T0sum(67),[G0tensor(86)])
  call ol_merge_tensors(T0sum(68),[G0tensor(38)])
  call ol_merge_tensors(T0sum(69),[G0tensor(91)])
  call ol_merge_tensors(T0sum(70),[G0tensor(96)])
  call ol_merge_tensors(T0sum(71),[G0tensor(101)])
  call ol_merge_tensors(T0sum(72),[G0tensor(105)])
  call ol_merge_tensors(T0sum(73),[G0tensor(109)])
  call ol_merge_tensors(T0sum(74),[G0tensor(119)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppjj_ew_uxcdsx_4_/**/REALKIND
