
module ol_vamp_1_ppjj_ew_bbbxbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjj_ew_bbbxbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjj_ew_bbbxbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjj_ew_bbbxbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppjj_ew_bbbxbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppjj_ew_bbbxbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjj_ew_bbbxbx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMB,nMH,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMB,nMZ,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMB,0,nMB,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMB,0,nMB,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[nMB,nMZ,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMB,0,nMB,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZd,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,2,1,4],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,1,2,4],[nMB,nMH,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,1,2,4],[nMB,nMZ,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,1,2,4],[nMB,0,nMB,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,1,2,4],[nMB,0,nMB,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,1,2,4],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,1,2,4],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,1,2,4],[nMB,nMZ,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,1,2,4],[nMB,0,nMB,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZd,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (c(14)*M(2,:)%j-c(13)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,1,2,4],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,1,4,2],[nMH,nMB,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,1,4,2],[nMZ,nMB,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngX,m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,4,2],[0,nMB,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,4,2],[0,nMB,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,22),heltab2x16(:,:,22))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,4,2],[nMB,nMH,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,4,2],[nMB,nMZ,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,4,2],[nMB,0,nMB,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngH,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,4,2],[nMB,0,nMB,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngX,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,1,4,2],[0,nMB,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,27),heltab2x16(:,:,27))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,1,4,2],[0,nMB,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,28),heltab2x16(:,:,28))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,1,4,2],[nMZ,nMB,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(7),ngZd,m3h2x8(:,29),heltab2x16(:,:,29))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,1,4,2],[0,nMB,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)-c(11)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,1,4,2],[0,nMB,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,1,4,2],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(10),8,nMB,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,1,4,2],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(10),8,nMB,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,1,4,2],[nMB,nMZ,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(10),8,nMB,G1H8(25),n2h8(25))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,1,4,2],[nMB,0,nMB,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),ngZd,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(10),8,nMB,G1H8(26),n2h8(26))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(16)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,1,4,2],[nMB,0,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(10),8,nMB,G1H8(27),n2h8(27))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(6),G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(15),G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(6),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(24),G1H8(23)])
  call Hloop_AQ_S(ntryL,G1H8(1),ex2(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G1H8(2),ex2(:),G1H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G1H8(3),ex2(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G1H8(4),ex2(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G1H8(9),ex2(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex2(:),G1H4(6),ngZd,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_V(ntryL,G1H8(8),ex2(:),G1H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_S(ntryL,G1H8(10),ex1(:),G1H4(8),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_S(ntryL,G1H8(11),ex1(:),G1H4(9),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G1H8(12),ex1(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G1H8(18),ex1(:),G1H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H8(16),ex1(:),G1H4(13),ngZd,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntryL,G1H8(17),ex1(:),G1H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_SQ_A(ntryL,G0H8(1),ex1(:),G0H4(1),ngH,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(15),n2h4(1))
  call Hloop_SQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),ngX,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(16),n2h4(2))
  call Hloop_VQ_A(ntryL,G0H8(3),ex1(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(17),n2h4(3))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(18),n2h4(4))
  call Hloop_AQ_S(ntryL,G1H8(19),ex1(:),G1H4(19),ngH,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_S(ntryL,G1H8(20),ex1(:),G1H4(20),ngX,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G1H8(21),ex1(:),G1H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G1H8(22),ex1(:),G1H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(23),n2h4(5))
  call Hloop_ZQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),ngZd,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(24),n2h4(6))
  call Hloop_VQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(25),n2h4(7))
  call Hloop_AQ_V(ntryL,G1H8(27),ex1(:),G1H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H8(25),ex1(:),G1H4(27),ngZd,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_V(ntryL,G1H8(26),ex1(:),G1H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(16)])
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(2),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(3),n2h2(3))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(4),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(5),n2h2(5))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),ngZd,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(6),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(7),n2h2(7))
  call Hloop_SQ_A(ntryL,G1H4(8),ex2(:),G1H2(1),ngH,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(8),n2h2(8))
  call Hloop_SQ_A(ntryL,G1H4(9),ex2(:),G1H2(1),ngX,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(9),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(10),ex2(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(10),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(11),ex2(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(11),n2h2(11))
  call Hloop_VQ_A(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(12),n2h2(12))
  call Hloop_ZQ_A(ntryL,G1H4(13),ex2(:),G1H2(1),ngZd,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(13),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(14),ex2(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(14),n2h2(14))
  call Hloop_QA_V(ntryL,G1H4(15),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G1H4(24),ex3(:),G1H2(2),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_S(ntryL,G1H4(17),ex3(:),G1H2(3),ngH,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_S(ntryL,G1H4(18),ex3(:),G1H2(4),ngX,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_SA_Q(ntryL,G1H4(19),ex3(:),G1H2(5),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(5),13,nMB,G2H2(15),n2h2(15))
  call Hloop_SA_Q(ntryL,G1H4(20),ex3(:),G1H2(5),ngX,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(5),13,nMB,G2H2(16),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(21),ex3(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(5),13,nMB,G2H2(17),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(22),ex3(:),G1H2(5),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(5),13,nMB,G2H2(18),n2h2(18))
  call Hloop_QA_V(ntryL,G1H4(23),ex3(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_Z(ntryL,G1H4(25),ex3(:),G1H2(6),ngZd,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_VA_Q(ntryL,G1H4(26),ex3(:),G1H2(7),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(7),13,nMB,G2H2(19),n2h2(19))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex3(:),G1H2(7),ngZd,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(7),13,nMB,G2H2(20),n2h2(20))
  call Hloop_VA_Q(ntryL,G1H4(28),ex3(:),G1H2(7),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(7),13,nMB,G2H2(21),n2h2(21))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(16)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(3),ngH,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(4),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(6),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(9),ngH,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(10),ngX,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(12),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_VQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(2))
  call Hloop_SQ_A(ntryL,G1H2(3),ex2(:),G1H1(1),ngH,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(15),n2h1(3))
  call Hloop_SQ_A(ntryL,G1H2(4),ex2(:),G1H1(1),ngX,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(16),n2h1(4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(19),ngH,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(20),ngX,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hloop_VQ_A(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(21),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex2(:),G1H1(1),ngZd,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(22),n2h1(6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(21),ex2(:),G2tensor(24),ngZd,m3h2x1(:,24),heltab2x2(:,:,24))
  call ol_merge_tensors(G2tensor(6),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(10)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(20)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(1),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(2),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(2),mass4set(:,3),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(2),mass4set(:,4),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(2),mass4set(:,5),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(3),mass4set(:,6),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),2)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(3),mass4set(:,7),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),2)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(3),mass4set(:,8),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(3),mass4set(:,9),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(3),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(3),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),2)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(3),mass4set(:,3),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),2)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(3),mass4set(:,4),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),2)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(3),mass4set(:,10),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(3),mass4set(:,5),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(1),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,2),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,3),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(2),mass4set(:,4),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(2),mass4set(:,5),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(3),mass4set(:,6),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(3),mass4set(:,7),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,8),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(3),mass4set(:,9),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(3),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(3),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,3),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(3),mass4set(:,4),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(3),mass4set(:,10),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(3),mass4set(:,5),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[8,2,5],[0,nMB,nMB],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[8,2,5],[0,nMB,nMB],3,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[8,2,5],[nMH,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(5),ngH,m3h2x8(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,2,5],[nMZ,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[8,2,5],[nMW,nMT,nMT],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngPbt,m3h2x8(:,41),heltab2x16(:,:,41))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[8,2,5],[0,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[8,2,5],[0,nMB,nMB],3,1,wf4(:,7))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[8,2,5],[0,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[8,2,5],[nMZ,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(7),ngZd,m3h2x8(:,45),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[8,2,5],[nMW,nMT,nMT],3,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,46),heltab2x16(:,:,46))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[8,2,5],[0,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(11),m3h2x8(:,47),heltab2x16(:,:,47))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(7)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[8,2,5],[nMB,0,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(12),8,nMB,G1H8(6),n2h8(28))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[8,1,6],[0,nMB,nMB],3,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,49),heltab2x16(:,:,49))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[8,1,6],[0,nMB,nMB],3,1,wf4(:,12))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,50),heltab2x16(:,:,50))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[8,1,6],[nMH,nMB,nMB],3,1,wf4(:,14))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(14),ngH,m3h2x8(:,51),heltab2x16(:,:,51))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(23)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[8,1,6],[nMZ,nMB,nMB],3,1,wf4(:,14))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(15),ngX,m3h2x8(:,52),heltab2x16(:,:,52))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[8,1,6],[nMW,nMT,nMT],3,1,wf4(:,14))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(16),ngPbt,m3h2x8(:,53),heltab2x16(:,:,53))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[8,1,6],[0,nMB,nMB],3,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,54),heltab2x16(:,:,54))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[8,1,6],[0,nMB,nMB],3,1,wf4(:,16))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(18),m3h2x8(:,55),heltab2x16(:,:,55))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[8,1,6],[0,nMB,nMB],3,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,56),heltab2x16(:,:,56))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[8,1,6],[nMZ,nMB,nMB],3,1,wf4(:,14))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(20),ngZd,m3h2x8(:,57),heltab2x16(:,:,57))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(19)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[8,1,6],[nMW,nMT,nMT],3,1,wf4(:,14))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(21),m3h2x8(:,58),heltab2x16(:,:,58))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(12)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[8,1,6],[0,nMB,nMB],3,1,wf4(:,14))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(22),m3h2x8(:,59),heltab2x16(:,:,59))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)+c(8)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[8,1,6],[nMB,0,0],3,1,wf4(:,14))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(23),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(23),8,nMB,G1H8(5),n2h8(29))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[9,2,4],[nMB,0,nMB],3,1,wf4(:,9))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(16),n2h4(8))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[9,2,4],[nMB,0,nMB],3,1,wf4(:,11))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,11),G0H4(1),ngX,m3h4x4(:,2),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(1),n2h4(9))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[9,2,4],[nMB,nMH,nMB],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,3),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(2),n2h4(10))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)+c(23)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[9,2,4],[nMB,nMZ,nMB],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,4),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(3),n2h4(11))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)+c(21)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[9,2,4],[nMT,nMW,nMT],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,5),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMT,G1H4(4),n2h4(12))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[9,2,4],[nMB,0,nMB],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,6),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(5),n2h4(13))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[9,2,4],[nMB,0,nMB],3,1,wf4(:,15))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,15),G0H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(6),n2h4(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[9,2,4],[nMB,0,nMB],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,8),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(7),n2h4(15))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[9,2,4],[nMB,nMZ,nMB],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,9),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(8),n2h4(16))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(19)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[9,2,4],[nMT,nMW,nMT],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,10),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMT,G1H4(9),n2h4(17))
  Gcoeff(:)%j = (c(11)*M(2,:)%j-c(12)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[9,2,4],[nMB,0,nMB],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H4(1),9,nMB,G1H4(10),n2h4(18))
  Gcoeff(:)%j = (c(7)*M(2,:)%j-c(8)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[9,2,4],[0,nMB,0],3,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,13),9,G1H4(11),m3h4x4(:,12),heltab2x16(:,:,72))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[10,1,4],[nMB,0,nMB],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,13),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(12),n2h4(19))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[10,1,4],[nMB,0,nMB],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngX,m3h4x4(:,14),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(13),n2h4(20))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[10,1,4],[nMB,nMH,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,15),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(14),n2h4(21))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)+c(22)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[10,1,4],[nMB,nMZ,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,16),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(15),n2h4(22))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[10,1,4],[nMT,nMW,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,17),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(24),n2h4(23))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[10,1,4],[nMB,0,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,18),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(17),n2h4(24))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[10,1,4],[nMB,0,nMB],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(1),ngZd,m3h4x4(:,19),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(18),n2h4(25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[10,1,4],[nMB,0,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,20),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(19),n2h4(26))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[10,1,4],[nMB,nMZ,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,21),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(20),n2h4(27))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[10,1,4],[nMT,nMW,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,22),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(21),n2h4(28))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[10,1,4],[nMB,0,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,23),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(22),n2h4(29))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[10,1,4],[0,nMB,0],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),10,G1H4(23),m3h4x4(:,24),heltab2x16(:,:,84))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(11),[G0H8(9),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(19),G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(7),G1H4(6),G1H4(5),G1H4(1),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(19),G1H4(18),G1H4(17),G1H4(13),G1H4(12)])
  call Hloop_VQ_A(ntryL,G0H8(10),ex2(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(25),n2h4(30))
  call Hloop_VQ_A(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(26),n2h4(31))
  call Hloop_SQ_A(ntryL,G0H8(5),ex2(:),G0H4(1),ngH,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(27),n2h4(32))
  call Hloop_SQ_A(ntryL,G0H8(1),ex2(:),G0H4(1),ngX,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(28),n2h4(33))
  call Hloop_SQ_A(ntryL,G0H8(2),ex2(:),G0H4(1),ngPtb,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(7),n2h4(34))
  call Hloop_VQ_A(ntryL,G0H8(11),ex2(:),G0H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(6),n2h4(35))
  call Hloop_VQ_A(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(5),n2h4(36))
  call Hloop_ZQ_A(ntryL,G0H8(7),ex2(:),G0H4(1),ngZd,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(1),n2h4(37))
  call Hloop_WQ_A(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(16),n2h4(38))
  call Hloop_AQ_V(ntryL,G1H8(6),ex2(:),G1H4(19),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(18),n2h4(39))
  call Hloop_VQ_A(ntryL,G0H8(13),ex1(:),G0H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(17),n2h4(40))
  call Hloop_SQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),ngH,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(13),n2h4(41))
  call Hloop_SQ_A(ntryL,G0H8(15),ex1(:),G0H4(1),ngX,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(12),n2h4(42))
  call Hloop_SQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),ngPtb,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(29),n2h4(43))
  call Hloop_VQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(30),n2h4(44))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(31),n2h4(45))
  call Hloop_ZQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),ngZd,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(32),n2h4(46))
  call Hloop_WQ_A(ntryL,G0H8(21),ex1(:),G0H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(33),n2h4(47))
  call Hloop_AQ_V(ntryL,G1H8(5),ex1(:),G1H4(34),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_AQ_V(ntryL,G1H4(10),ex2(:),G1H2(7),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_S(ntryL,G1H4(2),ex2(:),G1H2(1),ngH,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_S(ntryL,G1H4(3),ex2(:),G1H2(2),ngX,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_AQ_S(ntryL,G1H4(4),ex2(:),G1H2(3),ngPtb,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H4(8),ex2(:),G1H2(4),ngZd,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_W(ntryL,G1H4(9),ex2(:),G1H2(5),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_VQ_A(ntryL,G1H4(11),ex2(:),G1H2(6),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(6),11,nMB,G2H2(2),n2h2(22))
  call Hloop_AQ_V(ntryL,G1H4(22),ex1(:),G1H2(6),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_S(ntryL,G1H4(14),ex1(:),G1H2(8),ngH,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_S(ntryL,G1H4(15),ex1(:),G1H2(9),ngX,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_S(ntryL,G1H4(24),ex1(:),G1H2(10),ngPtb,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_Z(ntryL,G1H4(20),ex1(:),G1H2(11),ngZd,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G1H4(21),ex1(:),G1H2(12),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H4(23),ex1(:),G1H2(13),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(13),11,nMB,G2H2(9),n2h2(23))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(29)])
  call Hloop_QS_A(ntryL,G1H4(25),wf4(:,1),G1H1(1),ngH,m3h4x1(:,1),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(4),n2h1(7))
  call Hloop_QS_A(ntryL,G1H4(26),wf4(:,3),G1H1(1),ngX,m3h4x1(:,2),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(10),n2h1(8))
  call Hloop_QV_A(ntryL,G1H4(27),wf4(:,5),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(16),n2h1(9))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,5),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(20),n2h1(10))
  call Hloop_QV_A(ntryL,G1H4(16),wf4(:,5),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(1),n2h1(11))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,5),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(2),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,7),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(19),10,wf4(:,5),5,G2tensor(6),m3h4x1(:,8),heltab2x4(:,:,49))
  call Hloop_QS_A(ntryL,G1H4(18),wf4(:,10),G1H1(1),ngH,m3h4x1(:,9),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(14))
  call Hloop_QS_A(ntryL,G1H4(17),wf4(:,12),G1H1(1),ngX,m3h4x1(:,10),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(15))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,14),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(8),n2h1(16))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,14),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(9),n2h1(17))
  call Hloop_QV_A(ntryL,G1H4(33),wf4(:,14),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(12),n2h1(18))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,14),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(19))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,16),G1H1(1),ngZd,m3h4x1(:,15),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(34),9,wf4(:,14),6,G2tensor(14),m3h4x1(:,16),heltab2x4(:,:,57))
  call Hloop_VA_Q(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(15),n2h1(21))
  call Hloop_SA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),ngH,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(22),n2h1(22))
  call Hloop_SA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),ngX,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(17),n2h1(23))
  call Hloop_SA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),ngPbt,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(18),n2h1(24))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex3(:),G1H1(1),ngZd,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(19),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(24),n2h1(26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(21),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hloop_VA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(23),n2h1(27))
  call Hloop_SA_Q(ntryL,G1H2(8),ex3(:),G1H1(1),ngH,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(25),n2h1(28))
  call Hloop_SA_Q(ntryL,G1H2(9),ex3(:),G1H1(1),ngX,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(26),n2h1(29))
  call Hloop_SA_Q(ntryL,G1H2(10),ex3(:),G1H1(1),ngPbt,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(27),n2h1(30))
  call Hloop_ZA_Q(ntryL,G1H2(11),ex3(:),G1H1(1),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(28),n2h1(31))
  call Hloop_WA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(29),n2h1(32))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(30),m3h2x1(:,38),heltab2x2(:,:,38))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(3),G0tensor(52),G0tensor(3)])
  call ol_merge_tensors(G1tensor(49),[G1tensor(34),G1tensor(29),G1tensor(24),G1tensor(9),G1tensor(4),G0tensor(49),G0tensor(34) &
    ,G0tensor(29),G0tensor(24),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(8),G0tensor(57),G0tensor(8)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(10)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(17),G1tensor(12),G0tensor(22),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(13),G0tensor(62),G0tensor(13)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(14),G0tensor(39),G0tensor(14)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G1tensor(67),[G1tensor(18),G0tensor(67),G0tensor(18)])
  call ol_merge_tensors(G1tensor(44),[G1tensor(19),G0tensor(44),G0tensor(19)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(20)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(92),G1tensor(23),G0tensor(92),G0tensor(23)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(25),G0tensor(25)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(28)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(30),G0tensor(75),G0tensor(30)])
  call ol_merge_tensors(G1tensor(32),[G0tensor(32)])
  call ol_merge_tensors(G1tensor(33),[G0tensor(33)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(35),G0tensor(80),G0tensor(35)])
  call ol_merge_tensors(G1tensor(47),[G1tensor(42),G1tensor(37),G0tensor(47),G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G1tensor(38),[G0tensor(38)])
  call ol_merge_tensors(G1tensor(85),[G1tensor(40),G0tensor(85),G0tensor(40)])
  call ol_merge_tensors(G1tensor(43),[G0tensor(43)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(45),G0tensor(90),G0tensor(45)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(100),G1tensor(50),G0tensor(100),G0tensor(50)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(58),G1tensor(53),G0tensor(93),G0tensor(58),G0tensor(53)])
  call ol_merge_tensors(G1tensor(54),[G0tensor(54)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(55),G0tensor(55)])
  call ol_merge_tensors(G1tensor(59),[G0tensor(59)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(60),G0tensor(60)])
  call ol_merge_tensors(G1tensor(63),[G0tensor(63)])
  call ol_merge_tensors(G1tensor(64),[G0tensor(64)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(11),G2tensor(7),G2tensor(5),G1tensor(95),G1tensor(70),G1tensor(65),G0tensor(95) &
    ,G0tensor(70),G0tensor(65)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(68)])
  call ol_merge_tensors(G1tensor(69),[G0tensor(69)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(72),G0tensor(72)])
  call ol_merge_tensors(G1tensor(73),[G0tensor(73)])
  call ol_merge_tensors(G1tensor(99),[G1tensor(79),G1tensor(74),G0tensor(99),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(26),G1tensor(77),G0tensor(77)])
  call ol_merge_tensors(G1tensor(78),[G0tensor(78)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(97),G1tensor(87),G1tensor(82),G0tensor(97),G0tensor(87),G0tensor(82)])
  call ol_merge_tensors(G1tensor(83),[G0tensor(83)])
  call ol_merge_tensors(G1tensor(84),[G0tensor(84)])
  call ol_merge_tensors(G1tensor(88),[G0tensor(88)])
  call ol_merge_tensors(G1tensor(89),[G0tensor(89)])
  call ol_merge_tensors(G1tensor(94),[G0tensor(94)])
  call ol_merge_tensors(G1tensor(98),[G0tensor(98)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(2),G2tensor(10),G2tensor(4)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(17)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(18)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(27)])
  call TI_triangle_red(G2tensor(30),RedBasis(3),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(6),RedBasis(1),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMB], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(21),RedBasis(5),mass3set(:,1),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMB], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(14),RedBasis(4),mass3set(:,2),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMB], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(8),RedBasis(4),mass3set(:,3),G0tensor(2),G0tensor(52),G0tensor(3),G0tensor(49),M2L1R1,[nMB,nMH], &
    G0tensor(34),G0tensor(29))
  call TI_triangle_red(G2tensor(9),RedBasis(4),mass3set(:,4),G0tensor(24),G0tensor(9),G0tensor(4),G0tensor(5),M2L1R1,[nMB,nMZ], &
    G0tensor(7),G0tensor(57))
  call TI_triangle_red(G2tensor(13),RedBasis(4),mass3set(:,5),G0tensor(8),G0tensor(10),G0tensor(22),G0tensor(17),M2L1R1,[nMB], &
    G0tensor(12))
  call TI_triangle_red(G2tensor(25),RedBasis(3),mass3set(:,6),G0tensor(62),G0tensor(13),G0tensor(39), &
    G0tensor(14),M2L1R1,[nMB,nMH],G0tensor(15),G0tensor(67))
  call TI_triangle_red(G2tensor(28),RedBasis(3),mass3set(:,7),G0tensor(18),G0tensor(44),G0tensor(19), &
    G0tensor(20),M2L1R1,[nMB,nMZ],G0tensor(92),G0tensor(23))
  call TI_triangle_red(G2tensor(23),RedBasis(3),mass3set(:,8),G0tensor(25),G0tensor(27),G0tensor(28),G0tensor(75),M2L1R1,[nMB], &
    G0tensor(30))
  call TI_triangle_red(G2tensor(3),RedBasis(1),mass3set(:,5),G0tensor(32),G0tensor(33),G0tensor(80),G0tensor(35),M2L1R1,[nMB], &
    G0tensor(47))
  call TI_triangle_red(G2tensor(16),RedBasis(1),mass3set(:,3),G0tensor(42),G0tensor(37),G0tensor(38), &
    G0tensor(85),M2L1R1,[nMB,nMH],G0tensor(40),G0tensor(43))
  call TI_triangle_red(G2tensor(20),RedBasis(1),mass3set(:,4),G0tensor(90),G0tensor(45),G0tensor(48), &
    G0tensor(100),M2L1R1,[nMB,nMZ],G0tensor(50),G0tensor(93))
  call TI_triangle_red(G2tensor(1),RedBasis(1),mass3set(:,9),G0tensor(58),G0tensor(53),G0tensor(54),G0tensor(55),M2L1R1,[nMT,nMW], &
    G0tensor(59),G0tensor(60))
  call TI_triangle_red(G2tensor(12),RedBasis(4),mass3set(:,9),G0tensor(63),G0tensor(64),G0tensor(95), &
    G0tensor(70),M2L1R1,[nMT,nMW],G0tensor(65),G0tensor(68))
  call TI_triangle_red(G2tensor(15),RedBasis(5),mass3set(:,8),G0tensor(69),G0tensor(72),G0tensor(73),G0tensor(99),M2L1R1,[nMB], &
    G0tensor(79))
  call TI_triangle_red(G2tensor(22),RedBasis(5),mass3set(:,6),G0tensor(74),G0tensor(77),G0tensor(78), &
    G0tensor(97),M2L1R1,[nMB,nMH],G0tensor(87),G0tensor(82))
  call TI_triangle_red(G2tensor(19),RedBasis(5),mass3set(:,7),G0tensor(83),G0tensor(84),G0tensor(88), &
    G0tensor(89),M2L1R1,[nMB,nMZ],G0tensor(94),G0tensor(98))
  call TI_triangle_red(G2tensor(24),RedBasis(5),mass3set(:,10),G0tensor(101),G0tensor(102),G0tensor(103), &
    G0tensor(104),M2L1R1,[nMT,nMW],G0tensor(105),G0tensor(106))
  call TI_triangle_red(G2tensor(29),RedBasis(3),mass3set(:,10),G0tensor(107),G0tensor(108),G0tensor(109), &
    G0tensor(110),M2L1R1,[nMT,nMW],G0tensor(111),G0tensor(112))
  call TI_triangle_red(G1tensor(2),RedBasis(8),mass3set(:,6),G0tensor(113),G0tensor(114),G0tensor(115), &
    G0tensor(116),M2L1R1,[nMB,nMH],G0tensor(117),G0tensor(118))
  call TI_triangle_red(G1tensor(52),RedBasis(3),mass3set(:,11),G0tensor(119),G0tensor(120),G0tensor(121), &
    G0tensor(122),M2L1R1,[nMH,nMB],G0tensor(123),G0tensor(124))
  call TI_triangle_red(G1tensor(49),RedBasis(2),mass3set(:,12),G0tensor(125),G0tensor(126),G0tensor(127), &
    G0tensor(128),M2L1R1,[nMB],G0tensor(129))
  call TI_triangle_red(G1tensor(5),RedBasis(1),mass3set(:,13),G0tensor(130),G0tensor(131),G0tensor(132), &
    G0tensor(133),M2L1R1,[nMB,nMH],G0tensor(134),G0tensor(135))
  call TI_triangle_red(G1tensor(7),RedBasis(8),mass3set(:,7),G0tensor(136),G0tensor(137),G0tensor(138), &
    G0tensor(139),M2L1R1,[nMB,nMZ],G0tensor(140),G0tensor(141))
  call TI_triangle_red(G1tensor(57),RedBasis(3),mass3set(:,14),G0tensor(142),G0tensor(143),G0tensor(144), &
    G0tensor(145),M2L1R1,[nMZ,nMB],G0tensor(146),G0tensor(147))
  call TI_triangle_red(G1tensor(10),RedBasis(1),mass3set(:,15),G0tensor(148),G0tensor(149),G0tensor(150), &
    G0tensor(151),M2L1R1,[nMB,nMZ],G0tensor(152),G0tensor(153))
  call TI_triangle_red(G1tensor(22),RedBasis(8),mass3set(:,8),G0tensor(154),G0tensor(155),G0tensor(156), &
    G0tensor(157),M2L1R1,[nMB],G0tensor(158))
  call TI_triangle_red(G1tensor(62),RedBasis(3),mass3set(:,16),G0tensor(159),G0tensor(160),G0tensor(161), &
    G0tensor(162),M2L1R1,[nMH,nMB],G0tensor(163),G0tensor(164))
  call TI_triangle_red(G1tensor(39),RedBasis(2),mass3set(:,17),G0tensor(165),G0tensor(166),G0tensor(167), &
    G0tensor(168),M2L1R1,[nMH,nMB],G0tensor(169),G0tensor(170))
  call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,18),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nMH,nMB],G0tensor(175),G0tensor(176))
  call TI_triangle_red(G1tensor(67),RedBasis(3),mass3set(:,19),G0tensor(177),G0tensor(178),G0tensor(179), &
    G0tensor(180),M2L1R1,[nMZ,nMB],G0tensor(181),G0tensor(182))
  call TI_triangle_red(G1tensor(44),RedBasis(2),mass3set(:,20),G0tensor(183),G0tensor(184),G0tensor(185), &
    G0tensor(186),M2L1R1,[nMZ,nMB],G0tensor(187),G0tensor(188))
  call TI_triangle_red(G1tensor(20),RedBasis(1),mass3set(:,21),G0tensor(189),G0tensor(190),G0tensor(191), &
    G0tensor(192),M2L1R1,[nMZ,nMB],G0tensor(193),G0tensor(194))
  call TI_triangle_red(G1tensor(27),RedBasis(9),mass3set(:,6),G0tensor(195),G0tensor(196),G0tensor(197), &
    G0tensor(198),M2L1R1,[nMB,nMH],G0tensor(199),G0tensor(200))
  call TI_triangle_red(G1tensor(28),RedBasis(5),mass3set(:,11),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMH,nMB],G0tensor(205),G0tensor(206))
  call TI_triangle_red(G1tensor(75),RedBasis(4),mass3set(:,13),G0tensor(207),G0tensor(208),G0tensor(209), &
    G0tensor(210),M2L1R1,[nMB,nMH],G0tensor(211),G0tensor(212))
  call TI_triangle_red(G1tensor(32),RedBasis(9),mass3set(:,7),G0tensor(213),G0tensor(214),G0tensor(215), &
    G0tensor(216),M2L1R1,[nMB,nMZ],G0tensor(217),G0tensor(218))
  call TI_triangle_red(G1tensor(33),RedBasis(5),mass3set(:,14),G0tensor(219),G0tensor(220),G0tensor(221), &
    G0tensor(222),M2L1R1,[nMZ,nMB],G0tensor(223),G0tensor(224))
  call TI_triangle_red(G1tensor(80),RedBasis(4),mass3set(:,15),G0tensor(225),G0tensor(226),G0tensor(227), &
    G0tensor(228),M2L1R1,[nMB,nMZ],G0tensor(229),G0tensor(230))
  call TI_triangle_red(G1tensor(47),RedBasis(9),mass3set(:,8),G0tensor(231),G0tensor(232),G0tensor(233), &
    G0tensor(234),M2L1R1,[nMB],G0tensor(235))
  call TI_triangle_red(G1tensor(38),RedBasis(5),mass3set(:,16),G0tensor(236),G0tensor(237),G0tensor(238), &
    G0tensor(239),M2L1R1,[nMH,nMB],G0tensor(240),G0tensor(241))
  call TI_triangle_red(G1tensor(85),RedBasis(4),mass3set(:,18),G0tensor(242),G0tensor(243),G0tensor(244), &
    G0tensor(245),M2L1R1,[nMH,nMB],G0tensor(246),G0tensor(247))
  call TI_triangle_red(G1tensor(43),RedBasis(5),mass3set(:,19),G0tensor(248),G0tensor(249),G0tensor(250), &
    G0tensor(251),M2L1R1,[nMZ,nMB],G0tensor(252),G0tensor(253))
  call TI_triangle_red(G1tensor(90),RedBasis(4),mass3set(:,21),G0tensor(254),G0tensor(255),G0tensor(256), &
    G0tensor(257),M2L1R1,[nMZ,nMB],G0tensor(258),G0tensor(259))
  call TI_triangle_red(G1tensor(93),RedBasis(7),mass3set(:,8),G0tensor(260),G0tensor(261),G0tensor(262), &
    G0tensor(263),M2L1R1,[nMB],G0tensor(264))
  call TI_triangle_red(G1tensor(54),RedBasis(6),mass3set(:,22),G0tensor(265),G0tensor(266),G0tensor(267), &
    G0tensor(268),M2L1R1,[nMB,nMH],G0tensor(269),G0tensor(270))
  call TI_triangle_red(G1tensor(59),RedBasis(6),mass3set(:,23),G0tensor(271),G0tensor(272),G0tensor(273), &
    G0tensor(274),M2L1R1,[nMB,nMZ],G0tensor(275),G0tensor(276))
  call TI_triangle_red(G1tensor(63),RedBasis(7),mass3set(:,6),G0tensor(277),G0tensor(278),G0tensor(279), &
    G0tensor(280),M2L1R1,[nMB,nMH],G0tensor(281),G0tensor(282))
  call TI_triangle_red(G1tensor(64),RedBasis(6),mass3set(:,24),G0tensor(283),G0tensor(284),G0tensor(285), &
    G0tensor(286),M2L1R1,[nMB,nMH],G0tensor(287),G0tensor(288))
  call TI_triangle_red(G1tensor(68),RedBasis(7),mass3set(:,7),G0tensor(289),G0tensor(290),G0tensor(291), &
    G0tensor(292),M2L1R1,[nMB,nMZ],G0tensor(293),G0tensor(294))
  call TI_triangle_red(G1tensor(69),RedBasis(6),mass3set(:,25),G0tensor(295),G0tensor(296),G0tensor(297), &
    G0tensor(298),M2L1R1,[nMB,nMZ],G0tensor(299),G0tensor(300))
  call TI_triangle_red(G1tensor(73),RedBasis(7),mass3set(:,11),G0tensor(301),G0tensor(302),G0tensor(303), &
    G0tensor(304),M2L1R1,[nMH,nMB],G0tensor(305),G0tensor(306))
  call TI_triangle_red(G1tensor(99),RedBasis(6),mass3set(:,12),G0tensor(307),G0tensor(308),G0tensor(309), &
    G0tensor(310),M2L1R1,[nMB],G0tensor(311))
  call TI_triangle_red(G1tensor(78),RedBasis(7),mass3set(:,14),G0tensor(312),G0tensor(313),G0tensor(314), &
    G0tensor(315),M2L1R1,[nMZ,nMB],G0tensor(316),G0tensor(317))
  call TI_triangle_red(G1tensor(83),RedBasis(7),mass3set(:,16),G0tensor(318),G0tensor(319),G0tensor(320), &
    G0tensor(321),M2L1R1,[nMH,nMB],G0tensor(322),G0tensor(323))
  call TI_triangle_red(G1tensor(84),RedBasis(6),mass3set(:,17),G0tensor(324),G0tensor(325),G0tensor(326), &
    G0tensor(327),M2L1R1,[nMH,nMB],G0tensor(328),G0tensor(329))
  call TI_triangle_red(G1tensor(88),RedBasis(7),mass3set(:,19),G0tensor(330),G0tensor(331),G0tensor(332), &
    G0tensor(333),M2L1R1,[nMZ,nMB],G0tensor(334),G0tensor(335))
  call TI_triangle_red(G1tensor(89),RedBasis(6),mass3set(:,20),G0tensor(336),G0tensor(337),G0tensor(338), &
    G0tensor(339),M2L1R1,[nMZ,nMB],G0tensor(340),G0tensor(341))
  call TI_triangle_red(G1tensor(94),RedBasis(6),mass3set(:,26),G0tensor(342),G0tensor(343),G0tensor(344), &
    G0tensor(345),M2L1R1,[nMB],G0tensor(346))
  call TI_triangle_red(G1tensor(98),RedBasis(7),mass3set(:,1),G0tensor(347),G0tensor(348),G0tensor(349), &
    G0tensor(350),M2L1R1,[nMB],G0tensor(351))
  call ol_merge_tensors(T0sum(21),[G0tensor(113)])
  call ol_merge_tensors(T0sum(22),[G0tensor(119)])
  call ol_merge_tensors(T0sum(23),[G0tensor(125)])
  call ol_merge_tensors(T0sum(24),[G0tensor(130)])
  call ol_merge_tensors(T0sum(25),[G0tensor(136)])
  call ol_merge_tensors(T0sum(26),[G0tensor(142)])
  call ol_merge_tensors(T0sum(27),[G0tensor(148)])
  call ol_merge_tensors(T0sum(28),[G0tensor(154)])
  call ol_merge_tensors(T0sum(29),[G0tensor(159)])
  call ol_merge_tensors(T0sum(30),[G0tensor(165)])
  call ol_merge_tensors(T0sum(31),[G0tensor(171)])
  call ol_merge_tensors(T0sum(32),[G0tensor(177)])
  call ol_merge_tensors(T0sum(33),[G0tensor(183)])
  call ol_merge_tensors(T0sum(34),[G0tensor(189)])
  call ol_merge_tensors(T0sum(35),[G0tensor(1)])
  call ol_merge_tensors(T0sum(36),[G0tensor(26)])
  call ol_merge_tensors(T0sum(37),[G0tensor(195)])
  call ol_merge_tensors(T0sum(38),[G0tensor(201)])
  call ol_merge_tensors(T0sum(39),[G0tensor(207)])
  call ol_merge_tensors(T0sum(40),[G0tensor(213)])
  call ol_merge_tensors(T0sum(41),[G0tensor(219)])
  call ol_merge_tensors(T0sum(42),[G0tensor(225)])
  call ol_merge_tensors(T0sum(43),[G0tensor(231)])
  call ol_merge_tensors(T0sum(44),[G0tensor(236)])
  call ol_merge_tensors(T0sum(45),[G0tensor(242)])
  call ol_merge_tensors(T0sum(46),[G0tensor(248)])
  call ol_merge_tensors(T0sum(47),[G0tensor(254)])
  call ol_merge_tensors(T0sum(48),[G0tensor(51)])
  call ol_merge_tensors(T0sum(49),[G0tensor(76)])
  call ol_merge_tensors(T0sum(50),[G0tensor(260)])
  call ol_merge_tensors(T0sum(51),[G0tensor(265)])
  call ol_merge_tensors(T0sum(52),[G0tensor(2)])
  call ol_merge_tensors(T0sum(53),[G0tensor(271)])
  call ol_merge_tensors(T0sum(54),[G0tensor(24)])
  call ol_merge_tensors(T0sum(55),[G0tensor(277)])
  call ol_merge_tensors(T0sum(56),[G0tensor(283)])
  call ol_merge_tensors(T0sum(57),[G0tensor(8)])
  call ol_merge_tensors(T0sum(58),[G0tensor(289)])
  call ol_merge_tensors(T0sum(59),[G0tensor(295)])
  call ol_merge_tensors(T0sum(60),[G0tensor(62)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(307)])
  call ol_merge_tensors(T0sum(63),[G0tensor(18)])
  call ol_merge_tensors(T0sum(64),[G0tensor(312)])
  call ol_merge_tensors(T0sum(65),[G0tensor(25)])
  call ol_merge_tensors(T0sum(66),[G0tensor(318)])
  call ol_merge_tensors(T0sum(67),[G0tensor(324)])
  call ol_merge_tensors(T0sum(68),[G0tensor(330)])
  call ol_merge_tensors(T0sum(69),[G0tensor(336)])
  call ol_merge_tensors(T0sum(70),[G0tensor(342)])
  call ol_merge_tensors(T0sum(71),[G0tensor(347)])
  call ol_merge_tensors(T0sum(72),[G0tensor(32)])
  call ol_merge_tensors(T0sum(73),[G0tensor(42)])
  call ol_merge_tensors(T0sum(74),[G0tensor(90)])
  call ol_merge_tensors(T0sum(75),[G0tensor(58)])
  call ol_merge_tensors(T0sum(76),[G0tensor(63)])
  call ol_merge_tensors(T0sum(77),[G0tensor(69)])
  call ol_merge_tensors(T0sum(78),[G0tensor(74)])
  call ol_merge_tensors(T0sum(79),[G0tensor(83)])
  call ol_merge_tensors(T0sum(80),[G0tensor(101)])
  call ol_merge_tensors(T0sum(81),[G0tensor(107)])
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(27)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[10,5],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,25),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(10),n2h4(48))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(25)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[10,5],[nMT,nMT],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,26),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(2),n2h4(49))
  Gcoeff(:)%j = (c(28)*M(2,:)%j-c(27)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[10,5],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,27),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(3),n2h4(50))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(25)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[10,5],[nMB,nMB],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,28),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(4),n2h4(51))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(15)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[10,5],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),10,G1H4(8),m3h4x4(:,29),heltab2x16(:,:,89))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(9)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[10,5],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),10,G1H4(9),m3h4x4(:,30),heltab2x16(:,:,90))
  Gcoeff(:)%j = (c(27)*M(2,:)%j-c(28)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[9,6],[0,0],2,2,wf4(:,13),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,31),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(11),n2h4(52))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[9,6],[nMT,nMT],2,2,wf4(:,13),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,32),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(22),n2h4(53))
  Gcoeff(:)%j = (c(27)*M(2,:)%j-c(28)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[9,6],[0,0],2,2,wf4(:,13),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,33),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(14),n2h4(54))
  Gcoeff(:)%j = (c(25)*M(2,:)%j-c(26)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[9,6],[nMB,nMB],2,2,wf4(:,13),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,13),G0H4(1),m3h4x4(:,34),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMB,G1H4(15),n2h4(55))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(17)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[9,6],[0,0],2,2,wf4(:,13),wf4(:,14))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,13),9,G1H4(24),m3h4x4(:,35),heltab2x16(:,:,95))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(10)*M(4,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[9,6],[0,0],2,2,wf4(:,13),wf4(:,14))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,13),9,G1H4(20),m3h4x4(:,36),heltab2x16(:,:,96))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(11)])
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,5),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(33))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,5),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(7),n2h1(34))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,5),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(35))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(8),10,wf4(:,5),5,G2tensor(26),m3h4x1(:,20),heltab2x4(:,:,61))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(9),10,wf4(:,5),5,G2tensor(2),m3h4x1(:,21),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,14),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(36))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,14),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(4),n2h1(37))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,14),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(17),n2h1(38))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(24),9,wf4(:,14),6,G2tensor(18),m3h4x1(:,25),heltab2x4(:,:,66))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),9,wf4(:,14),6,G2tensor(27),m3h4x1(:,26),heltab2x4(:,:,67))
  call ol_merge_tensors(G0tensor(178),[G0tensor(160),G0tensor(156),G0tensor(10),G0tensor(6)])
  call ol_merge_tensors(G0tensor(261),[G0tensor(221),G0tensor(203),G0tensor(144),G0tensor(127),G0tensor(121),G0tensor(61) &
    ,G0tensor(11)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(26),G2tensor(11),G0tensor(343),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(351),[G0tensor(346),G0tensor(341),G0tensor(335),G0tensor(329),G0tensor(323),G0tensor(317) &
    ,G0tensor(311),G0tensor(306),G0tensor(299),G0tensor(293),G0tensor(287),G0tensor(281),G0tensor(275),G0tensor(269),G0tensor(264) &
    ,G0tensor(259),G0tensor(253),G0tensor(247),G0tensor(241),G0tensor(235),G0tensor(229),G0tensor(224),G0tensor(217),G0tensor(211) &
    ,G0tensor(206),G0tensor(199),G0tensor(194),G0tensor(188),G0tensor(182),G0tensor(176),G0tensor(170),G0tensor(164),G0tensor(158) &
    ,G0tensor(152),G0tensor(147),G0tensor(140),G0tensor(134),G0tensor(129),G0tensor(124),G0tensor(117),G0tensor(94),G0tensor(87) &
    ,G0tensor(79),G0tensor(50),G0tensor(40),G0tensor(47),G0tensor(30),G0tensor(92),G0tensor(15),G0tensor(12),G0tensor(7) &
    ,G0tensor(34),G0tensor(96),G0tensor(71),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(349),[G0tensor(314),G0tensor(309),G0tensor(303),G0tensor(190),G0tensor(172),G0tensor(155) &
    ,G0tensor(72),G0tensor(31)])
  call ol_merge_tensors(G0tensor(310),[G0tensor(228),G0tensor(210),G0tensor(151),G0tensor(133),G0tensor(128),G0tensor(91) &
    ,G0tensor(41)])
  call ol_merge_tensors(G0tensor(344),[G0tensor(273),G0tensor(267),G0tensor(262),G0tensor(249),G0tensor(237),G0tensor(233) &
    ,G0tensor(33),G0tensor(56)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(18),G2tensor(10),G0tensor(350),G0tensor(86),G0tensor(66)])
  call ol_merge_tensors(G0tensor(255),[G0tensor(243),G0tensor(232),G0tensor(27),G0tensor(81)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(115),G0tensor(52)])
  call ol_merge_tensors(G2tensor(17),[G0tensor(292),G0tensor(280),G0tensor(263),G0tensor(89),G0tensor(97),G0tensor(99) &
    ,G0tensor(22),G0tensor(4),G0tensor(3)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(85),G0tensor(49)])
  call ol_merge_tensors(G0tensor(328),[G0tensor(322),G0tensor(305),G0tensor(288),G0tensor(282),G0tensor(270),G0tensor(246) &
    ,G0tensor(240),G0tensor(212),G0tensor(205),G0tensor(200),G0tensor(175),G0tensor(169),G0tensor(163),G0tensor(135),G0tensor(123) &
    ,G0tensor(118),G0tensor(82),G0tensor(43),G0tensor(67),G0tensor(29)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(138),G0tensor(9)])
  call ol_merge_tensors(G0tensor(274),[G0tensor(100),G0tensor(5)])
  call ol_merge_tensors(G0tensor(340),[G0tensor(334),G0tensor(316),G0tensor(300),G0tensor(294),G0tensor(276),G0tensor(258) &
    ,G0tensor(252),G0tensor(230),G0tensor(223),G0tensor(218),G0tensor(193),G0tensor(187),G0tensor(181),G0tensor(153),G0tensor(146) &
    ,G0tensor(141),G0tensor(98),G0tensor(93),G0tensor(23),G0tensor(57)])
  call ol_merge_tensors(G0tensor(345),[G0tensor(298),G0tensor(286),G0tensor(35),G0tensor(17)])
  call ol_merge_tensors(G0tensor(208),[G0tensor(196),G0tensor(13)])
  call ol_merge_tensors(G0tensor(302),[G0tensor(78),G0tensor(39)])
  call ol_merge_tensors(G2tensor(5),[G0tensor(337),G0tensor(325),G0tensor(308),G0tensor(48),G0tensor(38),G0tensor(80),G0tensor(75) &
    ,G0tensor(20),G0tensor(14)])
  call ol_merge_tensors(G0tensor(226),[G0tensor(214),G0tensor(44)])
  call ol_merge_tensors(G0tensor(313),[G0tensor(88),G0tensor(19)])
  call ol_merge_tensors(G0tensor(348),[G0tensor(331),G0tensor(319),G0tensor(73),G0tensor(28)])
  call ol_merge_tensors(G0tensor(285),[G0tensor(279),G0tensor(202),G0tensor(197),G0tensor(37)])
  call ol_merge_tensors(G0tensor(297),[G0tensor(291),G0tensor(220),G0tensor(215),G0tensor(45)])
  call ol_merge_tensors(G2tensor(7),[G0tensor(110),G0tensor(54)])
  call ol_merge_tensors(G0tensor(70),[G0tensor(55)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(105),G0tensor(65),G0tensor(59)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(106),G0tensor(68),G0tensor(60)])
  call ol_merge_tensors(G2tensor(4),[G0tensor(104),G0tensor(95)])
  call ol_merge_tensors(G0tensor(326),[G0tensor(320),G0tensor(131),G0tensor(114),G0tensor(77)])
  call ol_merge_tensors(G0tensor(338),[G0tensor(332),G0tensor(149),G0tensor(137),G0tensor(84)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(103)])
  call ol_merge_tensors(G0tensor(234),[G0tensor(216),G0tensor(198),G0tensor(184),G0tensor(166),G0tensor(157),G0tensor(139) &
    ,G0tensor(126),G0tensor(116)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(132),G0tensor(122)])
  call ol_merge_tensors(G0tensor(272),[G0tensor(150),G0tensor(145)])
  call ol_merge_tensors(G0tensor(278),[G0tensor(238),G0tensor(167),G0tensor(161)])
  call ol_merge_tensors(G0tensor(284),[G0tensor(173),G0tensor(162)])
  call ol_merge_tensors(G0tensor(327),[G0tensor(245),G0tensor(174),G0tensor(168)])
  call ol_merge_tensors(G0tensor(290),[G0tensor(250),G0tensor(185),G0tensor(179)])
  call ol_merge_tensors(G0tensor(296),[G0tensor(191),G0tensor(180)])
  call ol_merge_tensors(G0tensor(339),[G0tensor(257),G0tensor(192),G0tensor(186)])
  call ol_merge_tensors(G0tensor(304),[G0tensor(209),G0tensor(204)])
  call ol_merge_tensors(G0tensor(315),[G0tensor(227),G0tensor(222)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(244),G0tensor(239)])
  call ol_merge_tensors(G0tensor(333),[G0tensor(256),G0tensor(251)])
call TI_bubble_red(G2tensor(2),10,mass2set(:,1),G0tensor(113),M2L1R1)
call TI_bubble_red(G2tensor(27),9,mass2set(:,1),G0tensor(119),M2L1R1)
call TI_bubble_red(G2tensor(17),9,mass2set(:,2),G0tensor(125),M2L1R1,G0tensor(130))
call TI_bubble_red(G2tensor(5),10,mass2set(:,2),G0tensor(136),M2L1R1,G0tensor(142))
call TI_bubble_red(G2tensor(7),10,mass2set(:,3),G0tensor(148),M2L1R1,G0tensor(154))
call TI_bubble_red(G2tensor(4),9,mass2set(:,3),G0tensor(159),M2L1R1,G0tensor(165))
  call ol_merge_tensors(G0tensor(142),[G0tensor(130),G0tensor(351)])
  call ol_merge_tensors(G0tensor(165),[G0tensor(111),G0tensor(154)])
  call ol_merge_tensors(T0sum(82),[G0tensor(178)])
  call ol_merge_tensors(T0sum(83),[G0tensor(261)])
  call ol_merge_tensors(T0sum(84),[G0tensor(113)])
  call ol_merge_tensors(T0sum(85),[G0tensor(142)])
  call ol_merge_tensors(T0sum(86),[G0tensor(349)])
  call ol_merge_tensors(T0sum(87),[G0tensor(310)])
  call ol_merge_tensors(T0sum(88),[G0tensor(344)])
  call ol_merge_tensors(T0sum(89),[G0tensor(119)])
  call ol_merge_tensors(T0sum(90),[G0tensor(255)])
  call ol_merge_tensors(T0sum(91),[G0tensor(120)])
  call ol_merge_tensors(T0sum(92),[G0tensor(125)])
  call ol_merge_tensors(T0sum(93),[G0tensor(268)])
  call ol_merge_tensors(T0sum(94),[G0tensor(328)])
  call ol_merge_tensors(T0sum(95),[G0tensor(143)])
  call ol_merge_tensors(T0sum(96),[G0tensor(274)])
  call ol_merge_tensors(T0sum(97),[G0tensor(340)])
  call ol_merge_tensors(T0sum(98),[G0tensor(345)])
  call ol_merge_tensors(T0sum(99),[G0tensor(208)])
  call ol_merge_tensors(T0sum(100),[G0tensor(302)])
  call ol_merge_tensors(T0sum(101),[G0tensor(136)])
  call ol_merge_tensors(T0sum(102),[G0tensor(226)])
  call ol_merge_tensors(T0sum(103),[G0tensor(313)])
  call ol_merge_tensors(T0sum(104),[G0tensor(348)])
  call ol_merge_tensors(T0sum(105),[G0tensor(285)])
  call ol_merge_tensors(T0sum(106),[G0tensor(297)])
  call ol_merge_tensors(T0sum(107),[G0tensor(53)])
  call ol_merge_tensors(T0sum(108),[G0tensor(148)])
  call ol_merge_tensors(T0sum(109),[G0tensor(165)])
  call ol_merge_tensors(T0sum(110),[G0tensor(70)])
  call ol_merge_tensors(T0sum(111),[G0tensor(112)])
  call ol_merge_tensors(T0sum(112),[G0tensor(64)])
  call ol_merge_tensors(T0sum(113),[G0tensor(159)])
  call ol_merge_tensors(T0sum(114),[G0tensor(326)])
  call ol_merge_tensors(T0sum(115),[G0tensor(338)])
  call ol_merge_tensors(T0sum(116),[G0tensor(102)])
  call ol_merge_tensors(T0sum(117),[G0tensor(109)])
  call ol_merge_tensors(T0sum(118),[G0tensor(108)])
  call ol_merge_tensors(T0sum(119),[G0tensor(234)])
  call ol_merge_tensors(T0sum(120),[G0tensor(266)])
  call ol_merge_tensors(T0sum(121),[G0tensor(272)])
  call ol_merge_tensors(T0sum(122),[G0tensor(278)])
  call ol_merge_tensors(T0sum(123),[G0tensor(284)])
  call ol_merge_tensors(T0sum(124),[G0tensor(327)])
  call ol_merge_tensors(T0sum(125),[G0tensor(290)])
  call ol_merge_tensors(T0sum(126),[G0tensor(296)])
  call ol_merge_tensors(T0sum(127),[G0tensor(339)])
  call ol_merge_tensors(T0sum(128),[G0tensor(304)])
  call ol_merge_tensors(T0sum(129),[G0tensor(315)])
  call ol_merge_tensors(T0sum(130),[G0tensor(321)])
  call ol_merge_tensors(T0sum(131),[G0tensor(333)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppjj_ew_bbbxbx_1_/**/REALKIND
