
module ol_vamp_1_ppjj_ew_uuuxux_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjj_ew_uuuxux_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjj_ew_uuuxux_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjj_ew_uuuxux_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppjj_ew_uuuxux_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppjj_ew_uuuxux_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjj_ew_uuuxux_3_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(4,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,0,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZu,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,nMZ,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[0,nMZ,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZu,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[0,nMZ,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,2,1,4],[0,0,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZu,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (c(1)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,1,2,4],[0,0,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZu,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,1,2,4],[0,nMZ,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (c(3)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,1,2,4],[0,nMZ,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZu,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,1,2,4],[0,nMZ,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,1,2,4],[0,0,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZu,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,1,4,2],[0,0,nMZ,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,1,4,2],[nMZ,0,0,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(3),ngZu,m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,1,4,2],[nMZ,0,nMZ,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(4),ngZu,m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (-(c(11)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,4,2],[nMW,0,nMW,0],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,22),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,23),heltab2x16(:,:,23))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,4,2],[nMZ,0,0,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(8),ngZu,m3h2x8(:,24),heltab2x16(:,:,24))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,4,2],[0,0,nMZ,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,25),heltab2x16(:,:,25))
  Gcoeff(:)%j = (c(1)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,1,4,2],[0,0,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),ngZu,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,1,4,2],[0,nMZ,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(3)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,1,4,2],[0,nMZ,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),ngZu,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,1,4,2],[0,nMW,0,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,1,4,2],[0,nMZ,0,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,1,4,2],[0,0,0,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(10),ngZu,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(10),8,0,G1H8(25),n2h8(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(5),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(13),G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(7),[G0H8(6),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(22),G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(19)])
  call Hloop_AQ_V(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G1H8(8),ex2(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex2(:),G1H4(3),ngZu,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H8(4),ex2(:),G1H4(4),ngZu,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G1H8(14),ex1(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G1H8(16),ex1(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H8(15),ex1(:),G1H4(7),ngZu,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H8(12),ex1(:),G1H4(8),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_VQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(9),n2h4(1))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(10),n2h4(2))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),ngZu,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(11),n2h4(3))
  call Hloop_ZQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),ngZu,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(12),n2h4(4))
  call Hloop_WQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(13),n2h4(5))
  call Hloop_AQ_V(ntryL,G1H8(23),ex1(:),G1H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_V(ntryL,G1H8(25),ex1(:),G1H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H8(24),ex1(:),G1H4(16),ngZu,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H8(20),ex1(:),G1H4(17),ngZu,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G1H8(21),ex1(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_VQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(2),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngZu,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(3),n2h2(3))
  call Hloop_ZQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),ngZu,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(4),n2h2(4))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(5),n2h2(5))
  call Hloop_VQ_A(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(6),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex2(:),G1H2(1),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(7),n2h2(7))
  call Hloop_ZQ_A(ntryL,G1H4(8),ex2(:),G1H2(1),ngZu,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(8),n2h2(8))
  call Hloop_QA_V(ntryL,G1H4(9),ex3(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G1H4(10),ex3(:),G1H2(2),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G1H4(11),ex3(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_Z(ntryL,G1H4(12),ex3(:),G1H2(4),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_W(ntryL,G1H4(13),ex3(:),G1H2(5),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VA_Q(ntryL,G1H4(14),ex3(:),G1H2(6),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(6),13,0,G2H2(9),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(15),ex3(:),G1H2(6),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(6),13,0,G2H2(10),n2h2(10))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex3(:),G1H2(6),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(6),13,0,G2H2(11),n2h2(11))
  call Hloop_ZA_Q(ntryL,G1H4(17),ex3(:),G1H2(6),ngZu,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(6),13,0,G2H2(12),n2h2(12))
  call Hloop_WA_Q(ntryL,G1H4(18),ex3(:),G1H2(6),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(6),13,0,G2H2(13),n2h2(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(2),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(4),ngZu,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(6),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(8),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),ngZu,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(4),ex2(:),G1H1(1),ngZu,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(4))
  call Hloop_WQ_A(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(13),n2h1(5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(15),ngZu,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(17),ngZu,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call ol_merge_tensors(G2tensor(14),[G2tensor(9)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,1),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,2),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(2),mass4set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,4),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(3),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),2)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(3),mass4set(:,5),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),2)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(3),mass4set(:,6),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),2)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(3),mass4set(:,7),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),2)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(3),mass4set(:,8),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(3),mass4set(:,2),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(3),mass4set(:,3),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),2)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(3),mass4set(:,4),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(3),mass4set(:,9),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,2),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,3),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,4),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(3),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(3),mass4set(:,5),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(3),mass4set(:,6),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(3),mass4set(:,7),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,8),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(3),mass4set(:,2),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(3),mass4set(:,3),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(3),mass4set(:,4),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,9),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,2,5],[0,0,0],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,2,5],[nMZ,0,0],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(6),ngZu,m3h2x8(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[8,2,5],[nMW,0,0],3,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[8,2,5],[0,0,0],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,2,5],[nMZ,0,0],3,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(7),ngZu,m3h2x8(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[8,2,5],[nMW,0,0],3,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,41),heltab2x16(:,:,41))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[8,2,5],[0,0,0],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[8,2,5],[nMZ,0,0],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(5),ngZu,m3h2x8(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[8,2,5],[nMW,0,0],3,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(11),m3h2x8(:,45),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(14)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[8,2,5],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G0H8(12),8,0,G1H8(5),n2h8(26))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[8,2,5],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G0H8(12),8,0,G1H8(1),n2h8(27))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,48),heltab2x16(:,:,48))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[8,1,6],[nMZ,0,0],3,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(13),ngZu,m3h2x8(:,49),heltab2x16(:,:,49))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[8,1,6],[nMW,0,0],3,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(14),m3h2x8(:,50),heltab2x16(:,:,50))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(15),m3h2x8(:,51),heltab2x16(:,:,51))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[8,1,6],[0,0,0],3,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(16),m3h2x8(:,52),heltab2x16(:,:,52))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[8,1,6],[nMZ,0,0],3,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(17),ngZu,m3h2x8(:,53),heltab2x16(:,:,53))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[8,1,6],[nMW,0,0],3,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(18),m3h2x8(:,54),heltab2x16(:,:,54))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[8,1,6],[0,0,0],3,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,55),heltab2x16(:,:,55))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(20),m3h2x8(:,56),heltab2x16(:,:,56))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[8,1,6],[nMZ,0,0],3,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(21),ngZu,m3h2x8(:,57),heltab2x16(:,:,57))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(19)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[8,1,6],[nMW,0,0],3,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(22),m3h2x8(:,58),heltab2x16(:,:,58))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[8,1,6],[0,nMW,nMW],3,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(23),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(23),8,0,G1H8(2),n2h8(28))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[8,1,6],[0,nMW,nMW],3,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(23),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(23),8,0,G1H8(3),n2h8(29))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,1),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(1),n2h4(6))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[9,2,4],[0,nMZ,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,2),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(2),n2h4(7))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[9,2,4],[0,nMW,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,3),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(3),n2h4(8))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,4),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(4),n2h4(9))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[9,2,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,7),G0H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(5),n2h4(10))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[9,2,4],[0,nMZ,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,7),G0H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(6),n2h4(11))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[9,2,4],[0,nMW,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,7),G0H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(7),n2h4(12))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[9,2,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,7),G0H4(1),ngZu,m3h4x4(:,8),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(8),n2h4(13))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(5)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,9),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(9),n2h4(14))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[9,2,4],[0,nMZ,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,10),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(10),n2h4(15))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(19)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[9,2,4],[0,nMW,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H4(1),9,0,G1H4(11),n2h4(16))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[9,2,4],[nMW,0,nMW],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(12),m3h4x4(:,12),heltab2x16(:,:,72))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[9,2,4],[nMW,0,nMW],3,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(13),m3h4x4(:,13),heltab2x16(:,:,73))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[10,1,4],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,14),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(14),n2h4(17))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[10,1,4],[0,nMZ,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,15),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(15),n2h4(18))
  Gcoeff(:)%j = (c(13)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[10,1,4],[0,nMW,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,16),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(16),n2h4(19))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[10,1,4],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,17),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(17),n2h4(20))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,18),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(18),n2h4(21))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[10,1,4],[0,nMZ,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,19),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(19),n2h4(22))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[10,1,4],[0,nMW,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,20),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(20),n2h4(23))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,21),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(21),n2h4(24))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[10,1,4],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,22),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(22),n2h4(25))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[10,1,4],[0,nMZ,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,23),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(23),n2h4(26))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(18)*M(3,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[10,1,4],[0,nMW,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,24),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(24),n2h4(27))
  Gcoeff(:)%j = (-(c(14)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[10,1,4],[nMW,0,nMW],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(25),m3h4x4(:,25),heltab2x16(:,:,85))
  Gcoeff(:)%j = (-(c(12)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[10,1,4],[nMW,0,nMW],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(26),m3h4x4(:,26),heltab2x16(:,:,86))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(2),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(11),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(15),G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(8),G1H4(5),G1H4(4),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(6),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(7),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(21),G1H4(18),G1H4(17),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(19),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(20),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(25)])
  call Hloop_VQ_A(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(8),n2h4(28))
  call Hloop_ZQ_A(ntryL,G0H8(5),ex2(:),G0H4(1),ngZu,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(5),n2h4(29))
  call Hloop_WQ_A(ntryL,G0H8(11),ex2(:),G0H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(4),n2h4(30))
  call Hloop_VQ_A(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(1),n2h4(31))
  call Hloop_ZQ_A(ntryL,G0H8(7),ex2(:),G0H4(1),ngZu,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(6),n2h4(32))
  call Hloop_WQ_A(ntryL,G0H8(9),ex2(:),G0H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(2),n2h4(33))
  call Hloop_AQ_W(ntryL,G1H8(5),ex2(:),G1H4(7),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_W(ntryL,G1H8(1),ex2(:),G1H4(3),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(12),n2h4(34))
  call Hloop_ZQ_A(ntryL,G0H8(21),ex1(:),G0H4(1),ngZu,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(21),n2h4(35))
  call Hloop_WQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(18),n2h4(36))
  call Hloop_VQ_A(ntryL,G0H8(19),ex1(:),G0H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(17),n2h4(37))
  call Hloop_ZQ_A(ntryL,G0H8(17),ex1(:),G0H4(1),ngZu,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(14),n2h4(38))
  call Hloop_WQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(19),n2h4(39))
  call Hloop_AQ_W(ntryL,G1H8(2),ex1(:),G1H4(15),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AQ_W(ntryL,G1H8(3),ex1(:),G1H4(20),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G1H4(9),ex2(:),G1H2(6),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_Z(ntryL,G1H4(10),ex2(:),G1H2(1),ngZu,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G1H4(11),ex2(:),G1H2(2),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_WQ_A(ntryL,G1H4(13),ex2(:),G1H2(3),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(3),11,0,G2H2(1),n2h2(14))
  call Hloop_AQ_V(ntryL,G1H4(22),ex1(:),G1H2(4),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H4(23),ex1(:),G1H2(5),ngZu,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_W(ntryL,G1H4(24),ex1(:),G1H2(3),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_WQ_A(ntryL,G1H4(26),ex1(:),G1H2(7),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(7),11,0,G2H2(2),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(6))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(7))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,1),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(8))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,5),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(10))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(11))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(7),10,wf4(:,1),5,G2tensor(6),m3h4x1(:,7),heltab2x4(:,:,33))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(3),10,wf4(:,3),5,G2tensor(7),m3h4x1(:,8),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,6),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(8),n2h1(12))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,6),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(14),n2h1(13))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,6),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,12),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,13),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,14),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(13),n2h1(17))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(15),9,wf4(:,6),6,G2tensor(15),m3h4x1(:,15),heltab2x4(:,:,41))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(20),9,wf4(:,8),6,G2tensor(16),m3h4x1(:,16),heltab2x4(:,:,42))
  call Hloop_VA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(17),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),ngZu,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(19))
  call Hloop_WA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(19),n2h1(20))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(20),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_VA_Q(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(5),ex3(:),G1H1(1),ngZu,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(22),n2h1(22))
  call Hloop_WA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(23))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(24),m3h2x1(:,26),heltab2x2(:,:,26))
  call ol_merge_tensors(G1tensor(7),[G1tensor(2),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(67),G1tensor(42),G1tensor(3),G0tensor(67),G0tensor(42),G0tensor(3)])
  call ol_merge_tensors(G1tensor(34),[G1tensor(24),G1tensor(14),G1tensor(4),G0tensor(34),G0tensor(24),G0tensor(14),G0tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(9),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G1tensor(47),[G1tensor(8),G0tensor(47),G0tensor(8)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(29),G1tensor(19),G1tensor(9),G0tensor(39),G0tensor(29),G0tensor(19),G0tensor(9)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(10)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(12),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(13),G0tensor(52),G0tensor(13)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(18),G0tensor(57),G0tensor(18)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(20)])
  call ol_merge_tensors(G1tensor(27),[G1tensor(22),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(23),G0tensor(23)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(8),G1tensor(50),G1tensor(45),G1tensor(25),G0tensor(50),G0tensor(45),G0tensor(25)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(28)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(30),G0tensor(70),G0tensor(30)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(32),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G1tensor(33),[G0tensor(33)])
  call ol_merge_tensors(G1tensor(75),[G1tensor(35),G0tensor(75),G0tensor(35)])
  call ol_merge_tensors(G1tensor(38),[G0tensor(38)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(40),G0tensor(80),G0tensor(40)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(43),G0tensor(53),G0tensor(43)])
  call ol_merge_tensors(G1tensor(74),[G1tensor(44),G0tensor(74),G0tensor(44)])
  call ol_merge_tensors(G1tensor(58),[G1tensor(48),G0tensor(58),G0tensor(48)])
  call ol_merge_tensors(G1tensor(49),[G0tensor(49)])
  call ol_merge_tensors(G1tensor(54),[G0tensor(54)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(14),G1tensor(60),G1tensor(55),G0tensor(60),G0tensor(55)])
  call ol_merge_tensors(G1tensor(59),[G0tensor(59)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(62),G0tensor(62)])
  call ol_merge_tensors(G1tensor(63),[G0tensor(63)])
  call ol_merge_tensors(G1tensor(64),[G0tensor(64)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(10),G1tensor(65),G0tensor(65)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(68)])
  call ol_merge_tensors(G1tensor(79),[G1tensor(69),G0tensor(79),G0tensor(69)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(77),G1tensor(72),G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G1tensor(73),[G0tensor(73)])
  call ol_merge_tensors(G1tensor(78),[G0tensor(78)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(82),G0tensor(82)])
  call ol_merge_tensors(G1tensor(83),[G0tensor(83)])
  call ol_merge_tensors(G1tensor(84),[G0tensor(84)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(15),G1tensor(85),G0tensor(85)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(6)])
  call TI_triangle_red(G2tensor(21),RedBasis(3),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(3),RedBasis(1),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(17),RedBasis(5),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(4),mass3set(:,1),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(4),mass3set(:,2),G0tensor(81),G0tensor(7),G0tensor(2),G0tensor(67),M2L1R1,[nMZ], &
    G0tensor(42))
  call TI_triangle_red(G2tensor(24),RedBasis(3),mass3set(:,3),G0tensor(3),G0tensor(34),G0tensor(24),G0tensor(14),M2L1R1,[nMW], &
    G0tensor(4))
  call TI_triangle_red(G2tensor(13),RedBasis(4),mass3set(:,4),G0tensor(5),G0tensor(47),G0tensor(8),G0tensor(39),M2L1R1,[nMW], &
    G0tensor(29))
  call TI_triangle_red(G2tensor(22),RedBasis(3),mass3set(:,5),G0tensor(19),G0tensor(9),G0tensor(10),G0tensor(17),M2L1R1,[nMZ], &
    G0tensor(12))
  call TI_triangle_red(G2tensor(23),RedBasis(3),mass3set(:,6),G0tensor(52),G0tensor(13),G0tensor(15),G0tensor(57),M2L1R1,[nMW], &
    G0tensor(18))
  call TI_triangle_red(G2tensor(16),RedBasis(4),mass3set(:,7),G0tensor(20),G0tensor(27),G0tensor(22),G0tensor(23),M2L1R1,[nMW], &
    G0tensor(50))
  call TI_triangle_red(G2tensor(4),RedBasis(1),mass3set(:,2),G0tensor(45),G0tensor(25),G0tensor(28),G0tensor(70),M2L1R1,[nMZ], &
    G0tensor(30))
  call TI_triangle_red(G2tensor(5),RedBasis(1),mass3set(:,4),G0tensor(37),G0tensor(32),G0tensor(33),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(35))
  call TI_triangle_red(G2tensor(7),RedBasis(1),mass3set(:,7),G0tensor(38),G0tensor(80),G0tensor(40),G0tensor(53),M2L1R1,[nMW], &
    G0tensor(43))
  call TI_triangle_red(G2tensor(18),RedBasis(5),mass3set(:,5),G0tensor(74),G0tensor(44),G0tensor(58),G0tensor(48),M2L1R1,[nMZ], &
    G0tensor(49))
  call TI_triangle_red(G2tensor(19),RedBasis(5),mass3set(:,6),G0tensor(54),G0tensor(60),G0tensor(55),G0tensor(59),M2L1R1,[nMW], &
    G0tensor(62))
  call TI_triangle_red(G2tensor(20),RedBasis(5),mass3set(:,3),G0tensor(63),G0tensor(64),G0tensor(65),G0tensor(68),M2L1R1,[nMW], &
    G0tensor(79))
  call TI_triangle_red(G1tensor(7),RedBasis(8),mass3set(:,1),G0tensor(69),G0tensor(77),G0tensor(72),G0tensor(73),M2L1R1)
  call TI_triangle_red(G1tensor(34),RedBasis(2),mass3set(:,1),G0tensor(78),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1)
  call TI_triangle_red(G1tensor(47),RedBasis(3),mass3set(:,8),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),M2L1R1,[nMZ], &
    G0tensor(89))
  call TI_triangle_red(G1tensor(39),RedBasis(2),mass3set(:,8),G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),M2L1R1,[nMZ], &
    G0tensor(94))
  call TI_triangle_red(G1tensor(10),RedBasis(1),mass3set(:,8),G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),M2L1R1,[nMZ], &
    G0tensor(99))
  call TI_triangle_red(G1tensor(17),RedBasis(8),mass3set(:,5),G0tensor(100),G0tensor(101),G0tensor(102), &
    G0tensor(103),M2L1R1,[nMZ],G0tensor(104))
  call TI_triangle_red(G1tensor(52),RedBasis(3),mass3set(:,2),G0tensor(105),G0tensor(106),G0tensor(107), &
    G0tensor(108),M2L1R1,[nMZ],G0tensor(109))
  call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,5),G0tensor(110),G0tensor(111),G0tensor(112), &
    G0tensor(113),M2L1R1,[nMZ],G0tensor(114))
  call TI_triangle_red(G1tensor(57),RedBasis(3),mass3set(:,9),G0tensor(115),G0tensor(116),G0tensor(117), &
    G0tensor(118),M2L1R1,[nMZ],G0tensor(119))
  call TI_triangle_red(G1tensor(20),RedBasis(1),mass3set(:,10),G0tensor(120),G0tensor(121),G0tensor(122), &
    G0tensor(123),M2L1R1,[nMZ],G0tensor(124))
  call TI_triangle_red(G1tensor(27),RedBasis(9),mass3set(:,1),G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),M2L1R1)
  call TI_triangle_red(G1tensor(28),RedBasis(5),mass3set(:,8),G0tensor(129),G0tensor(130),G0tensor(131), &
    G0tensor(132),M2L1R1,[nMZ],G0tensor(133))
  call TI_triangle_red(G1tensor(70),RedBasis(4),mass3set(:,8),G0tensor(134),G0tensor(135),G0tensor(136), &
    G0tensor(137),M2L1R1,[nMZ],G0tensor(138))
  call TI_triangle_red(G1tensor(37),RedBasis(9),mass3set(:,5),G0tensor(139),G0tensor(140),G0tensor(141), &
    G0tensor(142),M2L1R1,[nMZ],G0tensor(143))
  call TI_triangle_red(G1tensor(33),RedBasis(5),mass3set(:,2),G0tensor(144),G0tensor(145),G0tensor(146), &
    G0tensor(147),M2L1R1,[nMZ],G0tensor(148))
  call TI_triangle_red(G1tensor(75),RedBasis(4),mass3set(:,5),G0tensor(149),G0tensor(150),G0tensor(151), &
    G0tensor(152),M2L1R1,[nMZ],G0tensor(153))
  call TI_triangle_red(G1tensor(38),RedBasis(5),mass3set(:,9),G0tensor(154),G0tensor(155),G0tensor(156), &
    G0tensor(157),M2L1R1,[nMZ],G0tensor(158))
  call TI_triangle_red(G1tensor(80),RedBasis(4),mass3set(:,10),G0tensor(159),G0tensor(160),G0tensor(161), &
    G0tensor(162),M2L1R1,[nMZ],G0tensor(163))
  call TI_triangle_red(G1tensor(53),RedBasis(7),mass3set(:,1),G0tensor(164),G0tensor(165),G0tensor(166),G0tensor(167),M2L1R1)
  call TI_triangle_red(G1tensor(74),RedBasis(6),mass3set(:,1),G0tensor(168),G0tensor(169),G0tensor(170),G0tensor(171),M2L1R1)
  call TI_triangle_red(G1tensor(58),RedBasis(7),mass3set(:,5),G0tensor(172),G0tensor(173),G0tensor(174), &
    G0tensor(175),M2L1R1,[nMZ],G0tensor(176))
  call TI_triangle_red(G1tensor(49),RedBasis(6),mass3set(:,5),G0tensor(177),G0tensor(178),G0tensor(179), &
    G0tensor(180),M2L1R1,[nMZ],G0tensor(181))
  call TI_triangle_red(G1tensor(54),RedBasis(6),mass3set(:,2),G0tensor(182),G0tensor(183),G0tensor(184), &
    G0tensor(185),M2L1R1,[nMZ],G0tensor(186))
  call TI_triangle_red(G1tensor(59),RedBasis(6),mass3set(:,11),G0tensor(187),G0tensor(188),G0tensor(189), &
    G0tensor(190),M2L1R1,[nMZ],G0tensor(191))
  call TI_triangle_red(G1tensor(63),RedBasis(7),mass3set(:,6),G0tensor(192),G0tensor(193),G0tensor(194), &
    G0tensor(195),M2L1R1,[nMW],G0tensor(196))
  call TI_triangle_red(G1tensor(64),RedBasis(6),mass3set(:,12),G0tensor(197),G0tensor(198),G0tensor(199), &
    G0tensor(200),M2L1R1,[nMW],G0tensor(201))
  call TI_triangle_red(G1tensor(68),RedBasis(7),mass3set(:,8),G0tensor(202),G0tensor(203),G0tensor(204), &
    G0tensor(205),M2L1R1,[nMZ],G0tensor(206))
  call TI_triangle_red(G1tensor(79),RedBasis(6),mass3set(:,8),G0tensor(207),G0tensor(208),G0tensor(209), &
    G0tensor(210),M2L1R1,[nMZ],G0tensor(211))
  call TI_triangle_red(G1tensor(73),RedBasis(7),mass3set(:,2),G0tensor(212),G0tensor(213),G0tensor(214), &
    G0tensor(215),M2L1R1,[nMZ],G0tensor(216))
  call TI_triangle_red(G1tensor(78),RedBasis(7),mass3set(:,9),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nMZ],G0tensor(221))
  call TI_triangle_red(G1tensor(83),RedBasis(7),mass3set(:,3),G0tensor(222),G0tensor(223),G0tensor(224), &
    G0tensor(225),M2L1R1,[nMW],G0tensor(226))
  call TI_triangle_red(G1tensor(84),RedBasis(6),mass3set(:,13),G0tensor(227),G0tensor(228),G0tensor(229), &
    G0tensor(230),M2L1R1,[nMW],G0tensor(231))
  call ol_merge_tensors(T0sum(18),[G0tensor(69)])
  call ol_merge_tensors(T0sum(19),[G0tensor(1)])
  call ol_merge_tensors(T0sum(20),[G0tensor(78)])
  call ol_merge_tensors(T0sum(21),[G0tensor(21)])
  call ol_merge_tensors(T0sum(22),[G0tensor(85)])
  call ol_merge_tensors(T0sum(23),[G0tensor(90)])
  call ol_merge_tensors(T0sum(24),[G0tensor(95)])
  call ol_merge_tensors(T0sum(25),[G0tensor(100)])
  call ol_merge_tensors(T0sum(26),[G0tensor(105)])
  call ol_merge_tensors(T0sum(27),[G0tensor(110)])
  call ol_merge_tensors(T0sum(28),[G0tensor(115)])
  call ol_merge_tensors(T0sum(29),[G0tensor(120)])
  call ol_merge_tensors(T0sum(30),[G0tensor(125)])
  call ol_merge_tensors(T0sum(31),[G0tensor(41)])
  call ol_merge_tensors(T0sum(32),[G0tensor(61)])
  call ol_merge_tensors(T0sum(33),[G0tensor(129)])
  call ol_merge_tensors(T0sum(34),[G0tensor(134)])
  call ol_merge_tensors(T0sum(35),[G0tensor(139)])
  call ol_merge_tensors(T0sum(36),[G0tensor(144)])
  call ol_merge_tensors(T0sum(37),[G0tensor(149)])
  call ol_merge_tensors(T0sum(38),[G0tensor(154)])
  call ol_merge_tensors(T0sum(39),[G0tensor(159)])
  call ol_merge_tensors(T0sum(40),[G0tensor(164)])
  call ol_merge_tensors(T0sum(41),[G0tensor(168)])
  call ol_merge_tensors(T0sum(42),[G0tensor(172)])
  call ol_merge_tensors(T0sum(43),[G0tensor(177)])
  call ol_merge_tensors(T0sum(44),[G0tensor(182)])
  call ol_merge_tensors(T0sum(45),[G0tensor(81)])
  call ol_merge_tensors(T0sum(46),[G0tensor(187)])
  call ol_merge_tensors(T0sum(47),[G0tensor(3)])
  call ol_merge_tensors(T0sum(48),[G0tensor(192)])
  call ol_merge_tensors(T0sum(49),[G0tensor(197)])
  call ol_merge_tensors(T0sum(50),[G0tensor(5)])
  call ol_merge_tensors(T0sum(51),[G0tensor(202)])
  call ol_merge_tensors(T0sum(52),[G0tensor(207)])
  call ol_merge_tensors(T0sum(53),[G0tensor(19)])
  call ol_merge_tensors(T0sum(54),[G0tensor(212)])
  call ol_merge_tensors(T0sum(55),[G0tensor(217)])
  call ol_merge_tensors(T0sum(56),[G0tensor(52)])
  call ol_merge_tensors(T0sum(57),[G0tensor(222)])
  call ol_merge_tensors(T0sum(58),[G0tensor(227)])
  call ol_merge_tensors(T0sum(59),[G0tensor(20)])
  call ol_merge_tensors(T0sum(60),[G0tensor(45)])
  call ol_merge_tensors(T0sum(61),[G0tensor(37)])
  call ol_merge_tensors(T0sum(62),[G0tensor(38)])
  call ol_merge_tensors(T0sum(63),[G0tensor(74)])
  call ol_merge_tensors(T0sum(64),[G0tensor(54)])
  call ol_merge_tensors(T0sum(65),[G0tensor(63)])
  Gcoeff(:)%j = (c(31)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[10,5],[nME,nME],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,27),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(16),n2h4(40))
  Gcoeff(:)%j = (c(31)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[10,5],[nMM,nMM],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,28),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMM,G1H4(25),n2h4(41))
  Gcoeff(:)%j = (c(31)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[10,5],[nML,nML],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,29),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(1),10,nML,G1H4(9),n2h4(42))
  Gcoeff(:)%j = (c(30)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[10,5],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,30),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(10),n2h4(43))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[10,5],[nMT,nMT],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,31),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(11),n2h4(44))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[10,5],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,32),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(13),n2h4(45))
  Gcoeff(:)%j = (c(26)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[10,5],[nMB,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,33),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(22),n2h4(46))
  Gcoeff(:)%j = (-(c(33)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[10,5],[nME,nME],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,34),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(23),n2h4(47))
  Gcoeff(:)%j = (-(c(33)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[10,5],[nMM,nMM],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,35),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMM,G1H4(24),n2h4(48))
  Gcoeff(:)%j = (-(c(33)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[10,5],[nML,nML],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,36),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(1),10,nML,G1H4(26),n2h4(49))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[10,5],[0,0],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,37),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(8),n2h4(50))
  Gcoeff(:)%j = (c(32)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[10,5],[nMT,nMT],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,38),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(5),n2h4(51))
  Gcoeff(:)%j = (-(c(32)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[10,5],[0,0],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,39),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(4),n2h4(52))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[10,5],[nMB,nMB],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,40),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(1),n2h4(53))
  Gcoeff(:)%j = (-(c(33)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[10,5],[nME,nME],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,41),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(6),n2h4(54))
  Gcoeff(:)%j = (-(c(33)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[10,5],[nMM,nMM],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,42),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMM,G1H4(2),n2h4(55))
  Gcoeff(:)%j = (-(c(33)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[10,5],[nML,nML],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,43),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G0H4(1),10,nML,G1H4(7),n2h4(56))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[10,5],[0,0],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,44),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(3),n2h4(57))
  Gcoeff(:)%j = (c(32)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[10,5],[nMT,nMT],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,45),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(12),n2h4(58))
  Gcoeff(:)%j = (-(c(32)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[10,5],[0,0],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,46),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(21),n2h4(59))
  Gcoeff(:)%j = (-(c(29)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[10,5],[nMB,nMB],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,47),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(18),n2h4(60))
  Gcoeff(:)%j = (c(38)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZn,m3h4x4(:,48),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(17),n2h4(61))
  Gcoeff(:)%j = (c(35)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[10,5],[nME,nME],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,49),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(1),10,nME,G1H4(14),n2h4(62))
  Gcoeff(:)%j = (c(35)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[10,5],[nMM,nMM],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,50),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMM,G1H4(19),n2h4(63))
  Gcoeff(:)%j = (c(35)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[10,5],[nML,nML],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZl,m3h4x4(:,51),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G0H4(1),10,nML,G1H4(15),n2h4(64))
  Gcoeff(:)%j = (c(37)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,52),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(20),n2h4(65))
  Gcoeff(:)%j = (c(36)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[10,5],[nMT,nMT],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,53),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMT,G1H4(27),n2h4(66))
  Gcoeff(:)%j = (c(37)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,54),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G0H4(1),10,0,G1H4(28),n2h4(67))
  Gcoeff(:)%j = (c(36)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[10,5],[nMB,nMB],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZd,m3h4x4(:,55),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G0H4(1),10,nMB,G1H4(29),n2h4(68))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(30),m3h4x4(:,56),heltab2x16(:,:,116))
  Gcoeff(:)%j = (c(24)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(31),m3h4x4(:,57),heltab2x16(:,:,117))
  Gcoeff(:)%j = (c(24)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(32),m3h4x4(:,58),heltab2x16(:,:,118))
  Gcoeff(:)%j = (c(16)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[10,5],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(33),m3h4x4(:,59),heltab2x16(:,:,119))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(34),m3h4x4(:,60),heltab2x16(:,:,120))
  Gcoeff(:)%j = (c(2)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(35),m3h4x4(:,61),heltab2x16(:,:,121))
  Gcoeff(:)%j = (c(2)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(36),m3h4x4(:,62),heltab2x16(:,:,122))
  Gcoeff(:)%j = (c(21)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(37),m3h4x4(:,63),heltab2x16(:,:,123))
  Gcoeff(:)%j = (c(21)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(38),m3h4x4(:,64),heltab2x16(:,:,124))
  Gcoeff(:)%j = (c(21)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(39),m3h4x4(:,65),heltab2x16(:,:,125))
  Gcoeff(:)%j = (c(21)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(40),m3h4x4(:,66),heltab2x16(:,:,126))
  Gcoeff(:)%j = (c(17)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(41),m3h4x4(:,67),heltab2x16(:,:,127))
  Gcoeff(:)%j = (c(17)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(42),m3h4x4(:,68),heltab2x16(:,:,128))
  Gcoeff(:)%j = (-(c(2)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(43),m3h4x4(:,69),heltab2x16(:,:,129))
  Gcoeff(:)%j = (-(c(21)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(44),m3h4x4(:,70),heltab2x16(:,:,130))
  Gcoeff(:)%j = (-(c(21)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),10,G1H4(45),m3h4x4(:,71),heltab2x16(:,:,131))
  Gcoeff(:)%j = (-(c(17)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(46),m3h4x4(:,72),heltab2x16(:,:,132))
  Gcoeff(:)%j = (c(10)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,73),heltab2x16(:,:,133))
  Gcoeff(:)%j = (c(10)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(2),m3h4x4(:,74),heltab2x16(:,:,134))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(135),h0tab(:,135),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,4),G0H4(3),m3h4x4(:,75),heltab2x16(:,:,135))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,4),G0H4(4),m3h4x4(:,76),heltab2x16(:,:,136))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(137),h0tab(:,137),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(5),m3h4x4(:,77),heltab2x16(:,:,137))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[10,5],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,2),G0H4(6),m3h4x4(:,78),heltab2x16(:,:,138))
  Gcoeff(:)%j = (c(20)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[10,5],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,4),G0H4(7),m3h4x4(:,79),heltab2x16(:,:,139))
  Gcoeff(:)%j = (c(23)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,4),G0H4(8),m3h4x4(:,80),heltab2x16(:,:,140))
  Gcoeff(:)%j = (c(23)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[10,5],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,4),G0H4(9),m3h4x4(:,81),heltab2x16(:,:,141))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[9,6],[nME,nME],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,82),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(10),9,nME,G1H4(47),n2h4(69))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[9,6],[nMM,nMM],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,83),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMM,G1H4(48),n2h4(70))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[9,6],[nML,nML],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,84),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(10),9,nML,G1H4(49),n2h4(71))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[9,6],[0,0],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,85),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(50),n2h4(72))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[9,6],[nMT,nMT],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,86),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMT,G1H4(51),n2h4(73))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[9,6],[0,0],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,87),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(52),n2h4(74))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[9,6],[nMB,nMB],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,88),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMB,G1H4(53),n2h4(75))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[9,6],[nME,nME],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,89),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(10),9,nME,G1H4(54),n2h4(76))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[9,6],[nMM,nMM],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,90),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMM,G1H4(55),n2h4(77))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[9,6],[nML,nML],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,91),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G0H4(10),9,nML,G1H4(56),n2h4(78))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[9,6],[0,0],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,92),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(57),n2h4(79))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[9,6],[nMT,nMT],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,93),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMT,G1H4(58),n2h4(80))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[9,6],[0,0],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,94),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(59),n2h4(81))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[9,6],[nMB,nMB],2,2,wf4(:,5),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,95),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMB,G1H4(60),n2h4(82))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[9,6],[nME,nME],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZl,m3h4x4(:,96),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G0H4(10),9,nME,G1H4(61),n2h4(83))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[9,6],[nMM,nMM],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZl,m3h4x4(:,97),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMM,G1H4(62),n2h4(84))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[9,6],[nML,nML],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZl,m3h4x4(:,98),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G0H4(10),9,nML,G1H4(63),n2h4(85))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[9,6],[0,0],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZu,m3h4x4(:,99),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(64),n2h4(86))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[9,6],[nMT,nMT],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZu,m3h4x4(:,100),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMT,G1H4(65),n2h4(87))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[9,6],[0,0],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZd,m3h4x4(:,101),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(66),n2h4(88))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[9,6],[nMB,nMB],2,2,wf4(:,7),wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZd,m3h4x4(:,102),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMB,G1H4(67),n2h4(89))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[9,6],[0,0],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZn,m3h4x4(:,103),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(68),n2h4(90))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[9,6],[nME,nME],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZl,m3h4x4(:,104),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G0H4(10),9,nME,G1H4(69),n2h4(91))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[9,6],[nMM,nMM],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZl,m3h4x4(:,105),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMM,G1H4(70),n2h4(92))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[9,6],[nML,nML],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZl,m3h4x4(:,106),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G0H4(10),9,nML,G1H4(71),n2h4(93))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[9,6],[0,0],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZu,m3h4x4(:,107),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(72),n2h4(94))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[9,6],[nMT,nMT],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZu,m3h4x4(:,108),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMT,G1H4(73),n2h4(95))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[9,6],[0,0],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZd,m3h4x4(:,109),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G0H4(10),9,0,G1H4(74),n2h4(96))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[9,6],[nMB,nMB],2,2,wf4(:,7),wf4(:,8))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,7),G0H4(10),ngZd,m3h4x4(:,110),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMB,G1H4(75),n2h4(97))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(76),m3h4x4(:,111),heltab2x16(:,:,171))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(77),m3h4x4(:,112),heltab2x16(:,:,172))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,6))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(78),m3h4x4(:,113),heltab2x16(:,:,173))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[9,6],[nMZ,nMH],2,2,wf4(:,7),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(79),m3h4x4(:,114),heltab2x16(:,:,174))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(80),m3h4x4(:,115),heltab2x16(:,:,175))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(81),m3h4x4(:,116),heltab2x16(:,:,176))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(82),m3h4x4(:,117),heltab2x16(:,:,177))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(83),m3h4x4(:,118),heltab2x16(:,:,178))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(84),m3h4x4(:,119),heltab2x16(:,:,179))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(180),h0tab(:,180),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(85),m3h4x4(:,120),heltab2x16(:,:,180))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(86),m3h4x4(:,121),heltab2x16(:,:,181))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(87),m3h4x4(:,122),heltab2x16(:,:,182))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(88),m3h4x4(:,123),heltab2x16(:,:,183))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(89),m3h4x4(:,124),heltab2x16(:,:,184))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(90),m3h4x4(:,125),heltab2x16(:,:,185))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(91),m3h4x4(:,126),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,7),9,G1H4(92),m3h4x4(:,127),heltab2x16(:,:,187))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,128),heltab2x16(:,:,188))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,5),G0H4(11),m3h4x4(:,129),heltab2x16(:,:,189))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,5),G0H4(12),m3h4x4(:,130),heltab2x16(:,:,190))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[9,6],[nMW,nMW],2,2,wf4(:,5),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,5),G0H4(13),m3h4x4(:,131),heltab2x16(:,:,191))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,7),G0H4(14),m3h4x4(:,132),heltab2x16(:,:,192))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,6))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,7),G0H4(15),m3h4x4(:,133),heltab2x16(:,:,193))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[9,6],[nMZ,nMH],2,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,7),G0H4(16),m3h4x4(:,134),heltab2x16(:,:,194))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,7),G0H4(17),m3h4x4(:,135),heltab2x16(:,:,195))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(196),h0tab(:,196),[9,6],[nMW,nMW],2,2,wf4(:,7),wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,7),G0H4(18),m3h4x4(:,136),heltab2x16(:,:,196))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(8),G1H4(13),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(37),G1H4(36),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(41),G1H4(40),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(4),[G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(9),[G0H4(8),G0H4(6),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(64),G1H4(52),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(85),G1H4(82),G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(87),G1H4(84),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(15),[G0H4(14),G0H4(11),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(18),[G0H4(17),G0H4(13),G0H4(12)])
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,1),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(9),n2h1(24))
  call Hloop_QV_A(ntryL,G1H4(24),wf4(:,1),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(8),n2h1(25))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,1),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(14),n2h1(26))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,1),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(27))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(15),n2h1(28))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(29))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,23),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(2),n2h1(30))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,24),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(6),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,3),G1H1(1),ngZl,m3h4x1(:,25),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(21),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,26),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,3),G1H1(1),ngZu,m3h4x1(:,27),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(17),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H4(28),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,28),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,29),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(12),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,3),G1H1(1),ngZn,m3h4x1(:,30),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(24),n2h1(37))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(31),10,wf4(:,1),5,G2tensor(13),m3h4x1(:,31),heltab2x4(:,:,57))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(34),10,wf4(:,3),5,G2tensor(22),m3h4x1(:,32),heltab2x4(:,:,58))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(33),10,wf4(:,3),5,G2tensor(23),m3h4x1(:,33),heltab2x4(:,:,59))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(38),10,wf4(:,1),5,G2tensor(16),m3h4x1(:,34),heltab2x4(:,:,60))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(42),10,wf4(:,3),5,G2tensor(4),m3h4x1(:,35),heltab2x4(:,:,61))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(44),10,wf4(:,1),5,G2tensor(5),m3h4x1(:,36),heltab2x4(:,:,62))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(46),10,wf4(:,3),5,G2tensor(7),m3h4x1(:,37),heltab2x4(:,:,63))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(4),wf4(:,1),G0tensor(69),m3h4x1(:,38),heltab2x4(:,:,64))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(9),wf4(:,3),G0tensor(1),m3h4x1(:,39),heltab2x4(:,:,65))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(7),wf4(:,3),G0tensor(78),m3h4x1(:,40),heltab2x4(:,:,66))
  call Hloop_QV_A(ntryL,G1H4(61),wf4(:,6),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(18),n2h1(38))
  call Hloop_QV_A(ntryL,G1H4(62),wf4(:,6),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(19),n2h1(39))
  call Hloop_QV_A(ntryL,G1H4(63),wf4(:,6),G1H1(1),m3h4x1(:,43),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(20),n2h1(40))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,6),G1H1(1),m3h4x1(:,44),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(25),n2h1(41))
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,6),G1H1(1),m3h4x1(:,45),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(26),n2h1(42))
  call Hloop_QV_A(ntryL,G1H4(67),wf4(:,6),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(27),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H4(69),wf4(:,8),G1H1(1),ngZl,m3h4x1(:,47),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(28),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H4(70),wf4(:,8),G1H1(1),ngZl,m3h4x1(:,48),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(29),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H4(71),wf4(:,8),G1H1(1),ngZl,m3h4x1(:,49),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(30),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,50),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(31),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H4(73),wf4(:,8),G1H1(1),ngZu,m3h4x1(:,51),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(32),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,52),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(33),n2h1(49))
  call Hloop_QZ_A(ntryL,G1H4(75),wf4(:,8),G1H1(1),ngZd,m3h4x1(:,53),heltab2x4(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(34),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H4(68),wf4(:,8),G1H1(1),ngZn,m3h4x1(:,54),heltab2x4(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(35),n2h1(51))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(78),9,wf4(:,6),6,G2tensor(36),m3h4x1(:,55),heltab2x4(:,:,81))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(80),9,wf4(:,8),6,G2tensor(37),m3h4x1(:,56),heltab2x4(:,:,82))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(79),9,wf4(:,8),6,G2tensor(38),m3h4x1(:,57),heltab2x4(:,:,83))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(86),9,wf4(:,6),6,G2tensor(39),m3h4x1(:,58),heltab2x4(:,:,84))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(88),9,wf4(:,8),6,G2tensor(40),m3h4x1(:,59),heltab2x4(:,:,85))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(91),9,wf4(:,6),6,G2tensor(41),m3h4x1(:,60),heltab2x4(:,:,86))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(92),9,wf4(:,8),6,G2tensor(42),m3h4x1(:,61),heltab2x4(:,:,87))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(15),wf4(:,6),G0tensor(21),m3h4x1(:,62),heltab2x4(:,:,88))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(18),wf4(:,8),G0tensor(85),m3h4x1(:,63),heltab2x4(:,:,89))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(16),wf4(:,8),G0tensor(90),m3h4x1(:,64),heltab2x4(:,:,90))
  call ol_merge_tensors(G0tensor(135),[G0tensor(126),G0tensor(86),G0tensor(72),G0tensor(66),G0tensor(6)])
  call ol_merge_tensors(G0tensor(203),[G0tensor(165),G0tensor(146),G0tensor(107),G0tensor(83),G0tensor(51),G0tensor(11)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(11),G2tensor(3),G2tensor(10),G0tensor(228),G0tensor(208),G0tensor(169),G0tensor(33) &
    ,G0tensor(28),G0tensor(57),G0tensor(17),G0tensor(31),G0tensor(16)])
  call ol_merge_tensors(G0tensor(214),[G0tensor(184),G0tensor(170),G0tensor(166),G0tensor(130),G0tensor(127),G0tensor(96) &
    ,G0tensor(77),G0tensor(46),G0tensor(26)])
  call ol_merge_tensors(G0tensor(180),[G0tensor(171),G0tensor(152),G0tensor(113),G0tensor(84),G0tensor(76),G0tensor(36)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(33),G2tensor(31),G2tensor(25),G0tensor(195),G0tensor(175),G0tensor(167) &
    ,G0tensor(59),G0tensor(48),G0tensor(8),G0tensor(2),G0tensor(71),G0tensor(56)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(106),G0tensor(102),G0tensor(7)])
  call ol_merge_tensors(G0tensor(190),[G0tensor(185),G0tensor(70),G0tensor(67)])
  call ol_merge_tensors(G0tensor(221),[G0tensor(216),G0tensor(211),G0tensor(206),G0tensor(191),G0tensor(186),G0tensor(181) &
    ,G0tensor(176),G0tensor(163),G0tensor(158),G0tensor(153),G0tensor(148),G0tensor(143),G0tensor(138),G0tensor(133),G0tensor(124) &
    ,G0tensor(119),G0tensor(114),G0tensor(109),G0tensor(104),G0tensor(99),G0tensor(94),G0tensor(89),G0tensor(49),G0tensor(30) &
    ,G0tensor(12),G0tensor(42)])
  call ol_merge_tensors(G0tensor(47),[G0tensor(34)])
  call ol_merge_tensors(G0tensor(193),[G0tensor(65),G0tensor(24)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(5),G2tensor(4),G2tensor(16),G2tensor(22),G2tensor(13),G0tensor(1),G0tensor(69) &
    ,G0tensor(198),G0tensor(40),G0tensor(14)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(226),G0tensor(201),G0tensor(196),G0tensor(79),G0tensor(62),G0tensor(43) &
    ,G0tensor(35),G0tensor(50),G0tensor(18),G0tensor(29),G0tensor(4)])
  call ol_merge_tensors(G0tensor(200),[G0tensor(75),G0tensor(39)])
  call ol_merge_tensors(G0tensor(160),[G0tensor(150),G0tensor(140),G0tensor(9)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(213),G0tensor(58),G0tensor(10)])
  call ol_merge_tensors(G0tensor(27),[G0tensor(13)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(55),G0tensor(15)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(41),G2tensor(40),G2tensor(39),G2tensor(37),G2tensor(36),G0tensor(85),G0tensor(21) &
    ,G0tensor(225),G0tensor(68),G0tensor(22)])
  call ol_merge_tensors(G0tensor(230),[G0tensor(53),G0tensor(23)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(179),G0tensor(174),G0tensor(155),G0tensor(145),G0tensor(141),G0tensor(25)])
  call ol_merge_tensors(G0tensor(199),[G0tensor(194),G0tensor(64),G0tensor(32)])
  call ol_merge_tensors(G0tensor(229),[G0tensor(224),G0tensor(60),G0tensor(80)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(209),G0tensor(204),G0tensor(121),G0tensor(111),G0tensor(101),G0tensor(44)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(128),G0tensor(103),G0tensor(91),G0tensor(82),G0tensor(73)])
  call ol_merge_tensors(G0tensor(173),[G0tensor(156),G0tensor(131),G0tensor(117),G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(97),G0tensor(88)])
  call ol_merge_tensors(G0tensor(210),[G0tensor(162),G0tensor(137),G0tensor(123),G0tensor(98),G0tensor(93)])
  call ol_merge_tensors(G0tensor(183),[G0tensor(112),G0tensor(108)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(122),G0tensor(118)])
  call ol_merge_tensors(G0tensor(205),[G0tensor(136),G0tensor(132)])
  call ol_merge_tensors(G0tensor(215),[G0tensor(151),G0tensor(147)])
  call ol_merge_tensors(G0tensor(220),[G0tensor(161),G0tensor(157)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(8)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(14)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(15)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(23),[G0tensor(78)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(18)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(19)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(20)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(26)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(27)])
  call ol_merge_tensors(G2tensor(38),[G0tensor(90)])
call TI_bubble_red(G2tensor(24),10,mass2set(:,1),G0tensor(95),M2L1R1)
call TI_bubble_red(G2tensor(35),9,mass2set(:,1),G0tensor(100),M2L1R1)
call TI_bubble_red(G2tensor(7),10,mass2set(:,2),G0tensor(105),M2L1R1,G0tensor(110))
call TI_bubble_red(G2tensor(42),9,mass2set(:,2),G0tensor(115),M2L1R1,G0tensor(120))
call TI_bubble_red(G2tensor(2),10,mass2set(:,3),G0tensor(125),M2L1R1,G0tensor(41))
call TI_bubble_red(G2tensor(6),10,mass2set(:,4),G0tensor(61),M2L1R1,G0tensor(129))
call TI_bubble_red(G2tensor(21),10,mass2set(:,5),G0tensor(134),M2L1R1,G0tensor(139))
call TI_bubble_red(G2tensor(17),10,mass2set(:,6),G0tensor(144),M2L1R1,G0tensor(149))
call TI_bubble_red(G2tensor(12),10,mass2set(:,7),G0tensor(154),M2L1R1,G0tensor(159))
call TI_bubble_red(G2tensor(23),10,mass2set(:,8),G0tensor(164),M2L1R1,G0tensor(168),G0tensor(172))
call TI_bubble_red(G2tensor(28),9,mass2set(:,3),G0tensor(177),M2L1R1,G0tensor(182))
call TI_bubble_red(G2tensor(29),9,mass2set(:,4),G0tensor(81),M2L1R1,G0tensor(187))
call TI_bubble_red(G2tensor(30),9,mass2set(:,5),G0tensor(3),M2L1R1,G0tensor(192))
call TI_bubble_red(G2tensor(32),9,mass2set(:,6),G0tensor(197),M2L1R1,G0tensor(5))
call TI_bubble_red(G2tensor(34),9,mass2set(:,7),G0tensor(202),M2L1R1,G0tensor(207))
call TI_bubble_red(G2tensor(38),9,mass2set(:,9),G0tensor(19),M2L1R1,G0tensor(212),G0tensor(217))
  call ol_merge_tensors(G0tensor(217),[G0tensor(168),G0tensor(221)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(231),G0tensor(110)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(41)])
  call ol_merge_tensors(G0tensor(187),[G0tensor(129)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(139)])
  call ol_merge_tensors(G0tensor(5),[G0tensor(149)])
  call ol_merge_tensors(G0tensor(207),[G0tensor(159)])
  call ol_merge_tensors(G0tensor(212),[G0tensor(172)])
  call ol_merge_tensors(T0sum(66),[G0tensor(135)])
  call ol_merge_tensors(T0sum(67),[G0tensor(203)])
  call ol_merge_tensors(T0sum(68),[G0tensor(95)])
  call ol_merge_tensors(T0sum(69),[G0tensor(214)])
  call ol_merge_tensors(T0sum(70),[G0tensor(180)])
  call ol_merge_tensors(T0sum(71),[G0tensor(100)])
  call ol_merge_tensors(T0sum(72),[G0tensor(116)])
  call ol_merge_tensors(T0sum(73),[G0tensor(190)])
  call ol_merge_tensors(T0sum(74),[G0tensor(217)])
  call ol_merge_tensors(T0sum(75),[G0tensor(47)])
  call ol_merge_tensors(T0sum(76),[G0tensor(193)])
  call ol_merge_tensors(T0sum(77),[G0tensor(105)])
  call ol_merge_tensors(T0sum(78),[G0tensor(120)])
  call ol_merge_tensors(T0sum(79),[G0tensor(200)])
  call ol_merge_tensors(T0sum(80),[G0tensor(160)])
  call ol_merge_tensors(T0sum(81),[G0tensor(218)])
  call ol_merge_tensors(T0sum(82),[G0tensor(27)])
  call ol_merge_tensors(T0sum(83),[G0tensor(223)])
  call ol_merge_tensors(T0sum(84),[G0tensor(115)])
  call ol_merge_tensors(T0sum(85),[G0tensor(230)])
  call ol_merge_tensors(T0sum(86),[G0tensor(189)])
  call ol_merge_tensors(T0sum(87),[G0tensor(199)])
  call ol_merge_tensors(T0sum(88),[G0tensor(229)])
  call ol_merge_tensors(T0sum(89),[G0tensor(219)])
  call ol_merge_tensors(T0sum(90),[G0tensor(142)])
  call ol_merge_tensors(T0sum(91),[G0tensor(173)])
  call ol_merge_tensors(T0sum(92),[G0tensor(178)])
  call ol_merge_tensors(T0sum(93),[G0tensor(210)])
  call ol_merge_tensors(T0sum(94),[G0tensor(183)])
  call ol_merge_tensors(T0sum(95),[G0tensor(188)])
  call ol_merge_tensors(T0sum(96),[G0tensor(205)])
  call ol_merge_tensors(T0sum(97),[G0tensor(215)])
  call ol_merge_tensors(T0sum(98),[G0tensor(220)])
  call ol_merge_tensors(T0sum(99),[G0tensor(125)])
  call ol_merge_tensors(T0sum(100),[G0tensor(182)])
  call ol_merge_tensors(T0sum(101),[G0tensor(61)])
  call ol_merge_tensors(T0sum(102),[G0tensor(187)])
  call ol_merge_tensors(T0sum(103),[G0tensor(134)])
  call ol_merge_tensors(T0sum(104),[G0tensor(192)])
  call ol_merge_tensors(T0sum(105),[G0tensor(144)])
  call ol_merge_tensors(T0sum(106),[G0tensor(5)])
  call ol_merge_tensors(T0sum(107),[G0tensor(154)])
  call ol_merge_tensors(T0sum(108),[G0tensor(207)])
  call ol_merge_tensors(T0sum(109),[G0tensor(164)])
  call ol_merge_tensors(T0sum(110),[G0tensor(212)])
  call ol_merge_tensors(T0sum(111),[G0tensor(177)])
  call ol_merge_tensors(T0sum(112),[G0tensor(81)])
  call ol_merge_tensors(T0sum(113),[G0tensor(3)])
  call ol_merge_tensors(T0sum(114),[G0tensor(197)])
  call ol_merge_tensors(T0sum(115),[G0tensor(202)])
  call ol_merge_tensors(T0sum(116),[G0tensor(19)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppjj_ew_uuuxux_3_/**/REALKIND
