
module ol_vamp_1_ppjj_gggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjj_gggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjj_gggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjj_gggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppjj_gggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppjj_gggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjj_gggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(9,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(10)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(9)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMT,nMT,nMT,nMT],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(10)*M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMT,nMT,nMT,nMT],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(9)*M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMB,nMB,nMB,nMB],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(10)*M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMB,nMB,nMB,nMB],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j)+c(5)*(-M(5,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j)+c(5)*(-M(5,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (-(c(10)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(12),n2h8(9))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,1,2,4],[nMT,nMT,nMT,nMT],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(13),n2h8(10))
  Gcoeff(:)%j = (-(c(10)*M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(14),n2h8(11))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,1,2,4],[nMT,nMT,nMT,nMT],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(15),n2h8(12))
  Gcoeff(:)%j = (-(c(10)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(16),n2h8(13))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,1,2,4],[nMB,nMB,nMB,nMB],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(17),n2h8(14))
  Gcoeff(:)%j = (-(c(10)*M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(18),n2h8(15))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,1,2,4],[nMB,nMB,nMB,nMB],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(19),n2h8(16))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j)+c(5)*(-M(4,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j)+c(5)*(-M(4,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(23),n2h8(17))
  Gcoeff(:)%j = (-(c(9)*M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,4,2],[nMT,nMT,nMT,nMT],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(24),n2h8(18))
  Gcoeff(:)%j = (-(c(10)*M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(25),n2h8(19))
  Gcoeff(:)%j = (-(c(9)*M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,4,2],[nMT,nMT,nMT,nMT],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(26),n2h8(20))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(27),n2h8(21))
  Gcoeff(:)%j = (-(c(9)*M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,1,4,2],[nMB,nMB,nMB,nMB],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(28),n2h8(22))
  Gcoeff(:)%j = (-(c(10)*M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(29),n2h8(23))
  Gcoeff(:)%j = (-(c(9)*M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,1,4,2],[nMB,nMB,nMB,nMB],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(30),n2h8(24))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j)+c(5)*(-M(6,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j-M(2,:)%j-M(3,:)%j)+c(5)*(-M(6,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(25)])
  call Hloop_QV_A(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),10,0,G2H4(1),n2h4(1))
  call Hloop_QV_A(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),10,nMT,G2H4(2),n2h4(2))
  call Hloop_AV_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),10,0,G2H4(3),n2h4(3))
  call Hloop_AV_Q(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),10,nMT,G2H4(4),n2h4(4))
  call Hloop_QV_A(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),10,nMB,G2H4(5),n2h4(5))
  call Hloop_AV_Q(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),10,nMB,G2H4(6),n2h4(6))
  call Hloop_CV_D(ntryL,G1H8(9),8,ex2(:),2,G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_DV_C(ntryL,G1H8(10),8,ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_UV_W(ntryL,G1H8(11),8,ex2(:),2,G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AV_Q(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),9,0,G2H4(10),n2h4(7))
  call Hloop_AV_Q(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),9,nMT,G2H4(11),n2h4(8))
  call Hloop_QV_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),9,0,G2H4(12),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(15),ex1(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),9,nMT,G2H4(13),n2h4(10))
  call Hloop_AV_Q(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),9,nMB,G2H4(14),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),9,nMB,G2H4(15),n2h4(12))
  call Hloop_DV_C(ntryL,G1H8(20),8,ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_CV_D(ntryL,G1H8(21),8,ex1(:),1,G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_UV_W(ntryL,G1H8(22),8,ex1(:),1,G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AV_Q(ntryL,G1H8(27),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),9,0,G2H4(19),n2h4(13))
  call Hloop_AV_Q(ntryL,G1H8(24),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),9,nMT,G2H4(20),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(29),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),9,0,G2H4(21),n2h4(15))
  call Hloop_QV_A(ntryL,G1H8(26),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),9,nMT,G2H4(22),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H8(28),ex1(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),9,nMB,G2H4(23),n2h4(17))
  call Hloop_QV_A(ntryL,G1H8(30),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),9,nMB,G2H4(24),n2h4(18))
  call Hloop_DV_C(ntryL,G1H8(31),8,ex1(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_CV_D(ntryL,G1H8(32),8,ex1(:),1,G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_UV_W(ntryL,G1H8(33),8,ex1(:),1,G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(1),mass4set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G0H4(1),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(1),mass4set(:,2),  & 
G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),G0H4(2),4)
  call HG1shiftOLR(G1H4(7),4,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,1),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G0H4(3),4)
  call HG1shiftOLR(G1H4(12),4,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(1),mass4set(:,2),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),G0H4(4),4)
  call HG1shiftOLR(G1H4(17),4,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(1),mass4set(:,3),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G0H4(5),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(1),mass4set(:,3),  & 
G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),G0H4(6),4)
  call HG1shiftOLR(G1H4(27),4,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(1),mass4set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G0H4(7),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(1),mass4set(:,1),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),G0H4(8),4)
  call HG1shiftOLR(G1H4(37),4,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(1),mass4set(:,1),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G0H4(9),4)
  call HG1shiftOLR(G1H4(42),4,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(2),mass4set(:,1),  & 
G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),G0H4(10),4)
  call HG1shiftOLR(G1H4(47),4,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(2),mass4set(:,2),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G0H4(11),4)
  call HG1shiftOLR(G1H4(52),4,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(2),mass4set(:,1),  & 
G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),G0H4(12),4)
  call HG1shiftOLR(G1H4(57),4,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(2),mass4set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G0H4(13),4)
  call HG1shiftOLR(G1H4(62),4,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(2),mass4set(:,3),  & 
G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),G0H4(14),4)
  call HG1shiftOLR(G1H4(67),4,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(2),mass4set(:,3),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G0H4(15),4)
  call HG1shiftOLR(G1H4(72),4,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(2),mass4set(:,1),  & 
G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),G0H4(16),4)
  call HG1shiftOLR(G1H4(77),4,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(2),mass4set(:,1),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G0H4(17),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(2),mass4set(:,1),  & 
G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),G0H4(18),4)
  call HG1shiftOLR(G1H4(87),4,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(3),mass4set(:,1),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G0H4(19),4)
  call HG1shiftOLR(G1H4(92),2,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(3),mass4set(:,2),  & 
G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),G0H4(20),4)
  call HG1shiftOLR(G1H4(97),2,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(3),mass4set(:,1),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G0H4(21),4)
  call HG1shiftOLR(G1H4(102),2,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(3),mass4set(:,2),  & 
G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),G0H4(22),4)
  call HG1shiftOLR(G1H4(107),2,4)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(3),mass4set(:,3),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G0H4(23),4)
  call HG1shiftOLR(G1H4(112),2,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(3),mass4set(:,3),  & 
G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),G0H4(24),4)
  call HG1shiftOLR(G1H4(117),2,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(3),mass4set(:,1),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G0H4(25),4)
  call HG1shiftOLR(G1H4(122),2,4)
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(3),mass4set(:,1),  & 
G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),G0H4(26),4)
  call HG1shiftOLR(G1H4(127),2,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(3),mass4set(:,1),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G0H4(27),4)
  call HG1shiftOLR(G1H4(132),2,4)
  call Hloop_QV_A(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-4,0,G2H4(1),n2h4(19))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QV_A(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(3),n2h2(2))
  call Hloop_QV_A(ntryL,G1H4(5),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(4),n2h2(3))
  call Hloop_QV_A(ntryL,G0H4(1),ex1(:),G0H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G0H2(1),11,0,G1H2(1),n2h2(4))
  call Hloop_QV_A(ntryL,G1H4(6),ex1(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(2),11,nMT,G2H2(5),n2h2(5))
call HGT_OLR(G1H4(7),1,1,4)
call HGT_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(7),-4,nMT,G2H4(2),n2h4(20))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(6),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QV_A(ntryL,G1H4(9),ex1(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(2),11,nMT,G2H2(7),n2h2(6))
  call Hloop_QV_A(ntryL,G1H4(10),ex1(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(2),11,nMT,G2H2(8),n2h2(7))
  call Hloop_QV_A(ntryL,G0H4(2),ex1(:),G0H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G0H2(1),11,nMT,G1H2(2),n2h2(8))
  call Hloop_AV_Q(ntryL,G1H4(11),ex1(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),11,0,G2H2(9),n2h2(9))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-4,0,G2H4(3),n2h4(21))
  call Hloop_QV_A(ntryL,G2H4(3),ex3(:),G2H2(10),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AV_Q(ntryL,G1H4(14),ex1(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(3),11,0,G2H2(11),n2h2(10))
  call Hloop_AV_Q(ntryL,G1H4(15),ex1(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(3),11,0,G2H2(12),n2h2(11))
  call Hloop_AV_Q(ntryL,G0H4(3),ex1(:),G0H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G0H2(1),11,0,G1H2(3),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H4(16),ex1(:),G1H2(4),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMT,G2H2(13),n2h2(13))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(17),-4,nMT,G2H4(4),n2h4(22))
  call Hloop_QV_A(ntryL,G2H4(4),ex3(:),G2H2(14),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AV_Q(ntryL,G1H4(19),ex1(:),G1H2(4),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMT,G2H2(15),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H4(20),ex1(:),G1H2(4),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMT,G2H2(16),n2h2(15))
  call Hloop_AV_Q(ntryL,G0H4(4),ex1(:),G0H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G0H2(1),11,nMT,G1H2(4),n2h2(16))
  call Hloop_QV_A(ntryL,G1H4(21),ex1(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(5),11,nMB,G2H2(17),n2h2(17))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(22),-4,nMB,G2H4(5),n2h4(23))
  call Hloop_AV_Q(ntryL,G2H4(5),ex3(:),G2H2(18),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QV_A(ntryL,G1H4(24),ex1(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),11,nMB,G2H2(19),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(25),ex1(:),G1H2(5),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(5),11,nMB,G2H2(20),n2h2(19))
  call Hloop_QV_A(ntryL,G0H4(5),ex1(:),G0H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G0H2(1),11,nMB,G1H2(5),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H4(26),ex1(:),G1H2(6),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(21),n2h2(21))
call HGT_OLR(G1H4(27),1,1,4)
call HGT_invQ_OLR(G1H4(27),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(27),-4,nMB,G2H4(6),n2h4(24))
  call Hloop_QV_A(ntryL,G2H4(6),ex3(:),G2H2(22),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AV_Q(ntryL,G1H4(29),ex1(:),G1H2(6),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(23),n2h2(22))
  call Hloop_AV_Q(ntryL,G1H4(30),ex1(:),G1H2(6),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(24),n2h2(23))
  call Hloop_AV_Q(ntryL,G0H4(6),ex1(:),G0H2(1),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G0H2(1),11,nMB,G1H2(6),n2h2(24))
  call Hloop_CV_D(ntryL,G1H4(31),10,ex1(:),1,G2H2(25),m3h2x2(:,31),heltab2x4(:,:,31))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(32),-4,ex3(:),G2H2(26),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_CV_D(ntryL,G1H4(34),10,ex1(:),1,G2H2(27),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_CV_D(ntryL,G1H4(35),10,ex1(:),1,G2H2(28),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_CV_D(ntryL,G0H4(7),10,ex1(:),1,G1H2(7),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_DV_C(ntryL,G1H4(36),10,ex1(:),G2H2(29),m3h2x2(:,36),heltab2x4(:,:,36))
call HGT_OLR(G1H4(37),1,1,4)
call HGT_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(37),-4,ex3(:),4,G2H2(30),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_DV_C(ntryL,G1H4(39),10,ex1(:),G2H2(31),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_DV_C(ntryL,G1H4(40),10,ex1(:),G2H2(32),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_DV_C(ntryL,G0H4(8),10,ex1(:),G1H2(8),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_UV_W(ntryL,G1H4(41),10,ex1(:),1,G2H2(33),m3h2x2(:,41),heltab2x4(:,:,41))
call HGT_raise_alpha_OLR(G1H4(42),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(42),-4,ex3(:),4,G2H2(34),m3h2x2(:,42),heltab2x4(:,:,42))
call signflip_OLR(G2H2(34))
  call Hloop_UV_W(ntryL,G1H4(44),10,ex1(:),1,G2H2(35),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_UV_W(ntryL,G1H4(45),10,ex1(:),1,G2H2(36),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_UV_W(ntryL,G0H4(9),10,ex1(:),1,G1H2(9),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AV_Q(ntryL,G1H4(46),ex2(:),G1H2(10),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(10),11,0,G2H2(37),n2h2(25))
call HGT_OLR(G1H4(47),1,1,4)
call HGT_invQ_OLR(G1H4(47),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(47),-4,0,G2H4(7),n2h4(28))
  call Hloop_QV_A(ntryL,G2H4(7),ex3(:),G2H2(38),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AV_Q(ntryL,G1H4(49),ex2(:),G1H2(10),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(10),11,0,G2H2(39),n2h2(26))
  call Hloop_AV_Q(ntryL,G1H4(50),ex2(:),G1H2(10),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(10),11,0,G2H2(40),n2h2(27))
  call Hloop_AV_Q(ntryL,G0H4(10),ex2(:),G0H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G0H2(1),11,0,G1H2(10),n2h2(28))
  call Hloop_AV_Q(ntryL,G1H4(51),ex2(:),G1H2(11),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMT,G2H2(41),n2h2(29))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(52),-4,nMT,G2H4(8),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(8),ex3(:),G2H2(42),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AV_Q(ntryL,G1H4(54),ex2(:),G1H2(11),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMT,G2H2(43),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H4(55),ex2(:),G1H2(11),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMT,G2H2(44),n2h2(31))
  call Hloop_AV_Q(ntryL,G0H4(11),ex2(:),G0H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G0H2(1),11,nMT,G1H2(11),n2h2(32))
  call Hloop_QV_A(ntryL,G1H4(56),ex2(:),G1H2(12),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(12),11,0,G2H2(45),n2h2(33))
call HGT_OLR(G1H4(57),1,1,4)
call HGT_invQ_OLR(G1H4(57),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(57),-4,0,G2H4(9),n2h4(30))
  call Hloop_AV_Q(ntryL,G2H4(9),ex3(:),G2H2(46),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QV_A(ntryL,G1H4(59),ex2(:),G1H2(12),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(12),11,0,G2H2(47),n2h2(34))
  call Hloop_QV_A(ntryL,G1H4(60),ex2(:),G1H2(12),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(12),11,0,G2H2(48),n2h2(35))
  call Hloop_QV_A(ntryL,G0H4(12),ex2(:),G0H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G0H2(1),11,0,G1H2(12),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(61),ex2(:),G1H2(13),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(13),11,nMT,G2H2(49),n2h2(37))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-4,nMT,G2H4(10),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(10),ex3(:),G2H2(50),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QV_A(ntryL,G1H4(64),ex2(:),G1H2(13),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(13),11,nMT,G2H2(51),n2h2(38))
  call Hloop_QV_A(ntryL,G1H4(65),ex2(:),G1H2(13),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(13),11,nMT,G2H2(52),n2h2(39))
  call Hloop_QV_A(ntryL,G0H4(13),ex2(:),G0H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G0H2(1),11,nMT,G1H2(13),n2h2(40))
  call Hloop_AV_Q(ntryL,G1H4(66),ex2(:),G1H2(14),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(14),11,nMB,G2H2(53),n2h2(41))
call HGT_OLR(G1H4(67),1,1,4)
call HGT_invQ_OLR(G1H4(67),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(67),-4,nMB,G2H4(11),n2h4(32))
  call Hloop_QV_A(ntryL,G2H4(11),ex3(:),G2H2(54),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_AV_Q(ntryL,G1H4(69),ex2(:),G1H2(14),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(14),11,nMB,G2H2(55),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H4(70),ex2(:),G1H2(14),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(14),11,nMB,G2H2(56),n2h2(43))
  call Hloop_AV_Q(ntryL,G0H4(14),ex2(:),G0H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G0H2(1),11,nMB,G1H2(14),n2h2(44))
  call Hloop_QV_A(ntryL,G1H4(71),ex2(:),G1H2(15),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(15),11,nMB,G2H2(57),n2h2(45))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(72),-4,nMB,G2H4(12),n2h4(33))
  call Hloop_AV_Q(ntryL,G2H4(12),ex3(:),G2H2(58),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QV_A(ntryL,G1H4(74),ex2(:),G1H2(15),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(15),11,nMB,G2H2(59),n2h2(46))
  call Hloop_QV_A(ntryL,G1H4(75),ex2(:),G1H2(15),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(15),11,nMB,G2H2(60),n2h2(47))
  call Hloop_QV_A(ntryL,G0H4(15),ex2(:),G0H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G0H2(1),11,nMB,G1H2(15),n2h2(48))
  call Hloop_DV_C(ntryL,G1H4(76),9,ex2(:),G2H2(61),m3h2x2(:,76),heltab2x4(:,:,76))
call HGT_OLR(G1H4(77),1,1,4)
call HGT_invQ_OLR(G1H4(77),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(77),-4,ex3(:),4,G2H2(62),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_DV_C(ntryL,G1H4(79),9,ex2(:),G2H2(63),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_DV_C(ntryL,G1H4(80),9,ex2(:),G2H2(64),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_DV_C(ntryL,G0H4(16),9,ex2(:),G1H2(16),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_CV_D(ntryL,G1H4(81),9,ex2(:),2,G2H2(65),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(82),-4,ex3(:),G2H2(66),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_CV_D(ntryL,G1H4(84),9,ex2(:),2,G2H2(67),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_CV_D(ntryL,G1H4(85),9,ex2(:),2,G2H2(68),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_CV_D(ntryL,G0H4(17),9,ex2(:),2,G1H2(17),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_UV_W(ntryL,G1H4(86),9,ex2(:),2,G2H2(69),m3h2x2(:,86),heltab2x4(:,:,86))
call HGT_raise_alpha_OLR(G1H4(87),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(87),-4,ex3(:),4,G2H2(70),m3h2x2(:,87),heltab2x4(:,:,87))
call signflip_OLR(G2H2(70))
  call Hloop_UV_W(ntryL,G1H4(89),9,ex2(:),2,G2H2(71),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_UV_W(ntryL,G1H4(90),9,ex2(:),2,G2H2(72),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_UV_W(ntryL,G0H4(18),9,ex2(:),2,G1H2(18),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_AV_Q(ntryL,G1H4(91),ex3(:),G1H2(19),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(19),13,0,G2H2(73),n2h2(49))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(92),-2,0,G2H4(13),n2h4(37))
  call Hloop_QV_A(ntryL,G2H4(13),ex2(:),G2H2(74),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AV_Q(ntryL,G1H4(94),ex3(:),G1H2(19),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(19),13,0,G2H2(75),n2h2(50))
  call Hloop_AV_Q(ntryL,G1H4(95),ex3(:),G1H2(19),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(19),13,0,G2H2(76),n2h2(51))
  call Hloop_AV_Q(ntryL,G0H4(19),ex3(:),G0H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G0H2(1),13,0,G1H2(19),n2h2(52))
  call Hloop_AV_Q(ntryL,G1H4(96),ex3(:),G1H2(20),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(20),13,nMT,G2H2(77),n2h2(53))
call HGT_OLR(G1H4(97),1,1,4)
call HGT_invQ_OLR(G1H4(97),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(97),-2,nMT,G2H4(14),n2h4(38))
  call Hloop_QV_A(ntryL,G2H4(14),ex2(:),G2H2(78),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AV_Q(ntryL,G1H4(99),ex3(:),G1H2(20),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(20),13,nMT,G2H2(79),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H4(100),ex3(:),G1H2(20),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(20),13,nMT,G2H2(80),n2h2(55))
  call Hloop_AV_Q(ntryL,G0H4(20),ex3(:),G0H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G0H2(1),13,nMT,G1H2(20),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(101),ex3(:),G1H2(21),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(21),13,0,G2H2(81),n2h2(57))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(102),-2,0,G2H4(15),n2h4(39))
  call Hloop_AV_Q(ntryL,G2H4(15),ex2(:),G2H2(82),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(104),ex3(:),G1H2(21),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(21),13,0,G2H2(83),n2h2(58))
  call Hloop_QV_A(ntryL,G1H4(105),ex3(:),G1H2(21),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(21),13,0,G2H2(84),n2h2(59))
  call Hloop_QV_A(ntryL,G0H4(21),ex3(:),G0H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G0H2(1),13,0,G1H2(21),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(106),ex3(:),G1H2(22),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(22),13,nMT,G2H2(85),n2h2(61))
call HGT_OLR(G1H4(107),1,1,4)
call HGT_invQ_OLR(G1H4(107),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(107),-2,nMT,G2H4(16),n2h4(40))
  call Hloop_AV_Q(ntryL,G2H4(16),ex2(:),G2H2(86),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_QV_A(ntryL,G1H4(109),ex3(:),G1H2(22),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(22),13,nMT,G2H2(87),n2h2(62))
  call Hloop_QV_A(ntryL,G1H4(110),ex3(:),G1H2(22),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(22),13,nMT,G2H2(88),n2h2(63))
  call Hloop_QV_A(ntryL,G0H4(22),ex3(:),G0H2(1),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMT,G1H2(22),n2h2(64))
  call Hloop_AV_Q(ntryL,G1H4(111),ex3(:),G1H2(23),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(23),13,nMB,G2H2(89),n2h2(65))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(112),-2,nMB,G2H4(17),n2h4(41))
  call Hloop_QV_A(ntryL,G2H4(17),ex2(:),G2H2(90),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_AV_Q(ntryL,G1H4(114),ex3(:),G1H2(23),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(23),13,nMB,G2H2(91),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(115),ex3(:),G1H2(23),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(23),13,nMB,G2H2(92),n2h2(67))
  call Hloop_AV_Q(ntryL,G0H4(23),ex3(:),G0H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G0H2(1),13,nMB,G1H2(23),n2h2(68))
  call Hloop_QV_A(ntryL,G1H4(116),ex3(:),G1H2(24),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(24),13,nMB,G2H2(93),n2h2(69))
call HGT_OLR(G1H4(117),1,1,4)
call HGT_invQ_OLR(G1H4(117),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(117),-2,nMB,G2H4(18),n2h4(42))
  call Hloop_AV_Q(ntryL,G2H4(18),ex2(:),G2H2(94),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QV_A(ntryL,G1H4(119),ex3(:),G1H2(24),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(24),13,nMB,G2H2(95),n2h2(70))
  call Hloop_QV_A(ntryL,G1H4(120),ex3(:),G1H2(24),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(24),13,nMB,G2H2(96),n2h2(71))
  call Hloop_QV_A(ntryL,G0H4(24),ex3(:),G0H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(24),n2h2(72))
  call Hloop_DV_C(ntryL,G1H4(121),9,ex3(:),G2H2(97),m3h2x2(:,121),heltab2x4(:,:,121))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(122),-2,ex2(:),2,G2H2(98),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_DV_C(ntryL,G1H4(124),9,ex3(:),G2H2(99),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_DV_C(ntryL,G1H4(125),9,ex3(:),G2H2(100),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_DV_C(ntryL,G0H4(25),9,ex3(:),G1H2(25),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_CV_D(ntryL,G1H4(126),9,ex3(:),4,G2H2(101),m3h2x2(:,126),heltab2x4(:,:,126))
call HGT_OLR(G1H4(127),1,1,4)
call HGT_invQ_OLR(G1H4(127),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(127),-2,ex2(:),G2H2(102),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_CV_D(ntryL,G1H4(129),9,ex3(:),4,G2H2(103),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_CV_D(ntryL,G1H4(130),9,ex3(:),4,G2H2(104),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_CV_D(ntryL,G0H4(26),9,ex3(:),4,G1H2(26),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_UV_W(ntryL,G1H4(131),9,ex3(:),4,G2H2(105),m3h2x2(:,131),heltab2x4(:,:,131))
call HGT_raise_alpha_OLR(G1H4(132),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(132),-2,ex2(:),2,G2H2(106),m3h2x2(:,132),heltab2x4(:,:,132))
call signflip_OLR(G2H2(106))
  call Hloop_UV_W(ntryL,G1H4(134),9,ex3(:),4,G2H2(107),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_UV_W(ntryL,G1H4(135),9,ex3(:),4,G2H2(108),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_UV_W(ntryL,G0H4(27),9,ex3(:),4,G1H2(27),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(1),mass4set(:,1),  & 
G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(29),4,2)
  call Hloop_QV_A(ntryL,G2H2(4),ex3(:),G2H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(1),n2h1(1))
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(2))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(1),mass4set(:,2),  & 
G1H2(1),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(33),4,2)
  call Hloop_QV_A(ntryL,G2H2(8),ex3(:),G2H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(2),n2h1(3))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(2),n2h1(4))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(1),mass4set(:,1),  & 
G1H2(2),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(37),4,2)
  call Hloop_AV_Q(ntryL,G2H2(12),ex3(:),G2H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(3),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(6))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(1),mass4set(:,2),  & 
G1H2(3),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),4,2)
  call Hloop_AV_Q(ntryL,G2H2(16),ex3(:),G2H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(4),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(4),n2h1(8))
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(1),mass4set(:,3),  & 
G1H2(4),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(45),4,2)
  call Hloop_QV_A(ntryL,G2H2(20),ex3(:),G2H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(5),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(10))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(1),mass4set(:,3),  & 
G1H2(5),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(49),4,2)
  call Hloop_AV_Q(ntryL,G2H2(24),ex3(:),G2H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(6),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(6),n2h1(12))
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(1),mass4set(:,1),  & 
G1H2(6),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(53),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(28),11,ex3(:),4,G3tensor(7),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(7),11,ex3(:),4,G2tensor(7),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(57),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(32),11,ex3(:),G3tensor(8),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(8),11,ex3(:),G2tensor(8),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(1),mass4set(:,1),  & 
G1H2(8),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(61),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(36),11,ex3(:),4,G3tensor(9),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(9),11,ex3(:),4,G2tensor(9),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(2),mass4set(:,1),  & 
G1H2(9),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(65),4,2)
  call Hloop_AV_Q(ntryL,G2H2(40),ex3(:),G2H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(10),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(14))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(2),mass4set(:,2),  & 
G1H2(10),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(69),4,2)
  call Hloop_AV_Q(ntryL,G2H2(44),ex3(:),G2H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(11),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(11),n2h1(16))
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(2),mass4set(:,1),  & 
G1H2(11),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(73),4,2)
  call Hloop_QV_A(ntryL,G2H2(48),ex3(:),G2H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(12),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(18))
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(2),mass4set(:,2),  & 
G1H2(12),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(77),4,2)
  call Hloop_QV_A(ntryL,G2H2(52),ex3(:),G2H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(13),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(13),n2h1(20))
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(2),mass4set(:,3),  & 
G1H2(13),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(81),4,2)
  call Hloop_AV_Q(ntryL,G2H2(56),ex3(:),G2H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(14),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(22))
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(2),mass4set(:,3),  & 
G1H2(14),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(85),4,2)
  call Hloop_QV_A(ntryL,G2H2(60),ex3(:),G2H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(15),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(15),n2h1(24))
  call Hotf_4pt_reduction(G2H2(61),RedSet_4(2),mass4set(:,1),  & 
G1H2(15),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(89),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(64),11,ex3(:),G3tensor(16),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(16),11,ex3(:),G2tensor(16),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(2),mass4set(:,1),  & 
G1H2(16),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(93),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(68),11,ex3(:),4,G3tensor(17),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(17),11,ex3(:),4,G2tensor(17),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(2),mass4set(:,1),  & 
G1H2(17),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(97),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(72),11,ex3(:),4,G3tensor(18),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),11,ex3(:),4,G2tensor(18),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(3),mass4set(:,1),  & 
G1H2(18),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(101),2,2)
  call Hloop_AV_Q(ntryL,G2H2(76),ex2(:),G2H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(19),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(19),n2h1(26))
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(3),mass4set(:,2),  & 
G1H2(19),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(105),2,2)
  call Hloop_AV_Q(ntryL,G2H2(80),ex2(:),G2H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(20),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(20),n2h1(28))
  call Hotf_4pt_reduction(G2H2(81),RedSet_4(3),mass4set(:,1),  & 
G1H2(20),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(109),2,2)
  call Hloop_QV_A(ntryL,G2H2(84),ex2(:),G2H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(21),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(21),ex2(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(30))
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(3),mass4set(:,2),  & 
G1H2(21),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(113),2,2)
  call Hloop_QV_A(ntryL,G2H2(88),ex2(:),G2H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(22),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(22),n2h1(32))
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(3),mass4set(:,3),  & 
G1H2(22),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(117),2,2)
  call Hloop_AV_Q(ntryL,G2H2(92),ex2(:),G2H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(23),n2h1(33))
  call Hloop_AV_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(23),n2h1(34))
  call Hotf_4pt_reduction(G2H2(93),RedSet_4(3),mass4set(:,3),  & 
G1H2(23),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(121),2,2)
  call Hloop_QV_A(ntryL,G2H2(96),ex2(:),G2H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(24),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(24),n2h1(36))
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(3),mass4set(:,1),  & 
G1H2(24),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(125),2,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(100),13,ex2(:),G3tensor(25),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(25),13,ex2(:),G2tensor(25),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(3),mass4set(:,1),  & 
G1H2(25),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(129),2,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(104),13,ex2(:),2,G3tensor(26),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(26),13,ex2(:),2,G2tensor(26),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(3),mass4set(:,1),  & 
G1H2(26),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(133),2,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(108),13,ex2(:),2,G3tensor(27),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),13,ex2(:),2,G2tensor(27),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hloop_QV_A(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(28),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(29),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(30),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(31),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(32),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(36),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(33),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(34),n2h1(43))
  call Hloop_AV_Q(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(35),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(36),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(37),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(38),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(39),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(40),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(41),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(42),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(43),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(44),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(45),n2h1(54))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(6),11,ex3(:),4,G2tensor(46),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(53),0,ex3(:),4,G2tensor(47),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(56),11,ex3(:),4,G2tensor(48),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(7),11,ex3(:),G2tensor(49),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(57),0,ex3(:),G2tensor(50),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(60),11,ex3(:),G2tensor(51),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(8),11,ex3(:),4,G2tensor(52),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(61),0,ex3(:),4,G2tensor(53),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(64),11,ex3(:),4,G2tensor(54),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hloop_AV_Q(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(55),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(65),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(56),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(57),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(58),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(69),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(59),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(60),n2h1(63))
  call Hloop_QV_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(61),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(62),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(76),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(63),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(64),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(77),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(65),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(80),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(66),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(67),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(81),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(68),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(84),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(69),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(70),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(71),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(88),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(72),n2h1(75))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(15),11,ex3(:),G2tensor(73),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(89),0,ex3(:),G2tensor(74),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(92),11,ex3(:),G2tensor(75),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(16),11,ex3(:),4,G2tensor(76),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(93),0,ex3(:),4,G2tensor(77),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(96),11,ex3(:),4,G2tensor(78),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(17),11,ex3(:),4,G2tensor(79),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(97),0,ex3(:),4,G2tensor(80),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(100),11,ex3(:),4,G2tensor(81),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hloop_AV_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(82),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(101),ex2(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(83),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(104),ex2(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(84),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(85),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(105),ex2(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(86),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(108),ex2(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(87),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(88),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(109),ex2(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(89),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(112),ex2(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(90),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(21),ex2(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(91),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(113),ex2(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(92),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(116),ex2(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(93),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(94),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(117),ex2(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(95),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(120),ex2(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(96),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(97),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(121),ex2(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(98),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(124),ex2(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(99),n2h1(96))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(24),13,ex2(:),G2tensor(100),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(125),0,ex2(:),G2tensor(101),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(128),13,ex2(:),G2tensor(102),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(25),13,ex2(:),2,G2tensor(103),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(129),0,ex2(:),2,G2tensor(104),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(132),13,ex2(:),2,G2tensor(105),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(26),13,ex2(:),2,G2tensor(106),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(133),0,ex2(:),2,G2tensor(107),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(136),13,ex2(:),2,G2tensor(108),m3h2x1(:,135),heltab2x2(:,:,135))
  call ol_merge_tensors(G2tensor(9),[G2tensor(8),G2tensor(7),G2tensor(3),G2tensor(1)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(17),G2tensor(16),G2tensor(12),G2tensor(10)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(11)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(14)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(26),G2tensor(25),G2tensor(21),G2tensor(19)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(20)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(23)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(49),G2tensor(46),G2tensor(34),G2tensor(28)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(31)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(40)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(76),G2tensor(73),G2tensor(61),G2tensor(55)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(58)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(67)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(103),G2tensor(100),G2tensor(88),G2tensor(82)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(85)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(94)])
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G0tensor(1))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,2),  & 
G1tensor(1),G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G0tensor(2))
  call G_TensorShift(G1tensor(6),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(1),mass4set(:,3),  & 
G1tensor(1),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(13),G0tensor(3))
  call G_TensorShift(G1tensor(10),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G0tensor(4))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(2),mass4set(:,2),  & 
G1tensor(1),G1tensor(18),G1tensor(19),G1tensor(20),G1tensor(21),G0tensor(5))
  call G_TensorShift(G1tensor(18),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(2),mass4set(:,3),  & 
G1tensor(1),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25),G0tensor(6))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(3),mass4set(:,1),  & 
G1tensor(1),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G0tensor(7))
  call G_TensorShift(G1tensor(26),2)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(3),mass4set(:,2),  & 
G1tensor(1),G1tensor(30),G1tensor(31),G1tensor(32),G1tensor(33),G0tensor(8))
  call G_TensorShift(G1tensor(30),2)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(3),mass4set(:,3),  & 
G1tensor(1),G1tensor(34),G1tensor(35),G1tensor(36),G1tensor(37),G0tensor(9))
  call G_TensorShift(G1tensor(34),2)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(1),mass4set(:,2),  & 
G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46))
  call G_TensorShift(G1tensor(43),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(1),mass4set(:,3),  & 
G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50),G1tensor(51))
  call G_TensorShift(G1tensor(48),4)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(2),mass4set(:,1),  & 
G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55),G1tensor(56))
  call G_TensorShift(G1tensor(53),4)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(2),mass4set(:,2),  & 
G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60),G1tensor(61))
  call G_TensorShift(G1tensor(58),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(2),mass4set(:,3),  & 
G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(63),4)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(3),mass4set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(3),mass4set(:,2),  & 
G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76))
  call G_TensorShift(G1tensor(73),2)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(3),mass4set(:,3),  & 
G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80),G1tensor(81))
  call G_TensorShift(G1tensor(78),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(1),mass4set(:,2),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(1),mass4set(:,3),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(2),mass4set(:,1),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(2),mass4set(:,2),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(2),mass4set(:,3),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(67),RedSet_4(3),mass4set(:,1),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(72),RedSet_4(3),mass4set(:,2),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(77),RedSet_4(3),mass4set(:,3),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(2)])
  call ol_merge_tensors(T0sum(3),[G0tensor(3)])
  call ol_merge_tensors(T0sum(4),[G0tensor(4)])
  call ol_merge_tensors(T0sum(5),[G0tensor(5)])
  call ol_merge_tensors(T0sum(6),[G0tensor(6)])
  call ol_merge_tensors(T0sum(7),[G0tensor(7)])
  call ol_merge_tensors(T0sum(8),[G0tensor(8)])
  call ol_merge_tensors(T0sum(9),[G0tensor(9)])
  call ol_merge_tensors(T0sum(10),[G0tensor(10)])
  call ol_merge_tensors(T0sum(11),[G0tensor(15)])
  call ol_merge_tensors(T0sum(12),[G0tensor(20)])
  call ol_merge_tensors(T0sum(13),[G0tensor(25)])
  call ol_merge_tensors(T0sum(14),[G0tensor(30)])
  call ol_merge_tensors(T0sum(15),[G0tensor(35)])
  call ol_merge_tensors(T0sum(16),[G0tensor(40)])
  call ol_merge_tensors(T0sum(17),[G0tensor(45)])
  call ol_merge_tensors(T0sum(18),[G0tensor(50)])
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[12,1,2],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(1),m4h2x2x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[12,1,2],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(2),m4h2x2x4(:,2),heltab3x16(:,:,2))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[12,1,2],[0,0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(3),m4h2x2x4(:,3),heltab3x16(:,:,3))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[10,1,4],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(4),m4h2x2x4(:,4),heltab3x16(:,:,4))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[10,1,4],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),ex4(:),G0H4(5),m4h2x2x4(:,5),heltab3x16(:,:,5))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[10,1,4],[0,0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(6),m4h2x2x4(:,6),heltab3x16(:,:,6))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,1,6],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[8,1,6],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(3),m3h2x8(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[8,1,6],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(12),m3h2x8(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[9,2,4],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(7),m4h2x2x4(:,7),heltab3x16(:,:,7))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[9,2,4],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),ex4(:),G0H4(8),m4h2x2x4(:,8),heltab3x16(:,:,8))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[9,2,4],[0,0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(9),m4h2x2x4(:,9),heltab3x16(:,:,9))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[8,2,5],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(14),m3h2x8(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[8,2,5],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(23),m3h2x8(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[8,2,5],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(25),m3h2x8(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[8,3,4],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(5),m3h2x8(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(5)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[8,3,4],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(2),m3h2x8(:,41),heltab2x16(:,:,41))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[8,3,4],[0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(7),m3h2x8(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (c(8)*(M(4,:)%j-M(7,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(4),n2h8(25))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(7,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(6),n2h8(26))
  Gcoeff(:)%j = (c(8)*(M(5,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(8),n2h8(27))
  Gcoeff(:)%j = (c(7)*(M(5,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(9),n2h8(28))
  Gcoeff(:)%j = (c(8)*(M(4,:)%j-M(7,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(10),n2h8(29))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(7,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(11),n2h8(30))
  Gcoeff(:)%j = (c(8)*(M(5,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(16),n2h8(31))
  Gcoeff(:)%j = (c(7)*(M(5,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(13),n2h8(32))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(18),m3h2x8(:,51),heltab2x16(:,:,51))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(15),m3h2x8(:,52),heltab2x16(:,:,52))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(17),m3h2x8(:,53),heltab2x16(:,:,53))
  Gcoeff(:)%j = (c(8)*(-M(5,:)%j+M(6,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(19),n2h8(33))
  Gcoeff(:)%j = (c(7)*(-M(5,:)%j+M(6,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[8,2,5],[nMT,nMT,nMT],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(20),n2h8(34))
  Gcoeff(:)%j = (c(8)*(M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(21),n2h8(35))
  Gcoeff(:)%j = (c(7)*(M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[8,2,5],[nMT,nMT,nMT],3,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(22),n2h8(36))
  Gcoeff(:)%j = (c(8)*(-M(5,:)%j+M(6,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(27),n2h8(37))
  Gcoeff(:)%j = (c(7)*(-M(5,:)%j+M(6,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[8,2,5],[nMB,nMB,nMB],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(24),n2h8(38))
  Gcoeff(:)%j = (c(8)*(M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(29),n2h8(39))
  Gcoeff(:)%j = (c(7)*(M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[8,2,5],[nMB,nMB,nMB],3,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(26),n2h8(40))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(28),m3h2x8(:,62),heltab2x16(:,:,62))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(30),m3h2x8(:,63),heltab2x16(:,:,63))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(31),m3h2x8(:,64),heltab2x16(:,:,64))
  Gcoeff(:)%j = (c(8)*(M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(32),n2h8(41))
  Gcoeff(:)%j = (c(7)*(M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[8,1,6],[nMT,nMT,nMT],3,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(33),n2h8(42))
  Gcoeff(:)%j = (c(8)*(M(4,:)%j-M(6,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(34),n2h8(43))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(6,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[8,1,6],[nMT,nMT,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(35),n2h8(44))
  Gcoeff(:)%j = (c(8)*(M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(36),n2h8(45))
  Gcoeff(:)%j = (c(7)*(M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[8,1,6],[nMB,nMB,nMB],3,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(37),n2h8(46))
  Gcoeff(:)%j = (c(8)*(M(4,:)%j-M(6,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(38),n2h8(47))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(6,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[8,1,6],[nMB,nMB,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(39),n2h8(48))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(40),m3h2x8(:,73),heltab2x16(:,:,73))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(41),m3h2x8(:,74),heltab2x16(:,:,74))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[8,1,6],[0,0,0],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(42),m3h2x8(:,75),heltab2x16(:,:,75))
  Gcoeff(:)%j = (c(8)*(-M(4,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(10),m3h4x4(:,1),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(10),9,0,G1H4(1),n2h4(46))
  Gcoeff(:)%j = (c(7)*(-M(4,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[9,2,4],[nMT,nMT,nMT],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(11),m3h4x4(:,2),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(11),9,nMT,G1H4(2),n2h4(47))
  Gcoeff(:)%j = (c(8)*(-M(6,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(12),m3h4x4(:,3),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G0H4(12),9,0,G1H4(4),n2h4(48))
  Gcoeff(:)%j = (c(7)*(-M(6,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[9,2,4],[nMT,nMT,nMT],3,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(13),m3h4x4(:,4),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G0H4(13),9,nMT,G1H4(5),n2h4(49))
  Gcoeff(:)%j = (c(8)*(-M(4,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(14),m3h4x4(:,5),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(14),9,0,G1H4(6),n2h4(50))
  Gcoeff(:)%j = (c(7)*(-M(4,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[9,2,4],[nMB,nMB,nMB],3,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,5),G0H4(15),m3h4x4(:,6),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H4(15),9,nMB,G1H4(7),n2h4(51))
  Gcoeff(:)%j = (c(8)*(-M(6,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(16),m3h4x4(:,7),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H4(16),9,0,G1H4(9),n2h4(52))
  Gcoeff(:)%j = (c(7)*(-M(6,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[9,2,4],[nMB,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(17),m3h4x4(:,8),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(17),9,nMB,G1H4(10),n2h4(53))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,5),G1H4(11),m3h4x4(:,9),heltab2x16(:,:,84))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(12),m3h4x4(:,10),heltab2x16(:,:,85))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[9,2,4],[0,0,0],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(14),m3h4x4(:,11),heltab2x16(:,:,86))
  Gcoeff(:)%j = (c(8)*(M(6,:)%j-M(7,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,4),G0H4(18),m3h4x4(:,12),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G0H4(18),10,0,G1H4(15),n2h4(54))
  Gcoeff(:)%j = (c(7)*(M(6,:)%j-M(7,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[10,1,4],[nMT,nMT,nMT],3,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,4),G0H4(19),m3h4x4(:,13),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G0H4(19),10,nMT,G1H4(16),n2h4(55))
  Gcoeff(:)%j = (c(8)*(M(5,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(20),m3h4x4(:,14),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H4(20),10,0,G1H4(17),n2h4(56))
  Gcoeff(:)%j = (c(7)*(M(5,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[10,1,4],[nMT,nMT,nMT],3,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(21),m3h4x4(:,15),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H4(21),10,nMT,G1H4(19),n2h4(57))
  Gcoeff(:)%j = (c(8)*(M(6,:)%j-M(7,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,4),G0H4(22),m3h4x4(:,16),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G0H4(22),10,0,G1H4(20),n2h4(58))
  Gcoeff(:)%j = (c(7)*(M(6,:)%j-M(7,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[10,1,4],[nMB,nMB,nMB],3,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,4),G0H4(23),m3h4x4(:,17),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G0H4(23),10,nMB,G1H4(21),n2h4(59))
  Gcoeff(:)%j = (c(8)*(M(5,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(24),m3h4x4(:,18),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H4(24),10,0,G1H4(22),n2h4(60))
  Gcoeff(:)%j = (c(7)*(M(5,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[10,1,4],[nMB,nMB,nMB],3,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(25),m3h4x4(:,19),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(25),10,nMB,G1H4(24),n2h4(61))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,4),G1H4(25),m3h4x4(:,20),heltab2x16(:,:,95))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(26),m3h4x4(:,21),heltab2x16(:,:,96))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[10,1,4],[0,0,0],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(27),m3h4x4(:,22),heltab2x16(:,:,97))
  Gcoeff(:)%j = (c(8)*(M(4,:)%j-M(5,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(26),m3h4x4(:,23),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H4(26),12,0,G1H4(29),n2h4(62))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(5,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[12,1,2],[nMT,nMT,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(27),m3h4x4(:,24),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(27),12,nMT,G1H4(30),n2h4(63))
  Gcoeff(:)%j = (c(8)*(M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),m3h4x4(:,25),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(10),12,0,G1H4(31),n2h4(64))
  Gcoeff(:)%j = (c(7)*(M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[12,1,2],[nMT,nMT,nMT],3,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(11),m3h4x4(:,26),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(11),12,nMT,G1H4(32),n2h4(65))
  Gcoeff(:)%j = (c(8)*(M(4,:)%j-M(5,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(12),m3h4x4(:,27),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(12),12,0,G1H4(34),n2h4(66))
  Gcoeff(:)%j = (c(7)*(M(4,:)%j-M(5,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[12,1,2],[nMB,nMB,nMB],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(13),m3h4x4(:,28),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMB,G1H4(35),n2h4(67))
  Gcoeff(:)%j = (c(8)*(M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(14),m3h4x4(:,29),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(14),12,0,G1H4(36),n2h4(68))
  Gcoeff(:)%j = (c(7)*(M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[12,1,2],[nMB,nMB,nMB],3,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(15),m3h4x4(:,30),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(15),12,nMB,G1H4(37),n2h4(69))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,2),G1H4(39),m3h4x4(:,31),heltab2x16(:,:,106))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(40),m3h4x4(:,32),heltab2x16(:,:,107))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(41),m3h4x4(:,33),heltab2x16(:,:,108))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(17),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(15),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(43),G0H4(6),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(1),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(4),G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(88),G0H4(9),G0H4(8),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(31)])
  call Hloop_QV_A(ntryL,G1H4(22),ex1(:),G1H2(27),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(27),11,0,G2H2(1),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(19),ex1(:),G1H2(28),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(28),11,nMT,G2H2(4),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H4(20),ex1(:),G1H2(29),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(29),11,0,G2H2(5),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H4(16),ex1(:),G1H2(32),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(32),11,nMT,G2H2(8),n2h2(76))
  call Hloop_QV_A(ntryL,G1H4(24),ex1(:),G1H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(1),11,nMB,G2H2(9),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H4(21),ex1(:),G1H2(33),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(33),11,nMB,G2H2(12),n2h2(78))
  call Hloop_CV_D(ntryL,G1H4(26),10,ex1(:),1,G2H2(13),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_DV_C(ntryL,G1H4(25),10,ex1(:),G2H2(16),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_UV_W(ntryL,G1H4(27),10,ex1(:),1,G2H2(17),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_AV_Q(ntryL,G1H4(6),ex2(:),G1H2(36),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(36),11,0,G2H2(20),n2h2(79))
  call Hloop_AV_Q(ntryL,G1H4(2),ex2(:),G1H2(2),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(2),11,nMT,G2H2(21),n2h2(80))
  call Hloop_QV_A(ntryL,G1H4(9),ex2(:),G1H2(37),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(37),11,0,G2H2(24),n2h2(81))
  call Hloop_QV_A(ntryL,G1H4(5),ex2(:),G1H2(40),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(40),11,nMT,G2H2(25),n2h2(82))
  call Hloop_AV_Q(ntryL,G1H4(7),ex2(:),G1H2(3),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMB,G2H2(28),n2h2(83))
  call Hloop_QV_A(ntryL,G1H4(10),ex2(:),G1H2(41),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(41),11,nMB,G2H2(29),n2h2(84))
  call Hloop_DV_C(ntryL,G1H4(11),9,ex2(:),G2H2(32),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_CV_D(ntryL,G1H4(12),9,ex2(:),2,G2H2(33),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_UV_W(ntryL,G1H4(14),9,ex2(:),2,G2H2(36),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_AV_Q(ntryL,G1H4(93),ex3(:),G1H2(44),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(44),13,0,G2H2(37),n2h2(85))
  call Hloop_AV_Q(ntryL,G1H4(98),ex3(:),G1H2(4),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(4),13,nMT,G2H2(40),n2h2(86))
  call Hloop_QV_A(ntryL,G1H4(103),ex3(:),G1H2(45),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(45),13,0,G2H2(41),n2h2(87))
  call Hloop_QV_A(ntryL,G1H4(108),ex3(:),G1H2(48),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(48),13,nMT,G2H2(44),n2h2(88))
  call Hloop_AV_Q(ntryL,G1H4(113),ex3(:),G1H2(5),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(5),13,nMB,G2H2(45),n2h2(89))
  call Hloop_QV_A(ntryL,G1H4(118),ex3(:),G1H2(49),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(49),13,nMB,G2H2(48),n2h2(90))
  call Hloop_DV_C(ntryL,G1H4(123),9,ex3(:),G2H2(49),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_CV_D(ntryL,G1H4(128),9,ex3(:),4,G2H2(52),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_UV_W(ntryL,G1H4(133),9,ex3(:),4,G2H2(53),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_UV_W(ntryL,G1H4(41),12,ex1(:),1,G2H2(56),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_UV_W(ntryL,G1H8(1),8,ex1(:),1,G2H4(19),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_UV_W(ntryL,G1H8(3),8,ex1(:),1,G2H4(20),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_UV_W(ntryL,G1H8(12),8,ex1(:),1,G2H4(21),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_UV_W(ntryL,G1H8(14),8,ex2(:),2,G2H4(22),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_UV_W(ntryL,G1H8(23),8,ex2(:),2,G2H4(23),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_UV_W(ntryL,G1H8(25),8,ex2(:),2,G2H4(24),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_GGG_G_12(ntryL,G1H8(5),ex2(:),ex1(:),G1H2(52),m4h2x2x2(:,1),heltab3x8(:,:,1))
  call Hloop_GGG_G_12(ntryL,G1H8(2),ex1(:),ex2(:),G1H2(6),m4h2x2x2(:,2),heltab3x8(:,:,2))
  call Hloop_GGG_G_23(ntryL,G1H8(7),ex2(:),ex1(:),G1H2(53),m4h2x2x2(:,3),heltab3x8(:,:,3))
  call Hloop_AV_Q(ntryL,G1H8(10),wf4(:,1),G1H2(56),m3h4x2(:,1),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(56),11,0,G2H2(57),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,1),G1H2(7),m3h4x2(:,2),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMT,G2H2(60),n2h2(92))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(57),m3h4x2(:,3),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(57),11,0,G2H2(61),n2h2(93))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(60),m3h4x2(:,4),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(60),11,nMT,G2H2(64),n2h2(94))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,1),G1H2(8),m3h4x2(:,5),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMB,G2H2(65),n2h2(95))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,1),G1H2(61),m3h4x2(:,6),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(61),11,nMB,G2H2(68),n2h2(96))
  call Hloop_DV_C(ntryL,G1H8(18),8,wf4(:,1),G2H2(69),m3h4x2(:,7),heltab2x8(:,:,40))
  call Hloop_CV_D(ntryL,G1H8(15),8,wf4(:,1),3,G2H2(72),m3h4x2(:,8),heltab2x8(:,:,41))
  call Hloop_UV_W(ntryL,G1H8(17),8,wf4(:,1),3,G2H2(73),m3h4x2(:,9),heltab2x8(:,:,42))
  call Hloop_QV_A(ntryL,G1H8(27),ex2(:),G1H4(42),m3h2x4(:,34),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(42),10,0,G2H4(25),n2h4(70))
  call Hloop_QV_A(ntryL,G1H8(20),ex2(:),G1H4(44),m3h2x4(:,35),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(44),10,nMT,G2H4(26),n2h4(71))
  call Hloop_AV_Q(ntryL,G1H8(29),ex2(:),G1H4(45),m3h2x4(:,36),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(45),10,0,G2H4(27),n2h4(72))
  call Hloop_AV_Q(ntryL,G1H8(22),ex2(:),G1H4(46),m3h2x4(:,37),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(46),10,nMT,G2H4(1),n2h4(73))
  call Hloop_QV_A(ntryL,G1H8(24),ex2(:),G1H4(47),m3h2x4(:,38),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(47),10,nMB,G2H4(2),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(26),ex2(:),G1H4(49),m3h2x4(:,39),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(49),10,nMB,G2H4(3),n2h4(75))
  call Hloop_CV_D(ntryL,G1H8(28),8,ex2(:),2,G2H4(4),m3h2x4(:,40),heltab2x8(:,:,49))
  call Hloop_DV_C(ntryL,G1H8(30),8,ex2(:),G2H4(5),m3h2x4(:,41),heltab2x8(:,:,50))
  call Hloop_UV_W(ntryL,G1H8(31),8,ex2(:),2,G2H4(6),m3h2x4(:,42),heltab2x8(:,:,51))
  call Hloop_QV_A(ntryL,G1H8(36),ex1(:),G1H4(50),m3h2x4(:,43),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(50),9,0,G2H4(7),n2h4(76))
  call Hloop_QV_A(ntryL,G1H8(33),ex1(:),G1H4(51),m3h2x4(:,44),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(51),9,nMT,G2H4(8),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H8(38),ex1(:),G1H4(52),m3h2x4(:,45),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(52),9,0,G2H4(9),n2h4(78))
  call Hloop_AV_Q(ntryL,G1H8(35),ex1(:),G1H4(54),m3h2x4(:,46),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(54),9,nMT,G2H4(10),n2h4(79))
  call Hloop_QV_A(ntryL,G1H8(37),ex1(:),G1H4(55),m3h2x4(:,47),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(55),9,nMB,G2H4(11),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(39),ex1(:),G1H4(56),m3h2x4(:,48),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(56),9,nMB,G2H4(12),n2h4(81))
  call Hloop_CV_D(ntryL,G1H8(40),8,ex1(:),1,G2H4(13),m3h2x4(:,49),heltab2x8(:,:,58))
  call Hloop_DV_C(ntryL,G1H8(41),8,ex1(:),G2H4(14),m3h2x4(:,50),heltab2x8(:,:,59))
  call Hloop_UV_W(ntryL,G1H8(42),8,ex1(:),1,G2H4(15),m3h2x4(:,51),heltab2x8(:,:,60))
  call Hloop_AV_Q(ntryL,G1H4(34),ex1(:),G1H2(64),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(64),13,0,G2H2(76),n2h2(97))
  call Hloop_AV_Q(ntryL,G1H4(30),ex1(:),G1H2(9),m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(9),13,nMT,G2H2(77),n2h2(98))
  call Hloop_QV_A(ntryL,G1H4(36),ex1(:),G1H2(65),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(65),13,0,G2H2(80),n2h2(99))
  call Hloop_QV_A(ntryL,G1H4(32),ex1(:),G1H2(68),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(68),13,nMT,G2H2(81),n2h2(100))
  call Hloop_AV_Q(ntryL,G1H4(35),ex1(:),G1H2(10),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(10),13,nMB,G2H2(84),n2h2(101))
  call Hloop_QV_A(ntryL,G1H4(37),ex1(:),G1H2(69),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(69),13,nMB,G2H2(85),n2h2(102))
  call Hloop_DV_C(ntryL,G1H4(39),12,ex1(:),G2H2(88),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_CV_D(ntryL,G1H4(40),12,ex1(:),1,G2H2(89),m3h2x2(:,171),heltab2x4(:,:,171))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(47),G2H2(3),G1H2(75),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(51),G2H2(7),G1H2(79),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(39),G2H2(11),G1H2(67),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(43),G2H2(15),G1H2(71),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(59),G2H2(19),G1H2(87),G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(55),G2H2(23),G1H2(83),G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(67),G2H2(27),G1H2(95),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(63),G2H2(31),G1H2(91),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(71),G2H2(35),G1H2(53),G1H2(6),G1H2(52),G1H2(99) &
    ,G1H2(63)])
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(76)])
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(77)])
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(80)])
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(81)])
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(84)])
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(85)])
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(88)])
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(89)])
call HGT_lower_alpha_OLR(G2H2(70),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(70),2,5,2)
call HGT_lower_alpha_OLR(G2H2(70),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(38)])
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(42)])
call HGT_OLR(G2H2(78),1,1,2)
call HGT_invQ_OLR(G2H2(78),2,5,2)
call HGT_OLR(G2H2(78),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(30)])
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(34)])
call HGT_OLR(G2H2(86),1,1,2)
call HGT_invQ_OLR(G2H2(86),2,5,2)
call HGT_OLR(G2H2(86),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(50)])
call HGT_OLR(G2H2(90),1,1,2)
call HGT_invQ_OLR(G2H2(90),2,5,2)
call HGT_OLR(G2H2(90),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(46)])
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(58)])
call HGT_OLR(G2H2(98),1,1,2)
call HGT_invQ_OLR(G2H2(98),2,5,2)
call HGT_OLR(G2H2(98),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(54)])
call HGT_OLR(G2H2(102),1,1,2)
call HGT_invQ_OLR(G2H2(102),2,5,2)
call HGT_OLR(G2H2(102),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(103),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(62)])
call HGT_lower_alpha_OLR(G2H2(106),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(106),2,5,2)
call HGT_lower_alpha_OLR(G2H2(106),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(134)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(2),ex1(:),G2H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(28),n2h1(100))
  call Hloop_QV_A(ntryL,G2H2(61),ex3(:),G2H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(29),n2h1(101))
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(6),ex1(:),G2H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(30),n2h1(102))
  call Hloop_QV_A(ntryL,G2H2(64),ex3(:),G2H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(31),n2h1(103))
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(10),ex1(:),G2H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(32),n2h1(104))
  call Hloop_AV_Q(ntryL,G2H2(57),ex3(:),G2H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(33),n2h1(105))
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(14),ex1(:),G2H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(34),n2h1(106))
  call Hloop_AV_Q(ntryL,G2H2(60),ex3(:),G2H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(35),n2h1(107))
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hloop_QV_A(ntryL,G2H2(18),ex1(:),G2H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(36),n2h1(108))
  call Hloop_QV_A(ntryL,G2H2(68),ex3(:),G2H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(37),n2h1(109))
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hloop_AV_Q(ntryL,G2H2(22),ex1(:),G2H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(38),n2h1(110))
  call Hloop_AV_Q(ntryL,G2H2(65),ex3(:),G2H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(39),n2h1(111))
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(26),14,ex1(:),1,G3tensor(40),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(72),11,ex3(:),4,G3tensor(41),m3h2x1(:,149),heltab2x2(:,:,149))
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(30),14,ex1(:),G3tensor(42),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(69),11,ex3(:),G3tensor(43),m3h2x1(:,151),heltab2x2(:,:,151))
call HGT_lower_alpha_OLR(G2H2(34),1,1,2)
call HGT_lower_alpha_invQ_OLR(G2H2(34),2,5,2)
call HGT_lower_alpha_OLR(G2H2(34),6,15,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(34),14,ex1(:),1,G3tensor(44),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(73),11,ex3(:),4,G3tensor(45),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hloop_AV_Q(ntryL,G2H2(38),ex2(:),G2H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(46),n2h1(112))
  call Hloop_AV_Q(ntryL,G2H2(42),ex2(:),G2H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(47),n2h1(113))
  call Hloop_QV_A(ntryL,G2H2(46),ex2(:),G2H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(48),n2h1(114))
  call Hloop_QV_A(ntryL,G2H2(50),ex2(:),G2H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(49),n2h1(115))
  call Hloop_AV_Q(ntryL,G2H2(54),ex2(:),G2H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(50),n2h1(116))
  call Hloop_QV_A(ntryL,G2H2(58),ex2(:),G2H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(51),n2h1(117))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(62),13,ex2(:),G3tensor(52),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(66),13,ex2(:),2,G3tensor(53),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(70),13,ex2(:),2,G3tensor(54),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hloop_AV_Q(ntryL,G2H2(74),ex3(:),G2H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(55),n2h1(118))
  call Hloop_AV_Q(ntryL,G2H2(75),ex2(:),G2H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(56),n2h1(119))
  call Hloop_AV_Q(ntryL,G2H2(78),ex3(:),G2H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(57),n2h1(120))
  call Hloop_AV_Q(ntryL,G2H2(79),ex2(:),G2H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(58),n2h1(121))
  call Hloop_QV_A(ntryL,G2H2(82),ex3(:),G2H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(59),n2h1(122))
  call Hloop_QV_A(ntryL,G2H2(83),ex2(:),G2H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(60),n2h1(123))
  call Hloop_QV_A(ntryL,G2H2(86),ex3(:),G2H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(61),n2h1(124))
  call Hloop_QV_A(ntryL,G2H2(87),ex2(:),G2H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(62),n2h1(125))
  call Hloop_AV_Q(ntryL,G2H2(90),ex3(:),G2H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(63),n2h1(126))
  call Hloop_AV_Q(ntryL,G2H2(91),ex2(:),G2H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(64),n2h1(127))
  call Hloop_QV_A(ntryL,G2H2(94),ex3(:),G2H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(65),n2h1(128))
  call Hloop_QV_A(ntryL,G2H2(95),ex2(:),G2H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(66),n2h1(129))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(98),11,ex3(:),G3tensor(67),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(99),13,ex2(:),G3tensor(68),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(102),11,ex3(:),4,G3tensor(69),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(103),13,ex2(:),2,G3tensor(70),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(106),11,ex3(:),4,G3tensor(71),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(107),13,ex2(:),2,G3tensor(72),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hloop_AV_Q(ntryL,G2H2(20),ex3(:),G2H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(73),n2h1(130))
  call Hloop_AV_Q(ntryL,G2H2(21),ex3(:),G2H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(74),n2h1(131))
  call Hloop_QV_A(ntryL,G2H2(24),ex3(:),G2H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(75),n2h1(132))
  call Hloop_QV_A(ntryL,G2H2(25),ex3(:),G2H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(76),n2h1(133))
  call Hloop_AV_Q(ntryL,G2H2(28),ex3(:),G2H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(77),n2h1(134))
  call Hloop_QV_A(ntryL,G2H2(29),ex3(:),G2H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(78),n2h1(135))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(32),11,ex3(:),G3tensor(79),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(33),11,ex3(:),4,G3tensor(80),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(36),11,ex3(:),4,G3tensor(81),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hloop_AV_Q(ntryL,G2H2(37),ex2(:),G2H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(82),n2h1(136))
  call Hloop_AV_Q(ntryL,G2H2(40),ex2(:),G2H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(83),n2h1(137))
  call Hloop_QV_A(ntryL,G2H2(41),ex2(:),G2H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(84),n2h1(138))
  call Hloop_QV_A(ntryL,G2H2(44),ex2(:),G2H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(85),n2h1(139))
  call Hloop_AV_Q(ntryL,G2H2(45),ex2(:),G2H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(86),n2h1(140))
  call Hloop_QV_A(ntryL,G2H2(48),ex2(:),G2H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(87),n2h1(141))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(49),13,ex2(:),G3tensor(88),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(52),13,ex2(:),2,G3tensor(89),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(53),13,ex2(:),2,G3tensor(90),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(19),ex3(:),ex2(:),G2tensor(8),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(20),ex2(:),ex3(:),G2tensor(7),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(21),ex3(:),ex2(:),G2tensor(3),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(22),ex3(:),ex1(:),G2tensor(1),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G2H4(23),ex1(:),ex3(:),G2tensor(2),m4h2x2x1(:,5),heltab3x4(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G2H4(24),ex3(:),ex1(:),G2tensor(5),m4h2x2x1(:,6),heltab3x4(:,:,6))
  call Hloop_QV_A(ntryL,G2H4(25),wf4(:,3),G2H1(1),m3h4x1(:,1),heltab2x4(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(91),n2h1(142))
  call Hloop_QV_A(ntryL,G2H4(26),wf4(:,3),G2H1(1),m3h4x1(:,2),heltab2x4(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(92),n2h1(143))
  call Hloop_AV_Q(ntryL,G2H4(27),wf4(:,3),G2H1(1),m3h4x1(:,3),heltab2x4(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(93),n2h1(144))
  call Hloop_AV_Q(ntryL,G2H4(1),wf4(:,3),G2H1(1),m3h4x1(:,4),heltab2x4(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(94),n2h1(145))
  call Hloop_QV_A(ntryL,G2H4(2),wf4(:,3),G2H1(1),m3h4x1(:,5),heltab2x4(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(95),n2h1(146))
  call Hloop_AV_Q(ntryL,G2H4(3),wf4(:,3),G2H1(1),m3h4x1(:,6),heltab2x4(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(96),n2h1(147))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(4),10,wf4(:,3),5,G3tensor(97),m3h4x1(:,7),heltab2x4(:,:,178))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(5),10,wf4(:,3),G3tensor(98),m3h4x1(:,8),heltab2x4(:,:,179))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(6),10,wf4(:,3),5,G3tensor(99),m3h4x1(:,9),heltab2x4(:,:,180))
  call Hloop_QV_A(ntryL,G2H4(7),wf4(:,6),G2H1(1),m3h4x1(:,10),heltab2x4(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(100),n2h1(148))
  call Hloop_QV_A(ntryL,G2H4(8),wf4(:,6),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(101),n2h1(149))
  call Hloop_AV_Q(ntryL,G2H4(9),wf4(:,6),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(102),n2h1(150))
  call Hloop_AV_Q(ntryL,G2H4(10),wf4(:,6),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(103),n2h1(151))
  call Hloop_QV_A(ntryL,G2H4(11),wf4(:,6),G2H1(1),m3h4x1(:,14),heltab2x4(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(104),n2h1(152))
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,6),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(105),n2h1(153))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(13),9,wf4(:,6),6,G3tensor(106),m3h4x1(:,16),heltab2x4(:,:,187))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(14),9,wf4(:,6),G3tensor(107),m3h4x1(:,17),heltab2x4(:,:,188))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(15),9,wf4(:,6),6,G3tensor(108),m3h4x1(:,18),heltab2x4(:,:,189))
  call ol_merge_tensors(G3tensor(99),[G3tensor(98),G3tensor(97),G3tensor(93),G3tensor(91),G3tensor(9),G3tensor(8),G3tensor(7) &
    ,G3tensor(3),G3tensor(1),G2tensor(5),G2tensor(2),G2tensor(1),G2tensor(54),G2tensor(51),G2tensor(48),G2tensor(36),G2tensor(30) &
    ,G1tensor(41),G0tensor(14)])
  call ol_merge_tensors(G3tensor(94),[G3tensor(92),G3tensor(4),G3tensor(2),G2tensor(39),G2tensor(33),G1tensor(46),G0tensor(19)])
  call ol_merge_tensors(G3tensor(96),[G3tensor(95),G3tensor(6),G3tensor(5),G2tensor(45),G2tensor(42),G1tensor(51),G0tensor(24)])
  call ol_merge_tensors(G3tensor(108),[G3tensor(107),G3tensor(106),G3tensor(102),G3tensor(100),G3tensor(27),G3tensor(26) &
    ,G3tensor(25),G3tensor(21),G3tensor(19),G3tensor(18),G3tensor(17),G3tensor(16),G3tensor(12),G3tensor(10),G2tensor(3) &
    ,G2tensor(7),G2tensor(8),G2tensor(108),G2tensor(105),G2tensor(102),G2tensor(90),G2tensor(84),G2tensor(81),G2tensor(78) &
    ,G2tensor(75),G2tensor(63),G2tensor(57),G1tensor(71),G1tensor(56),G0tensor(44),G0tensor(29)])
  call ol_merge_tensors(G3tensor(103),[G3tensor(101),G3tensor(22),G3tensor(20),G3tensor(13),G3tensor(11),G2tensor(93),G2tensor(87) &
    ,G2tensor(66),G2tensor(60),G1tensor(76),G1tensor(61),G0tensor(49),G0tensor(34)])
  call ol_merge_tensors(G3tensor(105),[G3tensor(104),G3tensor(24),G3tensor(23),G3tensor(15),G3tensor(14),G2tensor(99),G2tensor(96) &
    ,G2tensor(72),G2tensor(69),G1tensor(81),G1tensor(66),G0tensor(54),G0tensor(39)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G3tensor(40),G3tensor(32),G3tensor(28),G2tensor(53),G2tensor(50),G2tensor(47) &
    ,G2tensor(35),G2tensor(29),G1tensor(38),G0tensor(11)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(30),G2tensor(38),G2tensor(32),G1tensor(43),G0tensor(16)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(36),G2tensor(44),G2tensor(41),G1tensor(48),G0tensor(21)])
  call ol_merge_tensors(G3tensor(54),[G3tensor(53),G3tensor(52),G3tensor(48),G3tensor(46),G2tensor(80),G2tensor(77),G2tensor(74) &
    ,G2tensor(62),G2tensor(56),G1tensor(53),G0tensor(26)])
  call ol_merge_tensors(G3tensor(49),[G3tensor(47),G2tensor(65),G2tensor(59),G1tensor(58),G0tensor(31)])
  call ol_merge_tensors(G3tensor(51),[G3tensor(50),G2tensor(71),G2tensor(68),G1tensor(63),G0tensor(36)])
  call ol_merge_tensors(G3tensor(71),[G3tensor(69),G3tensor(67),G3tensor(59),G3tensor(55),G2tensor(107),G2tensor(104) &
    ,G2tensor(101),G2tensor(89),G2tensor(83),G1tensor(68),G1tensor(39),G0tensor(41),G0tensor(12)])
  call ol_merge_tensors(G3tensor(61),[G3tensor(57),G2tensor(92),G2tensor(86),G1tensor(73),G1tensor(44),G0tensor(46) &
    ,G0tensor(17)])
  call ol_merge_tensors(G3tensor(65),[G3tensor(63),G2tensor(98),G2tensor(95),G1tensor(78),G1tensor(49),G0tensor(51) &
    ,G0tensor(22)])
  call ol_merge_tensors(G1tensor(26),[G1tensor(3)])
  call ol_merge_tensors(G1tensor(16),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(7)])
  call ol_merge_tensors(G1tensor(20),[G1tensor(8)])
  call ol_merge_tensors(G1tensor(34),[G1tensor(11)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(12)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(17)])
  call ol_merge_tensors(G1tensor(33),[G1tensor(21)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(25)])
  call ol_merge_tensors(G3tensor(45),[G3tensor(43),G3tensor(41),G3tensor(33),G3tensor(29),G1tensor(55),G1tensor(40),G0tensor(28) &
    ,G0tensor(13)])
  call ol_merge_tensors(G3tensor(35),[G3tensor(31),G1tensor(60),G1tensor(45),G0tensor(33),G0tensor(18)])
  call ol_merge_tensors(G3tensor(39),[G3tensor(37),G1tensor(65),G1tensor(50),G0tensor(38),G0tensor(23)])
  call ol_merge_tensors(G3tensor(81),[G3tensor(80),G3tensor(79),G3tensor(75),G3tensor(73),G1tensor(54),G0tensor(27)])
  call ol_merge_tensors(G3tensor(76),[G3tensor(74),G1tensor(59),G0tensor(32)])
  call ol_merge_tensors(G3tensor(78),[G3tensor(77),G1tensor(64),G0tensor(37)])
  call ol_merge_tensors(G3tensor(90),[G3tensor(89),G3tensor(88),G3tensor(84),G3tensor(82),G1tensor(69),G0tensor(42)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(70),G3tensor(68),G3tensor(60),G3tensor(56),G1tensor(70),G0tensor(43)])
  call ol_merge_tensors(G3tensor(85),[G3tensor(83),G1tensor(74),G0tensor(47)])
  call ol_merge_tensors(G3tensor(62),[G3tensor(58),G1tensor(75),G0tensor(48)])
  call ol_merge_tensors(G3tensor(87),[G3tensor(86),G1tensor(79),G0tensor(52)])
  call ol_merge_tensors(G3tensor(66),[G3tensor(64),G1tensor(80),G0tensor(53)])
  call TI_triangle_red(G3tensor(99),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1)
  call TI_triangle_red(G3tensor(94),RedBasis(1),mass3set(:,2),G0tensor(5),G0tensor(6),G0tensor(7),G0tensor(8),M2L1R1,[nMT], &
    G0tensor(9))
  call TI_triangle_red(G3tensor(96),RedBasis(1),mass3set(:,3),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(25),M2L1R1,[nMB], &
    G0tensor(30))
  call TI_triangle_red(G3tensor(108),RedBasis(4),mass3set(:,1),G0tensor(35),G0tensor(40),G0tensor(45),G0tensor(50),M2L1R1)
  call TI_triangle_red(G3tensor(103),RedBasis(4),mass3set(:,2),G0tensor(14),G0tensor(19),G0tensor(24),G0tensor(44),M2L1R1,[nMT], &
    G0tensor(29))
  call TI_triangle_red(G3tensor(105),RedBasis(4),mass3set(:,3),G0tensor(49),G0tensor(34),G0tensor(54),G0tensor(39),M2L1R1,[nMB], &
    G0tensor(11))
  call TI_triangle_red(G3tensor(44),RedBasis(8),mass3set(:,1),G0tensor(16),G0tensor(21),G0tensor(26),G0tensor(31),M2L1R1)
  call TI_triangle_red(G3tensor(34),RedBasis(8),mass3set(:,2),G0tensor(36),G0tensor(41),G0tensor(12),G0tensor(46),M2L1R1,[nMT], &
    G0tensor(17))
  call TI_triangle_red(G3tensor(38),RedBasis(8),mass3set(:,3),G0tensor(51),G0tensor(22),G0tensor(28),G0tensor(13),M2L1R1,[nMB], &
    G0tensor(33))
  call TI_triangle_red(G3tensor(54),RedBasis(9),mass3set(:,1),G0tensor(18),G0tensor(38),G0tensor(23),G0tensor(27),M2L1R1)
  call TI_triangle_red(G3tensor(49),RedBasis(9),mass3set(:,2),G0tensor(32),G0tensor(37),G0tensor(42),G0tensor(43),M2L1R1,[nMT], &
    G0tensor(47))
  call TI_triangle_red(G3tensor(51),RedBasis(9),mass3set(:,3),G0tensor(48),G0tensor(52),G0tensor(53),G0tensor(55),M2L1R1,[nMB], &
    G0tensor(56))
  call TI_triangle_red(G3tensor(71),RedBasis(3),mass3set(:,1),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1)
  call TI_triangle_red(G3tensor(61),RedBasis(3),mass3set(:,2),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),M2L1R1,[nMT], &
    G0tensor(65))
  call TI_triangle_red(G3tensor(65),RedBasis(3),mass3set(:,3),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),M2L1R1,[nMB], &
    G0tensor(70))
  call TI_triangle_red(G3tensor(45),RedBasis(2),mass3set(:,1),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),M2L1R1)
  call TI_triangle_red(G3tensor(35),RedBasis(2),mass3set(:,2),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),M2L1R1,[nMT], &
    G0tensor(79))
  call TI_triangle_red(G3tensor(39),RedBasis(2),mass3set(:,3),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),M2L1R1,[nMB], &
    G0tensor(84))
  call TI_triangle_red(G3tensor(81),RedBasis(5),mass3set(:,1),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),M2L1R1)
  call TI_triangle_red(G3tensor(76),RedBasis(5),mass3set(:,2),G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),M2L1R1,[nMT], &
    G0tensor(93))
  call TI_triangle_red(G3tensor(78),RedBasis(5),mass3set(:,3),G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),M2L1R1,[nMB], &
    G0tensor(98))
  call TI_triangle_red(G3tensor(90),RedBasis(7),mass3set(:,1),G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102),M2L1R1)
  call TI_triangle_red(G3tensor(72),RedBasis(6),mass3set(:,1),G0tensor(103),G0tensor(104),G0tensor(105),G0tensor(106),M2L1R1)
  call TI_triangle_red(G3tensor(85),RedBasis(7),mass3set(:,2),G0tensor(107),G0tensor(108),G0tensor(109), &
    G0tensor(110),M2L1R1,[nMT],G0tensor(111))
  call TI_triangle_red(G3tensor(62),RedBasis(6),mass3set(:,2),G0tensor(112),G0tensor(113),G0tensor(114), &
    G0tensor(115),M2L1R1,[nMT],G0tensor(116))
  call TI_triangle_red(G3tensor(87),RedBasis(7),mass3set(:,3),G0tensor(117),G0tensor(118),G0tensor(119), &
    G0tensor(120),M2L1R1,[nMB],G0tensor(121))
  call TI_triangle_red(G3tensor(66),RedBasis(6),mass3set(:,3),G0tensor(122),G0tensor(123),G0tensor(124), &
    G0tensor(125),M2L1R1,[nMB],G0tensor(126))
  call ol_merge_tensors(T0sum(19),[G0tensor(1)])
  call ol_merge_tensors(T0sum(20),[G0tensor(5)])
  call ol_merge_tensors(T0sum(21),[G0tensor(10)])
  call ol_merge_tensors(T0sum(22),[G0tensor(35)])
  call ol_merge_tensors(T0sum(23),[G0tensor(14)])
  call ol_merge_tensors(T0sum(24),[G0tensor(49)])
  call ol_merge_tensors(T0sum(25),[G0tensor(16)])
  call ol_merge_tensors(T0sum(26),[G0tensor(36)])
  call ol_merge_tensors(T0sum(27),[G0tensor(51)])
  call ol_merge_tensors(T0sum(28),[G0tensor(18)])
  call ol_merge_tensors(T0sum(29),[G0tensor(32)])
  call ol_merge_tensors(T0sum(30),[G0tensor(48)])
  call ol_merge_tensors(T0sum(31),[G0tensor(57)])
  call ol_merge_tensors(T0sum(32),[G0tensor(61)])
  call ol_merge_tensors(T0sum(33),[G0tensor(66)])
  call ol_merge_tensors(T1sum(1),[G1tensor(2)])
  call ol_merge_tensors(T1sum(2),[G1tensor(26)])
  call ol_merge_tensors(T1sum(3),[G1tensor(16)])
  call ol_merge_tensors(T1sum(4),[G1tensor(5)])
  call ol_merge_tensors(T1sum(5),[G1tensor(6)])
  call ol_merge_tensors(T1sum(6),[G1tensor(30)])
  call ol_merge_tensors(T1sum(7),[G1tensor(20)])
  call ol_merge_tensors(T1sum(8),[G1tensor(9)])
  call ol_merge_tensors(T1sum(9),[G1tensor(10)])
  call ol_merge_tensors(T1sum(10),[G1tensor(34)])
  call ol_merge_tensors(T1sum(11),[G1tensor(24)])
  call ol_merge_tensors(T1sum(12),[G1tensor(13)])
  call ol_merge_tensors(T1sum(13),[G1tensor(14)])
  call ol_merge_tensors(T1sum(14),[G1tensor(15)])
  call ol_merge_tensors(T1sum(15),[G1tensor(29)])
  call ol_merge_tensors(T1sum(16),[G1tensor(18)])
  call ol_merge_tensors(T1sum(17),[G1tensor(19)])
  call ol_merge_tensors(T1sum(18),[G1tensor(33)])
  call ol_merge_tensors(T1sum(19),[G1tensor(22)])
  call ol_merge_tensors(T1sum(20),[G1tensor(23)])
  call ol_merge_tensors(T1sum(21),[G1tensor(37)])
  call ol_merge_tensors(T1sum(22),[G1tensor(27)])
  call ol_merge_tensors(T1sum(23),[G1tensor(28)])
  call ol_merge_tensors(T1sum(24),[G1tensor(31)])
  call ol_merge_tensors(T1sum(25),[G1tensor(32)])
  call ol_merge_tensors(T1sum(26),[G1tensor(35)])
  call ol_merge_tensors(T1sum(27),[G1tensor(36)])
  call ol_merge_tensors(T0sum(34),[G0tensor(71)])
  call ol_merge_tensors(T0sum(35),[G0tensor(75)])
  call ol_merge_tensors(T0sum(36),[G0tensor(80)])
  call ol_merge_tensors(T0sum(37),[G0tensor(85)])
  call ol_merge_tensors(T0sum(38),[G0tensor(89)])
  call ol_merge_tensors(T0sum(39),[G0tensor(94)])
  call ol_merge_tensors(T0sum(40),[G0tensor(99)])
  call ol_merge_tensors(T0sum(41),[G0tensor(103)])
  call ol_merge_tensors(T0sum(42),[G0tensor(107)])
  call ol_merge_tensors(T0sum(43),[G0tensor(112)])
  call ol_merge_tensors(T0sum(44),[G0tensor(117)])
  call ol_merge_tensors(T0sum(45),[G0tensor(122)])
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[12,3],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(16),m4h2x2x4(:,10),heltab3x16(:,:,10))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[12,3],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(17),m4h2x2x4(:,11),heltab3x16(:,:,11))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[12,3],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(18),m4h2x2x4(:,12),heltab3x16(:,:,12))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[12,3],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(19),m4h2x2x4(:,13),heltab3x16(:,:,13))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[12,3],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(20),m4h2x2x4(:,14),heltab3x16(:,:,14))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[12,3],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(21),m4h2x2x4(:,15),heltab3x16(:,:,15))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[12,3],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(22),m4h2x2x4(:,16),heltab3x16(:,:,16))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[12,3],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(23),m4h2x2x4(:,17),heltab3x16(:,:,17))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[12,3],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(24),m4h2x2x4(:,18),heltab3x16(:,:,18))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[10,5],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(25),m4h2x2x4(:,19),heltab3x16(:,:,19))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[10,5],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(26),m4h2x2x4(:,20),heltab3x16(:,:,20))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[10,5],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(27),m4h2x2x4(:,21),heltab3x16(:,:,21))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(5,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[10,5],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),ex4(:),G0H4(10),m4h2x2x4(:,22),heltab3x16(:,:,22))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[10,5],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),ex4(:),G0H4(11),m4h2x2x4(:,23),heltab3x16(:,:,23))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[10,5],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),ex4(:),G0H4(12),m4h2x2x4(:,24),heltab3x16(:,:,24))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[10,5],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(13),m4h2x2x4(:,25),heltab3x16(:,:,25))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[10,5],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(14),m4h2x2x4(:,26),heltab3x16(:,:,26))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(135),h0tab(:,135),[10,5],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(15),m4h2x2x4(:,27),heltab3x16(:,:,27))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[9,6],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(6),m4h2x2x4(:,28),heltab3x16(:,:,28))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(137),h0tab(:,137),[9,6],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),ex4(:),G0H4(5),m4h2x2x4(:,29),heltab3x16(:,:,29))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[9,6],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(4),m4h2x2x4(:,30),heltab3x16(:,:,30))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(4,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[9,6],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(9),m4h2x2x4(:,31),heltab3x16(:,:,31))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j+M(2,:)%j+M(3,:)%j)+c(2)*(M(6,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[9,6],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),ex4(:),G0H4(8),m4h2x2x4(:,32),heltab3x16(:,:,32))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[9,6],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(7),m4h2x2x4(:,33),heltab3x16(:,:,33))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[9,6],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(3),m4h2x2x4(:,34),heltab3x16(:,:,34))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[9,6],[0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),ex4(:),G0H4(2),m4h2x2x4(:,35),heltab3x16(:,:,35))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[9,6],[0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(1),m4h2x2x4(:,36),heltab3x16(:,:,36))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[11,4],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),wf4(:,1),G0H2(1),m4h2x4x2(:,1),heltab3x16(:,:,37))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[11,4],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,1),ex4(:),G0H2(2),m4h4x2x2(:,1),heltab3x16(:,:,38))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[11,4],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),wf4(:,1),G0H2(3),m4h2x4x2(:,2),heltab3x16(:,:,39))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[8,7],[0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(4),m3h2x8(:,76),heltab2x16(:,:,109))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[8,7],[0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(8),m3h2x8(:,77),heltab2x16(:,:,110))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[8,7],[0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(19),m3h2x8(:,78),heltab2x16(:,:,111))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[12,3],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(28),m4h2x2x4(:,37),heltab3x16(:,:,40))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[12,3],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(29),m4h2x2x4(:,38),heltab3x16(:,:,41))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[12,3],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(30),m4h2x2x4(:,39),heltab3x16(:,:,42))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[13,2],[0,0],3,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),wf4(:,3),G0H2(4),m4h2x4x2(:,3),heltab3x16(:,:,43))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[13,2],[0,0],3,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,3),ex4(:),G0H2(5),m4h4x2x2(:,2),heltab3x16(:,:,44))
  Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[13,2],[0,0],3,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),wf4(:,3),G0H2(6),m4h2x4x2(:,4),heltab3x16(:,:,45))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[14,1],[0,0],3,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),wf4(:,6),G0H2(7),m4h2x4x2(:,5),heltab3x16(:,:,46))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[14,1],[0,0],3,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,6),ex4(:),G0H2(8),m4h4x2x2(:,3),heltab3x16(:,:,47))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[14,1],[0,0],3,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),wf4(:,6),G0H2(9),m4h2x4x2(:,6),heltab3x16(:,:,48))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[13,2],[0,0],3,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),wf4(:,5),G0H2(10),m4h2x4x2(:,7),heltab3x16(:,:,49))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[13,2],[0,0],3,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,5),ex3(:),G0H2(11),m4h4x2x2(:,4),heltab3x16(:,:,50))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[13,2],[0,0],3,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex3(:),wf4(:,5),G0H2(12),m4h2x4x2(:,8),heltab3x16(:,:,51))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[14,1],[0,0],3,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),wf4(:,4),G0H2(13),m4h2x4x2(:,9),heltab3x16(:,:,52))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[14,1],[0,0],3,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,4),ex3(:),G0H2(14),m4h4x2x2(:,5),heltab3x16(:,:,53))
  Gcoeff(:)%j = (c(3)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[14,1],[0,0],3,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex3(:),wf4(:,4),G0H2(15),m4h2x4x2(:,10),heltab3x16(:,:,54))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[8,7],[0,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(21),m3h2x8(:,79),heltab2x16(:,:,112))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[8,7],[0,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(32),m3h2x8(:,80),heltab2x16(:,:,113))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[8,7],[0,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(34),m3h2x8(:,81),heltab2x16(:,:,114))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[10,5],[0,0],3,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(31),m4h2x2x4(:,40),heltab3x16(:,:,55))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[10,5],[0,0],3,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),ex4(:),G0H4(32),m4h2x2x4(:,41),heltab3x16(:,:,56))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[10,5],[0,0],3,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex2(:),G0H4(33),m4h2x2x4(:,42),heltab3x16(:,:,57))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[11,4],[0,0],3,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),wf4(:,5),G0H2(16),m4h2x4x2(:,11),heltab3x16(:,:,58))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[11,4],[0,0],3,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,5),ex2(:),G0H2(17),m4h4x2x2(:,6),heltab3x16(:,:,59))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[11,4],[0,0],3,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex2(:),wf4(:,5),G0H2(18),m4h2x4x2(:,12),heltab3x16(:,:,60))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[14,1],[0,0],3,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex2(:),wf4(:,2),G0H2(19),m4h2x4x2(:,13),heltab3x16(:,:,61))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[14,1],[0,0],3,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,2),ex2(:),G0H2(20),m4h4x2x2(:,7),heltab3x16(:,:,62))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[14,1],[0,0],3,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex2(:),wf4(:,2),G0H2(21),m4h2x4x2(:,14),heltab3x16(:,:,63))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[9,6],[0,0],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(57),m3h4x4(:,34),heltab2x16(:,:,115))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[9,6],[0,0],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(59),m3h4x4(:,35),heltab2x16(:,:,116))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(180),h0tab(:,180),[9,6],[0,0],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(60),m3h4x4(:,36),heltab2x16(:,:,117))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[8,7],[0,0],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(1),m3h2x8(:,82),heltab2x16(:,:,118))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[8,7],[0,0],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(3),m3h2x8(:,83),heltab2x16(:,:,119))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[8,7],[0,0],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(12),m3h2x8(:,84),heltab2x16(:,:,120))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[9,6],[0,0],3,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(34),m4h2x2x4(:,43),heltab3x16(:,:,64))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[9,6],[0,0],3,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),ex4(:),G0H4(35),m4h2x2x4(:,44),heltab3x16(:,:,65))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[9,6],[0,0],3,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex1(:),G0H4(36),m4h2x2x4(:,45),heltab3x16(:,:,66))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[11,4],[0,0],3,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),wf4(:,4),G0H2(22),m4h2x4x2(:,15),heltab3x16(:,:,67))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[11,4],[0,0],3,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,4),ex1(:),G0H2(23),m4h4x2x2(:,8),heltab3x16(:,:,68))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[11,4],[0,0],3,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex1(:),wf4(:,4),G0H2(24),m4h2x4x2(:,16),heltab3x16(:,:,69))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[13,2],[0,0],3,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex1(:),wf4(:,2),G0H2(25),m4h2x4x2(:,17),heltab3x16(:,:,70))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[13,2],[0,0],3,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,2),ex1(:),G0H2(26),m4h4x2x2(:,9),heltab3x16(:,:,71))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[13,2],[0,0],3,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex1(:),wf4(:,2),G0H2(27),m4h2x4x2(:,18),heltab3x16(:,:,72))
  Gcoeff(:)%j = (c(2)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[10,5],[0,0],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(61),m3h4x4(:,37),heltab2x16(:,:,121))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[10,5],[0,0],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(62),m3h4x4(:,38),heltab2x16(:,:,122))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[10,5],[0,0],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(64),m3h4x4(:,39),heltab2x16(:,:,123))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(196),h0tab(:,196),[12,3],[0,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(65),m3h4x4(:,40),heltab2x16(:,:,124))
  Gcoeff(:)%j = (c(2)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(197),h0tab(:,197),[12,3],[0,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(66),m3h4x4(:,41),heltab2x16(:,:,125))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(198),h0tab(:,198),[12,3],[0,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(67),m3h4x4(:,42),heltab2x16(:,:,126))
  Gcoeff(:)%j = (c(10)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(199),h0tab(:,199),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(37),m3h4x4(:,43),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(37),12,0,G1H4(69),n2h4(82))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(200),h0tab(:,200),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(37),m3h4x4(:,44),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(37),12,nMT,G1H4(70),n2h4(83))
  Gcoeff(:)%j = (c(10)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(201),h0tab(:,201),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(37),m3h4x4(:,45),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G0H4(37),12,0,G1H4(71),n2h4(84))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(202),h0tab(:,202),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(37),m3h4x4(:,46),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G0H4(37),12,nMB,G1H4(72),n2h4(85))
  Gcoeff(:)%j = (c(6)*(-M(4,:)%j+M(5,:)%j+M(7,:)%j-M(9,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(203),h0tab(:,203),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(74),m3h4x4(:,47),heltab2x16(:,:,131))
  Gcoeff(:)%j = (c(3)*(M(4,:)%j-M(5,:)%j-M(7,:)%j+M(9,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(204),h0tab(:,204),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(75),m3h4x4(:,48),heltab2x16(:,:,132))
  Gcoeff(:)%j = (c(10)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(205),h0tab(:,205),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(37),m3h4x4(:,49),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G0H4(37),10,0,G1H4(76),n2h4(86))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(206),h0tab(:,206),[10,5],[nMT,nMT],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(37),m3h4x4(:,50),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G0H4(37),10,nMT,G1H4(77),n2h4(87))
  Gcoeff(:)%j = (c(10)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(207),h0tab(:,207),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(37),m3h4x4(:,51),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G0H4(37),10,0,G1H4(79),n2h4(88))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(208),h0tab(:,208),[10,5],[nMB,nMB],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,4),G0H4(37),m3h4x4(:,52),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G0H4(37),10,nMB,G1H4(80),n2h4(89))
  Gcoeff(:)%j = (c(6)*(M(5,:)%j-M(6,:)%j+M(7,:)%j-M(8,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(209),h0tab(:,209),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(81),m3h4x4(:,53),heltab2x16(:,:,137))
  Gcoeff(:)%j = (c(3)*(-M(5,:)%j+M(6,:)%j-M(7,:)%j+M(8,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(210),h0tab(:,210),[10,5],[0,0],2,2,wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,4),10,G1H4(82),m3h4x4(:,54),heltab2x16(:,:,138))
  Gcoeff(:)%j = (c(10)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(211),h0tab(:,211),[9,6],[0,0],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,55),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G0H4(37),9,0,G1H4(84),n2h4(90))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(212),h0tab(:,212),[9,6],[nMT,nMT],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,56),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G0H4(37),9,nMT,G1H4(85),n2h4(91))
  Gcoeff(:)%j = (c(10)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(213),h0tab(:,213),[9,6],[0,0],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,57),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G0H4(37),9,0,G1H4(86),n2h4(92))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(214),h0tab(:,214),[9,6],[nMB,nMB],2,2,wf4(:,5),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,58),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(37),9,nMB,G1H4(87),n2h4(93))
  Gcoeff(:)%j = (c(6)*(M(4,:)%j-M(6,:)%j-M(8,:)%j+M(9,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(215),h0tab(:,215),[9,6],[0,0],2,2,wf4(:,5),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(89),m3h4x4(:,59),heltab2x16(:,:,143))
  Gcoeff(:)%j = (c(3)*(-M(4,:)%j+M(6,:)%j+M(8,:)%j-M(9,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(216),h0tab(:,216),[9,6],[0,0],2,2,wf4(:,5),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,5),9,G1H4(90),m3h4x4(:,60),heltab2x16(:,:,144))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G0H4(22),G0H4(19),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G0H4(23),G0H4(20),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G0H4(24),G0H4(21),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G0H4(13),G0H4(10),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G0H4(14),G0H4(11),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G0H4(15),G0H4(12),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G0H4(4),G0H4(5),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G0H4(7),G0H4(8),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G0H4(1),G0H4(2),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(24),[G0H2(23),G0H2(22),G0H2(18),G0H2(17),G0H2(16),G0H2(3) &
    ,G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G0H4(30),G0H4(29),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(27),[G0H2(26),G0H2(25),G0H2(12),G0H2(11),G0H2(10),G0H2(6) &
    ,G0H2(5),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(21),[G0H2(20),G0H2(19),G0H2(15),G0H2(14),G0H2(13),G0H2(9) &
    ,G0H2(8),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G0H4(33),G0H4(32),G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G0H4(36),G0H4(35),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(84)])
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H4(65),ex2(:),ex1(:),G1tensor(1),m4h2x2x1(:,7),heltab3x4(:,:,7))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H4(66),ex1(:),ex2(:),G1tensor(42),m4h2x2x1(:,8),heltab3x4(:,:,8))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H4(67),ex2(:),ex1(:),G1tensor(47),m4h2x2x1(:,9),heltab3x4(:,:,9))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H4(61),ex3(:),ex1(:),G1tensor(52),m4h2x2x1(:,10),heltab3x4(:,:,10))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H4(62),ex1(:),ex3(:),G1tensor(57),m4h2x2x1(:,11),heltab3x4(:,:,11))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H4(64),ex3(:),ex1(:),G1tensor(62),m4h2x2x1(:,12),heltab3x4(:,:,12))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H4(57),ex3(:),ex2(:),G1tensor(67),m4h2x2x1(:,13),heltab3x4(:,:,13))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H4(59),ex2(:),ex3(:),G1tensor(72),m4h2x2x1(:,14),heltab3x4(:,:,14))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H4(60),ex3(:),ex2(:),G1tensor(77),m4h2x2x1(:,15),heltab3x4(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(24),11,ex3(:),4,G1tensor(41),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(4),ex3(:),wf4(:,1),G1tensor(46),m4h2x4x1(:,1),heltab3x8(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(8),wf4(:,1),ex3(:),G1tensor(51),m4h4x2x1(:,1),heltab3x8(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H8(19),ex3(:),wf4(:,1),G1tensor(71),m4h2x4x1(:,2),heltab3x8(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(75),12,wf4(:,1),3,G2tensor(17),m3h4x1(:,19),heltab2x4(:,:,190))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(27),13,ex2(:),2,G1tensor(56),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(21),14,ex1(:),1,G1tensor(76),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(21),ex2(:),wf4(:,3),G1tensor(61),m4h2x4x1(:,3),heltab3x8(:,:,7))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(32),wf4(:,3),ex2(:),G1tensor(81),m4h4x2x1(:,2),heltab3x8(:,:,8))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H8(34),ex2(:),wf4(:,3),G1tensor(66),m4h2x4x1(:,4),heltab3x8(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(82),10,wf4(:,3),5,G2tensor(16),m3h4x1(:,20),heltab2x4(:,:,191))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(1),ex1(:),wf4(:,6),G1tensor(38),m4h2x4x1(:,5),heltab3x8(:,:,10))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(3),wf4(:,6),ex1(:),G1tensor(43),m4h4x2x1(:,3),heltab3x8(:,:,11))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H8(12),ex1(:),wf4(:,6),G1tensor(48),m4h2x4x1(:,6),heltab3x8(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(90),9,wf4(:,6),6,G2tensor(12),m3h4x1(:,21),heltab2x4(:,:,192))
  call Hloop_QV_A(ntryL,G1H4(71),wf4(:,1),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(10),n2h1(154))
  call Hloop_QV_A(ntryL,G1H4(70),wf4(:,1),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(11),n2h1(155))
  call Hloop_QV_A(ntryL,G1H4(72),wf4(:,1),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,195))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(156))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(74),12,wf4(:,1),3,G2tensor(26),m3h4x1(:,25),heltab2x4(:,:,196))
  call Hloop_QV_A(ntryL,G1H4(79),wf4(:,3),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(25),n2h1(157))
  call Hloop_QV_A(ntryL,G1H4(77),wf4(:,3),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(21),n2h1(158))
  call Hloop_QV_A(ntryL,G1H4(80),wf4(:,3),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(19),n2h1(159))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(81),10,wf4(:,3),5,G2tensor(20),m3h4x1(:,29),heltab2x4(:,:,200))
  call Hloop_QV_A(ntryL,G1H4(86),wf4(:,6),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(160))
  call Hloop_QV_A(ntryL,G1H4(85),wf4(:,6),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(49),n2h1(161))
  call Hloop_QV_A(ntryL,G1H4(87),wf4(:,6),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,203))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(46),n2h1(162))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(89),9,wf4(:,6),6,G2tensor(34),m3h4x1(:,33),heltab2x4(:,:,204))
  call ol_merge_tensors(G1tensor(56),[G0tensor(105),G0tensor(101),G0tensor(86),G0tensor(23),G0tensor(21),G0tensor(2)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(25),G2tensor(16),G1tensor(62),G1tensor(57),G1tensor(52),G0tensor(104),G0tensor(60) &
    ,G0tensor(3)])
  call ol_merge_tensors(G1tensor(48),[G1tensor(43),G1tensor(38),G1tensor(66),G1tensor(81),G1tensor(61),G1tensor(71),G1tensor(51) &
    ,G1tensor(46),G0tensor(106),G0tensor(74),G0tensor(50),G0tensor(4)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(109),G0tensor(90),G0tensor(42),G0tensor(41),G0tensor(6)])
  call ol_merge_tensors(G2tensor(21),[G0tensor(113),G0tensor(64),G0tensor(7)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(78),G0tensor(44),G0tensor(8)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(111),G0tensor(93),G0tensor(79),G0tensor(65),G0tensor(47),G0tensor(17),G0tensor(29) &
    ,G0tensor(9)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(119),G0tensor(95),G0tensor(53),G0tensor(22),G0tensor(15)])
  call ol_merge_tensors(G2tensor(19),[G0tensor(123),G0tensor(69),G0tensor(20)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(83),G0tensor(39),G0tensor(25)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(121),G0tensor(98),G0tensor(84),G0tensor(70),G0tensor(56),G0tensor(33),G0tensor(11) &
    ,G0tensor(30)])
  call ol_merge_tensors(G1tensor(76),[G0tensor(58),G0tensor(38),G0tensor(26),G0tensor(40)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(23),G2tensor(12),G1tensor(77),G1tensor(72),G1tensor(67),G0tensor(102),G0tensor(88) &
    ,G0tensor(45)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(37),G0tensor(12),G0tensor(19)])
  call ol_merge_tensors(G2tensor(49),[G0tensor(110),G0tensor(92),G0tensor(24)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(52),G0tensor(28),G0tensor(34)])
  call ol_merge_tensors(G2tensor(46),[G0tensor(120),G0tensor(97),G0tensor(54)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(10),G2tensor(17),G1tensor(47),G1tensor(42),G1tensor(1),G0tensor(72),G0tensor(27) &
    ,G0tensor(31)])
  call ol_merge_tensors(G2tensor(11),[G0tensor(76),G0tensor(43),G0tensor(46)])
  call ol_merge_tensors(G2tensor(14),[G0tensor(81),G0tensor(55),G0tensor(13)])
  call ol_merge_tensors(G1tensor(41),[G0tensor(100),G0tensor(87),G0tensor(73),G0tensor(59)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(91),G0tensor(77),G0tensor(63)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(96),G0tensor(82),G0tensor(68)])
call TI_bubble_red(G2tensor(20),10,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(21),10,mass2set(:,2),G0tensor(5),M2L1R1,G0tensor(10))
call TI_bubble_red(G2tensor(19),10,mass2set(:,3),G0tensor(35),M2L1R1,G0tensor(14))
call TI_bubble_red(G2tensor(34),9,mass2set(:,1),G0tensor(49),M2L1R1)
call TI_bubble_red(G2tensor(49),9,mass2set(:,2),G0tensor(16),M2L1R1,G0tensor(36))
call TI_bubble_red(G2tensor(46),9,mass2set(:,3),G0tensor(51),M2L1R1,G0tensor(18))
call TI_bubble_red(G2tensor(26),12,mass2set(:,1),G0tensor(32),M2L1R1)
call TI_bubble_red(G2tensor(11),12,mass2set(:,2),G0tensor(48),M2L1R1,G0tensor(57))
call TI_bubble_red(G2tensor(14),12,mass2set(:,3),G0tensor(61),M2L1R1,G0tensor(66))
  call ol_merge_tensors(G0tensor(57),[G0tensor(36),G0tensor(116),G0tensor(10)])
  call ol_merge_tensors(G0tensor(66),[G0tensor(18),G0tensor(126),G0tensor(14)])
call TI_bubble_red(G1tensor(56),13,mass2set(:,1),G0tensor(71),M2L1R1)
call TI_bubble_red(G1tensor(48),8,mass2set(:,1),G0tensor(75),M2L1R1)
call TI_bubble_red(G1tensor(76),14,mass2set(:,1),G0tensor(80),M2L1R1)
call TI_bubble_red(G1tensor(41),11,mass2set(:,1),G0tensor(85),M2L1R1)
  call ol_merge_tensors(T0sum(46),[G0tensor(71)])
  call ol_merge_tensors(T0sum(47),[G0tensor(1)])
  call ol_merge_tensors(T0sum(48),[G0tensor(75)])
  call ol_merge_tensors(T0sum(49),[G0tensor(114)])
  call ol_merge_tensors(T0sum(50),[G0tensor(5)])
  call ol_merge_tensors(T0sum(51),[G0tensor(57)])
  call ol_merge_tensors(T0sum(52),[G0tensor(115)])
  call ol_merge_tensors(T0sum(53),[G0tensor(124)])
  call ol_merge_tensors(T0sum(54),[G0tensor(35)])
  call ol_merge_tensors(T0sum(55),[G0tensor(66)])
  call ol_merge_tensors(T0sum(56),[G0tensor(125)])
  call ol_merge_tensors(T0sum(57),[G0tensor(80)])
  call ol_merge_tensors(T0sum(58),[G0tensor(49)])
  call ol_merge_tensors(T0sum(59),[G0tensor(62)])
  call ol_merge_tensors(T0sum(60),[G0tensor(16)])
  call ol_merge_tensors(T0sum(61),[G0tensor(67)])
  call ol_merge_tensors(T0sum(62),[G0tensor(51)])
  call ol_merge_tensors(T0sum(63),[G0tensor(32)])
  call ol_merge_tensors(T0sum(64),[G0tensor(48)])
  call ol_merge_tensors(T0sum(65),[G0tensor(61)])
  call ol_merge_tensors(T0sum(66),[G0tensor(85)])
  call ol_merge_tensors(T0sum(67),[G0tensor(108)])
  call ol_merge_tensors(T0sum(68),[G0tensor(118)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppjj_gggg_1_/**/REALKIND
