
module ol_vamp_1_ppjj_ddxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppjj_ddxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppjj_ddxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppjj_ddxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppjj_ddxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppjj_ddxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppjj_ddxgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(3,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(3),n2h8(2))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(6),n2h8(3))
  call Hloop_QA_V(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(2),10,0,G2H4(1),n2h4(1))
  call Hloop_AQ_V(ntryL,G1H8(3),ex1(:),G1H4(2),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(3),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(3),9,0,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(3),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(3),9,0,G2H4(3),n2h4(3))
  call Hloop_AQ_V(ntryL,G1H8(6),ex1(:),G1H4(3),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_AQ_V(ntryL,G2H4(1),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VA_Q(ntryL,G1H4(2),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(3),n2h2(2))
  call Hloop_QA_V(ntryL,G2H4(2),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,1),  & 
G1H4(1),G1H4(2),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),2,4)
  call Hloop_UV_W(ntryL,G1H4(3),9,ex3(:),4,G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QV_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),13,0,G2H2(6),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QV_A(ntryL,G1H4(5),ex3(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(2),13,0,G2H2(7),n2h2(4))
  call Hloop_QV_A(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(2),13,0,G2H2(8),n2h2(5))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(2),mass4set(:,1),  & 
G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(3),4,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(2),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),4,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(3),mass4set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(13),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(3),mass4set(:,1),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),2)
  call HG1shiftOLR(G1H2(18),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(1),mass4set(:,1),  & 
G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(23),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(1))
  call Hloop_QV_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(4),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(7),11,ex3(:),4,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(8),0,ex3(:),4,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(11),11,ex3(:),4,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_AV_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(17),11,ex3(:),4,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),0,ex3(:),4,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(21),11,ex3(:),4,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(16),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(17),n2h1(11))
  call ol_merge_tensors(G2tensor(15),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(9)])
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[12,1,2],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(1),m4h2x2x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[12,1,2],[0,0,0],4,0)
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(2),m4h2x2x4(:,2),heltab3x16(:,:,2))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[12,1,2],[0,0,0],4,0)
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(3),m4h2x2x4(:,3),heltab3x16(:,:,3))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(1),n2h8(4))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(2),n2h8(5))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(3),n2h8(6))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMT,G1H8(4),n2h8(7))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(5),n2h8(8))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(6),n2h8(9))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(7),n2h8(10))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(8),n2h8(11))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(9),m3h2x8(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(10),m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(11),m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,2,5],[0,0,0],3,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,2,5],[0,0,0],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(13),m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,6],[0,0,0],3,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(14),n2h8(13))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,6],[0,0,0],3,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(15),m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[9,2,4],[0,0,0],3,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,8),G0H4(4),m3h4x4(:,1),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[9,2,4],[0,0,0],3,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H16(1),wf4(:,8),G0H4(5),m3h4x4(:,2),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(5),9,0,G1H4(3),n2h4(5))
  Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[10,1,4],[0,0,0],3,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,15),G0H4(5),m3h4x4(:,3),heltab2x16(:,:,24))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[10,1,4],[0,0,0],3,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(6),m3h4x4(:,4),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H4(6),10,0,G1H4(1),n2h4(6))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(6),m3h4x4(:,5),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H4(6),12,0,G1H4(2),n2h4(7))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[12,1,2],[0,0,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(5),m3h4x4(:,6),heltab2x16(:,:,27))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(3)])
  call Hloop_QV_A(ntryL,G1H4(4),ex3(:),G1H2(2),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(2),13,0,G2H2(1),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(5),ex1(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(3),13,0,G2H2(2),n2h2(7))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,1),G1H2(6),m3h4x2(:,1),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(6),11,0,G2H2(3),n2h2(8))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,1),G1H2(7),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMT,G2H2(4),n2h2(9))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(8),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(8),11,0,G2H2(5),n2h2(10))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,1),G1H2(11),m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(11),11,nMT,G2H2(6),n2h2(11))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,1),G1H2(12),m3h4x2(:,5),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(12),11,nMB,G2H2(8),n2h2(12))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,1),G1H2(13),m3h4x2(:,6),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(13),11,nMB,G2H2(9),n2h2(13))
  call Hloop_DV_C(ntryL,G1H8(9),8,wf4(:,1),G2H2(10),m3h4x2(:,7),heltab2x8(:,:,13))
  call Hloop_CV_D(ntryL,G1H8(10),8,wf4(:,1),3,G2H2(11),m3h4x2(:,8),heltab2x8(:,:,14))
  call Hloop_UV_W(ntryL,G1H8(11),8,wf4(:,1),3,G2H2(12),m3h4x2(:,9),heltab2x8(:,:,15))
  call Hloop_QA_V(ntryL,G1H8(12),ex2(:),G1H4(6),m3h2x4(:,7),heltab2x8(:,:,16))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(4),m3h2x4(:,8),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(4),10,0,G2H4(1),n2h4(8))
  call Hloop_AQ_V(ntryL,G1H8(14),ex1(:),G1H4(5),m3h2x4(:,9),heltab2x8(:,:,18))
  call Hloop_VQ_A(ntryL,G1H8(15),ex1(:),G1H4(4),m3h2x4(:,10),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(4),9,0,G2H4(2),n2h4(9))
  call Hloop_VA_Q(ntryL,G0H4(4),ex2(:),G0H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G0H2(1),11,0,G1H2(16),n2h2(14))
  call Hloop_QA_V(ntryL,G1H4(3),ex2(:),G1H2(17),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VQ_A(ntryL,G0H4(5),ex1(:),G0H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G0H2(1),11,0,G1H2(18),n2h2(15))
  call Hloop_AQ_V(ntryL,G1H4(1),ex1(:),G1H2(21),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(22),m3h2x2(:,16),heltab2x4(:,:,16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(4)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(20),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(19)])
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(12))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(3),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hloop_QV_A(ntryL,G2H2(5),ex3(:),G2H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(1),n2h1(13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(21),11,ex3(:),4,G2tensor(9),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(12),11,ex3(:),4,G3tensor(2),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_AV_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(14))
  call Hloop_AV_Q(ntryL,G2H2(3),ex3(:),G2H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(3),n2h1(15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(17),11,ex3(:),4,G2tensor(6),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(19),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(20),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hloop_AV_Q(ntryL,G2H2(4),ex3(:),G2H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(4),n2h1(18))
  call Hloop_QV_A(ntryL,G2H2(6),ex3(:),G2H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(5),n2h1(19))
  call Hloop_AV_Q(ntryL,G2H2(8),ex3(:),G2H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(6),n2h1(20))
  call Hloop_QV_A(ntryL,G2H2(9),ex3(:),G2H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(7),n2h1(21))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(10),11,ex3(:),G3tensor(8),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(11),11,ex3(:),4,G3tensor(9),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hloop_VQ_A(ntryL,G1H4(6),wf4(:,5),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(1),wf4(:,5),G2tensor(22),m3h4x1(:,2),heltab2x4(:,:,18))
  call Hloop_VA_Q(ntryL,G1H4(5),wf4(:,13),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(2),wf4(:,13),G2tensor(24),m3h4x1(:,4),heltab2x4(:,:,20))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(25),n2h1(24))
  call ol_merge_tensors(G2tensor(24),[G2tensor(23),G2tensor(17),G2tensor(14),G2tensor(11),G2tensor(2),G1tensor(15),G1tensor(5) &
    ,G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(4),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(21),G2tensor(8),G2tensor(5),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(20),G2tensor(13),G2tensor(10),G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(1),G2tensor(16),G1tensor(8),G1tensor(2),G0tensor(8),G0tensor(2)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(12),G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(3),G1tensor(4),G0tensor(4)])
  call ol_merge_tensors(G3tensor(9),[G3tensor(8),G3tensor(3),G3tensor(2),G3tensor(1),G1tensor(14),G1tensor(9),G0tensor(14) &
    ,G0tensor(9)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(15),G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(4)])
  call ol_merge_tensors(G3tensor(7),[G3tensor(6)])
  call TI_triangle_red(G2tensor(24),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(15),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(8),mass3set(:,1),G0tensor(5),G0tensor(7),G0tensor(10),G0tensor(12),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(4),mass3set(:,1),G0tensor(8),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(9),mass3set(:,1),G0tensor(14),G0tensor(9),G0tensor(13),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(6),mass3set(:,1),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(3),mass3set(:,1),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(2),mass3set(:,1),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),M2L1R1)
  call TI_triangle_red(G3tensor(9),RedBasis(5),mass3set(:,1),G0tensor(29),G0tensor(30),G0tensor(31),G0tensor(32),M2L1R1)
  call TI_triangle_red(G2tensor(6),RedBasis(7),mass3set(:,1),G0tensor(33),G0tensor(34),G0tensor(35),G0tensor(36),M2L1R1)
  call TI_triangle_red(G3tensor(5),RedBasis(5),mass3set(:,2),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40),M2L1R1,[nMT], &
    G0tensor(41))
  call TI_triangle_red(G3tensor(7),RedBasis(5),mass3set(:,3),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45),M2L1R1,[nMB], &
    G0tensor(46))
  call ol_merge_tensors(T0sum(4),[G0tensor(1)])
  call ol_merge_tensors(T0sum(5),[G0tensor(5)])
  call ol_merge_tensors(T0sum(6),[G0tensor(8)])
  call ol_merge_tensors(T0sum(7),[G0tensor(14)])
  call ol_merge_tensors(T0sum(8),[G0tensor(17)])
  call ol_merge_tensors(T0sum(9),[G0tensor(21)])
  call ol_merge_tensors(T0sum(10),[G0tensor(25)])
  call ol_merge_tensors(T0sum(11),[G0tensor(29)])
  call ol_merge_tensors(T0sum(12),[G0tensor(33)])
  call ol_merge_tensors(T0sum(13),[G0tensor(37)])
  call ol_merge_tensors(T0sum(14),[G0tensor(42)])
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[11,4],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),wf4(:,1),G0H2(1),m4h2x4x2(:,1),heltab3x16(:,:,4))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[11,4],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),wf4(:,1),ex4(:),G0H2(2),m4h4x2x2(:,1),heltab3x16(:,:,5))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[11,4],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),wf4(:,1),G0H2(3),m4h2x4x2(:,2),heltab3x16(:,:,6))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,7],[0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(1),m3h2x8(:,22),heltab2x16(:,:,28))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,7],[0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(3),m3h2x8(:,23),heltab2x16(:,:,29))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,7],[0,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(5),m3h2x8(:,24),heltab2x16(:,:,30))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[12,3],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(6),m4h2x2x4(:,4),heltab3x16(:,:,7))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[12,3],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H16(1),ex3(:),ex4(:),G0H4(3),m4h2x2x4(:,5),heltab3x16(:,:,8))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[12,3],[0,0],3,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(2),m4h2x2x4(:,6),heltab3x16(:,:,9))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,7),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),12,0,G1H4(4),n2h4(10))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,8),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(4),12,nMT,G1H4(3),n2h4(11))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(5),m3h4x4(:,9),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(5),12,0,G1H4(1),n2h4(12))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,10),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(2),n2h4(13))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(6),m3h4x4(:,11),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(5),m3h4x4(:,12),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[10,5],[0,0],2,2,wf4(:,15),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(4),m3h4x4(:,13),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H4(4),10,0,G1H4(7),n2h4(14))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[9,6],[0,0],2,2,wf4(:,8),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,8),G0H4(5),m3h4x4(:,14),heltab2x16(:,:,38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(3),[G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(2),G0H4(3),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(4)])
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(3),11,ex3(:),4,G1tensor(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(1),ex3(:),wf4(:,1),G1tensor(6),m4h2x4x1(:,1),heltab3x8(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H8(3),wf4(:,1),ex3(:),G1tensor(11),m4h4x2x1(:,1),heltab3x8(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H8(5),ex3(:),wf4(:,1),G1tensor(15),m4h2x4x1(:,2),heltab3x8(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(5),12,wf4(:,1),3,G2tensor(23),m3h4x1(:,5),heltab2x4(:,:,21))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(17),n2h1(25))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,1),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(14),n2h1(26))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(27))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(6),12,wf4(:,1),3,G2tensor(2),m3h4x1(:,9),heltab2x4(:,:,25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(7),wf4(:,5),G1tensor(5),m3h4x1(:,10),heltab2x4(:,:,26))
  call Hloop_VA_Q(ntryL,G0H4(5),wf4(:,13),G0H1(1),m3h4x1(:,11),heltab2x4(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,0,G1tensor(7),n2h1(28))
  call ol_merge_tensors(G0tensor(18),[G0tensor(9),G0tensor(10),G0tensor(6)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(36),G0tensor(24),G0tensor(11)])
  call ol_merge_tensors(G1tensor(15),[G1tensor(11),G1tensor(6),G0tensor(32),G0tensor(28),G0tensor(4),G0tensor(15)])
  call ol_merge_tensors(G0tensor(34),[G0tensor(27),G0tensor(23),G0tensor(13),G0tensor(2),G0tensor(7)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(17),G2tensor(23),G0tensor(30),G0tensor(16),G0tensor(12)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(26),G0tensor(20),G0tensor(3)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(35),G0tensor(31),G0tensor(22),G0tensor(19)])
  call ol_merge_tensors(G2tensor(14),[G0tensor(38)])
  call ol_merge_tensors(G2tensor(11),[G0tensor(43)])
call TI_bubble_red(G2tensor(2),12,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(14),12,mass2set(:,2),G0tensor(5),M2L1R1,G0tensor(8))
call TI_bubble_red(G2tensor(11),12,mass2set(:,3),G0tensor(14),M2L1R1,G0tensor(17))
  call ol_merge_tensors(G0tensor(41),[G0tensor(8)])
  call ol_merge_tensors(G0tensor(46),[G0tensor(17)])
call TI_bubble_red(G1tensor(7),9,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(15),8,mass2set(:,1),G0tensor(25),M2L1R1)
call TI_bubble_red(G1tensor(5),10,mass2set(:,1),G0tensor(29),M2L1R1)
call TI_bubble_red(G1tensor(1),11,mass2set(:,1),G0tensor(33),M2L1R1)
  call ol_merge_tensors(T0sum(15),[G0tensor(18)])
  call ol_merge_tensors(T0sum(16),[G0tensor(21)])
  call ol_merge_tensors(T0sum(17),[G0tensor(25)])
  call ol_merge_tensors(T0sum(18),[G0tensor(34)])
  call ol_merge_tensors(T0sum(19),[G0tensor(1)])
  call ol_merge_tensors(T0sum(20),[G0tensor(29)])
  call ol_merge_tensors(T0sum(21),[G0tensor(33)])
  call ol_merge_tensors(T0sum(22),[G0tensor(5)])
  call ol_merge_tensors(T0sum(23),[G0tensor(41)])
  call ol_merge_tensors(T0sum(24),[G0tensor(39)])
  call ol_merge_tensors(T0sum(25),[G0tensor(40)])
  call ol_merge_tensors(T0sum(26),[G0tensor(14)])
  call ol_merge_tensors(T0sum(27),[G0tensor(46)])
  call ol_merge_tensors(T0sum(28),[G0tensor(44)])
  call ol_merge_tensors(T0sum(29),[G0tensor(45)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppjj_ddxgg_1_/**/REALKIND
