
module ol_colourmatrix_ppjj_gggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(72,6), K2(72,9), KL(72,9), Cas(4) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  38,  -4,  -4,  -4,  -4,   8]
  K1( 2,:) = [  -4,  38,  -4,   8,  -4,  -4]
  K1( 3,:) = [  -4,  -4,  38,  -4,   8,  -4]
  K1( 4,:) = [  -4,   8,  -4,  38,  -4,  -4]
  K1( 5,:) = [  -4,  -4,   8,  -4,  38,  -4]
  K1( 6,:) = [   8,  -4,  -4,  -4,  -4,  38]
  K1( 7,:) = [ 114, -12, -12, -12, -12,  24]
  K1( 8,:) = [ -12, 114, -12,  24, -12, -12]
  K1( 9,:) = [ -12, -12, 114, -12,  24, -12]
  K1(10,:) = [ -12,  24, -12, 114, -12, -12]
  K1(11,:) = [ -12, -12,  24, -12, 114, -12]
  K1(12,:) = [  24, -12, -12, -12, -12, 114]
  K1(13,:) = [ -65,  -2,   7,  -2,   7, -20]
  K1(14,:) = [  -2, -65,   7, -20,   7,  -2]
  K1(15,:) = [   7,   7,  16,   7,  16,   7]
  K1(16,:) = [  -2, -20,   7, -65,   7,  -2]
  K1(17,:) = [   7,   7,  16,   7,  16,   7]
  K1(18,:) = [ -20,  -2,   7,  -2,   7, -65]
  K1(19,:) = [ 114, -12, -12, -12, -12,  24]
  K1(20,:) = [ -12, 114, -12,  24, -12, -12]
  K1(21,:) = [ -12, -12, 114, -12,  24, -12]
  K1(22,:) = [ -12,  24, -12, 114, -12, -12]
  K1(23,:) = [ -12, -12,  24, -12, 114, -12]
  K1(24,:) = [  24, -12, -12, -12, -12, 114]
  K1(25,:) = [  16,   7,   7,   7,   7,  16]
  K1(26,:) = [   7, -65,  -2, -20,  -2,   7]
  K1(27,:) = [   7,  -2, -65,  -2, -20,   7]
  K1(28,:) = [   7, -20,  -2, -65,  -2,   7]
  K1(29,:) = [   7,  -2, -20,  -2, -65,   7]
  K1(30,:) = [  16,   7,   7,   7,   7,  16]
  K1(31,:) = [ -65,   7,  -2,   7,  -2, -20]
  K1(32,:) = [   7,  16,   7,  16,   7,   7]
  K1(33,:) = [  -2,   7, -65,   7, -20,  -2]
  K1(34,:) = [   7,  16,   7,  16,   7,   7]
  K1(35,:) = [  -2,   7, -20,   7, -65,  -2]
  K1(36,:) = [ -20,   7,  -2,   7,  -2, -65]
  K1(37,:) = [ 114, -12, -12, -12, -12,  24]
  K1(38,:) = [ -12, 114, -12,  24, -12, -12]
  K1(39,:) = [ -12, -12, 114, -12,  24, -12]
  K1(40,:) = [ -12,  24, -12, 114, -12, -12]
  K1(41,:) = [ -12, -12,  24, -12, 114, -12]
  K1(42,:) = [  24, -12, -12, -12, -12, 114]
  K1(43,:) = [ -65,   7,  -2,   7,  -2, -20]
  K1(44,:) = [   7,  16,   7,  16,   7,   7]
  K1(45,:) = [  -2,   7, -65,   7, -20,  -2]
  K1(46,:) = [   7,  16,   7,  16,   7,   7]
  K1(47,:) = [  -2,   7, -20,   7, -65,  -2]
  K1(48,:) = [ -20,   7,  -2,   7,  -2, -65]
  K1(49,:) = [  16,   7,   7,   7,   7,  16]
  K1(50,:) = [   7, -65,  -2, -20,  -2,   7]
  K1(51,:) = [   7,  -2, -65,  -2, -20,   7]
  K1(52,:) = [   7, -20,  -2, -65,  -2,   7]
  K1(53,:) = [   7,  -2, -20,  -2, -65,   7]
  K1(54,:) = [  16,   7,   7,   7,   7,  16]
  K1(55,:) = [ -65,  -2,   7,  -2,   7, -20]
  K1(56,:) = [  -2, -65,   7, -20,   7,  -2]
  K1(57,:) = [   7,   7,  16,   7,  16,   7]
  K1(58,:) = [  -2, -20,   7, -65,   7,  -2]
  K1(59,:) = [   7,   7,  16,   7,  16,   7]
  K1(60,:) = [ -20,  -2,   7,  -2,   7, -65]
  K1(61,:) = [ 114, -12, -12, -12, -12,  24]
  K1(62,:) = [ -12, 114, -12,  24, -12, -12]
  K1(63,:) = [ -12, -12, 114, -12,  24, -12]
  K1(64,:) = [ -12,  24, -12, 114, -12, -12]
  K1(65,:) = [ -12, -12,  24, -12, 114, -12]
  K1(66,:) = [  24, -12, -12, -12, -12, 114]
  K1(67,:) = [   0,   0,   0,   0,   0,   0]
  K1(68,:) = [   0,   0,   0,   0,   0,   0]
  K1(69,:) = [   0,   0,   0,   0,   0,   0]
  K1(70,:) = [   0,   0,   0,   0,   0,   0]
  K1(71,:) = [   0,   0,   0,   0,   0,   0]
  K1(72,:) = [   0,   0,   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 12) * K1

  K2( 1,:) = [  16,  -2,  16,  38,  -4,  -4,  -4,  -4,   8]
  K2( 2,:) = [  -2,  16,  16,  -4,  38,  -4,   8,  -4,  -4]
  K2( 3,:) = [  16,  16,  -2,  -4,  -4,  38,  -4,   8,  -4]
  K2( 4,:) = [  -2,  16,  16,  -4,   8,  -4,  38,  -4,  -4]
  K2( 5,:) = [  16,  16,  -2,  -4,  -4,   8,  -4,  38,  -4]
  K2( 6,:) = [  16,  -2,  16,   8,  -4,  -4,  -4,  -4,  38]
  K2( 7,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  K2( 8,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  K2( 9,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  K2(10,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  K2(11,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  K2(12,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  K2(13,:) = [ -27,   0, -48, -65,  -2,   7,  -2,   7, -20]
  K2(14,:) = [   0, -27, -48,  -2, -65,   7, -20,   7,  -2]
  K2(15,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  K2(16,:) = [   0, -27, -48,  -2, -20,   7, -65,   7,  -2]
  K2(17,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  K2(18,:) = [ -27,   0, -48, -20,  -2,   7,  -2,   7, -65]
  K2(19,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  K2(20,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  K2(21,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  K2(22,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  K2(23,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  K2(24,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  K2(25,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  K2(26,:) = [   0, -48, -27,   7, -65,  -2, -20,  -2,   7]
  K2(27,:) = [ -27, -48,   0,   7,  -2, -65,  -2, -20,   7]
  K2(28,:) = [   0, -48, -27,   7, -20,  -2, -65,  -2,   7]
  K2(29,:) = [ -27, -48,   0,   7,  -2, -20,  -2, -65,   7]
  K2(30,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  K2(31,:) = [ -48,   0, -27, -65,   7,  -2,   7,  -2, -20]
  K2(32,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  K2(33,:) = [ -48, -27,   0,  -2,   7, -65,   7, -20,  -2]
  K2(34,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  K2(35,:) = [ -48, -27,   0,  -2,   7, -20,   7, -65,  -2]
  K2(36,:) = [ -48,   0, -27, -20,   7,  -2,   7,  -2, -65]
  K2(37,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  K2(38,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  K2(39,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  K2(40,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  K2(41,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  K2(42,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  K2(43,:) = [ -48,   0, -27, -65,   7,  -2,   7,  -2, -20]
  K2(44,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  K2(45,:) = [ -48, -27,   0,  -2,   7, -65,   7, -20,  -2]
  K2(46,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  K2(47,:) = [ -48, -27,   0,  -2,   7, -20,   7, -65,  -2]
  K2(48,:) = [ -48,   0, -27, -20,   7,  -2,   7,  -2, -65]
  K2(49,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  K2(50,:) = [   0, -48, -27,   7, -65,  -2, -20,  -2,   7]
  K2(51,:) = [ -27, -48,   0,   7,  -2, -65,  -2, -20,   7]
  K2(52,:) = [   0, -48, -27,   7, -20,  -2, -65,  -2,   7]
  K2(53,:) = [ -27, -48,   0,   7,  -2, -20,  -2, -65,   7]
  K2(54,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  K2(55,:) = [ -27,   0, -48, -65,  -2,   7,  -2,   7, -20]
  K2(56,:) = [   0, -27, -48,  -2, -65,   7, -20,   7,  -2]
  K2(57,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  K2(58,:) = [   0, -27, -48,  -2, -20,   7, -65,   7,  -2]
  K2(59,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  K2(60,:) = [ -27,   0, -48, -20,  -2,   7,  -2,   7, -65]
  K2(61,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  K2(62,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  K2(63,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  K2(64,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  K2(65,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  K2(66,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  K2(67,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K2(68,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K2(69,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K2(70,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K2(71,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K2(72,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K2 = (1._/**/REALKIND / 12) * K2

  KL( 1,:) = [  16,  -2,  16,  38,  -4,  -4,  -4,  -4,   8]
  KL( 2,:) = [  -2,  16,  16,  -4,  38,  -4,   8,  -4,  -4]
  KL( 3,:) = [  16,  16,  -2,  -4,  -4,  38,  -4,   8,  -4]
  KL( 4,:) = [  -2,  16,  16,  -4,   8,  -4,  38,  -4,  -4]
  KL( 5,:) = [  16,  16,  -2,  -4,  -4,   8,  -4,  38,  -4]
  KL( 6,:) = [  16,  -2,  16,   8,  -4,  -4,  -4,  -4,  38]
  KL( 7,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  KL( 8,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  KL( 9,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  KL(10,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  KL(11,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  KL(12,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  KL(13,:) = [ -27,   0, -48, -65,  -2,   7,  -2,   7, -20]
  KL(14,:) = [   0, -27, -48,  -2, -65,   7, -20,   7,  -2]
  KL(15,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  KL(16,:) = [   0, -27, -48,  -2, -20,   7, -65,   7,  -2]
  KL(17,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  KL(18,:) = [ -27,   0, -48, -20,  -2,   7,  -2,   7, -65]
  KL(19,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  KL(20,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  KL(21,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  KL(22,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  KL(23,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  KL(24,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  KL(25,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  KL(26,:) = [   0, -48, -27,   7, -65,  -2, -20,  -2,   7]
  KL(27,:) = [ -27, -48,   0,   7,  -2, -65,  -2, -20,   7]
  KL(28,:) = [   0, -48, -27,   7, -20,  -2, -65,  -2,   7]
  KL(29,:) = [ -27, -48,   0,   7,  -2, -20,  -2, -65,   7]
  KL(30,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  KL(31,:) = [ -48,   0, -27, -65,   7,  -2,   7,  -2, -20]
  KL(32,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  KL(33,:) = [ -48, -27,   0,  -2,   7, -65,   7, -20,  -2]
  KL(34,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  KL(35,:) = [ -48, -27,   0,  -2,   7, -20,   7, -65,  -2]
  KL(36,:) = [ -48,   0, -27, -20,   7,  -2,   7,  -2, -65]
  KL(37,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  KL(38,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  KL(39,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  KL(40,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  KL(41,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  KL(42,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  KL(43,:) = [ -48,   0, -27, -65,   7,  -2,   7,  -2, -20]
  KL(44,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  KL(45,:) = [ -48, -27,   0,  -2,   7, -65,   7, -20,  -2]
  KL(46,:) = [   6,  27,  27,   7,  16,   7,  16,   7,   7]
  KL(47,:) = [ -48, -27,   0,  -2,   7, -20,   7, -65,  -2]
  KL(48,:) = [ -48,   0, -27, -20,   7,  -2,   7,  -2, -65]
  KL(49,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  KL(50,:) = [   0, -48, -27,   7, -65,  -2, -20,  -2,   7]
  KL(51,:) = [ -27, -48,   0,   7,  -2, -65,  -2, -20,   7]
  KL(52,:) = [   0, -48, -27,   7, -20,  -2, -65,  -2,   7]
  KL(53,:) = [ -27, -48,   0,   7,  -2, -20,  -2, -65,   7]
  KL(54,:) = [  27,   6,  27,  16,   7,   7,   7,   7,  16]
  KL(55,:) = [ -27,   0, -48, -65,  -2,   7,  -2,   7, -20]
  KL(56,:) = [   0, -27, -48,  -2, -65,   7, -20,   7,  -2]
  KL(57,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  KL(58,:) = [   0, -27, -48,  -2, -20,   7, -65,   7,  -2]
  KL(59,:) = [  27,  27,   6,   7,   7,  16,   7,  16,   7]
  KL(60,:) = [ -27,   0, -48, -20,  -2,   7,  -2,   7, -65]
  KL(61,:) = [  48,  -6,  48, 114, -12, -12, -12, -12,  24]
  KL(62,:) = [  -6,  48,  48, -12, 114, -12,  24, -12, -12]
  KL(63,:) = [  48,  48,  -6, -12, -12, 114, -12,  24, -12]
  KL(64,:) = [  -6,  48,  48, -12,  24, -12, 114, -12, -12]
  KL(65,:) = [  48,  48,  -6, -12, -12,  24, -12, 114, -12]
  KL(66,:) = [  48,  -6,  48,  24, -12, -12, -12, -12, 114]
  KL(67,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  KL(68,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  KL(69,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  KL(70,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  KL(71,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  KL(72,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0]
  KL = (1._/**/REALKIND / 12) * KL

#if 1 > 0
    co = 0
    do k = 1, 4
      co = co + k
      Cas(k) = K1(1+6*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppjj_gggg_1_/**/REALKIND



module ol_forced_parameters_ppjj_gggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppjj_gggg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppjj_gggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:)
  complex(REALKIND), save :: den(9)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,15), wf8(8,6), wf16(16,21)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(11), c(10)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(9,16), M0M1_hel_cc(9,16,11)
  complex(REALKIND), save :: M2ctcc(11)

end module ol_loop_storage_ppjj_gggg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppjj_gggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppjj_gggg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**2
    f( 2) = CI*countertermnorm*gQCD**4
    f( 3) = CI*countertermnorm*ctVVV*gQCD**4
    f( 4) = CI*countertermnorm*ctVVVV*gQCD**4
    f( 5) = CI*countertermnorm*gQCD**4*R2GGGG
    f( 6) = (gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f( 7) = gQCD**4*integralnorm*SwB
    f( 8) = CI*gQCD**4*integralnorm*SwF
    f( 9) = 2*CI*gQCD**4*integralnorm*SwF
    f(10) = gQCD**4*integralnorm*SwF
    f(11) = 2*gQCD**4*integralnorm*SwF

  c = [ 2*f(6), 3*f(6), 6*f(6), 2*f(7), 3*f(7), 6*f(7), CI*f(8), CI*f(9), f(10), f(11) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,5))+L(6,5))
  den(3) = 1 /((L(5,9))+L(6,9))
  den(4) = 1 /((L(5,6))+L(6,6))
  den(5) = 1 /((L(5,10))+L(6,10))
  den(6) = 1 /((L(5,12))+L(6,12))

  ! denominators
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(5)
  den(9) = den(3)*den(4)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppjj_gggg_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for glue glue glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppjj_gggg_1, only: &
    & external_perm_ppjj_gggg_1, &
    & external_perm_inv_ppjj_gggg_1, &
    & extcomb_perm_ppjj_gggg_1, &
    & average_factor_ppjj_gggg_1, &
    & photonid_ppjj_gggg_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppjj_gggg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppjj_gggg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppjj_gggg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppjj_gggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,4)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(11)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,4)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,4)
#endif
  integer           :: extmasses2(4)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(11)
  complex(REALKIND) :: M1(6), M2(9)
  real(REALKIND)    :: P_scatt_intern(0:3,4)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,16)
  type(Hpolcont) :: M1helarray_ct(9,16)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(11), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 4 > 3
  integer :: ind_cc_comb(2)
#endif
!  type(Hpolcont) :: A(16,21)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(21)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,21))
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppjj_gggg_1, 4, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_V(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_V(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_GGG_G(ntry, ex1(:), ex2(:), ex3(:), wf8(:,1), n4(:,1), t4x8(:,:,1))
  call vert_GGG_G(ntry, ex2(:), ex3(:), ex1(:), wf8(:,2), n4(:,2), t4x8(:,:,2))
  call vert_GGG_G(ntry, ex3(:), ex1(:), ex2(:), wf8(:,3), n4(:,3), t4x8(:,:,3))
  call vert_UV_W(ntry, ex1(:), 1, ex2(:), 2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_UV_W(ntry, ex1(:), 1, ex3(:), 4, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_UV_W(ntry, ex2(:), 2, ex4(:), 8, wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_UV_W(ntry, ex1(:), 1, ex4(:), 8, wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_UV_W(ntry, ex2(:), 2, ex3(:), 4, wf4(:,6), n3(:,6), t3x4(:,:,6))
  call counter_GGG_G(ntry, ex1(:), ex2(:), ex3(:), wf8(:,4), n4(:,4), t4x8(:,:,4))
  call counter_GGG_G(ntry, ex2(:), ex3(:), ex1(:), wf8(:,5), n4(:,5), t4x8(:,:,5))
  call counter_GGG_G(ntry, ex3(:), ex1(:), ex2(:), wf8(:,6), n4(:,6), t4x8(:,:,6))
  call counter_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf4(:,7), n3(:,7), t3x4(:,:,7))
  call counter_UV_W(ntry, ex2(:), 2, ex4(:), 8, wf4(:,8), n3(:,8), t3x4(:,:,8))
  call counter_UV_W(ntry, ex2(:), 2, ex3(:), 4, wf4(:,9), n3(:,9), t3x4(:,:,9))
  call counter_UV_W(ntry, ex1(:), 1, ex4(:), 8, wf4(:,10), n3(:,10), t3x4(:,:,10))
  call counter_UV_W(ntry, ex1(:), 1, ex3(:), 4, wf4(:,11), n3(:,11), t3x4(:,:,11))
  call counter_UV_W(ntry, ex1(:), 1, ex2(:), 2, wf4(:,12), n3(:,12), t3x4(:,:,12))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,13), n2(1))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 5, wf4(:,14), n2(2))
  call counter_V_V(ctGG,21,ntry, wf4(:,5), 9, wf4(:,15), n2(3))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppjj_gggg_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

#if 1 > 0 && 4 > 3
  !!Born-loop colour correlators interference
  ind_cc_comb = [8,9]
  M0M1_hel_cc(:,:,:)%j = 0
  M2ctcc = 0
  do n = 1, 2
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4
integer :: n

n=0

do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf
 end if
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, ex4(:), wf8(:,1), A(:,1), n3(:,13), t3x16(:,:,1), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,2), A(:,2), n3(:,14), t3x16(:,:,2), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,3), A(:,3), n3(:,15), t3x16(:,:,3), nhel, cONE)
    call Hcont_VV(nsync, wf4(:,1), wf4(:,2), A(:,4), n3(:,16), t3x16(:,:,4), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,4), A(:,5), n3(:,17), t3x16(:,:,5), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,6), A(:,6), n3(:,18), t3x16(:,:,6), nhel, den(3))

    call Hcont_VV(nsync, ex4(:), wf8(:,4), A(:,7), n3(:,19), t3x16(:,:,7), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,5), A(:,8), n3(:,20), t3x16(:,:,8), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,6), A(:,9), n3(:,21), t3x16(:,:,9), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,4), A(:,10), n3(:,22), t3x16(:,:,10), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,5), A(:,11), n3(:,23), t3x16(:,:,11), nhel, cONE)
    call Hcont_VV(nsync, ex4(:), wf8(:,6), A(:,12), n3(:,24), t3x16(:,:,12), nhel, cONE)
    call Hcont_VV(nsync, wf4(:,1), wf4(:,7), A(:,13), n3(:,25), t3x16(:,:,13), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,8), A(:,14), n3(:,26), t3x16(:,:,14), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,9), A(:,15), n3(:,27), t3x16(:,:,15), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,10), A(:,16), n3(:,28), t3x16(:,:,16), nhel, den(4))
    call Hcont_VV(nsync, wf4(:,4), wf4(:,11), A(:,17), n3(:,29), t3x16(:,:,17), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,12), A(:,18), n3(:,30), t3x16(:,:,18), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,13), A(:,19), n3(:,31), t3x16(:,:,19), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,4), wf4(:,14), A(:,20), n3(:,32), t3x16(:,:,20), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,15), A(:,21), n3(:,33), t3x16(:,:,21), nhel, den(9))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(9) ! M1helarray(9,16)
  integer :: empty(0), i

  M1(1)%j = 2*(A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,6)%j)*f(1)
  M1(2)%j = 2*(-A(j,1)%j+A(j,3)%j-A(j,4)%j-A(j,5)%j)*f(1)
  M1(3)%j = 2*(A(j,2)%j-A(j,3)%j+A(j,5)%j+A(j,6)%j)*f(1)
  M1(4)%j = 2*(-A(j,1)%j+A(j,3)%j-A(j,4)%j-A(j,5)%j)*f(1)
  M1(5)%j = 2*(A(j,2)%j-A(j,3)%j+A(j,5)%j+A(j,6)%j)*f(1)
  M1(6)%j = 2*(A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,6)%j)*f(1)

  M2(1)%j = (4*(-A(j,10)%j-A(j,11)%j-A(j,12)%j)*f(5))/3._/**/REALKIND
  M2(2)%j = (4*(-A(j,10)%j-A(j,11)%j-A(j,12)%j)*f(5))/3._/**/REALKIND
  M2(3)%j = (4*(-A(j,10)%j-A(j,11)%j-A(j,12)%j)*f(5))/3._/**/REALKIND
  M2(4)%j = 2*(-A(j,19)%j+A(j,21)%j)*f(2)+2*(A(j,13)%j-A(j,15)%j-A(j,16)%j+A(j,18)%j)*f(3)+2*(-A(j,7)%j-A(j,8)%j)*f(4) &
       +4*A(j,9)%j*f(4)+19*(A(j,10)%j+A(j,11)%j)*f(5)-36*A(j,12)%j*f(5)
  M2(5)%j = 2*(A(j,19)%j+A(j,20)%j)*f(2)+2*(-A(j,13)%j-A(j,14)%j-A(j,17)%j-A(j,18)%j)*f(3)+4*A(j,8)%j*f(4)+2*(-A(j,7)%j &
       -A(j,9)%j)*f(4)-36*A(j,11)%j*f(5)+19*(A(j,10)%j+A(j,12)%j)*f(5)
  M2(6)%j = 2*(-A(j,20)%j-A(j,21)%j)*f(2)+2*(A(j,14)%j+A(j,15)%j+A(j,16)%j+A(j,17)%j)*f(3)+4*A(j,7)%j*f(4)+2*(-A(j,8)%j &
       -A(j,9)%j)*f(4)-36*A(j,10)%j*f(5)+19*(A(j,11)%j+A(j,12)%j)*f(5)
  M2(7)%j = 2*(A(j,19)%j+A(j,20)%j)*f(2)+2*(-A(j,13)%j-A(j,14)%j-A(j,17)%j-A(j,18)%j)*f(3)+4*A(j,8)%j*f(4)+2*(-A(j,7)%j &
       -A(j,9)%j)*f(4)-36*A(j,11)%j*f(5)+19*(A(j,10)%j+A(j,12)%j)*f(5)
  M2(8)%j = 2*(-A(j,20)%j-A(j,21)%j)*f(2)+2*(A(j,14)%j+A(j,15)%j+A(j,16)%j+A(j,17)%j)*f(3)+4*A(j,7)%j*f(4)+2*(-A(j,8)%j &
       -A(j,9)%j)*f(4)-36*A(j,10)%j*f(5)+19*(A(j,11)%j+A(j,12)%j)*f(5)
  M2(9)%j = 2*(-A(j,19)%j+A(j,21)%j)*f(2)+2*(A(j,13)%j-A(j,15)%j-A(j,16)%j+A(j,18)%j)*f(3)+2*(-A(j,7)%j-A(j,8)%j)*f(4) &
       +4*A(j,9)%j*f(4)+19*(A(j,10)%j+A(j,11)%j)*f(5)-36*A(j,12)%j*f(5)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjj_gggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjj_gggg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(6), Mct(9)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 6
    do j = 1, 9
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+6*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppjj_gggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(11)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 12-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppjj_gggg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppjj_gggg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(9)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 9 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+6*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppjj_gggg_1_/**/REALKIND
