
module ol_vamp_1_pphzj_ddxhzg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphzj_ddxhzg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphzj_ddxhzg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphzj_ddxhzg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphzj_ddxhzg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pphzj_ddxhzg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphzj_ddxhzg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(24)
  type(Hpolcont), intent(in) :: M(1,24)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(1),n2h12(1))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(2),n2h12(2))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(3))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(4),n2h12(4))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(5),n2h12(5))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(6),n2h12(6))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(7),n2h12(7))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(8),n2h12(8))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(9),n2h12(9))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(10),n2h12(10))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(11),n2h12(11))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(12),h0tab(:,12),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(12),n2h12(12))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(13),h0tab(:,13),[16,1,2,12],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(13),n2h12(13))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(14),h0tab(:,14),[16,2,1,12],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G0H12(1),16,0,G1H12(14),n2h12(14))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(15),h0tab(:,15),[16,1,12,2],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(15),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_QV_A(ntryL,G1H12(1),wf4(:,5),G1H3(1),m3h4x3(:,1),heltab2x12(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMT,G2H3(1),n2h3(1))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,5),G1H3(1),m3h4x3(:,2),heltab2x12(:,:,2))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMT,G2H3(2),n2h3(2))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,5),G1H3(1),m3h4x3(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMB,G2H3(3),n2h3(3))
  call Hloop_AV_Q(ntryL,G1H12(4),wf4(:,5),G1H3(1),m3h4x3(:,4),heltab2x12(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMB,G2H3(4),n2h3(4))
  call Hloop_AV_Q(ntryL,G1H12(5),wf4(:,5),G1H3(1),m3h4x3(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMT,G2H3(5),n2h3(5))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,5),G1H3(1),m3h4x3(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMT,G2H3(6),n2h3(6))
  call Hloop_AV_Q(ntryL,G1H12(7),wf4(:,5),G1H3(1),m3h4x3(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMB,G2H3(7),n2h3(7))
  call Hloop_QV_A(ntryL,G1H12(8),wf4(:,5),G1H3(1),m3h4x3(:,8),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMB,G2H3(8),n2h3(8))
  call Hloop_QS_A(ntryL,G1H12(9),ex3(:),G1H12(1),ngH,m3h1x12(:,1),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMT,G2H12(1),n2h12(15))
  call Hloop_AS_Q(ntryL,G1H12(10),ex3(:),G1H12(2),ngH,m3h1x12(:,2),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(2),20,nMT,G2H12(2),n2h12(16))
  call Hloop_QS_A(ntryL,G1H12(11),ex3(:),G1H12(3),ngH,m3h1x12(:,3),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H12(3),20,nMB,G2H12(3),n2h12(17))
  call Hloop_AS_Q(ntryL,G1H12(12),ex3(:),G1H12(4),ngH,m3h1x12(:,4),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(4),20,nMB,G2H12(4),n2h12(18))
  call Hloop_AQ_V(ntryL,G1H12(13),ex1(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,13))
  call Hloop_QA_V(ntryL,G1H12(14),ex2(:),G1H6(2),m3h2x6(:,2),heltab2x12(:,:,14))
  call Hloop_VQ_A(ntryL,G1H12(15),ex1(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H6(3),17,0,G2H6(1),n2h6(1))
call Hotf_4pt_reduction(G2H3(1),RedSet_4(1),mass4set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G0H3(1),3)
call HG1shiftOLR(G1H3(2),4,3)
call Hotf_4pt_reduction(G2H3(2),RedSet_4(1),mass4set(:,1),  & 
G1H3(6),G1H3(7),G1H3(8),G1H3(9),G1H3(10),G0H3(2),3)
call HG1shiftOLR(G1H3(7),4,3)
call Hotf_4pt_reduction(G2H3(3),RedSet_4(1),mass4set(:,2),  & 
G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(15),G0H3(3),3)
call HG1shiftOLR(G1H3(12),4,3)
call Hotf_4pt_reduction(G2H3(4),RedSet_4(1),mass4set(:,2),  & 
G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),G0H3(4),3)
call HG1shiftOLR(G1H3(17),4,3)
call Hotf_4pt_reduction(G2H3(5),RedSet_4(2),mass4set(:,1),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),G0H3(5),3)
call HG1shiftOLR(G1H3(22),8,3)
call Hotf_4pt_reduction(G2H3(6),RedSet_4(2),mass4set(:,1),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G0H3(6),3)
call HG1shiftOLR(G1H3(27),8,3)
call Hotf_4pt_reduction(G2H3(7),RedSet_4(2),mass4set(:,2),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G0H3(7),3)
call HG1shiftOLR(G1H3(32),8,3)
call Hotf_4pt_reduction(G2H3(8),RedSet_4(2),mass4set(:,2),  & 
G1H3(36),G1H3(37),G1H3(38),G1H3(39),G1H3(40),G0H3(8),3)
call HG1shiftOLR(G1H3(37),8,3)
call Hotf_4pt_reduction(G2H12(1),RedSet_4(3),mass4set(:,1),  & 
G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(9),G0H12(1),12)
call HG1shiftOLR(G1H12(6),8,12)
call Hotf_4pt_reduction(G2H12(2),RedSet_4(3),mass4set(:,1),  & 
G1H12(1),G1H12(10),G1H12(2),G1H12(11),G1H12(3),G0H12(2),12)
call HG1shiftOLR(G1H12(10),8,12)
call Hotf_4pt_reduction(G2H12(3),RedSet_4(3),mass4set(:,2),  & 
G1H12(12),G1H12(4),G1H12(13),G1H12(14),G1H12(15),G0H12(3),12)
call HG1shiftOLR(G1H12(4),8,12)
call Hotf_4pt_reduction(G2H12(4),RedSet_4(3),mass4set(:,2),  & 
G1H12(16),G1H12(17),G1H12(18),G1H12(19),G1H12(20),G0H12(4),12)
call HG1shiftOLR(G1H12(17),8,12)
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(41),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(41),19,0,G2H3(1),n2h3(9))
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(41),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(41),19,0,G2H3(2),n2h3(10))
call Hotf_4pt_reduction(G2H6(1),RedSet_4(4),mass4set(:,3),  & 
G1H6(3),G1H6(1),G1H6(2),G1H6(4),G1H6(5),6)
call HG1shiftOLR(G1H6(1),2,6)
  call Hloop_QZ_A(ntryL,G1H3(1),ex4(:),G1H1(1),ngZu,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(1),n2h1(1))
call HGT_OLR(G1H3(2),1,1,3)
call HGT_invQ_OLR(G1H3(2),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(2),-4,nMT,G2H3(3),n2h3(11))
  call Hloop_AS_Q(ntryL,G2H3(3),ex3(:),G2H3(4),ngH,m3h1x3(:,1),heltab2x3(:,:,2))
  call Hloop_QZ_A(ntryL,G1H3(4),ex4(:),G1H1(1),ngZu,m3h3x1(:,2),heltab2x3(:,:,3))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(2),n2h1(2))
  call Hloop_QZ_A(ntryL,G1H3(5),ex4(:),G1H1(1),ngZu,m3h3x1(:,3),heltab2x3(:,:,4))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(3),n2h1(3))
  call Hloop_QZ_A(ntryL,G0H3(1),ex4(:),G0H1(1),ngZu,m3h3x1(:,4),heltab2x3(:,:,5))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMT,G1H1(1),n2h1(4))
  call Hloop_AZ_Q(ntryL,G1H3(6),ex4(:),G1H1(2),ngZu,m3h3x1(:,5),heltab2x3(:,:,6))
  call Hloop_A_Q(ntryL,G1H1(2),27,nMT,G2H1(4),n2h1(5))
call HGT_OLR(G1H3(7),1,1,3)
call HGT_invQ_OLR(G1H3(7),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(7),-4,nMT,G2H3(5),n2h3(12))
  call Hloop_QS_A(ntryL,G2H3(5),ex3(:),G2H3(6),ngH,m3h1x3(:,2),heltab2x3(:,:,7))
  call Hloop_AZ_Q(ntryL,G1H3(9),ex4(:),G1H1(2),ngZu,m3h3x1(:,6),heltab2x3(:,:,8))
  call Hloop_A_Q(ntryL,G1H1(2),27,nMT,G2H1(5),n2h1(6))
  call Hloop_AZ_Q(ntryL,G1H3(10),ex4(:),G1H1(2),ngZu,m3h3x1(:,7),heltab2x3(:,:,9))
  call Hloop_A_Q(ntryL,G1H1(2),27,nMT,G2H1(6),n2h1(7))
  call Hloop_AZ_Q(ntryL,G0H3(2),ex4(:),G0H1(1),ngZu,m3h3x1(:,8),heltab2x3(:,:,10))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMT,G1H1(2),n2h1(8))
  call Hloop_QZ_A(ntryL,G1H3(11),ex4(:),G1H1(3),ngZd,m3h3x1(:,9),heltab2x3(:,:,11))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(7),n2h1(9))
call HGT_OLR(G1H3(12),1,1,3)
call HGT_invQ_OLR(G1H3(12),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(12),-4,nMB,G2H3(7),n2h3(13))
  call Hloop_AS_Q(ntryL,G2H3(7),ex3(:),G2H3(8),ngH,m3h1x3(:,3),heltab2x3(:,:,12))
  call Hloop_QZ_A(ntryL,G1H3(14),ex4(:),G1H1(3),ngZd,m3h3x1(:,10),heltab2x3(:,:,13))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(8),n2h1(10))
  call Hloop_QZ_A(ntryL,G1H3(15),ex4(:),G1H1(3),ngZd,m3h3x1(:,11),heltab2x3(:,:,14))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(9),n2h1(11))
  call Hloop_QZ_A(ntryL,G0H3(3),ex4(:),G0H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,15))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(3),n2h1(12))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex4(:),G1H1(4),ngZd,m3h3x1(:,13),heltab2x3(:,:,16))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMB,G2H1(10),n2h1(13))
call HGT_OLR(G1H3(17),1,1,3)
call HGT_invQ_OLR(G1H3(17),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(17),-4,nMB,G2H3(3),n2h3(14))
  call Hloop_QS_A(ntryL,G2H3(3),ex3(:),G2H3(5),ngH,m3h1x3(:,4),heltab2x3(:,:,17))
  call Hloop_AZ_Q(ntryL,G1H3(19),ex4(:),G1H1(4),ngZd,m3h3x1(:,14),heltab2x3(:,:,18))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMB,G2H1(11),n2h1(14))
  call Hloop_AZ_Q(ntryL,G1H3(20),ex4(:),G1H1(4),ngZd,m3h3x1(:,15),heltab2x3(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMB,G2H1(12),n2h1(15))
  call Hloop_AZ_Q(ntryL,G0H3(4),ex4(:),G0H1(1),ngZd,m3h3x1(:,16),heltab2x3(:,:,20))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(4),n2h1(16))
  call Hloop_AS_Q(ntryL,G1H3(21),ex3(:),G1H3(41),ngH,m3h1x3(:,5),heltab2x3(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(41),23,nMT,G2H3(7),n2h3(15))
call HGT_OLR(G1H3(22),1,1,3)
call HGT_invQ_OLR(G1H3(22),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(22),-8,nMT,G2H3(3),n2h3(16))
  call Hloop_QZ_A(ntryL,G2H3(3),ex4(:),G2H1(13),ngZu,m3h3x1(:,17),heltab2x3(:,:,22))
  call Hloop_AS_Q(ntryL,G1H3(24),ex3(:),G1H3(1),ngH,m3h1x3(:,6),heltab2x3(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(3),n2h3(17))
  call Hloop_AS_Q(ntryL,G1H3(25),ex3(:),G1H3(2),ngH,m3h1x3(:,7),heltab2x3(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(2),23,nMT,G2H3(9),n2h3(18))
  call Hloop_AS_Q(ntryL,G0H3(5),ex3(:),G0H3(1),ngH,m3h1x3(:,8),heltab2x3(:,:,25))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMT,G1H3(4),n2h3(19))
  call Hloop_QS_A(ntryL,G1H3(26),ex3(:),G1H3(5),ngH,m3h1x3(:,9),heltab2x3(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(5),23,nMT,G2H3(10),n2h3(20))
call HGT_OLR(G1H3(27),1,1,3)
call HGT_invQ_OLR(G1H3(27),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(27),-8,nMT,G2H3(11),n2h3(21))
  call Hloop_AZ_Q(ntryL,G2H3(11),ex4(:),G2H1(14),ngZu,m3h3x1(:,18),heltab2x3(:,:,27))
  call Hloop_QS_A(ntryL,G1H3(29),ex3(:),G1H3(6),ngH,m3h1x3(:,10),heltab2x3(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(6),23,nMT,G2H3(11),n2h3(22))
  call Hloop_QS_A(ntryL,G1H3(30),ex3(:),G1H3(7),ngH,m3h1x3(:,11),heltab2x3(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(7),23,nMT,G2H3(12),n2h3(23))
  call Hloop_QS_A(ntryL,G0H3(6),ex3(:),G0H3(2),ngH,m3h1x3(:,12),heltab2x3(:,:,30))
  call Hloop_Q_A(ntryL,G0H3(2),23,nMT,G1H3(9),n2h3(24))
  call Hloop_AS_Q(ntryL,G1H3(31),ex3(:),G1H3(10),ngH,m3h1x3(:,13),heltab2x3(:,:,31))
  call Hloop_A_Q(ntryL,G1H3(10),23,nMB,G2H3(13),n2h3(25))
call HGT_OLR(G1H3(32),1,1,3)
call HGT_invQ_OLR(G1H3(32),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(32),-8,nMB,G2H3(14),n2h3(26))
  call Hloop_QZ_A(ntryL,G2H3(14),ex4(:),G2H1(15),ngZd,m3h3x1(:,19),heltab2x3(:,:,32))
  call Hloop_AS_Q(ntryL,G1H3(34),ex3(:),G1H3(11),ngH,m3h1x3(:,14),heltab2x3(:,:,33))
  call Hloop_A_Q(ntryL,G1H3(11),23,nMB,G2H3(14),n2h3(27))
  call Hloop_AS_Q(ntryL,G1H3(35),ex3(:),G1H3(12),ngH,m3h1x3(:,15),heltab2x3(:,:,34))
  call Hloop_A_Q(ntryL,G1H3(12),23,nMB,G2H3(15),n2h3(28))
  call Hloop_AS_Q(ntryL,G0H3(7),ex3(:),G0H3(3),ngH,m3h1x3(:,16),heltab2x3(:,:,35))
  call Hloop_A_Q(ntryL,G0H3(3),23,nMB,G1H3(14),n2h3(29))
  call Hloop_QS_A(ntryL,G1H3(36),ex3(:),G1H3(15),ngH,m3h1x3(:,17),heltab2x3(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(15),23,nMB,G2H3(16),n2h3(30))
call HGT_OLR(G1H3(37),1,1,3)
call HGT_invQ_OLR(G1H3(37),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(37),-8,nMB,G2H3(17),n2h3(31))
  call Hloop_AZ_Q(ntryL,G2H3(17),ex4(:),G2H1(16),ngZd,m3h3x1(:,20),heltab2x3(:,:,37))
  call Hloop_QS_A(ntryL,G1H3(39),ex3(:),G1H3(16),ngH,m3h1x3(:,18),heltab2x3(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(16),23,nMB,G2H3(17),n2h3(32))
  call Hloop_QS_A(ntryL,G1H3(40),ex3(:),G1H3(17),ngH,m3h1x3(:,19),heltab2x3(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(17),23,nMB,G2H3(18),n2h3(33))
  call Hloop_QS_A(ntryL,G0H3(8),ex3(:),G0H3(4),ngH,m3h1x3(:,20),heltab2x3(:,:,40))
  call Hloop_Q_A(ntryL,G0H3(4),23,nMB,G1H3(19),n2h3(34))
  call Hloop_QV_A(ntryL,G1H12(5),wf4(:,5),G1H3(20),m3h4x3(:,9),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H3(20),23,nMT,G2H3(19),n2h3(35))
call HGT_OLR(G1H12(6),1,1,12)
call HGT_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(6),-8,nMT,G2H12(1),n2h12(19))
  call Hloop_AZ_Q(ntryL,G2H12(1),ex4(:),G2H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,17))
  call Hloop_QV_A(ntryL,G1H12(8),wf4(:,5),G1H3(21),m3h4x3(:,10),heltab2x12(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(21),23,nMT,G2H3(20),n2h3(36))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,5),G1H3(41),m3h4x3(:,11),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(41),23,nMT,G2H3(21),n2h3(37))
  call Hloop_QV_A(ntryL,G0H12(1),wf4(:,5),G0H3(5),m3h4x3(:,12),heltab2x12(:,:,20))
  call Hloop_Q_A(ntryL,G0H3(5),23,nMT,G1H3(22),n2h3(38))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,5),G1H3(24),m3h4x3(:,13),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(24),23,nMT,G2H3(22),n2h3(39))
call HGT_OLR(G1H12(10),1,1,12)
call HGT_invQ_OLR(G1H12(10),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(10),-8,nMT,G2H12(2),n2h12(20))
  call Hloop_QZ_A(ntryL,G2H12(2),ex4(:),G2H4(2),ngZu,m3h3x4(:,2),heltab2x12(:,:,22))
  call Hloop_AV_Q(ntryL,G1H12(11),wf4(:,5),G1H3(1),m3h4x3(:,14),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(23),n2h3(40))
  call Hloop_AV_Q(ntryL,G1H12(3),wf4(:,5),G1H3(25),m3h4x3(:,15),heltab2x12(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMT,G2H3(24),n2h3(41))
  call Hloop_AV_Q(ntryL,G0H12(2),wf4(:,5),G0H3(1),m3h4x3(:,16),heltab2x12(:,:,25))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMT,G1H3(2),n2h3(42))
  call Hloop_QV_A(ntryL,G1H12(12),wf4(:,5),G1H3(26),m3h4x3(:,17),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(26),23,nMB,G2H3(25),n2h3(43))
call HGT_OLR(G1H12(4),1,1,12)
call HGT_invQ_OLR(G1H12(4),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(4),-8,nMB,G2H12(3),n2h12(21))
  call Hloop_AZ_Q(ntryL,G2H12(3),ex4(:),G2H4(3),ngZd,m3h3x4(:,3),heltab2x12(:,:,27))
  call Hloop_QV_A(ntryL,G1H12(14),wf4(:,5),G1H3(5),m3h4x3(:,18),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(5),23,nMB,G2H3(26),n2h3(44))
  call Hloop_QV_A(ntryL,G1H12(15),wf4(:,5),G1H3(27),m3h4x3(:,19),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(27),23,nMB,G2H3(27),n2h3(45))
  call Hloop_QV_A(ntryL,G0H12(3),wf4(:,5),G0H3(6),m3h4x3(:,20),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G0H3(6),23,nMB,G1H3(29),n2h3(46))
  call Hloop_AV_Q(ntryL,G1H12(16),wf4(:,5),G1H3(6),m3h4x3(:,21),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H3(6),23,nMB,G2H3(28),n2h3(47))
call HGT_OLR(G1H12(17),1,1,12)
call HGT_invQ_OLR(G1H12(17),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(17),-8,nMB,G2H12(4),n2h12(22))
  call Hloop_QZ_A(ntryL,G2H12(4),ex4(:),G2H4(4),ngZd,m3h3x4(:,4),heltab2x12(:,:,32))
  call Hloop_AV_Q(ntryL,G1H12(19),wf4(:,5),G1H3(30),m3h4x3(:,22),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H3(30),23,nMB,G2H3(29),n2h3(48))
  call Hloop_AV_Q(ntryL,G1H12(20),wf4(:,5),G1H3(7),m3h4x3(:,23),heltab2x12(:,:,34))
  call Hloop_A_Q(ntryL,G1H3(7),23,nMB,G2H3(30),n2h3(49))
  call Hloop_AV_Q(ntryL,G0H12(4),wf4(:,5),G0H3(2),m3h4x3(:,24),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G0H3(2),23,nMB,G1H3(31),n2h3(50))
  call Hloop_QZ_A(ntryL,G1H6(3),wf3(:,2),G1H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(1),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(10),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_QZ_A(ntryL,G1H6(4),wf3(:,2),G1H2(1),ngZd,m3h3x2(:,2),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(2),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H6(5),wf3(:,2),G1H2(1),ngZd,m3h3x2(:,3),heltab2x6(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(3),n2h2(3))
call Hotf_4pt_reduction(G2H3(1),RedSet_4(5),mass4set(:,3),  & 
G1H3(32),G1H3(34),G1H3(11),G1H3(35),G1H3(12),3)
call HG1shiftOLR(G1H3(34),12,3)
call Hotf_4pt_reduction(G2H3(2),RedSet_4(6),mass4set(:,3),  & 
G1H3(36),G1H3(15),G1H3(37),G1H3(39),G1H3(16),3)
call HG1shiftOLR(G1H3(15),12,3)
call Hotf_4pt_reduction(G2H1(1),RedSet_4(1),mass4set(:,1),  & 
G1H1(5),G1H1(6),G1H1(7),G1H1(8),G1H1(9),1)
call HG1shiftOLR(G1H1(6),4,1)
  call Hloop_QS_A(ntryL,G2H1(3),ex3(:),G2H1(1),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(1),n2h1(17))
  call Hloop_QS_A(ntryL,G1H1(1),ex3(:),G1H1(10),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMT,G2tensor(1),n2h1(18))
call Hotf_4pt_reduction(G2H1(4),RedSet_4(1),mass4set(:,1),  & 
G1H1(1),G1H1(10),G1H1(11),G1H1(12),G1H1(13),1)
call HG1shiftOLR(G1H1(10),4,1)
  call Hloop_AS_Q(ntryL,G2H1(6),ex3(:),G2H1(3),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(2),n2h1(19))
  call Hloop_AS_Q(ntryL,G1H1(2),ex3(:),G1H1(14),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,nMT,G2tensor(2),n2h1(20))
call Hotf_4pt_reduction(G2H1(7),RedSet_4(1),mass4set(:,2),  & 
G1H1(2),G1H1(14),G1H1(15),G1H1(16),G1H1(17),1)
call HG1shiftOLR(G1H1(14),4,1)
  call Hloop_QS_A(ntryL,G2H1(9),ex3(:),G2H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(3),n2h1(21))
  call Hloop_QS_A(ntryL,G1H1(3),ex3(:),G1H1(18),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(3),n2h1(22))
call Hotf_4pt_reduction(G2H1(10),RedSet_4(1),mass4set(:,2),  & 
G1H1(3),G1H1(18),G1H1(19),G1H1(20),G1H1(21),1)
call HG1shiftOLR(G1H1(18),4,1)
  call Hloop_AS_Q(ntryL,G2H1(12),ex3(:),G2H1(4),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),31,nMB,G3tensor(4),n2h1(23))
  call Hloop_AS_Q(ntryL,G1H1(4),ex3(:),G1H1(22),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(4),n2h1(24))
call Hotf_4pt_reduction(G2H3(7),RedSet_4(2),mass4set(:,1),  & 
G1H3(40),G1H3(17),G1H3(20),G1H3(21),G1H3(41),3)
call HG1shiftOLR(G1H3(17),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(9),ex4(:),G2H1(6),ngZu,m3h3x1(:,21),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(6),31,nMT,G3tensor(5),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(4),ex4(:),G1H1(4),ngZu,m3h3x1(:,22),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMT,G2tensor(5),n2h1(26))
call Hotf_4pt_reduction(G2H3(10),RedSet_4(2),mass4set(:,1),  & 
G1H3(24),G1H3(1),G1H3(25),G1H3(26),G1H3(5),3)
call HG1shiftOLR(G1H3(1),8,3)
  call Hloop_QZ_A(ntryL,G2H3(12),ex4(:),G2H1(3),ngZu,m3h3x1(:,23),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(6),n2h1(27))
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(22),ngZu,m3h3x1(:,24),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMT,G2tensor(6),n2h1(28))
call Hotf_4pt_reduction(G2H3(13),RedSet_4(2),mass4set(:,2),  & 
G1H3(27),G1H3(6),G1H3(30),G1H3(7),G1H3(4),3)
call HG1shiftOLR(G1H3(6),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(15),ex4(:),G2H1(7),ngZd,m3h3x1(:,25),heltab2x3(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(7),n2h1(29))
  call Hloop_AZ_Q(ntryL,G1H3(14),ex4(:),G1H1(4),ngZd,m3h3x1(:,26),heltab2x3(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(7),n2h1(30))
call Hotf_4pt_reduction(G2H3(16),RedSet_4(2),mass4set(:,2),  & 
G1H3(9),G1H3(14),G1H3(42),G1H3(43),G1H3(44),3)
call HG1shiftOLR(G1H3(14),8,3)
  call Hloop_QZ_A(ntryL,G2H3(18),ex4(:),G2H1(9),ngZd,m3h3x1(:,27),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMB,G3tensor(8),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H3(19),ex4(:),G1H1(22),ngZd,m3h3x1(:,28),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(8),n2h1(32))
call Hotf_4pt_reduction(G2H3(19),RedSet_4(3),mass4set(:,1),  & 
G1H3(19),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
call HG1shiftOLR(G1H3(45),8,3)
  call Hloop_QZ_A(ntryL,G2H3(21),ex4(:),G2H1(1),ngZu,m3h3x1(:,29),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(9),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H3(22),ex4(:),G1H1(4),ngZu,m3h3x1(:,30),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMT,G2tensor(9),n2h1(34))
call Hotf_4pt_reduction(G2H3(22),RedSet_4(3),mass4set(:,1),  & 
G1H3(22),G1H3(49),G1H3(50),G1H3(51),G1H3(52),3)
call HG1shiftOLR(G1H3(49),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(24),ex4(:),G2H1(10),ngZu,m3h3x1(:,31),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(10),n2h1(35))
  call Hloop_AZ_Q(ntryL,G1H3(2),ex4(:),G1H1(22),ngZu,m3h3x1(:,32),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMT,G2tensor(10),n2h1(36))
call Hotf_4pt_reduction(G2H3(25),RedSet_4(3),mass4set(:,2),  & 
G1H3(2),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
call HG1shiftOLR(G1H3(53),8,3)
  call Hloop_QZ_A(ntryL,G2H3(27),ex4(:),G2H1(12),ngZd,m3h3x1(:,33),heltab2x3(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMB,G3tensor(11),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H3(29),ex4(:),G1H1(4),ngZd,m3h3x1(:,34),heltab2x3(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(11),n2h1(38))
call Hotf_4pt_reduction(G2H3(28),RedSet_4(3),mass4set(:,2),  & 
G1H3(29),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
call HG1shiftOLR(G1H3(57),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(30),ex4(:),G2H1(4),ngZd,m3h3x1(:,35),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),31,nMB,G3tensor(12),n2h1(39))
  call Hloop_AZ_Q(ntryL,G1H3(31),ex4(:),G1H1(22),ngZd,m3h3x1(:,36),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(12),n2h1(40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(13),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(14),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_AZ_Q(ntryL,G1H3(32),wf3(:,2),G1H1(4),ngZd,m3h3x1(:,37),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,0,G2tensor(15),n2h1(41))
  call Hloop_AZ_Q(ntryL,G1H3(34),wf3(:,2),G1H1(22),ngZd,m3h3x1(:,38),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),12,0,G2tensor(16),n2h1(42))
  call Hloop_AZ_Q(ntryL,G1H3(12),wf3(:,2),G1H1(4),ngZd,m3h3x1(:,39),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,0,G2tensor(17),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H3(36),wf3(:,2),G1H1(22),ngZd,m3h3x1(:,40),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,0,G2tensor(18),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H3(15),wf3(:,2),G1H1(4),ngZd,m3h3x1(:,41),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),12,0,G2tensor(19),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H3(16),wf3(:,2),G1H1(22),ngZd,m3h3x1(:,42),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,0,G2tensor(20),n2h1(46))
  call Hloop_QS_A(ntryL,G1H1(5),ex3(:),G1H1(4),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMT,G2tensor(21),n2h1(47))
  call Hloop_QS_A(ntryL,G1H1(6),ex3(:),G1H1(22),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),4,nMT,G2tensor(22),n2h1(48))
  call Hloop_QS_A(ntryL,G1H1(9),ex3(:),G1H1(5),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nMT,G2tensor(23),n2h1(49))
  call Hloop_AS_Q(ntryL,G1H1(1),ex3(:),G1H1(4),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMT,G2tensor(24),n2h1(50))
  call Hloop_AS_Q(ntryL,G1H1(10),ex3(:),G1H1(6),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),4,nMT,G2tensor(25),n2h1(51))
  call Hloop_AS_Q(ntryL,G1H1(13),ex3(:),G1H1(22),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMT,G2tensor(26),n2h1(52))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(9),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(27),n2h1(53))
  call Hloop_QS_A(ntryL,G1H1(14),ex3(:),G1H1(5),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),4,nMB,G2tensor(28),n2h1(54))
  call Hloop_QS_A(ntryL,G1H1(17),ex3(:),G1H1(1),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(55))
  call Hloop_AS_Q(ntryL,G1H1(3),ex3(:),G1H1(4),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(30),n2h1(56))
  call Hloop_AS_Q(ntryL,G1H1(18),ex3(:),G1H1(10),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),4,nMB,G2tensor(31),n2h1(57))
  call Hloop_AS_Q(ntryL,G1H1(21),ex3(:),G1H1(6),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(32),n2h1(58))
  call Hloop_AZ_Q(ntryL,G1H3(40),ex4(:),G1H1(13),ngZu,m3h3x1(:,43),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(33),n2h1(59))
  call Hloop_AZ_Q(ntryL,G1H3(17),ex4(:),G1H1(22),ngZu,m3h3x1(:,44),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),8,nMT,G2tensor(34),n2h1(60))
  call Hloop_AZ_Q(ntryL,G1H3(41),ex4(:),G1H1(2),ngZu,m3h3x1(:,45),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,nMT,G2tensor(35),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H3(24),ex4(:),G1H1(9),ngZu,m3h3x1(:,46),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMT,G2tensor(36),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H3(1),ex4(:),G1H1(14),ngZu,m3h3x1(:,47),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),8,nMT,G2tensor(37),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H3(5),ex4(:),G1H1(5),ngZu,m3h3x1(:,48),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nMT,G2tensor(38),n2h1(64))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex4(:),G1H1(17),ngZd,m3h3x1(:,49),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(39),n2h1(65))
  call Hloop_AZ_Q(ntryL,G1H3(6),ex4(:),G1H1(1),ngZd,m3h3x1(:,50),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(40),n2h1(66))
  call Hloop_AZ_Q(ntryL,G1H3(4),ex4(:),G1H1(3),ngZd,m3h3x1(:,51),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),31,nMB,G2tensor(41),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(4),ngZd,m3h3x1(:,52),heltab2x3(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(42),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H3(14),ex4(:),G1H1(18),ngZd,m3h3x1(:,53),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),8,nMB,G2tensor(43),n2h1(69))
  call Hloop_QZ_A(ntryL,G1H3(44),ex4(:),G1H1(10),ngZd,m3h3x1(:,54),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(44),n2h1(70))
  call Hloop_QZ_A(ntryL,G1H3(19),ex4(:),G1H1(21),ngZu,m3h3x1(:,55),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMT,G2tensor(45),n2h1(71))
  call Hloop_QZ_A(ntryL,G1H3(45),ex4(:),G1H1(6),ngZu,m3h3x1(:,56),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),8,nMT,G2tensor(46),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H3(48),ex4(:),G1H1(13),ngZu,m3h3x1(:,57),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(47),n2h1(73))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex4(:),G1H1(22),ngZu,m3h3x1(:,58),heltab2x3(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMT,G2tensor(48),n2h1(74))
  call Hloop_AZ_Q(ntryL,G1H3(49),ex4(:),G1H1(2),ngZu,m3h3x1(:,59),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),8,nMT,G2tensor(49),n2h1(75))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex4(:),G1H1(9),ngZu,m3h3x1(:,60),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMT,G2tensor(50),n2h1(76))
  call Hloop_QZ_A(ntryL,G1H3(2),ex4(:),G1H1(14),ngZd,m3h3x1(:,61),heltab2x3(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(51),n2h1(77))
  call Hloop_QZ_A(ntryL,G1H3(53),ex4(:),G1H1(5),ngZd,m3h3x1(:,62),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),8,nMB,G2tensor(52),n2h1(78))
  call Hloop_QZ_A(ntryL,G1H3(56),ex4(:),G1H1(17),ngZd,m3h3x1(:,63),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(53),n2h1(79))
  call Hloop_AZ_Q(ntryL,G1H3(29),ex4(:),G1H1(1),ngZd,m3h3x1(:,64),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(80))
  call Hloop_AZ_Q(ntryL,G1H3(57),ex4(:),G1H1(3),ngZd,m3h3x1(:,65),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),8,nMB,G2tensor(55),n2h1(81))
  call Hloop_AZ_Q(ntryL,G1H3(60),ex4(:),G1H1(4),ngZd,m3h3x1(:,66),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(56),n2h1(82))
  call ol_merge_tensors(G2tensor(2),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(11)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(27)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(33)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(39)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(45)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(51)])
call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G0tensor(1))
call G_TensorShift(G1tensor(2),4)
call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,2),  & 
G1tensor(1),G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G0tensor(2))
call G_TensorShift(G1tensor(6),4)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(13),G0tensor(3))
call G_TensorShift(G1tensor(10),8)
call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,2),  & 
G1tensor(1),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G0tensor(4))
call G_TensorShift(G1tensor(14),8)
call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(3),mass4set(:,1),  & 
G1tensor(1),G1tensor(18),G1tensor(19),G1tensor(20),G1tensor(21),G0tensor(5))
call G_TensorShift(G1tensor(18),8)
call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(3),mass4set(:,2),  & 
G1tensor(1),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25),G0tensor(6))
call G_TensorShift(G1tensor(22),8)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(4),mass4set(:,3),  & 
G1tensor(1),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29))
call G_TensorShift(G1tensor(26),2)
call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(5),mass4set(:,3),  & 
G1tensor(30),G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34))
call G_TensorShift(G1tensor(31),12)
call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(6),mass4set(:,3),  & 
G1tensor(35),G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39))
call G_TensorShift(G1tensor(36),12)
call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(1),mass4set(:,1),  & 
G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44))
call G_TensorShift(G1tensor(41),4)
call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(1),mass4set(:,2),  & 
G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49))
call G_TensorShift(G1tensor(46),4)
call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(2),mass4set(:,1),  & 
G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(51),8)
call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(2),mass4set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59))
call G_TensorShift(G1tensor(56),8)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(3),mass4set(:,1),  & 
G1tensor(60),G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64))
call G_TensorShift(G1tensor(61),8)
call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(3),mass4set(:,2),  & 
G1tensor(65),G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69))
call G_TensorShift(G1tensor(66),8)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,3),  & 
G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10),G0tensor(11))
call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(5),mass4set(:,3),  & 
G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16))
call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(6),mass4set(:,3),  & 
G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),G0tensor(21))
call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(1),mass4set(:,1),  & 
G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25),G0tensor(26))
call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(1),mass4set(:,2),  & 
G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30),G0tensor(31))
call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(2),mass4set(:,1),  & 
G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35),G0tensor(36))
call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(2),mass4set(:,2),  & 
G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40),G0tensor(41))
call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(3),mass4set(:,1),  & 
G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46))
call Hotf_4pt_reduction_last(G1tensor(65),RedSet_4(3),mass4set(:,2),  & 
G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50),G0tensor(51))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(2)])
call ol_merge_tensors(T0sum(3),[G0tensor(3)])
call ol_merge_tensors(T0sum(4),[G0tensor(4)])
call ol_merge_tensors(T0sum(5),[G0tensor(5)])
call ol_merge_tensors(T0sum(6),[G0tensor(6)])
call ol_merge_tensors(T0sum(7),[G0tensor(7)])
call ol_merge_tensors(T0sum(8),[G0tensor(12)])
call ol_merge_tensors(T0sum(9),[G0tensor(17)])
call ol_merge_tensors(T0sum(10),[G0tensor(22)])
call ol_merge_tensors(T0sum(11),[G0tensor(27)])
call ol_merge_tensors(T0sum(12),[G0tensor(32)])
call ol_merge_tensors(T0sum(13),[G0tensor(37)])
call ol_merge_tensors(T0sum(14),[G0tensor(42)])
call ol_merge_tensors(T0sum(15),[G0tensor(47)])
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(16),h0tab(:,16),[16,3,12],[0,0,0],3,2,wf4(:,5),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(5),n2h12(23))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(17),h0tab(:,17),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,5),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMT,G1H12(6),n2h12(24))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(18),h0tab(:,18),[16,3,12],[0,0,0],3,2,wf4(:,5),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G0H12(3),16,0,G1H12(8),n2h12(25))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(19),h0tab(:,19),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,5),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G0H12(4),16,nMT,G1H12(9),n2h12(26))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(20),h0tab(:,20),[16,3,12],[0,0,0],3,2,wf4(:,5),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(1),n2h12(27))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(21),h0tab(:,21),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,5),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(10),n2h12(28))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(22),h0tab(:,22),[16,3,12],[0,0,0],3,2,wf4(:,5),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_Q_A(ntryL,G0H12(3),16,0,G1H12(11),n2h12(29))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(23),h0tab(:,23),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,5),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G0H12(4),16,nMB,G1H12(3),n2h12(30))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(24),h0tab(:,24),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(12),n2h12(31))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(25),h0tab(:,25),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMT,G1H12(4),n2h12(32))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(26),h0tab(:,26),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMB,G1H12(14),n2h12(33))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(27),h0tab(:,27),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G0H12(4),16,nMB,G1H12(15),n2h12(34))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(28),h0tab(:,28),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(16),n2h12(35))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(29),h0tab(:,29),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMT,G1H12(17),n2h12(36))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(30),h0tab(:,30),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMB,G1H12(19),n2h12(37))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(31),h0tab(:,31),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G0H12(4),16,nMB,G1H12(20),n2h12(38))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(32),h0tab(:,32),[17,2,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,2),G0H6(1),m3h4x6(:,1),heltab2x24(:,:,32))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(33),h0tab(:,33),[18,1,12],[0,0,0],3,2,wf4(:,4),wf3(:,2))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,4),G0H6(2),m3h4x6(:,2),heltab2x24(:,:,33))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(34),h0tab(:,34),[16,2,13],[0,0,0],3,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,32),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G0H12(1),16,0,G1H12(21),n2h12(39))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(35),h0tab(:,35),[16,2,13],[0,0,0],3,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(22),m3h2x12(:,33),heltab2x24(:,:,35))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(36),h0tab(:,36),[16,1,14],[0,0,0],3,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,34),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G0H12(2),16,0,G1H12(23),n2h12(40))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(37),h0tab(:,37),[16,1,14],[0,0,0],3,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(24),m3h2x12(:,35),heltab2x24(:,:,37))
  call Hloop_QZ_A(ntryL,G1H3(3),ex4(:),G1H1(18),ngZu,m3h3x1(:,67),heltab2x3(:,:,87))
  call Hloop_Q_A(ntryL,G1H1(18),27,nMT,G2H1(6),n2h1(83))
  call Hloop_AZ_Q(ntryL,G1H3(8),ex4(:),G1H1(10),ngZu,m3h3x1(:,68),heltab2x3(:,:,88))
  call Hloop_A_Q(ntryL,G1H1(10),27,nMT,G2H1(3),n2h1(84))
  call Hloop_QZ_A(ntryL,G1H3(13),ex4(:),G1H1(21),ngZd,m3h3x1(:,69),heltab2x3(:,:,89))
  call Hloop_Q_A(ntryL,G1H1(21),27,nMB,G2H1(7),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H3(18),ex4(:),G1H1(6),ngZd,m3h3x1(:,70),heltab2x3(:,:,90))
  call Hloop_A_Q(ntryL,G1H1(6),27,nMB,G2H1(9),n2h1(86))
  call Hloop_AS_Q(ntryL,G1H3(23),ex3(:),G1H3(31),ngH,m3h1x3(:,21),heltab2x3(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(31),23,nMT,G2H3(1),n2h3(51))
  call Hloop_QS_A(ntryL,G1H3(28),ex3(:),G1H3(32),ngH,m3h1x3(:,22),heltab2x3(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(32),23,nMT,G2H3(2),n2h3(52))
  call Hloop_AS_Q(ntryL,G1H3(33),ex3(:),G1H3(34),ngH,m3h1x3(:,23),heltab2x3(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(34),23,nMB,G2H3(7),n2h3(53))
  call Hloop_QS_A(ntryL,G1H3(38),ex3(:),G1H3(12),ngH,m3h1x3(:,24),heltab2x3(:,:,94))
  call Hloop_Q_A(ntryL,G1H3(12),23,nMB,G2H3(9),n2h3(54))
  call Hloop_QV_A(ntryL,G1H12(7),wf4(:,5),G1H3(36),m3h4x3(:,25),heltab2x12(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(36),23,nMT,G2H3(10),n2h3(55))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,5),G1H3(15),m3h4x3(:,26),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(15),23,nMT,G2H3(12),n2h3(56))
  call Hloop_QV_A(ntryL,G1H12(13),wf4(:,5),G1H3(16),m3h4x3(:,27),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(16),23,nMB,G2H3(13),n2h3(57))
  call Hloop_AV_Q(ntryL,G1H12(18),wf4(:,5),G1H3(40),m3h4x3(:,28),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(40),23,nMB,G2H3(15),n2h3(58))
  call Hloop_QZ_A(ntryL,G1H6(2),wf3(:,2),G1H2(1),ngZd,m3h3x2(:,4),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(1),n2h2(4))
  call Hloop_AV_Q(ntryL,G1H12(5),wf4(:,5),G1H3(17),m3h4x3(:,29),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(17),19,0,G2H3(16),n2h3(59))
  call Hloop_AV_Q(ntryL,G1H12(6),wf4(:,5),G1H3(41),m3h4x3(:,30),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(41),19,nMT,G2H3(18),n2h3(60))
  call Hloop_QV_A(ntryL,G1H12(8),wf4(:,5),G1H3(24),m3h4x3(:,31),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H3(24),19,0,G2H3(19),n2h3(61))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,5),G1H3(1),m3h4x3(:,32),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMT,G2H3(21),n2h3(62))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,5),G1H3(5),m3h4x3(:,33),heltab2x12(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(5),19,0,G2H3(22),n2h3(63))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,5),G1H3(27),m3h4x3(:,34),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(27),19,nMB,G2H3(24),n2h3(64))
  call Hloop_QV_A(ntryL,G1H12(11),wf4(:,5),G1H3(6),m3h4x3(:,35),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G1H3(6),19,0,G2H3(25),n2h3(65))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,5),G1H3(4),m3h4x3(:,36),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G1H3(4),19,nMB,G2H3(27),n2h3(66))
  call Hloop_QS_A(ntryL,G1H12(12),ex3(:),G1H12(7),ngH,m3h1x12(:,5),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMT,G2H12(1),n2h12(41))
  call Hloop_AS_Q(ntryL,G1H12(4),ex3(:),G1H12(2),ngH,m3h1x12(:,6),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(2),20,nMT,G2H12(2),n2h12(42))
  call Hloop_QS_A(ntryL,G1H12(14),ex3(:),G1H12(13),ngH,m3h1x12(:,7),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H12(13),20,nMB,G2H12(3),n2h12(43))
  call Hloop_AS_Q(ntryL,G1H12(15),ex3(:),G1H12(18),ngH,m3h1x12(:,8),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H12(18),20,nMB,G2H12(4),n2h12(44))
  call Hloop_QS_A(ntryL,G1H12(16),ex3(:),G1H12(5),ngH,m3h1x12(:,9),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H12(5),20,nMT,G2H12(5),n2h12(45))
  call Hloop_AS_Q(ntryL,G1H12(17),ex3(:),G1H12(6),ngH,m3h1x12(:,10),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H12(6),20,nMT,G2H12(6),n2h12(46))
  call Hloop_QS_A(ntryL,G1H12(19),ex3(:),G1H12(8),ngH,m3h1x12(:,11),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H12(8),20,nMB,G2H12(7),n2h12(47))
  call Hloop_AS_Q(ntryL,G1H12(20),ex3(:),G1H12(9),ngH,m3h1x12(:,12),heltab2x12(:,:,55))
  call Hloop_A_Q(ntryL,G1H12(9),20,nMB,G2H12(8),n2h12(48))
  call Hloop_VA_Q(ntryL,G0H6(1),ex2(:),G0H3(7),m3h2x3(:,4),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G0H3(7),19,0,G1H3(9),n2h3(67))
  call Hloop_VQ_A(ntryL,G0H6(2),ex1(:),G0H3(3),m3h2x3(:,5),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G0H3(3),19,0,G1H3(14),n2h3(68))
  call Hloop_QA_V(ntryL,G1H12(21),ex2(:),G1H6(3),m3h2x6(:,4),heltab2x12(:,:,56))
  call Hloop_VA_Q(ntryL,G1H12(22),ex2(:),G1H6(1),m3h2x6(:,5),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H6(1),18,0,G2H6(1),n2h6(3))
  call Hloop_AQ_V(ntryL,G1H12(23),ex1(:),G1H6(4),m3h2x6(:,6),heltab2x12(:,:,58))
  call Hloop_VQ_A(ntryL,G1H12(24),ex1(:),G1H6(5),m3h2x6(:,7),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(5),17,0,G2H6(2),n2h6(4))
  call ol_merge(ntryL,G2H3(10),[G1H3(46)])
call HGT_OLR(G2H3(4),1,1,3)
call HGT_invQ_OLR(G2H3(4),2,5,3)
call HGT_OLR(G2H3(4),6,15,3)
  call ol_merge(ntryL,G2H3(4),[G2H3(10)])
  call ol_merge(ntryL,G2H1(2),[G1H1(8)])
  call ol_merge(ntryL,G2H3(12),[G1H3(50)])
call HGT_OLR(G2H3(6),1,1,3)
call HGT_invQ_OLR(G2H3(6),2,5,3)
call HGT_OLR(G2H3(6),6,15,3)
  call ol_merge(ntryL,G2H3(6),[G2H3(12)])
  call ol_merge(ntryL,G2H1(5),[G1H1(12)])
  call ol_merge(ntryL,G2H3(13),[G1H3(54)])
call HGT_OLR(G2H3(8),1,1,3)
call HGT_invQ_OLR(G2H3(8),2,5,3)
call HGT_OLR(G2H3(8),6,15,3)
  call ol_merge(ntryL,G2H3(8),[G2H3(13)])
  call ol_merge(ntryL,G2H1(8),[G1H1(16)])
  call ol_merge(ntryL,G2H3(15),[G1H3(58)])
call HGT_OLR(G2H3(5),1,1,3)
call HGT_invQ_OLR(G2H3(5),2,5,3)
call HGT_OLR(G2H3(5),6,15,3)
  call ol_merge(ntryL,G2H3(5),[G2H3(15)])
  call ol_merge(ntryL,G2H1(11),[G1H1(20)])
  call ol_merge(ntryL,G2H3(23),[G2H3(3),G1H3(51),G1H3(21)])
  call ol_merge(ntryL,G2H3(20),[G2H3(11),G1H3(47),G1H3(26)])
  call ol_merge(ntryL,G2H3(29),[G2H3(14),G1H3(59),G1H3(7)])
  call ol_merge(ntryL,G2H3(26),[G2H3(17),G1H3(55),G1H3(43)])
  call ol_merge(ntryL,G1H3(14),[G1H3(37)])
call HGT_w2_OLR(G1H3(10),1,1,3)
call HGT_w2_invQ_OLR(G1H3(10),2,5,3)
  call ol_merge(ntryL,G1H3(10),[G1H3(14)])
  call ol_merge(ntryL,G1H3(9),[G1H3(11)])
  call ol_merge(ntryL,G2H3(22),[G1H3(35)])
  call ol_merge(ntryL,G2H3(25),[G1H3(39)])
  call ol_merge(ntryL,G2H1(6),[G1H1(7)])
  call ol_merge(ntryL,G2H1(3),[G1H1(11)])
  call ol_merge(ntryL,G2H1(7),[G1H1(15)])
  call ol_merge(ntryL,G2H1(9),[G1H1(19)])
  call ol_merge(ntryL,G2H3(1),[G1H3(20)])
  call ol_merge(ntryL,G2H3(2),[G1H3(25)])
  call ol_merge(ntryL,G2H3(7),[G1H3(30)])
  call ol_merge(ntryL,G2H3(9),[G1H3(42)])
  call Hloop_QZ_A(ntryL,G2H3(4),ex4(:),G2H1(1),ngZu,m3h3x1(:,71),heltab2x3(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(87))
  call Hloop_QS_A(ntryL,G2H1(2),ex3(:),G2H1(10),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(14),n2h1(88))
  call Hloop_AZ_Q(ntryL,G2H3(6),ex4(:),G2H1(12),ngZu,m3h3x1(:,72),heltab2x3(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(15),n2h1(89))
  call Hloop_AS_Q(ntryL,G2H1(5),ex3(:),G2H1(4),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),31,nMT,G3tensor(16),n2h1(90))
  call Hloop_QZ_A(ntryL,G2H3(8),ex4(:),G2H1(1),ngZd,m3h3x1(:,73),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(17),n2h1(91))
  call Hloop_QS_A(ntryL,G2H1(8),ex3(:),G2H1(2),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(2),31,nMB,G3tensor(18),n2h1(92))
  call Hloop_AZ_Q(ntryL,G2H3(5),ex4(:),G2H1(10),ngZd,m3h3x1(:,74),heltab2x3(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nMB,G3tensor(19),n2h1(93))
  call Hloop_AS_Q(ntryL,G2H1(11),ex3(:),G2H1(12),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),31,nMB,G3tensor(20),n2h1(94))
call HGT_OLR(G2H1(13),1,1,1)
call HGT_invQ_OLR(G2H1(13),2,5,1)
call HGT_OLR(G2H1(13),6,15,1)
  call Hloop_AS_Q(ntryL,G2H1(13),ex3(:),G2H1(5),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),31,nMT,G3tensor(21),n2h1(95))
  call Hloop_AZ_Q(ntryL,G2H3(23),ex4(:),G2H1(4),ngZu,m3h3x1(:,75),heltab2x3(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),31,nMT,G3tensor(22),n2h1(96))
call HGT_OLR(G2H1(14),1,1,1)
call HGT_invQ_OLR(G2H1(14),2,5,1)
call HGT_OLR(G2H1(14),6,15,1)
  call Hloop_QS_A(ntryL,G2H1(14),ex3(:),G2H1(1),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(23),n2h1(97))
  call Hloop_QZ_A(ntryL,G2H3(20),ex4(:),G2H1(8),ngZu,m3h3x1(:,76),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),31,nMT,G3tensor(24),n2h1(98))
call HGT_OLR(G2H1(15),1,1,1)
call HGT_invQ_OLR(G2H1(15),2,5,1)
call HGT_OLR(G2H1(15),6,15,1)
  call Hloop_AS_Q(ntryL,G2H1(15),ex3(:),G2H1(2),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMB,G3tensor(25),n2h1(99))
  call Hloop_AZ_Q(ntryL,G2H3(29),ex4(:),G2H1(10),ngZd,m3h3x1(:,77),heltab2x3(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nMB,G3tensor(26),n2h1(100))
call HGT_OLR(G2H1(16),1,1,1)
call HGT_invQ_OLR(G2H1(16),2,5,1)
call HGT_OLR(G2H1(16),6,15,1)
  call Hloop_QS_A(ntryL,G2H1(16),ex3(:),G2H1(11),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),31,nMB,G3tensor(27),n2h1(101))
  call Hloop_QZ_A(ntryL,G2H3(26),ex4(:),G2H1(12),ngZd,m3h3x1(:,78),heltab2x3(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMB,G3tensor(28),n2h1(102))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,5),G2H1(13),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,nMT,G3tensor(29),n2h1(103))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,5),G2H1(5),m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),31,nMT,G3tensor(30),n2h1(104))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,5),G2H1(4),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),31,nMB,G3tensor(31),n2h1(105))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,5),G2H1(14),m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),31,nMB,G3tensor(32),n2h1(106))
  call Hloop_QZ_A(ntryL,G1H3(10),wf3(:,2),G1H1(13),ngZd,m3h3x1(:,79),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,0,G2tensor(1),n2h1(107))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hloop_AZ_Q(ntryL,G1H3(9),wf3(:,2),G1H1(22),ngZd,m3h3x1(:,80),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,0,G2tensor(5),n2h1(108))
  call Hloop_AZ_Q(ntryL,G2H3(22),wf3(:,2),G2H1(1),ngZd,m3h3x1(:,81),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(33),n2h1(109))
  call Hloop_QZ_A(ntryL,G2H3(25),wf3(:,2),G2H1(8),ngZd,m3h3x1(:,82),heltab2x3(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),31,0,G3tensor(34),n2h1(110))
  call Hloop_QS_A(ntryL,G2H1(6),ex3(:),G2H1(15),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),31,nMT,G3tensor(35),n2h1(111))
  call Hloop_AS_Q(ntryL,G2H1(3),ex3(:),G2H1(2),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMT,G3tensor(36),n2h1(112))
  call Hloop_QS_A(ntryL,G2H1(7),ex3(:),G2H1(10),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMB,G3tensor(37),n2h1(113))
  call Hloop_AS_Q(ntryL,G2H1(9),ex3(:),G2H1(16),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),31,nMB,G3tensor(38),n2h1(114))
  call Hloop_AZ_Q(ntryL,G2H3(1),ex4(:),G2H1(11),ngZu,m3h3x1(:,83),heltab2x3(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),31,nMT,G3tensor(39),n2h1(115))
  call Hloop_QZ_A(ntryL,G2H3(2),ex4(:),G2H1(12),ngZu,m3h3x1(:,84),heltab2x3(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(40),n2h1(116))
  call Hloop_AZ_Q(ntryL,G2H3(7),ex4(:),G2H1(13),ngZd,m3h3x1(:,85),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nMB,G3tensor(41),n2h1(117))
  call Hloop_QZ_A(ntryL,G2H3(9),ex4(:),G2H1(5),ngZd,m3h3x1(:,86),heltab2x3(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(5),31,nMB,G3tensor(42),n2h1(118))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(7),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_AZ_Q(ntryL,G2H3(16),wf3(:,2),G2H1(4),ngZu,m3h3x1(:,87),heltab2x3(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),31,0,G3tensor(43),n2h1(119))
  call Hloop_AZ_Q(ntryL,G2H3(18),wf3(:,2),G2H1(14),ngZu,m3h3x1(:,88),heltab2x3(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),31,nMT,G3tensor(44),n2h1(120))
  call Hloop_QZ_A(ntryL,G2H3(19),wf3(:,2),G2H1(1),ngZu,m3h3x1(:,89),heltab2x3(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(45),n2h1(121))
  call Hloop_QZ_A(ntryL,G2H3(21),wf3(:,2),G2H1(8),ngZu,m3h3x1(:,90),heltab2x3(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),31,nMT,G3tensor(46),n2h1(122))
  call Hloop_AZ_Q(ntryL,G2H3(24),wf3(:,2),G2H1(6),ngZd,m3h3x1(:,91),heltab2x3(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(6),31,nMB,G3tensor(47),n2h1(123))
  call Hloop_QZ_A(ntryL,G2H3(27),wf3(:,2),G2H1(15),ngZd,m3h3x1(:,92),heltab2x3(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),31,nMB,G3tensor(48),n2h1(124))
  call Hloop_QV_A(ntryL,G2H12(1),wf12(:,1),G2H1(3),m3h12x1(:,1),heltab2x12(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(49),n2h1(125))
  call Hloop_AV_Q(ntryL,G2H12(2),wf12(:,1),G2H1(2),m3h12x1(:,2),heltab2x12(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMT,G3tensor(50),n2h1(126))
  call Hloop_QV_A(ntryL,G2H12(3),wf12(:,1),G2H1(7),m3h12x1(:,3),heltab2x12(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(51),n2h1(127))
  call Hloop_AV_Q(ntryL,G2H12(4),wf12(:,1),G2H1(10),m3h12x1(:,4),heltab2x12(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nMB,G3tensor(52),n2h1(128))
  call Hloop_QV_A(ntryL,G2H12(5),wf12(:,2),G2H1(9),m3h12x1(:,5),heltab2x12(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMT,G3tensor(53),n2h1(129))
  call Hloop_AV_Q(ntryL,G2H12(6),wf12(:,2),G2H1(16),m3h12x1(:,6),heltab2x12(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),31,nMT,G3tensor(54),n2h1(130))
  call Hloop_QV_A(ntryL,G2H12(7),wf12(:,2),G2H1(11),m3h12x1(:,7),heltab2x12(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),31,nMB,G3tensor(55),n2h1(131))
  call Hloop_AV_Q(ntryL,G2H12(8),wf12(:,2),G2H1(12),m3h12x1(:,8),heltab2x12(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),31,nMB,G3tensor(56),n2h1(132))
  call Hloop_VQ_A(ntryL,G1H6(3),wf6(:,8),G1H1(2),m3h6x1(:,1),heltab2x6(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,0,G2tensor(9),n2h1(133))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(1),wf6(:,8),G2tensor(11),m3h6x1(:,2),heltab2x6(:,:,11))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,6),G1H1(9),m3h6x1(:,3),heltab2x6(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,0,G2tensor(21),n2h1(134))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(2),wf6(:,6),G2tensor(27),m3h6x1(:,4),heltab2x6(:,:,13))
  call ol_merge_tensors(G3tensor(46),[G3tensor(44),G3tensor(6),G3tensor(5),G3tensor(2),G3tensor(1),G2tensor(38),G2tensor(35) &
    ,G2tensor(26),G2tensor(23),G1tensor(54),G1tensor(44),G0tensor(36),G0tensor(26)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(47),G3tensor(8),G3tensor(7),G3tensor(4),G3tensor(3),G2tensor(44),G2tensor(41) &
    ,G2tensor(32),G2tensor(29),G1tensor(59),G1tensor(49),G0tensor(41),G0tensor(31)])
  call ol_merge_tensors(G3tensor(54),[G3tensor(53),G3tensor(50),G3tensor(49),G3tensor(10),G3tensor(9),G2tensor(50),G2tensor(47) &
    ,G1tensor(64),G0tensor(46)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(55),G3tensor(52),G3tensor(51),G3tensor(12),G3tensor(11),G2tensor(56),G2tensor(53) &
    ,G1tensor(69),G0tensor(51)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(21),G2tensor(17),G2tensor(14),G1tensor(34),G1tensor(29),G0tensor(16) &
    ,G0tensor(11)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(31),G0tensor(13)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(36),G0tensor(18)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(9),G2tensor(20),G1tensor(39),G0tensor(21)])
  call ol_merge_tensors(G3tensor(15),[G3tensor(13),G2tensor(25),G2tensor(22),G1tensor(62),G1tensor(41),G0tensor(44) &
    ,G0tensor(23)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(17),G2tensor(31),G2tensor(28),G1tensor(67),G1tensor(46),G0tensor(49) &
    ,G0tensor(28)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(21),G2tensor(37),G2tensor(34),G1tensor(51),G0tensor(33)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G2tensor(43),G2tensor(40),G1tensor(56),G0tensor(38)])
  call ol_merge_tensors(G3tensor(30),[G3tensor(29),G2tensor(49),G2tensor(46),G1tensor(61),G0tensor(43)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(31),G2tensor(55),G2tensor(52),G1tensor(66),G0tensor(48)])
  call ol_merge_tensors(G1tensor(19),[G1tensor(2)])
  call ol_merge_tensors(G1tensor(13),[G1tensor(5)])
  call ol_merge_tensors(G1tensor(23),[G1tensor(6)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(9)])
  call ol_merge_tensors(G1tensor(20),[G1tensor(12)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(37),G1tensor(26),G0tensor(19),G0tensor(8)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(27),G0tensor(9)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(28),G0tensor(10)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(32),G0tensor(14)])
  call ol_merge_tensors(G3tensor(45),[G3tensor(43),G3tensor(34),G3tensor(33),G1tensor(38),G1tensor(33),G0tensor(20) &
    ,G0tensor(15)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G1tensor(42),G0tensor(24)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(14),G1tensor(43),G0tensor(25)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(37),G1tensor(47),G0tensor(29)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(18),G1tensor(48),G0tensor(30)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(39),G1tensor(52),G0tensor(34)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(22),G1tensor(63),G1tensor(53),G0tensor(45),G0tensor(35)])
  call ol_merge_tensors(G3tensor(42),[G3tensor(41),G1tensor(57),G0tensor(39)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G1tensor(68),G1tensor(58),G0tensor(50),G0tensor(40)])
call TI_triangle_red(G3tensor(46),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1,[nMT], &
    G0tensor(5))
call TI_triangle_red(G3tensor(48),RedBasis(1),mass3set(:,2),G0tensor(6),G0tensor(7),G0tensor(12),G0tensor(17),M2L1R1,[nMB], &
    G0tensor(22))
call TI_triangle_red(G3tensor(54),RedBasis(6),mass3set(:,1),G0tensor(27),G0tensor(32),G0tensor(37),G0tensor(42),M2L1R1,[nMT], &
    G0tensor(47))
call TI_triangle_red(G3tensor(56),RedBasis(6),mass3set(:,2),G0tensor(36),G0tensor(26),G0tensor(41),G0tensor(31),M2L1R1,[nMB], &
    G0tensor(46))
call TI_triangle_red(G2tensor(27),RedBasis(8),mass3set(:,3),G0tensor(51),G0tensor(16),G0tensor(11),G0tensor(13),M2L1R1)
call TI_triangle_red(G2tensor(16),RedBasis(14),mass3set(:,3),G0tensor(18),G0tensor(21),G0tensor(44),G0tensor(23),M2L1R1)
call TI_triangle_red(G2tensor(19),RedBasis(15),mass3set(:,3),G0tensor(49),G0tensor(28),G0tensor(33),G0tensor(38),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(12),mass3set(:,3),G0tensor(43),G0tensor(48),G0tensor(19),G0tensor(8),M2L1R1)
call TI_triangle_red(G3tensor(15),RedBasis(7),mass3set(:,1),G0tensor(9),G0tensor(10),G0tensor(14),G0tensor(20),M2L1R1,[nMT], &
    G0tensor(15))
call TI_triangle_red(G3tensor(19),RedBasis(7),mass3set(:,2),G0tensor(24),G0tensor(25),G0tensor(29),G0tensor(30),M2L1R1,[nMB], &
    G0tensor(34))
call TI_triangle_red(G3tensor(23),RedBasis(16),mass3set(:,1),G0tensor(45),G0tensor(35),G0tensor(39),G0tensor(50),M2L1R1,[nMT], &
    G0tensor(40))
call TI_triangle_red(G3tensor(27),RedBasis(16),mass3set(:,2),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55),M2L1R1,[nMB], &
    G0tensor(56))
call TI_triangle_red(G3tensor(30),RedBasis(17),mass3set(:,1),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1,[nMT], &
    G0tensor(61))
call TI_triangle_red(G3tensor(32),RedBasis(17),mass3set(:,2),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65),M2L1R1,[nMB], &
    G0tensor(66))
call TI_triangle_red(G2tensor(1),RedBasis(13),mass3set(:,3),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(10),mass3set(:,3),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(9),mass3set(:,3),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),M2L1R1)
call TI_triangle_red(G2tensor(5),RedBasis(11),mass3set(:,3),G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82),M2L1R1)
call TI_triangle_red(G3tensor(45),RedBasis(1),mass3set(:,3),G0tensor(83),G0tensor(84),G0tensor(85),G0tensor(86),M2L1R1)
call TI_triangle_red(G3tensor(36),RedBasis(3),mass3set(:,1),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),M2L1R1,[nMT], &
    G0tensor(91))
call TI_triangle_red(G3tensor(16),RedBasis(2),mass3set(:,1),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),M2L1R1,[nMT], &
    G0tensor(96))
call TI_triangle_red(G3tensor(38),RedBasis(3),mass3set(:,2),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1,[nMB], &
    G0tensor(101))
call TI_triangle_red(G3tensor(20),RedBasis(2),mass3set(:,2),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105),M2L1R1,[nMB], &
    G0tensor(106))
call TI_triangle_red(G3tensor(40),RedBasis(5),mass3set(:,1),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110),M2L1R1,[nMT], &
    G0tensor(111))
call TI_triangle_red(G3tensor(24),RedBasis(4),mass3set(:,1),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115),M2L1R1,[nMT], &
    G0tensor(116))
call TI_triangle_red(G3tensor(42),RedBasis(5),mass3set(:,2),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120),M2L1R1,[nMB], &
    G0tensor(121))
call TI_triangle_red(G3tensor(28),RedBasis(4),mass3set(:,2),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125),M2L1R1,[nMB], &
    G0tensor(126))
call ol_merge_tensors(T0sum(16),[G0tensor(1)])
call ol_merge_tensors(T0sum(17),[G0tensor(6)])
call ol_merge_tensors(T0sum(18),[G0tensor(27)])
call ol_merge_tensors(T0sum(19),[G0tensor(36)])
call ol_merge_tensors(T0sum(20),[G0tensor(51)])
call ol_merge_tensors(T0sum(21),[G0tensor(18)])
call ol_merge_tensors(T0sum(22),[G0tensor(49)])
call ol_merge_tensors(T0sum(23),[G0tensor(43)])
call ol_merge_tensors(T0sum(24),[G0tensor(9)])
call ol_merge_tensors(T0sum(25),[G0tensor(24)])
call ol_merge_tensors(T0sum(26),[G0tensor(45)])
call ol_merge_tensors(T0sum(27),[G0tensor(52)])
call ol_merge_tensors(T0sum(28),[G0tensor(57)])
call ol_merge_tensors(T0sum(29),[G0tensor(62)])
call ol_merge_tensors(T1sum(1),[G1tensor(19)])
call ol_merge_tensors(T1sum(2),[G1tensor(3)])
call ol_merge_tensors(T1sum(3),[G1tensor(4)])
call ol_merge_tensors(T1sum(4),[G1tensor(13)])
call ol_merge_tensors(T1sum(5),[G1tensor(23)])
call ol_merge_tensors(T1sum(6),[G1tensor(7)])
call ol_merge_tensors(T1sum(7),[G1tensor(8)])
call ol_merge_tensors(T1sum(8),[G1tensor(17)])
call ol_merge_tensors(T1sum(9),[G1tensor(10)])
call ol_merge_tensors(T1sum(10),[G1tensor(11)])
call ol_merge_tensors(T1sum(11),[G1tensor(20)])
call ol_merge_tensors(T1sum(12),[G1tensor(14)])
call ol_merge_tensors(T1sum(13),[G1tensor(15)])
call ol_merge_tensors(T1sum(14),[G1tensor(24)])
call ol_merge_tensors(T1sum(15),[G1tensor(18)])
call ol_merge_tensors(T1sum(16),[G1tensor(21)])
call ol_merge_tensors(T1sum(17),[G1tensor(22)])
call ol_merge_tensors(T1sum(18),[G1tensor(25)])
call ol_merge_tensors(T0sum(30),[G0tensor(67)])
call ol_merge_tensors(T0sum(31),[G0tensor(71)])
call ol_merge_tensors(T0sum(32),[G0tensor(75)])
call ol_merge_tensors(T0sum(33),[G0tensor(79)])
call ol_merge_tensors(T0sum(34),[G0tensor(83)])
call ol_merge_tensors(T0sum(35),[G0tensor(87)])
call ol_merge_tensors(T0sum(36),[G0tensor(92)])
call ol_merge_tensors(T0sum(37),[G0tensor(97)])
call ol_merge_tensors(T0sum(38),[G0tensor(102)])
call ol_merge_tensors(T0sum(39),[G0tensor(107)])
call ol_merge_tensors(T0sum(40),[G0tensor(112)])
call ol_merge_tensors(T0sum(41),[G0tensor(117)])
call ol_merge_tensors(T0sum(42),[G0tensor(122)])
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(38),h0tab(:,38),[17,14],[0,0],2,2,wf4(:,2),wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,2),G0H6(1),m3h4x6(:,3),heltab2x24(:,:,38))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(39),h0tab(:,39),[18,13],[0,0],2,2,wf4(:,4),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H24(1),wf4(:,4),G0H6(2),m3h4x6(:,4),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G0H6(2),18,0,G1H6(2),n2h6(5))
  call Hloop_VA_Q(ntryL,G0H6(1),wf6(:,6),G0H1(1),m3h6x1(:,5),heltab2x6(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(1),n2h1(135))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(2),wf6(:,8),G1tensor(30),m3h6x1(:,6),heltab2x6(:,:,15))
  call ol_merge_tensors(G0tensor(59),[G0tensor(35),G0tensor(10),G0tensor(2)])
  call ol_merge_tensors(G0tensor(110),[G0tensor(90),G0tensor(3)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(95),G0tensor(42),G0tensor(4)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(111),G0tensor(96),G0tensor(91),G0tensor(61),G0tensor(40),G0tensor(15),G0tensor(47) &
    ,G0tensor(5)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(53),G0tensor(25),G0tensor(7)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(100),G0tensor(12)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(105),G0tensor(31),G0tensor(17)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(121),G0tensor(106),G0tensor(101),G0tensor(66),G0tensor(56),G0tensor(34) &
    ,G0tensor(46),G0tensor(22)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(94),G0tensor(89),G0tensor(58),G0tensor(39),G0tensor(32)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(20),G0tensor(37)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(104),G0tensor(99),G0tensor(63),G0tensor(54),G0tensor(26)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(30),G0tensor(41)])
  call ol_merge_tensors(G0tensor(68),[G0tensor(33),G0tensor(21),G0tensor(16)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(82),G0tensor(74),G0tensor(11)])
  call ol_merge_tensors(G0tensor(86),[G0tensor(78),G0tensor(8),G0tensor(13)])
  call ol_merge_tensors(G0tensor(80),[G0tensor(77),G0tensor(73),G0tensor(48),G0tensor(28),G0tensor(44)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(38),G0tensor(23)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(76),G0tensor(70),G0tensor(19)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(109),G0tensor(88),G0tensor(14)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(119),G0tensor(98),G0tensor(29)])
  call ol_merge_tensors(G0tensor(113),[G0tensor(60),G0tensor(50)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(65),G0tensor(55)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(81),G0tensor(72),G0tensor(69)])
call TI_bubble_red(G1tensor(1),17,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(30),18,mass2set(:,1),G0tensor(6),M2L1R1)
call ol_merge_tensors(T0sum(43),[G0tensor(59)])
call ol_merge_tensors(T0sum(44),[G0tensor(110)])
call ol_merge_tensors(T0sum(45),[G0tensor(115)])
call ol_merge_tensors(T0sum(46),[G0tensor(116)])
call ol_merge_tensors(T0sum(47),[G0tensor(64)])
call ol_merge_tensors(T0sum(48),[G0tensor(120)])
call ol_merge_tensors(T0sum(49),[G0tensor(125)])
call ol_merge_tensors(T0sum(50),[G0tensor(126)])
call ol_merge_tensors(T0sum(51),[G0tensor(108)])
call ol_merge_tensors(T0sum(52),[G0tensor(93)])
call ol_merge_tensors(T0sum(53),[G0tensor(118)])
call ol_merge_tensors(T0sum(54),[G0tensor(103)])
call ol_merge_tensors(T0sum(55),[G0tensor(68)])
call ol_merge_tensors(T0sum(56),[G0tensor(1)])
call ol_merge_tensors(T0sum(57),[G0tensor(86)])
call ol_merge_tensors(T0sum(58),[G0tensor(80)])
call ol_merge_tensors(T0sum(59),[G0tensor(84)])
call ol_merge_tensors(T0sum(60),[G0tensor(6)])
call ol_merge_tensors(T0sum(61),[G0tensor(114)])
call ol_merge_tensors(T0sum(62),[G0tensor(124)])
call ol_merge_tensors(T0sum(63),[G0tensor(113)])
call ol_merge_tensors(T0sum(64),[G0tensor(123)])
call ol_merge_tensors(T0sum(65),[G0tensor(85)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphzj_ddxhzg_1_/**/REALKIND
