
module ol_vamp_1_pphzj_bbxhzg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphzj_bbxhzg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphzj_bbxhzg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphzj_bbxhzg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphzj_bbxhzg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphzj_bbxhzg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphzj_bbxhzg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(24)
  type(Hpolcont), intent(in) :: M(1,24)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(7)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(1),n2h12(1))
Gcoeff(:)%j = (c(7)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(2),n2h12(2))
Gcoeff(:)%j = (c(7)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(3))
Gcoeff(:)%j = (c(7)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(4),n2h12(4))
Gcoeff(:)%j = (c(7)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(5),n2h12(5))
Gcoeff(:)%j = (c(7)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(6),n2h12(6))
Gcoeff(:)%j = (c(6)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[16,1,4,8,2],[0,nMB,nMB,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(7),m3h2x12(:,7),heltab2x24(:,:,7))
Gcoeff(:)%j = (c(6)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[16,1,8,4,2],[0,nMB,nMB,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(8),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_AS_Q(ntryL,G1H12(1),ex3(:),G1H12(9),ngH,m3h1x12(:,1),heltab2x12(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(9),20,nMB,G2H12(1),n2h12(7))
  call Hloop_QA_V(ntryL,G1H12(2),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,2))
  call Hloop_QS_A(ntryL,G1H12(3),ex3(:),G1H12(1),ngH,m3h1x12(:,2),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(2),n2h12(8))
  call Hloop_QA_V(ntryL,G1H12(4),ex2(:),G1H6(2),m3h2x6(:,2),heltab2x12(:,:,4))
  call Hloop_AQ_V(ntryL,G1H12(5),ex1(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G1H12(6),ex1(:),G1H6(4),m3h2x6(:,4),heltab2x12(:,:,6))
  call Hloop_VQ_A(ntryL,G1H12(7),ex1(:),G1H6(5),m3h2x6(:,5),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(5),17,nMB,G2H6(1),n2h6(1))
  call Hloop_VQ_A(ntryL,G1H12(8),ex1(:),G1H6(5),m3h2x6(:,6),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(5),17,nMB,G2H6(2),n2h6(2))
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(3),m3h2x6(:,7),heltab2x12(:,:,9))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMB,G2H3(1),n2h3(1))
  call Hloop_QA_V(ntryL,G2H12(2),ex2(:),G2H6(4),m3h2x6(:,8),heltab2x12(:,:,10))
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMB,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(3),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMB,G2H3(3),n2h3(3))
  call Hloop_VA_Q(ntryL,G1H6(4),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMB,G2H3(4),n2h3(4))
call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(5),G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(6),6)
call HG1shiftOLR(G1H6(1),2,6)
call Hotf_5pt_reduction(G2H6(2),RedSet_5(2),mass5set(:,1),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
call HG1shiftOLR(G1H6(8),2,6)
  call Hloop_QS_A(ntryL,G1H6(5),ex3(:),G1H6(13),ngH,m3h1x6(:,1),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMB,G2H6(1),n2h6(3))
call HGT_raise_alpha_OLR(G1H6(1),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,6))
  call Hloop_QS_A(ntryL,G1H6(3),ex3(:),G1H6(5),ngH,m3h1x6(:,2),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(5),21,nMB,G2H6(2),n2h6(5))
  call Hloop_QS_A(ntryL,G1H6(4),ex3(:),G1H6(13),ngH,m3h1x6(:,3),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMB,G2H6(5),n2h6(6))
  call Hloop_QS_A(ntryL,G1H6(6),ex3(:),G1H6(1),ngH,m3h1x6(:,4),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),21,nMB,G2H6(6),n2h6(7))
  call Hloop_QZ_A(ntryL,G1H6(7),ex4(:),G1H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),25,nMB,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(8),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(8),ex2(:),G1H3(2),m3h2x3(:,6),heltab2x6(:,:,11))
  call Hloop_QZ_A(ntryL,G1H6(10),ex4(:),G1H2(1),ngZd,m3h3x2(:,2),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),25,nMB,G2H2(2),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H6(11),ex4(:),G1H2(1),ngZd,m3h3x2(:,3),heltab2x6(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),25,nMB,G2H2(3),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H6(12),ex4(:),G1H2(1),ngZd,m3h3x2(:,4),heltab2x6(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),25,nMB,G2H2(4),n2h2(4))
call Hotf_5pt_reduction(G2H6(3),RedSet_5(3),mass5set(:,2),  & 
G1H6(3),G1H6(5),G1H6(4),G1H6(13),G1H6(6),G1H6(1),6)
call HG1shiftOLR(G1H6(5),8,6)
call Hotf_5pt_reduction(G2H3(1),RedSet_5(4),mass5set(:,3),  & 
G1H3(3),G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(8),3)
call HG1shiftOLR(G1H3(4),8,3)
call Hotf_5pt_reduction(G2H6(4),RedSet_5(5),mass5set(:,2),  & 
G1H6(7),G1H6(8),G1H6(10),G1H6(11),G1H6(12),G1H6(14),6)
call HG1shiftOLR(G1H6(8),8,6)
call Hotf_5pt_reduction(G2H3(2),RedSet_5(6),mass5set(:,3),  & 
G1H3(9),G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
call HG1shiftOLR(G1H3(10),4,3)
call Hotf_5pt_reduction(G2H3(3),RedSet_5(7),mass5set(:,3),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
call HG1shiftOLR(G1H3(16),8,3)
call Hotf_5pt_reduction(G2H3(4),RedSet_5(8),mass5set(:,3),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),G1H3(26),3)
call HG1shiftOLR(G1H3(22),4,3)
call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(20),6)
call HG1shiftOLR(G1H6(16),2,6)
call Hotf_4pt_reduction(G2H6(5),RedSet_4(1),mass4set(:,1),  & 
G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),6)
call HG1shiftOLR(G1H6(22),2,6)
call Hotf_4pt_reduction(G2H6(6),RedSet_4(2),mass4set(:,1),  & 
G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
call HG1shiftOLR(G1H6(27),10,6)
call Hotf_5pt_reduction(G2H2(1),RedSet_5(2),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
call HG1shiftOLR(G1H2(2),2,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
call HG1shiftOLR(G1H2(8),2,2)
call Hotf_4pt_reduction(G2H2(4),RedSet_4(3),mass4set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
call HG1shiftOLR(G1H2(13),6,2)
  call ol_merge(ntryL,G1H6(21),[G1H6(19)])
  call ol_merge(ntryL,G1H6(26),[G1H6(20)])
  call ol_merge(ntryL,G1H2(7),[G1H2(5)])
  call ol_merge(ntryL,G1H2(12),[G1H2(6)])
  call Hloop_VA_Q(ntryL,G1H6(3),ex2(:),G1H3(27),m3h2x3(:,7),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(1),n2h3(5))
call HGT_OLR(G1H6(5),1,1,6)
call HGT_invQ_OLR(G1H6(5),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(5),-8,nMB,G2H6(3),n2h6(9))
  call Hloop_QZ_A(ntryL,G2H6(3),ex4(:),G2H2(1),ngZd,m3h3x2(:,5),heltab2x6(:,:,16))
  call Hloop_VA_Q(ntryL,G1H6(6),ex2(:),G1H3(27),m3h2x3(:,8),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(2),n2h3(6))
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(27),m3h2x3(:,9),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(3),n2h3(7))
  call Hloop_QS_A(ntryL,G1H3(3),ex3(:),G1H3(27),ngH,m3h1x3(:,1),heltab2x3(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(27),23,nMB,G2H3(4),n2h3(8))
call HGT_OLR(G1H3(4),1,1,3)
call HGT_invQ_OLR(G1H3(4),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(4),-8,nMB,G2H3(5),n2h3(9))
  call Hloop_AZ_Q(ntryL,G2H3(5),ex4(:),G2H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,2))
  call Hloop_QS_A(ntryL,G1H3(7),ex3(:),G1H3(3),ngH,m3h1x3(:,2),heltab2x3(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(3),23,nMB,G2H3(5),n2h3(10))
  call Hloop_QS_A(ntryL,G1H3(8),ex3(:),G1H3(27),ngH,m3h1x3(:,3),heltab2x3(:,:,4))
  call Hloop_Q_A(ntryL,G1H3(27),23,nMB,G2H3(6),n2h3(11))
  call Hloop_VQ_A(ntryL,G1H6(7),ex1(:),G1H3(4),m3h2x3(:,10),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(4),23,nMB,G2H3(7),n2h3(12))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(8),-8,nMB,G2H6(4),n2h6(10))
  call Hloop_AZ_Q(ntryL,G2H6(4),ex4(:),G2H2(3),ngZd,m3h3x2(:,6),heltab2x6(:,:,20))
  call Hloop_VQ_A(ntryL,G1H6(12),ex1(:),G1H3(7),m3h2x3(:,11),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(7),23,nMB,G2H3(8),n2h3(13))
  call Hloop_VQ_A(ntryL,G1H6(14),ex1(:),G1H3(3),m3h2x3(:,12),heltab2x6(:,:,22))
  call Hloop_Q_A(ntryL,G1H3(3),23,nMB,G2H3(9),n2h3(14))
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,5))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(2),n2h1(1))
call HGT_OLR(G1H3(10),1,1,3)
call HGT_invQ_OLR(G1H3(10),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(10),-4,nMB,G2H3(10),n2h3(15))
  call Hloop_AS_Q(ntryL,G2H3(10),ex3(:),G2H3(11),ngH,m3h1x3(:,4),heltab2x3(:,:,6))
  call Hloop_QZ_A(ntryL,G1H3(13),ex4(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,7))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(3),n2h1(2))
  call Hloop_QZ_A(ntryL,G1H3(14),ex4(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,8))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(4),n2h1(3))
  call Hloop_AS_Q(ntryL,G1H3(15),ex3(:),G1H3(8),ngH,m3h1x3(:,5),heltab2x3(:,:,9))
  call Hloop_A_Q(ntryL,G1H3(8),23,nMB,G2H3(10),n2h3(16))
call HGT_OLR(G1H3(16),1,1,3)
call HGT_invQ_OLR(G1H3(16),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(16),-8,nMB,G2H3(12),n2h3(17))
  call Hloop_QZ_A(ntryL,G2H3(12),ex4(:),G2H1(5),ngZd,m3h3x1(:,5),heltab2x3(:,:,10))
  call Hloop_AS_Q(ntryL,G1H3(19),ex3(:),G1H3(27),ngH,m3h1x3(:,6),heltab2x3(:,:,11))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(12),n2h3(18))
  call Hloop_AS_Q(ntryL,G1H3(20),ex3(:),G1H3(4),ngH,m3h1x3(:,7),heltab2x3(:,:,12))
  call Hloop_A_Q(ntryL,G1H3(4),23,nMB,G2H3(13),n2h3(19))
  call Hloop_AZ_Q(ntryL,G1H3(21),ex4(:),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,13))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(6),n2h1(4))
call HGT_OLR(G1H3(22),1,1,3)
call HGT_invQ_OLR(G1H3(22),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(22),-4,nMB,G2H3(14),n2h3(20))
  call Hloop_QS_A(ntryL,G2H3(14),ex3(:),G2H3(15),ngH,m3h1x3(:,8),heltab2x3(:,:,14))
  call Hloop_AZ_Q(ntryL,G1H3(25),ex4(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,15))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(7),n2h1(5))
  call Hloop_AZ_Q(ntryL,G1H3(26),ex4(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,16))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(8),n2h1(6))
  call Hloop_QZ_A(ntryL,G1H6(15),ex4(:),G1H2(5),ngZd,m3h3x2(:,7),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(4),n2h2(5))
call HGT_raise_alpha_OLR(G1H6(16),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(16),ex2(:),G1H3(7),m3h2x3(:,13),heltab2x6(:,:,24))
  call Hloop_QZ_A(ntryL,G1H6(21),ex4(:),G1H2(6),ngZd,m3h3x2(:,8),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(6),29,nMB,G2H2(5),n2h2(6))
  call Hloop_QZ_A(ntryL,G1H6(26),ex4(:),G1H2(5),ngZd,m3h3x2(:,9),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(6),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(22),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(22),ex2(:),G1H3(3),m3h2x3(:,14),heltab2x6(:,:,27))
  call Hloop_QZ_A(ntryL,G1H6(25),ex4(:),G1H2(6),ngZd,m3h3x2(:,10),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(6),29,nMB,G2H2(7),n2h2(8))
call HGT_raise_alpha_OLR(G1H6(27),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(27),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(27),ex2(:),G1H3(9),m3h2x3(:,15),heltab2x6(:,:,29))
  call Hloop_QZ_A(ntryL,G1H6(30),ex4(:),G1H2(5),ngZd,m3h3x2(:,11),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(8),n2h2(9))
  call Hloop_QS_A(ntryL,G1H2(1),ex3(:),G1H2(6),ngH,m3h1x2(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(6),29,nMB,G2H2(9),n2h2(10))
call HGT_raise_alpha_OLR(G1H2(2),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,2))
  call Hloop_QS_A(ntryL,G1H2(7),ex3(:),G1H2(5),ngH,m3h1x2(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(10),n2h2(12))
  call Hloop_QS_A(ntryL,G1H2(12),ex3(:),G1H2(1),ngH,m3h1x2(:,3),heltab2x2(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),29,nMB,G2H2(11),n2h2(13))
call HGT_raise_alpha_OLR(G1H2(8),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(2),m3h2x1(:,2),heltab2x2(:,:,5))
  call Hloop_QS_A(ntryL,G1H2(11),ex3(:),G1H2(6),ngH,m3h1x2(:,4),heltab2x2(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(6),29,nMB,G2H2(12),n2h2(15))
call HGT_raise_alpha_OLR(G1H2(13),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(13),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(13),ex2(:),G1H1(3),m3h2x1(:,3),heltab2x2(:,:,7))
  call Hloop_QS_A(ntryL,G1H2(16),ex3(:),G1H2(2),ngH,m3h1x2(:,5),heltab2x2(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(13),n2h2(17))
call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,2),  & 
G1H3(10),G1H3(13),G1H3(14),G1H3(15),G1H3(8),G1H3(16),3)
call HG1shiftOLR(G1H3(13),8,3)
call Hotf_4pt_reduction(G2H3(3),RedSet_4(4),mass4set(:,2),  & 
G1H3(19),G1H3(27),G1H3(20),G1H3(4),G1H3(21),3)
call HG1shiftOLR(G1H3(27),10,3)
call Hotf_5pt_reduction(G2H3(4),RedSet_5(4),mass5set(:,3),  & 
G1H3(22),G1H3(25),G1H3(26),G1H3(28),G1H3(29),G1H3(30),3)
call HG1shiftOLR(G1H3(25),8,3)
call Hotf_4pt_reduction(G2H3(6),RedSet_4(5),mass4set(:,3),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),3)
call HG1shiftOLR(G1H3(32),12,3)
call Hotf_5pt_reduction(G2H3(7),RedSet_5(5),mass5set(:,2),  & 
G1H3(36),G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),3)
call HG1shiftOLR(G1H3(37),8,3)
call Hotf_4pt_reduction(G2H3(9),RedSet_4(6),mass4set(:,2),  & 
G1H3(42),G1H3(43),G1H3(44),G1H3(45),G1H3(46),3)
call HG1shiftOLR(G1H3(43),9,3)
call Hotf_5pt_reduction(G2H1(2),RedSet_5(6),mass5set(:,3),  & 
G1H1(4),G1H1(5),G1H1(6),G1H1(7),G1H1(8),G1H1(9),1)
call HG1shiftOLR(G1H1(5),4,1)
call Hotf_4pt_reduction(G2H1(4),RedSet_4(5),mass4set(:,3),  & 
G1H1(10),G1H1(11),G1H1(12),G1H1(13),G1H1(14),1)
call HG1shiftOLR(G1H1(11),12,1)
call Hotf_5pt_reduction(G2H3(10),RedSet_5(7),mass5set(:,3),  & 
G1H3(47),G1H3(48),G1H3(49),G1H3(50),G1H3(51),G1H3(52),3)
call HG1shiftOLR(G1H3(48),8,3)
call Hotf_4pt_reduction(G2H3(13),RedSet_4(7),mass4set(:,3),  & 
G1H3(53),G1H3(54),G1H3(55),G1H3(56),G1H3(57),3)
call HG1shiftOLR(G1H3(54),12,3)
call Hotf_5pt_reduction(G2H1(6),RedSet_5(8),mass5set(:,3),  & 
G1H1(15),G1H1(16),G1H1(17),G1H1(18),G1H1(19),G1H1(20),1)
call HG1shiftOLR(G1H1(16),4,1)
call Hotf_4pt_reduction(G2H1(8),RedSet_4(7),mass4set(:,3),  & 
G1H1(21),G1H1(22),G1H1(23),G1H1(24),G1H1(25),1)
call HG1shiftOLR(G1H1(22),12,1)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(1),m3h2x1(:,4),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(2),m3h2x1(:,5),heltab2x2(:,:,10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(3),m3h2x1(:,6),heltab2x2(:,:,11))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(4),m3h2x1(:,7),heltab2x2(:,:,12))
  call ol_merge(ntryL,G1H3(19),[G1H3(16)])
  call ol_merge(ntryL,G1H3(31),[G1H3(30)])
  call ol_merge(ntryL,G1H3(42),[G1H3(41)])
  call ol_merge(ntryL,G1H1(10),[G1H1(9)])
  call ol_merge(ntryL,G1H3(53),[G1H3(52)])
  call ol_merge(ntryL,G1H1(21),[G1H1(20)])
  call Hloop_AZ_Q(ntryL,G1H3(10),ex4(:),G1H1(9),ngZd,m3h3x1(:,9),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(5),n2h1(7))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex4(:),G1H1(20),ngZd,m3h3x1(:,10),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(6),n2h1(8))
  call Hloop_AZ_Q(ntryL,G1H3(19),ex4(:),G1H1(9),ngZd,m3h3x1(:,11),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(7),n2h1(9))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex4(:),G1H1(20),ngZd,m3h3x1(:,12),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),10,nMB,G2tensor(8),n2h1(10))
  call Hloop_QZ_A(ntryL,G1H3(22),ex4(:),G1H1(9),ngZd,m3h3x1(:,13),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(9),n2h1(11))
  call Hloop_QZ_A(ntryL,G1H3(25),ex4(:),G1H1(20),ngZd,m3h3x1(:,14),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(10),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H3(31),ex4(:),G1H1(9),ngZd,m3h3x1(:,15),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(11),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H3(32),ex4(:),G1H1(20),ngZd,m3h3x1(:,16),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),12,nMB,G2tensor(12),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H3(36),ex4(:),G1H1(9),ngZd,m3h3x1(:,17),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(13),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H3(37),ex4(:),G1H1(20),ngZd,m3h3x1(:,18),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(14),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H3(42),ex4(:),G1H1(9),ngZd,m3h3x1(:,19),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(15),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H3(43),ex4(:),G1H1(20),ngZd,m3h3x1(:,20),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),9,nMB,G2tensor(16),n2h1(18))
  call Hloop_QS_A(ntryL,G1H1(4),ex3(:),G1H1(9),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(17),n2h1(19))
  call Hloop_QS_A(ntryL,G1H1(5),ex3(:),G1H1(20),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),4,nMB,G2tensor(18),n2h1(20))
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(4),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(19),n2h1(21))
  call Hloop_QS_A(ntryL,G1H1(11),ex3(:),G1H1(9),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),12,nMB,G2tensor(20),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(47),ex4(:),G1H1(5),ngZd,m3h3x1(:,21),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,nMB,G2tensor(21),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(48),ex4(:),G1H1(20),ngZd,m3h3x1(:,22),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(22),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(53),ex4(:),G1H1(10),ngZd,m3h3x1(:,23),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(23),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(54),ex4(:),G1H1(4),ngZd,m3h3x1(:,24),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),12,nMB,G2tensor(24),n2h1(26))
  call Hloop_AS_Q(ntryL,G1H1(15),ex3(:),G1H1(11),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),31,nMB,G2tensor(25),n2h1(27))
  call Hloop_AS_Q(ntryL,G1H1(16),ex3(:),G1H1(9),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),4,nMB,G2tensor(26),n2h1(28))
  call Hloop_AS_Q(ntryL,G1H1(21),ex3(:),G1H1(5),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,nMB,G2tensor(27),n2h1(29))
  call Hloop_AS_Q(ntryL,G1H1(22),ex3(:),G1H1(20),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),12,nMB,G2tensor(28),n2h1(30))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),2)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),2)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),8)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),8)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),8)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),4)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(9),n2h12(9))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(2),n2h12(10))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(11))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(12),h0tab(:,12),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(1),n2h12(12))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(13),h0tab(:,13),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(4),n2h12(13))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(14),h0tab(:,14),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(5),n2h12(14))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(15),h0tab(:,15),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(6),n2h12(15))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(16),h0tab(:,16),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(7),n2h12(16))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(17),h0tab(:,17),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(8),n2h12(17))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(18),h0tab(:,18),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(10),n2h12(18))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(19),h0tab(:,19),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(11),n2h12(19))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(20),h0tab(:,20),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(12),n2h12(20))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(21),h0tab(:,21),[16,2,8,5],[0,nMB,nMB,0],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(13),m3h2x12(:,21),heltab2x24(:,:,21))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(22),h0tab(:,22),[16,5,2,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(14),n2h12(21))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(23),h0tab(:,23),[16,2,5,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(15),n2h12(22))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(24),h0tab(:,24),[16,1,8,6],[0,nMB,nMB,0],4,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(16),m3h2x12(:,24),heltab2x24(:,:,24))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(25),h0tab(:,25),[16,6,1,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(17),n2h12(23))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(26),h0tab(:,26),[16,1,6,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(18),n2h12(24))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(27),h0tab(:,27),[16,2,4,9],[0,nMB,nMB,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(19),m3h2x12(:,27),heltab2x24(:,:,27))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(28),h0tab(:,28),[16,4,2,9],[nMB,nMB,0,nMB],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(20),n2h12(25))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(29),h0tab(:,29),[16,2,9,4],[nMB,0,nMB,nMB],4,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(21),n2h12(26))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(30),h0tab(:,30),[16,1,4,10],[0,nMB,nMB,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(22),m3h2x12(:,30),heltab2x24(:,:,30))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(31),h0tab(:,31),[16,4,1,10],[nMB,nMB,0,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(23),n2h12(27))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(32),h0tab(:,32),[16,1,10,4],[nMB,0,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(24),n2h12(28))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(33),h0tab(:,33),[16,1,2,12],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(25),n2h12(29))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(34),h0tab(:,34),[16,2,1,12],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(26),n2h12(30))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(35),h0tab(:,35),[16,1,12,2],[0,nMB,nMB,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(27),m3h2x12(:,35),heltab2x24(:,:,35))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(36),h0tab(:,36),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,5),G0H6(1),m3h4x6(:,1),heltab2x24(:,:,36))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(37),h0tab(:,37),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,5),G0H6(2),m3h4x6(:,2),heltab2x24(:,:,37))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(38),h0tab(:,38),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(3),m3h4x6(:,3),heltab2x24(:,:,38))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(39),h0tab(:,39),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(4),m3h4x6(:,4),heltab2x24(:,:,39))
  call Hloop_QS_A(ntryL,G1H6(2),ex3(:),G1H6(19),ngH,m3h1x6(:,5),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H6(19),21,nMB,G2H6(1),n2h6(14))
  call Hloop_QZ_A(ntryL,G1H6(9),ex4(:),G1H2(7),ngZd,m3h3x2(:,12),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(7),25,nMB,G2H2(4),n2h2(18))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,7),G1H3(16),m3h4x3(:,1),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(16),19,nMT,G2H3(14),n2h3(21))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,7),G1H3(30),m3h4x3(:,2),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H3(30),19,nMT,G2H3(1),n2h3(22))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,7),G1H3(41),m3h4x3(:,3),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(41),19,nMB,G2H3(3),n2h3(23))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,7),G1H3(52),m3h4x3(:,4),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(52),19,nMB,G2H3(4),n2h3(24))
  call Hloop_AV_Q(ntryL,G1H12(4),wf4(:,7),G1H3(10),m3h4x3(:,5),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(10),19,nMT,G2H3(6),n2h3(25))
  call Hloop_QV_A(ntryL,G1H12(5),wf4(:,7),G1H3(13),m3h4x3(:,6),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H3(13),19,nMT,G2H3(7),n2h3(26))
  call Hloop_AV_Q(ntryL,G1H12(6),wf4(:,7),G1H3(19),m3h4x3(:,7),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(19),19,nMB,G2H3(9),n2h3(27))
  call Hloop_QV_A(ntryL,G1H12(7),wf4(:,7),G1H3(27),m3h4x3(:,8),heltab2x12(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(27),19,nMB,G2H3(10),n2h3(28))
  call Hloop_QS_A(ntryL,G1H12(8),ex3(:),G1H12(9),ngH,m3h1x12(:,3),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H12(9),20,nMT,G2H12(1),n2h12(31))
  call Hloop_AS_Q(ntryL,G1H12(10),ex3(:),G1H12(2),ngH,m3h1x12(:,4),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H12(2),20,nMT,G2H12(2),n2h12(32))
  call Hloop_QS_A(ntryL,G1H12(11),ex3(:),G1H12(3),ngH,m3h1x12(:,5),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H12(3),20,nMB,G2H12(3),n2h12(33))
  call Hloop_AS_Q(ntryL,G1H12(12),ex3(:),G1H12(1),ngH,m3h1x12(:,6),heltab2x12(:,:,22))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(4),n2h12(34))
  call Hloop_VA_Q(ntryL,G1H12(13),ex2(:),G1H6(20),m3h2x6(:,9),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H6(20),18,nMB,G2H6(5),n2h6(15))
  call Hloop_AQ_V(ntryL,G1H12(14),wf2(:,2),G1H6(3),m3h2x6(:,10),heltab2x12(:,:,24))
  call Hloop_QA_V(ntryL,G1H12(15),ex2(:),G1H6(5),m3h2x6(:,11),heltab2x12(:,:,25))
  call Hloop_VQ_A(ntryL,G1H12(16),ex1(:),G1H6(6),m3h2x6(:,12),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H6(6),17,nMB,G2H6(6),n2h6(16))
  call Hloop_QA_V(ntryL,G1H12(17),wf2(:,4),G1H6(1),m3h2x6(:,13),heltab2x12(:,:,27))
  call Hloop_AQ_V(ntryL,G1H12(18),ex1(:),G1H6(7),m3h2x6(:,14),heltab2x12(:,:,28))
  call Hloop_VA_Q(ntryL,G1H12(19),ex2(:),G1H6(8),m3h2x6(:,15),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H6(8),18,nMB,G2H6(3),n2h6(17))
  call Hloop_QS_A(ntryL,G1H12(20),ex3(:),G1H12(4),ngH,m3h1x12(:,7),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H12(4),20,nMB,G2H12(5),n2h12(35))
  call Hloop_QA_V(ntryL,G1H12(21),ex2(:),G1H6(12),m3h2x6(:,16),heltab2x12(:,:,31))
  call Hloop_VQ_A(ntryL,G1H12(22),ex1(:),G1H6(14),m3h2x6(:,17),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(14),17,nMB,G2H6(4),n2h6(18))
  call Hloop_AS_Q(ntryL,G1H12(23),ex3(:),G1H12(5),ngH,m3h1x12(:,8),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H12(5),20,nMB,G2H12(6),n2h12(36))
  call Hloop_AQ_V(ntryL,G1H12(24),ex1(:),G1H6(15),m3h2x6(:,18),heltab2x12(:,:,34))
  call Hloop_AQ_V(ntryL,G1H12(25),ex1(:),G1H6(16),m3h2x6(:,19),heltab2x12(:,:,35))
  call Hloop_QA_V(ntryL,G1H12(26),ex2(:),G1H6(21),m3h2x6(:,20),heltab2x12(:,:,36))
  call Hloop_VQ_A(ntryL,G1H12(27),ex1(:),G1H6(26),m3h2x6(:,21),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(26),17,nMB,G2H6(7),n2h6(19))
  call Hloop_VA_Q(ntryL,G0H6(1),ex2(:),G0H3(1),m3h2x3(:,16),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G0H3(1),19,nMB,G1H3(22),n2h3(29))
  call Hloop_VA_Q(ntryL,G0H6(2),ex2(:),G0H3(1),m3h2x3(:,17),heltab2x6(:,:,34))
  call Hloop_A_Q(ntryL,G0H3(1),19,nMB,G1H3(25),n2h3(30))
  call Hloop_VQ_A(ntryL,G0H6(3),ex1(:),G0H3(1),m3h2x3(:,18),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G0H3(1),19,nMB,G1H3(31),n2h3(31))
  call Hloop_VQ_A(ntryL,G0H6(4),ex1(:),G0H3(1),m3h2x3(:,19),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G0H3(1),19,nMB,G1H3(32),n2h3(32))
  call ol_merge(ntryL,G1H3(31),[G1H3(5)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,G1H3(1),[G1H3(31)])
  call ol_merge(ntryL,G2H6(2),[G1H6(18)])
  call ol_merge(ntryL,G1H3(32),[G1H3(11)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,G1H3(2),[G1H3(32)])
  call ol_merge(ntryL,G2H2(2),[G1H2(4)])
  call ol_merge(ntryL,G1H6(3),[G1H6(13)])
  call ol_merge(ntryL,G2H3(10),[G1H3(6)])
  call ol_merge(ntryL,G1H6(1),[G1H6(11)])
  call ol_merge(ntryL,G2H3(3),[G1H3(12)])
  call ol_merge(ntryL,G1H3(22),[G1H3(17)])
  call ol_merge(ntryL,G2H3(9),[G1H3(18)])
  call ol_merge(ntryL,G1H3(25),[G1H3(23)])
  call ol_merge(ntryL,G2H3(4),[G1H3(24)])
  call ol_merge(ntryL,G2H6(1),[G1H6(17)])
  call ol_merge(ntryL,G2H2(4),[G1H2(3)])
  call Hloop_QS_A(ntryL,G1H3(1),ex3(:),G1H3(36),ngH,m3h1x3(:,9),heltab2x3(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(36),23,nMB,G2H3(13),n2h3(33))
call Hotf_4pt_reduction(G2H6(2),RedSet_4(9),mass4set(:,1),  & 
G1H6(22),G1H6(25),G1H6(27),G1H6(30),G1H6(2),6)
call HG1shiftOLR(G1H6(25),2,6)
  call Hloop_QZ_A(ntryL,G1H3(2),ex4(:),G1H1(10),ngZd,m3h3x1(:,25),heltab2x3(:,:,34))
  call Hloop_Q_A(ntryL,G1H1(10),27,nMB,G2H1(2),n2h1(31))
call Hotf_4pt_reduction(G2H2(2),RedSet_4(12),mass4set(:,1),  & 
G1H2(5),G1H2(12),G1H2(1),G1H2(8),G1H2(11),2)
call HG1shiftOLR(G1H2(12),2,2)
  call Hloop_VA_Q(ntryL,G1H6(4),ex2(:),G1H3(37),m3h2x3(:,20),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(37),23,nMB,G2H3(16),n2h3(34))
  call Hloop_VA_Q(ntryL,G1H6(3),ex2(:),G1H3(42),m3h2x3(:,21),heltab2x6(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(42),23,nMB,G2H3(17),n2h3(35))
call Hotf_4pt_reduction(G2H3(10),RedSet_4(19),mass4set(:,4),  & 
G1H3(43),G1H3(47),G1H3(48),G1H3(53),G1H3(54),G0H3(1),3)
call HG1shiftOLR(G1H3(47),8,3)
  call Hloop_VQ_A(ntryL,G1H6(10),ex1(:),G1H3(16),m3h2x3(:,22),heltab2x6(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(16),23,nMB,G2H3(10),n2h3(36))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(30),m3h2x3(:,23),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H3(30),23,nMB,G2H3(18),n2h3(37))
call Hotf_4pt_reduction(G2H3(3),RedSet_4(26),mass4set(:,4),  & 
G1H3(41),G1H3(52),G1H3(10),G1H3(13),G1H3(19),G0H3(2),3)
call HG1shiftOLR(G1H3(52),4,3)
  call Hloop_AS_Q(ntryL,G1H3(22),ex3(:),G1H3(27),ngH,m3h1x3(:,10),heltab2x3(:,:,35))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(3),n2h3(38))
call Hotf_4pt_reduction(G2H3(9),RedSet_4(19),mass4set(:,4),  & 
G1H3(5),G1H3(31),G1H3(11),G1H3(32),G1H3(6),G0H3(3),3)
call HG1shiftOLR(G1H3(31),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(25),ex4(:),G1H1(4),ngZd,m3h3x1(:,26),heltab2x3(:,:,36))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMB,G2H1(4),n2h1(32))
call Hotf_4pt_reduction(G2H3(4),RedSet_4(26),mass4set(:,4),  & 
G1H3(12),G1H3(17),G1H3(18),G1H3(23),G1H3(24),G0H3(4),3)
call HG1shiftOLR(G1H3(17),4,3)
call Hotf_4pt_reduction(G2H6(1),RedSet_4(8),mass4set(:,5),  & 
G1H6(19),G1H6(9),G1H6(20),G1H6(6),G1H6(8),6)
call HG1shiftOLR(G1H6(9),2,6)
  call Hloop_QZ_A(ntryL,G1H6(23),ex4(:),G1H2(6),ngZd,m3h3x2(:,13),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(6),29,nMB,G2H2(6),n2h2(19))
  call Hloop_QZ_A(ntryL,G1H6(24),ex4(:),G1H2(13),ngZd,m3h3x2(:,14),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(13),29,nMB,G2H2(9),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H6(28),ex4(:),G1H2(16),ngZd,m3h3x2(:,15),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(11),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H6(29),ex4(:),G1H2(2),ngZd,m3h3x2(:,16),heltab2x6(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(2),n2h2(22))
call Hotf_4pt_reduction(G2H2(4),RedSet_4(11),mass4set(:,5),  & 
G1H2(7),G1H2(4),G1H2(3),G1H2(6),G1H2(13),2)
call HG1shiftOLR(G1H2(4),2,2)
  call Hloop_QS_A(ntryL,G1H2(9),ex3(:),G1H2(16),ngH,m3h1x2(:,6),heltab2x2(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(4),n2h2(23))
  call Hloop_QS_A(ntryL,G1H2(10),ex3(:),G1H2(2),ngH,m3h1x2(:,7),heltab2x2(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(14),n2h2(24))
  call Hloop_QS_A(ntryL,G1H2(14),ex3(:),G1H2(9),ngH,m3h1x2(:,8),heltab2x2(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(9),29,nMB,G2H2(15),n2h2(25))
  call Hloop_QS_A(ntryL,G1H2(15),ex3(:),G1H2(16),ngH,m3h1x2(:,9),heltab2x2(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(16),n2h2(26))
call Hotf_4pt_reduction(G2H3(14),RedSet_4(26),mass4set(:,6),  & 
G1H3(1),G1H3(36),G1H3(2),G1H3(37),G1H3(42),G0H3(5),3)
call HG1shiftOLR(G1H3(36),4,3)
call Hotf_4pt_reduction(G2H3(1),RedSet_4(26),mass4set(:,6),  & 
G1H3(16),G1H3(30),G1H3(22),G1H3(27),G1H3(25),G0H3(6),3)
call HG1shiftOLR(G1H3(30),4,3)
call Hotf_4pt_reduction(G2H3(6),RedSet_4(19),mass4set(:,6),  & 
G1H3(58),G1H3(59),G1H3(60),G1H3(61),G1H3(62),G0H3(7),3)
call HG1shiftOLR(G1H3(59),8,3)
call Hotf_4pt_reduction(G2H3(7),RedSet_4(19),mass4set(:,6),  & 
G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),G0H3(8),3)
call HG1shiftOLR(G1H3(64),8,3)
call Hotf_4pt_reduction(G2H12(1),RedSet_4(16),mass4set(:,6),  & 
G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),G0H12(1),12)
call HG1shiftOLR(G1H12(7),8,12)
call Hotf_4pt_reduction(G2H12(2),RedSet_4(16),mass4set(:,6),  & 
G1H12(2),G1H12(11),G1H12(3),G1H12(12),G1H12(1),G0H12(2),12)
call HG1shiftOLR(G1H12(11),8,12)
call Hotf_4pt_reduction(G2H12(3),RedSet_4(16),mass4set(:,4),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G0H12(3),12)
call HG1shiftOLR(G1H12(14),8,12)
call Hotf_4pt_reduction(G2H12(4),RedSet_4(16),mass4set(:,4),  & 
G1H12(18),G1H12(19),G1H12(20),G1H12(4),G1H12(21),G0H12(4),12)
call HG1shiftOLR(G1H12(19),8,12)
call Hotf_4pt_reduction(G2H6(5),RedSet_4(35),mass4set(:,1),  & 
G1H6(14),G1H6(26),G1H6(18),G1H6(13),G1H6(11),6)
call HG1shiftOLR(G1H6(26),5,6)
  call Hloop_VQ_A(ntryL,G1H6(5),wf2(:,2),G1H3(68),m3h2x3(:,24),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(68),23,nMB,G2H3(9),n2h3(39))
call Hotf_4pt_reduction(G2H6(6),RedSet_4(3),mass4set(:,1),  & 
G1H6(17),G1H6(4),G1H6(3),G1H6(10),G1H6(1),6)
call HG1shiftOLR(G1H6(4),6,6)
  call Hloop_VA_Q(ntryL,G1H6(7),wf2(:,4),G1H3(68),m3h2x3(:,25),heltab2x6(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(68),23,nMB,G2H3(4),n2h3(40))
call Hotf_4pt_reduction(G2H6(3),RedSet_4(36),mass4set(:,1),  & 
G1H6(23),G1H6(24),G1H6(28),G1H6(29),G1H6(5),6)
call HG1shiftOLR(G1H6(24),9,6)
  call Hloop_QA_V(ntryL,G2H12(5),ex2(:),G2H6(2),m3h2x6(:,22),heltab2x12(:,:,38))
  call Hloop_VQ_A(ntryL,G1H6(12),wf6(:,5),G1H1(15),m3h6x1(:,1),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H1(15),27,nMB,G2H1(6),n2h1(33))
call Hotf_4pt_reduction(G2H6(4),RedSet_4(2),mass4set(:,1),  & 
G1H6(7),G1H6(12),G1H6(31),G1H6(32),G1H6(33),6)
call HG1shiftOLR(G1H6(12),10,6)
  call Hloop_AQ_V(ntryL,G2H12(6),ex1(:),G2H6(1),m3h2x6(:,23),heltab2x12(:,:,39))
  call Hloop_VA_Q(ntryL,G1H6(15),wf6(:,2),G1H1(11),m3h6x1(:,2),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H1(11),27,nMB,G2H1(8),n2h1(34))
  call Hloop_VA_Q(ntryL,G1H6(16),ex2(:),G1H3(68),m3h2x3(:,26),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(68),19,nMB,G2H3(14),n2h3(41))
  call Hloop_VQ_A(ntryL,G1H6(21),ex1(:),G1H3(68),m3h2x3(:,27),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H3(68),19,nMB,G2H3(1),n2h3(42))
call Hotf_4pt_reduction(G2H6(7),RedSet_4(1),mass4set(:,1),  & 
G1H6(15),G1H6(16),G1H6(21),G1H6(34),G1H6(35),6)
call HG1shiftOLR(G1H6(16),2,6)
  call Hloop_QZ_A(ntryL,G1H6(22),ex4(:),G1H2(10),ngZd,m3h3x2(:,17),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(10),29,nMB,G2H2(17),n2h2(27))
call HGT_raise_alpha_OLR(G1H6(25),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(25),ex2(:),G1H3(68),m3h2x3(:,28),heltab2x6(:,:,52))
  call Hloop_QZ_A(ntryL,G1H6(30),ex4(:),G1H2(2),ngZd,m3h3x2(:,18),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(18),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H6(2),ex4(:),G1H2(14),ngZd,m3h3x2(:,19),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMB,G2H2(19),n2h2(29))
  call Hloop_QS_A(ntryL,G1H2(5),ex3(:),G1H2(9),ngH,m3h1x2(:,10),heltab2x2(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(9),29,nMB,G2H2(20),n2h2(30))
call HGT_raise_alpha_OLR(G1H2(12),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(12),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(16),m3h2x1(:,8),heltab2x2(:,:,18))
  call Hloop_QS_A(ntryL,G1H2(8),ex3(:),G1H2(15),ngH,m3h1x2(:,11),heltab2x2(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(15),29,nMB,G2H2(21),n2h2(32))
  call Hloop_QS_A(ntryL,G1H2(11),ex3(:),G1H2(16),ngH,m3h1x2(:,12),heltab2x2(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(22),n2h2(33))
  call Hloop_QS_A(ntryL,G1H3(43),ex3(:),G1H3(69),ngH,m3h1x3(:,11),heltab2x3(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(69),23,nMB,G2H3(6),n2h3(43))
call HGT_OLR(G1H3(47),1,1,3)
call HGT_invQ_OLR(G1H3(47),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(47),-8,nMB,G2H3(7),n2h3(44))
  call Hloop_AZ_Q(ntryL,G2H3(7),ex4(:),G2H1(9),ngZd,m3h3x1(:,27),heltab2x3(:,:,38))
  call Hloop_QS_A(ntryL,G1H3(53),ex3(:),G1H3(43),ngH,m3h1x3(:,12),heltab2x3(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(43),23,nMB,G2H3(7),n2h3(45))
  call Hloop_QS_A(ntryL,G1H3(54),ex3(:),G1H3(69),ngH,m3h1x3(:,13),heltab2x3(:,:,40))
  call Hloop_Q_A(ntryL,G1H3(69),23,nMB,G2H3(19),n2h3(46))
  call Hloop_QS_A(ntryL,G0H3(1),ex3(:),G0H3(9),ngH,m3h1x3(:,14),heltab2x3(:,:,41))
  call Hloop_Q_A(ntryL,G0H3(9),23,nMB,G1H3(47),n2h3(47))
  call Hloop_QZ_A(ntryL,G1H3(41),ex4(:),G1H1(9),ngZd,m3h3x1(:,28),heltab2x3(:,:,42))
  call Hloop_Q_A(ntryL,G1H1(9),27,nMB,G2H1(10),n2h1(35))
call HGT_OLR(G1H3(52),1,1,3)
call HGT_invQ_OLR(G1H3(52),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(52),-4,nMB,G2H3(20),n2h3(48))
  call Hloop_AS_Q(ntryL,G2H3(20),ex3(:),G2H3(21),ngH,m3h1x3(:,15),heltab2x3(:,:,43))
  call Hloop_QZ_A(ntryL,G1H3(13),ex4(:),G1H1(21),ngZd,m3h3x1(:,29),heltab2x3(:,:,44))
  call Hloop_Q_A(ntryL,G1H1(21),27,nMB,G2H1(11),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H3(19),ex4(:),G1H1(5),ngZd,m3h3x1(:,30),heltab2x3(:,:,45))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMB,G2H1(12),n2h1(37))
  call Hloop_QZ_A(ntryL,G0H3(2),ex4(:),G0H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,46))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(22),n2h1(38))
  call Hloop_AS_Q(ntryL,G1H3(5),ex3(:),G1H3(53),ngH,m3h1x3(:,16),heltab2x3(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(53),23,nMB,G2H3(20),n2h3(49))
call HGT_OLR(G1H3(31),1,1,3)
call HGT_invQ_OLR(G1H3(31),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(31),-8,nMB,G2H3(22),n2h3(50))
  call Hloop_QZ_A(ntryL,G2H3(22),ex4(:),G2H1(13),ngZd,m3h3x1(:,32),heltab2x3(:,:,48))
  call Hloop_AS_Q(ntryL,G1H3(32),ex3(:),G1H3(43),ngH,m3h1x3(:,17),heltab2x3(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(43),23,nMB,G2H3(22),n2h3(51))
  call Hloop_AS_Q(ntryL,G1H3(6),ex3(:),G1H3(54),ngH,m3h1x3(:,18),heltab2x3(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(54),23,nMB,G2H3(23),n2h3(52))
  call Hloop_AS_Q(ntryL,G0H3(3),ex3(:),G0H3(1),ngH,m3h1x3(:,19),heltab2x3(:,:,51))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(69),n2h3(53))
  call Hloop_AZ_Q(ntryL,G1H3(12),ex4(:),G1H1(20),ngZd,m3h3x1(:,33),heltab2x3(:,:,52))
  call Hloop_A_Q(ntryL,G1H1(20),27,nMB,G2H1(14),n2h1(39))
call HGT_OLR(G1H3(17),1,1,3)
call HGT_invQ_OLR(G1H3(17),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(17),-4,nMB,G2H3(24),n2h3(54))
  call Hloop_QS_A(ntryL,G2H3(24),ex3(:),G2H3(25),ngH,m3h1x3(:,20),heltab2x3(:,:,53))
  call Hloop_AZ_Q(ntryL,G1H3(23),ex4(:),G1H1(10),ngZd,m3h3x1(:,34),heltab2x3(:,:,54))
  call Hloop_A_Q(ntryL,G1H1(10),27,nMB,G2H1(15),n2h1(40))
  call Hloop_AZ_Q(ntryL,G1H3(24),ex4(:),G1H1(4),ngZd,m3h3x1(:,35),heltab2x3(:,:,55))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMB,G2H1(16),n2h1(41))
  call Hloop_AZ_Q(ntryL,G0H3(4),ex4(:),G0H1(1),ngZd,m3h3x1(:,36),heltab2x3(:,:,56))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(15),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H6(19),ex4(:),G1H2(10),ngZd,m3h3x2(:,20),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(10),29,nMB,G2H2(23),n2h2(34))
call HGT_raise_alpha_OLR(G1H6(9),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(9),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(9),ex2(:),G1H3(41),m3h2x3(:,29),heltab2x6(:,:,56))
  call Hloop_QZ_A(ntryL,G1H6(6),ex4(:),G1H2(2),ngZd,m3h3x2(:,21),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(24),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H6(8),ex4(:),G1H2(14),ngZd,m3h3x2(:,22),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMB,G2H2(25),n2h2(36))
  call Hloop_QS_A(ntryL,G1H2(7),ex3(:),G1H2(5),ngH,m3h1x2(:,13),heltab2x2(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(26),n2h2(37))
call HGT_raise_alpha_OLR(G1H2(4),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(11),m3h2x1(:,9),heltab2x2(:,:,22))
  call Hloop_QS_A(ntryL,G1H2(6),ex3(:),G1H2(9),ngH,m3h1x2(:,14),heltab2x2(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(9),29,nMB,G2H2(27),n2h2(39))
  call Hloop_QS_A(ntryL,G1H2(13),ex3(:),G1H2(12),ngH,m3h1x2(:,15),heltab2x2(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(12),29,nMB,G2H2(28),n2h2(40))
  call Hloop_QZ_A(ntryL,G1H3(1),ex4(:),G1H1(9),ngZu,m3h3x1(:,37),heltab2x3(:,:,57))
  call Hloop_Q_A(ntryL,G1H1(9),27,nMT,G2H1(17),n2h1(43))
call HGT_OLR(G1H3(36),1,1,3)
call HGT_invQ_OLR(G1H3(36),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(36),-4,nMT,G2H3(24),n2h3(55))
  call Hloop_AS_Q(ntryL,G2H3(24),ex3(:),G2H3(26),ngH,m3h1x3(:,21),heltab2x3(:,:,58))
  call Hloop_QZ_A(ntryL,G1H3(37),ex4(:),G1H1(21),ngZu,m3h3x1(:,38),heltab2x3(:,:,59))
  call Hloop_Q_A(ntryL,G1H1(21),27,nMT,G2H1(18),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H3(42),ex4(:),G1H1(5),ngZu,m3h3x1(:,39),heltab2x3(:,:,60))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(19),n2h1(45))
  call Hloop_QZ_A(ntryL,G0H3(5),ex4(:),G0H1(1),ngZu,m3h3x1(:,40),heltab2x3(:,:,61))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMT,G1H1(20),n2h1(46))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex4(:),G1H1(10),ngZu,m3h3x1(:,41),heltab2x3(:,:,62))
  call Hloop_A_Q(ntryL,G1H1(10),27,nMT,G2H1(20),n2h1(47))
call HGT_OLR(G1H3(30),1,1,3)
call HGT_invQ_OLR(G1H3(30),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(30),-4,nMT,G2H3(24),n2h3(56))
  call Hloop_QS_A(ntryL,G2H3(24),ex3(:),G2H3(27),ngH,m3h1x3(:,22),heltab2x3(:,:,63))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex4(:),G1H1(4),ngZu,m3h3x1(:,42),heltab2x3(:,:,64))
  call Hloop_A_Q(ntryL,G1H1(4),27,nMT,G2H1(21),n2h1(48))
  call Hloop_AZ_Q(ntryL,G1H3(25),ex4(:),G1H1(9),ngZu,m3h3x1(:,43),heltab2x3(:,:,65))
  call Hloop_A_Q(ntryL,G1H1(9),27,nMT,G2H1(22),n2h1(49))
  call Hloop_AZ_Q(ntryL,G0H3(6),ex4(:),G0H1(1),ngZu,m3h3x1(:,44),heltab2x3(:,:,66))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMT,G1H1(21),n2h1(50))
  call Hloop_AS_Q(ntryL,G1H3(58),ex3(:),G1H3(52),ngH,m3h1x3(:,23),heltab2x3(:,:,67))
  call Hloop_A_Q(ntryL,G1H3(52),23,nMT,G2H3(24),n2h3(57))
call HGT_OLR(G1H3(59),1,1,3)
call HGT_invQ_OLR(G1H3(59),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(59),-8,nMT,G2H3(28),n2h3(58))
  call Hloop_QZ_A(ntryL,G2H3(28),ex4(:),G2H1(23),ngZu,m3h3x1(:,45),heltab2x3(:,:,68))
  call Hloop_AS_Q(ntryL,G1H3(61),ex3(:),G1H3(13),ngH,m3h1x3(:,24),heltab2x3(:,:,69))
  call Hloop_A_Q(ntryL,G1H3(13),23,nMT,G2H3(28),n2h3(59))
  call Hloop_AS_Q(ntryL,G1H3(62),ex3(:),G1H3(19),ngH,m3h1x3(:,25),heltab2x3(:,:,70))
  call Hloop_A_Q(ntryL,G1H3(19),23,nMT,G2H3(29),n2h3(60))
  call Hloop_AS_Q(ntryL,G0H3(7),ex3(:),G0H3(9),ngH,m3h1x3(:,26),heltab2x3(:,:,71))
  call Hloop_A_Q(ntryL,G0H3(9),23,nMT,G1H3(5),n2h3(61))
  call Hloop_QS_A(ntryL,G1H3(63),ex3(:),G1H3(53),ngH,m3h1x3(:,27),heltab2x3(:,:,72))
  call Hloop_Q_A(ntryL,G1H3(53),23,nMT,G2H3(30),n2h3(62))
call HGT_OLR(G1H3(64),1,1,3)
call HGT_invQ_OLR(G1H3(64),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(64),-8,nMT,G2H3(31),n2h3(63))
  call Hloop_AZ_Q(ntryL,G2H3(31),ex4(:),G2H1(24),ngZu,m3h3x1(:,46),heltab2x3(:,:,73))
  call Hloop_QS_A(ntryL,G1H3(66),ex3(:),G1H3(31),ngH,m3h1x3(:,28),heltab2x3(:,:,74))
  call Hloop_Q_A(ntryL,G1H3(31),23,nMT,G2H3(31),n2h3(64))
  call Hloop_QS_A(ntryL,G1H3(67),ex3(:),G1H3(32),ngH,m3h1x3(:,29),heltab2x3(:,:,75))
  call Hloop_Q_A(ntryL,G1H3(32),23,nMT,G2H3(32),n2h3(65))
  call Hloop_QS_A(ntryL,G0H3(8),ex3(:),G0H3(2),ngH,m3h1x3(:,30),heltab2x3(:,:,76))
  call Hloop_Q_A(ntryL,G0H3(2),23,nMT,G1H3(43),n2h3(66))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,7),G1H3(6),m3h4x3(:,9),heltab2x12(:,:,40))
  call Hloop_Q_A(ntryL,G1H3(6),23,nMT,G2H3(33),n2h3(67))
call HGT_OLR(G1H12(7),1,1,12)
call HGT_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(7),-8,nMT,G2H12(1),n2h12(37))
  call Hloop_AZ_Q(ntryL,G2H12(1),ex4(:),G2H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,41))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,7),G1H3(54),m3h4x3(:,10),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H3(54),23,nMT,G2H3(34),n2h3(68))
  call Hloop_QV_A(ntryL,G1H12(10),wf4(:,7),G1H3(12),m3h4x3(:,11),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(12),23,nMT,G2H3(35),n2h3(69))
  call Hloop_QV_A(ntryL,G0H12(1),wf4(:,7),G0H3(3),m3h4x3(:,12),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G0H3(3),23,nMT,G1H3(17),n2h3(70))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,7),G1H3(23),m3h4x3(:,13),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(23),23,nMT,G2H3(36),n2h3(71))
call HGT_OLR(G1H12(11),1,1,12)
call HGT_invQ_OLR(G1H12(11),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(11),-8,nMT,G2H12(2),n2h12(38))
  call Hloop_QZ_A(ntryL,G2H12(2),ex4(:),G2H4(2),ngZu,m3h3x4(:,2),heltab2x12(:,:,46))
  call Hloop_AV_Q(ntryL,G1H12(12),wf4(:,7),G1H3(24),m3h4x3(:,14),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(24),23,nMT,G2H3(37),n2h3(72))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,7),G1H3(1),m3h4x3(:,15),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(38),n2h3(73))
  call Hloop_AV_Q(ntryL,G0H12(2),wf4(:,7),G0H3(1),m3h4x3(:,16),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMT,G1H3(36),n2h3(74))
  call Hloop_QV_A(ntryL,G1H12(13),wf4(:,7),G1H3(37),m3h4x3(:,17),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H3(37),23,nMB,G2H3(39),n2h3(75))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(14),-8,nMB,G2H12(3),n2h12(39))
  call Hloop_AZ_Q(ntryL,G2H12(3),ex4(:),G2H4(3),ngZd,m3h3x4(:,3),heltab2x12(:,:,51))
  call Hloop_QV_A(ntryL,G1H12(16),wf4(:,7),G1H3(42),m3h4x3(:,18),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H3(42),23,nMB,G2H3(40),n2h3(76))
  call Hloop_QV_A(ntryL,G1H12(17),wf4(:,7),G1H3(16),m3h4x3(:,19),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(16),23,nMB,G2H3(41),n2h3(77))
  call Hloop_QV_A(ntryL,G0H12(3),wf4(:,7),G0H3(4),m3h4x3(:,20),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G0H3(4),23,nMB,G1H3(30),n2h3(78))
  call Hloop_AV_Q(ntryL,G1H12(18),wf4(:,7),G1H3(27),m3h4x3(:,21),heltab2x12(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(42),n2h3(79))
call HGT_OLR(G1H12(19),1,1,12)
call HGT_invQ_OLR(G1H12(19),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(19),-8,nMB,G2H12(4),n2h12(40))
  call Hloop_QZ_A(ntryL,G2H12(4),ex4(:),G2H4(4),ngZd,m3h3x4(:,4),heltab2x12(:,:,56))
  call Hloop_AV_Q(ntryL,G1H12(4),wf4(:,7),G1H3(25),m3h4x3(:,22),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMB,G2H3(43),n2h3(80))
  call Hloop_AV_Q(ntryL,G1H12(21),wf4(:,7),G1H3(58),m3h4x3(:,23),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G1H3(58),23,nMB,G2H3(44),n2h3(81))
  call Hloop_AV_Q(ntryL,G0H12(4),wf4(:,7),G0H3(5),m3h4x3(:,24),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G0H3(5),23,nMB,G1H3(52),n2h3(82))
  call Hloop_AZ_Q(ntryL,G1H6(14),ex4(:),G1H2(8),ngZd,m3h3x2(:,23),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(8),26,nMB,G2H2(29),n2h2(41))
call HGT_raise_alpha_OLR(G1H6(26),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(26),wf2(:,2),G1H3(59),m3h2x3(:,30),heltab2x6(:,:,60))
  call Hloop_AZ_Q(ntryL,G1H6(13),ex4(:),G1H2(15),ngZd,m3h3x2(:,24),heltab2x6(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(15),26,nMB,G2H2(30),n2h2(42))
  call Hloop_AZ_Q(ntryL,G1H6(11),ex4(:),G1H2(11),ngZd,m3h3x2(:,25),heltab2x6(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(31),n2h2(43))
  call Hloop_QZ_A(ntryL,G1H6(17),ex4(:),G1H2(16),ngZd,m3h3x2(:,26),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(16),25,nMB,G2H2(32),n2h2(44))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(4),wf2(:,4),G1H3(61),m3h2x3(:,31),heltab2x6(:,:,64))
  call Hloop_QZ_A(ntryL,G1H6(10),ex4(:),G1H2(10),ngZd,m3h3x2(:,27),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(10),25,nMB,G2H2(33),n2h2(45))
  call Hloop_QZ_A(ntryL,G1H6(1),ex4(:),G1H2(2),ngZd,m3h3x2(:,28),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(2),25,nMB,G2H2(34),n2h2(46))
  call Hloop_AS_Q(ntryL,G1H6(23),ex3(:),G1H6(22),ngH,m3h1x6(:,6),heltab2x6(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(22),22,nMB,G2H6(5),n2h6(24))
call HGT_raise_alpha_OLR(G1H6(24),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(24),wf6(:,5),G1H1(5),m3h6x1(:,3),heltab2x6(:,:,68))
  call Hloop_AS_Q(ntryL,G1H6(29),ex3(:),G1H6(25),ngH,m3h1x6(:,7),heltab2x6(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(25),22,nMB,G2H6(6),n2h6(26))
  call Hloop_AS_Q(ntryL,G1H6(5),ex3(:),G1H6(30),ngH,m3h1x6(:,8),heltab2x6(:,:,70))
  call Hloop_A_Q(ntryL,G1H6(30),22,nMB,G2H6(3),n2h6(27))
  call Hloop_QS_A(ntryL,G1H6(7),ex3(:),G1H6(2),ngH,m3h1x6(:,9),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H6(2),21,nMB,G2H6(4),n2h6(28))
call HGT_raise_alpha_OLR(G1H6(12),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(12),wf6(:,2),G1H1(10),m3h6x1(:,4),heltab2x6(:,:,72))
  call Hloop_QS_A(ntryL,G1H6(32),ex3(:),G1H6(19),ngH,m3h1x6(:,10),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H6(19),21,nMB,G2H6(7),n2h6(30))
  call Hloop_QS_A(ntryL,G1H6(33),ex3(:),G1H6(9),ngH,m3h1x6(:,11),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H6(9),21,nMB,G2H6(8),n2h6(31))
  call Hloop_QZ_A(ntryL,G1H6(15),wf3(:,2),G1H2(14),ngZd,m3h3x2(:,29),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMB,G2H2(35),n2h2(47))
call HGT_raise_alpha_OLR(G1H6(16),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(16),ex2(:),G1H3(13),m3h2x3(:,32),heltab2x6(:,:,76))
  call Hloop_QZ_A(ntryL,G1H6(34),wf3(:,2),G1H2(7),ngZd,m3h3x2(:,30),heltab2x6(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(7),29,nMB,G2H2(36),n2h2(48))
  call Hloop_QZ_A(ntryL,G1H6(35),wf3(:,2),G1H2(5),ngZd,m3h3x2(:,31),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMB,G2H2(37),n2h2(49))
  call ol_merge(ntryL,G2H3(42),[G2H3(2),G1H3(8)])
  call ol_merge(ntryL,G2H3(9),[G2H3(5),G1H3(29)])
  call ol_merge(ntryL,G2H3(39),[G2H3(8),G1H3(40)])
  call ol_merge(ntryL,G2H3(10),[G1H3(38)])
call HGT_OLR(G2H3(11),1,1,3)
call HGT_invQ_OLR(G2H3(11),2,5,3)
call HGT_OLR(G2H3(11),6,15,3)
  call ol_merge(ntryL,G2H3(11),[G2H3(10)])
  call ol_merge(ntryL,G2H1(6),[G2H1(3),G1H1(8)])
  call ol_merge(ntryL,G2H3(4),[G2H3(12),G1H3(51)])
  call ol_merge(ntryL,G2H3(16),[G1H3(14)])
call HGT_OLR(G2H3(15),1,1,3)
call HGT_invQ_OLR(G2H3(15),2,5,3)
call HGT_OLR(G2H3(15),6,15,3)
  call ol_merge(ntryL,G2H3(15),[G2H3(16)])
  call ol_merge(ntryL,G2H1(8),[G2H1(7),G1H1(19)])
  call ol_merge(ntryL,G2H3(13),[G1H3(26)])
call HGT_w2_OLR(G1H3(7),1,1,3)
call HGT_w2_invQ_OLR(G1H3(7),2,5,3)
  call ol_merge(ntryL,G2H3(13),[G1H3(7)])
  call ol_merge(ntryL,G2H2(35),[G2H2(10),G2H2(5)])
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call ol_merge(ntryL,G1H3(3),[G1H3(33)])
  call ol_merge(ntryL,G2H2(37),[G2H2(13),G2H2(12),G2H2(8),G2H2(7)])
  call ol_merge(ntryL,G2H1(2),[G1H1(6)])
call HGT_w2_OLR(G1H1(1),1,1,1)
call HGT_w2_invQ_OLR(G1H1(1),2,5,1)
  call ol_merge(ntryL,G2H1(2),[G1H1(1)])
call HGT_w2_OLR(G1H1(2),1,1,1)
call HGT_w2_invQ_OLR(G1H1(2),2,5,1)
  call ol_merge(ntryL,G1H1(2),[G1H1(12)])
  call ol_merge(ntryL,G2H3(17),[G1H3(15)])
  call ol_merge(ntryL,G2H3(44),[G1H3(21)])
  call ol_merge(ntryL,G2H3(6),[G1H3(28)])
  call ol_merge(ntryL,G2H3(19),[G1H3(34)])
  call ol_merge(ntryL,G2H3(18),[G1H3(39)])
  call ol_merge(ntryL,G2H3(41),[G1H3(46)])
  call ol_merge(ntryL,G2H1(10),[G1H1(7)])
  call ol_merge(ntryL,G2H1(12),[G1H1(13)])
  call ol_merge(ntryL,G2H3(3),[G1H3(49)])
  call ol_merge(ntryL,G2H3(20),[G1H3(50)])
  call ol_merge(ntryL,G2H3(23),[G1H3(56)])
  call ol_merge(ntryL,G2H1(4),[G1H1(17)])
  call ol_merge(ntryL,G2H1(14),[G1H1(18)])
  call ol_merge(ntryL,G2H1(16),[G1H1(24)])
  call ol_merge(ntryL,G2H2(25),[G2H2(11)])
  call ol_merge(ntryL,G2H2(19),[G2H2(2)])
  call ol_merge(ntryL,G2H2(28),[G2H2(15)])
  call ol_merge(ntryL,G2H2(22),[G2H2(16)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
call Hotf_4pt_reduction(G2H2(1),RedSet_4(37),mass4set(:,2),  & 
G1H2(4),G1H2(6),G1H2(9),G1H2(13),G1H2(12),2)
call HG1shiftOLR(G1H2(6),2,2)
call Hotf_4pt_reduction(G2H3(42),RedSet_4(16),mass4set(:,4),  & 
G1H3(62),G1H3(19),G1H3(63),G1H3(53),G1H3(64),3)
call HG1shiftOLR(G1H3(19),8,3)
call HGT_OLR(G2H1(1),1,1,1)
call HGT_invQ_OLR(G2H1(1),2,5,1)
call HGT_OLR(G2H1(1),6,15,1)
call Hotf_4pt_reduction(G2H1(1),RedSet_4(38),mass4set(:,3),  & 
G1H1(4),G1H1(9),G1H1(8),G1H1(19),G1H1(6),1)
call HG1shiftOLR(G1H1(9),4,1)
call Hotf_4pt_reduction(G2H3(9),RedSet_4(20),mass4set(:,3),  & 
G1H3(66),G1H3(31),G1H3(67),G1H3(32),G1H3(6),3)
call HG1shiftOLR(G1H3(31),8,3)
call HGT_OLR(G2H2(3),1,1,2)
call HGT_invQ_OLR(G2H2(3),2,5,2)
call HGT_OLR(G2H2(3),6,15,2)
call Hotf_4pt_reduction(G2H2(3),RedSet_4(39),mass4set(:,2),  & 
G1H2(8),G1H2(15),G1H2(11),G1H2(16),G1H2(10),2)
call HG1shiftOLR(G1H2(15),1,2)
call Hotf_4pt_reduction(G2H3(39),RedSet_4(16),mass4set(:,4),  & 
G1H3(54),G1H3(12),G1H3(23),G1H3(24),G1H3(1),3)
call HG1shiftOLR(G1H3(12),8,3)
call Hotf_4pt_reduction(G2H3(11),RedSet_4(22),mass4set(:,3),  & 
G1H3(37),G1H3(42),G1H3(16),G1H3(27),G1H3(25),3)
call HG1shiftOLR(G1H3(42),8,3)
call Hotf_4pt_reduction(G2H1(6),RedSet_4(27),mass4set(:,3),  & 
G1H1(1),G1H1(12),G1H1(7),G1H1(13),G1H1(17),1)
call HG1shiftOLR(G1H1(12),4,1)
call HGT_OLR(G2H1(5),1,1,1)
call HGT_invQ_OLR(G2H1(5),2,5,1)
call HGT_OLR(G2H1(5),6,15,1)
call Hotf_4pt_reduction(G2H1(5),RedSet_4(40),mass4set(:,3),  & 
G1H1(18),G1H1(24),G1H1(26),G1H1(27),G1H1(28),1)
call HG1shiftOLR(G1H1(24),4,1)
call Hotf_4pt_reduction(G2H3(4),RedSet_4(30),mass4set(:,3),  & 
G1H3(58),G1H3(8),G1H3(29),G1H3(40),G1H3(38),3)
call HG1shiftOLR(G1H3(8),8,3)
call Hotf_4pt_reduction(G2H3(15),RedSet_4(14),mass4set(:,3),  & 
G1H3(51),G1H3(14),G1H3(26),G1H3(7),G1H3(33),3)
call HG1shiftOLR(G1H3(14),8,3)
call Hotf_4pt_reduction(G2H1(8),RedSet_4(33),mass4set(:,3),  & 
G1H1(29),G1H1(30),G1H1(31),G1H1(32),G1H1(33),1)
call HG1shiftOLR(G1H1(30),4,1)
call Hotf_4pt_reduction(G2H3(13),RedSet_4(18),mass4set(:,7),  & 
G1H3(15),G1H3(21),G1H3(28),G1H3(34),G1H3(39),3)
call HG1shiftOLR(G1H3(21),8,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex2(:),G2tensor(1),m3h2x1(:,10),heltab2x2(:,:,25))
  call Hloop_QZ_A(ntryL,G1H3(3),ex4(:),G1H1(34),ngZd,m3h3x1(:,47),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(3),n2h1(51))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex2(:),G2tensor(5),m3h2x1(:,11),heltab2x2(:,:,26))
call HGT_w2_OLR(G1H3(9),1,1,3)
call HGT_w2_invQ_OLR(G1H3(9),2,5,3)
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(34),ngZd,m3h3x1(:,48),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),8,nMB,G2tensor(9),n2h1(52))
call Hotf_4pt_reduction(G2H1(2),RedSet_4(25),mass4set(:,7),  & 
G1H1(34),G1H1(35),G1H1(36),G1H1(37),G1H1(38),1)
call HG1shiftOLR(G1H1(35),4,1)
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(39),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,nMB,G2tensor(13),n2h1(53))
call HGT_w2_OLR(G1H1(3),1,1,1)
call HGT_w2_invQ_OLR(G1H1(3),2,5,1)
  call Hloop_QS_A(ntryL,G1H1(3),ex3(:),G1H1(2),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),4,nMB,G2tensor(17),n2h1(54))
call Hotf_4pt_reduction(G2H3(17),RedSet_4(15),mass4set(:,3),  & 
G1H3(46),G1H3(49),G1H3(50),G1H3(56),G1H3(3),3)
call HG1shiftOLR(G1H3(49),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(20),ex4(:),G1H1(39),ngZd,m3h3x1(:,49),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),31,nMB,G2tensor(21),n2h1(55))
  call Hloop_AZ_Q(ntryL,G1H3(4),ex4(:),G1H1(3),ngZd,m3h3x1(:,50),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),31,nMB,G2tensor(25),n2h1(56))
  call Hloop_AZ_Q(ntryL,G2H3(44),ex4(:),G2H1(3),ngZd,m3h3x1(:,51),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),31,nMB,G3tensor(1),n2h1(57))
call Hotf_4pt_reduction(G2H3(6),RedSet_4(19),mass4set(:,4),  & 
G1H3(9),G1H3(20),G1H3(4),G1H3(70),G1H3(71),3)
call HG1shiftOLR(G1H3(20),8,3)
  call Hloop_QZ_A(ntryL,G2H3(19),ex4(:),G2H1(7),ngZd,m3h3x1(:,52),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(2),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H3(35),ex4(:),G1H1(2),ngZd,m3h3x1(:,53),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(29),n2h1(59))
call Hotf_4pt_reduction(G2H3(18),RedSet_4(23),mass4set(:,3),  & 
G1H3(35),G1H3(72),G1H3(73),G1H3(74),G1H3(75),3)
call HG1shiftOLR(G1H3(72),8,3)
  call Hloop_QZ_A(ntryL,G1H3(44),ex4(:),G1H1(39),ngZd,m3h3x1(:,54),heltab2x3(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,nMB,G2tensor(30),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(45),ex4(:),G1H1(3),ngZd,m3h3x1(:,55),heltab2x3(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,nMB,G2tensor(31),n2h1(61))
  call Hloop_QZ_A(ntryL,G2H3(41),ex4(:),G2H1(1),ngZd,m3h3x1(:,56),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(3),n2h1(62))
call Hotf_4pt_reduction(G2H1(10),RedSet_4(26),mass4set(:,4),  & 
G1H1(2),G1H1(39),G1H1(3),G1H1(40),G1H1(41),1)
call HG1shiftOLR(G1H1(39),4,1)
  call Hloop_QS_A(ntryL,G2H1(12),ex3(:),G2H1(6),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(6),31,nMB,G3tensor(4),n2h1(63))
  call Hloop_QS_A(ntryL,G1H1(14),ex3(:),G1H1(42),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(32),n2h1(64))
call Hotf_4pt_reduction(G2H3(3),RedSet_4(29),mass4set(:,7),  & 
G1H3(44),G1H3(45),G1H3(76),G1H3(77),G1H3(78),3)
call HG1shiftOLR(G1H3(45),8,3)
call Hotf_4pt_reduction(G2H3(20),RedSet_4(19),mass4set(:,4),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
call HG1shiftOLR(G1H3(80),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(55),ex4(:),G1H1(14),ngZd,m3h3x1(:,57),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(33),n2h1(65))
  call Hloop_AZ_Q(ntryL,G2H3(23),ex4(:),G2H1(5),ngZd,m3h3x1(:,58),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),31,nMB,G3tensor(5),n2h1(66))
  call Hloop_AZ_Q(ntryL,G1H3(57),ex4(:),G1H1(42),ngZd,m3h3x1(:,59),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(34),n2h1(67))
call Hotf_4pt_reduction(G2H1(4),RedSet_4(32),mass4set(:,7),  & 
G1H1(14),G1H1(42),G1H1(43),G1H1(44),G1H1(45),1)
call HG1shiftOLR(G1H1(42),4,1)
call Hotf_4pt_reduction(G2H1(14),RedSet_4(26),mass4set(:,4),  & 
G1H1(46),G1H1(47),G1H1(48),G1H1(49),G1H1(50),1)
call HG1shiftOLR(G1H1(47),4,1)
  call Hloop_AS_Q(ntryL,G1H1(23),ex3(:),G1H1(51),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(51),31,nMB,G2tensor(35),n2h1(68))
  call Hloop_AS_Q(ntryL,G2H1(16),ex3(:),G2H1(8),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,nMB,G3tensor(6),n2h1(69))
  call Hloop_AS_Q(ntryL,G1H1(25),ex3(:),G1H1(23),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(36),n2h1(70))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(37),m3h2x1(:,12),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(38),m3h2x1(:,13),heltab2x2(:,:,28))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(39),m3h2x1(:,14),heltab2x2(:,:,29))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(40),m3h2x1(:,15),heltab2x2(:,:,30))
call Hotf_4pt_reduction(G2H6(2),RedSet_4(6),mass4set(:,2),  & 
G1H6(6),G1H6(8),G1H6(14),G1H6(26),G1H6(13),6)
call HG1shiftOLR(G1H6(8),9,6)
call Hotf_4pt_reduction(G2H6(1),RedSet_4(4),mass4set(:,2),  & 
G1H6(11),G1H6(17),G1H6(4),G1H6(10),G1H6(1),6)
call HG1shiftOLR(G1H6(17),10,6)
call Hotf_4pt_reduction(G2H3(14),RedSet_4(7),mass4set(:,3),  & 
G1H3(55),G1H3(57),G1H3(84),G1H3(85),G1H3(86),3)
call HG1shiftOLR(G1H3(57),12,3)
call Hotf_4pt_reduction(G2H3(1),RedSet_4(5),mass4set(:,3),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),3)
call HG1shiftOLR(G1H3(88),12,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(41),m3h2x1(:,16),heltab2x2(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(42),m3h2x1(:,17),heltab2x2(:,:,32))
  call Hloop_QZ_A(ntryL,G1H3(47),ex4(:),G1H1(51),ngZd,m3h3x1(:,60),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(51),31,nMB,G2tensor(43),n2h1(71))
  call Hloop_QS_A(ntryL,G1H1(22),ex3(:),G1H1(25),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(44),n2h1(72))
  call Hloop_AZ_Q(ntryL,G1H3(69),ex4(:),G1H1(23),ngZd,m3h3x1(:,61),heltab2x3(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(45),n2h1(73))
  call Hloop_AS_Q(ntryL,G1H1(15),ex3(:),G1H1(51),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(51),31,nMB,G2tensor(46),n2h1(74))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(47),m3h2x1(:,18),heltab2x2(:,:,33))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(48),m3h2x1(:,19),heltab2x2(:,:,34))
call Hotf_4pt_reduction(G2H1(17),RedSet_4(26),mass4set(:,6),  & 
G1H1(22),G1H1(25),G1H1(23),G1H1(15),G1H1(51),1)
call HG1shiftOLR(G1H1(25),4,1)
  call Hloop_QS_A(ntryL,G2H1(19),ex3(:),G2H1(2),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(2),31,nMT,G3tensor(7),n2h1(75))
  call Hloop_QS_A(ntryL,G1H1(20),ex3(:),G1H1(52),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(52),31,nMT,G2tensor(49),n2h1(76))
call Hotf_4pt_reduction(G2H1(20),RedSet_4(26),mass4set(:,6),  & 
G1H1(20),G1H1(52),G1H1(53),G1H1(54),G1H1(55),1)
call HG1shiftOLR(G1H1(52),4,1)
  call Hloop_AS_Q(ntryL,G2H1(22),ex3(:),G2H1(3),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(8),n2h1(77))
  call Hloop_AS_Q(ntryL,G1H1(21),ex3(:),G1H1(56),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMT,G2tensor(50),n2h1(78))
call Hotf_4pt_reduction(G2H3(24),RedSet_4(19),mass4set(:,6),  & 
G1H3(47),G1H3(69),G1H3(92),G1H3(93),G1H3(94),3)
call HG1shiftOLR(G1H3(69),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(29),ex4(:),G2H1(7),ngZu,m3h3x1(:,62),heltab2x3(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMT,G3tensor(9),n2h1(79))
  call Hloop_AZ_Q(ntryL,G1H3(5),ex4(:),G1H1(21),ngZu,m3h3x1(:,63),heltab2x3(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMT,G2tensor(51),n2h1(80))
call Hotf_4pt_reduction(G2H3(30),RedSet_4(19),mass4set(:,6),  & 
G1H3(5),G1H3(95),G1H3(96),G1H3(97),G1H3(98),3)
call HG1shiftOLR(G1H3(95),8,3)
  call Hloop_QZ_A(ntryL,G2H3(32),ex4(:),G2H1(1),ngZu,m3h3x1(:,64),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(81))
  call Hloop_QZ_A(ntryL,G1H3(43),ex4(:),G1H1(56),ngZu,m3h3x1(:,65),heltab2x3(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),31,nMT,G2tensor(52),n2h1(82))
call Hotf_4pt_reduction(G2H3(33),RedSet_4(16),mass4set(:,6),  & 
G1H3(43),G1H3(99),G1H3(100),G1H3(101),G1H3(102),3)
call HG1shiftOLR(G1H3(99),8,3)
  call Hloop_QZ_A(ntryL,G2H3(35),ex4(:),G2H1(10),ngZu,m3h3x1(:,66),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(11),n2h1(83))
  call Hloop_QZ_A(ntryL,G1H3(17),ex4(:),G1H1(21),ngZu,m3h3x1(:,67),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMT,G2tensor(53),n2h1(84))
call Hotf_4pt_reduction(G2H3(36),RedSet_4(16),mass4set(:,6),  & 
G1H3(17),G1H3(103),G1H3(104),G1H3(105),G1H3(106),3)
call HG1shiftOLR(G1H3(103),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(38),ex4(:),G2H1(12),ngZu,m3h3x1(:,68),heltab2x3(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(12),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H3(36),ex4(:),G1H1(56),ngZu,m3h3x1(:,69),heltab2x3(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMT,G2tensor(54),n2h1(86))
  call Hloop_QZ_A(ntryL,G1H3(30),ex4(:),G1H1(21),ngZd,m3h3x1(:,70),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(55),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex4(:),G1H1(56),ngZd,m3h3x1(:,71),heltab2x3(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(56),n2h1(88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),wf2(:,2),G2tensor(57),m3h2x1(:,20),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(31),wf2(:,2),G2tensor(58),m3h2x1(:,21),heltab2x2(:,:,36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),wf2(:,4),G2tensor(59),m3h2x1(:,22),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),wf2(:,4),G2tensor(60),m3h2x1(:,23),heltab2x2(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(5),wf6(:,5),G2tensor(61),m3h6x1(:,5),heltab2x6(:,:,79))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(3),wf6(:,5),G2tensor(62),m3h6x1(:,6),heltab2x6(:,:,80))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(4),wf6(:,2),G2tensor(63),m3h6x1(:,7),heltab2x6(:,:,81))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(8),wf6(:,2),G2tensor(64),m3h6x1(:,8),heltab2x6(:,:,82))
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(21),m3h2x1(:,24),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(65),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(6),ex2(:),G1H1(56),m3h2x1(:,25),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),2,nMB,G2tensor(66),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(21),m3h2x1(:,26),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(67),n2h1(91))
  call Hloop_AZ_Q(ntryL,G1H3(62),ex4(:),G1H1(56),ngZd,m3h3x1(:,72),heltab2x3(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(68),n2h1(92))
  call Hloop_AZ_Q(ntryL,G1H3(19),ex4(:),G1H1(21),ngZd,m3h3x1(:,73),heltab2x3(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),8,nMB,G2tensor(69),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(64),ex4(:),G1H1(56),ngZd,m3h3x1(:,74),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(70),n2h1(94))
  call Hloop_QS_A(ntryL,G1H1(4),ex3(:),G1H1(21),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(71),n2h1(95))
  call Hloop_QS_A(ntryL,G1H1(9),ex3(:),G1H1(56),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),4,nMB,G2tensor(72),n2h1(96))
  call Hloop_QS_A(ntryL,G1H1(6),ex3(:),G1H1(4),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(73),n2h1(97))
  call Hloop_QZ_A(ntryL,G1H3(66),ex4(:),G1H1(21),ngZd,m3h3x1(:,75),heltab2x3(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(74),n2h1(98))
  call Hloop_QZ_A(ntryL,G1H3(31),ex4(:),G1H1(9),ngZd,m3h3x1(:,76),heltab2x3(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),8,nMB,G2tensor(75),n2h1(99))
  call Hloop_QZ_A(ntryL,G1H3(6),ex4(:),G1H1(56),ngZd,m3h3x1(:,77),heltab2x3(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(76),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(8),ex1(:),G1H1(6),m3h2x1(:,27),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(77),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(15),ex1(:),G1H1(4),m3h2x1(:,28),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),1,nMB,G2tensor(78),n2h1(102))
  call Hloop_VQ_A(ntryL,G1H2(10),ex1(:),G1H1(21),m3h2x1(:,29),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(79),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H3(54),ex4(:),G1H1(9),ngZd,m3h3x1(:,78),heltab2x3(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(80),n2h1(104))
  call Hloop_QZ_A(ntryL,G1H3(12),ex4(:),G1H1(56),ngZd,m3h3x1(:,79),heltab2x3(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),8,nMB,G2tensor(81),n2h1(105))
  call Hloop_QZ_A(ntryL,G1H3(1),ex4(:),G1H1(6),ngZd,m3h3x1(:,80),heltab2x3(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(82),n2h1(106))
  call Hloop_QZ_A(ntryL,G1H3(37),ex4(:),G1H1(4),ngZd,m3h3x1(:,81),heltab2x3(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(83),n2h1(107))
  call Hloop_QZ_A(ntryL,G1H3(42),ex4(:),G1H1(21),ngZd,m3h3x1(:,82),heltab2x3(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),8,nMB,G2tensor(84),n2h1(108))
  call Hloop_QZ_A(ntryL,G1H3(25),ex4(:),G1H1(9),ngZd,m3h3x1(:,83),heltab2x3(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(85),n2h1(109))
  call Hloop_QS_A(ntryL,G1H1(1),ex3(:),G1H1(56),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(86),n2h1(110))
  call Hloop_QS_A(ntryL,G1H1(12),ex3(:),G1H1(6),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),4,nMB,G2tensor(87),n2h1(111))
  call Hloop_QS_A(ntryL,G1H1(17),ex3(:),G1H1(4),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(88),n2h1(112))
  call Hloop_AS_Q(ntryL,G1H1(18),ex3(:),G1H1(21),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(89),n2h1(113))
  call Hloop_AS_Q(ntryL,G1H1(24),ex3(:),G1H1(9),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),4,nMB,G2tensor(90),n2h1(114))
  call Hloop_AS_Q(ntryL,G1H1(28),ex3(:),G1H1(1),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(115))
  call Hloop_AZ_Q(ntryL,G1H3(58),ex4(:),G1H1(56),ngZd,m3h3x1(:,84),heltab2x3(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(92),n2h1(116))
  call Hloop_AZ_Q(ntryL,G1H3(8),ex4(:),G1H1(12),ngZd,m3h3x1(:,85),heltab2x3(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),8,nMB,G2tensor(93),n2h1(117))
  call Hloop_AZ_Q(ntryL,G1H3(38),ex4(:),G1H1(6),ngZd,m3h3x1(:,86),heltab2x3(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(94),n2h1(118))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex4(:),G1H1(17),ngZd,m3h3x1(:,87),heltab2x3(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(95),n2h1(119))
  call Hloop_AZ_Q(ntryL,G1H3(14),ex4(:),G1H1(4),ngZd,m3h3x1(:,88),heltab2x3(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),8,nMB,G2tensor(96),n2h1(120))
  call Hloop_AZ_Q(ntryL,G1H3(33),ex4(:),G1H1(18),ngZd,m3h3x1(:,89),heltab2x3(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(97),n2h1(121))
  call Hloop_AS_Q(ntryL,G1H1(29),ex3(:),G1H1(21),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(98),n2h1(122))
  call Hloop_AS_Q(ntryL,G1H1(30),ex3(:),G1H1(24),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),4,nMB,G2tensor(99),n2h1(123))
  call Hloop_AS_Q(ntryL,G1H1(33),ex3(:),G1H1(9),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(100),n2h1(124))
  call Hloop_QZ_A(ntryL,G1H3(15),ex4(:),G1H1(28),ngZd,m3h3x1(:,90),heltab2x3(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(101),n2h1(125))
  call Hloop_QZ_A(ntryL,G1H3(21),ex4(:),G1H1(1),ngZd,m3h3x1(:,91),heltab2x3(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(102),n2h1(126))
  call Hloop_QZ_A(ntryL,G1H3(39),ex4(:),G1H1(56),ngZd,m3h3x1(:,92),heltab2x3(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(103),n2h1(127))
  call Hloop_QS_A(ntryL,G1H1(34),ex3(:),G1H1(12),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(104),n2h1(128))
  call Hloop_QS_A(ntryL,G1H1(35),ex3(:),G1H1(6),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),4,nMB,G2tensor(105),n2h1(129))
  call Hloop_QS_A(ntryL,G1H1(38),ex3(:),G1H1(17),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(106),n2h1(130))
  call Hloop_AZ_Q(ntryL,G1H3(46),ex4(:),G1H1(4),ngZd,m3h3x1(:,93),heltab2x3(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(107),n2h1(131))
  call Hloop_AZ_Q(ntryL,G1H3(49),ex4(:),G1H1(18),ngZd,m3h3x1(:,94),heltab2x3(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),8,nMB,G2tensor(108),n2h1(132))
  call Hloop_AZ_Q(ntryL,G1H3(3),ex4(:),G1H1(29),ngZd,m3h3x1(:,95),heltab2x3(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,nMB,G2tensor(109),n2h1(133))
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(21),ngZd,m3h3x1(:,96),heltab2x3(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(110),n2h1(134))
  call Hloop_QZ_A(ntryL,G1H3(20),ex4(:),G1H1(30),ngZd,m3h3x1(:,97),heltab2x3(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),8,nMB,G2tensor(111),n2h1(135))
  call Hloop_QZ_A(ntryL,G1H3(71),ex4(:),G1H1(24),ngZd,m3h3x1(:,98),heltab2x3(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(112),n2h1(136))
  call Hloop_QZ_A(ntryL,G1H3(35),ex4(:),G1H1(33),ngZd,m3h3x1(:,99),heltab2x3(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(33),31,nMB,G2tensor(113),n2h1(137))
  call Hloop_QZ_A(ntryL,G1H3(72),ex4(:),G1H1(9),ngZd,m3h3x1(:,100),heltab2x3(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),8,nMB,G2tensor(114),n2h1(138))
  call Hloop_QZ_A(ntryL,G1H3(75),ex4(:),G1H1(28),ngZd,m3h3x1(:,101),heltab2x3(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(115),n2h1(139))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(1),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(116),n2h1(140))
  call Hloop_QS_A(ntryL,G1H1(39),ex3(:),G1H1(56),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),4,nMB,G2tensor(117),n2h1(141))
  call Hloop_QS_A(ntryL,G1H1(41),ex3(:),G1H1(34),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(118),n2h1(142))
  call Hloop_AZ_Q(ntryL,G1H3(44),ex4(:),G1H1(12),ngZd,m3h3x1(:,102),heltab2x3(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(119),n2h1(143))
  call Hloop_AZ_Q(ntryL,G1H3(45),ex4(:),G1H1(35),ngZd,m3h3x1(:,103),heltab2x3(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),8,nMB,G2tensor(120),n2h1(144))
  call Hloop_AZ_Q(ntryL,G1H3(78),ex4(:),G1H1(6),ngZd,m3h3x1(:,104),heltab2x3(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(121),n2h1(145))
  call Hloop_AZ_Q(ntryL,G1H3(79),ex4(:),G1H1(38),ngZd,m3h3x1(:,105),heltab2x3(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),31,nMB,G2tensor(122),n2h1(146))
  call Hloop_AZ_Q(ntryL,G1H3(80),ex4(:),G1H1(17),ngZd,m3h3x1(:,106),heltab2x3(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(123),n2h1(147))
  call Hloop_AZ_Q(ntryL,G1H3(83),ex4(:),G1H1(4),ngZd,m3h3x1(:,107),heltab2x3(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(124),n2h1(148))
  call Hloop_AS_Q(ntryL,G1H1(14),ex3(:),G1H1(18),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(125),n2h1(149))
  call Hloop_AS_Q(ntryL,G1H1(42),ex3(:),G1H1(29),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),4,nMB,G2tensor(126),n2h1(150))
  call Hloop_AS_Q(ntryL,G1H1(45),ex3(:),G1H1(21),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(127),n2h1(151))
  call Hloop_AS_Q(ntryL,G1H1(46),ex3(:),G1H1(30),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nMB,G2tensor(128),n2h1(152))
  call Hloop_AS_Q(ntryL,G1H1(47),ex3(:),G1H1(24),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),4,nMB,G2tensor(129),n2h1(153))
  call Hloop_AS_Q(ntryL,G1H1(50),ex3(:),G1H1(33),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(33),31,nMB,G2tensor(130),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H6(6),wf6(:,5),G1H1(9),m3h6x1(:,9),heltab2x6(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(131),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H6(8),wf6(:,5),G1H1(28),m3h6x1(:,10),heltab2x6(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),9,nMB,G2tensor(132),n2h1(156))
  call Hloop_VQ_A(ntryL,G1H6(13),wf6(:,5),G1H1(2),m3h6x1(:,11),heltab2x6(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(133),n2h1(157))
  call Hloop_VA_Q(ntryL,G1H6(11),wf6(:,2),G1H1(1),m3h6x1(:,12),heltab2x6(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(134),n2h1(158))
  call Hloop_VA_Q(ntryL,G1H6(17),wf6(:,2),G1H1(39),m3h6x1(:,13),heltab2x6(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),10,nMB,G2tensor(135),n2h1(159))
  call Hloop_VA_Q(ntryL,G1H6(1),wf6(:,2),G1H1(56),m3h6x1(:,14),heltab2x6(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(136),n2h1(160))
  call Hloop_AZ_Q(ntryL,G1H3(55),wf3(:,2),G1H1(41),ngZd,m3h3x1(:,108),heltab2x3(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(137),n2h1(161))
  call Hloop_AZ_Q(ntryL,G1H3(57),wf3(:,2),G1H1(34),ngZd,m3h3x1(:,109),heltab2x3(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),12,nMB,G2tensor(138),n2h1(162))
  call Hloop_AZ_Q(ntryL,G1H3(86),wf3(:,2),G1H1(12),ngZd,m3h3x1(:,110),heltab2x3(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(139),n2h1(163))
  call Hloop_QZ_A(ntryL,G1H3(87),wf3(:,2),G1H1(35),ngZd,m3h3x1(:,111),heltab2x3(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),31,nMB,G2tensor(140),n2h1(164))
  call Hloop_QZ_A(ntryL,G1H3(88),wf3(:,2),G1H1(6),ngZd,m3h3x1(:,112),heltab2x3(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),12,nMB,G2tensor(141),n2h1(165))
  call Hloop_QZ_A(ntryL,G1H3(91),wf3(:,2),G1H1(38),ngZd,m3h3x1(:,113),heltab2x3(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),31,nMB,G2tensor(142),n2h1(166))
  call Hloop_QS_A(ntryL,G1H1(22),ex3(:),G1H1(17),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMT,G2tensor(143),n2h1(167))
  call Hloop_QS_A(ntryL,G1H1(25),ex3(:),G1H1(4),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),4,nMT,G2tensor(144),n2h1(168))
  call Hloop_QS_A(ntryL,G1H1(51),ex3(:),G1H1(14),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMT,G2tensor(145),n2h1(169))
  call Hloop_AS_Q(ntryL,G1H1(20),ex3(:),G1H1(18),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMT,G2tensor(146),n2h1(170))
  call Hloop_AS_Q(ntryL,G1H1(52),ex3(:),G1H1(42),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),4,nMT,G2tensor(147),n2h1(171))
  call Hloop_AS_Q(ntryL,G1H1(55),ex3(:),G1H1(29),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,nMT,G2tensor(148),n2h1(172))
  call Hloop_AZ_Q(ntryL,G1H3(47),ex4(:),G1H1(45),ngZu,m3h3x1(:,114),heltab2x3(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(45),31,nMT,G2tensor(149),n2h1(173))
  call Hloop_AZ_Q(ntryL,G1H3(69),ex4(:),G1H1(21),ngZu,m3h3x1(:,115),heltab2x3(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),8,nMT,G2tensor(150),n2h1(174))
  call Hloop_AZ_Q(ntryL,G1H3(94),ex4(:),G1H1(46),ngZu,m3h3x1(:,116),heltab2x3(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(46),31,nMT,G2tensor(151),n2h1(175))
  call Hloop_QZ_A(ntryL,G1H3(5),ex4(:),G1H1(30),ngZu,m3h3x1(:,117),heltab2x3(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),31,nMT,G2tensor(152),n2h1(176))
  call Hloop_QZ_A(ntryL,G1H3(95),ex4(:),G1H1(47),ngZu,m3h3x1(:,118),heltab2x3(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),8,nMT,G2tensor(153),n2h1(177))
  call Hloop_QZ_A(ntryL,G1H3(98),ex4(:),G1H1(24),ngZu,m3h3x1(:,119),heltab2x3(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nMT,G2tensor(154),n2h1(178))
  call Hloop_QZ_A(ntryL,G1H3(43),ex4(:),G1H1(50),ngZu,m3h3x1(:,120),heltab2x3(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMT,G2tensor(155),n2h1(179))
  call Hloop_QZ_A(ntryL,G1H3(99),ex4(:),G1H1(33),ngZu,m3h3x1(:,121),heltab2x3(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(33),8,nMT,G2tensor(156),n2h1(180))
  call Hloop_QZ_A(ntryL,G1H3(102),ex4(:),G1H1(9),ngZu,m3h3x1(:,122),heltab2x3(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMT,G2tensor(157),n2h1(181))
  call Hloop_AZ_Q(ntryL,G1H3(17),ex4(:),G1H1(28),ngZu,m3h3x1(:,123),heltab2x3(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(158),n2h1(182))
  call Hloop_AZ_Q(ntryL,G1H3(103),ex4(:),G1H1(2),ngZu,m3h3x1(:,124),heltab2x3(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),8,nMT,G2tensor(159),n2h1(183))
  call Hloop_AZ_Q(ntryL,G1H3(106),ex4(:),G1H1(1),ngZu,m3h3x1(:,125),heltab2x3(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(160),n2h1(184))
  call ol_merge_tensors(G2tensor(63),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(7),G1tensor(18)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(19),G2tensor(11),G1tensor(36),G1tensor(24)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(18),G1tensor(32),G1tensor(27)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(27),G2tensor(23),G1tensor(48),G1tensor(42)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(26),G1tensor(44),G1tensor(15)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(21),G1tensor(2)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(33),G1tensor(8)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(68),G1tensor(29),G1tensor(17)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(110),G1tensor(40),G1tensor(22)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(116),G1tensor(46),G1tensor(34)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(43)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(44)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(49)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(51)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(53)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(55)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(143)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(149)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(155)])
call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
call G_TensorShift(G1tensor(7),10)
call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(6),G1tensor(12))
call G_TensorShift(G1tensor(37),6)
call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(37),mass4set(:,2),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(36),G1tensor(24))
call G_TensorShift(G1tensor(18),2)
call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(4),mass4set(:,2),  & 
G1tensor(26),G1tensor(30),G1tensor(32),G1tensor(27),G1tensor(38))
call G_TensorShift(G1tensor(30),10)
call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(38),mass4set(:,3),  & 
G1tensor(48),G1tensor(42),G1tensor(44),G1tensor(15),G1tensor(21))
call G_TensorShift(G1tensor(42),4)
call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(5),mass4set(:,3),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(11),G1tensor(5))
call G_TensorShift(G1tensor(3),12)
call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(39),mass4set(:,2),  & 
G1tensor(33),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(16))
call G_TensorShift(G1tensor(8),1)
call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(6),mass4set(:,2),  & 
G1tensor(29),G1tensor(17),G1tensor(40),G1tensor(22),G1tensor(23))
call G_TensorShift(G1tensor(17),9)
call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(22),mass4set(:,3),  & 
G1tensor(28),G1tensor(46),G1tensor(34),G1tensor(35),G1tensor(39))
call G_TensorShift(G1tensor(46),8)
call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(40),mass4set(:,3),  & 
G1tensor(41),G1tensor(45),G1tensor(47),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(45),4)
call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(7),mass4set(:,3),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),12)
call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(14),mass4set(:,3),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),8)
call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(18),mass4set(:,7),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),8)
call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(8),mass4set(:,5),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),2)
call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(9),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),2)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),2)
call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(25),mass4set(:,7),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),4)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(11),mass4set(:,5),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),2)
call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(12),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),2)
call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(15),mass4set(:,3),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),8)
call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(16),mass4set(:,4),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),8)
call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(19),mass4set(:,4),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),8)
call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(20),mass4set(:,3),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),8)
call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(23),mass4set(:,3),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),8)
call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(26),mass4set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),4)
call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(27),mass4set(:,3),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),4)
call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(29),mass4set(:,7),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
call G_TensorShift(G1tensor(132),8)
call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(30),mass4set(:,3),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
call G_TensorShift(G1tensor(137),8)
call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(32),mass4set(:,7),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
call G_TensorShift(G1tensor(142),4)
call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(33),mass4set(:,3),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(147),4)
call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(19),mass4set(:,4),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G0tensor(1))
call G_TensorShift(G1tensor(152),8)
call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(26),mass4set(:,4),  & 
G1tensor(151),G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G0tensor(2))
call G_TensorShift(G1tensor(156),4)
call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(26),mass4set(:,6),  & 
G1tensor(151),G1tensor(160),G1tensor(161),G1tensor(162),G1tensor(163),G0tensor(3))
call G_TensorShift(G1tensor(160),4)
call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(19),mass4set(:,6),  & 
G1tensor(151),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G0tensor(4))
call G_TensorShift(G1tensor(164),8)
call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(16),mass4set(:,6),  & 
G1tensor(151),G1tensor(168),G1tensor(169),G1tensor(170),G1tensor(171),G0tensor(5))
call G_TensorShift(G1tensor(168),8)
call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(16),mass4set(:,4),  & 
G1tensor(151),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175),G0tensor(6))
call G_TensorShift(G1tensor(172),8)
call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(35),mass4set(:,1),  & 
G1tensor(151),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179))
call G_TensorShift(G1tensor(176),5)
call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(36),mass4set(:,1),  & 
G1tensor(180),G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184))
call G_TensorShift(G1tensor(181),9)
call Hotf_4pt_reduction_last(G2tensor(146),RedSet_4(26),mass4set(:,6),  & 
G1tensor(185),G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189))
call G_TensorShift(G1tensor(186),4)
call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(19),mass4set(:,6),  & 
G1tensor(190),G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194))
call G_TensorShift(G1tensor(191),8)
call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(16),mass4set(:,6),  & 
G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199))
call G_TensorShift(G1tensor(196),8)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10),G0tensor(11))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16))
call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(37),mass4set(:,2),  & 
G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),G0tensor(21))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(4),mass4set(:,2),  & 
G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25),G0tensor(26))
call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(38),mass4set(:,3),  & 
G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30),G0tensor(31))
call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(5),mass4set(:,3),  & 
G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35),G0tensor(36))
call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(39),mass4set(:,2),  & 
G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40),G0tensor(41))
call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(6),mass4set(:,2),  & 
G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46))
call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(22),mass4set(:,3),  & 
G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50),G0tensor(51))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(40),mass4set(:,3),  & 
G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55),G0tensor(56))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(7),mass4set(:,3),  & 
G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),G0tensor(61))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(14),mass4set(:,3),  & 
G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65),G0tensor(66))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(18),mass4set(:,7),  & 
G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),G0tensor(71))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,5),  & 
G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),G0tensor(76))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(9),mass4set(:,1),  & 
G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),G0tensor(81))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(1),mass4set(:,1),  & 
G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85),G0tensor(86))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(25),mass4set(:,7),  & 
G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),G0tensor(91))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(11),mass4set(:,5),  & 
G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),G0tensor(96))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(12),mass4set(:,1),  & 
G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),G0tensor(101))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(15),mass4set(:,3),  & 
G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105),G0tensor(106))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(16),mass4set(:,4),  & 
G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110),G0tensor(111))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(19),mass4set(:,4),  & 
G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115),G0tensor(116))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(20),mass4set(:,3),  & 
G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120),G0tensor(121))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(23),mass4set(:,3),  & 
G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125),G0tensor(126))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(26),mass4set(:,4),  & 
G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130),G0tensor(131))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(27),mass4set(:,3),  & 
G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135),G0tensor(136))
call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(29),mass4set(:,7),  & 
G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140),G0tensor(141))
call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(30),mass4set(:,3),  & 
G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145),G0tensor(146))
call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(32),mass4set(:,7),  & 
G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150),G0tensor(151))
call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(33),mass4set(:,3),  & 
G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155),G0tensor(156))
call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(35),mass4set(:,1),  & 
G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160),G0tensor(161))
call Hotf_4pt_reduction_last(G1tensor(180),RedSet_4(36),mass4set(:,1),  & 
G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165),G0tensor(166))
call Hotf_4pt_reduction_last(G1tensor(185),RedSet_4(26),mass4set(:,6),  & 
G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170),G0tensor(171))
call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(19),mass4set(:,6),  & 
G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175),G0tensor(176))
call Hotf_4pt_reduction_last(G1tensor(195),RedSet_4(16),mass4set(:,6),  & 
G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180),G0tensor(181))
call ol_merge_tensors(T0sum(1),[G0tensor(7)])
call ol_merge_tensors(T0sum(2),[G0tensor(12)])
call ol_merge_tensors(T0sum(3),[G0tensor(17)])
call ol_merge_tensors(T0sum(4),[G0tensor(22)])
call ol_merge_tensors(T0sum(5),[G0tensor(27)])
call ol_merge_tensors(T0sum(6),[G0tensor(32)])
call ol_merge_tensors(T0sum(7),[G0tensor(37)])
call ol_merge_tensors(T0sum(8),[G0tensor(42)])
call ol_merge_tensors(T0sum(9),[G0tensor(47)])
call ol_merge_tensors(T0sum(10),[G0tensor(52)])
call ol_merge_tensors(T0sum(11),[G0tensor(57)])
call ol_merge_tensors(T0sum(12),[G0tensor(62)])
call ol_merge_tensors(T0sum(13),[G0tensor(67)])
call ol_merge_tensors(T0sum(14),[G0tensor(72)])
call ol_merge_tensors(T0sum(15),[G0tensor(77)])
call ol_merge_tensors(T0sum(16),[G0tensor(82)])
call ol_merge_tensors(T0sum(17),[G0tensor(87)])
call ol_merge_tensors(T0sum(18),[G0tensor(92)])
call ol_merge_tensors(T0sum(19),[G0tensor(97)])
call ol_merge_tensors(T0sum(20),[G0tensor(102)])
call ol_merge_tensors(T0sum(21),[G0tensor(107)])
call ol_merge_tensors(T0sum(22),[G0tensor(112)])
call ol_merge_tensors(T0sum(23),[G0tensor(117)])
call ol_merge_tensors(T0sum(24),[G0tensor(122)])
call ol_merge_tensors(T0sum(25),[G0tensor(127)])
call ol_merge_tensors(T0sum(26),[G0tensor(132)])
call ol_merge_tensors(T0sum(27),[G0tensor(137)])
call ol_merge_tensors(T0sum(28),[G0tensor(142)])
call ol_merge_tensors(T0sum(29),[G0tensor(147)])
call ol_merge_tensors(T0sum(30),[G0tensor(152)])
call ol_merge_tensors(T0sum(31),[G0tensor(1)])
call ol_merge_tensors(T0sum(32),[G0tensor(2)])
call ol_merge_tensors(T0sum(33),[G0tensor(3)])
call ol_merge_tensors(T0sum(34),[G0tensor(4)])
call ol_merge_tensors(T0sum(35),[G0tensor(5)])
call ol_merge_tensors(T0sum(36),[G0tensor(6)])
call ol_merge_tensors(T0sum(37),[G0tensor(157)])
call ol_merge_tensors(T0sum(38),[G0tensor(162)])
call ol_merge_tensors(T0sum(39),[G0tensor(167)])
call ol_merge_tensors(T0sum(40),[G0tensor(172)])
call ol_merge_tensors(T0sum(41),[G0tensor(177)])
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(40),h0tab(:,40),[16,3,12],[0,0,0],3,2,wf4(:,7),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,36),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(22),n2h12(41))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(41),h0tab(:,41),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,7),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,37),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMT,G1H12(23),n2h12(42))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(42),h0tab(:,42),[16,3,12],[0,0,0],3,2,wf4(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,38),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G0H12(3),16,0,G1H12(5),n2h12(43))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(43),h0tab(:,43),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,39),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G0H12(4),16,nMT,G1H12(24),n2h12(44))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(44),h0tab(:,44),[16,3,12],[0,0,0],3,2,wf4(:,7),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,40),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(25),n2h12(45))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(45),h0tab(:,45),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,7),wf3(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,41),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(26),n2h12(46))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(46),h0tab(:,46),[16,3,12],[0,0,0],3,2,wf4(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,42),heltab2x24(:,:,46))
  call Hloop_Q_A(ntryL,G0H12(3),16,0,G1H12(27),n2h12(47))
Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(47),h0tab(:,47),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,43),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G0H12(4),16,nMB,G1H12(6),n2h12(48))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(48),h0tab(:,48),[16,5,10],[nMB,0,nMB],3,2,wf2(:,2),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,44),heltab2x24(:,:,48))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(7),n2h12(49))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(49),h0tab(:,49),[16,5,10],[0,nMB,0],3,2,wf2(:,2),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(9),m3h2x12(:,45),heltab2x24(:,:,49))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(50),h0tab(:,50),[18,5,8],[0,nMB,nMB],3,2,wf4(:,3),wf2(:,2))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(1),m3h4x6(:,5),heltab2x24(:,:,50))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(51),h0tab(:,51),[16,7,8],[0,0,0],3,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,46),heltab2x24(:,:,51))
  call Hloop_A_Q(ntryL,G0H12(2),16,0,G1H12(10),n2h12(50))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(52),h0tab(:,52),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,47),heltab2x24(:,:,52))
  call Hloop_A_Q(ntryL,G0H12(3),16,nMT,G1H12(2),n2h12(51))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(53),h0tab(:,53),[16,7,8],[0,0,0],3,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,48),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G0H12(4),16,0,G1H12(11),n2h12(52))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(54),h0tab(:,54),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,49),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(12),n2h12(53))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(55),h0tab(:,55),[16,7,8],[0,0,0],3,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,50),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G0H12(2),16,0,G1H12(1),n2h12(54))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(56),h0tab(:,56),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,51),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G0H12(3),16,nMB,G1H12(13),n2h12(55))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(57),h0tab(:,57),[16,7,8],[0,0,0],3,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,52),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G0H12(4),16,0,G1H12(14),n2h12(56))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(58),h0tab(:,58),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,53),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(16),n2h12(57))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(59),h0tab(:,59),[16,2,13],[nMB,0,nMB],3,1,wf6(:,17))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,54),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G0H12(2),16,nMB,G1H12(17),n2h12(58))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(60),h0tab(:,60),[16,2,13],[0,nMB,0],3,1,wf6(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(18),m3h2x12(:,55),heltab2x24(:,:,60))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(61),h0tab(:,61),[21,2,8],[0,nMB,nMB],3,1,wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,18),G0H6(2),m3h4x6(:,6),heltab2x24(:,:,61))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(62),h0tab(:,62),[16,6,9],[nMB,0,nMB],3,2,wf2(:,4),wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,56),heltab2x24(:,:,62))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMB,G1H12(19),n2h12(59))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(63),h0tab(:,63),[16,6,9],[0,nMB,0],3,2,wf2(:,4),wf6(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(4),m3h2x12(:,57),heltab2x24(:,:,63))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(64),h0tab(:,64),[17,6,8],[0,nMB,nMB],3,2,wf4(:,5),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,5),G0H6(3),m3h4x6(:,7),heltab2x24(:,:,64))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(65),h0tab(:,65),[16,7,8],[0,0,0],3,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,58),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G0H12(4),16,0,G1H12(21),n2h12(60))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(66),h0tab(:,66),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,59),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMT,G1H12(28),n2h12(61))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(67),h0tab(:,67),[16,7,8],[0,0,0],3,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,60),heltab2x24(:,:,67))
  call Hloop_Q_A(ntryL,G0H12(2),16,0,G1H12(29),n2h12(62))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(68),h0tab(:,68),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,61),heltab2x24(:,:,68))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMT,G1H12(30),n2h12(63))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(69),h0tab(:,69),[16,7,8],[0,0,0],3,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,62),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G0H12(4),16,0,G1H12(31),n2h12(64))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(70),h0tab(:,70),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,63),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(32),n2h12(65))
Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(71),h0tab(:,71),[16,7,8],[0,0,0],3,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,64),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G0H12(2),16,0,G1H12(33),n2h12(66))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(72),h0tab(:,72),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,65),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMB,G1H12(34),n2h12(67))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(73),h0tab(:,73),[16,1,14],[nMB,0,nMB],3,1,wf6(:,20))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,66),heltab2x24(:,:,73))
  call Hloop_A_Q(ntryL,G0H12(4),16,nMB,G1H12(35),n2h12(68))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(74),h0tab(:,74),[16,1,14],[0,nMB,0],3,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(36),m3h2x12(:,67),heltab2x24(:,:,74))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(75),h0tab(:,75),[22,1,8],[0,nMB,nMB],3,1,wf4(:,21))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,21),G0H6(4),m3h4x6(:,8),heltab2x24(:,:,75))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(76),h0tab(:,76),[18,4,9],[nMB,nMB,0],3,2,wf4(:,3),wf6(:,5))
  call Hloop_VA_Q(ntryL,G0H24(1),wf4(:,3),G0H6(5),m3h4x6(:,9),heltab2x24(:,:,76))
  call Hloop_A_Q(ntryL,G0H6(5),18,nMB,G1H6(23),n2h6(33))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(77),h0tab(:,77),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,68),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(37),n2h12(69))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(78),h0tab(:,78),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,69),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMT,G1H12(38),n2h12(70))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(79),h0tab(:,79),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,70),heltab2x24(:,:,79))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMB,G1H12(39),n2h12(71))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(62)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(80),h0tab(:,80),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,71),heltab2x24(:,:,80))
  call Hloop_A_Q(ntryL,G0H12(4),16,nMB,G1H12(40),n2h12(72))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(81),h0tab(:,81),[16,2,13],[nMB,0,nMB],3,1,wf6(:,21))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,72),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(41),n2h12(73))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(82),h0tab(:,82),[16,2,13],[0,nMB,0],3,1,wf6(:,21))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(42),m3h2x12(:,73),heltab2x24(:,:,82))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(83),h0tab(:,83),[25,2,4],[0,nMB,nMB],3,1,wf12(:,13))
  call Hloop_AQ_V(ntryL,G0H24(1),wf12(:,13),G0H2(1),m3h12x2(:,1),heltab2x24(:,:,83))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(84),h0tab(:,84),[17,4,10],[nMB,nMB,0],3,2,wf4(:,5),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H24(1),wf4(:,5),G0H6(5),m3h4x6(:,10),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G0H6(5),17,nMB,G1H6(22),n2h6(34))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(63)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(85),h0tab(:,85),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,74),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G0H12(2),16,nMT,G1H12(43),n2h12(74))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(63)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(86),h0tab(:,86),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,75),heltab2x24(:,:,86))
  call Hloop_A_Q(ntryL,G0H12(3),16,nMT,G1H12(44),n2h12(75))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(63)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(87),h0tab(:,87),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,76),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G0H12(4),16,nMB,G1H12(45),n2h12(76))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(63)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(88),h0tab(:,88),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(1),m3h2x12(:,77),heltab2x24(:,:,88))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(46),n2h12(77))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(89),h0tab(:,89),[16,1,14],[nMB,0,nMB],3,1,wf6(:,23))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(2),m3h2x12(:,78),heltab2x24(:,:,89))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(47),n2h12(78))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(90),h0tab(:,90),[16,1,14],[0,nMB,0],3,1,wf6(:,23))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(48),m3h2x12(:,79),heltab2x24(:,:,90))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(91),h0tab(:,91),[26,1,4],[0,nMB,nMB],3,1,wf12(:,10))
  call Hloop_QA_V(ntryL,G0H24(1),wf12(:,10),G0H2(2),m3h12x2(:,2),heltab2x24(:,:,91))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(92),h0tab(:,92),[17,2,12],[0,nMB,nMB],3,2,wf4(:,5),wf3(:,2))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,5),G0H6(5),m3h4x6(:,11),heltab2x24(:,:,92))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(93),h0tab(:,93),[18,1,12],[0,nMB,nMB],3,2,wf4(:,3),wf3(:,2))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(6),m3h4x6(:,12),heltab2x24(:,:,93))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(94),h0tab(:,94),[16,2,13],[nMB,0,nMB],3,1,wf6(:,27))
  call Hloop_QV_A(ntryL,G0H24(1),ex5(:),G0H12(3),m3h2x12(:,80),heltab2x24(:,:,94))
  call Hloop_Q_A(ntryL,G0H12(3),16,nMB,G1H12(49),n2h12(79))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(95),h0tab(:,95),[16,2,13],[0,nMB,0],3,1,wf6(:,27))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(50),m3h2x12(:,81),heltab2x24(:,:,95))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(54)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(96),h0tab(:,96),[16,1,14],[nMB,0,nMB],3,1,wf6(:,25))
  call Hloop_AV_Q(ntryL,G0H24(1),ex5(:),G0H12(4),m3h2x12(:,82),heltab2x24(:,:,96))
  call Hloop_A_Q(ntryL,G0H12(4),16,nMB,G1H12(51),n2h12(80))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(54)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(97),h0tab(:,97),[16,1,14],[0,nMB,0],3,1,wf6(:,25))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H12(52),m3h2x12(:,83),heltab2x24(:,:,97))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(98),h0tab(:,98),[21,2,8],[0,nMB,nMB],3,1,wf4(:,25))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,25),G0H6(7),m3h4x6(:,13),heltab2x24(:,:,98))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(99),h0tab(:,99),[25,2,4],[0,nMB,nMB],3,1,wf12(:,14))
  call Hloop_AQ_V(ntryL,G0H24(1),wf12(:,14),G0H2(3),m3h12x2(:,3),heltab2x24(:,:,99))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(100),h0tab(:,100),[22,1,8],[0,nMB,nMB],3,1,wf4(:,24))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,24),G0H6(8),m3h4x6(:,14),heltab2x24(:,:,100))
Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(101),h0tab(:,101),[26,1,4],[0,nMB,nMB],3,1,wf12(:,12))
  call Hloop_QA_V(ntryL,G0H24(1),wf12(:,12),G0H2(4),m3h12x2(:,4),heltab2x24(:,:,101))
  call ol_merge(ntryL,G1H6(20),[G1H6(27)])
  call ol_merge(ntryL,G1H2(3),[G1H2(1)])
  call ol_merge(ntryL,G1H6(23),[G1H6(28)])
  call ol_merge(ntryL,G1H6(22),[G1H6(31)])
  call ol_merge(ntryL,G0H6(7),[G0H6(2)])
  call ol_merge(ntryL,G0H6(8),[G0H6(4)])
  call ol_merge(ntryL,G0H2(3),[G0H2(1)])
  call ol_merge(ntryL,G0H2(4),[G0H2(2)])
  call Hloop_QZ_A(ntryL,G1H6(20),ex4(:),G1H2(2),ngZd,m3h3x2(:,32),heltab2x6(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(10),n2h2(50))
  call Hloop_QS_A(ntryL,G1H2(3),ex3(:),G1H2(14),ngH,m3h1x2(:,16),heltab2x2(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMB,G2H2(5),n2h2(51))
  call Hloop_QS_A(ntryL,G1H3(48),ex3(:),G1H3(36),ngH,m3h1x3(:,31),heltab2x3(:,:,156))
  call Hloop_Q_A(ntryL,G1H3(36),23,nMB,G2H3(2),n2h3(83))
  call Hloop_QZ_A(ntryL,G1H3(10),ex4(:),G1H1(39),ngZd,m3h3x1(:,126),heltab2x3(:,:,157))
  call Hloop_Q_A(ntryL,G1H1(39),27,nMB,G2H1(6),n2h1(185))
  call Hloop_AS_Q(ntryL,G1H3(11),ex3(:),G1H3(30),ngH,m3h1x3(:,32),heltab2x3(:,:,158))
  call Hloop_A_Q(ntryL,G1H3(30),23,nMB,G2H3(5),n2h3(84))
  call Hloop_AZ_Q(ntryL,G1H3(18),ex4(:),G1H1(56),ngZd,m3h3x1(:,127),heltab2x3(:,:,159))
  call Hloop_A_Q(ntryL,G1H1(56),27,nMB,G2H1(5),n2h1(186))
  call Hloop_QZ_A(ntryL,G1H3(2),ex4(:),G1H1(41),ngZu,m3h3x1(:,128),heltab2x3(:,:,160))
  call Hloop_Q_A(ntryL,G1H1(41),27,nMT,G2H1(4),n2h1(187))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex4(:),G1H1(34),ngZu,m3h3x1(:,129),heltab2x3(:,:,161))
  call Hloop_A_Q(ntryL,G1H1(34),27,nMT,G2H1(14),n2h1(188))
  call Hloop_AS_Q(ntryL,G1H3(60),ex3(:),G1H3(52),ngH,m3h1x3(:,33),heltab2x3(:,:,162))
  call Hloop_A_Q(ntryL,G1H3(52),23,nMT,G2H3(8),n2h3(85))
  call Hloop_QS_A(ntryL,G1H3(65),ex3(:),G1H3(62),ngH,m3h1x3(:,34),heltab2x3(:,:,163))
  call Hloop_Q_A(ntryL,G1H3(62),23,nMT,G2H3(10),n2h3(86))
  call Hloop_QV_A(ntryL,G1H12(8),wf4(:,7),G1H3(19),m3h4x3(:,25),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(19),23,nMT,G2H3(12),n2h3(87))
  call Hloop_AV_Q(ntryL,G1H12(3),wf4(:,7),G1H3(64),m3h4x3(:,26),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H3(64),23,nMT,G2H3(16),n2h3(88))
  call Hloop_QV_A(ntryL,G1H12(15),wf4(:,7),G1H3(66),m3h4x3(:,27),heltab2x12(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(66),23,nMB,G2H3(42),n2h3(89))
  call Hloop_AV_Q(ntryL,G1H12(20),wf4(:,7),G1H3(31),m3h4x3(:,28),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(31),23,nMB,G2H3(9),n2h3(90))
  call Hloop_AZ_Q(ntryL,G1H6(18),ex4(:),G1H2(7),ngZd,m3h3x2(:,33),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(7),26,nMB,G2H2(13),n2h2(52))
  call Hloop_QZ_A(ntryL,G1H6(3),ex4(:),G1H2(5),ngZd,m3h3x2(:,34),heltab2x6(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(5),25,nMB,G2H2(12),n2h2(53))
  call Hloop_AS_Q(ntryL,G1H6(23),ex3(:),G1H6(24),ngH,m3h1x6(:,12),heltab2x6(:,:,92))
  call Hloop_A_Q(ntryL,G1H6(24),22,nMB,G2H6(2),n2h6(35))
  call Hloop_QS_A(ntryL,G1H6(22),ex3(:),G1H6(29),ngH,m3h1x6(:,13),heltab2x6(:,:,93))
  call Hloop_Q_A(ntryL,G1H6(29),21,nMB,G2H6(1),n2h6(36))
  call Hloop_QZ_A(ntryL,G1H6(21),wf3(:,2),G1H2(4),ngZd,m3h3x2(:,35),heltab2x6(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(4),29,nMB,G2H2(8),n2h2(54))
  call Hloop_AV_Q(ntryL,G1H12(22),wf4(:,7),G1H3(6),m3h4x3(:,29),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H3(6),19,0,G2H3(39),n2h3(91))
  call Hloop_AV_Q(ntryL,G1H12(23),wf4(:,7),G1H3(54),m3h4x3(:,30),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H3(54),19,nMT,G2H3(11),n2h3(92))
  call Hloop_QV_A(ntryL,G1H12(5),wf4(:,7),G1H3(12),m3h4x3(:,31),heltab2x12(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(12),19,0,G2H3(4),n2h3(93))
  call Hloop_QV_A(ntryL,G1H12(24),wf4(:,7),G1H3(1),m3h4x3(:,32),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMT,G2H3(15),n2h3(94))
  call Hloop_AV_Q(ntryL,G1H12(25),wf4(:,7),G1H3(37),m3h4x3(:,33),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H3(37),19,0,G2H3(13),n2h3(95))
  call Hloop_AV_Q(ntryL,G1H12(26),wf4(:,7),G1H3(42),m3h4x3(:,34),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H3(42),19,nMB,G2H3(17),n2h3(96))
  call Hloop_QV_A(ntryL,G1H12(27),wf4(:,7),G1H3(25),m3h4x3(:,35),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G1H3(25),19,0,G2H3(44),n2h3(97))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,7),G1H3(58),m3h4x3(:,36),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H3(58),19,nMB,G2H3(6),n2h3(98))
  call Hloop_AQ_V(ntryL,G1H12(7),wf2(:,2),G1H6(25),m3h2x6(:,24),heltab2x12(:,:,72))
  call Hloop_VQ_A(ntryL,G1H12(9),wf2(:,2),G1H6(5),m3h2x6(:,25),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H6(5),21,nMB,G2H6(5),n2h6(37))
  call Hloop_VQ_A(ntryL,G0H6(1),wf2(:,2),G0H3(6),m3h2x3(:,33),heltab2x6(:,:,95))
  call Hloop_Q_A(ntryL,G0H3(6),23,nMB,G1H3(8),n2h3(99))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,9),G1H3(38),m3h4x3(:,37),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G1H3(38),23,0,G2H3(19),n2h3(100))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,9),G1H3(51),m3h4x3(:,38),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(51),23,nMT,G2H3(18),n2h3(101))
  call Hloop_QV_A(ntryL,G1H12(11),wf4(:,9),G1H3(14),m3h4x3(:,39),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H3(14),23,0,G2H3(41),n2h3(102))
  call Hloop_QV_A(ntryL,G1H12(12),wf4(:,9),G1H3(33),m3h4x3(:,40),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H3(33),23,nMT,G2H3(3),n2h3(103))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,9),G1H3(15),m3h4x3(:,41),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(15),23,0,G2H3(20),n2h3(104))
  call Hloop_AV_Q(ntryL,G1H12(13),wf4(:,9),G1H3(21),m3h4x3(:,42),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H3(21),23,nMB,G2H3(23),n2h3(105))
  call Hloop_QV_A(ntryL,G1H12(14),wf4(:,9),G1H3(39),m3h4x3(:,43),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(39),23,0,G2H3(14),n2h3(106))
  call Hloop_QV_A(ntryL,G1H12(16),wf4(:,9),G1H3(46),m3h4x3(:,44),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(46),23,nMB,G2H3(1),n2h3(107))
  call Hloop_QA_V(ntryL,G1H12(17),ex2(:),G1H6(30),m3h2x6(:,26),heltab2x12(:,:,82))
  call Hloop_VA_Q(ntryL,G1H12(18),ex2(:),G1H6(7),m3h2x6(:,27),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(7),18,nMB,G2H6(3),n2h6(38))
  call Hloop_VA_Q(ntryL,G0H6(7),ex2(:),G0H3(7),m3h2x3(:,34),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G0H3(7),23,nMB,G1H3(49),n2h3(108))
  call Hloop_QA_V(ntryL,G1H12(19),wf2(:,4),G1H6(2),m3h2x6(:,28),heltab2x12(:,:,84))
  call Hloop_VA_Q(ntryL,G1H12(4),wf2(:,4),G1H6(12),m3h2x6(:,29),heltab2x12(:,:,85))
  call Hloop_A_Q(ntryL,G1H6(12),22,nMB,G2H6(4),n2h6(39))
  call Hloop_VA_Q(ntryL,G0H6(3),wf2(:,4),G0H3(9),m3h2x3(:,35),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G0H3(9),23,nMB,G1H3(3),n2h3(109))
  call Hloop_AV_Q(ntryL,G1H12(21),wf4(:,10),G1H3(9),m3h4x3(:,45),heltab2x12(:,:,86))
  call Hloop_A_Q(ntryL,G1H3(9),23,0,G2H3(24),n2h3(110))
  call Hloop_AV_Q(ntryL,G1H12(28),wf4(:,10),G1H3(20),m3h4x3(:,46),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H3(20),23,nMT,G2H3(29),n2h3(111))
  call Hloop_QV_A(ntryL,G1H12(29),wf4(:,10),G1H3(71),m3h4x3(:,47),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(71),23,0,G2H3(30),n2h3(112))
  call Hloop_QV_A(ntryL,G1H12(30),wf4(:,10),G1H3(35),m3h4x3(:,48),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G1H3(35),23,nMT,G2H3(32),n2h3(113))
  call Hloop_AV_Q(ntryL,G1H12(31),wf4(:,10),G1H3(72),m3h4x3(:,49),heltab2x12(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(72),23,0,G2H3(33),n2h3(114))
  call Hloop_AV_Q(ntryL,G1H12(32),wf4(:,10),G1H3(75),m3h4x3(:,50),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(75),23,nMB,G2H3(35),n2h3(115))
  call Hloop_QV_A(ntryL,G1H12(33),wf4(:,10),G1H3(44),m3h4x3(:,51),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(44),23,0,G2H3(36),n2h3(116))
  call Hloop_QV_A(ntryL,G1H12(34),wf4(:,10),G1H3(45),m3h4x3(:,52),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H3(45),23,nMB,G2H3(38),n2h3(117))
  call Hloop_AQ_V(ntryL,G1H12(35),ex1(:),G1H6(32),m3h2x6(:,30),heltab2x12(:,:,94))
  call Hloop_VQ_A(ntryL,G1H12(36),ex1(:),G1H6(19),m3h2x6(:,31),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H6(19),17,nMB,G2H6(8),n2h6(40))
  call Hloop_VQ_A(ntryL,G0H6(8),ex1(:),G0H3(8),m3h2x3(:,36),heltab2x6(:,:,98))
  call Hloop_Q_A(ntryL,G0H3(8),23,nMB,G1H3(78),n2h3(118))
  call Hloop_QS_A(ntryL,G1H12(37),ex3(:),G1H12(8),ngH,m3h1x12(:,9),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H12(8),20,nMT,G2H12(5),n2h12(81))
  call Hloop_AS_Q(ntryL,G1H12(38),ex3(:),G1H12(3),ngH,m3h1x12(:,10),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G1H12(3),20,nMT,G2H12(6),n2h12(82))
  call Hloop_QS_A(ntryL,G1H12(39),ex3(:),G1H12(15),ngH,m3h1x12(:,11),heltab2x12(:,:,98))
  call Hloop_Q_A(ntryL,G1H12(15),20,nMB,G2H12(1),n2h12(83))
  call Hloop_AS_Q(ntryL,G1H12(40),ex3(:),G1H12(20),ngH,m3h1x12(:,12),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H12(20),20,nMB,G2H12(2),n2h12(84))
  call Hloop_QA_V(ntryL,G1H12(41),ex2(:),G1H6(33),m3h2x6(:,32),heltab2x12(:,:,100))
  call Hloop_VA_Q(ntryL,G1H12(42),ex2(:),G1H6(9),m3h2x6(:,33),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H6(9),18,nMB,G2H6(9),n2h6(41))
  call Hloop_VA_Q(ntryL,G0H2(3),ex2(:),G0H1(1),m3h2x1(:,30),heltab2x2(:,:,46))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(12),n2h1(189))
  call Hloop_QS_A(ntryL,G1H12(43),ex3(:),G1H12(22),ngH,m3h1x12(:,13),heltab2x12(:,:,102))
  call Hloop_Q_A(ntryL,G1H12(22),20,nMT,G2H12(3),n2h12(85))
  call Hloop_AS_Q(ntryL,G1H12(44),ex3(:),G1H12(23),ngH,m3h1x12(:,14),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G1H12(23),20,nMT,G2H12(4),n2h12(86))
  call Hloop_QS_A(ntryL,G1H12(45),ex3(:),G1H12(5),ngH,m3h1x12(:,15),heltab2x12(:,:,104))
  call Hloop_Q_A(ntryL,G1H12(5),20,nMB,G2H12(7),n2h12(87))
  call Hloop_AS_Q(ntryL,G1H12(46),ex3(:),G1H12(24),ngH,m3h1x12(:,16),heltab2x12(:,:,105))
  call Hloop_A_Q(ntryL,G1H12(24),20,nMB,G2H12(8),n2h12(88))
  call Hloop_AQ_V(ntryL,G1H12(47),ex1(:),G1H6(15),m3h2x6(:,34),heltab2x12(:,:,106))
  call Hloop_VQ_A(ntryL,G1H12(48),ex1(:),G1H6(16),m3h2x6(:,35),heltab2x12(:,:,107))
  call Hloop_Q_A(ntryL,G1H6(16),17,nMB,G2H6(10),n2h6(42))
  call Hloop_VQ_A(ntryL,G0H2(4),ex1(:),G0H1(1),m3h2x1(:,31),heltab2x2(:,:,47))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(35),n2h1(190))
  call Hloop_VA_Q(ntryL,G0H6(5),ex2(:),G0H3(2),m3h2x3(:,37),heltab2x6(:,:,99))
  call Hloop_A_Q(ntryL,G0H3(2),19,nMB,G1H3(79),n2h3(119))
  call Hloop_VQ_A(ntryL,G0H6(6),ex1(:),G0H3(3),m3h2x3(:,38),heltab2x6(:,:,100))
  call Hloop_Q_A(ntryL,G0H3(3),19,nMB,G1H3(80),n2h3(120))
  call Hloop_QA_V(ntryL,G1H12(49),ex2(:),G1H6(34),m3h2x6(:,36),heltab2x12(:,:,108))
  call Hloop_VA_Q(ntryL,G1H12(50),ex2(:),G1H6(35),m3h2x6(:,37),heltab2x12(:,:,109))
  call Hloop_A_Q(ntryL,G1H6(35),18,nMB,G2H6(11),n2h6(43))
  call Hloop_AQ_V(ntryL,G1H12(51),ex1(:),G1H6(6),m3h2x6(:,38),heltab2x12(:,:,110))
  call Hloop_VQ_A(ntryL,G1H12(52),ex1(:),G1H6(8),m3h2x6(:,39),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H6(8),17,nMB,G2H6(12),n2h6(44))
  call ol_merge(ntryL,G2H2(8),[G2H2(27),G2H2(24),G2H2(4),G2H2(6)])
  call ol_merge(ntryL,G2H2(36),[G2H2(21),G2H2(18),G2H2(14),G2H2(9)])
  call ol_merge(ntryL,G1H3(8),[G1H3(34),G1H3(67)])
call HGT_w2_OLR(G1H3(68),1,1,3)
call HGT_w2_invQ_OLR(G1H3(68),2,5,3)
  call ol_merge(ntryL,G1H3(68),[G1H3(8)])
  call ol_merge(ntryL,G1H1(37),[G1H1(7)])
call HGT_w2_OLR(G1H1(16),1,1,1)
call HGT_w2_invQ_OLR(G1H1(16),2,5,1)
  call ol_merge(ntryL,G1H1(16),[G1H1(37)])
call HGT_OLR(G2H1(9),1,1,1)
call HGT_invQ_OLR(G2H1(9),2,5,1)
call HGT_OLR(G2H1(9),6,15,1)
  call ol_merge(ntryL,G2H1(9),[G1H1(19)])
  call ol_merge(ntryL,G2H3(38),[G2H3(1),G2H3(40),G2H3(7),G1H3(74),G1H3(70),G1H3(24),G1H3(32)])
  call ol_merge(ntryL,G2H3(42),[G1H3(27),G1H3(23)])
call HGT_OLR(G2H3(21),1,1,3)
call HGT_invQ_OLR(G2H3(21),2,5,3)
call HGT_OLR(G2H3(21),6,15,3)
  call ol_merge(ntryL,G2H3(21),[G2H3(42)])
  call ol_merge(ntryL,G2H1(11),[G1H1(40),G1H1(13)])
call HGT_OLR(G2H1(13),1,1,1)
call HGT_invQ_OLR(G2H1(13),2,5,1)
call HGT_OLR(G2H1(13),6,15,1)
  call ol_merge(ntryL,G2H1(13),[G1H1(27)])
  call ol_merge(ntryL,G2H3(35),[G2H3(23),G2H3(43),G2H3(22),G1H3(82),G1H3(56),G1H3(40),G1H3(53)])
  call ol_merge(ntryL,G2H3(9),[G1H3(7),G1H3(63)])
call HGT_OLR(G2H3(25),1,1,3)
call HGT_invQ_OLR(G2H3(25),2,5,3)
call HGT_OLR(G2H3(25),6,15,3)
  call ol_merge(ntryL,G2H3(25),[G2H3(9)])
  call ol_merge(ntryL,G2H1(15),[G1H1(49),G1H1(32)])
  call ol_merge(ntryL,G2H3(2),[G1H3(4),G1H3(28)])
call HGT_w2_OLR(G1H3(41),1,1,3)
call HGT_w2_invQ_OLR(G1H3(41),2,5,3)
  call ol_merge(ntryL,G2H3(2),[G1H3(41)])
  call ol_merge(ntryL,G2H1(6),[G1H1(3),G1H1(36)])
call HGT_w2_OLR(G1H1(11),1,1,1)
call HGT_w2_invQ_OLR(G1H1(11),2,5,1)
  call ol_merge(ntryL,G2H1(6),[G1H1(11)])
  call ol_merge(ntryL,G2H3(12),[G1H3(100)])
call HGT_OLR(G2H3(26),1,1,3)
call HGT_invQ_OLR(G2H3(26),2,5,3)
call HGT_OLR(G2H3(26),6,15,3)
  call ol_merge(ntryL,G2H3(26),[G2H3(12)])
  call ol_merge(ntryL,G2H1(18),[G1H1(15)])
  call ol_merge(ntryL,G2H3(16),[G1H3(104)])
call HGT_OLR(G2H3(27),1,1,3)
call HGT_invQ_OLR(G2H3(27),2,5,3)
call HGT_OLR(G2H3(27),6,15,3)
  call ol_merge(ntryL,G2H3(27),[G2H3(16)])
  call ol_merge(ntryL,G2H1(21),[G1H1(54)])
  call ol_merge(ntryL,G2H3(29),[G2H3(18),G2H3(37),G2H3(28),G1H3(105),G1H3(93)])
  call ol_merge(ntryL,G2H3(32),[G2H3(3),G2H3(34),G2H3(31),G1H3(101),G1H3(97)])
  call ol_merge(ntryL,G1H3(49),[G1H3(50),G1H3(26)])
call HGT_w2_OLR(G1H3(59),1,1,3)
call HGT_w2_invQ_OLR(G1H3(59),2,5,3)
  call ol_merge(ntryL,G1H3(59),[G1H3(49)])
  call ol_merge(ntryL,G1H3(78),[G1H3(73),G1H3(16)])
call HGT_w2_OLR(G1H3(61),1,1,3)
call HGT_w2_invQ_OLR(G1H3(61),2,5,3)
  call ol_merge(ntryL,G1H3(61),[G1H3(78)])
  call ol_merge(ntryL,G1H1(12),[G1H1(26)])
call HGT_w2_OLR(G1H1(5),1,1,1)
call HGT_w2_invQ_OLR(G1H1(5),2,5,1)
  call ol_merge(ntryL,G1H1(5),[G1H1(12)])
  call ol_merge(ntryL,G2H6(4),[G2H6(6)])
  call ol_merge(ntryL,G1H1(35),[G1H1(8)])
call HGT_w2_OLR(G1H1(10),1,1,1)
call HGT_w2_invQ_OLR(G1H1(10),2,5,1)
  call ol_merge(ntryL,G1H1(10),[G1H1(35)])
  call ol_merge(ntryL,G2H6(5),[G2H6(7)])
  call ol_merge(ntryL,G1H3(80),[G1H3(89)])
call HGT_w2_OLR(G1H3(13),1,1,3)
call HGT_w2_invQ_OLR(G1H3(13),2,5,3)
  call ol_merge(ntryL,G1H3(13),[G1H3(80)])
  call ol_merge(ntryL,G1H3(3),[G1H3(77),G1H3(29)])
  call ol_merge(ntryL,G1H1(44),[G1H1(31)])
  call ol_merge(ntryL,G2H3(5),[G1H3(81),G1H3(76)])
  call ol_merge(ntryL,G2H1(5),[G1H1(48),G1H1(43)])
  call ol_merge(ntryL,G1H6(2),[G1H6(26)])
  call ol_merge(ntryL,G1H6(25),[G1H6(10)])
  call ol_merge(ntryL,G1H3(79),[G1H3(84)])
  call ol_merge(ntryL,G2H3(17),[G1H3(85)])
  call ol_merge(ntryL,G2H3(6),[G1H3(90)])
  call ol_merge(ntryL,G2H1(4),[G1H1(23)])
  call ol_merge(ntryL,G2H1(14),[G1H1(53)])
  call ol_merge(ntryL,G2H3(8),[G1H3(92)])
  call ol_merge(ntryL,G2H3(10),[G1H3(96)])
  call ol_merge(ntryL,G2H3(24),[G2H3(19)])
  call ol_merge(ntryL,G2H3(30),[G2H3(41)])
  call ol_merge(ntryL,G2H3(33),[G2H3(20)])
  call ol_merge(ntryL,G2H3(36),[G2H3(14)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(2),m3h2x1(:,32),heltab2x2(:,:,48))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex2(:),G2tensor(4),m3h2x1(:,33),heltab2x2(:,:,49))
  call Hloop_QZ_A(ntryL,G1H3(68),ex4(:),G1H1(6),ngZd,m3h3x1(:,130),heltab2x3(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(6),n2h1(191))
  call Hloop_QS_A(ntryL,G1H1(16),ex3(:),G1H1(38),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),31,nMB,G2tensor(7),n2h1(192))
  call Hloop_QS_A(ntryL,G2H1(9),ex3(:),G2H1(16),ngH,m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nMB,G3tensor(13),n2h1(193))
  call Hloop_QZ_A(ntryL,G2H3(38),ex4(:),G2H1(8),ngZd,m3h3x1(:,131),heltab2x3(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),31,nMB,G3tensor(14),n2h1(194))
  call Hloop_QZ_A(ntryL,G2H3(21),ex4(:),G2H1(17),ngZd,m3h3x1(:,132),heltab2x3(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,nMB,G3tensor(15),n2h1(195))
  call Hloop_QS_A(ntryL,G2H1(11),ex3(:),G2H1(19),ngH,m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(19),31,nMB,G3tensor(16),n2h1(196))
  call Hloop_AS_Q(ntryL,G2H1(13),ex3(:),G2H1(2),ngH,m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMB,G3tensor(17),n2h1(197))
  call Hloop_AZ_Q(ntryL,G2H3(35),ex4(:),G2H1(20),ngZd,m3h3x1(:,133),heltab2x3(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),31,nMB,G3tensor(18),n2h1(198))
  call Hloop_AZ_Q(ntryL,G2H3(25),ex4(:),G2H1(22),ngZd,m3h3x1(:,134),heltab2x3(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),31,nMB,G3tensor(19),n2h1(199))
  call Hloop_AS_Q(ntryL,G2H1(15),ex3(:),G2H1(3),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),31,nMB,G3tensor(20),n2h1(200))
  call Hloop_QZ_A(ntryL,G2H3(2),ex4(:),G2H1(7),ngZd,m3h3x1(:,135),heltab2x3(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(21),n2h1(201))
  call Hloop_QS_A(ntryL,G2H1(6),ex3(:),G2H1(1),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(22),n2h1(202))
  call Hloop_QZ_A(ntryL,G2H3(26),ex4(:),G2H1(10),ngZu,m3h3x1(:,136),heltab2x3(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(23),n2h1(203))
  call Hloop_QS_A(ntryL,G2H1(18),ex3(:),G2H1(12),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(24),n2h1(204))
  call Hloop_AZ_Q(ntryL,G2H3(27),ex4(:),G2H1(9),ngZu,m3h3x1(:,137),heltab2x3(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(9),31,nMT,G3tensor(25),n2h1(205))
  call Hloop_AS_Q(ntryL,G2H1(21),ex3(:),G2H1(16),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),31,nMT,G3tensor(26),n2h1(206))
call HGT_OLR(G2H1(23),1,1,1)
call HGT_invQ_OLR(G2H1(23),2,5,1)
call HGT_OLR(G2H1(23),6,15,1)
  call Hloop_AS_Q(ntryL,G2H1(23),ex3(:),G2H1(8),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,nMT,G3tensor(27),n2h1(207))
  call Hloop_AZ_Q(ntryL,G2H3(29),ex4(:),G2H1(17),ngZu,m3h3x1(:,138),heltab2x3(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),31,nMT,G3tensor(28),n2h1(208))
call HGT_OLR(G2H1(24),1,1,1)
call HGT_invQ_OLR(G2H1(24),2,5,1)
call HGT_OLR(G2H1(24),6,15,1)
  call Hloop_QS_A(ntryL,G2H1(24),ex3(:),G2H1(11),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),31,nMT,G3tensor(29),n2h1(209))
  call Hloop_QZ_A(ntryL,G2H3(32),ex4(:),G2H1(19),ngZu,m3h3x1(:,139),heltab2x3(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(19),31,nMT,G3tensor(30),n2h1(210))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,7),G2H1(13),m3h4x1(:,1),heltab2x4(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,nMT,G3tensor(31),n2h1(211))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,7),G2H1(2),m3h4x1(:,2),heltab2x4(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMT,G3tensor(32),n2h1(212))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,7),G2H1(20),m3h4x1(:,3),heltab2x4(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),31,nMB,G3tensor(33),n2h1(213))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,7),G2H1(22),m3h4x1(:,4),heltab2x4(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),31,nMB,G3tensor(34),n2h1(214))
  call Hloop_AZ_Q(ntryL,G1H3(59),ex4(:),G1H1(22),ngZd,m3h3x1(:,140),heltab2x3(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(10),n2h1(215))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),wf2(:,2),G2tensor(19),m3h2x1(:,34),heltab2x2(:,:,50))
  call Hloop_QZ_A(ntryL,G1H3(61),ex4(:),G1H1(17),ngZd,m3h3x1(:,141),heltab2x3(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(11),n2h1(216))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),wf2(:,4),G2tensor(14),m3h2x1(:,35),heltab2x2(:,:,51))
  call Hloop_AS_Q(ntryL,G1H1(5),ex3(:),G1H1(25),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(15),n2h1(217))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(4),wf6(:,5),G2tensor(18),m3h6x1(:,15),heltab2x6(:,:,101))
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(4),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,nMB,G2tensor(22),n2h1(218))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(5),wf6(:,2),G2tensor(27),m3h6x1(:,16),heltab2x6(:,:,102))
  call Hloop_QZ_A(ntryL,G1H3(13),wf3(:,2),G1H1(51),ngZd,m3h3x1(:,142),heltab2x3(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(51),31,nMB,G2tensor(23),n2h1(219))
  call Hloop_VA_Q(ntryL,G1H2(9),ex2(:),G1H1(14),m3h2x1(:,36),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(26),n2h1(220))
  call Hloop_VA_Q(ntryL,G1H2(13),ex2(:),G1H1(20),m3h2x1(:,37),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(68),n2h1(221))
  call Hloop_VQ_A(ntryL,G1H2(11),ex1(:),G1H1(18),m3h2x1(:,38),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(110),n2h1(222))
  call Hloop_VQ_A(ntryL,G1H2(16),ex1(:),G1H1(52),m3h2x1(:,39),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(52),31,nMB,G2tensor(116),n2h1(223))
  call Hloop_AZ_Q(ntryL,G1H3(3),ex4(:),G1H1(42),ngZd,m3h3x1(:,143),heltab2x3(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(43),n2h1(224))
  call Hloop_AS_Q(ntryL,G1H1(44),ex3(:),G1H1(55),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(55),31,nMB,G2tensor(44),n2h1(225))
  call Hloop_AZ_Q(ntryL,G2H3(5),ex4(:),G2H1(15),ngZd,m3h3x1(:,144),heltab2x3(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMB,G3tensor(35),n2h1(226))
  call Hloop_AS_Q(ntryL,G2H1(5),ex3(:),G2H1(3),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),31,nMB,G3tensor(36),n2h1(227))
  call Hloop_VQ_A(ntryL,G1H6(14),wf6(:,5),G1H1(29),m3h6x1(:,17),heltab2x6(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),31,nMB,G2tensor(49),n2h1(228))
  call Hloop_VQ_A(ntryL,G1H6(2),wf6(:,5),G1H1(45),m3h6x1(:,18),heltab2x6(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),31,nMB,G2tensor(51),n2h1(229))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,2),G1H1(21),m3h6x1(:,19),heltab2x6(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(53),n2h1(230))
  call Hloop_VA_Q(ntryL,G1H6(25),wf6(:,2),G1H1(46),m3h6x1(:,20),heltab2x6(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(46),31,nMB,G2tensor(55),n2h1(231))
  call Hloop_AZ_Q(ntryL,G1H3(79),wf3(:,2),G1H1(30),ngZd,m3h3x1(:,145),heltab2x3(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nMB,G2tensor(143),n2h1(232))
  call Hloop_AZ_Q(ntryL,G2H3(17),wf3(:,2),G2H1(7),ngZd,m3h3x1(:,146),heltab2x3(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(37),n2h1(233))
  call Hloop_QZ_A(ntryL,G2H3(6),wf3(:,2),G2H1(6),ngZd,m3h3x1(:,147),heltab2x3(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(6),31,nMB,G3tensor(38),n2h1(234))
  call Hloop_QS_A(ntryL,G2H1(4),ex3(:),G2H1(1),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(39),n2h1(235))
  call Hloop_AS_Q(ntryL,G2H1(14),ex3(:),G2H1(10),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(40),n2h1(236))
  call Hloop_AZ_Q(ntryL,G2H3(8),ex4(:),G2H1(18),ngZu,m3h3x1(:,148),heltab2x3(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nMT,G3tensor(41),n2h1(237))
  call Hloop_QZ_A(ntryL,G2H3(10),ex4(:),G2H1(12),ngZu,m3h3x1(:,149),heltab2x3(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(42),n2h1(238))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(149),m3h2x1(:,40),heltab2x2(:,:,56))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(155),m3h2x1(:,41),heltab2x2(:,:,57))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),wf2(:,2),G2tensor(63),m3h2x1(:,42),heltab2x2(:,:,58))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),wf2(:,4),G2tensor(59),m3h2x1(:,43),heltab2x2(:,:,59))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,5),G2tensor(65),m3h6x1(:,21),heltab2x6(:,:,107))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(1),wf6(:,2),G2tensor(134),m3h6x1(:,22),heltab2x6(:,:,108))
  call Hloop_AZ_Q(ntryL,G2H3(39),wf3(:,2),G2H1(9),ngZu,m3h3x1(:,150),heltab2x3(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(9),31,0,G3tensor(43),n2h1(239))
  call Hloop_AZ_Q(ntryL,G2H3(11),wf3(:,2),G2H1(21),ngZu,m3h3x1(:,151),heltab2x3(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(21),31,nMT,G3tensor(44),n2h1(240))
  call Hloop_QZ_A(ntryL,G2H3(4),wf3(:,2),G2H1(16),ngZu,m3h3x1(:,152),heltab2x3(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,0,G3tensor(45),n2h1(241))
  call Hloop_QZ_A(ntryL,G2H3(15),wf3(:,2),G2H1(23),ngZu,m3h3x1(:,153),heltab2x3(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMT,G3tensor(46),n2h1(242))
  call Hloop_AZ_Q(ntryL,G2H3(13),wf3(:,2),G2H1(8),ngZd,m3h3x1(:,154),heltab2x3(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,0,G3tensor(47),n2h1(243))
  call Hloop_QZ_A(ntryL,G2H3(44),wf3(:,2),G2H1(17),ngZd,m3h3x1(:,155),heltab2x3(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,0,G3tensor(48),n2h1(244))
  call Hloop_AZ_Q(ntryL,G2H3(24),ex4(:),G2H1(24),ngZu,m3h3x1(:,156),heltab2x3(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(24),31,0,G3tensor(49),n2h1(245))
  call Hloop_QZ_A(ntryL,G2H3(30),ex4(:),G2H1(11),ngZu,m3h3x1(:,157),heltab2x3(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),31,0,G3tensor(50),n2h1(246))
  call Hloop_AZ_Q(ntryL,G2H3(33),ex4(:),G2H1(19),ngZd,m3h3x1(:,158),heltab2x3(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(19),31,0,G3tensor(51),n2h1(247))
  call Hloop_QZ_A(ntryL,G2H3(36),ex4(:),G2H1(13),ngZd,m3h3x1(:,159),heltab2x3(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,0,G3tensor(52),n2h1(248))
  call Hloop_VQ_A(ntryL,G1H6(30),wf6(:,17),G1H1(47),m3h6x1(:,23),heltab2x6(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),31,nMB,G2tensor(71),n2h1(249))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(3),wf6(:,17),G2tensor(140),m3h6x1(:,24),heltab2x6(:,:,110))
  call Hloop_VA_Q(ntryL,G1H6(32),wf6(:,20),G1H1(24),m3h6x1(:,25),heltab2x6(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(77),n2h1(250))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(8),wf6(:,20),G2tensor(131),m3h6x1(:,26),heltab2x6(:,:,112))
  call Hloop_QV_A(ntryL,G2H12(5),wf12(:,5),G2H1(2),m3h12x1(:,1),heltab2x12(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(2),31,nMT,G3tensor(53),n2h1(251))
  call Hloop_AV_Q(ntryL,G2H12(6),wf12(:,5),G2H1(20),m3h12x1(:,2),heltab2x12(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),31,nMT,G3tensor(54),n2h1(252))
  call Hloop_QV_A(ntryL,G2H12(1),wf12(:,5),G2H1(22),m3h12x1(:,3),heltab2x12(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(22),31,nMB,G3tensor(55),n2h1(253))
  call Hloop_AV_Q(ntryL,G2H12(2),wf12(:,5),G2H1(15),m3h12x1(:,4),heltab2x12(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMB,G3tensor(56),n2h1(254))
  call Hloop_VQ_A(ntryL,G1H6(33),wf6(:,21),G1H1(50),m3h6x1(:,27),heltab2x6(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMB,G2tensor(83),n2h1(255))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(9),wf6(:,21),G2tensor(89),m3h6x1(:,28),heltab2x6(:,:,114))
  call Hloop_QV_A(ntryL,G2H12(3),wf12(:,6),G2H1(5),m3h12x1(:,5),heltab2x12(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(5),31,nMT,G3tensor(57),n2h1(256))
  call Hloop_AV_Q(ntryL,G2H12(4),wf12(:,6),G2H1(3),m3h12x1(:,6),heltab2x12(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(58),n2h1(257))
  call Hloop_QV_A(ntryL,G2H12(7),wf12(:,6),G2H1(7),m3h12x1(:,7),heltab2x12(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(59),n2h1(258))
  call Hloop_AV_Q(ntryL,G2H12(8),wf12(:,6),G2H1(6),m3h12x1(:,8),heltab2x12(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(6),31,nMB,G3tensor(60),n2h1(259))
  call Hloop_VA_Q(ntryL,G1H6(15),wf6(:,23),G1H1(33),m3h6x1(:,29),heltab2x6(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(33),31,nMB,G2tensor(137),n2h1(260))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(10),wf6(:,23),G2tensor(95),m3h6x1(:,30),heltab2x6(:,:,116))
  call Hloop_VQ_A(ntryL,G1H6(34),wf6(:,27),G1H1(9),m3h6x1(:,31),heltab2x6(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(101),n2h1(261))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(11),wf6(:,27),G2tensor(47),m3h6x1(:,32),heltab2x6(:,:,118))
  call Hloop_VA_Q(ntryL,G1H6(6),wf6(:,25),G1H1(28),m3h6x1(:,33),heltab2x6(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(41),n2h1(262))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(12),wf6(:,25),G2tensor(1),m3h6x1(:,34),heltab2x6(:,:,120))
  call ol_merge_tensors(G2tensor(135),[G2tensor(66),G2tensor(8),G1tensor(30),G1tensor(18),G0tensor(23),G0tensor(18)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(141),G2tensor(84),G2tensor(72),G2tensor(20),G2tensor(12),G1tensor(46),G1tensor(9) &
    ,G1tensor(3),G1tensor(42),G0tensor(48),G0tensor(39),G0tensor(33),G0tensor(28)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(132),G2tensor(78),G2tensor(16),G1tensor(93),G1tensor(88),G1tensor(17),G1tensor(8) &
    ,G0tensor(99),G0tensor(94),G0tensor(43),G0tensor(38)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(138),G2tensor(96),G2tensor(90),G2tensor(28),G2tensor(24),G1tensor(57),G1tensor(52) &
    ,G1tensor(45),G1tensor(20),G0tensor(63),G0tensor(58),G0tensor(53),G0tensor(19)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(106),G2tensor(103),G2tensor(13),G2tensor(3),G1tensor(85),G1tensor(77),G1tensor(65) &
    ,G1tensor(4),G0tensor(91),G0tensor(83),G0tensor(71),G0tensor(34)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(95),G2tensor(131),G2tensor(64),G2tensor(60),G2tensor(5),G1tensor(80),G1tensor(12) &
    ,G1tensor(25),G0tensor(86),G0tensor(16),G0tensor(11)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(102),G2tensor(9),G1tensor(62),G1tensor(44),G1tensor(7),G0tensor(68),G0tensor(29) &
    ,G0tensor(8)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(105),G2tensor(17),G1tensor(118),G1tensor(82),G1tensor(34),G1tensor(37) &
    ,G0tensor(124),G0tensor(88),G0tensor(49),G0tensor(13)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(99),G2tensor(97),G2tensor(21),G1tensor(147),G1tensor(60),G1tensor(32),G0tensor(153) &
    ,G0tensor(66),G0tensor(24)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(109),G2tensor(25),G1tensor(100),G1tensor(27),G0tensor(106),G0tensor(25)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(59),G3tensor(56),G3tensor(55),G3tensor(3),G3tensor(1),G2tensor(136),G2tensor(133) &
    ,G2tensor(82),G2tensor(70),G1tensor(105),G1tensor(23),G1tensor(38),G0tensor(111),G0tensor(46),G0tensor(26)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(37),G3tensor(6),G3tensor(5),G3tensor(4),G3tensor(2),G2tensor(130),G2tensor(124) &
    ,G2tensor(118),G2tensor(112),G1tensor(125),G1tensor(110),G1tensor(54),G1tensor(11),G0tensor(131),G0tensor(116),G0tensor(60) &
    ,G0tensor(35)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(83),G2tensor(71),G2tensor(142),G2tensor(88),G2tensor(76),G2tensor(32),G2tensor(29) &
    ,G1tensor(130),G1tensor(115),G1tensor(5),G0tensor(136),G0tensor(121),G0tensor(36)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(87),G2tensor(85),G2tensor(30),G1tensor(127),G1tensor(39),G1tensor(40),G0tensor(133) &
    ,G0tensor(51),G0tensor(44)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(115),G2tensor(31),G1tensor(120),G1tensor(22),G0tensor(126),G0tensor(45)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(127),G2tensor(121),G2tensor(35),G2tensor(33),G1tensor(145),G1tensor(135) &
    ,G1tensor(53),G0tensor(151),G0tensor(141),G0tensor(59)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(137),G2tensor(77),G2tensor(139),G2tensor(100),G2tensor(94),G2tensor(36) &
    ,G2tensor(34),G1tensor(150),G1tensor(140),G1tensor(55),G0tensor(156),G0tensor(146),G0tensor(61)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(37),G1tensor(70),G1tensor(13),G0tensor(76),G0tensor(9)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(38),G1tensor(75),G1tensor(19),G0tensor(81),G0tensor(10)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(39),G1tensor(90),G1tensor(43),G0tensor(96),G0tensor(14)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(40),G1tensor(95),G1tensor(6),G0tensor(101),G0tensor(15)])
  call ol_merge_tensors(G3tensor(46),[G3tensor(44),G3tensor(10),G3tensor(9),G3tensor(8),G3tensor(7),G2tensor(154),G2tensor(151) &
    ,G2tensor(148),G2tensor(145),G1tensor(194),G1tensor(189),G0tensor(176),G0tensor(171)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G3tensor(54),G3tensor(53),G3tensor(12),G3tensor(11),G2tensor(160),G2tensor(157) &
    ,G1tensor(199),G0tensor(181)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(89),G2tensor(140),G2tensor(62),G2tensor(58),G1tensor(184),G1tensor(179) &
    ,G0tensor(166),G0tensor(161)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(33),G2tensor(81),G2tensor(79),G2tensor(69),G2tensor(67),G1tensor(102),G1tensor(16) &
    ,G1tensor(24),G0tensor(108),G0tensor(41),G0tensor(21)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(73),G1tensor(112),G1tensor(21),G0tensor(118),G0tensor(31)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(91),G1tensor(137),G1tensor(50),G0tensor(143),G0tensor(56)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(108),G1tensor(97),G1tensor(36),G0tensor(103),G0tensor(20)])
  call ol_merge_tensors(G3tensor(17),[G3tensor(13),G2tensor(123),G2tensor(111),G1tensor(107),G1tensor(49),G1tensor(15) &
    ,G0tensor(113),G0tensor(55),G0tensor(30)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(114),G1tensor(117),G1tensor(10),G0tensor(123),G0tensor(40)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(15),G2tensor(129),G2tensor(117),G1tensor(122),G1tensor(103),G1tensor(59) &
    ,G1tensor(35),G0tensor(128),G0tensor(109),G0tensor(65),G0tensor(50)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(120),G1tensor(181),G1tensor(132),G1tensor(47),G0tensor(163),G0tensor(138) &
    ,G0tensor(54)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(126),G1tensor(176),G1tensor(142),G1tensor(98),G1tensor(58),G0tensor(158) &
    ,G0tensor(148),G0tensor(104),G0tensor(64)])
  call ol_merge_tensors(G3tensor(25),[G3tensor(23),G2tensor(147),G2tensor(144),G1tensor(197),G1tensor(186),G0tensor(179) &
    ,G0tensor(168)])



end subroutine vamp_1

end module ol_vamp_1_pphzj_bbxhzg_1_/**/REALKIND
