
! **********************************************************************
module ol_tables_storage_pphzj_ddxhzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(24,39)
integer(intkind2), save :: heltab2x1(2,1,32)
integer(intkind2), save :: heltab2x2(2,2,4)
integer(intkind2), save :: heltab2x3(2,3,116)
integer(intkind2), save :: heltab2x4(2,4,4)
integer(intkind2), save :: heltab2x6(2,6,15)
integer(intkind2), save :: heltab2x12(2,12,67)
integer(intkind2), save :: heltab2x24(2,24,39)


  ! number of helicity states for openloops recursion steps  
integer(intkind2), save :: m0h(39)
integer(intkind2), save :: m3h1x1(3,32)
integer(intkind2), save :: m3h2x1(3,4)
integer(intkind2), save :: m3h3x1(3,92)
integer(intkind2), save :: m3h4x1(3,4)
integer(intkind2), save :: m3h6x1(3,6)
integer(intkind2), save :: m3h12x1(3,8)
integer(intkind2), save :: m3h3x2(3,4)
integer(intkind2), save :: m3h1x3(3,24)
integer(intkind2), save :: m3h2x3(3,5)
integer(intkind2), save :: m3h4x3(3,36)
integer(intkind2), save :: m3h3x4(3,4)
integer(intkind2), save :: m3h2x6(3,7)
integer(intkind2), save :: m3h4x6(3,4)
integer(intkind2), save :: m3h1x12(3,12)
integer(intkind2), save :: m3h2x12(3,35)

integer(intkind2), save :: n2h1(135)
integer(intkind2), save :: n2h2(4)
integer(intkind2), save :: n2h3(68)
integer(intkind2), save :: n2h6(5)
integer(intkind2), save :: n2h12(48)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2
  
m3h1x1(1,:)=1
m3h1x1(2,:)=1
m3h1x1(3,:)=1
m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h3x1(1,:)=3
m3h3x1(2,:)=1
m3h3x1(3,:)=3
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h6x1(1,:)=6
m3h6x1(2,:)=1
m3h6x1(3,:)=6
m3h12x1(1,:)=12
m3h12x1(2,:)=1
m3h12x1(3,:)=12
m3h3x2(1,:)=3
m3h3x2(2,:)=2
m3h3x2(3,:)=6
m3h1x3(1,:)=1
m3h1x3(2,:)=3
m3h1x3(3,:)=3
m3h2x3(1,:)=2
m3h2x3(2,:)=3
m3h2x3(3,:)=6
m3h4x3(1,:)=4
m3h4x3(2,:)=3
m3h4x3(3,:)=12
m3h3x4(1,:)=3
m3h3x4(2,:)=4
m3h3x4(3,:)=12
m3h2x6(1,:)=2
m3h2x6(2,:)=6
m3h2x6(3,:)=12
m3h4x6(1,:)=4
m3h4x6(2,:)=6
m3h4x6(3,:)=24
m3h1x12(1,:)=1
m3h1x12(2,:)=12
m3h1x12(3,:)=12
m3h2x12(1,:)=2
m3h2x12(2,:)=12
m3h2x12(3,:)=24

n2h1(:)=1
n2h2(:)=2
n2h3(:)=3
n2h6(:)=6
n2h12(:)=12


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pphzj_ddxhzg_1_/**/REALKIND 

! **********************************************************************
module ol_tensor_sum_storage_pphzj_ddxhzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(22)
  type(hol), save :: G2H1(16)
  type(hol), save :: G1H2(1)
  type(hol), save :: G2H2(3)
  type(hol), save :: G0H3(8)
  type(hol), save :: G1H3(60)
  type(hol), save :: G2H3(30)
  type(hol), save :: G2H4(4)
  type(hol), save :: G0H6(2)
  type(hol), save :: G1H6(5)
  type(hol), save :: G2H6(2)
  type(hol), save :: G0H12(4)
  type(hol), save :: G1H12(24)
  type(hol), save :: G2H12(8)
  type(hol), save :: G0H24(1)
  type(hcl), save, dimension(126) :: G0tensor
  type(hcl), save, dimension(69) :: G1tensor
  type(hcl), save, dimension(56) :: G2tensor
  type(hcl), save, dimension(56) :: G3tensor



  ! Declarations for on-the-fly tensor reduction 
type (basis),      save :: RedBasis(17)
type (redset4),    save :: RedSet_4(6)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,3)
integer, save :: mass4set(0:3,3)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(3)
  integer, save :: momenta_14(3)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(4)
  integer, save :: momenta_31(4)
  integer, save :: momenta_32(4)
  integer, save :: momenta_33(4)
  integer, save :: momenta_34(4)
  integer, save :: momenta_35(4)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(4)
  integer, save :: masses2_10(4)
  integer, save :: masses2_11(4)



  type(hcl), save, dimension(65) :: T0sum
  type(hcl), save, dimension(18) :: T1sum


  contains
  
!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none
  
    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,22)
  call hol_allocation(4,15,4,1,G2H1,16)
  call hol_allocation(4,5,4,2,G1H2,1)
  call hol_allocation(4,15,4,2,G2H2,3)
  call hol_allocation(4,1,4,3,G0H3,8)
  call hol_allocation(4,5,4,3,G1H3,60)
  call hol_allocation(4,15,4,3,G2H3,30)
  call hol_allocation(4,15,4,4,G2H4,4)
  call hol_allocation(4,1,4,6,G0H6,2)
  call hol_allocation(4,5,4,6,G1H6,5)
  call hol_allocation(4,15,4,6,G2H6,2)
  call hol_allocation(4,1,4,12,G0H12,4)
  call hol_allocation(4,5,4,12,G1H12,24)
  call hol_allocation(4,15,4,12,G2H12,8)
  call hol_allocation(4,1,4,24,G0H24,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode
  
    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,22,dmode)
  call hol_deallocation(G2H1,16,dmode)
  call hol_deallocation(G1H2,1,dmode)
  call hol_deallocation(G2H2,3,dmode)
  call hol_deallocation(G0H3,8,dmode)
  call hol_deallocation(G1H3,60,dmode)
  call hol_deallocation(G2H3,30,dmode)
  call hol_deallocation(G2H4,4,dmode)
  call hol_deallocation(G0H6,2,dmode)
  call hol_deallocation(G1H6,5,dmode)
  call hol_deallocation(G2H6,2,dmode)
  call hol_deallocation(G0H12,4,dmode)
  call hol_deallocation(G1H12,24,dmode)
  call hol_deallocation(G2H12,8,dmode)
  call hol_deallocation(G0H24,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none
  
  call hcl_allocation(1,G0tensor, 126)
call hcl_allocation(5,G1tensor, 69)
call hcl_allocation(15,G2tensor, 56)
call hcl_allocation(35,G3tensor, 56)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode
  
  call hcl_deallocation(G0tensor, 126,dmode)
call hcl_deallocation(G1tensor, 69,dmode)
call hcl_deallocation(G2tensor, 56,dmode)
call hcl_deallocation(G3tensor, 56,dmode)

  call hcl_deallocation(T0sum,65,dmode)
call hcl_deallocation(T1sum,18,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none
  
  call hcl_allocation(1,T0sum,65)
call hcl_allocation(5,T1sum,18)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pphzj_ddxhzg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pphzj_ddxhzg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,65
    call init_hcl(T0sum(i))
  end do
  do i = 1,18
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(1)%cmp, 2)
  call scale_one_tsum(T0sum(2)%cmp, 2)
  call scale_one_tsum(T0sum(3)%cmp, 2)
  call scale_one_tsum(T0sum(4)%cmp, 2)
  call scale_one_tsum(T0sum(5)%cmp, 2)
  call scale_one_tsum(T0sum(6)%cmp, 2)
  call scale_one_tsum(T0sum(7)%cmp, 2)
  call scale_one_tsum(T0sum(8)%cmp, 2)
  call scale_one_tsum(T0sum(9)%cmp, 2)
  call scale_one_tsum(T0sum(10)%cmp, 2)
  call scale_one_tsum(T0sum(11)%cmp, 2)
  call scale_one_tsum(T0sum(12)%cmp, 2)
  call scale_one_tsum(T0sum(13)%cmp, 2)
  call scale_one_tsum(T0sum(14)%cmp, 2)
  call scale_one_tsum(T0sum(15)%cmp, 2)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T1sum(1)%cmp, 0)
  call scale_one_tsum(T1sum(2)%cmp, 0)
  call scale_one_tsum(T1sum(3)%cmp, 0)
  call scale_one_tsum(T1sum(4)%cmp, 0)
  call scale_one_tsum(T1sum(5)%cmp, 0)
  call scale_one_tsum(T1sum(6)%cmp, 0)
  call scale_one_tsum(T1sum(7)%cmp, 0)
  call scale_one_tsum(T1sum(8)%cmp, 0)
  call scale_one_tsum(T1sum(9)%cmp, 0)
  call scale_one_tsum(T1sum(10)%cmp, 0)
  call scale_one_tsum(T1sum(11)%cmp, 0)
  call scale_one_tsum(T1sum(12)%cmp, 0)
  call scale_one_tsum(T1sum(13)%cmp, 0)
  call scale_one_tsum(T1sum(14)%cmp, 0)
  call scale_one_tsum(T1sum(15)%cmp, 0)
  call scale_one_tsum(T1sum(16)%cmp, 0)
  call scale_one_tsum(T1sum(17)%cmp, 0)
  call scale_one_tsum(T1sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, -2)
  call scale_one_tsum(T0sum(44)%cmp, -2)
  call scale_one_tsum(T0sum(45)%cmp, -2)
  call scale_one_tsum(T0sum(46)%cmp, -2)
  call scale_one_tsum(T0sum(47)%cmp, -2)
  call scale_one_tsum(T0sum(48)%cmp, -2)
  call scale_one_tsum(T0sum(49)%cmp, -2)
  call scale_one_tsum(T0sum(50)%cmp, -2)
  call scale_one_tsum(T0sum(51)%cmp, -2)
  call scale_one_tsum(T0sum(52)%cmp, -2)
  call scale_one_tsum(T0sum(53)%cmp, -2)
  call scale_one_tsum(T0sum(54)%cmp, -2)
  call scale_one_tsum(T0sum(55)%cmp, -2)
  call scale_one_tsum(T0sum(56)%cmp, -2)
  call scale_one_tsum(T0sum(57)%cmp, -2)
  call scale_one_tsum(T0sum(58)%cmp, -2)
  call scale_one_tsum(T0sum(59)%cmp, -2)
  call scale_one_tsum(T0sum(60)%cmp, -2)
  call scale_one_tsum(T0sum(61)%cmp, -2)
  call scale_one_tsum(T0sum(62)%cmp, -2)
  call scale_one_tsum(T0sum(63)%cmp, -2)
  call scale_one_tsum(T0sum(64)%cmp, -2)
  call scale_one_tsum(T0sum(65)%cmp, -2)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 16, 15 ]
  momenta_3 = [ 17, 14 ]
  momenta_4 = [ 18, 13 ]
  momenta_5 = [ 19, 12 ]
  momenta_6 = [ 20, 11 ]
  momenta_7 = [ 23, 8 ]
  momenta_8 = [ 24, 7 ]
  momenta_9 = [ 27, 4 ]
  momenta_10 = [ 28, 3 ]
  momenta_11 = [ 29, 2 ]
  momenta_12 = [ 30, 1 ]
  momenta_13 = [ 16, 1, 14 ]
  momenta_14 = [ 16, 2, 13 ]
  momenta_15 = [ 16, 3, 12 ]
  momenta_16 = [ 16, 4, 11 ]
  momenta_17 = [ 16, 7, 8 ]
  momenta_18 = [ 16, 11, 4 ]
  momenta_19 = [ 16, 13, 2 ]
  momenta_20 = [ 17, 2, 12 ]
  momenta_21 = [ 17, 12, 2 ]
  momenta_22 = [ 18, 1, 12 ]
  momenta_23 = [ 19, 4, 8 ]
  momenta_24 = [ 19, 8, 4 ]
  momenta_25 = [ 20, 3, 8 ]
  momenta_26 = [ 24, 3, 4 ]
  momenta_27 = [ 24, 4, 3 ]
  momenta_28 = [ 28, 1, 2 ]
  momenta_29 = [ 28, 2, 1 ]
  momenta_30 = [ 16, 1, 2, 12 ]
  momenta_31 = [ 16, 1, 12, 2 ]
  momenta_32 = [ 16, 2, 1, 12 ]
  momenta_33 = [ 16, 3, 4, 8 ]
  momenta_34 = [ 16, 3, 8, 4 ]
  momenta_35 = [ 16, 4, 3, 8 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ nMT, nMT ]
  masses2_6 = [ 0, 0, 0 ]
  masses2_7 = [ nMB, nMB, nMB ]
  masses2_8 = [ nMT, nMT, nMT ]
  masses2_9 = [ 0, 0, 0, 0 ]
  masses2_10 = [ nMB, nMB, nMB, nMB ]
  masses2_11 = [ nMT, nMT, nMT, nMT ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_external_pphzj_ddxhzg_1, only: channel_number_pphzj_ddxhzg_1
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call channel_on(channel_number_pphzj_ddxhzg_1)
  call init_met(M2)



#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(2,0, momenta_34, masses2_11, T0sum(1), M2)
  call TI_call_OL(2,0, momenta_34, masses2_10, T0sum(2), M2)
  call TI_call_OL(2,0, momenta_33, masses2_11, T0sum(3), M2)
  call TI_call_OL(2,0, momenta_33, masses2_10, T0sum(4), M2)
  call TI_call_OL(2,0, momenta_35, masses2_11, T0sum(5), M2)
  call TI_call_OL(2,0, momenta_35, masses2_10, T0sum(6), M2)
  call TI_call_OL(0,0, momenta_31, masses2_9, T0sum(7), M2)
  call TI_call_OL(0,0, momenta_30, masses2_9, T0sum(8), M2)
  call TI_call_OL(0,0, momenta_32, masses2_9, T0sum(9), M2)
  call TI_call_OL(0,0, momenta_34, masses2_11, T0sum(10), M2)
  call TI_call_OL(0,0, momenta_34, masses2_10, T0sum(11), M2)
  call TI_call_OL(0,0, momenta_33, masses2_11, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_33, masses2_10, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_35, masses2_11, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_35, masses2_10, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_15, masses2_8, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_15, masses2_7, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_16, masses2_8, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_16, masses2_7, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_13, masses2_6, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_28, masses2_6, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_29, masses2_6, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_14, masses2_6, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_25, masses2_8, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_25, masses2_7, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_26, masses2_8, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_26, masses2_7, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_27, masses2_8, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_27, masses2_7, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_22, masses2_6, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_21, masses2_6, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_19, masses2_6, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_20, masses2_6, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_15, masses2_6, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_24, masses2_8, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_18, masses2_8, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_24, masses2_7, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_18, masses2_7, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_23, masses2_8, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_17, masses2_8, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_23, masses2_7, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_17, masses2_7, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_10, masses2_5, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_5, masses2_5, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_2, masses2_5, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_10, masses2_4, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_5, masses2_4, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_2, masses2_4, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_9, masses2_5, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_6, masses2_5, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_9, masses2_4, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_7, masses2_5, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_7, masses2_4, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_8, masses2_5, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_8, masses2_4, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(65), M2)

  call TI_call_OL(1,1, momenta_25, masses2_8, T1sum(1), M2)
  call TI_call_OL(1,1, momenta_24, masses2_8, T1sum(2), M2)
  call TI_call_OL(1,1, momenta_18, masses2_8, T1sum(3), M2)
  call TI_call_OL(1,1, momenta_15, masses2_8, T1sum(4), M2)
  call TI_call_OL(1,1, momenta_25, masses2_7, T1sum(5), M2)
  call TI_call_OL(1,1, momenta_24, masses2_7, T1sum(6), M2)
  call TI_call_OL(1,1, momenta_18, masses2_7, T1sum(7), M2)
  call TI_call_OL(1,1, momenta_15, masses2_7, T1sum(8), M2)
  call TI_call_OL(1,1, momenta_26, masses2_8, T1sum(9), M2)
  call TI_call_OL(1,1, momenta_23, masses2_8, T1sum(10), M2)
  call TI_call_OL(1,1, momenta_17, masses2_8, T1sum(11), M2)
  call TI_call_OL(1,1, momenta_26, masses2_7, T1sum(12), M2)
  call TI_call_OL(1,1, momenta_23, masses2_7, T1sum(13), M2)
  call TI_call_OL(1,1, momenta_17, masses2_7, T1sum(14), M2)
  call TI_call_OL(1,1, momenta_27, masses2_8, T1sum(15), M2)
  call TI_call_OL(1,1, momenta_16, masses2_8, T1sum(16), M2)
  call TI_call_OL(1,1, momenta_27, masses2_7, T1sum(17), M2)
  call TI_call_OL(1,1, momenta_16, masses2_7, T1sum(18), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)
  
#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pphzj_ddxhzg_1_/**/REALKIND
