
module ol_vamp_1_pphvv_ew_uxdhzwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_ew_uxdhzwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_ew_uxdhzwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_ew_uxdhzwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_ew_uxdhzwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphvv_ew_uxdhzwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_uxdhzwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMW,nMW,0,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMZ,nMZ,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(2),m3h3x12(:,2),heltab2x36(:,:,2))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMZ,nMZ,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,3),heltab2x36(:,:,3))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,4),heltab2x36(:,:,4))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMZ,nMZ,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(3),m3h3x12(:,5),heltab2x36(:,:,5))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,6),heltab2x36(:,:,6))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMW,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(4),m3h3x12(:,7),heltab2x36(:,:,7))
  Gcoeff(:)%j = (c(143)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,8),heltab2x36(:,:,8))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(4),m3h3x12(:,9),heltab2x36(:,:,9))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(5),m3h3x12(:,10),heltab2x36(:,:,10))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMW,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(6),m3h3x12(:,11),heltab2x36(:,:,11))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,12),heltab2x36(:,:,12))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(8),m3h3x12(:,13),heltab2x36(:,:,13))
  Gcoeff(:)%j = (c(76)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(6),m3h3x12(:,14),heltab2x36(:,:,14))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[16,2,1,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(7),m3h3x12(:,15),heltab2x36(:,:,15))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMW,nMW,0,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(8),m3h3x12(:,16),heltab2x36(:,:,16))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMZ,nMZ,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(9),m3h3x12(:,17),heltab2x36(:,:,17))
  Gcoeff(:)%j = (c(3)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMZ,nMZ,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,18),heltab2x36(:,:,18))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[16,4,2,1,8],[nMW,nMW,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(10),m3h3x12(:,19),heltab2x36(:,:,19))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[16,4,2,1,8],[nMZ,nMZ,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(10),m3h3x12(:,20),heltab2x36(:,:,20))
  Gcoeff(:)%j = (c(120)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(11),m3h3x12(:,21),heltab2x36(:,:,21))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMW,0,nMZ,nMH,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,22),heltab2x36(:,:,22))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,23),heltab2x36(:,:,23))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(11),m3h3x12(:,24),heltab2x36(:,:,24))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[16,2,1,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(12),m3h3x12(:,25),heltab2x36(:,:,25))
  Gcoeff(:)%j = (c(74)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,26),heltab2x36(:,:,26))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,27),heltab2x36(:,:,27))
  Gcoeff(:)%j = (c(76)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(13),m3h3x12(:,28),heltab2x36(:,:,28))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(14),m3h3x12(:,29),heltab2x36(:,:,29))
  Gcoeff(:)%j = (c(160)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,30),heltab2x36(:,:,30))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[16,1,2,4,8],[nMW,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,31),heltab2x36(:,:,31))
  Gcoeff(:)%j = (c(143)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[16,1,2,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,32),heltab2x36(:,:,32))
  Gcoeff(:)%j = (c(117)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[16,1,2,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(15),m3h3x12(:,33),heltab2x36(:,:,33))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[16,1,2,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(16),m3h3x12(:,34),heltab2x36(:,:,34))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[16,1,2,4,8],[nMW,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,35),heltab2x36(:,:,35))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[16,1,2,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,36),heltab2x36(:,:,36))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,37),heltab2x36(:,:,37))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[16,1,2,4,8],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(17),m3h3x12(:,38),heltab2x36(:,:,38))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(18),m3h3x12(:,39),heltab2x36(:,:,39))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[16,1,2,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,40),heltab2x36(:,:,40))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[16,1,2,8,4],[nMW,0,nMZ,nMH,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,41),heltab2x36(:,:,41))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[16,1,2,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,42),heltab2x36(:,:,42))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[16,1,2,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(19),m3h3x12(:,43),heltab2x36(:,:,43))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[16,1,2,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(20),m3h3x12(:,44),heltab2x36(:,:,44))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[16,1,2,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,45),heltab2x36(:,:,45))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[16,1,2,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,46),heltab2x36(:,:,46))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[16,1,2,8,4],[0,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(21),m3h3x12(:,47),heltab2x36(:,:,47))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[16,1,2,8,4],[nMZ,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(22),m3h3x12(:,48),heltab2x36(:,:,48))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[16,2,4,1,8],[0,nMZ,nMZ,0,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,49),heltab2x36(:,:,49))
  call Hloop_A_Q(ntryL,G0H12(27),16,0,G1H12(23),n2h12(1))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[16,2,8,1,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,50),heltab2x36(:,:,50))
  Gcoeff(:)%j = (c(118)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[16,2,8,1,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,51),heltab2x36(:,:,51))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[16,2,8,1,4],[nMW,0,0,nMZ,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(24),m3h3x12(:,52),heltab2x36(:,:,52))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[16,2,8,1,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(25),m3h3x12(:,53),heltab2x36(:,:,53))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[16,2,8,1,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(26),m3h3x12(:,54),heltab2x36(:,:,54))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[16,1,4,2,8],[0,nMZ,nMZ,0,0],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,55),heltab2x36(:,:,55))
  call Hloop_Q_A(ntryL,G0H12(29),16,0,G1H12(27),n2h12(2))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[16,1,8,2,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,56),heltab2x36(:,:,56))
  Gcoeff(:)%j = (c(118)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[16,1,8,2,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,57),heltab2x36(:,:,57))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[16,1,8,2,4],[nMW,0,0,nMZ,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(28),m3h3x12(:,58),heltab2x36(:,:,58))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[16,1,8,2,4],[0,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(29),m3h3x12(:,59),heltab2x36(:,:,59))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[16,1,8,2,4],[nMZ,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(30),m3h3x12(:,60),heltab2x36(:,:,60))
  call Hloop_ST_V(ntryL,G1H12(1),16,ex3(:),4,G2H12(1),m3h1x12(:,1),heltab2x12(:,:,1))
  call Hloop_ST_V(ntryL,G1H12(2),16,ex3(:),4,G2H12(2),m3h1x12(:,2),heltab2x12(:,:,2))
  call Hloop_VS_V(ntryL,G0H12(1),ex3(:),G0H12(31),m3h1x12(:,3),heltab2x12(:,:,3))
  call Hloop_VS_V(ntryL,G0H12(2),ex3(:),G0H12(1),m3h1x12(:,4),heltab2x12(:,:,4))
  call Hloop_VS_V(ntryL,G1H12(3),ex3(:),G1H12(1),m3h1x12(:,5),heltab2x12(:,:,5))
  call Hloop_VQ_A(ntryL,G0H12(3),ex2(:),G0H6(1),m3h2x6(:,1),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(1),n2h6(1))
  call Hloop_WQ_A(ntryL,G0H12(4),ex2(:),G0H6(1),m3h2x6(:,2),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(2),n2h6(2))
  call Hloop_ZQ_A(ntryL,G0H12(5),ex2(:),G0H6(1),ngZd,m3h2x6(:,3),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(3),n2h6(3))
  call Hloop_VQ_A(ntryL,G1H12(4),ex2(:),G1H6(4),m3h2x6(:,4),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(4),18,0,G2H6(1),n2h6(4))
  call Hloop_ZQ_A(ntryL,G1H12(5),ex2(:),G1H6(4),ngZd,m3h2x6(:,5),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(4),18,0,G2H6(2),n2h6(5))
  call Hloop_WQ_A(ntryL,G0H12(6),ex2(:),G0H6(1),m3h2x6(:,6),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(4),n2h6(6))
  call Hloop_VQ_A(ntryL,G0H12(7),ex2(:),G0H6(1),m3h2x6(:,7),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(5),n2h6(7))
  call Hloop_ZQ_A(ntryL,G0H12(8),ex2(:),G0H6(1),ngZd,m3h2x6(:,8),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(6),n2h6(8))
  call Hloop_VQ_A(ntryL,G1H12(6),ex2(:),G1H6(7),m3h2x6(:,9),heltab2x12(:,:,14))
  call Hloop_Q_A(ntryL,G1H6(7),18,0,G2H6(3),n2h6(9))
  call Hloop_ZQ_A(ntryL,G1H12(7),ex2(:),G1H6(7),ngZd,m3h2x6(:,10),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H6(7),18,0,G2H6(4),n2h6(10))
  call Hloop_ST_V(ntryL,G1H12(8),16,ex3(:),4,G2H12(3),m3h1x12(:,6),heltab2x12(:,:,16))
  call Hloop_ST_V(ntryL,G1H12(9),16,ex3(:),4,G2H12(4),m3h1x12(:,7),heltab2x12(:,:,17))
  call Hloop_VS_V(ntryL,G0H12(9),ex3(:),G0H12(2),m3h1x12(:,8),heltab2x12(:,:,18))
  call Hloop_VS_V(ntryL,G0H12(10),ex3(:),G0H12(3),m3h1x12(:,9),heltab2x12(:,:,19))
  call Hloop_VS_V(ntryL,G1H12(10),ex3(:),G1H12(2),m3h1x12(:,10),heltab2x12(:,:,20))
  call Hloop_VQ_A(ntryL,G0H12(11),ex2(:),G0H6(1),m3h2x6(:,11),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(7),n2h6(11))
  call Hloop_WQ_A(ntryL,G0H12(12),ex2(:),G0H6(1),m3h2x6(:,12),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(8),n2h6(12))
  call Hloop_ZQ_A(ntryL,G0H12(13),ex2(:),G0H6(1),ngZd,m3h2x6(:,13),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(9),n2h6(13))
  call Hloop_VQ_A(ntryL,G1H12(11),ex2(:),G1H6(10),m3h2x6(:,14),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(10),18,0,G2H6(5),n2h6(14))
  call Hloop_ZQ_A(ntryL,G1H12(12),ex2(:),G1H6(10),ngZd,m3h2x6(:,15),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(10),18,0,G2H6(6),n2h6(15))
  call Hloop_VQ_A(ntryL,G0H12(14),ex2(:),G0H6(1),m3h2x6(:,16),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(10),n2h6(16))
  call Hloop_ZQ_A(ntryL,G0H12(15),ex2(:),G0H6(1),ngZd,m3h2x6(:,17),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(11),n2h6(17))
  call Hloop_VQ_A(ntryL,G1H12(13),ex2(:),G1H6(12),m3h2x6(:,18),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H6(12),18,0,G2H6(7),n2h6(18))
  call Hloop_ZQ_A(ntryL,G1H12(14),ex2(:),G1H6(12),ngZd,m3h2x6(:,19),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(12),18,0,G2H6(8),n2h6(19))
  call Hloop_VA_Q(ntryL,G0H12(16),ex1(:),G0H6(1),m3h2x6(:,20),heltab2x12(:,:,30))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(12),n2h6(20))
  call Hloop_WA_Q(ntryL,G0H12(17),ex1(:),G0H6(1),m3h2x6(:,21),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(13),n2h6(21))
  call Hloop_ZA_Q(ntryL,G0H12(18),ex1(:),G0H6(1),ngZu,m3h2x6(:,22),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(14),n2h6(22))
  call Hloop_VA_Q(ntryL,G1H12(15),ex1(:),G1H6(15),m3h2x6(:,23),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H6(15),17,0,G2H6(9),n2h6(23))
  call Hloop_ZA_Q(ntryL,G1H12(16),ex1(:),G1H6(15),ngZu,m3h2x6(:,24),heltab2x12(:,:,34))
  call Hloop_A_Q(ntryL,G1H6(15),17,0,G2H6(10),n2h6(24))
  call Hloop_WA_Q(ntryL,G0H12(19),ex1(:),G0H6(1),m3h2x6(:,25),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(15),n2h6(25))
  call Hloop_VA_Q(ntryL,G0H12(20),ex1(:),G0H6(1),m3h2x6(:,26),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(16),n2h6(26))
  call Hloop_ZA_Q(ntryL,G0H12(21),ex1(:),G0H6(1),ngZu,m3h2x6(:,27),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(17),n2h6(27))
  call Hloop_VA_Q(ntryL,G1H12(17),ex1(:),G1H6(18),m3h2x6(:,28),heltab2x12(:,:,38))
  call Hloop_A_Q(ntryL,G1H6(18),17,0,G2H6(11),n2h6(28))
  call Hloop_ZA_Q(ntryL,G1H12(18),ex1(:),G1H6(18),ngZu,m3h2x6(:,29),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H6(18),17,0,G2H6(12),n2h6(29))
  call Hloop_VA_Q(ntryL,G0H12(22),ex1(:),G0H6(1),m3h2x6(:,30),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(18),n2h6(30))
  call Hloop_WA_Q(ntryL,G0H12(23),ex1(:),G0H6(1),m3h2x6(:,31),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(19),n2h6(31))
  call Hloop_ZA_Q(ntryL,G0H12(24),ex1(:),G0H6(1),ngZu,m3h2x6(:,32),heltab2x12(:,:,42))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(20),n2h6(32))
  call Hloop_VA_Q(ntryL,G1H12(19),ex1(:),G1H6(21),m3h2x6(:,33),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H6(21),17,0,G2H6(13),n2h6(33))
  call Hloop_ZA_Q(ntryL,G1H12(20),ex1(:),G1H6(21),ngZu,m3h2x6(:,34),heltab2x12(:,:,44))
  call Hloop_A_Q(ntryL,G1H6(21),17,0,G2H6(14),n2h6(34))
  call Hloop_VA_Q(ntryL,G0H12(25),ex1(:),G0H6(1),m3h2x6(:,35),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(21),n2h6(35))
  call Hloop_ZA_Q(ntryL,G0H12(26),ex1(:),G0H6(1),ngZu,m3h2x6(:,36),heltab2x12(:,:,46))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(22),n2h6(36))
  call Hloop_VA_Q(ntryL,G1H12(21),ex1(:),G1H6(23),m3h2x6(:,37),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G1H6(23),17,0,G2H6(15),n2h6(37))
  call Hloop_ZA_Q(ntryL,G1H12(22),ex1(:),G1H6(23),ngZu,m3h2x6(:,38),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H6(23),17,0,G2H6(16),n2h6(38))
  call Hloop_AQ_Z(ntryL,G1H12(23),ex2(:),G1H6(23),ngZd,m3h2x6(:,39),heltab2x12(:,:,49))
  call Hloop_VQ_A(ntryL,G0H12(27),ex2(:),G0H6(1),m3h2x6(:,40),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(24),n2h6(39))
  call Hloop_ZQ_A(ntryL,G0H12(28),ex2(:),G0H6(1),ngZd,m3h2x6(:,41),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G0H6(1),18,0,G1H6(25),n2h6(40))
  call Hloop_WQ_A(ntryL,G1H12(24),ex2(:),G1H6(26),m3h2x6(:,42),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H6(26),18,0,G2H6(17),n2h6(41))
  call Hloop_VQ_A(ntryL,G1H12(25),ex2(:),G1H6(26),m3h2x6(:,43),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H6(26),18,0,G2H6(18),n2h6(42))
  call Hloop_ZQ_A(ntryL,G1H12(26),ex2(:),G1H6(26),ngZd,m3h2x6(:,44),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H6(26),18,0,G2H6(19),n2h6(43))
  call Hloop_QA_Z(ntryL,G1H12(27),ex1(:),G1H6(26),ngZu,m3h2x6(:,45),heltab2x12(:,:,55))
  call Hloop_VA_Q(ntryL,G0H12(29),ex1(:),G0H6(1),m3h2x6(:,46),heltab2x12(:,:,56))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(27),n2h6(44))
  call Hloop_ZA_Q(ntryL,G0H12(30),ex1(:),G0H6(1),ngZu,m3h2x6(:,47),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G0H6(1),17,0,G1H6(28),n2h6(45))
  call Hloop_WA_Q(ntryL,G1H12(28),ex1(:),G1H6(29),m3h2x6(:,48),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G1H6(29),17,0,G2H6(20),n2h6(46))
  call Hloop_VA_Q(ntryL,G1H12(29),ex1(:),G1H6(29),m3h2x6(:,49),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G1H6(29),17,0,G2H6(21),n2h6(47))
  call Hloop_ZA_Q(ntryL,G1H12(30),ex1(:),G1H6(29),ngZu,m3h2x6(:,50),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(29),17,0,G2H6(22),n2h6(48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(1),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(2),[G0H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(2)])
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(1),mass5set(:,1),  & 
G1H12(3),G1H12(4),G1H12(5),G1H12(6),G1H12(7),G1H12(8),12)
  call HG1shiftOLR(G1H12(4),8,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(1),mass5set(:,2),  & 
G1H12(9),G1H12(10),G1H12(11),G1H12(12),G1H12(13),G1H12(14),12)
  call HG1shiftOLR(G1H12(10),8,12)
  call Hloop_ZA_Q(ntryL,G1H12(1),ex1(:),G1H6(29),ngZu,m3h2x6(:,51),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(29),21,0,G2H6(23),n2h6(49))
  call Hloop_QA_W(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_QA_Z(ntryL,G1H6(2),ex1(:),G1H3(2),ngZu,m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_QA_W(ntryL,G1H6(3),ex1(:),G1H3(3),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_QA_W(ntryL,G2H6(1),ex1(:),G2H3(1),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_QA_W(ntryL,G2H6(2),ex1(:),G2H3(2),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_QA_Z(ntryL,G1H6(4),ex1(:),G1H3(4),ngZu,m3h2x3(:,6),heltab2x6(:,:,6))
  call Hloop_QA_W(ntryL,G1H6(5),ex1(:),G1H3(5),m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_QA_W(ntryL,G1H6(6),ex1(:),G1H3(6),m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_QA_W(ntryL,G2H6(3),ex1(:),G2H3(3),m3h2x3(:,9),heltab2x6(:,:,9))
  call Hloop_QA_W(ntryL,G2H6(4),ex1(:),G2H3(4),m3h2x3(:,10),heltab2x6(:,:,10))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(2),mass5set(:,1),  & 
G1H12(15),G1H12(16),G1H12(17),G1H12(18),G1H12(19),G1H12(20),12)
  call HG1shiftOLR(G1H12(16),8,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(2),mass5set(:,2),  & 
G1H12(21),G1H12(22),G1H12(23),G1H12(24),G1H12(25),G1H12(26),12)
  call HG1shiftOLR(G1H12(22),8,12)
  call Hloop_ZQ_A(ntryL,G1H12(2),ex2(:),G1H6(29),ngZd,m3h2x6(:,52),heltab2x12(:,:,62))
  call Hloop_Q_A(ntryL,G1H6(29),22,0,G2H6(1),n2h6(50))
  call Hloop_QA_W(ntryL,G1H6(7),ex1(:),G1H3(7),m3h2x3(:,11),heltab2x6(:,:,11))
  call Hloop_QA_Z(ntryL,G1H6(8),ex1(:),G1H3(8),ngZu,m3h2x3(:,12),heltab2x6(:,:,12))
  call Hloop_QA_W(ntryL,G1H6(9),ex1(:),G1H3(9),m3h2x3(:,13),heltab2x6(:,:,13))
  call Hloop_QA_W(ntryL,G2H6(5),ex1(:),G2H3(5),m3h2x3(:,14),heltab2x6(:,:,14))
  call Hloop_QA_W(ntryL,G2H6(6),ex1(:),G2H3(6),m3h2x3(:,15),heltab2x6(:,:,15))
  call Hloop_QA_W(ntryL,G1H6(10),ex1(:),G1H3(10),m3h2x3(:,16),heltab2x6(:,:,16))
  call Hloop_QA_W(ntryL,G1H6(11),ex1(:),G1H3(11),m3h2x3(:,17),heltab2x6(:,:,17))
  call Hloop_QA_W(ntryL,G2H6(7),ex1(:),G2H3(7),m3h2x3(:,18),heltab2x6(:,:,18))
  call Hloop_QA_W(ntryL,G2H6(8),ex1(:),G2H3(8),m3h2x3(:,19),heltab2x6(:,:,19))
  call Hloop_AQ_W(ntryL,G1H6(12),ex2(:),G1H3(12),m3h2x3(:,20),heltab2x6(:,:,20))
  call Hloop_AQ_Z(ntryL,G1H6(13),ex2(:),G1H3(13),ngZd,m3h2x3(:,21),heltab2x6(:,:,21))
  call Hloop_AQ_W(ntryL,G1H6(14),ex2(:),G1H3(14),m3h2x3(:,22),heltab2x6(:,:,22))
  call Hloop_AQ_W(ntryL,G2H6(9),ex2(:),G2H3(9),m3h2x3(:,23),heltab2x6(:,:,23))
  call Hloop_AQ_W(ntryL,G2H6(10),ex2(:),G2H3(10),m3h2x3(:,24),heltab2x6(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H6(15),ex2(:),G1H3(15),ngZd,m3h2x3(:,25),heltab2x6(:,:,25))
  call Hloop_AQ_W(ntryL,G1H6(16),ex2(:),G1H3(16),m3h2x3(:,26),heltab2x6(:,:,26))
  call Hloop_AQ_W(ntryL,G1H6(17),ex2(:),G1H3(17),m3h2x3(:,27),heltab2x6(:,:,27))
  call Hloop_AQ_W(ntryL,G2H6(11),ex2(:),G2H3(11),m3h2x3(:,28),heltab2x6(:,:,28))
  call Hloop_AQ_W(ntryL,G2H6(12),ex2(:),G2H3(12),m3h2x3(:,29),heltab2x6(:,:,29))
  call Hloop_AQ_W(ntryL,G1H6(18),ex2(:),G1H3(18),m3h2x3(:,30),heltab2x6(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H6(19),ex2(:),G1H3(19),ngZd,m3h2x3(:,31),heltab2x6(:,:,31))
  call Hloop_AQ_W(ntryL,G1H6(20),ex2(:),G1H3(20),m3h2x3(:,32),heltab2x6(:,:,32))
  call Hloop_AQ_W(ntryL,G2H6(13),ex2(:),G2H3(13),m3h2x3(:,33),heltab2x6(:,:,33))
  call Hloop_AQ_W(ntryL,G2H6(14),ex2(:),G2H3(14),m3h2x3(:,34),heltab2x6(:,:,34))
  call Hloop_AQ_W(ntryL,G1H6(21),ex2(:),G1H3(21),m3h2x3(:,35),heltab2x6(:,:,35))
  call Hloop_AQ_W(ntryL,G1H6(22),ex2(:),G1H3(22),m3h2x3(:,36),heltab2x6(:,:,36))
  call Hloop_AQ_W(ntryL,G2H6(15),ex2(:),G2H3(15),m3h2x3(:,37),heltab2x6(:,:,37))
  call Hloop_AQ_W(ntryL,G2H6(16),ex2(:),G2H3(16),m3h2x3(:,38),heltab2x6(:,:,38))
  call Hloop_VS_V(ntryL,G1H6(23),ex3(:),G1H6(1),m3h1x6(:,1),heltab2x6(:,:,39))
  call Hloop_QZ_A(ntryL,G1H6(24),ex4(:),G1H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(1),n2h2(1))
  call Hloop_QZ_A(ntryL,G1H6(25),ex4(:),G1H2(1),ngZd,m3h3x2(:,2),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(2),n2h2(2))
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(3),mass5set(:,3),  & 
G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),G1H6(29),6)
  call HG1shiftOLR(G1H6(3),4,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(3),mass5set(:,4),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),4,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(3),mass5set(:,5),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),4,6)
  call Hloop_VS_V(ntryL,G1H6(26),ex3(:),G1H6(19),m3h1x6(:,2),heltab2x6(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H6(27),ex4(:),G1H2(1),ngZu,m3h3x2(:,3),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(3),n2h2(3))
  call Hloop_AZ_Q(ntryL,G1H6(28),ex4(:),G1H2(1),ngZu,m3h3x2(:,4),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(4),n2h2(4))
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(4),mass5set(:,3),  & 
G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),6)
  call HG1shiftOLR(G1H6(21),4,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(4),mass5set(:,4),  & 
G1H6(26),G1H6(27),G1H6(28),G1H6(30),G1H6(31),G1H6(32),6)
  call HG1shiftOLR(G1H6(27),4,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(4),mass5set(:,5),  & 
G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),G1H6(38),6)
  call HG1shiftOLR(G1H6(34),4,6)
  call Hloop_WA_Q(ntryL,G1H12(3),ex1(:),G1H6(39),m3h2x6(:,53),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(2),n2h6(51))
call HGT_OLR(G1H12(4),1,1,12)
call HGT_invQ_OLR(G1H12(4),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(4),ex4(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,64))
  call Hloop_WA_Q(ntryL,G1H12(6),ex1(:),G1H6(39),m3h2x6(:,54),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(3),n2h6(52))
  call Hloop_WA_Q(ntryL,G1H12(7),ex1(:),G1H6(39),m3h2x6(:,55),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(4),n2h6(53))
  call Hloop_WA_Q(ntryL,G1H12(8),ex1(:),G1H6(39),m3h2x6(:,56),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(5),n2h6(54))
  call Hloop_ZA_Q(ntryL,G1H12(9),ex1(:),G1H6(39),ngZu,m3h2x6(:,57),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(6),n2h6(55))
call HGT_OLR(G1H12(10),1,1,12)
call HGT_invQ_OLR(G1H12(10),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(10),ex4(:),G1H4(2),m3h3x4(:,2),heltab2x12(:,:,69))
  call Hloop_ZA_Q(ntryL,G1H12(12),ex1(:),G1H6(39),ngZu,m3h2x6(:,58),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(7),n2h6(56))
  call Hloop_ZA_Q(ntryL,G1H12(13),ex1(:),G1H6(39),ngZu,m3h2x6(:,59),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(8),n2h6(57))
  call Hloop_ZA_Q(ntryL,G1H12(14),ex1(:),G1H6(39),ngZu,m3h2x6(:,60),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(9),n2h6(58))
  call Hloop_WQ_A(ntryL,G1H12(15),ex2(:),G1H6(39),m3h2x6(:,61),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(10),n2h6(59))
call HGT_OLR(G1H12(16),1,1,12)
call HGT_invQ_OLR(G1H12(16),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(16),ex4(:),G1H4(3),m3h3x4(:,3),heltab2x12(:,:,74))
  call Hloop_WQ_A(ntryL,G1H12(18),ex2(:),G1H6(39),m3h2x6(:,62),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(11),n2h6(60))
  call Hloop_WQ_A(ntryL,G1H12(19),ex2(:),G1H6(39),m3h2x6(:,63),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(12),n2h6(61))
  call Hloop_WQ_A(ntryL,G1H12(20),ex2(:),G1H6(39),m3h2x6(:,64),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(13),n2h6(62))
  call Hloop_ZQ_A(ntryL,G1H12(21),ex2(:),G1H6(39),ngZd,m3h2x6(:,65),heltab2x12(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(14),n2h6(63))
call HGT_OLR(G1H12(22),1,1,12)
call HGT_invQ_OLR(G1H12(22),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(22),ex4(:),G1H4(4),m3h3x4(:,4),heltab2x12(:,:,79))
  call Hloop_ZQ_A(ntryL,G1H12(24),ex2(:),G1H6(39),ngZd,m3h2x6(:,66),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(15),n2h6(64))
  call Hloop_ZQ_A(ntryL,G1H12(25),ex2(:),G1H6(39),ngZd,m3h2x6(:,67),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(16),n2h6(65))
  call Hloop_ZQ_A(ntryL,G1H12(26),ex2(:),G1H6(39),ngZd,m3h2x6(:,68),heltab2x12(:,:,82))
  call Hloop_Q_A(ntryL,G1H6(39),22,0,G2H6(17),n2h6(66))
  call Hloop_QZ_A(ntryL,G1H6(2),ex4(:),G1H2(1),ngZu,m3h3x2(:,5),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(5),n2h2(5))
call HGT_raise_alpha_OLR(G1H6(3),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(3),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(3),ex3(:),G1H6(39),m3h1x6(:,3),heltab2x6(:,:,46))
  call Hloop_QZ_A(ntryL,G1H6(5),ex4(:),G1H2(1),ngZu,m3h3x2(:,6),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(6),n2h2(6))
  call Hloop_QZ_A(ntryL,G1H6(6),ex4(:),G1H2(1),ngZu,m3h3x2(:,7),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(7),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H6(29),ex4(:),G1H2(1),ngZu,m3h3x2(:,8),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(8),n2h2(8))
  call Hloop_QZ_A(ntryL,G1H6(7),ex4(:),G1H2(1),ngZd,m3h3x2(:,9),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(9),n2h2(9))
call HGT_raise_alpha_OLR(G1H6(8),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(8),ex3(:),G1H6(2),m3h1x6(:,4),heltab2x6(:,:,51))
  call Hloop_QZ_A(ntryL,G1H6(10),ex4(:),G1H2(1),ngZd,m3h3x2(:,10),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(10),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H6(11),ex4(:),G1H2(1),ngZd,m3h3x2(:,11),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(11),n2h2(11))
  call Hloop_QZ_A(ntryL,G1H6(12),ex4(:),G1H2(1),ngZd,m3h3x2(:,12),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(12),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H6(13),ex4(:),G1H2(1),ngZd,m3h3x2(:,13),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(13),n2h2(13))
call HGT_raise_alpha_OLR(G1H6(14),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(14),ex3(:),G1H6(3),m3h1x6(:,5),heltab2x6(:,:,56))
  call Hloop_QZ_A(ntryL,G1H6(16),ex4(:),G1H2(1),ngZd,m3h3x2(:,14),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(14),n2h2(14))
  call Hloop_QZ_A(ntryL,G1H6(17),ex4(:),G1H2(1),ngZd,m3h3x2(:,15),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(15),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H6(18),ex4(:),G1H2(1),ngZd,m3h3x2(:,16),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(16),n2h2(16))
  call Hloop_AZ_Q(ntryL,G1H6(20),ex4(:),G1H2(1),ngZd,m3h3x2(:,17),heltab2x6(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(17),n2h2(17))
call HGT_raise_alpha_OLR(G1H6(21),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(21),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(21),ex3(:),G1H6(5),m3h1x6(:,6),heltab2x6(:,:,61))
  call Hloop_AZ_Q(ntryL,G1H6(23),ex4(:),G1H2(1),ngZd,m3h3x2(:,18),heltab2x6(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(18),n2h2(18))
  call Hloop_AZ_Q(ntryL,G1H6(24),ex4(:),G1H2(1),ngZd,m3h3x2(:,19),heltab2x6(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(19),n2h2(19))
  call Hloop_AZ_Q(ntryL,G1H6(25),ex4(:),G1H2(1),ngZd,m3h3x2(:,20),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(20),n2h2(20))
  call Hloop_AZ_Q(ntryL,G1H6(26),ex4(:),G1H2(1),ngZu,m3h3x2(:,21),heltab2x6(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(21),n2h2(21))
call HGT_raise_alpha_OLR(G1H6(27),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(27),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(27),ex3(:),G1H6(6),m3h1x6(:,7),heltab2x6(:,:,66))
  call Hloop_AZ_Q(ntryL,G1H6(30),ex4(:),G1H2(1),ngZu,m3h3x2(:,22),heltab2x6(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(22),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H6(31),ex4(:),G1H2(1),ngZu,m3h3x2(:,23),heltab2x6(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(23),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H6(32),ex4(:),G1H2(1),ngZu,m3h3x2(:,24),heltab2x6(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(24),n2h2(24))
  call Hloop_AZ_Q(ntryL,G1H6(33),ex4(:),G1H2(1),ngZu,m3h3x2(:,25),heltab2x6(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(25),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(34),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(34),ex3(:),G1H6(29),m3h1x6(:,8),heltab2x6(:,:,71))
  call Hloop_AZ_Q(ntryL,G1H6(36),ex4(:),G1H2(1),ngZu,m3h3x2(:,26),heltab2x6(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(26),n2h2(26))
  call Hloop_AZ_Q(ntryL,G1H6(37),ex4(:),G1H2(1),ngZu,m3h3x2(:,27),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(27),n2h2(27))
  call Hloop_AZ_Q(ntryL,G1H6(38),ex4(:),G1H2(1),ngZu,m3h3x2(:,28),heltab2x6(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(28),n2h2(28))
  call Hloop_AQ_W(ntryL,G2H6(23),ex2(:),G2H3(17),m3h2x3(:,39),heltab2x6(:,:,75))
  call Hloop_VT_S(ntryL,G1H3(1),19,ex3(:),4,G2H3(18),m3h1x3(:,1),heltab2x3(:,:,1))
  call Hloop_VT_S(ntryL,G1H3(2),19,ex3(:),4,G2H3(19),m3h1x3(:,2),heltab2x3(:,:,2))
  call Hloop_VT_S(ntryL,G1H3(3),19,ex3(:),4,G2H3(20),m3h1x3(:,3),heltab2x3(:,:,3))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(5),mass5set(:,6),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(23),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(5),mass5set(:,7),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
  call HG1shiftOLR(G1H3(27),8,3)
  call Hloop_VS_V(ntryL,G1H3(4),ex3(:),G1H3(32),m3h1x3(:,4),heltab2x3(:,:,4))
  call Hloop_VS_V(ntryL,G1H3(5),ex3(:),G1H3(4),m3h1x3(:,5),heltab2x3(:,:,5))
  call Hloop_VS_V(ntryL,G1H3(6),ex3(:),G1H3(5),m3h1x3(:,6),heltab2x3(:,:,6))
  call Hloop_VS_V(ntryL,G2H3(3),ex3(:),G2H3(1),m3h1x3(:,7),heltab2x3(:,:,7))
  call Hloop_VS_V(ntryL,G2H3(4),ex3(:),G2H3(2),m3h1x3(:,8),heltab2x3(:,:,8))
  call Hloop_QA_W(ntryL,G2H6(1),ex1(:),G2H3(3),m3h2x3(:,40),heltab2x6(:,:,76))
  call Hloop_VV_S(ntryL,G1H3(7),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,9))
  call Hloop_VV_S(ntryL,G1H3(8),ex4(:),G1H1(2),m3h3x1(:,2),heltab2x3(:,:,10))
  call Hloop_VV_S(ntryL,G1H3(9),ex4(:),G1H1(3),m3h3x1(:,3),heltab2x3(:,:,11))
  call Hloop_VV_S(ntryL,G2H3(5),ex4(:),G2H1(1),m3h3x1(:,4),heltab2x3(:,:,12))
  call Hloop_VV_S(ntryL,G2H3(6),ex4(:),G2H1(2),m3h3x1(:,5),heltab2x3(:,:,13))
  call Hloop_UV_W(ntryL,G1H3(10),19,ex4(:),8,G2H1(3),m3h3x1(:,6),heltab2x3(:,:,14))
  call Hloop_UV_W(ntryL,G1H3(11),19,ex4(:),8,G2H1(4),m3h3x1(:,7),heltab2x3(:,:,15))
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(6),mass5set(:,6),  & 
G1H3(6),G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(7),4,3)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(6),mass5set(:,7),  & 
G1H3(33),G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),3)
  call HG1shiftOLR(G1H3(34),4,3)
  call Hloop_VT_S(ntryL,G1H3(12),19,ex3(:),4,G2H3(4),m3h1x3(:,9),heltab2x3(:,:,16))
  call Hloop_VT_S(ntryL,G1H3(13),19,ex3(:),4,G2H3(5),m3h1x3(:,10),heltab2x3(:,:,17))
  call Hloop_VT_S(ntryL,G1H3(14),19,ex3(:),4,G2H3(6),m3h1x3(:,11),heltab2x3(:,:,18))
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(7),mass5set(:,6),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(39),G1H3(40),G1H3(41),3)
  call HG1shiftOLR(G1H3(13),8,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(7),mass5set(:,7),  & 
G1H3(42),G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
  call HG1shiftOLR(G1H3(43),8,3)
  call Hloop_VS_V(ntryL,G1H3(15),ex3(:),G1H3(48),m3h1x3(:,12),heltab2x3(:,:,19))
  call Hloop_VS_V(ntryL,G1H3(16),ex3(:),G1H3(15),m3h1x3(:,13),heltab2x3(:,:,20))
  call Hloop_VS_V(ntryL,G1H3(17),ex3(:),G1H3(16),m3h1x3(:,14),heltab2x3(:,:,21))
  call Hloop_VS_V(ntryL,G2H3(11),ex3(:),G2H3(7),m3h1x3(:,15),heltab2x3(:,:,22))
  call Hloop_VS_V(ntryL,G2H3(12),ex3(:),G2H3(8),m3h1x3(:,16),heltab2x3(:,:,23))
  call Hloop_VV_S(ntryL,G1H3(18),ex4(:),G1H1(4),m3h3x1(:,8),heltab2x3(:,:,24))
  call Hloop_VV_S(ntryL,G1H3(19),ex4(:),G1H1(5),m3h3x1(:,9),heltab2x3(:,:,25))
  call Hloop_VV_S(ntryL,G1H3(20),ex4(:),G1H1(6),m3h3x1(:,10),heltab2x3(:,:,26))
  call Hloop_VV_S(ntryL,G2H3(13),ex4(:),G2H1(5),m3h3x1(:,11),heltab2x3(:,:,27))
  call Hloop_VV_S(ntryL,G2H3(14),ex4(:),G2H1(6),m3h3x1(:,12),heltab2x3(:,:,28))
  call Hloop_UV_W(ntryL,G1H3(21),19,ex4(:),8,G2H1(7),m3h3x1(:,13),heltab2x3(:,:,29))
  call Hloop_UV_W(ntryL,G1H3(22),19,ex4(:),8,G2H1(8),m3h3x1(:,14),heltab2x3(:,:,30))
  call Hotf_5pt_reduction(G2H3(15),RedSet_5(8),mass5set(:,6),  & 
G1H3(17),G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(18),4,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(8),mass5set(:,7),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),4,3)
  call Hloop_ZA_Q(ntryL,G1H6(1),ex1(:),G1H3(55),ngZu,m3h2x3(:,41),heltab2x6(:,:,77))
  call Hloop_A_Q(ntryL,G1H3(55),23,0,G2H3(9),n2h3(1))
  call Hloop_QA_W(ntryL,G2H2(1),ex1(:),G2H1(9),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_QA_W(ntryL,G2H2(2),ex1(:),G2H1(10),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_ZQ_A(ntryL,G1H6(19),ex2(:),G1H3(55),ngZd,m3h2x3(:,42),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H3(55),23,0,G2H3(10),n2h3(2))
  call Hloop_AQ_W(ntryL,G2H2(3),ex2(:),G2H1(11),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hloop_AQ_W(ntryL,G2H2(4),ex2(:),G2H1(12),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H6(2),ex2(:),G2H3(11),ngZd,m3h2x3(:,43),heltab2x6(:,:,79))
  call Hloop_AQ_Z(ntryL,G2H6(4),ex2(:),G2H3(12),ngZd,m3h2x3(:,44),heltab2x6(:,:,80))
  call Hloop_AQ_Z(ntryL,G2H6(5),ex2(:),G2H3(13),ngZd,m3h2x3(:,45),heltab2x6(:,:,81))
  call Hloop_AQ_W(ntryL,G2H6(6),ex2(:),G2H3(14),m3h2x3(:,46),heltab2x6(:,:,82))
  call Hloop_AQ_W(ntryL,G2H6(8),ex2(:),G2H3(15),m3h2x3(:,47),heltab2x6(:,:,83))
  call Hloop_AQ_W(ntryL,G2H6(9),ex2(:),G2H3(16),m3h2x3(:,48),heltab2x6(:,:,84))
  call Hloop_QA_Z(ntryL,G2H6(10),ex1(:),G2H3(21),ngZu,m3h2x3(:,49),heltab2x6(:,:,85))
  call Hloop_QA_Z(ntryL,G2H6(12),ex1(:),G2H3(22),ngZu,m3h2x3(:,50),heltab2x6(:,:,86))
  call Hloop_QA_Z(ntryL,G2H6(13),ex1(:),G2H3(23),ngZu,m3h2x3(:,51),heltab2x6(:,:,87))
  call Hloop_QA_W(ntryL,G2H6(14),ex1(:),G2H3(24),m3h2x3(:,52),heltab2x6(:,:,88))
  call Hloop_QA_W(ntryL,G2H6(16),ex1(:),G2H3(25),m3h2x3(:,53),heltab2x6(:,:,89))
  call Hloop_QA_W(ntryL,G2H6(17),ex1(:),G2H3(26),m3h2x3(:,54),heltab2x6(:,:,90))
  call Hloop_QA_Z(ntryL,G2H2(5),ex1(:),G2H1(13),ngZu,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hloop_QA_Z(ntryL,G2H2(7),ex1(:),G2H1(14),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hloop_QA_Z(ntryL,G2H2(8),ex1(:),G2H1(15),ngZu,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hloop_QA_W(ntryL,G2H2(9),ex1(:),G2H1(16),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_QA_W(ntryL,G2H2(11),ex1(:),G2H1(17),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hloop_QA_W(ntryL,G2H2(12),ex1(:),G2H1(18),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hloop_QA_W(ntryL,G2H2(13),ex1(:),G2H1(19),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hloop_QA_W(ntryL,G2H2(15),ex1(:),G2H1(20),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_QA_W(ntryL,G2H2(16),ex1(:),G2H1(21),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H2(17),ex2(:),G2H1(22),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hloop_AQ_Z(ntryL,G2H2(19),ex2(:),G2H1(23),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H2(20),ex2(:),G2H1(24),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hloop_AQ_W(ntryL,G2H2(21),ex2(:),G2H1(25),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hloop_AQ_W(ntryL,G2H2(23),ex2(:),G2H1(26),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hloop_AQ_W(ntryL,G2H2(24),ex2(:),G2H1(27),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hloop_AQ_W(ntryL,G2H2(25),ex2(:),G2H1(28),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hloop_AQ_W(ntryL,G2H2(27),ex2(:),G2H1(29),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hloop_AQ_W(ntryL,G2H2(28),ex2(:),G2H1(30),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_VT_S(ntryL,G1H3(1),19,ex3(:),4,G2H3(27),m3h1x3(:,17),heltab2x3(:,:,31))
call HGT_raise_alpha_OLR(G1H3(2),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(2),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(2),ex4(:),G1H1(7),m3h3x1(:,15),heltab2x3(:,:,32))
  call Hloop_VT_S(ntryL,G1H3(24),19,ex3(:),4,G2H3(28),m3h1x3(:,18),heltab2x3(:,:,33))
  call Hloop_VT_S(ntryL,G1H3(25),19,ex3(:),4,G2H3(29),m3h1x3(:,19),heltab2x3(:,:,34))
  call Hloop_VT_S(ntryL,G1H3(26),19,ex3(:),4,G2H3(30),m3h1x3(:,20),heltab2x3(:,:,35))
call HGT_raise_alpha_OLR(G1H3(27),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(27),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(27),ex4(:),G1H1(8),m3h3x1(:,16),heltab2x3(:,:,36))
  call Hloop_VT_S(ntryL,G1H3(30),19,ex3(:),4,G2H3(31),m3h1x3(:,21),heltab2x3(:,:,37))
  call Hloop_VT_S(ntryL,G1H3(31),19,ex3(:),4,G2H3(32),m3h1x3(:,22),heltab2x3(:,:,38))
  call Hloop_UV_W(ntryL,G1H3(6),19,ex4(:),8,G2H1(31),m3h3x1(:,17),heltab2x3(:,:,39))
call HGT_raise_alpha_OLR(G1H3(7),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(7),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(7),ex3(:),G1H3(55),m3h1x3(:,23),heltab2x3(:,:,40))
  call Hloop_UV_W(ntryL,G1H3(10),19,ex4(:),8,G2H1(32),m3h3x1(:,18),heltab2x3(:,:,41))
  call Hloop_UV_W(ntryL,G1H3(11),19,ex4(:),8,G2H1(33),m3h3x1(:,19),heltab2x3(:,:,42))
  call Hloop_UV_W(ntryL,G1H3(33),19,ex4(:),8,G2H1(34),m3h3x1(:,20),heltab2x3(:,:,43))
call HGT_raise_alpha_OLR(G1H3(34),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(34),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(34),ex3(:),G1H3(1),m3h1x3(:,24),heltab2x3(:,:,44))
  call Hloop_UV_W(ntryL,G1H3(37),19,ex4(:),8,G2H1(35),m3h3x1(:,21),heltab2x3(:,:,45))
  call Hloop_UV_W(ntryL,G1H3(38),19,ex4(:),8,G2H1(36),m3h3x1(:,22),heltab2x3(:,:,46))
  call Hloop_VT_S(ntryL,G1H3(12),19,ex3(:),4,G2H3(33),m3h1x3(:,25),heltab2x3(:,:,47))
call HGT_raise_alpha_OLR(G1H3(13),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(13),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(13),ex4(:),G1H1(9),m3h3x1(:,23),heltab2x3(:,:,48))
  call Hloop_VT_S(ntryL,G1H3(40),19,ex3(:),4,G2H3(34),m3h1x3(:,26),heltab2x3(:,:,49))
  call Hloop_VT_S(ntryL,G1H3(41),19,ex3(:),4,G2H3(35),m3h1x3(:,27),heltab2x3(:,:,50))
  call Hloop_VT_S(ntryL,G1H3(42),19,ex3(:),4,G2H3(36),m3h1x3(:,28),heltab2x3(:,:,51))
call HGT_raise_alpha_OLR(G1H3(43),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(43),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(43),ex4(:),G1H1(10),m3h3x1(:,24),heltab2x3(:,:,52))
  call Hloop_VT_S(ntryL,G1H3(46),19,ex3(:),4,G2H3(37),m3h1x3(:,29),heltab2x3(:,:,53))
  call Hloop_VT_S(ntryL,G1H3(47),19,ex3(:),4,G2H3(38),m3h1x3(:,30),heltab2x3(:,:,54))
  call Hloop_UV_W(ntryL,G1H3(17),19,ex4(:),8,G2H1(37),m3h3x1(:,25),heltab2x3(:,:,55))
call HGT_raise_alpha_OLR(G1H3(18),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(18),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(18),ex3(:),G1H3(2),m3h1x3(:,31),heltab2x3(:,:,56))
  call Hloop_UV_W(ntryL,G1H3(21),19,ex4(:),8,G2H1(38),m3h3x1(:,26),heltab2x3(:,:,57))
  call Hloop_UV_W(ntryL,G1H3(22),19,ex4(:),8,G2H1(39),m3h3x1(:,27),heltab2x3(:,:,58))
  call Hloop_UV_W(ntryL,G1H3(49),19,ex4(:),8,G2H1(40),m3h3x1(:,28),heltab2x3(:,:,59))
call HGT_raise_alpha_OLR(G1H3(50),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(50),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(50),ex3(:),G1H3(24),m3h1x3(:,32),heltab2x3(:,:,60))
  call Hloop_UV_W(ntryL,G1H3(53),19,ex4(:),8,G2H1(41),m3h3x1(:,29),heltab2x3(:,:,61))
  call Hloop_UV_W(ntryL,G1H3(54),19,ex4(:),8,G2H1(42),m3h3x1(:,30),heltab2x3(:,:,62))
  call Hotf_5pt_reduction(G2H3(17),RedSet_5(1),mass5set(:,2),  & 
G1H3(25),G1H3(26),G1H3(27),G1H3(30),G1H3(31),G1H3(6),3)
  call HG1shiftOLR(G1H3(26),8,3)
  call Hotf_5pt_reduction(G2H3(18),RedSet_5(5),mass5set(:,6),  & 
G1H3(7),G1H3(10),G1H3(11),G1H3(33),G1H3(34),G1H3(37),3)
  call HG1shiftOLR(G1H3(10),8,3)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(5),mass5set(:,8),  & 
G1H3(38),G1H3(12),G1H3(13),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(12),8,3)
  call Hotf_5pt_reduction(G2H3(20),RedSet_5(5),mass5set(:,7),  & 
G1H3(43),G1H3(46),G1H3(47),G1H3(17),G1H3(18),G1H3(21),3)
  call HG1shiftOLR(G1H3(46),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(32),ex4(:),G1tensor(1),m3h3x1(:,31),heltab2x3(:,:,63))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(4),ex4(:),G1tensor(2),m3h3x1(:,32),heltab2x3(:,:,64))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(5),ex4(:),G1tensor(3),m3h3x1(:,33),heltab2x3(:,:,65))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(5),mass5set(:,6),  & 
G1H3(22),G1H3(49),G1H3(50),G1H3(53),G1H3(54),G1H3(32),3)
  call HG1shiftOLR(G1H3(49),8,3)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(5),mass5set(:,7),  & 
G1H3(4),G1H3(5),G1H3(56),G1H3(57),G1H3(58),G1H3(59),3)
  call HG1shiftOLR(G1H3(5),8,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(2),mass5set(:,2),  & 
G1H3(60),G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),3)
  call HG1shiftOLR(G1H3(61),8,3)
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(1),ex3(:),G1tensor(4),m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(2),ex3(:),G1tensor(5),m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(3),ex3(:),G1tensor(6),m3h1x1(:,3),heltab2x1(:,:,3))
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(6),mass5set(:,6),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(11),G1H1(12),G1H1(13),1)
  call HG1shiftOLR(G1H1(2),4,1)
  call Hotf_5pt_reduction(G2H1(2),RedSet_5(6),mass5set(:,7),  & 
G1H1(14),G1H1(15),G1H1(16),G1H1(17),G1H1(18),G1H1(19),1)
  call HG1shiftOLR(G1H1(15),4,1)
  call Hotf_5pt_reduction(G2H1(3),RedSet_5(6),mass5set(:,6),  & 
G1H1(20),G1H1(21),G1H1(22),G1H1(23),G1H1(24),G1H1(25),1)
  call HG1shiftOLR(G1H1(21),4,1)
  call Hotf_5pt_reduction(G2H1(4),RedSet_5(6),mass5set(:,7),  & 
G1H1(26),G1H1(27),G1H1(28),G1H1(29),G1H1(30),G1H1(31),1)
  call HG1shiftOLR(G1H1(27),4,1)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(7),mass5set(:,6),  & 
G1H3(66),G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(67),8,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(7),mass5set(:,8),  & 
G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(73),8,3)
  call Hotf_5pt_reduction(G2H3(6),RedSet_5(7),mass5set(:,7),  & 
G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(79),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(48),ex4(:),G1tensor(7),m3h3x1(:,34),heltab2x3(:,:,66))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(15),ex4(:),G1tensor(8),m3h3x1(:,35),heltab2x3(:,:,67))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(16),ex4(:),G1tensor(9),m3h3x1(:,36),heltab2x3(:,:,68))
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(7),mass5set(:,6),  & 
G1H3(48),G1H3(15),G1H3(16),G1H3(84),G1H3(85),G1H3(86),3)
  call HG1shiftOLR(G1H3(15),8,3)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(7),mass5set(:,7),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),G1H3(92),3)
  call HG1shiftOLR(G1H3(88),8,3)
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(4),ex3(:),G1tensor(10),m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(5),ex3(:),G1tensor(11),m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(6),ex3(:),G1tensor(12),m3h1x1(:,6),heltab2x1(:,:,6))
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(8),mass5set(:,6),  & 
G1H1(4),G1H1(5),G1H1(6),G1H1(32),G1H1(33),G1H1(34),1)
  call HG1shiftOLR(G1H1(5),4,1)
  call Hotf_5pt_reduction(G2H1(6),RedSet_5(8),mass5set(:,7),  & 
G1H1(35),G1H1(36),G1H1(37),G1H1(38),G1H1(39),G1H1(40),1)
  call HG1shiftOLR(G1H1(36),4,1)
  call Hotf_5pt_reduction(G2H1(7),RedSet_5(8),mass5set(:,6),  & 
G1H1(41),G1H1(42),G1H1(43),G1H1(44),G1H1(45),G1H1(46),1)
  call HG1shiftOLR(G1H1(42),4,1)
  call Hotf_5pt_reduction(G2H1(8),RedSet_5(8),mass5set(:,7),  & 
G1H1(47),G1H1(48),G1H1(49),G1H1(50),G1H1(51),G1H1(52),1)
  call HG1shiftOLR(G1H1(48),4,1)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(9),mass5set(:,9),  & 
G1H3(93),G1H3(94),G1H3(95),G1H3(96),G1H3(97),G1H3(98),3)
  call HG1shiftOLR(G1H3(94),8,3)
  call Hotf_5pt_reduction(G2H1(9),RedSet_5(3),mass5set(:,4),  & 
G1H1(53),G1H1(54),G1H1(55),G1H1(56),G1H1(57),G1H1(58),1)
  call HG1shiftOLR(G1H1(54),4,1)
  call Hotf_5pt_reduction(G2H1(10),RedSet_5(3),mass5set(:,5),  & 
G1H1(59),G1H1(60),G1H1(61),G1H1(62),G1H1(63),G1H1(64),1)
  call HG1shiftOLR(G1H1(60),4,1)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(10),mass5set(:,9),  & 
G1H3(99),G1H3(100),G1H3(101),G1H3(102),G1H3(103),G1H3(104),3)
  call HG1shiftOLR(G1H3(100),8,3)
  call Hotf_5pt_reduction(G2H1(11),RedSet_5(4),mass5set(:,4),  & 
G1H1(65),G1H1(66),G1H1(67),G1H1(68),G1H1(69),G1H1(70),1)
  call HG1shiftOLR(G1H1(66),4,1)
  call Hotf_5pt_reduction(G2H1(12),RedSet_5(4),mass5set(:,5),  & 
G1H1(71),G1H1(72),G1H1(73),G1H1(74),G1H1(75),G1H1(76),1)
  call HG1shiftOLR(G1H1(72),4,1)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(11),ex4(:),G2tensor(1),m3h3x1(:,37),heltab2x3(:,:,69))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(13),ex4(:),G2tensor(2),m3h3x1(:,38),heltab2x3(:,:,70))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(14),ex4(:),G2tensor(3),m3h3x1(:,39),heltab2x3(:,:,71))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(16),ex4(:),G2tensor(4),m3h3x1(:,40),heltab2x3(:,:,72))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(21),ex4(:),G2tensor(5),m3h3x1(:,41),heltab2x3(:,:,73))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(23),ex4(:),G2tensor(6),m3h3x1(:,42),heltab2x3(:,:,74))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(24),ex4(:),G2tensor(7),m3h3x1(:,43),heltab2x3(:,:,75))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(26),ex4(:),G2tensor(8),m3h3x1(:,44),heltab2x3(:,:,76))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(13),ex3(:),G2tensor(9),m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(15),ex3(:),G2tensor(10),m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(11),m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(12),m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(19),ex3(:),G2tensor(13),m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(21),ex3(:),G2tensor(14),m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(22),ex3(:),G2tensor(15),m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(24),ex3(:),G2tensor(16),m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(25),ex3(:),G2tensor(17),m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(27),ex3(:),G2tensor(18),m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(28),ex3(:),G2tensor(19),m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(30),ex3(:),G2tensor(20),m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(27),ex4(:),G2tensor(21),m3h3x1(:,45),heltab2x3(:,:,77))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(29),ex4(:),G2tensor(22),m3h3x1(:,46),heltab2x3(:,:,78))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(30),ex4(:),G2tensor(23),m3h3x1(:,47),heltab2x3(:,:,79))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(32),ex4(:),G2tensor(24),m3h3x1(:,48),heltab2x3(:,:,80))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(31),ex3(:),G2tensor(25),m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(33),ex3(:),G2tensor(26),m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(34),ex3(:),G2tensor(27),m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(36),ex3(:),G2tensor(28),m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(33),ex4(:),G2tensor(29),m3h3x1(:,49),heltab2x3(:,:,81))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(35),ex4(:),G2tensor(30),m3h3x1(:,50),heltab2x3(:,:,82))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(36),ex4(:),G2tensor(31),m3h3x1(:,51),heltab2x3(:,:,83))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(38),ex4(:),G2tensor(32),m3h3x1(:,52),heltab2x3(:,:,84))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(37),ex3(:),G2tensor(33),m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(39),ex3(:),G2tensor(34),m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(40),ex3(:),G2tensor(35),m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(42),ex3(:),G2tensor(36),m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(25),23,ex4(:),8,G2tensor(37),m3h3x1(:,53),heltab2x3(:,:,85))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(26),0,ex4(:),8,G2tensor(38),m3h3x1(:,54),heltab2x3(:,:,86))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(6),23,ex4(:),8,G2tensor(39),m3h3x1(:,55),heltab2x3(:,:,87))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(7),23,ex4(:),8,G2tensor(40),m3h3x1(:,56),heltab2x3(:,:,88))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(10),0,ex4(:),8,G2tensor(41),m3h3x1(:,57),heltab2x3(:,:,89))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(37),23,ex4(:),8,G2tensor(42),m3h3x1(:,58),heltab2x3(:,:,90))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(38),23,ex4(:),8,G2tensor(43),m3h3x1(:,59),heltab2x3(:,:,91))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(12),0,ex4(:),8,G2tensor(44),m3h3x1(:,60),heltab2x3(:,:,92))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(42),23,ex4(:),8,G2tensor(45),m3h3x1(:,61),heltab2x3(:,:,93))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(43),23,ex4(:),8,G2tensor(46),m3h3x1(:,62),heltab2x3(:,:,94))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(46),0,ex4(:),8,G2tensor(47),m3h3x1(:,63),heltab2x3(:,:,95))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(21),23,ex4(:),8,G2tensor(48),m3h3x1(:,64),heltab2x3(:,:,96))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(22),23,ex4(:),8,G2tensor(49),m3h3x1(:,65),heltab2x3(:,:,97))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(49),0,ex4(:),8,G2tensor(50),m3h3x1(:,66),heltab2x3(:,:,98))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(32),23,ex4(:),8,G2tensor(51),m3h3x1(:,67),heltab2x3(:,:,99))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(4),23,ex4(:),8,G2tensor(52),m3h3x1(:,68),heltab2x3(:,:,100))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(5),0,ex4(:),8,G2tensor(53),m3h3x1(:,69),heltab2x3(:,:,101))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(59),23,ex4(:),8,G2tensor(54),m3h3x1(:,70),heltab2x3(:,:,102))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(60),23,ex4(:),8,G2tensor(55),m3h3x1(:,71),heltab2x3(:,:,103))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(61),0,ex4(:),8,G2tensor(56),m3h3x1(:,72),heltab2x3(:,:,104))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(65),23,ex4(:),8,G2tensor(57),m3h3x1(:,73),heltab2x3(:,:,105))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(1),27,ex3(:),4,G2tensor(58),m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(2),0,ex3(:),4,G2tensor(59),m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(13),27,ex3(:),4,G2tensor(60),m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(14),27,ex3(:),4,G2tensor(61),m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(15),0,ex3(:),4,G2tensor(62),m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(19),27,ex3(:),4,G2tensor(63),m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(64),m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(21),0,ex3(:),4,G2tensor(65),m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(25),27,ex3(:),4,G2tensor(66),m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(26),27,ex3(:),4,G2tensor(67),m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(27),0,ex3(:),4,G2tensor(68),m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(31),27,ex3(:),4,G2tensor(69),m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(66),23,ex4(:),8,G2tensor(70),m3h3x1(:,74),heltab2x3(:,:,106))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(67),0,ex4(:),8,G2tensor(71),m3h3x1(:,75),heltab2x3(:,:,107))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(71),23,ex4(:),8,G2tensor(72),m3h3x1(:,76),heltab2x3(:,:,108))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(72),23,ex4(:),8,G2tensor(73),m3h3x1(:,77),heltab2x3(:,:,109))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(73),0,ex4(:),8,G2tensor(74),m3h3x1(:,78),heltab2x3(:,:,110))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(77),23,ex4(:),8,G2tensor(75),m3h3x1(:,79),heltab2x3(:,:,111))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(78),23,ex4(:),8,G2tensor(76),m3h3x1(:,80),heltab2x3(:,:,112))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(79),0,ex4(:),8,G2tensor(77),m3h3x1(:,81),heltab2x3(:,:,113))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(83),23,ex4(:),8,G2tensor(78),m3h3x1(:,82),heltab2x3(:,:,114))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(48),23,ex4(:),8,G2tensor(79),m3h3x1(:,83),heltab2x3(:,:,115))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(15),0,ex4(:),8,G2tensor(80),m3h3x1(:,84),heltab2x3(:,:,116))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(86),23,ex4(:),8,G2tensor(81),m3h3x1(:,85),heltab2x3(:,:,117))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(87),23,ex4(:),8,G2tensor(82),m3h3x1(:,86),heltab2x3(:,:,118))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(88),0,ex4(:),8,G2tensor(83),m3h3x1(:,87),heltab2x3(:,:,119))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(92),23,ex4(:),8,G2tensor(84),m3h3x1(:,88),heltab2x3(:,:,120))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(4),27,ex3(:),4,G2tensor(85),m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(5),0,ex3(:),4,G2tensor(86),m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(34),27,ex3(:),4,G2tensor(87),m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(35),27,ex3(:),4,G2tensor(88),m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(36),0,ex3(:),4,G2tensor(89),m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(40),27,ex3(:),4,G2tensor(90),m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(41),27,ex3(:),4,G2tensor(91),m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(42),0,ex3(:),4,G2tensor(92),m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(46),27,ex3(:),4,G2tensor(93),m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(47),27,ex3(:),4,G2tensor(94),m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(48),0,ex3(:),4,G2tensor(95),m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(52),27,ex3(:),4,G2tensor(96),m3h1x1(:,50),heltab2x1(:,:,50))
  call Hloop_AZ_Q(ntryL,G1H3(93),ex4(:),G1H1(1),ngZu,m3h3x1(:,89),heltab2x3(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(21))
  call Hloop_AZ_Q(ntryL,G1H3(94),ex4(:),G1H1(2),ngZu,m3h3x1(:,90),heltab2x3(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),8,0,G2tensor(98),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(98),ex4(:),G1H1(13),ngZu,m3h3x1(:,91),heltab2x3(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,0,G2tensor(99),n2h1(23))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(53),27,ex3(:),4,G2tensor(100),m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(54),0,ex3(:),4,G2tensor(101),m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(58),27,ex3(:),4,G2tensor(102),m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(59),27,ex3(:),4,G2tensor(103),m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(60),0,ex3(:),4,G2tensor(104),m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(64),27,ex3(:),4,G2tensor(105),m3h1x1(:,56),heltab2x1(:,:,56))
  call Hloop_QZ_A(ntryL,G1H3(99),ex4(:),G1H1(14),ngZd,m3h3x1(:,92),heltab2x3(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,0,G2tensor(106),n2h1(26))
  call Hloop_QZ_A(ntryL,G1H3(100),ex4(:),G1H1(15),ngZd,m3h3x1(:,93),heltab2x3(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),8,0,G2tensor(107),n2h1(27))
  call Hloop_QZ_A(ntryL,G1H3(104),ex4(:),G1H1(19),ngZd,m3h3x1(:,94),heltab2x3(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,0,G2tensor(108),n2h1(28))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(65),27,ex3(:),4,G2tensor(109),m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(66),0,ex3(:),4,G2tensor(110),m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(70),27,ex3(:),4,G2tensor(111),m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(71),27,ex3(:),4,G2tensor(112),m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(72),0,ex3(:),4,G2tensor(113),m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(76),27,ex3(:),4,G2tensor(114),m3h1x1(:,62),heltab2x1(:,:,62))
  call ol_merge_tensors(G2tensor(43),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(40),G2tensor(21),G1tensor(2)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(46),G2tensor(23),G1tensor(3)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(58),G2tensor(25),G1tensor(4)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(61),G2tensor(27),G1tensor(6)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(7)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(70),G2tensor(29),G1tensor(8)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(76),G2tensor(31),G1tensor(9)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(85),G2tensor(33),G1tensor(10)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(88),G2tensor(35),G1tensor(12)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(11)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(17)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(19)])
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(5),mass5set(:,8),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(6),G1tensor(7))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(5),mass5set(:,6),  & 
G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(12),G1tensor(13),G1tensor(14))
  call G_TensorShift(G1tensor(9),8)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(5),mass5set(:,7),  & 
G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(16),8)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(6),mass5set(:,6),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25),G1tensor(26))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(6),mass5set(:,7),  & 
G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30),G1tensor(31),G1tensor(32))
  call G_TensorShift(G1tensor(28),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(7),mass5set(:,8),  & 
G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36),G1tensor(37),G1tensor(38))
  call G_TensorShift(G1tensor(34),8)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(7),mass5set(:,6),  & 
G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44))
  call G_TensorShift(G1tensor(40),8)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(7),mass5set(:,7),  & 
G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(46),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(8),mass5set(:,6),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55),G1tensor(56))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(8),mass5set(:,7),  & 
G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60),G1tensor(61),G1tensor(62))
  call G_TensorShift(G1tensor(58),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66),G1tensor(67),G1tensor(68))
  call G_TensorShift(G1tensor(64),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(1),mass5set(:,2),  & 
G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74))
  call G_TensorShift(G1tensor(70),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(76),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(2),mass5set(:,2),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85),G1tensor(86))
  call G_TensorShift(G1tensor(82),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,3),  & 
G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90),G1tensor(91),G1tensor(92))
  call G_TensorShift(G1tensor(88),4)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(3),mass5set(:,4),  & 
G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96),G1tensor(97),G1tensor(98))
  call G_TensorShift(G1tensor(94),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(3),mass5set(:,5),  & 
G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104))
  call G_TensorShift(G1tensor(100),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(4),mass5set(:,3),  & 
G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(106),4)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(4),mass5set(:,4),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115),G1tensor(116))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(4),mass5set(:,5),  & 
G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120),G1tensor(121),G1tensor(122))
  call G_TensorShift(G1tensor(118),4)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(9),mass5set(:,9),  & 
G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126),G1tensor(127),G1tensor(128))
  call G_TensorShift(G1tensor(124),8)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(10),mass5set(:,9),  & 
G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134))
  call G_TensorShift(G1tensor(130),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(8)])
  call ol_merge_tensors(T1sum(3),[G1tensor(15)])
  call ol_merge_tensors(T1sum(4),[G1tensor(21)])
  call ol_merge_tensors(T1sum(5),[G1tensor(5)])
  call ol_merge_tensors(T1sum(6),[G1tensor(27)])
  call ol_merge_tensors(T1sum(7),[G1tensor(33)])
  call ol_merge_tensors(T1sum(8),[G1tensor(39)])
  call ol_merge_tensors(T1sum(9),[G1tensor(45)])
  call ol_merge_tensors(T1sum(10),[G1tensor(51)])
  call ol_merge_tensors(T1sum(11),[G1tensor(11)])
  call ol_merge_tensors(T1sum(12),[G1tensor(57)])
  call ol_merge_tensors(T1sum(13),[G1tensor(63)])
  call ol_merge_tensors(T1sum(14),[G1tensor(69)])
  call ol_merge_tensors(T1sum(15),[G1tensor(75)])
  call ol_merge_tensors(T1sum(16),[G1tensor(81)])
  call ol_merge_tensors(T1sum(17),[G1tensor(87)])
  call ol_merge_tensors(T1sum(18),[G1tensor(93)])
  call ol_merge_tensors(T1sum(19),[G1tensor(99)])
  call ol_merge_tensors(T1sum(20),[G1tensor(105)])
  call ol_merge_tensors(T1sum(21),[G1tensor(111)])
  call ol_merge_tensors(T1sum(22),[G1tensor(117)])
  call ol_merge_tensors(T1sum(23),[G1tensor(123)])
  call ol_merge_tensors(T1sum(24),[G1tensor(129)])
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[24,2,1,4],[nMW,0,nMZ,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(1),m4h3x3x4(:,1),heltab3x36(:,:,1))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[24,2,1,4],[0,0,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(2),m4h3x3x4(:,2),heltab3x36(:,:,2))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[24,2,1,4],[nMZ,0,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(3),m4h3x3x4(:,3),heltab3x36(:,:,3))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[24,1,2,4],[nMW,0,nMZ,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(4),m4h3x3x4(:,4),heltab3x36(:,:,4))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[24,1,2,4],[0,0,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(5),m4h3x3x4(:,5),heltab3x36(:,:,5))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[24,1,2,4],[nMZ,0,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(6),m4h3x3x4(:,6),heltab3x36(:,:,6))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[20,2,1,8],[0,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(4),m4h1x3x12(:,1),heltab3x36(:,:,7))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[20,2,1,8],[nMW,0,nMZ,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(5),m4h1x3x12(:,2),heltab3x36(:,:,8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[20,2,1,8],[nMZ,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(6),m4h1x3x12(:,3),heltab3x36(:,:,9))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[20,1,2,8],[0,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(7),m4h1x3x12(:,4),heltab3x36(:,:,10))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[20,1,2,8],[nMW,0,nMZ,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(8),m4h1x3x12(:,5),heltab3x36(:,:,11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[20,1,2,8],[nMZ,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(9),m4h1x3x12(:,6),heltab3x36(:,:,12))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[16,1,2,12],[0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(10),m3h3x12(:,61),heltab2x36(:,:,61))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[16,1,2,12],[nMW,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(11),m3h3x12(:,62),heltab2x36(:,:,62))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[16,1,2,12],[nMZ,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,63),heltab2x36(:,:,63))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[16,2,1,12],[0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,64),heltab2x36(:,:,64))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(77),h0tab(:,77),[16,2,1,12],[nMW,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,65),heltab2x36(:,:,65))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(78),h0tab(:,78),[16,2,1,12],[nMZ,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,66),heltab2x36(:,:,66))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(79),h0tab(:,79),[16,3,8,4],[0,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,67),heltab2x36(:,:,67))
  call Hloop_Q_A(ntryL,G0H12(16),16,0,G1H12(27),n2h12(7))
  Gcoeff(:)%j = (c(206)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(80),h0tab(:,80),[16,3,8,4],[nMB,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,68),heltab2x36(:,:,68))
  call Hloop_A_Q(ntryL,G0H12(17),16,nMB,G1H12(28),n2h12(8))
  Gcoeff(:)%j = (c(204)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMT,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,69),heltab2x36(:,:,69))
  call Hloop_Q_A(ntryL,G0H12(18),16,nMT,G1H12(29),n2h12(9))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMW,nMZ,nMH,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(30),m3h3x12(:,70),heltab2x36(:,:,70))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMW,nMH,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(1),m3h3x12(:,71),heltab2x36(:,:,71))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(2),m3h3x12(:,72),heltab2x36(:,:,72))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(3),m3h3x12(:,73),heltab2x36(:,:,73))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(86),h0tab(:,86),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(4),m3h3x12(:,74),heltab2x36(:,:,74))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(6),m3h3x12(:,75),heltab2x36(:,:,75))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(88),h0tab(:,88),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(7),m3h3x12(:,76),heltab2x36(:,:,76))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(8),m3h3x12(:,77),heltab2x36(:,:,77))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(90),h0tab(:,90),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(9),m3h3x12(:,78),heltab2x36(:,:,78))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(10),m3h3x12(:,79),heltab2x36(:,:,79))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(92),h0tab(:,92),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,80),heltab2x36(:,:,80))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,81),heltab2x36(:,:,81))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(94),h0tab(:,94),[16,3,8,4],[nMW,nMZ,nMH,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(12),m3h3x12(:,82),heltab2x36(:,:,82))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(95),h0tab(:,95),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(13),m3h3x12(:,83),heltab2x36(:,:,83))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(96),h0tab(:,96),[16,3,8,4],[nMW,nMH,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,84),heltab2x36(:,:,84))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(97),h0tab(:,97),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,85),heltab2x36(:,:,85))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(98),h0tab(:,98),[16,3,8,4],[nMW,nMH,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(14),m3h3x12(:,86),heltab2x36(:,:,86))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(15),m3h3x12(:,87),heltab2x36(:,:,87))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(100),h0tab(:,100),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(16),m3h3x12(:,88),heltab2x36(:,:,88))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(101),h0tab(:,101),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,89),heltab2x36(:,:,89))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(102),h0tab(:,102),[16,3,8,4],[nMW,nMZ,nMH,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,90),heltab2x36(:,:,90))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(103),h0tab(:,103),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,91),heltab2x36(:,:,91))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(104),h0tab(:,104),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(18),m3h3x12(:,92),heltab2x36(:,:,92))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMW,nMH,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(19),m3h3x12(:,93),heltab2x36(:,:,93))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(106),h0tab(:,106),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(20),m3h3x12(:,94),heltab2x36(:,:,94))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,95),heltab2x36(:,:,95))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(108),h0tab(:,108),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,96),heltab2x36(:,:,96))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,97),heltab2x36(:,:,97))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(110),h0tab(:,110),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(21),m3h3x12(:,98),heltab2x36(:,:,98))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMW,nMH,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,99),heltab2x36(:,:,99))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,100),heltab2x36(:,:,100))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(113),h0tab(:,113),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(22),m3h3x12(:,101),heltab2x36(:,:,101))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(24),m3h3x12(:,102),heltab2x36(:,:,102))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(115),h0tab(:,115),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,103),heltab2x36(:,:,103))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,104),heltab2x36(:,:,104))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMH,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(25),m3h3x12(:,105),heltab2x36(:,:,105))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(118),h0tab(:,118),[16,3,8,4],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(26),m3h3x12(:,106),heltab2x36(:,:,106))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(31),m3h3x12(:,107),heltab2x36(:,:,107))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,108),heltab2x36(:,:,108))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(121),h0tab(:,121),[16,3,4,8],[0,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,109),heltab2x36(:,:,109))
  call Hloop_Q_A(ntryL,G0H12(2),16,0,G1H12(32),n2h12(10))
  Gcoeff(:)%j = (c(206)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(122),h0tab(:,122),[16,3,4,8],[nMB,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,110),heltab2x36(:,:,110))
  call Hloop_A_Q(ntryL,G0H12(16),16,nMB,G1H12(33),n2h12(11))
  Gcoeff(:)%j = (c(204)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(123),h0tab(:,123),[16,3,4,8],[nMT,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,111),heltab2x36(:,:,111))
  call Hloop_Q_A(ntryL,G0H12(17),16,nMT,G1H12(34),n2h12(12))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(124),h0tab(:,124),[16,3,4,8],[nMW,nMH,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(35),m3h3x12(:,112),heltab2x36(:,:,112))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(125),h0tab(:,125),[16,3,4,8],[nMW,nMZ,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(36),m3h3x12(:,113),heltab2x36(:,:,113))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(126),h0tab(:,126),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(37),m3h3x12(:,114),heltab2x36(:,:,114))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(127),h0tab(:,127),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(38),m3h3x12(:,115),heltab2x36(:,:,115))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(128),h0tab(:,128),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(39),m3h3x12(:,116),heltab2x36(:,:,116))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(129),h0tab(:,129),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(40),m3h3x12(:,117),heltab2x36(:,:,117))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(130),h0tab(:,130),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(41),m3h3x12(:,118),heltab2x36(:,:,118))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(131),h0tab(:,131),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(42),m3h3x12(:,119),heltab2x36(:,:,119))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(132),h0tab(:,132),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(43),m3h3x12(:,120),heltab2x36(:,:,120))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(133),h0tab(:,133),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(44),m3h3x12(:,121),heltab2x36(:,:,121))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(134),h0tab(:,134),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,122),heltab2x36(:,:,122))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(135),h0tab(:,135),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,123),heltab2x36(:,:,123))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(136),h0tab(:,136),[16,3,4,8],[nMW,nMH,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,124),heltab2x36(:,:,124))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(137),h0tab(:,137),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,125),heltab2x36(:,:,125))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(138),h0tab(:,138),[16,3,4,8],[nMW,nMZ,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(45),m3h3x12(:,126),heltab2x36(:,:,126))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(139),h0tab(:,139),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(46),m3h3x12(:,127),heltab2x36(:,:,127))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(140),h0tab(:,140),[16,3,4,8],[nMW,nMZ,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(47),m3h3x12(:,128),heltab2x36(:,:,128))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(141),h0tab(:,141),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(48),m3h3x12(:,129),heltab2x36(:,:,129))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(142),h0tab(:,142),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(49),m3h3x12(:,130),heltab2x36(:,:,130))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(143),h0tab(:,143),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(50),m3h3x12(:,131),heltab2x36(:,:,131))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(144),h0tab(:,144),[16,3,4,8],[nMW,nMH,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(51),m3h3x12(:,132),heltab2x36(:,:,132))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(145),h0tab(:,145),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(52),m3h3x12(:,133),heltab2x36(:,:,133))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(146),h0tab(:,146),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(32),m3h3x12(:,134),heltab2x36(:,:,134))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(147),h0tab(:,147),[16,3,4,8],[nMW,nMZ,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(33),m3h3x12(:,135),heltab2x36(:,:,135))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(148),h0tab(:,148),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(34),m3h3x12(:,136),heltab2x36(:,:,136))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(149),h0tab(:,149),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(35),m3h3x12(:,137),heltab2x36(:,:,137))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(150),h0tab(:,150),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(36),m3h3x12(:,138),heltab2x36(:,:,138))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(151),h0tab(:,151),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(37),m3h3x12(:,139),heltab2x36(:,:,139))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(152),h0tab(:,152),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,140),heltab2x36(:,:,140))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(153),h0tab(:,153),[16,3,4,8],[nMW,nMZ,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(53),m3h3x12(:,141),heltab2x36(:,:,141))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(154),h0tab(:,154),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(54),m3h3x12(:,142),heltab2x36(:,:,142))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(155),h0tab(:,155),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(55),m3h3x12(:,143),heltab2x36(:,:,143))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(156),h0tab(:,156),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(56),m3h3x12(:,144),heltab2x36(:,:,144))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(157),h0tab(:,157),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(57),m3h3x12(:,145),heltab2x36(:,:,145))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(158),h0tab(:,158),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(58),m3h3x12(:,146),heltab2x36(:,:,146))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(159),h0tab(:,159),[16,3,4,8],[nMW,nMZ,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,147),heltab2x36(:,:,147))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(160),h0tab(:,160),[16,3,4,8],[0,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,148),heltab2x36(:,:,148))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMZ,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(41),m3h3x12(:,149),heltab2x36(:,:,149))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(162),h0tab(:,162),[16,3,4,8],[nMH,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(42),m3h3x12(:,150),heltab2x36(:,:,150))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(163),h0tab(:,163),[16,4,3,8],[nML,nML,0,0],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,151),heltab2x36(:,:,151))
  call Hloop_A_Q(ntryL,G0H12(43),16,nML,G1H12(59),n2h12(13))
  Gcoeff(:)%j = (c(206)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(164),h0tab(:,164),[16,4,3,8],[nMT,nMT,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,152),heltab2x36(:,:,152))
  call Hloop_Q_A(ntryL,G0H12(43),16,nMT,G1H12(60),n2h12(14))
  Gcoeff(:)%j = (c(204)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(165),h0tab(:,165),[16,4,3,8],[nMB,nMB,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,153),heltab2x36(:,:,153))
  call Hloop_A_Q(ntryL,G0H12(43),16,nMB,G1H12(61),n2h12(15))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(166),h0tab(:,166),[16,4,3,8],[nMH,nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(62),m3h3x12(:,154),heltab2x36(:,:,154))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(167),h0tab(:,167),[16,4,3,8],[nMW,nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(63),m3h3x12(:,155),heltab2x36(:,:,155))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(168),h0tab(:,168),[16,4,3,8],[nMW,nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(64),m3h3x12(:,156),heltab2x36(:,:,156))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(169),h0tab(:,169),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(65),m3h3x12(:,157),heltab2x36(:,:,157))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(170),h0tab(:,170),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(66),m3h3x12(:,158),heltab2x36(:,:,158))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(171),h0tab(:,171),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(67),m3h3x12(:,159),heltab2x36(:,:,159))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(172),h0tab(:,172),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(68),m3h3x12(:,160),heltab2x36(:,:,160))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(173),h0tab(:,173),[16,4,3,8],[nMW,nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(69),m3h3x12(:,161),heltab2x36(:,:,161))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(174),h0tab(:,174),[16,4,3,8],[nMH,nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(70),m3h3x12(:,162),heltab2x36(:,:,162))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(175),h0tab(:,175),[16,4,3,8],[nMW,nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,163),heltab2x36(:,:,163))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(176),h0tab(:,176),[16,4,3,8],[nMH,nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(44),m3h3x12(:,164),heltab2x36(:,:,164))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(177),h0tab(:,177),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(71),m3h3x12(:,165),heltab2x36(:,:,165))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(178),h0tab(:,178),[16,4,3,8],[nMW,nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(72),m3h3x12(:,166),heltab2x36(:,:,166))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(179),h0tab(:,179),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(45),m3h3x12(:,167),heltab2x36(:,:,167))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(180),h0tab(:,180),[16,4,3,8],[nMW,nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(46),m3h3x12(:,168),heltab2x36(:,:,168))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(181),h0tab(:,181),[16,4,3,8],[nMH,nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(47),m3h3x12(:,169),heltab2x36(:,:,169))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(182),h0tab(:,182),[16,4,3,8],[nMW,nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(73),m3h3x12(:,170),heltab2x36(:,:,170))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(183),h0tab(:,183),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(74),m3h3x12(:,171),heltab2x36(:,:,171))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(184),h0tab(:,184),[16,4,3,8],[nMW,nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(48),m3h3x12(:,172),heltab2x36(:,:,172))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(185),h0tab(:,185),[16,4,3,8],[nMW,nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,173),heltab2x36(:,:,173))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(186),h0tab(:,186),[16,4,3,8],[nMW,nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(75),m3h3x12(:,174),heltab2x36(:,:,174))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(187),h0tab(:,187),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(76),m3h3x12(:,175),heltab2x36(:,:,175))
  Gcoeff(:)%j = (-(c(173)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(188),h0tab(:,188),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(50),m3h3x12(:,176),heltab2x36(:,:,176))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(189),h0tab(:,189),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(51),m3h3x12(:,177),heltab2x36(:,:,177))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(190),h0tab(:,190),[16,4,3,8],[nMW,nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(52),m3h3x12(:,178),heltab2x36(:,:,178))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(191),h0tab(:,191),[16,4,3,8],[nMZ,nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(77),m3h3x12(:,179),heltab2x36(:,:,179))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(192),h0tab(:,192),[16,4,3,8],[nMW,nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(78),m3h3x12(:,180),heltab2x36(:,:,180))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(193),h0tab(:,193),[16,2,4,9],[0,nMZ,nMZ,0],4,1,wf6(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,181),heltab2x36(:,:,181))
  call Hloop_A_Q(ntryL,G0H12(53),16,0,G1H12(79),n2h12(16))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(194),h0tab(:,194),[16,4,2,9],[nMW,nMW,0,0],4,1,wf6(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,182),heltab2x36(:,:,182))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(195),h0tab(:,195),[16,4,2,9],[nMW,nMW,0,nMZ],4,1,wf6(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(54),m3h3x12(:,183),heltab2x36(:,:,183))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(196),h0tab(:,196),[16,4,2,9],[nMZ,nMZ,0,nMW],4,1,wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(80),m3h3x12(:,184),heltab2x36(:,:,184))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(197),h0tab(:,197),[16,4,2,9],[nMW,nMW,0,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(81),m3h3x12(:,185),heltab2x36(:,:,185))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(198),h0tab(:,198),[16,4,2,9],[nMW,nMW,0,nMZ],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(82),m3h3x12(:,186),heltab2x36(:,:,186))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(199),h0tab(:,199),[16,2,9,4],[0,0,nMW,nMW],4,1,wf6(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(55),m3h3x12(:,187),heltab2x36(:,:,187))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(200),h0tab(:,200),[16,2,9,4],[nMZ,0,nMW,nMW],4,1,wf6(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(56),m3h3x12(:,188),heltab2x36(:,:,188))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(201),h0tab(:,201),[16,2,9,4],[nMW,0,nMZ,nMZ],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(83),m3h3x12(:,189),heltab2x36(:,:,189))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(202),h0tab(:,202),[16,2,9,4],[0,0,nMW,nMW],4,1,wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(84),m3h3x12(:,190),heltab2x36(:,:,190))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(203),h0tab(:,203),[16,2,9,4],[nMZ,0,nMW,nMW],4,1,wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(85),m3h3x12(:,191),heltab2x36(:,:,191))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(204),h0tab(:,204),[16,1,4,10],[0,nMZ,nMZ,0],4,1,wf6(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,192),heltab2x36(:,:,192))
  call Hloop_Q_A(ntryL,G0H12(57),16,0,G1H12(86),n2h12(17))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(205),h0tab(:,205),[16,4,1,10],[nMW,nMW,0,0],4,1,wf6(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,193),heltab2x36(:,:,193))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(206),h0tab(:,206),[16,4,1,10],[nMW,nMW,0,nMZ],4,1,wf6(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(58),m3h3x12(:,194),heltab2x36(:,:,194))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(207),h0tab(:,207),[16,4,1,10],[nMZ,nMZ,0,nMW],4,1,wf6(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(87),m3h3x12(:,195),heltab2x36(:,:,195))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(208),h0tab(:,208),[16,4,1,10],[nMW,nMW,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(88),m3h3x12(:,196),heltab2x36(:,:,196))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(209),h0tab(:,209),[16,4,1,10],[nMW,nMW,0,nMZ],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(89),m3h3x12(:,197),heltab2x36(:,:,197))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(210),h0tab(:,210),[16,1,10,4],[0,0,nMW,nMW],4,1,wf6(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(59),m3h3x12(:,198),heltab2x36(:,:,198))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(211),h0tab(:,211),[16,1,10,4],[nMZ,0,nMW,nMW],4,1,wf6(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(60),m3h3x12(:,199),heltab2x36(:,:,199))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(212),h0tab(:,212),[16,1,10,4],[nMW,0,nMZ,nMZ],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(90),m3h3x12(:,200),heltab2x36(:,:,200))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(213),h0tab(:,213),[16,1,10,4],[0,0,nMW,nMW],4,1,wf6(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(91),m3h3x12(:,201),heltab2x36(:,:,201))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(214),h0tab(:,214),[16,1,10,4],[nMZ,0,nMW,nMW],4,1,wf6(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(92),m3h3x12(:,202),heltab2x36(:,:,202))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(215),h0tab(:,215),[16,1,2,12],[0,0,nMW,nMW],4,1,wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,203),heltab2x36(:,:,203))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(216),h0tab(:,216),[16,1,2,12],[nMW,0,nMZ,nMH],4,1,wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,204),heltab2x36(:,:,204))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(217),h0tab(:,217),[16,1,2,12],[nMZ,0,nMW,nMW],4,1,wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(63),m3h3x12(:,205),heltab2x36(:,:,205))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(218),h0tab(:,218),[16,1,2,12],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,206),heltab2x36(:,:,206))
  call Hloop_Q_A(ntryL,G0H12(64),16,0,G1H12(93),n2h12(18))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(219),h0tab(:,219),[16,1,2,12],[0,nMZ,0,0],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,207),heltab2x36(:,:,207))
  call Hloop_Q_A(ntryL,G0H12(64),16,0,G1H12(94),n2h12(19))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(220),h0tab(:,220),[16,1,2,12],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,208),heltab2x36(:,:,208))
  call Hloop_Q_A(ntryL,G0H12(64),16,0,G1H12(95),n2h12(20))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(221),h0tab(:,221),[16,1,2,12],[0,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,209),heltab2x36(:,:,209))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(222),h0tab(:,222),[16,1,2,12],[nMW,0,nMZ,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(65),m3h3x12(:,210),heltab2x36(:,:,210))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(223),h0tab(:,223),[16,1,2,12],[nMZ,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(66),m3h3x12(:,211),heltab2x36(:,:,211))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(224),h0tab(:,224),[16,1,2,12],[0,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(96),m3h3x12(:,212),heltab2x36(:,:,212))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(225),h0tab(:,225),[16,1,2,12],[nMZ,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(97),m3h3x12(:,213),heltab2x36(:,:,213))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(226),h0tab(:,226),[16,2,1,12],[0,0,nMW,nMW],4,1,wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(67),m3h3x12(:,214),heltab2x36(:,:,214))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(227),h0tab(:,227),[16,2,1,12],[nMW,0,nMZ,nMH],4,1,wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(68),m3h3x12(:,215),heltab2x36(:,:,215))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(228),h0tab(:,228),[16,2,1,12],[nMZ,0,nMW,nMW],4,1,wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(69),m3h3x12(:,216),heltab2x36(:,:,216))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(229),h0tab(:,229),[16,2,1,12],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,217),heltab2x36(:,:,217))
  call Hloop_A_Q(ntryL,G0H12(70),16,0,G1H12(98),n2h12(21))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(230),h0tab(:,230),[16,2,1,12],[0,nMZ,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,218),heltab2x36(:,:,218))
  call Hloop_A_Q(ntryL,G0H12(70),16,0,G1H12(99),n2h12(22))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(231),h0tab(:,231),[16,2,1,12],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,219),heltab2x36(:,:,219))
  call Hloop_A_Q(ntryL,G0H12(70),16,0,G1H12(100),n2h12(23))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(232),h0tab(:,232),[16,2,1,12],[0,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,220),heltab2x36(:,:,220))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(233),h0tab(:,233),[16,2,1,12],[nMW,0,nMZ,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(71),m3h3x12(:,221),heltab2x36(:,:,221))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(234),h0tab(:,234),[16,2,1,12],[nMZ,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,222),heltab2x36(:,:,222))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(235),h0tab(:,235),[16,2,1,12],[0,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(101),m3h3x12(:,223),heltab2x36(:,:,223))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(236),h0tab(:,236),[16,2,1,12],[nMZ,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(102),m3h3x12(:,224),heltab2x36(:,:,224))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(237),h0tab(:,237),[16,1,12,2],[0,0,0,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(103),m3h3x12(:,225),heltab2x36(:,:,225))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(238),h0tab(:,238),[16,1,12,2],[nMW,0,0,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(104),m3h3x12(:,226),heltab2x36(:,:,226))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(239),h0tab(:,239),[16,1,12,2],[nMZ,0,0,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(105),m3h3x12(:,227),heltab2x36(:,:,227))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(240),h0tab(:,240),[16,1,12,2],[nMW,0,0,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(106),m3h3x12(:,228),heltab2x36(:,:,228))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(241),h0tab(:,241),[17,4,2,8],[nMZ,nMZ,0,0],4,1,wf6(:,6))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,6),G0H6(1),ngZd,m3h6x6(:,1),heltab2x36(:,:,229))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(242),h0tab(:,242),[17,4,2,8],[nMW,nMW,0,0],4,1,wf6(:,6))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,6),G0H6(2),m3h6x6(:,2),heltab2x36(:,:,230))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(243),h0tab(:,243),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,3),heltab2x36(:,:,231))
  call Hloop_A_Q(ntryL,G0H6(3),17,0,G1H6(7),n2h6(73))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(244),h0tab(:,244),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,4),heltab2x36(:,:,232))
  call Hloop_A_Q(ntryL,G0H6(3),17,0,G1H6(8),n2h6(74))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(245),h0tab(:,245),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,5),heltab2x36(:,:,233))
  call Hloop_A_Q(ntryL,G0H6(3),17,0,G1H6(10),n2h6(75))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(246),h0tab(:,246),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,6),heltab2x36(:,:,234))
  call Hloop_A_Q(ntryL,G0H6(3),17,0,G1H6(11),n2h6(76))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(247),h0tab(:,247),[18,4,1,8],[nMZ,nMZ,0,0],4,1,wf6(:,8))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,8),G0H6(3),ngZu,m3h6x6(:,7),heltab2x36(:,:,235))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(248),h0tab(:,248),[18,4,1,8],[nMW,nMW,0,0],4,1,wf6(:,8))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,8),G0H6(4),m3h6x6(:,8),heltab2x36(:,:,236))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(249),h0tab(:,249),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,9),heltab2x36(:,:,237))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(12),n2h6(77))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(250),h0tab(:,250),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,10),heltab2x36(:,:,238))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(13),n2h6(78))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(251),h0tab(:,251),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,11),heltab2x36(:,:,239))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(14),n2h6(79))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(252),h0tab(:,252),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,12),heltab2x36(:,:,240))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(16),n2h6(80))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(253),h0tab(:,253),[20,2,1,8],[0,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(107),m3h3x12(:,229),heltab2x36(:,:,241))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(254),h0tab(:,254),[20,2,1,8],[nMW,0,nMZ,nMH],4,1,wf3(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(108),m3h3x12(:,230),heltab2x36(:,:,242))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(255),h0tab(:,255),[20,2,1,8],[nMZ,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(109),m3h3x12(:,231),heltab2x36(:,:,243))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(256),h0tab(:,256),[20,2,1,8],[0,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(73),m3h3x12(:,232),heltab2x36(:,:,244))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(257),h0tab(:,257),[20,2,1,8],[nMZ,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(74),m3h3x12(:,233),heltab2x36(:,:,245))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(258),h0tab(:,258),[20,2,1,8],[0,0,0,0],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(75),m3h3x12(:,234),heltab2x36(:,:,246))
  call Hloop_A_Q(ntryL,G0H12(75),20,0,G1H12(110),n2h12(24))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(259),h0tab(:,259),[20,2,1,8],[0,nMZ,0,0],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(75),m3h3x12(:,235),heltab2x36(:,:,247))
  call Hloop_A_Q(ntryL,G0H12(75),20,0,G1H12(111),n2h12(25))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(260),h0tab(:,260),[20,2,1,8],[0,0,0,0],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(75),m3h3x12(:,236),heltab2x36(:,:,248))
  call Hloop_A_Q(ntryL,G0H12(75),20,0,G1H12(112),n2h12(26))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(261),h0tab(:,261),[20,2,1,8],[0,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(75),m3h3x12(:,237),heltab2x36(:,:,249))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(262),h0tab(:,262),[20,2,1,8],[nMW,0,nMZ,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(76),m3h3x12(:,238),heltab2x36(:,:,250))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(263),h0tab(:,263),[20,2,1,8],[nMZ,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(77),m3h3x12(:,239),heltab2x36(:,:,251))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(264),h0tab(:,264),[20,2,1,8],[0,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(113),m3h3x12(:,240),heltab2x36(:,:,252))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(265),h0tab(:,265),[20,2,1,8],[nMZ,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(114),m3h3x12(:,241),heltab2x36(:,:,253))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(266),h0tab(:,266),[20,1,2,8],[0,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(115),m3h3x12(:,242),heltab2x36(:,:,254))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(267),h0tab(:,267),[20,1,2,8],[nMW,0,nMZ,nMH],4,1,wf3(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(116),m3h3x12(:,243),heltab2x36(:,:,255))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(268),h0tab(:,268),[20,1,2,8],[nMZ,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(117),m3h3x12(:,244),heltab2x36(:,:,256))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(269),h0tab(:,269),[20,1,2,8],[0,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(78),m3h3x12(:,245),heltab2x36(:,:,257))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(270),h0tab(:,270),[20,1,2,8],[nMZ,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(79),m3h3x12(:,246),heltab2x36(:,:,258))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(271),h0tab(:,271),[20,1,2,8],[0,0,0,0],4,1,wf3(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(80),m3h3x12(:,247),heltab2x36(:,:,259))
  call Hloop_Q_A(ntryL,G0H12(80),20,0,G1H12(118),n2h12(27))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(272),h0tab(:,272),[20,1,2,8],[0,nMZ,0,0],4,1,wf3(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(80),m3h3x12(:,248),heltab2x36(:,:,260))
  call Hloop_Q_A(ntryL,G0H12(80),20,0,G1H12(119),n2h12(28))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(273),h0tab(:,273),[20,1,2,8],[0,0,0,0],4,1,wf3(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(80),m3h3x12(:,249),heltab2x36(:,:,261))
  call Hloop_Q_A(ntryL,G0H12(80),20,0,G1H12(120),n2h12(29))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(274),h0tab(:,274),[20,1,2,8],[0,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(80),m3h3x12(:,250),heltab2x36(:,:,262))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(275),h0tab(:,275),[20,1,2,8],[nMW,0,nMZ,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(81),m3h3x12(:,251),heltab2x36(:,:,263))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(276),h0tab(:,276),[20,1,2,8],[nMZ,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(82),m3h3x12(:,252),heltab2x36(:,:,264))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(277),h0tab(:,277),[20,1,2,8],[0,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(121),m3h3x12(:,253),heltab2x36(:,:,265))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(278),h0tab(:,278),[20,1,2,8],[nMZ,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(122),m3h3x12(:,254),heltab2x36(:,:,266))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(279),h0tab(:,279),[20,1,8,2],[0,0,0,nMW],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(83),m3h3x12(:,255),heltab2x36(:,:,267))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(280),h0tab(:,280),[20,1,8,2],[nMW,0,0,0],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(84),m3h3x12(:,256),heltab2x36(:,:,268))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(281),h0tab(:,281),[20,1,8,2],[nMZ,0,0,nMW],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(85),m3h3x12(:,257),heltab2x36(:,:,269))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(282),h0tab(:,282),[20,1,8,2],[nMW,0,0,nMZ],4,1,wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(86),m3h3x12(:,258),heltab2x36(:,:,270))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(283),h0tab(:,283),[20,1,8,2],[0,0,0,nMW],4,1,wf3(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(123),m3h3x12(:,259),heltab2x36(:,:,271))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(284),h0tab(:,284),[20,1,8,2],[nMW,0,0,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(124),m3h3x12(:,260),heltab2x36(:,:,272))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(285),h0tab(:,285),[20,1,8,2],[nMZ,0,0,nMW],4,1,wf3(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(125),m3h3x12(:,261),heltab2x36(:,:,273))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(286),h0tab(:,286),[20,1,8,2],[nMW,0,0,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(126),m3h3x12(:,262),heltab2x36(:,:,274))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(287),h0tab(:,287),[24,2,1,4],[0,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(5),m3h9x4(:,1),heltab2x36(:,:,275))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(288),h0tab(:,288),[24,2,1,4],[nMW,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(6),m3h9x4(:,2),heltab2x36(:,:,276))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(289),h0tab(:,289),[24,2,1,4],[nMZ,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(7),m3h9x4(:,3),heltab2x36(:,:,277))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(290),h0tab(:,290),[24,2,1,4],[nMW,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(7),m3h9x4(:,4),heltab2x36(:,:,278))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(291),h0tab(:,291),[24,2,1,4],[0,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(8),m3h9x4(:,5),heltab2x36(:,:,279))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(292),h0tab(:,292),[24,2,1,4],[nMZ,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(9),m3h9x4(:,6),heltab2x36(:,:,280))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(293),h0tab(:,293),[24,2,1,4],[0,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(10),m3h9x4(:,7),heltab2x36(:,:,281))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(294),h0tab(:,294),[24,2,1,4],[nMZ,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(11),m3h9x4(:,8),heltab2x36(:,:,282))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(295),h0tab(:,295),[24,2,1,4],[nMW,0,nMZ,nMZ],4,1,wf9(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(8),m3h9x4(:,9),heltab2x36(:,:,283))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(296),h0tab(:,296),[24,2,1,4],[0,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(9),m3h9x4(:,10),heltab2x36(:,:,284))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(297),h0tab(:,297),[24,2,1,4],[nMZ,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(10),m3h9x4(:,11),heltab2x36(:,:,285))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(298),h0tab(:,298),[24,1,2,4],[0,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(11),m3h9x4(:,12),heltab2x36(:,:,286))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(299),h0tab(:,299),[24,1,2,4],[nMW,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(12),m3h9x4(:,13),heltab2x36(:,:,287))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(300),h0tab(:,300),[24,1,2,4],[nMZ,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(13),m3h9x4(:,14),heltab2x36(:,:,288))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(301),h0tab(:,301),[24,1,2,4],[nMW,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(12),m3h9x4(:,15),heltab2x36(:,:,289))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(302),h0tab(:,302),[24,1,2,4],[0,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(13),m3h9x4(:,16),heltab2x36(:,:,290))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(303),h0tab(:,303),[24,1,2,4],[nMZ,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(14),m3h9x4(:,17),heltab2x36(:,:,291))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(304),h0tab(:,304),[24,1,2,4],[0,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(15),m3h9x4(:,18),heltab2x36(:,:,292))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(305),h0tab(:,305),[24,1,2,4],[nMZ,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(16),m3h9x4(:,19),heltab2x36(:,:,293))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(306),h0tab(:,306),[24,1,2,4],[nMW,0,nMZ,nMZ],4,1,wf9(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(14),m3h9x4(:,20),heltab2x36(:,:,294))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(307),h0tab(:,307),[24,1,2,4],[0,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(15),m3h9x4(:,21),heltab2x36(:,:,295))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(308),h0tab(:,308),[24,1,2,4],[nMZ,0,nMW,nMW],4,1,wf9(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(16),m3h9x4(:,22),heltab2x36(:,:,296))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(309),h0tab(:,309),[24,1,4,2],[0,nMZ,nMZ,0],4,1,wf9(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(17),m3h9x4(:,23),heltab2x36(:,:,297))
  call Hloop_Q_A(ntryL,G0H4(17),24,0,G1H4(17),n2h4(1))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(116),[G1H12(5),G0H12(81),G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(117),[G1H12(11),G0H12(82),G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(108),[G1H12(17),G0H12(76),G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(109),[G1H12(23),G0H12(77),G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(15),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(35),[G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G0H4(7),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G0H4(8),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G0H4(9),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G0H4(12),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G0H4(13),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G0H4(14),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(107),[G0H12(75),G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(115),[G0H12(80),G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(95),[G1H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(100),[G1H12(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(113),[G0H12(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(114),[G0H12(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(112),[G1H12(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(121),[G0H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(122),[G0H12(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(120),[G1H12(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(123),[G0H12(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(124),[G0H12(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(125),[G0H12(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(126),[G0H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G0H4(16)])
  call Hloop_WA_Q(ntryL,G1H12(116),ex1(:),G1H6(17),m3h2x6(:,69),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(17),21,0,G2H6(18),n2h6(81))
  call Hloop_ZA_Q(ntryL,G1H12(117),ex1(:),G1H6(18),ngZu,m3h2x6(:,70),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H6(18),21,0,G2H6(19),n2h6(82))
  call Hloop_WQ_A(ntryL,G1H12(108),ex2(:),G1H6(20),m3h2x6(:,71),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H6(20),22,0,G2H6(20),n2h6(83))
  call Hloop_ZQ_A(ntryL,G1H12(109),ex2(:),G1H6(21),ngZd,m3h2x6(:,72),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G1H6(21),22,0,G2H6(21),n2h6(84))
  call Hloop_QZ_A(ntryL,G1H6(4),ex4(:),G1H2(1),ngZu,m3h3x2(:,29),heltab2x6(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(1),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H6(15),ex4(:),G1H2(1),ngZd,m3h3x2(:,30),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(2),n2h2(30))
  call Hloop_AZ_Q(ntryL,G1H6(22),ex4(:),G1H2(1),ngZd,m3h3x2(:,31),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(3),n2h2(31))
  call Hloop_AZ_Q(ntryL,G1H6(35),ex4(:),G1H2(1),ngZu,m3h3x2(:,32),heltab2x6(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(4),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(8),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(5),n2h2(33))
  call Hloop_VQ_A(ntryL,G1H4(9),ex2(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(7),n2h2(34))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex2(:),G1H2(1),ngZd,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(8),n2h2(35))
  call Hloop_WA_Q(ntryL,G1H4(14),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(9),n2h2(36))
  call Hloop_VA_Q(ntryL,G1H4(15),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(11),n2h2(37))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex1(:),G1H2(1),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(12),n2h2(38))
  call Hloop_VQ_A(ntryL,G1H12(107),ex2(:),G1H6(23),m3h2x6(:,73),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G1H6(23),22,0,G2H6(22),n2h6(85))
  call Hloop_VA_Q(ntryL,G1H12(115),ex1(:),G1H6(24),m3h2x6(:,74),heltab2x12(:,:,88))
  call Hloop_A_Q(ntryL,G1H6(24),21,0,G2H6(23),n2h6(86))
  call Hloop_VA_Q(ntryL,G0H12(10),ex1(:),G0H6(5),m3h2x6(:,75),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(25),n2h6(87))
  call Hloop_WA_Q(ntryL,G0H12(11),ex1(:),G0H6(5),m3h2x6(:,76),heltab2x12(:,:,90))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(26),n2h6(88))
  call Hloop_ZA_Q(ntryL,G0H12(12),ex1(:),G0H6(5),ngZu,m3h2x6(:,77),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(27),n2h6(89))
  call Hloop_VQ_A(ntryL,G0H12(13),ex2(:),G0H6(5),m3h2x6(:,78),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(30),n2h6(90))
  call Hloop_WQ_A(ntryL,G0H12(14),ex2(:),G0H6(5),m3h2x6(:,79),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(31),n2h6(91))
  call Hloop_ZQ_A(ntryL,G0H12(15),ex2(:),G0H6(5),ngZd,m3h2x6(:,80),heltab2x12(:,:,94))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(32),n2h6(92))
  call Hloop_QW_A(ntryL,G1H12(27),wf4(:,1),G1H3(25),m3h4x3(:,1),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H3(25),19,nML,G2H3(17),n2h3(11))
  call Hloop_AW_Q(ntryL,G1H12(28),wf4(:,1),G1H3(26),m3h4x3(:,2),heltab2x12(:,:,96))
  call Hloop_A_Q(ntryL,G1H3(26),19,nMT,G2H3(18),n2h3(12))
  call Hloop_QW_A(ntryL,G1H12(29),wf4(:,1),G1H3(6),m3h4x3(:,3),heltab2x12(:,:,97))
  call Hloop_Q_A(ntryL,G1H3(6),19,nMB,G2H3(19),n2h3(13))
  call Hloop_SV_T(ntryL,G1H12(30),16,wf4(:,1),3,G2H3(20),m3h4x3(:,4),heltab2x12(:,:,98))
  call Hloop_SV_T(ntryL,G1H12(1),16,wf4(:,1),3,G2H3(1),m3h4x3(:,5),heltab2x12(:,:,99))
  call Hloop_TV_S(ntryL,G1H12(2),16,wf4(:,1),3,G2H3(2),m3h4x3(:,6),heltab2x12(:,:,100))
  call Hloop_TV_S(ntryL,G1H12(3),16,wf4(:,1),3,G2H3(3),m3h4x3(:,7),heltab2x12(:,:,101))
  call Hloop_CV_D(ntryL,G1H12(4),16,wf4(:,1),3,G2H3(4),m3h4x3(:,8),heltab2x12(:,:,102))
  call Hloop_CV_D(ntryL,G1H12(6),16,wf4(:,1),3,G2H3(5),m3h4x3(:,9),heltab2x12(:,:,103))
  call Hloop_DV_C(ntryL,G1H12(7),16,wf4(:,1),G2H3(6),m3h4x3(:,10),heltab2x12(:,:,104))
  call Hloop_DV_C(ntryL,G1H12(8),16,wf4(:,1),G2H3(7),m3h4x3(:,11),heltab2x12(:,:,105))
  call Hloop_UW_V(ntryL,G1H12(9),16,wf4(:,1),3,G2H3(8),m3h4x3(:,12),heltab2x12(:,:,106))
  call Hloop_UW_V(ntryL,G1H12(10),16,wf4(:,1),3,G2H3(9),m3h4x3(:,13),heltab2x12(:,:,107))
  call Hloop_VV_S(ntryL,G0H12(19),wf4(:,1),G0H3(1),m3h4x3(:,14),heltab2x12(:,:,108))
  call Hloop_VV_S(ntryL,G0H12(20),wf4(:,1),G0H3(2),m3h4x3(:,15),heltab2x12(:,:,109))
  call Hloop_SV_V(ntryL,G1H12(12),wf4(:,1),G1H3(7),m3h4x3(:,16),heltab2x12(:,:,110))
  call Hloop_SV_V(ntryL,G1H12(13),wf4(:,1),G1H3(10),m3h4x3(:,17),heltab2x12(:,:,111))
  call Hloop_SV_T(ntryL,G0H12(21),16,wf4(:,1),3,G1H3(37),m3h4x3(:,18),heltab2x12(:,:,112))
  call Hloop_TV_S(ntryL,G0H12(22),16,wf4(:,1),3,G1H3(38),m3h4x3(:,19),heltab2x12(:,:,113))
  call Hloop_SV_T(ntryL,G1H12(14),16,wf4(:,1),3,G2H3(10),m3h4x3(:,20),heltab2x12(:,:,114))
  call Hloop_TV_S(ntryL,G1H12(15),16,wf4(:,1),3,G2H3(11),m3h4x3(:,21),heltab2x12(:,:,115))
  call Hloop_TV_S(ntryL,G1H12(16),16,wf4(:,1),3,G2H3(13),m3h4x3(:,22),heltab2x12(:,:,116))
  call Hloop_UW_V(ntryL,G0H12(23),16,wf4(:,1),3,G1H3(12),m3h4x3(:,23),heltab2x12(:,:,117))
  call Hloop_UV_W(ntryL,G0H12(24),16,wf4(:,1),3,G1H3(42),m3h4x3(:,24),heltab2x12(:,:,118))
  call Hloop_UW_V(ntryL,G0H12(25),16,wf4(:,1),3,G1H3(43),m3h4x3(:,25),heltab2x12(:,:,119))
  call Hloop_VV_S(ntryL,G1H12(18),wf4(:,1),G1H3(46),m3h4x3(:,26),heltab2x12(:,:,120))
  call Hloop_VV_S(ntryL,G1H12(19),wf4(:,1),G1H3(21),m3h4x3(:,27),heltab2x12(:,:,121))
  call Hloop_VV_S(ntryL,G1H12(20),wf4(:,1),G1H3(22),m3h4x3(:,28),heltab2x12(:,:,122))
  call Hloop_SV_V(ntryL,G0H12(26),wf4(:,1),G0H3(3),m3h4x3(:,29),heltab2x12(:,:,123))
  call Hloop_VV_S(ntryL,G0H12(27),wf4(:,1),G0H3(4),m3h4x3(:,30),heltab2x12(:,:,124))
  call Hloop_VV_S(ntryL,G0H12(28),wf4(:,1),G0H3(5),m3h4x3(:,31),heltab2x12(:,:,125))
  call Hloop_SV_V(ntryL,G1H12(21),wf4(:,1),G1H3(49),m3h4x3(:,32),heltab2x12(:,:,126))
  call Hloop_SV_T(ntryL,G0H12(29),16,wf4(:,1),3,G1H3(32),m3h4x3(:,33),heltab2x12(:,:,127))
  call Hloop_TV_S(ntryL,G0H12(30),16,wf4(:,1),3,G1H3(4),m3h4x3(:,34),heltab2x12(:,:,128))
  call Hloop_UW_V(ntryL,G1H12(22),16,wf4(:,1),3,G2H3(14),m3h4x3(:,35),heltab2x12(:,:,129))
  call Hloop_UW_V(ntryL,G1H12(24),16,wf4(:,1),3,G2H3(16),m3h4x3(:,36),heltab2x12(:,:,130))
  call Hloop_UW_V(ntryL,G0H12(1),16,wf4(:,1),3,G1H3(5),m3h4x3(:,37),heltab2x12(:,:,131))
  call Hloop_UW_V(ntryL,G0H12(31),16,wf4(:,1),3,G1H3(59),m3h4x3(:,38),heltab2x12(:,:,132))
  call Hloop_VV_S(ntryL,G1H12(25),wf4(:,1),G1H3(60),m3h4x3(:,39),heltab2x12(:,:,133))
  call Hloop_VV_S(ntryL,G1H12(26),wf4(:,1),G1H3(61),m3h4x3(:,40),heltab2x12(:,:,134))
  call Hloop_VV_S(ntryL,G1H12(31),wf4(:,1),G1H3(65),m3h4x3(:,41),heltab2x12(:,:,135))
  call Hloop_SV_V(ntryL,G0H12(3),wf4(:,1),G0H3(6),m3h4x3(:,42),heltab2x12(:,:,136))
  call Hloop_QW_A(ntryL,G1H12(32),wf4(:,1),G1H3(66),m3h4x3(:,43),heltab2x12(:,:,137))
  call Hloop_Q_A(ntryL,G1H3(66),19,nML,G2H3(21),n2h3(14))
  call Hloop_AW_Q(ntryL,G1H12(33),wf4(:,1),G1H3(67),m3h4x3(:,44),heltab2x12(:,:,138))
  call Hloop_A_Q(ntryL,G1H3(67),19,nMT,G2H3(23),n2h3(15))
  call Hloop_QW_A(ntryL,G1H12(34),wf4(:,1),G1H3(71),m3h4x3(:,45),heltab2x12(:,:,139))
  call Hloop_Q_A(ntryL,G1H3(71),19,nMB,G2H3(24),n2h3(16))
  call Hloop_SV_T(ntryL,G1H12(35),16,wf4(:,1),3,G2H3(26),m3h4x3(:,46),heltab2x12(:,:,140))
  call Hloop_SV_T(ntryL,G1H12(36),16,wf4(:,1),3,G2H3(27),m3h4x3(:,47),heltab2x12(:,:,141))
  call Hloop_TV_S(ntryL,G1H12(37),16,wf4(:,1),3,G2H3(29),m3h4x3(:,48),heltab2x12(:,:,142))
  call Hloop_TV_S(ntryL,G1H12(38),16,wf4(:,1),3,G2H3(30),m3h4x3(:,49),heltab2x12(:,:,143))
  call Hloop_CV_D(ntryL,G1H12(39),16,wf4(:,1),3,G2H3(32),m3h4x3(:,50),heltab2x12(:,:,144))
  call Hloop_CV_D(ntryL,G1H12(40),16,wf4(:,1),3,G2H3(33),m3h4x3(:,51),heltab2x12(:,:,145))
  call Hloop_DV_C(ntryL,G1H12(41),16,wf4(:,1),G2H3(35),m3h4x3(:,52),heltab2x12(:,:,146))
  call Hloop_DV_C(ntryL,G1H12(42),16,wf4(:,1),G2H3(36),m3h4x3(:,53),heltab2x12(:,:,147))
  call Hloop_UW_V(ntryL,G1H12(43),16,wf4(:,1),3,G2H3(38),m3h4x3(:,54),heltab2x12(:,:,148))
  call Hloop_UW_V(ntryL,G1H12(44),16,wf4(:,1),3,G2H3(39),m3h4x3(:,55),heltab2x12(:,:,149))
  call Hloop_VV_S(ntryL,G0H12(18),wf4(:,1),G0H3(7),m3h4x3(:,56),heltab2x12(:,:,150))
  call Hloop_VV_S(ntryL,G0H12(2),wf4(:,1),G0H3(8),m3h4x3(:,57),heltab2x12(:,:,151))
  call Hloop_SV_T(ntryL,G0H12(16),16,wf4(:,1),3,G1H3(72),m3h4x3(:,58),heltab2x12(:,:,152))
  call Hloop_TV_S(ntryL,G0H12(17),16,wf4(:,1),3,G1H3(73),m3h4x3(:,59),heltab2x12(:,:,153))
  call Hloop_SV_V(ntryL,G1H12(45),wf4(:,1),G1H3(77),m3h4x3(:,60),heltab2x12(:,:,154))
  call Hloop_SV_V(ntryL,G1H12(46),wf4(:,1),G1H3(78),m3h4x3(:,61),heltab2x12(:,:,155))
  call Hloop_SV_T(ntryL,G1H12(47),16,wf4(:,1),3,G2H3(40),m3h4x3(:,62),heltab2x12(:,:,156))
  call Hloop_TV_S(ntryL,G1H12(48),16,wf4(:,1),3,G2H3(41),m3h4x3(:,63),heltab2x12(:,:,157))
  call Hloop_TV_S(ntryL,G1H12(49),16,wf4(:,1),3,G2H3(42),m3h4x3(:,64),heltab2x12(:,:,158))
  call Hloop_VV_S(ntryL,G1H12(50),wf4(:,1),G1H3(79),m3h4x3(:,65),heltab2x12(:,:,159))
  call Hloop_VV_S(ntryL,G1H12(51),wf4(:,1),G1H3(83),m3h4x3(:,66),heltab2x12(:,:,160))
  call Hloop_VV_S(ntryL,G1H12(52),wf4(:,1),G1H3(48),m3h4x3(:,67),heltab2x12(:,:,161))
  call Hloop_UW_V(ntryL,G0H12(32),16,wf4(:,1),3,G1H3(15),m3h4x3(:,68),heltab2x12(:,:,162))
  call Hloop_UV_W(ntryL,G0H12(33),16,wf4(:,1),3,G1H3(86),m3h4x3(:,69),heltab2x12(:,:,163))
  call Hloop_UW_V(ntryL,G0H12(34),16,wf4(:,1),3,G1H3(87),m3h4x3(:,70),heltab2x12(:,:,164))
  call Hloop_SV_V(ntryL,G0H12(35),wf4(:,1),G0H3(9),m3h4x3(:,71),heltab2x12(:,:,165))
  call Hloop_VV_S(ntryL,G0H12(36),wf4(:,1),G0H3(10),m3h4x3(:,72),heltab2x12(:,:,166))
  call Hloop_VV_S(ntryL,G0H12(37),wf4(:,1),G0H3(11),m3h4x3(:,73),heltab2x12(:,:,167))
  call Hloop_TV_S(ntryL,G0H12(38),16,wf4(:,1),3,G1H3(88),m3h4x3(:,74),heltab2x12(:,:,168))
  call Hloop_SV_V(ntryL,G1H12(53),wf4(:,1),G1H3(92),m3h4x3(:,75),heltab2x12(:,:,169))
  call Hloop_SV_V(ntryL,G1H12(54),wf4(:,1),G1H3(93),m3h4x3(:,76),heltab2x12(:,:,170))
  call Hloop_UW_V(ntryL,G1H12(55),16,wf4(:,1),3,G2H3(43),m3h4x3(:,77),heltab2x12(:,:,171))
  call Hloop_UW_V(ntryL,G1H12(56),16,wf4(:,1),3,G2H3(44),m3h4x3(:,78),heltab2x12(:,:,172))
  call Hloop_VV_S(ntryL,G1H12(57),wf4(:,1),G1H3(94),m3h4x3(:,79),heltab2x12(:,:,173))
  call Hloop_VV_S(ntryL,G1H12(58),wf4(:,1),G1H3(98),m3h4x3(:,80),heltab2x12(:,:,174))
  call Hloop_UV_W(ntryL,G0H12(39),16,wf4(:,1),3,G1H3(99),m3h4x3(:,81),heltab2x12(:,:,175))
  call Hloop_UW_V(ntryL,G0H12(40),16,wf4(:,1),3,G1H3(100),m3h4x3(:,82),heltab2x12(:,:,176))
  call Hloop_UW_V(ntryL,G0H12(41),16,wf4(:,1),3,G1H3(104),m3h4x3(:,83),heltab2x12(:,:,177))
  call Hloop_SV_V(ntryL,G0H12(42),wf4(:,1),G0H3(12),m3h4x3(:,84),heltab2x12(:,:,178))
  call Hloop_AS_Q(ntryL,G1H12(59),ex3(:),G1H12(5),ngH,m3h1x12(:,11),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G1H12(5),20,nML,G2H12(1),n2h12(30))
  call Hloop_QS_A(ntryL,G1H12(60),ex3(:),G1H12(11),ngH,m3h1x12(:,12),heltab2x12(:,:,180))
  call Hloop_Q_A(ntryL,G1H12(11),20,nMT,G2H12(2),n2h12(31))
  call Hloop_AS_Q(ntryL,G1H12(61),ex3(:),G1H12(17),ngH,m3h1x12(:,13),heltab2x12(:,:,181))
  call Hloop_A_Q(ntryL,G1H12(17),20,nMB,G2H12(3),n2h12(32))
  call Hloop_SS_S(ntryL,G1H12(62),ex3(:),G1H12(23),m3h1x12(:,14),heltab2x12(:,:,182))
  call Hloop_SS_S(ntryL,G1H12(63),ex3(:),G1H12(93),m3h1x12(:,15),heltab2x12(:,:,183))
  call Hloop_SS_S(ntryL,G1H12(64),ex3(:),G1H12(98),m3h1x12(:,16),heltab2x12(:,:,184))
  call Hloop_SS_S(ntryL,G1H12(65),ex3(:),G1H12(110),m3h1x12(:,17),heltab2x12(:,:,185))
  call Hloop_SS_S(ntryL,G1H12(66),ex3(:),G1H12(118),m3h1x12(:,18),heltab2x12(:,:,186))
  call Hloop_SS_S(ntryL,G1H12(67),ex3(:),G1H12(116),m3h1x12(:,19),heltab2x12(:,:,187))
  call Hloop_VS_V(ntryL,G1H12(68),ex3(:),G1H12(117),m3h1x12(:,20),heltab2x12(:,:,188))
  call Hloop_SS_S(ntryL,G1H12(69),ex3(:),G1H12(108),m3h1x12(:,21),heltab2x12(:,:,189))
  call Hloop_SS_S(ntryL,G1H12(70),ex3(:),G1H12(109),m3h1x12(:,22),heltab2x12(:,:,190))
  call Hloop_SS_S(ntryL,G0H12(43),ex3(:),G0H12(81),m3h1x12(:,23),heltab2x12(:,:,191))
  call Hloop_SS_S(ntryL,G0H12(44),ex3(:),G0H12(8),m3h1x12(:,24),heltab2x12(:,:,192))
  call Hloop_ST_V(ntryL,G1H12(71),16,ex3(:),4,G2H12(4),m3h1x12(:,25),heltab2x12(:,:,193))
  call Hloop_ST_V(ntryL,G1H12(72),16,ex3(:),4,G2H12(5),m3h1x12(:,26),heltab2x12(:,:,194))
  call Hloop_VT_S(ntryL,G0H12(45),16,ex3(:),4,G1H12(107),m3h1x12(:,27),heltab2x12(:,:,195))
  call Hloop_VT_S(ntryL,G0H12(46),16,ex3(:),4,G1H12(115),m3h1x12(:,28),heltab2x12(:,:,196))
  call Hloop_SS_S(ntryL,G0H12(47),ex3(:),G0H12(82),m3h1x12(:,29),heltab2x12(:,:,197))
  call Hloop_ST_V(ntryL,G1H12(73),16,ex3(:),4,G2H12(6),m3h1x12(:,30),heltab2x12(:,:,198))
  call Hloop_ST_V(ntryL,G1H12(74),16,ex3(:),4,G2H12(7),m3h1x12(:,31),heltab2x12(:,:,199))
  call Hloop_ST_V(ntryL,G0H12(48),16,ex3(:),4,G1H12(27),m3h1x12(:,32),heltab2x12(:,:,200))
  call Hloop_VT_S(ntryL,G0H12(49),16,ex3(:),4,G1H12(28),m3h1x12(:,33),heltab2x12(:,:,201))
  call Hloop_VT_S(ntryL,G1H12(75),16,ex3(:),4,G2H12(8),m3h1x12(:,34),heltab2x12(:,:,202))
  call Hloop_VT_S(ntryL,G1H12(76),16,ex3(:),4,G2H12(9),m3h1x12(:,35),heltab2x12(:,:,203))
  call Hloop_VS_V(ntryL,G0H12(50),ex3(:),G0H12(9),m3h1x12(:,36),heltab2x12(:,:,204))
  call Hloop_VS_V(ntryL,G0H12(51),ex3(:),G0H12(76),m3h1x12(:,37),heltab2x12(:,:,205))
  call Hloop_VS_V(ntryL,G0H12(52),ex3(:),G0H12(5),m3h1x12(:,38),heltab2x12(:,:,206))
  call Hloop_VS_V(ntryL,G1H12(77),ex3(:),G1H12(29),m3h1x12(:,39),heltab2x12(:,:,207))
  call Hloop_VS_V(ntryL,G1H12(78),ex3(:),G1H12(30),m3h1x12(:,40),heltab2x12(:,:,208))
  call Hloop_AQ_Z(ntryL,G1H12(79),ex2(:),G1H6(33),ngZd,m3h2x6(:,81),heltab2x12(:,:,209))
  call Hloop_ST_V(ntryL,G0H12(53),16,ex3(:),4,G1H12(1),m3h1x12(:,41),heltab2x12(:,:,210))
  call Hloop_ST_V(ntryL,G0H12(54),16,ex3(:),4,G1H12(2),m3h1x12(:,42),heltab2x12(:,:,211))
  call Hloop_VS_V(ntryL,G1H12(80),ex3(:),G1H12(3),m3h1x12(:,43),heltab2x12(:,:,212))
  call Hloop_VS_V(ntryL,G1H12(81),ex3(:),G1H12(4),m3h1x12(:,44),heltab2x12(:,:,213))
  call Hloop_VS_V(ntryL,G1H12(82),ex3(:),G1H12(6),m3h1x12(:,45),heltab2x12(:,:,214))
  call Hloop_VQ_A(ntryL,G0H12(55),ex2(:),G0H6(5),m3h2x6(:,82),heltab2x12(:,:,215))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(34),n2h6(93))
  call Hloop_ZQ_A(ntryL,G0H12(56),ex2(:),G0H6(5),ngZd,m3h2x6(:,83),heltab2x12(:,:,216))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(36),n2h6(94))
  call Hloop_WQ_A(ntryL,G1H12(83),ex2(:),G1H6(37),m3h2x6(:,84),heltab2x12(:,:,217))
  call Hloop_Q_A(ntryL,G1H6(37),18,0,G2H6(1),n2h6(95))
  call Hloop_VQ_A(ntryL,G1H12(84),ex2(:),G1H6(38),m3h2x6(:,85),heltab2x12(:,:,218))
  call Hloop_Q_A(ntryL,G1H6(38),18,0,G2H6(2),n2h6(96))
  call Hloop_ZQ_A(ntryL,G1H12(85),ex2(:),G1H6(1),ngZd,m3h2x6(:,86),heltab2x12(:,:,219))
  call Hloop_Q_A(ntryL,G1H6(1),18,0,G2H6(4),n2h6(97))
  call Hloop_QA_Z(ntryL,G1H12(86),ex1(:),G1H6(19),ngZu,m3h2x6(:,87),heltab2x12(:,:,220))
  call Hloop_ST_V(ntryL,G0H12(57),16,ex3(:),4,G1H12(7),m3h1x12(:,46),heltab2x12(:,:,221))
  call Hloop_ST_V(ntryL,G0H12(58),16,ex3(:),4,G1H12(8),m3h1x12(:,47),heltab2x12(:,:,222))
  call Hloop_VS_V(ntryL,G1H12(87),ex3(:),G1H12(9),m3h1x12(:,48),heltab2x12(:,:,223))
  call Hloop_VS_V(ntryL,G1H12(88),ex3(:),G1H12(10),m3h1x12(:,49),heltab2x12(:,:,224))
  call Hloop_VS_V(ntryL,G1H12(89),ex3(:),G1H12(12),m3h1x12(:,50),heltab2x12(:,:,225))
  call Hloop_VA_Q(ntryL,G0H12(59),ex1(:),G0H6(5),m3h2x6(:,88),heltab2x12(:,:,226))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(9),n2h6(98))
  call Hloop_ZA_Q(ntryL,G0H12(60),ex1(:),G0H6(5),ngZu,m3h2x6(:,89),heltab2x12(:,:,227))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(28),n2h6(99))
  call Hloop_WA_Q(ntryL,G1H12(90),ex1(:),G1H6(17),m3h2x6(:,90),heltab2x12(:,:,228))
  call Hloop_A_Q(ntryL,G1H6(17),17,0,G2H6(5),n2h6(100))
  call Hloop_VA_Q(ntryL,G1H12(91),ex1(:),G1H6(18),m3h2x6(:,91),heltab2x12(:,:,229))
  call Hloop_A_Q(ntryL,G1H6(18),17,0,G2H6(6),n2h6(101))
  call Hloop_ZA_Q(ntryL,G1H12(92),ex1(:),G1H6(20),ngZu,m3h2x6(:,92),heltab2x12(:,:,230))
  call Hloop_A_Q(ntryL,G1H6(20),17,0,G2H6(8),n2h6(102))
  call Hloop_VA_Q(ntryL,G0H12(61),ex1(:),G0H6(5),m3h2x6(:,93),heltab2x12(:,:,231))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(21),n2h6(103))
  call Hloop_WA_Q(ntryL,G0H12(62),ex1(:),G0H6(5),m3h2x6(:,94),heltab2x12(:,:,232))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(4),n2h6(104))
  call Hloop_ZA_Q(ntryL,G0H12(63),ex1(:),G0H6(5),ngZu,m3h2x6(:,95),heltab2x12(:,:,233))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(15),n2h6(105))
  call Hloop_QA_V(ntryL,G1H12(95),ex1(:),G1H6(22),m3h2x6(:,96),heltab2x12(:,:,234))
  call Hloop_QA_Z(ntryL,G1H12(94),ex1(:),G1H6(35),ngZu,m3h2x6(:,97),heltab2x12(:,:,235))
  call Hloop_VA_Q(ntryL,G0H12(64),ex1(:),G0H6(5),m3h2x6(:,98),heltab2x12(:,:,236))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(23),n2h6(106))
  call Hloop_WA_Q(ntryL,G0H12(65),ex1(:),G0H6(5),m3h2x6(:,99),heltab2x12(:,:,237))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(24),n2h6(107))
  call Hloop_ZA_Q(ntryL,G0H12(66),ex1(:),G0H6(5),ngZu,m3h2x6(:,100),heltab2x12(:,:,238))
  call Hloop_A_Q(ntryL,G0H6(5),17,0,G1H6(37),n2h6(108))
  call Hloop_VA_Q(ntryL,G1H12(96),ex1(:),G1H6(38),m3h2x6(:,101),heltab2x12(:,:,239))
  call Hloop_A_Q(ntryL,G1H6(38),17,0,G2H6(9),n2h6(109))
  call Hloop_ZA_Q(ntryL,G1H12(97),ex1(:),G1H6(1),ngZu,m3h2x6(:,102),heltab2x12(:,:,240))
  call Hloop_A_Q(ntryL,G1H6(1),17,0,G2H6(10),n2h6(110))
  call Hloop_VQ_A(ntryL,G0H12(67),ex2(:),G0H6(5),m3h2x6(:,103),heltab2x12(:,:,241))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(17),n2h6(111))
  call Hloop_WQ_A(ntryL,G0H12(68),ex2(:),G0H6(5),m3h2x6(:,104),heltab2x12(:,:,242))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(18),n2h6(112))
  call Hloop_ZQ_A(ntryL,G0H12(69),ex2(:),G0H6(5),ngZd,m3h2x6(:,105),heltab2x12(:,:,243))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(20),n2h6(113))
  call Hloop_AQ_V(ntryL,G1H12(100),ex2(:),G1H6(38),m3h2x6(:,106),heltab2x12(:,:,244))
  call Hloop_AQ_Z(ntryL,G1H12(99),ex2(:),G1H6(1),ngZd,m3h2x6(:,107),heltab2x12(:,:,245))
  call Hloop_VQ_A(ntryL,G0H12(70),ex2(:),G0H6(5),m3h2x6(:,108),heltab2x12(:,:,246))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(40),n2h6(114))
  call Hloop_WQ_A(ntryL,G0H12(71),ex2(:),G0H6(5),m3h2x6(:,109),heltab2x12(:,:,247))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(41),n2h6(115))
  call Hloop_ZQ_A(ntryL,G0H12(72),ex2(:),G0H6(5),ngZd,m3h2x6(:,110),heltab2x12(:,:,248))
  call Hloop_Q_A(ntryL,G0H6(5),18,0,G1H6(42),n2h6(116))
  call Hloop_VQ_A(ntryL,G1H12(101),ex2(:),G1H6(43),m3h2x6(:,111),heltab2x12(:,:,249))
  call Hloop_Q_A(ntryL,G1H6(43),18,0,G2H6(12),n2h6(117))
  call Hloop_ZQ_A(ntryL,G1H12(102),ex2(:),G1H6(43),ngZd,m3h2x6(:,112),heltab2x12(:,:,250))
  call Hloop_Q_A(ntryL,G1H6(43),18,0,G2H6(13),n2h6(118))
  call Hloop_VA_Q(ntryL,G1H12(103),ex1(:),G1H6(43),m3h2x6(:,113),heltab2x12(:,:,251))
  call Hloop_A_Q(ntryL,G1H6(43),17,0,G2H6(14),n2h6(119))
  call Hloop_WA_Q(ntryL,G1H12(104),ex1(:),G1H6(43),m3h2x6(:,114),heltab2x12(:,:,252))
  call Hloop_A_Q(ntryL,G1H6(43),17,0,G2H6(16),n2h6(120))
  call Hloop_ZA_Q(ntryL,G1H12(105),ex1(:),G1H6(43),ngZu,m3h2x6(:,115),heltab2x12(:,:,253))
  call Hloop_A_Q(ntryL,G1H6(43),17,0,G2H6(17),n2h6(121))
  call Hloop_WA_Q(ntryL,G1H12(106),ex1(:),G1H6(43),m3h2x6(:,116),heltab2x12(:,:,254))
  call Hloop_A_Q(ntryL,G1H6(43),17,0,G2H6(24),n2h6(122))
  call Hloop_VS_V(ntryL,G0H6(1),ex3(:),G0H6(5),m3h1x6(:,9),heltab2x6(:,:,95))
  call Hloop_VS_V(ntryL,G0H6(2),ex3(:),G0H6(1),m3h1x6(:,10),heltab2x6(:,:,96))
  call Hloop_AQ_W(ntryL,G1H6(7),ex2(:),G1H3(25),m3h2x3(:,55),heltab2x6(:,:,97))
  call Hloop_AQ_W(ntryL,G1H6(8),ex2(:),G1H3(26),m3h2x3(:,56),heltab2x6(:,:,98))
  call Hloop_AQ_W(ntryL,G1H6(10),ex2(:),G1H3(6),m3h2x3(:,57),heltab2x6(:,:,99))
  call Hloop_AQ_W(ntryL,G1H6(11),ex2(:),G1H3(66),m3h2x3(:,58),heltab2x6(:,:,100))
  call Hloop_VS_V(ntryL,G0H6(3),ex3(:),G0H6(2),m3h1x6(:,11),heltab2x6(:,:,101))
  call Hloop_VS_V(ntryL,G0H6(4),ex3(:),G0H6(3),m3h1x6(:,12),heltab2x6(:,:,102))
  call Hloop_QA_W(ntryL,G1H6(12),ex1(:),G1H3(67),m3h2x3(:,59),heltab2x6(:,:,103))
  call Hloop_QA_W(ntryL,G1H6(13),ex1(:),G1H3(71),m3h2x3(:,60),heltab2x6(:,:,104))
  call Hloop_QA_W(ntryL,G1H6(14),ex1(:),G1H3(105),m3h2x3(:,61),heltab2x6(:,:,105))
  call Hloop_QA_W(ntryL,G1H6(16),ex1(:),G1H3(106),m3h2x3(:,62),heltab2x6(:,:,106))
  call Hloop_VQ_A(ntryL,G1H12(113),ex2(:),G1H6(43),m3h2x6(:,117),heltab2x12(:,:,255))
  call Hloop_Q_A(ntryL,G1H6(43),22,0,G2H6(25),n2h6(123))
  call Hloop_ZQ_A(ntryL,G1H12(114),ex2(:),G1H6(7),ngZd,m3h2x6(:,118),heltab2x12(:,:,256))
  call Hloop_Q_A(ntryL,G1H6(7),22,0,G2H6(26),n2h6(124))
  call Hloop_AQ_V(ntryL,G1H12(112),ex2(:),G1H6(8),m3h2x6(:,119),heltab2x12(:,:,257))
  call Hloop_AQ_Z(ntryL,G1H12(111),ex2(:),G1H6(10),ngZd,m3h2x6(:,120),heltab2x12(:,:,258))
  call Hloop_VA_Q(ntryL,G1H12(121),ex1(:),G1H6(11),m3h2x6(:,121),heltab2x12(:,:,259))
  call Hloop_A_Q(ntryL,G1H6(11),21,0,G2H6(27),n2h6(125))
  call Hloop_ZA_Q(ntryL,G1H12(122),ex1(:),G1H6(12),ngZu,m3h2x6(:,122),heltab2x12(:,:,260))
  call Hloop_A_Q(ntryL,G1H6(12),21,0,G2H6(28),n2h6(126))
  call Hloop_QA_V(ntryL,G1H12(120),ex1(:),G1H6(13),m3h2x6(:,123),heltab2x12(:,:,261))
  call Hloop_QA_Z(ntryL,G1H12(119),ex1(:),G1H6(14),ngZu,m3h2x6(:,124),heltab2x12(:,:,262))
  call Hloop_VA_Q(ntryL,G1H12(123),ex1(:),G1H6(16),m3h2x6(:,125),heltab2x12(:,:,263))
  call Hloop_A_Q(ntryL,G1H6(16),21,0,G2H6(29),n2h6(127))
  call Hloop_WA_Q(ntryL,G1H12(124),ex1(:),G1H6(43),m3h2x6(:,126),heltab2x12(:,:,264))
  call Hloop_A_Q(ntryL,G1H6(43),21,0,G2H6(30),n2h6(128))
  call Hloop_ZA_Q(ntryL,G1H12(125),ex1(:),G1H6(7),ngZu,m3h2x6(:,127),heltab2x12(:,:,265))
  call Hloop_A_Q(ntryL,G1H6(7),21,0,G2H6(31),n2h6(129))
  call Hloop_WA_Q(ntryL,G1H12(126),ex1(:),G1H6(11),m3h2x6(:,128),heltab2x12(:,:,266))
  call Hloop_A_Q(ntryL,G1H6(11),21,0,G2H6(32),n2h6(130))
  call Hloop_VQ_A(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(13),n2h2(39))
  call Hloop_WQ_A(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(15),n2h2(40))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex2(:),G1H2(1),ngZd,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),26,0,G2H2(16),n2h2(41))
  call Hloop_VA_Q(ntryL,G1H4(11),ex1(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(17),n2h2(42))
  call Hloop_WA_Q(ntryL,G1H4(12),ex1(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(19),n2h2(43))
  call Hloop_ZA_Q(ntryL,G1H4(13),ex1(:),G1H2(1),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),25,0,G2H2(20),n2h2(44))
  call Hloop_QA_Z(ntryL,G1H4(17),ex1(:),G1H2(1),ngZu,m3h2x2(:,13),heltab2x4(:,:,13))
call HGT_lower_alpha_OLR(G1H6(5),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(5),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(32),[G1H6(5)])
call HGT_lower_alpha_OLR(G1H6(6),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(6),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G1H6(6)])
call HGT_lower_alpha_OLR(G1H6(29),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(29),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(31),[G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(67),[G1H3(28),G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G1H3(39),G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G1H3(45),G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(106),[G1H3(35),G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(20),G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(52),G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(25),[G1H3(44),G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(66),[G1H3(51),G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(42),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G0H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(60),[G1H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G0H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(83),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(86),[G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G0H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(99),[G1H3(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(115),[G1H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(107),[G1H12(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(6),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G0H12(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G1H12(8)])
call HGT_lower_alpha_w2_OLR(G1H4(1),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(1),ex1(:),G1H2(2),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(2),29,0,G2H2(21),n2h2(45))
  call Hloop_AQ_Z(ntryL,G2H6(3),ex2(:),G2H3(45),ngZd,m3h2x3(:,63),heltab2x6(:,:,107))
call HGT_lower_alpha_w2_OLR(G1H4(2),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(2),ex1(:),G1H2(2),ngZu,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(2),29,0,G2H2(23),n2h2(46))
  call Hloop_AQ_W(ntryL,G2H6(7),ex2(:),G2H3(46),m3h2x3(:,64),heltab2x6(:,:,108))
call HGT_lower_alpha_w2_OLR(G1H4(3),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(3),ex2(:),G1H2(2),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(2),30,0,G2H2(24),n2h2(47))
  call Hloop_QA_Z(ntryL,G2H6(11),ex1(:),G2H3(47),ngZu,m3h2x3(:,65),heltab2x6(:,:,109))
call HGT_lower_alpha_w2_OLR(G1H4(4),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(4),ex2(:),G1H2(2),ngZd,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(2),30,0,G2H2(25),n2h2(48))
  call Hloop_QA_W(ntryL,G2H6(15),ex1(:),G2H3(48),m3h2x3(:,66),heltab2x6(:,:,110))
call HGT_lower_alpha_OLR(G1H6(39),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_QZ_A(ntryL,G1H6(39),ex4(:),G1H2(2),ngZu,m3h3x2(:,33),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(2),30,0,G2H2(27),n2h2(49))
  call Hloop_QA_Z(ntryL,G2H2(6),ex1(:),G2H1(1),ngZu,m3h2x1(:,23),heltab2x2(:,:,23))
call HGT_lower_alpha_OLR(G1H6(2),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_QZ_A(ntryL,G1H6(2),ex4(:),G1H2(2),ngZd,m3h3x2(:,34),heltab2x6(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(2),30,0,G2H2(28),n2h2(50))
  call Hloop_QA_W(ntryL,G2H2(10),ex1(:),G2H1(2),m3h2x1(:,24),heltab2x2(:,:,24))
call HGT_lower_alpha_OLR(G1H6(3),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(3),2,5,6)
  call Hloop_QZ_A(ntryL,G1H6(3),ex4(:),G1H2(2),ngZd,m3h3x2(:,35),heltab2x6(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(2),30,0,G2H2(6),n2h2(51))
  call Hloop_QA_W(ntryL,G2H2(14),ex1(:),G2H1(3),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hotf_4pt_reduction(G2H6(32),RedSet_4(40),mass4set(:,1),  & 
G1H6(12),G1H6(16),G1H6(43),G1H6(7),G1H6(11),6)
  call HG1shiftOLR(G1H6(16),2,6)
  call Hloop_AQ_Z(ntryL,G2H2(18),ex2(:),G2H1(4),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hotf_4pt_reduction(G2H6(29),RedSet_4(40),mass4set(:,2),  & 
G1H6(5),G1H6(6),G1H6(29),G1H6(39),G1H6(2),6)
  call HG1shiftOLR(G1H6(6),2,6)
  call Hloop_AQ_W(ntryL,G2H2(22),ex2(:),G2H1(5),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hotf_4pt_reduction(G2H6(31),RedSet_4(40),mass4set(:,3),  & 
G1H6(3),G1H6(44),G1H6(45),G1H6(46),G1H6(47),6)
  call HG1shiftOLR(G1H6(44),2,6)
  call Hloop_AQ_W(ntryL,G2H2(26),ex2(:),G2H1(6),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hloop_VT_S(ntryL,G1H3(67),19,ex3(:),4,G2H3(49),m3h1x3(:,33),heltab2x3(:,:,127))
  call Hotf_4pt_reduction(G2H3(43),RedSet_4(2),mass4set(:,4),  & 
G1H3(28),G1H3(3),G1H3(39),G1H3(23),G1H3(45),3)
  call HG1shiftOLR(G1H3(3),8,3)
  call Hotf_4pt_reduction(G2H3(44),RedSet_4(2),mass4set(:,5),  & 
G1H3(29),G1H3(35),G1H3(8),G1H3(20),G1H3(9),3)
  call HG1shiftOLR(G1H3(35),8,3)
  call Hloop_UV_W(ntryL,G1H3(106),19,ex4(:),8,G2H1(7),m3h3x1(:,95),heltab2x3(:,:,128))
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(7),mass4set(:,4),  & 
G1H3(52),G1H3(36),G1H3(44),G1H3(14),G1H3(51),3)
  call HG1shiftOLR(G1H3(36),4,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(7),mass4set(:,5),  & 
G1H3(19),G1H3(7),G1H3(37),G1H3(32),G1H3(72),3)
  call HG1shiftOLR(G1H3(7),4,3)
  call Hloop_VT_S(ntryL,G1H3(25),19,ex3(:),4,G2H3(43),m3h1x3(:,34),heltab2x3(:,:,129))
  call Hloop_UV_W(ntryL,G1H3(66),19,ex4(:),8,G2H1(8),m3h3x1(:,96),heltab2x3(:,:,130))
  call Hloop_AQ_Z(ntryL,G2H6(18),ex2(:),G2H3(44),ngZd,m3h2x3(:,67),heltab2x6(:,:,114))
  call Hloop_AQ_W(ntryL,G2H6(19),ex2(:),G2H3(8),m3h2x3(:,68),heltab2x6(:,:,115))
  call Hloop_QA_Z(ntryL,G2H6(20),ex1(:),G2H3(9),ngZu,m3h2x3(:,69),heltab2x6(:,:,116))
  call Hloop_QA_W(ntryL,G2H6(21),ex1(:),G2H3(50),m3h2x3(:,70),heltab2x6(:,:,117))
  call Hloop_QA_Z(ntryL,G2H2(1),ex1(:),G2H1(9),ngZu,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hloop_QA_W(ntryL,G2H2(2),ex1(:),G2H1(10),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hloop_AQ_Z(ntryL,G2H2(3),ex2(:),G2H1(11),ngZd,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hloop_AQ_W(ntryL,G2H2(4),ex2(:),G2H1(12),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hloop_QA_Z(ntryL,G2H2(5),ex1(:),G2H1(13),ngZu,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hloop_QA_W(ntryL,G2H2(7),ex1(:),G2H1(15),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hloop_QA_W(ntryL,G2H2(8),ex1(:),G2H1(16),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H2(9),ex2(:),G2H1(18),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hloop_AQ_W(ntryL,G2H2(11),ex2(:),G2H1(19),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hloop_AQ_W(ntryL,G2H2(12),ex2(:),G2H1(21),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hloop_QA_W(ntryL,G2H6(22),ex1(:),G2H3(51),m3h2x3(:,71),heltab2x6(:,:,118))
  call Hloop_AQ_W(ntryL,G2H6(23),ex2(:),G2H3(52),m3h2x3(:,72),heltab2x6(:,:,119))
  call Hloop_AQ_W(ntryL,G1H6(25),ex2(:),G1H3(77),m3h2x3(:,73),heltab2x6(:,:,120))
  call Hloop_AQ_Z(ntryL,G1H6(26),ex2(:),G1H3(92),ngZd,m3h2x3(:,74),heltab2x6(:,:,121))
  call Hloop_AQ_W(ntryL,G1H6(27),ex2(:),G1H3(67),m3h2x3(:,75),heltab2x6(:,:,122))
  call Hloop_QA_W(ntryL,G1H6(30),ex1(:),G1H3(106),m3h2x3(:,76),heltab2x6(:,:,123))
  call Hloop_QA_Z(ntryL,G1H6(31),ex1(:),G1H3(25),ngZu,m3h2x3(:,77),heltab2x6(:,:,124))
  call Hloop_QA_W(ntryL,G1H6(32),ex1(:),G1H3(66),m3h2x3(:,78),heltab2x6(:,:,125))
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(7),mass4set(:,6),  & 
G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),G0H3(2),3)
  call HG1shiftOLR(G1H3(108),4,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(7),mass4set(:,7),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),G0H3(5),3)
  call HG1shiftOLR(G1H3(113),4,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(7),mass4set(:,8),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G0H3(8),3)
  call HG1shiftOLR(G1H3(118),4,3)
  call Hotf_4pt_reduction(G2H3(20),RedSet_4(7),mass4set(:,9),  & 
G1H3(122),G1H3(123),G1H3(124),G1H3(125),G1H3(126),3)
  call HG1shiftOLR(G1H3(123),4,3)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(7),mass4set(:,10),  & 
G1H3(127),G1H3(128),G1H3(129),G1H3(130),G1H3(131),3)
  call HG1shiftOLR(G1H3(128),4,3)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(7),mass4set(:,11),  & 
G1H3(132),G1H3(133),G1H3(134),G1H3(135),G1H3(136),3)
  call HG1shiftOLR(G1H3(133),4,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(7),mass4set(:,5),  & 
G1H3(137),G1H3(138),G1H3(139),G1H3(140),G1H3(141),3)
  call HG1shiftOLR(G1H3(138),4,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(7),mass4set(:,4),  & 
G1H3(142),G1H3(143),G1H3(144),G1H3(145),G1H3(146),3)
  call HG1shiftOLR(G1H3(143),4,3)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(7),mass4set(:,5),  & 
G1H3(147),G1H3(148),G1H3(149),G1H3(150),G1H3(151),3)
  call HG1shiftOLR(G1H3(148),4,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(7),mass4set(:,4),  & 
G1H3(152),G1H3(153),G1H3(154),G1H3(155),G1H3(156),3)
  call HG1shiftOLR(G1H3(153),4,3)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(7),mass4set(:,5),  & 
G1H3(157),G1H3(158),G1H3(159),G1H3(160),G1H3(161),3)
  call HG1shiftOLR(G1H3(158),4,3)
  call Hloop_TV_S(ntryL,G0H3(1),19,ex4(:),8,G1H1(20),m3h3x1(:,97),heltab2x3(:,:,131))
  call Hloop_VV_S(ntryL,G1H3(42),ex4(:),G1H1(21),m3h3x1(:,98),heltab2x3(:,:,132))
  call Hloop_VV_S(ntryL,G1H3(10),ex4(:),G1H1(25),m3h3x1(:,99),heltab2x3(:,:,133))
  call Hloop_TV_S(ntryL,G1H3(21),19,ex4(:),8,G2H1(22),m3h3x1(:,100),heltab2x3(:,:,134))
  call Hloop_TV_S(ntryL,G1H3(38),19,ex4(:),8,G2H1(24),m3h3x1(:,101),heltab2x3(:,:,135))
  call Hloop_SV_V(ntryL,G2H3(10),ex4(:),G2H1(25),m3h3x1(:,102),heltab2x3(:,:,136))
  call Hloop_SV_V(ntryL,G2H3(11),ex4(:),G2H1(27),m3h3x1(:,103),heltab2x3(:,:,137))
  call Hloop_SV_V(ntryL,G2H3(13),ex4(:),G2H1(28),m3h3x1(:,104),heltab2x3(:,:,138))
  call Hloop_VV_S(ntryL,G1H3(12),ex4(:),G1H1(26),m3h3x1(:,105),heltab2x3(:,:,139))
  call Hloop_VV_S(ntryL,G1H3(43),ex4(:),G1H1(27),m3h3x1(:,106),heltab2x3(:,:,140))
  call Hloop_TV_S(ntryL,G1H3(46),19,ex4(:),8,G2H1(30),m3h3x1(:,107),heltab2x3(:,:,141))
  call Hloop_TV_S(ntryL,G1H3(22),19,ex4(:),8,G2H1(31),m3h3x1(:,108),heltab2x3(:,:,142))
  call Hloop_VV_S(ntryL,G0H3(3),ex4(:),G0H1(1),m3h3x1(:,109),heltab2x3(:,:,143))
  call Hloop_SV_V(ntryL,G0H3(4),ex4(:),G0H1(2),m3h3x1(:,110),heltab2x3(:,:,144))
  call Hloop_UV_W(ntryL,G1H3(49),19,ex4(:),8,G2H1(33),m3h3x1(:,111),heltab2x3(:,:,145))
  call Hloop_SV_V(ntryL,G1H3(60),ex4(:),G1H1(31),m3h3x1(:,112),heltab2x3(:,:,146))
  call Hloop_SV_V(ntryL,G1H3(4),ex4(:),G1H1(4),m3h3x1(:,113),heltab2x3(:,:,147))
  call Hloop_VV_S(ntryL,G2H3(14),ex4(:),G2H1(34),m3h3x1(:,114),heltab2x3(:,:,148))
  call Hloop_VV_S(ntryL,G2H3(16),ex4(:),G2H1(36),m3h3x1(:,115),heltab2x3(:,:,149))
  call Hloop_UV_W(ntryL,G1H3(5),19,ex4(:),8,G2H1(37),m3h3x1(:,116),heltab2x3(:,:,150))
  call Hloop_UV_W(ntryL,G1H3(59),19,ex4(:),8,G2H1(39),m3h3x1(:,117),heltab2x3(:,:,151))
  call Hloop_SV_V(ntryL,G1H3(61),ex4(:),G1H1(5),m3h3x1(:,118),heltab2x3(:,:,152))
  call Hloop_SV_V(ntryL,G1H3(65),ex4(:),G1H1(34),m3h3x1(:,119),heltab2x3(:,:,153))
  call Hloop_UV_W(ntryL,G0H3(6),19,ex4(:),8,G1H1(35),m3h3x1(:,120),heltab2x3(:,:,154))
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(2),mass4set(:,6),  & 
G1H3(42),G1H3(10),G1H3(21),G1H3(38),G1H3(12),G0H3(11),3)
  call HG1shiftOLR(G1H3(10),8,3)
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(2),mass4set(:,7),  & 
G1H3(43),G1H3(46),G1H3(22),G1H3(49),G1H3(60),G0H3(1),3)
  call HG1shiftOLR(G1H3(46),8,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(2),mass4set(:,8),  & 
G1H3(4),G1H3(5),G1H3(59),G1H3(61),G1H3(65),G0H3(3),3)
  call HG1shiftOLR(G1H3(5),8,3)
  call Hloop_SS_S(ntryL,G2H3(26),ex3(:),G2H3(17),m3h1x3(:,35),heltab2x3(:,:,155))
  call Hloop_SS_S(ntryL,G2H3(27),ex3(:),G2H3(18),m3h1x3(:,36),heltab2x3(:,:,156))
  call Hloop_SS_S(ntryL,G2H3(29),ex3(:),G2H3(19),m3h1x3(:,37),heltab2x3(:,:,157))
  call Hloop_SS_S(ntryL,G2H3(30),ex3(:),G2H3(20),m3h1x3(:,38),heltab2x3(:,:,158))
  call Hloop_SS_S(ntryL,G2H3(32),ex3(:),G2H3(1),m3h1x3(:,39),heltab2x3(:,:,159))
  call Hloop_SS_S(ntryL,G2H3(33),ex3(:),G2H3(2),m3h1x3(:,40),heltab2x3(:,:,160))
  call Hloop_SS_S(ntryL,G2H3(35),ex3(:),G2H3(3),m3h1x3(:,41),heltab2x3(:,:,161))
  call Hloop_SS_S(ntryL,G2H3(36),ex3(:),G2H3(4),m3h1x3(:,42),heltab2x3(:,:,162))
  call Hloop_VS_V(ntryL,G2H3(38),ex3(:),G2H3(5),m3h1x3(:,43),heltab2x3(:,:,163))
  call Hloop_VS_V(ntryL,G2H3(39),ex3(:),G2H3(6),m3h1x3(:,44),heltab2x3(:,:,164))
  call Hloop_SS_S(ntryL,G0H3(7),ex3(:),G0H3(4),m3h1x3(:,45),heltab2x3(:,:,165))
  call Hloop_SS_S(ntryL,G1H3(83),ex3(:),G1H3(162),m3h1x3(:,46),heltab2x3(:,:,166))
  call Hloop_SS_S(ntryL,G1H3(73),ex3(:),G1H3(83),m3h1x3(:,47),heltab2x3(:,:,167))
  call Hloop_VT_S(ntryL,G1H3(86),19,ex3(:),4,G2H3(7),m3h1x3(:,48),heltab2x3(:,:,168))
  call Hloop_VT_S(ntryL,G1H3(78),19,ex3(:),4,G2H3(10),m3h1x3(:,49),heltab2x3(:,:,169))
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(2),mass4set(:,12),  & 
G1H3(73),G1H3(86),G1H3(78),G1H3(163),G1H3(164),3)
  call HG1shiftOLR(G1H3(86),8,3)
  call Hotf_4pt_reduction(G2H3(41),RedSet_4(2),mass4set(:,11),  & 
G1H3(165),G1H3(166),G1H3(167),G1H3(168),G1H3(169),3)
  call HG1shiftOLR(G1H3(166),8,3)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(2),mass4set(:,5),  & 
G1H3(170),G1H3(171),G1H3(172),G1H3(173),G1H3(174),3)
  call HG1shiftOLR(G1H3(171),8,3)
  call Hloop_SS_S(ntryL,G1H3(79),ex3(:),G1H3(175),m3h1x3(:,50),heltab2x3(:,:,170))
  call Hloop_SS_S(ntryL,G1H3(48),ex3(:),G1H3(79),m3h1x3(:,51),heltab2x3(:,:,171))
  call Hloop_VT_S(ntryL,G1H3(15),19,ex3(:),4,G2H3(11),m3h1x3(:,52),heltab2x3(:,:,172))
  call Hloop_VT_S(ntryL,G1H3(87),19,ex3(:),4,G2H3(13),m3h1x3(:,53),heltab2x3(:,:,173))
  call Hloop_VT_S(ntryL,G0H3(9),19,ex3(:),4,G1H3(48),m3h1x3(:,54),heltab2x3(:,:,174))
  call Hloop_ST_V(ntryL,G0H3(10),19,ex3(:),4,G1H3(15),m3h1x3(:,55),heltab2x3(:,:,175))
  call Hloop_ST_V(ntryL,G1H3(88),19,ex3(:),4,G2H3(14),m3h1x3(:,56),heltab2x3(:,:,176))
  call Hloop_VS_V(ntryL,G1H3(99),ex3(:),G1H3(87),m3h1x3(:,57),heltab2x3(:,:,177))
  call Hloop_VS_V(ntryL,G1H3(93),ex3(:),G1H3(88),m3h1x3(:,58),heltab2x3(:,:,178))
  call Hloop_ST_V(ntryL,G1H3(94),19,ex3(:),4,G2H3(16),m3h1x3(:,59),heltab2x3(:,:,179))
  call Hloop_ST_V(ntryL,G1H3(98),19,ex3(:),4,G2H3(21),m3h1x3(:,60),heltab2x3(:,:,180))
  call Hloop_VS_V(ntryL,G1H3(100),ex3(:),G1H3(99),m3h1x3(:,61),heltab2x3(:,:,181))
  call Hloop_VS_V(ntryL,G1H3(104),ex3(:),G1H3(93),m3h1x3(:,62),heltab2x3(:,:,182))
  call Hloop_VS_V(ntryL,G0H3(12),ex3(:),G0H3(6),m3h1x3(:,63),heltab2x3(:,:,183))
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(19),mass4set(:,13),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(18),G0H12(77),12)
  call HG1shiftOLR(G1H12(14),8,12)
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(19),mass4set(:,14),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(24),G0H12(6),12)
  call HG1shiftOLR(G1H12(20),8,12)
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(19),mass4set(:,15),  & 
G1H12(25),G1H12(26),G1H12(31),G1H12(32),G1H12(33),G0H12(75),12)
  call HG1shiftOLR(G1H12(26),8,12)
  call Hloop_TV_S(ntryL,G1H12(23),20,wf4(:,1),3,G2H3(23),m3h4x3(:,85),heltab2x12(:,:,267))
  call Hloop_SV_T(ntryL,G1H12(115),20,wf4(:,1),3,G2H3(24),m3h4x3(:,86),heltab2x12(:,:,268))
  call Hloop_SV_T(ntryL,G1H12(98),20,wf4(:,1),3,G2H3(26),m3h4x3(:,87),heltab2x12(:,:,269))
  call Hloop_TV_S(ntryL,G1H12(107),20,wf4(:,1),3,G2H3(27),m3h4x3(:,88),heltab2x12(:,:,270))
  call Hloop_CV_D(ntryL,G1H12(118),20,wf4(:,1),3,G2H3(29),m3h4x3(:,89),heltab2x12(:,:,271))
  call Hloop_DV_C(ntryL,G1H12(116),20,wf4(:,1),G2H3(30),m3h4x3(:,90),heltab2x12(:,:,272))
  call Hloop_UW_V(ntryL,G1H12(117),20,wf4(:,1),3,G2H3(32),m3h4x3(:,91),heltab2x12(:,:,273))
  call Hloop_SV_V(ntryL,G1H12(28),wf4(:,1),G1H3(94),m3h4x3(:,92),heltab2x12(:,:,274))
  call Hloop_SV_V(ntryL,G1H12(109),wf4(:,1),G1H3(98),m3h4x3(:,93),heltab2x12(:,:,275))
  call Hotf_4pt_reduction(G2H12(8),RedSet_4(19),mass4set(:,16),  & 
G1H12(34),G1H12(35),G1H12(36),G1H12(37),G1H12(38),12)
  call HG1shiftOLR(G1H12(35),8,12)
  call Hloop_TV_S(ntryL,G0H12(8),20,wf4(:,1),3,G1H3(100),m3h4x3(:,94),heltab2x12(:,:,276))
  call Hloop_VV_S(ntryL,G2H12(4),wf4(:,1),G2H3(33),m3h4x3(:,95),heltab2x12(:,:,277))
  call Hloop_VV_S(ntryL,G2H12(5),wf4(:,1),G2H3(35),m3h4x3(:,96),heltab2x12(:,:,278))
  call Hloop_SV_V(ntryL,G0H12(82),wf4(:,1),G0H3(7),m3h4x3(:,97),heltab2x12(:,:,279))
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(19),mass4set(:,17),  & 
G1H12(39),G1H12(40),G1H12(41),G1H12(42),G1H12(43),12)
  call HG1shiftOLR(G1H12(40),8,12)
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(19),mass4set(:,18),  & 
G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(48),12)
  call HG1shiftOLR(G1H12(45),8,12)
  call Hloop_VV_S(ntryL,G1H12(30),wf4(:,1),G1H3(104),m3h4x3(:,98),heltab2x12(:,:,280))
  call Hotf_4pt_reduction(G2H12(9),RedSet_4(19),mass4set(:,18),  & 
G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),12)
  call HG1shiftOLR(G1H12(50),8,12)
  call Hloop_VV_S(ntryL,G1H12(29),wf4(:,1),G1H3(176),m3h4x3(:,99),heltab2x12(:,:,281))
  call Hloop_VS_V(ntryL,G1H6(33),ex3(:),G1H6(25),m3h1x6(:,13),heltab2x6(:,:,126))
  call Hloop_WQ_A(ntryL,G1H12(4),ex2(:),G1H6(26),m3h2x6(:,129),heltab2x12(:,:,282))
  call Hloop_Q_A(ntryL,G1H6(26),22,0,G2H6(3),n2h6(131))
  call Hloop_WQ_A(ntryL,G1H12(6),ex2(:),G1H6(27),m3h2x6(:,130),heltab2x12(:,:,283))
  call Hloop_Q_A(ntryL,G1H6(27),22,0,G2H6(7),n2h6(132))
  call Hloop_ZQ_A(ntryL,G1H12(3),ex2(:),G1H6(30),ngZd,m3h2x6(:,131),heltab2x12(:,:,284))
  call Hloop_Q_A(ntryL,G1H6(30),22,0,G2H6(11),n2h6(133))
  call Hloop_QA_W(ntryL,G1H6(34),wf6(:,2),G1H1(36),m3h6x1(:,1),heltab2x6(:,:,127))
  call Hloop_QA_W(ntryL,G1H6(36),wf6(:,2),G1H1(40),m3h6x1(:,2),heltab2x6(:,:,128))
  call Hloop_QA_Z(ntryL,G2H6(1),wf6(:,2),G2H1(40),ngZu,m3h6x1(:,3),heltab2x6(:,:,129))
  call Hloop_QA_W(ntryL,G2H6(2),wf6(:,2),G2H1(42),m3h6x1(:,4),heltab2x6(:,:,130))
  call Hloop_QA_W(ntryL,G2H6(4),wf6(:,2),G2H1(43),m3h6x1(:,5),heltab2x6(:,:,131))
  call Hloop_VS_V(ntryL,G1H6(19),ex3(:),G1H6(31),m3h1x6(:,14),heltab2x6(:,:,132))
  call Hloop_WA_Q(ntryL,G1H12(10),ex1(:),G1H6(32),m3h2x6(:,132),heltab2x12(:,:,285))
  call Hloop_A_Q(ntryL,G1H6(32),21,0,G2H6(15),n2h6(134))
  call Hloop_WA_Q(ntryL,G1H12(12),ex1(:),G1H6(33),m3h2x6(:,133),heltab2x12(:,:,286))
  call Hloop_A_Q(ntryL,G1H6(33),21,0,G2H6(32),n2h6(135))
  call Hloop_ZA_Q(ntryL,G1H12(9),ex1(:),G1H6(26),ngZu,m3h2x6(:,134),heltab2x12(:,:,287))
  call Hloop_A_Q(ntryL,G1H6(26),21,0,G2H6(29),n2h6(136))
  call Hloop_AQ_W(ntryL,G1H6(9),wf6(:,4),G1H1(41),m3h6x1(:,6),heltab2x6(:,:,133))
  call Hloop_AQ_W(ntryL,G1H6(28),wf6(:,4),G1H1(42),m3h6x1(:,7),heltab2x6(:,:,134))
  call Hloop_AQ_Z(ntryL,G2H6(5),wf6(:,4),G2H1(44),ngZd,m3h6x1(:,8),heltab2x6(:,:,135))
  call Hloop_AQ_W(ntryL,G2H6(6),wf6(:,4),G2H1(45),m3h6x1(:,9),heltab2x6(:,:,136))
  call Hloop_AQ_W(ntryL,G2H6(8),wf6(:,4),G2H1(46),m3h6x1(:,10),heltab2x6(:,:,137))
  call Hloop_AQ_W(ntryL,G1H6(21),ex2(:),G1H3(177),m3h2x3(:,79),heltab2x6(:,:,138))
  call Hloop_AQ_Z(ntryL,G1H6(4),ex2(:),G1H3(178),ngZd,m3h2x3(:,80),heltab2x6(:,:,139))
  call Hloop_AQ_W(ntryL,G1H6(15),ex2(:),G1H3(179),m3h2x3(:,81),heltab2x6(:,:,140))
  call Hloop_VQ_A(ntryL,G1H6(22),ex2(:),G1H3(180),m3h2x3(:,82),heltab2x6(:,:,141))
  call Hloop_Q_A(ntryL,G1H3(180),19,0,G2H3(36),n2h3(17))
  call Hloop_ZQ_A(ntryL,G1H6(35),ex2(:),G1H3(180),ngZd,m3h2x3(:,83),heltab2x6(:,:,142))
  call Hloop_Q_A(ntryL,G1H3(180),19,0,G2H3(38),n2h3(18))
  call Hloop_AQ_W(ntryL,G1H6(23),ex2(:),G1H3(180),m3h2x3(:,84),heltab2x6(:,:,143))
  call Hloop_AQ_Z(ntryL,G1H6(24),ex2(:),G1H3(181),ngZd,m3h2x3(:,85),heltab2x6(:,:,144))
  call Hloop_AQ_W(ntryL,G1H6(37),ex2(:),G1H3(182),m3h2x3(:,86),heltab2x6(:,:,145))
  call Hloop_AQ_W(ntryL,G2H6(9),ex2(:),G2H3(39),m3h2x3(:,87),heltab2x6(:,:,146))
  call Hloop_AQ_W(ntryL,G2H6(10),ex2(:),G2H3(40),m3h2x3(:,88),heltab2x6(:,:,147))
  call Hloop_QA_W(ntryL,G1H6(17),ex1(:),G1H3(183),m3h2x3(:,89),heltab2x6(:,:,148))
  call Hloop_QA_Z(ntryL,G1H6(18),ex1(:),G1H3(184),ngZu,m3h2x3(:,90),heltab2x6(:,:,149))
  call Hloop_QA_W(ntryL,G1H6(20),ex1(:),G1H3(185),m3h2x3(:,91),heltab2x6(:,:,150))
  call Hloop_VA_Q(ntryL,G1H6(38),ex1(:),G1H3(186),m3h2x3(:,92),heltab2x6(:,:,151))
  call Hloop_A_Q(ntryL,G1H3(186),19,0,G2H3(41),n2h3(19))
  call Hloop_ZA_Q(ntryL,G1H6(1),ex1(:),G1H3(186),ngZu,m3h2x3(:,93),heltab2x6(:,:,152))
  call Hloop_A_Q(ntryL,G1H3(186),19,0,G2H3(42),n2h3(20))
  call Hloop_QA_W(ntryL,G1H6(40),ex1(:),G1H3(186),m3h2x3(:,94),heltab2x6(:,:,153))
  call Hloop_QA_Z(ntryL,G1H6(41),ex1(:),G1H3(187),ngZu,m3h2x3(:,95),heltab2x6(:,:,154))
  call Hloop_QA_W(ntryL,G1H6(42),ex1(:),G1H3(188),m3h2x3(:,96),heltab2x6(:,:,155))
  call Hloop_QA_W(ntryL,G2H6(12),ex1(:),G2H3(53),m3h2x3(:,97),heltab2x6(:,:,156))
  call Hloop_QA_W(ntryL,G2H6(13),ex1(:),G2H3(54),m3h2x3(:,98),heltab2x6(:,:,157))
  call Hotf_4pt_reduction(G2H6(14),RedSet_4(41),mass4set(:,2),  & 
G1H6(27),G1H6(30),G1H6(34),G1H6(36),G1H6(19),6)
  call HG1shiftOLR(G1H6(30),2,6)
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(41),mass4set(:,19),  & 
G1H6(32),G1H6(33),G1H6(26),G1H6(9),G1H6(28),6)
  call HG1shiftOLR(G1H6(33),2,6)
  call Hotf_4pt_reduction(G2H6(17),RedSet_4(41),mass4set(:,3),  & 
G1H6(21),G1H6(4),G1H6(15),G1H6(22),G1H6(35),6)
  call HG1shiftOLR(G1H6(4),2,6)
  call Hotf_4pt_reduction(G2H6(24),RedSet_4(41),mass4set(:,1),  & 
G1H6(23),G1H6(24),G1H6(37),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(24),2,6)
  call Hloop_ZQ_A(ntryL,G0H6(5),ex2(:),G0H3(9),ngZd,m3h2x3(:,99),heltab2x6(:,:,158))
  call Hloop_Q_A(ntryL,G0H3(9),23,0,G1H3(189),n2h3(21))
  call Hloop_WQ_A(ntryL,G0H6(1),ex2(:),G0H3(10),m3h2x3(:,100),heltab2x6(:,:,159))
  call Hloop_Q_A(ntryL,G0H3(10),23,0,G1H3(190),n2h3(22))
  call Hloop_VS_V(ntryL,G1H3(26),ex3(:),G1H3(191),m3h1x3(:,64),heltab2x3(:,:,184))
  call Hloop_VV_S(ntryL,G1H3(6),ex4(:),G1H1(46),m3h3x1(:,121),heltab2x3(:,:,185))
  call Hloop_ZA_Q(ntryL,G0H6(2),ex1(:),G0H3(12),ngZu,m3h2x3(:,101),heltab2x6(:,:,160))
  call Hloop_A_Q(ntryL,G0H3(12),23,0,G1H3(26),n2h3(23))
  call Hloop_WA_Q(ntryL,G0H6(3),ex1(:),G0H3(9),m3h2x3(:,102),heltab2x6(:,:,161))
  call Hloop_A_Q(ntryL,G0H3(9),23,0,G1H3(6),n2h3(24))
  call Hloop_VS_V(ntryL,G1H3(71),ex3(:),G1H3(192),m3h1x3(:,65),heltab2x3(:,:,186))
  call Hloop_VV_S(ntryL,G1H3(105),ex4(:),G1H1(47),m3h3x1(:,122),heltab2x3(:,:,187))
  call Hloop_QA_W(ntryL,G2H6(25),ex1(:),G2H3(55),m3h2x3(:,103),heltab2x6(:,:,162))
  call Hloop_QA_W(ntryL,G2H6(26),ex1(:),G2H3(56),m3h2x3(:,104),heltab2x6(:,:,163))
  call Hloop_VA_Q(ntryL,G1H6(8),ex1(:),G1H3(71),m3h2x3(:,105),heltab2x6(:,:,164))
  call Hloop_A_Q(ntryL,G1H3(71),23,0,G2H3(57),n2h3(25))
  call Hloop_ZA_Q(ntryL,G1H6(10),ex1(:),G1H3(105),ngZu,m3h2x3(:,106),heltab2x6(:,:,165))
  call Hloop_A_Q(ntryL,G1H3(105),23,0,G2H3(58),n2h3(26))
  call Hloop_AQ_W(ntryL,G2H6(27),ex2(:),G2H3(59),m3h2x3(:,107),heltab2x6(:,:,166))
  call Hloop_AQ_W(ntryL,G2H6(28),ex2(:),G2H3(60),m3h2x3(:,108),heltab2x6(:,:,167))
  call Hloop_VQ_A(ntryL,G1H6(13),ex2(:),G1H3(71),m3h2x3(:,109),heltab2x6(:,:,168))
  call Hloop_Q_A(ntryL,G1H3(71),23,0,G2H3(61),n2h3(27))
  call Hloop_ZQ_A(ntryL,G1H6(14),ex2(:),G1H3(105),ngZd,m3h2x3(:,110),heltab2x6(:,:,169))
  call Hloop_Q_A(ntryL,G1H3(105),23,0,G2H3(62),n2h3(28))
  call Hotf_4pt_reduction(G2H6(30),RedSet_4(40),mass4set(:,19),  & 
G1H6(20),G1H6(38),G1H6(1),G1H6(40),G1H6(41),6)
  call HG1shiftOLR(G1H6(38),2,6)
  call Hloop_QA_W(ntryL,G2H2(13),ex1(:),G2H1(47),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hloop_QA_Z(ntryL,G2H2(15),ex1(:),G2H1(48),ngZu,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hloop_QA_W(ntryL,G2H2(16),ex1(:),G2H1(49),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hloop_AQ_W(ntryL,G2H2(17),ex2(:),G2H1(50),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hloop_AQ_Z(ntryL,G2H2(19),ex2(:),G2H1(51),ngZd,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hloop_AQ_W(ntryL,G2H2(20),ex2(:),G2H1(52),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hloop_VS_V(ntryL,G1H2(1),ex3(:),G1H2(2),m3h1x2(:,1),heltab2x2(:,:,45))
  call Hloop_AZ_Q(ntryL,G1H6(12),ex4(:),G1H2(1),ngZd,m3h3x2(:,36),heltab2x6(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(10),n2h2(52))
call HGT_raise_alpha_OLR(G1H6(16),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_ZQ_A(ntryL,G1H6(16),ex2(:),G1H3(71),ngZd,m3h2x3(:,111),heltab2x6(:,:,171))
  call Hloop_AZ_Q(ntryL,G1H6(7),ex4(:),G1H2(1),ngZd,m3h3x2(:,37),heltab2x6(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(14),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H6(11),ex4(:),G1H2(1),ngZd,m3h3x2(:,38),heltab2x6(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(18),n2h2(54))
  call Hloop_AZ_Q(ntryL,G1H6(5),ex4(:),G1H2(1),ngZu,m3h3x2(:,39),heltab2x6(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(22),n2h2(55))
call HGT_raise_alpha_OLR(G1H6(6),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_WQ_A(ntryL,G1H6(6),ex2(:),G1H3(105),m3h2x3(:,112),heltab2x6(:,:,175))
  call Hloop_AZ_Q(ntryL,G1H6(39),ex4(:),G1H2(1),ngZu,m3h3x2(:,40),heltab2x6(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(26),n2h2(56))
  call Hloop_AZ_Q(ntryL,G1H6(2),ex4(:),G1H2(1),ngZu,m3h3x2(:,41),heltab2x6(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(1),n2h2(57))
  call Hloop_AZ_Q(ntryL,G1H6(3),ex4(:),G1H2(1),ngZu,m3h3x2(:,42),heltab2x6(:,:,178))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(2),n2h2(58))
call HGT_raise_alpha_OLR(G1H6(44),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_WQ_A(ntryL,G1H6(44),ex2(:),G1H3(193),m3h2x3(:,113),heltab2x6(:,:,179))
  call Hloop_AZ_Q(ntryL,G1H6(46),ex4(:),G1H2(1),ngZu,m3h3x2(:,43),heltab2x6(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(3),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H6(47),ex4(:),G1H2(1),ngZu,m3h3x2(:,44),heltab2x6(:,:,181))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(4),n2h2(60))
  call Hloop_VT_S(ntryL,G1H3(28),19,ex3(:),4,G2H3(63),m3h1x3(:,66),heltab2x3(:,:,188))
call HGT_raise_alpha_OLR(G1H3(3),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(3),ex4(:),G1H1(48),m3h3x1(:,123),heltab2x3(:,:,189))
  call Hloop_VT_S(ntryL,G1H3(23),19,ex3(:),4,G2H3(64),m3h1x3(:,67),heltab2x3(:,:,190))
  call Hloop_VT_S(ntryL,G1H3(45),19,ex3(:),4,G2H3(65),m3h1x3(:,68),heltab2x3(:,:,191))
  call Hloop_VT_S(ntryL,G1H3(29),19,ex3(:),4,G2H3(66),m3h1x3(:,69),heltab2x3(:,:,192))
call HGT_raise_alpha_OLR(G1H3(35),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(35),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(35),ex4(:),G1H1(52),m3h3x1(:,124),heltab2x3(:,:,193))
  call Hloop_VT_S(ntryL,G1H3(20),19,ex3(:),4,G2H3(67),m3h1x3(:,70),heltab2x3(:,:,194))
  call Hloop_VT_S(ntryL,G1H3(9),19,ex3(:),4,G2H3(68),m3h1x3(:,71),heltab2x3(:,:,195))
  call Hloop_UV_W(ntryL,G1H3(52),19,ex4(:),8,G2H1(53),m3h3x1(:,125),heltab2x3(:,:,196))
call HGT_raise_alpha_OLR(G1H3(36),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(36),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(36),ex3(:),G1H3(28),m3h1x3(:,72),heltab2x3(:,:,197))
  call Hloop_UV_W(ntryL,G1H3(14),19,ex4(:),8,G2H1(54),m3h3x1(:,126),heltab2x3(:,:,198))
  call Hloop_UV_W(ntryL,G1H3(51),19,ex4(:),8,G2H1(55),m3h3x1(:,127),heltab2x3(:,:,199))
  call Hloop_UV_W(ntryL,G1H3(19),19,ex4(:),8,G2H1(56),m3h3x1(:,128),heltab2x3(:,:,200))
call HGT_raise_alpha_OLR(G1H3(7),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(7),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(7),ex3(:),G1H3(3),m3h1x3(:,73),heltab2x3(:,:,201))
  call Hloop_UV_W(ntryL,G1H3(32),19,ex4(:),8,G2H1(57),m3h3x1(:,129),heltab2x3(:,:,202))
  call Hloop_UV_W(ntryL,G1H3(72),19,ex4(:),8,G2H1(58),m3h3x1(:,130),heltab2x3(:,:,203))
  call Hloop_QZ_A(ntryL,G1H3(107),ex4(:),G1H1(1),ngZl,m3h3x1(:,131),heltab2x3(:,:,204))
  call Hloop_Q_A(ntryL,G1H1(1),27,nML,G2H1(59),n2h1(31))
call HGT_OLR(G1H3(108),1,1,3)
call HGT_invQ_OLR(G1H3(108),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(108),-4,nML,G2H3(69),n2h3(33))
  call Hloop_AS_Q(ntryL,G2H3(69),ex3(:),G2H3(70),ngH,m3h1x3(:,74),heltab2x3(:,:,205))
  call Hloop_QZ_A(ntryL,G1H3(110),ex4(:),G1H1(2),ngZl,m3h3x1(:,132),heltab2x3(:,:,206))
  call Hloop_Q_A(ntryL,G1H1(2),27,nML,G2H1(60),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H3(111),ex4(:),G1H1(13),ngZl,m3h3x1(:,133),heltab2x3(:,:,207))
  call Hloop_Q_A(ntryL,G1H1(13),27,nML,G2H1(61),n2h1(33))
  call Hloop_QZ_A(ntryL,G0H3(2),ex4(:),G0H1(3),ngZl,m3h3x1(:,134),heltab2x3(:,:,208))
  call Hloop_Q_A(ntryL,G0H1(3),27,nML,G1H1(53),n2h1(34))
  call Hloop_AZ_Q(ntryL,G1H3(112),ex4(:),G1H1(54),ngZu,m3h3x1(:,135),heltab2x3(:,:,209))
  call Hloop_A_Q(ntryL,G1H1(54),27,nMT,G2H1(62),n2h1(35))
call HGT_OLR(G1H3(113),1,1,3)
call HGT_invQ_OLR(G1H3(113),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(113),-4,nMT,G2H3(69),n2h3(34))
  call Hloop_QS_A(ntryL,G2H3(69),ex3(:),G2H3(71),ngH,m3h1x3(:,75),heltab2x3(:,:,210))
  call Hloop_AZ_Q(ntryL,G1H3(115),ex4(:),G1H1(58),ngZu,m3h3x1(:,136),heltab2x3(:,:,211))
  call Hloop_A_Q(ntryL,G1H1(58),27,nMT,G2H1(63),n2h1(36))
  call Hloop_AZ_Q(ntryL,G1H3(116),ex4(:),G1H1(59),ngZu,m3h3x1(:,137),heltab2x3(:,:,212))
  call Hloop_A_Q(ntryL,G1H1(59),27,nMT,G2H1(64),n2h1(37))
  call Hloop_AZ_Q(ntryL,G0H3(5),ex4(:),G0H1(3),ngZu,m3h3x1(:,138),heltab2x3(:,:,213))
  call Hloop_A_Q(ntryL,G0H1(3),27,nMT,G1H1(60),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H3(117),ex4(:),G1H1(64),ngZd,m3h3x1(:,139),heltab2x3(:,:,214))
  call Hloop_Q_A(ntryL,G1H1(64),27,nMB,G2H1(65),n2h1(39))
call HGT_OLR(G1H3(118),1,1,3)
call HGT_invQ_OLR(G1H3(118),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(118),-4,nMB,G2H3(69),n2h3(35))
  call Hloop_AS_Q(ntryL,G2H3(69),ex3(:),G2H3(72),ngH,m3h1x3(:,76),heltab2x3(:,:,215))
  call Hloop_QZ_A(ntryL,G1H3(120),ex4(:),G1H1(14),ngZd,m3h3x1(:,140),heltab2x3(:,:,216))
  call Hloop_Q_A(ntryL,G1H1(14),27,nMB,G2H1(66),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(121),ex4(:),G1H1(15),ngZd,m3h3x1(:,141),heltab2x3(:,:,217))
  call Hloop_Q_A(ntryL,G1H1(15),27,nMB,G2H1(67),n2h1(41))
  call Hloop_QZ_A(ntryL,G0H3(8),ex4(:),G0H1(3),ngZd,m3h3x1(:,142),heltab2x3(:,:,218))
  call Hloop_Q_A(ntryL,G0H1(3),27,nMB,G1H1(19),n2h1(42))
  call Hloop_SV_T(ntryL,G1H3(122),19,ex4(:),8,G2H1(68),m3h3x1(:,143),heltab2x3(:,:,219))
call HGT_OLR(G1H3(123),1,1,3)
call HGT_invQ_OLR(G1H3(123),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(123),ex3(:),G1H3(23),m3h1x3(:,77),heltab2x3(:,:,220))
  call Hloop_SV_T(ntryL,G1H3(125),19,ex4(:),8,G2H1(69),m3h3x1(:,144),heltab2x3(:,:,221))
  call Hloop_SV_T(ntryL,G1H3(126),19,ex4(:),8,G2H1(70),m3h3x1(:,145),heltab2x3(:,:,222))
  call Hloop_TV_S(ntryL,G1H3(127),19,ex4(:),8,G2H1(71),m3h3x1(:,146),heltab2x3(:,:,223))
call HGT_OLR(G1H3(128),1,1,3)
call HGT_invQ_OLR(G1H3(128),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(128),ex3(:),G1H3(45),m3h1x3(:,78),heltab2x3(:,:,224))
  call Hloop_TV_S(ntryL,G1H3(130),19,ex4(:),8,G2H1(72),m3h3x1(:,147),heltab2x3(:,:,225))
  call Hloop_TV_S(ntryL,G1H3(131),19,ex4(:),8,G2H1(73),m3h3x1(:,148),heltab2x3(:,:,226))
  call Hloop_TV_S(ntryL,G1H3(132),19,ex4(:),8,G2H1(74),m3h3x1(:,149),heltab2x3(:,:,227))
call HGT_OLR(G1H3(133),1,1,3)
call HGT_invQ_OLR(G1H3(133),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(133),ex3(:),G1H3(29),m3h1x3(:,79),heltab2x3(:,:,228))
  call Hloop_TV_S(ntryL,G1H3(135),19,ex4(:),8,G2H1(75),m3h3x1(:,150),heltab2x3(:,:,229))
  call Hloop_TV_S(ntryL,G1H3(136),19,ex4(:),8,G2H1(76),m3h3x1(:,151),heltab2x3(:,:,230))
  call Hloop_TV_S(ntryL,G1H3(137),19,ex4(:),8,G2H1(77),m3h3x1(:,152),heltab2x3(:,:,231))
call HGT_OLR(G1H3(138),1,1,3)
call HGT_invQ_OLR(G1H3(138),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(138),ex3(:),G1H3(35),m3h1x3(:,80),heltab2x3(:,:,232))
  call Hloop_TV_S(ntryL,G1H3(140),19,ex4(:),8,G2H1(78),m3h3x1(:,153),heltab2x3(:,:,233))
  call Hloop_TV_S(ntryL,G1H3(141),19,ex4(:),8,G2H1(79),m3h3x1(:,154),heltab2x3(:,:,234))
  call Hloop_CV_D(ntryL,G1H3(142),19,ex4(:),8,G2H1(80),m3h3x1(:,155),heltab2x3(:,:,235))
call HGT_OLR(G1H3(143),1,1,3)
call HGT_invQ_OLR(G1H3(143),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(143),ex3(:),G1H3(20),m3h1x3(:,81),heltab2x3(:,:,236))
  call Hloop_CV_D(ntryL,G1H3(145),19,ex4(:),8,G2H1(81),m3h3x1(:,156),heltab2x3(:,:,237))
  call Hloop_CV_D(ntryL,G1H3(146),19,ex4(:),8,G2H1(82),m3h3x1(:,157),heltab2x3(:,:,238))
  call Hloop_CV_D(ntryL,G1H3(147),19,ex4(:),8,G2H1(83),m3h3x1(:,158),heltab2x3(:,:,239))
call HGT_OLR(G1H3(148),1,1,3)
call HGT_invQ_OLR(G1H3(148),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(148),ex3(:),G1H3(9),m3h1x3(:,82),heltab2x3(:,:,240))
  call Hloop_CV_D(ntryL,G1H3(150),19,ex4(:),8,G2H1(84),m3h3x1(:,159),heltab2x3(:,:,241))
  call Hloop_CV_D(ntryL,G1H3(151),19,ex4(:),8,G2H1(85),m3h3x1(:,160),heltab2x3(:,:,242))
  call Hloop_DV_C(ntryL,G1H3(152),19,ex4(:),G2H1(86),m3h3x1(:,161),heltab2x3(:,:,243))
call HGT_OLR(G1H3(153),1,1,3)
call HGT_invQ_OLR(G1H3(153),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(153),ex3(:),G1H3(52),m3h1x3(:,83),heltab2x3(:,:,244))
  call Hloop_DV_C(ntryL,G1H3(155),19,ex4(:),G2H1(87),m3h3x1(:,162),heltab2x3(:,:,245))
  call Hloop_DV_C(ntryL,G1H3(156),19,ex4(:),G2H1(88),m3h3x1(:,163),heltab2x3(:,:,246))
  call Hloop_DV_C(ntryL,G1H3(157),19,ex4(:),G2H1(89),m3h3x1(:,164),heltab2x3(:,:,247))
call HGT_OLR(G1H3(158),1,1,3)
call HGT_invQ_OLR(G1H3(158),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(158),ex3(:),G1H3(36),m3h1x3(:,84),heltab2x3(:,:,248))
  call Hloop_DV_C(ntryL,G1H3(160),19,ex4(:),G2H1(90),m3h3x1(:,165),heltab2x3(:,:,249))
  call Hloop_DV_C(ntryL,G1H3(161),19,ex4(:),G2H1(91),m3h3x1(:,166),heltab2x3(:,:,250))
  call Hloop_QS_A(ntryL,G1H3(42),ex3(:),G1H3(14),ngH,m3h1x3(:,85),heltab2x3(:,:,251))
  call Hloop_Q_A(ntryL,G1H3(14),23,nML,G2H3(69),n2h3(44))
call HGT_OLR(G1H3(10),1,1,3)
call HGT_invQ_OLR(G1H3(10),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(10),-8,nML,G2H3(73),n2h3(45))
  call Hloop_AZ_Q(ntryL,G2H3(73),ex4(:),G2H1(92),ngZl,m3h3x1(:,167),heltab2x3(:,:,252))
  call Hloop_QS_A(ntryL,G1H3(38),ex3(:),G1H3(51),ngH,m3h1x3(:,86),heltab2x3(:,:,253))
  call Hloop_Q_A(ntryL,G1H3(51),23,nML,G2H3(73),n2h3(46))
  call Hloop_QS_A(ntryL,G1H3(12),ex3(:),G1H3(19),ngH,m3h1x3(:,87),heltab2x3(:,:,254))
  call Hloop_Q_A(ntryL,G1H3(19),23,nML,G2H3(74),n2h3(47))
  call Hloop_QS_A(ntryL,G0H3(11),ex3(:),G0H3(10),ngH,m3h1x3(:,88),heltab2x3(:,:,255))
  call Hloop_Q_A(ntryL,G0H3(10),23,nML,G1H3(7),n2h3(48))
  call Hloop_AS_Q(ntryL,G1H3(43),ex3(:),G1H3(32),ngH,m3h1x3(:,89),heltab2x3(:,:,256))
  call Hloop_A_Q(ntryL,G1H3(32),23,nMT,G2H3(75),n2h3(49))
call HGT_OLR(G1H3(46),1,1,3)
call HGT_invQ_OLR(G1H3(46),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(46),-8,nMT,G2H3(76),n2h3(50))
  call Hloop_QZ_A(ntryL,G2H3(76),ex4(:),G2H1(93),ngZu,m3h3x1(:,168),heltab2x3(:,:,257))
  call Hloop_AS_Q(ntryL,G1H3(49),ex3(:),G1H3(72),ngH,m3h1x3(:,90),heltab2x3(:,:,258))
  call Hloop_A_Q(ntryL,G1H3(72),23,nMT,G2H3(76),n2h3(51))
  call Hloop_AS_Q(ntryL,G1H3(60),ex3(:),G1H3(107),ngH,m3h1x3(:,91),heltab2x3(:,:,259))
  call Hloop_A_Q(ntryL,G1H3(107),23,nMT,G2H3(77),n2h3(52))
  call Hloop_AS_Q(ntryL,G0H3(1),ex3(:),G0H3(12),ngH,m3h1x3(:,92),heltab2x3(:,:,260))
  call Hloop_A_Q(ntryL,G0H3(12),23,nMT,G1H3(108),n2h3(53))
  call Hloop_QS_A(ntryL,G1H3(4),ex3(:),G1H3(110),ngH,m3h1x3(:,93),heltab2x3(:,:,261))
  call Hloop_Q_A(ntryL,G1H3(110),23,nMB,G2H3(78),n2h3(54))
call HGT_OLR(G1H3(5),1,1,3)
call HGT_invQ_OLR(G1H3(5),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(5),-8,nMB,G2H3(79),n2h3(55))
  call Hloop_AZ_Q(ntryL,G2H3(79),ex4(:),G2H1(94),ngZd,m3h3x1(:,169),heltab2x3(:,:,262))
  call Hloop_QS_A(ntryL,G1H3(61),ex3(:),G1H3(111),ngH,m3h1x3(:,94),heltab2x3(:,:,263))
  call Hloop_Q_A(ntryL,G1H3(111),23,nMB,G2H3(79),n2h3(56))
  call Hloop_QS_A(ntryL,G1H3(65),ex3(:),G1H3(112),ngH,m3h1x3(:,95),heltab2x3(:,:,264))
  call Hloop_Q_A(ntryL,G1H3(112),23,nMB,G2H3(80),n2h3(57))
  call Hloop_QS_A(ntryL,G0H3(3),ex3(:),G0H3(9),ngH,m3h1x3(:,96),heltab2x3(:,:,265))
  call Hloop_Q_A(ntryL,G0H3(9),23,nMB,G1H3(113),n2h3(58))
  call Hloop_ST_V(ntryL,G1H3(73),19,ex3(:),4,G2H3(81),m3h1x3(:,97),heltab2x3(:,:,266))
call HGT_OLR(G1H3(86),1,1,3)
call HGT_invQ_OLR(G1H3(86),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(86),ex4(:),G1H1(65),m3h3x1(:,170),heltab2x3(:,:,267))
  call Hloop_ST_V(ntryL,G1H3(163),19,ex3(:),4,G2H3(82),m3h1x3(:,98),heltab2x3(:,:,268))
  call Hloop_ST_V(ntryL,G1H3(164),19,ex3(:),4,G2H3(83),m3h1x3(:,99),heltab2x3(:,:,269))
  call Hloop_ST_V(ntryL,G1H3(165),19,ex3(:),4,G2H3(84),m3h1x3(:,100),heltab2x3(:,:,270))
call HGT_OLR(G1H3(166),1,1,3)
call HGT_invQ_OLR(G1H3(166),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(166),ex4(:),G1H1(66),m3h3x1(:,171),heltab2x3(:,:,271))
  call Hloop_ST_V(ntryL,G1H3(168),19,ex3(:),4,G2H3(85),m3h1x3(:,101),heltab2x3(:,:,272))
  call Hloop_ST_V(ntryL,G1H3(169),19,ex3(:),4,G2H3(86),m3h1x3(:,102),heltab2x3(:,:,273))
  call Hloop_ST_V(ntryL,G1H3(170),19,ex3(:),4,G2H3(87),m3h1x3(:,103),heltab2x3(:,:,274))
call HGT_OLR(G1H3(171),1,1,3)
call HGT_invQ_OLR(G1H3(171),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(171),ex4(:),G1H1(70),m3h3x1(:,172),heltab2x3(:,:,275))
  call Hloop_ST_V(ntryL,G1H3(173),19,ex3(:),4,G2H3(88),m3h1x3(:,104),heltab2x3(:,:,276))
  call Hloop_ST_V(ntryL,G1H3(174),19,ex3(:),4,G2H3(89),m3h1x3(:,105),heltab2x3(:,:,277))
  call Hloop_AW_Q(ntryL,G1H12(13),wf4(:,1),G1H3(115),m3h4x3(:,100),heltab2x12(:,:,288))
  call Hloop_A_Q(ntryL,G1H3(115),23,0,G2H3(90),n2h3(62))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-8,0,G2H12(1),n2h12(33))
  call Hloop_QZ_A(ntryL,G2H12(1),ex4(:),G2H4(1),ngZn,m3h3x4(:,5),heltab2x12(:,:,289))
  call Hloop_AW_Q(ntryL,G1H12(16),wf4(:,1),G1H3(116),m3h4x3(:,101),heltab2x12(:,:,290))
  call Hloop_A_Q(ntryL,G1H3(116),23,0,G2H3(91),n2h3(63))
  call Hloop_AW_Q(ntryL,G1H12(18),wf4(:,1),G1H3(117),m3h4x3(:,102),heltab2x12(:,:,291))
  call Hloop_A_Q(ntryL,G1H3(117),23,0,G2H3(92),n2h3(64))
  call Hloop_AW_Q(ntryL,G0H12(77),wf4(:,1),G0H3(2),m3h4x3(:,103),heltab2x12(:,:,292))
  call Hloop_A_Q(ntryL,G0H3(2),23,0,G1H3(118),n2h3(65))
  call Hloop_QW_A(ntryL,G1H12(19),wf4(:,1),G1H3(120),m3h4x3(:,104),heltab2x12(:,:,293))
  call Hloop_Q_A(ntryL,G1H3(120),23,nMB,G2H3(93),n2h3(66))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(20),-8,nMB,G2H12(2),n2h12(34))
  call Hloop_AZ_Q(ntryL,G2H12(2),ex4(:),G2H4(2),ngZd,m3h3x4(:,6),heltab2x12(:,:,294))
  call Hloop_QW_A(ntryL,G1H12(22),wf4(:,1),G1H3(121),m3h4x3(:,105),heltab2x12(:,:,295))
  call Hloop_Q_A(ntryL,G1H3(121),23,nMB,G2H3(94),n2h3(67))
  call Hloop_QW_A(ntryL,G1H12(24),wf4(:,1),G1H3(122),m3h4x3(:,106),heltab2x12(:,:,296))
  call Hloop_Q_A(ntryL,G1H3(122),23,nMB,G2H3(95),n2h3(68))
  call Hloop_QW_A(ntryL,G0H12(6),wf4(:,1),G0H3(5),m3h4x3(:,107),heltab2x12(:,:,297))
  call Hloop_Q_A(ntryL,G0H3(5),23,nMB,G1H3(123),n2h3(69))
  call Hloop_AW_Q(ntryL,G1H12(25),wf4(:,1),G1H3(125),m3h4x3(:,108),heltab2x12(:,:,298))
  call Hloop_A_Q(ntryL,G1H3(125),23,nMT,G2H3(96),n2h3(70))
call HGT_OLR(G1H12(26),1,1,12)
call HGT_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(26),-8,nMT,G2H12(3),n2h12(35))
  call Hloop_QZ_A(ntryL,G2H12(3),ex4(:),G2H4(3),ngZu,m3h3x4(:,7),heltab2x12(:,:,299))
  call Hloop_AW_Q(ntryL,G1H12(32),wf4(:,1),G1H3(126),m3h4x3(:,109),heltab2x12(:,:,300))
  call Hloop_A_Q(ntryL,G1H3(126),23,nMT,G2H3(97),n2h3(71))
  call Hloop_AW_Q(ntryL,G1H12(33),wf4(:,1),G1H3(127),m3h4x3(:,110),heltab2x12(:,:,301))
  call Hloop_A_Q(ntryL,G1H3(127),23,nMT,G2H3(98),n2h3(72))
  call Hloop_AW_Q(ntryL,G0H12(75),wf4(:,1),G0H3(8),m3h4x3(:,111),heltab2x12(:,:,302))
  call Hloop_A_Q(ntryL,G0H3(8),23,nMT,G1H3(128),n2h3(73))
  call Hloop_SV_T(ntryL,G1H12(34),20,wf4(:,1),3,G2H3(99),m3h4x3(:,112),heltab2x12(:,:,303))
call HGT_raise_alpha_OLR(G1H12(35),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(35),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(35),ex4(:),G1H4(8),m3h3x4(:,8),heltab2x12(:,:,304))
  call Hloop_SV_T(ntryL,G1H12(37),20,wf4(:,1),3,G2H3(100),m3h4x3(:,113),heltab2x12(:,:,305))
  call Hloop_SV_T(ntryL,G1H12(38),20,wf4(:,1),3,G2H3(101),m3h4x3(:,114),heltab2x12(:,:,306))
  call Hloop_UV_W(ntryL,G1H12(39),20,wf4(:,1),3,G2H3(102),m3h4x3(:,115),heltab2x12(:,:,307))
call HGT_OLR(G1H12(40),1,1,12)
call HGT_invQ_OLR(G1H12(40),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(40),ex4(:),G1H4(9),m3h3x4(:,9),heltab2x12(:,:,308))
  call Hloop_UV_W(ntryL,G1H12(42),20,wf4(:,1),3,G2H3(103),m3h4x3(:,116),heltab2x12(:,:,309))
  call Hloop_UV_W(ntryL,G1H12(43),20,wf4(:,1),3,G2H3(104),m3h4x3(:,117),heltab2x12(:,:,310))
  call Hloop_UW_V(ntryL,G1H12(44),20,wf4(:,1),3,G2H3(105),m3h4x3(:,118),heltab2x12(:,:,311))
call HGT_OLR(G1H12(45),1,1,12)
call HGT_invQ_OLR(G1H12(45),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(45),ex4(:),G1H4(10),m3h3x4(:,10),heltab2x12(:,:,312))
  call Hloop_UW_V(ntryL,G1H12(47),20,wf4(:,1),3,G2H3(106),m3h4x3(:,119),heltab2x12(:,:,313))
  call Hloop_UW_V(ntryL,G1H12(48),20,wf4(:,1),3,G2H3(107),m3h4x3(:,120),heltab2x12(:,:,314))
  call Hloop_TV_S(ntryL,G1H12(49),20,wf4(:,1),3,G2H3(108),m3h4x3(:,121),heltab2x12(:,:,315))
call HGT_raise_alpha_OLR(G1H12(50),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(50),ex4(:),G1H4(14),m3h3x4(:,11),heltab2x12(:,:,316))
  call Hloop_TV_S(ntryL,G1H12(52),20,wf4(:,1),3,G2H3(109),m3h4x3(:,122),heltab2x12(:,:,317))
  call Hloop_TV_S(ntryL,G1H12(53),20,wf4(:,1),3,G2H3(110),m3h4x3(:,123),heltab2x12(:,:,318))
  call Hloop_AZ_Q(ntryL,G1H6(27),wf3(:,1),G1H2(1),ngZu,m3h3x2(:,45),heltab2x6(:,:,182))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(5),n2h2(61))
call HGT_raise_alpha_OLR(G1H6(30),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_WQ_A(ntryL,G1H6(30),ex2(:),G1H3(130),m3h2x3(:,114),heltab2x6(:,:,183))
  call Hloop_AZ_Q(ntryL,G1H6(36),wf3(:,1),G1H2(1),ngZu,m3h3x2(:,46),heltab2x6(:,:,184))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(7),n2h2(62))
  call Hloop_AZ_Q(ntryL,G1H6(19),wf3(:,1),G1H2(1),ngZu,m3h3x2(:,47),heltab2x6(:,:,185))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(8),n2h2(63))
  call Hloop_AZ_Q(ntryL,G1H6(32),wf3(:,1),G1H2(1),ngZd,m3h3x2(:,48),heltab2x6(:,:,186))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(9),n2h2(64))
call HGT_raise_alpha_OLR(G1H6(33),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(33),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(33),ex2(:),G1H3(131),m3h2x3(:,115),heltab2x6(:,:,187))
  call Hloop_AZ_Q(ntryL,G1H6(9),wf3(:,1),G1H2(1),ngZd,m3h3x2(:,49),heltab2x6(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(11),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H6(28),wf3(:,1),G1H2(1),ngZd,m3h3x2(:,50),heltab2x6(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(12),n2h2(66))
  call Hloop_AZ_Q(ntryL,G1H6(21),wf3(:,1),G1H2(1),ngZu,m3h3x2(:,51),heltab2x6(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(13),n2h2(67))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_WQ_A(ntryL,G1H6(4),ex2(:),G1H3(132),m3h2x3(:,116),heltab2x6(:,:,191))
  call Hloop_AZ_Q(ntryL,G1H6(22),wf3(:,1),G1H2(1),ngZu,m3h3x2(:,52),heltab2x6(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(15),n2h2(68))
  call Hloop_AZ_Q(ntryL,G1H6(35),wf3(:,1),G1H2(1),ngZu,m3h3x2(:,53),heltab2x6(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(16),n2h2(69))
  call Hloop_AZ_Q(ntryL,G1H6(23),wf3(:,1),G1H2(1),ngZd,m3h3x2(:,54),heltab2x6(:,:,194))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(17),n2h2(70))
call HGT_raise_alpha_OLR(G1H6(24),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_ZQ_A(ntryL,G1H6(24),ex2(:),G1H3(133),ngZd,m3h2x3(:,117),heltab2x6(:,:,195))
  call Hloop_AZ_Q(ntryL,G1H6(17),wf3(:,1),G1H2(1),ngZd,m3h3x2(:,55),heltab2x6(:,:,196))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(19),n2h2(71))
  call Hloop_AZ_Q(ntryL,G1H6(18),wf3(:,1),G1H2(1),ngZd,m3h3x2(:,56),heltab2x6(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(20),n2h2(72))
  call Hloop_AZ_Q(ntryL,G1H6(20),ex4(:),G1H2(1),ngZd,m3h3x2(:,57),heltab2x6(:,:,198))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(29),n2h2(73))
call HGT_raise_alpha_OLR(G1H6(38),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(38),ex2(:),G1H3(135),m3h2x3(:,118),heltab2x6(:,:,199))
  call Hloop_AZ_Q(ntryL,G1H6(40),ex4(:),G1H2(1),ngZd,m3h3x2(:,58),heltab2x6(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(30),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H6(41),ex4(:),G1H2(1),ngZd,m3h3x2(:,59),heltab2x6(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(31),n2h2(75))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(102),[G2H3(22),G2H3(12),G1H3(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(105),[G2H3(25),G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(40),[G2H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(42),[G2H1(32),G2H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(43),[G2H1(35),G2H1(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(44),[G2H1(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(45),[G2H1(38),G2H1(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(46),[G2H1(41),G2H1(29)])
call HGT_w2_OLR(G1H1(7),1,1,1)
call HGT_w2_invQ_OLR(G1H1(7),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(47),[G1H1(7)])
call HGT_w2_OLR(G1H1(8),1,1,1)
call HGT_w2_invQ_OLR(G1H1(8),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(49),[G1H1(8)])
call HGT_lower_alpha_OLR(G1H3(55),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(55),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(55),[G1H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(56),[G1H3(62)])
call HGT_lower_alpha_OLR(G1H3(1),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(56),[G1H3(1)])
call HGT_w2_OLR(G1H1(9),1,1,1)
call HGT_w2_invQ_OLR(G1H1(9),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(50),[G1H1(9)])
call HGT_w2_OLR(G1H1(10),1,1,1)
call HGT_w2_invQ_OLR(G1H1(10),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(52),[G1H1(10)])
call HGT_lower_alpha_OLR(G1H3(2),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(59),[G1H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(60),[G1H3(27)])
call HGT_lower_alpha_OLR(G1H3(24),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(24),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(60),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G1H3(64),G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(47),[G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(69),G1H3(33),G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G2H3(18),G1H3(75),G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(20),G1H3(81),G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(192),[G1H3(56),G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(5),G1H3(84),G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G2H3(6),G1H3(90),G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(47),[G1H1(16),G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(34),[G2H1(30),G1H1(32),G1H1(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(36),[G2H1(31),G1H1(38),G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(28),[G1H1(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(37),[G1H1(44),G1H1(23),G0H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(36),[G1H1(57),G1H1(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(39),[G2H1(28),G1H1(50),G1H1(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(40),[G1H1(63),G1H1(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(80),[G1H3(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(191),[G1H3(89),G1H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(46),[G1H1(37),G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(49),[G1H1(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(41),[G1H1(69),G1H1(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(42),[G1H1(75),G1H1(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(26),[G1H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(61),[G1H1(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G1H3(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(73),[G1H1(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(26),[G1H1(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(68),[G1H1(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(74),[G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(24),[G0H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(33),[G2H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(77),[G1H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(35),[G1H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(53),[G1H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(56),[G1H1(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G2H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(48),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G1H3(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(99),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G0H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(81),[G1H3(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(84),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(87),[G1H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G2H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G2H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(99),[G1H3(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(108),[G1H3(176)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(102),ex4(:),G2tensor(40),m3h3x1(:,173),heltab2x3(:,:,278))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(105),ex4(:),G2tensor(21),m3h3x1(:,174),heltab2x3(:,:,279))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(40),ex3(:),G2tensor(46),m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(42),ex3(:),G2tensor(23),m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(43),ex3(:),G2tensor(58),m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(44),ex3(:),G2tensor(25),m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(45),ex3(:),G2tensor(61),m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(46),ex3(:),G2tensor(27),m3h1x1(:,68),heltab2x1(:,:,68))
  call Hotf_4pt_reduction(G2H1(47),RedSet_4(42),mass4set(:,20),  & 
G1H1(71),G1H1(72),G1H1(76),G1H1(1),G1H1(2),1)
  call HG1shiftOLR(G1H1(72),4,1)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(28),ex4(:),G2tensor(70),m3h3x1(:,175),heltab2x3(:,:,280))
  call Hotf_4pt_reduction(G2H1(49),RedSet_4(42),mass4set(:,21),  & 
G1H1(13),G1H1(54),G1H1(58),G1H1(59),G1H1(64),1)
  call HG1shiftOLR(G1H1(54),4,1)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(31),ex4(:),G2tensor(29),m3h3x1(:,176),heltab2x3(:,:,281))
  call Hotf_4pt_reduction(G2H3(55),RedSet_4(22),mass4set(:,20),  & 
G1H3(136),G1H3(137),G1H3(138),G1H3(140),G1H3(141),3)
  call HG1shiftOLR(G1H3(137),8,3)
  call Hotf_4pt_reduction(G2H3(56),RedSet_4(22),mass4set(:,21),  & 
G1H3(142),G1H3(143),G1H3(145),G1H3(146),G1H3(147),3)
  call HG1shiftOLR(G1H3(143),8,3)
  call Hotf_4pt_reduction(G2H1(50),RedSet_4(43),mass4set(:,20),  & 
G1H1(14),G1H1(15),G1H1(7),G1H1(8),G1H1(9),1)
  call HG1shiftOLR(G1H1(15),4,1)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(34),ex4(:),G2tensor(76),m3h3x1(:,177),heltab2x3(:,:,282))
  call Hotf_4pt_reduction(G2H1(52),RedSet_4(43),mass4set(:,21),  & 
G1H1(10),G1H1(16),G1H1(3),G1H1(32),G1H1(11),1)
  call HG1shiftOLR(G1H1(16),4,1)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(37),ex4(:),G2tensor(31),m3h3x1(:,178),heltab2x3(:,:,283))
  call Hotf_4pt_reduction(G2H3(59),RedSet_4(17),mass4set(:,20),  & 
G1H3(148),G1H3(150),G1H3(151),G1H3(152),G1H3(153),3)
  call HG1shiftOLR(G1H3(150),8,3)
  call Hotf_4pt_reduction(G2H3(60),RedSet_4(17),mass4set(:,21),  & 
G1H3(155),G1H3(156),G1H3(157),G1H3(158),G1H3(160),3)
  call HG1shiftOLR(G1H3(156),8,3)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(30),23,ex4(:),8,G2tensor(85),m3h3x1(:,179),heltab2x3(:,:,284))
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(19),mass4set(:,18),  & 
G1H3(161),G1H3(42),G1H3(14),G1H3(10),G1H3(38),3)
  call HG1shiftOLR(G1H3(42),8,3)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(47),23,ex4(:),8,G2tensor(33),m3h3x1(:,180),heltab2x3(:,:,285))
  call Hotf_4pt_reduction(G2H3(11),RedSet_4(2),mass4set(:,4),  & 
G1H3(51),G1H3(12),G1H3(19),G1H3(43),G1H3(32),3)
  call HG1shiftOLR(G1H3(12),8,3)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(34),23,ex4(:),8,G2tensor(88),m3h3x1(:,181),heltab2x3(:,:,286))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(13),23,ex4(:),8,G2tensor(35),m3h3x1(:,182),heltab2x3(:,:,287))
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(2),mass4set(:,12),  & 
G1H3(46),G1H3(49),G1H3(72),G1H3(60),G1H3(107),3)
  call HG1shiftOLR(G1H3(49),8,3)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(41),23,ex4(:),8,G2tensor(3),m3h3x1(:,183),heltab2x3(:,:,288))
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(2),mass4set(:,5),  & 
G1H3(4),G1H3(110),G1H3(5),G1H3(61),G1H3(111),3)
  call HG1shiftOLR(G1H3(110),8,3)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(18),23,ex4(:),8,G2tensor(7),m3h3x1(:,184),heltab2x3(:,:,289))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(192),23,ex4(:),8,G2tensor(11),m3h3x1(:,185),heltab2x3(:,:,290))
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(2),mass4set(:,4),  & 
G1H3(65),G1H3(112),G1H3(73),G1H3(86),G1H3(163),3)
  call HG1shiftOLR(G1H3(112),8,3)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(54),23,ex4(:),8,G2tensor(13),m3h3x1(:,186),heltab2x3(:,:,291))
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(2),mass4set(:,5),  & 
G1H3(164),G1H3(165),G1H3(166),G1H3(168),G1H3(169),3)
  call HG1shiftOLR(G1H3(165),8,3)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(58),23,ex4(:),8,G2tensor(17),m3h3x1(:,187),heltab2x3(:,:,292))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(63),23,ex4(:),8,G2tensor(19),m3h3x1(:,188),heltab2x3(:,:,293))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(47),27,ex3(:),4,G2tensor(43),m3h1x1(:,69),heltab2x1(:,:,69))
  call Hotf_4pt_reduction(G2H1(34),RedSet_4(7),mass4set(:,4),  & 
G1H1(38),G1H1(17),G1H1(22),G1H1(44),G1H1(23),1)
  call HG1shiftOLR(G1H1(17),4,1)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(12),27,ex3(:),4,G2tensor(49),m3h1x1(:,70),heltab2x1(:,:,70))
  call Hotf_4pt_reduction(G2H1(36),RedSet_4(7),mass4set(:,5),  & 
G1H1(57),G1H1(24),G1H1(50),G1H1(29),G1H1(63),1)
  call HG1shiftOLR(G1H1(24),4,1)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(18),27,ex3(:),4,G2tensor(52),m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(28),27,ex3(:),4,G2tensor(64),m3h1x1(:,72),heltab2x1(:,:,72))
  call Hotf_4pt_reduction(G2H1(37),RedSet_4(7),mass4set(:,4),  & 
G1H1(30),G1H1(37),G1H1(6),G1H1(43),G1H1(69),1)
  call HG1shiftOLR(G1H1(37),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(36),27,ex3(:),4,G2tensor(67),m3h1x1(:,73),heltab2x1(:,:,73))
  call Hotf_4pt_reduction(G2H1(39),RedSet_4(7),mass4set(:,5),  & 
G1H1(45),G1H1(75),G1H1(51),G1H1(55),G1H1(67),1)
  call HG1shiftOLR(G1H1(75),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(40),27,ex3(:),4,G2tensor(73),m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(80),23,ex4(:),8,G2tensor(79),m3h3x1(:,189),heltab2x3(:,:,294))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(70),23,ex4(:),8,G2tensor(82),m3h3x1(:,190),heltab2x3(:,:,295))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(74),23,ex4(:),8,G2tensor(91),m3h3x1(:,191),heltab2x3(:,:,296))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(76),23,ex4(:),8,G2tensor(94),m3h3x1(:,192),heltab2x3(:,:,297))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(82),23,ex4(:),8,G2tensor(1),m3h3x1(:,193),heltab2x3(:,:,298))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(191),23,ex4(:),8,G2tensor(37),m3h3x1(:,194),heltab2x3(:,:,299))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(85),23,ex4(:),8,G2tensor(5),m3h3x1(:,195),heltab2x3(:,:,300))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(91),23,ex4(:),8,G2tensor(55),m3h3x1(:,196),heltab2x3(:,:,301))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(46),27,ex3(:),4,G2tensor(9),m3h1x1(:,75),heltab2x1(:,:,75))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(33),27,ex3(:),4,G2tensor(100),m3h1x1(:,76),heltab2x1(:,:,76))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(39),27,ex3(:),4,G2tensor(103),m3h1x1(:,77),heltab2x1(:,:,77))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(49),27,ex3(:),4,G2tensor(15),m3h1x1(:,78),heltab2x1(:,:,78))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(41),27,ex3(:),4,G2tensor(109),m3h1x1(:,79),heltab2x1(:,:,79))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(42),27,ex3(:),4,G2tensor(112),m3h1x1(:,80),heltab2x1(:,:,80))
  call Hloop_AZ_Q(ntryL,G1H3(26),ex4(:),G1H1(20),ngZu,m3h3x1(:,197),heltab2x3(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,0,G2tensor(97),n2h1(43))
  call Hloop_AZ_Q(ntryL,G1H3(96),ex4(:),G1H1(21),ngZu,m3h3x1(:,198),heltab2x3(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,0,G2tensor(106),n2h1(44))
  call Hloop_AZ_Q(ntryL,G1H3(97),ex4(:),G1H1(25),ngZu,m3h3x1(:,199),heltab2x3(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,0,G2tensor(115),n2h1(45))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(61),27,ex3(:),4,G2tensor(116),m3h1x1(:,81),heltab2x1(:,:,81))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(56),27,ex3(:),4,G2tensor(117),m3h1x1(:,82),heltab2x1(:,:,82))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(62),27,ex3(:),4,G2tensor(118),m3h1x1(:,83),heltab2x1(:,:,83))
  call Hloop_QZ_A(ntryL,G1H3(189),ex4(:),G1H1(27),ngZd,m3h3x1(:,200),heltab2x3(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,0,G2tensor(119),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(102),ex4(:),G1H1(4),ngZd,m3h3x1(:,201),heltab2x3(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,0,G2tensor(120),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H3(103),ex4(:),G1H1(5),ngZd,m3h3x1(:,202),heltab2x3(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,0,G2tensor(121),n2h1(48))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(73),27,ex3(:),4,G2tensor(122),m3h1x1(:,84),heltab2x1(:,:,84))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(68),27,ex3(:),4,G2tensor(123),m3h1x1(:,85),heltab2x1(:,:,85))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(74),27,ex3(:),4,G2tensor(124),m3h1x1(:,86),heltab2x1(:,:,86))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(21),ex2(:),G2tensor(125),ngZd,m3h2x1(:,45),heltab2x2(:,:,46))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(45),ex4(:),G2tensor(126),m3h3x1(:,203),heltab2x3(:,:,308))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(127),m3h2x1(:,46),heltab2x2(:,:,47))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(46),ex4(:),G2tensor(128),m3h3x1(:,204),heltab2x3(:,:,309))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(24),ex1(:),G2tensor(129),ngZu,m3h2x1(:,47),heltab2x2(:,:,48))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(47),ex4(:),G2tensor(130),m3h3x1(:,205),heltab2x3(:,:,310))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(25),ex1(:),G2tensor(131),m3h2x1(:,48),heltab2x2(:,:,49))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(48),ex4(:),G2tensor(132),m3h3x1(:,206),heltab2x3(:,:,311))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(27),ex1(:),G2tensor(133),ngZu,m3h2x1(:,49),heltab2x2(:,:,50))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(1),ex3(:),G2tensor(134),m3h1x1(:,87),heltab2x1(:,:,87))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(28),ex1(:),G2tensor(135),m3h2x1(:,50),heltab2x2(:,:,51))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(136),m3h1x1(:,88),heltab2x1(:,:,88))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex1(:),G2tensor(137),m3h2x1(:,51),heltab2x2(:,:,52))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(3),ex3(:),G2tensor(138),m3h1x1(:,89),heltab2x1(:,:,89))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(4),ex3(:),G2tensor(139),m3h1x1(:,90),heltab2x1(:,:,90))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(5),ex3(:),G2tensor(140),m3h1x1(:,91),heltab2x1(:,:,91))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(6),ex3(:),G2tensor(141),m3h1x1(:,92),heltab2x1(:,:,92))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(49),ex4(:),G2tensor(142),m3h3x1(:,207),heltab2x3(:,:,312))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(7),ex3(:),G2tensor(143),m3h1x1(:,93),heltab2x1(:,:,93))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(43),ex4(:),G2tensor(144),m3h3x1(:,208),heltab2x3(:,:,313))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(8),ex3(:),G2tensor(145),m3h1x1(:,94),heltab2x1(:,:,94))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(44),ex4(:),G2tensor(146),m3h3x1(:,209),heltab2x3(:,:,314))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(8),ex4(:),G2tensor(147),m3h3x1(:,210),heltab2x3(:,:,315))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(9),ex4(:),G2tensor(148),m3h3x1(:,211),heltab2x3(:,:,316))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(50),ex4(:),G2tensor(149),m3h3x1(:,212),heltab2x3(:,:,317))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(9),ex3(:),G2tensor(150),m3h1x1(:,95),heltab2x1(:,:,95))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex3(:),G2tensor(151),m3h1x1(:,96),heltab2x1(:,:,96))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(11),ex3(:),G2tensor(152),m3h1x1(:,97),heltab2x1(:,:,97))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(12),ex3(:),G2tensor(153),m3h1x1(:,98),heltab2x1(:,:,98))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(13),ex3(:),G2tensor(154),m3h1x1(:,99),heltab2x1(:,:,99))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(15),ex3(:),G2tensor(155),m3h1x1(:,100),heltab2x1(:,:,100))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(156),m3h1x1(:,101),heltab2x1(:,:,101))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(157),m3h1x1(:,102),heltab2x1(:,:,102))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(19),ex3(:),G2tensor(158),m3h1x1(:,103),heltab2x1(:,:,103))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(21),ex3(:),G2tensor(159),m3h1x1(:,104),heltab2x1(:,:,104))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(51),ex4(:),G2tensor(160),m3h3x1(:,213),heltab2x3(:,:,318))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(52),ex4(:),G2tensor(161),m3h3x1(:,214),heltab2x3(:,:,319))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(77),ex4(:),ex3(:),G1tensor(1),m4h3x1x1(:,1),heltab3x3(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(92),ex4(:),ex3(:),G1tensor(8),m4h3x1x1(:,2),heltab3x3(:,:,2))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(67),ex4(:),ex3(:),G1tensor(15),m4h3x1x1(:,3),heltab3x3(:,:,3))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(106),ex4(:),ex3(:),G1tensor(21),m4h3x1x1(:,4),heltab3x3(:,:,4))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(25),ex4(:),ex3(:),G1tensor(5),m4h3x1x1(:,5),heltab3x3(:,:,5))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(66),ex4(:),ex3(:),G1tensor(27),m4h3x1x1(:,6),heltab3x3(:,:,6))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(26),ex3(:),G1tensor(33),m3h1x1(:,105),heltab2x1(:,:,105))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(68),ex3(:),G2tensor(162),m3h1x1(:,106),heltab2x1(:,:,106))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(74),ex3(:),G2tensor(163),m3h1x1(:,107),heltab2x1(:,:,107))
  call Hotf_4pt_reduction(G2H1(22),RedSet_4(7),mass4set(:,10),  & 
G1H1(34),G1H1(47),G1H1(12),G1H1(18),G1H1(28),1)
  call HG1shiftOLR(G1H1(47),4,1)
  call Hotf_4pt_reduction(G2H1(24),RedSet_4(7),mass4set(:,11),  & 
G1H1(36),G1H1(40),G1H1(46),G1H1(33),G1H1(39),1)
  call HG1shiftOLR(G1H1(40),4,1)
  call Hotf_4pt_reduction(G2H1(25),RedSet_4(7),mass4set(:,10),  & 
G1H1(49),G1H1(41),G1H1(42),G1H1(20),G1H1(21),1)
  call HG1shiftOLR(G1H1(41),4,1)
  call Hotf_4pt_reduction(G2H1(33),RedSet_4(7),mass4set(:,11),  & 
G1H1(25),G1H1(61),G1H1(56),G1H1(62),G1H1(27),1)
  call HG1shiftOLR(G1H1(61),4,1)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(77),ex3(:),G2tensor(164),m3h1x1(:,108),heltab2x1(:,:,108))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(31),ex3(:),G1tensor(39),m3h1x1(:,109),heltab2x1(:,:,109))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(35),ex3(:),G1tensor(45),m3h1x1(:,110),heltab2x1(:,:,110))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(53),ex3(:),G2tensor(165),m3h1x1(:,111),heltab2x1(:,:,111))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(56),ex3(:),G2tensor(166),m3h1x1(:,112),heltab2x1(:,:,112))
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(2),mass4set(:,22),  & 
G1H3(170),G1H3(171),G1H3(173),G1H3(174),G1H3(115),3)
  call HG1shiftOLR(G1H3(171),8,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(2),mass4set(:,11),  & 
G1H3(116),G1H3(117),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(117),8,3)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(2),mass4set(:,4),  & 
G1H3(125),G1H3(126),G1H3(127),G1H3(94),G1H3(55),3)
  call HG1shiftOLR(G1H3(126),8,3)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(2),mass4set(:,5),  & 
G1H3(62),G1H3(1),G1H3(2),G1H3(27),G1H3(24),3)
  call HG1shiftOLR(G1H3(1),8,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(2),mass4set(:,4),  & 
G1H3(64),G1H3(31),G1H3(11),G1H3(69),G1H3(33),3)
  call HG1shiftOLR(G1H3(31),8,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(2),mass4set(:,5),  & 
G1H3(75),G1H3(40),G1H3(81),G1H3(17),G1H3(56),3)
  call HG1shiftOLR(G1H3(40),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(162),ex4(:),G1tensor(51),m3h3x1(:,215),heltab2x3(:,:,320))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(48),ex4(:),G1tensor(11),m3h3x1(:,216),heltab2x3(:,:,321))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(63),ex4(:),G2tensor(167),m3h3x1(:,217),heltab2x3(:,:,322))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(66),ex4(:),G2tensor(168),m3h3x1(:,218),heltab2x3(:,:,323))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(99),ex4(:),G1tensor(57),m3h3x1(:,219),heltab2x3(:,:,324))
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(2),mass4set(:,11),  & 
G1H3(50),G1H3(84),G1H3(53),G1H3(90),G1H3(57),3)
  call HG1shiftOLR(G1H3(84),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(81),ex4(:),G2tensor(169),m3h3x1(:,220),heltab2x3(:,:,325))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(84),ex4(:),G2tensor(170),m3h3x1(:,221),heltab2x3(:,:,326))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(87),ex4(:),G2tensor(171),m3h3x1(:,222),heltab2x3(:,:,327))
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(19),mass4set(:,23),  & 
G1H3(68),G1H3(89),G1H3(16),G1H3(95),G1H3(101),3)
  call HG1shiftOLR(G1H3(89),8,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(19),mass4set(:,17),  & 
G1H3(83),G1H3(175),G1H3(79),G1H3(15),G1H3(87),3)
  call HG1shiftOLR(G1H3(175),8,3)
  call Hotf_4pt_reduction(G2H3(35),RedSet_4(19),mass4set(:,16),  & 
G1H3(88),G1H3(93),G1H3(104),G1H3(176),G1H3(30),3)
  call HG1shiftOLR(G1H3(93),8,3)
  call Hotf_4pt_reduction(G2H3(33),RedSet_4(19),mass4set(:,18),  & 
G1H3(47),G1H3(34),G1H3(13),G1H3(41),G1H3(18),3)
  call HG1shiftOLR(G1H3(34),8,3)
  call Hotf_4pt_reduction(G2H3(29),RedSet_4(19),mass4set(:,18),  & 
G1H3(192),G1H3(54),G1H3(58),G1H3(63),G1H3(80),3)
  call HG1shiftOLR(G1H3(54),8,3)
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(19),mass4set(:,18),  & 
G1H3(70),G1H3(74),G1H3(76),G1H3(82),G1H3(191),3)
  call HG1shiftOLR(G1H3(74),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(98),ex4(:),G1tensor(63),m3h3x1(:,223),heltab2x3(:,:,328))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(100),ex4(:),G1tensor(69),m3h3x1(:,224),heltab2x3(:,:,329))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(7),23,ex4(:),8,G1tensor(75),m3h3x1(:,225),heltab2x3(:,:,330))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(99),ex4(:),G2tensor(172),m3h3x1(:,226),heltab2x3(:,:,331))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(108),ex4(:),G2tensor(173),m3h3x1(:,227),heltab2x3(:,:,332))
  call Hloop_ZA_Q(ntryL,G1H6(25),wf6(:,2),G1H1(4),ngZu,m3h6x1(:,11),heltab2x6(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,0,G2tensor(174),n2h1(49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(3),wf6(:,2),G2tensor(175),m3h6x1(:,12),heltab2x6(:,:,203))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(7),wf6(:,2),G2tensor(176),ngZu,m3h6x1(:,13),heltab2x6(:,:,204))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(11),wf6(:,2),G2tensor(177),m3h6x1(:,14),heltab2x6(:,:,205))
  call Hloop_ZQ_A(ntryL,G1H6(31),wf6(:,4),G1H1(5),ngZd,m3h6x1(:,15),heltab2x6(:,:,206))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,0,G2tensor(178),n2h1(50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(15),wf6(:,4),G2tensor(179),m3h6x1(:,16),heltab2x6(:,:,207))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H6(32),wf6(:,4),G2tensor(180),ngZd,m3h6x1(:,17),heltab2x6(:,:,208))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(29),wf6(:,4),G2tensor(181),m3h6x1(:,18),heltab2x6(:,:,209))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(177),19,wf3(:,7),12,G2tensor(182),m3h3x1(:,228),heltab2x3(:,:,333))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H3(178),19,wf3(:,7),12,G2tensor(183),m3h3x1(:,229),heltab2x3(:,:,334))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(179),19,wf3(:,7),12,G2tensor(184),m3h3x1(:,230),heltab2x3(:,:,335))
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(12),mass4set(:,24),  & 
G1H3(85),G1H3(91),G1H3(26),G1H3(96),G1H3(97),3)
  call HG1shiftOLR(G1H3(91),12,3)
  call Hotf_4pt_reduction(G2H3(38),RedSet_4(12),mass4set(:,25),  & 
G1H3(189),G1H3(102),G1H3(103),G1H3(77),G1H3(92),3)
  call HG1shiftOLR(G1H3(102),12,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(180),wf3(:,1),G1tensor(81),m3h3x1(:,231),heltab2x3(:,:,336))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(181),wf3(:,1),G1tensor(87),m3h3x1(:,232),heltab2x3(:,:,337))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(182),wf3(:,1),G1tensor(93),m3h3x1(:,233),heltab2x3(:,:,338))
  call Hotf_4pt_reduction(G2H3(39),RedSet_4(12),mass4set(:,20),  & 
G1H3(67),G1H3(106),G1H3(25),G1H3(66),G1H3(162),3)
  call HG1shiftOLR(G1H3(106),12,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(12),mass4set(:,21),  & 
G1H3(48),G1H3(99),G1H3(98),G1H3(100),G1H3(177),3)
  call HG1shiftOLR(G1H3(99),12,3)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(183),19,wf3(:,7),12,G2tensor(185),m3h3x1(:,234),heltab2x3(:,:,339))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H3(184),19,wf3(:,7),12,G2tensor(186),m3h3x1(:,235),heltab2x3(:,:,340))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(185),19,wf3(:,7),12,G2tensor(187),m3h3x1(:,236),heltab2x3(:,:,341))
  call Hotf_4pt_reduction(G2H3(41),RedSet_4(4),mass4set(:,24),  & 
G1H3(178),G1H3(179),G1H3(180),G1H3(181),G1H3(182),3)
  call HG1shiftOLR(G1H3(179),12,3)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(4),mass4set(:,25),  & 
G1H3(183),G1H3(184),G1H3(185),G1H3(194),G1H3(195),3)
  call HG1shiftOLR(G1H3(184),12,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(186),wf3(:,1),G1tensor(99),m3h3x1(:,237),heltab2x3(:,:,342))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(187),wf3(:,1),G1tensor(105),m3h3x1(:,238),heltab2x3(:,:,343))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(188),wf3(:,1),G1tensor(111),m3h3x1(:,239),heltab2x3(:,:,344))
  call Hotf_4pt_reduction(G2H3(53),RedSet_4(4),mass4set(:,20),  & 
G1H3(186),G1H3(187),G1H3(188),G1H3(196),G1H3(197),3)
  call HG1shiftOLR(G1H3(187),12,3)
  call Hotf_4pt_reduction(G2H3(54),RedSet_4(4),mass4set(:,21),  & 
G1H3(198),G1H3(199),G1H3(200),G1H3(201),G1H3(202),3)
  call HG1shiftOLR(G1H3(199),12,3)
  call Hloop_QZ_A(ntryL,G1H3(190),ex4(:),G1H1(73),ngZu,m3h3x1(:,240),heltab2x3(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(73),31,0,G2tensor(188),n2h1(51))
  call Hloop_AZ_Q(ntryL,G1H3(6),ex4(:),G1H1(68),ngZd,m3h3x1(:,241),heltab2x3(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(68),31,0,G2tensor(189),n2h1(52))
  call Hotf_4pt_reduction(G2H3(57),RedSet_4(22),mass4set(:,24),  & 
G1H3(190),G1H3(6),G1H3(203),G1H3(204),G1H3(205),3)
  call HG1shiftOLR(G1H3(6),8,3)
  call Hotf_4pt_reduction(G2H3(58),RedSet_4(22),mass4set(:,25),  & 
G1H3(206),G1H3(207),G1H3(208),G1H3(209),G1H3(210),3)
  call HG1shiftOLR(G1H3(207),8,3)
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(17),mass4set(:,24),  & 
G1H3(211),G1H3(212),G1H3(213),G1H3(214),G1H3(215),3)
  call HG1shiftOLR(G1H3(212),8,3)
  call Hotf_4pt_reduction(G2H3(62),RedSet_4(17),mass4set(:,25),  & 
G1H3(216),G1H3(217),G1H3(218),G1H3(219),G1H3(220),3)
  call HG1shiftOLR(G1H3(217),8,3)
  call Hotf_4pt_reduction(G2H1(48),RedSet_4(42),mass4set(:,26),  & 
G1H1(74),G1H1(26),G1H1(31),G1H1(35),G1H1(4),1)
  call HG1shiftOLR(G1H1(26),4,1)
  call Hotf_4pt_reduction(G2H1(51),RedSet_4(43),mass4set(:,26),  & 
G1H1(5),G1H1(73),G1H1(68),G1H1(77),G1H1(78),1)
  call HG1shiftOLR(G1H1(73),4,1)
  call Hloop_ZQ_A(ntryL,G1H2(2),ex2(:),G1H1(79),ngZd,m3h2x1(:,52),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(79),31,0,G2tensor(190),n2h1(53))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(191),ngZd,m3h2x1(:,53),heltab2x2(:,:,54))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(192),ngZd,m3h2x1(:,54),heltab2x2(:,:,55))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(193),m3h2x1(:,55),heltab2x2(:,:,56))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(194),m3h2x1(:,56),heltab2x2(:,:,57))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(195),m3h2x1(:,57),heltab2x2(:,:,58))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(196),m3h2x1(:,58),heltab2x2(:,:,59))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(65),ex4(:),G2tensor(197),m3h3x1(:,242),heltab2x3(:,:,347))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(68),ex4(:),G2tensor(198),m3h3x1(:,243),heltab2x3(:,:,348))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(55),ex3(:),G2tensor(199),m3h1x1(:,113),heltab2x1(:,:,113))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(58),ex3(:),G2tensor(200),m3h1x1(:,114),heltab2x1(:,:,114))
  call Hotf_4pt_reduction(G2H1(59),RedSet_4(7),mass4set(:,6),  & 
G1H1(79),G1H1(80),G1H1(81),G1H1(82),G1H1(83),1)
  call HG1shiftOLR(G1H1(80),4,1)
  call Hloop_QS_A(ntryL,G2H1(61),ex3(:),G2H1(14),ngH,m3h1x1(:,115),heltab2x1(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(14),31,nML,G3tensor(1),n2h1(54))
  call Hloop_QS_A(ntryL,G1H1(53),ex3(:),G1H1(84),ngH,m3h1x1(:,116),heltab2x1(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(84),31,nML,G2tensor(201),n2h1(55))
  call Hotf_4pt_reduction(G2H1(62),RedSet_4(7),mass4set(:,7),  & 
G1H1(53),G1H1(84),G1H1(85),G1H1(86),G1H1(87),1)
  call HG1shiftOLR(G1H1(84),4,1)
  call Hloop_AS_Q(ntryL,G2H1(64),ex3(:),G2H1(32),ngH,m3h1x1(:,117),heltab2x1(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(32),31,nMT,G3tensor(2),n2h1(56))
  call Hloop_AS_Q(ntryL,G1H1(60),ex3(:),G1H1(88),ngH,m3h1x1(:,118),heltab2x1(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),31,nMT,G2tensor(202),n2h1(57))
  call Hotf_4pt_reduction(G2H1(65),RedSet_4(7),mass4set(:,8),  & 
G1H1(60),G1H1(88),G1H1(89),G1H1(90),G1H1(91),1)
  call HG1shiftOLR(G1H1(88),4,1)
  call Hloop_QS_A(ntryL,G2H1(67),ex3(:),G2H1(17),ngH,m3h1x1(:,119),heltab2x1(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,nMB,G3tensor(3),n2h1(58))
  call Hloop_QS_A(ntryL,G1H1(19),ex3(:),G1H1(92),ngH,m3h1x1(:,120),heltab2x1(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(92),31,nMB,G2tensor(203),n2h1(59))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(70),ex3(:),G2tensor(204),m3h1x1(:,121),heltab2x1(:,:,121))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(71),ex3(:),G2tensor(205),m3h1x1(:,122),heltab2x1(:,:,122))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(73),ex3(:),G2tensor(206),m3h1x1(:,123),heltab2x1(:,:,123))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(76),ex3(:),G2tensor(207),m3h1x1(:,124),heltab2x1(:,:,124))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(79),ex3(:),G2tensor(208),m3h1x1(:,125),heltab2x1(:,:,125))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(80),ex3(:),G2tensor(209),m3h1x1(:,126),heltab2x1(:,:,126))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(82),ex3(:),G2tensor(210),m3h1x1(:,127),heltab2x1(:,:,127))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(83),ex3(:),G2tensor(211),m3h1x1(:,128),heltab2x1(:,:,128))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(85),ex3(:),G2tensor(212),m3h1x1(:,129),heltab2x1(:,:,129))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(86),ex3(:),G2tensor(213),m3h1x1(:,130),heltab2x1(:,:,130))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(88),ex3(:),G2tensor(214),m3h1x1(:,131),heltab2x1(:,:,131))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(89),ex3(:),G2tensor(215),m3h1x1(:,132),heltab2x1(:,:,132))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(91),ex3(:),G2tensor(216),m3h1x1(:,133),heltab2x1(:,:,133))
  call Hotf_4pt_reduction(G2H3(69),RedSet_4(2),mass4set(:,6),  & 
G1H3(221),G1H3(222),G1H3(223),G1H3(224),G1H3(225),3)
  call HG1shiftOLR(G1H3(222),8,3)
  call Hloop_QZ_A(ntryL,G2H3(74),ex4(:),G2H1(35),ngZl,m3h3x1(:,244),heltab2x3(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(35),31,nML,G3tensor(4),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(7),ex4(:),G1H1(19),ngZl,m3h3x1(:,245),heltab2x3(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nML,G2tensor(217),n2h1(61))
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(2),mass4set(:,7),  & 
G1H3(7),G1H3(226),G1H3(227),G1H3(228),G1H3(229),3)
  call HG1shiftOLR(G1H3(226),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(77),ex4(:),G2H1(20),ngZu,m3h3x1(:,246),heltab2x3(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),31,nMT,G3tensor(5),n2h1(62))
  call Hloop_AZ_Q(ntryL,G1H3(108),ex4(:),G1H1(92),ngZu,m3h3x1(:,247),heltab2x3(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(92),31,nMT,G2tensor(218),n2h1(63))
  call Hotf_4pt_reduction(G2H3(78),RedSet_4(2),mass4set(:,8),  & 
G1H3(108),G1H3(230),G1H3(231),G1H3(232),G1H3(233),3)
  call HG1shiftOLR(G1H3(230),8,3)
  call Hloop_QZ_A(ntryL,G2H3(80),ex4(:),G2H1(23),ngZd,m3h3x1(:,248),heltab2x3(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMB,G3tensor(6),n2h1(64))
  call Hloop_QZ_A(ntryL,G1H3(113),ex4(:),G1H1(19),ngZd,m3h3x1(:,249),heltab2x3(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(219),n2h1(65))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(83),ex4(:),G2tensor(220),m3h3x1(:,250),heltab2x3(:,:,355))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(86),ex4(:),G2tensor(221),m3h3x1(:,251),heltab2x3(:,:,356))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(89),ex4(:),G2tensor(222),m3h3x1(:,252),heltab2x3(:,:,357))
  call Hotf_4pt_reduction(G2H3(90),RedSet_4(19),mass4set(:,13),  & 
G1H3(113),G1H3(234),G1H3(235),G1H3(236),G1H3(237),3)
  call HG1shiftOLR(G1H3(234),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(92),ex4(:),G2H1(38),ngZn,m3h3x1(:,253),heltab2x3(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(38),31,0,G3tensor(7),n2h1(66))
  call Hloop_AZ_Q(ntryL,G1H3(118),ex4(:),G1H1(92),ngZn,m3h3x1(:,254),heltab2x3(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(92),31,0,G2tensor(223),n2h1(67))
  call Hotf_4pt_reduction(G2H3(93),RedSet_4(19),mass4set(:,14),  & 
G1H3(118),G1H3(238),G1H3(239),G1H3(240),G1H3(241),3)
  call HG1shiftOLR(G1H3(238),8,3)
  call Hloop_QZ_A(ntryL,G2H3(95),ex4(:),G2H1(26),ngZd,m3h3x1(:,255),heltab2x3(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(26),31,nMB,G3tensor(8),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H3(123),ex4(:),G1H1(19),ngZd,m3h3x1(:,256),heltab2x3(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(224),n2h1(69))
  call Hotf_4pt_reduction(G2H3(96),RedSet_4(19),mass4set(:,15),  & 
G1H3(123),G1H3(242),G1H3(243),G1H3(244),G1H3(245),3)
  call HG1shiftOLR(G1H3(242),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(98),ex4(:),G2H1(41),ngZu,m3h3x1(:,257),heltab2x3(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(41),31,nMT,G3tensor(9),n2h1(70))
  call Hloop_AZ_Q(ntryL,G1H3(128),ex4(:),G1H1(92),ngZu,m3h3x1(:,258),heltab2x3(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(92),31,nMT,G2tensor(225),n2h1(71))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(101),ex4(:),G2tensor(226),m3h3x1(:,259),heltab2x3(:,:,364))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(104),ex4(:),G2tensor(227),m3h3x1(:,260),heltab2x3(:,:,365))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(107),ex4(:),G2tensor(228),m3h3x1(:,261),heltab2x3(:,:,366))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(110),ex4(:),G2tensor(229),m3h3x1(:,262),heltab2x3(:,:,367))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(230),m3h2x1(:,59),heltab2x2(:,:,60))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(231),m3h2x1(:,60),heltab2x2(:,:,61))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(232),m3h2x1(:,61),heltab2x2(:,:,62))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(233),m3h2x1(:,62),heltab2x2(:,:,63))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(234),m3h2x1(:,63),heltab2x2(:,:,64))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(16),ex2(:),G2tensor(235),m3h2x1(:,64),heltab2x2(:,:,65))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(236),ngZd,m3h2x1(:,65),heltab2x2(:,:,66))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(237),ngZd,m3h2x1(:,66),heltab2x2(:,:,67))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex2(:),G2tensor(238),m3h2x1(:,67),heltab2x2(:,:,68))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(31),ex2(:),G2tensor(239),m3h2x1(:,68),heltab2x2(:,:,69))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(71),27,ex3(:),4,G2tensor(240),m3h1x1(:,134),heltab2x1(:,:,134))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(72),0,ex3(:),4,G2tensor(241),m3h1x1(:,135),heltab2x1(:,:,135))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(2),27,ex3(:),4,G2tensor(242),m3h1x1(:,136),heltab2x1(:,:,136))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(13),27,ex3(:),4,G2tensor(243),m3h1x1(:,137),heltab2x1(:,:,137))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(54),0,ex3(:),4,G2tensor(244),m3h1x1(:,138),heltab2x1(:,:,138))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(64),27,ex3(:),4,G2tensor(245),m3h1x1(:,139),heltab2x1(:,:,139))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(136),23,ex4(:),8,G2tensor(246),m3h3x1(:,263),heltab2x3(:,:,368))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(137),0,ex4(:),8,G2tensor(247),m3h3x1(:,264),heltab2x3(:,:,369))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(141),23,ex4(:),8,G2tensor(248),m3h3x1(:,265),heltab2x3(:,:,370))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(142),23,ex4(:),8,G2tensor(249),m3h3x1(:,266),heltab2x3(:,:,371))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(143),0,ex4(:),8,G2tensor(250),m3h3x1(:,267),heltab2x3(:,:,372))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(147),23,ex4(:),8,G2tensor(251),m3h3x1(:,268),heltab2x3(:,:,373))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(14),27,ex3(:),4,G2tensor(252),m3h1x1(:,140),heltab2x1(:,:,140))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(15),0,ex3(:),4,G2tensor(253),m3h1x1(:,141),heltab2x1(:,:,141))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(9),27,ex3(:),4,G2tensor(254),m3h1x1(:,142),heltab2x1(:,:,142))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(10),27,ex3(:),4,G2tensor(255),m3h1x1(:,143),heltab2x1(:,:,143))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(16),0,ex3(:),4,G2tensor(256),m3h1x1(:,144),heltab2x1(:,:,144))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(11),27,ex3(:),4,G2tensor(257),m3h1x1(:,145),heltab2x1(:,:,145))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(148),23,ex4(:),8,G2tensor(258),m3h3x1(:,269),heltab2x3(:,:,374))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(150),0,ex4(:),8,G2tensor(259),m3h3x1(:,270),heltab2x3(:,:,375))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(153),23,ex4(:),8,G2tensor(260),m3h3x1(:,271),heltab2x3(:,:,376))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(155),23,ex4(:),8,G2tensor(261),m3h3x1(:,272),heltab2x3(:,:,377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(156),0,ex4(:),8,G2tensor(262),m3h3x1(:,273),heltab2x3(:,:,378))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(160),23,ex4(:),8,G2tensor(263),m3h3x1(:,274),heltab2x3(:,:,379))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(161),23,ex4(:),8,G2tensor(264),m3h3x1(:,275),heltab2x3(:,:,380))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(42),0,ex4(:),8,G2tensor(265),m3h3x1(:,276),heltab2x3(:,:,381))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(38),23,ex4(:),8,G2tensor(266),m3h3x1(:,277),heltab2x3(:,:,382))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(51),23,ex4(:),8,G2tensor(267),m3h3x1(:,278),heltab2x3(:,:,383))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(12),0,ex4(:),8,G2tensor(268),m3h3x1(:,279),heltab2x3(:,:,384))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(32),23,ex4(:),8,G2tensor(269),m3h3x1(:,280),heltab2x3(:,:,385))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(46),23,ex4(:),8,G2tensor(270),m3h3x1(:,281),heltab2x3(:,:,386))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(49),0,ex4(:),8,G2tensor(271),m3h3x1(:,282),heltab2x3(:,:,387))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(107),23,ex4(:),8,G2tensor(272),m3h3x1(:,283),heltab2x3(:,:,388))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(4),23,ex4(:),8,G2tensor(273),m3h3x1(:,284),heltab2x3(:,:,389))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(110),0,ex4(:),8,G2tensor(274),m3h3x1(:,285),heltab2x3(:,:,390))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(111),23,ex4(:),8,G2tensor(275),m3h3x1(:,286),heltab2x3(:,:,391))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(65),23,ex4(:),8,G2tensor(276),m3h3x1(:,287),heltab2x3(:,:,392))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(112),0,ex4(:),8,G2tensor(277),m3h3x1(:,288),heltab2x3(:,:,393))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(163),23,ex4(:),8,G2tensor(278),m3h3x1(:,289),heltab2x3(:,:,394))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(164),23,ex4(:),8,G2tensor(279),m3h3x1(:,290),heltab2x3(:,:,395))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(165),0,ex4(:),8,G2tensor(280),m3h3x1(:,291),heltab2x3(:,:,396))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(169),23,ex4(:),8,G2tensor(281),m3h3x1(:,292),heltab2x3(:,:,397))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(38),27,ex3(:),4,G2tensor(282),m3h1x1(:,146),heltab2x1(:,:,146))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(17),0,ex3(:),4,G2tensor(283),m3h1x1(:,147),heltab2x1(:,:,147))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(23),27,ex3(:),4,G2tensor(284),m3h1x1(:,148),heltab2x1(:,:,148))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(57),27,ex3(:),4,G2tensor(285),m3h1x1(:,149),heltab2x1(:,:,149))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(24),0,ex3(:),4,G2tensor(286),m3h1x1(:,150),heltab2x1(:,:,150))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(63),27,ex3(:),4,G2tensor(287),m3h1x1(:,151),heltab2x1(:,:,151))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(30),27,ex3(:),4,G2tensor(288),m3h1x1(:,152),heltab2x1(:,:,152))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(37),0,ex3(:),4,G2tensor(289),m3h1x1(:,153),heltab2x1(:,:,153))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(69),27,ex3(:),4,G2tensor(290),m3h1x1(:,154),heltab2x1(:,:,154))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(45),27,ex3(:),4,G2tensor(291),m3h1x1(:,155),heltab2x1(:,:,155))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(75),0,ex3(:),4,G2tensor(292),m3h1x1(:,156),heltab2x1(:,:,156))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(67),27,ex3(:),4,G2tensor(293),m3h1x1(:,157),heltab2x1(:,:,157))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(34),27,ex3(:),4,G2tensor(294),m3h1x1(:,158),heltab2x1(:,:,158))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(47),0,ex3(:),4,G2tensor(295),m3h1x1(:,159),heltab2x1(:,:,159))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(28),27,ex3(:),4,G2tensor(296),m3h1x1(:,160),heltab2x1(:,:,160))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(36),27,ex3(:),4,G2tensor(297),m3h1x1(:,161),heltab2x1(:,:,161))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(40),0,ex3(:),4,G2tensor(298),m3h1x1(:,162),heltab2x1(:,:,162))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(39),27,ex3(:),4,G2tensor(299),m3h1x1(:,163),heltab2x1(:,:,163))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(49),27,ex3(:),4,G2tensor(300),m3h1x1(:,164),heltab2x1(:,:,164))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(41),0,ex3(:),4,G2tensor(301),m3h1x1(:,165),heltab2x1(:,:,165))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(21),27,ex3(:),4,G2tensor(302),m3h1x1(:,166),heltab2x1(:,:,166))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(25),27,ex3(:),4,G2tensor(303),m3h1x1(:,167),heltab2x1(:,:,167))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(61),0,ex3(:),4,G2tensor(304),m3h1x1(:,168),heltab2x1(:,:,168))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(27),27,ex3(:),4,G2tensor(305),m3h1x1(:,169),heltab2x1(:,:,169))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(170),23,ex4(:),8,G2tensor(306),m3h3x1(:,293),heltab2x3(:,:,398))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(171),0,ex4(:),8,G2tensor(307),m3h3x1(:,294),heltab2x3(:,:,399))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(115),23,ex4(:),8,G2tensor(308),m3h3x1(:,295),heltab2x3(:,:,400))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(116),23,ex4(:),8,G2tensor(309),m3h3x1(:,296),heltab2x3(:,:,401))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(117),0,ex4(:),8,G2tensor(310),m3h3x1(:,297),heltab2x3(:,:,402))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(122),23,ex4(:),8,G2tensor(311),m3h3x1(:,298),heltab2x3(:,:,403))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(125),23,ex4(:),8,G2tensor(312),m3h3x1(:,299),heltab2x3(:,:,404))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(126),0,ex4(:),8,G2tensor(313),m3h3x1(:,300),heltab2x3(:,:,405))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(55),23,ex4(:),8,G2tensor(314),m3h3x1(:,301),heltab2x3(:,:,406))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(62),23,ex4(:),8,G2tensor(315),m3h3x1(:,302),heltab2x3(:,:,407))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(1),0,ex4(:),8,G2tensor(316),m3h3x1(:,303),heltab2x3(:,:,408))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(24),23,ex4(:),8,G2tensor(317),m3h3x1(:,304),heltab2x3(:,:,409))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(64),23,ex4(:),G2tensor(318),m3h3x1(:,305),heltab2x3(:,:,410))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(31),0,ex4(:),G2tensor(319),m3h3x1(:,306),heltab2x3(:,:,411))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(33),23,ex4(:),G2tensor(320),m3h3x1(:,307),heltab2x3(:,:,412))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(75),23,ex4(:),G2tensor(321),m3h3x1(:,308),heltab2x3(:,:,413))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(40),0,ex4(:),G2tensor(322),m3h3x1(:,309),heltab2x3(:,:,414))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(56),23,ex4(:),G2tensor(323),m3h3x1(:,310),heltab2x3(:,:,415))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(50),23,ex4(:),8,G2tensor(324),m3h3x1(:,311),heltab2x3(:,:,416))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(84),0,ex4(:),8,G2tensor(325),m3h3x1(:,312),heltab2x3(:,:,417))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(57),23,ex4(:),8,G2tensor(326),m3h3x1(:,313),heltab2x3(:,:,418))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(68),23,ex4(:),8,G2tensor(327),m3h3x1(:,314),heltab2x3(:,:,419))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(89),0,ex4(:),8,G2tensor(328),m3h3x1(:,315),heltab2x3(:,:,420))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(101),23,ex4(:),8,G2tensor(329),m3h3x1(:,316),heltab2x3(:,:,421))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(83),23,ex4(:),8,G2tensor(330),m3h3x1(:,317),heltab2x3(:,:,422))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(175),0,ex4(:),8,G2tensor(331),m3h3x1(:,318),heltab2x3(:,:,423))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(87),23,ex4(:),8,G2tensor(332),m3h3x1(:,319),heltab2x3(:,:,424))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(88),23,ex4(:),8,G2tensor(333),m3h3x1(:,320),heltab2x3(:,:,425))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(93),0,ex4(:),8,G2tensor(334),m3h3x1(:,321),heltab2x3(:,:,426))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(30),23,ex4(:),8,G2tensor(335),m3h3x1(:,322),heltab2x3(:,:,427))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(47),23,ex4(:),8,G2tensor(336),m3h3x1(:,323),heltab2x3(:,:,428))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(34),0,ex4(:),8,G2tensor(337),m3h3x1(:,324),heltab2x3(:,:,429))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(18),23,ex4(:),8,G2tensor(338),m3h3x1(:,325),heltab2x3(:,:,430))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(192),23,ex4(:),8,G2tensor(339),m3h3x1(:,326),heltab2x3(:,:,431))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(54),0,ex4(:),8,G2tensor(340),m3h3x1(:,327),heltab2x3(:,:,432))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(80),23,ex4(:),8,G2tensor(341),m3h3x1(:,328),heltab2x3(:,:,433))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(70),23,ex4(:),G2tensor(342),m3h3x1(:,329),heltab2x3(:,:,434))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(74),0,ex4(:),G2tensor(343),m3h3x1(:,330),heltab2x3(:,:,435))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(191),23,ex4(:),G2tensor(344),m3h3x1(:,331),heltab2x3(:,:,436))
  call Hloop_QZ_A(ntryL,G1H3(85),wf3(:,1),G1H1(19),ngZd,m3h3x1(:,332),heltab2x3(:,:,437))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,0,G2tensor(345),n2h1(107))
  call Hloop_QZ_A(ntryL,G1H3(91),wf3(:,1),G1H1(92),ngZd,m3h3x1(:,333),heltab2x3(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(92),12,0,G2tensor(346),n2h1(108))
  call Hloop_QZ_A(ntryL,G1H3(97),wf3(:,1),G1H1(71),ngZd,m3h3x1(:,334),heltab2x3(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(71),31,0,G2tensor(347),n2h1(109))
  call Hloop_QZ_A(ntryL,G1H3(189),wf3(:,1),G1H1(72),ngZd,m3h3x1(:,335),heltab2x3(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,0,G2tensor(348),n2h1(110))
  call Hloop_QZ_A(ntryL,G1H3(102),wf3(:,1),G1H1(2),ngZd,m3h3x1(:,336),heltab2x3(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),12,0,G2tensor(349),n2h1(111))
  call Hloop_QZ_A(ntryL,G1H3(92),wf3(:,1),G1H1(13),ngZd,m3h3x1(:,337),heltab2x3(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,0,G2tensor(350),n2h1(112))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(67),19,wf3(:,1),12,G2tensor(351),m3h3x1(:,338),heltab2x3(:,:,443))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(106),0,wf3(:,1),12,G2tensor(352),m3h3x1(:,339),heltab2x3(:,:,444))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(162),19,wf3(:,1),12,G2tensor(353),m3h3x1(:,340),heltab2x3(:,:,445))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(48),19,wf3(:,1),12,G2tensor(354),m3h3x1(:,341),heltab2x3(:,:,446))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(99),0,wf3(:,1),12,G2tensor(355),m3h3x1(:,342),heltab2x3(:,:,447))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(177),19,wf3(:,1),12,G2tensor(356),m3h3x1(:,343),heltab2x3(:,:,448))
  call Hloop_AZ_Q(ntryL,G1H3(178),wf3(:,1),G1H1(54),ngZu,m3h3x1(:,344),heltab2x3(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(54),31,0,G2tensor(357),n2h1(115))
  call Hloop_AZ_Q(ntryL,G1H3(179),wf3(:,1),G1H1(64),ngZu,m3h3x1(:,345),heltab2x3(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(64),12,0,G2tensor(358),n2h1(116))
  call Hloop_AZ_Q(ntryL,G1H3(182),wf3(:,1),G1H1(14),ngZu,m3h3x1(:,346),heltab2x3(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,0,G2tensor(359),n2h1(117))
  call Hloop_AZ_Q(ntryL,G1H3(183),wf3(:,1),G1H1(15),ngZu,m3h3x1(:,347),heltab2x3(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(15),31,0,G2tensor(360),n2h1(118))
  call Hloop_AZ_Q(ntryL,G1H3(184),wf3(:,1),G1H1(9),ngZu,m3h3x1(:,348),heltab2x3(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),12,0,G2tensor(361),n2h1(119))
  call Hloop_AZ_Q(ntryL,G1H3(195),wf3(:,1),G1H1(10),ngZu,m3h3x1(:,349),heltab2x3(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,0,G2tensor(362),n2h1(120))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(186),19,wf3(:,1),12,G2tensor(363),m3h3x1(:,350),heltab2x3(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(187),0,wf3(:,1),12,G2tensor(364),m3h3x1(:,351),heltab2x3(:,:,456))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(197),19,wf3(:,1),12,G2tensor(365),m3h3x1(:,352),heltab2x3(:,:,457))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(198),19,wf3(:,1),12,G2tensor(366),m3h3x1(:,353),heltab2x3(:,:,458))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(199),0,wf3(:,1),12,G2tensor(367),m3h3x1(:,354),heltab2x3(:,:,459))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(202),19,wf3(:,1),12,G2tensor(368),m3h3x1(:,355),heltab2x3(:,:,460))
  call Hloop_AZ_Q(ntryL,G1H3(190),ex4(:),G1H1(16),ngZu,m3h3x1(:,356),heltab2x3(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,0,G2tensor(369),n2h1(123))
  call Hloop_AZ_Q(ntryL,G1H3(6),ex4(:),G1H1(11),ngZu,m3h3x1(:,357),heltab2x3(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),8,0,G2tensor(370),n2h1(124))
  call Hloop_AZ_Q(ntryL,G1H3(205),ex4(:),G1H1(38),ngZu,m3h3x1(:,358),heltab2x3(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),31,0,G2tensor(371),n2h1(125))
  call Hloop_AZ_Q(ntryL,G1H3(206),ex4(:),G1H1(17),ngZu,m3h3x1(:,359),heltab2x3(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,0,G2tensor(372),n2h1(126))
  call Hloop_AZ_Q(ntryL,G1H3(207),ex4(:),G1H1(23),ngZu,m3h3x1(:,360),heltab2x3(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),8,0,G2tensor(373),n2h1(127))
  call Hloop_AZ_Q(ntryL,G1H3(210),ex4(:),G1H1(57),ngZu,m3h3x1(:,361),heltab2x3(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(57),31,0,G2tensor(374),n2h1(128))
  call Hloop_QZ_A(ntryL,G1H3(211),ex4(:),G1H1(24),ngZd,m3h3x1(:,362),heltab2x3(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,0,G2tensor(375),n2h1(129))
  call Hloop_QZ_A(ntryL,G1H3(212),ex4(:),G1H1(63),ngZd,m3h3x1(:,363),heltab2x3(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(63),8,0,G2tensor(376),n2h1(130))
  call Hloop_QZ_A(ntryL,G1H3(215),ex4(:),G1H1(30),ngZd,m3h3x1(:,364),heltab2x3(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),31,0,G2tensor(377),n2h1(131))
  call Hloop_QZ_A(ntryL,G1H3(216),ex4(:),G1H1(37),ngZd,m3h3x1(:,365),heltab2x3(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,0,G2tensor(378),n2h1(132))
  call Hloop_QZ_A(ntryL,G1H3(217),ex4(:),G1H1(69),ngZd,m3h3x1(:,366),heltab2x3(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(69),8,0,G2tensor(379),n2h1(133))
  call Hloop_QZ_A(ntryL,G1H3(220),ex4(:),G1H1(45),ngZd,m3h3x1(:,367),heltab2x3(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),31,0,G2tensor(380),n2h1(134))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(74),27,ex3(:),4,G2tensor(381),m3h1x1(:,170),heltab2x1(:,:,170))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(26),0,ex3(:),4,G2tensor(382),m3h1x1(:,171),heltab2x1(:,:,171))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(4),27,ex3(:),4,G2tensor(383),m3h1x1(:,172),heltab2x1(:,:,172))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(5),27,ex3(:),4,G2tensor(384),m3h1x1(:,173),heltab2x1(:,:,173))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(73),0,ex3(:),4,G2tensor(385),m3h1x1(:,174),heltab2x1(:,:,174))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(78),27,ex3(:),4,G2tensor(386),m3h1x1(:,175),heltab2x1(:,:,175))
  call Hloop_QS_A(ntryL,G1H1(79),ex3(:),G1H1(75),ngH,m3h1x1(:,176),heltab2x1(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(75),31,nML,G2tensor(387),n2h1(137))
  call Hloop_QS_A(ntryL,G1H1(80),ex3(:),G1H1(67),ngH,m3h1x1(:,177),heltab2x1(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(67),4,nML,G2tensor(388),n2h1(138))
  call Hloop_QS_A(ntryL,G1H1(83),ex3(:),G1H1(34),ngH,m3h1x1(:,178),heltab2x1(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nML,G2tensor(389),n2h1(139))
  call Hloop_AS_Q(ntryL,G1H1(53),ex3(:),G1H1(47),ngH,m3h1x1(:,179),heltab2x1(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),31,nMT,G2tensor(390),n2h1(140))
  call Hloop_AS_Q(ntryL,G1H1(84),ex3(:),G1H1(28),ngH,m3h1x1(:,180),heltab2x1(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),4,nMT,G2tensor(391),n2h1(141))
  call Hloop_AS_Q(ntryL,G1H1(87),ex3(:),G1H1(36),ngH,m3h1x1(:,181),heltab2x1(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),31,nMT,G2tensor(392),n2h1(142))
  call Hloop_QS_A(ntryL,G1H1(60),ex3(:),G1H1(40),ngH,m3h1x1(:,182),heltab2x1(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),31,nMB,G2tensor(393),n2h1(143))
  call Hloop_QS_A(ntryL,G1H1(88),ex3(:),G1H1(39),ngH,m3h1x1(:,183),heltab2x1(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),4,nMB,G2tensor(394),n2h1(144))
  call Hloop_QS_A(ntryL,G1H1(91),ex3(:),G1H1(49),ngH,m3h1x1(:,184),heltab2x1(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(49),31,nMB,G2tensor(395),n2h1(145))
  call Hloop_QZ_A(ntryL,G1H3(221),ex4(:),G1H1(41),ngZl,m3h3x1(:,368),heltab2x3(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,nML,G2tensor(396),n2h1(146))
  call Hloop_QZ_A(ntryL,G1H3(222),ex4(:),G1H1(21),ngZl,m3h3x1(:,369),heltab2x3(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),8,nML,G2tensor(397),n2h1(147))
  call Hloop_QZ_A(ntryL,G1H3(225),ex4(:),G1H1(25),ngZl,m3h3x1(:,370),heltab2x3(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,nML,G2tensor(398),n2h1(148))
  call Hloop_AZ_Q(ntryL,G1H3(7),ex4(:),G1H1(61),ngZu,m3h3x1(:,371),heltab2x3(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),31,nMT,G2tensor(399),n2h1(149))
  call Hloop_AZ_Q(ntryL,G1H3(226),ex4(:),G1H1(27),ngZu,m3h3x1(:,372),heltab2x3(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),8,nMT,G2tensor(400),n2h1(150))
  call Hloop_AZ_Q(ntryL,G1H3(229),ex4(:),G1H1(19),ngZu,m3h3x1(:,373),heltab2x3(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(401),n2h1(151))
  call Hloop_QZ_A(ntryL,G1H3(108),ex4(:),G1H1(92),ngZd,m3h3x1(:,374),heltab2x3(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(92),31,nMB,G2tensor(402),n2h1(152))
  call Hloop_QZ_A(ntryL,G1H3(230),ex4(:),G1H1(71),ngZd,m3h3x1(:,375),heltab2x3(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(71),8,nMB,G2tensor(403),n2h1(153))
  call Hloop_QZ_A(ntryL,G1H3(233),ex4(:),G1H1(72),ngZd,m3h3x1(:,376),heltab2x3(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,nMB,G2tensor(404),n2h1(154))
  call Hloop_AZ_Q(ntryL,G1H3(113),ex4(:),G1H1(2),ngZn,m3h3x1(:,377),heltab2x3(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,0,G2tensor(405),n2h1(155))
  call Hloop_AZ_Q(ntryL,G1H3(234),ex4(:),G1H1(13),ngZn,m3h3x1(:,378),heltab2x3(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),8,0,G2tensor(406),n2h1(156))
  call Hloop_AZ_Q(ntryL,G1H3(237),ex4(:),G1H1(54),ngZn,m3h3x1(:,379),heltab2x3(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(54),31,0,G2tensor(407),n2h1(157))
  call Hloop_QZ_A(ntryL,G1H3(118),ex4(:),G1H1(64),ngZd,m3h3x1(:,380),heltab2x3(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nMB,G2tensor(408),n2h1(158))
  call Hloop_QZ_A(ntryL,G1H3(238),ex4(:),G1H1(14),ngZd,m3h3x1(:,381),heltab2x3(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),8,nMB,G2tensor(409),n2h1(159))
  call Hloop_QZ_A(ntryL,G1H3(241),ex4(:),G1H1(15),ngZd,m3h3x1(:,382),heltab2x3(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),31,nMB,G2tensor(410),n2h1(160))
  call Hloop_AZ_Q(ntryL,G1H3(123),ex4(:),G1H1(9),ngZu,m3h3x1(:,383),heltab2x3(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMT,G2tensor(411),n2h1(161))
  call Hloop_AZ_Q(ntryL,G1H3(242),ex4(:),G1H1(10),ngZu,m3h3x1(:,384),heltab2x3(:,:,489))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),8,nMT,G2tensor(412),n2h1(162))
  call Hloop_AZ_Q(ntryL,G1H3(245),ex4(:),G1H1(16),ngZu,m3h3x1(:,385),heltab2x3(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,nMT,G2tensor(413),n2h1(163))
  call ol_merge_tensors(G2tensor(2),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(39),G2tensor(4),G1tensor(74)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(80)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(57),G2tensor(8),G1tensor(86)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(92)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(12),G1tensor(98)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(14),G1tensor(104)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(18),G1tensor(116)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(20),G1tensor(122)])
  call ol_merge_tensors(G2tensor(363),[G2tensor(185),G2tensor(66),G2tensor(60),G2tensor(51),G2tensor(42),G2tensor(26),G2tensor(22) &
    ,G1tensor(99),G1tensor(21),G1tensor(26),G1tensor(14)])
  call ol_merge_tensors(G2tensor(366),[G2tensor(187),G2tensor(69),G2tensor(63),G2tensor(54),G2tensor(48),G2tensor(28),G2tensor(24) &
    ,G1tensor(111),G1tensor(27),G1tensor(32),G1tensor(20)])
  call ol_merge_tensors(G2tensor(351),[G2tensor(182),G2tensor(93),G2tensor(87),G2tensor(81),G2tensor(72),G2tensor(34),G2tensor(30) &
    ,G1tensor(81),G1tensor(1),G1tensor(56),G1tensor(44)])
  call ol_merge_tensors(G2tensor(354),[G2tensor(184),G2tensor(96),G2tensor(90),G2tensor(84),G2tensor(78),G2tensor(36),G2tensor(32) &
    ,G1tensor(93),G1tensor(15),G1tensor(62),G1tensor(50)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(38),G1tensor(70)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(155),G2tensor(50),G2tensor(41),G1tensor(9)])
  call ol_merge_tensors(G2tensor(381),[G2tensor(154),G2tensor(44),G1tensor(2)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(45),G1tensor(105),G1tensor(5),G1tensor(7)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(156),G2tensor(53),G2tensor(47),G1tensor(16)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(56),G1tensor(82)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(160),G2tensor(65),G2tensor(59),G1tensor(22)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(149),G2tensor(68),G2tensor(62),G1tensor(83),G1tensor(28)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(158),G2tensor(80),G2tensor(71),G1tensor(40)])
  call ol_merge_tensors(G2tensor(384),[G2tensor(157),G2tensor(74),G1tensor(34)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(75),G1tensor(87),G1tensor(8),G1tensor(38)])
  call ol_merge_tensors(G2tensor(255),[G2tensor(159),G2tensor(83),G2tensor(77),G1tensor(46)])
  call ol_merge_tensors(G2tensor(258),[G2tensor(161),G2tensor(92),G2tensor(86),G1tensor(52)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(147),G2tensor(95),G2tensor(89),G1tensor(71),G1tensor(58)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(124)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(99),G1tensor(128)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(101),G1tensor(94)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(104),G1tensor(100)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(107),G1tensor(130)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(108),G1tensor(134)])
  call ol_merge_tensors(G2tensor(193),[G2tensor(110),G1tensor(112)])
  call ol_merge_tensors(G2tensor(195),[G2tensor(113),G1tensor(118)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(270),[G2tensor(169),G1tensor(36),G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(11),G2tensor(33),G1tensor(17),G1tensor(10)])
  call ol_merge_tensors(G2tensor(318),[G2tensor(312),G2tensor(276),G2tensor(267),G2tensor(167),G1tensor(57),G1tensor(42) &
    ,G1tensor(12)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(88),G2tensor(70),G1tensor(13)])
  call ol_merge_tensors(G2tensor(321),[G2tensor(315),G2tensor(279),G2tensor(273),G2tensor(171),G2tensor(168),G1tensor(48) &
    ,G1tensor(18)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(7),G2tensor(29),G1tensor(19)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(64),G2tensor(43),G1tensor(29),G1tensor(23)])
  call ol_merge_tensors(G2tensor(288),[G2tensor(282),G2tensor(213),G2tensor(209),G2tensor(165),G1tensor(33),G1tensor(54) &
    ,G1tensor(24)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(49),G2tensor(23),G1tensor(97),G1tensor(25)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(285),G2tensor(215),G2tensor(211),G2tensor(166),G2tensor(164),G1tensor(60) &
    ,G1tensor(30)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(52),G2tensor(58),G1tensor(103),G1tensor(31)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(37)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(37),G2tensor(79),G1tensor(47),G1tensor(41)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(82),G2tensor(76),G1tensor(43)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(1),G2tensor(31),G1tensor(49)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(15),G2tensor(9),G1tensor(59),G1tensor(53)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(100),G2tensor(61),G1tensor(115),G1tensor(55)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(103),G2tensor(27),G1tensor(121),G1tensor(61)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(146),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(66)])
  call ol_merge_tensors(G2tensor(330),[G2tensor(40),G1tensor(79),G1tensor(67)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(85),G1tensor(72)])
  call ol_merge_tensors(G2tensor(342),[G2tensor(339),G2tensor(336),G2tensor(264),G2tensor(173),G2tensor(21),G1tensor(85) &
    ,G1tensor(73)])
  call ol_merge_tensors(G2tensor(129),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(130),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(19),G1tensor(84)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(91)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(116),G1tensor(101),G1tensor(95)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(117),G1tensor(96)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(118),G1tensor(102)])
  call ol_merge_tensors(G2tensor(191),[G1tensor(106)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(109)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(122),G1tensor(119),G1tensor(113)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(123),G1tensor(114)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(124),G1tensor(120)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(125)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(127)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(131)])
  call ol_merge_tensors(G2tensor(120),[G1tensor(132)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(133)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(297),G2tensor(163),G1tensor(45)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(294),G2tensor(205),G1tensor(39)])
  call ol_merge_tensors(G2tensor(306),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(324),[G2tensor(309),G2tensor(170),G1tensor(11)])
  call ol_merge_tensors(G2tensor(327),[G1tensor(75),G1tensor(69),G1tensor(63)])
  call ol_merge_tensors(G2tensor(333),[G2tensor(172)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(20),mass4set(:,27),  & 
G1tensor(117),G1tensor(123),G1tensor(129),G1tensor(68),G1tensor(74))
  call G_TensorShift(G1tensor(123),10)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(20),mass4set(:,28),  & 
G1tensor(80),G1tensor(86),G1tensor(92),G1tensor(98),G1tensor(104))
  call G_TensorShift(G1tensor(86),10)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(24),mass4set(:,27),  & 
G1tensor(110),G1tensor(116),G1tensor(122),G1tensor(99),G1tensor(21))
  call G_TensorShift(G1tensor(116),9)
  call Hotf_4pt_reduction_last(G2tensor(177),RedSet_4(24),mass4set(:,28),  & 
G1tensor(26),G1tensor(14),G1tensor(111),G1tensor(27),G1tensor(32))
  call G_TensorShift(G1tensor(14),9)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(28),mass4set(:,1),  & 
G1tensor(20),G1tensor(81),G1tensor(1),G1tensor(56),G1tensor(44))
  call G_TensorShift(G1tensor(81),5)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(28),mass4set(:,2),  & 
G1tensor(93),G1tensor(15),G1tensor(62),G1tensor(50),G1tensor(70))
  call G_TensorShift(G1tensor(15),5)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(28),mass4set(:,3),  & 
G1tensor(9),G1tensor(2),G1tensor(105),G1tensor(5),G1tensor(7))
  call G_TensorShift(G1tensor(2),5)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(32),mass4set(:,1),  & 
G1tensor(16),G1tensor(82),G1tensor(22),G1tensor(83),G1tensor(28))
  call G_TensorShift(G1tensor(82),6)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(32),mass4set(:,2),  & 
G1tensor(40),G1tensor(34),G1tensor(87),G1tensor(8),G1tensor(38))
  call G_TensorShift(G1tensor(34),6)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(32),mass4set(:,3),  & 
G1tensor(46),G1tensor(52),G1tensor(71),G1tensor(58),G1tensor(124))
  call G_TensorShift(G1tensor(52),6)
  call Hotf_4pt_reduction_last(G2tensor(363),RedSet_4(4),mass4set(:,20),  & 
G1tensor(128),G1tensor(94),G1tensor(100),G1tensor(130),G1tensor(134))
  call G_TensorShift(G1tensor(94),12)
  call Hotf_4pt_reduction_last(G2tensor(366),RedSet_4(4),mass4set(:,21),  & 
G1tensor(112),G1tensor(118),G1tensor(3),G1tensor(36),G1tensor(4))
  call G_TensorShift(G1tensor(118),12)
  call Hotf_4pt_reduction_last(G2tensor(351),RedSet_4(12),mass4set(:,20),  & 
G1tensor(6),G1tensor(17),G1tensor(10),G1tensor(57),G1tensor(42))
  call G_TensorShift(G1tensor(17),12)
  call Hotf_4pt_reduction_last(G2tensor(354),RedSet_4(12),mass4set(:,21),  & 
G1tensor(12),G1tensor(13),G1tensor(48),G1tensor(18),G1tensor(19))
  call G_TensorShift(G1tensor(13),12)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(44),mass4set(:,28),  & 
G1tensor(29),G1tensor(23),G1tensor(33),G1tensor(54),G1tensor(24))
  call G_TensorShift(G1tensor(23),2)
  call Hotf_4pt_reduction_last(G2tensor(240),RedSet_4(42),mass4set(:,20),  & 
G1tensor(97),G1tensor(25),G1tensor(60),G1tensor(30),G1tensor(103))
  call G_TensorShift(G1tensor(25),4)
  call Hotf_4pt_reduction_last(G2tensor(381),RedSet_4(42),mass4set(:,26),  & 
G1tensor(31),G1tensor(35),G1tensor(37),G1tensor(47),G1tensor(41))
  call G_TensorShift(G1tensor(35),4)
  call Hotf_4pt_reduction_last(G2tensor(186),RedSet_4(4),mass4set(:,29),  & 
G1tensor(43),G1tensor(49),G1tensor(59),G1tensor(53),G1tensor(115))
  call G_TensorShift(G1tensor(49),12)
  call Hotf_4pt_reduction_last(G2tensor(243),RedSet_4(42),mass4set(:,21),  & 
G1tensor(55),G1tensor(121),G1tensor(61),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(121),4)
  call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(45),mass4set(:,28),  & 
G1tensor(66),G1tensor(79),G1tensor(67),G1tensor(72),G1tensor(85))
  call G_TensorShift(G1tensor(79),1)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(22),mass4set(:,20),  & 
G1tensor(73),G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(84))
  call G_TensorShift(G1tensor(76),8)
  call Hotf_4pt_reduction_last(G2tensor(249),RedSet_4(22),mass4set(:,21),  & 
G1tensor(88),G1tensor(89),G1tensor(90),G1tensor(91),G1tensor(101))
  call G_TensorShift(G1tensor(89),8)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(43),mass4set(:,20),  & 
G1tensor(95),G1tensor(96),G1tensor(102),G1tensor(106),G1tensor(107))
  call G_TensorShift(G1tensor(96),4)
  call Hotf_4pt_reduction_last(G2tensor(384),RedSet_4(43),mass4set(:,26),  & 
G1tensor(108),G1tensor(109),G1tensor(119),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(109),4)
  call Hotf_4pt_reduction_last(G2tensor(183),RedSet_4(12),mass4set(:,29),  & 
G1tensor(120),G1tensor(125),G1tensor(126),G1tensor(127),G1tensor(131))
  call G_TensorShift(G1tensor(125),12)
  call Hotf_4pt_reduction_last(G2tensor(255),RedSet_4(43),mass4set(:,21),  & 
G1tensor(132),G1tensor(133),G1tensor(45),G1tensor(39),G1tensor(51))
  call G_TensorShift(G1tensor(133),4)
  call Hotf_4pt_reduction_last(G2tensor(258),RedSet_4(17),mass4set(:,20),  & 
G1tensor(11),G1tensor(75),G1tensor(69),G1tensor(63),G1tensor(135))
  call G_TensorShift(G1tensor(75),8)
  call Hotf_4pt_reduction_last(G2tensor(261),RedSet_4(17),mass4set(:,21),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(46),mass4set(:,30),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),1)
  call Hotf_4pt_reduction_last(G2tensor(174),RedSet_4(35),mass4set(:,30),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),9)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(47),mass4set(:,2),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),1)
  call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(47),mass4set(:,3),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),1)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(48),mass4set(:,30),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),2)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(38),mass4set(:,30),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),10)
  call Hotf_4pt_reduction_last(G2tensor(193),RedSet_4(40),mass4set(:,2),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),2)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(40),mass4set(:,3),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),2)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(1),mass4set(:,31),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_4pt_reduction_last(G2tensor(270),RedSet_4(2),mass4set(:,12),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,29),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),8)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(1),mass4set(:,4),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(2),mass4set(:,4),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(3),mass4set(:,20),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),8)
  call Hotf_4pt_reduction_last(G2tensor(321),RedSet_4(2),mass4set(:,5),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(3),mass4set(:,21),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(6),mass4set(:,4),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),4)
  call Hotf_4pt_reduction_last(G2tensor(288),RedSet_4(7),mass4set(:,4),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(8),mass4set(:,20),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_4pt_reduction_last(G2tensor(291),RedSet_4(7),mass4set(:,5),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),4)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(8),mass4set(:,21),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(10),mass4set(:,31),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(11),mass4set(:,29),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(10),mass4set(:,4),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(11),mass4set(:,20),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),8)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(11),mass4set(:,21),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),8)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(14),mass4set(:,4),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(15),mass4set(:,20),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),4)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(15),mass4set(:,21),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),4)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(44),mass4set(:,32),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),2)
  call Hotf_4pt_reduction_last(G2tensor(146),RedSet_4(17),mass4set(:,29),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(18),mass4set(:,29),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),8)
  call Hotf_4pt_reduction_last(G2tensor(330),RedSet_4(19),mass4set(:,17),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(18),mass4set(:,21),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),8)
  call Hotf_4pt_reduction_last(G2tensor(342),RedSet_4(19),mass4set(:,18),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),8)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(45),mass4set(:,32),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),1)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(22),mass4set(:,29),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),8)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(23),mass4set(:,29),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),8)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(23),mass4set(:,21),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(47),mass4set(:,1),  & 
G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340))
  call G_TensorShift(G1tensor(337),1)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(26),mass4set(:,33),  & 
G1tensor(341),G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(342),4)
  call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(27),mass4set(:,26),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),4)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(8),mass4set(:,26),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),4)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(26),mass4set(:,20),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),4)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(27),mass4set(:,20),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),4)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(27),mass4set(:,21),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),4)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(40),mass4set(:,1),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),2)
  call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(30),mass4set(:,33),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),4)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(31),mass4set(:,26),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),4)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(15),mass4set(:,26),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),4)
  call Hotf_4pt_reduction_last(G2tensor(153),RedSet_4(30),mass4set(:,20),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(31),mass4set(:,20),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),4)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(31),mass4set(:,21),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(34),mass4set(:,34),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),8)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(23),mass4set(:,25),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),8)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(3),mass4set(:,25),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),8)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(37),mass4set(:,34),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),8)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(18),mass4set(:,25),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),8)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(11),mass4set(:,25),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),8)
  call Hotf_4pt_reduction_last(G2tensor(162),RedSet_4(7),mass4set(:,9),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),4)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(7),mass4set(:,11),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),4)
  call Hotf_4pt_reduction_last(G2tensor(300),RedSet_4(7),mass4set(:,10),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),4)
  call Hotf_4pt_reduction_last(G2tensor(306),RedSet_4(2),mass4set(:,22),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_4pt_reduction_last(G2tensor(324),RedSet_4(2),mass4set(:,11),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),8)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(19),mass4set(:,23),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),8)
  call Hotf_4pt_reduction_last(G2tensor(333),RedSet_4(19),mass4set(:,16),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),8)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(24),mass4set(:,35),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),9)
  call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(24),mass4set(:,32),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),9)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(20),mass4set(:,35),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),10)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(20),mass4set(:,32),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),10)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(37),mass4set(:,35),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),8)
  call Hotf_4pt_reduction_last(G2tensor(189),RedSet_4(34),mass4set(:,35),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),8)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(7),mass4set(:,6),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505),G0tensor(1))
  call G_TensorShift(G1tensor(502),4)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(7),mass4set(:,7),  & 
G1tensor(501),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G0tensor(2))
  call G_TensorShift(G1tensor(506),4)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(7),mass4set(:,8),  & 
G1tensor(501),G1tensor(510),G1tensor(511),G1tensor(512),G1tensor(513),G0tensor(3))
  call G_TensorShift(G1tensor(510),4)
  call Hotf_4pt_reduction_last(G2tensor(217),RedSet_4(2),mass4set(:,6),  & 
G1tensor(501),G1tensor(514),G1tensor(515),G1tensor(516),G1tensor(517),G0tensor(4))
  call G_TensorShift(G1tensor(514),8)
  call Hotf_4pt_reduction_last(G2tensor(218),RedSet_4(2),mass4set(:,7),  & 
G1tensor(501),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G0tensor(5))
  call G_TensorShift(G1tensor(518),8)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(2),mass4set(:,8),  & 
G1tensor(501),G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525),G0tensor(6))
  call G_TensorShift(G1tensor(522),8)
  call Hotf_4pt_reduction_last(G2tensor(223),RedSet_4(19),mass4set(:,13),  & 
G1tensor(501),G1tensor(526),G1tensor(527),G1tensor(528),G1tensor(529),G0tensor(7))
  call G_TensorShift(G1tensor(526),8)
  call Hotf_4pt_reduction_last(G2tensor(224),RedSet_4(19),mass4set(:,14),  & 
G1tensor(501),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G0tensor(8))
  call G_TensorShift(G1tensor(530),8)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(19),mass4set(:,15),  & 
G1tensor(501),G1tensor(534),G1tensor(535),G1tensor(536),G1tensor(537),G0tensor(9))
  call G_TensorShift(G1tensor(534),8)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(41),mass4set(:,2),  & 
G1tensor(501),G1tensor(538),G1tensor(539),G1tensor(540),G1tensor(541))
  call G_TensorShift(G1tensor(538),2)
  call Hotf_4pt_reduction_last(G2tensor(232),RedSet_4(41),mass4set(:,19),  & 
G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(543),2)
  call Hotf_4pt_reduction_last(G2tensor(234),RedSet_4(41),mass4set(:,3),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551))
  call G_TensorShift(G1tensor(548),2)
  call Hotf_4pt_reduction_last(G2tensor(236),RedSet_4(41),mass4set(:,1),  & 
G1tensor(552),G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556))
  call G_TensorShift(G1tensor(553),2)
  call Hotf_4pt_reduction_last(G2tensor(238),RedSet_4(40),mass4set(:,19),  & 
G1tensor(557),G1tensor(558),G1tensor(559),G1tensor(560),G1tensor(561))
  call G_TensorShift(G1tensor(558),2)
  call Hotf_4pt_reduction_last(G2tensor(345),RedSet_4(12),mass4set(:,24),  & 
G1tensor(562),G1tensor(563),G1tensor(564),G1tensor(565),G1tensor(566))
  call G_TensorShift(G1tensor(563),12)
  call Hotf_4pt_reduction_last(G2tensor(348),RedSet_4(12),mass4set(:,25),  & 
G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570),G1tensor(571))
  call G_TensorShift(G1tensor(568),12)
  call Hotf_4pt_reduction_last(G2tensor(357),RedSet_4(4),mass4set(:,24),  & 
G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(573),12)
  call Hotf_4pt_reduction_last(G2tensor(360),RedSet_4(4),mass4set(:,25),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581))
  call G_TensorShift(G1tensor(578),12)
  call Hotf_4pt_reduction_last(G2tensor(369),RedSet_4(22),mass4set(:,24),  & 
G1tensor(582),G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586))
  call G_TensorShift(G1tensor(583),8)
  call Hotf_4pt_reduction_last(G2tensor(372),RedSet_4(22),mass4set(:,25),  & 
G1tensor(587),G1tensor(588),G1tensor(589),G1tensor(590),G1tensor(591))
  call G_TensorShift(G1tensor(588),8)
  call Hotf_4pt_reduction_last(G2tensor(375),RedSet_4(17),mass4set(:,24),  & 
G1tensor(592),G1tensor(593),G1tensor(594),G1tensor(595),G1tensor(596))
  call G_TensorShift(G1tensor(593),8)
  call Hotf_4pt_reduction_last(G2tensor(378),RedSet_4(17),mass4set(:,25),  & 
G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600),G1tensor(601))
  call G_TensorShift(G1tensor(598),8)
  call Hotf_4pt_reduction_last(G2tensor(387),RedSet_4(7),mass4set(:,6),  & 
G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(603),4)
  call Hotf_4pt_reduction_last(G2tensor(390),RedSet_4(7),mass4set(:,7),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611))
  call G_TensorShift(G1tensor(608),4)
  call Hotf_4pt_reduction_last(G2tensor(393),RedSet_4(7),mass4set(:,8),  & 
G1tensor(612),G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616))
  call G_TensorShift(G1tensor(613),4)
  call Hotf_4pt_reduction_last(G2tensor(396),RedSet_4(2),mass4set(:,6),  & 
G1tensor(617),G1tensor(618),G1tensor(619),G1tensor(620),G1tensor(621))
  call G_TensorShift(G1tensor(618),8)
  call Hotf_4pt_reduction_last(G2tensor(399),RedSet_4(2),mass4set(:,7),  & 
G1tensor(622),G1tensor(623),G1tensor(624),G1tensor(625),G1tensor(626))
  call G_TensorShift(G1tensor(623),8)
  call Hotf_4pt_reduction_last(G2tensor(402),RedSet_4(2),mass4set(:,8),  & 
G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630),G1tensor(631))
  call G_TensorShift(G1tensor(628),8)
  call Hotf_4pt_reduction_last(G2tensor(405),RedSet_4(19),mass4set(:,13),  & 
G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(633),8)
  call Hotf_4pt_reduction_last(G2tensor(408),RedSet_4(19),mass4set(:,14),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641))
  call G_TensorShift(G1tensor(638),8)
  call Hotf_4pt_reduction_last(G2tensor(411),RedSet_4(19),mass4set(:,15),  & 
G1tensor(642),G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646))
  call G_TensorShift(G1tensor(643),8)
  call Hotf_4pt_reduction_last(G1tensor(117),RedSet_4(20),mass4set(:,27),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(20),mass4set(:,28),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(24),mass4set(:,27),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(24),mass4set(:,28),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(28),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(28),mass4set(:,2),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(28),mass4set(:,3),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(32),mass4set(:,1),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(32),mass4set(:,2),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(32),mass4set(:,3),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(4),mass4set(:,20),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(112),RedSet_4(4),mass4set(:,21),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(12),mass4set(:,20),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(12),mass4set(:,21),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(44),mass4set(:,28),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(97),RedSet_4(42),mass4set(:,20),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(42),mass4set(:,26),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(43),RedSet_4(4),mass4set(:,29),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(42),mass4set(:,21),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(45),mass4set(:,28),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(73),RedSet_4(22),mass4set(:,20),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(88),RedSet_4(22),mass4set(:,21),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(95),RedSet_4(43),mass4set(:,20),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(43),mass4set(:,26),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(120),RedSet_4(12),mass4set(:,29),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(43),mass4set(:,21),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(17),mass4set(:,20),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(17),mass4set(:,21),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(46),mass4set(:,30),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(35),mass4set(:,30),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(47),mass4set(:,2),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(47),mass4set(:,3),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(48),mass4set(:,30),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(38),mass4set(:,30),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(40),mass4set(:,2),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(40),mass4set(:,3),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(1),mass4set(:,31),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(2),mass4set(:,12),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(3),mass4set(:,29),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(1),mass4set(:,4),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(2),mass4set(:,4),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(3),mass4set(:,20),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(2),mass4set(:,5),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(3),mass4set(:,21),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(6),mass4set(:,4),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(7),mass4set(:,4),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(8),mass4set(:,20),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(7),mass4set(:,5),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(8),mass4set(:,21),  & 
G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(10),mass4set(:,31),  & 
G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(11),mass4set(:,29),  & 
G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(10),mass4set(:,4),  & 
G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(11),mass4set(:,20),  & 
G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(11),mass4set(:,21),  & 
G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(14),mass4set(:,4),  & 
G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(15),mass4set(:,20),  & 
G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(15),mass4set(:,21),  & 
G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(44),mass4set(:,32),  & 
G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(17),mass4set(:,29),  & 
G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(18),mass4set(:,29),  & 
G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(19),mass4set(:,17),  & 
G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(18),mass4set(:,21),  & 
G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(19),mass4set(:,18),  & 
G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(45),mass4set(:,32),  & 
G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(22),mass4set(:,29),  & 
G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(23),mass4set(:,29),  & 
G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(23),mass4set(:,21),  & 
G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(47),mass4set(:,1),  & 
G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(26),mass4set(:,33),  & 
G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(27),mass4set(:,26),  & 
G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(8),mass4set(:,26),  & 
G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(26),mass4set(:,20),  & 
G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(27),mass4set(:,20),  & 
G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(27),mass4set(:,21),  & 
G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(40),mass4set(:,1),  & 
G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(30),mass4set(:,33),  & 
G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(31),mass4set(:,26),  & 
G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(15),mass4set(:,26),  & 
G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(30),mass4set(:,20),  & 
G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(31),mass4set(:,20),  & 
G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(31),mass4set(:,21),  & 
G0tensor(410),G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(34),mass4set(:,34),  & 
G0tensor(415),G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(23),mass4set(:,25),  & 
G0tensor(420),G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(3),mass4set(:,25),  & 
G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(37),mass4set(:,34),  & 
G0tensor(430),G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(18),mass4set(:,25),  & 
G0tensor(435),G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(11),mass4set(:,25),  & 
G0tensor(440),G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(7),mass4set(:,9),  & 
G0tensor(445),G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(7),mass4set(:,11),  & 
G0tensor(450),G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(7),mass4set(:,10),  & 
G0tensor(455),G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(2),mass4set(:,22),  & 
G0tensor(460),G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(2),mass4set(:,11),  & 
G0tensor(465),G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(19),mass4set(:,23),  & 
G0tensor(470),G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(19),mass4set(:,16),  & 
G0tensor(475),G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(24),mass4set(:,35),  & 
G0tensor(480),G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(24),mass4set(:,32),  & 
G0tensor(485),G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(20),mass4set(:,35),  & 
G0tensor(490),G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(20),mass4set(:,32),  & 
G0tensor(495),G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499))
  call Hotf_4pt_reduction_last(G1tensor(491),RedSet_4(37),mass4set(:,35),  & 
G0tensor(500),G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504))
  call Hotf_4pt_reduction_last(G1tensor(496),RedSet_4(34),mass4set(:,35),  & 
G0tensor(505),G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509))
  call Hotf_4pt_reduction_last(G1tensor(501),RedSet_4(41),mass4set(:,2),  & 
G0tensor(510),G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514))
  call Hotf_4pt_reduction_last(G1tensor(542),RedSet_4(41),mass4set(:,19),  & 
G0tensor(515),G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519))
  call Hotf_4pt_reduction_last(G1tensor(547),RedSet_4(41),mass4set(:,3),  & 
G0tensor(520),G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524))
  call Hotf_4pt_reduction_last(G1tensor(552),RedSet_4(41),mass4set(:,1),  & 
G0tensor(525),G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529))
  call Hotf_4pt_reduction_last(G1tensor(557),RedSet_4(40),mass4set(:,19),  & 
G0tensor(530),G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534))
  call Hotf_4pt_reduction_last(G1tensor(562),RedSet_4(12),mass4set(:,24),  & 
G0tensor(535),G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539))
  call Hotf_4pt_reduction_last(G1tensor(567),RedSet_4(12),mass4set(:,25),  & 
G0tensor(540),G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544))
  call Hotf_4pt_reduction_last(G1tensor(572),RedSet_4(4),mass4set(:,24),  & 
G0tensor(545),G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549))
  call Hotf_4pt_reduction_last(G1tensor(577),RedSet_4(4),mass4set(:,25),  & 
G0tensor(550),G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554))
  call Hotf_4pt_reduction_last(G1tensor(582),RedSet_4(22),mass4set(:,24),  & 
G0tensor(555),G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559))
  call Hotf_4pt_reduction_last(G1tensor(587),RedSet_4(22),mass4set(:,25),  & 
G0tensor(560),G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564))
  call Hotf_4pt_reduction_last(G1tensor(592),RedSet_4(17),mass4set(:,24),  & 
G0tensor(565),G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569))
  call Hotf_4pt_reduction_last(G1tensor(597),RedSet_4(17),mass4set(:,25),  & 
G0tensor(570),G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574))
  call Hotf_4pt_reduction_last(G1tensor(602),RedSet_4(7),mass4set(:,6),  & 
G0tensor(575),G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579))
  call Hotf_4pt_reduction_last(G1tensor(607),RedSet_4(7),mass4set(:,7),  & 
G0tensor(580),G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584))
  call Hotf_4pt_reduction_last(G1tensor(612),RedSet_4(7),mass4set(:,8),  & 
G0tensor(585),G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589))
  call Hotf_4pt_reduction_last(G1tensor(617),RedSet_4(2),mass4set(:,6),  & 
G0tensor(590),G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594))
  call Hotf_4pt_reduction_last(G1tensor(622),RedSet_4(2),mass4set(:,7),  & 
G0tensor(595),G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599))
  call Hotf_4pt_reduction_last(G1tensor(627),RedSet_4(2),mass4set(:,8),  & 
G0tensor(600),G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604))
  call Hotf_4pt_reduction_last(G1tensor(632),RedSet_4(19),mass4set(:,13),  & 
G0tensor(605),G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609))
  call Hotf_4pt_reduction_last(G1tensor(637),RedSet_4(19),mass4set(:,14),  & 
G0tensor(610),G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614))
  call Hotf_4pt_reduction_last(G1tensor(642),RedSet_4(19),mass4set(:,15),  & 
G0tensor(615),G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])
  call ol_merge_tensors(T0sum(45),[G0tensor(230)])
  call ol_merge_tensors(T0sum(46),[G0tensor(235)])
  call ol_merge_tensors(T0sum(47),[G0tensor(240)])
  call ol_merge_tensors(T0sum(48),[G0tensor(245)])
  call ol_merge_tensors(T0sum(49),[G0tensor(250)])
  call ol_merge_tensors(T0sum(50),[G0tensor(255)])
  call ol_merge_tensors(T0sum(51),[G0tensor(260)])
  call ol_merge_tensors(T0sum(52),[G0tensor(265)])
  call ol_merge_tensors(T0sum(53),[G0tensor(270)])
  call ol_merge_tensors(T0sum(54),[G0tensor(275)])
  call ol_merge_tensors(T0sum(55),[G0tensor(280)])
  call ol_merge_tensors(T0sum(56),[G0tensor(285)])
  call ol_merge_tensors(T0sum(57),[G0tensor(290)])
  call ol_merge_tensors(T0sum(58),[G0tensor(295)])
  call ol_merge_tensors(T0sum(59),[G0tensor(300)])
  call ol_merge_tensors(T0sum(60),[G0tensor(305)])
  call ol_merge_tensors(T0sum(61),[G0tensor(310)])
  call ol_merge_tensors(T0sum(62),[G0tensor(315)])
  call ol_merge_tensors(T0sum(63),[G0tensor(320)])
  call ol_merge_tensors(T0sum(64),[G0tensor(325)])
  call ol_merge_tensors(T0sum(65),[G0tensor(330)])
  call ol_merge_tensors(T0sum(66),[G0tensor(335)])
  call ol_merge_tensors(T0sum(67),[G0tensor(340)])
  call ol_merge_tensors(T0sum(68),[G0tensor(345)])
  call ol_merge_tensors(T0sum(69),[G0tensor(350)])
  call ol_merge_tensors(T0sum(70),[G0tensor(355)])
  call ol_merge_tensors(T0sum(71),[G0tensor(360)])
  call ol_merge_tensors(T0sum(72),[G0tensor(365)])
  call ol_merge_tensors(T0sum(73),[G0tensor(370)])
  call ol_merge_tensors(T0sum(74),[G0tensor(375)])
  call ol_merge_tensors(T0sum(75),[G0tensor(380)])
  call ol_merge_tensors(T0sum(76),[G0tensor(385)])
  call ol_merge_tensors(T0sum(77),[G0tensor(390)])
  call ol_merge_tensors(T0sum(78),[G0tensor(395)])
  call ol_merge_tensors(T0sum(79),[G0tensor(400)])
  call ol_merge_tensors(T0sum(80),[G0tensor(405)])
  call ol_merge_tensors(T0sum(81),[G0tensor(410)])
  call ol_merge_tensors(T0sum(82),[G0tensor(415)])
  call ol_merge_tensors(T0sum(83),[G0tensor(420)])
  call ol_merge_tensors(T0sum(84),[G0tensor(425)])
  call ol_merge_tensors(T0sum(85),[G0tensor(430)])
  call ol_merge_tensors(T0sum(86),[G0tensor(435)])
  call ol_merge_tensors(T0sum(87),[G0tensor(440)])
  call ol_merge_tensors(T0sum(88),[G0tensor(445)])
  call ol_merge_tensors(T0sum(89),[G0tensor(450)])
  call ol_merge_tensors(T0sum(90),[G0tensor(455)])
  call ol_merge_tensors(T0sum(91),[G0tensor(460)])
  call ol_merge_tensors(T0sum(92),[G0tensor(465)])
  call ol_merge_tensors(T0sum(93),[G0tensor(470)])
  call ol_merge_tensors(T0sum(94),[G0tensor(475)])
  call ol_merge_tensors(T0sum(95),[G0tensor(480)])
  call ol_merge_tensors(T0sum(96),[G0tensor(485)])
  call ol_merge_tensors(T0sum(97),[G0tensor(490)])
  call ol_merge_tensors(T0sum(98),[G0tensor(495)])
  call ol_merge_tensors(T0sum(99),[G0tensor(500)])
  call ol_merge_tensors(T0sum(100),[G0tensor(505)])
  call ol_merge_tensors(T0sum(101),[G0tensor(1)])
  call ol_merge_tensors(T0sum(102),[G0tensor(2)])
  call ol_merge_tensors(T0sum(103),[G0tensor(3)])
  call ol_merge_tensors(T0sum(104),[G0tensor(4)])
  call ol_merge_tensors(T0sum(105),[G0tensor(5)])
  call ol_merge_tensors(T0sum(106),[G0tensor(6)])
  call ol_merge_tensors(T0sum(107),[G0tensor(7)])
  call ol_merge_tensors(T0sum(108),[G0tensor(8)])
  call ol_merge_tensors(T0sum(109),[G0tensor(9)])
  call ol_merge_tensors(T0sum(110),[G0tensor(510)])
  call ol_merge_tensors(T0sum(111),[G0tensor(515)])
  call ol_merge_tensors(T0sum(112),[G0tensor(520)])
  call ol_merge_tensors(T0sum(113),[G0tensor(525)])
  call ol_merge_tensors(T0sum(114),[G0tensor(530)])
  call ol_merge_tensors(T0sum(115),[G0tensor(535)])
  call ol_merge_tensors(T0sum(116),[G0tensor(540)])
  call ol_merge_tensors(T0sum(117),[G0tensor(545)])
  call ol_merge_tensors(T0sum(118),[G0tensor(550)])
  call ol_merge_tensors(T0sum(119),[G0tensor(555)])
  call ol_merge_tensors(T0sum(120),[G0tensor(560)])
  call ol_merge_tensors(T0sum(121),[G0tensor(565)])
  call ol_merge_tensors(T0sum(122),[G0tensor(570)])
  call ol_merge_tensors(T0sum(123),[G0tensor(575)])
  call ol_merge_tensors(T0sum(124),[G0tensor(580)])
  call ol_merge_tensors(T0sum(125),[G0tensor(585)])
  call ol_merge_tensors(T0sum(126),[G0tensor(590)])
  call ol_merge_tensors(T0sum(127),[G0tensor(595)])
  call ol_merge_tensors(T0sum(128),[G0tensor(600)])
  call ol_merge_tensors(T0sum(129),[G0tensor(605)])
  call ol_merge_tensors(T0sum(130),[G0tensor(610)])
  call ol_merge_tensors(T0sum(131),[G0tensor(615)])
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(310),h0tab(:,310),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(11),m4h3x4x3(:,1),heltab3x36(:,:,13))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(311),h0tab(:,311),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(10),m4h3x4x3(:,2),heltab3x36(:,:,14))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(312),h0tab(:,312),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(1),m4h3x4x3(:,3),heltab3x36(:,:,15))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(313),h0tab(:,313),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,1),ex5(:),G0H3(12),m4h4x3x3(:,1),heltab3x36(:,:,16))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(314),h0tab(:,314),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(3),m4h3x4x3(:,4),heltab3x36(:,:,17))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(315),h0tab(:,315),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(9),m4h3x4x3(:,5),heltab3x36(:,:,18))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(316),h0tab(:,316),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(2),m4h3x4x3(:,6),heltab3x36(:,:,19))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(317),h0tab(:,317),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,1),ex5(:),G0H3(5),m4h4x3x3(:,2),heltab3x36(:,:,20))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(318),h0tab(:,318),[16,4,11],[nMH,nMH,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(54),m3h3x12(:,263),heltab2x36(:,:,298))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(319),h0tab(:,319),[16,4,11],[nMZ,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(55),m3h3x12(:,264),heltab2x36(:,:,299))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(320),h0tab(:,320),[16,4,11],[nMW,nMW,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(56),m3h3x12(:,265),heltab2x36(:,:,300))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(321),h0tab(:,321),[16,4,11],[nMW,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(57),m3h3x12(:,266),heltab2x36(:,:,301))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(322),h0tab(:,322),[16,4,11],[nMZ,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(58),m3h3x12(:,267),heltab2x36(:,:,302))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(323),h0tab(:,323),[16,4,11],[nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(59),m3h3x12(:,268),heltab2x36(:,:,303))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(324),h0tab(:,324),[16,4,11],[nMW,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(5),m3h3x12(:,269),heltab2x36(:,:,304))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(325),h0tab(:,325),[16,4,11],[nMZ,nMZ,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(4),m3h3x12(:,270),heltab2x36(:,:,305))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(326),h0tab(:,326),[16,4,11],[nMW,nMW,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(80),m3h3x12(:,271),heltab2x36(:,:,306))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(327),h0tab(:,327),[16,4,11],[nMW,nMW,0],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,272),heltab2x36(:,:,307))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(328),h0tab(:,328),[16,4,11],[nMW,nMW,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,273),heltab2x36(:,:,308))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(329),h0tab(:,329),[24,3,4],[nMW,nMH,nMH],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(17),m4h3x3x4(:,7),heltab3x36(:,:,21))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(330),h0tab(:,330),[24,3,4],[nMW,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(7),m4h3x3x4(:,8),heltab3x36(:,:,22))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(331),h0tab(:,331),[24,3,4],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(1),m4h3x3x4(:,9),heltab3x36(:,:,23))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(332),h0tab(:,332),[24,3,4],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(8),m4h3x3x4(:,10),heltab3x36(:,:,24))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(333),h0tab(:,333),[24,3,4],[nMW,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(2),m4h3x3x4(:,11),heltab3x36(:,:,25))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(334),h0tab(:,334),[24,3,4],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(9),m4h3x3x4(:,12),heltab3x36(:,:,26))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(335),h0tab(:,335),[24,3,4],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(3),m4h3x3x4(:,13),heltab3x36(:,:,27))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(336),h0tab(:,336),[24,3,4],[nMW,nMZ,nMZ],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(12),m4h3x3x4(:,14),heltab3x36(:,:,28))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(337),h0tab(:,337),[24,3,4],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(4),m4h3x3x4(:,15),heltab3x36(:,:,29))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(338),h0tab(:,338),[24,3,4],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(13),m4h3x3x4(:,16),heltab3x36(:,:,30))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(339),h0tab(:,339),[24,3,4],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(5),m4h3x3x4(:,17),heltab3x36(:,:,31))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(340),h0tab(:,340),[16,7,8],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(74),m3h3x12(:,274),heltab2x36(:,:,309))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(341),h0tab(:,341),[16,7,8],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(78),m3h3x12(:,275),heltab2x36(:,:,310))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(342),h0tab(:,342),[16,7,8],[nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(60),m3h3x12(:,276),heltab2x36(:,:,311))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(343),h0tab(:,343),[16,7,8],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(11),m3h3x12(:,277),heltab2x36(:,:,312))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(344),h0tab(:,344),[16,7,8],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(61),m3h3x12(:,278),heltab2x36(:,:,313))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(345),h0tab(:,345),[16,7,8],[nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(17),m3h3x12(:,279),heltab2x36(:,:,314))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(346),h0tab(:,346),[16,7,8],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(62),m3h3x12(:,280),heltab2x36(:,:,315))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(347),h0tab(:,347),[16,7,8],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(79),m3h3x12(:,281),heltab2x36(:,:,316))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(348),h0tab(:,348),[20,3,8],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(83),m4h1x3x12(:,7),heltab3x36(:,:,32))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(349),h0tab(:,349),[20,3,8],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(84),m4h1x3x12(:,8),heltab3x36(:,:,33))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(350),h0tab(:,350),[20,3,8],[nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(85),m4h3x1x12(:,1),heltab3x36(:,:,34))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(351),h0tab(:,351),[20,3,8],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(86),m4h3x1x12(:,2),heltab3x36(:,:,35))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(352),h0tab(:,352),[20,3,8],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(10),m4h1x3x12(:,9),heltab3x36(:,:,36))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(353),h0tab(:,353),[20,3,8],[nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(11),m4h1x3x12(:,10),heltab3x36(:,:,37))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(354),h0tab(:,354),[20,3,8],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(12),m4h1x3x12(:,11),heltab3x36(:,:,38))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(355),h0tab(:,355),[20,3,8],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(13),m4h3x1x12(:,3),heltab3x36(:,:,39))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(356),h0tab(:,356),[16,3,12],[nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(63),m3h3x12(:,282),heltab2x36(:,:,317))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(357),h0tab(:,357),[16,3,12],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(64),m3h3x12(:,283),heltab2x36(:,:,318))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(358),h0tab(:,358),[16,3,12],[nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,284),heltab2x36(:,:,319))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(359),h0tab(:,359),[16,3,12],[nMH,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,285),heltab2x36(:,:,320))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(360),h0tab(:,360),[16,3,12],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,286),heltab2x36(:,:,321))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(361),h0tab(:,361),[16,3,12],[nMW,nMZ,nMH],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,287),heltab2x36(:,:,322))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(362),h0tab(:,362),[16,3,12],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,288),heltab2x36(:,:,323))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(363),h0tab(:,363),[16,3,12],[0,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(65),m3h3x12(:,289),heltab2x36(:,:,324))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(364),h0tab(:,364),[16,3,12],[nMW,nMH,nMZ],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(66),m3h3x12(:,290),heltab2x36(:,:,325))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(365),h0tab(:,365),[16,3,12],[nMZ,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(67),m3h3x12(:,291),heltab2x36(:,:,326))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(366),h0tab(:,366),[28,1,2],[0,0,nMW],4,1,wf3(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),wf3(:,1),G0H4(14),m4h3x3x4(:,18),heltab3x36(:,:,40))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(367),h0tab(:,367),[28,1,2],[nMW,0,0],4,1,wf3(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf3(:,1),ex5(:),G0H4(6),m4h3x3x4(:,19),heltab3x36(:,:,41))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(368),h0tab(:,368),[28,1,2],[nMZ,0,nMW],4,1,wf3(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),wf3(:,1),G0H4(10),m4h3x3x4(:,20),heltab3x36(:,:,42))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(369),h0tab(:,369),[28,1,2],[nMW,0,nMZ],4,1,wf3(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf3(:,1),ex5(:),G0H4(11),m4h3x3x4(:,21),heltab3x36(:,:,43))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(370),h0tab(:,370),[28,1,2],[0,0,nMW],4,1,wf3(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),wf3(:,3),ex4(:),G0H4(15),m4h3x3x4(:,22),heltab3x36(:,:,44))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(371),h0tab(:,371),[28,1,2],[nMW,0,0],4,1,wf3(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),wf3(:,3),G0H4(16),m4h3x3x4(:,23),heltab3x36(:,:,45))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(372),h0tab(:,372),[28,1,2],[nMZ,0,nMW],4,1,wf3(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),wf3(:,3),ex4(:),G0H4(18),m4h3x3x4(:,24),heltab3x36(:,:,46))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(373),h0tab(:,373),[28,1,2],[nMW,0,nMZ],4,1,wf3(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),wf3(:,3),G0H4(19),m4h3x3x4(:,25),heltab3x36(:,:,47))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(374),h0tab(:,374),[28,1,2],[0,0,nMW],4,1,wf9(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(20),m4h1x9x4(:,1),heltab3x36(:,:,48))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(375),h0tab(:,375),[28,1,2],[nMW,0,0],4,1,wf9(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(21),m4h1x9x4(:,2),heltab3x36(:,:,49))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(376),h0tab(:,376),[28,1,2],[nMZ,0,nMW],4,1,wf9(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(22),m4h1x9x4(:,3),heltab3x36(:,:,50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(377),h0tab(:,377),[28,1,2],[nMW,0,nMZ],4,1,wf9(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(23),m4h1x9x4(:,4),heltab3x36(:,:,51))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(378),h0tab(:,378),[28,1,2],[0,0,nMW],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(24),m3h9x4(:,24),heltab2x36(:,:,327))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(379),h0tab(:,379),[28,1,2],[nMW,0,0],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(25),m3h9x4(:,25),heltab2x36(:,:,328))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(380),h0tab(:,380),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(26),m3h9x4(:,26),heltab2x36(:,:,329))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(381),h0tab(:,381),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(27),m3h9x4(:,27),heltab2x36(:,:,330))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(382),h0tab(:,382),[16,3,12],[0,nML,nML],3,2,wf4(:,1),wf3(:,7))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,292),heltab2x36(:,:,331))
  call Hloop_Q_A(ntryL,G0H12(22),16,0,G1H12(68),n2h12(40))
  Gcoeff(:)%j = (c(184)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(383),h0tab(:,383),[16,3,12],[nMB,nMT,nMT],3,2,wf4(:,1),wf3(:,7))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,293),heltab2x36(:,:,332))
  call Hloop_A_Q(ntryL,G0H12(23),16,nMB,G1H12(69),n2h12(41))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(384),h0tab(:,384),[16,3,12],[nMT,nMB,nMB],3,2,wf4(:,1),wf3(:,7))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,294),heltab2x36(:,:,333))
  call Hloop_Q_A(ntryL,G0H12(24),16,nMT,G1H12(70),n2h12(42))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(385),h0tab(:,385),[16,3,12],[nMW,nMZ,nMH],3,2,wf4(:,1),wf3(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(71),m3h3x12(:,295),heltab2x36(:,:,334))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(386),h0tab(:,386),[16,3,12],[nMW,nMH,nMZ],3,2,wf4(:,1),wf3(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(72),m3h3x12(:,296),heltab2x36(:,:,335))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(387),h0tab(:,387),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(73),m3h3x12(:,297),heltab2x36(:,:,336))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(388),h0tab(:,388),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(74),m3h3x12(:,298),heltab2x36(:,:,337))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(389),h0tab(:,389),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(75),m3h3x12(:,299),heltab2x36(:,:,338))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(390),h0tab(:,390),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(76),m3h3x12(:,300),heltab2x36(:,:,339))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(391),h0tab(:,391),[16,3,12],[nMW,nMZ,nMH],3,2,wf4(:,1),wf3(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(77),m3h3x12(:,301),heltab2x36(:,:,340))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(392),h0tab(:,392),[16,3,12],[nMH,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(78),m3h3x12(:,302),heltab2x36(:,:,341))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(393),h0tab(:,393),[16,3,12],[nMW,nMH,nMZ],3,2,wf4(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,303),heltab2x36(:,:,342))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(394),h0tab(:,394),[16,3,12],[nMH,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,304),heltab2x36(:,:,343))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(395),h0tab(:,395),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,305),heltab2x36(:,:,344))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(396),h0tab(:,396),[16,3,12],[nMW,nMZ,nMH],3,2,wf4(:,1),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,306),heltab2x36(:,:,345))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(397),h0tab(:,397),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,307),heltab2x36(:,:,346))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(398),h0tab(:,398),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(79),m3h3x12(:,308),heltab2x36(:,:,347))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(399),h0tab(:,399),[16,3,12],[nMW,nMH,nMZ],3,2,wf4(:,1),wf3(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(80),m3h3x12(:,309),heltab2x36(:,:,348))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(400),h0tab(:,400),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(81),m3h3x12(:,310),heltab2x36(:,:,349))
  Gcoeff(:)%j = (c(213)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(401),h0tab(:,401),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,311),heltab2x36(:,:,350))
  call Hloop_A_Q(ntryL,G0H12(30),16,0,G1H12(82),n2h12(43))
  Gcoeff(:)%j = (c(211)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(402),h0tab(:,402),[16,3,12],[nML,0,0],3,2,wf4(:,1),wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,312),heltab2x36(:,:,351))
  call Hloop_A_Q(ntryL,G0H12(1),16,nML,G1H12(83),n2h12(44))
  Gcoeff(:)%j = (c(213)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(403),h0tab(:,403),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,313),heltab2x36(:,:,352))
  call Hloop_Q_A(ntryL,G0H12(31),16,0,G1H12(84),n2h12(45))
  Gcoeff(:)%j = (c(211)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(404),h0tab(:,404),[16,3,12],[0,nML,nML],3,2,wf4(:,1),wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,314),heltab2x36(:,:,353))
  call Hloop_Q_A(ntryL,G0H12(3),16,0,G1H12(85),n2h12(46))
  Gcoeff(:)%j = (c(214)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(405),h0tab(:,405),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,315),heltab2x36(:,:,354))
  call Hloop_A_Q(ntryL,G0H12(18),16,0,G1H12(86),n2h12(47))
  Gcoeff(:)%j = (c(212)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(406),h0tab(:,406),[16,3,12],[nMB,nMT,nMT],3,2,wf4(:,1),wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,316),heltab2x36(:,:,355))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(87),n2h12(48))
  Gcoeff(:)%j = (c(214)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(407),h0tab(:,407),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,317),heltab2x36(:,:,356))
  call Hloop_Q_A(ntryL,G0H12(16),16,0,G1H12(88),n2h12(49))
  Gcoeff(:)%j = (c(212)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(408),h0tab(:,408),[16,3,12],[nMT,nMB,nMB],3,2,wf4(:,1),wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,318),heltab2x36(:,:,357))
  call Hloop_Q_A(ntryL,G0H12(17),16,nMT,G1H12(89),n2h12(50))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(409),h0tab(:,409),[16,3,12],[nMW,nMZ,nMH],3,2,wf4(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(90),m3h3x12(:,319),heltab2x36(:,:,358))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(410),h0tab(:,410),[16,3,12],[nMW,nMH,nMZ],3,2,wf4(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(91),m3h3x12(:,320),heltab2x36(:,:,359))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(411),h0tab(:,411),[16,3,12],[nMH,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(92),m3h3x12(:,321),heltab2x36(:,:,360))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(412),h0tab(:,412),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(95),m3h3x12(:,322),heltab2x36(:,:,361))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(413),h0tab(:,413),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(94),m3h3x12(:,323),heltab2x36(:,:,362))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(414),h0tab(:,414),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(96),m3h3x12(:,324),heltab2x36(:,:,363))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(415),h0tab(:,415),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(97),m3h3x12(:,325),heltab2x36(:,:,364))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(416),h0tab(:,416),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(100),m3h3x12(:,326),heltab2x36(:,:,365))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(417),h0tab(:,417),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(99),m3h3x12(:,327),heltab2x36(:,:,366))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(418),h0tab(:,418),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(101),m3h3x12(:,328),heltab2x36(:,:,367))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(419),h0tab(:,419),[16,3,12],[nMW,nMZ,nMH],3,2,wf4(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(102),m3h3x12(:,329),heltab2x36(:,:,368))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(420),h0tab(:,420),[16,3,12],[nMH,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(103),m3h3x12(:,330),heltab2x36(:,:,369))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(421),h0tab(:,421),[16,3,12],[nMW,nMH,nMZ],3,2,wf4(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(32),m3h3x12(:,331),heltab2x36(:,:,370))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(422),h0tab(:,422),[16,3,12],[nMH,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(33),m3h3x12(:,332),heltab2x36(:,:,371))
  Gcoeff(:)%j = (-(c(166)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(423),h0tab(:,423),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(34),m3h3x12(:,333),heltab2x36(:,:,372))
  Gcoeff(:)%j = (-(c(173)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(424),h0tab(:,424),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(35),m3h3x12(:,334),heltab2x36(:,:,373))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(425),h0tab(:,425),[16,3,12],[nMH,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(36),m3h3x12(:,335),heltab2x36(:,:,374))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(426),h0tab(:,426),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(37),m3h3x12(:,336),heltab2x36(:,:,375))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(427),h0tab(:,427),[16,3,12],[nMW,nMZ,nMH],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,337),heltab2x36(:,:,376))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(428),h0tab(:,428),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,338),heltab2x36(:,:,377))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(429),h0tab(:,429),[16,3,12],[0,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(104),m3h3x12(:,339),heltab2x36(:,:,378))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(430),h0tab(:,430),[16,3,12],[nMW,nMH,nMZ],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(105),m3h3x12(:,340),heltab2x36(:,:,379))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(431),h0tab(:,431),[16,3,12],[nMZ,nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(106),m3h3x12(:,341),heltab2x36(:,:,380))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(432),h0tab(:,432),[20,3,8],[nML,0,0],3,2,wf3(:,2),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,2),G0H12(40),ngPnl,m3h3x12(:,342),heltab2x36(:,:,381))
  call Hloop_A_Q(ntryL,G0H12(40),20,nML,G1H12(113),n2h12(51))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(433),h0tab(:,433),[20,3,8],[0,nML,nML],3,2,wf3(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,2),G0H12(41),ngPnl,m3h3x12(:,343),heltab2x36(:,:,382))
  call Hloop_Q_A(ntryL,G0H12(41),20,0,G1H12(114),n2h12(52))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(434),h0tab(:,434),[20,3,8],[nMB,nMT,nMT],3,2,wf3(:,2),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,2),G0H12(42),ngPtb,m3h3x12(:,344),heltab2x36(:,:,383))
  call Hloop_A_Q(ntryL,G0H12(42),20,nMB,G1H12(112),n2h12(53))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(435),h0tab(:,435),[20,3,8],[nMT,nMB,nMB],3,2,wf3(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,2),G0H12(43),ngPtb,m3h3x12(:,345),heltab2x36(:,:,384))
  call Hloop_Q_A(ntryL,G0H12(43),20,nMT,G1H12(111),n2h12(54))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(436),h0tab(:,436),[20,3,8],[nMW,nMZ,nMH],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(44),m3h3x12(:,346),heltab2x36(:,:,385))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(437),h0tab(:,437),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(45),m3h3x12(:,347),heltab2x36(:,:,386))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(438),h0tab(:,438),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(46),m3h3x12(:,348),heltab2x36(:,:,387))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(439),h0tab(:,439),[20,3,8],[0,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(47),m3h3x12(:,349),heltab2x36(:,:,388))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(440),h0tab(:,440),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(48),m3h3x12(:,350),heltab2x36(:,:,389))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(441),h0tab(:,441),[20,3,8],[0,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(49),m3h3x12(:,351),heltab2x36(:,:,390))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(442),h0tab(:,442),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(50),m3h3x12(:,352),heltab2x36(:,:,391))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(443),h0tab(:,443),[20,3,8],[0,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(121),m3h3x12(:,353),heltab2x36(:,:,392))
  Gcoeff(:)%j = (-(c(169)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(444),h0tab(:,444),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(122),m3h3x12(:,354),heltab2x36(:,:,393))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(445),h0tab(:,445),[20,3,8],[nMW,nMH,nMZ],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(120),m3h3x12(:,355),heltab2x36(:,:,394))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(446),h0tab(:,446),[20,3,8],[nMW,nMH,nMZ],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(119),m3h3x12(:,356),heltab2x36(:,:,395))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(447),h0tab(:,447),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(123),m3h3x12(:,357),heltab2x36(:,:,396))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(448),h0tab(:,448),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(124),m3h3x12(:,358),heltab2x36(:,:,397))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(449),h0tab(:,449),[20,3,8],[nMW,nMZ,nMH],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(51),m3h3x12(:,359),heltab2x36(:,:,398))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(450),h0tab(:,450),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(52),m3h3x12(:,360),heltab2x36(:,:,399))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(451),h0tab(:,451),[20,3,8],[0,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(53),m3h3x12(:,361),heltab2x36(:,:,400))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(452),h0tab(:,452),[20,3,8],[nMW,nMH,nMZ],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(54),m3h3x12(:,362),heltab2x36(:,:,401))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(453),h0tab(:,453),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(55),m3h3x12(:,363),heltab2x36(:,:,402))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(454),h0tab(:,454),[20,3,8],[0,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(125),m3h3x12(:,364),heltab2x36(:,:,403))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(455),h0tab(:,455),[20,3,8],[nMW,nMZ,nMH],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(126),m3h3x12(:,365),heltab2x36(:,:,404))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(456),h0tab(:,456),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(93),m3h3x12(:,366),heltab2x36(:,:,405))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(457),h0tab(:,457),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(110),m3h3x12(:,367),heltab2x36(:,:,406))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(458),h0tab(:,458),[20,3,8],[0,0,0],3,2,wf3(:,3),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(56),m3h3x12(:,368),heltab2x36(:,:,407))
  call Hloop_A_Q(ntryL,G0H12(56),20,0,G1H12(108),n2h12(55))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(459),h0tab(:,459),[20,3,8],[nML,0,0],3,2,wf3(:,3),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(57),m3h3x12(:,369),heltab2x36(:,:,408))
  call Hloop_A_Q(ntryL,G0H12(57),20,nML,G1H12(27),n2h12(56))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(460),h0tab(:,460),[20,3,8],[0,0,0],3,2,wf3(:,3),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(58),m3h3x12(:,370),heltab2x36(:,:,409))
  call Hloop_Q_A(ntryL,G0H12(58),20,0,G1H12(1),n2h12(57))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(461),h0tab(:,461),[20,3,8],[0,nML,nML],3,2,wf3(:,3),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(59),m3h3x12(:,371),heltab2x36(:,:,410))
  call Hloop_Q_A(ntryL,G0H12(59),20,0,G1H12(2),n2h12(58))
  Gcoeff(:)%j = (c(210)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(462),h0tab(:,462),[20,3,8],[0,0,0],3,2,wf3(:,3),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(60),m3h3x12(:,372),heltab2x36(:,:,411))
  call Hloop_A_Q(ntryL,G0H12(60),20,0,G1H12(7),n2h12(59))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(463),h0tab(:,463),[20,3,8],[nMB,nMT,nMT],3,2,wf3(:,3),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(61),m3h3x12(:,373),heltab2x36(:,:,412))
  call Hloop_A_Q(ntryL,G0H12(61),20,nMB,G1H12(8),n2h12(60))
  Gcoeff(:)%j = (c(210)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(464),h0tab(:,464),[20,3,8],[0,0,0],3,2,wf3(:,3),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(62),m3h3x12(:,374),heltab2x36(:,:,413))
  call Hloop_Q_A(ntryL,G0H12(62),20,0,G1H12(23),n2h12(61))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(465),h0tab(:,465),[20,3,8],[nMT,nMB,nMB],3,2,wf3(:,3),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(63),m3h3x12(:,375),heltab2x36(:,:,414))
  call Hloop_Q_A(ntryL,G0H12(63),20,nMT,G1H12(115),n2h12(62))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(466),h0tab(:,466),[20,3,8],[nMW,nMH,nMZ],3,2,wf3(:,3),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(98),m3h3x12(:,376),heltab2x36(:,:,415))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(467),h0tab(:,467),[20,3,8],[nMW,nMZ,nMH],3,2,wf3(:,3),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(107),m3h3x12(:,377),heltab2x36(:,:,416))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(468),h0tab(:,468),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(118),m3h3x12(:,378),heltab2x36(:,:,417))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(469),h0tab(:,469),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(116),m3h3x12(:,379),heltab2x36(:,:,418))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(470),h0tab(:,470),[20,3,8],[0,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(117),m3h3x12(:,380),heltab2x36(:,:,419))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(471),h0tab(:,471),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(28),m3h3x12(:,381),heltab2x36(:,:,420))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(472),h0tab(:,472),[20,3,8],[0,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(109),m3h3x12(:,382),heltab2x36(:,:,421))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(473),h0tab(:,473),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(30),m3h3x12(:,383),heltab2x36(:,:,422))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(474),h0tab(:,474),[20,3,8],[0,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(29),m3h3x12(:,384),heltab2x36(:,:,423))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(475),h0tab(:,475),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(4),m3h3x12(:,385),heltab2x36(:,:,424))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(476),h0tab(:,476),[20,3,8],[0,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(64),m3h3x12(:,386),heltab2x36(:,:,425))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(477),h0tab(:,477),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(65),m3h3x12(:,387),heltab2x36(:,:,426))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(478),h0tab(:,478),[20,3,8],[nMW,nMH,nMZ],3,2,wf3(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(66),m3h3x12(:,388),heltab2x36(:,:,427))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(479),h0tab(:,479),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(67),m3h3x12(:,389),heltab2x36(:,:,428))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(480),h0tab(:,480),[20,3,8],[nMW,nMZ,nMH],3,2,wf3(:,3),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(6),m3h3x12(:,390),heltab2x36(:,:,429))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(481),h0tab(:,481),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(3),m3h3x12(:,391),heltab2x36(:,:,430))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(482),h0tab(:,482),[20,3,8],[0,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(10),m3h3x12(:,392),heltab2x36(:,:,431))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(483),h0tab(:,483),[20,3,8],[nMW,nMH,nMZ],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(12),m3h3x12(:,393),heltab2x36(:,:,432))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(484),h0tab(:,484),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(9),m3h3x12(:,394),heltab2x36(:,:,433))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(485),h0tab(:,485),[20,3,8],[0,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(68),m3h3x12(:,395),heltab2x36(:,:,434))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(486),h0tab(:,486),[20,3,8],[nMW,nMZ,nMH],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(69),m3h3x12(:,396),heltab2x36(:,:,435))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(487),h0tab(:,487),[20,3,8],[nMZ,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(70),m3h3x12(:,397),heltab2x36(:,:,436))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(488),h0tab(:,488),[20,3,8],[nMH,nMW,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(71),m3h3x12(:,398),heltab2x36(:,:,437))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(489),h0tab(:,489),[24,3,4],[0,nML,nML],3,2,wf9(:,1),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(28),ngPnl,m3h9x4(:,28),heltab2x36(:,:,438))
  call Hloop_Q_A(ntryL,G0H4(28),24,0,G1H4(15),n2h4(2))
  Gcoeff(:)%j = (-(c(240)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(490),h0tab(:,490),[24,3,4],[nMB,nMT,nMT],3,2,wf9(:,1),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(28),ngPtb,m3h9x4(:,29),heltab2x36(:,:,439))
  call Hloop_A_Q(ntryL,G0H4(28),24,nMB,G1H4(16),n2h4(3))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(491),h0tab(:,491),[24,3,4],[nMT,nMB,nMB],3,2,wf9(:,1),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(28),ngPtb,m3h9x4(:,30),heltab2x36(:,:,440))
  call Hloop_Q_A(ntryL,G0H4(28),24,nMT,G1H4(5),n2h4(4))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(492),h0tab(:,492),[24,3,4],[nMW,nMH,nMH],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(28),m3h9x4(:,31),heltab2x36(:,:,441))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(493),h0tab(:,493),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(29),m3h9x4(:,32),heltab2x36(:,:,442))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(494),h0tab(:,494),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(30),m3h9x4(:,33),heltab2x36(:,:,443))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(495),h0tab(:,495),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(31),m3h9x4(:,34),heltab2x36(:,:,444))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(496),h0tab(:,496),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(32),m3h9x4(:,35),heltab2x36(:,:,445))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(497),h0tab(:,497),[24,3,4],[0,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(33),m3h9x4(:,36),heltab2x36(:,:,446))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(498),h0tab(:,498),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(34),m3h9x4(:,37),heltab2x36(:,:,447))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(499),h0tab(:,499),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(35),m3h9x4(:,38),heltab2x36(:,:,448))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(500),h0tab(:,500),[24,3,4],[0,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(36),m3h9x4(:,39),heltab2x36(:,:,449))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(501),h0tab(:,501),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(37),m3h9x4(:,40),heltab2x36(:,:,450))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(502),h0tab(:,502),[24,3,4],[0,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(6),m3h9x4(:,41),heltab2x36(:,:,451))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(503),h0tab(:,503),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(7),m3h9x4(:,42),heltab2x36(:,:,452))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(504),h0tab(:,504),[24,3,4],[nMW,nMH,nMH],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(11),m3h9x4(:,43),heltab2x36(:,:,453))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(505),h0tab(:,505),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(12),m3h9x4(:,44),heltab2x36(:,:,454))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(506),h0tab(:,506),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(13),m3h9x4(:,45),heltab2x36(:,:,455))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(507),h0tab(:,507),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(17),m3h9x4(:,46),heltab2x36(:,:,456))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(508),h0tab(:,508),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(38),m3h9x4(:,47),heltab2x36(:,:,457))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(509),h0tab(:,509),[24,3,4],[0,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(39),m3h9x4(:,48),heltab2x36(:,:,458))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(510),h0tab(:,510),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(40),m3h9x4(:,49),heltab2x36(:,:,459))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(511),h0tab(:,511),[24,3,4],[0,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(1),m3h9x4(:,50),heltab2x36(:,:,460))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(512),h0tab(:,512),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(2),m3h9x4(:,51),heltab2x36(:,:,461))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(513),h0tab(:,513),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(3),m3h9x4(:,52),heltab2x36(:,:,462))
  Gcoeff(:)%j = (-(c(173)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(514),h0tab(:,514),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(4),m3h9x4(:,53),heltab2x36(:,:,463))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(515),h0tab(:,515),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(18),m3h9x4(:,54),heltab2x36(:,:,464))
  Gcoeff(:)%j = (c(183)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(516),h0tab(:,516),[24,3,4],[0,nML,nML],3,2,wf9(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(41),m3h9x4(:,55),heltab2x36(:,:,465))
  call Hloop_Q_A(ntryL,G0H4(41),24,0,G1H4(19),n2h4(5))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(517),h0tab(:,517),[24,3,4],[nMB,nMT,nMT],3,2,wf9(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),wf9(:,2),G0H4(41),m3h9x4(:,56),heltab2x36(:,:,466))
  call Hloop_A_Q(ntryL,G0H4(41),24,nMB,G1H4(20),n2h4(6))
  Gcoeff(:)%j = (c(181)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(518),h0tab(:,518),[24,3,4],[nMT,nMB,nMB],3,2,wf9(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(41),m3h9x4(:,57),heltab2x36(:,:,467))
  call Hloop_Q_A(ntryL,G0H4(41),24,nMT,G1H4(21),n2h4(7))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(519),h0tab(:,519),[24,3,4],[nMW,nMH,nMH],3,2,wf9(:,2),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(22),m3h9x4(:,58),heltab2x36(:,:,468))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(520),h0tab(:,520),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(23),m3h9x4(:,59),heltab2x36(:,:,469))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(521),h0tab(:,521),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(24),m3h9x4(:,60),heltab2x36(:,:,470))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(522),h0tab(:,522),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(25),m3h9x4(:,61),heltab2x36(:,:,471))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(523),h0tab(:,523),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,2),G1H4(26),m3h9x4(:,62),heltab2x36(:,:,472))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(524),h0tab(:,524),[24,3,4],[0,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(27),m3h9x4(:,63),heltab2x36(:,:,473))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(525),h0tab(:,525),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(28),m3h9x4(:,64),heltab2x36(:,:,474))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(526),h0tab(:,526),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(29),m3h9x4(:,65),heltab2x36(:,:,475))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(527),h0tab(:,527),[24,3,4],[0,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,2),G1H4(30),m3h9x4(:,66),heltab2x36(:,:,476))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(528),h0tab(:,528),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,2),G1H4(31),m3h9x4(:,67),heltab2x36(:,:,477))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(529),h0tab(:,529),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(32),m3h9x4(:,68),heltab2x36(:,:,478))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(530),h0tab(:,530),[24,3,4],[0,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(33),m3h9x4(:,69),heltab2x36(:,:,479))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(531),h0tab(:,531),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(34),m3h9x4(:,70),heltab2x36(:,:,480))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(532),h0tab(:,532),[24,3,4],[0,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(41),m3h9x4(:,71),heltab2x36(:,:,481))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(533),h0tab(:,533),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(42),m3h9x4(:,72),heltab2x36(:,:,482))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(534),h0tab(:,534),[24,3,4],[nMW,nMH,nMH],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(43),m3h9x4(:,73),heltab2x36(:,:,483))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(535),h0tab(:,535),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(44),m3h9x4(:,74),heltab2x36(:,:,484))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(536),h0tab(:,536),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(45),m3h9x4(:,75),heltab2x36(:,:,485))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(537),h0tab(:,537),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(35),m3h9x4(:,76),heltab2x36(:,:,486))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(538),h0tab(:,538),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(36),m3h9x4(:,77),heltab2x36(:,:,487))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(539),h0tab(:,539),[24,3,4],[0,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(37),m3h9x4(:,78),heltab2x36(:,:,488))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(540),h0tab(:,540),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(38),m3h9x4(:,79),heltab2x36(:,:,489))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(541),h0tab(:,541),[24,3,4],[0,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(46),m3h9x4(:,80),heltab2x36(:,:,490))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(542),h0tab(:,542),[24,3,4],[nMZ,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(47),m3h9x4(:,81),heltab2x36(:,:,491))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(543),h0tab(:,543),[24,3,4],[nMW,nMZ,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(48),m3h9x4(:,82),heltab2x36(:,:,492))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(544),h0tab(:,544),[24,3,4],[nMH,nMW,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(49),m3h9x4(:,83),heltab2x36(:,:,493))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(545),h0tab(:,545),[16,7,8],[nML,0,0],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,399),heltab2x36(:,:,494))
  call Hloop_A_Q(ntryL,G0H12(72),16,nML,G1H12(13),n2h12(63))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(546),h0tab(:,546),[16,7,8],[0,nML,nML],3,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(81),m3h3x12(:,400),heltab2x36(:,:,495))
  call Hloop_Q_A(ntryL,G0H12(81),16,0,G1H12(14),n2h12(64))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(547),h0tab(:,547),[16,7,8],[nMB,nMT,nMT],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,401),heltab2x36(:,:,496))
  call Hloop_A_Q(ntryL,G0H12(9),16,nMB,G1H12(16),n2h12(65))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(548),h0tab(:,548),[16,7,8],[nMT,nMB,nMB],3,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,402),heltab2x36(:,:,497))
  call Hloop_Q_A(ntryL,G0H12(5),16,nMT,G1H12(18),n2h12(66))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(549),h0tab(:,549),[16,7,8],[nMW,nMH,nMZ],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(19),m3h3x12(:,403),heltab2x36(:,:,498))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(550),h0tab(:,550),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(20),m3h3x12(:,404),heltab2x36(:,:,499))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(551),h0tab(:,551),[16,7,8],[0,nMW,nMW],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(22),m3h3x12(:,405),heltab2x36(:,:,500))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(552),h0tab(:,552),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(24),m3h3x12(:,406),heltab2x36(:,:,501))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(553),h0tab(:,553),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(25),m3h3x12(:,407),heltab2x36(:,:,502))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(554),h0tab(:,554),[16,7,8],[0,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(26),m3h3x12(:,408),heltab2x36(:,:,503))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(555),h0tab(:,555),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(32),m3h3x12(:,409),heltab2x36(:,:,504))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(556),h0tab(:,556),[16,7,8],[0,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(76),m3h3x12(:,410),heltab2x36(:,:,505))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(557),h0tab(:,557),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(8),m3h3x12(:,411),heltab2x36(:,:,506))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(558),h0tab(:,558),[16,7,8],[nMW,nMZ,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(82),m3h3x12(:,412),heltab2x36(:,:,507))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(559),h0tab(:,559),[16,7,8],[nMW,nMZ,nMH],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(33),m3h3x12(:,413),heltab2x36(:,:,508))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(560),h0tab(:,560),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(34),m3h3x12(:,414),heltab2x36(:,:,509))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(561),h0tab(:,561),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(35),m3h3x12(:,415),heltab2x36(:,:,510))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(562),h0tab(:,562),[16,7,8],[nMW,nMH,nMZ],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(77),m3h3x12(:,416),heltab2x36(:,:,511))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(563),h0tab(:,563),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(6),m3h3x12(:,417),heltab2x36(:,:,512))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(564),h0tab(:,564),[16,7,8],[0,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(75),m3h3x12(:,418),heltab2x36(:,:,513))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(565),h0tab(:,565),[16,7,8],[nMW,nMZ,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,419),heltab2x36(:,:,514))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(566),h0tab(:,566),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,420),heltab2x36(:,:,515))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(567),h0tab(:,567),[16,7,8],[0,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(37),m3h3x12(:,421),heltab2x36(:,:,516))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(568),h0tab(:,568),[16,7,8],[nMW,nMH,nMZ],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(38),m3h3x12(:,422),heltab2x36(:,:,517))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(569),h0tab(:,569),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(39),m3h3x12(:,423),heltab2x36(:,:,518))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(570),h0tab(:,570),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,424),heltab2x36(:,:,519))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(571),h0tab(:,571),[16,7,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,425),heltab2x36(:,:,520))
  call Hloop_A_Q(ntryL,G0H12(30),16,0,G1H12(40),n2h12(67))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(572),h0tab(:,572),[16,7,8],[nML,0,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,426),heltab2x36(:,:,521))
  call Hloop_A_Q(ntryL,G0H12(1),16,nML,G1H12(42),n2h12(68))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(573),h0tab(:,573),[16,7,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,427),heltab2x36(:,:,522))
  call Hloop_Q_A(ntryL,G0H12(31),16,0,G1H12(43),n2h12(69))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(574),h0tab(:,574),[16,7,8],[0,nML,nML],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,428),heltab2x36(:,:,523))
  call Hloop_Q_A(ntryL,G0H12(3),16,0,G1H12(44),n2h12(70))
  Gcoeff(:)%j = (c(210)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(575),h0tab(:,575),[16,7,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,429),heltab2x36(:,:,524))
  call Hloop_A_Q(ntryL,G0H12(18),16,0,G1H12(45),n2h12(71))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(576),h0tab(:,576),[16,7,8],[nMB,nMT,nMT],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,430),heltab2x36(:,:,525))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(47),n2h12(72))
  Gcoeff(:)%j = (c(210)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(577),h0tab(:,577),[16,7,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,431),heltab2x36(:,:,526))
  call Hloop_Q_A(ntryL,G0H12(16),16,0,G1H12(48),n2h12(73))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(578),h0tab(:,578),[16,7,8],[nMT,nMB,nMB],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,432),heltab2x36(:,:,527))
  call Hloop_Q_A(ntryL,G0H12(17),16,nMT,G1H12(49),n2h12(74))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(579),h0tab(:,579),[16,7,8],[nMW,nMZ,nMH],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(50),m3h3x12(:,433),heltab2x36(:,:,528))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(580),h0tab(:,580),[16,7,8],[nMW,nMH,nMZ],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(52),m3h3x12(:,434),heltab2x36(:,:,529))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(581),h0tab(:,581),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(53),m3h3x12(:,435),heltab2x36(:,:,530))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(582),h0tab(:,582),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(127),m3h3x12(:,436),heltab2x36(:,:,531))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(583),h0tab(:,583),[16,7,8],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(128),m3h3x12(:,437),heltab2x36(:,:,532))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(584),h0tab(:,584),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(129),m3h3x12(:,438),heltab2x36(:,:,533))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(585),h0tab(:,585),[16,7,8],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(130),m3h3x12(:,439),heltab2x36(:,:,534))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(586),h0tab(:,586),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(131),m3h3x12(:,440),heltab2x36(:,:,535))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(587),h0tab(:,587),[16,7,8],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(132),m3h3x12(:,441),heltab2x36(:,:,536))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(588),h0tab(:,588),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(133),m3h3x12(:,442),heltab2x36(:,:,537))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(589),h0tab(:,589),[16,7,8],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,443),heltab2x36(:,:,538))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(590),h0tab(:,590),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(41),m3h3x12(:,444),heltab2x36(:,:,539))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(591),h0tab(:,591),[16,7,8],[nMW,nMZ,nMH],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(134),m3h3x12(:,445),heltab2x36(:,:,540))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(592),h0tab(:,592),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(135),m3h3x12(:,446),heltab2x36(:,:,541))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(593),h0tab(:,593),[16,7,8],[nMW,nMH,nMZ],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(42),m3h3x12(:,447),heltab2x36(:,:,542))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(594),h0tab(:,594),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,448),heltab2x36(:,:,543))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(595),h0tab(:,595),[16,7,8],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(56),m3h3x12(:,449),heltab2x36(:,:,544))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(596),h0tab(:,596),[16,7,8],[nMW,nMZ,nMH],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,450),heltab2x36(:,:,545))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(597),h0tab(:,597),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(58),m3h3x12(:,451),heltab2x36(:,:,546))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(598),h0tab(:,598),[16,7,8],[0,nMW,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(136),m3h3x12(:,452),heltab2x36(:,:,547))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(599),h0tab(:,599),[16,7,8],[nMW,nMH,nMZ],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(137),m3h3x12(:,453),heltab2x36(:,:,548))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(600),h0tab(:,600),[16,7,8],[nMZ,nMW,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(138),m3h3x12(:,454),heltab2x36(:,:,549))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(601),h0tab(:,601),[16,7,8],[nMH,nMW,nMW],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(59),m3h3x12(:,455),heltab2x36(:,:,550))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(602),h0tab(:,602),[16,4,11],[nML,nML,0],3,1,wf12(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(60),m3h3x12(:,456),heltab2x36(:,:,551))
  call Hloop_A_Q(ntryL,G0H12(60),16,nML,G1H12(139),n2h12(75))
  Gcoeff(:)%j = (c(240)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(603),h0tab(:,603),[16,4,11],[nMT,nMT,nMB],3,1,wf12(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,457),heltab2x36(:,:,552))
  call Hloop_Q_A(ntryL,G0H12(61),16,nMT,G1H12(140),n2h12(76))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(604),h0tab(:,604),[16,4,11],[nMB,nMB,nMT],3,1,wf12(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,458),heltab2x36(:,:,553))
  call Hloop_A_Q(ntryL,G0H12(62),16,nMB,G1H12(141),n2h12(77))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(605),h0tab(:,605),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(142),m3h3x12(:,459),heltab2x36(:,:,554))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(606),h0tab(:,606),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(143),m3h3x12(:,460),heltab2x36(:,:,555))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(607),h0tab(:,607),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(144),m3h3x12(:,461),heltab2x36(:,:,556))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(608),h0tab(:,608),[16,4,11],[nMW,nMW,0],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(145),m3h3x12(:,462),heltab2x36(:,:,557))
  Gcoeff(:)%j = (-(c(167)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(609),h0tab(:,609),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(146),m3h3x12(:,463),heltab2x36(:,:,558))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(610),h0tab(:,610),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(147),m3h3x12(:,464),heltab2x36(:,:,559))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(611),h0tab(:,611),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(148),m3h3x12(:,465),heltab2x36(:,:,560))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(612),h0tab(:,612),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(149),m3h3x12(:,466),heltab2x36(:,:,561))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(613),h0tab(:,613),[16,4,11],[nMW,nMW,0],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(150),m3h3x12(:,467),heltab2x36(:,:,562))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(614),h0tab(:,614),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(151),m3h3x12(:,468),heltab2x36(:,:,563))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(615),h0tab(:,615),[16,4,11],[nMW,nMW,0],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(63),m3h3x12(:,469),heltab2x36(:,:,564))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(616),h0tab(:,616),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,470),heltab2x36(:,:,565))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(617),h0tab(:,617),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(81),m3h3x12(:,471),heltab2x36(:,:,566))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(618),h0tab(:,618),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(152),m3h3x12(:,472),heltab2x36(:,:,567))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(619),h0tab(:,619),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(153),m3h3x12(:,473),heltab2x36(:,:,568))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(620),h0tab(:,620),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(154),m3h3x12(:,474),heltab2x36(:,:,569))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(621),h0tab(:,621),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,475),heltab2x36(:,:,570))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(622),h0tab(:,622),[16,4,11],[nMW,nMW,0],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,476),heltab2x36(:,:,571))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(623),h0tab(:,623),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,477),heltab2x36(:,:,572))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(624),h0tab(:,624),[16,4,11],[nMW,nMW,0],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(155),m3h3x12(:,478),heltab2x36(:,:,573))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(625),h0tab(:,625),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(156),m3h3x12(:,479),heltab2x36(:,:,574))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(626),h0tab(:,626),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(157),m3h3x12(:,480),heltab2x36(:,:,575))
  Gcoeff(:)%j = (-(c(173)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(627),h0tab(:,627),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,481),heltab2x36(:,:,576))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(628),h0tab(:,628),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,482),heltab2x36(:,:,577))
  Gcoeff(:)%j = (c(183)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(629),h0tab(:,629),[16,4,11],[nML,nML,0],3,1,wf12(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,483),heltab2x36(:,:,578))
  call Hloop_A_Q(ntryL,G0H12(3),16,nML,G1H12(158),n2h12(78))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(630),h0tab(:,630),[16,4,11],[nMT,nMT,nMB],3,1,wf12(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,484),heltab2x36(:,:,579))
  call Hloop_Q_A(ntryL,G0H12(18),16,nMT,G1H12(159),n2h12(79))
  Gcoeff(:)%j = (c(181)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(631),h0tab(:,631),[16,4,11],[nMB,nMB,nMT],3,1,wf12(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,485),heltab2x36(:,:,580))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(160),n2h12(80))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(632),h0tab(:,632),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(161),m3h3x12(:,486),heltab2x36(:,:,581))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(633),h0tab(:,633),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(162),m3h3x12(:,487),heltab2x36(:,:,582))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(634),h0tab(:,634),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(163),m3h3x12(:,488),heltab2x36(:,:,583))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(635),h0tab(:,635),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(164),m3h3x12(:,489),heltab2x36(:,:,584))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(636),h0tab(:,636),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(165),m3h3x12(:,490),heltab2x36(:,:,585))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(637),h0tab(:,637),[16,4,11],[nMW,nMW,0],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(166),m3h3x12(:,491),heltab2x36(:,:,586))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(638),h0tab(:,638),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(167),m3h3x12(:,492),heltab2x36(:,:,587))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(639),h0tab(:,639),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(168),m3h3x12(:,493),heltab2x36(:,:,588))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(640),h0tab(:,640),[16,4,11],[nMW,nMW,0],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(169),m3h3x12(:,494),heltab2x36(:,:,589))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(641),h0tab(:,641),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(170),m3h3x12(:,495),heltab2x36(:,:,590))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(642),h0tab(:,642),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(171),m3h3x12(:,496),heltab2x36(:,:,591))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(643),h0tab(:,643),[16,4,11],[nMW,nMW,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(172),m3h3x12(:,497),heltab2x36(:,:,592))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(644),h0tab(:,644),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(173),m3h3x12(:,498),heltab2x36(:,:,593))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(645),h0tab(:,645),[16,4,11],[nMW,nMW,0],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,499),heltab2x36(:,:,594))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(646),h0tab(:,646),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,500),heltab2x36(:,:,595))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(647),h0tab(:,647),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(60),m3h3x12(:,501),heltab2x36(:,:,596))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(648),h0tab(:,648),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(174),m3h3x12(:,502),heltab2x36(:,:,597))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(649),h0tab(:,649),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(175),m3h3x12(:,503),heltab2x36(:,:,598))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(650),h0tab(:,650),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,504),heltab2x36(:,:,599))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(651),h0tab(:,651),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,505),heltab2x36(:,:,600))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(652),h0tab(:,652),[16,4,11],[nMW,nMW,0],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,506),heltab2x36(:,:,601))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(653),h0tab(:,653),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,507),heltab2x36(:,:,602))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(654),h0tab(:,654),[16,4,11],[nMW,nMW,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(176),m3h3x12(:,508),heltab2x36(:,:,603))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(655),h0tab(:,655),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(177),m3h3x12(:,509),heltab2x36(:,:,604))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(656),h0tab(:,656),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,510),heltab2x36(:,:,605))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(657),h0tab(:,657),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(87),m3h3x12(:,511),heltab2x36(:,:,606))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(658),h0tab(:,658),[19,4,8],[nML,nML,nML],3,1,wf12(:,34))
  call Hloop_AS_Q(ntryL,G0H36(1),wf12(:,34),G0H3(8),ngH,m3h12x3(:,1),heltab2x36(:,:,607))
  call Hloop_A_Q(ntryL,G0H3(8),19,nML,G1H3(128),n2h3(74))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(659),h0tab(:,659),[19,4,8],[nML,nML,nML],3,1,wf12(:,34))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(4),ngH,m3h12x3(:,2),heltab2x36(:,:,608))
  call Hloop_Q_A(ntryL,G0H3(4),19,nML,G1H3(136),n2h3(75))
  Gcoeff(:)%j = (-(c(199)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(660),h0tab(:,660),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,34))
  call Hloop_AS_Q(ntryL,G0H36(1),wf12(:,34),G0H3(6),ngH,m3h12x3(:,3),heltab2x36(:,:,609))
  call Hloop_A_Q(ntryL,G0H3(6),19,nMT,G1H3(137),n2h3(76))
  Gcoeff(:)%j = (-(c(199)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(661),h0tab(:,661),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,34))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(7),ngH,m3h12x3(:,4),heltab2x36(:,:,610))
  call Hloop_Q_A(ntryL,G0H3(7),19,nMT,G1H3(141),n2h3(77))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(662),h0tab(:,662),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,34))
  call Hloop_AS_Q(ntryL,G0H36(1),wf12(:,34),G0H3(8),ngH,m3h12x3(:,5),heltab2x36(:,:,611))
  call Hloop_A_Q(ntryL,G0H3(8),19,nMB,G1H3(142),n2h3(78))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(663),h0tab(:,663),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,34))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(4),ngH,m3h12x3(:,6),heltab2x36(:,:,612))
  call Hloop_Q_A(ntryL,G0H3(4),19,nMB,G1H3(143),n2h3(79))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(664),h0tab(:,664),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(6),m3h12x3(:,7),heltab2x36(:,:,613))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(665),h0tab(:,665),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(7),m3h12x3(:,8),heltab2x36(:,:,614))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(666),h0tab(:,666),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(8),m3h12x3(:,9),heltab2x36(:,:,615))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(667),h0tab(:,667),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(4),m3h12x3(:,10),heltab2x36(:,:,616))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(668),h0tab(:,668),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(13),m3h12x3(:,11),heltab2x36(:,:,617))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(669),h0tab(:,669),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(14),m3h12x3(:,12),heltab2x36(:,:,618))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(670),h0tab(:,670),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,34),G0H3(15),m3h12x3(:,13),heltab2x36(:,:,619))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(671),h0tab(:,671),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,34),G0H3(16),m3h12x3(:,14),heltab2x36(:,:,620))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(672),h0tab(:,672),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(147),m3h12x3(:,15),heltab2x36(:,:,621))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(673),h0tab(:,673),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(148),m3h12x3(:,16),heltab2x36(:,:,622))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(674),h0tab(:,674),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(150),m3h12x3(:,17),heltab2x36(:,:,623))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(675),h0tab(:,675),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(153),m3h12x3(:,18),heltab2x36(:,:,624))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(676),h0tab(:,676),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(17),m3h12x3(:,19),heltab2x36(:,:,625))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(677),h0tab(:,677),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(18),m3h12x3(:,20),heltab2x36(:,:,626))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(678),h0tab(:,678),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,34),G0H3(19),m3h12x3(:,21),heltab2x36(:,:,627))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(679),h0tab(:,679),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,34),G0H3(20),m3h12x3(:,22),heltab2x36(:,:,628))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(680),h0tab(:,680),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(155),m3h12x3(:,23),heltab2x36(:,:,629))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(681),h0tab(:,681),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(156),m3h12x3(:,24),heltab2x36(:,:,630))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(682),h0tab(:,682),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(160),m3h12x3(:,25),heltab2x36(:,:,631))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(683),h0tab(:,683),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,34))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(161),m3h12x3(:,26),heltab2x36(:,:,632))
  Gcoeff(:)%j = (-(c(254)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(684),h0tab(:,684),[19,4,8],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,27),heltab2x36(:,:,633))
  call Hloop_A_Q(ntryL,G0H3(21),19,nML,G1H3(42),n2h3(80))
  Gcoeff(:)%j = (-(c(254)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(685),h0tab(:,685),[19,4,8],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,28),heltab2x36(:,:,634))
  call Hloop_Q_A(ntryL,G0H3(21),19,nML,G1H3(38),n2h3(81))
  Gcoeff(:)%j = (c(257)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(686),h0tab(:,686),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,29),heltab2x36(:,:,635))
  call Hloop_A_Q(ntryL,G0H3(21),19,nMT,G1H3(51),n2h3(82))
  Gcoeff(:)%j = (c(257)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(687),h0tab(:,687),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,30),heltab2x36(:,:,636))
  call Hloop_Q_A(ntryL,G0H3(21),19,nMT,G1H3(12),n2h3(83))
  Gcoeff(:)%j = (-(c(250)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(688),h0tab(:,688),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,31),heltab2x36(:,:,637))
  call Hloop_A_Q(ntryL,G0H3(21),19,nMB,G1H3(32),n2h3(84))
  Gcoeff(:)%j = (-(c(250)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(689),h0tab(:,689),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,32),heltab2x36(:,:,638))
  call Hloop_Q_A(ntryL,G0H3(21),19,nMB,G1H3(46),n2h3(85))
  Gcoeff(:)%j = (c(223)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(690),h0tab(:,690),[19,4,8],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,1),G0H3(21),ngZl,m3h12x3(:,33),heltab2x36(:,:,639))
  call Hloop_A_Q(ntryL,G0H3(21),19,nML,G1H3(49),n2h3(86))
  Gcoeff(:)%j = (c(223)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(691),h0tab(:,691),[19,4,8],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(21),ngZl,m3h12x3(:,34),heltab2x36(:,:,640))
  call Hloop_Q_A(ntryL,G0H3(21),19,nML,G1H3(107),n2h3(87))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(692),h0tab(:,692),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,1),G0H3(21),ngZu,m3h12x3(:,35),heltab2x36(:,:,641))
  call Hloop_A_Q(ntryL,G0H3(21),19,nMT,G1H3(4),n2h3(88))
  Gcoeff(:)%j = (c(228)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(693),h0tab(:,693),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(21),ngZu,m3h12x3(:,36),heltab2x36(:,:,642))
  call Hloop_Q_A(ntryL,G0H3(21),19,nMT,G1H3(110),n2h3(89))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(694),h0tab(:,694),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,1),G0H3(21),ngZd,m3h12x3(:,37),heltab2x36(:,:,643))
  call Hloop_A_Q(ntryL,G0H3(21),19,nMB,G1H3(111),n2h3(90))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(695),h0tab(:,695),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(21),ngZd,m3h12x3(:,38),heltab2x36(:,:,644))
  call Hloop_Q_A(ntryL,G0H3(21),19,nMB,G1H3(65),n2h3(91))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(696),h0tab(:,696),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(112),m3h12x3(:,39),heltab2x36(:,:,645))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(697),h0tab(:,697),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(163),m3h12x3(:,40),heltab2x36(:,:,646))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(698),h0tab(:,698),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(164),m3h12x3(:,41),heltab2x36(:,:,647))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(699),h0tab(:,699),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(165),m3h12x3(:,42),heltab2x36(:,:,648))
  Gcoeff(:)%j = (-(c(147)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(700),h0tab(:,700),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(169),m3h12x3(:,43),heltab2x36(:,:,649))
  Gcoeff(:)%j = (-(c(147)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(701),h0tab(:,701),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(170),m3h12x3(:,44),heltab2x36(:,:,650))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(702),h0tab(:,702),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,1),G1H3(171),m3h12x3(:,45),heltab2x36(:,:,651))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(703),h0tab(:,703),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(115),m3h12x3(:,46),heltab2x36(:,:,652))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(704),h0tab(:,704),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,1),G1H3(116),m3h12x3(:,47),heltab2x36(:,:,653))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(705),h0tab(:,705),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(117),m3h12x3(:,48),heltab2x36(:,:,654))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(706),h0tab(:,706),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,1),G1H3(122),m3h12x3(:,49),heltab2x36(:,:,655))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(707),h0tab(:,707),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(125),m3h12x3(:,50),heltab2x36(:,:,656))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(708),h0tab(:,708),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,1),G1H3(126),m3h12x3(:,51),heltab2x36(:,:,657))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(709),h0tab(:,709),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(55),m3h12x3(:,52),heltab2x36(:,:,658))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(710),h0tab(:,710),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(62),m3h12x3(:,53),heltab2x36(:,:,659))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(711),h0tab(:,711),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(1),m3h12x3(:,54),heltab2x36(:,:,660))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(712),h0tab(:,712),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(24),m3h12x3(:,55),heltab2x36(:,:,661))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(713),h0tab(:,713),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(64),m3h12x3(:,56),heltab2x36(:,:,662))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(714),h0tab(:,714),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(21),m3h12x3(:,57),heltab2x36(:,:,663))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(715),h0tab(:,715),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(22),m3h12x3(:,58),heltab2x36(:,:,664))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(716),h0tab(:,716),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(23),m3h12x3(:,59),heltab2x36(:,:,665))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(717),h0tab(:,717),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(24),m3h12x3(:,60),heltab2x36(:,:,666))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(718),h0tab(:,718),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(25),m3h12x3(:,61),heltab2x36(:,:,667))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(719),h0tab(:,719),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(26),m3h12x3(:,62),heltab2x36(:,:,668))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(720),h0tab(:,720),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(27),m3h12x3(:,63),heltab2x36(:,:,669))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(721),h0tab(:,721),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(28),m3h12x3(:,64),heltab2x36(:,:,670))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(722),h0tab(:,722),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(29),m3h12x3(:,65),heltab2x36(:,:,671))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(723),h0tab(:,723),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(30),m3h12x3(:,66),heltab2x36(:,:,672))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(724),h0tab(:,724),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(31),m3h12x3(:,67),heltab2x36(:,:,673))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(725),h0tab(:,725),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(33),m3h12x3(:,68),heltab2x36(:,:,674))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(726),h0tab(:,726),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(75),m3h12x3(:,69),heltab2x36(:,:,675))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(727),h0tab(:,727),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(40),m3h12x3(:,70),heltab2x36(:,:,676))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(728),h0tab(:,728),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(56),m3h12x3(:,71),heltab2x36(:,:,677))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(729),h0tab(:,729),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(50),m3h12x3(:,72),heltab2x36(:,:,678))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(730),h0tab(:,730),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(84),m3h12x3(:,73),heltab2x36(:,:,679))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(731),h0tab(:,731),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(57),m3h12x3(:,74),heltab2x36(:,:,680))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(732),h0tab(:,732),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(68),m3h12x3(:,75),heltab2x36(:,:,681))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(733),h0tab(:,733),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(31),m3h12x3(:,76),heltab2x36(:,:,682))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(734),h0tab(:,734),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(32),m3h12x3(:,77),heltab2x36(:,:,683))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(735),h0tab(:,735),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(33),m3h12x3(:,78),heltab2x36(:,:,684))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(736),h0tab(:,736),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(34),m3h12x3(:,79),heltab2x36(:,:,685))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(737),h0tab(:,737),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(35),m3h12x3(:,80),heltab2x36(:,:,686))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(738),h0tab(:,738),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(36),m3h12x3(:,81),heltab2x36(:,:,687))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(739),h0tab(:,739),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(37),m3h12x3(:,82),heltab2x36(:,:,688))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(740),h0tab(:,740),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(38),m3h12x3(:,83),heltab2x36(:,:,689))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(741),h0tab(:,741),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(39),m3h12x3(:,84),heltab2x36(:,:,690))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(742),h0tab(:,742),[18,4,9],[nMZ,nMZ,0],3,2,wf6(:,8),wf6(:,2))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,8),G0H6(4),ngZu,m3h6x6(:,13),heltab2x36(:,:,691))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(743),h0tab(:,743),[18,4,9],[nMW,nMW,0],3,2,wf6(:,8),wf6(:,2))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,14),heltab2x36(:,:,692))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(744),h0tab(:,744),[20,2,9],[nMW,0,0],3,2,wf3(:,2),wf6(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(88),m3h3x12(:,512),heltab2x36(:,:,693))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(745),h0tab(:,745),[20,2,9],[0,0,nMW],3,2,wf3(:,2),wf6(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(89),m3h3x12(:,513),heltab2x36(:,:,694))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(746),h0tab(:,746),[20,2,9],[nMW,0,nMZ],3,2,wf3(:,2),wf6(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(90),m3h3x12(:,514),heltab2x36(:,:,695))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(747),h0tab(:,747),[20,2,9],[nMZ,0,nMW],3,2,wf3(:,2),wf6(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(91),m3h3x12(:,515),heltab2x36(:,:,696))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(748),h0tab(:,748),[20,2,9],[0,0,0],3,2,wf3(:,3),wf6(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(92),m3h3x12(:,516),heltab2x36(:,:,697))
  call Hloop_A_Q(ntryL,G0H12(92),20,0,G1H12(178),n2h12(81))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(749),h0tab(:,749),[20,2,9],[0,nMZ,0],3,2,wf3(:,3),wf6(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(92),m3h3x12(:,517),heltab2x36(:,:,698))
  call Hloop_A_Q(ntryL,G0H12(92),20,0,G1H12(179),n2h12(82))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(750),h0tab(:,750),[20,2,9],[0,0,0],3,2,wf3(:,3),wf6(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(92),m3h3x12(:,518),heltab2x36(:,:,699))
  call Hloop_A_Q(ntryL,G0H12(92),20,0,G1H12(180),n2h12(83))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(751),h0tab(:,751),[20,2,9],[nMW,0,0],3,2,wf3(:,3),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(181),m3h3x12(:,519),heltab2x36(:,:,700))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(752),h0tab(:,752),[20,2,9],[0,0,nMW],3,2,wf3(:,3),wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(182),m3h3x12(:,520),heltab2x36(:,:,701))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(753),h0tab(:,753),[20,2,9],[nMW,0,nMZ],3,2,wf3(:,3),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(183),m3h3x12(:,521),heltab2x36(:,:,702))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(754),h0tab(:,754),[20,2,9],[nMZ,0,nMW],3,2,wf3(:,3),wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(184),m3h3x12(:,522),heltab2x36(:,:,703))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(755),h0tab(:,755),[16,4,11],[nML,nML,0],3,1,wf12(:,4))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,523),heltab2x36(:,:,704))
  call Hloop_A_Q(ntryL,G0H12(92),16,nML,G1H12(185),n2h12(84))
  Gcoeff(:)%j = (c(206)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(756),h0tab(:,756),[16,4,11],[nMT,nMT,nMB],3,1,wf12(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,524),heltab2x36(:,:,705))
  call Hloop_Q_A(ntryL,G0H12(92),16,nMT,G1H12(186),n2h12(85))
  Gcoeff(:)%j = (c(204)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(757),h0tab(:,757),[16,4,11],[nMB,nMB,nMT],3,1,wf12(:,4))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,525),heltab2x36(:,:,706))
  call Hloop_A_Q(ntryL,G0H12(92),16,nMB,G1H12(187),n2h12(86))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(758),h0tab(:,758),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(188),m3h3x12(:,526),heltab2x36(:,:,707))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(759),h0tab(:,759),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(189),m3h3x12(:,527),heltab2x36(:,:,708))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(760),h0tab(:,760),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(190),m3h3x12(:,528),heltab2x36(:,:,709))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(761),h0tab(:,761),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(191),m3h3x12(:,529),heltab2x36(:,:,710))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(762),h0tab(:,762),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(192),m3h3x12(:,530),heltab2x36(:,:,711))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(763),h0tab(:,763),[16,4,11],[nMW,nMW,0],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(193),m3h3x12(:,531),heltab2x36(:,:,712))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(764),h0tab(:,764),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(194),m3h3x12(:,532),heltab2x36(:,:,713))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(765),h0tab(:,765),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(195),m3h3x12(:,533),heltab2x36(:,:,714))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(766),h0tab(:,766),[16,4,11],[nMW,nMW,0],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(196),m3h3x12(:,534),heltab2x36(:,:,715))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(767),h0tab(:,767),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(197),m3h3x12(:,535),heltab2x36(:,:,716))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(768),h0tab(:,768),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(198),m3h3x12(:,536),heltab2x36(:,:,717))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(769),h0tab(:,769),[16,4,11],[nMW,nMW,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(199),m3h3x12(:,537),heltab2x36(:,:,718))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(770),h0tab(:,770),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(200),m3h3x12(:,538),heltab2x36(:,:,719))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(771),h0tab(:,771),[16,4,11],[nMW,nMW,0],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,539),heltab2x36(:,:,720))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(772),h0tab(:,772),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(93),m3h3x12(:,540),heltab2x36(:,:,721))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(773),h0tab(:,773),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(94),m3h3x12(:,541),heltab2x36(:,:,722))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(774),h0tab(:,774),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(201),m3h3x12(:,542),heltab2x36(:,:,723))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(775),h0tab(:,775),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(202),m3h3x12(:,543),heltab2x36(:,:,724))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(776),h0tab(:,776),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(95),m3h3x12(:,544),heltab2x36(:,:,725))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(777),h0tab(:,777),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(96),m3h3x12(:,545),heltab2x36(:,:,726))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(778),h0tab(:,778),[16,4,11],[nMW,nMW,0],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,546),heltab2x36(:,:,727))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(779),h0tab(:,779),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(98),m3h3x12(:,547),heltab2x36(:,:,728))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(780),h0tab(:,780),[16,4,11],[nMW,nMW,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(203),m3h3x12(:,548),heltab2x36(:,:,729))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(781),h0tab(:,781),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(204),m3h3x12(:,549),heltab2x36(:,:,730))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(782),h0tab(:,782),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(99),m3h3x12(:,550),heltab2x36(:,:,731))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(783),h0tab(:,783),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(100),m3h3x12(:,551),heltab2x36(:,:,732))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(784),h0tab(:,784),[25,2,4],[0,nMZ,nMZ],3,1,wf18(:,2))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf18(:,2),G0H2(1),ngZd,m3h18x2(:,1),heltab2x36(:,:,733))
  call Hloop_A_Q(ntryL,G0H2(1),25,0,G1H2(1),n2h2(76))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(785),h0tab(:,785),[25,2,4],[0,nMW,nMW],3,1,wf18(:,2))
  call Hloop_WA_Q(ntryL,G0H36(1),wf18(:,2),G0H2(1),m3h18x2(:,2),heltab2x36(:,:,734))
  call Hloop_A_Q(ntryL,G0H2(1),25,0,G1H2(2),n2h2(77))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(786),h0tab(:,786),[17,4,10],[nMZ,nMZ,0],3,2,wf6(:,6),wf6(:,4))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,6),G0H6(1),ngZd,m3h6x6(:,15),heltab2x36(:,:,735))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(787),h0tab(:,787),[17,4,10],[nMW,nMW,0],3,2,wf6(:,6),wf6(:,4))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,6),G0H6(2),m3h6x6(:,16),heltab2x36(:,:,736))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(788),h0tab(:,788),[20,1,10],[0,0,nMW],3,2,wf3(:,2),wf6(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(101),m3h3x12(:,552),heltab2x36(:,:,737))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(789),h0tab(:,789),[20,1,10],[nMW,0,0],3,2,wf3(:,2),wf6(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(102),m3h3x12(:,553),heltab2x36(:,:,738))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(790),h0tab(:,790),[20,1,10],[nMZ,0,nMW],3,2,wf3(:,2),wf6(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(103),m3h3x12(:,554),heltab2x36(:,:,739))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(791),h0tab(:,791),[20,1,10],[nMW,0,nMZ],3,2,wf3(:,2),wf6(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(104),m3h3x12(:,555),heltab2x36(:,:,740))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(792),h0tab(:,792),[20,1,10],[0,0,0],3,2,wf3(:,3),wf6(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(105),m3h3x12(:,556),heltab2x36(:,:,741))
  call Hloop_Q_A(ntryL,G0H12(105),20,0,G1H12(205),n2h12(87))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(793),h0tab(:,793),[20,1,10],[0,nMZ,0],3,2,wf3(:,3),wf6(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(105),m3h3x12(:,557),heltab2x36(:,:,742))
  call Hloop_Q_A(ntryL,G0H12(105),20,0,G1H12(206),n2h12(88))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(794),h0tab(:,794),[20,1,10],[0,0,0],3,2,wf3(:,3),wf6(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(105),m3h3x12(:,558),heltab2x36(:,:,743))
  call Hloop_Q_A(ntryL,G0H12(105),20,0,G1H12(207),n2h12(89))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(795),h0tab(:,795),[20,1,10],[0,0,nMW],3,2,wf3(:,3),wf6(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(208),m3h3x12(:,559),heltab2x36(:,:,744))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(796),h0tab(:,796),[20,1,10],[nMW,0,0],3,2,wf3(:,3),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(209),m3h3x12(:,560),heltab2x36(:,:,745))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(797),h0tab(:,797),[20,1,10],[nMZ,0,nMW],3,2,wf3(:,3),wf6(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(210),m3h3x12(:,561),heltab2x36(:,:,746))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(798),h0tab(:,798),[20,1,10],[nMW,0,nMZ],3,2,wf3(:,3),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(211),m3h3x12(:,562),heltab2x36(:,:,747))
  Gcoeff(:)%j = (c(205)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(799),h0tab(:,799),[16,4,11],[nML,nML,0],3,1,wf12(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(105),m3h3x12(:,563),heltab2x36(:,:,748))
  call Hloop_A_Q(ntryL,G0H12(105),16,nML,G1H12(212),n2h12(90))
  Gcoeff(:)%j = (c(206)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(800),h0tab(:,800),[16,4,11],[nMT,nMT,nMB],3,1,wf12(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(105),m3h3x12(:,564),heltab2x36(:,:,749))
  call Hloop_Q_A(ntryL,G0H12(105),16,nMT,G1H12(213),n2h12(91))
  Gcoeff(:)%j = (c(204)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(801),h0tab(:,801),[16,4,11],[nMB,nMB,nMT],3,1,wf12(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(105),m3h3x12(:,565),heltab2x36(:,:,750))
  call Hloop_A_Q(ntryL,G0H12(105),16,nMB,G1H12(214),n2h12(92))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(802),h0tab(:,802),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(215),m3h3x12(:,566),heltab2x36(:,:,751))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(803),h0tab(:,803),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(216),m3h3x12(:,567),heltab2x36(:,:,752))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(804),h0tab(:,804),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(217),m3h3x12(:,568),heltab2x36(:,:,753))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(805),h0tab(:,805),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(218),m3h3x12(:,569),heltab2x36(:,:,754))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(806),h0tab(:,806),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(219),m3h3x12(:,570),heltab2x36(:,:,755))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(807),h0tab(:,807),[16,4,11],[nMW,nMW,0],3,1,wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(220),m3h3x12(:,571),heltab2x36(:,:,756))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(808),h0tab(:,808),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(221),m3h3x12(:,572),heltab2x36(:,:,757))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(809),h0tab(:,809),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(222),m3h3x12(:,573),heltab2x36(:,:,758))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(810),h0tab(:,810),[16,4,11],[nMW,nMW,0],3,1,wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(223),m3h3x12(:,574),heltab2x36(:,:,759))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(811),h0tab(:,811),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(224),m3h3x12(:,575),heltab2x36(:,:,760))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(812),h0tab(:,812),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(225),m3h3x12(:,576),heltab2x36(:,:,761))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(813),h0tab(:,813),[16,4,11],[nMW,nMW,0],3,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(226),m3h3x12(:,577),heltab2x36(:,:,762))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(814),h0tab(:,814),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(227),m3h3x12(:,578),heltab2x36(:,:,763))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(815),h0tab(:,815),[16,4,11],[nMW,nMW,0],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(105),m3h3x12(:,579),heltab2x36(:,:,764))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(816),h0tab(:,816),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(106),m3h3x12(:,580),heltab2x36(:,:,765))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(817),h0tab(:,817),[16,4,11],[nMH,nMH,nMW],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(107),m3h3x12(:,581),heltab2x36(:,:,766))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(818),h0tab(:,818),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(228),m3h3x12(:,582),heltab2x36(:,:,767))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(819),h0tab(:,819),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(229),m3h3x12(:,583),heltab2x36(:,:,768))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(820),h0tab(:,820),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(108),m3h3x12(:,584),heltab2x36(:,:,769))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(821),h0tab(:,821),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(109),m3h3x12(:,585),heltab2x36(:,:,770))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(822),h0tab(:,822),[16,4,11],[nMW,nMW,0],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(110),m3h3x12(:,586),heltab2x36(:,:,771))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(823),h0tab(:,823),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(111),m3h3x12(:,587),heltab2x36(:,:,772))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(824),h0tab(:,824),[16,4,11],[nMW,nMW,0],3,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(230),m3h3x12(:,588),heltab2x36(:,:,773))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(825),h0tab(:,825),[16,4,11],[nMW,nMW,nMZ],3,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(231),m3h3x12(:,589),heltab2x36(:,:,774))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(826),h0tab(:,826),[16,4,11],[nMZ,nMZ,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(112),m3h3x12(:,590),heltab2x36(:,:,775))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(827),h0tab(:,827),[16,4,11],[nMW,nMW,nMH],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(113),m3h3x12(:,591),heltab2x36(:,:,776))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(828),h0tab(:,828),[26,1,4],[0,nMZ,nMZ],3,1,wf18(:,4))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf18(:,4),G0H2(1),ngZu,m3h18x2(:,3),heltab2x36(:,:,777))
  call Hloop_Q_A(ntryL,G0H2(1),26,0,G1H2(3),n2h2(78))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(829),h0tab(:,829),[26,1,4],[0,nMW,nMW],3,1,wf18(:,4))
  call Hloop_WQ_A(ntryL,G0H36(1),wf18(:,4),G0H2(1),m3h18x2(:,4),heltab2x36(:,:,778))
  call Hloop_Q_A(ntryL,G0H2(1),26,0,G1H2(4),n2h2(79))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(830),h0tab(:,830),[17,2,12],[0,0,0],3,2,wf6(:,6),wf3(:,1))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,17),heltab2x36(:,:,779))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(831),h0tab(:,831),[17,2,12],[nMZ,0,0],3,2,wf6(:,6),wf3(:,1))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,6),G0H6(6),ngZd,m3h6x6(:,18),heltab2x36(:,:,780))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(832),h0tab(:,832),[17,2,12],[nMW,0,0],3,2,wf6(:,6),wf3(:,1))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,6),G0H6(7),m3h6x6(:,19),heltab2x36(:,:,781))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(833),h0tab(:,833),[17,2,12],[0,0,0],3,2,wf6(:,6),wf3(:,1))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(8),m3h6x6(:,20),heltab2x36(:,:,782))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(834),h0tab(:,834),[17,2,12],[0,nMW,nMW],3,2,wf6(:,6),wf3(:,1))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(9),m3h6x6(:,21),heltab2x36(:,:,783))
  call Hloop_A_Q(ntryL,G0H6(9),17,0,G1H6(42),n2h6(145))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(835),h0tab(:,835),[18,1,12],[0,0,0],3,2,wf6(:,8),wf3(:,1))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,8),G0H6(9),m3h6x6(:,22),heltab2x36(:,:,784))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(836),h0tab(:,836),[18,1,12],[nMZ,0,0],3,2,wf6(:,8),wf3(:,1))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,8),G0H6(10),ngZu,m3h6x6(:,23),heltab2x36(:,:,785))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(837),h0tab(:,837),[18,1,12],[nMW,0,0],3,2,wf6(:,8),wf3(:,1))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,8),G0H6(11),m3h6x6(:,24),heltab2x36(:,:,786))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(838),h0tab(:,838),[18,1,12],[0,0,0],3,2,wf6(:,8),wf3(:,1))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,8),G0H6(12),m3h6x6(:,25),heltab2x36(:,:,787))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(839),h0tab(:,839),[18,1,12],[0,nMW,nMW],3,2,wf6(:,8),wf3(:,1))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(13),m3h6x6(:,26),heltab2x36(:,:,788))
  call Hloop_Q_A(ntryL,G0H6(13),18,0,G1H6(8),n2h6(146))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(840),h0tab(:,840),[16,2,13],[0,0,0],3,1,wf6(:,35))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,592),heltab2x36(:,:,789))
  call Hloop_A_Q(ntryL,G0H12(114),16,0,G1H12(232),n2h12(93))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(841),h0tab(:,841),[16,2,13],[0,nMZ,0],3,1,wf6(:,35))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,593),heltab2x36(:,:,790))
  call Hloop_A_Q(ntryL,G0H12(114),16,0,G1H12(233),n2h12(94))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(842),h0tab(:,842),[16,2,13],[0,0,0],3,1,wf6(:,35))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,594),heltab2x36(:,:,791))
  call Hloop_A_Q(ntryL,G0H12(114),16,0,G1H12(234),n2h12(95))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(843),h0tab(:,843),[16,2,13],[nMW,0,0],3,1,wf6(:,35))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(235),m3h3x12(:,595),heltab2x36(:,:,792))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(844),h0tab(:,844),[16,2,13],[0,0,nMW],3,1,wf6(:,35))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(236),m3h3x12(:,596),heltab2x36(:,:,793))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(845),h0tab(:,845),[16,2,13],[nMW,0,nMZ],3,1,wf6(:,35))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(237),m3h3x12(:,597),heltab2x36(:,:,794))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(846),h0tab(:,846),[16,2,13],[nMZ,0,nMW],3,1,wf6(:,35))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(238),m3h3x12(:,598),heltab2x36(:,:,795))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(847),h0tab(:,847),[16,1,14],[0,0,0],3,1,wf6(:,31))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,599),heltab2x36(:,:,796))
  call Hloop_Q_A(ntryL,G0H12(114),16,0,G1H12(239),n2h12(96))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(848),h0tab(:,848),[16,1,14],[0,nMZ,0],3,1,wf6(:,31))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,600),heltab2x36(:,:,797))
  call Hloop_Q_A(ntryL,G0H12(114),16,0,G1H12(240),n2h12(97))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(849),h0tab(:,849),[16,1,14],[0,0,0],3,1,wf6(:,31))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,601),heltab2x36(:,:,798))
  call Hloop_Q_A(ntryL,G0H12(114),16,0,G1H12(241),n2h12(98))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(850),h0tab(:,850),[16,1,14],[0,0,nMW],3,1,wf6(:,31))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(242),m3h3x12(:,602),heltab2x36(:,:,799))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(851),h0tab(:,851),[16,1,14],[nMW,0,0],3,1,wf6(:,31))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(243),m3h3x12(:,603),heltab2x36(:,:,800))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(852),h0tab(:,852),[16,1,14],[nMZ,0,nMW],3,1,wf6(:,31))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(244),m3h3x12(:,604),heltab2x36(:,:,801))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(853),h0tab(:,853),[16,1,14],[nMW,0,nMZ],3,1,wf6(:,31))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(245),m3h3x12(:,605),heltab2x36(:,:,802))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(854),h0tab(:,854),[28,1,2],[0,0,nMW],3,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(50),m3h9x4(:,84),heltab2x36(:,:,803))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(855),h0tab(:,855),[28,1,2],[nMW,0,0],3,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(51),m3h9x4(:,85),heltab2x36(:,:,804))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(856),h0tab(:,856),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(52),m3h9x4(:,86),heltab2x36(:,:,805))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(857),h0tab(:,857),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(53),m3h9x4(:,87),heltab2x36(:,:,806))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(858),h0tab(:,858),[28,1,2],[0,0,nMW],3,1,wf9(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(54),m3h9x4(:,88),heltab2x36(:,:,807))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(859),h0tab(:,859),[28,1,2],[nMW,0,0],3,1,wf9(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(55),m3h9x4(:,89),heltab2x36(:,:,808))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(860),h0tab(:,860),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(56),m3h9x4(:,90),heltab2x36(:,:,809))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(861),h0tab(:,861),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(57),m3h9x4(:,91),heltab2x36(:,:,810))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(862),h0tab(:,862),[28,1,2],[0,0,0],3,1,wf9(:,8))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(58),m3h9x4(:,92),heltab2x36(:,:,811))
  call Hloop_Q_A(ntryL,G0H4(58),28,0,G1H4(39),n2h4(8))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(863),h0tab(:,863),[28,1,2],[0,nMZ,0],3,1,wf9(:,8))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(58),m3h9x4(:,93),heltab2x36(:,:,812))
  call Hloop_Q_A(ntryL,G0H4(58),28,0,G1H4(40),n2h4(9))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(864),h0tab(:,864),[28,1,2],[0,0,0],3,1,wf9(:,8))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(58),m3h9x4(:,94),heltab2x36(:,:,813))
  call Hloop_Q_A(ntryL,G0H4(58),28,0,G1H4(41),n2h4(10))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(865),h0tab(:,865),[28,1,2],[0,0,nMW],3,1,wf9(:,8))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(42),m3h9x4(:,95),heltab2x36(:,:,814))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(866),h0tab(:,866),[28,1,2],[nMW,0,0],3,1,wf9(:,8))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(43),m3h9x4(:,96),heltab2x36(:,:,815))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(867),h0tab(:,867),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,8))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(44),m3h9x4(:,97),heltab2x36(:,:,816))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(868),h0tab(:,868),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,8))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(45),m3h9x4(:,98),heltab2x36(:,:,817))
  Gcoeff(:)%j = (c(252)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(869),h0tab(:,869),[19,4,8],[nML,nML,nML],3,1,wf12(:,11))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,85),heltab2x36(:,:,818))
  call Hloop_A_Q(ntryL,G0H3(40),19,nML,G1H3(89),n2h3(92))
  Gcoeff(:)%j = (c(252)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(870),h0tab(:,870),[19,4,8],[nML,nML,nML],3,1,wf12(:,11))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,86),heltab2x36(:,:,819))
  call Hloop_Q_A(ntryL,G0H3(40),19,nML,G1H3(101),n2h3(93))
  Gcoeff(:)%j = (-(c(255)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(871),h0tab(:,871),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,11))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,87),heltab2x36(:,:,820))
  call Hloop_A_Q(ntryL,G0H3(40),19,nMT,G1H3(83),n2h3(94))
  Gcoeff(:)%j = (-(c(255)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(872),h0tab(:,872),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,11))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,88),heltab2x36(:,:,821))
  call Hloop_Q_A(ntryL,G0H3(40),19,nMT,G1H3(175),n2h3(95))
  Gcoeff(:)%j = (c(248)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(873),h0tab(:,873),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,11))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,89),heltab2x36(:,:,822))
  call Hloop_A_Q(ntryL,G0H3(40),19,nMB,G1H3(87),n2h3(96))
  Gcoeff(:)%j = (c(248)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(874),h0tab(:,874),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,11))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,90),heltab2x36(:,:,823))
  call Hloop_Q_A(ntryL,G0H3(40),19,nMB,G1H3(88),n2h3(97))
  Gcoeff(:)%j = (c(254)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(875),h0tab(:,875),[19,4,8],[nML,nML,nML],3,1,wf12(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZl,m3h12x3(:,91),heltab2x36(:,:,824))
  call Hloop_A_Q(ntryL,G0H3(40),19,nML,G1H3(93),n2h3(98))
  Gcoeff(:)%j = (c(254)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(876),h0tab(:,876),[19,4,8],[nML,nML,nML],3,1,wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZl,m3h12x3(:,92),heltab2x36(:,:,825))
  call Hloop_Q_A(ntryL,G0H3(40),19,nML,G1H3(30),n2h3(99))
  Gcoeff(:)%j = (c(258)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(877),h0tab(:,877),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZu,m3h12x3(:,93),heltab2x36(:,:,826))
  call Hloop_A_Q(ntryL,G0H3(40),19,nMT,G1H3(47),n2h3(100))
  Gcoeff(:)%j = (c(258)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(878),h0tab(:,878),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZu,m3h12x3(:,94),heltab2x36(:,:,827))
  call Hloop_Q_A(ntryL,G0H3(40),19,nMT,G1H3(34),n2h3(101))
  Gcoeff(:)%j = (c(251)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(879),h0tab(:,879),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZd,m3h12x3(:,95),heltab2x36(:,:,828))
  call Hloop_A_Q(ntryL,G0H3(40),19,nMB,G1H3(18),n2h3(102))
  Gcoeff(:)%j = (c(251)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(880),h0tab(:,880),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZd,m3h12x3(:,96),heltab2x36(:,:,829))
  call Hloop_Q_A(ntryL,G0H3(40),19,nMB,G1H3(192),n2h3(103))
  Gcoeff(:)%j = (-(c(146)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(881),h0tab(:,881),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(54),m3h12x3(:,97),heltab2x36(:,:,830))
  Gcoeff(:)%j = (-(c(146)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(882),h0tab(:,882),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(80),m3h12x3(:,98),heltab2x36(:,:,831))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(883),h0tab(:,883),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(70),m3h12x3(:,99),heltab2x36(:,:,832))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(884),h0tab(:,884),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(74),m3h12x3(:,100),heltab2x36(:,:,833))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(885),h0tab(:,885),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(191),m3h12x3(:,101),heltab2x36(:,:,834))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(886),h0tab(:,886),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(85),m3h12x3(:,102),heltab2x36(:,:,835))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(887),h0tab(:,887),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,11),G1H3(91),m3h12x3(:,103),heltab2x36(:,:,836))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(888),h0tab(:,888),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(97),m3h12x3(:,104),heltab2x36(:,:,837))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(889),h0tab(:,889),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,11),G1H3(189),m3h12x3(:,105),heltab2x36(:,:,838))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(890),h0tab(:,890),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(102),m3h12x3(:,106),heltab2x36(:,:,839))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(891),h0tab(:,891),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,6),G1H3(92),m3h12x3(:,107),heltab2x36(:,:,840))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(892),h0tab(:,892),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(67),m3h12x3(:,108),heltab2x36(:,:,841))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(893),h0tab(:,893),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,6),G1H3(106),m3h12x3(:,109),heltab2x36(:,:,842))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(894),h0tab(:,894),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(162),m3h12x3(:,110),heltab2x36(:,:,843))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(895),h0tab(:,895),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(48),m3h12x3(:,111),heltab2x36(:,:,844))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(896),h0tab(:,896),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(99),m3h12x3(:,112),heltab2x36(:,:,845))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(897),h0tab(:,897),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(177),m3h12x3(:,113),heltab2x36(:,:,846))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(898),h0tab(:,898),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(178),m3h12x3(:,114),heltab2x36(:,:,847))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(899),h0tab(:,899),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,115),heltab2x36(:,:,848))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(900),h0tab(:,900),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,11),G0H3(41),m3h12x3(:,116),heltab2x36(:,:,849))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(901),h0tab(:,901),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,6),G0H3(42),m3h12x3(:,117),heltab2x36(:,:,850))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(902),h0tab(:,902),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,6),G0H3(43),m3h12x3(:,118),heltab2x36(:,:,851))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(903),h0tab(:,903),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,6),G0H3(44),m3h12x3(:,119),heltab2x36(:,:,852))
  Gcoeff(:)%j = (c(158)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(904),h0tab(:,904),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(45),m3h12x3(:,120),heltab2x36(:,:,853))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(905),h0tab(:,905),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(46),m3h12x3(:,121),heltab2x36(:,:,854))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(906),h0tab(:,906),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(47),m3h12x3(:,122),heltab2x36(:,:,855))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(907),h0tab(:,907),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(48),m3h12x3(:,123),heltab2x36(:,:,856))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(908),h0tab(:,908),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(49),m3h12x3(:,124),heltab2x36(:,:,857))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(909),h0tab(:,909),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(179),m3h12x3(:,125),heltab2x36(:,:,858))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(910),h0tab(:,910),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(182),m3h12x3(:,126),heltab2x36(:,:,859))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(911),h0tab(:,911),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(183),m3h12x3(:,127),heltab2x36(:,:,860))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(912),h0tab(:,912),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(184),m3h12x3(:,128),heltab2x36(:,:,861))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(913),h0tab(:,913),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(195),m3h12x3(:,129),heltab2x36(:,:,862))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(914),h0tab(:,914),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(186),m3h12x3(:,130),heltab2x36(:,:,863))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(915),h0tab(:,915),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(187),m3h12x3(:,131),heltab2x36(:,:,864))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(916),h0tab(:,916),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(197),m3h12x3(:,132),heltab2x36(:,:,865))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(917),h0tab(:,917),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(198),m3h12x3(:,133),heltab2x36(:,:,866))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(918),h0tab(:,918),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,11),G0H3(50),m3h12x3(:,134),heltab2x36(:,:,867))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(919),h0tab(:,919),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,11),G0H3(51),m3h12x3(:,135),heltab2x36(:,:,868))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(920),h0tab(:,920),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,6),G0H3(52),m3h12x3(:,136),heltab2x36(:,:,869))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(921),h0tab(:,921),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,6),G0H3(53),m3h12x3(:,137),heltab2x36(:,:,870))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(922),h0tab(:,922),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(54),m3h12x3(:,138),heltab2x36(:,:,871))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(923),h0tab(:,923),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(55),m3h12x3(:,139),heltab2x36(:,:,872))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(924),h0tab(:,924),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(56),m3h12x3(:,140),heltab2x36(:,:,873))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(925),h0tab(:,925),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(57),m3h12x3(:,141),heltab2x36(:,:,874))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(926),h0tab(:,926),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(58),m3h12x3(:,142),heltab2x36(:,:,875))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(927),h0tab(:,927),[25,2,4],[0,nMZ,nMZ],3,1,wf18(:,6))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf18(:,6),G0H2(1),ngZd,m3h18x2(:,5),heltab2x36(:,:,876))
  call Hloop_A_Q(ntryL,G0H2(1),25,0,G1H2(5),n2h2(80))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(928),h0tab(:,928),[25,2,4],[0,nMW,nMW],3,1,wf18(:,6))
  call Hloop_WA_Q(ntryL,G0H36(1),wf18(:,6),G0H2(1),m3h18x2(:,6),heltab2x36(:,:,877))
  call Hloop_A_Q(ntryL,G0H2(1),25,0,G1H2(6),n2h2(81))
  Gcoeff(:)%j = (-(c(253)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(929),h0tab(:,929),[19,4,8],[nML,nML,nML],3,1,wf12(:,12))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,143),heltab2x36(:,:,878))
  call Hloop_A_Q(ntryL,G0H3(59),19,nML,G1H3(199),n2h3(104))
  Gcoeff(:)%j = (-(c(253)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(930),h0tab(:,930),[19,4,8],[nML,nML,nML],3,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,144),heltab2x36(:,:,879))
  call Hloop_Q_A(ntryL,G0H3(59),19,nML,G1H3(202),n2h3(105))
  Gcoeff(:)%j = (c(256)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(931),h0tab(:,931),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,12))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,145),heltab2x36(:,:,880))
  call Hloop_A_Q(ntryL,G0H3(59),19,nMT,G1H3(190),n2h3(106))
  Gcoeff(:)%j = (c(256)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(932),h0tab(:,932),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,146),heltab2x36(:,:,881))
  call Hloop_Q_A(ntryL,G0H3(59),19,nMT,G1H3(6),n2h3(107))
  Gcoeff(:)%j = (-(c(249)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(933),h0tab(:,933),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,12))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,147),heltab2x36(:,:,882))
  call Hloop_A_Q(ntryL,G0H3(59),19,nMB,G1H3(205),n2h3(108))
  Gcoeff(:)%j = (-(c(249)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(934),h0tab(:,934),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,148),heltab2x36(:,:,883))
  call Hloop_Q_A(ntryL,G0H3(59),19,nMB,G1H3(206),n2h3(109))
  Gcoeff(:)%j = (c(254)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(935),h0tab(:,935),[19,4,8],[nML,nML,nML],3,1,wf12(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,7),G0H3(59),ngZl,m3h12x3(:,149),heltab2x36(:,:,884))
  call Hloop_A_Q(ntryL,G0H3(59),19,nML,G1H3(207),n2h3(110))
  Gcoeff(:)%j = (c(254)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(936),h0tab(:,936),[19,4,8],[nML,nML,nML],3,1,wf12(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(59),ngZl,m3h12x3(:,150),heltab2x36(:,:,885))
  call Hloop_Q_A(ntryL,G0H3(59),19,nML,G1H3(210),n2h3(111))
  Gcoeff(:)%j = (c(258)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(937),h0tab(:,937),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,7),G0H3(59),ngZu,m3h12x3(:,151),heltab2x36(:,:,886))
  call Hloop_A_Q(ntryL,G0H3(59),19,nMT,G1H3(211),n2h3(112))
  Gcoeff(:)%j = (c(258)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(938),h0tab(:,938),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(59),ngZu,m3h12x3(:,152),heltab2x36(:,:,887))
  call Hloop_Q_A(ntryL,G0H3(59),19,nMT,G1H3(212),n2h3(113))
  Gcoeff(:)%j = (c(251)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(939),h0tab(:,939),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,7),G0H3(59),ngZd,m3h12x3(:,153),heltab2x36(:,:,888))
  call Hloop_A_Q(ntryL,G0H3(59),19,nMB,G1H3(215),n2h3(114))
  Gcoeff(:)%j = (c(251)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(940),h0tab(:,940),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(59),ngZd,m3h12x3(:,154),heltab2x36(:,:,889))
  call Hloop_Q_A(ntryL,G0H3(59),19,nMB,G1H3(216),n2h3(115))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(941),h0tab(:,941),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(217),m3h12x3(:,155),heltab2x36(:,:,890))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(942),h0tab(:,942),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(220),m3h12x3(:,156),heltab2x36(:,:,891))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(943),h0tab(:,943),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(221),m3h12x3(:,157),heltab2x36(:,:,892))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(944),h0tab(:,944),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(222),m3h12x3(:,158),heltab2x36(:,:,893))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(945),h0tab(:,945),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(225),m3h12x3(:,159),heltab2x36(:,:,894))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(946),h0tab(:,946),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(7),m3h12x3(:,160),heltab2x36(:,:,895))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(947),h0tab(:,947),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,12),G1H3(226),m3h12x3(:,161),heltab2x36(:,:,896))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(948),h0tab(:,948),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(229),m3h12x3(:,162),heltab2x36(:,:,897))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(949),h0tab(:,949),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,12),G1H3(108),m3h12x3(:,163),heltab2x36(:,:,898))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(950),h0tab(:,950),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(230),m3h12x3(:,164),heltab2x36(:,:,899))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(951),h0tab(:,951),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,7),G1H3(233),m3h12x3(:,165),heltab2x36(:,:,900))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(952),h0tab(:,952),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(113),m3h12x3(:,166),heltab2x36(:,:,901))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(953),h0tab(:,953),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,7),G1H3(234),m3h12x3(:,167),heltab2x36(:,:,902))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(954),h0tab(:,954),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(237),m3h12x3(:,168),heltab2x36(:,:,903))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(955),h0tab(:,955),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(118),m3h12x3(:,169),heltab2x36(:,:,904))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(956),h0tab(:,956),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(238),m3h12x3(:,170),heltab2x36(:,:,905))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(957),h0tab(:,957),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(241),m3h12x3(:,171),heltab2x36(:,:,906))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(958),h0tab(:,958),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(123),m3h12x3(:,172),heltab2x36(:,:,907))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(959),h0tab(:,959),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,12),G0H3(59),m3h12x3(:,173),heltab2x36(:,:,908))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(960),h0tab(:,960),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,12),G0H3(60),m3h12x3(:,174),heltab2x36(:,:,909))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(961),h0tab(:,961),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(61),m3h12x3(:,175),heltab2x36(:,:,910))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(962),h0tab(:,962),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(62),m3h12x3(:,176),heltab2x36(:,:,911))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(963),h0tab(:,963),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(63),m3h12x3(:,177),heltab2x36(:,:,912))
  Gcoeff(:)%j = (-(c(160)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(964),h0tab(:,964),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(64),m3h12x3(:,178),heltab2x36(:,:,913))
  Gcoeff(:)%j = (c(160)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(965),h0tab(:,965),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(65),m3h12x3(:,179),heltab2x36(:,:,914))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(966),h0tab(:,966),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(66),m3h12x3(:,180),heltab2x36(:,:,915))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(967),h0tab(:,967),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(67),m3h12x3(:,181),heltab2x36(:,:,916))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(968),h0tab(:,968),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(68),m3h12x3(:,182),heltab2x36(:,:,917))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(969),h0tab(:,969),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(242),m3h12x3(:,183),heltab2x36(:,:,918))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(970),h0tab(:,970),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(245),m3h12x3(:,184),heltab2x36(:,:,919))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(971),h0tab(:,971),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(246),m3h12x3(:,185),heltab2x36(:,:,920))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(972),h0tab(:,972),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(247),m3h12x3(:,186),heltab2x36(:,:,921))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(973),h0tab(:,973),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(248),m3h12x3(:,187),heltab2x36(:,:,922))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(974),h0tab(:,974),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(249),m3h12x3(:,188),heltab2x36(:,:,923))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(975),h0tab(:,975),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(250),m3h12x3(:,189),heltab2x36(:,:,924))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(976),h0tab(:,976),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(251),m3h12x3(:,190),heltab2x36(:,:,925))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(977),h0tab(:,977),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(252),m3h12x3(:,191),heltab2x36(:,:,926))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(978),h0tab(:,978),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,12),G0H3(69),m3h12x3(:,192),heltab2x36(:,:,927))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(979),h0tab(:,979),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,12),G0H3(70),m3h12x3(:,193),heltab2x36(:,:,928))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(980),h0tab(:,980),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(71),m3h12x3(:,194),heltab2x36(:,:,929))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(981),h0tab(:,981),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(72),m3h12x3(:,195),heltab2x36(:,:,930))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(982),h0tab(:,982),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(73),m3h12x3(:,196),heltab2x36(:,:,931))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(983),h0tab(:,983),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(74),m3h12x3(:,197),heltab2x36(:,:,932))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(984),h0tab(:,984),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(75),m3h12x3(:,198),heltab2x36(:,:,933))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(985),h0tab(:,985),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(76),m3h12x3(:,199),heltab2x36(:,:,934))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(986),h0tab(:,986),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(77),m3h12x3(:,200),heltab2x36(:,:,935))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(987),h0tab(:,987),[26,1,4],[0,nMZ,nMZ],3,1,wf18(:,8))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf18(:,8),G0H2(1),ngZu,m3h18x2(:,7),heltab2x36(:,:,936))
  call Hloop_Q_A(ntryL,G0H2(1),26,0,G1H2(7),n2h2(82))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(988),h0tab(:,988),[26,1,4],[0,nMW,nMW],3,1,wf18(:,8))
  call Hloop_WQ_A(ntryL,G0H36(1),wf18(:,8),G0H2(1),m3h18x2(:,8),heltab2x36(:,:,937))
  call Hloop_Q_A(ntryL,G0H2(1),26,0,G1H2(8),n2h2(83))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(989),h0tab(:,989),[21,2,8],[0,0,0],3,1,wf6(:,27))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,27),G0H6(13),m3h6x6(:,27),heltab2x36(:,:,938))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(990),h0tab(:,990),[21,2,8],[nMZ,0,0],3,1,wf6(:,27))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,27),G0H6(14),ngZd,m3h6x6(:,28),heltab2x36(:,:,939))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(991),h0tab(:,991),[21,2,8],[nMW,0,0],3,1,wf6(:,27))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,27),G0H6(15),m3h6x6(:,29),heltab2x36(:,:,940))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(992),h0tab(:,992),[21,2,8],[0,0,0],3,1,wf6(:,27))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,27),G0H6(16),m3h6x6(:,30),heltab2x36(:,:,941))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(993),h0tab(:,993),[21,2,8],[0,nMW,nMW],3,1,wf6(:,27))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,27),G0H6(17),m3h6x6(:,31),heltab2x36(:,:,942))
  call Hloop_A_Q(ntryL,G0H6(17),21,0,G1H6(10),n2h6(147))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(994),h0tab(:,994),[22,1,8],[0,0,0],3,1,wf6(:,23))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,23),G0H6(17),m3h6x6(:,32),heltab2x36(:,:,943))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(995),h0tab(:,995),[22,1,8],[nMZ,0,0],3,1,wf6(:,23))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,23),G0H6(18),ngZu,m3h6x6(:,33),heltab2x36(:,:,944))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(996),h0tab(:,996),[22,1,8],[nMW,0,0],3,1,wf6(:,23))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,23),G0H6(19),m3h6x6(:,34),heltab2x36(:,:,945))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(997),h0tab(:,997),[22,1,8],[0,0,0],3,1,wf6(:,23))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,23),G0H6(20),m3h6x6(:,35),heltab2x36(:,:,946))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(998),h0tab(:,998),[22,1,8],[0,nMW,nMW],3,1,wf6(:,23))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,23),G0H6(21),m3h6x6(:,36),heltab2x36(:,:,947))
  call Hloop_Q_A(ntryL,G0H6(21),22,0,G1H6(13),n2h6(148))
  Gcoeff(:)%j = (-(c(160)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(999),h0tab(:,999),[28,1,2],[0,0,nMW],3,1,wf9(:,9))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,9),G0H4(58),m3h9x4(:,99),heltab2x36(:,:,948))
  Gcoeff(:)%j = (c(158)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1000),h0tab(:,1000),[28,1,2],[nMW,0,0],3,1,wf9(:,9))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,9),G0H4(59),m3h9x4(:,100),heltab2x36(:,:,949))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1001),h0tab(:,1001),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,9))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,9),G0H4(60),m3h9x4(:,101),heltab2x36(:,:,950))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1002),h0tab(:,1002),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,9))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,9),G0H4(61),m3h9x4(:,102),heltab2x36(:,:,951))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1003),h0tab(:,1003),[28,1,2],[0,0,0],3,1,wf9(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(62),m3h9x4(:,103),heltab2x36(:,:,952))
  call Hloop_Q_A(ntryL,G0H4(62),28,0,G1H4(46),n2h4(11))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1004),h0tab(:,1004),[28,1,2],[0,nMZ,0],3,1,wf9(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(62),m3h9x4(:,104),heltab2x36(:,:,953))
  call Hloop_Q_A(ntryL,G0H4(62),28,0,G1H4(47),n2h4(12))
  Gcoeff(:)%j = (-(c(119)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1005),h0tab(:,1005),[28,1,2],[0,0,0],3,1,wf9(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(62),m3h9x4(:,105),heltab2x36(:,:,954))
  call Hloop_Q_A(ntryL,G0H4(62),28,0,G1H4(48),n2h4(13))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1006),h0tab(:,1006),[28,1,2],[0,0,nMW],3,1,wf9(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(49),m3h9x4(:,106),heltab2x36(:,:,955))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1007),h0tab(:,1007),[28,1,2],[nMW,0,0],3,1,wf9(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(50),m3h9x4(:,107),heltab2x36(:,:,956))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1008),h0tab(:,1008),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(51),m3h9x4(:,108),heltab2x36(:,:,957))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1009),h0tab(:,1009),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(52),m3h9x4(:,109),heltab2x36(:,:,958))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1010),h0tab(:,1010),[28,1,2],[0,0,nMW],3,1,wf9(:,10))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,10),G0H4(62),m3h9x4(:,110),heltab2x36(:,:,959))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1011),h0tab(:,1011),[28,1,2],[nMW,0,0],3,1,wf9(:,10))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,10),G0H4(63),m3h9x4(:,111),heltab2x36(:,:,960))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1012),h0tab(:,1012),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,10))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,10),G0H4(64),m3h9x4(:,112),heltab2x36(:,:,961))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1013),h0tab(:,1013),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,10))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,10),G0H4(65),m3h9x4(:,113),heltab2x36(:,:,962))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1014),h0tab(:,1014),[28,1,2],[0,0,0],3,1,wf9(:,12))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(66),m3h9x4(:,114),heltab2x36(:,:,963))
  call Hloop_Q_A(ntryL,G0H4(66),28,0,G1H4(53),n2h4(14))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1015),h0tab(:,1015),[28,1,2],[0,nMZ,0],3,1,wf9(:,12))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(66),m3h9x4(:,115),heltab2x36(:,:,964))
  call Hloop_Q_A(ntryL,G0H4(66),28,0,G1H4(54),n2h4(15))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1016),h0tab(:,1016),[28,1,2],[0,0,0],3,1,wf9(:,12))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(66),m3h9x4(:,116),heltab2x36(:,:,965))
  call Hloop_Q_A(ntryL,G0H4(66),28,0,G1H4(55),n2h4(16))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1017),h0tab(:,1017),[28,1,2],[0,0,nMW],3,1,wf9(:,12))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(56),m3h9x4(:,117),heltab2x36(:,:,966))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1018),h0tab(:,1018),[28,1,2],[nMW,0,0],3,1,wf9(:,12))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(57),m3h9x4(:,118),heltab2x36(:,:,967))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1019),h0tab(:,1019),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,12))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(58),m3h9x4(:,119),heltab2x36(:,:,968))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1020),h0tab(:,1020),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,12))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(59),m3h9x4(:,120),heltab2x36(:,:,969))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1021),h0tab(:,1021),[25,2,4],[0,nMZ,nMZ],3,1,wf18(:,10))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf18(:,10),G0H2(1),ngZd,m3h18x2(:,9),heltab2x36(:,:,970))
  call Hloop_A_Q(ntryL,G0H2(1),25,0,G1H2(9),n2h2(84))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1022),h0tab(:,1022),[25,2,4],[0,nMW,nMW],3,1,wf18(:,10))
  call Hloop_WA_Q(ntryL,G0H36(1),wf18(:,10),G0H2(1),m3h18x2(:,10),heltab2x36(:,:,971))
  call Hloop_A_Q(ntryL,G0H2(1),25,0,G1H2(10),n2h2(85))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1023),h0tab(:,1023),[26,1,4],[0,nMZ,nMZ],3,1,wf18(:,12))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf18(:,12),G0H2(1),ngZu,m3h18x2(:,11),heltab2x36(:,:,972))
  call Hloop_Q_A(ntryL,G0H2(1),26,0,G1H2(11),n2h2(86))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1024),h0tab(:,1024),[26,1,4],[0,nMW,nMW],3,1,wf18(:,12))
  call Hloop_WQ_A(ntryL,G0H36(1),wf18(:,12),G0H2(1),m3h18x2(:,12),heltab2x36(:,:,973))
  call Hloop_Q_A(ntryL,G0H2(1),26,0,G1H2(12),n2h2(87))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1025),h0tab(:,1025),[28,1,2],[0,0,nMW],3,1,wf9(:,13))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,13),G0H4(66),m3h9x4(:,121),heltab2x36(:,:,974))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1026),h0tab(:,1026),[28,1,2],[nMW,0,0],3,1,wf9(:,13))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,13),G0H4(67),m3h9x4(:,122),heltab2x36(:,:,975))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1027),h0tab(:,1027),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,13))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,13),G0H4(68),m3h9x4(:,123),heltab2x36(:,:,976))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1028),h0tab(:,1028),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,13))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,13),G0H4(69),m3h9x4(:,124),heltab2x36(:,:,977))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1029),h0tab(:,1029),[28,1,2],[0,0,0],3,1,wf9(:,15))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(70),m3h9x4(:,125),heltab2x36(:,:,978))
  call Hloop_Q_A(ntryL,G0H4(70),28,0,G1H4(60),n2h4(17))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1030),h0tab(:,1030),[28,1,2],[0,nMZ,0],3,1,wf9(:,15))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(70),m3h9x4(:,126),heltab2x36(:,:,979))
  call Hloop_Q_A(ntryL,G0H4(70),28,0,G1H4(61),n2h4(18))
  Gcoeff(:)%j = (c(119)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1031),h0tab(:,1031),[28,1,2],[0,0,0],3,1,wf9(:,15))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(70),m3h9x4(:,127),heltab2x36(:,:,980))
  call Hloop_Q_A(ntryL,G0H4(70),28,0,G1H4(62),n2h4(19))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1032),h0tab(:,1032),[28,1,2],[0,0,nMW],3,1,wf9(:,15))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(63),m3h9x4(:,128),heltab2x36(:,:,981))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1033),h0tab(:,1033),[28,1,2],[nMW,0,0],3,1,wf9(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(64),m3h9x4(:,129),heltab2x36(:,:,982))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1034),h0tab(:,1034),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,15))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(65),m3h9x4(:,130),heltab2x36(:,:,983))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1035),h0tab(:,1035),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(66),m3h9x4(:,131),heltab2x36(:,:,984))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1036),h0tab(:,1036),[28,1,2],[0,0,nMW],3,1,wf9(:,14))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,14),G0H4(70),m3h9x4(:,132),heltab2x36(:,:,985))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1037),h0tab(:,1037),[28,1,2],[nMW,0,0],3,1,wf9(:,14))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,14),G0H4(71),m3h9x4(:,133),heltab2x36(:,:,986))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1038),h0tab(:,1038),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,14))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,14),G0H4(72),m3h9x4(:,134),heltab2x36(:,:,987))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1039),h0tab(:,1039),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,14))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,14),G0H4(73),m3h9x4(:,135),heltab2x36(:,:,988))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1040),h0tab(:,1040),[28,1,2],[0,0,0],3,1,wf9(:,16))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(74),m3h9x4(:,136),heltab2x36(:,:,989))
  call Hloop_Q_A(ntryL,G0H4(74),28,0,G1H4(67),n2h4(20))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1041),h0tab(:,1041),[28,1,2],[0,nMZ,0],3,1,wf9(:,16))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(74),m3h9x4(:,137),heltab2x36(:,:,990))
  call Hloop_Q_A(ntryL,G0H4(74),28,0,G1H4(68),n2h4(21))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1042),h0tab(:,1042),[28,1,2],[0,0,0],3,1,wf9(:,16))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(74),m3h9x4(:,138),heltab2x36(:,:,991))
  call Hloop_Q_A(ntryL,G0H4(74),28,0,G1H4(69),n2h4(22))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1043),h0tab(:,1043),[28,1,2],[0,0,nMW],3,1,wf9(:,16))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(70),m3h9x4(:,139),heltab2x36(:,:,992))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1044),h0tab(:,1044),[28,1,2],[nMW,0,0],3,1,wf9(:,16))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(71),m3h9x4(:,140),heltab2x36(:,:,993))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1045),h0tab(:,1045),[28,1,2],[nMZ,0,nMW],3,1,wf9(:,16))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(72),m3h9x4(:,141),heltab2x36(:,:,994))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1046),h0tab(:,1046),[28,1,2],[nMW,0,nMZ],3,1,wf9(:,16))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(73),m3h9x4(:,142),heltab2x36(:,:,995))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(45),[G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(252),[G1H3(251),G1H3(250),G1H3(249),G1H3(198),G1H3(197) &
    ,G1H3(187),G1H3(186),G1H3(68),G1H3(57),G1H3(84),G1H3(50),G1H3(8),G1H3(39),G0H3(20),G0H3(19),G0H3(5),G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(37),[G1H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(139),[G1H3(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(149),[G1H3(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(159),[G1H3(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(210),[G1H3(202),G1H3(30),G1H3(101),G1H3(107),G1H3(38) &
    ,G1H3(136),G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(190),G1H3(47),G1H3(83),G1H3(4),G1H3(51) &
    ,G1H3(137),G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(216),[G1H3(206),G1H3(192),G1H3(88),G1H3(65),G1H3(46) &
    ,G1H3(143),G1H3(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(246),[G1H3(183),G1H3(75),G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(248),[G1H3(247),G1H3(245),G1H3(242),G1H3(195),G1H3(184) &
    ,G1H3(182),G1H3(179),G1H3(56),G1H3(40),G1H3(33),G1H3(31),G1H3(172),G1H3(167),G0H3(18),G0H3(17),G0H3(9),G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(113),G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(115),[G1H12(111),G1H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G1H12(112),G1H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(119),[G1H12(36),G0H12(66),G0H12(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(126),[G1H12(41),G0H12(69),G0H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(93),[G1H12(46),G0H12(70),G0H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(124),[G1H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(15),[G1H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(225),[G1H3(217),G1H3(191),G1H3(54),G1H3(169),G1H3(112) &
    ,G0H3(6),G0H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(220),G1H3(85),G1H3(80),G1H3(170),G1H3(163) &
    ,G0H3(7),G0H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(241),[G1H3(118),G1H3(177),G1H3(48),G1H3(24),G1H3(62) &
    ,G0H3(15),G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(238),G1H3(178),G1H3(99),G1H3(64),G1H3(1) &
    ,G0H3(16),G0H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G0H4(28),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G0H4(29),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G0H4(35),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G0H4(36),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G0H4(37),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G0H4(38),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G0H4(39),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G0H4(40),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(121),[G0H12(64),G0H12(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(122),[G0H12(65),G0H12(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(123),[G0H12(67),G0H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(125),[G0H12(68),G0H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(110),[G0H12(71),G0H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(63),G1H4(56),G1H4(49),G1H4(42),G0H4(70) &
    ,G0H4(66),G0H4(62),G0H4(58),G0H4(54),G0H4(50),G0H4(24),G0H4(20),G0H4(15),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(64),G1H4(57),G1H4(50),G1H4(43),G0H4(71) &
    ,G0H4(67),G0H4(63),G0H4(59),G0H4(55),G0H4(51),G0H4(25),G0H4(21),G0H4(16),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(65),G1H4(58),G1H4(51),G1H4(44),G0H4(72) &
    ,G0H4(68),G0H4(64),G0H4(60),G0H4(56),G0H4(52),G0H4(26),G0H4(22),G0H4(18),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(66),G1H4(59),G1H4(52),G1H4(45),G0H4(73) &
    ,G0H4(69),G0H4(65),G0H4(61),G0H4(57),G0H4(53),G0H4(27),G0H4(23),G0H4(19),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(107),[G0H12(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(118),[G0H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G0H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(109),[G0H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G0H12(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G0H12(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G0H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G0H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G0H12(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G0H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G0H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G0H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G0H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G0H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G0H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(207),[G1H3(199),G1H3(93),G1H3(89),G1H3(49),G1H3(42) &
    ,G1H3(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(212),[G1H3(6),G1H3(34),G1H3(175),G1H3(110),G1H3(12) &
    ,G1H3(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(215),[G1H3(205),G1H3(18),G1H3(87),G1H3(111),G1H3(32) &
    ,G1H3(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(234),[G1H3(233),G1H3(108),G1H3(226),G1H3(106),G1H3(92) &
    ,G1H3(189),G1H3(91),G1H3(126),G1H3(122),G1H3(116),G1H3(171),G0H3(13),G0H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(237),[G1H3(113),G1H3(230),G1H3(229),G1H3(162),G1H3(67) &
    ,G1H3(102),G1H3(97),G1H3(55),G1H3(125),G1H3(117),G1H3(115),G0H3(14),G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(148),[G1H3(147),G0H3(63),G0H3(62),G0H3(60),G0H3(59) &
    ,G0H3(44),G0H3(43),G0H3(41),G0H3(40),G0H3(25),G0H3(24),G0H3(22),G0H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(150),[G0H3(67),G0H3(64),G0H3(48),G0H3(45),G0H3(29) &
    ,G0H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(153),[G0H3(68),G0H3(65),G0H3(49),G0H3(46),G0H3(30) &
    ,G0H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(155),[G0H3(71),G0H3(69),G0H3(52),G0H3(50),G0H3(33) &
    ,G0H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(156),[G0H3(72),G0H3(70),G0H3(53),G0H3(51),G0H3(34) &
    ,G0H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(161),[G1H3(160),G0H3(77),G0H3(76),G0H3(74),G0H3(73) &
    ,G0H3(58),G0H3(57),G0H3(55),G0H3(54),G0H3(39),G0H3(38),G0H3(36),G0H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(221),[G1H3(70),G1H3(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(222),[G1H3(74),G1H3(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(61),[G0H3(42),G0H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(66),[G0H3(47),G0H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(75),[G0H3(56),G0H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(181),[G0H12(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(182),[G0H12(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(183),[G0H12(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(184),[G0H12(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(180),[G1H12(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(5),G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(6),G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(208),[G0H12(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(209),[G0H12(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(210),[G0H12(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(211),[G0H12(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(207),[G1H12(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(7),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(8),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(8),[G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(12),[G0H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(234),[G1H12(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(241),[G1H12(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(67),G1H4(62),G1H4(60),G1H4(55),G1H4(53) &
    ,G1H4(48),G1H4(46),G1H4(41),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(61),G1H4(54),G1H4(47),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(20),[G0H6(17)])
  call Hloop_AZ_Q(ntryL,G1H6(43),ex4(:),G1H2(5),ngZd,m3h3x2(:,60),heltab2x6(:,:,210))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(21),n2h2(88))
  call Hloop_AZ_Q(ntryL,G1H6(45),ex4(:),G1H2(1),ngZu,m3h3x2(:,61),heltab2x6(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(23),n2h2(89))
  call Hloop_VT_S(ntryL,G1H3(252),19,ex3(:),4,G2H3(22),m3h1x3(:,106),heltab2x3(:,:,491))
  call Hloop_UV_W(ntryL,G1H3(37),19,ex4(:),8,G2H1(29),m3h3x1(:,386),heltab2x3(:,:,492))
  call Hloop_QZ_A(ntryL,G1H3(109),ex4(:),G1H1(11),ngZl,m3h3x1(:,387),heltab2x3(:,:,493))
  call Hloop_Q_A(ntryL,G1H1(11),27,nML,G2H1(30),n2h1(164))
  call Hloop_AZ_Q(ntryL,G1H3(114),ex4(:),G1H1(38),ngZu,m3h3x1(:,388),heltab2x3(:,:,494))
  call Hloop_A_Q(ntryL,G1H1(38),27,nMT,G2H1(31),n2h1(165))
  call Hloop_QZ_A(ntryL,G1H3(119),ex4(:),G1H1(17),ngZd,m3h3x1(:,389),heltab2x3(:,:,495))
  call Hloop_Q_A(ntryL,G1H1(17),27,nMB,G2H1(28),n2h1(166))
  call Hloop_SV_T(ntryL,G1H3(124),19,ex4(:),8,G2H1(27),m3h3x1(:,390),heltab2x3(:,:,496))
  call Hloop_TV_S(ntryL,G1H3(129),19,ex4(:),8,G2H1(40),m3h3x1(:,391),heltab2x3(:,:,497))
  call Hloop_TV_S(ntryL,G1H3(139),19,ex4(:),8,G2H1(42),m3h3x1(:,392),heltab2x3(:,:,498))
  call Hloop_CV_D(ntryL,G1H3(149),19,ex4(:),8,G2H1(43),m3h3x1(:,393),heltab2x3(:,:,499))
  call Hloop_DV_C(ntryL,G1H3(159),19,ex4(:),G2H1(44),m3h3x1(:,394),heltab2x3(:,:,500))
  call Hloop_QS_A(ntryL,G1H3(210),ex3(:),G1H3(251),ngH,m3h1x3(:,107),heltab2x3(:,:,501))
  call Hloop_Q_A(ntryL,G1H3(251),23,nML,G2H3(12),n2h3(116))
  call Hloop_AS_Q(ntryL,G1H3(211),ex3(:),G1H3(250),ngH,m3h1x3(:,108),heltab2x3(:,:,502))
  call Hloop_A_Q(ntryL,G1H3(250),23,nMT,G2H3(25),n2h3(117))
  call Hloop_QS_A(ntryL,G1H3(216),ex3(:),G1H3(249),ngH,m3h1x3(:,109),heltab2x3(:,:,503))
  call Hloop_Q_A(ntryL,G1H3(249),23,nMB,G2H3(15),n2h3(118))
  call Hloop_ST_V(ntryL,G1H3(246),19,ex3(:),4,G2H3(18),m3h1x3(:,110),heltab2x3(:,:,504))
  call Hloop_ST_V(ntryL,G1H3(248),19,ex3(:),4,G2H3(20),m3h1x3(:,111),heltab2x3(:,:,505))
  call Hloop_AW_Q(ntryL,G1H12(27),wf4(:,1),G1H3(198),m3h4x3(:,124),heltab2x12(:,:,319))
  call Hloop_A_Q(ntryL,G1H3(198),23,0,G2H3(5),n2h3(119))
  call Hloop_QW_A(ntryL,G1H12(115),wf4(:,1),G1H3(197),m3h4x3(:,125),heltab2x12(:,:,320))
  call Hloop_Q_A(ntryL,G1H3(197),23,nMB,G2H3(6),n2h3(120))
  call Hloop_AW_Q(ntryL,G1H12(8),wf4(:,1),G1H3(187),m3h4x3(:,126),heltab2x12(:,:,321))
  call Hloop_A_Q(ntryL,G1H3(187),23,nMT,G2H3(19),n2h3(121))
  call Hloop_SV_T(ntryL,G1H12(119),20,wf4(:,1),3,G2H3(26),m3h4x3(:,127),heltab2x12(:,:,322))
  call Hloop_UV_W(ntryL,G1H12(126),20,wf4(:,1),3,G2H3(27),m3h4x3(:,128),heltab2x12(:,:,323))
  call Hloop_UW_V(ntryL,G1H12(93),20,wf4(:,1),3,G2H3(102),m3h4x3(:,129),heltab2x12(:,:,324))
  call Hloop_TV_S(ntryL,G1H12(124),20,wf4(:,1),3,G2H3(105),m3h4x3(:,130),heltab2x12(:,:,325))
  call Hloop_AZ_Q(ntryL,G1H6(15),wf3(:,1),G1H2(6),ngZu,m3h3x2(:,62),heltab2x6(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(6),29,0,G2H2(24),n2h2(90))
  call Hloop_AZ_Q(ntryL,G1H6(26),wf3(:,1),G1H2(2),ngZd,m3h3x2(:,63),heltab2x6(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(2),29,0,G2H2(25),n2h2(91))
  call Hloop_AZ_Q(ntryL,G1H6(37),wf3(:,1),G1H2(7),ngZd,m3h3x2(:,64),heltab2x6(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(7),29,0,G2H2(27),n2h2(92))
  call Hloop_AZ_Q(ntryL,G1H6(1),ex4(:),G1H2(3),ngZd,m3h3x2(:,65),heltab2x6(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(3),29,0,G2H2(28),n2h2(93))
  call Hloop_SS_S(ntryL,G1H3(225),ex3(:),G1H3(186),m3h1x3(:,112),heltab2x3(:,:,506))
  call Hloop_SS_S(ntryL,G1H3(7),ex3(:),G1H3(68),m3h1x3(:,113),heltab2x3(:,:,507))
  call Hloop_VS_V(ntryL,G1H3(241),ex3(:),G1H3(57),m3h1x3(:,114),heltab2x3(:,:,508))
  call Hloop_VS_V(ntryL,G1H3(123),ex3(:),G1H3(84),m3h1x3(:,115),heltab2x3(:,:,509))
  call Hloop_SS_S(ntryL,G1H12(54),ex3(:),G1H12(113),m3h1x12(:,51),heltab2x12(:,:,326))
  call Hloop_SS_S(ntryL,G1H12(55),ex3(:),G1H12(15),m3h1x12(:,52),heltab2x12(:,:,327))
  call Hloop_SS_S(ntryL,G1H12(56),ex3(:),G1H12(111),m3h1x12(:,53),heltab2x12(:,:,328))
  call Hloop_SS_S(ntryL,G1H12(57),ex3(:),G1H12(21),m3h1x12(:,54),heltab2x12(:,:,329))
  call Hloop_VS_V(ntryL,G1H12(58),ex3(:),G1H12(112),m3h1x12(:,55),heltab2x12(:,:,330))
  call Hloop_VS_V(ntryL,G1H12(59),ex3(:),G1H12(31),m3h1x12(:,56),heltab2x12(:,:,331))
  call Hloop_VS_V(ntryL,G1H12(5),ex3(:),G1H12(36),m3h1x12(:,57),heltab2x12(:,:,332))
  call Hloop_VT_S(ntryL,G0H12(4),16,ex3(:),4,G1H12(41),m3h1x12(:,58),heltab2x12(:,:,333))
  call Hloop_VT_S(ntryL,G0H12(80),16,ex3(:),4,G1H12(46),m3h1x12(:,59),heltab2x12(:,:,334))
  call Hloop_ST_V(ntryL,G0H12(7),16,ex3(:),4,G1H12(51),m3h1x12(:,60),heltab2x12(:,:,335))
  call Hloop_ST_V(ntryL,G0H12(73),16,ex3(:),4,G1H12(114),m3h1x12(:,61),heltab2x12(:,:,336))
  call Hloop_SV_T(ntryL,G1H4(22),24,wf4(:,1),3,G2H1(45),m3h4x1(:,1),heltab2x4(:,:,18))
  call Hloop_SV_T(ntryL,G1H4(23),24,wf4(:,1),3,G2H1(46),m3h4x1(:,2),heltab2x4(:,:,19))
  call Hloop_TV_S(ntryL,G1H4(24),24,wf4(:,1),3,G2H1(47),m3h4x1(:,3),heltab2x4(:,:,20))
  call Hloop_TV_S(ntryL,G1H4(25),24,wf4(:,1),3,G2H1(49),m3h4x1(:,4),heltab2x4(:,:,21))
  call Hloop_UV_W(ntryL,G1H4(32),24,wf4(:,1),3,G2H1(50),m3h4x1(:,5),heltab2x4(:,:,22))
  call Hloop_UW_V(ntryL,G1H4(33),24,wf4(:,1),3,G2H1(52),m3h4x1(:,6),heltab2x4(:,:,23))
  call Hloop_UW_V(ntryL,G1H4(34),24,wf4(:,1),3,G2H1(34),m3h4x1(:,7),heltab2x4(:,:,24))
  call Hloop_SV_V(ntryL,G1H4(35),wf4(:,1),G1H1(23),m3h4x1(:,8),heltab2x4(:,:,25))
  call Hloop_SV_V(ntryL,G1H4(36),wf4(:,1),G1H1(57),m3h4x1(:,9),heltab2x4(:,:,26))
  call Hloop_VV_S(ntryL,G1H4(37),wf4(:,1),G1H1(24),m3h4x1(:,10),heltab2x4(:,:,27))
  call Hloop_VV_S(ntryL,G1H4(38),wf4(:,1),G1H1(63),m3h4x1(:,11),heltab2x4(:,:,28))
  call Hloop_VVS_S(ntryL,G0H12(74),wf4(:,1),ex3(:),G0H3(20),m4h4x1x3(:,1),heltab3x12(:,:,1))
  call Hloop_VVS_S(ntryL,G0H12(78),wf4(:,1),ex3(:),G0H3(19),m4h4x1x3(:,2),heltab3x12(:,:,2))
  call Hloop_SSV_V(ntryL,G1H12(60),ex3(:),wf4(:,1),G1H3(50),m4h1x4x3(:,1),heltab3x12(:,:,3))
  call Hloop_SSV_V(ntryL,G1H12(11),ex3(:),wf4(:,1),G1H3(8),m4h1x4x3(:,2),heltab3x12(:,:,4))
  call Hloop_VVS_S(ntryL,G1H12(61),wf4(:,1),ex3(:),G1H3(39),m4h4x1x3(:,3),heltab3x12(:,:,5))
  call Hloop_VVS_S(ntryL,G1H12(17),wf4(:,1),ex3(:),G1H3(44),m4h4x1x3(:,4),heltab3x12(:,:,6))
  call Hloop_VVS_S(ntryL,G1H12(62),wf4(:,1),ex3(:),G1H3(134),m4h4x1x3(:,5),heltab3x12(:,:,7))
  call Hloop_SSV_V(ntryL,G0H12(79),ex3(:),wf4(:,1),G0H3(5),m4h1x4x3(:,3),heltab3x12(:,:,8))
  call Hloop_VV_S(ntryL,G1H12(121),wf4(:,1),G1H3(144),m3h4x3(:,131),heltab2x12(:,:,337))
  call Hloop_VV_S(ntryL,G1H12(122),wf4(:,1),G1H3(154),m3h4x3(:,132),heltab2x12(:,:,338))
  call Hloop_TV_S(ntryL,G1H12(123),20,wf4(:,1),3,G2H3(28),m3h4x3(:,133),heltab2x12(:,:,339))
  call Hloop_UW_V(ntryL,G1H12(125),20,wf4(:,1),3,G2H3(31),m3h4x3(:,134),heltab2x12(:,:,340))
  call Hloop_SV_V(ntryL,G1H12(110),wf4(:,1),G1H3(202),m3h4x3(:,135),heltab2x12(:,:,341))
  call Hloop_SV_V(ntryL,G1H12(63),wf4(:,1),G1H3(30),m3h4x3(:,136),heltab2x12(:,:,342))
  call Hloop_SV_V(ntryL,G1H12(64),wf4(:,1),G1H3(101),m3h4x3(:,137),heltab2x12(:,:,343))
  call Hloop_SV_T(ntryL,G0H12(14),16,wf4(:,1),3,G1H3(107),m3h4x3(:,138),heltab2x12(:,:,344))
  call Hloop_TV_S(ntryL,G0H12(15),16,wf4(:,1),3,G1H3(38),m3h4x3(:,139),heltab2x12(:,:,345))
  call Hloop_UW_V(ntryL,G0H12(19),16,wf4(:,1),3,G1H3(136),m3h4x3(:,140),heltab2x12(:,:,346))
  call Hloop_UV_W(ntryL,G0H12(20),16,wf4(:,1),3,G1H3(21),m3h4x3(:,141),heltab2x12(:,:,347))
  call Hloop_UW_V(ntryL,G0H12(21),16,wf4(:,1),3,G1H3(190),m3h4x3(:,142),heltab2x12(:,:,348))
  call Hloop_VV_S(ntryL,G1H12(65),wf4(:,1),G1H3(47),m3h4x3(:,143),heltab2x12(:,:,349))
  call Hloop_VV_S(ntryL,G1H12(66),wf4(:,1),G1H3(83),m3h4x3(:,144),heltab2x12(:,:,350))
  call Hloop_VV_S(ntryL,G1H12(67),wf4(:,1),G1H3(4),m3h4x3(:,145),heltab2x12(:,:,351))
  call Hloop_VA_Q(ntryL,G1H4(70),ex1(:),G1H2(8),m3h2x2(:,18),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(8),29,0,G2H2(6),n2h2(94))
  call Hloop_WA_Q(ntryL,G1H4(71),ex1(:),G1H2(4),m3h2x2(:,19),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(4),29,0,G2H2(10),n2h2(95))
  call Hloop_ZA_Q(ntryL,G1H4(72),ex1(:),G1H2(5),ngZu,m3h2x2(:,20),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(18),n2h2(96))
  call Hloop_WA_Q(ntryL,G1H4(73),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(22),n2h2(97))
  call Hloop_QW_A(ntryL,G1H12(68),wf4(:,1),G1H3(51),m3h4x3(:,146),heltab2x12(:,:,352))
  call Hloop_Q_A(ntryL,G1H3(51),19,nML,G2H3(55),n2h3(122))
  call Hloop_AW_Q(ntryL,G1H12(69),wf4(:,1),G1H3(137),m3h4x3(:,147),heltab2x12(:,:,353))
  call Hloop_A_Q(ntryL,G1H3(137),19,nMT,G2H3(56),n2h3(123))
  call Hloop_QW_A(ntryL,G1H12(70),wf4(:,1),G1H3(22),m3h4x3(:,148),heltab2x12(:,:,354))
  call Hloop_Q_A(ntryL,G1H3(22),19,nMB,G2H3(34),n2h3(124))
  call Hloop_SV_T(ntryL,G1H12(71),16,wf4(:,1),3,G2H3(37),m3h4x3(:,149),heltab2x12(:,:,355))
  call Hloop_SV_T(ntryL,G1H12(72),16,wf4(:,1),3,G2H3(59),m3h4x3(:,150),heltab2x12(:,:,356))
  call Hloop_CV_D(ntryL,G1H12(73),16,wf4(:,1),3,G2H3(60),m3h4x3(:,151),heltab2x12(:,:,357))
  call Hloop_CV_D(ntryL,G1H12(74),16,wf4(:,1),3,G2H3(32),m3h4x3(:,152),heltab2x12(:,:,358))
  call Hloop_DV_C(ntryL,G1H12(75),16,wf4(:,1),G2H3(11),m3h4x3(:,153),heltab2x12(:,:,359))
  call Hloop_DV_C(ntryL,G1H12(76),16,wf4(:,1),G2H3(7),m3h4x3(:,154),heltab2x12(:,:,360))
  call Hloop_SV_V(ntryL,G1H12(77),wf4(:,1),G1H3(206),m3h4x3(:,155),heltab2x12(:,:,361))
  call Hloop_SV_V(ntryL,G1H12(78),wf4(:,1),G1H3(192),m3h4x3(:,156),heltab2x12(:,:,362))
  call Hloop_SV_T(ntryL,G0H12(25),16,wf4(:,1),3,G1H3(88),m3h4x3(:,157),heltab2x12(:,:,363))
  call Hloop_TV_S(ntryL,G0H12(26),16,wf4(:,1),3,G1H3(65),m3h4x3(:,158),heltab2x12(:,:,364))
  call Hloop_UW_V(ntryL,G0H12(27),16,wf4(:,1),3,G1H3(46),m3h4x3(:,159),heltab2x12(:,:,365))
  call Hloop_UV_W(ntryL,G0H12(28),16,wf4(:,1),3,G1H3(143),m3h4x3(:,160),heltab2x12(:,:,366))
  call Hloop_UW_V(ntryL,G0H12(29),16,wf4(:,1),3,G1H3(59),m3h4x3(:,161),heltab2x12(:,:,367))
  call Hloop_VV_S(ntryL,G1H12(79),wf4(:,1),G1H3(183),m3h4x3(:,162),heltab2x12(:,:,368))
  call Hloop_VV_S(ntryL,G1H12(80),wf4(:,1),G1H3(75),m3h4x3(:,163),heltab2x12(:,:,369))
  call Hloop_VV_S(ntryL,G1H12(81),wf4(:,1),G1H3(78),m3h4x3(:,164),heltab2x12(:,:,370))
  call Hloop_AW_Q(ntryL,G1H12(82),wf4(:,1),G1H3(247),m3h4x3(:,165),heltab2x12(:,:,371))
  call Hloop_A_Q(ntryL,G1H3(247),19,0,G2H3(13),n2h3(125))
  call Hloop_AW_Q(ntryL,G1H12(83),wf4(:,1),G1H3(245),m3h4x3(:,166),heltab2x12(:,:,372))
  call Hloop_A_Q(ntryL,G1H3(245),19,0,G2H3(16),n2h3(126))
  call Hloop_QW_A(ntryL,G1H12(84),wf4(:,1),G1H3(242),m3h4x3(:,167),heltab2x12(:,:,373))
  call Hloop_Q_A(ntryL,G1H3(242),19,0,G2H3(21),n2h3(127))
  call Hloop_QW_A(ntryL,G1H12(85),wf4(:,1),G1H3(195),m3h4x3(:,168),heltab2x12(:,:,374))
  call Hloop_Q_A(ntryL,G1H3(195),19,nML,G2H3(45),n2h3(128))
  call Hloop_AW_Q(ntryL,G1H12(86),wf4(:,1),G1H3(184),m3h4x3(:,169),heltab2x12(:,:,375))
  call Hloop_A_Q(ntryL,G1H3(184),19,0,G2H3(46),n2h3(129))
  call Hloop_AW_Q(ntryL,G1H12(87),wf4(:,1),G1H3(182),m3h4x3(:,170),heltab2x12(:,:,376))
  call Hloop_A_Q(ntryL,G1H3(182),19,nMT,G2H3(47),n2h3(130))
  call Hloop_QW_A(ntryL,G1H12(88),wf4(:,1),G1H3(179),m3h4x3(:,171),heltab2x12(:,:,377))
  call Hloop_Q_A(ntryL,G1H3(179),19,0,G2H3(48),n2h3(131))
  call Hloop_QW_A(ntryL,G1H12(89),wf4(:,1),G1H3(56),m3h4x3(:,172),heltab2x12(:,:,378))
  call Hloop_Q_A(ntryL,G1H3(56),19,nMB,G2H3(49),n2h3(132))
  call Hloop_SV_T(ntryL,G1H12(90),16,wf4(:,1),3,G2H3(43),m3h4x3(:,173),heltab2x12(:,:,379))
  call Hloop_SV_T(ntryL,G1H12(91),16,wf4(:,1),3,G2H3(44),m3h4x3(:,174),heltab2x12(:,:,380))
  call Hloop_TV_S(ntryL,G1H12(92),16,wf4(:,1),3,G2H3(8),m3h4x3(:,175),heltab2x12(:,:,381))
  call Hloop_TV_S(ntryL,G1H12(95),16,wf4(:,1),3,G2H3(9),m3h4x3(:,176),heltab2x12(:,:,382))
  call Hloop_CV_D(ntryL,G1H12(94),16,wf4(:,1),3,G2H3(50),m3h4x3(:,177),heltab2x12(:,:,383))
  call Hloop_CV_D(ntryL,G1H12(96),16,wf4(:,1),3,G2H3(51),m3h4x3(:,178),heltab2x12(:,:,384))
  call Hloop_DV_C(ntryL,G1H12(97),16,wf4(:,1),G2H3(52),m3h4x3(:,179),heltab2x12(:,:,385))
  call Hloop_DV_C(ntryL,G1H12(100),16,wf4(:,1),G2H3(17),m3h4x3(:,180),heltab2x12(:,:,386))
  call Hloop_UW_V(ntryL,G1H12(99),16,wf4(:,1),3,G2H3(10),m3h4x3(:,181),heltab2x12(:,:,387))
  call Hloop_UW_V(ntryL,G1H12(101),16,wf4(:,1),3,G2H3(1),m3h4x3(:,182),heltab2x12(:,:,388))
  call Hloop_SV_V(ntryL,G1H12(102),wf4(:,1),G1H3(40),m3h4x3(:,183),heltab2x12(:,:,389))
  call Hloop_SV_V(ntryL,G1H12(103),wf4(:,1),G1H3(33),m3h4x3(:,184),heltab2x12(:,:,390))
  call Hloop_SV_T(ntryL,G0H12(32),16,wf4(:,1),3,G1H3(31),m3h4x3(:,185),heltab2x12(:,:,391))
  call Hloop_TV_S(ntryL,G0H12(33),16,wf4(:,1),3,G1H3(172),m3h4x3(:,186),heltab2x12(:,:,392))
  call Hloop_VV_S(ntryL,G0H12(34),wf4(:,1),G0H3(2),m3h4x3(:,187),heltab2x12(:,:,393))
  call Hloop_VV_S(ntryL,G0H12(35),wf4(:,1),G0H3(18),m3h4x3(:,188),heltab2x12(:,:,394))
  call Hloop_SV_V(ntryL,G0H12(36),wf4(:,1),G0H3(17),m3h4x3(:,189),heltab2x12(:,:,395))
  call Hloop_UW_V(ntryL,G0H12(37),16,wf4(:,1),3,G1H3(167),m3h4x3(:,190),heltab2x12(:,:,396))
  call Hloop_UV_W(ntryL,G0H12(38),16,wf4(:,1),3,G1H3(217),m3h4x3(:,191),heltab2x12(:,:,397))
  call Hloop_UW_V(ntryL,G0H12(39),16,wf4(:,1),3,G1H3(191),m3h4x3(:,192),heltab2x12(:,:,398))
  call Hloop_VV_S(ntryL,G1H12(104),wf4(:,1),G1H3(54),m3h4x3(:,193),heltab2x12(:,:,399))
  call Hloop_VV_S(ntryL,G1H12(105),wf4(:,1),G1H3(169),m3h4x3(:,194),heltab2x12(:,:,400))
  call Hloop_VV_S(ntryL,G1H12(106),wf4(:,1),G1H3(112),m3h4x3(:,195),heltab2x12(:,:,401))
  call Hloop_QW_A(ntryL,G1H12(2),wf4(:,1),G1H3(220),m3h4x3(:,196),heltab2x12(:,:,402))
  call Hloop_Q_A(ntryL,G1H3(220),23,nML,G2H3(2),n2h3(133))
  call Hloop_SV_T(ntryL,G1H12(107),20,wf4(:,1),3,G2H3(3),m3h4x3(:,197),heltab2x12(:,:,403))
  call Hloop_TV_S(ntryL,G1H12(118),20,wf4(:,1),3,G2H3(4),m3h4x3(:,198),heltab2x12(:,:,404))
  call Hloop_CV_D(ntryL,G1H12(28),20,wf4(:,1),3,G2H3(63),m3h4x3(:,199),heltab2x12(:,:,405))
  call Hloop_DV_C(ntryL,G1H12(109),20,wf4(:,1),G2H3(66),m3h4x3(:,200),heltab2x12(:,:,406))
  call Hloop_DV_C(ntryL,G1H12(30),20,wf4(:,1),G2H3(14),m3h4x3(:,201),heltab2x12(:,:,407))
  call Hloop_UW_V(ntryL,G1H12(29),20,wf4(:,1),3,G2H3(81),m3h4x3(:,202),heltab2x12(:,:,408))
  call Hloop_UW_V(ntryL,G1H12(4),20,wf4(:,1),3,G2H3(84),m3h4x3(:,203),heltab2x12(:,:,409))
  call Hloop_VV_S(ntryL,G1H12(120),wf4(:,1),G1H3(85),m3h4x3(:,204),heltab2x12(:,:,410))
  call Hloop_SV_V(ntryL,G1H12(6),wf4(:,1),G1H3(80),m3h4x3(:,205),heltab2x12(:,:,411))
  call Hloop_SV_V(ntryL,G1H12(3),wf4(:,1),G1H3(170),m3h4x3(:,206),heltab2x12(:,:,412))
  call Hloop_VV_S(ntryL,G1H12(10),wf4(:,1),G1H3(163),m3h4x3(:,207),heltab2x12(:,:,413))
  call Hloop_VV_S(ntryL,G1H12(12),wf4(:,1),G1H3(118),m3h4x3(:,208),heltab2x12(:,:,414))
  call Hloop_VV_S(ntryL,G1H12(9),wf4(:,1),G1H3(177),m3h4x3(:,209),heltab2x12(:,:,415))
  call Hloop_AW_Q(ntryL,G1H12(108),wf4(:,1),G1H3(48),m3h4x3(:,210),heltab2x12(:,:,416))
  call Hloop_A_Q(ntryL,G1H3(48),23,0,G2H3(87),n2h3(134))
  call Hloop_QW_A(ntryL,G1H12(1),wf4(:,1),G1H3(24),m3h4x3(:,211),heltab2x12(:,:,417))
  call Hloop_Q_A(ntryL,G1H3(24),23,0,G2H3(23),n2h3(135))
  call Hloop_AW_Q(ntryL,G1H12(7),wf4(:,1),G1H3(62),m3h4x3(:,212),heltab2x12(:,:,418))
  call Hloop_A_Q(ntryL,G1H3(62),23,0,G2H3(24),n2h3(136))
  call Hloop_QW_A(ntryL,G1H12(23),wf4(:,1),G1H3(238),m3h4x3(:,213),heltab2x12(:,:,419))
  call Hloop_Q_A(ntryL,G1H3(238),23,0,G2H3(35),n2h3(137))
  call Hloop_SV_T(ntryL,G1H12(98),20,wf4(:,1),3,G2H3(33),m3h4x3(:,214),heltab2x12(:,:,420))
  call Hloop_TV_S(ntryL,G1H12(116),20,wf4(:,1),3,G2H3(29),m3h4x3(:,215),heltab2x12(:,:,421))
  call Hloop_CV_D(ntryL,G1H12(117),20,wf4(:,1),3,G2H3(30),m3h4x3(:,216),heltab2x12(:,:,422))
  call Hloop_QW_A(ntryL,G1H4(19),wf4(:,1),G1H1(30),m3h4x1(:,12),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H1(30),27,nML,G2H1(36),n2h1(167))
  call Hloop_AW_Q(ntryL,G1H4(20),wf4(:,1),G1H1(37),m3h4x1(:,13),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H1(37),27,nMT,G2H1(37),n2h1(168))
  call Hloop_QW_A(ntryL,G1H4(21),wf4(:,1),G1H1(69),m3h4x1(:,14),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H1(69),27,nMB,G2H1(39),n2h1(169))
  call Hloop_DV_C(ntryL,G1H4(26),24,wf4(:,1),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,36))
  call Hloop_CV_D(ntryL,G1H4(28),24,wf4(:,1),3,G2H1(2),m3h4x1(:,16),heltab2x4(:,:,37))
  call Hloop_CV_D(ntryL,G1H4(29),24,wf4(:,1),3,G2H1(3),m3h4x1(:,17),heltab2x4(:,:,38))
  call Hloop_DV_C(ntryL,G1H4(30),24,wf4(:,1),G2H1(4),m3h4x1(:,18),heltab2x4(:,:,39))
  call Hloop_DV_C(ntryL,G1H4(31),24,wf4(:,1),G2H1(5),m3h4x1(:,19),heltab2x4(:,:,40))
  call Hloop_VV_S(ntryL,G1H4(6),wf4(:,1),G1H1(45),m3h4x1(:,20),heltab2x4(:,:,41))
  call Hloop_VV_S(ntryL,G1H4(7),wf4(:,1),G1H1(74),m3h4x1(:,21),heltab2x4(:,:,42))
  call Hloop_VV_S(ntryL,G1H4(11),wf4(:,1),G1H1(26),m3h4x1(:,22),heltab2x4(:,:,43))
  call Hloop_SV_T(ntryL,G1H4(12),24,wf4(:,1),3,G2H1(6),m3h4x1(:,23),heltab2x4(:,:,44))
  call Hloop_TV_S(ntryL,G1H4(13),24,wf4(:,1),3,G2H1(7),m3h4x1(:,24),heltab2x4(:,:,45))
  call Hloop_TV_S(ntryL,G1H4(17),24,wf4(:,1),3,G2H1(8),m3h4x1(:,25),heltab2x4(:,:,46))
  call Hloop_UW_V(ntryL,G1H4(1),24,wf4(:,1),3,G2H1(9),m3h4x1(:,26),heltab2x4(:,:,47))
  call Hloop_UV_W(ntryL,G1H4(2),24,wf4(:,1),3,G2H1(10),m3h4x1(:,27),heltab2x4(:,:,48))
  call Hloop_UW_V(ntryL,G1H4(3),24,wf4(:,1),3,G2H1(11),m3h4x1(:,28),heltab2x4(:,:,49))
  call Hloop_SV_V(ntryL,G1H4(4),wf4(:,1),G1H1(4),m3h4x1(:,29),heltab2x4(:,:,50))
  call Hloop_SV_V(ntryL,G1H4(18),wf4(:,1),G1H1(5),m3h4x1(:,30),heltab2x4(:,:,51))
  call Hloop_CV_D(ntryL,G1H4(27),24,wf4(:,1),3,G2H1(12),m3h4x1(:,31),heltab2x4(:,:,52))
  call Hloop_AS_Q(ntryL,G1H12(13),wf4(:,2),G1H3(178),ngPln,m3h4x3(:,217),heltab2x12(:,:,423))
  call Hloop_A_Q(ntryL,G1H3(178),23,0,G2H3(99),n2h3(138))
  call Hloop_QS_A(ntryL,G1H12(14),wf4(:,2),G1H3(99),ngPln,m3h4x3(:,218),heltab2x12(:,:,424))
  call Hloop_Q_A(ntryL,G1H3(99),23,nML,G2H3(108),n2h3(139))
  call Hloop_AS_Q(ntryL,G1H12(16),wf4(:,2),G1H3(64),ngPbt,m3h4x3(:,219),heltab2x12(:,:,425))
  call Hloop_A_Q(ntryL,G1H3(64),23,nMT,G2H3(36),n2h3(140))
  call Hloop_QS_A(ntryL,G1H12(18),wf4(:,2),G1H3(1),ngPbt,m3h4x3(:,220),heltab2x12(:,:,426))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(38),n2h3(141))
  call Hloop_SS_S(ntryL,G1H12(19),wf4(:,2),G1H3(199),m3h4x3(:,221),heltab2x12(:,:,427))
  call Hloop_SS_S(ntryL,G1H12(20),wf4(:,2),G1H3(93),m3h4x3(:,222),heltab2x12(:,:,428))
  call Hloop_SS_S(ntryL,G1H12(22),wf4(:,2),G1H3(89),m3h4x3(:,223),heltab2x12(:,:,429))
  call Hloop_SS_S(ntryL,G1H12(24),wf4(:,2),G1H3(49),m3h4x3(:,224),heltab2x12(:,:,430))
  call Hloop_SS_S(ntryL,G1H12(25),wf4(:,2),G1H3(42),m3h4x3(:,225),heltab2x12(:,:,431))
  call Hloop_VS_V(ntryL,G1H12(26),wf4(:,2),G1H3(128),m3h4x3(:,226),heltab2x12(:,:,432))
  call Hloop_VS_V(ntryL,G1H12(32),wf4(:,2),G1H3(6),m3h4x3(:,227),heltab2x12(:,:,433))
  call Hloop_VT_S(ntryL,G0H12(76),16,wf4(:,2),7,G1H3(34),m3h4x3(:,228),heltab2x12(:,:,434))
  call Hloop_VT_S(ntryL,G0H12(8),16,wf4(:,2),7,G1H3(175),m3h4x3(:,229),heltab2x12(:,:,435))
  call Hloop_VS_T(ntryL,G0H12(82),16,wf4(:,2),7,G1H3(110),m3h4x3(:,230),heltab2x12(:,:,436))
  call Hloop_ST_V(ntryL,G1H12(33),16,wf4(:,2),7,G2H3(39),m3h4x3(:,231),heltab2x12(:,:,437))
  call Hloop_TS_V(ntryL,G1H12(34),16,wf4(:,2),7,G2H3(40),m3h4x3(:,232),heltab2x12(:,:,438))
  call Hloop_TS_V(ntryL,G1H12(35),16,wf4(:,2),7,G2H3(41),m3h4x3(:,233),heltab2x12(:,:,439))
  call Hloop_SS_S(ntryL,G0H12(77),wf4(:,2),G0H3(9),m3h4x3(:,234),heltab2x12(:,:,440))
  call Hloop_SS_S(ntryL,G0H12(6),wf4(:,2),G0H3(3),m3h4x3(:,235),heltab2x12(:,:,441))
  call Hloop_VS_V(ntryL,G0H12(75),wf4(:,2),G0H3(6),m3h4x3(:,236),heltab2x12(:,:,442))
  call Hloop_VS_V(ntryL,G0H12(22),wf4(:,2),G0H3(11),m3h4x3(:,237),heltab2x12(:,:,443))
  call Hloop_VS_V(ntryL,G0H12(23),wf4(:,2),G0H3(7),m3h4x3(:,238),heltab2x12(:,:,444))
  call Hloop_VT_S(ntryL,G1H12(37),16,wf4(:,2),7,G2H3(42),m3h4x3(:,239),heltab2x12(:,:,445))
  call Hloop_VS_T(ntryL,G1H12(38),16,wf4(:,2),7,G2H3(53),m3h4x3(:,240),heltab2x12(:,:,446))
  call Hloop_VT_S(ntryL,G1H12(39),16,wf4(:,2),7,G2H3(54),m3h4x3(:,241),heltab2x12(:,:,447))
  call Hloop_TS_V(ntryL,G0H12(24),16,wf4(:,2),7,G1H3(12),m3h4x3(:,242),heltab2x12(:,:,448))
  call Hloop_AW_Q(ntryL,G1H12(40),wf4(:,3),G1H3(141),m3h4x3(:,243),heltab2x12(:,:,449))
  call Hloop_A_Q(ntryL,G1H3(141),23,0,G2H3(57),n2h3(142))
  call Hloop_AW_Q(ntryL,G1H12(42),wf4(:,3),G1H3(205),m3h4x3(:,244),heltab2x12(:,:,450))
  call Hloop_A_Q(ntryL,G1H3(205),23,0,G2H3(58),n2h3(143))
  call Hloop_QW_A(ntryL,G1H12(43),wf4(:,3),G1H3(18),m3h4x3(:,245),heltab2x12(:,:,451))
  call Hloop_Q_A(ntryL,G1H3(18),23,0,G2H3(61),n2h3(144))
  call Hloop_QW_A(ntryL,G1H12(44),wf4(:,3),G1H3(87),m3h4x3(:,246),heltab2x12(:,:,452))
  call Hloop_Q_A(ntryL,G1H3(87),23,nML,G2H3(62),n2h3(145))
  call Hloop_AW_Q(ntryL,G1H12(45),wf4(:,3),G1H3(111),m3h4x3(:,247),heltab2x12(:,:,453))
  call Hloop_A_Q(ntryL,G1H3(111),23,0,G2H3(65),n2h3(146))
  call Hloop_AW_Q(ntryL,G1H12(47),wf4(:,3),G1H3(32),m3h4x3(:,248),heltab2x12(:,:,454))
  call Hloop_A_Q(ntryL,G1H3(32),23,nMT,G2H3(68),n2h3(147))
  call Hloop_QW_A(ntryL,G1H12(48),wf4(:,3),G1H3(142),m3h4x3(:,249),heltab2x12(:,:,455))
  call Hloop_Q_A(ntryL,G1H3(142),23,0,G2H3(69),n2h3(148))
  call Hloop_QW_A(ntryL,G1H12(49),wf4(:,3),G1H3(233),m3h4x3(:,250),heltab2x12(:,:,456))
  call Hloop_Q_A(ntryL,G1H3(233),23,nMB,G2H3(74),n2h3(149))
  call Hloop_SV_T(ntryL,G1H12(50),16,wf4(:,3),7,G2H3(75),m3h4x3(:,251),heltab2x12(:,:,457))
  call Hloop_SV_T(ntryL,G1H12(52),16,wf4(:,3),7,G2H3(77),m3h4x3(:,252),heltab2x12(:,:,458))
  call Hloop_TV_S(ntryL,G1H12(53),16,wf4(:,3),7,G2H3(78),m3h4x3(:,253),heltab2x12(:,:,459))
  call Hloop_TV_S(ntryL,G1H12(127),16,wf4(:,3),7,G2H3(80),m3h4x3(:,254),heltab2x12(:,:,460))
  call Hloop_CV_D(ntryL,G1H12(128),16,wf4(:,3),7,G2H3(83),m3h4x3(:,255),heltab2x12(:,:,461))
  call Hloop_CV_D(ntryL,G1H12(129),16,wf4(:,3),7,G2H3(86),m3h4x3(:,256),heltab2x12(:,:,462))
  call Hloop_DV_C(ntryL,G1H12(130),16,wf4(:,3),G2H3(89),m3h4x3(:,257),heltab2x12(:,:,463))
  call Hloop_DV_C(ntryL,G1H12(131),16,wf4(:,3),G2H3(90),m3h4x3(:,258),heltab2x12(:,:,464))
  call Hloop_UW_V(ntryL,G1H12(132),16,wf4(:,3),7,G2H3(92),m3h4x3(:,259),heltab2x12(:,:,465))
  call Hloop_UW_V(ntryL,G1H12(133),16,wf4(:,3),7,G2H3(93),m3h4x3(:,260),heltab2x12(:,:,466))
  call Hloop_VV_S(ntryL,G0H12(40),wf4(:,3),G0H3(10),m3h4x3(:,261),heltab2x12(:,:,467))
  call Hloop_VV_S(ntryL,G0H12(41),wf4(:,3),G0H3(15),m3h4x3(:,262),heltab2x12(:,:,468))
  call Hloop_SV_V(ntryL,G1H12(134),wf4(:,3),G1H3(108),m3h4x3(:,263),heltab2x12(:,:,469))
  call Hloop_SV_V(ntryL,G1H12(135),wf4(:,3),G1H3(226),m3h4x3(:,264),heltab2x12(:,:,470))
  call Hloop_SV_T(ntryL,G0H12(42),16,wf4(:,3),7,G1H3(106),m3h4x3(:,265),heltab2x12(:,:,471))
  call Hloop_TV_S(ntryL,G0H12(43),16,wf4(:,3),7,G1H3(92),m3h4x3(:,266),heltab2x12(:,:,472))
  call Hloop_UW_V(ntryL,G0H12(56),16,wf4(:,3),7,G1H3(189),m3h4x3(:,267),heltab2x12(:,:,473))
  call Hloop_UV_W(ntryL,G0H12(57),16,wf4(:,3),7,G1H3(91),m3h4x3(:,268),heltab2x12(:,:,474))
  call Hloop_UW_V(ntryL,G0H12(58),16,wf4(:,3),7,G1H3(126),m3h4x3(:,269),heltab2x12(:,:,475))
  call Hloop_VV_S(ntryL,G1H12(136),wf4(:,3),G1H3(122),m3h4x3(:,270),heltab2x12(:,:,476))
  call Hloop_VV_S(ntryL,G1H12(137),wf4(:,3),G1H3(116),m3h4x3(:,271),heltab2x12(:,:,477))
  call Hloop_VV_S(ntryL,G1H12(138),wf4(:,3),G1H3(171),m3h4x3(:,272),heltab2x12(:,:,478))
  call Hloop_SV_V(ntryL,G0H12(59),wf4(:,3),G0H3(1),m3h4x3(:,273),heltab2x12(:,:,479))
  call Hloop_AS_Q(ntryL,G1H12(139),ex3(:),G1H12(178),ngH,m3h1x12(:,62),heltab2x12(:,:,480))
  call Hloop_A_Q(ntryL,G1H12(178),20,nML,G2H12(8),n2h12(99))
  call Hloop_QS_A(ntryL,G1H12(140),ex3(:),G1H12(205),ngH,m3h1x12(:,63),heltab2x12(:,:,481))
  call Hloop_Q_A(ntryL,G1H12(205),20,nMT,G2H12(4),n2h12(100))
  call Hloop_AS_Q(ntryL,G1H12(141),ex3(:),G1H12(232),ngH,m3h1x12(:,64),heltab2x12(:,:,482))
  call Hloop_A_Q(ntryL,G1H12(232),20,nMB,G2H12(5),n2h12(101))
  call Hloop_SS_S(ntryL,G1H12(142),ex3(:),G1H12(239),m3h1x12(:,65),heltab2x12(:,:,483))
  call Hloop_SS_S(ntryL,G1H12(143),ex3(:),G1H12(27),m3h1x12(:,66),heltab2x12(:,:,484))
  call Hloop_SS_S(ntryL,G1H12(144),ex3(:),G1H12(115),m3h1x12(:,67),heltab2x12(:,:,485))
  call Hloop_SS_S(ntryL,G1H12(145),ex3(:),G1H12(8),m3h1x12(:,68),heltab2x12(:,:,486))
  call Hloop_SS_S(ntryL,G1H12(146),ex3(:),G1H12(119),m3h1x12(:,69),heltab2x12(:,:,487))
  call Hloop_SS_S(ntryL,G1H12(147),ex3(:),G1H12(126),m3h1x12(:,70),heltab2x12(:,:,488))
  call Hloop_SS_S(ntryL,G1H12(148),ex3(:),G1H12(93),m3h1x12(:,71),heltab2x12(:,:,489))
  call Hloop_VS_V(ntryL,G1H12(149),ex3(:),G1H12(124),m3h1x12(:,72),heltab2x12(:,:,490))
  call Hloop_VS_V(ntryL,G1H12(150),ex3(:),G1H12(54),m3h1x12(:,73),heltab2x12(:,:,491))
  call Hloop_VS_V(ntryL,G1H12(151),ex3(:),G1H12(55),m3h1x12(:,74),heltab2x12(:,:,492))
  call Hloop_SS_S(ntryL,G0H12(63),ex3(:),G0H12(114),m3h1x12(:,75),heltab2x12(:,:,493))
  call Hloop_SS_S(ntryL,G0H12(72),ex3(:),G0H12(66),m3h1x12(:,76),heltab2x12(:,:,494))
  call Hloop_SS_S(ntryL,G0H12(81),ex3(:),G0H12(85),m3h1x12(:,77),heltab2x12(:,:,495))
  call Hloop_ST_V(ntryL,G1H12(152),16,ex3(:),4,G2H12(6),m3h1x12(:,78),heltab2x12(:,:,496))
  call Hloop_ST_V(ntryL,G1H12(153),16,ex3(:),4,G2H12(7),m3h1x12(:,79),heltab2x12(:,:,497))
  call Hloop_ST_V(ntryL,G1H12(154),16,ex3(:),4,G2H12(9),m3h1x12(:,80),heltab2x12(:,:,498))
  call Hloop_VT_S(ntryL,G0H12(9),16,ex3(:),4,G1H12(56),m3h1x12(:,81),heltab2x12(:,:,499))
  call Hloop_ST_V(ntryL,G0H12(5),16,ex3(:),4,G1H12(57),m3h1x12(:,82),heltab2x12(:,:,500))
  call Hloop_ST_V(ntryL,G0H12(30),16,ex3(:),4,G1H12(58),m3h1x12(:,83),heltab2x12(:,:,501))
  call Hloop_VT_S(ntryL,G1H12(155),16,ex3(:),4,G2H12(1),m3h1x12(:,84),heltab2x12(:,:,502))
  call Hloop_VT_S(ntryL,G1H12(156),16,ex3(:),4,G2H12(2),m3h1x12(:,85),heltab2x12(:,:,503))
  call Hloop_VT_S(ntryL,G1H12(157),16,ex3(:),4,G2H12(3),m3h1x12(:,86),heltab2x12(:,:,504))
  call Hloop_VS_V(ntryL,G0H12(1),ex3(:),G0H12(69),m3h1x12(:,87),heltab2x12(:,:,505))
  call Hloop_VS_V(ntryL,G0H12(31),ex3(:),G0H12(11),m3h1x12(:,88),heltab2x12(:,:,506))
  call Hloop_AS_Q(ntryL,G1H12(158),ex3(:),G1H12(59),ngH,m3h1x12(:,89),heltab2x12(:,:,507))
  call Hloop_A_Q(ntryL,G1H12(59),20,nML,G2H12(10),n2h12(102))
  call Hloop_QS_A(ntryL,G1H12(159),ex3(:),G1H12(5),ngH,m3h1x12(:,90),heltab2x12(:,:,508))
  call Hloop_Q_A(ntryL,G1H12(5),20,nMT,G2H12(11),n2h12(103))
  call Hloop_AS_Q(ntryL,G1H12(160),ex3(:),G1H12(60),ngH,m3h1x12(:,91),heltab2x12(:,:,509))
  call Hloop_A_Q(ntryL,G1H12(60),20,nMB,G2H12(12),n2h12(104))
  call Hloop_SS_S(ntryL,G1H12(161),ex3(:),G1H12(11),m3h1x12(:,92),heltab2x12(:,:,510))
  call Hloop_SS_S(ntryL,G1H12(162),ex3(:),G1H12(61),m3h1x12(:,93),heltab2x12(:,:,511))
  call Hloop_SS_S(ntryL,G1H12(163),ex3(:),G1H12(17),m3h1x12(:,94),heltab2x12(:,:,512))
  call Hloop_SS_S(ntryL,G1H12(164),ex3(:),G1H12(62),m3h1x12(:,95),heltab2x12(:,:,513))
  call Hloop_SS_S(ntryL,G1H12(165),ex3(:),G1H12(121),m3h1x12(:,96),heltab2x12(:,:,514))
  call Hloop_SS_S(ntryL,G1H12(166),ex3(:),G1H12(122),m3h1x12(:,97),heltab2x12(:,:,515))
  call Hloop_SS_S(ntryL,G1H12(167),ex3(:),G1H12(123),m3h1x12(:,98),heltab2x12(:,:,516))
  call Hloop_SS_S(ntryL,G1H12(168),ex3(:),G1H12(125),m3h1x12(:,99),heltab2x12(:,:,517))
  call Hloop_SS_S(ntryL,G1H12(169),ex3(:),G1H12(110),m3h1x12(:,100),heltab2x12(:,:,518))
  call Hloop_SS_S(ntryL,G1H12(170),ex3(:),G1H12(63),m3h1x12(:,101),heltab2x12(:,:,519))
  call Hloop_VS_V(ntryL,G1H12(171),ex3(:),G1H12(64),m3h1x12(:,102),heltab2x12(:,:,520))
  call Hloop_VS_V(ntryL,G1H12(172),ex3(:),G1H12(65),m3h1x12(:,103),heltab2x12(:,:,521))
  call Hloop_VS_V(ntryL,G1H12(173),ex3(:),G1H12(66),m3h1x12(:,104),heltab2x12(:,:,522))
  call Hloop_SS_S(ntryL,G0H12(16),ex3(:),G0H12(70),m3h1x12(:,105),heltab2x12(:,:,523))
  call Hloop_SS_S(ntryL,G0H12(17),ex3(:),G0H12(12),m3h1x12(:,106),heltab2x12(:,:,524))
  call Hloop_SS_S(ntryL,G0H12(60),ex3(:),G0H12(64),m3h1x12(:,107),heltab2x12(:,:,525))
  call Hloop_ST_V(ntryL,G1H12(174),16,ex3(:),4,G2H12(13),m3h1x12(:,108),heltab2x12(:,:,526))
  call Hloop_ST_V(ntryL,G1H12(175),16,ex3(:),4,G2H12(14),m3h1x12(:,109),heltab2x12(:,:,527))
  call Hloop_VT_S(ntryL,G0H12(61),16,ex3(:),4,G1H12(67),m3h1x12(:,110),heltab2x12(:,:,528))
  call Hloop_VT_S(ntryL,G0H12(62),16,ex3(:),4,G1H12(68),m3h1x12(:,111),heltab2x12(:,:,529))
  call Hloop_ST_V(ntryL,G0H12(3),16,ex3(:),4,G1H12(69),m3h1x12(:,112),heltab2x12(:,:,530))
  call Hloop_ST_V(ntryL,G0H12(18),16,ex3(:),4,G1H12(70),m3h1x12(:,113),heltab2x12(:,:,531))
  call Hloop_VT_S(ntryL,G1H12(176),16,ex3(:),4,G2H12(15),m3h1x12(:,114),heltab2x12(:,:,532))
  call Hloop_VT_S(ntryL,G1H12(177),16,ex3(:),4,G2H12(16),m3h1x12(:,115),heltab2x12(:,:,533))
  call Hloop_VS_V(ntryL,G0H12(2),ex3(:),G0H12(83),m3h1x12(:,116),heltab2x12(:,:,534))
  call Hloop_VS_V(ntryL,G0H12(87),ex3(:),G0H12(65),m3h1x12(:,117),heltab2x12(:,:,535))
  call Hloop_AS_Q(ntryL,G1H3(207),ex3(:),G1H3(113),ngH,m3h1x3(:,116),heltab2x3(:,:,510))
  call Hloop_A_Q(ntryL,G1H3(113),23,nML,G2H3(95),n2h3(150))
  call Hloop_QS_A(ntryL,G1H3(212),ex3(:),G1H3(230),ngH,m3h1x3(:,117),heltab2x3(:,:,511))
  call Hloop_Q_A(ntryL,G1H3(230),23,nMT,G2H3(96),n2h3(151))
  call Hloop_AS_Q(ntryL,G1H3(215),ex3(:),G1H3(229),ngH,m3h1x3(:,118),heltab2x3(:,:,512))
  call Hloop_A_Q(ntryL,G1H3(229),23,nMB,G2H3(98),n2h3(152))
  call Hloop_SS_S(ntryL,G1H3(234),ex3(:),G1H3(162),m3h1x3(:,119),heltab2x3(:,:,513))
  call Hloop_SS_S(ntryL,G1H3(237),ex3(:),G1H3(67),m3h1x3(:,120),heltab2x3(:,:,514))
  call Hloop_SS_S(ntryL,G1H3(148),ex3(:),G1H3(102),m3h1x3(:,121),heltab2x3(:,:,515))
  call Hloop_VT_S(ntryL,G1H3(150),19,ex3(:),4,G2H3(101),m3h1x3(:,122),heltab2x3(:,:,516))
  call Hloop_VT_S(ntryL,G1H3(153),19,ex3(:),4,G2H3(104),m3h1x3(:,123),heltab2x3(:,:,517))
  call Hloop_ST_V(ntryL,G1H3(155),19,ex3(:),4,G2H3(107),m3h1x3(:,124),heltab2x3(:,:,518))
  call Hloop_ST_V(ntryL,G1H3(156),19,ex3(:),4,G2H3(110),m3h1x3(:,125),heltab2x3(:,:,519))
  call Hloop_VS_V(ntryL,G1H3(161),ex3(:),G1H3(97),m3h1x3(:,126),heltab2x3(:,:,520))
  call Hloop_SS_S(ntryL,G1H3(221),ex3(:),G1H3(55),m3h1x3(:,127),heltab2x3(:,:,521))
  call Hloop_SS_S(ntryL,G1H3(222),ex3(:),G1H3(125),m3h1x3(:,128),heltab2x3(:,:,522))
  call Hloop_SS_S(ntryL,G0H3(61),ex3(:),G0H3(16),m3h1x3(:,129),heltab2x3(:,:,523))
  call Hloop_VT_S(ntryL,G0H3(66),19,ex3(:),4,G1H3(117),m3h1x3(:,130),heltab2x3(:,:,524))
  call Hloop_VS_V(ntryL,G0H3(75),ex3(:),G0H3(12),m3h1x3(:,131),heltab2x3(:,:,525))
  call Hloop_VS_V(ntryL,G0H6(4),ex3(:),G0H6(21),m3h1x6(:,15),heltab2x6(:,:,216))
  call Hloop_VS_V(ntryL,G0H6(5),ex3(:),G0H6(3),m3h1x6(:,16),heltab2x6(:,:,217))
  call Hloop_WQ_A(ntryL,G1H12(181),ex2(:),G1H6(14),m3h2x6(:,135),heltab2x12(:,:,536))
  call Hloop_Q_A(ntryL,G1H6(14),22,0,G2H6(31),n2h6(149))
  call Hloop_VQ_A(ntryL,G1H12(182),ex2(:),G1H6(12),m3h2x6(:,136),heltab2x12(:,:,537))
  call Hloop_Q_A(ntryL,G1H6(12),22,0,G2H6(18),n2h6(150))
  call Hloop_WQ_A(ntryL,G1H12(183),ex2(:),G1H6(16),m3h2x6(:,137),heltab2x12(:,:,538))
  call Hloop_Q_A(ntryL,G1H6(16),22,0,G2H6(19),n2h6(151))
  call Hloop_ZQ_A(ntryL,G1H12(184),ex2(:),G1H6(7),ngZd,m3h2x6(:,138),heltab2x12(:,:,539))
  call Hloop_Q_A(ntryL,G1H6(7),22,0,G2H6(20),n2h6(152))
  call Hloop_AQ_V(ntryL,G1H12(180),ex2(:),G1H6(11),m3h2x6(:,139),heltab2x12(:,:,540))
  call Hloop_AQ_Z(ntryL,G1H12(179),ex2(:),G1H6(5),ngZd,m3h2x6(:,140),heltab2x12(:,:,541))
  call Hloop_AS_Q(ntryL,G1H12(185),ex3(:),G1H12(71),ngH,m3h1x12(:,118),heltab2x12(:,:,542))
  call Hloop_A_Q(ntryL,G1H12(71),20,nML,G2H12(17),n2h12(105))
  call Hloop_QS_A(ntryL,G1H12(186),ex3(:),G1H12(72),ngH,m3h1x12(:,119),heltab2x12(:,:,543))
  call Hloop_Q_A(ntryL,G1H12(72),20,nMT,G2H12(18),n2h12(106))
  call Hloop_AS_Q(ntryL,G1H12(187),ex3(:),G1H12(73),ngH,m3h1x12(:,120),heltab2x12(:,:,544))
  call Hloop_A_Q(ntryL,G1H12(73),20,nMB,G2H12(19),n2h12(107))
  call Hloop_SS_S(ntryL,G1H12(188),ex3(:),G1H12(74),m3h1x12(:,121),heltab2x12(:,:,545))
  call Hloop_SS_S(ntryL,G1H12(189),ex3(:),G1H12(75),m3h1x12(:,122),heltab2x12(:,:,546))
  call Hloop_SS_S(ntryL,G1H12(190),ex3(:),G1H12(76),m3h1x12(:,123),heltab2x12(:,:,547))
  call Hloop_SS_S(ntryL,G1H12(191),ex3(:),G1H12(77),m3h1x12(:,124),heltab2x12(:,:,548))
  call Hloop_SS_S(ntryL,G1H12(192),ex3(:),G1H12(78),m3h1x12(:,125),heltab2x12(:,:,549))
  call Hloop_SS_S(ntryL,G1H12(193),ex3(:),G1H12(79),m3h1x12(:,126),heltab2x12(:,:,550))
  call Hloop_SS_S(ntryL,G1H12(194),ex3(:),G1H12(80),m3h1x12(:,127),heltab2x12(:,:,551))
  call Hloop_SS_S(ntryL,G1H12(195),ex3(:),G1H12(81),m3h1x12(:,128),heltab2x12(:,:,552))
  call Hloop_SS_S(ntryL,G1H12(196),ex3(:),G1H12(82),m3h1x12(:,129),heltab2x12(:,:,553))
  call Hloop_SS_S(ntryL,G1H12(197),ex3(:),G1H12(83),m3h1x12(:,130),heltab2x12(:,:,554))
  call Hloop_VS_V(ntryL,G1H12(198),ex3(:),G1H12(84),m3h1x12(:,131),heltab2x12(:,:,555))
  call Hloop_VS_V(ntryL,G1H12(199),ex3(:),G1H12(85),m3h1x12(:,132),heltab2x12(:,:,556))
  call Hloop_VS_V(ntryL,G1H12(200),ex3(:),G1H12(86),m3h1x12(:,133),heltab2x12(:,:,557))
  call Hloop_SS_S(ntryL,G0H12(92),ex3(:),G0H12(84),m3h1x12(:,134),heltab2x12(:,:,558))
  call Hloop_SS_S(ntryL,G0H12(93),ex3(:),G0H12(67),m3h1x12(:,135),heltab2x12(:,:,559))
  call Hloop_SS_S(ntryL,G0H12(94),ex3(:),G0H12(86),m3h1x12(:,136),heltab2x12(:,:,560))
  call Hloop_ST_V(ntryL,G1H12(201),16,ex3(:),4,G2H12(20),m3h1x12(:,137),heltab2x12(:,:,561))
  call Hloop_ST_V(ntryL,G1H12(202),16,ex3(:),4,G2H12(21),m3h1x12(:,138),heltab2x12(:,:,562))
  call Hloop_VT_S(ntryL,G0H12(95),16,ex3(:),4,G1H12(87),m3h1x12(:,139),heltab2x12(:,:,563))
  call Hloop_VT_S(ntryL,G0H12(96),16,ex3(:),4,G1H12(88),m3h1x12(:,140),heltab2x12(:,:,564))
  call Hloop_ST_V(ntryL,G0H12(97),16,ex3(:),4,G1H12(89),m3h1x12(:,141),heltab2x12(:,:,565))
  call Hloop_ST_V(ntryL,G0H12(98),16,ex3(:),4,G1H12(90),m3h1x12(:,142),heltab2x12(:,:,566))
  call Hloop_VT_S(ntryL,G1H12(203),16,ex3(:),4,G2H12(22),m3h1x12(:,143),heltab2x12(:,:,567))
  call Hloop_VT_S(ntryL,G1H12(204),16,ex3(:),4,G2H12(23),m3h1x12(:,144),heltab2x12(:,:,568))
  call Hloop_VS_V(ntryL,G0H12(99),ex3(:),G0H12(68),m3h1x12(:,145),heltab2x12(:,:,569))
  call Hloop_VS_V(ntryL,G0H12(100),ex3(:),G0H12(10),m3h1x12(:,146),heltab2x12(:,:,570))
  call Hloop_AQ_Z(ntryL,G1H2(9),ex2(:),G1H1(73),ngZd,m3h2x1(:,69),heltab2x2(:,:,70))
  call Hloop_AQ_W(ntryL,G1H2(10),ex2(:),G1H1(78),m3h2x1(:,70),heltab2x2(:,:,71))
  call Hloop_VS_V(ntryL,G0H6(1),ex3(:),G0H6(9),m3h1x6(:,17),heltab2x6(:,:,218))
  call Hloop_VS_V(ntryL,G0H6(2),ex3(:),G0H6(13),m3h1x6(:,18),heltab2x6(:,:,219))
  call Hloop_VA_Q(ntryL,G1H12(208),ex1(:),G1H6(6),m3h2x6(:,141),heltab2x12(:,:,571))
  call Hloop_A_Q(ntryL,G1H6(6),21,0,G2H6(21),n2h6(153))
  call Hloop_WA_Q(ntryL,G1H12(209),ex1(:),G1H6(39),m3h2x6(:,142),heltab2x12(:,:,572))
  call Hloop_A_Q(ntryL,G1H6(39),21,0,G2H6(22),n2h6(154))
  call Hloop_ZA_Q(ntryL,G1H12(210),ex1(:),G1H6(2),ngZu,m3h2x6(:,143),heltab2x12(:,:,573))
  call Hloop_A_Q(ntryL,G1H6(2),21,0,G2H6(23),n2h6(155))
  call Hloop_WA_Q(ntryL,G1H12(211),ex1(:),G1H6(3),m3h2x6(:,144),heltab2x12(:,:,574))
  call Hloop_A_Q(ntryL,G1H6(3),21,0,G2H6(1),n2h6(156))
  call Hloop_QA_V(ntryL,G1H12(207),ex1(:),G1H6(44),m3h2x6(:,145),heltab2x12(:,:,575))
  call Hloop_QA_Z(ntryL,G1H12(206),ex1(:),G1H6(46),ngZu,m3h2x6(:,146),heltab2x12(:,:,576))
  call Hloop_AS_Q(ntryL,G1H12(212),ex3(:),G1H12(91),ngH,m3h1x12(:,147),heltab2x12(:,:,577))
  call Hloop_A_Q(ntryL,G1H12(91),20,nML,G2H12(24),n2h12(108))
  call Hloop_QS_A(ntryL,G1H12(213),ex3(:),G1H12(92),ngH,m3h1x12(:,148),heltab2x12(:,:,578))
  call Hloop_Q_A(ntryL,G1H12(92),20,nMT,G2H12(25),n2h12(109))
  call Hloop_AS_Q(ntryL,G1H12(214),ex3(:),G1H12(95),ngH,m3h1x12(:,149),heltab2x12(:,:,579))
  call Hloop_A_Q(ntryL,G1H12(95),20,nMB,G2H12(26),n2h12(110))
  call Hloop_SS_S(ntryL,G1H12(215),ex3(:),G1H12(94),m3h1x12(:,150),heltab2x12(:,:,580))
  call Hloop_SS_S(ntryL,G1H12(216),ex3(:),G1H12(96),m3h1x12(:,151),heltab2x12(:,:,581))
  call Hloop_SS_S(ntryL,G1H12(217),ex3(:),G1H12(97),m3h1x12(:,152),heltab2x12(:,:,582))
  call Hloop_SS_S(ntryL,G1H12(218),ex3(:),G1H12(100),m3h1x12(:,153),heltab2x12(:,:,583))
  call Hloop_SS_S(ntryL,G1H12(219),ex3(:),G1H12(99),m3h1x12(:,154),heltab2x12(:,:,584))
  call Hloop_SS_S(ntryL,G1H12(220),ex3(:),G1H12(101),m3h1x12(:,155),heltab2x12(:,:,585))
  call Hloop_SS_S(ntryL,G1H12(221),ex3(:),G1H12(102),m3h1x12(:,156),heltab2x12(:,:,586))
  call Hloop_SS_S(ntryL,G1H12(222),ex3(:),G1H12(103),m3h1x12(:,157),heltab2x12(:,:,587))
  call Hloop_SS_S(ntryL,G1H12(223),ex3(:),G1H12(104),m3h1x12(:,158),heltab2x12(:,:,588))
  call Hloop_SS_S(ntryL,G1H12(224),ex3(:),G1H12(105),m3h1x12(:,159),heltab2x12(:,:,589))
  call Hloop_VS_V(ntryL,G1H12(225),ex3(:),G1H12(106),m3h1x12(:,160),heltab2x12(:,:,590))
  call Hloop_VS_V(ntryL,G1H12(226),ex3(:),G1H12(2),m3h1x12(:,161),heltab2x12(:,:,591))
  call Hloop_VS_V(ntryL,G1H12(227),ex3(:),G1H12(107),m3h1x12(:,162),heltab2x12(:,:,592))
  call Hloop_SS_S(ntryL,G0H12(105),ex3(:),G0H12(71),m3h1x12(:,163),heltab2x12(:,:,593))
  call Hloop_SS_S(ntryL,G0H12(106),ex3(:),G0H12(13),m3h1x12(:,164),heltab2x12(:,:,594))
  call Hloop_SS_S(ntryL,G0H12(107),ex3(:),G0H12(44),m3h1x12(:,165),heltab2x12(:,:,595))
  call Hloop_ST_V(ntryL,G1H12(228),16,ex3(:),4,G2H12(27),m3h1x12(:,166),heltab2x12(:,:,596))
  call Hloop_ST_V(ntryL,G1H12(229),16,ex3(:),4,G2H12(28),m3h1x12(:,167),heltab2x12(:,:,597))
  call Hloop_VT_S(ntryL,G0H12(108),16,ex3(:),4,G1H12(118),m3h1x12(:,168),heltab2x12(:,:,598))
  call Hloop_VT_S(ntryL,G0H12(109),16,ex3(:),4,G1H12(28),m3h1x12(:,169),heltab2x12(:,:,599))
  call Hloop_ST_V(ntryL,G0H12(110),16,ex3(:),4,G1H12(109),m3h1x12(:,170),heltab2x12(:,:,600))
  call Hloop_ST_V(ntryL,G0H12(111),16,ex3(:),4,G1H12(30),m3h1x12(:,171),heltab2x12(:,:,601))
  call Hloop_VT_S(ntryL,G1H12(230),16,ex3(:),4,G2H12(29),m3h1x12(:,172),heltab2x12(:,:,602))
  call Hloop_VT_S(ntryL,G1H12(231),16,ex3(:),4,G2H12(30),m3h1x12(:,173),heltab2x12(:,:,603))
  call Hloop_VS_V(ntryL,G0H12(112),ex3(:),G0H12(45),m3h1x12(:,174),heltab2x12(:,:,604))
  call Hloop_VS_V(ntryL,G0H12(113),ex3(:),G0H12(46),m3h1x12(:,175),heltab2x12(:,:,605))
  call Hloop_QA_Z(ntryL,G1H2(11),ex1(:),G1H1(79),ngZu,m3h2x1(:,71),heltab2x2(:,:,72))
  call Hloop_QA_W(ntryL,G1H2(12),ex1(:),G1H1(75),m3h2x1(:,72),heltab2x2(:,:,73))
  call Hloop_VQ_A(ntryL,G0H6(8),ex2(:),G0H3(13),m3h2x3(:,119),heltab2x6(:,:,220))
  call Hloop_Q_A(ntryL,G0H3(13),19,0,G1H3(115),n2h3(153))
  call Hloop_ZQ_A(ntryL,G0H6(6),ex2(:),G0H3(8),ngZd,m3h2x3(:,120),heltab2x6(:,:,221))
  call Hloop_Q_A(ntryL,G0H3(8),19,0,G1H3(147),n2h3(154))
  call Hloop_WQ_A(ntryL,G0H6(7),ex2(:),G0H3(14),m3h2x3(:,121),heltab2x6(:,:,222))
  call Hloop_Q_A(ntryL,G0H3(14),19,0,G1H3(160),n2h3(155))
  call Hloop_AQ_W(ntryL,G1H6(42),ex2(:),G1H3(70),m3h2x3(:,122),heltab2x6(:,:,223))
  call Hloop_VA_Q(ntryL,G0H6(12),ex1(:),G0H3(4),m3h2x3(:,123),heltab2x6(:,:,224))
  call Hloop_A_Q(ntryL,G0H3(4),19,0,G1H3(164),n2h3(156))
  call Hloop_ZA_Q(ntryL,G0H6(10),ex1(:),G0H3(63),ngZu,m3h2x3(:,124),heltab2x6(:,:,225))
  call Hloop_A_Q(ntryL,G0H3(63),19,0,G1H3(74),n2h3(157))
  call Hloop_WA_Q(ntryL,G0H6(11),ex1(:),G0H3(62),m3h2x3(:,125),heltab2x6(:,:,226))
  call Hloop_A_Q(ntryL,G0H3(62),19,0,G1H3(165),n2h3(158))
  call Hloop_QA_W(ntryL,G1H6(8),ex1(:),G1H3(252),m3h2x3(:,126),heltab2x6(:,:,227))
  call Hloop_AQ_V(ntryL,G1H12(234),ex2(:),G1H6(47),m3h2x6(:,147),heltab2x12(:,:,606))
  call Hloop_AQ_Z(ntryL,G1H12(233),ex2(:),G1H6(27),ngZd,m3h2x6(:,148),heltab2x12(:,:,607))
  call Hloop_WQ_A(ntryL,G1H12(235),ex2(:),G1H6(30),m3h2x6(:,149),heltab2x12(:,:,608))
  call Hloop_Q_A(ntryL,G1H6(30),18,0,G2H6(2),n2h6(157))
  call Hloop_VQ_A(ntryL,G1H12(236),ex2(:),G1H6(36),m3h2x6(:,150),heltab2x12(:,:,609))
  call Hloop_Q_A(ntryL,G1H6(36),18,0,G2H6(4),n2h6(158))
  call Hloop_WQ_A(ntryL,G1H12(237),ex2(:),G1H6(19),m3h2x6(:,151),heltab2x12(:,:,610))
  call Hloop_Q_A(ntryL,G1H6(19),18,0,G2H6(5),n2h6(159))
  call Hloop_ZQ_A(ntryL,G1H12(238),ex2(:),G1H6(32),ngZd,m3h2x6(:,152),heltab2x12(:,:,611))
  call Hloop_Q_A(ntryL,G1H6(32),18,0,G2H6(6),n2h6(160))
  call Hloop_QA_V(ntryL,G1H12(241),ex1(:),G1H6(33),m3h2x6(:,153),heltab2x12(:,:,612))
  call Hloop_QA_Z(ntryL,G1H12(240),ex1(:),G1H6(9),ngZu,m3h2x6(:,154),heltab2x12(:,:,613))
  call Hloop_VA_Q(ntryL,G1H12(242),ex1(:),G1H6(28),m3h2x6(:,155),heltab2x12(:,:,614))
  call Hloop_A_Q(ntryL,G1H6(28),17,0,G2H6(8),n2h6(161))
  call Hloop_WA_Q(ntryL,G1H12(243),ex1(:),G1H6(21),m3h2x6(:,156),heltab2x12(:,:,615))
  call Hloop_A_Q(ntryL,G1H6(21),17,0,G2H6(9),n2h6(162))
  call Hloop_ZA_Q(ntryL,G1H12(244),ex1(:),G1H6(4),ngZu,m3h2x6(:,157),heltab2x12(:,:,616))
  call Hloop_A_Q(ntryL,G1H6(4),17,0,G2H6(10),n2h6(163))
  call Hloop_WA_Q(ntryL,G1H12(245),ex1(:),G1H6(22),m3h2x6(:,158),heltab2x12(:,:,617))
  call Hloop_A_Q(ntryL,G1H6(22),17,0,G2H6(12),n2h6(164))
  call Hloop_QA_V(ntryL,G1H4(69),ex1(:),G1H2(6),m3h2x2(:,22),heltab2x4(:,:,53))
  call Hloop_QA_Z(ntryL,G1H4(68),ex1(:),G1H2(2),ngZu,m3h2x2(:,23),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G0H6(16),ex2(:),G0H3(60),m3h2x3(:,127),heltab2x6(:,:,228))
  call Hloop_Q_A(ntryL,G0H3(60),23,0,G1H3(37),n2h3(159))
  call Hloop_ZQ_A(ntryL,G0H6(14),ex2(:),G0H3(59),ngZd,m3h2x3(:,128),heltab2x6(:,:,229))
  call Hloop_Q_A(ntryL,G0H3(59),23,0,G1H3(109),n2h3(160))
  call Hloop_WQ_A(ntryL,G0H6(15),ex2(:),G0H3(44),m3h2x3(:,129),heltab2x6(:,:,230))
  call Hloop_Q_A(ntryL,G0H3(44),23,0,G1H3(114),n2h3(161))
  call Hloop_AQ_W(ntryL,G1H6(10),ex2(:),G1H3(119),m3h2x3(:,130),heltab2x6(:,:,231))
  call Hloop_VA_Q(ntryL,G0H6(20),ex1(:),G0H3(43),m3h2x3(:,131),heltab2x6(:,:,232))
  call Hloop_A_Q(ntryL,G0H3(43),23,0,G1H3(124),n2h3(162))
  call Hloop_ZA_Q(ntryL,G0H6(18),ex1(:),G0H3(41),ngZu,m3h2x3(:,132),heltab2x6(:,:,233))
  call Hloop_A_Q(ntryL,G0H3(41),23,0,G1H3(129),n2h3(163))
  call Hloop_WA_Q(ntryL,G0H6(19),ex1(:),G0H3(40),m3h2x3(:,133),heltab2x6(:,:,234))
  call Hloop_A_Q(ntryL,G0H3(40),23,0,G1H3(139),n2h3(164))
  call Hloop_QA_W(ntryL,G1H6(13),ex1(:),G1H3(149),m3h2x3(:,134),heltab2x6(:,:,235))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(135),[G1H3(71)])
call HGT_w2_OLR(G1H3(135),1,1,3)
call HGT_w2_invQ_OLR(G1H3(135),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(135),[G1H3(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(124),[G1H3(203)])
call HGT_w2_OLR(G1H3(105),1,1,3)
call HGT_w2_invQ_OLR(G1H3(105),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(105),[G1H3(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(129),[G1H3(208)])
call HGT_w2_OLR(G1H3(193),1,1,3)
call HGT_w2_invQ_OLR(G1H3(193),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(193),[G1H3(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(8),G1H1(1)])
call HGT_w2_OLR(G1H1(48),1,1,1)
call HGT_w2_invQ_OLR(G1H1(48),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G2H3(64),G1H3(122),G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G1H1(32),G1H1(59)])
call HGT_w2_OLR(G1H1(52),1,1,1)
call HGT_w2_invQ_OLR(G1H1(52),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G1H1(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(54),[G2H3(109),G2H3(67),G1H3(171),G1H3(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(81),[G1H3(152),G1H3(140)])
call HGT_lower_alpha_OLR(G1H3(28),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(28),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(81),[G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(84),[G1H3(14),G1H3(158),G1H3(146)])
call HGT_lower_alpha_OLR(G1H3(3),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(3),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(84),[G1H3(3)])
call HGT_OLR(G2H3(70),1,1,3)
call HGT_invQ_OLR(G2H3(70),2,5,3)
call HGT_OLR(G2H3(70),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(70),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(60),[G1H1(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G1H3(243)])
call HGT_OLR(G2H3(71),1,1,3)
call HGT_invQ_OLR(G2H3(71),2,5,3)
call HGT_OLR(G2H3(71),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(71),[G2H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(63),[G1H1(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(239)])
call HGT_OLR(G2H3(72),1,1,3)
call HGT_invQ_OLR(G2H3(72),2,5,3)
call HGT_OLR(G2H3(72),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(72),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(66),[G1H1(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(79)])
call HGT_OLR(G1H3(23),1,1,3)
call HGT_invQ_OLR(G1H3(23),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G1H3(85),G1H3(104)])
call HGT_OLR(G1H3(45),1,1,3)
call HGT_invQ_OLR(G1H3(45),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(16)])
call HGT_OLR(G1H3(29),1,1,3)
call HGT_invQ_OLR(G1H3(29),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G1H3(154),G1H3(13)])
call HGT_OLR(G1H3(35),1,1,3)
call HGT_invQ_OLR(G1H3(35),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G1H3(35)])
call HGT_OLR(G1H3(20),1,1,3)
call HGT_invQ_OLR(G1H3(20),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G1H3(58)])
call HGT_OLR(G1H3(9),1,1,3)
call HGT_invQ_OLR(G1H3(9),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G1H3(9)])
call HGT_OLR(G1H3(52),1,1,3)
call HGT_invQ_OLR(G1H3(52),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G1H3(76)])
call HGT_OLR(G1H3(36),1,1,3)
call HGT_invQ_OLR(G1H3(36),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G1H3(36)])
call HGT_OLR(G2H1(92),1,1,1)
call HGT_invQ_OLR(G2H1(92),2,5,1)
call HGT_OLR(G2H1(92),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(92),[G2H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(62),[G2H3(108),G2H3(73),G1H3(224)])
call HGT_OLR(G2H1(93),1,1,1)
call HGT_invQ_OLR(G2H1(93),2,5,1)
call HGT_OLR(G2H1(93),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(93),[G2H1(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(68),[G2H3(36),G2H3(97),G2H3(76),G1H3(244),G1H3(228)])
call HGT_OLR(G2H1(94),1,1,1)
call HGT_invQ_OLR(G2H1(94),2,5,1)
call HGT_OLR(G2H1(94),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(94),[G2H1(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(74),[G2H3(38),G2H3(94),G2H3(79),G1H3(240),G1H3(232)])
call HGT_lower_alpha_w2_OLR(G1H1(65),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G1H1(65),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(39),[G2H3(103),G2H3(82),G1H3(91),G1H3(108),G1H3(50) &
    ,G0H3(11)])
call HGT_lower_alpha_w2_OLR(G1H1(66),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G1H1(66),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(7),[G1H1(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(40),[G2H3(85),G1H3(226),G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(63)])
call HGT_lower_alpha_w2_OLR(G1H1(70),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G1H1(70),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G2H3(106),G2H3(88),G1H3(126),G0H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(99),G2H3(91),G1H3(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(53),[G2H3(100),G1H3(116),G1H3(106),G1H3(44),G0H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(164),[G1H3(180)])
call HGT_w2_OLR(G1H3(130),1,1,3)
call HGT_w2_invQ_OLR(G1H3(130),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(130),[G1H3(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(133),[G1H3(131)])
call HGT_w2_OLR(G1H3(133),1,1,3)
call HGT_w2_invQ_OLR(G1H3(133),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(133),[G1H3(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(74),[G1H3(185)])
call HGT_w2_OLR(G1H3(132),1,1,3)
call HGT_w2_invQ_OLR(G1H3(132),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(132),[G1H3(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(58),[G1H1(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(149),[G1H3(145),G1H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(3),[G1H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(119),[G1H3(157),G1H3(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(93),[G1H3(6),G1H3(168),G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(104),[G1H3(68),G1H3(120),G1H3(5),G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(34),[G1H3(43),G0H3(10),G0H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(117),[G1H3(125),G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(75),[G1H3(110),G1H3(15),G1H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(80),[G1H3(175),G1H3(41),G1H3(61),G0H3(15),G0H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(110),[G1H3(84),G1H3(53),G1H3(166),G1H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(92),[G1H3(128),G1H3(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(46),[G1H1(50),G1H1(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(56),[G1H1(51),G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(55),[G1H3(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(77),[G1H3(199),G1H3(176),G1H3(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G1H3(93),G1H3(95),G1H3(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(67),[G1H3(2),G1H3(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(83),[G1H3(89),G1H3(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(86),[G1H3(49),G1H3(63),G1H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(162),[G1H3(81),G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(89),[G1H3(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(90),[G1H3(42),G1H3(82),G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(90),G0H3(1),G0H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(115),[G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G1H3(77),G1H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(147),[G1H3(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(70),[G1H3(98),G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(196),G1H3(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(201),G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G1H3(194),G1H3(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(252),[G1H3(200),G1H3(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G1H3(209),G1H3(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(37),[G1H3(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G1H3(219),G1H3(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(109),[G1H3(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G1H1(23),G1H1(77),G1H1(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(30),[G1H1(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(31),[G1H1(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(28),[G1H1(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G1H3(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G1H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G0H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G1H3(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(27),[G1H3(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(105),[G1H3(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(101),[G1H3(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(107),[G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(41),[G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(46),[G1H12(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(51),[G1H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(114),[G1H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(45),[G1H1(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(49),[G1H1(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(50),[G1H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(83),[G1H3(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(143),[G1H3(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(75),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G0H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(217),[G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(169),[G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(92),[G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G0H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(56),[G1H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(57),[G1H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(58),[G1H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(1),[G0H12(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G0H12(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(6),[G0H12(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G0H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(67),[G1H12(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(68),[G1H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(69),[G1H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(70),[G1H12(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G0H12(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G0H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G0H12(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(14),[G0H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(87),[G1H12(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(88),[G1H12(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(89),[G1H12(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(90),[G1H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(22),[G0H12(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(23),[G0H12(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(20),[G0H12(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(21),[G0H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(118),[G1H12(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(109),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G0H12(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(30),[G0H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G0H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(28),[G0H12(46)])
  call Hloop_AZ_Q(ntryL,G1H3(135),ex4(:),G1H1(80),ngZd,m3h3x1(:,395),heltab2x3(:,:,526))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(80),31,0,G2tensor(39),n2h1(170))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(4),ngZd,m3h2x1(:,73),heltab2x2(:,:,74))
  call Hloop_AZ_Q(ntryL,G1H3(105),ex4(:),G1H1(67),ngZu,m3h3x1(:,396),heltab2x3(:,:,527))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(67),31,0,G2tensor(57),n2h1(171))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(8),m3h2x1(:,74),heltab2x2(:,:,75))
  call Hloop_AZ_Q(ntryL,G1H3(193),ex4(:),G1H1(83),ngZu,m3h3x1(:,397),heltab2x3(:,:,528))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),31,0,G2tensor(12),n2h1(172))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(14),m3h2x1(:,75),heltab2x2(:,:,76))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H1(9),27,ex3(:),4,G3tensor(10),m3h1x1(:,185),heltab2x1(:,:,185))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(42),ex4(:),G2tensor(18),m3h3x1(:,398),heltab2x3(:,:,529))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H1(11),27,ex3(:),4,G3tensor(11),m3h1x1(:,186),heltab2x1(:,:,186))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(54),ex4(:),G2tensor(20),m3h3x1(:,399),heltab2x3(:,:,530))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(81),23,ex4(:),8,G3tensor(12),m3h3x1(:,400),heltab2x3(:,:,531))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(54),ex3(:),G2tensor(185),m3h1x1(:,187),heltab2x1(:,:,187))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(84),23,ex4(:),8,G3tensor(13),m3h3x1(:,401),heltab2x3(:,:,532))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(57),ex3(:),G2tensor(66),m3h1x1(:,188),heltab2x1(:,:,188))
  call Hloop_QZ_A(ntryL,G2H3(70),ex4(:),G2H1(13),ngZl,m3h3x1(:,402),heltab2x3(:,:,533))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,nML,G3tensor(14),n2h1(173))
  call Hloop_QS_A(ntryL,G2H1(60),ex3(:),G2H1(15),ngH,m3h1x1(:,189),heltab2x1(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),31,nML,G3tensor(15),n2h1(174))
  call Hloop_AZ_Q(ntryL,G2H3(71),ex4(:),G2H1(16),ngZu,m3h3x1(:,403),heltab2x3(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),31,nMT,G3tensor(16),n2h1(175))
  call Hloop_AS_Q(ntryL,G2H1(63),ex3(:),G2H1(18),ngH,m3h1x1(:,190),heltab2x1(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nMT,G3tensor(17),n2h1(176))
  call Hloop_QZ_A(ntryL,G2H3(72),ex4(:),G2H1(19),ngZd,m3h3x1(:,404),heltab2x3(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(19),31,nMB,G3tensor(18),n2h1(177))
  call Hloop_QS_A(ntryL,G2H1(66),ex3(:),G2H1(21),ngH,m3h1x1(:,191),heltab2x1(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(21),31,nMB,G3tensor(19),n2h1(178))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(3),23,ex4(:),8,G3tensor(20),m3h3x1(:,405),heltab2x3(:,:,536))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(69),ex3(:),G2tensor(60),m3h1x1(:,192),heltab2x1(:,:,192))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(33),23,ex4(:),8,G3tensor(21),m3h3x1(:,406),heltab2x3(:,:,537))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(72),ex3(:),G2tensor(51),m3h1x1(:,193),heltab2x1(:,:,193))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(4),23,ex4(:),8,G3tensor(22),m3h3x1(:,407),heltab2x3(:,:,538))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(75),ex3(:),G2tensor(42),m3h1x1(:,194),heltab2x1(:,:,194))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(29),23,ex4(:),8,G3tensor(23),m3h3x1(:,408),heltab2x3(:,:,539))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(78),ex3(:),G2tensor(26),m3h1x1(:,195),heltab2x1(:,:,195))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(30),23,ex4(:),8,G3tensor(24),m3h3x1(:,409),heltab2x3(:,:,540))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(81),ex3(:),G2tensor(22),m3h1x1(:,196),heltab2x1(:,:,196))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(63),23,ex4(:),8,G3tensor(25),m3h3x1(:,410),heltab2x3(:,:,541))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(84),ex3(:),G2tensor(187),m3h1x1(:,197),heltab2x1(:,:,197))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(66),23,ex4(:),G3tensor(26),m3h3x1(:,411),heltab2x3(:,:,542))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(87),ex3(:),G2tensor(69),m3h1x1(:,198),heltab2x1(:,:,198))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(14),23,ex4(:),G3tensor(27),m3h3x1(:,412),heltab2x3(:,:,543))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(90),ex3(:),G2tensor(63),m3h1x1(:,199),heltab2x1(:,:,199))
  call Hloop_QS_A(ntryL,G2H1(92),ex3(:),G2H1(68),ngH,m3h1x1(:,200),heltab2x1(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(68),31,nML,G3tensor(28),n2h1(179))
  call Hloop_QZ_A(ntryL,G2H3(62),ex4(:),G2H1(74),ngZl,m3h3x1(:,413),heltab2x3(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(74),31,nML,G3tensor(29),n2h1(180))
  call Hloop_AS_Q(ntryL,G2H1(93),ex3(:),G2H1(22),ngH,m3h1x1(:,201),heltab2x1(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),31,nMT,G3tensor(30),n2h1(181))
  call Hloop_AZ_Q(ntryL,G2H3(68),ex4(:),G2H1(24),ngZu,m3h3x1(:,414),heltab2x3(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(24),31,nMT,G3tensor(31),n2h1(182))
  call Hloop_QS_A(ntryL,G2H1(94),ex3(:),G2H1(25),ngH,m3h1x1(:,202),heltab2x1(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(25),31,nMB,G3tensor(32),n2h1(183))
  call Hloop_QZ_A(ntryL,G2H3(74),ex4(:),G2H1(33),ngZd,m3h3x1(:,415),heltab2x3(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(33),31,nMB,G3tensor(33),n2h1(184))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H1(6),27,ex3(:),4,G3tensor(34),m3h1x1(:,203),heltab2x1(:,:,203))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(39),ex4(:),G2tensor(54),m3h3x1(:,416),heltab2x3(:,:,547))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H1(7),27,ex3(:),4,G3tensor(35),m3h1x1(:,204),heltab2x1(:,:,204))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(40),ex4(:),G2tensor(48),m3h3x1(:,417),heltab2x3(:,:,548))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H1(8),27,ex3(:),4,G3tensor(36),m3h1x1(:,205),heltab2x1(:,:,205))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(41),ex4(:),G2tensor(28),m3h3x1(:,418),heltab2x3(:,:,549))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_AW_Q(ntryL,G2H4(1),wf4(:,1),G2H1(77),m3h4x1(:,32),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(77),31,0,G3tensor(37),n2h1(185))
  call Hloop_AZ_Q(ntryL,G2H3(58),ex4(:),G2H1(53),ngZn,m3h3x1(:,419),heltab2x3(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(53),31,0,G3tensor(38),n2h1(186))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_QW_A(ntryL,G2H4(2),wf4(:,1),G2H1(56),m3h4x1(:,33),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(56),31,nMB,G3tensor(39),n2h1(187))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_AW_Q(ntryL,G2H4(3),wf4(:,1),G2H1(48),m3h4x1(:,34),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(48),31,nMT,G3tensor(40),n2h1(188))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(8),28,wf4(:,1),3,G2tensor(24),m3h4x1(:,35),heltab2x4(:,:,58))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(53),ex4(:),G2tensor(182),m3h3x1(:,420),heltab2x3(:,:,551))
call HGT_lower_alpha_w2_OLR(G1H4(9),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(9),2,5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(9),28,wf4(:,1),3,G2tensor(93),m3h4x1(:,36),heltab2x4(:,:,59))
call HGT_lower_alpha_w2_OLR(G1H4(10),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(10),2,5,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(10),28,wf4(:,1),3,G2tensor(87),m3h4x1(:,37),heltab2x4(:,:,60))
call HGT_w2_OLR(G1H4(14),1,1,4)
call HGT_w2_invQ_OLR(G1H4(14),2,5,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(14),28,wf4(:,1),3,G2tensor(81),m3h4x1(:,38),heltab2x4(:,:,61))
  call Hloop_AZ_Q(ntryL,G1H3(130),wf3(:,1),G1H1(34),ngZu,m3h3x1(:,421),heltab2x3(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,0,G2tensor(72),n2h1(189))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(34),m3h2x1(:,76),heltab2x2(:,:,77))
  call Hloop_AZ_Q(ntryL,G1H3(133),wf3(:,1),G1H1(53),ngZd,m3h3x1(:,422),heltab2x3(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(53),31,0,G2tensor(30),n2h1(190))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(184),m3h2x1(:,77),heltab2x2(:,:,78))
  call Hloop_AZ_Q(ntryL,G1H3(132),wf3(:,1),G1H1(47),ngZu,m3h3x1(:,423),heltab2x3(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),31,0,G2tensor(96),n2h1(191))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(90),m3h2x1(:,78),heltab2x2(:,:,79))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(84),ngZd,m3h2x1(:,79),heltab2x2(:,:,80))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(78),m3h2x1(:,80),heltab2x2(:,:,81))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(58),27,ex3(:),4,G2tensor(36),m3h1x1(:,206),heltab2x1(:,:,206))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(149),23,ex4(:),8,G2tensor(32),m3h3x1(:,424),heltab2x3(:,:,555))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(3),27,ex3(:),4,G2tensor(38),m3h1x1(:,207),heltab2x1(:,:,207))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(119),23,ex4(:),8,G2tensor(155),m3h3x1(:,425),heltab2x3(:,:,556))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(93),23,ex4(:),8,G3tensor(41),m3h3x1(:,426),heltab2x3(:,:,557))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(104),23,ex4(:),8,G3tensor(42),m3h3x1(:,427),heltab2x3(:,:,558))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(34),23,ex4(:),8,G2tensor(50),m3h3x1(:,428),heltab2x3(:,:,559))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(117),23,ex4(:),8,G2tensor(41),m3h3x1(:,429),heltab2x3(:,:,560))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(75),23,ex4(:),8,G3tensor(43),m3h3x1(:,430),heltab2x3(:,:,561))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(80),23,ex4(:),8,G3tensor(44),m3h3x1(:,431),heltab2x3(:,:,562))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(110),23,ex4(:),8,G3tensor(45),m3h3x1(:,432),heltab2x3(:,:,563))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(92),23,ex4(:),8,G3tensor(46),m3h3x1(:,433),heltab2x3(:,:,564))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(46),27,ex3(:),4,G2tensor(154),m3h1x1(:,208),heltab2x1(:,:,208))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(44),27,ex3(:),4,G2tensor(44),m3h1x1(:,209),heltab2x1(:,:,209))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(29),27,ex3(:),4,G2tensor(45),m3h1x1(:,210),heltab2x1(:,:,210))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(56),27,ex3(:),4,G2tensor(156),m3h1x1(:,211),heltab2x1(:,:,211))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(43),27,ex3(:),4,G2tensor(53),m3h1x1(:,212),heltab2x1(:,:,212))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(55),27,ex3(:),4,G2tensor(47),m3h1x1(:,213),heltab2x1(:,:,213))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(12),27,ex3(:),4,G2tensor(56),m3h1x1(:,214),heltab2x1(:,:,214))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(18),27,ex3(:),4,G2tensor(160),m3h1x1(:,215),heltab2x1(:,:,215))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(33),27,ex3(:),4,G2tensor(65),m3h1x1(:,216),heltab2x1(:,:,216))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(42),27,ex3(:),4,G2tensor(59),m3h1x1(:,217),heltab2x1(:,:,217))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(149),m3h1x1(:,218),heltab2x1(:,:,218))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(62),27,ex3(:),4,G2tensor(68),m3h1x1(:,219),heltab2x1(:,:,219))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(55),23,ex4(:),8,G2tensor(62),m3h3x1(:,434),heltab2x3(:,:,565))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(77),23,ex4(:),8,G3tensor(47),m3h3x1(:,435),heltab2x3(:,:,566))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(78),23,ex4(:),8,G3tensor(48),m3h3x1(:,436),heltab2x3(:,:,567))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(67),23,ex4(:),8,G2tensor(158),m3h3x1(:,437),heltab2x3(:,:,568))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(83),23,ex4(:),8,G3tensor(49),m3h3x1(:,438),heltab2x3(:,:,569))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(86),23,ex4(:),8,G3tensor(50),m3h3x1(:,439),heltab2x3(:,:,570))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(162),23,ex4(:),G2tensor(80),m3h3x1(:,440),heltab2x3(:,:,571))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(89),23,ex4(:),G3tensor(51),m3h3x1(:,441),heltab2x3(:,:,572))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(90),23,ex4(:),G3tensor(52),m3h3x1(:,442),heltab2x3(:,:,573))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(12),23,ex4(:),8,G2tensor(71),m3h3x1(:,443),heltab2x3(:,:,574))
  call Hloop_QZ_A(ntryL,G1H3(115),wf3(:,1),G1H1(84),ngZd,m3h3x1(:,444),heltab2x3(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(84),31,0,G2tensor(157),n2h1(192))
  call Hloop_QZ_A(ntryL,G2H3(48),wf3(:,1),G2H1(51),ngZd,m3h3x1(:,445),heltab2x3(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(51),31,0,G3tensor(53),n2h1(193))
  call Hloop_QZ_A(ntryL,G1H3(147),wf3(:,1),G1H1(28),ngZd,m3h3x1(:,446),heltab2x3(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,0,G2tensor(74),n2h1(194))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(70),19,wf3(:,1),12,G2tensor(75),m3h3x1(:,447),heltab2x3(:,:,578))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(10),19,wf3(:,1),12,G3tensor(54),m3h3x1(:,448),heltab2x3(:,:,579))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(1),19,wf3(:,1),12,G3tensor(55),m3h3x1(:,449),heltab2x3(:,:,580))
  call Hloop_AZ_Q(ntryL,G2H3(46),wf3(:,1),G2H1(55),ngZu,m3h3x1(:,450),heltab2x3(:,:,581))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(55),31,0,G3tensor(56),n2h1(195))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(252),19,wf3(:,1),12,G2tensor(159),m3h3x1(:,451),heltab2x3(:,:,582))
  call Hloop_AZ_Q(ntryL,G2H3(24),ex4(:),G2H1(58),ngZu,m3h3x1(:,452),heltab2x3(:,:,583))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(58),31,0,G3tensor(57),n2h1(196))
  call Hloop_QZ_A(ntryL,G1H3(37),ex4(:),G1H1(87),ngZd,m3h3x1(:,453),heltab2x3(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(87),31,0,G2tensor(83),n2h1(197))
  call Hloop_QZ_A(ntryL,G2H3(35),ex4(:),G2H1(59),ngZd,m3h3x1(:,454),heltab2x3(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(59),31,0,G3tensor(58),n2h1(198))
  call Hloop_QZ_A(ntryL,G1H3(109),ex4(:),G1H1(36),ngZd,m3h3x1(:,455),heltab2x3(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),31,0,G2tensor(77),n2h1(199))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(31),27,ex3(:),4,G2tensor(161),m3h1x1(:,220),heltab2x1(:,:,220))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H1(10),27,ex3(:),4,G3tensor(59),m3h1x1(:,221),heltab2x1(:,:,221))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(68),27,ex3(:),4,G2tensor(92),m3h1x1(:,222),heltab2x1(:,:,222))
  call Hloop_QS_A(ntryL,G2H1(30),ex3(:),G2H1(61),ngH,m3h1x1(:,223),heltab2x1(:,:,223))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(61),31,nML,G3tensor(60),n2h1(200))
  call Hloop_AS_Q(ntryL,G2H1(31),ex3(:),G2H1(14),ngH,m3h1x1(:,224),heltab2x1(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),31,nMT,G3tensor(61),n2h1(201))
  call Hloop_QS_A(ntryL,G2H1(28),ex3(:),G2H1(62),ngH,m3h1x1(:,225),heltab2x1(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(62),31,nMB,G3tensor(62),n2h1(202))
  call Hloop_QZ_A(ntryL,G2H3(12),ex4(:),G2H1(64),ngZl,m3h3x1(:,456),heltab2x3(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(64),31,nML,G3tensor(63),n2h1(203))
  call Hloop_AZ_Q(ntryL,G2H3(25),ex4(:),G2H1(32),ngZu,m3h3x1(:,457),heltab2x3(:,:,588))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(32),31,nMT,G3tensor(64),n2h1(204))
  call Hloop_QZ_A(ntryL,G2H3(15),ex4(:),G2H1(65),ngZd,m3h3x1(:,458),heltab2x3(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(65),31,nMB,G3tensor(65),n2h1(205))
  call Hloop_AZ_Q(ntryL,G2H3(5),ex4(:),G2H1(67),ngZn,m3h3x1(:,459),heltab2x3(:,:,590))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(67),31,0,G3tensor(66),n2h1(206))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(21),ex2(:),G2tensor(86),ngZd,m3h2x1(:,81),heltab2x2(:,:,82))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(147),m3h2x1(:,82),heltab2x2(:,:,83))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(22),ex4(:),G2tensor(95),m3h3x1(:,460),heltab2x3(:,:,591))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(29),ex3(:),G2tensor(89),m3h1x1(:,226),heltab2x1(:,:,226))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(27),ex3(:),G2tensor(99),m3h1x1(:,227),heltab2x1(:,:,227))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(40),ex3(:),G2tensor(101),m3h1x1(:,228),heltab2x1(:,:,228))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(42),ex3(:),G2tensor(104),m3h1x1(:,229),heltab2x1(:,:,229))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(43),ex3(:),G2tensor(107),m3h1x1(:,230),heltab2x1(:,:,230))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(44),ex3(:),G2tensor(108),m3h1x1(:,231),heltab2x1(:,:,231))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(18),ex4(:),G2tensor(110),m3h3x1(:,461),heltab2x3(:,:,592))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(20),ex4(:),G2tensor(113),m3h3x1(:,462),heltab2x3(:,:,593))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(26),ex4(:),G2tensor(169),m3h3x1(:,463),heltab2x3(:,:,594))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(27),ex4(:),G2tensor(11),m3h3x1(:,464),heltab2x3(:,:,595))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(102),ex4(:),G2tensor(33),m3h3x1(:,465),heltab2x3(:,:,596))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(105),ex4(:),G2tensor(312),m3h3x1(:,466),heltab2x3(:,:,597))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(24),ex2(:),G2tensor(276),m3h2x1(:,83),heltab2x2(:,:,84))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(267),m3h2x1(:,84),heltab2x2(:,:,85))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(167),ngZd,m3h2x1(:,85),heltab2x2(:,:,86))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(88),m3h2x1(:,86),heltab2x2(:,:,87))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(101),23,ex4(:),8,G3tensor(67),m3h3x1(:,467),heltab2x3(:,:,598))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(107),23,ex4(:),8,G3tensor(68),m3h3x1(:,468),heltab2x3(:,:,599))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(113),ex4(:),wf4(:,1),G1tensor(117),m4h3x4x1(:,1),heltab3x12(:,:,9))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(41),ex4(:),wf4(:,1),G1tensor(80),m4h3x4x1(:,2),heltab3x12(:,:,10))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(46),ex4(:),wf4(:,1),G1tensor(110),m4h3x4x1(:,3),heltab3x12(:,:,11))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(21),ex4(:),wf4(:,1),G1tensor(26),m4h3x4x1(:,4),heltab3x12(:,:,12))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(112),ex4(:),wf4(:,1),G1tensor(20),m4h3x4x1(:,5),heltab3x12(:,:,13))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(51),wf4(:,1),ex4(:),G1tensor(93),m4h4x3x1(:,1),heltab3x12(:,:,14))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(114),wf4(:,1),ex4(:),G1tensor(9),m4h4x3x1(:,2),heltab3x12(:,:,15))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(45),ex3(:),G2tensor(70),m3h1x1(:,232),heltab2x1(:,:,232))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(46),ex3(:),G2tensor(315),m3h1x1(:,233),heltab2x1(:,:,233))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(47),ex3(:),G2tensor(279),m3h1x1(:,234),heltab2x1(:,:,234))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(49),ex3(:),G2tensor(273),m3h1x1(:,235),heltab2x1(:,:,235))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(50),ex3(:),G2tensor(171),m3h1x1(:,236),heltab2x1(:,:,236))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(52),ex3(:),G2tensor(168),m3h1x1(:,237),heltab2x1(:,:,237))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(34),ex3(:),G2tensor(7),m3h1x1(:,238),heltab2x1(:,:,238))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(57),27,ex3(:),4,G2tensor(29),m3h1x1(:,239),heltab2x1(:,:,239))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(24),27,ex3(:),4,G2tensor(64),m3h1x1(:,240),heltab2x1(:,:,240))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(144),23,ex4(:),8,G2tensor(43),m3h3x1(:,469),heltab2x3(:,:,600))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(28),ex4(:),G2tensor(282),m3h3x1(:,470),heltab2x3(:,:,601))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(31),ex4(:),G2tensor(213),m3h3x1(:,471),heltab2x3(:,:,602))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(202),23,ex4(:),8,G2tensor(209),m3h3x1(:,472),heltab2x3(:,:,603))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(21),ex4(:),ex3(:),G1tensor(16),m4h3x1x1(:,7),heltab3x3(:,:,7))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(101),ex4(:),ex3(:),G1tensor(40),m4h3x1x1(:,8),heltab3x3(:,:,8))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H3(83),ex3(:),ex4(:),G1tensor(46),m4h1x3x1(:,1),heltab3x3(:,:,9))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H3(38),ex3(:),ex4(:),G1tensor(128),m4h1x3x1(:,2),heltab3x3(:,:,10))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(136),ex4(:),ex3(:),G1tensor(112),m4h3x1x1(:,9),heltab3x3(:,:,11))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(190),ex4(:),ex3(:),G1tensor(6),m4h3x1x1(:,10),heltab3x3(:,:,12))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H3(47),ex3(:),ex4(:),G1tensor(12),m4h1x3x1(:,3),heltab3x3(:,:,13))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H3(4),ex3(:),ex4(:),G1tensor(29),m4h1x3x1(:,4),heltab3x3(:,:,14))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(165),m3h2x1(:,87),heltab2x2(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(49),m3h2x1(:,88),heltab2x2(:,:,89))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(18),ex2(:),G2tensor(23),m3h2x1(:,89),heltab2x2(:,:,90))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(285),ngZd,m3h2x1(:,90),heltab2x2(:,:,91))
  call Hloop_QS_A(ntryL,G2H3(55),wf3(:,7),G2H1(17),ngX,m3h3x1(:,473),heltab2x3(:,:,604))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,nML,G3tensor(69),n2h1(207))
  call Hloop_AS_Q(ntryL,G2H3(56),wf3(:,7),G2H1(70),ngX,m3h3x1(:,474),heltab2x3(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(70),31,nMT,G3tensor(70),n2h1(208))
  call Hloop_QS_A(ntryL,G2H3(34),wf3(:,7),G2H1(71),ngX,m3h3x1(:,475),heltab2x3(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(71),31,nMB,G3tensor(71),n2h1(209))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(37),wf3(:,7),G2tensor(215),m3h3x1(:,476),heltab2x3(:,:,607))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(59),wf3(:,7),G2tensor(211),m3h3x1(:,477),heltab2x3(:,:,608))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(60),wf3(:,7),G2tensor(166),m3h3x1(:,478),heltab2x3(:,:,609))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(32),wf3(:,7),G2tensor(164),m3h3x1(:,479),heltab2x3(:,:,610))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(11),wf3(:,7),G2tensor(52),m3h3x1(:,480),heltab2x3(:,:,611))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(7),wf3(:,7),G2tensor(58),m3h3x1(:,481),heltab2x3(:,:,612))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H3(143),19,wf3(:,7),12,G2tensor(37),m3h3x1(:,482),heltab2x3(:,:,613))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(192),19,wf3(:,7),12,G2tensor(79),m3h3x1(:,483),heltab2x3(:,:,614))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H3(75),19,wf3(:,7),12,G2tensor(82),m3h3x1(:,484),heltab2x3(:,:,615))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H3(65),19,wf3(:,7),12,G2tensor(76),m3h3x1(:,485),heltab2x3(:,:,616))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(46),19,wf3(:,7),12,G2tensor(1),m3h3x1(:,486),heltab2x3(:,:,617))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(59),19,wf3(:,7),12,G2tensor(31),m3h3x1(:,487),heltab2x3(:,:,618))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H3(183),19,wf3(:,7),12,G2tensor(15),m3h3x1(:,488),heltab2x3(:,:,619))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H3(78),19,wf3(:,7),12,G2tensor(9),m3h3x1(:,489),heltab2x3(:,:,620))
  call Hloop_AZ_Q(ntryL,G2H3(13),wf3(:,1),G2H1(73),ngZn,m3h3x1(:,490),heltab2x3(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(73),31,0,G3tensor(72),n2h1(210))
  call Hloop_AZ_Q(ntryL,G2H3(16),wf3(:,1),G2H1(76),ngZn,m3h3x1(:,491),heltab2x3(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(76),31,0,G3tensor(73),n2h1(211))
  call Hloop_QZ_A(ntryL,G2H3(21),wf3(:,1),G2H1(79),ngZl,m3h3x1(:,492),heltab2x3(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(79),31,0,G3tensor(74),n2h1(212))
  call Hloop_QZ_A(ntryL,G2H3(45),wf3(:,1),G2H1(80),ngZl,m3h3x1(:,493),heltab2x3(:,:,624))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(80),31,nML,G3tensor(75),n2h1(213))
  call Hloop_AZ_Q(ntryL,G2H3(47),wf3(:,1),G2H1(82),ngZu,m3h3x1(:,494),heltab2x3(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(82),31,nMT,G3tensor(76),n2h1(214))
  call Hloop_QZ_A(ntryL,G2H3(49),wf3(:,1),G2H1(83),ngZd,m3h3x1(:,495),heltab2x3(:,:,626))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(83),31,nMB,G3tensor(77),n2h1(215))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(43),19,wf3(:,1),12,G3tensor(78),m3h3x1(:,496),heltab2x3(:,:,627))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(44),19,wf3(:,1),12,G3tensor(79),m3h3x1(:,497),heltab2x3(:,:,628))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(8),19,wf3(:,1),12,G3tensor(80),m3h3x1(:,498),heltab2x3(:,:,629))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(9),19,wf3(:,1),12,G3tensor(81),m3h3x1(:,499),heltab2x3(:,:,630))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(50),19,wf3(:,1),12,G3tensor(82),m3h3x1(:,500),heltab2x3(:,:,631))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(51),19,wf3(:,1),12,G3tensor(83),m3h3x1(:,501),heltab2x3(:,:,632))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(52),19,wf3(:,1),G3tensor(84),m3h3x1(:,502),heltab2x3(:,:,633))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(17),19,wf3(:,1),G3tensor(85),m3h3x1(:,503),heltab2x3(:,:,634))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(217),wf3(:,1),G1tensor(97),m3h3x1(:,504),heltab2x3(:,:,635))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(33),wf3(:,1),G1tensor(31),m3h3x1(:,505),heltab2x3(:,:,636))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(169),wf3(:,1),G1tensor(43),m3h3x1(:,506),heltab2x3(:,:,637))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(172),wf3(:,1),G1tensor(55),m3h3x1(:,507),heltab2x3(:,:,638))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H3(2),19,wf3(:,1),12,G1tensor(66),m3h3x1(:,508),heltab2x3(:,:,639))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(17),19,wf3(:,1),12,G1tensor(73),m3h3x1(:,509),heltab2x3(:,:,640))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(167),wf3(:,1),G1tensor(88),m3h3x1(:,510),heltab2x3(:,:,641))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(191),wf3(:,1),G1tensor(95),m3h3x1(:,511),heltab2x3(:,:,642))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(54),wf3(:,1),G1tensor(108),m3h3x1(:,512),heltab2x3(:,:,643))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(112),wf3(:,1),G1tensor(120),m3h3x1(:,513),heltab2x3(:,:,644))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(170),ex4(:),G1tensor(132),m3h3x1(:,514),heltab2x3(:,:,645))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(163),ex4(:),G1tensor(11),m3h3x1(:,515),heltab2x3(:,:,646))
  call Hloop_AZ_Q(ntryL,G2H3(87),ex4(:),G2H1(85),ngZn,m3h3x1(:,516),heltab2x3(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(85),31,0,G3tensor(86),n2h1(216))
  call Hloop_QZ_A(ntryL,G2H3(23),ex4(:),G2H1(86),ngZl,m3h3x1(:,517),heltab2x3(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(86),31,0,G3tensor(87),n2h1(217))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(1),ex3(:),G2tensor(100),m3h1x1(:,241),heltab2x1(:,:,241))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(61),m3h1x1(:,242),heltab2x1(:,:,242))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(3),ex3(:),G2tensor(103),m3h1x1(:,243),heltab2x1(:,:,243))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(4),ex3(:),G2tensor(27),m3h1x1(:,244),heltab2x1(:,:,244))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(5),ex3(:),G2tensor(40),m3h1x1(:,245),heltab2x1(:,:,245))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(45),ex3(:),G1tensor(136),m3h1x1(:,246),heltab2x1(:,:,246))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(5),ex3(:),G1tensor(141),m3h1x1(:,247),heltab2x1(:,:,247))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(12),ex3(:),G2tensor(85),m3h1x1(:,248),heltab2x1(:,:,248))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(92),ex4(:),G1tensor(146),m3h3x1(:,518),heltab2x3(:,:,649))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(189),ex4(:),G1tensor(151),m3h3x1(:,519),heltab2x3(:,:,650))
  call Hloop_AZ_Q(ntryL,G2H3(57),ex4(:),G2H1(88),ngZn,m3h3x1(:,520),heltab2x3(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(88),31,0,G3tensor(88),n2h1(218))
  call Hloop_QZ_A(ntryL,G2H3(61),ex4(:),G2H1(89),ngZl,m3h3x1(:,521),heltab2x3(:,:,652))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(89),31,0,G3tensor(89),n2h1(219))
  call Hloop_AZ_Q(ntryL,G2H3(65),ex4(:),G2H1(91),ngZu,m3h3x1(:,522),heltab2x3(:,:,653))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(91),31,0,G3tensor(90),n2h1(220))
  call Hloop_QZ_A(ntryL,G2H3(69),ex4(:),G2H1(35),ngZd,m3h3x1(:,523),heltab2x3(:,:,654))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(35),31,0,G3tensor(91),n2h1(221))
  call Hloop_AS_Q(ntryL,G2H12(8),wf12(:,2),G2H1(20),ngPln,m3h12x1(:,1),heltab2x12(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),31,0,G3tensor(92),n2h1(222))
  call Hloop_QS_A(ntryL,G2H12(4),wf12(:,2),G2H1(23),ngPbt,m3h12x1(:,2),heltab2x12(:,:,619))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMB,G3tensor(93),n2h1(223))
  call Hloop_AS_Q(ntryL,G2H12(5),wf12(:,2),G2H1(38),ngPbt,m3h12x1(:,3),heltab2x12(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(38),31,nMT,G3tensor(94),n2h1(224))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(239),wf12(:,2),G1tensor(156),m3h12x1(:,4),heltab2x12(:,:,621))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(56),wf12(:,2),G1tensor(161),m3h12x1(:,5),heltab2x12(:,:,622))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(115),wf12(:,2),G1tensor(166),m3h12x1(:,6),heltab2x12(:,:,623))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(8),wf12(:,2),G1tensor(171),m3h12x1(:,7),heltab2x12(:,:,624))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(119),wf12(:,2),G1tensor(176),m3h12x1(:,8),heltab2x12(:,:,625))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(126),wf12(:,2),G1tensor(181),m3h12x1(:,9),heltab2x12(:,:,626))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(93),wf12(:,2),G1tensor(186),m3h12x1(:,10),heltab2x12(:,:,627))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(124),wf12(:,2),G1tensor(191),m3h12x1(:,11),heltab2x12(:,:,628))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(57),wf12(:,2),G1tensor(196),m3h12x1(:,12),heltab2x12(:,:,629))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(58),wf12(:,2),G1tensor(201),m3h12x1(:,13),heltab2x12(:,:,630))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H12(1),20,wf12(:,2),11,G3tensor(95),m3h12x1(:,14),heltab2x12(:,:,631))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H12(3),20,wf12(:,2),11,G3tensor(96),m3h12x1(:,15),heltab2x12(:,:,632))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H12(85),20,wf12(:,2),11,G1tensor(206),m3h12x1(:,16),heltab2x12(:,:,633))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H12(6),20,wf12(:,2),11,G3tensor(97),m3h12x1(:,17),heltab2x12(:,:,634))
  call Hcheck_last_VS_T(ntryL,l_switch,G2H12(7),20,wf12(:,2),11,G3tensor(98),m3h12x1(:,18),heltab2x12(:,:,635))
  call Hcheck_last_VS_T(ntryL,l_switch,G2H12(9),20,wf12(:,2),11,G3tensor(99),m3h12x1(:,19),heltab2x12(:,:,636))
  call Hcheck_last_TS_V(ntryL,l_switch,G2H12(2),20,wf12(:,2),11,G3tensor(100),m3h12x1(:,20),heltab2x12(:,:,637))
  call Hloop_AW_Q(ntryL,G2H12(10),wf12(:,3),G2H1(26),m3h12x1(:,21),heltab2x12(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(26),31,0,G3tensor(101),n2h1(225))
  call Hloop_QW_A(ntryL,G2H12(11),wf12(:,3),G2H1(41),m3h12x1(:,22),heltab2x12(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(41),31,nMB,G3tensor(102),n2h1(226))
  call Hloop_AW_Q(ntryL,G2H12(12),wf12(:,3),G2H1(36),m3h12x1(:,23),heltab2x12(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(36),31,nMT,G3tensor(103),n2h1(227))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(11),20,wf12(:,3),11,G2tensor(339),m3h12x1(:,24),heltab2x12(:,:,641))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(67),20,wf12(:,3),11,G2tensor(336),m3h12x1(:,25),heltab2x12(:,:,642))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(68),20,wf12(:,3),11,G2tensor(264),m3h12x1(:,26),heltab2x12(:,:,643))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(62),20,wf12(:,3),11,G2tensor(173),m3h12x1(:,27),heltab2x12(:,:,644))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(121),20,wf12(:,3),11,G2tensor(21),m3h12x1(:,28),heltab2x12(:,:,645))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(122),20,wf12(:,3),G2tensor(19),m3h12x1(:,29),heltab2x12(:,:,646))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(123),20,wf12(:,3),G2tensor(116),m3h12x1(:,30),heltab2x12(:,:,647))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(125),20,wf12(:,3),G2tensor(117),m3h12x1(:,31),heltab2x12(:,:,648))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(110),20,wf12(:,3),11,G2tensor(118),m3h12x1(:,32),heltab2x12(:,:,649))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(63),20,wf12(:,3),11,G2tensor(122),m3h12x1(:,33),heltab2x12(:,:,650))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(64),20,wf12(:,3),11,G2tensor(123),m3h12x1(:,34),heltab2x12(:,:,651))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(69),20,wf12(:,3),11,G2tensor(124),m3h12x1(:,35),heltab2x12(:,:,652))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(70),20,wf12(:,3),11,G2tensor(297),m3h12x1(:,36),heltab2x12(:,:,653))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(15),wf12(:,3),G2tensor(163),m3h12x1(:,37),heltab2x12(:,:,654))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(16),wf12(:,3),G2tensor(294),m3h12x1(:,38),heltab2x12(:,:,655))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(64),wf12(:,3),G0tensor(10),m3h12x1(:,39),heltab2x12(:,:,656))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(13),wf12(:,3),G2tensor(205),m3h12x1(:,40),heltab2x12(:,:,657))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(14),wf12(:,3),G2tensor(309),m3h12x1(:,41),heltab2x12(:,:,658))
  call Hloop_AZ_Q(ntryL,G2H3(95),ex4(:),G2H1(37),ngZl,m3h3x1(:,524),heltab2x3(:,:,655))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(37),31,nML,G3tensor(104),n2h1(228))
  call Hloop_QZ_A(ntryL,G2H3(96),ex4(:),G2H1(39),ngZu,m3h3x1(:,525),heltab2x3(:,:,656))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(39),31,nMT,G3tensor(105),n2h1(229))
  call Hloop_AZ_Q(ntryL,G2H3(98),ex4(:),G2H1(9),ngZd,m3h3x1(:,526),heltab2x3(:,:,657))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(9),31,nMB,G3tensor(106),n2h1(230))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(16),ex4(:),G0tensor(15),m3h3x1(:,527),heltab2x3(:,:,658))
  call Hloop_ZA_Q(ntryL,G0H6(21),wf6(:,2),G0H1(3),ngZu,m3h6x1(:,19),heltab2x6(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(3),31,0,G1tensor(211),n2h1(231))
  call Hloop_WA_Q(ntryL,G0H6(3),wf6(:,2),G0H1(2),m3h6x1(:,20),heltab2x6(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(2),31,0,G1tensor(216),n2h1(232))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(31),wf6(:,2),G2tensor(170),m3h6x1(:,21),heltab2x6(:,:,238))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(18),wf6(:,2),G2tensor(172),m3h6x1(:,22),heltab2x6(:,:,239))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(19),wf6(:,2),G2tensor(2),ngZu,m3h6x1(:,23),heltab2x6(:,:,240))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(20),wf6(:,2),G2tensor(181),m3h6x1(:,24),heltab2x6(:,:,241))
  call Hloop_VA_Q(ntryL,G1H6(11),wf6(:,2),G1H1(60),m3h6x1(:,25),heltab2x6(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(60),31,0,G2tensor(6),n2h1(233))
  call Hloop_ZA_Q(ntryL,G1H6(5),wf6(:,2),G1H1(40),ngZu,m3h6x1(:,26),heltab2x6(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(40),31,0,G2tensor(177),n2h1(234))
  call Hloop_AW_Q(ntryL,G2H12(17),wf12(:,4),G2H1(11),m3h12x1(:,42),heltab2x12(:,:,659))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),31,0,G3tensor(107),n2h1(235))
  call Hloop_QW_A(ntryL,G2H12(18),wf12(:,4),G2H1(54),m3h12x1(:,43),heltab2x12(:,:,660))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(54),31,nMB,G3tensor(108),n2h1(236))
  call Hloop_AW_Q(ntryL,G2H12(19),wf12(:,4),G2H1(57),m3h12x1(:,44),heltab2x12(:,:,661))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(57),31,nMT,G3tensor(109),n2h1(237))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(74),20,wf12(:,4),11,G2tensor(10),m3h12x1(:,45),heltab2x12(:,:,662))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(87),20,wf12(:,4),11,G2tensor(102),m3h12x1(:,46),heltab2x12(:,:,663))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(88),20,wf12(:,4),11,G2tensor(105),m3h12x1(:,47),heltab2x12(:,:,664))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(77),20,wf12(:,4),11,G2tensor(16),m3h12x1(:,48),heltab2x12(:,:,665))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(78),20,wf12(:,4),11,G2tensor(111),m3h12x1(:,49),heltab2x12(:,:,666))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(79),20,wf12(:,4),G2tensor(114),m3h12x1(:,50),heltab2x12(:,:,667))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(80),20,wf12(:,4),G2tensor(363),m3h12x1(:,51),heltab2x12(:,:,668))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(81),20,wf12(:,4),G2tensor(366),m3h12x1(:,52),heltab2x12(:,:,669))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(82),20,wf12(:,4),11,G2tensor(351),m3h12x1(:,53),heltab2x12(:,:,670))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(83),20,wf12(:,4),11,G2tensor(354),m3h12x1(:,54),heltab2x12(:,:,671))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(84),20,wf12(:,4),11,G2tensor(127),m3h12x1(:,55),heltab2x12(:,:,672))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(89),20,wf12(:,4),11,G2tensor(240),m3h12x1(:,56),heltab2x12(:,:,673))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(90),20,wf12(:,4),11,G2tensor(381),m3h12x1(:,57),heltab2x12(:,:,674))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(22),wf12(:,4),G2tensor(186),m3h12x1(:,58),heltab2x12(:,:,675))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(23),wf12(:,4),G2tensor(243),m3h12x1(:,59),heltab2x12(:,:,676))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(86),wf12(:,4),G0tensor(20),m3h12x1(:,60),heltab2x12(:,:,677))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(20),wf12(:,4),G2tensor(131),m3h12x1(:,61),heltab2x12(:,:,678))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(21),wf12(:,4),G2tensor(246),m3h12x1(:,62),heltab2x12(:,:,679))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(73),ex3(:),G1tensor(221),m3h1x1(:,249),heltab2x1(:,:,249))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(78),ex3(:),G1tensor(226),m3h1x1(:,250),heltab2x1(:,:,250))
  call Hloop_ZQ_A(ntryL,G0H6(9),wf6(:,4),G0H1(1),ngZd,m3h6x1(:,27),heltab2x6(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(231),n2h1(238))
  call Hloop_WQ_A(ntryL,G0H6(13),wf6(:,4),G0H1(3),m3h6x1(:,28),heltab2x6(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(3),31,0,G1tensor(236),n2h1(239))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(21),wf6(:,4),G2tensor(249),m3h6x1(:,29),heltab2x6(:,:,246))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(22),wf6(:,4),G2tensor(252),m3h6x1(:,30),heltab2x6(:,:,247))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(23),wf6(:,4),G2tensor(384),m3h6x1(:,31),heltab2x6(:,:,248))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H6(1),wf6(:,4),G2tensor(183),ngZd,m3h6x1(:,32),heltab2x6(:,:,249))
  call Hloop_VQ_A(ntryL,G1H6(44),wf6(:,4),G1H1(88),m3h6x1(:,33),heltab2x6(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),31,0,G2tensor(255),n2h1(240))
  call Hloop_ZQ_A(ntryL,G1H6(46),wf6(:,4),G1H1(39),ngZd,m3h6x1(:,34),heltab2x6(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,0,G2tensor(258),n2h1(241))
  call Hloop_AW_Q(ntryL,G2H12(24),wf12(:,5),G2H1(13),m3h12x1(:,63),heltab2x12(:,:,680))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,0,G3tensor(110),n2h1(242))
  call Hloop_QW_A(ntryL,G2H12(25),wf12(:,5),G2H1(60),m3h12x1(:,64),heltab2x12(:,:,681))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(60),31,nMB,G3tensor(111),n2h1(243))
  call Hloop_AW_Q(ntryL,G2H12(26),wf12(:,5),G2H1(15),m3h12x1(:,65),heltab2x12(:,:,682))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMT,G3tensor(112),n2h1(244))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(94),20,wf12(:,5),11,G2tensor(261),m3h12x1(:,66),heltab2x12(:,:,683))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(118),20,wf12(:,5),11,G2tensor(98),m3h12x1(:,67),heltab2x12(:,:,684))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(28),20,wf12(:,5),11,G2tensor(174),m3h12x1(:,68),heltab2x12(:,:,685))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(100),20,wf12(:,5),11,G2tensor(135),m3h12x1(:,69),heltab2x12(:,:,686))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(99),20,wf12(:,5),11,G2tensor(137),m3h12x1(:,70),heltab2x12(:,:,687))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(101),20,wf12(:,5),G2tensor(190),m3h12x1(:,71),heltab2x12(:,:,688))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(102),20,wf12(:,5),G2tensor(178),m3h12x1(:,72),heltab2x12(:,:,689))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(103),20,wf12(:,5),G2tensor(193),m3h12x1(:,73),heltab2x12(:,:,690))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(104),20,wf12(:,5),11,G2tensor(195),m3h12x1(:,74),heltab2x12(:,:,691))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(105),20,wf12(:,5),11,G2tensor(35),m3h12x1(:,75),heltab2x12(:,:,692))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(106),20,wf12(:,5),11,G2tensor(270),m3h12x1(:,76),heltab2x12(:,:,693))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(109),20,wf12(:,5),11,G2tensor(3),m3h12x1(:,77),heltab2x12(:,:,694))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(30),20,wf12(:,5),11,G2tensor(142),m3h12x1(:,78),heltab2x12(:,:,695))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(29),wf12(:,5),G2tensor(318),m3h12x1(:,79),heltab2x12(:,:,696))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(30),wf12(:,5),G2tensor(13),m3h12x1(:,80),heltab2x12(:,:,697))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(44),wf12(:,5),G0tensor(25),m3h12x1(:,81),heltab2x12(:,:,698))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(27),wf12(:,5),G2tensor(321),m3h12x1(:,82),heltab2x12(:,:,699))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(28),wf12(:,5),G2tensor(17),m3h12x1(:,83),heltab2x12(:,:,700))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(79),ex3(:),G1tensor(241),m3h1x1(:,251),heltab2x1(:,:,251))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(75),ex3(:),G1tensor(246),m3h1x1(:,252),heltab2x1(:,:,252))
  call Hloop_QZ_A(ntryL,G1H3(160),wf3(:,1),G1H1(91),ngZu,m3h3x1(:,528),heltab2x3(:,:,659))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(91),31,0,G2tensor(143),n2h1(245))
  call Hloop_VA_Q(ntryL,G1H6(47),wf6(:,35),G1H1(49),m3h6x1(:,35),heltab2x6(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(49),31,0,G2tensor(288),n2h1(246))
  call Hloop_ZA_Q(ntryL,G1H6(27),wf6(:,35),G1H1(41),ngZu,m3h6x1(:,36),heltab2x6(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,0,G2tensor(67),n2h1(247))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(2),wf6(:,35),G2tensor(291),m3h6x1(:,37),heltab2x6(:,:,254))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(4),wf6(:,35),G2tensor(73),m3h6x1(:,38),heltab2x6(:,:,255))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(5),wf6(:,35),G2tensor(91),ngZu,m3h6x1(:,39),heltab2x6(:,:,256))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(6),wf6(:,35),G2tensor(94),m3h6x1(:,40),heltab2x6(:,:,257))
  call Hloop_VQ_A(ntryL,G1H6(33),wf6(:,31),G1H1(21),m3h6x1(:,41),heltab2x6(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,0,G2tensor(144),n2h1(248))
  call Hloop_ZQ_A(ntryL,G1H6(9),wf6(:,31),G1H1(25),ngZd,m3h6x1(:,42),heltab2x6(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,0,G2tensor(5),n2h1(249))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(8),wf6(:,31),G2tensor(55),m3h6x1(:,43),heltab2x6(:,:,260))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(9),wf6(:,31),G2tensor(145),m3h6x1(:,44),heltab2x6(:,:,261))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(10),wf6(:,31),G2tensor(109),m3h6x1(:,45),heltab2x6(:,:,262))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H6(12),wf6(:,31),G2tensor(112),ngZd,m3h6x1(:,46),heltab2x6(:,:,263))
  call Hloop_VQ_A(ntryL,G1H2(6),ex2(:),G1H1(61),m3h2x1(:,91),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),31,0,G2tensor(125),n2h1(250))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex2(:),G1H1(27),ngZd,m3h2x1(:,92),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,0,G2tensor(146),n2h1(251))
  call Hloop_QZ_A(ntryL,G1H3(114),ex4(:),G1H1(19),ngZu,m3h3x1(:,529),heltab2x3(:,:,660))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,0,G2tensor(126),n2h1(252))
  call ol_merge_tensors(G2tensor(183),[G2tensor(192),G1tensor(488),G1tensor(387),G1tensor(375),G0tensor(497),G0tensor(396) &
    ,G0tensor(384)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(260),G2tensor(194),G1tensor(277),G1tensor(175),G1tensor(135),G0tensor(286) &
    ,G0tensor(184),G0tensor(144)])
  call ol_merge_tensors(G2tensor(384),[G2tensor(263),G2tensor(196),G1tensor(282),G1tensor(180),G1tensor(140),G1tensor(92) &
    ,G0tensor(291),G0tensor(189),G0tensor(149),G0tensor(17)])
  call ol_merge_tensors(G3tensor(84),[G3tensor(82),G3tensor(54),G2tensor(15),G2tensor(1),G2tensor(52),G2tensor(166),G2tensor(320) &
    ,G2tensor(314),G2tensor(290),G2tensor(284),G2tensor(278),G2tensor(269),G2tensor(214),G2tensor(210),G2tensor(199),G2tensor(197) &
    ,G1tensor(108),G1tensor(88),G1tensor(66),G1tensor(12),G1tensor(112),G1tensor(230),G1tensor(205),G1tensor(57),G1tensor(130) &
    ,G0tensor(239),G0tensor(214),G0tensor(73),G0tensor(63)])
  call ol_merge_tensors(G3tensor(85),[G3tensor(83),G3tensor(81),G3tensor(55),G2tensor(9),G2tensor(31),G2tensor(58),G2tensor(164) &
    ,G2tensor(323),G2tensor(317),G2tensor(293),G2tensor(287),G2tensor(281),G2tensor(275),G2tensor(222),G2tensor(216),G2tensor(212) &
    ,G2tensor(208),G2tensor(200),G2tensor(198),G1tensor(120),G1tensor(95),G1tensor(29),G1tensor(6),G1tensor(240),G1tensor(215) &
    ,G1tensor(18),G1tensor(36),G0tensor(249),G0tensor(224),G0tensor(78),G0tensor(68)])
  call ol_merge_tensors(G3tensor(75),[G3tensor(69),G3tensor(4),G3tensor(1),G2tensor(398),G2tensor(389),G1tensor(621),G1tensor(606) &
    ,G0tensor(594),G0tensor(579)])
  call ol_merge_tensors(G3tensor(76),[G3tensor(70),G3tensor(5),G3tensor(2),G2tensor(401),G2tensor(392),G1tensor(626),G1tensor(611) &
    ,G0tensor(599),G0tensor(584)])
  call ol_merge_tensors(G3tensor(77),[G3tensor(71),G3tensor(6),G3tensor(3),G2tensor(404),G2tensor(395),G1tensor(631),G1tensor(616) &
    ,G0tensor(604),G0tensor(589)])
  call ol_merge_tensors(G3tensor(78),[G2tensor(37),G2tensor(215),G2tensor(272),G2tensor(220),G2tensor(204),G1tensor(97) &
    ,G1tensor(16),G1tensor(440),G1tensor(190),G1tensor(127),G1tensor(53),G0tensor(449),G0tensor(199),G0tensor(133),G0tensor(98)])
  call ol_merge_tensors(G3tensor(79),[G2tensor(82),G2tensor(211),G2tensor(308),G2tensor(302),G2tensor(296),G2tensor(206) &
    ,G1tensor(43),G1tensor(46),G1tensor(455),G1tensor(450),G0tensor(464),G0tensor(459)])
  call ol_merge_tensors(G3tensor(80),[G2tensor(76),G2tensor(79),G2tensor(326),G2tensor(311),G2tensor(305),G2tensor(299) &
    ,G2tensor(221),G2tensor(207),G1tensor(73),G1tensor(55),G1tensor(31),G1tensor(128),G1tensor(40),G1tensor(460),G1tensor(445) &
    ,G0tensor(469),G0tensor(454)])
  call ol_merge_tensors(G3tensor(110),[G3tensor(107),G3tensor(101),G3tensor(92),G3tensor(7),G2tensor(407),G1tensor(636) &
    ,G0tensor(609)])
  call ol_merge_tensors(G3tensor(111),[G3tensor(108),G3tensor(102),G3tensor(93),G3tensor(8),G2tensor(410),G1tensor(641) &
    ,G0tensor(614)])
  call ol_merge_tensors(G3tensor(112),[G3tensor(109),G3tensor(103),G3tensor(94),G3tensor(9),G2tensor(413),G1tensor(646) &
    ,G0tensor(619)])
  call ol_merge_tensors(G3tensor(99),[G3tensor(96),G2tensor(13),G2tensor(142),G2tensor(35),G2tensor(178),G2tensor(135) &
    ,G2tensor(243),G2tensor(381),G2tensor(354),G2tensor(363),G2tensor(16),G2tensor(294),G2tensor(297),G2tensor(122),G2tensor(116) &
    ,G2tensor(173),G2tensor(335),G2tensor(226),G1tensor(201),G1tensor(186),G1tensor(176),G1tensor(9),G1tensor(26),G1tensor(490) &
    ,G1tensor(480),G1tensor(470),G0tensor(499),G0tensor(489),G0tensor(479)])
  call ol_merge_tensors(G3tensor(98),[G2tensor(17),G2tensor(174),G2tensor(246),G2tensor(105),G2tensor(309),G2tensor(264) &
    ,G2tensor(332),G2tensor(227),G1tensor(161),G1tensor(110),G1tensor(305),G1tensor(21),G1tensor(74),G0tensor(314),G0tensor(24) &
    ,G0tensor(14)])
  call ol_merge_tensors(G3tensor(100),[G3tensor(97),G2tensor(321),G2tensor(270),G2tensor(193),G2tensor(137),G2tensor(98) &
    ,G2tensor(131),G2tensor(127),G2tensor(366),G2tensor(111),G2tensor(102),G2tensor(205),G2tensor(123),G2tensor(117),G2tensor(21) &
    ,G2tensor(336),G2tensor(344),G2tensor(341),G2tensor(338),G2tensor(266),G2tensor(229),G2tensor(228),G1tensor(191),G1tensor(181) &
    ,G1tensor(166),G1tensor(20),G1tensor(80),G1tensor(315),G1tensor(32),G1tensor(104),G0tensor(324),G0tensor(29),G0tensor(19)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(353),G2tensor(231),G1tensor(541),G1tensor(280),G1tensor(265),G1tensor(42) &
    ,G1tensor(38),G0tensor(514),G0tensor(289),G0tensor(274),G0tensor(74),G0tensor(54)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(233),G1tensor(546),G0tensor(519)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(356),G2tensor(235),G1tensor(551),G1tensor(285),G1tensor(270),G1tensor(19) &
    ,G1tensor(124),G0tensor(524),G0tensor(294),G0tensor(279),G0tensor(79),G0tensor(59)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(237),G1tensor(556),G1tensor(390),G1tensor(28),G0tensor(529),G0tensor(399) &
    ,G0tensor(49)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(239),G1tensor(561),G1tensor(483),G0tensor(534),G0tensor(492)])
  call ol_merge_tensors(G2tensor(364),[G2tensor(247),G2tensor(241),G1tensor(76),G1tensor(25),G1tensor(94),G0tensor(111) &
    ,G0tensor(86),G0tensor(61)])
  call ol_merge_tensors(G2tensor(242),[G1tensor(207),G1tensor(103),G0tensor(216),G0tensor(89)])
  call ol_merge_tensors(G2tensor(367),[G2tensor(250),G2tensor(244),G1tensor(89),G1tensor(67),G1tensor(121),G1tensor(118) &
    ,G0tensor(116),G0tensor(107),G0tensor(101),G0tensor(66)])
  call ol_merge_tensors(G2tensor(245),[G1tensor(217),G1tensor(65),G0tensor(226),G0tensor(104)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(248),G1tensor(232),G1tensor(155),G1tensor(84),G0tensor(241),G0tensor(164) &
    ,G0tensor(114)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(251),G1tensor(242),G1tensor(160),G1tensor(101),G1tensor(111),G0tensor(251) &
    ,G0tensor(169),G0tensor(119),G0tensor(27)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(352),G2tensor(259),G2tensor(253),G1tensor(75),G1tensor(96),G1tensor(17) &
    ,G0tensor(141),G0tensor(121),G0tensor(71)])
  call ol_merge_tensors(G2tensor(254),[G1tensor(262),G1tensor(107),G0tensor(271),G0tensor(124)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(355),G2tensor(262),G2tensor(256),G1tensor(137),G1tensor(133),G1tensor(33) &
    ,G1tensor(13),G0tensor(146),G0tensor(136),G0tensor(82),G0tensor(76)])
  call ol_merge_tensors(G2tensor(257),[G1tensor(267),G1tensor(51),G0tensor(276),G0tensor(139)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(87),G2tensor(343),G2tensor(340),G2tensor(337),G2tensor(265),G1tensor(312) &
    ,G1tensor(85),G1tensor(24),G0tensor(321),G0tensor(109),G0tensor(84)])
  call ol_merge_tensors(G3tensor(10),[G2tensor(85),G2tensor(27),G2tensor(64),G2tensor(168),G2tensor(319),G2tensor(313) &
    ,G2tensor(277),G2tensor(268),G1tensor(136),G1tensor(202),G1tensor(106),G1tensor(30),G0tensor(211),G0tensor(123) &
    ,G0tensor(88)])
  call ol_merge_tensors(G3tensor(59),[G3tensor(34),G2tensor(103),G2tensor(100),G2tensor(171),G2tensor(315),G2tensor(271) &
    ,G1tensor(187),G1tensor(113),G1tensor(47),G0tensor(196),G0tensor(128),G0tensor(93)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(11),G2tensor(40),G2tensor(61),G2tensor(7),G2tensor(273),G2tensor(322),G2tensor(316) &
    ,G2tensor(280),G2tensor(274),G1tensor(212),G1tensor(39),G1tensor(64),G0tensor(221),G0tensor(138),G0tensor(103)])
  call ol_merge_tensors(G3tensor(26),[G3tensor(24),G3tensor(12),G2tensor(213),G2tensor(43),G2tensor(289),G2tensor(283) &
    ,G1tensor(11),G1tensor(227),G1tensor(63),G1tensor(78),G0tensor(236),G0tensor(143),G0tensor(113)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G3tensor(23),G3tensor(13),G2tensor(312),G2tensor(33),G2tensor(292) &
    ,G2tensor(286),G1tensor(313),G1tensor(237),G1tensor(139),G1tensor(91),G0tensor(322),G0tensor(246),G0tensor(148) &
    ,G0tensor(118)])
  call ol_merge_tensors(G3tensor(21),[G2tensor(169),G2tensor(301),G2tensor(295),G1tensor(468),G1tensor(447),G0tensor(477) &
    ,G0tensor(456)])
  call ol_merge_tensors(G3tensor(22),[G2tensor(209),G2tensor(282),G2tensor(304),G2tensor(298),G1tensor(132),G1tensor(463) &
    ,G1tensor(442),G0tensor(472),G0tensor(451)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(307),G1tensor(452),G0tensor(461)])
  call ol_merge_tensors(G3tensor(35),[G2tensor(29),G2tensor(279),G2tensor(325),G2tensor(310),G1tensor(141),G1tensor(457) &
    ,G0tensor(466)])
  call ol_merge_tensors(G2tensor(328),[G1tensor(462),G0tensor(471)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(10),G2tensor(339),G2tensor(329),G1tensor(206),G1tensor(156),G1tensor(117) &
    ,G1tensor(465),G0tensor(25),G0tensor(20),G0tensor(10),G0tensor(474)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(331),G1tensor(320),G1tensor(302),G1tensor(290),G0tensor(329),G0tensor(311) &
    ,G0tensor(299)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(334),G1tensor(467),G0tensor(476)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(376),G2tensor(346),G1tensor(593),G1tensor(563),G0tensor(566),G0tensor(536)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(347),G1tensor(566),G0tensor(539)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(379),G2tensor(349),G1tensor(598),G1tensor(568),G0tensor(571),G0tensor(541)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(350),G1tensor(571),G1tensor(435),G1tensor(170),G0tensor(544),G0tensor(444) &
    ,G0tensor(179)])
  call ol_merge_tensors(G2tensor(370),[G2tensor(358),G1tensor(583),G1tensor(573),G0tensor(556),G0tensor(546)])
  call ol_merge_tensors(G2tensor(288),[G2tensor(359),G1tensor(576),G0tensor(549)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(361),G1tensor(588),G1tensor(578),G0tensor(561),G0tensor(551)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(362),G1tensor(581),G1tensor(420),G1tensor(150),G0tensor(554),G0tensor(429) &
    ,G0tensor(159)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(365),G1tensor(235),G1tensor(210),G1tensor(134),G1tensor(70),G0tensor(244) &
    ,G0tensor(219),G0tensor(64),G0tensor(39)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(368),G1tensor(245),G1tensor(220),G1tensor(4),G1tensor(7),G0tensor(254) &
    ,G0tensor(229),G0tensor(69),G0tensor(44)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(371),G1tensor(586),G0tensor(559)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(374),G1tensor(591),G0tensor(564)])
  call ol_merge_tensors(G2tensor(255),[G2tensor(377),G1tensor(596),G0tensor(569)])
  call ol_merge_tensors(G2tensor(258),[G2tensor(380),G1tensor(601),G0tensor(574)])
  call ol_merge_tensors(G2tensor(382),[G1tensor(322),G1tensor(318),G1tensor(49),G1tensor(35),G0tensor(331),G0tensor(327) &
    ,G0tensor(96),G0tensor(91)])
  call ol_merge_tensors(G2tensor(383),[G1tensor(192),G1tensor(41),G0tensor(201),G0tensor(94)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(385),G1tensor(292),G1tensor(288),G1tensor(125),G1tensor(109),G0tensor(301) &
    ,G0tensor(297),G0tensor(131),G0tensor(126)])
  call ol_merge_tensors(G2tensor(386),[G1tensor(252),G1tensor(114),G0tensor(261),G0tensor(129)])
  call ol_merge_tensors(G3tensor(14),[G2tensor(388),G1tensor(603),G0tensor(576)])
  call ol_merge_tensors(G3tensor(16),[G2tensor(391),G1tensor(644),G1tensor(608),G0tensor(617),G0tensor(581)])
  call ol_merge_tensors(G3tensor(18),[G2tensor(394),G1tensor(639),G1tensor(613),G0tensor(612),G0tensor(586)])
  call ol_merge_tensors(G3tensor(28),[G2tensor(397),G1tensor(618),G0tensor(591)])
  call ol_merge_tensors(G3tensor(30),[G2tensor(400),G1tensor(623),G0tensor(596)])
  call ol_merge_tensors(G3tensor(32),[G2tensor(403),G1tensor(628),G0tensor(601)])
  call ol_merge_tensors(G3tensor(37),[G2tensor(406),G1tensor(633),G0tensor(606)])
  call ol_merge_tensors(G3tensor(39),[G2tensor(409),G1tensor(638),G0tensor(611)])
  call ol_merge_tensors(G3tensor(40),[G2tensor(412),G1tensor(643),G0tensor(616)])
  call ol_merge_tensors(G1tensor(497),[G1tensor(487),G1tensor(482),G1tensor(287),G1tensor(123),G0tensor(506),G0tensor(496) &
    ,G0tensor(491),G0tensor(296),G0tensor(11)])
  call ol_merge_tensors(G1tensor(295),[G1tensor(129),G0tensor(304),G0tensor(12)])
  call ol_merge_tensors(G1tensor(300),[G1tensor(68),G0tensor(309),G0tensor(13)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(143),G1tensor(23),G1tensor(86),G0tensor(416),G0tensor(152),G0tensor(81) &
    ,G0tensor(16)])
  call ol_merge_tensors(G1tensor(310),[G1tensor(98),G0tensor(319),G0tensor(18)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(477),G1tensor(472),G1tensor(317),G1tensor(116),G0tensor(501),G0tensor(486) &
    ,G0tensor(481),G0tensor(326),G0tensor(21)])
  call ol_merge_tensors(G1tensor(325),[G1tensor(122),G0tensor(334),G0tensor(22)])
  call ol_merge_tensors(G1tensor(330),[G1tensor(99),G0tensor(339),G0tensor(23)])
  call ol_merge_tensors(G1tensor(422),[G1tensor(163),G1tensor(79),G1tensor(14),G0tensor(431),G0tensor(172),G0tensor(106) &
    ,G0tensor(26)])
  call ol_merge_tensors(G1tensor(335),[G1tensor(27),G0tensor(344),G0tensor(28)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(493),G1tensor(337),G1tensor(81),G0tensor(502),G0tensor(346),G0tensor(31)])
  call ol_merge_tensors(G1tensor(345),[G1tensor(1),G0tensor(354),G0tensor(32)])
  call ol_merge_tensors(G1tensor(350),[G1tensor(56),G0tensor(359),G0tensor(33)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(355),G1tensor(44),G0tensor(364),G0tensor(34)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(594),G1tensor(152),G1tensor(15),G0tensor(567),G0tensor(161),G0tensor(36)])
  call ol_merge_tensors(G1tensor(360),[G1tensor(105),G1tensor(62),G0tensor(369),G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G1tensor(365),[G1tensor(50),G0tensor(374),G0tensor(38)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(599),G1tensor(428),G1tensor(423),G1tensor(157),G1tensor(2),G0tensor(572) &
    ,G0tensor(437),G0tensor(432),G0tensor(166),G0tensor(41)])
  call ol_merge_tensors(G1tensor(370),[G1tensor(5),G0tensor(379),G0tensor(43)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(558),G1tensor(498),G1tensor(372),G1tensor(82),G0tensor(531),G0tensor(507) &
    ,G0tensor(381),G0tensor(46)])
  call ol_merge_tensors(G1tensor(380),[G1tensor(22),G0tensor(389),G0tensor(47)])
  call ol_merge_tensors(G1tensor(385),[G1tensor(83),G0tensor(394),G0tensor(48)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(584),G1tensor(172),G1tensor(34),G0tensor(557),G0tensor(181),G0tensor(51)])
  call ol_merge_tensors(G1tensor(395),[G1tensor(71),G1tensor(87),G0tensor(404),G0tensor(57),G0tensor(52)])
  call ol_merge_tensors(G1tensor(400),[G1tensor(8),G0tensor(409),G0tensor(53)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(589),G1tensor(413),G1tensor(408),G1tensor(177),G1tensor(52),G0tensor(562) &
    ,G0tensor(422),G0tensor(417),G0tensor(186),G0tensor(56)])
  call ol_merge_tensors(G1tensor(405),[G1tensor(58),G0tensor(414),G0tensor(58)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(225),G1tensor(200),G1tensor(3),G1tensor(100),G0tensor(234),G0tensor(209) &
    ,G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(275),G1tensor(260),G1tensor(48),G1tensor(10),G0tensor(284),G0tensor(269) &
    ,G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G1tensor(307),[G1tensor(54),G0tensor(316),G0tensor(83)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(246),G1tensor(368),G1tensor(363),G1tensor(358),G1tensor(197),G1tensor(61) &
    ,G1tensor(60),G0tensor(377),G0tensor(372),G0tensor(367),G0tensor(206),G0tensor(102),G0tensor(87)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(241),G1tensor(348),G1tensor(343),G1tensor(182),G1tensor(167),G1tensor(162) &
    ,G1tensor(37),G0tensor(357),G0tensor(352),G0tensor(191),G0tensor(176),G0tensor(171),G0tensor(92)])
  call ol_merge_tensors(G1tensor(185),[G1tensor(59),G0tensor(194),G0tensor(97)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(115),G0tensor(204),G0tensor(99)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(72),G0tensor(341),G0tensor(108)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(333),G1tensor(222),G1tensor(90),G1tensor(77),G0tensor(342),G0tensor(231) &
    ,G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(226),G1tensor(403),G1tensor(398),G1tensor(393),G1tensor(257),G1tensor(45) &
    ,G1tensor(102),G0tensor(412),G0tensor(407),G0tensor(402),G0tensor(266),G0tensor(137),G0tensor(122)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(221),G1tensor(383),G1tensor(378),G1tensor(247),G1tensor(147),G1tensor(142) &
    ,G1tensor(119),G0tensor(392),G0tensor(387),G0tensor(256),G0tensor(156),G0tensor(151),G0tensor(127)])
  call ol_merge_tensors(G1tensor(250),[G1tensor(126),G0tensor(259),G0tensor(132)])
  call ol_merge_tensors(G1tensor(255),[G1tensor(131),G0tensor(264),G0tensor(134)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(308),G1tensor(272),G1tensor(138),G1tensor(69),G0tensor(317),G0tensor(281) &
    ,G0tensor(147),G0tensor(142)])
  call ol_merge_tensors(G1tensor(412),[G1tensor(144),G0tensor(421),G0tensor(153)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(145),G0tensor(426),G0tensor(154)])
  call ol_merge_tensors(G1tensor(211),[G1tensor(410),G1tensor(148),G0tensor(419),G0tensor(157)])
  call ol_merge_tensors(G1tensor(415),[G1tensor(149),G0tensor(424),G0tensor(158)])
  call ol_merge_tensors(G1tensor(357),[G1tensor(158),G1tensor(153),G0tensor(366),G0tensor(167),G0tensor(162)])
  call ol_merge_tensors(G1tensor(362),[G1tensor(154),G0tensor(371),G0tensor(163)])
  call ol_merge_tensors(G1tensor(367),[G1tensor(159),G0tensor(376),G0tensor(168)])
  call ol_merge_tensors(G1tensor(427),[G1tensor(164),G0tensor(436),G0tensor(173)])
  call ol_merge_tensors(G1tensor(432),[G1tensor(165),G0tensor(441),G0tensor(174)])
  call ol_merge_tensors(G1tensor(231),[G1tensor(425),G1tensor(168),G0tensor(434),G0tensor(177)])
  call ol_merge_tensors(G1tensor(430),[G1tensor(169),G0tensor(439),G0tensor(178)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(392),G1tensor(178),G1tensor(173),G0tensor(401),G0tensor(187),G0tensor(182)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(397),G1tensor(174),G0tensor(406),G0tensor(183)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(402),G1tensor(179),G0tensor(411),G0tensor(188)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(41),G1tensor(248),G1tensor(188),G1tensor(183),G0tensor(257),G0tensor(197) &
    ,G0tensor(192)])
  call ol_merge_tensors(G1tensor(193),[G1tensor(184),G0tensor(202),G0tensor(193)])
  call ol_merge_tensors(G3tensor(43),[G2tensor(54),G1tensor(329),G1tensor(304),G1tensor(299),G1tensor(254),G1tensor(194) &
    ,G1tensor(189),G0tensor(338),G0tensor(313),G0tensor(308),G0tensor(263),G0tensor(203),G0tensor(198)])
  call ol_merge_tensors(G3tensor(68),[G3tensor(67),G3tensor(45),G3tensor(42),G2tensor(113),G2tensor(95),G2tensor(80),G2tensor(158) &
    ,G1tensor(458),G1tensor(258),G1tensor(213),G1tensor(203),G1tensor(198),G0tensor(467),G0tensor(267),G0tensor(222),G0tensor(212) &
    ,G0tensor(207)])
  call ol_merge_tensors(G1tensor(218),[G1tensor(208),G1tensor(199),G0tensor(227),G0tensor(217),G0tensor(208)])
  call ol_merge_tensors(G3tensor(51),[G3tensor(49),G3tensor(46),G2tensor(50),G2tensor(18),G1tensor(151),G1tensor(264) &
    ,G1tensor(209),G1tensor(204),G0tensor(273),G0tensor(218),G0tensor(213)])
  call ol_merge_tensors(G3tensor(52),[G3tensor(50),G3tensor(44),G3tensor(41),G2tensor(28),G2tensor(20),G1tensor(334),G1tensor(314) &
    ,G1tensor(309),G1tensor(269),G1tensor(219),G1tensor(214),G0tensor(343),G0tensor(323),G0tensor(318),G0tensor(278),G0tensor(228) &
    ,G0tensor(223)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(107),G2tensor(104),G2tensor(89),G2tensor(156),G2tensor(154),G1tensor(443) &
    ,G1tensor(273),G1tensor(238),G1tensor(228),G1tensor(223),G0tensor(452),G0tensor(282),G0tensor(247),G0tensor(237) &
    ,G0tensor(232)])
  call ol_merge_tensors(G1tensor(359),[G1tensor(243),G1tensor(233),G1tensor(224),G0tensor(368),G0tensor(252),G0tensor(242) &
    ,G0tensor(233)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(44),G2tensor(69),G2tensor(22),G2tensor(185),G1tensor(399),G1tensor(364) &
    ,G1tensor(279),G1tensor(234),G1tensor(229),G0tensor(408),G0tensor(373),G0tensor(288),G0tensor(243),G0tensor(238)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(45),G2tensor(63),G2tensor(187),G2tensor(26),G2tensor(66),G1tensor(404) &
    ,G1tensor(369),G1tensor(284),G1tensor(244),G1tensor(239),G0tensor(413),G0tensor(378),G0tensor(293),G0tensor(253) &
    ,G0tensor(248)])
  call ol_merge_tensors(G1tensor(253),[G1tensor(249),G0tensor(262),G0tensor(258)])
  call ol_merge_tensors(G1tensor(268),[G1tensor(263),G1tensor(259),G0tensor(277),G0tensor(272),G0tensor(268)])
  call ol_merge_tensors(G1tensor(394),[G1tensor(283),G1tensor(278),G1tensor(274),G0tensor(403),G0tensor(292),G0tensor(287) &
    ,G0tensor(283)])
  call ol_merge_tensors(G1tensor(297),[G1tensor(289),G0tensor(306),G0tensor(298)])
  call ol_merge_tensors(G1tensor(298),[G1tensor(293),G0tensor(307),G0tensor(302)])
  call ol_merge_tensors(G3tensor(20),[G2tensor(11),G1tensor(437),G1tensor(324),G1tensor(303),G1tensor(294),G0tensor(446) &
    ,G0tensor(333),G0tensor(312),G0tensor(303)])
  call ol_merge_tensors(G1tensor(327),[G1tensor(319),G0tensor(336),G0tensor(328)])
  call ol_merge_tensors(G1tensor(328),[G1tensor(323),G0tensor(337),G0tensor(332)])
  call ol_merge_tensors(G1tensor(342),[G1tensor(338),G0tensor(351),G0tensor(347)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(339),G0tensor(356),G0tensor(348)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(478),G1tensor(352),G1tensor(340),G0tensor(487),G0tensor(361),G0tensor(349)])
  call ol_merge_tensors(G1tensor(353),[G1tensor(344),G0tensor(362),G0tensor(353)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(160),G2tensor(51),G1tensor(449),G1tensor(389),G1tensor(384),G1tensor(354) &
    ,G1tensor(349),G0tensor(458),G0tensor(398),G0tensor(393),G0tensor(363),G0tensor(358)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(377),G1tensor(373),G0tensor(386),G0tensor(382)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(382),G1tensor(374),G0tensor(391),G0tensor(383)])
  call ol_merge_tensors(G1tensor(388),[G1tensor(379),G0tensor(397),G0tensor(388)])
  call ol_merge_tensors(G1tensor(418),[G1tensor(409),G0tensor(427),G0tensor(418)])
  call ol_merge_tensors(G3tensor(91),[G3tensor(90),G3tensor(89),G3tensor(88),G1tensor(434),G1tensor(429),G1tensor(419) &
    ,G1tensor(414),G0tensor(443),G0tensor(438),G0tensor(428),G0tensor(423)])
  call ol_merge_tensors(G1tensor(433),[G1tensor(424),G0tensor(442),G0tensor(433)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(438),G0tensor(447)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(439),G0tensor(448)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(65),G2tensor(42),G1tensor(444),G0tensor(453)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(59),G2tensor(56),G1tensor(448),G0tensor(457)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(453),G0tensor(15),G0tensor(462)])
  call ol_merge_tensors(G3tensor(47),[G2tensor(182),G1tensor(469),G1tensor(454),G0tensor(478),G0tensor(463)])
  call ol_merge_tensors(G3tensor(48),[G2tensor(71),G2tensor(48),G1tensor(146),G1tensor(464),G1tensor(459),G0tensor(473) &
    ,G0tensor(468)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(473),G0tensor(482)])
  call ol_merge_tensors(G1tensor(474),[G0tensor(483)])
  call ol_merge_tensors(G3tensor(95),[G2tensor(318),G2tensor(3),G2tensor(195),G2tensor(190),G2tensor(186),G2tensor(240) &
    ,G2tensor(351),G2tensor(114),G2tensor(163),G2tensor(124),G2tensor(118),G2tensor(19),G1tensor(196),G1tensor(171),G1tensor(93) &
    ,G1tensor(485),G1tensor(475),G0tensor(494),G0tensor(484)])
  call ol_merge_tensors(G1tensor(479),[G0tensor(488)])
  call ol_merge_tensors(G1tensor(484),[G0tensor(493)])
  call ol_merge_tensors(G1tensor(489),[G0tensor(498)])
  call ol_merge_tensors(G1tensor(494),[G0tensor(503)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(495),G0tensor(504)])
  call ol_merge_tensors(G1tensor(499),[G0tensor(508)])
  call ol_merge_tensors(G1tensor(216),[G1tensor(500),G0tensor(509)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(505)])
  call ol_merge_tensors(G1tensor(535),[G1tensor(506)])
  call ol_merge_tensors(G1tensor(521),[G1tensor(509)])
  call ol_merge_tensors(G1tensor(531),[G1tensor(510)])
  call ol_merge_tensors(G1tensor(525),[G1tensor(513)])
  call ol_merge_tensors(G1tensor(536),[G1tensor(520)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(524)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(574),G1tensor(538),G0tensor(547),G0tensor(511)])
  call ol_merge_tensors(G2tensor(276),[G1tensor(549),G1tensor(539),G0tensor(522),G0tensor(512)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(540),G0tensor(513)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(553),G1tensor(543),G0tensor(526),G0tensor(516)])
  call ol_merge_tensors(G2tensor(267),[G1tensor(544),G0tensor(517)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(545),G0tensor(518)])
  call ol_merge_tensors(G2tensor(96),[G1tensor(579),G1tensor(548),G0tensor(552),G0tensor(521)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(550),G0tensor(523)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(554),G0tensor(527)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(555),G0tensor(528)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(559),G0tensor(532)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(560),G0tensor(533)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(564),G0tensor(537)])
  call ol_merge_tensors(G3tensor(74),[G3tensor(72),G3tensor(56),G3tensor(53),G1tensor(580),G1tensor(575),G1tensor(570) &
    ,G1tensor(565),G0tensor(553),G0tensor(548),G0tensor(543),G0tensor(538)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(569),G0tensor(542)])
  call ol_merge_tensors(G3tensor(87),[G3tensor(86),G3tensor(58),G3tensor(57),G1tensor(600),G1tensor(595),G1tensor(590) &
    ,G1tensor(585),G0tensor(573),G0tensor(568),G0tensor(563),G0tensor(558)])
  call ol_merge_tensors(G3tensor(60),[G1tensor(604),G0tensor(577)])
  call ol_merge_tensors(G3tensor(15),[G1tensor(605),G0tensor(578)])
  call ol_merge_tensors(G3tensor(61),[G1tensor(609),G0tensor(582)])
  call ol_merge_tensors(G3tensor(17),[G1tensor(610),G0tensor(583)])
  call ol_merge_tensors(G3tensor(62),[G1tensor(614),G0tensor(587)])
  call ol_merge_tensors(G3tensor(19),[G1tensor(615),G0tensor(588)])
  call ol_merge_tensors(G3tensor(104),[G3tensor(63),G1tensor(619),G0tensor(592)])
  call ol_merge_tensors(G3tensor(29),[G1tensor(620),G0tensor(593)])
  call ol_merge_tensors(G3tensor(105),[G3tensor(64),G1tensor(624),G0tensor(597)])
  call ol_merge_tensors(G3tensor(31),[G1tensor(645),G1tensor(625),G0tensor(618),G0tensor(598)])
  call ol_merge_tensors(G3tensor(106),[G3tensor(65),G1tensor(629),G0tensor(602)])
  call ol_merge_tensors(G3tensor(33),[G1tensor(640),G1tensor(630),G0tensor(613),G0tensor(603)])
  call ol_merge_tensors(G3tensor(66),[G1tensor(634),G0tensor(607)])
  call ol_merge_tensors(G3tensor(38),[G1tensor(635),G0tensor(608)])
  call TI_triangle_red(G2tensor(183),RedBasis(4),mass3set(:,1),G0tensor(30),G0tensor(35),G0tensor(40), &
    G0tensor(45),M2L1R1,[nMZ,nMW],G0tensor(50),G0tensor(55))
  call TI_triangle_red(G2tensor(249),RedBasis(4),mass3set(:,2),G0tensor(60),G0tensor(65),G0tensor(70),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(80))
  call TI_triangle_red(G2tensor(384),RedBasis(4),mass3set(:,3),G0tensor(85),G0tensor(90),G0tensor(95), &
    G0tensor(100),M2L1R1,[nMW,nMZ],G0tensor(105),G0tensor(110))
  call TI_triangle_red(G3tensor(84),RedBasis(21),mass3set(:,4),G0tensor(115),G0tensor(120),G0tensor(125), &
    G0tensor(130),M2L1R1,[nMW],G0tensor(135))
  call TI_triangle_red(G3tensor(85),RedBasis(21),mass3set(:,5),G0tensor(140),G0tensor(145),G0tensor(150), &
    G0tensor(155),M2L1R1,[nMW,nMZ],G0tensor(160),G0tensor(165))
  call TI_triangle_red(G3tensor(75),RedBasis(21),mass3set(:,6),G0tensor(170),G0tensor(175),G0tensor(180), &
    G0tensor(185),M2L1R1,[nML],G0tensor(190))
  call TI_triangle_red(G3tensor(76),RedBasis(21),mass3set(:,7),G0tensor(195),G0tensor(200),G0tensor(205), &
    G0tensor(210),M2L1R1,[nMT,nMB],G0tensor(215),G0tensor(220))
  call TI_triangle_red(G3tensor(77),RedBasis(21),mass3set(:,8),G0tensor(225),G0tensor(230),G0tensor(235), &
    G0tensor(240),M2L1R1,[nMB,nMT],G0tensor(245),G0tensor(250))
  call TI_triangle_red(G3tensor(78),RedBasis(21),mass3set(:,9),G0tensor(255),G0tensor(260),G0tensor(265), &
    G0tensor(270),M2L1R1,[nMH,nMW,nMZ],G0tensor(275),G0tensor(280),G0tensor(285))
  call TI_triangle_red(G3tensor(79),RedBasis(21),mass3set(:,10),G0tensor(290),G0tensor(295),G0tensor(300), &
    G0tensor(305),M2L1R1,[nMZ,nMW,nMH],G0tensor(310),G0tensor(315),G0tensor(320))
  call TI_triangle_red(G3tensor(80),RedBasis(21),mass3set(:,11),G0tensor(325),G0tensor(330),G0tensor(335), &
    G0tensor(340),M2L1R1,[nMW,nMH],G0tensor(345),G0tensor(350))
  call TI_triangle_red(G3tensor(110),RedBasis(1),mass3set(:,12),G0tensor(355),G0tensor(360),G0tensor(365), &
    G0tensor(370),M2L1R1,[nML],G0tensor(375))
  call TI_triangle_red(G3tensor(111),RedBasis(1),mass3set(:,13),G0tensor(380),G0tensor(385),G0tensor(390), &
    G0tensor(395),M2L1R1,[nMB,nMT],G0tensor(400),G0tensor(405))
  call TI_triangle_red(G3tensor(112),RedBasis(1),mass3set(:,14),G0tensor(410),G0tensor(415),G0tensor(420), &
    G0tensor(425),M2L1R1,[nMT,nMB],G0tensor(430),G0tensor(435))
  call TI_triangle_red(G3tensor(99),RedBasis(1),mass3set(:,15),G0tensor(440),G0tensor(445),G0tensor(450), &
    G0tensor(455),M2L1R1,[nMZ,nMW],G0tensor(460),G0tensor(465))
  call TI_triangle_red(G3tensor(98),RedBasis(1),mass3set(:,16),G0tensor(470),G0tensor(475),G0tensor(480), &
    G0tensor(485),M2L1R1,[nMH,nMW],G0tensor(490),G0tensor(495))
  call TI_triangle_red(G3tensor(100),RedBasis(1),mass3set(:,17),G0tensor(500),G0tensor(505),G0tensor(1), &
    G0tensor(2),M2L1R1,[nMW,nMZ],G0tensor(3),G0tensor(4))
  call TI_triangle_red(G2tensor(55),RedBasis(16),mass3set(:,2),G0tensor(5),G0tensor(6),G0tensor(7),G0tensor(8),M2L1R1,[nMW], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(145),RedBasis(16),mass3set(:,18),G0tensor(510),G0tensor(515),G0tensor(520), &
    G0tensor(525),M2L1R1,[nMW],G0tensor(530))
  call TI_triangle_red(G2tensor(109),RedBasis(16),mass3set(:,3),G0tensor(535),G0tensor(540),G0tensor(545), &
    G0tensor(550),M2L1R1,[nMW,nMZ],G0tensor(555),G0tensor(560))
  call TI_triangle_red(G2tensor(112),RedBasis(16),mass3set(:,1),G0tensor(565),G0tensor(570),G0tensor(575), &
    G0tensor(580),M2L1R1,[nMZ,nMW],G0tensor(585),G0tensor(590))
  call TI_triangle_red(G2tensor(252),RedBasis(4),mass3set(:,18),G0tensor(595),G0tensor(600),G0tensor(605), &
    G0tensor(610),M2L1R1,[nMW],G0tensor(615))
  call TI_triangle_red(G2tensor(364),RedBasis(60),mass3set(:,2),G0tensor(497),G0tensor(396),G0tensor(384), &
    G0tensor(286),M2L1R1,[nMW],G0tensor(184))
  call TI_triangle_red(G2tensor(242),RedBasis(53),mass3set(:,2),G0tensor(144),G0tensor(291),G0tensor(189), &
    G0tensor(149),M2L1R1,[nMW],G0tensor(17))
  call TI_triangle_red(G2tensor(367),RedBasis(60),mass3set(:,3),G0tensor(239),G0tensor(214),G0tensor(73), &
    G0tensor(63),M2L1R1,[nMW,nMZ],G0tensor(249),G0tensor(224))
  call TI_triangle_red(G2tensor(245),RedBasis(53),mass3set(:,3),G0tensor(78),G0tensor(68),G0tensor(594), &
    G0tensor(579),M2L1R1,[nMW,nMZ],G0tensor(599),G0tensor(584))
  call TI_triangle_red(G2tensor(172),RedBasis(8),mass3set(:,2),G0tensor(604),G0tensor(589),G0tensor(449), &
    G0tensor(199),M2L1R1,[nMW],G0tensor(133))
  call TI_triangle_red(G2tensor(181),RedBasis(8),mass3set(:,3),G0tensor(98),G0tensor(464),G0tensor(459), &
    G0tensor(469),M2L1R1,[nMW,nMZ],G0tensor(454),G0tensor(609))
  call TI_triangle_red(G2tensor(165),RedBasis(58),mass3set(:,2),G0tensor(614),G0tensor(619),G0tensor(499), &
    G0tensor(489),M2L1R1,[nMW],G0tensor(479))
  call TI_triangle_red(G2tensor(254),RedBasis(55),mass3set(:,2),G0tensor(314),G0tensor(24),G0tensor(14), &
    G0tensor(324),M2L1R1,[nMW],G0tensor(29))
  call TI_triangle_red(G2tensor(23),RedBasis(58),mass3set(:,3),G0tensor(19),G0tensor(514),G0tensor(289), &
    G0tensor(274),M2L1R1,[nMW,nMZ],G0tensor(74),G0tensor(54))
  call TI_triangle_red(G2tensor(257),RedBasis(55),mass3set(:,3),G0tensor(519),G0tensor(524),G0tensor(294), &
    G0tensor(279),M2L1R1,[nMW,nMZ],G0tensor(79),G0tensor(59))
  call TI_triangle_red(G2tensor(81),RedBasis(56),mass3set(:,17),G0tensor(529),G0tensor(399),G0tensor(49), &
    G0tensor(534),M2L1R1,[nMW,nMZ],G0tensor(492),G0tensor(111))
  call TI_triangle_red(G3tensor(10),RedBasis(54),mass3set(:,4),G0tensor(86),G0tensor(61),G0tensor(216),G0tensor(89),M2L1R1,[nMW], &
    G0tensor(116))
  call TI_triangle_red(G3tensor(59),RedBasis(54),mass3set(:,19),G0tensor(107),G0tensor(101),G0tensor(66), &
    G0tensor(226),M2L1R1,[nMZ,nMW],G0tensor(104),G0tensor(241))
  call TI_triangle_red(G3tensor(36),RedBasis(54),mass3set(:,5),G0tensor(164),G0tensor(114),G0tensor(251), &
    G0tensor(169),M2L1R1,[nMW,nMZ],G0tensor(119),G0tensor(27))
  call TI_triangle_red(G3tensor(26),RedBasis(5),mass3set(:,4),G0tensor(141),G0tensor(121),G0tensor(71),G0tensor(271),M2L1R1,[nMW], &
    G0tensor(124))
  call TI_triangle_red(G3tensor(27),RedBasis(5),mass3set(:,5),G0tensor(146),G0tensor(136),G0tensor(82), &
    G0tensor(76),M2L1R1,[nMW,nMZ],G0tensor(276),G0tensor(139))
  call TI_triangle_red(G3tensor(21),RedBasis(5),mass3set(:,10),G0tensor(321),G0tensor(109),G0tensor(84), &
    G0tensor(211),M2L1R1,[nMZ,nMW,nMH],G0tensor(123),G0tensor(88),G0tensor(196))
  call TI_triangle_red(G3tensor(22),RedBasis(5),mass3set(:,11),G0tensor(128),G0tensor(93),G0tensor(221), &
    G0tensor(138),M2L1R1,[nMW,nMH],G0tensor(103),G0tensor(236))
  call TI_triangle_red(G2tensor(70),RedBasis(54),mass3set(:,20),G0tensor(143),G0tensor(113),G0tensor(322), &
    G0tensor(246),M2L1R1,[nMH,nMW],G0tensor(148),G0tensor(118))
  call TI_triangle_red(G3tensor(35),RedBasis(54),mass3set(:,11),G0tensor(477),G0tensor(456),G0tensor(472), &
    G0tensor(451),M2L1R1,[nMW,nMH],G0tensor(461),G0tensor(466))
  call TI_triangle_red(G2tensor(328),RedBasis(56),mass3set(:,21),G0tensor(471),G0tensor(25),G0tensor(20), &
    G0tensor(10),M2L1R1,[nMW,nMH],G0tensor(474),G0tensor(329))
  call TI_triangle_red(G2tensor(261),RedBasis(1),mass3set(:,21),G0tensor(311),G0tensor(299),G0tensor(476), &
    G0tensor(566),M2L1R1,[nMW,nMH],G0tensor(536),G0tensor(539))
  call TI_triangle_red(G2tensor(93),RedBasis(56),mass3set(:,15),G0tensor(571),G0tensor(541),G0tensor(544), &
    G0tensor(444),M2L1R1,[nMZ,nMW],G0tensor(179),G0tensor(556))
  call TI_triangle_red(G2tensor(24),RedBasis(56),mass3set(:,16),G0tensor(546),G0tensor(549),G0tensor(561), &
    G0tensor(551),M2L1R1,[nMH,nMW],G0tensor(554),G0tensor(429))
  call TI_triangle_red(G2tensor(125),RedBasis(58),mass3set(:,22),G0tensor(159),G0tensor(244),G0tensor(219),G0tensor(64),M2L1R1)
  call TI_triangle_red(G2tensor(144),RedBasis(16),mass3set(:,22),G0tensor(39),G0tensor(254),G0tensor(229),G0tensor(69),M2L1R1)
  call TI_triangle_red(G2tensor(146),RedBasis(58),mass3set(:,23),G0tensor(44),G0tensor(559),G0tensor(564), &
    G0tensor(569),M2L1R1,[nMZ],G0tensor(574))
  call TI_triangle_red(G2tensor(5),RedBasis(16),mass3set(:,23),G0tensor(331),G0tensor(327),G0tensor(96),G0tensor(91),M2L1R1,[nMZ], &
    G0tensor(201))
  call TI_triangle_red(G2tensor(370),RedBasis(60),mass3set(:,22),G0tensor(94),G0tensor(301),G0tensor(297),G0tensor(131),M2L1R1)
  call TI_triangle_red(G2tensor(288),RedBasis(10),mass3set(:,22),G0tensor(126),G0tensor(261),G0tensor(129),G0tensor(576),M2L1R1)
  call TI_triangle_red(G2tensor(373),RedBasis(60),mass3set(:,23),G0tensor(617),G0tensor(581),G0tensor(612), &
    G0tensor(586),M2L1R1,[nMZ],G0tensor(591))
  call TI_triangle_red(G2tensor(67),RedBasis(10),mass3set(:,23),G0tensor(596),G0tensor(601),G0tensor(606), &
    G0tensor(611),M2L1R1,[nMZ],G0tensor(616))
  call TI_triangle_red(G2tensor(73),RedBasis(10),mass3set(:,2),G0tensor(506),G0tensor(496),G0tensor(491), &
    G0tensor(296),M2L1R1,[nMW],G0tensor(11))
  call TI_triangle_red(G2tensor(94),RedBasis(10),mass3set(:,3),G0tensor(304),G0tensor(12),G0tensor(309), &
    G0tensor(13),M2L1R1,[nMW,nMZ],G0tensor(416),G0tensor(152))
  call TI_triangle_red(G2tensor(6),RedBasis(8),mass3set(:,22),G0tensor(81),G0tensor(16),G0tensor(319),G0tensor(18),M2L1R1)
  call TI_triangle_red(G2tensor(177),RedBasis(8),mass3set(:,23),G0tensor(501),G0tensor(486),G0tensor(481), &
    G0tensor(326),M2L1R1,[nMZ],G0tensor(21))
  call TI_triangle_red(G2tensor(255),RedBasis(4),mass3set(:,22),G0tensor(334),G0tensor(22),G0tensor(339),G0tensor(23),M2L1R1)
  call TI_triangle_red(G2tensor(258),RedBasis(4),mass3set(:,23),G0tensor(431),G0tensor(172),G0tensor(106), &
    G0tensor(26),M2L1R1,[nMZ],G0tensor(344))
  call TI_triangle_red(G2tensor(382),RedBasis(60),mass3set(:,1),G0tensor(28),G0tensor(502),G0tensor(346), &
    G0tensor(31),M2L1R1,[nMZ,nMW],G0tensor(354),G0tensor(32))
  call TI_triangle_red(G2tensor(383),RedBasis(53),mass3set(:,1),G0tensor(359),G0tensor(33),G0tensor(364), &
    G0tensor(34),M2L1R1,[nMZ,nMW],G0tensor(567),G0tensor(161))
  call TI_triangle_red(G2tensor(285),RedBasis(58),mass3set(:,1),G0tensor(36),G0tensor(369),G0tensor(42), &
    G0tensor(37),M2L1R1,[nMZ,nMW],G0tensor(374),G0tensor(38))
  call TI_triangle_red(G2tensor(386),RedBasis(55),mass3set(:,1),G0tensor(572),G0tensor(437),G0tensor(432), &
    G0tensor(166),M2L1R1,[nMZ,nMW],G0tensor(41),G0tensor(379))
  call TI_triangle_red(G3tensor(14),RedBasis(5),mass3set(:,6),G0tensor(43),G0tensor(531),G0tensor(507),G0tensor(381),M2L1R1,[nML], &
    G0tensor(46))
  call TI_triangle_red(G3tensor(16),RedBasis(5),mass3set(:,7),G0tensor(389),G0tensor(47),G0tensor(394), &
    G0tensor(48),M2L1R1,[nMT,nMB],G0tensor(557),G0tensor(181))
  call TI_triangle_red(G3tensor(18),RedBasis(5),mass3set(:,8),G0tensor(51),G0tensor(404),G0tensor(57), &
    G0tensor(52),M2L1R1,[nMB,nMT],G0tensor(409),G0tensor(53))
  call TI_triangle_red(G3tensor(28),RedBasis(54),mass3set(:,6),G0tensor(562),G0tensor(422),G0tensor(417), &
    G0tensor(186),M2L1R1,[nML],G0tensor(56))
  call TI_triangle_red(G3tensor(30),RedBasis(54),mass3set(:,7),G0tensor(414),G0tensor(58),G0tensor(234), &
    G0tensor(209),M2L1R1,[nMT,nMB],G0tensor(67),G0tensor(62))
  call TI_triangle_red(G3tensor(32),RedBasis(54),mass3set(:,8),G0tensor(284),G0tensor(269),G0tensor(77), &
    G0tensor(72),M2L1R1,[nMB,nMT],G0tensor(316),G0tensor(83))
  call TI_triangle_red(G3tensor(37),RedBasis(56),mass3set(:,12),G0tensor(377),G0tensor(372),G0tensor(367), &
    G0tensor(206),M2L1R1,[nML],G0tensor(102))
  call TI_triangle_red(G3tensor(39),RedBasis(56),mass3set(:,13),G0tensor(87),G0tensor(357),G0tensor(352), &
    G0tensor(191),M2L1R1,[nMB,nMT],G0tensor(176),G0tensor(171))
  call TI_triangle_red(G3tensor(40),RedBasis(56),mass3set(:,14),G0tensor(92),G0tensor(194),G0tensor(97), &
    G0tensor(204),M2L1R1,[nMT,nMB],G0tensor(99),G0tensor(341))
  call TI_triangle_red(G2tensor(126),RedBasis(6),mass3set(:,18),G0tensor(108),G0tensor(342),G0tensor(231), &
    G0tensor(117),M2L1R1,[nMW],G0tensor(112))
  call TI_triangle_red(G2tensor(91),RedBasis(10),mass3set(:,1),G0tensor(412),G0tensor(407),G0tensor(402), &
    G0tensor(266),M2L1R1,[nMZ,nMW],G0tensor(137),G0tensor(122))
  call TI_triangle_red(G2tensor(83),RedBasis(6),mass3set(:,22),G0tensor(392),G0tensor(387),G0tensor(256),G0tensor(156),M2L1R1)
  call TI_triangle_red(G2tensor(77),RedBasis(6),mass3set(:,24),G0tensor(151),G0tensor(127),G0tensor(259), &
    G0tensor(132),M2L1R1,[nMZ],G0tensor(264))
  call TI_triangle_red(G2tensor(39),RedBasis(9),mass3set(:,18),G0tensor(134),G0tensor(317),G0tensor(281), &
    G0tensor(147),M2L1R1,[nMW],G0tensor(142))
  call TI_triangle_red(G2tensor(57),RedBasis(9),mass3set(:,22),G0tensor(421),G0tensor(153),G0tensor(426),G0tensor(154),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(9),mass3set(:,24),G0tensor(419),G0tensor(157),G0tensor(424), &
    G0tensor(158),M2L1R1,[nMZ],G0tensor(366))
  call TI_triangle_red(G2tensor(159),RedBasis(22),mass3set(:,4),G0tensor(167),G0tensor(162),G0tensor(371), &
    G0tensor(163),M2L1R1,[nMW],G0tensor(376))
  call TI_triangle_red(G2tensor(75),RedBasis(26),mass3set(:,4),G0tensor(168),G0tensor(436),G0tensor(173), &
    G0tensor(441),M2L1R1,[nMW],G0tensor(174))
  call TI_triangle_red(G2tensor(36),RedBasis(15),mass3set(:,4),G0tensor(434),G0tensor(177),G0tensor(439), &
    G0tensor(178),M2L1R1,[nMW],G0tensor(401))
  call TI_triangle_red(G2tensor(161),RedBasis(15),mass3set(:,25),G0tensor(187),G0tensor(182),G0tensor(406), &
    G0tensor(183),M2L1R1,[nMZ],G0tensor(411))
  call TI_triangle_red(G2tensor(32),RedBasis(9),mass3set(:,4),G0tensor(188),G0tensor(257),G0tensor(197), &
    G0tensor(192),M2L1R1,[nMW],G0tensor(202))
  call TI_triangle_red(G2tensor(38),RedBasis(20),mass3set(:,4),G0tensor(193),G0tensor(338),G0tensor(313), &
    G0tensor(308),M2L1R1,[nMW],G0tensor(263))
  call TI_triangle_red(G2tensor(92),RedBasis(20),mass3set(:,25),G0tensor(203),G0tensor(198),G0tensor(467), &
    G0tensor(267),M2L1R1,[nMZ],G0tensor(222))
  call TI_triangle_red(G2tensor(155),RedBasis(6),mass3set(:,4),G0tensor(212),G0tensor(207),G0tensor(227), &
    G0tensor(217),M2L1R1,[nMW],G0tensor(208))
  call TI_triangle_red(G2tensor(147),RedBasis(50),mass3set(:,2),G0tensor(273),G0tensor(218),G0tensor(213), &
    G0tensor(343),M2L1R1,[nMW],G0tensor(323))
  call TI_triangle_red(G2tensor(8),RedBasis(49),mass3set(:,2),G0tensor(318),G0tensor(278),G0tensor(228), &
    G0tensor(223),M2L1R1,[nMW],G0tensor(452))
  call TI_triangle_red(G2tensor(14),RedBasis(49),mass3set(:,3),G0tensor(282),G0tensor(247),G0tensor(237), &
    G0tensor(232),M2L1R1,[nMW,nMZ],G0tensor(368),G0tensor(252))
  call TI_triangle_red(G2tensor(110),RedBasis(24),mass3set(:,26),G0tensor(242),G0tensor(233),G0tensor(408), &
    G0tensor(373),M2L1R1,[nMH,nMZ],G0tensor(288),G0tensor(243))
  call TI_triangle_red(G3tensor(43),RedBasis(3),mass3set(:,9),G0tensor(238),G0tensor(413),G0tensor(378), &
    G0tensor(293),M2L1R1,[nMH,nMW,nMZ],G0tensor(253),G0tensor(248),G0tensor(262))
  call TI_triangle_red(G3tensor(68),RedBasis(24),mass3set(:,27),G0tensor(258),G0tensor(277),G0tensor(272), &
    G0tensor(268),M2L1R1,[nMW],G0tensor(403))
  call TI_triangle_red(G3tensor(51),RedBasis(3),mass3set(:,4),G0tensor(292),G0tensor(287),G0tensor(283), &
    G0tensor(306),M2L1R1,[nMW],G0tensor(298))
  call TI_triangle_red(G3tensor(52),RedBasis(3),mass3set(:,5),G0tensor(307),G0tensor(302),G0tensor(446), &
    G0tensor(333),M2L1R1,[nMW,nMZ],G0tensor(312),G0tensor(303))
  call TI_triangle_red(G2tensor(108),RedBasis(25),mass3set(:,27),G0tensor(336),G0tensor(328),G0tensor(337), &
    G0tensor(332),M2L1R1,[nMW],G0tensor(351))
  call TI_triangle_red(G2tensor(53),RedBasis(12),mass3set(:,4),G0tensor(347),G0tensor(356),G0tensor(348), &
    G0tensor(487),M2L1R1,[nMW],G0tensor(361))
  call TI_triangle_red(G2tensor(47),RedBasis(12),mass3set(:,5),G0tensor(349),G0tensor(362),G0tensor(353), &
    G0tensor(458),M2L1R1,[nMW,nMZ],G0tensor(398),G0tensor(393))
  call TI_triangle_red(G3tensor(20),RedBasis(5),mass3set(:,9),G0tensor(363),G0tensor(358),G0tensor(386), &
    G0tensor(382),M2L1R1,[nMH,nMW,nMZ],G0tensor(391),G0tensor(383),G0tensor(397))
  call TI_triangle_red(G2tensor(2),RedBasis(8),mass3set(:,1),G0tensor(388),G0tensor(427),G0tensor(418), &
    G0tensor(443),M2L1R1,[nMZ,nMW],G0tensor(438),G0tensor(428))
  call TI_triangle_red(G2tensor(149),RedBasis(12),mass3set(:,19),G0tensor(423),G0tensor(442),G0tensor(433), &
    G0tensor(447),M2L1R1,[nMZ,nMW],G0tensor(448),G0tensor(453))
  call TI_triangle_red(G2tensor(86),RedBasis(50),mass3set(:,28),G0tensor(457),G0tensor(15),G0tensor(462), &
    G0tensor(478),M2L1R1,[nMZ],G0tensor(463))
  call TI_triangle_red(G2tensor(4),RedBasis(49),mass3set(:,1),G0tensor(473),G0tensor(468),G0tensor(482), &
    G0tensor(483),M2L1R1,[nMZ,nMW],G0tensor(494),G0tensor(484))
  call TI_triangle_red(G3tensor(91),RedBasis(3),mass3set(:,22),G0tensor(488),G0tensor(493),G0tensor(498),G0tensor(503),M2L1R1)
  call TI_triangle_red(G2tensor(99),RedBasis(25),mass3set(:,29),G0tensor(504),G0tensor(508),G0tensor(509), &
    G0tensor(547),M2L1R1,[nMH,nMZ],G0tensor(511),G0tensor(522))
  call TI_triangle_red(G2tensor(60),RedBasis(12),mass3set(:,20),G0tensor(512),G0tensor(513),G0tensor(526), &
    G0tensor(516),M2L1R1,[nMH,nMW],G0tensor(517),G0tensor(518))
  call TI_triangle_red(G2tensor(68),RedBasis(12),mass3set(:,11),G0tensor(552),G0tensor(521),G0tensor(523), &
    G0tensor(527),M2L1R1,[nMW,nMH],G0tensor(528),G0tensor(532))
  call TI_triangle_red(G2tensor(101),RedBasis(25),mass3set(:,30),G0tensor(533),G0tensor(537),G0tensor(553), &
    G0tensor(548),M2L1R1,[nMZ,nMH],G0tensor(543),G0tensor(538))
  call TI_triangle_red(G2tensor(62),RedBasis(24),mass3set(:,31),G0tensor(542),G0tensor(573),G0tensor(568), &
    G0tensor(563),M2L1R1,[nMZ,nMH],G0tensor(558),G0tensor(577))
  call TI_triangle_red(G3tensor(47),RedBasis(3),mass3set(:,10),G0tensor(578),G0tensor(582),G0tensor(583), &
    G0tensor(587),M2L1R1,[nMZ,nMW,nMH],G0tensor(588),G0tensor(592),G0tensor(593))
  call TI_triangle_red(G3tensor(48),RedBasis(3),mass3set(:,11),G0tensor(597),G0tensor(618),G0tensor(598), &
    G0tensor(602),M2L1R1,[nMW,nMH],G0tensor(613),G0tensor(603))
  call TI_triangle_red(G2tensor(170),RedBasis(8),mass3set(:,18),G0tensor(607),G0tensor(608),G0tensor(620), &
    G0tensor(621),M2L1R1,[nMW],G0tensor(622))
  call TI_triangle_red(G3tensor(95),RedBasis(1),mass3set(:,32),G0tensor(623),G0tensor(624),G0tensor(625), &
    G0tensor(626),M2L1R1,[nMW],G0tensor(627))
  call TI_triangle_red(G2tensor(72),RedBasis(22),mass3set(:,22),G0tensor(628),G0tensor(629),G0tensor(630),G0tensor(631),M2L1R1)
  call TI_triangle_red(G2tensor(276),RedBasis(52),mass3set(:,2),G0tensor(632),G0tensor(633),G0tensor(634), &
    G0tensor(635),M2L1R1,[nMW],G0tensor(636))
  call TI_triangle_red(G2tensor(34),RedBasis(51),mass3set(:,2),G0tensor(637),G0tensor(638),G0tensor(639), &
    G0tensor(640),M2L1R1,[nMW],G0tensor(641))
  call TI_triangle_red(G2tensor(30),RedBasis(22),mass3set(:,18),G0tensor(642),G0tensor(643),G0tensor(644), &
    G0tensor(645),M2L1R1,[nMW],G0tensor(646))
  call TI_triangle_red(G2tensor(267),RedBasis(52),mass3set(:,22),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650),M2L1R1)
  call TI_triangle_red(G2tensor(184),RedBasis(51),mass3set(:,18),G0tensor(651),G0tensor(652),G0tensor(653), &
    G0tensor(654),M2L1R1,[nMW],G0tensor(655))
  call TI_triangle_red(G2tensor(96),RedBasis(22),mass3set(:,24),G0tensor(656),G0tensor(657),G0tensor(658), &
    G0tensor(659),M2L1R1,[nMZ],G0tensor(660))
  call TI_triangle_red(G2tensor(90),RedBasis(51),mass3set(:,3),G0tensor(661),G0tensor(662),G0tensor(663), &
    G0tensor(664),M2L1R1,[nMW,nMZ],G0tensor(665),G0tensor(666))
  call TI_triangle_red(G2tensor(167),RedBasis(52),mass3set(:,28),G0tensor(667),G0tensor(668),G0tensor(669), &
    G0tensor(670),M2L1R1,[nMZ],G0tensor(671))
  call TI_triangle_red(G2tensor(84),RedBasis(51),mass3set(:,1),G0tensor(672),G0tensor(673),G0tensor(674), &
    G0tensor(675),M2L1R1,[nMZ,nMW],G0tensor(676),G0tensor(677))
  call TI_triangle_red(G2tensor(88),RedBasis(50),mass3set(:,22),G0tensor(678),G0tensor(679),G0tensor(680),G0tensor(681),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(49),mass3set(:,18),G0tensor(682),G0tensor(683),G0tensor(684), &
    G0tensor(685),M2L1R1,[nMW],G0tensor(686))
  call TI_triangle_red(G2tensor(157),RedBasis(26),mass3set(:,22),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690),M2L1R1)
  call TI_triangle_red(G3tensor(74),RedBasis(21),mass3set(:,22),G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),M2L1R1)
  call TI_triangle_red(G2tensor(74),RedBasis(26),mass3set(:,24),G0tensor(695),G0tensor(696),G0tensor(697), &
    G0tensor(698),M2L1R1,[nMZ],G0tensor(699))
  call TI_triangle_red(G3tensor(87),RedBasis(5),mass3set(:,22),G0tensor(700),G0tensor(701),G0tensor(702),G0tensor(703),M2L1R1)
  call TI_triangle_red(G3tensor(60),RedBasis(25),mass3set(:,33),G0tensor(704),G0tensor(705),G0tensor(706), &
    G0tensor(707),M2L1R1,[nML],G0tensor(708))
  call TI_triangle_red(G3tensor(15),RedBasis(12),mass3set(:,6),G0tensor(709),G0tensor(710),G0tensor(711), &
    G0tensor(712),M2L1R1,[nML],G0tensor(713))
  call TI_triangle_red(G3tensor(61),RedBasis(25),mass3set(:,34),G0tensor(714),G0tensor(715),G0tensor(716), &
    G0tensor(717),M2L1R1,[nMT],G0tensor(718))
  call TI_triangle_red(G3tensor(17),RedBasis(12),mass3set(:,7),G0tensor(719),G0tensor(720),G0tensor(721), &
    G0tensor(722),M2L1R1,[nMT,nMB],G0tensor(723),G0tensor(724))
  call TI_triangle_red(G3tensor(62),RedBasis(25),mass3set(:,35),G0tensor(725),G0tensor(726),G0tensor(727), &
    G0tensor(728),M2L1R1,[nMB],G0tensor(729))
  call TI_triangle_red(G3tensor(19),RedBasis(12),mass3set(:,8),G0tensor(730),G0tensor(731),G0tensor(732), &
    G0tensor(733),M2L1R1,[nMB,nMT],G0tensor(734),G0tensor(735))
  call TI_triangle_red(G3tensor(104),RedBasis(24),mass3set(:,33),G0tensor(736),G0tensor(737),G0tensor(738), &
    G0tensor(739),M2L1R1,[nML],G0tensor(740))
  call TI_triangle_red(G3tensor(29),RedBasis(3),mass3set(:,6),G0tensor(741),G0tensor(742),G0tensor(743), &
    G0tensor(744),M2L1R1,[nML],G0tensor(745))
  call TI_triangle_red(G3tensor(105),RedBasis(24),mass3set(:,34),G0tensor(746),G0tensor(747),G0tensor(748), &
    G0tensor(749),M2L1R1,[nMT],G0tensor(750))
  call TI_triangle_red(G3tensor(31),RedBasis(3),mass3set(:,7),G0tensor(751),G0tensor(752),G0tensor(753), &
    G0tensor(754),M2L1R1,[nMT,nMB],G0tensor(755),G0tensor(756))
  call TI_triangle_red(G3tensor(106),RedBasis(24),mass3set(:,35),G0tensor(757),G0tensor(758),G0tensor(759), &
    G0tensor(760),M2L1R1,[nMB],G0tensor(761))
  call TI_triangle_red(G3tensor(33),RedBasis(3),mass3set(:,8),G0tensor(762),G0tensor(763),G0tensor(764), &
    G0tensor(765),M2L1R1,[nMB,nMT],G0tensor(766),G0tensor(767))
  call TI_triangle_red(G3tensor(66),RedBasis(5),mass3set(:,36),G0tensor(768),G0tensor(769),G0tensor(770), &
    G0tensor(771),M2L1R1,[nML],G0tensor(772))
  call TI_triangle_red(G3tensor(38),RedBasis(3),mass3set(:,36),G0tensor(773),G0tensor(774),G0tensor(775), &
    G0tensor(776),M2L1R1,[nML],G0tensor(777))
  call TI_triangle_red(G2tensor(49),RedBasis(58),mass3set(:,18),G0tensor(778),G0tensor(779),G0tensor(780), &
    G0tensor(781),M2L1R1,[nMW],G0tensor(782))
  call TI_triangle_red(G3tensor(73),RedBasis(21),mass3set(:,36),G0tensor(783),G0tensor(784),G0tensor(785), &
    G0tensor(786),M2L1R1,[nML],G0tensor(787))
  call TI_triangle_red(G2tensor(143),RedBasis(26),mass3set(:,18),G0tensor(788),G0tensor(789),G0tensor(790), &
    G0tensor(791),M2L1R1,[nMW],G0tensor(792))
  call TI_triangle_red(G2tensor(291),RedBasis(10),mass3set(:,18),G0tensor(793),G0tensor(794),G0tensor(795), &
    G0tensor(796),M2L1R1,[nMW],G0tensor(797))
  call TI_triangle_red(G1tensor(497),RedBasis(61),mass3set(:,32),G0tensor(798),G0tensor(799),G0tensor(800), &
    G0tensor(801),M2L1R1,[nMW],G0tensor(802))
  call TI_triangle_red(G1tensor(295),RedBasis(4),mass3set(:,37),G0tensor(803),G0tensor(804),G0tensor(805), &
    G0tensor(806),M2L1R1,[nMH,nMW],G0tensor(807),G0tensor(808))
  call TI_triangle_red(G1tensor(300),RedBasis(2),mass3set(:,37),G0tensor(809),G0tensor(810),G0tensor(811), &
    G0tensor(812),M2L1R1,[nMH,nMW],G0tensor(813),G0tensor(814))
  call TI_triangle_red(G1tensor(407),RedBasis(61),mass3set(:,38),G0tensor(815),G0tensor(816),G0tensor(817), &
    G0tensor(818),M2L1R1,[nMZ],G0tensor(819))
  call TI_triangle_red(G1tensor(310),RedBasis(2),mass3set(:,3),G0tensor(820),G0tensor(821),G0tensor(822), &
    G0tensor(823),M2L1R1,[nMW,nMZ],G0tensor(824),G0tensor(825))
  call TI_triangle_red(G1tensor(492),RedBasis(64),mass3set(:,32),G0tensor(826),G0tensor(827),G0tensor(828), &
    G0tensor(829),M2L1R1,[nMW],G0tensor(830))
  call TI_triangle_red(G1tensor(325),RedBasis(8),mass3set(:,37),G0tensor(831),G0tensor(832),G0tensor(833), &
    G0tensor(834),M2L1R1,[nMH,nMW],G0tensor(835),G0tensor(836))
  call TI_triangle_red(G1tensor(330),RedBasis(7),mass3set(:,37),G0tensor(837),G0tensor(838),G0tensor(839), &
    G0tensor(840),M2L1R1,[nMH,nMW],G0tensor(841),G0tensor(842))
  call TI_triangle_red(G1tensor(422),RedBasis(64),mass3set(:,38),G0tensor(843),G0tensor(844),G0tensor(845), &
    G0tensor(846),M2L1R1,[nMZ],G0tensor(847))
  call TI_triangle_red(G1tensor(335),RedBasis(7),mass3set(:,3),G0tensor(848),G0tensor(849),G0tensor(850), &
    G0tensor(851),M2L1R1,[nMW,nMZ],G0tensor(852),G0tensor(853))
  call TI_triangle_red(G1tensor(345),RedBasis(13),mass3set(:,28),G0tensor(854),G0tensor(855),G0tensor(856), &
    G0tensor(857),M2L1R1,[nMZ],G0tensor(858))
  call TI_triangle_red(G1tensor(350),RedBasis(11),mass3set(:,1),G0tensor(859),G0tensor(860),G0tensor(861), &
    G0tensor(862),M2L1R1,[nMZ,nMW],G0tensor(863),G0tensor(864))
  call TI_triangle_red(G1tensor(360),RedBasis(13),mass3set(:,2),G0tensor(865),G0tensor(866),G0tensor(867), &
    G0tensor(868),M2L1R1,[nMW],G0tensor(869))
  call TI_triangle_red(G1tensor(365),RedBasis(11),mass3set(:,2),G0tensor(870),G0tensor(871),G0tensor(872), &
    G0tensor(873),M2L1R1,[nMW],G0tensor(874))
  call TI_triangle_red(G1tensor(370),RedBasis(11),mass3set(:,3),G0tensor(875),G0tensor(876),G0tensor(877), &
    G0tensor(878),M2L1R1,[nMW,nMZ],G0tensor(879),G0tensor(880))
  call TI_triangle_red(G1tensor(380),RedBasis(18),mass3set(:,28),G0tensor(881),G0tensor(882),G0tensor(883), &
    G0tensor(884),M2L1R1,[nMZ],G0tensor(885))
  call TI_triangle_red(G1tensor(385),RedBasis(17),mass3set(:,1),G0tensor(886),G0tensor(887),G0tensor(888), &
    G0tensor(889),M2L1R1,[nMZ,nMW],G0tensor(890),G0tensor(891))
  call TI_triangle_red(G1tensor(395),RedBasis(18),mass3set(:,2),G0tensor(892),G0tensor(893),G0tensor(894), &
    G0tensor(895),M2L1R1,[nMW],G0tensor(896))
  call TI_triangle_red(G1tensor(400),RedBasis(17),mass3set(:,2),G0tensor(897),G0tensor(898),G0tensor(899), &
    G0tensor(900),M2L1R1,[nMW],G0tensor(901))
  call TI_triangle_red(G1tensor(405),RedBasis(17),mass3set(:,3),G0tensor(902),G0tensor(903),G0tensor(904), &
    G0tensor(905),M2L1R1,[nMW,nMZ],G0tensor(906),G0tensor(907))
  call TI_triangle_red(G1tensor(307),RedBasis(57),mass3set(:,3),G0tensor(908),G0tensor(909),G0tensor(910), &
    G0tensor(911),M2L1R1,[nMW,nMZ],G0tensor(912),G0tensor(913))
  call TI_triangle_red(G1tensor(185),RedBasis(22),mass3set(:,39),G0tensor(914),G0tensor(915),G0tensor(916), &
    G0tensor(917),M2L1R1,[nMH,nMZ],G0tensor(918),G0tensor(919))
  call TI_triangle_red(G1tensor(195),RedBasis(10),mass3set(:,37),G0tensor(920),G0tensor(921),G0tensor(922), &
    G0tensor(923),M2L1R1,[nMH,nMW],G0tensor(924),G0tensor(925))
  call TI_triangle_red(G1tensor(332),RedBasis(59),mass3set(:,3),G0tensor(926),G0tensor(927),G0tensor(928), &
    G0tensor(929),M2L1R1,[nMW,nMZ],G0tensor(930),G0tensor(931))
  call TI_triangle_red(G1tensor(250),RedBasis(26),mass3set(:,39),G0tensor(932),G0tensor(933),G0tensor(934), &
    G0tensor(935),M2L1R1,[nMH,nMZ],G0tensor(936),G0tensor(937))
  call TI_triangle_red(G1tensor(255),RedBasis(16),mass3set(:,37),G0tensor(938),G0tensor(939),G0tensor(940), &
    G0tensor(941),M2L1R1,[nMH,nMW],G0tensor(942),G0tensor(943))
  call TI_triangle_red(G1tensor(412),RedBasis(59),mass3set(:,23),G0tensor(944),G0tensor(945),G0tensor(946), &
    G0tensor(947),M2L1R1,[nMZ],G0tensor(948))
  call TI_triangle_red(G1tensor(417),RedBasis(53),mass3set(:,23),G0tensor(949),G0tensor(950),G0tensor(951), &
    G0tensor(952),M2L1R1,[nMZ],G0tensor(953))
  call TI_triangle_red(G1tensor(211),RedBasis(28),mass3set(:,38),G0tensor(954),G0tensor(955),G0tensor(956), &
    G0tensor(957),M2L1R1,[nMZ],G0tensor(958))
  call TI_triangle_red(G1tensor(415),RedBasis(7),mass3set(:,23),G0tensor(959),G0tensor(960),G0tensor(961), &
    G0tensor(962),M2L1R1,[nMZ],G0tensor(963))
  call TI_triangle_red(G1tensor(357),RedBasis(63),mass3set(:,2),G0tensor(964),G0tensor(965),G0tensor(966), &
    G0tensor(967),M2L1R1,[nMW],G0tensor(968))
  call TI_triangle_red(G1tensor(362),RedBasis(62),mass3set(:,2),G0tensor(969),G0tensor(970),G0tensor(971), &
    G0tensor(972),M2L1R1,[nMW],G0tensor(973))
  call TI_triangle_red(G1tensor(367),RedBasis(62),mass3set(:,3),G0tensor(974),G0tensor(975),G0tensor(976), &
    G0tensor(977),M2L1R1,[nMW,nMZ],G0tensor(978),G0tensor(979))
  call TI_triangle_red(G1tensor(427),RedBasis(57),mass3set(:,23),G0tensor(980),G0tensor(981),G0tensor(982), &
    G0tensor(983),M2L1R1,[nMZ],G0tensor(984))
  call TI_triangle_red(G1tensor(432),RedBasis(55),mass3set(:,23),G0tensor(985),G0tensor(986),G0tensor(987), &
    G0tensor(988),M2L1R1,[nMZ],G0tensor(989))
  call TI_triangle_red(G1tensor(231),RedBasis(29),mass3set(:,38),G0tensor(990),G0tensor(991),G0tensor(992), &
    G0tensor(993),M2L1R1,[nMZ],G0tensor(994))
  call TI_triangle_red(G1tensor(430),RedBasis(2),mass3set(:,23),G0tensor(995),G0tensor(996),G0tensor(997), &
    G0tensor(998),M2L1R1,[nMZ],G0tensor(999))
  call TI_triangle_red(G1tensor(193),RedBasis(23),mass3set(:,39),G0tensor(1000),G0tensor(1001),G0tensor(1002), &
    G0tensor(1003),M2L1R1,[nMH,nMZ],G0tensor(1004),G0tensor(1005))
  call TI_triangle_red(G1tensor(218),RedBasis(23),mass3set(:,4),G0tensor(1006),G0tensor(1007),G0tensor(1008), &
    G0tensor(1009),M2L1R1,[nMW],G0tensor(1010))
  call TI_triangle_red(G1tensor(359),RedBasis(14),mass3set(:,4),G0tensor(1011),G0tensor(1012),G0tensor(1013), &
    G0tensor(1014),M2L1R1,[nMW],G0tensor(1015))
  call TI_triangle_red(G1tensor(253),RedBasis(27),mass3set(:,39),G0tensor(1016),G0tensor(1017),G0tensor(1018), &
    G0tensor(1019),M2L1R1,[nMH,nMZ],G0tensor(1020),G0tensor(1021))
  call TI_triangle_red(G1tensor(268),RedBasis(27),mass3set(:,4),G0tensor(1022),G0tensor(1023),G0tensor(1024), &
    G0tensor(1025),M2L1R1,[nMW],G0tensor(1026))
  call TI_triangle_red(G1tensor(394),RedBasis(19),mass3set(:,4),G0tensor(1027),G0tensor(1028),G0tensor(1029), &
    G0tensor(1030),M2L1R1,[nMW],G0tensor(1031))
  call TI_triangle_red(G1tensor(297),RedBasis(57),mass3set(:,1),G0tensor(1032),G0tensor(1033),G0tensor(1034), &
    G0tensor(1035),M2L1R1,[nMZ,nMW],G0tensor(1036),G0tensor(1037))
  call TI_triangle_red(G1tensor(298),RedBasis(6),mass3set(:,39),G0tensor(1038),G0tensor(1039),G0tensor(1040), &
    G0tensor(1041),M2L1R1,[nMH,nMZ],G0tensor(1042),G0tensor(1043))
  call TI_triangle_red(G1tensor(327),RedBasis(59),mass3set(:,1),G0tensor(1044),G0tensor(1045),G0tensor(1046), &
    G0tensor(1047),M2L1R1,[nMZ,nMW],G0tensor(1048),G0tensor(1049))
  call TI_triangle_red(G1tensor(328),RedBasis(9),mass3set(:,39),G0tensor(1050),G0tensor(1051),G0tensor(1052), &
    G0tensor(1053),M2L1R1,[nMH,nMZ],G0tensor(1054),G0tensor(1055))
  call TI_triangle_red(G1tensor(342),RedBasis(63),mass3set(:,28),G0tensor(1056),G0tensor(1057),G0tensor(1058), &
    G0tensor(1059),M2L1R1,[nMZ],G0tensor(1060))
  call TI_triangle_red(G1tensor(347),RedBasis(62),mass3set(:,1),G0tensor(1061),G0tensor(1062),G0tensor(1063), &
    G0tensor(1064),M2L1R1,[nMZ,nMW],G0tensor(1065),G0tensor(1066))
  call TI_triangle_red(G1tensor(353),RedBasis(14),mass3set(:,25),G0tensor(1067),G0tensor(1068),G0tensor(1069), &
    G0tensor(1070),M2L1R1,[nMZ],G0tensor(1071))
  call TI_triangle_red(G1tensor(388),RedBasis(19),mass3set(:,25),G0tensor(1072),G0tensor(1073),G0tensor(1074), &
    G0tensor(1075),M2L1R1,[nMZ],G0tensor(1076))
  call TI_triangle_red(G1tensor(418),RedBasis(23),mass3set(:,24),G0tensor(1077),G0tensor(1078),G0tensor(1079), &
    G0tensor(1080),M2L1R1,[nMZ],G0tensor(1081))
  call TI_triangle_red(G1tensor(433),RedBasis(27),mass3set(:,24),G0tensor(1082),G0tensor(1083),G0tensor(1084), &
    G0tensor(1085),M2L1R1,[nMZ],G0tensor(1086))
  call TI_triangle_red(G1tensor(474),RedBasis(7),mass3set(:,18),G0tensor(1087),G0tensor(1088),G0tensor(1089), &
    G0tensor(1090),M2L1R1,[nMW],G0tensor(1091))
  call TI_triangle_red(G1tensor(479),RedBasis(7),mass3set(:,1),G0tensor(1092),G0tensor(1093),G0tensor(1094), &
    G0tensor(1095),M2L1R1,[nMZ,nMW],G0tensor(1096),G0tensor(1097))
  call TI_triangle_red(G1tensor(484),RedBasis(2),mass3set(:,18),G0tensor(1098),G0tensor(1099),G0tensor(1100), &
    G0tensor(1101),M2L1R1,[nMW],G0tensor(1102))
  call TI_triangle_red(G1tensor(489),RedBasis(2),mass3set(:,1),G0tensor(1103),G0tensor(1104),G0tensor(1105), &
    G0tensor(1106),M2L1R1,[nMZ,nMW],G0tensor(1107),G0tensor(1108))
  call TI_triangle_red(G1tensor(494),RedBasis(27),mass3set(:,18),G0tensor(1109),G0tensor(1110),G0tensor(1111), &
    G0tensor(1112),M2L1R1,[nMW],G0tensor(1113))
  call TI_triangle_red(G1tensor(236),RedBasis(29),mass3set(:,32),G0tensor(1114),G0tensor(1115),G0tensor(1116), &
    G0tensor(1117),M2L1R1,[nMW],G0tensor(1118))
  call TI_triangle_red(G1tensor(499),RedBasis(23),mass3set(:,18),G0tensor(1119),G0tensor(1120),G0tensor(1121), &
    G0tensor(1122),M2L1R1,[nMW],G0tensor(1123))
  call TI_triangle_red(G1tensor(216),RedBasis(28),mass3set(:,32),G0tensor(1124),G0tensor(1125),G0tensor(1126), &
    G0tensor(1127),M2L1R1,[nMW],G0tensor(1128))
  call ol_merge_tensors(T0sum(132),[G0tensor(30)])
  call ol_merge_tensors(T0sum(133),[G0tensor(60)])
  call ol_merge_tensors(T0sum(134),[G0tensor(85)])
  call ol_merge_tensors(T0sum(135),[G0tensor(115)])
  call ol_merge_tensors(T0sum(136),[G0tensor(140)])
  call ol_merge_tensors(T0sum(137),[G0tensor(170)])
  call ol_merge_tensors(T0sum(138),[G0tensor(195)])
  call ol_merge_tensors(T0sum(139),[G0tensor(225)])
  call ol_merge_tensors(T0sum(140),[G0tensor(255)])
  call ol_merge_tensors(T0sum(141),[G0tensor(290)])
  call ol_merge_tensors(T0sum(142),[G0tensor(325)])
  call ol_merge_tensors(T0sum(143),[G0tensor(355)])
  call ol_merge_tensors(T0sum(144),[G0tensor(380)])
  call ol_merge_tensors(T0sum(145),[G0tensor(410)])
  call ol_merge_tensors(T0sum(146),[G0tensor(440)])
  call ol_merge_tensors(T0sum(147),[G0tensor(470)])
  call ol_merge_tensors(T0sum(148),[G0tensor(500)])
  call ol_merge_tensors(T0sum(149),[G0tensor(5)])
  call ol_merge_tensors(T0sum(150),[G0tensor(510)])
  call ol_merge_tensors(T0sum(151),[G0tensor(535)])
  call ol_merge_tensors(T0sum(152),[G0tensor(565)])
  call ol_merge_tensors(T0sum(153),[G0tensor(595)])
  call ol_merge_tensors(T0sum(154),[G0tensor(497)])
  call ol_merge_tensors(T0sum(155),[G0tensor(144)])
  call ol_merge_tensors(T0sum(156),[G0tensor(239)])
  call ol_merge_tensors(T0sum(157),[G0tensor(78)])
  call ol_merge_tensors(T0sum(158),[G0tensor(604)])
  call ol_merge_tensors(T0sum(159),[G0tensor(98)])
  call ol_merge_tensors(T0sum(160),[G0tensor(614)])
  call ol_merge_tensors(T0sum(161),[G0tensor(314)])
  call ol_merge_tensors(T0sum(162),[G0tensor(19)])
  call ol_merge_tensors(T0sum(163),[G0tensor(519)])
  call ol_merge_tensors(T0sum(164),[G0tensor(529)])
  call ol_merge_tensors(T0sum(165),[G0tensor(86)])
  call ol_merge_tensors(T0sum(166),[G0tensor(107)])
  call ol_merge_tensors(T0sum(167),[G0tensor(164)])
  call ol_merge_tensors(T0sum(168),[G0tensor(141)])
  call ol_merge_tensors(T0sum(169),[G0tensor(146)])
  call ol_merge_tensors(T0sum(170),[G0tensor(321)])
  call ol_merge_tensors(T0sum(171),[G0tensor(128)])
  call ol_merge_tensors(T0sum(172),[G0tensor(143)])
  call ol_merge_tensors(T0sum(173),[G0tensor(477)])
  call ol_merge_tensors(T0sum(174),[G0tensor(471)])
  call ol_merge_tensors(T0sum(175),[G0tensor(311)])
  call ol_merge_tensors(T0sum(176),[G0tensor(571)])
  call ol_merge_tensors(T0sum(177),[G0tensor(546)])
  call ol_merge_tensors(T0sum(178),[G0tensor(159)])
  call ol_merge_tensors(T0sum(179),[G0tensor(39)])
  call ol_merge_tensors(T0sum(180),[G0tensor(44)])
  call ol_merge_tensors(T0sum(181),[G0tensor(331)])
  call ol_merge_tensors(T0sum(182),[G0tensor(94)])
  call ol_merge_tensors(T0sum(183),[G0tensor(126)])
  call ol_merge_tensors(T0sum(184),[G0tensor(617)])
  call ol_merge_tensors(T0sum(185),[G0tensor(596)])
  call ol_merge_tensors(T0sum(186),[G0tensor(506)])
  call ol_merge_tensors(T0sum(187),[G0tensor(304)])
  call ol_merge_tensors(T0sum(188),[G0tensor(81)])
  call ol_merge_tensors(T0sum(189),[G0tensor(501)])
  call ol_merge_tensors(T0sum(190),[G0tensor(334)])
  call ol_merge_tensors(T0sum(191),[G0tensor(431)])
  call ol_merge_tensors(T0sum(192),[G0tensor(28)])
  call ol_merge_tensors(T0sum(193),[G0tensor(359)])
  call ol_merge_tensors(T0sum(194),[G0tensor(36)])
  call ol_merge_tensors(T0sum(195),[G0tensor(572)])
  call ol_merge_tensors(T0sum(196),[G0tensor(43)])
  call ol_merge_tensors(T0sum(197),[G0tensor(389)])
  call ol_merge_tensors(T0sum(198),[G0tensor(51)])
  call ol_merge_tensors(T0sum(199),[G0tensor(562)])
  call ol_merge_tensors(T0sum(200),[G0tensor(414)])
  call ol_merge_tensors(T0sum(201),[G0tensor(284)])
  call ol_merge_tensors(T0sum(202),[G0tensor(377)])
  call ol_merge_tensors(T0sum(203),[G0tensor(87)])
  call ol_merge_tensors(T0sum(204),[G0tensor(92)])
  call ol_merge_tensors(T0sum(205),[G0tensor(798)])
  call ol_merge_tensors(T0sum(206),[G0tensor(803)])
  call ol_merge_tensors(T0sum(207),[G0tensor(809)])
  call ol_merge_tensors(T0sum(208),[G0tensor(815)])
  call ol_merge_tensors(T0sum(209),[G0tensor(820)])
  call ol_merge_tensors(T0sum(210),[G0tensor(826)])
  call ol_merge_tensors(T0sum(211),[G0tensor(831)])
  call ol_merge_tensors(T0sum(212),[G0tensor(837)])
  call ol_merge_tensors(T0sum(213),[G0tensor(843)])
  call ol_merge_tensors(T0sum(214),[G0tensor(848)])
  call ol_merge_tensors(T0sum(215),[G0tensor(108)])
  call ol_merge_tensors(T0sum(216),[G0tensor(854)])
  call ol_merge_tensors(T0sum(217),[G0tensor(859)])
  call ol_merge_tensors(T0sum(218),[G0tensor(412)])
  call ol_merge_tensors(T0sum(219),[G0tensor(392)])
  call ol_merge_tensors(T0sum(220),[G0tensor(865)])
  call ol_merge_tensors(T0sum(221),[G0tensor(870)])
  call ol_merge_tensors(T0sum(222),[G0tensor(151)])
  call ol_merge_tensors(T0sum(223),[G0tensor(875)])
  call ol_merge_tensors(T0sum(224),[G0tensor(134)])
  call ol_merge_tensors(T0sum(225),[G0tensor(881)])
  call ol_merge_tensors(T0sum(226),[G0tensor(886)])
  call ol_merge_tensors(T0sum(227),[G0tensor(421)])
  call ol_merge_tensors(T0sum(228),[G0tensor(892)])
  call ol_merge_tensors(T0sum(229),[G0tensor(897)])
  call ol_merge_tensors(T0sum(230),[G0tensor(419)])
  call ol_merge_tensors(T0sum(231),[G0tensor(902)])
  call ol_merge_tensors(T0sum(232),[G0tensor(167)])
  call ol_merge_tensors(T0sum(233),[G0tensor(168)])
  call ol_merge_tensors(T0sum(234),[G0tensor(908)])
  call ol_merge_tensors(T0sum(235),[G0tensor(434)])
  call ol_merge_tensors(T0sum(236),[G0tensor(187)])
  call ol_merge_tensors(T0sum(237),[G0tensor(914)])
  call ol_merge_tensors(T0sum(238),[G0tensor(920)])
  call ol_merge_tensors(T0sum(239),[G0tensor(926)])
  call ol_merge_tensors(T0sum(240),[G0tensor(188)])
  call ol_merge_tensors(T0sum(241),[G0tensor(193)])
  call ol_merge_tensors(T0sum(242),[G0tensor(203)])
  call ol_merge_tensors(T0sum(243),[G0tensor(932)])
  call ol_merge_tensors(T0sum(244),[G0tensor(938)])
  call ol_merge_tensors(T0sum(245),[G0tensor(212)])
  call ol_merge_tensors(T0sum(246),[G0tensor(944)])
  call ol_merge_tensors(T0sum(247),[G0tensor(949)])
  call ol_merge_tensors(T0sum(248),[G0tensor(954)])
  call ol_merge_tensors(T0sum(249),[G0tensor(959)])
  call ol_merge_tensors(T0sum(250),[G0tensor(964)])
  call ol_merge_tensors(T0sum(251),[G0tensor(969)])
  call ol_merge_tensors(T0sum(252),[G0tensor(974)])
  call ol_merge_tensors(T0sum(253),[G0tensor(980)])
  call ol_merge_tensors(T0sum(254),[G0tensor(985)])
  call ol_merge_tensors(T0sum(255),[G0tensor(990)])
  call ol_merge_tensors(T0sum(256),[G0tensor(995)])
  call ol_merge_tensors(T0sum(257),[G0tensor(273)])
  call ol_merge_tensors(T0sum(258),[G0tensor(318)])
  call ol_merge_tensors(T0sum(259),[G0tensor(282)])
  call ol_merge_tensors(T0sum(260),[G0tensor(242)])
  call ol_merge_tensors(T0sum(261),[G0tensor(1000)])
  call ol_merge_tensors(T0sum(262),[G0tensor(238)])
  call ol_merge_tensors(T0sum(263),[G0tensor(258)])
  call ol_merge_tensors(T0sum(264),[G0tensor(1006)])
  call ol_merge_tensors(T0sum(265),[G0tensor(292)])
  call ol_merge_tensors(T0sum(266),[G0tensor(307)])
  call ol_merge_tensors(T0sum(267),[G0tensor(336)])
  call ol_merge_tensors(T0sum(268),[G0tensor(1011)])
  call ol_merge_tensors(T0sum(269),[G0tensor(347)])
  call ol_merge_tensors(T0sum(270),[G0tensor(349)])
  call ol_merge_tensors(T0sum(271),[G0tensor(1016)])
  call ol_merge_tensors(T0sum(272),[G0tensor(1022)])
  call ol_merge_tensors(T0sum(273),[G0tensor(1027)])
  call ol_merge_tensors(T0sum(274),[G0tensor(1032)])
  call ol_merge_tensors(T0sum(275),[G0tensor(1038)])
  call ol_merge_tensors(T0sum(276),[G0tensor(363)])
  call ol_merge_tensors(T0sum(277),[G0tensor(1044)])
  call ol_merge_tensors(T0sum(278),[G0tensor(1050)])
  call ol_merge_tensors(T0sum(279),[G0tensor(1056)])
  call ol_merge_tensors(T0sum(280),[G0tensor(1061)])
  call ol_merge_tensors(T0sum(281),[G0tensor(388)])
  call ol_merge_tensors(T0sum(282),[G0tensor(1067)])
  call ol_merge_tensors(T0sum(283),[G0tensor(423)])
  call ol_merge_tensors(T0sum(284),[G0tensor(457)])
  call ol_merge_tensors(T0sum(285),[G0tensor(473)])
  call ol_merge_tensors(T0sum(286),[G0tensor(1072)])
  call ol_merge_tensors(T0sum(287),[G0tensor(1077)])
  call ol_merge_tensors(T0sum(288),[G0tensor(488)])
  call ol_merge_tensors(T0sum(289),[G0tensor(1082)])
  call ol_merge_tensors(T0sum(290),[G0tensor(504)])
  call ol_merge_tensors(T0sum(291),[G0tensor(512)])
  call ol_merge_tensors(T0sum(292),[G0tensor(552)])
  call ol_merge_tensors(T0sum(293),[G0tensor(533)])
  call ol_merge_tensors(T0sum(294),[G0tensor(542)])
  call ol_merge_tensors(T0sum(295),[G0tensor(578)])
  call ol_merge_tensors(T0sum(296),[G0tensor(597)])
  call ol_merge_tensors(T0sum(297),[G0tensor(607)])
  call ol_merge_tensors(T0sum(298),[G0tensor(1087)])
  call ol_merge_tensors(T0sum(299),[G0tensor(623)])
  call ol_merge_tensors(T0sum(300),[G0tensor(1092)])
  call ol_merge_tensors(T0sum(301),[G0tensor(1098)])
  call ol_merge_tensors(T0sum(302),[G0tensor(1103)])
  call ol_merge_tensors(T0sum(303),[G0tensor(1109)])
  call ol_merge_tensors(T0sum(304),[G0tensor(1114)])
  call ol_merge_tensors(T0sum(305),[G0tensor(1119)])
  call ol_merge_tensors(T0sum(306),[G0tensor(1124)])
  call ol_merge_tensors(T1sum(25),[G1tensor(502)])
  call ol_merge_tensors(T1sum(26),[G1tensor(503)])
  call ol_merge_tensors(T1sum(27),[G1tensor(504)])
  call ol_merge_tensors(T1sum(28),[G1tensor(517)])
  call ol_merge_tensors(T1sum(29),[G1tensor(535)])
  call ol_merge_tensors(T1sum(30),[G1tensor(507)])
  call ol_merge_tensors(T1sum(31),[G1tensor(508)])
  call ol_merge_tensors(T1sum(32),[G1tensor(521)])
  call ol_merge_tensors(T1sum(33),[G1tensor(531)])
  call ol_merge_tensors(T1sum(34),[G1tensor(511)])
  call ol_merge_tensors(T1sum(35),[G1tensor(512)])
  call ol_merge_tensors(T1sum(36),[G1tensor(525)])
  call ol_merge_tensors(T1sum(37),[G1tensor(514)])
  call ol_merge_tensors(T1sum(38),[G1tensor(515)])
  call ol_merge_tensors(T1sum(39),[G1tensor(516)])
  call ol_merge_tensors(T1sum(40),[G1tensor(518)])
  call ol_merge_tensors(T1sum(41),[G1tensor(519)])
  call ol_merge_tensors(T1sum(42),[G1tensor(536)])
  call ol_merge_tensors(T1sum(43),[G1tensor(522)])
  call ol_merge_tensors(T1sum(44),[G1tensor(523)])
  call ol_merge_tensors(T1sum(45),[G1tensor(532)])
  call ol_merge_tensors(T1sum(46),[G1tensor(526)])
  call ol_merge_tensors(T1sum(47),[G1tensor(527)])
  call ol_merge_tensors(T1sum(48),[G1tensor(528)])
  call ol_merge_tensors(T1sum(49),[G1tensor(529)])
  call ol_merge_tensors(T1sum(50),[G1tensor(530)])
  call ol_merge_tensors(T1sum(51),[G1tensor(533)])
  call ol_merge_tensors(T1sum(52),[G1tensor(534)])
  call ol_merge_tensors(T1sum(53),[G1tensor(537)])
  call ol_merge_tensors(T0sum(307),[G0tensor(628)])
  call ol_merge_tensors(T0sum(308),[G0tensor(632)])
  call ol_merge_tensors(T0sum(309),[G0tensor(637)])
  call ol_merge_tensors(T0sum(310),[G0tensor(642)])
  call ol_merge_tensors(T0sum(311),[G0tensor(647)])
  call ol_merge_tensors(T0sum(312),[G0tensor(651)])
  call ol_merge_tensors(T0sum(313),[G0tensor(656)])
  call ol_merge_tensors(T0sum(314),[G0tensor(661)])
  call ol_merge_tensors(T0sum(315),[G0tensor(667)])
  call ol_merge_tensors(T0sum(316),[G0tensor(672)])
  call ol_merge_tensors(T0sum(317),[G0tensor(678)])
  call ol_merge_tensors(T0sum(318),[G0tensor(682)])
  call ol_merge_tensors(T0sum(319),[G0tensor(687)])
  call ol_merge_tensors(T0sum(320),[G0tensor(691)])
  call ol_merge_tensors(T0sum(321),[G0tensor(695)])
  call ol_merge_tensors(T0sum(322),[G0tensor(700)])
  call ol_merge_tensors(T0sum(323),[G0tensor(704)])
  call ol_merge_tensors(T0sum(324),[G0tensor(709)])
  call ol_merge_tensors(T0sum(325),[G0tensor(714)])
  call ol_merge_tensors(T0sum(326),[G0tensor(719)])
  call ol_merge_tensors(T0sum(327),[G0tensor(725)])
  call ol_merge_tensors(T0sum(328),[G0tensor(730)])
  call ol_merge_tensors(T0sum(329),[G0tensor(736)])
  call ol_merge_tensors(T0sum(330),[G0tensor(741)])
  call ol_merge_tensors(T0sum(331),[G0tensor(746)])
  call ol_merge_tensors(T0sum(332),[G0tensor(751)])
  call ol_merge_tensors(T0sum(333),[G0tensor(757)])
  call ol_merge_tensors(T0sum(334),[G0tensor(762)])
  call ol_merge_tensors(T0sum(335),[G0tensor(768)])
  call ol_merge_tensors(T0sum(336),[G0tensor(773)])
  call ol_merge_tensors(T0sum(337),[G0tensor(778)])
  call ol_merge_tensors(T0sum(338),[G0tensor(783)])
  call ol_merge_tensors(T0sum(339),[G0tensor(788)])
  call ol_merge_tensors(T0sum(340),[G0tensor(793)])
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1047),h0tab(:,1047),[16,15],[0,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(47),m3h3x12(:,606),heltab2x36(:,:,996))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1048),h0tab(:,1048),[16,15],[nMZ,nMW],3,2,wf4(:,1),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(48),m3h3x12(:,607),heltab2x36(:,:,997))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1049),h0tab(:,1049),[16,15],[nMW,nMH],3,2,wf4(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(29),m3h3x12(:,608),heltab2x36(:,:,998))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1050),h0tab(:,1050),[16,15],[nMW,nMZ],3,2,wf4(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(4),m3h3x12(:,609),heltab2x36(:,:,999))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1051),h0tab(:,1051),[16,15],[nMW,0],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(120),m3h3x12(:,610),heltab2x36(:,:,1000))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1052),h0tab(:,1052),[16,15],[nMW,nMZ],3,2,wf4(:,1),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(6),m3h3x12(:,611),heltab2x36(:,:,1001))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1053),h0tab(:,1053),[28,3],[nMW,0],3,2,wf3(:,7),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf3(:,7),G0H4(74),m4h3x3x4(:,26),heltab3x36(:,:,52))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1054),h0tab(:,1054),[28,3],[nMW,nMZ],3,2,wf3(:,7),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf3(:,7),G0H4(28),m4h3x3x4(:,27),heltab3x36(:,:,53))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1055),h0tab(:,1055),[28,3],[nMH,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf3(:,1),G0H4(17),m4h3x3x4(:,28),heltab3x36(:,:,54))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1056),h0tab(:,1056),[28,3],[nMZ,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf3(:,1),G0H4(7),m4h3x3x4(:,29),heltab3x36(:,:,55))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1057),h0tab(:,1057),[28,3],[0,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),wf3(:,1),G0H4(29),m4h3x3x4(:,30),heltab3x36(:,:,56))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1058),h0tab(:,1058),[28,3],[nMZ,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),wf3(:,1),G0H4(1),m4h3x3x4(:,31),heltab3x36(:,:,57))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1059),h0tab(:,1059),[19,12],[nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(25),m4h3x4x3(:,7),heltab3x36(:,:,58))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1060),h0tab(:,1060),[19,12],[nMW,nMW],3,2,wf4(:,1),wf3(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,1),ex5(:),G0H3(24),m4h4x3x3(:,3),heltab3x36(:,:,59))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1061),h0tab(:,1061),[23,8],[nMH,nMZ],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf3(:,2),G0H3(22),m4h4x3x3(:,4),heltab3x36(:,:,60))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1062),h0tab(:,1062),[23,8],[nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf3(:,2),G0H3(21),m4h4x3x3(:,5),heltab3x36(:,:,61))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1063),h0tab(:,1063),[23,8],[nMW,nMW],3,2,wf4(:,1),wf3(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),wf4(:,1),wf3(:,3),G0H3(67),m4h4x3x3(:,6),heltab3x36(:,:,62))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1064),h0tab(:,1064),[23,8],[nMW,nMW],3,2,wf4(:,1),wf3(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,1),wf3(:,3),G0H3(64),m4h4x3x3(:,7),heltab3x36(:,:,63))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1065),h0tab(:,1065),[27,4],[nMZ,nMZ],3,2,wf4(:,1),wf9(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf9(:,1),G0H1(2),m4h4x9x1(:,1),heltab3x36(:,:,64))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1066),h0tab(:,1066),[27,4],[nMW,nMW],3,2,wf4(:,1),wf9(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf9(:,1),G0H1(1),m4h4x9x1(:,2),heltab3x36(:,:,65))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1067),h0tab(:,1067),[27,4],[nMH,nMH],3,2,wf4(:,1),wf9(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),wf4(:,1),wf9(:,2),G0H1(3),m4h4x9x1(:,3),heltab3x36(:,:,66))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1068),h0tab(:,1068),[27,4],[nMZ,nMZ],3,2,wf4(:,1),wf9(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),wf4(:,1),wf9(:,2),G0H1(4),m4h4x9x1(:,4),heltab3x36(:,:,67))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1069),h0tab(:,1069),[27,4],[nMW,nMW],3,2,wf4(:,1),wf9(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),wf4(:,1),wf9(:,2),G0H1(5),m4h4x9x1(:,5),heltab3x36(:,:,68))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1070),h0tab(:,1070),[27,4],[nMZ,nMZ],3,2,wf4(:,1),wf9(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),wf4(:,1),wf9(:,2),G0H1(6),m4h4x9x1(:,6),heltab3x36(:,:,69))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1071),h0tab(:,1071),[27,4],[nMW,nMW],3,2,wf4(:,1),wf9(:,2))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,1),wf9(:,2),G0H1(7),m4h4x9x1(:,7),heltab3x36(:,:,70))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1072),h0tab(:,1072),[23,8],[nMH,nMZ],3,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(48),m4h3x4x3(:,8),heltab3x36(:,:,71))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1073),h0tab(:,1073),[23,8],[nMW,nMW],3,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(45),m4h3x4x3(:,9),heltab3x36(:,:,72))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1074),h0tab(:,1074),[23,8],[nMW,nMW],3,1,wf4(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,3),G0H3(29),m4h3x4x3(:,10),heltab3x36(:,:,73))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1075),h0tab(:,1075),[23,8],[nMW,nMW],3,1,wf4(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,3),ex5(:),G0H3(26),m4h4x3x3(:,8),heltab3x36(:,:,74))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1076),h0tab(:,1076),[27,4],[nMZ,nMZ],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf12(:,2),G0H1(8),m4h3x12x1(:,1),heltab3x36(:,:,75))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1077),h0tab(:,1077),[27,4],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf12(:,2),G0H1(9),m4h3x12x1(:,2),heltab3x36(:,:,76))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1078),h0tab(:,1078),[27,4],[nMH,nMH],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,3),G0H1(10),m4h3x12x1(:,3),heltab3x36(:,:,77))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1079),h0tab(:,1079),[27,4],[nMZ,nMZ],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,3),G0H1(11),m4h3x12x1(:,4),heltab3x36(:,:,78))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1080),h0tab(:,1080),[27,4],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,3),G0H1(12),m4h3x12x1(:,5),heltab3x36(:,:,79))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1081),h0tab(:,1081),[27,4],[nMZ,nMZ],3,1,wf12(:,3))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,3),G0H1(13),m4h3x12x1(:,6),heltab3x36(:,:,80))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1082),h0tab(:,1082),[27,4],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),wf12(:,3),ex5(:),G0H1(14),m4h12x3x1(:,1),heltab3x36(:,:,81))
  Gcoeff(:)%j = (c(162)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1083),h0tab(:,1083),[28,3],[nMW,0],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,2),G0H4(8),m4h3x3x4(:,32),heltab3x36(:,:,82))
  Gcoeff(:)%j = (c(170)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1084),h0tab(:,1084),[28,3],[nMW,nMZ],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,2),G0H4(35),m4h3x3x4(:,33),heltab3x36(:,:,83))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1085),h0tab(:,1085),[28,3],[nMH,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,2),G0H4(2),m4h3x3x4(:,34),heltab3x36(:,:,84))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1086),h0tab(:,1086),[28,3],[nMH,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf3(:,3),G0H4(36),m4h3x3x4(:,35),heltab3x36(:,:,85))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1087),h0tab(:,1087),[28,3],[nMZ,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf3(:,3),G0H4(9),m4h3x3x4(:,36),heltab3x36(:,:,86))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1088),h0tab(:,1088),[28,3],[0,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf3(:,3),ex4(:),G0H4(37),m4h3x3x4(:,37),heltab3x36(:,:,87))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1089),h0tab(:,1089),[28,3],[nMZ,nMW],3,2,wf3(:,3),wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf3(:,3),ex4(:),G0H4(3),m4h3x3x4(:,38),heltab3x36(:,:,88))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1090),h0tab(:,1090),[20,11],[nMW,nMH],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(49),m3h3x12(:,612),heltab2x36(:,:,1002))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1091),h0tab(:,1091),[20,11],[nMW,0],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(50),m3h3x12(:,613),heltab2x36(:,:,1003))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1092),h0tab(:,1092),[20,11],[nMW,nMZ],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(51),m3h3x12(:,614),heltab2x36(:,:,1004))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1093),h0tab(:,1093),[20,11],[nMW,nMH],3,2,wf3(:,3),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(3),m3h3x12(:,615),heltab2x36(:,:,1005))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1094),h0tab(:,1094),[20,11],[nMW,nMZ],3,2,wf3(:,3),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(10),m3h3x12(:,616),heltab2x36(:,:,1006))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1095),h0tab(:,1095),[20,11],[nMW,0],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(12),m3h3x12(:,617),heltab2x36(:,:,1007))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1096),h0tab(:,1096),[20,11],[nMW,nMZ],3,2,wf3(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(9),m3h3x12(:,618),heltab2x36(:,:,1008))
  Gcoeff(:)%j = (-(c(162)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1097),h0tab(:,1097),[16,15],[0,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(52),m3h3x12(:,619),heltab2x36(:,:,1009))
  Gcoeff(:)%j = (-(c(170)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1098),h0tab(:,1098),[16,15],[nMZ,nMW],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,620),heltab2x36(:,:,1010))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1099),h0tab(:,1099),[16,15],[nMW,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(54),m3h3x12(:,621),heltab2x36(:,:,1011))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1100),h0tab(:,1100),[16,15],[nMW,nMH],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(108),m3h3x12(:,622),heltab2x36(:,:,1012))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1101),h0tab(:,1101),[16,15],[nMW,nMZ],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(1),m3h3x12(:,623),heltab2x36(:,:,1013))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1102),h0tab(:,1102),[16,15],[nMW,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(7),m3h3x12(:,624),heltab2x36(:,:,1014))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1103),h0tab(:,1103),[16,15],[nMW,nMZ],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(23),m3h3x12(:,625),heltab2x36(:,:,1015))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1104),h0tab(:,1104),[27,4],[nMW,nMW],3,1,wf12(:,34))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf12(:,34),G0H1(15),m4h3x12x1(:,7),heltab3x36(:,:,89))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1105),h0tab(:,1105),[27,4],[nMW,nMW],3,1,wf12(:,34))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf12(:,34),G0H1(16),m4h3x12x1(:,8),heltab3x36(:,:,90))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1106),h0tab(:,1106),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,1),G0H1(17),m4h3x12x1(:,9),heltab3x36(:,:,91))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1107),h0tab(:,1107),[27,4],[nMH,nMH],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,1),G0H1(18),m4h3x12x1(:,10),heltab3x36(:,:,92))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1108),h0tab(:,1108),[27,4],[nMZ,nMZ],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,1),G0H1(19),m4h3x12x1(:,11),heltab3x36(:,:,93))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1109),h0tab(:,1109),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,1),G0H1(20),m4h3x12x1(:,12),heltab3x36(:,:,94))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1110),h0tab(:,1110),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,1),G0H1(21),m4h3x12x1(:,13),heltab3x36(:,:,95))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1111),h0tab(:,1111),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,1),G0H1(22),m4h3x12x1(:,14),heltab3x36(:,:,96))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1112),h0tab(:,1112),[24,7],[nMH,nMW],3,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(12),m4h3x3x4(:,39),heltab3x36(:,:,97))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1113),h0tab(:,1113),[24,7],[0,nMW],3,1,wf4(:,2))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(38),m4h3x3x4(:,40),heltab3x36(:,:,98))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1114),h0tab(:,1114),[24,7],[nMZ,nMW],3,1,wf4(:,2))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(4),m4h3x3x4(:,41),heltab3x36(:,:,99))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1115),h0tab(:,1115),[24,7],[nMH,nMW],3,1,wf4(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(39),m4h3x3x4(:,42),heltab3x36(:,:,100))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1116),h0tab(:,1116),[24,7],[nMZ,nMW],3,1,wf4(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(13),m4h3x3x4(:,43),heltab3x36(:,:,101))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1117),h0tab(:,1117),[24,7],[0,nMW],3,1,wf4(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(40),m4h3x3x4(:,44),heltab3x36(:,:,102))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1118),h0tab(:,1118),[24,7],[nMZ,nMW],3,1,wf4(:,3))
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(5),m4h3x3x4(:,45),heltab3x36(:,:,103))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1119),h0tab(:,1119),[28,3],[nMH,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SSS_S(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(70),m4h1x9x4(:,5),heltab3x36(:,:,104))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1120),h0tab(:,1120),[28,3],[0,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(66),m4h1x9x4(:,6),heltab3x36(:,:,105))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1121),h0tab(:,1121),[28,3],[nMZ,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(62),m4h1x9x4(:,7),heltab3x36(:,:,106))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1122),h0tab(:,1122),[28,3],[nMW,0],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf9(:,2),ex3(:),G0H4(58),m4h9x1x4(:,1),heltab3x36(:,:,107))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1123),h0tab(:,1123),[28,3],[nMW,nMZ],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf9(:,2),ex3(:),G0H4(54),m4h9x1x4(:,2),heltab3x36(:,:,108))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1124),h0tab(:,1124),[28,3],[nMH,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf9(:,2),ex3(:),G0H4(50),m4h9x1x4(:,3),heltab3x36(:,:,109))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1125),h0tab(:,1125),[24,7],[0,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(63),m3h9x4(:,143),heltab2x36(:,:,1016))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1126),h0tab(:,1126),[24,7],[nMZ,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(56),m3h9x4(:,144),heltab2x36(:,:,1017))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1127),h0tab(:,1127),[24,7],[nMW,nMH],3,2,wf9(:,1),wf4(:,1))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(49),m3h9x4(:,145),heltab2x36(:,:,1018))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1128),h0tab(:,1128),[24,7],[0,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(24),m3h9x4(:,146),heltab2x36(:,:,1019))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1129),h0tab(:,1129),[24,7],[nMZ,nMW],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(20),m3h9x4(:,147),heltab2x36(:,:,1020))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1130),h0tab(:,1130),[24,7],[nMW,nMH],3,2,wf9(:,2),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(15),m3h9x4(:,148),heltab2x36(:,:,1021))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1131),h0tab(:,1131),[16,15],[nMW,nMH],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(98),m3h3x12(:,626),heltab2x36(:,:,1022))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1132),h0tab(:,1132),[16,15],[nMW,0],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(116),m3h3x12(:,627),heltab2x36(:,:,1023))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1133),h0tab(:,1133),[16,15],[nMW,nMZ],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(117),m3h3x12(:,628),heltab2x36(:,:,1024))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1134),h0tab(:,1134),[16,15],[0,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(55),m3h3x12(:,629),heltab2x36(:,:,1025))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1135),h0tab(:,1135),[16,15],[nMZ,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(88),m3h3x12(:,630),heltab2x36(:,:,1026))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1136),h0tab(:,1136),[16,15],[nMW,nMH],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(89),m3h3x12(:,631),heltab2x36(:,:,1027))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1137),h0tab(:,1137),[23,8],[nMW,nMW],3,1,wf12(:,34))
  call Hloop_SSS_S(ntryL,G0H36(1),ex3(:),wf12(:,34),G0H3(68),m4h1x12x3(:,1),heltab3x36(:,:,110))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1138),h0tab(:,1138),[23,8],[nMW,nMW],3,1,wf12(:,34))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf12(:,34),G0H3(65),m4h1x12x3(:,2),heltab3x36(:,:,111))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1139),h0tab(:,1139),[23,8],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,1),ex3(:),G0H3(49),m4h12x1x3(:,1),heltab3x36(:,:,112))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1140),h0tab(:,1140),[23,8],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,1),ex3(:),G0H3(46),m4h12x1x3(:,2),heltab3x36(:,:,113))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1141),h0tab(:,1141),[23,8],[nMH,nMZ],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,1),ex3(:),G0H3(30),m4h12x1x3(:,3),heltab3x36(:,:,114))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1142),h0tab(:,1142),[23,8],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,1),ex3(:),G0H3(27),m4h12x1x3(:,4),heltab3x36(:,:,115))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1143),h0tab(:,1143),[23,8],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,1),ex3(:),G0H3(71),m4h12x1x3(:,5),heltab3x36(:,:,116))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1144),h0tab(:,1144),[20,11],[nMW,0],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(90),m4h3x1x12(:,4),heltab3x36(:,:,117))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1145),h0tab(:,1145),[20,11],[nMW,nMZ],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(91),m4h3x1x12(:,5),heltab3x36(:,:,118))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1146),h0tab(:,1146),[20,11],[nMH,nMW],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(101),m4h3x1x12(:,6),heltab3x36(:,:,119))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1147),h0tab(:,1147),[20,11],[nMW,0],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(102),m4h3x1x12(:,7),heltab3x36(:,:,120))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1148),h0tab(:,1148),[20,11],[nMW,nMZ],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(103),m4h3x1x12(:,8),heltab3x36(:,:,121))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1149),h0tab(:,1149),[20,11],[nMH,nMW],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(104),m4h3x1x12(:,9),heltab3x36(:,:,122))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1150),h0tab(:,1150),[19,12],[nMW,nMW],3,1,wf12(:,34))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(159),m3h12x3(:,201),heltab2x36(:,:,1028))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1151),h0tab(:,1151),[19,12],[nMW,nMW],3,1,wf12(:,34))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(210),m3h12x3(:,202),heltab2x36(:,:,1029))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1152),h0tab(:,1152),[19,12],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(69),m3h12x3(:,203),heltab2x36(:,:,1030))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1153),h0tab(:,1153),[19,12],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(52),m3h12x3(:,204),heltab2x36(:,:,1031))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1154),h0tab(:,1154),[19,12],[nMZ,nMH],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(50),m3h12x3(:,205),heltab2x36(:,:,1032))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1155),h0tab(:,1155),[19,12],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(33),m3h12x3(:,206),heltab2x36(:,:,1033))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1156),h0tab(:,1156),[19,12],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,1),G0H3(31),m3h12x3(:,207),heltab2x36(:,:,1034))
  Gcoeff(:)%j = (c(237)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1157),h0tab(:,1157),[28,3],[0,nML],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(14),ngPnl,m3h9x4(:,149),heltab2x36(:,:,1035))
  call Hloop_Q_A(ntryL,G0H4(14),28,0,G1H4(42),n2h4(23))
  Gcoeff(:)%j = (-(c(234)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1158),h0tab(:,1158),[28,3],[nMT,nMB],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(71),ngPtb,m3h9x4(:,150),heltab2x36(:,:,1036))
  call Hloop_Q_A(ntryL,G0H4(71),28,nMT,G1H4(64),n2h4(24))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1159),h0tab(:,1159),[28,3],[nMH,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(67),m3h9x4(:,151),heltab2x36(:,:,1037))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1160),h0tab(:,1160),[28,3],[nMZ,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(63),m3h9x4(:,152),heltab2x36(:,:,1038))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1161),h0tab(:,1161),[28,3],[0,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(59),m3h9x4(:,153),heltab2x36(:,:,1039))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1162),h0tab(:,1162),[28,3],[nMZ,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(55),m3h9x4(:,154),heltab2x36(:,:,1040))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1163),h0tab(:,1163),[28,3],[0,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(51),m3h9x4(:,155),heltab2x36(:,:,1041))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1164),h0tab(:,1164),[28,3],[nMZ,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(25),m3h9x4(:,156),heltab2x36(:,:,1042))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1165),h0tab(:,1165),[28,3],[nMW,0],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(57),m3h9x4(:,157),heltab2x36(:,:,1043))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1166),h0tab(:,1166),[28,3],[nMW,nMZ],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(50),m3h9x4(:,158),heltab2x36(:,:,1044))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1167),h0tab(:,1167),[28,3],[nMH,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(43),m3h9x4(:,159),heltab2x36(:,:,1045))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1168),h0tab(:,1168),[27,4],[nMH,nMH],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,4),G0H1(23),m4h3x12x1(:,15),heltab3x36(:,:,123))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1169),h0tab(:,1169),[27,4],[nMZ,nMZ],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,4),G0H1(24),m4h3x12x1(:,16),heltab3x36(:,:,124))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1170),h0tab(:,1170),[27,4],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,4),G0H1(25),m4h3x12x1(:,17),heltab3x36(:,:,125))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1171),h0tab(:,1171),[27,4],[nMZ,nMZ],3,1,wf12(:,4))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,4),G0H1(26),m4h3x12x1(:,18),heltab3x36(:,:,126))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1172),h0tab(:,1172),[27,4],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_WWV_V(ntryL,G0H36(1),wf12(:,4),ex5(:),G0H1(27),m4h12x3x1(:,2),heltab3x36(:,:,127))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1173),h0tab(:,1173),[27,4],[nMH,nMH],3,1,wf12(:,5))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,5),G0H1(28),m4h3x12x1(:,19),heltab3x36(:,:,128))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1174),h0tab(:,1174),[27,4],[nMZ,nMZ],3,1,wf12(:,5))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,5),G0H1(29),m4h3x12x1(:,20),heltab3x36(:,:,129))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1175),h0tab(:,1175),[27,4],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,5),G0H1(30),m4h3x12x1(:,21),heltab3x36(:,:,130))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1176),h0tab(:,1176),[27,4],[nMZ,nMZ],3,1,wf12(:,5))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,5),G0H1(31),m4h3x12x1(:,22),heltab3x36(:,:,131))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1177),h0tab(:,1177),[27,4],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_WWV_V(ntryL,G0H36(1),wf12(:,5),ex5(:),G0H1(32),m4h12x3x1(:,3),heltab3x36(:,:,132))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1178),h0tab(:,1178),[27,4],[nMW,nMW],3,1,wf12(:,11))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,11),G0H1(33),m4h3x12x1(:,23),heltab3x36(:,:,133))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1179),h0tab(:,1179),[27,4],[nMH,nMH],3,1,wf12(:,6))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,6),G0H1(34),m4h3x12x1(:,24),heltab3x36(:,:,134))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1180),h0tab(:,1180),[27,4],[nMZ,nMZ],3,1,wf12(:,6))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,6),G0H1(35),m4h3x12x1(:,25),heltab3x36(:,:,135))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1181),h0tab(:,1181),[27,4],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,6),G0H1(36),m4h3x12x1(:,26),heltab3x36(:,:,136))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1182),h0tab(:,1182),[27,4],[nMW,nMW],3,1,wf12(:,11))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,11),G0H1(37),m4h3x12x1(:,27),heltab3x36(:,:,137))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1183),h0tab(:,1183),[27,4],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,6),G0H1(38),m4h3x12x1(:,28),heltab3x36(:,:,138))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1184),h0tab(:,1184),[27,4],[nMW,nMW],3,1,wf12(:,12))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,12),G0H1(39),m4h3x12x1(:,29),heltab3x36(:,:,139))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1185),h0tab(:,1185),[27,4],[nMH,nMH],3,1,wf12(:,7))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,7),G0H1(40),m4h3x12x1(:,30),heltab3x36(:,:,140))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1186),h0tab(:,1186),[27,4],[nMZ,nMZ],3,1,wf12(:,7))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,7),G0H1(41),m4h3x12x1(:,31),heltab3x36(:,:,141))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1187),h0tab(:,1187),[27,4],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,7),G0H1(42),m4h3x12x1(:,32),heltab3x36(:,:,142))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1188),h0tab(:,1188),[27,4],[nMW,nMW],3,1,wf12(:,12))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,12),G0H1(43),m4h3x12x1(:,33),heltab3x36(:,:,143))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1189),h0tab(:,1189),[27,4],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,7),G0H1(44),m4h3x12x1(:,34),heltab3x36(:,:,144))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1190),h0tab(:,1190),[16,15],[0,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(4),m3h3x12(:,632),heltab2x36(:,:,1046))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1191),h0tab(:,1191),[16,15],[nMZ,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(80),m3h3x12(:,633),heltab2x36(:,:,1047))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1192),h0tab(:,1192),[16,15],[nMW,nMH],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,634),heltab2x36(:,:,1048))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1193),h0tab(:,1193),[20,11],[nMW,0],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(73),m4h3x1x12(:,10),heltab3x36(:,:,145))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1194),h0tab(:,1194),[20,11],[nMW,nMZ],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(74),m4h3x1x12(:,11),heltab3x36(:,:,146))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1195),h0tab(:,1195),[20,11],[nMH,nMW],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(78),m4h3x1x12(:,12),heltab3x36(:,:,147))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1196),h0tab(:,1196),[16,15],[0,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(79),m3h3x12(:,635),heltab2x36(:,:,1049))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1197),h0tab(:,1197),[16,15],[nMZ,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,636),heltab2x36(:,:,1050))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1198),h0tab(:,1198),[16,15],[nMW,nMH],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,637),heltab2x36(:,:,1051))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1199),h0tab(:,1199),[20,11],[nMW,0],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(19),m4h3x1x12(:,13),heltab3x36(:,:,148))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1200),h0tab(:,1200),[20,11],[nMW,nMZ],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(20),m4h3x1x12(:,14),heltab3x36(:,:,149))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1201),h0tab(:,1201),[20,11],[nMH,nMW],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(21),m4h3x1x12(:,15),heltab3x36(:,:,150))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1202),h0tab(:,1202),[23,8],[nMW,nMW],3,1,wf12(:,11))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,11),ex3(:),G0H3(72),m4h12x1x3(:,6),heltab3x36(:,:,151))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1203),h0tab(:,1203),[23,8],[nMW,nMW],3,1,wf12(:,11))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,11),ex3(:),G0H3(70),m4h12x1x3(:,7),heltab3x36(:,:,152))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1204),h0tab(:,1204),[23,8],[nMH,nMZ],3,1,wf12(:,6))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,6),ex3(:),G0H3(53),m4h12x1x3(:,8),heltab3x36(:,:,153))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1205),h0tab(:,1205),[23,8],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,6),ex3(:),G0H3(51),m4h12x1x3(:,9),heltab3x36(:,:,154))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1206),h0tab(:,1206),[23,8],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,6),ex3(:),G0H3(34),m4h12x1x3(:,10),heltab3x36(:,:,155))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1207),h0tab(:,1207),[23,8],[nMW,nMW],3,1,wf12(:,12))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,12),ex3(:),G0H3(32),m4h12x1x3(:,11),heltab3x36(:,:,156))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1208),h0tab(:,1208),[23,8],[nMW,nMW],3,1,wf12(:,12))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,12),ex3(:),G0H3(77),m4h12x1x3(:,12),heltab3x36(:,:,157))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1209),h0tab(:,1209),[23,8],[nMH,nMZ],3,1,wf12(:,7))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,7),ex3(:),G0H3(76),m4h12x1x3(:,13),heltab3x36(:,:,158))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1210),h0tab(:,1210),[23,8],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,7),ex3(:),G0H3(74),m4h12x1x3(:,14),heltab3x36(:,:,159))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1211),h0tab(:,1211),[23,8],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,7),ex3(:),G0H3(73),m4h12x1x3(:,15),heltab3x36(:,:,160))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1212),h0tab(:,1212),[19,12],[nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(58),m3h12x3(:,208),heltab2x36(:,:,1052))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1213),h0tab(:,1213),[19,12],[nMW,nMW],3,1,wf12(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(57),m3h12x3(:,209),heltab2x36(:,:,1053))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1214),h0tab(:,1214),[19,12],[nMZ,nMH],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(55),m3h12x3(:,210),heltab2x36(:,:,1054))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1215),h0tab(:,1215),[19,12],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(54),m3h12x3(:,211),heltab2x36(:,:,1055))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1216),h0tab(:,1216),[19,12],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(39),m3h12x3(:,212),heltab2x36(:,:,1056))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1217),h0tab(:,1217),[19,12],[nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(38),m3h12x3(:,213),heltab2x36(:,:,1057))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1218),h0tab(:,1218),[19,12],[nMW,nMW],3,1,wf12(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(36),m3h12x3(:,214),heltab2x36(:,:,1058))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1219),h0tab(:,1219),[19,12],[nMZ,nMH],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(35),m3h12x3(:,215),heltab2x36(:,:,1059))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1220),h0tab(:,1220),[19,12],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(42),m3h12x3(:,216),heltab2x36(:,:,1060))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1221),h0tab(:,1221),[19,12],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(23),m3h12x3(:,217),heltab2x36(:,:,1061))
  Gcoeff(:)%j = (c(176)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1222),h0tab(:,1222),[19,12],[nML,nML],2,2,wf12(:,34),wf3(:,7))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(47),ngH,m3h12x3(:,218),heltab2x36(:,:,1062))
  call Hloop_Q_A(ntryL,G0H3(47),19,nML,G1H3(251),n2h3(165))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1223),h0tab(:,1223),[19,12],[nMT,nMT],2,2,wf12(:,34),wf3(:,7))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(28),ngH,m3h12x3(:,219),heltab2x36(:,:,1063))
  call Hloop_Q_A(ntryL,G0H3(28),19,nMT,G1H3(211),n2h3(166))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1224),h0tab(:,1224),[19,12],[nMB,nMB],2,2,wf12(:,34),wf3(:,7))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(56),ngH,m3h12x3(:,220),heltab2x36(:,:,1064))
  call Hloop_Q_A(ntryL,G0H3(56),19,nMB,G1H3(250),n2h3(167))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1225),h0tab(:,1225),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(37),m3h12x3(:,221),heltab2x36(:,:,1065))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1226),h0tab(:,1226),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(61),m3h12x3(:,222),heltab2x36(:,:,1066))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1227),h0tab(:,1227),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,7))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(216),m3h12x3(:,223),heltab2x36(:,:,1067))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1228),h0tab(:,1228),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,7))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(249),m3h12x3(:,224),heltab2x36(:,:,1068))
  Gcoeff(:)%j = (c(222)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1229),h0tab(:,1229),[19,12],[nML,nML],2,2,wf12(:,1),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(66),m3h12x3(:,225),heltab2x36(:,:,1069))
  call Hloop_Q_A(ntryL,G0H3(66),19,nML,G1H3(246),n2h3(168))
  Gcoeff(:)%j = (c(226)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1230),h0tab(:,1230),[19,12],[nMT,nMT],2,2,wf12(:,1),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(75),m3h12x3(:,226),heltab2x36(:,:,1070))
  call Hloop_Q_A(ntryL,G0H3(75),19,nMT,G1H3(248),n2h3(169))
  Gcoeff(:)%j = (c(217)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1231),h0tab(:,1231),[19,12],[nMB,nMB],2,2,wf12(:,1),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(13),m3h12x3(:,227),heltab2x36(:,:,1071))
  call Hloop_Q_A(ntryL,G0H3(13),19,nMB,G1H3(198),n2h3(170))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1232),h0tab(:,1232),[19,12],[nML,nML],2,2,wf12(:,1),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(8),ngZl,m3h12x3(:,228),heltab2x36(:,:,1072))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(197),n2h3(171))
  Gcoeff(:)%j = (c(198)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1233),h0tab(:,1233),[19,12],[nMT,nMT],2,2,wf12(:,1),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(14),ngZu,m3h12x3(:,229),heltab2x36(:,:,1073))
  call Hloop_Q_A(ntryL,G0H3(14),19,nMT,G1H3(187),n2h3(172))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1234),h0tab(:,1234),[19,12],[nMB,nMB],2,2,wf12(:,1),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(4),ngZd,m3h12x3(:,230),heltab2x36(:,:,1074))
  call Hloop_Q_A(ntryL,G0H3(4),19,nMB,G1H3(225),n2h3(173))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1235),h0tab(:,1235),[19,12],[nMH,nMZ],2,2,wf12(:,1),wf3(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(7),m3h12x3(:,231),heltab2x36(:,:,1075))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1236),h0tab(:,1236),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(241),m3h12x3(:,232),heltab2x36(:,:,1076))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1237),h0tab(:,1237),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(123),m3h12x3(:,233),heltab2x36(:,:,1077))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1238),h0tab(:,1238),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(51),m3h12x3(:,234),heltab2x36(:,:,1078))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1239),h0tab(:,1239),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(137),m3h12x3(:,235),heltab2x36(:,:,1079))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1240),h0tab(:,1240),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(63),m3h12x3(:,236),heltab2x36(:,:,1080))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1241),h0tab(:,1241),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(62),m3h12x3(:,237),heltab2x36(:,:,1081))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1242),h0tab(:,1242),[19,12],[nMH,nMZ],2,2,wf12(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(60),m3h12x3(:,238),heltab2x36(:,:,1082))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1243),h0tab(:,1243),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(59),m3h12x3(:,239),heltab2x36(:,:,1083))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1244),h0tab(:,1244),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(44),m3h12x3(:,240),heltab2x36(:,:,1084))
  Gcoeff(:)%j = (-(c(201)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1245),h0tab(:,1245),[19,12],[nML,nML],2,2,wf12(:,34),wf3(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(43),ngH,m3h12x3(:,241),heltab2x36(:,:,1085))
  call Hloop_Q_A(ntryL,G0H3(43),19,nML,G1H3(22),n2h3(174))
  Gcoeff(:)%j = (-(c(202)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1246),h0tab(:,1246),[19,12],[nMT,nMT],2,2,wf12(:,34),wf3(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(41),ngH,m3h12x3(:,242),heltab2x36(:,:,1086))
  call Hloop_Q_A(ntryL,G0H3(41),19,nMT,G1H3(247),n2h3(175))
  Gcoeff(:)%j = (-(c(200)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1247),h0tab(:,1247),[19,12],[nMB,nMB],2,2,wf12(:,34),wf3(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,34),G0H3(40),ngH,m3h12x3(:,243),heltab2x36(:,:,1087))
  call Hloop_Q_A(ntryL,G0H3(40),19,nMB,G1H3(245),n2h3(176))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1248),h0tab(:,1248),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(11),m3h12x3(:,244),heltab2x36(:,:,1088))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1249),h0tab(:,1249),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(7),m3h12x3(:,245),heltab2x36(:,:,1089))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1250),h0tab(:,1250),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,34),G0H3(9),m3h12x3(:,246),heltab2x36(:,:,1090))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1251),h0tab(:,1251),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,34),G0H3(10),m3h12x3(:,247),heltab2x36(:,:,1091))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1252),h0tab(:,1252),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(242),m3h12x3(:,248),heltab2x36(:,:,1092))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1253),h0tab(:,1253),[19,12],[nMW,nMW],2,2,wf12(:,34),wf3(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,34),19,G1H3(195),m3h12x3(:,249),heltab2x36(:,:,1093))
  Gcoeff(:)%j = (-(c(271)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1254),h0tab(:,1254),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(20),m3h12x3(:,250),heltab2x36(:,:,1094))
  call Hloop_Q_A(ntryL,G0H3(20),19,0,G1H3(184),n2h3(177))
  Gcoeff(:)%j = (-(c(267)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1255),h0tab(:,1255),[19,12],[nML,nML],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(15),m3h12x3(:,251),heltab2x36(:,:,1095))
  call Hloop_Q_A(ntryL,G0H3(15),19,nML,G1H3(182),n2h3(178))
  Gcoeff(:)%j = (c(270)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1256),h0tab(:,1256),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(19),m3h12x3(:,252),heltab2x36(:,:,1096))
  call Hloop_Q_A(ntryL,G0H3(19),19,0,G1H3(179),n2h3(179))
  Gcoeff(:)%j = (c(265)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1257),h0tab(:,1257),[19,12],[nMT,nMT],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(1),m3h12x3(:,253),heltab2x36(:,:,1097))
  call Hloop_Q_A(ntryL,G0H3(1),19,nMT,G1H3(56),n2h3(180))
  Gcoeff(:)%j = (-(c(265)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1258),h0tab(:,1258),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(5),m3h12x3(:,254),heltab2x36(:,:,1098))
  call Hloop_Q_A(ntryL,G0H3(5),19,0,G1H3(220),n2h3(181))
  Gcoeff(:)%j = (-(c(262)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1259),h0tab(:,1259),[19,12],[nMB,nMB],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,1),G0H3(12),m3h12x3(:,255),heltab2x36(:,:,1099))
  call Hloop_Q_A(ntryL,G0H3(12),19,nMB,G1H3(48),n2h3(182))
  Gcoeff(:)%j = (c(233)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1260),h0tab(:,1260),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(18),ngZn,m3h12x3(:,256),heltab2x36(:,:,1100))
  call Hloop_Q_A(ntryL,G0H3(18),19,0,G1H3(24),n2h3(183))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1261),h0tab(:,1261),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(3),ngZl,m3h12x3(:,257),heltab2x36(:,:,1101))
  call Hloop_Q_A(ntryL,G0H3(3),19,0,G1H3(62),n2h3(184))
  Gcoeff(:)%j = (c(229)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1262),h0tab(:,1262),[19,12],[nML,nML],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(6),ngZl,m3h12x3(:,258),heltab2x36(:,:,1102))
  call Hloop_Q_A(ntryL,G0H3(6),19,nML,G1H3(238),n2h3(185))
  Gcoeff(:)%j = (c(232)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1263),h0tab(:,1263),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(2),ngZu,m3h12x3(:,259),heltab2x36(:,:,1103))
  call Hloop_Q_A(ntryL,G0H3(2),19,0,G1H3(178),n2h3(186))
  Gcoeff(:)%j = (c(230)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1264),h0tab(:,1264),[19,12],[nMT,nMT],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(17),ngZu,m3h12x3(:,260),heltab2x36(:,:,1104))
  call Hloop_Q_A(ntryL,G0H3(17),19,nMT,G1H3(99),n2h3(187))
  Gcoeff(:)%j = (c(232)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1265),h0tab(:,1265),[19,12],[0,0],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(16),ngZd,m3h12x3(:,261),heltab2x36(:,:,1105))
  call Hloop_Q_A(ntryL,G0H3(16),19,0,G1H3(64),n2h3(188))
  Gcoeff(:)%j = (c(230)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1266),h0tab(:,1266),[19,12],[nMB,nMB],2,2,wf12(:,1),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,1),G0H3(47),ngZd,m3h12x3(:,262),heltab2x36(:,:,1106))
  call Hloop_Q_A(ntryL,G0H3(47),19,nMB,G1H3(1),n2h3(189))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1267),h0tab(:,1267),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(141),m3h12x3(:,263),heltab2x36(:,:,1107))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1268),h0tab(:,1268),[19,12],[nMH,nMZ],2,2,wf12(:,1),wf3(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(205),m3h12x3(:,264),heltab2x36(:,:,1108))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1269),h0tab(:,1269),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(18),m3h12x3(:,265),heltab2x36(:,:,1109))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1270),h0tab(:,1270),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(87),m3h12x3(:,266),heltab2x36(:,:,1110))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1271),h0tab(:,1271),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(111),m3h12x3(:,267),heltab2x36(:,:,1111))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1272),h0tab(:,1272),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(32),m3h12x3(:,268),heltab2x36(:,:,1112))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1273),h0tab(:,1273),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(142),m3h12x3(:,269),heltab2x36(:,:,1113))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1274),h0tab(:,1274),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(233),m3h12x3(:,270),heltab2x36(:,:,1114))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1275),h0tab(:,1275),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,1),19,G1H3(207),m3h12x3(:,271),heltab2x36(:,:,1115))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1276),h0tab(:,1276),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(28),m3h12x3(:,272),heltab2x36(:,:,1116))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1277),h0tab(:,1277),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(56),m3h12x3(:,273),heltab2x36(:,:,1117))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1278),h0tab(:,1278),[19,12],[nMH,nMZ],2,2,wf12(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(66),m3h12x3(:,274),heltab2x36(:,:,1118))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1279),h0tab(:,1279),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(75),m3h12x3(:,275),heltab2x36(:,:,1119))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1280),h0tab(:,1280),[19,12],[nMW,nMW],2,2,wf12(:,1),wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,1),G0H3(13),m3h12x3(:,276),heltab2x36(:,:,1120))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1281),h0tab(:,1281),[28,3],[0,nML],2,2,wf9(:,6),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(21),ngPnl,m3h9x4(:,160),heltab2x36(:,:,1121))
  call Hloop_Q_A(ntryL,G0H4(21),28,0,G1H4(65),n2h4(25))
  Gcoeff(:)%j = (c(178)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1282),h0tab(:,1282),[28,3],[nMT,nMB],2,2,wf9(:,6),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(16),ngPtb,m3h9x4(:,161),heltab2x36(:,:,1122))
  call Hloop_Q_A(ntryL,G0H4(16),28,nMT,G1H4(58),n2h4(26))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1283),h0tab(:,1283),[28,3],[nMH,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(6),m3h9x4(:,162),heltab2x36(:,:,1123))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1284),h0tab(:,1284),[28,3],[nMZ,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(72),m3h9x4(:,163),heltab2x36(:,:,1124))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1285),h0tab(:,1285),[28,3],[0,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(68),m3h9x4(:,164),heltab2x36(:,:,1125))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1286),h0tab(:,1286),[28,3],[nMZ,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(64),m3h9x4(:,165),heltab2x36(:,:,1126))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1287),h0tab(:,1287),[28,3],[0,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(60),m3h9x4(:,166),heltab2x36(:,:,1127))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1288),h0tab(:,1288),[28,3],[nMZ,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(56),m3h9x4(:,167),heltab2x36(:,:,1128))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1289),h0tab(:,1289),[28,3],[nMW,0],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(51),m3h9x4(:,168),heltab2x36(:,:,1129))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1290),h0tab(:,1290),[28,3],[nMW,nMZ],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(44),m3h9x4(:,169),heltab2x36(:,:,1130))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1291),h0tab(:,1291),[28,3],[nMH,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(66),m3h9x4(:,170),heltab2x36(:,:,1131))
  Gcoeff(:)%j = (c(246)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1292),h0tab(:,1292),[28,3],[0,nML],2,2,wf9(:,7),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(52),ngPnl,m3h9x4(:,171),heltab2x36(:,:,1132))
  call Hloop_Q_A(ntryL,G0H4(52),28,0,G1H4(59),n2h4(27))
  Gcoeff(:)%j = (-(c(241)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1293),h0tab(:,1293),[28,3],[nMT,nMB],2,2,wf9(:,7),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(26),ngPtb,m3h9x4(:,172),heltab2x36(:,:,1133))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMT,G1H4(52),n2h4(28))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1294),h0tab(:,1294),[28,3],[nMH,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(22),m3h9x4(:,173),heltab2x36(:,:,1134))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1295),h0tab(:,1295),[28,3],[nMZ,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(18),m3h9x4(:,174),heltab2x36(:,:,1135))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1296),h0tab(:,1296),[28,3],[0,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(10),m3h9x4(:,175),heltab2x36(:,:,1136))
  Gcoeff(:)%j = (c(166)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1297),h0tab(:,1297),[28,3],[nMZ,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(73),m3h9x4(:,176),heltab2x36(:,:,1137))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1298),h0tab(:,1298),[28,3],[0,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,177),heltab2x36(:,:,1138))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1299),h0tab(:,1299),[28,3],[nMZ,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(65),m3h9x4(:,178),heltab2x36(:,:,1139))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1300),h0tab(:,1300),[28,3],[nMW,0],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(45),m3h9x4(:,179),heltab2x36(:,:,1140))
  Gcoeff(:)%j = (-(c(173)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1301),h0tab(:,1301),[28,3],[nMW,nMZ],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(15),m3h9x4(:,180),heltab2x36(:,:,1141))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1302),h0tab(:,1302),[28,3],[nMH,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(16),m3h9x4(:,181),heltab2x36(:,:,1142))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1303),h0tab(:,1303),[28,3],[0,0],2,2,wf9(:,8),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(61),m3h9x4(:,182),heltab2x36(:,:,1143))
  call Hloop_Q_A(ntryL,G0H4(61),28,0,G1H4(5),n2h4(29))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1304),h0tab(:,1304),[28,3],[0,nML],2,2,wf9(:,8),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(57),m3h9x4(:,183),heltab2x36(:,:,1144))
  call Hloop_Q_A(ntryL,G0H4(57),28,0,G1H4(67),n2h4(30))
  Gcoeff(:)%j = (c(189)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1305),h0tab(:,1305),[28,3],[0,0],2,2,wf9(:,8),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(53),m3h9x4(:,184),heltab2x36(:,:,1145))
  call Hloop_Q_A(ntryL,G0H4(53),28,0,G1H4(62),n2h4(31))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1306),h0tab(:,1306),[28,3],[nMT,nMB],2,2,wf9(:,8),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,8),G0H4(27),m3h9x4(:,185),heltab2x36(:,:,1146))
  call Hloop_Q_A(ntryL,G0H4(27),28,nMT,G1H4(60),n2h4(32))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1307),h0tab(:,1307),[28,3],[nMH,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(55),m3h9x4(:,186),heltab2x36(:,:,1147))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1308),h0tab(:,1308),[28,3],[nMZ,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(53),m3h9x4(:,187),heltab2x36(:,:,1148))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1309),h0tab(:,1309),[28,3],[0,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(48),m3h9x4(:,188),heltab2x36(:,:,1149))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1310),h0tab(:,1310),[28,3],[nMZ,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(46),m3h9x4(:,189),heltab2x36(:,:,1150))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1311),h0tab(:,1311),[28,3],[0,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,8),G1H4(41),m3h9x4(:,190),heltab2x36(:,:,1151))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1312),h0tab(:,1312),[28,3],[nMZ,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,8),G1H4(39),m3h9x4(:,191),heltab2x36(:,:,1152))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1313),h0tab(:,1313),[28,3],[0,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(61),m3h9x4(:,192),heltab2x36(:,:,1153))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1314),h0tab(:,1314),[28,3],[nMZ,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,8),28,G1H4(54),m3h9x4(:,193),heltab2x36(:,:,1154))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1315),h0tab(:,1315),[28,3],[nMW,0],2,2,wf9(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,8),G0H4(23),m3h9x4(:,194),heltab2x36(:,:,1155))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1316),h0tab(:,1316),[28,3],[nMW,nMZ],2,2,wf9(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,8),G0H4(19),m3h9x4(:,195),heltab2x36(:,:,1156))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1317),h0tab(:,1317),[28,3],[nMH,nMW],2,2,wf9(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,8),G0H4(11),m3h9x4(:,196),heltab2x36(:,:,1157))
  Gcoeff(:)%j = (-(c(239)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1318),h0tab(:,1318),[20,11],[nML,0],2,2,wf3(:,2),wf12(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,2),G0H12(25),ngPnl,m3h3x12(:,638),heltab2x36(:,:,1158))
  call Hloop_A_Q(ntryL,G0H12(25),20,nML,G1H12(13),n2h12(111))
  Gcoeff(:)%j = (c(234)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1319),h0tab(:,1319),[20,11],[nMB,nMT],2,2,wf3(:,2),wf12(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,2),G0H12(26),ngPtb,m3h3x12(:,639),heltab2x36(:,:,1159))
  call Hloop_A_Q(ntryL,G0H12(26),20,nMB,G1H12(14),n2h12(112))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1320),h0tab(:,1320),[20,11],[nMW,nMH],2,2,wf3(:,2),wf12(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(27),m3h3x12(:,640),heltab2x36(:,:,1160))
  Gcoeff(:)%j = (-(c(164)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1321),h0tab(:,1321),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(28),m3h3x12(:,641),heltab2x36(:,:,1161))
  Gcoeff(:)%j = (-(c(164)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1322),h0tab(:,1322),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(29),m3h3x12(:,642),heltab2x36(:,:,1162))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1323),h0tab(:,1323),[20,11],[nMW,0],2,2,wf3(:,2),wf12(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(32),m3h3x12(:,643),heltab2x36(:,:,1163))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1324),h0tab(:,1324),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(33),m3h3x12(:,644),heltab2x36(:,:,1164))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1325),h0tab(:,1325),[20,11],[0,nMW],2,2,wf3(:,2),wf12(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(16),m3h3x12(:,645),heltab2x36(:,:,1165))
  Gcoeff(:)%j = (-(c(169)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1326),h0tab(:,1326),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(18),m3h3x12(:,646),heltab2x36(:,:,1166))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1327),h0tab(:,1327),[20,11],[nMW,nMH],2,2,wf3(:,2),wf12(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(19),m3h3x12(:,647),heltab2x36(:,:,1167))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1328),h0tab(:,1328),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,2))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(20),m3h3x12(:,648),heltab2x36(:,:,1168))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1329),h0tab(:,1329),[20,11],[nML,0],2,2,wf3(:,2),wf12(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,2),G0H12(34),ngPnl,m3h3x12(:,649),heltab2x36(:,:,1169))
  call Hloop_A_Q(ntryL,G0H12(34),20,nML,G1H12(22),n2h12(113))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1330),h0tab(:,1330),[20,11],[nMB,nMT],2,2,wf3(:,2),wf12(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,2),G0H12(35),ngPtb,m3h3x12(:,650),heltab2x36(:,:,1170))
  call Hloop_A_Q(ntryL,G0H12(35),20,nMB,G1H12(24),n2h12(114))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1331),h0tab(:,1331),[20,11],[nMW,nMH],2,2,wf3(:,2),wf12(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(36),m3h3x12(:,651),heltab2x36(:,:,1171))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1332),h0tab(:,1332),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(37),m3h3x12(:,652),heltab2x36(:,:,1172))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1333),h0tab(:,1333),[20,11],[nMW,0],2,2,wf3(:,2),wf12(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(38),m3h3x12(:,653),heltab2x36(:,:,1173))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1334),h0tab(:,1334),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(39),m3h3x12(:,654),heltab2x36(:,:,1174))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1335),h0tab(:,1335),[20,11],[nMW,0],2,2,wf3(:,2),wf12(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(76),m3h3x12(:,655),heltab2x36(:,:,1175))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1336),h0tab(:,1336),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(8),m3h3x12(:,656),heltab2x36(:,:,1176))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1337),h0tab(:,1337),[20,11],[0,nMW],2,2,wf3(:,2),wf12(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(25),m3h3x12(:,657),heltab2x36(:,:,1177))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1338),h0tab(:,1338),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(26),m3h3x12(:,658),heltab2x36(:,:,1178))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1339),h0tab(:,1339),[20,11],[nMW,nMH],2,2,wf3(:,2),wf12(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(32),m3h3x12(:,659),heltab2x36(:,:,1179))
  Gcoeff(:)%j = (c(247)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1340),h0tab(:,1340),[20,11],[nML,0],2,2,wf3(:,3),wf12(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(82),m3h3x12(:,660),heltab2x36(:,:,1180))
  call Hloop_A_Q(ntryL,G0H12(82),20,nML,G1H12(33),n2h12(115))
  Gcoeff(:)%j = (c(245)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1341),h0tab(:,1341),[20,11],[nMB,nMT],2,2,wf3(:,3),wf12(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(77),m3h3x12(:,661),heltab2x36(:,:,1181))
  call Hloop_A_Q(ntryL,G0H12(77),20,nMB,G1H12(34),n2h12(116))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1342),h0tab(:,1342),[20,11],[nMW,nMH],2,2,wf3(:,3),wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(35),m3h3x12(:,662),heltab2x36(:,:,1182))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1343),h0tab(:,1343),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(37),m3h3x12(:,663),heltab2x36(:,:,1183))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1344),h0tab(:,1344),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(38),m3h3x12(:,664),heltab2x36(:,:,1184))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1345),h0tab(:,1345),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(39),m3h3x12(:,665),heltab2x36(:,:,1185))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1346),h0tab(:,1346),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(40),m3h3x12(:,666),heltab2x36(:,:,1186))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1347),h0tab(:,1347),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(42),m3h3x12(:,667),heltab2x36(:,:,1187))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1348),h0tab(:,1348),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(6),m3h3x12(:,668),heltab2x36(:,:,1188))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1349),h0tab(:,1349),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(75),m3h3x12(:,669),heltab2x36(:,:,1189))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1350),h0tab(:,1350),[20,11],[nMW,nMH],2,2,wf3(:,3),wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(22),m3h3x12(:,670),heltab2x36(:,:,1190))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1351),h0tab(:,1351),[20,11],[0,0],2,2,wf3(:,3),wf12(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(23),m3h3x12(:,671),heltab2x36(:,:,1191))
  call Hloop_A_Q(ntryL,G0H12(23),20,0,G1H12(43),n2h12(117))
  Gcoeff(:)%j = (c(190)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1352),h0tab(:,1352),[20,11],[nML,0],2,2,wf3(:,3),wf12(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(24),m3h3x12(:,672),heltab2x36(:,:,1192))
  call Hloop_A_Q(ntryL,G0H12(24),20,nML,G1H12(44),n2h12(118))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1353),h0tab(:,1353),[20,11],[0,0],2,2,wf3(:,3),wf12(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(40),m3h3x12(:,673),heltab2x36(:,:,1193))
  call Hloop_A_Q(ntryL,G0H12(40),20,0,G1H12(45),n2h12(119))
  Gcoeff(:)%j = (c(191)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1354),h0tab(:,1354),[20,11],[nMB,nMT],2,2,wf3(:,3),wf12(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,3),G0H12(41),m3h3x12(:,674),heltab2x36(:,:,1194))
  call Hloop_A_Q(ntryL,G0H12(41),20,nMB,G1H12(47),n2h12(120))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1355),h0tab(:,1355),[20,11],[nMW,nMH],2,2,wf3(:,3),wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(48),m3h3x12(:,675),heltab2x36(:,:,1195))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1356),h0tab(:,1356),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(49),m3h3x12(:,676),heltab2x36(:,:,1196))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1357),h0tab(:,1357),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(50),m3h3x12(:,677),heltab2x36(:,:,1197))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1358),h0tab(:,1358),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(52),m3h3x12(:,678),heltab2x36(:,:,1198))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1359),h0tab(:,1359),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(53),m3h3x12(:,679),heltab2x36(:,:,1199))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1360),h0tab(:,1360),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(127),m3h3x12(:,680),heltab2x36(:,:,1200))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1361),h0tab(:,1361),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(128),m3h3x12(:,681),heltab2x36(:,:,1201))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1362),h0tab(:,1362),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(129),m3h3x12(:,682),heltab2x36(:,:,1202))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1363),h0tab(:,1363),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(42),m3h3x12(:,683),heltab2x36(:,:,1203))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1364),h0tab(:,1364),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(43),m3h3x12(:,684),heltab2x36(:,:,1204))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1365),h0tab(:,1365),[20,11],[nMW,nMH],2,2,wf3(:,3),wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,3),G0H12(56),m3h3x12(:,685),heltab2x36(:,:,1205))
  Gcoeff(:)%j = (c(275)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1366),h0tab(:,1366),[28,3],[0,nML],2,2,wf9(:,9),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,9),G0H4(30),ngPnl,m3h9x4(:,197),heltab2x36(:,:,1206))
  call Hloop_Q_A(ntryL,G0H4(30),28,0,G1H4(47),n2h4(33))
  Gcoeff(:)%j = (-(c(274)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1367),h0tab(:,1367),[28,3],[nMT,nMB],2,2,wf9(:,9),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,9),G0H4(31),ngPtb,m3h9x4(:,198),heltab2x36(:,:,1207))
  call Hloop_Q_A(ntryL,G0H4(31),28,nMT,G1H4(40),n2h4(34))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1368),h0tab(:,1368),[28,3],[nMH,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,9),G0H4(32),m3h9x4(:,199),heltab2x36(:,:,1208))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1369),h0tab(:,1369),[28,3],[nMZ,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,9),G0H4(33),m3h9x4(:,200),heltab2x36(:,:,1209))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1370),h0tab(:,1370),[28,3],[0,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,9),G0H4(34),m3h9x4(:,201),heltab2x36(:,:,1210))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1371),h0tab(:,1371),[28,3],[nMZ,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,9),G0H4(41),m3h9x4(:,202),heltab2x36(:,:,1211))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1372),h0tab(:,1372),[28,3],[0,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,9),G0H4(42),m3h9x4(:,203),heltab2x36(:,:,1212))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1373),h0tab(:,1373),[28,3],[nMZ,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,9),G0H4(43),m3h9x4(:,204),heltab2x36(:,:,1213))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1374),h0tab(:,1374),[28,3],[nMW,0],2,2,wf9(:,9),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,9),28,G1H4(22),m3h9x4(:,205),heltab2x36(:,:,1214))
  Gcoeff(:)%j = (-(c(169)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1375),h0tab(:,1375),[28,3],[nMW,nMZ],2,2,wf9(:,9),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,9),28,G1H4(23),m3h9x4(:,206),heltab2x36(:,:,1215))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1376),h0tab(:,1376),[28,3],[nMH,nMW],2,2,wf9(:,9),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,9),28,G1H4(24),m3h9x4(:,207),heltab2x36(:,:,1216))
  Gcoeff(:)%j = (c(244)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1377),h0tab(:,1377),[28,3],[0,0],2,2,wf9(:,11),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(44),m3h9x4(:,208),heltab2x36(:,:,1217))
  call Hloop_Q_A(ntryL,G0H4(44),28,0,G1H4(25),n2h4(35))
  Gcoeff(:)%j = (c(242)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1378),h0tab(:,1378),[28,3],[0,nML],2,2,wf9(:,11),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(45),m3h9x4(:,209),heltab2x36(:,:,1218))
  call Hloop_Q_A(ntryL,G0H4(45),28,0,G1H4(32),n2h4(36))
  Gcoeff(:)%j = (c(245)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1379),h0tab(:,1379),[28,3],[0,0],2,2,wf9(:,11),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(46),m3h9x4(:,210),heltab2x36(:,:,1219))
  call Hloop_Q_A(ntryL,G0H4(46),28,0,G1H4(33),n2h4(37))
  Gcoeff(:)%j = (c(243)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1380),h0tab(:,1380),[28,3],[nMT,nMB],2,2,wf9(:,11),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,11),G0H4(47),m3h9x4(:,211),heltab2x36(:,:,1220))
  call Hloop_Q_A(ntryL,G0H4(47),28,nMT,G1H4(34),n2h4(38))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1381),h0tab(:,1381),[28,3],[nMH,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(35),m3h9x4(:,212),heltab2x36(:,:,1221))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1382),h0tab(:,1382),[28,3],[nMZ,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(36),m3h9x4(:,213),heltab2x36(:,:,1222))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1383),h0tab(:,1383),[28,3],[0,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(37),m3h9x4(:,214),heltab2x36(:,:,1223))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1384),h0tab(:,1384),[28,3],[nMZ,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(38),m3h9x4(:,215),heltab2x36(:,:,1224))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1385),h0tab(:,1385),[28,3],[0,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,11),G1H4(70),m3h9x4(:,216),heltab2x36(:,:,1225))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1386),h0tab(:,1386),[28,3],[nMZ,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,11),G1H4(71),m3h9x4(:,217),heltab2x36(:,:,1226))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1387),h0tab(:,1387),[28,3],[0,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(72),m3h9x4(:,218),heltab2x36(:,:,1227))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1388),h0tab(:,1388),[28,3],[nMZ,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,11),28,G1H4(73),m3h9x4(:,219),heltab2x36(:,:,1228))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1389),h0tab(:,1389),[28,3],[nMW,0],2,2,wf9(:,11),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,11),G0H4(48),m3h9x4(:,220),heltab2x36(:,:,1229))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1390),h0tab(:,1390),[28,3],[nMW,nMZ],2,2,wf9(:,11),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,11),G0H4(49),m3h9x4(:,221),heltab2x36(:,:,1230))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1391),h0tab(:,1391),[28,3],[nMH,nMW],2,2,wf9(:,11),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,11),G0H4(14),m3h9x4(:,222),heltab2x36(:,:,1231))
  Gcoeff(:)%j = (c(247)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1392),h0tab(:,1392),[28,3],[0,nML],2,2,wf9(:,10),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,10),G0H4(71),ngPnl,m3h9x4(:,223),heltab2x36(:,:,1232))
  call Hloop_Q_A(ntryL,G0H4(71),28,0,G1H4(19),n2h4(39))
  Gcoeff(:)%j = (-(c(245)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1393),h0tab(:,1393),[28,3],[nMT,nMB],2,2,wf9(:,10),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,10),G0H4(21),ngPtb,m3h9x4(:,224),heltab2x36(:,:,1233))
  call Hloop_Q_A(ntryL,G0H4(21),28,nMT,G1H4(20),n2h4(40))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1394),h0tab(:,1394),[28,3],[nMH,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,10),G0H4(16),m3h9x4(:,225),heltab2x36(:,:,1234))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1395),h0tab(:,1395),[28,3],[nMZ,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,10),G0H4(52),m3h9x4(:,226),heltab2x36(:,:,1235))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1396),h0tab(:,1396),[28,3],[0,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,10),G0H4(26),m3h9x4(:,227),heltab2x36(:,:,1236))
  Gcoeff(:)%j = (c(168)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1397),h0tab(:,1397),[28,3],[nMZ,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,10),G0H4(61),m3h9x4(:,228),heltab2x36(:,:,1237))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1398),h0tab(:,1398),[28,3],[0,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,10),G0H4(57),m3h9x4(:,229),heltab2x36(:,:,1238))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1399),h0tab(:,1399),[28,3],[nMZ,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,10),G0H4(53),m3h9x4(:,230),heltab2x36(:,:,1239))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1400),h0tab(:,1400),[28,3],[nMW,0],2,2,wf9(:,10),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,10),28,G1H4(21),m3h9x4(:,231),heltab2x36(:,:,1240))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1401),h0tab(:,1401),[28,3],[nMW,nMZ],2,2,wf9(:,10),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,10),28,G1H4(26),m3h9x4(:,232),heltab2x36(:,:,1241))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1402),h0tab(:,1402),[28,3],[nMH,nMW],2,2,wf9(:,10),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,10),28,G1H4(28),m3h9x4(:,233),heltab2x36(:,:,1242))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1403),h0tab(:,1403),[28,3],[0,0],2,2,wf9(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(27),m3h9x4(:,234),heltab2x36(:,:,1243))
  call Hloop_Q_A(ntryL,G0H4(27),28,0,G1H4(29),n2h4(41))
  Gcoeff(:)%j = (c(190)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1404),h0tab(:,1404),[28,3],[0,nML],2,2,wf9(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(30),m3h9x4(:,235),heltab2x36(:,:,1244))
  call Hloop_Q_A(ntryL,G0H4(30),28,0,G1H4(30),n2h4(42))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1405),h0tab(:,1405),[28,3],[0,0],2,2,wf9(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(31),m3h9x4(:,236),heltab2x36(:,:,1245))
  call Hloop_Q_A(ntryL,G0H4(31),28,0,G1H4(31),n2h4(43))
  Gcoeff(:)%j = (c(191)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1406),h0tab(:,1406),[28,3],[nMT,nMB],2,2,wf9(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,12),G0H4(44),m3h9x4(:,237),heltab2x36(:,:,1246))
  call Hloop_Q_A(ntryL,G0H4(44),28,nMT,G1H4(6),n2h4(44))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1407),h0tab(:,1407),[28,3],[nMH,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(7),m3h9x4(:,238),heltab2x36(:,:,1247))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1408),h0tab(:,1408),[28,3],[nMZ,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(11),m3h9x4(:,239),heltab2x36(:,:,1248))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1409),h0tab(:,1409),[28,3],[0,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(12),m3h9x4(:,240),heltab2x36(:,:,1249))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1410),h0tab(:,1410),[28,3],[nMZ,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(13),m3h9x4(:,241),heltab2x36(:,:,1250))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1411),h0tab(:,1411),[28,3],[0,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,12),G1H4(17),m3h9x4(:,242),heltab2x36(:,:,1251))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1412),h0tab(:,1412),[28,3],[nMZ,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,12),G1H4(1),m3h9x4(:,243),heltab2x36(:,:,1252))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1413),h0tab(:,1413),[28,3],[0,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(2),m3h9x4(:,244),heltab2x36(:,:,1253))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1414),h0tab(:,1414),[28,3],[nMZ,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,12),28,G1H4(3),m3h9x4(:,245),heltab2x36(:,:,1254))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1415),h0tab(:,1415),[28,3],[nMW,0],2,2,wf9(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,12),G0H4(45),m3h9x4(:,246),heltab2x36(:,:,1255))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1416),h0tab(:,1416),[28,3],[nMW,nMZ],2,2,wf9(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,12),G0H4(46),m3h9x4(:,247),heltab2x36(:,:,1256))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1417),h0tab(:,1417),[28,3],[nMH,nMW],2,2,wf9(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,12),G0H4(47),m3h9x4(:,248),heltab2x36(:,:,1257))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1418),h0tab(:,1418),[24,7],[0,nML],2,2,wf9(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(71),ngPnl,m3h9x4(:,249),heltab2x36(:,:,1258))
  call Hloop_Q_A(ntryL,G0H4(71),24,0,G1H4(4),n2h4(45))
  Gcoeff(:)%j = (-(c(234)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1419),h0tab(:,1419),[24,7],[nMT,nMB],2,2,wf9(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(21),ngPtb,m3h9x4(:,250),heltab2x36(:,:,1259))
  call Hloop_Q_A(ntryL,G0H4(21),24,nMT,G1H4(18),n2h4(46))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1420),h0tab(:,1420),[24,7],[nMH,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(27),m3h9x4(:,251),heltab2x36(:,:,1260))
  Gcoeff(:)%j = (c(164)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1421),h0tab(:,1421),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(30),m3h9x4(:,252),heltab2x36(:,:,1261))
  Gcoeff(:)%j = (c(164)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1422),h0tab(:,1422),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(31),m3h9x4(:,253),heltab2x36(:,:,1262))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1423),h0tab(:,1423),[24,7],[0,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(44),m3h9x4(:,254),heltab2x36(:,:,1263))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1424),h0tab(:,1424),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(71),m3h9x4(:,255),heltab2x36(:,:,1264))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1425),h0tab(:,1425),[24,7],[nMW,0],2,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(27),m3h9x4(:,256),heltab2x36(:,:,1265))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1426),h0tab(:,1426),[24,7],[nMW,nMZ],2,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(69),m3h9x4(:,257),heltab2x36(:,:,1266))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1427),h0tab(:,1427),[24,7],[nMH,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(68),m3h9x4(:,258),heltab2x36(:,:,1267))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1428),h0tab(:,1428),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(8),m3h9x4(:,259),heltab2x36(:,:,1268))
  Gcoeff(:)%j = (c(183)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1429),h0tab(:,1429),[24,7],[0,nML],2,2,wf9(:,2),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(21),m3h9x4(:,260),heltab2x36(:,:,1269))
  call Hloop_Q_A(ntryL,G0H4(21),24,0,G1H4(9),n2h4(47))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1430),h0tab(:,1430),[24,7],[nMT,nMB],2,2,wf9(:,2),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(21),m3h9x4(:,261),heltab2x36(:,:,1270))
  call Hloop_Q_A(ntryL,G0H4(21),24,nMT,G1H4(10),n2h4(48))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1431),h0tab(:,1431),[24,7],[nMH,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(14),m3h9x4(:,262),heltab2x36(:,:,1271))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1432),h0tab(:,1432),[24,7],[0,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(74),m3h9x4(:,263),heltab2x36(:,:,1272))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1433),h0tab(:,1433),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(75),m3h9x4(:,264),heltab2x36(:,:,1273))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1434),h0tab(:,1434),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,2),G1H4(76),m3h9x4(:,265),heltab2x36(:,:,1274))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1435),h0tab(:,1435),[24,7],[0,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(77),m3h9x4(:,266),heltab2x36(:,:,1275))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1436),h0tab(:,1436),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(78),m3h9x4(:,267),heltab2x36(:,:,1276))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1437),h0tab(:,1437),[24,7],[nMW,0],2,2,wf9(:,2),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(21),m3h9x4(:,268),heltab2x36(:,:,1277))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1438),h0tab(:,1438),[24,7],[nMW,nMZ],2,2,wf9(:,2),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(75),m3h9x4(:,269),heltab2x36(:,:,1278))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1439),h0tab(:,1439),[24,7],[nMH,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(76),m3h9x4(:,270),heltab2x36(:,:,1279))
  Gcoeff(:)%j = (c(247)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1440),h0tab(:,1440),[24,7],[0,nML],2,2,wf9(:,1),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(77),ngPnl,m3h9x4(:,271),heltab2x36(:,:,1280))
  call Hloop_Q_A(ntryL,G0H4(77),24,0,G1H4(79),n2h4(49))
  Gcoeff(:)%j = (-(c(245)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1441),h0tab(:,1441),[24,7],[nMT,nMB],2,2,wf9(:,1),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(77),ngPtb,m3h9x4(:,272),heltab2x36(:,:,1281))
  call Hloop_Q_A(ntryL,G0H4(77),24,nMT,G1H4(80),n2h4(50))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1442),h0tab(:,1442),[24,7],[nMH,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(77),m3h9x4(:,273),heltab2x36(:,:,1282))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1443),h0tab(:,1443),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(78),m3h9x4(:,274),heltab2x36(:,:,1283))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1444),h0tab(:,1444),[24,7],[0,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(79),m3h9x4(:,275),heltab2x36(:,:,1284))
  Gcoeff(:)%j = (c(168)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1445),h0tab(:,1445),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(80),m3h9x4(:,276),heltab2x36(:,:,1285))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1446),h0tab(:,1446),[24,7],[0,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(81),m3h9x4(:,277),heltab2x36(:,:,1286))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1447),h0tab(:,1447),[24,7],[nMZ,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(82),m3h9x4(:,278),heltab2x36(:,:,1287))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1448),h0tab(:,1448),[24,7],[nMW,0],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(81),m3h9x4(:,279),heltab2x36(:,:,1288))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1449),h0tab(:,1449),[24,7],[nMW,nMZ],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(82),m3h9x4(:,280),heltab2x36(:,:,1289))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1450),h0tab(:,1450),[24,7],[nMH,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(83),m3h9x4(:,281),heltab2x36(:,:,1290))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1451),h0tab(:,1451),[24,7],[0,0],2,2,wf9(:,2),wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(83),m3h9x4(:,282),heltab2x36(:,:,1291))
  call Hloop_Q_A(ntryL,G0H4(83),24,0,G1H4(84),n2h4(51))
  Gcoeff(:)%j = (c(190)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1452),h0tab(:,1452),[24,7],[0,nML],2,2,wf9(:,2),wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(83),m3h9x4(:,283),heltab2x36(:,:,1292))
  call Hloop_Q_A(ntryL,G0H4(83),24,0,G1H4(85),n2h4(52))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1453),h0tab(:,1453),[24,7],[0,0],2,2,wf9(:,2),wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(83),m3h9x4(:,284),heltab2x36(:,:,1293))
  call Hloop_Q_A(ntryL,G0H4(83),24,0,G1H4(86),n2h4(53))
  Gcoeff(:)%j = (c(191)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1454),h0tab(:,1454),[24,7],[nMT,nMB],2,2,wf9(:,2),wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,2),G0H4(83),m3h9x4(:,285),heltab2x36(:,:,1294))
  call Hloop_Q_A(ntryL,G0H4(83),24,nMT,G1H4(87),n2h4(54))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1455),h0tab(:,1455),[24,7],[nMH,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(88),m3h9x4(:,286),heltab2x36(:,:,1295))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1456),h0tab(:,1456),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(89),m3h9x4(:,287),heltab2x36(:,:,1296))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1457),h0tab(:,1457),[24,7],[0,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(90),m3h9x4(:,288),heltab2x36(:,:,1297))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1458),h0tab(:,1458),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(91),m3h9x4(:,289),heltab2x36(:,:,1298))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1459),h0tab(:,1459),[24,7],[0,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,2),G1H4(92),m3h9x4(:,290),heltab2x36(:,:,1299))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1460),h0tab(:,1460),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,2),G1H4(93),m3h9x4(:,291),heltab2x36(:,:,1300))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1461),h0tab(:,1461),[24,7],[0,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(94),m3h9x4(:,292),heltab2x36(:,:,1301))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1462),h0tab(:,1462),[24,7],[nMZ,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),24,G1H4(95),m3h9x4(:,293),heltab2x36(:,:,1302))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1463),h0tab(:,1463),[24,7],[nMW,0],2,2,wf9(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(83),m3h9x4(:,294),heltab2x36(:,:,1303))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1464),h0tab(:,1464),[24,7],[nMW,nMZ],2,2,wf9(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(84),m3h9x4(:,295),heltab2x36(:,:,1304))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1465),h0tab(:,1465),[24,7],[nMH,nMW],2,2,wf9(:,2),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(85),m3h9x4(:,296),heltab2x36(:,:,1305))
  Gcoeff(:)%j = (c(238)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1466),h0tab(:,1466),[28,3],[0,nML],2,2,wf9(:,13),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,13),G0H4(86),ngPnl,m3h9x4(:,297),heltab2x36(:,:,1306))
  call Hloop_Q_A(ntryL,G0H4(86),28,0,G1H4(96),n2h4(55))
  Gcoeff(:)%j = (-(c(236)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1467),h0tab(:,1467),[28,3],[nMT,nMB],2,2,wf9(:,13),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,13),G0H4(86),ngPtb,m3h9x4(:,298),heltab2x36(:,:,1307))
  call Hloop_Q_A(ntryL,G0H4(86),28,nMT,G1H4(97),n2h4(56))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1468),h0tab(:,1468),[28,3],[nMH,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,13),G0H4(86),m3h9x4(:,299),heltab2x36(:,:,1308))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1469),h0tab(:,1469),[28,3],[nMZ,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,13),G0H4(87),m3h9x4(:,300),heltab2x36(:,:,1309))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1470),h0tab(:,1470),[28,3],[0,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,13),G0H4(88),m3h9x4(:,301),heltab2x36(:,:,1310))
  Gcoeff(:)%j = (c(163)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1471),h0tab(:,1471),[28,3],[nMZ,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,13),G0H4(89),m3h9x4(:,302),heltab2x36(:,:,1311))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1472),h0tab(:,1472),[28,3],[0,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,13),G0H4(90),m3h9x4(:,303),heltab2x36(:,:,1312))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1473),h0tab(:,1473),[28,3],[nMZ,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,13),G0H4(91),m3h9x4(:,304),heltab2x36(:,:,1313))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1474),h0tab(:,1474),[28,3],[nMW,0],2,2,wf9(:,13),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,13),28,G1H4(98),m3h9x4(:,305),heltab2x36(:,:,1314))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1475),h0tab(:,1475),[28,3],[nMW,nMZ],2,2,wf9(:,13),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,13),28,G1H4(99),m3h9x4(:,306),heltab2x36(:,:,1315))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1476),h0tab(:,1476),[28,3],[nMH,nMW],2,2,wf9(:,13),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,13),28,G1H4(100),m3h9x4(:,307),heltab2x36(:,:,1316))
  Gcoeff(:)%j = (-(c(244)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1477),h0tab(:,1477),[28,3],[0,0],2,2,wf9(:,15),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(92),m3h9x4(:,308),heltab2x36(:,:,1317))
  call Hloop_Q_A(ntryL,G0H4(92),28,0,G1H4(101),n2h4(57))
  Gcoeff(:)%j = (-(c(242)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1478),h0tab(:,1478),[28,3],[0,nML],2,2,wf9(:,15),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(92),m3h9x4(:,309),heltab2x36(:,:,1318))
  call Hloop_Q_A(ntryL,G0H4(92),28,0,G1H4(102),n2h4(58))
  Gcoeff(:)%j = (-(c(245)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1479),h0tab(:,1479),[28,3],[0,0],2,2,wf9(:,15),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(92),m3h9x4(:,310),heltab2x36(:,:,1319))
  call Hloop_Q_A(ntryL,G0H4(92),28,0,G1H4(103),n2h4(59))
  Gcoeff(:)%j = (-(c(243)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1480),h0tab(:,1480),[28,3],[nMT,nMB],2,2,wf9(:,15),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,15),G0H4(92),m3h9x4(:,311),heltab2x36(:,:,1320))
  call Hloop_Q_A(ntryL,G0H4(92),28,nMT,G1H4(104),n2h4(60))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1481),h0tab(:,1481),[28,3],[nMH,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(105),m3h9x4(:,312),heltab2x36(:,:,1321))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1482),h0tab(:,1482),[28,3],[nMZ,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(106),m3h9x4(:,313),heltab2x36(:,:,1322))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1483),h0tab(:,1483),[28,3],[0,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(107),m3h9x4(:,314),heltab2x36(:,:,1323))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1484),h0tab(:,1484),[28,3],[nMZ,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(108),m3h9x4(:,315),heltab2x36(:,:,1324))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1485),h0tab(:,1485),[28,3],[0,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,15),G1H4(109),m3h9x4(:,316),heltab2x36(:,:,1325))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1486),h0tab(:,1486),[28,3],[nMZ,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,15),G1H4(110),m3h9x4(:,317),heltab2x36(:,:,1326))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1487),h0tab(:,1487),[28,3],[0,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(111),m3h9x4(:,318),heltab2x36(:,:,1327))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1488),h0tab(:,1488),[28,3],[nMZ,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,15),28,G1H4(112),m3h9x4(:,319),heltab2x36(:,:,1328))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1489),h0tab(:,1489),[28,3],[nMW,0],2,2,wf9(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,15),G0H4(92),m3h9x4(:,320),heltab2x36(:,:,1329))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1490),h0tab(:,1490),[28,3],[nMW,nMZ],2,2,wf9(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,15),G0H4(93),m3h9x4(:,321),heltab2x36(:,:,1330))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1491),h0tab(:,1491),[28,3],[nMH,nMW],2,2,wf9(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,15),G0H4(94),m3h9x4(:,322),heltab2x36(:,:,1331))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1492),h0tab(:,1492),[28,3],[0,nML],2,2,wf9(:,14),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,14),G0H4(95),ngPnl,m3h9x4(:,323),heltab2x36(:,:,1332))
  call Hloop_Q_A(ntryL,G0H4(95),28,0,G1H4(113),n2h4(61))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1493),h0tab(:,1493),[28,3],[nMT,nMB],2,2,wf9(:,14),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,14),G0H4(95),ngPtb,m3h9x4(:,324),heltab2x36(:,:,1333))
  call Hloop_Q_A(ntryL,G0H4(95),28,nMT,G1H4(114),n2h4(62))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1494),h0tab(:,1494),[28,3],[nMH,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,14),G0H4(95),m3h9x4(:,325),heltab2x36(:,:,1334))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1495),h0tab(:,1495),[28,3],[nMZ,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,14),G0H4(96),m3h9x4(:,326),heltab2x36(:,:,1335))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1496),h0tab(:,1496),[28,3],[0,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,14),G0H4(97),m3h9x4(:,327),heltab2x36(:,:,1336))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1497),h0tab(:,1497),[28,3],[nMZ,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,14),G0H4(98),m3h9x4(:,328),heltab2x36(:,:,1337))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1498),h0tab(:,1498),[28,3],[0,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,14),G0H4(99),m3h9x4(:,329),heltab2x36(:,:,1338))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1499),h0tab(:,1499),[28,3],[nMZ,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,14),G0H4(100),m3h9x4(:,330),heltab2x36(:,:,1339))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1500),h0tab(:,1500),[28,3],[nMW,0],2,2,wf9(:,14),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,14),28,G1H4(115),m3h9x4(:,331),heltab2x36(:,:,1340))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1501),h0tab(:,1501),[28,3],[nMW,nMZ],2,2,wf9(:,14),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,14),28,G1H4(116),m3h9x4(:,332),heltab2x36(:,:,1341))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1502),h0tab(:,1502),[28,3],[nMH,nMW],2,2,wf9(:,14),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,14),28,G1H4(117),m3h9x4(:,333),heltab2x36(:,:,1342))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1503),h0tab(:,1503),[28,3],[0,0],2,2,wf9(:,16),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(101),m3h9x4(:,334),heltab2x36(:,:,1343))
  call Hloop_Q_A(ntryL,G0H4(101),28,0,G1H4(118),n2h4(63))
  Gcoeff(:)%j = (c(190)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1504),h0tab(:,1504),[28,3],[0,nML],2,2,wf9(:,16),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(101),m3h9x4(:,335),heltab2x36(:,:,1344))
  call Hloop_Q_A(ntryL,G0H4(101),28,0,G1H4(119),n2h4(64))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1505),h0tab(:,1505),[28,3],[0,0],2,2,wf9(:,16),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(101),m3h9x4(:,336),heltab2x36(:,:,1345))
  call Hloop_Q_A(ntryL,G0H4(101),28,0,G1H4(120),n2h4(65))
  Gcoeff(:)%j = (c(191)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1506),h0tab(:,1506),[28,3],[nMT,nMB],2,2,wf9(:,16),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,16),G0H4(101),m3h9x4(:,337),heltab2x36(:,:,1346))
  call Hloop_Q_A(ntryL,G0H4(101),28,nMT,G1H4(121),n2h4(66))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1507),h0tab(:,1507),[28,3],[nMH,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(122),m3h9x4(:,338),heltab2x36(:,:,1347))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1508),h0tab(:,1508),[28,3],[nMZ,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(123),m3h9x4(:,339),heltab2x36(:,:,1348))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1509),h0tab(:,1509),[28,3],[0,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(124),m3h9x4(:,340),heltab2x36(:,:,1349))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1510),h0tab(:,1510),[28,3],[nMZ,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(125),m3h9x4(:,341),heltab2x36(:,:,1350))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1511),h0tab(:,1511),[28,3],[0,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,16),G1H4(126),m3h9x4(:,342),heltab2x36(:,:,1351))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1512),h0tab(:,1512),[28,3],[nMZ,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,16),G1H4(127),m3h9x4(:,343),heltab2x36(:,:,1352))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1513),h0tab(:,1513),[28,3],[0,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(128),m3h9x4(:,344),heltab2x36(:,:,1353))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1514),h0tab(:,1514),[28,3],[nMZ,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,16),28,G1H4(129),m3h9x4(:,345),heltab2x36(:,:,1354))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1515),h0tab(:,1515),[28,3],[nMW,0],2,2,wf9(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,16),G0H4(101),m3h9x4(:,346),heltab2x36(:,:,1355))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1516),h0tab(:,1516),[28,3],[nMW,nMZ],2,2,wf9(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,16),G0H4(102),m3h9x4(:,347),heltab2x36(:,:,1356))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1517),h0tab(:,1517),[28,3],[nMH,nMW],2,2,wf9(:,16),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,16),G0H4(103),m3h9x4(:,348),heltab2x36(:,:,1357))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1518),h0tab(:,1518),[20,11],[0,nML],2,2,wf3(:,2),wf12(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,2),G0H12(57),ngPnl,m3h3x12(:,686),heltab2x36(:,:,1358))
  call Hloop_Q_A(ntryL,G0H12(57),20,0,G1H12(130),n2h12(121))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1519),h0tab(:,1519),[20,11],[nMT,nMB],2,2,wf3(:,2),wf12(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,2),G0H12(58),ngPtb,m3h3x12(:,687),heltab2x36(:,:,1359))
  call Hloop_Q_A(ntryL,G0H12(58),20,nMT,G1H12(131),n2h12(122))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1520),h0tab(:,1520),[20,11],[nMH,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(59),m3h3x12(:,688),heltab2x36(:,:,1360))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1521),h0tab(:,1521),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(63),m3h3x12(:,689),heltab2x36(:,:,1361))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1522),h0tab(:,1522),[20,11],[0,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(72),m3h3x12(:,690),heltab2x36(:,:,1362))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1523),h0tab(:,1523),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(81),m3h3x12(:,691),heltab2x36(:,:,1363))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1524),h0tab(:,1524),[20,11],[0,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(9),m3h3x12(:,692),heltab2x36(:,:,1364))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1525),h0tab(:,1525),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(5),m3h3x12(:,693),heltab2x36(:,:,1365))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1526),h0tab(:,1526),[20,11],[nMW,0],2,2,wf3(:,2),wf12(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(132),m3h3x12(:,694),heltab2x36(:,:,1366))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1527),h0tab(:,1527),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(133),m3h3x12(:,695),heltab2x36(:,:,1367))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1528),h0tab(:,1528),[20,11],[nMH,nMW],2,2,wf3(:,2),wf12(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(134),m3h3x12(:,696),heltab2x36(:,:,1368))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1529),h0tab(:,1529),[20,11],[0,0],2,2,wf3(:,3),wf12(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(30),m3h3x12(:,697),heltab2x36(:,:,1369))
  call Hloop_Q_A(ntryL,G0H12(30),20,0,G1H12(135),n2h12(123))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1530),h0tab(:,1530),[20,11],[0,nML],2,2,wf3(:,3),wf12(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(1),m3h3x12(:,698),heltab2x36(:,:,1370))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(136),n2h12(124))
  Gcoeff(:)%j = (c(210)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1531),h0tab(:,1531),[20,11],[0,0],2,2,wf3(:,3),wf12(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(31),m3h3x12(:,699),heltab2x36(:,:,1371))
  call Hloop_Q_A(ntryL,G0H12(31),20,0,G1H12(137),n2h12(125))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1532),h0tab(:,1532),[20,11],[nMT,nMB],2,2,wf3(:,3),wf12(:,4))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(16),m3h3x12(:,700),heltab2x36(:,:,1372))
  call Hloop_Q_A(ntryL,G0H12(16),20,nMT,G1H12(138),n2h12(126))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1533),h0tab(:,1533),[20,11],[nMH,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(139),m3h3x12(:,701),heltab2x36(:,:,1373))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1534),h0tab(:,1534),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(178),m3h3x12(:,702),heltab2x36(:,:,1374))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1535),h0tab(:,1535),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(140),m3h3x12(:,703),heltab2x36(:,:,1375))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1536),h0tab(:,1536),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(205),m3h3x12(:,704),heltab2x36(:,:,1376))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1537),h0tab(:,1537),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(141),m3h3x12(:,705),heltab2x36(:,:,1377))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1538),h0tab(:,1538),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(232),m3h3x12(:,706),heltab2x36(:,:,1378))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1539),h0tab(:,1539),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(142),m3h3x12(:,707),heltab2x36(:,:,1379))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1540),h0tab(:,1540),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(143),m3h3x12(:,708),heltab2x36(:,:,1380))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1541),h0tab(:,1541),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(17),m3h3x12(:,709),heltab2x36(:,:,1381))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1542),h0tab(:,1542),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(60),m3h3x12(:,710),heltab2x36(:,:,1382))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1543),h0tab(:,1543),[20,11],[nMH,nMW],2,2,wf3(:,3),wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(61),m3h3x12(:,711),heltab2x36(:,:,1383))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1544),h0tab(:,1544),[22,9],[0,0],2,2,wf6(:,23),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,23),G0H6(17),m3h6x6(:,37),heltab2x36(:,:,1384))
  call Hloop_Q_A(ntryL,G0H6(17),22,0,G1H6(35),n2h6(165))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1545),h0tab(:,1545),[22,9],[0,nMZ],2,2,wf6(:,23),wf6(:,2))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf6(:,23),G0H6(4),ngZu,m3h6x6(:,38),heltab2x36(:,:,1385))
  call Hloop_Q_A(ntryL,G0H6(4),22,0,G1H6(23),n2h6(166))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1546),h0tab(:,1546),[22,9],[0,nMW],2,2,wf6(:,23),wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,23),G0H6(5),m3h6x6(:,39),heltab2x36(:,:,1386))
  call Hloop_Q_A(ntryL,G0H6(5),22,0,G1H6(24),n2h6(167))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1547),h0tab(:,1547),[22,9],[0,0],2,2,wf6(:,23),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,23),G0H6(1),m3h6x6(:,40),heltab2x36(:,:,1387))
  call Hloop_Q_A(ntryL,G0H6(1),22,0,G1H6(17),n2h6(168))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1548),h0tab(:,1548),[20,11],[0,nML],2,2,wf3(:,2),wf12(:,5))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,2),G0H12(62),ngPnl,m3h3x12(:,712),heltab2x36(:,:,1388))
  call Hloop_Q_A(ntryL,G0H12(62),20,0,G1H12(144),n2h12(127))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1549),h0tab(:,1549),[20,11],[nMT,nMB],2,2,wf3(:,2),wf12(:,5))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,2),G0H12(3),ngPtb,m3h3x12(:,713),heltab2x36(:,:,1389))
  call Hloop_Q_A(ntryL,G0H12(3),20,nMT,G1H12(145),n2h12(128))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1550),h0tab(:,1550),[20,11],[nMH,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(18),m3h3x12(:,714),heltab2x36(:,:,1390))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1551),h0tab(:,1551),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(2),m3h3x12(:,715),heltab2x36(:,:,1391))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1552),h0tab(:,1552),[20,11],[0,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(87),m3h3x12(:,716),heltab2x36(:,:,1392))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1553),h0tab(:,1553),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,2),G0H12(92),m3h3x12(:,717),heltab2x36(:,:,1393))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1554),h0tab(:,1554),[20,11],[0,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(93),m3h3x12(:,718),heltab2x36(:,:,1394))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1555),h0tab(:,1555),[20,11],[nMZ,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,2),G0H12(94),m3h3x12(:,719),heltab2x36(:,:,1395))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1556),h0tab(:,1556),[20,11],[nMW,0],2,2,wf3(:,2),wf12(:,5))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(146),m3h3x12(:,720),heltab2x36(:,:,1396))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1557),h0tab(:,1557),[20,11],[nMW,nMZ],2,2,wf3(:,2),wf12(:,5))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(147),m3h3x12(:,721),heltab2x36(:,:,1397))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1558),h0tab(:,1558),[20,11],[nMH,nMW],2,2,wf3(:,2),wf12(:,5))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,2),20,G1H12(148),m3h3x12(:,722),heltab2x36(:,:,1398))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1559),h0tab(:,1559),[20,11],[0,0],2,2,wf3(:,3),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(95),m3h3x12(:,723),heltab2x36(:,:,1399))
  call Hloop_Q_A(ntryL,G0H12(95),20,0,G1H12(149),n2h12(129))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1560),h0tab(:,1560),[20,11],[0,nML],2,2,wf3(:,3),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(96),m3h3x12(:,724),heltab2x36(:,:,1400))
  call Hloop_Q_A(ntryL,G0H12(96),20,0,G1H12(150),n2h12(130))
  Gcoeff(:)%j = (c(210)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1561),h0tab(:,1561),[20,11],[0,0],2,2,wf3(:,3),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(97),m3h3x12(:,725),heltab2x36(:,:,1401))
  call Hloop_Q_A(ntryL,G0H12(97),20,0,G1H12(151),n2h12(131))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1562),h0tab(:,1562),[20,11],[nMT,nMB],2,2,wf3(:,3),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,3),G0H12(98),m3h3x12(:,726),heltab2x36(:,:,1402))
  call Hloop_Q_A(ntryL,G0H12(98),20,nMT,G1H12(152),n2h12(132))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1563),h0tab(:,1563),[20,11],[nMH,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(153),m3h3x12(:,727),heltab2x36(:,:,1403))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1564),h0tab(:,1564),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(154),m3h3x12(:,728),heltab2x36(:,:,1404))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1565),h0tab(:,1565),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(155),m3h3x12(:,729),heltab2x36(:,:,1405))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1566),h0tab(:,1566),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(156),m3h3x12(:,730),heltab2x36(:,:,1406))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1567),h0tab(:,1567),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(157),m3h3x12(:,731),heltab2x36(:,:,1407))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1568),h0tab(:,1568),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,3),G1H12(158),m3h3x12(:,732),heltab2x36(:,:,1408))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1569),h0tab(:,1569),[20,11],[0,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(59),m3h3x12(:,733),heltab2x36(:,:,1409))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1570),h0tab(:,1570),[20,11],[nMZ,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,3),20,G1H12(159),m3h3x12(:,734),heltab2x36(:,:,1410))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1571),h0tab(:,1571),[20,11],[nMW,0],2,2,wf3(:,3),wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(99),m3h3x12(:,735),heltab2x36(:,:,1411))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1572),h0tab(:,1572),[20,11],[nMW,nMZ],2,2,wf3(:,3),wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(100),m3h3x12(:,736),heltab2x36(:,:,1412))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1573),h0tab(:,1573),[20,11],[nMH,nMW],2,2,wf3(:,3),wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,3),G0H12(105),m3h3x12(:,737),heltab2x36(:,:,1413))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1574),h0tab(:,1574),[21,10],[0,0],2,2,wf6(:,27),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,27),G0H6(2),m3h6x6(:,41),heltab2x36(:,:,1414))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1575),h0tab(:,1575),[21,10],[nMZ,0],2,2,wf6(:,27),wf6(:,4))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,27),G0H6(8),ngZd,m3h6x6(:,42),heltab2x36(:,:,1415))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1576),h0tab(:,1576),[21,10],[nMW,0],2,2,wf6(:,27),wf6(:,4))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,27),G0H6(6),m3h6x6(:,43),heltab2x36(:,:,1416))
  Gcoeff(:)%j = (-(c(110)*M(2,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1577),h0tab(:,1577),[21,10],[0,0],2,2,wf6(:,27),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,27),G0H6(7),m3h6x6(:,44),heltab2x36(:,:,1417))
  Gcoeff(:)%j = (-(c(220)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1578),h0tab(:,1578),[19,12],[nML,nML],2,2,wf12(:,11),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(8),m3h12x3(:,277),heltab2x36(:,:,1418))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(113),n2h3(190))
  Gcoeff(:)%j = (-(c(224)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1579),h0tab(:,1579),[19,12],[nMT,nMT],2,2,wf12(:,11),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(14),m3h12x3(:,278),heltab2x36(:,:,1419))
  call Hloop_Q_A(ntryL,G0H3(14),19,nMT,G1H3(212),n2h3(191))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1580),h0tab(:,1580),[19,12],[nMB,nMB],2,2,wf12(:,11),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(4),m3h12x3(:,279),heltab2x36(:,:,1420))
  call Hloop_Q_A(ntryL,G0H3(4),19,nMB,G1H3(230),n2h3(192))
  Gcoeff(:)%j = (-(c(222)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1581),h0tab(:,1581),[19,12],[nML,nML],2,2,wf12(:,6),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(43),ngZl,m3h12x3(:,280),heltab2x36(:,:,1421))
  call Hloop_Q_A(ntryL,G0H3(43),19,nML,G1H3(215),n2h3(193))
  Gcoeff(:)%j = (c(227)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1582),h0tab(:,1582),[19,12],[nMT,nMT],2,2,wf12(:,6),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(41),ngZu,m3h12x3(:,281),heltab2x36(:,:,1422))
  call Hloop_Q_A(ntryL,G0H3(41),19,nMT,G1H3(229),n2h3(194))
  Gcoeff(:)%j = (-(c(218)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1583),h0tab(:,1583),[19,12],[nMB,nMB],2,2,wf12(:,6),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(40),ngZd,m3h12x3(:,282),heltab2x36(:,:,1423))
  call Hloop_Q_A(ntryL,G0H3(40),19,nMB,G1H3(234),n2h3(195))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1584),h0tab(:,1584),[19,12],[nMZ,nMH],2,2,wf12(:,6),wf3(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(237),m3h12x3(:,283),heltab2x36(:,:,1424))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1585),h0tab(:,1585),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(148),m3h12x3(:,284),heltab2x36(:,:,1425))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1586),h0tab(:,1586),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(150),m3h12x3(:,285),heltab2x36(:,:,1426))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1587),h0tab(:,1587),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(153),m3h12x3(:,286),heltab2x36(:,:,1427))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1588),h0tab(:,1588),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(155),m3h12x3(:,287),heltab2x36(:,:,1428))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1589),h0tab(:,1589),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(20),m3h12x3(:,288),heltab2x36(:,:,1429))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1590),h0tab(:,1590),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(15),m3h12x3(:,289),heltab2x36(:,:,1430))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1591),h0tab(:,1591),[19,12],[nMZ,nMH],2,2,wf12(:,6),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(19),m3h12x3(:,290),heltab2x36(:,:,1431))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1592),h0tab(:,1592),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(1),m3h12x3(:,291),heltab2x36(:,:,1432))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1593),h0tab(:,1593),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(5),m3h12x3(:,292),heltab2x36(:,:,1433))
  Gcoeff(:)%j = (c(264)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1594),h0tab(:,1594),[19,12],[0,0],2,2,wf12(:,11),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(12),m3h12x3(:,293),heltab2x36(:,:,1434))
  call Hloop_Q_A(ntryL,G0H3(12),19,0,G1H3(156),n2h3(196))
  Gcoeff(:)%j = (c(261)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1595),h0tab(:,1595),[19,12],[nML,nML],2,2,wf12(:,11),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(18),m3h12x3(:,294),heltab2x36(:,:,1435))
  call Hloop_Q_A(ntryL,G0H3(18),19,nML,G1H3(161),n2h3(197))
  Gcoeff(:)%j = (-(c(263)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1596),h0tab(:,1596),[19,12],[0,0],2,2,wf12(:,11),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(3),m3h12x3(:,295),heltab2x36(:,:,1436))
  call Hloop_Q_A(ntryL,G0H3(3),19,0,G1H3(221),n2h3(198))
  Gcoeff(:)%j = (-(c(260)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1597),h0tab(:,1597),[19,12],[nMT,nMT],2,2,wf12(:,11),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(6),m3h12x3(:,296),heltab2x36(:,:,1437))
  call Hloop_Q_A(ntryL,G0H3(6),19,nMT,G1H3(222),n2h3(199))
  Gcoeff(:)%j = (c(260)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1598),h0tab(:,1598),[19,12],[0,0],2,2,wf12(:,11),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(2),m3h12x3(:,297),heltab2x36(:,:,1438))
  call Hloop_Q_A(ntryL,G0H3(2),19,0,G1H3(71),n2h3(200))
  Gcoeff(:)%j = (c(259)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1599),h0tab(:,1599),[19,12],[nMB,nMB],2,2,wf12(:,11),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,11),G0H3(17),m3h12x3(:,298),heltab2x36(:,:,1439))
  call Hloop_Q_A(ntryL,G0H3(17),19,nMB,G1H3(139),n2h3(201))
  Gcoeff(:)%j = (c(273)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1600),h0tab(:,1600),[19,12],[0,0],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(16),ngZn,m3h12x3(:,299),heltab2x36(:,:,1440))
  call Hloop_Q_A(ntryL,G0H3(16),19,0,G1H3(203),n2h3(202))
  Gcoeff(:)%j = (c(271)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1601),h0tab(:,1601),[19,12],[0,0],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(47),ngZl,m3h12x3(:,300),heltab2x36(:,:,1441))
  call Hloop_Q_A(ntryL,G0H3(47),19,0,G1H3(124),n2h3(203))
  Gcoeff(:)%j = (c(267)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1602),h0tab(:,1602),[19,12],[nML,nML],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(8),ngZl,m3h12x3(:,301),heltab2x36(:,:,1442))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(208),n2h3(204))
  Gcoeff(:)%j = (c(272)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1603),h0tab(:,1603),[19,12],[0,0],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(14),ngZu,m3h12x3(:,302),heltab2x36(:,:,1443))
  call Hloop_Q_A(ntryL,G0H3(14),19,0,G1H3(129),n2h3(205))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1604),h0tab(:,1604),[19,12],[nMT,nMT],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(4),ngZu,m3h12x3(:,303),heltab2x36(:,:,1444))
  call Hloop_Q_A(ntryL,G0H3(4),19,nMT,G1H3(122),n2h3(206))
  Gcoeff(:)%j = (c(272)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1605),h0tab(:,1605),[19,12],[0,0],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(43),ngZd,m3h12x3(:,304),heltab2x36(:,:,1445))
  call Hloop_Q_A(ntryL,G0H3(43),19,0,G1H3(39),n2h3(207))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1606),h0tab(:,1606),[19,12],[nMB,nMB],2,2,wf12(:,6),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,6),G0H3(41),ngZd,m3h12x3(:,305),heltab2x36(:,:,1446))
  call Hloop_Q_A(ntryL,G0H3(41),19,nMB,G1H3(171),n2h3(208))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1607),h0tab(:,1607),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(134),m3h12x3(:,306),heltab2x36(:,:,1447))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1608),h0tab(:,1608),[19,12],[nMZ,nMH],2,2,wf12(:,6),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(152),m3h12x3(:,307),heltab2x36(:,:,1448))
  Gcoeff(:)%j = (c(145)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1609),h0tab(:,1609),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(140),m3h12x3(:,308),heltab2x36(:,:,1449))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1610),h0tab(:,1610),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(28),m3h12x3(:,309),heltab2x36(:,:,1450))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1611),h0tab(:,1611),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(14),m3h12x3(:,310),heltab2x36(:,:,1451))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1612),h0tab(:,1612),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(158),m3h12x3(:,311),heltab2x36(:,:,1452))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1613),h0tab(:,1613),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(146),m3h12x3(:,312),heltab2x36(:,:,1453))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1614),h0tab(:,1614),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,11),19,G1H3(3),m3h12x3(:,313),heltab2x36(:,:,1454))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1615),h0tab(:,1615),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,6),19,G1H3(243),m3h12x3(:,314),heltab2x36(:,:,1455))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1616),h0tab(:,1616),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(40),m3h12x3(:,315),heltab2x36(:,:,1456))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1617),h0tab(:,1617),[19,12],[nMW,nMW],2,2,wf12(:,11),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,11),G0H3(12),m3h12x3(:,316),heltab2x36(:,:,1457))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1618),h0tab(:,1618),[19,12],[nMZ,nMH],2,2,wf12(:,6),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(18),m3h12x3(:,317),heltab2x36(:,:,1458))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1619),h0tab(:,1619),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(3),m3h12x3(:,318),heltab2x36(:,:,1459))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1620),h0tab(:,1620),[19,12],[nMW,nMW],2,2,wf12(:,6),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,6),G0H3(6),m3h12x3(:,319),heltab2x36(:,:,1460))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1621),h0tab(:,1621),[17,14],[0,0],2,2,wf6(:,6),wf6(:,31))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(12),m3h6x6(:,45),heltab2x36(:,:,1461))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1622),h0tab(:,1622),[17,14],[nMZ,0],2,2,wf6(:,6),wf6(:,31))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,6),G0H6(10),ngZd,m3h6x6(:,46),heltab2x36(:,:,1462))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1623),h0tab(:,1623),[17,14],[nMW,0],2,2,wf6(:,6),wf6(:,31))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,6),G0H6(11),m3h6x6(:,47),heltab2x36(:,:,1463))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1624),h0tab(:,1624),[17,14],[0,0],2,2,wf6(:,6),wf6(:,31))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(16),m3h6x6(:,48),heltab2x36(:,:,1464))
  Gcoeff(:)%j = (c(221)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1625),h0tab(:,1625),[19,12],[nML,nML],2,2,wf12(:,12),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(2),m3h12x3(:,320),heltab2x36(:,:,1465))
  call Hloop_Q_A(ntryL,G0H3(2),19,nML,G1H3(239),n2h3(209))
  Gcoeff(:)%j = (c(225)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1626),h0tab(:,1626),[19,12],[nMT,nMT],2,2,wf12(:,12),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(17),m3h12x3(:,321),heltab2x36(:,:,1466))
  call Hloop_Q_A(ntryL,G0H3(17),19,nMT,G1H3(79),n2h3(210))
  Gcoeff(:)%j = (c(216)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1627),h0tab(:,1627),[19,12],[nMB,nMB],2,2,wf12(:,12),wf3(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(16),m3h12x3(:,322),heltab2x36(:,:,1467))
  call Hloop_Q_A(ntryL,G0H3(16),19,nMB,G1H3(23),n2h3(211))
  Gcoeff(:)%j = (-(c(222)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1628),h0tab(:,1628),[19,12],[nML,nML],2,2,wf12(:,7),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(47),ngZl,m3h12x3(:,323),heltab2x36(:,:,1468))
  call Hloop_Q_A(ntryL,G0H3(47),19,nML,G1H3(85),n2h3(212))
  Gcoeff(:)%j = (c(227)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1629),h0tab(:,1629),[19,12],[nMT,nMT],2,2,wf12(:,7),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(8),ngZu,m3h12x3(:,324),heltab2x36(:,:,1469))
  call Hloop_Q_A(ntryL,G0H3(8),19,nMT,G1H3(104),n2h3(213))
  Gcoeff(:)%j = (-(c(218)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1630),h0tab(:,1630),[19,12],[nMB,nMB],2,2,wf12(:,7),wf3(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(14),ngZd,m3h12x3(:,325),heltab2x36(:,:,1470))
  call Hloop_Q_A(ntryL,G0H3(14),19,nMB,G1H3(45),n2h3(214))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1631),h0tab(:,1631),[19,12],[nMZ,nMH],2,2,wf12(:,7),wf3(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(16),m3h12x3(:,326),heltab2x36(:,:,1471))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1632),h0tab(:,1632),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(29),m3h12x3(:,327),heltab2x36(:,:,1472))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1633),h0tab(:,1633),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(154),m3h12x3(:,328),heltab2x36(:,:,1473))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1634),h0tab(:,1634),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(13),m3h12x3(:,329),heltab2x36(:,:,1474))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1635),h0tab(:,1635),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(35),m3h12x3(:,330),heltab2x36(:,:,1475))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1636),h0tab(:,1636),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(4),m3h12x3(:,331),heltab2x36(:,:,1476))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1637),h0tab(:,1637),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(43),m3h12x3(:,332),heltab2x36(:,:,1477))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1638),h0tab(:,1638),[19,12],[nMZ,nMH],2,2,wf12(:,7),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(41),m3h12x3(:,333),heltab2x36(:,:,1478))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1639),h0tab(:,1639),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(2),m3h12x3(:,334),heltab2x36(:,:,1479))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1640),h0tab(:,1640),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(17),m3h12x3(:,335),heltab2x36(:,:,1480))
  Gcoeff(:)%j = (-(c(269)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1641),h0tab(:,1641),[19,12],[0,0],2,2,wf12(:,12),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(16),m3h12x3(:,336),heltab2x36(:,:,1481))
  call Hloop_Q_A(ntryL,G0H3(16),19,0,G1H3(20),n2h3(215))
  Gcoeff(:)%j = (-(c(264)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1642),h0tab(:,1642),[19,12],[nML,nML],2,2,wf12(:,12),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(47),m3h12x3(:,337),heltab2x36(:,:,1482))
  call Hloop_Q_A(ntryL,G0H3(47),19,nML,G1H3(58),n2h3(216))
  Gcoeff(:)%j = (c(266)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1643),h0tab(:,1643),[19,12],[0,0],2,2,wf12(:,12),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(8),m3h12x3(:,338),heltab2x36(:,:,1483))
  call Hloop_Q_A(ntryL,G0H3(8),19,0,G1H3(9),n2h3(217))
  Gcoeff(:)%j = (c(263)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1644),h0tab(:,1644),[19,12],[nMT,nMT],2,2,wf12(:,12),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(14),m3h12x3(:,339),heltab2x36(:,:,1484))
  call Hloop_Q_A(ntryL,G0H3(14),19,nMT,G1H3(52),n2h3(218))
  Gcoeff(:)%j = (-(c(263)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1645),h0tab(:,1645),[19,12],[0,0],2,2,wf12(:,12),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(16),m3h12x3(:,340),heltab2x36(:,:,1485))
  call Hloop_Q_A(ntryL,G0H3(16),19,0,G1H3(76),n2h3(219))
  Gcoeff(:)%j = (-(c(260)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1646),h0tab(:,1646),[19,12],[nMB,nMB],2,2,wf12(:,12),wf3(:,1))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,12),G0H3(47),m3h12x3(:,341),heltab2x36(:,:,1486))
  call Hloop_Q_A(ntryL,G0H3(47),19,nMB,G1H3(36),n2h3(220))
  Gcoeff(:)%j = (c(273)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1647),h0tab(:,1647),[19,12],[0,0],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(8),ngZn,m3h12x3(:,342),heltab2x36(:,:,1487))
  call Hloop_Q_A(ntryL,G0H3(8),19,0,G1H3(224),n2h3(221))
  Gcoeff(:)%j = (c(271)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1648),h0tab(:,1648),[19,12],[0,0],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(14),ngZl,m3h12x3(:,343),heltab2x36(:,:,1488))
  call Hloop_Q_A(ntryL,G0H3(14),19,0,G1H3(244),n2h3(222))
  Gcoeff(:)%j = (c(267)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1649),h0tab(:,1649),[19,12],[nML,nML],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(16),ngZl,m3h12x3(:,344),heltab2x36(:,:,1489))
  call Hloop_Q_A(ntryL,G0H3(16),19,nML,G1H3(228),n2h3(223))
  Gcoeff(:)%j = (c(272)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1650),h0tab(:,1650),[19,12],[0,0],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(47),ngZu,m3h12x3(:,345),heltab2x36(:,:,1490))
  call Hloop_Q_A(ntryL,G0H3(47),19,0,G1H3(240),n2h3(224))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1651),h0tab(:,1651),[19,12],[nMT,nMT],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(8),ngZu,m3h12x3(:,346),heltab2x36(:,:,1491))
  call Hloop_Q_A(ntryL,G0H3(8),19,nMT,G1H3(232),n2h3(225))
  Gcoeff(:)%j = (c(272)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1652),h0tab(:,1652),[19,12],[0,0],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(14),ngZd,m3h12x3(:,347),heltab2x36(:,:,1492))
  call Hloop_Q_A(ntryL,G0H3(14),19,0,G1H3(91),n2h3(226))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1653),h0tab(:,1653),[19,12],[nMB,nMB],2,2,wf12(:,7),wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,7),G0H3(16),ngZd,m3h12x3(:,348),heltab2x36(:,:,1493))
  call Hloop_Q_A(ntryL,G0H3(16),19,nMB,G1H3(108),n2h3(227))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1654),h0tab(:,1654),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(50),m3h12x3(:,349),heltab2x36(:,:,1494))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1655),h0tab(:,1655),[19,12],[nMZ,nMH],2,2,wf12(:,7),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(226),m3h12x3(:,350),heltab2x36(:,:,1495))
  Gcoeff(:)%j = (c(145)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1656),h0tab(:,1656),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(8),m3h12x3(:,351),heltab2x36(:,:,1496))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1657),h0tab(:,1657),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(126),m3h12x3(:,352),heltab2x36(:,:,1497))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1658),h0tab(:,1658),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(236),m3h12x3(:,353),heltab2x36(:,:,1498))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1659),h0tab(:,1659),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(116),m3h12x3(:,354),heltab2x36(:,:,1499))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1660),h0tab(:,1660),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(106),m3h12x3(:,355),heltab2x36(:,:,1500))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1661),h0tab(:,1661),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,12),19,G1H3(44),m3h12x3(:,356),heltab2x36(:,:,1501))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1662),h0tab(:,1662),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(180),m3h12x3(:,357),heltab2x36(:,:,1502))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1663),h0tab(:,1663),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(47),m3h12x3(:,358),heltab2x36(:,:,1503))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1664),h0tab(:,1664),[19,12],[nMW,nMW],2,2,wf12(:,12),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,12),G0H3(8),m3h12x3(:,359),heltab2x36(:,:,1504))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1665),h0tab(:,1665),[19,12],[nMZ,nMH],2,2,wf12(:,7),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(14),m3h12x3(:,360),heltab2x36(:,:,1505))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1666),h0tab(:,1666),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(16),m3h12x3(:,361),heltab2x36(:,:,1506))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1667),h0tab(:,1667),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(78),m3h12x3(:,362),heltab2x36(:,:,1507))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1668),h0tab(:,1668),[18,13],[0,0],2,2,wf6(:,8),wf6(:,35))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(14),m3h6x6(:,49),heltab2x36(:,:,1508))
  call Hloop_Q_A(ntryL,G0H6(14),18,0,G1H6(18),n2h6(169))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1669),h0tab(:,1669),[18,13],[0,nMZ],2,2,wf6(:,8),wf6(:,35))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(15),ngZu,m3h6x6(:,50),heltab2x36(:,:,1509))
  call Hloop_Q_A(ntryL,G0H6(15),18,0,G1H6(20),n2h6(170))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1670),h0tab(:,1670),[18,13],[0,nMW],2,2,wf6(:,8),wf6(:,35))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(20),m3h6x6(:,51),heltab2x36(:,:,1510))
  call Hloop_Q_A(ntryL,G0H6(20),18,0,G1H6(38),n2h6(171))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1671),h0tab(:,1671),[18,13],[0,0],2,2,wf6(:,8),wf6(:,35))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,8),G0H6(18),m3h6x6(:,52),heltab2x36(:,:,1511))
  call Hloop_Q_A(ntryL,G0H6(18),18,0,G1H6(40),n2h6(172))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(98),G1H4(21),G1H4(22),G1H4(45),G1H4(51) &
    ,G1H4(57),G0H4(101),G0H4(92),G0H4(45),G0H4(48),G0H4(23),G0H4(58),G0H4(8),G0H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(99),G1H4(26),G1H4(23),G1H4(15),G1H4(44) &
    ,G1H4(50),G0H4(102),G0H4(93),G0H4(46),G0H4(49),G0H4(19),G0H4(54),G0H4(35),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(105),G1H4(7),G1H4(35),G1H4(55),G0H4(95) &
    ,G0H4(86),G0H4(16),G0H4(32),G0H4(22),G0H4(6),G0H4(67),G0H4(70),G0H4(36),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(106),G1H4(11),G1H4(36),G1H4(53),G0H4(9) &
    ,G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(111),G1H4(2),G1H4(72),G1H4(61),G0H4(99) &
    ,G0H4(90),G0H4(57),G0H4(42),G0H4(69),G0H4(60),G0H4(51),G0H4(66),G0H4(37),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(112),G1H4(3),G1H4(73),G1H4(54),G0H4(100) &
    ,G0H4(91),G0H4(53),G0H4(43),G0H4(65),G0H4(56),G0H4(25),G0H4(62),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(8),[G1H3(50),G1H3(140),G1H3(134),G1H3(18),G1H3(141) &
    ,G0H3(11),G0H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(180),[G1H3(44),G1H3(243),G1H3(3),G1H3(207),G1H3(233) &
    ,G0H3(10),G0H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(76),[G0H3(53),G0H3(30),G0H3(48),G0H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(73),[G0H3(74),G0H3(77),G0H3(32),G0H3(34),G0H3(51) &
    ,G0H3(70),G0H3(72),G0H3(71),G0H3(27),G0H3(46),G0H3(49),G0H3(45),G0H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(68),[G0H3(29),G0H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(65),[G0H3(26),G0H3(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(8),[G0H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(16),[G0H1(15),G0H1(9),G0H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(40),[G0H1(34),G0H1(28),G0H1(23),G0H1(18),G0H1(10) &
    ,G0H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(41),[G0H1(35),G0H1(29),G0H1(24),G0H1(19),G0H1(11) &
    ,G0H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(42),[G0H1(39),G0H1(36),G0H1(33),G0H1(30),G0H1(25) &
    ,G0H1(20),G0H1(17),G0H1(12),G0H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(31),[G0H1(26),G0H1(13),G0H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(44),[G0H1(43),G0H1(38),G0H1(37),G0H1(32),G0H1(27) &
    ,G0H1(22),G0H1(21),G0H1(14),G0H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(100),G1H4(28),G1H4(24),G1H4(16),G1H4(66) &
    ,G1H4(43),G0H4(103),G0H4(94),G0H4(47),G0H4(14),G0H4(11),G0H4(50),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G0H12(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G0H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G0H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G0H4(27),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G0H4(44),G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G0H4(71),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G0H4(77),G0H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G0H4(81),G0H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G0H4(82),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(210),[G1H3(159),G0H3(23),G0H3(42),G0H3(36),G0H3(38) &
    ,G0H3(39),G0H3(54),G0H3(57),G0H3(58),G0H3(31),G0H3(33),G0H3(52),G0H3(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(35),[G0H3(55),G0H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(113),G1H4(102),G1H4(96),G1H4(30),G1H4(19) &
    ,G1H4(32),G1H4(47),G1H4(67),G1H4(59),G1H4(65),G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(114),G1H4(104),G1H4(97),G1H4(6),G1H4(20) &
    ,G1H4(34),G1H4(40),G1H4(60),G1H4(52),G1H4(58),G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(108),G1H4(13),G1H4(38),G1H4(46),G0H4(96) &
    ,G0H4(87),G0H4(52),G0H4(33),G0H4(18),G0H4(72),G0H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(109),G1H4(17),G1H4(70),G1H4(41),G0H4(97) &
    ,G0H4(88),G0H4(26),G0H4(34),G0H4(10),G0H4(68),G0H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(110),G1H4(1),G1H4(71),G1H4(39),G0H4(98) &
    ,G0H4(89),G0H4(61),G0H4(41),G0H4(73),G0H4(64),G0H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(132),[G0H12(17),G0H12(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(133),[G0H12(60),G0H12(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(134),[G0H12(61),G0H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(146),[G0H12(99),G0H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(147),[G0H12(100),G0H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(148),[G0H12(105),G0H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(85),[G1H3(239),G1H3(215),G1H3(113),G1H3(197),G1H3(246) &
    ,G1H3(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(104),[G1H3(79),G1H3(229),G1H3(212),G1H3(187),G1H3(248) &
    ,G1H3(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(45),[G1H3(23),G1H3(234),G1H3(230),G1H3(225),G1H3(198) &
    ,G1H3(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(13),G1H3(154),G1H3(29),G1H3(155),G1H3(153) &
    ,G1H3(150),G1H3(148),G1H3(137),G1H3(51),G1H3(123),G1H3(241),G0H3(61),G0H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(249),[G1H3(216),G0H3(44),G0H3(59),G0H3(62),G0H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(228),[G1H3(58),G1H3(208),G1H3(161),G1H3(238),G1H3(182) &
    ,G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(232),[G1H3(52),G1H3(122),G1H3(222),G1H3(99),G1H3(56) &
    ,G1H3(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(108),[G1H3(36),G1H3(171),G1H3(139),G1H3(1),G1H3(48) &
    ,G1H3(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(106),[G1H3(116),G1H3(236),G1H3(126),G1H3(146),G1H3(158) &
    ,G1H3(14),G1H3(28),G1H3(142),G1H3(32),G1H3(111),G1H3(87),G0H3(9),G0H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(195),[G1H3(242),G0H3(13),G0H3(75),G0H3(56),G0H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(244),[G1H3(20),G1H3(124),G1H3(156),G1H3(62),G1H3(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(240),[G1H3(9),G1H3(129),G1H3(221),G1H3(178),G1H3(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(91),[G1H3(76),G1H3(39),G1H3(71),G1H3(64),G1H3(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(224),[G1H3(203),G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(118),G1H4(103),G1H4(101),G1H4(31),G1H4(29) &
    ,G1H4(33),G1H4(25),G1H4(62),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(107),G1H4(12),G1H4(37),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(33),[G1H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(34),[G1H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(35),[G0H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(38),[G0H12(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(39),[G0H12(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(40),[G0H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G0H12(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(16),[G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G0H12(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(19),[G0H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(44),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(47),[G1H12(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(48),[G0H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(52),[G0H12(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(53),[G0H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(127),[G0H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(128),[G0H12(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(129),[G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(25),[G0H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(26),[G0H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(32),[G0H12(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(45),[G1H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G0H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G0H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G0H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G0H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G0H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G0H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G0H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G0H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(136),[G1H12(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(138),[G1H12(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(139),[G0H12(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(205),[G0H12(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(141),[G0H12(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(232),[G0H12(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(142),[G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(143),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(137),[G1H12(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(17),[G1H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(150),[G1H12(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(152),[G1H12(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(153),[G0H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(156),[G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(157),[G0H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(158),[G0H12(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(59),[G0H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(159),[G0H12(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(151),[G1H12(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(7),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(16),[G1H3(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(17),[G0H3(2),G0H3(43),G0H3(4),G0H3(5),G0H3(1),G0H3(15) &
    ,G0H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(41),[G0H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(226),[G1H3(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(78),[G0H3(16),G0H3(8),G0H3(47),G0H3(6),G0H3(3),G0H3(12) &
    ,G0H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(14),[G0H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(40),[G1H6(18)])
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(47),wf4(:,1),wf3(:,7),G0tensor(30),m4h4x3x1(:,3),heltab3x12(:,:,16))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(48),wf4(:,1),wf3(:,7),G0tensor(60),m4h4x3x1(:,4),heltab3x12(:,:,17))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(29),wf4(:,1),wf3(:,1),G1tensor(251),m4h4x3x1(:,5),heltab3x12(:,:,18))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(4),wf4(:,1),wf3(:,1),G1tensor(256),m4h4x3x1(:,6),heltab3x12(:,:,19))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(120),wf4(:,1),wf3(:,1),G1tensor(261),m4h4x3x1(:,7),heltab3x12(:,:,20))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(6),wf4(:,1),wf3(:,1),G1tensor(266),m4h4x3x1(:,8),heltab3x12(:,:,21))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(115),wf4(:,1),G1tensor(271),m3h4x1(:,39),heltab2x4(:,:,62))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(116),wf4(:,1),G1tensor(276),m3h4x1(:,40),heltab2x4(:,:,63))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(122),28,wf4(:,1),3,G2tensor(330),m3h4x1(:,41),heltab2x4(:,:,64))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(123),28,wf4(:,1),3,G2tensor(128),m3h4x1(:,42),heltab2x4(:,:,65))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(128),28,wf4(:,1),3,G2tensor(342),m3h4x1(:,43),heltab2x4(:,:,66))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(129),28,wf4(:,1),3,G2tensor(129),m3h4x1(:,44),heltab2x4(:,:,67))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(8),19,wf3(:,1),12,G2tensor(148),m3h3x1(:,530),heltab2x3(:,:,661))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(180),19,wf3(:,1),12,G2tensor(130),m3h3x1(:,531),heltab2x3(:,:,662))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(76),ex4(:),G0tensor(85),m3h3x1(:,532),heltab2x3(:,:,663))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(73),ex4(:),G0tensor(115),m3h3x1(:,533),heltab2x3(:,:,664))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H3(68),23,ex4(:),8,G1tensor(281),m3h3x1(:,534),heltab2x3(:,:,665))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(65),23,ex4(:),8,G1tensor(286),m3h3x1(:,535),heltab2x3(:,:,666))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H1(8),27,ex3(:),4,G1tensor(291),m3h1x1(:,253),heltab2x1(:,:,253))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H1(16),27,ex3(:),4,G1tensor(296),m3h1x1(:,254),heltab2x1(:,:,254))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(40),ex3(:),G0tensor(140),m3h1x1(:,255),heltab2x1(:,:,255))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(41),ex3(:),G0tensor(170),m3h1x1(:,256),heltab2x1(:,:,256))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(42),ex3(:),G0tensor(195),m3h1x1(:,257),heltab2x1(:,:,257))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H1(31),ex3(:),G0tensor(225),m3h1x1(:,258),heltab2x1(:,:,258))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H1(44),ex3(:),G0tensor(255),m3h1x1(:,259),heltab2x1(:,:,259))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(117),wf4(:,1),G1tensor(301),m3h4x1(:,45),heltab2x4(:,:,68))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(3),ex4(:),wf4(:,1),G1tensor(306),m4h3x4x1(:,6),heltab3x12(:,:,22))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(12),wf4(:,1),ex4(:),G1tensor(311),m4h4x3x1(:,9),heltab3x12(:,:,23))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(9),wf4(:,1),ex4(:),G1tensor(316),m4h4x3x1(:,10),heltab3x12(:,:,24))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(10),ex4(:),wf4(:,1),G1tensor(321),m4h3x4x1(:,7),heltab3x12(:,:,25))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(52),ex4(:),wf4(:,2),G0tensor(290),m4h3x4x1(:,8),heltab3x12(:,:,26))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(53),ex4(:),wf4(:,2),G0tensor(325),m4h3x4x1(:,9),heltab3x12(:,:,27))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(54),ex4(:),wf4(:,2),G0tensor(355),m4h3x4x1(:,10),heltab3x12(:,:,28))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(108),ex4(:),wf4(:,3),G1tensor(326),m4h3x4x1(:,11),heltab3x12(:,:,29))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(1),ex4(:),wf4(:,3),G1tensor(331),m4h3x4x1(:,12),heltab3x12(:,:,30))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(7),wf4(:,3),ex4(:),G1tensor(336),m4h4x3x1(:,11),heltab3x12(:,:,31))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(23),wf4(:,3),ex4(:),G1tensor(341),m4h4x3x1(:,12),heltab3x12(:,:,32))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(14),wf4(:,2),G1tensor(346),m3h4x1(:,46),heltab2x4(:,:,69))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(77),wf4(:,2),G1tensor(351),m3h4x1(:,47),heltab2x4(:,:,70))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(78),wf4(:,2),G1tensor(356),m3h4x1(:,48),heltab2x4(:,:,71))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(88),24,wf4(:,3),7,G2tensor(132),m3h4x1(:,49),heltab2x4(:,:,72))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(89),24,wf4(:,3),7,G2tensor(133),m3h4x1(:,50),heltab2x4(:,:,73))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(94),24,wf4(:,3),7,G2tensor(150),m3h4x1(:,51),heltab2x4(:,:,74))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(95),24,wf4(:,3),7,G2tensor(134),m3h4x1(:,52),heltab2x4(:,:,75))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H4(63),wf4(:,1),ex3(:),G1tensor(361),m4h4x1x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H4(56),wf4(:,1),ex3(:),G1tensor(366),m4h4x1x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H4(49),wf4(:,1),ex3(:),G1tensor(371),m4h4x1x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_SSS_S(ntryL,l_switch,G1H12(98),ex3(:),wf12(:,2),G1tensor(376),m4h1x12x1(:,1),heltab3x12(:,:,33))
  call Hcheck_last_VSS_V(ntryL,l_switch,G1H12(116),ex3(:),wf12(:,2),G1tensor(381),m4h1x12x1(:,2),heltab3x12(:,:,34))
  call Hcheck_last_VSS_V(ntryL,l_switch,G1H12(117),ex3(:),wf12(:,2),G1tensor(386),m4h1x12x1(:,3),heltab3x12(:,:,35))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(55),wf12(:,3),ex3(:),G0tensor(380),m4h12x1x1(:,1),heltab3x12(:,:,36))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(88),wf12(:,3),ex3(:),G0tensor(410),m4h12x1x1(:,2),heltab3x12(:,:,37))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(89),wf12(:,3),ex3(:),G0tensor(440),m4h12x1x1(:,3),heltab3x12(:,:,38))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H12(90),20,wf12(:,2),11,G1tensor(391),m3h12x1(:,84),heltab2x12(:,:,701))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H12(91),20,wf12(:,2),11,G1tensor(396),m3h12x1(:,85),heltab2x12(:,:,702))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H12(101),20,wf12(:,2),11,G1tensor(401),m3h12x1(:,86),heltab2x12(:,:,703))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(102),wf12(:,3),G0tensor(470),m3h12x1(:,87),heltab2x12(:,:,704))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(103),wf12(:,3),G0tensor(500),m3h12x1(:,88),heltab2x12(:,:,705))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(104),wf12(:,3),G0tensor(5),m3h12x1(:,89),heltab2x12(:,:,706))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(210),ex4(:),ex3(:),G1tensor(406),m4h3x1x1(:,11),heltab3x3(:,:,15))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H3(35),ex4(:),ex3(:),G0tensor(510),m4h3x1x1(:,12),heltab3x3(:,:,16))
  call Hloop_QW_A(ntryL,G1H4(119),wf4(:,1),G1H1(92),m3h4x1(:,53),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(92),31,nML,G2tensor(46),n2h1(253))
  call Hloop_QW_A(ntryL,G1H4(121),wf4(:,1),G1H1(71),m3h4x1(:,54),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(71),31,nMB,G2tensor(151),n2h1(254))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(125),28,wf4(:,1),3,G2tensor(136),m3h4x1(:,55),heltab2x4(:,:,78))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(126),28,wf4(:,1),G2tensor(138),m3h4x1(:,56),heltab2x4(:,:,79))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(127),28,wf4(:,1),G2tensor(191),m3h4x1(:,57),heltab2x4(:,:,80))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(4),wf12(:,4),ex3(:),G0tensor(535),m4h12x1x1(:,4),heltab3x12(:,:,39))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(80),wf12(:,4),ex3(:),G0tensor(565),m4h12x1x1(:,5),heltab3x12(:,:,40))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(7),wf12(:,4),ex3(:),G0tensor(595),m4h12x1x1(:,6),heltab3x12(:,:,41))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(132),wf12(:,4),G1tensor(411),m3h12x1(:,90),heltab2x12(:,:,707))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(133),wf12(:,4),G1tensor(416),m3h12x1(:,91),heltab2x12(:,:,708))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(134),wf12(:,4),G1tensor(421),m3h12x1(:,92),heltab2x12(:,:,709))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(79),wf12(:,5),ex3(:),G0tensor(497),m4h12x1x1(:,7),heltab3x12(:,:,42))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(14),wf12(:,5),ex3(:),G0tensor(144),m4h12x1x1(:,8),heltab3x12(:,:,43))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(15),wf12(:,5),ex3(:),G0tensor(239),m4h12x1x1(:,9),heltab3x12(:,:,44))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(146),wf12(:,5),G1tensor(426),m3h12x1(:,93),heltab2x12(:,:,710))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(147),wf12(:,5),G1tensor(431),m3h12x1(:,94),heltab2x12(:,:,711))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(148),wf12(:,5),G1tensor(436),m3h12x1(:,95),heltab2x12(:,:,712))
  call Hloop_QS_A(ntryL,G1H3(85),wf3(:,7),G1H1(72),ngX,m3h3x1(:,536),heltab2x3(:,:,667))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,nML,G2tensor(152),n2h1(255))
  call Hloop_QS_A(ntryL,G1H3(104),wf3(:,7),G1H1(2),ngX,m3h3x1(:,537),heltab2x3(:,:,668))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMT,G2tensor(139),n2h1(256))
  call Hloop_QS_A(ntryL,G1H3(45),wf3(:,7),G1H1(13),ngX,m3h3x1(:,538),heltab2x3(:,:,669))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(25),n2h1(257))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H3(35),wf3(:,7),G1tensor(441),m3h3x1(:,539),heltab2x3(:,:,670))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H3(249),19,wf3(:,7),12,G2tensor(153),m3h3x1(:,540),heltab2x3(:,:,671))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H3(7),wf3(:,7),G1tensor(446),m3h3x1(:,541),heltab2x3(:,:,672))
  call Hcheck_last_TS_V(ntryL,l_switch,G0H3(60),19,wf3(:,7),12,G1tensor(451),m3h3x1(:,542),heltab2x3(:,:,673))
  call Hloop_QZ_A(ntryL,G1H3(228),wf3(:,1),G1H1(54),ngZl,m3h3x1(:,543),heltab2x3(:,:,674))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),31,nML,G2tensor(140),n2h1(258))
  call Hloop_QZ_A(ntryL,G1H3(232),wf3(:,1),G1H1(64),ngZu,m3h3x1(:,544),heltab2x3(:,:,675))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nMT,G2tensor(141),n2h1(259))
  call Hloop_QZ_A(ntryL,G1H3(108),wf3(:,1),G1H1(14),ngZd,m3h3x1(:,545),heltab2x3(:,:,676))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(97),n2h1(260))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(106),19,wf3(:,1),12,G2tensor(106),m3h3x1(:,546),heltab2x3(:,:,677))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(195),wf3(:,1),G1tensor(456),m3h3x1(:,547),heltab2x3(:,:,678))
  call Hloop_QZ_A(ntryL,G1H3(244),wf3(:,1),G1H1(15),ngZl,m3h3x1(:,548),heltab2x3(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),31,0,G2tensor(115),n2h1(261))
  call Hloop_QZ_A(ntryL,G1H3(240),wf3(:,1),G1H1(9),ngZu,m3h3x1(:,549),heltab2x3(:,:,680))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,0,G2tensor(119),n2h1(262))
  call Hloop_QZ_A(ntryL,G1H3(91),wf3(:,1),G1H1(10),ngZd,m3h3x1(:,550),heltab2x3(:,:,681))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,0,G2tensor(120),n2h1(263))
  call Hloop_QZ_A(ntryL,G1H3(224),wf3(:,1),G1H1(16),ngZn,m3h3x1(:,551),heltab2x3(:,:,682))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),31,0,G2tensor(121),n2h1(264))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(205),19,wf3(:,1),12,G2tensor(162),m3h3x1(:,552),heltab2x3(:,:,683))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(66),wf3(:,1),G0tensor(78),m3h3x1(:,553),heltab2x3(:,:,684))
  call Hloop_QW_A(ntryL,G1H4(120),wf4(:,1),G1H1(11),m3h4x1(:,58),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),31,0,G2tensor(303),n2h1(265))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(124),28,wf4(:,1),3,G2tensor(300),m3h4x1(:,59),heltab2x4(:,:,82))
  call Hloop_AS_Q(ntryL,G1H12(33),wf12(:,2),G1H1(38),ngPln,m3h12x1(:,96),heltab2x12(:,:,713))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),31,0,G2tensor(306),n2h1(266))
  call Hloop_AS_Q(ntryL,G1H12(34),wf12(:,2),G1H1(17),ngPbt,m3h12x1(:,97),heltab2x12(:,:,714))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,nMT,G2tensor(324),n2h1(267))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(35),wf12(:,2),G1tensor(461),m3h12x1(:,98),heltab2x12(:,:,715))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(38),wf12(:,2),G1tensor(466),m3h12x1(:,99),heltab2x12(:,:,716))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(39),wf12(:,2),G1tensor(471),m3h12x1(:,100),heltab2x12(:,:,717))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(40),wf12(:,2),G1tensor(476),m3h12x1(:,101),heltab2x12(:,:,718))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(42),wf12(:,2),G1tensor(481),m3h12x1(:,102),heltab2x12(:,:,719))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H12(16),20,wf12(:,2),11,G2tensor(327),m3h12x1(:,103),heltab2x12(:,:,720))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H12(18),20,wf12(:,2),11,G2tensor(333),m3h12x1(:,104),heltab2x12(:,:,721))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H12(19),20,wf12(:,2),11,G2tensor(175),m3h12x1(:,105),heltab2x12(:,:,722))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H12(20),20,wf12(:,2),11,G2tensor(176),m3h12x1(:,106),heltab2x12(:,:,723))
  call Hloop_AW_Q(ntryL,G1H12(44),wf12(:,3),G1H1(30),m3h12x1(:,107),heltab2x12(:,:,724))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,0,G2tensor(179),n2h1(268))
  call Hloop_AW_Q(ntryL,G1H12(47),wf12(:,3),G1H1(37),m3h12x1(:,108),heltab2x12(:,:,725))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,nMT,G2tensor(180),n2h1(269))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(48),20,wf12(:,3),11,G2tensor(188),m3h12x1(:,109),heltab2x12(:,:,726))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(52),20,wf12(:,3),G2tensor(189),m3h12x1(:,110),heltab2x12(:,:,727))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(53),20,wf12(:,3),11,G2tensor(201),m3h12x1(:,111),heltab2x12(:,:,728))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(127),20,wf12(:,3),11,G2tensor(202),m3h12x1(:,112),heltab2x12(:,:,729))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(128),20,wf12(:,3),11,G2tensor(203),m3h12x1(:,113),heltab2x12(:,:,730))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(129),20,wf12(:,3),11,G2tensor(217),m3h12x1(:,114),heltab2x12(:,:,731))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H12(25),wf12(:,3),G1tensor(486),m3h12x1(:,115),heltab2x12(:,:,732))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H12(26),wf12(:,3),G1tensor(491),m3h12x1(:,116),heltab2x12(:,:,733))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H12(32),wf12(:,3),G1tensor(496),m3h12x1(:,117),heltab2x12(:,:,734))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(37),wf12(:,2),G1tensor(501),m3h12x1(:,118),heltab2x12(:,:,735))
  call Hloop_AW_Q(ntryL,G1H12(45),wf12(:,3),G1H1(69),m3h12x1(:,119),heltab2x12(:,:,736))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(69),31,0,G2tensor(218),n2h1(270))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(49),20,wf12(:,3),11,G2tensor(219),m3h12x1(:,120),heltab2x12(:,:,737))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(50),20,wf12(:,3),G2tensor(223),m3h12x1(:,121),heltab2x12(:,:,738))
  call Hloop_QS_A(ntryL,G1H4(9),wf4(:,2),G1H1(8),ngPln,m3h4x1(:,60),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nML,G2tensor(224),n2h1(271))
  call Hloop_QS_A(ntryL,G1H4(10),wf4(:,2),G1H1(1),ngPbt,m3h4x1(:,61),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(225),n2h1(272))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(75),wf4(:,2),G1tensor(542),m3h4x1(:,62),heltab2x4(:,:,85))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(76),wf4(:,2),G1tensor(547),m3h4x1(:,63),heltab2x4(:,:,86))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(27),24,wf4(:,2),7,G2tensor(230),m3h4x1(:,64),heltab2x4(:,:,87))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(69),24,wf4(:,2),7,G2tensor(232),m3h4x1(:,65),heltab2x4(:,:,88))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(68),24,wf4(:,2),7,G2tensor(234),m3h4x1(:,66),heltab2x4(:,:,89))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(8),24,wf4(:,2),7,G2tensor(236),m3h4x1(:,67),heltab2x4(:,:,90))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(74),wf4(:,2),G1tensor(552),m3h4x1(:,68),heltab2x4(:,:,91))
  call Hloop_QW_A(ntryL,G1H4(85),wf4(:,3),G1H1(48),m3h4x1(:,69),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(48),31,nML,G2tensor(238),n2h1(273))
  call Hloop_QW_A(ntryL,G1H4(87),wf4(:,3),G1H1(32),m3h4x1(:,70),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(345),n2h1(274))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(91),24,wf4(:,3),7,G2tensor(348),m3h4x1(:,71),heltab2x4(:,:,94))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(92),24,wf4(:,3),G2tensor(357),m3h4x1(:,72),heltab2x4(:,:,95))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(93),24,wf4(:,3),G2tensor(360),m3h4x1(:,73),heltab2x4(:,:,96))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(81),wf4(:,3),G1tensor(557),m3h4x1(:,74),heltab2x4(:,:,97))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(82),wf4(:,3),G1tensor(562),m3h4x1(:,75),heltab2x4(:,:,98))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(83),wf4(:,3),G1tensor(567),m3h4x1(:,76),heltab2x4(:,:,99))
  call Hloop_QW_A(ntryL,G1H4(86),wf4(:,3),G1H1(59),m3h4x1(:,77),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),31,0,G2tensor(369),n2h1(275))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(90),24,wf4(:,3),7,G2tensor(372),m3h4x1(:,78),heltab2x4(:,:,101))
  call Hloop_QW_A(ntryL,G1H12(136),wf12(:,4),G1H1(52),m3h12x1(:,122),heltab2x12(:,:,739))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(52),31,nML,G2tensor(375),n2h1(276))
  call Hloop_QW_A(ntryL,G1H12(138),wf12(:,4),G1H1(82),m3h12x1(:,123),heltab2x12(:,:,740))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(82),31,nMB,G2tensor(378),n2h1(277))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(139),20,wf12(:,4),11,G2tensor(387),m3h12x1(:,124),heltab2x12(:,:,741))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(205),20,wf12(:,4),11,G2tensor(390),m3h12x1(:,125),heltab2x12(:,:,742))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(141),20,wf12(:,4),G2tensor(393),m3h12x1(:,126),heltab2x12(:,:,743))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(232),20,wf12(:,4),G2tensor(396),m3h12x1(:,127),heltab2x12(:,:,744))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(142),20,wf12(:,4),11,G2tensor(399),m3h12x1(:,128),heltab2x12(:,:,745))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(143),20,wf12(:,4),11,G2tensor(402),m3h12x1(:,129),heltab2x12(:,:,746))
  call Hloop_QW_A(ntryL,G1H12(137),wf12(:,4),G1H1(86),m3h12x1(:,130),heltab2x12(:,:,747))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(86),31,0,G2tensor(405),n2h1(278))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(178),20,wf12(:,4),11,G2tensor(408),m3h12x1(:,131),heltab2x12(:,:,748))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(140),20,wf12(:,4),11,G2tensor(411),m3h12x1(:,132),heltab2x12(:,:,749))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(17),wf6(:,2),G1tensor(572),m3h6x1(:,47),heltab2x6(:,:,264))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H6(23),wf6(:,2),G1tensor(577),ngZu,m3h6x1(:,48),heltab2x6(:,:,265))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H6(24),wf6(:,2),G1tensor(582),m3h6x1(:,49),heltab2x6(:,:,266))
  call Hloop_QW_A(ntryL,G1H12(150),wf12(:,5),G1H1(90),m3h12x1(:,133),heltab2x12(:,:,750))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(90),31,nML,G2tensor(192),n2h1(279))
  call Hloop_QW_A(ntryL,G1H12(152),wf12(:,5),G1H1(65),m3h12x1(:,134),heltab2x12(:,:,751))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),31,nMB,G2tensor(260),n2h1(280))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(153),20,wf12(:,5),11,G2tensor(194),m3h12x1(:,135),heltab2x12(:,:,752))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(156),20,wf12(:,5),11,G2tensor(263),m3h12x1(:,136),heltab2x12(:,:,753))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(157),20,wf12(:,5),G2tensor(196),m3h12x1(:,137),heltab2x12(:,:,754))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(158),20,wf12(:,5),G2tensor(15),m3h12x1(:,138),heltab2x12(:,:,755))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(59),20,wf12(:,5),11,G2tensor(1),m3h12x1(:,139),heltab2x12(:,:,756))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(159),20,wf12(:,5),11,G2tensor(52),m3h12x1(:,140),heltab2x12(:,:,757))
  call Hloop_QW_A(ntryL,G1H12(151),wf12(:,5),G1H1(66),m3h12x1(:,141),heltab2x12(:,:,758))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),31,0,G2tensor(166),n2h1(281))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(154),20,wf12(:,5),11,G2tensor(320),m3h12x1(:,142),heltab2x12(:,:,759))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(155),20,wf12(:,5),11,G2tensor(314),m3h12x1(:,143),heltab2x12(:,:,760))
  call Hloop_VQ_A(ntryL,G0H6(7),wf6(:,4),G0H1(2),m3h6x1(:,50),heltab2x6(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(2),31,0,G1tensor(587),n2h1(282))
  call Hloop_ZQ_A(ntryL,G0H6(8),wf6(:,4),G0H1(15),ngZd,m3h6x1(:,51),heltab2x6(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(15),31,0,G1tensor(592),n2h1(283))
  call Hloop_WQ_A(ntryL,G0H6(6),wf6(:,4),G0H1(9),m3h6x1(:,52),heltab2x6(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(9),31,0,G1tensor(597),n2h1(284))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H3(16),wf3(:,7),G1tensor(602),m3h3x1(:,554),heltab2x3(:,:,685))
  call Hcheck_last_VT_S(ntryL,l_switch,G0H3(17),19,wf3(:,7),12,G1tensor(607),m3h3x1(:,555),heltab2x3(:,:,686))
  call Hcheck_last_VS_T(ntryL,l_switch,G0H3(41),19,wf3(:,7),12,G1tensor(612),m3h3x1(:,556),heltab2x3(:,:,687))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(226),19,wf3(:,1),12,G2tensor(290),m3h3x1(:,557),heltab2x3(:,:,688))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H3(78),wf3(:,1),G0tensor(604),m3h3x1(:,558),heltab2x3(:,:,689))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H3(14),wf3(:,1),G0tensor(98),m3h3x1(:,559),heltab2x3(:,:,690))
  call Hloop_VQ_A(ntryL,G0H6(16),wf6(:,31),G0H1(1),m3h6x1(:,53),heltab2x6(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(617),n2h1(285))
  call Hloop_ZQ_A(ntryL,G0H6(10),wf6(:,31),G0H1(34),ngZd,m3h6x1(:,54),heltab2x6(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(34),31,0,G1tensor(622),n2h1(286))
  call Hloop_WQ_A(ntryL,G0H6(11),wf6(:,31),G0H1(28),m3h6x1(:,55),heltab2x6(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(28),31,0,G1tensor(627),n2h1(287))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(40),wf6(:,35),G1tensor(632),m3h6x1(:,56),heltab2x6(:,:,273))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H6(20),wf6(:,35),G1tensor(637),ngZu,m3h6x1(:,57),heltab2x6(:,:,274))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H6(38),wf6(:,35),G1tensor(642),m3h6x1(:,58),heltab2x6(:,:,275))
  call ol_merge_tensors(G0tensor(939),[G0tensor(804),G0tensor(800),G0tensor(779),G0tensor(643),G0tensor(317),G0tensor(437) &
    ,G0tensor(369),G0tensor(600),G0tensor(570),G0tensor(515),G0tensor(35)])
  call ol_merge_tensors(G0tensor(1105),[G0tensor(1073),G0tensor(478),G0tensor(40)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(217),G2tensor(202),G2tensor(189),G2tensor(176),G1tensor(481),G1tensor(471) &
    ,G1tensor(466),G1tensor(431),G1tensor(416),G1tensor(396),G1tensor(321),G1tensor(316),G0tensor(500),G0tensor(1064) &
    ,G0tensor(483),G0tensor(442),G0tensor(443),G0tensor(211),G0tensor(450),G0tensor(45)])
  call ol_merge_tensors(G0tensor(1107),[G0tensor(1096),G0tensor(1086),G0tensor(1081),G0tensor(1076),G0tensor(1071),G0tensor(1065) &
    ,G0tensor(1060),G0tensor(1055),G0tensor(1048),G0tensor(1043),G0tensor(1036),G0tensor(1021),G0tensor(1005),G0tensor(999) &
    ,G0tensor(994),G0tensor(989),G0tensor(984),G0tensor(979),G0tensor(963),G0tensor(958),G0tensor(953),G0tensor(948),G0tensor(937) &
    ,G0tensor(931),G0tensor(919),G0tensor(913),G0tensor(907),G0tensor(890),G0tensor(885),G0tensor(880),G0tensor(863),G0tensor(858) &
    ,G0tensor(853),G0tensor(847),G0tensor(825),G0tensor(819),G0tensor(699),G0tensor(676),G0tensor(671),G0tensor(666),G0tensor(660) &
    ,G0tensor(588),G0tensor(558),G0tensor(543),G0tensor(522),G0tensor(494),G0tensor(463),G0tensor(448),G0tensor(438),G0tensor(397) &
    ,G0tensor(393),G0tensor(303),G0tensor(262),G0tensor(243),G0tensor(252),G0tensor(222),G0tensor(411),G0tensor(366),G0tensor(264) &
    ,G0tensor(137),G0tensor(41),G0tensor(374),G0tensor(567),G0tensor(354),G0tensor(344),G0tensor(21),G0tensor(152),G0tensor(616) &
    ,G0tensor(591),G0tensor(201),G0tensor(574),G0tensor(179),G0tensor(123),G0tensor(139),G0tensor(27),G0tensor(104),G0tensor(111) &
    ,G0tensor(59),G0tensor(54),G0tensor(609),G0tensor(584),G0tensor(224),G0tensor(585),G0tensor(560),G0tensor(4),G0tensor(460) &
    ,G0tensor(310),G0tensor(285),G0tensor(165),G0tensor(110),G0tensor(50)])
  call ol_merge_tensors(G0tensor(1128),[G0tensor(1123),G0tensor(1118),G0tensor(1113),G0tensor(1108),G0tensor(1102),G0tensor(1097) &
    ,G0tensor(1091),G0tensor(1066),G0tensor(1049),G0tensor(1037),G0tensor(1031),G0tensor(1026),G0tensor(1015),G0tensor(1010) &
    ,G0tensor(978),G0tensor(973),G0tensor(968),G0tensor(943),G0tensor(930),G0tensor(925),G0tensor(912),G0tensor(906),G0tensor(901) &
    ,G0tensor(896),G0tensor(891),G0tensor(879),G0tensor(874),G0tensor(869),G0tensor(864),G0tensor(852),G0tensor(842),G0tensor(836) &
    ,G0tensor(830),G0tensor(824),G0tensor(814),G0tensor(808),G0tensor(802),G0tensor(797),G0tensor(792),G0tensor(782),G0tensor(686) &
    ,G0tensor(677),G0tensor(665),G0tensor(655),G0tensor(646),G0tensor(641),G0tensor(636),G0tensor(627),G0tensor(622),G0tensor(613) &
    ,G0tensor(592),G0tensor(528),G0tensor(518),G0tensor(484),G0tensor(453),G0tensor(428),G0tensor(383),G0tensor(398),G0tensor(361) &
    ,G0tensor(351),G0tensor(312),G0tensor(298),G0tensor(403),G0tensor(248),G0tensor(368),G0tensor(452),G0tensor(323),G0tensor(208) &
    ,G0tensor(263),G0tensor(202),G0tensor(401),G0tensor(174),G0tensor(376),G0tensor(142),G0tensor(122),G0tensor(112),G0tensor(379) &
    ,G0tensor(38),G0tensor(161),G0tensor(32),G0tensor(416),G0tensor(11),G0tensor(429),G0tensor(556),G0tensor(536),G0tensor(474) &
    ,G0tensor(461),G0tensor(118),G0tensor(103),G0tensor(88),G0tensor(276),G0tensor(124),G0tensor(119),G0tensor(241),G0tensor(116) &
    ,G0tensor(492),G0tensor(79),G0tensor(74),G0tensor(29),G0tensor(479),G0tensor(454),G0tensor(133),G0tensor(599),G0tensor(249) &
    ,G0tensor(17),G0tensor(184),G0tensor(615),G0tensor(590),G0tensor(555),G0tensor(530),G0tensor(9),G0tensor(3),G0tensor(495) &
    ,G0tensor(465),G0tensor(345),G0tensor(315),G0tensor(280),G0tensor(160),G0tensor(135),G0tensor(105),G0tensor(80) &
    ,G0tensor(55)])
  call ol_merge_tensors(G0tensor(629),[G0tensor(153),G0tensor(22),G0tensor(297),G0tensor(254),G0tensor(244),G0tensor(24) &
    ,G0tensor(619),G0tensor(6),G0tensor(65)])
  call ol_merge_tensors(G0tensor(1028),[G0tensor(822),G0tensor(343),G0tensor(217),G0tensor(95),G0tensor(70)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(1),G2tensor(196),G2tensor(411),G2tensor(399),G2tensor(393),G2tensor(327) &
    ,G1tensor(486),G0tensor(972),G0tensor(356),G0tensor(223),G0tensor(271),G0tensor(199),G0tensor(75)])
  call ol_merge_tensors(G0tensor(946),[G0tensor(817),G0tensor(657),G0tensor(157),G0tensor(612),G0tensor(524),G0tensor(514) &
    ,G0tensor(540),G0tensor(90)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(52),G2tensor(15),G2tensor(263),G2tensor(408),G2tensor(402),G2tensor(396) &
    ,G2tensor(390),G2tensor(333),G1tensor(491),G0tensor(977),G0tensor(362),G0tensor(232),G0tensor(76),G0tensor(469),G0tensor(1) &
    ,G0tensor(100)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(138),G2tensor(342),G0tensor(121),G0tensor(61),G0tensor(489),G0tensor(286) &
    ,G0tensor(120)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(153),G2tensor(130),G2tensor(148),G1tensor(607),G1tensor(456),G1tensor(441) &
    ,G1tensor(406),G0tensor(604),G0tensor(332),G0tensor(268),G0tensor(173),G0tensor(371),G0tensor(335),G0tensor(150) &
    ,G0tensor(125)])
  call ol_merge_tensors(G0tensor(497),[G0tensor(535),G0tensor(380),G0tensor(290),G0tensor(30),G0tensor(900),G0tensor(873) &
    ,G0tensor(640),G0tensor(487),G0tensor(306),G0tensor(296),G0tensor(8),G0tensor(130)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(136),G2tensor(129),G2tensor(128),G0tensor(136),G0tensor(114),G0tensor(49) &
    ,G0tensor(274),G0tensor(63),G0tensor(145)])
  call ol_merge_tensors(G0tensor(144),[G0tensor(565),G0tensor(410),G0tensor(325),G0tensor(60),G0tensor(905),G0tensor(878) &
    ,G0tensor(851),G0tensor(823),G0tensor(664),G0tensor(458),G0tensor(333),G0tensor(13),G0tensor(550),G0tensor(2),G0tensor(155)])
  call ol_merge_tensors(G2tensor(46),[G0tensor(422),G0tensor(531),G0tensor(175)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(152),G0tensor(739),G0tensor(707),G0tensor(180)])
  call ol_merge_tensors(G0tensor(744),[G0tensor(712),G0tensor(185)])
  call ol_merge_tensors(G0tensor(787),[G0tensor(777),G0tensor(772),G0tensor(745),G0tensor(740),G0tensor(713),G0tensor(708) &
    ,G0tensor(102),G0tensor(56),G0tensor(46),G0tensor(375),G0tensor(190)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(58),G0tensor(47),G0tensor(200)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(139),G0tensor(749),G0tensor(717),G0tensor(205)])
  call ol_merge_tensors(G0tensor(754),[G0tensor(722),G0tensor(425),G0tensor(210)])
  call ol_merge_tensors(G0tensor(767),[G0tensor(755),G0tensor(750),G0tensor(735),G0tensor(723),G0tensor(718),G0tensor(99) &
    ,G0tensor(171),G0tensor(83),G0tensor(67),G0tensor(53),G0tensor(557),G0tensor(430),G0tensor(405),G0tensor(250),G0tensor(215)])
  call ol_merge_tensors(G0tensor(766),[G0tensor(761),G0tensor(756),G0tensor(734),G0tensor(729),G0tensor(724),G0tensor(341) &
    ,G0tensor(176),G0tensor(316),G0tensor(62),G0tensor(409),G0tensor(181),G0tensor(435),G0tensor(400),G0tensor(245) &
    ,G0tensor(220)])
  call ol_merge_tensors(G2tensor(151),[G0tensor(352),G0tensor(269),G0tensor(404),G0tensor(230)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(25),G0tensor(760),G0tensor(728),G0tensor(235)])
  call ol_merge_tensors(G0tensor(765),[G0tensor(733),G0tensor(395),G0tensor(240)])
  call ol_merge_tensors(G1tensor(276),[G0tensor(358),G0tensor(37),G0tensor(31),G0tensor(544),G0tensor(101),G0tensor(260)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(612),G1tensor(602),G0tensor(98),G0tensor(510),G0tensor(934),G0tensor(916) &
    ,G0tensor(547),G0tensor(373),G0tensor(265)])
  call ol_merge_tensors(G1tensor(376),[G1tensor(326),G1tensor(251),G0tensor(239),G0tensor(595),G0tensor(440),G0tensor(355) &
    ,G0tensor(941),G0tensor(923),G0tensor(840),G0tensor(812),G0tensor(516),G0tensor(293),G0tensor(485),G0tensor(270)])
  call ol_merge_tensors(G0tensor(1054),[G0tensor(1042),G0tensor(1020),G0tensor(1004),G0tensor(942),G0tensor(936),G0tensor(924) &
    ,G0tensor(918),G0tensor(841),G0tensor(835),G0tensor(813),G0tensor(807),G0tensor(603),G0tensor(593),G0tensor(577),G0tensor(538) &
    ,G0tensor(532),G0tensor(517),G0tensor(511),G0tensor(391),G0tensor(253),G0tensor(288),G0tensor(554),G0tensor(539),G0tensor(329) &
    ,G0tensor(466),G0tensor(148),G0tensor(236),G0tensor(196),G0tensor(490),G0tensor(350),G0tensor(320),G0tensor(275)])
  call ol_merge_tensors(G0tensor(561),[G0tensor(113),G0tensor(109),G0tensor(295)])
  call ol_merge_tensors(G2tensor(162),[G1tensor(451),G1tensor(446),G0tensor(78),G0tensor(563),G0tensor(548),G0tensor(300)])
  call ol_merge_tensors(G1tensor(386),[G1tensor(341),G1tensor(331),G1tensor(266),G1tensor(256),G0tensor(1106),G0tensor(1095) &
    ,G0tensor(889),G0tensor(862),G0tensor(675),G0tensor(587),G0tensor(447),G0tensor(266),G0tensor(580),G0tensor(455) &
    ,G0tensor(305)])
  call ol_merge_tensors(G2tensor(330),[G1tensor(301),G0tensor(20),G0tensor(456),G0tensor(93),G0tensor(330)])
  call ol_merge_tensors(G0tensor(602),[G0tensor(527),G0tensor(566),G0tensor(340)])
  call ol_merge_tensors(G0tensor(737),[G0tensor(711),G0tensor(706),G0tensor(372),G0tensor(417),G0tensor(360)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(306),G0tensor(771),G0tensor(365)])
  call ol_merge_tensors(G0tensor(786),[G0tensor(776),G0tensor(370)])
  call ol_merge_tensors(G0tensor(747),[G0tensor(721),G0tensor(716),G0tensor(357),G0tensor(234),G0tensor(385)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(378),G0tensor(731),G0tensor(52),G0tensor(390)])
  call ol_merge_tensors(G0tensor(758),[G0tensor(732),G0tensor(727),G0tensor(194),G0tensor(77),G0tensor(415)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(324),G0tensor(720),G0tensor(48),G0tensor(420)])
  call ol_merge_tensors(G1tensor(296),[G0tensor(255),G0tensor(195),G0tensor(1125),G0tensor(1115),G0tensor(1029),G0tensor(1013) &
    ,G0tensor(827),G0tensor(799),G0tensor(624),G0tensor(523),G0tensor(353),G0tensor(348),G0tensor(337),G0tensor(277),G0tensor(313) &
    ,G0tensor(439),G0tensor(549),G0tensor(541),G0tensor(472),G0tensor(251),G0tensor(216),G0tensor(475),G0tensor(445)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(175),G1tensor(496),G1tensor(461),G1tensor(306),G0tensor(834),G0tensor(806) &
    ,G0tensor(513),G0tensor(382),G0tensor(480)])
  call ol_merge_tensors(G1tensor(291),[G0tensor(225),G0tensor(170),G0tensor(1074),G0tensor(1069),G0tensor(991),G0tensor(955) &
    ,G0tensor(844),G0tensor(816),G0tensor(553),G0tensor(433),G0tensor(233),G0tensor(467),G0tensor(406),G0tensor(66),G0tensor(399) &
    ,G0tensor(505)])
  call ol_merge_tensors(G0tensor(1030),[G0tensor(1025),G0tensor(895),G0tensor(635),G0tensor(441),G0tensor(545),G0tensor(7)])
  call ol_merge_tensors(G1tensor(617),[G0tensor(690),G0tensor(650),G0tensor(229),G0tensor(520)])
  call ol_merge_tensors(G1tensor(381),[G1tensor(336),G1tensor(261),G0tensor(1101),G0tensor(1090),G0tensor(796),G0tensor(654) &
    ,G0tensor(626),G0tensor(525)])
  call ol_merge_tensors(G0tensor(1075),[G0tensor(884),G0tensor(670),G0tensor(575)])
  call ol_merge_tensors(G1tensor(587),[G0tensor(1100),G0tensor(970),G0tensor(871),G0tensor(681),G0tensor(156),G0tensor(339) &
    ,G0tensor(605)])
  call ol_merge_tensors(G2tensor(223),[G2tensor(203),G2tensor(201),G1tensor(501),G1tensor(476),G1tensor(426),G1tensor(411) &
    ,G1tensor(391),G1tensor(311),G0tensor(470),G0tensor(685),G0tensor(625),G0tensor(621),G0tensor(610)])
  call ol_merge_tensors(G0tensor(780),[G0tensor(688),G0tensor(684),G0tensor(680),G0tensor(653),G0tensor(649),G0tensor(387) &
    ,G0tensor(16),G0tensor(496),G0tensor(261),G0tensor(301),G0tensor(219),G0tensor(589),G0tensor(291),G0tensor(396)])
  call ol_merge_tensors(G0tensor(976),[G0tensor(971),G0tensor(966),G0tensor(928),G0tensor(257),G0tensor(177),G0tensor(162) &
    ,G0tensor(73),G0tensor(384)])
  call ol_merge_tensors(G0tensor(1007),[G0tensor(877),G0tensor(872),G0tensor(867),G0tensor(178),G0tensor(594),G0tensor(189)])
  call ol_merge_tensors(G2tensor(372),[G2tensor(357),G2tensor(150),G1tensor(552),G1tensor(361),G1tensor(351),G0tensor(287) &
    ,G0tensor(89),G0tensor(324),G0tensor(149)])
  call ol_merge_tensors(G0tensor(982),[G0tensor(845),G0tensor(696),G0tensor(127),G0tensor(12),G0tensor(564),G0tensor(464) &
    ,G0tensor(68),G0tensor(214)])
  call ol_merge_tensors(G2tensor(360),[G2tensor(348),G2tensor(236),G2tensor(134),G2tensor(133),G1tensor(547),G1tensor(542) &
    ,G1tensor(366),G1tensor(356),G0tensor(929),G0tensor(911),G0tensor(302),G0tensor(169),G0tensor(534),G0tensor(279) &
    ,G0tensor(579)])
  call ol_merge_tensors(G1tensor(582),[G0tensor(1012),G0tensor(967),G0tensor(850),G0tensor(192),G0tensor(459),G0tensor(449)])
  call ol_merge_tensors(G0tensor(910),[G0tensor(663),G0tensor(639),G0tensor(634),G0tensor(237),G0tensor(228),G0tensor(213) &
    ,G0tensor(207),G0tensor(338),G0tensor(436),G0tensor(289),G0tensor(499)])
  call ol_merge_tensors(G0tensor(1023),[G0tensor(904),G0tensor(899),G0tensor(894),G0tensor(308),G0tensor(294),G0tensor(14)])
  call ol_merge_tensors(G2tensor(232),[G1tensor(562),G0tensor(1047),G0tensor(1035),G0tensor(413),G0tensor(166),G0tensor(34) &
    ,G0tensor(444),G0tensor(226)])
  call ol_merge_tensors(G1tensor(286),[G1tensor(281),G0tensor(115),G0tensor(1024),G0tensor(1008),G0tensor(598),G0tensor(328) &
    ,G0tensor(446),G0tensor(283),G0tensor(272),G0tensor(227),G0tensor(197),G0tensor(221),G0tensor(82),G0tensor(71)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(583),G0tensor(568),G0tensor(537),G0tensor(84)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(387),G1tensor(436),G1tensor(421),G1tensor(401),G0tensor(5),G0tensor(521) &
    ,G0tensor(476),G0tensor(138)])
  call ol_merge_tensors(G0tensor(140),[G0tensor(573),G0tensor(526),G0tensor(509),G0tensor(299),G0tensor(25),G0tensor(322)])
  call ol_merge_tensors(G1tensor(371),[G0tensor(582),G0tensor(551),G0tensor(246)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(132),G1tensor(567),G1tensor(346),G0tensor(618),G0tensor(10),G0tensor(451)])
  call ol_merge_tensors(G2tensor(303),[G0tensor(701),G0tensor(692),G0tensor(586),G0tensor(131),G0tensor(569),G0tensor(64)])
  call ol_merge_tensors(G0tensor(998),[G0tensor(962),G0tensor(694),G0tensor(503),G0tensor(611),G0tensor(576),G0tensor(91) &
    ,G0tensor(69)])
  call ol_merge_tensors(G0tensor(1063),[G0tensor(1058),G0tensor(1051),G0tensor(1046),G0tensor(986),G0tensor(915),G0tensor(182) &
    ,G0tensor(346),G0tensor(172),G0tensor(327),G0tensor(559)])
  call ol_merge_tensors(G1tensor(622),[G0tensor(1085),G0tensor(993),G0tensor(698),G0tensor(96)])
  call ol_merge_tensors(G1tensor(632),[G0tensor(795),G0tensor(638),G0tensor(631),G0tensor(129)])
  call ol_merge_tensors(G0tensor(1039),[G0tensor(1034),G0tensor(950),G0tensor(933),G0tensor(674),G0tensor(669),G0tensor(482) &
    ,G0tensor(462),G0tensor(198),G0tensor(42),G0tensor(486),G0tensor(601),G0tensor(581)])
  call ol_merge_tensors(G0tensor(1080),[G0tensor(957),G0tensor(662),G0tensor(659),G0tensor(606)])
  call ol_merge_tensors(G1tensor(642),[G0tensor(1014),G0tensor(1009),G0tensor(868),G0tensor(163),G0tensor(309),G0tensor(491)])
  call ol_merge_tensors(G1tensor(572),[G0tensor(1089),G0tensor(898),G0tensor(620),G0tensor(278),G0tensor(154),G0tensor(319)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(405),G2tensor(218),G0tensor(703),G0tensor(26),G0tensor(23),G0tensor(326) &
    ,G0tensor(18)])
  call ol_merge_tensors(G0tensor(961),[G0tensor(956),G0tensor(903),G0tensor(247),G0tensor(158),G0tensor(481)])
  call ol_merge_tensors(G1tensor(592),[G0tensor(997),G0tensor(992),G0tensor(975),G0tensor(876),G0tensor(132),G0tensor(106)])
  call ol_merge_tensors(G0tensor(921),[G0tensor(832),G0tensor(828),G0tensor(794),G0tensor(789),G0tensor(608),G0tensor(427) &
    ,G0tensor(407),G0tensor(342),G0tensor(33),G0tensor(502)])
  call ol_merge_tensors(G0tensor(1001),[G0tensor(996),G0tensor(981),G0tensor(861),G0tensor(856),G0tensor(183),G0tensor(364)])
  call ol_merge_tensors(G0tensor(1017),[G0tensor(960),G0tensor(945),G0tensor(888),G0tensor(883),G0tensor(267),G0tensor(432)])
  call ol_merge_tensors(G0tensor(743),[G0tensor(738),G0tensor(705),G0tensor(507)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(375),G0tensor(710),G0tensor(381)])
  call ol_merge_tensors(G0tensor(753),[G0tensor(748),G0tensor(715),G0tensor(394)])
  call ol_merge_tensors(G0tensor(764),[G0tensor(759),G0tensor(726),G0tensor(57)])
  call ol_merge_tensors(G2tensor(238),[G2tensor(224),G0tensor(742),G0tensor(186)])
  call ol_merge_tensors(G0tensor(752),[G0tensor(204),G0tensor(209)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(225),G0tensor(763),G0tensor(191),G0tensor(72)])
  call ol_merge_tensors(G0tensor(784),[G0tensor(769),G0tensor(367)])
  call ol_merge_tensors(G0tensor(774),[G0tensor(206)])
  call ol_merge_tensors(G0tensor(1121),[G0tensor(1111),G0tensor(1084),G0tensor(1079),G0tensor(1057),G0tensor(965),G0tensor(893) &
    ,G0tensor(882),G0tensor(866),G0tensor(855),G0tensor(775),G0tensor(770),G0tensor(702),G0tensor(679),G0tensor(498),G0tensor(15) &
    ,G0tensor(218),G0tensor(424),G0tensor(426),G0tensor(281),G0tensor(259),G0tensor(256),G0tensor(231)])
  call ol_merge_tensors(G1tensor(597),[G0tensor(1116),G0tensor(1062),G0tensor(860),G0tensor(117)])
  call ol_merge_tensors(G1tensor(637),[G0tensor(1070),G0tensor(857),G0tensor(402)])
  call ol_merge_tensors(G0tensor(1126),[G0tensor(887),G0tensor(683),G0tensor(468),G0tensor(147)])
  call ol_merge_tensors(G0tensor(1052),[G0tensor(1040),G0tensor(1018),G0tensor(1002),G0tensor(508),G0tensor(386),G0tensor(378) &
    ,G0tensor(408)])
  call ol_merge_tensors(G1tensor(577),[G0tensor(1094),G0tensor(1068),G0tensor(1059),G0tensor(418)])
  call ol_merge_tensors(G2tensor(369),[G0tensor(988),G0tensor(983),G0tensor(952),G0tensor(947),G0tensor(493)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(120),G2tensor(119),G2tensor(115),G0tensor(790),G0tensor(785),G0tensor(697) &
    ,G0tensor(693),G0tensor(689),G0tensor(668),G0tensor(658),G0tensor(648),G0tensor(644),G0tensor(633),G0tensor(630)])
  call ol_merge_tensors(G0tensor(1127),[G0tensor(1122),G0tensor(673),G0tensor(652),G0tensor(645)])
  call ol_merge_tensors(G1tensor(271),[G0tensor(781)])
  call ol_merge_tensors(G1tensor(627),[G0tensor(1117),G0tensor(1112),G0tensor(791)])
  call ol_merge_tensors(G0tensor(1120),[G0tensor(1104),G0tensor(1099),G0tensor(1033),G0tensor(810),G0tensor(801)])
  call ol_merge_tensors(G0tensor(1041),[G0tensor(811),G0tensor(805)])
  call ol_merge_tensors(G0tensor(1078),[G0tensor(951),G0tensor(909),G0tensor(821),G0tensor(818)])
  call ol_merge_tensors(G0tensor(1110),[G0tensor(1093),G0tensor(1088),G0tensor(1045),G0tensor(838),G0tensor(829)])
  call ol_merge_tensors(G0tensor(1053),[G0tensor(839),G0tensor(833)])
  call ol_merge_tensors(G0tensor(1083),[G0tensor(987),G0tensor(927),G0tensor(849),G0tensor(846)])
  call ol_merge_tensors(G0tensor(1003),[G0tensor(922),G0tensor(917)])
  call ol_merge_tensors(G0tensor(1019),[G0tensor(940),G0tensor(935)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(557)])
call TI_bubble_red(G2tensor(219),20,mass2set(:,1),G0tensor(614),M2L1R1,G0tensor(314),G0tensor(19))
call TI_bubble_red(G2tensor(314),20,mass2set(:,2),G0tensor(519),M2L1R1,G0tensor(529))
call TI_bubble_red(G2tensor(320),20,mass2set(:,3),G0tensor(86),M2L1R1,G0tensor(107),G0tensor(164))
call TI_bubble_red(G2tensor(300),28,mass2set(:,2),G0tensor(141),M2L1R1,G0tensor(146))
call TI_bubble_red(G2tensor(106),19,mass2set(:,4),G0tensor(321),M2L1R1,G0tensor(128))
call TI_bubble_red(G2tensor(191),28,mass2set(:,3),G0tensor(143),M2L1R1,G0tensor(477),G0tensor(471))
call TI_bubble_red(G2tensor(46),28,mass2set(:,5),G0tensor(311),M2L1R1,G0tensor(571))
call TI_bubble_red(G2tensor(140),19,mass2set(:,6),G0tensor(546),M2L1R1,G0tensor(159))
call TI_bubble_red(G2tensor(141),19,mass2set(:,7),G0tensor(39),M2L1R1,G0tensor(44))
call TI_bubble_red(G2tensor(151),28,mass2set(:,8),G0tensor(331),M2L1R1,G0tensor(94),G0tensor(126))
call TI_bubble_red(G2tensor(97),19,mass2set(:,9),G0tensor(617),M2L1R1,G0tensor(596))
call TI_bubble_red(G2tensor(290),19,mass2set(:,10),G0tensor(506),M2L1R1,G0tensor(304),G0tensor(81))
call TI_bubble_red(G2tensor(162),19,mass2set(:,11),G0tensor(501),M2L1R1,G0tensor(334),G0tensor(431))
call TI_bubble_red(G2tensor(330),28,mass2set(:,12),G0tensor(28),M2L1R1,G0tensor(359),G0tensor(36))
call TI_bubble_red(G2tensor(179),20,mass2set(:,13),G0tensor(572),M2L1R1,G0tensor(43))
call TI_bubble_red(G2tensor(260),20,mass2set(:,8),G0tensor(389),M2L1R1,G0tensor(51),G0tensor(562))
call TI_bubble_red(G2tensor(180),20,mass2set(:,14),G0tensor(414),M2L1R1,G0tensor(284),G0tensor(377))
call TI_bubble_red(G2tensor(188),20,mass2set(:,15),G0tensor(87),M2L1R1,G0tensor(92),G0tensor(798))
call TI_bubble_red(G2tensor(223),20,mass2set(:,16),G0tensor(803),M2L1R1,G0tensor(809))
call TI_bubble_red(G2tensor(372),24,mass2set(:,2),G0tensor(815),M2L1R1,G0tensor(820))
call TI_bubble_red(G2tensor(360),24,mass2set(:,3),G0tensor(826),M2L1R1,G0tensor(831),G0tensor(837))
call TI_bubble_red(G2tensor(232),24,mass2set(:,1),G0tensor(843),M2L1R1,G0tensor(848),G0tensor(108))
call TI_bubble_red(G2tensor(194),20,mass2set(:,12),G0tensor(854),M2L1R1,G0tensor(859),G0tensor(412))
call TI_bubble_red(G2tensor(234),24,mass2set(:,12),G0tensor(392),M2L1R1,G0tensor(865),G0tensor(870))
call TI_bubble_red(G2tensor(303),28,mass2set(:,17),G0tensor(151),M2L1R1)
call TI_bubble_red(G2tensor(166),20,mass2set(:,17),G0tensor(875),M2L1R1)
call TI_bubble_red(G2tensor(192),20,mass2set(:,5),G0tensor(134),M2L1R1,G0tensor(881))
call TI_bubble_red(G2tensor(238),24,mass2set(:,5),G0tensor(886),M2L1R1,G0tensor(421))
call TI_bubble_red(G2tensor(345),24,mass2set(:,8),G0tensor(892),M2L1R1,G0tensor(897),G0tensor(419))
call TI_bubble_red(G2tensor(369),24,mass2set(:,17),G0tensor(902),M2L1R1)
call TI_bubble_red(G2tensor(121),19,mass2set(:,17),G0tensor(167),M2L1R1)
call TI_bubble_red(G2tensor(230),24,mass2set(:,16),G0tensor(168),M2L1R1,G0tensor(908))
  call ol_merge_tensors(G0tensor(848),[G0tensor(837),G0tensor(334),G0tensor(81),G0tensor(471),G0tensor(164),G0tensor(1107) &
    ,G0tensor(314)])
  call ol_merge_tensors(G0tensor(908),[G0tensor(865),G0tensor(859),G0tensor(108),G0tensor(831),G0tensor(820),G0tensor(809) &
    ,G0tensor(798),G0tensor(359),G0tensor(477),G0tensor(128),G0tensor(146),G0tensor(107),G0tensor(529),G0tensor(1128) &
    ,G0tensor(19)])
  call ol_merge_tensors(G0tensor(421),[G0tensor(881),G0tensor(43),G0tensor(787),G0tensor(159),G0tensor(571)])
  call ol_merge_tensors(G0tensor(419),[G0tensor(284),G0tensor(562),G0tensor(126),G0tensor(767),G0tensor(44)])
  call ol_merge_tensors(G0tensor(897),[G0tensor(377),G0tensor(51),G0tensor(596),G0tensor(94),G0tensor(766)])
  call ol_merge_tensors(G0tensor(870),[G0tensor(412),G0tensor(92),G0tensor(36),G0tensor(431),G0tensor(1054),G0tensor(304)])
call TI_bubble_red(G1tensor(276),28,mass2set(:,1),G0tensor(434),M2L1R1,G0tensor(187),G0tensor(914))
call TI_bubble_red(G1tensor(376),16,mass2set(:,15),G0tensor(920),M2L1R1,G0tensor(926),G0tensor(188))
call TI_bubble_red(G1tensor(386),16,mass2set(:,1),G0tensor(193),M2L1R1,G0tensor(203),G0tensor(932))
call TI_bubble_red(G1tensor(296),27,mass2set(:,4),G0tensor(938),M2L1R1,G0tensor(212))
call TI_bubble_red(G1tensor(291),27,mass2set(:,18),G0tensor(944),M2L1R1,G0tensor(949))
call TI_bubble_red(G1tensor(617),17,mass2set(:,17),G0tensor(954),M2L1R1)
call TI_bubble_red(G1tensor(381),16,mass2set(:,16),G0tensor(959),M2L1R1,G0tensor(964))
call TI_bubble_red(G1tensor(587),21,mass2set(:,17),G0tensor(969),M2L1R1)
call TI_bubble_red(G1tensor(582),22,mass2set(:,2),G0tensor(974),M2L1R1,G0tensor(980))
call TI_bubble_red(G1tensor(286),23,mass2set(:,4),G0tensor(985),M2L1R1,G0tensor(990))
call TI_bubble_red(G1tensor(371),24,mass2set(:,15),G0tensor(995),M2L1R1,G0tensor(273),G0tensor(318))
call TI_bubble_red(G1tensor(622),17,mass2set(:,19),G0tensor(282),M2L1R1,G0tensor(242))
call TI_bubble_red(G1tensor(632),18,mass2set(:,17),G0tensor(1000),M2L1R1)
call TI_bubble_red(G1tensor(642),18,mass2set(:,2),G0tensor(238),M2L1R1,G0tensor(258))
call TI_bubble_red(G1tensor(572),22,mass2set(:,17),G0tensor(1006),M2L1R1)
call TI_bubble_red(G1tensor(592),21,mass2set(:,19),G0tensor(292),M2L1R1,G0tensor(307))
call TI_bubble_red(G1tensor(597),21,mass2set(:,16),G0tensor(336),M2L1R1,G0tensor(1011))
call TI_bubble_red(G1tensor(637),18,mass2set(:,20),G0tensor(347),M2L1R1,G0tensor(349))
call TI_bubble_red(G1tensor(577),22,mass2set(:,20),G0tensor(1016),M2L1R1,G0tensor(1022))
call TI_bubble_red(G1tensor(271),28,mass2set(:,16),G0tensor(1027),M2L1R1,G0tensor(1032))
call TI_bubble_red(G1tensor(627),17,mass2set(:,16),G0tensor(1038),M2L1R1,G0tensor(363))
  call ol_merge_tensors(G0tensor(1022),[G0tensor(349),G0tensor(307),G0tensor(242),G0tensor(949),G0tensor(203),G0tensor(187) &
    ,G0tensor(848)])
  call ol_merge_tensors(G0tensor(363),[G0tensor(1032),G0tensor(1011),G0tensor(258),G0tensor(318),G0tensor(990),G0tensor(980) &
    ,G0tensor(964),G0tensor(212),G0tensor(932),G0tensor(188),G0tensor(914),G0tensor(908)])
  call ol_merge_tensors(G0tensor(273),[G0tensor(926),G0tensor(870)])
  call ol_merge_tensors(T0sum(341),[G0tensor(939)])
  call ol_merge_tensors(T0sum(342),[G0tensor(1105)])
  call ol_merge_tensors(T0sum(343),[G0tensor(614)])
  call ol_merge_tensors(T0sum(344),[G0tensor(1022)])
  call ol_merge_tensors(T0sum(345),[G0tensor(363)])
  call ol_merge_tensors(T0sum(346),[G0tensor(629)])
  call ol_merge_tensors(T0sum(347),[G0tensor(1028)])
  call ol_merge_tensors(T0sum(348),[G0tensor(519)])
  call ol_merge_tensors(T0sum(349),[G0tensor(946)])
  call ol_merge_tensors(T0sum(350),[G0tensor(86)])
  call ol_merge_tensors(T0sum(351),[G0tensor(141)])
  call ol_merge_tensors(T0sum(352),[G0tensor(321)])
  call ol_merge_tensors(T0sum(353),[G0tensor(497)])
  call ol_merge_tensors(T0sum(354),[G0tensor(143)])
  call ol_merge_tensors(T0sum(355),[G0tensor(144)])
  call ol_merge_tensors(T0sum(356),[G0tensor(311)])
  call ol_merge_tensors(T0sum(357),[G0tensor(421)])
  call ol_merge_tensors(T0sum(358),[G0tensor(546)])
  call ol_merge_tensors(T0sum(359),[G0tensor(744)])
  call ol_merge_tensors(T0sum(360),[G0tensor(97)])
  call ol_merge_tensors(T0sum(361),[G0tensor(39)])
  call ol_merge_tensors(T0sum(362),[G0tensor(419)])
  call ol_merge_tensors(T0sum(363),[G0tensor(754)])
  call ol_merge_tensors(T0sum(364),[G0tensor(897)])
  call ol_merge_tensors(T0sum(365),[G0tensor(331)])
  call ol_merge_tensors(T0sum(366),[G0tensor(617)])
  call ol_merge_tensors(T0sum(367),[G0tensor(765)])
  call ol_merge_tensors(T0sum(368),[G0tensor(434)])
  call ol_merge_tensors(T0sum(369),[G0tensor(506)])
  call ol_merge_tensors(T0sum(370),[G0tensor(273)])
  call ol_merge_tensors(T0sum(371),[G0tensor(920)])
  call ol_merge_tensors(T0sum(372),[G0tensor(561)])
  call ol_merge_tensors(T0sum(373),[G0tensor(501)])
  call ol_merge_tensors(T0sum(374),[G0tensor(193)])
  call ol_merge_tensors(T0sum(375),[G0tensor(28)])
  call ol_merge_tensors(T0sum(376),[G0tensor(602)])
  call ol_merge_tensors(T0sum(377),[G0tensor(737)])
  call ol_merge_tensors(T0sum(378),[G0tensor(572)])
  call ol_merge_tensors(T0sum(379),[G0tensor(786)])
  call ol_merge_tensors(T0sum(380),[G0tensor(747)])
  call ol_merge_tensors(T0sum(381),[G0tensor(389)])
  call ol_merge_tensors(T0sum(382),[G0tensor(758)])
  call ol_merge_tensors(T0sum(383),[G0tensor(414)])
  call ol_merge_tensors(T0sum(384),[G0tensor(938)])
  call ol_merge_tensors(T0sum(385),[G0tensor(87)])
  call ol_merge_tensors(T0sum(386),[G0tensor(944)])
  call ol_merge_tensors(T0sum(387),[G0tensor(1030)])
  call ol_merge_tensors(T0sum(388),[G0tensor(954)])
  call ol_merge_tensors(T0sum(389),[G0tensor(959)])
  call ol_merge_tensors(T0sum(390),[G0tensor(1075)])
  call ol_merge_tensors(T0sum(391),[G0tensor(969)])
  call ol_merge_tensors(T0sum(392),[G0tensor(803)])
  call ol_merge_tensors(T0sum(393),[G0tensor(780)])
  call ol_merge_tensors(T0sum(394),[G0tensor(976)])
  call ol_merge_tensors(T0sum(395),[G0tensor(1007)])
  call ol_merge_tensors(T0sum(396),[G0tensor(815)])
  call ol_merge_tensors(T0sum(397),[G0tensor(982)])
  call ol_merge_tensors(T0sum(398),[G0tensor(826)])
  call ol_merge_tensors(T0sum(399),[G0tensor(974)])
  call ol_merge_tensors(T0sum(400),[G0tensor(910)])
  call ol_merge_tensors(T0sum(401),[G0tensor(1023)])
  call ol_merge_tensors(T0sum(402),[G0tensor(843)])
  call ol_merge_tensors(T0sum(403),[G0tensor(985)])
  call ol_merge_tensors(T0sum(404),[G0tensor(85)])
  call ol_merge_tensors(T0sum(405),[G0tensor(854)])
  call ol_merge_tensors(T0sum(406),[G0tensor(140)])
  call ol_merge_tensors(T0sum(407),[G0tensor(995)])
  call ol_merge_tensors(T0sum(408),[G0tensor(392)])
  call ol_merge_tensors(T0sum(409),[G0tensor(151)])
  call ol_merge_tensors(T0sum(410),[G0tensor(998)])
  call ol_merge_tensors(T0sum(411),[G0tensor(1063)])
  call ol_merge_tensors(T0sum(412),[G0tensor(282)])
  call ol_merge_tensors(T0sum(413),[G0tensor(1000)])
  call ol_merge_tensors(T0sum(414),[G0tensor(1039)])
  call ol_merge_tensors(T0sum(415),[G0tensor(1080)])
  call ol_merge_tensors(T0sum(416),[G0tensor(238)])
  call ol_merge_tensors(T0sum(417),[G0tensor(1006)])
  call ol_merge_tensors(T0sum(418),[G0tensor(875)])
  call ol_merge_tensors(T0sum(419),[G0tensor(961)])
  call ol_merge_tensors(T0sum(420),[G0tensor(292)])
  call ol_merge_tensors(T0sum(421),[G0tensor(921)])
  call ol_merge_tensors(T0sum(422),[G0tensor(1001)])
  call ol_merge_tensors(T0sum(423),[G0tensor(1017)])
  call ol_merge_tensors(T0sum(424),[G0tensor(743)])
  call ol_merge_tensors(T0sum(425),[G0tensor(134)])
  call ol_merge_tensors(T0sum(426),[G0tensor(753)])
  call ol_merge_tensors(T0sum(427),[G0tensor(764)])
  call ol_merge_tensors(T0sum(428),[G0tensor(886)])
  call ol_merge_tensors(T0sum(429),[G0tensor(752)])
  call ol_merge_tensors(T0sum(430),[G0tensor(892)])
  call ol_merge_tensors(T0sum(431),[G0tensor(784)])
  call ol_merge_tensors(T0sum(432),[G0tensor(774)])
  call ol_merge_tensors(T0sum(433),[G0tensor(1121)])
  call ol_merge_tensors(T0sum(434),[G0tensor(336)])
  call ol_merge_tensors(T0sum(435),[G0tensor(347)])
  call ol_merge_tensors(T0sum(436),[G0tensor(1126)])
  call ol_merge_tensors(T0sum(437),[G0tensor(1052)])
  call ol_merge_tensors(T0sum(438),[G0tensor(1016)])
  call ol_merge_tensors(T0sum(439),[G0tensor(902)])
  call ol_merge_tensors(T0sum(440),[G0tensor(167)])
  call ol_merge_tensors(T0sum(441),[G0tensor(1127)])
  call ol_merge_tensors(T0sum(442),[G0tensor(1027)])
  call ol_merge_tensors(T0sum(443),[G0tensor(1038)])
  call ol_merge_tensors(T0sum(444),[G0tensor(1120)])
  call ol_merge_tensors(T0sum(445),[G0tensor(1041)])
  call ol_merge_tensors(T0sum(446),[G0tensor(1078)])
  call ol_merge_tensors(T0sum(447),[G0tensor(1110)])
  call ol_merge_tensors(T0sum(448),[G0tensor(1053)])
  call ol_merge_tensors(T0sum(449),[G0tensor(1083)])
  call ol_merge_tensors(T0sum(450),[G0tensor(1003)])
  call ol_merge_tensors(T0sum(451),[G0tensor(1019)])
  call ol_merge_tensors(T0sum(452),[G0tensor(168)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_79,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_102,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_91,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_91,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_80,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_73,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_73,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_67,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_67,RedSet_4(4),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_72,RedSet_4(5),ScalarBoxes(10))
  call compute_scalar_box([ 16, 19, 23 ],masses2_106,RedSet_4(2),ScalarBoxes(11))
  call compute_scalar_box([ 16, 18, 23 ],masses2_104,RedSet_4(3),ScalarBoxes(12))
  call compute_scalar_box([ 16, 18, 19 ],masses2_104,RedSet_4(4),ScalarBoxes(13))
  call compute_scalar_box([ 2, 3, 7 ],masses2_74,RedSet_4(5),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_73,RedSet_4(6),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_73,RedSet_4(7),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_67,RedSet_4(8),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_72,RedSet_4(9),ScalarBoxes(18))
  call compute_scalar_box([ 18, 19, 27 ],masses2_76,RedSet_4(6),ScalarBoxes(19))
  call compute_scalar_box([ 16, 19, 27 ],masses2_101,RedSet_4(7),ScalarBoxes(20))
  call compute_scalar_box([ 16, 18, 27 ],masses2_90,RedSet_4(8),ScalarBoxes(21))
  call compute_scalar_box([ 2, 3, 11 ],masses2_77,RedSet_4(9),ScalarBoxes(22))
  call compute_scalar_box([ 16, 19, 27 ],masses2_106,RedSet_4(7),ScalarBoxes(23))
  call compute_scalar_box([ 16, 18, 27 ],masses2_104,RedSet_4(8),ScalarBoxes(24))
  call compute_scalar_box([ 2, 3, 11 ],masses2_74,RedSet_4(9),ScalarBoxes(25))
  call compute_scalar_box([ 17, 19, 23 ],masses2_79,RedSet_4(10),ScalarBoxes(26))
  call compute_scalar_box([ 16, 17, 23 ],masses2_91,RedSet_4(11),ScalarBoxes(27))
  call compute_scalar_box([ 16, 17, 19 ],masses2_91,RedSet_4(12),ScalarBoxes(28))
  call compute_scalar_box([ 1, 3, 7 ],masses2_80,RedSet_4(13),ScalarBoxes(29))
  call compute_scalar_box([ 17, 19, 23 ],masses2_73,RedSet_4(10),ScalarBoxes(30))
  call compute_scalar_box([ 16, 17, 23 ],masses2_67,RedSet_4(11),ScalarBoxes(31))
  call compute_scalar_box([ 16, 17, 19 ],masses2_67,RedSet_4(12),ScalarBoxes(32))
  call compute_scalar_box([ 1, 3, 7 ],masses2_72,RedSet_4(13),ScalarBoxes(33))
  call compute_scalar_box([ 16, 17, 23 ],masses2_104,RedSet_4(11),ScalarBoxes(34))
  call compute_scalar_box([ 16, 17, 19 ],masses2_104,RedSet_4(12),ScalarBoxes(35))
  call compute_scalar_box([ 1, 3, 7 ],masses2_74,RedSet_4(13),ScalarBoxes(36))
  call compute_scalar_box([ 17, 19, 27 ],masses2_73,RedSet_4(14),ScalarBoxes(37))
  call compute_scalar_box([ 16, 17, 27 ],masses2_67,RedSet_4(15),ScalarBoxes(38))
  call compute_scalar_box([ 1, 3, 11 ],masses2_72,RedSet_4(16),ScalarBoxes(39))
  call compute_scalar_box([ 17, 19, 27 ],masses2_76,RedSet_4(14),ScalarBoxes(40))
  call compute_scalar_box([ 16, 17, 27 ],masses2_90,RedSet_4(15),ScalarBoxes(41))
  call compute_scalar_box([ 1, 3, 11 ],masses2_77,RedSet_4(16),ScalarBoxes(42))
  call compute_scalar_box([ 16, 17, 27 ],masses2_104,RedSet_4(15),ScalarBoxes(43))
  call compute_scalar_box([ 1, 3, 11 ],masses2_74,RedSet_4(16),ScalarBoxes(44))
  call compute_scalar_box([ 20, 21, 23 ],masses2_91,RedSet_4(17),ScalarBoxes(45))
  call compute_scalar_box([ 16, 21, 23 ],masses2_91,RedSet_4(18),ScalarBoxes(46))
  call compute_scalar_box([ 16, 20, 23 ],masses2_100,RedSet_4(19),ScalarBoxes(47))
  call compute_scalar_box([ 16, 20, 21 ],masses2_97,RedSet_4(20),ScalarBoxes(48))
  call compute_scalar_box([ 4, 5, 7 ],masses2_92,RedSet_4(21),ScalarBoxes(49))
  call compute_scalar_box([ 20, 21, 23 ],masses2_104,RedSet_4(17),ScalarBoxes(50))
  call compute_scalar_box([ 16, 21, 23 ],masses2_104,RedSet_4(18),ScalarBoxes(51))
  call compute_scalar_box([ 16, 20, 23 ],masses2_109,RedSet_4(19),ScalarBoxes(52))
  call compute_scalar_box([ 16, 20, 21 ],masses2_108,RedSet_4(20),ScalarBoxes(53))
  call compute_scalar_box([ 4, 5, 7 ],masses2_105,RedSet_4(21),ScalarBoxes(54))
  call compute_scalar_box([ 20, 22, 23 ],masses2_91,RedSet_4(22),ScalarBoxes(55))
  call compute_scalar_box([ 16, 22, 23 ],masses2_91,RedSet_4(23),ScalarBoxes(56))
  call compute_scalar_box([ 16, 20, 22 ],masses2_97,RedSet_4(24),ScalarBoxes(57))
  call compute_scalar_box([ 4, 6, 7 ],masses2_92,RedSet_4(25),ScalarBoxes(58))
  call compute_scalar_box([ 20, 22, 23 ],masses2_104,RedSet_4(22),ScalarBoxes(59))
  call compute_scalar_box([ 16, 22, 23 ],masses2_104,RedSet_4(23),ScalarBoxes(60))
  call compute_scalar_box([ 16, 20, 22 ],masses2_108,RedSet_4(24),ScalarBoxes(61))
  call compute_scalar_box([ 4, 6, 7 ],masses2_105,RedSet_4(25),ScalarBoxes(62))
  call compute_scalar_box([ 18, 26, 27 ],masses2_70,RedSet_4(26),ScalarBoxes(63))
  call compute_scalar_box([ 16, 26, 27 ],masses2_93,RedSet_4(27),ScalarBoxes(64))
  call compute_scalar_box([ 16, 18, 27 ],masses2_93,RedSet_4(8),ScalarBoxes(65))
  call compute_scalar_box([ 16, 18, 26 ],masses2_89,RedSet_4(28),ScalarBoxes(66))
  call compute_scalar_box([ 2, 10, 11 ],masses2_69,RedSet_4(29),ScalarBoxes(67))
  call compute_scalar_box([ 18, 26, 27 ],masses2_67,RedSet_4(26),ScalarBoxes(68))
  call compute_scalar_box([ 16, 26, 27 ],masses2_67,RedSet_4(27),ScalarBoxes(69))
  call compute_scalar_box([ 16, 18, 26 ],masses2_65,RedSet_4(28),ScalarBoxes(70))
  call compute_scalar_box([ 2, 10, 11 ],masses2_66,RedSet_4(29),ScalarBoxes(71))
  call compute_scalar_box([ 16, 26, 27 ],masses2_104,RedSet_4(27),ScalarBoxes(72))
  call compute_scalar_box([ 16, 18, 26 ],masses2_103,RedSet_4(28),ScalarBoxes(73))
  call compute_scalar_box([ 2, 10, 11 ],masses2_68,RedSet_4(29),ScalarBoxes(74))
  call compute_scalar_box([ 17, 25, 27 ],masses2_70,RedSet_4(30),ScalarBoxes(75))
  call compute_scalar_box([ 16, 25, 27 ],masses2_93,RedSet_4(31),ScalarBoxes(76))
  call compute_scalar_box([ 16, 17, 27 ],masses2_93,RedSet_4(15),ScalarBoxes(77))
  call compute_scalar_box([ 16, 17, 25 ],masses2_89,RedSet_4(32),ScalarBoxes(78))
  call compute_scalar_box([ 1, 9, 11 ],masses2_69,RedSet_4(33),ScalarBoxes(79))
  call compute_scalar_box([ 17, 25, 27 ],masses2_67,RedSet_4(30),ScalarBoxes(80))
  call compute_scalar_box([ 16, 25, 27 ],masses2_67,RedSet_4(31),ScalarBoxes(81))
  call compute_scalar_box([ 16, 17, 25 ],masses2_65,RedSet_4(32),ScalarBoxes(82))
  call compute_scalar_box([ 1, 9, 11 ],masses2_66,RedSet_4(33),ScalarBoxes(83))
  call compute_scalar_box([ 16, 25, 27 ],masses2_104,RedSet_4(31),ScalarBoxes(84))
  call compute_scalar_box([ 16, 17, 25 ],masses2_103,RedSet_4(32),ScalarBoxes(85))
  call compute_scalar_box([ 1, 9, 11 ],masses2_68,RedSet_4(33),ScalarBoxes(86))
  call compute_scalar_box([ 18, 22, 23 ],masses2_107,RedSet_4(34),ScalarBoxes(87))
  call compute_scalar_box([ 16, 22, 23 ],masses2_75,RedSet_4(23),ScalarBoxes(88))
  call compute_scalar_box([ 16, 18, 23 ],masses2_75,RedSet_4(3),ScalarBoxes(89))
  call compute_scalar_box([ 16, 18, 22 ],masses2_78,RedSet_4(35),ScalarBoxes(90))
  call compute_scalar_box([ 2, 6, 7 ],masses2_107,RedSet_4(36),ScalarBoxes(91))
  call compute_scalar_box([ 17, 21, 23 ],masses2_107,RedSet_4(37),ScalarBoxes(92))
  call compute_scalar_box([ 16, 21, 23 ],masses2_75,RedSet_4(18),ScalarBoxes(93))
  call compute_scalar_box([ 16, 17, 23 ],masses2_75,RedSet_4(11),ScalarBoxes(94))
  call compute_scalar_box([ 16, 17, 21 ],masses2_78,RedSet_4(38),ScalarBoxes(95))
  call compute_scalar_box([ 1, 5, 7 ],masses2_107,RedSet_4(39),ScalarBoxes(96))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphvv_ew_uxdhzwx_1_/**/REALKIND
