
module ol_vamp_1_pphvv_ew_uuxhzz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_ew_uuxhzz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_ew_uuxhzz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_ew_uuxhzz_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_ew_uuxhzz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphvv_ew_uuxhzz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_uuxhzz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMZ,nMZ,0,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(2),m3h3x12(:,2),heltab2x36(:,:,2))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,3),heltab2x36(:,:,3))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMZ,nMZ,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,4),heltab2x36(:,:,4))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,5),heltab2x36(:,:,5))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(3),m3h3x12(:,6),heltab2x36(:,:,6))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMZ,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(4),m3h3x12(:,7),heltab2x36(:,:,7))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,8),heltab2x36(:,:,8))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(4),m3h3x12(:,9),heltab2x36(:,:,9))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMZ,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(6),m3h3x12(:,10),heltab2x36(:,:,10))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,11),heltab2x36(:,:,11))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(5),m3h3x12(:,12),heltab2x36(:,:,12))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[nMZ,nMZ,0,nMZ,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(6),m3h3x12(:,13),heltab2x36(:,:,13))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(7),m3h3x12(:,14),heltab2x36(:,:,14))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(8),m3h3x12(:,15),heltab2x36(:,:,15))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMZ,nMZ,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,16),heltab2x36(:,:,16))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(10),m3h3x12(:,17),heltab2x36(:,:,17))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(8),m3h3x12(:,18),heltab2x36(:,:,18))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[nMZ,0,nMZ,nMH,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(11),m3h3x12(:,19),heltab2x36(:,:,19))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,20),heltab2x36(:,:,20))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(9),m3h3x12(:,21),heltab2x36(:,:,21))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,22),heltab2x36(:,:,22))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(10),m3h3x12(:,23),heltab2x36(:,:,23))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[16,1,2,4,8],[nMZ,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,24),heltab2x36(:,:,24))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,25),heltab2x36(:,:,25))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(11),m3h3x12(:,26),heltab2x36(:,:,26))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMZ,0,nMZ,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,27),heltab2x36(:,:,27))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,28),heltab2x36(:,:,28))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(12),m3h3x12(:,29),heltab2x36(:,:,29))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[16,1,2,8,4],[nMZ,0,nMZ,nMH,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,30),heltab2x36(:,:,30))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,31),heltab2x36(:,:,31))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(13),m3h3x12(:,32),heltab2x36(:,:,32))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,33),heltab2x36(:,:,33))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(14),m3h3x12(:,34),heltab2x36(:,:,34))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[16,2,4,1,8],[0,nMZ,nMZ,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(21),ngZu,m3h3x12(:,35),heltab2x36(:,:,35))
  call Hloop_Q_A(ntryL,G0H12(21),16,0,G1H12(15),n2h12(1))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(21),ngZd,m3h3x12(:,36),heltab2x36(:,:,36))
  call Hloop_Q_A(ntryL,G0H12(21),16,0,G1H12(16),n2h12(2))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,37),heltab2x36(:,:,37))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(17),m3h3x12(:,38),heltab2x36(:,:,38))
  Gcoeff(:)%j = (c(83)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[16,1,4,2,8],[0,nMZ,nMZ,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(22),ngZu,m3h3x12(:,39),heltab2x36(:,:,39))
  call Hloop_A_Q(ntryL,G0H12(22),16,0,G1H12(18),n2h12(3))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(22),ngZd,m3h3x12(:,40),heltab2x36(:,:,40))
  call Hloop_A_Q(ntryL,G0H12(22),16,0,G1H12(19),n2h12(4))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(22),ngZd,m3h3x12(:,41),heltab2x36(:,:,41))
  call Hloop_A_Q(ntryL,G0H12(22),16,0,G1H12(20),n2h12(5))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(22),ngZd,m3h3x12(:,42),heltab2x36(:,:,42))
  call Hloop_A_Q(ntryL,G0H12(22),16,0,G1H12(21),n2h12(6))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,43),heltab2x36(:,:,43))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(22),m3h3x12(:,44),heltab2x36(:,:,44))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(23),ngZd,m3h3x12(:,45),heltab2x36(:,:,45))
  call Hloop_A_Q(ntryL,G0H12(23),16,0,G1H12(23),n2h12(7))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(23),ngZd,m3h3x12(:,46),heltab2x36(:,:,46))
  call Hloop_A_Q(ntryL,G0H12(23),16,0,G1H12(24),n2h12(8))
  call Hloop_ST_V(ntryL,G1H12(1),16,ex3(:),4,G2H12(1),m3h1x12(:,1),heltab2x12(:,:,1))
  call Hloop_ST_V(ntryL,G1H12(2),16,ex3(:),4,G2H12(2),m3h1x12(:,2),heltab2x12(:,:,2))
  call Hloop_ST_V(ntryL,G0H12(1),16,ex3(:),4,G1H12(1),m3h1x12(:,3),heltab2x12(:,:,3))
  call Hloop_VS_V(ntryL,G0H12(2),ex3(:),G0H12(23),m3h1x12(:,4),heltab2x12(:,:,4))
  call Hloop_VS_V(ntryL,G0H12(3),ex3(:),G0H12(1),m3h1x12(:,5),heltab2x12(:,:,5))
  call Hloop_VS_V(ntryL,G1H12(3),ex3(:),G1H12(2),m3h1x12(:,6),heltab2x12(:,:,6))
  call Hloop_ZA_Q(ntryL,G0H12(4),ex2(:),G0H6(1),ngZu,m3h2x6(:,1),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(1),n2h6(1))
  call Hloop_WA_Q(ntryL,G0H12(5),ex2(:),G0H6(1),m3h2x6(:,2),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(2),n2h6(2))
  call Hloop_WA_Q(ntryL,G1H12(4),ex2(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G1H6(3),18,0,G2H6(1),n2h6(3))
  call Hloop_ZA_Q(ntryL,G0H12(6),ex2(:),G0H6(1),ngZu,m3h2x6(:,4),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(3),n2h6(4))
  call Hloop_WA_Q(ntryL,G0H12(7),ex2(:),G0H6(1),m3h2x6(:,5),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(4),n2h6(5))
  call Hloop_WA_Q(ntryL,G1H12(5),ex2(:),G1H6(5),m3h2x6(:,6),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H6(5),18,0,G2H6(2),n2h6(6))
  call Hloop_ST_V(ntryL,G1H12(6),16,ex3(:),4,G2H12(3),m3h1x12(:,7),heltab2x12(:,:,13))
  call Hloop_ST_V(ntryL,G1H12(7),16,ex3(:),4,G2H12(4),m3h1x12(:,8),heltab2x12(:,:,14))
  call Hloop_ST_V(ntryL,G0H12(8),16,ex3(:),4,G1H12(3),m3h1x12(:,9),heltab2x12(:,:,15))
  call Hloop_VS_V(ntryL,G0H12(9),ex3(:),G0H12(2),m3h1x12(:,10),heltab2x12(:,:,16))
  call Hloop_VS_V(ntryL,G0H12(10),ex3(:),G0H12(3),m3h1x12(:,11),heltab2x12(:,:,17))
  call Hloop_VS_V(ntryL,G1H12(8),ex3(:),G1H12(4),m3h1x12(:,12),heltab2x12(:,:,18))
  call Hloop_ZA_Q(ntryL,G0H12(11),ex2(:),G0H6(1),ngZu,m3h2x6(:,7),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(5),n2h6(7))
  call Hloop_WA_Q(ntryL,G0H12(12),ex2(:),G0H6(1),m3h2x6(:,8),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(6),n2h6(8))
  call Hloop_WA_Q(ntryL,G1H12(9),ex2(:),G1H6(7),m3h2x6(:,9),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G1H6(7),18,0,G2H6(3),n2h6(9))
  call Hloop_WA_Q(ntryL,G0H12(13),ex2(:),G0H6(1),m3h2x6(:,10),heltab2x12(:,:,22))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(7),n2h6(10))
  call Hloop_WA_Q(ntryL,G1H12(10),ex2(:),G1H6(8),m3h2x6(:,11),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H6(8),18,0,G2H6(4),n2h6(11))
  call Hloop_ZQ_A(ntryL,G0H12(14),ex1(:),G0H6(1),ngZu,m3h2x6(:,12),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(8),n2h6(12))
  call Hloop_WQ_A(ntryL,G0H12(15),ex1(:),G0H6(1),m3h2x6(:,13),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(9),n2h6(13))
  call Hloop_WQ_A(ntryL,G1H12(11),ex1(:),G1H6(10),m3h2x6(:,14),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H6(10),17,0,G2H6(5),n2h6(14))
  call Hloop_ZQ_A(ntryL,G0H12(16),ex1(:),G0H6(1),ngZu,m3h2x6(:,15),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(10),n2h6(15))
  call Hloop_WQ_A(ntryL,G0H12(17),ex1(:),G0H6(1),m3h2x6(:,16),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(11),n2h6(16))
  call Hloop_WQ_A(ntryL,G1H12(12),ex1(:),G1H6(12),m3h2x6(:,17),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(12),17,0,G2H6(6),n2h6(17))
  call Hloop_ZQ_A(ntryL,G0H12(18),ex1(:),G0H6(1),ngZu,m3h2x6(:,18),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(12),n2h6(18))
  call Hloop_WQ_A(ntryL,G0H12(19),ex1(:),G0H6(1),m3h2x6(:,19),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(13),n2h6(19))
  call Hloop_WQ_A(ntryL,G1H12(13),ex1(:),G1H6(14),m3h2x6(:,20),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(14),17,0,G2H6(7),n2h6(20))
  call Hloop_WQ_A(ntryL,G0H12(20),ex1(:),G0H6(1),m3h2x6(:,21),heltab2x12(:,:,33))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(14),n2h6(21))
  call Hloop_WQ_A(ntryL,G1H12(14),ex1(:),G1H6(15),m3h2x6(:,22),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G1H6(15),17,0,G2H6(8),n2h6(22))
  call Hloop_QA_Z(ntryL,G1H12(15),ex2(:),G1H6(15),ngZu,m3h2x6(:,23),heltab2x12(:,:,35))
  call Hloop_QA_W(ntryL,G1H12(16),ex2(:),G1H6(16),m3h2x6(:,24),heltab2x12(:,:,36))
  call Hloop_WA_Q(ntryL,G0H12(21),ex2(:),G0H6(1),m3h2x6(:,25),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G0H6(1),18,0,G1H6(17),n2h6(23))
  call Hloop_WA_Q(ntryL,G1H12(17),ex2(:),G1H6(18),m3h2x6(:,26),heltab2x12(:,:,38))
  call Hloop_A_Q(ntryL,G1H6(18),18,0,G2H6(9),n2h6(24))
  call Hloop_AQ_Z(ntryL,G1H12(18),ex1(:),G1H6(18),ngZu,m3h2x6(:,27),heltab2x12(:,:,39))
  call Hloop_AQ_W(ntryL,G1H12(19),ex1(:),G1H6(19),m3h2x6(:,28),heltab2x12(:,:,40))
  call Hloop_AQ_W(ntryL,G1H12(20),ex1(:),G1H6(20),m3h2x6(:,29),heltab2x12(:,:,41))
  call Hloop_AQ_W(ntryL,G1H12(21),ex1(:),G1H6(21),m3h2x6(:,30),heltab2x12(:,:,42))
  call Hloop_WQ_A(ntryL,G0H12(22),ex1(:),G0H6(1),m3h2x6(:,31),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G0H6(1),17,0,G1H6(22),n2h6(25))
  call Hloop_WQ_A(ntryL,G1H12(22),ex1(:),G1H6(23),m3h2x6(:,32),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H6(23),17,0,G2H6(10),n2h6(26))
  call Hloop_AQ_W(ntryL,G1H12(23),ex1(:),G1H6(23),m3h2x6(:,33),heltab2x12(:,:,45))
  call Hloop_AQ_W(ntryL,G1H12(24),ex1(:),G1H6(24),m3h2x6(:,34),heltab2x12(:,:,46))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(1),[G0H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(2),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(3)])
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(1),mass5set(:,1),  & 
G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),12)
  call HG1shiftOLR(G1H12(6),8,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(1),mass5set(:,2),  & 
G1H12(11),G1H12(12),G1H12(13),G1H12(14),G1H12(15),G1H12(16),12)
  call HG1shiftOLR(G1H12(12),8,12)
  call Hloop_WQ_A(ntryL,G1H12(2),ex1(:),G1H6(25),m3h2x6(:,35),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G1H6(25),21,0,G2H6(11),n2h6(27))
  call Hloop_AQ_Z(ntryL,G1H6(1),ex1(:),G1H3(1),ngZu,m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_AQ_W(ntryL,G1H6(2),ex1(:),G1H3(2),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_AQ_W(ntryL,G2H6(1),ex1(:),G2H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_AQ_Z(ntryL,G1H6(3),ex1(:),G1H3(3),ngZu,m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_AQ_W(ntryL,G1H6(4),ex1(:),G1H3(4),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_AQ_W(ntryL,G2H6(2),ex1(:),G2H3(2),m3h2x3(:,6),heltab2x6(:,:,6))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(2),mass5set(:,1),  & 
G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(21),G1H12(22),12)
  call HG1shiftOLR(G1H12(18),8,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(2),mass5set(:,2),  & 
G1H12(23),G1H12(24),G1H12(1),G1H12(3),G1H12(2),G1H12(25),12)
  call HG1shiftOLR(G1H12(24),8,12)
  call Hloop_WA_Q(ntryL,G1H12(4),ex2(:),G1H6(25),m3h2x6(:,36),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H6(25),22,0,G2H6(1),n2h6(28))
  call Hloop_AQ_Z(ntryL,G1H6(5),ex1(:),G1H3(5),ngZu,m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_AQ_W(ntryL,G1H6(6),ex1(:),G1H3(6),m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_AQ_W(ntryL,G2H6(3),ex1(:),G2H3(3),m3h2x3(:,9),heltab2x6(:,:,9))
  call Hloop_AQ_W(ntryL,G1H6(7),ex1(:),G1H3(7),m3h2x3(:,10),heltab2x6(:,:,10))
  call Hloop_AQ_W(ntryL,G2H6(4),ex1(:),G2H3(4),m3h2x3(:,11),heltab2x6(:,:,11))
  call Hloop_QA_Z(ntryL,G1H6(8),ex2(:),G1H3(8),ngZu,m3h2x3(:,12),heltab2x6(:,:,12))
  call Hloop_QA_W(ntryL,G1H6(9),ex2(:),G1H3(9),m3h2x3(:,13),heltab2x6(:,:,13))
  call Hloop_QA_W(ntryL,G2H6(5),ex2(:),G2H3(5),m3h2x3(:,14),heltab2x6(:,:,14))
  call Hloop_QA_Z(ntryL,G1H6(10),ex2(:),G1H3(10),ngZu,m3h2x3(:,15),heltab2x6(:,:,15))
  call Hloop_QA_W(ntryL,G1H6(11),ex2(:),G1H3(11),m3h2x3(:,16),heltab2x6(:,:,16))
  call Hloop_QA_W(ntryL,G2H6(6),ex2(:),G2H3(6),m3h2x3(:,17),heltab2x6(:,:,17))
  call Hloop_QA_Z(ntryL,G1H6(12),ex2(:),G1H3(12),ngZu,m3h2x3(:,18),heltab2x6(:,:,18))
  call Hloop_QA_W(ntryL,G1H6(13),ex2(:),G1H3(13),m3h2x3(:,19),heltab2x6(:,:,19))
  call Hloop_QA_W(ntryL,G2H6(7),ex2(:),G2H3(7),m3h2x3(:,20),heltab2x6(:,:,20))
  call Hloop_QA_W(ntryL,G1H6(14),ex2(:),G1H3(14),m3h2x3(:,21),heltab2x6(:,:,21))
  call Hloop_QA_W(ntryL,G2H6(8),ex2(:),G2H3(8),m3h2x3(:,22),heltab2x6(:,:,22))
  call Hloop_VS_V(ntryL,G1H6(15),ex3(:),G1H6(1),m3h1x6(:,1),heltab2x6(:,:,23))
  call Hloop_VS_V(ntryL,G1H6(16),ex3(:),G1H6(2),m3h1x6(:,2),heltab2x6(:,:,24))
  call Hloop_AZ_Q(ntryL,G1H6(17),ex4(:),G1H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),26,0,G2H2(1),n2h2(1))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(3),mass5set(:,3),  & 
G1H6(3),G1H6(4),G1H6(25),G1H6(5),G1H6(6),G1H6(7),6)
  call HG1shiftOLR(G1H6(4),4,6)
  call Hloop_VS_V(ntryL,G1H6(18),ex3(:),G1H6(8),m3h1x6(:,3),heltab2x6(:,:,26))
  call Hloop_VS_V(ntryL,G1H6(19),ex3(:),G1H6(9),m3h1x6(:,4),heltab2x6(:,:,27))
  call Hloop_VT_S(ntryL,G1H6(20),17,ex3(:),4,G2H6(2),m3h1x6(:,5),heltab2x6(:,:,28))
  call Hloop_VS_V(ntryL,G1H6(21),ex3(:),G1H6(10),m3h1x6(:,6),heltab2x6(:,:,29))
  call Hloop_QZ_A(ntryL,G1H6(22),ex4(:),G1H2(1),ngZd,m3h3x2(:,2),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),25,0,G2H2(2),n2h2(2))
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(4),mass5set(:,3),  & 
G1H6(11),G1H6(12),G1H6(13),G1H6(14),G1H6(15),G1H6(16),6)
  call HG1shiftOLR(G1H6(12),4,6)
  call Hloop_VV_S(ntryL,G1H6(23),ex4(:),G1H2(1),m3h3x2(:,3),heltab2x6(:,:,31))
  call Hloop_UW_V(ntryL,G1H6(24),17,ex4(:),8,G2H2(3),m3h3x2(:,4),heltab2x6(:,:,32))
  call Hloop_ZQ_A(ntryL,G1H12(5),ex1(:),G1H6(17),ngZu,m3h2x6(:,37),heltab2x12(:,:,49))
  call Hloop_Q_A(ntryL,G1H6(17),21,0,G2H6(3),n2h6(29))
call HGT_OLR(G1H12(6),1,1,12)
call HGT_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(6),ex4(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,50))
  call Hloop_ZQ_A(ntryL,G1H12(8),ex1(:),G1H6(18),ngZu,m3h2x6(:,38),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G1H6(18),21,0,G2H6(4),n2h6(30))
  call Hloop_ZQ_A(ntryL,G1H12(9),ex1(:),G1H6(19),ngZu,m3h2x6(:,39),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H6(19),21,0,G2H6(5),n2h6(31))
  call Hloop_ZQ_A(ntryL,G1H12(10),ex1(:),G1H6(20),ngZu,m3h2x6(:,40),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H6(20),21,0,G2H6(6),n2h6(32))
  call Hloop_WQ_A(ntryL,G1H12(11),ex1(:),G1H6(21),m3h2x6(:,41),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H6(21),21,0,G2H6(7),n2h6(33))
call HGT_OLR(G1H12(12),1,1,12)
call HGT_invQ_OLR(G1H12(12),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(12),ex4(:),G1H4(2),m3h3x4(:,2),heltab2x12(:,:,55))
  call Hloop_WQ_A(ntryL,G1H12(14),ex1(:),G1H6(22),m3h2x6(:,42),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H6(22),21,0,G2H6(8),n2h6(34))
  call Hloop_WQ_A(ntryL,G1H12(15),ex1(:),G1H6(23),m3h2x6(:,43),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(23),21,0,G2H6(9),n2h6(35))
  call Hloop_WQ_A(ntryL,G1H12(16),ex1(:),G1H6(24),m3h2x6(:,44),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H6(24),21,0,G2H6(10),n2h6(36))
  call Hloop_ZA_Q(ntryL,G1H12(17),ex2(:),G1H6(17),ngZu,m3h2x6(:,45),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G1H6(17),22,0,G2H6(12),n2h6(37))
call HGT_OLR(G1H12(18),1,1,12)
call HGT_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(18),ex4(:),G1H4(3),m3h3x4(:,3),heltab2x12(:,:,60))
  call Hloop_ZA_Q(ntryL,G1H12(20),ex2(:),G1H6(18),ngZu,m3h2x6(:,46),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(18),22,0,G2H6(13),n2h6(38))
  call Hloop_ZA_Q(ntryL,G1H12(21),ex2(:),G1H6(19),ngZu,m3h2x6(:,47),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(14),n2h6(39))
  call Hloop_ZA_Q(ntryL,G1H12(22),ex2(:),G1H6(20),ngZu,m3h2x6(:,48),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(20),22,0,G2H6(15),n2h6(40))
  call Hloop_WA_Q(ntryL,G1H12(23),ex2(:),G1H6(21),m3h2x6(:,49),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(16),n2h6(41))
call HGT_OLR(G1H12(24),1,1,12)
call HGT_invQ_OLR(G1H12(24),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(24),ex4(:),G1H4(4),m3h3x4(:,4),heltab2x12(:,:,65))
  call Hloop_WA_Q(ntryL,G1H12(3),ex2(:),G1H6(22),m3h2x6(:,50),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H6(22),22,0,G2H6(17),n2h6(42))
  call Hloop_WA_Q(ntryL,G1H12(2),ex2(:),G1H6(23),m3h2x6(:,51),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(23),22,0,G2H6(18),n2h6(43))
  call Hloop_WA_Q(ntryL,G1H12(25),ex2(:),G1H6(24),m3h2x6(:,52),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H6(24),22,0,G2H6(19),n2h6(44))
  call Hloop_AZ_Q(ntryL,G1H6(3),ex4(:),G1H2(2),ngZd,m3h3x2(:,5),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(2),26,0,G2H2(4),n2h2(3))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(4),ex3(:),G1H6(17),m3h1x6(:,7),heltab2x6(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H6(5),ex4(:),G1H2(2),ngZd,m3h3x2(:,6),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(2),26,0,G2H2(5),n2h2(4))
  call Hloop_AZ_Q(ntryL,G1H6(6),ex4(:),G1H2(2),ngZd,m3h3x2(:,7),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(2),26,0,G2H2(6),n2h2(5))
  call Hloop_AZ_Q(ntryL,G1H6(7),ex4(:),G1H2(2),ngZd,m3h3x2(:,8),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(2),26,0,G2H2(7),n2h2(6))
  call Hloop_QZ_A(ntryL,G1H6(11),ex4(:),G1H2(2),ngZd,m3h3x2(:,9),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(2),25,0,G2H2(8),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(12),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_VS_V(ntryL,G1H6(12),ex3(:),G1H6(18),m3h1x6(:,8),heltab2x6(:,:,39))
  call Hloop_QZ_A(ntryL,G1H6(14),ex4(:),G1H2(2),ngZd,m3h3x2(:,10),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(2),25,0,G2H2(9),n2h2(8))
  call Hloop_QZ_A(ntryL,G1H6(15),ex4(:),G1H2(2),ngZd,m3h3x2(:,11),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(2),25,0,G2H2(10),n2h2(9))
  call Hloop_QZ_A(ntryL,G1H6(16),ex4(:),G1H2(2),ngZd,m3h3x2(:,12),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(2),25,0,G2H2(11),n2h2(10))
  call Hloop_QA_W(ntryL,G2H6(11),ex2(:),G2H3(9),m3h2x3(:,23),heltab2x6(:,:,43))
  call Hloop_VT_S(ntryL,G1H3(1),19,ex3(:),4,G2H3(10),m3h1x3(:,1),heltab2x3(:,:,1))
  call Hloop_VT_S(ntryL,G1H3(2),19,ex3(:),4,G2H3(11),m3h1x3(:,2),heltab2x3(:,:,2))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(5),mass5set(:,4),  & 
G1H3(1),G1H3(2),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hloop_VS_V(ntryL,G1H3(3),ex3(:),G1H3(19),m3h1x3(:,3),heltab2x3(:,:,3))
  call Hloop_VS_V(ntryL,G1H3(4),ex3(:),G1H3(3),m3h1x3(:,4),heltab2x3(:,:,4))
  call Hloop_VS_V(ntryL,G2H3(2),ex3(:),G2H3(1),m3h1x3(:,5),heltab2x3(:,:,5))
  call Hloop_AQ_W(ntryL,G2H6(1),ex1(:),G2H3(2),m3h2x3(:,24),heltab2x6(:,:,44))
  call Hloop_VV_S(ntryL,G1H3(5),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,6))
  call Hloop_VV_S(ntryL,G1H3(6),ex4(:),G1H1(2),m3h3x1(:,2),heltab2x3(:,:,7))
  call Hloop_VV_S(ntryL,G2H3(3),ex4(:),G2H1(1),m3h3x1(:,3),heltab2x3(:,:,8))
  call Hloop_UW_V(ntryL,G1H3(7),19,ex4(:),8,G2H1(2),m3h3x1(:,4),heltab2x3(:,:,9))
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(6),mass5set(:,4),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(20),G1H3(21),3)
  call HG1shiftOLR(G1H3(5),4,3)
  call Hloop_VT_S(ntryL,G1H3(8),19,ex3(:),4,G2H3(3),m3h1x3(:,6),heltab2x3(:,:,10))
  call Hloop_VT_S(ntryL,G1H3(9),19,ex3(:),4,G2H3(4),m3h1x3(:,7),heltab2x3(:,:,11))
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(7),mass5set(:,4),  & 
G1H3(8),G1H3(9),G1H3(22),G1H3(23),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(9),8,3)
  call Hloop_VS_V(ntryL,G1H3(10),ex3(:),G1H3(26),m3h1x3(:,8),heltab2x3(:,:,12))
  call Hloop_VS_V(ntryL,G1H3(11),ex3(:),G1H3(10),m3h1x3(:,9),heltab2x3(:,:,13))
  call Hloop_VS_V(ntryL,G2H3(6),ex3(:),G2H3(5),m3h1x3(:,10),heltab2x3(:,:,14))
  call Hloop_VV_S(ntryL,G1H3(12),ex4(:),G1H1(3),m3h3x1(:,5),heltab2x3(:,:,15))
  call Hloop_VV_S(ntryL,G1H3(13),ex4(:),G1H1(4),m3h3x1(:,6),heltab2x3(:,:,16))
  call Hloop_VV_S(ntryL,G2H3(7),ex4(:),G2H1(3),m3h3x1(:,7),heltab2x3(:,:,17))
  call Hloop_UV_W(ntryL,G1H3(14),19,ex4(:),8,G2H1(4),m3h3x1(:,8),heltab2x3(:,:,18))
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(8),mass5set(:,4),  & 
G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(12),4,3)
  call Hloop_ZQ_A(ntryL,G1H6(1),ex1(:),G1H3(29),ngZu,m3h2x3(:,25),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(29),23,0,G2H3(6),n2h3(1))
  call Hloop_WQ_A(ntryL,G1H6(2),ex1(:),G1H3(29),m3h2x3(:,26),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H3(29),23,0,G2H3(7),n2h3(2))
  call Hloop_AQ_W(ntryL,G2H2(1),ex1(:),G2H1(5),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_ZA_Q(ntryL,G1H6(8),ex2(:),G1H3(29),ngZu,m3h2x3(:,27),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(29),23,0,G2H3(8),n2h3(3))
  call Hloop_WA_Q(ntryL,G1H6(9),ex2(:),G1H3(29),m3h2x3(:,28),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(29),23,0,G2H3(12),n2h3(4))
  call Hloop_SV_V(ntryL,G2H6(2),ex4(:),G2H2(1),m3h3x2(:,13),heltab2x6(:,:,49))
  call Hloop_UW_V(ntryL,G1H6(10),21,ex4(:),8,G2H2(12),m3h3x2(:,14),heltab2x6(:,:,50))
  call Hloop_QA_W(ntryL,G2H2(2),ex2(:),G2H1(6),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_ST_V(ntryL,G1H2(1),25,ex3(:),4,G2H2(2),m3h1x2(:,1),heltab2x2(:,:,3))
  call Hloop_VS_V(ntryL,G2H2(3),ex3(:),G2H2(13),m3h1x2(:,2),heltab2x2(:,:,4))
  call Hloop_QA_Z(ntryL,G2H6(3),ex2(:),G2H3(13),ngZu,m3h2x3(:,29),heltab2x6(:,:,51))
  call Hloop_QA_Z(ntryL,G2H6(5),ex2(:),G2H3(14),ngZu,m3h2x3(:,30),heltab2x6(:,:,52))
  call Hloop_QA_Z(ntryL,G2H6(6),ex2(:),G2H3(15),ngZu,m3h2x3(:,31),heltab2x6(:,:,53))
  call Hloop_QA_W(ntryL,G2H6(7),ex2(:),G2H3(16),m3h2x3(:,32),heltab2x6(:,:,54))
  call Hloop_QA_W(ntryL,G2H6(9),ex2(:),G2H3(17),m3h2x3(:,33),heltab2x6(:,:,55))
  call Hloop_QA_W(ntryL,G2H6(10),ex2(:),G2H3(18),m3h2x3(:,34),heltab2x6(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H6(12),ex1(:),G2H3(19),ngZu,m3h2x3(:,35),heltab2x6(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H6(14),ex1(:),G2H3(20),ngZu,m3h2x3(:,36),heltab2x6(:,:,58))
  call Hloop_AQ_Z(ntryL,G2H6(15),ex1(:),G2H3(21),ngZu,m3h2x3(:,37),heltab2x6(:,:,59))
  call Hloop_AQ_W(ntryL,G2H6(16),ex1(:),G2H3(22),m3h2x3(:,38),heltab2x6(:,:,60))
  call Hloop_AQ_W(ntryL,G2H6(18),ex1(:),G2H3(23),m3h2x3(:,39),heltab2x6(:,:,61))
  call Hloop_AQ_W(ntryL,G2H6(19),ex1(:),G2H3(24),m3h2x3(:,40),heltab2x6(:,:,62))
  call Hloop_AQ_W(ntryL,G2H2(4),ex1(:),G2H1(7),m3h2x1(:,3),heltab2x2(:,:,5))
  call Hloop_AQ_W(ntryL,G2H2(6),ex1(:),G2H1(8),m3h2x1(:,4),heltab2x2(:,:,6))
  call Hloop_AQ_W(ntryL,G2H2(7),ex1(:),G2H1(9),m3h2x1(:,5),heltab2x2(:,:,7))
  call Hloop_QA_W(ntryL,G2H2(8),ex2(:),G2H1(10),m3h2x1(:,6),heltab2x2(:,:,8))
  call Hloop_QA_W(ntryL,G2H2(10),ex2(:),G2H1(11),m3h2x1(:,7),heltab2x2(:,:,9))
  call Hloop_QA_W(ntryL,G2H2(11),ex2(:),G2H1(12),m3h2x1(:,8),heltab2x2(:,:,10))
  call Hloop_VT_S(ntryL,G1H3(1),19,ex3(:),4,G2H3(25),m3h1x3(:,11),heltab2x3(:,:,19))
call HGT_raise_alpha_OLR(G1H3(2),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(2),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(2),ex4(:),G1H1(5),m3h3x1(:,9),heltab2x3(:,:,20))
  call Hloop_VT_S(ntryL,G1H3(17),19,ex3(:),4,G2H3(26),m3h1x3(:,12),heltab2x3(:,:,21))
  call Hloop_VT_S(ntryL,G1H3(18),19,ex3(:),4,G2H3(27),m3h1x3(:,13),heltab2x3(:,:,22))
  call Hloop_UW_V(ntryL,G1H3(4),19,ex4(:),8,G2H1(13),m3h3x1(:,10),heltab2x3(:,:,23))
call HGT_raise_alpha_OLR(G1H3(5),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(5),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(5),ex3(:),G1H3(29),m3h1x3(:,14),heltab2x3(:,:,24))
  call Hloop_UW_V(ntryL,G1H3(20),19,ex4(:),8,G2H1(14),m3h3x1(:,11),heltab2x3(:,:,25))
  call Hloop_UW_V(ntryL,G1H3(21),19,ex4(:),8,G2H1(15),m3h3x1(:,12),heltab2x3(:,:,26))
  call Hloop_VT_S(ntryL,G1H3(8),19,ex3(:),4,G2H3(28),m3h1x3(:,15),heltab2x3(:,:,27))
call HGT_raise_alpha_OLR(G1H3(9),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(9),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(9),ex4(:),G1H1(6),m3h3x1(:,13),heltab2x3(:,:,28))
  call Hloop_VT_S(ntryL,G1H3(24),19,ex3(:),4,G2H3(29),m3h1x3(:,16),heltab2x3(:,:,29))
  call Hloop_VT_S(ntryL,G1H3(25),19,ex3(:),4,G2H3(30),m3h1x3(:,17),heltab2x3(:,:,30))
  call Hloop_UV_W(ntryL,G1H3(11),19,ex4(:),8,G2H1(16),m3h3x1(:,14),heltab2x3(:,:,31))
call HGT_raise_alpha_OLR(G1H3(12),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(12),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(12),ex3(:),G1H3(1),m3h1x3(:,18),heltab2x3(:,:,32))
  call Hloop_UV_W(ntryL,G1H3(27),19,ex4(:),8,G2H1(17),m3h3x1(:,15),heltab2x3(:,:,33))
  call Hloop_UV_W(ntryL,G1H3(28),19,ex4(:),8,G2H1(18),m3h3x1(:,16),heltab2x3(:,:,34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(2)])
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(1),mass5set(:,2),  & 
G1H3(2),G1H3(17),G1H3(18),G1H3(4),G1H3(5),G1H3(20),3)
  call HG1shiftOLR(G1H3(17),8,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(5),mass5set(:,5),  & 
G1H3(21),G1H3(8),G1H3(9),G1H3(24),G1H3(25),G1H3(11),3)
  call HG1shiftOLR(G1H3(8),8,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(5),mass5set(:,4),  & 
G1H3(12),G1H3(27),G1H3(28),G1H3(30),G1H3(31),G1H3(32),3)
  call HG1shiftOLR(G1H3(27),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(19),ex4(:),G1tensor(1),m3h3x1(:,17),heltab2x3(:,:,35))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(3),ex4(:),G1tensor(2),m3h3x1(:,18),heltab2x3(:,:,36))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(5),mass5set(:,4),  & 
G1H3(19),G1H3(3),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(3),8,3)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(2),mass5set(:,2),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),8,3)
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(1),ex3(:),G1tensor(3),m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(2),ex3(:),G1tensor(4),m3h1x1(:,2),heltab2x1(:,:,2))
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(6),mass5set(:,4),  & 
G1H1(1),G1H1(2),G1H1(7),G1H1(8),G1H1(9),G1H1(10),1)
  call HG1shiftOLR(G1H1(2),4,1)
  call Hotf_5pt_reduction(G2H1(2),RedSet_5(6),mass5set(:,4),  & 
G1H1(11),G1H1(12),G1H1(13),G1H1(14),G1H1(15),G1H1(16),1)
  call HG1shiftOLR(G1H1(12),4,1)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(7),mass5set(:,5),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),8,3)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(7),mass5set(:,4),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(26),ex4(:),G1tensor(5),m3h3x1(:,19),heltab2x3(:,:,37))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(10),ex4(:),G1tensor(6),m3h3x1(:,20),heltab2x3(:,:,38))
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(7),mass5set(:,4),  & 
G1H3(26),G1H3(10),G1H3(55),G1H3(56),G1H3(57),G1H3(58),3)
  call HG1shiftOLR(G1H3(10),8,3)
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(3),ex3(:),G1tensor(7),m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(4),ex3(:),G1tensor(8),m3h1x1(:,4),heltab2x1(:,:,4))
  call Hotf_5pt_reduction(G2H1(3),RedSet_5(8),mass5set(:,4),  & 
G1H1(3),G1H1(4),G1H1(17),G1H1(18),G1H1(19),G1H1(20),1)
  call HG1shiftOLR(G1H1(4),4,1)
  call Hotf_5pt_reduction(G2H1(4),RedSet_5(8),mass5set(:,4),  & 
G1H1(21),G1H1(22),G1H1(23),G1H1(24),G1H1(25),G1H1(26),1)
  call HG1shiftOLR(G1H1(22),4,1)
  call Hotf_5pt_reduction(G2H3(6),RedSet_5(9),mass5set(:,6),  & 
G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),G1H3(64),3)
  call HG1shiftOLR(G1H3(60),8,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(9),mass5set(:,7),  & 
G1H3(65),G1H3(66),G1H3(67),G1H3(68),G1H3(69),G1H3(70),3)
  call HG1shiftOLR(G1H3(66),8,3)
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(3),mass5set(:,3),  & 
G1H1(27),G1H1(28),G1H1(29),G1H1(30),G1H1(31),G1H1(32),1)
  call HG1shiftOLR(G1H1(28),4,1)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(10),mass5set(:,6),  & 
G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),3)
  call HG1shiftOLR(G1H3(72),8,3)
  call Hotf_5pt_reduction(G2H3(12),RedSet_5(10),mass5set(:,7),  & 
G1H3(77),G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),3)
  call HG1shiftOLR(G1H3(78),8,3)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(11),mass5set(:,8),  & 
G1H2(2),G1H2(1),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hotf_5pt_reduction(G2H1(6),RedSet_5(4),mass5set(:,3),  & 
G1H1(33),G1H1(34),G1H1(35),G1H1(36),G1H1(37),G1H1(38),1)
  call HG1shiftOLR(G1H1(34),4,1)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(12),mass5set(:,8),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(13),ex4(:),G2tensor(1),m3h3x1(:,21),heltab2x3(:,:,39))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(15),ex4(:),G2tensor(2),m3h3x1(:,22),heltab2x3(:,:,40))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(16),ex4(:),G2tensor(3),m3h3x1(:,23),heltab2x3(:,:,41))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(18),ex4(:),G2tensor(4),m3h3x1(:,24),heltab2x3(:,:,42))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(19),ex4(:),G2tensor(5),m3h3x1(:,25),heltab2x3(:,:,43))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(21),ex4(:),G2tensor(6),m3h3x1(:,26),heltab2x3(:,:,44))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(22),ex4(:),G2tensor(7),m3h3x1(:,27),heltab2x3(:,:,45))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(24),ex4(:),G2tensor(8),m3h3x1(:,28),heltab2x3(:,:,46))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(7),ex3(:),G2tensor(9),m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(9),ex3(:),G2tensor(10),m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex3(:),G2tensor(11),m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(12),ex3(:),G2tensor(12),m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(25),ex4(:),G2tensor(13),m3h3x1(:,29),heltab2x3(:,:,47))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(27),ex4(:),G2tensor(14),m3h3x1(:,30),heltab2x3(:,:,48))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(13),ex3(:),G2tensor(15),m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(15),ex3(:),G2tensor(16),m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(28),ex4(:),G2tensor(17),m3h3x1(:,31),heltab2x3(:,:,49))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(30),ex4(:),G2tensor(18),m3h3x1(:,32),heltab2x3(:,:,50))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(19),m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(20),m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(2),23,ex4(:),8,G2tensor(21),m3h3x1(:,33),heltab2x3(:,:,51))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(17),0,ex4(:),8,G2tensor(22),m3h3x1(:,34),heltab2x3(:,:,52))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(20),23,ex4(:),8,G2tensor(23),m3h3x1(:,35),heltab2x3(:,:,53))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(21),23,ex4(:),8,G2tensor(24),m3h3x1(:,36),heltab2x3(:,:,54))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(8),0,ex4(:),8,G2tensor(25),m3h3x1(:,37),heltab2x3(:,:,55))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(11),23,ex4(:),8,G2tensor(26),m3h3x1(:,38),heltab2x3(:,:,56))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(12),23,ex4(:),8,G2tensor(27),m3h3x1(:,39),heltab2x3(:,:,57))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(27),0,ex4(:),8,G2tensor(28),m3h3x1(:,40),heltab2x3(:,:,58))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(32),23,ex4(:),8,G2tensor(29),m3h3x1(:,41),heltab2x3(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(19),23,ex4(:),8,G2tensor(30),m3h3x1(:,42),heltab2x3(:,:,60))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(3),0,ex4(:),8,G2tensor(31),m3h3x1(:,43),heltab2x3(:,:,61))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(36),23,ex4(:),8,G2tensor(32),m3h3x1(:,44),heltab2x3(:,:,62))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(37),23,ex4(:),8,G2tensor(33),m3h3x1(:,45),heltab2x3(:,:,63))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(38),0,ex4(:),8,G2tensor(34),m3h3x1(:,46),heltab2x3(:,:,64))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(42),23,ex4(:),8,G2tensor(35),m3h3x1(:,47),heltab2x3(:,:,65))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(1),27,ex3(:),4,G2tensor(36),m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(2),0,ex3(:),4,G2tensor(37),m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(10),27,ex3(:),4,G2tensor(38),m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(11),27,ex3(:),4,G2tensor(39),m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(12),0,ex3(:),4,G2tensor(40),m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(16),27,ex3(:),4,G2tensor(41),m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(43),23,ex4(:),8,G2tensor(42),m3h3x1(:,48),heltab2x3(:,:,66))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(44),0,ex4(:),8,G2tensor(43),m3h3x1(:,49),heltab2x3(:,:,67))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(48),23,ex4(:),8,G2tensor(44),m3h3x1(:,50),heltab2x3(:,:,68))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(49),23,ex4(:),8,G2tensor(45),m3h3x1(:,51),heltab2x3(:,:,69))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(50),0,ex4(:),8,G2tensor(46),m3h3x1(:,52),heltab2x3(:,:,70))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(54),23,ex4(:),8,G2tensor(47),m3h3x1(:,53),heltab2x3(:,:,71))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(26),23,ex4(:),8,G2tensor(48),m3h3x1(:,54),heltab2x3(:,:,72))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(10),0,ex4(:),8,G2tensor(49),m3h3x1(:,55),heltab2x3(:,:,73))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(58),23,ex4(:),8,G2tensor(50),m3h3x1(:,56),heltab2x3(:,:,74))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(3),27,ex3(:),4,G2tensor(51),m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(4),0,ex3(:),4,G2tensor(52),m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(53),m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(21),27,ex3(:),4,G2tensor(54),m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(22),0,ex3(:),4,G2tensor(55),m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(26),27,ex3(:),4,G2tensor(56),m3h1x1(:,24),heltab2x1(:,:,24))
  call Hloop_QZ_A(ntryL,G1H3(59),ex4(:),G1H1(1),ngZu,m3h3x1(:,57),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H3(60),ex4(:),G1H1(2),ngZu,m3h3x1(:,58),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),8,0,G2tensor(58),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H3(64),ex4(:),G1H1(10),ngZu,m3h3x1(:,59),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,0,G2tensor(59),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H3(65),ex4(:),G1H1(11),ngZd,m3h3x1(:,60),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),31,0,G2tensor(60),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H3(66),ex4(:),G1H1(12),ngZd,m3h3x1(:,61),heltab2x3(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),8,0,G2tensor(61),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H3(70),ex4(:),G1H1(16),ngZd,m3h3x1(:,62),heltab2x3(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),31,0,G2tensor(62),n2h1(18))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(27),27,ex3(:),4,G2tensor(63),m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(28),0,ex3(:),4,G2tensor(64),m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(32),27,ex3(:),4,G2tensor(65),m3h1x1(:,27),heltab2x1(:,:,27))
  call Hloop_AZ_Q(ntryL,G1H3(71),ex4(:),G1H1(3),ngZu,m3h3x1(:,63),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),31,0,G2tensor(66),n2h1(20))
  call Hloop_AZ_Q(ntryL,G1H3(72),ex4(:),G1H1(4),ngZu,m3h3x1(:,64),heltab2x3(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),8,0,G2tensor(67),n2h1(21))
  call Hloop_AZ_Q(ntryL,G1H3(76),ex4(:),G1H1(20),ngZu,m3h3x1(:,65),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,0,G2tensor(68),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(77),ex4(:),G1H1(21),ngZd,m3h3x1(:,66),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,0,G2tensor(69),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(78),ex4(:),G1H1(22),ngZd,m3h3x1(:,67),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),8,0,G2tensor(70),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(82),ex4(:),G1H1(26),ngZd,m3h3x1(:,68),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),31,0,G2tensor(71),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(26))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(2),m3h2x1(:,10),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),2,0,G2tensor(73),n2h1(27))
  call Hloop_WA_Q(ntryL,G1H2(6),ex2(:),G1H1(10),m3h2x1(:,11),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,0,G2tensor(74),n2h1(28))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(33),27,ex3(:),4,G2tensor(75),m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(34),0,ex3(:),4,G2tensor(76),m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(38),27,ex3(:),4,G2tensor(77),m3h1x1(:,30),heltab2x1(:,:,30))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(11),m3h2x1(:,12),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),31,0,G2tensor(78),n2h1(30))
  call Hloop_WA_Q(ntryL,G1H2(8),ex2(:),G1H1(12),m3h2x1(:,13),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),2,0,G2tensor(79),n2h1(31))
  call Hloop_WA_Q(ntryL,G1H2(12),ex2(:),G1H1(16),m3h2x1(:,14),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,0,G2tensor(80),n2h1(32))
  call ol_merge_tensors(G2tensor(24),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(27),G2tensor(13),G1tensor(2)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(36),G2tensor(15),G1tensor(4)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(45),G2tensor(17),G1tensor(6)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(51),G2tensor(19),G1tensor(8)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(11)])
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(5),mass5set(:,5),  & 
G1tensor(1),G1tensor(2),G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(8))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(5),mass5set(:,4),  & 
G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14))
  call G_TensorShift(G1tensor(10),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(6),mass5set(:,4),  & 
G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(16),4)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(7),mass5set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25),G1tensor(26))
  call G_TensorShift(G1tensor(22),8)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(7),mass5set(:,4),  & 
G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30),G1tensor(31),G1tensor(32))
  call G_TensorShift(G1tensor(28),8)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(8),mass5set(:,4),  & 
G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36),G1tensor(37),G1tensor(38))
  call G_TensorShift(G1tensor(34),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44))
  call G_TensorShift(G1tensor(40),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(1),mass5set(:,2),  & 
G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(46),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55),G1tensor(56))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(2),mass5set(:,2),  & 
G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60),G1tensor(61),G1tensor(62))
  call G_TensorShift(G1tensor(58),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(3),mass5set(:,3),  & 
G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66),G1tensor(67),G1tensor(68))
  call G_TensorShift(G1tensor(64),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(4),mass5set(:,3),  & 
G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74))
  call G_TensorShift(G1tensor(70),4)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(9),mass5set(:,6),  & 
G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(76),8)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(9),mass5set(:,7),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85),G1tensor(86))
  call G_TensorShift(G1tensor(82),8)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(10),mass5set(:,6),  & 
G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90),G1tensor(91),G1tensor(92))
  call G_TensorShift(G1tensor(88),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(10),mass5set(:,7),  & 
G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96),G1tensor(97),G1tensor(98))
  call G_TensorShift(G1tensor(94),8)
  call Hotf_5pt_reduction_last(G2tensor(72),RedSet_5(11),mass5set(:,8),  & 
G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104))
  call G_TensorShift(G1tensor(100),2)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(12),mass5set(:,8),  & 
G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(106),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(9)])
  call ol_merge_tensors(T1sum(3),[G1tensor(3)])
  call ol_merge_tensors(T1sum(4),[G1tensor(15)])
  call ol_merge_tensors(T1sum(5),[G1tensor(21)])
  call ol_merge_tensors(T1sum(6),[G1tensor(27)])
  call ol_merge_tensors(T1sum(7),[G1tensor(7)])
  call ol_merge_tensors(T1sum(8),[G1tensor(33)])
  call ol_merge_tensors(T1sum(9),[G1tensor(39)])
  call ol_merge_tensors(T1sum(10),[G1tensor(45)])
  call ol_merge_tensors(T1sum(11),[G1tensor(51)])
  call ol_merge_tensors(T1sum(12),[G1tensor(57)])
  call ol_merge_tensors(T1sum(13),[G1tensor(63)])
  call ol_merge_tensors(T1sum(14),[G1tensor(69)])
  call ol_merge_tensors(T1sum(15),[G1tensor(75)])
  call ol_merge_tensors(T1sum(16),[G1tensor(81)])
  call ol_merge_tensors(T1sum(17),[G1tensor(87)])
  call ol_merge_tensors(T1sum(18),[G1tensor(93)])
  call ol_merge_tensors(T1sum(19),[G1tensor(99)])
  call ol_merge_tensors(T1sum(20),[G1tensor(105)])
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(1),m4h3x3x4(:,1),heltab3x36(:,:,1))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(2),m4h3x3x4(:,2),heltab3x36(:,:,2))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[20,2,1,8],[nMZ,0,nMZ,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(4),m4h1x3x12(:,1),heltab3x36(:,:,3))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(5),m4h1x3x12(:,2),heltab3x36(:,:,4))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[20,1,2,8],[nMZ,0,nMZ,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(6),m4h1x3x12(:,3),heltab3x36(:,:,5))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(7),m4h1x3x12(:,4),heltab3x36(:,:,6))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[16,1,2,12],[nMZ,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(8),m3h3x12(:,47),heltab2x36(:,:,47))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,48),heltab2x36(:,:,48))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[16,2,1,12],[nMZ,0,nMZ,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(10),m3h3x12(:,49),heltab2x36(:,:,49))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(11),m3h3x12(:,50),heltab2x36(:,:,50))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(12),ngZl,m3h3x12(:,51),heltab2x36(:,:,51))
  call Hloop_Q_A(ntryL,G0H12(12),16,nML,G1H12(4),n2h12(13))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(13),ngZl,m3h3x12(:,52),heltab2x36(:,:,52))
  call Hloop_A_Q(ntryL,G0H12(13),16,nML,G1H12(5),n2h12(14))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(14),ngZu,m3h3x12(:,53),heltab2x36(:,:,53))
  call Hloop_Q_A(ntryL,G0H12(14),16,nMT,G1H12(6),n2h12(15))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(15),ngZu,m3h3x12(:,54),heltab2x36(:,:,54))
  call Hloop_A_Q(ntryL,G0H12(15),16,nMT,G1H12(8),n2h12(16))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(16),ngZd,m3h3x12(:,55),heltab2x36(:,:,55))
  call Hloop_Q_A(ntryL,G0H12(16),16,nMB,G1H12(9),n2h12(17))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(17),ngZd,m3h3x12(:,56),heltab2x36(:,:,56))
  call Hloop_A_Q(ntryL,G0H12(17),16,nMB,G1H12(10),n2h12(18))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(18),ngZl,m3h3x12(:,57),heltab2x36(:,:,57))
  call Hloop_Q_A(ntryL,G0H12(18),16,nML,G1H12(11),n2h12(19))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(19),ngZl,m3h3x12(:,58),heltab2x36(:,:,58))
  call Hloop_A_Q(ntryL,G0H12(19),16,nML,G1H12(12),n2h12(20))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(20),ngZu,m3h3x12(:,59),heltab2x36(:,:,59))
  call Hloop_Q_A(ntryL,G0H12(20),16,nMT,G1H12(14),n2h12(21))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(21),ngZu,m3h3x12(:,60),heltab2x36(:,:,60))
  call Hloop_A_Q(ntryL,G0H12(21),16,nMT,G1H12(15),n2h12(22))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(22),ngZd,m3h3x12(:,61),heltab2x36(:,:,61))
  call Hloop_Q_A(ntryL,G0H12(22),16,nMB,G1H12(16),n2h12(23))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(23),ngZd,m3h3x12(:,62),heltab2x36(:,:,62))
  call Hloop_A_Q(ntryL,G0H12(23),16,nMB,G1H12(17),n2h12(24))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(18),m3h3x12(:,63),heltab2x36(:,:,63))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(20),m3h3x12(:,64),heltab2x36(:,:,64))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(21),m3h3x12(:,65),heltab2x36(:,:,65))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(22),m3h3x12(:,66),heltab2x36(:,:,66))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(23),m3h3x12(:,67),heltab2x36(:,:,67))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(24),m3h3x12(:,68),heltab2x36(:,:,68))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(3),m3h3x12(:,69),heltab2x36(:,:,69))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(2),m3h3x12(:,70),heltab2x36(:,:,70))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(77),h0tab(:,77),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(25),m3h3x12(:,71),heltab2x36(:,:,71))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(78),h0tab(:,78),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(26),m3h3x12(:,72),heltab2x36(:,:,72))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(79),h0tab(:,79),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(27),m3h3x12(:,73),heltab2x36(:,:,73))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(80),h0tab(:,80),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(28),m3h3x12(:,74),heltab2x36(:,:,74))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(29),m3h3x12(:,75),heltab2x36(:,:,75))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(30),m3h3x12(:,76),heltab2x36(:,:,76))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(31),m3h3x12(:,77),heltab2x36(:,:,77))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(32),m3h3x12(:,78),heltab2x36(:,:,78))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,79),heltab2x36(:,:,79))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,80),heltab2x36(:,:,80))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,81),heltab2x36(:,:,81))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(88),h0tab(:,88),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,82),heltab2x36(:,:,82))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(33),m3h3x12(:,83),heltab2x36(:,:,83))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(90),h0tab(:,90),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(34),m3h3x12(:,84),heltab2x36(:,:,84))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(35),m3h3x12(:,85),heltab2x36(:,:,85))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(92),h0tab(:,92),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(36),m3h3x12(:,86),heltab2x36(:,:,86))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,87),heltab2x36(:,:,87))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(94),h0tab(:,94),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,88),heltab2x36(:,:,88))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(95),h0tab(:,95),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,89),heltab2x36(:,:,89))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(96),h0tab(:,96),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,90),heltab2x36(:,:,90))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(97),h0tab(:,97),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(37),m3h3x12(:,91),heltab2x36(:,:,91))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(98),h0tab(:,98),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(38),m3h3x12(:,92),heltab2x36(:,:,92))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(39),m3h3x12(:,93),heltab2x36(:,:,93))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(100),h0tab(:,100),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(40),m3h3x12(:,94),heltab2x36(:,:,94))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(101),h0tab(:,101),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,95),heltab2x36(:,:,95))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(102),h0tab(:,102),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,96),heltab2x36(:,:,96))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(103),h0tab(:,103),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,97),heltab2x36(:,:,97))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(104),h0tab(:,104),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,98),heltab2x36(:,:,98))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(41),m3h3x12(:,99),heltab2x36(:,:,99))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(106),h0tab(:,106),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(42),m3h3x12(:,100),heltab2x36(:,:,100))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(43),m3h3x12(:,101),heltab2x36(:,:,101))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(108),h0tab(:,108),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(44),m3h3x12(:,102),heltab2x36(:,:,102))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,103),heltab2x36(:,:,103))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(110),h0tab(:,110),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,104),heltab2x36(:,:,104))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,105),heltab2x36(:,:,105))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,106),heltab2x36(:,:,106))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(113),h0tab(:,113),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,107),heltab2x36(:,:,107))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,108),heltab2x36(:,:,108))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(115),h0tab(:,115),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,109),heltab2x36(:,:,109))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,110),heltab2x36(:,:,110))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(45),m3h3x12(:,111),heltab2x36(:,:,111))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(118),h0tab(:,118),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(46),m3h3x12(:,112),heltab2x36(:,:,112))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(47),m3h3x12(:,113),heltab2x36(:,:,113))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(48),m3h3x12(:,114),heltab2x36(:,:,114))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(121),h0tab(:,121),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,115),heltab2x36(:,:,115))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(122),h0tab(:,122),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,116),heltab2x36(:,:,116))
  Gcoeff(:)%j = (c(140)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(123),h0tab(:,123),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,117),heltab2x36(:,:,117))
  Gcoeff(:)%j = (c(140)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(124),h0tab(:,124),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(32),m3h3x12(:,118),heltab2x36(:,:,118))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(49),m3h3x12(:,119),heltab2x36(:,:,119))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(126),h0tab(:,126),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(50),m3h3x12(:,120),heltab2x36(:,:,120))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(127),h0tab(:,127),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(51),m3h3x12(:,121),heltab2x36(:,:,121))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(128),h0tab(:,128),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(52),m3h3x12(:,122),heltab2x36(:,:,122))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(129),h0tab(:,129),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(33),m3h3x12(:,123),heltab2x36(:,:,123))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(130),h0tab(:,130),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(34),m3h3x12(:,124),heltab2x36(:,:,124))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(131),h0tab(:,131),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(35),m3h3x12(:,125),heltab2x36(:,:,125))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(132),h0tab(:,132),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(36),m3h3x12(:,126),heltab2x36(:,:,126))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(133),h0tab(:,133),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(53),m3h3x12(:,127),heltab2x36(:,:,127))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(134),h0tab(:,134),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(54),m3h3x12(:,128),heltab2x36(:,:,128))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(135),h0tab(:,135),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(55),m3h3x12(:,129),heltab2x36(:,:,129))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(136),h0tab(:,136),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(56),m3h3x12(:,130),heltab2x36(:,:,130))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(37),m3h3x12(:,131),heltab2x36(:,:,131))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,132),heltab2x36(:,:,132))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,133),heltab2x36(:,:,133))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,134),heltab2x36(:,:,134))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(141),h0tab(:,141),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(41),ngZl,m3h3x12(:,135),heltab2x36(:,:,135))
  call Hloop_A_Q(ntryL,G0H12(41),16,nML,G1H12(57),n2h12(25))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(142),h0tab(:,142),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(41),ngZl,m3h3x12(:,136),heltab2x36(:,:,136))
  call Hloop_Q_A(ntryL,G0H12(41),16,nML,G1H12(58),n2h12(26))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(143),h0tab(:,143),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(41),ngZu,m3h3x12(:,137),heltab2x36(:,:,137))
  call Hloop_A_Q(ntryL,G0H12(41),16,nMT,G1H12(59),n2h12(27))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(144),h0tab(:,144),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(41),ngZu,m3h3x12(:,138),heltab2x36(:,:,138))
  call Hloop_Q_A(ntryL,G0H12(41),16,nMT,G1H12(60),n2h12(28))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(145),h0tab(:,145),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(41),ngZd,m3h3x12(:,139),heltab2x36(:,:,139))
  call Hloop_A_Q(ntryL,G0H12(41),16,nMB,G1H12(61),n2h12(29))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(146),h0tab(:,146),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(41),ngZd,m3h3x12(:,140),heltab2x36(:,:,140))
  call Hloop_Q_A(ntryL,G0H12(41),16,nMB,G1H12(62),n2h12(30))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(147),h0tab(:,147),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(41),ngZl,m3h3x12(:,141),heltab2x36(:,:,141))
  call Hloop_A_Q(ntryL,G0H12(41),16,nML,G1H12(63),n2h12(31))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(148),h0tab(:,148),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(41),ngZl,m3h3x12(:,142),heltab2x36(:,:,142))
  call Hloop_Q_A(ntryL,G0H12(41),16,nML,G1H12(64),n2h12(32))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(149),h0tab(:,149),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(41),ngZu,m3h3x12(:,143),heltab2x36(:,:,143))
  call Hloop_A_Q(ntryL,G0H12(41),16,nMT,G1H12(65),n2h12(33))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(150),h0tab(:,150),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(41),ngZu,m3h3x12(:,144),heltab2x36(:,:,144))
  call Hloop_Q_A(ntryL,G0H12(41),16,nMT,G1H12(66),n2h12(34))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(151),h0tab(:,151),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(41),ngZd,m3h3x12(:,145),heltab2x36(:,:,145))
  call Hloop_A_Q(ntryL,G0H12(41),16,nMB,G1H12(67),n2h12(35))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(152),h0tab(:,152),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(41),ngZd,m3h3x12(:,146),heltab2x36(:,:,146))
  call Hloop_Q_A(ntryL,G0H12(41),16,nMB,G1H12(68),n2h12(36))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(153),h0tab(:,153),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(69),m3h3x12(:,147),heltab2x36(:,:,147))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(154),h0tab(:,154),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(70),m3h3x12(:,148),heltab2x36(:,:,148))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(155),h0tab(:,155),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(71),m3h3x12(:,149),heltab2x36(:,:,149))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(156),h0tab(:,156),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(72),m3h3x12(:,150),heltab2x36(:,:,150))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(157),h0tab(:,157),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(73),m3h3x12(:,151),heltab2x36(:,:,151))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(158),h0tab(:,158),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(74),m3h3x12(:,152),heltab2x36(:,:,152))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(159),h0tab(:,159),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(75),m3h3x12(:,153),heltab2x36(:,:,153))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(160),h0tab(:,160),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(76),m3h3x12(:,154),heltab2x36(:,:,154))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(77),m3h3x12(:,155),heltab2x36(:,:,155))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(162),h0tab(:,162),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(78),m3h3x12(:,156),heltab2x36(:,:,156))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(163),h0tab(:,163),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(79),m3h3x12(:,157),heltab2x36(:,:,157))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(164),h0tab(:,164),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(80),m3h3x12(:,158),heltab2x36(:,:,158))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(165),h0tab(:,165),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(81),m3h3x12(:,159),heltab2x36(:,:,159))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(166),h0tab(:,166),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(82),m3h3x12(:,160),heltab2x36(:,:,160))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(167),h0tab(:,167),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(83),m3h3x12(:,161),heltab2x36(:,:,161))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(168),h0tab(:,168),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(84),m3h3x12(:,162),heltab2x36(:,:,162))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(169),h0tab(:,169),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(41),m3h3x12(:,163),heltab2x36(:,:,163))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(170),h0tab(:,170),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(42),m3h3x12(:,164),heltab2x36(:,:,164))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(171),h0tab(:,171),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,165),heltab2x36(:,:,165))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(172),h0tab(:,172),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(44),m3h3x12(:,166),heltab2x36(:,:,166))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(173),h0tab(:,173),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(45),m3h3x12(:,167),heltab2x36(:,:,167))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(174),h0tab(:,174),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(46),m3h3x12(:,168),heltab2x36(:,:,168))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(175),h0tab(:,175),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(47),m3h3x12(:,169),heltab2x36(:,:,169))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(176),h0tab(:,176),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(48),m3h3x12(:,170),heltab2x36(:,:,170))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(177),h0tab(:,177),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(85),m3h3x12(:,171),heltab2x36(:,:,171))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(178),h0tab(:,178),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(86),m3h3x12(:,172),heltab2x36(:,:,172))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(179),h0tab(:,179),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(87),m3h3x12(:,173),heltab2x36(:,:,173))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(180),h0tab(:,180),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(88),m3h3x12(:,174),heltab2x36(:,:,174))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(181),h0tab(:,181),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(89),m3h3x12(:,175),heltab2x36(:,:,175))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(182),h0tab(:,182),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(90),m3h3x12(:,176),heltab2x36(:,:,176))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(183),h0tab(:,183),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(91),m3h3x12(:,177),heltab2x36(:,:,177))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(184),h0tab(:,184),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(92),m3h3x12(:,178),heltab2x36(:,:,178))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(185),h0tab(:,185),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(93),m3h3x12(:,179),heltab2x36(:,:,179))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(186),h0tab(:,186),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(94),m3h3x12(:,180),heltab2x36(:,:,180))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(187),h0tab(:,187),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(95),m3h3x12(:,181),heltab2x36(:,:,181))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(188),h0tab(:,188),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(96),m3h3x12(:,182),heltab2x36(:,:,182))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(189),h0tab(:,189),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,183),heltab2x36(:,:,183))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(190),h0tab(:,190),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(50),m3h3x12(:,184),heltab2x36(:,:,184))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(191),h0tab(:,191),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(51),m3h3x12(:,185),heltab2x36(:,:,185))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(192),h0tab(:,192),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(52),m3h3x12(:,186),heltab2x36(:,:,186))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(193),h0tab(:,193),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,187),heltab2x36(:,:,187))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(194),h0tab(:,194),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(54),m3h3x12(:,188),heltab2x36(:,:,188))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(195),h0tab(:,195),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(55),m3h3x12(:,189),heltab2x36(:,:,189))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(196),h0tab(:,196),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(56),m3h3x12(:,190),heltab2x36(:,:,190))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(197),h0tab(:,197),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,191),heltab2x36(:,:,191))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(198),h0tab(:,198),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(58),m3h3x12(:,192),heltab2x36(:,:,192))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(199),h0tab(:,199),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(59),m3h3x12(:,193),heltab2x36(:,:,193))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(200),h0tab(:,200),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(60),m3h3x12(:,194),heltab2x36(:,:,194))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(201),h0tab(:,201),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,195),heltab2x36(:,:,195))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(202),h0tab(:,202),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,196),heltab2x36(:,:,196))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(203),h0tab(:,203),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(63),m3h3x12(:,197),heltab2x36(:,:,197))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(204),h0tab(:,204),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,198),heltab2x36(:,:,198))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(205),h0tab(:,205),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(97),m3h3x12(:,199),heltab2x36(:,:,199))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(206),h0tab(:,206),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(98),m3h3x12(:,200),heltab2x36(:,:,200))
  Gcoeff(:)%j = (c(140)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(207),h0tab(:,207),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(99),m3h3x12(:,201),heltab2x36(:,:,201))
  Gcoeff(:)%j = (c(140)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(208),h0tab(:,208),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(100),m3h3x12(:,202),heltab2x36(:,:,202))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(209),h0tab(:,209),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(101),m3h3x12(:,203),heltab2x36(:,:,203))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(210),h0tab(:,210),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(102),m3h3x12(:,204),heltab2x36(:,:,204))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(211),h0tab(:,211),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(103),m3h3x12(:,205),heltab2x36(:,:,205))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(212),h0tab(:,212),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(104),m3h3x12(:,206),heltab2x36(:,:,206))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(213),h0tab(:,213),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(105),m3h3x12(:,207),heltab2x36(:,:,207))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(214),h0tab(:,214),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(106),m3h3x12(:,208),heltab2x36(:,:,208))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(215),h0tab(:,215),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(107),m3h3x12(:,209),heltab2x36(:,:,209))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(216),h0tab(:,216),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(108),m3h3x12(:,210),heltab2x36(:,:,210))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(217),h0tab(:,217),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(65),m3h3x12(:,211),heltab2x36(:,:,211))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(218),h0tab(:,218),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(66),m3h3x12(:,212),heltab2x36(:,:,212))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(219),h0tab(:,219),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(67),m3h3x12(:,213),heltab2x36(:,:,213))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(220),h0tab(:,220),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(68),m3h3x12(:,214),heltab2x36(:,:,214))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(221),h0tab(:,221),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(69),m3h3x12(:,215),heltab2x36(:,:,215))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(222),h0tab(:,222),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,216),heltab2x36(:,:,216))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(223),h0tab(:,223),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(71),m3h3x12(:,217),heltab2x36(:,:,217))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(224),h0tab(:,224),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,218),heltab2x36(:,:,218))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(225),h0tab(:,225),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(73),ngZl,m3h3x12(:,219),heltab2x36(:,:,219))
  call Hloop_Q_A(ntryL,G0H12(73),16,nML,G1H12(109),n2h12(37))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(226),h0tab(:,226),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(73),ngZl,m3h3x12(:,220),heltab2x36(:,:,220))
  call Hloop_A_Q(ntryL,G0H12(73),16,nML,G1H12(110),n2h12(38))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(227),h0tab(:,227),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(73),ngZu,m3h3x12(:,221),heltab2x36(:,:,221))
  call Hloop_Q_A(ntryL,G0H12(73),16,nMT,G1H12(111),n2h12(39))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(228),h0tab(:,228),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(73),ngZu,m3h3x12(:,222),heltab2x36(:,:,222))
  call Hloop_A_Q(ntryL,G0H12(73),16,nMT,G1H12(112),n2h12(40))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(229),h0tab(:,229),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(73),ngZd,m3h3x12(:,223),heltab2x36(:,:,223))
  call Hloop_Q_A(ntryL,G0H12(73),16,nMB,G1H12(113),n2h12(41))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(230),h0tab(:,230),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(73),ngZd,m3h3x12(:,224),heltab2x36(:,:,224))
  call Hloop_A_Q(ntryL,G0H12(73),16,nMB,G1H12(114),n2h12(42))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(231),h0tab(:,231),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(73),ngZl,m3h3x12(:,225),heltab2x36(:,:,225))
  call Hloop_Q_A(ntryL,G0H12(73),16,nML,G1H12(115),n2h12(43))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(232),h0tab(:,232),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(73),ngZl,m3h3x12(:,226),heltab2x36(:,:,226))
  call Hloop_A_Q(ntryL,G0H12(73),16,nML,G1H12(116),n2h12(44))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(233),h0tab(:,233),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(73),ngZu,m3h3x12(:,227),heltab2x36(:,:,227))
  call Hloop_Q_A(ntryL,G0H12(73),16,nMT,G1H12(117),n2h12(45))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(234),h0tab(:,234),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(73),ngZu,m3h3x12(:,228),heltab2x36(:,:,228))
  call Hloop_A_Q(ntryL,G0H12(73),16,nMT,G1H12(118),n2h12(46))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(235),h0tab(:,235),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(73),ngZd,m3h3x12(:,229),heltab2x36(:,:,229))
  call Hloop_Q_A(ntryL,G0H12(73),16,nMB,G1H12(119),n2h12(47))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(236),h0tab(:,236),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(73),ngZd,m3h3x12(:,230),heltab2x36(:,:,230))
  call Hloop_A_Q(ntryL,G0H12(73),16,nMB,G1H12(120),n2h12(48))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(237),h0tab(:,237),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(121),m3h3x12(:,231),heltab2x36(:,:,231))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(238),h0tab(:,238),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(122),m3h3x12(:,232),heltab2x36(:,:,232))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(239),h0tab(:,239),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(123),m3h3x12(:,233),heltab2x36(:,:,233))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(240),h0tab(:,240),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(124),m3h3x12(:,234),heltab2x36(:,:,234))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(241),h0tab(:,241),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(125),m3h3x12(:,235),heltab2x36(:,:,235))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(242),h0tab(:,242),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(126),m3h3x12(:,236),heltab2x36(:,:,236))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(243),h0tab(:,243),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(127),m3h3x12(:,237),heltab2x36(:,:,237))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(244),h0tab(:,244),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(128),m3h3x12(:,238),heltab2x36(:,:,238))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(245),h0tab(:,245),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(129),m3h3x12(:,239),heltab2x36(:,:,239))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(246),h0tab(:,246),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(130),m3h3x12(:,240),heltab2x36(:,:,240))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(247),h0tab(:,247),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(131),m3h3x12(:,241),heltab2x36(:,:,241))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(248),h0tab(:,248),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(132),m3h3x12(:,242),heltab2x36(:,:,242))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(249),h0tab(:,249),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(133),m3h3x12(:,243),heltab2x36(:,:,243))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(250),h0tab(:,250),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(134),m3h3x12(:,244),heltab2x36(:,:,244))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(251),h0tab(:,251),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(135),m3h3x12(:,245),heltab2x36(:,:,245))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(252),h0tab(:,252),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(136),m3h3x12(:,246),heltab2x36(:,:,246))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(253),h0tab(:,253),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(137),m3h3x12(:,247),heltab2x36(:,:,247))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(254),h0tab(:,254),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(138),m3h3x12(:,248),heltab2x36(:,:,248))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(255),h0tab(:,255),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(139),m3h3x12(:,249),heltab2x36(:,:,249))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(256),h0tab(:,256),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(140),m3h3x12(:,250),heltab2x36(:,:,250))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(257),h0tab(:,257),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,251),heltab2x36(:,:,251))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(258),h0tab(:,258),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(74),m3h3x12(:,252),heltab2x36(:,:,252))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(259),h0tab(:,259),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(75),m3h3x12(:,253),heltab2x36(:,:,253))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(260),h0tab(:,260),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(76),m3h3x12(:,254),heltab2x36(:,:,254))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(261),h0tab(:,261),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(141),m3h3x12(:,255),heltab2x36(:,:,255))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(262),h0tab(:,262),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(142),m3h3x12(:,256),heltab2x36(:,:,256))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(263),h0tab(:,263),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(143),m3h3x12(:,257),heltab2x36(:,:,257))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(264),h0tab(:,264),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(144),m3h3x12(:,258),heltab2x36(:,:,258))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(265),h0tab(:,265),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(77),m3h3x12(:,259),heltab2x36(:,:,259))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(266),h0tab(:,266),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(78),m3h3x12(:,260),heltab2x36(:,:,260))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(267),h0tab(:,267),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(79),m3h3x12(:,261),heltab2x36(:,:,261))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(268),h0tab(:,268),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(80),m3h3x12(:,262),heltab2x36(:,:,262))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(269),h0tab(:,269),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(81),m3h3x12(:,263),heltab2x36(:,:,263))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(270),h0tab(:,270),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(82),m3h3x12(:,264),heltab2x36(:,:,264))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(271),h0tab(:,271),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(83),m3h3x12(:,265),heltab2x36(:,:,265))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(272),h0tab(:,272),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(84),m3h3x12(:,266),heltab2x36(:,:,266))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(273),h0tab(:,273),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(145),m3h3x12(:,267),heltab2x36(:,:,267))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(274),h0tab(:,274),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(146),m3h3x12(:,268),heltab2x36(:,:,268))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(275),h0tab(:,275),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(147),m3h3x12(:,269),heltab2x36(:,:,269))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(276),h0tab(:,276),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(148),m3h3x12(:,270),heltab2x36(:,:,270))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(277),h0tab(:,277),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(85),m3h3x12(:,271),heltab2x36(:,:,271))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(278),h0tab(:,278),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(86),m3h3x12(:,272),heltab2x36(:,:,272))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(279),h0tab(:,279),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(87),m3h3x12(:,273),heltab2x36(:,:,273))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(280),h0tab(:,280),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(88),m3h3x12(:,274),heltab2x36(:,:,274))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(281),h0tab(:,281),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(89),m3h3x12(:,275),heltab2x36(:,:,275))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(282),h0tab(:,282),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(90),m3h3x12(:,276),heltab2x36(:,:,276))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(283),h0tab(:,283),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(91),m3h3x12(:,277),heltab2x36(:,:,277))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(284),h0tab(:,284),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,278),heltab2x36(:,:,278))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(285),h0tab(:,285),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(149),m3h3x12(:,279),heltab2x36(:,:,279))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(286),h0tab(:,286),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(150),m3h3x12(:,280),heltab2x36(:,:,280))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(287),h0tab(:,287),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(151),m3h3x12(:,281),heltab2x36(:,:,281))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(288),h0tab(:,288),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(152),m3h3x12(:,282),heltab2x36(:,:,282))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(289),h0tab(:,289),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(93),m3h3x12(:,283),heltab2x36(:,:,283))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(290),h0tab(:,290),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(94),m3h3x12(:,284),heltab2x36(:,:,284))
  Gcoeff(:)%j = (c(140)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(291),h0tab(:,291),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(95),m3h3x12(:,285),heltab2x36(:,:,285))
  Gcoeff(:)%j = (c(140)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(292),h0tab(:,292),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(96),m3h3x12(:,286),heltab2x36(:,:,286))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(293),h0tab(:,293),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,287),heltab2x36(:,:,287))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(294),h0tab(:,294),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(98),m3h3x12(:,288),heltab2x36(:,:,288))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(295),h0tab(:,295),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(99),m3h3x12(:,289),heltab2x36(:,:,289))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(296),h0tab(:,296),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(100),m3h3x12(:,290),heltab2x36(:,:,290))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(297),h0tab(:,297),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(153),m3h3x12(:,291),heltab2x36(:,:,291))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(298),h0tab(:,298),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(154),m3h3x12(:,292),heltab2x36(:,:,292))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(299),h0tab(:,299),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(155),m3h3x12(:,293),heltab2x36(:,:,293))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(300),h0tab(:,300),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(156),m3h3x12(:,294),heltab2x36(:,:,294))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(301),h0tab(:,301),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(101),m3h3x12(:,295),heltab2x36(:,:,295))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(302),h0tab(:,302),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(102),m3h3x12(:,296),heltab2x36(:,:,296))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(303),h0tab(:,303),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(103),m3h3x12(:,297),heltab2x36(:,:,297))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(304),h0tab(:,304),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(104),m3h3x12(:,298),heltab2x36(:,:,298))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(305),h0tab(:,305),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(157),m3h3x12(:,299),heltab2x36(:,:,299))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(306),h0tab(:,306),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(158),m3h3x12(:,300),heltab2x36(:,:,300))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(307),h0tab(:,307),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(159),m3h3x12(:,301),heltab2x36(:,:,301))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(308),h0tab(:,308),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(160),m3h3x12(:,302),heltab2x36(:,:,302))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(309),h0tab(:,309),[16,2,4,9],[0,nMZ,nMZ,0],4,1,wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(105),ngZu,m3h3x12(:,303),heltab2x36(:,:,303))
  call Hloop_Q_A(ntryL,G0H12(105),16,0,G1H12(161),n2h12(49))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(310),h0tab(:,310),[16,2,4,9],[0,nMW,nMW,0],4,1,wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(105),ngZd,m3h3x12(:,304),heltab2x36(:,:,304))
  call Hloop_Q_A(ntryL,G0H12(105),16,0,G1H12(162),n2h12(50))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(311),h0tab(:,311),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf6(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(105),m3h3x12(:,305),heltab2x36(:,:,305))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(312),h0tab(:,312),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(163),m3h3x12(:,306),heltab2x36(:,:,306))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(313),h0tab(:,313),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf6(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(106),m3h3x12(:,307),heltab2x36(:,:,307))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(314),h0tab(:,314),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(164),m3h3x12(:,308),heltab2x36(:,:,308))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(315),h0tab(:,315),[16,1,4,10],[0,nMZ,nMZ,0],4,1,wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(107),ngZu,m3h3x12(:,309),heltab2x36(:,:,309))
  call Hloop_A_Q(ntryL,G0H12(107),16,0,G1H12(165),n2h12(51))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(316),h0tab(:,316),[16,1,4,10],[0,nMW,nMW,0],4,1,wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(107),ngZd,m3h3x12(:,310),heltab2x36(:,:,310))
  call Hloop_A_Q(ntryL,G0H12(107),16,0,G1H12(166),n2h12(52))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(317),h0tab(:,317),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf6(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(107),m3h3x12(:,311),heltab2x36(:,:,311))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(318),h0tab(:,318),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(167),m3h3x12(:,312),heltab2x36(:,:,312))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(319),h0tab(:,319),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf6(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(108),m3h3x12(:,313),heltab2x36(:,:,313))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(320),h0tab(:,320),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(168),m3h3x12(:,314),heltab2x36(:,:,314))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(321),h0tab(:,321),[16,1,2,12],[nMZ,0,nMZ,nMH],4,1,wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(109),m3h3x12(:,315),heltab2x36(:,:,315))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(322),h0tab(:,322),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(110),m3h3x12(:,316),heltab2x36(:,:,316))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(323),h0tab(:,323),[16,1,2,12],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(111),ngZu,m3h3x12(:,317),heltab2x36(:,:,317))
  call Hloop_A_Q(ntryL,G0H12(111),16,0,G1H12(169),n2h12(53))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(324),h0tab(:,324),[16,1,2,12],[0,nMZ,0,0],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(111),ngZu,m3h3x12(:,318),heltab2x36(:,:,318))
  call Hloop_A_Q(ntryL,G0H12(111),16,0,G1H12(170),n2h12(54))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(325),h0tab(:,325),[16,1,2,12],[0,nMW,0,0],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(111),ngZd,m3h3x12(:,319),heltab2x36(:,:,319))
  call Hloop_A_Q(ntryL,G0H12(111),16,0,G1H12(171),n2h12(55))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(326),h0tab(:,326),[16,1,2,12],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(111),ngZu,m3h3x12(:,320),heltab2x36(:,:,320))
  call Hloop_A_Q(ntryL,G0H12(111),16,0,G1H12(172),n2h12(56))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(327),h0tab(:,327),[16,1,2,12],[nMZ,0,nMZ,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(111),m3h3x12(:,321),heltab2x36(:,:,321))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(328),h0tab(:,328),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(112),m3h3x12(:,322),heltab2x36(:,:,322))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(329),h0tab(:,329),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(173),m3h3x12(:,323),heltab2x36(:,:,323))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(330),h0tab(:,330),[16,2,1,12],[nMZ,0,nMZ,nMH],4,1,wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(113),m3h3x12(:,324),heltab2x36(:,:,324))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(331),h0tab(:,331),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,325),heltab2x36(:,:,325))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(332),h0tab(:,332),[16,2,1,12],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(115),ngZu,m3h3x12(:,326),heltab2x36(:,:,326))
  call Hloop_Q_A(ntryL,G0H12(115),16,0,G1H12(174),n2h12(57))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(333),h0tab(:,333),[16,2,1,12],[0,nMZ,0,0],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(115),ngZu,m3h3x12(:,327),heltab2x36(:,:,327))
  call Hloop_Q_A(ntryL,G0H12(115),16,0,G1H12(175),n2h12(58))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(334),h0tab(:,334),[16,2,1,12],[0,nMW,0,0],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(115),ngZd,m3h3x12(:,328),heltab2x36(:,:,328))
  call Hloop_Q_A(ntryL,G0H12(115),16,0,G1H12(176),n2h12(59))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(335),h0tab(:,335),[16,2,1,12],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(115),ngZu,m3h3x12(:,329),heltab2x36(:,:,329))
  call Hloop_Q_A(ntryL,G0H12(115),16,0,G1H12(177),n2h12(60))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(336),h0tab(:,336),[16,2,1,12],[nMZ,0,nMZ,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(115),m3h3x12(:,330),heltab2x36(:,:,330))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(337),h0tab(:,337),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(116),m3h3x12(:,331),heltab2x36(:,:,331))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(338),h0tab(:,338),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf3(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(178),m3h3x12(:,332),heltab2x36(:,:,332))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(339),h0tab(:,339),[16,1,12,2],[0,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(117),ngZd,m3h3x12(:,333),heltab2x36(:,:,333))
  call Hloop_A_Q(ntryL,G0H12(117),16,0,G1H12(179),n2h12(61))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(340),h0tab(:,340),[16,1,12,2],[nMW,0,0,nMW],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(180),m3h3x12(:,334),heltab2x36(:,:,334))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(341),h0tab(:,341),[17,4,2,8],[nMZ,nMZ,0,0],4,1,wf6(:,6))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,6),G0H6(1),ngZu,m3h6x6(:,1),heltab2x36(:,:,335))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(342),h0tab(:,342),[17,4,2,8],[nMW,nMW,0,0],4,1,wf6(:,6))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,6),G0H6(2),m3h6x6(:,2),heltab2x36(:,:,336))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(343),h0tab(:,343),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,3),heltab2x36(:,:,337))
  call Hloop_Q_A(ntryL,G0H6(3),17,0,G1H6(19),n2h6(47))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(344),h0tab(:,344),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,4),heltab2x36(:,:,338))
  call Hloop_Q_A(ntryL,G0H6(3),17,0,G1H6(20),n2h6(48))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(345),h0tab(:,345),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,5),heltab2x36(:,:,339))
  call Hloop_Q_A(ntryL,G0H6(3),17,0,G1H6(21),n2h6(49))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(346),h0tab(:,346),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,6),heltab2x36(:,:,340))
  call Hloop_Q_A(ntryL,G0H6(3),17,0,G1H6(22),n2h6(50))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(347),h0tab(:,347),[18,4,1,8],[nMZ,nMZ,0,0],4,1,wf6(:,8))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,8),G0H6(3),ngZu,m3h6x6(:,7),heltab2x36(:,:,341))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(348),h0tab(:,348),[18,4,1,8],[nMW,nMW,0,0],4,1,wf6(:,8))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,8),G0H6(4),m3h6x6(:,8),heltab2x36(:,:,342))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(349),h0tab(:,349),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,9),heltab2x36(:,:,343))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(23),n2h6(51))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(350),h0tab(:,350),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,10),heltab2x36(:,:,344))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(24),n2h6(52))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(351),h0tab(:,351),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,11),heltab2x36(:,:,345))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(3),n2h6(53))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(352),h0tab(:,352),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,8))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,12),heltab2x36(:,:,346))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(4),n2h6(54))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(353),h0tab(:,353),[20,2,1,8],[nMZ,0,nMZ,nMH],4,1,wf3(:,5))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(181),m3h3x12(:,335),heltab2x36(:,:,347))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(354),h0tab(:,354),[20,2,1,8],[nMW,0,nMW,nMW],4,1,wf3(:,5))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(182),m3h3x12(:,336),heltab2x36(:,:,348))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(355),h0tab(:,355),[20,2,1,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(117),ngZu,m3h3x12(:,337),heltab2x36(:,:,349))
  call Hloop_Q_A(ntryL,G0H12(117),20,0,G1H12(183),n2h12(62))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(356),h0tab(:,356),[20,2,1,8],[0,nMZ,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(117),ngZu,m3h3x12(:,338),heltab2x36(:,:,350))
  call Hloop_Q_A(ntryL,G0H12(117),20,0,G1H12(184),n2h12(63))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(357),h0tab(:,357),[20,2,1,8],[0,nMW,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(117),ngZd,m3h3x12(:,339),heltab2x36(:,:,351))
  call Hloop_Q_A(ntryL,G0H12(117),20,0,G1H12(185),n2h12(64))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(358),h0tab(:,358),[20,2,1,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(117),ngZu,m3h3x12(:,340),heltab2x36(:,:,352))
  call Hloop_Q_A(ntryL,G0H12(117),20,0,G1H12(186),n2h12(65))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(359),h0tab(:,359),[20,2,1,8],[nMZ,0,nMZ,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(117),m3h3x12(:,341),heltab2x36(:,:,353))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(360),h0tab(:,360),[20,2,1,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(118),m3h3x12(:,342),heltab2x36(:,:,354))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(361),h0tab(:,361),[20,2,1,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(187),m3h3x12(:,343),heltab2x36(:,:,355))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(362),h0tab(:,362),[20,1,2,8],[nMZ,0,nMZ,nMH],4,1,wf3(:,5))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(188),m3h3x12(:,344),heltab2x36(:,:,356))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(363),h0tab(:,363),[20,1,2,8],[nMW,0,nMW,nMW],4,1,wf3(:,5))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(189),m3h3x12(:,345),heltab2x36(:,:,357))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(364),h0tab(:,364),[20,1,2,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(119),ngZu,m3h3x12(:,346),heltab2x36(:,:,358))
  call Hloop_A_Q(ntryL,G0H12(119),20,0,G1H12(190),n2h12(66))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(365),h0tab(:,365),[20,1,2,8],[0,nMZ,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(119),ngZu,m3h3x12(:,347),heltab2x36(:,:,359))
  call Hloop_A_Q(ntryL,G0H12(119),20,0,G1H12(191),n2h12(67))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(366),h0tab(:,366),[20,1,2,8],[0,nMW,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(119),ngZd,m3h3x12(:,348),heltab2x36(:,:,360))
  call Hloop_A_Q(ntryL,G0H12(119),20,0,G1H12(192),n2h12(68))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(367),h0tab(:,367),[20,1,2,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(119),ngZu,m3h3x12(:,349),heltab2x36(:,:,361))
  call Hloop_A_Q(ntryL,G0H12(119),20,0,G1H12(193),n2h12(69))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(368),h0tab(:,368),[20,1,2,8],[nMZ,0,nMZ,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(119),m3h3x12(:,350),heltab2x36(:,:,362))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(369),h0tab(:,369),[20,1,2,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(120),m3h3x12(:,351),heltab2x36(:,:,363))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(370),h0tab(:,370),[20,1,2,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(194),m3h3x12(:,352),heltab2x36(:,:,364))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(371),h0tab(:,371),[20,1,8,2],[nMW,0,0,nMW],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(195),m3h3x12(:,353),heltab2x36(:,:,365))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(372),h0tab(:,372),[20,1,8,2],[0,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(121),ngZd,m3h3x12(:,354),heltab2x36(:,:,366))
  call Hloop_A_Q(ntryL,G0H12(121),20,0,G1H12(196),n2h12(70))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(373),h0tab(:,373),[24,2,1,4],[nMZ,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(5),m3h9x4(:,1),heltab2x36(:,:,367))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(374),h0tab(:,374),[24,2,1,4],[nMW,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(6),m3h9x4(:,2),heltab2x36(:,:,368))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(375),h0tab(:,375),[24,2,1,4],[nMZ,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(3),m3h9x4(:,3),heltab2x36(:,:,369))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(376),h0tab(:,376),[24,2,1,4],[nMW,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(4),m3h9x4(:,4),heltab2x36(:,:,370))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(377),h0tab(:,377),[24,1,2,4],[nMZ,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(7),m3h9x4(:,5),heltab2x36(:,:,371))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(378),h0tab(:,378),[24,1,2,4],[nMW,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(8),m3h9x4(:,6),heltab2x36(:,:,372))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(379),h0tab(:,379),[24,1,2,4],[nMZ,0,nMZ,nMZ],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(5),m3h9x4(:,7),heltab2x36(:,:,373))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(380),h0tab(:,380),[24,1,2,4],[nMW,0,nMW,nMW],4,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(6),m3h9x4(:,8),heltab2x36(:,:,374))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(188),[G1H12(7),G0H12(119),G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(189),[G1H12(13),G0H12(120),G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(181),[G1H12(19),G0H12(117),G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(182),[G1H12(1),G0H12(118),G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(4),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(6),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(34),[G1H12(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(36),[G1H12(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(22),[G0H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(24),[G0H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(26),[G0H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(28),[G0H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(54),[G1H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(56),[G1H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(75),[G1H12(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(76),[G1H12(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(79),[G1H12(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(80),[G1H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(94),[G1H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(96),[G1H12(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(54),[G0H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(56),[G0H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(58),[G0H12(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(60),[G0H12(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(98),[G1H12(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(100),[G1H12(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(127),[G1H12(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(128),[G1H12(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(131),[G1H12(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(132),[G1H12(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(138),[G1H12(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(140),[G1H12(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(86),[G0H12(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(88),[G0H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(90),[G0H12(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(92),[G0H12(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(158),[G1H12(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(160),[G1H12(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(172),[G1H12(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(177),[G1H12(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(186),[G1H12(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(193),[G1H12(190)])
  call Hloop_ZQ_A(ntryL,G1H12(188),ex1(:),G1H6(5),ngZu,m3h2x6(:,53),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H6(5),21,0,G2H6(11),n2h6(55))
  call Hloop_WQ_A(ntryL,G1H12(189),ex1(:),G1H6(6),m3h2x6(:,54),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G1H6(6),21,0,G2H6(1),n2h6(56))
  call Hloop_ZA_Q(ntryL,G1H12(181),ex2(:),G1H6(7),ngZu,m3h2x6(:,55),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H6(7),22,0,G2H6(2),n2h6(57))
  call Hloop_WA_Q(ntryL,G1H12(182),ex2(:),G1H6(11),m3h2x6(:,56),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(11),22,0,G2H6(3),n2h6(58))
  call Hloop_AZ_Q(ntryL,G1H6(25),ex4(:),G1H2(2),ngZd,m3h3x2(:,15),heltab2x6(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(2),26,0,G2H2(3),n2h2(11))
  call Hloop_QZ_A(ntryL,G1H6(13),ex4(:),G1H2(1),ngZd,m3h3x2(:,16),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(1),25,0,G2H2(4),n2h2(12))
  call Hloop_WA_Q(ntryL,G0H4(4),ex2(:),G0H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(6),n2h2(13))
  call Hloop_WQ_A(ntryL,G0H4(6),ex1(:),G0H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(7),n2h2(14))
  call Hloop_ZQ_A(ntryL,G0H12(8),ex1(:),G0H6(5),ngZu,m3h2x6(:,57),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(12),n2h6(59))
  call Hloop_WQ_A(ntryL,G0H12(9),ex1(:),G0H6(5),m3h2x6(:,58),heltab2x12(:,:,74))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(14),n2h6(60))
  call Hloop_ZA_Q(ntryL,G0H12(10),ex2(:),G0H6(5),ngZu,m3h2x6(:,59),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(15),n2h6(61))
  call Hloop_WA_Q(ntryL,G0H12(11),ex2(:),G0H6(5),m3h2x6(:,60),heltab2x12(:,:,76))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(16),n2h6(62))
  call Hloop_QV_A(ntryL,G1H12(4),wf4(:,1),G1H3(2),m3h4x3(:,1),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H3(2),19,nML,G2H3(9),n2h3(9))
  call Hloop_AV_Q(ntryL,G1H12(5),wf4(:,1),G1H3(17),m3h4x3(:,2),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(17),19,nML,G2H3(10),n2h3(10))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,1),G1H3(20),m3h4x3(:,3),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G1H3(20),19,nMT,G2H3(11),n2h3(11))
  call Hloop_AV_Q(ntryL,G1H12(8),wf4(:,1),G1H3(21),m3h4x3(:,4),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G1H3(21),19,nMT,G2H3(1),n2h3(12))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,1),G1H3(8),m3h4x3(:,5),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(8),19,nMB,G2H3(2),n2h3(13))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,1),G1H3(11),m3h4x3(:,6),heltab2x12(:,:,82))
  call Hloop_A_Q(ntryL,G1H3(11),19,nMB,G2H3(3),n2h3(14))
  call Hloop_QZ_A(ntryL,G1H12(11),wf4(:,2),G1H3(12),ngZl,m3h4x3(:,7),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(12),19,nML,G2H3(4),n2h3(15))
  call Hloop_AZ_Q(ntryL,G1H12(12),wf4(:,2),G1H3(27),ngZl,m3h4x3(:,8),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H3(27),19,nML,G2H3(5),n2h3(16))
  call Hloop_QZ_A(ntryL,G1H12(14),wf4(:,2),G1H3(32),ngZu,m3h4x3(:,9),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(32),19,nMT,G2H3(6),n2h3(17))
  call Hloop_AZ_Q(ntryL,G1H12(15),wf4(:,2),G1H3(19),ngZu,m3h4x3(:,10),heltab2x12(:,:,86))
  call Hloop_A_Q(ntryL,G1H3(19),19,nMT,G2H3(7),n2h3(18))
  call Hloop_QZ_A(ntryL,G1H12(16),wf4(:,2),G1H3(3),ngZd,m3h4x3(:,11),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G1H3(3),19,nMB,G2H3(8),n2h3(19))
  call Hloop_AZ_Q(ntryL,G1H12(17),wf4(:,2),G1H3(36),ngZd,m3h4x3(:,12),heltab2x12(:,:,88))
  call Hloop_A_Q(ntryL,G1H3(36),19,nMB,G2H3(12),n2h3(20))
  call Hloop_TV_S(ntryL,G1H12(18),16,wf4(:,1),3,G2H3(13),m3h4x3(:,13),heltab2x12(:,:,89))
  call Hloop_SV_T(ntryL,G1H12(20),16,wf4(:,1),3,G2H3(15),m3h4x3(:,14),heltab2x12(:,:,90))
  call Hloop_TV_S(ntryL,G1H12(21),16,wf4(:,2),3,G2H3(16),m3h4x3(:,15),heltab2x12(:,:,91))
  call Hloop_SV_T(ntryL,G1H12(22),16,wf4(:,2),3,G2H3(18),m3h4x3(:,16),heltab2x12(:,:,92))
  call Hloop_CV_D(ntryL,G1H12(3),16,wf4(:,1),3,G2H3(19),m3h4x3(:,17),heltab2x12(:,:,93))
  call Hloop_DV_C(ntryL,G1H12(2),16,wf4(:,1),G2H3(21),m3h4x3(:,18),heltab2x12(:,:,94))
  call Hloop_CV_D(ntryL,G1H12(27),16,wf4(:,2),3,G2H3(22),m3h4x3(:,19),heltab2x12(:,:,95))
  call Hloop_DV_C(ntryL,G1H12(28),16,wf4(:,2),G2H3(24),m3h4x3(:,20),heltab2x12(:,:,96))
  call Hloop_UV_W(ntryL,G1H12(29),16,wf4(:,1),3,G2H3(25),m3h4x3(:,21),heltab2x12(:,:,97))
  call Hloop_UW_V(ntryL,G1H12(30),16,wf4(:,1),3,G2H3(27),m3h4x3(:,22),heltab2x12(:,:,98))
  call Hloop_UV_W(ntryL,G1H12(31),16,wf4(:,2),3,G2H3(28),m3h4x3(:,23),heltab2x12(:,:,99))
  call Hloop_UW_V(ntryL,G1H12(32),16,wf4(:,2),3,G2H3(30),m3h4x3(:,24),heltab2x12(:,:,100))
  call Hloop_VV_S(ntryL,G0H12(1),wf4(:,1),G0H3(1),m3h4x3(:,25),heltab2x12(:,:,101))
  call Hloop_VV_S(ntryL,G0H12(2),wf4(:,1),G0H3(2),m3h4x3(:,26),heltab2x12(:,:,102))
  call Hloop_VV_S(ntryL,G0H12(3),wf4(:,2),G0H3(3),m3h4x3(:,27),heltab2x12(:,:,103))
  call Hloop_VV_S(ntryL,G0H12(12),wf4(:,2),G0H3(4),m3h4x3(:,28),heltab2x12(:,:,104))
  call Hloop_SV_V(ntryL,G1H12(34),wf4(:,1),G1H3(37),m3h4x3(:,29),heltab2x12(:,:,105))
  call Hloop_SV_V(ntryL,G1H12(36),wf4(:,2),G1H3(38),m3h4x3(:,30),heltab2x12(:,:,106))
  call Hloop_TV_S(ntryL,G0H12(13),16,wf4(:,1),3,G1H3(42),m3h4x3(:,31),heltab2x12(:,:,107))
  call Hloop_SV_T(ntryL,G0H12(14),16,wf4(:,1),3,G1H3(43),m3h4x3(:,32),heltab2x12(:,:,108))
  call Hloop_TV_S(ntryL,G0H12(15),16,wf4(:,2),3,G1H3(44),m3h4x3(:,33),heltab2x12(:,:,109))
  call Hloop_SV_T(ntryL,G0H12(16),16,wf4(:,2),3,G1H3(48),m3h4x3(:,34),heltab2x12(:,:,110))
  call Hloop_TV_S(ntryL,G1H12(37),16,wf4(:,1),3,G2H3(31),m3h4x3(:,35),heltab2x12(:,:,111))
  call Hloop_SV_T(ntryL,G1H12(38),16,wf4(:,1),3,G2H3(32),m3h4x3(:,36),heltab2x12(:,:,112))
  call Hloop_TV_S(ntryL,G1H12(39),16,wf4(:,2),3,G2H3(33),m3h4x3(:,37),heltab2x12(:,:,113))
  call Hloop_SV_T(ntryL,G1H12(40),16,wf4(:,2),3,G2H3(34),m3h4x3(:,38),heltab2x12(:,:,114))
  call Hloop_UV_W(ntryL,G0H12(17),16,wf4(:,1),3,G1H3(49),m3h4x3(:,39),heltab2x12(:,:,115))
  call Hloop_UW_V(ntryL,G0H12(18),16,wf4(:,1),3,G1H3(50),m3h4x3(:,40),heltab2x12(:,:,116))
  call Hloop_UV_W(ntryL,G0H12(19),16,wf4(:,2),3,G1H3(54),m3h4x3(:,41),heltab2x12(:,:,117))
  call Hloop_UW_V(ntryL,G0H12(20),16,wf4(:,2),3,G1H3(26),m3h4x3(:,42),heltab2x12(:,:,118))
  call Hloop_VV_S(ntryL,G1H12(41),wf4(:,1),G1H3(10),m3h4x3(:,43),heltab2x12(:,:,119))
  call Hloop_VV_S(ntryL,G1H12(42),wf4(:,1),G1H3(58),m3h4x3(:,44),heltab2x12(:,:,120))
  call Hloop_VV_S(ntryL,G1H12(43),wf4(:,2),G1H3(59),m3h4x3(:,45),heltab2x12(:,:,121))
  call Hloop_VV_S(ntryL,G1H12(44),wf4(:,2),G1H3(60),m3h4x3(:,46),heltab2x12(:,:,122))
  call Hloop_SV_V(ntryL,G0H12(22),wf4(:,1),G0H3(5),m3h4x3(:,47),heltab2x12(:,:,123))
  call Hloop_SV_V(ntryL,G0H12(24),wf4(:,2),G0H3(6),m3h4x3(:,48),heltab2x12(:,:,124))
  call Hloop_VV_S(ntryL,G0H12(26),wf4(:,1),G0H3(7),m3h4x3(:,49),heltab2x12(:,:,125))
  call Hloop_VV_S(ntryL,G0H12(28),wf4(:,2),G0H3(8),m3h4x3(:,50),heltab2x12(:,:,126))
  call Hloop_SV_V(ntryL,G1H12(45),wf4(:,1),G1H3(64),m3h4x3(:,51),heltab2x12(:,:,127))
  call Hloop_SV_V(ntryL,G1H12(46),wf4(:,1),G1H3(65),m3h4x3(:,52),heltab2x12(:,:,128))
  call Hloop_SV_V(ntryL,G1H12(47),wf4(:,2),G1H3(66),m3h4x3(:,53),heltab2x12(:,:,129))
  call Hloop_SV_V(ntryL,G1H12(48),wf4(:,2),G1H3(70),m3h4x3(:,54),heltab2x12(:,:,130))
  call Hloop_TV_S(ntryL,G0H12(29),16,wf4(:,1),3,G1H3(71),m3h4x3(:,55),heltab2x12(:,:,131))
  call Hloop_SV_T(ntryL,G0H12(30),16,wf4(:,1),3,G1H3(72),m3h4x3(:,56),heltab2x12(:,:,132))
  call Hloop_TV_S(ntryL,G0H12(31),16,wf4(:,2),3,G1H3(76),m3h4x3(:,57),heltab2x12(:,:,133))
  call Hloop_SV_T(ntryL,G0H12(32),16,wf4(:,2),3,G1H3(77),m3h4x3(:,58),heltab2x12(:,:,134))
  call Hloop_UV_W(ntryL,G1H12(49),16,wf4(:,1),3,G2H3(35),m3h4x3(:,59),heltab2x12(:,:,135))
  call Hloop_UW_V(ntryL,G1H12(50),16,wf4(:,1),3,G2H3(36),m3h4x3(:,60),heltab2x12(:,:,136))
  call Hloop_UV_W(ntryL,G1H12(51),16,wf4(:,2),3,G2H3(37),m3h4x3(:,61),heltab2x12(:,:,137))
  call Hloop_UW_V(ntryL,G1H12(52),16,wf4(:,2),3,G2H3(38),m3h4x3(:,62),heltab2x12(:,:,138))
  call Hloop_UV_W(ntryL,G0H12(33),16,wf4(:,1),3,G1H3(78),m3h4x3(:,63),heltab2x12(:,:,139))
  call Hloop_UW_V(ntryL,G0H12(34),16,wf4(:,1),3,G1H3(82),m3h4x3(:,64),heltab2x12(:,:,140))
  call Hloop_UV_W(ntryL,G0H12(35),16,wf4(:,2),3,G1H3(2),m3h4x3(:,65),heltab2x12(:,:,141))
  call Hloop_UW_V(ntryL,G0H12(36),16,wf4(:,2),3,G1H3(17),m3h4x3(:,66),heltab2x12(:,:,142))
  call Hloop_VV_S(ntryL,G1H12(54),wf4(:,1),G1H3(20),m3h4x3(:,67),heltab2x12(:,:,143))
  call Hloop_VV_S(ntryL,G1H12(56),wf4(:,2),G1H3(21),m3h4x3(:,68),heltab2x12(:,:,144))
  call Hloop_SV_V(ntryL,G0H12(37),wf4(:,1),G0H3(9),m3h4x3(:,69),heltab2x12(:,:,145))
  call Hloop_SV_V(ntryL,G0H12(38),wf4(:,1),G0H3(10),m3h4x3(:,70),heltab2x12(:,:,146))
  call Hloop_SV_V(ntryL,G0H12(39),wf4(:,2),G0H3(11),m3h4x3(:,71),heltab2x12(:,:,147))
  call Hloop_SV_V(ntryL,G0H12(40),wf4(:,2),G0H3(12),m3h4x3(:,72),heltab2x12(:,:,148))
  call Hloop_AV_Q(ntryL,G1H12(57),wf4(:,1),G1H3(8),m3h4x3(:,73),heltab2x12(:,:,149))
  call Hloop_A_Q(ntryL,G1H3(8),19,nML,G2H3(39),n2h3(21))
  call Hloop_QV_A(ntryL,G1H12(58),wf4(:,1),G1H3(11),m3h4x3(:,74),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H3(11),19,nML,G2H3(40),n2h3(22))
  call Hloop_AV_Q(ntryL,G1H12(59),wf4(:,1),G1H3(12),m3h4x3(:,75),heltab2x12(:,:,151))
  call Hloop_A_Q(ntryL,G1H3(12),19,nMT,G2H3(41),n2h3(23))
  call Hloop_QV_A(ntryL,G1H12(60),wf4(:,1),G1H3(27),m3h4x3(:,76),heltab2x12(:,:,152))
  call Hloop_Q_A(ntryL,G1H3(27),19,nMT,G2H3(42),n2h3(24))
  call Hloop_AV_Q(ntryL,G1H12(61),wf4(:,1),G1H3(32),m3h4x3(:,77),heltab2x12(:,:,153))
  call Hloop_A_Q(ntryL,G1H3(32),19,nMB,G2H3(43),n2h3(25))
  call Hloop_QV_A(ntryL,G1H12(62),wf4(:,1),G1H3(19),m3h4x3(:,78),heltab2x12(:,:,154))
  call Hloop_Q_A(ntryL,G1H3(19),19,nMB,G2H3(44),n2h3(26))
  call Hloop_AZ_Q(ntryL,G1H12(63),wf4(:,2),G1H3(3),ngZl,m3h4x3(:,79),heltab2x12(:,:,155))
  call Hloop_A_Q(ntryL,G1H3(3),19,nML,G2H3(45),n2h3(27))
  call Hloop_QZ_A(ntryL,G1H12(64),wf4(:,2),G1H3(36),ngZl,m3h4x3(:,80),heltab2x12(:,:,156))
  call Hloop_Q_A(ntryL,G1H3(36),19,nML,G2H3(46),n2h3(28))
  call Hloop_AZ_Q(ntryL,G1H12(65),wf4(:,2),G1H3(8),ngZu,m3h4x3(:,81),heltab2x12(:,:,157))
  call Hloop_A_Q(ntryL,G1H3(8),19,nMT,G2H3(47),n2h3(29))
  call Hloop_QZ_A(ntryL,G1H12(66),wf4(:,2),G1H3(11),ngZu,m3h4x3(:,82),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H3(11),19,nMT,G2H3(48),n2h3(30))
  call Hloop_AZ_Q(ntryL,G1H12(67),wf4(:,2),G1H3(12),ngZd,m3h4x3(:,83),heltab2x12(:,:,159))
  call Hloop_A_Q(ntryL,G1H3(12),19,nMB,G2H3(49),n2h3(31))
  call Hloop_QZ_A(ntryL,G1H12(68),wf4(:,2),G1H3(27),ngZd,m3h4x3(:,84),heltab2x12(:,:,160))
  call Hloop_Q_A(ntryL,G1H3(27),19,nMB,G2H3(50),n2h3(32))
  call Hloop_SV_T(ntryL,G1H12(69),16,wf4(:,1),3,G2H3(51),m3h4x3(:,85),heltab2x12(:,:,161))
  call Hloop_TV_S(ntryL,G1H12(70),16,wf4(:,1),3,G2H3(52),m3h4x3(:,86),heltab2x12(:,:,162))
  call Hloop_SV_T(ntryL,G1H12(71),16,wf4(:,2),3,G2H3(53),m3h4x3(:,87),heltab2x12(:,:,163))
  call Hloop_TV_S(ntryL,G1H12(72),16,wf4(:,2),3,G2H3(54),m3h4x3(:,88),heltab2x12(:,:,164))
  call Hloop_DV_C(ntryL,G1H12(75),16,wf4(:,1),G2H3(55),m3h4x3(:,89),heltab2x12(:,:,165))
  call Hloop_CV_D(ntryL,G1H12(76),16,wf4(:,1),3,G2H3(56),m3h4x3(:,90),heltab2x12(:,:,166))
  call Hloop_DV_C(ntryL,G1H12(79),16,wf4(:,2),G2H3(57),m3h4x3(:,91),heltab2x12(:,:,167))
  call Hloop_CV_D(ntryL,G1H12(80),16,wf4(:,2),3,G2H3(58),m3h4x3(:,92),heltab2x12(:,:,168))
  call Hloop_UW_V(ntryL,G1H12(81),16,wf4(:,1),3,G2H3(59),m3h4x3(:,93),heltab2x12(:,:,169))
  call Hloop_UV_W(ntryL,G1H12(82),16,wf4(:,1),3,G2H3(60),m3h4x3(:,94),heltab2x12(:,:,170))
  call Hloop_UW_V(ntryL,G1H12(83),16,wf4(:,2),3,G2H3(61),m3h4x3(:,95),heltab2x12(:,:,171))
  call Hloop_UV_W(ntryL,G1H12(84),16,wf4(:,2),3,G2H3(62),m3h4x3(:,96),heltab2x12(:,:,172))
  call Hloop_VV_S(ntryL,G0H12(41),wf4(:,1),G0H3(13),m3h4x3(:,97),heltab2x12(:,:,173))
  call Hloop_VV_S(ntryL,G0H12(42),wf4(:,1),G0H3(14),m3h4x3(:,98),heltab2x12(:,:,174))
  call Hloop_VV_S(ntryL,G0H12(43),wf4(:,2),G0H3(15),m3h4x3(:,99),heltab2x12(:,:,175))
  call Hloop_VV_S(ntryL,G0H12(44),wf4(:,2),G0H3(16),m3h4x3(:,100),heltab2x12(:,:,176))
  call Hloop_SV_T(ntryL,G0H12(45),16,wf4(:,1),3,G1H3(32),m3h4x3(:,101),heltab2x12(:,:,177))
  call Hloop_TV_S(ntryL,G0H12(46),16,wf4(:,1),3,G1H3(19),m3h4x3(:,102),heltab2x12(:,:,178))
  call Hloop_SV_T(ntryL,G0H12(47),16,wf4(:,2),3,G1H3(3),m3h4x3(:,103),heltab2x12(:,:,179))
  call Hloop_TV_S(ntryL,G0H12(48),16,wf4(:,2),3,G1H3(36),m3h4x3(:,104),heltab2x12(:,:,180))
  call Hloop_SV_V(ntryL,G1H12(85),wf4(:,1),G1H3(8),m3h4x3(:,105),heltab2x12(:,:,181))
  call Hloop_SV_V(ntryL,G1H12(86),wf4(:,1),G1H3(11),m3h4x3(:,106),heltab2x12(:,:,182))
  call Hloop_SV_V(ntryL,G1H12(87),wf4(:,2),G1H3(12),m3h4x3(:,107),heltab2x12(:,:,183))
  call Hloop_SV_V(ntryL,G1H12(88),wf4(:,2),G1H3(27),m3h4x3(:,108),heltab2x12(:,:,184))
  call Hloop_SV_T(ntryL,G1H12(89),16,wf4(:,1),3,G2H3(63),m3h4x3(:,109),heltab2x12(:,:,185))
  call Hloop_TV_S(ntryL,G1H12(90),16,wf4(:,1),3,G2H3(64),m3h4x3(:,110),heltab2x12(:,:,186))
  call Hloop_SV_T(ntryL,G1H12(91),16,wf4(:,2),3,G2H3(65),m3h4x3(:,111),heltab2x12(:,:,187))
  call Hloop_TV_S(ntryL,G1H12(92),16,wf4(:,2),3,G2H3(66),m3h4x3(:,112),heltab2x12(:,:,188))
  call Hloop_VV_S(ntryL,G1H12(94),wf4(:,1),G1H3(83),m3h4x3(:,113),heltab2x12(:,:,189))
  call Hloop_VV_S(ntryL,G1H12(96),wf4(:,2),G1H3(84),m3h4x3(:,114),heltab2x12(:,:,190))
  call Hloop_UW_V(ntryL,G0H12(49),16,wf4(:,1),3,G1H3(85),m3h4x3(:,115),heltab2x12(:,:,191))
  call Hloop_UV_W(ntryL,G0H12(50),16,wf4(:,1),3,G1H3(86),m3h4x3(:,116),heltab2x12(:,:,192))
  call Hloop_UW_V(ntryL,G0H12(51),16,wf4(:,2),3,G1H3(87),m3h4x3(:,117),heltab2x12(:,:,193))
  call Hloop_UV_W(ntryL,G0H12(52),16,wf4(:,2),3,G1H3(88),m3h4x3(:,118),heltab2x12(:,:,194))
  call Hloop_SV_V(ntryL,G0H12(54),wf4(:,1),G0H3(17),m3h4x3(:,119),heltab2x12(:,:,195))
  call Hloop_SV_V(ntryL,G0H12(56),wf4(:,2),G0H3(18),m3h4x3(:,120),heltab2x12(:,:,196))
  call Hloop_VV_S(ntryL,G0H12(58),wf4(:,1),G0H3(19),m3h4x3(:,121),heltab2x12(:,:,197))
  call Hloop_VV_S(ntryL,G0H12(60),wf4(:,2),G0H3(20),m3h4x3(:,122),heltab2x12(:,:,198))
  call Hloop_SV_T(ntryL,G0H12(61),16,wf4(:,1),3,G1H3(89),m3h4x3(:,123),heltab2x12(:,:,199))
  call Hloop_TV_S(ntryL,G0H12(62),16,wf4(:,1),3,G1H3(90),m3h4x3(:,124),heltab2x12(:,:,200))
  call Hloop_SV_T(ntryL,G0H12(63),16,wf4(:,2),3,G1H3(91),m3h4x3(:,125),heltab2x12(:,:,201))
  call Hloop_TV_S(ntryL,G0H12(64),16,wf4(:,2),3,G1H3(92),m3h4x3(:,126),heltab2x12(:,:,202))
  call Hloop_SV_V(ntryL,G1H12(98),wf4(:,1),G1H3(93),m3h4x3(:,127),heltab2x12(:,:,203))
  call Hloop_SV_V(ntryL,G1H12(100),wf4(:,2),G1H3(94),m3h4x3(:,128),heltab2x12(:,:,204))
  call Hloop_UW_V(ntryL,G1H12(101),16,wf4(:,1),3,G2H3(67),m3h4x3(:,129),heltab2x12(:,:,205))
  call Hloop_UV_W(ntryL,G1H12(102),16,wf4(:,1),3,G2H3(68),m3h4x3(:,130),heltab2x12(:,:,206))
  call Hloop_UW_V(ntryL,G1H12(103),16,wf4(:,2),3,G2H3(69),m3h4x3(:,131),heltab2x12(:,:,207))
  call Hloop_UV_W(ntryL,G1H12(104),16,wf4(:,2),3,G2H3(70),m3h4x3(:,132),heltab2x12(:,:,208))
  call Hloop_VV_S(ntryL,G1H12(105),wf4(:,1),G1H3(95),m3h4x3(:,133),heltab2x12(:,:,209))
  call Hloop_VV_S(ntryL,G1H12(106),wf4(:,1),G1H3(96),m3h4x3(:,134),heltab2x12(:,:,210))
  call Hloop_VV_S(ntryL,G1H12(107),wf4(:,2),G1H3(97),m3h4x3(:,135),heltab2x12(:,:,211))
  call Hloop_VV_S(ntryL,G1H12(108),wf4(:,2),G1H3(98),m3h4x3(:,136),heltab2x12(:,:,212))
  call Hloop_UW_V(ntryL,G0H12(65),16,wf4(:,1),3,G1H3(99),m3h4x3(:,137),heltab2x12(:,:,213))
  call Hloop_UV_W(ntryL,G0H12(66),16,wf4(:,1),3,G1H3(100),m3h4x3(:,138),heltab2x12(:,:,214))
  call Hloop_UW_V(ntryL,G0H12(67),16,wf4(:,2),3,G1H3(101),m3h4x3(:,139),heltab2x12(:,:,215))
  call Hloop_UV_W(ntryL,G0H12(68),16,wf4(:,2),3,G1H3(102),m3h4x3(:,140),heltab2x12(:,:,216))
  call Hloop_SV_V(ntryL,G0H12(69),wf4(:,1),G0H3(21),m3h4x3(:,141),heltab2x12(:,:,217))
  call Hloop_SV_V(ntryL,G0H12(70),wf4(:,1),G0H3(22),m3h4x3(:,142),heltab2x12(:,:,218))
  call Hloop_SV_V(ntryL,G0H12(71),wf4(:,2),G0H3(23),m3h4x3(:,143),heltab2x12(:,:,219))
  call Hloop_SV_V(ntryL,G0H12(72),wf4(:,2),G0H3(24),m3h4x3(:,144),heltab2x12(:,:,220))
  call Hloop_QS_A(ntryL,G1H12(109),ex3(:),G1H12(7),ngH,m3h1x12(:,13),heltab2x12(:,:,221))
  call Hloop_Q_A(ntryL,G1H12(7),20,nML,G2H12(1),n2h12(71))
  call Hloop_AS_Q(ntryL,G1H12(110),ex3(:),G1H12(13),ngH,m3h1x12(:,14),heltab2x12(:,:,222))
  call Hloop_A_Q(ntryL,G1H12(13),20,nML,G2H12(2),n2h12(72))
  call Hloop_QS_A(ntryL,G1H12(111),ex3(:),G1H12(19),ngH,m3h1x12(:,15),heltab2x12(:,:,223))
  call Hloop_Q_A(ntryL,G1H12(19),20,nMT,G2H12(3),n2h12(73))
  call Hloop_AS_Q(ntryL,G1H12(112),ex3(:),G1H12(1),ngH,m3h1x12(:,16),heltab2x12(:,:,224))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(4),n2h12(74))
  call Hloop_QS_A(ntryL,G1H12(113),ex3(:),G1H12(23),ngH,m3h1x12(:,17),heltab2x12(:,:,225))
  call Hloop_Q_A(ntryL,G1H12(23),20,nMB,G2H12(5),n2h12(75))
  call Hloop_AS_Q(ntryL,G1H12(114),ex3(:),G1H12(24),ngH,m3h1x12(:,18),heltab2x12(:,:,226))
  call Hloop_A_Q(ntryL,G1H12(24),20,nMB,G2H12(6),n2h12(76))
  call Hloop_QS_A(ntryL,G1H12(115),ex3(:),G1H12(25),ngH,m3h1x12(:,19),heltab2x12(:,:,227))
  call Hloop_Q_A(ntryL,G1H12(25),20,nML,G2H12(7),n2h12(77))
  call Hloop_AS_Q(ntryL,G1H12(116),ex3(:),G1H12(26),ngH,m3h1x12(:,20),heltab2x12(:,:,228))
  call Hloop_A_Q(ntryL,G1H12(26),20,nML,G2H12(8),n2h12(78))
  call Hloop_QS_A(ntryL,G1H12(117),ex3(:),G1H12(33),ngH,m3h1x12(:,21),heltab2x12(:,:,229))
  call Hloop_Q_A(ntryL,G1H12(33),20,nMT,G2H12(9),n2h12(79))
  call Hloop_AS_Q(ntryL,G1H12(118),ex3(:),G1H12(35),ngH,m3h1x12(:,22),heltab2x12(:,:,230))
  call Hloop_A_Q(ntryL,G1H12(35),20,nMT,G2H12(10),n2h12(80))
  call Hloop_QS_A(ntryL,G1H12(119),ex3(:),G1H12(53),ngH,m3h1x12(:,23),heltab2x12(:,:,231))
  call Hloop_Q_A(ntryL,G1H12(53),20,nMB,G2H12(11),n2h12(81))
  call Hloop_AS_Q(ntryL,G1H12(120),ex3(:),G1H12(55),ngH,m3h1x12(:,24),heltab2x12(:,:,232))
  call Hloop_A_Q(ntryL,G1H12(55),20,nMB,G2H12(12),n2h12(82))
  call Hloop_SS_S(ntryL,G1H12(121),ex3(:),G1H12(73),m3h1x12(:,25),heltab2x12(:,:,233))
  call Hloop_SS_S(ntryL,G1H12(122),ex3(:),G1H12(74),m3h1x12(:,26),heltab2x12(:,:,234))
  call Hloop_SS_S(ntryL,G1H12(123),ex3(:),G1H12(77),m3h1x12(:,27),heltab2x12(:,:,235))
  call Hloop_SS_S(ntryL,G1H12(124),ex3(:),G1H12(78),m3h1x12(:,28),heltab2x12(:,:,236))
  call Hloop_SS_S(ntryL,G1H12(127),ex3(:),G1H12(93),m3h1x12(:,29),heltab2x12(:,:,237))
  call Hloop_SS_S(ntryL,G1H12(128),ex3(:),G1H12(95),m3h1x12(:,30),heltab2x12(:,:,238))
  call Hloop_SS_S(ntryL,G1H12(131),ex3(:),G1H12(97),m3h1x12(:,31),heltab2x12(:,:,239))
  call Hloop_SS_S(ntryL,G1H12(132),ex3(:),G1H12(99),m3h1x12(:,32),heltab2x12(:,:,240))
  call Hloop_VS_V(ntryL,G1H12(133),ex3(:),G1H12(125),m3h1x12(:,33),heltab2x12(:,:,241))
  call Hloop_VS_V(ntryL,G1H12(134),ex3(:),G1H12(126),m3h1x12(:,34),heltab2x12(:,:,242))
  call Hloop_VS_V(ntryL,G1H12(135),ex3(:),G1H12(129),m3h1x12(:,35),heltab2x12(:,:,243))
  call Hloop_VS_V(ntryL,G1H12(136),ex3(:),G1H12(130),m3h1x12(:,36),heltab2x12(:,:,244))
  call Hloop_SS_S(ntryL,G1H12(138),ex3(:),G1H12(137),m3h1x12(:,37),heltab2x12(:,:,245))
  call Hloop_SS_S(ntryL,G1H12(140),ex3(:),G1H12(139),m3h1x12(:,38),heltab2x12(:,:,246))
  call Hloop_SS_S(ntryL,G0H12(73),ex3(:),G0H12(121),m3h1x12(:,39),heltab2x12(:,:,247))
  call Hloop_SS_S(ntryL,G0H12(74),ex3(:),G0H12(119),m3h1x12(:,40),heltab2x12(:,:,248))
  call Hloop_SS_S(ntryL,G0H12(75),ex3(:),G0H12(6),m3h1x12(:,41),heltab2x12(:,:,249))
  call Hloop_SS_S(ntryL,G0H12(76),ex3(:),G0H12(120),m3h1x12(:,42),heltab2x12(:,:,250))
  call Hloop_ST_V(ntryL,G1H12(141),16,ex3(:),4,G2H12(13),m3h1x12(:,43),heltab2x12(:,:,251))
  call Hloop_ST_V(ntryL,G1H12(142),16,ex3(:),4,G2H12(14),m3h1x12(:,44),heltab2x12(:,:,252))
  call Hloop_ST_V(ntryL,G1H12(143),16,ex3(:),4,G2H12(15),m3h1x12(:,45),heltab2x12(:,:,253))
  call Hloop_ST_V(ntryL,G1H12(144),16,ex3(:),4,G2H12(16),m3h1x12(:,46),heltab2x12(:,:,254))
  call Hloop_VT_S(ntryL,G0H12(77),16,ex3(:),4,G1H12(157),m3h1x12(:,47),heltab2x12(:,:,255))
  call Hloop_VT_S(ntryL,G0H12(78),16,ex3(:),4,G1H12(159),m3h1x12(:,48),heltab2x12(:,:,256))
  call Hloop_VT_S(ntryL,G0H12(79),16,ex3(:),4,G1H12(169),m3h1x12(:,49),heltab2x12(:,:,257))
  call Hloop_VT_S(ntryL,G0H12(80),16,ex3(:),4,G1H12(174),m3h1x12(:,50),heltab2x12(:,:,258))
  call Hloop_SS_S(ntryL,G0H12(81),ex3(:),G0H12(7),m3h1x12(:,51),heltab2x12(:,:,259))
  call Hloop_SS_S(ntryL,G0H12(82),ex3(:),G0H12(117),m3h1x12(:,52),heltab2x12(:,:,260))
  call Hloop_SS_S(ntryL,G0H12(83),ex3(:),G0H12(4),m3h1x12(:,53),heltab2x12(:,:,261))
  call Hloop_SS_S(ntryL,G0H12(84),ex3(:),G0H12(118),m3h1x12(:,54),heltab2x12(:,:,262))
  call Hloop_ST_V(ntryL,G1H12(145),16,ex3(:),4,G2H12(17),m3h1x12(:,55),heltab2x12(:,:,263))
  call Hloop_ST_V(ntryL,G1H12(146),16,ex3(:),4,G2H12(18),m3h1x12(:,56),heltab2x12(:,:,264))
  call Hloop_ST_V(ntryL,G1H12(147),16,ex3(:),4,G2H12(19),m3h1x12(:,57),heltab2x12(:,:,265))
  call Hloop_ST_V(ntryL,G1H12(148),16,ex3(:),4,G2H12(20),m3h1x12(:,58),heltab2x12(:,:,266))
  call Hloop_ST_V(ntryL,G0H12(86),16,ex3(:),4,G1H12(183),m3h1x12(:,59),heltab2x12(:,:,267))
  call Hloop_ST_V(ntryL,G0H12(88),16,ex3(:),4,G1H12(190),m3h1x12(:,60),heltab2x12(:,:,268))
  call Hloop_VT_S(ntryL,G0H12(90),16,ex3(:),4,G1H12(188),m3h1x12(:,61),heltab2x12(:,:,269))
  call Hloop_VT_S(ntryL,G0H12(92),16,ex3(:),4,G1H12(189),m3h1x12(:,62),heltab2x12(:,:,270))
  call Hloop_VT_S(ntryL,G1H12(149),16,ex3(:),4,G2H12(21),m3h1x12(:,63),heltab2x12(:,:,271))
  call Hloop_VT_S(ntryL,G1H12(150),16,ex3(:),4,G2H12(22),m3h1x12(:,64),heltab2x12(:,:,272))
  call Hloop_VT_S(ntryL,G1H12(151),16,ex3(:),4,G2H12(23),m3h1x12(:,65),heltab2x12(:,:,273))
  call Hloop_VT_S(ntryL,G1H12(152),16,ex3(:),4,G2H12(24),m3h1x12(:,66),heltab2x12(:,:,274))
  call Hloop_VS_V(ntryL,G0H12(93),ex3(:),G0H12(5),m3h1x12(:,67),heltab2x12(:,:,275))
  call Hloop_VS_V(ntryL,G0H12(94),ex3(:),G0H12(21),m3h1x12(:,68),heltab2x12(:,:,276))
  call Hloop_VS_V(ntryL,G0H12(95),ex3(:),G0H12(23),m3h1x12(:,69),heltab2x12(:,:,277))
  call Hloop_VS_V(ntryL,G0H12(96),ex3(:),G0H12(25),m3h1x12(:,70),heltab2x12(:,:,278))
  call Hloop_ST_V(ntryL,G0H12(97),16,ex3(:),4,G1H12(181),m3h1x12(:,71),heltab2x12(:,:,279))
  call Hloop_ST_V(ntryL,G0H12(98),16,ex3(:),4,G1H12(182),m3h1x12(:,72),heltab2x12(:,:,280))
  call Hloop_ST_V(ntryL,G0H12(99),16,ex3(:),4,G1H12(4),m3h1x12(:,73),heltab2x12(:,:,281))
  call Hloop_ST_V(ntryL,G0H12(100),16,ex3(:),4,G1H12(5),m3h1x12(:,74),heltab2x12(:,:,282))
  call Hloop_VT_S(ntryL,G1H12(153),16,ex3(:),4,G2H12(25),m3h1x12(:,75),heltab2x12(:,:,283))
  call Hloop_VT_S(ntryL,G1H12(154),16,ex3(:),4,G2H12(26),m3h1x12(:,76),heltab2x12(:,:,284))
  call Hloop_VT_S(ntryL,G1H12(155),16,ex3(:),4,G2H12(27),m3h1x12(:,77),heltab2x12(:,:,285))
  call Hloop_VT_S(ntryL,G1H12(156),16,ex3(:),4,G2H12(28),m3h1x12(:,78),heltab2x12(:,:,286))
  call Hloop_VS_V(ntryL,G0H12(101),ex3(:),G0H12(27),m3h1x12(:,79),heltab2x12(:,:,287))
  call Hloop_VS_V(ntryL,G0H12(102),ex3(:),G0H12(53),m3h1x12(:,80),heltab2x12(:,:,288))
  call Hloop_VS_V(ntryL,G0H12(103),ex3(:),G0H12(55),m3h1x12(:,81),heltab2x12(:,:,289))
  call Hloop_VS_V(ntryL,G0H12(104),ex3(:),G0H12(57),m3h1x12(:,82),heltab2x12(:,:,290))
  call Hloop_VS_V(ntryL,G1H12(158),ex3(:),G1H12(6),m3h1x12(:,83),heltab2x12(:,:,291))
  call Hloop_VS_V(ntryL,G1H12(160),ex3(:),G1H12(8),m3h1x12(:,84),heltab2x12(:,:,292))
  call Hloop_QA_Z(ntryL,G1H12(161),ex2(:),G1H6(1),ngZu,m3h2x6(:,61),heltab2x12(:,:,293))
  call Hloop_QA_W(ntryL,G1H12(162),ex2(:),G1H6(2),m3h2x6(:,62),heltab2x12(:,:,294))
  call Hloop_ST_V(ntryL,G0H12(105),16,ex3(:),4,G1H12(9),m3h1x12(:,85),heltab2x12(:,:,295))
  call Hloop_VS_V(ntryL,G1H12(163),ex3(:),G1H12(10),m3h1x12(:,86),heltab2x12(:,:,296))
  call Hloop_WA_Q(ntryL,G0H12(106),ex2(:),G0H6(5),m3h2x6(:,63),heltab2x12(:,:,297))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(8),n2h6(63))
  call Hloop_WA_Q(ntryL,G1H12(164),ex2(:),G1H6(9),m3h2x6(:,64),heltab2x12(:,:,298))
  call Hloop_A_Q(ntryL,G1H6(9),18,0,G2H6(5),n2h6(64))
  call Hloop_AQ_Z(ntryL,G1H12(165),ex1(:),G1H6(10),ngZu,m3h2x6(:,65),heltab2x12(:,:,299))
  call Hloop_AQ_W(ntryL,G1H12(166),ex1(:),G1H6(5),m3h2x6(:,66),heltab2x12(:,:,300))
  call Hloop_ST_V(ntryL,G0H12(107),16,ex3(:),4,G1H12(11),m3h1x12(:,87),heltab2x12(:,:,301))
  call Hloop_VS_V(ntryL,G1H12(167),ex3(:),G1H12(12),m3h1x12(:,88),heltab2x12(:,:,302))
  call Hloop_WQ_A(ntryL,G0H12(108),ex1(:),G0H6(5),m3h2x6(:,67),heltab2x12(:,:,303))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(6),n2h6(65))
  call Hloop_WQ_A(ntryL,G1H12(168),ex1(:),G1H6(7),m3h2x6(:,68),heltab2x12(:,:,304))
  call Hloop_Q_A(ntryL,G1H6(7),17,0,G2H6(6),n2h6(66))
  call Hloop_ZQ_A(ntryL,G0H12(109),ex1(:),G0H6(5),ngZu,m3h2x6(:,69),heltab2x12(:,:,305))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(11),n2h6(67))
  call Hloop_WQ_A(ntryL,G0H12(110),ex1(:),G0H6(5),m3h2x6(:,70),heltab2x12(:,:,306))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(25),n2h6(68))
  call Hloop_AQ_V(ntryL,G1H12(172),ex1(:),G1H6(13),m3h2x6(:,71),heltab2x12(:,:,307))
  call Hloop_AQ_Z(ntryL,G1H12(170),ex1(:),G1H6(9),ngZu,m3h2x6(:,72),heltab2x12(:,:,308))
  call Hloop_AQ_W(ntryL,G1H12(171),ex1(:),G1H6(7),m3h2x6(:,73),heltab2x12(:,:,309))
  call Hloop_ZQ_A(ntryL,G0H12(111),ex1(:),G0H6(5),ngZu,m3h2x6(:,74),heltab2x12(:,:,310))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(26),n2h6(69))
  call Hloop_WQ_A(ntryL,G0H12(112),ex1(:),G0H6(5),m3h2x6(:,75),heltab2x12(:,:,311))
  call Hloop_Q_A(ntryL,G0H6(5),17,0,G1H6(27),n2h6(70))
  call Hloop_WQ_A(ntryL,G1H12(173),ex1(:),G1H6(28),m3h2x6(:,76),heltab2x12(:,:,312))
  call Hloop_Q_A(ntryL,G1H6(28),17,0,G2H6(7),n2h6(71))
  call Hloop_ZA_Q(ntryL,G0H12(113),ex2(:),G0H6(5),ngZu,m3h2x6(:,77),heltab2x12(:,:,313))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(28),n2h6(72))
  call Hloop_WA_Q(ntryL,G0H12(114),ex2(:),G0H6(5),m3h2x6(:,78),heltab2x12(:,:,314))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(29),n2h6(73))
  call Hloop_QA_V(ntryL,G1H12(177),ex2(:),G1H6(30),m3h2x6(:,79),heltab2x12(:,:,315))
  call Hloop_QA_Z(ntryL,G1H12(175),ex2(:),G1H6(31),ngZu,m3h2x6(:,80),heltab2x12(:,:,316))
  call Hloop_QA_W(ntryL,G1H12(176),ex2(:),G1H6(32),m3h2x6(:,81),heltab2x12(:,:,317))
  call Hloop_ZA_Q(ntryL,G0H12(115),ex2(:),G0H6(5),ngZu,m3h2x6(:,82),heltab2x12(:,:,318))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(33),n2h6(74))
  call Hloop_WA_Q(ntryL,G0H12(116),ex2(:),G0H6(5),m3h2x6(:,83),heltab2x12(:,:,319))
  call Hloop_A_Q(ntryL,G0H6(5),18,0,G1H6(34),n2h6(75))
  call Hloop_WA_Q(ntryL,G1H12(178),ex2(:),G1H6(35),m3h2x6(:,84),heltab2x12(:,:,320))
  call Hloop_A_Q(ntryL,G1H6(35),18,0,G2H6(9),n2h6(76))
  call Hloop_AQ_W(ntryL,G1H12(179),ex1(:),G1H6(35),m3h2x6(:,85),heltab2x12(:,:,321))
  call Hloop_WQ_A(ntryL,G1H12(180),ex1(:),G1H6(36),m3h2x6(:,86),heltab2x12(:,:,322))
  call Hloop_Q_A(ntryL,G1H6(36),17,0,G2H6(10),n2h6(77))
  call Hloop_VS_V(ntryL,G0H6(1),ex3(:),G0H6(5),m3h1x6(:,9),heltab2x6(:,:,65))
  call Hloop_VS_V(ntryL,G0H6(2),ex3(:),G0H6(1),m3h1x6(:,10),heltab2x6(:,:,66))
  call Hloop_QA_W(ntryL,G1H6(19),ex2(:),G1H3(103),m3h2x3(:,41),heltab2x6(:,:,67))
  call Hloop_QA_W(ntryL,G1H6(20),ex2(:),G1H3(104),m3h2x3(:,42),heltab2x6(:,:,68))
  call Hloop_QA_W(ntryL,G1H6(21),ex2(:),G1H3(105),m3h2x3(:,43),heltab2x6(:,:,69))
  call Hloop_QA_W(ntryL,G1H6(22),ex2(:),G1H3(106),m3h2x3(:,44),heltab2x6(:,:,70))
  call Hloop_VS_V(ntryL,G0H6(3),ex3(:),G0H6(2),m3h1x6(:,11),heltab2x6(:,:,71))
  call Hloop_VS_V(ntryL,G0H6(4),ex3(:),G0H6(3),m3h1x6(:,12),heltab2x6(:,:,72))
  call Hloop_AQ_W(ntryL,G1H6(23),ex1(:),G1H3(107),m3h2x3(:,45),heltab2x6(:,:,73))
  call Hloop_AQ_W(ntryL,G1H6(24),ex1(:),G1H3(108),m3h2x3(:,46),heltab2x6(:,:,74))
  call Hloop_AQ_W(ntryL,G1H6(3),ex1(:),G1H3(109),m3h2x3(:,47),heltab2x6(:,:,75))
  call Hloop_AQ_W(ntryL,G1H6(4),ex1(:),G1H3(110),m3h2x3(:,48),heltab2x6(:,:,76))
  call Hloop_QA_V(ntryL,G1H12(186),ex2(:),G1H6(36),m3h2x6(:,87),heltab2x12(:,:,323))
  call Hloop_QA_Z(ntryL,G1H12(184),ex2(:),G1H6(19),ngZu,m3h2x6(:,88),heltab2x12(:,:,324))
  call Hloop_QA_W(ntryL,G1H12(185),ex2(:),G1H6(20),m3h2x6(:,89),heltab2x12(:,:,325))
  call Hloop_WA_Q(ntryL,G1H12(187),ex2(:),G1H6(21),m3h2x6(:,90),heltab2x12(:,:,326))
  call Hloop_A_Q(ntryL,G1H6(21),22,0,G2H6(12),n2h6(78))
  call Hloop_AQ_V(ntryL,G1H12(193),ex1(:),G1H6(22),m3h2x6(:,91),heltab2x12(:,:,327))
  call Hloop_AQ_Z(ntryL,G1H12(191),ex1(:),G1H6(23),ngZu,m3h2x6(:,92),heltab2x12(:,:,328))
  call Hloop_AQ_W(ntryL,G1H12(192),ex1(:),G1H6(24),m3h2x6(:,93),heltab2x12(:,:,329))
  call Hloop_WQ_A(ntryL,G1H12(194),ex1(:),G1H6(3),m3h2x6(:,94),heltab2x12(:,:,330))
  call Hloop_Q_A(ntryL,G1H6(3),21,0,G2H6(14),n2h6(79))
  call Hloop_WQ_A(ntryL,G1H12(195),ex1(:),G1H6(4),m3h2x6(:,95),heltab2x12(:,:,331))
  call Hloop_Q_A(ntryL,G1H6(4),21,0,G2H6(15),n2h6(80))
  call Hloop_AQ_W(ntryL,G1H12(196),ex1(:),G1H6(21),m3h2x6(:,96),heltab2x12(:,:,332))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex2(:),G1H2(8),ngZu,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(8),26,0,G2H2(6),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(6),ex2(:),G1H2(12),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(12),26,0,G2H2(7),n2h2(16))
  call Hloop_ZA_Q(ntryL,G0H4(3),ex2(:),G0H2(1),ngZu,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(2),n2h2(17))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),25,0,G2H2(8),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(8),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(8),25,0,G2H2(10),n2h2(19))
  call Hloop_ZQ_A(ntryL,G0H4(5),ex1(:),G0H2(1),ngZu,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(12),n2h2(20))
call HGT_lower_alpha_OLR(G1H6(18),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(18),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(107),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(70),[G2H3(69),G2H3(68),G2H3(67),G1H3(23),G1H3(16) &
    ,G0H3(18),G0H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(110),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G2H3(27),G1H3(7),G0H3(12),G0H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(103),[G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(106),[G1H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(25),G1H3(14),G0H3(11),G0H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G2H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G2H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G2H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(13),G0H3(3),G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G2H3(15),G0H3(4),G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G2H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(26),[G1H3(54),G1H3(50),G1H3(49),G1H3(38),G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(59),[G1H3(10),G1H3(44),G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(60),[G1H3(58),G1H3(48),G1H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(34),[G2H3(33),G2H3(32),G2H3(31),G0H3(8),G0H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(38),[G2H3(37),G2H3(36),G2H3(35),G0H3(6),G0H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(78),G1H3(66),G1H3(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(17),[G1H3(82),G1H3(70),G1H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(20),G1H3(77),G1H3(76),G1H3(72),G1H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G2H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G2H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G2H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G2H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G2H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G2H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(53),[G2H3(51),G0H3(15),G0H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(54),[G2H3(52),G0H3(16),G0H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(57),[G2H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(61),[G2H3(59),G0H3(23),G0H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(62),[G2H3(60),G0H3(24),G0H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(84),[G1H3(83),G1H3(36),G1H3(3),G1H3(19),G1H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(87),[G1H3(85),G1H3(12),G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(88),[G1H3(86),G1H3(27),G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(65),G2H3(64),G2H3(63),G0H3(20),G0H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(97),[G1H3(95),G1H3(91),G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(98),[G1H3(96),G1H3(92),G1H3(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(102),[G1H3(101),G1H3(100),G1H3(99),G1H3(94),G1H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(157),[G1H12(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(159),[G1H12(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(169),[G1H12(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(174),[G1H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(181),[G1H12(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(182),[G1H12(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(188),[G1H12(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(189),[G1H12(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(21),[G0H12(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(22),[G0H12(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(23),[G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(24),[G0H12(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(14),[G0H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G0H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G0H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(25),[G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(26),[G0H12(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(28),[G0H12(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(17),[G0H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(18),[G0H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(19),[G0H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(20),[G0H12(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G1H12(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G1H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G1H12(11)])
call HGT_lower_alpha_w2_OLR(G1H4(1),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngZu,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(11),n2h2(21))
  call Hloop_QA_Z(ntryL,G2H6(4),ex2(:),G2H3(69),ngZu,m3h2x3(:,49),heltab2x6(:,:,77))
call HGT_lower_alpha_w2_OLR(G1H4(2),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(2),ex1(:),G1H2(8),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(8),29,0,G2H2(1),n2h2(22))
  call Hloop_QA_W(ntryL,G2H6(8),ex2(:),G2H3(68),m3h2x3(:,50),heltab2x6(:,:,78))
call HGT_lower_alpha_w2_OLR(G1H4(3),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(3),ex2(:),G1H2(1),ngZu,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),30,0,G2H2(2),n2h2(23))
  call Hloop_AQ_Z(ntryL,G2H6(13),ex1(:),G2H3(67),ngZu,m3h2x3(:,51),heltab2x6(:,:,79))
call HGT_lower_alpha_w2_OLR(G1H4(4),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(4),ex2(:),G1H2(8),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(8),30,0,G2H2(12),n2h2(24))
  call Hloop_AQ_W(ntryL,G2H6(17),ex1(:),G2H3(27),m3h2x3(:,52),heltab2x6(:,:,80))
call HGT_lower_alpha_OLR(G1H6(17),1,1,6)
call HGT_lower_alpha_invQ_OLR(G1H6(17),2,5,6)
  call Hloop_AZ_Q(ntryL,G1H6(17),ex4(:),G1H2(1),ngZd,m3h3x2(:,17),heltab2x6(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),30,0,G2H2(13),n2h2(25))
  call Hloop_AQ_W(ntryL,G2H2(5),ex1(:),G2H1(1),m3h2x1(:,15),heltab2x2(:,:,17))
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(47),mass4set(:,1),  & 
G1H6(3),G1H6(4),G1H6(18),G1H6(17),G1H6(37),6)
  call HG1shiftOLR(G1H6(4),2,6)
  call Hloop_QA_W(ntryL,G2H2(9),ex2(:),G2H1(2),m3h2x1(:,16),heltab2x2(:,:,18))
  call Hloop_VT_S(ntryL,G1H3(107),19,ex3(:),4,G2H3(25),m3h1x3(:,19),heltab2x3(:,:,87))
  call Hotf_4pt_reduction(G2H3(70),RedSet_4(2),mass4set(:,2),  & 
G1H3(15),G1H3(23),G1H3(16),G1H3(6),G1H3(7),3)
  call HG1shiftOLR(G1H3(23),8,3)
  call Hloop_UW_V(ntryL,G1H3(110),19,ex4(:),8,G2H1(3),m3h3x1(:,69),heltab2x3(:,:,88))
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(7),mass4set(:,2),  & 
G1H3(22),G1H3(13),G1H3(14),G1H3(54),G1H3(50),3)
  call HG1shiftOLR(G1H3(13),4,3)
  call Hloop_VT_S(ntryL,G1H3(103),19,ex3(:),4,G2H3(9),m3h1x3(:,20),heltab2x3(:,:,89))
  call Hloop_UV_W(ntryL,G1H3(106),19,ex4(:),8,G2H1(4),m3h3x1(:,70),heltab2x3(:,:,90))
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(7),mass4set(:,2),  & 
G1H3(49),G1H3(38),G1H3(37),G1H3(10),G1H3(44),3)
  call HG1shiftOLR(G1H3(38),4,3)
  call Hloop_QA_Z(ntryL,G2H6(11),ex2(:),G2H3(10),ngZu,m3h2x3(:,53),heltab2x6(:,:,82))
  call Hloop_QA_W(ntryL,G2H6(1),ex2(:),G2H3(11),m3h2x3(:,54),heltab2x6(:,:,83))
  call Hloop_AQ_Z(ntryL,G2H6(2),ex1(:),G2H3(1),ngZu,m3h2x3(:,55),heltab2x6(:,:,84))
  call Hloop_AQ_W(ntryL,G2H6(3),ex1(:),G2H3(2),m3h2x3(:,56),heltab2x6(:,:,85))
  call Hloop_AQ_W(ntryL,G2H2(3),ex1(:),G2H1(5),m3h2x1(:,17),heltab2x2(:,:,19))
  call Hloop_QA_W(ntryL,G2H2(4),ex2(:),G2H1(6),m3h2x1(:,18),heltab2x2(:,:,20))
  call Hloop_AQ_W(ntryL,G1H2(6),ex1(:),G1H1(27),m3h2x1(:,19),heltab2x2(:,:,21))
  call Hloop_QA_W(ntryL,G1H2(7),ex2(:),G1H1(28),m3h2x1(:,20),heltab2x2(:,:,22))
  call Hloop_QA_Z(ntryL,G1H6(12),ex2(:),G1H3(42),ngZu,m3h2x3(:,57),heltab2x6(:,:,86))
  call Hloop_QA_W(ntryL,G1H6(14),ex2(:),G1H3(58),m3h2x3(:,58),heltab2x6(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H6(15),ex1(:),G1H3(48),ngZu,m3h2x3(:,59),heltab2x6(:,:,88))
  call Hloop_AQ_W(ntryL,G1H6(16),ex1(:),G1H3(43),m3h2x3(:,60),heltab2x6(:,:,89))
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(7),mass4set(:,3),  & 
G1H3(78),G1H3(66),G1H3(64),G1H3(82),G1H3(70),G0H3(18),3)
  call HG1shiftOLR(G1H3(66),4,3)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(7),mass4set(:,3),  & 
G1H3(65),G1H3(20),G1H3(77),G1H3(76),G1H3(72),G0H3(17),3)
  call HG1shiftOLR(G1H3(20),4,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(7),mass4set(:,4),  & 
G1H3(71),G1H3(83),G1H3(36),G1H3(3),G1H3(19),G0H3(12),3)
  call HG1shiftOLR(G1H3(83),4,3)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(7),mass4set(:,4),  & 
G1H3(32),G1H3(85),G1H3(12),G1H3(8),G1H3(86),G0H3(10),3)
  call HG1shiftOLR(G1H3(85),4,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(7),mass4set(:,5),  & 
G1H3(27),G1H3(11),G1H3(95),G1H3(91),G1H3(89),G0H3(11),3)
  call HG1shiftOLR(G1H3(11),4,3)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(7),mass4set(:,5),  & 
G1H3(96),G1H3(92),G1H3(90),G1H3(101),G1H3(100),G0H3(9),3)
  call HG1shiftOLR(G1H3(92),4,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(7),mass4set(:,2),  & 
G1H3(99),G1H3(94),G1H3(93),G1H3(107),G1H3(110),3)
  call HG1shiftOLR(G1H3(94),4,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(7),mass4set(:,2),  & 
G1H3(103),G1H3(106),G1H3(111),G1H3(112),G1H3(113),3)
  call HG1shiftOLR(G1H3(106),4,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(7),mass4set(:,2),  & 
G1H3(114),G1H3(115),G1H3(116),G1H3(117),G1H3(118),3)
  call HG1shiftOLR(G1H3(115),4,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(7),mass4set(:,2),  & 
G1H3(119),G1H3(120),G1H3(121),G1H3(122),G1H3(123),3)
  call HG1shiftOLR(G1H3(120),4,3)
  call Hloop_VV_S(ntryL,G1H3(26),ex4(:),G1H1(32),m3h3x1(:,71),heltab2x3(:,:,91))
  call Hloop_TV_S(ntryL,G1H3(59),19,ex4(:),8,G2H1(7),m3h3x1(:,72),heltab2x3(:,:,92))
  call Hloop_SV_T(ntryL,G1H3(60),19,ex4(:),8,G2H1(9),m3h3x1(:,73),heltab2x3(:,:,93))
  call Hloop_SV_V(ntryL,G2H3(34),ex4(:),G2H1(10),m3h3x1(:,74),heltab2x3(:,:,94))
  call Hloop_VV_S(ntryL,G2H3(38),ex4(:),G2H1(12),m3h3x1(:,75),heltab2x3(:,:,95))
  call Hloop_UV_W(ntryL,G1H3(2),19,ex4(:),8,G2H1(13),m3h3x1(:,76),heltab2x3(:,:,96))
  call Hloop_UW_V(ntryL,G1H3(17),19,ex4(:),8,G2H1(15),m3h3x1(:,77),heltab2x3(:,:,97))
  call Hloop_SV_V(ntryL,G1H3(21),ex4(:),G1H1(3),m3h3x1(:,78),heltab2x3(:,:,98))
  call Hotf_4pt_reduction(G2H3(45),RedSet_4(2),mass4set(:,3),  & 
G1H3(26),G1H3(59),G1H3(60),G1H3(2),G1H3(17),G0H3(3),3)
  call HG1shiftOLR(G1H3(59),8,3)
  call Hotf_4pt_reduction(G2H3(46),RedSet_4(2),mass4set(:,3),  & 
G1H3(21),G1H3(124),G1H3(125),G1H3(126),G1H3(127),G0H3(1),3)
  call HG1shiftOLR(G1H3(124),8,3)
  call Hotf_4pt_reduction(G2H3(47),RedSet_4(2),mass4set(:,4),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G0H3(4),3)
  call HG1shiftOLR(G1H3(129),8,3)
  call Hotf_4pt_reduction(G2H3(48),RedSet_4(2),mass4set(:,4),  & 
G1H3(133),G1H3(134),G1H3(135),G1H3(136),G1H3(137),G0H3(2),3)
  call HG1shiftOLR(G1H3(134),8,3)
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(2),mass4set(:,5),  & 
G1H3(138),G1H3(139),G1H3(140),G1H3(141),G1H3(142),G0H3(8),3)
  call HG1shiftOLR(G1H3(139),8,3)
  call Hotf_4pt_reduction(G2H3(50),RedSet_4(2),mass4set(:,5),  & 
G1H3(143),G1H3(144),G1H3(145),G1H3(146),G1H3(147),G0H3(7),3)
  call HG1shiftOLR(G1H3(144),8,3)
  call Hloop_SS_S(ntryL,G2H3(53),ex3(:),G2H3(3),m3h1x3(:,21),heltab2x3(:,:,99))
  call Hloop_SS_S(ntryL,G2H3(54),ex3(:),G2H3(13),m3h1x3(:,22),heltab2x3(:,:,100))
  call Hloop_SS_S(ntryL,G2H3(57),ex3(:),G2H3(15),m3h1x3(:,23),heltab2x3(:,:,101))
  call Hloop_SS_S(ntryL,G2H3(58),ex3(:),G2H3(19),m3h1x3(:,24),heltab2x3(:,:,102))
  call Hloop_VS_V(ntryL,G2H3(61),ex3(:),G2H3(21),m3h1x3(:,25),heltab2x3(:,:,103))
  call Hloop_VS_V(ntryL,G2H3(62),ex3(:),G2H3(33),m3h1x3(:,26),heltab2x3(:,:,104))
  call Hloop_SS_S(ntryL,G1H3(84),ex3(:),G1H3(148),m3h1x3(:,27),heltab2x3(:,:,105))
  call Hloop_VT_S(ntryL,G1H3(87),19,ex3(:),4,G2H3(32),m3h1x3(:,28),heltab2x3(:,:,106))
  call Hloop_VT_S(ntryL,G1H3(88),19,ex3(:),4,G2H3(31),m3h1x3(:,29),heltab2x3(:,:,107))
  call Hotf_4pt_reduction(G2H3(66),RedSet_4(2),mass4set(:,2),  & 
G1H3(84),G1H3(87),G1H3(88),G1H3(149),G1H3(150),3)
  call HG1shiftOLR(G1H3(87),8,3)
  call Hloop_ST_V(ntryL,G1H3(97),19,ex3(:),4,G2H3(37),m3h1x3(:,30),heltab2x3(:,:,108))
  call Hloop_ST_V(ntryL,G1H3(98),19,ex3(:),4,G2H3(36),m3h1x3(:,31),heltab2x3(:,:,109))
  call Hloop_VS_V(ntryL,G1H3(102),ex3(:),G1H3(97),m3h1x3(:,32),heltab2x3(:,:,110))
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(19),mass4set(:,3),  & 
G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),G0H12(59),12)
  call HG1shiftOLR(G1H12(15),8,12)
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(19),mass4set(:,3),  & 
G1H12(20),G1H12(21),G1H12(22),G1H12(3),G1H12(2),G0H12(85),12)
  call HG1shiftOLR(G1H12(21),8,12)
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(19),mass4set(:,4),  & 
G1H12(27),G1H12(28),G1H12(29),G1H12(30),G1H12(31),G0H12(87),12)
  call HG1shiftOLR(G1H12(28),8,12)
  call Hotf_4pt_reduction(G2H12(4),RedSet_4(19),mass4set(:,4),  & 
G1H12(32),G1H12(34),G1H12(36),G1H12(37),G1H12(38),G0H12(89),12)
  call HG1shiftOLR(G1H12(34),8,12)
  call Hotf_4pt_reduction(G2H12(5),RedSet_4(19),mass4set(:,5),  & 
G1H12(39),G1H12(40),G1H12(41),G1H12(42),G1H12(43),G0H12(91),12)
  call HG1shiftOLR(G1H12(40),8,12)
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(19),mass4set(:,5),  & 
G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(48),G0H12(8),12)
  call HG1shiftOLR(G1H12(45),8,12)
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(19),mass4set(:,3),  & 
G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(54),G0H12(9),12)
  call HG1shiftOLR(G1H12(50),8,12)
  call Hotf_4pt_reduction(G2H12(8),RedSet_4(19),mass4set(:,3),  & 
G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),G0H12(10),12)
  call HG1shiftOLR(G1H12(57),8,12)
  call Hotf_4pt_reduction(G2H12(9),RedSet_4(19),mass4set(:,4),  & 
G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),G0H12(11),12)
  call HG1shiftOLR(G1H12(62),8,12)
  call Hotf_4pt_reduction(G2H12(10),RedSet_4(19),mass4set(:,4),  & 
G1H12(66),G1H12(67),G1H12(68),G1H12(69),G1H12(70),G0H12(1),12)
  call HG1shiftOLR(G1H12(67),8,12)
  call Hotf_4pt_reduction(G2H12(11),RedSet_4(19),mass4set(:,5),  & 
G1H12(71),G1H12(72),G1H12(75),G1H12(76),G1H12(79),G0H12(2),12)
  call HG1shiftOLR(G1H12(72),8,12)
  call Hotf_4pt_reduction(G2H12(12),RedSet_4(19),mass4set(:,5),  & 
G1H12(80),G1H12(81),G1H12(82),G1H12(83),G1H12(84),G0H12(3),12)
  call HG1shiftOLR(G1H12(81),8,12)
  call Hloop_TV_S(ntryL,G1H12(157),20,wf4(:,1),3,G2H3(35),m3h4x3(:,145),heltab2x12(:,:,333))
  call Hloop_SV_T(ntryL,G1H12(159),20,wf4(:,1),3,G2H3(39),m3h4x3(:,146),heltab2x12(:,:,334))
  call Hloop_TV_S(ntryL,G1H12(169),20,wf4(:,2),3,G2H3(40),m3h4x3(:,147),heltab2x12(:,:,335))
  call Hloop_SV_T(ntryL,G1H12(174),20,wf4(:,2),3,G2H3(41),m3h4x3(:,148),heltab2x12(:,:,336))
  call Hloop_CV_D(ntryL,G1H12(93),20,wf4(:,1),3,G2H3(42),m3h4x3(:,149),heltab2x12(:,:,337))
  call Hloop_DV_C(ntryL,G1H12(95),20,wf4(:,1),G2H3(43),m3h4x3(:,150),heltab2x12(:,:,338))
  call Hloop_CV_D(ntryL,G1H12(97),20,wf4(:,2),3,G2H3(44),m3h4x3(:,151),heltab2x12(:,:,339))
  call Hloop_DV_C(ntryL,G1H12(99),20,wf4(:,2),G2H3(51),m3h4x3(:,152),heltab2x12(:,:,340))
  call Hloop_UV_W(ntryL,G1H12(181),20,wf4(:,1),3,G2H3(52),m3h4x3(:,153),heltab2x12(:,:,341))
  call Hloop_UW_V(ntryL,G1H12(182),20,wf4(:,1),3,G2H3(55),m3h4x3(:,154),heltab2x12(:,:,342))
  call Hloop_UV_W(ntryL,G1H12(4),20,wf4(:,2),3,G2H3(56),m3h4x3(:,155),heltab2x12(:,:,343))
  call Hloop_UW_V(ntryL,G1H12(5),20,wf4(:,2),3,G2H3(59),m3h4x3(:,156),heltab2x12(:,:,344))
  call Hloop_SV_V(ntryL,G1H12(188),wf4(:,1),G1H3(98),m3h4x3(:,157),heltab2x12(:,:,345))
  call Hloop_SV_V(ntryL,G1H12(189),wf4(:,2),G1H3(102),m3h4x3(:,158),heltab2x12(:,:,346))
  call Hotf_4pt_reduction(G2H12(21),RedSet_4(19),mass4set(:,2),  & 
G1H12(85),G1H12(86),G1H12(87),G1H12(88),G1H12(89),12)
  call HG1shiftOLR(G1H12(86),8,12)
  call Hotf_4pt_reduction(G2H12(22),RedSet_4(19),mass4set(:,2),  & 
G1H12(90),G1H12(91),G1H12(92),G1H12(94),G1H12(96),12)
  call HG1shiftOLR(G1H12(91),8,12)
  call Hotf_4pt_reduction(G2H12(23),RedSet_4(19),mass4set(:,2),  & 
G1H12(98),G1H12(100),G1H12(101),G1H12(102),G1H12(103),12)
  call HG1shiftOLR(G1H12(100),8,12)
  call Hotf_4pt_reduction(G2H12(24),RedSet_4(19),mass4set(:,2),  & 
G1H12(104),G1H12(105),G1H12(106),G1H12(107),G1H12(108),12)
  call HG1shiftOLR(G1H12(105),8,12)
  call Hloop_VV_S(ntryL,G2H12(13),wf4(:,1),G2H3(60),m3h4x3(:,159),heltab2x12(:,:,347))
  call Hloop_VV_S(ntryL,G2H12(14),wf4(:,1),G2H3(65),m3h4x3(:,160),heltab2x12(:,:,348))
  call Hloop_VV_S(ntryL,G2H12(15),wf4(:,2),G2H3(64),m3h4x3(:,161),heltab2x12(:,:,349))
  call Hloop_VV_S(ntryL,G2H12(16),wf4(:,2),G2H3(63),m3h4x3(:,162),heltab2x12(:,:,350))
  call Hloop_SV_V(ntryL,G2H12(25),wf4(:,1),G2H3(70),m3h4x3(:,163),heltab2x12(:,:,351))
  call Hloop_SV_V(ntryL,G2H12(26),wf4(:,1),G2H3(30),m3h4x3(:,164),heltab2x12(:,:,352))
  call Hloop_SV_V(ntryL,G2H12(27),wf4(:,2),G2H3(28),m3h4x3(:,165),heltab2x12(:,:,353))
  call Hloop_SV_V(ntryL,G2H12(28),wf4(:,2),G2H3(4),m3h4x3(:,166),heltab2x12(:,:,354))
  call Hotf_4pt_reduction(G2H12(17),RedSet_4(19),mass4set(:,2),  & 
G1H12(109),G1H12(7),G1H12(110),G1H12(13),G1H12(111),12)
  call HG1shiftOLR(G1H12(7),8,12)
  call Hotf_4pt_reduction(G2H12(18),RedSet_4(19),mass4set(:,2),  & 
G1H12(19),G1H12(112),G1H12(1),G1H12(113),G1H12(23),12)
  call HG1shiftOLR(G1H12(112),8,12)
  call Hotf_4pt_reduction(G2H12(19),RedSet_4(19),mass4set(:,2),  & 
G1H12(114),G1H12(24),G1H12(115),G1H12(25),G1H12(116),12)
  call HG1shiftOLR(G1H12(24),8,12)
  call Hotf_4pt_reduction(G2H12(20),RedSet_4(19),mass4set(:,2),  & 
G1H12(26),G1H12(117),G1H12(33),G1H12(118),G1H12(35),12)
  call HG1shiftOLR(G1H12(117),8,12)
  call Hloop_VV_S(ntryL,G1H12(6),wf4(:,1),G1H3(151),m3h4x3(:,167),heltab2x12(:,:,355))
  call Hloop_VV_S(ntryL,G1H12(8),wf4(:,2),G1H3(152),m3h4x3(:,168),heltab2x12(:,:,356))
  call Hloop_VS_V(ntryL,G1H6(1),ex3(:),G1H6(12),m3h1x6(:,13),heltab2x6(:,:,90))
  call Hloop_VS_V(ntryL,G1H6(2),ex3(:),G1H6(14),m3h1x6(:,14),heltab2x6(:,:,91))
  call Hloop_WA_Q(ntryL,G1H12(10),ex2(:),G1H6(15),m3h2x6(:,97),heltab2x12(:,:,357))
  call Hloop_A_Q(ntryL,G1H6(15),22,0,G2H6(16),n2h6(81))
  call Hloop_AQ_W(ntryL,G1H6(8),wf6(:,2),G1H1(4),m3h6x1(:,1),heltab2x6(:,:,92))
  call Hloop_AQ_W(ntryL,G2H6(5),wf6(:,2),G2H1(16),m3h6x1(:,2),heltab2x6(:,:,93))
  call Hloop_VS_V(ntryL,G1H6(10),ex3(:),G1H6(16),m3h1x6(:,15),heltab2x6(:,:,94))
  call Hloop_VS_V(ntryL,G1H6(5),ex3(:),G1H6(1),m3h1x6(:,16),heltab2x6(:,:,95))
  call Hloop_WQ_A(ntryL,G1H12(12),ex1(:),G1H6(2),m3h2x6(:,98),heltab2x12(:,:,358))
  call Hloop_Q_A(ntryL,G1H6(2),21,0,G2H6(18),n2h6(82))
  call Hloop_QA_W(ntryL,G1H6(6),wf6(:,4),G1H1(20),m3h6x1(:,3),heltab2x6(:,:,96))
  call Hloop_QA_W(ntryL,G2H6(6),wf6(:,4),G2H1(18),m3h6x1(:,4),heltab2x6(:,:,97))
  call Hloop_QA_Z(ntryL,G1H6(11),ex2(:),G1H3(153),ngZu,m3h2x3(:,61),heltab2x6(:,:,98))
  call Hloop_QA_W(ntryL,G1H6(25),ex2(:),G1H3(154),m3h2x3(:,62),heltab2x6(:,:,99))
  call Hloop_VA_Q(ntryL,G1H6(13),ex2(:),G1H3(155),m3h2x3(:,63),heltab2x6(:,:,100))
  call Hloop_A_Q(ntryL,G1H3(155),19,0,G2H3(5),n2h3(33))
  call Hloop_ZA_Q(ntryL,G1H6(9),ex2(:),G1H3(155),ngZu,m3h2x3(:,64),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(155),19,0,G2H3(6),n2h3(34))
  call Hloop_WA_Q(ntryL,G1H6(7),ex2(:),G1H3(155),m3h2x3(:,65),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G1H3(155),19,0,G2H3(7),n2h3(35))
  call Hloop_QA_Z(ntryL,G1H6(26),ex2(:),G1H3(155),ngZu,m3h2x3(:,66),heltab2x6(:,:,103))
  call Hloop_QA_W(ntryL,G1H6(27),ex2(:),G1H3(156),m3h2x3(:,67),heltab2x6(:,:,104))
  call Hloop_QA_W(ntryL,G2H6(7),ex2(:),G2H3(8),m3h2x3(:,68),heltab2x6(:,:,105))
  call Hloop_AQ_Z(ntryL,G1H6(28),ex1(:),G1H3(157),ngZu,m3h2x3(:,69),heltab2x6(:,:,106))
  call Hloop_AQ_W(ntryL,G1H6(29),ex1(:),G1H3(158),m3h2x3(:,70),heltab2x6(:,:,107))
  call Hloop_VQ_A(ntryL,G1H6(30),ex1(:),G1H3(159),m3h2x3(:,71),heltab2x6(:,:,108))
  call Hloop_Q_A(ntryL,G1H3(159),19,0,G2H3(12),n2h3(36))
  call Hloop_ZQ_A(ntryL,G1H6(31),ex1(:),G1H3(159),ngZu,m3h2x3(:,72),heltab2x6(:,:,109))
  call Hloop_Q_A(ntryL,G1H3(159),19,0,G2H3(16),n2h3(37))
  call Hloop_WQ_A(ntryL,G1H6(32),ex1(:),G1H3(159),m3h2x3(:,73),heltab2x6(:,:,110))
  call Hloop_Q_A(ntryL,G1H3(159),19,0,G2H3(18),n2h3(38))
  call Hloop_AQ_Z(ntryL,G1H6(33),ex1(:),G1H3(159),ngZu,m3h2x3(:,74),heltab2x6(:,:,111))
  call Hloop_AQ_W(ntryL,G1H6(34),ex1(:),G1H3(160),m3h2x3(:,75),heltab2x6(:,:,112))
  call Hloop_AQ_W(ntryL,G2H6(9),ex1(:),G2H3(22),m3h2x3(:,76),heltab2x6(:,:,113))
  call Hloop_UW_V(ntryL,G1H6(35),17,wf3(:,2),12,G2H2(5),m3h3x2(:,18),heltab2x6(:,:,114))
  call Hotf_4pt_reduction(G2H6(10),RedSet_4(42),mass4set(:,1),  & 
G1H6(15),G1H6(8),G1H6(10),G1H6(5),G1H6(2),6)
  call HG1shiftOLR(G1H6(8),2,6)
  call Hloop_ZA_Q(ntryL,G0H6(5),ex2(:),G0H3(6),ngZu,m3h2x3(:,77),heltab2x6(:,:,115))
  call Hloop_A_Q(ntryL,G0H3(6),23,0,G1H3(161),n2h3(39))
  call Hloop_WA_Q(ntryL,G0H6(1),ex2(:),G0H3(5),m3h2x3(:,78),heltab2x6(:,:,116))
  call Hloop_A_Q(ntryL,G0H3(5),23,0,G1H3(162),n2h3(40))
  call Hloop_VS_V(ntryL,G1H3(104),ex3(:),G1H3(163),m3h1x3(:,33),heltab2x3(:,:,111))
  call Hloop_VV_S(ntryL,G1H3(105),ex4(:),G1H1(21),m3h3x1(:,79),heltab2x3(:,:,112))
  call Hloop_ZQ_A(ntryL,G0H6(2),ex1(:),G0H3(15),ngZu,m3h2x3(:,79),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G0H3(15),23,0,G1H3(104),n2h3(41))
  call Hloop_WQ_A(ntryL,G0H6(3),ex1(:),G0H3(13),m3h2x3(:,80),heltab2x6(:,:,118))
  call Hloop_Q_A(ntryL,G0H3(13),23,0,G1H3(105),n2h3(42))
  call Hloop_VS_V(ntryL,G1H3(108),ex3(:),G1H3(164),m3h1x3(:,34),heltab2x3(:,:,113))
  call Hloop_VV_S(ntryL,G1H3(109),ex4(:),G1H1(22),m3h3x1(:,80),heltab2x3(:,:,114))
  call Hloop_VQ_A(ntryL,G1H6(36),ex1(:),G1H3(108),m3h2x3(:,81),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(108),23,0,G2H3(24),n2h3(43))
  call Hloop_ZQ_A(ntryL,G1H6(19),ex1(:),G1H3(109),ngZu,m3h2x3(:,82),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(109),23,0,G2H3(34),n2h3(44))
  call Hloop_WQ_A(ntryL,G1H6(20),ex1(:),G1H3(108),m3h2x3(:,83),heltab2x6(:,:,121))
  call Hloop_Q_A(ntryL,G1H3(108),23,0,G2H3(38),n2h3(45))
  call Hloop_AQ_W(ntryL,G2H6(12),ex1(:),G2H3(45),m3h2x3(:,84),heltab2x6(:,:,122))
  call Hloop_VA_Q(ntryL,G1H6(22),ex2(:),G1H3(109),m3h2x3(:,85),heltab2x6(:,:,123))
  call Hloop_A_Q(ntryL,G1H3(109),23,0,G2H3(46),n2h3(46))
  call Hloop_ZA_Q(ntryL,G1H6(23),ex2(:),G1H3(108),ngZu,m3h2x3(:,86),heltab2x6(:,:,124))
  call Hloop_A_Q(ntryL,G1H3(108),23,0,G2H3(47),n2h3(47))
  call Hloop_WA_Q(ntryL,G1H6(24),ex2(:),G1H3(109),m3h2x3(:,87),heltab2x6(:,:,125))
  call Hloop_A_Q(ntryL,G1H3(109),23,0,G2H3(48),n2h3(48))
  call Hloop_QA_W(ntryL,G2H6(14),ex2(:),G2H3(49),m3h2x3(:,88),heltab2x6(:,:,126))
  call Hloop_UW_V(ntryL,G1H6(21),21,ex4(:),8,G2H2(9),m3h3x2(:,19),heltab2x6(:,:,127))
  call Hloop_AQ_Z(ntryL,G2H2(6),ex1(:),G2H1(19),ngZu,m3h2x1(:,21),heltab2x2(:,:,23))
  call Hloop_AQ_W(ntryL,G2H2(7),ex1(:),G2H1(20),m3h2x1(:,22),heltab2x2(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H2(2),ex1(:),G1H1(26),ngZu,m3h2x1(:,23),heltab2x2(:,:,25))
  call Hloop_QA_Z(ntryL,G2H2(8),ex2(:),G2H1(21),ngZu,m3h2x1(:,24),heltab2x2(:,:,26))
  call Hloop_QA_W(ntryL,G2H2(10),ex2(:),G2H1(22),m3h2x1(:,25),heltab2x2(:,:,27))
  call Hloop_QA_Z(ntryL,G1H2(12),ex2(:),G1H1(1),ngZu,m3h2x1(:,26),heltab2x2(:,:,28))
  call Hloop_QZ_A(ntryL,G1H6(3),ex4(:),G1H2(8),ngZd,m3h3x2(:,20),heltab2x6(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(8),29,0,G2H2(3),n2h2(26))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(4),ex2(:),G1H3(108),m3h2x3(:,89),heltab2x6(:,:,129))
  call Hloop_QZ_A(ntryL,G1H6(17),ex4(:),G1H2(1),ngZd,m3h3x2(:,21),heltab2x6(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(4),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H6(37),ex4(:),G1H2(6),ngZd,m3h3x2(:,22),heltab2x6(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(6),n2h2(28))
  call Hloop_VT_S(ntryL,G1H3(15),19,ex3(:),4,G2H3(50),m3h1x3(:,35),heltab2x3(:,:,115))
call HGT_raise_alpha_OLR(G1H3(23),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(23),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(23),ex4(:),G1H1(2),m3h3x1(:,81),heltab2x3(:,:,116))
  call Hloop_VT_S(ntryL,G1H3(6),19,ex3(:),4,G2H3(53),m3h1x3(:,36),heltab2x3(:,:,117))
  call Hloop_VT_S(ntryL,G1H3(7),19,ex3(:),4,G2H3(54),m3h1x3(:,37),heltab2x3(:,:,118))
  call Hloop_UW_V(ntryL,G1H3(22),19,ex4(:),8,G2H1(23),m3h3x1(:,82),heltab2x3(:,:,119))
call HGT_raise_alpha_OLR(G1H3(13),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(13),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(13),ex3(:),G1H3(109),m3h1x3(:,38),heltab2x3(:,:,120))
  call Hloop_UW_V(ntryL,G1H3(54),19,ex4(:),8,G2H1(24),m3h3x1(:,83),heltab2x3(:,:,121))
  call Hloop_UW_V(ntryL,G1H3(50),19,ex4(:),8,G2H1(25),m3h3x1(:,84),heltab2x3(:,:,122))
  call Hloop_UV_W(ntryL,G1H3(49),19,ex4(:),8,G2H1(26),m3h3x1(:,85),heltab2x3(:,:,123))
call HGT_raise_alpha_OLR(G1H3(38),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(38),2,5,3)
  call Hloop_VS_V(ntryL,G1H3(38),ex3(:),G1H3(15),m3h1x3(:,39),heltab2x3(:,:,124))
  call Hloop_UV_W(ntryL,G1H3(10),19,ex4(:),8,G2H1(27),m3h3x1(:,86),heltab2x3(:,:,125))
  call Hloop_UV_W(ntryL,G1H3(44),19,ex4(:),8,G2H1(28),m3h3x1(:,87),heltab2x3(:,:,126))
  call Hloop_QZ_A(ntryL,G1H3(78),ex4(:),G1H1(10),ngZl,m3h3x1(:,88),heltab2x3(:,:,127))
  call Hloop_Q_A(ntryL,G1H1(10),27,nML,G2H1(29),n2h1(33))
call HGT_OLR(G1H3(66),1,1,3)
call HGT_invQ_OLR(G1H3(66),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(66),-4,nML,G2H3(57),n2h3(52))
  call Hloop_AS_Q(ntryL,G2H3(57),ex3(:),G2H3(58),ngH,m3h1x3(:,40),heltab2x3(:,:,128))
  call Hloop_QZ_A(ntryL,G1H3(82),ex4(:),G1H1(33),ngZl,m3h3x1(:,89),heltab2x3(:,:,129))
  call Hloop_Q_A(ntryL,G1H1(33),27,nML,G2H1(30),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H3(70),ex4(:),G1H1(34),ngZl,m3h3x1(:,90),heltab2x3(:,:,130))
  call Hloop_Q_A(ntryL,G1H1(34),27,nML,G2H1(31),n2h1(35))
  call Hloop_QZ_A(ntryL,G0H3(18),ex4(:),G0H1(1),ngZl,m3h3x1(:,91),heltab2x3(:,:,131))
  call Hloop_Q_A(ntryL,G0H1(1),27,nML,G1H1(38),n2h1(36))
  call Hloop_AZ_Q(ntryL,G1H3(65),ex4(:),G1H1(11),ngZl,m3h3x1(:,92),heltab2x3(:,:,132))
  call Hloop_A_Q(ntryL,G1H1(11),27,nML,G2H1(32),n2h1(37))
call HGT_OLR(G1H3(20),1,1,3)
call HGT_invQ_OLR(G1H3(20),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(20),-4,nML,G2H3(61),n2h3(53))
  call Hloop_QS_A(ntryL,G2H3(61),ex3(:),G2H3(62),ngH,m3h1x3(:,41),heltab2x3(:,:,133))
  call Hloop_AZ_Q(ntryL,G1H3(76),ex4(:),G1H1(12),ngZl,m3h3x1(:,93),heltab2x3(:,:,134))
  call Hloop_A_Q(ntryL,G1H1(12),27,nML,G2H1(33),n2h1(38))
  call Hloop_AZ_Q(ntryL,G1H3(72),ex4(:),G1H1(16),ngZl,m3h3x1(:,94),heltab2x3(:,:,135))
  call Hloop_A_Q(ntryL,G1H1(16),27,nML,G2H1(34),n2h1(39))
  call Hloop_AZ_Q(ntryL,G0H3(17),ex4(:),G0H1(1),ngZl,m3h3x1(:,95),heltab2x3(:,:,136))
  call Hloop_A_Q(ntryL,G0H1(1),27,nML,G1H1(10),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(71),ex4(:),G1H1(33),ngZu,m3h3x1(:,96),heltab2x3(:,:,137))
  call Hloop_Q_A(ntryL,G1H1(33),27,nMT,G2H1(35),n2h1(41))
call HGT_OLR(G1H3(83),1,1,3)
call HGT_invQ_OLR(G1H3(83),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(83),-4,nMT,G2H3(66),n2h3(54))
  call Hloop_AS_Q(ntryL,G2H3(66),ex3(:),G2H3(57),ngH,m3h1x3(:,42),heltab2x3(:,:,138))
  call Hloop_QZ_A(ntryL,G1H3(3),ex4(:),G1H1(34),ngZu,m3h3x1(:,97),heltab2x3(:,:,139))
  call Hloop_Q_A(ntryL,G1H1(34),27,nMT,G2H1(36),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H3(19),ex4(:),G1H1(11),ngZu,m3h3x1(:,98),heltab2x3(:,:,140))
  call Hloop_Q_A(ntryL,G1H1(11),27,nMT,G2H1(37),n2h1(43))
  call Hloop_QZ_A(ntryL,G0H3(12),ex4(:),G0H1(1),ngZu,m3h3x1(:,99),heltab2x3(:,:,141))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMT,G1H1(12),n2h1(44))
  call Hloop_AZ_Q(ntryL,G1H3(32),ex4(:),G1H1(16),ngZu,m3h3x1(:,100),heltab2x3(:,:,142))
  call Hloop_A_Q(ntryL,G1H1(16),27,nMT,G2H1(38),n2h1(45))
call HGT_OLR(G1H3(85),1,1,3)
call HGT_invQ_OLR(G1H3(85),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(85),-4,nMT,G2H3(61),n2h3(55))
  call Hloop_QS_A(ntryL,G2H3(61),ex3(:),G2H3(66),ngH,m3h1x3(:,43),heltab2x3(:,:,143))
  call Hloop_AZ_Q(ntryL,G1H3(8),ex4(:),G1H1(33),ngZu,m3h3x1(:,101),heltab2x3(:,:,144))
  call Hloop_A_Q(ntryL,G1H1(33),27,nMT,G2H1(39),n2h1(46))
  call Hloop_AZ_Q(ntryL,G1H3(86),ex4(:),G1H1(34),ngZu,m3h3x1(:,102),heltab2x3(:,:,145))
  call Hloop_A_Q(ntryL,G1H1(34),27,nMT,G2H1(40),n2h1(47))
  call Hloop_AZ_Q(ntryL,G0H3(10),ex4(:),G0H1(1),ngZu,m3h3x1(:,103),heltab2x3(:,:,146))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMT,G1H1(11),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H3(27),ex4(:),G1H1(16),ngZd,m3h3x1(:,104),heltab2x3(:,:,147))
  call Hloop_Q_A(ntryL,G1H1(16),27,nMB,G2H1(41),n2h1(49))
call HGT_OLR(G1H3(11),1,1,3)
call HGT_invQ_OLR(G1H3(11),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(11),-4,nMB,G2H3(61),n2h3(56))
  call Hloop_AS_Q(ntryL,G2H3(61),ex3(:),G2H3(71),ngH,m3h1x3(:,44),heltab2x3(:,:,148))
  call Hloop_QZ_A(ntryL,G1H3(91),ex4(:),G1H1(33),ngZd,m3h3x1(:,105),heltab2x3(:,:,149))
  call Hloop_Q_A(ntryL,G1H1(33),27,nMB,G2H1(42),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H3(89),ex4(:),G1H1(34),ngZd,m3h3x1(:,106),heltab2x3(:,:,150))
  call Hloop_Q_A(ntryL,G1H1(34),27,nMB,G2H1(43),n2h1(51))
  call Hloop_QZ_A(ntryL,G0H3(11),ex4(:),G0H1(1),ngZd,m3h3x1(:,107),heltab2x3(:,:,151))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(16),n2h1(52))
  call Hloop_AZ_Q(ntryL,G1H3(96),ex4(:),G1H1(33),ngZd,m3h3x1(:,108),heltab2x3(:,:,152))
  call Hloop_A_Q(ntryL,G1H1(33),27,nMB,G2H1(44),n2h1(53))
call HGT_OLR(G1H3(92),1,1,3)
call HGT_invQ_OLR(G1H3(92),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(92),-4,nMB,G2H3(61),n2h3(57))
  call Hloop_QS_A(ntryL,G2H3(61),ex3(:),G2H3(72),ngH,m3h1x3(:,45),heltab2x3(:,:,153))
  call Hloop_AZ_Q(ntryL,G1H3(101),ex4(:),G1H1(34),ngZd,m3h3x1(:,109),heltab2x3(:,:,154))
  call Hloop_A_Q(ntryL,G1H1(34),27,nMB,G2H1(45),n2h1(54))
  call Hloop_AZ_Q(ntryL,G1H3(100),ex4(:),G1H1(33),ngZd,m3h3x1(:,110),heltab2x3(:,:,155))
  call Hloop_A_Q(ntryL,G1H1(33),27,nMB,G2H1(46),n2h1(55))
  call Hloop_AZ_Q(ntryL,G0H3(9),ex4(:),G0H1(1),ngZd,m3h3x1(:,111),heltab2x3(:,:,156))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(34),n2h1(56))
  call Hloop_TV_S(ntryL,G1H3(99),19,ex4(:),8,G2H1(47),m3h3x1(:,112),heltab2x3(:,:,157))
call HGT_OLR(G1H3(94),1,1,3)
call HGT_invQ_OLR(G1H3(94),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(94),ex3(:),G1H3(23),m3h1x3(:,46),heltab2x3(:,:,158))
  call Hloop_TV_S(ntryL,G1H3(107),19,ex4(:),8,G2H1(48),m3h3x1(:,113),heltab2x3(:,:,159))
  call Hloop_TV_S(ntryL,G1H3(110),19,ex4(:),8,G2H1(49),m3h3x1(:,114),heltab2x3(:,:,160))
  call Hloop_SV_T(ntryL,G1H3(103),19,ex4(:),8,G2H1(50),m3h3x1(:,115),heltab2x3(:,:,161))
call HGT_OLR(G1H3(106),1,1,3)
call HGT_invQ_OLR(G1H3(106),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(106),ex3(:),G1H3(6),m3h1x3(:,47),heltab2x3(:,:,162))
  call Hloop_SV_T(ntryL,G1H3(112),19,ex4(:),8,G2H1(51),m3h3x1(:,116),heltab2x3(:,:,163))
  call Hloop_SV_T(ntryL,G1H3(113),19,ex4(:),8,G2H1(52),m3h3x1(:,117),heltab2x3(:,:,164))
  call Hloop_CV_D(ntryL,G1H3(114),19,ex4(:),8,G2H1(53),m3h3x1(:,118),heltab2x3(:,:,165))
call HGT_OLR(G1H3(115),1,1,3)
call HGT_invQ_OLR(G1H3(115),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(115),ex3(:),G1H3(7),m3h1x3(:,48),heltab2x3(:,:,166))
  call Hloop_CV_D(ntryL,G1H3(117),19,ex4(:),8,G2H1(54),m3h3x1(:,119),heltab2x3(:,:,167))
  call Hloop_CV_D(ntryL,G1H3(118),19,ex4(:),8,G2H1(55),m3h3x1(:,120),heltab2x3(:,:,168))
  call Hloop_DV_C(ntryL,G1H3(119),19,ex4(:),G2H1(56),m3h3x1(:,121),heltab2x3(:,:,169))
call HGT_OLR(G1H3(120),1,1,3)
call HGT_invQ_OLR(G1H3(120),2,5,3)
  call Hloop_SS_S(ntryL,G1H3(120),ex3(:),G1H3(22),m3h1x3(:,49),heltab2x3(:,:,170))
  call Hloop_DV_C(ntryL,G1H3(122),19,ex4(:),G2H1(57),m3h3x1(:,122),heltab2x3(:,:,171))
  call Hloop_DV_C(ntryL,G1H3(123),19,ex4(:),G2H1(58),m3h3x1(:,123),heltab2x3(:,:,172))
  call Hloop_AS_Q(ntryL,G1H3(26),ex3(:),G1H3(13),ngH,m3h1x3(:,50),heltab2x3(:,:,173))
  call Hloop_A_Q(ntryL,G1H3(13),23,nML,G2H3(61),n2h3(62))
call HGT_OLR(G1H3(59),1,1,3)
call HGT_invQ_OLR(G1H3(59),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(59),-8,nML,G2H3(73),n2h3(63))
  call Hloop_QZ_A(ntryL,G2H3(73),ex4(:),G2H1(59),ngZl,m3h3x1(:,124),heltab2x3(:,:,174))
  call Hloop_AS_Q(ntryL,G1H3(2),ex3(:),G1H3(54),ngH,m3h1x3(:,51),heltab2x3(:,:,175))
  call Hloop_A_Q(ntryL,G1H3(54),23,nML,G2H3(73),n2h3(64))
  call Hloop_AS_Q(ntryL,G1H3(17),ex3(:),G1H3(50),ngH,m3h1x3(:,52),heltab2x3(:,:,176))
  call Hloop_A_Q(ntryL,G1H3(50),23,nML,G2H3(74),n2h3(65))
  call Hloop_AS_Q(ntryL,G0H3(3),ex3(:),G0H3(16),ngH,m3h1x3(:,53),heltab2x3(:,:,177))
  call Hloop_A_Q(ntryL,G0H3(16),23,nML,G1H3(49),n2h3(66))
  call Hloop_QS_A(ntryL,G1H3(21),ex3(:),G1H3(38),ngH,m3h1x3(:,54),heltab2x3(:,:,178))
  call Hloop_Q_A(ntryL,G1H3(38),23,nML,G2H3(75),n2h3(67))
call HGT_OLR(G1H3(124),1,1,3)
call HGT_invQ_OLR(G1H3(124),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(124),-8,nML,G2H3(76),n2h3(68))
  call Hloop_AZ_Q(ntryL,G2H3(76),ex4(:),G2H1(60),ngZl,m3h3x1(:,125),heltab2x3(:,:,179))
  call Hloop_QS_A(ntryL,G1H3(126),ex3(:),G1H3(10),ngH,m3h1x3(:,55),heltab2x3(:,:,180))
  call Hloop_Q_A(ntryL,G1H3(10),23,nML,G2H3(76),n2h3(69))
  call Hloop_QS_A(ntryL,G1H3(127),ex3(:),G1H3(44),ngH,m3h1x3(:,56),heltab2x3(:,:,181))
  call Hloop_Q_A(ntryL,G1H3(44),23,nML,G2H3(77),n2h3(70))
  call Hloop_QS_A(ntryL,G0H3(1),ex3(:),G0H3(14),ngH,m3h1x3(:,57),heltab2x3(:,:,182))
  call Hloop_Q_A(ntryL,G0H3(14),23,nML,G1H3(78),n2h3(71))
  call Hloop_AS_Q(ntryL,G1H3(128),ex3(:),G1H3(66),ngH,m3h1x3(:,58),heltab2x3(:,:,183))
  call Hloop_A_Q(ntryL,G1H3(66),23,nMT,G2H3(78),n2h3(72))
call HGT_OLR(G1H3(129),1,1,3)
call HGT_invQ_OLR(G1H3(129),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(129),-8,nMT,G2H3(79),n2h3(73))
  call Hloop_QZ_A(ntryL,G2H3(79),ex4(:),G2H1(61),ngZu,m3h3x1(:,126),heltab2x3(:,:,184))
  call Hloop_AS_Q(ntryL,G1H3(131),ex3(:),G1H3(82),ngH,m3h1x3(:,59),heltab2x3(:,:,185))
  call Hloop_A_Q(ntryL,G1H3(82),23,nMT,G2H3(79),n2h3(74))
  call Hloop_AS_Q(ntryL,G1H3(132),ex3(:),G1H3(70),ngH,m3h1x3(:,60),heltab2x3(:,:,186))
  call Hloop_A_Q(ntryL,G1H3(70),23,nMT,G2H3(80),n2h3(75))
  call Hloop_AS_Q(ntryL,G0H3(4),ex3(:),G0H3(23),ngH,m3h1x3(:,61),heltab2x3(:,:,187))
  call Hloop_A_Q(ntryL,G0H3(23),23,nMT,G1H3(65),n2h3(76))
  call Hloop_QS_A(ntryL,G1H3(133),ex3(:),G1H3(20),ngH,m3h1x3(:,62),heltab2x3(:,:,188))
  call Hloop_Q_A(ntryL,G1H3(20),23,nMT,G2H3(81),n2h3(77))
call HGT_OLR(G1H3(134),1,1,3)
call HGT_invQ_OLR(G1H3(134),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(134),-8,nMT,G2H3(82),n2h3(78))
  call Hloop_AZ_Q(ntryL,G2H3(82),ex4(:),G2H1(62),ngZu,m3h3x1(:,127),heltab2x3(:,:,189))
  call Hloop_QS_A(ntryL,G1H3(136),ex3(:),G1H3(76),ngH,m3h1x3(:,63),heltab2x3(:,:,190))
  call Hloop_Q_A(ntryL,G1H3(76),23,nMT,G2H3(82),n2h3(79))
  call Hloop_QS_A(ntryL,G1H3(137),ex3(:),G1H3(72),ngH,m3h1x3(:,64),heltab2x3(:,:,191))
  call Hloop_Q_A(ntryL,G1H3(72),23,nMT,G2H3(83),n2h3(80))
  call Hloop_QS_A(ntryL,G0H3(2),ex3(:),G0H3(21),ngH,m3h1x3(:,65),heltab2x3(:,:,192))
  call Hloop_Q_A(ntryL,G0H3(21),23,nMT,G1H3(71),n2h3(81))
  call Hloop_AS_Q(ntryL,G1H3(138),ex3(:),G1H3(83),ngH,m3h1x3(:,66),heltab2x3(:,:,193))
  call Hloop_A_Q(ntryL,G1H3(83),23,nMB,G2H3(84),n2h3(82))
call HGT_OLR(G1H3(139),1,1,3)
call HGT_invQ_OLR(G1H3(139),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(139),-8,nMB,G2H3(85),n2h3(83))
  call Hloop_QZ_A(ntryL,G2H3(85),ex4(:),G2H1(63),ngZd,m3h3x1(:,128),heltab2x3(:,:,194))
  call Hloop_AS_Q(ntryL,G1H3(141),ex3(:),G1H3(3),ngH,m3h1x3(:,67),heltab2x3(:,:,195))
  call Hloop_A_Q(ntryL,G1H3(3),23,nMB,G2H3(85),n2h3(84))
  call Hloop_AS_Q(ntryL,G1H3(142),ex3(:),G1H3(19),ngH,m3h1x3(:,68),heltab2x3(:,:,196))
  call Hloop_A_Q(ntryL,G1H3(19),23,nMB,G2H3(86),n2h3(85))
  call Hloop_AS_Q(ntryL,G0H3(8),ex3(:),G0H3(24),ngH,m3h1x3(:,69),heltab2x3(:,:,197))
  call Hloop_A_Q(ntryL,G0H3(24),23,nMB,G1H3(32),n2h3(86))
  call Hloop_QS_A(ntryL,G1H3(143),ex3(:),G1H3(85),ngH,m3h1x3(:,70),heltab2x3(:,:,198))
  call Hloop_Q_A(ntryL,G1H3(85),23,nMB,G2H3(87),n2h3(87))
call HGT_OLR(G1H3(144),1,1,3)
call HGT_invQ_OLR(G1H3(144),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(144),-8,nMB,G2H3(88),n2h3(88))
  call Hloop_AZ_Q(ntryL,G2H3(88),ex4(:),G2H1(64),ngZd,m3h3x1(:,129),heltab2x3(:,:,199))
  call Hloop_QS_A(ntryL,G1H3(146),ex3(:),G1H3(8),ngH,m3h1x3(:,71),heltab2x3(:,:,200))
  call Hloop_Q_A(ntryL,G1H3(8),23,nMB,G2H3(88),n2h3(89))
  call Hloop_QS_A(ntryL,G1H3(147),ex3(:),G1H3(86),ngH,m3h1x3(:,72),heltab2x3(:,:,201))
  call Hloop_Q_A(ntryL,G1H3(86),23,nMB,G2H3(89),n2h3(90))
  call Hloop_QS_A(ntryL,G0H3(7),ex3(:),G0H3(22),ngH,m3h1x3(:,73),heltab2x3(:,:,202))
  call Hloop_Q_A(ntryL,G0H3(22),23,nMB,G1H3(27),n2h3(91))
  call Hloop_ST_V(ntryL,G1H3(84),19,ex3(:),4,G2H3(90),m3h1x3(:,74),heltab2x3(:,:,203))
call HGT_OLR(G1H3(87),1,1,3)
call HGT_invQ_OLR(G1H3(87),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(87),ex4(:),G1H1(33),m3h3x1(:,130),heltab2x3(:,:,204))
  call Hloop_ST_V(ntryL,G1H3(149),19,ex3(:),4,G2H3(91),m3h1x3(:,75),heltab2x3(:,:,205))
  call Hloop_ST_V(ntryL,G1H3(150),19,ex3(:),4,G2H3(92),m3h1x3(:,76),heltab2x3(:,:,206))
  call Hloop_QV_A(ntryL,G1H12(14),wf4(:,1),G1H3(11),m3h4x3(:,169),heltab2x12(:,:,359))
  call Hloop_Q_A(ntryL,G1H3(11),23,nML,G2H3(93),n2h3(93))
call HGT_OLR(G1H12(15),1,1,12)
call HGT_invQ_OLR(G1H12(15),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(15),-8,nML,G2H12(1),n2h12(83))
  call Hloop_AZ_Q(ntryL,G2H12(1),ex4(:),G2H4(1),ngZl,m3h3x4(:,5),heltab2x12(:,:,360))
  call Hloop_QV_A(ntryL,G1H12(17),wf4(:,1),G1H3(91),m3h4x3(:,170),heltab2x12(:,:,361))
  call Hloop_Q_A(ntryL,G1H3(91),23,nML,G2H3(94),n2h3(94))
  call Hloop_QV_A(ntryL,G1H12(18),wf4(:,1),G1H3(89),m3h4x3(:,171),heltab2x12(:,:,362))
  call Hloop_Q_A(ntryL,G1H3(89),23,nML,G2H3(95),n2h3(95))
  call Hloop_QV_A(ntryL,G0H12(59),wf4(:,1),G0H3(20),m3h4x3(:,172),heltab2x12(:,:,363))
  call Hloop_Q_A(ntryL,G0H3(20),23,nML,G1H3(96),n2h3(96))
  call Hloop_AV_Q(ntryL,G1H12(20),wf4(:,1),G1H3(92),m3h4x3(:,173),heltab2x12(:,:,364))
  call Hloop_A_Q(ntryL,G1H3(92),23,nML,G2H3(96),n2h3(97))
call HGT_OLR(G1H12(21),1,1,12)
call HGT_invQ_OLR(G1H12(21),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(21),-8,nML,G2H12(2),n2h12(84))
  call Hloop_QZ_A(ntryL,G2H12(2),ex4(:),G2H4(2),ngZl,m3h3x4(:,6),heltab2x12(:,:,365))
  call Hloop_AV_Q(ntryL,G1H12(3),wf4(:,1),G1H3(101),m3h4x3(:,174),heltab2x12(:,:,366))
  call Hloop_A_Q(ntryL,G1H3(101),23,nML,G2H3(97),n2h3(98))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,1),G1H3(100),m3h4x3(:,175),heltab2x12(:,:,367))
  call Hloop_A_Q(ntryL,G1H3(100),23,nML,G2H3(98),n2h3(99))
  call Hloop_AV_Q(ntryL,G0H12(85),wf4(:,1),G0H3(19),m3h4x3(:,176),heltab2x12(:,:,368))
  call Hloop_A_Q(ntryL,G0H3(19),23,nML,G1H3(99),n2h3(100))
  call Hloop_QV_A(ntryL,G1H12(27),wf4(:,1),G1H3(94),m3h4x3(:,177),heltab2x12(:,:,369))
  call Hloop_Q_A(ntryL,G1H3(94),23,nMT,G2H3(99),n2h3(101))
call HGT_OLR(G1H12(28),1,1,12)
call HGT_invQ_OLR(G1H12(28),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(28),-8,nMT,G2H12(3),n2h12(85))
  call Hloop_AZ_Q(ntryL,G2H12(3),ex4(:),G2H4(3),ngZu,m3h3x4(:,7),heltab2x12(:,:,370))
  call Hloop_QV_A(ntryL,G1H12(30),wf4(:,1),G1H3(107),m3h4x3(:,178),heltab2x12(:,:,371))
  call Hloop_Q_A(ntryL,G1H3(107),23,nMT,G2H3(100),n2h3(102))
  call Hloop_QV_A(ntryL,G1H12(31),wf4(:,1),G1H3(110),m3h4x3(:,179),heltab2x12(:,:,372))
  call Hloop_Q_A(ntryL,G1H3(110),23,nMT,G2H3(101),n2h3(103))
  call Hloop_QV_A(ntryL,G0H12(87),wf4(:,1),G0H3(6),m3h4x3(:,180),heltab2x12(:,:,373))
  call Hloop_Q_A(ntryL,G0H3(6),23,nMT,G1H3(103),n2h3(104))
  call Hloop_AV_Q(ntryL,G1H12(32),wf4(:,1),G1H3(106),m3h4x3(:,181),heltab2x12(:,:,374))
  call Hloop_A_Q(ntryL,G1H3(106),23,nMT,G2H3(102),n2h3(105))
call HGT_OLR(G1H12(34),1,1,12)
call HGT_invQ_OLR(G1H12(34),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(34),-8,nMT,G2H12(4),n2h12(86))
  call Hloop_QZ_A(ntryL,G2H12(4),ex4(:),G2H4(4),ngZu,m3h3x4(:,8),heltab2x12(:,:,375))
  call Hloop_AV_Q(ntryL,G1H12(37),wf4(:,1),G1H3(112),m3h4x3(:,182),heltab2x12(:,:,376))
  call Hloop_A_Q(ntryL,G1H3(112),23,nMT,G2H3(103),n2h3(106))
  call Hloop_AV_Q(ntryL,G1H12(38),wf4(:,1),G1H3(113),m3h4x3(:,183),heltab2x12(:,:,377))
  call Hloop_A_Q(ntryL,G1H3(113),23,nMT,G2H3(104),n2h3(107))
  call Hloop_AV_Q(ntryL,G0H12(89),wf4(:,1),G0H3(5),m3h4x3(:,184),heltab2x12(:,:,378))
  call Hloop_A_Q(ntryL,G0H3(5),23,nMT,G1H3(114),n2h3(108))
  call Hloop_QV_A(ntryL,G1H12(39),wf4(:,1),G1H3(115),m3h4x3(:,185),heltab2x12(:,:,379))
  call Hloop_Q_A(ntryL,G1H3(115),23,nMB,G2H3(105),n2h3(109))
call HGT_OLR(G1H12(40),1,1,12)
call HGT_invQ_OLR(G1H12(40),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(40),-8,nMB,G2H12(5),n2h12(87))
  call Hloop_AZ_Q(ntryL,G2H12(5),ex4(:),G2H4(5),ngZd,m3h3x4(:,9),heltab2x12(:,:,380))
  call Hloop_QV_A(ntryL,G1H12(42),wf4(:,1),G1H3(117),m3h4x3(:,186),heltab2x12(:,:,381))
  call Hloop_Q_A(ntryL,G1H3(117),23,nMB,G2H3(106),n2h3(110))
  call Hloop_QV_A(ntryL,G1H12(43),wf4(:,1),G1H3(118),m3h4x3(:,187),heltab2x12(:,:,382))
  call Hloop_Q_A(ntryL,G1H3(118),23,nMB,G2H3(107),n2h3(111))
  call Hloop_QV_A(ntryL,G0H12(91),wf4(:,1),G0H3(15),m3h4x3(:,188),heltab2x12(:,:,383))
  call Hloop_Q_A(ntryL,G0H3(15),23,nMB,G1H3(119),n2h3(112))
  call Hloop_AV_Q(ntryL,G1H12(44),wf4(:,1),G1H3(120),m3h4x3(:,189),heltab2x12(:,:,384))
  call Hloop_A_Q(ntryL,G1H3(120),23,nMB,G2H3(108),n2h3(113))
call HGT_OLR(G1H12(45),1,1,12)
call HGT_invQ_OLR(G1H12(45),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(45),-8,nMB,G2H12(6),n2h12(88))
  call Hloop_QZ_A(ntryL,G2H12(6),ex4(:),G2H4(6),ngZd,m3h3x4(:,10),heltab2x12(:,:,385))
  call Hloop_AV_Q(ntryL,G1H12(47),wf4(:,1),G1H3(122),m3h4x3(:,190),heltab2x12(:,:,386))
  call Hloop_A_Q(ntryL,G1H3(122),23,nMB,G2H3(109),n2h3(114))
  call Hloop_AV_Q(ntryL,G1H12(48),wf4(:,1),G1H3(123),m3h4x3(:,191),heltab2x12(:,:,387))
  call Hloop_A_Q(ntryL,G1H3(123),23,nMB,G2H3(110),n2h3(115))
  call Hloop_AV_Q(ntryL,G0H12(8),wf4(:,1),G0H3(13),m3h4x3(:,192),heltab2x12(:,:,388))
  call Hloop_A_Q(ntryL,G0H3(13),23,nMB,G1H3(26),n2h3(116))
  call Hloop_QZ_A(ntryL,G1H12(49),wf4(:,2),G1H3(13),ngZl,m3h4x3(:,193),heltab2x12(:,:,389))
  call Hloop_Q_A(ntryL,G1H3(13),23,nML,G2H3(111),n2h3(117))
call HGT_OLR(G1H12(50),1,1,12)
call HGT_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(50),-8,nML,G2H12(7),n2h12(89))
  call Hloop_AZ_Q(ntryL,G2H12(7),ex4(:),G2H4(7),ngZl,m3h3x4(:,11),heltab2x12(:,:,390))
  call Hloop_QZ_A(ntryL,G1H12(52),wf4(:,2),G1H3(59),ngZl,m3h4x3(:,194),heltab2x12(:,:,391))
  call Hloop_Q_A(ntryL,G1H3(59),23,nML,G2H3(112),n2h3(118))
  call Hloop_QZ_A(ntryL,G1H12(54),wf4(:,2),G1H3(2),ngZl,m3h4x3(:,195),heltab2x12(:,:,392))
  call Hloop_Q_A(ntryL,G1H3(2),23,nML,G2H3(113),n2h3(119))
  call Hloop_QZ_A(ntryL,G0H12(9),wf4(:,2),G0H3(18),ngZl,m3h4x3(:,196),heltab2x12(:,:,393))
  call Hloop_Q_A(ntryL,G0H3(18),23,nML,G1H3(54),n2h3(120))
  call Hloop_AZ_Q(ntryL,G1H12(56),wf4(:,2),G1H3(17),ngZl,m3h4x3(:,197),heltab2x12(:,:,394))
  call Hloop_A_Q(ntryL,G1H3(17),23,nML,G2H3(114),n2h3(121))
call HGT_OLR(G1H12(57),1,1,12)
call HGT_invQ_OLR(G1H12(57),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(57),-8,nML,G2H12(8),n2h12(90))
  call Hloop_QZ_A(ntryL,G2H12(8),ex4(:),G2H4(8),ngZl,m3h3x4(:,12),heltab2x12(:,:,395))
  call Hloop_AZ_Q(ntryL,G1H12(59),wf4(:,2),G1H3(50),ngZl,m3h4x3(:,198),heltab2x12(:,:,396))
  call Hloop_A_Q(ntryL,G1H3(50),23,nML,G2H3(115),n2h3(122))
  call Hloop_AZ_Q(ntryL,G1H12(60),wf4(:,2),G1H3(21),ngZl,m3h4x3(:,199),heltab2x12(:,:,397))
  call Hloop_A_Q(ntryL,G1H3(21),23,nML,G2H3(116),n2h3(123))
  call Hloop_AZ_Q(ntryL,G0H12(10),wf4(:,2),G0H3(17),ngZl,m3h4x3(:,200),heltab2x12(:,:,398))
  call Hloop_A_Q(ntryL,G0H3(17),23,nML,G1H3(38),n2h3(124))
  call Hloop_QZ_A(ntryL,G1H12(61),wf4(:,2),G1H3(124),ngZu,m3h4x3(:,201),heltab2x12(:,:,399))
  call Hloop_Q_A(ntryL,G1H3(124),23,nMT,G2H3(117),n2h3(125))
call HGT_OLR(G1H12(62),1,1,12)
call HGT_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(62),-8,nMT,G2H12(9),n2h12(91))
  call Hloop_AZ_Q(ntryL,G2H12(9),ex4(:),G2H4(9),ngZu,m3h3x4(:,13),heltab2x12(:,:,400))
  call Hloop_QZ_A(ntryL,G1H12(64),wf4(:,2),G1H3(126),ngZu,m3h4x3(:,202),heltab2x12(:,:,401))
  call Hloop_Q_A(ntryL,G1H3(126),23,nMT,G2H3(118),n2h3(126))
  call Hloop_QZ_A(ntryL,G1H12(65),wf4(:,2),G1H3(10),ngZu,m3h4x3(:,203),heltab2x12(:,:,402))
  call Hloop_Q_A(ntryL,G1H3(10),23,nMT,G2H3(119),n2h3(127))
  call Hloop_QZ_A(ntryL,G0H12(11),wf4(:,2),G0H3(12),ngZu,m3h4x3(:,204),heltab2x12(:,:,403))
  call Hloop_Q_A(ntryL,G0H3(12),23,nMT,G1H3(127),n2h3(128))
  call Hloop_AZ_Q(ntryL,G1H12(66),wf4(:,2),G1H3(44),ngZu,m3h4x3(:,205),heltab2x12(:,:,404))
  call Hloop_A_Q(ntryL,G1H3(44),23,nMT,G2H3(120),n2h3(129))
call HGT_OLR(G1H12(67),1,1,12)
call HGT_invQ_OLR(G1H12(67),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(67),-8,nMT,G2H12(10),n2h12(92))
  call Hloop_QZ_A(ntryL,G2H12(10),ex4(:),G2H4(10),ngZu,m3h3x4(:,14),heltab2x12(:,:,405))
  call Hloop_AZ_Q(ntryL,G1H12(69),wf4(:,2),G1H3(128),ngZu,m3h4x3(:,206),heltab2x12(:,:,406))
  call Hloop_A_Q(ntryL,G1H3(128),23,nMT,G2H3(121),n2h3(130))
  call Hloop_AZ_Q(ntryL,G1H12(70),wf4(:,2),G1H3(66),ngZu,m3h4x3(:,207),heltab2x12(:,:,407))
  call Hloop_A_Q(ntryL,G1H3(66),23,nMT,G2H3(122),n2h3(131))
  call Hloop_AZ_Q(ntryL,G0H12(1),wf4(:,2),G0H3(10),ngZu,m3h4x3(:,208),heltab2x12(:,:,408))
  call Hloop_A_Q(ntryL,G0H3(10),23,nMT,G1H3(129),n2h3(132))
  call Hloop_QZ_A(ntryL,G1H12(71),wf4(:,2),G1H3(131),ngZd,m3h4x3(:,209),heltab2x12(:,:,409))
  call Hloop_Q_A(ntryL,G1H3(131),23,nMB,G2H3(123),n2h3(133))
call HGT_OLR(G1H12(72),1,1,12)
call HGT_invQ_OLR(G1H12(72),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(72),-8,nMB,G2H12(11),n2h12(93))
  call Hloop_AZ_Q(ntryL,G2H12(11),ex4(:),G2H4(11),ngZd,m3h3x4(:,15),heltab2x12(:,:,410))
  call Hloop_QZ_A(ntryL,G1H12(76),wf4(:,2),G1H3(82),ngZd,m3h4x3(:,210),heltab2x12(:,:,411))
  call Hloop_Q_A(ntryL,G1H3(82),23,nMB,G2H3(124),n2h3(134))
  call Hloop_QZ_A(ntryL,G1H12(79),wf4(:,2),G1H3(132),ngZd,m3h4x3(:,211),heltab2x12(:,:,412))
  call Hloop_Q_A(ntryL,G1H3(132),23,nMB,G2H3(125),n2h3(135))
  call Hloop_QZ_A(ntryL,G0H12(2),wf4(:,2),G0H3(11),ngZd,m3h4x3(:,212),heltab2x12(:,:,413))
  call Hloop_Q_A(ntryL,G0H3(11),23,nMB,G1H3(70),n2h3(136))
  call Hloop_AZ_Q(ntryL,G1H12(80),wf4(:,2),G1H3(133),ngZd,m3h4x3(:,213),heltab2x12(:,:,414))
  call Hloop_A_Q(ntryL,G1H3(133),23,nMB,G2H3(126),n2h3(137))
call HGT_OLR(G1H12(81),1,1,12)
call HGT_invQ_OLR(G1H12(81),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(81),-8,nMB,G2H12(12),n2h12(94))
  call Hloop_QZ_A(ntryL,G2H12(12),ex4(:),G2H4(12),ngZd,m3h3x4(:,16),heltab2x12(:,:,415))
  call Hloop_AZ_Q(ntryL,G1H12(83),wf4(:,2),G1H3(20),ngZd,m3h4x3(:,214),heltab2x12(:,:,416))
  call Hloop_A_Q(ntryL,G1H3(20),23,nMB,G2H3(127),n2h3(138))
  call Hloop_AZ_Q(ntryL,G1H12(84),wf4(:,2),G1H3(134),ngZd,m3h4x3(:,215),heltab2x12(:,:,417))
  call Hloop_A_Q(ntryL,G1H3(134),23,nMB,G2H3(128),n2h3(139))
  call Hloop_AZ_Q(ntryL,G0H12(3),wf4(:,2),G0H3(9),ngZd,m3h4x3(:,216),heltab2x12(:,:,418))
  call Hloop_A_Q(ntryL,G0H3(9),23,nMB,G1H3(136),n2h3(140))
  call Hloop_TV_S(ntryL,G1H12(85),20,wf4(:,1),3,G2H3(129),m3h4x3(:,217),heltab2x12(:,:,419))
call HGT_raise_alpha_OLR(G1H12(86),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(86),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(86),ex4(:),G1H4(5),m3h3x4(:,17),heltab2x12(:,:,420))
  call Hloop_TV_S(ntryL,G1H12(88),20,wf4(:,1),3,G2H3(130),m3h4x3(:,218),heltab2x12(:,:,421))
  call Hloop_TV_S(ntryL,G1H12(89),20,wf4(:,1),3,G2H3(131),m3h4x3(:,219),heltab2x12(:,:,422))
  call Hloop_SV_T(ntryL,G1H12(90),20,wf4(:,1),3,G2H3(132),m3h4x3(:,220),heltab2x12(:,:,423))
call HGT_raise_alpha_OLR(G1H12(91),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(91),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(91),ex4(:),G1H4(6),m3h3x4(:,18),heltab2x12(:,:,424))
  call Hloop_SV_T(ntryL,G1H12(94),20,wf4(:,1),3,G2H3(133),m3h4x3(:,221),heltab2x12(:,:,425))
  call Hloop_SV_T(ntryL,G1H12(96),20,wf4(:,1),3,G2H3(134),m3h4x3(:,222),heltab2x12(:,:,426))
  call Hloop_TV_S(ntryL,G1H12(98),20,wf4(:,2),3,G2H3(135),m3h4x3(:,223),heltab2x12(:,:,427))
call HGT_raise_alpha_OLR(G1H12(100),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(100),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(100),ex4(:),G1H4(7),m3h3x4(:,19),heltab2x12(:,:,428))
  call Hloop_TV_S(ntryL,G1H12(102),20,wf4(:,2),3,G2H3(136),m3h4x3(:,224),heltab2x12(:,:,429))
  call Hloop_TV_S(ntryL,G1H12(103),20,wf4(:,2),3,G2H3(137),m3h4x3(:,225),heltab2x12(:,:,430))
  call Hloop_SV_T(ntryL,G1H12(104),20,wf4(:,2),3,G2H3(138),m3h4x3(:,226),heltab2x12(:,:,431))
call HGT_raise_alpha_OLR(G1H12(105),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(105),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(105),ex4(:),G1H4(8),m3h3x4(:,20),heltab2x12(:,:,432))
  call Hloop_SV_T(ntryL,G1H12(107),20,wf4(:,2),3,G2H3(139),m3h4x3(:,227),heltab2x12(:,:,433))
  call Hloop_SV_T(ntryL,G1H12(108),20,wf4(:,2),3,G2H3(140),m3h4x3(:,228),heltab2x12(:,:,434))
  call Hloop_UV_W(ntryL,G1H12(109),20,wf4(:,1),3,G2H3(141),m3h4x3(:,229),heltab2x12(:,:,435))
call HGT_OLR(G1H12(7),1,1,12)
call HGT_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(7),ex4(:),G1H4(1),m3h3x4(:,21),heltab2x12(:,:,436))
  call Hloop_UV_W(ntryL,G1H12(13),20,wf4(:,1),3,G2H3(142),m3h4x3(:,230),heltab2x12(:,:,437))
  call Hloop_UV_W(ntryL,G1H12(111),20,wf4(:,1),3,G2H3(143),m3h4x3(:,231),heltab2x12(:,:,438))
  call Hloop_UW_V(ntryL,G1H12(19),20,wf4(:,1),3,G2H3(144),m3h4x3(:,232),heltab2x12(:,:,439))
call HGT_OLR(G1H12(112),1,1,12)
call HGT_invQ_OLR(G1H12(112),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(112),ex4(:),G1H4(2),m3h3x4(:,22),heltab2x12(:,:,440))
  call Hloop_UW_V(ntryL,G1H12(113),20,wf4(:,1),3,G2H3(145),m3h4x3(:,233),heltab2x12(:,:,441))
  call Hloop_UW_V(ntryL,G1H12(23),20,wf4(:,1),3,G2H3(146),m3h4x3(:,234),heltab2x12(:,:,442))
  call Hloop_UV_W(ntryL,G1H12(114),20,wf4(:,2),3,G2H3(147),m3h4x3(:,235),heltab2x12(:,:,443))
call HGT_OLR(G1H12(24),1,1,12)
call HGT_invQ_OLR(G1H12(24),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(24),ex4(:),G1H4(3),m3h3x4(:,23),heltab2x12(:,:,444))
  call Hloop_UV_W(ntryL,G1H12(25),20,wf4(:,2),3,G2H3(148),m3h4x3(:,236),heltab2x12(:,:,445))
  call Hloop_UV_W(ntryL,G1H12(116),20,wf4(:,2),3,G2H3(149),m3h4x3(:,237),heltab2x12(:,:,446))
  call Hloop_UW_V(ntryL,G1H12(26),20,wf4(:,2),3,G2H3(150),m3h4x3(:,238),heltab2x12(:,:,447))
call HGT_OLR(G1H12(117),1,1,12)
call HGT_invQ_OLR(G1H12(117),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(117),ex4(:),G1H4(4),m3h3x4(:,24),heltab2x12(:,:,448))
  call Hloop_UW_V(ntryL,G1H12(118),20,wf4(:,2),3,G2H3(151),m3h4x3(:,239),heltab2x12(:,:,449))
  call Hloop_UW_V(ntryL,G1H12(35),20,wf4(:,2),3,G2H3(152),m3h4x3(:,240),heltab2x12(:,:,450))
  call Hloop_QZ_A(ntryL,G1H6(15),wf3(:,2),G1H2(7),ngZd,m3h3x2(:,23),heltab2x6(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(7),n2h2(29))
call HGT_raise_alpha_OLR(G1H6(8),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(8),ex2(:),G1H3(76),m3h2x3(:,90),heltab2x6(:,:,133))
  call Hloop_QZ_A(ntryL,G1H6(5),wf3(:,2),G1H2(2),ngZd,m3h3x2(:,24),heltab2x6(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(8),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H6(2),wf3(:,2),G1H2(12),ngZd,m3h3x2(:,25),heltab2x6(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(12),29,0,G2H2(10),n2h2(31))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G2H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(150),[G2H3(147),G2H3(144),G2H3(141),G2H3(23),G2H3(17) &
    ,G1H3(102),G1H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G2H1(14),G2H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(18),[G2H1(17),G2H1(11)])
call HGT_w2_OLR(G1H1(5),1,1,1)
call HGT_w2_invQ_OLR(G1H1(5),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(20),[G1H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G1H3(39)])
call HGT_lower_alpha_OLR(G1H3(29),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(29),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G1H3(29)])
call HGT_w2_OLR(G1H1(6),1,1,1)
call HGT_w2_invQ_OLR(G1H1(6),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(22),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G1H3(18)])
call HGT_lower_alpha_OLR(G1H3(1),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(70),G2H3(56),G2H3(52),G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G2H3(3),G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(164),[G1H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(37),[G2H3(21),G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G2H3(30),G2H3(59),G2H3(55),G1H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(22),[G1H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G2H1(9),G2H1(7),G1H1(18),G1H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(15),[G2H1(13),G2H1(10),G1H1(24),G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(4),[G1H1(31),G1H1(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(31),[G2H3(13),G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(163),[G1H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(36),[G2H3(33),G1H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(21),[G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(20),[G1H1(37),G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(104),[G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(105),[G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(161),[G1H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(162),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(11),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(50),[G2H1(47),G1H1(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(26),[G2H1(23),G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G1H3(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(90),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(64),[G2H3(60),G2H3(40),G2H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G2H3(65),G2H3(41),G2H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G2H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(51),[G2H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(138),[G2H3(135),G2H3(132),G2H3(129),G1H3(152) &
    ,G1H3(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(28),[G2H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(52),[G2H1(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(111),[G2H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(113),[G2H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(54),[G1H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(114),[G2H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(116),[G2H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(38),[G1H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(117),[G2H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(119),[G2H3(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(127),[G1H3(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(120),[G2H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(122),[G2H3(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(129),[G1H3(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(123),[G2H3(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(125),[G2H3(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(70),[G1H3(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(126),[G2H3(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(128),[G2H3(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(136),[G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(140),[G2H3(137),G2H3(134),G2H3(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(152),[G2H3(149),G2H3(146),G2H3(143)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(20),ex4(:),G2tensor(27),m3h3x1(:,131),heltab2x3(:,:,207))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(150),ex4(:),G2tensor(13),m3h3x1(:,132),heltab2x3(:,:,208))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(36),m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(15),m3h1x1(:,32),heltab2x1(:,:,32))
  call Hotf_4pt_reduction(G2H1(20),RedSet_4(48),mass4set(:,6),  & 
G1H1(5),G1H1(6),G1H1(7),G1H1(18),G1H1(8),1)
  call HG1shiftOLR(G1H1(6),4,1)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(26),ex4(:),G2tensor(45),m3h3x1(:,133),heltab2x3(:,:,209))
  call Hotf_4pt_reduction(G2H3(45),RedSet_4(22),mass4set(:,6),  & 
G1H3(137),G1H3(72),G1H3(138),G1H3(83),G1H3(139),3)
  call HG1shiftOLR(G1H3(72),8,3)
  call Hotf_4pt_reduction(G2H1(22),RedSet_4(49),mass4set(:,6),  & 
G1H1(24),G1H1(14),G1H1(31),G1H1(15),G1H1(17),1)
  call HG1shiftOLR(G1H1(14),4,1)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(29),ex4(:),G2tensor(17),m3h3x1(:,134),heltab2x3(:,:,210))
  call Hotf_4pt_reduction(G2H3(49),RedSet_4(17),mass4set(:,6),  & 
G1H3(141),G1H3(3),G1H3(142),G1H3(19),G1H3(143),3)
  call HG1shiftOLR(G1H3(3),8,3)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(4),23,ex4(:),8,G2tensor(51),m3h3x1(:,135),heltab2x3(:,:,211))
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(19),mass4set(:,2),  & 
G1H3(85),G1H3(144),G1H3(146),G1H3(8),G1H3(147),3)
  call HG1shiftOLR(G1H3(144),8,3)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(9),23,ex4(:),8,G2tensor(19),m3h3x1(:,136),heltab2x3(:,:,212))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(46),23,ex4(:),8,G2tensor(3),m3h3x1(:,137),heltab2x3(:,:,213))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(25),23,ex4(:),8,G2tensor(7),m3h3x1(:,138),heltab2x3(:,:,214))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(28),23,ex4(:),8,G2tensor(9),m3h3x1(:,139),heltab2x3(:,:,215))
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(2),mass4set(:,2),  & 
G1H3(86),G1H3(84),G1H3(87),G1H3(149),G1H3(150),3)
  call HG1shiftOLR(G1H3(84),8,3)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(31),23,ex4(:),8,G2tensor(11),m3h3x1(:,140),heltab2x3(:,:,216))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(164),23,ex4(:),8,G2tensor(24),m3h3x1(:,141),heltab2x3(:,:,217))
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(2),mass4set(:,2),  & 
G1H3(11),G1H3(91),G1H3(89),G1H3(92),G1H3(101),3)
  call HG1shiftOLR(G1H3(91),8,3)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(35),23,ex4(:),8,G2tensor(30),m3h3x1(:,142),heltab2x3(:,:,218))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(40),23,ex4(:),8,G2tensor(39),m3h3x1(:,143),heltab2x3(:,:,219))
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(19),mass4set(:,2),  & 
G1H3(100),G1H3(94),G1H3(107),G1H3(110),G1H3(106),3)
  call HG1shiftOLR(G1H3(94),8,3)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(22),27,ex3(:),4,G2tensor(42),m3h1x1(:,33),heltab2x1(:,:,33))
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(7),mass4set(:,2),  & 
G1H1(37),G1H1(25),G1H1(32),G1H1(3),G1H1(22),1)
  call HG1shiftOLR(G1H1(25),4,1)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(9),27,ex3(:),4,G2tensor(48),m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(13),27,ex3(:),4,G2tensor(54),m3h1x1(:,35),heltab2x1(:,:,35))
  call Hotf_4pt_reduction(G2H1(15),RedSet_4(7),mass4set(:,2),  & 
G1H1(9),G1H1(13),G1H1(39),G1H1(40),G1H1(41),1)
  call HG1shiftOLR(G1H1(13),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(4),27,ex3(:),4,G2tensor(1),m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(45),23,ex4(:),8,G2tensor(21),m3h3x1(:,144),heltab2x3(:,:,220))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(47),23,ex4(:),8,G2tensor(5),m3h3x1(:,145),heltab2x3(:,:,221))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(51),23,ex4(:),8,G2tensor(33),m3h3x1(:,146),heltab2x3(:,:,222))
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(2),mass4set(:,2),  & 
G1H3(112),G1H3(113),G1H3(115),G1H3(117),G1H3(118),3)
  call HG1shiftOLR(G1H3(113),8,3)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(53),23,ex4(:),8,G2tensor(63),m3h3x1(:,147),heltab2x3(:,:,223))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(163),23,ex4(:),8,G2tensor(75),m3h3x1(:,148),heltab2x3(:,:,224))
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(2),mass4set(:,2),  & 
G1H3(120),G1H3(122),G1H3(123),G1H3(13),G1H3(59),3)
  call HG1shiftOLR(G1H3(122),8,3)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(57),23,ex4(:),8,G2tensor(57),m3h3x1(:,149),heltab2x3(:,:,225))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(21),27,ex3(:),4,G2tensor(60),m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(19),27,ex3(:),4,G2tensor(66),m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(23),27,ex3(:),4,G2tensor(69),m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(72),m3h1x1(:,40),heltab2x1(:,:,40))
  call Hloop_QZ_A(ntryL,G1H3(104),ex4(:),G1H1(4),ngZu,m3h3x1(:,150),heltab2x3(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,0,G2tensor(78),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H3(62),ex4(:),G1H1(21),ngZu,m3h3x1(:,151),heltab2x3(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,0,G2tensor(81),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H3(63),ex4(:),G1H1(19),ngZu,m3h3x1(:,152),heltab2x3(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,0,G2tensor(82),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H3(105),ex4(:),G1H1(23),ngZd,m3h3x1(:,153),heltab2x3(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),31,0,G2tensor(83),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(68),ex4(:),G1H1(20),ngZd,m3h3x1(:,154),heltab2x3(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,0,G2tensor(84),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H3(69),ex4(:),G1H1(4),ngZd,m3h3x1(:,155),heltab2x3(:,:,231))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,0,G2tensor(85),n2h1(62))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(29),27,ex3(:),4,G2tensor(86),m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(30),27,ex3(:),4,G2tensor(87),m3h1x1(:,42),heltab2x1(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H3(161),ex4(:),G1H1(21),ngZu,m3h3x1(:,156),heltab2x3(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,0,G2tensor(88),n2h1(63))
  call Hloop_AZ_Q(ntryL,G1H3(74),ex4(:),G1H1(19),ngZu,m3h3x1(:,157),heltab2x3(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(89),n2h1(64))
  call Hloop_AZ_Q(ntryL,G1H3(75),ex4(:),G1H1(23),ngZu,m3h3x1(:,158),heltab2x3(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,0,G2tensor(90),n2h1(65))
  call Hloop_AZ_Q(ntryL,G1H3(162),ex4(:),G1H1(20),ngZd,m3h3x1(:,159),heltab2x3(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,0,G2tensor(91),n2h1(66))
  call Hloop_AZ_Q(ntryL,G1H3(80),ex4(:),G1H1(4),ngZd,m3h3x1(:,160),heltab2x3(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,0,G2tensor(92),n2h1(67))
  call Hloop_AZ_Q(ntryL,G1H3(81),ex4(:),G1H1(29),ngZd,m3h3x1(:,161),heltab2x3(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,0,G2tensor(93),n2h1(68))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(30),m3h2x1(:,27),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,0,G2tensor(94),n2h1(69))
  call Hloop_WA_Q(ntryL,G1H2(4),ex2(:),G1H1(21),m3h2x1(:,28),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,0,G2tensor(95),n2h1(70))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(42),mass4set(:,7),  & 
G1H2(8),G1H2(1),G1H2(6),G1H2(7),G1H2(2),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(35),27,ex3(:),4,G2tensor(96),m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(36),27,ex3(:),4,G2tensor(97),m3h1x1(:,44),heltab2x1(:,:,44))
  call Hloop_WA_Q(ntryL,G1H2(9),ex2(:),G1H1(19),m3h2x1(:,29),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(98),n2h1(71))
  call Hloop_WA_Q(ntryL,G1H2(10),ex2(:),G1H1(23),m3h2x1(:,30),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,0,G2tensor(99),n2h1(72))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(100),ngZu,m3h2x1(:,31),heltab2x2(:,:,33))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(69),ex4(:),G2tensor(101),m3h3x1(:,162),heltab2x3(:,:,238))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(102),m3h2x1(:,32),heltab2x2(:,:,34))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(68),ex4(:),G2tensor(103),m3h3x1(:,163),heltab2x3(:,:,239))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(2),ex1(:),G2tensor(104),ngZu,m3h2x1(:,33),heltab2x2(:,:,35))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(67),ex4(:),G2tensor(105),m3h3x1(:,164),heltab2x3(:,:,240))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(12),ex1(:),G2tensor(106),m3h2x1(:,34),heltab2x2(:,:,36))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(27),ex4(:),G2tensor(107),m3h3x1(:,165),heltab2x3(:,:,241))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(13),ex1(:),G2tensor(108),m3h2x1(:,35),heltab2x2(:,:,37))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(1),ex3(:),G2tensor(109),m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(110),m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(25),ex4(:),G2tensor(111),m3h3x1(:,166),heltab2x3(:,:,242))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(3),ex3(:),G2tensor(112),m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(9),ex4(:),G2tensor(113),m3h3x1(:,167),heltab2x3(:,:,243))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(4),ex3(:),G2tensor(114),m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(10),ex4(:),G2tensor(115),m3h3x1(:,168),heltab2x3(:,:,244))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(11),ex4(:),G2tensor(116),m3h3x1(:,169),heltab2x3(:,:,245))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(1),ex4(:),G2tensor(117),m3h3x1(:,170),heltab2x3(:,:,246))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(2),ex4(:),G2tensor(118),m3h3x1(:,171),heltab2x3(:,:,247))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(5),ex3(:),G2tensor(119),m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(6),ex3(:),G2tensor(120),m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(27),ex3(:),G1tensor(1),m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(28),ex3(:),G1tensor(9),m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(42),ex4(:),ex3(:),G1tensor(3),m4h3x1x1(:,1),heltab3x3(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(58),ex4(:),ex3(:),G1tensor(15),m4h3x1x1(:,2),heltab3x3(:,:,2))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(48),ex4(:),ex3(:),G1tensor(21),m4h3x1x1(:,3),heltab3x3(:,:,3))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(43),ex4(:),ex3(:),G1tensor(27),m4h3x1x1(:,4),heltab3x3(:,:,4))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(50),ex3(:),G2tensor(121),m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(26),ex3(:),G2tensor(122),m3h1x1(:,54),heltab2x1(:,:,54))
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(2),mass4set(:,2),  & 
G1H3(2),G1H3(17),G1H3(50),G1H3(21),G1H3(124),3)
  call HG1shiftOLR(G1H3(17),8,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(2),mass4set(:,2),  & 
G1H3(126),G1H3(10),G1H3(44),G1H3(128),G1H3(66),3)
  call HG1shiftOLR(G1H3(10),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(50),ex4(:),G2tensor(123),m3h3x1(:,172),heltab2x3(:,:,248))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(90),ex4(:),G2tensor(124),m3h3x1(:,173),heltab2x3(:,:,249))
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(19),mass4set(:,2),  & 
G1H3(131),G1H3(82),G1H3(132),G1H3(133),G1H3(20),3)
  call HG1shiftOLR(G1H3(82),8,3)
  call Hotf_4pt_reduction(G2H3(63),RedSet_4(19),mass4set(:,2),  & 
G1H3(134),G1H3(102),G1H3(98),G1H3(39),G1H3(29),3)
  call HG1shiftOLR(G1H3(102),8,3)
  call Hotf_4pt_reduction(G2H3(44),RedSet_4(19),mass4set(:,2),  & 
G1H3(18),G1H3(1),G1H3(5),G1H3(24),G1H3(30),3)
  call HG1shiftOLR(G1H3(1),8,3)
  call Hotf_4pt_reduction(G2H3(51),RedSet_4(19),mass4set(:,2),  & 
G1H3(33),G1H3(34),G1H3(41),G1H3(52),G1H3(55),3)
  call HG1shiftOLR(G1H3(34),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(138),ex4(:),G2tensor(125),m3h3x1(:,174),heltab2x3(:,:,250))
  call Hloop_ZQ_A(ntryL,G1H6(12),wf6(:,2),G1H1(20),ngZu,m3h6x1(:,5),heltab2x6(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,0,G2tensor(126),n2h1(73))
  call Hloop_WQ_A(ntryL,G1H6(14),wf6(:,2),G1H1(4),m3h6x1(:,6),heltab2x6(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,0,G2tensor(127),n2h1(74))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(16),wf6(:,2),G2tensor(128),m3h6x1(:,7),heltab2x6(:,:,138))
  call Hloop_ZA_Q(ntryL,G1H6(16),wf6(:,4),G1H1(29),ngZu,m3h6x1(:,8),heltab2x6(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,0,G2tensor(129),n2h1(75))
  call Hloop_WA_Q(ntryL,G1H6(1),wf6(:,4),G1H1(30),m3h6x1(:,9),heltab2x6(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,0,G2tensor(130),n2h1(76))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(18),wf6(:,4),G2tensor(131),m3h6x1(:,10),heltab2x6(:,:,141))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H3(153),19,wf3(:,10),12,G2tensor(132),m3h3x1(:,175),heltab2x3(:,:,251))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(154),19,wf3(:,10),12,G2tensor(133),m3h3x1(:,176),heltab2x3(:,:,252))
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(12),mass4set(:,8),  & 
G1H3(56),G1H3(61),G1H3(67),G1H3(73),G1H3(79),3)
  call HG1shiftOLR(G1H3(61),12,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(12),mass4set(:,9),  & 
G1H3(148),G1H3(97),G1H3(152),G1H3(151),G1H3(96),3)
  call HG1shiftOLR(G1H3(97),12,3)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(12),mass4set(:,10),  & 
G1H3(99),G1H3(103),G1H3(114),G1H3(119),G1H3(26),3)
  call HG1shiftOLR(G1H3(103),12,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(155),wf3(:,2),G1tensor(7),m3h3x1(:,177),heltab2x3(:,:,253))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(156),wf3(:,2),G1tensor(33),m3h3x1(:,178),heltab2x3(:,:,254))
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(12),mass4set(:,6),  & 
G1H3(4),G1H3(9),G1H3(46),G1H3(25),G1H3(28),3)
  call HG1shiftOLR(G1H3(9),12,3)
  call Hcheck_last_VS_T(ntryL,l_switch,G1H3(157),19,wf3(:,10),12,G2tensor(134),m3h3x1(:,179),heltab2x3(:,:,255))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(158),19,wf3(:,10),12,G2tensor(135),m3h3x1(:,180),heltab2x3(:,:,256))
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(4),mass4set(:,8),  & 
G1H3(31),G1H3(164),G1H3(35),G1H3(40),G1H3(45),3)
  call HG1shiftOLR(G1H3(164),12,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(4),mass4set(:,9),  & 
G1H3(47),G1H3(51),G1H3(53),G1H3(163),G1H3(57),3)
  call HG1shiftOLR(G1H3(51),12,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(4),mass4set(:,10),  & 
G1H3(104),G1H3(62),G1H3(63),G1H3(105),G1H3(68),3)
  call HG1shiftOLR(G1H3(62),12,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(159),wf3(:,2),G1tensor(39),m3h3x1(:,181),heltab2x3(:,:,257))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(160),wf3(:,2),G1tensor(45),m3h3x1(:,182),heltab2x3(:,:,258))
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(4),mass4set(:,6),  & 
G1H3(69),G1H3(161),G1H3(74),G1H3(75),G1H3(162),3)
  call HG1shiftOLR(G1H3(161),12,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(22),mass4set(:,8),  & 
G1H3(80),G1H3(81),G1H3(42),G1H3(58),G1H3(48),3)
  call HG1shiftOLR(G1H3(81),8,3)
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(22),mass4set(:,9),  & 
G1H3(43),G1H3(153),G1H3(154),G1H3(155),G1H3(156),3)
  call HG1shiftOLR(G1H3(153),8,3)
  call Hotf_4pt_reduction(G2H3(38),RedSet_4(22),mass4set(:,10),  & 
G1H3(157),G1H3(158),G1H3(159),G1H3(160),G1H3(165),3)
  call HG1shiftOLR(G1H3(158),8,3)
  call Hotf_4pt_reduction(G2H3(46),RedSet_4(17),mass4set(:,8),  & 
G1H3(166),G1H3(167),G1H3(168),G1H3(169),G1H3(170),3)
  call HG1shiftOLR(G1H3(167),8,3)
  call Hotf_4pt_reduction(G2H3(47),RedSet_4(17),mass4set(:,9),  & 
G1H3(171),G1H3(172),G1H3(173),G1H3(174),G1H3(175),3)
  call HG1shiftOLR(G1H3(172),8,3)
  call Hotf_4pt_reduction(G2H3(48),RedSet_4(17),mass4set(:,10),  & 
G1H3(176),G1H3(177),G1H3(178),G1H3(179),G1H3(180),3)
  call HG1shiftOLR(G1H3(177),8,3)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(47),mass4set(:,7),  & 
G1H2(12),G1H2(11),G1H2(5),G1H2(3),G1H2(4),2)
  call HG1shiftOLR(G1H2(11),2,2)
  call Hotf_4pt_reduction(G2H1(19),RedSet_4(48),mass4set(:,11),  & 
G1H1(21),G1H1(35),G1H1(36),G1H1(19),G1H1(23),1)
  call HG1shiftOLR(G1H1(35),4,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(26),ex3(:),G1tensor(51),m3h1x1(:,55),heltab2x1(:,:,55))
  call Hotf_4pt_reduction(G2H1(21),RedSet_4(49),mass4set(:,11),  & 
G1H1(27),G1H1(28),G1H1(20),G1H1(4),G1H1(29),1)
  call HG1shiftOLR(G1H1(28),4,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(1),ex3(:),G1tensor(57),m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(136),m3h2x1(:,36),heltab2x2(:,:,38))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(137),m3h2x1(:,37),heltab2x2(:,:,39))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(54),ex4(:),G2tensor(138),m3h3x1(:,183),heltab2x3(:,:,259))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(28),ex3(:),G2tensor(139),m3h1x1(:,57),heltab2x1(:,:,57))
  call Hotf_4pt_reduction(G2H1(29),RedSet_4(7),mass4set(:,3),  & 
G1H1(30),G1H1(26),G1H1(1),G1H1(42),G1H1(43),1)
  call HG1shiftOLR(G1H1(26),4,1)
  call Hloop_QS_A(ntryL,G2H1(31),ex3(:),G2H1(14),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(14),31,nML,G3tensor(1),n2h1(77))
  call Hloop_QS_A(ntryL,G1H1(38),ex3(:),G1H1(44),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nML,G2tensor(140),n2h1(78))
  call Hotf_4pt_reduction(G2H1(32),RedSet_4(7),mass4set(:,3),  & 
G1H1(38),G1H1(44),G1H1(45),G1H1(46),G1H1(47),1)
  call HG1shiftOLR(G1H1(44),4,1)
  call Hloop_AS_Q(ntryL,G2H1(34),ex3(:),G2H1(8),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,nML,G3tensor(2),n2h1(79))
  call Hloop_AS_Q(ntryL,G1H1(10),ex3(:),G1H1(48),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(48),31,nML,G2tensor(141),n2h1(80))
  call Hotf_4pt_reduction(G2H1(35),RedSet_4(7),mass4set(:,4),  & 
G1H1(10),G1H1(48),G1H1(49),G1H1(50),G1H1(51),1)
  call HG1shiftOLR(G1H1(48),4,1)
  call Hloop_QS_A(ntryL,G2H1(37),ex3(:),G2H1(17),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,nMT,G3tensor(3),n2h1(81))
  call Hloop_QS_A(ntryL,G1H1(12),ex3(:),G1H1(52),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(52),31,nMT,G2tensor(142),n2h1(82))
  call Hotf_4pt_reduction(G2H1(38),RedSet_4(7),mass4set(:,4),  & 
G1H1(12),G1H1(52),G1H1(53),G1H1(54),G1H1(55),1)
  call HG1shiftOLR(G1H1(52),4,1)
  call Hloop_AS_Q(ntryL,G2H1(40),ex3(:),G2H1(11),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),31,nMT,G3tensor(4),n2h1(83))
  call Hloop_AS_Q(ntryL,G1H1(11),ex3(:),G1H1(56),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMT,G2tensor(143),n2h1(84))
  call Hotf_4pt_reduction(G2H1(41),RedSet_4(7),mass4set(:,5),  & 
G1H1(11),G1H1(56),G1H1(57),G1H1(58),G1H1(59),1)
  call HG1shiftOLR(G1H1(56),4,1)
  call Hloop_QS_A(ntryL,G2H1(43),ex3(:),G2H1(9),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMB,G3tensor(5),n2h1(85))
  call Hloop_QS_A(ntryL,G1H1(16),ex3(:),G1H1(60),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(60),31,nMB,G2tensor(144),n2h1(86))
  call Hotf_4pt_reduction(G2H1(44),RedSet_4(7),mass4set(:,5),  & 
G1H1(16),G1H1(60),G1H1(61),G1H1(62),G1H1(63),1)
  call HG1shiftOLR(G1H1(60),4,1)
  call Hloop_AS_Q(ntryL,G2H1(46),ex3(:),G2H1(7),ngH,m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(6),n2h1(87))
  call Hloop_AS_Q(ntryL,G1H1(34),ex3(:),G1H1(64),ngH,m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(64),31,nMB,G2tensor(145),n2h1(88))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(52),ex3(:),G2tensor(146),m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(53),ex3(:),G2tensor(147),m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(55),ex3(:),G2tensor(148),m3h1x1(:,72),heltab2x1(:,:,72))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(56),ex3(:),G2tensor(149),m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(58),ex3(:),G2tensor(150),m3h1x1(:,74),heltab2x1(:,:,74))
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(2),mass4set(:,3),  & 
G1H3(181),G1H3(182),G1H3(183),G1H3(184),G1H3(185),3)
  call HG1shiftOLR(G1H3(182),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(74),ex4(:),G2H1(13),ngZl,m3h3x1(:,184),heltab2x3(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nML,G3tensor(7),n2h1(89))
  call Hloop_AZ_Q(ntryL,G1H3(49),ex4(:),G1H1(34),ngZl,m3h3x1(:,185),heltab2x3(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nML,G2tensor(151),n2h1(90))
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(2),mass4set(:,3),  & 
G1H3(49),G1H3(186),G1H3(187),G1H3(188),G1H3(189),3)
  call HG1shiftOLR(G1H3(186),8,3)
  call Hloop_QZ_A(ntryL,G2H3(77),ex4(:),G2H1(10),ngZl,m3h3x1(:,186),heltab2x3(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nML,G3tensor(8),n2h1(91))
  call Hloop_QZ_A(ntryL,G1H3(78),ex4(:),G1H1(64),ngZl,m3h3x1(:,187),heltab2x3(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nML,G2tensor(152),n2h1(92))
  call Hotf_4pt_reduction(G2H3(78),RedSet_4(2),mass4set(:,4),  & 
G1H3(78),G1H3(190),G1H3(191),G1H3(192),G1H3(193),3)
  call HG1shiftOLR(G1H3(190),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(80),ex4(:),G2H1(47),ngZu,m3h3x1(:,188),heltab2x3(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(47),31,nMT,G3tensor(9),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(65),ex4(:),G1H1(34),ngZu,m3h3x1(:,189),heltab2x3(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nMT,G2tensor(153),n2h1(94))
  call Hotf_4pt_reduction(G2H3(81),RedSet_4(2),mass4set(:,4),  & 
G1H3(65),G1H3(194),G1H3(195),G1H3(196),G1H3(197),3)
  call HG1shiftOLR(G1H3(194),8,3)
  call Hloop_QZ_A(ntryL,G2H3(83),ex4(:),G2H1(23),ngZu,m3h3x1(:,190),heltab2x3(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMT,G3tensor(10),n2h1(95))
  call Hloop_QZ_A(ntryL,G1H3(71),ex4(:),G1H1(64),ngZu,m3h3x1(:,191),heltab2x3(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nMT,G2tensor(154),n2h1(96))
  call Hotf_4pt_reduction(G2H3(84),RedSet_4(2),mass4set(:,5),  & 
G1H3(71),G1H3(198),G1H3(199),G1H3(200),G1H3(201),3)
  call HG1shiftOLR(G1H3(198),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(86),ex4(:),G2H1(25),ngZd,m3h3x1(:,192),heltab2x3(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(25),31,nMB,G3tensor(11),n2h1(97))
  call Hloop_AZ_Q(ntryL,G1H3(32),ex4(:),G1H1(34),ngZd,m3h3x1(:,193),heltab2x3(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(155),n2h1(98))
  call Hotf_4pt_reduction(G2H3(87),RedSet_4(2),mass4set(:,5),  & 
G1H3(32),G1H3(202),G1H3(203),G1H3(204),G1H3(205),3)
  call HG1shiftOLR(G1H3(202),8,3)
  call Hloop_QZ_A(ntryL,G2H3(89),ex4(:),G2H1(49),ngZd,m3h3x1(:,194),heltab2x3(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(49),31,nMB,G3tensor(12),n2h1(99))
  call Hloop_QZ_A(ntryL,G1H3(27),ex4(:),G1H1(64),ngZd,m3h3x1(:,195),heltab2x3(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nMB,G2tensor(156),n2h1(100))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(92),ex4(:),G2tensor(157),m3h3x1(:,196),heltab2x3(:,:,272))
  call Hotf_4pt_reduction(G2H3(111),RedSet_4(19),mass4set(:,3),  & 
G1H3(27),G1H3(206),G1H3(207),G1H3(208),G1H3(209),3)
  call HG1shiftOLR(G1H3(206),8,3)
  call Hloop_QZ_A(ntryL,G2H3(113),ex4(:),G2H1(16),ngZl,m3h3x1(:,197),heltab2x3(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nML,G3tensor(13),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H3(54),ex4(:),G1H1(34),ngZl,m3h3x1(:,198),heltab2x3(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nML,G2tensor(158),n2h1(102))
  call Hotf_4pt_reduction(G2H3(114),RedSet_4(19),mass4set(:,3),  & 
G1H3(54),G1H3(210),G1H3(211),G1H3(212),G1H3(213),3)
  call HG1shiftOLR(G1H3(210),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(116),ex4(:),G2H1(18),ngZl,m3h3x1(:,199),heltab2x3(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nML,G3tensor(14),n2h1(103))
  call Hloop_AZ_Q(ntryL,G1H3(38),ex4(:),G1H1(64),ngZl,m3h3x1(:,200),heltab2x3(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(64),31,nML,G2tensor(159),n2h1(104))
  call Hotf_4pt_reduction(G2H3(117),RedSet_4(19),mass4set(:,4),  & 
G1H3(38),G1H3(214),G1H3(215),G1H3(216),G1H3(217),3)
  call HG1shiftOLR(G1H3(214),8,3)
  call Hloop_QZ_A(ntryL,G2H3(119),ex4(:),G2H1(20),ngZu,m3h3x1(:,201),heltab2x3(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),31,nMT,G3tensor(15),n2h1(105))
  call Hloop_QZ_A(ntryL,G1H3(127),ex4(:),G1H1(34),ngZu,m3h3x1(:,202),heltab2x3(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMT,G2tensor(160),n2h1(106))
  call Hotf_4pt_reduction(G2H3(120),RedSet_4(19),mass4set(:,4),  & 
G1H3(127),G1H3(218),G1H3(219),G1H3(220),G1H3(221),3)
  call HG1shiftOLR(G1H3(218),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(122),ex4(:),G2H1(22),ngZu,m3h3x1(:,203),heltab2x3(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),31,nMT,G3tensor(16),n2h1(107))
  call Hloop_AZ_Q(ntryL,G1H3(129),ex4(:),G1H1(64),ngZu,m3h3x1(:,204),heltab2x3(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(64),31,nMT,G2tensor(161),n2h1(108))
  call Hotf_4pt_reduction(G2H3(123),RedSet_4(19),mass4set(:,5),  & 
G1H3(129),G1H3(222),G1H3(223),G1H3(224),G1H3(225),3)
  call HG1shiftOLR(G1H3(222),8,3)
  call Hloop_QZ_A(ntryL,G2H3(125),ex4(:),G2H1(12),ngZd,m3h3x1(:,205),heltab2x3(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMB,G3tensor(17),n2h1(109))
  call Hloop_QZ_A(ntryL,G1H3(70),ex4(:),G1H1(34),ngZd,m3h3x1(:,206),heltab2x3(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(162),n2h1(110))
  call Hotf_4pt_reduction(G2H3(126),RedSet_4(19),mass4set(:,5),  & 
G1H3(70),G1H3(226),G1H3(227),G1H3(228),G1H3(229),3)
  call HG1shiftOLR(G1H3(226),8,3)
  call Hloop_AZ_Q(ntryL,G2H3(128),ex4(:),G2H1(15),ngZd,m3h3x1(:,207),heltab2x3(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMB,G3tensor(18),n2h1(111))
  call Hloop_AZ_Q(ntryL,G1H3(136),ex4(:),G1H1(64),ngZd,m3h3x1(:,208),heltab2x3(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(64),31,nMB,G2tensor(163),n2h1(112))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(140),ex4(:),G2tensor(164),m3h3x1(:,209),heltab2x3(:,:,285))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(152),ex4(:),G2tensor(165),m3h3x1(:,210),heltab2x3(:,:,286))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(166),m3h2x1(:,38),heltab2x2(:,:,40))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(167),m3h2x1(:,39),heltab2x2(:,:,41))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(5),27,ex3(:),4,G2tensor(168),m3h1x1(:,75),heltab2x1(:,:,75))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(6),0,ex3(:),4,G2tensor(169),m3h1x1(:,76),heltab2x1(:,:,76))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(8),27,ex3(:),4,G2tensor(170),m3h1x1(:,77),heltab2x1(:,:,77))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(137),23,ex4(:),8,G2tensor(171),m3h3x1(:,211),heltab2x3(:,:,287))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(72),0,ex4(:),8,G2tensor(172),m3h3x1(:,212),heltab2x3(:,:,288))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(139),23,ex4(:),8,G2tensor(173),m3h3x1(:,213),heltab2x3(:,:,289))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(24),27,ex3(:),4,G2tensor(174),m3h1x1(:,78),heltab2x1(:,:,78))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(14),0,ex3(:),4,G2tensor(175),m3h1x1(:,79),heltab2x1(:,:,79))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(17),27,ex3(:),4,G2tensor(176),m3h1x1(:,80),heltab2x1(:,:,80))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(141),23,ex4(:),8,G2tensor(177),m3h3x1(:,214),heltab2x3(:,:,290))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(3),0,ex4(:),8,G2tensor(178),m3h3x1(:,215),heltab2x3(:,:,291))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(143),23,ex4(:),8,G2tensor(179),m3h3x1(:,216),heltab2x3(:,:,292))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(85),23,ex4(:),8,G2tensor(180),m3h3x1(:,217),heltab2x3(:,:,293))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(144),0,ex4(:),8,G2tensor(181),m3h3x1(:,218),heltab2x3(:,:,294))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(147),23,ex4(:),8,G2tensor(182),m3h3x1(:,219),heltab2x3(:,:,295))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(86),23,ex4(:),8,G2tensor(183),m3h3x1(:,220),heltab2x3(:,:,296))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(84),0,ex4(:),8,G2tensor(184),m3h3x1(:,221),heltab2x3(:,:,297))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(150),23,ex4(:),8,G2tensor(185),m3h3x1(:,222),heltab2x3(:,:,298))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(11),23,ex4(:),8,G2tensor(186),m3h3x1(:,223),heltab2x3(:,:,299))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(91),0,ex4(:),8,G2tensor(187),m3h3x1(:,224),heltab2x3(:,:,300))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(101),23,ex4(:),8,G2tensor(188),m3h3x1(:,225),heltab2x3(:,:,301))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(100),23,ex4(:),8,G2tensor(189),m3h3x1(:,226),heltab2x3(:,:,302))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(94),0,ex4(:),8,G2tensor(190),m3h3x1(:,227),heltab2x3(:,:,303))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(106),23,ex4(:),8,G2tensor(191),m3h3x1(:,228),heltab2x3(:,:,304))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(37),27,ex3(:),4,G2tensor(192),m3h1x1(:,81),heltab2x1(:,:,81))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(25),0,ex3(:),4,G2tensor(193),m3h1x1(:,82),heltab2x1(:,:,82))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(22),27,ex3(:),4,G2tensor(194),m3h1x1(:,83),heltab2x1(:,:,83))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(9),27,ex3(:),4,G2tensor(195),m3h1x1(:,84),heltab2x1(:,:,84))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(13),0,ex3(:),4,G2tensor(196),m3h1x1(:,85),heltab2x1(:,:,85))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(41),27,ex3(:),4,G2tensor(197),m3h1x1(:,86),heltab2x1(:,:,86))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(112),23,ex4(:),8,G2tensor(198),m3h3x1(:,229),heltab2x3(:,:,305))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(113),0,ex4(:),8,G2tensor(199),m3h3x1(:,230),heltab2x3(:,:,306))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(118),23,ex4(:),8,G2tensor(200),m3h3x1(:,231),heltab2x3(:,:,307))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(120),23,ex4(:),8,G2tensor(201),m3h3x1(:,232),heltab2x3(:,:,308))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(122),0,ex4(:),8,G2tensor(202),m3h3x1(:,233),heltab2x3(:,:,309))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(59),23,ex4(:),8,G2tensor(203),m3h3x1(:,234),heltab2x3(:,:,310))
  call Hloop_WA_Q(ntryL,G1H2(8),ex2(:),G1H1(34),m3h2x1(:,40),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,0,G2tensor(204),n2h1(125))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(64),m3h2x1(:,41),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(64),2,0,G2tensor(205),n2h1(126))
  call Hloop_WA_Q(ntryL,G1H2(2),ex2(:),G1H1(5),m3h2x1(:,42),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,0,G2tensor(206),n2h1(127))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(2),23,ex4(:),G2tensor(207),m3h3x1(:,235),heltab2x3(:,:,311))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(17),0,ex4(:),G2tensor(208),m3h3x1(:,236),heltab2x3(:,:,312))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(124),23,ex4(:),G2tensor(209),m3h3x1(:,237),heltab2x3(:,:,313))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(126),23,ex4(:),8,G2tensor(210),m3h3x1(:,238),heltab2x3(:,:,314))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(10),0,ex4(:),8,G2tensor(211),m3h3x1(:,239),heltab2x3(:,:,315))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(66),23,ex4(:),8,G2tensor(212),m3h3x1(:,240),heltab2x3(:,:,316))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(131),23,ex4(:),8,G2tensor(213),m3h3x1(:,241),heltab2x3(:,:,317))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(82),0,ex4(:),8,G2tensor(214),m3h3x1(:,242),heltab2x3(:,:,318))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(20),23,ex4(:),8,G2tensor(215),m3h3x1(:,243),heltab2x3(:,:,319))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(134),23,ex4(:),8,G2tensor(216),m3h3x1(:,244),heltab2x3(:,:,320))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(102),0,ex4(:),8,G2tensor(217),m3h3x1(:,245),heltab2x3(:,:,321))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(29),23,ex4(:),8,G2tensor(218),m3h3x1(:,246),heltab2x3(:,:,322))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(18),23,ex4(:),8,G2tensor(219),m3h3x1(:,247),heltab2x3(:,:,323))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(1),0,ex4(:),8,G2tensor(220),m3h3x1(:,248),heltab2x3(:,:,324))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(30),23,ex4(:),8,G2tensor(221),m3h3x1(:,249),heltab2x3(:,:,325))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(33),23,ex4(:),G2tensor(222),m3h3x1(:,250),heltab2x3(:,:,326))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(34),0,ex4(:),G2tensor(223),m3h3x1(:,251),heltab2x3(:,:,327))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(55),23,ex4(:),G2tensor(224),m3h3x1(:,252),heltab2x3(:,:,328))
  call Hloop_AZ_Q(ntryL,G1H3(56),wf3(:,2),G1H1(6),ngZu,m3h3x1(:,253),heltab2x3(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,0,G2tensor(225),n2h1(134))
  call Hloop_AZ_Q(ntryL,G1H3(61),wf3(:,2),G1H1(8),ngZu,m3h3x1(:,254),heltab2x3(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),12,0,G2tensor(226),n2h1(135))
  call Hloop_AZ_Q(ntryL,G1H3(79),wf3(:,2),G1H1(24),ngZu,m3h3x1(:,255),heltab2x3(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,0,G2tensor(227),n2h1(136))
  call Hloop_AZ_Q(ntryL,G1H3(148),wf3(:,2),G1H1(14),ngZu,m3h3x1(:,256),heltab2x3(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,0,G2tensor(228),n2h1(137))
  call Hloop_AZ_Q(ntryL,G1H3(97),wf3(:,2),G1H1(17),ngZu,m3h3x1(:,257),heltab2x3(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),12,0,G2tensor(229),n2h1(138))
  call Hloop_AZ_Q(ntryL,G1H3(96),wf3(:,2),G1H1(37),ngZu,m3h3x1(:,258),heltab2x3(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,0,G2tensor(230),n2h1(139))
  call Hloop_AZ_Q(ntryL,G1H3(99),wf3(:,2),G1H1(25),ngZd,m3h3x1(:,259),heltab2x3(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,0,G2tensor(231),n2h1(140))
  call Hloop_AZ_Q(ntryL,G1H3(103),wf3(:,2),G1H1(22),ngZd,m3h3x1(:,260),heltab2x3(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),12,0,G2tensor(232),n2h1(141))
  call Hloop_AZ_Q(ntryL,G1H3(26),wf3(:,2),G1H1(9),ngZd,m3h3x1(:,261),heltab2x3(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,0,G2tensor(233),n2h1(142))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(4),19,wf3(:,2),12,G2tensor(234),m3h3x1(:,262),heltab2x3(:,:,338))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(9),0,wf3(:,2),12,G2tensor(235),m3h3x1(:,263),heltab2x3(:,:,339))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(28),19,wf3(:,2),12,G2tensor(236),m3h3x1(:,264),heltab2x3(:,:,340))
  call Hloop_QZ_A(ntryL,G1H3(31),wf3(:,2),G1H1(13),ngZu,m3h3x1(:,265),heltab2x3(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,0,G2tensor(237),n2h1(144))
  call Hloop_QZ_A(ntryL,G1H3(164),wf3(:,2),G1H1(41),ngZu,m3h3x1(:,266),heltab2x3(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),12,0,G2tensor(238),n2h1(145))
  call Hloop_QZ_A(ntryL,G1H3(45),wf3(:,2),G1H1(34),ngZu,m3h3x1(:,267),heltab2x3(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,0,G2tensor(239),n2h1(146))
  call Hloop_QZ_A(ntryL,G1H3(47),wf3(:,2),G1H1(64),ngZu,m3h3x1(:,268),heltab2x3(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,0,G2tensor(240),n2h1(147))
  call Hloop_QZ_A(ntryL,G1H3(51),wf3(:,2),G1H1(5),ngZu,m3h3x1(:,269),heltab2x3(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),12,0,G2tensor(241),n2h1(148))
  call Hloop_QZ_A(ntryL,G1H3(57),wf3(:,2),G1H1(6),ngZu,m3h3x1(:,270),heltab2x3(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,0,G2tensor(242),n2h1(149))
  call Hloop_QZ_A(ntryL,G1H3(104),wf3(:,2),G1H1(8),ngZd,m3h3x1(:,271),heltab2x3(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,0,G2tensor(243),n2h1(150))
  call Hloop_QZ_A(ntryL,G1H3(62),wf3(:,2),G1H1(24),ngZd,m3h3x1(:,272),heltab2x3(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),12,0,G2tensor(244),n2h1(151))
  call Hloop_QZ_A(ntryL,G1H3(68),wf3(:,2),G1H1(14),ngZd,m3h3x1(:,273),heltab2x3(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,0,G2tensor(245),n2h1(152))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(69),19,wf3(:,2),12,G2tensor(246),m3h3x1(:,274),heltab2x3(:,:,350))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(161),0,wf3(:,2),12,G2tensor(247),m3h3x1(:,275),heltab2x3(:,:,351))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(162),19,wf3(:,2),12,G2tensor(248),m3h3x1(:,276),heltab2x3(:,:,352))
  call Hloop_QZ_A(ntryL,G1H3(80),ex4(:),G1H1(17),ngZu,m3h3x1(:,277),heltab2x3(:,:,353))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,0,G2tensor(249),n2h1(154))
  call Hloop_QZ_A(ntryL,G1H3(81),ex4(:),G1H1(37),ngZu,m3h3x1(:,278),heltab2x3(:,:,354))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),8,0,G2tensor(250),n2h1(155))
  call Hloop_QZ_A(ntryL,G1H3(48),ex4(:),G1H1(25),ngZu,m3h3x1(:,279),heltab2x3(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,0,G2tensor(251),n2h1(156))
  call Hloop_QZ_A(ntryL,G1H3(43),ex4(:),G1H1(22),ngZu,m3h3x1(:,280),heltab2x3(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,0,G2tensor(252),n2h1(157))
  call Hloop_QZ_A(ntryL,G1H3(153),ex4(:),G1H1(9),ngZu,m3h3x1(:,281),heltab2x3(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),8,0,G2tensor(253),n2h1(158))
  call Hloop_QZ_A(ntryL,G1H3(156),ex4(:),G1H1(13),ngZu,m3h3x1(:,282),heltab2x3(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,0,G2tensor(254),n2h1(159))
  call Hloop_QZ_A(ntryL,G1H3(157),ex4(:),G1H1(41),ngZd,m3h3x1(:,283),heltab2x3(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,0,G2tensor(255),n2h1(160))
  call Hloop_QZ_A(ntryL,G1H3(158),ex4(:),G1H1(34),ngZd,m3h3x1(:,284),heltab2x3(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),8,0,G2tensor(256),n2h1(161))
  call Hloop_QZ_A(ntryL,G1H3(165),ex4(:),G1H1(64),ngZd,m3h3x1(:,285),heltab2x3(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,0,G2tensor(257),n2h1(162))
  call Hloop_AZ_Q(ntryL,G1H3(166),ex4(:),G1H1(5),ngZu,m3h3x1(:,286),heltab2x3(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,0,G2tensor(258),n2h1(163))
  call Hloop_AZ_Q(ntryL,G1H3(167),ex4(:),G1H1(6),ngZu,m3h3x1(:,287),heltab2x3(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),8,0,G2tensor(259),n2h1(164))
  call Hloop_AZ_Q(ntryL,G1H3(170),ex4(:),G1H1(8),ngZu,m3h3x1(:,288),heltab2x3(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,0,G2tensor(260),n2h1(165))
  call Hloop_AZ_Q(ntryL,G1H3(171),ex4(:),G1H1(24),ngZu,m3h3x1(:,289),heltab2x3(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,0,G2tensor(261),n2h1(166))
  call Hloop_AZ_Q(ntryL,G1H3(172),ex4(:),G1H1(14),ngZu,m3h3x1(:,290),heltab2x3(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),8,0,G2tensor(262),n2h1(167))
  call Hloop_AZ_Q(ntryL,G1H3(175),ex4(:),G1H1(17),ngZu,m3h3x1(:,291),heltab2x3(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,0,G2tensor(263),n2h1(168))
  call Hloop_AZ_Q(ntryL,G1H3(176),ex4(:),G1H1(37),ngZd,m3h3x1(:,292),heltab2x3(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,0,G2tensor(264),n2h1(169))
  call Hloop_AZ_Q(ntryL,G1H3(177),ex4(:),G1H1(25),ngZd,m3h3x1(:,293),heltab2x3(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),8,0,G2tensor(265),n2h1(170))
  call Hloop_AZ_Q(ntryL,G1H3(180),ex4(:),G1H1(22),ngZd,m3h3x1(:,294),heltab2x3(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,0,G2tensor(266),n2h1(171))
  call Hloop_WA_Q(ntryL,G1H2(12),ex2(:),G1H1(9),m3h2x1(:,43),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,0,G2tensor(267),n2h1(172))
  call Hloop_WA_Q(ntryL,G1H2(11),ex2(:),G1H1(13),m3h2x1(:,44),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),2,0,G2tensor(268),n2h1(173))
  call Hloop_WA_Q(ntryL,G1H2(4),ex2(:),G1H1(41),m3h2x1(:,45),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,0,G2tensor(269),n2h1(174))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(21),27,ex3(:),4,G2tensor(270),m3h1x1(:,87),heltab2x1(:,:,87))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(35),0,ex3(:),4,G2tensor(271),m3h1x1(:,88),heltab2x1(:,:,88))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(23),27,ex3(:),4,G2tensor(272),m3h1x1(:,89),heltab2x1(:,:,89))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(27),27,ex3(:),4,G2tensor(273),m3h1x1(:,90),heltab2x1(:,:,90))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(28),0,ex3(:),4,G2tensor(274),m3h1x1(:,91),heltab2x1(:,:,91))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(29),27,ex3(:),4,G2tensor(275),m3h1x1(:,92),heltab2x1(:,:,92))
  call Hloop_QS_A(ntryL,G1H1(30),ex3(:),G1H1(34),ngH,m3h1x1(:,93),heltab2x1(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nML,G2tensor(276),n2h1(177))
  call Hloop_QS_A(ntryL,G1H1(26),ex3(:),G1H1(64),ngH,m3h1x1(:,94),heltab2x1(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),4,nML,G2tensor(277),n2h1(178))
  call Hloop_QS_A(ntryL,G1H1(43),ex3(:),G1H1(5),ngH,m3h1x1(:,95),heltab2x1(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nML,G2tensor(278),n2h1(179))
  call Hloop_AS_Q(ntryL,G1H1(38),ex3(:),G1H1(6),ngH,m3h1x1(:,96),heltab2x1(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nML,G2tensor(279),n2h1(180))
  call Hloop_AS_Q(ntryL,G1H1(44),ex3(:),G1H1(8),ngH,m3h1x1(:,97),heltab2x1(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),4,nML,G2tensor(280),n2h1(181))
  call Hloop_AS_Q(ntryL,G1H1(47),ex3(:),G1H1(24),ngH,m3h1x1(:,98),heltab2x1(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nML,G2tensor(281),n2h1(182))
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(14),ngH,m3h1x1(:,99),heltab2x1(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMT,G2tensor(282),n2h1(183))
  call Hloop_QS_A(ntryL,G1H1(48),ex3(:),G1H1(17),ngH,m3h1x1(:,100),heltab2x1(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),4,nMT,G2tensor(283),n2h1(184))
  call Hloop_QS_A(ntryL,G1H1(51),ex3(:),G1H1(37),ngH,m3h1x1(:,101),heltab2x1(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,nMT,G2tensor(284),n2h1(185))
  call Hloop_AS_Q(ntryL,G1H1(12),ex3(:),G1H1(25),ngH,m3h1x1(:,102),heltab2x1(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nMT,G2tensor(285),n2h1(186))
  call Hloop_AS_Q(ntryL,G1H1(52),ex3(:),G1H1(22),ngH,m3h1x1(:,103),heltab2x1(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),4,nMT,G2tensor(286),n2h1(187))
  call Hloop_AS_Q(ntryL,G1H1(55),ex3(:),G1H1(9),ngH,m3h1x1(:,104),heltab2x1(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMT,G2tensor(287),n2h1(188))
  call Hloop_QS_A(ntryL,G1H1(11),ex3(:),G1H1(13),ngH,m3h1x1(:,105),heltab2x1(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(288),n2h1(189))
  call Hloop_QS_A(ntryL,G1H1(56),ex3(:),G1H1(41),ngH,m3h1x1(:,106),heltab2x1(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),4,nMB,G2tensor(289),n2h1(190))
  call Hloop_QS_A(ntryL,G1H1(59),ex3(:),G1H1(21),ngH,m3h1x1(:,107),heltab2x1(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(290),n2h1(191))
  call Hloop_AS_Q(ntryL,G1H1(16),ex3(:),G1H1(35),ngH,m3h1x1(:,108),heltab2x1(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),31,nMB,G2tensor(291),n2h1(192))
  call Hloop_AS_Q(ntryL,G1H1(60),ex3(:),G1H1(23),ngH,m3h1x1(:,109),heltab2x1(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),4,nMB,G2tensor(292),n2h1(193))
  call Hloop_AS_Q(ntryL,G1H1(63),ex3(:),G1H1(27),ngH,m3h1x1(:,110),heltab2x1(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(293),n2h1(194))
  call Hloop_AZ_Q(ntryL,G1H3(181),ex4(:),G1H1(28),ngZl,m3h3x1(:,295),heltab2x3(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nML,G2tensor(294),n2h1(195))
  call Hloop_AZ_Q(ntryL,G1H3(182),ex4(:),G1H1(29),ngZl,m3h3x1(:,296),heltab2x3(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),8,nML,G2tensor(295),n2h1(196))
  call Hloop_AZ_Q(ntryL,G1H3(185),ex4(:),G1H1(30),ngZl,m3h3x1(:,297),heltab2x3(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nML,G2tensor(296),n2h1(197))
  call Hloop_QZ_A(ntryL,G1H3(49),ex4(:),G1H1(34),ngZl,m3h3x1(:,298),heltab2x3(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nML,G2tensor(297),n2h1(198))
  call Hloop_QZ_A(ntryL,G1H3(186),ex4(:),G1H1(26),ngZl,m3h3x1(:,299),heltab2x3(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),8,nML,G2tensor(298),n2h1(199))
  call Hloop_QZ_A(ntryL,G1H3(189),ex4(:),G1H1(64),ngZl,m3h3x1(:,300),heltab2x3(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nML,G2tensor(299),n2h1(200))
  call Hloop_AZ_Q(ntryL,G1H3(78),ex4(:),G1H1(43),ngZu,m3h3x1(:,301),heltab2x3(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),31,nMT,G2tensor(300),n2h1(201))
  call Hloop_AZ_Q(ntryL,G1H3(190),ex4(:),G1H1(5),ngZu,m3h3x1(:,302),heltab2x3(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),8,nMT,G2tensor(301),n2h1(202))
  call Hloop_AZ_Q(ntryL,G1H3(193),ex4(:),G1H1(38),ngZu,m3h3x1(:,303),heltab2x3(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),31,nMT,G2tensor(302),n2h1(203))
  call Hloop_QZ_A(ntryL,G1H3(65),ex4(:),G1H1(6),ngZu,m3h3x1(:,304),heltab2x3(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(303),n2h1(204))
  call Hloop_QZ_A(ntryL,G1H3(194),ex4(:),G1H1(44),ngZu,m3h3x1(:,305),heltab2x3(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),8,nMT,G2tensor(304),n2h1(205))
  call Hloop_QZ_A(ntryL,G1H3(197),ex4(:),G1H1(8),ngZu,m3h3x1(:,306),heltab2x3(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nMT,G2tensor(305),n2h1(206))
  call Hloop_AZ_Q(ntryL,G1H3(71),ex4(:),G1H1(47),ngZd,m3h3x1(:,307),heltab2x3(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),31,nMB,G2tensor(306),n2h1(207))
  call Hloop_AZ_Q(ntryL,G1H3(198),ex4(:),G1H1(24),ngZd,m3h3x1(:,308),heltab2x3(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),8,nMB,G2tensor(307),n2h1(208))
  call Hloop_AZ_Q(ntryL,G1H3(201),ex4(:),G1H1(10),ngZd,m3h3x1(:,309),heltab2x3(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(308),n2h1(209))
  call Hloop_QZ_A(ntryL,G1H3(32),ex4(:),G1H1(14),ngZd,m3h3x1(:,310),heltab2x3(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(309),n2h1(210))
  call Hloop_QZ_A(ntryL,G1H3(202),ex4(:),G1H1(48),ngZd,m3h3x1(:,311),heltab2x3(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(48),8,nMB,G2tensor(310),n2h1(211))
  call Hloop_QZ_A(ntryL,G1H3(205),ex4(:),G1H1(17),ngZd,m3h3x1(:,312),heltab2x3(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(311),n2h1(212))
  call Hloop_QZ_A(ntryL,G1H3(27),ex4(:),G1H1(51),ngZl,m3h3x1(:,313),heltab2x3(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(51),31,nML,G2tensor(312),n2h1(213))
  call Hloop_QZ_A(ntryL,G1H3(206),ex4(:),G1H1(37),ngZl,m3h3x1(:,314),heltab2x3(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),8,nML,G2tensor(313),n2h1(214))
  call Hloop_QZ_A(ntryL,G1H3(209),ex4(:),G1H1(12),ngZl,m3h3x1(:,315),heltab2x3(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nML,G2tensor(314),n2h1(215))
  call Hloop_AZ_Q(ntryL,G1H3(54),ex4(:),G1H1(25),ngZl,m3h3x1(:,316),heltab2x3(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nML,G2tensor(315),n2h1(216))
  call Hloop_AZ_Q(ntryL,G1H3(210),ex4(:),G1H1(52),ngZl,m3h3x1(:,317),heltab2x3(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(52),8,nML,G2tensor(316),n2h1(217))
  call Hloop_AZ_Q(ntryL,G1H3(213),ex4(:),G1H1(22),ngZl,m3h3x1(:,318),heltab2x3(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nML,G2tensor(317),n2h1(218))
  call Hloop_QZ_A(ntryL,G1H3(38),ex4(:),G1H1(55),ngZu,m3h3x1(:,319),heltab2x3(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),31,nMT,G2tensor(318),n2h1(219))
  call Hloop_QZ_A(ntryL,G1H3(214),ex4(:),G1H1(9),ngZu,m3h3x1(:,320),heltab2x3(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),8,nMT,G2tensor(319),n2h1(220))
  call Hloop_QZ_A(ntryL,G1H3(217),ex4(:),G1H1(11),ngZu,m3h3x1(:,321),heltab2x3(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),31,nMT,G2tensor(320),n2h1(221))
  call Hloop_AZ_Q(ntryL,G1H3(127),ex4(:),G1H1(13),ngZu,m3h3x1(:,322),heltab2x3(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(321),n2h1(222))
  call Hloop_AZ_Q(ntryL,G1H3(218),ex4(:),G1H1(56),ngZu,m3h3x1(:,323),heltab2x3(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),8,nMT,G2tensor(322),n2h1(223))
  call Hloop_AZ_Q(ntryL,G1H3(221),ex4(:),G1H1(41),ngZu,m3h3x1(:,324),heltab2x3(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMT,G2tensor(323),n2h1(224))
  call Hloop_QZ_A(ntryL,G1H3(129),ex4(:),G1H1(59),ngZd,m3h3x1(:,325),heltab2x3(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),31,nMB,G2tensor(324),n2h1(225))
  call Hloop_QZ_A(ntryL,G1H3(222),ex4(:),G1H1(21),ngZd,m3h3x1(:,326),heltab2x3(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),8,nMB,G2tensor(325),n2h1(226))
  call Hloop_QZ_A(ntryL,G1H3(225),ex4(:),G1H1(16),ngZd,m3h3x1(:,327),heltab2x3(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),31,nMB,G2tensor(326),n2h1(227))
  call Hloop_AZ_Q(ntryL,G1H3(70),ex4(:),G1H1(35),ngZd,m3h3x1(:,328),heltab2x3(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),31,nMB,G2tensor(327),n2h1(228))
  call Hloop_AZ_Q(ntryL,G1H3(226),ex4(:),G1H1(60),ngZd,m3h3x1(:,329),heltab2x3(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(60),8,nMB,G2tensor(328),n2h1(229))
  call Hloop_AZ_Q(ntryL,G1H3(229),ex4(:),G1H1(23),ngZd,m3h3x1(:,330),heltab2x3(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(329),n2h1(230))
  call ol_merge_tensors(G2tensor(2),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(23),G2tensor(4),G1tensor(50)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(35),G2tensor(8),G1tensor(62)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(10),G1tensor(68)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(12),G1tensor(74)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(135),G2tensor(41),G2tensor(38),G2tensor(32),G2tensor(29),G2tensor(16),G2tensor(14) &
    ,G1tensor(45),G1tensor(27),G1tensor(20),G1tensor(14)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(133),G2tensor(56),G2tensor(53),G2tensor(50),G2tensor(47),G2tensor(20),G2tensor(18) &
    ,G1tensor(33),G1tensor(15),G1tensor(38),G1tensor(32)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(22),G1tensor(46)])
  call ol_merge_tensors(G2tensor(270),[G2tensor(25),G1tensor(51),G1tensor(2)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(26),G1tensor(39),G1tensor(21),G1tensor(8)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(31),G2tensor(28),G1tensor(1),G1tensor(10)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(34),G1tensor(58)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(118),G2tensor(40),G2tensor(37),G1tensor(59),G1tensor(16)])
  call ol_merge_tensors(G2tensor(273),[G2tensor(43),G1tensor(57),G1tensor(22)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(44),G1tensor(7),G1tensor(3),G1tensor(26)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(49),G2tensor(46),G1tensor(9),G1tensor(28)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(116),G2tensor(55),G2tensor(52),G1tensor(47),G1tensor(34)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(59),G1tensor(80)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(62),G1tensor(86)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(64),G1tensor(64)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(68),G1tensor(92)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(74),G2tensor(71),G1tensor(104),G1tensor(98)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(24),G2tensor(9),G2tensor(73),G1tensor(100),G1tensor(11)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(76),G1tensor(70)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(54),G2tensor(42),G2tensor(79),G1tensor(106),G1tensor(17)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(24),G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(207),G2tensor(201),G2tensor(198),G2tensor(186),G2tensor(183),G2tensor(124) &
    ,G2tensor(123),G1tensor(30),G1tensor(12)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(11),G2tensor(45),G1tensor(13)])
  call ol_merge_tensors(G2tensor(195),[G2tensor(192),G2tensor(149),G2tensor(147),G2tensor(122),G2tensor(121),G1tensor(36) &
    ,G1tensor(18)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(48),G2tensor(36),G1tensor(67),G1tensor(19)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(25)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(75),G2tensor(33),G1tensor(29)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(63),G2tensor(17),G1tensor(31)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(69),G2tensor(60),G1tensor(35)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(66),G2tensor(15),G1tensor(73),G1tensor(37)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(55),G1tensor(43)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(51),G1tensor(48)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(219),G2tensor(216),G2tensor(213),G2tensor(189),G2tensor(180),G2tensor(125) &
    ,G2tensor(13),G1tensor(61),G1tensor(49)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(105),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(39),G1tensor(60)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(86),G1tensor(65)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(87),G1tensor(66)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(96),G1tensor(71)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(97),G1tensor(72)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(79)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(85)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(91)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(96)])
  call ol_merge_tensors(G2tensor(93),[G1tensor(97)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(101)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(204),[G1tensor(109),G1tensor(103)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(140)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(142)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(144)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(151)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(153)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(155)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(158)])
  call ol_merge_tensors(G2tensor(161),[G2tensor(160)])
  call ol_merge_tensors(G2tensor(163),[G2tensor(162)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(276)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(282)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(288)])
  call ol_merge_tensors(G2tensor(297),[G2tensor(294)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(300)])
  call ol_merge_tensors(G2tensor(309),[G2tensor(306)])
  call ol_merge_tensors(G2tensor(315),[G2tensor(312)])
  call ol_merge_tensors(G2tensor(321),[G2tensor(318)])
  call ol_merge_tensors(G2tensor(327),[G2tensor(324)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(20),mass4set(:,12),  & 
G1tensor(63),G1tensor(69),G1tensor(75),G1tensor(81),G1tensor(87))
  call G_TensorShift(G1tensor(69),10)
  call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(20),mass4set(:,13),  & 
G1tensor(93),G1tensor(99),G1tensor(105),G1tensor(44),G1tensor(50))
  call G_TensorShift(G1tensor(99),10)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(24),mass4set(:,12),  & 
G1tensor(56),G1tensor(62),G1tensor(68),G1tensor(74),G1tensor(45))
  call G_TensorShift(G1tensor(62),9)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(24),mass4set(:,13),  & 
G1tensor(27),G1tensor(20),G1tensor(14),G1tensor(33),G1tensor(15))
  call G_TensorShift(G1tensor(20),9)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(28),mass4set(:,1),  & 
G1tensor(38),G1tensor(32),G1tensor(46),G1tensor(51),G1tensor(2))
  call G_TensorShift(G1tensor(32),5)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(32),mass4set(:,1),  & 
G1tensor(39),G1tensor(21),G1tensor(8),G1tensor(1),G1tensor(10))
  call G_TensorShift(G1tensor(21),6)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(4),mass4set(:,6),  & 
G1tensor(58),G1tensor(59),G1tensor(16),G1tensor(57),G1tensor(22))
  call G_TensorShift(G1tensor(59),12)
  call Hotf_4pt_reduction_last(G2tensor(234),RedSet_4(12),mass4set(:,6),  & 
G1tensor(7),G1tensor(3),G1tensor(26),G1tensor(9),G1tensor(28))
  call G_TensorShift(G1tensor(3),12)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(50),mass4set(:,13),  & 
G1tensor(47),G1tensor(34),G1tensor(76),G1tensor(80),G1tensor(82))
  call G_TensorShift(G1tensor(34),2)
  call Hotf_4pt_reduction_last(G2tensor(270),RedSet_4(48),mass4set(:,11),  & 
G1tensor(86),G1tensor(64),G1tensor(88),G1tensor(92),G1tensor(94))
  call G_TensorShift(G1tensor(64),4)
  call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(4),mass4set(:,14),  & 
G1tensor(104),G1tensor(98),G1tensor(100),G1tensor(11),G1tensor(70))
  call G_TensorShift(G1tensor(98),12)
  call Hotf_4pt_reduction_last(G2tensor(168),RedSet_4(48),mass4set(:,6),  & 
G1tensor(106),G1tensor(17),G1tensor(110),G1tensor(4),G1tensor(24))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(51),mass4set(:,13),  & 
G1tensor(5),G1tensor(6),G1tensor(30),G1tensor(12),G1tensor(13))
  call G_TensorShift(G1tensor(6),1)
  call Hotf_4pt_reduction_last(G2tensor(171),RedSet_4(22),mass4set(:,6),  & 
G1tensor(36),G1tensor(18),G1tensor(67),G1tensor(19),G1tensor(23))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_4pt_reduction_last(G2tensor(273),RedSet_4(49),mass4set(:,11),  & 
G1tensor(25),G1tensor(29),G1tensor(31),G1tensor(35),G1tensor(73))
  call G_TensorShift(G1tensor(29),4)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(12),mass4set(:,14),  & 
G1tensor(37),G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(55))
  call G_TensorShift(G1tensor(40),12)
  call Hotf_4pt_reduction_last(G2tensor(174),RedSet_4(49),mass4set(:,6),  & 
G1tensor(43),G1tensor(48),G1tensor(61),G1tensor(49),G1tensor(52))
  call G_TensorShift(G1tensor(48),4)
  call Hotf_4pt_reduction_last(G2tensor(177),RedSet_4(17),mass4set(:,6),  & 
G1tensor(53),G1tensor(54),G1tensor(60),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(54),8)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(52),mass4set(:,15),  & 
G1tensor(71),G1tensor(72),G1tensor(77),G1tensor(78),G1tensor(79))
  call G_TensorShift(G1tensor(72),1)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(35),mass4set(:,15),  & 
G1tensor(83),G1tensor(84),G1tensor(85),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(84),9)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(52),mass4set(:,7),  & 
G1tensor(91),G1tensor(95),G1tensor(96),G1tensor(97),G1tensor(101))
  call G_TensorShift(G1tensor(95),1)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(35),mass4set(:,7),  & 
G1tensor(102),G1tensor(109),G1tensor(103),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(109),9)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(53),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),1)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(54),mass4set(:,15),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),2)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(38),mass4set(:,15),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),10)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(54),mass4set(:,7),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(38),mass4set(:,7),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),10)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(1),mass4set(:,16),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(47),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),2)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(6),mass4set(:,16),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),4)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(32),mass4set(:,7),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),6)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(1),mass4set(:,17),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,18),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(3),mass4set(:,14),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),8)
  call Hotf_4pt_reduction_last(G2tensor(210),RedSet_4(2),mass4set(:,2),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),8)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(3),mass4set(:,6),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),8)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(7),mass4set(:,2),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(8),mass4set(:,6),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(10),mass4set(:,17),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(11),mass4set(:,14),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(10),mass4set(:,16),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(11),mass4set(:,6),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),8)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(14),mass4set(:,16),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(15),mass4set(:,6),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),4)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(50),mass4set(:,19),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),2)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(17),mass4set(:,14),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),8)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(18),mass4set(:,14),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),8)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(19),mass4set(:,18),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),8)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(18),mass4set(:,6),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(19),mass4set(:,2),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(51),mass4set(:,19),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),1)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(22),mass4set(:,14),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(23),mass4set(:,14),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),8)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(23),mass4set(:,6),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),8)
  call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(26),mass4set(:,20),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(27),mass4set(:,6),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),4)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(30),mass4set(:,20),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),4)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(31),mass4set(:,6),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),4)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(34),mass4set(:,21),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(23),mass4set(:,9),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),8)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(3),mass4set(:,9),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(34),mass4set(:,22),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),8)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(23),mass4set(:,10),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),8)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(3),mass4set(:,10),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(37),mass4set(:,21),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),8)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(18),mass4set(:,9),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),8)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(11),mass4set(:,9),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(37),mass4set(:,22),  & 
G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340))
  call G_TensorShift(G1tensor(337),8)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(18),mass4set(:,10),  & 
G1tensor(341),G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(342),8)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(11),mass4set(:,10),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),8)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(40),mass4set(:,23),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),2)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(41),mass4set(:,7),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),2)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(42),mass4set(:,7),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),2)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(44),mass4set(:,23),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),2)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(45),mass4set(:,7),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),2)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(7),mass4set(:,3),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380),G0tensor(1))
  call G_TensorShift(G1tensor(377),4)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(7),mass4set(:,4),  & 
G1tensor(376),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G0tensor(2))
  call G_TensorShift(G1tensor(381),4)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(7),mass4set(:,5),  & 
G1tensor(376),G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G0tensor(3))
  call G_TensorShift(G1tensor(385),4)
  call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(2),mass4set(:,3),  & 
G1tensor(376),G1tensor(389),G1tensor(390),G1tensor(391),G1tensor(392),G0tensor(4))
  call G_TensorShift(G1tensor(389),8)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(2),mass4set(:,4),  & 
G1tensor(376),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396),G0tensor(5))
  call G_TensorShift(G1tensor(393),8)
  call Hotf_4pt_reduction_last(G2tensor(156),RedSet_4(2),mass4set(:,5),  & 
G1tensor(376),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G0tensor(6))
  call G_TensorShift(G1tensor(397),8)
  call Hotf_4pt_reduction_last(G2tensor(159),RedSet_4(19),mass4set(:,3),  & 
G1tensor(376),G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G0tensor(7))
  call G_TensorShift(G1tensor(401),8)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(19),mass4set(:,4),  & 
G1tensor(376),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408),G0tensor(8))
  call G_TensorShift(G1tensor(405),8)
  call Hotf_4pt_reduction_last(G2tensor(163),RedSet_4(19),mass4set(:,5),  & 
G1tensor(376),G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G0tensor(9))
  call G_TensorShift(G1tensor(409),8)
  call Hotf_4pt_reduction_last(G2tensor(166),RedSet_4(42),mass4set(:,1),  & 
G1tensor(376),G1tensor(413),G1tensor(414),G1tensor(415),G1tensor(416))
  call G_TensorShift(G1tensor(413),2)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(12),mass4set(:,8),  & 
G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420),G1tensor(421))
  call G_TensorShift(G1tensor(418),12)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(12),mass4set(:,9),  & 
G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(423),12)
  call Hotf_4pt_reduction_last(G2tensor(231),RedSet_4(12),mass4set(:,10),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431))
  call G_TensorShift(G1tensor(428),12)
  call Hotf_4pt_reduction_last(G2tensor(237),RedSet_4(4),mass4set(:,8),  & 
G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436))
  call G_TensorShift(G1tensor(433),12)
  call Hotf_4pt_reduction_last(G2tensor(240),RedSet_4(4),mass4set(:,9),  & 
G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440),G1tensor(441))
  call G_TensorShift(G1tensor(438),12)
  call Hotf_4pt_reduction_last(G2tensor(243),RedSet_4(4),mass4set(:,10),  & 
G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445),G1tensor(446))
  call G_TensorShift(G1tensor(443),12)
  call Hotf_4pt_reduction_last(G2tensor(249),RedSet_4(22),mass4set(:,8),  & 
G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450),G1tensor(451))
  call G_TensorShift(G1tensor(448),8)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(22),mass4set(:,9),  & 
G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(453),8)
  call Hotf_4pt_reduction_last(G2tensor(255),RedSet_4(22),mass4set(:,10),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461))
  call G_TensorShift(G1tensor(458),8)
  call Hotf_4pt_reduction_last(G2tensor(258),RedSet_4(17),mass4set(:,8),  & 
G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466))
  call G_TensorShift(G1tensor(463),8)
  call Hotf_4pt_reduction_last(G2tensor(261),RedSet_4(17),mass4set(:,9),  & 
G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470),G1tensor(471))
  call G_TensorShift(G1tensor(468),8)
  call Hotf_4pt_reduction_last(G2tensor(264),RedSet_4(17),mass4set(:,10),  & 
G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475),G1tensor(476))
  call G_TensorShift(G1tensor(473),8)
  call Hotf_4pt_reduction_last(G2tensor(267),RedSet_4(47),mass4set(:,7),  & 
G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480),G1tensor(481))
  call G_TensorShift(G1tensor(478),2)
  call Hotf_4pt_reduction_last(G2tensor(279),RedSet_4(7),mass4set(:,3),  & 
G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(483),4)
  call Hotf_4pt_reduction_last(G2tensor(285),RedSet_4(7),mass4set(:,4),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491))
  call G_TensorShift(G1tensor(488),4)
  call Hotf_4pt_reduction_last(G2tensor(291),RedSet_4(7),mass4set(:,5),  & 
G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496))
  call G_TensorShift(G1tensor(493),4)
  call Hotf_4pt_reduction_last(G2tensor(297),RedSet_4(2),mass4set(:,3),  & 
G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500),G1tensor(501))
  call G_TensorShift(G1tensor(498),8)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(2),mass4set(:,4),  & 
G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505),G1tensor(506))
  call G_TensorShift(G1tensor(503),8)
  call Hotf_4pt_reduction_last(G2tensor(309),RedSet_4(2),mass4set(:,5),  & 
G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510),G1tensor(511))
  call G_TensorShift(G1tensor(508),8)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(19),mass4set(:,3),  & 
G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(513),8)
  call Hotf_4pt_reduction_last(G2tensor(321),RedSet_4(19),mass4set(:,4),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521))
  call G_TensorShift(G1tensor(518),8)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(19),mass4set(:,5),  & 
G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526))
  call G_TensorShift(G1tensor(523),8)
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(20),mass4set(:,12),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(20),mass4set(:,13),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(24),mass4set(:,12),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(24),mass4set(:,13),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(28),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(32),mass4set(:,1),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(4),mass4set(:,6),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(7),RedSet_4(12),mass4set(:,6),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(50),mass4set(:,13),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(48),mass4set(:,11),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(4),mass4set(:,14),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(48),mass4set(:,6),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(51),mass4set(:,13),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(22),mass4set(:,6),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(49),mass4set(:,11),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(37),RedSet_4(12),mass4set(:,14),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(43),RedSet_4(49),mass4set(:,6),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(17),mass4set(:,6),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(52),mass4set(:,15),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(35),mass4set(:,15),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(52),mass4set(:,7),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(102),RedSet_4(35),mass4set(:,7),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(53),mass4set(:,1),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(54),mass4set(:,15),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(38),mass4set(:,15),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(54),mass4set(:,7),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(38),mass4set(:,7),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(1),mass4set(:,16),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(47),mass4set(:,1),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(6),mass4set(:,16),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(32),mass4set(:,7),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(1),mass4set(:,17),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(2),mass4set(:,18),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(3),mass4set(:,14),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(2),mass4set(:,2),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(3),mass4set(:,6),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(7),mass4set(:,2),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(8),mass4set(:,6),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(10),mass4set(:,17),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(11),mass4set(:,14),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(10),mass4set(:,16),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(11),mass4set(:,6),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(14),mass4set(:,16),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(15),mass4set(:,6),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(50),mass4set(:,19),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(17),mass4set(:,14),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(18),mass4set(:,14),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(19),mass4set(:,18),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(18),mass4set(:,6),  & 
G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(19),mass4set(:,2),  & 
G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(51),mass4set(:,19),  & 
G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(22),mass4set(:,14),  & 
G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(23),mass4set(:,14),  & 
G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(23),mass4set(:,6),  & 
G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(26),mass4set(:,20),  & 
G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(27),mass4set(:,6),  & 
G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(30),mass4set(:,20),  & 
G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(31),mass4set(:,6),  & 
G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(34),mass4set(:,21),  & 
G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(23),mass4set(:,9),  & 
G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(3),mass4set(:,9),  & 
G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(34),mass4set(:,22),  & 
G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(23),mass4set(:,10),  & 
G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(3),mass4set(:,10),  & 
G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(37),mass4set(:,21),  & 
G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(18),mass4set(:,9),  & 
G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(11),mass4set(:,9),  & 
G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(37),mass4set(:,22),  & 
G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(18),mass4set(:,10),  & 
G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(11),mass4set(:,10),  & 
G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(40),mass4set(:,23),  & 
G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(41),mass4set(:,7),  & 
G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(42),mass4set(:,7),  & 
G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(44),mass4set(:,23),  & 
G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(45),mass4set(:,7),  & 
G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(42),mass4set(:,1),  & 
G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389))
  call Hotf_4pt_reduction_last(G1tensor(417),RedSet_4(12),mass4set(:,8),  & 
G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394))
  call Hotf_4pt_reduction_last(G1tensor(422),RedSet_4(12),mass4set(:,9),  & 
G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399))
  call Hotf_4pt_reduction_last(G1tensor(427),RedSet_4(12),mass4set(:,10),  & 
G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404))
  call Hotf_4pt_reduction_last(G1tensor(432),RedSet_4(4),mass4set(:,8),  & 
G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409))
  call Hotf_4pt_reduction_last(G1tensor(437),RedSet_4(4),mass4set(:,9),  & 
G0tensor(410),G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414))
  call Hotf_4pt_reduction_last(G1tensor(442),RedSet_4(4),mass4set(:,10),  & 
G0tensor(415),G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419))
  call Hotf_4pt_reduction_last(G1tensor(447),RedSet_4(22),mass4set(:,8),  & 
G0tensor(420),G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424))
  call Hotf_4pt_reduction_last(G1tensor(452),RedSet_4(22),mass4set(:,9),  & 
G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429))
  call Hotf_4pt_reduction_last(G1tensor(457),RedSet_4(22),mass4set(:,10),  & 
G0tensor(430),G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434))
  call Hotf_4pt_reduction_last(G1tensor(462),RedSet_4(17),mass4set(:,8),  & 
G0tensor(435),G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439))
  call Hotf_4pt_reduction_last(G1tensor(467),RedSet_4(17),mass4set(:,9),  & 
G0tensor(440),G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444))
  call Hotf_4pt_reduction_last(G1tensor(472),RedSet_4(17),mass4set(:,10),  & 
G0tensor(445),G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449))
  call Hotf_4pt_reduction_last(G1tensor(477),RedSet_4(47),mass4set(:,7),  & 
G0tensor(450),G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454))
  call Hotf_4pt_reduction_last(G1tensor(482),RedSet_4(7),mass4set(:,3),  & 
G0tensor(455),G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459))
  call Hotf_4pt_reduction_last(G1tensor(487),RedSet_4(7),mass4set(:,4),  & 
G0tensor(460),G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464))
  call Hotf_4pt_reduction_last(G1tensor(492),RedSet_4(7),mass4set(:,5),  & 
G0tensor(465),G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469))
  call Hotf_4pt_reduction_last(G1tensor(497),RedSet_4(2),mass4set(:,3),  & 
G0tensor(470),G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474))
  call Hotf_4pt_reduction_last(G1tensor(502),RedSet_4(2),mass4set(:,4),  & 
G0tensor(475),G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479))
  call Hotf_4pt_reduction_last(G1tensor(507),RedSet_4(2),mass4set(:,5),  & 
G0tensor(480),G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484))
  call Hotf_4pt_reduction_last(G1tensor(512),RedSet_4(19),mass4set(:,3),  & 
G0tensor(485),G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489))
  call Hotf_4pt_reduction_last(G1tensor(517),RedSet_4(19),mass4set(:,4),  & 
G0tensor(490),G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494))
  call Hotf_4pt_reduction_last(G1tensor(522),RedSet_4(19),mass4set(:,5),  & 
G0tensor(495),G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])
  call ol_merge_tensors(T0sum(45),[G0tensor(230)])
  call ol_merge_tensors(T0sum(46),[G0tensor(235)])
  call ol_merge_tensors(T0sum(47),[G0tensor(240)])
  call ol_merge_tensors(T0sum(48),[G0tensor(245)])
  call ol_merge_tensors(T0sum(49),[G0tensor(250)])
  call ol_merge_tensors(T0sum(50),[G0tensor(255)])
  call ol_merge_tensors(T0sum(51),[G0tensor(260)])
  call ol_merge_tensors(T0sum(52),[G0tensor(265)])
  call ol_merge_tensors(T0sum(53),[G0tensor(270)])
  call ol_merge_tensors(T0sum(54),[G0tensor(275)])
  call ol_merge_tensors(T0sum(55),[G0tensor(280)])
  call ol_merge_tensors(T0sum(56),[G0tensor(285)])
  call ol_merge_tensors(T0sum(57),[G0tensor(290)])
  call ol_merge_tensors(T0sum(58),[G0tensor(295)])
  call ol_merge_tensors(T0sum(59),[G0tensor(300)])
  call ol_merge_tensors(T0sum(60),[G0tensor(305)])
  call ol_merge_tensors(T0sum(61),[G0tensor(310)])
  call ol_merge_tensors(T0sum(62),[G0tensor(315)])
  call ol_merge_tensors(T0sum(63),[G0tensor(320)])
  call ol_merge_tensors(T0sum(64),[G0tensor(325)])
  call ol_merge_tensors(T0sum(65),[G0tensor(330)])
  call ol_merge_tensors(T0sum(66),[G0tensor(335)])
  call ol_merge_tensors(T0sum(67),[G0tensor(340)])
  call ol_merge_tensors(T0sum(68),[G0tensor(345)])
  call ol_merge_tensors(T0sum(69),[G0tensor(350)])
  call ol_merge_tensors(T0sum(70),[G0tensor(355)])
  call ol_merge_tensors(T0sum(71),[G0tensor(360)])
  call ol_merge_tensors(T0sum(72),[G0tensor(365)])
  call ol_merge_tensors(T0sum(73),[G0tensor(370)])
  call ol_merge_tensors(T0sum(74),[G0tensor(375)])
  call ol_merge_tensors(T0sum(75),[G0tensor(380)])
  call ol_merge_tensors(T0sum(76),[G0tensor(1)])
  call ol_merge_tensors(T0sum(77),[G0tensor(2)])
  call ol_merge_tensors(T0sum(78),[G0tensor(3)])
  call ol_merge_tensors(T0sum(79),[G0tensor(4)])
  call ol_merge_tensors(T0sum(80),[G0tensor(5)])
  call ol_merge_tensors(T0sum(81),[G0tensor(6)])
  call ol_merge_tensors(T0sum(82),[G0tensor(7)])
  call ol_merge_tensors(T0sum(83),[G0tensor(8)])
  call ol_merge_tensors(T0sum(84),[G0tensor(9)])
  call ol_merge_tensors(T0sum(85),[G0tensor(385)])
  call ol_merge_tensors(T0sum(86),[G0tensor(390)])
  call ol_merge_tensors(T0sum(87),[G0tensor(395)])
  call ol_merge_tensors(T0sum(88),[G0tensor(400)])
  call ol_merge_tensors(T0sum(89),[G0tensor(405)])
  call ol_merge_tensors(T0sum(90),[G0tensor(410)])
  call ol_merge_tensors(T0sum(91),[G0tensor(415)])
  call ol_merge_tensors(T0sum(92),[G0tensor(420)])
  call ol_merge_tensors(T0sum(93),[G0tensor(425)])
  call ol_merge_tensors(T0sum(94),[G0tensor(430)])
  call ol_merge_tensors(T0sum(95),[G0tensor(435)])
  call ol_merge_tensors(T0sum(96),[G0tensor(440)])
  call ol_merge_tensors(T0sum(97),[G0tensor(445)])
  call ol_merge_tensors(T0sum(98),[G0tensor(450)])
  call ol_merge_tensors(T0sum(99),[G0tensor(455)])
  call ol_merge_tensors(T0sum(100),[G0tensor(460)])
  call ol_merge_tensors(T0sum(101),[G0tensor(465)])
  call ol_merge_tensors(T0sum(102),[G0tensor(470)])
  call ol_merge_tensors(T0sum(103),[G0tensor(475)])
  call ol_merge_tensors(T0sum(104),[G0tensor(480)])
  call ol_merge_tensors(T0sum(105),[G0tensor(485)])
  call ol_merge_tensors(T0sum(106),[G0tensor(490)])
  call ol_merge_tensors(T0sum(107),[G0tensor(495)])
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(381),h0tab(:,381),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(3),m4h3x4x3(:,1),heltab3x36(:,:,7))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(382),h0tab(:,382),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(16),m4h3x4x3(:,2),heltab3x36(:,:,8))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(383),h0tab(:,383),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(1),m4h3x4x3(:,3),heltab3x36(:,:,9))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(384),h0tab(:,384),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(14),m4h3x4x3(:,4),heltab3x36(:,:,10))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(385),h0tab(:,385),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(4),m4h3x4x3(:,5),heltab3x36(:,:,11))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(386),h0tab(:,386),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(23),m4h3x4x3(:,6),heltab3x36(:,:,12))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(387),h0tab(:,387),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(2),m4h3x4x3(:,7),heltab3x36(:,:,13))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(388),h0tab(:,388),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(21),m4h3x4x3(:,8),heltab3x36(:,:,14))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(389),h0tab(:,389),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(8),m4h3x4x3(:,9),heltab3x36(:,:,15))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(390),h0tab(:,390),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(24),m4h3x4x3(:,10),heltab3x36(:,:,16))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(391),h0tab(:,391),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(7),m4h3x4x3(:,11),heltab3x36(:,:,17))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(392),h0tab(:,392),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(22),m4h3x4x3(:,12),heltab3x36(:,:,18))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(393),h0tab(:,393),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(20),m4h3x4x3(:,13),heltab3x36(:,:,19))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(394),h0tab(:,394),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(19),m4h3x4x3(:,14),heltab3x36(:,:,20))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(395),h0tab(:,395),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(6),m4h3x4x3(:,15),heltab3x36(:,:,21))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(396),h0tab(:,396),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(5),m4h3x4x3(:,16),heltab3x36(:,:,22))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(397),h0tab(:,397),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(119),m3h3x12(:,355),heltab2x36(:,:,375))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(398),h0tab(:,398),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(53),m3h3x12(:,356),heltab2x36(:,:,376))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(399),h0tab(:,399),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(120),m3h3x12(:,357),heltab2x36(:,:,377))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(400),h0tab(:,400),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(55),m3h3x12(:,358),heltab2x36(:,:,378))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(401),h0tab(:,401),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(121),m3h3x12(:,359),heltab2x36(:,:,379))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(402),h0tab(:,402),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(122),m3h3x12(:,360),heltab2x36(:,:,380))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(403),h0tab(:,403),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(123),m3h3x12(:,361),heltab2x36(:,:,381))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(404),h0tab(:,404),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(124),m3h3x12(:,362),heltab2x36(:,:,382))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(405),h0tab(:,405),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,363),heltab2x36(:,:,383))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(406),h0tab(:,406),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,364),heltab2x36(:,:,384))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(407),h0tab(:,407),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,365),heltab2x36(:,:,385))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(408),h0tab(:,408),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,366),heltab2x36(:,:,386))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(409),h0tab(:,409),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,367),heltab2x36(:,:,387))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(410),h0tab(:,410),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,368),heltab2x36(:,:,388))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(411),h0tab(:,411),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,369),heltab2x36(:,:,389))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(412),h0tab(:,412),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,370),heltab2x36(:,:,390))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(413),h0tab(:,413),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(1),m4h3x3x4(:,3),heltab3x36(:,:,23))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(414),h0tab(:,414),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(2),m4h3x3x4(:,4),heltab3x36(:,:,24))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(415),h0tab(:,415),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(4),m4h3x3x4(:,5),heltab3x36(:,:,25))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(416),h0tab(:,416),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(6),m4h3x3x4(:,6),heltab3x36(:,:,26))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(417),h0tab(:,417),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(3),m4h3x3x4(:,7),heltab3x36(:,:,27))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(418),h0tab(:,418),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(5),m4h3x3x4(:,8),heltab3x36(:,:,28))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(419),h0tab(:,419),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(7),m4h3x3x4(:,9),heltab3x36(:,:,29))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(420),h0tab(:,420),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(8),m4h3x3x4(:,10),heltab3x36(:,:,30))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(421),h0tab(:,421),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(9),m4h3x3x4(:,11),heltab3x36(:,:,31))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(422),h0tab(:,422),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(10),m4h3x3x4(:,12),heltab3x36(:,:,32))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(423),h0tab(:,423),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(11),m4h3x3x4(:,13),heltab3x36(:,:,33))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(424),h0tab(:,424),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(12),m4h3x3x4(:,14),heltab3x36(:,:,34))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(425),h0tab(:,425),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(13),m4h3x3x4(:,15),heltab3x36(:,:,35))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(426),h0tab(:,426),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(14),m4h3x3x4(:,16),heltab3x36(:,:,36))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(427),h0tab(:,427),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(15),m4h3x3x4(:,17),heltab3x36(:,:,37))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(428),h0tab(:,428),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(16),m4h3x3x4(:,18),heltab3x36(:,:,38))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(429),h0tab(:,429),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,371),heltab2x36(:,:,391))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(430),h0tab(:,430),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,372),heltab2x36(:,:,392))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(431),h0tab(:,431),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,373),heltab2x36(:,:,393))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(432),h0tab(:,432),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,374),heltab2x36(:,:,394))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(433),h0tab(:,433),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(127),m3h3x12(:,375),heltab2x36(:,:,395))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(434),h0tab(:,434),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(128),m3h3x12(:,376),heltab2x36(:,:,396))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(435),h0tab(:,435),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(131),m3h3x12(:,377),heltab2x36(:,:,397))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(436),h0tab(:,436),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(132),m3h3x12(:,378),heltab2x36(:,:,398))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(437),h0tab(:,437),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(133),m3h3x12(:,379),heltab2x36(:,:,399))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(438),h0tab(:,438),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(134),m3h3x12(:,380),heltab2x36(:,:,400))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(439),h0tab(:,439),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(135),m3h3x12(:,381),heltab2x36(:,:,401))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(440),h0tab(:,440),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(136),m3h3x12(:,382),heltab2x36(:,:,402))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(441),h0tab(:,441),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,383),heltab2x36(:,:,403))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(442),h0tab(:,442),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,384),heltab2x36(:,:,404))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(443),h0tab(:,443),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,385),heltab2x36(:,:,405))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(444),h0tab(:,444),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,386),heltab2x36(:,:,406))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(445),h0tab(:,445),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(32),m4h1x3x12(:,5),heltab3x36(:,:,39))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(446),h0tab(:,446),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(33),m4h1x3x12(:,6),heltab3x36(:,:,40))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(447),h0tab(:,447),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(34),m4h1x3x12(:,7),heltab3x36(:,:,41))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(448),h0tab(:,448),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(35),m4h1x3x12(:,8),heltab3x36(:,:,42))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(449),h0tab(:,449),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(36),m4h3x1x12(:,1),heltab3x36(:,:,43))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(450),h0tab(:,450),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(37),m4h3x1x12(:,2),heltab3x36(:,:,44))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(451),h0tab(:,451),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(38),m4h3x1x12(:,3),heltab3x36(:,:,45))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(452),h0tab(:,452),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(39),m4h3x1x12(:,4),heltab3x36(:,:,46))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(453),h0tab(:,453),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(40),m4h1x3x12(:,9),heltab3x36(:,:,47))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(454),h0tab(:,454),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(41),m4h1x3x12(:,10),heltab3x36(:,:,48))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(455),h0tab(:,455),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(42),m4h1x3x12(:,11),heltab3x36(:,:,49))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(456),h0tab(:,456),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SSV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H12(43),m4h1x3x12(:,12),heltab3x36(:,:,50))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(457),h0tab(:,457),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(44),m4h3x1x12(:,5),heltab3x36(:,:,51))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(458),h0tab(:,458),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(45),m4h3x1x12(:,6),heltab3x36(:,:,52))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(459),h0tab(:,459),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(46),m4h3x1x12(:,7),heltab3x36(:,:,53))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(460),h0tab(:,460),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(47),m4h3x1x12(:,8),heltab3x36(:,:,54))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(461),h0tab(:,461),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(138),m3h3x12(:,387),heltab2x36(:,:,407))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(462),h0tab(:,462),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(140),m3h3x12(:,388),heltab2x36(:,:,408))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(463),h0tab(:,463),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(141),m3h3x12(:,389),heltab2x36(:,:,409))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(464),h0tab(:,464),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(142),m3h3x12(:,390),heltab2x36(:,:,410))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(465),h0tab(:,465),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(48),m3h3x12(:,391),heltab2x36(:,:,411))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(466),h0tab(:,466),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,392),heltab2x36(:,:,412))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(467),h0tab(:,467),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(50),m3h3x12(:,393),heltab2x36(:,:,413))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(468),h0tab(:,468),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(51),m3h3x12(:,394),heltab2x36(:,:,414))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(469),h0tab(:,469),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(52),m3h3x12(:,395),heltab2x36(:,:,415))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(470),h0tab(:,470),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(54),m3h3x12(:,396),heltab2x36(:,:,416))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(471),h0tab(:,471),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(56),m3h3x12(:,397),heltab2x36(:,:,417))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(472),h0tab(:,472),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(58),m3h3x12(:,398),heltab2x36(:,:,418))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(473),h0tab(:,473),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(143),m3h3x12(:,399),heltab2x36(:,:,419))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(474),h0tab(:,474),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(144),m3h3x12(:,400),heltab2x36(:,:,420))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(475),h0tab(:,475),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(145),m3h3x12(:,401),heltab2x36(:,:,421))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(476),h0tab(:,476),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(146),m3h3x12(:,402),heltab2x36(:,:,422))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(477),h0tab(:,477),[28,1,2],[nMW,0,nMW],4,1,wf3(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf3(:,2),G0H4(17),m4h3x3x4(:,19),heltab3x36(:,:,55))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(478),h0tab(:,478),[28,1,2],[nMW,0,nMW],4,1,wf3(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf3(:,1),G0H4(18),m4h3x3x4(:,20),heltab3x36(:,:,56))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(479),h0tab(:,479),[28,1,2],[nMZ,0,nMZ],4,1,wf9(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(19),m4h1x9x4(:,1),heltab3x36(:,:,57))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(480),h0tab(:,480),[28,1,2],[nMW,0,nMW],4,1,wf9(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(20),m4h1x9x4(:,2),heltab3x36(:,:,58))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(481),h0tab(:,481),[28,1,2],[nMZ,0,nMZ],3,1,wf9(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,2),G0H4(21),m3h9x4(:,9),heltab2x36(:,:,423))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(482),h0tab(:,482),[28,1,2],[nMW,0,nMW],3,1,wf9(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,2),G0H4(22),m3h9x4(:,10),heltab2x36(:,:,424))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(483),h0tab(:,483),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf3(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(60),ngZl,m3h3x12(:,403),heltab2x36(:,:,425))
  call Hloop_A_Q(ntryL,G0H12(60),16,nML,G1H12(147),n2h12(103))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(484),h0tab(:,484),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(61),ngZl,m3h3x12(:,404),heltab2x36(:,:,426))
  call Hloop_Q_A(ntryL,G0H12(61),16,nML,G1H12(148),n2h12(104))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(485),h0tab(:,485),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf3(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(62),ngZu,m3h3x12(:,405),heltab2x36(:,:,427))
  call Hloop_A_Q(ntryL,G0H12(62),16,nMT,G1H12(149),n2h12(105))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(486),h0tab(:,486),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(63),ngZu,m3h3x12(:,406),heltab2x36(:,:,428))
  call Hloop_Q_A(ntryL,G0H12(63),16,nMT,G1H12(150),n2h12(106))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(487),h0tab(:,487),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf3(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(64),ngZd,m3h3x12(:,407),heltab2x36(:,:,429))
  call Hloop_A_Q(ntryL,G0H12(64),16,nMB,G1H12(151),n2h12(107))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(488),h0tab(:,488),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(65),ngZd,m3h3x12(:,408),heltab2x36(:,:,430))
  call Hloop_Q_A(ntryL,G0H12(65),16,nMB,G1H12(152),n2h12(108))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(489),h0tab(:,489),[16,3,12],[nML,nML,nML],3,2,wf4(:,2),wf3(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(66),ngZl,m3h3x12(:,409),heltab2x36(:,:,431))
  call Hloop_A_Q(ntryL,G0H12(66),16,nML,G1H12(153),n2h12(109))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(490),h0tab(:,490),[16,3,12],[nML,nML,nML],3,2,wf4(:,2),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(67),ngZl,m3h3x12(:,410),heltab2x36(:,:,432))
  call Hloop_Q_A(ntryL,G0H12(67),16,nML,G1H12(154),n2h12(110))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(491),h0tab(:,491),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,2),wf3(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(68),ngZu,m3h3x12(:,411),heltab2x36(:,:,433))
  call Hloop_A_Q(ntryL,G0H12(68),16,nMT,G1H12(155),n2h12(111))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(492),h0tab(:,492),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,2),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(69),ngZu,m3h3x12(:,412),heltab2x36(:,:,434))
  call Hloop_Q_A(ntryL,G0H12(69),16,nMT,G1H12(156),n2h12(112))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(493),h0tab(:,493),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,2),wf3(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(70),ngZd,m3h3x12(:,413),heltab2x36(:,:,435))
  call Hloop_A_Q(ntryL,G0H12(70),16,nMB,G1H12(158),n2h12(113))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(494),h0tab(:,494),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,2),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(71),ngZd,m3h3x12(:,414),heltab2x36(:,:,436))
  call Hloop_Q_A(ntryL,G0H12(71),16,nMB,G1H12(160),n2h12(114))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(495),h0tab(:,495),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(161),m3h3x12(:,415),heltab2x36(:,:,437))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(496),h0tab(:,496),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(162),m3h3x12(:,416),heltab2x36(:,:,438))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(497),h0tab(:,497),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(163),m3h3x12(:,417),heltab2x36(:,:,439))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(498),h0tab(:,498),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(164),m3h3x12(:,418),heltab2x36(:,:,440))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(499),h0tab(:,499),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(165),m3h3x12(:,419),heltab2x36(:,:,441))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(500),h0tab(:,500),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(166),m3h3x12(:,420),heltab2x36(:,:,442))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(501),h0tab(:,501),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(167),m3h3x12(:,421),heltab2x36(:,:,443))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(502),h0tab(:,502),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(168),m3h3x12(:,422),heltab2x36(:,:,444))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(503),h0tab(:,503),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(172),m3h3x12(:,423),heltab2x36(:,:,445))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(504),h0tab(:,504),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(170),m3h3x12(:,424),heltab2x36(:,:,446))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(505),h0tab(:,505),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(171),m3h3x12(:,425),heltab2x36(:,:,447))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(506),h0tab(:,506),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(173),m3h3x12(:,426),heltab2x36(:,:,448))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(507),h0tab(:,507),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,427),heltab2x36(:,:,449))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(508),h0tab(:,508),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,428),heltab2x36(:,:,450))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(509),h0tab(:,509),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(74),m3h3x12(:,429),heltab2x36(:,:,451))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(510),h0tab(:,510),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(75),m3h3x12(:,430),heltab2x36(:,:,452))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(511),h0tab(:,511),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(76),m3h3x12(:,431),heltab2x36(:,:,453))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(512),h0tab(:,512),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(77),m3h3x12(:,432),heltab2x36(:,:,454))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(513),h0tab(:,513),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(78),m3h3x12(:,433),heltab2x36(:,:,455))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(514),h0tab(:,514),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(79),m3h3x12(:,434),heltab2x36(:,:,456))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(515),h0tab(:,515),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(177),m3h3x12(:,435),heltab2x36(:,:,457))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(516),h0tab(:,516),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(175),m3h3x12(:,436),heltab2x36(:,:,458))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(517),h0tab(:,517),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(176),m3h3x12(:,437),heltab2x36(:,:,459))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(518),h0tab(:,518),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(178),m3h3x12(:,438),heltab2x36(:,:,460))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(519),h0tab(:,519),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(80),ngZl,m3h3x12(:,439),heltab2x36(:,:,461))
  call Hloop_A_Q(ntryL,G0H12(80),16,0,G1H12(179),n2h12(115))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(520),h0tab(:,520),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(81),ngZl,m3h3x12(:,440),heltab2x36(:,:,462))
  call Hloop_A_Q(ntryL,G0H12(81),16,nML,G1H12(180),n2h12(116))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(521),h0tab(:,521),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(82),ngZl,m3h3x12(:,441),heltab2x36(:,:,463))
  call Hloop_Q_A(ntryL,G0H12(82),16,0,G1H12(186),n2h12(117))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(522),h0tab(:,522),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(83),ngZl,m3h3x12(:,442),heltab2x36(:,:,464))
  call Hloop_Q_A(ntryL,G0H12(83),16,nML,G1H12(184),n2h12(118))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(523),h0tab(:,523),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(84),ngZu,m3h3x12(:,443),heltab2x36(:,:,465))
  call Hloop_A_Q(ntryL,G0H12(84),16,0,G1H12(185),n2h12(119))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(524),h0tab(:,524),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(86),ngZu,m3h3x12(:,444),heltab2x36(:,:,466))
  call Hloop_A_Q(ntryL,G0H12(86),16,nMT,G1H12(187),n2h12(120))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(525),h0tab(:,525),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(88),ngZu,m3h3x12(:,445),heltab2x36(:,:,467))
  call Hloop_Q_A(ntryL,G0H12(88),16,0,G1H12(193),n2h12(121))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(526),h0tab(:,526),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(90),ngZu,m3h3x12(:,446),heltab2x36(:,:,468))
  call Hloop_Q_A(ntryL,G0H12(90),16,nMT,G1H12(191),n2h12(122))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(527),h0tab(:,527),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(92),ngZd,m3h3x12(:,447),heltab2x36(:,:,469))
  call Hloop_A_Q(ntryL,G0H12(92),16,0,G1H12(192),n2h12(123))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(528),h0tab(:,528),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(93),ngZd,m3h3x12(:,448),heltab2x36(:,:,470))
  call Hloop_A_Q(ntryL,G0H12(93),16,nMB,G1H12(194),n2h12(124))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(529),h0tab(:,529),[16,3,12],[0,0,0],3,2,wf4(:,1),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(94),ngZd,m3h3x12(:,449),heltab2x36(:,:,471))
  call Hloop_Q_A(ntryL,G0H12(94),16,0,G1H12(195),n2h12(125))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(530),h0tab(:,530),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(95),ngZd,m3h3x12(:,450),heltab2x36(:,:,472))
  call Hloop_Q_A(ntryL,G0H12(95),16,nMB,G1H12(196),n2h12(126))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(531),h0tab(:,531),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(96),ngZn,m3h3x12(:,451),heltab2x36(:,:,473))
  call Hloop_A_Q(ntryL,G0H12(96),16,0,G1H12(73),n2h12(127))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(532),h0tab(:,532),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(97),ngZn,m3h3x12(:,452),heltab2x36(:,:,474))
  call Hloop_Q_A(ntryL,G0H12(97),16,0,G1H12(74),n2h12(128))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(533),h0tab(:,533),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(98),ngZl,m3h3x12(:,453),heltab2x36(:,:,475))
  call Hloop_A_Q(ntryL,G0H12(98),16,0,G1H12(77),n2h12(129))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(534),h0tab(:,534),[16,3,12],[nML,nML,nML],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(99),ngZl,m3h3x12(:,454),heltab2x36(:,:,476))
  call Hloop_A_Q(ntryL,G0H12(99),16,nML,G1H12(78),n2h12(130))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(535),h0tab(:,535),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(100),ngZl,m3h3x12(:,455),heltab2x36(:,:,477))
  call Hloop_Q_A(ntryL,G0H12(100),16,0,G1H12(125),n2h12(131))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(536),h0tab(:,536),[16,3,12],[nML,nML,nML],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(101),ngZl,m3h3x12(:,456),heltab2x36(:,:,478))
  call Hloop_Q_A(ntryL,G0H12(101),16,nML,G1H12(126),n2h12(132))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(537),h0tab(:,537),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(102),ngZu,m3h3x12(:,457),heltab2x36(:,:,479))
  call Hloop_A_Q(ntryL,G0H12(102),16,0,G1H12(129),n2h12(133))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(538),h0tab(:,538),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(103),ngZu,m3h3x12(:,458),heltab2x36(:,:,480))
  call Hloop_A_Q(ntryL,G0H12(103),16,nMT,G1H12(130),n2h12(134))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(539),h0tab(:,539),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(104),ngZu,m3h3x12(:,459),heltab2x36(:,:,481))
  call Hloop_Q_A(ntryL,G0H12(104),16,0,G1H12(137),n2h12(135))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(540),h0tab(:,540),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(105),ngZu,m3h3x12(:,460),heltab2x36(:,:,482))
  call Hloop_Q_A(ntryL,G0H12(105),16,nMT,G1H12(139),n2h12(136))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(541),h0tab(:,541),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(106),ngZd,m3h3x12(:,461),heltab2x36(:,:,483))
  call Hloop_A_Q(ntryL,G0H12(106),16,0,G1H12(183),n2h12(137))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(542),h0tab(:,542),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,2),wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(107),ngZd,m3h3x12(:,462),heltab2x36(:,:,484))
  call Hloop_A_Q(ntryL,G0H12(107),16,nMB,G1H12(190),n2h12(138))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(543),h0tab(:,543),[16,3,12],[0,0,0],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(108),ngZd,m3h3x12(:,463),heltab2x36(:,:,485))
  call Hloop_Q_A(ntryL,G0H12(108),16,0,G1H12(9),n2h12(139))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(544),h0tab(:,544),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,2),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(109),ngZd,m3h3x12(:,464),heltab2x36(:,:,486))
  call Hloop_Q_A(ntryL,G0H12(109),16,nMB,G1H12(11),n2h12(140))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(545),h0tab(:,545),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(157),m3h3x12(:,465),heltab2x36(:,:,487))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(546),h0tab(:,546),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(159),m3h3x12(:,466),heltab2x36(:,:,488))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(547),h0tab(:,547),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(169),m3h3x12(:,467),heltab2x36(:,:,489))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(548),h0tab(:,548),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(174),m3h3x12(:,468),heltab2x36(:,:,490))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(549),h0tab(:,549),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(93),m3h3x12(:,469),heltab2x36(:,:,491))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(550),h0tab(:,550),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(95),m3h3x12(:,470),heltab2x36(:,:,492))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(551),h0tab(:,551),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(97),m3h3x12(:,471),heltab2x36(:,:,493))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(552),h0tab(:,552),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(99),m3h3x12(:,472),heltab2x36(:,:,494))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(553),h0tab(:,553),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(181),m3h3x12(:,473),heltab2x36(:,:,495))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(554),h0tab(:,554),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(182),m3h3x12(:,474),heltab2x36(:,:,496))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(555),h0tab(:,555),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(4),m3h3x12(:,475),heltab2x36(:,:,497))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(556),h0tab(:,556),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(5),m3h3x12(:,476),heltab2x36(:,:,498))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(557),h0tab(:,557),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(188),m3h3x12(:,477),heltab2x36(:,:,499))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(558),h0tab(:,558),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(189),m3h3x12(:,478),heltab2x36(:,:,500))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(559),h0tab(:,559),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(6),m3h3x12(:,479),heltab2x36(:,:,501))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(560),h0tab(:,560),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(8),m3h3x12(:,480),heltab2x36(:,:,502))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(561),h0tab(:,561),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(10),m3h3x12(:,481),heltab2x36(:,:,503))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(562),h0tab(:,562),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(12),m3h3x12(:,482),heltab2x36(:,:,504))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(563),h0tab(:,563),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(14),m3h3x12(:,483),heltab2x36(:,:,505))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(564),h0tab(:,564),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(15),m3h3x12(:,484),heltab2x36(:,:,506))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(565),h0tab(:,565),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(110),m3h3x12(:,485),heltab2x36(:,:,507))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(566),h0tab(:,566),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(111),m3h3x12(:,486),heltab2x36(:,:,508))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(567),h0tab(:,567),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(112),m3h3x12(:,487),heltab2x36(:,:,509))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(568),h0tab(:,568),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(113),m3h3x12(:,488),heltab2x36(:,:,510))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(569),h0tab(:,569),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,489),heltab2x36(:,:,511))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(570),h0tab(:,570),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(115),m3h3x12(:,490),heltab2x36(:,:,512))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(571),h0tab(:,571),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(116),m3h3x12(:,491),heltab2x36(:,:,513))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(572),h0tab(:,572),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,492),heltab2x36(:,:,514))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(573),h0tab(:,573),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(119),m3h3x12(:,493),heltab2x36(:,:,515))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(574),h0tab(:,574),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(6),m3h3x12(:,494),heltab2x36(:,:,516))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(575),h0tab(:,575),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(120),m3h3x12(:,495),heltab2x36(:,:,517))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(576),h0tab(:,576),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,496),heltab2x36(:,:,518))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(577),h0tab(:,577),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,497),heltab2x36(:,:,519))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(578),h0tab(:,578),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,498),heltab2x36(:,:,520))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(579),h0tab(:,579),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,499),heltab2x36(:,:,521))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(580),h0tab(:,580),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,500),heltab2x36(:,:,522))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(581),h0tab(:,581),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(17),m3h3x12(:,501),heltab2x36(:,:,523))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(582),h0tab(:,582),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(18),m3h3x12(:,502),heltab2x36(:,:,524))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(583),h0tab(:,583),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(20),m3h3x12(:,503),heltab2x36(:,:,525))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(584),h0tab(:,584),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(21),m3h3x12(:,504),heltab2x36(:,:,526))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(585),h0tab(:,585),[20,3,8],[nML,nML,nML],3,2,wf3(:,5),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(117),ngX,m3h3x12(:,505),heltab2x36(:,:,527))
  call Hloop_Q_A(ntryL,G0H12(117),20,nML,G1H12(3),n2h12(141))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(586),h0tab(:,586),[20,3,8],[nML,nML,nML],3,2,wf3(:,5),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,5),G0H12(4),ngX,m3h3x12(:,506),heltab2x36(:,:,528))
  call Hloop_A_Q(ntryL,G0H12(4),20,nML,G1H12(2),n2h12(142))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(587),h0tab(:,587),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,5),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(118),ngX,m3h3x12(:,507),heltab2x36(:,:,529))
  call Hloop_Q_A(ntryL,G0H12(118),20,nMT,G1H12(27),n2h12(143))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(588),h0tab(:,588),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,5),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,5),G0H12(27),ngX,m3h3x12(:,508),heltab2x36(:,:,530))
  call Hloop_A_Q(ntryL,G0H12(27),20,nMT,G1H12(28),n2h12(144))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(589),h0tab(:,589),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,5),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(53),ngX,m3h3x12(:,509),heltab2x36(:,:,531))
  call Hloop_Q_A(ntryL,G0H12(53),20,nMB,G1H12(30),n2h12(145))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(590),h0tab(:,590),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,5),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,5),G0H12(55),ngX,m3h3x12(:,510),heltab2x36(:,:,532))
  call Hloop_A_Q(ntryL,G0H12(55),20,nMB,G1H12(31),n2h12(146))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(591),h0tab(:,591),[20,3,8],[nML,nML,nML],3,2,wf3(:,5),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(57),ngX,m3h3x12(:,511),heltab2x36(:,:,533))
  call Hloop_Q_A(ntryL,G0H12(57),20,nML,G1H12(32),n2h12(147))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(592),h0tab(:,592),[20,3,8],[nML,nML,nML],3,2,wf3(:,5),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,5),G0H12(59),ngX,m3h3x12(:,512),heltab2x36(:,:,534))
  call Hloop_A_Q(ntryL,G0H12(59),20,nML,G1H12(34),n2h12(148))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(593),h0tab(:,593),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,5),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(85),ngX,m3h3x12(:,513),heltab2x36(:,:,535))
  call Hloop_Q_A(ntryL,G0H12(85),20,nMT,G1H12(37),n2h12(149))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(594),h0tab(:,594),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,5),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,5),G0H12(87),ngX,m3h3x12(:,514),heltab2x36(:,:,536))
  call Hloop_A_Q(ntryL,G0H12(87),20,nMT,G1H12(38),n2h12(150))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(595),h0tab(:,595),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,5),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(89),ngX,m3h3x12(:,515),heltab2x36(:,:,537))
  call Hloop_Q_A(ntryL,G0H12(89),20,nMB,G1H12(39),n2h12(151))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(596),h0tab(:,596),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,5),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,5),G0H12(91),ngX,m3h3x12(:,516),heltab2x36(:,:,538))
  call Hloop_A_Q(ntryL,G0H12(91),20,nMB,G1H12(40),n2h12(152))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(597),h0tab(:,597),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(8),m3h3x12(:,517),heltab2x36(:,:,539))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(598),h0tab(:,598),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(9),m3h3x12(:,518),heltab2x36(:,:,540))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(599),h0tab(:,599),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(10),m3h3x12(:,519),heltab2x36(:,:,541))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(600),h0tab(:,600),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(11),m3h3x12(:,520),heltab2x36(:,:,542))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(601),h0tab(:,601),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(1),m3h3x12(:,521),heltab2x36(:,:,543))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(602),h0tab(:,602),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(2),m3h3x12(:,522),heltab2x36(:,:,544))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(603),h0tab(:,603),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(3),m3h3x12(:,523),heltab2x36(:,:,545))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(604),h0tab(:,604),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(60),m3h3x12(:,524),heltab2x36(:,:,546))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(605),h0tab(:,605),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(42),m3h3x12(:,525),heltab2x36(:,:,547))
  Gcoeff(:)%j = (c(114)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(606),h0tab(:,606),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(43),m3h3x12(:,526),heltab2x36(:,:,548))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(607),h0tab(:,607),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(44),m3h3x12(:,527),heltab2x36(:,:,549))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(608),h0tab(:,608),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(45),m3h3x12(:,528),heltab2x36(:,:,550))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(609),h0tab(:,609),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(47),m3h3x12(:,529),heltab2x36(:,:,551))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(610),h0tab(:,610),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(48),m3h3x12(:,530),heltab2x36(:,:,552))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(611),h0tab(:,611),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(49),m3h3x12(:,531),heltab2x36(:,:,553))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(612),h0tab(:,612),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(50),m3h3x12(:,532),heltab2x36(:,:,554))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(613),h0tab(:,613),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(52),m3h3x12(:,533),heltab2x36(:,:,555))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(614),h0tab(:,614),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(54),m3h3x12(:,534),heltab2x36(:,:,556))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(615),h0tab(:,615),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(56),m3h3x12(:,535),heltab2x36(:,:,557))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(616),h0tab(:,616),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(57),m3h3x12(:,536),heltab2x36(:,:,558))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(617),h0tab(:,617),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(59),m3h3x12(:,537),heltab2x36(:,:,559))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(618),h0tab(:,618),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(60),m3h3x12(:,538),heltab2x36(:,:,560))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(619),h0tab(:,619),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(61),m3h3x12(:,539),heltab2x36(:,:,561))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(620),h0tab(:,620),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(62),m3h3x12(:,540),heltab2x36(:,:,562))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(621),h0tab(:,621),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(61),ngZl,m3h3x12(:,541),heltab2x36(:,:,563))
  call Hloop_Q_A(ntryL,G0H12(61),20,0,G1H12(64),n2h12(153))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(622),h0tab(:,622),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(62),ngZl,m3h3x12(:,542),heltab2x36(:,:,564))
  call Hloop_Q_A(ntryL,G0H12(62),20,nML,G1H12(65),n2h12(154))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(623),h0tab(:,623),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(63),ngZl,m3h3x12(:,543),heltab2x36(:,:,565))
  call Hloop_A_Q(ntryL,G0H12(63),20,0,G1H12(66),n2h12(155))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(624),h0tab(:,624),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(64),ngZl,m3h3x12(:,544),heltab2x36(:,:,566))
  call Hloop_A_Q(ntryL,G0H12(64),20,nML,G1H12(67),n2h12(156))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(625),h0tab(:,625),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(65),ngZu,m3h3x12(:,545),heltab2x36(:,:,567))
  call Hloop_Q_A(ntryL,G0H12(65),20,0,G1H12(69),n2h12(157))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(626),h0tab(:,626),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(66),ngZu,m3h3x12(:,546),heltab2x36(:,:,568))
  call Hloop_Q_A(ntryL,G0H12(66),20,nMT,G1H12(70),n2h12(158))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(627),h0tab(:,627),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(67),ngZu,m3h3x12(:,547),heltab2x36(:,:,569))
  call Hloop_A_Q(ntryL,G0H12(67),20,0,G1H12(71),n2h12(159))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(628),h0tab(:,628),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(68),ngZu,m3h3x12(:,548),heltab2x36(:,:,570))
  call Hloop_A_Q(ntryL,G0H12(68),20,nMT,G1H12(72),n2h12(160))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(629),h0tab(:,629),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(69),ngZd,m3h3x12(:,549),heltab2x36(:,:,571))
  call Hloop_Q_A(ntryL,G0H12(69),20,0,G1H12(76),n2h12(161))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(630),h0tab(:,630),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(70),ngZd,m3h3x12(:,550),heltab2x36(:,:,572))
  call Hloop_Q_A(ntryL,G0H12(70),20,nMB,G1H12(79),n2h12(162))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(631),h0tab(:,631),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(71),ngZd,m3h3x12(:,551),heltab2x36(:,:,573))
  call Hloop_A_Q(ntryL,G0H12(71),20,0,G1H12(80),n2h12(163))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(632),h0tab(:,632),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(80),ngZd,m3h3x12(:,552),heltab2x36(:,:,574))
  call Hloop_A_Q(ntryL,G0H12(80),20,nMB,G1H12(81),n2h12(164))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(633),h0tab(:,633),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(81),ngZn,m3h3x12(:,553),heltab2x36(:,:,575))
  call Hloop_Q_A(ntryL,G0H12(81),20,0,G1H12(83),n2h12(165))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(634),h0tab(:,634),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(82),ngZn,m3h3x12(:,554),heltab2x36(:,:,576))
  call Hloop_A_Q(ntryL,G0H12(82),20,0,G1H12(84),n2h12(166))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(635),h0tab(:,635),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(83),ngZl,m3h3x12(:,555),heltab2x36(:,:,577))
  call Hloop_Q_A(ntryL,G0H12(83),20,0,G1H12(85),n2h12(167))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(636),h0tab(:,636),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(84),ngZl,m3h3x12(:,556),heltab2x36(:,:,578))
  call Hloop_Q_A(ntryL,G0H12(84),20,nML,G1H12(86),n2h12(168))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(637),h0tab(:,637),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(86),ngZl,m3h3x12(:,557),heltab2x36(:,:,579))
  call Hloop_A_Q(ntryL,G0H12(86),20,0,G1H12(88),n2h12(169))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(638),h0tab(:,638),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(88),ngZl,m3h3x12(:,558),heltab2x36(:,:,580))
  call Hloop_A_Q(ntryL,G0H12(88),20,nML,G1H12(89),n2h12(170))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(639),h0tab(:,639),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(90),ngZu,m3h3x12(:,559),heltab2x36(:,:,581))
  call Hloop_Q_A(ntryL,G0H12(90),20,0,G1H12(90),n2h12(171))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(640),h0tab(:,640),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(92),ngZu,m3h3x12(:,560),heltab2x36(:,:,582))
  call Hloop_Q_A(ntryL,G0H12(92),20,nMT,G1H12(91),n2h12(172))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(641),h0tab(:,641),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(93),ngZu,m3h3x12(:,561),heltab2x36(:,:,583))
  call Hloop_A_Q(ntryL,G0H12(93),20,0,G1H12(94),n2h12(173))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(642),h0tab(:,642),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(94),ngZu,m3h3x12(:,562),heltab2x36(:,:,584))
  call Hloop_A_Q(ntryL,G0H12(94),20,nMT,G1H12(96),n2h12(174))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(643),h0tab(:,643),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(95),ngZd,m3h3x12(:,563),heltab2x36(:,:,585))
  call Hloop_Q_A(ntryL,G0H12(95),20,0,G1H12(98),n2h12(175))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(644),h0tab(:,644),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(96),ngZd,m3h3x12(:,564),heltab2x36(:,:,586))
  call Hloop_Q_A(ntryL,G0H12(96),20,nMB,G1H12(100),n2h12(176))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(645),h0tab(:,645),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(97),ngZd,m3h3x12(:,565),heltab2x36(:,:,587))
  call Hloop_A_Q(ntryL,G0H12(97),20,0,G1H12(102),n2h12(177))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(646),h0tab(:,646),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(98),ngZd,m3h3x12(:,566),heltab2x36(:,:,588))
  call Hloop_A_Q(ntryL,G0H12(98),20,nMB,G1H12(103),n2h12(178))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(647),h0tab(:,647),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(104),m3h3x12(:,567),heltab2x36(:,:,589))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(648),h0tab(:,648),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(105),m3h3x12(:,568),heltab2x36(:,:,590))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(649),h0tab(:,649),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(107),m3h3x12(:,569),heltab2x36(:,:,591))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(650),h0tab(:,650),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(108),m3h3x12(:,570),heltab2x36(:,:,592))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(651),h0tab(:,651),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(109),m3h3x12(:,571),heltab2x36(:,:,593))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(652),h0tab(:,652),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,1),G1H12(7),m3h3x12(:,572),heltab2x36(:,:,594))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(653),h0tab(:,653),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(13),m3h3x12(:,573),heltab2x36(:,:,595))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(654),h0tab(:,654),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,1),G1H12(111),m3h3x12(:,574),heltab2x36(:,:,596))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(655),h0tab(:,655),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(19),m3h3x12(:,575),heltab2x36(:,:,597))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(656),h0tab(:,656),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,1),G1H12(112),m3h3x12(:,576),heltab2x36(:,:,598))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(657),h0tab(:,657),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(113),m3h3x12(:,577),heltab2x36(:,:,599))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(658),h0tab(:,658),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,1),G1H12(23),m3h3x12(:,578),heltab2x36(:,:,600))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(659),h0tab(:,659),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(114),m3h3x12(:,579),heltab2x36(:,:,601))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(660),h0tab(:,660),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(24),m3h3x12(:,580),heltab2x36(:,:,602))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(661),h0tab(:,661),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(25),m3h3x12(:,581),heltab2x36(:,:,603))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(662),h0tab(:,662),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(116),m3h3x12(:,582),heltab2x36(:,:,604))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(663),h0tab(:,663),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(99),m3h3x12(:,583),heltab2x36(:,:,605))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(664),h0tab(:,664),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(100),m3h3x12(:,584),heltab2x36(:,:,606))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(665),h0tab(:,665),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(101),m3h3x12(:,585),heltab2x36(:,:,607))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(666),h0tab(:,666),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(102),m3h3x12(:,586),heltab2x36(:,:,608))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(667),h0tab(:,667),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(103),m3h3x12(:,587),heltab2x36(:,:,609))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(668),h0tab(:,668),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(104),m3h3x12(:,588),heltab2x36(:,:,610))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(669),h0tab(:,669),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(105),m3h3x12(:,589),heltab2x36(:,:,611))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(670),h0tab(:,670),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(106),m3h3x12(:,590),heltab2x36(:,:,612))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(671),h0tab(:,671),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(26),m3h3x12(:,591),heltab2x36(:,:,613))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(672),h0tab(:,672),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(117),m3h3x12(:,592),heltab2x36(:,:,614))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(673),h0tab(:,673),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(118),m3h3x12(:,593),heltab2x36(:,:,615))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(674),h0tab(:,674),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(35),m3h3x12(:,594),heltab2x36(:,:,616))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(675),h0tab(:,675),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(197),m3h3x12(:,595),heltab2x36(:,:,617))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(676),h0tab(:,676),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(198),m3h3x12(:,596),heltab2x36(:,:,618))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(677),h0tab(:,677),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(199),m3h3x12(:,597),heltab2x36(:,:,619))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(678),h0tab(:,678),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(200),m3h3x12(:,598),heltab2x36(:,:,620))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(679),h0tab(:,679),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(107),m3h3x12(:,599),heltab2x36(:,:,621))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(680),h0tab(:,680),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(108),m3h3x12(:,600),heltab2x36(:,:,622))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(681),h0tab(:,681),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(109),m3h3x12(:,601),heltab2x36(:,:,623))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(682),h0tab(:,682),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(117),m3h3x12(:,602),heltab2x36(:,:,624))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(683),h0tab(:,683),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(4),m3h3x12(:,603),heltab2x36(:,:,625))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(684),h0tab(:,684),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(118),m3h3x12(:,604),heltab2x36(:,:,626))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(685),h0tab(:,685),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(27),m3h3x12(:,605),heltab2x36(:,:,627))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(686),h0tab(:,686),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(53),m3h3x12(:,606),heltab2x36(:,:,628))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(687),h0tab(:,687),[24,3,4],[nML,nML,nML],3,2,wf9(:,1),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,11),heltab2x36(:,:,629))
  call Hloop_Q_A(ntryL,G0H4(23),24,nML,G1H4(9),n2h4(1))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(688),h0tab(:,688),[24,3,4],[nML,nML,nML],3,2,wf9(:,1),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,12),heltab2x36(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(23),24,nML,G1H4(10),n2h4(2))
  Gcoeff(:)%j = (c(166)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(689),h0tab(:,689),[24,3,4],[nMT,nMT,nMT],3,2,wf9(:,1),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,13),heltab2x36(:,:,631))
  call Hloop_Q_A(ntryL,G0H4(23),24,nMT,G1H4(11),n2h4(3))
  Gcoeff(:)%j = (c(166)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(690),h0tab(:,690),[24,3,4],[nMT,nMT,nMT],3,2,wf9(:,1),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,14),heltab2x36(:,:,632))
  call Hloop_A_Q(ntryL,G0H4(23),24,nMT,G1H4(12),n2h4(4))
  Gcoeff(:)%j = (-(c(148)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(691),h0tab(:,691),[24,3,4],[nMB,nMB,nMB],3,2,wf9(:,1),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,15),heltab2x36(:,:,633))
  call Hloop_Q_A(ntryL,G0H4(23),24,nMB,G1H4(13),n2h4(5))
  Gcoeff(:)%j = (-(c(148)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(692),h0tab(:,692),[24,3,4],[nMB,nMB,nMB],3,2,wf9(:,1),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,16),heltab2x36(:,:,634))
  call Hloop_A_Q(ntryL,G0H4(23),24,nMB,G1H4(14),n2h4(6))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(693),h0tab(:,693),[24,3,4],[nML,nML,nML],3,2,wf9(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,17),heltab2x36(:,:,635))
  call Hloop_Q_A(ntryL,G0H4(23),24,nML,G1H4(15),n2h4(7))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(694),h0tab(:,694),[24,3,4],[nML,nML,nML],3,2,wf9(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,18),heltab2x36(:,:,636))
  call Hloop_A_Q(ntryL,G0H4(23),24,nML,G1H4(16),n2h4(8))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(695),h0tab(:,695),[24,3,4],[nMT,nMT,nMT],3,2,wf9(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,19),heltab2x36(:,:,637))
  call Hloop_Q_A(ntryL,G0H4(23),24,nMT,G1H4(17),n2h4(9))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(696),h0tab(:,696),[24,3,4],[nMT,nMT,nMT],3,2,wf9(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,20),heltab2x36(:,:,638))
  call Hloop_A_Q(ntryL,G0H4(23),24,nMT,G1H4(18),n2h4(10))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(697),h0tab(:,697),[24,3,4],[nMB,nMB,nMB],3,2,wf9(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,21),heltab2x36(:,:,639))
  call Hloop_Q_A(ntryL,G0H4(23),24,nMB,G1H4(19),n2h4(11))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(698),h0tab(:,698),[24,3,4],[nMB,nMB,nMB],3,2,wf9(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(23),ngH,m3h9x4(:,22),heltab2x36(:,:,640))
  call Hloop_A_Q(ntryL,G0H4(23),24,nMB,G1H4(20),n2h4(12))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(699),h0tab(:,699),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(23),m3h9x4(:,23),heltab2x36(:,:,641))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(700),h0tab(:,700),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(24),m3h9x4(:,24),heltab2x36(:,:,642))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(701),h0tab(:,701),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(25),m3h9x4(:,25),heltab2x36(:,:,643))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(702),h0tab(:,702),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(26),m3h9x4(:,26),heltab2x36(:,:,644))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(703),h0tab(:,703),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(27),m3h9x4(:,27),heltab2x36(:,:,645))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(704),h0tab(:,704),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(28),m3h9x4(:,28),heltab2x36(:,:,646))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(705),h0tab(:,705),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(29),m3h9x4(:,29),heltab2x36(:,:,647))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(706),h0tab(:,706),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(30),m3h9x4(:,30),heltab2x36(:,:,648))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(707),h0tab(:,707),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(31),m3h9x4(:,31),heltab2x36(:,:,649))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(708),h0tab(:,708),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(32),m3h9x4(:,32),heltab2x36(:,:,650))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(709),h0tab(:,709),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(33),m3h9x4(:,33),heltab2x36(:,:,651))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(710),h0tab(:,710),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(34),m3h9x4(:,34),heltab2x36(:,:,652))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(711),h0tab(:,711),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(35),m3h9x4(:,35),heltab2x36(:,:,653))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(712),h0tab(:,712),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(36),m3h9x4(:,36),heltab2x36(:,:,654))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(713),h0tab(:,713),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(37),m3h9x4(:,37),heltab2x36(:,:,655))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(714),h0tab(:,714),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(38),m3h9x4(:,38),heltab2x36(:,:,656))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(715),h0tab(:,715),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(21),m3h9x4(:,39),heltab2x36(:,:,657))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(716),h0tab(:,716),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(22),m3h9x4(:,40),heltab2x36(:,:,658))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(717),h0tab(:,717),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(23),m3h9x4(:,41),heltab2x36(:,:,659))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(718),h0tab(:,718),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(24),m3h9x4(:,42),heltab2x36(:,:,660))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(719),h0tab(:,719),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(25),m3h9x4(:,43),heltab2x36(:,:,661))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(720),h0tab(:,720),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(26),m3h9x4(:,44),heltab2x36(:,:,662))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(721),h0tab(:,721),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(27),m3h9x4(:,45),heltab2x36(:,:,663))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(722),h0tab(:,722),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(28),m3h9x4(:,46),heltab2x36(:,:,664))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(723),h0tab(:,723),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(39),m3h9x4(:,47),heltab2x36(:,:,665))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(724),h0tab(:,724),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(40),m3h9x4(:,48),heltab2x36(:,:,666))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(725),h0tab(:,725),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(41),m3h9x4(:,49),heltab2x36(:,:,667))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(726),h0tab(:,726),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(42),m3h9x4(:,50),heltab2x36(:,:,668))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(727),h0tab(:,727),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(43),m3h9x4(:,51),heltab2x36(:,:,669))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(728),h0tab(:,728),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(44),m3h9x4(:,52),heltab2x36(:,:,670))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(729),h0tab(:,729),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(45),m3h9x4(:,53),heltab2x36(:,:,671))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(730),h0tab(:,730),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(46),m3h9x4(:,54),heltab2x36(:,:,672))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(731),h0tab(:,731),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(29),m3h9x4(:,55),heltab2x36(:,:,673))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(732),h0tab(:,732),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(30),m3h9x4(:,56),heltab2x36(:,:,674))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(733),h0tab(:,733),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(31),m3h9x4(:,57),heltab2x36(:,:,675))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(734),h0tab(:,734),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(32),m3h9x4(:,58),heltab2x36(:,:,676))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(735),h0tab(:,735),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(33),m3h9x4(:,59),heltab2x36(:,:,677))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(736),h0tab(:,736),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(34),m3h9x4(:,60),heltab2x36(:,:,678))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(737),h0tab(:,737),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(35),m3h9x4(:,61),heltab2x36(:,:,679))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(738),h0tab(:,738),[24,3,4],[nMW,nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(36),m3h9x4(:,62),heltab2x36(:,:,680))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(739),h0tab(:,739),[16,7,8],[nML,nML,nML],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(55),ngZl,m3h3x12(:,607),heltab2x36(:,:,681))
  call Hloop_A_Q(ntryL,G0H12(55),16,nML,G1H12(201),n2h12(179))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(740),h0tab(:,740),[16,7,8],[nML,nML,nML],3,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(57),ngZl,m3h3x12(:,608),heltab2x36(:,:,682))
  call Hloop_Q_A(ntryL,G0H12(57),16,nML,G1H12(202),n2h12(180))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(741),h0tab(:,741),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(59),ngZu,m3h3x12(:,609),heltab2x36(:,:,683))
  call Hloop_A_Q(ntryL,G0H12(59),16,nMT,G1H12(203),n2h12(181))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(742),h0tab(:,742),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(85),ngZu,m3h3x12(:,610),heltab2x36(:,:,684))
  call Hloop_Q_A(ntryL,G0H12(85),16,nMT,G1H12(204),n2h12(182))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(743),h0tab(:,743),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(87),ngZd,m3h3x12(:,611),heltab2x36(:,:,685))
  call Hloop_A_Q(ntryL,G0H12(87),16,nMB,G1H12(205),n2h12(183))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(744),h0tab(:,744),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(89),ngZd,m3h3x12(:,612),heltab2x36(:,:,686))
  call Hloop_Q_A(ntryL,G0H12(89),16,nMB,G1H12(206),n2h12(184))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(745),h0tab(:,745),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(207),m3h3x12(:,613),heltab2x36(:,:,687))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(746),h0tab(:,746),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(208),m3h3x12(:,614),heltab2x36(:,:,688))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(747),h0tab(:,747),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(209),m3h3x12(:,615),heltab2x36(:,:,689))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(748),h0tab(:,748),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(210),m3h3x12(:,616),heltab2x36(:,:,690))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(749),h0tab(:,749),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(91),m3h3x12(:,617),heltab2x36(:,:,691))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(750),h0tab(:,750),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,618),heltab2x36(:,:,692))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(751),h0tab(:,751),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(211),m3h3x12(:,619),heltab2x36(:,:,693))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(752),h0tab(:,752),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(212),m3h3x12(:,620),heltab2x36(:,:,694))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(753),h0tab(:,753),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(213),m3h3x12(:,621),heltab2x36(:,:,695))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(754),h0tab(:,754),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(214),m3h3x12(:,622),heltab2x36(:,:,696))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(755),h0tab(:,755),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,623),heltab2x36(:,:,697))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(756),h0tab(:,756),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(63),m3h3x12(:,624),heltab2x36(:,:,698))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(757),h0tab(:,757),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(64),ngZn,m3h3x12(:,625),heltab2x36(:,:,699))
  call Hloop_A_Q(ntryL,G0H12(64),16,0,G1H12(215),n2h12(185))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(758),h0tab(:,758),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(65),ngZn,m3h3x12(:,626),heltab2x36(:,:,700))
  call Hloop_Q_A(ntryL,G0H12(65),16,0,G1H12(216),n2h12(186))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(759),h0tab(:,759),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(66),ngZl,m3h3x12(:,627),heltab2x36(:,:,701))
  call Hloop_A_Q(ntryL,G0H12(66),16,0,G1H12(217),n2h12(187))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(760),h0tab(:,760),[16,7,8],[nML,nML,nML],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(67),ngZl,m3h3x12(:,628),heltab2x36(:,:,702))
  call Hloop_A_Q(ntryL,G0H12(67),16,nML,G1H12(218),n2h12(188))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(761),h0tab(:,761),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(68),ngZl,m3h3x12(:,629),heltab2x36(:,:,703))
  call Hloop_Q_A(ntryL,G0H12(68),16,0,G1H12(219),n2h12(189))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(762),h0tab(:,762),[16,7,8],[nML,nML,nML],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(69),ngZl,m3h3x12(:,630),heltab2x36(:,:,704))
  call Hloop_Q_A(ntryL,G0H12(69),16,nML,G1H12(220),n2h12(190))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(763),h0tab(:,763),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(70),ngZu,m3h3x12(:,631),heltab2x36(:,:,705))
  call Hloop_A_Q(ntryL,G0H12(70),16,0,G1H12(221),n2h12(191))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(764),h0tab(:,764),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(71),ngZu,m3h3x12(:,632),heltab2x36(:,:,706))
  call Hloop_A_Q(ntryL,G0H12(71),16,nMT,G1H12(222),n2h12(192))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(765),h0tab(:,765),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(80),ngZu,m3h3x12(:,633),heltab2x36(:,:,707))
  call Hloop_Q_A(ntryL,G0H12(80),16,0,G1H12(223),n2h12(193))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(766),h0tab(:,766),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(81),ngZu,m3h3x12(:,634),heltab2x36(:,:,708))
  call Hloop_Q_A(ntryL,G0H12(81),16,nMT,G1H12(224),n2h12(194))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(767),h0tab(:,767),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(82),ngZd,m3h3x12(:,635),heltab2x36(:,:,709))
  call Hloop_A_Q(ntryL,G0H12(82),16,0,G1H12(225),n2h12(195))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(768),h0tab(:,768),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(83),ngZd,m3h3x12(:,636),heltab2x36(:,:,710))
  call Hloop_A_Q(ntryL,G0H12(83),16,nMB,G1H12(226),n2h12(196))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(769),h0tab(:,769),[16,7,8],[0,0,0],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(84),ngZd,m3h3x12(:,637),heltab2x36(:,:,711))
  call Hloop_Q_A(ntryL,G0H12(84),16,0,G1H12(227),n2h12(197))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(770),h0tab(:,770),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(86),ngZd,m3h3x12(:,638),heltab2x36(:,:,712))
  call Hloop_Q_A(ntryL,G0H12(86),16,nMB,G1H12(228),n2h12(198))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(771),h0tab(:,771),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(229),m3h3x12(:,639),heltab2x36(:,:,713))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(772),h0tab(:,772),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(230),m3h3x12(:,640),heltab2x36(:,:,714))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(773),h0tab(:,773),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(231),m3h3x12(:,641),heltab2x36(:,:,715))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(774),h0tab(:,774),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(232),m3h3x12(:,642),heltab2x36(:,:,716))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(775),h0tab(:,775),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(233),m3h3x12(:,643),heltab2x36(:,:,717))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(776),h0tab(:,776),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(234),m3h3x12(:,644),heltab2x36(:,:,718))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(777),h0tab(:,777),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(235),m3h3x12(:,645),heltab2x36(:,:,719))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(778),h0tab(:,778),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(236),m3h3x12(:,646),heltab2x36(:,:,720))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(779),h0tab(:,779),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(88),m3h3x12(:,647),heltab2x36(:,:,721))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(780),h0tab(:,780),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(90),m3h3x12(:,648),heltab2x36(:,:,722))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(781),h0tab(:,781),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(237),m3h3x12(:,649),heltab2x36(:,:,723))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(782),h0tab(:,782),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(238),m3h3x12(:,650),heltab2x36(:,:,724))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(783),h0tab(:,783),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,651),heltab2x36(:,:,725))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(784),h0tab(:,784),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(93),m3h3x12(:,652),heltab2x36(:,:,726))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(785),h0tab(:,785),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(94),m3h3x12(:,653),heltab2x36(:,:,727))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(786),h0tab(:,786),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(95),m3h3x12(:,654),heltab2x36(:,:,728))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(787),h0tab(:,787),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(239),m3h3x12(:,655),heltab2x36(:,:,729))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(788),h0tab(:,788),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(240),m3h3x12(:,656),heltab2x36(:,:,730))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(789),h0tab(:,789),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(96),m3h3x12(:,657),heltab2x36(:,:,731))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(790),h0tab(:,790),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,658),heltab2x36(:,:,732))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(791),h0tab(:,791),[16,4,11],[nML,nML,nML],3,1,wf12(:,25))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(98),ngZl,m3h3x12(:,659),heltab2x36(:,:,733))
  call Hloop_Q_A(ntryL,G0H12(98),16,nML,G1H12(241),n2h12(199))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(792),h0tab(:,792),[16,4,11],[nML,nML,nML],3,1,wf12(:,25))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(55),ngZl,m3h3x12(:,660),heltab2x36(:,:,734))
  call Hloop_A_Q(ntryL,G0H12(55),16,nML,G1H12(242),n2h12(200))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(793),h0tab(:,793),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,25))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(57),ngZu,m3h3x12(:,661),heltab2x36(:,:,735))
  call Hloop_Q_A(ntryL,G0H12(57),16,nMT,G1H12(243),n2h12(201))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(794),h0tab(:,794),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,25))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(59),ngZu,m3h3x12(:,662),heltab2x36(:,:,736))
  call Hloop_A_Q(ntryL,G0H12(59),16,nMT,G1H12(244),n2h12(202))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(795),h0tab(:,795),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,25))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(85),ngZd,m3h3x12(:,663),heltab2x36(:,:,737))
  call Hloop_Q_A(ntryL,G0H12(85),16,nMB,G1H12(245),n2h12(203))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(796),h0tab(:,796),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,25))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(87),ngZd,m3h3x12(:,664),heltab2x36(:,:,738))
  call Hloop_A_Q(ntryL,G0H12(87),16,nMB,G1H12(246),n2h12(204))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(797),h0tab(:,797),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(247),m3h3x12(:,665),heltab2x36(:,:,739))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(798),h0tab(:,798),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(248),m3h3x12(:,666),heltab2x36(:,:,740))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(799),h0tab(:,799),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(249),m3h3x12(:,667),heltab2x36(:,:,741))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(800),h0tab(:,800),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(250),m3h3x12(:,668),heltab2x36(:,:,742))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(801),h0tab(:,801),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(251),m3h3x12(:,669),heltab2x36(:,:,743))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(802),h0tab(:,802),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(252),m3h3x12(:,670),heltab2x36(:,:,744))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(803),h0tab(:,803),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(253),m3h3x12(:,671),heltab2x36(:,:,745))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(804),h0tab(:,804),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(254),m3h3x12(:,672),heltab2x36(:,:,746))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(805),h0tab(:,805),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(89),m3h3x12(:,673),heltab2x36(:,:,747))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(806),h0tab(:,806),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,674),heltab2x36(:,:,748))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(807),h0tab(:,807),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(255),m3h3x12(:,675),heltab2x36(:,:,749))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(808),h0tab(:,808),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(256),m3h3x12(:,676),heltab2x36(:,:,750))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(809),h0tab(:,809),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(65),m3h3x12(:,677),heltab2x36(:,:,751))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(810),h0tab(:,810),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(66),m3h3x12(:,678),heltab2x36(:,:,752))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(811),h0tab(:,811),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(67),m3h3x12(:,679),heltab2x36(:,:,753))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(812),h0tab(:,812),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(68),m3h3x12(:,680),heltab2x36(:,:,754))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(813),h0tab(:,813),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(257),m3h3x12(:,681),heltab2x36(:,:,755))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(814),h0tab(:,814),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(258),m3h3x12(:,682),heltab2x36(:,:,756))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(815),h0tab(:,815),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(69),m3h3x12(:,683),heltab2x36(:,:,757))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(816),h0tab(:,816),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,25))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,684),heltab2x36(:,:,758))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(817),h0tab(:,817),[19,4,8],[nML,nML,nML],3,1,wf12(:,26))
  call Hloop_AS_Q(ntryL,G0H36(1),wf12(:,26),G0H3(15),ngH,m3h12x3(:,1),heltab2x36(:,:,759))
  call Hloop_A_Q(ntryL,G0H3(15),19,nML,G1H3(136),n2h3(141))
  Gcoeff(:)%j = (c(159)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(818),h0tab(:,818),[19,4,8],[nML,nML,nML],3,1,wf12(:,26))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(13),ngH,m3h12x3(:,2),heltab2x36(:,:,760))
  call Hloop_Q_A(ntryL,G0H3(13),19,nML,G1H3(137),n2h3(142))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(819),h0tab(:,819),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,26))
  call Hloop_AS_Q(ntryL,G0H36(1),wf12(:,26),G0H3(18),ngH,m3h12x3(:,3),heltab2x36(:,:,761))
  call Hloop_A_Q(ntryL,G0H3(18),19,nMT,G1H3(72),n2h3(143))
  Gcoeff(:)%j = (c(167)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(820),h0tab(:,820),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,26))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(17),ngH,m3h12x3(:,4),heltab2x36(:,:,762))
  call Hloop_Q_A(ntryL,G0H3(17),19,nMT,G1H3(139),n2h3(144))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(821),h0tab(:,821),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,26))
  call Hloop_AS_Q(ntryL,G0H36(1),wf12(:,26),G0H3(12),ngH,m3h12x3(:,5),heltab2x36(:,:,763))
  call Hloop_A_Q(ntryL,G0H3(12),19,nMB,G1H3(141),n2h3(145))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(822),h0tab(:,822),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,26))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(10),ngH,m3h12x3(:,6),heltab2x36(:,:,764))
  call Hloop_Q_A(ntryL,G0H3(10),19,nMB,G1H3(3),n2h3(146))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(823),h0tab(:,823),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(11),m3h12x3(:,7),heltab2x36(:,:,765))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(824),h0tab(:,824),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(9),m3h12x3(:,8),heltab2x36(:,:,766))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(825),h0tab(:,825),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(15),m3h12x3(:,9),heltab2x36(:,:,767))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(826),h0tab(:,826),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(13),m3h12x3(:,10),heltab2x36(:,:,768))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(827),h0tab(:,827),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(18),m3h12x3(:,11),heltab2x36(:,:,769))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(828),h0tab(:,828),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(17),m3h12x3(:,12),heltab2x36(:,:,770))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(829),h0tab(:,829),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,26),G0H3(12),m3h12x3(:,13),heltab2x36(:,:,771))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(830),h0tab(:,830),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,26),G0H3(10),m3h12x3(:,14),heltab2x36(:,:,772))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(831),h0tab(:,831),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(143),m3h12x3(:,15),heltab2x36(:,:,773))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(832),h0tab(:,832),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(85),m3h12x3(:,16),heltab2x36(:,:,774))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(833),h0tab(:,833),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(144),m3h12x3(:,17),heltab2x36(:,:,775))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(834),h0tab(:,834),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(147),m3h12x3(:,18),heltab2x36(:,:,776))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(835),h0tab(:,835),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(25),m3h12x3(:,19),heltab2x36(:,:,777))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(836),h0tab(:,836),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(26),m3h12x3(:,20),heltab2x36(:,:,778))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(837),h0tab(:,837),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,26),G0H3(27),m3h12x3(:,21),heltab2x36(:,:,779))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(838),h0tab(:,838),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,26),G0H3(28),m3h12x3(:,22),heltab2x36(:,:,780))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(839),h0tab(:,839),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(86),m3h12x3(:,23),heltab2x36(:,:,781))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(840),h0tab(:,840),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(84),m3h12x3(:,24),heltab2x36(:,:,782))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(841),h0tab(:,841),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(150),m3h12x3(:,25),heltab2x36(:,:,783))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(842),h0tab(:,842),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,26))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(11),m3h12x3(:,26),heltab2x36(:,:,784))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(843),h0tab(:,843),[18,4,9],[nMZ,nMZ,0],3,2,wf6(:,8),wf6(:,2))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,8),G0H6(4),ngZu,m3h6x6(:,13),heltab2x36(:,:,785))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(844),h0tab(:,844),[18,4,9],[nMW,nMW,0],3,2,wf6(:,8),wf6(:,2))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,8),G0H6(5),m3h6x6(:,14),heltab2x36(:,:,786))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(845),h0tab(:,845),[20,2,9],[0,0,0],3,2,wf3(:,1),wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(71),ngZu,m3h3x12(:,685),heltab2x36(:,:,787))
  call Hloop_Q_A(ntryL,G0H12(71),20,0,G1H12(259),n2h12(205))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(846),h0tab(:,846),[20,2,9],[0,nMZ,0],3,2,wf3(:,1),wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(80),ngZu,m3h3x12(:,686),heltab2x36(:,:,788))
  call Hloop_Q_A(ntryL,G0H12(80),20,0,G1H12(260),n2h12(206))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(847),h0tab(:,847),[20,2,9],[0,nMW,0],3,2,wf3(:,1),wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(81),ngZd,m3h3x12(:,687),heltab2x36(:,:,789))
  call Hloop_Q_A(ntryL,G0H12(81),20,0,G1H12(261),n2h12(207))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(848),h0tab(:,848),[20,2,9],[0,0,0],3,2,wf3(:,1),wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(82),ngZu,m3h3x12(:,688),heltab2x36(:,:,790))
  call Hloop_Q_A(ntryL,G0H12(82),20,0,G1H12(262),n2h12(208))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(849),h0tab(:,849),[20,2,9],[nMW,0,nMW],3,2,wf3(:,1),wf6(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(263),m3h3x12(:,689),heltab2x36(:,:,791))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(850),h0tab(:,850),[16,4,11],[nML,nML,nML],3,1,wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(83),ngZl,m3h3x12(:,690),heltab2x36(:,:,792))
  call Hloop_Q_A(ntryL,G0H12(83),16,nML,G1H12(264),n2h12(209))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(851),h0tab(:,851),[16,4,11],[nML,nML,nML],3,1,wf12(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(84),ngZl,m3h3x12(:,691),heltab2x36(:,:,793))
  call Hloop_A_Q(ntryL,G0H12(84),16,nML,G1H12(265),n2h12(210))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(852),h0tab(:,852),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(86),ngZu,m3h3x12(:,692),heltab2x36(:,:,794))
  call Hloop_Q_A(ntryL,G0H12(86),16,nMT,G1H12(266),n2h12(211))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(853),h0tab(:,853),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(98),ngZu,m3h3x12(:,693),heltab2x36(:,:,795))
  call Hloop_A_Q(ntryL,G0H12(98),16,nMT,G1H12(267),n2h12(212))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(854),h0tab(:,854),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(55),ngZd,m3h3x12(:,694),heltab2x36(:,:,796))
  call Hloop_Q_A(ntryL,G0H12(55),16,nMB,G1H12(268),n2h12(213))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(855),h0tab(:,855),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(57),ngZd,m3h3x12(:,695),heltab2x36(:,:,797))
  call Hloop_A_Q(ntryL,G0H12(57),16,nMB,G1H12(269),n2h12(214))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(856),h0tab(:,856),[16,4,11],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(59),ngZl,m3h3x12(:,696),heltab2x36(:,:,798))
  call Hloop_Q_A(ntryL,G0H12(59),16,nML,G1H12(270),n2h12(215))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(857),h0tab(:,857),[16,4,11],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(85),ngZl,m3h3x12(:,697),heltab2x36(:,:,799))
  call Hloop_A_Q(ntryL,G0H12(85),16,nML,G1H12(271),n2h12(216))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(858),h0tab(:,858),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(87),ngZu,m3h3x12(:,698),heltab2x36(:,:,800))
  call Hloop_Q_A(ntryL,G0H12(87),16,nMT,G1H12(272),n2h12(217))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(859),h0tab(:,859),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(71),ngZu,m3h3x12(:,699),heltab2x36(:,:,801))
  call Hloop_A_Q(ntryL,G0H12(71),16,nMT,G1H12(273),n2h12(218))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(860),h0tab(:,860),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(80),ngZd,m3h3x12(:,700),heltab2x36(:,:,802))
  call Hloop_Q_A(ntryL,G0H12(80),16,nMB,G1H12(274),n2h12(219))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(861),h0tab(:,861),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(81),ngZd,m3h3x12(:,701),heltab2x36(:,:,803))
  call Hloop_A_Q(ntryL,G0H12(81),16,nMB,G1H12(275),n2h12(220))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(862),h0tab(:,862),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(276),m3h3x12(:,702),heltab2x36(:,:,804))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(863),h0tab(:,863),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(277),m3h3x12(:,703),heltab2x36(:,:,805))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(864),h0tab(:,864),[16,4,11],[nMH,nMH,nMZ],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(278),m3h3x12(:,704),heltab2x36(:,:,806))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(865),h0tab(:,865),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(279),m3h3x12(:,705),heltab2x36(:,:,807))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(866),h0tab(:,866),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(280),m3h3x12(:,706),heltab2x36(:,:,808))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(867),h0tab(:,867),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(281),m3h3x12(:,707),heltab2x36(:,:,809))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(868),h0tab(:,868),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(282),m3h3x12(:,708),heltab2x36(:,:,810))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(869),h0tab(:,869),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(283),m3h3x12(:,709),heltab2x36(:,:,811))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(870),h0tab(:,870),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(284),m3h3x12(:,710),heltab2x36(:,:,812))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(871),h0tab(:,871),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(285),m3h3x12(:,711),heltab2x36(:,:,813))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(872),h0tab(:,872),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(286),m3h3x12(:,712),heltab2x36(:,:,814))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(873),h0tab(:,873),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(287),m3h3x12(:,713),heltab2x36(:,:,815))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(874),h0tab(:,874),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(288),m3h3x12(:,714),heltab2x36(:,:,816))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(875),h0tab(:,875),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(289),m3h3x12(:,715),heltab2x36(:,:,817))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(876),h0tab(:,876),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(290),m3h3x12(:,716),heltab2x36(:,:,818))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(877),h0tab(:,877),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(291),m3h3x12(:,717),heltab2x36(:,:,819))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(878),h0tab(:,878),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(292),m3h3x12(:,718),heltab2x36(:,:,820))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(879),h0tab(:,879),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(293),m3h3x12(:,719),heltab2x36(:,:,821))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(880),h0tab(:,880),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(82),m3h3x12(:,720),heltab2x36(:,:,822))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(881),h0tab(:,881),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(83),m3h3x12(:,721),heltab2x36(:,:,823))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(882),h0tab(:,882),[16,4,11],[nMH,nMH,nMZ],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(84),m3h3x12(:,722),heltab2x36(:,:,824))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(883),h0tab(:,883),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(86),m3h3x12(:,723),heltab2x36(:,:,825))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(884),h0tab(:,884),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(98),m3h3x12(:,724),heltab2x36(:,:,826))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(885),h0tab(:,885),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(294),m3h3x12(:,725),heltab2x36(:,:,827))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(886),h0tab(:,886),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(295),m3h3x12(:,726),heltab2x36(:,:,828))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(887),h0tab(:,887),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(296),m3h3x12(:,727),heltab2x36(:,:,829))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(888),h0tab(:,888),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(297),m3h3x12(:,728),heltab2x36(:,:,830))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(889),h0tab(:,889),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(298),m3h3x12(:,729),heltab2x36(:,:,831))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(890),h0tab(:,890),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(55),m3h3x12(:,730),heltab2x36(:,:,832))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(891),h0tab(:,891),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,731),heltab2x36(:,:,833))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(892),h0tab(:,892),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(59),m3h3x12(:,732),heltab2x36(:,:,834))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(893),h0tab(:,893),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(85),m3h3x12(:,733),heltab2x36(:,:,835))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(894),h0tab(:,894),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(87),m3h3x12(:,734),heltab2x36(:,:,836))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(895),h0tab(:,895),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(71),m3h3x12(:,735),heltab2x36(:,:,837))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(896),h0tab(:,896),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(80),m3h3x12(:,736),heltab2x36(:,:,838))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(897),h0tab(:,897),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(81),m3h3x12(:,737),heltab2x36(:,:,839))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(898),h0tab(:,898),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(122),m3h3x12(:,738),heltab2x36(:,:,840))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(899),h0tab(:,899),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(299),m3h3x12(:,739),heltab2x36(:,:,841))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(900),h0tab(:,900),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(300),m3h3x12(:,740),heltab2x36(:,:,842))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(901),h0tab(:,901),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(301),m3h3x12(:,741),heltab2x36(:,:,843))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(902),h0tab(:,902),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(302),m3h3x12(:,742),heltab2x36(:,:,844))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(903),h0tab(:,903),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(123),m3h3x12(:,743),heltab2x36(:,:,845))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(904),h0tab(:,904),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(124),m3h3x12(:,744),heltab2x36(:,:,846))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(905),h0tab(:,905),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(125),m3h3x12(:,745),heltab2x36(:,:,847))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(906),h0tab(:,906),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(126),m3h3x12(:,746),heltab2x36(:,:,848))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(907),h0tab(:,907),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(127),m3h3x12(:,747),heltab2x36(:,:,849))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(908),h0tab(:,908),[25,2,4],[0,nMZ,nMZ],3,1,wf18(:,2))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf18(:,2),G0H2(1),ngZu,m3h18x2(:,1),heltab2x36(:,:,850))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(9),n2h2(32))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(909),h0tab(:,909),[25,2,4],[0,nMW,nMW],3,1,wf18(:,2))
  call Hloop_WQ_A(ntryL,G0H36(1),wf18(:,2),G0H2(1),m3h18x2(:,2),heltab2x36(:,:,851))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(10),n2h2(33))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(910),h0tab(:,910),[17,4,10],[nMZ,nMZ,0],3,2,wf6(:,6),wf6(:,4))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,6),G0H6(1),ngZu,m3h6x6(:,15),heltab2x36(:,:,852))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(911),h0tab(:,911),[17,4,10],[nMW,nMW,0],3,2,wf6(:,6),wf6(:,4))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,6),G0H6(2),m3h6x6(:,16),heltab2x36(:,:,853))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(912),h0tab(:,912),[20,1,10],[0,0,0],3,2,wf3(:,1),wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(128),ngZu,m3h3x12(:,748),heltab2x36(:,:,854))
  call Hloop_A_Q(ntryL,G0H12(128),20,0,G1H12(303),n2h12(221))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(913),h0tab(:,913),[20,1,10],[0,nMZ,0],3,2,wf3(:,1),wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(128),ngZu,m3h3x12(:,749),heltab2x36(:,:,855))
  call Hloop_A_Q(ntryL,G0H12(128),20,0,G1H12(304),n2h12(222))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(914),h0tab(:,914),[20,1,10],[0,nMW,0],3,2,wf3(:,1),wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(128),ngZd,m3h3x12(:,750),heltab2x36(:,:,856))
  call Hloop_A_Q(ntryL,G0H12(128),20,0,G1H12(305),n2h12(223))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(915),h0tab(:,915),[20,1,10],[0,0,0],3,2,wf3(:,1),wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,1),G0H12(128),ngZu,m3h3x12(:,751),heltab2x36(:,:,857))
  call Hloop_A_Q(ntryL,G0H12(128),20,0,G1H12(306),n2h12(224))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(916),h0tab(:,916),[20,1,10],[nMW,0,nMW],3,2,wf3(:,1),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(307),m3h3x12(:,752),heltab2x36(:,:,858))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(917),h0tab(:,917),[16,4,11],[nML,nML,nML],3,1,wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(128),ngZl,m3h3x12(:,753),heltab2x36(:,:,859))
  call Hloop_Q_A(ntryL,G0H12(128),16,nML,G1H12(308),n2h12(225))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(918),h0tab(:,918),[16,4,11],[nML,nML,nML],3,1,wf12(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(128),ngZl,m3h3x12(:,754),heltab2x36(:,:,860))
  call Hloop_A_Q(ntryL,G0H12(128),16,nML,G1H12(309),n2h12(226))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(919),h0tab(:,919),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(128),ngZu,m3h3x12(:,755),heltab2x36(:,:,861))
  call Hloop_Q_A(ntryL,G0H12(128),16,nMT,G1H12(310),n2h12(227))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(920),h0tab(:,920),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(128),ngZu,m3h3x12(:,756),heltab2x36(:,:,862))
  call Hloop_A_Q(ntryL,G0H12(128),16,nMT,G1H12(311),n2h12(228))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(921),h0tab(:,921),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(128),ngZd,m3h3x12(:,757),heltab2x36(:,:,863))
  call Hloop_Q_A(ntryL,G0H12(128),16,nMB,G1H12(312),n2h12(229))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(922),h0tab(:,922),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(128),ngZd,m3h3x12(:,758),heltab2x36(:,:,864))
  call Hloop_A_Q(ntryL,G0H12(128),16,nMB,G1H12(313),n2h12(230))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(923),h0tab(:,923),[16,4,11],[nML,nML,nML],3,1,wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(128),ngZl,m3h3x12(:,759),heltab2x36(:,:,865))
  call Hloop_Q_A(ntryL,G0H12(128),16,nML,G1H12(314),n2h12(231))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(924),h0tab(:,924),[16,4,11],[nML,nML,nML],3,1,wf12(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(128),ngZl,m3h3x12(:,760),heltab2x36(:,:,866))
  call Hloop_A_Q(ntryL,G0H12(128),16,nML,G1H12(315),n2h12(232))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(925),h0tab(:,925),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(128),ngZu,m3h3x12(:,761),heltab2x36(:,:,867))
  call Hloop_Q_A(ntryL,G0H12(128),16,nMT,G1H12(316),n2h12(233))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(926),h0tab(:,926),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(128),ngZu,m3h3x12(:,762),heltab2x36(:,:,868))
  call Hloop_A_Q(ntryL,G0H12(128),16,nMT,G1H12(317),n2h12(234))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(927),h0tab(:,927),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(128),ngZd,m3h3x12(:,763),heltab2x36(:,:,869))
  call Hloop_Q_A(ntryL,G0H12(128),16,nMB,G1H12(318),n2h12(235))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(928),h0tab(:,928),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(128),ngZd,m3h3x12(:,764),heltab2x36(:,:,870))
  call Hloop_A_Q(ntryL,G0H12(128),16,nMB,G1H12(319),n2h12(236))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(929),h0tab(:,929),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(320),m3h3x12(:,765),heltab2x36(:,:,871))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(930),h0tab(:,930),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(321),m3h3x12(:,766),heltab2x36(:,:,872))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(931),h0tab(:,931),[16,4,11],[nMH,nMH,nMZ],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(322),m3h3x12(:,767),heltab2x36(:,:,873))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(932),h0tab(:,932),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(323),m3h3x12(:,768),heltab2x36(:,:,874))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(933),h0tab(:,933),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(324),m3h3x12(:,769),heltab2x36(:,:,875))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(934),h0tab(:,934),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(325),m3h3x12(:,770),heltab2x36(:,:,876))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(935),h0tab(:,935),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(326),m3h3x12(:,771),heltab2x36(:,:,877))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(936),h0tab(:,936),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(327),m3h3x12(:,772),heltab2x36(:,:,878))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(937),h0tab(:,937),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(328),m3h3x12(:,773),heltab2x36(:,:,879))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(938),h0tab(:,938),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(329),m3h3x12(:,774),heltab2x36(:,:,880))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(939),h0tab(:,939),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(330),m3h3x12(:,775),heltab2x36(:,:,881))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(940),h0tab(:,940),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(331),m3h3x12(:,776),heltab2x36(:,:,882))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(941),h0tab(:,941),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(332),m3h3x12(:,777),heltab2x36(:,:,883))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(942),h0tab(:,942),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(333),m3h3x12(:,778),heltab2x36(:,:,884))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(943),h0tab(:,943),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(334),m3h3x12(:,779),heltab2x36(:,:,885))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(944),h0tab(:,944),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(335),m3h3x12(:,780),heltab2x36(:,:,886))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(945),h0tab(:,945),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(336),m3h3x12(:,781),heltab2x36(:,:,887))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(946),h0tab(:,946),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(337),m3h3x12(:,782),heltab2x36(:,:,888))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(947),h0tab(:,947),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(128),m3h3x12(:,783),heltab2x36(:,:,889))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(948),h0tab(:,948),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(129),m3h3x12(:,784),heltab2x36(:,:,890))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(949),h0tab(:,949),[16,4,11],[nMH,nMH,nMZ],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(130),m3h3x12(:,785),heltab2x36(:,:,891))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(950),h0tab(:,950),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(131),m3h3x12(:,786),heltab2x36(:,:,892))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(951),h0tab(:,951),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(132),m3h3x12(:,787),heltab2x36(:,:,893))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(952),h0tab(:,952),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(338),m3h3x12(:,788),heltab2x36(:,:,894))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(953),h0tab(:,953),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(339),m3h3x12(:,789),heltab2x36(:,:,895))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(954),h0tab(:,954),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(340),m3h3x12(:,790),heltab2x36(:,:,896))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(955),h0tab(:,955),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(341),m3h3x12(:,791),heltab2x36(:,:,897))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(956),h0tab(:,956),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(342),m3h3x12(:,792),heltab2x36(:,:,898))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(957),h0tab(:,957),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(133),m3h3x12(:,793),heltab2x36(:,:,899))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(958),h0tab(:,958),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(134),m3h3x12(:,794),heltab2x36(:,:,900))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(959),h0tab(:,959),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(135),m3h3x12(:,795),heltab2x36(:,:,901))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(960),h0tab(:,960),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(136),m3h3x12(:,796),heltab2x36(:,:,902))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(961),h0tab(:,961),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(137),m3h3x12(:,797),heltab2x36(:,:,903))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(962),h0tab(:,962),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(138),m3h3x12(:,798),heltab2x36(:,:,904))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(963),h0tab(:,963),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(139),m3h3x12(:,799),heltab2x36(:,:,905))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(964),h0tab(:,964),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(140),m3h3x12(:,800),heltab2x36(:,:,906))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(965),h0tab(:,965),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(141),m3h3x12(:,801),heltab2x36(:,:,907))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(966),h0tab(:,966),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(343),m3h3x12(:,802),heltab2x36(:,:,908))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(967),h0tab(:,967),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(344),m3h3x12(:,803),heltab2x36(:,:,909))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(968),h0tab(:,968),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(345),m3h3x12(:,804),heltab2x36(:,:,910))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(969),h0tab(:,969),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(346),m3h3x12(:,805),heltab2x36(:,:,911))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(970),h0tab(:,970),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(142),m3h3x12(:,806),heltab2x36(:,:,912))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(971),h0tab(:,971),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(143),m3h3x12(:,807),heltab2x36(:,:,913))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(972),h0tab(:,972),[16,4,11],[nMZ,nMZ,nMH],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(144),m3h3x12(:,808),heltab2x36(:,:,914))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(973),h0tab(:,973),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,809),heltab2x36(:,:,915))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(974),h0tab(:,974),[16,4,11],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(146),m3h3x12(:,810),heltab2x36(:,:,916))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(975),h0tab(:,975),[26,1,4],[0,nMZ,nMZ],3,1,wf18(:,4))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf18(:,4),G0H2(1),ngZu,m3h18x2(:,3),heltab2x36(:,:,917))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(8),n2h2(34))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(976),h0tab(:,976),[26,1,4],[0,nMW,nMW],3,1,wf18(:,4))
  call Hloop_WA_Q(ntryL,G0H36(1),wf18(:,4),G0H2(1),m3h18x2(:,4),heltab2x36(:,:,918))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(1),n2h2(35))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(977),h0tab(:,977),[17,2,12],[0,0,0],3,2,wf6(:,6),wf3(:,2))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,17),heltab2x36(:,:,919))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(978),h0tab(:,978),[17,2,12],[nMZ,0,0],3,2,wf6(:,6),wf3(:,2))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,6),G0H6(6),ngZu,m3h6x6(:,18),heltab2x36(:,:,920))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(979),h0tab(:,979),[17,2,12],[nMW,0,0],3,2,wf6(:,6),wf3(:,2))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,6),G0H6(7),m3h6x6(:,19),heltab2x36(:,:,921))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(980),h0tab(:,980),[17,2,12],[0,0,0],3,2,wf6(:,6),wf3(:,2))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(8),m3h6x6(:,20),heltab2x36(:,:,922))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(981),h0tab(:,981),[17,2,12],[0,nMW,nMW],3,2,wf6(:,6),wf3(:,2))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(9),m3h6x6(:,21),heltab2x36(:,:,923))
  call Hloop_Q_A(ntryL,G0H6(9),17,0,G1H6(6),n2h6(85))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(982),h0tab(:,982),[18,1,12],[0,0,0],3,2,wf6(:,8),wf3(:,2))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,8),G0H6(9),m3h6x6(:,22),heltab2x36(:,:,924))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(983),h0tab(:,983),[18,1,12],[nMZ,0,0],3,2,wf6(:,8),wf3(:,2))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,8),G0H6(10),ngZu,m3h6x6(:,23),heltab2x36(:,:,925))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(984),h0tab(:,984),[18,1,12],[nMW,0,0],3,2,wf6(:,8),wf3(:,2))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,8),G0H6(11),m3h6x6(:,24),heltab2x36(:,:,926))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(985),h0tab(:,985),[18,1,12],[0,0,0],3,2,wf6(:,8),wf3(:,2))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,8),G0H6(12),m3h6x6(:,25),heltab2x36(:,:,927))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(986),h0tab(:,986),[18,1,12],[0,nMW,nMW],3,2,wf6(:,8),wf3(:,2))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(13),m3h6x6(:,26),heltab2x36(:,:,928))
  call Hloop_A_Q(ntryL,G0H6(13),18,0,G1H6(11),n2h6(86))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(987),h0tab(:,987),[16,2,13],[0,0,0],3,1,wf6(:,39))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(147),ngZu,m3h3x12(:,811),heltab2x36(:,:,929))
  call Hloop_Q_A(ntryL,G0H12(147),16,0,G1H12(347),n2h12(237))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(988),h0tab(:,988),[16,2,13],[0,nMZ,0],3,1,wf6(:,39))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(147),ngZu,m3h3x12(:,812),heltab2x36(:,:,930))
  call Hloop_Q_A(ntryL,G0H12(147),16,0,G1H12(348),n2h12(238))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(989),h0tab(:,989),[16,2,13],[0,nMW,0],3,1,wf6(:,39))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(147),ngZd,m3h3x12(:,813),heltab2x36(:,:,931))
  call Hloop_Q_A(ntryL,G0H12(147),16,0,G1H12(349),n2h12(239))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(990),h0tab(:,990),[16,2,13],[0,0,0],3,1,wf6(:,39))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(147),ngZu,m3h3x12(:,814),heltab2x36(:,:,932))
  call Hloop_Q_A(ntryL,G0H12(147),16,0,G1H12(350),n2h12(240))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(991),h0tab(:,991),[16,2,13],[nMW,0,nMW],3,1,wf6(:,39))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(351),m3h3x12(:,815),heltab2x36(:,:,933))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(992),h0tab(:,992),[16,1,14],[0,0,0],3,1,wf6(:,35))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(147),ngZu,m3h3x12(:,816),heltab2x36(:,:,934))
  call Hloop_A_Q(ntryL,G0H12(147),16,0,G1H12(352),n2h12(241))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(993),h0tab(:,993),[16,1,14],[0,nMZ,0],3,1,wf6(:,35))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(147),ngZu,m3h3x12(:,817),heltab2x36(:,:,935))
  call Hloop_A_Q(ntryL,G0H12(147),16,0,G1H12(353),n2h12(242))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(994),h0tab(:,994),[16,1,14],[0,nMW,0],3,1,wf6(:,35))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(147),ngZd,m3h3x12(:,818),heltab2x36(:,:,936))
  call Hloop_A_Q(ntryL,G0H12(147),16,0,G1H12(354),n2h12(243))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(995),h0tab(:,995),[16,1,14],[0,0,0],3,1,wf6(:,35))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(147),ngZu,m3h3x12(:,819),heltab2x36(:,:,937))
  call Hloop_A_Q(ntryL,G0H12(147),16,0,G1H12(355),n2h12(244))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(996),h0tab(:,996),[16,1,14],[nMW,0,nMW],3,1,wf6(:,35))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(356),m3h3x12(:,820),heltab2x36(:,:,938))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(997),h0tab(:,997),[28,1,2],[nMZ,0,nMZ],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(47),m3h9x4(:,63),heltab2x36(:,:,939))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(998),h0tab(:,998),[28,1,2],[nMW,0,nMW],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(48),m3h9x4(:,64),heltab2x36(:,:,940))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(999),h0tab(:,999),[28,1,2],[nMZ,0,nMZ],3,1,wf9(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,4),G0H4(49),m3h9x4(:,65),heltab2x36(:,:,941))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1000),h0tab(:,1000),[28,1,2],[nMW,0,nMW],3,1,wf9(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,4),G0H4(50),m3h9x4(:,66),heltab2x36(:,:,942))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1001),h0tab(:,1001),[19,4,8],[nML,nML,nML],3,1,wf12(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,27),heltab2x36(:,:,943))
  call Hloop_A_Q(ntryL,G0H3(29),19,nML,G1H3(91),n2h3(147))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1002),h0tab(:,1002),[19,4,8],[nML,nML,nML],3,1,wf12(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,28),heltab2x36(:,:,944))
  call Hloop_Q_A(ntryL,G0H3(29),19,nML,G1H3(101),n2h3(148))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1003),h0tab(:,1003),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,29),heltab2x36(:,:,945))
  call Hloop_A_Q(ntryL,G0H3(29),19,nMT,G1H3(100),n2h3(149))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1004),h0tab(:,1004),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,30),heltab2x36(:,:,946))
  call Hloop_Q_A(ntryL,G0H3(29),19,nMT,G1H3(94),n2h3(150))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1005),h0tab(:,1005),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,31),heltab2x36(:,:,947))
  call Hloop_A_Q(ntryL,G0H3(29),19,nMB,G1H3(106),n2h3(151))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1006),h0tab(:,1006),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,32),heltab2x36(:,:,948))
  call Hloop_Q_A(ntryL,G0H3(29),19,nMB,G1H3(112),n2h3(152))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1007),h0tab(:,1007),[19,4,8],[nML,nML,nML],3,1,wf12(:,3))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,3),G0H3(29),ngZl,m3h12x3(:,33),heltab2x36(:,:,949))
  call Hloop_A_Q(ntryL,G0H3(29),19,nML,G1H3(113),n2h3(153))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1008),h0tab(:,1008),[19,4,8],[nML,nML,nML],3,1,wf12(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(29),ngZl,m3h12x3(:,34),heltab2x36(:,:,950))
  call Hloop_Q_A(ntryL,G0H3(29),19,nML,G1H3(118),n2h3(154))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1009),h0tab(:,1009),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,3))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,3),G0H3(29),ngZu,m3h12x3(:,35),heltab2x36(:,:,951))
  call Hloop_A_Q(ntryL,G0H3(29),19,nMT,G1H3(120),n2h3(155))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1010),h0tab(:,1010),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(29),ngZu,m3h12x3(:,36),heltab2x36(:,:,952))
  call Hloop_Q_A(ntryL,G0H3(29),19,nMT,G1H3(122),n2h3(156))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1011),h0tab(:,1011),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,3))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,3),G0H3(29),ngZd,m3h12x3(:,37),heltab2x36(:,:,953))
  call Hloop_A_Q(ntryL,G0H3(29),19,nMB,G1H3(59),n2h3(157))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1012),h0tab(:,1012),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(29),ngZd,m3h12x3(:,38),heltab2x36(:,:,954))
  call Hloop_Q_A(ntryL,G0H3(29),19,nMB,G1H3(2),n2h3(158))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1013),h0tab(:,1013),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(17),m3h12x3(:,39),heltab2x36(:,:,955))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1014),h0tab(:,1014),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(124),m3h12x3(:,40),heltab2x36(:,:,956))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1015),h0tab(:,1015),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(126),m3h12x3(:,41),heltab2x36(:,:,957))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1016),h0tab(:,1016),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(10),m3h12x3(:,42),heltab2x36(:,:,958))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1017),h0tab(:,1017),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(66),m3h12x3(:,43),heltab2x36(:,:,959))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1018),h0tab(:,1018),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(131),m3h12x3(:,44),heltab2x36(:,:,960))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1019),h0tab(:,1019),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,7),G1H3(82),m3h12x3(:,45),heltab2x36(:,:,961))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1020),h0tab(:,1020),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(20),m3h12x3(:,46),heltab2x36(:,:,962))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1021),h0tab(:,1021),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,7),G1H3(134),m3h12x3(:,47),heltab2x36(:,:,963))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1022),h0tab(:,1022),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(102),m3h12x3(:,48),heltab2x36(:,:,964))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1023),h0tab(:,1023),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,3),G1H3(29),m3h12x3(:,49),heltab2x36(:,:,965))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1024),h0tab(:,1024),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(18),m3h12x3(:,50),heltab2x36(:,:,966))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1025),h0tab(:,1025),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,3),G1H3(1),m3h12x3(:,51),heltab2x36(:,:,967))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1026),h0tab(:,1026),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(30),m3h12x3(:,52),heltab2x36(:,:,968))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1027),h0tab(:,1027),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(33),m3h12x3(:,53),heltab2x36(:,:,969))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1028),h0tab(:,1028),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(34),m3h12x3(:,54),heltab2x36(:,:,970))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1029),h0tab(:,1029),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(55),m3h12x3(:,55),heltab2x36(:,:,971))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1030),h0tab(:,1030),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(56),m3h12x3(:,56),heltab2x36(:,:,972))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1031),h0tab(:,1031),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(29),m3h12x3(:,57),heltab2x36(:,:,973))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1032),h0tab(:,1032),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(30),m3h12x3(:,58),heltab2x36(:,:,974))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1033),h0tab(:,1033),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,3),G0H3(31),m3h12x3(:,59),heltab2x36(:,:,975))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1034),h0tab(:,1034),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,3),G0H3(32),m3h12x3(:,60),heltab2x36(:,:,976))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1035),h0tab(:,1035),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,3),G0H3(33),m3h12x3(:,61),heltab2x36(:,:,977))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1036),h0tab(:,1036),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(34),m3h12x3(:,62),heltab2x36(:,:,978))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1037),h0tab(:,1037),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(35),m3h12x3(:,63),heltab2x36(:,:,979))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1038),h0tab(:,1038),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(36),m3h12x3(:,64),heltab2x36(:,:,980))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1039),h0tab(:,1039),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(37),m3h12x3(:,65),heltab2x36(:,:,981))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1040),h0tab(:,1040),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(38),m3h12x3(:,66),heltab2x36(:,:,982))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1041),h0tab(:,1041),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(61),m3h12x3(:,67),heltab2x36(:,:,983))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1042),h0tab(:,1042),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(79),m3h12x3(:,68),heltab2x36(:,:,984))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1043),h0tab(:,1043),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(148),m3h12x3(:,69),heltab2x36(:,:,985))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1044),h0tab(:,1044),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(97),m3h12x3(:,70),heltab2x36(:,:,986))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1045),h0tab(:,1045),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(96),m3h12x3(:,71),heltab2x36(:,:,987))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1046),h0tab(:,1046),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(99),m3h12x3(:,72),heltab2x36(:,:,988))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1047),h0tab(:,1047),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(103),m3h12x3(:,73),heltab2x36(:,:,989))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1048),h0tab(:,1048),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(26),m3h12x3(:,74),heltab2x36(:,:,990))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1049),h0tab(:,1049),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(4),m3h12x3(:,75),heltab2x36(:,:,991))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1050),h0tab(:,1050),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(39),m3h12x3(:,76),heltab2x36(:,:,992))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1051),h0tab(:,1051),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,7),G0H3(40),m3h12x3(:,77),heltab2x36(:,:,993))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1052),h0tab(:,1052),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,3),G0H3(41),m3h12x3(:,78),heltab2x36(:,:,994))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1053),h0tab(:,1053),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,3),G0H3(42),m3h12x3(:,79),heltab2x36(:,:,995))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1054),h0tab(:,1054),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(43),m3h12x3(:,80),heltab2x36(:,:,996))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1055),h0tab(:,1055),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(44),m3h12x3(:,81),heltab2x36(:,:,997))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1056),h0tab(:,1056),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(45),m3h12x3(:,82),heltab2x36(:,:,998))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1057),h0tab(:,1057),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(46),m3h12x3(:,83),heltab2x36(:,:,999))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1058),h0tab(:,1058),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(47),m3h12x3(:,84),heltab2x36(:,:,1000))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1059),h0tab(:,1059),[25,2,4],[0,nMZ,nMZ],3,1,wf18(:,6))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf18(:,6),G0H2(1),ngZu,m3h18x2(:,5),heltab2x36(:,:,1001))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(2),n2h2(36))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1060),h0tab(:,1060),[25,2,4],[0,nMW,nMW],3,1,wf18(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf18(:,6),G0H2(1),m3h18x2(:,6),heltab2x36(:,:,1002))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(12),n2h2(37))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1061),h0tab(:,1061),[19,4,8],[nML,nML,nML],3,1,wf12(:,8))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,85),heltab2x36(:,:,1003))
  call Hloop_A_Q(ntryL,G0H3(48),19,nML,G1H3(9),n2h3(159))
  Gcoeff(:)%j = (c(182)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1062),h0tab(:,1062),[19,4,8],[nML,nML,nML],3,1,wf12(:,8))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,86),heltab2x36(:,:,1004))
  call Hloop_Q_A(ntryL,G0H3(48),19,nML,G1H3(28),n2h3(160))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1063),h0tab(:,1063),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,8))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,87),heltab2x36(:,:,1005))
  call Hloop_A_Q(ntryL,G0H3(48),19,nMT,G1H3(31),n2h3(161))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1064),h0tab(:,1064),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,8))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,88),heltab2x36(:,:,1006))
  call Hloop_Q_A(ntryL,G0H3(48),19,nMT,G1H3(164),n2h3(162))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1065),h0tab(:,1065),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,8))
  call Hloop_AV_Q(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,89),heltab2x36(:,:,1007))
  call Hloop_A_Q(ntryL,G0H3(48),19,nMB,G1H3(45),n2h3(163))
  Gcoeff(:)%j = (c(180)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1066),h0tab(:,1066),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,8))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,90),heltab2x36(:,:,1008))
  call Hloop_Q_A(ntryL,G0H3(48),19,nMB,G1H3(47),n2h3(164))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1067),h0tab(:,1067),[19,4,8],[nML,nML,nML],3,1,wf12(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,4),G0H3(48),ngZl,m3h12x3(:,91),heltab2x36(:,:,1009))
  call Hloop_A_Q(ntryL,G0H3(48),19,nML,G1H3(51),n2h3(165))
  Gcoeff(:)%j = (-(c(183)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1068),h0tab(:,1068),[19,4,8],[nML,nML,nML],3,1,wf12(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(48),ngZl,m3h12x3(:,92),heltab2x36(:,:,1010))
  call Hloop_Q_A(ntryL,G0H3(48),19,nML,G1H3(57),n2h3(166))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1069),h0tab(:,1069),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,4),G0H3(48),ngZu,m3h12x3(:,93),heltab2x36(:,:,1011))
  call Hloop_A_Q(ntryL,G0H3(48),19,nMT,G1H3(104),n2h3(167))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1070),h0tab(:,1070),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(48),ngZu,m3h12x3(:,94),heltab2x36(:,:,1012))
  call Hloop_Q_A(ntryL,G0H3(48),19,nMT,G1H3(62),n2h3(168))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1071),h0tab(:,1071),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf12(:,4),G0H3(48),ngZd,m3h12x3(:,95),heltab2x36(:,:,1013))
  call Hloop_A_Q(ntryL,G0H3(48),19,nMB,G1H3(68),n2h3(169))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1072),h0tab(:,1072),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(48),ngZd,m3h12x3(:,96),heltab2x36(:,:,1014))
  call Hloop_Q_A(ntryL,G0H3(48),19,nMB,G1H3(69),n2h3(170))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1073),h0tab(:,1073),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(161),m3h12x3(:,97),heltab2x36(:,:,1015))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1074),h0tab(:,1074),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(162),m3h12x3(:,98),heltab2x36(:,:,1016))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1075),h0tab(:,1075),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(80),m3h12x3(:,99),heltab2x36(:,:,1017))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1076),h0tab(:,1076),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(81),m3h12x3(:,100),heltab2x36(:,:,1018))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1077),h0tab(:,1077),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(48),m3h12x3(:,101),heltab2x36(:,:,1019))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1078),h0tab(:,1078),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(43),m3h12x3(:,102),heltab2x36(:,:,1020))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1079),h0tab(:,1079),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,8),G1H3(153),m3h12x3(:,103),heltab2x36(:,:,1021))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1080),h0tab(:,1080),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(156),m3h12x3(:,104),heltab2x36(:,:,1022))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1081),h0tab(:,1081),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,8),G1H3(157),m3h12x3(:,105),heltab2x36(:,:,1023))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1082),h0tab(:,1082),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(158),m3h12x3(:,106),heltab2x36(:,:,1024))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1083),h0tab(:,1083),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,4),G1H3(165),m3h12x3(:,107),heltab2x36(:,:,1025))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1084),h0tab(:,1084),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(166),m3h12x3(:,108),heltab2x36(:,:,1026))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1085),h0tab(:,1085),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf12(:,4),G1H3(167),m3h12x3(:,109),heltab2x36(:,:,1027))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1086),h0tab(:,1086),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(170),m3h12x3(:,110),heltab2x36(:,:,1028))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1087),h0tab(:,1087),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(171),m3h12x3(:,111),heltab2x36(:,:,1029))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1088),h0tab(:,1088),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(172),m3h12x3(:,112),heltab2x36(:,:,1030))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1089),h0tab(:,1089),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(175),m3h12x3(:,113),heltab2x36(:,:,1031))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1090),h0tab(:,1090),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(176),m3h12x3(:,114),heltab2x36(:,:,1032))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1091),h0tab(:,1091),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,8),G0H3(48),m3h12x3(:,115),heltab2x36(:,:,1033))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1092),h0tab(:,1092),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,8),G0H3(49),m3h12x3(:,116),heltab2x36(:,:,1034))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1093),h0tab(:,1093),[19,4,8],[nMH,nMH,nMZ],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,4),G0H3(50),m3h12x3(:,117),heltab2x36(:,:,1035))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1094),h0tab(:,1094),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,4),G0H3(51),m3h12x3(:,118),heltab2x36(:,:,1036))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1095),h0tab(:,1095),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,4),G0H3(52),m3h12x3(:,119),heltab2x36(:,:,1037))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1096),h0tab(:,1096),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(53),m3h12x3(:,120),heltab2x36(:,:,1038))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1097),h0tab(:,1097),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(54),m3h12x3(:,121),heltab2x36(:,:,1039))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1098),h0tab(:,1098),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(55),m3h12x3(:,122),heltab2x36(:,:,1040))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1099),h0tab(:,1099),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(56),m3h12x3(:,123),heltab2x36(:,:,1041))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1100),h0tab(:,1100),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(57),m3h12x3(:,124),heltab2x36(:,:,1042))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1101),h0tab(:,1101),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(177),m3h12x3(:,125),heltab2x36(:,:,1043))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1102),h0tab(:,1102),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(180),m3h12x3(:,126),heltab2x36(:,:,1044))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1103),h0tab(:,1103),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(181),m3h12x3(:,127),heltab2x36(:,:,1045))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1104),h0tab(:,1104),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(182),m3h12x3(:,128),heltab2x36(:,:,1046))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1105),h0tab(:,1105),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(185),m3h12x3(:,129),heltab2x36(:,:,1047))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1106),h0tab(:,1106),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(49),m3h12x3(:,130),heltab2x36(:,:,1048))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1107),h0tab(:,1107),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(186),m3h12x3(:,131),heltab2x36(:,:,1049))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1108),h0tab(:,1108),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(189),m3h12x3(:,132),heltab2x36(:,:,1050))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1109),h0tab(:,1109),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(78),m3h12x3(:,133),heltab2x36(:,:,1051))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1110),h0tab(:,1110),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,8),G0H3(58),m3h12x3(:,134),heltab2x36(:,:,1052))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1111),h0tab(:,1111),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,8),G0H3(59),m3h12x3(:,135),heltab2x36(:,:,1053))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1112),h0tab(:,1112),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,4),G0H3(60),m3h12x3(:,136),heltab2x36(:,:,1054))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1113),h0tab(:,1113),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H36(1),wf12(:,4),G0H3(61),m3h12x3(:,137),heltab2x36(:,:,1055))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1114),h0tab(:,1114),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(62),m3h12x3(:,138),heltab2x36(:,:,1056))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1115),h0tab(:,1115),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(63),m3h12x3(:,139),heltab2x36(:,:,1057))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1116),h0tab(:,1116),[19,4,8],[nMZ,nMZ,nMH],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(64),m3h12x3(:,140),heltab2x36(:,:,1058))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1117),h0tab(:,1117),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(65),m3h12x3(:,141),heltab2x36(:,:,1059))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1118),h0tab(:,1118),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(66),m3h12x3(:,142),heltab2x36(:,:,1060))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1119),h0tab(:,1119),[26,1,4],[0,nMZ,nMZ],3,1,wf18(:,8))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf18(:,8),G0H2(1),ngZu,m3h18x2(:,7),heltab2x36(:,:,1061))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(11),n2h2(38))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1120),h0tab(:,1120),[26,1,4],[0,nMW,nMW],3,1,wf18(:,8))
  call Hloop_WA_Q(ntryL,G0H36(1),wf18(:,8),G0H2(1),m3h18x2(:,8),heltab2x36(:,:,1062))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(4),n2h2(39))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1121),h0tab(:,1121),[21,2,8],[0,0,0],3,1,wf6(:,31))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,31),G0H6(13),m3h6x6(:,27),heltab2x36(:,:,1063))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1122),h0tab(:,1122),[21,2,8],[nMZ,0,0],3,1,wf6(:,31))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,31),G0H6(14),ngZu,m3h6x6(:,28),heltab2x36(:,:,1064))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1123),h0tab(:,1123),[21,2,8],[nMW,0,0],3,1,wf6(:,31))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,31),G0H6(15),m3h6x6(:,29),heltab2x36(:,:,1065))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1124),h0tab(:,1124),[21,2,8],[0,0,0],3,1,wf6(:,31))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,31),G0H6(16),m3h6x6(:,30),heltab2x36(:,:,1066))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1125),h0tab(:,1125),[21,2,8],[0,nMW,nMW],3,1,wf6(:,31))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,31),G0H6(17),m3h6x6(:,31),heltab2x36(:,:,1067))
  call Hloop_Q_A(ntryL,G0H6(17),21,0,G1H6(25),n2h6(87))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1126),h0tab(:,1126),[22,1,8],[0,0,0],3,1,wf6(:,27))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,27),G0H6(17),m3h6x6(:,32),heltab2x36(:,:,1068))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1127),h0tab(:,1127),[22,1,8],[nMZ,0,0],3,1,wf6(:,27))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,27),G0H6(18),ngZu,m3h6x6(:,33),heltab2x36(:,:,1069))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1128),h0tab(:,1128),[22,1,8],[nMW,0,0],3,1,wf6(:,27))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,27),G0H6(19),m3h6x6(:,34),heltab2x36(:,:,1070))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1129),h0tab(:,1129),[22,1,8],[0,0,0],3,1,wf6(:,27))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,27),G0H6(20),m3h6x6(:,35),heltab2x36(:,:,1071))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1130),h0tab(:,1130),[22,1,8],[0,nMW,nMW],3,1,wf6(:,27))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,27),G0H6(21),m3h6x6(:,36),heltab2x36(:,:,1072))
  call Hloop_A_Q(ntryL,G0H6(21),22,0,G1H6(13),n2h6(88))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1131),h0tab(:,1131),[28,1,2],[nMZ,0,nMZ],3,1,wf9(:,5))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,5),G0H4(51),m3h9x4(:,67),heltab2x36(:,:,1073))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1132),h0tab(:,1132),[28,1,2],[nMW,0,nMW],3,1,wf9(:,5))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,5),G0H4(52),m3h9x4(:,68),heltab2x36(:,:,1074))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1133),h0tab(:,1133),[28,1,2],[nMZ,0,nMZ],3,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(53),m3h9x4(:,69),heltab2x36(:,:,1075))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1134),h0tab(:,1134),[28,1,2],[nMW,0,nMW],3,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(54),m3h9x4(:,70),heltab2x36(:,:,1076))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1135),h0tab(:,1135),[28,1,2],[nMZ,0,nMZ],3,1,wf9(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(55),m3h9x4(:,71),heltab2x36(:,:,1077))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1136),h0tab(:,1136),[28,1,2],[nMW,0,nMW],3,1,wf9(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(56),m3h9x4(:,72),heltab2x36(:,:,1078))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(78),[G1H3(189),G1H3(186),G1H3(49),G1H3(4),G1H3(26) &
    ,G1H3(103),G1H3(99),G1H3(16),G0H3(28),G0H3(27),G0H3(5),G0H3(6),G0H3(19),G0H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(51),[G1H3(9),G1H3(113),G1H3(91),G1H3(136),G1H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(57),[G1H3(28),G1H3(118),G1H3(101),G1H3(137),G1H3(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(104),[G1H3(31),G1H3(120),G1H3(100),G1H3(72),G1H3(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(164),G1H3(122),G1H3(94),G1H3(139),G1H3(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(68),[G1H3(45),G1H3(59),G1H3(106),G1H3(141),G1H3(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(69),[G1H3(47),G1H3(2),G1H3(112),G1H3(3),G1H3(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(185),[G1H3(182),G1H3(180),G1H3(177),G1H3(96),G1H3(97) &
    ,G1H3(79),G1H3(61),G1H3(88),G0H3(26),G0H3(25),G0H3(22),G0H3(7),G0H3(24),G0H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(65),[G1H12(3),G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(67),[G1H12(2),G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(70),[G1H12(27),G1H12(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(72),[G1H12(28),G1H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(79),[G1H12(30),G1H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(81),[G1H12(31),G1H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(86),[G1H12(32),G1H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(89),[G1H12(34),G1H12(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(91),[G1H12(37),G1H12(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(96),[G1H12(38),G1H12(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(100),[G1H12(39),G1H12(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(103),[G1H12(40),G1H12(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(47),[G1H12(87),G0H12(103),G0H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(48),[G1H12(92),G0H12(104),G0H12(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(49),[G1H12(101),G0H12(105),G0H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(50),[G1H12(106),G0H12(106),G0H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(52),[G1H12(110),G0H12(107),G0H12(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(54),[G1H12(1),G0H12(108),G0H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(56),[G1H12(115),G0H12(109),G0H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(57),[G1H12(33),G0H12(117),G0H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(48),[G1H3(161),G1H3(66),G1H3(17),G0H3(11),G0H3(1) &
    ,G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(162),G1H3(131),G1H3(124),G0H3(9),G0H3(14) &
    ,G0H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(175),[G1H3(171),G1H3(55),G1H3(33),G0H3(12),G0H3(2) &
    ,G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(176),[G1H3(172),G1H3(56),G1H3(34),G0H3(10),G0H3(21) &
    ,G0H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(53),[G1H12(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(55),[G1H12(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(122),[G1H12(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(124),[G1H12(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(13),[G0H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(15),[G0H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(17),[G0H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(19),[G0H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(23),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(24),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(25),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(26),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(35),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(36),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(37),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(38),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(40),[G0H4(39),G0H4(10),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(42),[G0H4(41),G0H4(12),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(44),[G0H4(43),G0H4(14),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(46),[G0H4(45),G0H4(16),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(128),[G1H12(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(132),[G1H12(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(134),[G1H12(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(136),[G1H12(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G0H12(99),G0H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(43),[G0H12(100),G0H12(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(44),[G0H12(101),G0H12(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(45),[G0H12(102),G0H12(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(59),[G0H12(4),G0H12(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(60),[G0H12(118),G0H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(61),[G0H12(27),G0H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(62),[G0H12(53),G0H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(140),[G1H12(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(142),[G1H12(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(144),[G1H12(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(146),[G1H12(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(56),[G0H4(54),G0H4(52),G0H4(50),G0H4(48),G0H4(22) &
    ,G0H4(20),G0H4(18),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(55),[G0H4(53),G0H4(51),G0H4(49),G0H4(47),G0H4(21) &
    ,G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(163),[G1H12(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(164),[G1H12(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(167),[G1H12(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(168),[G1H12(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(170),[G1H12(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(173),[G1H12(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(175),[G1H12(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(178),[G1H12(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(97),[G1H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(99),[G1H12(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(15),[G1H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(21),[G1H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(13),[G1H12(109),G0H12(10),G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(111),[G1H12(7),G0H12(11),G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(113),[G1H12(19),G0H12(3),G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(23),[G1H12(112),G0H12(60),G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(117),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(35),[G1H12(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(198),[G1H12(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(200),[G1H12(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(29),[G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(30),[G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(33),[G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(34),[G0H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(209),[G1H12(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(210),[G1H12(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(212),[G1H12(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(214),[G1H12(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(233),[G1H12(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(234),[G1H12(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(238),[G1H12(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(240),[G1H12(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(248),[G1H12(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(251),[G1H12(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(252),[G1H12(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(254),[G1H12(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(64),[G0H12(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(256),[G1H12(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(66),[G0H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(68),[G0H12(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(258),[G1H12(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(70),[G0H12(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(167),[G1H3(165),G1H3(157),G1H3(153),G1H3(1),G1H3(29) &
    ,G1H3(134),G1H3(82),G0H3(18),G0H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(170),[G1H3(166),G1H3(158),G1H3(156),G1H3(30),G1H3(18) &
    ,G1H3(102),G1H3(20),G0H3(17),G0H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(85),[G1H3(143),G0H3(52),G0H3(51),G0H3(49),G0H3(48) &
    ,G0H3(33),G0H3(32),G0H3(30),G0H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(144),[G0H3(56),G0H3(53),G0H3(37),G0H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(147),[G0H3(57),G0H3(54),G0H3(38),G0H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(86),[G0H3(60),G0H3(58),G0H3(41),G0H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(84),[G0H3(61),G0H3(59),G0H3(42),G0H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(11),[G1H3(150),G0H3(66),G0H3(65),G0H3(63),G0H3(62) &
    ,G0H3(47),G0H3(46),G0H3(44),G0H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(262),[G1H12(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(284),[G1H12(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(285),[G1H12(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(288),[G1H12(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(289),[G1H12(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(83),[G0H12(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(98),[G0H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(295),[G1H12(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(298),[G1H12(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(300),[G1H12(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(302),[G1H12(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(124),[G0H12(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(127),[G0H12(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(306),[G1H12(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(328),[G1H12(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(329),[G1H12(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(332),[G1H12(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(333),[G1H12(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(129),[G0H12(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(132),[G0H12(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(339),[G1H12(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(342),[G1H12(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(344),[G1H12(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(346),[G1H12(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(143),[G0H12(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(146),[G0H12(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(8),[G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(12),[G0H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(350),[G1H12(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(355),[G1H12(352)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(80),[G1H3(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(81),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(50),[G0H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(55),[G0H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(181),[G1H3(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(64),[G0H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(20),[G0H6(17)])
  call Hloop_QZ_A(ntryL,G1H6(18),ex4(:),G1H2(9),ngZd,m3h3x2(:,26),heltab2x6(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(9),29,0,G2H2(5),n2h2(40))
  call Hloop_VT_S(ntryL,G1H3(78),19,ex3(:),4,G2H3(14),m3h1x3(:,77),heltab2x3(:,:,407))
  call Hloop_UW_V(ntryL,G1H3(14),19,ex4(:),8,G2H1(1),m3h3x1(:,331),heltab2x3(:,:,408))
  call Hloop_UV_W(ntryL,G1H3(37),19,ex4(:),8,G2H1(2),m3h3x1(:,332),heltab2x3(:,:,409))
  call Hloop_QZ_A(ntryL,G1H3(64),ex4(:),G1H1(63),ngZl,m3h3x1(:,333),heltab2x3(:,:,410))
  call Hloop_Q_A(ntryL,G1H1(63),27,nML,G2H1(3),n2h1(231))
  call Hloop_AZ_Q(ntryL,G1H3(77),ex4(:),G1H1(27),ngZl,m3h3x1(:,334),heltab2x3(:,:,411))
  call Hloop_A_Q(ntryL,G1H1(27),27,nML,G2H1(4),n2h1(232))
  call Hloop_QZ_A(ntryL,G1H3(36),ex4(:),G1H1(28),ngZu,m3h3x1(:,335),heltab2x3(:,:,412))
  call Hloop_Q_A(ntryL,G1H1(28),27,nMT,G2H1(5),n2h1(233))
  call Hloop_AZ_Q(ntryL,G1H3(12),ex4(:),G1H1(29),ngZu,m3h3x1(:,336),heltab2x3(:,:,413))
  call Hloop_A_Q(ntryL,G1H1(29),27,nMT,G2H1(6),n2h1(234))
  call Hloop_QZ_A(ntryL,G1H3(95),ex4(:),G1H1(30),ngZd,m3h3x1(:,337),heltab2x3(:,:,414))
  call Hloop_Q_A(ntryL,G1H1(30),27,nMB,G2H1(50),n2h1(235))
  call Hloop_AZ_Q(ntryL,G1H3(90),ex4(:),G1H1(34),ngZd,m3h3x1(:,338),heltab2x3(:,:,415))
  call Hloop_A_Q(ntryL,G1H1(34),27,nMB,G2H1(26),n2h1(236))
  call Hloop_TV_S(ntryL,G1H3(93),19,ex4(:),8,G2H1(19),m3h3x1(:,339),heltab2x3(:,:,416))
  call Hloop_SV_T(ntryL,G1H3(111),19,ex4(:),8,G2H1(21),m3h3x1(:,340),heltab2x3(:,:,417))
  call Hloop_CV_D(ntryL,G1H3(116),19,ex4(:),8,G2H1(28),m3h3x1(:,341),heltab2x3(:,:,418))
  call Hloop_DV_C(ntryL,G1H3(121),19,ex4(:),G2H1(29),m3h3x1(:,342),heltab2x3(:,:,419))
  call Hloop_AS_Q(ntryL,G1H3(51),ex3(:),G1H3(190),ngH,m3h1x3(:,78),heltab2x3(:,:,420))
  call Hloop_A_Q(ntryL,G1H3(190),23,nML,G2H3(147),n2h3(171))
  call Hloop_QS_A(ntryL,G1H3(57),ex3(:),G1H3(193),ngH,m3h1x3(:,79),heltab2x3(:,:,421))
  call Hloop_Q_A(ntryL,G1H3(193),23,nML,G2H3(144),n2h3(172))
  call Hloop_AS_Q(ntryL,G1H3(104),ex3(:),G1H3(65),ngH,m3h1x3(:,80),heltab2x3(:,:,422))
  call Hloop_A_Q(ntryL,G1H3(65),23,nMT,G2H3(141),n2h3(173))
  call Hloop_QS_A(ntryL,G1H3(62),ex3(:),G1H3(194),ngH,m3h1x3(:,81),heltab2x3(:,:,423))
  call Hloop_Q_A(ntryL,G1H3(194),23,nMT,G2H3(23),n2h3(174))
  call Hloop_AS_Q(ntryL,G1H3(68),ex3(:),G1H3(197),ngH,m3h1x3(:,82),heltab2x3(:,:,424))
  call Hloop_A_Q(ntryL,G1H3(197),23,nMB,G2H3(17),n2h3(175))
  call Hloop_QS_A(ntryL,G1H3(69),ex3(:),G1H3(71),ngH,m3h1x3(:,83),heltab2x3(:,:,425))
  call Hloop_Q_A(ntryL,G1H3(71),23,nMB,G2H3(70),n2h3(176))
  call Hloop_ST_V(ntryL,G1H3(185),19,ex3(:),4,G2H3(56),m3h1x3(:,84),heltab2x3(:,:,426))
  call Hloop_QV_A(ntryL,G1H12(65),wf4(:,1),G1H3(198),m3h4x3(:,241),heltab2x12(:,:,451))
  call Hloop_Q_A(ntryL,G1H3(198),23,nML,G2H3(52),n2h3(177))
  call Hloop_AV_Q(ntryL,G1H12(67),wf4(:,1),G1H3(201),m3h4x3(:,242),heltab2x12(:,:,452))
  call Hloop_A_Q(ntryL,G1H3(201),23,nML,G2H3(3),n2h3(178))
  call Hloop_QV_A(ntryL,G1H12(70),wf4(:,1),G1H3(32),m3h4x3(:,243),heltab2x12(:,:,453))
  call Hloop_Q_A(ntryL,G1H3(32),23,nMT,G2H3(21),n2h3(179))
  call Hloop_AV_Q(ntryL,G1H12(72),wf4(:,1),G1H3(202),m3h4x3(:,244),heltab2x12(:,:,454))
  call Hloop_A_Q(ntryL,G1H3(202),23,nMT,G2H3(30),n2h3(180))
  call Hloop_QV_A(ntryL,G1H12(79),wf4(:,1),G1H3(205),m3h4x3(:,245),heltab2x12(:,:,455))
  call Hloop_Q_A(ntryL,G1H3(205),23,nMB,G2H3(59),n2h3(181))
  call Hloop_AV_Q(ntryL,G1H12(81),wf4(:,1),G1H3(27),m3h4x3(:,246),heltab2x12(:,:,456))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(55),n2h3(182))
  call Hloop_QZ_A(ntryL,G1H12(86),wf4(:,2),G1H3(206),ngZl,m3h4x3(:,247),heltab2x12(:,:,457))
  call Hloop_Q_A(ntryL,G1H3(206),23,nML,G2H3(13),n2h3(183))
  call Hloop_AZ_Q(ntryL,G1H12(89),wf4(:,2),G1H3(209),ngZl,m3h4x3(:,248),heltab2x12(:,:,458))
  call Hloop_A_Q(ntryL,G1H3(209),23,nML,G2H3(33),n2h3(184))
  call Hloop_QZ_A(ntryL,G1H12(91),wf4(:,2),G1H3(54),ngZu,m3h4x3(:,249),heltab2x12(:,:,459))
  call Hloop_Q_A(ntryL,G1H3(54),23,nMT,G2H3(60),n2h3(185))
  call Hloop_AZ_Q(ntryL,G1H12(96),wf4(:,2),G1H3(210),ngZu,m3h4x3(:,250),heltab2x12(:,:,460))
  call Hloop_A_Q(ntryL,G1H3(210),23,nMT,G2H3(40),n2h3(186))
  call Hloop_QZ_A(ntryL,G1H12(100),wf4(:,2),G1H3(213),ngZd,m3h4x3(:,251),heltab2x12(:,:,461))
  call Hloop_Q_A(ntryL,G1H3(213),23,nMB,G2H3(35),n2h3(187))
  call Hloop_AZ_Q(ntryL,G1H12(103),wf4(:,2),G1H3(38),ngZd,m3h4x3(:,252),heltab2x12(:,:,462))
  call Hloop_A_Q(ntryL,G1H3(38),23,nMB,G2H3(65),n2h3(188))
  call Hloop_TV_S(ntryL,G1H12(47),20,wf4(:,1),3,G2H3(41),m3h4x3(:,253),heltab2x12(:,:,463))
  call Hloop_SV_T(ntryL,G1H12(48),20,wf4(:,1),3,G2H3(39),m3h4x3(:,254),heltab2x12(:,:,464))
  call Hloop_TV_S(ntryL,G1H12(49),20,wf4(:,2),3,G2H3(42),m3h4x3(:,255),heltab2x12(:,:,465))
  call Hloop_SV_T(ntryL,G1H12(50),20,wf4(:,2),3,G2H3(43),m3h4x3(:,256),heltab2x12(:,:,466))
  call Hloop_UV_W(ntryL,G1H12(52),20,wf4(:,1),3,G2H3(135),m3h4x3(:,257),heltab2x12(:,:,467))
  call Hloop_UW_V(ntryL,G1H12(54),20,wf4(:,1),3,G2H3(132),m3h4x3(:,258),heltab2x12(:,:,468))
  call Hloop_UV_W(ntryL,G1H12(56),20,wf4(:,2),3,G2H3(129),m3h4x3(:,259),heltab2x12(:,:,469))
  call Hloop_UW_V(ntryL,G1H12(57),20,wf4(:,2),3,G2H3(93),m3h4x3(:,260),heltab2x12(:,:,470))
  call Hloop_QZ_A(ntryL,G1H6(10),wf3(:,2),G1H2(10),ngZd,m3h3x2(:,27),heltab2x6(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(10),29,0,G2H2(11),n2h2(41))
  call Hloop_SS_S(ntryL,G1H3(48),ex3(:),G1H3(214),m3h1x3(:,85),heltab2x3(:,:,427))
  call Hloop_SS_S(ntryL,G1H3(43),ex3(:),G1H3(217),m3h1x3(:,86),heltab2x3(:,:,428))
  call Hloop_VS_V(ntryL,G1H3(175),ex3(:),G1H3(127),m3h1x3(:,87),heltab2x3(:,:,429))
  call Hloop_VS_V(ntryL,G1H3(176),ex3(:),G1H3(218),m3h1x3(:,88),heltab2x3(:,:,430))
  call Hloop_SS_S(ntryL,G1H12(53),ex3(:),G1H12(3),m3h1x12(:,89),heltab2x12(:,:,471))
  call Hloop_SS_S(ntryL,G1H12(55),ex3(:),G1H12(16),m3h1x12(:,90),heltab2x12(:,:,472))
  call Hloop_VS_V(ntryL,G1H12(122),ex3(:),G1H12(2),m3h1x12(:,91),heltab2x12(:,:,473))
  call Hloop_VS_V(ntryL,G1H12(124),ex3(:),G1H12(22),m3h1x12(:,92),heltab2x12(:,:,474))
  call Hloop_VT_S(ntryL,G0H12(13),16,ex3(:),4,G1H12(27),m3h1x12(:,93),heltab2x12(:,:,475))
  call Hloop_VT_S(ntryL,G0H12(15),16,ex3(:),4,G1H12(29),m3h1x12(:,94),heltab2x12(:,:,476))
  call Hloop_ST_V(ntryL,G0H12(17),16,ex3(:),4,G1H12(28),m3h1x12(:,95),heltab2x12(:,:,477))
  call Hloop_ST_V(ntryL,G0H12(19),16,ex3(:),4,G1H12(36),m3h1x12(:,96),heltab2x12(:,:,478))
  call Hloop_TV_S(ntryL,G0H4(23),24,wf4(:,1),3,G1H1(26),m3h4x1(:,1),heltab2x4(:,:,13))
  call Hloop_SV_T(ntryL,G0H4(24),24,wf4(:,1),3,G1H1(64),m3h4x1(:,2),heltab2x4(:,:,14))
  call Hloop_TV_S(ntryL,G0H4(25),24,wf4(:,2),3,G1H1(43),m3h4x1(:,3),heltab2x4(:,:,15))
  call Hloop_SV_T(ntryL,G0H4(26),24,wf4(:,2),3,G1H1(5),m3h4x1(:,4),heltab2x4(:,:,16))
  call Hloop_UV_W(ntryL,G0H4(35),24,wf4(:,1),3,G1H1(38),m3h4x1(:,5),heltab2x4(:,:,17))
  call Hloop_UW_V(ntryL,G0H4(36),24,wf4(:,1),3,G1H1(6),m3h4x1(:,6),heltab2x4(:,:,18))
  call Hloop_UV_W(ntryL,G0H4(37),24,wf4(:,2),3,G1H1(44),m3h4x1(:,7),heltab2x4(:,:,19))
  call Hloop_UW_V(ntryL,G0H4(38),24,wf4(:,2),3,G1H1(8),m3h4x1(:,8),heltab2x4(:,:,20))
  call Hloop_SV_V(ntryL,G0H4(40),wf4(:,1),G0H1(1),m3h4x1(:,9),heltab2x4(:,:,21))
  call Hloop_SV_V(ntryL,G0H4(42),wf4(:,2),G0H1(2),m3h4x1(:,10),heltab2x4(:,:,22))
  call Hloop_VV_S(ntryL,G0H4(44),wf4(:,1),G0H1(3),m3h4x1(:,11),heltab2x4(:,:,23))
  call Hloop_VV_S(ntryL,G0H4(46),wf4(:,2),G0H1(4),m3h4x1(:,12),heltab2x4(:,:,24))
  call Hloop_VVS_S(ntryL,G0H12(20),wf4(:,1),ex3(:),G0H3(28),m4h4x1x3(:,1),heltab3x12(:,:,1))
  call Hloop_VVS_S(ntryL,G0H12(22),wf4(:,1),ex3(:),G0H3(27),m4h4x1x3(:,2),heltab3x12(:,:,2))
  call Hloop_VVS_S(ntryL,G0H12(24),wf4(:,2),ex3(:),G0H3(5),m4h4x1x3(:,3),heltab3x12(:,:,3))
  call Hloop_VVS_S(ntryL,G0H12(26),wf4(:,2),ex3(:),G0H3(6),m4h4x1x3(:,4),heltab3x12(:,:,4))
  call Hloop_SSV_V(ntryL,G1H12(128),ex3(:),wf4(:,1),G1H3(221),m4h1x4x3(:,1),heltab3x12(:,:,5))
  call Hloop_SSV_V(ntryL,G1H12(132),ex3(:),wf4(:,2),G1H3(129),m4h1x4x3(:,2),heltab3x12(:,:,6))
  call Hloop_VVS_S(ntryL,G1H12(134),wf4(:,1),ex3(:),G1H3(222),m4h4x1x3(:,5),heltab3x12(:,:,7))
  call Hloop_VVS_S(ntryL,G1H12(136),wf4(:,2),ex3(:),G1H3(225),m4h4x1x3(:,6),heltab3x12(:,:,8))
  call Hloop_SSV_V(ntryL,G0H12(28),ex3(:),wf4(:,1),G0H3(19),m4h1x4x3(:,3),heltab3x12(:,:,9))
  call Hloop_SSV_V(ntryL,G0H12(29),ex3(:),wf4(:,1),G0H3(20),m4h1x4x3(:,4),heltab3x12(:,:,10))
  call Hloop_SSV_V(ntryL,G0H12(30),ex3(:),wf4(:,2),G0H3(26),m4h1x4x3(:,5),heltab3x12(:,:,11))
  call Hloop_SSV_V(ntryL,G0H12(31),ex3(:),wf4(:,2),G0H3(25),m4h1x4x3(:,6),heltab3x12(:,:,12))
  call Hloop_VV_S(ntryL,G1H12(42),wf4(:,1),G1H3(70),m3h4x3(:,261),heltab2x12(:,:,479))
  call Hloop_VV_S(ntryL,G1H12(43),wf4(:,1),G1H3(226),m3h4x3(:,262),heltab2x12(:,:,480))
  call Hloop_VV_S(ntryL,G1H12(44),wf4(:,2),G1H3(229),m3h4x3(:,263),heltab2x12(:,:,481))
  call Hloop_VV_S(ntryL,G1H12(45),wf4(:,2),G1H3(189),m3h4x3(:,264),heltab2x12(:,:,482))
  call Hloop_SV_V(ntryL,G1H12(59),wf4(:,1),G1H3(186),m3h4x3(:,265),heltab2x12(:,:,483))
  call Hloop_SV_V(ntryL,G1H12(60),wf4(:,1),G1H3(49),m3h4x3(:,266),heltab2x12(:,:,484))
  call Hloop_SV_V(ntryL,G1H12(61),wf4(:,2),G1H3(4),m3h4x3(:,267),heltab2x12(:,:,485))
  call Hloop_SV_V(ntryL,G1H12(62),wf4(:,2),G1H3(26),m3h4x3(:,268),heltab2x12(:,:,486))
  call Hloop_SV_V(ntryL,G1H12(140),wf4(:,1),G1H3(103),m3h4x3(:,269),heltab2x12(:,:,487))
  call Hloop_SV_V(ntryL,G1H12(142),wf4(:,2),G1H3(99),m3h4x3(:,270),heltab2x12(:,:,488))
  call Hloop_SV_T(ntryL,G0H12(48),16,wf4(:,1),3,G1H3(16),m3h4x3(:,271),heltab2x12(:,:,489))
  call Hloop_TV_S(ntryL,G0H12(49),16,wf4(:,1),3,G1H3(9),m3h4x3(:,272),heltab2x12(:,:,490))
  call Hloop_SV_T(ntryL,G0H12(50),16,wf4(:,2),3,G1H3(113),m3h4x3(:,273),heltab2x12(:,:,491))
  call Hloop_TV_S(ntryL,G0H12(51),16,wf4(:,2),3,G1H3(91),m3h4x3(:,274),heltab2x12(:,:,492))
  call Hloop_UW_V(ntryL,G0H12(52),16,wf4(:,1),3,G1H3(136),m3h4x3(:,275),heltab2x12(:,:,493))
  call Hloop_UV_W(ntryL,G0H12(54),16,wf4(:,1),3,G1H3(60),m3h4x3(:,276),heltab2x12(:,:,494))
  call Hloop_UW_V(ntryL,G0H12(56),16,wf4(:,2),3,G1H3(28),m3h4x3(:,277),heltab2x12(:,:,495))
  call Hloop_UV_W(ntryL,G0H12(58),16,wf4(:,2),3,G1H3(118),m3h4x3(:,278),heltab2x12(:,:,496))
  call Hloop_VV_S(ntryL,G1H12(144),wf4(:,1),G1H3(101),m3h4x3(:,279),heltab2x12(:,:,497))
  call Hloop_VV_S(ntryL,G1H12(146),wf4(:,2),G1H3(137),m3h4x3(:,280),heltab2x12(:,:,498))
  call Hloop_WQ_A(ntryL,G0H4(56),ex1(:),G0H2(1),m3h2x2(:,13),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G0H2(1),29,0,G1H2(8),n2h2(42))
  call Hloop_ZQ_A(ntryL,G0H4(55),ex1(:),G0H2(1),ngZu,m3h2x2(:,14),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G0H2(1),29,0,G1H2(1),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H12(147),wf4(:,1),G1H3(125),m3h4x3(:,281),heltab2x12(:,:,499))
  call Hloop_A_Q(ntryL,G1H3(125),19,nML,G2H3(95),n2h3(189))
  call Hloop_QV_A(ntryL,G1H12(148),wf4(:,1),G1H3(31),m3h4x3(:,282),heltab2x12(:,:,500))
  call Hloop_Q_A(ntryL,G1H3(31),19,nML,G2H3(96),n2h3(190))
  call Hloop_AV_Q(ntryL,G1H12(149),wf4(:,1),G1H3(120),m3h4x3(:,283),heltab2x12(:,:,501))
  call Hloop_A_Q(ntryL,G1H3(120),19,nMT,G2H3(98),n2h3(191))
  call Hloop_QV_A(ntryL,G1H12(150),wf4(:,1),G1H3(100),m3h4x3(:,284),heltab2x12(:,:,502))
  call Hloop_Q_A(ntryL,G1H3(100),19,nMT,G2H3(99),n2h3(192))
  call Hloop_AV_Q(ntryL,G1H12(151),wf4(:,1),G1H3(72),m3h4x3(:,285),heltab2x12(:,:,503))
  call Hloop_A_Q(ntryL,G1H3(72),19,nMB,G2H3(101),n2h3(193))
  call Hloop_QV_A(ntryL,G1H12(152),wf4(:,1),G1H3(130),m3h4x3(:,286),heltab2x12(:,:,504))
  call Hloop_Q_A(ntryL,G1H3(130),19,nMB,G2H3(102),n2h3(194))
  call Hloop_AZ_Q(ntryL,G1H12(153),wf4(:,2),G1H3(164),ngZl,m3h4x3(:,287),heltab2x12(:,:,505))
  call Hloop_A_Q(ntryL,G1H3(164),19,nML,G2H3(104),n2h3(195))
  call Hloop_QZ_A(ntryL,G1H12(154),wf4(:,2),G1H3(122),ngZl,m3h4x3(:,288),heltab2x12(:,:,506))
  call Hloop_Q_A(ntryL,G1H3(122),19,nML,G2H3(105),n2h3(196))
  call Hloop_AZ_Q(ntryL,G1H12(155),wf4(:,2),G1H3(94),ngZu,m3h4x3(:,289),heltab2x12(:,:,507))
  call Hloop_A_Q(ntryL,G1H3(94),19,nMT,G2H3(107),n2h3(197))
  call Hloop_QZ_A(ntryL,G1H12(156),wf4(:,2),G1H3(139),ngZu,m3h4x3(:,290),heltab2x12(:,:,508))
  call Hloop_Q_A(ntryL,G1H3(139),19,nMT,G2H3(108),n2h3(198))
  call Hloop_AZ_Q(ntryL,G1H12(158),wf4(:,2),G1H3(135),ngZd,m3h4x3(:,291),heltab2x12(:,:,509))
  call Hloop_A_Q(ntryL,G1H3(135),19,nMB,G2H3(110),n2h3(199))
  call Hloop_QZ_A(ntryL,G1H12(160),wf4(:,2),G1H3(45),ngZd,m3h4x3(:,292),heltab2x12(:,:,510))
  call Hloop_Q_A(ntryL,G1H3(45),19,nMB,G2H3(137),n2h3(200))
  call Hloop_DV_C(ntryL,G1H12(163),16,wf4(:,1),G2H3(134),m3h4x3(:,293),heltab2x12(:,:,511))
  call Hloop_CV_D(ntryL,G1H12(164),16,wf4(:,1),3,G2H3(131),m3h4x3(:,294),heltab2x12(:,:,512))
  call Hloop_DV_C(ntryL,G1H12(167),16,wf4(:,2),G2H3(149),m3h4x3(:,295),heltab2x12(:,:,513))
  call Hloop_CV_D(ntryL,G1H12(168),16,wf4(:,2),3,G2H3(146),m3h4x3(:,296),heltab2x12(:,:,514))
  call Hloop_SV_V(ntryL,G1H12(170),wf4(:,1),G1H3(59),m3h4x3(:,297),heltab2x12(:,:,515))
  call Hloop_SV_V(ntryL,G1H12(173),wf4(:,2),G1H3(106),m3h4x3(:,298),heltab2x12(:,:,516))
  call Hloop_SV_T(ntryL,G0H12(72),16,wf4(:,1),3,G1H3(141),m3h4x3(:,299),heltab2x12(:,:,517))
  call Hloop_TV_S(ntryL,G0H12(73),16,wf4(:,1),3,G1H3(140),m3h4x3(:,300),heltab2x12(:,:,518))
  call Hloop_SV_T(ntryL,G0H12(74),16,wf4(:,2),3,G1H3(47),m3h4x3(:,301),heltab2x12(:,:,519))
  call Hloop_TV_S(ntryL,G0H12(75),16,wf4(:,2),3,G1H3(2),m3h4x3(:,302),heltab2x12(:,:,520))
  call Hloop_UW_V(ntryL,G0H12(76),16,wf4(:,1),3,G1H3(112),m3h4x3(:,303),heltab2x12(:,:,521))
  call Hloop_UV_W(ntryL,G0H12(77),16,wf4(:,1),3,G1H3(3),m3h4x3(:,304),heltab2x12(:,:,522))
  call Hloop_UW_V(ntryL,G0H12(78),16,wf4(:,2),3,G1H3(145),m3h4x3(:,305),heltab2x12(:,:,523))
  call Hloop_UV_W(ntryL,G0H12(79),16,wf4(:,2),3,G1H3(182),m3h4x3(:,306),heltab2x12(:,:,524))
  call Hloop_VV_S(ntryL,G1H12(175),wf4(:,1),G1H3(180),m3h4x3(:,307),heltab2x12(:,:,525))
  call Hloop_VV_S(ntryL,G1H12(178),wf4(:,2),G1H3(177),m3h4x3(:,308),heltab2x12(:,:,526))
  call Hloop_AV_Q(ntryL,G1H12(179),wf4(:,1),G1H3(96),m3h4x3(:,309),heltab2x12(:,:,527))
  call Hloop_A_Q(ntryL,G1H3(96),19,0,G2H3(143),n2h3(201))
  call Hloop_AV_Q(ntryL,G1H12(180),wf4(:,1),G1H3(97),m3h4x3(:,310),heltab2x12(:,:,528))
  call Hloop_A_Q(ntryL,G1H3(97),19,nML,G2H3(20),n2h3(202))
  call Hloop_QV_A(ntryL,G1H12(186),wf4(:,1),G1H3(79),m3h4x3(:,311),heltab2x12(:,:,529))
  call Hloop_Q_A(ntryL,G1H3(79),19,0,G2H3(150),n2h3(203))
  call Hloop_QV_A(ntryL,G1H12(184),wf4(:,1),G1H3(61),m3h4x3(:,312),heltab2x12(:,:,530))
  call Hloop_Q_A(ntryL,G1H3(61),19,nML,G2H3(26),n2h3(204))
  call Hloop_AV_Q(ntryL,G1H12(185),wf4(:,1),G1H3(88),m3h4x3(:,313),heltab2x12(:,:,531))
  call Hloop_A_Q(ntryL,G1H3(88),19,0,G2H3(45),n2h3(205))
  call Hloop_AV_Q(ntryL,G1H12(187),wf4(:,1),G1H3(161),m3h4x3(:,314),heltab2x12(:,:,532))
  call Hloop_A_Q(ntryL,G1H3(161),19,nMT,G2H3(29),n2h3(206))
  call Hloop_QV_A(ntryL,G1H12(193),wf4(:,1),G1H3(66),m3h4x3(:,315),heltab2x12(:,:,533))
  call Hloop_Q_A(ntryL,G1H3(66),19,0,G2H3(49),n2h3(207))
  call Hloop_QV_A(ntryL,G1H12(191),wf4(:,1),G1H3(17),m3h4x3(:,316),heltab2x12(:,:,534))
  call Hloop_Q_A(ntryL,G1H3(17),19,nMT,G2H3(28),n2h3(208))
  call Hloop_AV_Q(ntryL,G1H12(192),wf4(:,1),G1H3(162),m3h4x3(:,317),heltab2x12(:,:,535))
  call Hloop_A_Q(ntryL,G1H3(162),19,0,G2H3(32),n2h3(209))
  call Hloop_AV_Q(ntryL,G1H12(194),wf4(:,1),G1H3(131),m3h4x3(:,318),heltab2x12(:,:,536))
  call Hloop_A_Q(ntryL,G1H3(131),19,nMB,G2H3(37),n2h3(210))
  call Hloop_QV_A(ntryL,G1H12(195),wf4(:,1),G1H3(124),m3h4x3(:,319),heltab2x12(:,:,537))
  call Hloop_Q_A(ntryL,G1H3(124),19,0,G2H3(4),n2h3(211))
  call Hloop_QV_A(ntryL,G1H12(196),wf4(:,1),G1H3(171),m3h4x3(:,320),heltab2x12(:,:,538))
  call Hloop_Q_A(ntryL,G1H3(171),19,nMB,G2H3(31),n2h3(212))
  call Hloop_AZ_Q(ntryL,G1H12(73),wf4(:,2),G1H3(55),ngZn,m3h4x3(:,321),heltab2x12(:,:,539))
  call Hloop_A_Q(ntryL,G1H3(55),19,0,G2H3(36),n2h3(213))
  call Hloop_QZ_A(ntryL,G1H12(74),wf4(:,2),G1H3(33),ngZn,m3h4x3(:,322),heltab2x12(:,:,540))
  call Hloop_Q_A(ntryL,G1H3(33),19,0,G2H3(69),n2h3(214))
  call Hloop_AZ_Q(ntryL,G1H12(77),wf4(:,2),G1H3(172),ngZl,m3h4x3(:,323),heltab2x12(:,:,541))
  call Hloop_A_Q(ntryL,G1H3(172),19,0,G2H3(68),n2h3(215))
  call Hloop_AZ_Q(ntryL,G1H12(78),wf4(:,2),G1H3(56),ngZl,m3h4x3(:,324),heltab2x12(:,:,542))
  call Hloop_A_Q(ntryL,G1H3(56),19,nML,G2H3(67),n2h3(216))
  call Hloop_QZ_A(ntryL,G1H12(125),wf4(:,2),G1H3(34),ngZl,m3h4x3(:,325),heltab2x12(:,:,543))
  call Hloop_Q_A(ntryL,G1H3(34),19,0,G2H3(27),n2h3(217))
  call Hloop_QZ_A(ntryL,G1H12(126),wf4(:,2),G1H3(165),ngZl,m3h4x3(:,326),heltab2x12(:,:,544))
  call Hloop_Q_A(ntryL,G1H3(165),19,nML,G2H3(25),n2h3(218))
  call Hloop_AZ_Q(ntryL,G1H12(129),wf4(:,2),G1H3(157),ngZu,m3h4x3(:,327),heltab2x12(:,:,545))
  call Hloop_A_Q(ntryL,G1H3(157),19,0,G2H3(9),n2h3(219))
  call Hloop_AZ_Q(ntryL,G1H12(130),wf4(:,2),G1H3(153),ngZu,m3h4x3(:,328),heltab2x12(:,:,546))
  call Hloop_A_Q(ntryL,G1H3(153),19,nMT,G2H3(10),n2h3(220))
  call Hloop_QZ_A(ntryL,G1H12(137),wf4(:,2),G1H3(1),ngZu,m3h4x3(:,329),heltab2x12(:,:,547))
  call Hloop_Q_A(ntryL,G1H3(1),19,0,G2H3(11),n2h3(221))
  call Hloop_QZ_A(ntryL,G1H12(139),wf4(:,2),G1H3(29),ngZu,m3h4x3(:,330),heltab2x12(:,:,548))
  call Hloop_Q_A(ntryL,G1H3(29),19,nMT,G2H3(1),n2h3(222))
  call Hloop_AZ_Q(ntryL,G1H12(183),wf4(:,2),G1H3(134),ngZd,m3h4x3(:,331),heltab2x12(:,:,549))
  call Hloop_A_Q(ntryL,G1H3(134),19,0,G2H3(2),n2h3(223))
  call Hloop_AZ_Q(ntryL,G1H12(190),wf4(:,2),G1H3(82),ngZd,m3h4x3(:,332),heltab2x12(:,:,550))
  call Hloop_A_Q(ntryL,G1H3(82),19,nMB,G2H3(15),n2h3(224))
  call Hloop_QZ_A(ntryL,G1H12(9),wf4(:,2),G1H3(166),ngZd,m3h4x3(:,333),heltab2x12(:,:,551))
  call Hloop_Q_A(ntryL,G1H3(166),19,0,G2H3(19),n2h3(225))
  call Hloop_QZ_A(ntryL,G1H12(11),wf4(:,2),G1H3(158),ngZd,m3h4x3(:,334),heltab2x12(:,:,552))
  call Hloop_Q_A(ntryL,G1H3(158),19,nMB,G2H3(50),n2h3(226))
  call Hloop_SV_T(ntryL,G1H12(157),16,wf4(:,1),3,G2H3(90),m3h4x3(:,335),heltab2x12(:,:,553))
  call Hloop_TV_S(ntryL,G1H12(159),16,wf4(:,1),3,G2H3(64),m3h4x3(:,336),heltab2x12(:,:,554))
  call Hloop_SV_T(ntryL,G1H12(169),16,wf4(:,2),3,G2H3(63),m3h4x3(:,337),heltab2x12(:,:,555))
  call Hloop_TV_S(ntryL,G1H12(174),16,wf4(:,2),3,G2H3(44),m3h4x3(:,338),heltab2x12(:,:,556))
  call Hloop_DV_C(ntryL,G1H12(97),16,wf4(:,1),G2H3(51),m3h4x3(:,339),heltab2x12(:,:,557))
  call Hloop_CV_D(ntryL,G1H12(99),16,wf4(:,1),3,G2H3(138),m3h4x3(:,340),heltab2x12(:,:,558))
  call Hloop_DV_C(ntryL,G1H12(4),16,wf4(:,2),G2H3(5),m3h4x3(:,341),heltab2x12(:,:,559))
  call Hloop_CV_D(ntryL,G1H12(5),16,wf4(:,2),3,G2H3(6),m3h4x3(:,342),heltab2x12(:,:,560))
  call Hloop_UW_V(ntryL,G1H12(188),16,wf4(:,1),3,G2H3(7),m3h4x3(:,343),heltab2x12(:,:,561))
  call Hloop_UV_W(ntryL,G1H12(189),16,wf4(:,1),3,G2H3(8),m3h4x3(:,344),heltab2x12(:,:,562))
  call Hloop_UW_V(ntryL,G1H12(6),16,wf4(:,2),3,G2H3(12),m3h4x3(:,345),heltab2x12(:,:,563))
  call Hloop_UV_W(ntryL,G1H12(8),16,wf4(:,2),3,G2H3(16),m3h4x3(:,346),heltab2x12(:,:,564))
  call Hloop_SV_V(ntryL,G1H12(12),wf4(:,1),G1H3(156),m3h4x3(:,347),heltab2x12(:,:,565))
  call Hloop_SV_V(ntryL,G1H12(15),wf4(:,2),G1H3(30),m3h4x3(:,348),heltab2x12(:,:,566))
  call Hloop_SV_T(ntryL,G0H12(110),16,wf4(:,1),3,G1H3(18),m3h4x3(:,349),heltab2x12(:,:,567))
  call Hloop_TV_S(ntryL,G0H12(111),16,wf4(:,1),3,G1H3(102),m3h4x3(:,350),heltab2x12(:,:,568))
  call Hloop_SV_T(ntryL,G0H12(112),16,wf4(:,2),3,G1H3(20),m3h4x3(:,351),heltab2x12(:,:,569))
  call Hloop_TV_S(ntryL,G0H12(113),16,wf4(:,2),3,G1H3(143),m3h4x3(:,352),heltab2x12(:,:,570))
  call Hloop_VV_S(ntryL,G0H12(114),wf4(:,1),G0H3(22),m3h4x3(:,353),heltab2x12(:,:,571))
  call Hloop_VV_S(ntryL,G0H12(115),wf4(:,1),G0H3(7),m3h4x3(:,354),heltab2x12(:,:,572))
  call Hloop_VV_S(ntryL,G0H12(116),wf4(:,2),G0H3(24),m3h4x3(:,355),heltab2x12(:,:,573))
  call Hloop_VV_S(ntryL,G0H12(121),wf4(:,2),G0H3(8),m3h4x3(:,356),heltab2x12(:,:,574))
  call Hloop_SV_V(ntryL,G0H12(119),wf4(:,1),G0H3(11),m3h4x3(:,357),heltab2x12(:,:,575))
  call Hloop_SV_V(ntryL,G0H12(6),wf4(:,1),G0H3(1),m3h4x3(:,358),heltab2x12(:,:,576))
  call Hloop_SV_V(ntryL,G0H12(120),wf4(:,2),G0H3(3),m3h4x3(:,359),heltab2x12(:,:,577))
  call Hloop_SV_V(ntryL,G0H12(5),wf4(:,2),G0H3(9),m3h4x3(:,360),heltab2x12(:,:,578))
  call Hloop_UW_V(ntryL,G0H12(21),16,wf4(:,1),3,G1H3(150),m3h4x3(:,361),heltab2x12(:,:,579))
  call Hloop_UV_W(ntryL,G0H12(23),16,wf4(:,1),3,G1H3(126),m3h4x3(:,362),heltab2x12(:,:,580))
  call Hloop_UW_V(ntryL,G0H12(25),16,wf4(:,2),3,G1H3(10),m3h4x3(:,363),heltab2x12(:,:,581))
  call Hloop_UV_W(ntryL,G0H12(7),16,wf4(:,2),3,G1H3(148),m3h4x3(:,364),heltab2x12(:,:,582))
  call Hloop_VV_S(ntryL,G1H12(18),wf4(:,1),G1H3(78),m3h4x3(:,365),heltab2x12(:,:,583))
  call Hloop_VV_S(ntryL,G1H12(21),wf4(:,2),G1H3(14),m3h4x3(:,366),heltab2x12(:,:,584))
  call Hloop_CV_D(ntryL,G1H12(13),20,wf4(:,1),3,G2H3(18),m3h4x3(:,367),heltab2x12(:,:,585))
  call Hloop_DV_C(ntryL,G1H12(111),20,wf4(:,1),G2H3(22),m3h4x3(:,368),heltab2x12(:,:,586))
  call Hloop_CV_D(ntryL,G1H12(113),20,wf4(:,2),3,G2H3(24),m3h4x3(:,369),heltab2x12(:,:,587))
  call Hloop_DV_C(ntryL,G1H12(23),20,wf4(:,2),G2H3(34),m3h4x3(:,370),heltab2x12(:,:,588))
  call Hloop_QV_A(ntryL,G1H12(64),wf4(:,1),G1H3(37),m3h4x3(:,371),heltab2x12(:,:,589))
  call Hloop_Q_A(ntryL,G1H3(37),23,0,G2H3(38),n2h3(227))
  call Hloop_AV_Q(ntryL,G1H12(66),wf4(:,1),G1H3(64),m3h4x3(:,372),heltab2x12(:,:,590))
  call Hloop_A_Q(ntryL,G1H3(64),23,0,G2H3(46),n2h3(228))
  call Hloop_QV_A(ntryL,G1H12(69),wf4(:,1),G1H3(77),m3h4x3(:,373),heltab2x12(:,:,591))
  call Hloop_Q_A(ntryL,G1H3(77),23,0,G2H3(47),n2h3(229))
  call Hloop_AV_Q(ntryL,G1H12(71),wf4(:,1),G1H3(36),m3h4x3(:,374),heltab2x12(:,:,592))
  call Hloop_A_Q(ntryL,G1H3(36),23,0,G2H3(48),n2h3(230))
  call Hloop_QV_A(ntryL,G1H12(76),wf4(:,1),G1H3(12),m3h4x3(:,375),heltab2x12(:,:,593))
  call Hloop_Q_A(ntryL,G1H3(12),23,0,G2H3(54),n2h3(231))
  call Hloop_AV_Q(ntryL,G1H12(80),wf4(:,1),G1H3(95),m3h4x3(:,376),heltab2x12(:,:,594))
  call Hloop_A_Q(ntryL,G1H3(95),23,0,G2H3(61),n2h3(232))
  call Hloop_QZ_A(ntryL,G1H12(83),wf4(:,2),G1H3(90),ngZn,m3h4x3(:,377),heltab2x12(:,:,595))
  call Hloop_Q_A(ntryL,G1H3(90),23,0,G2H3(74),n2h3(233))
  call Hloop_AZ_Q(ntryL,G1H12(84),wf4(:,2),G1H3(93),ngZn,m3h4x3(:,378),heltab2x12(:,:,596))
  call Hloop_A_Q(ntryL,G1H3(93),23,0,G2H3(75),n2h3(234))
  call Hloop_QZ_A(ntryL,G1H12(85),wf4(:,2),G1H3(111),ngZl,m3h4x3(:,379),heltab2x12(:,:,597))
  call Hloop_Q_A(ntryL,G1H3(111),23,0,G2H3(77),n2h3(235))
  call Hloop_AZ_Q(ntryL,G1H12(88),wf4(:,2),G1H3(116),ngZl,m3h4x3(:,380),heltab2x12(:,:,598))
  call Hloop_A_Q(ntryL,G1H3(116),23,0,G2H3(78),n2h3(236))
  call Hloop_QZ_A(ntryL,G1H12(90),wf4(:,2),G1H3(121),ngZu,m3h4x3(:,381),heltab2x12(:,:,599))
  call Hloop_Q_A(ntryL,G1H3(121),23,0,G2H3(80),n2h3(237))
  call Hloop_AZ_Q(ntryL,G1H12(94),wf4(:,2),G1H3(51),ngZu,m3h4x3(:,382),heltab2x12(:,:,600))
  call Hloop_A_Q(ntryL,G1H3(51),23,0,G2H3(81),n2h3(238))
  call Hloop_QZ_A(ntryL,G1H12(98),wf4(:,2),G1H3(190),ngZd,m3h4x3(:,383),heltab2x12(:,:,601))
  call Hloop_Q_A(ntryL,G1H3(190),23,0,G2H3(83),n2h3(239))
  call Hloop_AZ_Q(ntryL,G1H12(102),wf4(:,2),G1H3(57),ngZd,m3h4x3(:,384),heltab2x12(:,:,602))
  call Hloop_A_Q(ntryL,G1H3(57),23,0,G2H3(84),n2h3(240))
  call Hloop_TV_S(ntryL,G1H12(104),20,wf4(:,1),3,G2H3(86),m3h4x3(:,385),heltab2x12(:,:,603))
  call Hloop_SV_T(ntryL,G1H12(105),20,wf4(:,1),3,G2H3(87),m3h4x3(:,386),heltab2x12(:,:,604))
  call Hloop_TV_S(ntryL,G1H12(107),20,wf4(:,2),3,G2H3(89),m3h4x3(:,387),heltab2x12(:,:,605))
  call Hloop_SV_T(ntryL,G1H12(108),20,wf4(:,2),3,G2H3(92),m3h4x3(:,388),heltab2x12(:,:,606))
  call Hloop_UV_W(ntryL,G1H12(114),20,wf4(:,1),3,G2H3(111),m3h4x3(:,389),heltab2x12(:,:,607))
  call Hloop_UW_V(ntryL,G1H12(24),20,wf4(:,1),3,G2H3(113),m3h4x3(:,390),heltab2x12(:,:,608))
  call Hloop_UV_W(ntryL,G1H12(25),20,wf4(:,2),3,G2H3(114),m3h4x3(:,391),heltab2x12(:,:,609))
  call Hloop_UW_V(ntryL,G1H12(116),20,wf4(:,2),3,G2H3(116),m3h4x3(:,392),heltab2x12(:,:,610))
  call Hloop_SV_V(ntryL,G1H12(117),wf4(:,1),G1H3(193),m3h4x3(:,393),heltab2x12(:,:,611))
  call Hloop_SV_V(ntryL,G1H12(35),wf4(:,2),G1H3(104),m3h4x3(:,394),heltab2x12(:,:,612))
  call Hloop_VV_S(ntryL,G1H12(198),wf4(:,1),G1H3(65),m3h4x3(:,395),heltab2x12(:,:,613))
  call Hloop_VV_S(ntryL,G1H12(200),wf4(:,2),G1H3(62),m3h4x3(:,396),heltab2x12(:,:,614))
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,1),G1H1(47),m3h4x1(:,13),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H1(47),27,nML,G2H1(31),n2h1(237))
  call Hloop_AV_Q(ntryL,G1H4(10),wf4(:,1),G1H1(24),m3h4x1(:,14),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H1(24),27,nML,G2H1(14),n2h1(238))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,1),G1H1(10),m3h4x1(:,15),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H1(10),27,nMT,G2H1(32),n2h1(239))
  call Hloop_AV_Q(ntryL,G1H4(12),wf4(:,1),G1H1(14),m3h4x1(:,16),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H1(14),27,nMT,G2H1(34),n2h1(240))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,1),G1H1(48),m3h4x1(:,17),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H1(48),27,nMB,G2H1(8),n2h1(241))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,1),G1H1(17),m3h4x1(:,18),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H1(17),27,nMB,G2H1(35),n2h1(242))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,2),G1H1(51),ngZl,m3h4x1(:,19),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H1(51),27,nML,G2H1(37),n2h1(243))
  call Hloop_AZ_Q(ntryL,G1H4(16),wf4(:,2),G1H1(37),ngZl,m3h4x1(:,20),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H1(37),27,nML,G2H1(17),n2h1(244))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,2),G1H1(12),ngZu,m3h4x1(:,21),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H1(12),27,nMT,G2H1(38),n2h1(245))
  call Hloop_AZ_Q(ntryL,G1H4(18),wf4(:,2),G1H1(25),ngZu,m3h4x1(:,22),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H1(25),27,nMT,G2H1(40),n2h1(246))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,2),G1H1(52),ngZd,m3h4x1(:,23),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H1(52),27,nMB,G2H1(11),n2h1(247))
  call Hloop_AZ_Q(ntryL,G1H4(20),wf4(:,2),G1H1(22),ngZd,m3h4x1(:,24),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H1(22),27,nMB,G2H1(41),n2h1(248))
  call Hloop_CV_D(ntryL,G0H4(29),24,wf4(:,1),3,G1H1(55),m3h4x1(:,25),heltab2x4(:,:,39))
  call Hloop_DV_C(ntryL,G0H4(30),24,wf4(:,1),G1H1(9),m3h4x1(:,26),heltab2x4(:,:,40))
  call Hloop_CV_D(ntryL,G0H4(33),24,wf4(:,2),3,G1H1(11),m3h4x1(:,27),heltab2x4(:,:,41))
  call Hloop_DV_C(ntryL,G0H4(34),24,wf4(:,2),G1H1(13),m3h4x1(:,28),heltab2x4(:,:,42))
  call Hloop_VV_S(ntryL,G1H4(22),wf4(:,1),G1H1(56),m3h4x1(:,29),heltab2x4(:,:,43))
  call Hloop_VV_S(ntryL,G1H4(24),wf4(:,2),G1H1(41),m3h4x1(:,30),heltab2x4(:,:,44))
  call Hloop_TV_S(ntryL,G1H4(25),24,wf4(:,1),3,G2H1(43),m3h4x1(:,31),heltab2x4(:,:,45))
  call Hloop_SV_T(ntryL,G1H4(26),24,wf4(:,1),3,G2H1(9),m3h4x1(:,32),heltab2x4(:,:,46))
  call Hloop_TV_S(ntryL,G1H4(27),24,wf4(:,2),3,G2H1(44),m3h4x1(:,33),heltab2x4(:,:,47))
  call Hloop_SV_T(ntryL,G1H4(28),24,wf4(:,2),3,G2H1(46),m3h4x1(:,34),heltab2x4(:,:,48))
  call Hloop_UV_W(ntryL,G1H4(29),24,wf4(:,1),3,G2H1(7),m3h4x1(:,35),heltab2x4(:,:,49))
  call Hloop_UW_V(ntryL,G1H4(30),24,wf4(:,1),3,G2H1(52),m3h4x1(:,36),heltab2x4(:,:,50))
  call Hloop_UV_W(ntryL,G1H4(31),24,wf4(:,2),3,G2H1(53),m3h4x1(:,37),heltab2x4(:,:,51))
  call Hloop_UW_V(ntryL,G1H4(32),24,wf4(:,2),3,G2H1(55),m3h4x1(:,38),heltab2x4(:,:,52))
  call Hloop_SV_V(ntryL,G1H4(34),wf4(:,1),G1H1(59),m3h4x1(:,39),heltab2x4(:,:,53))
  call Hloop_SV_V(ntryL,G1H4(36),wf4(:,2),G1H1(21),m3h4x1(:,40),heltab2x4(:,:,54))
  call Hloop_AS_Q(ntryL,G1H12(201),wf4(:,3),G1H3(194),ngX,m3h4x3(:,397),heltab2x12(:,:,615))
  call Hloop_A_Q(ntryL,G1H3(194),23,nML,G2H3(117),n2h3(241))
  call Hloop_QS_A(ntryL,G1H12(202),wf4(:,3),G1H3(68),ngX,m3h4x3(:,398),heltab2x12(:,:,616))
  call Hloop_Q_A(ntryL,G1H3(68),23,nML,G2H3(119),n2h3(242))
  call Hloop_AS_Q(ntryL,G1H12(203),wf4(:,3),G1H3(197),ngX,m3h4x3(:,399),heltab2x12(:,:,617))
  call Hloop_A_Q(ntryL,G1H3(197),23,nMT,G2H3(120),n2h3(243))
  call Hloop_QS_A(ntryL,G1H12(204),wf4(:,3),G1H3(69),ngX,m3h4x3(:,400),heltab2x12(:,:,618))
  call Hloop_Q_A(ntryL,G1H3(69),23,nMT,G2H3(122),n2h3(244))
  call Hloop_AS_Q(ntryL,G1H12(205),wf4(:,3),G1H3(71),ngX,m3h4x3(:,401),heltab2x12(:,:,619))
  call Hloop_A_Q(ntryL,G1H3(71),23,nMB,G2H3(123),n2h3(245))
  call Hloop_QS_A(ntryL,G1H12(206),wf4(:,3),G1H3(185),ngX,m3h4x3(:,402),heltab2x12(:,:,620))
  call Hloop_Q_A(ntryL,G1H3(185),23,nMB,G2H3(125),n2h3(246))
  call Hloop_SS_S(ntryL,G1H12(209),wf4(:,3),G1H3(198),m3h4x3(:,403),heltab2x12(:,:,621))
  call Hloop_SS_S(ntryL,G1H12(210),wf4(:,3),G1H3(201),m3h4x3(:,404),heltab2x12(:,:,622))
  call Hloop_VT_S(ntryL,G0H12(91),16,wf4(:,3),7,G1H3(32),m3h4x3(:,405),heltab2x12(:,:,623))
  call Hloop_VT_S(ntryL,G0H12(61),16,wf4(:,3),7,G1H3(202),m3h4x3(:,406),heltab2x12(:,:,624))
  call Hloop_ST_V(ntryL,G1H12(212),16,wf4(:,3),7,G2H3(126),m3h4x3(:,407),heltab2x12(:,:,625))
  call Hloop_VT_S(ntryL,G1H12(214),16,wf4(:,3),7,G2H3(128),m3h4x3(:,408),heltab2x12(:,:,626))
  call Hloop_ST_V(ntryL,G0H12(62),16,wf4(:,3),7,G1H3(205),m3h4x3(:,409),heltab2x12(:,:,627))
  call Hloop_ST_V(ntryL,G0H12(63),16,wf4(:,3),7,G1H3(27),m3h4x3(:,410),heltab2x12(:,:,628))
  call Hloop_AZ_Q(ntryL,G1H12(215),wf4(:,4),G1H3(206),ngZn,m3h4x3(:,411),heltab2x12(:,:,629))
  call Hloop_A_Q(ntryL,G1H3(206),23,0,G2H3(140),n2h3(247))
  call Hloop_QZ_A(ntryL,G1H12(216),wf4(:,4),G1H3(209),ngZn,m3h4x3(:,412),heltab2x12(:,:,630))
  call Hloop_Q_A(ntryL,G1H3(209),23,0,G2H3(152),n2h3(248))
  call Hloop_AZ_Q(ntryL,G1H12(217),wf4(:,4),G1H3(54),ngZl,m3h4x3(:,413),heltab2x12(:,:,631))
  call Hloop_A_Q(ntryL,G1H3(54),23,0,G2H3(153),n2h3(249))
  call Hloop_AZ_Q(ntryL,G1H12(218),wf4(:,4),G1H3(210),ngZl,m3h4x3(:,414),heltab2x12(:,:,632))
  call Hloop_A_Q(ntryL,G1H3(210),23,nML,G2H3(154),n2h3(250))
  call Hloop_QZ_A(ntryL,G1H12(219),wf4(:,4),G1H3(213),ngZl,m3h4x3(:,415),heltab2x12(:,:,633))
  call Hloop_Q_A(ntryL,G1H3(213),23,0,G2H3(155),n2h3(251))
  call Hloop_QZ_A(ntryL,G1H12(220),wf4(:,4),G1H3(38),ngZl,m3h4x3(:,416),heltab2x12(:,:,634))
  call Hloop_Q_A(ntryL,G1H3(38),23,nML,G2H3(156),n2h3(252))
  call Hloop_AZ_Q(ntryL,G1H12(221),wf4(:,4),G1H3(48),ngZu,m3h4x3(:,417),heltab2x12(:,:,635))
  call Hloop_A_Q(ntryL,G1H3(48),23,0,G2H3(157),n2h3(253))
  call Hloop_AZ_Q(ntryL,G1H12(222),wf4(:,4),G1H3(43),ngZu,m3h4x3(:,418),heltab2x12(:,:,636))
  call Hloop_A_Q(ntryL,G1H3(43),23,nMT,G2H3(158),n2h3(254))
  call Hloop_QZ_A(ntryL,G1H12(223),wf4(:,4),G1H3(175),ngZu,m3h4x3(:,419),heltab2x12(:,:,637))
  call Hloop_Q_A(ntryL,G1H3(175),23,0,G2H3(159),n2h3(255))
  call Hloop_QZ_A(ntryL,G1H12(224),wf4(:,4),G1H3(176),ngZu,m3h4x3(:,420),heltab2x12(:,:,638))
  call Hloop_Q_A(ntryL,G1H3(176),23,nMT,G2H3(160),n2h3(256))
  call Hloop_AZ_Q(ntryL,G1H12(225),wf4(:,4),G1H3(125),ngZd,m3h4x3(:,421),heltab2x12(:,:,639))
  call Hloop_A_Q(ntryL,G1H3(125),23,0,G2H3(161),n2h3(257))
  call Hloop_AZ_Q(ntryL,G1H12(226),wf4(:,4),G1H3(31),ngZd,m3h4x3(:,422),heltab2x12(:,:,640))
  call Hloop_A_Q(ntryL,G1H3(31),23,nMB,G2H3(162),n2h3(258))
  call Hloop_QZ_A(ntryL,G1H12(227),wf4(:,4),G1H3(120),ngZd,m3h4x3(:,423),heltab2x12(:,:,641))
  call Hloop_Q_A(ntryL,G1H3(120),23,0,G2H3(163),n2h3(259))
  call Hloop_QZ_A(ntryL,G1H12(228),wf4(:,4),G1H3(100),ngZd,m3h4x3(:,424),heltab2x12(:,:,642))
  call Hloop_Q_A(ntryL,G1H3(100),23,nMB,G2H3(164),n2h3(260))
  call Hloop_SV_T(ntryL,G1H12(229),16,wf4(:,4),7,G2H3(165),m3h4x3(:,425),heltab2x12(:,:,643))
  call Hloop_TV_S(ntryL,G1H12(230),16,wf4(:,4),7,G2H3(166),m3h4x3(:,426),heltab2x12(:,:,644))
  call Hloop_DV_C(ntryL,G1H12(233),16,wf4(:,4),G2H3(167),m3h4x3(:,427),heltab2x12(:,:,645))
  call Hloop_CV_D(ntryL,G1H12(234),16,wf4(:,4),7,G2H3(168),m3h4x3(:,428),heltab2x12(:,:,646))
  call Hloop_UW_V(ntryL,G1H12(235),16,wf4(:,4),7,G2H3(169),m3h4x3(:,429),heltab2x12(:,:,647))
  call Hloop_UV_W(ntryL,G1H12(236),16,wf4(:,4),7,G2H3(170),m3h4x3(:,430),heltab2x12(:,:,648))
  call Hloop_VV_S(ntryL,G0H12(88),wf4(:,4),G0H3(14),m3h4x3(:,431),heltab2x12(:,:,649))
  call Hloop_VV_S(ntryL,G0H12(90),wf4(:,4),G0H3(16),m3h4x3(:,432),heltab2x12(:,:,650))
  call Hloop_SV_V(ntryL,G1H12(238),wf4(:,4),G1H3(72),m3h4x3(:,433),heltab2x12(:,:,651))
  call Hloop_SV_T(ntryL,G0H12(92),16,wf4(:,4),7,G1H3(130),m3h4x3(:,434),heltab2x12(:,:,652))
  call Hloop_TV_S(ntryL,G0H12(93),16,wf4(:,4),7,G1H3(164),m3h4x3(:,435),heltab2x12(:,:,653))
  call Hloop_UW_V(ntryL,G0H12(94),16,wf4(:,4),7,G1H3(122),m3h4x3(:,436),heltab2x12(:,:,654))
  call Hloop_UV_W(ntryL,G0H12(95),16,wf4(:,4),7,G1H3(94),m3h4x3(:,437),heltab2x12(:,:,655))
  call Hloop_VV_S(ntryL,G1H12(240),wf4(:,4),G1H3(139),m3h4x3(:,438),heltab2x12(:,:,656))
  call Hloop_SV_V(ntryL,G0H12(96),wf4(:,4),G0H3(12),m3h4x3(:,439),heltab2x12(:,:,657))
  call Hloop_SV_V(ntryL,G0H12(97),wf4(:,4),G0H3(2),m3h4x3(:,440),heltab2x12(:,:,658))
  call Hloop_QS_A(ntryL,G1H12(241),ex3(:),G1H12(30),ngH,m3h1x12(:,97),heltab2x12(:,:,659))
  call Hloop_Q_A(ntryL,G1H12(30),20,nML,G2H12(21),n2h12(245))
  call Hloop_AS_Q(ntryL,G1H12(242),ex3(:),G1H12(41),ngH,m3h1x12(:,98),heltab2x12(:,:,660))
  call Hloop_A_Q(ntryL,G1H12(41),20,nML,G2H12(22),n2h12(246))
  call Hloop_QS_A(ntryL,G1H12(243),ex3(:),G1H12(31),ngH,m3h1x12(:,99),heltab2x12(:,:,661))
  call Hloop_Q_A(ntryL,G1H12(31),20,nMT,G2H12(23),n2h12(247))
  call Hloop_AS_Q(ntryL,G1H12(244),ex3(:),G1H12(46),ngH,m3h1x12(:,100),heltab2x12(:,:,662))
  call Hloop_A_Q(ntryL,G1H12(46),20,nMT,G2H12(24),n2h12(248))
  call Hloop_QS_A(ntryL,G1H12(245),ex3(:),G1H12(32),ngH,m3h1x12(:,101),heltab2x12(:,:,663))
  call Hloop_Q_A(ntryL,G1H12(32),20,nMB,G2H12(13),n2h12(249))
  call Hloop_AS_Q(ntryL,G1H12(246),ex3(:),G1H12(51),ngH,m3h1x12(:,102),heltab2x12(:,:,664))
  call Hloop_A_Q(ntryL,G1H12(51),20,nMB,G2H12(14),n2h12(250))
  call Hloop_SS_S(ntryL,G1H12(248),ex3(:),G1H12(34),m3h1x12(:,103),heltab2x12(:,:,665))
  call Hloop_SS_S(ntryL,G1H12(251),ex3(:),G1H12(58),m3h1x12(:,104),heltab2x12(:,:,666))
  call Hloop_SS_S(ntryL,G1H12(252),ex3(:),G1H12(37),m3h1x12(:,105),heltab2x12(:,:,667))
  call Hloop_VS_V(ntryL,G1H12(254),ex3(:),G1H12(63),m3h1x12(:,106),heltab2x12(:,:,668))
  call Hloop_SS_S(ntryL,G0H12(64),ex3(:),G0H12(147),m3h1x12(:,107),heltab2x12(:,:,669))
  call Hloop_ST_V(ntryL,G1H12(256),16,ex3(:),4,G2H12(15),m3h1x12(:,108),heltab2x12(:,:,670))
  call Hloop_VT_S(ntryL,G0H12(66),16,ex3(:),4,G1H12(38),m3h1x12(:,109),heltab2x12(:,:,671))
  call Hloop_ST_V(ntryL,G0H12(68),16,ex3(:),4,G1H12(68),m3h1x12(:,110),heltab2x12(:,:,672))
  call Hloop_VT_S(ntryL,G1H12(258),16,ex3(:),4,G2H12(16),m3h1x12(:,111),heltab2x12(:,:,673))
  call Hloop_VS_V(ntryL,G0H12(70),ex3(:),G0H12(103),m3h1x12(:,112),heltab2x12(:,:,674))
  call Hloop_SS_S(ntryL,G1H3(167),ex3(:),G1H3(135),m3h1x3(:,89),heltab2x3(:,:,431))
  call Hloop_SS_S(ntryL,G1H3(170),ex3(:),G1H3(45),m3h1x3(:,90),heltab2x3(:,:,432))
  call Hloop_SS_S(ntryL,G1H3(85),ex3(:),G1H3(96),m3h1x3(:,91),heltab2x3(:,:,433))
  call Hloop_VT_S(ntryL,G1H3(144),19,ex3(:),4,G2H3(171),m3h1x3(:,92),heltab2x3(:,:,434))
  call Hloop_VT_S(ntryL,G1H3(147),19,ex3(:),4,G2H3(172),m3h1x3(:,93),heltab2x3(:,:,435))
  call Hloop_ST_V(ntryL,G1H3(86),19,ex3(:),4,G2H3(173),m3h1x3(:,94),heltab2x3(:,:,436))
  call Hloop_ST_V(ntryL,G1H3(84),19,ex3(:),4,G2H3(174),m3h1x3(:,95),heltab2x3(:,:,437))
  call Hloop_VS_V(ntryL,G1H3(11),ex3(:),G1H3(97),m3h1x3(:,96),heltab2x3(:,:,438))
  call Hloop_VS_V(ntryL,G0H6(4),ex3(:),G0H6(21),m3h1x6(:,17),heltab2x6(:,:,144))
  call Hloop_VS_V(ntryL,G0H6(5),ex3(:),G0H6(3),m3h1x6(:,18),heltab2x6(:,:,145))
  call Hloop_QA_V(ntryL,G1H12(262),ex2(:),G1H6(9),m3h2x6(:,99),heltab2x12(:,:,675))
  call Hloop_QA_Z(ntryL,G1H12(260),ex2(:),G1H6(7),ngZu,m3h2x6(:,100),heltab2x12(:,:,676))
  call Hloop_QA_W(ntryL,G1H12(261),ex2(:),G1H6(26),m3h2x6(:,101),heltab2x12(:,:,677))
  call Hloop_WA_Q(ntryL,G1H12(263),ex2(:),G1H6(27),m3h2x6(:,102),heltab2x12(:,:,678))
  call Hloop_A_Q(ntryL,G1H6(27),22,0,G2H6(19),n2h6(89))
  call Hloop_QS_A(ntryL,G1H12(264),ex3(:),G1H12(39),ngH,m3h1x12(:,113),heltab2x12(:,:,679))
  call Hloop_Q_A(ntryL,G1H12(39),20,nML,G2H12(25),n2h12(251))
  call Hloop_AS_Q(ntryL,G1H12(265),ex3(:),G1H12(75),ngH,m3h1x12(:,114),heltab2x12(:,:,680))
  call Hloop_A_Q(ntryL,G1H12(75),20,nML,G2H12(26),n2h12(252))
  call Hloop_QS_A(ntryL,G1H12(266),ex3(:),G1H12(40),ngH,m3h1x12(:,115),heltab2x12(:,:,681))
  call Hloop_Q_A(ntryL,G1H12(40),20,nMT,G2H12(27),n2h12(253))
  call Hloop_AS_Q(ntryL,G1H12(267),ex3(:),G1H12(82),ngH,m3h1x12(:,116),heltab2x12(:,:,682))
  call Hloop_A_Q(ntryL,G1H12(82),20,nMT,G2H12(28),n2h12(254))
  call Hloop_QS_A(ntryL,G1H12(268),ex3(:),G1H12(87),ngH,m3h1x12(:,117),heltab2x12(:,:,683))
  call Hloop_Q_A(ntryL,G1H12(87),20,nMB,G2H12(17),n2h12(255))
  call Hloop_AS_Q(ntryL,G1H12(269),ex3(:),G1H12(92),ngH,m3h1x12(:,118),heltab2x12(:,:,684))
  call Hloop_A_Q(ntryL,G1H12(92),20,nMB,G2H12(18),n2h12(256))
  call Hloop_QS_A(ntryL,G1H12(270),ex3(:),G1H12(101),ngH,m3h1x12(:,119),heltab2x12(:,:,685))
  call Hloop_Q_A(ntryL,G1H12(101),20,nML,G2H12(19),n2h12(257))
  call Hloop_AS_Q(ntryL,G1H12(271),ex3(:),G1H12(106),ngH,m3h1x12(:,120),heltab2x12(:,:,686))
  call Hloop_A_Q(ntryL,G1H12(106),20,nML,G2H12(20),n2h12(258))
  call Hloop_QS_A(ntryL,G1H12(272),ex3(:),G1H12(110),ngH,m3h1x12(:,121),heltab2x12(:,:,687))
  call Hloop_Q_A(ntryL,G1H12(110),20,nMT,G2H12(1),n2h12(259))
  call Hloop_AS_Q(ntryL,G1H12(273),ex3(:),G1H12(1),ngH,m3h1x12(:,122),heltab2x12(:,:,688))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(2),n2h12(260))
  call Hloop_QS_A(ntryL,G1H12(274),ex3(:),G1H12(115),ngH,m3h1x12(:,123),heltab2x12(:,:,689))
  call Hloop_Q_A(ntryL,G1H12(115),20,nMB,G2H12(3),n2h12(261))
  call Hloop_AS_Q(ntryL,G1H12(275),ex3(:),G1H12(33),ngH,m3h1x12(:,124),heltab2x12(:,:,690))
  call Hloop_A_Q(ntryL,G1H12(33),20,nMB,G2H12(4),n2h12(262))
  call Hloop_SS_S(ntryL,G1H12(276),ex3(:),G1H12(119),m3h1x12(:,125),heltab2x12(:,:,691))
  call Hloop_SS_S(ntryL,G1H12(277),ex3(:),G1H12(120),m3h1x12(:,126),heltab2x12(:,:,692))
  call Hloop_SS_S(ntryL,G1H12(278),ex3(:),G1H12(121),m3h1x12(:,127),heltab2x12(:,:,693))
  call Hloop_SS_S(ntryL,G1H12(279),ex3(:),G1H12(123),m3h1x12(:,128),heltab2x12(:,:,694))
  call Hloop_SS_S(ntryL,G1H12(280),ex3(:),G1H12(127),m3h1x12(:,129),heltab2x12(:,:,695))
  call Hloop_SS_S(ntryL,G1H12(281),ex3(:),G1H12(131),m3h1x12(:,130),heltab2x12(:,:,696))
  call Hloop_SS_S(ntryL,G1H12(284),ex3(:),G1H12(133),m3h1x12(:,131),heltab2x12(:,:,697))
  call Hloop_SS_S(ntryL,G1H12(285),ex3(:),G1H12(135),m3h1x12(:,132),heltab2x12(:,:,698))
  call Hloop_SS_S(ntryL,G1H12(288),ex3(:),G1H12(138),m3h1x12(:,133),heltab2x12(:,:,699))
  call Hloop_SS_S(ntryL,G1H12(289),ex3(:),G1H12(141),m3h1x12(:,134),heltab2x12(:,:,700))
  call Hloop_VS_V(ntryL,G1H12(290),ex3(:),G1H12(143),m3h1x12(:,135),heltab2x12(:,:,701))
  call Hloop_VS_V(ntryL,G1H12(291),ex3(:),G1H12(145),m3h1x12(:,136),heltab2x12(:,:,702))
  call Hloop_VS_V(ntryL,G1H12(292),ex3(:),G1H12(161),m3h1x12(:,137),heltab2x12(:,:,703))
  call Hloop_VS_V(ntryL,G1H12(293),ex3(:),G1H12(162),m3h1x12(:,138),heltab2x12(:,:,704))
  call Hloop_SS_S(ntryL,G0H12(83),ex3(:),G0H12(36),m3h1x12(:,139),heltab2x12(:,:,705))
  call Hloop_SS_S(ntryL,G0H12(84),ex3(:),G0H12(104),m3h1x12(:,140),heltab2x12(:,:,706))
  call Hloop_SS_S(ntryL,G0H12(98),ex3(:),G0H12(37),m3h1x12(:,141),heltab2x12(:,:,707))
  call Hloop_ST_V(ntryL,G1H12(295),16,ex3(:),4,G2H12(5),m3h1x12(:,142),heltab2x12(:,:,708))
  call Hloop_ST_V(ntryL,G1H12(296),16,ex3(:),4,G2H12(6),m3h1x12(:,143),heltab2x12(:,:,709))
  call Hloop_ST_V(ntryL,G1H12(298),16,ex3(:),4,G2H12(7),m3h1x12(:,144),heltab2x12(:,:,710))
  call Hloop_VT_S(ntryL,G0H12(55),16,ex3(:),4,G1H12(165),m3h1x12(:,145),heltab2x12(:,:,711))
  call Hloop_VT_S(ntryL,G0H12(57),16,ex3(:),4,G1H12(166),m3h1x12(:,146),heltab2x12(:,:,712))
  call Hloop_VT_S(ntryL,G0H12(59),16,ex3(:),4,G1H12(172),m3h1x12(:,147),heltab2x12(:,:,713))
  call Hloop_VT_S(ntryL,G0H12(85),16,ex3(:),4,G1H12(171),m3h1x12(:,148),heltab2x12(:,:,714))
  call Hloop_VT_S(ntryL,G0H12(87),16,ex3(:),4,G1H12(177),m3h1x12(:,149),heltab2x12(:,:,715))
  call Hloop_ST_V(ntryL,G0H12(71),16,ex3(:),4,G1H12(176),m3h1x12(:,150),heltab2x12(:,:,716))
  call Hloop_ST_V(ntryL,G0H12(80),16,ex3(:),4,G1H12(93),m3h1x12(:,151),heltab2x12(:,:,717))
  call Hloop_ST_V(ntryL,G0H12(81),16,ex3(:),4,G1H12(95),m3h1x12(:,152),heltab2x12(:,:,718))
  call Hloop_ST_V(ntryL,G0H12(122),16,ex3(:),4,G1H12(181),m3h1x12(:,153),heltab2x12(:,:,719))
  call Hloop_VT_S(ntryL,G1H12(300),16,ex3(:),4,G2H12(8),m3h1x12(:,154),heltab2x12(:,:,720))
  call Hloop_VT_S(ntryL,G1H12(302),16,ex3(:),4,G2H12(9),m3h1x12(:,155),heltab2x12(:,:,721))
  call Hloop_VS_V(ntryL,G0H12(124),ex3(:),G0H12(105),m3h1x12(:,156),heltab2x12(:,:,722))
  call Hloop_VS_V(ntryL,G0H12(125),ex3(:),G0H12(38),m3h1x12(:,157),heltab2x12(:,:,723))
  call Hloop_VS_V(ntryL,G0H12(127),ex3(:),G0H12(106),m3h1x12(:,158),heltab2x12(:,:,724))
  call Hloop_QA_Z(ntryL,G1H2(2),ex2(:),G1H1(16),ngZu,m3h2x1(:,46),heltab2x2(:,:,48))
  call Hloop_QA_W(ntryL,G1H2(12),ex2(:),G1H1(35),m3h2x1(:,47),heltab2x2(:,:,49))
  call Hloop_VS_V(ntryL,G0H6(1),ex3(:),G0H6(9),m3h1x6(:,19),heltab2x6(:,:,146))
  call Hloop_VS_V(ntryL,G0H6(2),ex3(:),G0H6(13),m3h1x6(:,20),heltab2x6(:,:,147))
  call Hloop_AQ_V(ntryL,G1H12(306),ex1(:),G1H6(28),m3h2x6(:,103),heltab2x12(:,:,725))
  call Hloop_AQ_Z(ntryL,G1H12(304),ex1(:),G1H6(29),ngZu,m3h2x6(:,104),heltab2x12(:,:,726))
  call Hloop_AQ_W(ntryL,G1H12(305),ex1(:),G1H6(30),m3h2x6(:,105),heltab2x12(:,:,727))
  call Hloop_WQ_A(ntryL,G1H12(307),ex1(:),G1H6(31),m3h2x6(:,106),heltab2x12(:,:,728))
  call Hloop_Q_A(ntryL,G1H6(31),21,0,G2H6(4),n2h6(90))
  call Hloop_QS_A(ntryL,G1H12(308),ex3(:),G1H12(182),ngH,m3h1x12(:,159),heltab2x12(:,:,729))
  call Hloop_Q_A(ntryL,G1H12(182),20,nML,G2H12(10),n2h12(263))
  call Hloop_AS_Q(ntryL,G1H12(309),ex3(:),G1H12(10),ngH,m3h1x12(:,160),heltab2x12(:,:,730))
  call Hloop_A_Q(ntryL,G1H12(10),20,nML,G2H12(11),n2h12(264))
  call Hloop_QS_A(ntryL,G1H12(310),ex3(:),G1H12(14),ngH,m3h1x12(:,161),heltab2x12(:,:,731))
  call Hloop_Q_A(ntryL,G1H12(14),20,nMT,G2H12(12),n2h12(265))
  call Hloop_AS_Q(ntryL,G1H12(311),ex3(:),G1H12(17),ngH,m3h1x12(:,162),heltab2x12(:,:,732))
  call Hloop_A_Q(ntryL,G1H12(17),20,nMT,G2H12(29),n2h12(266))
  call Hloop_QS_A(ntryL,G1H12(312),ex3(:),G1H12(20),ngH,m3h1x12(:,163),heltab2x12(:,:,733))
  call Hloop_Q_A(ntryL,G1H12(20),20,nMB,G2H12(30),n2h12(267))
  call Hloop_AS_Q(ntryL,G1H12(313),ex3(:),G1H12(109),ngH,m3h1x12(:,164),heltab2x12(:,:,734))
  call Hloop_A_Q(ntryL,G1H12(109),20,nMB,G2H12(31),n2h12(268))
  call Hloop_QS_A(ntryL,G1H12(314),ex3(:),G1H12(7),ngH,m3h1x12(:,165),heltab2x12(:,:,735))
  call Hloop_Q_A(ntryL,G1H12(7),20,nML,G2H12(32),n2h12(269))
  call Hloop_AS_Q(ntryL,G1H12(315),ex3(:),G1H12(19),ngH,m3h1x12(:,166),heltab2x12(:,:,736))
  call Hloop_A_Q(ntryL,G1H12(19),20,nML,G2H12(33),n2h12(270))
  call Hloop_QS_A(ntryL,G1H12(316),ex3(:),G1H12(112),ngH,m3h1x12(:,167),heltab2x12(:,:,737))
  call Hloop_Q_A(ntryL,G1H12(112),20,nMT,G2H12(34),n2h12(271))
  call Hloop_AS_Q(ntryL,G1H12(317),ex3(:),G1H12(26),ngH,m3h1x12(:,168),heltab2x12(:,:,738))
  call Hloop_A_Q(ntryL,G1H12(26),20,nMT,G2H12(35),n2h12(272))
  call Hloop_QS_A(ntryL,G1H12(318),ex3(:),G1H12(118),ngH,m3h1x12(:,169),heltab2x12(:,:,739))
  call Hloop_Q_A(ntryL,G1H12(118),20,nMB,G2H12(36),n2h12(273))
  call Hloop_AS_Q(ntryL,G1H12(319),ex3(:),G1H12(197),ngH,m3h1x12(:,170),heltab2x12(:,:,740))
  call Hloop_A_Q(ntryL,G1H12(197),20,nMB,G2H12(37),n2h12(274))
  call Hloop_SS_S(ntryL,G1H12(320),ex3(:),G1H12(199),m3h1x12(:,171),heltab2x12(:,:,741))
  call Hloop_SS_S(ntryL,G1H12(321),ex3(:),G1H12(207),m3h1x12(:,172),heltab2x12(:,:,742))
  call Hloop_SS_S(ntryL,G1H12(322),ex3(:),G1H12(208),m3h1x12(:,173),heltab2x12(:,:,743))
  call Hloop_SS_S(ntryL,G1H12(323),ex3(:),G1H12(211),m3h1x12(:,174),heltab2x12(:,:,744))
  call Hloop_SS_S(ntryL,G1H12(324),ex3(:),G1H12(213),m3h1x12(:,175),heltab2x12(:,:,745))
  call Hloop_SS_S(ntryL,G1H12(325),ex3(:),G1H12(231),m3h1x12(:,176),heltab2x12(:,:,746))
  call Hloop_SS_S(ntryL,G1H12(328),ex3(:),G1H12(232),m3h1x12(:,177),heltab2x12(:,:,747))
  call Hloop_SS_S(ntryL,G1H12(329),ex3(:),G1H12(237),m3h1x12(:,178),heltab2x12(:,:,748))
  call Hloop_SS_S(ntryL,G1H12(332),ex3(:),G1H12(239),m3h1x12(:,179),heltab2x12(:,:,749))
  call Hloop_SS_S(ntryL,G1H12(333),ex3(:),G1H12(247),m3h1x12(:,180),heltab2x12(:,:,750))
  call Hloop_VS_V(ntryL,G1H12(334),ex3(:),G1H12(249),m3h1x12(:,181),heltab2x12(:,:,751))
  call Hloop_VS_V(ntryL,G1H12(335),ex3(:),G1H12(250),m3h1x12(:,182),heltab2x12(:,:,752))
  call Hloop_VS_V(ntryL,G1H12(336),ex3(:),G1H12(253),m3h1x12(:,183),heltab2x12(:,:,753))
  call Hloop_VS_V(ntryL,G1H12(337),ex3(:),G1H12(255),m3h1x12(:,184),heltab2x12(:,:,754))
  call Hloop_SS_S(ntryL,G0H12(129),ex3(:),G0H12(39),m3h1x12(:,185),heltab2x12(:,:,755))
  call Hloop_SS_S(ntryL,G0H12(130),ex3(:),G0H12(107),m3h1x12(:,186),heltab2x12(:,:,756))
  call Hloop_SS_S(ntryL,G0H12(132),ex3(:),G0H12(40),m3h1x12(:,187),heltab2x12(:,:,757))
  call Hloop_ST_V(ntryL,G1H12(339),16,ex3(:),4,G2H12(38),m3h1x12(:,188),heltab2x12(:,:,758))
  call Hloop_ST_V(ntryL,G1H12(340),16,ex3(:),4,G2H12(39),m3h1x12(:,189),heltab2x12(:,:,759))
  call Hloop_ST_V(ntryL,G1H12(342),16,ex3(:),4,G2H12(40),m3h1x12(:,190),heltab2x12(:,:,760))
  call Hloop_VT_S(ntryL,G0H12(133),16,ex3(:),4,G1H12(257),m3h1x12(:,191),heltab2x12(:,:,761))
  call Hloop_VT_S(ntryL,G0H12(134),16,ex3(:),4,G1H12(259),m3h1x12(:,192),heltab2x12(:,:,762))
  call Hloop_VT_S(ntryL,G0H12(135),16,ex3(:),4,G1H12(282),m3h1x12(:,193),heltab2x12(:,:,763))
  call Hloop_VT_S(ntryL,G0H12(136),16,ex3(:),4,G1H12(283),m3h1x12(:,194),heltab2x12(:,:,764))
  call Hloop_VT_S(ntryL,G0H12(137),16,ex3(:),4,G1H12(286),m3h1x12(:,195),heltab2x12(:,:,765))
  call Hloop_ST_V(ntryL,G0H12(138),16,ex3(:),4,G1H12(287),m3h1x12(:,196),heltab2x12(:,:,766))
  call Hloop_ST_V(ntryL,G0H12(139),16,ex3(:),4,G1H12(294),m3h1x12(:,197),heltab2x12(:,:,767))
  call Hloop_ST_V(ntryL,G0H12(140),16,ex3(:),4,G1H12(297),m3h1x12(:,198),heltab2x12(:,:,768))
  call Hloop_ST_V(ntryL,G0H12(141),16,ex3(:),4,G1H12(299),m3h1x12(:,199),heltab2x12(:,:,769))
  call Hloop_VT_S(ntryL,G1H12(344),16,ex3(:),4,G2H12(41),m3h1x12(:,200),heltab2x12(:,:,770))
  call Hloop_VT_S(ntryL,G1H12(346),16,ex3(:),4,G2H12(42),m3h1x12(:,201),heltab2x12(:,:,771))
  call Hloop_VS_V(ntryL,G0H12(143),ex3(:),G0H12(108),m3h1x12(:,202),heltab2x12(:,:,772))
  call Hloop_VS_V(ntryL,G0H12(144),ex3(:),G0H12(41),m3h1x12(:,203),heltab2x12(:,:,773))
  call Hloop_VS_V(ntryL,G0H12(146),ex3(:),G0H12(109),m3h1x12(:,204),heltab2x12(:,:,774))
  call Hloop_AQ_Z(ntryL,G1H2(11),ex1(:),G1H1(60),ngZu,m3h2x1(:,48),heltab2x2(:,:,50))
  call Hloop_AQ_W(ntryL,G1H2(4),ex1(:),G1H1(23),m3h2x1(:,49),heltab2x2(:,:,51))
  call Hloop_VA_Q(ntryL,G0H6(8),ex2(:),G0H3(4),m3h2x3(:,91),heltab2x6(:,:,148))
  call Hloop_A_Q(ntryL,G0H3(4),19,0,G1H3(79),n2h3(261))
  call Hloop_ZA_Q(ntryL,G0H6(6),ex2(:),G0H3(10),ngZu,m3h2x3(:,92),heltab2x6(:,:,149))
  call Hloop_A_Q(ntryL,G0H3(10),19,0,G1H3(61),n2h3(262))
  call Hloop_WA_Q(ntryL,G0H6(7),ex2(:),G0H3(21),m3h2x3(:,93),heltab2x6(:,:,150))
  call Hloop_A_Q(ntryL,G0H3(21),19,0,G1H3(88),n2h3(263))
  call Hloop_QA_W(ntryL,G1H6(6),ex2(:),G1H3(161),m3h2x3(:,94),heltab2x6(:,:,151))
  call Hloop_VQ_A(ntryL,G0H6(12),ex1(:),G0H3(23),m3h2x3(:,95),heltab2x6(:,:,152))
  call Hloop_Q_A(ntryL,G0H3(23),19,0,G1H3(66),n2h3(264))
  call Hloop_ZQ_A(ntryL,G0H6(10),ex1(:),G0H3(18),ngZu,m3h2x3(:,96),heltab2x6(:,:,153))
  call Hloop_Q_A(ntryL,G0H3(18),19,0,G1H3(17),n2h3(265))
  call Hloop_WQ_A(ntryL,G0H6(11),ex1(:),G0H3(15),m3h2x3(:,97),heltab2x6(:,:,154))
  call Hloop_Q_A(ntryL,G0H3(15),19,0,G1H3(162),n2h3(266))
  call Hloop_AQ_W(ntryL,G1H6(11),ex1(:),G1H3(131),m3h2x3(:,98),heltab2x6(:,:,155))
  call Hloop_QA_V(ntryL,G1H12(350),ex2(:),G1H6(32),m3h2x6(:,107),heltab2x12(:,:,775))
  call Hloop_QA_Z(ntryL,G1H12(348),ex2(:),G1H6(33),ngZu,m3h2x6(:,108),heltab2x12(:,:,776))
  call Hloop_QA_W(ntryL,G1H12(349),ex2(:),G1H6(34),m3h2x6(:,109),heltab2x12(:,:,777))
  call Hloop_WA_Q(ntryL,G1H12(351),ex2(:),G1H6(35),m3h2x6(:,110),heltab2x12(:,:,778))
  call Hloop_A_Q(ntryL,G1H6(35),18,0,G2H6(8),n2h6(91))
  call Hloop_AQ_V(ntryL,G1H12(355),ex1(:),G1H6(36),m3h2x6(:,111),heltab2x12(:,:,779))
  call Hloop_AQ_Z(ntryL,G1H12(353),ex1(:),G1H6(19),ngZu,m3h2x6(:,112),heltab2x12(:,:,780))
  call Hloop_AQ_W(ntryL,G1H12(354),ex1(:),G1H6(20),m3h2x6(:,113),heltab2x12(:,:,781))
  call Hloop_WQ_A(ntryL,G1H12(356),ex1(:),G1H6(22),m3h2x6(:,114),heltab2x12(:,:,782))
  call Hloop_Q_A(ntryL,G1H6(22),17,0,G2H6(13),n2h6(92))
  call Hloop_SS_S(ntryL,G1H3(80),ex3(:),G1H3(124),m3h1x3(:,97),heltab2x3(:,:,439))
  call Hloop_SS_S(ntryL,G1H3(81),ex3(:),G1H3(171),m3h1x3(:,98),heltab2x3(:,:,440))
  call Hloop_SS_S(ntryL,G0H3(50),ex3(:),G0H3(17),m3h1x3(:,99),heltab2x3(:,:,441))
  call Hloop_VT_S(ntryL,G0H3(55),19,ex3(:),4,G1H3(55),m3h1x3(:,100),heltab2x3(:,:,442))
  call Hloop_ST_V(ntryL,G1H3(181),19,ex3(:),4,G2H3(175),m3h1x3(:,101),heltab2x3(:,:,443))
  call Hloop_VS_V(ntryL,G0H3(64),ex3(:),G0H3(13),m3h1x3(:,102),heltab2x3(:,:,444))
  call Hloop_VA_Q(ntryL,G0H6(16),ex2(:),G0H3(52),m3h2x3(:,99),heltab2x6(:,:,156))
  call Hloop_A_Q(ntryL,G0H3(52),23,0,G1H3(33),n2h3(267))
  call Hloop_ZA_Q(ntryL,G0H6(14),ex2(:),G0H3(51),ngZu,m3h2x3(:,100),heltab2x6(:,:,157))
  call Hloop_A_Q(ntryL,G0H3(51),23,0,G1H3(172),n2h3(268))
  call Hloop_WA_Q(ntryL,G0H6(15),ex2(:),G0H3(49),m3h2x3(:,101),heltab2x6(:,:,158))
  call Hloop_A_Q(ntryL,G0H3(49),23,0,G1H3(56),n2h3(269))
  call Hloop_QA_W(ntryL,G1H6(25),ex2(:),G1H3(34),m3h2x3(:,102),heltab2x6(:,:,159))
  call Hloop_VQ_A(ntryL,G0H6(20),ex1(:),G0H3(48),m3h2x3(:,103),heltab2x6(:,:,160))
  call Hloop_Q_A(ntryL,G0H3(48),23,0,G1H3(165),n2h3(270))
  call Hloop_ZQ_A(ntryL,G0H6(18),ex1(:),G0H3(33),ngZu,m3h2x3(:,104),heltab2x6(:,:,161))
  call Hloop_Q_A(ntryL,G0H3(33),23,0,G1H3(157),n2h3(271))
  call Hloop_WQ_A(ntryL,G0H6(19),ex1(:),G0H3(32),m3h2x3(:,105),heltab2x6(:,:,162))
  call Hloop_Q_A(ntryL,G0H3(32),23,0,G1H3(153),n2h3(272))
  call Hloop_AQ_W(ntryL,G1H6(13),ex1(:),G1H3(1),m3h2x3(:,106),heltab2x6(:,:,163))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(153),[G1H3(159)])
call HGT_w2_OLR(G1H3(108),1,1,3)
call HGT_w2_invQ_OLR(G1H3(108),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(108),[G1H3(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(55),[G2H1(53),G2H1(52),G2H1(7),G1H1(15),G1H1(18),G0H1(2) &
    ,G0H1(1)])
call HGT_w2_OLR(G1H1(2),1,1,1)
call HGT_w2_invQ_OLR(G1H1(2),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(55),[G1H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(128),[G2H3(139),G2H3(136),G2H3(133),G2H3(130),G2H3(53) &
    ,G1H3(139),G1H3(164),G1H3(130),G1H3(225),G1H3(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(116),[G2H3(113),G1H3(26),G1H3(49),G1H3(107),G1H3(83)])
call HGT_lower_alpha_OLR(G1H3(109),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(109),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(116),[G1H3(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(27),[G2H1(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(114),[G2H3(111),G1H3(4),G1H3(186),G1H3(146),G1H3(19)])
call HGT_lower_alpha_OLR(G1H3(15),1,1,3)
call HGT_lower_alpha_invQ_OLR(G1H3(15),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(114),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(52),G1H3(207)])
call HGT_OLR(G2H3(58),1,1,3)
call HGT_invQ_OLR(G2H3(58),2,5,3)
call HGT_OLR(G2H3(58),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(30),[G1H1(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G2H3(3),G1H3(211)])
call HGT_OLR(G2H3(62),1,1,3)
call HGT_invQ_OLR(G2H3(62),2,5,3)
call HGT_OLR(G2H3(62),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(62),[G2H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(33),[G1H1(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(60),[G2H3(21),G1H3(215)])
call HGT_OLR(G2H3(57),1,1,3)
call HGT_invQ_OLR(G2H3(57),2,5,3)
call HGT_OLR(G2H3(57),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(57),[G2H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(36),[G1H1(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(40),[G2H3(30),G1H3(219)])
call HGT_OLR(G2H3(66),1,1,3)
call HGT_invQ_OLR(G2H3(66),2,5,3)
call HGT_OLR(G2H3(66),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(39),[G1H1(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G2H3(59),G1H3(223)])
call HGT_OLR(G2H3(71),1,1,3)
call HGT_invQ_OLR(G2H3(71),2,5,3)
call HGT_OLR(G2H3(71),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(71),[G2H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(42),[G1H1(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(65),[G2H3(55),G1H3(227)])
call HGT_OLR(G2H3(72),1,1,3)
call HGT_invQ_OLR(G2H3(72),2,5,3)
call HGT_OLR(G2H3(72),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(72),[G2H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(45),[G1H1(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(89),[G2H3(86),G1H3(229),G1H3(70),G1H3(132)])
call HGT_OLR(G1H3(23),1,1,3)
call HGT_invQ_OLR(G1H3(23),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(89),[G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(51),[G2H1(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(92),[G2H3(87),G1H3(189),G1H3(226),G1H3(98)])
call HGT_OLR(G1H3(6),1,1,3)
call HGT_invQ_OLR(G1H3(6),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(92),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(18),G1H3(5)])
call HGT_OLR(G1H3(7),1,1,3)
call HGT_invQ_OLR(G1H3(7),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(34),[G2H3(22),G1H3(41)])
call HGT_OLR(G1H3(22),1,1,3)
call HGT_invQ_OLR(G1H3(22),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(34),[G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(17),[G2H1(14)])
call HGT_OLR(G2H1(59),1,1,1)
call HGT_invQ_OLR(G2H1(59),2,5,1)
call HGT_OLR(G2H1(59),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(59),[G2H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(154),[G2H3(117),G2H3(115),G2H3(97),G2H3(73),G1H3(212) &
    ,G1H3(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(37),[G2H1(31)])
call HGT_OLR(G2H1(60),1,1,1)
call HGT_invQ_OLR(G2H1(60),2,5,1)
call HGT_OLR(G2H1(60),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(60),[G2H1(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(156),[G2H3(119),G2H3(112),G2H3(94),G2H3(76),G1H3(208) &
    ,G1H3(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(40),[G2H1(34)])
call HGT_OLR(G2H1(61),1,1,1)
call HGT_invQ_OLR(G2H1(61),2,5,1)
call HGT_OLR(G2H1(61),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(61),[G2H1(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(158),[G2H3(120),G2H3(121),G2H3(103),G2H3(79),G1H3(220) &
    ,G1H3(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(38),[G2H1(32)])
call HGT_OLR(G2H1(62),1,1,1)
call HGT_invQ_OLR(G2H1(62),2,5,1)
call HGT_OLR(G2H1(62),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(62),[G2H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(160),[G2H3(122),G2H3(118),G2H3(100),G2H3(82),G1H3(216) &
    ,G1H3(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(41),[G2H1(35)])
call HGT_OLR(G2H1(63),1,1,1)
call HGT_invQ_OLR(G2H1(63),2,5,1)
call HGT_OLR(G2H1(63),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(63),[G2H1(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(162),[G2H3(123),G2H3(127),G2H3(109),G2H3(85),G1H3(228) &
    ,G1H3(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G2H1(8)])
call HGT_OLR(G2H1(64),1,1,1)
call HGT_invQ_OLR(G2H1(64),2,5,1)
call HGT_OLR(G2H1(64),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(64),[G2H1(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(164),[G2H3(125),G2H3(124),G2H3(106),G2H3(88),G1H3(224) &
    ,G1H3(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(46),[G2H1(44),G2H1(9),G2H1(43),G0H1(4),G0H1(3)])
call HGT_lower_alpha_w2_OLR(G1H1(33),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G1H1(33),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(46),[G1H1(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(126),[G2H3(151),G2H3(148),G2H3(145),G2H3(142),G2H3(91) &
    ,G1H3(94),G1H3(122),G1H3(72),G1H3(129),G1H3(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(162),[G1H3(63)])
call HGT_w2_OLR(G1H3(76),1,1,3)
call HGT_w2_invQ_OLR(G1H3(76),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(76),[G1H3(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(1),[G1H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(34),[G1H3(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(170),[G1H3(27),G1H3(13),G1H3(8),G0H3(2),G0H3(25) &
    ,G0H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(171),[G1H3(214),G1H3(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(165),[G1H3(32),G1H3(39),G1H3(149),G0H3(14),G0H3(5) &
    ,G0H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(173),[G1H3(127),G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(169),[G1H3(205),G1H3(110),G1H3(92),G0H3(12),G0H3(26) &
    ,G0H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(172),[G1H3(217),G1H3(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(166),[G1H3(202),G1H3(133),G1H3(117),G0H3(16),G0H3(6) &
    ,G0H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(174),[G1H3(218),G1H3(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(135),[G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(167),[G1H3(198),G1H3(52),G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(45),[G1H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(168),[G1H3(201),G1H3(24),G1H3(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(79),[G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G2H3(45),G1H3(151),G1H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(61),[G1H3(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(88),[G1H3(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G2H3(32),G1H3(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(161),[G1H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(8),G1H3(25),G0H3(9),G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(66),[G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G2H3(49),G1H3(163),G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(17),[G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G2H3(4),G1H3(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(131),[G1H3(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G2H3(7),G1H3(75),G0H3(3),G0H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(165),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(80),[G2H3(47),G1H3(155),G1H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(157),[G1H3(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(83),[G2H3(54),G1H3(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(81),[G2H3(48),G1H3(174),G1H3(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(172),[G1H3(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(56),[G1H3(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(84),[G2H3(61),G1H3(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(4),[G1H1(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(3),[G1H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(5),[G1H1(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(50),[G1H1(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(26),[G1H1(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(147),[G1H3(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(144),[G1H3(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(141),[G1H3(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G1H3(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(17),[G1H3(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(70),[G1H3(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G1H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G2H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(21),[G2H1(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(56),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G2H3(42),G2H3(39),G2H3(41),G1H3(62),G1H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(93),[G2H3(129),G2H3(132),G2H3(135),G1H3(104),G1H3(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(36),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(41),[G1H1(56),G1H1(5),G1H1(43),G1H1(64),G1H1(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(21),[G1H1(59),G1H1(8),G1H1(44),G1H1(6),G1H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(118),[G1H3(28),G1H3(60),G1H3(136),G1H3(99),G1H3(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(137),[G1H3(101),G1H3(91),G1H3(113),G1H3(9),G1H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(104),[G2H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(105),[G2H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(107),[G2H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(108),[G2H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(110),[G2H3(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(137),[G2H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(149),[G2H3(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(146),[G2H3(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(182),[G1H3(145),G1H3(3),G1H3(112),G1H3(106),G1H3(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(177),[G1H3(180),G1H3(2),G1H3(47),G1H3(140),G1H3(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(68),[G2H3(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(67),[G2H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(27),[G2H3(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G2H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G2H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G2H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G2H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G2H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G2H3(90),G0H3(24),G0H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G2H3(64),G0H3(8),G0H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G2H3(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G2H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(148),[G1H3(10),G1H3(126),G1H3(150),G1H3(30),G1H3(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(14),[G1H3(78),G1H3(143),G1H3(20),G1H3(102),G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(77),[G2H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G2H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(11),[G1H1(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(13),[G1H1(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(38),[G1H12(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(68),[G1H12(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G0H12(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G0H12(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(165),[G1H12(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(166),[G1H12(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(172),[G1H12(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(171),[G1H12(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(177),[G1H12(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(176),[G1H12(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(93),[G1H12(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(95),[G1H12(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(181),[G1H12(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G0H12(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(5),[G0H12(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(6),[G0H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G0H12(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(257),[G1H12(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(259),[G1H12(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(282),[G1H12(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(283),[G1H12(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(286),[G1H12(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(287),[G1H12(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(294),[G1H12(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(297),[G1H12(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(299),[G1H12(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G0H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(42),[G0H12(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(38),[G0H12(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(39),[G0H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(40),[G0H12(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(55),[G1H3(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(175),[G0H3(13)])
  call Hloop_QZ_A(ntryL,G1H3(108),ex4(:),G1H1(63),ngZd,m3h3x1(:,343),heltab2x3(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(63),31,0,G2tensor(23),n2h1(249))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(4),m3h2x1(:,50),heltab2x2(:,:,52))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H1(55),27,ex3(:),4,G3tensor(19),m3h1x1(:,111),heltab2x1(:,:,111))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(128),ex4(:),G2tensor(35),m3h3x1(:,344),heltab2x3(:,:,446))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(116),23,ex4(:),8,G3tensor(20),m3h3x1(:,345),heltab2x3(:,:,447))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(27),ex3(:),G2tensor(8),m3h1x1(:,112),heltab2x1(:,:,112))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(114),23,ex4(:),8,G3tensor(21),m3h3x1(:,346),heltab2x3(:,:,448))
  call Hloop_QZ_A(ntryL,G2H3(58),ex4(:),G2H1(56),ngZl,m3h3x1(:,347),heltab2x3(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(56),31,nML,G3tensor(22),n2h1(250))
  call Hloop_QS_A(ntryL,G2H1(30),ex3(:),G2H1(58),ngH,m3h1x1(:,113),heltab2x1(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(58),31,nML,G3tensor(23),n2h1(251))
  call Hloop_AZ_Q(ntryL,G2H3(62),ex4(:),G2H1(13),ngZl,m3h3x1(:,348),heltab2x3(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nML,G3tensor(24),n2h1(252))
  call Hloop_AS_Q(ntryL,G2H1(33),ex3(:),G2H1(10),ngH,m3h1x1(:,114),heltab2x1(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nML,G3tensor(25),n2h1(253))
  call Hloop_QZ_A(ntryL,G2H3(57),ex4(:),G2H1(47),ngZu,m3h3x1(:,349),heltab2x3(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(47),31,nMT,G3tensor(26),n2h1(254))
  call Hloop_QS_A(ntryL,G2H1(36),ex3(:),G2H1(23),ngH,m3h1x1(:,115),heltab2x1(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMT,G3tensor(27),n2h1(255))
  call Hloop_AZ_Q(ntryL,G2H3(66),ex4(:),G2H1(25),ngZu,m3h3x1(:,350),heltab2x3(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(25),31,nMT,G3tensor(28),n2h1(256))
  call Hloop_AS_Q(ntryL,G2H1(39),ex3(:),G2H1(49),ngH,m3h1x1(:,116),heltab2x1(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(49),31,nMT,G3tensor(29),n2h1(257))
  call Hloop_QZ_A(ntryL,G2H3(71),ex4(:),G2H1(16),ngZd,m3h3x1(:,351),heltab2x3(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nMB,G3tensor(30),n2h1(258))
  call Hloop_QS_A(ntryL,G2H1(42),ex3(:),G2H1(18),ngH,m3h1x1(:,117),heltab2x1(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(18),31,nMB,G3tensor(31),n2h1(259))
  call Hloop_AZ_Q(ntryL,G2H3(72),ex4(:),G2H1(20),ngZd,m3h3x1(:,352),heltab2x3(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),31,nMB,G3tensor(32),n2h1(260))
  call Hloop_AS_Q(ntryL,G2H1(45),ex3(:),G2H1(22),ngH,m3h1x1(:,118),heltab2x1(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),31,nMB,G3tensor(33),n2h1(261))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(89),23,ex4(:),8,G3tensor(34),m3h3x1(:,353),heltab2x3(:,:,455))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(51),ex3(:),G2tensor(10),m3h1x1(:,119),heltab2x1(:,:,119))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(92),23,ex4(:),8,G3tensor(35),m3h3x1(:,354),heltab2x3(:,:,456))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(24),23,ex4(:),8,G3tensor(36),m3h3x1(:,355),heltab2x3(:,:,457))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(54),ex3(:),G2tensor(12),m3h1x1(:,120),heltab2x1(:,:,120))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(34),23,ex4(:),G3tensor(37),m3h3x1(:,356),heltab2x3(:,:,458))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(57),ex3(:),G2tensor(135),m3h1x1(:,121),heltab2x1(:,:,121))
  call Hloop_AS_Q(ntryL,G2H1(59),ex3(:),G2H1(12),ngH,m3h1x1(:,122),heltab2x1(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),31,nML,G3tensor(38),n2h1(262))
  call Hloop_AZ_Q(ntryL,G2H3(154),ex4(:),G2H1(15),ngZl,m3h3x1(:,357),heltab2x3(:,:,459))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nML,G3tensor(39),n2h1(263))
  call Hloop_QS_A(ntryL,G2H1(60),ex3(:),G2H1(53),ngH,m3h1x1(:,123),heltab2x1(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(53),31,nML,G3tensor(40),n2h1(264))
  call Hloop_QZ_A(ntryL,G2H3(156),ex4(:),G2H1(52),ngZl,m3h3x1(:,358),heltab2x3(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(52),31,nML,G3tensor(41),n2h1(265))
  call Hloop_AS_Q(ntryL,G2H1(61),ex3(:),G2H1(7),ngH,m3h1x1(:,124),heltab2x1(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMT,G3tensor(42),n2h1(266))
  call Hloop_AZ_Q(ntryL,G2H3(158),ex4(:),G2H1(24),ngZu,m3h3x1(:,359),heltab2x3(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(24),31,nMT,G3tensor(43),n2h1(267))
  call Hloop_QS_A(ntryL,G2H1(62),ex3(:),G2H1(48),ngH,m3h1x1(:,125),heltab2x1(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(48),31,nMT,G3tensor(44),n2h1(268))
  call Hloop_QZ_A(ntryL,G2H3(160),ex4(:),G2H1(14),ngZu,m3h3x1(:,360),heltab2x3(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(14),31,nMT,G3tensor(45),n2h1(269))
  call Hloop_AS_Q(ntryL,G2H1(63),ex3(:),G2H1(17),ngH,m3h1x1(:,126),heltab2x1(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),31,nMB,G3tensor(46),n2h1(270))
  call Hloop_AZ_Q(ntryL,G2H3(162),ex4(:),G2H1(31),ngZd,m3h3x1(:,361),heltab2x3(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(31),31,nMB,G3tensor(47),n2h1(271))
  call Hloop_QS_A(ntryL,G2H1(64),ex3(:),G2H1(37),ngH,m3h1x1(:,127),heltab2x1(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(37),31,nMB,G3tensor(48),n2h1(272))
  call Hloop_QZ_A(ntryL,G2H3(164),ex4(:),G2H1(34),ngZd,m3h3x1(:,362),heltab2x3(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(34),31,nMB,G3tensor(49),n2h1(273))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H1(46),27,ex3(:),4,G3tensor(50),m3h1x1(:,128),heltab2x1(:,:,128))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(126),ex4(:),G2tensor(41),m3h3x1(:,363),heltab2x3(:,:,465))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,1),G2H1(40),m3h4x1(:,41),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(40),31,nML,G3tensor(51),n2h1(274))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,1),G2H1(32),m3h4x1(:,42),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(32),31,nML,G3tensor(52),n2h1(275))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,1),G2H1(38),m3h4x1(:,43),heltab2x4(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(38),31,nMT,G3tensor(53),n2h1(276))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,1),G2H1(35),m3h4x1(:,44),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(35),31,nMT,G3tensor(54),n2h1(277))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,1),G2H1(41),m3h4x1(:,45),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(41),31,nMB,G3tensor(55),n2h1(278))
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(6),wf4(:,1),G2H1(8),m3h4x1(:,46),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,nMB,G3tensor(56),n2h1(279))
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(7),wf4(:,2),G2H1(11),ngZl,m3h4x1(:,47),heltab2x4(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),31,nML,G3tensor(57),n2h1(280))
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(8),wf4(:,2),G2H1(44),ngZl,m3h4x1(:,48),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(44),31,nML,G3tensor(58),n2h1(281))
call HGT_OLR(G2H4(9),1,1,4)
call HGT_invQ_OLR(G2H4(9),2,5,4)
call HGT_OLR(G2H4(9),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(9),wf4(:,2),G2H1(9),ngZu,m3h4x1(:,49),heltab2x4(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMT,G3tensor(59),n2h1(282))
call HGT_OLR(G2H4(10),1,1,4)
call HGT_invQ_OLR(G2H4(10),2,5,4)
call HGT_OLR(G2H4(10),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(10),wf4(:,2),G2H1(43),ngZu,m3h4x1(:,50),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(43),31,nMT,G3tensor(60),n2h1(283))
call HGT_OLR(G2H4(11),1,1,4)
call HGT_invQ_OLR(G2H4(11),2,5,4)
call HGT_OLR(G2H4(11),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(11),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,51),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(61),n2h1(284))
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(12),wf4(:,2),G2H1(19),ngZd,m3h4x1(:,52),heltab2x4(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(19),31,nMB,G3tensor(62),n2h1(285))
call HGT_w2_OLR(G1H4(5),1,1,4)
call HGT_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(5),28,wf4(:,1),3,G2tensor(38),m3h4x1(:,53),heltab2x4(:,:,67))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(6),28,wf4(:,1),3,G2tensor(32),m3h4x1(:,54),heltab2x4(:,:,68))
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(7),28,wf4(:,2),3,G2tensor(29),m3h4x1(:,55),heltab2x4(:,:,69))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(8),28,wf4(:,2),3,G2tensor(16),m3h4x1(:,56),heltab2x4(:,:,70))
call HGT_lower_alpha_w2_OLR(G1H4(1),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(1),28,wf4(:,1),3,G2tensor(14),m3h4x1(:,57),heltab2x4(:,:,71))
call HGT_lower_alpha_w2_OLR(G1H4(2),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(2),28,wf4(:,1),3,G2tensor(133),m3h4x1(:,58),heltab2x4(:,:,72))
call HGT_lower_alpha_w2_OLR(G1H4(3),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(3),28,wf4(:,2),3,G2tensor(56),m3h4x1(:,59),heltab2x4(:,:,73))
call HGT_lower_alpha_w2_OLR(G1H4(4),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(4),28,wf4(:,2),3,G2tensor(53),m3h4x1(:,60),heltab2x4(:,:,74))
  call Hloop_QZ_A(ntryL,G1H3(76),wf3(:,2),G1H1(27),ngZd,m3h3x1(:,364),heltab2x3(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,0,G2tensor(50),n2h1(286))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(47),m3h2x1(:,51),heltab2x2(:,:,53))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(7),27,ex3(:),4,G2tensor(20),m3h1x1(:,129),heltab2x1(:,:,129))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(1),23,ex4(:),8,G2tensor(18),m3h3x1(:,365),heltab2x3(:,:,467))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(31),27,ex3(:),4,G2tensor(22),m3h1x1(:,130),heltab2x1(:,:,130))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(34),23,ex4(:),8,G2tensor(25),m3h3x1(:,366),heltab2x3(:,:,468))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(170),23,ex4(:),8,G3tensor(63),m3h3x1(:,367),heltab2x3(:,:,469))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(171),23,ex4(:),8,G3tensor(64),m3h3x1(:,368),heltab2x3(:,:,470))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(165),23,ex4(:),8,G3tensor(65),m3h3x1(:,369),heltab2x3(:,:,471))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(173),23,ex4(:),8,G3tensor(66),m3h3x1(:,370),heltab2x3(:,:,472))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(169),23,ex4(:),8,G3tensor(67),m3h3x1(:,371),heltab2x3(:,:,473))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(32),27,ex3(:),4,G2tensor(26),m3h1x1(:,131),heltab2x1(:,:,131))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(3),27,ex3(:),4,G2tensor(31),m3h1x1(:,132),heltab2x1(:,:,132))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(39),27,ex3(:),4,G2tensor(28),m3h1x1(:,133),heltab2x1(:,:,133))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(40),27,ex3(:),4,G2tensor(34),m3h1x1(:,134),heltab2x1(:,:,134))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(172),23,ex4(:),8,G3tensor(68),m3h3x1(:,372),heltab2x3(:,:,474))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(166),23,ex4(:),8,G3tensor(69),m3h3x1(:,373),heltab2x3(:,:,475))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(174),23,ex4(:),8,G3tensor(70),m3h3x1(:,374),heltab2x3(:,:,476))
  call Hloop_WA_Q(ntryL,G1H2(6),ex2(:),G1H1(28),m3h2x1(:,52),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,0,G2tensor(118),n2h1(287))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(29),m3h2x1(:,53),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,0,G2tensor(40),n2h1(288))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(135),23,ex4(:),G2tensor(37),m3h3x1(:,375),heltab2x3(:,:,477))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(167),23,ex4(:),G3tensor(71),m3h3x1(:,376),heltab2x3(:,:,478))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(45),23,ex4(:),8,G2tensor(43),m3h3x1(:,377),heltab2x3(:,:,479))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(168),23,ex4(:),8,G3tensor(72),m3h3x1(:,378),heltab2x3(:,:,480))
  call Hloop_AZ_Q(ntryL,G1H3(79),wf3(:,2),G1H1(30),ngZu,m3h3x1(:,379),heltab2x3(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,0,G2tensor(44),n2h1(289))
  call Hloop_AZ_Q(ntryL,G2H3(9),wf3(:,2),G2H1(55),ngZu,m3h3x1(:,380),heltab2x3(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(55),31,0,G3tensor(73),n2h1(290))
  call Hloop_AZ_Q(ntryL,G1H3(61),wf3(:,2),G1H1(34),ngZu,m3h3x1(:,381),heltab2x3(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,0,G2tensor(49),n2h1(291))
  call Hloop_AZ_Q(ntryL,G1H3(88),wf3(:,2),G1H1(47),ngZd,m3h3x1(:,382),heltab2x3(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),31,0,G2tensor(46),n2h1(292))
  call Hloop_AZ_Q(ntryL,G2H3(2),wf3(:,2),G2H1(27),ngZd,m3h3x1(:,383),heltab2x3(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(27),31,0,G3tensor(74),n2h1(293))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(161),19,wf3(:,2),12,G2tensor(116),m3h3x1(:,384),heltab2x3(:,:,486))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(16),19,wf3(:,2),12,G3tensor(75),m3h3x1(:,385),heltab2x3(:,:,487))
  call Hloop_QZ_A(ntryL,G1H3(66),wf3(:,2),G1H1(24),ngZu,m3h3x1(:,386),heltab2x3(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,0,G2tensor(55),n2h1(294))
  call Hloop_QZ_A(ntryL,G2H3(11),wf3(:,2),G2H1(56),ngZu,m3h3x1(:,387),heltab2x3(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(56),31,0,G3tensor(76),n2h1(295))
  call Hloop_QZ_A(ntryL,G1H3(17),wf3(:,2),G1H1(10),ngZu,m3h3x1(:,388),heltab2x3(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,0,G2tensor(52),n2h1(296))
  call Hloop_QZ_A(ntryL,G2H3(19),wf3(:,2),G2H1(30),ngZd,m3h3x1(:,389),heltab2x3(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(30),31,0,G3tensor(77),n2h1(297))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(131),19,wf3(:,2),12,G2tensor(59),m3h3x1(:,390),heltab2x3(:,:,492))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(12),19,wf3(:,2),12,G3tensor(78),m3h3x1(:,391),heltab2x3(:,:,493))
  call Hloop_QZ_A(ntryL,G1H3(165),ex4(:),G1H1(14),ngZu,m3h3x1(:,392),heltab2x3(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,0,G2tensor(62),n2h1(298))
  call Hloop_QZ_A(ntryL,G2H3(80),ex4(:),G2H1(58),ngZu,m3h3x1(:,393),heltab2x3(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(58),31,0,G3tensor(79),n2h1(299))
  call Hloop_QZ_A(ntryL,G1H3(157),ex4(:),G1H1(48),ngZu,m3h3x1(:,394),heltab2x3(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(48),31,0,G2tensor(64),n2h1(300))
  call Hloop_QZ_A(ntryL,G2H3(83),ex4(:),G2H1(13),ngZd,m3h3x1(:,395),heltab2x3(:,:,497))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,0,G3tensor(80),n2h1(301))
  call Hloop_AZ_Q(ntryL,G1H3(33),ex4(:),G1H1(17),ngZu,m3h3x1(:,396),heltab2x3(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,0,G2tensor(68),n2h1(302))
  call Hloop_AZ_Q(ntryL,G2H3(81),ex4(:),G2H1(33),ngZu,m3h3x1(:,397),heltab2x3(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(33),31,0,G3tensor(81),n2h1(303))
  call Hloop_AZ_Q(ntryL,G1H3(172),ex4(:),G1H1(51),ngZu,m3h3x1(:,398),heltab2x3(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(51),31,0,G2tensor(74),n2h1(304))
  call Hloop_AZ_Q(ntryL,G1H3(56),ex4(:),G1H1(37),ngZd,m3h3x1(:,399),heltab2x3(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,0,G2tensor(71),n2h1(305))
  call Hloop_AZ_Q(ntryL,G2H3(84),ex4(:),G2H1(10),ngZd,m3h3x1(:,400),heltab2x3(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,0,G3tensor(82),n2h1(306))
  call Hloop_WA_Q(ntryL,G1H2(5),ex2(:),G1H1(12),m3h2x1(:,54),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,0,G2tensor(24),n2h1(307))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(25),m3h2x1(:,55),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,0,G2tensor(9),n2h1(308))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(36),27,ex3(:),4,G2tensor(73),m3h1x1(:,135),heltab2x1(:,:,135))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(4),27,ex3(:),4,G2tensor(76),m3h1x1(:,136),heltab2x1(:,:,136))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(54),m3h1x1(:,137),heltab2x1(:,:,137))
  call Hloop_QS_A(ntryL,G2H1(3),ex3(:),G2H1(47),ngH,m3h1x1(:,138),heltab2x1(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(47),31,nML,G3tensor(83),n2h1(309))
  call Hloop_AS_Q(ntryL,G2H1(4),ex3(:),G2H1(36),ngH,m3h1x1(:,139),heltab2x1(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(36),31,nML,G3tensor(84),n2h1(310))
  call Hloop_QS_A(ntryL,G2H1(5),ex3(:),G2H1(23),ngH,m3h1x1(:,140),heltab2x1(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMT,G3tensor(85),n2h1(311))
  call Hloop_AS_Q(ntryL,G2H1(6),ex3(:),G2H1(25),ngH,m3h1x1(:,141),heltab2x1(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(25),31,nMT,G3tensor(86),n2h1(312))
  call Hloop_QS_A(ntryL,G2H1(50),ex3(:),G2H1(39),ngH,m3h1x1(:,142),heltab2x1(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(39),31,nMB,G3tensor(87),n2h1(313))
  call Hloop_AS_Q(ntryL,G2H1(26),ex3(:),G2H1(49),ngH,m3h1x1(:,143),heltab2x1(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(49),31,nMB,G3tensor(88),n2h1(314))
  call Hloop_AZ_Q(ntryL,G2H3(147),ex4(:),G2H1(16),ngZl,m3h3x1(:,401),heltab2x3(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),31,nML,G3tensor(89),n2h1(315))
  call Hloop_QZ_A(ntryL,G2H3(144),ex4(:),G2H1(42),ngZl,m3h3x1(:,402),heltab2x3(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(42),31,nML,G3tensor(90),n2h1(316))
  call Hloop_AZ_Q(ntryL,G2H3(141),ex4(:),G2H1(18),ngZu,m3h3x1(:,403),heltab2x3(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nMT,G3tensor(91),n2h1(317))
  call Hloop_QZ_A(ntryL,G2H3(23),ex4(:),G2H1(20),ngZu,m3h3x1(:,404),heltab2x3(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),31,nMT,G3tensor(92),n2h1(318))
  call Hloop_AZ_Q(ntryL,G2H3(17),ex4(:),G2H1(45),ngZd,m3h3x1(:,405),heltab2x3(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(45),31,nMB,G3tensor(93),n2h1(319))
  call Hloop_QZ_A(ntryL,G2H3(70),ex4(:),G2H1(22),ngZd,m3h3x1(:,406),heltab2x3(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(22),31,nMB,G3tensor(94),n2h1(320))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(42),m3h2x1(:,56),heltab2x2(:,:,58))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(14),ex4(:),G2tensor(79),m3h3x1(:,407),heltab2x3(:,:,509))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(207),m3h1x1(:,144),heltab2x1(:,:,144))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(21),ex3(:),G2tensor(201),m3h1x1(:,145),heltab2x1(:,:,145))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(28),ex3(:),G2tensor(198),m3h1x1(:,146),heltab2x1(:,:,146))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(29),ex3(:),G2tensor(186),m3h1x1(:,147),heltab2x1(:,:,147))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(56),ex4(:),G2tensor(183),m3h3x1(:,408),heltab2x3(:,:,510))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(43),ex4(:),G2tensor(124),m3h3x1(:,409),heltab2x3(:,:,511))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(93),ex4(:),G2tensor(123),m3h3x1(:,410),heltab2x3(:,:,512))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(11),m3h2x1(:,57),heltab2x2(:,:,59))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(27),ex4(:),wf4(:,1),G1tensor(63),m4h3x4x1(:,1),heltab3x12(:,:,13))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(29),ex4(:),wf4(:,2),G1tensor(93),m4h3x4x1(:,2),heltab3x12(:,:,14))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(28),ex4(:),wf4(:,1),G1tensor(56),m4h3x4x1(:,3),heltab3x12(:,:,15))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(36),ex4(:),wf4(:,2),G1tensor(27),m4h3x4x1(:,4),heltab3x12(:,:,16))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(41),ex3(:),G1tensor(38),m3h1x1(:,148),heltab2x1(:,:,148))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(21),ex3(:),G1tensor(39),m3h1x1(:,149),heltab2x1(:,:,149))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(118),ex4(:),ex3(:),G1tensor(58),m4h3x1x1(:,5),heltab3x3(:,:,5))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H3(137),ex3(:),ex4(:),G1tensor(7),m4h1x3x1(:,1),heltab3x3(:,:,6))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(8),ex2(:),G1tensor(47),m3h2x1(:,58),heltab2x2(:,:,60))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(1),ex2(:),G1tensor(86),ngZu,m3h2x1(:,59),heltab2x2(:,:,61))
  call Hloop_AS_Q(ntryL,G2H3(104),wf3(:,10),G2H1(51),ngX,m3h3x1(:,411),heltab2x3(:,:,513))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(51),31,nML,G3tensor(95),n2h1(321))
  call Hloop_QS_A(ntryL,G2H3(105),wf3(:,10),G2H1(54),ngX,m3h3x1(:,412),heltab2x3(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(54),31,nML,G3tensor(96),n2h1(322))
  call Hloop_AS_Q(ntryL,G2H3(107),wf3(:,10),G2H1(57),ngX,m3h3x1(:,413),heltab2x3(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(57),31,nMT,G3tensor(97),n2h1(323))
  call Hloop_QS_A(ntryL,G2H3(108),wf3(:,10),G2H1(59),ngX,m3h3x1(:,414),heltab2x3(:,:,516))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(59),31,nMT,G3tensor(98),n2h1(324))
  call Hloop_AS_Q(ntryL,G2H3(110),wf3(:,10),G2H1(12),ngX,m3h3x1(:,415),heltab2x3(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),31,nMB,G3tensor(99),n2h1(325))
  call Hloop_QS_A(ntryL,G2H3(137),wf3(:,10),G2H1(15),ngX,m3h3x1(:,416),heltab2x3(:,:,518))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),31,nMB,G3tensor(100),n2h1(326))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(149),wf3(:,10),G2tensor(45),m3h3x1(:,417),heltab2x3(:,:,519))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H3(146),wf3(:,10),G2tensor(192),m3h3x1(:,418),heltab2x3(:,:,520))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H3(182),19,wf3(:,10),12,G2tensor(149),m3h3x1(:,419),heltab2x3(:,:,521))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H3(177),19,wf3(:,10),12,G2tensor(147),m3h3x1(:,420),heltab2x3(:,:,522))
  call Hloop_AZ_Q(ntryL,G2H3(68),wf3(:,2),G2H1(60),ngZl,m3h3x1(:,421),heltab2x3(:,:,523))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(60),31,0,G3tensor(101),n2h1(327))
  call Hloop_AZ_Q(ntryL,G2H3(67),wf3(:,2),G2H1(53),ngZl,m3h3x1(:,422),heltab2x3(:,:,524))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(53),31,nML,G3tensor(102),n2h1(328))
  call Hloop_QZ_A(ntryL,G2H3(27),wf3(:,2),G2H1(52),ngZl,m3h3x1(:,423),heltab2x3(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(52),31,0,G3tensor(103),n2h1(329))
  call Hloop_QZ_A(ntryL,G2H3(25),wf3(:,2),G2H1(61),ngZl,m3h3x1(:,424),heltab2x3(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(61),31,nML,G3tensor(104),n2h1(330))
  call Hloop_AZ_Q(ntryL,G2H3(10),wf3(:,2),G2H1(7),ngZu,m3h3x1(:,425),heltab2x3(:,:,527))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMT,G3tensor(105),n2h1(331))
  call Hloop_QZ_A(ntryL,G2H3(1),wf3(:,2),G2H1(24),ngZu,m3h3x1(:,426),heltab2x3(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(24),31,nMT,G3tensor(106),n2h1(332))
  call Hloop_AZ_Q(ntryL,G2H3(15),wf3(:,2),G2H1(62),ngZd,m3h3x1(:,427),heltab2x3(:,:,529))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(62),31,nMB,G3tensor(107),n2h1(333))
  call Hloop_QZ_A(ntryL,G2H3(50),wf3(:,2),G2H1(48),ngZd,m3h3x1(:,428),heltab2x3(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(48),31,nMB,G3tensor(108),n2h1(334))
  call Hloop_AZ_Q(ntryL,G2H3(36),wf3(:,2),G2H1(14),ngZn,m3h3x1(:,429),heltab2x3(:,:,531))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),31,0,G3tensor(109),n2h1(335))
  call Hloop_QZ_A(ntryL,G2H3(69),wf3(:,2),G2H1(63),ngZn,m3h3x1(:,430),heltab2x3(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(63),31,0,G3tensor(110),n2h1(336))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(63),19,wf3(:,2),12,G3tensor(111),m3h3x1(:,431),heltab2x3(:,:,533))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(44),19,wf3(:,2),12,G3tensor(112),m3h3x1(:,432),heltab2x3(:,:,534))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(5),19,wf3(:,2),G3tensor(113),m3h3x1(:,433),heltab2x3(:,:,535))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(6),19,wf3(:,2),12,G3tensor(114),m3h3x1(:,434),heltab2x3(:,:,536))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(148),wf3(:,2),G1tensor(104),m3h3x1(:,435),heltab2x3(:,:,537))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(14),wf3(:,2),G1tensor(106),m3h3x1(:,436),heltab2x3(:,:,538))
  call Hloop_QZ_A(ntryL,G2H3(77),ex4(:),G2H1(17),ngZl,m3h3x1(:,437),heltab2x3(:,:,539))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,0,G3tensor(115),n2h1(337))
  call Hloop_AZ_Q(ntryL,G2H3(78),ex4(:),G2H1(31),ngZl,m3h3x1(:,438),heltab2x3(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(31),31,0,G3tensor(116),n2h1(338))
  call Hloop_QZ_A(ntryL,G2H3(74),ex4(:),G2H1(64),ngZn,m3h3x1(:,439),heltab2x3(:,:,541))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(64),31,0,G3tensor(117),n2h1(339))
  call Hloop_AZ_Q(ntryL,G2H3(75),ex4(:),G2H1(37),ngZn,m3h3x1(:,440),heltab2x3(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(37),31,0,G3tensor(118),n2h1(340))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(11),ex3(:),G1tensor(5),m3h1x1(:,150),heltab2x1(:,:,150))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(13),ex3(:),G1tensor(36),m3h1x1(:,151),heltab2x1(:,:,151))
  call Hloop_AZ_Q(ntryL,G2H3(140),ex4(:),G2H1(34),ngZn,m3h3x1(:,441),heltab2x3(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(34),31,0,G3tensor(119),n2h1(341))
  call Hloop_QZ_A(ntryL,G2H3(152),ex4(:),G2H1(46),ngZn,m3h3x1(:,442),heltab2x3(:,:,544))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(46),31,0,G3tensor(120),n2h1(342))
  call Hloop_AZ_Q(ntryL,G2H3(153),ex4(:),G2H1(40),ngZl,m3h3x1(:,443),heltab2x3(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(40),31,0,G3tensor(121),n2h1(343))
  call Hloop_QZ_A(ntryL,G2H3(155),ex4(:),G2H1(32),ngZl,m3h3x1(:,444),heltab2x3(:,:,546))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(32),31,0,G3tensor(122),n2h1(344))
  call Hloop_AZ_Q(ntryL,G2H3(157),ex4(:),G2H1(38),ngZu,m3h3x1(:,445),heltab2x3(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(38),31,0,G3tensor(123),n2h1(345))
  call Hloop_QZ_A(ntryL,G2H3(159),ex4(:),G2H1(35),ngZu,m3h3x1(:,446),heltab2x3(:,:,548))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(35),31,0,G3tensor(124),n2h1(346))
  call Hloop_AZ_Q(ntryL,G2H3(161),ex4(:),G2H1(41),ngZd,m3h3x1(:,447),heltab2x3(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(41),31,0,G3tensor(125),n2h1(347))
  call Hloop_QZ_A(ntryL,G2H3(163),ex4(:),G2H1(8),ngZd,m3h3x1(:,448),heltab2x3(:,:,550))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),31,0,G3tensor(126),n2h1(348))
  call Hloop_QS_A(ntryL,G2H12(21),wf12(:,25),G2H1(11),ngH,m3h12x1(:,1),heltab2x12(:,:,783))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),31,nML,G3tensor(127),n2h1(349))
  call Hloop_AS_Q(ntryL,G2H12(22),wf12(:,25),G2H1(44),ngH,m3h12x1(:,2),heltab2x12(:,:,784))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(44),31,nML,G3tensor(128),n2h1(350))
  call Hloop_QS_A(ntryL,G2H12(23),wf12(:,25),G2H1(9),ngH,m3h12x1(:,3),heltab2x12(:,:,785))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMT,G3tensor(129),n2h1(351))
  call Hloop_AS_Q(ntryL,G2H12(24),wf12(:,25),G2H1(43),ngH,m3h12x1(:,4),heltab2x12(:,:,786))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(43),31,nMT,G3tensor(130),n2h1(352))
  call Hloop_QS_A(ntryL,G2H12(13),wf12(:,25),G2H1(1),ngH,m3h12x1(:,5),heltab2x12(:,:,787))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(131),n2h1(353))
  call Hloop_AS_Q(ntryL,G2H12(14),wf12(:,25),G2H1(19),ngH,m3h12x1(:,6),heltab2x12(:,:,788))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(19),31,nMB,G3tensor(132),n2h1(354))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(38),wf12(:,25),G1tensor(25),m3h12x1(:,7),heltab2x12(:,:,789))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(58),wf12(:,25),G1tensor(37),m3h12x1(:,8),heltab2x12(:,:,790))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(37),wf12(:,25),G1tensor(43),m3h12x1(:,9),heltab2x12(:,:,791))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(68),wf12(:,25),G1tensor(53),m3h12x1(:,10),heltab2x12(:,:,792))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H12(16),20,wf12(:,25),11,G3tensor(133),m3h12x1(:,11),heltab2x12(:,:,793))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H12(15),20,wf12(:,25),11,G3tensor(134),m3h12x1(:,12),heltab2x12(:,:,794))
  call Hloop_ZQ_A(ntryL,G0H6(21),wf6(:,2),G0H1(2),ngZu,m3h6x1(:,11),heltab2x6(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(2),31,0,G1tensor(71),n2h1(355))
  call Hloop_WQ_A(ntryL,G0H6(3),wf6(:,2),G0H1(1),m3h6x1(:,12),heltab2x6(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(83),n2h1(356))
  call Hloop_VQ_A(ntryL,G1H6(9),wf6(:,2),G1H1(52),m3h6x1(:,13),heltab2x6(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(52),31,0,G2tensor(122),n2h1(357))
  call Hloop_ZQ_A(ntryL,G1H6(7),wf6(:,2),G1H1(22),ngZu,m3h6x1(:,14),heltab2x6(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,0,G2tensor(121),n2h1(358))
  call Hloop_WQ_A(ntryL,G1H6(26),wf6(:,2),G1H1(15),m3h6x1(:,15),heltab2x6(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),31,0,G2tensor(48),n2h1(359))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(19),wf6(:,2),G2tensor(36),m3h6x1(:,16),heltab2x6(:,:,169))
  call Hloop_QV_A(ntryL,G2H12(25),wf12(:,5),G2H1(55),m3h12x1(:,13),heltab2x12(:,:,795))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(55),31,nML,G3tensor(135),n2h1(360))
  call Hloop_AV_Q(ntryL,G2H12(26),wf12(:,5),G2H1(27),m3h12x1(:,14),heltab2x12(:,:,796))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(27),31,nML,G3tensor(136),n2h1(361))
  call Hloop_QV_A(ntryL,G2H12(27),wf12(:,5),G2H1(56),m3h12x1(:,15),heltab2x12(:,:,797))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(56),31,nMT,G3tensor(137),n2h1(362))
  call Hloop_AV_Q(ntryL,G2H12(28),wf12(:,5),G2H1(30),m3h12x1(:,16),heltab2x12(:,:,798))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(30),31,nMT,G3tensor(138),n2h1(363))
  call Hloop_QV_A(ntryL,G2H12(17),wf12(:,5),G2H1(58),m3h12x1(:,17),heltab2x12(:,:,799))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(58),31,nMB,G3tensor(139),n2h1(364))
  call Hloop_AV_Q(ntryL,G2H12(18),wf12(:,5),G2H1(13),m3h12x1(:,18),heltab2x12(:,:,800))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nMB,G3tensor(140),n2h1(365))
  call Hloop_QZ_A(ntryL,G2H12(19),wf12(:,1),G2H1(33),ngZl,m3h12x1(:,19),heltab2x12(:,:,801))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(33),31,nML,G3tensor(141),n2h1(366))
  call Hloop_AZ_Q(ntryL,G2H12(20),wf12(:,1),G2H1(10),ngZl,m3h12x1(:,20),heltab2x12(:,:,802))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nML,G3tensor(142),n2h1(367))
  call Hloop_QZ_A(ntryL,G2H12(1),wf12(:,1),G2H1(3),ngZu,m3h12x1(:,21),heltab2x12(:,:,803))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(143),n2h1(368))
  call Hloop_AZ_Q(ntryL,G2H12(2),wf12(:,1),G2H1(47),ngZu,m3h12x1(:,22),heltab2x12(:,:,804))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(47),31,nMT,G3tensor(144),n2h1(369))
  call Hloop_QZ_A(ntryL,G2H12(3),wf12(:,1),G2H1(4),ngZd,m3h12x1(:,23),heltab2x12(:,:,805))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),31,nMB,G3tensor(145),n2h1(370))
  call Hloop_AZ_Q(ntryL,G2H12(4),wf12(:,1),G2H1(36),ngZd,m3h12x1(:,24),heltab2x12(:,:,806))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(36),31,nMB,G3tensor(146),n2h1(371))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(165),20,wf12(:,5),11,G2tensor(75),m3h12x1(:,25),heltab2x12(:,:,807))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(166),20,wf12(:,5),11,G2tensor(33),m3h12x1(:,26),heltab2x12(:,:,808))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(121),20,wf12(:,1),11,G2tensor(63),m3h12x1(:,27),heltab2x12(:,:,809))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(172),20,wf12(:,1),11,G2tensor(17),m3h12x1(:,28),heltab2x12(:,:,810))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(171),20,wf12(:,1),11,G2tensor(69),m3h12x1(:,29),heltab2x12(:,:,811))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(177),20,wf12(:,1),11,G2tensor(60),m3h12x1(:,30),heltab2x12(:,:,812))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(133),20,wf12(:,5),11,G2tensor(66),m3h12x1(:,31),heltab2x12(:,:,813))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(135),20,wf12(:,5),G2tensor(15),m3h12x1(:,32),heltab2x12(:,:,814))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(138),20,wf12(:,1),11,G2tensor(51),m3h12x1(:,33),heltab2x12(:,:,815))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(141),20,wf12(:,1),G2tensor(219),m3h12x1(:,34),heltab2x12(:,:,816))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(176),20,wf12(:,5),11,G2tensor(216),m3h12x1(:,35),heltab2x12(:,:,817))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(93),20,wf12(:,5),11,G2tensor(213),m3h12x1(:,36),heltab2x12(:,:,818))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(95),20,wf12(:,1),11,G2tensor(189),m3h12x1(:,37),heltab2x12(:,:,819))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(181),20,wf12(:,1),11,G2tensor(180),m3h12x1(:,38),heltab2x12(:,:,820))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(8),wf12(:,5),G2tensor(125),m3h12x1(:,39),heltab2x12(:,:,821))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(104),wf12(:,1),G0tensor(10),m3h12x1(:,40),heltab2x12(:,:,822))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(9),wf12(:,1),G2tensor(13),m3h12x1(:,41),heltab2x12(:,:,823))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(5),wf12(:,5),G2tensor(39),m3h12x1(:,42),heltab2x12(:,:,824))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(6),wf12(:,1),G2tensor(86),m3h12x1(:,43),heltab2x12(:,:,825))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(7),wf12(:,1),G2tensor(87),m3h12x1(:,44),heltab2x12(:,:,826))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(16),ex3(:),G1tensor(91),m3h1x1(:,152),heltab2x1(:,:,152))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(35),ex3(:),G1tensor(102),m3h1x1(:,153),heltab2x1(:,:,153))
  call Hloop_ZA_Q(ntryL,G0H6(9),wf6(:,4),G0H1(4),ngZu,m3h6x1(:,17),heltab2x6(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(4),31,0,G1tensor(111),n2h1(372))
  call Hloop_WA_Q(ntryL,G0H6(13),wf6(:,4),G0H1(3),m3h6x1(:,18),heltab2x6(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(3),31,0,G1tensor(116),n2h1(373))
  call Hloop_VA_Q(ntryL,G1H6(28),wf6(:,4),G1H1(18),m3h6x1(:,19),heltab2x6(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,0,G2tensor(96),n2h1(374))
  call Hloop_ZA_Q(ntryL,G1H6(29),wf6(:,4),G1H1(2),ngZu,m3h6x1(:,20),heltab2x6(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,0,G2tensor(97),n2h1(375))
  call Hloop_WA_Q(ntryL,G1H6(30),wf6(:,4),G1H1(42),m3h6x1(:,21),heltab2x6(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),31,0,G2tensor(140),n2h1(376))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(4),wf6(:,4),G2tensor(142),m3h6x1(:,22),heltab2x6(:,:,175))
  call Hloop_QV_A(ntryL,G2H12(10),wf12(:,6),G2H1(5),m3h12x1(:,45),heltab2x12(:,:,827))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(5),31,nML,G3tensor(147),n2h1(377))
  call Hloop_AV_Q(ntryL,G2H12(11),wf12(:,6),G2H1(23),m3h12x1(:,46),heltab2x12(:,:,828))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(23),31,nML,G3tensor(148),n2h1(378))
  call Hloop_QV_A(ntryL,G2H12(12),wf12(:,6),G2H1(6),m3h12x1(:,47),heltab2x12(:,:,829))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(6),31,nMT,G3tensor(149),n2h1(379))
  call Hloop_AV_Q(ntryL,G2H12(29),wf12(:,6),G2H1(25),m3h12x1(:,48),heltab2x12(:,:,830))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(25),31,nMT,G3tensor(150),n2h1(380))
  call Hloop_QV_A(ntryL,G2H12(30),wf12(:,6),G2H1(50),m3h12x1(:,49),heltab2x12(:,:,831))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(50),31,nMB,G3tensor(151),n2h1(381))
  call Hloop_AV_Q(ntryL,G2H12(31),wf12(:,6),G2H1(39),m3h12x1(:,50),heltab2x12(:,:,832))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(39),31,nMB,G3tensor(152),n2h1(382))
  call Hloop_QZ_A(ntryL,G2H12(32),wf12(:,2),G2H1(26),ngZl,m3h12x1(:,51),heltab2x12(:,:,833))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(26),31,nML,G3tensor(153),n2h1(383))
  call Hloop_AZ_Q(ntryL,G2H12(33),wf12(:,2),G2H1(49),ngZl,m3h12x1(:,52),heltab2x12(:,:,834))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(49),31,nML,G3tensor(154),n2h1(384))
  call Hloop_QZ_A(ntryL,G2H12(34),wf12(:,2),G2H1(16),ngZu,m3h12x1(:,53),heltab2x12(:,:,835))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nMT,G3tensor(155),n2h1(385))
  call Hloop_AZ_Q(ntryL,G2H12(35),wf12(:,2),G2H1(42),ngZu,m3h12x1(:,54),heltab2x12(:,:,836))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(42),31,nMT,G3tensor(156),n2h1(386))
  call Hloop_QZ_A(ntryL,G2H12(36),wf12(:,2),G2H1(18),ngZd,m3h12x1(:,55),heltab2x12(:,:,837))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(18),31,nMB,G3tensor(157),n2h1(387))
  call Hloop_AZ_Q(ntryL,G2H12(37),wf12(:,2),G2H1(20),ngZd,m3h12x1(:,56),heltab2x12(:,:,838))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),31,nMB,G3tensor(158),n2h1(388))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(257),20,wf12(:,6),11,G2tensor(144),m3h12x1(:,57),heltab2x12(:,:,839))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(259),20,wf12(:,6),11,G2tensor(151),m3h12x1(:,58),heltab2x12(:,:,840))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(208),20,wf12(:,2),11,G2tensor(153),m3h12x1(:,59),heltab2x12(:,:,841))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(282),20,wf12(:,2),11,G2tensor(155),m3h12x1(:,60),heltab2x12(:,:,842))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(283),20,wf12(:,2),11,G2tensor(158),m3h12x1(:,61),heltab2x12(:,:,843))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H12(286),20,wf12(:,2),11,G2tensor(160),m3h12x1(:,62),heltab2x12(:,:,844))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(232),20,wf12(:,6),11,G2tensor(162),m3h12x1(:,63),heltab2x12(:,:,845))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(237),20,wf12(:,6),G2tensor(276),m3h12x1(:,64),heltab2x12(:,:,846))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(239),20,wf12(:,2),11,G2tensor(282),m3h12x1(:,65),heltab2x12(:,:,847))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H12(247),20,wf12(:,2),G2tensor(288),m3h12x1(:,66),heltab2x12(:,:,848))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(287),20,wf12(:,6),11,G2tensor(294),m3h12x1(:,67),heltab2x12(:,:,849))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(294),20,wf12(:,6),11,G2tensor(300),m3h12x1(:,68),heltab2x12(:,:,850))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(297),20,wf12(:,2),11,G2tensor(306),m3h12x1(:,69),heltab2x12(:,:,851))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H12(299),20,wf12(:,2),11,G2tensor(312),m3h12x1(:,70),heltab2x12(:,:,852))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(41),wf12(:,6),G2tensor(318),m3h12x1(:,71),heltab2x12(:,:,853))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H12(107),wf12(:,2),G0tensor(15),m3h12x1(:,72),heltab2x12(:,:,854))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H12(42),wf12(:,2),G2tensor(324),m3h12x1(:,73),heltab2x12(:,:,855))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(38),wf12(:,6),G2tensor(2),m3h12x1(:,74),heltab2x12(:,:,856))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(39),wf12(:,2),G2tensor(131),m3h12x1(:,75),heltab2x12(:,:,857))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H12(40),wf12(:,2),G2tensor(6),m3h12x1(:,76),heltab2x12(:,:,858))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(60),ex3(:),G1tensor(121),m3h1x1(:,154),heltab2x1(:,:,154))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(23),ex3(:),G1tensor(126),m3h1x1(:,155),heltab2x1(:,:,155))
  call Hloop_VQ_A(ntryL,G1H6(32),wf6(:,39),G1H1(46),m3h6x1(:,23),heltab2x6(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(46),31,0,G2tensor(128),n2h1(389))
  call Hloop_ZQ_A(ntryL,G1H6(33),wf6(:,39),G1H1(50),ngZu,m3h6x1(:,24),heltab2x6(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,0,G2tensor(65),n2h1(390))
  call Hloop_WQ_A(ntryL,G1H6(34),wf6(:,39),G1H1(54),m3h6x1(:,25),heltab2x6(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),31,0,G2tensor(77),n2h1(391))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(8),wf6(:,39),G2tensor(246),m3h6x1(:,26),heltab2x6(:,:,179))
  call Hloop_VA_Q(ntryL,G1H6(36),wf6(:,35),G1H1(58),m3h6x1(:,27),heltab2x6(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(58),31,0,G2tensor(234),n2h1(392))
  call Hloop_ZA_Q(ntryL,G1H6(19),wf6(:,35),G1H1(62),ngZu,m3h6x1(:,28),heltab2x6(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(62),31,0,G2tensor(102),n2h1(393))
  call Hloop_WA_Q(ntryL,G1H6(20),wf6(:,35),G1H1(33),m3h6x1(:,29),heltab2x6(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(33),31,0,G2tensor(270),n2h1(394))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(13),wf6(:,35),G2tensor(134),m3h6x1(:,30),heltab2x6(:,:,183))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(124),23,ex4(:),8,G2tensor(168),m3h3x1(:,449),heltab2x3(:,:,551))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(55),23,ex4(:),8,G2tensor(106),m3h3x1(:,450),heltab2x3(:,:,552))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(17),ex4(:),G0tensor(20),m3h3x1(:,451),heltab2x3(:,:,553))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(175),ex4(:),G2tensor(171),m3h3x1(:,452),heltab2x3(:,:,554))
  call ol_merge_tensors(G2tensor(142),[G2tensor(179),G2tensor(137),G1tensor(217),G1tensor(145),G1tensor(66),G1tensor(105) &
    ,G0tensor(226),G0tensor(154),G0tensor(99),G0tensor(17)])
  call ol_merge_tensors(G3tensor(114),[G3tensor(113),G3tensor(112),G3tensor(111),G3tensor(78),G3tensor(75),G2tensor(147) &
    ,G2tensor(149),G2tensor(192),G2tensor(45),G2tensor(212),G2tensor(209),G2tensor(203),G2tensor(200),G2tensor(197),G2tensor(194) &
    ,G2tensor(188),G2tensor(185),G2tensor(157),G2tensor(150),G2tensor(148),G2tensor(146),G2tensor(139),G2tensor(138),G1tensor(106) &
    ,G1tensor(104),G1tensor(7),G1tensor(58),G1tensor(185),G1tensor(175),G1tensor(9),G1tensor(57),G0tensor(194),G0tensor(184) &
    ,G0tensor(48),G0tensor(43)])
  call ol_merge_tensors(G3tensor(104),[G3tensor(102),G3tensor(96),G3tensor(95),G3tensor(8),G3tensor(7),G3tensor(2),G3tensor(1) &
    ,G2tensor(299),G2tensor(296),G2tensor(281),G2tensor(278),G1tensor(501),G1tensor(486),G0tensor(474),G0tensor(459)])
  call ol_merge_tensors(G3tensor(106),[G3tensor(105),G3tensor(98),G3tensor(97),G3tensor(10),G3tensor(9),G3tensor(4),G3tensor(3) &
    ,G2tensor(305),G2tensor(302),G2tensor(287),G2tensor(284),G1tensor(506),G1tensor(491),G0tensor(479),G0tensor(464)])
  call ol_merge_tensors(G3tensor(108),[G3tensor(107),G3tensor(100),G3tensor(99),G3tensor(12),G3tensor(11),G3tensor(6),G3tensor(5) &
    ,G2tensor(311),G2tensor(308),G2tensor(293),G2tensor(290),G1tensor(511),G1tensor(496),G0tensor(484),G0tensor(469)])
  call ol_merge_tensors(G3tensor(154),[G3tensor(153),G3tensor(148),G3tensor(147),G3tensor(142),G3tensor(141),G3tensor(136) &
    ,G3tensor(135),G3tensor(128),G3tensor(127),G3tensor(14),G3tensor(13),G2tensor(317),G2tensor(314),G1tensor(516) &
    ,G0tensor(489)])
  call ol_merge_tensors(G3tensor(156),[G3tensor(155),G3tensor(150),G3tensor(149),G3tensor(144),G3tensor(143),G3tensor(138) &
    ,G3tensor(137),G3tensor(130),G3tensor(129),G3tensor(16),G3tensor(15),G2tensor(323),G2tensor(320),G1tensor(521) &
    ,G0tensor(494)])
  call ol_merge_tensors(G3tensor(158),[G3tensor(157),G3tensor(152),G3tensor(151),G3tensor(146),G3tensor(145),G3tensor(140) &
    ,G3tensor(139),G3tensor(132),G3tensor(131),G3tensor(18),G3tensor(17),G2tensor(329),G2tensor(326),G1tensor(526) &
    ,G0tensor(499)])
  call ol_merge_tensors(G3tensor(134),[G3tensor(133),G2tensor(6),G2tensor(2),G2tensor(324),G2tensor(318),G2tensor(312) &
    ,G2tensor(306),G2tensor(300),G2tensor(294),G2tensor(288),G2tensor(282),G2tensor(276),G2tensor(162),G2tensor(160),G2tensor(158) &
    ,G2tensor(151),G2tensor(144),G2tensor(87),G2tensor(39),G2tensor(13),G2tensor(125),G2tensor(180),G2tensor(189),G2tensor(213) &
    ,G2tensor(216),G2tensor(219),G2tensor(51),G2tensor(15),G2tensor(66),G2tensor(60),G2tensor(69),G2tensor(33),G2tensor(75) &
    ,G2tensor(224),G2tensor(221),G2tensor(218),G2tensor(215),G2tensor(191),G2tensor(182),G2tensor(165),G2tensor(164),G1tensor(53) &
    ,G1tensor(43),G1tensor(37),G1tensor(25),G1tensor(27),G1tensor(56),G1tensor(93),G1tensor(63),G1tensor(250),G1tensor(15) &
    ,G1tensor(50),G0tensor(259),G0tensor(29),G0tensor(19)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(236),G2tensor(167),G1tensor(416),G1tensor(220),G1tensor(210),G1tensor(28) &
    ,G1tensor(10),G0tensor(389),G0tensor(229),G0tensor(219),G0tensor(49),G0tensor(39)])
  call ol_merge_tensors(G2tensor(247),[G2tensor(172),G2tensor(169),G1tensor(18),G1tensor(30),G1tensor(17),G1tensor(59) &
    ,G0tensor(76),G0tensor(72),G0tensor(66),G0tensor(41)])
  call ol_merge_tensors(G2tensor(170),[G1tensor(177),G1tensor(24),G0tensor(186),G0tensor(69)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(173),G1tensor(187),G1tensor(115),G1tensor(23),G1tensor(14),G0tensor(196) &
    ,G0tensor(124),G0tensor(79),G0tensor(27)])
  call ol_merge_tensors(G2tensor(235),[G2tensor(178),G2tensor(175),G1tensor(47),G1tensor(54),G1tensor(48),G1tensor(76),G1tensor(3) &
    ,G0tensor(96),G0tensor(91),G0tensor(52),G0tensor(46)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(207),G1tensor(52),G0tensor(216),G0tensor(94)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(56),G2tensor(133),G2tensor(14),G2tensor(16),G2tensor(29),G2tensor(32),G2tensor(38) &
    ,G2tensor(223),G2tensor(220),G2tensor(217),G2tensor(214),G2tensor(190),G2tensor(181),G1tensor(247),G1tensor(13),G1tensor(82) &
    ,G0tensor(256),G0tensor(74),G0tensor(54)])
  call ol_merge_tensors(G3tensor(50),[G3tensor(19),G2tensor(211),G2tensor(208),G2tensor(202),G2tensor(199),G2tensor(187) &
    ,G2tensor(184),G1tensor(36),G1tensor(5),G1tensor(39),G1tensor(38),G1tensor(172),G1tensor(49),G1tensor(4),G0tensor(181) &
    ,G0tensor(93),G0tensor(68)])
  call ol_merge_tensors(G3tensor(37),[G3tensor(36),G3tensor(35),G3tensor(34),G3tensor(21),G3tensor(20),G2tensor(123),G2tensor(124) &
    ,G2tensor(196),G2tensor(193),G1tensor(248),G1tensor(182),G1tensor(65),G1tensor(19),G0tensor(257),G0tensor(191),G0tensor(98) &
    ,G0tensor(78)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(205),G1tensor(362),G1tensor(150),G1tensor(140),G1tensor(16),G0tensor(371) &
    ,G0tensor(159),G0tensor(149),G0tensor(42)])
  call ol_merge_tensors(G2tensor(270),[G2tensor(233),G2tensor(206),G1tensor(431),G1tensor(365),G1tensor(350),G1tensor(155) &
    ,G1tensor(135),G0tensor(404),G0tensor(374),G0tensor(359),G0tensor(164),G0tensor(144)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(226),G1tensor(463),G1tensor(418),G0tensor(436),G0tensor(391)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(227),G1tensor(421),G0tensor(394)])
  call ol_merge_tensors(G2tensor(262),[G2tensor(229),G1tensor(468),G1tensor(423),G0tensor(441),G0tensor(396)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(230),G1tensor(426),G1tensor(335),G1tensor(125),G0tensor(399),G0tensor(344) &
    ,G0tensor(134)])
  call ol_merge_tensors(G2tensor(265),[G2tensor(232),G1tensor(473),G1tensor(428),G0tensor(446),G0tensor(401)])
  call ol_merge_tensors(G2tensor(250),[G2tensor(238),G1tensor(448),G1tensor(433),G0tensor(421),G0tensor(406)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(239),G1tensor(436),G0tensor(409)])
  call ol_merge_tensors(G2tensor(253),[G2tensor(241),G1tensor(453),G1tensor(438),G0tensor(426),G0tensor(411)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(242),G1tensor(441),G1tensor(305),G1tensor(90),G0tensor(414),G0tensor(314) &
    ,G0tensor(109)])
  call ol_merge_tensors(G2tensor(256),[G2tensor(244),G1tensor(458),G1tensor(443),G0tensor(431),G0tensor(416)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(245),G1tensor(446),G1tensor(320),G1tensor(108),G0tensor(419),G0tensor(329) &
    ,G0tensor(119)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(248),G1tensor(190),G1tensor(180),G1tensor(22),G1tensor(2),G0tensor(199) &
    ,G0tensor(189),G0tensor(44),G0tensor(34)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(251),G1tensor(451),G0tensor(424)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(254),G1tensor(456),G0tensor(429)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(257),G1tensor(461),G0tensor(434)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(260),G1tensor(466),G0tensor(439)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(263),G1tensor(471),G0tensor(444)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(269),G2tensor(266),G1tensor(481),G1tensor(476),G0tensor(454),G0tensor(449)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(268),G1tensor(478),G1tensor(268),G1tensor(152),G1tensor(147),G1tensor(67) &
    ,G0tensor(451),G0tensor(277),G0tensor(161),G0tensor(156),G0tensor(77)])
  call ol_merge_tensors(G2tensor(271),[G1tensor(257),G1tensor(253),G1tensor(98),G1tensor(64),G0tensor(266),G0tensor(262) &
    ,G0tensor(61),G0tensor(56)])
  call ol_merge_tensors(G2tensor(272),[G1tensor(167),G1tensor(94),G0tensor(176),G0tensor(59)])
  call ol_merge_tensors(G2tensor(274),[G1tensor(86),G1tensor(227),G1tensor(223),G1tensor(40),G1tensor(29),G0tensor(236) &
    ,G0tensor(232),G0tensor(86),G0tensor(81)])
  call ol_merge_tensors(G2tensor(275),[G1tensor(197),G1tensor(73),G0tensor(206),G0tensor(84)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(22),G2tensor(280),G2tensor(277),G1tensor(514),G1tensor(483),G0tensor(487) &
    ,G0tensor(456)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G2tensor(286),G2tensor(283),G1tensor(519),G1tensor(488),G0tensor(492) &
    ,G0tensor(461)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(30),G2tensor(292),G2tensor(289),G1tensor(524),G1tensor(493),G0tensor(497) &
    ,G0tensor(466)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(38),G2tensor(298),G2tensor(295),G1tensor(498),G0tensor(471)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G2tensor(304),G2tensor(301),G1tensor(503),G0tensor(476)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(46),G2tensor(310),G2tensor(307),G1tensor(508),G0tensor(481)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G3tensor(52),G3tensor(51),G2tensor(316),G2tensor(313),G1tensor(513) &
    ,G0tensor(486)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(59),G3tensor(54),G3tensor(53),G2tensor(322),G2tensor(319),G1tensor(518) &
    ,G0tensor(491)])
  call ol_merge_tensors(G3tensor(62),[G3tensor(61),G3tensor(56),G3tensor(55),G2tensor(328),G2tensor(325),G1tensor(523) &
    ,G0tensor(496)])
  call ol_merge_tensors(G1tensor(292),[G1tensor(222),G1tensor(77),G1tensor(69),G0tensor(301),G0tensor(231),G0tensor(102) &
    ,G0tensor(11)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(75),G0tensor(239),G0tensor(12)])
  call ol_merge_tensors(G1tensor(235),[G1tensor(81),G0tensor(244),G0tensor(13)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(155),G2tensor(86),G2tensor(17),G1tensor(240),G1tensor(45),G1tensor(87) &
    ,G0tensor(249),G0tensor(24),G0tensor(14)])
  call ol_merge_tensors(G1tensor(307),[G1tensor(96),G1tensor(34),G1tensor(99),G0tensor(316),G0tensor(112),G0tensor(51) &
    ,G0tensor(16)])
  call ol_merge_tensors(G1tensor(245),[G1tensor(44),G0tensor(254),G0tensor(18)])
  call ol_merge_tensors(G1tensor(322),[G1tensor(252),G1tensor(118),G1tensor(62),G0tensor(331),G0tensor(261),G0tensor(127) &
    ,G0tensor(21)])
  call ol_merge_tensors(G1tensor(260),[G1tensor(68),G0tensor(269),G0tensor(22)])
  call ol_merge_tensors(G1tensor(265),[G1tensor(74),G0tensor(274),G0tensor(23)])
  call ol_merge_tensors(G1tensor(373),[G1tensor(368),G1tensor(337),G1tensor(128),G1tensor(6),G1tensor(20),G0tensor(382) &
    ,G0tensor(377),G0tensor(346),G0tensor(137),G0tensor(71),G0tensor(26)])
  call ol_merge_tensors(G1tensor(270),[G1tensor(33),G0tensor(279),G0tensor(28)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(474),G1tensor(343),G1tensor(338),G1tensor(112),G1tensor(32),G0tensor(447) &
    ,G0tensor(352),G0tensor(347),G0tensor(121),G0tensor(31)])
  call ol_merge_tensors(G1tensor(275),[G1tensor(46),G0tensor(284),G0tensor(32)])
  call ol_merge_tensors(G1tensor(280),[G1tensor(51),G0tensor(289),G0tensor(33)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(459),G1tensor(313),G1tensor(308),G1tensor(142),G1tensor(21),G0tensor(432) &
    ,G0tensor(322),G0tensor(317),G0tensor(151),G0tensor(36)])
  call ol_merge_tensors(G1tensor(285),[G1tensor(8),G0tensor(294),G0tensor(37)])
  call ol_merge_tensors(G1tensor(290),[G1tensor(1),G0tensor(299),G0tensor(38)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(215),G1tensor(205),G1tensor(26),G0tensor(224),G0tensor(214),G0tensor(47)])
  call ol_merge_tensors(G1tensor(242),[G1tensor(80),G0tensor(251),G0tensor(53)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(121),G1tensor(157),G1tensor(122),G1tensor(117),G1tensor(88),G0tensor(166) &
    ,G0tensor(131),G0tensor(126),G0tensor(57)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(162),G1tensor(35),G1tensor(92),G0tensor(171),G0tensor(83),G0tensor(58)])
  call ol_merge_tensors(G1tensor(160),[G1tensor(100),G0tensor(169),G0tensor(62)])
  call ol_merge_tensors(G1tensor(165),[G1tensor(42),G1tensor(11),G0tensor(174),G0tensor(88),G0tensor(63)])
  call ol_merge_tensors(G1tensor(170),[G1tensor(70),G0tensor(179),G0tensor(64)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(126),G1tensor(278),G1tensor(273),G1tensor(137),G1tensor(132),G1tensor(127) &
    ,G1tensor(110),G0tensor(287),G0tensor(282),G0tensor(146),G0tensor(141),G0tensor(136),G0tensor(67)])
  call ol_merge_tensors(G1tensor(267),[G1tensor(12),G0tensor(276),G0tensor(73)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(91),G1tensor(192),G1tensor(84),G1tensor(72),G1tensor(31),G0tensor(201) &
    ,G0tensor(106),G0tensor(101),G0tensor(82)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(41),G0tensor(204),G0tensor(87)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(55),G0tensor(209),G0tensor(89)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(102),G1tensor(288),G1tensor(283),G1tensor(202),G1tensor(109),G1tensor(95) &
    ,G1tensor(61),G0tensor(297),G0tensor(292),G0tensor(211),G0tensor(116),G0tensor(111),G0tensor(92)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(243),G1tensor(212),G1tensor(60),G0tensor(252),G0tensor(221),G0tensor(97)])
  call ol_merge_tensors(G1tensor(297),[G1tensor(78),G0tensor(306),G0tensor(103)])
  call ol_merge_tensors(G1tensor(302),[G1tensor(79),G0tensor(311),G0tensor(104)])
  call ol_merge_tensors(G1tensor(71),[G1tensor(295),G1tensor(85),G0tensor(304),G0tensor(107)])
  call ol_merge_tensors(G1tensor(300),[G1tensor(89),G0tensor(309),G0tensor(108)])
  call ol_merge_tensors(G1tensor(312),[G1tensor(97),G0tensor(321),G0tensor(113)])
  call ol_merge_tensors(G1tensor(317),[G1tensor(101),G0tensor(326),G0tensor(114)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(310),G1tensor(103),G0tensor(319),G0tensor(117)])
  call ol_merge_tensors(G1tensor(315),[G1tensor(107),G0tensor(324),G0tensor(118)])
  call ol_merge_tensors(G1tensor(272),[G1tensor(113),G0tensor(281),G0tensor(122)])
  call ol_merge_tensors(G1tensor(277),[G1tensor(114),G0tensor(286),G0tensor(123)])
  call ol_merge_tensors(G1tensor(327),[G1tensor(119),G0tensor(336),G0tensor(128)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(120),G0tensor(341),G0tensor(129)])
  call ol_merge_tensors(G1tensor(111),[G1tensor(325),G1tensor(123),G0tensor(334),G0tensor(132)])
  call ol_merge_tensors(G1tensor(330),[G1tensor(124),G0tensor(339),G0tensor(133)])
  call ol_merge_tensors(G1tensor(342),[G1tensor(129),G0tensor(351),G0tensor(138)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(130),G0tensor(356),G0tensor(139)])
  call ol_merge_tensors(G1tensor(116),[G1tensor(355),G1tensor(340),G1tensor(133),G0tensor(364),G0tensor(349),G0tensor(142)])
  call ol_merge_tensors(G1tensor(360),[G1tensor(345),G1tensor(134),G0tensor(369),G0tensor(354),G0tensor(143)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(68),G3tensor(66),G3tensor(64),G2tensor(183),G2tensor(79),G2tensor(43),G2tensor(37) &
    ,G1tensor(352),G1tensor(203),G1tensor(173),G1tensor(138),G0tensor(361),G0tensor(212),G0tensor(182),G0tensor(147)])
  call ol_merge_tensors(G1tensor(357),[G1tensor(178),G1tensor(139),G0tensor(366),G0tensor(187),G0tensor(148)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(282),G1tensor(143),G0tensor(291),G0tensor(152)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(287),G1tensor(144),G0tensor(296),G0tensor(153)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(198),G2tensor(201),G2tensor(207),G2tensor(28),G2tensor(26),G1tensor(367) &
    ,G1tensor(213),G1tensor(183),G1tensor(148),G0tensor(376),G0tensor(222),G0tensor(192),G0tensor(157)])
  call ol_merge_tensors(G1tensor(372),[G1tensor(274),G1tensor(188),G1tensor(149),G0tensor(381),G0tensor(283),G0tensor(197) &
    ,G0tensor(158)])
  call ol_merge_tensors(G1tensor(370),[G1tensor(153),G0tensor(379),G0tensor(162)])
  call ol_merge_tensors(G1tensor(375),[G1tensor(154),G0tensor(384),G0tensor(163)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(106),G1tensor(193),G1tensor(163),G1tensor(158),G0tensor(202),G0tensor(172) &
    ,G0tensor(167)])
  call ol_merge_tensors(G1tensor(168),[G1tensor(159),G0tensor(177),G0tensor(168)])
  call ol_merge_tensors(G1tensor(264),[G1tensor(239),G1tensor(234),G1tensor(199),G1tensor(169),G1tensor(164),G0tensor(273) &
    ,G0tensor(248),G0tensor(243),G0tensor(208),G0tensor(178),G0tensor(173)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(71),G3tensor(69),G3tensor(67),G3tensor(65),G3tensor(63),G2tensor(41),G2tensor(35) &
    ,G1tensor(269),G1tensor(249),G1tensor(244),G1tensor(209),G1tensor(179),G1tensor(174),G0tensor(278),G0tensor(258),G0tensor(253) &
    ,G0tensor(218),G0tensor(188),G0tensor(183)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(31),G2tensor(135),G2tensor(12),G2tensor(10),G2tensor(8),G1tensor(289),G1tensor(279) &
    ,G1tensor(219),G1tensor(189),G1tensor(184),G0tensor(298),G0tensor(288),G0tensor(228),G0tensor(198),G0tensor(193)])
  call ol_merge_tensors(G1tensor(198),[G1tensor(194),G0tensor(207),G0tensor(203)])
  call ol_merge_tensors(G1tensor(208),[G1tensor(204),G0tensor(217),G0tensor(213)])
  call ol_merge_tensors(G1tensor(284),[G1tensor(218),G1tensor(214),G0tensor(293),G0tensor(227),G0tensor(223)])
  call ol_merge_tensors(G1tensor(232),[G1tensor(224),G0tensor(241),G0tensor(233)])
  call ol_merge_tensors(G1tensor(255),[G1tensor(237),G1tensor(225),G0tensor(264),G0tensor(246),G0tensor(234)])
  call ol_merge_tensors(G1tensor(233),[G1tensor(228),G0tensor(242),G0tensor(237)])
  call ol_merge_tensors(G1tensor(259),[G1tensor(238),G1tensor(229),G0tensor(268),G0tensor(247),G0tensor(238)])
  call ol_merge_tensors(G1tensor(262),[G1tensor(254),G0tensor(271),G0tensor(263)])
  call ol_merge_tensors(G1tensor(263),[G1tensor(258),G0tensor(272),G0tensor(267)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(454),G1tensor(298),G1tensor(293),G0tensor(427),G0tensor(307),G0tensor(302)])
  call ol_merge_tensors(G1tensor(303),[G1tensor(294),G0tensor(312),G0tensor(303)])
  call ol_merge_tensors(G3tensor(126),[G3tensor(125),G3tensor(124),G3tensor(123),G3tensor(122),G3tensor(121),G3tensor(120) &
    ,G3tensor(119),G1tensor(349),G1tensor(344),G1tensor(334),G1tensor(329),G1tensor(319),G1tensor(314),G1tensor(304),G1tensor(299) &
    ,G0tensor(358),G0tensor(353),G0tensor(343),G0tensor(338),G0tensor(328),G0tensor(323),G0tensor(313),G0tensor(308)])
  call ol_merge_tensors(G1tensor(318),[G1tensor(309),G0tensor(327),G0tensor(318)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(469),G1tensor(328),G1tensor(323),G0tensor(442),G0tensor(337),G0tensor(332)])
  call ol_merge_tensors(G1tensor(333),[G1tensor(324),G0tensor(342),G0tensor(333)])
  call ol_merge_tensors(G1tensor(348),[G1tensor(339),G0tensor(357),G0tensor(348)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(479),G1tensor(358),G1tensor(353),G0tensor(452),G0tensor(367),G0tensor(362)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(369),G1tensor(363),G1tensor(354),G0tensor(378),G0tensor(372),G0tensor(363)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(374),G1tensor(364),G1tensor(359),G0tensor(383),G0tensor(373),G0tensor(368)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(377)])
  call ol_merge_tensors(G1tensor(392),[G1tensor(380)])
  call ol_merge_tensors(G1tensor(406),[G1tensor(381)])
  call ol_merge_tensors(G1tensor(396),[G1tensor(384)])
  call ol_merge_tensors(G1tensor(410),[G1tensor(385)])
  call ol_merge_tensors(G1tensor(400),[G1tensor(388)])
  call ol_merge_tensors(G1tensor(403),[G1tensor(391)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(395)])
  call ol_merge_tensors(G1tensor(411),[G1tensor(399)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(444),G1tensor(413),G0tensor(417),G0tensor(386)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(414),G0tensor(387)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(415),G0tensor(388)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(419),G0tensor(392)])
  call ol_merge_tensors(G3tensor(110),[G3tensor(109),G3tensor(103),G3tensor(101),G3tensor(77),G3tensor(76),G3tensor(74) &
    ,G3tensor(73),G1tensor(445),G1tensor(440),G1tensor(435),G1tensor(430),G1tensor(425),G1tensor(420),G0tensor(418),G0tensor(413) &
    ,G0tensor(408),G0tensor(403),G0tensor(398),G0tensor(393)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(424),G0tensor(397)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(429),G0tensor(402)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(434),G0tensor(407)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(439),G0tensor(412)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(449),G0tensor(422)])
  call ol_merge_tensors(G3tensor(118),[G3tensor(117),G3tensor(116),G3tensor(115),G3tensor(82),G3tensor(81),G3tensor(80) &
    ,G3tensor(79),G1tensor(475),G1tensor(470),G1tensor(465),G1tensor(460),G1tensor(455),G1tensor(450),G0tensor(448),G0tensor(443) &
    ,G0tensor(438),G0tensor(433),G0tensor(428),G0tensor(423)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(464),G0tensor(437)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(480),G0tensor(453)])
  call ol_merge_tensors(G3tensor(84),[G3tensor(83),G1tensor(484),G0tensor(457)])
  call ol_merge_tensors(G3tensor(25),[G3tensor(23),G1tensor(485),G0tensor(458)])
  call ol_merge_tensors(G3tensor(86),[G3tensor(85),G1tensor(489),G0tensor(462)])
  call ol_merge_tensors(G3tensor(29),[G3tensor(27),G1tensor(490),G0tensor(463)])
  call ol_merge_tensors(G3tensor(88),[G3tensor(87),G1tensor(494),G0tensor(467)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(31),G1tensor(495),G0tensor(468)])
  call ol_merge_tensors(G3tensor(90),[G3tensor(89),G1tensor(499),G0tensor(472)])
  call ol_merge_tensors(G3tensor(41),[G3tensor(39),G1tensor(515),G1tensor(500),G0tensor(488),G0tensor(473)])
  call ol_merge_tensors(G3tensor(92),[G3tensor(91),G1tensor(504),G0tensor(477)])
  call ol_merge_tensors(G3tensor(45),[G3tensor(43),G1tensor(520),G1tensor(505),G0tensor(493),G0tensor(478)])
  call ol_merge_tensors(G3tensor(94),[G3tensor(93),G1tensor(509),G0tensor(482)])
  call ol_merge_tensors(G3tensor(49),[G3tensor(47),G1tensor(525),G1tensor(510),G0tensor(498),G0tensor(483)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(63),G0tensor(15),G0tensor(10)])
  call ol_merge_tensors(G2tensor(168),[G0tensor(20)])
  call TI_triangle_red(G2tensor(142),RedBasis(4),mass3set(:,1),G0tensor(25),G0tensor(30),G0tensor(35),G0tensor(40),M2L1R1,[nMW], &
    G0tensor(45))
  call TI_triangle_red(G3tensor(114),RedBasis(21),mass3set(:,2),G0tensor(50),G0tensor(55),G0tensor(60),G0tensor(65),M2L1R1,[nMW], &
    G0tensor(70))
  call TI_triangle_red(G3tensor(104),RedBasis(21),mass3set(:,3),G0tensor(75),G0tensor(80),G0tensor(85),G0tensor(90),M2L1R1,[nML], &
    G0tensor(95))
  call TI_triangle_red(G3tensor(106),RedBasis(21),mass3set(:,4),G0tensor(100),G0tensor(105),G0tensor(110), &
    G0tensor(115),M2L1R1,[nMT],G0tensor(120))
  call TI_triangle_red(G3tensor(108),RedBasis(21),mass3set(:,5),G0tensor(125),G0tensor(130),G0tensor(135), &
    G0tensor(140),M2L1R1,[nMB],G0tensor(145))
  call TI_triangle_red(G3tensor(154),RedBasis(1),mass3set(:,3),G0tensor(150),G0tensor(155),G0tensor(160), &
    G0tensor(165),M2L1R1,[nML],G0tensor(170))
  call TI_triangle_red(G3tensor(156),RedBasis(1),mass3set(:,4),G0tensor(175),G0tensor(180),G0tensor(185), &
    G0tensor(190),M2L1R1,[nMT],G0tensor(195))
  call TI_triangle_red(G3tensor(158),RedBasis(1),mass3set(:,5),G0tensor(200),G0tensor(205),G0tensor(210), &
    G0tensor(215),M2L1R1,[nMB],G0tensor(220))
  call TI_triangle_red(G3tensor(134),RedBasis(1),mass3set(:,2),G0tensor(225),G0tensor(230),G0tensor(235), &
    G0tensor(240),M2L1R1,[nMW],G0tensor(245))
  call TI_triangle_red(G2tensor(134),RedBasis(16),mass3set(:,1),G0tensor(250),G0tensor(255),G0tensor(260), &
    G0tensor(265),M2L1R1,[nMW],G0tensor(270))
  call TI_triangle_red(G2tensor(247),RedBasis(64),mass3set(:,1),G0tensor(275),G0tensor(280),G0tensor(285), &
    G0tensor(290),M2L1R1,[nMW],G0tensor(295))
  call TI_triangle_red(G2tensor(170),RedBasis(57),mass3set(:,1),G0tensor(300),G0tensor(305),G0tensor(310), &
    G0tensor(315),M2L1R1,[nMW],G0tensor(320))
  call TI_triangle_red(G2tensor(36),RedBasis(8),mass3set(:,1),G0tensor(325),G0tensor(330),G0tensor(335), &
    G0tensor(340),M2L1R1,[nMW],G0tensor(345))
  call TI_triangle_red(G2tensor(235),RedBasis(62),mass3set(:,1),G0tensor(350),G0tensor(355),G0tensor(360), &
    G0tensor(365),M2L1R1,[nMW],G0tensor(370))
  call TI_triangle_red(G2tensor(176),RedBasis(59),mass3set(:,1),G0tensor(375),G0tensor(380),G0tensor(1),G0tensor(2),M2L1R1,[nMW], &
    G0tensor(3))
  call TI_triangle_red(G2tensor(53),RedBasis(60),mass3set(:,2),G0tensor(4),G0tensor(5),G0tensor(6),G0tensor(7),M2L1R1,[nMW], &
    G0tensor(8))
  call TI_triangle_red(G3tensor(50),RedBasis(58),mass3set(:,2),G0tensor(9),G0tensor(385),G0tensor(390),G0tensor(395),M2L1R1,[nMW], &
    G0tensor(400))
  call TI_triangle_red(G3tensor(37),RedBasis(5),mass3set(:,2),G0tensor(405),G0tensor(410),G0tensor(415), &
    G0tensor(420),M2L1R1,[nMW],G0tensor(425))
  call TI_triangle_red(G2tensor(59),RedBasis(22),mass3set(:,6),G0tensor(430),G0tensor(435),G0tensor(440), &
    G0tensor(445),M2L1R1,[nMW],G0tensor(450))
  call TI_triangle_red(G2tensor(270),RedBasis(16),mass3set(:,7),G0tensor(455),G0tensor(460),G0tensor(465), &
    G0tensor(470),M2L1R1,[nMW],G0tensor(475))
  call TI_triangle_red(G2tensor(259),RedBasis(62),mass3set(:,8),G0tensor(480),G0tensor(485),G0tensor(490),G0tensor(495),M2L1R1)
  call TI_triangle_red(G2tensor(234),RedBasis(16),mass3set(:,8),G0tensor(226),G0tensor(154),G0tensor(99),G0tensor(17),M2L1R1)
  call TI_triangle_red(G2tensor(262),RedBasis(62),mass3set(:,9),G0tensor(194),G0tensor(184),G0tensor(48), &
    G0tensor(43),M2L1R1,[nMZ],G0tensor(474))
  call TI_triangle_red(G2tensor(102),RedBasis(16),mass3set(:,9),G0tensor(459),G0tensor(479),G0tensor(464), &
    G0tensor(484),M2L1R1,[nMZ],G0tensor(469))
  call TI_triangle_red(G2tensor(265),RedBasis(62),mass3set(:,7),G0tensor(489),G0tensor(494),G0tensor(499), &
    G0tensor(259),M2L1R1,[nMW],G0tensor(29))
  call TI_triangle_red(G2tensor(250),RedBasis(64),mass3set(:,8),G0tensor(19),G0tensor(389),G0tensor(229),G0tensor(219),M2L1R1)
  call TI_triangle_red(G2tensor(128),RedBasis(10),mass3set(:,8),G0tensor(49),G0tensor(39),G0tensor(76),G0tensor(72),M2L1R1)
  call TI_triangle_red(G2tensor(253),RedBasis(64),mass3set(:,9),G0tensor(66),G0tensor(41),G0tensor(186),G0tensor(69),M2L1R1,[nMZ], &
    G0tensor(196))
  call TI_triangle_red(G2tensor(65),RedBasis(10),mass3set(:,9),G0tensor(124),G0tensor(79),G0tensor(27),G0tensor(96),M2L1R1,[nMZ], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(256),RedBasis(64),mass3set(:,7),G0tensor(52),G0tensor(46),G0tensor(216),G0tensor(94),M2L1R1,[nMW], &
    G0tensor(256))
  call TI_triangle_red(G2tensor(77),RedBasis(10),mass3set(:,7),G0tensor(74),G0tensor(54),G0tensor(181),G0tensor(93),M2L1R1,[nMW], &
    G0tensor(68))
  call TI_triangle_red(G2tensor(246),RedBasis(10),mass3set(:,1),G0tensor(257),G0tensor(191),G0tensor(98), &
    G0tensor(78),M2L1R1,[nMW],G0tensor(371))
  call TI_triangle_red(G2tensor(122),RedBasis(8),mass3set(:,8),G0tensor(159),G0tensor(149),G0tensor(42),G0tensor(404),M2L1R1)
  call TI_triangle_red(G2tensor(121),RedBasis(8),mass3set(:,9),G0tensor(374),G0tensor(359),G0tensor(164), &
    G0tensor(144),M2L1R1,[nMZ],G0tensor(436))
  call TI_triangle_red(G2tensor(48),RedBasis(8),mass3set(:,7),G0tensor(391),G0tensor(394),G0tensor(441), &
    G0tensor(396),M2L1R1,[nMW],G0tensor(399))
  call TI_triangle_red(G2tensor(96),RedBasis(4),mass3set(:,8),G0tensor(344),G0tensor(134),G0tensor(446),G0tensor(401),M2L1R1)
  call TI_triangle_red(G2tensor(97),RedBasis(4),mass3set(:,9),G0tensor(421),G0tensor(406),G0tensor(409), &
    G0tensor(426),M2L1R1,[nMZ],G0tensor(411))
  call TI_triangle_red(G2tensor(140),RedBasis(4),mass3set(:,7),G0tensor(414),G0tensor(314),G0tensor(109), &
    G0tensor(431),M2L1R1,[nMW],G0tensor(416))
  call TI_triangle_red(G2tensor(18),RedBasis(9),mass3set(:,6),G0tensor(419),G0tensor(329),G0tensor(119), &
    G0tensor(199),M2L1R1,[nMW],G0tensor(189))
  call TI_triangle_red(G2tensor(271),RedBasis(64),mass3set(:,10),G0tensor(44),G0tensor(34),G0tensor(424), &
    G0tensor(429),M2L1R1,[nMZ],G0tensor(434))
  call TI_triangle_red(G2tensor(272),RedBasis(57),mass3set(:,10),G0tensor(439),G0tensor(444),G0tensor(454), &
    G0tensor(449),M2L1R1,[nMZ],G0tensor(451))
  call TI_triangle_red(G2tensor(274),RedBasis(62),mass3set(:,10),G0tensor(277),G0tensor(161),G0tensor(156), &
    G0tensor(77),M2L1R1,[nMZ],G0tensor(266))
  call TI_triangle_red(G2tensor(275),RedBasis(59),mass3set(:,10),G0tensor(262),G0tensor(61),G0tensor(56), &
    G0tensor(176),M2L1R1,[nMZ],G0tensor(59))
  call TI_triangle_red(G3tensor(24),RedBasis(5),mass3set(:,3),G0tensor(236),G0tensor(232),G0tensor(86),G0tensor(81),M2L1R1,[nML], &
    G0tensor(206))
  call TI_triangle_red(G3tensor(28),RedBasis(5),mass3set(:,4),G0tensor(84),G0tensor(487),G0tensor(456),G0tensor(492),M2L1R1,[nMT], &
    G0tensor(461))
  call TI_triangle_red(G3tensor(32),RedBasis(5),mass3set(:,5),G0tensor(497),G0tensor(466),G0tensor(471), &
    G0tensor(476),M2L1R1,[nMB],G0tensor(481))
  call TI_triangle_red(G3tensor(40),RedBasis(58),mass3set(:,3),G0tensor(486),G0tensor(491),G0tensor(496), &
    G0tensor(301),M2L1R1,[nML],G0tensor(231))
  call TI_triangle_red(G3tensor(44),RedBasis(58),mass3set(:,4),G0tensor(102),G0tensor(11),G0tensor(239),G0tensor(12),M2L1R1,[nMT], &
    G0tensor(244))
  call TI_triangle_red(G3tensor(48),RedBasis(58),mass3set(:,5),G0tensor(13),G0tensor(249),G0tensor(24),G0tensor(14),M2L1R1,[nMB], &
    G0tensor(316))
  call TI_triangle_red(G3tensor(58),RedBasis(60),mass3set(:,3),G0tensor(112),G0tensor(51),G0tensor(16),G0tensor(254),M2L1R1,[nML], &
    G0tensor(18))
  call TI_triangle_red(G3tensor(60),RedBasis(60),mass3set(:,4),G0tensor(331),G0tensor(261),G0tensor(127), &
    G0tensor(21),M2L1R1,[nMT],G0tensor(269))
  call TI_triangle_red(G3tensor(62),RedBasis(60),mass3set(:,5),G0tensor(22),G0tensor(274),G0tensor(23),G0tensor(382),M2L1R1,[nMB], &
    G0tensor(377))
  call TI_triangle_red(G2tensor(131),RedBasis(1),mass3set(:,11),G0tensor(346),G0tensor(137),G0tensor(71), &
    G0tensor(26),M2L1R1,[nMH,nMZ],G0tensor(279),G0tensor(28))
  call TI_triangle_red(G2tensor(71),RedBasis(6),mass3set(:,12),G0tensor(447),G0tensor(352),G0tensor(347), &
    G0tensor(121),M2L1R1,[nMW],G0tensor(31))
  call TI_triangle_red(G2tensor(23),RedBasis(9),mass3set(:,12),G0tensor(284),G0tensor(32),G0tensor(289),G0tensor(33),M2L1R1,[nMW], &
    G0tensor(432))
  call TI_triangle_red(G2tensor(116),RedBasis(26),mass3set(:,6),G0tensor(322),G0tensor(317),G0tensor(151), &
    G0tensor(36),M2L1R1,[nMW],G0tensor(294))
  call TI_triangle_red(G2tensor(73),RedBasis(15),mass3set(:,13),G0tensor(37),G0tensor(299),G0tensor(38), &
    G0tensor(224),M2L1R1,[nMZ],G0tensor(214))
  call TI_triangle_red(G2tensor(76),RedBasis(58),mass3set(:,14),G0tensor(47),G0tensor(251),G0tensor(53), &
    G0tensor(166),M2L1R1,[nMZ],G0tensor(131))
  call TI_triangle_red(G2tensor(20),RedBasis(15),mass3set(:,6),G0tensor(126),G0tensor(57),G0tensor(171),G0tensor(83),M2L1R1,[nMW], &
    G0tensor(58))
  call TI_triangle_red(G2tensor(54),RedBasis(20),mass3set(:,13),G0tensor(169),G0tensor(62),G0tensor(174), &
    G0tensor(88),M2L1R1,[nMZ],G0tensor(63))
  call TI_triangle_red(G2tensor(22),RedBasis(20),mass3set(:,6),G0tensor(179),G0tensor(64),G0tensor(287), &
    G0tensor(282),M2L1R1,[nMW],G0tensor(146))
  call TI_triangle_red(G2tensor(25),RedBasis(6),mass3set(:,6),G0tensor(141),G0tensor(136),G0tensor(67),G0tensor(276),M2L1R1,[nMW], &
    G0tensor(73))
  call TI_triangle_red(G3tensor(70),RedBasis(24),mass3set(:,2),G0tensor(201),G0tensor(106),G0tensor(101), &
    G0tensor(82),M2L1R1,[nMW],G0tensor(204))
  call TI_triangle_red(G2tensor(42),RedBasis(32),mass3set(:,15),G0tensor(87),G0tensor(209),G0tensor(89), &
    G0tensor(297),M2L1R1,[nMW],G0tensor(292))
  call TI_triangle_red(G2tensor(4),RedBasis(56),mass3set(:,1),G0tensor(211),G0tensor(116),G0tensor(111),G0tensor(92),M2L1R1,[nMW], &
    G0tensor(252))
  call TI_triangle_red(G2tensor(186),RedBasis(25),mass3set(:,2),G0tensor(221),G0tensor(97),G0tensor(306), &
    G0tensor(103),M2L1R1,[nMW],G0tensor(311))
  call TI_triangle_red(G2tensor(171),RedBasis(24),mass3set(:,11),G0tensor(104),G0tensor(304),G0tensor(107), &
    G0tensor(309),M2L1R1,[nMH,nMZ],G0tensor(108),G0tensor(321))
  call TI_triangle_red(G3tensor(72),RedBasis(3),mass3set(:,2),G0tensor(113),G0tensor(326),G0tensor(114), &
    G0tensor(319),M2L1R1,[nMW],G0tensor(117))
  call TI_triangle_red(G2tensor(34),RedBasis(12),mass3set(:,2),G0tensor(324),G0tensor(118),G0tensor(281), &
    G0tensor(122),M2L1R1,[nMW],G0tensor(286))
  call TI_triangle_red(G2tensor(64),RedBasis(9),mass3set(:,16),G0tensor(123),G0tensor(336),G0tensor(128), &
    G0tensor(341),M2L1R1,[nMZ],G0tensor(129))
  call TI_triangle_red(G3tensor(126),RedBasis(3),mass3set(:,8),G0tensor(334),G0tensor(132),G0tensor(339),G0tensor(133),M2L1R1)
  call TI_triangle_red(G2tensor(74),RedBasis(6),mass3set(:,16),G0tensor(351),G0tensor(138),G0tensor(356), &
    G0tensor(139),M2L1R1,[nMZ],G0tensor(364))
  call TI_triangle_red(G2tensor(24),RedBasis(32),mass3set(:,17),G0tensor(349),G0tensor(142),G0tensor(369), &
    G0tensor(354),M2L1R1,[nMW],G0tensor(143))
  call TI_triangle_red(G2tensor(118),RedBasis(31),mass3set(:,17),G0tensor(361),G0tensor(212),G0tensor(182), &
    G0tensor(147),M2L1R1,[nMW],G0tensor(366))
  call TI_triangle_red(G2tensor(40),RedBasis(30),mass3set(:,7),G0tensor(187),G0tensor(148),G0tensor(291), &
    G0tensor(152),M2L1R1,[nMW],G0tensor(296))
  call TI_triangle_red(G2tensor(50),RedBasis(22),mass3set(:,12),G0tensor(153),G0tensor(376),G0tensor(222), &
    G0tensor(192),M2L1R1,[nMW],G0tensor(157))
  call TI_triangle_red(G2tensor(11),RedBasis(31),mass3set(:,15),G0tensor(381),G0tensor(283),G0tensor(197), &
    G0tensor(158),M2L1R1,[nMW],G0tensor(379))
  call TI_triangle_red(G2tensor(47),RedBasis(30),mass3set(:,1),G0tensor(162),G0tensor(384),G0tensor(163), &
    G0tensor(202),M2L1R1,[nMW],G0tensor(172))
  call TI_triangle_red(G2tensor(44),RedBasis(26),mass3set(:,8),G0tensor(167),G0tensor(177),G0tensor(168),G0tensor(273),M2L1R1)
  call TI_triangle_red(G3tensor(110),RedBasis(21),mass3set(:,8),G0tensor(248),G0tensor(243),G0tensor(208),G0tensor(178),M2L1R1)
  call TI_triangle_red(G2tensor(49),RedBasis(26),mass3set(:,16),G0tensor(173),G0tensor(278),G0tensor(258), &
    G0tensor(253),M2L1R1,[nMZ],G0tensor(218))
  call TI_triangle_red(G2tensor(46),RedBasis(26),mass3set(:,12),G0tensor(188),G0tensor(183),G0tensor(298), &
    G0tensor(288),M2L1R1,[nMW],G0tensor(228))
  call TI_triangle_red(G2tensor(55),RedBasis(22),mass3set(:,8),G0tensor(198),G0tensor(193),G0tensor(207),G0tensor(203),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(22),mass3set(:,16),G0tensor(217),G0tensor(213),G0tensor(293), &
    G0tensor(227),M2L1R1,[nMZ],G0tensor(223))
  call TI_triangle_red(G2tensor(62),RedBasis(9),mass3set(:,8),G0tensor(241),G0tensor(233),G0tensor(264),G0tensor(246),M2L1R1)
  call TI_triangle_red(G3tensor(118),RedBasis(5),mass3set(:,8),G0tensor(234),G0tensor(242),G0tensor(237),G0tensor(268),M2L1R1)
  call TI_triangle_red(G2tensor(68),RedBasis(6),mass3set(:,8),G0tensor(247),G0tensor(238),G0tensor(271),G0tensor(263),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(56),mass3set(:,7),G0tensor(272),G0tensor(267),G0tensor(427), &
    G0tensor(307),M2L1R1,[nMW],G0tensor(302))
  call TI_triangle_red(G3tensor(84),RedBasis(25),mass3set(:,3),G0tensor(312),G0tensor(303),G0tensor(358), &
    G0tensor(353),M2L1R1,[nML],G0tensor(343))
  call TI_triangle_red(G3tensor(25),RedBasis(12),mass3set(:,3),G0tensor(338),G0tensor(328),G0tensor(323), &
    G0tensor(313),M2L1R1,[nML],G0tensor(308))
  call TI_triangle_red(G3tensor(86),RedBasis(25),mass3set(:,4),G0tensor(327),G0tensor(318),G0tensor(442), &
    G0tensor(337),M2L1R1,[nMT],G0tensor(332))
  call TI_triangle_red(G3tensor(29),RedBasis(12),mass3set(:,4),G0tensor(342),G0tensor(333),G0tensor(357), &
    G0tensor(348),M2L1R1,[nMT],G0tensor(452))
  call TI_triangle_red(G3tensor(88),RedBasis(25),mass3set(:,5),G0tensor(367),G0tensor(362),G0tensor(378), &
    G0tensor(372),M2L1R1,[nMB],G0tensor(363))
  call TI_triangle_red(G3tensor(33),RedBasis(12),mass3set(:,5),G0tensor(383),G0tensor(373),G0tensor(368), &
    G0tensor(417),M2L1R1,[nMB],G0tensor(386))
  call TI_triangle_red(G3tensor(90),RedBasis(24),mass3set(:,3),G0tensor(387),G0tensor(388),G0tensor(392), &
    G0tensor(418),M2L1R1,[nML],G0tensor(413))
  call TI_triangle_red(G3tensor(41),RedBasis(3),mass3set(:,3),G0tensor(408),G0tensor(403),G0tensor(398), &
    G0tensor(393),M2L1R1,[nML],G0tensor(397))
  call TI_triangle_red(G3tensor(92),RedBasis(24),mass3set(:,4),G0tensor(402),G0tensor(407),G0tensor(412), &
    G0tensor(422),M2L1R1,[nMT],G0tensor(448))
  call TI_triangle_red(G3tensor(45),RedBasis(3),mass3set(:,4),G0tensor(443),G0tensor(438),G0tensor(433), &
    G0tensor(428),M2L1R1,[nMT],G0tensor(423))
  call TI_triangle_red(G3tensor(94),RedBasis(24),mass3set(:,5),G0tensor(437),G0tensor(453),G0tensor(457), &
    G0tensor(458),M2L1R1,[nMB],G0tensor(462))
  call TI_triangle_red(G3tensor(49),RedBasis(3),mass3set(:,5),G0tensor(463),G0tensor(467),G0tensor(468), &
    G0tensor(472),M2L1R1,[nMB],G0tensor(488))
  call TI_triangle_red(G2tensor(153),RedBasis(1),mass3set(:,18),G0tensor(473),G0tensor(477),G0tensor(493), &
    G0tensor(478),M2L1R1,[nMZ,nMH],G0tensor(482),G0tensor(498))
  call TI_triangle_red(G2tensor(168),RedBasis(24),mass3set(:,18),G0tensor(483),G0tensor(15),G0tensor(10), &
    G0tensor(20),M2L1R1,[nMZ,nMH],G0tensor(500),G0tensor(501))
  call TI_triangle_red(G1tensor(292),RedBasis(65),mass3set(:,19),G0tensor(502),G0tensor(503),G0tensor(504), &
    G0tensor(505),M2L1R1,[nMZ],G0tensor(506))
  call TI_triangle_red(G1tensor(230),RedBasis(4),mass3set(:,20),G0tensor(507),G0tensor(508),G0tensor(509), &
    G0tensor(510),M2L1R1,[nMH,nMZ],G0tensor(511),G0tensor(512))
  call TI_triangle_red(G1tensor(235),RedBasis(2),mass3set(:,20),G0tensor(513),G0tensor(514),G0tensor(515), &
    G0tensor(516),M2L1R1,[nMH,nMZ],G0tensor(517),G0tensor(518))
  call TI_triangle_red(G1tensor(307),RedBasis(65),mass3set(:,17),G0tensor(519),G0tensor(520),G0tensor(521), &
    G0tensor(522),M2L1R1,[nMW],G0tensor(523))
  call TI_triangle_red(G1tensor(245),RedBasis(2),mass3set(:,1),G0tensor(524),G0tensor(525),G0tensor(526), &
    G0tensor(527),M2L1R1,[nMW],G0tensor(528))
  call TI_triangle_red(G1tensor(322),RedBasis(33),mass3set(:,19),G0tensor(529),G0tensor(530),G0tensor(531), &
    G0tensor(532),M2L1R1,[nMZ],G0tensor(533))
  call TI_triangle_red(G1tensor(260),RedBasis(8),mass3set(:,20),G0tensor(534),G0tensor(535),G0tensor(536), &
    G0tensor(537),M2L1R1,[nMH,nMZ],G0tensor(538),G0tensor(539))
  call TI_triangle_red(G1tensor(265),RedBasis(7),mass3set(:,20),G0tensor(540),G0tensor(541),G0tensor(542), &
    G0tensor(543),M2L1R1,[nMH,nMZ],G0tensor(544),G0tensor(545))
  call TI_triangle_red(G1tensor(373),RedBasis(33),mass3set(:,17),G0tensor(546),G0tensor(547),G0tensor(548), &
    G0tensor(549),M2L1R1,[nMW],G0tensor(550))
  call TI_triangle_red(G1tensor(270),RedBasis(7),mass3set(:,1),G0tensor(551),G0tensor(552),G0tensor(553), &
    G0tensor(554),M2L1R1,[nMW],G0tensor(555))
  call TI_triangle_red(G1tensor(275),RedBasis(13),mass3set(:,15),G0tensor(556),G0tensor(557),G0tensor(558), &
    G0tensor(559),M2L1R1,[nMW],G0tensor(560))
  call TI_triangle_red(G1tensor(280),RedBasis(11),mass3set(:,1),G0tensor(561),G0tensor(562),G0tensor(563), &
    G0tensor(564),M2L1R1,[nMW],G0tensor(565))
  call TI_triangle_red(G1tensor(285),RedBasis(18),mass3set(:,15),G0tensor(566),G0tensor(567),G0tensor(568), &
    G0tensor(569),M2L1R1,[nMW],G0tensor(570))
  call TI_triangle_red(G1tensor(290),RedBasis(17),mass3set(:,1),G0tensor(571),G0tensor(572),G0tensor(573), &
    G0tensor(574),M2L1R1,[nMW],G0tensor(575))
  call TI_triangle_red(G1tensor(242),RedBasis(61),mass3set(:,1),G0tensor(576),G0tensor(577),G0tensor(578), &
    G0tensor(579),M2L1R1,[nMW],G0tensor(580))
  call TI_triangle_red(G1tensor(160),RedBasis(22),mass3set(:,21),G0tensor(581),G0tensor(582),G0tensor(583), &
    G0tensor(584),M2L1R1,[nMH,nMZ],G0tensor(585),G0tensor(586))
  call TI_triangle_red(G1tensor(165),RedBasis(21),mass3set(:,11),G0tensor(587),G0tensor(588),G0tensor(589), &
    G0tensor(590),M2L1R1,[nMH,nMZ],G0tensor(591),G0tensor(592))
  call TI_triangle_red(G1tensor(170),RedBasis(10),mass3set(:,20),G0tensor(593),G0tensor(594),G0tensor(595), &
    G0tensor(596),M2L1R1,[nMH,nMZ],G0tensor(597),G0tensor(598))
  call TI_triangle_red(G1tensor(267),RedBasis(63),mass3set(:,1),G0tensor(599),G0tensor(600),G0tensor(601), &
    G0tensor(602),M2L1R1,[nMW],G0tensor(603))
  call TI_triangle_red(G1tensor(195),RedBasis(26),mass3set(:,21),G0tensor(604),G0tensor(605),G0tensor(606), &
    G0tensor(607),M2L1R1,[nMH,nMZ],G0tensor(608),G0tensor(609))
  call TI_triangle_red(G1tensor(200),RedBasis(16),mass3set(:,20),G0tensor(610),G0tensor(611),G0tensor(612), &
    G0tensor(613),M2L1R1,[nMH,nMZ],G0tensor(614),G0tensor(615))
  call TI_triangle_red(G1tensor(297),RedBasis(63),mass3set(:,9),G0tensor(616),G0tensor(617),G0tensor(618), &
    G0tensor(619),M2L1R1,[nMZ],G0tensor(620))
  call TI_triangle_red(G1tensor(302),RedBasis(57),mass3set(:,9),G0tensor(621),G0tensor(622),G0tensor(623), &
    G0tensor(624),M2L1R1,[nMZ],G0tensor(625))
  call TI_triangle_red(G1tensor(71),RedBasis(28),mass3set(:,19),G0tensor(626),G0tensor(627),G0tensor(628), &
    G0tensor(629),M2L1R1,[nMZ],G0tensor(630))
  call TI_triangle_red(G1tensor(300),RedBasis(7),mass3set(:,9),G0tensor(631),G0tensor(632),G0tensor(633), &
    G0tensor(634),M2L1R1,[nMZ],G0tensor(635))
  call TI_triangle_red(G1tensor(312),RedBasis(63),mass3set(:,7),G0tensor(636),G0tensor(637),G0tensor(638), &
    G0tensor(639),M2L1R1,[nMW],G0tensor(640))
  call TI_triangle_red(G1tensor(317),RedBasis(57),mass3set(:,7),G0tensor(641),G0tensor(642),G0tensor(643), &
    G0tensor(644),M2L1R1,[nMW],G0tensor(645))
  call TI_triangle_red(G1tensor(83),RedBasis(28),mass3set(:,17),G0tensor(646),G0tensor(647),G0tensor(648), &
    G0tensor(649),M2L1R1,[nMW],G0tensor(650))
  call TI_triangle_red(G1tensor(315),RedBasis(7),mass3set(:,7),G0tensor(651),G0tensor(652),G0tensor(653), &
    G0tensor(654),M2L1R1,[nMW],G0tensor(655))
  call TI_triangle_red(G1tensor(272),RedBasis(67),mass3set(:,15),G0tensor(656),G0tensor(657),G0tensor(658), &
    G0tensor(659),M2L1R1,[nMW],G0tensor(660))
  call TI_triangle_red(G1tensor(277),RedBasis(66),mass3set(:,1),G0tensor(661),G0tensor(662),G0tensor(663), &
    G0tensor(664),M2L1R1,[nMW],G0tensor(665))
  call TI_triangle_red(G1tensor(327),RedBasis(61),mass3set(:,9),G0tensor(666),G0tensor(667),G0tensor(668), &
    G0tensor(669),M2L1R1,[nMZ],G0tensor(670))
  call TI_triangle_red(G1tensor(332),RedBasis(59),mass3set(:,9),G0tensor(671),G0tensor(672),G0tensor(673), &
    G0tensor(674),M2L1R1,[nMZ],G0tensor(675))
  call TI_triangle_red(G1tensor(111),RedBasis(29),mass3set(:,19),G0tensor(676),G0tensor(677),G0tensor(678), &
    G0tensor(679),M2L1R1,[nMZ],G0tensor(680))
  call TI_triangle_red(G1tensor(330),RedBasis(2),mass3set(:,9),G0tensor(681),G0tensor(682),G0tensor(683), &
    G0tensor(684),M2L1R1,[nMZ],G0tensor(685))
  call TI_triangle_red(G1tensor(342),RedBasis(61),mass3set(:,7),G0tensor(686),G0tensor(687),G0tensor(688), &
    G0tensor(689),M2L1R1,[nMW],G0tensor(690))
  call TI_triangle_red(G1tensor(347),RedBasis(59),mass3set(:,7),G0tensor(691),G0tensor(692),G0tensor(693), &
    G0tensor(694),M2L1R1,[nMW],G0tensor(695))
  call TI_triangle_red(G1tensor(116),RedBasis(29),mass3set(:,17),G0tensor(696),G0tensor(697),G0tensor(698), &
    G0tensor(699),M2L1R1,[nMW],G0tensor(700))
  call TI_triangle_red(G1tensor(360),RedBasis(2),mass3set(:,7),G0tensor(701),G0tensor(702),G0tensor(703), &
    G0tensor(704),M2L1R1,[nMW],G0tensor(705))
  call TI_triangle_red(G1tensor(357),RedBasis(23),mass3set(:,6),G0tensor(706),G0tensor(707),G0tensor(708), &
    G0tensor(709),M2L1R1,[nMW],G0tensor(710))
  call TI_triangle_red(G1tensor(372),RedBasis(14),mass3set(:,6),G0tensor(711),G0tensor(712),G0tensor(713), &
    G0tensor(714),M2L1R1,[nMW],G0tensor(715))
  call TI_triangle_red(G1tensor(370),RedBasis(18),mass3set(:,17),G0tensor(716),G0tensor(717),G0tensor(718), &
    G0tensor(719),M2L1R1,[nMW],G0tensor(720))
  call TI_triangle_red(G1tensor(375),RedBasis(17),mass3set(:,7),G0tensor(721),G0tensor(722),G0tensor(723), &
    G0tensor(724),M2L1R1,[nMW],G0tensor(725))
  call TI_triangle_red(G1tensor(168),RedBasis(23),mass3set(:,21),G0tensor(726),G0tensor(727),G0tensor(728), &
    G0tensor(729),M2L1R1,[nMH,nMZ],G0tensor(730),G0tensor(731))
  call TI_triangle_red(G1tensor(264),RedBasis(3),mass3set(:,11),G0tensor(732),G0tensor(733),G0tensor(734), &
    G0tensor(735),M2L1R1,[nMH,nMZ],G0tensor(736),G0tensor(737))
  call TI_triangle_red(G1tensor(198),RedBasis(27),mass3set(:,21),G0tensor(738),G0tensor(739),G0tensor(740), &
    G0tensor(741),M2L1R1,[nMH,nMZ],G0tensor(742),G0tensor(743))
  call TI_triangle_red(G1tensor(208),RedBasis(27),mass3set(:,6),G0tensor(744),G0tensor(745),G0tensor(746), &
    G0tensor(747),M2L1R1,[nMW],G0tensor(748))
  call TI_triangle_red(G1tensor(284),RedBasis(19),mass3set(:,6),G0tensor(749),G0tensor(750),G0tensor(751), &
    G0tensor(752),M2L1R1,[nMW],G0tensor(753))
  call TI_triangle_red(G1tensor(232),RedBasis(61),mass3set(:,10),G0tensor(754),G0tensor(755),G0tensor(756), &
    G0tensor(757),M2L1R1,[nMZ],G0tensor(758))
  call TI_triangle_red(G1tensor(255),RedBasis(60),mass3set(:,14),G0tensor(759),G0tensor(760),G0tensor(761), &
    G0tensor(762),M2L1R1,[nMZ],G0tensor(763))
  call TI_triangle_red(G1tensor(233),RedBasis(6),mass3set(:,21),G0tensor(764),G0tensor(765),G0tensor(766), &
    G0tensor(767),M2L1R1,[nMH,nMZ],G0tensor(768),G0tensor(769))
  call TI_triangle_red(G1tensor(259),RedBasis(5),mass3set(:,11),G0tensor(770),G0tensor(771),G0tensor(772), &
    G0tensor(773),M2L1R1,[nMH,nMZ],G0tensor(774),G0tensor(775))
  call TI_triangle_red(G1tensor(262),RedBasis(63),mass3set(:,10),G0tensor(776),G0tensor(777),G0tensor(778), &
    G0tensor(779),M2L1R1,[nMZ],G0tensor(780))
  call TI_triangle_red(G1tensor(263),RedBasis(9),mass3set(:,21),G0tensor(781),G0tensor(782),G0tensor(783), &
    G0tensor(784),M2L1R1,[nMH,nMZ],G0tensor(785),G0tensor(786))
  call TI_triangle_red(G1tensor(303),RedBasis(23),mass3set(:,16),G0tensor(787),G0tensor(788),G0tensor(789), &
    G0tensor(790),M2L1R1,[nMZ],G0tensor(791))
  call TI_triangle_red(G1tensor(318),RedBasis(23),mass3set(:,12),G0tensor(792),G0tensor(793),G0tensor(794), &
    G0tensor(795),M2L1R1,[nMW],G0tensor(796))
  call TI_triangle_red(G1tensor(333),RedBasis(27),mass3set(:,16),G0tensor(797),G0tensor(798),G0tensor(799), &
    G0tensor(800),M2L1R1,[nMZ],G0tensor(801))
  call TI_triangle_red(G1tensor(348),RedBasis(27),mass3set(:,12),G0tensor(802),G0tensor(803),G0tensor(804), &
    G0tensor(805),M2L1R1,[nMW],G0tensor(806))
  call ol_merge_tensors(T0sum(108),[G0tensor(25)])
  call ol_merge_tensors(T0sum(109),[G0tensor(50)])
  call ol_merge_tensors(T0sum(110),[G0tensor(75)])
  call ol_merge_tensors(T0sum(111),[G0tensor(100)])
  call ol_merge_tensors(T0sum(112),[G0tensor(125)])
  call ol_merge_tensors(T0sum(113),[G0tensor(150)])
  call ol_merge_tensors(T0sum(114),[G0tensor(175)])
  call ol_merge_tensors(T0sum(115),[G0tensor(200)])
  call ol_merge_tensors(T0sum(116),[G0tensor(225)])
  call ol_merge_tensors(T0sum(117),[G0tensor(250)])
  call ol_merge_tensors(T0sum(118),[G0tensor(275)])
  call ol_merge_tensors(T0sum(119),[G0tensor(300)])
  call ol_merge_tensors(T0sum(120),[G0tensor(325)])
  call ol_merge_tensors(T0sum(121),[G0tensor(350)])
  call ol_merge_tensors(T0sum(122),[G0tensor(375)])
  call ol_merge_tensors(T0sum(123),[G0tensor(4)])
  call ol_merge_tensors(T0sum(124),[G0tensor(9)])
  call ol_merge_tensors(T0sum(125),[G0tensor(405)])
  call ol_merge_tensors(T0sum(126),[G0tensor(430)])
  call ol_merge_tensors(T0sum(127),[G0tensor(455)])
  call ol_merge_tensors(T0sum(128),[G0tensor(480)])
  call ol_merge_tensors(T0sum(129),[G0tensor(226)])
  call ol_merge_tensors(T0sum(130),[G0tensor(194)])
  call ol_merge_tensors(T0sum(131),[G0tensor(459)])
  call ol_merge_tensors(T0sum(132),[G0tensor(489)])
  call ol_merge_tensors(T0sum(133),[G0tensor(19)])
  call ol_merge_tensors(T0sum(134),[G0tensor(49)])
  call ol_merge_tensors(T0sum(135),[G0tensor(66)])
  call ol_merge_tensors(T0sum(136),[G0tensor(124)])
  call ol_merge_tensors(T0sum(137),[G0tensor(52)])
  call ol_merge_tensors(T0sum(138),[G0tensor(74)])
  call ol_merge_tensors(T0sum(139),[G0tensor(257)])
  call ol_merge_tensors(T0sum(140),[G0tensor(159)])
  call ol_merge_tensors(T0sum(141),[G0tensor(374)])
  call ol_merge_tensors(T0sum(142),[G0tensor(391)])
  call ol_merge_tensors(T0sum(143),[G0tensor(344)])
  call ol_merge_tensors(T0sum(144),[G0tensor(421)])
  call ol_merge_tensors(T0sum(145),[G0tensor(414)])
  call ol_merge_tensors(T0sum(146),[G0tensor(419)])
  call ol_merge_tensors(T0sum(147),[G0tensor(44)])
  call ol_merge_tensors(T0sum(148),[G0tensor(439)])
  call ol_merge_tensors(T0sum(149),[G0tensor(277)])
  call ol_merge_tensors(T0sum(150),[G0tensor(262)])
  call ol_merge_tensors(T0sum(151),[G0tensor(236)])
  call ol_merge_tensors(T0sum(152),[G0tensor(84)])
  call ol_merge_tensors(T0sum(153),[G0tensor(497)])
  call ol_merge_tensors(T0sum(154),[G0tensor(486)])
  call ol_merge_tensors(T0sum(155),[G0tensor(102)])
  call ol_merge_tensors(T0sum(156),[G0tensor(13)])
  call ol_merge_tensors(T0sum(157),[G0tensor(112)])
  call ol_merge_tensors(T0sum(158),[G0tensor(331)])
  call ol_merge_tensors(T0sum(159),[G0tensor(22)])
  call ol_merge_tensors(T0sum(160),[G0tensor(502)])
  call ol_merge_tensors(T0sum(161),[G0tensor(507)])
  call ol_merge_tensors(T0sum(162),[G0tensor(513)])
  call ol_merge_tensors(T0sum(163),[G0tensor(346)])
  call ol_merge_tensors(T0sum(164),[G0tensor(519)])
  call ol_merge_tensors(T0sum(165),[G0tensor(524)])
  call ol_merge_tensors(T0sum(166),[G0tensor(529)])
  call ol_merge_tensors(T0sum(167),[G0tensor(534)])
  call ol_merge_tensors(T0sum(168),[G0tensor(540)])
  call ol_merge_tensors(T0sum(169),[G0tensor(546)])
  call ol_merge_tensors(T0sum(170),[G0tensor(551)])
  call ol_merge_tensors(T0sum(171),[G0tensor(447)])
  call ol_merge_tensors(T0sum(172),[G0tensor(556)])
  call ol_merge_tensors(T0sum(173),[G0tensor(561)])
  call ol_merge_tensors(T0sum(174),[G0tensor(284)])
  call ol_merge_tensors(T0sum(175),[G0tensor(566)])
  call ol_merge_tensors(T0sum(176),[G0tensor(571)])
  call ol_merge_tensors(T0sum(177),[G0tensor(322)])
  call ol_merge_tensors(T0sum(178),[G0tensor(576)])
  call ol_merge_tensors(T0sum(179),[G0tensor(37)])
  call ol_merge_tensors(T0sum(180),[G0tensor(47)])
  call ol_merge_tensors(T0sum(181),[G0tensor(581)])
  call ol_merge_tensors(T0sum(182),[G0tensor(587)])
  call ol_merge_tensors(T0sum(183),[G0tensor(593)])
  call ol_merge_tensors(T0sum(184),[G0tensor(126)])
  call ol_merge_tensors(T0sum(185),[G0tensor(599)])
  call ol_merge_tensors(T0sum(186),[G0tensor(169)])
  call ol_merge_tensors(T0sum(187),[G0tensor(604)])
  call ol_merge_tensors(T0sum(188),[G0tensor(610)])
  call ol_merge_tensors(T0sum(189),[G0tensor(179)])
  call ol_merge_tensors(T0sum(190),[G0tensor(141)])
  call ol_merge_tensors(T0sum(191),[G0tensor(616)])
  call ol_merge_tensors(T0sum(192),[G0tensor(621)])
  call ol_merge_tensors(T0sum(193),[G0tensor(626)])
  call ol_merge_tensors(T0sum(194),[G0tensor(631)])
  call ol_merge_tensors(T0sum(195),[G0tensor(636)])
  call ol_merge_tensors(T0sum(196),[G0tensor(641)])
  call ol_merge_tensors(T0sum(197),[G0tensor(646)])
  call ol_merge_tensors(T0sum(198),[G0tensor(651)])
  call ol_merge_tensors(T0sum(199),[G0tensor(656)])
  call ol_merge_tensors(T0sum(200),[G0tensor(661)])
  call ol_merge_tensors(T0sum(201),[G0tensor(666)])
  call ol_merge_tensors(T0sum(202),[G0tensor(671)])
  call ol_merge_tensors(T0sum(203),[G0tensor(676)])
  call ol_merge_tensors(T0sum(204),[G0tensor(681)])
  call ol_merge_tensors(T0sum(205),[G0tensor(686)])
  call ol_merge_tensors(T0sum(206),[G0tensor(691)])
  call ol_merge_tensors(T0sum(207),[G0tensor(696)])
  call ol_merge_tensors(T0sum(208),[G0tensor(701)])
  call ol_merge_tensors(T0sum(209),[G0tensor(201)])
  call ol_merge_tensors(T0sum(210),[G0tensor(706)])
  call ol_merge_tensors(T0sum(211),[G0tensor(87)])
  call ol_merge_tensors(T0sum(212),[G0tensor(211)])
  call ol_merge_tensors(T0sum(213),[G0tensor(221)])
  call ol_merge_tensors(T0sum(214),[G0tensor(711)])
  call ol_merge_tensors(T0sum(215),[G0tensor(716)])
  call ol_merge_tensors(T0sum(216),[G0tensor(721)])
  call ol_merge_tensors(T0sum(217),[G0tensor(104)])
  call ol_merge_tensors(T0sum(218),[G0tensor(726)])
  call ol_merge_tensors(T0sum(219),[G0tensor(732)])
  call ol_merge_tensors(T0sum(220),[G0tensor(113)])
  call ol_merge_tensors(T0sum(221),[G0tensor(324)])
  call ol_merge_tensors(T0sum(222),[G0tensor(738)])
  call ol_merge_tensors(T0sum(223),[G0tensor(744)])
  call ol_merge_tensors(T0sum(224),[G0tensor(749)])
  call ol_merge_tensors(T0sum(225),[G0tensor(754)])
  call ol_merge_tensors(T0sum(226),[G0tensor(759)])
  call ol_merge_tensors(T0sum(227),[G0tensor(764)])
  call ol_merge_tensors(T0sum(228),[G0tensor(770)])
  call ol_merge_tensors(T0sum(229),[G0tensor(776)])
  call ol_merge_tensors(T0sum(230),[G0tensor(781)])
  call ol_merge_tensors(T0sum(231),[G0tensor(123)])
  call ol_merge_tensors(T0sum(232),[G0tensor(787)])
  call ol_merge_tensors(T0sum(233),[G0tensor(334)])
  call ol_merge_tensors(T0sum(234),[G0tensor(792)])
  call ol_merge_tensors(T0sum(235),[G0tensor(351)])
  call ol_merge_tensors(T0sum(236),[G0tensor(797)])
  call ol_merge_tensors(T0sum(237),[G0tensor(802)])
  call ol_merge_tensors(T0sum(238),[G0tensor(349)])
  call ol_merge_tensors(T0sum(239),[G0tensor(361)])
  call ol_merge_tensors(T0sum(240),[G0tensor(187)])
  call ol_merge_tensors(T1sum(21),[G1tensor(402)])
  call ol_merge_tensors(T1sum(22),[G1tensor(378)])
  call ol_merge_tensors(T1sum(23),[G1tensor(379)])
  call ol_merge_tensors(T1sum(24),[G1tensor(392)])
  call ol_merge_tensors(T1sum(25),[G1tensor(406)])
  call ol_merge_tensors(T1sum(26),[G1tensor(382)])
  call ol_merge_tensors(T1sum(27),[G1tensor(383)])
  call ol_merge_tensors(T1sum(28),[G1tensor(396)])
  call ol_merge_tensors(T1sum(29),[G1tensor(410)])
  call ol_merge_tensors(T1sum(30),[G1tensor(386)])
  call ol_merge_tensors(T1sum(31),[G1tensor(387)])
  call ol_merge_tensors(T1sum(32),[G1tensor(400)])
  call ol_merge_tensors(T1sum(33),[G1tensor(389)])
  call ol_merge_tensors(T1sum(34),[G1tensor(390)])
  call ol_merge_tensors(T1sum(35),[G1tensor(403)])
  call ol_merge_tensors(T1sum(36),[G1tensor(393)])
  call ol_merge_tensors(T1sum(37),[G1tensor(394)])
  call ol_merge_tensors(T1sum(38),[G1tensor(407)])
  call ol_merge_tensors(T1sum(39),[G1tensor(397)])
  call ol_merge_tensors(T1sum(40),[G1tensor(398)])
  call ol_merge_tensors(T1sum(41),[G1tensor(411)])
  call ol_merge_tensors(T1sum(42),[G1tensor(401)])
  call ol_merge_tensors(T1sum(43),[G1tensor(404)])
  call ol_merge_tensors(T1sum(44),[G1tensor(405)])
  call ol_merge_tensors(T1sum(45),[G1tensor(408)])
  call ol_merge_tensors(T1sum(46),[G1tensor(409)])
  call ol_merge_tensors(T1sum(47),[G1tensor(412)])
  call ol_merge_tensors(T0sum(241),[G0tensor(153)])
  call ol_merge_tensors(T0sum(242),[G0tensor(381)])
  call ol_merge_tensors(T0sum(243),[G0tensor(162)])
  call ol_merge_tensors(T0sum(244),[G0tensor(167)])
  call ol_merge_tensors(T0sum(245),[G0tensor(248)])
  call ol_merge_tensors(T0sum(246),[G0tensor(173)])
  call ol_merge_tensors(T0sum(247),[G0tensor(188)])
  call ol_merge_tensors(T0sum(248),[G0tensor(198)])
  call ol_merge_tensors(T0sum(249),[G0tensor(217)])
  call ol_merge_tensors(T0sum(250),[G0tensor(241)])
  call ol_merge_tensors(T0sum(251),[G0tensor(234)])
  call ol_merge_tensors(T0sum(252),[G0tensor(247)])
  call ol_merge_tensors(T0sum(253),[G0tensor(272)])
  call ol_merge_tensors(T0sum(254),[G0tensor(312)])
  call ol_merge_tensors(T0sum(255),[G0tensor(338)])
  call ol_merge_tensors(T0sum(256),[G0tensor(327)])
  call ol_merge_tensors(T0sum(257),[G0tensor(342)])
  call ol_merge_tensors(T0sum(258),[G0tensor(367)])
  call ol_merge_tensors(T0sum(259),[G0tensor(383)])
  call ol_merge_tensors(T0sum(260),[G0tensor(387)])
  call ol_merge_tensors(T0sum(261),[G0tensor(408)])
  call ol_merge_tensors(T0sum(262),[G0tensor(402)])
  call ol_merge_tensors(T0sum(263),[G0tensor(443)])
  call ol_merge_tensors(T0sum(264),[G0tensor(437)])
  call ol_merge_tensors(T0sum(265),[G0tensor(463)])
  call ol_merge_tensors(T0sum(266),[G0tensor(473)])
  call ol_merge_tensors(T0sum(267),[G0tensor(483)])
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1137),h0tab(:,1137),[16,15],[nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(42),m3h3x12(:,821),heltab2x36(:,:,1079))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1138),h0tab(:,1138),[16,15],[nMW,nMW],3,2,wf4(:,1),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(117),m3h3x12(:,822),heltab2x36(:,:,1080))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1139),h0tab(:,1139),[16,15],[nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,823),heltab2x36(:,:,1081))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1140),h0tab(:,1140),[16,15],[nMW,nMW],3,2,wf4(:,2),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,824),heltab2x36(:,:,1082))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1141),h0tab(:,1141),[16,15],[nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(301),m3h3x12(:,825),heltab2x36(:,:,1083))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1142),h0tab(:,1142),[16,15],[nMW,nMW],3,2,wf3(:,2),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(303),m3h3x12(:,826),heltab2x36(:,:,1084))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1143),h0tab(:,1143),[16,15],[nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(326),m3h3x12(:,827),heltab2x36(:,:,1085))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1144),h0tab(:,1144),[16,15],[nMW,nMW],3,2,wf3(:,2),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(327),m3h3x12(:,828),heltab2x36(:,:,1086))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1145),h0tab(:,1145),[28,3],[nMW,nMW],3,2,wf3(:,10),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf3(:,10),G0H4(1),m4h3x3x4(:,21),heltab3x36(:,:,59))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1146),h0tab(:,1146),[28,3],[nMW,nMW],3,2,wf3(:,10),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf3(:,10),G0H4(2),m4h3x3x4(:,22),heltab3x36(:,:,60))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1147),h0tab(:,1147),[28,3],[nMW,nMW],3,2,wf3(:,10),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf3(:,10),G0H4(4),m4h3x3x4(:,23),heltab3x36(:,:,61))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1148),h0tab(:,1148),[28,3],[nMW,nMW],3,2,wf3(:,10),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf3(:,10),G0H4(6),m4h3x3x4(:,24),heltab3x36(:,:,62))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1149),h0tab(:,1149),[28,3],[nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf3(:,2),G0H4(3),m4h3x3x4(:,25),heltab3x36(:,:,63))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1150),h0tab(:,1150),[28,3],[nMW,nMW],3,2,wf3(:,2),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf3(:,2),G0H4(5),m4h3x3x4(:,26),heltab3x36(:,:,64))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1151),h0tab(:,1151),[28,3],[nMW,nMW],3,2,wf3(:,2),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf3(:,2),G0H4(7),m4h3x3x4(:,27),heltab3x36(:,:,65))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1152),h0tab(:,1152),[28,3],[nMW,nMW],3,2,wf3(:,2),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf3(:,2),G0H4(8),m4h3x3x4(:,28),heltab3x36(:,:,66))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1153),h0tab(:,1153),[19,12],[nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(30),m4h3x4x3(:,17),heltab3x36(:,:,67))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1154),h0tab(:,1154),[19,12],[nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(29),m4h3x4x3(:,18),heltab3x36(:,:,68))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1155),h0tab(:,1155),[19,12],[nMW,nMW],3,2,wf4(:,1),wf3(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,1),G0H3(56),m4h3x4x3(:,19),heltab3x36(:,:,69))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1156),h0tab(:,1156),[19,12],[nMW,nMW],3,2,wf4(:,2),wf3(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,2),G0H3(53),m4h3x4x3(:,20),heltab3x36(:,:,70))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1157),h0tab(:,1157),[23,8],[nMW,nMW],3,2,wf4(:,1),wf3(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf3(:,5),G0H3(37),m4h4x3x3(:,1),heltab3x36(:,:,71))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1158),h0tab(:,1158),[23,8],[nMW,nMW],3,2,wf4(:,1),wf3(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf3(:,5),G0H3(34),m4h4x3x3(:,2),heltab3x36(:,:,72))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1159),h0tab(:,1159),[23,8],[nMW,nMW],3,2,wf4(:,2),wf3(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,2),wf3(:,5),G0H3(57),m4h4x3x3(:,3),heltab3x36(:,:,73))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1160),h0tab(:,1160),[23,8],[nMW,nMW],3,2,wf4(:,2),wf3(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,2),wf3(:,5),G0H3(54),m4h4x3x3(:,4),heltab3x36(:,:,74))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1161),h0tab(:,1161),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),wf3(:,1),wf4(:,1),G0H3(38),m4h3x4x3(:,21),heltab3x36(:,:,75))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1162),h0tab(:,1162),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),wf3(:,1),wf4(:,2),G0H3(35),m4h3x4x3(:,22),heltab3x36(:,:,76))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1163),h0tab(:,1163),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),wf3(:,1),wf4(:,1),G0H3(60),m4h3x4x3(:,23),heltab3x36(:,:,77))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1164),h0tab(:,1164),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),wf3(:,1),wf4(:,2),G0H3(58),m4h3x4x3(:,24),heltab3x36(:,:,78))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1165),h0tab(:,1165),[27,4],[nMW,nMW],3,2,wf4(:,1),wf9(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf9(:,1),G0H1(2),m4h4x9x1(:,1),heltab3x36(:,:,79))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1166),h0tab(:,1166),[27,4],[nMW,nMW],3,2,wf4(:,1),wf9(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,1),wf9(:,1),G0H1(1),m4h4x9x1(:,2),heltab3x36(:,:,80))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1167),h0tab(:,1167),[27,4],[nMW,nMW],3,2,wf4(:,2),wf9(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,2),wf9(:,1),G0H1(4),m4h4x9x1(:,3),heltab3x36(:,:,81))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1168),h0tab(:,1168),[27,4],[nMW,nMW],3,2,wf4(:,2),wf9(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),wf4(:,2),wf9(:,1),G0H1(3),m4h4x9x1(:,4),heltab3x36(:,:,82))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1169),h0tab(:,1169),[23,8],[nMW,nMW],3,1,wf4(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf4(:,3),G0H3(41),m4h3x4x3(:,25),heltab3x36(:,:,83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1170),h0tab(:,1170),[23,8],[nMW,nMW],3,1,wf4(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf4(:,3),G0H3(39),m4h3x4x3(:,26),heltab3x36(:,:,84))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1171),h0tab(:,1171),[23,8],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf4(:,4),G0H3(61),m4h3x4x3(:,27),heltab3x36(:,:,85))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1172),h0tab(:,1172),[23,8],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf4(:,4),G0H3(59),m4h3x4x3(:,28),heltab3x36(:,:,86))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1173),h0tab(:,1173),[27,4],[nMW,nMW],3,1,wf12(:,25))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf12(:,25),G0H1(5),m4h3x12x1(:,1),heltab3x36(:,:,87))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1174),h0tab(:,1174),[27,4],[nMW,nMW],3,1,wf12(:,25))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),wf12(:,25),G0H1(6),m4h3x12x1(:,2),heltab3x36(:,:,88))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1175),h0tab(:,1175),[28,3],[nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,5),G0H4(39),m4h3x3x4(:,29),heltab3x36(:,:,89))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1176),h0tab(:,1176),[28,3],[nMW,nMW],3,2,wf3(:,5),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,5),G0H4(10),m4h3x3x4(:,30),heltab3x36(:,:,90))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1177),h0tab(:,1177),[28,3],[nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,5),G0H4(9),m4h3x3x4(:,31),heltab3x36(:,:,91))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1178),h0tab(:,1178),[28,3],[nMW,nMW],3,2,wf3(:,5),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf3(:,5),G0H4(41),m4h3x3x4(:,32),heltab3x36(:,:,92))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1179),h0tab(:,1179),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf3(:,1),G0H4(12),m4h3x3x4(:,33),heltab3x36(:,:,93))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1180),h0tab(:,1180),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf3(:,1),G0H4(11),m4h3x3x4(:,34),heltab3x36(:,:,94))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1181),h0tab(:,1181),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf3(:,1),G0H4(43),m4h3x3x4(:,35),heltab3x36(:,:,95))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1182),h0tab(:,1182),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf3(:,1),G0H4(14),m4h3x3x4(:,36),heltab3x36(:,:,96))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1183),h0tab(:,1183),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(330),m3h3x12(:,829),heltab2x36(:,:,1087))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1184),h0tab(:,1184),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(331),m3h3x12(:,830),heltab2x36(:,:,1088))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1185),h0tab(:,1185),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(338),m3h3x12(:,831),heltab2x36(:,:,1089))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1186),h0tab(:,1186),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(341),m3h3x12(:,832),heltab2x36(:,:,1090))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1187),h0tab(:,1187),[16,15],[nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,833),heltab2x36(:,:,1091))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1188),h0tab(:,1188),[16,15],[nMW,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,834),heltab2x36(:,:,1092))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1189),h0tab(:,1189),[16,15],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(343),m3h3x12(:,835),heltab2x36(:,:,1093))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1190),h0tab(:,1190),[16,15],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(345),m3h3x12(:,836),heltab2x36(:,:,1094))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1191),h0tab(:,1191),[27,4],[nMW,nMW],3,1,wf12(:,26))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf12(:,26),G0H1(7),m4h3x12x1(:,3),heltab3x36(:,:,97))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1192),h0tab(:,1192),[27,4],[nMW,nMW],3,1,wf12(:,26))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf12(:,26),G0H1(8),m4h3x12x1(:,4),heltab3x36(:,:,98))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1193),h0tab(:,1193),[24,7],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(13),m4h3x3x4(:,37),heltab3x36(:,:,99))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1194),h0tab(:,1194),[24,7],[nMW,nMW],3,1,wf4(:,4))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(45),m4h3x3x4(:,38),heltab3x36(:,:,100))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1195),h0tab(:,1195),[28,3],[nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_SSS_S(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(16),m4h1x9x4(:,3),heltab3x36(:,:,101))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1196),h0tab(:,1196),[28,3],[nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_SSS_S(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(15),m4h1x9x4(:,4),heltab3x36(:,:,102))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1197),h0tab(:,1197),[28,3],[nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(54),m4h1x9x4(:,5),heltab3x36(:,:,103))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1198),h0tab(:,1198),[28,3],[nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf9(:,1),G0H4(52),m4h1x9x4(:,6),heltab3x36(:,:,104))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1199),h0tab(:,1199),[24,7],[nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(21),m3h9x4(:,73),heltab2x36(:,:,1095))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1200),h0tab(:,1200),[24,7],[nMW,nMW],3,2,wf9(:,1),wf4(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(23),m3h9x4(:,74),heltab2x36(:,:,1096))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1201),h0tab(:,1201),[24,7],[nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(33),m3h9x4(:,75),heltab2x36(:,:,1097))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1202),h0tab(:,1202),[24,7],[nMW,nMW],3,2,wf9(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(35),m3h9x4(:,76),heltab2x36(:,:,1098))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1203),h0tab(:,1203),[16,15],[nMW,nMW],3,1,wf12(:,25))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(347),m3h3x12(:,837),heltab2x36(:,:,1099))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1204),h0tab(:,1204),[16,15],[nMW,nMW],3,1,wf12(:,25))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(352),m3h3x12(:,838),heltab2x36(:,:,1100))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1205),h0tab(:,1205),[23,8],[nMW,nMW],3,1,wf12(:,26))
  call Hloop_SSS_S(ntryL,G0H36(1),ex3(:),wf12(:,26),G0H3(42),m4h1x12x3(:,1),heltab3x36(:,:,105))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1206),h0tab(:,1206),[23,8],[nMW,nMW],3,1,wf12(:,26))
  call Hloop_VSS_V(ntryL,G0H36(1),ex3(:),wf12(:,26),G0H3(40),m4h1x12x3(:,2),heltab3x36(:,:,106))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1207),h0tab(:,1207),[20,11],[nMW,nMW],3,1,wf12(:,25))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(18),m4h3x1x12(:,9),heltab3x36(:,:,107))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1208),h0tab(:,1208),[20,11],[nMW,nMW],3,1,wf12(:,25))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(99),m4h3x1x12(:,10),heltab3x36(:,:,108))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1209),h0tab(:,1209),[19,12],[nMW,nMW],3,1,wf12(:,26))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(29),m3h12x3(:,143),heltab2x36(:,:,1101))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1210),h0tab(:,1210),[19,12],[nMW,nMW],3,1,wf12(:,26))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(134),m3h12x3(:,144),heltab2x36(:,:,1102))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1211),h0tab(:,1211),[28,3],[nML,nML],2,2,wf9(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(50),ngH,m3h9x4(:,77),heltab2x36(:,:,1103))
  call Hloop_Q_A(ntryL,G0H4(50),28,nML,G1H4(9),n2h4(13))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1212),h0tab(:,1212),[28,3],[nMT,nMT],2,2,wf9(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(48),ngH,m3h9x4(:,78),heltab2x36(:,:,1104))
  call Hloop_Q_A(ntryL,G0H4(48),28,nMT,G1H4(10),n2h4(14))
  Gcoeff(:)%j = (-(c(145)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1213),h0tab(:,1213),[28,3],[nMB,nMB],2,2,wf9(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(22),ngH,m3h9x4(:,79),heltab2x36(:,:,1105))
  call Hloop_Q_A(ntryL,G0H4(22),28,nMB,G1H4(11),n2h4(15))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1214),h0tab(:,1214),[28,3],[nML,nML],2,2,wf9(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(20),ngH,m3h9x4(:,80),heltab2x36(:,:,1106))
  call Hloop_Q_A(ntryL,G0H4(20),28,nML,G1H4(12),n2h4(16))
  Gcoeff(:)%j = (c(163)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1215),h0tab(:,1215),[28,3],[nMT,nMT],2,2,wf9(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(18),ngH,m3h9x4(:,81),heltab2x36(:,:,1107))
  call Hloop_Q_A(ntryL,G0H4(18),28,nMT,G1H4(13),n2h4(17))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1216),h0tab(:,1216),[28,3],[nMB,nMB],2,2,wf9(:,2),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(17),ngH,m3h9x4(:,82),heltab2x36(:,:,1108))
  call Hloop_Q_A(ntryL,G0H4(17),28,nMB,G1H4(14),n2h4(18))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1217),h0tab(:,1217),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,2),G0H4(53),m3h9x4(:,83),heltab2x36(:,:,1109))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1218),h0tab(:,1218),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,2),G0H4(51),m3h9x4(:,84),heltab2x36(:,:,1110))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1219),h0tab(:,1219),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,2),G0H4(49),m3h9x4(:,85),heltab2x36(:,:,1111))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1220),h0tab(:,1220),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,2),G0H4(47),m3h9x4(:,86),heltab2x36(:,:,1112))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1221),h0tab(:,1221),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,2),G0H4(21),m3h9x4(:,87),heltab2x36(:,:,1113))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1222),h0tab(:,1222),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,2),G0H4(19),m3h9x4(:,88),heltab2x36(:,:,1114))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1223),h0tab(:,1223),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,2),G0H4(27),m3h9x4(:,89),heltab2x36(:,:,1115))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1224),h0tab(:,1224),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,2),G0H4(28),m3h9x4(:,90),heltab2x36(:,:,1116))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1225),h0tab(:,1225),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,2),28,G1H4(15),m3h9x4(:,91),heltab2x36(:,:,1117))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1226),h0tab(:,1226),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,2),28,G1H4(16),m3h9x4(:,92),heltab2x36(:,:,1118))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1227),h0tab(:,1227),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,2),28,G1H4(17),m3h9x4(:,93),heltab2x36(:,:,1119))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1228),h0tab(:,1228),[28,3],[nMW,nMW],2,2,wf9(:,2),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,2),28,G1H4(18),m3h9x4(:,94),heltab2x36(:,:,1120))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1229),h0tab(:,1229),[27,4],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,5),G0H1(9),m4h3x12x1(:,5),heltab3x36(:,:,109))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1230),h0tab(:,1230),[27,4],[nMH,nMH],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,1),G0H1(10),m4h3x12x1(:,6),heltab3x36(:,:,110))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1231),h0tab(:,1231),[27,4],[nMZ,nMZ],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,1),G0H1(11),m4h3x12x1(:,7),heltab3x36(:,:,111))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1232),h0tab(:,1232),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,1),G0H1(12),m4h3x12x1(:,8),heltab3x36(:,:,112))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1233),h0tab(:,1233),[27,4],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,5),G0H1(13),m4h3x12x1(:,9),heltab3x36(:,:,113))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1234),h0tab(:,1234),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,1),G0H1(14),m4h3x12x1(:,10),heltab3x36(:,:,114))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1235),h0tab(:,1235),[27,4],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,6),G0H1(15),m4h3x12x1(:,11),heltab3x36(:,:,115))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1236),h0tab(:,1236),[27,4],[nMH,nMH],3,1,wf12(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,2),G0H1(16),m4h3x12x1(:,12),heltab3x36(:,:,116))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1237),h0tab(:,1237),[27,4],[nMZ,nMZ],3,1,wf12(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,2),G0H1(17),m4h3x12x1(:,13),heltab3x36(:,:,117))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1238),h0tab(:,1238),[27,4],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),wf12(:,2),G0H1(18),m4h3x12x1(:,14),heltab3x36(:,:,118))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1239),h0tab(:,1239),[27,4],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,6),G0H1(19),m4h3x12x1(:,15),heltab3x36(:,:,119))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1240),h0tab(:,1240),[27,4],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VWW_V(ntryL,G0H36(1),ex5(:),wf12(:,2),G0H1(20),m4h3x12x1(:,16),heltab3x36(:,:,120))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1241),h0tab(:,1241),[27,4],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,7),G0H1(21),m4h3x12x1(:,17),heltab3x36(:,:,121))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1242),h0tab(:,1242),[27,4],[nMH,nMH],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,3),G0H1(22),m4h3x12x1(:,18),heltab3x36(:,:,122))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1243),h0tab(:,1243),[27,4],[nMZ,nMZ],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,3),G0H1(23),m4h3x12x1(:,19),heltab3x36(:,:,123))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1244),h0tab(:,1244),[27,4],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,3),G0H1(24),m4h3x12x1(:,20),heltab3x36(:,:,124))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1245),h0tab(:,1245),[27,4],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,7),G0H1(25),m4h3x12x1(:,21),heltab3x36(:,:,125))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1246),h0tab(:,1246),[27,4],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,3),G0H1(26),m4h3x12x1(:,22),heltab3x36(:,:,126))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1247),h0tab(:,1247),[27,4],[nMW,nMW],3,1,wf12(:,8))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,8),G0H1(27),m4h3x12x1(:,23),heltab3x36(:,:,127))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1248),h0tab(:,1248),[27,4],[nMH,nMH],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,4),G0H1(28),m4h3x12x1(:,24),heltab3x36(:,:,128))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1249),h0tab(:,1249),[27,4],[nMZ,nMZ],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,4),G0H1(29),m4h3x12x1(:,25),heltab3x36(:,:,129))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1250),h0tab(:,1250),[27,4],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf12(:,4),G0H1(30),m4h3x12x1(:,26),heltab3x36(:,:,130))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1251),h0tab(:,1251),[27,4],[nMW,nMW],3,1,wf12(:,8))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,8),G0H1(31),m4h3x12x1(:,27),heltab3x36(:,:,131))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1252),h0tab(:,1252),[27,4],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf12(:,4),G0H1(32),m4h3x12x1(:,28),heltab3x36(:,:,132))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1253),h0tab(:,1253),[16,15],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(32),m3h3x12(:,839),heltab2x36(:,:,1121))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1254),h0tab(:,1254),[16,15],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(100),m3h3x12(:,840),heltab2x36(:,:,1122))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1255),h0tab(:,1255),[16,15],[nMZ,nMH],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(33),m3h3x12(:,841),heltab2x36(:,:,1123))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1256),h0tab(:,1256),[16,15],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(101),m3h3x12(:,842),heltab2x36(:,:,1124))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1257),h0tab(:,1257),[16,15],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(34),m3h3x12(:,843),heltab2x36(:,:,1125))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1258),h0tab(:,1258),[20,11],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(102),m4h3x1x12(:,11),heltab3x36(:,:,133))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1259),h0tab(:,1259),[20,11],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(35),m4h3x1x12(:,12),heltab3x36(:,:,134))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1260),h0tab(:,1260),[20,11],[nMH,nMZ],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(4),m4h3x1x12(:,13),heltab3x36(:,:,135))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1261),h0tab(:,1261),[20,11],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(44),m4h3x1x12(:,14),heltab3x36(:,:,136))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1262),h0tab(:,1262),[20,11],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(118),m4h3x1x12(:,15),heltab3x36(:,:,137))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1263),h0tab(:,1263),[16,15],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(45),m3h3x12(:,844),heltab2x36(:,:,1126))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1264),h0tab(:,1264),[16,15],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,845),heltab2x36(:,:,1127))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1265),h0tab(:,1265),[16,15],[nMZ,nMH],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(46),m3h3x12(:,846),heltab2x36(:,:,1128))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1266),h0tab(:,1266),[16,15],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,847),heltab2x36(:,:,1129))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1267),h0tab(:,1267),[16,15],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(47),m3h3x12(:,848),heltab2x36(:,:,1130))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1268),h0tab(:,1268),[20,11],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(10),m4h3x1x12(:,16),heltab3x36(:,:,138))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1269),h0tab(:,1269),[20,11],[nMW,nMW],3,1,wf12(:,6))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(8),m4h3x1x12(:,17),heltab3x36(:,:,139))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1270),h0tab(:,1270),[20,11],[nMH,nMZ],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(11),m4h3x1x12(:,18),heltab3x36(:,:,140))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1271),h0tab(:,1271),[20,11],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(9),m4h3x1x12(:,19),heltab3x36(:,:,141))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1272),h0tab(:,1272),[20,11],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H12(3),m4h3x1x12(:,20),heltab3x36(:,:,142))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1273),h0tab(:,1273),[23,8],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,7),ex3(:),G0H3(66),m4h12x1x3(:,1),heltab3x36(:,:,143))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1274),h0tab(:,1274),[23,8],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,7),ex3(:),G0H3(65),m4h12x1x3(:,2),heltab3x36(:,:,144))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1275),h0tab(:,1275),[23,8],[nMH,nMZ],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,3),ex3(:),G0H3(63),m4h12x1x3(:,3),heltab3x36(:,:,145))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1276),h0tab(:,1276),[23,8],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,3),ex3(:),G0H3(62),m4h12x1x3(:,4),heltab3x36(:,:,146))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1277),h0tab(:,1277),[23,8],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,3),ex3(:),G0H3(47),m4h12x1x3(:,5),heltab3x36(:,:,147))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1278),h0tab(:,1278),[23,8],[nMW,nMW],3,1,wf12(:,8))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,8),ex3(:),G0H3(46),m4h12x1x3(:,6),heltab3x36(:,:,148))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1279),h0tab(:,1279),[23,8],[nMW,nMW],3,1,wf12(:,8))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,8),ex3(:),G0H3(44),m4h12x1x3(:,7),heltab3x36(:,:,149))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1280),h0tab(:,1280),[23,8],[nMH,nMZ],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,4),ex3(:),G0H3(43),m4h12x1x3(:,8),heltab3x36(:,:,150))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1281),h0tab(:,1281),[23,8],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,4),ex3(:),G0H3(31),m4h12x1x3(:,9),heltab3x36(:,:,151))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1282),h0tab(:,1282),[23,8],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H36(1),wf12(:,4),ex3(:),G0H3(36),m4h12x1x3(:,10),heltab3x36(:,:,152))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1283),h0tab(:,1283),[19,12],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(45),m3h12x3(:,145),heltab2x36(:,:,1131))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1284),h0tab(:,1284),[19,12],[nMW,nMW],3,1,wf12(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(4),m3h12x3(:,146),heltab2x36(:,:,1132))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1285),h0tab(:,1285),[19,12],[nMZ,nMH],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(10),m3h12x3(:,147),heltab2x36(:,:,1133))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1286),h0tab(:,1286),[19,12],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(21),m3h12x3(:,148),heltab2x36(:,:,1134))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1287),h0tab(:,1287),[19,12],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(23),m3h12x3(:,149),heltab2x36(:,:,1135))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1288),h0tab(:,1288),[19,12],[nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(18),m3h12x3(:,150),heltab2x36(:,:,1136))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1289),h0tab(:,1289),[19,12],[nMW,nMW],3,1,wf12(:,8))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(15),m3h12x3(:,151),heltab2x36(:,:,1137))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1290),h0tab(:,1290),[19,12],[nMZ,nMH],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(50),m3h12x3(:,152),heltab2x36(:,:,1138))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1291),h0tab(:,1291),[19,12],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(55),m3h12x3(:,153),heltab2x36(:,:,1139))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1292),h0tab(:,1292),[19,12],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(64),m3h12x3(:,154),heltab2x36(:,:,1140))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1293),h0tab(:,1293),[19,12],[nML,nML],2,2,wf12(:,26),wf3(:,10))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(52),ngH,m3h12x3(:,155),heltab2x36(:,:,1141))
  call Hloop_Q_A(ntryL,G0H3(52),19,nML,G1H3(82),n2h3(273))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1294),h0tab(:,1294),[19,12],[nMT,nMT],2,2,wf12(:,26),wf3(:,10))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(51),ngH,m3h12x3(:,156),heltab2x36(:,:,1142))
  call Hloop_Q_A(ntryL,G0H3(51),19,nMT,G1H3(166),n2h3(274))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1295),h0tab(:,1295),[19,12],[nMB,nMB],2,2,wf12(:,26),wf3(:,10))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(49),ngH,m3h12x3(:,157),heltab2x36(:,:,1143))
  call Hloop_Q_A(ntryL,G0H3(49),19,nMB,G1H3(158),n2h3(275))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1296),h0tab(:,1296),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,10))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(48),m3h12x3(:,158),heltab2x36(:,:,1144))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1297),h0tab(:,1297),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,10))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(33),m3h12x3(:,159),heltab2x36(:,:,1145))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1298),h0tab(:,1298),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,10))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(37),m3h12x3(:,160),heltab2x36(:,:,1146))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1299),h0tab(:,1299),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,10))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(64),m3h12x3(:,161),heltab2x36(:,:,1147))
  Gcoeff(:)%j = (c(171)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1300),h0tab(:,1300),[19,12],[nML,nML],2,2,wf12(:,26),wf3(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(32),ngH,m3h12x3(:,162),heltab2x36(:,:,1148))
  call Hloop_Q_A(ntryL,G0H3(32),19,nML,G1H3(77),n2h3(276))
  Gcoeff(:)%j = (c(173)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1301),h0tab(:,1301),[19,12],[nMT,nMT],2,2,wf12(:,26),wf3(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(2),ngH,m3h12x3(:,163),heltab2x36(:,:,1149))
  call Hloop_Q_A(ntryL,G0H3(2),19,nMT,G1H3(36),n2h3(277))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1302),h0tab(:,1302),[19,12],[nMB,nMB],2,2,wf12(:,26),wf3(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf12(:,26),G0H3(25),ngH,m3h12x3(:,164),heltab2x36(:,:,1150))
  call Hloop_Q_A(ntryL,G0H3(25),19,nMB,G1H3(12),n2h3(278))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1303),h0tab(:,1303),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(20),m3h12x3(:,165),heltab2x36(:,:,1151))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1304),h0tab(:,1304),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(14),m3h12x3(:,166),heltab2x36(:,:,1152))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1305),h0tab(:,1305),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf12(:,26),G0H3(5),m3h12x3(:,167),heltab2x36(:,:,1153))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1306),h0tab(:,1306),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf12(:,26),G0H3(28),m3h12x3(:,168),heltab2x36(:,:,1154))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1307),h0tab(:,1307),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(95),m3h12x3(:,169),heltab2x36(:,:,1155))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1308),h0tab(:,1308),[19,12],[nMW,nMW],2,2,wf12(:,26),wf3(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf12(:,26),19,G1H3(90),m3h12x3(:,170),heltab2x36(:,:,1156))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1309),h0tab(:,1309),[28,3],[nML,nML],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(31),ngH,m3h9x4(:,95),heltab2x36(:,:,1157))
  call Hloop_Q_A(ntryL,G0H4(31),28,nML,G1H4(19),n2h4(19))
  Gcoeff(:)%j = (c(160)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1310),h0tab(:,1310),[28,3],[nMT,nMT],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(32),ngH,m3h9x4(:,96),heltab2x36(:,:,1158))
  call Hloop_Q_A(ntryL,G0H4(32),28,nMT,G1H4(20),n2h4(20))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1311),h0tab(:,1311),[28,3],[nMB,nMB],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(23),ngH,m3h9x4(:,97),heltab2x36(:,:,1159))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(22),n2h4(21))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1312),h0tab(:,1312),[28,3],[nML,nML],2,2,wf9(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(24),ngH,m3h9x4(:,98),heltab2x36(:,:,1160))
  call Hloop_Q_A(ntryL,G0H4(24),28,nML,G1H4(24),n2h4(22))
  Gcoeff(:)%j = (c(162)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1313),h0tab(:,1313),[28,3],[nMT,nMT],2,2,wf9(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(25),ngH,m3h9x4(:,99),heltab2x36(:,:,1161))
  call Hloop_Q_A(ntryL,G0H4(25),28,nMT,G1H4(25),n2h4(23))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1314),h0tab(:,1314),[28,3],[nMB,nMB],2,2,wf9(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(26),ngH,m3h9x4(:,100),heltab2x36(:,:,1162))
  call Hloop_Q_A(ntryL,G0H4(26),28,nMB,G1H4(26),n2h4(24))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1315),h0tab(:,1315),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(35),m3h9x4(:,101),heltab2x36(:,:,1163))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1316),h0tab(:,1316),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(36),m3h9x4(:,102),heltab2x36(:,:,1164))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1317),h0tab(:,1317),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(37),m3h9x4(:,103),heltab2x36(:,:,1165))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1318),h0tab(:,1318),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(38),m3h9x4(:,104),heltab2x36(:,:,1166))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1319),h0tab(:,1319),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(40),m3h9x4(:,105),heltab2x36(:,:,1167))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1320),h0tab(:,1320),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(42),m3h9x4(:,106),heltab2x36(:,:,1168))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1321),h0tab(:,1321),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(44),m3h9x4(:,107),heltab2x36(:,:,1169))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1322),h0tab(:,1322),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(46),m3h9x4(:,108),heltab2x36(:,:,1170))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1323),h0tab(:,1323),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(27),m3h9x4(:,109),heltab2x36(:,:,1171))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1324),h0tab(:,1324),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(28),m3h9x4(:,110),heltab2x36(:,:,1172))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1325),h0tab(:,1325),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(29),m3h9x4(:,111),heltab2x36(:,:,1173))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1326),h0tab(:,1326),[28,3],[nMW,nMW],2,2,wf9(:,3),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,3),28,G1H4(30),m3h9x4(:,112),heltab2x36(:,:,1174))
  Gcoeff(:)%j = (-(c(170)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1327),h0tab(:,1327),[28,3],[nML,nML],2,2,wf9(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,4),G0H4(56),ngH,m3h9x4(:,113),heltab2x36(:,:,1175))
  call Hloop_Q_A(ntryL,G0H4(56),28,nML,G1H4(31),n2h4(25))
  Gcoeff(:)%j = (c(172)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1328),h0tab(:,1328),[28,3],[nMT,nMT],2,2,wf9(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,4),G0H4(55),ngH,m3h9x4(:,114),heltab2x36(:,:,1176))
  call Hloop_Q_A(ntryL,G0H4(55),28,nMT,G1H4(32),n2h4(26))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1329),h0tab(:,1329),[28,3],[nMB,nMB],2,2,wf9(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,4),G0H4(29),ngH,m3h9x4(:,115),heltab2x36(:,:,1177))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(34),n2h4(27))
  Gcoeff(:)%j = (c(171)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1330),h0tab(:,1330),[28,3],[nML,nML],2,2,wf9(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,4),G0H4(30),ngH,m3h9x4(:,116),heltab2x36(:,:,1178))
  call Hloop_Q_A(ntryL,G0H4(30),28,nML,G1H4(36),n2h4(28))
  Gcoeff(:)%j = (c(173)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1331),h0tab(:,1331),[28,3],[nMT,nMT],2,2,wf9(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,4),G0H4(33),ngH,m3h9x4(:,117),heltab2x36(:,:,1179))
  call Hloop_Q_A(ntryL,G0H4(33),28,nMT,G1H4(5),n2h4(29))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1332),h0tab(:,1332),[28,3],[nMB,nMB],2,2,wf9(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,4),G0H4(34),ngH,m3h9x4(:,118),heltab2x36(:,:,1180))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMB,G1H4(6),n2h4(30))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1333),h0tab(:,1333),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,4),G0H4(50),m3h9x4(:,119),heltab2x36(:,:,1181))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1334),h0tab(:,1334),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,4),G0H4(48),m3h9x4(:,120),heltab2x36(:,:,1182))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1335),h0tab(:,1335),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,4),G0H4(22),m3h9x4(:,121),heltab2x36(:,:,1183))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1336),h0tab(:,1336),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,4),G0H4(20),m3h9x4(:,122),heltab2x36(:,:,1184))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1337),h0tab(:,1337),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,4),G0H4(18),m3h9x4(:,123),heltab2x36(:,:,1185))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1338),h0tab(:,1338),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,4),G0H4(17),m3h9x4(:,124),heltab2x36(:,:,1186))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1339),h0tab(:,1339),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,4),G0H4(31),m3h9x4(:,125),heltab2x36(:,:,1187))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1340),h0tab(:,1340),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,4),G0H4(32),m3h9x4(:,126),heltab2x36(:,:,1188))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1341),h0tab(:,1341),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,4),28,G1H4(7),m3h9x4(:,127),heltab2x36(:,:,1189))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1342),h0tab(:,1342),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,4),28,G1H4(8),m3h9x4(:,128),heltab2x36(:,:,1190))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1343),h0tab(:,1343),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,4),28,G1H4(1),m3h9x4(:,129),heltab2x36(:,:,1191))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1344),h0tab(:,1344),[28,3],[nMW,nMW],2,2,wf9(:,4),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,4),28,G1H4(2),m3h9x4(:,130),heltab2x36(:,:,1192))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1345),h0tab(:,1345),[20,11],[nML,nML],2,2,wf3(:,5),wf12(:,25))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(1),ngX,m3h3x12(:,849),heltab2x36(:,:,1193))
  call Hloop_Q_A(ntryL,G0H12(1),20,nML,G1H12(65),n2h12(275))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1346),h0tab(:,1346),[20,11],[nMT,nMT],2,2,wf3(:,5),wf12(:,25))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(60),ngX,m3h3x12(:,850),heltab2x36(:,:,1194))
  call Hloop_Q_A(ntryL,G0H12(60),20,nMT,G1H12(67),n2h12(276))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1347),h0tab(:,1347),[20,11],[nMB,nMB],2,2,wf3(:,5),wf12(:,25))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(2),ngX,m3h3x12(:,851),heltab2x36(:,:,1195))
  call Hloop_Q_A(ntryL,G0H12(2),20,nMB,G1H12(70),n2h12(277))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1348),h0tab(:,1348),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,25))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(89),m3h3x12(:,852),heltab2x36(:,:,1196))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1349),h0tab(:,1349),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,25))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(65),m3h3x12(:,853),heltab2x36(:,:,1197))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1350),h0tab(:,1350),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,25))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(72),m3h3x12(:,854),heltab2x36(:,:,1198))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1351),h0tab(:,1351),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,25))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(79),m3h3x12(:,855),heltab2x36(:,:,1199))
  Gcoeff(:)%j = (c(171)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1352),h0tab(:,1352),[20,11],[nML,nML],2,2,wf3(:,1),wf12(:,25))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(67),ngZl,m3h3x12(:,856),heltab2x36(:,:,1200))
  call Hloop_Q_A(ntryL,G0H12(67),20,nML,G1H12(81),n2h12(278))
  Gcoeff(:)%j = (c(173)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1353),h0tab(:,1353),[20,11],[nMT,nMT],2,2,wf3(:,1),wf12(:,25))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(69),ngZu,m3h3x12(:,857),heltab2x36(:,:,1201))
  call Hloop_Q_A(ntryL,G0H12(69),20,nMT,G1H12(86),n2h12(279))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1354),h0tab(:,1354),[20,11],[nMB,nMB],2,2,wf3(:,1),wf12(:,25))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(82),ngZd,m3h3x12(:,858),heltab2x36(:,:,1202))
  call Hloop_Q_A(ntryL,G0H12(82),20,nMB,G1H12(89),n2h12(280))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1355),h0tab(:,1355),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,25))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(91),m3h3x12(:,859),heltab2x36(:,:,1203))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1356),h0tab(:,1356),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,25))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(96),m3h3x12(:,860),heltab2x36(:,:,1204))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1357),h0tab(:,1357),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,25))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(100),m3h3x12(:,861),heltab2x36(:,:,1205))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1358),h0tab(:,1358),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,25))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(103),m3h3x12(:,862),heltab2x36(:,:,1206))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1359),h0tab(:,1359),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,25))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(86),m3h3x12(:,863),heltab2x36(:,:,1207))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1360),h0tab(:,1360),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,25))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,1),G0H12(123),m3h3x12(:,864),heltab2x36(:,:,1208))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1361),h0tab(:,1361),[28,3],[nML,nML],2,2,wf9(:,5),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,5),G0H4(23),ngH,m3h9x4(:,131),heltab2x36(:,:,1209))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(3),n2h4(31))
  Gcoeff(:)%j = (c(160)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1362),h0tab(:,1362),[28,3],[nMT,nMT],2,2,wf9(:,5),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,5),G0H4(24),ngH,m3h9x4(:,132),heltab2x36(:,:,1210))
  call Hloop_Q_A(ntryL,G0H4(24),28,nMT,G1H4(4),n2h4(32))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1363),h0tab(:,1363),[28,3],[nMB,nMB],2,2,wf9(:,5),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,5),G0H4(25),ngH,m3h9x4(:,133),heltab2x36(:,:,1211))
  call Hloop_Q_A(ntryL,G0H4(25),28,nMB,G1H4(37),n2h4(33))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1364),h0tab(:,1364),[28,3],[nML,nML],2,2,wf9(:,5),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,5),G0H4(26),ngH,m3h9x4(:,134),heltab2x36(:,:,1212))
  call Hloop_Q_A(ntryL,G0H4(26),28,nML,G1H4(38),n2h4(34))
  Gcoeff(:)%j = (c(162)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1365),h0tab(:,1365),[28,3],[nMT,nMT],2,2,wf9(:,5),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,5),G0H4(56),ngH,m3h9x4(:,135),heltab2x36(:,:,1213))
  call Hloop_Q_A(ntryL,G0H4(56),28,nMT,G1H4(39),n2h4(35))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1366),h0tab(:,1366),[28,3],[nMB,nMB],2,2,wf9(:,5),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,5),G0H4(55),ngH,m3h9x4(:,136),heltab2x36(:,:,1214))
  call Hloop_Q_A(ntryL,G0H4(55),28,nMB,G1H4(40),n2h4(36))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1367),h0tab(:,1367),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,5),G0H4(29),m3h9x4(:,137),heltab2x36(:,:,1215))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1368),h0tab(:,1368),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,5),G0H4(30),m3h9x4(:,138),heltab2x36(:,:,1216))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1369),h0tab(:,1369),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,5),G0H4(33),m3h9x4(:,139),heltab2x36(:,:,1217))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1370),h0tab(:,1370),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,5),G0H4(34),m3h9x4(:,140),heltab2x36(:,:,1218))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1371),h0tab(:,1371),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,5),G0H4(23),m3h9x4(:,141),heltab2x36(:,:,1219))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1372),h0tab(:,1372),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,5),G0H4(24),m3h9x4(:,142),heltab2x36(:,:,1220))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1373),h0tab(:,1373),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,5),G0H4(25),m3h9x4(:,143),heltab2x36(:,:,1221))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1374),h0tab(:,1374),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,5),G0H4(26),m3h9x4(:,144),heltab2x36(:,:,1222))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1375),h0tab(:,1375),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,5),28,G1H4(41),m3h9x4(:,145),heltab2x36(:,:,1223))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1376),h0tab(:,1376),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,5),28,G1H4(42),m3h9x4(:,146),heltab2x36(:,:,1224))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1377),h0tab(:,1377),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,5),28,G1H4(43),m3h9x4(:,147),heltab2x36(:,:,1225))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1378),h0tab(:,1378),[28,3],[nMW,nMW],2,2,wf9(:,5),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,5),28,G1H4(44),m3h9x4(:,148),heltab2x36(:,:,1226))
  Gcoeff(:)%j = (-(c(170)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1379),h0tab(:,1379),[28,3],[nML,nML],2,2,wf9(:,6),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(56),ngH,m3h9x4(:,149),heltab2x36(:,:,1227))
  call Hloop_Q_A(ntryL,G0H4(56),28,nML,G1H4(45),n2h4(37))
  Gcoeff(:)%j = (c(172)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1380),h0tab(:,1380),[28,3],[nMT,nMT],2,2,wf9(:,6),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(55),ngH,m3h9x4(:,150),heltab2x36(:,:,1228))
  call Hloop_Q_A(ntryL,G0H4(55),28,nMT,G1H4(46),n2h4(38))
  Gcoeff(:)%j = (-(c(168)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1381),h0tab(:,1381),[28,3],[nMB,nMB],2,2,wf9(:,6),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(56),ngH,m3h9x4(:,151),heltab2x36(:,:,1229))
  call Hloop_Q_A(ntryL,G0H4(56),28,nMB,G1H4(47),n2h4(39))
  Gcoeff(:)%j = (c(171)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1382),h0tab(:,1382),[28,3],[nML,nML],2,2,wf9(:,6),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(55),ngH,m3h9x4(:,152),heltab2x36(:,:,1230))
  call Hloop_Q_A(ntryL,G0H4(55),28,nML,G1H4(48),n2h4(40))
  Gcoeff(:)%j = (c(173)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1383),h0tab(:,1383),[28,3],[nMT,nMT],2,2,wf9(:,6),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(56),ngH,m3h9x4(:,153),heltab2x36(:,:,1231))
  call Hloop_Q_A(ntryL,G0H4(56),28,nMT,G1H4(49),n2h4(41))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1384),h0tab(:,1384),[28,3],[nMB,nMB],2,2,wf9(:,6),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(55),ngH,m3h9x4(:,154),heltab2x36(:,:,1232))
  call Hloop_Q_A(ntryL,G0H4(55),28,nMB,G1H4(50),n2h4(42))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1385),h0tab(:,1385),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(56),m3h9x4(:,155),heltab2x36(:,:,1233))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1386),h0tab(:,1386),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(55),m3h9x4(:,156),heltab2x36(:,:,1234))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1387),h0tab(:,1387),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(57),m3h9x4(:,157),heltab2x36(:,:,1235))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1388),h0tab(:,1388),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(58),m3h9x4(:,158),heltab2x36(:,:,1236))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1389),h0tab(:,1389),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(59),m3h9x4(:,159),heltab2x36(:,:,1237))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1390),h0tab(:,1390),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(60),m3h9x4(:,160),heltab2x36(:,:,1238))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1391),h0tab(:,1391),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(61),m3h9x4(:,161),heltab2x36(:,:,1239))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1392),h0tab(:,1392),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(62),m3h9x4(:,162),heltab2x36(:,:,1240))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1393),h0tab(:,1393),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(51),m3h9x4(:,163),heltab2x36(:,:,1241))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1394),h0tab(:,1394),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(52),m3h9x4(:,164),heltab2x36(:,:,1242))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1395),h0tab(:,1395),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(53),m3h9x4(:,165),heltab2x36(:,:,1243))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1396),h0tab(:,1396),[28,3],[nMW,nMW],2,2,wf9(:,6),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),28,G1H4(54),m3h9x4(:,166),heltab2x36(:,:,1244))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1397),h0tab(:,1397),[24,7],[nML,nML],2,2,wf9(:,1),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(63),ngH,m3h9x4(:,167),heltab2x36(:,:,1245))
  call Hloop_Q_A(ntryL,G0H4(63),24,nML,G1H4(55),n2h4(43))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1398),h0tab(:,1398),[24,7],[nMT,nMT],2,2,wf9(:,1),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(63),ngH,m3h9x4(:,168),heltab2x36(:,:,1246))
  call Hloop_Q_A(ntryL,G0H4(63),24,nMT,G1H4(56),n2h4(44))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1399),h0tab(:,1399),[24,7],[nMB,nMB],2,2,wf9(:,1),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(63),ngH,m3h9x4(:,169),heltab2x36(:,:,1247))
  call Hloop_Q_A(ntryL,G0H4(63),24,nMB,G1H4(57),n2h4(45))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1400),h0tab(:,1400),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(63),m3h9x4(:,170),heltab2x36(:,:,1248))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1401),h0tab(:,1401),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(64),m3h9x4(:,171),heltab2x36(:,:,1249))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1402),h0tab(:,1402),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(58),m3h9x4(:,172),heltab2x36(:,:,1250))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1403),h0tab(:,1403),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(59),m3h9x4(:,173),heltab2x36(:,:,1251))
  Gcoeff(:)%j = (c(171)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1404),h0tab(:,1404),[24,7],[nML,nML],2,2,wf9(:,1),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(65),ngH,m3h9x4(:,174),heltab2x36(:,:,1252))
  call Hloop_Q_A(ntryL,G0H4(65),24,nML,G1H4(60),n2h4(46))
  Gcoeff(:)%j = (c(173)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1405),h0tab(:,1405),[24,7],[nMT,nMT],2,2,wf9(:,1),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(65),ngH,m3h9x4(:,175),heltab2x36(:,:,1253))
  call Hloop_Q_A(ntryL,G0H4(65),24,nMT,G1H4(61),n2h4(47))
  Gcoeff(:)%j = (c(169)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1406),h0tab(:,1406),[24,7],[nMB,nMB],2,2,wf9(:,1),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,1),G0H4(65),ngH,m3h9x4(:,176),heltab2x36(:,:,1254))
  call Hloop_Q_A(ntryL,G0H4(65),24,nMB,G1H4(62),n2h4(48))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1407),h0tab(:,1407),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(65),m3h9x4(:,177),heltab2x36(:,:,1255))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1408),h0tab(:,1408),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(66),m3h9x4(:,178),heltab2x36(:,:,1256))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1409),h0tab(:,1409),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(67),m3h9x4(:,179),heltab2x36(:,:,1257))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1410),h0tab(:,1410),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(68),m3h9x4(:,180),heltab2x36(:,:,1258))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1411),h0tab(:,1411),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(63),m3h9x4(:,181),heltab2x36(:,:,1259))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1412),h0tab(:,1412),[24,7],[nMW,nMW],2,2,wf9(:,1),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),24,G1H4(64),m3h9x4(:,182),heltab2x36(:,:,1260))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1413),h0tab(:,1413),[28,3],[nML,nML],2,2,wf9(:,7),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngH,m3h9x4(:,183),heltab2x36(:,:,1261))
  call Hloop_Q_A(ntryL,G0H4(69),28,nML,G1H4(65),n2h4(49))
  Gcoeff(:)%j = (c(164)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1414),h0tab(:,1414),[28,3],[nMT,nMT],2,2,wf9(:,7),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngH,m3h9x4(:,184),heltab2x36(:,:,1262))
  call Hloop_Q_A(ntryL,G0H4(69),28,nMT,G1H4(66),n2h4(50))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1415),h0tab(:,1415),[28,3],[nMB,nMB],2,2,wf9(:,7),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngH,m3h9x4(:,185),heltab2x36(:,:,1263))
  call Hloop_Q_A(ntryL,G0H4(69),28,nMB,G1H4(67),n2h4(51))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1416),h0tab(:,1416),[28,3],[nML,nML],2,2,wf9(:,7),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngH,m3h9x4(:,186),heltab2x36(:,:,1264))
  call Hloop_Q_A(ntryL,G0H4(69),28,nML,G1H4(68),n2h4(52))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1417),h0tab(:,1417),[28,3],[nMT,nMT],2,2,wf9(:,7),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngH,m3h9x4(:,187),heltab2x36(:,:,1265))
  call Hloop_Q_A(ntryL,G0H4(69),28,nMT,G1H4(69),n2h4(53))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1418),h0tab(:,1418),[28,3],[nMB,nMB],2,2,wf9(:,7),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngH,m3h9x4(:,188),heltab2x36(:,:,1266))
  call Hloop_Q_A(ntryL,G0H4(69),28,nMB,G1H4(70),n2h4(54))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1419),h0tab(:,1419),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,189),heltab2x36(:,:,1267))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1420),h0tab(:,1420),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(70),m3h9x4(:,190),heltab2x36(:,:,1268))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1421),h0tab(:,1421),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(71),m3h9x4(:,191),heltab2x36(:,:,1269))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1422),h0tab(:,1422),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(72),m3h9x4(:,192),heltab2x36(:,:,1270))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1423),h0tab(:,1423),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(73),m3h9x4(:,193),heltab2x36(:,:,1271))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1424),h0tab(:,1424),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,7),G0H4(74),m3h9x4(:,194),heltab2x36(:,:,1272))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1425),h0tab(:,1425),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(75),m3h9x4(:,195),heltab2x36(:,:,1273))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1426),h0tab(:,1426),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,7),G0H4(76),m3h9x4(:,196),heltab2x36(:,:,1274))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1427),h0tab(:,1427),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(71),m3h9x4(:,197),heltab2x36(:,:,1275))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1428),h0tab(:,1428),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(72),m3h9x4(:,198),heltab2x36(:,:,1276))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1429),h0tab(:,1429),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(73),m3h9x4(:,199),heltab2x36(:,:,1277))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1430),h0tab(:,1430),[28,3],[nMW,nMW],2,2,wf9(:,7),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,7),28,G1H4(74),m3h9x4(:,200),heltab2x36(:,:,1278))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1431),h0tab(:,1431),[20,11],[nML,nML],2,2,wf3(:,5),wf12(:,5))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(126),ngX,m3h3x12(:,865),heltab2x36(:,:,1279))
  call Hloop_Q_A(ntryL,G0H12(126),20,nML,G1H12(47),n2h12(281))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1432),h0tab(:,1432),[20,11],[nMT,nMT],2,2,wf3(:,5),wf12(:,5))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(128),ngX,m3h3x12(:,866),heltab2x36(:,:,1280))
  call Hloop_Q_A(ntryL,G0H12(128),20,nMT,G1H12(48),n2h12(282))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1433),h0tab(:,1433),[20,11],[nMB,nMB],2,2,wf3(:,5),wf12(:,5))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(131),ngX,m3h3x12(:,867),heltab2x36(:,:,1281))
  call Hloop_Q_A(ntryL,G0H12(131),20,nMB,G1H12(49),n2h12(283))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1434),h0tab(:,1434),[20,11],[nML,nML],2,2,wf3(:,5),wf12(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(142),ngX,m3h3x12(:,868),heltab2x36(:,:,1282))
  call Hloop_Q_A(ntryL,G0H12(142),20,nML,G1H12(50),n2h12(284))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1435),h0tab(:,1435),[20,11],[nMT,nMT],2,2,wf3(:,5),wf12(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(145),ngX,m3h3x12(:,869),heltab2x36(:,:,1283))
  call Hloop_Q_A(ntryL,G0H12(145),20,nMT,G1H12(52),n2h12(285))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1436),h0tab(:,1436),[20,11],[nMB,nMB],2,2,wf3(:,5),wf12(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(13),ngX,m3h3x12(:,870),heltab2x36(:,:,1284))
  call Hloop_Q_A(ntryL,G0H12(13),20,nMB,G1H12(54),n2h12(286))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1437),h0tab(:,1437),[20,11],[nMH,nMZ],2,2,wf3(:,5),wf12(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(15),m3h3x12(:,871),heltab2x36(:,:,1285))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1438),h0tab(:,1438),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,5))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(17),m3h3x12(:,872),heltab2x36(:,:,1286))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1439),h0tab(:,1439),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,5))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(19),m3h3x12(:,873),heltab2x36(:,:,1287))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1440),h0tab(:,1440),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(20),m3h3x12(:,874),heltab2x36(:,:,1288))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1441),h0tab(:,1441),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(22),m3h3x12(:,875),heltab2x36(:,:,1289))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1442),h0tab(:,1442),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,5))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(56),m3h3x12(:,876),heltab2x36(:,:,1290))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1443),h0tab(:,1443),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,5))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(57),m3h3x12(:,877),heltab2x36(:,:,1291))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1444),h0tab(:,1444),[20,11],[nMH,nMZ],2,2,wf3(:,5),wf12(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(53),m3h3x12(:,878),heltab2x36(:,:,1292))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1445),h0tab(:,1445),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(55),m3h3x12(:,879),heltab2x36(:,:,1293))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1446),h0tab(:,1446),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(122),m3h3x12(:,880),heltab2x36(:,:,1294))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1447),h0tab(:,1447),[20,11],[0,0],2,2,wf3(:,1),wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(24),ngZl,m3h3x12(:,881),heltab2x36(:,:,1295))
  call Hloop_Q_A(ntryL,G0H12(24),20,0,G1H12(124),n2h12(287))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1448),h0tab(:,1448),[20,11],[nML,nML],2,2,wf3(:,1),wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(26),ngZl,m3h3x12(:,882),heltab2x36(:,:,1296))
  call Hloop_Q_A(ntryL,G0H12(26),20,nML,G1H12(128),n2h12(288))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1449),h0tab(:,1449),[20,11],[0,0],2,2,wf3(:,1),wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(28),ngZu,m3h3x12(:,883),heltab2x36(:,:,1297))
  call Hloop_Q_A(ntryL,G0H12(28),20,0,G1H12(132),n2h12(289))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1450),h0tab(:,1450),[20,11],[nMT,nMT],2,2,wf3(:,1),wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(29),ngZu,m3h3x12(:,884),heltab2x36(:,:,1298))
  call Hloop_Q_A(ntryL,G0H12(29),20,nMT,G1H12(134),n2h12(290))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1451),h0tab(:,1451),[20,11],[0,0],2,2,wf3(:,1),wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(30),ngZd,m3h3x12(:,885),heltab2x36(:,:,1299))
  call Hloop_Q_A(ntryL,G0H12(30),20,0,G1H12(136),n2h12(291))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1452),h0tab(:,1452),[20,11],[nMB,nMB],2,2,wf3(:,1),wf12(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(31),ngZd,m3h3x12(:,886),heltab2x36(:,:,1300))
  call Hloop_Q_A(ntryL,G0H12(31),20,nMB,G1H12(42),n2h12(292))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1453),h0tab(:,1453),[20,11],[0,0],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(48),ngZn,m3h3x12(:,887),heltab2x36(:,:,1301))
  call Hloop_Q_A(ntryL,G0H12(48),20,0,G1H12(43),n2h12(293))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1454),h0tab(:,1454),[20,11],[0,0],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(49),ngZl,m3h3x12(:,888),heltab2x36(:,:,1302))
  call Hloop_Q_A(ntryL,G0H12(49),20,0,G1H12(44),n2h12(294))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1455),h0tab(:,1455),[20,11],[nML,nML],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(50),ngZl,m3h3x12(:,889),heltab2x36(:,:,1303))
  call Hloop_Q_A(ntryL,G0H12(50),20,nML,G1H12(45),n2h12(295))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1456),h0tab(:,1456),[20,11],[0,0],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(51),ngZu,m3h3x12(:,890),heltab2x36(:,:,1304))
  call Hloop_Q_A(ntryL,G0H12(51),20,0,G1H12(59),n2h12(296))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1457),h0tab(:,1457),[20,11],[nMT,nMT],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(52),ngZu,m3h3x12(:,891),heltab2x36(:,:,1305))
  call Hloop_Q_A(ntryL,G0H12(52),20,nMT,G1H12(60),n2h12(297))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1458),h0tab(:,1458),[20,11],[0,0],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(54),ngZd,m3h3x12(:,892),heltab2x36(:,:,1306))
  call Hloop_Q_A(ntryL,G0H12(54),20,0,G1H12(61),n2h12(298))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1459),h0tab(:,1459),[20,11],[nMB,nMB],2,2,wf3(:,1),wf12(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(56),ngZd,m3h3x12(:,893),heltab2x36(:,:,1307))
  call Hloop_Q_A(ntryL,G0H12(56),20,nMB,G1H12(62),n2h12(299))
  Gcoeff(:)%j = (c(109)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1460),h0tab(:,1460),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(140),m3h3x12(:,894),heltab2x36(:,:,1308))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1461),h0tab(:,1461),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf12(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(142),m3h3x12(:,895),heltab2x36(:,:,1309))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1462),h0tab(:,1462),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(144),m3h3x12(:,896),heltab2x36(:,:,1310))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1463),h0tab(:,1463),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(146),m3h3x12(:,897),heltab2x36(:,:,1311))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1464),h0tab(:,1464),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(147),m3h3x12(:,898),heltab2x36(:,:,1312))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1465),h0tab(:,1465),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(148),m3h3x12(:,899),heltab2x36(:,:,1313))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1466),h0tab(:,1466),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(149),m3h3x12(:,900),heltab2x36(:,:,1314))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1467),h0tab(:,1467),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(150),m3h3x12(:,901),heltab2x36(:,:,1315))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1468),h0tab(:,1468),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(151),m3h3x12(:,902),heltab2x36(:,:,1316))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1469),h0tab(:,1469),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(58),m3h3x12(:,903),heltab2x36(:,:,1317))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1470),h0tab(:,1470),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(72),m3h3x12(:,904),heltab2x36(:,:,1318))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1471),h0tab(:,1471),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(73),m3h3x12(:,905),heltab2x36(:,:,1319))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1472),h0tab(:,1472),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(74),m3h3x12(:,906),heltab2x36(:,:,1320))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1473),h0tab(:,1473),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(75),m3h3x12(:,907),heltab2x36(:,:,1321))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1474),h0tab(:,1474),[22,9],[0,0],2,2,wf6(:,27),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,27),G0H6(17),m3h6x6(:,37),heltab2x36(:,:,1322))
  call Hloop_A_Q(ntryL,G0H6(17),22,0,G1H6(23),n2h6(93))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1475),h0tab(:,1475),[22,9],[0,nMZ],2,2,wf6(:,27),wf6(:,2))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf6(:,27),G0H6(4),ngZu,m3h6x6(:,38),heltab2x36(:,:,1323))
  call Hloop_A_Q(ntryL,G0H6(4),22,0,G1H6(24),n2h6(94))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1476),h0tab(:,1476),[22,9],[0,nMW],2,2,wf6(:,27),wf6(:,2))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,27),G0H6(5),m3h6x6(:,39),heltab2x36(:,:,1324))
  call Hloop_A_Q(ntryL,G0H6(5),22,0,G1H6(21),n2h6(95))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1477),h0tab(:,1477),[22,9],[0,0],2,2,wf6(:,27),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,27),G0H6(1),m3h6x6(:,40),heltab2x36(:,:,1325))
  call Hloop_A_Q(ntryL,G0H6(1),22,0,G1H6(3),n2h6(96))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1478),h0tab(:,1478),[20,11],[nML,nML],2,2,wf3(:,5),wf12(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(76),ngX,m3h3x12(:,908),heltab2x36(:,:,1326))
  call Hloop_Q_A(ntryL,G0H12(76),20,nML,G1H12(152),n2h12(300))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1479),h0tab(:,1479),[20,11],[nMT,nMT],2,2,wf3(:,5),wf12(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(77),ngX,m3h3x12(:,909),heltab2x36(:,:,1327))
  call Hloop_Q_A(ntryL,G0H12(77),20,nMT,G1H12(153),n2h12(301))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1480),h0tab(:,1480),[20,11],[nMB,nMB],2,2,wf3(:,5),wf12(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(78),ngX,m3h3x12(:,910),heltab2x36(:,:,1328))
  call Hloop_Q_A(ntryL,G0H12(78),20,nMB,G1H12(154),n2h12(302))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1481),h0tab(:,1481),[20,11],[nML,nML],2,2,wf3(:,5),wf12(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(79),ngX,m3h3x12(:,911),heltab2x36(:,:,1329))
  call Hloop_Q_A(ntryL,G0H12(79),20,nML,G1H12(155),n2h12(303))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1482),h0tab(:,1482),[20,11],[nMT,nMT],2,2,wf3(:,5),wf12(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(110),ngX,m3h3x12(:,912),heltab2x36(:,:,1330))
  call Hloop_Q_A(ntryL,G0H12(110),20,nMT,G1H12(156),n2h12(304))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1483),h0tab(:,1483),[20,11],[nMB,nMB],2,2,wf3(:,5),wf12(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,5),G0H12(111),ngX,m3h3x12(:,913),heltab2x36(:,:,1331))
  call Hloop_Q_A(ntryL,G0H12(111),20,nMB,G1H12(158),n2h12(305))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1484),h0tab(:,1484),[20,11],[nMH,nMZ],2,2,wf3(:,5),wf12(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(112),m3h3x12(:,914),heltab2x36(:,:,1332))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1485),h0tab(:,1485),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(113),m3h3x12(:,915),heltab2x36(:,:,1333))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1486),h0tab(:,1486),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(114),m3h3x12(:,916),heltab2x36(:,:,1334))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1487),h0tab(:,1487),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(115),m3h3x12(:,917),heltab2x36(:,:,1335))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1488),h0tab(:,1488),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,2))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,5),G0H12(116),m3h3x12(:,918),heltab2x36(:,:,1336))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1489),h0tab(:,1489),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(160),m3h3x12(:,919),heltab2x36(:,:,1337))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1490),h0tab(:,1490),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(163),m3h3x12(:,920),heltab2x36(:,:,1338))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1491),h0tab(:,1491),[20,11],[nMH,nMZ],2,2,wf3(:,5),wf12(:,2))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(164),m3h3x12(:,921),heltab2x36(:,:,1339))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1492),h0tab(:,1492),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(167),m3h3x12(:,922),heltab2x36(:,:,1340))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1493),h0tab(:,1493),[20,11],[nMW,nMW],2,2,wf3(:,5),wf12(:,2))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf3(:,5),20,G1H12(168),m3h3x12(:,923),heltab2x36(:,:,1341))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1494),h0tab(:,1494),[20,11],[0,0],2,2,wf3(:,1),wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(121),ngZl,m3h3x12(:,924),heltab2x36(:,:,1342))
  call Hloop_Q_A(ntryL,G0H12(121),20,0,G1H12(170),n2h12(306))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1495),h0tab(:,1495),[20,11],[nML,nML],2,2,wf3(:,1),wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(119),ngZl,m3h3x12(:,925),heltab2x36(:,:,1343))
  call Hloop_Q_A(ntryL,G0H12(119),20,nML,G1H12(173),n2h12(307))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1496),h0tab(:,1496),[20,11],[0,0],2,2,wf3(:,1),wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(6),ngZu,m3h3x12(:,926),heltab2x36(:,:,1344))
  call Hloop_Q_A(ntryL,G0H12(6),20,0,G1H12(175),n2h12(308))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1497),h0tab(:,1497),[20,11],[nMT,nMT],2,2,wf3(:,1),wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(120),ngZu,m3h3x12(:,927),heltab2x36(:,:,1345))
  call Hloop_Q_A(ntryL,G0H12(120),20,nMT,G1H12(178),n2h12(309))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1498),h0tab(:,1498),[20,11],[0,0],2,2,wf3(:,1),wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(5),ngZd,m3h3x12(:,928),heltab2x36(:,:,1346))
  call Hloop_Q_A(ntryL,G0H12(5),20,0,G1H12(179),n2h12(310))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1499),h0tab(:,1499),[20,11],[nMB,nMB],2,2,wf3(:,1),wf12(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(21),ngZd,m3h3x12(:,929),heltab2x36(:,:,1347))
  call Hloop_Q_A(ntryL,G0H12(21),20,nMB,G1H12(180),n2h12(311))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1500),h0tab(:,1500),[20,11],[0,0],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(23),ngZn,m3h3x12(:,930),heltab2x36(:,:,1348))
  call Hloop_Q_A(ntryL,G0H12(23),20,0,G1H12(186),n2h12(312))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1501),h0tab(:,1501),[20,11],[0,0],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(25),ngZl,m3h3x12(:,931),heltab2x36(:,:,1349))
  call Hloop_Q_A(ntryL,G0H12(25),20,0,G1H12(184),n2h12(313))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1502),h0tab(:,1502),[20,11],[nML,nML],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(7),ngZl,m3h3x12(:,932),heltab2x36(:,:,1350))
  call Hloop_Q_A(ntryL,G0H12(7),20,nML,G1H12(185),n2h12(314))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1503),h0tab(:,1503),[20,11],[0,0],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(91),ngZu,m3h3x12(:,933),heltab2x36(:,:,1351))
  call Hloop_Q_A(ntryL,G0H12(91),20,0,G1H12(187),n2h12(315))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1504),h0tab(:,1504),[20,11],[nMT,nMT],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(61),ngZu,m3h3x12(:,934),heltab2x36(:,:,1352))
  call Hloop_Q_A(ntryL,G0H12(61),20,nMT,G1H12(193),n2h12(316))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1505),h0tab(:,1505),[20,11],[0,0],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(62),ngZd,m3h3x12(:,935),heltab2x36(:,:,1353))
  call Hloop_Q_A(ntryL,G0H12(62),20,0,G1H12(191),n2h12(317))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1506),h0tab(:,1506),[20,11],[nMB,nMB],2,2,wf3(:,1),wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,1),G0H12(63),ngZd,m3h3x12(:,936),heltab2x36(:,:,1354))
  call Hloop_Q_A(ntryL,G0H12(63),20,nMB,G1H12(192),n2h12(318))
  Gcoeff(:)%j = (c(109)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1507),h0tab(:,1507),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(194),m3h3x12(:,937),heltab2x36(:,:,1355))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1508),h0tab(:,1508),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf12(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(195),m3h3x12(:,938),heltab2x36(:,:,1356))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1509),h0tab(:,1509),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(196),m3h3x12(:,939),heltab2x36(:,:,1357))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1510),h0tab(:,1510),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(73),m3h3x12(:,940),heltab2x36(:,:,1358))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1511),h0tab(:,1511),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(74),m3h3x12(:,941),heltab2x36(:,:,1359))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1512),h0tab(:,1512),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(77),m3h3x12(:,942),heltab2x36(:,:,1360))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1513),h0tab(:,1513),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(78),m3h3x12(:,943),heltab2x36(:,:,1361))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1514),h0tab(:,1514),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(125),m3h3x12(:,944),heltab2x36(:,:,1362))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1515),h0tab(:,1515),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,1),20,G1H12(126),m3h3x12(:,945),heltab2x36(:,:,1363))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1516),h0tab(:,1516),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(88),m3h3x12(:,946),heltab2x36(:,:,1364))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1517),h0tab(:,1517),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(90),m3h3x12(:,947),heltab2x36(:,:,1365))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1518),h0tab(:,1518),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(92),m3h3x12(:,948),heltab2x36(:,:,1366))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1519),h0tab(:,1519),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(93),m3h3x12(:,949),heltab2x36(:,:,1367))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1520),h0tab(:,1520),[20,11],[nMW,nMW],2,2,wf3(:,1),wf12(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,1),G0H12(94),m3h3x12(:,950),heltab2x36(:,:,1368))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1521),h0tab(:,1521),[21,10],[0,0],2,2,wf6(:,31),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,31),G0H6(2),m3h6x6(:,41),heltab2x36(:,:,1369))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1522),h0tab(:,1522),[21,10],[nMZ,0],2,2,wf6(:,31),wf6(:,4))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,31),G0H6(8),ngZu,m3h6x6(:,42),heltab2x36(:,:,1370))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1523),h0tab(:,1523),[21,10],[nMW,0],2,2,wf6(:,31),wf6(:,4))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,31),G0H6(6),m3h6x6(:,43),heltab2x36(:,:,1371))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1524),h0tab(:,1524),[21,10],[0,0],2,2,wf6(:,31),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,31),G0H6(7),m3h6x6(:,44),heltab2x36(:,:,1372))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1525),h0tab(:,1525),[19,12],[nML,nML],2,2,wf12(:,7),wf3(:,10))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(12),m3h12x3(:,171),heltab2x36(:,:,1373))
  call Hloop_Q_A(ntryL,G0H3(12),19,nML,G1H3(93),n2h3(279))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1526),h0tab(:,1526),[19,12],[nMT,nMT],2,2,wf12(:,7),wf3(:,10))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(26),m3h12x3(:,172),heltab2x36(:,:,1374))
  call Hloop_Q_A(ntryL,G0H3(26),19,nMT,G1H3(111),n2h3(280))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1527),h0tab(:,1527),[19,12],[nMB,nMB],2,2,wf12(:,7),wf3(:,10))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(19),m3h12x3(:,173),heltab2x36(:,:,1375))
  call Hloop_Q_A(ntryL,G0H3(19),19,nMB,G1H3(116),n2h3(281))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1528),h0tab(:,1528),[19,12],[nML,nML],2,2,wf12(:,3),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(16),ngZl,m3h12x3(:,174),heltab2x36(:,:,1376))
  call Hloop_Q_A(ntryL,G0H3(16),19,nML,G1H3(121),n2h3(282))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1529),h0tab(:,1529),[19,12],[nMT,nMT],2,2,wf12(:,3),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(6),ngZu,m3h12x3(:,175),heltab2x36(:,:,1377))
  call Hloop_Q_A(ntryL,G0H3(6),19,nMT,G1H3(51),n2h3(283))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1530),h0tab(:,1530),[19,12],[nMB,nMB],2,2,wf12(:,3),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(27),ngZd,m3h12x3(:,176),heltab2x36(:,:,1378))
  call Hloop_Q_A(ntryL,G0H3(27),19,nMB,G1H3(190),n2h3(284))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1531),h0tab(:,1531),[19,12],[nMZ,nMH],2,2,wf12(:,3),wf3(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(57),m3h12x3(:,177),heltab2x36(:,:,1379))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1532),h0tab(:,1532),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(194),m3h12x3(:,178),heltab2x36(:,:,1380))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1533),h0tab(:,1533),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(68),m3h12x3(:,179),heltab2x36(:,:,1381))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1534),h0tab(:,1534),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(197),m3h12x3(:,180),heltab2x36(:,:,1382))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1535),h0tab(:,1535),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(69),m3h12x3(:,181),heltab2x36(:,:,1383))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1536),h0tab(:,1536),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(9),m3h12x3(:,182),heltab2x36(:,:,1384))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1537),h0tab(:,1537),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(1),m3h12x3(:,183),heltab2x36(:,:,1385))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1538),h0tab(:,1538),[19,12],[nMZ,nMH],2,2,wf12(:,3),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(3),m3h12x3(:,184),heltab2x36(:,:,1386))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1539),h0tab(:,1539),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(11),m3h12x3(:,185),heltab2x36(:,:,1387))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1540),h0tab(:,1540),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(24),m3h12x3(:,186),heltab2x36(:,:,1388))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1541),h0tab(:,1541),[19,12],[0,0],2,2,wf12(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(22),m3h12x3(:,187),heltab2x36(:,:,1389))
  call Hloop_Q_A(ntryL,G0H3(22),19,0,G1H3(71),n2h3(285))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1542),h0tab(:,1542),[19,12],[nML,nML],2,2,wf12(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(8),m3h12x3(:,188),heltab2x36(:,:,1390))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(185),n2h3(286))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1543),h0tab(:,1543),[19,12],[0,0],2,2,wf12(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(7),m3h12x3(:,189),heltab2x36(:,:,1391))
  call Hloop_Q_A(ntryL,G0H3(7),19,0,G1H3(206),n2h3(287))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1544),h0tab(:,1544),[19,12],[nMT,nMT],2,2,wf12(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(13),m3h12x3(:,190),heltab2x36(:,:,1392))
  call Hloop_Q_A(ntryL,G0H3(13),19,nMT,G1H3(209),n2h3(288))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1545),h0tab(:,1545),[19,12],[0,0],2,2,wf12(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(17),m3h12x3(:,191),heltab2x36(:,:,1393))
  call Hloop_Q_A(ntryL,G0H3(17),19,0,G1H3(54),n2h3(289))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1546),h0tab(:,1546),[19,12],[nMB,nMB],2,2,wf12(:,7),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,7),G0H3(52),m3h12x3(:,192),heltab2x36(:,:,1394))
  call Hloop_Q_A(ntryL,G0H3(52),19,nMB,G1H3(210),n2h3(290))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1547),h0tab(:,1547),[19,12],[0,0],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(51),ngZn,m3h12x3(:,193),heltab2x36(:,:,1395))
  call Hloop_Q_A(ntryL,G0H3(51),19,0,G1H3(213),n2h3(291))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1548),h0tab(:,1548),[19,12],[0,0],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(49),ngZl,m3h12x3(:,194),heltab2x36(:,:,1396))
  call Hloop_Q_A(ntryL,G0H3(49),19,0,G1H3(38),n2h3(292))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1549),h0tab(:,1549),[19,12],[nML,nML],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(32),ngZl,m3h12x3(:,195),heltab2x36(:,:,1397))
  call Hloop_Q_A(ntryL,G0H3(32),19,nML,G1H3(48),n2h3(293))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1550),h0tab(:,1550),[19,12],[0,0],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(2),ngZu,m3h12x3(:,196),heltab2x36(:,:,1398))
  call Hloop_Q_A(ntryL,G0H3(2),19,0,G1H3(43),n2h3(294))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1551),h0tab(:,1551),[19,12],[nMT,nMT],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(25),ngZu,m3h12x3(:,197),heltab2x36(:,:,1399))
  call Hloop_Q_A(ntryL,G0H3(25),19,nMT,G1H3(175),n2h3(295))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1552),h0tab(:,1552),[19,12],[0,0],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(12),ngZd,m3h12x3(:,198),heltab2x36(:,:,1400))
  call Hloop_Q_A(ntryL,G0H3(12),19,0,G1H3(176),n2h3(296))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1553),h0tab(:,1553),[19,12],[nMB,nMB],2,2,wf12(:,3),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,3),G0H3(26),ngZd,m3h12x3(:,199),heltab2x36(:,:,1401))
  call Hloop_Q_A(ntryL,G0H3(26),19,nMB,G1H3(125),n2h3(297))
  Gcoeff(:)%j = (c(109)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1554),h0tab(:,1554),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(31),m3h12x3(:,200),heltab2x36(:,:,1402))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1555),h0tab(:,1555),[19,12],[nMZ,nMH],2,2,wf12(:,3),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(120),m3h12x3(:,201),heltab2x36(:,:,1403))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1556),h0tab(:,1556),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(100),m3h12x3(:,202),heltab2x36(:,:,1404))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1557),h0tab(:,1557),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(167),m3h12x3(:,203),heltab2x36(:,:,1405))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1558),h0tab(:,1558),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(170),m3h12x3(:,204),heltab2x36(:,:,1406))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1559),h0tab(:,1559),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(85),m3h12x3(:,205),heltab2x36(:,:,1407))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1560),h0tab(:,1560),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(144),m3h12x3(:,206),heltab2x36(:,:,1408))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1561),h0tab(:,1561),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,7),19,G1H3(147),m3h12x3(:,207),heltab2x36(:,:,1409))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1562),h0tab(:,1562),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,3),19,G1H3(86),m3h12x3(:,208),heltab2x36(:,:,1410))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1563),h0tab(:,1563),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(19),m3h12x3(:,209),heltab2x36(:,:,1411))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1564),h0tab(:,1564),[19,12],[nMW,nMW],2,2,wf12(:,7),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,7),G0H3(16),m3h12x3(:,210),heltab2x36(:,:,1412))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1565),h0tab(:,1565),[19,12],[nMZ,nMH],2,2,wf12(:,3),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(6),m3h12x3(:,211),heltab2x36(:,:,1413))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1566),h0tab(:,1566),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(27),m3h12x3(:,212),heltab2x36(:,:,1414))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1567),h0tab(:,1567),[19,12],[nMW,nMW],2,2,wf12(:,3),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,3),G0H3(22),m3h12x3(:,213),heltab2x36(:,:,1415))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1568),h0tab(:,1568),[17,14],[0,0],2,2,wf6(:,6),wf6(:,35))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(12),m3h6x6(:,45),heltab2x36(:,:,1416))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1569),h0tab(:,1569),[17,14],[nMZ,0],2,2,wf6(:,6),wf6(:,35))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,6),G0H6(10),ngZu,m3h6x6(:,46),heltab2x36(:,:,1417))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1570),h0tab(:,1570),[17,14],[nMW,0],2,2,wf6(:,6),wf6(:,35))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,6),G0H6(11),m3h6x6(:,47),heltab2x36(:,:,1418))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1571),h0tab(:,1571),[17,14],[0,0],2,2,wf6(:,6),wf6(:,35))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(16),m3h6x6(:,48),heltab2x36(:,:,1419))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1572),h0tab(:,1572),[19,12],[nML,nML],2,2,wf12(:,8),wf3(:,10))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(8),m3h12x3(:,214),heltab2x36(:,:,1420))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(84),n2h3(298))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1573),h0tab(:,1573),[19,12],[nMT,nMT],2,2,wf12(:,8),wf3(:,10))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(7),m3h12x3(:,215),heltab2x36(:,:,1421))
  call Hloop_Q_A(ntryL,G0H3(7),19,nMT,G1H3(11),n2h3(299))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1574),h0tab(:,1574),[19,12],[nMB,nMB],2,2,wf12(:,8),wf3(:,10))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(13),m3h12x3(:,216),heltab2x36(:,:,1422))
  call Hloop_Q_A(ntryL,G0H3(13),19,nMB,G1H3(80),n2h3(300))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1575),h0tab(:,1575),[19,12],[nML,nML],2,2,wf12(:,4),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(17),ngZl,m3h12x3(:,217),heltab2x36(:,:,1423))
  call Hloop_Q_A(ntryL,G0H3(17),19,nML,G1H3(81),n2h3(301))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1576),h0tab(:,1576),[19,12],[nMT,nMT],2,2,wf12(:,4),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(52),ngZu,m3h12x3(:,218),heltab2x36(:,:,1424))
  call Hloop_Q_A(ntryL,G0H3(52),19,nMT,G1H3(181),n2h3(302))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1577),h0tab(:,1577),[19,12],[nMB,nMB],2,2,wf12(:,4),wf3(:,10))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(51),ngZd,m3h12x3(:,219),heltab2x36(:,:,1425))
  call Hloop_Q_A(ntryL,G0H3(51),19,nMB,G1H3(159),n2h3(303))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1578),h0tab(:,1578),[19,12],[nMZ,nMH],2,2,wf12(:,4),wf3(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(153),m3h12x3(:,220),heltab2x36(:,:,1426))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1579),h0tab(:,1579),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(139),m3h12x3(:,221),heltab2x36(:,:,1427))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1580),h0tab(:,1580),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(164),m3h12x3(:,222),heltab2x36(:,:,1428))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1581),h0tab(:,1581),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(130),m3h12x3(:,223),heltab2x36(:,:,1429))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1582),h0tab(:,1582),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(225),m3h12x3(:,224),heltab2x36(:,:,1430))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1583),h0tab(:,1583),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(49),m3h12x3(:,225),heltab2x36(:,:,1431))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1584),h0tab(:,1584),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(32),m3h12x3(:,226),heltab2x36(:,:,1432))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1585),h0tab(:,1585),[19,12],[nMZ,nMH],2,2,wf12(:,4),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(2),m3h12x3(:,227),heltab2x36(:,:,1433))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1586),h0tab(:,1586),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(25),m3h12x3(:,228),heltab2x36(:,:,1434))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1587),h0tab(:,1587),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(12),m3h12x3(:,229),heltab2x36(:,:,1435))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1588),h0tab(:,1588),[19,12],[0,0],2,2,wf12(:,8),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(26),m3h12x3(:,230),heltab2x36(:,:,1436))
  call Hloop_Q_A(ntryL,G0H3(26),19,0,G1H3(222),n2h3(304))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1589),h0tab(:,1589),[19,12],[nML,nML],2,2,wf12(:,8),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(8),m3h12x3(:,231),heltab2x36(:,:,1437))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(26),n2h3(305))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1590),h0tab(:,1590),[19,12],[0,0],2,2,wf12(:,8),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(7),m3h12x3(:,232),heltab2x36(:,:,1438))
  call Hloop_Q_A(ntryL,G0H3(7),19,0,G1H3(49),n2h3(306))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1591),h0tab(:,1591),[19,12],[nMT,nMT],2,2,wf12(:,8),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(13),m3h12x3(:,233),heltab2x36(:,:,1439))
  call Hloop_Q_A(ntryL,G0H3(13),19,nMT,G1H3(107),n2h3(307))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1592),h0tab(:,1592),[19,12],[0,0],2,2,wf12(:,8),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(17),m3h12x3(:,234),heltab2x36(:,:,1440))
  call Hloop_Q_A(ntryL,G0H3(17),19,0,G1H3(83),n2h3(308))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1593),h0tab(:,1593),[19,12],[nMB,nMB],2,2,wf12(:,8),wf3(:,2))
  call Hloop_QV_A(ntryL,G0H36(1),wf12(:,8),G0H3(52),m3h12x3(:,235),heltab2x36(:,:,1441))
  call Hloop_Q_A(ntryL,G0H3(52),19,nMB,G1H3(109),n2h3(309))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1594),h0tab(:,1594),[19,12],[0,0],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(51),ngZn,m3h12x3(:,236),heltab2x36(:,:,1442))
  call Hloop_Q_A(ntryL,G0H3(51),19,0,G1H3(4),n2h3(310))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1595),h0tab(:,1595),[19,12],[0,0],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(26),ngZl,m3h12x3(:,237),heltab2x36(:,:,1443))
  call Hloop_Q_A(ntryL,G0H3(26),19,0,G1H3(186),n2h3(311))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1596),h0tab(:,1596),[19,12],[nML,nML],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(8),ngZl,m3h12x3(:,238),heltab2x36(:,:,1444))
  call Hloop_Q_A(ntryL,G0H3(8),19,nML,G1H3(146),n2h3(312))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1597),h0tab(:,1597),[19,12],[0,0],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(7),ngZu,m3h12x3(:,239),heltab2x36(:,:,1445))
  call Hloop_Q_A(ntryL,G0H3(7),19,0,G1H3(19),n2h3(313))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1598),h0tab(:,1598),[19,12],[nMT,nMT],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(13),ngZu,m3h12x3(:,240),heltab2x36(:,:,1446))
  call Hloop_Q_A(ntryL,G0H3(13),19,nMT,G1H3(15),n2h3(314))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1599),h0tab(:,1599),[19,12],[0,0],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(17),ngZd,m3h12x3(:,241),heltab2x36(:,:,1447))
  call Hloop_Q_A(ntryL,G0H3(17),19,0,G1H3(207),n2h3(315))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1600),h0tab(:,1600),[19,12],[nMB,nMB],2,2,wf12(:,4),wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf12(:,4),G0H3(52),ngZd,m3h12x3(:,242),heltab2x36(:,:,1448))
  call Hloop_Q_A(ntryL,G0H3(52),19,nMB,G1H3(211),n2h3(316))
  Gcoeff(:)%j = (c(109)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1601),h0tab(:,1601),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(215),m3h12x3(:,243),heltab2x36(:,:,1449))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1602),h0tab(:,1602),[19,12],[nMZ,nMH],2,2,wf12(:,4),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(219),m3h12x3(:,244),heltab2x36(:,:,1450))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1603),h0tab(:,1603),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(223),m3h12x3(:,245),heltab2x36(:,:,1451))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1604),h0tab(:,1604),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(227),m3h12x3(:,246),heltab2x36(:,:,1452))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1605),h0tab(:,1605),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(229),m3h12x3(:,247),heltab2x36(:,:,1453))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1606),h0tab(:,1606),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(70),m3h12x3(:,248),heltab2x36(:,:,1454))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1607),h0tab(:,1607),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(132),m3h12x3(:,249),heltab2x36(:,:,1455))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1608),h0tab(:,1608),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,8),19,G1H3(23),m3h12x3(:,250),heltab2x36(:,:,1456))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1609),h0tab(:,1609),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf12(:,4),19,G1H3(189),m3h12x3(:,251),heltab2x36(:,:,1457))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1610),h0tab(:,1610),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(51),m3h12x3(:,252),heltab2x36(:,:,1458))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1611),h0tab(:,1611),[19,12],[nMW,nMW],2,2,wf12(:,8),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,8),G0H3(26),m3h12x3(:,253),heltab2x36(:,:,1459))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1612),h0tab(:,1612),[19,12],[nMZ,nMH],2,2,wf12(:,4),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(8),m3h12x3(:,254),heltab2x36(:,:,1460))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1613),h0tab(:,1613),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(7),m3h12x3(:,255),heltab2x36(:,:,1461))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1614),h0tab(:,1614),[19,12],[nMW,nMW],2,2,wf12(:,4),wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf12(:,4),G0H3(13),m3h12x3(:,256),heltab2x36(:,:,1462))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1615),h0tab(:,1615),[18,13],[0,0],2,2,wf6(:,8),wf6(:,39))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(14),m3h6x6(:,49),heltab2x36(:,:,1463))
  call Hloop_A_Q(ntryL,G0H6(14),18,0,G1H6(4),n2h6(97))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1616),h0tab(:,1616),[18,13],[0,nMZ],2,2,wf6(:,8),wf6(:,39))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(15),ngZu,m3h6x6(:,50),heltab2x36(:,:,1464))
  call Hloop_A_Q(ntryL,G0H6(15),18,0,G1H6(17),n2h6(98))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1617),h0tab(:,1617),[18,13],[0,nMW],2,2,wf6(:,8),wf6(:,39))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(20),m3h6x6(:,51),heltab2x36(:,:,1465))
  call Hloop_A_Q(ntryL,G0H6(20),18,0,G1H6(37),n2h6(99))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1618),h0tab(:,1618),[18,13],[0,0],2,2,wf6(:,8),wf6(:,39))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(18),m3h6x6(:,52),heltab2x36(:,:,1466))
  call Hloop_A_Q(ntryL,G0H6(18),18,0,G1H6(15),n2h6(100))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(117),[G0H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(12),[G0H12(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(71),G1H4(52),G1H4(51),G1H4(42),G1H4(41),G1H4(8) &
    ,G1H4(7),G1H4(28),G1H4(27),G1H4(16),G1H4(15),G0H4(10),G0H4(39),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(73),G1H4(54),G1H4(53),G1H4(44),G1H4(43),G1H4(2) &
    ,G1H4(1),G1H4(30),G1H4(29),G1H4(18),G1H4(17),G0H4(41),G0H4(9),G0H4(6),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(69),[G0H4(56),G0H4(29),G0H4(50),G0H4(35),G0H4(53) &
    ,G0H4(16),G0H4(12),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(70),[G0H4(55),G0H4(30),G0H4(48),G0H4(36),G0H4(51) &
    ,G0H4(15),G0H4(11),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(75),[G0H4(61),G0H4(25),G0H4(31),G0H4(44),G0H4(27) &
    ,G0H4(54),G0H4(43),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(76),[G0H4(62),G0H4(26),G0H4(32),G0H4(46),G0H4(28) &
    ,G0H4(52),G0H4(14),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(223),[G1H3(215),G1H3(100),G1H3(31),G0H3(20),G0H3(29) &
    ,G0H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G1H3(23),G1H3(86),G1H3(147),G0H3(28),G0H3(53) &
    ,G0H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(36),[G0H3(31),G0H3(44),G0H3(46),G0H3(47),G0H3(62) &
    ,G0H3(65),G0H3(66),G0H3(39),G0H3(41),G0H3(54),G0H3(57),G0H3(34),G0H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(42),[G0H3(61),G0H3(35),G0H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(40),[G0H3(59),G0H3(58),G0H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(8),[G0H1(7),G0H1(6),G0H1(5),G0H1(3),G0H1(4),G0H1(1) &
    ,G0H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(16),[G0H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(65),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(68),[G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(99),[G0H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(134),[G1H3(29),G0H3(64),G0H3(55),G0H3(15),G0H3(18) &
    ,G0H3(23),G0H3(21),G0H3(4),G0H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(45),G1H4(3),G1H4(31),G1H4(19),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(46),G1H4(4),G1H4(32),G1H4(20),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(47),G1H4(37),G1H4(34),G1H4(22),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(48),G1H4(38),G1H4(36),G1H4(24),G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(49),G1H4(39),G1H4(5),G1H4(25),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(50),G1H4(40),G1H4(6),G1H4(26),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(72),[G0H4(71),G0H4(58),G0H4(57),G0H4(34),G0H4(33) &
    ,G0H4(20),G0H4(22),G0H4(38),G0H4(37),G0H4(47),G0H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(74),[G0H4(73),G0H4(60),G0H4(59),G0H4(24),G0H4(23) &
    ,G0H4(17),G0H4(18),G0H4(42),G0H4(40),G0H4(19),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(30),[G0H1(27),G0H1(24),G0H1(21),G0H1(18),G0H1(15) &
    ,G0H1(12),G0H1(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(28),[G0H1(22),G0H1(16),G0H1(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(29),[G0H1(23),G0H1(17),G0H1(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(32),[G0H1(31),G0H1(26),G0H1(25),G0H1(20),G0H1(19) &
    ,G0H1(14),G0H1(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(100),[G0H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(34),[G0H12(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(57),[G1H12(56),G0H12(72),G0H12(58),G0H12(35) &
    ,G0H12(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(53),[G0H12(73),G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(122),[G1H12(55),G0H12(75),G0H12(74),G0H12(118) &
    ,G0H12(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(27),[G0H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(47),[G0H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(163),[G1H12(160),G0H12(90),G0H12(88),G0H12(8) &
    ,G0H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(164),[G0H12(92),G0H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(168),[G1H12(167),G0H12(94),G0H12(93),G0H12(3) &
    ,G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(43),[G0H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(50),[G0H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(81),[G1H3(84),G1H3(121),G1H3(93),G1H3(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(181),[G1H3(11),G1H3(51),G1H3(111),G1H3(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(159),[G1H3(80),G1H3(190),G1H3(116),G1H3(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(225),[G1H3(130),G1H3(164),G1H3(139),G1H3(69),G1H3(197) &
    ,G1H3(68),G1H3(194),G0H3(33),G0H3(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(64),[G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(146),[G1H3(26),G1H3(48),G1H3(185),G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(15),[G1H3(107),G1H3(175),G1H3(209),G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(109),G1H3(125),G1H3(210),G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(132),[G1H3(70),G1H3(229),G1H3(227),G1H3(144),G1H3(85) &
    ,G1H3(170),G1H3(167),G0H3(5),G0H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(81),[G1H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(86),[G1H12(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(89),[G1H12(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(100),[G1H12(96),G0H12(65),G0H12(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(79),[G1H12(72),G0H12(123),G0H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(64),[G0H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(67),[G0H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(128),[G1H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(134),[G1H12(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G1H12(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(45),[G1H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(60),[G1H12(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(62),[G1H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(142),[G0H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(147),[G1H12(146),G0H12(19),G0H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(149),[G1H12(148),G0H12(22),G0H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(136),[G1H12(132),G1H12(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(3),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(173),[G1H12(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(178),[G1H12(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(180),[G1H12(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(185),[G1H12(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(193),[G1H12(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(192),[G1H12(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(195),[G0H12(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(74),[G1H12(73),G0H12(114),G0H12(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(78),[G1H12(77),G0H12(116),G0H12(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(179),[G1H12(175),G1H12(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(7),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(153),[G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(12),[G0H3(25),G0H3(32),G0H3(49),G0H3(24),G0H3(11),G0H3(1) &
    ,G0H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(2),[G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(186),[G1H3(222),G1H3(38),G1H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(19),[G1H3(49),G1H3(43),G1H3(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(207),[G1H3(83),G1H3(176),G1H3(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(4),[G1H3(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(219),[G1H3(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(13),[G0H3(7),G0H3(26),G0H3(51),G0H3(22),G0H3(27),G0H3(16) &
    ,G0H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H3(8),[G0H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(15),[G1H6(4)])
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(117),wf4(:,1),wf3(:,10),G0tensor(25),m4h4x3x1(:,1),heltab3x12(:,:,17))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(12),wf4(:,2),wf3(:,10),G0tensor(50),m4h4x3x1(:,2),heltab3x12(:,:,18))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(301),wf3(:,2),wf4(:,1),G1tensor(131),m4h3x4x1(:,5),heltab3x12(:,:,19))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(303),wf3(:,2),wf4(:,2),G1tensor(136),m4h3x4x1(:,6),heltab3x12(:,:,20))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(326),wf3(:,2),wf4(:,1),G1tensor(141),m4h3x4x1(:,7),heltab3x12(:,:,21))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(327),wf3(:,2),wf4(:,2),G1tensor(146),m4h3x4x1(:,8),heltab3x12(:,:,22))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(72),wf4(:,1),G1tensor(151),m3h4x1(:,61),heltab2x4(:,:,75))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(74),wf4(:,2),G1tensor(156),m3h4x1(:,62),heltab2x4(:,:,76))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(69),28,wf4(:,1),3,G1tensor(161),m3h4x1(:,63),heltab2x4(:,:,77))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(70),28,wf4(:,2),3,G1tensor(166),m3h4x1(:,64),heltab2x4(:,:,78))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(75),28,wf4(:,1),3,G1tensor(171),m3h4x1(:,65),heltab2x4(:,:,79))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(76),28,wf4(:,2),3,G1tensor(176),m3h4x1(:,66),heltab2x4(:,:,80))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(223),19,wf3(:,2),12,G2tensor(273),m3h3x1(:,453),heltab2x3(:,:,555))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(189),19,wf3(:,2),12,G2tensor(132),m3h3x1(:,454),heltab2x3(:,:,556))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(36),ex4(:),G0tensor(75),m3h3x1(:,455),heltab2x3(:,:,557))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H3(42),23,ex4(:),8,G1tensor(181),m3h3x1(:,456),heltab2x3(:,:,558))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(40),23,ex4(:),8,G1tensor(186),m3h3x1(:,457),heltab2x3(:,:,559))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H1(8),27,ex3(:),4,G1tensor(191),m3h1x1(:,156),heltab2x1(:,:,156))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(330),ex4(:),wf4(:,1),G1tensor(196),m4h3x4x1(:,9),heltab3x12(:,:,23))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(331),ex4(:),wf4(:,2),G1tensor(201),m4h3x4x1(:,10),heltab3x12(:,:,24))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(338),ex4(:),wf4(:,1),G1tensor(206),m4h3x4x1(:,11),heltab3x12(:,:,25))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(341),ex4(:),wf4(:,2),G1tensor(211),m4h3x4x1(:,12),heltab3x12(:,:,26))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(16),ex4(:),wf4(:,3),G0tensor(100),m4h3x4x1(:,13),heltab3x12(:,:,27))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(343),ex4(:),wf4(:,4),G1tensor(216),m4h3x4x1(:,14),heltab3x12(:,:,28))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H12(345),ex4(:),wf4(:,4),G1tensor(221),m4h3x4x1(:,15),heltab3x12(:,:,29))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(65),24,wf4(:,4),7,G1tensor(226),m3h4x1(:,67),heltab2x4(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(68),24,wf4(:,4),7,G1tensor(231),m3h4x1(:,68),heltab2x4(:,:,82))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H4(23),wf4(:,1),ex3(:),G1tensor(236),m4h4x1x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H4(35),wf4(:,2),ex3(:),G1tensor(241),m4h4x1x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_SSS_S(ntryL,l_switch,G1H12(347),ex3(:),wf12(:,25),G1tensor(246),m4h1x12x1(:,1),heltab3x12(:,:,30))
  call Hcheck_last_VSS_V(ntryL,l_switch,G1H12(352),ex3(:),wf12(:,25),G1tensor(251),m4h1x12x1(:,2),heltab3x12(:,:,31))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H12(99),20,wf12(:,25),11,G1tensor(256),m3h12x1(:,77),heltab2x12(:,:,859))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H3(134),ex4(:),ex3(:),G1tensor(261),m4h3x1x1(:,6),heltab3x3(:,:,7))
  call Hloop_QV_A(ntryL,G1H4(65),wf4(:,1),G1H1(19),m3h4x1(:,69),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nML,G2tensor(174),n2h1(395))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,1),G1H1(1),m3h4x1(:,70),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(177),n2h1(396))
  call Hloop_QV_A(ntryL,G1H4(67),wf4(:,1),G1H1(45),m3h4x1(:,71),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),31,nMB,G2tensor(58),n2h1(397))
  call Hloop_QZ_A(ntryL,G1H4(68),wf4(:,2),G1H1(49),ngZl,m3h4x1(:,72),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(49),31,nML,G2tensor(126),n2h1(398))
  call Hloop_QZ_A(ntryL,G1H4(69),wf4(:,2),G1H1(53),ngZu,m3h4x1(:,73),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(53),31,nMT,G2tensor(61),n2h1(399))
  call Hloop_QZ_A(ntryL,G1H4(70),wf4(:,2),G1H1(57),ngZd,m3h4x1(:,74),heltab2x4(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(57),31,nMB,G2tensor(127),n2h1(400))
  call Hcheck_last_CV_D(ntryL,l_switch,G0H4(72),28,wf4(:,1),3,G1tensor(266),m3h4x1(:,75),heltab2x4(:,:,89))
  call Hcheck_last_CV_D(ntryL,l_switch,G0H4(74),28,wf4(:,2),3,G1tensor(271),m3h4x1(:,76),heltab2x4(:,:,90))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(30),ex3(:),G0tensor(125),m3h1x1(:,157),heltab2x1(:,:,157))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(28),ex3(:),G0tensor(150),m3h1x1(:,158),heltab2x1(:,:,158))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(29),ex3(:),G0tensor(175),m3h1x1(:,159),heltab2x1(:,:,159))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H1(32),ex3(:),G0tensor(200),m3h1x1(:,160),heltab2x1(:,:,160))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(100),wf12(:,5),ex3(:),G0tensor(225),m4h12x1x1(:,1),heltab3x12(:,:,32))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(33),wf12(:,1),ex3(:),G0tensor(250),m4h12x1x1(:,2),heltab3x12(:,:,33))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(34),wf12(:,1),ex3(:),G0tensor(275),m4h12x1x1(:,3),heltab3x12(:,:,34))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(57),wf12(:,5),G1tensor(276),m3h12x1(:,78),heltab2x12(:,:,860))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(53),wf12(:,1),G1tensor(281),m3h12x1(:,79),heltab2x12(:,:,861))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(122),wf12(:,1),G1tensor(286),m3h12x1(:,80),heltab2x12(:,:,862))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(27),wf12(:,6),ex3(:),G0tensor(300),m4h12x1x1(:,4),heltab3x12(:,:,35))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(46),wf12(:,2),ex3(:),G0tensor(325),m4h12x1x1(:,5),heltab3x12(:,:,36))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H12(47),wf12(:,2),ex3(:),G0tensor(350),m4h12x1x1(:,6),heltab3x12(:,:,37))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(163),wf12(:,6),G1tensor(291),m3h12x1(:,81),heltab2x12(:,:,863))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(164),wf12(:,2),G1tensor(296),m3h12x1(:,82),heltab2x12(:,:,864))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H12(168),wf12(:,2),G1tensor(301),m3h12x1(:,83),heltab2x12(:,:,865))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(43),ex4(:),G0tensor(375),m3h3x1(:,458),heltab2x3(:,:,560))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H3(50),ex4(:),ex3(:),G0tensor(4),m4h3x1x1(:,7),heltab3x3(:,:,8))
  call Hloop_QS_A(ntryL,G1H3(81),wf3(:,10),G1H1(61),ngX,m3h3x1(:,459),heltab2x3(:,:,561))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),31,nML,G2tensor(108),n2h1(401))
  call Hloop_QS_A(ntryL,G1H3(181),wf3(:,10),G1H1(56),ngX,m3h3x1(:,460),heltab2x3(:,:,562))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(56),31,nMT,G2tensor(67),n2h1(402))
  call Hloop_QS_A(ntryL,G1H3(159),wf3(:,10),G1H1(5),ngX,m3h3x1(:,461),heltab2x3(:,:,563))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nMB,G2tensor(129),n2h1(403))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H3(225),wf3(:,10),G1tensor(306),m3h3x1(:,462),heltab2x3(:,:,564))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H3(64),19,wf3(:,10),12,G2tensor(70),m3h3x1(:,463),heltab2x3(:,:,565))
  call Hloop_QZ_A(ntryL,G1H3(146),wf3(:,2),G1H1(43),ngZl,m3h3x1(:,464),heltab2x3(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),31,nML,G2tensor(130),n2h1(404))
  call Hloop_QZ_A(ntryL,G1H3(15),wf3(:,2),G1H1(64),ngZu,m3h3x1(:,465),heltab2x3(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(64),31,nMT,G2tensor(111),n2h1(405))
  call Hloop_QZ_A(ntryL,G1H3(211),wf3(:,2),G1H1(26),ngZd,m3h3x1(:,466),heltab2x3(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),31,nMB,G2tensor(136),n2h1(406))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(132),19,wf3(:,2),12,G2tensor(112),m3h3x1(:,467),heltab2x3(:,:,569))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(90),wf3(:,2),G1tensor(311),m3h3x1(:,468),heltab2x3(:,:,570))
  call Hloop_QS_A(ntryL,G1H12(81),wf12(:,25),G1H1(59),ngH,m3h12x1(:,84),heltab2x12(:,:,866))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),31,nML,G2tensor(80),n2h1(407))
  call Hloop_QS_A(ntryL,G1H12(86),wf12(:,25),G1H1(8),ngH,m3h12x1(:,85),heltab2x12(:,:,867))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nMT,G2tensor(19),n2h1(408))
  call Hloop_QS_A(ntryL,G1H12(89),wf12(:,25),G1H1(44),ngH,m3h12x1(:,86),heltab2x12(:,:,868))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(3),n2h1(409))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(100),wf12(:,25),G1tensor(316),m3h12x1(:,87),heltab2x12(:,:,869))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H12(79),20,wf12(:,25),11,G2tensor(7),m3h12x1(:,88),heltab2x12(:,:,870))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H12(91),wf12(:,25),G1tensor(321),m3h12x1(:,89),heltab2x12(:,:,871))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H12(103),wf12(:,25),G1tensor(326),m3h12x1(:,90),heltab2x12(:,:,872))
  call Hloop_QS_A(ntryL,G1H4(55),wf4(:,3),G1H1(6),ngX,m3h4x1(:,77),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nML,G2tensor(210),n2h1(410))
  call Hloop_QS_A(ntryL,G1H4(56),wf4(:,3),G1H1(38),ngX,m3h4x1(:,78),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),31,nMT,G2tensor(30),n2h1(411))
  call Hloop_QS_A(ntryL,G1H4(57),wf4(:,3),G1H1(55),ngX,m3h4x1(:,79),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),31,nMB,G2tensor(195),n2h1(412))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(64),wf4(:,3),G0tensor(9),m3h4x1(:,80),heltab2x4(:,:,94))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(59),24,wf4(:,3),7,G2tensor(1),m3h4x1(:,81),heltab2x4(:,:,95))
  call Hloop_QZ_A(ntryL,G1H4(60),wf4(:,4),G1H1(9),ngZl,m3h4x1(:,82),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nML,G2tensor(21),n2h1(413))
  call Hloop_QZ_A(ntryL,G1H4(61),wf4(:,4),G1H1(63),ngZu,m3h4x1(:,83),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(63),31,nMT,G2tensor(5),n2h1(414))
  call Hloop_QZ_A(ntryL,G1H4(62),wf4(:,4),G1H1(27),ngZd,m3h4x1(:,84),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(113),n2h1(415))
  call Hcheck_last_CV_D(ntryL,l_switch,G0H4(67),24,wf4(:,4),7,G1tensor(331),m3h4x1(:,85),heltab2x4(:,:,99))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(64),wf4(:,4),G1tensor(336),m3h4x1(:,86),heltab2x4(:,:,100))
  call Hloop_QV_A(ntryL,G1H12(128),wf12(:,5),G1H1(7),m3h12x1(:,91),heltab2x12(:,:,873))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),31,nML,G2tensor(57),n2h1(416))
  call Hloop_QV_A(ntryL,G1H12(134),wf12(:,5),G1H1(31),m3h12x1(:,92),heltab2x12(:,:,874))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),31,nMT,G2tensor(114),n2h1(417))
  call Hloop_QV_A(ntryL,G1H12(42),wf12(:,5),G1H1(32),m3h12x1(:,93),heltab2x12(:,:,875))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(72),n2h1(418))
  call Hloop_QZ_A(ntryL,G1H12(45),wf12(:,1),G1H1(3),ngZl,m3h12x1(:,94),heltab2x12(:,:,876))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,nML,G2tensor(100),n2h1(419))
  call Hloop_QZ_A(ntryL,G1H12(60),wf12(:,1),G1H1(39),ngZu,m3h12x1(:,95),heltab2x12(:,:,877))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,nMT,G2tensor(115),n2h1(420))
  call Hloop_QZ_A(ntryL,G1H12(62),wf12(:,1),G1H1(40),ngZd,m3h12x1(:,96),heltab2x12(:,:,878))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),31,nMB,G2tensor(101),n2h1(421))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(142),20,wf12(:,1),11,G2tensor(27),m3h12x1(:,97),heltab2x12(:,:,879))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(147),20,wf12(:,5),11,G2tensor(103),m3h12x1(:,98),heltab2x12(:,:,880))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(149),20,wf12(:,1),11,G2tensor(222),m3h12x1(:,99),heltab2x12(:,:,881))
  call Hloop_QV_A(ntryL,G1H12(136),wf12(:,5),G1H1(28),m3h12x1(:,100),heltab2x12(:,:,882))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,0,G2tensor(104),n2h1(422))
  call Hloop_QZ_A(ntryL,G1H12(43),wf12(:,1),G1H1(29),ngZn,m3h12x1(:,101),heltab2x12(:,:,883))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),31,0,G2tensor(117),n2h1(423))
  call Hloop_QZ_A(ntryL,G1H12(44),wf12(:,1),G1H1(30),ngZl,m3h12x1(:,102),heltab2x12(:,:,884))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),31,0,G2tensor(105),n2h1(424))
  call Hloop_QZ_A(ntryL,G1H12(59),wf12(:,1),G1H1(34),ngZu,m3h12x1(:,103),heltab2x12(:,:,885))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,0,G2tensor(107),n2h1(425))
  call Hloop_QZ_A(ntryL,G1H12(61),wf12(:,1),G1H1(47),ngZd,m3h12x1(:,104),heltab2x12(:,:,886))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),31,0,G2tensor(119),n2h1(426))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(140),20,wf12(:,5),11,G2tensor(109),m3h12x1(:,105),heltab2x12(:,:,887))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(144),20,wf12(:,1),11,G2tensor(120),m3h12x1(:,106),heltab2x12(:,:,888))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(150),20,wf12(:,5),11,G2tensor(110),m3h12x1(:,107),heltab2x12(:,:,889))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(151),20,wf12(:,1),11,G2tensor(78),m3h12x1(:,108),heltab2x12(:,:,890))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(3),wf6(:,2),G1tensor(341),m3h6x1(:,31),heltab2x6(:,:,184))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H6(24),wf6(:,2),G1tensor(346),ngZu,m3h6x1(:,32),heltab2x6(:,:,185))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H6(21),wf6(:,2),G1tensor(351),m3h6x1(:,33),heltab2x6(:,:,186))
  call Hloop_QV_A(ntryL,G1H12(173),wf12(:,6),G1H1(24),m3h12x1(:,109),heltab2x12(:,:,891))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nML,G2tensor(81),n2h1(427))
  call Hloop_QV_A(ntryL,G1H12(178),wf12(:,6),G1H1(10),m3h12x1(:,110),heltab2x12(:,:,892))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMT,G2tensor(82),n2h1(428))
  call Hloop_QV_A(ntryL,G1H12(180),wf12(:,6),G1H1(14),m3h12x1(:,111),heltab2x12(:,:,893))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(83),n2h1(429))
  call Hloop_QZ_A(ntryL,G1H12(185),wf12(:,2),G1H1(48),ngZl,m3h12x1(:,112),heltab2x12(:,:,894))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(48),31,nML,G2tensor(84),n2h1(430))
  call Hloop_QZ_A(ntryL,G1H12(193),wf12(:,2),G1H1(17),ngZu,m3h12x1(:,113),heltab2x12(:,:,895))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMT,G2tensor(85),n2h1(431))
  call Hloop_QZ_A(ntryL,G1H12(192),wf12(:,2),G1H1(51),ngZd,m3h12x1(:,114),heltab2x12(:,:,896))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(51),31,nMB,G2tensor(88),n2h1(432))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(195),20,wf12(:,2),11,G2tensor(89),m3h12x1(:,115),heltab2x12(:,:,897))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(74),20,wf12(:,6),11,G2tensor(90),m3h12x1(:,116),heltab2x12(:,:,898))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(78),20,wf12(:,2),11,G2tensor(91),m3h12x1(:,117),heltab2x12(:,:,899))
  call Hloop_QV_A(ntryL,G1H12(179),wf12(:,6),G1H1(37),m3h12x1(:,118),heltab2x12(:,:,900))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,0,G2tensor(92),n2h1(433))
  call Hloop_QZ_A(ntryL,G1H12(186),wf12(:,2),G1H1(12),ngZn,m3h12x1(:,119),heltab2x12(:,:,901))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,0,G2tensor(93),n2h1(434))
  call Hloop_QZ_A(ntryL,G1H12(184),wf12(:,2),G1H1(25),ngZl,m3h12x1(:,120),heltab2x12(:,:,902))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,0,G2tensor(94),n2h1(435))
  call Hloop_QZ_A(ntryL,G1H12(187),wf12(:,2),G1H1(36),ngZu,m3h12x1(:,121),heltab2x12(:,:,903))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),31,0,G2tensor(95),n2h1(436))
  call Hloop_QZ_A(ntryL,G1H12(191),wf12(:,2),G1H1(4),ngZd,m3h12x1(:,122),heltab2x12(:,:,904))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,0,G2tensor(204),n2h1(437))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(194),20,wf12(:,6),11,G2tensor(98),m3h12x1(:,123),heltab2x12(:,:,905))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H12(196),20,wf12(:,2),11,G2tensor(99),m3h12x1(:,124),heltab2x12(:,:,906))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(125),20,wf12(:,6),11,G2tensor(141),m3h12x1(:,125),heltab2x12(:,:,907))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(126),20,wf12(:,2),11,G2tensor(143),m3h12x1(:,126),heltab2x12(:,:,908))
  call Hloop_VA_Q(ntryL,G0H6(7),wf6(:,4),G0H1(7),m3h6x1(:,34),heltab2x6(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(7),31,0,G1tensor(356),n2h1(438))
  call Hloop_ZA_Q(ntryL,G0H6(8),wf6(:,4),G0H1(6),ngZu,m3h6x1(:,35),heltab2x6(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(6),31,0,G1tensor(361),n2h1(439))
  call Hloop_WA_Q(ntryL,G0H6(6),wf6(:,4),G0H1(5),m3h6x1(:,36),heltab2x6(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(5),31,0,G1tensor(366),n2h1(440))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H3(153),wf3(:,10),G1tensor(371),m3h3x1(:,469),heltab2x3(:,:,571))
  call Hcheck_last_VT_S(ntryL,l_switch,G0H3(12),19,wf3(:,10),12,G1tensor(376),m3h3x1(:,470),heltab2x3(:,:,572))
  call Hcheck_last_VS_T(ntryL,l_switch,G0H3(2),19,wf3(:,10),12,G1tensor(417),m3h3x1(:,471),heltab2x3(:,:,573))
  call Hloop_QZ_A(ntryL,G1H3(186),wf3(:,2),G1H1(20),ngZl,m3h3x1(:,472),heltab2x3(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,0,G2tensor(145),n2h1(441))
  call Hloop_QZ_A(ntryL,G1H3(19),wf3(:,2),G1H1(41),ngZu,m3h3x1(:,473),heltab2x3(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,0,G2tensor(152),n2h1(442))
  call Hloop_QZ_A(ntryL,G1H3(207),wf3(:,2),G1H1(21),ngZd,m3h3x1(:,474),heltab2x3(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,0,G2tensor(154),n2h1(443))
  call Hloop_QZ_A(ntryL,G1H3(4),wf3(:,2),G1H1(11),ngZn,m3h3x1(:,475),heltab2x3(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),31,0,G2tensor(156),n2h1(444))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(219),19,wf3(:,2),12,G2tensor(159),m3h3x1(:,476),heltab2x3(:,:,578))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H3(13),wf3(:,2),G0tensor(405),m3h3x1(:,477),heltab2x3(:,:,579))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H3(8),wf3(:,2),G0tensor(430),m3h3x1(:,478),heltab2x3(:,:,580))
  call Hloop_VA_Q(ntryL,G0H6(16),wf6(:,35),G0H1(3),m3h6x1(:,37),heltab2x6(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(3),31,0,G1tensor(422),n2h1(445))
  call Hloop_ZA_Q(ntryL,G0H6(10),wf6(:,35),G0H1(4),ngZu,m3h6x1(:,38),heltab2x6(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(4),31,0,G1tensor(427),n2h1(446))
  call Hloop_WA_Q(ntryL,G0H6(11),wf6(:,35),G0H1(1),m3h6x1(:,39),heltab2x6(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(432),n2h1(447))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(15),wf6(:,39),G1tensor(437),m3h6x1(:,40),heltab2x6(:,:,193))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H6(17),wf6(:,39),G1tensor(442),ngZu,m3h6x1(:,41),heltab2x6(:,:,194))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H6(37),wf6(:,39),G1tensor(447),m3h6x1(:,42),heltab2x6(:,:,195))
  call ol_merge_tensors(G0tensor(638),[G0tensor(521),G0tensor(376),G0tensor(32),G0tensor(216),G0tensor(380),G0tensor(355) &
    ,G0tensor(255),G0tensor(30)])
  call ol_merge_tensors(G0tensor(750),[G0tensor(526),G0tensor(297),G0tensor(276),G0tensor(35)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(141),G2tensor(99),G2tensor(98),G2tensor(91),G2tensor(90),G2tensor(78) &
    ,G2tensor(110),G2tensor(120),G2tensor(109),G2tensor(222),G2tensor(103),G2tensor(7),G1tensor(326),G1tensor(321),G1tensor(316) &
    ,G1tensor(301),G1tensor(291),G1tensor(286),G1tensor(276),G1tensor(256),G1tensor(211),G1tensor(206),G1tensor(201),G1tensor(196) &
    ,G0tensor(664),G0tensor(118),G0tensor(92),G0tensor(420),G0tensor(340),G0tensor(235),G0tensor(40)])
  call ol_merge_tensors(G0tensor(806),[G0tensor(796),G0tensor(753),G0tensor(748),G0tensor(725),G0tensor(720),G0tensor(715) &
    ,G0tensor(710),G0tensor(705),G0tensor(700),G0tensor(695),G0tensor(690),G0tensor(665),G0tensor(660),G0tensor(655),G0tensor(650) &
    ,G0tensor(645),G0tensor(640),G0tensor(603),G0tensor(580),G0tensor(575),G0tensor(570),G0tensor(565),G0tensor(560),G0tensor(555) &
    ,G0tensor(550),G0tensor(528),G0tensor(523),G0tensor(302),G0tensor(228),G0tensor(172),G0tensor(379),G0tensor(157),G0tensor(296) &
    ,G0tensor(366),G0tensor(143),G0tensor(286),G0tensor(117),G0tensor(311),G0tensor(252),G0tensor(292),G0tensor(204),G0tensor(73) &
    ,G0tensor(146),G0tensor(58),G0tensor(294),G0tensor(432),G0tensor(31),G0tensor(189),G0tensor(416),G0tensor(399),G0tensor(371) &
    ,G0tensor(68),G0tensor(256),G0tensor(29),G0tensor(475),G0tensor(450),G0tensor(425),G0tensor(400),G0tensor(8),G0tensor(3) &
    ,G0tensor(370),G0tensor(345),G0tensor(320),G0tensor(295),G0tensor(270),G0tensor(245),G0tensor(70),G0tensor(45)])
  call ol_merge_tensors(G1tensor(271),[G1tensor(266),G1tensor(176),G1tensor(171),G1tensor(166),G1tensor(161),G1tensor(156) &
    ,G1tensor(151),G0tensor(410),G0tensor(385),G0tensor(6),G0tensor(365),G0tensor(290),G0tensor(55)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(70),G2tensor(132),G2tensor(273),G1tensor(376),G1tensor(311),G1tensor(306) &
    ,G1tensor(261),G0tensor(405),G0tensor(212),G0tensor(103),G0tensor(82),G0tensor(151),G0tensor(440),G0tensor(60)])
  call ol_merge_tensors(G1tensor(251),[G1tensor(246),G1tensor(221),G1tensor(216),G1tensor(146),G1tensor(141),G1tensor(136) &
    ,G1tensor(131),G0tensor(350),G0tensor(300),G0tensor(275),G0tensor(225),G0tensor(100),G0tensor(50),G0tensor(25),G0tensor(574) &
    ,G0tensor(564),G0tensor(554),G0tensor(527),G0tensor(202),G0tensor(122),G0tensor(319),G0tensor(78),G0tensor(265),G0tensor(240) &
    ,G0tensor(65)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(174),G0tensor(16),G0tensor(491),G0tensor(232),G0tensor(80)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(108),G0tensor(418),G0tensor(353),G0tensor(85)])
  call ol_merge_tensors(G0tensor(393),[G0tensor(313),G0tensor(165),G0tensor(90)])
  call ol_merge_tensors(G0tensor(397),[G0tensor(413),G0tensor(308),G0tensor(343),G0tensor(18),G0tensor(231),G0tensor(206) &
    ,G0tensor(170),G0tensor(95)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(177),G0tensor(127),G0tensor(11),G0tensor(487),G0tensor(105)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(67),G0tensor(422),G0tensor(337),G0tensor(110)])
  call ol_merge_tensors(G0tensor(428),[G0tensor(348),G0tensor(190),G0tensor(115)])
  call ol_merge_tensors(G0tensor(423),[G0tensor(448),G0tensor(452),G0tensor(332),G0tensor(269),G0tensor(244),G0tensor(461) &
    ,G0tensor(195),G0tensor(120)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(58),G0tensor(23),G0tensor(249),G0tensor(466),G0tensor(130)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(129),G0tensor(458),G0tensor(372),G0tensor(135)])
  call ol_merge_tensors(G0tensor(472),[G0tensor(417),G0tensor(215),G0tensor(140)])
  call ol_merge_tensors(G0tensor(488),[G0tensor(462),G0tensor(386),G0tensor(363),G0tensor(377),G0tensor(316),G0tensor(481) &
    ,G0tensor(220),G0tensor(145)])
  call ol_merge_tensors(G0tensor(388),[G0tensor(323),G0tensor(358),G0tensor(51),G0tensor(496),G0tensor(155)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(81),G2tensor(100),G2tensor(57),G2tensor(80),G0tensor(328),G0tensor(81) &
    ,G0tensor(160)])
  call ol_merge_tensors(G0tensor(407),[G0tensor(357),G0tensor(442),G0tensor(261),G0tensor(239),G0tensor(180)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(82),G2tensor(115),G2tensor(114),G2tensor(19),G0tensor(333),G0tensor(492) &
    ,G0tensor(185)])
  call ol_merge_tensors(G0tensor(453),[G0tensor(368),G0tensor(378),G0tensor(274),G0tensor(24),G0tensor(205)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(83),G2tensor(101),G2tensor(72),G2tensor(3),G0tensor(373),G0tensor(476) &
    ,G0tensor(210)])
  call ol_merge_tensors(G1tensor(191),[G0tensor(200),G0tensor(125),G0tensor(751),G0tensor(713),G0tensor(697),G0tensor(647) &
    ,G0tensor(547),G0tensor(520),G0tensor(281),G0tensor(306),G0tensor(106),G0tensor(287),G0tensor(171),G0tensor(390),G0tensor(5) &
    ,G0tensor(230)])
  call ol_merge_tensors(G0tensor(752),[G0tensor(747),G0tensor(569),G0tensor(158),G0tensor(36),G0tensor(260)])
  call ol_merge_tensors(G0tensor(688),[G0tensor(548),G0tensor(427),G0tensor(183),G0tensor(291),G0tensor(182),G0tensor(369) &
    ,G0tensor(352),G0tensor(191),G0tensor(499),G0tensor(330),G0tensor(305),G0tensor(280)])
  call ol_merge_tensors(G0tensor(692),[G0tensor(663),G0tensor(658),G0tensor(601),G0tensor(57),G0tensor(329),G0tensor(314) &
    ,G0tensor(494),G0tensor(460),G0tensor(435),G0tensor(285)])
  call ol_merge_tensors(G0tensor(707),[G0tensor(702),G0tensor(687),G0tensor(563),G0tensor(558),G0tensor(83),G0tensor(310)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(336),G1tensor(331),G1tensor(241),G1tensor(236),G1tensor(231),G1tensor(226) &
    ,G0tensor(9),G0tensor(602),G0tensor(579),G0tensor(326),G0tensor(395),G0tensor(7),G0tensor(2),G0tensor(315)])
  call ol_merge_tensors(G1tensor(351),[G0tensor(722),G0tensor(712),G0tensor(659),G0tensor(553),G0tensor(267),G0tensor(199) &
    ,G0tensor(335)])
  call ol_merge_tensors(G0tensor(642),[G0tensor(578),G0tensor(163),G0tensor(197),G0tensor(111),G0tensor(89),G0tensor(136) &
    ,G0tensor(64),G0tensor(317),G0tensor(394),G0tensor(54),G0tensor(46),G0tensor(360)])
  call ol_merge_tensors(G0tensor(745),[G0tensor(652),G0tensor(637),G0tensor(573),G0tensor(568),G0tensor(282),G0tensor(1)])
  call ol_merge_tensors(G1tensor(186),[G1tensor(181),G0tensor(75),G0tensor(746),G0tensor(717),G0tensor(708),G0tensor(142) &
    ,G0tensor(114),G0tensor(97),G0tensor(101),G0tensor(67),G0tensor(119),G0tensor(415)])
  call ol_merge_tensors(G1tensor(447),[G0tensor(714),G0tensor(709),G0tensor(559),G0tensor(148),G0tensor(98),G0tensor(445)])
  call ol_merge_tensors(G1tensor(432),[G0tensor(805),G0tensor(719),G0tensor(699),G0tensor(288),G0tensor(147),G0tensor(465)])
  call ol_merge_tensors(G0tensor(724),[G0tensor(704),G0tensor(684),G0tensor(654),G0tensor(634),G0tensor(178),G0tensor(152) &
    ,G0tensor(133),G0tensor(93),G0tensor(96),G0tensor(72),G0tensor(484),G0tensor(17),G0tensor(470)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(193),G0tensor(134),G0tensor(229),G0tensor(154),G0tensor(485)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(177),G0tensor(149),G0tensor(39),G0tensor(389),G0tensor(490)])
  call ol_merge_tensors(G0tensor(242),[G0tensor(243),G0tensor(94),G0tensor(69),G0tensor(219),G0tensor(259),G0tensor(43) &
    ,G0tensor(495)])
  call ol_merge_tensors(G1tensor(422),[G0tensor(273),G0tensor(99)])
  call ol_merge_tensors(G0tensor(782),[G0tensor(778),G0tensor(672),G0tensor(582),G0tensor(299),G0tensor(424),G0tensor(406) &
    ,G0tensor(479),G0tensor(184)])
  call ol_merge_tensors(G0tensor(668),[G0tensor(594),G0tensor(535),G0tensor(531),G0tensor(278),G0tensor(138),G0tensor(444) &
    ,G0tensor(34),G0tensor(48)])
  call ol_merge_tensors(G0tensor(801),[G0tensor(791),G0tensor(786),G0tensor(780),G0tensor(775),G0tensor(769),G0tensor(763) &
    ,G0tensor(758),G0tensor(743),G0tensor(737),G0tensor(731),G0tensor(685),G0tensor(680),G0tensor(675),G0tensor(670),G0tensor(635) &
    ,G0tensor(630),G0tensor(625),G0tensor(620),G0tensor(615),G0tensor(609),G0tensor(598),G0tensor(592),G0tensor(586),G0tensor(545) &
    ,G0tensor(539),G0tensor(533),G0tensor(518),G0tensor(512),G0tensor(506),G0tensor(500),G0tensor(482),G0tensor(223),G0tensor(218) &
    ,G0tensor(364),G0tensor(129),G0tensor(321),G0tensor(63),G0tensor(131),G0tensor(214),G0tensor(28),G0tensor(59),G0tensor(266) &
    ,G0tensor(451),G0tensor(434),G0tensor(411),G0tensor(436),G0tensor(91),G0tensor(196),G0tensor(469),G0tensor(474)])
  call ol_merge_tensors(G1tensor(427),[G0tensor(800),G0tensor(679),G0tensor(253),G0tensor(464)])
  call ol_merge_tensors(G1tensor(437),[G0tensor(203),G0tensor(76)])
  call ol_merge_tensors(G0tensor(765),[G0tensor(756),G0tensor(622),G0tensor(605),G0tensor(62),G0tensor(156),G0tensor(359) &
    ,G0tensor(79),G0tensor(41)])
  call ol_merge_tensors(G0tensor(618),[G0tensor(611),G0tensor(508),G0tensor(504),G0tensor(213),G0tensor(336),G0tensor(61) &
    ,G0tensor(161),G0tensor(186)])
  call ol_merge_tensors(G0tensor(790),[G0tensor(629),G0tensor(227),G0tensor(27)])
  call ol_merge_tensors(G0tensor(795),[G0tensor(649),G0tensor(384),G0tensor(192),G0tensor(181)])
  call ol_merge_tensors(G1tensor(341),[G0tensor(246),G0tensor(42)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(95),G2tensor(94),G2tensor(93),G2tensor(92),G2tensor(119),G2tensor(107) &
    ,G2tensor(105),G2tensor(117),G2tensor(104),G0tensor(307),G0tensor(268),G0tensor(431),G0tensor(426),G0tensor(401),G0tensor(396) &
    ,G0tensor(144),G0tensor(404)])
  call ol_merge_tensors(G0tensor(633),[G0tensor(628),G0tensor(341),G0tensor(164)])
  call ol_merge_tensors(G0tensor(653),[G0tensor(648),G0tensor(572),G0tensor(116),G0tensor(33),G0tensor(441)])
  call ol_merge_tensors(G1tensor(356),[G0tensor(263),G0tensor(446)])
  call ol_merge_tensors(G1tensor(361),[G0tensor(683),G0tensor(678),G0tensor(139),G0tensor(409)])
  call ol_merge_tensors(G1tensor(366),[G0tensor(703),G0tensor(698),G0tensor(662),G0tensor(562),G0tensor(354),G0tensor(121) &
    ,G0tensor(109)])
  call ol_merge_tensors(G0tensor(771),[G0tensor(761),G0tensor(588),G0tensor(251),G0tensor(77),G0tensor(429)])
  call ol_merge_tensors(G0tensor(727),[G0tensor(682),G0tensor(667),G0tensor(224),G0tensor(454)])
  call ol_merge_tensors(G0tensor(779),[G0tensor(762),G0tensor(757),G0tensor(733),G0tensor(166),G0tensor(176),G0tensor(449)])
  call ol_merge_tensors(G0tensor(739),[G0tensor(632),G0tensor(617),G0tensor(88),G0tensor(56)])
  call ol_merge_tensors(G0tensor(398),[G0tensor(392),G0tensor(303),G0tensor(86)])
  call ol_merge_tensors(G0tensor(433),[G0tensor(412),G0tensor(318),G0tensor(456)])
  call ol_merge_tensors(G0tensor(468),[G0tensor(457),G0tensor(362),G0tensor(471)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(210),G0tensor(403),G0tensor(254),G0tensor(301)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(30),G0tensor(438),G0tensor(21),G0tensor(12)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(195),G0tensor(467),G0tensor(382),G0tensor(14)])
  call ol_merge_tensors(G0tensor(175),[G0tensor(760),G0tensor(677),G0tensor(627),G0tensor(530),G0tensor(503),G0tensor(304) &
    ,G0tensor(174),G0tensor(53),G0tensor(38),G0tensor(137)])
  call ol_merge_tensors(G0tensor(773),[G0tensor(537),G0tensor(510),G0tensor(71)])
  call ol_merge_tensors(G0tensor(325),[G0tensor(250),G0tensor(735),G0tensor(613),G0tensor(596),G0tensor(590),G0tensor(543) &
    ,G0tensor(516),G0tensor(26)])
  call ol_merge_tensors(G0tensor(785),[G0tensor(774),G0tensor(768),G0tensor(742),G0tensor(736),G0tensor(730),G0tensor(614) &
    ,G0tensor(608),G0tensor(597),G0tensor(591),G0tensor(585),G0tensor(544),G0tensor(538),G0tensor(517),G0tensor(511),G0tensor(501) &
    ,G0tensor(498),G0tensor(108),G0tensor(279)])
  call ol_merge_tensors(G0tensor(804),[G0tensor(799),G0tensor(794),G0tensor(789),G0tensor(657),G0tensor(567),G0tensor(557) &
    ,G0tensor(271),G0tensor(237),G0tensor(264),G0tensor(356),G0tensor(339),G0tensor(128),G0tensor(209),G0tensor(289) &
    ,G0tensor(347)])
  call ol_merge_tensors(G0tensor(783),[G0tensor(772),G0tensor(766),G0tensor(740),G0tensor(734),G0tensor(728),G0tensor(107)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(417),G1tensor(371),G0tensor(430),G0tensor(4),G0tensor(606),G0tensor(589) &
    ,G0tensor(583),G0tensor(309)])
  call ol_merge_tensors(G0tensor(694),[G0tensor(689),G0tensor(674),G0tensor(669),G0tensor(644),G0tensor(639),G0tensor(624) &
    ,G0tensor(619),G0tensor(132)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(154),G2tensor(152),G2tensor(145),G0tensor(293),G0tensor(207),G0tensor(298) &
    ,G0tensor(258),G0tensor(208),G0tensor(168),G0tensor(283),G0tensor(222)])
  call ol_merge_tensors(G0tensor(150),[G0tensor(15),G0tensor(477)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(27),G1tensor(296),G1tensor(281),G0tensor(493)])
  call ol_merge_tensors(G0tensor(375),[G0tensor(10)])
  call ol_merge_tensors(G0tensor(788),[G0tensor(755),G0tensor(623),G0tensor(514),G0tensor(505)])
  call ol_merge_tensors(G0tensor(767),[G0tensor(515),G0tensor(509)])
  call ol_merge_tensors(G0tensor(793),[G0tensor(643),G0tensor(577),G0tensor(525),G0tensor(522)])
  call ol_merge_tensors(G0tensor(798),[G0tensor(777),G0tensor(673),G0tensor(541),G0tensor(532)])
  call ol_merge_tensors(G0tensor(784),[G0tensor(542),G0tensor(536)])
  call ol_merge_tensors(G0tensor(803),[G0tensor(723),G0tensor(718),G0tensor(693),G0tensor(600),G0tensor(552),G0tensor(549)])
  call ol_merge_tensors(G0tensor(729),[G0tensor(595),G0tensor(584)])
  call ol_merge_tensors(G0tensor(741),[G0tensor(612),G0tensor(607)])
call TI_bubble_red(G2tensor(143),20,mass2set(:,1),G0tensor(455),M2L1R1,G0tensor(480))
call TI_bubble_red(G2tensor(112),19,mass2set(:,1),G0tensor(226),M2L1R1,G0tensor(194))
call TI_bubble_red(G2tensor(126),28,mass2set(:,2),G0tensor(459),M2L1R1,G0tensor(489))
call TI_bubble_red(G2tensor(130),19,mass2set(:,2),G0tensor(19),M2L1R1,G0tensor(49))
call TI_bubble_red(G2tensor(61),28,mass2set(:,3),G0tensor(66),M2L1R1,G0tensor(124))
call TI_bubble_red(G2tensor(111),19,mass2set(:,3),G0tensor(52),M2L1R1,G0tensor(74))
call TI_bubble_red(G2tensor(127),28,mass2set(:,4),G0tensor(257),M2L1R1,G0tensor(159))
call TI_bubble_red(G2tensor(136),19,mass2set(:,4),G0tensor(374),M2L1R1,G0tensor(391))
call TI_bubble_red(G2tensor(84),20,mass2set(:,2),G0tensor(344),M2L1R1,G0tensor(421))
call TI_bubble_red(G2tensor(85),20,mass2set(:,3),G0tensor(414),M2L1R1,G0tensor(419))
call TI_bubble_red(G2tensor(88),20,mass2set(:,4),G0tensor(44),M2L1R1,G0tensor(439))
call TI_bubble_red(G2tensor(1),24,mass2set(:,1),G0tensor(277),M2L1R1,G0tensor(262))
call TI_bubble_red(G2tensor(204),20,mass2set(:,5),G0tensor(236),M2L1R1)
call TI_bubble_red(G2tensor(21),24,mass2set(:,2),G0tensor(84),M2L1R1,G0tensor(497))
call TI_bubble_red(G2tensor(5),24,mass2set(:,3),G0tensor(486),M2L1R1,G0tensor(102))
call TI_bubble_red(G2tensor(113),24,mass2set(:,4),G0tensor(13),M2L1R1,G0tensor(112))
call TI_bubble_red(G2tensor(159),19,mass2set(:,6),G0tensor(331),M2L1R1,G0tensor(22),G0tensor(502))
call TI_bubble_red(G2tensor(156),19,mass2set(:,5),G0tensor(507),M2L1R1)
call TI_bubble_red(G2tensor(89),20,mass2set(:,7),G0tensor(513),M2L1R1,G0tensor(346),G0tensor(519))
  call ol_merge_tensors(G0tensor(262),[G0tensor(194),G0tensor(806),G0tensor(480)])
  call ol_merge_tensors(G0tensor(497),[G0tensor(421),G0tensor(397),G0tensor(49),G0tensor(489)])
  call ol_merge_tensors(G0tensor(102),[G0tensor(419),G0tensor(423),G0tensor(74),G0tensor(124)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(439),G0tensor(488),G0tensor(391),G0tensor(159)])
  call ol_merge_tensors(G0tensor(346),[G0tensor(502),G0tensor(801)])
  call ol_merge_tensors(G0tensor(519),[G0tensor(22),G0tensor(785)])
call TI_bubble_red(G1tensor(271),28,mass2set(:,1),G0tensor(524),M2L1R1,G0tensor(529))
call TI_bubble_red(G1tensor(251),16,mass2set(:,1),G0tensor(534),M2L1R1,G0tensor(540))
call TI_bubble_red(G1tensor(191),27,mass2set(:,1),G0tensor(546),M2L1R1,G0tensor(551))
call TI_bubble_red(G1tensor(351),22,mass2set(:,8),G0tensor(447),M2L1R1,G0tensor(556))
call TI_bubble_red(G1tensor(186),23,mass2set(:,1),G0tensor(561),M2L1R1,G0tensor(284))
call TI_bubble_red(G1tensor(447),18,mass2set(:,8),G0tensor(566),M2L1R1,G0tensor(571))
call TI_bubble_red(G1tensor(432),17,mass2set(:,9),G0tensor(322),M2L1R1,G0tensor(576))
call TI_bubble_red(G1tensor(422),17,mass2set(:,5),G0tensor(37),M2L1R1)
call TI_bubble_red(G1tensor(427),17,mass2set(:,10),G0tensor(47),M2L1R1,G0tensor(581))
call TI_bubble_red(G1tensor(437),18,mass2set(:,5),G0tensor(587),M2L1R1)
call TI_bubble_red(G1tensor(341),22,mass2set(:,5),G0tensor(593),M2L1R1)
call TI_bubble_red(G1tensor(356),21,mass2set(:,5),G0tensor(126),M2L1R1)
call TI_bubble_red(G1tensor(361),21,mass2set(:,10),G0tensor(599),M2L1R1,G0tensor(169))
call TI_bubble_red(G1tensor(366),21,mass2set(:,9),G0tensor(604),M2L1R1,G0tensor(610))
call TI_bubble_red(G1tensor(346),22,mass2set(:,11),G0tensor(179),M2L1R1,G0tensor(141))
call TI_bubble_red(G1tensor(442),18,mass2set(:,11),G0tensor(616),M2L1R1,G0tensor(621))
  call ol_merge_tensors(G0tensor(610),[G0tensor(576),G0tensor(571),G0tensor(284),G0tensor(556),G0tensor(551),G0tensor(540) &
    ,G0tensor(529),G0tensor(262)])
  call ol_merge_tensors(G0tensor(621),[G0tensor(141),G0tensor(169),G0tensor(581),G0tensor(346)])
  call ol_merge_tensors(T0sum(268),[G0tensor(638)])
  call ol_merge_tensors(T0sum(269),[G0tensor(750)])
  call ol_merge_tensors(T0sum(270),[G0tensor(455)])
  call ol_merge_tensors(T0sum(271),[G0tensor(610)])
  call ol_merge_tensors(T0sum(272),[G0tensor(524)])
  call ol_merge_tensors(T0sum(273),[G0tensor(226)])
  call ol_merge_tensors(T0sum(274),[G0tensor(534)])
  call ol_merge_tensors(T0sum(275),[G0tensor(459)])
  call ol_merge_tensors(T0sum(276),[G0tensor(497)])
  call ol_merge_tensors(T0sum(277),[G0tensor(19)])
  call ol_merge_tensors(T0sum(278),[G0tensor(393)])
  call ol_merge_tensors(T0sum(279),[G0tensor(66)])
  call ol_merge_tensors(T0sum(280),[G0tensor(102)])
  call ol_merge_tensors(T0sum(281),[G0tensor(52)])
  call ol_merge_tensors(T0sum(282),[G0tensor(428)])
  call ol_merge_tensors(T0sum(283),[G0tensor(257)])
  call ol_merge_tensors(T0sum(284),[G0tensor(112)])
  call ol_merge_tensors(T0sum(285),[G0tensor(374)])
  call ol_merge_tensors(T0sum(286),[G0tensor(472)])
  call ol_merge_tensors(T0sum(287),[G0tensor(388)])
  call ol_merge_tensors(T0sum(288),[G0tensor(344)])
  call ol_merge_tensors(T0sum(289),[G0tensor(407)])
  call ol_merge_tensors(T0sum(290),[G0tensor(414)])
  call ol_merge_tensors(T0sum(291),[G0tensor(453)])
  call ol_merge_tensors(T0sum(292),[G0tensor(44)])
  call ol_merge_tensors(T0sum(293),[G0tensor(546)])
  call ol_merge_tensors(T0sum(294),[G0tensor(752)])
  call ol_merge_tensors(T0sum(295),[G0tensor(688)])
  call ol_merge_tensors(T0sum(296),[G0tensor(692)])
  call ol_merge_tensors(T0sum(297),[G0tensor(707)])
  call ol_merge_tensors(T0sum(298),[G0tensor(277)])
  call ol_merge_tensors(T0sum(299),[G0tensor(447)])
  call ol_merge_tensors(T0sum(300),[G0tensor(642)])
  call ol_merge_tensors(T0sum(301),[G0tensor(745)])
  call ol_merge_tensors(T0sum(302),[G0tensor(561)])
  call ol_merge_tensors(T0sum(303),[G0tensor(566)])
  call ol_merge_tensors(T0sum(304),[G0tensor(322)])
  call ol_merge_tensors(T0sum(305),[G0tensor(724)])
  call ol_merge_tensors(T0sum(306),[G0tensor(233)])
  call ol_merge_tensors(T0sum(307),[G0tensor(238)])
  call ol_merge_tensors(T0sum(308),[G0tensor(242)])
  call ol_merge_tensors(T0sum(309),[G0tensor(37)])
  call ol_merge_tensors(T0sum(310),[G0tensor(782)])
  call ol_merge_tensors(T0sum(311),[G0tensor(668)])
  call ol_merge_tensors(T0sum(312),[G0tensor(621)])
  call ol_merge_tensors(T0sum(313),[G0tensor(47)])
  call ol_merge_tensors(T0sum(314),[G0tensor(587)])
  call ol_merge_tensors(T0sum(315),[G0tensor(765)])
  call ol_merge_tensors(T0sum(316),[G0tensor(618)])
  call ol_merge_tensors(T0sum(317),[G0tensor(790)])
  call ol_merge_tensors(T0sum(318),[G0tensor(795)])
  call ol_merge_tensors(T0sum(319),[G0tensor(593)])
  call ol_merge_tensors(T0sum(320),[G0tensor(236)])
  call ol_merge_tensors(T0sum(321),[G0tensor(633)])
  call ol_merge_tensors(T0sum(322),[G0tensor(653)])
  call ol_merge_tensors(T0sum(323),[G0tensor(126)])
  call ol_merge_tensors(T0sum(324),[G0tensor(599)])
  call ol_merge_tensors(T0sum(325),[G0tensor(604)])
  call ol_merge_tensors(T0sum(326),[G0tensor(771)])
  call ol_merge_tensors(T0sum(327),[G0tensor(727)])
  call ol_merge_tensors(T0sum(328),[G0tensor(779)])
  call ol_merge_tensors(T0sum(329),[G0tensor(739)])
  call ol_merge_tensors(T0sum(330),[G0tensor(398)])
  call ol_merge_tensors(T0sum(331),[G0tensor(433)])
  call ol_merge_tensors(T0sum(332),[G0tensor(468)])
  call ol_merge_tensors(T0sum(333),[G0tensor(84)])
  call ol_merge_tensors(T0sum(334),[G0tensor(486)])
  call ol_merge_tensors(T0sum(335),[G0tensor(13)])
  call ol_merge_tensors(T0sum(336),[G0tensor(175)])
  call ol_merge_tensors(T0sum(337),[G0tensor(773)])
  call ol_merge_tensors(T0sum(338),[G0tensor(325)])
  call ol_merge_tensors(T0sum(339),[G0tensor(519)])
  call ol_merge_tensors(T0sum(340),[G0tensor(804)])
  call ol_merge_tensors(T0sum(341),[G0tensor(783)])
  call ol_merge_tensors(T0sum(342),[G0tensor(331)])
  call ol_merge_tensors(T0sum(343),[G0tensor(694)])
  call ol_merge_tensors(T0sum(344),[G0tensor(507)])
  call ol_merge_tensors(T0sum(345),[G0tensor(150)])
  call ol_merge_tensors(T0sum(346),[G0tensor(513)])
  call ol_merge_tensors(T0sum(347),[G0tensor(478)])
  call ol_merge_tensors(T0sum(348),[G0tensor(375)])
  call ol_merge_tensors(T0sum(349),[G0tensor(20)])
  call ol_merge_tensors(T0sum(350),[G0tensor(788)])
  call ol_merge_tensors(T0sum(351),[G0tensor(767)])
  call ol_merge_tensors(T0sum(352),[G0tensor(793)])
  call ol_merge_tensors(T0sum(353),[G0tensor(798)])
  call ol_merge_tensors(T0sum(354),[G0tensor(784)])
  call ol_merge_tensors(T0sum(355),[G0tensor(803)])
  call ol_merge_tensors(T0sum(356),[G0tensor(729)])
  call ol_merge_tensors(T0sum(357),[G0tensor(741)])
  call ol_merge_tensors(T0sum(358),[G0tensor(179)])
  call ol_merge_tensors(T0sum(359),[G0tensor(616)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_48,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_66,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_60,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_60,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_49,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_43,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_58,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_54,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_54,RedSet_4(4),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_43,RedSet_4(5),ScalarBoxes(10))
  call compute_scalar_box([ 18, 19, 27 ],masses2_45,RedSet_4(6),ScalarBoxes(11))
  call compute_scalar_box([ 16, 19, 27 ],masses2_65,RedSet_4(7),ScalarBoxes(12))
  call compute_scalar_box([ 16, 18, 27 ],masses2_59,RedSet_4(8),ScalarBoxes(13))
  call compute_scalar_box([ 2, 3, 11 ],masses2_46,RedSet_4(9),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_43,RedSet_4(6),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_58,RedSet_4(7),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_54,RedSet_4(8),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_43,RedSet_4(9),ScalarBoxes(18))
  call compute_scalar_box([ 17, 19, 23 ],masses2_48,RedSet_4(10),ScalarBoxes(19))
  call compute_scalar_box([ 16, 17, 23 ],masses2_60,RedSet_4(11),ScalarBoxes(20))
  call compute_scalar_box([ 16, 17, 19 ],masses2_60,RedSet_4(12),ScalarBoxes(21))
  call compute_scalar_box([ 1, 3, 7 ],masses2_49,RedSet_4(13),ScalarBoxes(22))
  call compute_scalar_box([ 17, 19, 23 ],masses2_43,RedSet_4(10),ScalarBoxes(23))
  call compute_scalar_box([ 16, 17, 23 ],masses2_54,RedSet_4(11),ScalarBoxes(24))
  call compute_scalar_box([ 16, 17, 19 ],masses2_54,RedSet_4(12),ScalarBoxes(25))
  call compute_scalar_box([ 1, 3, 7 ],masses2_43,RedSet_4(13),ScalarBoxes(26))
  call compute_scalar_box([ 17, 19, 27 ],masses2_45,RedSet_4(14),ScalarBoxes(27))
  call compute_scalar_box([ 16, 17, 27 ],masses2_59,RedSet_4(15),ScalarBoxes(28))
  call compute_scalar_box([ 1, 3, 11 ],masses2_46,RedSet_4(16),ScalarBoxes(29))
  call compute_scalar_box([ 17, 19, 27 ],masses2_43,RedSet_4(14),ScalarBoxes(30))
  call compute_scalar_box([ 16, 17, 27 ],masses2_54,RedSet_4(15),ScalarBoxes(31))
  call compute_scalar_box([ 1, 3, 11 ],masses2_43,RedSet_4(16),ScalarBoxes(32))
  call compute_scalar_box([ 20, 21, 23 ],masses2_60,RedSet_4(17),ScalarBoxes(33))
  call compute_scalar_box([ 16, 21, 23 ],masses2_60,RedSet_4(18),ScalarBoxes(34))
  call compute_scalar_box([ 16, 20, 23 ],masses2_66,RedSet_4(19),ScalarBoxes(35))
  call compute_scalar_box([ 16, 20, 21 ],masses2_63,RedSet_4(20),ScalarBoxes(36))
  call compute_scalar_box([ 4, 5, 7 ],masses2_61,RedSet_4(21),ScalarBoxes(37))
  call compute_scalar_box([ 20, 21, 23 ],masses2_54,RedSet_4(17),ScalarBoxes(38))
  call compute_scalar_box([ 16, 21, 23 ],masses2_54,RedSet_4(18),ScalarBoxes(39))
  call compute_scalar_box([ 16, 20, 23 ],masses2_58,RedSet_4(19),ScalarBoxes(40))
  call compute_scalar_box([ 16, 20, 21 ],masses2_56,RedSet_4(20),ScalarBoxes(41))
  call compute_scalar_box([ 4, 5, 7 ],masses2_54,RedSet_4(21),ScalarBoxes(42))
  call compute_scalar_box([ 20, 22, 23 ],masses2_60,RedSet_4(22),ScalarBoxes(43))
  call compute_scalar_box([ 16, 22, 23 ],masses2_60,RedSet_4(23),ScalarBoxes(44))
  call compute_scalar_box([ 16, 20, 22 ],masses2_63,RedSet_4(24),ScalarBoxes(45))
  call compute_scalar_box([ 4, 6, 7 ],masses2_61,RedSet_4(25),ScalarBoxes(46))
  call compute_scalar_box([ 20, 22, 23 ],masses2_54,RedSet_4(22),ScalarBoxes(47))
  call compute_scalar_box([ 16, 22, 23 ],masses2_54,RedSet_4(23),ScalarBoxes(48))
  call compute_scalar_box([ 16, 20, 22 ],masses2_56,RedSet_4(24),ScalarBoxes(49))
  call compute_scalar_box([ 4, 6, 7 ],masses2_54,RedSet_4(25),ScalarBoxes(50))
  call compute_scalar_box([ 18, 26, 27 ],masses2_40,RedSet_4(26),ScalarBoxes(51))
  call compute_scalar_box([ 16, 26, 27 ],masses2_54,RedSet_4(27),ScalarBoxes(52))
  call compute_scalar_box([ 16, 18, 26 ],masses2_53,RedSet_4(28),ScalarBoxes(53))
  call compute_scalar_box([ 2, 10, 11 ],masses2_40,RedSet_4(29),ScalarBoxes(54))
  call compute_scalar_box([ 17, 25, 27 ],masses2_40,RedSet_4(30),ScalarBoxes(55))
  call compute_scalar_box([ 16, 25, 27 ],masses2_54,RedSet_4(31),ScalarBoxes(56))
  call compute_scalar_box([ 16, 17, 25 ],masses2_53,RedSet_4(32),ScalarBoxes(57))
  call compute_scalar_box([ 1, 9, 11 ],masses2_40,RedSet_4(33),ScalarBoxes(58))
  call compute_scalar_box([ 18, 22, 23 ],masses2_62,RedSet_4(34),ScalarBoxes(59))
  call compute_scalar_box([ 16, 22, 23 ],masses2_44,RedSet_4(23),ScalarBoxes(60))
  call compute_scalar_box([ 16, 18, 23 ],masses2_44,RedSet_4(3),ScalarBoxes(61))
  call compute_scalar_box([ 16, 18, 22 ],masses2_47,RedSet_4(35),ScalarBoxes(62))
  call compute_scalar_box([ 2, 6, 7 ],masses2_62,RedSet_4(36),ScalarBoxes(63))
  call compute_scalar_box([ 18, 22, 23 ],masses2_55,RedSet_4(34),ScalarBoxes(64))
  call compute_scalar_box([ 16, 22, 23 ],masses2_41,RedSet_4(23),ScalarBoxes(65))
  call compute_scalar_box([ 16, 18, 23 ],masses2_41,RedSet_4(3),ScalarBoxes(66))
  call compute_scalar_box([ 16, 18, 22 ],masses2_42,RedSet_4(35),ScalarBoxes(67))
  call compute_scalar_box([ 2, 6, 7 ],masses2_55,RedSet_4(36),ScalarBoxes(68))
  call compute_scalar_box([ 17, 21, 23 ],masses2_62,RedSet_4(37),ScalarBoxes(69))
  call compute_scalar_box([ 16, 21, 23 ],masses2_44,RedSet_4(18),ScalarBoxes(70))
  call compute_scalar_box([ 16, 17, 23 ],masses2_44,RedSet_4(11),ScalarBoxes(71))
  call compute_scalar_box([ 16, 17, 21 ],masses2_47,RedSet_4(38),ScalarBoxes(72))
  call compute_scalar_box([ 1, 5, 7 ],masses2_62,RedSet_4(39),ScalarBoxes(73))
  call compute_scalar_box([ 17, 21, 23 ],masses2_55,RedSet_4(37),ScalarBoxes(74))
  call compute_scalar_box([ 16, 21, 23 ],masses2_41,RedSet_4(18),ScalarBoxes(75))
  call compute_scalar_box([ 16, 17, 23 ],masses2_41,RedSet_4(11),ScalarBoxes(76))
  call compute_scalar_box([ 16, 17, 21 ],masses2_42,RedSet_4(38),ScalarBoxes(77))
  call compute_scalar_box([ 1, 5, 7 ],masses2_55,RedSet_4(39),ScalarBoxes(78))
  call compute_scalar_box([ 17, 21, 29 ],masses2_57,RedSet_4(40),ScalarBoxes(79))
  call compute_scalar_box([ 16, 21, 29 ],masses2_42,RedSet_4(41),ScalarBoxes(80))
  call compute_scalar_box([ 16, 17, 29 ],masses2_42,RedSet_4(42),ScalarBoxes(81))
  call compute_scalar_box([ 1, 5, 13 ],masses2_57,RedSet_4(43),ScalarBoxes(82))
  call compute_scalar_box([ 17, 25, 29 ],masses2_57,RedSet_4(44),ScalarBoxes(83))
  call compute_scalar_box([ 16, 25, 29 ],masses2_42,RedSet_4(45),ScalarBoxes(84))
  call compute_scalar_box([ 16, 17, 25 ],masses2_42,RedSet_4(32),ScalarBoxes(85))
  call compute_scalar_box([ 1, 9, 13 ],masses2_57,RedSet_4(46),ScalarBoxes(86))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphvv_ew_uuxhzz_1_/**/REALKIND
