
module ol_vamp_1_pphvv_ew_uuxhaz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_ew_uuxhaz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_ew_uuxhaz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_ew_uuxhaz_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_ew_uuxhaz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphvv_ew_uuxhaz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_uuxhaz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(1),m3h3x8(:,1),heltab2x24(:,:,1))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(1),m3h3x8(:,2),heltab2x24(:,:,2))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(2),m3h3x8(:,3),heltab2x24(:,:,3))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(2),m3h3x8(:,4),heltab2x24(:,:,4))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(3),m3h3x8(:,5),heltab2x24(:,:,5))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(3),m3h3x8(:,6),heltab2x24(:,:,6))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(4),m3h3x8(:,7),heltab2x24(:,:,7))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(4),m3h3x8(:,8),heltab2x24(:,:,8))
  Gcoeff(:)%j = (c(96)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(5),m3h3x8(:,9),heltab2x24(:,:,9))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(5),m3h3x8(:,10),heltab2x24(:,:,10))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(6),m3h3x8(:,11),heltab2x24(:,:,11))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(12),h0tab(:,12),[16,4,2,1,8],[nMW,nMW,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(6),m3h3x8(:,12),heltab2x24(:,:,12))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(13),h0tab(:,13),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(7),m3h3x8(:,13),heltab2x24(:,:,13))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(14),h0tab(:,14),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(7),m3h3x8(:,14),heltab2x24(:,:,14))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(15),h0tab(:,15),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(8),m3h3x8(:,15),heltab2x24(:,:,15))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(16),h0tab(:,16),[16,2,1,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(8),m3h3x8(:,16),heltab2x24(:,:,16))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(17),h0tab(:,17),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(9),m3h3x8(:,17),heltab2x24(:,:,17))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(18),h0tab(:,18),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(9),m3h3x8(:,18),heltab2x24(:,:,18))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(19),h0tab(:,19),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(10),m3h3x8(:,19),heltab2x24(:,:,19))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(20),h0tab(:,20),[16,1,2,4,8],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(10),m3h3x8(:,20),heltab2x24(:,:,20))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(21),h0tab(:,21),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(11),m3h3x8(:,21),heltab2x24(:,:,21))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(22),h0tab(:,22),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(11),m3h3x8(:,22),heltab2x24(:,:,22))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(23),h0tab(:,23),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(12),m3h3x8(:,23),heltab2x24(:,:,23))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(24),h0tab(:,24),[16,1,2,8,4],[nMW,0,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(12),m3h3x8(:,24),heltab2x24(:,:,24))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(25),h0tab(:,25),[16,2,4,1,8],[0,nMZ,nMZ,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(13),ngZu,m3h3x8(:,25),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(13),16,0,G1H8(13),n2h8(1))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(26),h0tab(:,26),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(13),ngZd,m3h3x8(:,26),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G0H8(13),16,0,G1H8(14),n2h8(2))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(27),h0tab(:,27),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(13),m3h3x8(:,27),heltab2x24(:,:,27))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(28),h0tab(:,28),[16,2,8,1,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(15),m3h3x8(:,28),heltab2x24(:,:,28))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(29),h0tab(:,29),[16,1,4,2,8],[0,nMZ,nMZ,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(14),ngZu,m3h3x8(:,29),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(14),16,0,G1H8(16),n2h8(3))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(30),h0tab(:,30),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(14),ngZd,m3h3x8(:,30),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(14),16,0,G1H8(17),n2h8(4))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(31),h0tab(:,31),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(14),ngZd,m3h3x8(:,31),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(14),16,0,G1H8(18),n2h8(5))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(32),h0tab(:,32),[16,1,4,8,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(14),ngZd,m3h3x8(:,32),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(14),16,0,G1H8(19),n2h8(6))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(33),h0tab(:,33),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(14),m3h3x8(:,33),heltab2x24(:,:,33))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(34),h0tab(:,34),[16,1,8,2,4],[nMW,0,0,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(20),m3h3x8(:,34),heltab2x24(:,:,34))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(35),h0tab(:,35),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(15),ngZd,m3h3x8(:,35),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(15),16,0,G1H8(21),n2h8(7))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(36),h0tab(:,36),[16,1,8,4,2],[0,nMW,nMW,nMW,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(15),ngZd,m3h3x8(:,36),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(15),16,0,G1H8(22),n2h8(8))
  call Hloop_ST_V(ntryL,G1H8(1),16,ex3(:),4,G2H8(1),m3h1x8(:,1),heltab2x8(:,:,1))
  call Hloop_ST_V(ntryL,G0H8(1),16,ex3(:),4,G1H8(1),m3h1x8(:,2),heltab2x8(:,:,2))
  call Hloop_VS_V(ntryL,G0H8(2),ex3(:),G0H8(15),m3h1x8(:,3),heltab2x8(:,:,3))
  call Hloop_VS_V(ntryL,G1H8(2),ex3(:),G1H8(23),m3h1x8(:,4),heltab2x8(:,:,4))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,1),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),18,0,G1H4(1),n2h4(1))
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(2),m3h2x4(:,2),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(2),18,0,G2H4(1),n2h4(2))
  call Hloop_WA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),m3h2x4(:,3),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),18,0,G1H4(2),n2h4(3))
  call Hloop_WA_Q(ntryL,G1H8(4),ex2(:),G1H4(3),m3h2x4(:,4),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(3),18,0,G2H4(2),n2h4(4))
  call Hloop_ST_V(ntryL,G1H8(5),16,ex3(:),4,G2H8(2),m3h1x8(:,5),heltab2x8(:,:,9))
  call Hloop_ST_V(ntryL,G0H8(5),16,ex3(:),4,G1H8(2),m3h1x8(:,6),heltab2x8(:,:,10))
  call Hloop_VS_V(ntryL,G0H8(6),ex3(:),G0H8(1),m3h1x8(:,7),heltab2x8(:,:,11))
  call Hloop_VS_V(ntryL,G1H8(6),ex3(:),G1H8(3),m3h1x8(:,8),heltab2x8(:,:,12))
  call Hloop_WA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G0H4(1),18,0,G1H4(3),n2h4(5))
  call Hloop_WA_Q(ntryL,G1H8(7),ex2(:),G1H4(4),m3h2x4(:,6),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(4),18,0,G2H4(3),n2h4(6))
  call Hloop_WA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G0H4(1),18,0,G1H4(4),n2h4(7))
  call Hloop_WA_Q(ntryL,G1H8(8),ex2(:),G1H4(5),m3h2x4(:,8),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(5),18,0,G2H4(4),n2h4(8))
  call Hloop_WQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H4(1),17,0,G1H4(5),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(6),m3h2x4(:,10),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(6),17,0,G2H4(5),n2h4(10))
  call Hloop_WQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G0H4(1),17,0,G1H4(6),n2h4(11))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(7),m3h2x4(:,12),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(7),17,0,G2H4(6),n2h4(12))
  call Hloop_WQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),m3h2x4(:,13),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),17,0,G1H4(7),n2h4(13))
  call Hloop_WQ_A(ntryL,G1H8(11),ex1(:),G1H4(8),m3h2x4(:,14),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(8),17,0,G2H4(7),n2h4(14))
  call Hloop_WQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,15),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),17,0,G1H4(8),n2h4(15))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(9),m3h2x4(:,16),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(9),17,0,G2H4(8),n2h4(16))
  call Hloop_QA_Z(ntryL,G1H8(13),ex2(:),G1H4(9),ngZu,m3h2x4(:,17),heltab2x8(:,:,25))
  call Hloop_QA_W(ntryL,G1H8(14),ex2(:),G1H4(10),m3h2x4(:,18),heltab2x8(:,:,26))
  call Hloop_WA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,19),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G0H4(1),18,0,G1H4(11),n2h4(17))
  call Hloop_WA_Q(ntryL,G1H8(15),ex2(:),G1H4(12),m3h2x4(:,20),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(12),18,0,G2H4(9),n2h4(18))
  call Hloop_AQ_Z(ntryL,G1H8(16),ex1(:),G1H4(12),ngZu,m3h2x4(:,21),heltab2x8(:,:,29))
  call Hloop_AQ_W(ntryL,G1H8(17),ex1(:),G1H4(13),m3h2x4(:,22),heltab2x8(:,:,30))
  call Hloop_AQ_W(ntryL,G1H8(18),ex1(:),G1H4(14),m3h2x4(:,23),heltab2x8(:,:,31))
  call Hloop_AQ_W(ntryL,G1H8(19),ex1(:),G1H4(15),m3h2x4(:,24),heltab2x8(:,:,32))
  call Hloop_WQ_A(ntryL,G0H8(14),ex1(:),G0H4(1),m3h2x4(:,25),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),17,0,G1H4(16),n2h4(19))
  call Hloop_WQ_A(ntryL,G1H8(20),ex1(:),G1H4(17),m3h2x4(:,26),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(17),17,0,G2H4(10),n2h4(20))
  call Hloop_AQ_W(ntryL,G1H8(21),ex1(:),G1H4(17),m3h2x4(:,27),heltab2x8(:,:,35))
  call Hloop_AQ_W(ntryL,G1H8(22),ex1(:),G1H4(18),m3h2x4(:,28),heltab2x8(:,:,36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(2)])
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(4),G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(5),8,8)
  call Hloop_WQ_A(ntryL,G1H8(23),ex1(:),G1H4(19),m3h2x4(:,29),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(19),21,0,G2H4(11),n2h4(21))
  call Hloop_AQ_W(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_W(ntryL,G2H4(1),ex1(:),G2H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_W(ntryL,G1H4(2),ex1(:),G1H2(2),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_W(ntryL,G2H4(2),ex1(:),G2H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(2),mass5set(:,1),  & 
G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(11),8,8)
  call Hloop_WA_Q(ntryL,G1H8(3),ex2(:),G1H4(19),m3h2x4(:,30),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(19),22,0,G2H4(1),n2h4(22))
  call Hloop_AQ_W(ntryL,G1H4(3),ex1(:),G1H2(3),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G2H4(3),ex1(:),G2H2(3),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_W(ntryL,G1H4(4),ex1(:),G1H2(4),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_W(ntryL,G2H4(4),ex1(:),G2H2(4),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_W(ntryL,G1H4(5),ex2(:),G1H2(5),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_W(ntryL,G2H4(5),ex2(:),G2H2(5),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_W(ntryL,G1H4(6),ex2(:),G1H2(6),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_W(ntryL,G2H4(6),ex2(:),G2H2(6),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_W(ntryL,G1H4(7),ex2(:),G1H2(7),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_W(ntryL,G2H4(7),ex2(:),G2H2(7),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_W(ntryL,G1H4(8),ex2(:),G1H2(8),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_W(ntryL,G2H4(8),ex2(:),G2H2(8),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VS_V(ntryL,G1H4(9),ex3(:),G1H4(1),m3h1x4(:,1),heltab2x4(:,:,17))
  call Hloop_VS_V(ntryL,G1H4(10),ex3(:),G1H4(2),m3h1x4(:,2),heltab2x4(:,:,18))
  call Hloop_AV_Q(ntryL,G1H4(11),ex4(:),G1H2(9),m3h2x2(:,17),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(9),26,0,G2H2(9),n2h2(1))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,2),  & 
G1H4(19),G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(7),4)
  call HG1shiftOLR(G1H4(3),4,4)
  call Hloop_VS_V(ntryL,G1H4(12),ex3(:),G1H4(8),m3h1x4(:,3),heltab2x4(:,:,20))
  call Hloop_VS_V(ntryL,G1H4(13),ex3(:),G1H4(9),m3h1x4(:,4),heltab2x4(:,:,21))
  call Hloop_VT_S(ntryL,G1H4(14),17,ex3(:),4,G2H4(2),m3h1x4(:,5),heltab2x4(:,:,22))
  call Hloop_VS_V(ntryL,G1H4(15),ex3(:),G1H4(10),m3h1x4(:,6),heltab2x4(:,:,23))
  call Hloop_QV_A(ntryL,G1H4(16),ex4(:),G1H2(9),m3h2x2(:,18),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(9),25,0,G2H2(10),n2h2(2))
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),4,4)
  call Hloop_VV_S(ntryL,G1H4(17),ex4(:),G1H2(9),m3h2x2(:,19),heltab2x4(:,:,25))
  call Hloop_UW_V(ntryL,G1H4(18),17,ex4(:),8,G2H2(11),m3h2x2(:,20),heltab2x4(:,:,26))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(17),m3h2x4(:,31),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(17),21,0,G2H4(3),n2h4(23))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(5),ex4(:),G1H4(18),m3h2x4(:,32),heltab2x8(:,:,40))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(17),m3h2x4(:,33),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(17),21,0,G2H4(4),n2h4(24))
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(17),m3h2x4(:,34),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(17),21,0,G2H4(5),n2h4(25))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(17),m3h2x4(:,35),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(17),21,0,G2H4(6),n2h4(26))
  call Hloop_WA_Q(ntryL,G1H8(10),ex2(:),G1H4(17),m3h2x4(:,36),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(17),22,0,G2H4(7),n2h4(27))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(11),ex4(:),G1H4(17),m3h2x4(:,37),heltab2x8(:,:,45))
  call Hloop_WA_Q(ntryL,G1H8(13),ex2(:),G1H4(20),m3h2x4(:,38),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(20),22,0,G2H4(8),n2h4(28))
  call Hloop_WA_Q(ntryL,G1H8(14),ex2(:),G1H4(20),m3h2x4(:,39),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(20),22,0,G2H4(9),n2h4(29))
  call Hloop_WA_Q(ntryL,G1H8(15),ex2(:),G1H4(20),m3h2x4(:,40),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(20),22,0,G2H4(10),n2h4(30))
  call Hloop_AV_Q(ntryL,G1H4(19),ex4(:),G1H2(10),m3h2x2(:,21),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(10),26,0,G2H2(12),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(3),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_VS_V(ntryL,G1H4(3),ex3(:),G1H4(20),m3h1x4(:,7),heltab2x4(:,:,28))
  call Hloop_AV_Q(ntryL,G1H4(5),ex4(:),G1H2(10),m3h2x2(:,22),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(10),26,0,G2H2(13),n2h2(4))
  call Hloop_AV_Q(ntryL,G1H4(6),ex4(:),G1H2(10),m3h2x2(:,23),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(10),26,0,G2H2(14),n2h2(5))
  call Hloop_AV_Q(ntryL,G1H4(7),ex4(:),G1H2(10),m3h2x2(:,24),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(10),26,0,G2H2(15),n2h2(6))
  call Hloop_QV_A(ntryL,G1H4(11),ex4(:),G1H2(10),m3h2x2(:,25),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(10),25,0,G2H2(16),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_VS_V(ntryL,G1H4(12),ex3(:),G1H4(19),m3h1x4(:,8),heltab2x4(:,:,33))
  call Hloop_QV_A(ntryL,G1H4(14),ex4(:),G1H2(10),m3h2x2(:,26),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(10),25,0,G2H2(17),n2h2(8))
  call Hloop_QV_A(ntryL,G1H4(15),ex4(:),G1H2(10),m3h2x2(:,27),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(10),25,0,G2H2(18),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(16),ex4(:),G1H2(10),m3h2x2(:,28),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(10),25,0,G2H2(19),n2h2(10))
  call Hloop_QA_W(ntryL,G2H4(11),ex2(:),G2H2(20),m3h2x2(:,29),heltab2x4(:,:,37))
  call Hloop_VT_S(ntryL,G1H2(1),19,ex3(:),4,G2H2(21),m3h1x2(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,3),  & 
G1H2(10),G1H2(1),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hloop_VS_V(ntryL,G1H2(2),ex3(:),G1H2(15),m3h1x2(:,2),heltab2x2(:,:,2))
  call Hloop_VS_V(ntryL,G2H2(2),ex3(:),G2H2(1),m3h1x2(:,3),heltab2x2(:,:,3))
  call Hloop_AQ_W(ntryL,G2H4(1),ex1(:),G2H2(2),m3h2x2(:,30),heltab2x4(:,:,38))
  call Hloop_VV_S(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,4))
  call Hloop_VV_S(ntryL,G2H2(3),ex4(:),G2H1(1),m3h2x1(:,2),heltab2x2(:,:,5))
  call Hloop_UW_V(ntryL,G1H2(4),19,ex4(:),8,G2H1(2),m3h2x1(:,3),heltab2x2(:,:,6))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(6),mass5set(:,3),  & 
G1H2(2),G1H2(3),G1H2(4),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(3),4,2)
  call Hloop_VT_S(ntryL,G1H2(5),19,ex3(:),4,G2H2(3),m3h1x2(:,4),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(7),mass5set(:,3),  & 
G1H2(5),G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
  call HG1shiftOLR(G1H2(19),8,2)
  call Hloop_VS_V(ntryL,G1H2(6),ex3(:),G1H2(24),m3h1x2(:,5),heltab2x2(:,:,8))
  call Hloop_VS_V(ntryL,G2H2(6),ex3(:),G2H2(4),m3h1x2(:,6),heltab2x2(:,:,9))
  call Hloop_VV_S(ntryL,G1H2(7),ex4(:),G1H1(2),m3h2x1(:,4),heltab2x2(:,:,10))
  call Hloop_VV_S(ntryL,G2H2(7),ex4(:),G2H1(3),m3h2x1(:,5),heltab2x2(:,:,11))
  call Hloop_UV_W(ntryL,G1H2(8),19,ex4(:),8,G2H1(4),m3h2x1(:,6),heltab2x2(:,:,12))
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(8),mass5set(:,3),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(7),4,2)
  call Hloop_ZQ_A(ntryL,G1H4(1),ex1(:),G1H2(28),ngZu,m3h2x2(:,31),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(28),23,0,G2H2(5),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(2),ex1(:),G1H2(28),m3h2x2(:,32),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(28),23,0,G2H2(6),n2h2(12))
  call Hloop_AQ_W(ntryL,G2H2(9),ex1(:),G2H1(5),m3h2x1(:,7),heltab2x2(:,:,13))
  call Hloop_ZA_Q(ntryL,G1H4(8),ex2(:),G1H2(28),ngZu,m3h2x2(:,33),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(28),23,0,G2H2(7),n2h2(13))
  call Hloop_WA_Q(ntryL,G1H4(9),ex2(:),G1H2(28),m3h2x2(:,34),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(28),23,0,G2H2(8),n2h2(14))
  call Hloop_SV_V(ntryL,G2H4(2),ex4(:),G2H2(9),m3h2x2(:,35),heltab2x4(:,:,43))
  call Hloop_UW_V(ntryL,G1H4(10),21,ex4(:),8,G2H2(22),m3h2x2(:,36),heltab2x4(:,:,44))
  call Hloop_QA_W(ntryL,G2H2(10),ex2(:),G2H1(6),m3h2x1(:,8),heltab2x2(:,:,14))
  call Hloop_ST_V(ntryL,G1H2(9),25,ex3(:),4,G2H2(10),m3h1x2(:,7),heltab2x2(:,:,15))
  call Hloop_VS_V(ntryL,G2H2(11),ex3(:),G2H2(23),m3h1x2(:,8),heltab2x2(:,:,16))
  call Hloop_QA_W(ntryL,G2H4(3),ex2(:),G2H2(11),m3h2x2(:,37),heltab2x4(:,:,45))
  call Hloop_QA_W(ntryL,G2H4(5),ex2(:),G2H2(24),m3h2x2(:,38),heltab2x4(:,:,46))
  call Hloop_QA_W(ntryL,G2H4(6),ex2(:),G2H2(25),m3h2x2(:,39),heltab2x4(:,:,47))
  call Hloop_AQ_W(ntryL,G2H4(7),ex1(:),G2H2(26),m3h2x2(:,40),heltab2x4(:,:,48))
  call Hloop_AQ_W(ntryL,G2H4(9),ex1(:),G2H2(27),m3h2x2(:,41),heltab2x4(:,:,49))
  call Hloop_AQ_W(ntryL,G2H4(10),ex1(:),G2H2(28),m3h2x2(:,42),heltab2x4(:,:,50))
  call Hloop_AQ_W(ntryL,G2H2(12),ex1(:),G2H1(7),m3h2x1(:,9),heltab2x2(:,:,17))
  call Hloop_AQ_W(ntryL,G2H2(14),ex1(:),G2H1(8),m3h2x1(:,10),heltab2x2(:,:,18))
  call Hloop_AQ_W(ntryL,G2H2(15),ex1(:),G2H1(9),m3h2x1(:,11),heltab2x2(:,:,19))
  call Hloop_QA_W(ntryL,G2H2(16),ex2(:),G2H1(10),m3h2x1(:,12),heltab2x2(:,:,20))
  call Hloop_QA_W(ntryL,G2H2(18),ex2(:),G2H1(11),m3h2x1(:,13),heltab2x2(:,:,21))
  call Hloop_QA_W(ntryL,G2H2(19),ex2(:),G2H1(12),m3h2x1(:,14),heltab2x2(:,:,22))
  call Hloop_VT_S(ntryL,G1H2(10),19,ex3(:),4,G2H2(12),m3h1x2(:,9),heltab2x2(:,:,23))
call HGT_raise_alpha_OLR(G1H2(1),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(1),ex4(:),G1H1(3),m3h2x1(:,15),heltab2x2(:,:,24))
  call Hloop_VT_S(ntryL,G1H2(13),19,ex3(:),4,G2H2(14),m3h1x2(:,10),heltab2x2(:,:,25))
  call Hloop_VT_S(ntryL,G1H2(14),19,ex3(:),4,G2H2(15),m3h1x2(:,11),heltab2x2(:,:,26))
  call Hloop_UW_V(ntryL,G1H2(2),19,ex4(:),8,G2H1(13),m3h2x1(:,16),heltab2x2(:,:,27))
call HGT_raise_alpha_OLR(G1H2(3),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(3),ex3(:),G1H2(28),m3h1x2(:,12),heltab2x2(:,:,28))
  call Hloop_UW_V(ntryL,G1H2(17),19,ex4(:),8,G2H1(14),m3h2x1(:,17),heltab2x2(:,:,29))
  call Hloop_UW_V(ntryL,G1H2(18),19,ex4(:),8,G2H1(15),m3h2x1(:,18),heltab2x2(:,:,30))
  call Hloop_VT_S(ntryL,G1H2(5),19,ex3(:),4,G2H2(16),m3h1x2(:,13),heltab2x2(:,:,31))
call HGT_raise_alpha_OLR(G1H2(19),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(19),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(19),ex4(:),G1H1(4),m3h2x1(:,19),heltab2x2(:,:,32))
  call Hloop_VT_S(ntryL,G1H2(22),19,ex3(:),4,G2H2(18),m3h1x2(:,14),heltab2x2(:,:,33))
  call Hloop_VT_S(ntryL,G1H2(23),19,ex3(:),4,G2H2(19),m3h1x2(:,15),heltab2x2(:,:,34))
  call Hloop_UV_W(ntryL,G1H2(6),19,ex4(:),8,G2H1(16),m3h2x1(:,20),heltab2x2(:,:,35))
call HGT_raise_alpha_OLR(G1H2(7),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(7),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(7),ex3(:),G1H2(9),m3h1x2(:,16),heltab2x2(:,:,36))
  call Hloop_UV_W(ntryL,G1H2(26),19,ex4(:),8,G2H1(17),m3h2x1(:,21),heltab2x2(:,:,37))
  call Hloop_UV_W(ntryL,G1H2(27),19,ex4(:),8,G2H1(18),m3h2x1(:,22),heltab2x2(:,:,38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(10)])
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(1),mass5set(:,1),  & 
G1H2(10),G1H2(1),G1H2(13),G1H2(14),G1H2(2),G1H2(3),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(5),mass5set(:,3),  & 
G1H2(17),G1H2(18),G1H2(5),G1H2(19),G1H2(22),G1H2(23),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(15),ex4(:),G1tensor(1),m3h2x1(:,23),heltab2x2(:,:,39))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,3),  & 
G1H2(6),G1H2(7),G1H2(26),G1H2(27),G1H2(15),G1H2(29),2)
  call HG1shiftOLR(G1H2(7),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,1),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(31),8,2)
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(1),ex3(:),G1tensor(2),m3h1x1(:,1),heltab2x1(:,:,1))
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(6),mass5set(:,3),  & 
G1H1(1),G1H1(5),G1H1(6),G1H1(7),G1H1(8),G1H1(9),1)
  call HG1shiftOLR(G1H1(5),4,1)
  call Hotf_5pt_reduction(G2H1(2),RedSet_5(6),mass5set(:,3),  & 
G1H1(10),G1H1(11),G1H1(12),G1H1(13),G1H1(14),G1H1(15),1)
  call HG1shiftOLR(G1H1(11),4,1)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(7),mass5set(:,3),  & 
G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),2)
  call HG1shiftOLR(G1H2(37),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(24),ex4(:),G1tensor(3),m3h2x1(:,24),heltab2x2(:,:,40))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(7),mass5set(:,3),  & 
G1H2(24),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),8,2)
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(2),ex3(:),G1tensor(4),m3h1x1(:,2),heltab2x1(:,:,2))
  call Hotf_5pt_reduction(G2H1(3),RedSet_5(8),mass5set(:,3),  & 
G1H1(2),G1H1(16),G1H1(17),G1H1(18),G1H1(19),G1H1(20),1)
  call HG1shiftOLR(G1H1(16),4,1)
  call Hotf_5pt_reduction(G2H1(4),RedSet_5(8),mass5set(:,3),  & 
G1H1(21),G1H1(22),G1H1(23),G1H1(24),G1H1(25),G1H1(26),1)
  call HG1shiftOLR(G1H1(22),4,1)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,4),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(9),mass5set(:,5),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(3),mass5set(:,2),  & 
G1H1(27),G1H1(28),G1H1(29),G1H1(30),G1H1(31),G1H1(32),1)
  call HG1shiftOLR(G1H1(28),4,1)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,4),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(10),mass5set(:,5),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
  call HG1shiftOLR(G1H2(66),8,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(11),mass5set(:,6),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(72),2,2)
  call Hotf_5pt_reduction(G2H1(6),RedSet_5(4),mass5set(:,2),  & 
G1H1(33),G1H1(34),G1H1(35),G1H1(36),G1H1(37),G1H1(38),1)
  call HG1shiftOLR(G1H1(34),4,1)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(12),mass5set(:,6),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
  call HG1shiftOLR(G1H2(78),2,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(1),m3h2x1(:,25),heltab2x2(:,:,41))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(2),m3h2x1(:,26),heltab2x2(:,:,42))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(3),m3h2x1(:,27),heltab2x2(:,:,43))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(4),m3h2x1(:,28),heltab2x2(:,:,44))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(7),ex3(:),G2tensor(5),m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(9),ex3(:),G2tensor(6),m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex3(:),G2tensor(7),m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(12),ex3(:),G2tensor(8),m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(9),m3h2x1(:,29),heltab2x2(:,:,45))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(10),m3h2x1(:,30),heltab2x2(:,:,46))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(13),ex3(:),G2tensor(11),m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(15),ex3(:),G2tensor(12),m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(13),m3h2x1(:,31),heltab2x2(:,:,47))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(14),m3h2x1(:,32),heltab2x2(:,:,48))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(15),m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(16),m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),23,ex4(:),8,G2tensor(17),m3h2x1(:,33),heltab2x2(:,:,49))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1),0,ex4(:),8,G2tensor(18),m3h2x1(:,34),heltab2x2(:,:,50))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(3),23,ex4(:),8,G2tensor(19),m3h2x1(:,35),heltab2x2(:,:,51))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(17),23,ex4(:),8,G2tensor(20),m3h2x1(:,36),heltab2x2(:,:,52))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(18),0,ex4(:),8,G2tensor(21),m3h2x1(:,37),heltab2x2(:,:,53))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(23),23,ex4(:),8,G2tensor(22),m3h2x1(:,38),heltab2x2(:,:,54))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(6),23,ex4(:),8,G2tensor(23),m3h2x1(:,39),heltab2x2(:,:,55))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(7),0,ex4(:),8,G2tensor(24),m3h2x1(:,40),heltab2x2(:,:,56))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(29),23,ex4(:),8,G2tensor(25),m3h2x1(:,41),heltab2x2(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(30),23,ex4(:),8,G2tensor(26),m3h2x1(:,42),heltab2x2(:,:,58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(31),0,ex4(:),8,G2tensor(27),m3h2x1(:,43),heltab2x2(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(35),23,ex4(:),8,G2tensor(28),m3h2x1(:,44),heltab2x2(:,:,60))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(1),27,ex3(:),4,G2tensor(29),m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(5),0,ex3(:),4,G2tensor(30),m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(9),27,ex3(:),4,G2tensor(31),m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(10),27,ex3(:),4,G2tensor(32),m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(11),0,ex3(:),4,G2tensor(33),m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(15),27,ex3(:),4,G2tensor(34),m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(36),23,ex4(:),8,G2tensor(35),m3h2x1(:,45),heltab2x2(:,:,61))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(37),0,ex4(:),8,G2tensor(36),m3h2x1(:,46),heltab2x2(:,:,62))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(41),23,ex4(:),8,G2tensor(37),m3h2x1(:,47),heltab2x2(:,:,63))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(24),23,ex4(:),8,G2tensor(38),m3h2x1(:,48),heltab2x2(:,:,64))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(42),0,ex4(:),8,G2tensor(39),m3h2x1(:,49),heltab2x2(:,:,65))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(46),23,ex4(:),8,G2tensor(40),m3h2x1(:,50),heltab2x2(:,:,66))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(2),27,ex3(:),4,G2tensor(41),m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(16),0,ex3(:),4,G2tensor(42),m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(43),m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(21),27,ex3(:),4,G2tensor(44),m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(22),0,ex3(:),4,G2tensor(45),m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(26),27,ex3(:),4,G2tensor(46),m3h1x1(:,22),heltab2x1(:,:,22))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(48),ex4(:),G1H1(5),m3h2x1(:,52),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),8,0,G2tensor(48),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(9),m3h2x1(:,53),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,0,G2tensor(49),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(10),m3h2x1(:,54),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,0,G2tensor(50),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(54),ex4(:),G1H1(11),m3h2x1(:,55),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),8,0,G2tensor(51),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(58),ex4(:),G1H1(15),m3h2x1(:,56),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),31,0,G2tensor(52),n2h1(16))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(27),27,ex3(:),4,G2tensor(53),m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(28),0,ex3(:),4,G2tensor(54),m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(32),27,ex3(:),4,G2tensor(55),m3h1x1(:,25),heltab2x1(:,:,25))
  call Hloop_AV_Q(ntryL,G1H2(59),ex4(:),G1H1(2),m3h2x1(:,57),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,0,G2tensor(56),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(16),m3h2x1(:,58),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),8,0,G2tensor(57),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(64),ex4(:),G1H1(20),m3h2x1(:,59),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,0,G2tensor(58),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(65),ex4(:),G1H1(21),m3h2x1(:,60),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,0,G2tensor(59),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(66),ex4(:),G1H1(22),m3h2x1(:,61),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),8,0,G2tensor(60),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(70),ex4(:),G1H1(26),m3h2x1(:,62),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),31,0,G2tensor(61),n2h1(23))
  call Hloop_WA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(24))
  call Hloop_WA_Q(ntryL,G1H2(72),ex2(:),G1H1(5),m3h2x1(:,64),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),2,0,G2tensor(63),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(76),ex2(:),G1H1(9),m3h2x1(:,65),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,0,G2tensor(64),n2h1(26))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(33),27,ex3(:),4,G2tensor(65),m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(34),0,ex3(:),4,G2tensor(66),m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(38),27,ex3(:),4,G2tensor(67),m3h1x1(:,28),heltab2x1(:,:,28))
  call Hloop_WA_Q(ntryL,G1H2(77),ex2(:),G1H1(10),m3h2x1(:,66),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,0,G2tensor(68),n2h1(28))
  call Hloop_WA_Q(ntryL,G1H2(78),ex2(:),G1H1(11),m3h2x1(:,67),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),2,0,G2tensor(69),n2h1(29))
  call Hloop_WA_Q(ntryL,G1H2(82),ex2(:),G1H1(15),m3h2x1(:,68),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(15),31,0,G2tensor(70),n2h1(30))
  call ol_merge_tensors(G2tensor(23),[G2tensor(20),G2tensor(9),G1tensor(1)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(29),G2tensor(11),G1tensor(2)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(35),G2tensor(13),G1tensor(3)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(41),G2tensor(15),G1tensor(4)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(7)])
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(5),mass5set(:,3),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(6),mass5set(:,3),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(7),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(8),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(2),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(4),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(9),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(9),mass5set(:,5),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(10),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(10),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(11),mass5set(:,6),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(68),RedSet_5(12),mass5set(:,6),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(37),h0tab(:,37),[24,2,1,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(1),m4h3x2x4(:,1),heltab3x24(:,:,1))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(38),h0tab(:,38),[24,1,2,4],[nMW,0,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(2),m4h3x2x4(:,2),heltab3x24(:,:,2))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(39),h0tab(:,39),[20,2,1,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(2),m4h1x3x8(:,1),heltab3x24(:,:,3))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(40),h0tab(:,40),[20,1,2,8],[nMW,0,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(3),m4h1x3x8(:,2),heltab3x24(:,:,4))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(41),h0tab(:,41),[16,1,2,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(4),m3h3x8(:,37),heltab2x24(:,:,37))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(42),h0tab(:,42),[16,2,1,12],[nMW,0,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(5),m3h3x8(:,38),heltab2x24(:,:,38))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(43),h0tab(:,43),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(6),ngZl,m3h3x8(:,39),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(6),16,nML,G1H8(16),n2h8(11))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(44),h0tab(:,44),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(7),ngZl,m3h3x8(:,40),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(7),16,nML,G1H8(17),n2h8(12))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(45),h0tab(:,45),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(8),ngZu,m3h3x8(:,41),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G0H8(8),16,nMT,G1H8(18),n2h8(13))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(46),h0tab(:,46),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(9),ngZu,m3h3x8(:,42),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(9),16,nMT,G1H8(19),n2h8(14))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(47),h0tab(:,47),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(10),ngZd,m3h3x8(:,43),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G0H8(10),16,nMB,G1H8(20),n2h8(15))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(48),h0tab(:,48),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(11),ngZd,m3h3x8(:,44),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G0H8(11),16,nMB,G1H8(21),n2h8(16))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(49),h0tab(:,49),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(12),ngZl,m3h3x8(:,45),heltab2x24(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(12),16,nML,G1H8(22),n2h8(17))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(50),h0tab(:,50),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(13),ngZl,m3h3x8(:,46),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G0H8(13),16,nML,G1H8(1),n2h8(18))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(51),h0tab(:,51),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(14),ngZu,m3h3x8(:,47),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(14),16,nMT,G1H8(2),n2h8(19))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(52),h0tab(:,52),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(15),ngZu,m3h3x8(:,48),heltab2x24(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(15),16,nMT,G1H8(23),n2h8(20))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(53),h0tab(:,53),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(1),ngZd,m3h3x8(:,49),heltab2x24(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(3),n2h8(21))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(54),h0tab(:,54),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(6),ngZd,m3h3x8(:,50),heltab2x24(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(6),16,nMB,G1H8(4),n2h8(22))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(55),h0tab(:,55),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(5),m3h3x8(:,51),heltab2x24(:,:,51))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(56),h0tab(:,56),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(7),m3h3x8(:,52),heltab2x24(:,:,52))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(57),h0tab(:,57),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(8),m3h3x8(:,53),heltab2x24(:,:,53))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(58),h0tab(:,58),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(9),m3h3x8(:,54),heltab2x24(:,:,54))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(59),h0tab(:,59),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(10),m3h3x8(:,55),heltab2x24(:,:,55))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(60),h0tab(:,60),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(11),m3h3x8(:,56),heltab2x24(:,:,56))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(61),h0tab(:,61),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(13),m3h3x8(:,57),heltab2x24(:,:,57))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(62),h0tab(:,62),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(14),m3h3x8(:,58),heltab2x24(:,:,58))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(63),h0tab(:,63),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(15),m3h3x8(:,59),heltab2x24(:,:,59))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(64),h0tab(:,64),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(24),m3h3x8(:,60),heltab2x24(:,:,60))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(65),h0tab(:,65),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(25),m3h3x8(:,61),heltab2x24(:,:,61))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(66),h0tab(:,66),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(26),m3h3x8(:,62),heltab2x24(:,:,62))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(67),h0tab(:,67),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(27),m3h3x8(:,63),heltab2x24(:,:,63))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(68),h0tab(:,68),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(28),m3h3x8(:,64),heltab2x24(:,:,64))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(69),h0tab(:,69),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(29),m3h3x8(:,65),heltab2x24(:,:,65))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(70),h0tab(:,70),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(30),m3h3x8(:,66),heltab2x24(:,:,66))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(71),h0tab(:,71),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(7),m3h3x8(:,67),heltab2x24(:,:,67))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(72),h0tab(:,72),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(8),m3h3x8(:,68),heltab2x24(:,:,68))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(73),h0tab(:,73),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(9),m3h3x8(:,69),heltab2x24(:,:,69))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(74),h0tab(:,74),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(10),m3h3x8(:,70),heltab2x24(:,:,70))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(75),h0tab(:,75),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(31),m3h3x8(:,71),heltab2x24(:,:,71))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(76),h0tab(:,76),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(32),m3h3x8(:,72),heltab2x24(:,:,72))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(77),h0tab(:,77),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(33),m3h3x8(:,73),heltab2x24(:,:,73))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(78),h0tab(:,78),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(34),m3h3x8(:,74),heltab2x24(:,:,74))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(79),h0tab(:,79),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(11),m3h3x8(:,75),heltab2x24(:,:,75))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(80),h0tab(:,80),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(12),m3h3x8(:,76),heltab2x24(:,:,76))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(13),m3h3x8(:,77),heltab2x24(:,:,77))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(14),m3h3x8(:,78),heltab2x24(:,:,78))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(35),m3h3x8(:,79),heltab2x24(:,:,79))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(36),m3h3x8(:,80),heltab2x24(:,:,80))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(37),m3h3x8(:,81),heltab2x24(:,:,81))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(38),m3h3x8(:,82),heltab2x24(:,:,82))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(15),m3h3x8(:,83),heltab2x24(:,:,83))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(88),h0tab(:,88),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(1),m3h3x8(:,84),heltab2x24(:,:,84))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(6),m3h3x8(:,85),heltab2x24(:,:,85))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(90),h0tab(:,90),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(16),m3h3x8(:,86),heltab2x24(:,:,86))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(39),m3h3x8(:,87),heltab2x24(:,:,87))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(92),h0tab(:,92),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(40),m3h3x8(:,88),heltab2x24(:,:,88))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(93),h0tab(:,93),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(41),m3h3x8(:,89),heltab2x24(:,:,89))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(94),h0tab(:,94),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(42),m3h3x8(:,90),heltab2x24(:,:,90))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(95),h0tab(:,95),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(17),m3h3x8(:,91),heltab2x24(:,:,91))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(96),h0tab(:,96),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(18),m3h3x8(:,92),heltab2x24(:,:,92))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(97),h0tab(:,97),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(19),m3h3x8(:,93),heltab2x24(:,:,93))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(98),h0tab(:,98),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(20),m3h3x8(:,94),heltab2x24(:,:,94))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(99),h0tab(:,99),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(21),m3h3x8(:,95),heltab2x24(:,:,95))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(100),h0tab(:,100),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(22),m3h3x8(:,96),heltab2x24(:,:,96))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(101),h0tab(:,101),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(23),m3h3x8(:,97),heltab2x24(:,:,97))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(102),h0tab(:,102),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(24),m3h3x8(:,98),heltab2x24(:,:,98))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(103),h0tab(:,103),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(43),m3h3x8(:,99),heltab2x24(:,:,99))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(104),h0tab(:,104),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(44),m3h3x8(:,100),heltab2x24(:,:,100))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(105),h0tab(:,105),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(45),m3h3x8(:,101),heltab2x24(:,:,101))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(106),h0tab(:,106),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(46),m3h3x8(:,102),heltab2x24(:,:,102))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(107),h0tab(:,107),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(25),m3h3x8(:,103),heltab2x24(:,:,103))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(108),h0tab(:,108),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(26),m3h3x8(:,104),heltab2x24(:,:,104))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(109),h0tab(:,109),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(27),m3h3x8(:,105),heltab2x24(:,:,105))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(110),h0tab(:,110),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(28),m3h3x8(:,106),heltab2x24(:,:,106))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(111),h0tab(:,111),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(47),m3h3x8(:,107),heltab2x24(:,:,107))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(112),h0tab(:,112),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(48),m3h3x8(:,108),heltab2x24(:,:,108))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(113),h0tab(:,113),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(49),m3h3x8(:,109),heltab2x24(:,:,109))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(114),h0tab(:,114),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(50),m3h3x8(:,110),heltab2x24(:,:,110))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(115),h0tab(:,115),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(29),m3h3x8(:,111),heltab2x24(:,:,111))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(116),h0tab(:,116),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(30),m3h3x8(:,112),heltab2x24(:,:,112))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(117),h0tab(:,117),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(31),m3h3x8(:,113),heltab2x24(:,:,113))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(118),h0tab(:,118),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(32),m3h3x8(:,114),heltab2x24(:,:,114))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(119),h0tab(:,119),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(51),m3h3x8(:,115),heltab2x24(:,:,115))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(120),h0tab(:,120),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(52),m3h3x8(:,116),heltab2x24(:,:,116))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(121),h0tab(:,121),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(53),m3h3x8(:,117),heltab2x24(:,:,117))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(122),h0tab(:,122),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(54),m3h3x8(:,118),heltab2x24(:,:,118))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(123),h0tab(:,123),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(33),m3h3x8(:,119),heltab2x24(:,:,119))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(124),h0tab(:,124),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(34),m3h3x8(:,120),heltab2x24(:,:,120))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(125),h0tab(:,125),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(35),m3h3x8(:,121),heltab2x24(:,:,121))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(126),h0tab(:,126),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(36),m3h3x8(:,122),heltab2x24(:,:,122))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(127),h0tab(:,127),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZl,m3h3x8(:,123),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G0H8(37),16,nML,G1H8(55),n2h8(23))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(128),h0tab(:,128),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(37),ngZl,m3h3x8(:,124),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G0H8(37),16,nML,G1H8(56),n2h8(24))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(129),h0tab(:,129),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZu,m3h3x8(:,125),heltab2x24(:,:,125))
  call Hloop_A_Q(ntryL,G0H8(37),16,nMT,G1H8(57),n2h8(25))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(130),h0tab(:,130),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(37),ngZu,m3h3x8(:,126),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G0H8(37),16,nMT,G1H8(58),n2h8(26))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(131),h0tab(:,131),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZd,m3h3x8(:,127),heltab2x24(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(37),16,nMB,G1H8(59),n2h8(27))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(132),h0tab(:,132),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(37),ngZd,m3h3x8(:,128),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G0H8(37),16,nMB,G1H8(60),n2h8(28))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(133),h0tab(:,133),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZl,m3h3x8(:,129),heltab2x24(:,:,129))
  call Hloop_A_Q(ntryL,G0H8(37),16,nML,G1H8(61),n2h8(29))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(134),h0tab(:,134),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(37),ngZl,m3h3x8(:,130),heltab2x24(:,:,130))
  call Hloop_Q_A(ntryL,G0H8(37),16,nML,G1H8(62),n2h8(30))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(135),h0tab(:,135),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZu,m3h3x8(:,131),heltab2x24(:,:,131))
  call Hloop_A_Q(ntryL,G0H8(37),16,nMT,G1H8(63),n2h8(31))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(136),h0tab(:,136),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(37),ngZu,m3h3x8(:,132),heltab2x24(:,:,132))
  call Hloop_Q_A(ntryL,G0H8(37),16,nMT,G1H8(64),n2h8(32))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(137),h0tab(:,137),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZd,m3h3x8(:,133),heltab2x24(:,:,133))
  call Hloop_A_Q(ntryL,G0H8(37),16,nMB,G1H8(65),n2h8(33))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(138),h0tab(:,138),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(37),ngZd,m3h3x8(:,134),heltab2x24(:,:,134))
  call Hloop_Q_A(ntryL,G0H8(37),16,nMB,G1H8(66),n2h8(34))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(139),h0tab(:,139),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(67),m3h3x8(:,135),heltab2x24(:,:,135))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(140),h0tab(:,140),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(68),m3h3x8(:,136),heltab2x24(:,:,136))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(141),h0tab(:,141),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(69),m3h3x8(:,137),heltab2x24(:,:,137))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(142),h0tab(:,142),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(70),m3h3x8(:,138),heltab2x24(:,:,138))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(143),h0tab(:,143),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(71),m3h3x8(:,139),heltab2x24(:,:,139))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(144),h0tab(:,144),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(72),m3h3x8(:,140),heltab2x24(:,:,140))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(145),h0tab(:,145),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(73),m3h3x8(:,141),heltab2x24(:,:,141))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(146),h0tab(:,146),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(74),m3h3x8(:,142),heltab2x24(:,:,142))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(147),h0tab(:,147),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(75),m3h3x8(:,143),heltab2x24(:,:,143))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(148),h0tab(:,148),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(76),m3h3x8(:,144),heltab2x24(:,:,144))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(149),h0tab(:,149),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(77),m3h3x8(:,145),heltab2x24(:,:,145))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(150),h0tab(:,150),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(78),m3h3x8(:,146),heltab2x24(:,:,146))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(151),h0tab(:,151),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(79),m3h3x8(:,147),heltab2x24(:,:,147))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(152),h0tab(:,152),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(80),m3h3x8(:,148),heltab2x24(:,:,148))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(153),h0tab(:,153),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(81),m3h3x8(:,149),heltab2x24(:,:,149))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(154),h0tab(:,154),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(82),m3h3x8(:,150),heltab2x24(:,:,150))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(155),h0tab(:,155),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(37),m3h3x8(:,151),heltab2x24(:,:,151))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(156),h0tab(:,156),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(38),m3h3x8(:,152),heltab2x24(:,:,152))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(157),h0tab(:,157),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(39),m3h3x8(:,153),heltab2x24(:,:,153))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(158),h0tab(:,158),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(40),m3h3x8(:,154),heltab2x24(:,:,154))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(159),h0tab(:,159),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(41),m3h3x8(:,155),heltab2x24(:,:,155))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(160),h0tab(:,160),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(42),m3h3x8(:,156),heltab2x24(:,:,156))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(43),m3h3x8(:,157),heltab2x24(:,:,157))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(162),h0tab(:,162),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(44),m3h3x8(:,158),heltab2x24(:,:,158))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(163),h0tab(:,163),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(83),m3h3x8(:,159),heltab2x24(:,:,159))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(164),h0tab(:,164),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(84),m3h3x8(:,160),heltab2x24(:,:,160))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(165),h0tab(:,165),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(85),m3h3x8(:,161),heltab2x24(:,:,161))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(166),h0tab(:,166),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(86),m3h3x8(:,162),heltab2x24(:,:,162))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(167),h0tab(:,167),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(87),m3h3x8(:,163),heltab2x24(:,:,163))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(168),h0tab(:,168),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(88),m3h3x8(:,164),heltab2x24(:,:,164))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(169),h0tab(:,169),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(89),m3h3x8(:,165),heltab2x24(:,:,165))
  Gcoeff(:)%j = (c(116)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(170),h0tab(:,170),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(90),m3h3x8(:,166),heltab2x24(:,:,166))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(171),h0tab(:,171),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(91),m3h3x8(:,167),heltab2x24(:,:,167))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(172),h0tab(:,172),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(92),m3h3x8(:,168),heltab2x24(:,:,168))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(173),h0tab(:,173),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(93),m3h3x8(:,169),heltab2x24(:,:,169))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(174),h0tab(:,174),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(94),m3h3x8(:,170),heltab2x24(:,:,170))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(175),h0tab(:,175),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(45),m3h3x8(:,171),heltab2x24(:,:,171))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(176),h0tab(:,176),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(46),m3h3x8(:,172),heltab2x24(:,:,172))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(177),h0tab(:,177),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(47),m3h3x8(:,173),heltab2x24(:,:,173))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(178),h0tab(:,178),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(48),m3h3x8(:,174),heltab2x24(:,:,174))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(179),h0tab(:,179),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(49),m3h3x8(:,175),heltab2x24(:,:,175))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(180),h0tab(:,180),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(50),m3h3x8(:,176),heltab2x24(:,:,176))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(181),h0tab(:,181),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(51),m3h3x8(:,177),heltab2x24(:,:,177))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(182),h0tab(:,182),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(52),m3h3x8(:,178),heltab2x24(:,:,178))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(183),h0tab(:,183),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(53),m3h3x8(:,179),heltab2x24(:,:,179))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(184),h0tab(:,184),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(54),m3h3x8(:,180),heltab2x24(:,:,180))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(185),h0tab(:,185),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(55),m3h3x8(:,181),heltab2x24(:,:,181))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(186),h0tab(:,186),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(56),m3h3x8(:,182),heltab2x24(:,:,182))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(187),h0tab(:,187),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(57),m3h3x8(:,183),heltab2x24(:,:,183))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(188),h0tab(:,188),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(58),m3h3x8(:,184),heltab2x24(:,:,184))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(189),h0tab(:,189),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(59),m3h3x8(:,185),heltab2x24(:,:,185))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(190),h0tab(:,190),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(60),m3h3x8(:,186),heltab2x24(:,:,186))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(191),h0tab(:,191),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(95),m3h3x8(:,187),heltab2x24(:,:,187))
  Gcoeff(:)%j = (c(106)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(192),h0tab(:,192),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(96),m3h3x8(:,188),heltab2x24(:,:,188))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(193),h0tab(:,193),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(97),m3h3x8(:,189),heltab2x24(:,:,189))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(194),h0tab(:,194),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(98),m3h3x8(:,190),heltab2x24(:,:,190))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(195),h0tab(:,195),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(99),m3h3x8(:,191),heltab2x24(:,:,191))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(196),h0tab(:,196),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(100),m3h3x8(:,192),heltab2x24(:,:,192))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(197),h0tab(:,197),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(101),m3h3x8(:,193),heltab2x24(:,:,193))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(198),h0tab(:,198),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(102),m3h3x8(:,194),heltab2x24(:,:,194))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(199),h0tab(:,199),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(103),m3h3x8(:,195),heltab2x24(:,:,195))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(200),h0tab(:,200),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(104),m3h3x8(:,196),heltab2x24(:,:,196))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(201),h0tab(:,201),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(105),m3h3x8(:,197),heltab2x24(:,:,197))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(202),h0tab(:,202),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(106),m3h3x8(:,198),heltab2x24(:,:,198))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(203),h0tab(:,203),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(61),m3h3x8(:,199),heltab2x24(:,:,199))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(204),h0tab(:,204),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(62),m3h3x8(:,200),heltab2x24(:,:,200))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(205),h0tab(:,205),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(63),m3h3x8(:,201),heltab2x24(:,:,201))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(206),h0tab(:,206),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(64),m3h3x8(:,202),heltab2x24(:,:,202))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(207),h0tab(:,207),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(65),m3h3x8(:,203),heltab2x24(:,:,203))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(208),h0tab(:,208),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(66),m3h3x8(:,204),heltab2x24(:,:,204))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(209),h0tab(:,209),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(67),m3h3x8(:,205),heltab2x24(:,:,205))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(210),h0tab(:,210),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(68),m3h3x8(:,206),heltab2x24(:,:,206))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(211),h0tab(:,211),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZl,m3h3x8(:,207),heltab2x24(:,:,207))
  call Hloop_Q_A(ntryL,G0H8(69),16,nML,G1H8(107),n2h8(35))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(212),h0tab(:,212),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZl,m3h3x8(:,208),heltab2x24(:,:,208))
  call Hloop_A_Q(ntryL,G0H8(69),16,nML,G1H8(108),n2h8(36))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(213),h0tab(:,213),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,209),heltab2x24(:,:,209))
  call Hloop_Q_A(ntryL,G0H8(69),16,nMT,G1H8(109),n2h8(37))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(214),h0tab(:,214),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,210),heltab2x24(:,:,210))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMT,G1H8(110),n2h8(38))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(215),h0tab(:,215),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZd,m3h3x8(:,211),heltab2x24(:,:,211))
  call Hloop_Q_A(ntryL,G0H8(69),16,nMB,G1H8(111),n2h8(39))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(216),h0tab(:,216),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZd,m3h3x8(:,212),heltab2x24(:,:,212))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(112),n2h8(40))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(217),h0tab(:,217),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZl,m3h3x8(:,213),heltab2x24(:,:,213))
  call Hloop_Q_A(ntryL,G0H8(69),16,nML,G1H8(113),n2h8(41))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(218),h0tab(:,218),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZl,m3h3x8(:,214),heltab2x24(:,:,214))
  call Hloop_A_Q(ntryL,G0H8(69),16,nML,G1H8(114),n2h8(42))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(219),h0tab(:,219),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,215),heltab2x24(:,:,215))
  call Hloop_Q_A(ntryL,G0H8(69),16,nMT,G1H8(115),n2h8(43))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(220),h0tab(:,220),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,216),heltab2x24(:,:,216))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMT,G1H8(116),n2h8(44))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(221),h0tab(:,221),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZd,m3h3x8(:,217),heltab2x24(:,:,217))
  call Hloop_Q_A(ntryL,G0H8(69),16,nMB,G1H8(117),n2h8(45))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(222),h0tab(:,222),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZd,m3h3x8(:,218),heltab2x24(:,:,218))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(118),n2h8(46))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(223),h0tab(:,223),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(119),m3h3x8(:,219),heltab2x24(:,:,219))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(224),h0tab(:,224),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(120),m3h3x8(:,220),heltab2x24(:,:,220))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(225),h0tab(:,225),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(121),m3h3x8(:,221),heltab2x24(:,:,221))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(226),h0tab(:,226),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(122),m3h3x8(:,222),heltab2x24(:,:,222))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(227),h0tab(:,227),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(123),m3h3x8(:,223),heltab2x24(:,:,223))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(228),h0tab(:,228),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(124),m3h3x8(:,224),heltab2x24(:,:,224))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(229),h0tab(:,229),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(125),m3h3x8(:,225),heltab2x24(:,:,225))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(230),h0tab(:,230),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(126),m3h3x8(:,226),heltab2x24(:,:,226))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(231),h0tab(:,231),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(127),m3h3x8(:,227),heltab2x24(:,:,227))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(232),h0tab(:,232),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(128),m3h3x8(:,228),heltab2x24(:,:,228))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(233),h0tab(:,233),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(129),m3h3x8(:,229),heltab2x24(:,:,229))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(234),h0tab(:,234),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(130),m3h3x8(:,230),heltab2x24(:,:,230))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(235),h0tab(:,235),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(131),m3h3x8(:,231),heltab2x24(:,:,231))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(236),h0tab(:,236),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(132),m3h3x8(:,232),heltab2x24(:,:,232))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(237),h0tab(:,237),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(133),m3h3x8(:,233),heltab2x24(:,:,233))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(238),h0tab(:,238),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(134),m3h3x8(:,234),heltab2x24(:,:,234))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(239),h0tab(:,239),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(135),m3h3x8(:,235),heltab2x24(:,:,235))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(240),h0tab(:,240),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(136),m3h3x8(:,236),heltab2x24(:,:,236))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(241),h0tab(:,241),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(137),m3h3x8(:,237),heltab2x24(:,:,237))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(242),h0tab(:,242),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(138),m3h3x8(:,238),heltab2x24(:,:,238))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(243),h0tab(:,243),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(69),m3h3x8(:,239),heltab2x24(:,:,239))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(244),h0tab(:,244),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(70),m3h3x8(:,240),heltab2x24(:,:,240))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(245),h0tab(:,245),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(71),m3h3x8(:,241),heltab2x24(:,:,241))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(246),h0tab(:,246),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(72),m3h3x8(:,242),heltab2x24(:,:,242))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(247),h0tab(:,247),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(139),m3h3x8(:,243),heltab2x24(:,:,243))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(248),h0tab(:,248),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(140),m3h3x8(:,244),heltab2x24(:,:,244))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(249),h0tab(:,249),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(141),m3h3x8(:,245),heltab2x24(:,:,245))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(250),h0tab(:,250),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(142),m3h3x8(:,246),heltab2x24(:,:,246))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(251),h0tab(:,251),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(73),m3h3x8(:,247),heltab2x24(:,:,247))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(252),h0tab(:,252),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(74),m3h3x8(:,248),heltab2x24(:,:,248))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(253),h0tab(:,253),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(75),m3h3x8(:,249),heltab2x24(:,:,249))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(254),h0tab(:,254),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(76),m3h3x8(:,250),heltab2x24(:,:,250))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(255),h0tab(:,255),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(77),m3h3x8(:,251),heltab2x24(:,:,251))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(256),h0tab(:,256),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(78),m3h3x8(:,252),heltab2x24(:,:,252))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(257),h0tab(:,257),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(79),m3h3x8(:,253),heltab2x24(:,:,253))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(258),h0tab(:,258),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(80),m3h3x8(:,254),heltab2x24(:,:,254))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(259),h0tab(:,259),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(143),m3h3x8(:,255),heltab2x24(:,:,255))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(260),h0tab(:,260),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(144),m3h3x8(:,256),heltab2x24(:,:,256))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(261),h0tab(:,261),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(145),m3h3x8(:,257),heltab2x24(:,:,257))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(262),h0tab(:,262),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(146),m3h3x8(:,258),heltab2x24(:,:,258))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(263),h0tab(:,263),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(81),m3h3x8(:,259),heltab2x24(:,:,259))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(264),h0tab(:,264),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(82),m3h3x8(:,260),heltab2x24(:,:,260))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(265),h0tab(:,265),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(83),m3h3x8(:,261),heltab2x24(:,:,261))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(266),h0tab(:,266),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(84),m3h3x8(:,262),heltab2x24(:,:,262))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(267),h0tab(:,267),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(85),m3h3x8(:,263),heltab2x24(:,:,263))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(268),h0tab(:,268),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(86),m3h3x8(:,264),heltab2x24(:,:,264))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(269),h0tab(:,269),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(87),m3h3x8(:,265),heltab2x24(:,:,265))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(270),h0tab(:,270),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(88),m3h3x8(:,266),heltab2x24(:,:,266))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(271),h0tab(:,271),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(147),m3h3x8(:,267),heltab2x24(:,:,267))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(272),h0tab(:,272),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(148),m3h3x8(:,268),heltab2x24(:,:,268))
  Gcoeff(:)%j = (c(107)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(273),h0tab(:,273),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(149),m3h3x8(:,269),heltab2x24(:,:,269))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(274),h0tab(:,274),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(150),m3h3x8(:,270),heltab2x24(:,:,270))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(275),h0tab(:,275),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(89),m3h3x8(:,271),heltab2x24(:,:,271))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(276),h0tab(:,276),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(90),m3h3x8(:,272),heltab2x24(:,:,272))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(277),h0tab(:,277),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(91),m3h3x8(:,273),heltab2x24(:,:,273))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(278),h0tab(:,278),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(92),m3h3x8(:,274),heltab2x24(:,:,274))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(279),h0tab(:,279),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(93),m3h3x8(:,275),heltab2x24(:,:,275))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(280),h0tab(:,280),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(94),m3h3x8(:,276),heltab2x24(:,:,276))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(281),h0tab(:,281),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(95),m3h3x8(:,277),heltab2x24(:,:,277))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(282),h0tab(:,282),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(96),m3h3x8(:,278),heltab2x24(:,:,278))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(283),h0tab(:,283),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(151),m3h3x8(:,279),heltab2x24(:,:,279))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(284),h0tab(:,284),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(152),m3h3x8(:,280),heltab2x24(:,:,280))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(285),h0tab(:,285),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(153),m3h3x8(:,281),heltab2x24(:,:,281))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(286),h0tab(:,286),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(154),m3h3x8(:,282),heltab2x24(:,:,282))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(287),h0tab(:,287),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(97),m3h3x8(:,283),heltab2x24(:,:,283))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(288),h0tab(:,288),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(98),m3h3x8(:,284),heltab2x24(:,:,284))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(289),h0tab(:,289),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(99),m3h3x8(:,285),heltab2x24(:,:,285))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(290),h0tab(:,290),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(100),m3h3x8(:,286),heltab2x24(:,:,286))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(291),h0tab(:,291),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(155),m3h3x8(:,287),heltab2x24(:,:,287))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(292),h0tab(:,292),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(156),m3h3x8(:,288),heltab2x24(:,:,288))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(293),h0tab(:,293),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(157),m3h3x8(:,289),heltab2x24(:,:,289))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(294),h0tab(:,294),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(158),m3h3x8(:,290),heltab2x24(:,:,290))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(295),h0tab(:,295),[16,2,4,9],[0,nMZ,nMZ,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(101),ngZu,m3h3x8(:,291),heltab2x24(:,:,291))
  call Hloop_Q_A(ntryL,G0H8(101),16,0,G1H8(159),n2h8(47))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(296),h0tab(:,296),[16,2,4,9],[0,nMW,nMW,0],4,1,wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(101),ngZd,m3h3x8(:,292),heltab2x24(:,:,292))
  call Hloop_Q_A(ntryL,G0H8(101),16,0,G1H8(160),n2h8(48))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(297),h0tab(:,297),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(101),m3h3x8(:,293),heltab2x24(:,:,293))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(298),h0tab(:,298),[16,4,2,9],[nMW,nMW,0,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(161),m3h3x8(:,294),heltab2x24(:,:,294))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(299),h0tab(:,299),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(102),m3h3x8(:,295),heltab2x24(:,:,295))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(300),h0tab(:,300),[16,2,9,4],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(162),m3h3x8(:,296),heltab2x24(:,:,296))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(301),h0tab(:,301),[16,1,4,10],[0,nMZ,nMZ,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(103),ngZu,m3h3x8(:,297),heltab2x24(:,:,297))
  call Hloop_A_Q(ntryL,G0H8(103),16,0,G1H8(163),n2h8(49))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(302),h0tab(:,302),[16,1,4,10],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(103),ngZd,m3h3x8(:,298),heltab2x24(:,:,298))
  call Hloop_A_Q(ntryL,G0H8(103),16,0,G1H8(164),n2h8(50))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(303),h0tab(:,303),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(103),m3h3x8(:,299),heltab2x24(:,:,299))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(304),h0tab(:,304),[16,4,1,10],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(165),m3h3x8(:,300),heltab2x24(:,:,300))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(305),h0tab(:,305),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(104),m3h3x8(:,301),heltab2x24(:,:,301))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(306),h0tab(:,306),[16,1,10,4],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(166),m3h3x8(:,302),heltab2x24(:,:,302))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(307),h0tab(:,307),[17,4,2,8],[nMZ,nMZ,0,0],4,1,wf6(:,2))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,2),G0H4(3),ngZu,m3h6x4(:,1),heltab2x24(:,:,303))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(308),h0tab(:,308),[17,4,2,8],[nMW,nMW,0,0],4,1,wf6(:,2))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,2),G0H4(4),m3h6x4(:,2),heltab2x24(:,:,304))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(309),h0tab(:,309),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,2),G0H4(5),m3h6x4(:,3),heltab2x24(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(5),17,0,G1H4(3),n2h4(33))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(310),h0tab(:,310),[17,2,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,2),G0H4(5),m3h6x4(:,4),heltab2x24(:,:,306))
  call Hloop_Q_A(ntryL,G0H4(5),17,0,G1H4(5),n2h4(34))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(311),h0tab(:,311),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,2),G0H4(5),m3h6x4(:,5),heltab2x24(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(5),17,0,G1H4(6),n2h4(35))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(312),h0tab(:,312),[17,2,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,2),G0H4(5),m3h6x4(:,6),heltab2x24(:,:,308))
  call Hloop_Q_A(ntryL,G0H4(5),17,0,G1H4(7),n2h4(36))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(313),h0tab(:,313),[18,4,1,8],[nMZ,nMZ,0,0],4,1,wf6(:,4))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,4),G0H4(5),ngZu,m3h6x4(:,7),heltab2x24(:,:,309))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(314),h0tab(:,314),[18,4,1,8],[nMW,nMW,0,0],4,1,wf6(:,4))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,4),G0H4(6),m3h6x4(:,8),heltab2x24(:,:,310))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(315),h0tab(:,315),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,4),G0H4(7),m3h6x4(:,9),heltab2x24(:,:,311))
  call Hloop_A_Q(ntryL,G0H4(7),18,0,G1H4(11),n2h4(37))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(316),h0tab(:,316),[18,1,4,8],[0,nMW,nMW,nMW],4,1,wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,4),G0H4(7),m3h6x4(:,10),heltab2x24(:,:,312))
  call Hloop_A_Q(ntryL,G0H4(7),18,0,G1H4(12),n2h4(38))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(317),h0tab(:,317),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,4),G0H4(7),m3h6x4(:,11),heltab2x24(:,:,313))
  call Hloop_A_Q(ntryL,G0H4(7),18,0,G1H4(14),n2h4(39))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(318),h0tab(:,318),[18,1,8,4],[0,nMW,nMW,nMW],4,1,wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,4),G0H4(7),m3h6x4(:,12),heltab2x24(:,:,314))
  call Hloop_A_Q(ntryL,G0H4(7),18,0,G1H4(15),n2h4(40))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(319),h0tab(:,319),[20,2,1,8],[nMW,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(167),m3h3x8(:,303),heltab2x24(:,:,315))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(320),h0tab(:,320),[20,2,1,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(105),ngZu,m3h3x8(:,304),heltab2x24(:,:,316))
  call Hloop_Q_A(ntryL,G0H8(105),20,0,G1H8(168),n2h8(51))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(321),h0tab(:,321),[20,2,1,8],[0,nMZ,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(105),ngZu,m3h3x8(:,305),heltab2x24(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(105),20,0,G1H8(169),n2h8(52))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(322),h0tab(:,322),[20,2,1,8],[0,nMW,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(105),ngZd,m3h3x8(:,306),heltab2x24(:,:,318))
  call Hloop_Q_A(ntryL,G0H8(105),20,0,G1H8(170),n2h8(53))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(323),h0tab(:,323),[20,2,1,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(105),ngZu,m3h3x8(:,307),heltab2x24(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(105),20,0,G1H8(171),n2h8(54))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(324),h0tab(:,324),[20,2,1,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(105),m3h3x8(:,308),heltab2x24(:,:,320))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(325),h0tab(:,325),[20,2,1,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(172),m3h3x8(:,309),heltab2x24(:,:,321))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(326),h0tab(:,326),[20,1,2,8],[nMW,0,nMW,nMW],4,1,wf3(:,3))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(173),m3h3x8(:,310),heltab2x24(:,:,322))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(327),h0tab(:,327),[20,1,2,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(106),ngZu,m3h3x8(:,311),heltab2x24(:,:,323))
  call Hloop_A_Q(ntryL,G0H8(106),20,0,G1H8(174),n2h8(55))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(328),h0tab(:,328),[20,1,2,8],[0,nMZ,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(106),ngZu,m3h3x8(:,312),heltab2x24(:,:,324))
  call Hloop_A_Q(ntryL,G0H8(106),20,0,G1H8(175),n2h8(56))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(329),h0tab(:,329),[20,1,2,8],[0,nMW,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(106),ngZd,m3h3x8(:,313),heltab2x24(:,:,325))
  call Hloop_A_Q(ntryL,G0H8(106),20,0,G1H8(176),n2h8(57))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(330),h0tab(:,330),[20,1,2,8],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(106),ngZu,m3h3x8(:,314),heltab2x24(:,:,326))
  call Hloop_A_Q(ntryL,G0H8(106),20,0,G1H8(177),n2h8(58))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(331),h0tab(:,331),[20,1,2,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(106),m3h3x8(:,315),heltab2x24(:,:,327))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(332),h0tab(:,332),[20,1,2,8],[nMW,0,nMW,nMW],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(178),m3h3x8(:,316),heltab2x24(:,:,328))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(333),h0tab(:,333),[20,1,8,2],[nMW,0,0,nMW],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(179),m3h3x8(:,317),heltab2x24(:,:,329))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(334),h0tab(:,334),[20,1,8,2],[0,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(107),ngZd,m3h3x8(:,318),heltab2x24(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(107),20,0,G1H8(180),n2h8(59))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(6),G0H8(106),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(12),G0H8(105),G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(54),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(77),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(50),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(52),[G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(54),[G0H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(56),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(125),[G1H8(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(126),[G1H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(129),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(136),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(82),[G0H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(84),[G0H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(86),[G0H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(88),[G0H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(156),[G1H8(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(158),[G1H8(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G1H8(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(177),[G1H8(174)])
  call Hloop_WQ_A(ntryL,G1H8(173),ex1(:),G1H4(16),m3h2x4(:,41),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(16),21,0,G2H4(11),n2h4(41))
  call Hloop_WA_Q(ntryL,G1H8(167),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(1),n2h4(42))
  call Hloop_AV_Q(ntryL,G1H4(4),ex4(:),G1H2(10),m3h2x2(:,43),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(10),26,0,G2H2(9),n2h2(19))
  call Hloop_QV_A(ntryL,G1H4(13),ex4(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),25,0,G2H2(10),n2h2(20))
  call Hloop_WA_Q(ntryL,G0H4(1),ex2(:),G0H2(1),m3h2x2(:,45),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G0H2(1),26,0,G1H2(3),n2h2(21))
  call Hloop_WQ_A(ntryL,G0H4(2),ex1(:),G0H2(1),m3h2x2(:,46),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G0H2(1),25,0,G1H2(17),n2h2(22))
  call Hloop_WQ_A(ntryL,G0H8(4),ex1(:),G0H4(7),m3h2x4(:,43),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G0H4(7),17,0,G1H4(2),n2h4(43))
  call Hloop_WA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,44),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G0H4(1),18,0,G1H4(8),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,17),G1H2(18),m3h4x2(:,1),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(18),19,nML,G2H2(20),n2h2(23))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,17),G1H2(23),m3h4x2(:,2),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(23),19,nML,G2H2(21),n2h2(24))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,17),G1H2(6),m3h4x2(:,3),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(6),19,nMT,G2H2(1),n2h2(25))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,17),G1H2(7),m3h4x2(:,4),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(7),19,nMT,G2H2(2),n2h2(26))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,17),G1H2(29),m3h4x2(:,5),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(29),19,nMB,G2H2(3),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,17),G1H2(30),m3h4x2(:,6),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(30),19,nMB,G2H2(4),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H8(22),wf4(:,18),G1H2(31),ngZl,m3h4x2(:,7),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(31),19,nML,G2H2(5),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H8(1),wf4(:,18),G1H2(35),ngZl,m3h4x2(:,8),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(35),19,nML,G2H2(6),n2h2(30))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,18),G1H2(36),ngZu,m3h4x2(:,9),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(36),19,nMT,G2H2(7),n2h2(31))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,18),G1H2(37),ngZu,m3h4x2(:,10),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(37),19,nMT,G2H2(8),n2h2(32))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,18),G1H2(41),ngZd,m3h4x2(:,11),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(41),19,nMB,G2H2(22),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H8(4),wf4(:,18),G1H2(24),ngZd,m3h4x2(:,12),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(24),19,nMB,G2H2(23),n2h2(34))
  call Hloop_TV_S(ntryL,G1H8(5),16,wf4(:,17),3,G2H2(11),m3h4x2(:,13),heltab2x8(:,:,65))
  call Hloop_SV_T(ntryL,G1H8(7),16,wf4(:,17),3,G2H2(25),m3h4x2(:,14),heltab2x8(:,:,66))
  call Hloop_TV_S(ntryL,G1H8(8),16,wf4(:,18),3,G2H2(26),m3h4x2(:,15),heltab2x8(:,:,67))
  call Hloop_SV_T(ntryL,G1H8(9),16,wf4(:,18),3,G2H2(28),m3h4x2(:,16),heltab2x8(:,:,68))
  call Hloop_CV_D(ntryL,G1H8(13),16,wf4(:,17),3,G2H2(12),m3h4x2(:,17),heltab2x8(:,:,69))
  call Hloop_DV_C(ntryL,G1H8(14),16,wf4(:,17),G2H2(15),m3h4x2(:,18),heltab2x8(:,:,70))
  call Hloop_CV_D(ntryL,G1H8(25),16,wf4(:,18),3,G2H2(16),m3h4x2(:,19),heltab2x8(:,:,71))
  call Hloop_DV_C(ntryL,G1H8(26),16,wf4(:,18),G2H2(19),m3h4x2(:,20),heltab2x8(:,:,72))
  call Hloop_UV_W(ntryL,G1H8(27),16,wf4(:,17),3,G2H2(29),m3h4x2(:,21),heltab2x8(:,:,73))
  call Hloop_UW_V(ntryL,G1H8(28),16,wf4(:,17),3,G2H2(30),m3h4x2(:,22),heltab2x8(:,:,74))
  call Hloop_UV_W(ntryL,G1H8(29),16,wf4(:,18),3,G2H2(31),m3h4x2(:,23),heltab2x8(:,:,75))
  call Hloop_UW_V(ntryL,G1H8(30),16,wf4(:,18),3,G2H2(32),m3h4x2(:,24),heltab2x8(:,:,76))
  call Hloop_VV_S(ntryL,G0H8(7),wf4(:,17),G0H2(1),m3h4x2(:,25),heltab2x8(:,:,77))
  call Hloop_VV_S(ntryL,G0H8(8),wf4(:,17),G0H2(2),m3h4x2(:,26),heltab2x8(:,:,78))
  call Hloop_VV_S(ntryL,G0H8(9),wf4(:,18),G0H2(3),m3h4x2(:,27),heltab2x8(:,:,79))
  call Hloop_VV_S(ntryL,G0H8(10),wf4(:,18),G0H2(4),m3h4x2(:,28),heltab2x8(:,:,80))
  call Hloop_SV_V(ntryL,G1H8(32),wf4(:,17),G1H2(42),m3h4x2(:,29),heltab2x8(:,:,81))
  call Hloop_SV_V(ntryL,G1H8(34),wf4(:,18),G1H2(46),m3h4x2(:,30),heltab2x8(:,:,82))
  call Hloop_TV_S(ntryL,G0H8(11),16,wf4(:,17),3,G1H2(47),m3h4x2(:,31),heltab2x8(:,:,83))
  call Hloop_SV_T(ntryL,G0H8(12),16,wf4(:,17),3,G1H2(48),m3h4x2(:,32),heltab2x8(:,:,84))
  call Hloop_TV_S(ntryL,G0H8(13),16,wf4(:,18),3,G1H2(52),m3h4x2(:,33),heltab2x8(:,:,85))
  call Hloop_SV_T(ntryL,G0H8(14),16,wf4(:,18),3,G1H2(53),m3h4x2(:,34),heltab2x8(:,:,86))
  call Hloop_TV_S(ntryL,G1H8(35),16,wf4(:,17),3,G2H2(33),m3h4x2(:,35),heltab2x8(:,:,87))
  call Hloop_SV_T(ntryL,G1H8(36),16,wf4(:,17),3,G2H2(34),m3h4x2(:,36),heltab2x8(:,:,88))
  call Hloop_TV_S(ntryL,G1H8(37),16,wf4(:,18),3,G2H2(35),m3h4x2(:,37),heltab2x8(:,:,89))
  call Hloop_SV_T(ntryL,G1H8(38),16,wf4(:,18),3,G2H2(36),m3h4x2(:,38),heltab2x8(:,:,90))
  call Hloop_UV_W(ntryL,G0H8(15),16,wf4(:,17),3,G1H2(54),m3h4x2(:,39),heltab2x8(:,:,91))
  call Hloop_UW_V(ntryL,G0H8(1),16,wf4(:,17),3,G1H2(58),m3h4x2(:,40),heltab2x8(:,:,92))
  call Hloop_UV_W(ntryL,G0H8(6),16,wf4(:,18),3,G1H2(59),m3h4x2(:,41),heltab2x8(:,:,93))
  call Hloop_UW_V(ntryL,G0H8(16),16,wf4(:,18),3,G1H2(60),m3h4x2(:,42),heltab2x8(:,:,94))
  call Hloop_VV_S(ntryL,G1H8(39),wf4(:,17),G1H2(64),m3h4x2(:,43),heltab2x8(:,:,95))
  call Hloop_VV_S(ntryL,G1H8(40),wf4(:,17),G1H2(65),m3h4x2(:,44),heltab2x8(:,:,96))
  call Hloop_VV_S(ntryL,G1H8(41),wf4(:,18),G1H2(66),m3h4x2(:,45),heltab2x8(:,:,97))
  call Hloop_VV_S(ntryL,G1H8(42),wf4(:,18),G1H2(70),m3h4x2(:,46),heltab2x8(:,:,98))
  call Hloop_SV_V(ntryL,G0H8(18),wf4(:,17),G0H2(5),m3h4x2(:,47),heltab2x8(:,:,99))
  call Hloop_SV_V(ntryL,G0H8(20),wf4(:,18),G0H2(6),m3h4x2(:,48),heltab2x8(:,:,100))
  call Hloop_VV_S(ntryL,G0H8(22),wf4(:,17),G0H2(7),m3h4x2(:,49),heltab2x8(:,:,101))
  call Hloop_VV_S(ntryL,G0H8(24),wf4(:,18),G0H2(8),m3h4x2(:,50),heltab2x8(:,:,102))
  call Hloop_SV_V(ntryL,G1H8(43),wf4(:,17),G1H2(71),m3h4x2(:,51),heltab2x8(:,:,103))
  call Hloop_SV_V(ntryL,G1H8(44),wf4(:,17),G1H2(72),m3h4x2(:,52),heltab2x8(:,:,104))
  call Hloop_SV_V(ntryL,G1H8(45),wf4(:,18),G1H2(76),m3h4x2(:,53),heltab2x8(:,:,105))
  call Hloop_SV_V(ntryL,G1H8(46),wf4(:,18),G1H2(77),m3h4x2(:,54),heltab2x8(:,:,106))
  call Hloop_TV_S(ntryL,G0H8(25),16,wf4(:,17),3,G1H2(78),m3h4x2(:,55),heltab2x8(:,:,107))
  call Hloop_SV_T(ntryL,G0H8(26),16,wf4(:,17),3,G1H2(82),m3h4x2(:,56),heltab2x8(:,:,108))
  call Hloop_TV_S(ntryL,G0H8(27),16,wf4(:,18),3,G1H2(10),m3h4x2(:,57),heltab2x8(:,:,109))
  call Hloop_SV_T(ntryL,G0H8(28),16,wf4(:,18),3,G1H2(1),m3h4x2(:,58),heltab2x8(:,:,110))
  call Hloop_UV_W(ntryL,G1H8(47),16,wf4(:,17),3,G2H2(37),m3h4x2(:,59),heltab2x8(:,:,111))
  call Hloop_UW_V(ntryL,G1H8(48),16,wf4(:,17),3,G2H2(38),m3h4x2(:,60),heltab2x8(:,:,112))
  call Hloop_UV_W(ntryL,G1H8(49),16,wf4(:,18),3,G2H2(39),m3h4x2(:,61),heltab2x8(:,:,113))
  call Hloop_UW_V(ntryL,G1H8(50),16,wf4(:,18),3,G2H2(40),m3h4x2(:,62),heltab2x8(:,:,114))
  call Hloop_UV_W(ntryL,G0H8(29),16,wf4(:,17),3,G1H2(18),m3h4x2(:,63),heltab2x8(:,:,115))
  call Hloop_UW_V(ntryL,G0H8(30),16,wf4(:,17),3,G1H2(23),m3h4x2(:,64),heltab2x8(:,:,116))
  call Hloop_UV_W(ntryL,G0H8(31),16,wf4(:,18),3,G1H2(6),m3h4x2(:,65),heltab2x8(:,:,117))
  call Hloop_UW_V(ntryL,G0H8(32),16,wf4(:,18),3,G1H2(7),m3h4x2(:,66),heltab2x8(:,:,118))
  call Hloop_VV_S(ntryL,G1H8(52),wf4(:,17),G1H2(29),m3h4x2(:,67),heltab2x8(:,:,119))
  call Hloop_VV_S(ntryL,G1H8(54),wf4(:,18),G1H2(30),m3h4x2(:,68),heltab2x8(:,:,120))
  call Hloop_SV_V(ntryL,G0H8(33),wf4(:,17),G0H2(9),m3h4x2(:,69),heltab2x8(:,:,121))
  call Hloop_SV_V(ntryL,G0H8(34),wf4(:,17),G0H2(10),m3h4x2(:,70),heltab2x8(:,:,122))
  call Hloop_SV_V(ntryL,G0H8(35),wf4(:,18),G0H2(11),m3h4x2(:,71),heltab2x8(:,:,123))
  call Hloop_SV_V(ntryL,G0H8(36),wf4(:,18),G0H2(12),m3h4x2(:,72),heltab2x8(:,:,124))
  call Hloop_AV_Q(ntryL,G1H8(55),wf4(:,17),G1H2(31),m3h4x2(:,73),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(31),19,nML,G2H2(41),n2h2(35))
  call Hloop_QV_A(ntryL,G1H8(56),wf4(:,17),G1H2(35),m3h4x2(:,74),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(35),19,nML,G2H2(42),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H8(57),wf4(:,17),G1H2(36),m3h4x2(:,75),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(36),19,nMT,G2H2(43),n2h2(37))
  call Hloop_QV_A(ntryL,G1H8(58),wf4(:,17),G1H2(37),m3h4x2(:,76),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(37),19,nMT,G2H2(44),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H8(59),wf4(:,17),G1H2(41),m3h4x2(:,77),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(41),19,nMB,G2H2(45),n2h2(39))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,17),G1H2(24),m3h4x2(:,78),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(24),19,nMB,G2H2(46),n2h2(40))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,18),G1H2(31),ngZl,m3h4x2(:,79),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(31),19,nML,G2H2(47),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H8(62),wf4(:,18),G1H2(35),ngZl,m3h4x2(:,80),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(35),19,nML,G2H2(48),n2h2(42))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,18),G1H2(36),ngZu,m3h4x2(:,81),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(36),19,nMT,G2H2(49),n2h2(43))
  call Hloop_QZ_A(ntryL,G1H8(64),wf4(:,18),G1H2(37),ngZu,m3h4x2(:,82),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(37),19,nMT,G2H2(50),n2h2(44))
  call Hloop_AZ_Q(ntryL,G1H8(65),wf4(:,18),G1H2(41),ngZd,m3h4x2(:,83),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(41),19,nMB,G2H2(51),n2h2(45))
  call Hloop_QZ_A(ntryL,G1H8(66),wf4(:,18),G1H2(24),ngZd,m3h4x2(:,84),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(24),19,nMB,G2H2(52),n2h2(46))
  call Hloop_SV_T(ntryL,G1H8(67),16,wf4(:,17),3,G2H2(53),m3h4x2(:,85),heltab2x8(:,:,137))
  call Hloop_TV_S(ntryL,G1H8(68),16,wf4(:,17),3,G2H2(54),m3h4x2(:,86),heltab2x8(:,:,138))
  call Hloop_SV_T(ntryL,G1H8(69),16,wf4(:,18),3,G2H2(55),m3h4x2(:,87),heltab2x8(:,:,139))
  call Hloop_TV_S(ntryL,G1H8(70),16,wf4(:,18),3,G2H2(56),m3h4x2(:,88),heltab2x8(:,:,140))
  call Hloop_DV_C(ntryL,G1H8(73),16,wf4(:,17),G2H2(57),m3h4x2(:,89),heltab2x8(:,:,141))
  call Hloop_CV_D(ntryL,G1H8(74),16,wf4(:,17),3,G2H2(58),m3h4x2(:,90),heltab2x8(:,:,142))
  call Hloop_DV_C(ntryL,G1H8(77),16,wf4(:,18),G2H2(59),m3h4x2(:,91),heltab2x8(:,:,143))
  call Hloop_CV_D(ntryL,G1H8(78),16,wf4(:,18),3,G2H2(60),m3h4x2(:,92),heltab2x8(:,:,144))
  call Hloop_UW_V(ntryL,G1H8(79),16,wf4(:,17),3,G2H2(61),m3h4x2(:,93),heltab2x8(:,:,145))
  call Hloop_UV_W(ntryL,G1H8(80),16,wf4(:,17),3,G2H2(62),m3h4x2(:,94),heltab2x8(:,:,146))
  call Hloop_UW_V(ntryL,G1H8(81),16,wf4(:,18),3,G2H2(63),m3h4x2(:,95),heltab2x8(:,:,147))
  call Hloop_UV_W(ntryL,G1H8(82),16,wf4(:,18),3,G2H2(64),m3h4x2(:,96),heltab2x8(:,:,148))
  call Hloop_VV_S(ntryL,G0H8(37),wf4(:,17),G0H2(13),m3h4x2(:,97),heltab2x8(:,:,149))
  call Hloop_VV_S(ntryL,G0H8(38),wf4(:,17),G0H2(14),m3h4x2(:,98),heltab2x8(:,:,150))
  call Hloop_VV_S(ntryL,G0H8(39),wf4(:,18),G0H2(15),m3h4x2(:,99),heltab2x8(:,:,151))
  call Hloop_VV_S(ntryL,G0H8(40),wf4(:,18),G0H2(16),m3h4x2(:,100),heltab2x8(:,:,152))
  call Hloop_SV_T(ntryL,G0H8(41),16,wf4(:,17),3,G1H2(31),m3h4x2(:,101),heltab2x8(:,:,153))
  call Hloop_TV_S(ntryL,G0H8(42),16,wf4(:,17),3,G1H2(35),m3h4x2(:,102),heltab2x8(:,:,154))
  call Hloop_SV_T(ntryL,G0H8(43),16,wf4(:,18),3,G1H2(36),m3h4x2(:,103),heltab2x8(:,:,155))
  call Hloop_TV_S(ntryL,G0H8(44),16,wf4(:,18),3,G1H2(37),m3h4x2(:,104),heltab2x8(:,:,156))
  call Hloop_SV_V(ntryL,G1H8(83),wf4(:,17),G1H2(41),m3h4x2(:,105),heltab2x8(:,:,157))
  call Hloop_SV_V(ntryL,G1H8(84),wf4(:,17),G1H2(24),m3h4x2(:,106),heltab2x8(:,:,158))
  call Hloop_SV_V(ntryL,G1H8(85),wf4(:,18),G1H2(83),m3h4x2(:,107),heltab2x8(:,:,159))
  call Hloop_SV_V(ntryL,G1H8(86),wf4(:,18),G1H2(84),m3h4x2(:,108),heltab2x8(:,:,160))
  call Hloop_SV_T(ntryL,G1H8(87),16,wf4(:,17),3,G2H2(65),m3h4x2(:,109),heltab2x8(:,:,161))
  call Hloop_TV_S(ntryL,G1H8(88),16,wf4(:,17),3,G2H2(66),m3h4x2(:,110),heltab2x8(:,:,162))
  call Hloop_SV_T(ntryL,G1H8(89),16,wf4(:,18),3,G2H2(67),m3h4x2(:,111),heltab2x8(:,:,163))
  call Hloop_TV_S(ntryL,G1H8(90),16,wf4(:,18),3,G2H2(68),m3h4x2(:,112),heltab2x8(:,:,164))
  call Hloop_VV_S(ntryL,G1H8(92),wf4(:,17),G1H2(85),m3h4x2(:,113),heltab2x8(:,:,165))
  call Hloop_VV_S(ntryL,G1H8(94),wf4(:,18),G1H2(86),m3h4x2(:,114),heltab2x8(:,:,166))
  call Hloop_UW_V(ntryL,G0H8(45),16,wf4(:,17),3,G1H2(87),m3h4x2(:,115),heltab2x8(:,:,167))
  call Hloop_UV_W(ntryL,G0H8(46),16,wf4(:,17),3,G1H2(88),m3h4x2(:,116),heltab2x8(:,:,168))
  call Hloop_UW_V(ntryL,G0H8(47),16,wf4(:,18),3,G1H2(89),m3h4x2(:,117),heltab2x8(:,:,169))
  call Hloop_UV_W(ntryL,G0H8(48),16,wf4(:,18),3,G1H2(90),m3h4x2(:,118),heltab2x8(:,:,170))
  call Hloop_SV_V(ntryL,G0H8(50),wf4(:,17),G0H2(17),m3h4x2(:,119),heltab2x8(:,:,171))
  call Hloop_SV_V(ntryL,G0H8(52),wf4(:,18),G0H2(18),m3h4x2(:,120),heltab2x8(:,:,172))
  call Hloop_VV_S(ntryL,G0H8(54),wf4(:,17),G0H2(19),m3h4x2(:,121),heltab2x8(:,:,173))
  call Hloop_VV_S(ntryL,G0H8(56),wf4(:,18),G0H2(20),m3h4x2(:,122),heltab2x8(:,:,174))
  call Hloop_SV_T(ntryL,G0H8(57),16,wf4(:,17),3,G1H2(91),m3h4x2(:,123),heltab2x8(:,:,175))
  call Hloop_TV_S(ntryL,G0H8(58),16,wf4(:,17),3,G1H2(92),m3h4x2(:,124),heltab2x8(:,:,176))
  call Hloop_SV_T(ntryL,G0H8(59),16,wf4(:,18),3,G1H2(93),m3h4x2(:,125),heltab2x8(:,:,177))
  call Hloop_TV_S(ntryL,G0H8(60),16,wf4(:,18),3,G1H2(94),m3h4x2(:,126),heltab2x8(:,:,178))
  call Hloop_SV_V(ntryL,G1H8(96),wf4(:,17),G1H2(95),m3h4x2(:,127),heltab2x8(:,:,179))
  call Hloop_SV_V(ntryL,G1H8(98),wf4(:,18),G1H2(96),m3h4x2(:,128),heltab2x8(:,:,180))
  call Hloop_UW_V(ntryL,G1H8(99),16,wf4(:,17),3,G2H2(69),m3h4x2(:,129),heltab2x8(:,:,181))
  call Hloop_UV_W(ntryL,G1H8(100),16,wf4(:,17),3,G2H2(70),m3h4x2(:,130),heltab2x8(:,:,182))
  call Hloop_UW_V(ntryL,G1H8(101),16,wf4(:,18),3,G2H2(71),m3h4x2(:,131),heltab2x8(:,:,183))
  call Hloop_UV_W(ntryL,G1H8(102),16,wf4(:,18),3,G2H2(72),m3h4x2(:,132),heltab2x8(:,:,184))
  call Hloop_VV_S(ntryL,G1H8(103),wf4(:,17),G1H2(97),m3h4x2(:,133),heltab2x8(:,:,185))
  call Hloop_VV_S(ntryL,G1H8(104),wf4(:,17),G1H2(98),m3h4x2(:,134),heltab2x8(:,:,186))
  call Hloop_VV_S(ntryL,G1H8(105),wf4(:,18),G1H2(99),m3h4x2(:,135),heltab2x8(:,:,187))
  call Hloop_VV_S(ntryL,G1H8(106),wf4(:,18),G1H2(100),m3h4x2(:,136),heltab2x8(:,:,188))
  call Hloop_UW_V(ntryL,G0H8(61),16,wf4(:,17),3,G1H2(101),m3h4x2(:,137),heltab2x8(:,:,189))
  call Hloop_UV_W(ntryL,G0H8(62),16,wf4(:,17),3,G1H2(102),m3h4x2(:,138),heltab2x8(:,:,190))
  call Hloop_UW_V(ntryL,G0H8(63),16,wf4(:,18),3,G1H2(103),m3h4x2(:,139),heltab2x8(:,:,191))
  call Hloop_UV_W(ntryL,G0H8(64),16,wf4(:,18),3,G1H2(104),m3h4x2(:,140),heltab2x8(:,:,192))
  call Hloop_SV_V(ntryL,G0H8(65),wf4(:,17),G0H2(21),m3h4x2(:,141),heltab2x8(:,:,193))
  call Hloop_SV_V(ntryL,G0H8(66),wf4(:,17),G0H2(22),m3h4x2(:,142),heltab2x8(:,:,194))
  call Hloop_SV_V(ntryL,G0H8(67),wf4(:,18),G0H2(23),m3h4x2(:,143),heltab2x8(:,:,195))
  call Hloop_SV_V(ntryL,G0H8(68),wf4(:,18),G0H2(24),m3h4x2(:,144),heltab2x8(:,:,196))
  call Hloop_QS_A(ntryL,G1H8(107),ex3(:),G1H8(6),ngH,m3h1x8(:,9),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(6),20,nML,G2H8(1),n2h8(60))
  call Hloop_AS_Q(ntryL,G1H8(108),ex3(:),G1H8(12),ngH,m3h1x8(:,10),heltab2x8(:,:,198))
  call Hloop_A_Q(ntryL,G1H8(12),20,nML,G2H8(2),n2h8(61))
  call Hloop_QS_A(ntryL,G1H8(109),ex3(:),G1H8(10),ngH,m3h1x8(:,11),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(10),20,nMT,G2H8(3),n2h8(62))
  call Hloop_AS_Q(ntryL,G1H8(110),ex3(:),G1H8(11),ngH,m3h1x8(:,12),heltab2x8(:,:,200))
  call Hloop_A_Q(ntryL,G1H8(11),20,nMT,G2H8(4),n2h8(63))
  call Hloop_QS_A(ntryL,G1H8(111),ex3(:),G1H8(15),ngH,m3h1x8(:,13),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(15),20,nMB,G2H8(5),n2h8(64))
  call Hloop_AS_Q(ntryL,G1H8(112),ex3(:),G1H8(24),ngH,m3h1x8(:,14),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G1H8(24),20,nMB,G2H8(6),n2h8(65))
  call Hloop_QS_A(ntryL,G1H8(113),ex3(:),G1H8(31),ngH,m3h1x8(:,15),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(31),20,nML,G2H8(7),n2h8(66))
  call Hloop_AS_Q(ntryL,G1H8(114),ex3(:),G1H8(33),ngH,m3h1x8(:,16),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H8(33),20,nML,G2H8(8),n2h8(67))
  call Hloop_QS_A(ntryL,G1H8(115),ex3(:),G1H8(51),ngH,m3h1x8(:,17),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(51),20,nMT,G2H8(9),n2h8(68))
  call Hloop_AS_Q(ntryL,G1H8(116),ex3(:),G1H8(53),ngH,m3h1x8(:,18),heltab2x8(:,:,206))
  call Hloop_A_Q(ntryL,G1H8(53),20,nMT,G2H8(10),n2h8(69))
  call Hloop_QS_A(ntryL,G1H8(117),ex3(:),G1H8(71),ngH,m3h1x8(:,19),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(71),20,nMB,G2H8(11),n2h8(70))
  call Hloop_AS_Q(ntryL,G1H8(118),ex3(:),G1H8(72),ngH,m3h1x8(:,20),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G1H8(72),20,nMB,G2H8(12),n2h8(71))
  call Hloop_SS_S(ntryL,G1H8(119),ex3(:),G1H8(75),m3h1x8(:,21),heltab2x8(:,:,209))
  call Hloop_SS_S(ntryL,G1H8(120),ex3(:),G1H8(76),m3h1x8(:,22),heltab2x8(:,:,210))
  call Hloop_SS_S(ntryL,G1H8(121),ex3(:),G1H8(91),m3h1x8(:,23),heltab2x8(:,:,211))
  call Hloop_SS_S(ntryL,G1H8(122),ex3(:),G1H8(93),m3h1x8(:,24),heltab2x8(:,:,212))
  call Hloop_SS_S(ntryL,G1H8(125),ex3(:),G1H8(95),m3h1x8(:,25),heltab2x8(:,:,213))
  call Hloop_SS_S(ntryL,G1H8(126),ex3(:),G1H8(97),m3h1x8(:,26),heltab2x8(:,:,214))
  call Hloop_SS_S(ntryL,G1H8(129),ex3(:),G1H8(123),m3h1x8(:,27),heltab2x8(:,:,215))
  call Hloop_SS_S(ntryL,G1H8(130),ex3(:),G1H8(124),m3h1x8(:,28),heltab2x8(:,:,216))
  call Hloop_VS_V(ntryL,G1H8(131),ex3(:),G1H8(127),m3h1x8(:,29),heltab2x8(:,:,217))
  call Hloop_VS_V(ntryL,G1H8(132),ex3(:),G1H8(128),m3h1x8(:,30),heltab2x8(:,:,218))
  call Hloop_VS_V(ntryL,G1H8(133),ex3(:),G1H8(135),m3h1x8(:,31),heltab2x8(:,:,219))
  call Hloop_VS_V(ntryL,G1H8(134),ex3(:),G1H8(137),m3h1x8(:,32),heltab2x8(:,:,220))
  call Hloop_SS_S(ntryL,G1H8(136),ex3(:),G1H8(155),m3h1x8(:,33),heltab2x8(:,:,221))
  call Hloop_SS_S(ntryL,G1H8(138),ex3(:),G1H8(157),m3h1x8(:,34),heltab2x8(:,:,222))
  call Hloop_SS_S(ntryL,G0H8(69),ex3(:),G0H8(107),m3h1x8(:,35),heltab2x8(:,:,223))
  call Hloop_SS_S(ntryL,G0H8(70),ex3(:),G0H8(106),m3h1x8(:,36),heltab2x8(:,:,224))
  call Hloop_SS_S(ntryL,G0H8(71),ex3(:),G0H8(3),m3h1x8(:,37),heltab2x8(:,:,225))
  call Hloop_SS_S(ntryL,G0H8(72),ex3(:),G0H8(105),m3h1x8(:,38),heltab2x8(:,:,226))
  call Hloop_ST_V(ntryL,G1H8(139),16,ex3(:),4,G2H8(13),m3h1x8(:,39),heltab2x8(:,:,227))
  call Hloop_ST_V(ntryL,G1H8(140),16,ex3(:),4,G2H8(14),m3h1x8(:,40),heltab2x8(:,:,228))
  call Hloop_ST_V(ntryL,G1H8(141),16,ex3(:),4,G2H8(15),m3h1x8(:,41),heltab2x8(:,:,229))
  call Hloop_ST_V(ntryL,G1H8(142),16,ex3(:),4,G2H8(16),m3h1x8(:,42),heltab2x8(:,:,230))
  call Hloop_VT_S(ntryL,G0H8(73),16,ex3(:),4,G1H8(168),m3h1x8(:,43),heltab2x8(:,:,231))
  call Hloop_VT_S(ntryL,G0H8(74),16,ex3(:),4,G1H8(174),m3h1x8(:,44),heltab2x8(:,:,232))
  call Hloop_VT_S(ntryL,G0H8(75),16,ex3(:),4,G1H8(173),m3h1x8(:,45),heltab2x8(:,:,233))
  call Hloop_VT_S(ntryL,G0H8(76),16,ex3(:),4,G1H8(167),m3h1x8(:,46),heltab2x8(:,:,234))
  call Hloop_SS_S(ntryL,G0H8(77),ex3(:),G0H8(2),m3h1x8(:,47),heltab2x8(:,:,235))
  call Hloop_SS_S(ntryL,G0H8(78),ex3(:),G0H8(17),m3h1x8(:,48),heltab2x8(:,:,236))
  call Hloop_SS_S(ntryL,G0H8(79),ex3(:),G0H8(19),m3h1x8(:,49),heltab2x8(:,:,237))
  call Hloop_SS_S(ntryL,G0H8(80),ex3(:),G0H8(21),m3h1x8(:,50),heltab2x8(:,:,238))
  call Hloop_ST_V(ntryL,G1H8(143),16,ex3(:),4,G2H8(17),m3h1x8(:,51),heltab2x8(:,:,239))
  call Hloop_ST_V(ntryL,G1H8(144),16,ex3(:),4,G2H8(18),m3h1x8(:,52),heltab2x8(:,:,240))
  call Hloop_ST_V(ntryL,G1H8(145),16,ex3(:),4,G2H8(19),m3h1x8(:,53),heltab2x8(:,:,241))
  call Hloop_ST_V(ntryL,G1H8(146),16,ex3(:),4,G2H8(20),m3h1x8(:,54),heltab2x8(:,:,242))
  call Hloop_ST_V(ntryL,G0H8(82),16,ex3(:),4,G1H8(16),m3h1x8(:,55),heltab2x8(:,:,243))
  call Hloop_ST_V(ntryL,G0H8(84),16,ex3(:),4,G1H8(17),m3h1x8(:,56),heltab2x8(:,:,244))
  call Hloop_VT_S(ntryL,G0H8(86),16,ex3(:),4,G1H8(18),m3h1x8(:,57),heltab2x8(:,:,245))
  call Hloop_VT_S(ntryL,G0H8(88),16,ex3(:),4,G1H8(19),m3h1x8(:,58),heltab2x8(:,:,246))
  call Hloop_VT_S(ntryL,G1H8(147),16,ex3(:),4,G2H8(21),m3h1x8(:,59),heltab2x8(:,:,247))
  call Hloop_VT_S(ntryL,G1H8(148),16,ex3(:),4,G2H8(22),m3h1x8(:,60),heltab2x8(:,:,248))
  call Hloop_VT_S(ntryL,G1H8(149),16,ex3(:),4,G2H8(23),m3h1x8(:,61),heltab2x8(:,:,249))
  call Hloop_VT_S(ntryL,G1H8(150),16,ex3(:),4,G2H8(24),m3h1x8(:,62),heltab2x8(:,:,250))
  call Hloop_VS_V(ntryL,G0H8(89),ex3(:),G0H8(23),m3h1x8(:,63),heltab2x8(:,:,251))
  call Hloop_VS_V(ntryL,G0H8(90),ex3(:),G0H8(49),m3h1x8(:,64),heltab2x8(:,:,252))
  call Hloop_VS_V(ntryL,G0H8(91),ex3(:),G0H8(51),m3h1x8(:,65),heltab2x8(:,:,253))
  call Hloop_VS_V(ntryL,G0H8(92),ex3(:),G0H8(53),m3h1x8(:,66),heltab2x8(:,:,254))
  call Hloop_ST_V(ntryL,G0H8(93),16,ex3(:),4,G1H8(20),m3h1x8(:,67),heltab2x8(:,:,255))
  call Hloop_ST_V(ntryL,G0H8(94),16,ex3(:),4,G1H8(21),m3h1x8(:,68),heltab2x8(:,:,256))
  call Hloop_ST_V(ntryL,G0H8(95),16,ex3(:),4,G1H8(22),m3h1x8(:,69),heltab2x8(:,:,257))
  call Hloop_ST_V(ntryL,G0H8(96),16,ex3(:),4,G1H8(1),m3h1x8(:,70),heltab2x8(:,:,258))
  call Hloop_VT_S(ntryL,G1H8(151),16,ex3(:),4,G2H8(25),m3h1x8(:,71),heltab2x8(:,:,259))
  call Hloop_VT_S(ntryL,G1H8(152),16,ex3(:),4,G2H8(26),m3h1x8(:,72),heltab2x8(:,:,260))
  call Hloop_VT_S(ntryL,G1H8(153),16,ex3(:),4,G2H8(27),m3h1x8(:,73),heltab2x8(:,:,261))
  call Hloop_VT_S(ntryL,G1H8(154),16,ex3(:),4,G2H8(28),m3h1x8(:,74),heltab2x8(:,:,262))
  call Hloop_VS_V(ntryL,G0H8(97),ex3(:),G0H8(55),m3h1x8(:,75),heltab2x8(:,:,263))
  call Hloop_VS_V(ntryL,G0H8(98),ex3(:),G0H8(81),m3h1x8(:,76),heltab2x8(:,:,264))
  call Hloop_VS_V(ntryL,G0H8(99),ex3(:),G0H8(83),m3h1x8(:,77),heltab2x8(:,:,265))
  call Hloop_VS_V(ntryL,G0H8(100),ex3(:),G0H8(85),m3h1x8(:,78),heltab2x8(:,:,266))
  call Hloop_VS_V(ntryL,G1H8(156),ex3(:),G1H8(2),m3h1x8(:,79),heltab2x8(:,:,267))
  call Hloop_VS_V(ntryL,G1H8(158),ex3(:),G1H8(23),m3h1x8(:,80),heltab2x8(:,:,268))
  call Hloop_QA_Z(ntryL,G1H8(159),ex2(:),G1H4(9),ngZu,m3h2x4(:,45),heltab2x8(:,:,269))
  call Hloop_QA_W(ntryL,G1H8(160),ex2(:),G1H4(10),m3h2x4(:,46),heltab2x8(:,:,270))
  call Hloop_ST_V(ntryL,G0H8(101),16,ex3(:),4,G1H8(3),m3h1x8(:,81),heltab2x8(:,:,271))
  call Hloop_VS_V(ntryL,G1H8(161),ex3(:),G1H8(4),m3h1x8(:,82),heltab2x8(:,:,272))
  call Hloop_WA_Q(ntryL,G0H8(102),ex2(:),G0H4(2),m3h2x4(:,47),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(2),18,0,G1H4(16),n2h4(45))
  call Hloop_WA_Q(ntryL,G1H8(162),ex2(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G1H4(1),18,0,G2H4(2),n2h4(46))
  call Hloop_AQ_Z(ntryL,G1H8(163),ex1(:),G1H4(4),ngZu,m3h2x4(:,49),heltab2x8(:,:,275))
  call Hloop_AQ_W(ntryL,G1H8(164),ex1(:),G1H4(13),m3h2x4(:,50),heltab2x8(:,:,276))
  call Hloop_ST_V(ntryL,G0H8(103),16,ex3(:),4,G1H8(5),m3h1x8(:,83),heltab2x8(:,:,277))
  call Hloop_VS_V(ntryL,G1H8(165),ex3(:),G1H8(7),m3h1x8(:,84),heltab2x8(:,:,278))
  call Hloop_WQ_A(ntryL,G0H8(104),ex1(:),G0H4(7),m3h2x4(:,51),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(7),17,0,G1H4(1),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(166),ex1(:),G1H4(21),m3h2x4(:,52),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H4(21),17,0,G2H4(3),n2h4(48))
  call Hloop_VS_V(ntryL,G0H4(3),ex3(:),G0H4(1),m3h1x4(:,9),heltab2x4(:,:,55))
  call Hloop_VS_V(ntryL,G0H4(4),ex3(:),G0H4(2),m3h1x4(:,10),heltab2x4(:,:,56))
  call Hloop_QA_W(ntryL,G1H4(3),ex2(:),G1H2(105),m3h2x2(:,47),heltab2x4(:,:,57))
  call Hloop_QA_W(ntryL,G1H4(5),ex2(:),G1H2(106),m3h2x2(:,48),heltab2x4(:,:,58))
  call Hloop_QA_W(ntryL,G1H4(6),ex2(:),G1H2(107),m3h2x2(:,49),heltab2x4(:,:,59))
  call Hloop_QA_W(ntryL,G1H4(7),ex2(:),G1H2(108),m3h2x2(:,50),heltab2x4(:,:,60))
  call Hloop_VS_V(ntryL,G0H4(5),ex3(:),G0H4(7),m3h1x4(:,11),heltab2x4(:,:,61))
  call Hloop_VS_V(ntryL,G0H4(6),ex3(:),G0H4(3),m3h1x4(:,12),heltab2x4(:,:,62))
  call Hloop_AQ_W(ntryL,G1H4(11),ex1(:),G1H2(109),m3h2x2(:,51),heltab2x4(:,:,63))
  call Hloop_AQ_W(ntryL,G1H4(12),ex1(:),G1H2(110),m3h2x2(:,52),heltab2x4(:,:,64))
  call Hloop_AQ_W(ntryL,G1H4(14),ex1(:),G1H2(111),m3h2x2(:,53),heltab2x4(:,:,65))
  call Hloop_AQ_W(ntryL,G1H4(15),ex1(:),G1H2(112),m3h2x2(:,54),heltab2x4(:,:,66))
  call Hloop_QA_V(ntryL,G1H8(171),ex2(:),G1H4(21),m3h2x4(:,53),heltab2x8(:,:,281))
  call Hloop_QA_Z(ntryL,G1H8(169),ex2(:),G1H4(3),ngZu,m3h2x4(:,54),heltab2x8(:,:,282))
  call Hloop_QA_W(ntryL,G1H8(170),ex2(:),G1H4(5),m3h2x4(:,55),heltab2x8(:,:,283))
  call Hloop_WA_Q(ntryL,G1H8(172),ex2(:),G1H4(6),m3h2x4(:,56),heltab2x8(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(6),22,0,G2H4(5),n2h4(49))
  call Hloop_AQ_V(ntryL,G1H8(177),ex1(:),G1H4(7),m3h2x4(:,57),heltab2x8(:,:,285))
  call Hloop_AQ_Z(ntryL,G1H8(175),ex1(:),G1H4(11),ngZu,m3h2x4(:,58),heltab2x8(:,:,286))
  call Hloop_AQ_W(ntryL,G1H8(176),ex1(:),G1H4(12),m3h2x4(:,59),heltab2x8(:,:,287))
  call Hloop_WQ_A(ntryL,G1H8(178),ex1(:),G1H4(14),m3h2x4(:,60),heltab2x8(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(14),21,0,G2H4(6),n2h4(50))
  call Hloop_WQ_A(ntryL,G1H8(179),ex1(:),G1H4(15),m3h2x4(:,61),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G1H4(15),21,0,G2H4(7),n2h4(51))
  call Hloop_AQ_W(ntryL,G1H8(180),ex1(:),G1H4(6),m3h2x4(:,62),heltab2x8(:,:,290))
call HGT_lower_alpha_OLR(G1H4(19),1,1,4)
call HGT_lower_alpha_invQ_OLR(G1H4(19),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(71),G2H2(70),G2H2(69),G1H2(21),G1H2(12) &
    ,G0H2(18),G0H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(30),G1H2(16),G0H2(12),G0H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(108),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(29),G1H2(25),G0H2(11),G0H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(11),G0H2(3),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(25),G0H2(4),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(59),G1H2(58),G1H2(54),G1H2(46),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(64),G1H2(52),G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(70),[G1H2(65),G1H2(53),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(35),G2H2(34),G2H2(33),G0H2(8),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(39),G2H2(38),G2H2(37),G0H2(6),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(18),G1H2(76),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(23),G1H2(77),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(29),G1H2(1),G1H2(10),G1H2(82),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(53),G0H2(15),G0H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(54),G0H2(16),G0H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(61),G0H2(23),G0H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(62),G0H2(24),G0H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(85),G1H2(37),G1H2(36),G1H2(35),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(87),G1H2(83),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(88),G1H2(84),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(67),G2H2(66),G2H2(65),G0H2(20),G0H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(99),[G1H2(97),G1H2(93),G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(98),G1H2(94),G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(104),[G1H2(103),G1H2(102),G1H2(101),G1H2(96),G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(168),[G1H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(174),[G1H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G0H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G0H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G0H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G0H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G0H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G0H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G0H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G0H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
call HGT_lower_alpha_w2_OLR(G1H4(18),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(18),ex1(:),G1H2(11),m3h2x2(:,55),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(71),n2h2(47))
  call Hloop_QA_W(ntryL,G2H4(4),ex2(:),G2H2(70),m3h2x2(:,56),heltab2x4(:,:,68))
call HGT_lower_alpha_w2_OLR(G1H4(17),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(17),ex2(:),G1H2(21),m3h2x2(:,57),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(21),30,0,G2H2(69),n2h2(48))
  call Hloop_AQ_W(ntryL,G2H4(8),ex1(:),G2H2(30),m3h2x2(:,58),heltab2x4(:,:,70))
call HGT_lower_alpha_OLR(G1H4(20),1,1,4)
call HGT_lower_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(20),ex4(:),G1H2(12),m3h2x2(:,59),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(12),30,0,G2H2(29),n2h2(49))
  call Hloop_AQ_W(ntryL,G2H2(13),ex1(:),G2H1(1),m3h2x1(:,69),heltab2x2(:,:,85))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(47),mass4set(:,1),  & 
G1H4(14),G1H4(15),G1H4(19),G1H4(18),G1H4(17),4)
  call HG1shiftOLR(G1H4(15),2,4)
  call Hloop_QA_W(ntryL,G2H2(17),ex2(:),G2H1(2),m3h2x1(:,70),heltab2x2(:,:,86))
  call Hloop_VT_S(ntryL,G1H2(109),19,ex3(:),4,G2H2(20),m3h1x2(:,17),heltab2x2(:,:,87))
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(2),mass4set(:,2),  & 
G1H2(4),G1H2(16),G1H2(20),G1H2(8),G1H2(25),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hloop_UW_V(ntryL,G1H2(112),19,ex4(:),8,G2H1(3),m3h2x1(:,71),heltab2x2(:,:,88))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(7),mass4set(:,2),  & 
G1H2(59),G1H2(58),G1H2(54),G1H2(46),G1H2(42),2)
  call HG1shiftOLR(G1H2(58),4,2)
  call Hloop_VT_S(ntryL,G1H2(105),19,ex3(:),4,G2H2(21),m3h1x2(:,18),heltab2x2(:,:,89))
  call Hloop_UV_W(ntryL,G1H2(108),19,ex4(:),8,G2H1(4),m3h2x1(:,72),heltab2x2(:,:,90))
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(7),mass4set(:,2),  & 
G1H2(64),G1H2(52),G1H2(47),G1H2(65),G1H2(53),2)
  call HG1shiftOLR(G1H2(52),4,2)
  call Hloop_QA_W(ntryL,G2H4(11),ex2(:),G2H2(1),m3h2x2(:,60),heltab2x4(:,:,72))
  call Hloop_AQ_W(ntryL,G2H4(1),ex1(:),G2H2(2),m3h2x2(:,61),heltab2x4(:,:,73))
  call Hloop_AQ_W(ntryL,G2H2(9),ex1(:),G2H1(5),m3h2x1(:,73),heltab2x2(:,:,91))
  call Hloop_QA_W(ntryL,G2H2(10),ex2(:),G2H1(6),m3h2x1(:,74),heltab2x2(:,:,92))
  call Hloop_AQ_W(ntryL,G1H2(3),ex1(:),G1H1(27),m3h2x1(:,75),heltab2x2(:,:,93))
  call Hloop_QA_W(ntryL,G1H2(17),ex2(:),G1H1(28),m3h2x1(:,76),heltab2x2(:,:,94))
  call Hloop_QA_W(ntryL,G1H4(2),ex2(:),G1H2(48),m3h2x2(:,62),heltab2x4(:,:,74))
  call Hloop_AQ_W(ntryL,G1H4(8),ex1(:),G1H2(18),m3h2x2(:,63),heltab2x4(:,:,75))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,3),  & 
G1H2(76),G1H2(71),G1H2(23),G1H2(77),G1H2(72),G0H2(18),2)
  call HG1shiftOLR(G1H2(71),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(7),mass4set(:,3),  & 
G1H2(29),G1H2(1),G1H2(10),G1H2(82),G1H2(78),G0H2(17),2)
  call HG1shiftOLR(G1H2(1),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(7),mass4set(:,4),  & 
G1H2(85),G1H2(37),G1H2(36),G1H2(35),G1H2(31),G0H2(12),2)
  call HG1shiftOLR(G1H2(37),4,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(7),mass4set(:,4),  & 
G1H2(87),G1H2(83),G1H2(41),G1H2(88),G1H2(84),G0H2(10),2)
  call HG1shiftOLR(G1H2(83),4,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(7),mass4set(:,5),  & 
G1H2(24),G1H2(97),G1H2(93),G1H2(91),G1H2(98),G0H2(11),2)
  call HG1shiftOLR(G1H2(97),4,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(7),mass4set(:,5),  & 
G1H2(94),G1H2(92),G1H2(103),G1H2(102),G1H2(101),G0H2(9),2)
  call HG1shiftOLR(G1H2(92),4,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(7),mass4set(:,2),  & 
G1H2(96),G1H2(95),G1H2(11),G1H2(21),G1H2(12),2)
  call HG1shiftOLR(G1H2(95),4,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(7),mass4set(:,2),  & 
G1H2(109),G1H2(112),G1H2(105),G1H2(108),G1H2(3),2)
  call HG1shiftOLR(G1H2(112),4,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(7),mass4set(:,2),  & 
G1H2(17),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(113),4,2)
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(7),mass4set(:,2),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(118),4,2)
  call Hloop_VV_S(ntryL,G1H2(60),ex4(:),G1H1(32),m3h2x1(:,77),heltab2x2(:,:,95))
  call Hloop_TV_S(ntryL,G1H2(66),19,ex4(:),8,G2H1(7),m3h2x1(:,78),heltab2x2(:,:,96))
  call Hloop_SV_T(ntryL,G1H2(70),19,ex4(:),8,G2H1(9),m3h2x1(:,79),heltab2x2(:,:,97))
  call Hloop_SV_V(ntryL,G2H2(36),ex4(:),G2H1(10),m3h2x1(:,80),heltab2x2(:,:,98))
  call Hloop_VV_S(ntryL,G2H2(40),ex4(:),G2H1(12),m3h2x1(:,81),heltab2x2(:,:,99))
  call Hloop_UV_W(ntryL,G1H2(6),19,ex4(:),8,G2H1(13),m3h2x1(:,82),heltab2x2(:,:,100))
  call Hloop_UW_V(ntryL,G1H2(7),19,ex4(:),8,G2H1(15),m3h2x1(:,83),heltab2x2(:,:,101))
  call Hloop_SV_V(ntryL,G1H2(30),ex4(:),G1H1(2),m3h2x1(:,84),heltab2x2(:,:,102))
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(2),mass4set(:,3),  & 
G1H2(60),G1H2(66),G1H2(70),G1H2(6),G1H2(7),G0H2(3),2)
  call HG1shiftOLR(G1H2(66),8,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(2),mass4set(:,3),  & 
G1H2(30),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G0H2(1),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(2),mass4set(:,4),  & 
G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),G0H2(4),2)
  call HG1shiftOLR(G1H2(127),8,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(2),mass4set(:,4),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),G0H2(2),2)
  call HG1shiftOLR(G1H2(132),8,2)
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(2),mass4set(:,5),  & 
G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),G0H2(8),2)
  call HG1shiftOLR(G1H2(137),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(2),mass4set(:,5),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),G0H2(7),2)
  call HG1shiftOLR(G1H2(142),8,2)
  call Hloop_SS_S(ntryL,G2H2(55),ex3(:),G2H2(3),m3h1x2(:,19),heltab2x2(:,:,103))
  call Hloop_SS_S(ntryL,G2H2(56),ex3(:),G2H2(4),m3h1x2(:,20),heltab2x2(:,:,104))
  call Hloop_SS_S(ntryL,G2H2(59),ex3(:),G2H2(11),m3h1x2(:,21),heltab2x2(:,:,105))
  call Hloop_SS_S(ntryL,G2H2(60),ex3(:),G2H2(25),m3h1x2(:,22),heltab2x2(:,:,106))
  call Hloop_VS_V(ntryL,G2H2(63),ex3(:),G2H2(12),m3h1x2(:,23),heltab2x2(:,:,107))
  call Hloop_VS_V(ntryL,G2H2(64),ex3(:),G2H2(15),m3h1x2(:,24),heltab2x2(:,:,108))
  call Hloop_SS_S(ntryL,G1H2(86),ex3(:),G1H2(146),m3h1x2(:,25),heltab2x2(:,:,109))
  call Hloop_VT_S(ntryL,G1H2(89),19,ex3(:),4,G2H2(35),m3h1x2(:,26),heltab2x2(:,:,110))
  call Hloop_VT_S(ntryL,G1H2(90),19,ex3(:),4,G2H2(34),m3h1x2(:,27),heltab2x2(:,:,111))
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(2),mass4set(:,2),  & 
G1H2(86),G1H2(89),G1H2(90),G1H2(147),G1H2(148),2)
  call HG1shiftOLR(G1H2(89),8,2)
  call Hloop_ST_V(ntryL,G1H2(99),19,ex3(:),4,G2H2(33),m3h1x2(:,28),heltab2x2(:,:,112))
  call Hloop_ST_V(ntryL,G1H2(100),19,ex3(:),4,G2H2(39),m3h1x2(:,29),heltab2x2(:,:,113))
  call Hloop_VS_V(ntryL,G1H2(104),ex3(:),G1H2(99),m3h1x2(:,30),heltab2x2(:,:,114))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(19),mass4set(:,3),  & 
G1H8(8),G1H8(9),G1H8(13),G1H8(14),G1H8(25),G0H8(87),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(19),mass4set(:,3),  & 
G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),G0H8(4),8)
  call HG1shiftOLR(G1H8(27),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(19),mass4set(:,4),  & 
G1H8(32),G1H8(34),G1H8(35),G1H8(36),G1H8(37),G0H8(5),8)
  call HG1shiftOLR(G1H8(34),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(19),mass4set(:,4),  & 
G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),G0H8(7),8)
  call HG1shiftOLR(G1H8(39),8,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(19),mass4set(:,5),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G0H8(8),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(19),mass4set(:,5),  & 
G1H8(48),G1H8(49),G1H8(50),G1H8(52),G1H8(54),G0H8(9),8)
  call HG1shiftOLR(G1H8(49),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(19),mass4set(:,3),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G0H8(10),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(19),mass4set(:,3),  & 
G1H8(60),G1H8(61),G1H8(62),G1H8(63),G1H8(64),G0H8(11),8)
  call HG1shiftOLR(G1H8(61),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(19),mass4set(:,4),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G0H8(12),8)
  call HG1shiftOLR(G1H8(66),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(19),mass4set(:,4),  & 
G1H8(70),G1H8(73),G1H8(74),G1H8(77),G1H8(78),G0H8(13),8)
  call HG1shiftOLR(G1H8(73),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(19),mass4set(:,5),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G0H8(14),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(19),mass4set(:,5),  & 
G1H8(84),G1H8(85),G1H8(86),G1H8(87),G1H8(88),G0H8(15),8)
  call HG1shiftOLR(G1H8(85),8,8)
  call Hloop_TV_S(ntryL,G1H8(168),20,wf4(:,17),3,G2H2(38),m3h4x2(:,145),heltab2x8(:,:,291))
  call Hloop_SV_T(ntryL,G1H8(174),20,wf4(:,17),3,G2H2(37),m3h4x2(:,146),heltab2x8(:,:,292))
  call Hloop_TV_S(ntryL,G1H8(173),20,wf4(:,18),3,G2H2(41),m3h4x2(:,147),heltab2x8(:,:,293))
  call Hloop_SV_T(ntryL,G1H8(167),20,wf4(:,18),3,G2H2(42),m3h4x2(:,148),heltab2x8(:,:,294))
  call Hloop_CV_D(ntryL,G1H8(95),20,wf4(:,17),3,G2H2(43),m3h4x2(:,149),heltab2x8(:,:,295))
  call Hloop_DV_C(ntryL,G1H8(97),20,wf4(:,17),G2H2(44),m3h4x2(:,150),heltab2x8(:,:,296))
  call Hloop_CV_D(ntryL,G1H8(123),20,wf4(:,18),3,G2H2(45),m3h4x2(:,151),heltab2x8(:,:,297))
  call Hloop_DV_C(ntryL,G1H8(124),20,wf4(:,18),G2H2(46),m3h4x2(:,152),heltab2x8(:,:,298))
  call Hloop_UV_W(ntryL,G1H8(20),20,wf4(:,17),3,G2H2(53),m3h4x2(:,153),heltab2x8(:,:,299))
  call Hloop_UW_V(ntryL,G1H8(21),20,wf4(:,17),3,G2H2(54),m3h4x2(:,154),heltab2x8(:,:,300))
  call Hloop_UV_W(ntryL,G1H8(22),20,wf4(:,18),3,G2H2(57),m3h4x2(:,155),heltab2x8(:,:,301))
  call Hloop_UW_V(ntryL,G1H8(1),20,wf4(:,18),3,G2H2(58),m3h4x2(:,156),heltab2x8(:,:,302))
  call Hloop_SV_V(ntryL,G1H8(18),wf4(:,17),G1H2(100),m3h4x2(:,157),heltab2x8(:,:,303))
  call Hloop_SV_V(ntryL,G1H8(19),wf4(:,18),G1H2(104),m3h4x2(:,158),heltab2x8(:,:,304))
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(19),mass4set(:,2),  & 
G1H8(89),G1H8(90),G1H8(92),G1H8(94),G1H8(96),8)
  call HG1shiftOLR(G1H8(90),8,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(19),mass4set(:,2),  & 
G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(99),8,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(19),mass4set(:,2),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(19),mass4set(:,2),  & 
G1H8(6),G1H8(108),G1H8(12),G1H8(109),G1H8(10),8)
  call HG1shiftOLR(G1H8(108),8,8)
  call Hloop_VV_S(ntryL,G2H8(13),wf4(:,17),G2H2(61),m3h4x2(:,159),heltab2x8(:,:,305))
  call Hloop_VV_S(ntryL,G2H8(14),wf4(:,17),G2H2(62),m3h4x2(:,160),heltab2x8(:,:,306))
  call Hloop_VV_S(ntryL,G2H8(15),wf4(:,18),G2H2(67),m3h4x2(:,161),heltab2x8(:,:,307))
  call Hloop_VV_S(ntryL,G2H8(16),wf4(:,18),G2H2(66),m3h4x2(:,162),heltab2x8(:,:,308))
  call Hloop_SV_V(ntryL,G2H8(25),wf4(:,17),G2H2(65),m3h4x2(:,163),heltab2x8(:,:,309))
  call Hloop_SV_V(ntryL,G2H8(26),wf4(:,17),G2H2(13),m3h4x2(:,164),heltab2x8(:,:,310))
  call Hloop_SV_V(ntryL,G2H8(27),wf4(:,18),G2H2(17),m3h4x2(:,165),heltab2x8(:,:,311))
  call Hloop_SV_V(ntryL,G2H8(28),wf4(:,18),G2H2(72),m3h4x2(:,166),heltab2x8(:,:,312))
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(19),mass4set(:,2),  & 
G1H8(110),G1H8(11),G1H8(111),G1H8(15),G1H8(112),8)
  call HG1shiftOLR(G1H8(11),8,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(19),mass4set(:,2),  & 
G1H8(24),G1H8(113),G1H8(31),G1H8(114),G1H8(33),8)
  call HG1shiftOLR(G1H8(113),8,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(19),mass4set(:,2),  & 
G1H8(115),G1H8(51),G1H8(116),G1H8(53),G1H8(117),8)
  call HG1shiftOLR(G1H8(51),8,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(19),mass4set(:,2),  & 
G1H8(71),G1H8(118),G1H8(72),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(118),8,8)
  call Hloop_VV_S(ntryL,G1H8(2),wf4(:,17),G1H2(149),m3h4x2(:,167),heltab2x8(:,:,313))
  call Hloop_VV_S(ntryL,G1H8(23),wf4(:,18),G1H2(150),m3h4x2(:,168),heltab2x8(:,:,314))
  call Hloop_VS_V(ntryL,G1H4(9),ex3(:),G1H4(20),m3h1x4(:,13),heltab2x4(:,:,76))
  call Hloop_VS_V(ntryL,G1H4(10),ex3(:),G1H4(2),m3h1x4(:,14),heltab2x4(:,:,77))
  call Hloop_WA_Q(ntryL,G1H8(4),ex2(:),G1H4(8),m3h2x4(:,63),heltab2x8(:,:,315))
  call Hloop_A_Q(ntryL,G1H4(8),22,0,G2H4(9),n2h4(52))
  call Hloop_AQ_W(ntryL,G1H4(16),wf4(:,2),G1H1(16),m3h4x1(:,1),heltab2x4(:,:,78))
  call Hloop_AQ_W(ntryL,G2H4(2),wf4(:,2),G2H1(16),m3h4x1(:,2),heltab2x4(:,:,79))
  call Hloop_VS_V(ntryL,G1H4(4),ex3(:),G1H4(9),m3h1x4(:,15),heltab2x4(:,:,80))
  call Hloop_VS_V(ntryL,G1H4(13),ex3(:),G1H4(10),m3h1x4(:,16),heltab2x4(:,:,81))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(8),m3h2x4(:,64),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G1H4(8),21,0,G2H4(10),n2h4(53))
  call Hloop_QA_W(ntryL,G1H4(1),wf4(:,4),G1H1(20),m3h4x1(:,3),heltab2x4(:,:,82))
  call Hloop_QA_W(ntryL,G2H4(3),wf4(:,4),G2H1(18),m3h4x1(:,4),heltab2x4(:,:,83))
  call Hloop_ZA_Q(ntryL,G0H4(1),ex2(:),G0H2(6),ngZu,m3h2x2(:,64),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G0H2(6),23,0,G1H2(151),n2h2(50))
  call Hloop_WA_Q(ntryL,G0H4(2),ex2(:),G0H2(5),m3h2x2(:,65),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G0H2(5),23,0,G1H2(152),n2h2(51))
  call Hloop_VS_V(ntryL,G1H2(106),ex3(:),G1H2(153),m3h1x2(:,31),heltab2x2(:,:,115))
  call Hloop_VV_S(ntryL,G1H2(107),ex4(:),G1H1(21),m3h2x1(:,85),heltab2x2(:,:,116))
  call Hloop_ZQ_A(ntryL,G0H4(7),ex1(:),G0H2(15),ngZu,m3h2x2(:,66),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G0H2(15),23,0,G1H2(106),n2h2(52))
  call Hloop_WQ_A(ntryL,G0H4(3),ex1(:),G0H2(13),m3h2x2(:,67),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G0H2(13),23,0,G1H2(107),n2h2(53))
  call Hloop_VS_V(ntryL,G1H2(110),ex3(:),G1H2(154),m3h1x2(:,32),heltab2x2(:,:,117))
  call Hloop_VV_S(ntryL,G1H2(111),ex4(:),G1H1(22),m3h2x1(:,86),heltab2x2(:,:,118))
  call Hloop_VQ_A(ntryL,G1H4(21),ex1(:),G1H2(110),m3h2x2(:,68),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(110),23,0,G2H2(32),n2h2(54))
  call Hloop_ZQ_A(ntryL,G1H4(3),ex1(:),G1H2(111),ngZu,m3h2x2(:,69),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(111),23,0,G2H2(31),n2h2(55))
  call Hloop_WQ_A(ntryL,G1H4(5),ex1(:),G1H2(110),m3h2x2(:,70),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(110),23,0,G2H2(9),n2h2(56))
  call Hloop_AQ_W(ntryL,G2H4(5),ex1(:),G2H2(10),m3h2x2(:,71),heltab2x4(:,:,91))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(111),m3h2x2(:,72),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(111),23,0,G2H2(5),n2h2(57))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex2(:),G1H2(110),ngZu,m3h2x2(:,73),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(110),23,0,G2H2(6),n2h2(58))
  call Hloop_WA_Q(ntryL,G1H4(12),ex2(:),G1H2(111),m3h2x2(:,74),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(111),23,0,G2H2(7),n2h2(59))
  call Hloop_QA_W(ntryL,G2H4(6),ex2(:),G2H2(8),m3h2x2(:,75),heltab2x4(:,:,95))
  call Hloop_UW_V(ntryL,G1H4(6),21,ex4(:),8,G2H2(22),m3h2x2(:,76),heltab2x4(:,:,96))
  call Hloop_QV_A(ntryL,G1H4(14),ex4(:),G1H2(110),m3h2x2(:,77),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(110),29,0,G2H2(23),n2h2(60))
call HGT_raise_alpha_OLR(G1H4(15),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(15),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(15),ex2(:),G1H2(111),m3h2x2(:,78),heltab2x4(:,:,98))
  call Hloop_QV_A(ntryL,G1H4(18),ex4(:),G1H2(110),m3h2x2(:,79),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(110),29,0,G2H2(26),n2h2(61))
  call Hloop_QV_A(ntryL,G1H4(17),ex4(:),G1H2(110),m3h2x2(:,80),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(110),29,0,G2H2(28),n2h2(62))
  call Hloop_VT_S(ntryL,G1H2(4),19,ex3(:),4,G2H2(16),m3h1x2(:,33),heltab2x2(:,:,119))
call HGT_raise_alpha_OLR(G1H2(16),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(16),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(16),ex4(:),G1H1(26),m3h2x1(:,87),heltab2x2(:,:,120))
  call Hloop_VT_S(ntryL,G1H2(8),19,ex3(:),4,G2H2(19),m3h1x2(:,34),heltab2x2(:,:,121))
  call Hloop_VT_S(ntryL,G1H2(25),19,ex3(:),4,G2H2(36),m3h1x2(:,35),heltab2x2(:,:,122))
  call Hloop_UW_V(ntryL,G1H2(59),19,ex4(:),8,G2H1(19),m3h2x1(:,88),heltab2x2(:,:,123))
call HGT_raise_alpha_OLR(G1H2(58),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(58),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(58),ex3(:),G1H2(110),m3h1x2(:,36),heltab2x2(:,:,124))
  call Hloop_UW_V(ntryL,G1H2(46),19,ex4(:),8,G2H1(20),m3h2x1(:,89),heltab2x2(:,:,125))
  call Hloop_UW_V(ntryL,G1H2(42),19,ex4(:),8,G2H1(21),m3h2x1(:,90),heltab2x2(:,:,126))
  call Hloop_UV_W(ntryL,G1H2(64),19,ex4(:),8,G2H1(22),m3h2x1(:,91),heltab2x2(:,:,127))
call HGT_raise_alpha_OLR(G1H2(52),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(52),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(52),ex3(:),G1H2(4),m3h1x2(:,37),heltab2x2(:,:,128))
  call Hloop_UV_W(ntryL,G1H2(65),19,ex4(:),8,G2H1(23),m3h2x1(:,92),heltab2x2(:,:,129))
  call Hloop_UV_W(ntryL,G1H2(53),19,ex4(:),8,G2H1(24),m3h2x1(:,93),heltab2x2(:,:,130))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,131))
  call Hloop_Q_A(ntryL,G1H1(1),27,nML,G2H1(25),n2h1(31))
call HGT_OLR(G1H2(71),1,1,2)
call HGT_invQ_OLR(G1H2(71),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(71),-4,nML,G2H2(40),n2h2(66))
  call Hloop_AS_Q(ntryL,G2H2(40),ex3(:),G2H2(47),ngH,m3h1x2(:,38),heltab2x2(:,:,132))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(5),m3h2x1(:,95),heltab2x2(:,:,133))
  call Hloop_Q_A(ntryL,G1H1(5),27,nML,G2H1(26),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(72),ex4(:),G1H1(9),m3h2x1(:,96),heltab2x2(:,:,134))
  call Hloop_Q_A(ntryL,G1H1(9),27,nML,G2H1(27),n2h1(33))
  call Hloop_QV_A(ntryL,G0H2(18),ex4(:),G0H1(1),m3h2x1(:,97),heltab2x2(:,:,135))
  call Hloop_Q_A(ntryL,G0H1(1),27,nML,G1H1(33),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(34),m3h2x1(:,98),heltab2x2(:,:,136))
  call Hloop_A_Q(ntryL,G1H1(34),27,nML,G2H1(28),n2h1(35))
call HGT_OLR(G1H2(1),1,1,2)
call HGT_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(1),-4,nML,G2H2(48),n2h2(67))
  call Hloop_QS_A(ntryL,G2H2(48),ex3(:),G2H2(49),ngH,m3h1x2(:,39),heltab2x2(:,:,137))
  call Hloop_AV_Q(ntryL,G1H2(82),ex4(:),G1H1(38),m3h2x1(:,99),heltab2x2(:,:,138))
  call Hloop_A_Q(ntryL,G1H1(38),27,nML,G2H1(29),n2h1(36))
  call Hloop_AV_Q(ntryL,G1H2(78),ex4(:),G1H1(10),m3h2x1(:,100),heltab2x2(:,:,139))
  call Hloop_A_Q(ntryL,G1H1(10),27,nML,G2H1(30),n2h1(37))
  call Hloop_AV_Q(ntryL,G0H2(17),ex4(:),G0H1(1),m3h2x1(:,101),heltab2x2(:,:,140))
  call Hloop_A_Q(ntryL,G0H1(1),27,nML,G1H1(11),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(15),m3h2x1(:,102),heltab2x2(:,:,141))
  call Hloop_Q_A(ntryL,G1H1(15),27,nMT,G2H1(31),n2h1(39))
call HGT_OLR(G1H2(37),1,1,2)
call HGT_invQ_OLR(G1H2(37),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(37),-4,nMT,G2H2(50),n2h2(68))
  call Hloop_AS_Q(ntryL,G2H2(50),ex3(:),G2H2(51),ngH,m3h1x2(:,40),heltab2x2(:,:,142))
  call Hloop_QV_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,143))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(32),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(31),ex4(:),G1H1(5),m3h2x1(:,104),heltab2x2(:,:,144))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(33),n2h1(41))
  call Hloop_QV_A(ntryL,G0H2(12),ex4(:),G0H1(1),m3h2x1(:,105),heltab2x2(:,:,145))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMT,G1H1(9),n2h1(42))
  call Hloop_AV_Q(ntryL,G1H2(87),ex4(:),G1H1(34),m3h2x1(:,106),heltab2x2(:,:,146))
  call Hloop_A_Q(ntryL,G1H1(34),27,nMT,G2H1(34),n2h1(43))
call HGT_OLR(G1H2(83),1,1,2)
call HGT_invQ_OLR(G1H2(83),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(83),-4,nMT,G2H2(52),n2h2(69))
  call Hloop_QS_A(ntryL,G2H2(52),ex3(:),G2H2(55),ngH,m3h1x2(:,41),heltab2x2(:,:,147))
  call Hloop_AV_Q(ntryL,G1H2(88),ex4(:),G1H1(38),m3h2x1(:,107),heltab2x2(:,:,148))
  call Hloop_A_Q(ntryL,G1H1(38),27,nMT,G2H1(35),n2h1(44))
  call Hloop_AV_Q(ntryL,G1H2(84),ex4(:),G1H1(10),m3h2x1(:,108),heltab2x2(:,:,149))
  call Hloop_A_Q(ntryL,G1H1(10),27,nMT,G2H1(36),n2h1(45))
  call Hloop_AV_Q(ntryL,G0H2(10),ex4(:),G0H1(1),m3h2x1(:,109),heltab2x2(:,:,150))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMT,G1H1(15),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,151))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(37),n2h1(47))
call HGT_OLR(G1H2(97),1,1,2)
call HGT_invQ_OLR(G1H2(97),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(97),-4,nMB,G2H2(56),n2h2(70))
  call Hloop_AS_Q(ntryL,G2H2(56),ex3(:),G2H2(59),ngH,m3h1x2(:,42),heltab2x2(:,:,152))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(5),m3h2x1(:,111),heltab2x2(:,:,153))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMB,G2H1(38),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(34),m3h2x1(:,112),heltab2x2(:,:,154))
  call Hloop_Q_A(ntryL,G1H1(34),27,nMB,G2H1(39),n2h1(49))
  call Hloop_QV_A(ntryL,G0H2(11),ex4(:),G0H1(1),m3h2x1(:,113),heltab2x2(:,:,155))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(38),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(94),ex4(:),G1H1(10),m3h2x1(:,114),heltab2x2(:,:,156))
  call Hloop_A_Q(ntryL,G1H1(10),27,nMB,G2H1(40),n2h1(51))
call HGT_OLR(G1H2(92),1,1,2)
call HGT_invQ_OLR(G1H2(92),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(92),-4,nMB,G2H2(60),n2h2(71))
  call Hloop_QS_A(ntryL,G2H2(60),ex3(:),G2H2(63),ngH,m3h1x2(:,43),heltab2x2(:,:,157))
  call Hloop_AV_Q(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,158))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(41),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(5),m3h2x1(:,116),heltab2x2(:,:,159))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(42),n2h1(53))
  call Hloop_AV_Q(ntryL,G0H2(9),ex4(:),G0H1(1),m3h2x1(:,117),heltab2x2(:,:,160))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(34),n2h1(54))
  call Hloop_TV_S(ntryL,G1H2(96),19,ex4(:),8,G2H1(43),m3h2x1(:,118),heltab2x2(:,:,161))
call HGT_OLR(G1H2(95),1,1,2)
call HGT_invQ_OLR(G1H2(95),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(95),ex3(:),G1H2(16),m3h1x2(:,44),heltab2x2(:,:,162))
  call Hloop_TV_S(ntryL,G1H2(21),19,ex4(:),8,G2H1(44),m3h2x1(:,119),heltab2x2(:,:,163))
  call Hloop_TV_S(ntryL,G1H2(12),19,ex4(:),8,G2H1(45),m3h2x1(:,120),heltab2x2(:,:,164))
  call Hloop_SV_T(ntryL,G1H2(109),19,ex4(:),8,G2H1(46),m3h2x1(:,121),heltab2x2(:,:,165))
call HGT_OLR(G1H2(112),1,1,2)
call HGT_invQ_OLR(G1H2(112),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(112),ex3(:),G1H2(8),m3h1x2(:,45),heltab2x2(:,:,166))
  call Hloop_SV_T(ntryL,G1H2(108),19,ex4(:),8,G2H1(47),m3h2x1(:,122),heltab2x2(:,:,167))
  call Hloop_SV_T(ntryL,G1H2(3),19,ex4(:),8,G2H1(48),m3h2x1(:,123),heltab2x2(:,:,168))
  call Hloop_CV_D(ntryL,G1H2(17),19,ex4(:),8,G2H1(49),m3h2x1(:,124),heltab2x2(:,:,169))
call HGT_OLR(G1H2(113),1,1,2)
call HGT_invQ_OLR(G1H2(113),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(113),ex3(:),G1H2(25),m3h1x2(:,46),heltab2x2(:,:,170))
  call Hloop_CV_D(ntryL,G1H2(115),19,ex4(:),8,G2H1(50),m3h2x1(:,125),heltab2x2(:,:,171))
  call Hloop_CV_D(ntryL,G1H2(116),19,ex4(:),8,G2H1(51),m3h2x1(:,126),heltab2x2(:,:,172))
  call Hloop_DV_C(ntryL,G1H2(117),19,ex4(:),G2H1(52),m3h2x1(:,127),heltab2x2(:,:,173))
call HGT_OLR(G1H2(118),1,1,2)
call HGT_invQ_OLR(G1H2(118),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(118),ex3(:),G1H2(59),m3h1x2(:,47),heltab2x2(:,:,174))
  call Hloop_DV_C(ntryL,G1H2(120),19,ex4(:),G2H1(53),m3h2x1(:,128),heltab2x2(:,:,175))
  call Hloop_DV_C(ntryL,G1H2(121),19,ex4(:),G2H1(54),m3h2x1(:,129),heltab2x2(:,:,176))
  call Hloop_AS_Q(ntryL,G1H2(60),ex3(:),G1H2(58),ngH,m3h1x2(:,48),heltab2x2(:,:,177))
  call Hloop_A_Q(ntryL,G1H2(58),23,nML,G2H2(64),n2h2(76))
call HGT_OLR(G1H2(66),1,1,2)
call HGT_invQ_OLR(G1H2(66),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(66),-8,nML,G2H2(68),n2h2(77))
  call Hloop_QV_A(ntryL,G2H2(68),ex4(:),G2H1(55),m3h2x1(:,130),heltab2x2(:,:,178))
  call Hloop_AS_Q(ntryL,G1H2(6),ex3(:),G1H2(46),ngH,m3h1x2(:,49),heltab2x2(:,:,179))
  call Hloop_A_Q(ntryL,G1H2(46),23,nML,G2H2(40),n2h2(78))
  call Hloop_AS_Q(ntryL,G1H2(7),ex3(:),G1H2(42),ngH,m3h1x2(:,50),heltab2x2(:,:,180))
  call Hloop_A_Q(ntryL,G1H2(42),23,nML,G2H2(48),n2h2(79))
  call Hloop_AS_Q(ntryL,G0H2(3),ex3(:),G0H2(16),ngH,m3h1x2(:,51),heltab2x2(:,:,181))
  call Hloop_A_Q(ntryL,G0H2(16),23,nML,G1H2(64),n2h2(80))
  call Hloop_QS_A(ntryL,G1H2(30),ex3(:),G1H2(52),ngH,m3h1x2(:,52),heltab2x2(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(52),23,nML,G2H2(50),n2h2(81))
call HGT_OLR(G1H2(122),1,1,2)
call HGT_invQ_OLR(G1H2(122),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(122),-8,nML,G2H2(52),n2h2(82))
  call Hloop_AV_Q(ntryL,G2H2(52),ex4(:),G2H1(56),m3h2x1(:,131),heltab2x2(:,:,183))
  call Hloop_QS_A(ntryL,G1H2(124),ex3(:),G1H2(65),ngH,m3h1x2(:,53),heltab2x2(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(65),23,nML,G2H2(56),n2h2(83))
  call Hloop_QS_A(ntryL,G1H2(125),ex3(:),G1H2(53),ngH,m3h1x2(:,54),heltab2x2(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(53),23,nML,G2H2(60),n2h2(84))
  call Hloop_QS_A(ntryL,G0H2(1),ex3(:),G0H2(14),ngH,m3h1x2(:,55),heltab2x2(:,:,186))
  call Hloop_Q_A(ntryL,G0H2(14),23,nML,G1H2(76),n2h2(85))
  call Hloop_AS_Q(ntryL,G1H2(126),ex3(:),G1H2(71),ngH,m3h1x2(:,56),heltab2x2(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(71),23,nMT,G2H2(68),n2h2(86))
call HGT_OLR(G1H2(127),1,1,2)
call HGT_invQ_OLR(G1H2(127),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(127),-8,nMT,G2H2(52),n2h2(87))
  call Hloop_QV_A(ntryL,G2H2(52),ex4(:),G2H1(57),m3h2x1(:,132),heltab2x2(:,:,188))
  call Hloop_AS_Q(ntryL,G1H2(129),ex3(:),G1H2(77),ngH,m3h1x2(:,57),heltab2x2(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(77),23,nMT,G2H2(52),n2h2(88))
  call Hloop_AS_Q(ntryL,G1H2(130),ex3(:),G1H2(72),ngH,m3h1x2(:,58),heltab2x2(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(72),23,nMT,G2H2(73),n2h2(89))
  call Hloop_AS_Q(ntryL,G0H2(4),ex3(:),G0H2(23),ngH,m3h1x2(:,59),heltab2x2(:,:,191))
  call Hloop_A_Q(ntryL,G0H2(23),23,nMT,G1H2(29),n2h2(90))
  call Hloop_QS_A(ntryL,G1H2(131),ex3(:),G1H2(1),ngH,m3h1x2(:,60),heltab2x2(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(74),n2h2(91))
call HGT_OLR(G1H2(132),1,1,2)
call HGT_invQ_OLR(G1H2(132),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(132),-8,nMT,G2H2(75),n2h2(92))
  call Hloop_AV_Q(ntryL,G2H2(75),ex4(:),G2H1(58),m3h2x1(:,133),heltab2x2(:,:,193))
  call Hloop_QS_A(ntryL,G1H2(134),ex3(:),G1H2(82),ngH,m3h1x2(:,61),heltab2x2(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(82),23,nMT,G2H2(75),n2h2(93))
  call Hloop_QS_A(ntryL,G1H2(135),ex3(:),G1H2(78),ngH,m3h1x2(:,62),heltab2x2(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(78),23,nMT,G2H2(76),n2h2(94))
  call Hloop_QS_A(ntryL,G0H2(2),ex3(:),G0H2(21),ngH,m3h1x2(:,63),heltab2x2(:,:,196))
  call Hloop_Q_A(ntryL,G0H2(21),23,nMT,G1H2(85),n2h2(95))
  call Hloop_AS_Q(ntryL,G1H2(136),ex3(:),G1H2(37),ngH,m3h1x2(:,64),heltab2x2(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(37),23,nMB,G2H2(77),n2h2(96))
call HGT_OLR(G1H2(137),1,1,2)
call HGT_invQ_OLR(G1H2(137),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(137),-8,nMB,G2H2(78),n2h2(97))
  call Hloop_QV_A(ntryL,G2H2(78),ex4(:),G2H1(59),m3h2x1(:,134),heltab2x2(:,:,198))
  call Hloop_AS_Q(ntryL,G1H2(139),ex3(:),G1H2(35),ngH,m3h1x2(:,65),heltab2x2(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(35),23,nMB,G2H2(78),n2h2(98))
  call Hloop_AS_Q(ntryL,G1H2(140),ex3(:),G1H2(31),ngH,m3h1x2(:,66),heltab2x2(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(31),23,nMB,G2H2(79),n2h2(99))
  call Hloop_AS_Q(ntryL,G0H2(8),ex3(:),G0H2(24),ngH,m3h1x2(:,67),heltab2x2(:,:,201))
  call Hloop_A_Q(ntryL,G0H2(24),23,nMB,G1H2(87),n2h2(100))
  call Hloop_QS_A(ntryL,G1H2(141),ex3(:),G1H2(83),ngH,m3h1x2(:,68),heltab2x2(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMB,G2H2(80),n2h2(101))
call HGT_OLR(G1H2(142),1,1,2)
call HGT_invQ_OLR(G1H2(142),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(142),-8,nMB,G2H2(81),n2h2(102))
  call Hloop_AV_Q(ntryL,G2H2(81),ex4(:),G2H1(60),m3h2x1(:,135),heltab2x2(:,:,203))
  call Hloop_QS_A(ntryL,G1H2(144),ex3(:),G1H2(88),ngH,m3h1x2(:,69),heltab2x2(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(88),23,nMB,G2H2(81),n2h2(103))
  call Hloop_QS_A(ntryL,G1H2(145),ex3(:),G1H2(84),ngH,m3h1x2(:,70),heltab2x2(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(84),23,nMB,G2H2(82),n2h2(104))
  call Hloop_QS_A(ntryL,G0H2(7),ex3(:),G0H2(22),ngH,m3h1x2(:,71),heltab2x2(:,:,206))
  call Hloop_Q_A(ntryL,G0H2(22),23,nMB,G1H2(24),n2h2(105))
  call Hloop_ST_V(ntryL,G1H2(86),19,ex3(:),4,G2H2(83),m3h1x2(:,72),heltab2x2(:,:,207))
call HGT_OLR(G1H2(89),1,1,2)
call HGT_invQ_OLR(G1H2(89),2,5,2)
  call Hloop_SV_V(ntryL,G1H2(89),ex4(:),G1H1(10),m3h2x1(:,136),heltab2x2(:,:,208))
  call Hloop_ST_V(ntryL,G1H2(147),19,ex3(:),4,G2H2(84),m3h1x2(:,73),heltab2x2(:,:,209))
  call Hloop_ST_V(ntryL,G1H2(148),19,ex3(:),4,G2H2(85),m3h1x2(:,74),heltab2x2(:,:,210))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,17),G1H2(97),m3h4x2(:,169),heltab2x8(:,:,317))
  call Hloop_Q_A(ntryL,G1H2(97),23,nML,G2H2(86),n2h2(107))
call HGT_OLR(G1H8(9),1,1,8)
call HGT_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(9),-8,nML,G2H8(1),n2h8(72))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(4),m3h2x4(:,65),heltab2x8(:,:,318))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,17),G1H2(91),m3h4x2(:,170),heltab2x8(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(91),23,nML,G2H2(87),n2h2(108))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,17),G1H2(98),m3h4x2(:,171),heltab2x8(:,:,320))
  call Hloop_Q_A(ntryL,G1H2(98),23,nML,G2H2(88),n2h2(109))
  call Hloop_QV_A(ntryL,G0H8(87),wf4(:,17),G0H2(20),m3h4x2(:,172),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G0H2(20),23,nML,G1H2(94),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H8(26),wf4(:,17),G1H2(92),m3h4x2(:,173),heltab2x8(:,:,322))
  call Hloop_A_Q(ntryL,G1H2(92),23,nML,G2H2(89),n2h2(111))
call HGT_OLR(G1H8(27),1,1,8)
call HGT_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(27),-8,nML,G2H8(2),n2h8(73))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(8),m3h2x4(:,66),heltab2x8(:,:,323))
  call Hloop_AV_Q(ntryL,G1H8(29),wf4(:,17),G1H2(102),m3h4x2(:,174),heltab2x8(:,:,324))
  call Hloop_A_Q(ntryL,G1H2(102),23,nML,G2H2(90),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,17),G1H2(101),m3h4x2(:,175),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H2(101),23,nML,G2H2(91),n2h2(113))
  call Hloop_AV_Q(ntryL,G0H8(4),wf4(:,17),G0H2(19),m3h4x2(:,176),heltab2x8(:,:,326))
  call Hloop_A_Q(ntryL,G0H2(19),23,nML,G1H2(96),n2h2(114))
  call Hloop_QV_A(ntryL,G1H8(32),wf4(:,17),G1H2(95),m3h4x2(:,177),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(95),23,nMT,G2H2(92),n2h2(115))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(34),-8,nMT,G2H8(3),n2h8(74))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(7),m3h2x4(:,67),heltab2x8(:,:,328))
  call Hloop_QV_A(ntryL,G1H8(36),wf4(:,17),G1H2(21),m3h4x2(:,178),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(93),n2h2(116))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,17),G1H2(12),m3h4x2(:,179),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(94),n2h2(117))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,17),G0H2(6),m3h4x2(:,180),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G0H2(6),23,nMT,G1H2(109),n2h2(118))
  call Hloop_AV_Q(ntryL,G1H8(38),wf4(:,17),G1H2(112),m3h4x2(:,181),heltab2x8(:,:,332))
  call Hloop_A_Q(ntryL,G1H2(112),23,nMT,G2H2(95),n2h2(119))
call HGT_OLR(G1H8(39),1,1,8)
call HGT_invQ_OLR(G1H8(39),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(39),-8,nMT,G2H8(4),n2h8(75))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(11),m3h2x4(:,68),heltab2x8(:,:,333))
  call Hloop_AV_Q(ntryL,G1H8(41),wf4(:,17),G1H2(108),m3h4x2(:,182),heltab2x8(:,:,334))
  call Hloop_A_Q(ntryL,G1H2(108),23,nMT,G2H2(96),n2h2(120))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,17),G1H2(3),m3h4x2(:,183),heltab2x8(:,:,335))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMT,G2H2(97),n2h2(121))
  call Hloop_AV_Q(ntryL,G0H8(7),wf4(:,17),G0H2(5),m3h4x2(:,184),heltab2x8(:,:,336))
  call Hloop_A_Q(ntryL,G0H2(5),23,nMT,G1H2(17),n2h2(122))
  call Hloop_QV_A(ntryL,G1H8(43),wf4(:,17),G1H2(113),m3h4x2(:,185),heltab2x8(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(113),23,nMB,G2H2(98),n2h2(123))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-8,nMB,G2H8(5),n2h8(76))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(1),m3h2x4(:,69),heltab2x8(:,:,338))
  call Hloop_QV_A(ntryL,G1H8(46),wf4(:,17),G1H2(115),m3h4x2(:,186),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(115),23,nMB,G2H2(99),n2h2(124))
  call Hloop_QV_A(ntryL,G1H8(47),wf4(:,17),G1H2(116),m3h4x2(:,187),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G1H2(116),23,nMB,G2H2(100),n2h2(125))
  call Hloop_QV_A(ntryL,G0H8(8),wf4(:,17),G0H2(15),m3h4x2(:,188),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G0H2(15),23,nMB,G1H2(117),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,17),G1H2(118),m3h4x2(:,189),heltab2x8(:,:,342))
  call Hloop_A_Q(ntryL,G1H2(118),23,nMB,G2H2(101),n2h2(127))
call HGT_OLR(G1H8(49),1,1,8)
call HGT_invQ_OLR(G1H8(49),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(49),-8,nMB,G2H8(6),n2h8(77))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(2),m3h2x4(:,70),heltab2x8(:,:,343))
  call Hloop_AV_Q(ntryL,G1H8(52),wf4(:,17),G1H2(120),m3h4x2(:,190),heltab2x8(:,:,344))
  call Hloop_A_Q(ntryL,G1H2(120),23,nMB,G2H2(102),n2h2(128))
  call Hloop_AV_Q(ntryL,G1H8(54),wf4(:,17),G1H2(121),m3h4x2(:,191),heltab2x8(:,:,345))
  call Hloop_A_Q(ntryL,G1H2(121),23,nMB,G2H2(103),n2h2(129))
  call Hloop_AV_Q(ntryL,G0H8(9),wf4(:,17),G0H2(13),m3h4x2(:,192),heltab2x8(:,:,346))
  call Hloop_A_Q(ntryL,G0H2(13),23,nMB,G1H2(60),n2h2(130))
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,18),G1H2(58),ngZl,m3h4x2(:,193),heltab2x8(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(58),23,nML,G2H2(104),n2h2(131))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-8,nML,G2H8(7),n2h8(78))
  call Hloop_AV_Q(ntryL,G2H8(7),ex4(:),G2H4(3),m3h2x4(:,71),heltab2x8(:,:,348))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,18),G1H2(66),ngZl,m3h4x2(:,194),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(66),23,nML,G2H2(105),n2h2(132))
  call Hloop_QZ_A(ntryL,G1H8(59),wf4(:,18),G1H2(6),ngZl,m3h4x2(:,195),heltab2x8(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(6),23,nML,G2H2(106),n2h2(133))
  call Hloop_QZ_A(ntryL,G0H8(10),wf4(:,18),G0H2(18),ngZl,m3h4x2(:,196),heltab2x8(:,:,351))
  call Hloop_Q_A(ntryL,G0H2(18),23,nML,G1H2(46),n2h2(134))
  call Hloop_AZ_Q(ntryL,G1H8(60),wf4(:,18),G1H2(7),ngZl,m3h4x2(:,197),heltab2x8(:,:,352))
  call Hloop_A_Q(ntryL,G1H2(7),23,nML,G2H2(107),n2h2(135))
call HGT_OLR(G1H8(61),1,1,8)
call HGT_invQ_OLR(G1H8(61),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(61),-8,nML,G2H8(8),n2h8(79))
  call Hloop_QV_A(ntryL,G2H8(8),ex4(:),G2H4(5),m3h2x4(:,72),heltab2x8(:,:,353))
  call Hloop_AZ_Q(ntryL,G1H8(63),wf4(:,18),G1H2(42),ngZl,m3h4x2(:,198),heltab2x8(:,:,354))
  call Hloop_A_Q(ntryL,G1H2(42),23,nML,G2H2(108),n2h2(136))
  call Hloop_AZ_Q(ntryL,G1H8(64),wf4(:,18),G1H2(30),ngZl,m3h4x2(:,199),heltab2x8(:,:,355))
  call Hloop_A_Q(ntryL,G1H2(30),23,nML,G2H2(109),n2h2(137))
  call Hloop_AZ_Q(ntryL,G0H8(11),wf4(:,18),G0H2(17),ngZl,m3h4x2(:,200),heltab2x8(:,:,356))
  call Hloop_A_Q(ntryL,G0H2(17),23,nML,G1H2(52),n2h2(138))
  call Hloop_QZ_A(ntryL,G1H8(65),wf4(:,18),G1H2(122),ngZu,m3h4x2(:,201),heltab2x8(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(122),23,nMT,G2H2(110),n2h2(139))
call HGT_OLR(G1H8(66),1,1,8)
call HGT_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(66),-8,nMT,G2H8(9),n2h8(80))
  call Hloop_AV_Q(ntryL,G2H8(9),ex4(:),G2H4(6),m3h2x4(:,73),heltab2x8(:,:,358))
  call Hloop_QZ_A(ntryL,G1H8(68),wf4(:,18),G1H2(124),ngZu,m3h4x2(:,202),heltab2x8(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(124),23,nMT,G2H2(111),n2h2(140))
  call Hloop_QZ_A(ntryL,G1H8(69),wf4(:,18),G1H2(65),ngZu,m3h4x2(:,203),heltab2x8(:,:,360))
  call Hloop_Q_A(ntryL,G1H2(65),23,nMT,G2H2(112),n2h2(141))
  call Hloop_QZ_A(ntryL,G0H8(12),wf4(:,18),G0H2(12),ngZu,m3h4x2(:,204),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G0H2(12),23,nMT,G1H2(125),n2h2(142))
  call Hloop_AZ_Q(ntryL,G1H8(70),wf4(:,18),G1H2(53),ngZu,m3h4x2(:,205),heltab2x8(:,:,362))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMT,G2H2(113),n2h2(143))
call HGT_OLR(G1H8(73),1,1,8)
call HGT_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(73),-8,nMT,G2H8(10),n2h8(81))
  call Hloop_QV_A(ntryL,G2H8(10),ex4(:),G2H4(12),m3h2x4(:,74),heltab2x8(:,:,363))
  call Hloop_AZ_Q(ntryL,G1H8(77),wf4(:,18),G1H2(126),ngZu,m3h4x2(:,206),heltab2x8(:,:,364))
  call Hloop_A_Q(ntryL,G1H2(126),23,nMT,G2H2(114),n2h2(144))
  call Hloop_AZ_Q(ntryL,G1H8(78),wf4(:,18),G1H2(71),ngZu,m3h4x2(:,207),heltab2x8(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(71),23,nMT,G2H2(115),n2h2(145))
  call Hloop_AZ_Q(ntryL,G0H8(13),wf4(:,18),G0H2(10),ngZu,m3h4x2(:,208),heltab2x8(:,:,366))
  call Hloop_A_Q(ntryL,G0H2(10),23,nMT,G1H2(127),n2h2(146))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,18),G1H2(129),ngZd,m3h4x2(:,209),heltab2x8(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(129),23,nMB,G2H2(116),n2h2(147))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-8,nMB,G2H8(11),n2h8(82))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(13),m3h2x4(:,75),heltab2x8(:,:,368))
  call Hloop_QZ_A(ntryL,G1H8(82),wf4(:,18),G1H2(77),ngZd,m3h4x2(:,210),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(77),23,nMB,G2H2(117),n2h2(148))
  call Hloop_QZ_A(ntryL,G1H8(83),wf4(:,18),G1H2(130),ngZd,m3h4x2(:,211),heltab2x8(:,:,370))
  call Hloop_Q_A(ntryL,G1H2(130),23,nMB,G2H2(118),n2h2(149))
  call Hloop_QZ_A(ntryL,G0H8(14),wf4(:,18),G0H2(11),ngZd,m3h4x2(:,212),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G0H2(11),23,nMB,G1H2(72),n2h2(150))
  call Hloop_AZ_Q(ntryL,G1H8(84),wf4(:,18),G1H2(131),ngZd,m3h4x2(:,213),heltab2x8(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(131),23,nMB,G2H2(119),n2h2(151))
call HGT_OLR(G1H8(85),1,1,8)
call HGT_invQ_OLR(G1H8(85),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(85),-8,nMB,G2H8(12),n2h8(83))
  call Hloop_QV_A(ntryL,G2H8(12),ex4(:),G2H4(14),m3h2x4(:,76),heltab2x8(:,:,373))
  call Hloop_AZ_Q(ntryL,G1H8(87),wf4(:,18),G1H2(1),ngZd,m3h4x2(:,214),heltab2x8(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(120),n2h2(152))
  call Hloop_AZ_Q(ntryL,G1H8(88),wf4(:,18),G1H2(132),ngZd,m3h4x2(:,215),heltab2x8(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(132),23,nMB,G2H2(121),n2h2(153))
  call Hloop_AZ_Q(ntryL,G0H8(15),wf4(:,18),G0H2(9),ngZd,m3h4x2(:,216),heltab2x8(:,:,376))
  call Hloop_A_Q(ntryL,G0H2(9),23,nMB,G1H2(134),n2h2(154))
  call Hloop_TV_S(ntryL,G1H8(89),20,wf4(:,17),3,G2H2(122),m3h4x2(:,217),heltab2x8(:,:,377))
call HGT_raise_alpha_OLR(G1H8(90),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(90),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(90),ex4(:),G1H4(16),m3h2x4(:,77),heltab2x8(:,:,378))
  call Hloop_TV_S(ntryL,G1H8(94),20,wf4(:,17),3,G2H2(123),m3h4x2(:,218),heltab2x8(:,:,379))
  call Hloop_TV_S(ntryL,G1H8(96),20,wf4(:,17),3,G2H2(124),m3h4x2(:,219),heltab2x8(:,:,380))
  call Hloop_SV_T(ntryL,G1H8(98),20,wf4(:,17),3,G2H2(125),m3h4x2(:,220),heltab2x8(:,:,381))
call HGT_raise_alpha_OLR(G1H8(99),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(99),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(99),ex4(:),G1H4(4),m3h2x4(:,78),heltab2x8(:,:,382))
  call Hloop_SV_T(ntryL,G1H8(101),20,wf4(:,17),3,G2H2(126),m3h4x2(:,221),heltab2x8(:,:,383))
  call Hloop_SV_T(ntryL,G1H8(102),20,wf4(:,17),3,G2H2(127),m3h4x2(:,222),heltab2x8(:,:,384))
  call Hloop_TV_S(ntryL,G1H8(103),20,wf4(:,18),3,G2H2(128),m3h4x2(:,223),heltab2x8(:,:,385))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(104),ex4(:),G1H4(13),m3h2x4(:,79),heltab2x8(:,:,386))
  call Hloop_TV_S(ntryL,G1H8(106),20,wf4(:,18),3,G2H2(129),m3h4x2(:,224),heltab2x8(:,:,387))
  call Hloop_TV_S(ntryL,G1H8(107),20,wf4(:,18),3,G2H2(130),m3h4x2(:,225),heltab2x8(:,:,388))
  call Hloop_SV_T(ntryL,G1H8(6),20,wf4(:,18),3,G2H2(131),m3h4x2(:,226),heltab2x8(:,:,389))
call HGT_raise_alpha_OLR(G1H8(108),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(108),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(108),ex4(:),G1H4(8),m3h2x4(:,80),heltab2x8(:,:,390))
  call Hloop_SV_T(ntryL,G1H8(109),20,wf4(:,18),3,G2H2(132),m3h4x2(:,227),heltab2x8(:,:,391))
  call Hloop_SV_T(ntryL,G1H8(10),20,wf4(:,18),3,G2H2(133),m3h4x2(:,228),heltab2x8(:,:,392))
  call Hloop_UV_W(ntryL,G1H8(110),20,wf4(:,17),3,G2H2(134),m3h4x2(:,229),heltab2x8(:,:,393))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(11),ex4(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,394))
  call Hloop_UV_W(ntryL,G1H8(15),20,wf4(:,17),3,G2H2(135),m3h4x2(:,230),heltab2x8(:,:,395))
  call Hloop_UV_W(ntryL,G1H8(112),20,wf4(:,17),3,G2H2(136),m3h4x2(:,231),heltab2x8(:,:,396))
  call Hloop_UW_V(ntryL,G1H8(24),20,wf4(:,17),3,G2H2(137),m3h4x2(:,232),heltab2x8(:,:,397))
call HGT_OLR(G1H8(113),1,1,8)
call HGT_invQ_OLR(G1H8(113),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(113),ex4(:),G1H4(21),m3h2x4(:,82),heltab2x8(:,:,398))
  call Hloop_UW_V(ntryL,G1H8(114),20,wf4(:,17),3,G2H2(138),m3h4x2(:,233),heltab2x8(:,:,399))
  call Hloop_UW_V(ntryL,G1H8(33),20,wf4(:,17),3,G2H2(139),m3h4x2(:,234),heltab2x8(:,:,400))
  call Hloop_UV_W(ntryL,G1H8(115),20,wf4(:,18),3,G2H2(140),m3h4x2(:,235),heltab2x8(:,:,401))
call HGT_OLR(G1H8(51),1,1,8)
call HGT_invQ_OLR(G1H8(51),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(51),ex4(:),G1H4(3),m3h2x4(:,83),heltab2x8(:,:,402))
  call Hloop_UV_W(ntryL,G1H8(53),20,wf4(:,18),3,G2H2(141),m3h4x2(:,236),heltab2x8(:,:,403))
  call Hloop_UV_W(ntryL,G1H8(117),20,wf4(:,18),3,G2H2(142),m3h4x2(:,237),heltab2x8(:,:,404))
  call Hloop_UW_V(ntryL,G1H8(71),20,wf4(:,18),3,G2H2(143),m3h4x2(:,238),heltab2x8(:,:,405))
call HGT_OLR(G1H8(118),1,1,8)
call HGT_invQ_OLR(G1H8(118),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(118),ex4(:),G1H4(5),m3h2x4(:,84),heltab2x8(:,:,406))
  call Hloop_UW_V(ntryL,G1H8(119),20,wf4(:,18),3,G2H2(144),m3h4x2(:,239),heltab2x8(:,:,407))
  call Hloop_UW_V(ntryL,G1H8(120),20,wf4(:,18),3,G2H2(145),m3h4x2(:,240),heltab2x8(:,:,408))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G2H2(140),G2H2(137),G2H2(134),G2H2(27),G2H2(24) &
    ,G1H2(104),G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G2H1(14),G2H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(18),[G2H1(17),G2H1(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(32)])
call HGT_lower_alpha_OLR(G1H2(28),1,1,2)
call HGT_lower_alpha_invQ_OLR(G1H2(28),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(13)])
call HGT_lower_alpha_OLR(G1H2(9),1,1,2)
call HGT_lower_alpha_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(65),G2H2(57),G2H2(53),G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(3),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G2H2(12),G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(13),G2H2(58),G2H2(54),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(22),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G2H1(9),G2H1(7),G1H1(18),G1H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(15),[G2H1(13),G2H1(10),G1H1(24),G1H1(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(16),[G1H1(31),G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(4),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(15),G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(21),[G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(20),[G1H1(37),G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(152),[G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(46),[G2H1(43),G1H1(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(22),[G2H1(19),G1H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(61),G2H2(41),G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(62),G2H2(42),G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(131),[G2H2(128),G2H2(125),G2H2(122),G1H2(150) &
    ,G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(24),[G2H1(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(48),[G2H1(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G2H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G2H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(134),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(130),G2H2(127),G2H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G2H2(142),G2H2(139),G2H2(136)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(143),ex4(:),G2tensor(20),m3h2x1(:,137),heltab2x2(:,:,211))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(9),m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(29),m3h1x1(:,30),heltab2x1(:,:,30))
call HGT_w2_OLR(G1H1(3),1,1,1)
call HGT_w2_invQ_OLR(G1H1(3),2,5,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(3),27,ex3(:),4,G2tensor(11),m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(35),m3h2x1(:,138),heltab2x2(:,:,212))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(22),mass4set(:,6),  & 
G1H2(82),G1H2(135),G1H2(78),G1H2(136),G1H2(37),2)
  call HG1shiftOLR(G1H2(135),8,2)
call HGT_w2_OLR(G1H1(4),1,1,1)
call HGT_w2_invQ_OLR(G1H1(4),2,5,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(4),27,ex3(:),4,G2tensor(13),m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(41),m3h2x1(:,139),heltab2x2(:,:,213))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(17),mass4set(:,6),  & 
G1H2(137),G1H2(139),G1H2(35),G1H2(140),G1H2(31),2)
  call HG1shiftOLR(G1H2(139),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(14),23,ex4(:),8,G2tensor(15),m3h2x1(:,140),heltab2x2(:,:,214))
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(19),mass4set(:,2),  & 
G1H2(141),G1H2(83),G1H2(142),G1H2(144),G1H2(88),2)
  call HG1shiftOLR(G1H2(83),8,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(5),23,ex4(:),8,G2tensor(1),m3h2x1(:,141),heltab2x2(:,:,215))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(2),mass4set(:,2),  & 
G1H2(145),G1H2(84),G1H2(86),G1H2(89),G1H2(147),2)
  call HG1shiftOLR(G1H2(84),8,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(22),23,ex4(:),8,G2tensor(3),m3h2x1(:,142),heltab2x2(:,:,216))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(154),23,ex4(:),8,G2tensor(5),m3h2x1(:,143),heltab2x2(:,:,217))
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(2),mass4set(:,2),  & 
G1H2(148),G1H2(97),G1H2(91),G1H2(98),G1H2(92),2)
  call HG1shiftOLR(G1H2(97),8,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(7),m3h2x1(:,144),heltab2x2(:,:,218))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(33),23,ex4(:),8,G2tensor(23),m3h2x1(:,145),heltab2x2(:,:,219))
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(19),mass4set(:,2),  & 
G1H2(102),G1H2(101),G1H2(95),G1H2(21),G1H2(12),2)
  call HG1shiftOLR(G1H2(101),8,2)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(22),27,ex3(:),4,G2tensor(32),m3h1x1(:,33),heltab2x1(:,:,33))
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(7),mass4set(:,2),  & 
G1H1(1),G1H1(5),G1H1(6),G1H1(18),G1H1(7),1)
  call HG1shiftOLR(G1H1(5),4,1)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(8),27,ex3(:),4,G2tensor(38),m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(12),27,ex3(:),4,G2tensor(44),m3h1x1(:,35),heltab2x1(:,:,35))
  call Hotf_4pt_reduction(G2H1(15),RedSet_4(7),mass4set(:,2),  & 
G1H1(24),G1H1(13),G1H1(31),G1H1(14),G1H1(17),1)
  call HG1shiftOLR(G1H1(13),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(16),27,ex3(:),4,G2tensor(17),m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(38),23,ex4(:),8,G2tensor(26),m3h2x1(:,146),heltab2x2(:,:,220))
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(2),mass4set(:,2),  & 
G1H2(112),G1H2(108),G1H2(3),G1H2(113),G1H2(115),2)
  call HG1shiftOLR(G1H2(108),8,2)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(40),23,ex4(:),8,G2tensor(53),m3h2x1(:,147),heltab2x2(:,:,221))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(153),23,ex4(:),8,G2tensor(65),m3h2x1(:,148),heltab2x2(:,:,222))
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(2),mass4set(:,2),  & 
G1H2(116),G1H2(118),G1H2(120),G1H2(121),G1H2(58),2)
  call HG1shiftOLR(G1H2(118),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(45),23,ex4(:),8,G2tensor(47),m3h2x1(:,149),heltab2x2(:,:,223))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(21),27,ex3(:),4,G2tensor(50),m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(19),27,ex3(:),4,G2tensor(56),m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(23),27,ex3(:),4,G2tensor(59),m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(20),27,ex3(:),4,G2tensor(62),m3h1x1(:,40),heltab2x1(:,:,40))
  call Hloop_QV_A(ntryL,G1H2(106),ex4(:),G1H1(37),m3h2x1(:,150),heltab2x2(:,:,224))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,0,G2tensor(68),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(50),ex4(:),G1H1(25),m3h2x1(:,151),heltab2x2(:,:,225))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,0,G2tensor(71),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(32),m3h2x1(:,152),heltab2x2(:,:,226))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,0,G2tensor(72),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(2),m3h2x1(:,153),heltab2x2(:,:,227))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,0,G2tensor(73),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(3),m3h2x1(:,154),heltab2x2(:,:,228))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,0,G2tensor(74),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(4),m3h2x1(:,155),heltab2x2(:,:,229))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),31,0,G2tensor(75),n2h1(60))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(29),27,ex3(:),4,G2tensor(76),m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(30),27,ex3(:),4,G2tensor(77),m3h1x1(:,42),heltab2x1(:,:,42))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(22),m3h2x1(:,156),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,0,G2tensor(78),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(62),ex4(:),G1H1(8),m3h2x1(:,157),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,0,G2tensor(79),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(63),ex4(:),G1H1(12),m3h2x1(:,158),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,0,G2tensor(80),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(16),m3h2x1(:,159),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,0,G2tensor(81),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(68),ex4(:),G1H1(21),m3h2x1(:,160),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,0,G2tensor(82),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(69),ex4(:),G1H1(19),m3h2x1(:,161),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(83),n2h1(66))
  call Hloop_WA_Q(ntryL,G1H2(73),ex2(:),G1H1(23),m3h2x1(:,162),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,0,G2tensor(84),n2h1(67))
  call Hloop_WA_Q(ntryL,G1H2(74),ex2(:),G1H1(20),m3h2x1(:,163),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,0,G2tensor(85),n2h1(68))
  call Hloop_WA_Q(ntryL,G1H2(81),ex2(:),G1H1(37),m3h2x1(:,164),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,0,G2tensor(86),n2h1(69))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(35),27,ex3(:),4,G2tensor(87),m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(36),27,ex3(:),4,G2tensor(88),m3h1x1(:,44),heltab2x1(:,:,44))
  call Hloop_WA_Q(ntryL,G1H2(79),ex2(:),G1H1(25),m3h2x1(:,165),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,0,G2tensor(89),n2h1(70))
  call Hloop_WA_Q(ntryL,G1H2(80),ex2(:),G1H1(32),m3h2x1(:,166),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),31,0,G2tensor(90),n2h1(71))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(71),ex2(:),G2tensor(91),m3h2x1(:,167),heltab2x2(:,:,241))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(70),ex4(:),G2tensor(92),m3h2x1(:,168),heltab2x2(:,:,242))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(69),ex1(:),G2tensor(93),m3h2x1(:,169),heltab2x2(:,:,243))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(94),m3h2x1(:,170),heltab2x2(:,:,244))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(29),ex1(:),G2tensor(95),m3h2x1(:,171),heltab2x2(:,:,245))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(1),ex3(:),G2tensor(96),m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(97),m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(98),m3h2x1(:,172),heltab2x2(:,:,246))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(3),ex3(:),G2tensor(99),m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(100),m3h2x1(:,173),heltab2x2(:,:,247))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(4),ex3(:),G2tensor(101),m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(102),m3h2x1(:,174),heltab2x2(:,:,248))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(103),m3h2x1(:,175),heltab2x2(:,:,249))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(5),ex3(:),G2tensor(104),m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(6),ex3(:),G2tensor(105),m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(27),ex3(:),G1tensor(1),m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(28),ex3(:),G1tensor(7),m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H2(48),ex4(:),ex3(:),G1tensor(13),m4h2x1x1(:,1),heltab3x2(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H2(18),ex4(:),ex3(:),G1tensor(19),m4h2x1x1(:,2),heltab3x2(:,:,2))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(46),ex3(:),G2tensor(106),m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(22),ex3(:),G2tensor(107),m3h1x1(:,54),heltab2x1(:,:,54))
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(2),mass4set(:,2),  & 
G1H2(66),G1H2(6),G1H2(7),G1H2(42),G1H2(30),2)
  call HG1shiftOLR(G1H2(6),8,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(2),mass4set(:,2),  & 
G1H2(122),G1H2(124),G1H2(65),G1H2(53),G1H2(126),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(108),m3h2x1(:,176),heltab2x2(:,:,250))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(109),m3h2x1(:,177),heltab2x2(:,:,251))
  call Hotf_4pt_reduction(G2H2(67),RedSet_4(19),mass4set(:,2),  & 
G1H2(71),G1H2(129),G1H2(77),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(129),8,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(19),mass4set(:,2),  & 
G1H2(1),G1H2(132),G1H2(104),G1H2(100),G1H2(32),2)
  call HG1shiftOLR(G1H2(132),8,2)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(19),mass4set(:,2),  & 
G1H2(28),G1H2(13),G1H2(9),G1H2(2),G1H2(19),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(19),mass4set(:,2),  & 
G1H2(26),G1H2(27),G1H2(34),G1H2(39),G1H2(43),2)
  call HG1shiftOLR(G1H2(27),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(131),ex4(:),G2tensor(110),m3h2x1(:,178),heltab2x2(:,:,252))
  call Hloop_ZQ_A(ntryL,G1H4(20),wf4(:,2),G1H1(2),ngZu,m3h4x1(:,5),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,0,G2tensor(111),n2h1(72))
  call Hloop_WQ_A(ntryL,G1H4(2),wf4(:,2),G1H1(3),m3h4x1(:,6),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,0,G2tensor(112),n2h1(73))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(9),wf4(:,2),G2tensor(113),m3h4x1(:,7),heltab2x4(:,:,103))
  call Hloop_ZA_Q(ntryL,G1H4(9),wf4(:,4),G1H1(4),ngZu,m3h4x1(:,8),heltab2x4(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,0,G2tensor(114),n2h1(74))
  call Hloop_WA_Q(ntryL,G1H4(10),wf4(:,4),G1H1(29),m3h4x1(:,9),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,0,G2tensor(115),n2h1(75))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(10),wf4(:,4),G2tensor(116),m3h4x1(:,10),heltab2x4(:,:,106))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(22),mass4set(:,7),  & 
G1H2(44),G1H2(49),G1H2(55),G1H2(61),G1H2(67),2)
  call HG1shiftOLR(G1H2(49),8,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(22),mass4set(:,8),  & 
G1H2(75),G1H2(146),G1H2(99),G1H2(150),G1H2(149),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(22),mass4set(:,9),  & 
G1H2(94),G1H2(96),G1H2(109),G1H2(17),G1H2(117),2)
  call HG1shiftOLR(G1H2(96),8,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(17),mass4set(:,7),  & 
G1H2(60),G1H2(14),G1H2(5),G1H2(22),G1H2(154),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(17),mass4set(:,8),  & 
G1H2(15),G1H2(33),G1H2(38),G1H2(40),G1H2(153),2)
  call HG1shiftOLR(G1H2(33),8,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(17),mass4set(:,9),  & 
G1H2(45),G1H2(106),G1H2(50),G1H2(51),G1H2(107),2)
  call HG1shiftOLR(G1H2(106),8,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(47),mass4set(:,10),  & 
G1H2(56),G1H2(57),G1H2(151),G1H2(62),G1H2(63),2)
  call HG1shiftOLR(G1H2(57),2,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(117),m3h2x1(:,179),heltab2x2(:,:,253))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(118),m3h2x1(:,180),heltab2x2(:,:,254))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(119),m3h2x1(:,181),heltab2x2(:,:,255))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(24),ex3(:),G2tensor(120),m3h1x1(:,55),heltab2x1(:,:,55))
  call Hotf_4pt_reduction(G2H1(25),RedSet_4(7),mass4set(:,3),  & 
G1H1(30),G1H1(22),G1H1(8),G1H1(12),G1H1(16),1)
  call HG1shiftOLR(G1H1(22),4,1)
  call Hloop_QS_A(ntryL,G2H1(27),ex3(:),G2H1(14),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(14),31,nML,G3tensor(1),n2h1(76))
  call Hloop_QS_A(ntryL,G1H1(33),ex3(:),G1H1(21),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nML,G2tensor(121),n2h1(77))
  call Hotf_4pt_reduction(G2H1(28),RedSet_4(7),mass4set(:,3),  & 
G1H1(19),G1H1(23),G1H1(20),G1H1(37),G1H1(35),1)
  call HG1shiftOLR(G1H1(23),4,1)
  call Hloop_AS_Q(ntryL,G2H1(30),ex3(:),G2H1(8),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,nML,G3tensor(2),n2h1(78))
  call Hloop_AS_Q(ntryL,G1H1(11),ex3(:),G1H1(36),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),31,nML,G2tensor(122),n2h1(79))
  call Hotf_4pt_reduction(G2H1(31),RedSet_4(7),mass4set(:,4),  & 
G1H1(25),G1H1(32),G1H1(27),G1H1(28),G1H1(2),1)
  call HG1shiftOLR(G1H1(32),4,1)
  call Hloop_QS_A(ntryL,G2H1(33),ex3(:),G2H1(17),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,nMT,G3tensor(3),n2h1(80))
  call Hloop_QS_A(ntryL,G1H1(9),ex3(:),G1H1(3),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,nMT,G2tensor(123),n2h1(81))
  call Hotf_4pt_reduction(G2H1(34),RedSet_4(7),mass4set(:,4),  & 
G1H1(4),G1H1(29),G1H1(33),G1H1(21),G1H1(11),1)
  call HG1shiftOLR(G1H1(29),4,1)
  call Hloop_AS_Q(ntryL,G2H1(36),ex3(:),G2H1(11),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),31,nMT,G3tensor(4),n2h1(82))
  call Hloop_AS_Q(ntryL,G1H1(15),ex3(:),G1H1(36),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),31,nMT,G2tensor(124),n2h1(83))
  call Hotf_4pt_reduction(G2H1(37),RedSet_4(7),mass4set(:,5),  & 
G1H1(9),G1H1(3),G1H1(15),G1H1(36),G1H1(39),1)
  call HG1shiftOLR(G1H1(3),4,1)
  call Hloop_QS_A(ntryL,G2H1(39),ex3(:),G2H1(9),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMB,G3tensor(5),n2h1(84))
  call Hloop_QS_A(ntryL,G1H1(38),ex3(:),G1H1(40),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),31,nMB,G2tensor(125),n2h1(85))
  call Hotf_4pt_reduction(G2H1(40),RedSet_4(7),mass4set(:,5),  & 
G1H1(38),G1H1(40),G1H1(41),G1H1(42),G1H1(43),1)
  call HG1shiftOLR(G1H1(40),4,1)
  call Hloop_AS_Q(ntryL,G2H1(42),ex3(:),G2H1(7),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(6),n2h1(86))
  call Hloop_AS_Q(ntryL,G1H1(34),ex3(:),G1H1(44),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(126),n2h1(87))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(48),ex3(:),G2tensor(127),m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(49),ex3(:),G2tensor(128),m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(51),ex3(:),G2tensor(129),m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(52),ex3(:),G2tensor(130),m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(54),ex3(:),G2tensor(131),m3h1x1(:,72),heltab2x1(:,:,72))
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(2),mass4set(:,3),  & 
G1H2(152),G1H2(68),G1H2(69),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hloop_AV_Q(ntryL,G2H2(48),ex4(:),G2H1(13),m3h2x1(:,182),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),31,nML,G3tensor(7),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(64),ex4(:),G1H1(34),m3h2x1(:,183),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nML,G2tensor(132),n2h1(89))
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(2),mass4set(:,3),  & 
G1H2(81),G1H2(79),G1H2(80),G1H2(48),G1H2(18),2)
  call HG1shiftOLR(G1H2(79),8,2)
  call Hloop_QV_A(ntryL,G2H2(60),ex4(:),G2H1(10),m3h2x1(:,184),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nML,G3tensor(8),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(44),m3h2x1(:,185),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nML,G2tensor(133),n2h1(91))
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(2),mass4set(:,4),  & 
G1H2(64),G1H2(76),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(76),8,2)
  call Hloop_AV_Q(ntryL,G2H2(73),ex4(:),G2H1(43),m3h2x1(:,186),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(43),31,nMT,G3tensor(9),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(34),m3h2x1(:,187),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nMT,G2tensor(134),n2h1(93))
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(2),mass4set(:,4),  & 
G1H2(29),G1H2(158),G1H2(159),G1H2(160),G1H2(161),2)
  call HG1shiftOLR(G1H2(158),8,2)
  call Hloop_QV_A(ntryL,G2H2(76),ex4(:),G2H1(19),m3h2x1(:,188),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(19),31,nMT,G3tensor(10),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(44),m3h2x1(:,189),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nMT,G2tensor(135),n2h1(95))
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(2),mass4set(:,5),  & 
G1H2(85),G1H2(162),G1H2(163),G1H2(164),G1H2(165),2)
  call HG1shiftOLR(G1H2(162),8,2)
  call Hloop_AV_Q(ntryL,G2H2(79),ex4(:),G2H1(21),m3h2x1(:,190),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(21),31,nMB,G3tensor(11),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(87),ex4(:),G1H1(34),m3h2x1(:,191),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(136),n2h1(97))
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(2),mass4set(:,5),  & 
G1H2(87),G1H2(166),G1H2(167),G1H2(168),G1H2(169),2)
  call HG1shiftOLR(G1H2(166),8,2)
  call Hloop_QV_A(ntryL,G2H2(82),ex4(:),G2H1(45),m3h2x1(:,192),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(45),31,nMB,G3tensor(12),n2h1(98))
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(44),m3h2x1(:,193),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(137),n2h1(99))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(85),ex4(:),G2tensor(138),m3h2x1(:,194),heltab2x2(:,:,268))
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(19),mass4set(:,3),  & 
G1H2(24),G1H2(170),G1H2(171),G1H2(172),G1H2(173),2)
  call HG1shiftOLR(G1H2(170),8,2)
  call Hloop_QV_A(ntryL,G2H2(106),ex4(:),G2H1(16),m3h2x1(:,195),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nML,G3tensor(13),n2h1(100))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(34),m3h2x1(:,196),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nML,G2tensor(139),n2h1(101))
  call Hotf_4pt_reduction(G2H2(107),RedSet_4(19),mass4set(:,3),  & 
G1H2(46),G1H2(174),G1H2(175),G1H2(176),G1H2(177),2)
  call HG1shiftOLR(G1H2(174),8,2)
  call Hloop_AV_Q(ntryL,G2H2(109),ex4(:),G2H1(18),m3h2x1(:,197),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nML,G3tensor(14),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(52),ex4(:),G1H1(44),m3h2x1(:,198),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nML,G2tensor(140),n2h1(103))
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(19),mass4set(:,4),  & 
G1H2(52),G1H2(178),G1H2(179),G1H2(180),G1H2(181),2)
  call HG1shiftOLR(G1H2(178),8,2)
  call Hloop_QV_A(ntryL,G2H2(112),ex4(:),G2H1(12),m3h2x1(:,199),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(15),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(125),ex4(:),G1H1(34),m3h2x1(:,200),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMT,G2tensor(141),n2h1(105))
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(19),mass4set(:,4),  & 
G1H2(125),G1H2(182),G1H2(183),G1H2(184),G1H2(185),2)
  call HG1shiftOLR(G1H2(182),8,2)
  call Hloop_AV_Q(ntryL,G2H2(115),ex4(:),G2H1(15),m3h2x1(:,201),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMT,G3tensor(16),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(127),ex4(:),G1H1(44),m3h2x1(:,202),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMT,G2tensor(142),n2h1(107))
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(19),mass4set(:,5),  & 
G1H2(127),G1H2(186),G1H2(187),G1H2(188),G1H2(189),2)
  call HG1shiftOLR(G1H2(186),8,2)
  call Hloop_QV_A(ntryL,G2H2(118),ex4(:),G2H1(1),m3h2x1(:,203),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(17),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(72),ex4(:),G1H1(34),m3h2x1(:,204),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(143),n2h1(109))
  call Hotf_4pt_reduction(G2H2(119),RedSet_4(19),mass4set(:,5),  & 
G1H2(72),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(190),8,2)
  call Hloop_AV_Q(ntryL,G2H2(121),ex4(:),G2H1(2),m3h2x1(:,205),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMB,G3tensor(18),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(134),ex4(:),G1H1(44),m3h2x1(:,206),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(144),n2h1(111))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(133),ex4(:),G2tensor(145),m3h2x1(:,207),heltab2x2(:,:,281))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(145),ex4(:),G2tensor(146),m3h2x1(:,208),heltab2x2(:,:,282))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(82),23,ex4(:),8,G2tensor(147),m3h2x1(:,209),heltab2x2(:,:,283))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(135),0,ex4(:),8,G2tensor(148),m3h2x1(:,210),heltab2x2(:,:,284))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(37),23,ex4(:),8,G2tensor(149),m3h2x1(:,211),heltab2x2(:,:,285))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(137),23,ex4(:),8,G2tensor(150),m3h2x1(:,212),heltab2x2(:,:,286))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(139),0,ex4(:),8,G2tensor(151),m3h2x1(:,213),heltab2x2(:,:,287))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(31),23,ex4(:),8,G2tensor(152),m3h2x1(:,214),heltab2x2(:,:,288))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(141),23,ex4(:),8,G2tensor(153),m3h2x1(:,215),heltab2x2(:,:,289))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(83),0,ex4(:),8,G2tensor(154),m3h2x1(:,216),heltab2x2(:,:,290))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(88),23,ex4(:),8,G2tensor(155),m3h2x1(:,217),heltab2x2(:,:,291))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(145),23,ex4(:),8,G2tensor(156),m3h2x1(:,218),heltab2x2(:,:,292))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(84),0,ex4(:),8,G2tensor(157),m3h2x1(:,219),heltab2x2(:,:,293))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(147),23,ex4(:),8,G2tensor(158),m3h2x1(:,220),heltab2x2(:,:,294))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(148),23,ex4(:),8,G2tensor(159),m3h2x1(:,221),heltab2x2(:,:,295))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(97),0,ex4(:),8,G2tensor(160),m3h2x1(:,222),heltab2x2(:,:,296))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(92),23,ex4(:),8,G2tensor(161),m3h2x1(:,223),heltab2x2(:,:,297))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(102),23,ex4(:),8,G2tensor(162),m3h2x1(:,224),heltab2x2(:,:,298))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(101),0,ex4(:),8,G2tensor(163),m3h2x1(:,225),heltab2x2(:,:,299))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(164),m3h2x1(:,226),heltab2x2(:,:,300))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(1),27,ex3(:),4,G2tensor(165),m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(5),0,ex3(:),4,G2tensor(166),m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(7),27,ex3(:),4,G2tensor(167),m3h1x1(:,75),heltab2x1(:,:,75))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(24),27,ex3(:),4,G2tensor(168),m3h1x1(:,76),heltab2x1(:,:,76))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(13),0,ex3(:),4,G2tensor(169),m3h1x1(:,77),heltab2x1(:,:,77))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(17),27,ex3(:),4,G2tensor(170),m3h1x1(:,78),heltab2x1(:,:,78))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(112),23,ex4(:),8,G2tensor(171),m3h2x1(:,227),heltab2x2(:,:,301))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(108),0,ex4(:),8,G2tensor(172),m3h2x1(:,228),heltab2x2(:,:,302))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(115),23,ex4(:),8,G2tensor(173),m3h2x1(:,229),heltab2x2(:,:,303))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(116),23,ex4(:),8,G2tensor(174),m3h2x1(:,230),heltab2x2(:,:,304))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(118),0,ex4(:),8,G2tensor(175),m3h2x1(:,231),heltab2x2(:,:,305))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(58),23,ex4(:),8,G2tensor(176),m3h2x1(:,232),heltab2x2(:,:,306))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(66),23,ex4(:),G2tensor(177),m3h2x1(:,233),heltab2x2(:,:,307))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(6),0,ex4(:),G2tensor(178),m3h2x1(:,234),heltab2x2(:,:,308))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(30),23,ex4(:),G2tensor(179),m3h2x1(:,235),heltab2x2(:,:,309))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(122),23,ex4(:),8,G2tensor(180),m3h2x1(:,236),heltab2x2(:,:,310))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(124),0,ex4(:),8,G2tensor(181),m3h2x1(:,237),heltab2x2(:,:,311))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(126),23,ex4(:),8,G2tensor(182),m3h2x1(:,238),heltab2x2(:,:,312))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(71),23,ex4(:),8,G2tensor(183),m3h2x1(:,239),heltab2x2(:,:,313))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(129),0,ex4(:),8,G2tensor(184),m3h2x1(:,240),heltab2x2(:,:,314))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(131),23,ex4(:),8,G2tensor(185),m3h2x1(:,241),heltab2x2(:,:,315))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(1),23,ex4(:),8,G2tensor(186),m3h2x1(:,242),heltab2x2(:,:,316))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(132),0,ex4(:),8,G2tensor(187),m3h2x1(:,243),heltab2x2(:,:,317))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(32),23,ex4(:),8,G2tensor(188),m3h2x1(:,244),heltab2x2(:,:,318))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(28),23,ex4(:),8,G2tensor(189),m3h2x1(:,245),heltab2x2(:,:,319))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(13),0,ex4(:),8,G2tensor(190),m3h2x1(:,246),heltab2x2(:,:,320))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(19),23,ex4(:),8,G2tensor(191),m3h2x1(:,247),heltab2x2(:,:,321))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(26),23,ex4(:),G2tensor(192),m3h2x1(:,248),heltab2x2(:,:,322))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(27),0,ex4(:),G2tensor(193),m3h2x1(:,249),heltab2x2(:,:,323))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(43),23,ex4(:),G2tensor(194),m3h2x1(:,250),heltab2x2(:,:,324))
  call Hloop_QV_A(ntryL,G1H2(44),ex4(:),G1H1(34),m3h2x1(:,251),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,0,G2tensor(195),n2h1(128))
  call Hloop_QV_A(ntryL,G1H2(49),ex4(:),G1H1(44),m3h2x1(:,252),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),8,0,G2tensor(196),n2h1(129))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(130))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(5),m3h2x1(:,254),heltab2x2(:,:,328))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,0,G2tensor(198),n2h1(131))
  call Hloop_QV_A(ntryL,G1H2(146),ex4(:),G1H1(7),m3h2x1(:,255),heltab2x2(:,:,329))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),8,0,G2tensor(199),n2h1(132))
  call Hloop_QV_A(ntryL,G1H2(149),ex4(:),G1H1(24),m3h2x1(:,256),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,0,G2tensor(200),n2h1(133))
  call Hloop_QV_A(ntryL,G1H2(94),ex4(:),G1H1(13),m3h2x1(:,257),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),31,0,G2tensor(201),n2h1(134))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(17),m3h2x1(:,258),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),8,0,G2tensor(202),n2h1(135))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(34),m3h2x1(:,259),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,0,G2tensor(203),n2h1(136))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(44),m3h2x1(:,260),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,0,G2tensor(204),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(205),n2h1(138))
  call Hloop_AV_Q(ntryL,G1H2(154),ex4(:),G1H1(5),m3h2x1(:,262),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,0,G2tensor(206),n2h1(139))
  call Hloop_AV_Q(ntryL,G1H2(15),ex4(:),G1H1(7),m3h2x1(:,263),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),31,0,G2tensor(207),n2h1(140))
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(24),m3h2x1(:,264),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),8,0,G2tensor(208),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(153),ex4(:),G1H1(13),m3h2x1(:,265),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,0,G2tensor(209),n2h1(142))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(17),m3h2x1(:,266),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,0,G2tensor(210),n2h1(143))
  call Hloop_AV_Q(ntryL,G1H2(106),ex4(:),G1H1(34),m3h2x1(:,267),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),8,0,G2tensor(211),n2h1(144))
  call Hloop_AV_Q(ntryL,G1H2(107),ex4(:),G1H1(44),m3h2x1(:,268),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,0,G2tensor(212),n2h1(145))
  call Hloop_WA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(213),n2h1(146))
  call Hloop_WA_Q(ntryL,G1H2(57),ex2(:),G1H1(5),m3h2x1(:,270),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),2,0,G2tensor(214),n2h1(147))
  call Hloop_WA_Q(ntryL,G1H2(63),ex2(:),G1H1(7),m3h2x1(:,271),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),31,0,G2tensor(215),n2h1(148))
  call Hloop_QS_A(ntryL,G1H1(30),ex3(:),G1H1(24),ngH,m3h1x1(:,79),heltab2x1(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nML,G2tensor(216),n2h1(149))
  call Hloop_QS_A(ntryL,G1H1(22),ex3(:),G1H1(13),ngH,m3h1x1(:,80),heltab2x1(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),4,nML,G2tensor(217),n2h1(150))
  call Hloop_QS_A(ntryL,G1H1(16),ex3(:),G1H1(17),ngH,m3h1x1(:,81),heltab2x1(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nML,G2tensor(218),n2h1(151))
  call Hloop_AS_Q(ntryL,G1H1(19),ex3(:),G1H1(34),ngH,m3h1x1(:,82),heltab2x1(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nML,G2tensor(219),n2h1(152))
  call Hloop_AS_Q(ntryL,G1H1(23),ex3(:),G1H1(44),ngH,m3h1x1(:,83),heltab2x1(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),4,nML,G2tensor(220),n2h1(153))
  call Hloop_AS_Q(ntryL,G1H1(35),ex3(:),G1H1(1),ngH,m3h1x1(:,84),heltab2x1(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(221),n2h1(154))
  call Hloop_QS_A(ntryL,G1H1(25),ex3(:),G1H1(5),ngH,m3h1x1(:,85),heltab2x1(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nMT,G2tensor(222),n2h1(155))
  call Hloop_QS_A(ntryL,G1H1(32),ex3(:),G1H1(7),ngH,m3h1x1(:,86),heltab2x1(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),4,nMT,G2tensor(223),n2h1(156))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(30),ngH,m3h1x1(:,87),heltab2x1(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),31,nMT,G2tensor(224),n2h1(157))
  call Hloop_AS_Q(ntryL,G1H1(4),ex3(:),G1H1(24),ngH,m3h1x1(:,88),heltab2x1(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nMT,G2tensor(225),n2h1(158))
  call Hloop_AS_Q(ntryL,G1H1(29),ex3(:),G1H1(22),ngH,m3h1x1(:,89),heltab2x1(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),4,nMT,G2tensor(226),n2h1(159))
  call Hloop_AS_Q(ntryL,G1H1(11),ex3(:),G1H1(13),ngH,m3h1x1(:,90),heltab2x1(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(227),n2h1(160))
  call Hloop_QS_A(ntryL,G1H1(9),ex3(:),G1H1(16),ngH,m3h1x1(:,91),heltab2x1(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),31,nMB,G2tensor(228),n2h1(161))
  call Hloop_QS_A(ntryL,G1H1(3),ex3(:),G1H1(17),ngH,m3h1x1(:,92),heltab2x1(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),4,nMB,G2tensor(229),n2h1(162))
  call Hloop_QS_A(ntryL,G1H1(39),ex3(:),G1H1(19),ngH,m3h1x1(:,93),heltab2x1(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(230),n2h1(163))
  call Hloop_AS_Q(ntryL,G1H1(38),ex3(:),G1H1(34),ngH,m3h1x1(:,94),heltab2x1(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(231),n2h1(164))
  call Hloop_AS_Q(ntryL,G1H1(40),ex3(:),G1H1(23),ngH,m3h1x1(:,95),heltab2x1(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),4,nMB,G2tensor(232),n2h1(165))
  call Hloop_AS_Q(ntryL,G1H1(43),ex3(:),G1H1(44),ngH,m3h1x1(:,96),heltab2x1(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(233),n2h1(166))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(35),m3h2x1(:,272),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),31,nML,G2tensor(234),n2h1(167))
  call Hloop_AV_Q(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nML,G2tensor(235),n2h1(168))
  call Hloop_AV_Q(ntryL,G1H2(74),ex4(:),G1H1(25),m3h2x1(:,274),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nML,G2tensor(236),n2h1(169))
  call Hloop_QV_A(ntryL,G1H2(81),ex4(:),G1H1(5),m3h2x1(:,275),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,nML,G2tensor(237),n2h1(170))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(32),m3h2x1(:,276),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),8,nML,G2tensor(238),n2h1(171))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(7),m3h2x1(:,277),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),31,nML,G2tensor(239),n2h1(172))
  call Hloop_AV_Q(ntryL,G1H2(64),ex4(:),G1H1(2),m3h2x1(:,278),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,nMT,G2tensor(240),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H2(76),ex4(:),G1H1(30),m3h2x1(:,279),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),8,nMT,G2tensor(241),n2h1(174))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(4),m3h2x1(:,280),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,nMT,G2tensor(242),n2h1(175))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(24),m3h2x1(:,281),heltab2x2(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nMT,G2tensor(243),n2h1(176))
  call Hloop_QV_A(ntryL,G1H2(158),ex4(:),G1H1(29),m3h2x1(:,282),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),8,nMT,G2tensor(244),n2h1(177))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(22),m3h2x1(:,283),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMT,G2tensor(245),n2h1(178))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(11),m3h2x1(:,284),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),31,nMB,G2tensor(246),n2h1(179))
  call Hloop_AV_Q(ntryL,G1H2(162),ex4(:),G1H1(13),m3h2x1(:,285),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),8,nMB,G2tensor(247),n2h1(180))
  call Hloop_AV_Q(ntryL,G1H2(165),ex4(:),G1H1(9),m3h2x1(:,286),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(248),n2h1(181))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(16),m3h2x1(:,287),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),31,nMB,G2tensor(249),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(166),ex4(:),G1H1(3),m3h2x1(:,288),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),8,nMB,G2tensor(250),n2h1(183))
  call Hloop_QV_A(ntryL,G1H2(169),ex4(:),G1H1(17),m3h2x1(:,289),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(251),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(24),ex4(:),G1H1(39),m3h2x1(:,290),heltab2x2(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,nML,G2tensor(252),n2h1(185))
  call Hloop_QV_A(ntryL,G1H2(170),ex4(:),G1H1(19),m3h2x1(:,291),heltab2x2(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nML,G2tensor(253),n2h1(186))
  call Hloop_QV_A(ntryL,G1H2(173),ex4(:),G1H1(38),m3h2x1(:,292),heltab2x2(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),31,nML,G2tensor(254),n2h1(187))
  call Hloop_AV_Q(ntryL,G1H2(46),ex4(:),G1H1(34),m3h2x1(:,293),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nML,G2tensor(255),n2h1(188))
  call Hloop_AV_Q(ntryL,G1H2(174),ex4(:),G1H1(40),m3h2x1(:,294),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(40),8,nML,G2tensor(256),n2h1(189))
  call Hloop_AV_Q(ntryL,G1H2(177),ex4(:),G1H1(23),m3h2x1(:,295),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nML,G2tensor(257),n2h1(190))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(43),m3h2x1(:,296),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),31,nMT,G2tensor(258),n2h1(191))
  call Hloop_QV_A(ntryL,G1H2(178),ex4(:),G1H1(44),m3h2x1(:,297),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),8,nMT,G2tensor(259),n2h1(192))
  call Hloop_QV_A(ntryL,G1H2(181),ex4(:),G1H1(35),m3h2x1(:,298),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),31,nMT,G2tensor(260),n2h1(193))
  call Hloop_AV_Q(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(261),n2h1(194))
  call Hloop_AV_Q(ntryL,G1H2(182),ex4(:),G1H1(25),m3h2x1(:,300),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),8,nMT,G2tensor(262),n2h1(195))
  call Hloop_AV_Q(ntryL,G1H2(185),ex4(:),G1H1(5),m3h2x1(:,301),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,nMT,G2tensor(263),n2h1(196))
  call Hloop_QV_A(ntryL,G1H2(127),ex4(:),G1H1(32),m3h2x1(:,302),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(264),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(186),ex4(:),G1H1(7),m3h2x1(:,303),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),8,nMB,G2tensor(265),n2h1(198))
  call Hloop_QV_A(ntryL,G1H2(189),ex4(:),G1H1(2),m3h2x1(:,304),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(266),n2h1(199))
  call Hloop_AV_Q(ntryL,G1H2(72),ex4(:),G1H1(30),m3h2x1(:,305),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nMB,G2tensor(267),n2h1(200))
  call Hloop_AV_Q(ntryL,G1H2(190),ex4(:),G1H1(4),m3h2x1(:,306),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),8,nMB,G2tensor(268),n2h1(201))
  call Hloop_AV_Q(ntryL,G1H2(193),ex4(:),G1H1(24),m3h2x1(:,307),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(269),n2h1(202))
  call ol_merge_tensors(G2tensor(116),[G2tensor(19),G2tensor(2),G1tensor(30)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(28),G2tensor(4),G1tensor(36)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(6),G1tensor(42)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(8),G1tensor(48)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(31),G2tensor(25),G2tensor(22),G2tensor(12),G2tensor(10),G1tensor(19),G1tensor(12) &
    ,G1tensor(6)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(43),G2tensor(40),G2tensor(37),G2tensor(16),G2tensor(14),G1tensor(13),G1tensor(24) &
    ,G1tensor(18)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(18),G1tensor(26)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(24),G2tensor(21),G1tensor(1),G1tensor(2)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(27),G1tensor(32)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(103),G2tensor(33),G2tensor(30),G1tensor(33),G1tensor(8)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(39),G2tensor(36),G1tensor(7),G1tensor(14)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(102),G2tensor(45),G2tensor(42),G1tensor(27),G1tensor(20)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(49),G1tensor(54)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(52),G1tensor(60)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(54),G1tensor(38)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(58),G1tensor(66)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(64),G2tensor(61),G1tensor(78),G1tensor(72)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(5),G2tensor(1),G2tensor(63),G1tensor(74),G1tensor(3)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(66),G1tensor(44)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(44),G2tensor(32),G2tensor(69),G1tensor(80),G1tensor(9)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(177),G2tensor(174),G2tensor(171),G2tensor(159),G2tensor(156),G2tensor(109) &
    ,G2tensor(108),G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(3),G2tensor(35),G1tensor(5)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(165),G2tensor(130),G2tensor(128),G2tensor(107),G2tensor(106),G1tensor(22) &
    ,G1tensor(10)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(38),G2tensor(9),G1tensor(41),G1tensor(11)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(65),G2tensor(26),G1tensor(15)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(53),G2tensor(41),G1tensor(17)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(59),G2tensor(50),G1tensor(21)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(56),G2tensor(29),G1tensor(47),G1tensor(23)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(15),G1tensor(28)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(189),G2tensor(186),G2tensor(183),G2tensor(162),G2tensor(153),G2tensor(110) &
    ,G2tensor(20),G1tensor(35),G1tensor(29)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(23),G1tensor(34)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(76),G1tensor(39)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(77),G1tensor(40)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(87),G1tensor(45)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(88),G1tensor(46)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(83),G1tensor(77)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(121)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(123)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(125)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(132)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(134)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(136)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(139)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(141)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(143)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(216)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(222)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(228)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(234)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(240)])
  call ol_merge_tensors(G2tensor(249),[G2tensor(246)])
  call ol_merge_tensors(G2tensor(255),[G2tensor(252)])
  call ol_merge_tensors(G2tensor(261),[G2tensor(258)])
  call ol_merge_tensors(G2tensor(267),[G2tensor(264)])
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(20),mass4set(:,11),  & 
G1tensor(25),G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49))
  call G_TensorShift(G1tensor(31),10)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(24),mass4set(:,11),  & 
G1tensor(55),G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79))
  call G_TensorShift(G1tensor(61),9)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(28),mass4set(:,1),  & 
G1tensor(30),G1tensor(36),G1tensor(42),G1tensor(48),G1tensor(19))
  call G_TensorShift(G1tensor(36),5)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(32),mass4set(:,1),  & 
G1tensor(12),G1tensor(6),G1tensor(13),G1tensor(24),G1tensor(18))
  call G_TensorShift(G1tensor(6),6)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(4),mass4set(:,6),  & 
G1tensor(26),G1tensor(1),G1tensor(2),G1tensor(32),G1tensor(33))
  call G_TensorShift(G1tensor(1),12)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(12),mass4set(:,6),  & 
G1tensor(8),G1tensor(7),G1tensor(14),G1tensor(27),G1tensor(20))
  call G_TensorShift(G1tensor(7),12)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(48),mass4set(:,11),  & 
G1tensor(50),G1tensor(54),G1tensor(56),G1tensor(60),G1tensor(38))
  call G_TensorShift(G1tensor(54),2)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(49),mass4set(:,6),  & 
G1tensor(62),G1tensor(66),G1tensor(68),G1tensor(78),G1tensor(72))
  call G_TensorShift(G1tensor(66),4)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(50),mass4set(:,11),  & 
G1tensor(74),G1tensor(3),G1tensor(44),G1tensor(80),G1tensor(9))
  call G_TensorShift(G1tensor(3),1)
  call Hotf_4pt_reduction_last(G2tensor(147),RedSet_4(22),mass4set(:,6),  & 
G1tensor(84),G1tensor(16),G1tensor(4),G1tensor(5),G1tensor(22))
  call G_TensorShift(G1tensor(16),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(51),mass4set(:,6),  & 
G1tensor(10),G1tensor(41),G1tensor(11),G1tensor(15),G1tensor(17))
  call G_TensorShift(G1tensor(41),4)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(17),mass4set(:,6),  & 
G1tensor(21),G1tensor(47),G1tensor(23),G1tensor(28),G1tensor(35))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(52),mass4set(:,12),  & 
G1tensor(29),G1tensor(34),G1tensor(39),G1tensor(40),G1tensor(45))
  call G_TensorShift(G1tensor(34),1)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(35),mass4set(:,12),  & 
G1tensor(46),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(57))
  call G_TensorShift(G1tensor(51),9)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(52),mass4set(:,10),  & 
G1tensor(58),G1tensor(59),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(59),1)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(35),mass4set(:,10),  & 
G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(75),G1tensor(76))
  call G_TensorShift(G1tensor(70),9)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(53),mass4set(:,1),  & 
G1tensor(83),G1tensor(77),G1tensor(81),G1tensor(82),G1tensor(85))
  call G_TensorShift(G1tensor(77),1)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(54),mass4set(:,12),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),2)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(38),mass4set(:,12),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),10)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(54),mass4set(:,10),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(38),mass4set(:,10),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),10)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(1),mass4set(:,13),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(47),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),2)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(6),mass4set(:,13),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(32),mass4set(:,10),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),6)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(2),mass4set(:,2),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(3),mass4set(:,6),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_4pt_reduction_last(G2tensor(168),RedSet_4(7),mass4set(:,2),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),4)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(8),mass4set(:,6),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),4)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(10),mass4set(:,13),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(11),mass4set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(14),mass4set(:,13),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),4)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(15),mass4set(:,6),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),4)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(18),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),8)
  call Hotf_4pt_reduction_last(G2tensor(192),RedSet_4(19),mass4set(:,2),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),8)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(23),mass4set(:,6),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),8)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(26),mass4set(:,14),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(27),mass4set(:,6),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(30),mass4set(:,14),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(31),mass4set(:,6),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),4)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(34),mass4set(:,15),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(23),mass4set(:,8),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),8)
  call Hotf_4pt_reduction_last(G2tensor(72),RedSet_4(3),mass4set(:,8),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(34),mass4set(:,16),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(23),mass4set(:,9),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),8)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(3),mass4set(:,9),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),8)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(37),mass4set(:,15),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),8)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(18),mass4set(:,8),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),8)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(11),mass4set(:,8),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(37),mass4set(:,16),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),8)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(18),mass4set(:,9),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),8)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(11),mass4set(:,9),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),8)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(40),mass4set(:,17),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),2)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(41),mass4set(:,10),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),2)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(42),mass4set(:,10),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),2)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(44),mass4set(:,17),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),2)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(45),mass4set(:,10),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),2)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(7),mass4set(:,3),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290),G0tensor(1))
  call G_TensorShift(G1tensor(287),4)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(7),mass4set(:,4),  & 
G1tensor(286),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G0tensor(2))
  call G_TensorShift(G1tensor(291),4)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(7),mass4set(:,5),  & 
G1tensor(286),G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G0tensor(3))
  call G_TensorShift(G1tensor(295),4)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(2),mass4set(:,3),  & 
G1tensor(286),G1tensor(299),G1tensor(300),G1tensor(301),G1tensor(302),G0tensor(4))
  call G_TensorShift(G1tensor(299),8)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(2),mass4set(:,4),  & 
G1tensor(286),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306),G0tensor(5))
  call G_TensorShift(G1tensor(303),8)
  call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(2),mass4set(:,5),  & 
G1tensor(286),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G0tensor(6))
  call G_TensorShift(G1tensor(307),8)
  call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(19),mass4set(:,3),  & 
G1tensor(286),G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G0tensor(7))
  call G_TensorShift(G1tensor(311),8)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(19),mass4set(:,4),  & 
G1tensor(286),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318),G0tensor(8))
  call G_TensorShift(G1tensor(315),8)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(19),mass4set(:,5),  & 
G1tensor(286),G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G0tensor(9))
  call G_TensorShift(G1tensor(319),8)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(22),mass4set(:,7),  & 
G1tensor(286),G1tensor(323),G1tensor(324),G1tensor(325),G1tensor(326))
  call G_TensorShift(G1tensor(323),8)
  call Hotf_4pt_reduction_last(G2tensor(198),RedSet_4(22),mass4set(:,8),  & 
G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330),G1tensor(331))
  call G_TensorShift(G1tensor(328),8)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(22),mass4set(:,9),  & 
G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(333),8)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(17),mass4set(:,7),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341))
  call G_TensorShift(G1tensor(338),8)
  call Hotf_4pt_reduction_last(G2tensor(207),RedSet_4(17),mass4set(:,8),  & 
G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346))
  call G_TensorShift(G1tensor(343),8)
  call Hotf_4pt_reduction_last(G2tensor(210),RedSet_4(17),mass4set(:,9),  & 
G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350),G1tensor(351))
  call G_TensorShift(G1tensor(348),8)
  call Hotf_4pt_reduction_last(G2tensor(213),RedSet_4(47),mass4set(:,10),  & 
G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355),G1tensor(356))
  call G_TensorShift(G1tensor(353),2)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(7),mass4set(:,3),  & 
G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360),G1tensor(361))
  call G_TensorShift(G1tensor(358),4)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(7),mass4set(:,4),  & 
G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(363),4)
  call Hotf_4pt_reduction_last(G2tensor(231),RedSet_4(7),mass4set(:,5),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371))
  call G_TensorShift(G1tensor(368),4)
  call Hotf_4pt_reduction_last(G2tensor(237),RedSet_4(2),mass4set(:,3),  & 
G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376))
  call G_TensorShift(G1tensor(373),8)
  call Hotf_4pt_reduction_last(G2tensor(243),RedSet_4(2),mass4set(:,4),  & 
G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380),G1tensor(381))
  call G_TensorShift(G1tensor(378),8)
  call Hotf_4pt_reduction_last(G2tensor(249),RedSet_4(2),mass4set(:,5),  & 
G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385),G1tensor(386))
  call G_TensorShift(G1tensor(383),8)
  call Hotf_4pt_reduction_last(G2tensor(255),RedSet_4(19),mass4set(:,3),  & 
G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391))
  call G_TensorShift(G1tensor(388),8)
  call Hotf_4pt_reduction_last(G2tensor(261),RedSet_4(19),mass4set(:,4),  & 
G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(393),8)
  call Hotf_4pt_reduction_last(G2tensor(267),RedSet_4(19),mass4set(:,5),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401))
  call G_TensorShift(G1tensor(398),8)
  call Hotf_4pt_reduction_last(G1tensor(25),RedSet_4(20),mass4set(:,11),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(24),mass4set(:,11),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(28),mass4set(:,1),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(32),mass4set(:,1),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(4),mass4set(:,6),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(12),mass4set(:,6),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(48),mass4set(:,11),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(49),mass4set(:,6),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(50),mass4set(:,11),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(22),mass4set(:,6),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(51),mass4set(:,6),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(17),mass4set(:,6),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(52),mass4set(:,12),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(35),mass4set(:,12),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(52),mass4set(:,10),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(35),mass4set(:,10),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(53),mass4set(:,1),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(54),mass4set(:,12),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(38),mass4set(:,12),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(54),mass4set(:,10),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(38),mass4set(:,10),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(1),mass4set(:,13),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(47),mass4set(:,1),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(6),mass4set(:,13),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(32),mass4set(:,10),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(2),mass4set(:,2),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(3),mass4set(:,6),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(7),mass4set(:,2),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(8),mass4set(:,6),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(10),mass4set(:,13),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(11),mass4set(:,6),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(14),mass4set(:,13),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(15),mass4set(:,6),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(18),mass4set(:,6),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(19),mass4set(:,2),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(23),mass4set(:,6),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(26),mass4set(:,14),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(27),mass4set(:,6),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(30),mass4set(:,14),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(31),mass4set(:,6),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(34),mass4set(:,15),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(23),mass4set(:,8),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(3),mass4set(:,8),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(34),mass4set(:,16),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(23),mass4set(:,9),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(3),mass4set(:,9),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(37),mass4set(:,15),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(18),mass4set(:,8),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(11),mass4set(:,8),  & 
G0tensor(250),G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(37),mass4set(:,16),  & 
G0tensor(255),G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(18),mass4set(:,9),  & 
G0tensor(260),G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(11),mass4set(:,9),  & 
G0tensor(265),G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(40),mass4set(:,17),  & 
G0tensor(270),G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(41),mass4set(:,10),  & 
G0tensor(275),G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(42),mass4set(:,10),  & 
G0tensor(280),G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(44),mass4set(:,17),  & 
G0tensor(285),G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(45),mass4set(:,10),  & 
G0tensor(290),G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(22),mass4set(:,7),  & 
G0tensor(295),G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299))
  call Hotf_4pt_reduction_last(G1tensor(327),RedSet_4(22),mass4set(:,8),  & 
G0tensor(300),G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304))
  call Hotf_4pt_reduction_last(G1tensor(332),RedSet_4(22),mass4set(:,9),  & 
G0tensor(305),G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309))
  call Hotf_4pt_reduction_last(G1tensor(337),RedSet_4(17),mass4set(:,7),  & 
G0tensor(310),G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314))
  call Hotf_4pt_reduction_last(G1tensor(342),RedSet_4(17),mass4set(:,8),  & 
G0tensor(315),G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319))
  call Hotf_4pt_reduction_last(G1tensor(347),RedSet_4(17),mass4set(:,9),  & 
G0tensor(320),G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324))
  call Hotf_4pt_reduction_last(G1tensor(352),RedSet_4(47),mass4set(:,10),  & 
G0tensor(325),G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329))
  call Hotf_4pt_reduction_last(G1tensor(357),RedSet_4(7),mass4set(:,3),  & 
G0tensor(330),G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334))
  call Hotf_4pt_reduction_last(G1tensor(362),RedSet_4(7),mass4set(:,4),  & 
G0tensor(335),G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339))
  call Hotf_4pt_reduction_last(G1tensor(367),RedSet_4(7),mass4set(:,5),  & 
G0tensor(340),G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344))
  call Hotf_4pt_reduction_last(G1tensor(372),RedSet_4(2),mass4set(:,3),  & 
G0tensor(345),G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349))
  call Hotf_4pt_reduction_last(G1tensor(377),RedSet_4(2),mass4set(:,4),  & 
G0tensor(350),G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354))
  call Hotf_4pt_reduction_last(G1tensor(382),RedSet_4(2),mass4set(:,5),  & 
G0tensor(355),G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359))
  call Hotf_4pt_reduction_last(G1tensor(387),RedSet_4(19),mass4set(:,3),  & 
G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364))
  call Hotf_4pt_reduction_last(G1tensor(392),RedSet_4(19),mass4set(:,4),  & 
G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369))
  call Hotf_4pt_reduction_last(G1tensor(397),RedSet_4(19),mass4set(:,5),  & 
G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])
  call ol_merge_tensors(T0sum(45),[G0tensor(230)])
  call ol_merge_tensors(T0sum(46),[G0tensor(235)])
  call ol_merge_tensors(T0sum(47),[G0tensor(240)])
  call ol_merge_tensors(T0sum(48),[G0tensor(245)])
  call ol_merge_tensors(T0sum(49),[G0tensor(250)])
  call ol_merge_tensors(T0sum(50),[G0tensor(255)])
  call ol_merge_tensors(T0sum(51),[G0tensor(260)])
  call ol_merge_tensors(T0sum(52),[G0tensor(265)])
  call ol_merge_tensors(T0sum(53),[G0tensor(270)])
  call ol_merge_tensors(T0sum(54),[G0tensor(275)])
  call ol_merge_tensors(T0sum(55),[G0tensor(280)])
  call ol_merge_tensors(T0sum(56),[G0tensor(285)])
  call ol_merge_tensors(T0sum(57),[G0tensor(290)])
  call ol_merge_tensors(T0sum(58),[G0tensor(1)])
  call ol_merge_tensors(T0sum(59),[G0tensor(2)])
  call ol_merge_tensors(T0sum(60),[G0tensor(3)])
  call ol_merge_tensors(T0sum(61),[G0tensor(4)])
  call ol_merge_tensors(T0sum(62),[G0tensor(5)])
  call ol_merge_tensors(T0sum(63),[G0tensor(6)])
  call ol_merge_tensors(T0sum(64),[G0tensor(7)])
  call ol_merge_tensors(T0sum(65),[G0tensor(8)])
  call ol_merge_tensors(T0sum(66),[G0tensor(9)])
  call ol_merge_tensors(T0sum(67),[G0tensor(295)])
  call ol_merge_tensors(T0sum(68),[G0tensor(300)])
  call ol_merge_tensors(T0sum(69),[G0tensor(305)])
  call ol_merge_tensors(T0sum(70),[G0tensor(310)])
  call ol_merge_tensors(T0sum(71),[G0tensor(315)])
  call ol_merge_tensors(T0sum(72),[G0tensor(320)])
  call ol_merge_tensors(T0sum(73),[G0tensor(325)])
  call ol_merge_tensors(T0sum(74),[G0tensor(330)])
  call ol_merge_tensors(T0sum(75),[G0tensor(335)])
  call ol_merge_tensors(T0sum(76),[G0tensor(340)])
  call ol_merge_tensors(T0sum(77),[G0tensor(345)])
  call ol_merge_tensors(T0sum(78),[G0tensor(350)])
  call ol_merge_tensors(T0sum(79),[G0tensor(355)])
  call ol_merge_tensors(T0sum(80),[G0tensor(360)])
  call ol_merge_tensors(T0sum(81),[G0tensor(365)])
  call ol_merge_tensors(T0sum(82),[G0tensor(370)])
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(335),h0tab(:,335),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(3),m4h3x4x2(:,1),heltab3x24(:,:,5))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(336),h0tab(:,336),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(16),m4h3x4x2(:,2),heltab3x24(:,:,6))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(337),h0tab(:,337),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(1),m4h3x4x2(:,3),heltab3x24(:,:,7))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(338),h0tab(:,338),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(14),m4h3x4x2(:,4),heltab3x24(:,:,8))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(339),h0tab(:,339),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(4),m4h3x4x2(:,5),heltab3x24(:,:,9))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(340),h0tab(:,340),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(23),m4h3x4x2(:,6),heltab3x24(:,:,10))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(341),h0tab(:,341),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(2),m4h3x4x2(:,7),heltab3x24(:,:,11))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(342),h0tab(:,342),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(21),m4h3x4x2(:,8),heltab3x24(:,:,12))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(343),h0tab(:,343),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(8),m4h3x4x2(:,9),heltab3x24(:,:,13))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(344),h0tab(:,344),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(24),m4h3x4x2(:,10),heltab3x24(:,:,14))
  Gcoeff(:)%j = (c(118)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(345),h0tab(:,345),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(7),m4h3x4x2(:,11),heltab3x24(:,:,15))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(346),h0tab(:,346),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(22),m4h3x4x2(:,12),heltab3x24(:,:,16))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(347),h0tab(:,347),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(20),m4h3x4x2(:,13),heltab3x24(:,:,17))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(348),h0tab(:,348),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,17),G0H2(19),m4h3x4x2(:,14),heltab3x24(:,:,18))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(349),h0tab(:,349),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(6),m4h3x4x2(:,15),heltab3x24(:,:,19))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(350),h0tab(:,350),[19,4,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,18),G0H2(5),m4h3x4x2(:,16),heltab3x24(:,:,20))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(351),h0tab(:,351),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(121),m3h3x8(:,319),heltab2x24(:,:,331))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(352),h0tab(:,352),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(122),m3h3x8(:,320),heltab2x24(:,:,332))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(353),h0tab(:,353),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(125),m3h3x8(:,321),heltab2x24(:,:,333))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(354),h0tab(:,354),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(126),m3h3x8(:,322),heltab2x24(:,:,334))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(355),h0tab(:,355),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(129),m3h3x8(:,323),heltab2x24(:,:,335))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(356),h0tab(:,356),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(130),m3h3x8(:,324),heltab2x24(:,:,336))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(357),h0tab(:,357),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(131),m3h3x8(:,325),heltab2x24(:,:,337))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(358),h0tab(:,358),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(132),m3h3x8(:,326),heltab2x24(:,:,338))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(359),h0tab(:,359),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(1),m3h3x8(:,327),heltab2x24(:,:,339))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(360),h0tab(:,360),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(6),m3h3x8(:,328),heltab2x24(:,:,340))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(361),h0tab(:,361),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(16),m3h3x8(:,329),heltab2x24(:,:,341))
  Gcoeff(:)%j = (-(c(120)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(362),h0tab(:,362),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(18),m3h3x8(:,330),heltab2x24(:,:,342))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(363),h0tab(:,363),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(20),m3h3x8(:,331),heltab2x24(:,:,343))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(364),h0tab(:,364),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(22),m3h3x8(:,332),heltab2x24(:,:,344))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(365),h0tab(:,365),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(24),m3h3x8(:,333),heltab2x24(:,:,345))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(366),h0tab(:,366),[16,4,11],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(25),m3h3x8(:,334),heltab2x24(:,:,346))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(367),h0tab(:,367),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(4),m4h3x2x4(:,3),heltab3x24(:,:,21))
  Gcoeff(:)%j = (c(94)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(368),h0tab(:,368),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(5),m4h3x2x4(:,4),heltab3x24(:,:,22))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(369),h0tab(:,369),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(6),m4h3x2x4(:,5),heltab3x24(:,:,23))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(370),h0tab(:,370),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(1),m4h3x2x4(:,6),heltab3x24(:,:,24))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(371),h0tab(:,371),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(2),m4h3x2x4(:,7),heltab3x24(:,:,25))
  Gcoeff(:)%j = (c(58)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(372),h0tab(:,372),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(7),m4h3x2x4(:,8),heltab3x24(:,:,26))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(373),h0tab(:,373),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(3),m4h3x2x4(:,9),heltab3x24(:,:,27))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(374),h0tab(:,374),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(8),m4h3x2x4(:,10),heltab3x24(:,:,28))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(375),h0tab(:,375),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(9),m4h3x2x4(:,11),heltab3x24(:,:,29))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(376),h0tab(:,376),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(10),m4h3x2x4(:,12),heltab3x24(:,:,30))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(377),h0tab(:,377),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(11),m4h3x2x4(:,13),heltab3x24(:,:,31))
  Gcoeff(:)%j = (-(c(120)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(378),h0tab(:,378),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(12),m4h3x2x4(:,14),heltab3x24(:,:,32))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(379),h0tab(:,379),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(13),m4h3x2x4(:,15),heltab3x24(:,:,33))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(380),h0tab(:,380),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(14),m4h3x2x4(:,16),heltab3x24(:,:,34))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(381),h0tab(:,381),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(15),m4h3x2x4(:,17),heltab3x24(:,:,35))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(382),h0tab(:,382),[24,3,4],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(16),m4h3x2x4(:,18),heltab3x24(:,:,36))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(383),h0tab(:,383),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(26),m3h3x8(:,335),heltab2x24(:,:,347))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(384),h0tab(:,384),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(27),m3h3x8(:,336),heltab2x24(:,:,348))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(385),h0tab(:,385),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(28),m3h3x8(:,337),heltab2x24(:,:,349))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(386),h0tab(:,386),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(29),m3h3x8(:,338),heltab2x24(:,:,350))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(387),h0tab(:,387),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(133),m3h3x8(:,339),heltab2x24(:,:,351))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(388),h0tab(:,388),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(134),m3h3x8(:,340),heltab2x24(:,:,352))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(389),h0tab(:,389),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(136),m3h3x8(:,341),heltab2x24(:,:,353))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(390),h0tab(:,390),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(138),m3h3x8(:,342),heltab2x24(:,:,354))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(391),h0tab(:,391),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(139),m3h3x8(:,343),heltab2x24(:,:,355))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(392),h0tab(:,392),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(140),m3h3x8(:,344),heltab2x24(:,:,356))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(393),h0tab(:,393),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(141),m3h3x8(:,345),heltab2x24(:,:,357))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(394),h0tab(:,394),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(142),m3h3x8(:,346),heltab2x24(:,:,358))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(395),h0tab(:,395),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(30),m3h3x8(:,347),heltab2x24(:,:,359))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(396),h0tab(:,396),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(31),m3h3x8(:,348),heltab2x24(:,:,360))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(397),h0tab(:,397),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(32),m3h3x8(:,349),heltab2x24(:,:,361))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(398),h0tab(:,398),[16,7,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(33),m3h3x8(:,350),heltab2x24(:,:,362))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(399),h0tab(:,399),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(34),m4h1x3x8(:,3),heltab3x24(:,:,37))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(400),h0tab(:,400),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(35),m4h1x3x8(:,4),heltab3x24(:,:,38))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(401),h0tab(:,401),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(36),m4h1x3x8(:,5),heltab3x24(:,:,39))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(402),h0tab(:,402),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(37),m4h1x3x8(:,6),heltab3x24(:,:,40))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(403),h0tab(:,403),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(38),m4h3x1x8(:,1),heltab3x24(:,:,41))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(404),h0tab(:,404),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(39),m4h3x1x8(:,2),heltab3x24(:,:,42))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(405),h0tab(:,405),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(40),m4h3x1x8(:,3),heltab3x24(:,:,43))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(406),h0tab(:,406),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(41),m4h3x1x8(:,4),heltab3x24(:,:,44))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(407),h0tab(:,407),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(42),m4h1x3x8(:,7),heltab3x24(:,:,45))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(408),h0tab(:,408),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(43),m4h1x3x8(:,8),heltab3x24(:,:,46))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(409),h0tab(:,409),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(44),m4h1x3x8(:,9),heltab3x24(:,:,47))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(410),h0tab(:,410),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(45),m4h1x3x8(:,10),heltab3x24(:,:,48))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(411),h0tab(:,411),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(46),m4h3x1x8(:,5),heltab3x24(:,:,49))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(412),h0tab(:,412),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(47),m4h3x1x8(:,6),heltab3x24(:,:,50))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(413),h0tab(:,413),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(48),m4h3x1x8(:,7),heltab3x24(:,:,51))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(414),h0tab(:,414),[20,3,8],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(50),m4h3x1x8(:,8),heltab3x24(:,:,52))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(415),h0tab(:,415),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(143),m3h3x8(:,351),heltab2x24(:,:,363))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(416),h0tab(:,416),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(144),m3h3x8(:,352),heltab2x24(:,:,364))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(417),h0tab(:,417),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(145),m3h3x8(:,353),heltab2x24(:,:,365))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(418),h0tab(:,418),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(146),m3h3x8(:,354),heltab2x24(:,:,366))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(419),h0tab(:,419),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(52),m3h3x8(:,355),heltab2x24(:,:,367))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(420),h0tab(:,420),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(54),m3h3x8(:,356),heltab2x24(:,:,368))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(421),h0tab(:,421),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(56),m3h3x8(:,357),heltab2x24(:,:,369))
  Gcoeff(:)%j = (c(119)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(422),h0tab(:,422),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(57),m3h3x8(:,358),heltab2x24(:,:,370))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(423),h0tab(:,423),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(58),m3h3x8(:,359),heltab2x24(:,:,371))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(424),h0tab(:,424),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(59),m3h3x8(:,360),heltab2x24(:,:,372))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(425),h0tab(:,425),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(60),m3h3x8(:,361),heltab2x24(:,:,373))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(426),h0tab(:,426),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(61),m3h3x8(:,362),heltab2x24(:,:,374))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(427),h0tab(:,427),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(147),m3h3x8(:,363),heltab2x24(:,:,375))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(428),h0tab(:,428),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(148),m3h3x8(:,364),heltab2x24(:,:,376))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(429),h0tab(:,429),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(149),m3h3x8(:,365),heltab2x24(:,:,377))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(430),h0tab(:,430),[16,3,12],[nMW,nMW,nMW],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(150),m3h3x8(:,366),heltab2x24(:,:,378))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(431),h0tab(:,431),[28,1,2],[nMW,0,nMW],4,1,wf3(:,1))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf3(:,1),G0H4(17),m4h2x3x4(:,1),heltab3x24(:,:,53))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(432),h0tab(:,432),[20,3,8],[nML,nML,nML],3,2,wf3(:,3),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(62),ngX,m3h3x8(:,367),heltab2x24(:,:,379))
  call Hloop_Q_A(ntryL,G0H8(62),20,nML,G1H8(151),n2h8(92))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(433),h0tab(:,433),[20,3,8],[nML,nML,nML],3,2,wf3(:,3),wf4(:,17))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,3),G0H8(63),ngX,m3h3x8(:,368),heltab2x24(:,:,380))
  call Hloop_A_Q(ntryL,G0H8(63),20,nML,G1H8(152),n2h8(93))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(434),h0tab(:,434),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,3),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(64),ngX,m3h3x8(:,369),heltab2x24(:,:,381))
  call Hloop_Q_A(ntryL,G0H8(64),20,nMT,G1H8(153),n2h8(94))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(435),h0tab(:,435),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,3),wf4(:,17))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,3),G0H8(65),ngX,m3h3x8(:,370),heltab2x24(:,:,382))
  call Hloop_A_Q(ntryL,G0H8(65),20,nMT,G1H8(154),n2h8(95))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(436),h0tab(:,436),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,3),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(66),ngX,m3h3x8(:,371),heltab2x24(:,:,383))
  call Hloop_Q_A(ntryL,G0H8(66),20,nMB,G1H8(156),n2h8(96))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(437),h0tab(:,437),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,3),wf4(:,17))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,3),G0H8(67),ngX,m3h3x8(:,372),heltab2x24(:,:,384))
  call Hloop_A_Q(ntryL,G0H8(67),20,nMB,G1H8(158),n2h8(97))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(438),h0tab(:,438),[20,3,8],[nML,nML,nML],3,2,wf3(:,3),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(68),ngX,m3h3x8(:,373),heltab2x24(:,:,385))
  call Hloop_Q_A(ntryL,G0H8(68),20,nML,G1H8(159),n2h8(98))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(439),h0tab(:,439),[20,3,8],[nML,nML,nML],3,2,wf3(:,3),wf4(:,18))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,3),G0H8(69),ngX,m3h3x8(:,374),heltab2x24(:,:,386))
  call Hloop_A_Q(ntryL,G0H8(69),20,nML,G1H8(160),n2h8(99))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(440),h0tab(:,440),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,3),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(70),ngX,m3h3x8(:,375),heltab2x24(:,:,387))
  call Hloop_Q_A(ntryL,G0H8(70),20,nMT,G1H8(161),n2h8(100))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(441),h0tab(:,441),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,3),wf4(:,18))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,3),G0H8(71),ngX,m3h3x8(:,376),heltab2x24(:,:,388))
  call Hloop_A_Q(ntryL,G0H8(71),20,nMT,G1H8(162),n2h8(101))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(442),h0tab(:,442),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,3),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(72),ngX,m3h3x8(:,377),heltab2x24(:,:,389))
  call Hloop_Q_A(ntryL,G0H8(72),20,nMB,G1H8(163),n2h8(102))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(443),h0tab(:,443),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,3),wf4(:,18))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,3),G0H8(73),ngX,m3h3x8(:,378),heltab2x24(:,:,390))
  call Hloop_A_Q(ntryL,G0H8(73),20,nMB,G1H8(164),n2h8(103))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(444),h0tab(:,444),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(74),m3h3x8(:,379),heltab2x24(:,:,391))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(445),h0tab(:,445),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(75),m3h3x8(:,380),heltab2x24(:,:,392))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(446),h0tab(:,446),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(76),m3h3x8(:,381),heltab2x24(:,:,393))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(447),h0tab(:,447),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(77),m3h3x8(:,382),heltab2x24(:,:,394))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(448),h0tab(:,448),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(78),m3h3x8(:,383),heltab2x24(:,:,395))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(449),h0tab(:,449),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(79),m3h3x8(:,384),heltab2x24(:,:,396))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(450),h0tab(:,450),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(80),m3h3x8(:,385),heltab2x24(:,:,397))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(451),h0tab(:,451),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(82),m3h3x8(:,386),heltab2x24(:,:,398))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(452),h0tab(:,452),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(165),m3h3x8(:,387),heltab2x24(:,:,399))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(453),h0tab(:,453),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(166),m3h3x8(:,388),heltab2x24(:,:,400))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(454),h0tab(:,454),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(171),m3h3x8(:,389),heltab2x24(:,:,401))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(455),h0tab(:,455),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(169),m3h3x8(:,390),heltab2x24(:,:,402))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(456),h0tab(:,456),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(170),m3h3x8(:,391),heltab2x24(:,:,403))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(457),h0tab(:,457),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(172),m3h3x8(:,392),heltab2x24(:,:,404))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(458),h0tab(:,458),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(177),m3h3x8(:,393),heltab2x24(:,:,405))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(459),h0tab(:,459),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(175),m3h3x8(:,394),heltab2x24(:,:,406))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(460),h0tab(:,460),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(176),m3h3x8(:,395),heltab2x24(:,:,407))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(461),h0tab(:,461),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(178),m3h3x8(:,396),heltab2x24(:,:,408))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(462),h0tab(:,462),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(179),m3h3x8(:,397),heltab2x24(:,:,409))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(463),h0tab(:,463),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(180),m3h3x8(:,398),heltab2x24(:,:,410))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(464),h0tab(:,464),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(75),m3h3x8(:,399),heltab2x24(:,:,411))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(465),h0tab(:,465),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(76),m3h3x8(:,400),heltab2x24(:,:,412))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(466),h0tab(:,466),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(91),m3h3x8(:,401),heltab2x24(:,:,413))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(467),h0tab(:,467),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(93),m3h3x8(:,402),heltab2x24(:,:,414))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(468),h0tab(:,468),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(84),ngZl,m3h3x8(:,403),heltab2x24(:,:,415))
  call Hloop_Q_A(ntryL,G0H8(84),20,0,G1H8(127),n2h8(104))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(469),h0tab(:,469),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(86),ngZl,m3h3x8(:,404),heltab2x24(:,:,416))
  call Hloop_Q_A(ntryL,G0H8(86),20,nML,G1H8(128),n2h8(105))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(470),h0tab(:,470),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(88),ngZl,m3h3x8(:,405),heltab2x24(:,:,417))
  call Hloop_A_Q(ntryL,G0H8(88),20,0,G1H8(135),n2h8(106))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(471),h0tab(:,471),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(89),ngZl,m3h3x8(:,406),heltab2x24(:,:,418))
  call Hloop_A_Q(ntryL,G0H8(89),20,nML,G1H8(137),n2h8(107))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(472),h0tab(:,472),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(90),ngZu,m3h3x8(:,407),heltab2x24(:,:,419))
  call Hloop_Q_A(ntryL,G0H8(90),20,0,G1H8(155),n2h8(108))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(473),h0tab(:,473),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(91),ngZu,m3h3x8(:,408),heltab2x24(:,:,420))
  call Hloop_Q_A(ntryL,G0H8(91),20,nMT,G1H8(157),n2h8(109))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(474),h0tab(:,474),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(92),ngZu,m3h3x8(:,409),heltab2x24(:,:,421))
  call Hloop_A_Q(ntryL,G0H8(92),20,0,G1H8(16),n2h8(110))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(475),h0tab(:,475),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(93),ngZu,m3h3x8(:,410),heltab2x24(:,:,422))
  call Hloop_A_Q(ntryL,G0H8(93),20,nMT,G1H8(17),n2h8(111))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(476),h0tab(:,476),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(94),ngZd,m3h3x8(:,411),heltab2x24(:,:,423))
  call Hloop_Q_A(ntryL,G0H8(94),20,0,G1H8(3),n2h8(112))
  Gcoeff(:)%j = (c(145)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(477),h0tab(:,477),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(95),ngZd,m3h3x8(:,412),heltab2x24(:,:,424))
  call Hloop_Q_A(ntryL,G0H8(95),20,nMB,G1H8(5),n2h8(113))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(478),h0tab(:,478),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(96),ngZd,m3h3x8(:,413),heltab2x24(:,:,425))
  call Hloop_A_Q(ntryL,G0H8(96),20,0,G1H8(168),n2h8(114))
  Gcoeff(:)%j = (c(145)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(479),h0tab(:,479),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,17))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(97),ngZd,m3h3x8(:,414),heltab2x24(:,:,426))
  call Hloop_A_Q(ntryL,G0H8(97),20,nMB,G1H8(174),n2h8(115))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(480),h0tab(:,480),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(98),ngZl,m3h3x8(:,415),heltab2x24(:,:,427))
  call Hloop_Q_A(ntryL,G0H8(98),20,0,G1H8(173),n2h8(116))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(481),h0tab(:,481),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(99),ngZl,m3h3x8(:,416),heltab2x24(:,:,428))
  call Hloop_Q_A(ntryL,G0H8(99),20,nML,G1H8(167),n2h8(117))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(482),h0tab(:,482),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(100),ngZl,m3h3x8(:,417),heltab2x24(:,:,429))
  call Hloop_A_Q(ntryL,G0H8(100),20,0,G1H8(95),n2h8(118))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(483),h0tab(:,483),[20,3,8],[nML,nML,nML],3,2,wf3(:,1),wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(101),ngZl,m3h3x8(:,418),heltab2x24(:,:,430))
  call Hloop_A_Q(ntryL,G0H8(101),20,nML,G1H8(97),n2h8(119))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(484),h0tab(:,484),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(102),ngZu,m3h3x8(:,419),heltab2x24(:,:,431))
  call Hloop_Q_A(ntryL,G0H8(102),20,0,G1H8(123),n2h8(120))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(485),h0tab(:,485),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(103),ngZu,m3h3x8(:,420),heltab2x24(:,:,432))
  call Hloop_Q_A(ntryL,G0H8(103),20,nMT,G1H8(124),n2h8(121))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(486),h0tab(:,486),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(104),ngZu,m3h3x8(:,421),heltab2x24(:,:,433))
  call Hloop_A_Q(ntryL,G0H8(104),20,0,G1H8(20),n2h8(122))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(487),h0tab(:,487),[20,3,8],[nMT,nMT,nMT],3,2,wf3(:,1),wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(107),ngZu,m3h3x8(:,422),heltab2x24(:,:,434))
  call Hloop_A_Q(ntryL,G0H8(107),20,nMT,G1H8(21),n2h8(123))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(488),h0tab(:,488),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(106),ngZd,m3h3x8(:,423),heltab2x24(:,:,435))
  call Hloop_Q_A(ntryL,G0H8(106),20,0,G1H8(22),n2h8(124))
  Gcoeff(:)%j = (-(c(148)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(489),h0tab(:,489),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(3),ngZd,m3h3x8(:,424),heltab2x24(:,:,436))
  call Hloop_Q_A(ntryL,G0H8(3),20,nMB,G1H8(1),n2h8(125))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(490),h0tab(:,490),[20,3,8],[0,0,0],3,2,wf3(:,1),wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(105),ngZd,m3h3x8(:,425),heltab2x24(:,:,437))
  call Hloop_A_Q(ntryL,G0H8(105),20,0,G1H8(18),n2h8(126))
  Gcoeff(:)%j = (-(c(148)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(491),h0tab(:,491),[20,3,8],[nMB,nMB,nMB],3,2,wf3(:,1),wf4(:,18))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(23),ngZd,m3h3x8(:,426),heltab2x24(:,:,438))
  call Hloop_A_Q(ntryL,G0H8(23),20,nMB,G1H8(19),n2h8(127))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(492),h0tab(:,492),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(2),m3h3x8(:,427),heltab2x24(:,:,439))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(493),h0tab(:,493),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(23),m3h3x8(:,428),heltab2x24(:,:,440))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(494),h0tab(:,494),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(4),m3h3x8(:,429),heltab2x24(:,:,441))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(495),h0tab(:,495),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(7),m3h3x8(:,430),heltab2x24(:,:,442))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(496),h0tab(:,496),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(8),m3h3x8(:,431),heltab2x24(:,:,443))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(497),h0tab(:,497),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf3(:,1),G1H8(9),m3h3x8(:,432),heltab2x24(:,:,444))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(498),h0tab(:,498),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(14),m3h3x8(:,433),heltab2x24(:,:,445))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(499),h0tab(:,499),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf3(:,1),G1H8(25),m3h3x8(:,434),heltab2x24(:,:,446))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(500),h0tab(:,500),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(26),m3h3x8(:,435),heltab2x24(:,:,447))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(501),h0tab(:,501),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf3(:,1),G1H8(27),m3h3x8(:,436),heltab2x24(:,:,448))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(502),h0tab(:,502),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(29),m3h3x8(:,437),heltab2x24(:,:,449))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(503),h0tab(:,503),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf3(:,1),G1H8(30),m3h3x8(:,438),heltab2x24(:,:,450))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(504),h0tab(:,504),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(32),m3h3x8(:,439),heltab2x24(:,:,451))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(505),h0tab(:,505),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(34),m3h3x8(:,440),heltab2x24(:,:,452))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(506),h0tab(:,506),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(36),m3h3x8(:,441),heltab2x24(:,:,453))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(507),h0tab(:,507),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(37),m3h3x8(:,442),heltab2x24(:,:,454))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(508),h0tab(:,508),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(49),m3h3x8(:,443),heltab2x24(:,:,455))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(509),h0tab(:,509),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(51),m3h3x8(:,444),heltab2x24(:,:,456))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(510),h0tab(:,510),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(53),m3h3x8(:,445),heltab2x24(:,:,457))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(511),h0tab(:,511),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(2),m3h3x8(:,446),heltab2x24(:,:,458))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(512),h0tab(:,512),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(17),m3h3x8(:,447),heltab2x24(:,:,459))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(513),h0tab(:,513),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(19),m3h3x8(:,448),heltab2x24(:,:,460))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(514),h0tab(:,514),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(21),m3h3x8(:,449),heltab2x24(:,:,461))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(515),h0tab(:,515),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(55),m3h3x8(:,450),heltab2x24(:,:,462))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(516),h0tab(:,516),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(38),m3h3x8(:,451),heltab2x24(:,:,463))
  Gcoeff(:)%j = (c(105)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(517),h0tab(:,517),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(39),m3h3x8(:,452),heltab2x24(:,:,464))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(518),h0tab(:,518),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(41),m3h3x8(:,453),heltab2x24(:,:,465))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(519),h0tab(:,519),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(42),m3h3x8(:,454),heltab2x24(:,:,466))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(520),h0tab(:,520),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(43),m3h3x8(:,455),heltab2x24(:,:,467))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(521),h0tab(:,521),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(44),m3h3x8(:,456),heltab2x24(:,:,468))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(522),h0tab(:,522),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(46),m3h3x8(:,457),heltab2x24(:,:,469))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(523),h0tab(:,523),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(47),m3h3x8(:,458),heltab2x24(:,:,470))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(524),h0tab(:,524),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(81),m3h3x8(:,459),heltab2x24(:,:,471))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(525),h0tab(:,525),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(83),m3h3x8(:,460),heltab2x24(:,:,472))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(526),h0tab(:,526),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(85),m3h3x8(:,461),heltab2x24(:,:,473))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(527),h0tab(:,527),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,1),G0H8(87),m3h3x8(:,462),heltab2x24(:,:,474))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(528),h0tab(:,528),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(4),m3h3x8(:,463),heltab2x24(:,:,475))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(529),h0tab(:,529),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(5),m3h3x8(:,464),heltab2x24(:,:,476))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(530),h0tab(:,530),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(7),m3h3x8(:,465),heltab2x24(:,:,477))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(531),h0tab(:,531),[20,3,8],[nMW,nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(8),m3h3x8(:,466),heltab2x24(:,:,478))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(532),h0tab(:,532),[16,7,8],[nML,nML,nML],3,1,wf4(:,19))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(9),ngZl,m3h3x8(:,467),heltab2x24(:,:,479))
  call Hloop_A_Q(ntryL,G0H8(9),16,nML,G1H8(48),n2h8(128))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(533),h0tab(:,533),[16,7,8],[nML,nML,nML],3,1,wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(10),ngZl,m3h3x8(:,468),heltab2x24(:,:,480))
  call Hloop_Q_A(ntryL,G0H8(10),16,nML,G1H8(49),n2h8(129))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(534),h0tab(:,534),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,19))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(11),ngZu,m3h3x8(:,469),heltab2x24(:,:,481))
  call Hloop_A_Q(ntryL,G0H8(11),16,nMT,G1H8(52),n2h8(130))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(535),h0tab(:,535),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(12),ngZu,m3h3x8(:,470),heltab2x24(:,:,482))
  call Hloop_Q_A(ntryL,G0H8(12),16,nMT,G1H8(54),n2h8(131))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(536),h0tab(:,536),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,19))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(13),ngZd,m3h3x8(:,471),heltab2x24(:,:,483))
  call Hloop_A_Q(ntryL,G0H8(13),16,nMB,G1H8(55),n2h8(132))
  Gcoeff(:)%j = (c(129)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(537),h0tab(:,537),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(14),ngZd,m3h3x8(:,472),heltab2x24(:,:,484))
  call Hloop_Q_A(ntryL,G0H8(14),16,nMB,G1H8(56),n2h8(133))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(538),h0tab(:,538),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(58),m3h3x8(:,473),heltab2x24(:,:,485))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(539),h0tab(:,539),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(59),m3h3x8(:,474),heltab2x24(:,:,486))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(540),h0tab(:,540),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(60),m3h3x8(:,475),heltab2x24(:,:,487))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(541),h0tab(:,541),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(61),m3h3x8(:,476),heltab2x24(:,:,488))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(542),h0tab(:,542),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(15),m3h3x8(:,477),heltab2x24(:,:,489))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(543),h0tab(:,543),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(62),m3h3x8(:,478),heltab2x24(:,:,490))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(544),h0tab(:,544),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(63),m3h3x8(:,479),heltab2x24(:,:,491))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(545),h0tab(:,545),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(64),m3h3x8(:,480),heltab2x24(:,:,492))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(546),h0tab(:,546),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(65),m3h3x8(:,481),heltab2x24(:,:,493))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(547),h0tab(:,547),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(66),m3h3x8(:,482),heltab2x24(:,:,494))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(548),h0tab(:,548),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(63),m3h3x8(:,483),heltab2x24(:,:,495))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(549),h0tab(:,549),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,19))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(64),m3h3x8(:,484),heltab2x24(:,:,496))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(550),h0tab(:,550),[16,7,8],[0,0,0],3,1,wf4(:,20))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(65),ngZl,m3h3x8(:,485),heltab2x24(:,:,497))
  call Hloop_A_Q(ntryL,G0H8(65),16,0,G1H8(68),n2h8(134))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(551),h0tab(:,551),[16,7,8],[nML,nML,nML],3,1,wf4(:,20))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(66),ngZl,m3h3x8(:,486),heltab2x24(:,:,498))
  call Hloop_A_Q(ntryL,G0H8(66),16,nML,G1H8(69),n2h8(135))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(552),h0tab(:,552),[16,7,8],[0,0,0],3,1,wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(67),ngZl,m3h3x8(:,487),heltab2x24(:,:,499))
  call Hloop_Q_A(ntryL,G0H8(67),16,0,G1H8(70),n2h8(136))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(553),h0tab(:,553),[16,7,8],[nML,nML,nML],3,1,wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(68),ngZl,m3h3x8(:,488),heltab2x24(:,:,500))
  call Hloop_Q_A(ntryL,G0H8(68),16,nML,G1H8(73),n2h8(137))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(554),h0tab(:,554),[16,7,8],[0,0,0],3,1,wf4(:,20))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,489),heltab2x24(:,:,501))
  call Hloop_A_Q(ntryL,G0H8(69),16,0,G1H8(77),n2h8(138))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(555),h0tab(:,555),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,20))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(70),ngZu,m3h3x8(:,490),heltab2x24(:,:,502))
  call Hloop_A_Q(ntryL,G0H8(70),16,nMT,G1H8(78),n2h8(139))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(556),h0tab(:,556),[16,7,8],[0,0,0],3,1,wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(71),ngZu,m3h3x8(:,491),heltab2x24(:,:,503))
  call Hloop_Q_A(ntryL,G0H8(71),16,0,G1H8(79),n2h8(140))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(557),h0tab(:,557),[16,7,8],[nMT,nMT,nMT],3,1,wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(72),ngZu,m3h3x8(:,492),heltab2x24(:,:,504))
  call Hloop_Q_A(ntryL,G0H8(72),16,nMT,G1H8(80),n2h8(141))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(558),h0tab(:,558),[16,7,8],[0,0,0],3,1,wf4(:,20))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(73),ngZd,m3h3x8(:,493),heltab2x24(:,:,505))
  call Hloop_A_Q(ntryL,G0H8(73),16,0,G1H8(82),n2h8(142))
  Gcoeff(:)%j = (-(c(148)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(559),h0tab(:,559),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,20))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(84),ngZd,m3h3x8(:,494),heltab2x24(:,:,506))
  call Hloop_A_Q(ntryL,G0H8(84),16,nMB,G1H8(83),n2h8(143))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(560),h0tab(:,560),[16,7,8],[0,0,0],3,1,wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(86),ngZd,m3h3x8(:,495),heltab2x24(:,:,507))
  call Hloop_Q_A(ntryL,G0H8(86),16,0,G1H8(84),n2h8(144))
  Gcoeff(:)%j = (-(c(148)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(561),h0tab(:,561),[16,7,8],[nMB,nMB,nMB],3,1,wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(88),ngZd,m3h3x8(:,496),heltab2x24(:,:,508))
  call Hloop_Q_A(ntryL,G0H8(88),16,nMB,G1H8(85),n2h8(145))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(562),h0tab(:,562),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(87),m3h3x8(:,497),heltab2x24(:,:,509))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(563),h0tab(:,563),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(88),m3h3x8(:,498),heltab2x24(:,:,510))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(564),h0tab(:,564),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(89),m3h3x8(:,499),heltab2x24(:,:,511))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(565),h0tab(:,565),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(90),m3h3x8(:,500),heltab2x24(:,:,512))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(566),h0tab(:,566),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(94),m3h3x8(:,501),heltab2x24(:,:,513))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(567),h0tab(:,567),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(96),m3h3x8(:,502),heltab2x24(:,:,514))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(568),h0tab(:,568),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(98),m3h3x8(:,503),heltab2x24(:,:,515))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(569),h0tab(:,569),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(99),m3h3x8(:,504),heltab2x24(:,:,516))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(570),h0tab(:,570),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(89),m3h3x8(:,505),heltab2x24(:,:,517))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(571),h0tab(:,571),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(90),m3h3x8(:,506),heltab2x24(:,:,518))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(572),h0tab(:,572),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(101),m3h3x8(:,507),heltab2x24(:,:,519))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(573),h0tab(:,573),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(102),m3h3x8(:,508),heltab2x24(:,:,520))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(574),h0tab(:,574),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(91),m3h3x8(:,509),heltab2x24(:,:,521))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(575),h0tab(:,575),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(92),m3h3x8(:,510),heltab2x24(:,:,522))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(576),h0tab(:,576),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(93),m3h3x8(:,511),heltab2x24(:,:,523))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(577),h0tab(:,577),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(94),m3h3x8(:,512),heltab2x24(:,:,524))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(578),h0tab(:,578),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(103),m3h3x8(:,513),heltab2x24(:,:,525))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(579),h0tab(:,579),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(104),m3h3x8(:,514),heltab2x24(:,:,526))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(580),h0tab(:,580),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(95),m3h3x8(:,515),heltab2x24(:,:,527))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(581),h0tab(:,581),[16,7,8],[nMW,nMW,nMW],3,1,wf4(:,20))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(96),m3h3x8(:,516),heltab2x24(:,:,528))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(582),h0tab(:,582),[19,4,8],[nML,nML,nML],3,1,wf12(:,5))
  call Hloop_AS_Q(ntryL,G0H24(1),wf12(:,5),G0H2(15),ngH,m3h12x2(:,1),heltab2x24(:,:,529))
  call Hloop_A_Q(ntryL,G0H2(15),19,nML,G1H2(134),n2h2(155))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(583),h0tab(:,583),[19,4,8],[nML,nML,nML],3,1,wf12(:,5))
  call Hloop_QS_A(ntryL,G0H24(1),wf12(:,5),G0H2(13),ngH,m3h12x2(:,2),heltab2x24(:,:,530))
  call Hloop_Q_A(ntryL,G0H2(13),19,nML,G1H2(82),n2h2(156))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(584),h0tab(:,584),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,5))
  call Hloop_AS_Q(ntryL,G0H24(1),wf12(:,5),G0H2(18),ngH,m3h12x2(:,3),heltab2x24(:,:,531))
  call Hloop_A_Q(ntryL,G0H2(18),19,nMT,G1H2(135),n2h2(157))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(585),h0tab(:,585),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,5))
  call Hloop_QS_A(ntryL,G0H24(1),wf12(:,5),G0H2(17),ngH,m3h12x2(:,4),heltab2x24(:,:,532))
  call Hloop_Q_A(ntryL,G0H2(17),19,nMT,G1H2(37),n2h2(158))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(586),h0tab(:,586),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,5))
  call Hloop_AS_Q(ntryL,G0H24(1),wf12(:,5),G0H2(12),ngH,m3h12x2(:,5),heltab2x24(:,:,533))
  call Hloop_A_Q(ntryL,G0H2(12),19,nMB,G1H2(137),n2h2(159))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(587),h0tab(:,587),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,5))
  call Hloop_QS_A(ntryL,G0H24(1),wf12(:,5),G0H2(10),ngH,m3h12x2(:,6),heltab2x24(:,:,534))
  call Hloop_Q_A(ntryL,G0H2(10),19,nMB,G1H2(139),n2h2(160))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(588),h0tab(:,588),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(11),m3h12x2(:,7),heltab2x24(:,:,535))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(589),h0tab(:,589),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(9),m3h12x2(:,8),heltab2x24(:,:,536))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(590),h0tab(:,590),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(15),m3h12x2(:,9),heltab2x24(:,:,537))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(591),h0tab(:,591),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(13),m3h12x2(:,10),heltab2x24(:,:,538))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(592),h0tab(:,592),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(18),m3h12x2(:,11),heltab2x24(:,:,539))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(593),h0tab(:,593),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(17),m3h12x2(:,12),heltab2x24(:,:,540))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(594),h0tab(:,594),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VS_V(ntryL,G0H24(1),wf12(:,5),G0H2(12),m3h12x2(:,13),heltab2x24(:,:,541))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(595),h0tab(:,595),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VS_V(ntryL,G0H24(1),wf12(:,5),G0H2(10),m3h12x2(:,14),heltab2x24(:,:,542))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(596),h0tab(:,596),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(31),m3h12x2(:,15),heltab2x24(:,:,543))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(597),h0tab(:,597),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(141),m3h12x2(:,16),heltab2x24(:,:,544))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(598),h0tab(:,598),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(83),m3h12x2(:,17),heltab2x24(:,:,545))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(599),h0tab(:,599),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(88),m3h12x2(:,18),heltab2x24(:,:,546))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(600),h0tab(:,600),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(25),m3h12x2(:,19),heltab2x24(:,:,547))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(601),h0tab(:,601),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_SS_S(ntryL,G0H24(1),wf12(:,5),G0H2(26),m3h12x2(:,20),heltab2x24(:,:,548))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(602),h0tab(:,602),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VS_V(ntryL,G0H24(1),wf12(:,5),G0H2(27),m3h12x2(:,21),heltab2x24(:,:,549))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(603),h0tab(:,603),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VS_V(ntryL,G0H24(1),wf12(:,5),G0H2(28),m3h12x2(:,22),heltab2x24(:,:,550))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(604),h0tab(:,604),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(145),m3h12x2(:,23),heltab2x24(:,:,551))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(605),h0tab(:,605),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(84),m3h12x2(:,24),heltab2x24(:,:,552))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(606),h0tab(:,606),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(147),m3h12x2(:,25),heltab2x24(:,:,553))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(607),h0tab(:,607),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,5))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(148),m3h12x2(:,26),heltab2x24(:,:,554))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(608),h0tab(:,608),[18,4,9],[nMZ,nMZ,0],3,2,wf6(:,4),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,4),G0H4(18),ngZu,m3h6x4(:,13),heltab2x24(:,:,555))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(609),h0tab(:,609),[18,4,9],[nMW,nMW,0],3,2,wf6(:,4),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,4),G0H4(19),m3h6x4(:,14),heltab2x24(:,:,556))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(610),h0tab(:,610),[20,2,9],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(97),ngZu,m3h3x8(:,517),heltab2x24(:,:,557))
  call Hloop_Q_A(ntryL,G0H8(97),20,0,G1H8(106),n2h8(146))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(611),h0tab(:,611),[20,2,9],[0,nMZ,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(98),ngZu,m3h3x8(:,518),heltab2x24(:,:,558))
  call Hloop_Q_A(ntryL,G0H8(98),20,0,G1H8(107),n2h8(147))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(612),h0tab(:,612),[20,2,9],[0,nMW,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(99),ngZd,m3h3x8(:,519),heltab2x24(:,:,559))
  call Hloop_Q_A(ntryL,G0H8(99),20,0,G1H8(6),n2h8(148))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(613),h0tab(:,613),[20,2,9],[0,0,0],3,2,wf3(:,1),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(100),ngZu,m3h3x8(:,520),heltab2x24(:,:,560))
  call Hloop_Q_A(ntryL,G0H8(100),20,0,G1H8(108),n2h8(149))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(614),h0tab(:,614),[20,2,9],[nMW,0,nMW],3,2,wf3(:,1),wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(109),m3h3x8(:,521),heltab2x24(:,:,561))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(615),h0tab(:,615),[16,4,11],[nML,nML,nML],3,1,wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(101),ngZl,m3h3x8(:,522),heltab2x24(:,:,562))
  call Hloop_Q_A(ntryL,G0H8(101),16,nML,G1H8(10),n2h8(150))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(616),h0tab(:,616),[16,4,11],[nML,nML,nML],3,1,wf8(:,3))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(102),ngZl,m3h3x8(:,523),heltab2x24(:,:,563))
  call Hloop_A_Q(ntryL,G0H8(102),16,nML,G1H8(110),n2h8(151))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(617),h0tab(:,617),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(103),ngZu,m3h3x8(:,524),heltab2x24(:,:,564))
  call Hloop_Q_A(ntryL,G0H8(103),16,nMT,G1H8(11),n2h8(152))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(618),h0tab(:,618),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,3))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(104),ngZu,m3h3x8(:,525),heltab2x24(:,:,565))
  call Hloop_A_Q(ntryL,G0H8(104),16,nMT,G1H8(15),n2h8(153))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(619),h0tab(:,619),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(107),ngZd,m3h3x8(:,526),heltab2x24(:,:,566))
  call Hloop_Q_A(ntryL,G0H8(107),16,nMB,G1H8(112),n2h8(154))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(620),h0tab(:,620),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,3))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(106),ngZd,m3h3x8(:,527),heltab2x24(:,:,567))
  call Hloop_A_Q(ntryL,G0H8(106),16,nMB,G1H8(24),n2h8(155))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(621),h0tab(:,621),[16,4,11],[nML,nML,nML],3,1,wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(3),ngZl,m3h3x8(:,528),heltab2x24(:,:,568))
  call Hloop_Q_A(ntryL,G0H8(3),16,nML,G1H8(113),n2h8(156))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(622),h0tab(:,622),[16,4,11],[nML,nML,nML],3,1,wf8(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(105),ngZl,m3h3x8(:,529),heltab2x24(:,:,569))
  call Hloop_A_Q(ntryL,G0H8(105),16,nML,G1H8(114),n2h8(157))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(623),h0tab(:,623),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(23),ngZu,m3h3x8(:,530),heltab2x24(:,:,570))
  call Hloop_Q_A(ntryL,G0H8(23),16,nMT,G1H8(33),n2h8(158))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(624),h0tab(:,624),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(9),ngZu,m3h3x8(:,531),heltab2x24(:,:,571))
  call Hloop_A_Q(ntryL,G0H8(9),16,nMT,G1H8(115),n2h8(159))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(625),h0tab(:,625),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(10),ngZd,m3h3x8(:,532),heltab2x24(:,:,572))
  call Hloop_Q_A(ntryL,G0H8(10),16,nMB,G1H8(51),n2h8(160))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(626),h0tab(:,626),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,1))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(11),ngZd,m3h3x8(:,533),heltab2x24(:,:,573))
  call Hloop_A_Q(ntryL,G0H8(11),16,nMB,G1H8(53),n2h8(161))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(627),h0tab(:,627),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(117),m3h3x8(:,534),heltab2x24(:,:,574))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(628),h0tab(:,628),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(71),m3h3x8(:,535),heltab2x24(:,:,575))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(629),h0tab(:,629),[16,4,11],[nMH,nMH,nMZ],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(118),m3h3x8(:,536),heltab2x24(:,:,576))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(630),h0tab(:,630),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(119),m3h3x8(:,537),heltab2x24(:,:,577))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(631),h0tab(:,631),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(120),m3h3x8(:,538),heltab2x24(:,:,578))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(632),h0tab(:,632),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(181),m3h3x8(:,539),heltab2x24(:,:,579))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(633),h0tab(:,633),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(182),m3h3x8(:,540),heltab2x24(:,:,580))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(634),h0tab(:,634),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(183),m3h3x8(:,541),heltab2x24(:,:,581))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(635),h0tab(:,635),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(184),m3h3x8(:,542),heltab2x24(:,:,582))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(636),h0tab(:,636),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(185),m3h3x8(:,543),heltab2x24(:,:,583))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(637),h0tab(:,637),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(186),m3h3x8(:,544),heltab2x24(:,:,584))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(638),h0tab(:,638),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(187),m3h3x8(:,545),heltab2x24(:,:,585))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(639),h0tab(:,639),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(188),m3h3x8(:,546),heltab2x24(:,:,586))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(640),h0tab(:,640),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(189),m3h3x8(:,547),heltab2x24(:,:,587))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(641),h0tab(:,641),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(190),m3h3x8(:,548),heltab2x24(:,:,588))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(642),h0tab(:,642),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(191),m3h3x8(:,549),heltab2x24(:,:,589))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(643),h0tab(:,643),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(192),m3h3x8(:,550),heltab2x24(:,:,590))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(644),h0tab(:,644),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(193),m3h3x8(:,551),heltab2x24(:,:,591))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(645),h0tab(:,645),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(12),m3h3x8(:,552),heltab2x24(:,:,592))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(646),h0tab(:,646),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(13),m3h3x8(:,553),heltab2x24(:,:,593))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(647),h0tab(:,647),[16,4,11],[nMH,nMH,nMZ],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(14),m3h3x8(:,554),heltab2x24(:,:,594))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(648),h0tab(:,648),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(65),m3h3x8(:,555),heltab2x24(:,:,595))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(649),h0tab(:,649),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(66),m3h3x8(:,556),heltab2x24(:,:,596))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(650),h0tab(:,650),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(194),m3h3x8(:,557),heltab2x24(:,:,597))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(651),h0tab(:,651),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(195),m3h3x8(:,558),heltab2x24(:,:,598))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(652),h0tab(:,652),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(196),m3h3x8(:,559),heltab2x24(:,:,599))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(653),h0tab(:,653),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(197),m3h3x8(:,560),heltab2x24(:,:,600))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(654),h0tab(:,654),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(198),m3h3x8(:,561),heltab2x24(:,:,601))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(655),h0tab(:,655),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(67),m3h3x8(:,562),heltab2x24(:,:,602))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(656),h0tab(:,656),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(68),m3h3x8(:,563),heltab2x24(:,:,603))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(657),h0tab(:,657),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(69),m3h3x8(:,564),heltab2x24(:,:,604))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(658),h0tab(:,658),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(70),m3h3x8(:,565),heltab2x24(:,:,605))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(659),h0tab(:,659),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(71),m3h3x8(:,566),heltab2x24(:,:,606))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(660),h0tab(:,660),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(72),m3h3x8(:,567),heltab2x24(:,:,607))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(661),h0tab(:,661),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(73),m3h3x8(:,568),heltab2x24(:,:,608))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(662),h0tab(:,662),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(84),m3h3x8(:,569),heltab2x24(:,:,609))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(663),h0tab(:,663),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(86),m3h3x8(:,570),heltab2x24(:,:,610))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(664),h0tab(:,664),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(199),m3h3x8(:,571),heltab2x24(:,:,611))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(665),h0tab(:,665),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(200),m3h3x8(:,572),heltab2x24(:,:,612))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(666),h0tab(:,666),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(201),m3h3x8(:,573),heltab2x24(:,:,613))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(667),h0tab(:,667),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(202),m3h3x8(:,574),heltab2x24(:,:,614))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(668),h0tab(:,668),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(88),m3h3x8(:,575),heltab2x24(:,:,615))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(669),h0tab(:,669),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(97),m3h3x8(:,576),heltab2x24(:,:,616))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(670),h0tab(:,670),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(98),m3h3x8(:,577),heltab2x24(:,:,617))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(671),h0tab(:,671),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(99),m3h3x8(:,578),heltab2x24(:,:,618))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(672),h0tab(:,672),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(100),m3h3x8(:,579),heltab2x24(:,:,619))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(673),h0tab(:,673),[25,2,4],[0,nMZ,nMZ],3,1,wf12(:,7))
  call Hloop_ZQ_A(ntryL,G0H24(1),wf12(:,7),G0H2(29),ngZu,m3h12x2(:,27),heltab2x24(:,:,620))
  call Hloop_Q_A(ntryL,G0H2(29),25,0,G1H2(97),n2h2(161))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(674),h0tab(:,674),[25,2,4],[0,nMW,nMW],3,1,wf12(:,7))
  call Hloop_WQ_A(ntryL,G0H24(1),wf12(:,7),G0H2(29),m3h12x2(:,28),heltab2x24(:,:,621))
  call Hloop_Q_A(ntryL,G0H2(29),25,0,G1H2(92),n2h2(162))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(675),h0tab(:,675),[17,4,10],[nMZ,nMZ,0],3,2,wf6(:,2),wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,2),G0H4(20),ngZu,m3h6x4(:,15),heltab2x24(:,:,622))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(676),h0tab(:,676),[17,4,10],[nMW,nMW,0],3,2,wf6(:,2),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,2),G0H4(21),m3h6x4(:,16),heltab2x24(:,:,623))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(677),h0tab(:,677),[20,1,10],[0,0,0],3,2,wf3(:,1),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(101),ngZu,m3h3x8(:,580),heltab2x24(:,:,624))
  call Hloop_A_Q(ntryL,G0H8(101),20,0,G1H8(203),n2h8(162))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(678),h0tab(:,678),[20,1,10],[0,nMZ,0],3,2,wf3(:,1),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(102),ngZu,m3h3x8(:,581),heltab2x24(:,:,625))
  call Hloop_A_Q(ntryL,G0H8(102),20,0,G1H8(204),n2h8(163))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(679),h0tab(:,679),[20,1,10],[0,nMW,0],3,2,wf3(:,1),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(103),ngZd,m3h3x8(:,582),heltab2x24(:,:,626))
  call Hloop_A_Q(ntryL,G0H8(103),20,0,G1H8(205),n2h8(164))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(680),h0tab(:,680),[20,1,10],[0,0,0],3,2,wf3(:,1),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,1),G0H8(104),ngZu,m3h3x8(:,583),heltab2x24(:,:,627))
  call Hloop_A_Q(ntryL,G0H8(104),20,0,G1H8(206),n2h8(165))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(681),h0tab(:,681),[20,1,10],[nMW,0,nMW],3,2,wf3(:,1),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(207),m3h3x8(:,584),heltab2x24(:,:,628))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(682),h0tab(:,682),[16,4,11],[nML,nML,nML],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(107),ngZl,m3h3x8(:,585),heltab2x24(:,:,629))
  call Hloop_Q_A(ntryL,G0H8(107),16,nML,G1H8(208),n2h8(166))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(683),h0tab(:,683),[16,4,11],[nML,nML,nML],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(106),ngZl,m3h3x8(:,586),heltab2x24(:,:,630))
  call Hloop_A_Q(ntryL,G0H8(106),16,nML,G1H8(209),n2h8(167))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(684),h0tab(:,684),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(3),ngZu,m3h3x8(:,587),heltab2x24(:,:,631))
  call Hloop_Q_A(ntryL,G0H8(3),16,nMT,G1H8(210),n2h8(168))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(685),h0tab(:,685),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(105),ngZu,m3h3x8(:,588),heltab2x24(:,:,632))
  call Hloop_A_Q(ntryL,G0H8(105),16,nMT,G1H8(211),n2h8(169))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(686),h0tab(:,686),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(23),ngZd,m3h3x8(:,589),heltab2x24(:,:,633))
  call Hloop_Q_A(ntryL,G0H8(23),16,nMB,G1H8(212),n2h8(170))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(687),h0tab(:,687),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(9),ngZd,m3h3x8(:,590),heltab2x24(:,:,634))
  call Hloop_A_Q(ntryL,G0H8(9),16,nMB,G1H8(213),n2h8(171))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(688),h0tab(:,688),[16,4,11],[nML,nML,nML],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(10),ngZl,m3h3x8(:,591),heltab2x24(:,:,635))
  call Hloop_Q_A(ntryL,G0H8(10),16,nML,G1H8(214),n2h8(172))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(689),h0tab(:,689),[16,4,11],[nML,nML,nML],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(11),ngZl,m3h3x8(:,592),heltab2x24(:,:,636))
  call Hloop_A_Q(ntryL,G0H8(11),16,nML,G1H8(215),n2h8(173))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(690),h0tab(:,690),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(101),ngZu,m3h3x8(:,593),heltab2x24(:,:,637))
  call Hloop_Q_A(ntryL,G0H8(101),16,nMT,G1H8(216),n2h8(174))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(691),h0tab(:,691),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(102),ngZu,m3h3x8(:,594),heltab2x24(:,:,638))
  call Hloop_A_Q(ntryL,G0H8(102),16,nMT,G1H8(217),n2h8(175))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(692),h0tab(:,692),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(103),ngZd,m3h3x8(:,595),heltab2x24(:,:,639))
  call Hloop_Q_A(ntryL,G0H8(103),16,nMB,G1H8(218),n2h8(176))
  Gcoeff(:)%j = (c(139)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(693),h0tab(:,693),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(104),ngZd,m3h3x8(:,596),heltab2x24(:,:,640))
  call Hloop_A_Q(ntryL,G0H8(104),16,nMB,G1H8(219),n2h8(177))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(694),h0tab(:,694),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(220),m3h3x8(:,597),heltab2x24(:,:,641))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(695),h0tab(:,695),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(221),m3h3x8(:,598),heltab2x24(:,:,642))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(696),h0tab(:,696),[16,4,11],[nMH,nMH,nMZ],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(222),m3h3x8(:,599),heltab2x24(:,:,643))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(697),h0tab(:,697),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(223),m3h3x8(:,600),heltab2x24(:,:,644))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(698),h0tab(:,698),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(224),m3h3x8(:,601),heltab2x24(:,:,645))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(699),h0tab(:,699),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(225),m3h3x8(:,602),heltab2x24(:,:,646))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(700),h0tab(:,700),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(226),m3h3x8(:,603),heltab2x24(:,:,647))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(701),h0tab(:,701),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(227),m3h3x8(:,604),heltab2x24(:,:,648))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(702),h0tab(:,702),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(228),m3h3x8(:,605),heltab2x24(:,:,649))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(703),h0tab(:,703),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(229),m3h3x8(:,606),heltab2x24(:,:,650))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(704),h0tab(:,704),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(230),m3h3x8(:,607),heltab2x24(:,:,651))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(705),h0tab(:,705),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(231),m3h3x8(:,608),heltab2x24(:,:,652))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(706),h0tab(:,706),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(232),m3h3x8(:,609),heltab2x24(:,:,653))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(707),h0tab(:,707),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(233),m3h3x8(:,610),heltab2x24(:,:,654))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(708),h0tab(:,708),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(234),m3h3x8(:,611),heltab2x24(:,:,655))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(709),h0tab(:,709),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(235),m3h3x8(:,612),heltab2x24(:,:,656))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(710),h0tab(:,710),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(236),m3h3x8(:,613),heltab2x24(:,:,657))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(711),h0tab(:,711),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(237),m3h3x8(:,614),heltab2x24(:,:,658))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(712),h0tab(:,712),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(107),m3h3x8(:,615),heltab2x24(:,:,659))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(713),h0tab(:,713),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(106),m3h3x8(:,616),heltab2x24(:,:,660))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(714),h0tab(:,714),[16,4,11],[nMH,nMH,nMZ],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(3),m3h3x8(:,617),heltab2x24(:,:,661))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(715),h0tab(:,715),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(105),m3h3x8(:,618),heltab2x24(:,:,662))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(716),h0tab(:,716),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(23),m3h3x8(:,619),heltab2x24(:,:,663))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(717),h0tab(:,717),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(238),m3h3x8(:,620),heltab2x24(:,:,664))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(718),h0tab(:,718),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(239),m3h3x8(:,621),heltab2x24(:,:,665))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(719),h0tab(:,719),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(240),m3h3x8(:,622),heltab2x24(:,:,666))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(720),h0tab(:,720),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(241),m3h3x8(:,623),heltab2x24(:,:,667))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(721),h0tab(:,721),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(242),m3h3x8(:,624),heltab2x24(:,:,668))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(722),h0tab(:,722),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(9),m3h3x8(:,625),heltab2x24(:,:,669))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(723),h0tab(:,723),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(10),m3h3x8(:,626),heltab2x24(:,:,670))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(724),h0tab(:,724),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(11),m3h3x8(:,627),heltab2x24(:,:,671))
  Gcoeff(:)%j = (-(c(117)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(725),h0tab(:,725),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(101),m3h3x8(:,628),heltab2x24(:,:,672))
  Gcoeff(:)%j = (c(117)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(726),h0tab(:,726),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(102),m3h3x8(:,629),heltab2x24(:,:,673))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(727),h0tab(:,727),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(103),m3h3x8(:,630),heltab2x24(:,:,674))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(728),h0tab(:,728),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(104),m3h3x8(:,631),heltab2x24(:,:,675))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(729),h0tab(:,729),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(108),m3h3x8(:,632),heltab2x24(:,:,676))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(730),h0tab(:,730),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(109),m3h3x8(:,633),heltab2x24(:,:,677))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(731),h0tab(:,731),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(243),m3h3x8(:,634),heltab2x24(:,:,678))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(732),h0tab(:,732),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(244),m3h3x8(:,635),heltab2x24(:,:,679))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(733),h0tab(:,733),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(245),m3h3x8(:,636),heltab2x24(:,:,680))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(734),h0tab(:,734),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(246),m3h3x8(:,637),heltab2x24(:,:,681))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(735),h0tab(:,735),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(110),m3h3x8(:,638),heltab2x24(:,:,682))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(736),h0tab(:,736),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(111),m3h3x8(:,639),heltab2x24(:,:,683))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(737),h0tab(:,737),[16,4,11],[nMZ,nMZ,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(112),m3h3x8(:,640),heltab2x24(:,:,684))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(738),h0tab(:,738),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(113),m3h3x8(:,641),heltab2x24(:,:,685))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(739),h0tab(:,739),[16,4,11],[nMW,nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(114),m3h3x8(:,642),heltab2x24(:,:,686))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(740),h0tab(:,740),[26,1,4],[0,nMZ,nMZ],3,1,wf12(:,9))
  call Hloop_ZA_Q(ntryL,G0H24(1),wf12(:,9),G0H2(29),ngZu,m3h12x2(:,29),heltab2x24(:,:,687))
  call Hloop_A_Q(ntryL,G0H2(29),26,0,G1H2(102),n2h2(163))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(741),h0tab(:,741),[26,1,4],[0,nMW,nMW],3,1,wf12(:,9))
  call Hloop_WA_Q(ntryL,G0H24(1),wf12(:,9),G0H2(29),m3h12x2(:,30),heltab2x24(:,:,688))
  call Hloop_A_Q(ntryL,G0H2(29),26,0,G1H2(101),n2h2(164))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(742),h0tab(:,742),[19,4,8],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,31),heltab2x24(:,:,689))
  call Hloop_A_Q(ntryL,G0H2(29),19,nML,G1H2(12),n2h2(165))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(743),h0tab(:,743),[19,4,8],[nML,nML,nML],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,32),heltab2x24(:,:,690))
  call Hloop_Q_A(ntryL,G0H2(29),19,nML,G1H2(112),n2h2(166))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(744),h0tab(:,744),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,33),heltab2x24(:,:,691))
  call Hloop_A_Q(ntryL,G0H2(29),19,nMT,G1H2(108),n2h2(167))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(745),h0tab(:,745),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,34),heltab2x24(:,:,692))
  call Hloop_Q_A(ntryL,G0H2(29),19,nMT,G1H2(115),n2h2(168))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(746),h0tab(:,746),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,35),heltab2x24(:,:,693))
  call Hloop_A_Q(ntryL,G0H2(29),19,nMB,G1H2(116),n2h2(169))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(747),h0tab(:,747),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,36),heltab2x24(:,:,694))
  call Hloop_Q_A(ntryL,G0H2(29),19,nMB,G1H2(118),n2h2(170))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(748),h0tab(:,748),[19,4,8],[nML,nML,nML],3,1,wf12(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf12(:,2),G0H2(29),ngZl,m3h12x2(:,37),heltab2x24(:,:,695))
  call Hloop_A_Q(ntryL,G0H2(29),19,nML,G1H2(58),n2h2(171))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(749),h0tab(:,749),[19,4,8],[nML,nML,nML],3,1,wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf12(:,2),G0H2(29),ngZl,m3h12x2(:,38),heltab2x24(:,:,696))
  call Hloop_Q_A(ntryL,G0H2(29),19,nML,G1H2(66),n2h2(172))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(750),h0tab(:,750),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf12(:,2),G0H2(29),ngZu,m3h12x2(:,39),heltab2x24(:,:,697))
  call Hloop_A_Q(ntryL,G0H2(29),19,nMT,G1H2(6),n2h2(173))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(751),h0tab(:,751),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf12(:,2),G0H2(29),ngZu,m3h12x2(:,40),heltab2x24(:,:,698))
  call Hloop_Q_A(ntryL,G0H2(29),19,nMT,G1H2(30),n2h2(174))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(752),h0tab(:,752),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf12(:,2),G0H2(29),ngZd,m3h12x2(:,41),heltab2x24(:,:,699))
  call Hloop_A_Q(ntryL,G0H2(29),19,nMB,G1H2(122),n2h2(175))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(753),h0tab(:,753),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf12(:,2),G0H2(29),ngZd,m3h12x2(:,42),heltab2x24(:,:,700))
  call Hloop_Q_A(ntryL,G0H2(29),19,nMB,G1H2(124),n2h2(176))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(754),h0tab(:,754),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(126),m3h12x2(:,43),heltab2x24(:,:,701))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(755),h0tab(:,755),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(71),m3h12x2(:,44),heltab2x24(:,:,702))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(756),h0tab(:,756),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(129),m3h12x2(:,45),heltab2x24(:,:,703))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(757),h0tab(:,757),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(131),m3h12x2(:,46),heltab2x24(:,:,704))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(758),h0tab(:,758),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,1),G1H2(1),m3h12x2(:,47),heltab2x24(:,:,705))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(759),h0tab(:,759),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(132),m3h12x2(:,48),heltab2x24(:,:,706))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(760),h0tab(:,760),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,1),G1H2(32),m3h12x2(:,49),heltab2x24(:,:,707))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(761),h0tab(:,761),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(28),m3h12x2(:,50),heltab2x24(:,:,708))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(762),h0tab(:,762),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,2),G1H2(13),m3h12x2(:,51),heltab2x24(:,:,709))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(763),h0tab(:,763),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(19),m3h12x2(:,52),heltab2x24(:,:,710))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(764),h0tab(:,764),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,2),G1H2(26),m3h12x2(:,53),heltab2x24(:,:,711))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(765),h0tab(:,765),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(27),m3h12x2(:,54),heltab2x24(:,:,712))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(766),h0tab(:,766),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(43),m3h12x2(:,55),heltab2x24(:,:,713))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(767),h0tab(:,767),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(44),m3h12x2(:,56),heltab2x24(:,:,714))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(768),h0tab(:,768),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(49),m3h12x2(:,57),heltab2x24(:,:,715))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(769),h0tab(:,769),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(67),m3h12x2(:,58),heltab2x24(:,:,716))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(770),h0tab(:,770),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,1),G0H2(29),m3h12x2(:,59),heltab2x24(:,:,717))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(771),h0tab(:,771),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,1),G0H2(30),m3h12x2(:,60),heltab2x24(:,:,718))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(772),h0tab(:,772),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,2),G0H2(31),m3h12x2(:,61),heltab2x24(:,:,719))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(773),h0tab(:,773),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,2),G0H2(32),m3h12x2(:,62),heltab2x24(:,:,720))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(774),h0tab(:,774),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,1),G0H2(33),m3h12x2(:,63),heltab2x24(:,:,721))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(775),h0tab(:,775),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,1),G0H2(34),m3h12x2(:,64),heltab2x24(:,:,722))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(776),h0tab(:,776),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,2),G0H2(35),m3h12x2(:,65),heltab2x24(:,:,723))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(777),h0tab(:,777),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,2),G0H2(36),m3h12x2(:,66),heltab2x24(:,:,724))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(778),h0tab(:,778),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(75),m3h12x2(:,67),heltab2x24(:,:,725))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(779),h0tab(:,779),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(146),m3h12x2(:,68),heltab2x24(:,:,726))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(780),h0tab(:,780),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(149),m3h12x2(:,69),heltab2x24(:,:,727))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(781),h0tab(:,781),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(94),m3h12x2(:,70),heltab2x24(:,:,728))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(782),h0tab(:,782),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(96),m3h12x2(:,71),heltab2x24(:,:,729))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(783),h0tab(:,783),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,1),19,G1H2(117),m3h12x2(:,72),heltab2x24(:,:,730))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(784),h0tab(:,784),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(60),m3h12x2(:,73),heltab2x24(:,:,731))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(785),h0tab(:,785),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,2),19,G1H2(14),m3h12x2(:,74),heltab2x24(:,:,732))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(786),h0tab(:,786),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,1),G0H2(37),m3h12x2(:,75),heltab2x24(:,:,733))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(787),h0tab(:,787),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,1),G0H2(38),m3h12x2(:,76),heltab2x24(:,:,734))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(788),h0tab(:,788),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,2),G0H2(39),m3h12x2(:,77),heltab2x24(:,:,735))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(789),h0tab(:,789),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,2),G0H2(40),m3h12x2(:,78),heltab2x24(:,:,736))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(790),h0tab(:,790),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,1),G0H2(41),m3h12x2(:,79),heltab2x24(:,:,737))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(791),h0tab(:,791),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,1),G0H2(42),m3h12x2(:,80),heltab2x24(:,:,738))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(792),h0tab(:,792),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,2),G0H2(43),m3h12x2(:,81),heltab2x24(:,:,739))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(793),h0tab(:,793),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,2),G0H2(44),m3h12x2(:,82),heltab2x24(:,:,740))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(794),h0tab(:,794),[25,2,4],[0,nMZ,nMZ],3,1,wf12(:,11))
  call Hloop_ZQ_A(ntryL,G0H24(1),wf12(:,11),G0H2(45),ngZu,m3h12x2(:,83),heltab2x24(:,:,741))
  call Hloop_Q_A(ntryL,G0H2(45),25,0,G1H2(154),n2h2(177))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(795),h0tab(:,795),[25,2,4],[0,nMW,nMW],3,1,wf12(:,11))
  call Hloop_WQ_A(ntryL,G0H24(1),wf12(:,11),G0H2(45),m3h12x2(:,84),heltab2x24(:,:,742))
  call Hloop_Q_A(ntryL,G0H2(45),25,0,G1H2(15),n2h2(178))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(796),h0tab(:,796),[19,4,8],[nML,nML,nML],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,85),heltab2x24(:,:,743))
  call Hloop_A_Q(ntryL,G0H2(45),19,nML,G1H2(33),n2h2(179))
  Gcoeff(:)%j = (c(141)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(797),h0tab(:,797),[19,4,8],[nML,nML,nML],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,86),heltab2x24(:,:,744))
  call Hloop_Q_A(ntryL,G0H2(45),19,nML,G1H2(153),n2h2(180))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(798),h0tab(:,798),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,87),heltab2x24(:,:,745))
  call Hloop_A_Q(ntryL,G0H2(45),19,nMT,G1H2(45),n2h2(181))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(799),h0tab(:,799),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,88),heltab2x24(:,:,746))
  call Hloop_Q_A(ntryL,G0H2(45),19,nMT,G1H2(106),n2h2(182))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(800),h0tab(:,800),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,89),heltab2x24(:,:,747))
  call Hloop_A_Q(ntryL,G0H2(45),19,nMB,G1H2(107),n2h2(183))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(801),h0tab(:,801),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,90),heltab2x24(:,:,748))
  call Hloop_Q_A(ntryL,G0H2(45),19,nMB,G1H2(56),n2h2(184))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(802),h0tab(:,802),[19,4,8],[nML,nML,nML],3,1,wf12(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf12(:,4),G0H2(45),ngZl,m3h12x2(:,91),heltab2x24(:,:,749))
  call Hloop_A_Q(ntryL,G0H2(45),19,nML,G1H2(57),n2h2(185))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(803),h0tab(:,803),[19,4,8],[nML,nML,nML],3,1,wf12(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf12(:,4),G0H2(45),ngZl,m3h12x2(:,92),heltab2x24(:,:,750))
  call Hloop_Q_A(ntryL,G0H2(45),19,nML,G1H2(63),n2h2(186))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(804),h0tab(:,804),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf12(:,4),G0H2(45),ngZu,m3h12x2(:,93),heltab2x24(:,:,751))
  call Hloop_A_Q(ntryL,G0H2(45),19,nMT,G1H2(152),n2h2(187))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(805),h0tab(:,805),[19,4,8],[nMT,nMT,nMT],3,1,wf12(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf12(:,4),G0H2(45),ngZu,m3h12x2(:,94),heltab2x24(:,:,752))
  call Hloop_Q_A(ntryL,G0H2(45),19,nMT,G1H2(68),n2h2(188))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(806),h0tab(:,806),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf12(:,4),G0H2(45),ngZd,m3h12x2(:,95),heltab2x24(:,:,753))
  call Hloop_A_Q(ntryL,G0H2(45),19,nMB,G1H2(74),n2h2(189))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(807),h0tab(:,807),[19,4,8],[nMB,nMB,nMB],3,1,wf12(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf12(:,4),G0H2(45),ngZd,m3h12x2(:,96),heltab2x24(:,:,754))
  call Hloop_Q_A(ntryL,G0H2(45),19,nMB,G1H2(81),n2h2(190))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(808),h0tab(:,808),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(79),m3h12x2(:,97),heltab2x24(:,:,755))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(809),h0tab(:,809),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(18),m3h12x2(:,98),heltab2x24(:,:,756))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(810),h0tab(:,810),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(64),m3h12x2(:,99),heltab2x24(:,:,757))
  Gcoeff(:)%j = (-(c(93)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(811),h0tab(:,811),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(76),m3h12x2(:,100),heltab2x24(:,:,758))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(812),h0tab(:,812),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,3),G1H2(157),m3h12x2(:,101),heltab2x24(:,:,759))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(813),h0tab(:,813),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(29),m3h12x2(:,102),heltab2x24(:,:,760))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(814),h0tab(:,814),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,3),G1H2(158),m3h12x2(:,103),heltab2x24(:,:,761))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(815),h0tab(:,815),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(161),m3h12x2(:,104),heltab2x24(:,:,762))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(816),h0tab(:,816),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,4),G1H2(85),m3h12x2(:,105),heltab2x24(:,:,763))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(817),h0tab(:,817),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(162),m3h12x2(:,106),heltab2x24(:,:,764))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(818),h0tab(:,818),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H24(1),0,wf12(:,4),G1H2(165),m3h12x2(:,107),heltab2x24(:,:,765))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(819),h0tab(:,819),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(87),m3h12x2(:,108),heltab2x24(:,:,766))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(820),h0tab(:,820),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(166),m3h12x2(:,109),heltab2x24(:,:,767))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(821),h0tab(:,821),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(169),m3h12x2(:,110),heltab2x24(:,:,768))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(822),h0tab(:,822),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(24),m3h12x2(:,111),heltab2x24(:,:,769))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(823),h0tab(:,823),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(170),m3h12x2(:,112),heltab2x24(:,:,770))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(824),h0tab(:,824),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,3),G0H2(45),m3h12x2(:,113),heltab2x24(:,:,771))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(825),h0tab(:,825),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,3),G0H2(46),m3h12x2(:,114),heltab2x24(:,:,772))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(826),h0tab(:,826),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,4),G0H2(47),m3h12x2(:,115),heltab2x24(:,:,773))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(827),h0tab(:,827),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,4),G0H2(48),m3h12x2(:,116),heltab2x24(:,:,774))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(828),h0tab(:,828),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,3),G0H2(49),m3h12x2(:,117),heltab2x24(:,:,775))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(829),h0tab(:,829),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,3),G0H2(50),m3h12x2(:,118),heltab2x24(:,:,776))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(830),h0tab(:,830),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,4),G0H2(51),m3h12x2(:,119),heltab2x24(:,:,777))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(831),h0tab(:,831),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,4),G0H2(52),m3h12x2(:,120),heltab2x24(:,:,778))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(832),h0tab(:,832),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(173),m3h12x2(:,121),heltab2x24(:,:,779))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(833),h0tab(:,833),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(46),m3h12x2(:,122),heltab2x24(:,:,780))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(834),h0tab(:,834),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(174),m3h12x2(:,123),heltab2x24(:,:,781))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(835),h0tab(:,835),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(177),m3h12x2(:,124),heltab2x24(:,:,782))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(836),h0tab(:,836),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(52),m3h12x2(:,125),heltab2x24(:,:,783))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(837),h0tab(:,837),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,3),19,G1H2(178),m3h12x2(:,126),heltab2x24(:,:,784))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(838),h0tab(:,838),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(181),m3h12x2(:,127),heltab2x24(:,:,785))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(839),h0tab(:,839),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf12(:,4),19,G1H2(125),m3h12x2(:,128),heltab2x24(:,:,786))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(840),h0tab(:,840),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,3),G0H2(53),m3h12x2(:,129),heltab2x24(:,:,787))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(841),h0tab(:,841),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,3),G0H2(54),m3h12x2(:,130),heltab2x24(:,:,788))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(842),h0tab(:,842),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,4),G0H2(55),m3h12x2(:,131),heltab2x24(:,:,789))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(843),h0tab(:,843),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),wf12(:,4),G0H2(56),m3h12x2(:,132),heltab2x24(:,:,790))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(844),h0tab(:,844),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,3),G0H2(57),m3h12x2(:,133),heltab2x24(:,:,791))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(845),h0tab(:,845),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,3),G0H2(58),m3h12x2(:,134),heltab2x24(:,:,792))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(846),h0tab(:,846),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,4),G0H2(59),m3h12x2(:,135),heltab2x24(:,:,793))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(847),h0tab(:,847),[19,4,8],[nMW,nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,4),G0H2(60),m3h12x2(:,136),heltab2x24(:,:,794))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(848),h0tab(:,848),[26,1,4],[0,nMZ,nMZ],3,1,wf12(:,13))
  call Hloop_ZA_Q(ntryL,G0H24(1),wf12(:,13),G0H2(61),ngZu,m3h12x2(:,137),heltab2x24(:,:,795))
  call Hloop_A_Q(ntryL,G0H2(61),26,0,G1H2(182),n2h2(191))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(849),h0tab(:,849),[26,1,4],[0,nMW,nMW],3,1,wf12(:,13))
  call Hloop_WA_Q(ntryL,G0H24(1),wf12(:,13),G0H2(61),m3h12x2(:,138),heltab2x24(:,:,796))
  call Hloop_A_Q(ntryL,G0H2(61),26,0,G1H2(185),n2h2(192))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(850),h0tab(:,850),[21,2,8],[0,0,0],3,1,wf6(:,8))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,8),G0H4(22),m3h6x4(:,17),heltab2x24(:,:,797))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(851),h0tab(:,851),[21,2,8],[nMZ,0,0],3,1,wf6(:,8))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,8),G0H4(23),ngZu,m3h6x4(:,18),heltab2x24(:,:,798))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(852),h0tab(:,852),[21,2,8],[nMW,0,0],3,1,wf6(:,8))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,8),G0H4(24),m3h6x4(:,19),heltab2x24(:,:,799))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(853),h0tab(:,853),[21,2,8],[0,0,0],3,1,wf6(:,8))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,8),G0H4(25),m3h6x4(:,20),heltab2x24(:,:,800))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(854),h0tab(:,854),[21,2,8],[0,nMW,nMW],3,1,wf6(:,8))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,8),G0H4(26),m3h6x4(:,21),heltab2x24(:,:,801))
  call Hloop_Q_A(ntryL,G0H4(26),21,0,G1H4(7),n2h4(55))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(855),h0tab(:,855),[22,1,8],[0,0,0],3,1,wf6(:,6))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,6),G0H4(26),m3h6x4(:,22),heltab2x24(:,:,802))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(856),h0tab(:,856),[22,1,8],[nMZ,0,0],3,1,wf6(:,6))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,6),G0H4(27),ngZu,m3h6x4(:,23),heltab2x24(:,:,803))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(857),h0tab(:,857),[22,1,8],[nMW,0,0],3,1,wf6(:,6))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,6),G0H4(28),m3h6x4(:,24),heltab2x24(:,:,804))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(858),h0tab(:,858),[22,1,8],[0,0,0],3,1,wf6(:,6))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,6),G0H4(29),m3h6x4(:,25),heltab2x24(:,:,805))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(859),h0tab(:,859),[22,1,8],[0,nMW,nMW],3,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,6),G0H4(30),m3h6x4(:,26),heltab2x24(:,:,806))
  call Hloop_A_Q(ntryL,G0H4(30),22,0,G1H4(11),n2h4(56))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(181),G1H2(178),G1H2(52),G1H2(14),G1H2(60) &
    ,G1H2(117),G1H2(96),G1H2(20),G0H2(28),G0H2(27),G0H2(5),G0H2(6),G0H2(19),G0H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(33),G1H2(58),G1H2(12),G1H2(134),G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(153),G1H2(66),G1H2(112),G1H2(82),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(152),[G1H2(45),G1H2(6),G1H2(108),G1H2(135),G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(68),[G1H2(106),G1H2(30),G1H2(115),G1H2(37),G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(107),G1H2(122),G1H2(116),G1H2(137),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(56),G1H2(124),G1H2(118),G1H2(139),G1H2(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(177),[G1H2(174),G1H2(46),G1H2(173),G1H2(94),G1H2(149) &
    ,G1H2(146),G1H2(75),G1H2(90),G0H2(26),G0H2(25),G0H2(22),G0H2(7),G0H2(24),G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(151),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(137),[G1H8(152),G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(157),[G1H8(153),G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(154),G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(156),G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(174),[G1H8(158),G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(167),[G1H8(159),G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(160),G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(161),G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(162),G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(163),G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(164),G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(170),[G1H8(92),G0H8(17),G0H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(172),[G1H8(100),G0H8(19),G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(177),[G1H8(105),G0H8(21),G0H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(12),G0H8(55),G0H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(176),[G1H8(111),G0H8(81),G0H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(178),[G1H8(31),G0H8(83),G0H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(179),[G1H8(116),G0H8(85),G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(180),[G1H8(72),G0H8(87),G0H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(79),G1H2(129),G1H2(126),G0H2(11),G0H2(1) &
    ,G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(18),G1H2(131),G1H2(71),G0H2(9),G0H2(14) &
    ,G0H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(166),G1H2(49),G1H2(43),G0H2(12),G0H2(2) &
    ,G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(170),[G1H2(169),G1H2(67),G1H2(44),G0H2(10),G0H2(21) &
    ,G0H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(122),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(126),[G1H8(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(10),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(12),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(14),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(16),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(134),[G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(142),[G1H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(165),[G0H8(49),G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(166),[G0H8(51),G0H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G0H8(53),G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G0H8(2),G0H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G0H8(4),G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G0H8(5),G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G0H8(7),G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(93),[G0H8(8),G0H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(146),[G1H8(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(148),[G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(150),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(8),G0H8(76),G0H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(9),G0H8(77),G0H8(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(26),G0H8(80),G0H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(27),G0H8(82),G0H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(155),G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(168),[G1H8(16),G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(85),G1H2(158),G1H2(157),G1H2(26),G1H2(13) &
    ,G1H2(32),G1H2(1),G0H2(18),G0H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(162),G1H2(161),G1H2(29),G1H2(27),G1H2(19) &
    ,G1H2(28),G1H2(132),G0H2(17),G0H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(31),G0H2(48),G0H2(47),G0H2(46),G0H2(45) &
    ,G0H2(32),G0H2(31),G0H2(30),G0H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G0H2(51),G0H2(49),G0H2(35),G0H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G0H2(52),G0H2(50),G0H2(36),G0H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G0H2(55),G0H2(53),G0H2(39),G0H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G0H2(56),G0H2(54),G0H2(40),G0H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(147),G0H2(60),G0H2(59),G0H2(58),G0H2(57) &
    ,G0H2(44),G0H2(43),G0H2(42),G0H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(184),[G1H8(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(185),[G1H8(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(188),[G1H8(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(189),[G1H8(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(66),[G0H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(195),[G1H8(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(198),[G1H8(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(200),[G1H8(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(202),[G1H8(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(97),[G0H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(100),[G0H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(206),[G1H8(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(228),[G1H8(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(229),[G1H8(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(232),[G1H8(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(233),[G1H8(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(106),[G0H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(239),[G1H8(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(242),[G1H8(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(244),[G1H8(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(246),[G1H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(111),[G0H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(114),[G0H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(182),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(25),[G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(29),[G0H4(26)])
  call Hloop_QV_A(ntryL,G1H4(19),ex4(:),G1H2(127),m3h2x2(:,81),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(127),29,0,G2H2(140),n2h2(193))
  call Hloop_VT_S(ntryL,G1H2(125),19,ex3(:),4,G2H2(137),m3h1x2(:,75),heltab2x2(:,:,382))
  call Hloop_UW_V(ntryL,G1H2(54),19,ex4(:),8,G2H1(3),m3h2x1(:,308),heltab2x2(:,:,383))
  call Hloop_UV_W(ntryL,G1H2(47),19,ex4(:),8,G2H1(4),m3h2x1(:,309),heltab2x2(:,:,384))
  call Hloop_QV_A(ntryL,G1H2(23),ex4(:),G1H1(29),m3h2x1(:,310),heltab2x2(:,:,385))
  call Hloop_Q_A(ntryL,G1H1(29),27,nML,G2H1(5),n2h1(203))
  call Hloop_AV_Q(ntryL,G1H2(10),ex4(:),G1H1(22),m3h2x1(:,311),heltab2x2(:,:,386))
  call Hloop_A_Q(ntryL,G1H1(22),27,nML,G2H1(6),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(36),ex4(:),G1H1(11),m3h2x1(:,312),heltab2x2(:,:,387))
  call Hloop_Q_A(ntryL,G1H1(11),27,nMT,G2H1(46),n2h1(205))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(13),m3h2x1(:,313),heltab2x2(:,:,388))
  call Hloop_A_Q(ntryL,G1H1(13),27,nMT,G2H1(22),n2h1(206))
  call Hloop_QV_A(ntryL,G1H2(93),ex4(:),G1H1(9),m3h2x1(:,314),heltab2x2(:,:,389))
  call Hloop_Q_A(ntryL,G1H1(9),27,nMB,G2H1(24),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H2(103),ex4(:),G1H1(16),m3h2x1(:,315),heltab2x2(:,:,390))
  call Hloop_A_Q(ntryL,G1H1(16),27,nMB,G2H1(25),n2h1(208))
  call Hloop_TV_S(ntryL,G1H2(11),19,ex4(:),8,G2H1(27),m3h2x1(:,316),heltab2x2(:,:,391))
  call Hloop_SV_T(ntryL,G1H2(105),19,ex4(:),8,G2H1(14),m3h2x1(:,317),heltab2x2(:,:,392))
  call Hloop_CV_D(ntryL,G1H2(114),19,ex4(:),8,G2H1(28),m3h2x1(:,318),heltab2x2(:,:,393))
  call Hloop_DV_C(ntryL,G1H2(119),19,ex4(:),G2H1(30),m3h2x1(:,319),heltab2x2(:,:,394))
  call Hloop_AS_Q(ntryL,G1H2(57),ex3(:),G1H2(186),ngH,m3h1x2(:,76),heltab2x2(:,:,395))
  call Hloop_A_Q(ntryL,G1H2(186),23,nML,G2H2(134),n2h2(194))
  call Hloop_QS_A(ntryL,G1H2(63),ex3(:),G1H2(189),ngH,m3h1x2(:,77),heltab2x2(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(189),23,nML,G2H2(27),n2h2(195))
  call Hloop_AS_Q(ntryL,G1H2(152),ex3(:),G1H2(72),ngH,m3h1x2(:,78),heltab2x2(:,:,397))
  call Hloop_A_Q(ntryL,G1H2(72),23,nMT,G2H2(24),n2h2(196))
  call Hloop_QS_A(ntryL,G1H2(68),ex3(:),G1H2(190),ngH,m3h1x2(:,79),heltab2x2(:,:,398))
  call Hloop_Q_A(ntryL,G1H2(190),23,nMT,G2H2(65),n2h2(197))
  call Hloop_AS_Q(ntryL,G1H2(74),ex3(:),G1H2(193),ngH,m3h1x2(:,80),heltab2x2(:,:,399))
  call Hloop_A_Q(ntryL,G1H2(193),23,nMB,G2H2(57),n2h2(198))
  call Hloop_QS_A(ntryL,G1H2(81),ex3(:),G1H2(181),ngH,m3h1x2(:,81),heltab2x2(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(181),23,nMB,G2H2(53),n2h2(199))
  call Hloop_ST_V(ntryL,G1H2(177),19,ex3(:),4,G2H2(3),m3h1x2(:,82),heltab2x2(:,:,401))
  call Hloop_QV_A(ntryL,G1H8(128),wf4(:,17),G1H2(178),m3h4x2(:,241),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(178),23,nML,G2H2(12),n2h2(200))
  call Hloop_AV_Q(ntryL,G1H8(137),wf4(:,17),G1H2(52),m3h4x2(:,242),heltab2x8(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(52),23,nML,G2H2(13),n2h2(201))
  call Hloop_QV_A(ntryL,G1H8(157),wf4(:,17),G1H2(14),m3h4x2(:,243),heltab2x8(:,:,411))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMT,G2H2(58),n2h2(202))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,17),G1H2(60),m3h4x2(:,244),heltab2x8(:,:,412))
  call Hloop_A_Q(ntryL,G1H2(60),23,nMT,G2H2(54),n2h2(203))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,17),G1H2(117),m3h4x2(:,245),heltab2x8(:,:,413))
  call Hloop_Q_A(ntryL,G1H2(117),23,nMB,G2H2(4),n2h2(204))
  call Hloop_AV_Q(ntryL,G1H8(174),wf4(:,17),G1H2(96),m3h4x2(:,246),heltab2x8(:,:,414))
  call Hloop_A_Q(ntryL,G1H2(96),23,nMB,G2H2(15),n2h2(205))
  call Hloop_QZ_A(ntryL,G1H8(167),wf4(:,18),G1H2(20),ngZl,m3h4x2(:,247),heltab2x8(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(20),23,nML,G2H2(61),n2h2(206))
  call Hloop_AZ_Q(ntryL,G1H8(97),wf4(:,18),G1H2(33),ngZl,m3h4x2(:,248),heltab2x8(:,:,416))
  call Hloop_A_Q(ntryL,G1H2(33),23,nML,G2H2(41),n2h2(207))
  call Hloop_QZ_A(ntryL,G1H8(124),wf4(:,18),G1H2(58),ngZu,m3h4x2(:,249),heltab2x8(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(58),23,nMT,G2H2(38),n2h2(208))
  call Hloop_AZ_Q(ntryL,G1H8(21),wf4(:,18),G1H2(12),ngZu,m3h4x2(:,250),heltab2x8(:,:,418))
  call Hloop_A_Q(ntryL,G1H2(12),23,nMT,G2H2(62),n2h2(209))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,18),G1H2(134),ngZd,m3h4x2(:,251),heltab2x8(:,:,419))
  call Hloop_Q_A(ntryL,G1H2(134),23,nMB,G2H2(42),n2h2(210))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,18),G1H2(70),ngZd,m3h4x2(:,252),heltab2x8(:,:,420))
  call Hloop_A_Q(ntryL,G1H2(70),23,nMB,G2H2(37),n2h2(211))
  call Hloop_TV_S(ntryL,G1H8(170),20,wf4(:,17),3,G2H2(43),m3h4x2(:,253),heltab2x8(:,:,421))
  call Hloop_SV_T(ntryL,G1H8(172),20,wf4(:,17),3,G2H2(44),m3h4x2(:,254),heltab2x8(:,:,422))
  call Hloop_TV_S(ntryL,G1H8(177),20,wf4(:,18),3,G2H2(128),m3h4x2(:,255),heltab2x8(:,:,423))
  call Hloop_SV_T(ntryL,G1H8(175),20,wf4(:,18),3,G2H2(125),m3h4x2(:,256),heltab2x8(:,:,424))
  call Hloop_UV_W(ntryL,G1H8(176),20,wf4(:,17),3,G2H2(122),m3h4x2(:,257),heltab2x8(:,:,425))
  call Hloop_UW_V(ntryL,G1H8(178),20,wf4(:,17),3,G2H2(86),m3h4x2(:,258),heltab2x8(:,:,426))
  call Hloop_UV_W(ntryL,G1H8(179),20,wf4(:,18),3,G2H2(88),m3h4x2(:,259),heltab2x8(:,:,427))
  call Hloop_UW_V(ntryL,G1H8(180),20,wf4(:,18),3,G2H2(89),m3h4x2(:,260),heltab2x8(:,:,428))
  call Hloop_SS_S(ntryL,G1H2(64),ex3(:),G1H2(153),m3h1x2(:,83),heltab2x2(:,:,402))
  call Hloop_SS_S(ntryL,G1H2(76),ex3(:),G1H2(66),m3h1x2(:,84),heltab2x2(:,:,403))
  call Hloop_VS_V(ntryL,G1H2(24),ex3(:),G1H2(112),m3h1x2(:,85),heltab2x2(:,:,404))
  call Hloop_VS_V(ntryL,G1H2(170),ex3(:),G1H2(82),m3h1x2(:,86),heltab2x2(:,:,405))
  call Hloop_SS_S(ntryL,G1H8(122),ex3(:),G1H8(151),m3h1x8(:,85),heltab2x8(:,:,429))
  call Hloop_SS_S(ntryL,G1H8(126),ex3(:),G1H8(13),m3h1x8(:,86),heltab2x8(:,:,430))
  call Hloop_VS_V(ntryL,G1H8(130),ex3(:),G1H8(152),m3h1x8(:,87),heltab2x8(:,:,431))
  call Hloop_VS_V(ntryL,G1H8(132),ex3(:),G1H8(28),m3h1x8(:,88),heltab2x8(:,:,432))
  call Hloop_VT_S(ntryL,G0H8(6),16,ex3(:),4,G1H8(153),m3h1x8(:,89),heltab2x8(:,:,433))
  call Hloop_VT_S(ntryL,G0H8(18),16,ex3(:),4,G1H8(35),m3h1x8(:,90),heltab2x8(:,:,434))
  call Hloop_ST_V(ntryL,G0H8(22),16,ex3(:),4,G1H8(154),m3h1x8(:,91),heltab2x8(:,:,435))
  call Hloop_ST_V(ntryL,G0H8(25),16,ex3(:),4,G1H8(40),m3h1x8(:,92),heltab2x8(:,:,436))
  call Hloop_TV_S(ntryL,G0H4(4),24,wf4(:,17),3,G1H1(3),m3h4x1(:,11),heltab2x4(:,:,108))
  call Hloop_SV_T(ntryL,G0H4(5),24,wf4(:,17),3,G1H1(17),m3h4x1(:,12),heltab2x4(:,:,109))
  call Hloop_TV_S(ntryL,G0H4(6),24,wf4(:,18),3,G1H1(39),m3h4x1(:,13),heltab2x4(:,:,110))
  call Hloop_SV_T(ntryL,G0H4(1),24,wf4(:,18),3,G1H1(19),m3h4x1(:,14),heltab2x4(:,:,111))
  call Hloop_UV_W(ntryL,G0H4(2),24,wf4(:,17),3,G1H1(38),m3h4x1(:,15),heltab2x4(:,:,112))
  call Hloop_UW_V(ntryL,G0H4(7),24,wf4(:,17),3,G1H1(34),m3h4x1(:,16),heltab2x4(:,:,113))
  call Hloop_UV_W(ntryL,G0H4(3),24,wf4(:,18),3,G1H1(40),m3h4x1(:,17),heltab2x4(:,:,114))
  call Hloop_UW_V(ntryL,G0H4(8),24,wf4(:,18),3,G1H1(23),m3h4x1(:,18),heltab2x4(:,:,115))
  call Hloop_SV_V(ntryL,G0H4(10),wf4(:,17),G0H1(1),m3h4x1(:,19),heltab2x4(:,:,116))
  call Hloop_SV_V(ntryL,G0H4(12),wf4(:,18),G0H1(2),m3h4x1(:,20),heltab2x4(:,:,117))
  call Hloop_VV_S(ntryL,G0H4(14),wf4(:,17),G0H1(3),m3h4x1(:,21),heltab2x4(:,:,118))
  call Hloop_VV_S(ntryL,G0H4(16),wf4(:,18),G0H1(4),m3h4x1(:,22),heltab2x4(:,:,119))
  call Hloop_VVS_S(ntryL,G0H8(26),wf4(:,17),ex3(:),G0H2(61),m4h4x1x2(:,1),heltab3x8(:,:,1))
  call Hloop_VVS_S(ntryL,G0H8(27),wf4(:,17),ex3(:),G0H2(28),m4h4x1x2(:,2),heltab3x8(:,:,2))
  call Hloop_VVS_S(ntryL,G0H8(28),wf4(:,18),ex3(:),G0H2(27),m4h4x1x2(:,3),heltab3x8(:,:,3))
  call Hloop_VVS_S(ntryL,G0H8(29),wf4(:,18),ex3(:),G0H2(5),m4h4x1x2(:,4),heltab3x8(:,:,4))
  call Hloop_SSV_V(ntryL,G1H8(134),ex3(:),wf4(:,17),G1H2(123),m4h1x4x2(:,1),heltab3x8(:,:,5))
  call Hloop_SSV_V(ntryL,G1H8(138),ex3(:),wf4(:,18),G1H2(45),m4h1x4x2(:,2),heltab3x8(:,:,6))
  call Hloop_VVS_S(ntryL,G1H8(140),wf4(:,17),ex3(:),G1H2(6),m4h4x1x2(:,5),heltab3x8(:,:,7))
  call Hloop_VVS_S(ntryL,G1H8(142),wf4(:,18),ex3(:),G1H2(108),m4h4x1x2(:,6),heltab3x8(:,:,8))
  call Hloop_SSV_V(ntryL,G0H8(30),ex3(:),wf4(:,17),G0H2(6),m4h1x4x2(:,3),heltab3x8(:,:,9))
  call Hloop_SSV_V(ntryL,G0H8(31),ex3(:),wf4(:,17),G0H2(19),m4h1x4x2(:,4),heltab3x8(:,:,10))
  call Hloop_SSV_V(ntryL,G0H8(32),ex3(:),wf4(:,18),G0H2(20),m4h1x4x2(:,5),heltab3x8(:,:,11))
  call Hloop_SSV_V(ntryL,G0H8(33),ex3(:),wf4(:,18),G0H2(26),m4h1x4x2(:,6),heltab3x8(:,:,12))
  call Hloop_VV_S(ntryL,G1H8(165),wf4(:,17),G1H2(135),m3h4x2(:,261),heltab2x8(:,:,437))
  call Hloop_VV_S(ntryL,G1H8(166),wf4(:,17),G1H2(128),m3h4x2(:,262),heltab2x8(:,:,438))
  call Hloop_VV_S(ntryL,G1H8(171),wf4(:,18),G1H2(106),m3h4x2(:,263),heltab2x8(:,:,439))
  call Hloop_VV_S(ntryL,G1H8(169),wf4(:,18),G1H2(30),m3h4x2(:,264),heltab2x8(:,:,440))
  call Hloop_SV_V(ntryL,G1H8(75),wf4(:,17),G1H2(115),m3h4x2(:,265),heltab2x8(:,:,441))
  call Hloop_SV_V(ntryL,G1H8(76),wf4(:,17),G1H2(37),m3h4x2(:,266),heltab2x8(:,:,442))
  call Hloop_SV_V(ntryL,G1H8(91),wf4(:,18),G1H2(133),m3h4x2(:,267),heltab2x8(:,:,443))
  call Hloop_SV_V(ntryL,G1H8(93),wf4(:,18),G1H2(107),m3h4x2(:,268),heltab2x8(:,:,444))
  call Hloop_SV_V(ntryL,G1H8(144),wf4(:,17),G1H2(122),m3h4x2(:,269),heltab2x8(:,:,445))
  call Hloop_SV_V(ntryL,G1H8(146),wf4(:,18),G1H2(116),m3h4x2(:,270),heltab2x8(:,:,446))
  call Hloop_SV_T(ntryL,G0H8(52),16,wf4(:,17),3,G1H2(137),m3h4x2(:,271),heltab2x8(:,:,447))
  call Hloop_TV_S(ntryL,G0H8(54),16,wf4(:,17),3,G1H2(138),m3h4x2(:,272),heltab2x8(:,:,448))
  call Hloop_SV_T(ntryL,G0H8(56),16,wf4(:,18),3,G1H2(56),m3h4x2(:,273),heltab2x8(:,:,449))
  call Hloop_TV_S(ntryL,G0H8(57),16,wf4(:,18),3,G1H2(124),m3h4x2(:,274),heltab2x8(:,:,450))
  call Hloop_UW_V(ntryL,G0H8(58),16,wf4(:,17),3,G1H2(118),m3h4x2(:,275),heltab2x8(:,:,451))
  call Hloop_UV_W(ntryL,G0H8(59),16,wf4(:,17),3,G1H2(139),m3h4x2(:,276),heltab2x8(:,:,452))
  call Hloop_UW_V(ntryL,G0H8(60),16,wf4(:,18),3,G1H2(143),m3h4x2(:,277),heltab2x8(:,:,453))
  call Hloop_UV_W(ntryL,G0H8(61),16,wf4(:,18),3,G1H2(174),m3h4x2(:,278),heltab2x8(:,:,454))
  call Hloop_VV_S(ntryL,G1H8(148),wf4(:,17),G1H2(46),m3h4x2(:,279),heltab2x8(:,:,455))
  call Hloop_VV_S(ntryL,G1H8(150),wf4(:,18),G1H2(173),m3h4x2(:,280),heltab2x8(:,:,456))
  call Hloop_WQ_A(ntryL,G0H4(17),ex1(:),G0H2(25),m3h2x2(:,82),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G0H2(25),29,0,G1H2(94),n2h2(212))
  call Hloop_CV_D(ntryL,G1H8(14),20,wf4(:,17),3,G2H2(91),m3h4x2(:,281),heltab2x8(:,:,457))
  call Hloop_DV_C(ntryL,G1H8(25),20,wf4(:,17),G2H2(92),m3h4x2(:,282),heltab2x8(:,:,458))
  call Hloop_CV_D(ntryL,G1H8(29),20,wf4(:,18),3,G2H2(94),m3h4x2(:,283),heltab2x8(:,:,459))
  call Hloop_DV_C(ntryL,G1H8(30),20,wf4(:,18),G2H2(95),m3h4x2(:,284),heltab2x8(:,:,460))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,17),G1H2(149),m3h4x2(:,285),heltab2x8(:,:,461))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(97),n2h2(213))
  call Hloop_AV_Q(ntryL,G1H8(168),wf4(:,17),G1H2(146),m3h4x2(:,286),heltab2x8(:,:,462))
  call Hloop_A_Q(ntryL,G1H2(146),23,0,G2H2(98),n2h2(214))
  call Hloop_QZ_A(ntryL,G1H8(173),wf4(:,18),G1H2(75),ngZl,m3h4x2(:,287),heltab2x8(:,:,463))
  call Hloop_Q_A(ntryL,G1H2(75),23,0,G2H2(100),n2h2(215))
  call Hloop_AZ_Q(ntryL,G1H8(95),wf4(:,18),G1H2(90),ngZl,m3h4x2(:,288),heltab2x8(:,:,464))
  call Hloop_A_Q(ntryL,G1H2(90),23,0,G2H2(101),n2h2(216))
  call Hloop_QZ_A(ntryL,G1H8(123),wf4(:,18),G1H2(79),ngZu,m3h4x2(:,289),heltab2x8(:,:,465))
  call Hloop_Q_A(ntryL,G1H2(79),23,0,G2H2(103),n2h2(217))
  call Hloop_AZ_Q(ntryL,G1H8(20),wf4(:,18),G1H2(129),ngZu,m3h4x2(:,290),heltab2x8(:,:,466))
  call Hloop_A_Q(ntryL,G1H2(129),23,0,G2H2(130),n2h2(218))
  call Hloop_QZ_A(ntryL,G1H8(22),wf4(:,18),G1H2(126),ngZd,m3h4x2(:,291),heltab2x8(:,:,467))
  call Hloop_Q_A(ntryL,G1H2(126),23,0,G2H2(127),n2h2(219))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,18),G1H2(18),ngZd,m3h4x2(:,292),heltab2x8(:,:,468))
  call Hloop_A_Q(ntryL,G1H2(18),23,0,G2H2(124),n2h2(220))
  call Hloop_TV_S(ntryL,G1H8(2),20,wf4(:,17),3,G2H2(142),m3h4x2(:,293),heltab2x8(:,:,469))
  call Hloop_SV_T(ntryL,G1H8(23),20,wf4(:,17),3,G2H2(139),m3h4x2(:,294),heltab2x8(:,:,470))
  call Hloop_TV_S(ntryL,G1H8(4),20,wf4(:,18),3,G2H2(136),m3h4x2(:,295),heltab2x8(:,:,471))
  call Hloop_SV_T(ntryL,G1H8(7),20,wf4(:,18),3,G2H2(143),m3h4x2(:,296),heltab2x8(:,:,472))
  call Hloop_UV_W(ntryL,G1H8(32),20,wf4(:,17),3,G2H2(14),m3h4x2(:,297),heltab2x8(:,:,473))
  call Hloop_UW_V(ntryL,G1H8(34),20,wf4(:,17),3,G2H2(10),m3h4x2(:,298),heltab2x8(:,:,474))
  call Hloop_UV_W(ntryL,G1H8(36),20,wf4(:,18),3,G2H2(18),m3h4x2(:,299),heltab2x8(:,:,475))
  call Hloop_UW_V(ntryL,G1H8(37),20,wf4(:,18),3,G2H2(8),m3h4x2(:,300),heltab2x8(:,:,476))
  call Hloop_SV_V(ntryL,G1H8(39),wf4(:,17),G1H2(131),m3h4x2(:,301),heltab2x8(:,:,477))
  call Hloop_SV_V(ntryL,G1H8(42),wf4(:,18),G1H2(71),m3h4x2(:,302),heltab2x8(:,:,478))
  call Hloop_VV_S(ntryL,G1H8(44),wf4(:,17),G1H2(166),m3h4x2(:,303),heltab2x8(:,:,479))
  call Hloop_VV_S(ntryL,G1H8(47),wf4(:,18),G1H2(49),m3h4x2(:,304),heltab2x8(:,:,480))
  call Hloop_AS_Q(ntryL,G1H8(48),wf4(:,19),G1H2(43),ngX,m3h4x2(:,305),heltab2x8(:,:,481))
  call Hloop_A_Q(ntryL,G1H2(43),23,nML,G2H2(17),n2h2(221))
  call Hloop_QS_A(ntryL,G1H8(49),wf4(:,19),G1H2(169),ngX,m3h4x2(:,306),heltab2x8(:,:,482))
  call Hloop_Q_A(ntryL,G1H2(169),23,nML,G2H2(35),n2h2(222))
  call Hloop_AS_Q(ntryL,G1H8(52),wf4(:,19),G1H2(67),ngX,m3h4x2(:,307),heltab2x8(:,:,483))
  call Hloop_A_Q(ntryL,G1H2(67),23,nMT,G2H2(33),n2h2(223))
  call Hloop_QS_A(ntryL,G1H8(54),wf4(:,19),G1H2(44),ngX,m3h4x2(:,308),heltab2x8(:,:,484))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMT,G2H2(72),n2h2(224))
  call Hloop_AS_Q(ntryL,G1H8(55),wf4(:,19),G1H2(85),ngX,m3h4x2(:,309),heltab2x8(:,:,485))
  call Hloop_A_Q(ntryL,G1H2(85),23,nMB,G2H2(34),n2h2(225))
  call Hloop_QS_A(ntryL,G1H8(56),wf4(:,19),G1H2(158),ngX,m3h4x2(:,310),heltab2x8(:,:,486))
  call Hloop_Q_A(ntryL,G1H2(158),23,nMB,G2H2(39),n2h2(226))
  call Hloop_SS_S(ntryL,G1H8(60),wf4(:,19),G1H2(157),m3h4x2(:,311),heltab2x8(:,:,487))
  call Hloop_SS_S(ntryL,G1H8(61),wf4(:,19),G1H2(26),m3h4x2(:,312),heltab2x8(:,:,488))
  call Hloop_VT_S(ntryL,G0H8(15),16,wf4(:,19),7,G1H2(13),m3h4x2(:,313),heltab2x8(:,:,489))
  call Hloop_VT_S(ntryL,G0H8(62),16,wf4(:,19),7,G1H2(32),m3h4x2(:,314),heltab2x8(:,:,490))
  call Hloop_ST_V(ntryL,G1H8(64),16,wf4(:,19),7,G2H2(71),m3h4x2(:,315),heltab2x8(:,:,491))
  call Hloop_VT_S(ntryL,G1H8(66),16,wf4(:,19),7,G2H2(70),m3h4x2(:,316),heltab2x8(:,:,492))
  call Hloop_ST_V(ntryL,G0H8(63),16,wf4(:,19),7,G1H2(1),m3h4x2(:,317),heltab2x8(:,:,493))
  call Hloop_ST_V(ntryL,G0H8(64),16,wf4(:,19),7,G1H2(162),m3h4x2(:,318),heltab2x8(:,:,494))
  call Hloop_AZ_Q(ntryL,G1H8(68),wf4(:,20),G1H2(161),ngZl,m3h4x2(:,319),heltab2x8(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(161),23,0,G2H2(69),n2h2(227))
  call Hloop_AZ_Q(ntryL,G1H8(69),wf4(:,20),G1H2(29),ngZl,m3h4x2(:,320),heltab2x8(:,:,496))
  call Hloop_A_Q(ntryL,G1H2(29),23,nML,G2H2(30),n2h2(228))
  call Hloop_QZ_A(ntryL,G1H8(70),wf4(:,20),G1H2(27),ngZl,m3h4x2(:,321),heltab2x8(:,:,497))
  call Hloop_Q_A(ntryL,G1H2(27),23,0,G2H2(29),n2h2(229))
  call Hloop_QZ_A(ntryL,G1H8(73),wf4(:,20),G1H2(19),ngZl,m3h4x2(:,322),heltab2x8(:,:,498))
  call Hloop_Q_A(ntryL,G1H2(19),23,nML,G2H2(20),n2h2(230))
  call Hloop_AZ_Q(ntryL,G1H8(77),wf4(:,20),G1H2(28),ngZu,m3h4x2(:,323),heltab2x8(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(28),23,0,G2H2(21),n2h2(231))
  call Hloop_AZ_Q(ntryL,G1H8(78),wf4(:,20),G1H2(132),ngZu,m3h4x2(:,324),heltab2x8(:,:,500))
  call Hloop_A_Q(ntryL,G1H2(132),23,nMT,G2H2(1),n2h2(232))
  call Hloop_QZ_A(ntryL,G1H8(79),wf4(:,20),G1H2(31),ngZu,m3h4x2(:,325),heltab2x8(:,:,501))
  call Hloop_Q_A(ntryL,G1H2(31),23,0,G2H2(2),n2h2(233))
  call Hloop_QZ_A(ntryL,G1H8(80),wf4(:,20),G1H2(147),ngZu,m3h4x2(:,326),heltab2x8(:,:,502))
  call Hloop_Q_A(ntryL,G1H2(147),23,nMT,G2H2(11),n2h2(234))
  call Hloop_AZ_Q(ntryL,G1H8(82),wf4(:,20),G1H2(97),ngZd,m3h4x2(:,327),heltab2x8(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(97),23,0,G2H2(25),n2h2(235))
  call Hloop_AZ_Q(ntryL,G1H8(83),wf4(:,20),G1H2(92),ngZd,m3h4x2(:,328),heltab2x8(:,:,504))
  call Hloop_A_Q(ntryL,G1H2(92),23,nMB,G2H2(16),n2h2(236))
  call Hloop_QZ_A(ntryL,G1H8(84),wf4(:,20),G1H2(102),ngZd,m3h4x2(:,329),heltab2x8(:,:,505))
  call Hloop_Q_A(ntryL,G1H2(102),23,0,G2H2(83),n2h2(237))
  call Hloop_QZ_A(ntryL,G1H8(85),wf4(:,20),G1H2(101),ngZd,m3h4x2(:,330),heltab2x8(:,:,506))
  call Hloop_Q_A(ntryL,G1H2(101),23,nMB,G2H2(67),n2h2(238))
  call Hloop_SV_T(ntryL,G1H8(87),16,wf4(:,20),7,G2H2(66),m3h4x2(:,331),heltab2x8(:,:,507))
  call Hloop_TV_S(ntryL,G1H8(88),16,wf4(:,20),7,G2H2(45),m3h4x2(:,332),heltab2x8(:,:,508))
  call Hloop_DV_C(ntryL,G1H8(94),16,wf4(:,20),G2H2(46),m3h4x2(:,333),heltab2x8(:,:,509))
  call Hloop_CV_D(ntryL,G1H8(96),16,wf4(:,20),7,G2H2(131),m3h4x2(:,334),heltab2x8(:,:,510))
  call Hloop_UW_V(ntryL,G1H8(98),16,wf4(:,20),7,G2H2(32),m3h4x2(:,335),heltab2x8(:,:,511))
  call Hloop_UV_W(ntryL,G1H8(99),16,wf4(:,20),7,G2H2(31),m3h4x2(:,336),heltab2x8(:,:,512))
  call Hloop_VV_S(ntryL,G0H8(89),wf4(:,20),G0H2(22),m3h4x2(:,337),heltab2x8(:,:,513))
  call Hloop_VV_S(ntryL,G0H8(90),wf4(:,20),G0H2(7),m3h4x2(:,338),heltab2x8(:,:,514))
  call Hloop_SV_V(ntryL,G1H8(102),wf4(:,20),G1H2(127),m3h4x2(:,339),heltab2x8(:,:,515))
  call Hloop_SV_T(ntryL,G0H8(91),16,wf4(:,20),7,G1H2(125),m3h4x2(:,340),heltab2x8(:,:,516))
  call Hloop_TV_S(ntryL,G0H8(92),16,wf4(:,20),7,G1H2(54),m3h4x2(:,341),heltab2x8(:,:,517))
  call Hloop_UW_V(ntryL,G0H8(93),16,wf4(:,20),7,G1H2(47),m3h4x2(:,342),heltab2x8(:,:,518))
  call Hloop_UV_W(ntryL,G0H8(94),16,wf4(:,20),7,G1H2(23),m3h4x2(:,343),heltab2x8(:,:,519))
  call Hloop_VV_S(ntryL,G1H8(104),wf4(:,20),G1H2(10),m3h4x2(:,344),heltab2x8(:,:,520))
  call Hloop_SV_V(ntryL,G0H8(95),wf4(:,20),G0H2(24),m3h4x2(:,345),heltab2x8(:,:,521))
  call Hloop_SV_V(ntryL,G0H8(96),wf4(:,20),G0H2(8),m3h4x2(:,346),heltab2x8(:,:,522))
  call Hloop_SS_S(ntryL,G1H2(165),ex3(:),G1H2(36),m3h1x2(:,87),heltab2x2(:,:,406))
  call Hloop_SS_S(ntryL,G1H2(87),ex3(:),G1H2(41),m3h1x2(:,88),heltab2x2(:,:,407))
  call Hloop_SS_S(ntryL,G1H2(141),ex3(:),G1H2(93),m3h1x2(:,89),heltab2x2(:,:,408))
  call Hloop_VT_S(ntryL,G1H2(83),19,ex3(:),4,G2H2(9),m3h1x2(:,90),heltab2x2(:,:,409))
  call Hloop_VT_S(ntryL,G1H2(88),19,ex3(:),4,G2H2(5),m3h1x2(:,91),heltab2x2(:,:,410))
  call Hloop_ST_V(ntryL,G1H2(145),19,ex3(:),4,G2H2(6),m3h1x2(:,92),heltab2x2(:,:,411))
  call Hloop_ST_V(ntryL,G1H2(84),19,ex3(:),4,G2H2(7),m3h1x2(:,93),heltab2x2(:,:,412))
  call Hloop_VS_V(ntryL,G1H2(148),ex3(:),G1H2(103),m3h1x2(:,94),heltab2x2(:,:,413))
  call Hloop_VS_V(ntryL,G0H4(18),ex3(:),G0H4(30),m3h1x4(:,17),heltab2x4(:,:,121))
  call Hloop_VS_V(ntryL,G0H4(19),ex3(:),G0H4(9),m3h1x4(:,18),heltab2x4(:,:,122))
  call Hloop_QA_V(ntryL,G1H8(108),ex2(:),G1H4(12),m3h2x4(:,85),heltab2x8(:,:,523))
  call Hloop_QA_Z(ntryL,G1H8(107),ex2(:),G1H4(6),ngZu,m3h2x4(:,86),heltab2x8(:,:,524))
  call Hloop_QA_W(ntryL,G1H8(6),ex2(:),G1H4(14),m3h2x4(:,87),heltab2x8(:,:,525))
  call Hloop_WA_Q(ntryL,G1H8(109),ex2(:),G1H4(15),m3h2x4(:,88),heltab2x8(:,:,526))
  call Hloop_A_Q(ntryL,G1H4(15),22,0,G2H4(9),n2h4(57))
  call Hloop_QS_A(ntryL,G1H8(10),ex3(:),G1H8(156),ngH,m3h1x8(:,93),heltab2x8(:,:,527))
  call Hloop_Q_A(ntryL,G1H8(156),20,nML,G2H8(21),n2h8(178))
  call Hloop_AS_Q(ntryL,G1H8(110),ex3(:),G1H8(45),ngH,m3h1x8(:,94),heltab2x8(:,:,528))
  call Hloop_A_Q(ntryL,G1H8(45),20,nML,G2H8(22),n2h8(179))
  call Hloop_QS_A(ntryL,G1H8(11),ex3(:),G1H8(158),ngH,m3h1x8(:,95),heltab2x8(:,:,529))
  call Hloop_Q_A(ntryL,G1H8(158),20,nMT,G2H8(23),n2h8(180))
  call Hloop_AS_Q(ntryL,G1H8(15),ex3(:),G1H8(50),ngH,m3h1x8(:,96),heltab2x8(:,:,530))
  call Hloop_A_Q(ntryL,G1H8(50),20,nMT,G2H8(24),n2h8(181))
  call Hloop_QS_A(ntryL,G1H8(112),ex3(:),G1H8(159),ngH,m3h1x8(:,97),heltab2x8(:,:,531))
  call Hloop_Q_A(ntryL,G1H8(159),20,nMB,G2H8(13),n2h8(182))
  call Hloop_AS_Q(ntryL,G1H8(24),ex3(:),G1H8(57),ngH,m3h1x8(:,98),heltab2x8(:,:,532))
  call Hloop_A_Q(ntryL,G1H8(57),20,nMB,G2H8(14),n2h8(183))
  call Hloop_QS_A(ntryL,G1H8(113),ex3(:),G1H8(160),ngH,m3h1x8(:,99),heltab2x8(:,:,533))
  call Hloop_Q_A(ntryL,G1H8(160),20,nML,G2H8(15),n2h8(184))
  call Hloop_AS_Q(ntryL,G1H8(114),ex3(:),G1H8(62),ngH,m3h1x8(:,100),heltab2x8(:,:,534))
  call Hloop_A_Q(ntryL,G1H8(62),20,nML,G2H8(16),n2h8(185))
  call Hloop_QS_A(ntryL,G1H8(33),ex3(:),G1H8(161),ngH,m3h1x8(:,101),heltab2x8(:,:,535))
  call Hloop_Q_A(ntryL,G1H8(161),20,nMT,G2H8(25),n2h8(186))
  call Hloop_AS_Q(ntryL,G1H8(115),ex3(:),G1H8(67),ngH,m3h1x8(:,102),heltab2x8(:,:,536))
  call Hloop_A_Q(ntryL,G1H8(67),20,nMT,G2H8(26),n2h8(187))
  call Hloop_QS_A(ntryL,G1H8(51),ex3(:),G1H8(162),ngH,m3h1x8(:,103),heltab2x8(:,:,537))
  call Hloop_Q_A(ntryL,G1H8(162),20,nMB,G2H8(27),n2h8(188))
  call Hloop_AS_Q(ntryL,G1H8(53),ex3(:),G1H8(74),ngH,m3h1x8(:,104),heltab2x8(:,:,538))
  call Hloop_A_Q(ntryL,G1H8(74),20,nMB,G2H8(28),n2h8(189))
  call Hloop_SS_S(ntryL,G1H8(117),ex3(:),G1H8(163),m3h1x8(:,105),heltab2x8(:,:,539))
  call Hloop_SS_S(ntryL,G1H8(71),ex3(:),G1H8(81),m3h1x8(:,106),heltab2x8(:,:,540))
  call Hloop_SS_S(ntryL,G1H8(118),ex3(:),G1H8(164),m3h1x8(:,107),heltab2x8(:,:,541))
  call Hloop_SS_S(ntryL,G1H8(119),ex3(:),G1H8(86),m3h1x8(:,108),heltab2x8(:,:,542))
  call Hloop_SS_S(ntryL,G1H8(120),ex3(:),G1H8(92),m3h1x8(:,109),heltab2x8(:,:,543))
  call Hloop_SS_S(ntryL,G1H8(181),ex3(:),G1H8(100),m3h1x8(:,110),heltab2x8(:,:,544))
  call Hloop_SS_S(ntryL,G1H8(184),ex3(:),G1H8(105),m3h1x8(:,111),heltab2x8(:,:,545))
  call Hloop_SS_S(ntryL,G1H8(185),ex3(:),G1H8(12),m3h1x8(:,112),heltab2x8(:,:,546))
  call Hloop_SS_S(ntryL,G1H8(188),ex3(:),G1H8(111),m3h1x8(:,113),heltab2x8(:,:,547))
  call Hloop_SS_S(ntryL,G1H8(189),ex3(:),G1H8(31),m3h1x8(:,114),heltab2x8(:,:,548))
  call Hloop_VS_V(ntryL,G1H8(190),ex3(:),G1H8(116),m3h1x8(:,115),heltab2x8(:,:,549))
  call Hloop_VS_V(ntryL,G1H8(191),ex3(:),G1H8(72),m3h1x8(:,116),heltab2x8(:,:,550))
  call Hloop_VS_V(ntryL,G1H8(192),ex3(:),G1H8(121),m3h1x8(:,117),heltab2x8(:,:,551))
  call Hloop_VS_V(ntryL,G1H8(193),ex3(:),G1H8(125),m3h1x8(:,118),heltab2x8(:,:,552))
  call Hloop_SS_S(ntryL,G0H8(13),ex3(:),G0H8(17),m3h1x8(:,119),heltab2x8(:,:,553))
  call Hloop_SS_S(ntryL,G0H8(14),ex3(:),G0H8(38),m3h1x8(:,120),heltab2x8(:,:,554))
  call Hloop_SS_S(ntryL,G0H8(66),ex3(:),G0H8(19),m3h1x8(:,121),heltab2x8(:,:,555))
  call Hloop_ST_V(ntryL,G1H8(195),16,ex3(:),4,G2H8(17),m3h1x8(:,122),heltab2x8(:,:,556))
  call Hloop_ST_V(ntryL,G1H8(196),16,ex3(:),4,G2H8(18),m3h1x8(:,123),heltab2x8(:,:,557))
  call Hloop_ST_V(ntryL,G1H8(198),16,ex3(:),4,G2H8(19),m3h1x8(:,124),heltab2x8(:,:,558))
  call Hloop_VT_S(ntryL,G0H8(67),16,ex3(:),4,G1H8(129),m3h1x8(:,125),heltab2x8(:,:,559))
  call Hloop_VT_S(ntryL,G0H8(68),16,ex3(:),4,G1H8(131),m3h1x8(:,126),heltab2x8(:,:,560))
  call Hloop_VT_S(ntryL,G0H8(69),16,ex3(:),4,G1H8(133),m3h1x8(:,127),heltab2x8(:,:,561))
  call Hloop_VT_S(ntryL,G0H8(70),16,ex3(:),4,G1H8(136),m3h1x8(:,128),heltab2x8(:,:,562))
  call Hloop_VT_S(ntryL,G0H8(71),16,ex3(:),4,G1H8(139),m3h1x8(:,129),heltab2x8(:,:,563))
  call Hloop_ST_V(ntryL,G0H8(72),16,ex3(:),4,G1H8(141),m3h1x8(:,130),heltab2x8(:,:,564))
  call Hloop_ST_V(ntryL,G0H8(73),16,ex3(:),4,G1H8(143),m3h1x8(:,131),heltab2x8(:,:,565))
  call Hloop_ST_V(ntryL,G0H8(84),16,ex3(:),4,G1H8(145),m3h1x8(:,132),heltab2x8(:,:,566))
  call Hloop_ST_V(ntryL,G0H8(86),16,ex3(:),4,G1H8(147),m3h1x8(:,133),heltab2x8(:,:,567))
  call Hloop_VT_S(ntryL,G1H8(200),16,ex3(:),4,G2H8(20),m3h1x8(:,134),heltab2x8(:,:,568))
  call Hloop_VT_S(ntryL,G1H8(202),16,ex3(:),4,G2H8(1),m3h1x8(:,135),heltab2x8(:,:,569))
  call Hloop_VS_V(ntryL,G0H8(97),ex3(:),G0H8(39),m3h1x8(:,136),heltab2x8(:,:,570))
  call Hloop_VS_V(ntryL,G0H8(98),ex3(:),G0H8(21),m3h1x8(:,137),heltab2x8(:,:,571))
  call Hloop_VS_V(ntryL,G0H8(100),ex3(:),G0H8(40),m3h1x8(:,138),heltab2x8(:,:,572))
  call Hloop_QA_Z(ntryL,G1H2(154),ex2(:),G1H1(43),ngZu,m3h2x1(:,320),heltab2x2(:,:,414))
  call Hloop_QA_W(ntryL,G1H2(15),ex2(:),G1H1(44),m3h2x1(:,321),heltab2x2(:,:,415))
  call Hloop_VS_V(ntryL,G0H4(20),ex3(:),G0H4(11),m3h1x4(:,19),heltab2x4(:,:,123))
  call Hloop_VS_V(ntryL,G0H4(21),ex3(:),G0H4(13),m3h1x4(:,20),heltab2x4(:,:,124))
  call Hloop_AQ_V(ntryL,G1H8(206),ex1(:),G1H4(18),m3h2x4(:,89),heltab2x8(:,:,573))
  call Hloop_AQ_Z(ntryL,G1H8(204),ex1(:),G1H4(17),ngZu,m3h2x4(:,90),heltab2x8(:,:,574))
  call Hloop_AQ_W(ntryL,G1H8(205),ex1(:),G1H4(20),m3h2x4(:,91),heltab2x8(:,:,575))
  call Hloop_WQ_A(ntryL,G1H8(207),ex1(:),G1H4(2),m3h2x4(:,92),heltab2x8(:,:,576))
  call Hloop_Q_A(ntryL,G1H4(2),21,0,G2H4(10),n2h4(58))
  call Hloop_QS_A(ntryL,G1H8(208),ex3(:),G1H8(149),ngH,m3h1x8(:,139),heltab2x8(:,:,577))
  call Hloop_Q_A(ntryL,G1H8(149),20,nML,G2H8(2),n2h8(190))
  call Hloop_AS_Q(ntryL,G1H8(209),ex3(:),G1H8(8),ngH,m3h1x8(:,140),heltab2x8(:,:,578))
  call Hloop_A_Q(ntryL,G1H8(8),20,nML,G2H8(3),n2h8(191))
  call Hloop_QS_A(ntryL,G1H8(210),ex3(:),G1H8(9),ngH,m3h1x8(:,141),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H8(9),20,nMT,G2H8(4),n2h8(192))
  call Hloop_AS_Q(ntryL,G1H8(211),ex3(:),G1H8(26),ngH,m3h1x8(:,142),heltab2x8(:,:,580))
  call Hloop_A_Q(ntryL,G1H8(26),20,nMT,G2H8(5),n2h8(193))
  call Hloop_QS_A(ntryL,G1H8(212),ex3(:),G1H8(27),ngH,m3h1x8(:,143),heltab2x8(:,:,581))
  call Hloop_Q_A(ntryL,G1H8(27),20,nMB,G2H8(6),n2h8(194))
  call Hloop_AS_Q(ntryL,G1H8(213),ex3(:),G1H8(155),ngH,m3h1x8(:,144),heltab2x8(:,:,582))
  call Hloop_A_Q(ntryL,G1H8(155),20,nMB,G2H8(7),n2h8(195))
  call Hloop_QS_A(ntryL,G1H8(214),ex3(:),G1H8(127),ngH,m3h1x8(:,145),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H8(127),20,nML,G2H8(8),n2h8(196))
  call Hloop_AS_Q(ntryL,G1H8(215),ex3(:),G1H8(16),ngH,m3h1x8(:,146),heltab2x8(:,:,584))
  call Hloop_A_Q(ntryL,G1H8(16),20,nML,G2H8(9),n2h8(197))
  call Hloop_QS_A(ntryL,G1H8(216),ex3(:),G1H8(135),ngH,m3h1x8(:,147),heltab2x8(:,:,585))
  call Hloop_Q_A(ntryL,G1H8(135),20,nMT,G2H8(10),n2h8(198))
  call Hloop_AS_Q(ntryL,G1H8(217),ex3(:),G1H8(38),ngH,m3h1x8(:,148),heltab2x8(:,:,586))
  call Hloop_A_Q(ntryL,G1H8(38),20,nMT,G2H8(11),n2h8(199))
  call Hloop_QS_A(ntryL,G1H8(218),ex3(:),G1H8(41),ngH,m3h1x8(:,149),heltab2x8(:,:,587))
  call Hloop_Q_A(ntryL,G1H8(41),20,nMB,G2H8(12),n2h8(200))
  call Hloop_AS_Q(ntryL,G1H8(219),ex3(:),G1H8(43),ngH,m3h1x8(:,150),heltab2x8(:,:,588))
  call Hloop_A_Q(ntryL,G1H8(43),20,nMB,G2H8(29),n2h8(201))
  call Hloop_SS_S(ntryL,G1H8(220),ex3(:),G1H8(46),m3h1x8(:,151),heltab2x8(:,:,589))
  call Hloop_SS_S(ntryL,G1H8(221),ex3(:),G1H8(58),m3h1x8(:,152),heltab2x8(:,:,590))
  call Hloop_SS_S(ntryL,G1H8(222),ex3(:),G1H8(59),m3h1x8(:,153),heltab2x8(:,:,591))
  call Hloop_SS_S(ntryL,G1H8(223),ex3(:),G1H8(63),m3h1x8(:,154),heltab2x8(:,:,592))
  call Hloop_SS_S(ntryL,G1H8(224),ex3(:),G1H8(65),m3h1x8(:,155),heltab2x8(:,:,593))
  call Hloop_SS_S(ntryL,G1H8(225),ex3(:),G1H8(89),m3h1x8(:,156),heltab2x8(:,:,594))
  call Hloop_SS_S(ntryL,G1H8(228),ex3(:),G1H8(90),m3h1x8(:,157),heltab2x8(:,:,595))
  call Hloop_SS_S(ntryL,G1H8(229),ex3(:),G1H8(101),m3h1x8(:,158),heltab2x8(:,:,596))
  call Hloop_SS_S(ntryL,G1H8(232),ex3(:),G1H8(103),m3h1x8(:,159),heltab2x8(:,:,597))
  call Hloop_SS_S(ntryL,G1H8(233),ex3(:),G1H8(106),m3h1x8(:,160),heltab2x8(:,:,598))
  call Hloop_VS_V(ntryL,G1H8(234),ex3(:),G1H8(182),m3h1x8(:,161),heltab2x8(:,:,599))
  call Hloop_VS_V(ntryL,G1H8(235),ex3(:),G1H8(183),m3h1x8(:,162),heltab2x8(:,:,600))
  call Hloop_VS_V(ntryL,G1H8(236),ex3(:),G1H8(186),m3h1x8(:,163),heltab2x8(:,:,601))
  call Hloop_VS_V(ntryL,G1H8(237),ex3(:),G1H8(187),m3h1x8(:,164),heltab2x8(:,:,602))
  call Hloop_SS_S(ntryL,G0H8(106),ex3(:),G0H8(55),m3h1x8(:,165),heltab2x8(:,:,603))
  call Hloop_SS_S(ntryL,G0H8(3),ex3(:),G0H8(41),m3h1x8(:,166),heltab2x8(:,:,604))
  call Hloop_SS_S(ntryL,G0H8(23),ex3(:),G0H8(81),m3h1x8(:,167),heltab2x8(:,:,605))
  call Hloop_ST_V(ntryL,G1H8(239),16,ex3(:),4,G2H8(30),m3h1x8(:,168),heltab2x8(:,:,606))
  call Hloop_ST_V(ntryL,G1H8(240),16,ex3(:),4,G2H8(31),m3h1x8(:,169),heltab2x8(:,:,607))
  call Hloop_ST_V(ntryL,G1H8(242),16,ex3(:),4,G2H8(32),m3h1x8(:,170),heltab2x8(:,:,608))
  call Hloop_VT_S(ntryL,G0H8(9),16,ex3(:),4,G1H8(194),m3h1x8(:,171),heltab2x8(:,:,609))
  call Hloop_VT_S(ntryL,G0H8(10),16,ex3(:),4,G1H8(197),m3h1x8(:,172),heltab2x8(:,:,610))
  call Hloop_VT_S(ntryL,G0H8(11),16,ex3(:),4,G1H8(199),m3h1x8(:,173),heltab2x8(:,:,611))
  call Hloop_VT_S(ntryL,G0H8(101),16,ex3(:),4,G1H8(201),m3h1x8(:,174),heltab2x8(:,:,612))
  call Hloop_VT_S(ntryL,G0H8(102),16,ex3(:),4,G1H8(203),m3h1x8(:,175),heltab2x8(:,:,613))
  call Hloop_ST_V(ntryL,G0H8(103),16,ex3(:),4,G1H8(226),m3h1x8(:,176),heltab2x8(:,:,614))
  call Hloop_ST_V(ntryL,G0H8(104),16,ex3(:),4,G1H8(227),m3h1x8(:,177),heltab2x8(:,:,615))
  call Hloop_ST_V(ntryL,G0H8(108),16,ex3(:),4,G1H8(230),m3h1x8(:,178),heltab2x8(:,:,616))
  call Hloop_ST_V(ntryL,G0H8(109),16,ex3(:),4,G1H8(231),m3h1x8(:,179),heltab2x8(:,:,617))
  call Hloop_VT_S(ntryL,G1H8(244),16,ex3(:),4,G2H8(33),m3h1x8(:,180),heltab2x8(:,:,618))
  call Hloop_VT_S(ntryL,G1H8(246),16,ex3(:),4,G2H8(34),m3h1x8(:,181),heltab2x8(:,:,619))
  call Hloop_VS_V(ntryL,G0H8(111),ex3(:),G0H8(42),m3h1x8(:,182),heltab2x8(:,:,620))
  call Hloop_VS_V(ntryL,G0H8(112),ex3(:),G0H8(83),m3h1x8(:,183),heltab2x8(:,:,621))
  call Hloop_VS_V(ntryL,G0H8(114),ex3(:),G0H8(43),m3h1x8(:,184),heltab2x8(:,:,622))
  call Hloop_AQ_Z(ntryL,G1H2(182),ex1(:),G1H1(35),ngZu,m3h2x1(:,322),heltab2x2(:,:,416))
  call Hloop_AQ_W(ntryL,G1H2(185),ex1(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,417))
  call Hloop_VA_Q(ntryL,G0H4(25),ex2(:),G0H2(11),m3h2x2(:,83),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G0H2(11),23,0,G1H2(11),n2h2(239))
  call Hloop_ZA_Q(ntryL,G0H4(23),ex2(:),G0H2(1),ngZu,m3h2x2(:,84),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(105),n2h2(240))
  call Hloop_WA_Q(ntryL,G0H4(24),ex2(:),G0H2(3),m3h2x2(:,85),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G0H2(3),23,0,G1H2(114),n2h2(241))
  call Hloop_QA_W(ntryL,G1H4(7),ex2(:),G1H2(119),m3h2x2(:,86),heltab2x4(:,:,128))
  call Hloop_VQ_A(ntryL,G0H4(29),ex1(:),G0H2(9),m3h2x2(:,87),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G0H2(9),23,0,G1H2(57),n2h2(242))
  call Hloop_ZQ_A(ntryL,G0H4(27),ex1(:),G0H2(14),ngZu,m3h2x2(:,88),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G0H2(14),23,0,G1H2(186),n2h2(243))
  call Hloop_WQ_A(ntryL,G0H4(28),ex1(:),G0H2(16),m3h2x2(:,89),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G0H2(16),23,0,G1H2(63),n2h2(244))
  call Hloop_AQ_W(ntryL,G1H4(11),ex1(:),G1H2(189),m3h2x2(:,90),heltab2x4(:,:,132))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(109)])
call HGT_w2_OLR(G1H2(111),1,1,2)
call HGT_w2_invQ_OLR(G1H2(111),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(2),[G0H1(1)])
call HGT_w2_OLR(G1H1(26),1,1,1)
call HGT_w2_invQ_OLR(G1H1(26),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(26),[G0H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(132),G2H2(129),G2H2(126),G2H2(123),G2H2(19) &
    ,G1H2(10),G1H2(54),G1H2(125),G1H2(108),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(10),G1H2(107),G1H2(37),G1H2(95),G1H2(136)])
call HGT_lower_alpha_OLR(G1H2(110),1,1,2)
call HGT_lower_alpha_invQ_OLR(G1H2(110),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(23),[G2H1(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(14),G1H2(133),G1H2(115),G1H2(142),G1H2(140)])
call HGT_lower_alpha_OLR(G1H2(4),1,1,2)
call HGT_lower_alpha_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(12),G1H2(171)])
call HGT_OLR(G2H2(47),1,1,2)
call HGT_invQ_OLR(G2H2(47),2,5,2)
call HGT_OLR(G2H2(47),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(26),[G1H1(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(13),G1H2(175)])
call HGT_OLR(G2H2(49),1,1,2)
call HGT_invQ_OLR(G2H2(49),2,5,2)
call HGT_OLR(G2H2(49),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(29),[G1H1(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(58),G1H2(179)])
call HGT_OLR(G2H2(51),1,1,2)
call HGT_invQ_OLR(G2H2(51),2,5,2)
call HGT_OLR(G2H2(51),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(32),[G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(54),G1H2(183)])
call HGT_OLR(G2H2(55),1,1,2)
call HGT_invQ_OLR(G2H2(55),2,5,2)
call HGT_OLR(G2H2(55),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(35),[G1H1(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(4),G1H2(187)])
call HGT_OLR(G2H2(59),1,1,2)
call HGT_invQ_OLR(G2H2(59),2,5,2)
call HGT_OLR(G2H2(59),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(38),[G1H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(15),G1H2(191)])
call HGT_OLR(G2H2(63),1,1,2)
call HGT_invQ_OLR(G2H2(63),2,5,2)
call HGT_OLR(G2H2(63),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(41),[G1H1(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G2H2(142),G1H2(106),G1H2(135),G1H2(77)])
call HGT_OLR(G1H2(16),1,1,2)
call HGT_invQ_OLR(G1H2(16),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(47),[G2H1(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G2H2(139),G1H2(30),G1H2(128),G1H2(104)])
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(91),G1H2(9)])
call HGT_OLR(G1H2(25),1,1,2)
call HGT_invQ_OLR(G1H2(25),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(92),G1H2(34)])
call HGT_OLR(G1H2(59),1,1,2)
call HGT_invQ_OLR(G1H2(59),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(17),G2H2(108),G2H2(90),G2H2(40),G1H2(176) &
    ,G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(35),G2H2(105),G2H2(87),G2H2(56),G1H2(172) &
    ,G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(33),G2H2(114),G2H2(96),G2H2(52),G1H2(184) &
    ,G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(72),G2H2(111),G2H2(93),G2H2(75),G1H2(180) &
    ,G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(34),G2H2(120),G2H2(102),G2H2(78),G1H2(192) &
    ,G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(39),G2H2(117),G2H2(99),G2H2(81),G1H2(188) &
    ,G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(4),[G0H1(3)])
call HGT_lower_alpha_w2_OLR(G1H1(10),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G1H1(10),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(10),[G0H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(144),G2H2(141),G2H2(138),G2H2(135),G2H2(84) &
    ,G1H2(23),G1H2(47),G1H2(127),G1H2(45),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(162),G1H2(121),G1H2(144),G0H2(8),G0H2(26) &
    ,G0H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(153),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(13),G1H2(100),G1H2(89),G0H2(22),G0H2(27) &
    ,G0H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(112),G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(1),G1H2(21),G1H2(98),G0H2(24),G0H2(20) &
    ,G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(66),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(32),G1H2(130),G1H2(113),G0H2(7),G0H2(5) &
    ,G0H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(82),G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(157),G1H2(39),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(131),[G1H2(26),G1H2(2),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(127),[G2H2(103),G2H2(100),G2H2(97),G1H2(17),G1H2(150) &
    ,G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(186),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(130),G2H2(101),G2H2(98),G1H2(51),G1H2(40) &
    ,G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(105),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(5),[G1H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(46),[G1H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(22),[G1H1(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(24),[G1H1(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(25),[G1H1(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G2H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(14),[G2H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(128),G2H2(44),G2H2(43),G1H2(49),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(88),G2H2(86),G2H2(122),G1H2(71),G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(153),[G1H8(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(154),[G1H8(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(19),[G1H1(39),G1H1(17),G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(23),[G1H1(40),G1H1(34),G1H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(174),[G1H2(143),G1H2(139),G1H2(118),G1H2(116) &
    ,G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(46),G1H2(124),G1H2(56),G1H2(138),G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G2H2(21),G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(2),G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(129),[G1H8(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(131),[G1H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(136),[G1H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(141),[G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(143),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(147),[G1H8(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G0H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(194),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(197),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(199),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(201),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(203),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(226),[G1H8(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(227),[G1H8(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(230),[G1H8(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(231),[G1H8(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G0H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G0H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G0H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G0H8(43)])
  call Hloop_QV_A(ntryL,G1H2(111),ex4(:),G1H1(25),m3h2x1(:,324),heltab2x2(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,0,G2tensor(19),n2h1(209))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(2),m3h2x1(:,325),heltab2x2(:,:,419))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(26),27,ex3(:),4,G2tensor(28),m3h1x1(:,97),heltab2x1(:,:,97))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(70),ex4(:),G2tensor(4),m3h2x1(:,326),heltab2x2(:,:,420))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(8),23,ex4(:),8,G3tensor(19),m3h2x1(:,327),heltab2x2(:,:,421))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(23),ex3(:),G2tensor(6),m3h1x1(:,98),heltab2x1(:,:,98))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(18),23,ex4(:),8,G3tensor(20),m3h2x1(:,328),heltab2x2(:,:,422))
  call Hloop_QV_A(ntryL,G2H2(47),ex4(:),G2H1(8),m3h2x1(:,329),heltab2x2(:,:,423))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),31,nML,G3tensor(21),n2h1(210))
  call Hloop_QS_A(ntryL,G2H1(26),ex3(:),G2H1(31),ngH,m3h1x1(:,99),heltab2x1(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(31),31,nML,G3tensor(22),n2h1(211))
  call Hloop_AV_Q(ntryL,G2H2(49),ex4(:),G2H1(33),m3h2x1(:,330),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(33),31,nML,G3tensor(23),n2h1(212))
  call Hloop_AS_Q(ntryL,G2H1(29),ex3(:),G2H1(17),ngH,m3h1x1(:,100),heltab2x1(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),31,nML,G3tensor(24),n2h1(213))
  call Hloop_QV_A(ntryL,G2H2(51),ex4(:),G2H1(34),m3h2x1(:,331),heltab2x2(:,:,425))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(34),31,nMT,G3tensor(25),n2h1(214))
  call Hloop_QS_A(ntryL,G2H1(32),ex3(:),G2H1(36),ngH,m3h1x1(:,101),heltab2x1(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(36),31,nMT,G3tensor(26),n2h1(215))
  call Hloop_AV_Q(ntryL,G2H2(55),ex4(:),G2H1(11),m3h2x1(:,332),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),31,nMT,G3tensor(27),n2h1(216))
  call Hloop_AS_Q(ntryL,G2H1(35),ex3(:),G2H1(37),ngH,m3h1x1(:,102),heltab2x1(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(37),31,nMT,G3tensor(28),n2h1(217))
  call Hloop_QV_A(ntryL,G2H2(59),ex4(:),G2H1(39),m3h2x1(:,333),heltab2x2(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(39),31,nMB,G3tensor(29),n2h1(218))
  call Hloop_QS_A(ntryL,G2H1(38),ex3(:),G2H1(9),ngH,m3h1x1(:,103),heltab2x1(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMB,G3tensor(30),n2h1(219))
  call Hloop_AV_Q(ntryL,G2H2(63),ex4(:),G2H1(40),m3h2x1(:,334),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(40),31,nMB,G3tensor(31),n2h1(220))
  call Hloop_AS_Q(ntryL,G2H1(41),ex3(:),G2H1(42),ngH,m3h1x1(:,104),heltab2x1(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(42),31,nMB,G3tensor(32),n2h1(221))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(136),23,ex4(:),8,G3tensor(33),m3h2x1(:,335),heltab2x2(:,:,429))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(47),ex3(:),G2tensor(8),m3h1x1(:,105),heltab2x1(:,:,105))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(143),23,ex4(:),8,G3tensor(34),m3h2x1(:,336),heltab2x2(:,:,430))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(94),23,ex4(:),8,G3tensor(35),m3h2x1(:,337),heltab2x2(:,:,431))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(50),ex3(:),G2tensor(31),m3h1x1(:,106),heltab2x1(:,:,106))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(95),23,ex4(:),G3tensor(36),m3h2x1(:,338),heltab2x2(:,:,432))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(53),ex3(:),G2tensor(25),m3h1x1(:,107),heltab2x1(:,:,107))
call HGT_OLR(G2H1(55),1,1,1)
call HGT_invQ_OLR(G2H1(55),2,5,1)
call HGT_OLR(G2H1(55),6,15,1)
  call Hloop_AS_Q(ntryL,G2H1(55),ex3(:),G2H1(7),ngH,m3h1x1(:,108),heltab2x1(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nML,G3tensor(37),n2h1(222))
  call Hloop_AV_Q(ntryL,G2H2(30),ex4(:),G2H1(48),m3h2x1(:,339),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(48),31,nML,G3tensor(38),n2h1(223))
call HGT_OLR(G2H1(56),1,1,1)
call HGT_invQ_OLR(G2H1(56),2,5,1)
call HGT_OLR(G2H1(56),6,15,1)
  call Hloop_QS_A(ntryL,G2H1(56),ex3(:),G2H1(49),ngH,m3h1x1(:,109),heltab2x1(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(49),31,nML,G3tensor(39),n2h1(224))
  call Hloop_QV_A(ntryL,G2H2(20),ex4(:),G2H1(51),m3h2x1(:,340),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(51),31,nML,G3tensor(40),n2h1(225))
call HGT_OLR(G2H1(57),1,1,1)
call HGT_invQ_OLR(G2H1(57),2,5,1)
call HGT_OLR(G2H1(57),6,15,1)
  call Hloop_AS_Q(ntryL,G2H1(57),ex3(:),G2H1(52),ngH,m3h1x1(:,110),heltab2x1(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(52),31,nMT,G3tensor(41),n2h1(226))
  call Hloop_AV_Q(ntryL,G2H2(1),ex4(:),G2H1(54),m3h2x1(:,341),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(54),31,nMT,G3tensor(42),n2h1(227))
call HGT_OLR(G2H1(58),1,1,1)
call HGT_invQ_OLR(G2H1(58),2,5,1)
call HGT_OLR(G2H1(58),6,15,1)
  call Hloop_QS_A(ntryL,G2H1(58),ex3(:),G2H1(13),ngH,m3h1x1(:,111),heltab2x1(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,nMT,G3tensor(43),n2h1(228))
  call Hloop_QV_A(ntryL,G2H2(11),ex4(:),G2H1(10),m3h2x1(:,342),heltab2x2(:,:,436))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(44),n2h1(229))
call HGT_OLR(G2H1(59),1,1,1)
call HGT_invQ_OLR(G2H1(59),2,5,1)
call HGT_OLR(G2H1(59),6,15,1)
  call Hloop_AS_Q(ntryL,G2H1(59),ex3(:),G2H1(43),ngH,m3h1x1(:,112),heltab2x1(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(43),31,nMB,G3tensor(45),n2h1(230))
  call Hloop_AV_Q(ntryL,G2H2(16),ex4(:),G2H1(19),m3h2x1(:,343),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(19),31,nMB,G3tensor(46),n2h1(231))
call HGT_OLR(G2H1(60),1,1,1)
call HGT_invQ_OLR(G2H1(60),2,5,1)
call HGT_OLR(G2H1(60),6,15,1)
  call Hloop_QS_A(ntryL,G2H1(60),ex3(:),G2H1(21),ngH,m3h1x1(:,113),heltab2x1(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(21),31,nMB,G3tensor(47),n2h1(232))
  call Hloop_QV_A(ntryL,G2H2(67),ex4(:),G2H1(45),m3h2x1(:,344),heltab2x2(:,:,438))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(45),31,nMB,G3tensor(48),n2h1(233))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(10),27,ex3(:),4,G2tensor(22),m3h1x1(:,114),heltab2x1(:,:,114))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(12),m3h2x1(:,345),heltab2x2(:,:,439))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,17),G2H1(16),m3h4x1(:,23),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nML,G3tensor(49),n2h1(234))
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(8),wf4(:,17),G2H1(18),m3h4x1(:,24),heltab2x4(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nML,G3tensor(50),n2h1(235))
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(7),wf4(:,17),G2H1(12),m3h4x1(:,25),heltab2x4(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),31,nMT,G3tensor(51),n2h1(236))
call HGT_OLR(G2H4(11),1,1,4)
call HGT_invQ_OLR(G2H4(11),2,5,4)
call HGT_OLR(G2H4(11),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(11),wf4(:,17),G2H1(15),m3h4x1(:,26),heltab2x4(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),31,nMT,G3tensor(52),n2h1(237))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,17),G2H1(1),m3h4x1(:,27),heltab2x4(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(53),n2h1(238))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,17),G2H1(2),m3h4x1(:,28),heltab2x4(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),31,nMB,G3tensor(54),n2h1(239))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(3),wf4(:,18),G2H1(20),ngZl,m3h4x1(:,29),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),31,nML,G3tensor(55),n2h1(240))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(5),wf4(:,18),G2H1(44),ngZl,m3h4x1(:,30),heltab2x4(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(44),31,nML,G3tensor(56),n2h1(241))
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(6),wf4(:,18),G2H1(3),ngZu,m3h4x1(:,31),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),31,nMT,G3tensor(57),n2h1(242))
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(12),wf4(:,18),G2H1(27),ngZu,m3h4x1(:,32),heltab2x4(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(27),31,nMT,G3tensor(58),n2h1(243))
call HGT_OLR(G2H4(13),1,1,4)
call HGT_invQ_OLR(G2H4(13),2,5,4)
call HGT_OLR(G2H4(13),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(13),wf4(:,18),G2H1(23),ngZd,m3h4x1(:,33),heltab2x4(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMB,G3tensor(59),n2h1(244))
call HGT_OLR(G2H4(14),1,1,4)
call HGT_invQ_OLR(G2H4(14),2,5,4)
call HGT_OLR(G2H4(14),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(14),wf4(:,18),G2H1(8),ngZd,m3h4x1(:,34),heltab2x4(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),31,nMB,G3tensor(60),n2h1(245))
call HGT_w2_OLR(G1H4(16),1,1,4)
call HGT_w2_invQ_OLR(G1H4(16),2,5,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(16),28,wf4(:,17),3,G2tensor(10),m3h4x1(:,35),heltab2x4(:,:,145))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(4),28,wf4(:,17),3,G2tensor(43),m3h4x1(:,36),heltab2x4(:,:,146))
call HGT_w2_OLR(G1H4(13),1,1,4)
call HGT_w2_invQ_OLR(G1H4(13),2,5,4)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(13),28,wf4(:,18),3,G2tensor(40),m3h4x1(:,37),heltab2x4(:,:,147))
call HGT_w2_OLR(G1H4(8),1,1,4)
call HGT_w2_invQ_OLR(G1H4(8),2,5,4)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(8),28,wf4(:,18),3,G2tensor(37),m3h4x1(:,38),heltab2x4(:,:,148))
call HGT_lower_alpha_w2_OLR(G1H4(1),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(1),28,wf4(:,17),3,G2tensor(16),m3h4x1(:,39),heltab2x4(:,:,149))
call HGT_lower_alpha_w2_OLR(G1H4(21),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(21),2,5,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(21),28,wf4(:,17),3,G2tensor(14),m3h4x1(:,40),heltab2x4(:,:,150))
call HGT_lower_alpha_w2_OLR(G1H4(3),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(3),2,5,4)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(3),28,wf4(:,18),3,G2tensor(18),m3h4x1(:,41),heltab2x4(:,:,151))
call HGT_lower_alpha_w2_OLR(G1H4(5),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(5),2,5,4)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(5),28,wf4(:,18),3,G2tensor(24),m3h4x1(:,42),heltab2x4(:,:,152))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(189),23,ex4(:),8,G2tensor(21),m3h2x1(:,346),heltab2x2(:,:,440))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(119),23,ex4(:),8,G2tensor(27),m3h2x1(:,347),heltab2x2(:,:,441))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(31),23,ex4(:),8,G3tensor(61),m3h2x1(:,348),heltab2x2(:,:,442))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(9),23,ex4(:),8,G3tensor(62),m3h2x1(:,349),heltab2x2(:,:,443))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(66),23,ex4(:),8,G3tensor(63),m3h2x1(:,350),heltab2x2(:,:,444))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(6),23,ex4(:),8,G3tensor(64),m3h2x1(:,351),heltab2x2(:,:,445))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(32),23,ex4(:),8,G3tensor(65),m3h2x1(:,352),heltab2x2(:,:,446))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(6),27,ex3(:),4,G2tensor(103),m3h1x1(:,115),heltab2x1(:,:,115))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(18),27,ex3(:),4,G2tensor(33),m3h1x1(:,116),heltab2x1(:,:,116))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(31),27,ex3(:),4,G2tensor(30),m3h1x1(:,117),heltab2x1(:,:,117))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(14),27,ex3(:),4,G2tensor(39),m3h1x1(:,118),heltab2x1(:,:,118))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(5),23,ex4(:),8,G3tensor(66),m3h2x1(:,353),heltab2x2(:,:,447))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(45),23,ex4(:),8,G3tensor(67),m3h2x1(:,354),heltab2x2(:,:,448))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(7),23,ex4(:),8,G3tensor(68),m3h2x1(:,355),heltab2x2(:,:,449))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(36),23,ex4(:),G2tensor(36),m3h2x1(:,356),heltab2x2(:,:,450))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(46),23,ex4(:),G3tensor(69),m3h2x1(:,357),heltab2x2(:,:,451))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(41),23,ex4(:),8,G2tensor(102),m3h2x1(:,358),heltab2x2(:,:,452))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(131),23,ex4(:),8,G3tensor(70),m3h2x1(:,359),heltab2x2(:,:,453))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(5),m3h2x1(:,360),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),31,0,G2tensor(45),n2h1(246))
  call Hloop_QV_A(ntryL,G2H2(127),ex4(:),G2H1(26),m3h2x1(:,361),heltab2x2(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(26),31,0,G3tensor(71),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(186),ex4(:),G1H1(32),m3h2x1(:,362),heltab2x2(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(32),31,0,G2tensor(42),n2h1(248))
  call Hloop_AV_Q(ntryL,G1H2(11),ex4(:),G1H1(7),m3h2x1(:,363),heltab2x2(:,:,457))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),31,0,G2tensor(49),n2h1(249))
  call Hloop_AV_Q(ntryL,G2H2(124),ex4(:),G2H1(31),m3h2x1(:,364),heltab2x2(:,:,458))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(31),31,0,G3tensor(72),n2h1(250))
  call Hloop_AV_Q(ntryL,G1H2(105),ex4(:),G1H1(2),m3h2x1(:,365),heltab2x2(:,:,459))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,0,G2tensor(52),n2h1(251))
  call Hloop_AV_Q(ntryL,G1H2(114),ex4(:),G1H1(30),m3h2x1(:,366),heltab2x2(:,:,460))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,0,G2tensor(54),n2h1(252))
  call Hloop_WA_Q(ntryL,G1H2(151),ex2(:),G1H1(4),m3h2x1(:,367),heltab2x2(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),31,0,G2tensor(58),n2h1(253))
  call Hloop_WA_Q(ntryL,G1H2(62),ex2(:),G1H1(24),m3h2x1(:,368),heltab2x2(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,0,G2tensor(64),n2h1(254))
  call Hloop_QS_A(ntryL,G2H1(5),ex3(:),G2H1(33),ngH,m3h1x1(:,119),heltab2x1(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(33),31,nML,G3tensor(73),n2h1(255))
  call Hloop_AS_Q(ntryL,G2H1(6),ex3(:),G2H1(29),ngH,m3h1x1(:,120),heltab2x1(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(29),31,nML,G3tensor(74),n2h1(256))
  call Hloop_QS_A(ntryL,G2H1(46),ex3(:),G2H1(17),ngH,m3h1x1(:,121),heltab2x1(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(17),31,nMT,G3tensor(75),n2h1(257))
  call Hloop_AS_Q(ntryL,G2H1(22),ex3(:),G2H1(34),ngH,m3h1x1(:,122),heltab2x1(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(34),31,nMT,G3tensor(76),n2h1(258))
  call Hloop_QS_A(ntryL,G2H1(24),ex3(:),G2H1(32),ngH,m3h1x1(:,123),heltab2x1(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(32),31,nMB,G3tensor(77),n2h1(259))
  call Hloop_AS_Q(ntryL,G2H1(25),ex3(:),G2H1(36),ngH,m3h1x1(:,124),heltab2x1(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(36),31,nMB,G3tensor(78),n2h1(260))
  call Hloop_AV_Q(ntryL,G2H2(134),ex4(:),G2H1(11),m3h2x1(:,369),heltab2x2(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),31,nML,G3tensor(79),n2h1(261))
  call Hloop_QV_A(ntryL,G2H2(27),ex4(:),G2H1(35),m3h2x1(:,370),heltab2x2(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(35),31,nML,G3tensor(80),n2h1(262))
  call Hloop_AV_Q(ntryL,G2H2(24),ex4(:),G2H1(37),m3h2x1(:,371),heltab2x2(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(37),31,nMT,G3tensor(81),n2h1(263))
  call Hloop_QV_A(ntryL,G2H2(65),ex4(:),G2H1(39),m3h2x1(:,372),heltab2x2(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(39),31,nMT,G3tensor(82),n2h1(264))
  call Hloop_AV_Q(ntryL,G2H2(57),ex4(:),G2H1(38),m3h2x1(:,373),heltab2x2(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(38),31,nMB,G3tensor(83),n2h1(265))
  call Hloop_QV_A(ntryL,G2H2(53),ex4(:),G2H1(9),m3h2x1(:,374),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),31,nMB,G3tensor(84),n2h1(266))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(140),ex2(:),G2tensor(61),m3h2x1(:,375),heltab2x2(:,:,469))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(137),ex4(:),G2tensor(5),m3h2x1(:,376),heltab2x2(:,:,470))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(4),ex3(:),G2tensor(1),m3h1x1(:,125),heltab2x1(:,:,125))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(14),ex3(:),G2tensor(63),m3h1x1(:,126),heltab2x1(:,:,126))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(28),ex3(:),G2tensor(66),m3h1x1(:,127),heltab2x1(:,:,127))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(30),ex3(:),G2tensor(44),m3h1x1(:,128),heltab2x1(:,:,128))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(32),m3h2x1(:,377),heltab2x2(:,:,471))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(125),ex4(:),G2tensor(69),m3h2x1(:,378),heltab2x2(:,:,472))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(89),ex4(:),G2tensor(177),m3h2x1(:,379),heltab2x2(:,:,473))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(153),ex4(:),wf4(:,17),G1tensor(25),m4h2x4x1(:,1),heltab3x8(:,:,13))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(35),ex4(:),wf4(:,18),G1tensor(55),m4h2x4x1(:,2),heltab3x8(:,:,14))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(154),ex4(:),wf4(:,17),G1tensor(30),m4h2x4x1(:,3),heltab3x8(:,:,15))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(40),ex4(:),wf4(:,18),G1tensor(12),m4h2x4x1(:,4),heltab3x8(:,:,16))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(19),ex3(:),G1tensor(26),m3h1x1(:,129),heltab2x1(:,:,129))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(23),ex3(:),G1tensor(8),m3h1x1(:,130),heltab2x1(:,:,130))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H2(174),ex4(:),ex3(:),G1tensor(50),m4h2x1x1(:,3),heltab3x2(:,:,3))
  call Hcheck_last_SSV_V(ntryL,l_switch,G1H2(173),ex3(:),ex4(:),G1tensor(62),m4h1x2x1(:,1),heltab3x2(:,:,4))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(94),ex2(:),G1tensor(74),m3h2x1(:,380),heltab2x2(:,:,474))
  call Hloop_AV_Q(ntryL,G2H2(25),ex4(:),G2H1(40),m3h2x1(:,381),heltab2x2(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(40),31,0,G3tensor(85),n2h1(267))
  call Hloop_QV_A(ntryL,G2H2(83),ex4(:),G2H1(41),m3h2x1(:,382),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(41),31,0,G3tensor(86),n2h1(268))
  call Hloop_ZQ_A(ntryL,G0H4(30),wf4(:,2),G0H1(1),ngZu,m3h4x1(:,43),heltab2x4(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(84),n2h1(269))
  call Hloop_WQ_A(ntryL,G0H4(9),wf4(:,2),G0H1(2),m3h4x1(:,44),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(2),31,0,G1tensor(10),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H4(12),wf4(:,2),G1H1(29),m3h4x1(:,45),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),31,0,G2tensor(174),n2h1(271))
  call Hloop_ZQ_A(ntryL,G1H4(6),wf4(:,2),G1H1(22),ngZu,m3h4x1(:,46),heltab2x4(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,0,G2tensor(171),n2h1(272))
  call Hloop_WQ_A(ntryL,G1H4(14),wf4(:,2),G1H1(11),m3h4x1(:,47),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(11),31,0,G2tensor(159),n2h1(273))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(9),wf4(:,2),G2tensor(156),m3h4x1(:,48),heltab2x4(:,:,158))
  call Hloop_QV_A(ntryL,G2H8(21),wf8(:,3),G2H1(42),m3h8x1(:,1),heltab2x8(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(42),31,nML,G3tensor(87),n2h1(274))
  call Hloop_AV_Q(ntryL,G2H8(22),wf8(:,3),G2H1(47),m3h8x1(:,2),heltab2x8(:,:,624))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(47),31,nML,G3tensor(88),n2h1(275))
  call Hloop_QV_A(ntryL,G2H8(23),wf8(:,3),G2H1(50),m3h8x1(:,3),heltab2x8(:,:,625))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(50),31,nMT,G3tensor(89),n2h1(276))
  call Hloop_AV_Q(ntryL,G2H8(24),wf8(:,3),G2H1(53),m3h8x1(:,4),heltab2x8(:,:,626))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(53),31,nMT,G3tensor(90),n2h1(277))
  call Hloop_QV_A(ntryL,G2H8(13),wf8(:,3),G2H1(55),m3h8x1(:,5),heltab2x8(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(55),31,nMB,G3tensor(91),n2h1(278))
  call Hloop_AV_Q(ntryL,G2H8(14),wf8(:,3),G2H1(7),m3h8x1(:,6),heltab2x8(:,:,628))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),31,nMB,G3tensor(92),n2h1(279))
  call Hloop_QZ_A(ntryL,G2H8(15),wf8(:,1),G2H1(48),ngZl,m3h8x1(:,7),heltab2x8(:,:,629))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(48),31,nML,G3tensor(93),n2h1(280))
  call Hloop_AZ_Q(ntryL,G2H8(16),wf8(:,1),G2H1(56),ngZl,m3h8x1(:,8),heltab2x8(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(56),31,nML,G3tensor(94),n2h1(281))
  call Hloop_QZ_A(ntryL,G2H8(25),wf8(:,1),G2H1(49),ngZu,m3h8x1(:,9),heltab2x8(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(49),31,nMT,G3tensor(95),n2h1(282))
  call Hloop_AZ_Q(ntryL,G2H8(26),wf8(:,1),G2H1(51),ngZu,m3h8x1(:,10),heltab2x8(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(51),31,nMT,G3tensor(96),n2h1(283))
  call Hloop_QZ_A(ntryL,G2H8(27),wf8(:,1),G2H1(57),ngZd,m3h8x1(:,11),heltab2x8(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(57),31,nMB,G3tensor(97),n2h1(284))
  call Hloop_AZ_Q(ntryL,G2H8(28),wf8(:,1),G2H1(52),ngZd,m3h8x1(:,12),heltab2x8(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(52),31,nMB,G3tensor(98),n2h1(285))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(129),20,wf8(:,3),11,G2tensor(109),m3h8x1(:,13),heltab2x8(:,:,635))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H8(131),20,wf8(:,3),11,G2tensor(108),m3h8x1(:,14),heltab2x8(:,:,636))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(164),20,wf8(:,1),11,G2tensor(3),m3h8x1(:,15),heltab2x8(:,:,637))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H8(133),20,wf8(:,1),11,G2tensor(35),m3h8x1(:,16),heltab2x8(:,:,638))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(136),20,wf8(:,1),11,G2tensor(165),m3h8x1(:,17),heltab2x8(:,:,639))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H8(139),20,wf8(:,1),11,G2tensor(130),m3h8x1(:,18),heltab2x8(:,:,640))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(105),20,wf8(:,3),11,G2tensor(128),m3h8x1(:,19),heltab2x8(:,:,641))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H8(12),20,wf8(:,3),G2tensor(107),m3h8x1(:,20),heltab2x8(:,:,642))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(111),20,wf8(:,1),11,G2tensor(106),m3h8x1(:,21),heltab2x8(:,:,643))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H8(31),20,wf8(:,1),G2tensor(38),m3h8x1(:,22),heltab2x8(:,:,644))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(141),20,wf8(:,3),11,G2tensor(9),m3h8x1(:,23),heltab2x8(:,:,645))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H8(143),20,wf8(:,3),11,G2tensor(65),m3h8x1(:,24),heltab2x8(:,:,646))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(145),20,wf8(:,1),11,G2tensor(26),m3h8x1(:,25),heltab2x8(:,:,647))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H8(147),20,wf8(:,1),11,G2tensor(53),m3h8x1(:,26),heltab2x8(:,:,648))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H8(20),wf8(:,3),G2tensor(41),m3h8x1(:,27),heltab2x8(:,:,649))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H8(38),wf8(:,1),G0tensor(10),m3h8x1(:,28),heltab2x8(:,:,650))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H8(1),wf8(:,1),G2tensor(59),m3h8x1(:,29),heltab2x8(:,:,651))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H8(17),wf8(:,3),G2tensor(50),m3h8x1(:,30),heltab2x8(:,:,652))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H8(18),wf8(:,1),G2tensor(56),m3h8x1(:,31),heltab2x8(:,:,653))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H8(19),wf8(:,1),G2tensor(29),m3h8x1(:,32),heltab2x8(:,:,654))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(43),ex3(:),G1tensor(21),m3h1x1(:,131),heltab2x1(:,:,131))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(44),ex3(:),G1tensor(29),m3h1x1(:,132),heltab2x1(:,:,132))
  call Hloop_ZA_Q(ntryL,G0H4(11),wf4(:,4),G0H1(3),ngZu,m3h4x1(:,49),heltab2x4(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(3),31,0,G1tensor(46),n2h1(286))
  call Hloop_WA_Q(ntryL,G0H4(13),wf4(:,4),G0H1(4),m3h4x1(:,50),heltab2x4(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(4),31,0,G1tensor(58),n2h1(287))
  call Hloop_VA_Q(ntryL,G1H4(18),wf4(:,4),G1H1(13),m3h4x1(:,51),heltab2x4(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,0,G2tensor(15),n2h1(288))
  call Hloop_ZA_Q(ntryL,G1H4(17),wf4(:,4),G1H1(9),ngZu,m3h4x1(:,52),heltab2x4(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,0,G2tensor(189),n2h1(289))
  call Hloop_WA_Q(ntryL,G1H4(20),wf4(:,4),G1H1(16),m3h4x1(:,53),heltab2x4(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,0,G2tensor(186),n2h1(290))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(10),wf4(:,4),G2tensor(183),m3h4x1(:,54),heltab2x4(:,:,164))
  call Hloop_QV_A(ntryL,G2H8(2),wf8(:,4),G2H1(54),m3h8x1(:,33),heltab2x8(:,:,655))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(54),31,nML,G3tensor(99),n2h1(291))
  call Hloop_AV_Q(ntryL,G2H8(3),wf8(:,4),G2H1(58),m3h8x1(:,34),heltab2x8(:,:,656))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(58),31,nML,G3tensor(100),n2h1(292))
  call Hloop_QV_A(ntryL,G2H8(4),wf8(:,4),G2H1(13),m3h8x1(:,35),heltab2x8(:,:,657))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),31,nMT,G3tensor(101),n2h1(293))
  call Hloop_AV_Q(ntryL,G2H8(5),wf8(:,4),G2H1(10),m3h8x1(:,36),heltab2x8(:,:,658))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),31,nMT,G3tensor(102),n2h1(294))
  call Hloop_QV_A(ntryL,G2H8(6),wf8(:,4),G2H1(59),m3h8x1(:,37),heltab2x8(:,:,659))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(59),31,nMB,G3tensor(103),n2h1(295))
  call Hloop_AV_Q(ntryL,G2H8(7),wf8(:,4),G2H1(43),m3h8x1(:,38),heltab2x8(:,:,660))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(43),31,nMB,G3tensor(104),n2h1(296))
  call Hloop_QZ_A(ntryL,G2H8(8),wf8(:,2),G2H1(19),ngZl,m3h8x1(:,39),heltab2x8(:,:,661))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(19),31,nML,G3tensor(105),n2h1(297))
  call Hloop_AZ_Q(ntryL,G2H8(9),wf8(:,2),G2H1(60),ngZl,m3h8x1(:,40),heltab2x8(:,:,662))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(60),31,nML,G3tensor(106),n2h1(298))
  call Hloop_QZ_A(ntryL,G2H8(10),wf8(:,2),G2H1(21),ngZu,m3h8x1(:,41),heltab2x8(:,:,663))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(21),31,nMT,G3tensor(107),n2h1(299))
  call Hloop_AZ_Q(ntryL,G2H8(11),wf8(:,2),G2H1(45),ngZu,m3h8x1(:,42),heltab2x8(:,:,664))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(45),31,nMT,G3tensor(108),n2h1(300))
  call Hloop_QZ_A(ntryL,G2H8(12),wf8(:,2),G2H1(16),ngZd,m3h8x1(:,43),heltab2x8(:,:,665))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),31,nMB,G3tensor(109),n2h1(301))
  call Hloop_AZ_Q(ntryL,G2H8(29),wf8(:,2),G2H1(18),ngZd,m3h8x1(:,44),heltab2x8(:,:,666))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(18),31,nMB,G3tensor(110),n2h1(302))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(194),20,wf8(:,4),11,G2tensor(162),m3h8x1(:,45),heltab2x8(:,:,667))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H8(197),20,wf8(:,4),11,G2tensor(153),m3h8x1(:,46),heltab2x8(:,:,668))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(59),20,wf8(:,2),11,G2tensor(110),m3h8x1(:,47),heltab2x8(:,:,669))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H8(199),20,wf8(:,2),11,G2tensor(20),m3h8x1(:,48),heltab2x8(:,:,670))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(201),20,wf8(:,2),11,G2tensor(23),m3h8x1(:,49),heltab2x8(:,:,671))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H8(203),20,wf8(:,2),11,G2tensor(76),m3h8x1(:,50),heltab2x8(:,:,672))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(90),20,wf8(:,4),11,G2tensor(77),m3h8x1(:,51),heltab2x8(:,:,673))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H8(101),20,wf8(:,4),G2tensor(87),m3h8x1(:,52),heltab2x8(:,:,674))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(103),20,wf8(:,2),11,G2tensor(88),m3h8x1(:,53),heltab2x8(:,:,675))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H8(106),20,wf8(:,2),G2tensor(121),m3h8x1(:,54),heltab2x8(:,:,676))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(226),20,wf8(:,4),11,G2tensor(123),m3h8x1(:,55),heltab2x8(:,:,677))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H8(227),20,wf8(:,4),11,G2tensor(125),m3h8x1(:,56),heltab2x8(:,:,678))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(230),20,wf8(:,2),11,G2tensor(132),m3h8x1(:,57),heltab2x8(:,:,679))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H8(231),20,wf8(:,2),11,G2tensor(134),m3h8x1(:,58),heltab2x8(:,:,680))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H8(33),wf8(:,4),G2tensor(136),m3h8x1(:,59),heltab2x8(:,:,681))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H8(41),wf8(:,2),G0tensor(15),m3h8x1(:,60),heltab2x8(:,:,682))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H8(34),wf8(:,2),G2tensor(139),m3h8x1(:,61),heltab2x8(:,:,683))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H8(30),wf8(:,4),G2tensor(141),m3h8x1(:,62),heltab2x8(:,:,684))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H8(31),wf8(:,2),G2tensor(143),m3h8x1(:,63),heltab2x8(:,:,685))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H8(32),wf8(:,2),G2tensor(216),m3h8x1(:,64),heltab2x8(:,:,686))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(35),ex3(:),G1tensor(69),m3h1x1(:,133),heltab2x1(:,:,133))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(1),ex3(:),G1tensor(83),m3h1x1(:,134),heltab2x1(:,:,134))
  call ol_merge_tensors(G2tensor(183),[G2tensor(152),G2tensor(118),G1tensor(162),G1tensor(115),G1tensor(35),G1tensor(37) &
    ,G0tensor(171),G0tensor(124),G0tensor(69),G0tensor(12)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(179),G2tensor(176),G2tensor(173),G2tensor(170),G2tensor(167),G2tensor(161) &
    ,G2tensor(158),G2tensor(138),G2tensor(131),G2tensor(129),G2tensor(127),G2tensor(120),G2tensor(119),G1tensor(62),G1tensor(50) &
    ,G1tensor(140),G1tensor(130),G1tensor(27),G1tensor(32),G0tensor(149),G0tensor(139),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G3tensor(8),[G3tensor(7),G3tensor(2),G3tensor(1),G2tensor(239),G2tensor(236),G2tensor(221),G2tensor(218) &
    ,G1tensor(376),G1tensor(361),G0tensor(349),G0tensor(334)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(9),G3tensor(4),G3tensor(3),G2tensor(245),G2tensor(242),G2tensor(227),G2tensor(224) &
    ,G1tensor(381),G1tensor(366),G0tensor(354),G0tensor(339)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(6),G3tensor(5),G2tensor(251),G2tensor(248),G2tensor(233),G2tensor(230) &
    ,G1tensor(386),G1tensor(371),G0tensor(359),G0tensor(344)])
  call ol_merge_tensors(G3tensor(106),[G3tensor(105),G3tensor(100),G3tensor(99),G3tensor(94),G3tensor(93),G3tensor(88) &
    ,G3tensor(87),G3tensor(14),G3tensor(13),G2tensor(257),G2tensor(254),G1tensor(391),G0tensor(364)])
  call ol_merge_tensors(G3tensor(108),[G3tensor(107),G3tensor(102),G3tensor(101),G3tensor(96),G3tensor(95),G3tensor(90) &
    ,G3tensor(89),G3tensor(16),G3tensor(15),G2tensor(263),G2tensor(260),G1tensor(396),G0tensor(369)])
  call ol_merge_tensors(G3tensor(110),[G3tensor(109),G3tensor(104),G3tensor(103),G3tensor(98),G3tensor(97),G3tensor(92) &
    ,G3tensor(91),G3tensor(18),G3tensor(17),G2tensor(269),G2tensor(266),G1tensor(401),G0tensor(374)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(141),G2tensor(139),G2tensor(136),G2tensor(134),G2tensor(132),G2tensor(125) &
    ,G2tensor(123),G2tensor(121),G2tensor(88),G2tensor(87),G2tensor(77),G2tensor(76),G2tensor(23),G2tensor(153),G2tensor(162) &
    ,G2tensor(29),G2tensor(50),G2tensor(59),G2tensor(41),G2tensor(53),G2tensor(26),G2tensor(65),G2tensor(9),G2tensor(38) &
    ,G2tensor(106),G2tensor(107),G2tensor(128),G2tensor(130),G2tensor(165),G2tensor(108),G2tensor(109),G2tensor(194),G2tensor(191) &
    ,G2tensor(188),G2tensor(185),G2tensor(164),G2tensor(155),G2tensor(146),G2tensor(145),G1tensor(12),G1tensor(30),G1tensor(55) &
    ,G1tensor(25),G1tensor(175),G1tensor(79),G1tensor(49),G0tensor(184),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(16),G1tensor(44),G1tensor(66),G1tensor(1),G0tensor(56),G0tensor(52),G0tensor(46) &
    ,G0tensor(31)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(149),G1tensor(142),G1tensor(85),G1tensor(22),G1tensor(67),G0tensor(151) &
    ,G0tensor(94),G0tensor(59),G0tensor(17)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(74),G1tensor(47),G1tensor(41),G1tensor(56),G1tensor(7),G0tensor(66),G0tensor(61) &
    ,G0tensor(42),G0tensor(36)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(18),G2tensor(14),G2tensor(16),G2tensor(37),G2tensor(40),G2tensor(43),G2tensor(10) &
    ,G2tensor(193),G2tensor(190),G2tensor(187),G2tensor(184),G2tensor(163),G2tensor(154),G1tensor(172),G1tensor(9),G1tensor(38) &
    ,G0tensor(181),G0tensor(54),G0tensor(44)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(28),G2tensor(181),G2tensor(178),G2tensor(175),G2tensor(172),G2tensor(160) &
    ,G2tensor(157),G1tensor(8),G1tensor(26),G1tensor(127),G1tensor(15),G1tensor(78),G0tensor(136),G0tensor(63),G0tensor(48)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G3tensor(34),G3tensor(33),G3tensor(20),G3tensor(19),G2tensor(177),G2tensor(69) &
    ,G2tensor(169),G2tensor(166),G1tensor(173),G1tensor(137),G1tensor(28),G1tensor(5),G0tensor(182),G0tensor(146),G0tensor(68) &
    ,G0tensor(58)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(323),G0tensor(296)])
  call ol_merge_tensors(G2tensor(174),[G2tensor(197),G1tensor(326),G0tensor(299)])
  call ol_merge_tensors(G2tensor(199),[G1tensor(328),G0tensor(301)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(200),G1tensor(331),G0tensor(304)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(333),G0tensor(306)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(203),G1tensor(336),G0tensor(309)])
  call ol_merge_tensors(G2tensor(205),[G1tensor(338),G0tensor(311)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(206),G1tensor(341),G0tensor(314)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(343),G0tensor(316)])
  call ol_merge_tensors(G2tensor(189),[G2tensor(209),G1tensor(346),G0tensor(319)])
  call ol_merge_tensors(G2tensor(211),[G1tensor(348),G0tensor(321)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(215),G2tensor(212),G1tensor(356),G1tensor(351),G0tensor(329),G0tensor(324)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(214),G1tensor(353),G1tensor(178),G1tensor(122),G1tensor(117),G1tensor(4) &
    ,G0tensor(326),G0tensor(187),G0tensor(131),G0tensor(126),G0tensor(57)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(21),G2tensor(220),G2tensor(217),G1tensor(389),G1tensor(358),G0tensor(362) &
    ,G0tensor(331)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G2tensor(226),G2tensor(223),G1tensor(394),G1tensor(363),G0tensor(367) &
    ,G0tensor(336)])
  call ol_merge_tensors(G3tensor(31),[G3tensor(29),G2tensor(232),G2tensor(229),G1tensor(399),G1tensor(368),G0tensor(372) &
    ,G0tensor(341)])
  call ol_merge_tensors(G3tensor(39),[G3tensor(37),G2tensor(238),G2tensor(235),G1tensor(373),G0tensor(346)])
  call ol_merge_tensors(G3tensor(43),[G3tensor(41),G2tensor(244),G2tensor(241),G1tensor(378),G0tensor(351)])
  call ol_merge_tensors(G3tensor(47),[G3tensor(45),G2tensor(250),G2tensor(247),G1tensor(383),G0tensor(356)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(55),G3tensor(50),G3tensor(49),G2tensor(256),G2tensor(253),G1tensor(388) &
    ,G0tensor(361)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G3tensor(52),G3tensor(51),G2tensor(262),G2tensor(259),G1tensor(393) &
    ,G0tensor(366)])
  call ol_merge_tensors(G3tensor(60),[G3tensor(59),G3tensor(54),G3tensor(53),G2tensor(268),G2tensor(265),G1tensor(398) &
    ,G0tensor(371)])
  call ol_merge_tensors(G1tensor(217),[G1tensor(63),G1tensor(54),G1tensor(31),G0tensor(226),G0tensor(82),G0tensor(41) &
    ,G0tensor(11)])
  call ol_merge_tensors(G1tensor(170),[G1tensor(43),G0tensor(179),G0tensor(13)])
  call ol_merge_tensors(G1tensor(283),[G1tensor(278),G1tensor(247),G1tensor(98),G1tensor(3),G1tensor(61),G0tensor(292) &
    ,G0tensor(287),G0tensor(256),G0tensor(107),G0tensor(51),G0tensor(16)])
  call ol_merge_tensors(G1tensor(180),[G1tensor(73),G0tensor(189),G0tensor(18)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(349),G1tensor(253),G1tensor(248),G1tensor(77),G1tensor(36),G0tensor(322) &
    ,G0tensor(262),G0tensor(257),G0tensor(91),G0tensor(21)])
  call ol_merge_tensors(G1tensor(185),[G1tensor(42),G0tensor(194),G0tensor(22)])
  call ol_merge_tensors(G1tensor(190),[G1tensor(48),G0tensor(199),G0tensor(23)])
  call ol_merge_tensors(G1tensor(145),[G1tensor(135),G1tensor(33),G1tensor(19),G0tensor(154),G0tensor(144),G0tensor(34) &
    ,G0tensor(24)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(334),G1tensor(223),G1tensor(218),G1tensor(112),G1tensor(6),G0tensor(307) &
    ,G0tensor(232),G0tensor(227),G0tensor(121),G0tensor(26)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(13),G0tensor(204),G0tensor(27)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(24),G0tensor(209),G0tensor(28)])
  call ol_merge_tensors(G1tensor(165),[G1tensor(155),G1tensor(20),G1tensor(18),G0tensor(174),G0tensor(164),G0tensor(39) &
    ,G0tensor(29)])
  call ol_merge_tensors(G1tensor(272),[G1tensor(120),G1tensor(110),G1tensor(2),G0tensor(281),G0tensor(129),G0tensor(119) &
    ,G0tensor(32)])
  call ol_merge_tensors(G1tensor(160),[G1tensor(150),G1tensor(14),G0tensor(169),G0tensor(159),G0tensor(37)])
  call ol_merge_tensors(G1tensor(167),[G1tensor(60),G0tensor(176),G0tensor(43)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(188),G1tensor(183),G1tensor(107),G1tensor(102),G1tensor(97),G1tensor(68) &
    ,G0tensor(197),G0tensor(192),G0tensor(116),G0tensor(111),G0tensor(106),G0tensor(47)])
  call ol_merge_tensors(G1tensor(132),[G1tensor(72),G0tensor(141),G0tensor(49)])
  call ol_merge_tensors(G1tensor(177),[G1tensor(80),G0tensor(186),G0tensor(53)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(198),G1tensor(193),G1tensor(147),G1tensor(70),G1tensor(59),G1tensor(11) &
    ,G0tensor(207),G0tensor(202),G0tensor(156),G0tensor(86),G0tensor(81),G0tensor(62)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(17),G0tensor(161),G0tensor(64)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(168),G1tensor(157),G1tensor(23),G0tensor(177),G0tensor(166),G0tensor(67)])
  call ol_merge_tensors(G1tensor(21),[G1tensor(51),G1tensor(34),G0tensor(76),G0tensor(71)])
  call ol_merge_tensors(G1tensor(202),[G1tensor(39),G0tensor(211),G0tensor(72)])
  call ol_merge_tensors(G1tensor(207),[G1tensor(40),G0tensor(216),G0tensor(73)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(45),G0tensor(221),G0tensor(74)])
  call ol_merge_tensors(G1tensor(84),[G1tensor(205),G1tensor(52),G0tensor(214),G0tensor(77)])
  call ol_merge_tensors(G1tensor(210),[G1tensor(53),G0tensor(219),G0tensor(78)])
  call ol_merge_tensors(G1tensor(215),[G1tensor(57),G0tensor(224),G0tensor(79)])
  call ol_merge_tensors(G1tensor(222),[G1tensor(64),G0tensor(231),G0tensor(83)])
  call ol_merge_tensors(G1tensor(227),[G1tensor(65),G0tensor(236),G0tensor(84)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(220),G1tensor(71),G0tensor(229),G0tensor(87)])
  call ol_merge_tensors(G1tensor(225),[G1tensor(75),G0tensor(234),G0tensor(88)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(76),G0tensor(239),G0tensor(89)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(81),G0tensor(191),G0tensor(92)])
  call ol_merge_tensors(G1tensor(187),[G1tensor(82),G0tensor(196),G0tensor(93)])
  call ol_merge_tensors(G1tensor(69),[G1tensor(92),G1tensor(87),G0tensor(101),G0tensor(96)])
  call ol_merge_tensors(G1tensor(232),[G1tensor(88),G0tensor(241),G0tensor(97)])
  call ol_merge_tensors(G1tensor(237),[G1tensor(89),G0tensor(246),G0tensor(98)])
  call ol_merge_tensors(G1tensor(242),[G1tensor(90),G0tensor(251),G0tensor(99)])
  call ol_merge_tensors(G1tensor(46),[G1tensor(235),G1tensor(93),G0tensor(244),G0tensor(102)])
  call ol_merge_tensors(G1tensor(240),[G1tensor(94),G0tensor(249),G0tensor(103)])
  call ol_merge_tensors(G1tensor(245),[G1tensor(95),G0tensor(254),G0tensor(104)])
  call ol_merge_tensors(G1tensor(252),[G1tensor(99),G0tensor(261),G0tensor(108)])
  call ol_merge_tensors(G1tensor(257),[G1tensor(100),G0tensor(266),G0tensor(109)])
  call ol_merge_tensors(G1tensor(58),[G1tensor(265),G1tensor(250),G1tensor(103),G0tensor(274),G0tensor(259),G0tensor(112)])
  call ol_merge_tensors(G1tensor(270),[G1tensor(255),G1tensor(104),G0tensor(279),G0tensor(264),G0tensor(113)])
  call ol_merge_tensors(G1tensor(275),[G1tensor(260),G1tensor(125),G1tensor(105),G0tensor(284),G0tensor(269),G0tensor(134) &
    ,G0tensor(114)])
  call ol_merge_tensors(G3tensor(68),[G3tensor(66),G3tensor(64),G3tensor(62),G2tensor(32),G2tensor(5),G2tensor(102),G2tensor(36) &
    ,G1tensor(262),G1tensor(148),G1tensor(128),G1tensor(108),G0tensor(271),G0tensor(157),G0tensor(137),G0tensor(117)])
  call ol_merge_tensors(G1tensor(267),[G1tensor(133),G1tensor(109),G0tensor(276),G0tensor(142),G0tensor(118)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(192),G1tensor(113),G0tensor(201),G0tensor(122)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(197),G1tensor(114),G0tensor(206),G0tensor(123)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(66),G2tensor(63),G2tensor(1),G2tensor(30),G2tensor(103),G1tensor(277),G1tensor(158) &
    ,G1tensor(138),G1tensor(118),G0tensor(286),G0tensor(167),G0tensor(147),G0tensor(127)])
  call ol_merge_tensors(G1tensor(282),[G1tensor(184),G1tensor(143),G1tensor(119),G0tensor(291),G0tensor(193),G0tensor(152) &
    ,G0tensor(128)])
  call ol_merge_tensors(G1tensor(280),[G1tensor(123),G0tensor(289),G0tensor(132)])
  call ol_merge_tensors(G1tensor(285),[G1tensor(124),G0tensor(294),G0tensor(133)])
  call ol_merge_tensors(G3tensor(70),[G3tensor(69),G3tensor(67),G3tensor(65),G3tensor(63),G3tensor(61),G2tensor(12),G2tensor(4) &
    ,G1tensor(179),G1tensor(174),G1tensor(169),G1tensor(154),G1tensor(134),G1tensor(129),G0tensor(188),G0tensor(183),G0tensor(178) &
    ,G0tensor(163),G0tensor(143),G0tensor(138)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(33),G2tensor(25),G2tensor(31),G2tensor(8),G2tensor(6),G1tensor(199),G1tensor(189) &
    ,G1tensor(164),G1tensor(144),G1tensor(139),G0tensor(208),G0tensor(198),G0tensor(173),G0tensor(153),G0tensor(148)])
  call ol_merge_tensors(G1tensor(153),[G1tensor(149),G0tensor(162),G0tensor(158)])
  call ol_merge_tensors(G1tensor(194),[G1tensor(163),G1tensor(159),G0tensor(203),G0tensor(172),G0tensor(168)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(329),G1tensor(208),G1tensor(203),G0tensor(302),G0tensor(217),G0tensor(212)])
  call ol_merge_tensors(G1tensor(213),[G1tensor(204),G0tensor(222),G0tensor(213)])
  call ol_merge_tensors(G3tensor(86),[G3tensor(85),G1tensor(259),G1tensor(254),G1tensor(244),G1tensor(239),G1tensor(229) &
    ,G1tensor(224),G1tensor(214),G1tensor(209),G0tensor(268),G0tensor(263),G0tensor(253),G0tensor(248),G0tensor(238),G0tensor(233) &
    ,G0tensor(223),G0tensor(218)])
  call ol_merge_tensors(G1tensor(228),[G1tensor(219),G0tensor(237),G0tensor(228)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(344),G1tensor(238),G1tensor(233),G0tensor(317),G0tensor(247),G0tensor(242)])
  call ol_merge_tensors(G1tensor(243),[G1tensor(234),G0tensor(252),G0tensor(243)])
  call ol_merge_tensors(G1tensor(258),[G1tensor(249),G0tensor(267),G0tensor(258)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(354),G1tensor(268),G1tensor(263),G0tensor(327),G0tensor(277),G0tensor(272)])
  call ol_merge_tensors(G1tensor(279),[G1tensor(273),G1tensor(264),G0tensor(288),G0tensor(282),G0tensor(273)])
  call ol_merge_tensors(G1tensor(284),[G1tensor(274),G1tensor(269),G0tensor(293),G0tensor(283),G0tensor(278)])
  call ol_merge_tensors(G1tensor(312),[G1tensor(287)])
  call ol_merge_tensors(G1tensor(302),[G1tensor(290)])
  call ol_merge_tensors(G1tensor(316),[G1tensor(291)])
  call ol_merge_tensors(G1tensor(306),[G1tensor(294)])
  call ol_merge_tensors(G1tensor(320),[G1tensor(295)])
  call ol_merge_tensors(G1tensor(310),[G1tensor(298)])
  call ol_merge_tensors(G1tensor(313),[G1tensor(301)])
  call ol_merge_tensors(G1tensor(317),[G1tensor(305)])
  call ol_merge_tensors(G1tensor(321),[G1tensor(309)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(324),G0tensor(297)])
  call ol_merge_tensors(G3tensor(72),[G3tensor(71),G1tensor(350),G1tensor(345),G1tensor(340),G1tensor(335),G1tensor(330) &
    ,G1tensor(325),G0tensor(323),G0tensor(318),G0tensor(313),G0tensor(308),G0tensor(303),G0tensor(298)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(339),G0tensor(312)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(355),G0tensor(328)])
  call ol_merge_tensors(G3tensor(74),[G3tensor(73),G1tensor(359),G0tensor(332)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(22),G1tensor(360),G0tensor(333)])
  call ol_merge_tensors(G3tensor(76),[G3tensor(75),G1tensor(364),G0tensor(337)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G1tensor(365),G0tensor(338)])
  call ol_merge_tensors(G3tensor(78),[G3tensor(77),G1tensor(369),G0tensor(342)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(30),G1tensor(370),G0tensor(343)])
  call ol_merge_tensors(G3tensor(80),[G3tensor(79),G1tensor(374),G0tensor(347)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(38),G1tensor(390),G1tensor(375),G0tensor(363),G0tensor(348)])
  call ol_merge_tensors(G3tensor(82),[G3tensor(81),G1tensor(379),G0tensor(352)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G1tensor(395),G1tensor(380),G0tensor(368),G0tensor(353)])
  call ol_merge_tensors(G3tensor(84),[G3tensor(83),G1tensor(384),G0tensor(357)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(46),G1tensor(400),G1tensor(385),G0tensor(373),G0tensor(358)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(3),G0tensor(15),G0tensor(10)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(20),G2tensor(56),G2tensor(35)])
  call TI_triangle_red(G2tensor(183),RedBasis(4),mass3set(:,1),G0tensor(20),G0tensor(25),G0tensor(30),G0tensor(35),M2L1R1,[nMW], &
    G0tensor(40))
  call TI_triangle_red(G2tensor(182),RedBasis(21),mass3set(:,2),G0tensor(45),G0tensor(50),G0tensor(55),G0tensor(60),M2L1R1,[nMW], &
    G0tensor(65))
  call TI_triangle_red(G3tensor(8),RedBasis(21),mass3set(:,3),G0tensor(70),G0tensor(75),G0tensor(80),G0tensor(85),M2L1R1,[nML], &
    G0tensor(90))
  call TI_triangle_red(G3tensor(10),RedBasis(21),mass3set(:,4),G0tensor(95),G0tensor(100),G0tensor(105), &
    G0tensor(110),M2L1R1,[nMT],G0tensor(115))
  call TI_triangle_red(G3tensor(12),RedBasis(21),mass3set(:,5),G0tensor(120),G0tensor(125),G0tensor(130), &
    G0tensor(135),M2L1R1,[nMB],G0tensor(140))
  call TI_triangle_red(G3tensor(106),RedBasis(1),mass3set(:,3),G0tensor(145),G0tensor(150),G0tensor(155), &
    G0tensor(160),M2L1R1,[nML],G0tensor(165))
  call TI_triangle_red(G3tensor(108),RedBasis(1),mass3set(:,4),G0tensor(170),G0tensor(175),G0tensor(180), &
    G0tensor(185),M2L1R1,[nMT],G0tensor(190))
  call TI_triangle_red(G3tensor(110),RedBasis(1),mass3set(:,5),G0tensor(195),G0tensor(200),G0tensor(205), &
    G0tensor(210),M2L1R1,[nMB],G0tensor(215))
  call TI_triangle_red(G2tensor(216),RedBasis(1),mass3set(:,2),G0tensor(220),G0tensor(225),G0tensor(230), &
    G0tensor(235),M2L1R1,[nMW],G0tensor(240))
  call TI_triangle_red(G2tensor(148),RedBasis(63),mass3set(:,1),G0tensor(245),G0tensor(250),G0tensor(255), &
    G0tensor(260),M2L1R1,[nMW],G0tensor(265))
  call TI_triangle_red(G2tensor(156),RedBasis(8),mass3set(:,1),G0tensor(270),G0tensor(275),G0tensor(280), &
    G0tensor(285),M2L1R1,[nMW],G0tensor(290))
  call TI_triangle_red(G2tensor(151),RedBasis(59),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1,[nMW], &
    G0tensor(5))
  call TI_triangle_red(G2tensor(24),RedBasis(57),mass3set(:,2),G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),M2L1R1,[nMW], &
    G0tensor(295))
  call TI_triangle_red(G2tensor(22),RedBasis(61),mass3set(:,2),G0tensor(300),G0tensor(305),G0tensor(310), &
    G0tensor(315),M2L1R1,[nMW],G0tensor(320))
  call TI_triangle_red(G3tensor(36),RedBasis(5),mass3set(:,2),G0tensor(325),G0tensor(330),G0tensor(335), &
    G0tensor(340),M2L1R1,[nMW],G0tensor(345))
  call TI_triangle_red(G2tensor(196),RedBasis(63),mass3set(:,6),G0tensor(350),G0tensor(355),G0tensor(360),G0tensor(365),M2L1R1)
  call TI_triangle_red(G2tensor(174),RedBasis(8),mass3set(:,6),G0tensor(370),G0tensor(171),G0tensor(124),G0tensor(69),M2L1R1)
  call TI_triangle_red(G2tensor(199),RedBasis(63),mass3set(:,7),G0tensor(12),G0tensor(149),G0tensor(139), &
    G0tensor(38),M2L1R1,[nMZ],G0tensor(33))
  call TI_triangle_red(G2tensor(171),RedBasis(8),mass3set(:,7),G0tensor(349),G0tensor(334),G0tensor(354), &
    G0tensor(339),M2L1R1,[nMZ],G0tensor(359))
  call TI_triangle_red(G2tensor(202),RedBasis(63),mass3set(:,8),G0tensor(344),G0tensor(364),G0tensor(369), &
    G0tensor(374),M2L1R1,[nMW],G0tensor(184))
  call TI_triangle_red(G2tensor(159),RedBasis(8),mass3set(:,8),G0tensor(19),G0tensor(14),G0tensor(56),G0tensor(52),M2L1R1,[nMW], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(205),RedBasis(59),mass3set(:,6),G0tensor(31),G0tensor(151),G0tensor(94),G0tensor(59),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(4),mass3set(:,6),G0tensor(17),G0tensor(66),G0tensor(61),G0tensor(42),M2L1R1)
  call TI_triangle_red(G2tensor(208),RedBasis(59),mass3set(:,7),G0tensor(36),G0tensor(181),G0tensor(54),G0tensor(44),M2L1R1,[nMZ], &
    G0tensor(136))
  call TI_triangle_red(G2tensor(189),RedBasis(4),mass3set(:,7),G0tensor(63),G0tensor(48),G0tensor(182),G0tensor(146),M2L1R1,[nMZ], &
    G0tensor(68))
  call TI_triangle_red(G2tensor(211),RedBasis(59),mass3set(:,8),G0tensor(58),G0tensor(296),G0tensor(299), &
    G0tensor(301),M2L1R1,[nMW],G0tensor(304))
  call TI_triangle_red(G2tensor(186),RedBasis(4),mass3set(:,8),G0tensor(306),G0tensor(309),G0tensor(311), &
    G0tensor(314),M2L1R1,[nMW],G0tensor(316))
  call TI_triangle_red(G2tensor(21),RedBasis(9),mass3set(:,9),G0tensor(319),G0tensor(321),G0tensor(329), &
    G0tensor(324),M2L1R1,[nMW],G0tensor(326))
  call TI_triangle_red(G3tensor(23),RedBasis(5),mass3set(:,3),G0tensor(187),G0tensor(131),G0tensor(126),G0tensor(57),M2L1R1,[nML], &
    G0tensor(362))
  call TI_triangle_red(G3tensor(27),RedBasis(5),mass3set(:,4),G0tensor(331),G0tensor(367),G0tensor(336), &
    G0tensor(372),M2L1R1,[nMT],G0tensor(341))
  call TI_triangle_red(G3tensor(31),RedBasis(5),mass3set(:,5),G0tensor(346),G0tensor(351),G0tensor(356), &
    G0tensor(361),M2L1R1,[nMB],G0tensor(366))
  call TI_triangle_red(G3tensor(39),RedBasis(61),mass3set(:,3),G0tensor(371),G0tensor(226),G0tensor(82),G0tensor(41),M2L1R1,[nML], &
    G0tensor(11))
  call TI_triangle_red(G3tensor(43),RedBasis(61),mass3set(:,4),G0tensor(179),G0tensor(13),G0tensor(292), &
    G0tensor(287),M2L1R1,[nMT],G0tensor(256))
  call TI_triangle_red(G3tensor(47),RedBasis(61),mass3set(:,5),G0tensor(107),G0tensor(51),G0tensor(16),G0tensor(189),M2L1R1,[nMB], &
    G0tensor(18))
  call TI_triangle_red(G3tensor(56),RedBasis(57),mass3set(:,3),G0tensor(322),G0tensor(262),G0tensor(257), &
    G0tensor(91),M2L1R1,[nML],G0tensor(21))
  call TI_triangle_red(G3tensor(58),RedBasis(57),mass3set(:,4),G0tensor(194),G0tensor(22),G0tensor(199),G0tensor(23),M2L1R1,[nMT], &
    G0tensor(154))
  call TI_triangle_red(G3tensor(60),RedBasis(57),mass3set(:,5),G0tensor(144),G0tensor(34),G0tensor(24),G0tensor(307),M2L1R1,[nMB], &
    G0tensor(232))
  call TI_triangle_red(G2tensor(54),RedBasis(6),mass3set(:,10),G0tensor(227),G0tensor(121),G0tensor(26), &
    G0tensor(204),M2L1R1,[nMW],G0tensor(27))
  call TI_triangle_red(G2tensor(19),RedBasis(9),mass3set(:,10),G0tensor(209),G0tensor(28),G0tensor(174), &
    G0tensor(164),M2L1R1,[nMW],G0tensor(39))
  call TI_triangle_red(G2tensor(27),RedBasis(6),mass3set(:,9),G0tensor(29),G0tensor(281),G0tensor(129),G0tensor(119),M2L1R1,[nMW], &
    G0tensor(32))
  call TI_triangle_red(G3tensor(68),RedBasis(24),mass3set(:,2),G0tensor(169),G0tensor(159),G0tensor(37), &
    G0tensor(176),M2L1R1,[nMW],G0tensor(43))
  call TI_triangle_red(G2tensor(61),RedBasis(32),mass3set(:,11),G0tensor(197),G0tensor(192),G0tensor(116), &
    G0tensor(111),M2L1R1,[nMW],G0tensor(106))
  call TI_triangle_red(G2tensor(2),RedBasis(56),mass3set(:,1),G0tensor(47),G0tensor(141),G0tensor(49),G0tensor(186),M2L1R1,[nMW], &
    G0tensor(53))
  call TI_triangle_red(G2tensor(44),RedBasis(25),mass3set(:,2),G0tensor(207),G0tensor(202),G0tensor(156), &
    G0tensor(86),M2L1R1,[nMW],G0tensor(81))
  call TI_triangle_red(G3tensor(70),RedBasis(3),mass3set(:,2),G0tensor(62),G0tensor(161),G0tensor(64),G0tensor(177),M2L1R1,[nMW], &
    G0tensor(166))
  call TI_triangle_red(G2tensor(39),RedBasis(12),mass3set(:,2),G0tensor(67),G0tensor(76),G0tensor(71),G0tensor(211),M2L1R1,[nMW], &
    G0tensor(72))
  call TI_triangle_red(G2tensor(42),RedBasis(9),mass3set(:,12),G0tensor(216),G0tensor(73),G0tensor(221),G0tensor(74),M2L1R1,[nMZ], &
    G0tensor(214))
  call TI_triangle_red(G3tensor(86),RedBasis(3),mass3set(:,6),G0tensor(77),G0tensor(219),G0tensor(78),G0tensor(224),M2L1R1)
  call TI_triangle_red(G2tensor(52),RedBasis(6),mass3set(:,12),G0tensor(79),G0tensor(231),G0tensor(83),G0tensor(236),M2L1R1,[nMZ], &
    G0tensor(84))
  call TI_triangle_red(G2tensor(58),RedBasis(32),mass3set(:,13),G0tensor(229),G0tensor(87),G0tensor(234), &
    G0tensor(88),M2L1R1,[nMW],G0tensor(239))
  call TI_triangle_red(G2tensor(45),RedBasis(9),mass3set(:,6),G0tensor(89),G0tensor(191),G0tensor(92),G0tensor(196),M2L1R1)
  call TI_triangle_red(G3tensor(72),RedBasis(5),mass3set(:,6),G0tensor(93),G0tensor(101),G0tensor(96),G0tensor(241),M2L1R1)
  call TI_triangle_red(G2tensor(49),RedBasis(6),mass3set(:,6),G0tensor(97),G0tensor(246),G0tensor(98),G0tensor(251),M2L1R1)
  call TI_triangle_red(G2tensor(64),RedBasis(56),mass3set(:,8),G0tensor(99),G0tensor(244),G0tensor(102), &
    G0tensor(249),M2L1R1,[nMW],G0tensor(103))
  call TI_triangle_red(G3tensor(74),RedBasis(25),mass3set(:,3),G0tensor(254),G0tensor(104),G0tensor(261), &
    G0tensor(108),M2L1R1,[nML],G0tensor(266))
  call TI_triangle_red(G3tensor(24),RedBasis(12),mass3set(:,3),G0tensor(109),G0tensor(274),G0tensor(259), &
    G0tensor(112),M2L1R1,[nML],G0tensor(279))
  call TI_triangle_red(G3tensor(76),RedBasis(25),mass3set(:,4),G0tensor(264),G0tensor(113),G0tensor(284), &
    G0tensor(269),M2L1R1,[nMT],G0tensor(134))
  call TI_triangle_red(G3tensor(28),RedBasis(12),mass3set(:,4),G0tensor(114),G0tensor(271),G0tensor(157), &
    G0tensor(137),M2L1R1,[nMT],G0tensor(117))
  call TI_triangle_red(G3tensor(78),RedBasis(25),mass3set(:,5),G0tensor(276),G0tensor(142),G0tensor(118), &
    G0tensor(201),M2L1R1,[nMB],G0tensor(122))
  call TI_triangle_red(G3tensor(32),RedBasis(12),mass3set(:,5),G0tensor(206),G0tensor(123),G0tensor(286), &
    G0tensor(167),M2L1R1,[nMB],G0tensor(147))
  call TI_triangle_red(G3tensor(80),RedBasis(24),mass3set(:,3),G0tensor(127),G0tensor(291),G0tensor(193), &
    G0tensor(152),M2L1R1,[nML],G0tensor(128))
  call TI_triangle_red(G3tensor(40),RedBasis(3),mass3set(:,3),G0tensor(289),G0tensor(132),G0tensor(294), &
    G0tensor(133),M2L1R1,[nML],G0tensor(188))
  call TI_triangle_red(G3tensor(82),RedBasis(24),mass3set(:,4),G0tensor(183),G0tensor(178),G0tensor(163), &
    G0tensor(143),M2L1R1,[nMT],G0tensor(138))
  call TI_triangle_red(G3tensor(44),RedBasis(3),mass3set(:,4),G0tensor(208),G0tensor(198),G0tensor(173), &
    G0tensor(153),M2L1R1,[nMT],G0tensor(148))
  call TI_triangle_red(G3tensor(84),RedBasis(24),mass3set(:,5),G0tensor(162),G0tensor(158),G0tensor(203), &
    G0tensor(172),M2L1R1,[nMB],G0tensor(168))
  call TI_triangle_red(G3tensor(48),RedBasis(3),mass3set(:,5),G0tensor(302),G0tensor(217),G0tensor(212), &
    G0tensor(222),M2L1R1,[nMB],G0tensor(213))
  call TI_triangle_red(G2tensor(110),RedBasis(1),mass3set(:,14),G0tensor(268),G0tensor(263),G0tensor(253), &
    G0tensor(248),M2L1R1,[nMZ,nMH],G0tensor(238),G0tensor(233))
  call TI_triangle_red(G2tensor(143),RedBasis(1),mass3set(:,15),G0tensor(223),G0tensor(218),G0tensor(237), &
    G0tensor(228),M2L1R1,[nMH,nMZ],G0tensor(317),G0tensor(247))
  call TI_triangle_red(G1tensor(217),RedBasis(65),mass3set(:,13),G0tensor(242),G0tensor(252),G0tensor(243), &
    G0tensor(267),M2L1R1,[nMW],G0tensor(258))
  call TI_triangle_red(G1tensor(170),RedBasis(2),mass3set(:,1),G0tensor(327),G0tensor(277),G0tensor(272), &
    G0tensor(288),M2L1R1,[nMW],G0tensor(282))
  call TI_triangle_red(G1tensor(283),RedBasis(33),mass3set(:,13),G0tensor(273),G0tensor(293),G0tensor(283), &
    G0tensor(278),M2L1R1,[nMW],G0tensor(297))
  call TI_triangle_red(G1tensor(180),RedBasis(7),mass3set(:,1),G0tensor(323),G0tensor(318),G0tensor(313), &
    G0tensor(308),M2L1R1,[nMW],G0tensor(303))
  call TI_triangle_red(G1tensor(185),RedBasis(13),mass3set(:,11),G0tensor(298),G0tensor(312),G0tensor(328), &
    G0tensor(332),M2L1R1,[nMW],G0tensor(333))
  call TI_triangle_red(G1tensor(190),RedBasis(11),mass3set(:,1),G0tensor(337),G0tensor(338),G0tensor(342), &
    G0tensor(343),M2L1R1,[nMW],G0tensor(347))
  call TI_triangle_red(G1tensor(145),RedBasis(10),mass3set(:,1),G0tensor(363),G0tensor(348),G0tensor(352), &
    G0tensor(368),M2L1R1,[nMW],G0tensor(353))
  call TI_triangle_red(G1tensor(195),RedBasis(18),mass3set(:,11),G0tensor(357),G0tensor(373),G0tensor(358), &
    G0tensor(15),M2L1R1,[nMW],G0tensor(10))
  call TI_triangle_red(G1tensor(200),RedBasis(17),mass3set(:,1),G0tensor(375),G0tensor(376),G0tensor(377), &
    G0tensor(378),M2L1R1,[nMW],G0tensor(379))
  call TI_triangle_red(G1tensor(165),RedBasis(16),mass3set(:,1),G0tensor(380),G0tensor(381),G0tensor(382), &
    G0tensor(383),M2L1R1,[nMW],G0tensor(384))
  call TI_triangle_red(G1tensor(272),RedBasis(22),mass3set(:,9),G0tensor(385),G0tensor(386),G0tensor(387), &
    G0tensor(388),M2L1R1,[nMW],G0tensor(389))
  call TI_triangle_red(G1tensor(160),RedBasis(26),mass3set(:,9),G0tensor(390),G0tensor(391),G0tensor(392), &
    G0tensor(393),M2L1R1,[nMW],G0tensor(394))
  call TI_triangle_red(G1tensor(167),RedBasis(58),mass3set(:,1),G0tensor(395),G0tensor(396),G0tensor(397), &
    G0tensor(398),M2L1R1,[nMW],G0tensor(399))
  call TI_triangle_red(G1tensor(83),RedBasis(15),mass3set(:,9),G0tensor(400),G0tensor(401),G0tensor(402), &
    G0tensor(403),M2L1R1,[nMW],G0tensor(404))
  call TI_triangle_red(G1tensor(132),RedBasis(60),mass3set(:,1),G0tensor(405),G0tensor(406),G0tensor(407), &
    G0tensor(408),M2L1R1,[nMW],G0tensor(409))
  call TI_triangle_red(G1tensor(177),RedBasis(62),mass3set(:,1),G0tensor(410),G0tensor(411),G0tensor(412), &
    G0tensor(413),M2L1R1,[nMW],G0tensor(414))
  call TI_triangle_red(G1tensor(29),RedBasis(20),mass3set(:,9),G0tensor(415),G0tensor(416),G0tensor(417), &
    G0tensor(418),M2L1R1,[nMW],G0tensor(419))
  call TI_triangle_red(G1tensor(152),RedBasis(64),mass3set(:,1),G0tensor(420),G0tensor(421),G0tensor(422), &
    G0tensor(423),M2L1R1,[nMW],G0tensor(424))
  call TI_triangle_red(G1tensor(21),RedBasis(20),mass3set(:,16),G0tensor(425),G0tensor(426),G0tensor(427), &
    G0tensor(428),M2L1R1,[nMZ],G0tensor(429))
  call TI_triangle_red(G1tensor(202),RedBasis(65),mass3set(:,17),G0tensor(430),G0tensor(431),G0tensor(432), &
    G0tensor(433),M2L1R1,[nMZ],G0tensor(434))
  call TI_triangle_red(G1tensor(207),RedBasis(62),mass3set(:,7),G0tensor(435),G0tensor(436),G0tensor(437), &
    G0tensor(438),M2L1R1,[nMZ],G0tensor(439))
  call TI_triangle_red(G1tensor(212),RedBasis(60),mass3set(:,7),G0tensor(440),G0tensor(441),G0tensor(442), &
    G0tensor(443),M2L1R1,[nMZ],G0tensor(444))
  call TI_triangle_red(G1tensor(84),RedBasis(28),mass3set(:,17),G0tensor(445),G0tensor(446),G0tensor(447), &
    G0tensor(448),M2L1R1,[nMZ],G0tensor(449))
  call TI_triangle_red(G1tensor(210),RedBasis(7),mass3set(:,7),G0tensor(450),G0tensor(451),G0tensor(452), &
    G0tensor(453),M2L1R1,[nMZ],G0tensor(454))
  call TI_triangle_red(G1tensor(215),RedBasis(10),mass3set(:,7),G0tensor(455),G0tensor(456),G0tensor(457), &
    G0tensor(458),M2L1R1,[nMZ],G0tensor(459))
  call TI_triangle_red(G1tensor(222),RedBasis(62),mass3set(:,8),G0tensor(460),G0tensor(461),G0tensor(462), &
    G0tensor(463),M2L1R1,[nMW],G0tensor(464))
  call TI_triangle_red(G1tensor(227),RedBasis(60),mass3set(:,8),G0tensor(465),G0tensor(466),G0tensor(467), &
    G0tensor(468),M2L1R1,[nMW],G0tensor(469))
  call TI_triangle_red(G1tensor(10),RedBasis(28),mass3set(:,13),G0tensor(470),G0tensor(471),G0tensor(472), &
    G0tensor(473),M2L1R1,[nMW],G0tensor(474))
  call TI_triangle_red(G1tensor(225),RedBasis(7),mass3set(:,8),G0tensor(475),G0tensor(476),G0tensor(477), &
    G0tensor(478),M2L1R1,[nMW],G0tensor(479))
  call TI_triangle_red(G1tensor(230),RedBasis(10),mass3set(:,8),G0tensor(480),G0tensor(481),G0tensor(482), &
    G0tensor(483),M2L1R1,[nMW],G0tensor(484))
  call TI_triangle_red(G1tensor(182),RedBasis(67),mass3set(:,11),G0tensor(485),G0tensor(486),G0tensor(487), &
    G0tensor(488),M2L1R1,[nMW],G0tensor(489))
  call TI_triangle_red(G1tensor(187),RedBasis(66),mass3set(:,1),G0tensor(490),G0tensor(491),G0tensor(492), &
    G0tensor(493),M2L1R1,[nMW],G0tensor(494))
  call TI_triangle_red(G1tensor(69),RedBasis(15),mass3set(:,16),G0tensor(495),G0tensor(496),G0tensor(497), &
    G0tensor(498),M2L1R1,[nMZ],G0tensor(499))
  call TI_triangle_red(G1tensor(232),RedBasis(33),mass3set(:,17),G0tensor(500),G0tensor(501),G0tensor(502), &
    G0tensor(503),M2L1R1,[nMZ],G0tensor(504))
  call TI_triangle_red(G1tensor(237),RedBasis(58),mass3set(:,7),G0tensor(505),G0tensor(506),G0tensor(507), &
    G0tensor(508),M2L1R1,[nMZ],G0tensor(509))
  call TI_triangle_red(G1tensor(242),RedBasis(64),mass3set(:,7),G0tensor(510),G0tensor(511),G0tensor(512), &
    G0tensor(513),M2L1R1,[nMZ],G0tensor(514))
  call TI_triangle_red(G1tensor(46),RedBasis(29),mass3set(:,17),G0tensor(515),G0tensor(516),G0tensor(517), &
    G0tensor(518),M2L1R1,[nMZ],G0tensor(519))
  call TI_triangle_red(G1tensor(240),RedBasis(2),mass3set(:,7),G0tensor(520),G0tensor(521),G0tensor(522), &
    G0tensor(523),M2L1R1,[nMZ],G0tensor(524))
  call TI_triangle_red(G1tensor(245),RedBasis(16),mass3set(:,7),G0tensor(525),G0tensor(526),G0tensor(527), &
    G0tensor(528),M2L1R1,[nMZ],G0tensor(529))
  call TI_triangle_red(G1tensor(252),RedBasis(58),mass3set(:,8),G0tensor(530),G0tensor(531),G0tensor(532), &
    G0tensor(533),M2L1R1,[nMW],G0tensor(534))
  call TI_triangle_red(G1tensor(257),RedBasis(64),mass3set(:,8),G0tensor(535),G0tensor(536),G0tensor(537), &
    G0tensor(538),M2L1R1,[nMW],G0tensor(539))
  call TI_triangle_red(G1tensor(58),RedBasis(29),mass3set(:,13),G0tensor(540),G0tensor(541),G0tensor(542), &
    G0tensor(543),M2L1R1,[nMW],G0tensor(544))
  call TI_triangle_red(G1tensor(270),RedBasis(2),mass3set(:,8),G0tensor(545),G0tensor(546),G0tensor(547), &
    G0tensor(548),M2L1R1,[nMW],G0tensor(549))
  call TI_triangle_red(G1tensor(275),RedBasis(16),mass3set(:,8),G0tensor(550),G0tensor(551),G0tensor(552), &
    G0tensor(553),M2L1R1,[nMW],G0tensor(554))
  call TI_triangle_red(G1tensor(267),RedBasis(23),mass3set(:,9),G0tensor(555),G0tensor(556),G0tensor(557), &
    G0tensor(558),M2L1R1,[nMW],G0tensor(559))
  call TI_triangle_red(G1tensor(282),RedBasis(14),mass3set(:,9),G0tensor(560),G0tensor(561),G0tensor(562), &
    G0tensor(563),M2L1R1,[nMW],G0tensor(564))
  call TI_triangle_red(G1tensor(280),RedBasis(18),mass3set(:,13),G0tensor(565),G0tensor(566),G0tensor(567), &
    G0tensor(568),M2L1R1,[nMW],G0tensor(569))
  call TI_triangle_red(G1tensor(285),RedBasis(17),mass3set(:,8),G0tensor(570),G0tensor(571),G0tensor(572), &
    G0tensor(573),M2L1R1,[nMW],G0tensor(574))
  call TI_triangle_red(G1tensor(153),RedBasis(27),mass3set(:,9),G0tensor(575),G0tensor(576),G0tensor(577), &
    G0tensor(578),M2L1R1,[nMW],G0tensor(579))
  call TI_triangle_red(G1tensor(194),RedBasis(19),mass3set(:,9),G0tensor(580),G0tensor(581),G0tensor(582), &
    G0tensor(583),M2L1R1,[nMW],G0tensor(584))
  call TI_triangle_red(G1tensor(213),RedBasis(23),mass3set(:,12),G0tensor(585),G0tensor(586),G0tensor(587), &
    G0tensor(588),M2L1R1,[nMZ],G0tensor(589))
  call TI_triangle_red(G1tensor(228),RedBasis(23),mass3set(:,10),G0tensor(590),G0tensor(591),G0tensor(592), &
    G0tensor(593),M2L1R1,[nMW],G0tensor(594))
  call TI_triangle_red(G1tensor(243),RedBasis(27),mass3set(:,12),G0tensor(595),G0tensor(596),G0tensor(597), &
    G0tensor(598),M2L1R1,[nMZ],G0tensor(599))
  call TI_triangle_red(G1tensor(258),RedBasis(27),mass3set(:,10),G0tensor(600),G0tensor(601),G0tensor(602), &
    G0tensor(603),M2L1R1,[nMW],G0tensor(604))
  call TI_triangle_red(G1tensor(279),RedBasis(31),mass3set(:,13),G0tensor(605),G0tensor(606),G0tensor(607), &
    G0tensor(608),M2L1R1,[nMW],G0tensor(609))
  call TI_triangle_red(G1tensor(284),RedBasis(30),mass3set(:,8),G0tensor(610),G0tensor(611),G0tensor(612), &
    G0tensor(613),M2L1R1,[nMW],G0tensor(614))
  call ol_merge_tensors(T0sum(83),[G0tensor(20)])
  call ol_merge_tensors(T0sum(84),[G0tensor(45)])
  call ol_merge_tensors(T0sum(85),[G0tensor(70)])
  call ol_merge_tensors(T0sum(86),[G0tensor(95)])
  call ol_merge_tensors(T0sum(87),[G0tensor(120)])
  call ol_merge_tensors(T0sum(88),[G0tensor(145)])
  call ol_merge_tensors(T0sum(89),[G0tensor(170)])
  call ol_merge_tensors(T0sum(90),[G0tensor(195)])
  call ol_merge_tensors(T0sum(91),[G0tensor(220)])
  call ol_merge_tensors(T0sum(92),[G0tensor(245)])
  call ol_merge_tensors(T0sum(93),[G0tensor(270)])
  call ol_merge_tensors(T0sum(94),[G0tensor(1)])
  call ol_merge_tensors(T0sum(95),[G0tensor(6)])
  call ol_merge_tensors(T0sum(96),[G0tensor(300)])
  call ol_merge_tensors(T0sum(97),[G0tensor(325)])
  call ol_merge_tensors(T0sum(98),[G0tensor(350)])
  call ol_merge_tensors(T0sum(99),[G0tensor(370)])
  call ol_merge_tensors(T0sum(100),[G0tensor(12)])
  call ol_merge_tensors(T0sum(101),[G0tensor(349)])
  call ol_merge_tensors(T0sum(102),[G0tensor(344)])
  call ol_merge_tensors(T0sum(103),[G0tensor(19)])
  call ol_merge_tensors(T0sum(104),[G0tensor(31)])
  call ol_merge_tensors(T0sum(105),[G0tensor(17)])
  call ol_merge_tensors(T0sum(106),[G0tensor(36)])
  call ol_merge_tensors(T0sum(107),[G0tensor(63)])
  call ol_merge_tensors(T0sum(108),[G0tensor(58)])
  call ol_merge_tensors(T0sum(109),[G0tensor(306)])
  call ol_merge_tensors(T0sum(110),[G0tensor(319)])
  call ol_merge_tensors(T0sum(111),[G0tensor(187)])
  call ol_merge_tensors(T0sum(112),[G0tensor(331)])
  call ol_merge_tensors(T0sum(113),[G0tensor(346)])
  call ol_merge_tensors(T0sum(114),[G0tensor(371)])
  call ol_merge_tensors(T0sum(115),[G0tensor(179)])
  call ol_merge_tensors(T0sum(116),[G0tensor(107)])
  call ol_merge_tensors(T0sum(117),[G0tensor(322)])
  call ol_merge_tensors(T0sum(118),[G0tensor(194)])
  call ol_merge_tensors(T0sum(119),[G0tensor(144)])
  call ol_merge_tensors(T0sum(120),[G0tensor(242)])
  call ol_merge_tensors(T0sum(121),[G0tensor(327)])
  call ol_merge_tensors(T0sum(122),[G0tensor(273)])
  call ol_merge_tensors(T0sum(123),[G0tensor(323)])
  call ol_merge_tensors(T0sum(124),[G0tensor(227)])
  call ol_merge_tensors(T0sum(125),[G0tensor(298)])
  call ol_merge_tensors(T0sum(126),[G0tensor(337)])
  call ol_merge_tensors(T0sum(127),[G0tensor(363)])
  call ol_merge_tensors(T0sum(128),[G0tensor(209)])
  call ol_merge_tensors(T0sum(129),[G0tensor(357)])
  call ol_merge_tensors(T0sum(130),[G0tensor(375)])
  call ol_merge_tensors(T0sum(131),[G0tensor(380)])
  call ol_merge_tensors(T0sum(132),[G0tensor(385)])
  call ol_merge_tensors(T0sum(133),[G0tensor(390)])
  call ol_merge_tensors(T0sum(134),[G0tensor(395)])
  call ol_merge_tensors(T0sum(135),[G0tensor(400)])
  call ol_merge_tensors(T0sum(136),[G0tensor(405)])
  call ol_merge_tensors(T0sum(137),[G0tensor(410)])
  call ol_merge_tensors(T0sum(138),[G0tensor(415)])
  call ol_merge_tensors(T0sum(139),[G0tensor(420)])
  call ol_merge_tensors(T0sum(140),[G0tensor(29)])
  call ol_merge_tensors(T0sum(141),[G0tensor(425)])
  call ol_merge_tensors(T0sum(142),[G0tensor(430)])
  call ol_merge_tensors(T0sum(143),[G0tensor(435)])
  call ol_merge_tensors(T0sum(144),[G0tensor(440)])
  call ol_merge_tensors(T0sum(145),[G0tensor(445)])
  call ol_merge_tensors(T0sum(146),[G0tensor(450)])
  call ol_merge_tensors(T0sum(147),[G0tensor(455)])
  call ol_merge_tensors(T0sum(148),[G0tensor(460)])
  call ol_merge_tensors(T0sum(149),[G0tensor(465)])
  call ol_merge_tensors(T0sum(150),[G0tensor(470)])
  call ol_merge_tensors(T0sum(151),[G0tensor(475)])
  call ol_merge_tensors(T0sum(152),[G0tensor(480)])
  call ol_merge_tensors(T0sum(153),[G0tensor(485)])
  call ol_merge_tensors(T0sum(154),[G0tensor(490)])
  call ol_merge_tensors(T0sum(155),[G0tensor(495)])
  call ol_merge_tensors(T0sum(156),[G0tensor(500)])
  call ol_merge_tensors(T0sum(157),[G0tensor(505)])
  call ol_merge_tensors(T0sum(158),[G0tensor(510)])
  call ol_merge_tensors(T0sum(159),[G0tensor(515)])
  call ol_merge_tensors(T0sum(160),[G0tensor(520)])
  call ol_merge_tensors(T0sum(161),[G0tensor(525)])
  call ol_merge_tensors(T0sum(162),[G0tensor(530)])
  call ol_merge_tensors(T0sum(163),[G0tensor(535)])
  call ol_merge_tensors(T0sum(164),[G0tensor(540)])
  call ol_merge_tensors(T0sum(165),[G0tensor(545)])
  call ol_merge_tensors(T0sum(166),[G0tensor(550)])
  call ol_merge_tensors(T0sum(167),[G0tensor(169)])
  call ol_merge_tensors(T0sum(168),[G0tensor(555)])
  call ol_merge_tensors(T0sum(169),[G0tensor(197)])
  call ol_merge_tensors(T0sum(170),[G0tensor(47)])
  call ol_merge_tensors(T0sum(171),[G0tensor(207)])
  call ol_merge_tensors(T0sum(172),[G0tensor(560)])
  call ol_merge_tensors(T0sum(173),[G0tensor(565)])
  call ol_merge_tensors(T0sum(174),[G0tensor(570)])
  call ol_merge_tensors(T0sum(175),[G0tensor(62)])
  call ol_merge_tensors(T0sum(176),[G0tensor(67)])
  call ol_merge_tensors(T0sum(177),[G0tensor(575)])
  call ol_merge_tensors(T0sum(178),[G0tensor(580)])
  call ol_merge_tensors(T0sum(179),[G0tensor(216)])
  call ol_merge_tensors(T0sum(180),[G0tensor(585)])
  call ol_merge_tensors(T0sum(181),[G0tensor(77)])
  call ol_merge_tensors(T0sum(182),[G0tensor(590)])
  call ol_merge_tensors(T0sum(183),[G0tensor(79)])
  call ol_merge_tensors(T0sum(184),[G0tensor(595)])
  call ol_merge_tensors(T0sum(185),[G0tensor(600)])
  call ol_merge_tensors(T0sum(186),[G0tensor(229)])
  call ol_merge_tensors(T0sum(187),[G0tensor(605)])
  call ol_merge_tensors(T0sum(188),[G0tensor(610)])
  call ol_merge_tensors(T1sum(15),[G1tensor(312)])
  call ol_merge_tensors(T1sum(16),[G1tensor(288)])
  call ol_merge_tensors(T1sum(17),[G1tensor(289)])
  call ol_merge_tensors(T1sum(18),[G1tensor(302)])
  call ol_merge_tensors(T1sum(19),[G1tensor(316)])
  call ol_merge_tensors(T1sum(20),[G1tensor(292)])
  call ol_merge_tensors(T1sum(21),[G1tensor(293)])
  call ol_merge_tensors(T1sum(22),[G1tensor(306)])
  call ol_merge_tensors(T1sum(23),[G1tensor(320)])
  call ol_merge_tensors(T1sum(24),[G1tensor(296)])
  call ol_merge_tensors(T1sum(25),[G1tensor(297)])
  call ol_merge_tensors(T1sum(26),[G1tensor(310)])
  call ol_merge_tensors(T1sum(27),[G1tensor(299)])
  call ol_merge_tensors(T1sum(28),[G1tensor(300)])
  call ol_merge_tensors(T1sum(29),[G1tensor(313)])
  call ol_merge_tensors(T1sum(30),[G1tensor(303)])
  call ol_merge_tensors(T1sum(31),[G1tensor(304)])
  call ol_merge_tensors(T1sum(32),[G1tensor(317)])
  call ol_merge_tensors(T1sum(33),[G1tensor(307)])
  call ol_merge_tensors(T1sum(34),[G1tensor(308)])
  call ol_merge_tensors(T1sum(35),[G1tensor(321)])
  call ol_merge_tensors(T1sum(36),[G1tensor(311)])
  call ol_merge_tensors(T1sum(37),[G1tensor(314)])
  call ol_merge_tensors(T1sum(38),[G1tensor(315)])
  call ol_merge_tensors(T1sum(39),[G1tensor(318)])
  call ol_merge_tensors(T1sum(40),[G1tensor(319)])
  call ol_merge_tensors(T1sum(41),[G1tensor(322)])
  call ol_merge_tensors(T0sum(189),[G0tensor(89)])
  call ol_merge_tensors(T0sum(190),[G0tensor(93)])
  call ol_merge_tensors(T0sum(191),[G0tensor(97)])
  call ol_merge_tensors(T0sum(192),[G0tensor(99)])
  call ol_merge_tensors(T0sum(193),[G0tensor(254)])
  call ol_merge_tensors(T0sum(194),[G0tensor(109)])
  call ol_merge_tensors(T0sum(195),[G0tensor(264)])
  call ol_merge_tensors(T0sum(196),[G0tensor(114)])
  call ol_merge_tensors(T0sum(197),[G0tensor(276)])
  call ol_merge_tensors(T0sum(198),[G0tensor(206)])
  call ol_merge_tensors(T0sum(199),[G0tensor(127)])
  call ol_merge_tensors(T0sum(200),[G0tensor(289)])
  call ol_merge_tensors(T0sum(201),[G0tensor(183)])
  call ol_merge_tensors(T0sum(202),[G0tensor(208)])
  call ol_merge_tensors(T0sum(203),[G0tensor(162)])
  call ol_merge_tensors(T0sum(204),[G0tensor(302)])
  call ol_merge_tensors(T0sum(205),[G0tensor(268)])
  call ol_merge_tensors(T0sum(206),[G0tensor(223)])
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(860),h0tab(:,860),[23,8],[nMW,nMW],3,2,wf4(:,17),wf3(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),wf4(:,17),wf3(:,3),G0H2(12),m4h4x3x2(:,1),heltab3x24(:,:,54))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(861),h0tab(:,861),[23,8],[nMW,nMW],3,2,wf4(:,17),wf3(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),wf4(:,17),wf3(:,3),G0H2(2),m4h4x3x2(:,2),heltab3x24(:,:,55))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(862),h0tab(:,862),[23,8],[nMW,nMW],3,2,wf4(:,18),wf3(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),wf4(:,18),wf3(:,3),G0H2(4),m4h4x3x2(:,3),heltab3x24(:,:,56))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(863),h0tab(:,863),[23,8],[nMW,nMW],3,2,wf4(:,18),wf3(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),wf4(:,18),wf3(:,3),G0H2(10),m4h4x3x2(:,4),heltab3x24(:,:,57))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(864),h0tab(:,864),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),wf3(:,1),wf4(:,17),G0H2(21),m4h3x4x2(:,17),heltab3x24(:,:,58))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(865),h0tab(:,865),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),wf3(:,1),wf4(:,18),G0H2(23),m4h3x4x2(:,18),heltab3x24(:,:,59))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(866),h0tab(:,866),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),wf3(:,1),wf4(:,17),G0H2(18),m4h3x4x2(:,19),heltab3x24(:,:,60))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(867),h0tab(:,867),[23,8],[nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),wf3(:,1),wf4(:,18),G0H2(15),m4h3x4x2(:,20),heltab3x24(:,:,61))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(868),h0tab(:,868),[23,8],[nMW,nMW],3,1,wf4(:,19))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),wf4(:,19),G0H2(17),m4h3x4x2(:,21),heltab3x24(:,:,62))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(869),h0tab(:,869),[23,8],[nMW,nMW],3,1,wf4(:,19))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),wf4(:,19),G0H2(13),m4h3x4x2(:,22),heltab3x24(:,:,63))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(870),h0tab(:,870),[23,8],[nMW,nMW],3,1,wf4(:,20))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf4(:,20),G0H2(48),m4h3x4x2(:,23),heltab3x24(:,:,64))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(871),h0tab(:,871),[23,8],[nMW,nMW],3,1,wf4(:,20))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf4(:,20),G0H2(47),m4h3x4x2(:,24),heltab3x24(:,:,65))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(872),h0tab(:,872),[28,3],[nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf3(:,3),G0H4(15),m4h2x3x4(:,2),heltab3x24(:,:,66))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(873),h0tab(:,873),[28,3],[nMW,nMW],3,2,wf3(:,3),wf4(:,17))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf3(:,3),G0H4(22),m4h2x3x4(:,3),heltab3x24(:,:,67))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(874),h0tab(:,874),[28,3],[nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf3(:,3),G0H4(26),m4h2x3x4(:,4),heltab3x24(:,:,68))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(875),h0tab(:,875),[28,3],[nMW,nMW],3,2,wf3(:,3),wf4(:,18))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf3(:,3),G0H4(4),m4h2x3x4(:,5),heltab3x24(:,:,69))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(876),h0tab(:,876),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf3(:,1),G0H4(5),m4h2x3x4(:,6),heltab3x24(:,:,70))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(877),h0tab(:,877),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf3(:,1),G0H4(6),m4h2x3x4(:,7),heltab3x24(:,:,71))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(878),h0tab(:,878),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf3(:,1),G0H4(1),m4h2x3x4(:,8),heltab3x24(:,:,72))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(879),h0tab(:,879),[28,3],[nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf3(:,1),G0H4(2),m4h2x3x4(:,9),heltab3x24(:,:,73))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(880),h0tab(:,880),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(238),m3h3x8(:,643),heltab2x24(:,:,807))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(881),h0tab(:,881),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(241),m3h3x8(:,644),heltab2x24(:,:,808))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(882),h0tab(:,882),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,17))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(243),m3h3x8(:,645),heltab2x24(:,:,809))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(883),h0tab(:,883),[20,11],[nMW,nMW],3,2,wf3(:,1),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(245),m3h3x8(:,646),heltab2x24(:,:,810))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(884),h0tab(:,884),[16,15],[nMW,nMW],3,1,wf4(:,19))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(85),m3h3x8(:,647),heltab2x24(:,:,811))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(885),h0tab(:,885),[16,15],[nMW,nMW],3,1,wf4(:,19))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(44),m3h3x8(:,648),heltab2x24(:,:,812))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(886),h0tab(:,886),[16,15],[nMW,nMW],3,1,wf4(:,20))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(128),m3h3x8(:,649),heltab2x24(:,:,813))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(887),h0tab(:,887),[16,15],[nMW,nMW],3,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(137),m3h3x8(:,650),heltab2x24(:,:,814))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(888),h0tab(:,888),[27,4],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf12(:,5),G0H1(1),m4h2x12x1(:,1),heltab3x24(:,:,74))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(889),h0tab(:,889),[27,4],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_VVS_S(ntryL,G0H24(1),ex4(:),wf12(:,5),G0H1(2),m4h2x12x1(:,2),heltab3x24(:,:,75))
  Gcoeff(:)%j = (c(115)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(890),h0tab(:,890),[24,7],[nMW,nMW],3,1,wf4(:,20))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(7),m4h3x2x4(:,19),heltab3x24(:,:,76))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(891),h0tab(:,891),[24,7],[nMW,nMW],3,1,wf4(:,20))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(3),m4h3x2x4(:,20),heltab3x24(:,:,77))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(892),h0tab(:,892),[23,8],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_SSS_S(ntryL,G0H24(1),ex3(:),wf12(:,5),G0H2(46),m4h1x12x2(:,1),heltab3x24(:,:,78))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(893),h0tab(:,893),[23,8],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_VSS_V(ntryL,G0H24(1),ex3(:),wf12(:,5),G0H2(45),m4h1x12x2(:,2),heltab3x24(:,:,79))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(894),h0tab(:,894),[19,12],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(152),m3h12x2(:,139),heltab2x24(:,:,815))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(895),h0tab(:,895),[19,12],[nMW,nMW],3,1,wf12(:,5))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf12(:,5),19,G1H2(72),m3h12x2(:,140),heltab2x24(:,:,816))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(896),h0tab(:,896),[27,4],[nMW,nMW],3,1,wf8(:,3))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,3),G0H1(3),m4h3x8x1(:,1),heltab3x24(:,:,80))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(897),h0tab(:,897),[27,4],[nMH,nMH],3,1,wf8(:,1))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,1),G0H1(4),m4h3x8x1(:,2),heltab3x24(:,:,81))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(898),h0tab(:,898),[27,4],[nMZ,nMZ],3,1,wf8(:,1))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,1),G0H1(5),m4h3x8x1(:,3),heltab3x24(:,:,82))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(899),h0tab(:,899),[27,4],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,1),G0H1(6),m4h3x8x1(:,4),heltab3x24(:,:,83))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(900),h0tab(:,900),[27,4],[nMW,nMW],3,1,wf8(:,3))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf8(:,3),G0H1(7),m4h3x8x1(:,5),heltab3x24(:,:,84))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(901),h0tab(:,901),[27,4],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf8(:,1),G0H1(8),m4h3x8x1(:,6),heltab3x24(:,:,85))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(902),h0tab(:,902),[27,4],[nMW,nMW],3,1,wf8(:,4))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,4),G0H1(9),m4h3x8x1(:,7),heltab3x24(:,:,86))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(903),h0tab(:,903),[27,4],[nMH,nMH],3,1,wf8(:,2))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,2),G0H1(10),m4h3x8x1(:,8),heltab3x24(:,:,87))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(904),h0tab(:,904),[27,4],[nMZ,nMZ],3,1,wf8(:,2))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,2),G0H1(11),m4h3x8x1(:,9),heltab3x24(:,:,88))
  Gcoeff(:)%j = (c(111)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(905),h0tab(:,905),[27,4],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),wf8(:,2),G0H1(12),m4h3x8x1(:,10),heltab3x24(:,:,89))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(906),h0tab(:,906),[27,4],[nMW,nMW],3,1,wf8(:,4))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf8(:,4),G0H1(13),m4h3x8x1(:,11),heltab3x24(:,:,90))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(907),h0tab(:,907),[27,4],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),wf8(:,2),G0H1(14),m4h3x8x1(:,12),heltab3x24(:,:,91))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(908),h0tab(:,908),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf12(:,1),G0H1(15),m4h2x12x1(:,3),heltab3x24(:,:,92))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(909),h0tab(:,909),[27,4],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf12(:,2),G0H1(16),m4h2x12x1(:,4),heltab3x24(:,:,93))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(910),h0tab(:,910),[27,4],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf12(:,1),G0H1(17),m4h2x12x1(:,5),heltab3x24(:,:,94))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(911),h0tab(:,911),[27,4],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf12(:,2),G0H1(18),m4h2x12x1(:,6),heltab3x24(:,:,95))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(912),h0tab(:,912),[27,4],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf12(:,3),G0H1(19),m4h2x12x1(:,7),heltab3x24(:,:,96))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(913),h0tab(:,913),[27,4],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SVV_S(ntryL,G0H24(1),ex4(:),wf12(:,4),G0H1(20),m4h2x12x1(:,8),heltab3x24(:,:,97))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(914),h0tab(:,914),[27,4],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf12(:,3),G0H1(21),m4h2x12x1(:,9),heltab3x24(:,:,98))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(915),h0tab(:,915),[27,4],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_VWW_V(ntryL,G0H24(1),ex4(:),wf12(:,4),G0H1(22),m4h2x12x1(:,10),heltab3x24(:,:,99))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(916),h0tab(:,916),[16,15],[nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(87),m3h3x8(:,651),heltab2x24(:,:,817))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(917),h0tab(:,917),[16,15],[nMW,nMW],3,1,wf8(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(45),m3h3x8(:,652),heltab2x24(:,:,818))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(918),h0tab(:,918),[16,15],[nMZ,nMH],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(1),m3h3x8(:,653),heltab2x24(:,:,819))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(919),h0tab(:,919),[16,15],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(16),m3h3x8(:,654),heltab2x24(:,:,820))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(920),h0tab(:,920),[16,15],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(20),m3h3x8(:,655),heltab2x24(:,:,821))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(921),h0tab(:,921),[20,11],[nMW,nMW],3,1,wf8(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(24),m4h3x1x8(:,9),heltab3x24(:,:,100))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(922),h0tab(:,922),[20,11],[nMW,nMW],3,1,wf8(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(49),m4h3x1x8(:,10),heltab3x24(:,:,101))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(923),h0tab(:,923),[20,11],[nMH,nMZ],3,1,wf8(:,1))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(34),m4h3x1x8(:,11),heltab3x24(:,:,102))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(924),h0tab(:,924),[20,11],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(51),m4h3x1x8(:,12),heltab3x24(:,:,103))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(925),h0tab(:,925),[20,11],[nMW,nMW],3,1,wf8(:,1))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(35),m4h3x1x8(:,13),heltab3x24(:,:,104))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(926),h0tab(:,926),[16,15],[nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(53),m3h3x8(:,656),heltab2x24(:,:,822))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(927),h0tab(:,927),[16,15],[nMW,nMW],3,1,wf8(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(36),m3h3x8(:,657),heltab2x24(:,:,823))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(928),h0tab(:,928),[16,15],[nMZ,nMH],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(2),m3h3x8(:,658),heltab2x24(:,:,824))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(929),h0tab(:,929),[16,15],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(37),m3h3x8(:,659),heltab2x24(:,:,825))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(930),h0tab(:,930),[16,15],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(4),m3h3x8(:,660),heltab2x24(:,:,826))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(931),h0tab(:,931),[20,11],[nMW,nMW],3,1,wf8(:,4))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(46),m4h3x1x8(:,14),heltab3x24(:,:,105))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(932),h0tab(:,932),[20,11],[nMW,nMW],3,1,wf8(:,4))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(5),m4h3x1x8(:,15),heltab3x24(:,:,106))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(933),h0tab(:,933),[20,11],[nMH,nMZ],3,1,wf8(:,2))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(47),m4h3x1x8(:,16),heltab3x24(:,:,107))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(934),h0tab(:,934),[20,11],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(7),m4h3x1x8(:,17),heltab3x24(:,:,108))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(935),h0tab(:,935),[20,11],[nMW,nMW],3,1,wf8(:,2))
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(48),m4h3x1x8(:,18),heltab3x24(:,:,109))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(936),h0tab(:,936),[23,8],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,1),ex3(:),G0H2(32),m4h12x1x2(:,1),heltab3x24(:,:,110))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(937),h0tab(:,937),[23,8],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,1),ex3(:),G0H2(31),m4h12x1x2(:,2),heltab3x24(:,:,111))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(938),h0tab(:,938),[23,8],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,2),ex3(:),G0H2(30),m4h12x1x2(:,3),heltab3x24(:,:,112))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(939),h0tab(:,939),[23,8],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,2),ex3(:),G0H2(29),m4h12x1x2(:,4),heltab3x24(:,:,113))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(940),h0tab(:,940),[23,8],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,3),ex3(:),G0H2(51),m4h12x1x2(:,5),heltab3x24(:,:,114))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(941),h0tab(:,941),[23,8],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,3),ex3(:),G0H2(49),m4h12x1x2(:,6),heltab3x24(:,:,115))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(942),h0tab(:,942),[23,8],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,4),ex3(:),G0H2(35),m4h12x1x2(:,7),heltab3x24(:,:,116))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(943),h0tab(:,943),[23,8],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_VVS_S(ntryL,G0H24(1),wf12(:,4),ex3(:),G0H2(33),m4h12x1x2(:,8),heltab3x24(:,:,117))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(944),h0tab(:,944),[19,12],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,1),G0H2(52),m3h12x2(:,141),heltab2x24(:,:,827))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(945),h0tab(:,945),[19,12],[nMW,nMW],3,1,wf12(:,1))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,1),G0H2(50),m3h12x2(:,142),heltab2x24(:,:,828))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(946),h0tab(:,946),[19,12],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,2),G0H2(36),m3h12x2(:,143),heltab2x24(:,:,829))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(947),h0tab(:,947),[19,12],[nMW,nMW],3,1,wf12(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,2),G0H2(34),m3h12x2(:,144),heltab2x24(:,:,830))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(948),h0tab(:,948),[19,12],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,3),G0H2(55),m3h12x2(:,145),heltab2x24(:,:,831))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(949),h0tab(:,949),[19,12],[nMW,nMW],3,1,wf12(:,3))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,3),G0H2(53),m3h12x2(:,146),heltab2x24(:,:,832))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(950),h0tab(:,950),[19,12],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,4),G0H2(39),m3h12x2(:,147),heltab2x24(:,:,833))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(951),h0tab(:,951),[19,12],[nMW,nMW],3,1,wf12(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),wf12(:,4),G0H2(37),m3h12x2(:,148),heltab2x24(:,:,834))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(952),h0tab(:,952),[20,11],[nML,nML],2,2,wf3(:,3),wf8(:,3))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(8),ngX,m3h3x8(:,661),heltab2x24(:,:,835))
  call Hloop_Q_A(ntryL,G0H8(8),20,nML,G1H8(157),n2h8(202))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(953),h0tab(:,953),[20,11],[nMT,nMT],2,2,wf3(:,3),wf8(:,3))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(50),ngX,m3h3x8(:,662),heltab2x24(:,:,836))
  call Hloop_Q_A(ntryL,G0H8(50),20,nMT,G1H8(17),n2h8(203))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(954),h0tab(:,954),[20,11],[nMB,nMB],2,2,wf3(:,3),wf8(:,3))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(76),ngX,m3h3x8(:,663),heltab2x24(:,:,837))
  call Hloop_Q_A(ntryL,G0H8(76),20,nMB,G1H8(5),n2h8(204))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(955),h0tab(:,955),[20,11],[nML,nML],2,2,wf3(:,3),wf8(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(74),ngX,m3h3x8(:,664),heltab2x24(:,:,838))
  call Hloop_Q_A(ntryL,G0H8(74),20,nML,G1H8(174),n2h8(205))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(956),h0tab(:,956),[20,11],[nMT,nMT],2,2,wf3(:,3),wf8(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(77),ngX,m3h3x8(:,665),heltab2x24(:,:,839))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMT,G1H8(167),n2h8(206))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(957),h0tab(:,957),[20,11],[nMB,nMB],2,2,wf3(:,3),wf8(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(75),ngX,m3h3x8(:,666),heltab2x24(:,:,840))
  call Hloop_Q_A(ntryL,G0H8(75),20,nMB,G1H8(97),n2h8(207))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(958),h0tab(:,958),[20,11],[nMH,nMZ],2,2,wf3(:,3),wf8(:,1))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(80),m3h3x8(:,667),heltab2x24(:,:,841))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(959),h0tab(:,959),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,3))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(78),m3h3x8(:,668),heltab2x24(:,:,842))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(960),h0tab(:,960),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,3))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(82),m3h3x8(:,669),heltab2x24(:,:,843))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(961),h0tab(:,961),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,1))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(79),m3h3x8(:,670),heltab2x24(:,:,844))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(962),h0tab(:,962),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,1))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(12),m3h3x8(:,671),heltab2x24(:,:,845))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(963),h0tab(:,963),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,3))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(124),m3h3x8(:,672),heltab2x24(:,:,846))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(964),h0tab(:,964),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,3))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(21),m3h3x8(:,673),heltab2x24(:,:,847))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(965),h0tab(:,965),[20,11],[nMH,nMZ],2,2,wf3(:,3),wf8(:,1))
  call Hloop_VS_T(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(1),m3h3x8(:,674),heltab2x24(:,:,848))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(966),h0tab(:,966),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(19),m3h3x8(:,675),heltab2x24(:,:,849))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(967),h0tab(:,967),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(170),m3h3x8(:,676),heltab2x24(:,:,850))
  Gcoeff(:)%j = (-(c(153)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(968),h0tab(:,968),[20,11],[0,0],2,2,wf3(:,1),wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(65),ngZl,m3h3x8(:,677),heltab2x24(:,:,851))
  call Hloop_Q_A(ntryL,G0H8(65),20,0,G1H8(172),n2h8(208))
  Gcoeff(:)%j = (-(c(149)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(969),h0tab(:,969),[20,11],[nML,nML],2,2,wf3(:,1),wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(88),ngZl,m3h3x8(:,678),heltab2x24(:,:,852))
  call Hloop_Q_A(ntryL,G0H8(88),20,nML,G1H8(177),n2h8(209))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(970),h0tab(:,970),[20,11],[0,0],2,2,wf3(:,1),wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(99),ngZu,m3h3x8(:,679),heltab2x24(:,:,853))
  call Hloop_Q_A(ntryL,G0H8(99),20,0,G1H8(175),n2h8(210))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(971),h0tab(:,971),[20,11],[nMT,nMT],2,2,wf3(:,1),wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(107),ngZu,m3h3x8(:,680),heltab2x24(:,:,854))
  call Hloop_Q_A(ntryL,G0H8(107),20,nMT,G1H8(176),n2h8(211))
  Gcoeff(:)%j = (-(c(147)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(972),h0tab(:,972),[20,11],[0,0],2,2,wf3(:,1),wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(105),ngZd,m3h3x8(:,681),heltab2x24(:,:,855))
  call Hloop_Q_A(ntryL,G0H8(105),20,0,G1H8(178),n2h8(212))
  Gcoeff(:)%j = (-(c(146)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(973),h0tab(:,973),[20,11],[nMB,nMB],2,2,wf3(:,1),wf8(:,3))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(110),ngZd,m3h3x8(:,682),heltab2x24(:,:,856))
  call Hloop_Q_A(ntryL,G0H8(110),20,nMB,G1H8(179),n2h8(213))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(974),h0tab(:,974),[20,11],[0,0],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(113),ngZn,m3h3x8(:,683),heltab2x24(:,:,857))
  call Hloop_Q_A(ntryL,G0H8(113),20,0,G1H8(180),n2h8(214))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(975),h0tab(:,975),[20,11],[0,0],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(6),ngZl,m3h3x8(:,684),heltab2x24(:,:,858))
  call Hloop_Q_A(ntryL,G0H8(6),20,0,G1H8(122),n2h8(215))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(976),h0tab(:,976),[20,11],[nML,nML],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(18),ngZl,m3h3x8(:,685),heltab2x24(:,:,859))
  call Hloop_Q_A(ntryL,G0H8(18),20,nML,G1H8(126),n2h8(216))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(977),h0tab(:,977),[20,11],[0,0],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(22),ngZu,m3h3x8(:,686),heltab2x24(:,:,860))
  call Hloop_Q_A(ntryL,G0H8(22),20,0,G1H8(130),n2h8(217))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(978),h0tab(:,978),[20,11],[nMT,nMT],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(25),ngZu,m3h3x8(:,687),heltab2x24(:,:,861))
  call Hloop_Q_A(ntryL,G0H8(25),20,nMT,G1H8(132),n2h8(218))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(979),h0tab(:,979),[20,11],[0,0],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(26),ngZd,m3h3x8(:,688),heltab2x24(:,:,862))
  call Hloop_Q_A(ntryL,G0H8(26),20,0,G1H8(134),n2h8(219))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(980),h0tab(:,980),[20,11],[nMB,nMB],2,2,wf3(:,1),wf8(:,1))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(27),ngZd,m3h3x8(:,689),heltab2x24(:,:,863))
  call Hloop_Q_A(ntryL,G0H8(27),20,nMB,G1H8(138),n2h8(220))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(981),h0tab(:,981),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,3))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(140),m3h3x8(:,690),heltab2x24(:,:,864))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(982),h0tab(:,982),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf8(:,1))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(142),m3h3x8(:,691),heltab2x24(:,:,865))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(983),h0tab(:,983),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,1))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(165),m3h3x8(:,692),heltab2x24(:,:,866))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(984),h0tab(:,984),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,3))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(166),m3h3x8(:,693),heltab2x24(:,:,867))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(985),h0tab(:,985),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,3))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(171),m3h3x8(:,694),heltab2x24(:,:,868))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(986),h0tab(:,986),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,1))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(169),m3h3x8(:,695),heltab2x24(:,:,869))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(987),h0tab(:,987),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,1))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(75),m3h3x8(:,696),heltab2x24(:,:,870))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(988),h0tab(:,988),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,3))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(76),m3h3x8(:,697),heltab2x24(:,:,871))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(989),h0tab(:,989),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,1))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(91),m3h3x8(:,698),heltab2x24(:,:,872))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(990),h0tab(:,990),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(28),m3h3x8(:,699),heltab2x24(:,:,873))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(991),h0tab(:,991),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,3))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(29),m3h3x8(:,700),heltab2x24(:,:,874))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(992),h0tab(:,992),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(30),m3h3x8(:,701),heltab2x24(:,:,875))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(993),h0tab(:,993),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(31),m3h3x8(:,702),heltab2x24(:,:,876))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(994),h0tab(:,994),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,1))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(32),m3h3x8(:,703),heltab2x24(:,:,877))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(995),h0tab(:,995),[22,9],[0,0],2,2,wf6(:,6),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H24(1),wf6(:,6),G0H4(8),m3h6x4(:,27),heltab2x24(:,:,878))
  call Hloop_A_Q(ntryL,G0H4(8),22,0,G1H4(9),n2h4(59))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(996),h0tab(:,996),[22,9],[0,nMZ],2,2,wf6(:,6),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H24(1),wf6(:,6),G0H4(10),ngZu,m3h6x4(:,28),heltab2x24(:,:,879))
  call Hloop_A_Q(ntryL,G0H4(10),22,0,G1H4(10),n2h4(60))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(997),h0tab(:,997),[22,9],[0,nMW],2,2,wf6(:,6),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,6),G0H4(12),m3h6x4(:,29),heltab2x24(:,:,880))
  call Hloop_A_Q(ntryL,G0H4(12),22,0,G1H4(19),n2h4(61))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(998),h0tab(:,998),[22,9],[0,0],2,2,wf6(:,6),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H24(1),wf6(:,6),G0H4(14),m3h6x4(:,30),heltab2x24(:,:,881))
  call Hloop_A_Q(ntryL,G0H4(14),22,0,G1H4(15),n2h4(62))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(999),h0tab(:,999),[20,11],[nML,nML],2,2,wf3(:,3),wf8(:,4))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(33),ngX,m3h3x8(:,704),heltab2x24(:,:,882))
  call Hloop_Q_A(ntryL,G0H8(33),20,nML,G1H8(93),n2h8(221))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1000),h0tab(:,1000),[20,11],[nMT,nMT],2,2,wf3(:,3),wf8(:,4))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(52),ngX,m3h3x8(:,705),heltab2x24(:,:,883))
  call Hloop_Q_A(ntryL,G0H8(52),20,nMT,G1H8(144),n2h8(222))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1001),h0tab(:,1001),[20,11],[nMB,nMB],2,2,wf3(:,3),wf8(:,4))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(54),ngX,m3h3x8(:,706),heltab2x24(:,:,884))
  call Hloop_Q_A(ntryL,G0H8(54),20,nMB,G1H8(146),n2h8(223))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1002),h0tab(:,1002),[20,11],[nML,nML],2,2,wf3(:,3),wf8(:,2))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(56),ngX,m3h3x8(:,707),heltab2x24(:,:,885))
  call Hloop_Q_A(ntryL,G0H8(56),20,nML,G1H8(148),n2h8(224))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1003),h0tab(:,1003),[20,11],[nMT,nMT],2,2,wf3(:,3),wf8(:,2))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(57),ngX,m3h3x8(:,708),heltab2x24(:,:,886))
  call Hloop_Q_A(ntryL,G0H8(57),20,nMT,G1H8(150),n2h8(225))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1004),h0tab(:,1004),[20,11],[nMB,nMB],2,2,wf3(:,3),wf8(:,2))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,3),G0H8(58),ngX,m3h3x8(:,709),heltab2x24(:,:,887))
  call Hloop_Q_A(ntryL,G0H8(58),20,nMB,G1H8(14),n2h8(226))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1005),h0tab(:,1005),[20,11],[nMH,nMZ],2,2,wf3(:,3),wf8(:,2))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(59),m3h3x8(:,710),heltab2x24(:,:,888))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1006),h0tab(:,1006),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,4))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(60),m3h3x8(:,711),heltab2x24(:,:,889))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1007),h0tab(:,1007),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,4))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(61),m3h3x8(:,712),heltab2x24(:,:,890))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1008),h0tab(:,1008),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,2))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(15),m3h3x8(:,713),heltab2x24(:,:,891))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1009),h0tab(:,1009),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,2))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,3),G0H8(62),m3h3x8(:,714),heltab2x24(:,:,892))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1010),h0tab(:,1010),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,4))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(25),m3h3x8(:,715),heltab2x24(:,:,893))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1011),h0tab(:,1011),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,4))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(29),m3h3x8(:,716),heltab2x24(:,:,894))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1012),h0tab(:,1012),[20,11],[nMH,nMZ],2,2,wf3(:,3),wf8(:,2))
  call Hloop_VS_T(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(30),m3h3x8(:,717),heltab2x24(:,:,895))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1013),h0tab(:,1013),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,2))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(3),m3h3x8(:,718),heltab2x24(:,:,896))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1014),h0tab(:,1014),[20,11],[nMW,nMW],2,2,wf3(:,3),wf8(:,2))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,3),20,G1H8(168),m3h3x8(:,719),heltab2x24(:,:,897))
  Gcoeff(:)%j = (-(c(153)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1015),h0tab(:,1015),[20,11],[0,0],2,2,wf3(:,1),wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(63),ngZl,m3h3x8(:,720),heltab2x24(:,:,898))
  call Hloop_Q_A(ntryL,G0H8(63),20,0,G1H8(173),n2h8(227))
  Gcoeff(:)%j = (-(c(149)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1016),h0tab(:,1016),[20,11],[nML,nML],2,2,wf3(:,1),wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(64),ngZl,m3h3x8(:,721),heltab2x24(:,:,899))
  call Hloop_Q_A(ntryL,G0H8(64),20,nML,G1H8(95),n2h8(228))
  Gcoeff(:)%j = (c(150)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1017),h0tab(:,1017),[20,11],[0,0],2,2,wf3(:,1),wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(89),ngZu,m3h3x8(:,722),heltab2x24(:,:,900))
  call Hloop_Q_A(ntryL,G0H8(89),20,0,G1H8(123),n2h8(229))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1018),h0tab(:,1018),[20,11],[nMT,nMT],2,2,wf3(:,1),wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(90),ngZu,m3h3x8(:,723),heltab2x24(:,:,901))
  call Hloop_Q_A(ntryL,G0H8(90),20,nMT,G1H8(20),n2h8(230))
  Gcoeff(:)%j = (-(c(147)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1019),h0tab(:,1019),[20,11],[0,0],2,2,wf3(:,1),wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(91),ngZd,m3h3x8(:,724),heltab2x24(:,:,902))
  call Hloop_Q_A(ntryL,G0H8(91),20,0,G1H8(22),n2h8(231))
  Gcoeff(:)%j = (-(c(146)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1020),h0tab(:,1020),[20,11],[nMB,nMB],2,2,wf3(:,1),wf8(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(92),ngZd,m3h3x8(:,725),heltab2x24(:,:,903))
  call Hloop_Q_A(ntryL,G0H8(92),20,nMB,G1H8(18),n2h8(232))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1021),h0tab(:,1021),[20,11],[0,0],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(93),ngZn,m3h3x8(:,726),heltab2x24(:,:,904))
  call Hloop_Q_A(ntryL,G0H8(93),20,0,G1H8(2),n2h8(233))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1022),h0tab(:,1022),[20,11],[0,0],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(94),ngZl,m3h3x8(:,727),heltab2x24(:,:,905))
  call Hloop_Q_A(ntryL,G0H8(94),20,0,G1H8(23),n2h8(234))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1023),h0tab(:,1023),[20,11],[nML,nML],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(95),ngZl,m3h3x8(:,728),heltab2x24(:,:,906))
  call Hloop_Q_A(ntryL,G0H8(95),20,nML,G1H8(4),n2h8(235))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1024),h0tab(:,1024),[20,11],[0,0],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(96),ngZu,m3h3x8(:,729),heltab2x24(:,:,907))
  call Hloop_Q_A(ntryL,G0H8(96),20,0,G1H8(7),n2h8(236))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1025),h0tab(:,1025),[20,11],[nMT,nMT],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(13),ngZu,m3h3x8(:,730),heltab2x24(:,:,908))
  call Hloop_Q_A(ntryL,G0H8(13),20,nMT,G1H8(32),n2h8(237))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1026),h0tab(:,1026),[20,11],[0,0],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(14),ngZd,m3h3x8(:,731),heltab2x24(:,:,909))
  call Hloop_Q_A(ntryL,G0H8(14),20,0,G1H8(34),n2h8(238))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1027),h0tab(:,1027),[20,11],[nMB,nMB],2,2,wf3(:,1),wf8(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,1),G0H8(66),ngZd,m3h3x8(:,732),heltab2x24(:,:,910))
  call Hloop_Q_A(ntryL,G0H8(66),20,nMB,G1H8(36),n2h8(239))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1028),h0tab(:,1028),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(37),m3h3x8(:,733),heltab2x24(:,:,911))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1029),h0tab(:,1029),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf8(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(39),m3h3x8(:,734),heltab2x24(:,:,912))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1030),h0tab(:,1030),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(42),m3h3x8(:,735),heltab2x24(:,:,913))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1031),h0tab(:,1031),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(44),m3h3x8(:,736),heltab2x24(:,:,914))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1032),h0tab(:,1032),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,4))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(47),m3h3x8(:,737),heltab2x24(:,:,915))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1033),h0tab(:,1033),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,2))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(48),m3h3x8(:,738),heltab2x24(:,:,916))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1034),h0tab(:,1034),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,2))
  call Hloop_CV_D(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(49),m3h3x8(:,739),heltab2x24(:,:,917))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1035),h0tab(:,1035),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(52),m3h3x8(:,740),heltab2x24(:,:,918))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1036),h0tab(:,1036),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(54),m3h3x8(:,741),heltab2x24(:,:,919))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1037),h0tab(:,1037),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(67),m3h3x8(:,742),heltab2x24(:,:,920))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1038),h0tab(:,1038),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(68),m3h3x8(:,743),heltab2x24(:,:,921))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1039),h0tab(:,1039),[20,11],[nMH,nMZ],2,2,wf3(:,1),wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(69),m3h3x8(:,744),heltab2x24(:,:,922))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1040),h0tab(:,1040),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(70),m3h3x8(:,745),heltab2x24(:,:,923))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1041),h0tab(:,1041),[20,11],[nMW,nMW],2,2,wf3(:,1),wf8(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,1),G0H8(71),m3h3x8(:,746),heltab2x24(:,:,924))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1042),h0tab(:,1042),[21,10],[0,0],2,2,wf6(:,8),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,8),G0H4(16),m3h6x4(:,31),heltab2x24(:,:,925))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1043),h0tab(:,1043),[21,10],[nMZ,0],2,2,wf6(:,8),wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,8),G0H4(17),ngZu,m3h6x4(:,32),heltab2x24(:,:,926))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1044),h0tab(:,1044),[21,10],[nMW,0],2,2,wf6(:,8),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,8),G0H4(18),m3h6x4(:,33),heltab2x24(:,:,927))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1045),h0tab(:,1045),[21,10],[0,0],2,2,wf6(:,8),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,8),G0H4(19),m3h6x4(:,34),heltab2x24(:,:,928))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(33),[G0H2(35),G0H2(49),G0H2(51),G0H2(29),G0H2(30) &
    ,G0H2(31),G0H2(32),G0H2(13),G0H2(17),G0H2(10),G0H2(4),G0H2(2),G0H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(46),[G0H2(48),G0H2(23),G0H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(45),[G0H2(47),G0H2(15),G0H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(22),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(4),[G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(44),[G0H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(2),[G0H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(152),G0H2(37),G0H2(39),G0H2(53),G0H2(55) &
    ,G0H2(34),G0H2(36),G0H2(50),G0H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(20),[G0H1(19),G0H1(16),G0H1(15),G0H1(12),G0H1(9),G0H1(6) &
    ,G0H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(10),[G0H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(11),[G0H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H1(22),[G0H1(21),G0H1(18),G0H1(17),G0H1(14),G0H1(13),G0H1(8) &
    ,G0H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(45),[G0H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(124),G0H8(29),G0H8(28),G0H8(49),G0H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G0H8(30),G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(170),[G1H8(19),G0H8(32),G0H8(31),G0H8(35),G0H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(36),[G0H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(4),[G0H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(25),G0H8(68),G0H8(67),G0H8(5),G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G0H8(69),G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(168),[G1H8(3),G0H8(71),G0H8(70),G0H8(48),G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(177),[G1H8(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(176),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(179),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(126),[G1H8(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G1H8(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(142),[G0H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G1H8(166),G0H8(82),G0H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(169),G0H8(12),G0H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(178),[G1H8(175),G1H8(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(95),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G0H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(44),G0H8(61),G0H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(48),G0H8(62),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(123),G1H8(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(19),[G0H4(16)])
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(33),ex4(:),G0tensor(20),m3h2x1(:,383),heltab2x2(:,:,477))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(46),23,ex4(:),8,G1tensor(86),m3h2x1(:,384),heltab2x2(:,:,478))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(45),23,ex4(:),8,G1tensor(91),m3h2x1(:,385),heltab2x2(:,:,479))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(22),wf4(:,17),G0tensor(45),m3h4x1(:,55),heltab2x4(:,:,165))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H4(4),wf4(:,18),G0tensor(70),m3h4x1(:,56),heltab2x4(:,:,166))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(5),28,wf4(:,17),3,G1tensor(96),m3h4x1(:,57),heltab2x4(:,:,167))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(6),28,wf4(:,18),3,G1tensor(101),m3h4x1(:,58),heltab2x4(:,:,168))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(1),28,wf4(:,17),3,G1tensor(106),m3h4x1(:,59),heltab2x4(:,:,169))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(2),28,wf4(:,18),3,G1tensor(111),m3h4x1(:,60),heltab2x4(:,:,170))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(238),ex4(:),wf4(:,17),G1tensor(116),m4h2x4x1(:,5),heltab3x8(:,:,17))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(241),ex4(:),wf4(:,18),G1tensor(121),m4h2x4x1(:,6),heltab3x8(:,:,18))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(243),ex4(:),wf4(:,17),G1tensor(126),m4h2x4x1(:,7),heltab3x8(:,:,19))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(245),ex4(:),wf4(:,18),G1tensor(131),m4h2x4x1(:,8),heltab3x8(:,:,20))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(44),ex4(:),wf4(:,19),G0tensor(95),m4h2x4x1(:,9),heltab3x8(:,:,21))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(128),ex4(:),wf4(:,20),G1tensor(136),m4h2x4x1(:,10),heltab3x8(:,:,22))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(137),ex4(:),wf4(:,20),G1tensor(141),m4h2x4x1(:,11),heltab3x8(:,:,23))
  call Hcheck_last_ST_V(ntryL,l_switch,G0H1(2),27,ex3(:),4,G1tensor(146),m3h1x1(:,135),heltab2x1(:,:,135))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(7),24,wf4(:,20),7,G1tensor(151),m3h4x1(:,61),heltab2x4(:,:,171))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(3),24,wf4(:,20),7,G1tensor(156),m3h4x1(:,62),heltab2x4(:,:,172))
  call Hcheck_last_VVS_S(ntryL,l_switch,G1H2(72),ex4(:),ex3(:),G1tensor(161),m4h2x1x1(:,4),heltab3x2(:,:,5))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(20),ex3(:),G0tensor(120),m3h1x1(:,136),heltab2x1(:,:,136))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(10),ex3(:),G0tensor(145),m3h1x1(:,137),heltab2x1(:,:,137))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H1(11),ex3(:),G0tensor(170),m3h1x1(:,138),heltab2x1(:,:,138))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H1(22),ex3(:),G0tensor(195),m3h1x1(:,139),heltab2x1(:,:,139))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(45),wf8(:,3),ex3(:),G0tensor(220),m4h8x1x1(:,1),heltab3x8(:,:,24))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(1),wf8(:,1),ex3(:),G0tensor(245),m4h8x1x1(:,2),heltab3x8(:,:,25))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(20),wf8(:,1),ex3(:),G0tensor(270),m4h8x1x1(:,3),heltab3x8(:,:,26))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(21),wf8(:,3),G1tensor(166),m3h8x1(:,65),heltab2x8(:,:,687))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(1),wf8(:,1),G1tensor(171),m3h8x1(:,66),heltab2x8(:,:,688))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(170),wf8(:,1),G1tensor(176),m3h8x1(:,67),heltab2x8(:,:,689))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(36),wf8(:,4),ex3(:),G0tensor(1),m4h8x1x1(:,4),heltab3x8(:,:,27))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(2),wf8(:,2),ex3(:),G0tensor(6),m4h8x1x1(:,5),heltab3x8(:,:,28))
  call Hcheck_last_VVS_S(ntryL,l_switch,G0H8(4),wf8(:,2),ex3(:),G0tensor(300),m4h8x1x1(:,6),heltab3x8(:,:,29))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(29),wf8(:,4),G1tensor(181),m3h8x1(:,68),heltab2x8(:,:,690))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(30),wf8(:,2),G1tensor(186),m3h8x1(:,69),heltab2x8(:,:,691))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H8(168),wf8(:,2),G1tensor(191),m3h8x1(:,70),heltab2x8(:,:,692))
  call Hloop_QV_A(ntryL,G1H8(177),wf8(:,3),G1H1(12),m3h8x1(:,71),heltab2x8(:,:,693))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nML,G2tensor(222),n2h1(303))
  call Hloop_QV_A(ntryL,G1H8(176),wf8(:,3),G1H1(37),m3h8x1(:,72),heltab2x8(:,:,694))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,nMT,G2tensor(228),n2h1(304))
  call Hloop_QV_A(ntryL,G1H8(179),wf8(:,3),G1H1(28),m3h8x1(:,73),heltab2x8(:,:,695))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(234),n2h1(305))
  call Hloop_QZ_A(ntryL,G1H8(126),wf8(:,1),G1H1(21),ngZl,m3h8x1(:,74),heltab2x8(:,:,696))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nML,G2tensor(240),n2h1(306))
  call Hloop_QZ_A(ntryL,G1H8(132),wf8(:,1),G1H1(36),ngZu,m3h8x1(:,75),heltab2x8(:,:,697))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),31,nMT,G2tensor(246),n2h1(307))
  call Hloop_QZ_A(ntryL,G1H8(138),wf8(:,1),G1H1(42),ngZd,m3h8x1(:,76),heltab2x8(:,:,698))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),31,nMB,G2tensor(252),n2h1(308))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(142),20,wf8(:,1),11,G2tensor(258),m3h8x1(:,77),heltab2x8(:,:,699))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(171),20,wf8(:,3),11,G2tensor(264),m3h8x1(:,78),heltab2x8(:,:,700))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(75),20,wf8(:,1),11,G2tensor(116),m3h8x1(:,79),heltab2x8(:,:,701))
  call Hloop_QV_A(ntryL,G1H8(178),wf8(:,3),G1H1(8),m3h8x1(:,80),heltab2x8(:,:,702))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,0,G2tensor(113),n2h1(309))
  call Hloop_QZ_A(ntryL,G1H8(180),wf8(:,1),G1H1(20),ngZn,m3h8x1(:,81),heltab2x8(:,:,703))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,0,G2tensor(55),n2h1(310))
  call Hloop_QZ_A(ntryL,G1H8(122),wf8(:,1),G1H1(27),ngZl,m3h8x1(:,82),heltab2x8(:,:,704))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,0,G2tensor(67),n2h1(311))
  call Hloop_QZ_A(ntryL,G1H8(130),wf8(:,1),G1H1(33),ngZu,m3h8x1(:,83),heltab2x8(:,:,705))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(33),31,0,G2tensor(34),n2h1(312))
  call Hloop_QZ_A(ntryL,G1H8(134),wf8(:,1),G1H1(15),ngZd,m3h8x1(:,84),heltab2x8(:,:,706))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),31,0,G2tensor(46),n2h1(313))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(140),20,wf8(:,3),11,G2tensor(91),m3h8x1(:,85),heltab2x8(:,:,707))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(165),20,wf8(:,1),11,G2tensor(11),m3h8x1(:,86),heltab2x8(:,:,708))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(76),20,wf8(:,3),11,G2tensor(93),m3h8x1(:,87),heltab2x8(:,:,709))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(91),20,wf8(:,1),11,G2tensor(147),m3h8x1(:,88),heltab2x8(:,:,710))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(15),wf4(:,2),G1tensor(196),m3h4x1(:,63),heltab2x4(:,:,173))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(10),wf4(:,2),G1tensor(201),ngZu,m3h4x1(:,64),heltab2x4(:,:,174))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(19),wf4(:,2),G1tensor(206),m3h4x1(:,65),heltab2x4(:,:,175))
  call Hloop_QV_A(ntryL,G1H8(95),wf8(:,4),G1H1(41),m3h8x1(:,89),heltab2x8(:,:,711))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,nML,G2tensor(13),n2h1(314))
  call Hloop_QV_A(ntryL,G1H8(20),wf8(:,4),G1H1(39),m3h8x1(:,90),heltab2x8(:,:,712))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,nMT,G2tensor(150),n2h1(315))
  call Hloop_QV_A(ntryL,G1H8(18),wf8(:,4),G1H1(17),m3h8x1(:,91),heltab2x8(:,:,713))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(48),n2h1(316))
  call Hloop_QZ_A(ntryL,G1H8(4),wf8(:,2),G1H1(3),ngZl,m3h8x1(:,92),heltab2x8(:,:,714))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),31,nML,G2tensor(111),n2h1(317))
  call Hloop_QZ_A(ntryL,G1H8(32),wf8(:,2),G1H1(40),ngZu,m3h8x1(:,93),heltab2x8(:,:,715))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),31,nMT,G2tensor(51),n2h1(318))
  call Hloop_QZ_A(ntryL,G1H8(36),wf8(:,2),G1H1(34),ngZd,m3h8x1(:,94),heltab2x8(:,:,716))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),31,nMB,G2tensor(112),n2h1(319))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(39),20,wf8(:,2),11,G2tensor(95),m3h8x1(:,95),heltab2x8(:,:,717))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(47),20,wf8(:,4),11,G2tensor(57),m3h8x1(:,96),heltab2x8(:,:,718))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H8(49),20,wf8(:,2),11,G2tensor(114),m3h8x1(:,97),heltab2x8(:,:,719))
  call Hloop_QV_A(ntryL,G1H8(22),wf8(:,4),G1H1(38),m3h8x1(:,98),heltab2x8(:,:,720))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),31,0,G2tensor(60),n2h1(320))
  call Hloop_QZ_A(ntryL,G1H8(2),wf8(:,2),G1H1(25),ngZn,m3h8x1(:,99),heltab2x8(:,:,721))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,0,G2tensor(115),n2h1(321))
  call Hloop_QZ_A(ntryL,G1H8(23),wf8(:,2),G1H1(26),ngZl,m3h8x1(:,100),heltab2x8(:,:,722))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),31,0,G2tensor(98),n2h1(322))
  call Hloop_QZ_A(ntryL,G1H8(7),wf8(:,2),G1H1(10),ngZu,m3h8x1(:,101),heltab2x8(:,:,723))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,0,G2tensor(117),n2h1(323))
  call Hloop_QZ_A(ntryL,G1H8(34),wf8(:,2),G1H1(6),ngZd,m3h8x1(:,102),heltab2x8(:,:,724))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,0,G2tensor(99),n2h1(324))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(37),20,wf8(:,4),11,G2tensor(70),m3h8x1(:,103),heltab2x8(:,:,725))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H8(42),20,wf8(:,2),11,G2tensor(180),m3h8x1(:,104),heltab2x8(:,:,726))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(52),20,wf8(:,4),11,G2tensor(7),m3h8x1(:,105),heltab2x8(:,:,727))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H8(54),20,wf8(:,2),11,G2tensor(168),m3h8x1(:,106),heltab2x8(:,:,728))
  call Hloop_VA_Q(ntryL,G0H4(19),wf4(:,4),G0H1(1),m3h4x1(:,66),heltab2x4(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(211),n2h1(325))
  call Hloop_ZA_Q(ntryL,G0H4(17),wf4(:,4),G0H1(19),ngZu,m3h4x1(:,67),heltab2x4(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(19),31,0,G1tensor(216),n2h1(326))
  call Hloop_WA_Q(ntryL,G0H4(18),wf4(:,4),G0H1(16),m3h4x1(:,68),heltab2x4(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(16),31,0,G1tensor(221),n2h1(327))
  call ol_merge_tensors(G0tensor(462),[G0tensor(421),G0tensor(381),G0tensor(243),G0tensor(28),G0tensor(369),G0tensor(2) &
    ,G0tensor(25)])
  call ol_merge_tensors(G0tensor(581),[G0tensor(272),G0tensor(111),G0tensor(119),G0tensor(30)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(7),G2tensor(180),G2tensor(70),G2tensor(114),G2tensor(57),G2tensor(147) &
    ,G2tensor(93),G2tensor(11),G2tensor(91),G2tensor(116),G2tensor(264),G1tensor(191),G1tensor(181),G1tensor(176),G1tensor(166) &
    ,G1tensor(131),G1tensor(126),G1tensor(121),G1tensor(116),G0tensor(493),G0tensor(76),G0tensor(186),G0tensor(340),G0tensor(285) &
    ,G0tensor(230),G0tensor(35)])
  call ol_merge_tensors(G0tensor(614),[G0tensor(609),G0tensor(604),G0tensor(594),G0tensor(584),G0tensor(579),G0tensor(574) &
    ,G0tensor(569),G0tensor(564),G0tensor(559),G0tensor(554),G0tensor(549),G0tensor(544),G0tensor(539),G0tensor(534),G0tensor(494) &
    ,G0tensor(489),G0tensor(484),G0tensor(479),G0tensor(474),G0tensor(469),G0tensor(464),G0tensor(424),G0tensor(419),G0tensor(414) &
    ,G0tensor(409),G0tensor(404),G0tensor(399),G0tensor(394),G0tensor(389),G0tensor(384),G0tensor(379),G0tensor(10),G0tensor(353) &
    ,G0tensor(347),G0tensor(333),G0tensor(303),G0tensor(297),G0tensor(282),G0tensor(258),G0tensor(103),G0tensor(239),G0tensor(72) &
    ,G0tensor(166),G0tensor(81),G0tensor(53),G0tensor(106),G0tensor(43),G0tensor(32),G0tensor(39),G0tensor(27),G0tensor(326) &
    ,G0tensor(316),G0tensor(304),G0tensor(46),G0tensor(184),G0tensor(345),G0tensor(320),G0tensor(295),G0tensor(5),G0tensor(290) &
    ,G0tensor(265),G0tensor(240),G0tensor(65),G0tensor(40)])
  call ol_merge_tensors(G1tensor(111),[G1tensor(106),G1tensor(101),G1tensor(96),G0tensor(70),G0tensor(45),G0tensor(330) &
    ,G0tensor(305),G0tensor(8),G0tensor(4),G0tensor(260),G0tensor(50)])
  call ol_merge_tensors(G1tensor(161),[G0tensor(606),G0tensor(392),G0tensor(387),G0tensor(86),G0tensor(176),G0tensor(55)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(136),G0tensor(300),G0tensor(1),G0tensor(270),G0tensor(220),G0tensor(95) &
    ,G0tensor(383),G0tensor(378),G0tensor(368),G0tensor(343),G0tensor(308),G0tensor(288),G0tensor(211),G0tensor(177),G0tensor(235) &
    ,G0tensor(60)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(226),G0tensor(131),G0tensor(75)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(108),G0tensor(80)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(112),G0tensor(160),G0tensor(85)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(128),G0tensor(279),G0tensor(266),G0tensor(21),G0tensor(11),G0tensor(362) &
    ,G0tensor(165),G0tensor(90)])
  call ol_merge_tensors(G0tensor(199),[G0tensor(13),G0tensor(367),G0tensor(100)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(269),G0tensor(105)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(137),G0tensor(185),G0tensor(110)])
  call ol_merge_tensors(G0tensor(148),[G0tensor(138),G0tensor(117),G0tensor(134),G0tensor(154),G0tensor(256),G0tensor(341) &
    ,G0tensor(190),G0tensor(115)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(51),G0tensor(351),G0tensor(125)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(201),G0tensor(130)])
  call ol_merge_tensors(G0tensor(222),[G0tensor(167),G0tensor(210),G0tensor(135)])
  call ol_merge_tensors(G0tensor(213),[G0tensor(168),G0tensor(147),G0tensor(122),G0tensor(232),G0tensor(18),G0tensor(366) &
    ,G0tensor(215),G0tensor(140)])
  call ol_merge_tensors(G0tensor(291),[G0tensor(259),G0tensor(261),G0tensor(262),G0tensor(82),G0tensor(150)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(13),G2tensor(240),G2tensor(222),G0tensor(274),G0tensor(57),G0tensor(155)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(157),G0tensor(284),G0tensor(22),G0tensor(292),G0tensor(175)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(150),G2tensor(246),G2tensor(228),G0tensor(271),G0tensor(372),G0tensor(180)])
  call ol_merge_tensors(G0tensor(158),[G0tensor(286),G0tensor(118),G0tensor(34),G0tensor(16),G0tensor(200)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(48),G2tensor(252),G2tensor(234),G0tensor(123),G0tensor(361),G0tensor(205)])
  call ol_merge_tensors(G1tensor(146),[G0tensor(195),G0tensor(120),G0tensor(582),G0tensor(562),G0tensor(541),G0tensor(471) &
    ,G0tensor(417),G0tensor(402),G0tensor(293),G0tensor(252),G0tensor(71),G0tensor(156),G0tensor(159),G0tensor(310),G0tensor(7) &
    ,G0tensor(225)])
  call ol_merge_tensors(G0tensor(612),[G0tensor(607),G0tensor(532),G0tensor(406),G0tensor(348),G0tensor(283),G0tensor(102) &
    ,G0tensor(234),G0tensor(121),G0tensor(299),G0tensor(275),G0tensor(250)])
  call ol_merge_tensors(G0tensor(551),[G0tensor(536),G0tensor(492),G0tensor(487),G0tensor(412),G0tensor(401),G0tensor(386) &
    ,G0tensor(321),G0tensor(309),G0tensor(296),G0tensor(255)])
  call ol_merge_tensors(G1tensor(206),[G0tensor(571),G0tensor(561),G0tensor(488),G0tensor(313),G0tensor(244),G0tensor(324) &
    ,G0tensor(280)])
  call ol_merge_tensors(G0tensor(481),[G0tensor(466),G0tensor(416),G0tensor(397),G0tensor(391),G0tensor(49),G0tensor(116) &
    ,G0tensor(281),G0tensor(14),G0tensor(364),G0tensor(3)])
  call ol_merge_tensors(G1tensor(156),[G1tensor(151),G0tensor(423),G0tensor(413),G0tensor(408),G0tensor(398),G0tensor(161) &
    ,G0tensor(315),G0tensor(9)])
  call ol_merge_tensors(G1tensor(91),[G1tensor(86),G0tensor(20),G0tensor(577),G0tensor(566),G0tensor(557),G0tensor(87) &
    ,G0tensor(64),G0tensor(202),G0tensor(37),G0tensor(129),G0tensor(329),G0tensor(335)])
  call ol_merge_tensors(G0tensor(246),[G0tensor(94),G0tensor(171),G0tensor(355)])
  call ol_merge_tensors(G0tensor(191),[G0tensor(66),G0tensor(151),G0tensor(360)])
  call ol_merge_tensors(G0tensor(101),[G0tensor(301),G0tensor(44),G0tensor(59),G0tensor(374),G0tensor(38),G0tensor(365)])
  call ol_merge_tensors(G1tensor(196),[G0tensor(196),G0tensor(124)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(117),G2tensor(98),G2tensor(115),G2tensor(60),G2tensor(46),G2tensor(34),G2tensor(67) &
    ,G2tensor(55),G2tensor(113),G0tensor(249),G0tensor(241),G0tensor(314),G0tensor(146),G0tensor(42),G0tensor(52),G0tensor(339) &
    ,G0tensor(69)])
  call ol_merge_tensors(G0tensor(456),[G0tensor(441),G0tensor(426),G0tensor(334),G0tensor(149)])
  call ol_merge_tensors(G0tensor(437),[G0tensor(432),G0tensor(73),G0tensor(139)])
  call ol_merge_tensors(G0tensor(599),[G0tensor(589),G0tensor(529),G0tensor(524),G0tensor(519),G0tensor(514),G0tensor(509) &
    ,G0tensor(504),G0tensor(499),G0tensor(459),G0tensor(454),G0tensor(449),G0tensor(444),G0tensor(439),G0tensor(434),G0tensor(429) &
    ,G0tensor(247),G0tensor(238),G0tensor(84),G0tensor(214),G0tensor(68),G0tensor(136),G0tensor(359),G0tensor(33)])
  call ol_merge_tensors(G0tensor(452),[G0tensor(447),G0tensor(74),G0tensor(354)])
  call ol_merge_tensors(G0tensor(477),[G0tensor(472),G0tensor(376),G0tensor(141),G0tensor(164),G0tensor(56)])
  call ol_merge_tensors(G1tensor(211),[G0tensor(251),G0tensor(61)])
  call ol_merge_tensors(G0tensor(526),[G0tensor(511),G0tensor(496),G0tensor(48),G0tensor(181)])
  call ol_merge_tensors(G0tensor(507),[G0tensor(502),G0tensor(231),G0tensor(54)])
  call ol_merge_tensors(G1tensor(216),[G0tensor(522),G0tensor(517),G0tensor(236),G0tensor(182)])
  call ol_merge_tensors(G1tensor(221),[G0tensor(547),G0tensor(542),G0tensor(491),G0tensor(338),G0tensor(88),G0tensor(204) &
    ,G0tensor(311)])
  call ol_merge_tensors(G0tensor(294),[G0tensor(193),G0tensor(104),G0tensor(126)])
  call ol_merge_tensors(G0tensor(173),[G0tensor(163),G0tensor(113),G0tensor(336)])
  call ol_merge_tensors(G0tensor(212),[G0tensor(203),G0tensor(142),G0tensor(356)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(91),G0tensor(41)])
  call ol_merge_tensors(G0tensor(198),[G0tensor(23),G0tensor(287)])
  call ol_merge_tensors(G0tensor(217),[G0tensor(307),G0tensor(189)])
  call ol_merge_tensors(G0tensor(602),[G0tensor(597),G0tensor(592),G0tensor(587),G0tensor(486),G0tensor(373),G0tensor(312) &
    ,G0tensor(98),G0tensor(96),G0tensor(92),G0tensor(83),G0tensor(78),G0tensor(221),G0tensor(192),G0tensor(174),G0tensor(26)])
  call ol_merge_tensors(G0tensor(538),[G0tensor(533),G0tensor(513),G0tensor(508),G0tensor(468),G0tensor(463),G0tensor(443) &
    ,G0tensor(438),G0tensor(219)])
  call ol_merge_tensors(G0tensor(613),[G0tensor(573),G0tensor(553),G0tensor(548),G0tensor(528),G0tensor(523),G0tensor(483) &
    ,G0tensor(478),G0tensor(458),G0tensor(453),G0tensor(224)])
  call ol_merge_tensors(G0tensor(145),[G0tensor(263)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(258),G1tensor(186),G1tensor(171),G0tensor(253)])
  call ol_merge_tensors(G0tensor(317),[G0tensor(233)])
  call ol_merge_tensors(G0tensor(170),[G0tensor(516),G0tensor(501),G0tensor(497),G0tensor(446),G0tensor(431),G0tensor(427) &
    ,G0tensor(218)])
  call ol_merge_tensors(G0tensor(6),[G0tensor(245),G0tensor(228)])
  call ol_merge_tensors(G0tensor(591),[G0tensor(467),G0tensor(396),G0tensor(277),G0tensor(267)])
  call ol_merge_tensors(G0tensor(601),[G0tensor(572),G0tensor(567),G0tensor(537),G0tensor(411),G0tensor(318),G0tensor(278)])
  call ol_merge_tensors(G0tensor(556),[G0tensor(546),G0tensor(531),G0tensor(407),G0tensor(403),G0tensor(342),G0tensor(328)])
  call ol_merge_tensors(G0tensor(611),[G0tensor(563),G0tensor(558),G0tensor(388),G0tensor(352),G0tensor(332)])
  call ol_merge_tensors(G0tensor(576),[G0tensor(476),G0tensor(461),G0tensor(422),G0tensor(418),G0tensor(377),G0tensor(358)])
  call ol_merge_tensors(G0tensor(583),[G0tensor(578),G0tensor(393),G0tensor(382),G0tensor(15)])
  call ol_merge_tensors(G0tensor(451),[G0tensor(436),G0tensor(428)])
  call ol_merge_tensors(G0tensor(586),[G0tensor(442),G0tensor(433)])
  call ol_merge_tensors(G0tensor(588),[G0tensor(457),G0tensor(448)])
  call ol_merge_tensors(G0tensor(593),[G0tensor(482),G0tensor(473)])
  call ol_merge_tensors(G0tensor(521),[G0tensor(506),G0tensor(498)])
  call ol_merge_tensors(G0tensor(596),[G0tensor(512),G0tensor(503)])
  call ol_merge_tensors(G0tensor(598),[G0tensor(527),G0tensor(518)])
  call ol_merge_tensors(G0tensor(608),[G0tensor(603),G0tensor(568),G0tensor(552),G0tensor(543)])
call TI_bubble_red(G2tensor(168),20,mass2set(:,1),G0tensor(325),M2L1R1,G0tensor(350))
call TI_bubble_red(G2tensor(111),20,mass2set(:,2),G0tensor(370),M2L1R1,G0tensor(12))
call TI_bubble_red(G2tensor(51),20,mass2set(:,3),G0tensor(349),M2L1R1,G0tensor(344))
call TI_bubble_red(G2tensor(112),20,mass2set(:,4),G0tensor(19),M2L1R1,G0tensor(31))
call TI_bubble_red(G2tensor(99),20,mass2set(:,5),G0tensor(17),M2L1R1)
call TI_bubble_red(G2tensor(95),20,mass2set(:,6),G0tensor(36),M2L1R1,G0tensor(63),G0tensor(58))
  call ol_merge_tensors(G0tensor(614),[G0tensor(350)])
  call ol_merge_tensors(G0tensor(12),[G0tensor(188)])
  call ol_merge_tensors(G0tensor(344),[G0tensor(148)])
  call ol_merge_tensors(G0tensor(31),[G0tensor(213)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(599)])
  call ol_merge_tensors(G0tensor(317),[G0tensor(58)])
call TI_bubble_red(G1tensor(111),28,mass2set(:,1),G0tensor(306),M2L1R1,G0tensor(319))
call TI_bubble_red(G1tensor(161),19,mass2set(:,1),G0tensor(187),M2L1R1,G0tensor(331))
call TI_bubble_red(G1tensor(141),16,mass2set(:,1),G0tensor(346),M2L1R1,G0tensor(371))
call TI_bubble_red(G1tensor(146),27,mass2set(:,1),G0tensor(179),M2L1R1,G0tensor(107))
call TI_bubble_red(G1tensor(206),22,mass2set(:,7),G0tensor(322),M2L1R1,G0tensor(194))
call TI_bubble_red(G1tensor(156),24,mass2set(:,1),G0tensor(144),M2L1R1,G0tensor(242))
call TI_bubble_red(G1tensor(91),23,mass2set(:,1),G0tensor(327),M2L1R1,G0tensor(273))
call TI_bubble_red(G1tensor(196),22,mass2set(:,5),G0tensor(323),M2L1R1)
call TI_bubble_red(G1tensor(211),21,mass2set(:,5),G0tensor(227),M2L1R1)
call TI_bubble_red(G1tensor(216),21,mass2set(:,8),G0tensor(298),M2L1R1,G0tensor(337))
call TI_bubble_red(G1tensor(221),21,mass2set(:,9),G0tensor(363),M2L1R1,G0tensor(209))
call TI_bubble_red(G1tensor(201),22,mass2set(:,10),G0tensor(357),M2L1R1,G0tensor(375))
  call ol_merge_tensors(G0tensor(209),[G0tensor(273),G0tensor(242),G0tensor(194),G0tensor(107),G0tensor(371),G0tensor(331) &
    ,G0tensor(319),G0tensor(614)])
  call ol_merge_tensors(G0tensor(375),[G0tensor(337),G0tensor(63)])
  call ol_merge_tensors(T0sum(207),[G0tensor(462)])
  call ol_merge_tensors(T0sum(208),[G0tensor(581)])
  call ol_merge_tensors(T0sum(209),[G0tensor(325)])
  call ol_merge_tensors(T0sum(210),[G0tensor(209)])
  call ol_merge_tensors(T0sum(211),[G0tensor(306)])
  call ol_merge_tensors(T0sum(212),[G0tensor(187)])
  call ol_merge_tensors(T0sum(213),[G0tensor(346)])
  call ol_merge_tensors(T0sum(214),[G0tensor(257)])
  call ol_merge_tensors(T0sum(215),[G0tensor(152)])
  call ol_merge_tensors(T0sum(216),[G0tensor(133)])
  call ol_merge_tensors(T0sum(217),[G0tensor(12)])
  call ol_merge_tensors(T0sum(218),[G0tensor(199)])
  call ol_merge_tensors(T0sum(219),[G0tensor(143)])
  call ol_merge_tensors(T0sum(220),[G0tensor(153)])
  call ol_merge_tensors(T0sum(221),[G0tensor(344)])
  call ol_merge_tensors(T0sum(222),[G0tensor(24)])
  call ol_merge_tensors(T0sum(223),[G0tensor(172)])
  call ol_merge_tensors(T0sum(224),[G0tensor(222)])
  call ol_merge_tensors(T0sum(225),[G0tensor(31)])
  call ol_merge_tensors(T0sum(226),[G0tensor(291)])
  call ol_merge_tensors(T0sum(227),[G0tensor(370)])
  call ol_merge_tensors(T0sum(228),[G0tensor(178)])
  call ol_merge_tensors(T0sum(229),[G0tensor(349)])
  call ol_merge_tensors(T0sum(230),[G0tensor(158)])
  call ol_merge_tensors(T0sum(231),[G0tensor(19)])
  call ol_merge_tensors(T0sum(232),[G0tensor(179)])
  call ol_merge_tensors(T0sum(233),[G0tensor(612)])
  call ol_merge_tensors(T0sum(234),[G0tensor(551)])
  call ol_merge_tensors(T0sum(235),[G0tensor(322)])
  call ol_merge_tensors(T0sum(236),[G0tensor(481)])
  call ol_merge_tensors(T0sum(237),[G0tensor(144)])
  call ol_merge_tensors(T0sum(238),[G0tensor(327)])
  call ol_merge_tensors(T0sum(239),[G0tensor(246)])
  call ol_merge_tensors(T0sum(240),[G0tensor(191)])
  call ol_merge_tensors(T0sum(241),[G0tensor(101)])
  call ol_merge_tensors(T0sum(242),[G0tensor(323)])
  call ol_merge_tensors(T0sum(243),[G0tensor(17)])
  call ol_merge_tensors(T0sum(244),[G0tensor(456)])
  call ol_merge_tensors(T0sum(245),[G0tensor(437)])
  call ol_merge_tensors(T0sum(246),[G0tensor(375)])
  call ol_merge_tensors(T0sum(247),[G0tensor(452)])
  call ol_merge_tensors(T0sum(248),[G0tensor(477)])
  call ol_merge_tensors(T0sum(249),[G0tensor(227)])
  call ol_merge_tensors(T0sum(250),[G0tensor(526)])
  call ol_merge_tensors(T0sum(251),[G0tensor(507)])
  call ol_merge_tensors(T0sum(252),[G0tensor(298)])
  call ol_merge_tensors(T0sum(253),[G0tensor(363)])
  call ol_merge_tensors(T0sum(254),[G0tensor(294)])
  call ol_merge_tensors(T0sum(255),[G0tensor(173)])
  call ol_merge_tensors(T0sum(256),[G0tensor(212)])
  call ol_merge_tensors(T0sum(257),[G0tensor(132)])
  call ol_merge_tensors(T0sum(258),[G0tensor(198)])
  call ol_merge_tensors(T0sum(259),[G0tensor(217)])
  call ol_merge_tensors(T0sum(260),[G0tensor(602)])
  call ol_merge_tensors(T0sum(261),[G0tensor(538)])
  call ol_merge_tensors(T0sum(262),[G0tensor(613)])
  call ol_merge_tensors(T0sum(263),[G0tensor(145)])
  call ol_merge_tensors(T0sum(264),[G0tensor(36)])
  call ol_merge_tensors(T0sum(265),[G0tensor(317)])
  call ol_merge_tensors(T0sum(266),[G0tensor(248)])
  call ol_merge_tensors(T0sum(267),[G0tensor(170)])
  call ol_merge_tensors(T0sum(268),[G0tensor(237)])
  call ol_merge_tensors(T0sum(269),[G0tensor(6)])
  call ol_merge_tensors(T0sum(270),[G0tensor(591)])
  call ol_merge_tensors(T0sum(271),[G0tensor(601)])
  call ol_merge_tensors(T0sum(272),[G0tensor(556)])
  call ol_merge_tensors(T0sum(273),[G0tensor(611)])
  call ol_merge_tensors(T0sum(274),[G0tensor(576)])
  call ol_merge_tensors(T0sum(275),[G0tensor(583)])
  call ol_merge_tensors(T0sum(276),[G0tensor(451)])
  call ol_merge_tensors(T0sum(277),[G0tensor(586)])
  call ol_merge_tensors(T0sum(278),[G0tensor(588)])
  call ol_merge_tensors(T0sum(279),[G0tensor(593)])
  call ol_merge_tensors(T0sum(280),[G0tensor(521)])
  call ol_merge_tensors(T0sum(281),[G0tensor(596)])
  call ol_merge_tensors(T0sum(282),[G0tensor(598)])
  call ol_merge_tensors(T0sum(283),[G0tensor(608)])
  call ol_merge_tensors(T0sum(284),[G0tensor(357)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_39,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_50,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_46,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_46,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_39,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 27 ],masses2_39,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 27 ],masses2_50,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 27 ],masses2_46,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 2, 3, 11 ],masses2_39,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 17, 19, 23 ],masses2_39,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 16, 17, 23 ],masses2_46,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 17, 19 ],masses2_46,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 1, 3, 7 ],masses2_39,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 17, 19, 27 ],masses2_39,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 16, 17, 27 ],masses2_46,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 1, 3, 11 ],masses2_39,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 20, 21, 23 ],masses2_46,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 16, 21, 23 ],masses2_46,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 16, 20, 23 ],masses2_50,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 16, 20, 21 ],masses2_48,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 4, 5, 7 ],masses2_46,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 20, 22, 23 ],masses2_46,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 16, 22, 23 ],masses2_46,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 16, 20, 22 ],masses2_48,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 4, 6, 7 ],masses2_46,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 18, 26, 27 ],masses2_36,RedSet_4(26),ScalarBoxes(26))
  call compute_scalar_box([ 16, 26, 27 ],masses2_46,RedSet_4(27),ScalarBoxes(27))
  call compute_scalar_box([ 16, 18, 26 ],masses2_45,RedSet_4(28),ScalarBoxes(28))
  call compute_scalar_box([ 2, 10, 11 ],masses2_36,RedSet_4(29),ScalarBoxes(29))
  call compute_scalar_box([ 17, 25, 27 ],masses2_36,RedSet_4(30),ScalarBoxes(30))
  call compute_scalar_box([ 16, 25, 27 ],masses2_46,RedSet_4(31),ScalarBoxes(31))
  call compute_scalar_box([ 16, 17, 25 ],masses2_45,RedSet_4(32),ScalarBoxes(32))
  call compute_scalar_box([ 1, 9, 11 ],masses2_36,RedSet_4(33),ScalarBoxes(33))
  call compute_scalar_box([ 18, 22, 23 ],masses2_51,RedSet_4(34),ScalarBoxes(34))
  call compute_scalar_box([ 16, 22, 23 ],masses2_40,RedSet_4(23),ScalarBoxes(35))
  call compute_scalar_box([ 16, 18, 23 ],masses2_40,RedSet_4(3),ScalarBoxes(36))
  call compute_scalar_box([ 16, 18, 22 ],masses2_41,RedSet_4(35),ScalarBoxes(37))
  call compute_scalar_box([ 2, 6, 7 ],masses2_51,RedSet_4(36),ScalarBoxes(38))
  call compute_scalar_box([ 18, 22, 23 ],masses2_47,RedSet_4(34),ScalarBoxes(39))
  call compute_scalar_box([ 16, 22, 23 ],masses2_37,RedSet_4(23),ScalarBoxes(40))
  call compute_scalar_box([ 16, 18, 23 ],masses2_37,RedSet_4(3),ScalarBoxes(41))
  call compute_scalar_box([ 16, 18, 22 ],masses2_38,RedSet_4(35),ScalarBoxes(42))
  call compute_scalar_box([ 2, 6, 7 ],masses2_47,RedSet_4(36),ScalarBoxes(43))
  call compute_scalar_box([ 17, 21, 23 ],masses2_51,RedSet_4(37),ScalarBoxes(44))
  call compute_scalar_box([ 16, 21, 23 ],masses2_40,RedSet_4(18),ScalarBoxes(45))
  call compute_scalar_box([ 16, 17, 23 ],masses2_40,RedSet_4(11),ScalarBoxes(46))
  call compute_scalar_box([ 16, 17, 21 ],masses2_41,RedSet_4(38),ScalarBoxes(47))
  call compute_scalar_box([ 1, 5, 7 ],masses2_51,RedSet_4(39),ScalarBoxes(48))
  call compute_scalar_box([ 17, 21, 23 ],masses2_47,RedSet_4(37),ScalarBoxes(49))
  call compute_scalar_box([ 16, 21, 23 ],masses2_37,RedSet_4(18),ScalarBoxes(50))
  call compute_scalar_box([ 16, 17, 23 ],masses2_37,RedSet_4(11),ScalarBoxes(51))
  call compute_scalar_box([ 16, 17, 21 ],masses2_38,RedSet_4(38),ScalarBoxes(52))
  call compute_scalar_box([ 1, 5, 7 ],masses2_47,RedSet_4(39),ScalarBoxes(53))
  call compute_scalar_box([ 17, 21, 29 ],masses2_49,RedSet_4(40),ScalarBoxes(54))
  call compute_scalar_box([ 16, 21, 29 ],masses2_38,RedSet_4(41),ScalarBoxes(55))
  call compute_scalar_box([ 16, 17, 29 ],masses2_38,RedSet_4(42),ScalarBoxes(56))
  call compute_scalar_box([ 1, 5, 13 ],masses2_49,RedSet_4(43),ScalarBoxes(57))
  call compute_scalar_box([ 17, 25, 29 ],masses2_49,RedSet_4(44),ScalarBoxes(58))
  call compute_scalar_box([ 16, 25, 29 ],masses2_38,RedSet_4(45),ScalarBoxes(59))
  call compute_scalar_box([ 16, 17, 25 ],masses2_38,RedSet_4(32),ScalarBoxes(60))
  call compute_scalar_box([ 1, 9, 13 ],masses2_49,RedSet_4(46),ScalarBoxes(61))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphvv_ew_uuxhaz_1_/**/REALKIND
